// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AddCustomRoutingEndpoints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddCustomRoutingEndpointsError {
    /// Kind of error that occurred.
    pub kind: AddCustomRoutingEndpointsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddCustomRoutingEndpoints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddCustomRoutingEndpointsErrorKind {
    /// <p>You don't have access permission.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You can't use both of those options.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The endpoint that you specified doesn't exist.</p>
    EndpointAlreadyExistsException(crate::error::EndpointAlreadyExistsException),
    /// <p>The endpoint group that you specified doesn't exist.</p>
    EndpointGroupNotFoundException(crate::error::EndpointGroupNotFoundException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>Processing your request would cause you to exceed an AWS Global Accelerator limit.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddCustomRoutingEndpointsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddCustomRoutingEndpointsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AddCustomRoutingEndpointsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            AddCustomRoutingEndpointsErrorKind::EndpointAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            AddCustomRoutingEndpointsErrorKind::EndpointGroupNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AddCustomRoutingEndpointsErrorKind::InternalServiceErrorException(_inner) => {
                _inner.fmt(f)
            }
            AddCustomRoutingEndpointsErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            AddCustomRoutingEndpointsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            AddCustomRoutingEndpointsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddCustomRoutingEndpointsError {
    fn code(&self) -> Option<&str> {
        AddCustomRoutingEndpointsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddCustomRoutingEndpointsError {
    /// Creates a new `AddCustomRoutingEndpointsError`.
    pub fn new(kind: AddCustomRoutingEndpointsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddCustomRoutingEndpointsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddCustomRoutingEndpointsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddCustomRoutingEndpointsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddCustomRoutingEndpointsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AddCustomRoutingEndpointsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddCustomRoutingEndpointsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `AddCustomRoutingEndpointsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddCustomRoutingEndpointsErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `AddCustomRoutingEndpointsErrorKind::EndpointAlreadyExistsException`.
    pub fn is_endpoint_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddCustomRoutingEndpointsErrorKind::EndpointAlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `AddCustomRoutingEndpointsErrorKind::EndpointGroupNotFoundException`.
    pub fn is_endpoint_group_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddCustomRoutingEndpointsErrorKind::EndpointGroupNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `AddCustomRoutingEndpointsErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddCustomRoutingEndpointsErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `AddCustomRoutingEndpointsErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddCustomRoutingEndpointsErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns true if the error kind is `AddCustomRoutingEndpointsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddCustomRoutingEndpointsErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for AddCustomRoutingEndpointsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddCustomRoutingEndpointsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AddCustomRoutingEndpointsErrorKind::ConflictException(_inner) => Some(_inner),
            AddCustomRoutingEndpointsErrorKind::EndpointAlreadyExistsException(_inner) => {
                Some(_inner)
            }
            AddCustomRoutingEndpointsErrorKind::EndpointGroupNotFoundException(_inner) => {
                Some(_inner)
            }
            AddCustomRoutingEndpointsErrorKind::InternalServiceErrorException(_inner) => {
                Some(_inner)
            }
            AddCustomRoutingEndpointsErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            AddCustomRoutingEndpointsErrorKind::LimitExceededException(_inner) => Some(_inner),
            AddCustomRoutingEndpointsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AdvertiseByoipCidr` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AdvertiseByoipCidrError {
    /// Kind of error that occurred.
    pub kind: AdvertiseByoipCidrErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AdvertiseByoipCidr` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AdvertiseByoipCidrErrorKind {
    /// <p>You don't have access permission.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The CIDR that you specified was not found or is incorrect.</p>
    ByoipCidrNotFoundException(crate::error::ByoipCidrNotFoundException),
    /// <p>The CIDR that you specified is not valid for this action. For example, the state of the CIDR might be
    /// incorrect for this action.</p>
    IncorrectCidrStateException(crate::error::IncorrectCidrStateException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AdvertiseByoipCidrError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AdvertiseByoipCidrErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AdvertiseByoipCidrErrorKind::ByoipCidrNotFoundException(_inner) => _inner.fmt(f),
            AdvertiseByoipCidrErrorKind::IncorrectCidrStateException(_inner) => _inner.fmt(f),
            AdvertiseByoipCidrErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            AdvertiseByoipCidrErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            AdvertiseByoipCidrErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AdvertiseByoipCidrError {
    fn code(&self) -> Option<&str> {
        AdvertiseByoipCidrError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AdvertiseByoipCidrError {
    /// Creates a new `AdvertiseByoipCidrError`.
    pub fn new(kind: AdvertiseByoipCidrErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AdvertiseByoipCidrError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AdvertiseByoipCidrErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AdvertiseByoipCidrError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AdvertiseByoipCidrErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AdvertiseByoipCidrErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdvertiseByoipCidrErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `AdvertiseByoipCidrErrorKind::ByoipCidrNotFoundException`.
    pub fn is_byoip_cidr_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdvertiseByoipCidrErrorKind::ByoipCidrNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `AdvertiseByoipCidrErrorKind::IncorrectCidrStateException`.
    pub fn is_incorrect_cidr_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdvertiseByoipCidrErrorKind::IncorrectCidrStateException(_)
        )
    }
    /// Returns true if the error kind is `AdvertiseByoipCidrErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdvertiseByoipCidrErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `AdvertiseByoipCidrErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            AdvertiseByoipCidrErrorKind::InvalidArgumentException(_)
        )
    }
}
impl std::error::Error for AdvertiseByoipCidrError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AdvertiseByoipCidrErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AdvertiseByoipCidrErrorKind::ByoipCidrNotFoundException(_inner) => Some(_inner),
            AdvertiseByoipCidrErrorKind::IncorrectCidrStateException(_inner) => Some(_inner),
            AdvertiseByoipCidrErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            AdvertiseByoipCidrErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            AdvertiseByoipCidrErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AllowCustomRoutingTraffic` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AllowCustomRoutingTrafficError {
    /// Kind of error that occurred.
    pub kind: AllowCustomRoutingTrafficErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AllowCustomRoutingTraffic` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AllowCustomRoutingTrafficErrorKind {
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AllowCustomRoutingTrafficError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AllowCustomRoutingTrafficErrorKind::InternalServiceErrorException(_inner) => {
                _inner.fmt(f)
            }
            AllowCustomRoutingTrafficErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            AllowCustomRoutingTrafficErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AllowCustomRoutingTrafficError {
    fn code(&self) -> Option<&str> {
        AllowCustomRoutingTrafficError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AllowCustomRoutingTrafficError {
    /// Creates a new `AllowCustomRoutingTrafficError`.
    pub fn new(kind: AllowCustomRoutingTrafficErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AllowCustomRoutingTrafficError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AllowCustomRoutingTrafficErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AllowCustomRoutingTrafficError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AllowCustomRoutingTrafficErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AllowCustomRoutingTrafficErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AllowCustomRoutingTrafficErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `AllowCustomRoutingTrafficErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            AllowCustomRoutingTrafficErrorKind::InvalidArgumentException(_)
        )
    }
}
impl std::error::Error for AllowCustomRoutingTrafficError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AllowCustomRoutingTrafficErrorKind::InternalServiceErrorException(_inner) => {
                Some(_inner)
            }
            AllowCustomRoutingTrafficErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            AllowCustomRoutingTrafficErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAccelerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAcceleratorError {
    /// Kind of error that occurred.
    pub kind: CreateAcceleratorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAccelerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAcceleratorErrorKind {
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>Processing your request would cause you to exceed an AWS Global Accelerator limit.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAcceleratorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAcceleratorErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            CreateAcceleratorErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            CreateAcceleratorErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateAcceleratorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAcceleratorError {
    fn code(&self) -> Option<&str> {
        CreateAcceleratorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAcceleratorError {
    /// Creates a new `CreateAcceleratorError`.
    pub fn new(kind: CreateAcceleratorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAcceleratorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAcceleratorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAcceleratorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAcceleratorErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateAcceleratorErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAcceleratorErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `CreateAcceleratorErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAcceleratorErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns true if the error kind is `CreateAcceleratorErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAcceleratorErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateAcceleratorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAcceleratorErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            CreateAcceleratorErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            CreateAcceleratorErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateAcceleratorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateCustomRoutingAccelerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateCustomRoutingAcceleratorError {
    /// Kind of error that occurred.
    pub kind: CreateCustomRoutingAcceleratorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCustomRoutingAccelerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateCustomRoutingAcceleratorErrorKind {
    /// <p>You don't have access permission.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>Processing your request would cause you to exceed an AWS Global Accelerator limit.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateCustomRoutingAcceleratorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateCustomRoutingAcceleratorErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateCustomRoutingAcceleratorErrorKind::InternalServiceErrorException(_inner) => {
                _inner.fmt(f)
            }
            CreateCustomRoutingAcceleratorErrorKind::InvalidArgumentException(_inner) => {
                _inner.fmt(f)
            }
            CreateCustomRoutingAcceleratorErrorKind::LimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateCustomRoutingAcceleratorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateCustomRoutingAcceleratorError {
    fn code(&self) -> Option<&str> {
        CreateCustomRoutingAcceleratorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateCustomRoutingAcceleratorError {
    /// Creates a new `CreateCustomRoutingAcceleratorError`.
    pub fn new(
        kind: CreateCustomRoutingAcceleratorErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateCustomRoutingAcceleratorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateCustomRoutingAcceleratorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateCustomRoutingAcceleratorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateCustomRoutingAcceleratorErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateCustomRoutingAcceleratorErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomRoutingAcceleratorErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `CreateCustomRoutingAcceleratorErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomRoutingAcceleratorErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `CreateCustomRoutingAcceleratorErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomRoutingAcceleratorErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns true if the error kind is `CreateCustomRoutingAcceleratorErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomRoutingAcceleratorErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateCustomRoutingAcceleratorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateCustomRoutingAcceleratorErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateCustomRoutingAcceleratorErrorKind::InternalServiceErrorException(_inner) => {
                Some(_inner)
            }
            CreateCustomRoutingAcceleratorErrorKind::InvalidArgumentException(_inner) => {
                Some(_inner)
            }
            CreateCustomRoutingAcceleratorErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateCustomRoutingAcceleratorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateCustomRoutingEndpointGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateCustomRoutingEndpointGroupError {
    /// Kind of error that occurred.
    pub kind: CreateCustomRoutingEndpointGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCustomRoutingEndpointGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateCustomRoutingEndpointGroupErrorKind {
    /// <p>The accelerator that you specified doesn't exist.</p>
    AcceleratorNotFoundException(crate::error::AcceleratorNotFoundException),
    /// <p>You don't have access permission.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The endpoint group that you specified already exists.</p>
    EndpointGroupAlreadyExistsException(crate::error::EndpointGroupAlreadyExistsException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The port numbers that you specified are not valid numbers or are not unique for this accelerator.</p>
    InvalidPortRangeException(crate::error::InvalidPortRangeException),
    /// <p>Processing your request would cause you to exceed an AWS Global Accelerator limit.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The listener that you specified doesn't exist.</p>
    ListenerNotFoundException(crate::error::ListenerNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateCustomRoutingEndpointGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateCustomRoutingEndpointGroupErrorKind::AcceleratorNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CreateCustomRoutingEndpointGroupErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            CreateCustomRoutingEndpointGroupErrorKind::EndpointGroupAlreadyExistsException(
                _inner,
            ) => _inner.fmt(f),
            CreateCustomRoutingEndpointGroupErrorKind::InternalServiceErrorException(_inner) => {
                _inner.fmt(f)
            }
            CreateCustomRoutingEndpointGroupErrorKind::InvalidArgumentException(_inner) => {
                _inner.fmt(f)
            }
            CreateCustomRoutingEndpointGroupErrorKind::InvalidPortRangeException(_inner) => {
                _inner.fmt(f)
            }
            CreateCustomRoutingEndpointGroupErrorKind::LimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateCustomRoutingEndpointGroupErrorKind::ListenerNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CreateCustomRoutingEndpointGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateCustomRoutingEndpointGroupError {
    fn code(&self) -> Option<&str> {
        CreateCustomRoutingEndpointGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateCustomRoutingEndpointGroupError {
    /// Creates a new `CreateCustomRoutingEndpointGroupError`.
    pub fn new(
        kind: CreateCustomRoutingEndpointGroupErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateCustomRoutingEndpointGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateCustomRoutingEndpointGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateCustomRoutingEndpointGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateCustomRoutingEndpointGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateCustomRoutingEndpointGroupErrorKind::AcceleratorNotFoundException`.
    pub fn is_accelerator_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomRoutingEndpointGroupErrorKind::AcceleratorNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateCustomRoutingEndpointGroupErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomRoutingEndpointGroupErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `CreateCustomRoutingEndpointGroupErrorKind::EndpointGroupAlreadyExistsException`.
    pub fn is_endpoint_group_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomRoutingEndpointGroupErrorKind::EndpointGroupAlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `CreateCustomRoutingEndpointGroupErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomRoutingEndpointGroupErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `CreateCustomRoutingEndpointGroupErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomRoutingEndpointGroupErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns true if the error kind is `CreateCustomRoutingEndpointGroupErrorKind::InvalidPortRangeException`.
    pub fn is_invalid_port_range_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomRoutingEndpointGroupErrorKind::InvalidPortRangeException(_)
        )
    }
    /// Returns true if the error kind is `CreateCustomRoutingEndpointGroupErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomRoutingEndpointGroupErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateCustomRoutingEndpointGroupErrorKind::ListenerNotFoundException`.
    pub fn is_listener_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomRoutingEndpointGroupErrorKind::ListenerNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateCustomRoutingEndpointGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateCustomRoutingEndpointGroupErrorKind::AcceleratorNotFoundException(_inner) => {
                Some(_inner)
            }
            CreateCustomRoutingEndpointGroupErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            CreateCustomRoutingEndpointGroupErrorKind::EndpointGroupAlreadyExistsException(
                _inner,
            ) => Some(_inner),
            CreateCustomRoutingEndpointGroupErrorKind::InternalServiceErrorException(_inner) => {
                Some(_inner)
            }
            CreateCustomRoutingEndpointGroupErrorKind::InvalidArgumentException(_inner) => {
                Some(_inner)
            }
            CreateCustomRoutingEndpointGroupErrorKind::InvalidPortRangeException(_inner) => {
                Some(_inner)
            }
            CreateCustomRoutingEndpointGroupErrorKind::LimitExceededException(_inner) => {
                Some(_inner)
            }
            CreateCustomRoutingEndpointGroupErrorKind::ListenerNotFoundException(_inner) => {
                Some(_inner)
            }
            CreateCustomRoutingEndpointGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateCustomRoutingListener` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateCustomRoutingListenerError {
    /// Kind of error that occurred.
    pub kind: CreateCustomRoutingListenerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCustomRoutingListener` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateCustomRoutingListenerErrorKind {
    /// <p>The accelerator that you specified doesn't exist.</p>
    AcceleratorNotFoundException(crate::error::AcceleratorNotFoundException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The port numbers that you specified are not valid numbers or are not unique for this accelerator.</p>
    InvalidPortRangeException(crate::error::InvalidPortRangeException),
    /// <p>Processing your request would cause you to exceed an AWS Global Accelerator limit.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateCustomRoutingListenerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateCustomRoutingListenerErrorKind::AcceleratorNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CreateCustomRoutingListenerErrorKind::InternalServiceErrorException(_inner) => {
                _inner.fmt(f)
            }
            CreateCustomRoutingListenerErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            CreateCustomRoutingListenerErrorKind::InvalidPortRangeException(_inner) => {
                _inner.fmt(f)
            }
            CreateCustomRoutingListenerErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateCustomRoutingListenerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateCustomRoutingListenerError {
    fn code(&self) -> Option<&str> {
        CreateCustomRoutingListenerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateCustomRoutingListenerError {
    /// Creates a new `CreateCustomRoutingListenerError`.
    pub fn new(kind: CreateCustomRoutingListenerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateCustomRoutingListenerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateCustomRoutingListenerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateCustomRoutingListenerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateCustomRoutingListenerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateCustomRoutingListenerErrorKind::AcceleratorNotFoundException`.
    pub fn is_accelerator_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomRoutingListenerErrorKind::AcceleratorNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateCustomRoutingListenerErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomRoutingListenerErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `CreateCustomRoutingListenerErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomRoutingListenerErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns true if the error kind is `CreateCustomRoutingListenerErrorKind::InvalidPortRangeException`.
    pub fn is_invalid_port_range_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomRoutingListenerErrorKind::InvalidPortRangeException(_)
        )
    }
    /// Returns true if the error kind is `CreateCustomRoutingListenerErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomRoutingListenerErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateCustomRoutingListenerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateCustomRoutingListenerErrorKind::AcceleratorNotFoundException(_inner) => {
                Some(_inner)
            }
            CreateCustomRoutingListenerErrorKind::InternalServiceErrorException(_inner) => {
                Some(_inner)
            }
            CreateCustomRoutingListenerErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            CreateCustomRoutingListenerErrorKind::InvalidPortRangeException(_inner) => Some(_inner),
            CreateCustomRoutingListenerErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateCustomRoutingListenerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateEndpointGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateEndpointGroupError {
    /// Kind of error that occurred.
    pub kind: CreateEndpointGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateEndpointGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateEndpointGroupErrorKind {
    /// <p>The accelerator that you specified doesn't exist.</p>
    AcceleratorNotFoundException(crate::error::AcceleratorNotFoundException),
    /// <p>You don't have access permission.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The endpoint group that you specified already exists.</p>
    EndpointGroupAlreadyExistsException(crate::error::EndpointGroupAlreadyExistsException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>Processing your request would cause you to exceed an AWS Global Accelerator limit.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The listener that you specified doesn't exist.</p>
    ListenerNotFoundException(crate::error::ListenerNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateEndpointGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateEndpointGroupErrorKind::AcceleratorNotFoundException(_inner) => _inner.fmt(f),
            CreateEndpointGroupErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateEndpointGroupErrorKind::EndpointGroupAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            CreateEndpointGroupErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            CreateEndpointGroupErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            CreateEndpointGroupErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateEndpointGroupErrorKind::ListenerNotFoundException(_inner) => _inner.fmt(f),
            CreateEndpointGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateEndpointGroupError {
    fn code(&self) -> Option<&str> {
        CreateEndpointGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateEndpointGroupError {
    /// Creates a new `CreateEndpointGroupError`.
    pub fn new(kind: CreateEndpointGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateEndpointGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateEndpointGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateEndpointGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateEndpointGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateEndpointGroupErrorKind::AcceleratorNotFoundException`.
    pub fn is_accelerator_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEndpointGroupErrorKind::AcceleratorNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateEndpointGroupErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEndpointGroupErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `CreateEndpointGroupErrorKind::EndpointGroupAlreadyExistsException`.
    pub fn is_endpoint_group_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEndpointGroupErrorKind::EndpointGroupAlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `CreateEndpointGroupErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEndpointGroupErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `CreateEndpointGroupErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEndpointGroupErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns true if the error kind is `CreateEndpointGroupErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEndpointGroupErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateEndpointGroupErrorKind::ListenerNotFoundException`.
    pub fn is_listener_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEndpointGroupErrorKind::ListenerNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateEndpointGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateEndpointGroupErrorKind::AcceleratorNotFoundException(_inner) => Some(_inner),
            CreateEndpointGroupErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateEndpointGroupErrorKind::EndpointGroupAlreadyExistsException(_inner) => {
                Some(_inner)
            }
            CreateEndpointGroupErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            CreateEndpointGroupErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            CreateEndpointGroupErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateEndpointGroupErrorKind::ListenerNotFoundException(_inner) => Some(_inner),
            CreateEndpointGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateListener` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateListenerError {
    /// Kind of error that occurred.
    pub kind: CreateListenerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateListener` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateListenerErrorKind {
    /// <p>The accelerator that you specified doesn't exist.</p>
    AcceleratorNotFoundException(crate::error::AcceleratorNotFoundException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The port numbers that you specified are not valid numbers or are not unique for this accelerator.</p>
    InvalidPortRangeException(crate::error::InvalidPortRangeException),
    /// <p>Processing your request would cause you to exceed an AWS Global Accelerator limit.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateListenerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateListenerErrorKind::AcceleratorNotFoundException(_inner) => _inner.fmt(f),
            CreateListenerErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            CreateListenerErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            CreateListenerErrorKind::InvalidPortRangeException(_inner) => _inner.fmt(f),
            CreateListenerErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateListenerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateListenerError {
    fn code(&self) -> Option<&str> {
        CreateListenerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateListenerError {
    /// Creates a new `CreateListenerError`.
    pub fn new(kind: CreateListenerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateListenerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateListenerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateListenerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateListenerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateListenerErrorKind::AcceleratorNotFoundException`.
    pub fn is_accelerator_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateListenerErrorKind::AcceleratorNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateListenerErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateListenerErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `CreateListenerErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateListenerErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns true if the error kind is `CreateListenerErrorKind::InvalidPortRangeException`.
    pub fn is_invalid_port_range_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateListenerErrorKind::InvalidPortRangeException(_)
        )
    }
    /// Returns true if the error kind is `CreateListenerErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateListenerErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateListenerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateListenerErrorKind::AcceleratorNotFoundException(_inner) => Some(_inner),
            CreateListenerErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            CreateListenerErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            CreateListenerErrorKind::InvalidPortRangeException(_inner) => Some(_inner),
            CreateListenerErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateListenerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAccelerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAcceleratorError {
    /// Kind of error that occurred.
    pub kind: DeleteAcceleratorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAccelerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAcceleratorErrorKind {
    /// <p>The accelerator that you specified could not be disabled.</p>
    AcceleratorNotDisabledException(crate::error::AcceleratorNotDisabledException),
    /// <p>The accelerator that you specified doesn't exist.</p>
    AcceleratorNotFoundException(crate::error::AcceleratorNotFoundException),
    /// <p>The accelerator that you specified has a listener associated with it. You must remove all dependent resources from an
    /// accelerator before you can delete it.</p>
    AssociatedListenerFoundException(crate::error::AssociatedListenerFoundException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAcceleratorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAcceleratorErrorKind::AcceleratorNotDisabledException(_inner) => _inner.fmt(f),
            DeleteAcceleratorErrorKind::AcceleratorNotFoundException(_inner) => _inner.fmt(f),
            DeleteAcceleratorErrorKind::AssociatedListenerFoundException(_inner) => _inner.fmt(f),
            DeleteAcceleratorErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            DeleteAcceleratorErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            DeleteAcceleratorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAcceleratorError {
    fn code(&self) -> Option<&str> {
        DeleteAcceleratorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAcceleratorError {
    /// Creates a new `DeleteAcceleratorError`.
    pub fn new(kind: DeleteAcceleratorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAcceleratorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAcceleratorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAcceleratorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAcceleratorErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteAcceleratorErrorKind::AcceleratorNotDisabledException`.
    pub fn is_accelerator_not_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAcceleratorErrorKind::AcceleratorNotDisabledException(_)
        )
    }
    /// Returns true if the error kind is `DeleteAcceleratorErrorKind::AcceleratorNotFoundException`.
    pub fn is_accelerator_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAcceleratorErrorKind::AcceleratorNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteAcceleratorErrorKind::AssociatedListenerFoundException`.
    pub fn is_associated_listener_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAcceleratorErrorKind::AssociatedListenerFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteAcceleratorErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAcceleratorErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `DeleteAcceleratorErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAcceleratorErrorKind::InvalidArgumentException(_)
        )
    }
}
impl std::error::Error for DeleteAcceleratorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAcceleratorErrorKind::AcceleratorNotDisabledException(_inner) => Some(_inner),
            DeleteAcceleratorErrorKind::AcceleratorNotFoundException(_inner) => Some(_inner),
            DeleteAcceleratorErrorKind::AssociatedListenerFoundException(_inner) => Some(_inner),
            DeleteAcceleratorErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            DeleteAcceleratorErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            DeleteAcceleratorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCustomRoutingAccelerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteCustomRoutingAcceleratorError {
    /// Kind of error that occurred.
    pub kind: DeleteCustomRoutingAcceleratorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCustomRoutingAccelerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteCustomRoutingAcceleratorErrorKind {
    /// <p>The accelerator that you specified could not be disabled.</p>
    AcceleratorNotDisabledException(crate::error::AcceleratorNotDisabledException),
    /// <p>The accelerator that you specified doesn't exist.</p>
    AcceleratorNotFoundException(crate::error::AcceleratorNotFoundException),
    /// <p>The accelerator that you specified has a listener associated with it. You must remove all dependent resources from an
    /// accelerator before you can delete it.</p>
    AssociatedListenerFoundException(crate::error::AssociatedListenerFoundException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteCustomRoutingAcceleratorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteCustomRoutingAcceleratorErrorKind::AcceleratorNotDisabledException(_inner) => {
                _inner.fmt(f)
            }
            DeleteCustomRoutingAcceleratorErrorKind::AcceleratorNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteCustomRoutingAcceleratorErrorKind::AssociatedListenerFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteCustomRoutingAcceleratorErrorKind::InternalServiceErrorException(_inner) => {
                _inner.fmt(f)
            }
            DeleteCustomRoutingAcceleratorErrorKind::InvalidArgumentException(_inner) => {
                _inner.fmt(f)
            }
            DeleteCustomRoutingAcceleratorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteCustomRoutingAcceleratorError {
    fn code(&self) -> Option<&str> {
        DeleteCustomRoutingAcceleratorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteCustomRoutingAcceleratorError {
    /// Creates a new `DeleteCustomRoutingAcceleratorError`.
    pub fn new(
        kind: DeleteCustomRoutingAcceleratorErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteCustomRoutingAcceleratorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteCustomRoutingAcceleratorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteCustomRoutingAcceleratorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteCustomRoutingAcceleratorErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteCustomRoutingAcceleratorErrorKind::AcceleratorNotDisabledException`.
    pub fn is_accelerator_not_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomRoutingAcceleratorErrorKind::AcceleratorNotDisabledException(_)
        )
    }
    /// Returns true if the error kind is `DeleteCustomRoutingAcceleratorErrorKind::AcceleratorNotFoundException`.
    pub fn is_accelerator_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomRoutingAcceleratorErrorKind::AcceleratorNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteCustomRoutingAcceleratorErrorKind::AssociatedListenerFoundException`.
    pub fn is_associated_listener_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomRoutingAcceleratorErrorKind::AssociatedListenerFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteCustomRoutingAcceleratorErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomRoutingAcceleratorErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `DeleteCustomRoutingAcceleratorErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomRoutingAcceleratorErrorKind::InvalidArgumentException(_)
        )
    }
}
impl std::error::Error for DeleteCustomRoutingAcceleratorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteCustomRoutingAcceleratorErrorKind::AcceleratorNotDisabledException(_inner) => {
                Some(_inner)
            }
            DeleteCustomRoutingAcceleratorErrorKind::AcceleratorNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteCustomRoutingAcceleratorErrorKind::AssociatedListenerFoundException(_inner) => {
                Some(_inner)
            }
            DeleteCustomRoutingAcceleratorErrorKind::InternalServiceErrorException(_inner) => {
                Some(_inner)
            }
            DeleteCustomRoutingAcceleratorErrorKind::InvalidArgumentException(_inner) => {
                Some(_inner)
            }
            DeleteCustomRoutingAcceleratorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCustomRoutingEndpointGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteCustomRoutingEndpointGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteCustomRoutingEndpointGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCustomRoutingEndpointGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteCustomRoutingEndpointGroupErrorKind {
    /// <p>The endpoint group that you specified doesn't exist.</p>
    EndpointGroupNotFoundException(crate::error::EndpointGroupNotFoundException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteCustomRoutingEndpointGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteCustomRoutingEndpointGroupErrorKind::EndpointGroupNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteCustomRoutingEndpointGroupErrorKind::InternalServiceErrorException(_inner) => {
                _inner.fmt(f)
            }
            DeleteCustomRoutingEndpointGroupErrorKind::InvalidArgumentException(_inner) => {
                _inner.fmt(f)
            }
            DeleteCustomRoutingEndpointGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteCustomRoutingEndpointGroupError {
    fn code(&self) -> Option<&str> {
        DeleteCustomRoutingEndpointGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteCustomRoutingEndpointGroupError {
    /// Creates a new `DeleteCustomRoutingEndpointGroupError`.
    pub fn new(
        kind: DeleteCustomRoutingEndpointGroupErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteCustomRoutingEndpointGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteCustomRoutingEndpointGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteCustomRoutingEndpointGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteCustomRoutingEndpointGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteCustomRoutingEndpointGroupErrorKind::EndpointGroupNotFoundException`.
    pub fn is_endpoint_group_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomRoutingEndpointGroupErrorKind::EndpointGroupNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteCustomRoutingEndpointGroupErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomRoutingEndpointGroupErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `DeleteCustomRoutingEndpointGroupErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomRoutingEndpointGroupErrorKind::InvalidArgumentException(_)
        )
    }
}
impl std::error::Error for DeleteCustomRoutingEndpointGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteCustomRoutingEndpointGroupErrorKind::EndpointGroupNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteCustomRoutingEndpointGroupErrorKind::InternalServiceErrorException(_inner) => {
                Some(_inner)
            }
            DeleteCustomRoutingEndpointGroupErrorKind::InvalidArgumentException(_inner) => {
                Some(_inner)
            }
            DeleteCustomRoutingEndpointGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCustomRoutingListener` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteCustomRoutingListenerError {
    /// Kind of error that occurred.
    pub kind: DeleteCustomRoutingListenerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCustomRoutingListener` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteCustomRoutingListenerErrorKind {
    /// <p>The listener that you specified has an endpoint group associated with it. You must remove all dependent resources
    /// from a listener before you can delete it.</p>
    AssociatedEndpointGroupFoundException(crate::error::AssociatedEndpointGroupFoundException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The listener that you specified doesn't exist.</p>
    ListenerNotFoundException(crate::error::ListenerNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteCustomRoutingListenerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteCustomRoutingListenerErrorKind::AssociatedEndpointGroupFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteCustomRoutingListenerErrorKind::InternalServiceErrorException(_inner) => {
                _inner.fmt(f)
            }
            DeleteCustomRoutingListenerErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            DeleteCustomRoutingListenerErrorKind::ListenerNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteCustomRoutingListenerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteCustomRoutingListenerError {
    fn code(&self) -> Option<&str> {
        DeleteCustomRoutingListenerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteCustomRoutingListenerError {
    /// Creates a new `DeleteCustomRoutingListenerError`.
    pub fn new(kind: DeleteCustomRoutingListenerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteCustomRoutingListenerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteCustomRoutingListenerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteCustomRoutingListenerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteCustomRoutingListenerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteCustomRoutingListenerErrorKind::AssociatedEndpointGroupFoundException`.
    pub fn is_associated_endpoint_group_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomRoutingListenerErrorKind::AssociatedEndpointGroupFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteCustomRoutingListenerErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomRoutingListenerErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `DeleteCustomRoutingListenerErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomRoutingListenerErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns true if the error kind is `DeleteCustomRoutingListenerErrorKind::ListenerNotFoundException`.
    pub fn is_listener_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomRoutingListenerErrorKind::ListenerNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteCustomRoutingListenerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteCustomRoutingListenerErrorKind::AssociatedEndpointGroupFoundException(_inner) => {
                Some(_inner)
            }
            DeleteCustomRoutingListenerErrorKind::InternalServiceErrorException(_inner) => {
                Some(_inner)
            }
            DeleteCustomRoutingListenerErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            DeleteCustomRoutingListenerErrorKind::ListenerNotFoundException(_inner) => Some(_inner),
            DeleteCustomRoutingListenerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEndpointGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEndpointGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteEndpointGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEndpointGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEndpointGroupErrorKind {
    /// <p>The endpoint group that you specified doesn't exist.</p>
    EndpointGroupNotFoundException(crate::error::EndpointGroupNotFoundException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEndpointGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEndpointGroupErrorKind::EndpointGroupNotFoundException(_inner) => _inner.fmt(f),
            DeleteEndpointGroupErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            DeleteEndpointGroupErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            DeleteEndpointGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEndpointGroupError {
    fn code(&self) -> Option<&str> {
        DeleteEndpointGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteEndpointGroupError {
    /// Creates a new `DeleteEndpointGroupError`.
    pub fn new(kind: DeleteEndpointGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEndpointGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEndpointGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEndpointGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEndpointGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteEndpointGroupErrorKind::EndpointGroupNotFoundException`.
    pub fn is_endpoint_group_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEndpointGroupErrorKind::EndpointGroupNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteEndpointGroupErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEndpointGroupErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `DeleteEndpointGroupErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEndpointGroupErrorKind::InvalidArgumentException(_)
        )
    }
}
impl std::error::Error for DeleteEndpointGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEndpointGroupErrorKind::EndpointGroupNotFoundException(_inner) => Some(_inner),
            DeleteEndpointGroupErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            DeleteEndpointGroupErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            DeleteEndpointGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteListener` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteListenerError {
    /// Kind of error that occurred.
    pub kind: DeleteListenerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteListener` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteListenerErrorKind {
    /// <p>The listener that you specified has an endpoint group associated with it. You must remove all dependent resources
    /// from a listener before you can delete it.</p>
    AssociatedEndpointGroupFoundException(crate::error::AssociatedEndpointGroupFoundException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The listener that you specified doesn't exist.</p>
    ListenerNotFoundException(crate::error::ListenerNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteListenerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteListenerErrorKind::AssociatedEndpointGroupFoundException(_inner) => _inner.fmt(f),
            DeleteListenerErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            DeleteListenerErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            DeleteListenerErrorKind::ListenerNotFoundException(_inner) => _inner.fmt(f),
            DeleteListenerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteListenerError {
    fn code(&self) -> Option<&str> {
        DeleteListenerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteListenerError {
    /// Creates a new `DeleteListenerError`.
    pub fn new(kind: DeleteListenerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteListenerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteListenerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteListenerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteListenerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteListenerErrorKind::AssociatedEndpointGroupFoundException`.
    pub fn is_associated_endpoint_group_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteListenerErrorKind::AssociatedEndpointGroupFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteListenerErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteListenerErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `DeleteListenerErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteListenerErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns true if the error kind is `DeleteListenerErrorKind::ListenerNotFoundException`.
    pub fn is_listener_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteListenerErrorKind::ListenerNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteListenerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteListenerErrorKind::AssociatedEndpointGroupFoundException(_inner) => Some(_inner),
            DeleteListenerErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            DeleteListenerErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            DeleteListenerErrorKind::ListenerNotFoundException(_inner) => Some(_inner),
            DeleteListenerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DenyCustomRoutingTraffic` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DenyCustomRoutingTrafficError {
    /// Kind of error that occurred.
    pub kind: DenyCustomRoutingTrafficErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DenyCustomRoutingTraffic` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DenyCustomRoutingTrafficErrorKind {
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DenyCustomRoutingTrafficError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DenyCustomRoutingTrafficErrorKind::InternalServiceErrorException(_inner) => {
                _inner.fmt(f)
            }
            DenyCustomRoutingTrafficErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            DenyCustomRoutingTrafficErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DenyCustomRoutingTrafficError {
    fn code(&self) -> Option<&str> {
        DenyCustomRoutingTrafficError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DenyCustomRoutingTrafficError {
    /// Creates a new `DenyCustomRoutingTrafficError`.
    pub fn new(kind: DenyCustomRoutingTrafficErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DenyCustomRoutingTrafficError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DenyCustomRoutingTrafficErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DenyCustomRoutingTrafficError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DenyCustomRoutingTrafficErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DenyCustomRoutingTrafficErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DenyCustomRoutingTrafficErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `DenyCustomRoutingTrafficErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            DenyCustomRoutingTrafficErrorKind::InvalidArgumentException(_)
        )
    }
}
impl std::error::Error for DenyCustomRoutingTrafficError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DenyCustomRoutingTrafficErrorKind::InternalServiceErrorException(_inner) => {
                Some(_inner)
            }
            DenyCustomRoutingTrafficErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            DenyCustomRoutingTrafficErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeprovisionByoipCidr` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeprovisionByoipCidrError {
    /// Kind of error that occurred.
    pub kind: DeprovisionByoipCidrErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeprovisionByoipCidr` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeprovisionByoipCidrErrorKind {
    /// <p>You don't have access permission.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The CIDR that you specified was not found or is incorrect.</p>
    ByoipCidrNotFoundException(crate::error::ByoipCidrNotFoundException),
    /// <p>The CIDR that you specified is not valid for this action. For example, the state of the CIDR might be
    /// incorrect for this action.</p>
    IncorrectCidrStateException(crate::error::IncorrectCidrStateException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeprovisionByoipCidrError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeprovisionByoipCidrErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeprovisionByoipCidrErrorKind::ByoipCidrNotFoundException(_inner) => _inner.fmt(f),
            DeprovisionByoipCidrErrorKind::IncorrectCidrStateException(_inner) => _inner.fmt(f),
            DeprovisionByoipCidrErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            DeprovisionByoipCidrErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            DeprovisionByoipCidrErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeprovisionByoipCidrError {
    fn code(&self) -> Option<&str> {
        DeprovisionByoipCidrError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeprovisionByoipCidrError {
    /// Creates a new `DeprovisionByoipCidrError`.
    pub fn new(kind: DeprovisionByoipCidrErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeprovisionByoipCidrError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeprovisionByoipCidrErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeprovisionByoipCidrError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeprovisionByoipCidrErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeprovisionByoipCidrErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeprovisionByoipCidrErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DeprovisionByoipCidrErrorKind::ByoipCidrNotFoundException`.
    pub fn is_byoip_cidr_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeprovisionByoipCidrErrorKind::ByoipCidrNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeprovisionByoipCidrErrorKind::IncorrectCidrStateException`.
    pub fn is_incorrect_cidr_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeprovisionByoipCidrErrorKind::IncorrectCidrStateException(_)
        )
    }
    /// Returns true if the error kind is `DeprovisionByoipCidrErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeprovisionByoipCidrErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `DeprovisionByoipCidrErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeprovisionByoipCidrErrorKind::InvalidArgumentException(_)
        )
    }
}
impl std::error::Error for DeprovisionByoipCidrError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeprovisionByoipCidrErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeprovisionByoipCidrErrorKind::ByoipCidrNotFoundException(_inner) => Some(_inner),
            DeprovisionByoipCidrErrorKind::IncorrectCidrStateException(_inner) => Some(_inner),
            DeprovisionByoipCidrErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            DeprovisionByoipCidrErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            DeprovisionByoipCidrErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAccelerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAcceleratorError {
    /// Kind of error that occurred.
    pub kind: DescribeAcceleratorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAccelerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAcceleratorErrorKind {
    /// <p>The accelerator that you specified doesn't exist.</p>
    AcceleratorNotFoundException(crate::error::AcceleratorNotFoundException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAcceleratorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAcceleratorErrorKind::AcceleratorNotFoundException(_inner) => _inner.fmt(f),
            DescribeAcceleratorErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            DescribeAcceleratorErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            DescribeAcceleratorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAcceleratorError {
    fn code(&self) -> Option<&str> {
        DescribeAcceleratorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAcceleratorError {
    /// Creates a new `DescribeAcceleratorError`.
    pub fn new(kind: DescribeAcceleratorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAcceleratorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAcceleratorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAcceleratorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAcceleratorErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeAcceleratorErrorKind::AcceleratorNotFoundException`.
    pub fn is_accelerator_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAcceleratorErrorKind::AcceleratorNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeAcceleratorErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAcceleratorErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `DescribeAcceleratorErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAcceleratorErrorKind::InvalidArgumentException(_)
        )
    }
}
impl std::error::Error for DescribeAcceleratorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAcceleratorErrorKind::AcceleratorNotFoundException(_inner) => Some(_inner),
            DescribeAcceleratorErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            DescribeAcceleratorErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            DescribeAcceleratorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAcceleratorAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAcceleratorAttributesError {
    /// Kind of error that occurred.
    pub kind: DescribeAcceleratorAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAcceleratorAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAcceleratorAttributesErrorKind {
    /// <p>The accelerator that you specified doesn't exist.</p>
    AcceleratorNotFoundException(crate::error::AcceleratorNotFoundException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAcceleratorAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAcceleratorAttributesErrorKind::AcceleratorNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAcceleratorAttributesErrorKind::InternalServiceErrorException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAcceleratorAttributesErrorKind::InvalidArgumentException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAcceleratorAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAcceleratorAttributesError {
    fn code(&self) -> Option<&str> {
        DescribeAcceleratorAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAcceleratorAttributesError {
    /// Creates a new `DescribeAcceleratorAttributesError`.
    pub fn new(
        kind: DescribeAcceleratorAttributesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAcceleratorAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAcceleratorAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAcceleratorAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAcceleratorAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeAcceleratorAttributesErrorKind::AcceleratorNotFoundException`.
    pub fn is_accelerator_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAcceleratorAttributesErrorKind::AcceleratorNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeAcceleratorAttributesErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAcceleratorAttributesErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `DescribeAcceleratorAttributesErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAcceleratorAttributesErrorKind::InvalidArgumentException(_)
        )
    }
}
impl std::error::Error for DescribeAcceleratorAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAcceleratorAttributesErrorKind::AcceleratorNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeAcceleratorAttributesErrorKind::InternalServiceErrorException(_inner) => {
                Some(_inner)
            }
            DescribeAcceleratorAttributesErrorKind::InvalidArgumentException(_inner) => {
                Some(_inner)
            }
            DescribeAcceleratorAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeCustomRoutingAccelerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeCustomRoutingAcceleratorError {
    /// Kind of error that occurred.
    pub kind: DescribeCustomRoutingAcceleratorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCustomRoutingAccelerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeCustomRoutingAcceleratorErrorKind {
    /// <p>The accelerator that you specified doesn't exist.</p>
    AcceleratorNotFoundException(crate::error::AcceleratorNotFoundException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeCustomRoutingAcceleratorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeCustomRoutingAcceleratorErrorKind::AcceleratorNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeCustomRoutingAcceleratorErrorKind::InternalServiceErrorException(_inner) => {
                _inner.fmt(f)
            }
            DescribeCustomRoutingAcceleratorErrorKind::InvalidArgumentException(_inner) => {
                _inner.fmt(f)
            }
            DescribeCustomRoutingAcceleratorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeCustomRoutingAcceleratorError {
    fn code(&self) -> Option<&str> {
        DescribeCustomRoutingAcceleratorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeCustomRoutingAcceleratorError {
    /// Creates a new `DescribeCustomRoutingAcceleratorError`.
    pub fn new(
        kind: DescribeCustomRoutingAcceleratorErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeCustomRoutingAcceleratorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeCustomRoutingAcceleratorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeCustomRoutingAcceleratorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeCustomRoutingAcceleratorErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeCustomRoutingAcceleratorErrorKind::AcceleratorNotFoundException`.
    pub fn is_accelerator_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCustomRoutingAcceleratorErrorKind::AcceleratorNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeCustomRoutingAcceleratorErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCustomRoutingAcceleratorErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `DescribeCustomRoutingAcceleratorErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCustomRoutingAcceleratorErrorKind::InvalidArgumentException(_)
        )
    }
}
impl std::error::Error for DescribeCustomRoutingAcceleratorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeCustomRoutingAcceleratorErrorKind::AcceleratorNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeCustomRoutingAcceleratorErrorKind::InternalServiceErrorException(_inner) => {
                Some(_inner)
            }
            DescribeCustomRoutingAcceleratorErrorKind::InvalidArgumentException(_inner) => {
                Some(_inner)
            }
            DescribeCustomRoutingAcceleratorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeCustomRoutingAcceleratorAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeCustomRoutingAcceleratorAttributesError {
    /// Kind of error that occurred.
    pub kind: DescribeCustomRoutingAcceleratorAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCustomRoutingAcceleratorAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeCustomRoutingAcceleratorAttributesErrorKind {
    /// <p>The accelerator that you specified doesn't exist.</p>
    AcceleratorNotFoundException(crate::error::AcceleratorNotFoundException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeCustomRoutingAcceleratorAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeCustomRoutingAcceleratorAttributesErrorKind::AcceleratorNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            DescribeCustomRoutingAcceleratorAttributesErrorKind::InternalServiceErrorException(
                _inner,
            ) => _inner.fmt(f),
            DescribeCustomRoutingAcceleratorAttributesErrorKind::InvalidArgumentException(
                _inner,
            ) => _inner.fmt(f),
            DescribeCustomRoutingAcceleratorAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeCustomRoutingAcceleratorAttributesError {
    fn code(&self) -> Option<&str> {
        DescribeCustomRoutingAcceleratorAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeCustomRoutingAcceleratorAttributesError {
    /// Creates a new `DescribeCustomRoutingAcceleratorAttributesError`.
    pub fn new(
        kind: DescribeCustomRoutingAcceleratorAttributesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeCustomRoutingAcceleratorAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeCustomRoutingAcceleratorAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeCustomRoutingAcceleratorAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeCustomRoutingAcceleratorAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeCustomRoutingAcceleratorAttributesErrorKind::AcceleratorNotFoundException`.
    pub fn is_accelerator_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCustomRoutingAcceleratorAttributesErrorKind::AcceleratorNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeCustomRoutingAcceleratorAttributesErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCustomRoutingAcceleratorAttributesErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `DescribeCustomRoutingAcceleratorAttributesErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCustomRoutingAcceleratorAttributesErrorKind::InvalidArgumentException(_)
        )
    }
}
impl std::error::Error for DescribeCustomRoutingAcceleratorAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeCustomRoutingAcceleratorAttributesErrorKind::AcceleratorNotFoundException(
                _inner,
            ) => Some(_inner),
            DescribeCustomRoutingAcceleratorAttributesErrorKind::InternalServiceErrorException(
                _inner,
            ) => Some(_inner),
            DescribeCustomRoutingAcceleratorAttributesErrorKind::InvalidArgumentException(
                _inner,
            ) => Some(_inner),
            DescribeCustomRoutingAcceleratorAttributesErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeCustomRoutingEndpointGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeCustomRoutingEndpointGroupError {
    /// Kind of error that occurred.
    pub kind: DescribeCustomRoutingEndpointGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCustomRoutingEndpointGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeCustomRoutingEndpointGroupErrorKind {
    /// <p>The endpoint group that you specified doesn't exist.</p>
    EndpointGroupNotFoundException(crate::error::EndpointGroupNotFoundException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeCustomRoutingEndpointGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeCustomRoutingEndpointGroupErrorKind::EndpointGroupNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeCustomRoutingEndpointGroupErrorKind::InternalServiceErrorException(_inner) => {
                _inner.fmt(f)
            }
            DescribeCustomRoutingEndpointGroupErrorKind::InvalidArgumentException(_inner) => {
                _inner.fmt(f)
            }
            DescribeCustomRoutingEndpointGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeCustomRoutingEndpointGroupError {
    fn code(&self) -> Option<&str> {
        DescribeCustomRoutingEndpointGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeCustomRoutingEndpointGroupError {
    /// Creates a new `DescribeCustomRoutingEndpointGroupError`.
    pub fn new(
        kind: DescribeCustomRoutingEndpointGroupErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeCustomRoutingEndpointGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeCustomRoutingEndpointGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeCustomRoutingEndpointGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeCustomRoutingEndpointGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeCustomRoutingEndpointGroupErrorKind::EndpointGroupNotFoundException`.
    pub fn is_endpoint_group_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCustomRoutingEndpointGroupErrorKind::EndpointGroupNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeCustomRoutingEndpointGroupErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCustomRoutingEndpointGroupErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `DescribeCustomRoutingEndpointGroupErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCustomRoutingEndpointGroupErrorKind::InvalidArgumentException(_)
        )
    }
}
impl std::error::Error for DescribeCustomRoutingEndpointGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeCustomRoutingEndpointGroupErrorKind::EndpointGroupNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeCustomRoutingEndpointGroupErrorKind::InternalServiceErrorException(_inner) => {
                Some(_inner)
            }
            DescribeCustomRoutingEndpointGroupErrorKind::InvalidArgumentException(_inner) => {
                Some(_inner)
            }
            DescribeCustomRoutingEndpointGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeCustomRoutingListener` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeCustomRoutingListenerError {
    /// Kind of error that occurred.
    pub kind: DescribeCustomRoutingListenerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCustomRoutingListener` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeCustomRoutingListenerErrorKind {
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The listener that you specified doesn't exist.</p>
    ListenerNotFoundException(crate::error::ListenerNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeCustomRoutingListenerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeCustomRoutingListenerErrorKind::InternalServiceErrorException(_inner) => {
                _inner.fmt(f)
            }
            DescribeCustomRoutingListenerErrorKind::InvalidArgumentException(_inner) => {
                _inner.fmt(f)
            }
            DescribeCustomRoutingListenerErrorKind::ListenerNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeCustomRoutingListenerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeCustomRoutingListenerError {
    fn code(&self) -> Option<&str> {
        DescribeCustomRoutingListenerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeCustomRoutingListenerError {
    /// Creates a new `DescribeCustomRoutingListenerError`.
    pub fn new(
        kind: DescribeCustomRoutingListenerErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeCustomRoutingListenerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeCustomRoutingListenerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeCustomRoutingListenerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeCustomRoutingListenerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeCustomRoutingListenerErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCustomRoutingListenerErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `DescribeCustomRoutingListenerErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCustomRoutingListenerErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns true if the error kind is `DescribeCustomRoutingListenerErrorKind::ListenerNotFoundException`.
    pub fn is_listener_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCustomRoutingListenerErrorKind::ListenerNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeCustomRoutingListenerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeCustomRoutingListenerErrorKind::InternalServiceErrorException(_inner) => {
                Some(_inner)
            }
            DescribeCustomRoutingListenerErrorKind::InvalidArgumentException(_inner) => {
                Some(_inner)
            }
            DescribeCustomRoutingListenerErrorKind::ListenerNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeCustomRoutingListenerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEndpointGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEndpointGroupError {
    /// Kind of error that occurred.
    pub kind: DescribeEndpointGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEndpointGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEndpointGroupErrorKind {
    /// <p>The endpoint group that you specified doesn't exist.</p>
    EndpointGroupNotFoundException(crate::error::EndpointGroupNotFoundException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEndpointGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEndpointGroupErrorKind::EndpointGroupNotFoundException(_inner) => _inner.fmt(f),
            DescribeEndpointGroupErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            DescribeEndpointGroupErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            DescribeEndpointGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEndpointGroupError {
    fn code(&self) -> Option<&str> {
        DescribeEndpointGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEndpointGroupError {
    /// Creates a new `DescribeEndpointGroupError`.
    pub fn new(kind: DescribeEndpointGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEndpointGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEndpointGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEndpointGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEndpointGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeEndpointGroupErrorKind::EndpointGroupNotFoundException`.
    pub fn is_endpoint_group_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEndpointGroupErrorKind::EndpointGroupNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeEndpointGroupErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEndpointGroupErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `DescribeEndpointGroupErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEndpointGroupErrorKind::InvalidArgumentException(_)
        )
    }
}
impl std::error::Error for DescribeEndpointGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEndpointGroupErrorKind::EndpointGroupNotFoundException(_inner) => Some(_inner),
            DescribeEndpointGroupErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            DescribeEndpointGroupErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            DescribeEndpointGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeListener` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeListenerError {
    /// Kind of error that occurred.
    pub kind: DescribeListenerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeListener` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeListenerErrorKind {
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The listener that you specified doesn't exist.</p>
    ListenerNotFoundException(crate::error::ListenerNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeListenerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeListenerErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            DescribeListenerErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            DescribeListenerErrorKind::ListenerNotFoundException(_inner) => _inner.fmt(f),
            DescribeListenerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeListenerError {
    fn code(&self) -> Option<&str> {
        DescribeListenerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeListenerError {
    /// Creates a new `DescribeListenerError`.
    pub fn new(kind: DescribeListenerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeListenerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeListenerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeListenerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeListenerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeListenerErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeListenerErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `DescribeListenerErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeListenerErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns true if the error kind is `DescribeListenerErrorKind::ListenerNotFoundException`.
    pub fn is_listener_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeListenerErrorKind::ListenerNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeListenerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeListenerErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            DescribeListenerErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            DescribeListenerErrorKind::ListenerNotFoundException(_inner) => Some(_inner),
            DescribeListenerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAccelerators` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAcceleratorsError {
    /// Kind of error that occurred.
    pub kind: ListAcceleratorsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAccelerators` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAcceleratorsErrorKind {
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>There isn't another item to return.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAcceleratorsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAcceleratorsErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            ListAcceleratorsErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            ListAcceleratorsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListAcceleratorsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAcceleratorsError {
    fn code(&self) -> Option<&str> {
        ListAcceleratorsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAcceleratorsError {
    /// Creates a new `ListAcceleratorsError`.
    pub fn new(kind: ListAcceleratorsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAcceleratorsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAcceleratorsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAcceleratorsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAcceleratorsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListAcceleratorsErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAcceleratorsErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListAcceleratorsErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAcceleratorsErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns true if the error kind is `ListAcceleratorsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAcceleratorsErrorKind::InvalidNextTokenException(_)
        )
    }
}
impl std::error::Error for ListAcceleratorsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAcceleratorsErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            ListAcceleratorsErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            ListAcceleratorsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListAcceleratorsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListByoipCidrs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListByoipCidrsError {
    /// Kind of error that occurred.
    pub kind: ListByoipCidrsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListByoipCidrs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListByoipCidrsErrorKind {
    /// <p>You don't have access permission.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>There isn't another item to return.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListByoipCidrsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListByoipCidrsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListByoipCidrsErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            ListByoipCidrsErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            ListByoipCidrsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListByoipCidrsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListByoipCidrsError {
    fn code(&self) -> Option<&str> {
        ListByoipCidrsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListByoipCidrsError {
    /// Creates a new `ListByoipCidrsError`.
    pub fn new(kind: ListByoipCidrsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListByoipCidrsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListByoipCidrsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListByoipCidrsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListByoipCidrsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListByoipCidrsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListByoipCidrsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListByoipCidrsErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListByoipCidrsErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListByoipCidrsErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListByoipCidrsErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns true if the error kind is `ListByoipCidrsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListByoipCidrsErrorKind::InvalidNextTokenException(_)
        )
    }
}
impl std::error::Error for ListByoipCidrsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListByoipCidrsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListByoipCidrsErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            ListByoipCidrsErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            ListByoipCidrsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListByoipCidrsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCustomRoutingAccelerators` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCustomRoutingAcceleratorsError {
    /// Kind of error that occurred.
    pub kind: ListCustomRoutingAcceleratorsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCustomRoutingAccelerators` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCustomRoutingAcceleratorsErrorKind {
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>There isn't another item to return.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCustomRoutingAcceleratorsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCustomRoutingAcceleratorsErrorKind::InternalServiceErrorException(_inner) => {
                _inner.fmt(f)
            }
            ListCustomRoutingAcceleratorsErrorKind::InvalidArgumentException(_inner) => {
                _inner.fmt(f)
            }
            ListCustomRoutingAcceleratorsErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            ListCustomRoutingAcceleratorsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCustomRoutingAcceleratorsError {
    fn code(&self) -> Option<&str> {
        ListCustomRoutingAcceleratorsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCustomRoutingAcceleratorsError {
    /// Creates a new `ListCustomRoutingAcceleratorsError`.
    pub fn new(
        kind: ListCustomRoutingAcceleratorsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCustomRoutingAcceleratorsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCustomRoutingAcceleratorsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCustomRoutingAcceleratorsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCustomRoutingAcceleratorsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListCustomRoutingAcceleratorsErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomRoutingAcceleratorsErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListCustomRoutingAcceleratorsErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomRoutingAcceleratorsErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns true if the error kind is `ListCustomRoutingAcceleratorsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomRoutingAcceleratorsErrorKind::InvalidNextTokenException(_)
        )
    }
}
impl std::error::Error for ListCustomRoutingAcceleratorsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCustomRoutingAcceleratorsErrorKind::InternalServiceErrorException(_inner) => {
                Some(_inner)
            }
            ListCustomRoutingAcceleratorsErrorKind::InvalidArgumentException(_inner) => {
                Some(_inner)
            }
            ListCustomRoutingAcceleratorsErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            ListCustomRoutingAcceleratorsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCustomRoutingEndpointGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCustomRoutingEndpointGroupsError {
    /// Kind of error that occurred.
    pub kind: ListCustomRoutingEndpointGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCustomRoutingEndpointGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCustomRoutingEndpointGroupsErrorKind {
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>There isn't another item to return.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>The listener that you specified doesn't exist.</p>
    ListenerNotFoundException(crate::error::ListenerNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCustomRoutingEndpointGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCustomRoutingEndpointGroupsErrorKind::InternalServiceErrorException(_inner) => {
                _inner.fmt(f)
            }
            ListCustomRoutingEndpointGroupsErrorKind::InvalidArgumentException(_inner) => {
                _inner.fmt(f)
            }
            ListCustomRoutingEndpointGroupsErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            ListCustomRoutingEndpointGroupsErrorKind::ListenerNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListCustomRoutingEndpointGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCustomRoutingEndpointGroupsError {
    fn code(&self) -> Option<&str> {
        ListCustomRoutingEndpointGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCustomRoutingEndpointGroupsError {
    /// Creates a new `ListCustomRoutingEndpointGroupsError`.
    pub fn new(
        kind: ListCustomRoutingEndpointGroupsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCustomRoutingEndpointGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCustomRoutingEndpointGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCustomRoutingEndpointGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCustomRoutingEndpointGroupsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListCustomRoutingEndpointGroupsErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomRoutingEndpointGroupsErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListCustomRoutingEndpointGroupsErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomRoutingEndpointGroupsErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns true if the error kind is `ListCustomRoutingEndpointGroupsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomRoutingEndpointGroupsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns true if the error kind is `ListCustomRoutingEndpointGroupsErrorKind::ListenerNotFoundException`.
    pub fn is_listener_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomRoutingEndpointGroupsErrorKind::ListenerNotFoundException(_)
        )
    }
}
impl std::error::Error for ListCustomRoutingEndpointGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCustomRoutingEndpointGroupsErrorKind::InternalServiceErrorException(_inner) => {
                Some(_inner)
            }
            ListCustomRoutingEndpointGroupsErrorKind::InvalidArgumentException(_inner) => {
                Some(_inner)
            }
            ListCustomRoutingEndpointGroupsErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            ListCustomRoutingEndpointGroupsErrorKind::ListenerNotFoundException(_inner) => {
                Some(_inner)
            }
            ListCustomRoutingEndpointGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCustomRoutingListeners` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCustomRoutingListenersError {
    /// Kind of error that occurred.
    pub kind: ListCustomRoutingListenersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCustomRoutingListeners` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCustomRoutingListenersErrorKind {
    /// <p>The accelerator that you specified doesn't exist.</p>
    AcceleratorNotFoundException(crate::error::AcceleratorNotFoundException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>There isn't another item to return.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCustomRoutingListenersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCustomRoutingListenersErrorKind::AcceleratorNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListCustomRoutingListenersErrorKind::InternalServiceErrorException(_inner) => {
                _inner.fmt(f)
            }
            ListCustomRoutingListenersErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            ListCustomRoutingListenersErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListCustomRoutingListenersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCustomRoutingListenersError {
    fn code(&self) -> Option<&str> {
        ListCustomRoutingListenersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCustomRoutingListenersError {
    /// Creates a new `ListCustomRoutingListenersError`.
    pub fn new(kind: ListCustomRoutingListenersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCustomRoutingListenersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCustomRoutingListenersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCustomRoutingListenersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCustomRoutingListenersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListCustomRoutingListenersErrorKind::AcceleratorNotFoundException`.
    pub fn is_accelerator_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomRoutingListenersErrorKind::AcceleratorNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListCustomRoutingListenersErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomRoutingListenersErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListCustomRoutingListenersErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomRoutingListenersErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns true if the error kind is `ListCustomRoutingListenersErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomRoutingListenersErrorKind::InvalidNextTokenException(_)
        )
    }
}
impl std::error::Error for ListCustomRoutingListenersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCustomRoutingListenersErrorKind::AcceleratorNotFoundException(_inner) => {
                Some(_inner)
            }
            ListCustomRoutingListenersErrorKind::InternalServiceErrorException(_inner) => {
                Some(_inner)
            }
            ListCustomRoutingListenersErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            ListCustomRoutingListenersErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListCustomRoutingListenersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCustomRoutingPortMappings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCustomRoutingPortMappingsError {
    /// Kind of error that occurred.
    pub kind: ListCustomRoutingPortMappingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCustomRoutingPortMappings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCustomRoutingPortMappingsErrorKind {
    /// <p>The accelerator that you specified doesn't exist.</p>
    AcceleratorNotFoundException(crate::error::AcceleratorNotFoundException),
    /// <p>The endpoint group that you specified doesn't exist.</p>
    EndpointGroupNotFoundException(crate::error::EndpointGroupNotFoundException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>There isn't another item to return.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCustomRoutingPortMappingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCustomRoutingPortMappingsErrorKind::AcceleratorNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListCustomRoutingPortMappingsErrorKind::EndpointGroupNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListCustomRoutingPortMappingsErrorKind::InternalServiceErrorException(_inner) => {
                _inner.fmt(f)
            }
            ListCustomRoutingPortMappingsErrorKind::InvalidArgumentException(_inner) => {
                _inner.fmt(f)
            }
            ListCustomRoutingPortMappingsErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            ListCustomRoutingPortMappingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCustomRoutingPortMappingsError {
    fn code(&self) -> Option<&str> {
        ListCustomRoutingPortMappingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCustomRoutingPortMappingsError {
    /// Creates a new `ListCustomRoutingPortMappingsError`.
    pub fn new(
        kind: ListCustomRoutingPortMappingsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCustomRoutingPortMappingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCustomRoutingPortMappingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCustomRoutingPortMappingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCustomRoutingPortMappingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListCustomRoutingPortMappingsErrorKind::AcceleratorNotFoundException`.
    pub fn is_accelerator_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomRoutingPortMappingsErrorKind::AcceleratorNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListCustomRoutingPortMappingsErrorKind::EndpointGroupNotFoundException`.
    pub fn is_endpoint_group_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomRoutingPortMappingsErrorKind::EndpointGroupNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListCustomRoutingPortMappingsErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomRoutingPortMappingsErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListCustomRoutingPortMappingsErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomRoutingPortMappingsErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns true if the error kind is `ListCustomRoutingPortMappingsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomRoutingPortMappingsErrorKind::InvalidNextTokenException(_)
        )
    }
}
impl std::error::Error for ListCustomRoutingPortMappingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCustomRoutingPortMappingsErrorKind::AcceleratorNotFoundException(_inner) => {
                Some(_inner)
            }
            ListCustomRoutingPortMappingsErrorKind::EndpointGroupNotFoundException(_inner) => {
                Some(_inner)
            }
            ListCustomRoutingPortMappingsErrorKind::InternalServiceErrorException(_inner) => {
                Some(_inner)
            }
            ListCustomRoutingPortMappingsErrorKind::InvalidArgumentException(_inner) => {
                Some(_inner)
            }
            ListCustomRoutingPortMappingsErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            ListCustomRoutingPortMappingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCustomRoutingPortMappingsByDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCustomRoutingPortMappingsByDestinationError {
    /// Kind of error that occurred.
    pub kind: ListCustomRoutingPortMappingsByDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCustomRoutingPortMappingsByDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCustomRoutingPortMappingsByDestinationErrorKind {
    /// <p>The endpoint that you specified doesn't exist.</p>
    EndpointNotFoundException(crate::error::EndpointNotFoundException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>There isn't another item to return.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCustomRoutingPortMappingsByDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCustomRoutingPortMappingsByDestinationErrorKind::EndpointNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            ListCustomRoutingPortMappingsByDestinationErrorKind::InternalServiceErrorException(
                _inner,
            ) => _inner.fmt(f),
            ListCustomRoutingPortMappingsByDestinationErrorKind::InvalidArgumentException(
                _inner,
            ) => _inner.fmt(f),
            ListCustomRoutingPortMappingsByDestinationErrorKind::InvalidNextTokenException(
                _inner,
            ) => _inner.fmt(f),
            ListCustomRoutingPortMappingsByDestinationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCustomRoutingPortMappingsByDestinationError {
    fn code(&self) -> Option<&str> {
        ListCustomRoutingPortMappingsByDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCustomRoutingPortMappingsByDestinationError {
    /// Creates a new `ListCustomRoutingPortMappingsByDestinationError`.
    pub fn new(
        kind: ListCustomRoutingPortMappingsByDestinationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCustomRoutingPortMappingsByDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCustomRoutingPortMappingsByDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCustomRoutingPortMappingsByDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCustomRoutingPortMappingsByDestinationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListCustomRoutingPortMappingsByDestinationErrorKind::EndpointNotFoundException`.
    pub fn is_endpoint_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomRoutingPortMappingsByDestinationErrorKind::EndpointNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListCustomRoutingPortMappingsByDestinationErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomRoutingPortMappingsByDestinationErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListCustomRoutingPortMappingsByDestinationErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomRoutingPortMappingsByDestinationErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns true if the error kind is `ListCustomRoutingPortMappingsByDestinationErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomRoutingPortMappingsByDestinationErrorKind::InvalidNextTokenException(_)
        )
    }
}
impl std::error::Error for ListCustomRoutingPortMappingsByDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCustomRoutingPortMappingsByDestinationErrorKind::EndpointNotFoundException(
                _inner,
            ) => Some(_inner),
            ListCustomRoutingPortMappingsByDestinationErrorKind::InternalServiceErrorException(
                _inner,
            ) => Some(_inner),
            ListCustomRoutingPortMappingsByDestinationErrorKind::InvalidArgumentException(
                _inner,
            ) => Some(_inner),
            ListCustomRoutingPortMappingsByDestinationErrorKind::InvalidNextTokenException(
                _inner,
            ) => Some(_inner),
            ListCustomRoutingPortMappingsByDestinationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListEndpointGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEndpointGroupsError {
    /// Kind of error that occurred.
    pub kind: ListEndpointGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEndpointGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEndpointGroupsErrorKind {
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>There isn't another item to return.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>The listener that you specified doesn't exist.</p>
    ListenerNotFoundException(crate::error::ListenerNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEndpointGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEndpointGroupsErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            ListEndpointGroupsErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            ListEndpointGroupsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListEndpointGroupsErrorKind::ListenerNotFoundException(_inner) => _inner.fmt(f),
            ListEndpointGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEndpointGroupsError {
    fn code(&self) -> Option<&str> {
        ListEndpointGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListEndpointGroupsError {
    /// Creates a new `ListEndpointGroupsError`.
    pub fn new(kind: ListEndpointGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEndpointGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEndpointGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEndpointGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEndpointGroupsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListEndpointGroupsErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEndpointGroupsErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListEndpointGroupsErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEndpointGroupsErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns true if the error kind is `ListEndpointGroupsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEndpointGroupsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns true if the error kind is `ListEndpointGroupsErrorKind::ListenerNotFoundException`.
    pub fn is_listener_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEndpointGroupsErrorKind::ListenerNotFoundException(_)
        )
    }
}
impl std::error::Error for ListEndpointGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEndpointGroupsErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            ListEndpointGroupsErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            ListEndpointGroupsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListEndpointGroupsErrorKind::ListenerNotFoundException(_inner) => Some(_inner),
            ListEndpointGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListListeners` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListListenersError {
    /// Kind of error that occurred.
    pub kind: ListListenersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListListeners` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListListenersErrorKind {
    /// <p>The accelerator that you specified doesn't exist.</p>
    AcceleratorNotFoundException(crate::error::AcceleratorNotFoundException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>There isn't another item to return.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListListenersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListListenersErrorKind::AcceleratorNotFoundException(_inner) => _inner.fmt(f),
            ListListenersErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            ListListenersErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            ListListenersErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListListenersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListListenersError {
    fn code(&self) -> Option<&str> {
        ListListenersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListListenersError {
    /// Creates a new `ListListenersError`.
    pub fn new(kind: ListListenersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListListenersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListListenersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListListenersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListListenersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListListenersErrorKind::AcceleratorNotFoundException`.
    pub fn is_accelerator_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListListenersErrorKind::AcceleratorNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListListenersErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListListenersErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListListenersErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListListenersErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns true if the error kind is `ListListenersErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListListenersErrorKind::InvalidNextTokenException(_)
        )
    }
}
impl std::error::Error for ListListenersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListListenersErrorKind::AcceleratorNotFoundException(_inner) => Some(_inner),
            ListListenersErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            ListListenersErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            ListListenersErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListListenersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>The accelerator that you specified doesn't exist.</p>
    AcceleratorNotFoundException(crate::error::AcceleratorNotFoundException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::AcceleratorNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::AcceleratorNotFoundException`.
    pub fn is_accelerator_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::AcceleratorNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidArgumentException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::AcceleratorNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ProvisionByoipCidr` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ProvisionByoipCidrError {
    /// Kind of error that occurred.
    pub kind: ProvisionByoipCidrErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ProvisionByoipCidr` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ProvisionByoipCidrErrorKind {
    /// <p>You don't have access permission.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The CIDR that you specified is not valid for this action. For example, the state of the CIDR might be
    /// incorrect for this action.</p>
    IncorrectCidrStateException(crate::error::IncorrectCidrStateException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>Processing your request would cause you to exceed an AWS Global Accelerator limit.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ProvisionByoipCidrError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ProvisionByoipCidrErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ProvisionByoipCidrErrorKind::IncorrectCidrStateException(_inner) => _inner.fmt(f),
            ProvisionByoipCidrErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            ProvisionByoipCidrErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            ProvisionByoipCidrErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ProvisionByoipCidrErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ProvisionByoipCidrError {
    fn code(&self) -> Option<&str> {
        ProvisionByoipCidrError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ProvisionByoipCidrError {
    /// Creates a new `ProvisionByoipCidrError`.
    pub fn new(kind: ProvisionByoipCidrErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ProvisionByoipCidrError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ProvisionByoipCidrErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ProvisionByoipCidrError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ProvisionByoipCidrErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ProvisionByoipCidrErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ProvisionByoipCidrErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ProvisionByoipCidrErrorKind::IncorrectCidrStateException`.
    pub fn is_incorrect_cidr_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ProvisionByoipCidrErrorKind::IncorrectCidrStateException(_)
        )
    }
    /// Returns true if the error kind is `ProvisionByoipCidrErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ProvisionByoipCidrErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `ProvisionByoipCidrErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ProvisionByoipCidrErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns true if the error kind is `ProvisionByoipCidrErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ProvisionByoipCidrErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for ProvisionByoipCidrError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ProvisionByoipCidrErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ProvisionByoipCidrErrorKind::IncorrectCidrStateException(_inner) => Some(_inner),
            ProvisionByoipCidrErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            ProvisionByoipCidrErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            ProvisionByoipCidrErrorKind::LimitExceededException(_inner) => Some(_inner),
            ProvisionByoipCidrErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveCustomRoutingEndpoints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveCustomRoutingEndpointsError {
    /// Kind of error that occurred.
    pub kind: RemoveCustomRoutingEndpointsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveCustomRoutingEndpoints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveCustomRoutingEndpointsErrorKind {
    /// <p>You don't have access permission.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You can't use both of those options.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The endpoint group that you specified doesn't exist.</p>
    EndpointGroupNotFoundException(crate::error::EndpointGroupNotFoundException),
    /// <p>The endpoint that you specified doesn't exist.</p>
    EndpointNotFoundException(crate::error::EndpointNotFoundException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveCustomRoutingEndpointsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveCustomRoutingEndpointsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            RemoveCustomRoutingEndpointsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            RemoveCustomRoutingEndpointsErrorKind::EndpointGroupNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            RemoveCustomRoutingEndpointsErrorKind::EndpointNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            RemoveCustomRoutingEndpointsErrorKind::InternalServiceErrorException(_inner) => {
                _inner.fmt(f)
            }
            RemoveCustomRoutingEndpointsErrorKind::InvalidArgumentException(_inner) => {
                _inner.fmt(f)
            }
            RemoveCustomRoutingEndpointsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveCustomRoutingEndpointsError {
    fn code(&self) -> Option<&str> {
        RemoveCustomRoutingEndpointsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveCustomRoutingEndpointsError {
    /// Creates a new `RemoveCustomRoutingEndpointsError`.
    pub fn new(kind: RemoveCustomRoutingEndpointsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveCustomRoutingEndpointsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveCustomRoutingEndpointsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveCustomRoutingEndpointsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveCustomRoutingEndpointsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `RemoveCustomRoutingEndpointsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveCustomRoutingEndpointsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `RemoveCustomRoutingEndpointsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveCustomRoutingEndpointsErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `RemoveCustomRoutingEndpointsErrorKind::EndpointGroupNotFoundException`.
    pub fn is_endpoint_group_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveCustomRoutingEndpointsErrorKind::EndpointGroupNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `RemoveCustomRoutingEndpointsErrorKind::EndpointNotFoundException`.
    pub fn is_endpoint_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveCustomRoutingEndpointsErrorKind::EndpointNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `RemoveCustomRoutingEndpointsErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveCustomRoutingEndpointsErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `RemoveCustomRoutingEndpointsErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveCustomRoutingEndpointsErrorKind::InvalidArgumentException(_)
        )
    }
}
impl std::error::Error for RemoveCustomRoutingEndpointsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveCustomRoutingEndpointsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            RemoveCustomRoutingEndpointsErrorKind::ConflictException(_inner) => Some(_inner),
            RemoveCustomRoutingEndpointsErrorKind::EndpointGroupNotFoundException(_inner) => {
                Some(_inner)
            }
            RemoveCustomRoutingEndpointsErrorKind::EndpointNotFoundException(_inner) => {
                Some(_inner)
            }
            RemoveCustomRoutingEndpointsErrorKind::InternalServiceErrorException(_inner) => {
                Some(_inner)
            }
            RemoveCustomRoutingEndpointsErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            RemoveCustomRoutingEndpointsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>The accelerator that you specified doesn't exist.</p>
    AcceleratorNotFoundException(crate::error::AcceleratorNotFoundException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::AcceleratorNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `TagResourceErrorKind::AcceleratorNotFoundException`.
    pub fn is_accelerator_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::AcceleratorNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InvalidArgumentException(_)
        )
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::AcceleratorNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>The accelerator that you specified doesn't exist.</p>
    AcceleratorNotFoundException(crate::error::AcceleratorNotFoundException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::AcceleratorNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::AcceleratorNotFoundException`.
    pub fn is_accelerator_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::AcceleratorNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidArgumentException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::AcceleratorNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAccelerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAcceleratorError {
    /// Kind of error that occurred.
    pub kind: UpdateAcceleratorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAccelerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAcceleratorErrorKind {
    /// <p>The accelerator that you specified doesn't exist.</p>
    AcceleratorNotFoundException(crate::error::AcceleratorNotFoundException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAcceleratorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAcceleratorErrorKind::AcceleratorNotFoundException(_inner) => _inner.fmt(f),
            UpdateAcceleratorErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            UpdateAcceleratorErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            UpdateAcceleratorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAcceleratorError {
    fn code(&self) -> Option<&str> {
        UpdateAcceleratorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAcceleratorError {
    /// Creates a new `UpdateAcceleratorError`.
    pub fn new(kind: UpdateAcceleratorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAcceleratorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAcceleratorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAcceleratorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAcceleratorErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateAcceleratorErrorKind::AcceleratorNotFoundException`.
    pub fn is_accelerator_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAcceleratorErrorKind::AcceleratorNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAcceleratorErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAcceleratorErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAcceleratorErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAcceleratorErrorKind::InvalidArgumentException(_)
        )
    }
}
impl std::error::Error for UpdateAcceleratorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAcceleratorErrorKind::AcceleratorNotFoundException(_inner) => Some(_inner),
            UpdateAcceleratorErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            UpdateAcceleratorErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            UpdateAcceleratorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAcceleratorAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAcceleratorAttributesError {
    /// Kind of error that occurred.
    pub kind: UpdateAcceleratorAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAcceleratorAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAcceleratorAttributesErrorKind {
    /// <p>The accelerator that you specified doesn't exist.</p>
    AcceleratorNotFoundException(crate::error::AcceleratorNotFoundException),
    /// <p>You don't have access permission.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAcceleratorAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAcceleratorAttributesErrorKind::AcceleratorNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateAcceleratorAttributesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateAcceleratorAttributesErrorKind::InternalServiceErrorException(_inner) => {
                _inner.fmt(f)
            }
            UpdateAcceleratorAttributesErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            UpdateAcceleratorAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAcceleratorAttributesError {
    fn code(&self) -> Option<&str> {
        UpdateAcceleratorAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAcceleratorAttributesError {
    /// Creates a new `UpdateAcceleratorAttributesError`.
    pub fn new(kind: UpdateAcceleratorAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAcceleratorAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAcceleratorAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAcceleratorAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAcceleratorAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateAcceleratorAttributesErrorKind::AcceleratorNotFoundException`.
    pub fn is_accelerator_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAcceleratorAttributesErrorKind::AcceleratorNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAcceleratorAttributesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAcceleratorAttributesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAcceleratorAttributesErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAcceleratorAttributesErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAcceleratorAttributesErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAcceleratorAttributesErrorKind::InvalidArgumentException(_)
        )
    }
}
impl std::error::Error for UpdateAcceleratorAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAcceleratorAttributesErrorKind::AcceleratorNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateAcceleratorAttributesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateAcceleratorAttributesErrorKind::InternalServiceErrorException(_inner) => {
                Some(_inner)
            }
            UpdateAcceleratorAttributesErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            UpdateAcceleratorAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateCustomRoutingAccelerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateCustomRoutingAcceleratorError {
    /// Kind of error that occurred.
    pub kind: UpdateCustomRoutingAcceleratorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateCustomRoutingAccelerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateCustomRoutingAcceleratorErrorKind {
    /// <p>The accelerator that you specified doesn't exist.</p>
    AcceleratorNotFoundException(crate::error::AcceleratorNotFoundException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateCustomRoutingAcceleratorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateCustomRoutingAcceleratorErrorKind::AcceleratorNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateCustomRoutingAcceleratorErrorKind::InternalServiceErrorException(_inner) => {
                _inner.fmt(f)
            }
            UpdateCustomRoutingAcceleratorErrorKind::InvalidArgumentException(_inner) => {
                _inner.fmt(f)
            }
            UpdateCustomRoutingAcceleratorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateCustomRoutingAcceleratorError {
    fn code(&self) -> Option<&str> {
        UpdateCustomRoutingAcceleratorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateCustomRoutingAcceleratorError {
    /// Creates a new `UpdateCustomRoutingAcceleratorError`.
    pub fn new(
        kind: UpdateCustomRoutingAcceleratorErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateCustomRoutingAcceleratorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateCustomRoutingAcceleratorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateCustomRoutingAcceleratorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateCustomRoutingAcceleratorErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateCustomRoutingAcceleratorErrorKind::AcceleratorNotFoundException`.
    pub fn is_accelerator_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCustomRoutingAcceleratorErrorKind::AcceleratorNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateCustomRoutingAcceleratorErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCustomRoutingAcceleratorErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `UpdateCustomRoutingAcceleratorErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCustomRoutingAcceleratorErrorKind::InvalidArgumentException(_)
        )
    }
}
impl std::error::Error for UpdateCustomRoutingAcceleratorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateCustomRoutingAcceleratorErrorKind::AcceleratorNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateCustomRoutingAcceleratorErrorKind::InternalServiceErrorException(_inner) => {
                Some(_inner)
            }
            UpdateCustomRoutingAcceleratorErrorKind::InvalidArgumentException(_inner) => {
                Some(_inner)
            }
            UpdateCustomRoutingAcceleratorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateCustomRoutingAcceleratorAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateCustomRoutingAcceleratorAttributesError {
    /// Kind of error that occurred.
    pub kind: UpdateCustomRoutingAcceleratorAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateCustomRoutingAcceleratorAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateCustomRoutingAcceleratorAttributesErrorKind {
    /// <p>The accelerator that you specified doesn't exist.</p>
    AcceleratorNotFoundException(crate::error::AcceleratorNotFoundException),
    /// <p>You don't have access permission.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateCustomRoutingAcceleratorAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateCustomRoutingAcceleratorAttributesErrorKind::AcceleratorNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            UpdateCustomRoutingAcceleratorAttributesErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            UpdateCustomRoutingAcceleratorAttributesErrorKind::InternalServiceErrorException(
                _inner,
            ) => _inner.fmt(f),
            UpdateCustomRoutingAcceleratorAttributesErrorKind::InvalidArgumentException(_inner) => {
                _inner.fmt(f)
            }
            UpdateCustomRoutingAcceleratorAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateCustomRoutingAcceleratorAttributesError {
    fn code(&self) -> Option<&str> {
        UpdateCustomRoutingAcceleratorAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateCustomRoutingAcceleratorAttributesError {
    /// Creates a new `UpdateCustomRoutingAcceleratorAttributesError`.
    pub fn new(
        kind: UpdateCustomRoutingAcceleratorAttributesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateCustomRoutingAcceleratorAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateCustomRoutingAcceleratorAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateCustomRoutingAcceleratorAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateCustomRoutingAcceleratorAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateCustomRoutingAcceleratorAttributesErrorKind::AcceleratorNotFoundException`.
    pub fn is_accelerator_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCustomRoutingAcceleratorAttributesErrorKind::AcceleratorNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateCustomRoutingAcceleratorAttributesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCustomRoutingAcceleratorAttributesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `UpdateCustomRoutingAcceleratorAttributesErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCustomRoutingAcceleratorAttributesErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `UpdateCustomRoutingAcceleratorAttributesErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCustomRoutingAcceleratorAttributesErrorKind::InvalidArgumentException(_)
        )
    }
}
impl std::error::Error for UpdateCustomRoutingAcceleratorAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateCustomRoutingAcceleratorAttributesErrorKind::AcceleratorNotFoundException(
                _inner,
            ) => Some(_inner),
            UpdateCustomRoutingAcceleratorAttributesErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            UpdateCustomRoutingAcceleratorAttributesErrorKind::InternalServiceErrorException(
                _inner,
            ) => Some(_inner),
            UpdateCustomRoutingAcceleratorAttributesErrorKind::InvalidArgumentException(_inner) => {
                Some(_inner)
            }
            UpdateCustomRoutingAcceleratorAttributesErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `UpdateCustomRoutingListener` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateCustomRoutingListenerError {
    /// Kind of error that occurred.
    pub kind: UpdateCustomRoutingListenerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateCustomRoutingListener` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateCustomRoutingListenerErrorKind {
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The port numbers that you specified are not valid numbers or are not unique for this accelerator.</p>
    InvalidPortRangeException(crate::error::InvalidPortRangeException),
    /// <p>Processing your request would cause you to exceed an AWS Global Accelerator limit.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The listener that you specified doesn't exist.</p>
    ListenerNotFoundException(crate::error::ListenerNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateCustomRoutingListenerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateCustomRoutingListenerErrorKind::InternalServiceErrorException(_inner) => {
                _inner.fmt(f)
            }
            UpdateCustomRoutingListenerErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            UpdateCustomRoutingListenerErrorKind::InvalidPortRangeException(_inner) => {
                _inner.fmt(f)
            }
            UpdateCustomRoutingListenerErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateCustomRoutingListenerErrorKind::ListenerNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateCustomRoutingListenerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateCustomRoutingListenerError {
    fn code(&self) -> Option<&str> {
        UpdateCustomRoutingListenerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateCustomRoutingListenerError {
    /// Creates a new `UpdateCustomRoutingListenerError`.
    pub fn new(kind: UpdateCustomRoutingListenerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateCustomRoutingListenerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateCustomRoutingListenerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateCustomRoutingListenerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateCustomRoutingListenerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateCustomRoutingListenerErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCustomRoutingListenerErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `UpdateCustomRoutingListenerErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCustomRoutingListenerErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns true if the error kind is `UpdateCustomRoutingListenerErrorKind::InvalidPortRangeException`.
    pub fn is_invalid_port_range_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCustomRoutingListenerErrorKind::InvalidPortRangeException(_)
        )
    }
    /// Returns true if the error kind is `UpdateCustomRoutingListenerErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCustomRoutingListenerErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateCustomRoutingListenerErrorKind::ListenerNotFoundException`.
    pub fn is_listener_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCustomRoutingListenerErrorKind::ListenerNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateCustomRoutingListenerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateCustomRoutingListenerErrorKind::InternalServiceErrorException(_inner) => {
                Some(_inner)
            }
            UpdateCustomRoutingListenerErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            UpdateCustomRoutingListenerErrorKind::InvalidPortRangeException(_inner) => Some(_inner),
            UpdateCustomRoutingListenerErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateCustomRoutingListenerErrorKind::ListenerNotFoundException(_inner) => Some(_inner),
            UpdateCustomRoutingListenerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateEndpointGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateEndpointGroupError {
    /// Kind of error that occurred.
    pub kind: UpdateEndpointGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateEndpointGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateEndpointGroupErrorKind {
    /// <p>You don't have access permission.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The endpoint group that you specified doesn't exist.</p>
    EndpointGroupNotFoundException(crate::error::EndpointGroupNotFoundException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>Processing your request would cause you to exceed an AWS Global Accelerator limit.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateEndpointGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateEndpointGroupErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateEndpointGroupErrorKind::EndpointGroupNotFoundException(_inner) => _inner.fmt(f),
            UpdateEndpointGroupErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            UpdateEndpointGroupErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            UpdateEndpointGroupErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateEndpointGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateEndpointGroupError {
    fn code(&self) -> Option<&str> {
        UpdateEndpointGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateEndpointGroupError {
    /// Creates a new `UpdateEndpointGroupError`.
    pub fn new(kind: UpdateEndpointGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateEndpointGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateEndpointGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateEndpointGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateEndpointGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateEndpointGroupErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEndpointGroupErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `UpdateEndpointGroupErrorKind::EndpointGroupNotFoundException`.
    pub fn is_endpoint_group_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEndpointGroupErrorKind::EndpointGroupNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateEndpointGroupErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEndpointGroupErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `UpdateEndpointGroupErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEndpointGroupErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns true if the error kind is `UpdateEndpointGroupErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEndpointGroupErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for UpdateEndpointGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateEndpointGroupErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateEndpointGroupErrorKind::EndpointGroupNotFoundException(_inner) => Some(_inner),
            UpdateEndpointGroupErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            UpdateEndpointGroupErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            UpdateEndpointGroupErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateEndpointGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateListener` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateListenerError {
    /// Kind of error that occurred.
    pub kind: UpdateListenerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateListener` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateListenerErrorKind {
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The port numbers that you specified are not valid numbers or are not unique for this accelerator.</p>
    InvalidPortRangeException(crate::error::InvalidPortRangeException),
    /// <p>Processing your request would cause you to exceed an AWS Global Accelerator limit.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The listener that you specified doesn't exist.</p>
    ListenerNotFoundException(crate::error::ListenerNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateListenerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateListenerErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            UpdateListenerErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            UpdateListenerErrorKind::InvalidPortRangeException(_inner) => _inner.fmt(f),
            UpdateListenerErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateListenerErrorKind::ListenerNotFoundException(_inner) => _inner.fmt(f),
            UpdateListenerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateListenerError {
    fn code(&self) -> Option<&str> {
        UpdateListenerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateListenerError {
    /// Creates a new `UpdateListenerError`.
    pub fn new(kind: UpdateListenerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateListenerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateListenerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateListenerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateListenerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateListenerErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateListenerErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `UpdateListenerErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateListenerErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns true if the error kind is `UpdateListenerErrorKind::InvalidPortRangeException`.
    pub fn is_invalid_port_range_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateListenerErrorKind::InvalidPortRangeException(_)
        )
    }
    /// Returns true if the error kind is `UpdateListenerErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateListenerErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateListenerErrorKind::ListenerNotFoundException`.
    pub fn is_listener_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateListenerErrorKind::ListenerNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateListenerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateListenerErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            UpdateListenerErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            UpdateListenerErrorKind::InvalidPortRangeException(_inner) => Some(_inner),
            UpdateListenerErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateListenerErrorKind::ListenerNotFoundException(_inner) => Some(_inner),
            UpdateListenerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `WithdrawByoipCidr` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct WithdrawByoipCidrError {
    /// Kind of error that occurred.
    pub kind: WithdrawByoipCidrErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `WithdrawByoipCidr` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum WithdrawByoipCidrErrorKind {
    /// <p>You don't have access permission.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The CIDR that you specified was not found or is incorrect.</p>
    ByoipCidrNotFoundException(crate::error::ByoipCidrNotFoundException),
    /// <p>The CIDR that you specified is not valid for this action. For example, the state of the CIDR might be
    /// incorrect for this action.</p>
    IncorrectCidrStateException(crate::error::IncorrectCidrStateException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for WithdrawByoipCidrError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            WithdrawByoipCidrErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            WithdrawByoipCidrErrorKind::ByoipCidrNotFoundException(_inner) => _inner.fmt(f),
            WithdrawByoipCidrErrorKind::IncorrectCidrStateException(_inner) => _inner.fmt(f),
            WithdrawByoipCidrErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            WithdrawByoipCidrErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            WithdrawByoipCidrErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for WithdrawByoipCidrError {
    fn code(&self) -> Option<&str> {
        WithdrawByoipCidrError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl WithdrawByoipCidrError {
    /// Creates a new `WithdrawByoipCidrError`.
    pub fn new(kind: WithdrawByoipCidrErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `WithdrawByoipCidrError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: WithdrawByoipCidrErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `WithdrawByoipCidrError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: WithdrawByoipCidrErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `WithdrawByoipCidrErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            WithdrawByoipCidrErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `WithdrawByoipCidrErrorKind::ByoipCidrNotFoundException`.
    pub fn is_byoip_cidr_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            WithdrawByoipCidrErrorKind::ByoipCidrNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `WithdrawByoipCidrErrorKind::IncorrectCidrStateException`.
    pub fn is_incorrect_cidr_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            WithdrawByoipCidrErrorKind::IncorrectCidrStateException(_)
        )
    }
    /// Returns true if the error kind is `WithdrawByoipCidrErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            WithdrawByoipCidrErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `WithdrawByoipCidrErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            WithdrawByoipCidrErrorKind::InvalidArgumentException(_)
        )
    }
}
impl std::error::Error for WithdrawByoipCidrError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            WithdrawByoipCidrErrorKind::AccessDeniedException(_inner) => Some(_inner),
            WithdrawByoipCidrErrorKind::ByoipCidrNotFoundException(_inner) => Some(_inner),
            WithdrawByoipCidrErrorKind::IncorrectCidrStateException(_inner) => Some(_inner),
            WithdrawByoipCidrErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            WithdrawByoipCidrErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            WithdrawByoipCidrErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>An argument that you specified is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidArgumentException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidArgumentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidArgumentException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidArgumentException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidArgumentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidArgumentException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidArgumentException {}
/// See [`InvalidArgumentException`](crate::error::InvalidArgumentException)
pub mod invalid_argument_exception {
    /// A builder for [`InvalidArgumentException`](crate::error::InvalidArgumentException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidArgumentException`](crate::error::InvalidArgumentException)
        pub fn build(self) -> crate::error::InvalidArgumentException {
            crate::error::InvalidArgumentException {
                message: self.message,
            }
        }
    }
}
impl InvalidArgumentException {
    /// Creates a new builder-style object to manufacture [`InvalidArgumentException`](crate::error::InvalidArgumentException)
    pub fn builder() -> crate::error::invalid_argument_exception::Builder {
        crate::error::invalid_argument_exception::Builder::default()
    }
}

/// <p>There was an internal error for AWS Global Accelerator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServiceErrorException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServiceErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServiceErrorException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServiceErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServiceErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServiceErrorException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServiceErrorException {}
/// See [`InternalServiceErrorException`](crate::error::InternalServiceErrorException)
pub mod internal_service_error_exception {
    /// A builder for [`InternalServiceErrorException`](crate::error::InternalServiceErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServiceErrorException`](crate::error::InternalServiceErrorException)
        pub fn build(self) -> crate::error::InternalServiceErrorException {
            crate::error::InternalServiceErrorException {
                message: self.message,
            }
        }
    }
}
impl InternalServiceErrorException {
    /// Creates a new builder-style object to manufacture [`InternalServiceErrorException`](crate::error::InternalServiceErrorException)
    pub fn builder() -> crate::error::internal_service_error_exception::Builder {
        crate::error::internal_service_error_exception::Builder::default()
    }
}

/// <p>The CIDR that you specified is not valid for this action. For example, the state of the CIDR might be
/// incorrect for this action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IncorrectCidrStateException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IncorrectCidrStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IncorrectCidrStateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IncorrectCidrStateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IncorrectCidrStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IncorrectCidrStateException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for IncorrectCidrStateException {}
/// See [`IncorrectCidrStateException`](crate::error::IncorrectCidrStateException)
pub mod incorrect_cidr_state_exception {
    /// A builder for [`IncorrectCidrStateException`](crate::error::IncorrectCidrStateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IncorrectCidrStateException`](crate::error::IncorrectCidrStateException)
        pub fn build(self) -> crate::error::IncorrectCidrStateException {
            crate::error::IncorrectCidrStateException {
                message: self.message,
            }
        }
    }
}
impl IncorrectCidrStateException {
    /// Creates a new builder-style object to manufacture [`IncorrectCidrStateException`](crate::error::IncorrectCidrStateException)
    pub fn builder() -> crate::error::incorrect_cidr_state_exception::Builder {
        crate::error::incorrect_cidr_state_exception::Builder::default()
    }
}

/// <p>The CIDR that you specified was not found or is incorrect.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ByoipCidrNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ByoipCidrNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ByoipCidrNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ByoipCidrNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ByoipCidrNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ByoipCidrNotFoundException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ByoipCidrNotFoundException {}
/// See [`ByoipCidrNotFoundException`](crate::error::ByoipCidrNotFoundException)
pub mod byoip_cidr_not_found_exception {
    /// A builder for [`ByoipCidrNotFoundException`](crate::error::ByoipCidrNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ByoipCidrNotFoundException`](crate::error::ByoipCidrNotFoundException)
        pub fn build(self) -> crate::error::ByoipCidrNotFoundException {
            crate::error::ByoipCidrNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ByoipCidrNotFoundException {
    /// Creates a new builder-style object to manufacture [`ByoipCidrNotFoundException`](crate::error::ByoipCidrNotFoundException)
    pub fn builder() -> crate::error::byoip_cidr_not_found_exception::Builder {
        crate::error::byoip_cidr_not_found_exception::Builder::default()
    }
}

/// <p>You don't have access permission.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>The listener that you specified doesn't exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListenerNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListenerNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListenerNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ListenerNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ListenerNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ListenerNotFoundException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ListenerNotFoundException {}
/// See [`ListenerNotFoundException`](crate::error::ListenerNotFoundException)
pub mod listener_not_found_exception {
    /// A builder for [`ListenerNotFoundException`](crate::error::ListenerNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ListenerNotFoundException`](crate::error::ListenerNotFoundException)
        pub fn build(self) -> crate::error::ListenerNotFoundException {
            crate::error::ListenerNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ListenerNotFoundException {
    /// Creates a new builder-style object to manufacture [`ListenerNotFoundException`](crate::error::ListenerNotFoundException)
    pub fn builder() -> crate::error::listener_not_found_exception::Builder {
        crate::error::listener_not_found_exception::Builder::default()
    }
}

/// <p>Processing your request would cause you to exceed an AWS Global Accelerator limit.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>The port numbers that you specified are not valid numbers or are not unique for this accelerator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidPortRangeException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidPortRangeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidPortRangeException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidPortRangeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidPortRangeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidPortRangeException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidPortRangeException {}
/// See [`InvalidPortRangeException`](crate::error::InvalidPortRangeException)
pub mod invalid_port_range_exception {
    /// A builder for [`InvalidPortRangeException`](crate::error::InvalidPortRangeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidPortRangeException`](crate::error::InvalidPortRangeException)
        pub fn build(self) -> crate::error::InvalidPortRangeException {
            crate::error::InvalidPortRangeException {
                message: self.message,
            }
        }
    }
}
impl InvalidPortRangeException {
    /// Creates a new builder-style object to manufacture [`InvalidPortRangeException`](crate::error::InvalidPortRangeException)
    pub fn builder() -> crate::error::invalid_port_range_exception::Builder {
        crate::error::invalid_port_range_exception::Builder::default()
    }
}

/// <p>The endpoint group that you specified doesn't exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndpointGroupNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EndpointGroupNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndpointGroupNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EndpointGroupNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EndpointGroupNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EndpointGroupNotFoundException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for EndpointGroupNotFoundException {}
/// See [`EndpointGroupNotFoundException`](crate::error::EndpointGroupNotFoundException)
pub mod endpoint_group_not_found_exception {
    /// A builder for [`EndpointGroupNotFoundException`](crate::error::EndpointGroupNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EndpointGroupNotFoundException`](crate::error::EndpointGroupNotFoundException)
        pub fn build(self) -> crate::error::EndpointGroupNotFoundException {
            crate::error::EndpointGroupNotFoundException {
                message: self.message,
            }
        }
    }
}
impl EndpointGroupNotFoundException {
    /// Creates a new builder-style object to manufacture [`EndpointGroupNotFoundException`](crate::error::EndpointGroupNotFoundException)
    pub fn builder() -> crate::error::endpoint_group_not_found_exception::Builder {
        crate::error::endpoint_group_not_found_exception::Builder::default()
    }
}

/// <p>The accelerator that you specified doesn't exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceleratorNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AcceleratorNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceleratorNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AcceleratorNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AcceleratorNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AcceleratorNotFoundException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for AcceleratorNotFoundException {}
/// See [`AcceleratorNotFoundException`](crate::error::AcceleratorNotFoundException)
pub mod accelerator_not_found_exception {
    /// A builder for [`AcceleratorNotFoundException`](crate::error::AcceleratorNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceleratorNotFoundException`](crate::error::AcceleratorNotFoundException)
        pub fn build(self) -> crate::error::AcceleratorNotFoundException {
            crate::error::AcceleratorNotFoundException {
                message: self.message,
            }
        }
    }
}
impl AcceleratorNotFoundException {
    /// Creates a new builder-style object to manufacture [`AcceleratorNotFoundException`](crate::error::AcceleratorNotFoundException)
    pub fn builder() -> crate::error::accelerator_not_found_exception::Builder {
        crate::error::accelerator_not_found_exception::Builder::default()
    }
}

/// <p>The endpoint that you specified doesn't exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndpointNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EndpointNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndpointNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EndpointNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EndpointNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EndpointNotFoundException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for EndpointNotFoundException {}
/// See [`EndpointNotFoundException`](crate::error::EndpointNotFoundException)
pub mod endpoint_not_found_exception {
    /// A builder for [`EndpointNotFoundException`](crate::error::EndpointNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EndpointNotFoundException`](crate::error::EndpointNotFoundException)
        pub fn build(self) -> crate::error::EndpointNotFoundException {
            crate::error::EndpointNotFoundException {
                message: self.message,
            }
        }
    }
}
impl EndpointNotFoundException {
    /// Creates a new builder-style object to manufacture [`EndpointNotFoundException`](crate::error::EndpointNotFoundException)
    pub fn builder() -> crate::error::endpoint_not_found_exception::Builder {
        crate::error::endpoint_not_found_exception::Builder::default()
    }
}

/// <p>You can't use both of those options.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>There isn't another item to return.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidNextTokenException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidNextTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidNextTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidNextTokenException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidNextTokenException {}
/// See [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
pub mod invalid_next_token_exception {
    /// A builder for [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
        pub fn build(self) -> crate::error::InvalidNextTokenException {
            crate::error::InvalidNextTokenException {
                message: self.message,
            }
        }
    }
}
impl InvalidNextTokenException {
    /// Creates a new builder-style object to manufacture [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    pub fn builder() -> crate::error::invalid_next_token_exception::Builder {
        crate::error::invalid_next_token_exception::Builder::default()
    }
}

/// <p>The listener that you specified has an endpoint group associated with it. You must remove all dependent resources
/// from a listener before you can delete it.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociatedEndpointGroupFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AssociatedEndpointGroupFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociatedEndpointGroupFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AssociatedEndpointGroupFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AssociatedEndpointGroupFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AssociatedEndpointGroupFoundException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for AssociatedEndpointGroupFoundException {}
/// See [`AssociatedEndpointGroupFoundException`](crate::error::AssociatedEndpointGroupFoundException)
pub mod associated_endpoint_group_found_exception {
    /// A builder for [`AssociatedEndpointGroupFoundException`](crate::error::AssociatedEndpointGroupFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociatedEndpointGroupFoundException`](crate::error::AssociatedEndpointGroupFoundException)
        pub fn build(self) -> crate::error::AssociatedEndpointGroupFoundException {
            crate::error::AssociatedEndpointGroupFoundException {
                message: self.message,
            }
        }
    }
}
impl AssociatedEndpointGroupFoundException {
    /// Creates a new builder-style object to manufacture [`AssociatedEndpointGroupFoundException`](crate::error::AssociatedEndpointGroupFoundException)
    pub fn builder() -> crate::error::associated_endpoint_group_found_exception::Builder {
        crate::error::associated_endpoint_group_found_exception::Builder::default()
    }
}

/// <p>The accelerator that you specified has a listener associated with it. You must remove all dependent resources from an
/// accelerator before you can delete it.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociatedListenerFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AssociatedListenerFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociatedListenerFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AssociatedListenerFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AssociatedListenerFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AssociatedListenerFoundException")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for AssociatedListenerFoundException {}
/// See [`AssociatedListenerFoundException`](crate::error::AssociatedListenerFoundException)
pub mod associated_listener_found_exception {
    /// A builder for [`AssociatedListenerFoundException`](crate::error::AssociatedListenerFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociatedListenerFoundException`](crate::error::AssociatedListenerFoundException)
        pub fn build(self) -> crate::error::AssociatedListenerFoundException {
            crate::error::AssociatedListenerFoundException {
                message: self.message,
            }
        }
    }
}
impl AssociatedListenerFoundException {
    /// Creates a new builder-style object to manufacture [`AssociatedListenerFoundException`](crate::error::AssociatedListenerFoundException)
    pub fn builder() -> crate::error::associated_listener_found_exception::Builder {
        crate::error::associated_listener_found_exception::Builder::default()
    }
}

/// <p>The accelerator that you specified could not be disabled.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceleratorNotDisabledException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AcceleratorNotDisabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceleratorNotDisabledException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AcceleratorNotDisabledException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AcceleratorNotDisabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AcceleratorNotDisabledException")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for AcceleratorNotDisabledException {}
/// See [`AcceleratorNotDisabledException`](crate::error::AcceleratorNotDisabledException)
pub mod accelerator_not_disabled_exception {
    /// A builder for [`AcceleratorNotDisabledException`](crate::error::AcceleratorNotDisabledException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceleratorNotDisabledException`](crate::error::AcceleratorNotDisabledException)
        pub fn build(self) -> crate::error::AcceleratorNotDisabledException {
            crate::error::AcceleratorNotDisabledException {
                message: self.message,
            }
        }
    }
}
impl AcceleratorNotDisabledException {
    /// Creates a new builder-style object to manufacture [`AcceleratorNotDisabledException`](crate::error::AcceleratorNotDisabledException)
    pub fn builder() -> crate::error::accelerator_not_disabled_exception::Builder {
        crate::error::accelerator_not_disabled_exception::Builder::default()
    }
}

/// <p>The endpoint group that you specified already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndpointGroupAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EndpointGroupAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndpointGroupAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EndpointGroupAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EndpointGroupAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EndpointGroupAlreadyExistsException")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for EndpointGroupAlreadyExistsException {}
/// See [`EndpointGroupAlreadyExistsException`](crate::error::EndpointGroupAlreadyExistsException)
pub mod endpoint_group_already_exists_exception {
    /// A builder for [`EndpointGroupAlreadyExistsException`](crate::error::EndpointGroupAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EndpointGroupAlreadyExistsException`](crate::error::EndpointGroupAlreadyExistsException)
        pub fn build(self) -> crate::error::EndpointGroupAlreadyExistsException {
            crate::error::EndpointGroupAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl EndpointGroupAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`EndpointGroupAlreadyExistsException`](crate::error::EndpointGroupAlreadyExistsException)
    pub fn builder() -> crate::error::endpoint_group_already_exists_exception::Builder {
        crate::error::endpoint_group_already_exists_exception::Builder::default()
    }
}

/// <p>The endpoint that you specified doesn't exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndpointAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EndpointAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndpointAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EndpointAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EndpointAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EndpointAlreadyExistsException")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for EndpointAlreadyExistsException {}
/// See [`EndpointAlreadyExistsException`](crate::error::EndpointAlreadyExistsException)
pub mod endpoint_already_exists_exception {
    /// A builder for [`EndpointAlreadyExistsException`](crate::error::EndpointAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EndpointAlreadyExistsException`](crate::error::EndpointAlreadyExistsException)
        pub fn build(self) -> crate::error::EndpointAlreadyExistsException {
            crate::error::EndpointAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl EndpointAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`EndpointAlreadyExistsException`](crate::error::EndpointAlreadyExistsException)
    pub fn builder() -> crate::error::endpoint_already_exists_exception::Builder {
        crate::error::endpoint_already_exists_exception::Builder::default()
    }
}
