// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_abort_multipart_upload_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AbortMultipartUploadOutput,
    crate::error::AbortMultipartUploadError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AbortMultipartUploadError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AbortMultipartUploadError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::AbortMultipartUploadError {
            meta: generic,
            kind: crate::error::AbortMultipartUploadErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AbortMultipartUploadError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameterValueException" => crate::error::AbortMultipartUploadError {
            meta: generic,
            kind: crate::error::AbortMultipartUploadErrorKind::MissingParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AbortMultipartUploadError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AbortMultipartUploadError {
            meta: generic,
            kind: crate::error::AbortMultipartUploadErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AbortMultipartUploadError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::AbortMultipartUploadError {
            meta: generic,
            kind: crate::error::AbortMultipartUploadErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AbortMultipartUploadError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AbortMultipartUploadError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_abort_multipart_upload_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AbortMultipartUploadOutput,
    crate::error::AbortMultipartUploadError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::abort_multipart_upload_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_abort_vault_lock_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AbortVaultLockOutput, crate::error::AbortVaultLockError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AbortVaultLockError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AbortVaultLockError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::AbortVaultLockError {
            meta: generic,
            kind: crate::error::AbortVaultLockErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AbortVaultLockError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameterValueException" => crate::error::AbortVaultLockError {
            meta: generic,
            kind: crate::error::AbortVaultLockErrorKind::MissingParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AbortVaultLockError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AbortVaultLockError {
            meta: generic,
            kind: crate::error::AbortVaultLockErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AbortVaultLockError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::AbortVaultLockError {
            meta: generic,
            kind: crate::error::AbortVaultLockErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AbortVaultLockError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AbortVaultLockError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_abort_vault_lock_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AbortVaultLockOutput, crate::error::AbortVaultLockError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::abort_vault_lock_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_tags_to_vault_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddTagsToVaultOutput, crate::error::AddTagsToVaultError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AddTagsToVaultError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AddTagsToVaultError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::AddTagsToVaultError {
            meta: generic,
            kind: crate::error::AddTagsToVaultErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsToVaultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::AddTagsToVaultError {
            meta: generic,
            kind: crate::error::AddTagsToVaultErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsToVaultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameterValueException" => crate::error::AddTagsToVaultError {
            meta: generic,
            kind: crate::error::AddTagsToVaultErrorKind::MissingParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsToVaultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AddTagsToVaultError {
            meta: generic,
            kind: crate::error::AddTagsToVaultErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsToVaultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::AddTagsToVaultError {
            meta: generic,
            kind: crate::error::AddTagsToVaultErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsToVaultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AddTagsToVaultError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_tags_to_vault_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddTagsToVaultOutput, crate::error::AddTagsToVaultError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::add_tags_to_vault_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_complete_multipart_upload_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CompleteMultipartUploadOutput,
    crate::error::CompleteMultipartUploadError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CompleteMultipartUploadError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CompleteMultipartUploadError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::CompleteMultipartUploadError {
            meta: generic,
            kind: crate::error::CompleteMultipartUploadErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CompleteMultipartUploadError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameterValueException" => crate::error::CompleteMultipartUploadError {
            meta: generic,
            kind: crate::error::CompleteMultipartUploadErrorKind::MissingParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CompleteMultipartUploadError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::CompleteMultipartUploadError {
            meta: generic,
            kind: crate::error::CompleteMultipartUploadErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CompleteMultipartUploadError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::CompleteMultipartUploadError {
            meta: generic,
            kind: crate::error::CompleteMultipartUploadErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CompleteMultipartUploadError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CompleteMultipartUploadError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_complete_multipart_upload_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CompleteMultipartUploadOutput,
    crate::error::CompleteMultipartUploadError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::complete_multipart_upload_output::Builder::default();
        let _ = response;
        output = output.set_archive_id(
            crate::http_serde::deser_header_complete_multipart_upload_complete_multipart_upload_output_archive_id(response.headers())
                                    .map_err(|_|crate::error::CompleteMultipartUploadError::unhandled("Failed to parse archiveId from header `x-amz-archive-id"))?
        );
        output = output.set_checksum(
            crate::http_serde::deser_header_complete_multipart_upload_complete_multipart_upload_output_checksum(response.headers())
                                    .map_err(|_|crate::error::CompleteMultipartUploadError::unhandled("Failed to parse checksum from header `x-amz-sha256-tree-hash"))?
        );
        output = output.set_location(
            crate::http_serde::deser_header_complete_multipart_upload_complete_multipart_upload_output_location(response.headers())
                                    .map_err(|_|crate::error::CompleteMultipartUploadError::unhandled("Failed to parse location from header `Location"))?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_complete_vault_lock_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CompleteVaultLockOutput, crate::error::CompleteVaultLockError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CompleteVaultLockError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CompleteVaultLockError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::CompleteVaultLockError {
            meta: generic,
            kind: crate::error::CompleteVaultLockErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CompleteVaultLockError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameterValueException" => crate::error::CompleteVaultLockError {
            meta: generic,
            kind: crate::error::CompleteVaultLockErrorKind::MissingParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CompleteVaultLockError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::CompleteVaultLockError {
            meta: generic,
            kind: crate::error::CompleteVaultLockErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CompleteVaultLockError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::CompleteVaultLockError {
            meta: generic,
            kind: crate::error::CompleteVaultLockErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CompleteVaultLockError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CompleteVaultLockError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_complete_vault_lock_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CompleteVaultLockOutput, crate::error::CompleteVaultLockError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::complete_vault_lock_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_vault_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateVaultOutput, crate::error::CreateVaultError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateVaultError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateVaultError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::CreateVaultError {
            meta: generic,
            kind: crate::error::CreateVaultErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateVaultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateVaultError {
            meta: generic,
            kind: crate::error::CreateVaultErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateVaultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameterValueException" => crate::error::CreateVaultError {
            meta: generic,
            kind: crate::error::CreateVaultErrorKind::MissingParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateVaultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::CreateVaultError {
            meta: generic,
            kind: crate::error::CreateVaultErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateVaultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateVaultError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_vault_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateVaultOutput, crate::error::CreateVaultError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_vault_output::Builder::default();
        let _ = response;
        output = output.set_location(
            crate::http_serde::deser_header_create_vault_create_vault_output_location(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::CreateVaultError::unhandled(
                    "Failed to parse location from header `Location",
                )
            })?,
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_archive_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteArchiveOutput, crate::error::DeleteArchiveError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteArchiveError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteArchiveError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::DeleteArchiveError {
            meta: generic,
            kind: crate::error::DeleteArchiveErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteArchiveError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameterValueException" => crate::error::DeleteArchiveError {
            meta: generic,
            kind: crate::error::DeleteArchiveErrorKind::MissingParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteArchiveError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteArchiveError {
            meta: generic,
            kind: crate::error::DeleteArchiveErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteArchiveError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::DeleteArchiveError {
            meta: generic,
            kind: crate::error::DeleteArchiveErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteArchiveError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteArchiveError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_archive_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteArchiveOutput, crate::error::DeleteArchiveError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_archive_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_vault_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteVaultOutput, crate::error::DeleteVaultError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteVaultError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteVaultError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::DeleteVaultError {
            meta: generic,
            kind: crate::error::DeleteVaultErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteVaultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameterValueException" => crate::error::DeleteVaultError {
            meta: generic,
            kind: crate::error::DeleteVaultErrorKind::MissingParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteVaultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteVaultError {
            meta: generic,
            kind: crate::error::DeleteVaultErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteVaultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::DeleteVaultError {
            meta: generic,
            kind: crate::error::DeleteVaultErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteVaultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteVaultError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_vault_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteVaultOutput, crate::error::DeleteVaultError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_vault_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_vault_access_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteVaultAccessPolicyOutput,
    crate::error::DeleteVaultAccessPolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteVaultAccessPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteVaultAccessPolicyError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::DeleteVaultAccessPolicyError {
            meta: generic,
            kind: crate::error::DeleteVaultAccessPolicyErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteVaultAccessPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameterValueException" => crate::error::DeleteVaultAccessPolicyError {
            meta: generic,
            kind: crate::error::DeleteVaultAccessPolicyErrorKind::MissingParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteVaultAccessPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteVaultAccessPolicyError {
            meta: generic,
            kind: crate::error::DeleteVaultAccessPolicyErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteVaultAccessPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::DeleteVaultAccessPolicyError {
            meta: generic,
            kind: crate::error::DeleteVaultAccessPolicyErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteVaultAccessPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteVaultAccessPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_vault_access_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteVaultAccessPolicyOutput,
    crate::error::DeleteVaultAccessPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_vault_access_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_vault_notifications_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteVaultNotificationsOutput,
    crate::error::DeleteVaultNotificationsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteVaultNotificationsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteVaultNotificationsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::DeleteVaultNotificationsError {
            meta: generic,
            kind: crate::error::DeleteVaultNotificationsErrorKind::InvalidParameterValueException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_parameter_value_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteVaultNotificationsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "MissingParameterValueException" => crate::error::DeleteVaultNotificationsError {
            meta: generic,
            kind: crate::error::DeleteVaultNotificationsErrorKind::MissingParameterValueException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::missing_parameter_value_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_missing_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteVaultNotificationsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ResourceNotFoundException" => crate::error::DeleteVaultNotificationsError {
            meta: generic,
            kind: crate::error::DeleteVaultNotificationsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteVaultNotificationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::DeleteVaultNotificationsError {
            meta: generic,
            kind: crate::error::DeleteVaultNotificationsErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteVaultNotificationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteVaultNotificationsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_vault_notifications_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteVaultNotificationsOutput,
    crate::error::DeleteVaultNotificationsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_vault_notifications_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeJobOutput, crate::error::DescribeJobError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::DescribeJobError {
            meta: generic,
            kind: crate::error::DescribeJobErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameterValueException" => crate::error::DescribeJobError {
            meta: generic,
            kind: crate::error::DescribeJobErrorKind::MissingParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DescribeJobError {
            meta: generic,
            kind: crate::error::DescribeJobErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::DescribeJobError {
            meta: generic,
            kind: crate::error::DescribeJobErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeJobOutput, crate::error::DescribeJobError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_vault_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeVaultOutput, crate::error::DescribeVaultError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeVaultError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeVaultError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::DescribeVaultError {
            meta: generic,
            kind: crate::error::DescribeVaultErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeVaultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameterValueException" => crate::error::DescribeVaultError {
            meta: generic,
            kind: crate::error::DescribeVaultErrorKind::MissingParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeVaultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DescribeVaultError {
            meta: generic,
            kind: crate::error::DescribeVaultErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeVaultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::DescribeVaultError {
            meta: generic,
            kind: crate::error::DescribeVaultErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeVaultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeVaultError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_vault_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeVaultOutput, crate::error::DescribeVaultError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_vault_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_vault(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeVaultError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_data_retrieval_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetDataRetrievalPolicyOutput,
    crate::error::GetDataRetrievalPolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetDataRetrievalPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetDataRetrievalPolicyError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::GetDataRetrievalPolicyError {
            meta: generic,
            kind: crate::error::GetDataRetrievalPolicyErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDataRetrievalPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameterValueException" => crate::error::GetDataRetrievalPolicyError {
            meta: generic,
            kind: crate::error::GetDataRetrievalPolicyErrorKind::MissingParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDataRetrievalPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::GetDataRetrievalPolicyError {
            meta: generic,
            kind: crate::error::GetDataRetrievalPolicyErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDataRetrievalPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetDataRetrievalPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_data_retrieval_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetDataRetrievalPolicyOutput,
    crate::error::GetDataRetrievalPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_data_retrieval_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_data_retrieval_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetDataRetrievalPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_job_output(
    op_response: &mut aws_smithy_http::operation::Response,
) -> std::result::Result<crate::output::GetJobOutputOutput, crate::error::GetJobOutputError> {
    let response = op_response.http_mut();
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_job_output_output::Builder::default();
        let _ = response;
        output = output.set_accept_ranges(
            crate::http_serde::deser_header_get_job_output_get_job_output_output_accept_ranges(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetJobOutputError::unhandled(
                    "Failed to parse acceptRanges from header `Accept-Ranges",
                )
            })?,
        );
        output = output.set_archive_description(
            crate::http_serde::deser_header_get_job_output_get_job_output_output_archive_description(response.headers())
                                    .map_err(|_|crate::error::GetJobOutputError::unhandled("Failed to parse archiveDescription from header `x-amz-archive-description"))?
        );
        output = output.set_body(Some(
            crate::http_serde::deser_payload_get_job_output_get_job_output_output_body(
                response.body_mut(),
            )?,
        ));
        output = output.set_checksum(
            crate::http_serde::deser_header_get_job_output_get_job_output_output_checksum(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetJobOutputError::unhandled(
                    "Failed to parse checksum from header `x-amz-sha256-tree-hash",
                )
            })?,
        );
        output = output.set_content_range(
            crate::http_serde::deser_header_get_job_output_get_job_output_output_content_range(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetJobOutputError::unhandled(
                    "Failed to parse contentRange from header `Content-Range",
                )
            })?,
        );
        output = output.set_content_type(
            crate::http_serde::deser_header_get_job_output_get_job_output_output_content_type(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetJobOutputError::unhandled(
                    "Failed to parse contentType from header `Content-Type",
                )
            })?,
        );
        output = output.set_status(Some(response.status().as_u16() as _));
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_job_output_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetJobOutputOutput, crate::error::GetJobOutputError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetJobOutputError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetJobOutputError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::GetJobOutputError {
            meta: generic,
            kind: crate::error::GetJobOutputErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetJobOutputError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameterValueException" => crate::error::GetJobOutputError {
            meta: generic,
            kind: crate::error::GetJobOutputErrorKind::MissingParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetJobOutputError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetJobOutputError {
            meta: generic,
            kind: crate::error::GetJobOutputErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetJobOutputError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::GetJobOutputError {
            meta: generic,
            kind: crate::error::GetJobOutputErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetJobOutputError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetJobOutputError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_vault_access_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetVaultAccessPolicyOutput,
    crate::error::GetVaultAccessPolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetVaultAccessPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetVaultAccessPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::GetVaultAccessPolicyError {
            meta: generic,
            kind: crate::error::GetVaultAccessPolicyErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetVaultAccessPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameterValueException" => crate::error::GetVaultAccessPolicyError {
            meta: generic,
            kind: crate::error::GetVaultAccessPolicyErrorKind::MissingParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetVaultAccessPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetVaultAccessPolicyError {
            meta: generic,
            kind: crate::error::GetVaultAccessPolicyErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetVaultAccessPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::GetVaultAccessPolicyError {
            meta: generic,
            kind: crate::error::GetVaultAccessPolicyErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetVaultAccessPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetVaultAccessPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_vault_access_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetVaultAccessPolicyOutput,
    crate::error::GetVaultAccessPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_vault_access_policy_output::Builder::default();
        let _ = response;
        output = output.set_policy(
            crate::http_serde::deser_payload_get_vault_access_policy_get_vault_access_policy_output_policy(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_vault_lock_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetVaultLockOutput, crate::error::GetVaultLockError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetVaultLockError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetVaultLockError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::GetVaultLockError {
            meta: generic,
            kind: crate::error::GetVaultLockErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetVaultLockError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameterValueException" => crate::error::GetVaultLockError {
            meta: generic,
            kind: crate::error::GetVaultLockErrorKind::MissingParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetVaultLockError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetVaultLockError {
            meta: generic,
            kind: crate::error::GetVaultLockErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetVaultLockError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::GetVaultLockError {
            meta: generic,
            kind: crate::error::GetVaultLockErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetVaultLockError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetVaultLockError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_vault_lock_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetVaultLockOutput, crate::error::GetVaultLockError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_vault_lock_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_vault_lock(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetVaultLockError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_vault_notifications_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetVaultNotificationsOutput,
    crate::error::GetVaultNotificationsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetVaultNotificationsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetVaultNotificationsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::GetVaultNotificationsError {
            meta: generic,
            kind: crate::error::GetVaultNotificationsErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetVaultNotificationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameterValueException" => crate::error::GetVaultNotificationsError {
            meta: generic,
            kind: crate::error::GetVaultNotificationsErrorKind::MissingParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetVaultNotificationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetVaultNotificationsError {
            meta: generic,
            kind: crate::error::GetVaultNotificationsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetVaultNotificationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::GetVaultNotificationsError {
            meta: generic,
            kind: crate::error::GetVaultNotificationsErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetVaultNotificationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetVaultNotificationsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_vault_notifications_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetVaultNotificationsOutput,
    crate::error::GetVaultNotificationsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_vault_notifications_output::Builder::default();
        let _ = response;
        output = output.set_vault_notification_config(
            crate::http_serde::deser_payload_get_vault_notifications_get_vault_notifications_output_vault_notification_config(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_initiate_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::InitiateJobOutput, crate::error::InitiateJobError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::InitiateJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::InitiateJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InsufficientCapacityException" => crate::error::InitiateJobError {
            meta: generic,
            kind: crate::error::InitiateJobErrorKind::InsufficientCapacityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::insufficient_capacity_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_insufficient_capacity_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InitiateJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValueException" => crate::error::InitiateJobError {
            meta: generic,
            kind: crate::error::InitiateJobErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InitiateJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameterValueException" => crate::error::InitiateJobError {
            meta: generic,
            kind: crate::error::InitiateJobErrorKind::MissingParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InitiateJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PolicyEnforcedException" => crate::error::InitiateJobError {
            meta: generic,
            kind: crate::error::InitiateJobErrorKind::PolicyEnforcedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::policy_enforced_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_policy_enforced_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InitiateJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::InitiateJobError {
            meta: generic,
            kind: crate::error::InitiateJobErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InitiateJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::InitiateJobError {
            meta: generic,
            kind: crate::error::InitiateJobErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InitiateJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::InitiateJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_initiate_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::InitiateJobOutput, crate::error::InitiateJobError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::initiate_job_output::Builder::default();
        let _ = response;
        output = output.set_job_id(
            crate::http_serde::deser_header_initiate_job_initiate_job_output_job_id(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::InitiateJobError::unhandled(
                    "Failed to parse jobId from header `x-amz-job-id",
                )
            })?,
        );
        output = output.set_job_output_path(
            crate::http_serde::deser_header_initiate_job_initiate_job_output_job_output_path(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::InitiateJobError::unhandled(
                    "Failed to parse jobOutputPath from header `x-amz-job-output-path",
                )
            })?,
        );
        output = output.set_location(
            crate::http_serde::deser_header_initiate_job_initiate_job_output_location(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::InitiateJobError::unhandled(
                    "Failed to parse location from header `Location",
                )
            })?,
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_initiate_multipart_upload_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::InitiateMultipartUploadOutput,
    crate::error::InitiateMultipartUploadError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::InitiateMultipartUploadError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::InitiateMultipartUploadError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::InitiateMultipartUploadError {
            meta: generic,
            kind: crate::error::InitiateMultipartUploadErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InitiateMultipartUploadError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameterValueException" => crate::error::InitiateMultipartUploadError {
            meta: generic,
            kind: crate::error::InitiateMultipartUploadErrorKind::MissingParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InitiateMultipartUploadError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::InitiateMultipartUploadError {
            meta: generic,
            kind: crate::error::InitiateMultipartUploadErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InitiateMultipartUploadError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::InitiateMultipartUploadError {
            meta: generic,
            kind: crate::error::InitiateMultipartUploadErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InitiateMultipartUploadError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::InitiateMultipartUploadError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_initiate_multipart_upload_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::InitiateMultipartUploadOutput,
    crate::error::InitiateMultipartUploadError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::initiate_multipart_upload_output::Builder::default();
        let _ = response;
        output = output.set_location(
            crate::http_serde::deser_header_initiate_multipart_upload_initiate_multipart_upload_output_location(response.headers())
                                    .map_err(|_|crate::error::InitiateMultipartUploadError::unhandled("Failed to parse location from header `Location"))?
        );
        output = output.set_upload_id(
            crate::http_serde::deser_header_initiate_multipart_upload_initiate_multipart_upload_output_upload_id(response.headers())
                                    .map_err(|_|crate::error::InitiateMultipartUploadError::unhandled("Failed to parse uploadId from header `x-amz-multipart-upload-id"))?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_initiate_vault_lock_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::InitiateVaultLockOutput, crate::error::InitiateVaultLockError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::InitiateVaultLockError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::InitiateVaultLockError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::InitiateVaultLockError {
            meta: generic,
            kind: crate::error::InitiateVaultLockErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InitiateVaultLockError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameterValueException" => crate::error::InitiateVaultLockError {
            meta: generic,
            kind: crate::error::InitiateVaultLockErrorKind::MissingParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InitiateVaultLockError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::InitiateVaultLockError {
            meta: generic,
            kind: crate::error::InitiateVaultLockErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InitiateVaultLockError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::InitiateVaultLockError {
            meta: generic,
            kind: crate::error::InitiateVaultLockErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InitiateVaultLockError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::InitiateVaultLockError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_initiate_vault_lock_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::InitiateVaultLockOutput, crate::error::InitiateVaultLockError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::initiate_vault_lock_output::Builder::default();
        let _ = response;
        output = output.set_lock_id(
            crate::http_serde::deser_header_initiate_vault_lock_initiate_vault_lock_output_lock_id(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::InitiateVaultLockError::unhandled(
                    "Failed to parse lockId from header `x-amz-lock-id",
                )
            })?,
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_jobs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListJobsOutput, crate::error::ListJobsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListJobsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListJobsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::ListJobsError {
            meta: generic,
            kind: crate::error::ListJobsErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameterValueException" => crate::error::ListJobsError {
            meta: generic,
            kind: crate::error::ListJobsErrorKind::MissingParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListJobsError {
            meta: generic,
            kind: crate::error::ListJobsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::ListJobsError {
            meta: generic,
            kind: crate::error::ListJobsErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListJobsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_jobs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListJobsOutput, crate::error::ListJobsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_jobs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_jobs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListJobsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_multipart_uploads_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListMultipartUploadsOutput,
    crate::error::ListMultipartUploadsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListMultipartUploadsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListMultipartUploadsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::ListMultipartUploadsError {
            meta: generic,
            kind: crate::error::ListMultipartUploadsErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListMultipartUploadsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameterValueException" => crate::error::ListMultipartUploadsError {
            meta: generic,
            kind: crate::error::ListMultipartUploadsErrorKind::MissingParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListMultipartUploadsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListMultipartUploadsError {
            meta: generic,
            kind: crate::error::ListMultipartUploadsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListMultipartUploadsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::ListMultipartUploadsError {
            meta: generic,
            kind: crate::error::ListMultipartUploadsErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListMultipartUploadsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListMultipartUploadsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_multipart_uploads_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListMultipartUploadsOutput,
    crate::error::ListMultipartUploadsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_multipart_uploads_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_multipart_uploads(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListMultipartUploadsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_parts_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListPartsOutput, crate::error::ListPartsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListPartsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListPartsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::ListPartsError {
            meta: generic,
            kind: crate::error::ListPartsErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPartsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameterValueException" => crate::error::ListPartsError {
            meta: generic,
            kind: crate::error::ListPartsErrorKind::MissingParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPartsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListPartsError {
            meta: generic,
            kind: crate::error::ListPartsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPartsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::ListPartsError {
            meta: generic,
            kind: crate::error::ListPartsErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPartsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListPartsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_parts_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListPartsOutput, crate::error::ListPartsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_parts_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_parts(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListPartsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_provisioned_capacity_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListProvisionedCapacityOutput,
    crate::error::ListProvisionedCapacityError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListProvisionedCapacityError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListProvisionedCapacityError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::ListProvisionedCapacityError {
            meta: generic,
            kind: crate::error::ListProvisionedCapacityErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListProvisionedCapacityError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameterValueException" => crate::error::ListProvisionedCapacityError {
            meta: generic,
            kind: crate::error::ListProvisionedCapacityErrorKind::MissingParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListProvisionedCapacityError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::ListProvisionedCapacityError {
            meta: generic,
            kind: crate::error::ListProvisionedCapacityErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListProvisionedCapacityError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListProvisionedCapacityError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_provisioned_capacity_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListProvisionedCapacityOutput,
    crate::error::ListProvisionedCapacityError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_provisioned_capacity_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_provisioned_capacity(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListProvisionedCapacityError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_vault_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTagsForVaultOutput, crate::error::ListTagsForVaultError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsForVaultError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsForVaultError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::ListTagsForVaultError {
            meta: generic,
            kind: crate::error::ListTagsForVaultErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForVaultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameterValueException" => crate::error::ListTagsForVaultError {
            meta: generic,
            kind: crate::error::ListTagsForVaultErrorKind::MissingParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForVaultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListTagsForVaultError {
            meta: generic,
            kind: crate::error::ListTagsForVaultErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForVaultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::ListTagsForVaultError {
            meta: generic,
            kind: crate::error::ListTagsForVaultErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForVaultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTagsForVaultError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_vault_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTagsForVaultOutput, crate::error::ListTagsForVaultError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_for_vault_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tags_for_vault(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsForVaultError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_vaults_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListVaultsOutput, crate::error::ListVaultsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListVaultsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListVaultsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::ListVaultsError {
            meta: generic,
            kind: crate::error::ListVaultsErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListVaultsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameterValueException" => crate::error::ListVaultsError {
            meta: generic,
            kind: crate::error::ListVaultsErrorKind::MissingParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListVaultsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListVaultsError {
            meta: generic,
            kind: crate::error::ListVaultsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListVaultsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::ListVaultsError {
            meta: generic,
            kind: crate::error::ListVaultsErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListVaultsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListVaultsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_vaults_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListVaultsOutput, crate::error::ListVaultsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_vaults_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_vaults(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListVaultsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_purchase_provisioned_capacity_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PurchaseProvisionedCapacityOutput,
    crate::error::PurchaseProvisionedCapacityError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PurchaseProvisionedCapacityError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::PurchaseProvisionedCapacityError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::PurchaseProvisionedCapacityError {
            meta: generic,
            kind:
                crate::error::PurchaseProvisionedCapacityErrorKind::InvalidParameterValueException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_parameter_value_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PurchaseProvisionedCapacityError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "LimitExceededException" => crate::error::PurchaseProvisionedCapacityError {
            meta: generic,
            kind: crate::error::PurchaseProvisionedCapacityErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PurchaseProvisionedCapacityError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameterValueException" => crate::error::PurchaseProvisionedCapacityError {
            meta: generic,
            kind:
                crate::error::PurchaseProvisionedCapacityErrorKind::MissingParameterValueException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::missing_parameter_value_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_missing_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PurchaseProvisionedCapacityError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ServiceUnavailableException" => crate::error::PurchaseProvisionedCapacityError {
            meta: generic,
            kind: crate::error::PurchaseProvisionedCapacityErrorKind::ServiceUnavailableException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::service_unavailable_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PurchaseProvisionedCapacityError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::PurchaseProvisionedCapacityError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_purchase_provisioned_capacity_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PurchaseProvisionedCapacityOutput,
    crate::error::PurchaseProvisionedCapacityError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::purchase_provisioned_capacity_output::Builder::default();
        let _ = response;
        output = output.set_capacity_id(
            crate::http_serde::deser_header_purchase_provisioned_capacity_purchase_provisioned_capacity_output_capacity_id(response.headers())
                                    .map_err(|_|crate::error::PurchaseProvisionedCapacityError::unhandled("Failed to parse capacityId from header `x-amz-capacity-id"))?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_tags_from_vault_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveTagsFromVaultOutput,
    crate::error::RemoveTagsFromVaultError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RemoveTagsFromVaultError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RemoveTagsFromVaultError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::RemoveTagsFromVaultError {
            meta: generic,
            kind: crate::error::RemoveTagsFromVaultErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsFromVaultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameterValueException" => crate::error::RemoveTagsFromVaultError {
            meta: generic,
            kind: crate::error::RemoveTagsFromVaultErrorKind::MissingParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsFromVaultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::RemoveTagsFromVaultError {
            meta: generic,
            kind: crate::error::RemoveTagsFromVaultErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsFromVaultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::RemoveTagsFromVaultError {
            meta: generic,
            kind: crate::error::RemoveTagsFromVaultErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsFromVaultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RemoveTagsFromVaultError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_tags_from_vault_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveTagsFromVaultOutput,
    crate::error::RemoveTagsFromVaultError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::remove_tags_from_vault_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_data_retrieval_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetDataRetrievalPolicyOutput,
    crate::error::SetDataRetrievalPolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetDataRetrievalPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::SetDataRetrievalPolicyError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::SetDataRetrievalPolicyError {
            meta: generic,
            kind: crate::error::SetDataRetrievalPolicyErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetDataRetrievalPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameterValueException" => crate::error::SetDataRetrievalPolicyError {
            meta: generic,
            kind: crate::error::SetDataRetrievalPolicyErrorKind::MissingParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetDataRetrievalPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::SetDataRetrievalPolicyError {
            meta: generic,
            kind: crate::error::SetDataRetrievalPolicyErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetDataRetrievalPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SetDataRetrievalPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_data_retrieval_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetDataRetrievalPolicyOutput,
    crate::error::SetDataRetrievalPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_data_retrieval_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_vault_access_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetVaultAccessPolicyOutput,
    crate::error::SetVaultAccessPolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetVaultAccessPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SetVaultAccessPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::SetVaultAccessPolicyError {
            meta: generic,
            kind: crate::error::SetVaultAccessPolicyErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetVaultAccessPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameterValueException" => crate::error::SetVaultAccessPolicyError {
            meta: generic,
            kind: crate::error::SetVaultAccessPolicyErrorKind::MissingParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetVaultAccessPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::SetVaultAccessPolicyError {
            meta: generic,
            kind: crate::error::SetVaultAccessPolicyErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetVaultAccessPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::SetVaultAccessPolicyError {
            meta: generic,
            kind: crate::error::SetVaultAccessPolicyErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetVaultAccessPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SetVaultAccessPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_vault_access_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetVaultAccessPolicyOutput,
    crate::error::SetVaultAccessPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_vault_access_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_vault_notifications_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetVaultNotificationsOutput,
    crate::error::SetVaultNotificationsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetVaultNotificationsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SetVaultNotificationsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::SetVaultNotificationsError {
            meta: generic,
            kind: crate::error::SetVaultNotificationsErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetVaultNotificationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameterValueException" => crate::error::SetVaultNotificationsError {
            meta: generic,
            kind: crate::error::SetVaultNotificationsErrorKind::MissingParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetVaultNotificationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::SetVaultNotificationsError {
            meta: generic,
            kind: crate::error::SetVaultNotificationsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetVaultNotificationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::SetVaultNotificationsError {
            meta: generic,
            kind: crate::error::SetVaultNotificationsErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetVaultNotificationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SetVaultNotificationsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_vault_notifications_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetVaultNotificationsOutput,
    crate::error::SetVaultNotificationsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_vault_notifications_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_upload_archive_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UploadArchiveOutput, crate::error::UploadArchiveError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UploadArchiveError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UploadArchiveError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::UploadArchiveError {
            meta: generic,
            kind: crate::error::UploadArchiveErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UploadArchiveError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameterValueException" => crate::error::UploadArchiveError {
            meta: generic,
            kind: crate::error::UploadArchiveErrorKind::MissingParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UploadArchiveError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RequestTimeoutException" => crate::error::UploadArchiveError {
            meta: generic,
            kind: crate::error::UploadArchiveErrorKind::RequestTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UploadArchiveError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UploadArchiveError {
            meta: generic,
            kind: crate::error::UploadArchiveErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UploadArchiveError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::UploadArchiveError {
            meta: generic,
            kind: crate::error::UploadArchiveErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UploadArchiveError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UploadArchiveError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_upload_archive_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UploadArchiveOutput, crate::error::UploadArchiveError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::upload_archive_output::Builder::default();
        let _ = response;
        output = output.set_archive_id(
            crate::http_serde::deser_header_upload_archive_upload_archive_output_archive_id(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::UploadArchiveError::unhandled(
                    "Failed to parse archiveId from header `x-amz-archive-id",
                )
            })?,
        );
        output = output.set_checksum(
            crate::http_serde::deser_header_upload_archive_upload_archive_output_checksum(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::UploadArchiveError::unhandled(
                    "Failed to parse checksum from header `x-amz-sha256-tree-hash",
                )
            })?,
        );
        output = output.set_location(
            crate::http_serde::deser_header_upload_archive_upload_archive_output_location(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::UploadArchiveError::unhandled(
                    "Failed to parse location from header `Location",
                )
            })?,
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_upload_multipart_part_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UploadMultipartPartOutput,
    crate::error::UploadMultipartPartError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UploadMultipartPartError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UploadMultipartPartError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::UploadMultipartPartError {
            meta: generic,
            kind: crate::error::UploadMultipartPartErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UploadMultipartPartError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameterValueException" => crate::error::UploadMultipartPartError {
            meta: generic,
            kind: crate::error::UploadMultipartPartErrorKind::MissingParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UploadMultipartPartError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RequestTimeoutException" => crate::error::UploadMultipartPartError {
            meta: generic,
            kind: crate::error::UploadMultipartPartErrorKind::RequestTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UploadMultipartPartError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UploadMultipartPartError {
            meta: generic,
            kind: crate::error::UploadMultipartPartErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UploadMultipartPartError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceUnavailableException" => crate::error::UploadMultipartPartError {
            meta: generic,
            kind: crate::error::UploadMultipartPartErrorKind::ServiceUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UploadMultipartPartError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UploadMultipartPartError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_upload_multipart_part_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UploadMultipartPartOutput,
    crate::error::UploadMultipartPartError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::upload_multipart_part_output::Builder::default();
        let _ = response;
        output = output.set_checksum(
            crate::http_serde::deser_header_upload_multipart_part_upload_multipart_part_output_checksum(response.headers())
                                    .map_err(|_|crate::error::UploadMultipartPartError::unhandled("Failed to parse checksum from header `x-amz-sha256-tree-hash"))?
        );
        output.build()
    })
}
