// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Represents a vault's notification configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VaultNotificationConfig {
    /// <p>The Amazon Simple Notification Service (Amazon SNS) topic Amazon Resource Name (ARN).</p>
    pub sns_topic: std::option::Option<std::string::String>,
    /// <p>A list of one or more events for which Amazon S3 Glacier will send a notification to the specified Amazon SNS topic.</p>
    pub events: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl VaultNotificationConfig {
    /// <p>The Amazon Simple Notification Service (Amazon SNS) topic Amazon Resource Name (ARN).</p>
    pub fn sns_topic(&self) -> std::option::Option<&str> {
        self.sns_topic.as_deref()
    }
    /// <p>A list of one or more events for which Amazon S3 Glacier will send a notification to the specified Amazon SNS topic.</p>
    pub fn events(&self) -> std::option::Option<&[std::string::String]> {
        self.events.as_deref()
    }
}
impl std::fmt::Debug for VaultNotificationConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VaultNotificationConfig");
        formatter.field("sns_topic", &self.sns_topic);
        formatter.field("events", &self.events);
        formatter.finish()
    }
}
/// See [`VaultNotificationConfig`](crate::model::VaultNotificationConfig)
pub mod vault_notification_config {
    /// A builder for [`VaultNotificationConfig`](crate::model::VaultNotificationConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sns_topic: std::option::Option<std::string::String>,
        pub(crate) events: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Simple Notification Service (Amazon SNS) topic Amazon Resource Name (ARN).</p>
        pub fn sns_topic(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic = Some(input.into());
            self
        }
        /// <p>The Amazon Simple Notification Service (Amazon SNS) topic Amazon Resource Name (ARN).</p>
        pub fn set_sns_topic(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sns_topic = input;
            self
        }
        /// Appends an item to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>A list of one or more events for which Amazon S3 Glacier will send a notification to the specified Amazon SNS topic.</p>
        pub fn events(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.events.unwrap_or_default();
            v.push(input.into());
            self.events = Some(v);
            self
        }
        /// <p>A list of one or more events for which Amazon S3 Glacier will send a notification to the specified Amazon SNS topic.</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.events = input;
            self
        }
        /// Consumes the builder and constructs a [`VaultNotificationConfig`](crate::model::VaultNotificationConfig)
        pub fn build(self) -> crate::model::VaultNotificationConfig {
            crate::model::VaultNotificationConfig {
                sns_topic: self.sns_topic,
                events: self.events,
            }
        }
    }
}
impl VaultNotificationConfig {
    /// Creates a new builder-style object to manufacture [`VaultNotificationConfig`](crate::model::VaultNotificationConfig)
    pub fn builder() -> crate::model::vault_notification_config::Builder {
        crate::model::vault_notification_config::Builder::default()
    }
}

/// <p>Contains the vault access policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VaultAccessPolicy {
    /// <p>The vault access policy.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl VaultAccessPolicy {
    /// <p>The vault access policy.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
}
impl std::fmt::Debug for VaultAccessPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VaultAccessPolicy");
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`VaultAccessPolicy`](crate::model::VaultAccessPolicy)
pub mod vault_access_policy {
    /// A builder for [`VaultAccessPolicy`](crate::model::VaultAccessPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The vault access policy.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The vault access policy.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`VaultAccessPolicy`](crate::model::VaultAccessPolicy)
        pub fn build(self) -> crate::model::VaultAccessPolicy {
            crate::model::VaultAccessPolicy {
                policy: self.policy,
            }
        }
    }
}
impl VaultAccessPolicy {
    /// Creates a new builder-style object to manufacture [`VaultAccessPolicy`](crate::model::VaultAccessPolicy)
    pub fn builder() -> crate::model::vault_access_policy::Builder {
        crate::model::vault_access_policy::Builder::default()
    }
}

/// <p>Data retrieval policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataRetrievalPolicy {
    /// <p>The policy rule. Although this is a list type, currently there must be only one rule, which contains a Strategy field and optionally a BytesPerHour field.</p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::DataRetrievalRule>>,
}
impl DataRetrievalPolicy {
    /// <p>The policy rule. Although this is a list type, currently there must be only one rule, which contains a Strategy field and optionally a BytesPerHour field.</p>
    pub fn rules(&self) -> std::option::Option<&[crate::model::DataRetrievalRule]> {
        self.rules.as_deref()
    }
}
impl std::fmt::Debug for DataRetrievalPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataRetrievalPolicy");
        formatter.field("rules", &self.rules);
        formatter.finish()
    }
}
/// See [`DataRetrievalPolicy`](crate::model::DataRetrievalPolicy)
pub mod data_retrieval_policy {
    /// A builder for [`DataRetrievalPolicy`](crate::model::DataRetrievalPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::DataRetrievalRule>>,
    }
    impl Builder {
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>The policy rule. Although this is a list type, currently there must be only one rule, which contains a Strategy field and optionally a BytesPerHour field.</p>
        pub fn rules(mut self, input: crate::model::DataRetrievalRule) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input);
            self.rules = Some(v);
            self
        }
        /// <p>The policy rule. Although this is a list type, currently there must be only one rule, which contains a Strategy field and optionally a BytesPerHour field.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataRetrievalRule>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// Consumes the builder and constructs a [`DataRetrievalPolicy`](crate::model::DataRetrievalPolicy)
        pub fn build(self) -> crate::model::DataRetrievalPolicy {
            crate::model::DataRetrievalPolicy { rules: self.rules }
        }
    }
}
impl DataRetrievalPolicy {
    /// Creates a new builder-style object to manufacture [`DataRetrievalPolicy`](crate::model::DataRetrievalPolicy)
    pub fn builder() -> crate::model::data_retrieval_policy::Builder {
        crate::model::data_retrieval_policy::Builder::default()
    }
}

/// <p>Data retrieval policy rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataRetrievalRule {
    /// <p>The type of data retrieval policy to set.</p>
    /// <p>Valid values: BytesPerHour|FreeTier|None</p>
    pub strategy: std::option::Option<std::string::String>,
    /// <p>The maximum number of bytes that can be retrieved in an hour.</p>
    /// <p>This field is required only if the value of the Strategy field is <code>BytesPerHour</code>. Your PUT operation will be rejected if the Strategy field is not set to <code>BytesPerHour</code> and you set this field.</p>
    pub bytes_per_hour: std::option::Option<i64>,
}
impl DataRetrievalRule {
    /// <p>The type of data retrieval policy to set.</p>
    /// <p>Valid values: BytesPerHour|FreeTier|None</p>
    pub fn strategy(&self) -> std::option::Option<&str> {
        self.strategy.as_deref()
    }
    /// <p>The maximum number of bytes that can be retrieved in an hour.</p>
    /// <p>This field is required only if the value of the Strategy field is <code>BytesPerHour</code>. Your PUT operation will be rejected if the Strategy field is not set to <code>BytesPerHour</code> and you set this field.</p>
    pub fn bytes_per_hour(&self) -> std::option::Option<i64> {
        self.bytes_per_hour
    }
}
impl std::fmt::Debug for DataRetrievalRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataRetrievalRule");
        formatter.field("strategy", &self.strategy);
        formatter.field("bytes_per_hour", &self.bytes_per_hour);
        formatter.finish()
    }
}
/// See [`DataRetrievalRule`](crate::model::DataRetrievalRule)
pub mod data_retrieval_rule {
    /// A builder for [`DataRetrievalRule`](crate::model::DataRetrievalRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) strategy: std::option::Option<std::string::String>,
        pub(crate) bytes_per_hour: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The type of data retrieval policy to set.</p>
        /// <p>Valid values: BytesPerHour|FreeTier|None</p>
        pub fn strategy(mut self, input: impl Into<std::string::String>) -> Self {
            self.strategy = Some(input.into());
            self
        }
        /// <p>The type of data retrieval policy to set.</p>
        /// <p>Valid values: BytesPerHour|FreeTier|None</p>
        pub fn set_strategy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.strategy = input;
            self
        }
        /// <p>The maximum number of bytes that can be retrieved in an hour.</p>
        /// <p>This field is required only if the value of the Strategy field is <code>BytesPerHour</code>. Your PUT operation will be rejected if the Strategy field is not set to <code>BytesPerHour</code> and you set this field.</p>
        pub fn bytes_per_hour(mut self, input: i64) -> Self {
            self.bytes_per_hour = Some(input);
            self
        }
        /// <p>The maximum number of bytes that can be retrieved in an hour.</p>
        /// <p>This field is required only if the value of the Strategy field is <code>BytesPerHour</code>. Your PUT operation will be rejected if the Strategy field is not set to <code>BytesPerHour</code> and you set this field.</p>
        pub fn set_bytes_per_hour(mut self, input: std::option::Option<i64>) -> Self {
            self.bytes_per_hour = input;
            self
        }
        /// Consumes the builder and constructs a [`DataRetrievalRule`](crate::model::DataRetrievalRule)
        pub fn build(self) -> crate::model::DataRetrievalRule {
            crate::model::DataRetrievalRule {
                strategy: self.strategy,
                bytes_per_hour: self.bytes_per_hour,
            }
        }
    }
}
impl DataRetrievalRule {
    /// Creates a new builder-style object to manufacture [`DataRetrievalRule`](crate::model::DataRetrievalRule)
    pub fn builder() -> crate::model::data_retrieval_rule::Builder {
        crate::model::data_retrieval_rule::Builder::default()
    }
}

/// <p>Contains the Amazon S3 Glacier response to your request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeVaultOutput {
    /// <p>The Amazon Resource Name (ARN) of the vault.</p>
    pub vault_arn: std::option::Option<std::string::String>,
    /// <p>The name of the vault.</p>
    pub vault_name: std::option::Option<std::string::String>,
    /// <p>The Universal Coordinated Time (UTC) date when the vault was created. This value should be a string in the ISO 8601 date format, for example <code>2012-03-20T17:03:43.221Z</code>.</p>
    pub creation_date: std::option::Option<std::string::String>,
    /// <p>The Universal Coordinated Time (UTC) date when Amazon S3 Glacier completed the last vault inventory. This value should be a string in the ISO 8601 date format, for example <code>2012-03-20T17:03:43.221Z</code>.</p>
    pub last_inventory_date: std::option::Option<std::string::String>,
    /// <p>The number of archives in the vault as of the last inventory date. This field will return <code>null</code> if an inventory has not yet run on the vault, for example if you just created the vault.</p>
    pub number_of_archives: i64,
    /// <p>Total size, in bytes, of the archives in the vault as of the last inventory date. This field will return null if an inventory has not yet run on the vault, for example if you just created the vault.</p>
    pub size_in_bytes: i64,
}
impl DescribeVaultOutput {
    /// <p>The Amazon Resource Name (ARN) of the vault.</p>
    pub fn vault_arn(&self) -> std::option::Option<&str> {
        self.vault_arn.as_deref()
    }
    /// <p>The name of the vault.</p>
    pub fn vault_name(&self) -> std::option::Option<&str> {
        self.vault_name.as_deref()
    }
    /// <p>The Universal Coordinated Time (UTC) date when the vault was created. This value should be a string in the ISO 8601 date format, for example <code>2012-03-20T17:03:43.221Z</code>.</p>
    pub fn creation_date(&self) -> std::option::Option<&str> {
        self.creation_date.as_deref()
    }
    /// <p>The Universal Coordinated Time (UTC) date when Amazon S3 Glacier completed the last vault inventory. This value should be a string in the ISO 8601 date format, for example <code>2012-03-20T17:03:43.221Z</code>.</p>
    pub fn last_inventory_date(&self) -> std::option::Option<&str> {
        self.last_inventory_date.as_deref()
    }
    /// <p>The number of archives in the vault as of the last inventory date. This field will return <code>null</code> if an inventory has not yet run on the vault, for example if you just created the vault.</p>
    pub fn number_of_archives(&self) -> i64 {
        self.number_of_archives
    }
    /// <p>Total size, in bytes, of the archives in the vault as of the last inventory date. This field will return null if an inventory has not yet run on the vault, for example if you just created the vault.</p>
    pub fn size_in_bytes(&self) -> i64 {
        self.size_in_bytes
    }
}
impl std::fmt::Debug for DescribeVaultOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeVaultOutput");
        formatter.field("vault_arn", &self.vault_arn);
        formatter.field("vault_name", &self.vault_name);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_inventory_date", &self.last_inventory_date);
        formatter.field("number_of_archives", &self.number_of_archives);
        formatter.field("size_in_bytes", &self.size_in_bytes);
        formatter.finish()
    }
}
/// See [`DescribeVaultOutput`](crate::model::DescribeVaultOutput)
pub mod describe_vault_output {
    /// A builder for [`DescribeVaultOutput`](crate::model::DescribeVaultOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vault_arn: std::option::Option<std::string::String>,
        pub(crate) vault_name: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<std::string::String>,
        pub(crate) last_inventory_date: std::option::Option<std::string::String>,
        pub(crate) number_of_archives: std::option::Option<i64>,
        pub(crate) size_in_bytes: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the vault.</p>
        pub fn vault_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the vault.</p>
        pub fn set_vault_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_arn = input;
            self
        }
        /// <p>The name of the vault.</p>
        pub fn vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_name = Some(input.into());
            self
        }
        /// <p>The name of the vault.</p>
        pub fn set_vault_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_name = input;
            self
        }
        /// <p>The Universal Coordinated Time (UTC) date when the vault was created. This value should be a string in the ISO 8601 date format, for example <code>2012-03-20T17:03:43.221Z</code>.</p>
        pub fn creation_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_date = Some(input.into());
            self
        }
        /// <p>The Universal Coordinated Time (UTC) date when the vault was created. This value should be a string in the ISO 8601 date format, for example <code>2012-03-20T17:03:43.221Z</code>.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The Universal Coordinated Time (UTC) date when Amazon S3 Glacier completed the last vault inventory. This value should be a string in the ISO 8601 date format, for example <code>2012-03-20T17:03:43.221Z</code>.</p>
        pub fn last_inventory_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_inventory_date = Some(input.into());
            self
        }
        /// <p>The Universal Coordinated Time (UTC) date when Amazon S3 Glacier completed the last vault inventory. This value should be a string in the ISO 8601 date format, for example <code>2012-03-20T17:03:43.221Z</code>.</p>
        pub fn set_last_inventory_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_inventory_date = input;
            self
        }
        /// <p>The number of archives in the vault as of the last inventory date. This field will return <code>null</code> if an inventory has not yet run on the vault, for example if you just created the vault.</p>
        pub fn number_of_archives(mut self, input: i64) -> Self {
            self.number_of_archives = Some(input);
            self
        }
        /// <p>The number of archives in the vault as of the last inventory date. This field will return <code>null</code> if an inventory has not yet run on the vault, for example if you just created the vault.</p>
        pub fn set_number_of_archives(mut self, input: std::option::Option<i64>) -> Self {
            self.number_of_archives = input;
            self
        }
        /// <p>Total size, in bytes, of the archives in the vault as of the last inventory date. This field will return null if an inventory has not yet run on the vault, for example if you just created the vault.</p>
        pub fn size_in_bytes(mut self, input: i64) -> Self {
            self.size_in_bytes = Some(input);
            self
        }
        /// <p>Total size, in bytes, of the archives in the vault as of the last inventory date. This field will return null if an inventory has not yet run on the vault, for example if you just created the vault.</p>
        pub fn set_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.size_in_bytes = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeVaultOutput`](crate::model::DescribeVaultOutput)
        pub fn build(self) -> crate::model::DescribeVaultOutput {
            crate::model::DescribeVaultOutput {
                vault_arn: self.vault_arn,
                vault_name: self.vault_name,
                creation_date: self.creation_date,
                last_inventory_date: self.last_inventory_date,
                number_of_archives: self.number_of_archives.unwrap_or_default(),
                size_in_bytes: self.size_in_bytes.unwrap_or_default(),
            }
        }
    }
}
impl DescribeVaultOutput {
    /// Creates a new builder-style object to manufacture [`DescribeVaultOutput`](crate::model::DescribeVaultOutput)
    pub fn builder() -> crate::model::describe_vault_output::Builder {
        crate::model::describe_vault_output::Builder::default()
    }
}

/// <p>The definition for a provisioned capacity unit.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisionedCapacityDescription {
    /// <p>The ID that identifies the provisioned capacity unit.</p>
    pub capacity_id: std::option::Option<std::string::String>,
    /// <p>The date that the provisioned capacity unit was purchased, in Universal Coordinated Time (UTC).</p>
    pub start_date: std::option::Option<std::string::String>,
    /// <p>The date that the provisioned capacity unit expires, in Universal Coordinated Time (UTC).</p>
    pub expiration_date: std::option::Option<std::string::String>,
}
impl ProvisionedCapacityDescription {
    /// <p>The ID that identifies the provisioned capacity unit.</p>
    pub fn capacity_id(&self) -> std::option::Option<&str> {
        self.capacity_id.as_deref()
    }
    /// <p>The date that the provisioned capacity unit was purchased, in Universal Coordinated Time (UTC).</p>
    pub fn start_date(&self) -> std::option::Option<&str> {
        self.start_date.as_deref()
    }
    /// <p>The date that the provisioned capacity unit expires, in Universal Coordinated Time (UTC).</p>
    pub fn expiration_date(&self) -> std::option::Option<&str> {
        self.expiration_date.as_deref()
    }
}
impl std::fmt::Debug for ProvisionedCapacityDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisionedCapacityDescription");
        formatter.field("capacity_id", &self.capacity_id);
        formatter.field("start_date", &self.start_date);
        formatter.field("expiration_date", &self.expiration_date);
        formatter.finish()
    }
}
/// See [`ProvisionedCapacityDescription`](crate::model::ProvisionedCapacityDescription)
pub mod provisioned_capacity_description {
    /// A builder for [`ProvisionedCapacityDescription`](crate::model::ProvisionedCapacityDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) capacity_id: std::option::Option<std::string::String>,
        pub(crate) start_date: std::option::Option<std::string::String>,
        pub(crate) expiration_date: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID that identifies the provisioned capacity unit.</p>
        pub fn capacity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.capacity_id = Some(input.into());
            self
        }
        /// <p>The ID that identifies the provisioned capacity unit.</p>
        pub fn set_capacity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.capacity_id = input;
            self
        }
        /// <p>The date that the provisioned capacity unit was purchased, in Universal Coordinated Time (UTC).</p>
        pub fn start_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_date = Some(input.into());
            self
        }
        /// <p>The date that the provisioned capacity unit was purchased, in Universal Coordinated Time (UTC).</p>
        pub fn set_start_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start_date = input;
            self
        }
        /// <p>The date that the provisioned capacity unit expires, in Universal Coordinated Time (UTC).</p>
        pub fn expiration_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.expiration_date = Some(input.into());
            self
        }
        /// <p>The date that the provisioned capacity unit expires, in Universal Coordinated Time (UTC).</p>
        pub fn set_expiration_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expiration_date = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisionedCapacityDescription`](crate::model::ProvisionedCapacityDescription)
        pub fn build(self) -> crate::model::ProvisionedCapacityDescription {
            crate::model::ProvisionedCapacityDescription {
                capacity_id: self.capacity_id,
                start_date: self.start_date,
                expiration_date: self.expiration_date,
            }
        }
    }
}
impl ProvisionedCapacityDescription {
    /// Creates a new builder-style object to manufacture [`ProvisionedCapacityDescription`](crate::model::ProvisionedCapacityDescription)
    pub fn builder() -> crate::model::provisioned_capacity_description::Builder {
        crate::model::provisioned_capacity_description::Builder::default()
    }
}

/// <p>A list of the part sizes of the multipart upload.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PartListElement {
    /// <p>The byte range of a part, inclusive of the upper value of the range.</p>
    pub range_in_bytes: std::option::Option<std::string::String>,
    /// <p>The SHA256 tree hash value that Amazon S3 Glacier calculated for the part. This field is never <code>null</code>.</p>
    pub sha256_tree_hash: std::option::Option<std::string::String>,
}
impl PartListElement {
    /// <p>The byte range of a part, inclusive of the upper value of the range.</p>
    pub fn range_in_bytes(&self) -> std::option::Option<&str> {
        self.range_in_bytes.as_deref()
    }
    /// <p>The SHA256 tree hash value that Amazon S3 Glacier calculated for the part. This field is never <code>null</code>.</p>
    pub fn sha256_tree_hash(&self) -> std::option::Option<&str> {
        self.sha256_tree_hash.as_deref()
    }
}
impl std::fmt::Debug for PartListElement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PartListElement");
        formatter.field("range_in_bytes", &self.range_in_bytes);
        formatter.field("sha256_tree_hash", &self.sha256_tree_hash);
        formatter.finish()
    }
}
/// See [`PartListElement`](crate::model::PartListElement)
pub mod part_list_element {
    /// A builder for [`PartListElement`](crate::model::PartListElement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) range_in_bytes: std::option::Option<std::string::String>,
        pub(crate) sha256_tree_hash: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The byte range of a part, inclusive of the upper value of the range.</p>
        pub fn range_in_bytes(mut self, input: impl Into<std::string::String>) -> Self {
            self.range_in_bytes = Some(input.into());
            self
        }
        /// <p>The byte range of a part, inclusive of the upper value of the range.</p>
        pub fn set_range_in_bytes(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.range_in_bytes = input;
            self
        }
        /// <p>The SHA256 tree hash value that Amazon S3 Glacier calculated for the part. This field is never <code>null</code>.</p>
        pub fn sha256_tree_hash(mut self, input: impl Into<std::string::String>) -> Self {
            self.sha256_tree_hash = Some(input.into());
            self
        }
        /// <p>The SHA256 tree hash value that Amazon S3 Glacier calculated for the part. This field is never <code>null</code>.</p>
        pub fn set_sha256_tree_hash(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sha256_tree_hash = input;
            self
        }
        /// Consumes the builder and constructs a [`PartListElement`](crate::model::PartListElement)
        pub fn build(self) -> crate::model::PartListElement {
            crate::model::PartListElement {
                range_in_bytes: self.range_in_bytes,
                sha256_tree_hash: self.sha256_tree_hash,
            }
        }
    }
}
impl PartListElement {
    /// Creates a new builder-style object to manufacture [`PartListElement`](crate::model::PartListElement)
    pub fn builder() -> crate::model::part_list_element::Builder {
        crate::model::part_list_element::Builder::default()
    }
}

/// <p>A list of in-progress multipart uploads for a vault.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UploadListElement {
    /// <p>The ID of a multipart upload.</p>
    pub multipart_upload_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the vault that contains the archive.</p>
    pub vault_arn: std::option::Option<std::string::String>,
    /// <p>The description of the archive that was specified in the Initiate Multipart Upload request.</p>
    pub archive_description: std::option::Option<std::string::String>,
    /// <p>The part size, in bytes, specified in the Initiate Multipart Upload request. This is the size of all the parts in the upload except the last part, which may be smaller than this size.</p>
    pub part_size_in_bytes: i64,
    /// <p>The UTC time at which the multipart upload was initiated.</p>
    pub creation_date: std::option::Option<std::string::String>,
}
impl UploadListElement {
    /// <p>The ID of a multipart upload.</p>
    pub fn multipart_upload_id(&self) -> std::option::Option<&str> {
        self.multipart_upload_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the vault that contains the archive.</p>
    pub fn vault_arn(&self) -> std::option::Option<&str> {
        self.vault_arn.as_deref()
    }
    /// <p>The description of the archive that was specified in the Initiate Multipart Upload request.</p>
    pub fn archive_description(&self) -> std::option::Option<&str> {
        self.archive_description.as_deref()
    }
    /// <p>The part size, in bytes, specified in the Initiate Multipart Upload request. This is the size of all the parts in the upload except the last part, which may be smaller than this size.</p>
    pub fn part_size_in_bytes(&self) -> i64 {
        self.part_size_in_bytes
    }
    /// <p>The UTC time at which the multipart upload was initiated.</p>
    pub fn creation_date(&self) -> std::option::Option<&str> {
        self.creation_date.as_deref()
    }
}
impl std::fmt::Debug for UploadListElement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UploadListElement");
        formatter.field("multipart_upload_id", &self.multipart_upload_id);
        formatter.field("vault_arn", &self.vault_arn);
        formatter.field("archive_description", &self.archive_description);
        formatter.field("part_size_in_bytes", &self.part_size_in_bytes);
        formatter.field("creation_date", &self.creation_date);
        formatter.finish()
    }
}
/// See [`UploadListElement`](crate::model::UploadListElement)
pub mod upload_list_element {
    /// A builder for [`UploadListElement`](crate::model::UploadListElement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) multipart_upload_id: std::option::Option<std::string::String>,
        pub(crate) vault_arn: std::option::Option<std::string::String>,
        pub(crate) archive_description: std::option::Option<std::string::String>,
        pub(crate) part_size_in_bytes: std::option::Option<i64>,
        pub(crate) creation_date: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of a multipart upload.</p>
        pub fn multipart_upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.multipart_upload_id = Some(input.into());
            self
        }
        /// <p>The ID of a multipart upload.</p>
        pub fn set_multipart_upload_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.multipart_upload_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the vault that contains the archive.</p>
        pub fn vault_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the vault that contains the archive.</p>
        pub fn set_vault_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_arn = input;
            self
        }
        /// <p>The description of the archive that was specified in the Initiate Multipart Upload request.</p>
        pub fn archive_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.archive_description = Some(input.into());
            self
        }
        /// <p>The description of the archive that was specified in the Initiate Multipart Upload request.</p>
        pub fn set_archive_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.archive_description = input;
            self
        }
        /// <p>The part size, in bytes, specified in the Initiate Multipart Upload request. This is the size of all the parts in the upload except the last part, which may be smaller than this size.</p>
        pub fn part_size_in_bytes(mut self, input: i64) -> Self {
            self.part_size_in_bytes = Some(input);
            self
        }
        /// <p>The part size, in bytes, specified in the Initiate Multipart Upload request. This is the size of all the parts in the upload except the last part, which may be smaller than this size.</p>
        pub fn set_part_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.part_size_in_bytes = input;
            self
        }
        /// <p>The UTC time at which the multipart upload was initiated.</p>
        pub fn creation_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_date = Some(input.into());
            self
        }
        /// <p>The UTC time at which the multipart upload was initiated.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// Consumes the builder and constructs a [`UploadListElement`](crate::model::UploadListElement)
        pub fn build(self) -> crate::model::UploadListElement {
            crate::model::UploadListElement {
                multipart_upload_id: self.multipart_upload_id,
                vault_arn: self.vault_arn,
                archive_description: self.archive_description,
                part_size_in_bytes: self.part_size_in_bytes.unwrap_or_default(),
                creation_date: self.creation_date,
            }
        }
    }
}
impl UploadListElement {
    /// Creates a new builder-style object to manufacture [`UploadListElement`](crate::model::UploadListElement)
    pub fn builder() -> crate::model::upload_list_element::Builder {
        crate::model::upload_list_element::Builder::default()
    }
}

/// <p>Contains the description of an Amazon S3 Glacier job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GlacierJobDescription {
    /// <p>An opaque string that identifies an Amazon S3 Glacier job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The job description provided when initiating the job.</p>
    pub job_description: std::option::Option<std::string::String>,
    /// <p>The job type. This value is either <code>ArchiveRetrieval</code>, <code>InventoryRetrieval</code>, or <code>Select</code>. </p>
    pub action: std::option::Option<crate::model::ActionCode>,
    /// <p>The archive ID requested for a select job or archive retrieval. Otherwise, this field is null.</p>
    pub archive_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the vault from which an archive retrieval was requested.</p>
    pub vault_arn: std::option::Option<std::string::String>,
    /// <p>The UTC date when the job was created. This value is a string representation of ISO 8601 date format, for example <code>"2012-03-20T17:03:43.221Z"</code>.</p>
    pub creation_date: std::option::Option<std::string::String>,
    /// <p>The job status. When a job is completed, you get the job's output using Get Job Output (GET output).</p>
    pub completed: bool,
    /// <p>The status code can be <code>InProgress</code>, <code>Succeeded</code>, or <code>Failed</code>, and indicates the status of the job.</p>
    pub status_code: std::option::Option<crate::model::StatusCode>,
    /// <p>A friendly message that describes the job status.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>For an archive retrieval job, this value is the size in bytes of the archive being requested for download. For an inventory retrieval or select job, this value is null.</p>
    pub archive_size_in_bytes: std::option::Option<i64>,
    /// <p>For an inventory retrieval job, this value is the size in bytes of the inventory requested for download. For an archive retrieval or select job, this value is null.</p>
    pub inventory_size_in_bytes: std::option::Option<i64>,
    /// <p>An Amazon SNS topic that receives notification.</p>
    pub sns_topic: std::option::Option<std::string::String>,
    /// <p>The UTC time that the job request completed. While the job is in progress, the value is null.</p>
    pub completion_date: std::option::Option<std::string::String>,
    /// <p>For an archive retrieval job, this value is the checksum of the archive. Otherwise, this value is null.</p>
    /// <p>The SHA256 tree hash value for the requested range of an archive. If the <b>InitiateJob</b> request for an archive specified a tree-hash aligned range, then this field returns a value.</p>
    /// <p>If the whole archive is retrieved, this value is the same as the ArchiveSHA256TreeHash value.</p>
    /// <p>This field is null for the following:</p>
    /// <ul>
    /// <li> <p>Archive retrieval jobs that specify a range that is not tree-hash aligned</p> </li>
    /// </ul>
    /// <ul>
    /// <li> <p>Archival jobs that specify a range that is equal to the whole archive, when the job status is <code>InProgress</code> </p> </li>
    /// </ul>
    /// <ul>
    /// <li> <p>Inventory jobs</p> </li>
    /// <li> <p>Select jobs</p> </li>
    /// </ul>
    pub sha256_tree_hash: std::option::Option<std::string::String>,
    /// <p>The SHA256 tree hash of the entire archive for an archive retrieval. For inventory retrieval or select jobs, this field is null.</p>
    pub archive_sha256_tree_hash: std::option::Option<std::string::String>,
    /// <p>The retrieved byte range for archive retrieval jobs in the form <i>StartByteValue</i>-<i>EndByteValue</i>. If no range was specified in the archive retrieval, then the whole archive is retrieved. In this case, <i>StartByteValue</i> equals 0 and <i>EndByteValue</i> equals the size of the archive minus 1. For inventory retrieval or select jobs, this field is null. </p>
    pub retrieval_byte_range: std::option::Option<std::string::String>,
    /// <p>The tier to use for a select or an archive retrieval. Valid values are <code>Expedited</code>, <code>Standard</code>, or <code>Bulk</code>. <code>Standard</code> is the default.</p>
    pub tier: std::option::Option<std::string::String>,
    /// <p>Parameters used for range inventory retrieval.</p>
    pub inventory_retrieval_parameters:
        std::option::Option<crate::model::InventoryRetrievalJobDescription>,
    /// <p>Contains the job output location.</p>
    pub job_output_path: std::option::Option<std::string::String>,
    /// <p>Contains the parameters used for a select.</p>
    pub select_parameters: std::option::Option<crate::model::SelectParameters>,
    /// <p>Contains the location where the data from the select job is stored.</p>
    pub output_location: std::option::Option<crate::model::OutputLocation>,
}
impl GlacierJobDescription {
    /// <p>An opaque string that identifies an Amazon S3 Glacier job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The job description provided when initiating the job.</p>
    pub fn job_description(&self) -> std::option::Option<&str> {
        self.job_description.as_deref()
    }
    /// <p>The job type. This value is either <code>ArchiveRetrieval</code>, <code>InventoryRetrieval</code>, or <code>Select</code>. </p>
    pub fn action(&self) -> std::option::Option<&crate::model::ActionCode> {
        self.action.as_ref()
    }
    /// <p>The archive ID requested for a select job or archive retrieval. Otherwise, this field is null.</p>
    pub fn archive_id(&self) -> std::option::Option<&str> {
        self.archive_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the vault from which an archive retrieval was requested.</p>
    pub fn vault_arn(&self) -> std::option::Option<&str> {
        self.vault_arn.as_deref()
    }
    /// <p>The UTC date when the job was created. This value is a string representation of ISO 8601 date format, for example <code>"2012-03-20T17:03:43.221Z"</code>.</p>
    pub fn creation_date(&self) -> std::option::Option<&str> {
        self.creation_date.as_deref()
    }
    /// <p>The job status. When a job is completed, you get the job's output using Get Job Output (GET output).</p>
    pub fn completed(&self) -> bool {
        self.completed
    }
    /// <p>The status code can be <code>InProgress</code>, <code>Succeeded</code>, or <code>Failed</code>, and indicates the status of the job.</p>
    pub fn status_code(&self) -> std::option::Option<&crate::model::StatusCode> {
        self.status_code.as_ref()
    }
    /// <p>A friendly message that describes the job status.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>For an archive retrieval job, this value is the size in bytes of the archive being requested for download. For an inventory retrieval or select job, this value is null.</p>
    pub fn archive_size_in_bytes(&self) -> std::option::Option<i64> {
        self.archive_size_in_bytes
    }
    /// <p>For an inventory retrieval job, this value is the size in bytes of the inventory requested for download. For an archive retrieval or select job, this value is null.</p>
    pub fn inventory_size_in_bytes(&self) -> std::option::Option<i64> {
        self.inventory_size_in_bytes
    }
    /// <p>An Amazon SNS topic that receives notification.</p>
    pub fn sns_topic(&self) -> std::option::Option<&str> {
        self.sns_topic.as_deref()
    }
    /// <p>The UTC time that the job request completed. While the job is in progress, the value is null.</p>
    pub fn completion_date(&self) -> std::option::Option<&str> {
        self.completion_date.as_deref()
    }
    /// <p>For an archive retrieval job, this value is the checksum of the archive. Otherwise, this value is null.</p>
    /// <p>The SHA256 tree hash value for the requested range of an archive. If the <b>InitiateJob</b> request for an archive specified a tree-hash aligned range, then this field returns a value.</p>
    /// <p>If the whole archive is retrieved, this value is the same as the ArchiveSHA256TreeHash value.</p>
    /// <p>This field is null for the following:</p>
    /// <ul>
    /// <li> <p>Archive retrieval jobs that specify a range that is not tree-hash aligned</p> </li>
    /// </ul>
    /// <ul>
    /// <li> <p>Archival jobs that specify a range that is equal to the whole archive, when the job status is <code>InProgress</code> </p> </li>
    /// </ul>
    /// <ul>
    /// <li> <p>Inventory jobs</p> </li>
    /// <li> <p>Select jobs</p> </li>
    /// </ul>
    pub fn sha256_tree_hash(&self) -> std::option::Option<&str> {
        self.sha256_tree_hash.as_deref()
    }
    /// <p>The SHA256 tree hash of the entire archive for an archive retrieval. For inventory retrieval or select jobs, this field is null.</p>
    pub fn archive_sha256_tree_hash(&self) -> std::option::Option<&str> {
        self.archive_sha256_tree_hash.as_deref()
    }
    /// <p>The retrieved byte range for archive retrieval jobs in the form <i>StartByteValue</i>-<i>EndByteValue</i>. If no range was specified in the archive retrieval, then the whole archive is retrieved. In this case, <i>StartByteValue</i> equals 0 and <i>EndByteValue</i> equals the size of the archive minus 1. For inventory retrieval or select jobs, this field is null. </p>
    pub fn retrieval_byte_range(&self) -> std::option::Option<&str> {
        self.retrieval_byte_range.as_deref()
    }
    /// <p>The tier to use for a select or an archive retrieval. Valid values are <code>Expedited</code>, <code>Standard</code>, or <code>Bulk</code>. <code>Standard</code> is the default.</p>
    pub fn tier(&self) -> std::option::Option<&str> {
        self.tier.as_deref()
    }
    /// <p>Parameters used for range inventory retrieval.</p>
    pub fn inventory_retrieval_parameters(
        &self,
    ) -> std::option::Option<&crate::model::InventoryRetrievalJobDescription> {
        self.inventory_retrieval_parameters.as_ref()
    }
    /// <p>Contains the job output location.</p>
    pub fn job_output_path(&self) -> std::option::Option<&str> {
        self.job_output_path.as_deref()
    }
    /// <p>Contains the parameters used for a select.</p>
    pub fn select_parameters(&self) -> std::option::Option<&crate::model::SelectParameters> {
        self.select_parameters.as_ref()
    }
    /// <p>Contains the location where the data from the select job is stored.</p>
    pub fn output_location(&self) -> std::option::Option<&crate::model::OutputLocation> {
        self.output_location.as_ref()
    }
}
impl std::fmt::Debug for GlacierJobDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GlacierJobDescription");
        formatter.field("job_id", &self.job_id);
        formatter.field("job_description", &self.job_description);
        formatter.field("action", &self.action);
        formatter.field("archive_id", &self.archive_id);
        formatter.field("vault_arn", &self.vault_arn);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("completed", &self.completed);
        formatter.field("status_code", &self.status_code);
        formatter.field("status_message", &self.status_message);
        formatter.field("archive_size_in_bytes", &self.archive_size_in_bytes);
        formatter.field("inventory_size_in_bytes", &self.inventory_size_in_bytes);
        formatter.field("sns_topic", &self.sns_topic);
        formatter.field("completion_date", &self.completion_date);
        formatter.field("sha256_tree_hash", &self.sha256_tree_hash);
        formatter.field("archive_sha256_tree_hash", &self.archive_sha256_tree_hash);
        formatter.field("retrieval_byte_range", &self.retrieval_byte_range);
        formatter.field("tier", &self.tier);
        formatter.field(
            "inventory_retrieval_parameters",
            &self.inventory_retrieval_parameters,
        );
        formatter.field("job_output_path", &self.job_output_path);
        formatter.field("select_parameters", &self.select_parameters);
        formatter.field("output_location", &self.output_location);
        formatter.finish()
    }
}
/// See [`GlacierJobDescription`](crate::model::GlacierJobDescription)
pub mod glacier_job_description {
    /// A builder for [`GlacierJobDescription`](crate::model::GlacierJobDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) job_description: std::option::Option<std::string::String>,
        pub(crate) action: std::option::Option<crate::model::ActionCode>,
        pub(crate) archive_id: std::option::Option<std::string::String>,
        pub(crate) vault_arn: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<std::string::String>,
        pub(crate) completed: std::option::Option<bool>,
        pub(crate) status_code: std::option::Option<crate::model::StatusCode>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) archive_size_in_bytes: std::option::Option<i64>,
        pub(crate) inventory_size_in_bytes: std::option::Option<i64>,
        pub(crate) sns_topic: std::option::Option<std::string::String>,
        pub(crate) completion_date: std::option::Option<std::string::String>,
        pub(crate) sha256_tree_hash: std::option::Option<std::string::String>,
        pub(crate) archive_sha256_tree_hash: std::option::Option<std::string::String>,
        pub(crate) retrieval_byte_range: std::option::Option<std::string::String>,
        pub(crate) tier: std::option::Option<std::string::String>,
        pub(crate) inventory_retrieval_parameters:
            std::option::Option<crate::model::InventoryRetrievalJobDescription>,
        pub(crate) job_output_path: std::option::Option<std::string::String>,
        pub(crate) select_parameters: std::option::Option<crate::model::SelectParameters>,
        pub(crate) output_location: std::option::Option<crate::model::OutputLocation>,
    }
    impl Builder {
        /// <p>An opaque string that identifies an Amazon S3 Glacier job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>An opaque string that identifies an Amazon S3 Glacier job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The job description provided when initiating the job.</p>
        pub fn job_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_description = Some(input.into());
            self
        }
        /// <p>The job description provided when initiating the job.</p>
        pub fn set_job_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_description = input;
            self
        }
        /// <p>The job type. This value is either <code>ArchiveRetrieval</code>, <code>InventoryRetrieval</code>, or <code>Select</code>. </p>
        pub fn action(mut self, input: crate::model::ActionCode) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The job type. This value is either <code>ArchiveRetrieval</code>, <code>InventoryRetrieval</code>, or <code>Select</code>. </p>
        pub fn set_action(mut self, input: std::option::Option<crate::model::ActionCode>) -> Self {
            self.action = input;
            self
        }
        /// <p>The archive ID requested for a select job or archive retrieval. Otherwise, this field is null.</p>
        pub fn archive_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.archive_id = Some(input.into());
            self
        }
        /// <p>The archive ID requested for a select job or archive retrieval. Otherwise, this field is null.</p>
        pub fn set_archive_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.archive_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the vault from which an archive retrieval was requested.</p>
        pub fn vault_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the vault from which an archive retrieval was requested.</p>
        pub fn set_vault_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_arn = input;
            self
        }
        /// <p>The UTC date when the job was created. This value is a string representation of ISO 8601 date format, for example <code>"2012-03-20T17:03:43.221Z"</code>.</p>
        pub fn creation_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_date = Some(input.into());
            self
        }
        /// <p>The UTC date when the job was created. This value is a string representation of ISO 8601 date format, for example <code>"2012-03-20T17:03:43.221Z"</code>.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The job status. When a job is completed, you get the job's output using Get Job Output (GET output).</p>
        pub fn completed(mut self, input: bool) -> Self {
            self.completed = Some(input);
            self
        }
        /// <p>The job status. When a job is completed, you get the job's output using Get Job Output (GET output).</p>
        pub fn set_completed(mut self, input: std::option::Option<bool>) -> Self {
            self.completed = input;
            self
        }
        /// <p>The status code can be <code>InProgress</code>, <code>Succeeded</code>, or <code>Failed</code>, and indicates the status of the job.</p>
        pub fn status_code(mut self, input: crate::model::StatusCode) -> Self {
            self.status_code = Some(input);
            self
        }
        /// <p>The status code can be <code>InProgress</code>, <code>Succeeded</code>, or <code>Failed</code>, and indicates the status of the job.</p>
        pub fn set_status_code(
            mut self,
            input: std::option::Option<crate::model::StatusCode>,
        ) -> Self {
            self.status_code = input;
            self
        }
        /// <p>A friendly message that describes the job status.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>A friendly message that describes the job status.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>For an archive retrieval job, this value is the size in bytes of the archive being requested for download. For an inventory retrieval or select job, this value is null.</p>
        pub fn archive_size_in_bytes(mut self, input: i64) -> Self {
            self.archive_size_in_bytes = Some(input);
            self
        }
        /// <p>For an archive retrieval job, this value is the size in bytes of the archive being requested for download. For an inventory retrieval or select job, this value is null.</p>
        pub fn set_archive_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.archive_size_in_bytes = input;
            self
        }
        /// <p>For an inventory retrieval job, this value is the size in bytes of the inventory requested for download. For an archive retrieval or select job, this value is null.</p>
        pub fn inventory_size_in_bytes(mut self, input: i64) -> Self {
            self.inventory_size_in_bytes = Some(input);
            self
        }
        /// <p>For an inventory retrieval job, this value is the size in bytes of the inventory requested for download. For an archive retrieval or select job, this value is null.</p>
        pub fn set_inventory_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.inventory_size_in_bytes = input;
            self
        }
        /// <p>An Amazon SNS topic that receives notification.</p>
        pub fn sns_topic(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic = Some(input.into());
            self
        }
        /// <p>An Amazon SNS topic that receives notification.</p>
        pub fn set_sns_topic(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sns_topic = input;
            self
        }
        /// <p>The UTC time that the job request completed. While the job is in progress, the value is null.</p>
        pub fn completion_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.completion_date = Some(input.into());
            self
        }
        /// <p>The UTC time that the job request completed. While the job is in progress, the value is null.</p>
        pub fn set_completion_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.completion_date = input;
            self
        }
        /// <p>For an archive retrieval job, this value is the checksum of the archive. Otherwise, this value is null.</p>
        /// <p>The SHA256 tree hash value for the requested range of an archive. If the <b>InitiateJob</b> request for an archive specified a tree-hash aligned range, then this field returns a value.</p>
        /// <p>If the whole archive is retrieved, this value is the same as the ArchiveSHA256TreeHash value.</p>
        /// <p>This field is null for the following:</p>
        /// <ul>
        /// <li> <p>Archive retrieval jobs that specify a range that is not tree-hash aligned</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p>Archival jobs that specify a range that is equal to the whole archive, when the job status is <code>InProgress</code> </p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p>Inventory jobs</p> </li>
        /// <li> <p>Select jobs</p> </li>
        /// </ul>
        pub fn sha256_tree_hash(mut self, input: impl Into<std::string::String>) -> Self {
            self.sha256_tree_hash = Some(input.into());
            self
        }
        /// <p>For an archive retrieval job, this value is the checksum of the archive. Otherwise, this value is null.</p>
        /// <p>The SHA256 tree hash value for the requested range of an archive. If the <b>InitiateJob</b> request for an archive specified a tree-hash aligned range, then this field returns a value.</p>
        /// <p>If the whole archive is retrieved, this value is the same as the ArchiveSHA256TreeHash value.</p>
        /// <p>This field is null for the following:</p>
        /// <ul>
        /// <li> <p>Archive retrieval jobs that specify a range that is not tree-hash aligned</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p>Archival jobs that specify a range that is equal to the whole archive, when the job status is <code>InProgress</code> </p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p>Inventory jobs</p> </li>
        /// <li> <p>Select jobs</p> </li>
        /// </ul>
        pub fn set_sha256_tree_hash(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sha256_tree_hash = input;
            self
        }
        /// <p>The SHA256 tree hash of the entire archive for an archive retrieval. For inventory retrieval or select jobs, this field is null.</p>
        pub fn archive_sha256_tree_hash(mut self, input: impl Into<std::string::String>) -> Self {
            self.archive_sha256_tree_hash = Some(input.into());
            self
        }
        /// <p>The SHA256 tree hash of the entire archive for an archive retrieval. For inventory retrieval or select jobs, this field is null.</p>
        pub fn set_archive_sha256_tree_hash(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.archive_sha256_tree_hash = input;
            self
        }
        /// <p>The retrieved byte range for archive retrieval jobs in the form <i>StartByteValue</i>-<i>EndByteValue</i>. If no range was specified in the archive retrieval, then the whole archive is retrieved. In this case, <i>StartByteValue</i> equals 0 and <i>EndByteValue</i> equals the size of the archive minus 1. For inventory retrieval or select jobs, this field is null. </p>
        pub fn retrieval_byte_range(mut self, input: impl Into<std::string::String>) -> Self {
            self.retrieval_byte_range = Some(input.into());
            self
        }
        /// <p>The retrieved byte range for archive retrieval jobs in the form <i>StartByteValue</i>-<i>EndByteValue</i>. If no range was specified in the archive retrieval, then the whole archive is retrieved. In this case, <i>StartByteValue</i> equals 0 and <i>EndByteValue</i> equals the size of the archive minus 1. For inventory retrieval or select jobs, this field is null. </p>
        pub fn set_retrieval_byte_range(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.retrieval_byte_range = input;
            self
        }
        /// <p>The tier to use for a select or an archive retrieval. Valid values are <code>Expedited</code>, <code>Standard</code>, or <code>Bulk</code>. <code>Standard</code> is the default.</p>
        pub fn tier(mut self, input: impl Into<std::string::String>) -> Self {
            self.tier = Some(input.into());
            self
        }
        /// <p>The tier to use for a select or an archive retrieval. Valid values are <code>Expedited</code>, <code>Standard</code>, or <code>Bulk</code>. <code>Standard</code> is the default.</p>
        pub fn set_tier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tier = input;
            self
        }
        /// <p>Parameters used for range inventory retrieval.</p>
        pub fn inventory_retrieval_parameters(
            mut self,
            input: crate::model::InventoryRetrievalJobDescription,
        ) -> Self {
            self.inventory_retrieval_parameters = Some(input);
            self
        }
        /// <p>Parameters used for range inventory retrieval.</p>
        pub fn set_inventory_retrieval_parameters(
            mut self,
            input: std::option::Option<crate::model::InventoryRetrievalJobDescription>,
        ) -> Self {
            self.inventory_retrieval_parameters = input;
            self
        }
        /// <p>Contains the job output location.</p>
        pub fn job_output_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_output_path = Some(input.into());
            self
        }
        /// <p>Contains the job output location.</p>
        pub fn set_job_output_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_output_path = input;
            self
        }
        /// <p>Contains the parameters used for a select.</p>
        pub fn select_parameters(mut self, input: crate::model::SelectParameters) -> Self {
            self.select_parameters = Some(input);
            self
        }
        /// <p>Contains the parameters used for a select.</p>
        pub fn set_select_parameters(
            mut self,
            input: std::option::Option<crate::model::SelectParameters>,
        ) -> Self {
            self.select_parameters = input;
            self
        }
        /// <p>Contains the location where the data from the select job is stored.</p>
        pub fn output_location(mut self, input: crate::model::OutputLocation) -> Self {
            self.output_location = Some(input);
            self
        }
        /// <p>Contains the location where the data from the select job is stored.</p>
        pub fn set_output_location(
            mut self,
            input: std::option::Option<crate::model::OutputLocation>,
        ) -> Self {
            self.output_location = input;
            self
        }
        /// Consumes the builder and constructs a [`GlacierJobDescription`](crate::model::GlacierJobDescription)
        pub fn build(self) -> crate::model::GlacierJobDescription {
            crate::model::GlacierJobDescription {
                job_id: self.job_id,
                job_description: self.job_description,
                action: self.action,
                archive_id: self.archive_id,
                vault_arn: self.vault_arn,
                creation_date: self.creation_date,
                completed: self.completed.unwrap_or_default(),
                status_code: self.status_code,
                status_message: self.status_message,
                archive_size_in_bytes: self.archive_size_in_bytes,
                inventory_size_in_bytes: self.inventory_size_in_bytes,
                sns_topic: self.sns_topic,
                completion_date: self.completion_date,
                sha256_tree_hash: self.sha256_tree_hash,
                archive_sha256_tree_hash: self.archive_sha256_tree_hash,
                retrieval_byte_range: self.retrieval_byte_range,
                tier: self.tier,
                inventory_retrieval_parameters: self.inventory_retrieval_parameters,
                job_output_path: self.job_output_path,
                select_parameters: self.select_parameters,
                output_location: self.output_location,
            }
        }
    }
}
impl GlacierJobDescription {
    /// Creates a new builder-style object to manufacture [`GlacierJobDescription`](crate::model::GlacierJobDescription)
    pub fn builder() -> crate::model::glacier_job_description::Builder {
        crate::model::glacier_job_description::Builder::default()
    }
}

/// <p>Contains information about the location where the select job results are stored.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutputLocation {
    /// <p>Describes an S3 location that will receive the results of the job request.</p>
    pub s3: std::option::Option<crate::model::S3Location>,
}
impl OutputLocation {
    /// <p>Describes an S3 location that will receive the results of the job request.</p>
    pub fn s3(&self) -> std::option::Option<&crate::model::S3Location> {
        self.s3.as_ref()
    }
}
impl std::fmt::Debug for OutputLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutputLocation");
        formatter.field("s3", &self.s3);
        formatter.finish()
    }
}
/// See [`OutputLocation`](crate::model::OutputLocation)
pub mod output_location {
    /// A builder for [`OutputLocation`](crate::model::OutputLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3: std::option::Option<crate::model::S3Location>,
    }
    impl Builder {
        /// <p>Describes an S3 location that will receive the results of the job request.</p>
        pub fn s3(mut self, input: crate::model::S3Location) -> Self {
            self.s3 = Some(input);
            self
        }
        /// <p>Describes an S3 location that will receive the results of the job request.</p>
        pub fn set_s3(mut self, input: std::option::Option<crate::model::S3Location>) -> Self {
            self.s3 = input;
            self
        }
        /// Consumes the builder and constructs a [`OutputLocation`](crate::model::OutputLocation)
        pub fn build(self) -> crate::model::OutputLocation {
            crate::model::OutputLocation { s3: self.s3 }
        }
    }
}
impl OutputLocation {
    /// Creates a new builder-style object to manufacture [`OutputLocation`](crate::model::OutputLocation)
    pub fn builder() -> crate::model::output_location::Builder {
        crate::model::output_location::Builder::default()
    }
}

/// <p>Contains information about the location in Amazon S3 where the select job results are stored.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Location {
    /// <p>The name of the Amazon S3 bucket where the job results are stored.</p>
    pub bucket_name: std::option::Option<std::string::String>,
    /// <p>The prefix that is prepended to the results for this request.</p>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>Contains information about the encryption used to store the job results in Amazon S3.</p>
    pub encryption: std::option::Option<crate::model::Encryption>,
    /// <p>The canned access control list (ACL) to apply to the job results.</p>
    pub canned_acl: std::option::Option<crate::model::CannedAcl>,
    /// <p>A list of grants that control access to the staged results.</p>
    pub access_control_list: std::option::Option<std::vec::Vec<crate::model::Grant>>,
    /// <p>The tag-set that is applied to the job results.</p>
    pub tagging:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A map of metadata to store with the job results in Amazon S3.</p>
    pub user_metadata:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The storage class used to store the job results.</p>
    pub storage_class: std::option::Option<crate::model::StorageClass>,
}
impl S3Location {
    /// <p>The name of the Amazon S3 bucket where the job results are stored.</p>
    pub fn bucket_name(&self) -> std::option::Option<&str> {
        self.bucket_name.as_deref()
    }
    /// <p>The prefix that is prepended to the results for this request.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>Contains information about the encryption used to store the job results in Amazon S3.</p>
    pub fn encryption(&self) -> std::option::Option<&crate::model::Encryption> {
        self.encryption.as_ref()
    }
    /// <p>The canned access control list (ACL) to apply to the job results.</p>
    pub fn canned_acl(&self) -> std::option::Option<&crate::model::CannedAcl> {
        self.canned_acl.as_ref()
    }
    /// <p>A list of grants that control access to the staged results.</p>
    pub fn access_control_list(&self) -> std::option::Option<&[crate::model::Grant]> {
        self.access_control_list.as_deref()
    }
    /// <p>The tag-set that is applied to the job results.</p>
    pub fn tagging(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tagging.as_ref()
    }
    /// <p>A map of metadata to store with the job results in Amazon S3.</p>
    pub fn user_metadata(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.user_metadata.as_ref()
    }
    /// <p>The storage class used to store the job results.</p>
    pub fn storage_class(&self) -> std::option::Option<&crate::model::StorageClass> {
        self.storage_class.as_ref()
    }
}
impl std::fmt::Debug for S3Location {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Location");
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("prefix", &self.prefix);
        formatter.field("encryption", &self.encryption);
        formatter.field("canned_acl", &self.canned_acl);
        formatter.field("access_control_list", &self.access_control_list);
        formatter.field("tagging", &self.tagging);
        formatter.field("user_metadata", &self.user_metadata);
        formatter.field("storage_class", &self.storage_class);
        formatter.finish()
    }
}
/// See [`S3Location`](crate::model::S3Location)
pub mod s3_location {
    /// A builder for [`S3Location`](crate::model::S3Location)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) encryption: std::option::Option<crate::model::Encryption>,
        pub(crate) canned_acl: std::option::Option<crate::model::CannedAcl>,
        pub(crate) access_control_list: std::option::Option<std::vec::Vec<crate::model::Grant>>,
        pub(crate) tagging: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) user_metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) storage_class: std::option::Option<crate::model::StorageClass>,
    }
    impl Builder {
        /// <p>The name of the Amazon S3 bucket where the job results are stored.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket where the job results are stored.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p>The prefix that is prepended to the results for this request.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>The prefix that is prepended to the results for this request.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>Contains information about the encryption used to store the job results in Amazon S3.</p>
        pub fn encryption(mut self, input: crate::model::Encryption) -> Self {
            self.encryption = Some(input);
            self
        }
        /// <p>Contains information about the encryption used to store the job results in Amazon S3.</p>
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::Encryption>,
        ) -> Self {
            self.encryption = input;
            self
        }
        /// <p>The canned access control list (ACL) to apply to the job results.</p>
        pub fn canned_acl(mut self, input: crate::model::CannedAcl) -> Self {
            self.canned_acl = Some(input);
            self
        }
        /// <p>The canned access control list (ACL) to apply to the job results.</p>
        pub fn set_canned_acl(
            mut self,
            input: std::option::Option<crate::model::CannedAcl>,
        ) -> Self {
            self.canned_acl = input;
            self
        }
        /// Appends an item to `access_control_list`.
        ///
        /// To override the contents of this collection use [`set_access_control_list`](Self::set_access_control_list).
        ///
        /// <p>A list of grants that control access to the staged results.</p>
        pub fn access_control_list(mut self, input: crate::model::Grant) -> Self {
            let mut v = self.access_control_list.unwrap_or_default();
            v.push(input);
            self.access_control_list = Some(v);
            self
        }
        /// <p>A list of grants that control access to the staged results.</p>
        pub fn set_access_control_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Grant>>,
        ) -> Self {
            self.access_control_list = input;
            self
        }
        /// Adds a key-value pair to `tagging`.
        ///
        /// To override the contents of this collection use [`set_tagging`](Self::set_tagging).
        ///
        /// <p>The tag-set that is applied to the job results.</p>
        pub fn tagging(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tagging.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tagging = Some(hash_map);
            self
        }
        /// <p>The tag-set that is applied to the job results.</p>
        pub fn set_tagging(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tagging = input;
            self
        }
        /// Adds a key-value pair to `user_metadata`.
        ///
        /// To override the contents of this collection use [`set_user_metadata`](Self::set_user_metadata).
        ///
        /// <p>A map of metadata to store with the job results in Amazon S3.</p>
        pub fn user_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.user_metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.user_metadata = Some(hash_map);
            self
        }
        /// <p>A map of metadata to store with the job results in Amazon S3.</p>
        pub fn set_user_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.user_metadata = input;
            self
        }
        /// <p>The storage class used to store the job results.</p>
        pub fn storage_class(mut self, input: crate::model::StorageClass) -> Self {
            self.storage_class = Some(input);
            self
        }
        /// <p>The storage class used to store the job results.</p>
        pub fn set_storage_class(
            mut self,
            input: std::option::Option<crate::model::StorageClass>,
        ) -> Self {
            self.storage_class = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Location`](crate::model::S3Location)
        pub fn build(self) -> crate::model::S3Location {
            crate::model::S3Location {
                bucket_name: self.bucket_name,
                prefix: self.prefix,
                encryption: self.encryption,
                canned_acl: self.canned_acl,
                access_control_list: self.access_control_list,
                tagging: self.tagging,
                user_metadata: self.user_metadata,
                storage_class: self.storage_class,
            }
        }
    }
}
impl S3Location {
    /// Creates a new builder-style object to manufacture [`S3Location`](crate::model::S3Location)
    pub fn builder() -> crate::model::s3_location::Builder {
        crate::model::s3_location::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StorageClass {
    #[allow(missing_docs)] // documentation missing in model
    ReducedRedundancy,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    #[allow(missing_docs)] // documentation missing in model
    StandardInfrequentAccess,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StorageClass {
    fn from(s: &str) -> Self {
        match s {
            "REDUCED_REDUNDANCY" => StorageClass::ReducedRedundancy,
            "STANDARD" => StorageClass::Standard,
            "STANDARD_IA" => StorageClass::StandardInfrequentAccess,
            other => StorageClass::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StorageClass {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StorageClass::from(s))
    }
}
impl StorageClass {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StorageClass::ReducedRedundancy => "REDUCED_REDUNDANCY",
            StorageClass::Standard => "STANDARD",
            StorageClass::StandardInfrequentAccess => "STANDARD_IA",
            StorageClass::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["REDUCED_REDUNDANCY", "STANDARD", "STANDARD_IA"]
    }
}
impl AsRef<str> for StorageClass {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about a grant.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Grant {
    /// <p>The grantee.</p>
    pub grantee: std::option::Option<crate::model::Grantee>,
    /// <p>Specifies the permission given to the grantee. </p>
    pub permission: std::option::Option<crate::model::Permission>,
}
impl Grant {
    /// <p>The grantee.</p>
    pub fn grantee(&self) -> std::option::Option<&crate::model::Grantee> {
        self.grantee.as_ref()
    }
    /// <p>Specifies the permission given to the grantee. </p>
    pub fn permission(&self) -> std::option::Option<&crate::model::Permission> {
        self.permission.as_ref()
    }
}
impl std::fmt::Debug for Grant {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Grant");
        formatter.field("grantee", &self.grantee);
        formatter.field("permission", &self.permission);
        formatter.finish()
    }
}
/// See [`Grant`](crate::model::Grant)
pub mod grant {
    /// A builder for [`Grant`](crate::model::Grant)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) grantee: std::option::Option<crate::model::Grantee>,
        pub(crate) permission: std::option::Option<crate::model::Permission>,
    }
    impl Builder {
        /// <p>The grantee.</p>
        pub fn grantee(mut self, input: crate::model::Grantee) -> Self {
            self.grantee = Some(input);
            self
        }
        /// <p>The grantee.</p>
        pub fn set_grantee(mut self, input: std::option::Option<crate::model::Grantee>) -> Self {
            self.grantee = input;
            self
        }
        /// <p>Specifies the permission given to the grantee. </p>
        pub fn permission(mut self, input: crate::model::Permission) -> Self {
            self.permission = Some(input);
            self
        }
        /// <p>Specifies the permission given to the grantee. </p>
        pub fn set_permission(
            mut self,
            input: std::option::Option<crate::model::Permission>,
        ) -> Self {
            self.permission = input;
            self
        }
        /// Consumes the builder and constructs a [`Grant`](crate::model::Grant)
        pub fn build(self) -> crate::model::Grant {
            crate::model::Grant {
                grantee: self.grantee,
                permission: self.permission,
            }
        }
    }
}
impl Grant {
    /// Creates a new builder-style object to manufacture [`Grant`](crate::model::Grant)
    pub fn builder() -> crate::model::grant::Builder {
        crate::model::grant::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Permission {
    #[allow(missing_docs)] // documentation missing in model
    FullControl,
    #[allow(missing_docs)] // documentation missing in model
    Read,
    #[allow(missing_docs)] // documentation missing in model
    ReadAcp,
    #[allow(missing_docs)] // documentation missing in model
    Write,
    #[allow(missing_docs)] // documentation missing in model
    WriteAcp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Permission {
    fn from(s: &str) -> Self {
        match s {
            "FULL_CONTROL" => Permission::FullControl,
            "READ" => Permission::Read,
            "READ_ACP" => Permission::ReadAcp,
            "WRITE" => Permission::Write,
            "WRITE_ACP" => Permission::WriteAcp,
            other => Permission::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Permission {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Permission::from(s))
    }
}
impl Permission {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Permission::FullControl => "FULL_CONTROL",
            Permission::Read => "READ",
            Permission::ReadAcp => "READ_ACP",
            Permission::Write => "WRITE",
            Permission::WriteAcp => "WRITE_ACP",
            Permission::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FULL_CONTROL", "READ", "READ_ACP", "WRITE", "WRITE_ACP"]
    }
}
impl AsRef<str> for Permission {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about the grantee.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Grantee {
    /// <p>Type of grantee</p>
    pub r#type: std::option::Option<crate::model::Type>,
    /// <p>Screen name of the grantee.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>URI of the grantee group.</p>
    pub uri: std::option::Option<std::string::String>,
    /// <p>The canonical user ID of the grantee.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Email address of the grantee.</p>
    pub email_address: std::option::Option<std::string::String>,
}
impl Grantee {
    /// <p>Type of grantee</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::Type> {
        self.r#type.as_ref()
    }
    /// <p>Screen name of the grantee.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>URI of the grantee group.</p>
    pub fn uri(&self) -> std::option::Option<&str> {
        self.uri.as_deref()
    }
    /// <p>The canonical user ID of the grantee.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Email address of the grantee.</p>
    pub fn email_address(&self) -> std::option::Option<&str> {
        self.email_address.as_deref()
    }
}
impl std::fmt::Debug for Grantee {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Grantee");
        formatter.field("r#type", &self.r#type);
        formatter.field("display_name", &self.display_name);
        formatter.field("uri", &self.uri);
        formatter.field("id", &self.id);
        formatter.field("email_address", &self.email_address);
        formatter.finish()
    }
}
/// See [`Grantee`](crate::model::Grantee)
pub mod grantee {
    /// A builder for [`Grantee`](crate::model::Grantee)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::Type>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) uri: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) email_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Type of grantee</p>
        pub fn r#type(mut self, input: crate::model::Type) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Type of grantee</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::Type>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Screen name of the grantee.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>Screen name of the grantee.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>URI of the grantee group.</p>
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.uri = Some(input.into());
            self
        }
        /// <p>URI of the grantee group.</p>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uri = input;
            self
        }
        /// <p>The canonical user ID of the grantee.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The canonical user ID of the grantee.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Email address of the grantee.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>Email address of the grantee.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// Consumes the builder and constructs a [`Grantee`](crate::model::Grantee)
        pub fn build(self) -> crate::model::Grantee {
            crate::model::Grantee {
                r#type: self.r#type,
                display_name: self.display_name,
                uri: self.uri,
                id: self.id,
                email_address: self.email_address,
            }
        }
    }
}
impl Grantee {
    /// Creates a new builder-style object to manufacture [`Grantee`](crate::model::Grantee)
    pub fn builder() -> crate::model::grantee::Builder {
        crate::model::grantee::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Type {
    #[allow(missing_docs)] // documentation missing in model
    AmazonCustomerByEmail,
    #[allow(missing_docs)] // documentation missing in model
    CanonicalUser,
    #[allow(missing_docs)] // documentation missing in model
    Group,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Type {
    fn from(s: &str) -> Self {
        match s {
            "AmazonCustomerByEmail" => Type::AmazonCustomerByEmail,
            "CanonicalUser" => Type::CanonicalUser,
            "Group" => Type::Group,
            other => Type::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Type {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Type::from(s))
    }
}
impl Type {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Type::AmazonCustomerByEmail => "AmazonCustomerByEmail",
            Type::CanonicalUser => "CanonicalUser",
            Type::Group => "Group",
            Type::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AmazonCustomerByEmail", "CanonicalUser", "Group"]
    }
}
impl AsRef<str> for Type {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CannedAcl {
    #[allow(missing_docs)] // documentation missing in model
    AuthenticatedRead,
    #[allow(missing_docs)] // documentation missing in model
    AwsExecRead,
    #[allow(missing_docs)] // documentation missing in model
    BucketOwnerFullControl,
    #[allow(missing_docs)] // documentation missing in model
    BucketOwnerRead,
    #[allow(missing_docs)] // documentation missing in model
    Private,
    #[allow(missing_docs)] // documentation missing in model
    PublicRead,
    #[allow(missing_docs)] // documentation missing in model
    PublicReadWrite,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CannedAcl {
    fn from(s: &str) -> Self {
        match s {
            "authenticated-read" => CannedAcl::AuthenticatedRead,
            "aws-exec-read" => CannedAcl::AwsExecRead,
            "bucket-owner-full-control" => CannedAcl::BucketOwnerFullControl,
            "bucket-owner-read" => CannedAcl::BucketOwnerRead,
            "private" => CannedAcl::Private,
            "public-read" => CannedAcl::PublicRead,
            "public-read-write" => CannedAcl::PublicReadWrite,
            other => CannedAcl::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CannedAcl {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CannedAcl::from(s))
    }
}
impl CannedAcl {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CannedAcl::AuthenticatedRead => "authenticated-read",
            CannedAcl::AwsExecRead => "aws-exec-read",
            CannedAcl::BucketOwnerFullControl => "bucket-owner-full-control",
            CannedAcl::BucketOwnerRead => "bucket-owner-read",
            CannedAcl::Private => "private",
            CannedAcl::PublicRead => "public-read",
            CannedAcl::PublicReadWrite => "public-read-write",
            CannedAcl::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "authenticated-read",
            "aws-exec-read",
            "bucket-owner-full-control",
            "bucket-owner-read",
            "private",
            "public-read",
            "public-read-write",
        ]
    }
}
impl AsRef<str> for CannedAcl {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about the encryption used to store the job results in Amazon S3. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Encryption {
    /// <p>The server-side encryption algorithm used when storing job results in Amazon S3, for example <code>AES256</code> or <code>aws:kms</code>.</p>
    pub encryption_type: std::option::Option<crate::model::EncryptionType>,
    /// <p>The AWS KMS key ID to use for object encryption. All GET and PUT requests for an object protected by AWS KMS fail if not made by using Secure Sockets Layer (SSL) or Signature Version 4. </p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>Optional. If the encryption type is <code>aws:kms</code>, you can use this value to specify the encryption context for the job results.</p>
    pub kms_context: std::option::Option<std::string::String>,
}
impl Encryption {
    /// <p>The server-side encryption algorithm used when storing job results in Amazon S3, for example <code>AES256</code> or <code>aws:kms</code>.</p>
    pub fn encryption_type(&self) -> std::option::Option<&crate::model::EncryptionType> {
        self.encryption_type.as_ref()
    }
    /// <p>The AWS KMS key ID to use for object encryption. All GET and PUT requests for an object protected by AWS KMS fail if not made by using Secure Sockets Layer (SSL) or Signature Version 4. </p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>Optional. If the encryption type is <code>aws:kms</code>, you can use this value to specify the encryption context for the job results.</p>
    pub fn kms_context(&self) -> std::option::Option<&str> {
        self.kms_context.as_deref()
    }
}
impl std::fmt::Debug for Encryption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Encryption");
        formatter.field("encryption_type", &self.encryption_type);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("kms_context", &self.kms_context);
        formatter.finish()
    }
}
/// See [`Encryption`](crate::model::Encryption)
pub mod encryption {
    /// A builder for [`Encryption`](crate::model::Encryption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) encryption_type: std::option::Option<crate::model::EncryptionType>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) kms_context: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The server-side encryption algorithm used when storing job results in Amazon S3, for example <code>AES256</code> or <code>aws:kms</code>.</p>
        pub fn encryption_type(mut self, input: crate::model::EncryptionType) -> Self {
            self.encryption_type = Some(input);
            self
        }
        /// <p>The server-side encryption algorithm used when storing job results in Amazon S3, for example <code>AES256</code> or <code>aws:kms</code>.</p>
        pub fn set_encryption_type(
            mut self,
            input: std::option::Option<crate::model::EncryptionType>,
        ) -> Self {
            self.encryption_type = input;
            self
        }
        /// <p>The AWS KMS key ID to use for object encryption. All GET and PUT requests for an object protected by AWS KMS fail if not made by using Secure Sockets Layer (SSL) or Signature Version 4. </p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The AWS KMS key ID to use for object encryption. All GET and PUT requests for an object protected by AWS KMS fail if not made by using Secure Sockets Layer (SSL) or Signature Version 4. </p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>Optional. If the encryption type is <code>aws:kms</code>, you can use this value to specify the encryption context for the job results.</p>
        pub fn kms_context(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_context = Some(input.into());
            self
        }
        /// <p>Optional. If the encryption type is <code>aws:kms</code>, you can use this value to specify the encryption context for the job results.</p>
        pub fn set_kms_context(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_context = input;
            self
        }
        /// Consumes the builder and constructs a [`Encryption`](crate::model::Encryption)
        pub fn build(self) -> crate::model::Encryption {
            crate::model::Encryption {
                encryption_type: self.encryption_type,
                kms_key_id: self.kms_key_id,
                kms_context: self.kms_context,
            }
        }
    }
}
impl Encryption {
    /// Creates a new builder-style object to manufacture [`Encryption`](crate::model::Encryption)
    pub fn builder() -> crate::model::encryption::Builder {
        crate::model::encryption::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EncryptionType {
    #[allow(missing_docs)] // documentation missing in model
    S3,
    #[allow(missing_docs)] // documentation missing in model
    Kms,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EncryptionType {
    fn from(s: &str) -> Self {
        match s {
            "AES256" => EncryptionType::S3,
            "aws:kms" => EncryptionType::Kms,
            other => EncryptionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EncryptionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EncryptionType::from(s))
    }
}
impl EncryptionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EncryptionType::S3 => "AES256",
            EncryptionType::Kms => "aws:kms",
            EncryptionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AES256", "aws:kms"]
    }
}
impl AsRef<str> for EncryptionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about the parameters used for a select.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SelectParameters {
    /// <p>Describes the serialization format of the object.</p>
    pub input_serialization: std::option::Option<crate::model::InputSerialization>,
    /// <p>The type of the provided expression, for example <code>SQL</code>.</p>
    pub expression_type: std::option::Option<crate::model::ExpressionType>,
    /// <p>The expression that is used to select the object.</p>
    pub expression: std::option::Option<std::string::String>,
    /// <p>Describes how the results of the select job are serialized.</p>
    pub output_serialization: std::option::Option<crate::model::OutputSerialization>,
}
impl SelectParameters {
    /// <p>Describes the serialization format of the object.</p>
    pub fn input_serialization(&self) -> std::option::Option<&crate::model::InputSerialization> {
        self.input_serialization.as_ref()
    }
    /// <p>The type of the provided expression, for example <code>SQL</code>.</p>
    pub fn expression_type(&self) -> std::option::Option<&crate::model::ExpressionType> {
        self.expression_type.as_ref()
    }
    /// <p>The expression that is used to select the object.</p>
    pub fn expression(&self) -> std::option::Option<&str> {
        self.expression.as_deref()
    }
    /// <p>Describes how the results of the select job are serialized.</p>
    pub fn output_serialization(&self) -> std::option::Option<&crate::model::OutputSerialization> {
        self.output_serialization.as_ref()
    }
}
impl std::fmt::Debug for SelectParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SelectParameters");
        formatter.field("input_serialization", &self.input_serialization);
        formatter.field("expression_type", &self.expression_type);
        formatter.field("expression", &self.expression);
        formatter.field("output_serialization", &self.output_serialization);
        formatter.finish()
    }
}
/// See [`SelectParameters`](crate::model::SelectParameters)
pub mod select_parameters {
    /// A builder for [`SelectParameters`](crate::model::SelectParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_serialization: std::option::Option<crate::model::InputSerialization>,
        pub(crate) expression_type: std::option::Option<crate::model::ExpressionType>,
        pub(crate) expression: std::option::Option<std::string::String>,
        pub(crate) output_serialization: std::option::Option<crate::model::OutputSerialization>,
    }
    impl Builder {
        /// <p>Describes the serialization format of the object.</p>
        pub fn input_serialization(mut self, input: crate::model::InputSerialization) -> Self {
            self.input_serialization = Some(input);
            self
        }
        /// <p>Describes the serialization format of the object.</p>
        pub fn set_input_serialization(
            mut self,
            input: std::option::Option<crate::model::InputSerialization>,
        ) -> Self {
            self.input_serialization = input;
            self
        }
        /// <p>The type of the provided expression, for example <code>SQL</code>.</p>
        pub fn expression_type(mut self, input: crate::model::ExpressionType) -> Self {
            self.expression_type = Some(input);
            self
        }
        /// <p>The type of the provided expression, for example <code>SQL</code>.</p>
        pub fn set_expression_type(
            mut self,
            input: std::option::Option<crate::model::ExpressionType>,
        ) -> Self {
            self.expression_type = input;
            self
        }
        /// <p>The expression that is used to select the object.</p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.expression = Some(input.into());
            self
        }
        /// <p>The expression that is used to select the object.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.expression = input;
            self
        }
        /// <p>Describes how the results of the select job are serialized.</p>
        pub fn output_serialization(mut self, input: crate::model::OutputSerialization) -> Self {
            self.output_serialization = Some(input);
            self
        }
        /// <p>Describes how the results of the select job are serialized.</p>
        pub fn set_output_serialization(
            mut self,
            input: std::option::Option<crate::model::OutputSerialization>,
        ) -> Self {
            self.output_serialization = input;
            self
        }
        /// Consumes the builder and constructs a [`SelectParameters`](crate::model::SelectParameters)
        pub fn build(self) -> crate::model::SelectParameters {
            crate::model::SelectParameters {
                input_serialization: self.input_serialization,
                expression_type: self.expression_type,
                expression: self.expression,
                output_serialization: self.output_serialization,
            }
        }
    }
}
impl SelectParameters {
    /// Creates a new builder-style object to manufacture [`SelectParameters`](crate::model::SelectParameters)
    pub fn builder() -> crate::model::select_parameters::Builder {
        crate::model::select_parameters::Builder::default()
    }
}

/// <p>Describes how the select output is serialized.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutputSerialization {
    /// <p>Describes the serialization of CSV-encoded query results.</p>
    pub csv: std::option::Option<crate::model::CsvOutput>,
}
impl OutputSerialization {
    /// <p>Describes the serialization of CSV-encoded query results.</p>
    pub fn csv(&self) -> std::option::Option<&crate::model::CsvOutput> {
        self.csv.as_ref()
    }
}
impl std::fmt::Debug for OutputSerialization {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutputSerialization");
        formatter.field("csv", &self.csv);
        formatter.finish()
    }
}
/// See [`OutputSerialization`](crate::model::OutputSerialization)
pub mod output_serialization {
    /// A builder for [`OutputSerialization`](crate::model::OutputSerialization)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) csv: std::option::Option<crate::model::CsvOutput>,
    }
    impl Builder {
        /// <p>Describes the serialization of CSV-encoded query results.</p>
        pub fn csv(mut self, input: crate::model::CsvOutput) -> Self {
            self.csv = Some(input);
            self
        }
        /// <p>Describes the serialization of CSV-encoded query results.</p>
        pub fn set_csv(mut self, input: std::option::Option<crate::model::CsvOutput>) -> Self {
            self.csv = input;
            self
        }
        /// Consumes the builder and constructs a [`OutputSerialization`](crate::model::OutputSerialization)
        pub fn build(self) -> crate::model::OutputSerialization {
            crate::model::OutputSerialization { csv: self.csv }
        }
    }
}
impl OutputSerialization {
    /// Creates a new builder-style object to manufacture [`OutputSerialization`](crate::model::OutputSerialization)
    pub fn builder() -> crate::model::output_serialization::Builder {
        crate::model::output_serialization::Builder::default()
    }
}

/// <p>Contains information about the comma-separated value (CSV) file that the job results are stored in.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CsvOutput {
    /// <p>A value that indicates whether all output fields should be contained within quotation marks.</p>
    pub quote_fields: std::option::Option<crate::model::QuoteFields>,
    /// <p>A single character used for escaping the quotation-mark character inside an already escaped value.</p>
    pub quote_escape_character: std::option::Option<std::string::String>,
    /// <p>A value used to separate individual records from each other.</p>
    pub record_delimiter: std::option::Option<std::string::String>,
    /// <p>A value used to separate individual fields from each other within a record.</p>
    pub field_delimiter: std::option::Option<std::string::String>,
    /// <p>A value used as an escape character where the field delimiter is part of the value.</p>
    pub quote_character: std::option::Option<std::string::String>,
}
impl CsvOutput {
    /// <p>A value that indicates whether all output fields should be contained within quotation marks.</p>
    pub fn quote_fields(&self) -> std::option::Option<&crate::model::QuoteFields> {
        self.quote_fields.as_ref()
    }
    /// <p>A single character used for escaping the quotation-mark character inside an already escaped value.</p>
    pub fn quote_escape_character(&self) -> std::option::Option<&str> {
        self.quote_escape_character.as_deref()
    }
    /// <p>A value used to separate individual records from each other.</p>
    pub fn record_delimiter(&self) -> std::option::Option<&str> {
        self.record_delimiter.as_deref()
    }
    /// <p>A value used to separate individual fields from each other within a record.</p>
    pub fn field_delimiter(&self) -> std::option::Option<&str> {
        self.field_delimiter.as_deref()
    }
    /// <p>A value used as an escape character where the field delimiter is part of the value.</p>
    pub fn quote_character(&self) -> std::option::Option<&str> {
        self.quote_character.as_deref()
    }
}
impl std::fmt::Debug for CsvOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CsvOutput");
        formatter.field("quote_fields", &self.quote_fields);
        formatter.field("quote_escape_character", &self.quote_escape_character);
        formatter.field("record_delimiter", &self.record_delimiter);
        formatter.field("field_delimiter", &self.field_delimiter);
        formatter.field("quote_character", &self.quote_character);
        formatter.finish()
    }
}
/// See [`CsvOutput`](crate::model::CsvOutput)
pub mod csv_output {
    /// A builder for [`CsvOutput`](crate::model::CsvOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quote_fields: std::option::Option<crate::model::QuoteFields>,
        pub(crate) quote_escape_character: std::option::Option<std::string::String>,
        pub(crate) record_delimiter: std::option::Option<std::string::String>,
        pub(crate) field_delimiter: std::option::Option<std::string::String>,
        pub(crate) quote_character: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A value that indicates whether all output fields should be contained within quotation marks.</p>
        pub fn quote_fields(mut self, input: crate::model::QuoteFields) -> Self {
            self.quote_fields = Some(input);
            self
        }
        /// <p>A value that indicates whether all output fields should be contained within quotation marks.</p>
        pub fn set_quote_fields(
            mut self,
            input: std::option::Option<crate::model::QuoteFields>,
        ) -> Self {
            self.quote_fields = input;
            self
        }
        /// <p>A single character used for escaping the quotation-mark character inside an already escaped value.</p>
        pub fn quote_escape_character(mut self, input: impl Into<std::string::String>) -> Self {
            self.quote_escape_character = Some(input.into());
            self
        }
        /// <p>A single character used for escaping the quotation-mark character inside an already escaped value.</p>
        pub fn set_quote_escape_character(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.quote_escape_character = input;
            self
        }
        /// <p>A value used to separate individual records from each other.</p>
        pub fn record_delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.record_delimiter = Some(input.into());
            self
        }
        /// <p>A value used to separate individual records from each other.</p>
        pub fn set_record_delimiter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.record_delimiter = input;
            self
        }
        /// <p>A value used to separate individual fields from each other within a record.</p>
        pub fn field_delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.field_delimiter = Some(input.into());
            self
        }
        /// <p>A value used to separate individual fields from each other within a record.</p>
        pub fn set_field_delimiter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.field_delimiter = input;
            self
        }
        /// <p>A value used as an escape character where the field delimiter is part of the value.</p>
        pub fn quote_character(mut self, input: impl Into<std::string::String>) -> Self {
            self.quote_character = Some(input.into());
            self
        }
        /// <p>A value used as an escape character where the field delimiter is part of the value.</p>
        pub fn set_quote_character(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.quote_character = input;
            self
        }
        /// Consumes the builder and constructs a [`CsvOutput`](crate::model::CsvOutput)
        pub fn build(self) -> crate::model::CsvOutput {
            crate::model::CsvOutput {
                quote_fields: self.quote_fields,
                quote_escape_character: self.quote_escape_character,
                record_delimiter: self.record_delimiter,
                field_delimiter: self.field_delimiter,
                quote_character: self.quote_character,
            }
        }
    }
}
impl CsvOutput {
    /// Creates a new builder-style object to manufacture [`CsvOutput`](crate::model::CsvOutput)
    pub fn builder() -> crate::model::csv_output::Builder {
        crate::model::csv_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum QuoteFields {
    #[allow(missing_docs)] // documentation missing in model
    Always,
    #[allow(missing_docs)] // documentation missing in model
    AsNeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for QuoteFields {
    fn from(s: &str) -> Self {
        match s {
            "ALWAYS" => QuoteFields::Always,
            "ASNEEDED" => QuoteFields::AsNeeded,
            other => QuoteFields::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for QuoteFields {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(QuoteFields::from(s))
    }
}
impl QuoteFields {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            QuoteFields::Always => "ALWAYS",
            QuoteFields::AsNeeded => "ASNEEDED",
            QuoteFields::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALWAYS", "ASNEEDED"]
    }
}
impl AsRef<str> for QuoteFields {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExpressionType {
    #[allow(missing_docs)] // documentation missing in model
    Sql,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExpressionType {
    fn from(s: &str) -> Self {
        match s {
            "SQL" => ExpressionType::Sql,
            other => ExpressionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExpressionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExpressionType::from(s))
    }
}
impl ExpressionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExpressionType::Sql => "SQL",
            ExpressionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SQL"]
    }
}
impl AsRef<str> for ExpressionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes how the archive is serialized.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputSerialization {
    /// <p>Describes the serialization of a CSV-encoded object.</p>
    pub csv: std::option::Option<crate::model::CsvInput>,
}
impl InputSerialization {
    /// <p>Describes the serialization of a CSV-encoded object.</p>
    pub fn csv(&self) -> std::option::Option<&crate::model::CsvInput> {
        self.csv.as_ref()
    }
}
impl std::fmt::Debug for InputSerialization {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputSerialization");
        formatter.field("csv", &self.csv);
        formatter.finish()
    }
}
/// See [`InputSerialization`](crate::model::InputSerialization)
pub mod input_serialization {
    /// A builder for [`InputSerialization`](crate::model::InputSerialization)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) csv: std::option::Option<crate::model::CsvInput>,
    }
    impl Builder {
        /// <p>Describes the serialization of a CSV-encoded object.</p>
        pub fn csv(mut self, input: crate::model::CsvInput) -> Self {
            self.csv = Some(input);
            self
        }
        /// <p>Describes the serialization of a CSV-encoded object.</p>
        pub fn set_csv(mut self, input: std::option::Option<crate::model::CsvInput>) -> Self {
            self.csv = input;
            self
        }
        /// Consumes the builder and constructs a [`InputSerialization`](crate::model::InputSerialization)
        pub fn build(self) -> crate::model::InputSerialization {
            crate::model::InputSerialization { csv: self.csv }
        }
    }
}
impl InputSerialization {
    /// Creates a new builder-style object to manufacture [`InputSerialization`](crate::model::InputSerialization)
    pub fn builder() -> crate::model::input_serialization::Builder {
        crate::model::input_serialization::Builder::default()
    }
}

/// <p>Contains information about the comma-separated value (CSV) file to select from.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CsvInput {
    /// <p>Describes the first line of input. Valid values are <code>None</code>, <code>Ignore</code>, and <code>Use</code>.</p>
    pub file_header_info: std::option::Option<crate::model::FileHeaderInfo>,
    /// <p>A single character used to indicate that a row should be ignored when the character is present at the start of that row.</p>
    pub comments: std::option::Option<std::string::String>,
    /// <p>A single character used for escaping the quotation-mark character inside an already escaped value.</p>
    pub quote_escape_character: std::option::Option<std::string::String>,
    /// <p>A value used to separate individual records from each other.</p>
    pub record_delimiter: std::option::Option<std::string::String>,
    /// <p>A value used to separate individual fields from each other within a record.</p>
    pub field_delimiter: std::option::Option<std::string::String>,
    /// <p>A value used as an escape character where the field delimiter is part of the value.</p>
    pub quote_character: std::option::Option<std::string::String>,
}
impl CsvInput {
    /// <p>Describes the first line of input. Valid values are <code>None</code>, <code>Ignore</code>, and <code>Use</code>.</p>
    pub fn file_header_info(&self) -> std::option::Option<&crate::model::FileHeaderInfo> {
        self.file_header_info.as_ref()
    }
    /// <p>A single character used to indicate that a row should be ignored when the character is present at the start of that row.</p>
    pub fn comments(&self) -> std::option::Option<&str> {
        self.comments.as_deref()
    }
    /// <p>A single character used for escaping the quotation-mark character inside an already escaped value.</p>
    pub fn quote_escape_character(&self) -> std::option::Option<&str> {
        self.quote_escape_character.as_deref()
    }
    /// <p>A value used to separate individual records from each other.</p>
    pub fn record_delimiter(&self) -> std::option::Option<&str> {
        self.record_delimiter.as_deref()
    }
    /// <p>A value used to separate individual fields from each other within a record.</p>
    pub fn field_delimiter(&self) -> std::option::Option<&str> {
        self.field_delimiter.as_deref()
    }
    /// <p>A value used as an escape character where the field delimiter is part of the value.</p>
    pub fn quote_character(&self) -> std::option::Option<&str> {
        self.quote_character.as_deref()
    }
}
impl std::fmt::Debug for CsvInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CsvInput");
        formatter.field("file_header_info", &self.file_header_info);
        formatter.field("comments", &self.comments);
        formatter.field("quote_escape_character", &self.quote_escape_character);
        formatter.field("record_delimiter", &self.record_delimiter);
        formatter.field("field_delimiter", &self.field_delimiter);
        formatter.field("quote_character", &self.quote_character);
        formatter.finish()
    }
}
/// See [`CsvInput`](crate::model::CsvInput)
pub mod csv_input {
    /// A builder for [`CsvInput`](crate::model::CsvInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_header_info: std::option::Option<crate::model::FileHeaderInfo>,
        pub(crate) comments: std::option::Option<std::string::String>,
        pub(crate) quote_escape_character: std::option::Option<std::string::String>,
        pub(crate) record_delimiter: std::option::Option<std::string::String>,
        pub(crate) field_delimiter: std::option::Option<std::string::String>,
        pub(crate) quote_character: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Describes the first line of input. Valid values are <code>None</code>, <code>Ignore</code>, and <code>Use</code>.</p>
        pub fn file_header_info(mut self, input: crate::model::FileHeaderInfo) -> Self {
            self.file_header_info = Some(input);
            self
        }
        /// <p>Describes the first line of input. Valid values are <code>None</code>, <code>Ignore</code>, and <code>Use</code>.</p>
        pub fn set_file_header_info(
            mut self,
            input: std::option::Option<crate::model::FileHeaderInfo>,
        ) -> Self {
            self.file_header_info = input;
            self
        }
        /// <p>A single character used to indicate that a row should be ignored when the character is present at the start of that row.</p>
        pub fn comments(mut self, input: impl Into<std::string::String>) -> Self {
            self.comments = Some(input.into());
            self
        }
        /// <p>A single character used to indicate that a row should be ignored when the character is present at the start of that row.</p>
        pub fn set_comments(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comments = input;
            self
        }
        /// <p>A single character used for escaping the quotation-mark character inside an already escaped value.</p>
        pub fn quote_escape_character(mut self, input: impl Into<std::string::String>) -> Self {
            self.quote_escape_character = Some(input.into());
            self
        }
        /// <p>A single character used for escaping the quotation-mark character inside an already escaped value.</p>
        pub fn set_quote_escape_character(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.quote_escape_character = input;
            self
        }
        /// <p>A value used to separate individual records from each other.</p>
        pub fn record_delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.record_delimiter = Some(input.into());
            self
        }
        /// <p>A value used to separate individual records from each other.</p>
        pub fn set_record_delimiter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.record_delimiter = input;
            self
        }
        /// <p>A value used to separate individual fields from each other within a record.</p>
        pub fn field_delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.field_delimiter = Some(input.into());
            self
        }
        /// <p>A value used to separate individual fields from each other within a record.</p>
        pub fn set_field_delimiter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.field_delimiter = input;
            self
        }
        /// <p>A value used as an escape character where the field delimiter is part of the value.</p>
        pub fn quote_character(mut self, input: impl Into<std::string::String>) -> Self {
            self.quote_character = Some(input.into());
            self
        }
        /// <p>A value used as an escape character where the field delimiter is part of the value.</p>
        pub fn set_quote_character(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.quote_character = input;
            self
        }
        /// Consumes the builder and constructs a [`CsvInput`](crate::model::CsvInput)
        pub fn build(self) -> crate::model::CsvInput {
            crate::model::CsvInput {
                file_header_info: self.file_header_info,
                comments: self.comments,
                quote_escape_character: self.quote_escape_character,
                record_delimiter: self.record_delimiter,
                field_delimiter: self.field_delimiter,
                quote_character: self.quote_character,
            }
        }
    }
}
impl CsvInput {
    /// Creates a new builder-style object to manufacture [`CsvInput`](crate::model::CsvInput)
    pub fn builder() -> crate::model::csv_input::Builder {
        crate::model::csv_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FileHeaderInfo {
    #[allow(missing_docs)] // documentation missing in model
    Ignore,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Use,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FileHeaderInfo {
    fn from(s: &str) -> Self {
        match s {
            "IGNORE" => FileHeaderInfo::Ignore,
            "NONE" => FileHeaderInfo::None,
            "USE" => FileHeaderInfo::Use,
            other => FileHeaderInfo::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FileHeaderInfo {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FileHeaderInfo::from(s))
    }
}
impl FileHeaderInfo {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FileHeaderInfo::Ignore => "IGNORE",
            FileHeaderInfo::None => "NONE",
            FileHeaderInfo::Use => "USE",
            FileHeaderInfo::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IGNORE", "NONE", "USE"]
    }
}
impl AsRef<str> for FileHeaderInfo {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the options for a range inventory retrieval job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InventoryRetrievalJobDescription {
    /// <p>The output format for the vault inventory list, which is set by the <b>InitiateJob</b> request when initiating a job to retrieve a vault inventory. Valid values are <code>CSV</code> and <code>JSON</code>.</p>
    pub format: std::option::Option<std::string::String>,
    /// <p>The start of the date range in Universal Coordinated Time (UTC) for vault inventory retrieval that includes archives created on or after this date. This value should be a string in the ISO 8601 date format, for example <code>2013-03-20T17:03:43Z</code>.</p>
    pub start_date: std::option::Option<std::string::String>,
    /// <p>The end of the date range in UTC for vault inventory retrieval that includes archives created before this date. This value should be a string in the ISO 8601 date format, for example <code>2013-03-20T17:03:43Z</code>.</p>
    pub end_date: std::option::Option<std::string::String>,
    /// <p>The maximum number of inventory items returned per vault inventory retrieval request. This limit is set when initiating the job with the a <b>InitiateJob</b> request. </p>
    pub limit: std::option::Option<std::string::String>,
    /// <p>An opaque string that represents where to continue pagination of the vault inventory retrieval results. You use the marker in a new <b>InitiateJob</b> request to obtain additional inventory items. If there are no more inventory items, this value is <code>null</code>. For more information, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-initiate-job-post.html#api-initiate-job-post-vault-inventory-list-filtering"> Range Inventory Retrieval</a>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl InventoryRetrievalJobDescription {
    /// <p>The output format for the vault inventory list, which is set by the <b>InitiateJob</b> request when initiating a job to retrieve a vault inventory. Valid values are <code>CSV</code> and <code>JSON</code>.</p>
    pub fn format(&self) -> std::option::Option<&str> {
        self.format.as_deref()
    }
    /// <p>The start of the date range in Universal Coordinated Time (UTC) for vault inventory retrieval that includes archives created on or after this date. This value should be a string in the ISO 8601 date format, for example <code>2013-03-20T17:03:43Z</code>.</p>
    pub fn start_date(&self) -> std::option::Option<&str> {
        self.start_date.as_deref()
    }
    /// <p>The end of the date range in UTC for vault inventory retrieval that includes archives created before this date. This value should be a string in the ISO 8601 date format, for example <code>2013-03-20T17:03:43Z</code>.</p>
    pub fn end_date(&self) -> std::option::Option<&str> {
        self.end_date.as_deref()
    }
    /// <p>The maximum number of inventory items returned per vault inventory retrieval request. This limit is set when initiating the job with the a <b>InitiateJob</b> request. </p>
    pub fn limit(&self) -> std::option::Option<&str> {
        self.limit.as_deref()
    }
    /// <p>An opaque string that represents where to continue pagination of the vault inventory retrieval results. You use the marker in a new <b>InitiateJob</b> request to obtain additional inventory items. If there are no more inventory items, this value is <code>null</code>. For more information, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-initiate-job-post.html#api-initiate-job-post-vault-inventory-list-filtering"> Range Inventory Retrieval</a>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for InventoryRetrievalJobDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InventoryRetrievalJobDescription");
        formatter.field("format", &self.format);
        formatter.field("start_date", &self.start_date);
        formatter.field("end_date", &self.end_date);
        formatter.field("limit", &self.limit);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`InventoryRetrievalJobDescription`](crate::model::InventoryRetrievalJobDescription)
pub mod inventory_retrieval_job_description {
    /// A builder for [`InventoryRetrievalJobDescription`](crate::model::InventoryRetrievalJobDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) format: std::option::Option<std::string::String>,
        pub(crate) start_date: std::option::Option<std::string::String>,
        pub(crate) end_date: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The output format for the vault inventory list, which is set by the <b>InitiateJob</b> request when initiating a job to retrieve a vault inventory. Valid values are <code>CSV</code> and <code>JSON</code>.</p>
        pub fn format(mut self, input: impl Into<std::string::String>) -> Self {
            self.format = Some(input.into());
            self
        }
        /// <p>The output format for the vault inventory list, which is set by the <b>InitiateJob</b> request when initiating a job to retrieve a vault inventory. Valid values are <code>CSV</code> and <code>JSON</code>.</p>
        pub fn set_format(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.format = input;
            self
        }
        /// <p>The start of the date range in Universal Coordinated Time (UTC) for vault inventory retrieval that includes archives created on or after this date. This value should be a string in the ISO 8601 date format, for example <code>2013-03-20T17:03:43Z</code>.</p>
        pub fn start_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_date = Some(input.into());
            self
        }
        /// <p>The start of the date range in Universal Coordinated Time (UTC) for vault inventory retrieval that includes archives created on or after this date. This value should be a string in the ISO 8601 date format, for example <code>2013-03-20T17:03:43Z</code>.</p>
        pub fn set_start_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start_date = input;
            self
        }
        /// <p>The end of the date range in UTC for vault inventory retrieval that includes archives created before this date. This value should be a string in the ISO 8601 date format, for example <code>2013-03-20T17:03:43Z</code>.</p>
        pub fn end_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.end_date = Some(input.into());
            self
        }
        /// <p>The end of the date range in UTC for vault inventory retrieval that includes archives created before this date. This value should be a string in the ISO 8601 date format, for example <code>2013-03-20T17:03:43Z</code>.</p>
        pub fn set_end_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.end_date = input;
            self
        }
        /// <p>The maximum number of inventory items returned per vault inventory retrieval request. This limit is set when initiating the job with the a <b>InitiateJob</b> request. </p>
        pub fn limit(mut self, input: impl Into<std::string::String>) -> Self {
            self.limit = Some(input.into());
            self
        }
        /// <p>The maximum number of inventory items returned per vault inventory retrieval request. This limit is set when initiating the job with the a <b>InitiateJob</b> request. </p>
        pub fn set_limit(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.limit = input;
            self
        }
        /// <p>An opaque string that represents where to continue pagination of the vault inventory retrieval results. You use the marker in a new <b>InitiateJob</b> request to obtain additional inventory items. If there are no more inventory items, this value is <code>null</code>. For more information, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-initiate-job-post.html#api-initiate-job-post-vault-inventory-list-filtering"> Range Inventory Retrieval</a>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An opaque string that represents where to continue pagination of the vault inventory retrieval results. You use the marker in a new <b>InitiateJob</b> request to obtain additional inventory items. If there are no more inventory items, this value is <code>null</code>. For more information, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-initiate-job-post.html#api-initiate-job-post-vault-inventory-list-filtering"> Range Inventory Retrieval</a>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`InventoryRetrievalJobDescription`](crate::model::InventoryRetrievalJobDescription)
        pub fn build(self) -> crate::model::InventoryRetrievalJobDescription {
            crate::model::InventoryRetrievalJobDescription {
                format: self.format,
                start_date: self.start_date,
                end_date: self.end_date,
                limit: self.limit,
                marker: self.marker,
            }
        }
    }
}
impl InventoryRetrievalJobDescription {
    /// Creates a new builder-style object to manufacture [`InventoryRetrievalJobDescription`](crate::model::InventoryRetrievalJobDescription)
    pub fn builder() -> crate::model::inventory_retrieval_job_description::Builder {
        crate::model::inventory_retrieval_job_description::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StatusCode {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StatusCode {
    fn from(s: &str) -> Self {
        match s {
            "Failed" => StatusCode::Failed,
            "InProgress" => StatusCode::InProgress,
            "Succeeded" => StatusCode::Succeeded,
            other => StatusCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StatusCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StatusCode::from(s))
    }
}
impl StatusCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StatusCode::Failed => "Failed",
            StatusCode::InProgress => "InProgress",
            StatusCode::Succeeded => "Succeeded",
            StatusCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Failed", "InProgress", "Succeeded"]
    }
}
impl AsRef<str> for StatusCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ActionCode {
    #[allow(missing_docs)] // documentation missing in model
    ArchiveRetrieval,
    #[allow(missing_docs)] // documentation missing in model
    InventoryRetrieval,
    #[allow(missing_docs)] // documentation missing in model
    Select,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ActionCode {
    fn from(s: &str) -> Self {
        match s {
            "ArchiveRetrieval" => ActionCode::ArchiveRetrieval,
            "InventoryRetrieval" => ActionCode::InventoryRetrieval,
            "Select" => ActionCode::Select,
            other => ActionCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ActionCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ActionCode::from(s))
    }
}
impl ActionCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ActionCode::ArchiveRetrieval => "ArchiveRetrieval",
            ActionCode::InventoryRetrieval => "InventoryRetrieval",
            ActionCode::Select => "Select",
            ActionCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ArchiveRetrieval", "InventoryRetrieval", "Select"]
    }
}
impl AsRef<str> for ActionCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the vault lock policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VaultLockPolicy {
    /// <p>The vault lock policy.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl VaultLockPolicy {
    /// <p>The vault lock policy.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
}
impl std::fmt::Debug for VaultLockPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VaultLockPolicy");
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`VaultLockPolicy`](crate::model::VaultLockPolicy)
pub mod vault_lock_policy {
    /// A builder for [`VaultLockPolicy`](crate::model::VaultLockPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The vault lock policy.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The vault lock policy.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`VaultLockPolicy`](crate::model::VaultLockPolicy)
        pub fn build(self) -> crate::model::VaultLockPolicy {
            crate::model::VaultLockPolicy {
                policy: self.policy,
            }
        }
    }
}
impl VaultLockPolicy {
    /// Creates a new builder-style object to manufacture [`VaultLockPolicy`](crate::model::VaultLockPolicy)
    pub fn builder() -> crate::model::vault_lock_policy::Builder {
        crate::model::vault_lock_policy::Builder::default()
    }
}

/// <p>Provides options for defining a job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobParameters {
    /// <p>When initiating a job to retrieve a vault inventory, you can optionally add this parameter to your request to specify the output format. If you are initiating an inventory job and do not specify a Format field, JSON is the default format. Valid values are "CSV" and "JSON".</p>
    pub format: std::option::Option<std::string::String>,
    /// <p>The job type. You can initiate a job to perform a select query on an archive, retrieve an archive, or get an inventory of a vault. Valid values are "select", "archive-retrieval" and "inventory-retrieval".</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The ID of the archive that you want to retrieve. This field is required only if <code>Type</code> is set to <code>select</code> or <code>archive-retrieval</code>code&gt;. An error occurs if you specify this request parameter for an inventory retrieval job request. </p>
    pub archive_id: std::option::Option<std::string::String>,
    /// <p>The optional description for the job. The description must be less than or equal to 1,024 bytes. The allowable characters are 7-bit ASCII without control codes-specifically, ASCII values 32-126 decimal or 0x20-0x7E hexadecimal.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon SNS topic ARN to which Amazon S3 Glacier sends a notification when the job is completed and the output is ready for you to download. The specified topic publishes the notification to its subscribers. The SNS topic must exist.</p>
    pub sns_topic: std::option::Option<std::string::String>,
    /// <p>The byte range to retrieve for an archive retrieval. in the form "<i>StartByteValue</i>-<i>EndByteValue</i>" If not specified, the whole archive is retrieved. If specified, the byte range must be megabyte (1024*1024) aligned which means that <i>StartByteValue</i> must be divisible by 1 MB and <i>EndByteValue</i> plus 1 must be divisible by 1 MB or be the end of the archive specified as the archive byte size value minus 1. If RetrievalByteRange is not megabyte aligned, this operation returns a 400 response. </p>
    /// <p>An error occurs if you specify this field for an inventory retrieval job request.</p>
    pub retrieval_byte_range: std::option::Option<std::string::String>,
    /// <p>The tier to use for a select or an archive retrieval job. Valid values are <code>Expedited</code>, <code>Standard</code>, or <code>Bulk</code>. <code>Standard</code> is the default.</p>
    pub tier: std::option::Option<std::string::String>,
    /// <p>Input parameters used for range inventory retrieval.</p>
    pub inventory_retrieval_parameters:
        std::option::Option<crate::model::InventoryRetrievalJobInput>,
    /// <p>Contains the parameters that define a job.</p>
    pub select_parameters: std::option::Option<crate::model::SelectParameters>,
    /// <p>Contains information about the location where the select job results are stored.</p>
    pub output_location: std::option::Option<crate::model::OutputLocation>,
}
impl JobParameters {
    /// <p>When initiating a job to retrieve a vault inventory, you can optionally add this parameter to your request to specify the output format. If you are initiating an inventory job and do not specify a Format field, JSON is the default format. Valid values are "CSV" and "JSON".</p>
    pub fn format(&self) -> std::option::Option<&str> {
        self.format.as_deref()
    }
    /// <p>The job type. You can initiate a job to perform a select query on an archive, retrieve an archive, or get an inventory of a vault. Valid values are "select", "archive-retrieval" and "inventory-retrieval".</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The ID of the archive that you want to retrieve. This field is required only if <code>Type</code> is set to <code>select</code> or <code>archive-retrieval</code>code&gt;. An error occurs if you specify this request parameter for an inventory retrieval job request. </p>
    pub fn archive_id(&self) -> std::option::Option<&str> {
        self.archive_id.as_deref()
    }
    /// <p>The optional description for the job. The description must be less than or equal to 1,024 bytes. The allowable characters are 7-bit ASCII without control codes-specifically, ASCII values 32-126 decimal or 0x20-0x7E hexadecimal.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon SNS topic ARN to which Amazon S3 Glacier sends a notification when the job is completed and the output is ready for you to download. The specified topic publishes the notification to its subscribers. The SNS topic must exist.</p>
    pub fn sns_topic(&self) -> std::option::Option<&str> {
        self.sns_topic.as_deref()
    }
    /// <p>The byte range to retrieve for an archive retrieval. in the form "<i>StartByteValue</i>-<i>EndByteValue</i>" If not specified, the whole archive is retrieved. If specified, the byte range must be megabyte (1024*1024) aligned which means that <i>StartByteValue</i> must be divisible by 1 MB and <i>EndByteValue</i> plus 1 must be divisible by 1 MB or be the end of the archive specified as the archive byte size value minus 1. If RetrievalByteRange is not megabyte aligned, this operation returns a 400 response. </p>
    /// <p>An error occurs if you specify this field for an inventory retrieval job request.</p>
    pub fn retrieval_byte_range(&self) -> std::option::Option<&str> {
        self.retrieval_byte_range.as_deref()
    }
    /// <p>The tier to use for a select or an archive retrieval job. Valid values are <code>Expedited</code>, <code>Standard</code>, or <code>Bulk</code>. <code>Standard</code> is the default.</p>
    pub fn tier(&self) -> std::option::Option<&str> {
        self.tier.as_deref()
    }
    /// <p>Input parameters used for range inventory retrieval.</p>
    pub fn inventory_retrieval_parameters(
        &self,
    ) -> std::option::Option<&crate::model::InventoryRetrievalJobInput> {
        self.inventory_retrieval_parameters.as_ref()
    }
    /// <p>Contains the parameters that define a job.</p>
    pub fn select_parameters(&self) -> std::option::Option<&crate::model::SelectParameters> {
        self.select_parameters.as_ref()
    }
    /// <p>Contains information about the location where the select job results are stored.</p>
    pub fn output_location(&self) -> std::option::Option<&crate::model::OutputLocation> {
        self.output_location.as_ref()
    }
}
impl std::fmt::Debug for JobParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobParameters");
        formatter.field("format", &self.format);
        formatter.field("r#type", &self.r#type);
        formatter.field("archive_id", &self.archive_id);
        formatter.field("description", &self.description);
        formatter.field("sns_topic", &self.sns_topic);
        formatter.field("retrieval_byte_range", &self.retrieval_byte_range);
        formatter.field("tier", &self.tier);
        formatter.field(
            "inventory_retrieval_parameters",
            &self.inventory_retrieval_parameters,
        );
        formatter.field("select_parameters", &self.select_parameters);
        formatter.field("output_location", &self.output_location);
        formatter.finish()
    }
}
/// See [`JobParameters`](crate::model::JobParameters)
pub mod job_parameters {
    /// A builder for [`JobParameters`](crate::model::JobParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) format: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) archive_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) sns_topic: std::option::Option<std::string::String>,
        pub(crate) retrieval_byte_range: std::option::Option<std::string::String>,
        pub(crate) tier: std::option::Option<std::string::String>,
        pub(crate) inventory_retrieval_parameters:
            std::option::Option<crate::model::InventoryRetrievalJobInput>,
        pub(crate) select_parameters: std::option::Option<crate::model::SelectParameters>,
        pub(crate) output_location: std::option::Option<crate::model::OutputLocation>,
    }
    impl Builder {
        /// <p>When initiating a job to retrieve a vault inventory, you can optionally add this parameter to your request to specify the output format. If you are initiating an inventory job and do not specify a Format field, JSON is the default format. Valid values are "CSV" and "JSON".</p>
        pub fn format(mut self, input: impl Into<std::string::String>) -> Self {
            self.format = Some(input.into());
            self
        }
        /// <p>When initiating a job to retrieve a vault inventory, you can optionally add this parameter to your request to specify the output format. If you are initiating an inventory job and do not specify a Format field, JSON is the default format. Valid values are "CSV" and "JSON".</p>
        pub fn set_format(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.format = input;
            self
        }
        /// <p>The job type. You can initiate a job to perform a select query on an archive, retrieve an archive, or get an inventory of a vault. Valid values are "select", "archive-retrieval" and "inventory-retrieval".</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The job type. You can initiate a job to perform a select query on an archive, retrieve an archive, or get an inventory of a vault. Valid values are "select", "archive-retrieval" and "inventory-retrieval".</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The ID of the archive that you want to retrieve. This field is required only if <code>Type</code> is set to <code>select</code> or <code>archive-retrieval</code>code&gt;. An error occurs if you specify this request parameter for an inventory retrieval job request. </p>
        pub fn archive_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.archive_id = Some(input.into());
            self
        }
        /// <p>The ID of the archive that you want to retrieve. This field is required only if <code>Type</code> is set to <code>select</code> or <code>archive-retrieval</code>code&gt;. An error occurs if you specify this request parameter for an inventory retrieval job request. </p>
        pub fn set_archive_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.archive_id = input;
            self
        }
        /// <p>The optional description for the job. The description must be less than or equal to 1,024 bytes. The allowable characters are 7-bit ASCII without control codes-specifically, ASCII values 32-126 decimal or 0x20-0x7E hexadecimal.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The optional description for the job. The description must be less than or equal to 1,024 bytes. The allowable characters are 7-bit ASCII without control codes-specifically, ASCII values 32-126 decimal or 0x20-0x7E hexadecimal.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon SNS topic ARN to which Amazon S3 Glacier sends a notification when the job is completed and the output is ready for you to download. The specified topic publishes the notification to its subscribers. The SNS topic must exist.</p>
        pub fn sns_topic(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic = Some(input.into());
            self
        }
        /// <p>The Amazon SNS topic ARN to which Amazon S3 Glacier sends a notification when the job is completed and the output is ready for you to download. The specified topic publishes the notification to its subscribers. The SNS topic must exist.</p>
        pub fn set_sns_topic(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sns_topic = input;
            self
        }
        /// <p>The byte range to retrieve for an archive retrieval. in the form "<i>StartByteValue</i>-<i>EndByteValue</i>" If not specified, the whole archive is retrieved. If specified, the byte range must be megabyte (1024*1024) aligned which means that <i>StartByteValue</i> must be divisible by 1 MB and <i>EndByteValue</i> plus 1 must be divisible by 1 MB or be the end of the archive specified as the archive byte size value minus 1. If RetrievalByteRange is not megabyte aligned, this operation returns a 400 response. </p>
        /// <p>An error occurs if you specify this field for an inventory retrieval job request.</p>
        pub fn retrieval_byte_range(mut self, input: impl Into<std::string::String>) -> Self {
            self.retrieval_byte_range = Some(input.into());
            self
        }
        /// <p>The byte range to retrieve for an archive retrieval. in the form "<i>StartByteValue</i>-<i>EndByteValue</i>" If not specified, the whole archive is retrieved. If specified, the byte range must be megabyte (1024*1024) aligned which means that <i>StartByteValue</i> must be divisible by 1 MB and <i>EndByteValue</i> plus 1 must be divisible by 1 MB or be the end of the archive specified as the archive byte size value minus 1. If RetrievalByteRange is not megabyte aligned, this operation returns a 400 response. </p>
        /// <p>An error occurs if you specify this field for an inventory retrieval job request.</p>
        pub fn set_retrieval_byte_range(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.retrieval_byte_range = input;
            self
        }
        /// <p>The tier to use for a select or an archive retrieval job. Valid values are <code>Expedited</code>, <code>Standard</code>, or <code>Bulk</code>. <code>Standard</code> is the default.</p>
        pub fn tier(mut self, input: impl Into<std::string::String>) -> Self {
            self.tier = Some(input.into());
            self
        }
        /// <p>The tier to use for a select or an archive retrieval job. Valid values are <code>Expedited</code>, <code>Standard</code>, or <code>Bulk</code>. <code>Standard</code> is the default.</p>
        pub fn set_tier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tier = input;
            self
        }
        /// <p>Input parameters used for range inventory retrieval.</p>
        pub fn inventory_retrieval_parameters(
            mut self,
            input: crate::model::InventoryRetrievalJobInput,
        ) -> Self {
            self.inventory_retrieval_parameters = Some(input);
            self
        }
        /// <p>Input parameters used for range inventory retrieval.</p>
        pub fn set_inventory_retrieval_parameters(
            mut self,
            input: std::option::Option<crate::model::InventoryRetrievalJobInput>,
        ) -> Self {
            self.inventory_retrieval_parameters = input;
            self
        }
        /// <p>Contains the parameters that define a job.</p>
        pub fn select_parameters(mut self, input: crate::model::SelectParameters) -> Self {
            self.select_parameters = Some(input);
            self
        }
        /// <p>Contains the parameters that define a job.</p>
        pub fn set_select_parameters(
            mut self,
            input: std::option::Option<crate::model::SelectParameters>,
        ) -> Self {
            self.select_parameters = input;
            self
        }
        /// <p>Contains information about the location where the select job results are stored.</p>
        pub fn output_location(mut self, input: crate::model::OutputLocation) -> Self {
            self.output_location = Some(input);
            self
        }
        /// <p>Contains information about the location where the select job results are stored.</p>
        pub fn set_output_location(
            mut self,
            input: std::option::Option<crate::model::OutputLocation>,
        ) -> Self {
            self.output_location = input;
            self
        }
        /// Consumes the builder and constructs a [`JobParameters`](crate::model::JobParameters)
        pub fn build(self) -> crate::model::JobParameters {
            crate::model::JobParameters {
                format: self.format,
                r#type: self.r#type,
                archive_id: self.archive_id,
                description: self.description,
                sns_topic: self.sns_topic,
                retrieval_byte_range: self.retrieval_byte_range,
                tier: self.tier,
                inventory_retrieval_parameters: self.inventory_retrieval_parameters,
                select_parameters: self.select_parameters,
                output_location: self.output_location,
            }
        }
    }
}
impl JobParameters {
    /// Creates a new builder-style object to manufacture [`JobParameters`](crate::model::JobParameters)
    pub fn builder() -> crate::model::job_parameters::Builder {
        crate::model::job_parameters::Builder::default()
    }
}

/// <p>Provides options for specifying a range inventory retrieval job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InventoryRetrievalJobInput {
    /// <p>The start of the date range in UTC for vault inventory retrieval that includes archives created on or after this date. This value should be a string in the ISO 8601 date format, for example <code>2013-03-20T17:03:43Z</code>.</p>
    pub start_date: std::option::Option<std::string::String>,
    /// <p>The end of the date range in UTC for vault inventory retrieval that includes archives created before this date. This value should be a string in the ISO 8601 date format, for example <code>2013-03-20T17:03:43Z</code>.</p>
    pub end_date: std::option::Option<std::string::String>,
    /// <p>Specifies the maximum number of inventory items returned per vault inventory retrieval request. Valid values are greater than or equal to 1.</p>
    pub limit: std::option::Option<std::string::String>,
    /// <p>An opaque string that represents where to continue pagination of the vault inventory retrieval results. You use the marker in a new <b>InitiateJob</b> request to obtain additional inventory items. If there are no more inventory items, this value is <code>null</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl InventoryRetrievalJobInput {
    /// <p>The start of the date range in UTC for vault inventory retrieval that includes archives created on or after this date. This value should be a string in the ISO 8601 date format, for example <code>2013-03-20T17:03:43Z</code>.</p>
    pub fn start_date(&self) -> std::option::Option<&str> {
        self.start_date.as_deref()
    }
    /// <p>The end of the date range in UTC for vault inventory retrieval that includes archives created before this date. This value should be a string in the ISO 8601 date format, for example <code>2013-03-20T17:03:43Z</code>.</p>
    pub fn end_date(&self) -> std::option::Option<&str> {
        self.end_date.as_deref()
    }
    /// <p>Specifies the maximum number of inventory items returned per vault inventory retrieval request. Valid values are greater than or equal to 1.</p>
    pub fn limit(&self) -> std::option::Option<&str> {
        self.limit.as_deref()
    }
    /// <p>An opaque string that represents where to continue pagination of the vault inventory retrieval results. You use the marker in a new <b>InitiateJob</b> request to obtain additional inventory items. If there are no more inventory items, this value is <code>null</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for InventoryRetrievalJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InventoryRetrievalJobInput");
        formatter.field("start_date", &self.start_date);
        formatter.field("end_date", &self.end_date);
        formatter.field("limit", &self.limit);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`InventoryRetrievalJobInput`](crate::model::InventoryRetrievalJobInput)
pub mod inventory_retrieval_job_input {
    /// A builder for [`InventoryRetrievalJobInput`](crate::model::InventoryRetrievalJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_date: std::option::Option<std::string::String>,
        pub(crate) end_date: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The start of the date range in UTC for vault inventory retrieval that includes archives created on or after this date. This value should be a string in the ISO 8601 date format, for example <code>2013-03-20T17:03:43Z</code>.</p>
        pub fn start_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_date = Some(input.into());
            self
        }
        /// <p>The start of the date range in UTC for vault inventory retrieval that includes archives created on or after this date. This value should be a string in the ISO 8601 date format, for example <code>2013-03-20T17:03:43Z</code>.</p>
        pub fn set_start_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start_date = input;
            self
        }
        /// <p>The end of the date range in UTC for vault inventory retrieval that includes archives created before this date. This value should be a string in the ISO 8601 date format, for example <code>2013-03-20T17:03:43Z</code>.</p>
        pub fn end_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.end_date = Some(input.into());
            self
        }
        /// <p>The end of the date range in UTC for vault inventory retrieval that includes archives created before this date. This value should be a string in the ISO 8601 date format, for example <code>2013-03-20T17:03:43Z</code>.</p>
        pub fn set_end_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.end_date = input;
            self
        }
        /// <p>Specifies the maximum number of inventory items returned per vault inventory retrieval request. Valid values are greater than or equal to 1.</p>
        pub fn limit(mut self, input: impl Into<std::string::String>) -> Self {
            self.limit = Some(input.into());
            self
        }
        /// <p>Specifies the maximum number of inventory items returned per vault inventory retrieval request. Valid values are greater than or equal to 1.</p>
        pub fn set_limit(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.limit = input;
            self
        }
        /// <p>An opaque string that represents where to continue pagination of the vault inventory retrieval results. You use the marker in a new <b>InitiateJob</b> request to obtain additional inventory items. If there are no more inventory items, this value is <code>null</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An opaque string that represents where to continue pagination of the vault inventory retrieval results. You use the marker in a new <b>InitiateJob</b> request to obtain additional inventory items. If there are no more inventory items, this value is <code>null</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`InventoryRetrievalJobInput`](crate::model::InventoryRetrievalJobInput)
        pub fn build(self) -> crate::model::InventoryRetrievalJobInput {
            crate::model::InventoryRetrievalJobInput {
                start_date: self.start_date,
                end_date: self.end_date,
                limit: self.limit,
                marker: self.marker,
            }
        }
    }
}
impl InventoryRetrievalJobInput {
    /// Creates a new builder-style object to manufacture [`InventoryRetrievalJobInput`](crate::model::InventoryRetrievalJobInput)
    pub fn builder() -> crate::model::inventory_retrieval_job_input::Builder {
        crate::model::inventory_retrieval_job_input::Builder::default()
    }
}
