// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Contains the Amazon S3 Glacier response to your request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UploadMultipartPartOutput {
    /// <p>The SHA256 tree hash that Amazon S3 Glacier computed for the uploaded part.</p>
    pub checksum: std::option::Option<std::string::String>,
}
impl UploadMultipartPartOutput {
    /// <p>The SHA256 tree hash that Amazon S3 Glacier computed for the uploaded part.</p>
    pub fn checksum(&self) -> std::option::Option<&str> {
        self.checksum.as_deref()
    }
}
impl std::fmt::Debug for UploadMultipartPartOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UploadMultipartPartOutput");
        formatter.field("checksum", &self.checksum);
        formatter.finish()
    }
}
/// See [`UploadMultipartPartOutput`](crate::output::UploadMultipartPartOutput)
pub mod upload_multipart_part_output {
    /// A builder for [`UploadMultipartPartOutput`](crate::output::UploadMultipartPartOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) checksum: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The SHA256 tree hash that Amazon S3 Glacier computed for the uploaded part.</p>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.checksum = Some(input.into());
            self
        }
        /// <p>The SHA256 tree hash that Amazon S3 Glacier computed for the uploaded part.</p>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.checksum = input;
            self
        }
        /// Consumes the builder and constructs a [`UploadMultipartPartOutput`](crate::output::UploadMultipartPartOutput)
        pub fn build(self) -> crate::output::UploadMultipartPartOutput {
            crate::output::UploadMultipartPartOutput {
                checksum: self.checksum,
            }
        }
    }
}
impl UploadMultipartPartOutput {
    /// Creates a new builder-style object to manufacture [`UploadMultipartPartOutput`](crate::output::UploadMultipartPartOutput)
    pub fn builder() -> crate::output::upload_multipart_part_output::Builder {
        crate::output::upload_multipart_part_output::Builder::default()
    }
}

/// <p>Contains the Amazon S3 Glacier response to your request.</p>
/// <p>For information about the underlying REST API, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-post.html">Upload Archive</a>. For
/// conceptual information, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html">Working with Archives in
/// Amazon S3 Glacier</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UploadArchiveOutput {
    /// <p>The relative URI path of the newly added archive resource.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The checksum of the archive computed by Amazon S3 Glacier.</p>
    pub checksum: std::option::Option<std::string::String>,
    /// <p>The ID of the archive. This value is also included as part of the location.</p>
    pub archive_id: std::option::Option<std::string::String>,
}
impl UploadArchiveOutput {
    /// <p>The relative URI path of the newly added archive resource.</p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
    /// <p>The checksum of the archive computed by Amazon S3 Glacier.</p>
    pub fn checksum(&self) -> std::option::Option<&str> {
        self.checksum.as_deref()
    }
    /// <p>The ID of the archive. This value is also included as part of the location.</p>
    pub fn archive_id(&self) -> std::option::Option<&str> {
        self.archive_id.as_deref()
    }
}
impl std::fmt::Debug for UploadArchiveOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UploadArchiveOutput");
        formatter.field("location", &self.location);
        formatter.field("checksum", &self.checksum);
        formatter.field("archive_id", &self.archive_id);
        formatter.finish()
    }
}
/// See [`UploadArchiveOutput`](crate::output::UploadArchiveOutput)
pub mod upload_archive_output {
    /// A builder for [`UploadArchiveOutput`](crate::output::UploadArchiveOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) checksum: std::option::Option<std::string::String>,
        pub(crate) archive_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The relative URI path of the newly added archive resource.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The relative URI path of the newly added archive resource.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The checksum of the archive computed by Amazon S3 Glacier.</p>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.checksum = Some(input.into());
            self
        }
        /// <p>The checksum of the archive computed by Amazon S3 Glacier.</p>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.checksum = input;
            self
        }
        /// <p>The ID of the archive. This value is also included as part of the location.</p>
        pub fn archive_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.archive_id = Some(input.into());
            self
        }
        /// <p>The ID of the archive. This value is also included as part of the location.</p>
        pub fn set_archive_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.archive_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UploadArchiveOutput`](crate::output::UploadArchiveOutput)
        pub fn build(self) -> crate::output::UploadArchiveOutput {
            crate::output::UploadArchiveOutput {
                location: self.location,
                checksum: self.checksum,
                archive_id: self.archive_id,
            }
        }
    }
}
impl UploadArchiveOutput {
    /// Creates a new builder-style object to manufacture [`UploadArchiveOutput`](crate::output::UploadArchiveOutput)
    pub fn builder() -> crate::output::upload_archive_output::Builder {
        crate::output::upload_archive_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetVaultNotificationsOutput {}
impl std::fmt::Debug for SetVaultNotificationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetVaultNotificationsOutput");
        formatter.finish()
    }
}
/// See [`SetVaultNotificationsOutput`](crate::output::SetVaultNotificationsOutput)
pub mod set_vault_notifications_output {
    /// A builder for [`SetVaultNotificationsOutput`](crate::output::SetVaultNotificationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SetVaultNotificationsOutput`](crate::output::SetVaultNotificationsOutput)
        pub fn build(self) -> crate::output::SetVaultNotificationsOutput {
            crate::output::SetVaultNotificationsOutput {}
        }
    }
}
impl SetVaultNotificationsOutput {
    /// Creates a new builder-style object to manufacture [`SetVaultNotificationsOutput`](crate::output::SetVaultNotificationsOutput)
    pub fn builder() -> crate::output::set_vault_notifications_output::Builder {
        crate::output::set_vault_notifications_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetVaultAccessPolicyOutput {}
impl std::fmt::Debug for SetVaultAccessPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetVaultAccessPolicyOutput");
        formatter.finish()
    }
}
/// See [`SetVaultAccessPolicyOutput`](crate::output::SetVaultAccessPolicyOutput)
pub mod set_vault_access_policy_output {
    /// A builder for [`SetVaultAccessPolicyOutput`](crate::output::SetVaultAccessPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SetVaultAccessPolicyOutput`](crate::output::SetVaultAccessPolicyOutput)
        pub fn build(self) -> crate::output::SetVaultAccessPolicyOutput {
            crate::output::SetVaultAccessPolicyOutput {}
        }
    }
}
impl SetVaultAccessPolicyOutput {
    /// Creates a new builder-style object to manufacture [`SetVaultAccessPolicyOutput`](crate::output::SetVaultAccessPolicyOutput)
    pub fn builder() -> crate::output::set_vault_access_policy_output::Builder {
        crate::output::set_vault_access_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetDataRetrievalPolicyOutput {}
impl std::fmt::Debug for SetDataRetrievalPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetDataRetrievalPolicyOutput");
        formatter.finish()
    }
}
/// See [`SetDataRetrievalPolicyOutput`](crate::output::SetDataRetrievalPolicyOutput)
pub mod set_data_retrieval_policy_output {
    /// A builder for [`SetDataRetrievalPolicyOutput`](crate::output::SetDataRetrievalPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SetDataRetrievalPolicyOutput`](crate::output::SetDataRetrievalPolicyOutput)
        pub fn build(self) -> crate::output::SetDataRetrievalPolicyOutput {
            crate::output::SetDataRetrievalPolicyOutput {}
        }
    }
}
impl SetDataRetrievalPolicyOutput {
    /// Creates a new builder-style object to manufacture [`SetDataRetrievalPolicyOutput`](crate::output::SetDataRetrievalPolicyOutput)
    pub fn builder() -> crate::output::set_data_retrieval_policy_output::Builder {
        crate::output::set_data_retrieval_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTagsFromVaultOutput {}
impl std::fmt::Debug for RemoveTagsFromVaultOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTagsFromVaultOutput");
        formatter.finish()
    }
}
/// See [`RemoveTagsFromVaultOutput`](crate::output::RemoveTagsFromVaultOutput)
pub mod remove_tags_from_vault_output {
    /// A builder for [`RemoveTagsFromVaultOutput`](crate::output::RemoveTagsFromVaultOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RemoveTagsFromVaultOutput`](crate::output::RemoveTagsFromVaultOutput)
        pub fn build(self) -> crate::output::RemoveTagsFromVaultOutput {
            crate::output::RemoveTagsFromVaultOutput {}
        }
    }
}
impl RemoveTagsFromVaultOutput {
    /// Creates a new builder-style object to manufacture [`RemoveTagsFromVaultOutput`](crate::output::RemoveTagsFromVaultOutput)
    pub fn builder() -> crate::output::remove_tags_from_vault_output::Builder {
        crate::output::remove_tags_from_vault_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PurchaseProvisionedCapacityOutput {
    /// <p>The ID that identifies the provisioned capacity unit.</p>
    pub capacity_id: std::option::Option<std::string::String>,
}
impl PurchaseProvisionedCapacityOutput {
    /// <p>The ID that identifies the provisioned capacity unit.</p>
    pub fn capacity_id(&self) -> std::option::Option<&str> {
        self.capacity_id.as_deref()
    }
}
impl std::fmt::Debug for PurchaseProvisionedCapacityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PurchaseProvisionedCapacityOutput");
        formatter.field("capacity_id", &self.capacity_id);
        formatter.finish()
    }
}
/// See [`PurchaseProvisionedCapacityOutput`](crate::output::PurchaseProvisionedCapacityOutput)
pub mod purchase_provisioned_capacity_output {
    /// A builder for [`PurchaseProvisionedCapacityOutput`](crate::output::PurchaseProvisionedCapacityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) capacity_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID that identifies the provisioned capacity unit.</p>
        pub fn capacity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.capacity_id = Some(input.into());
            self
        }
        /// <p>The ID that identifies the provisioned capacity unit.</p>
        pub fn set_capacity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.capacity_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PurchaseProvisionedCapacityOutput`](crate::output::PurchaseProvisionedCapacityOutput)
        pub fn build(self) -> crate::output::PurchaseProvisionedCapacityOutput {
            crate::output::PurchaseProvisionedCapacityOutput {
                capacity_id: self.capacity_id,
            }
        }
    }
}
impl PurchaseProvisionedCapacityOutput {
    /// Creates a new builder-style object to manufacture [`PurchaseProvisionedCapacityOutput`](crate::output::PurchaseProvisionedCapacityOutput)
    pub fn builder() -> crate::output::purchase_provisioned_capacity_output::Builder {
        crate::output::purchase_provisioned_capacity_output::Builder::default()
    }
}

/// <p>Contains the Amazon S3 Glacier response to your request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListVaultsOutput {
    /// <p>List of vaults.</p>
    pub vault_list: std::option::Option<std::vec::Vec<crate::model::DescribeVaultOutput>>,
    /// <p>The vault ARN at which to continue pagination of the results. You use the marker in
    /// another List Vaults request to obtain more vaults in the list.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListVaultsOutput {
    /// <p>List of vaults.</p>
    pub fn vault_list(&self) -> std::option::Option<&[crate::model::DescribeVaultOutput]> {
        self.vault_list.as_deref()
    }
    /// <p>The vault ARN at which to continue pagination of the results. You use the marker in
    /// another List Vaults request to obtain more vaults in the list.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListVaultsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListVaultsOutput");
        formatter.field("vault_list", &self.vault_list);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListVaultsOutput`](crate::output::ListVaultsOutput)
pub mod list_vaults_output {
    /// A builder for [`ListVaultsOutput`](crate::output::ListVaultsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vault_list:
            std::option::Option<std::vec::Vec<crate::model::DescribeVaultOutput>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `vault_list`.
        ///
        /// To override the contents of this collection use [`set_vault_list`](Self::set_vault_list).
        ///
        /// <p>List of vaults.</p>
        pub fn vault_list(mut self, input: impl Into<crate::model::DescribeVaultOutput>) -> Self {
            let mut v = self.vault_list.unwrap_or_default();
            v.push(input.into());
            self.vault_list = Some(v);
            self
        }
        /// <p>List of vaults.</p>
        pub fn set_vault_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DescribeVaultOutput>>,
        ) -> Self {
            self.vault_list = input;
            self
        }
        /// <p>The vault ARN at which to continue pagination of the results. You use the marker in
        /// another List Vaults request to obtain more vaults in the list.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The vault ARN at which to continue pagination of the results. You use the marker in
        /// another List Vaults request to obtain more vaults in the list.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListVaultsOutput`](crate::output::ListVaultsOutput)
        pub fn build(self) -> crate::output::ListVaultsOutput {
            crate::output::ListVaultsOutput {
                vault_list: self.vault_list,
                marker: self.marker,
            }
        }
    }
}
impl ListVaultsOutput {
    /// Creates a new builder-style object to manufacture [`ListVaultsOutput`](crate::output::ListVaultsOutput)
    pub fn builder() -> crate::output::list_vaults_output::Builder {
        crate::output::list_vaults_output::Builder::default()
    }
}

/// <p>Contains the Amazon S3 Glacier response to your request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForVaultOutput {
    /// <p>The tags attached to the vault. Each tag is composed of a key and a value.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForVaultOutput {
    /// <p>The tags attached to the vault. Each tag is composed of a key and a value.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForVaultOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForVaultOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForVaultOutput`](crate::output::ListTagsForVaultOutput)
pub mod list_tags_for_vault_output {
    /// A builder for [`ListTagsForVaultOutput`](crate::output::ListTagsForVaultOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags attached to the vault. Each tag is composed of a key and a value.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags attached to the vault. Each tag is composed of a key and a value.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForVaultOutput`](crate::output::ListTagsForVaultOutput)
        pub fn build(self) -> crate::output::ListTagsForVaultOutput {
            crate::output::ListTagsForVaultOutput { tags: self.tags }
        }
    }
}
impl ListTagsForVaultOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForVaultOutput`](crate::output::ListTagsForVaultOutput)
    pub fn builder() -> crate::output::list_tags_for_vault_output::Builder {
        crate::output::list_tags_for_vault_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProvisionedCapacityOutput {
    /// <p>The response body contains the following JSON fields.</p>
    pub provisioned_capacity_list:
        std::option::Option<std::vec::Vec<crate::model::ProvisionedCapacityDescription>>,
}
impl ListProvisionedCapacityOutput {
    /// <p>The response body contains the following JSON fields.</p>
    pub fn provisioned_capacity_list(
        &self,
    ) -> std::option::Option<&[crate::model::ProvisionedCapacityDescription]> {
        self.provisioned_capacity_list.as_deref()
    }
}
impl std::fmt::Debug for ListProvisionedCapacityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProvisionedCapacityOutput");
        formatter.field("provisioned_capacity_list", &self.provisioned_capacity_list);
        formatter.finish()
    }
}
/// See [`ListProvisionedCapacityOutput`](crate::output::ListProvisionedCapacityOutput)
pub mod list_provisioned_capacity_output {
    /// A builder for [`ListProvisionedCapacityOutput`](crate::output::ListProvisionedCapacityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) provisioned_capacity_list:
            std::option::Option<std::vec::Vec<crate::model::ProvisionedCapacityDescription>>,
    }
    impl Builder {
        /// Appends an item to `provisioned_capacity_list`.
        ///
        /// To override the contents of this collection use [`set_provisioned_capacity_list`](Self::set_provisioned_capacity_list).
        ///
        /// <p>The response body contains the following JSON fields.</p>
        pub fn provisioned_capacity_list(
            mut self,
            input: impl Into<crate::model::ProvisionedCapacityDescription>,
        ) -> Self {
            let mut v = self.provisioned_capacity_list.unwrap_or_default();
            v.push(input.into());
            self.provisioned_capacity_list = Some(v);
            self
        }
        /// <p>The response body contains the following JSON fields.</p>
        pub fn set_provisioned_capacity_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProvisionedCapacityDescription>>,
        ) -> Self {
            self.provisioned_capacity_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProvisionedCapacityOutput`](crate::output::ListProvisionedCapacityOutput)
        pub fn build(self) -> crate::output::ListProvisionedCapacityOutput {
            crate::output::ListProvisionedCapacityOutput {
                provisioned_capacity_list: self.provisioned_capacity_list,
            }
        }
    }
}
impl ListProvisionedCapacityOutput {
    /// Creates a new builder-style object to manufacture [`ListProvisionedCapacityOutput`](crate::output::ListProvisionedCapacityOutput)
    pub fn builder() -> crate::output::list_provisioned_capacity_output::Builder {
        crate::output::list_provisioned_capacity_output::Builder::default()
    }
}

/// <p>Contains the Amazon S3 Glacier response to your request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPartsOutput {
    /// <p>The ID of the upload to which the parts are associated.</p>
    pub multipart_upload_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the vault to which the multipart upload was
    /// initiated.</p>
    pub vault_arn: std::option::Option<std::string::String>,
    /// <p>The description of the archive that was specified in the Initiate Multipart Upload
    /// request.</p>
    pub archive_description: std::option::Option<std::string::String>,
    /// <p>The part size in bytes. This is the same value that you specified in the Initiate
    /// Multipart Upload request.</p>
    pub part_size_in_bytes: i64,
    /// <p>The UTC time at which the multipart upload was initiated.</p>
    pub creation_date: std::option::Option<std::string::String>,
    /// <p>A list of the part sizes of the multipart upload. Each object in the array contains a
    /// <code>RangeBytes</code> and <code>sha256-tree-hash</code> name/value
    /// pair.</p>
    pub parts: std::option::Option<std::vec::Vec<crate::model::PartListElement>>,
    /// <p>An opaque string that represents where to continue pagination of the results. You use
    /// the marker in a new List Parts request to obtain more jobs in the list. If there are no
    /// more parts, this value is <code>null</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListPartsOutput {
    /// <p>The ID of the upload to which the parts are associated.</p>
    pub fn multipart_upload_id(&self) -> std::option::Option<&str> {
        self.multipart_upload_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the vault to which the multipart upload was
    /// initiated.</p>
    pub fn vault_arn(&self) -> std::option::Option<&str> {
        self.vault_arn.as_deref()
    }
    /// <p>The description of the archive that was specified in the Initiate Multipart Upload
    /// request.</p>
    pub fn archive_description(&self) -> std::option::Option<&str> {
        self.archive_description.as_deref()
    }
    /// <p>The part size in bytes. This is the same value that you specified in the Initiate
    /// Multipart Upload request.</p>
    pub fn part_size_in_bytes(&self) -> i64 {
        self.part_size_in_bytes
    }
    /// <p>The UTC time at which the multipart upload was initiated.</p>
    pub fn creation_date(&self) -> std::option::Option<&str> {
        self.creation_date.as_deref()
    }
    /// <p>A list of the part sizes of the multipart upload. Each object in the array contains a
    /// <code>RangeBytes</code> and <code>sha256-tree-hash</code> name/value
    /// pair.</p>
    pub fn parts(&self) -> std::option::Option<&[crate::model::PartListElement]> {
        self.parts.as_deref()
    }
    /// <p>An opaque string that represents where to continue pagination of the results. You use
    /// the marker in a new List Parts request to obtain more jobs in the list. If there are no
    /// more parts, this value is <code>null</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListPartsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPartsOutput");
        formatter.field("multipart_upload_id", &self.multipart_upload_id);
        formatter.field("vault_arn", &self.vault_arn);
        formatter.field("archive_description", &self.archive_description);
        formatter.field("part_size_in_bytes", &self.part_size_in_bytes);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("parts", &self.parts);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListPartsOutput`](crate::output::ListPartsOutput)
pub mod list_parts_output {
    /// A builder for [`ListPartsOutput`](crate::output::ListPartsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) multipart_upload_id: std::option::Option<std::string::String>,
        pub(crate) vault_arn: std::option::Option<std::string::String>,
        pub(crate) archive_description: std::option::Option<std::string::String>,
        pub(crate) part_size_in_bytes: std::option::Option<i64>,
        pub(crate) creation_date: std::option::Option<std::string::String>,
        pub(crate) parts: std::option::Option<std::vec::Vec<crate::model::PartListElement>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the upload to which the parts are associated.</p>
        pub fn multipart_upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.multipart_upload_id = Some(input.into());
            self
        }
        /// <p>The ID of the upload to which the parts are associated.</p>
        pub fn set_multipart_upload_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.multipart_upload_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the vault to which the multipart upload was
        /// initiated.</p>
        pub fn vault_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the vault to which the multipart upload was
        /// initiated.</p>
        pub fn set_vault_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_arn = input;
            self
        }
        /// <p>The description of the archive that was specified in the Initiate Multipart Upload
        /// request.</p>
        pub fn archive_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.archive_description = Some(input.into());
            self
        }
        /// <p>The description of the archive that was specified in the Initiate Multipart Upload
        /// request.</p>
        pub fn set_archive_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.archive_description = input;
            self
        }
        /// <p>The part size in bytes. This is the same value that you specified in the Initiate
        /// Multipart Upload request.</p>
        pub fn part_size_in_bytes(mut self, input: i64) -> Self {
            self.part_size_in_bytes = Some(input);
            self
        }
        /// <p>The part size in bytes. This is the same value that you specified in the Initiate
        /// Multipart Upload request.</p>
        pub fn set_part_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.part_size_in_bytes = input;
            self
        }
        /// <p>The UTC time at which the multipart upload was initiated.</p>
        pub fn creation_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_date = Some(input.into());
            self
        }
        /// <p>The UTC time at which the multipart upload was initiated.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// Appends an item to `parts`.
        ///
        /// To override the contents of this collection use [`set_parts`](Self::set_parts).
        ///
        /// <p>A list of the part sizes of the multipart upload. Each object in the array contains a
        /// <code>RangeBytes</code> and <code>sha256-tree-hash</code> name/value
        /// pair.</p>
        pub fn parts(mut self, input: impl Into<crate::model::PartListElement>) -> Self {
            let mut v = self.parts.unwrap_or_default();
            v.push(input.into());
            self.parts = Some(v);
            self
        }
        /// <p>A list of the part sizes of the multipart upload. Each object in the array contains a
        /// <code>RangeBytes</code> and <code>sha256-tree-hash</code> name/value
        /// pair.</p>
        pub fn set_parts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PartListElement>>,
        ) -> Self {
            self.parts = input;
            self
        }
        /// <p>An opaque string that represents where to continue pagination of the results. You use
        /// the marker in a new List Parts request to obtain more jobs in the list. If there are no
        /// more parts, this value is <code>null</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An opaque string that represents where to continue pagination of the results. You use
        /// the marker in a new List Parts request to obtain more jobs in the list. If there are no
        /// more parts, this value is <code>null</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPartsOutput`](crate::output::ListPartsOutput)
        pub fn build(self) -> crate::output::ListPartsOutput {
            crate::output::ListPartsOutput {
                multipart_upload_id: self.multipart_upload_id,
                vault_arn: self.vault_arn,
                archive_description: self.archive_description,
                part_size_in_bytes: self.part_size_in_bytes.unwrap_or_default(),
                creation_date: self.creation_date,
                parts: self.parts,
                marker: self.marker,
            }
        }
    }
}
impl ListPartsOutput {
    /// Creates a new builder-style object to manufacture [`ListPartsOutput`](crate::output::ListPartsOutput)
    pub fn builder() -> crate::output::list_parts_output::Builder {
        crate::output::list_parts_output::Builder::default()
    }
}

/// <p>Contains the Amazon S3 Glacier response to your request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMultipartUploadsOutput {
    /// <p>A list of in-progress multipart uploads.</p>
    pub uploads_list: std::option::Option<std::vec::Vec<crate::model::UploadListElement>>,
    /// <p>An opaque string that represents where to continue pagination of the results. You use
    /// the marker in a new List Multipart Uploads request to obtain more uploads in the list. If
    /// there are no more uploads, this value is <code>null</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListMultipartUploadsOutput {
    /// <p>A list of in-progress multipart uploads.</p>
    pub fn uploads_list(&self) -> std::option::Option<&[crate::model::UploadListElement]> {
        self.uploads_list.as_deref()
    }
    /// <p>An opaque string that represents where to continue pagination of the results. You use
    /// the marker in a new List Multipart Uploads request to obtain more uploads in the list. If
    /// there are no more uploads, this value is <code>null</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListMultipartUploadsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMultipartUploadsOutput");
        formatter.field("uploads_list", &self.uploads_list);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListMultipartUploadsOutput`](crate::output::ListMultipartUploadsOutput)
pub mod list_multipart_uploads_output {
    /// A builder for [`ListMultipartUploadsOutput`](crate::output::ListMultipartUploadsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) uploads_list:
            std::option::Option<std::vec::Vec<crate::model::UploadListElement>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `uploads_list`.
        ///
        /// To override the contents of this collection use [`set_uploads_list`](Self::set_uploads_list).
        ///
        /// <p>A list of in-progress multipart uploads.</p>
        pub fn uploads_list(mut self, input: impl Into<crate::model::UploadListElement>) -> Self {
            let mut v = self.uploads_list.unwrap_or_default();
            v.push(input.into());
            self.uploads_list = Some(v);
            self
        }
        /// <p>A list of in-progress multipart uploads.</p>
        pub fn set_uploads_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UploadListElement>>,
        ) -> Self {
            self.uploads_list = input;
            self
        }
        /// <p>An opaque string that represents where to continue pagination of the results. You use
        /// the marker in a new List Multipart Uploads request to obtain more uploads in the list. If
        /// there are no more uploads, this value is <code>null</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An opaque string that represents where to continue pagination of the results. You use
        /// the marker in a new List Multipart Uploads request to obtain more uploads in the list. If
        /// there are no more uploads, this value is <code>null</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMultipartUploadsOutput`](crate::output::ListMultipartUploadsOutput)
        pub fn build(self) -> crate::output::ListMultipartUploadsOutput {
            crate::output::ListMultipartUploadsOutput {
                uploads_list: self.uploads_list,
                marker: self.marker,
            }
        }
    }
}
impl ListMultipartUploadsOutput {
    /// Creates a new builder-style object to manufacture [`ListMultipartUploadsOutput`](crate::output::ListMultipartUploadsOutput)
    pub fn builder() -> crate::output::list_multipart_uploads_output::Builder {
        crate::output::list_multipart_uploads_output::Builder::default()
    }
}

/// <p>Contains the Amazon S3 Glacier response to your request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListJobsOutput {
    /// <p>A list of job objects. Each job object contains metadata describing the
    /// job.</p>
    pub job_list: std::option::Option<std::vec::Vec<crate::model::GlacierJobDescription>>,
    /// <p>  
    /// An opaque string used for pagination that specifies the job at which the listing of jobs should begin.
    /// You get the <code>marker</code> value from a previous List Jobs response.
    /// You only need to include the marker if you are continuing the pagination of the results started in a
    /// previous List Jobs request. </p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListJobsOutput {
    /// <p>A list of job objects. Each job object contains metadata describing the
    /// job.</p>
    pub fn job_list(&self) -> std::option::Option<&[crate::model::GlacierJobDescription]> {
        self.job_list.as_deref()
    }
    /// <p>  
    /// An opaque string used for pagination that specifies the job at which the listing of jobs should begin.
    /// You get the <code>marker</code> value from a previous List Jobs response.
    /// You only need to include the marker if you are continuing the pagination of the results started in a
    /// previous List Jobs request. </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListJobsOutput");
        formatter.field("job_list", &self.job_list);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListJobsOutput`](crate::output::ListJobsOutput)
pub mod list_jobs_output {
    /// A builder for [`ListJobsOutput`](crate::output::ListJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_list:
            std::option::Option<std::vec::Vec<crate::model::GlacierJobDescription>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `job_list`.
        ///
        /// To override the contents of this collection use [`set_job_list`](Self::set_job_list).
        ///
        /// <p>A list of job objects. Each job object contains metadata describing the
        /// job.</p>
        pub fn job_list(mut self, input: impl Into<crate::model::GlacierJobDescription>) -> Self {
            let mut v = self.job_list.unwrap_or_default();
            v.push(input.into());
            self.job_list = Some(v);
            self
        }
        /// <p>A list of job objects. Each job object contains metadata describing the
        /// job.</p>
        pub fn set_job_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GlacierJobDescription>>,
        ) -> Self {
            self.job_list = input;
            self
        }
        /// <p>  
        /// An opaque string used for pagination that specifies the job at which the listing of jobs should begin.
        /// You get the <code>marker</code> value from a previous List Jobs response.
        /// You only need to include the marker if you are continuing the pagination of the results started in a
        /// previous List Jobs request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>  
        /// An opaque string used for pagination that specifies the job at which the listing of jobs should begin.
        /// You get the <code>marker</code> value from a previous List Jobs response.
        /// You only need to include the marker if you are continuing the pagination of the results started in a
        /// previous List Jobs request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListJobsOutput`](crate::output::ListJobsOutput)
        pub fn build(self) -> crate::output::ListJobsOutput {
            crate::output::ListJobsOutput {
                job_list: self.job_list,
                marker: self.marker,
            }
        }
    }
}
impl ListJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListJobsOutput`](crate::output::ListJobsOutput)
    pub fn builder() -> crate::output::list_jobs_output::Builder {
        crate::output::list_jobs_output::Builder::default()
    }
}

/// <p>Contains the Amazon S3 Glacier response to your request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InitiateVaultLockOutput {
    /// <p>The lock ID, which is used to complete the vault locking process.</p>
    pub lock_id: std::option::Option<std::string::String>,
}
impl InitiateVaultLockOutput {
    /// <p>The lock ID, which is used to complete the vault locking process.</p>
    pub fn lock_id(&self) -> std::option::Option<&str> {
        self.lock_id.as_deref()
    }
}
impl std::fmt::Debug for InitiateVaultLockOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InitiateVaultLockOutput");
        formatter.field("lock_id", &self.lock_id);
        formatter.finish()
    }
}
/// See [`InitiateVaultLockOutput`](crate::output::InitiateVaultLockOutput)
pub mod initiate_vault_lock_output {
    /// A builder for [`InitiateVaultLockOutput`](crate::output::InitiateVaultLockOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lock_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The lock ID, which is used to complete the vault locking process.</p>
        pub fn lock_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.lock_id = Some(input.into());
            self
        }
        /// <p>The lock ID, which is used to complete the vault locking process.</p>
        pub fn set_lock_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lock_id = input;
            self
        }
        /// Consumes the builder and constructs a [`InitiateVaultLockOutput`](crate::output::InitiateVaultLockOutput)
        pub fn build(self) -> crate::output::InitiateVaultLockOutput {
            crate::output::InitiateVaultLockOutput {
                lock_id: self.lock_id,
            }
        }
    }
}
impl InitiateVaultLockOutput {
    /// Creates a new builder-style object to manufacture [`InitiateVaultLockOutput`](crate::output::InitiateVaultLockOutput)
    pub fn builder() -> crate::output::initiate_vault_lock_output::Builder {
        crate::output::initiate_vault_lock_output::Builder::default()
    }
}

/// <p>The Amazon S3 Glacier response to your request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InitiateMultipartUploadOutput {
    /// <p>The relative URI path of the multipart upload ID Amazon S3 Glacier created.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The ID of the multipart upload. This value is also included as part of the
    /// location.</p>
    pub upload_id: std::option::Option<std::string::String>,
}
impl InitiateMultipartUploadOutput {
    /// <p>The relative URI path of the multipart upload ID Amazon S3 Glacier created.</p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
    /// <p>The ID of the multipart upload. This value is also included as part of the
    /// location.</p>
    pub fn upload_id(&self) -> std::option::Option<&str> {
        self.upload_id.as_deref()
    }
}
impl std::fmt::Debug for InitiateMultipartUploadOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InitiateMultipartUploadOutput");
        formatter.field("location", &self.location);
        formatter.field("upload_id", &self.upload_id);
        formatter.finish()
    }
}
/// See [`InitiateMultipartUploadOutput`](crate::output::InitiateMultipartUploadOutput)
pub mod initiate_multipart_upload_output {
    /// A builder for [`InitiateMultipartUploadOutput`](crate::output::InitiateMultipartUploadOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) upload_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The relative URI path of the multipart upload ID Amazon S3 Glacier created.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The relative URI path of the multipart upload ID Amazon S3 Glacier created.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The ID of the multipart upload. This value is also included as part of the
        /// location.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id = Some(input.into());
            self
        }
        /// <p>The ID of the multipart upload. This value is also included as part of the
        /// location.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upload_id = input;
            self
        }
        /// Consumes the builder and constructs a [`InitiateMultipartUploadOutput`](crate::output::InitiateMultipartUploadOutput)
        pub fn build(self) -> crate::output::InitiateMultipartUploadOutput {
            crate::output::InitiateMultipartUploadOutput {
                location: self.location,
                upload_id: self.upload_id,
            }
        }
    }
}
impl InitiateMultipartUploadOutput {
    /// Creates a new builder-style object to manufacture [`InitiateMultipartUploadOutput`](crate::output::InitiateMultipartUploadOutput)
    pub fn builder() -> crate::output::initiate_multipart_upload_output::Builder {
        crate::output::initiate_multipart_upload_output::Builder::default()
    }
}

/// <p>Contains the Amazon S3 Glacier response to your request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InitiateJobOutput {
    /// <p>The relative URI path of the job.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The ID of the job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The path to the location of where the select results are stored.</p>
    pub job_output_path: std::option::Option<std::string::String>,
}
impl InitiateJobOutput {
    /// <p>The relative URI path of the job.</p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
    /// <p>The ID of the job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The path to the location of where the select results are stored.</p>
    pub fn job_output_path(&self) -> std::option::Option<&str> {
        self.job_output_path.as_deref()
    }
}
impl std::fmt::Debug for InitiateJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InitiateJobOutput");
        formatter.field("location", &self.location);
        formatter.field("job_id", &self.job_id);
        formatter.field("job_output_path", &self.job_output_path);
        formatter.finish()
    }
}
/// See [`InitiateJobOutput`](crate::output::InitiateJobOutput)
pub mod initiate_job_output {
    /// A builder for [`InitiateJobOutput`](crate::output::InitiateJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) job_output_path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The relative URI path of the job.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The relative URI path of the job.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The ID of the job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID of the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The path to the location of where the select results are stored.</p>
        pub fn job_output_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_output_path = Some(input.into());
            self
        }
        /// <p>The path to the location of where the select results are stored.</p>
        pub fn set_job_output_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_output_path = input;
            self
        }
        /// Consumes the builder and constructs a [`InitiateJobOutput`](crate::output::InitiateJobOutput)
        pub fn build(self) -> crate::output::InitiateJobOutput {
            crate::output::InitiateJobOutput {
                location: self.location,
                job_id: self.job_id,
                job_output_path: self.job_output_path,
            }
        }
    }
}
impl InitiateJobOutput {
    /// Creates a new builder-style object to manufacture [`InitiateJobOutput`](crate::output::InitiateJobOutput)
    pub fn builder() -> crate::output::initiate_job_output::Builder {
        crate::output::initiate_job_output::Builder::default()
    }
}

/// <p>Contains the Amazon S3 Glacier response to your request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetVaultNotificationsOutput {
    /// <p>Returns the notification configuration set on the vault.</p>
    pub vault_notification_config: std::option::Option<crate::model::VaultNotificationConfig>,
}
impl GetVaultNotificationsOutput {
    /// <p>Returns the notification configuration set on the vault.</p>
    pub fn vault_notification_config(
        &self,
    ) -> std::option::Option<&crate::model::VaultNotificationConfig> {
        self.vault_notification_config.as_ref()
    }
}
impl std::fmt::Debug for GetVaultNotificationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetVaultNotificationsOutput");
        formatter.field("vault_notification_config", &self.vault_notification_config);
        formatter.finish()
    }
}
/// See [`GetVaultNotificationsOutput`](crate::output::GetVaultNotificationsOutput)
pub mod get_vault_notifications_output {
    /// A builder for [`GetVaultNotificationsOutput`](crate::output::GetVaultNotificationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vault_notification_config:
            std::option::Option<crate::model::VaultNotificationConfig>,
    }
    impl Builder {
        /// <p>Returns the notification configuration set on the vault.</p>
        pub fn vault_notification_config(
            mut self,
            input: crate::model::VaultNotificationConfig,
        ) -> Self {
            self.vault_notification_config = Some(input);
            self
        }
        /// <p>Returns the notification configuration set on the vault.</p>
        pub fn set_vault_notification_config(
            mut self,
            input: std::option::Option<crate::model::VaultNotificationConfig>,
        ) -> Self {
            self.vault_notification_config = input;
            self
        }
        /// Consumes the builder and constructs a [`GetVaultNotificationsOutput`](crate::output::GetVaultNotificationsOutput)
        pub fn build(self) -> crate::output::GetVaultNotificationsOutput {
            crate::output::GetVaultNotificationsOutput {
                vault_notification_config: self.vault_notification_config,
            }
        }
    }
}
impl GetVaultNotificationsOutput {
    /// Creates a new builder-style object to manufacture [`GetVaultNotificationsOutput`](crate::output::GetVaultNotificationsOutput)
    pub fn builder() -> crate::output::get_vault_notifications_output::Builder {
        crate::output::get_vault_notifications_output::Builder::default()
    }
}

/// <p>Contains the Amazon S3 Glacier response to your request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetVaultLockOutput {
    /// <p>The vault lock policy as a JSON string, which uses "\" as an escape
    /// character.</p>
    pub policy: std::option::Option<std::string::String>,
    /// <p>The state of the vault lock. <code>InProgress</code> or
    /// <code>Locked</code>.</p>
    pub state: std::option::Option<std::string::String>,
    /// <p>The UTC date and time at which the lock ID expires. This value can be
    /// <code>null</code> if the vault lock is in a <code>Locked</code> state.</p>
    pub expiration_date: std::option::Option<std::string::String>,
    /// <p>The UTC date and time at which the vault lock was put into the
    /// <code>InProgress</code> state.</p>
    pub creation_date: std::option::Option<std::string::String>,
}
impl GetVaultLockOutput {
    /// <p>The vault lock policy as a JSON string, which uses "\" as an escape
    /// character.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
    /// <p>The state of the vault lock. <code>InProgress</code> or
    /// <code>Locked</code>.</p>
    pub fn state(&self) -> std::option::Option<&str> {
        self.state.as_deref()
    }
    /// <p>The UTC date and time at which the lock ID expires. This value can be
    /// <code>null</code> if the vault lock is in a <code>Locked</code> state.</p>
    pub fn expiration_date(&self) -> std::option::Option<&str> {
        self.expiration_date.as_deref()
    }
    /// <p>The UTC date and time at which the vault lock was put into the
    /// <code>InProgress</code> state.</p>
    pub fn creation_date(&self) -> std::option::Option<&str> {
        self.creation_date.as_deref()
    }
}
impl std::fmt::Debug for GetVaultLockOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetVaultLockOutput");
        formatter.field("policy", &self.policy);
        formatter.field("state", &self.state);
        formatter.field("expiration_date", &self.expiration_date);
        formatter.field("creation_date", &self.creation_date);
        formatter.finish()
    }
}
/// See [`GetVaultLockOutput`](crate::output::GetVaultLockOutput)
pub mod get_vault_lock_output {
    /// A builder for [`GetVaultLockOutput`](crate::output::GetVaultLockOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<std::string::String>,
        pub(crate) expiration_date: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The vault lock policy as a JSON string, which uses "\" as an escape
        /// character.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The vault lock policy as a JSON string, which uses "\" as an escape
        /// character.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// <p>The state of the vault lock. <code>InProgress</code> or
        /// <code>Locked</code>.</p>
        pub fn state(mut self, input: impl Into<std::string::String>) -> Self {
            self.state = Some(input.into());
            self
        }
        /// <p>The state of the vault lock. <code>InProgress</code> or
        /// <code>Locked</code>.</p>
        pub fn set_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state = input;
            self
        }
        /// <p>The UTC date and time at which the lock ID expires. This value can be
        /// <code>null</code> if the vault lock is in a <code>Locked</code> state.</p>
        pub fn expiration_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.expiration_date = Some(input.into());
            self
        }
        /// <p>The UTC date and time at which the lock ID expires. This value can be
        /// <code>null</code> if the vault lock is in a <code>Locked</code> state.</p>
        pub fn set_expiration_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expiration_date = input;
            self
        }
        /// <p>The UTC date and time at which the vault lock was put into the
        /// <code>InProgress</code> state.</p>
        pub fn creation_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_date = Some(input.into());
            self
        }
        /// <p>The UTC date and time at which the vault lock was put into the
        /// <code>InProgress</code> state.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// Consumes the builder and constructs a [`GetVaultLockOutput`](crate::output::GetVaultLockOutput)
        pub fn build(self) -> crate::output::GetVaultLockOutput {
            crate::output::GetVaultLockOutput {
                policy: self.policy,
                state: self.state,
                expiration_date: self.expiration_date,
                creation_date: self.creation_date,
            }
        }
    }
}
impl GetVaultLockOutput {
    /// Creates a new builder-style object to manufacture [`GetVaultLockOutput`](crate::output::GetVaultLockOutput)
    pub fn builder() -> crate::output::get_vault_lock_output::Builder {
        crate::output::get_vault_lock_output::Builder::default()
    }
}

/// <p>Output for GetVaultAccessPolicy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetVaultAccessPolicyOutput {
    /// <p>Contains the returned vault access policy as a JSON string.</p>
    pub policy: std::option::Option<crate::model::VaultAccessPolicy>,
}
impl GetVaultAccessPolicyOutput {
    /// <p>Contains the returned vault access policy as a JSON string.</p>
    pub fn policy(&self) -> std::option::Option<&crate::model::VaultAccessPolicy> {
        self.policy.as_ref()
    }
}
impl std::fmt::Debug for GetVaultAccessPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetVaultAccessPolicyOutput");
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`GetVaultAccessPolicyOutput`](crate::output::GetVaultAccessPolicyOutput)
pub mod get_vault_access_policy_output {
    /// A builder for [`GetVaultAccessPolicyOutput`](crate::output::GetVaultAccessPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<crate::model::VaultAccessPolicy>,
    }
    impl Builder {
        /// <p>Contains the returned vault access policy as a JSON string.</p>
        pub fn policy(mut self, input: crate::model::VaultAccessPolicy) -> Self {
            self.policy = Some(input);
            self
        }
        /// <p>Contains the returned vault access policy as a JSON string.</p>
        pub fn set_policy(
            mut self,
            input: std::option::Option<crate::model::VaultAccessPolicy>,
        ) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`GetVaultAccessPolicyOutput`](crate::output::GetVaultAccessPolicyOutput)
        pub fn build(self) -> crate::output::GetVaultAccessPolicyOutput {
            crate::output::GetVaultAccessPolicyOutput {
                policy: self.policy,
            }
        }
    }
}
impl GetVaultAccessPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetVaultAccessPolicyOutput`](crate::output::GetVaultAccessPolicyOutput)
    pub fn builder() -> crate::output::get_vault_access_policy_output::Builder {
        crate::output::get_vault_access_policy_output::Builder::default()
    }
}

/// <p>Contains the Amazon S3 Glacier response to your request.</p>
#[non_exhaustive]
pub struct GetJobOutputOutput {
    /// <p>The job data, either archive data or inventory data.</p>
    pub body: aws_smithy_http::byte_stream::ByteStream,
    /// <p>The checksum of the data in the response. This header is returned only when
    /// retrieving the output for an archive retrieval job. Furthermore, this header appears only
    /// under the following conditions:</p>
    /// <ul>
    /// <li>
    /// <p>You get the entire range of the archive.</p>
    /// </li>
    /// <li>
    /// <p>You request a range to return of the archive that starts and ends on a multiple
    /// of 1 MB. For example, if you have an 3.1 MB archive and you specify a range to return
    /// that starts at 1 MB and ends at 2 MB, then the x-amz-sha256-tree-hash is returned as
    /// a response header.</p>
    /// </li>
    /// <li>
    /// <p>You request a range of the archive to return that starts on a multiple of 1 MB
    /// and goes to the end of the archive. For example, if you have a 3.1 MB archive and you
    /// specify a range that starts at 2 MB and ends at 3.1 MB (the end of the archive), then
    /// the x-amz-sha256-tree-hash is returned as a response header.</p>
    /// </li>
    /// </ul>
    pub checksum: std::option::Option<std::string::String>,
    /// <p>The HTTP response code for a job output request. The value depends on whether a range
    /// was specified in the request.</p>
    pub status: i32,
    /// <p>The range of bytes returned by Amazon S3 Glacier. If only partial output is downloaded,
    /// the response provides the range of bytes Amazon S3 Glacier returned. For example, bytes
    /// 0-1048575/8388608 returns the first 1 MB from 8 MB.</p>
    pub content_range: std::option::Option<std::string::String>,
    /// <p>Indicates the range units accepted. For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html">RFC2616</a>. </p>
    pub accept_ranges: std::option::Option<std::string::String>,
    /// <p>The Content-Type depends on whether the job output is an archive or a vault
    /// inventory. For archive data, the Content-Type is application/octet-stream. For vault
    /// inventory, if you requested CSV format when you initiated the job, the Content-Type is
    /// text/csv. Otherwise, by default, vault inventory is returned as JSON, and the Content-Type
    /// is application/json.</p>
    pub content_type: std::option::Option<std::string::String>,
    /// <p>The description of an archive.</p>
    pub archive_description: std::option::Option<std::string::String>,
}
impl GetJobOutputOutput {
    /// <p>The job data, either archive data or inventory data.</p>
    pub fn body(&self) -> &aws_smithy_http::byte_stream::ByteStream {
        &self.body
    }
    /// <p>The checksum of the data in the response. This header is returned only when
    /// retrieving the output for an archive retrieval job. Furthermore, this header appears only
    /// under the following conditions:</p>
    /// <ul>
    /// <li>
    /// <p>You get the entire range of the archive.</p>
    /// </li>
    /// <li>
    /// <p>You request a range to return of the archive that starts and ends on a multiple
    /// of 1 MB. For example, if you have an 3.1 MB archive and you specify a range to return
    /// that starts at 1 MB and ends at 2 MB, then the x-amz-sha256-tree-hash is returned as
    /// a response header.</p>
    /// </li>
    /// <li>
    /// <p>You request a range of the archive to return that starts on a multiple of 1 MB
    /// and goes to the end of the archive. For example, if you have a 3.1 MB archive and you
    /// specify a range that starts at 2 MB and ends at 3.1 MB (the end of the archive), then
    /// the x-amz-sha256-tree-hash is returned as a response header.</p>
    /// </li>
    /// </ul>
    pub fn checksum(&self) -> std::option::Option<&str> {
        self.checksum.as_deref()
    }
    /// <p>The HTTP response code for a job output request. The value depends on whether a range
    /// was specified in the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The range of bytes returned by Amazon S3 Glacier. If only partial output is downloaded,
    /// the response provides the range of bytes Amazon S3 Glacier returned. For example, bytes
    /// 0-1048575/8388608 returns the first 1 MB from 8 MB.</p>
    pub fn content_range(&self) -> std::option::Option<&str> {
        self.content_range.as_deref()
    }
    /// <p>Indicates the range units accepted. For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html">RFC2616</a>. </p>
    pub fn accept_ranges(&self) -> std::option::Option<&str> {
        self.accept_ranges.as_deref()
    }
    /// <p>The Content-Type depends on whether the job output is an archive or a vault
    /// inventory. For archive data, the Content-Type is application/octet-stream. For vault
    /// inventory, if you requested CSV format when you initiated the job, the Content-Type is
    /// text/csv. Otherwise, by default, vault inventory is returned as JSON, and the Content-Type
    /// is application/json.</p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
    /// <p>The description of an archive.</p>
    pub fn archive_description(&self) -> std::option::Option<&str> {
        self.archive_description.as_deref()
    }
}
impl std::fmt::Debug for GetJobOutputOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetJobOutputOutput");
        formatter.field("body", &self.body);
        formatter.field("checksum", &self.checksum);
        formatter.field("status", &self.status);
        formatter.field("content_range", &self.content_range);
        formatter.field("accept_ranges", &self.accept_ranges);
        formatter.field("content_type", &self.content_type);
        formatter.field("archive_description", &self.archive_description);
        formatter.finish()
    }
}
/// See [`GetJobOutputOutput`](crate::output::GetJobOutputOutput)
pub mod get_job_output_output {
    /// A builder for [`GetJobOutputOutput`](crate::output::GetJobOutputOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) body: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        pub(crate) checksum: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) content_range: std::option::Option<std::string::String>,
        pub(crate) accept_ranges: std::option::Option<std::string::String>,
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) archive_description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The job data, either archive data or inventory data.</p>
        pub fn body(mut self, input: aws_smithy_http::byte_stream::ByteStream) -> Self {
            self.body = Some(input);
            self
        }
        /// <p>The job data, either archive data or inventory data.</p>
        pub fn set_body(
            mut self,
            input: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        ) -> Self {
            self.body = input;
            self
        }
        /// <p>The checksum of the data in the response. This header is returned only when
        /// retrieving the output for an archive retrieval job. Furthermore, this header appears only
        /// under the following conditions:</p>
        /// <ul>
        /// <li>
        /// <p>You get the entire range of the archive.</p>
        /// </li>
        /// <li>
        /// <p>You request a range to return of the archive that starts and ends on a multiple
        /// of 1 MB. For example, if you have an 3.1 MB archive and you specify a range to return
        /// that starts at 1 MB and ends at 2 MB, then the x-amz-sha256-tree-hash is returned as
        /// a response header.</p>
        /// </li>
        /// <li>
        /// <p>You request a range of the archive to return that starts on a multiple of 1 MB
        /// and goes to the end of the archive. For example, if you have a 3.1 MB archive and you
        /// specify a range that starts at 2 MB and ends at 3.1 MB (the end of the archive), then
        /// the x-amz-sha256-tree-hash is returned as a response header.</p>
        /// </li>
        /// </ul>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.checksum = Some(input.into());
            self
        }
        /// <p>The checksum of the data in the response. This header is returned only when
        /// retrieving the output for an archive retrieval job. Furthermore, this header appears only
        /// under the following conditions:</p>
        /// <ul>
        /// <li>
        /// <p>You get the entire range of the archive.</p>
        /// </li>
        /// <li>
        /// <p>You request a range to return of the archive that starts and ends on a multiple
        /// of 1 MB. For example, if you have an 3.1 MB archive and you specify a range to return
        /// that starts at 1 MB and ends at 2 MB, then the x-amz-sha256-tree-hash is returned as
        /// a response header.</p>
        /// </li>
        /// <li>
        /// <p>You request a range of the archive to return that starts on a multiple of 1 MB
        /// and goes to the end of the archive. For example, if you have a 3.1 MB archive and you
        /// specify a range that starts at 2 MB and ends at 3.1 MB (the end of the archive), then
        /// the x-amz-sha256-tree-hash is returned as a response header.</p>
        /// </li>
        /// </ul>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.checksum = input;
            self
        }
        /// <p>The HTTP response code for a job output request. The value depends on whether a range
        /// was specified in the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP response code for a job output request. The value depends on whether a range
        /// was specified in the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The range of bytes returned by Amazon S3 Glacier. If only partial output is downloaded,
        /// the response provides the range of bytes Amazon S3 Glacier returned. For example, bytes
        /// 0-1048575/8388608 returns the first 1 MB from 8 MB.</p>
        pub fn content_range(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_range = Some(input.into());
            self
        }
        /// <p>The range of bytes returned by Amazon S3 Glacier. If only partial output is downloaded,
        /// the response provides the range of bytes Amazon S3 Glacier returned. For example, bytes
        /// 0-1048575/8388608 returns the first 1 MB from 8 MB.</p>
        pub fn set_content_range(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_range = input;
            self
        }
        /// <p>Indicates the range units accepted. For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html">RFC2616</a>. </p>
        pub fn accept_ranges(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_ranges = Some(input.into());
            self
        }
        /// <p>Indicates the range units accepted. For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html">RFC2616</a>. </p>
        pub fn set_accept_ranges(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_ranges = input;
            self
        }
        /// <p>The Content-Type depends on whether the job output is an archive or a vault
        /// inventory. For archive data, the Content-Type is application/octet-stream. For vault
        /// inventory, if you requested CSV format when you initiated the job, the Content-Type is
        /// text/csv. Otherwise, by default, vault inventory is returned as JSON, and the Content-Type
        /// is application/json.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The Content-Type depends on whether the job output is an archive or a vault
        /// inventory. For archive data, the Content-Type is application/octet-stream. For vault
        /// inventory, if you requested CSV format when you initiated the job, the Content-Type is
        /// text/csv. Otherwise, by default, vault inventory is returned as JSON, and the Content-Type
        /// is application/json.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p>The description of an archive.</p>
        pub fn archive_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.archive_description = Some(input.into());
            self
        }
        /// <p>The description of an archive.</p>
        pub fn set_archive_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.archive_description = input;
            self
        }
        /// Consumes the builder and constructs a [`GetJobOutputOutput`](crate::output::GetJobOutputOutput)
        pub fn build(self) -> crate::output::GetJobOutputOutput {
            crate::output::GetJobOutputOutput {
                body: self.body.unwrap_or_default(),
                checksum: self.checksum,
                status: self.status.unwrap_or_default(),
                content_range: self.content_range,
                accept_ranges: self.accept_ranges,
                content_type: self.content_type,
                archive_description: self.archive_description,
            }
        }
    }
}
impl GetJobOutputOutput {
    /// Creates a new builder-style object to manufacture [`GetJobOutputOutput`](crate::output::GetJobOutputOutput)
    pub fn builder() -> crate::output::get_job_output_output::Builder {
        crate::output::get_job_output_output::Builder::default()
    }
}

/// <p>Contains the Amazon S3 Glacier response to the <code>GetDataRetrievalPolicy</code>
/// request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDataRetrievalPolicyOutput {
    /// <p>Contains the returned data retrieval policy in JSON format.</p>
    pub policy: std::option::Option<crate::model::DataRetrievalPolicy>,
}
impl GetDataRetrievalPolicyOutput {
    /// <p>Contains the returned data retrieval policy in JSON format.</p>
    pub fn policy(&self) -> std::option::Option<&crate::model::DataRetrievalPolicy> {
        self.policy.as_ref()
    }
}
impl std::fmt::Debug for GetDataRetrievalPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDataRetrievalPolicyOutput");
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`GetDataRetrievalPolicyOutput`](crate::output::GetDataRetrievalPolicyOutput)
pub mod get_data_retrieval_policy_output {
    /// A builder for [`GetDataRetrievalPolicyOutput`](crate::output::GetDataRetrievalPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<crate::model::DataRetrievalPolicy>,
    }
    impl Builder {
        /// <p>Contains the returned data retrieval policy in JSON format.</p>
        pub fn policy(mut self, input: crate::model::DataRetrievalPolicy) -> Self {
            self.policy = Some(input);
            self
        }
        /// <p>Contains the returned data retrieval policy in JSON format.</p>
        pub fn set_policy(
            mut self,
            input: std::option::Option<crate::model::DataRetrievalPolicy>,
        ) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDataRetrievalPolicyOutput`](crate::output::GetDataRetrievalPolicyOutput)
        pub fn build(self) -> crate::output::GetDataRetrievalPolicyOutput {
            crate::output::GetDataRetrievalPolicyOutput {
                policy: self.policy,
            }
        }
    }
}
impl GetDataRetrievalPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetDataRetrievalPolicyOutput`](crate::output::GetDataRetrievalPolicyOutput)
    pub fn builder() -> crate::output::get_data_retrieval_policy_output::Builder {
        crate::output::get_data_retrieval_policy_output::Builder::default()
    }
}

/// <p>Contains the Amazon S3 Glacier response to your request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeVaultOutput {
    /// <p>The Amazon Resource Name (ARN) of the vault.</p>
    pub vault_arn: std::option::Option<std::string::String>,
    /// <p>The name of the vault.</p>
    pub vault_name: std::option::Option<std::string::String>,
    /// <p>The Universal Coordinated Time (UTC) date when the vault was created. This value
    /// should be a string in the ISO 8601 date format, for example
    /// <code>2012-03-20T17:03:43.221Z</code>.</p>
    pub creation_date: std::option::Option<std::string::String>,
    /// <p>The Universal Coordinated Time (UTC) date when Amazon S3 Glacier completed the last
    /// vault inventory.  This value should be a string in the ISO 8601 date format, for example
    /// <code>2012-03-20T17:03:43.221Z</code>.</p>
    pub last_inventory_date: std::option::Option<std::string::String>,
    /// <p>The number of archives in the vault as of the last inventory date. This field will
    /// return <code>null</code> if an inventory has not yet run on the vault, for example if you
    /// just created the vault.</p>
    pub number_of_archives: i64,
    /// <p>Total size, in bytes, of the archives in the vault as of the last inventory date.
    /// This field will return null if an inventory has not yet run on the vault, for example if
    /// you just created the vault.</p>
    pub size_in_bytes: i64,
}
impl DescribeVaultOutput {
    /// <p>The Amazon Resource Name (ARN) of the vault.</p>
    pub fn vault_arn(&self) -> std::option::Option<&str> {
        self.vault_arn.as_deref()
    }
    /// <p>The name of the vault.</p>
    pub fn vault_name(&self) -> std::option::Option<&str> {
        self.vault_name.as_deref()
    }
    /// <p>The Universal Coordinated Time (UTC) date when the vault was created. This value
    /// should be a string in the ISO 8601 date format, for example
    /// <code>2012-03-20T17:03:43.221Z</code>.</p>
    pub fn creation_date(&self) -> std::option::Option<&str> {
        self.creation_date.as_deref()
    }
    /// <p>The Universal Coordinated Time (UTC) date when Amazon S3 Glacier completed the last
    /// vault inventory.  This value should be a string in the ISO 8601 date format, for example
    /// <code>2012-03-20T17:03:43.221Z</code>.</p>
    pub fn last_inventory_date(&self) -> std::option::Option<&str> {
        self.last_inventory_date.as_deref()
    }
    /// <p>The number of archives in the vault as of the last inventory date. This field will
    /// return <code>null</code> if an inventory has not yet run on the vault, for example if you
    /// just created the vault.</p>
    pub fn number_of_archives(&self) -> i64 {
        self.number_of_archives
    }
    /// <p>Total size, in bytes, of the archives in the vault as of the last inventory date.
    /// This field will return null if an inventory has not yet run on the vault, for example if
    /// you just created the vault.</p>
    pub fn size_in_bytes(&self) -> i64 {
        self.size_in_bytes
    }
}
impl std::fmt::Debug for DescribeVaultOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeVaultOutput");
        formatter.field("vault_arn", &self.vault_arn);
        formatter.field("vault_name", &self.vault_name);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_inventory_date", &self.last_inventory_date);
        formatter.field("number_of_archives", &self.number_of_archives);
        formatter.field("size_in_bytes", &self.size_in_bytes);
        formatter.finish()
    }
}
/// See [`DescribeVaultOutput`](crate::output::DescribeVaultOutput)
pub mod describe_vault_output {
    /// A builder for [`DescribeVaultOutput`](crate::output::DescribeVaultOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vault_arn: std::option::Option<std::string::String>,
        pub(crate) vault_name: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<std::string::String>,
        pub(crate) last_inventory_date: std::option::Option<std::string::String>,
        pub(crate) number_of_archives: std::option::Option<i64>,
        pub(crate) size_in_bytes: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the vault.</p>
        pub fn vault_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the vault.</p>
        pub fn set_vault_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_arn = input;
            self
        }
        /// <p>The name of the vault.</p>
        pub fn vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_name = Some(input.into());
            self
        }
        /// <p>The name of the vault.</p>
        pub fn set_vault_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_name = input;
            self
        }
        /// <p>The Universal Coordinated Time (UTC) date when the vault was created. This value
        /// should be a string in the ISO 8601 date format, for example
        /// <code>2012-03-20T17:03:43.221Z</code>.</p>
        pub fn creation_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_date = Some(input.into());
            self
        }
        /// <p>The Universal Coordinated Time (UTC) date when the vault was created. This value
        /// should be a string in the ISO 8601 date format, for example
        /// <code>2012-03-20T17:03:43.221Z</code>.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The Universal Coordinated Time (UTC) date when Amazon S3 Glacier completed the last
        /// vault inventory.  This value should be a string in the ISO 8601 date format, for example
        /// <code>2012-03-20T17:03:43.221Z</code>.</p>
        pub fn last_inventory_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_inventory_date = Some(input.into());
            self
        }
        /// <p>The Universal Coordinated Time (UTC) date when Amazon S3 Glacier completed the last
        /// vault inventory.  This value should be a string in the ISO 8601 date format, for example
        /// <code>2012-03-20T17:03:43.221Z</code>.</p>
        pub fn set_last_inventory_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_inventory_date = input;
            self
        }
        /// <p>The number of archives in the vault as of the last inventory date. This field will
        /// return <code>null</code> if an inventory has not yet run on the vault, for example if you
        /// just created the vault.</p>
        pub fn number_of_archives(mut self, input: i64) -> Self {
            self.number_of_archives = Some(input);
            self
        }
        /// <p>The number of archives in the vault as of the last inventory date. This field will
        /// return <code>null</code> if an inventory has not yet run on the vault, for example if you
        /// just created the vault.</p>
        pub fn set_number_of_archives(mut self, input: std::option::Option<i64>) -> Self {
            self.number_of_archives = input;
            self
        }
        /// <p>Total size, in bytes, of the archives in the vault as of the last inventory date.
        /// This field will return null if an inventory has not yet run on the vault, for example if
        /// you just created the vault.</p>
        pub fn size_in_bytes(mut self, input: i64) -> Self {
            self.size_in_bytes = Some(input);
            self
        }
        /// <p>Total size, in bytes, of the archives in the vault as of the last inventory date.
        /// This field will return null if an inventory has not yet run on the vault, for example if
        /// you just created the vault.</p>
        pub fn set_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.size_in_bytes = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeVaultOutput`](crate::output::DescribeVaultOutput)
        pub fn build(self) -> crate::output::DescribeVaultOutput {
            crate::output::DescribeVaultOutput {
                vault_arn: self.vault_arn,
                vault_name: self.vault_name,
                creation_date: self.creation_date,
                last_inventory_date: self.last_inventory_date,
                number_of_archives: self.number_of_archives.unwrap_or_default(),
                size_in_bytes: self.size_in_bytes.unwrap_or_default(),
            }
        }
    }
}
impl DescribeVaultOutput {
    /// Creates a new builder-style object to manufacture [`DescribeVaultOutput`](crate::output::DescribeVaultOutput)
    pub fn builder() -> crate::output::describe_vault_output::Builder {
        crate::output::describe_vault_output::Builder::default()
    }
}

/// <p>Contains the description of an Amazon S3 Glacier job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeJobOutput {
    /// <p>An opaque string that identifies an Amazon S3 Glacier job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The job description provided when initiating the job.</p>
    pub job_description: std::option::Option<std::string::String>,
    /// <p>The job type. This value is either <code>ArchiveRetrieval</code>,
    /// <code>InventoryRetrieval</code>, or
    /// <code>Select</code>. </p>
    pub action: std::option::Option<crate::model::ActionCode>,
    /// <p>The archive ID requested for a select job or archive retrieval. Otherwise, this
    /// field is null.</p>
    pub archive_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the vault from which an archive retrieval was
    /// requested.</p>
    pub vault_arn: std::option::Option<std::string::String>,
    /// <p>The UTC date when the job was created. This value is a string representation of ISO
    /// 8601 date format, for example <code>"2012-03-20T17:03:43.221Z"</code>.</p>
    pub creation_date: std::option::Option<std::string::String>,
    /// <p>The job status. When a job is completed, you get the job's output using Get Job
    /// Output (GET output).</p>
    pub completed: bool,
    /// <p>The status code can be <code>InProgress</code>, <code>Succeeded</code>, or
    /// <code>Failed</code>, and indicates the status of the job.</p>
    pub status_code: std::option::Option<crate::model::StatusCode>,
    /// <p>A friendly message that describes the job status.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>For an archive retrieval job, this value is the size in bytes of the archive being
    /// requested for download. For an inventory retrieval or select job, this value is
    /// null.</p>
    pub archive_size_in_bytes: std::option::Option<i64>,
    /// <p>For an inventory retrieval job, this value is the size in bytes of the inventory
    /// requested for download. For an archive retrieval or select job, this value is
    /// null.</p>
    pub inventory_size_in_bytes: std::option::Option<i64>,
    /// <p>An Amazon SNS topic that receives notification.</p>
    pub sns_topic: std::option::Option<std::string::String>,
    /// <p>The UTC time that the job request completed. While the job is in progress, the
    /// value is null.</p>
    pub completion_date: std::option::Option<std::string::String>,
    /// <p>For an archive retrieval job, this value is the checksum of the archive. Otherwise,
    /// this value is null.</p>
    /// <p>The SHA256 tree hash value for the requested range of an archive. If the <b>InitiateJob</b> request for an archive specified a tree-hash
    /// aligned range, then this field returns a value.</p>
    /// <p>If the whole archive is retrieved, this value is the same as the
    /// ArchiveSHA256TreeHash value.</p>
    /// <p>This field is null for the following:</p>
    /// <ul>
    /// <li>
    /// <p>Archive retrieval jobs that specify a range that is not tree-hash
    /// aligned</p>
    /// </li>
    /// </ul>
    /// <ul>
    /// <li>
    /// <p>Archival jobs that specify a range that is equal to the whole archive, when
    /// the job status is <code>InProgress</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <ul>
    /// <li>
    /// <p>Inventory jobs</p>
    /// </li>
    /// <li>
    /// <p>Select jobs</p>
    /// </li>
    /// </ul>
    pub sha256_tree_hash: std::option::Option<std::string::String>,
    /// <p>The SHA256 tree hash of the entire archive for an archive retrieval. For inventory
    /// retrieval or select jobs, this field is null.</p>
    pub archive_sha256_tree_hash: std::option::Option<std::string::String>,
    /// <p>The retrieved byte range for archive retrieval jobs in the form
    /// <i>StartByteValue</i>-<i>EndByteValue</i>. If no range
    /// was specified in the archive retrieval, then the whole archive is retrieved. In this
    /// case, <i>StartByteValue</i> equals 0 and <i>EndByteValue</i>
    /// equals the size of the archive minus 1. For inventory retrieval or select jobs, this
    /// field is null. </p>
    pub retrieval_byte_range: std::option::Option<std::string::String>,
    /// <p>The tier to use for a select or an archive retrieval. Valid values are
    /// <code>Expedited</code>, <code>Standard</code>, or <code>Bulk</code>.
    /// <code>Standard</code> is the default.</p>
    pub tier: std::option::Option<std::string::String>,
    /// <p>Parameters used for range inventory retrieval.</p>
    pub inventory_retrieval_parameters:
        std::option::Option<crate::model::InventoryRetrievalJobDescription>,
    /// <p>Contains the job output location.</p>
    pub job_output_path: std::option::Option<std::string::String>,
    /// <p>Contains the parameters used for a select.</p>
    pub select_parameters: std::option::Option<crate::model::SelectParameters>,
    /// <p>Contains the location where the data from the select job is stored.</p>
    pub output_location: std::option::Option<crate::model::OutputLocation>,
}
impl DescribeJobOutput {
    /// <p>An opaque string that identifies an Amazon S3 Glacier job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The job description provided when initiating the job.</p>
    pub fn job_description(&self) -> std::option::Option<&str> {
        self.job_description.as_deref()
    }
    /// <p>The job type. This value is either <code>ArchiveRetrieval</code>,
    /// <code>InventoryRetrieval</code>, or
    /// <code>Select</code>. </p>
    pub fn action(&self) -> std::option::Option<&crate::model::ActionCode> {
        self.action.as_ref()
    }
    /// <p>The archive ID requested for a select job or archive retrieval. Otherwise, this
    /// field is null.</p>
    pub fn archive_id(&self) -> std::option::Option<&str> {
        self.archive_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the vault from which an archive retrieval was
    /// requested.</p>
    pub fn vault_arn(&self) -> std::option::Option<&str> {
        self.vault_arn.as_deref()
    }
    /// <p>The UTC date when the job was created. This value is a string representation of ISO
    /// 8601 date format, for example <code>"2012-03-20T17:03:43.221Z"</code>.</p>
    pub fn creation_date(&self) -> std::option::Option<&str> {
        self.creation_date.as_deref()
    }
    /// <p>The job status. When a job is completed, you get the job's output using Get Job
    /// Output (GET output).</p>
    pub fn completed(&self) -> bool {
        self.completed
    }
    /// <p>The status code can be <code>InProgress</code>, <code>Succeeded</code>, or
    /// <code>Failed</code>, and indicates the status of the job.</p>
    pub fn status_code(&self) -> std::option::Option<&crate::model::StatusCode> {
        self.status_code.as_ref()
    }
    /// <p>A friendly message that describes the job status.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>For an archive retrieval job, this value is the size in bytes of the archive being
    /// requested for download. For an inventory retrieval or select job, this value is
    /// null.</p>
    pub fn archive_size_in_bytes(&self) -> std::option::Option<i64> {
        self.archive_size_in_bytes
    }
    /// <p>For an inventory retrieval job, this value is the size in bytes of the inventory
    /// requested for download. For an archive retrieval or select job, this value is
    /// null.</p>
    pub fn inventory_size_in_bytes(&self) -> std::option::Option<i64> {
        self.inventory_size_in_bytes
    }
    /// <p>An Amazon SNS topic that receives notification.</p>
    pub fn sns_topic(&self) -> std::option::Option<&str> {
        self.sns_topic.as_deref()
    }
    /// <p>The UTC time that the job request completed. While the job is in progress, the
    /// value is null.</p>
    pub fn completion_date(&self) -> std::option::Option<&str> {
        self.completion_date.as_deref()
    }
    /// <p>For an archive retrieval job, this value is the checksum of the archive. Otherwise,
    /// this value is null.</p>
    /// <p>The SHA256 tree hash value for the requested range of an archive. If the <b>InitiateJob</b> request for an archive specified a tree-hash
    /// aligned range, then this field returns a value.</p>
    /// <p>If the whole archive is retrieved, this value is the same as the
    /// ArchiveSHA256TreeHash value.</p>
    /// <p>This field is null for the following:</p>
    /// <ul>
    /// <li>
    /// <p>Archive retrieval jobs that specify a range that is not tree-hash
    /// aligned</p>
    /// </li>
    /// </ul>
    /// <ul>
    /// <li>
    /// <p>Archival jobs that specify a range that is equal to the whole archive, when
    /// the job status is <code>InProgress</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <ul>
    /// <li>
    /// <p>Inventory jobs</p>
    /// </li>
    /// <li>
    /// <p>Select jobs</p>
    /// </li>
    /// </ul>
    pub fn sha256_tree_hash(&self) -> std::option::Option<&str> {
        self.sha256_tree_hash.as_deref()
    }
    /// <p>The SHA256 tree hash of the entire archive for an archive retrieval. For inventory
    /// retrieval or select jobs, this field is null.</p>
    pub fn archive_sha256_tree_hash(&self) -> std::option::Option<&str> {
        self.archive_sha256_tree_hash.as_deref()
    }
    /// <p>The retrieved byte range for archive retrieval jobs in the form
    /// <i>StartByteValue</i>-<i>EndByteValue</i>. If no range
    /// was specified in the archive retrieval, then the whole archive is retrieved. In this
    /// case, <i>StartByteValue</i> equals 0 and <i>EndByteValue</i>
    /// equals the size of the archive minus 1. For inventory retrieval or select jobs, this
    /// field is null. </p>
    pub fn retrieval_byte_range(&self) -> std::option::Option<&str> {
        self.retrieval_byte_range.as_deref()
    }
    /// <p>The tier to use for a select or an archive retrieval. Valid values are
    /// <code>Expedited</code>, <code>Standard</code>, or <code>Bulk</code>.
    /// <code>Standard</code> is the default.</p>
    pub fn tier(&self) -> std::option::Option<&str> {
        self.tier.as_deref()
    }
    /// <p>Parameters used for range inventory retrieval.</p>
    pub fn inventory_retrieval_parameters(
        &self,
    ) -> std::option::Option<&crate::model::InventoryRetrievalJobDescription> {
        self.inventory_retrieval_parameters.as_ref()
    }
    /// <p>Contains the job output location.</p>
    pub fn job_output_path(&self) -> std::option::Option<&str> {
        self.job_output_path.as_deref()
    }
    /// <p>Contains the parameters used for a select.</p>
    pub fn select_parameters(&self) -> std::option::Option<&crate::model::SelectParameters> {
        self.select_parameters.as_ref()
    }
    /// <p>Contains the location where the data from the select job is stored.</p>
    pub fn output_location(&self) -> std::option::Option<&crate::model::OutputLocation> {
        self.output_location.as_ref()
    }
}
impl std::fmt::Debug for DescribeJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeJobOutput");
        formatter.field("job_id", &self.job_id);
        formatter.field("job_description", &self.job_description);
        formatter.field("action", &self.action);
        formatter.field("archive_id", &self.archive_id);
        formatter.field("vault_arn", &self.vault_arn);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("completed", &self.completed);
        formatter.field("status_code", &self.status_code);
        formatter.field("status_message", &self.status_message);
        formatter.field("archive_size_in_bytes", &self.archive_size_in_bytes);
        formatter.field("inventory_size_in_bytes", &self.inventory_size_in_bytes);
        formatter.field("sns_topic", &self.sns_topic);
        formatter.field("completion_date", &self.completion_date);
        formatter.field("sha256_tree_hash", &self.sha256_tree_hash);
        formatter.field("archive_sha256_tree_hash", &self.archive_sha256_tree_hash);
        formatter.field("retrieval_byte_range", &self.retrieval_byte_range);
        formatter.field("tier", &self.tier);
        formatter.field(
            "inventory_retrieval_parameters",
            &self.inventory_retrieval_parameters,
        );
        formatter.field("job_output_path", &self.job_output_path);
        formatter.field("select_parameters", &self.select_parameters);
        formatter.field("output_location", &self.output_location);
        formatter.finish()
    }
}
/// See [`DescribeJobOutput`](crate::output::DescribeJobOutput)
pub mod describe_job_output {
    /// A builder for [`DescribeJobOutput`](crate::output::DescribeJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) job_description: std::option::Option<std::string::String>,
        pub(crate) action: std::option::Option<crate::model::ActionCode>,
        pub(crate) archive_id: std::option::Option<std::string::String>,
        pub(crate) vault_arn: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<std::string::String>,
        pub(crate) completed: std::option::Option<bool>,
        pub(crate) status_code: std::option::Option<crate::model::StatusCode>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) archive_size_in_bytes: std::option::Option<i64>,
        pub(crate) inventory_size_in_bytes: std::option::Option<i64>,
        pub(crate) sns_topic: std::option::Option<std::string::String>,
        pub(crate) completion_date: std::option::Option<std::string::String>,
        pub(crate) sha256_tree_hash: std::option::Option<std::string::String>,
        pub(crate) archive_sha256_tree_hash: std::option::Option<std::string::String>,
        pub(crate) retrieval_byte_range: std::option::Option<std::string::String>,
        pub(crate) tier: std::option::Option<std::string::String>,
        pub(crate) inventory_retrieval_parameters:
            std::option::Option<crate::model::InventoryRetrievalJobDescription>,
        pub(crate) job_output_path: std::option::Option<std::string::String>,
        pub(crate) select_parameters: std::option::Option<crate::model::SelectParameters>,
        pub(crate) output_location: std::option::Option<crate::model::OutputLocation>,
    }
    impl Builder {
        /// <p>An opaque string that identifies an Amazon S3 Glacier job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>An opaque string that identifies an Amazon S3 Glacier job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The job description provided when initiating the job.</p>
        pub fn job_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_description = Some(input.into());
            self
        }
        /// <p>The job description provided when initiating the job.</p>
        pub fn set_job_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_description = input;
            self
        }
        /// <p>The job type. This value is either <code>ArchiveRetrieval</code>,
        /// <code>InventoryRetrieval</code>, or
        /// <code>Select</code>. </p>
        pub fn action(mut self, input: crate::model::ActionCode) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The job type. This value is either <code>ArchiveRetrieval</code>,
        /// <code>InventoryRetrieval</code>, or
        /// <code>Select</code>. </p>
        pub fn set_action(mut self, input: std::option::Option<crate::model::ActionCode>) -> Self {
            self.action = input;
            self
        }
        /// <p>The archive ID requested for a select job or archive retrieval. Otherwise, this
        /// field is null.</p>
        pub fn archive_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.archive_id = Some(input.into());
            self
        }
        /// <p>The archive ID requested for a select job or archive retrieval. Otherwise, this
        /// field is null.</p>
        pub fn set_archive_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.archive_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the vault from which an archive retrieval was
        /// requested.</p>
        pub fn vault_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the vault from which an archive retrieval was
        /// requested.</p>
        pub fn set_vault_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_arn = input;
            self
        }
        /// <p>The UTC date when the job was created. This value is a string representation of ISO
        /// 8601 date format, for example <code>"2012-03-20T17:03:43.221Z"</code>.</p>
        pub fn creation_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_date = Some(input.into());
            self
        }
        /// <p>The UTC date when the job was created. This value is a string representation of ISO
        /// 8601 date format, for example <code>"2012-03-20T17:03:43.221Z"</code>.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The job status. When a job is completed, you get the job's output using Get Job
        /// Output (GET output).</p>
        pub fn completed(mut self, input: bool) -> Self {
            self.completed = Some(input);
            self
        }
        /// <p>The job status. When a job is completed, you get the job's output using Get Job
        /// Output (GET output).</p>
        pub fn set_completed(mut self, input: std::option::Option<bool>) -> Self {
            self.completed = input;
            self
        }
        /// <p>The status code can be <code>InProgress</code>, <code>Succeeded</code>, or
        /// <code>Failed</code>, and indicates the status of the job.</p>
        pub fn status_code(mut self, input: crate::model::StatusCode) -> Self {
            self.status_code = Some(input);
            self
        }
        /// <p>The status code can be <code>InProgress</code>, <code>Succeeded</code>, or
        /// <code>Failed</code>, and indicates the status of the job.</p>
        pub fn set_status_code(
            mut self,
            input: std::option::Option<crate::model::StatusCode>,
        ) -> Self {
            self.status_code = input;
            self
        }
        /// <p>A friendly message that describes the job status.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>A friendly message that describes the job status.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>For an archive retrieval job, this value is the size in bytes of the archive being
        /// requested for download. For an inventory retrieval or select job, this value is
        /// null.</p>
        pub fn archive_size_in_bytes(mut self, input: i64) -> Self {
            self.archive_size_in_bytes = Some(input);
            self
        }
        /// <p>For an archive retrieval job, this value is the size in bytes of the archive being
        /// requested for download. For an inventory retrieval or select job, this value is
        /// null.</p>
        pub fn set_archive_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.archive_size_in_bytes = input;
            self
        }
        /// <p>For an inventory retrieval job, this value is the size in bytes of the inventory
        /// requested for download. For an archive retrieval or select job, this value is
        /// null.</p>
        pub fn inventory_size_in_bytes(mut self, input: i64) -> Self {
            self.inventory_size_in_bytes = Some(input);
            self
        }
        /// <p>For an inventory retrieval job, this value is the size in bytes of the inventory
        /// requested for download. For an archive retrieval or select job, this value is
        /// null.</p>
        pub fn set_inventory_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.inventory_size_in_bytes = input;
            self
        }
        /// <p>An Amazon SNS topic that receives notification.</p>
        pub fn sns_topic(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic = Some(input.into());
            self
        }
        /// <p>An Amazon SNS topic that receives notification.</p>
        pub fn set_sns_topic(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sns_topic = input;
            self
        }
        /// <p>The UTC time that the job request completed. While the job is in progress, the
        /// value is null.</p>
        pub fn completion_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.completion_date = Some(input.into());
            self
        }
        /// <p>The UTC time that the job request completed. While the job is in progress, the
        /// value is null.</p>
        pub fn set_completion_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.completion_date = input;
            self
        }
        /// <p>For an archive retrieval job, this value is the checksum of the archive. Otherwise,
        /// this value is null.</p>
        /// <p>The SHA256 tree hash value for the requested range of an archive. If the <b>InitiateJob</b> request for an archive specified a tree-hash
        /// aligned range, then this field returns a value.</p>
        /// <p>If the whole archive is retrieved, this value is the same as the
        /// ArchiveSHA256TreeHash value.</p>
        /// <p>This field is null for the following:</p>
        /// <ul>
        /// <li>
        /// <p>Archive retrieval jobs that specify a range that is not tree-hash
        /// aligned</p>
        /// </li>
        /// </ul>
        /// <ul>
        /// <li>
        /// <p>Archival jobs that specify a range that is equal to the whole archive, when
        /// the job status is <code>InProgress</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <ul>
        /// <li>
        /// <p>Inventory jobs</p>
        /// </li>
        /// <li>
        /// <p>Select jobs</p>
        /// </li>
        /// </ul>
        pub fn sha256_tree_hash(mut self, input: impl Into<std::string::String>) -> Self {
            self.sha256_tree_hash = Some(input.into());
            self
        }
        /// <p>For an archive retrieval job, this value is the checksum of the archive. Otherwise,
        /// this value is null.</p>
        /// <p>The SHA256 tree hash value for the requested range of an archive. If the <b>InitiateJob</b> request for an archive specified a tree-hash
        /// aligned range, then this field returns a value.</p>
        /// <p>If the whole archive is retrieved, this value is the same as the
        /// ArchiveSHA256TreeHash value.</p>
        /// <p>This field is null for the following:</p>
        /// <ul>
        /// <li>
        /// <p>Archive retrieval jobs that specify a range that is not tree-hash
        /// aligned</p>
        /// </li>
        /// </ul>
        /// <ul>
        /// <li>
        /// <p>Archival jobs that specify a range that is equal to the whole archive, when
        /// the job status is <code>InProgress</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <ul>
        /// <li>
        /// <p>Inventory jobs</p>
        /// </li>
        /// <li>
        /// <p>Select jobs</p>
        /// </li>
        /// </ul>
        pub fn set_sha256_tree_hash(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sha256_tree_hash = input;
            self
        }
        /// <p>The SHA256 tree hash of the entire archive for an archive retrieval. For inventory
        /// retrieval or select jobs, this field is null.</p>
        pub fn archive_sha256_tree_hash(mut self, input: impl Into<std::string::String>) -> Self {
            self.archive_sha256_tree_hash = Some(input.into());
            self
        }
        /// <p>The SHA256 tree hash of the entire archive for an archive retrieval. For inventory
        /// retrieval or select jobs, this field is null.</p>
        pub fn set_archive_sha256_tree_hash(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.archive_sha256_tree_hash = input;
            self
        }
        /// <p>The retrieved byte range for archive retrieval jobs in the form
        /// <i>StartByteValue</i>-<i>EndByteValue</i>. If no range
        /// was specified in the archive retrieval, then the whole archive is retrieved. In this
        /// case, <i>StartByteValue</i> equals 0 and <i>EndByteValue</i>
        /// equals the size of the archive minus 1. For inventory retrieval or select jobs, this
        /// field is null. </p>
        pub fn retrieval_byte_range(mut self, input: impl Into<std::string::String>) -> Self {
            self.retrieval_byte_range = Some(input.into());
            self
        }
        /// <p>The retrieved byte range for archive retrieval jobs in the form
        /// <i>StartByteValue</i>-<i>EndByteValue</i>. If no range
        /// was specified in the archive retrieval, then the whole archive is retrieved. In this
        /// case, <i>StartByteValue</i> equals 0 and <i>EndByteValue</i>
        /// equals the size of the archive minus 1. For inventory retrieval or select jobs, this
        /// field is null. </p>
        pub fn set_retrieval_byte_range(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.retrieval_byte_range = input;
            self
        }
        /// <p>The tier to use for a select or an archive retrieval. Valid values are
        /// <code>Expedited</code>, <code>Standard</code>, or <code>Bulk</code>.
        /// <code>Standard</code> is the default.</p>
        pub fn tier(mut self, input: impl Into<std::string::String>) -> Self {
            self.tier = Some(input.into());
            self
        }
        /// <p>The tier to use for a select or an archive retrieval. Valid values are
        /// <code>Expedited</code>, <code>Standard</code>, or <code>Bulk</code>.
        /// <code>Standard</code> is the default.</p>
        pub fn set_tier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tier = input;
            self
        }
        /// <p>Parameters used for range inventory retrieval.</p>
        pub fn inventory_retrieval_parameters(
            mut self,
            input: crate::model::InventoryRetrievalJobDescription,
        ) -> Self {
            self.inventory_retrieval_parameters = Some(input);
            self
        }
        /// <p>Parameters used for range inventory retrieval.</p>
        pub fn set_inventory_retrieval_parameters(
            mut self,
            input: std::option::Option<crate::model::InventoryRetrievalJobDescription>,
        ) -> Self {
            self.inventory_retrieval_parameters = input;
            self
        }
        /// <p>Contains the job output location.</p>
        pub fn job_output_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_output_path = Some(input.into());
            self
        }
        /// <p>Contains the job output location.</p>
        pub fn set_job_output_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_output_path = input;
            self
        }
        /// <p>Contains the parameters used for a select.</p>
        pub fn select_parameters(mut self, input: crate::model::SelectParameters) -> Self {
            self.select_parameters = Some(input);
            self
        }
        /// <p>Contains the parameters used for a select.</p>
        pub fn set_select_parameters(
            mut self,
            input: std::option::Option<crate::model::SelectParameters>,
        ) -> Self {
            self.select_parameters = input;
            self
        }
        /// <p>Contains the location where the data from the select job is stored.</p>
        pub fn output_location(mut self, input: crate::model::OutputLocation) -> Self {
            self.output_location = Some(input);
            self
        }
        /// <p>Contains the location where the data from the select job is stored.</p>
        pub fn set_output_location(
            mut self,
            input: std::option::Option<crate::model::OutputLocation>,
        ) -> Self {
            self.output_location = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeJobOutput`](crate::output::DescribeJobOutput)
        pub fn build(self) -> crate::output::DescribeJobOutput {
            crate::output::DescribeJobOutput {
                job_id: self.job_id,
                job_description: self.job_description,
                action: self.action,
                archive_id: self.archive_id,
                vault_arn: self.vault_arn,
                creation_date: self.creation_date,
                completed: self.completed.unwrap_or_default(),
                status_code: self.status_code,
                status_message: self.status_message,
                archive_size_in_bytes: self.archive_size_in_bytes,
                inventory_size_in_bytes: self.inventory_size_in_bytes,
                sns_topic: self.sns_topic,
                completion_date: self.completion_date,
                sha256_tree_hash: self.sha256_tree_hash,
                archive_sha256_tree_hash: self.archive_sha256_tree_hash,
                retrieval_byte_range: self.retrieval_byte_range,
                tier: self.tier,
                inventory_retrieval_parameters: self.inventory_retrieval_parameters,
                job_output_path: self.job_output_path,
                select_parameters: self.select_parameters,
                output_location: self.output_location,
            }
        }
    }
}
impl DescribeJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeJobOutput`](crate::output::DescribeJobOutput)
    pub fn builder() -> crate::output::describe_job_output::Builder {
        crate::output::describe_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVaultNotificationsOutput {}
impl std::fmt::Debug for DeleteVaultNotificationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVaultNotificationsOutput");
        formatter.finish()
    }
}
/// See [`DeleteVaultNotificationsOutput`](crate::output::DeleteVaultNotificationsOutput)
pub mod delete_vault_notifications_output {
    /// A builder for [`DeleteVaultNotificationsOutput`](crate::output::DeleteVaultNotificationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteVaultNotificationsOutput`](crate::output::DeleteVaultNotificationsOutput)
        pub fn build(self) -> crate::output::DeleteVaultNotificationsOutput {
            crate::output::DeleteVaultNotificationsOutput {}
        }
    }
}
impl DeleteVaultNotificationsOutput {
    /// Creates a new builder-style object to manufacture [`DeleteVaultNotificationsOutput`](crate::output::DeleteVaultNotificationsOutput)
    pub fn builder() -> crate::output::delete_vault_notifications_output::Builder {
        crate::output::delete_vault_notifications_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVaultAccessPolicyOutput {}
impl std::fmt::Debug for DeleteVaultAccessPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVaultAccessPolicyOutput");
        formatter.finish()
    }
}
/// See [`DeleteVaultAccessPolicyOutput`](crate::output::DeleteVaultAccessPolicyOutput)
pub mod delete_vault_access_policy_output {
    /// A builder for [`DeleteVaultAccessPolicyOutput`](crate::output::DeleteVaultAccessPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteVaultAccessPolicyOutput`](crate::output::DeleteVaultAccessPolicyOutput)
        pub fn build(self) -> crate::output::DeleteVaultAccessPolicyOutput {
            crate::output::DeleteVaultAccessPolicyOutput {}
        }
    }
}
impl DeleteVaultAccessPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteVaultAccessPolicyOutput`](crate::output::DeleteVaultAccessPolicyOutput)
    pub fn builder() -> crate::output::delete_vault_access_policy_output::Builder {
        crate::output::delete_vault_access_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVaultOutput {}
impl std::fmt::Debug for DeleteVaultOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVaultOutput");
        formatter.finish()
    }
}
/// See [`DeleteVaultOutput`](crate::output::DeleteVaultOutput)
pub mod delete_vault_output {
    /// A builder for [`DeleteVaultOutput`](crate::output::DeleteVaultOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteVaultOutput`](crate::output::DeleteVaultOutput)
        pub fn build(self) -> crate::output::DeleteVaultOutput {
            crate::output::DeleteVaultOutput {}
        }
    }
}
impl DeleteVaultOutput {
    /// Creates a new builder-style object to manufacture [`DeleteVaultOutput`](crate::output::DeleteVaultOutput)
    pub fn builder() -> crate::output::delete_vault_output::Builder {
        crate::output::delete_vault_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteArchiveOutput {}
impl std::fmt::Debug for DeleteArchiveOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteArchiveOutput");
        formatter.finish()
    }
}
/// See [`DeleteArchiveOutput`](crate::output::DeleteArchiveOutput)
pub mod delete_archive_output {
    /// A builder for [`DeleteArchiveOutput`](crate::output::DeleteArchiveOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteArchiveOutput`](crate::output::DeleteArchiveOutput)
        pub fn build(self) -> crate::output::DeleteArchiveOutput {
            crate::output::DeleteArchiveOutput {}
        }
    }
}
impl DeleteArchiveOutput {
    /// Creates a new builder-style object to manufacture [`DeleteArchiveOutput`](crate::output::DeleteArchiveOutput)
    pub fn builder() -> crate::output::delete_archive_output::Builder {
        crate::output::delete_archive_output::Builder::default()
    }
}

/// <p>Contains the Amazon S3 Glacier response to your request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateVaultOutput {
    /// <p>The URI of the vault that was created.</p>
    pub location: std::option::Option<std::string::String>,
}
impl CreateVaultOutput {
    /// <p>The URI of the vault that was created.</p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
}
impl std::fmt::Debug for CreateVaultOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateVaultOutput");
        formatter.field("location", &self.location);
        formatter.finish()
    }
}
/// See [`CreateVaultOutput`](crate::output::CreateVaultOutput)
pub mod create_vault_output {
    /// A builder for [`CreateVaultOutput`](crate::output::CreateVaultOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The URI of the vault that was created.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The URI of the vault that was created.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateVaultOutput`](crate::output::CreateVaultOutput)
        pub fn build(self) -> crate::output::CreateVaultOutput {
            crate::output::CreateVaultOutput {
                location: self.location,
            }
        }
    }
}
impl CreateVaultOutput {
    /// Creates a new builder-style object to manufacture [`CreateVaultOutput`](crate::output::CreateVaultOutput)
    pub fn builder() -> crate::output::create_vault_output::Builder {
        crate::output::create_vault_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CompleteVaultLockOutput {}
impl std::fmt::Debug for CompleteVaultLockOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CompleteVaultLockOutput");
        formatter.finish()
    }
}
/// See [`CompleteVaultLockOutput`](crate::output::CompleteVaultLockOutput)
pub mod complete_vault_lock_output {
    /// A builder for [`CompleteVaultLockOutput`](crate::output::CompleteVaultLockOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CompleteVaultLockOutput`](crate::output::CompleteVaultLockOutput)
        pub fn build(self) -> crate::output::CompleteVaultLockOutput {
            crate::output::CompleteVaultLockOutput {}
        }
    }
}
impl CompleteVaultLockOutput {
    /// Creates a new builder-style object to manufacture [`CompleteVaultLockOutput`](crate::output::CompleteVaultLockOutput)
    pub fn builder() -> crate::output::complete_vault_lock_output::Builder {
        crate::output::complete_vault_lock_output::Builder::default()
    }
}

/// <p>Contains the Amazon S3 Glacier response to your request.</p>
/// <p>For information about the underlying REST API, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-post.html">Upload Archive</a>. For
/// conceptual information, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html">Working with Archives in
/// Amazon S3 Glacier</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CompleteMultipartUploadOutput {
    /// <p>The relative URI path of the newly added archive resource.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The checksum of the archive computed by Amazon S3 Glacier.</p>
    pub checksum: std::option::Option<std::string::String>,
    /// <p>The ID of the archive. This value is also included as part of the location.</p>
    pub archive_id: std::option::Option<std::string::String>,
}
impl CompleteMultipartUploadOutput {
    /// <p>The relative URI path of the newly added archive resource.</p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
    /// <p>The checksum of the archive computed by Amazon S3 Glacier.</p>
    pub fn checksum(&self) -> std::option::Option<&str> {
        self.checksum.as_deref()
    }
    /// <p>The ID of the archive. This value is also included as part of the location.</p>
    pub fn archive_id(&self) -> std::option::Option<&str> {
        self.archive_id.as_deref()
    }
}
impl std::fmt::Debug for CompleteMultipartUploadOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CompleteMultipartUploadOutput");
        formatter.field("location", &self.location);
        formatter.field("checksum", &self.checksum);
        formatter.field("archive_id", &self.archive_id);
        formatter.finish()
    }
}
/// See [`CompleteMultipartUploadOutput`](crate::output::CompleteMultipartUploadOutput)
pub mod complete_multipart_upload_output {
    /// A builder for [`CompleteMultipartUploadOutput`](crate::output::CompleteMultipartUploadOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) checksum: std::option::Option<std::string::String>,
        pub(crate) archive_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The relative URI path of the newly added archive resource.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The relative URI path of the newly added archive resource.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The checksum of the archive computed by Amazon S3 Glacier.</p>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.checksum = Some(input.into());
            self
        }
        /// <p>The checksum of the archive computed by Amazon S3 Glacier.</p>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.checksum = input;
            self
        }
        /// <p>The ID of the archive. This value is also included as part of the location.</p>
        pub fn archive_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.archive_id = Some(input.into());
            self
        }
        /// <p>The ID of the archive. This value is also included as part of the location.</p>
        pub fn set_archive_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.archive_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CompleteMultipartUploadOutput`](crate::output::CompleteMultipartUploadOutput)
        pub fn build(self) -> crate::output::CompleteMultipartUploadOutput {
            crate::output::CompleteMultipartUploadOutput {
                location: self.location,
                checksum: self.checksum,
                archive_id: self.archive_id,
            }
        }
    }
}
impl CompleteMultipartUploadOutput {
    /// Creates a new builder-style object to manufacture [`CompleteMultipartUploadOutput`](crate::output::CompleteMultipartUploadOutput)
    pub fn builder() -> crate::output::complete_multipart_upload_output::Builder {
        crate::output::complete_multipart_upload_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddTagsToVaultOutput {}
impl std::fmt::Debug for AddTagsToVaultOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddTagsToVaultOutput");
        formatter.finish()
    }
}
/// See [`AddTagsToVaultOutput`](crate::output::AddTagsToVaultOutput)
pub mod add_tags_to_vault_output {
    /// A builder for [`AddTagsToVaultOutput`](crate::output::AddTagsToVaultOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AddTagsToVaultOutput`](crate::output::AddTagsToVaultOutput)
        pub fn build(self) -> crate::output::AddTagsToVaultOutput {
            crate::output::AddTagsToVaultOutput {}
        }
    }
}
impl AddTagsToVaultOutput {
    /// Creates a new builder-style object to manufacture [`AddTagsToVaultOutput`](crate::output::AddTagsToVaultOutput)
    pub fn builder() -> crate::output::add_tags_to_vault_output::Builder {
        crate::output::add_tags_to_vault_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AbortVaultLockOutput {}
impl std::fmt::Debug for AbortVaultLockOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AbortVaultLockOutput");
        formatter.finish()
    }
}
/// See [`AbortVaultLockOutput`](crate::output::AbortVaultLockOutput)
pub mod abort_vault_lock_output {
    /// A builder for [`AbortVaultLockOutput`](crate::output::AbortVaultLockOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AbortVaultLockOutput`](crate::output::AbortVaultLockOutput)
        pub fn build(self) -> crate::output::AbortVaultLockOutput {
            crate::output::AbortVaultLockOutput {}
        }
    }
}
impl AbortVaultLockOutput {
    /// Creates a new builder-style object to manufacture [`AbortVaultLockOutput`](crate::output::AbortVaultLockOutput)
    pub fn builder() -> crate::output::abort_vault_lock_output::Builder {
        crate::output::abort_vault_lock_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AbortMultipartUploadOutput {}
impl std::fmt::Debug for AbortMultipartUploadOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AbortMultipartUploadOutput");
        formatter.finish()
    }
}
/// See [`AbortMultipartUploadOutput`](crate::output::AbortMultipartUploadOutput)
pub mod abort_multipart_upload_output {
    /// A builder for [`AbortMultipartUploadOutput`](crate::output::AbortMultipartUploadOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AbortMultipartUploadOutput`](crate::output::AbortMultipartUploadOutput)
        pub fn build(self) -> crate::output::AbortMultipartUploadOutput {
            crate::output::AbortMultipartUploadOutput {}
        }
    }
}
impl AbortMultipartUploadOutput {
    /// Creates a new builder-style object to manufacture [`AbortMultipartUploadOutput`](crate::output::AbortMultipartUploadOutput)
    pub fn builder() -> crate::output::abort_multipart_upload_output::Builder {
        crate::output::abort_multipart_upload_output::Builder::default()
    }
}
