// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AbortMultipartUploadInput`](crate::input::AbortMultipartUploadInput)
pub mod abort_multipart_upload_input {
    /// A builder for [`AbortMultipartUploadInput`](crate::input::AbortMultipartUploadInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) vault_name: std::option::Option<std::string::String>,
        pub(crate) upload_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the vault.</p>
        pub fn vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_name = Some(input.into());
            self
        }
        /// <p>The name of the vault.</p>
        pub fn set_vault_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_name = input;
            self
        }
        /// <p>The upload ID of the multipart upload to delete.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id = Some(input.into());
            self
        }
        /// <p>The upload ID of the multipart upload to delete.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upload_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AbortMultipartUploadInput`](crate::input::AbortMultipartUploadInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AbortMultipartUploadInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AbortMultipartUploadInput {
                account_id: self.account_id,
                vault_name: self.vault_name,
                upload_id: self.upload_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AbortMultipartUploadInputOperationOutputAlias = crate::operation::AbortMultipartUpload;
#[doc(hidden)]
pub type AbortMultipartUploadInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AbortMultipartUploadInput {
    /// Consumes the builder and constructs an Operation<[`AbortMultipartUpload`](crate::operation::AbortMultipartUpload)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AbortMultipartUpload,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AbortMultipartUploadInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.account_id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_1, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_2 = &_input.vault_name;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let vault_name = aws_smithy_http::label::fmt_string(input_2, false);
            if vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "vault_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_3 = &_input.upload_id;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "upload_id",
                        details: "cannot be empty or unset",
                    })?;
            let upload_id = aws_smithy_http::label::fmt_string(input_3, false);
            if upload_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "upload_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}",
                accountId = account_id,
                vaultName = vault_name,
                uploadId = upload_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AbortMultipartUploadInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AbortMultipartUploadInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        if self.account_id.as_deref().unwrap_or_default().is_empty() {
            self.account_id = Some("-".to_owned());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request.http_mut().headers_mut().insert(
            "x-amz-glacier-version",
            http::HeaderValue::from_static("2012-06-01"),
        );
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AbortMultipartUpload::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AbortMultipartUpload",
            "glacier",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AbortMultipartUploadInput`](crate::input::AbortMultipartUploadInput)
    pub fn builder() -> crate::input::abort_multipart_upload_input::Builder {
        crate::input::abort_multipart_upload_input::Builder::default()
    }
}

/// See [`AbortVaultLockInput`](crate::input::AbortVaultLockInput)
pub mod abort_vault_lock_input {
    /// A builder for [`AbortVaultLockInput`](crate::input::AbortVaultLockInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) vault_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS
        /// account ID associated with the credentials used to sign the request. You can either specify
        /// an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon
        /// Glacier uses the AWS account ID associated with the credentials used to sign the request.
        /// If you specify your account ID, do not include any hyphens ('-') in the ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS
        /// account ID associated with the credentials used to sign the request. You can either specify
        /// an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon
        /// Glacier uses the AWS account ID associated with the credentials used to sign the request.
        /// If you specify your account ID, do not include any hyphens ('-') in the ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the vault.</p>
        pub fn vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_name = Some(input.into());
            self
        }
        /// <p>The name of the vault.</p>
        pub fn set_vault_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AbortVaultLockInput`](crate::input::AbortVaultLockInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AbortVaultLockInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AbortVaultLockInput {
                account_id: self.account_id,
                vault_name: self.vault_name,
            })
        }
    }
}
#[doc(hidden)]
pub type AbortVaultLockInputOperationOutputAlias = crate::operation::AbortVaultLock;
#[doc(hidden)]
pub type AbortVaultLockInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AbortVaultLockInput {
    /// Consumes the builder and constructs an Operation<[`AbortVaultLock`](crate::operation::AbortVaultLock)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AbortVaultLock,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AbortVaultLockInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.account_id;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_4, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_5 = &_input.vault_name;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let vault_name = aws_smithy_http::label::fmt_string(input_5, false);
            if vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "vault_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/{accountId}/vaults/{vaultName}/lock-policy",
                accountId = account_id,
                vaultName = vault_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AbortVaultLockInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AbortVaultLockInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        if self.account_id.as_deref().unwrap_or_default().is_empty() {
            self.account_id = Some("-".to_owned());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request.http_mut().headers_mut().insert(
            "x-amz-glacier-version",
            http::HeaderValue::from_static("2012-06-01"),
        );
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AbortVaultLock::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AbortVaultLock",
            "glacier",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AbortVaultLockInput`](crate::input::AbortVaultLockInput)
    pub fn builder() -> crate::input::abort_vault_lock_input::Builder {
        crate::input::abort_vault_lock_input::Builder::default()
    }
}

/// See [`AddTagsToVaultInput`](crate::input::AddTagsToVaultInput)
pub mod add_tags_to_vault_input {
    /// A builder for [`AddTagsToVaultInput`](crate::input::AddTagsToVaultInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) vault_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the vault.</p>
        pub fn vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_name = Some(input.into());
            self
        }
        /// <p>The name of the vault.</p>
        pub fn set_vault_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the vault. Each tag is composed of a key and a value. The value
        /// can be an empty string.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to add to the vault. Each tag is composed of a key and a value. The value
        /// can be an empty string.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`AddTagsToVaultInput`](crate::input::AddTagsToVaultInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddTagsToVaultInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddTagsToVaultInput {
                account_id: self.account_id,
                vault_name: self.vault_name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type AddTagsToVaultInputOperationOutputAlias = crate::operation::AddTagsToVault;
#[doc(hidden)]
pub type AddTagsToVaultInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddTagsToVaultInput {
    /// Consumes the builder and constructs an Operation<[`AddTagsToVault`](crate::operation::AddTagsToVault)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddTagsToVault,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddTagsToVaultInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_6 = &_input.account_id;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_6, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_7 = &_input.vault_name;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let vault_name = aws_smithy_http::label::fmt_string(input_7, false);
            if vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "vault_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/{accountId}/vaults/{vaultName}/tags",
                accountId = account_id,
                vaultName = vault_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::AddTagsToVaultInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("operation", "add");
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddTagsToVaultInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddTagsToVaultInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.account_id.as_deref().unwrap_or_default().is_empty() {
            self.account_id = Some("-".to_owned());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_tags_to_vault(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request.http_mut().headers_mut().insert(
            "x-amz-glacier-version",
            http::HeaderValue::from_static("2012-06-01"),
        );
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddTagsToVault::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddTagsToVault",
            "glacier",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddTagsToVaultInput`](crate::input::AddTagsToVaultInput)
    pub fn builder() -> crate::input::add_tags_to_vault_input::Builder {
        crate::input::add_tags_to_vault_input::Builder::default()
    }
}

/// See [`CompleteMultipartUploadInput`](crate::input::CompleteMultipartUploadInput)
pub mod complete_multipart_upload_input {
    /// A builder for [`CompleteMultipartUploadInput`](crate::input::CompleteMultipartUploadInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) vault_name: std::option::Option<std::string::String>,
        pub(crate) upload_id: std::option::Option<std::string::String>,
        pub(crate) archive_size: std::option::Option<std::string::String>,
        pub(crate) checksum: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the vault.</p>
        pub fn vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_name = Some(input.into());
            self
        }
        /// <p>The name of the vault.</p>
        pub fn set_vault_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_name = input;
            self
        }
        /// <p>The upload ID of the multipart upload.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id = Some(input.into());
            self
        }
        /// <p>The upload ID of the multipart upload.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upload_id = input;
            self
        }
        /// <p>The total size, in bytes, of the entire archive. This value should be the sum of all
        /// the sizes of the individual parts that you uploaded.</p>
        pub fn archive_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.archive_size = Some(input.into());
            self
        }
        /// <p>The total size, in bytes, of the entire archive. This value should be the sum of all
        /// the sizes of the individual parts that you uploaded.</p>
        pub fn set_archive_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.archive_size = input;
            self
        }
        /// <p>The SHA256 tree hash of the entire archive. It is the tree hash of SHA256 tree hash
        /// of the individual parts. If the value you specify in the request does not match the SHA256
        /// tree hash of the final assembled archive as computed by Amazon S3 Glacier (Glacier),
        /// Glacier returns an error and the request fails.</p>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.checksum = Some(input.into());
            self
        }
        /// <p>The SHA256 tree hash of the entire archive. It is the tree hash of SHA256 tree hash
        /// of the individual parts. If the value you specify in the request does not match the SHA256
        /// tree hash of the final assembled archive as computed by Amazon S3 Glacier (Glacier),
        /// Glacier returns an error and the request fails.</p>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.checksum = input;
            self
        }
        /// Consumes the builder and constructs a [`CompleteMultipartUploadInput`](crate::input::CompleteMultipartUploadInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CompleteMultipartUploadInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CompleteMultipartUploadInput {
                account_id: self.account_id,
                vault_name: self.vault_name,
                upload_id: self.upload_id,
                archive_size: self.archive_size,
                checksum: self.checksum,
            })
        }
    }
}
#[doc(hidden)]
pub type CompleteMultipartUploadInputOperationOutputAlias =
    crate::operation::CompleteMultipartUpload;
#[doc(hidden)]
pub type CompleteMultipartUploadInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CompleteMultipartUploadInput {
    /// Consumes the builder and constructs an Operation<[`CompleteMultipartUpload`](crate::operation::CompleteMultipartUpload)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CompleteMultipartUpload,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CompleteMultipartUploadInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_8 = &_input.account_id;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_8, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_9 = &_input.vault_name;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let vault_name = aws_smithy_http::label::fmt_string(input_9, false);
            if vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "vault_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_10 = &_input.upload_id;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "upload_id",
                        details: "cannot be empty or unset",
                    })?;
            let upload_id = aws_smithy_http::label::fmt_string(input_10, false);
            if upload_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "upload_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}",
                accountId = account_id,
                vaultName = vault_name,
                uploadId = upload_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CompleteMultipartUploadInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_11) = &_input.archive_size {
                let formatted_12 = AsRef::<str>::as_ref(inner_11);
                if !formatted_12.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_12;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "archive_size",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-archive-size", header_value);
                }
            }
            if let Some(inner_13) = &_input.checksum {
                let formatted_14 = AsRef::<str>::as_ref(inner_13);
                if !formatted_14.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_14;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "checksum",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-sha256-tree-hash", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CompleteMultipartUploadInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CompleteMultipartUploadInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        if self.account_id.as_deref().unwrap_or_default().is_empty() {
            self.account_id = Some("-".to_owned());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request.http_mut().headers_mut().insert(
            "x-amz-glacier-version",
            http::HeaderValue::from_static("2012-06-01"),
        );
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CompleteMultipartUpload::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CompleteMultipartUpload",
            "glacier",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CompleteMultipartUploadInput`](crate::input::CompleteMultipartUploadInput)
    pub fn builder() -> crate::input::complete_multipart_upload_input::Builder {
        crate::input::complete_multipart_upload_input::Builder::default()
    }
}

/// See [`CompleteVaultLockInput`](crate::input::CompleteVaultLockInput)
pub mod complete_vault_lock_input {
    /// A builder for [`CompleteVaultLockInput`](crate::input::CompleteVaultLockInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) vault_name: std::option::Option<std::string::String>,
        pub(crate) lock_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS
        /// account ID associated with the credentials used to sign the request. You can either specify
        /// an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon
        /// Glacier uses the AWS account ID associated with the credentials used to sign the request.
        /// If you specify your account ID, do not include any hyphens ('-') in the ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS
        /// account ID associated with the credentials used to sign the request. You can either specify
        /// an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon
        /// Glacier uses the AWS account ID associated with the credentials used to sign the request.
        /// If you specify your account ID, do not include any hyphens ('-') in the ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the vault.</p>
        pub fn vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_name = Some(input.into());
            self
        }
        /// <p>The name of the vault.</p>
        pub fn set_vault_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_name = input;
            self
        }
        /// <p>The <code>lockId</code> value is the lock ID obtained from a <a>InitiateVaultLock</a> request.</p>
        pub fn lock_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.lock_id = Some(input.into());
            self
        }
        /// <p>The <code>lockId</code> value is the lock ID obtained from a <a>InitiateVaultLock</a> request.</p>
        pub fn set_lock_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lock_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CompleteVaultLockInput`](crate::input::CompleteVaultLockInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CompleteVaultLockInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CompleteVaultLockInput {
                account_id: self.account_id,
                vault_name: self.vault_name,
                lock_id: self.lock_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CompleteVaultLockInputOperationOutputAlias = crate::operation::CompleteVaultLock;
#[doc(hidden)]
pub type CompleteVaultLockInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CompleteVaultLockInput {
    /// Consumes the builder and constructs an Operation<[`CompleteVaultLock`](crate::operation::CompleteVaultLock)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CompleteVaultLock,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CompleteVaultLockInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_15 = &_input.account_id;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_15, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_16 = &_input.vault_name;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let vault_name = aws_smithy_http::label::fmt_string(input_16, false);
            if vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "vault_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_17 = &_input.lock_id;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "lock_id",
                        details: "cannot be empty or unset",
                    })?;
            let lock_id = aws_smithy_http::label::fmt_string(input_17, false);
            if lock_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "lock_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/{accountId}/vaults/{vaultName}/lock-policy/{lockId}",
                accountId = account_id,
                vaultName = vault_name,
                lockId = lock_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CompleteVaultLockInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CompleteVaultLockInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        if self.account_id.as_deref().unwrap_or_default().is_empty() {
            self.account_id = Some("-".to_owned());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request.http_mut().headers_mut().insert(
            "x-amz-glacier-version",
            http::HeaderValue::from_static("2012-06-01"),
        );
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CompleteVaultLock::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CompleteVaultLock",
            "glacier",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CompleteVaultLockInput`](crate::input::CompleteVaultLockInput)
    pub fn builder() -> crate::input::complete_vault_lock_input::Builder {
        crate::input::complete_vault_lock_input::Builder::default()
    }
}

/// See [`CreateVaultInput`](crate::input::CreateVaultInput)
pub mod create_vault_input {
    /// A builder for [`CreateVaultInput`](crate::input::CreateVaultInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) vault_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS
        /// account ID associated with the credentials used to sign the request. You can either specify
        /// an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon S3
        /// Glacier uses the AWS account ID associated with the credentials used to sign the request.
        /// If you specify your account ID, do not include any hyphens ('-') in the ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS
        /// account ID associated with the credentials used to sign the request. You can either specify
        /// an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon S3
        /// Glacier uses the AWS account ID associated with the credentials used to sign the request.
        /// If you specify your account ID, do not include any hyphens ('-') in the ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the vault.</p>
        pub fn vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_name = Some(input.into());
            self
        }
        /// <p>The name of the vault.</p>
        pub fn set_vault_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateVaultInput`](crate::input::CreateVaultInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateVaultInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateVaultInput {
                account_id: self.account_id,
                vault_name: self.vault_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateVaultInputOperationOutputAlias = crate::operation::CreateVault;
#[doc(hidden)]
pub type CreateVaultInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateVaultInput {
    /// Consumes the builder and constructs an Operation<[`CreateVault`](crate::operation::CreateVault)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateVault,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateVaultInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_18 = &_input.account_id;
            let input_18 =
                input_18
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_18, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_19 = &_input.vault_name;
            let input_19 =
                input_19
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let vault_name = aws_smithy_http::label::fmt_string(input_19, false);
            if vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "vault_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/{accountId}/vaults/{vaultName}",
                accountId = account_id,
                vaultName = vault_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateVaultInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateVaultInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        if self.account_id.as_deref().unwrap_or_default().is_empty() {
            self.account_id = Some("-".to_owned());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request.http_mut().headers_mut().insert(
            "x-amz-glacier-version",
            http::HeaderValue::from_static("2012-06-01"),
        );
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateVault::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateVault",
            "glacier",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateVaultInput`](crate::input::CreateVaultInput)
    pub fn builder() -> crate::input::create_vault_input::Builder {
        crate::input::create_vault_input::Builder::default()
    }
}

/// See [`DeleteArchiveInput`](crate::input::DeleteArchiveInput)
pub mod delete_archive_input {
    /// A builder for [`DeleteArchiveInput`](crate::input::DeleteArchiveInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) vault_name: std::option::Option<std::string::String>,
        pub(crate) archive_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the vault.</p>
        pub fn vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_name = Some(input.into());
            self
        }
        /// <p>The name of the vault.</p>
        pub fn set_vault_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_name = input;
            self
        }
        /// <p>The ID of the archive to delete.</p>
        pub fn archive_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.archive_id = Some(input.into());
            self
        }
        /// <p>The ID of the archive to delete.</p>
        pub fn set_archive_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.archive_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteArchiveInput`](crate::input::DeleteArchiveInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteArchiveInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteArchiveInput {
                account_id: self.account_id,
                vault_name: self.vault_name,
                archive_id: self.archive_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteArchiveInputOperationOutputAlias = crate::operation::DeleteArchive;
#[doc(hidden)]
pub type DeleteArchiveInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteArchiveInput {
    /// Consumes the builder and constructs an Operation<[`DeleteArchive`](crate::operation::DeleteArchive)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteArchive,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteArchiveInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_20 = &_input.account_id;
            let input_20 =
                input_20
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_20, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_21 = &_input.vault_name;
            let input_21 =
                input_21
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let vault_name = aws_smithy_http::label::fmt_string(input_21, false);
            if vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "vault_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_22 = &_input.archive_id;
            let input_22 =
                input_22
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "archive_id",
                        details: "cannot be empty or unset",
                    })?;
            let archive_id = aws_smithy_http::label::fmt_string(input_22, false);
            if archive_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "archive_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/{accountId}/vaults/{vaultName}/archives/{archiveId}",
                accountId = account_id,
                vaultName = vault_name,
                archiveId = archive_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteArchiveInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteArchiveInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        if self.account_id.as_deref().unwrap_or_default().is_empty() {
            self.account_id = Some("-".to_owned());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request.http_mut().headers_mut().insert(
            "x-amz-glacier-version",
            http::HeaderValue::from_static("2012-06-01"),
        );
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteArchive::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteArchive",
            "glacier",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteArchiveInput`](crate::input::DeleteArchiveInput)
    pub fn builder() -> crate::input::delete_archive_input::Builder {
        crate::input::delete_archive_input::Builder::default()
    }
}

/// See [`DeleteVaultInput`](crate::input::DeleteVaultInput)
pub mod delete_vault_input {
    /// A builder for [`DeleteVaultInput`](crate::input::DeleteVaultInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) vault_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the vault.</p>
        pub fn vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_name = Some(input.into());
            self
        }
        /// <p>The name of the vault.</p>
        pub fn set_vault_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVaultInput`](crate::input::DeleteVaultInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteVaultInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteVaultInput {
                account_id: self.account_id,
                vault_name: self.vault_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteVaultInputOperationOutputAlias = crate::operation::DeleteVault;
#[doc(hidden)]
pub type DeleteVaultInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteVaultInput {
    /// Consumes the builder and constructs an Operation<[`DeleteVault`](crate::operation::DeleteVault)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteVault,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteVaultInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_23 = &_input.account_id;
            let input_23 =
                input_23
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_23, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_24 = &_input.vault_name;
            let input_24 =
                input_24
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let vault_name = aws_smithy_http::label::fmt_string(input_24, false);
            if vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "vault_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/{accountId}/vaults/{vaultName}",
                accountId = account_id,
                vaultName = vault_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteVaultInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteVaultInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        if self.account_id.as_deref().unwrap_or_default().is_empty() {
            self.account_id = Some("-".to_owned());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request.http_mut().headers_mut().insert(
            "x-amz-glacier-version",
            http::HeaderValue::from_static("2012-06-01"),
        );
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteVault::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteVault",
            "glacier",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteVaultInput`](crate::input::DeleteVaultInput)
    pub fn builder() -> crate::input::delete_vault_input::Builder {
        crate::input::delete_vault_input::Builder::default()
    }
}

/// See [`DeleteVaultAccessPolicyInput`](crate::input::DeleteVaultAccessPolicyInput)
pub mod delete_vault_access_policy_input {
    /// A builder for [`DeleteVaultAccessPolicyInput`](crate::input::DeleteVaultAccessPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) vault_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID. </p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID. </p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the vault.</p>
        pub fn vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_name = Some(input.into());
            self
        }
        /// <p>The name of the vault.</p>
        pub fn set_vault_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVaultAccessPolicyInput`](crate::input::DeleteVaultAccessPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteVaultAccessPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteVaultAccessPolicyInput {
                account_id: self.account_id,
                vault_name: self.vault_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteVaultAccessPolicyInputOperationOutputAlias =
    crate::operation::DeleteVaultAccessPolicy;
#[doc(hidden)]
pub type DeleteVaultAccessPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteVaultAccessPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteVaultAccessPolicy`](crate::operation::DeleteVaultAccessPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteVaultAccessPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteVaultAccessPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_25 = &_input.account_id;
            let input_25 =
                input_25
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_25, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_26 = &_input.vault_name;
            let input_26 =
                input_26
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let vault_name = aws_smithy_http::label::fmt_string(input_26, false);
            if vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "vault_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/{accountId}/vaults/{vaultName}/access-policy",
                accountId = account_id,
                vaultName = vault_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteVaultAccessPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteVaultAccessPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        if self.account_id.as_deref().unwrap_or_default().is_empty() {
            self.account_id = Some("-".to_owned());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request.http_mut().headers_mut().insert(
            "x-amz-glacier-version",
            http::HeaderValue::from_static("2012-06-01"),
        );
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteVaultAccessPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteVaultAccessPolicy",
            "glacier",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteVaultAccessPolicyInput`](crate::input::DeleteVaultAccessPolicyInput)
    pub fn builder() -> crate::input::delete_vault_access_policy_input::Builder {
        crate::input::delete_vault_access_policy_input::Builder::default()
    }
}

/// See [`DeleteVaultNotificationsInput`](crate::input::DeleteVaultNotificationsInput)
pub mod delete_vault_notifications_input {
    /// A builder for [`DeleteVaultNotificationsInput`](crate::input::DeleteVaultNotificationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) vault_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID. </p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID. </p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the vault.</p>
        pub fn vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_name = Some(input.into());
            self
        }
        /// <p>The name of the vault.</p>
        pub fn set_vault_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVaultNotificationsInput`](crate::input::DeleteVaultNotificationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteVaultNotificationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteVaultNotificationsInput {
                account_id: self.account_id,
                vault_name: self.vault_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteVaultNotificationsInputOperationOutputAlias =
    crate::operation::DeleteVaultNotifications;
#[doc(hidden)]
pub type DeleteVaultNotificationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteVaultNotificationsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteVaultNotifications`](crate::operation::DeleteVaultNotifications)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteVaultNotifications,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteVaultNotificationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_27 = &_input.account_id;
            let input_27 =
                input_27
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_27, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_28 = &_input.vault_name;
            let input_28 =
                input_28
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let vault_name = aws_smithy_http::label::fmt_string(input_28, false);
            if vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "vault_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/{accountId}/vaults/{vaultName}/notification-configuration",
                accountId = account_id,
                vaultName = vault_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteVaultNotificationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteVaultNotificationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        if self.account_id.as_deref().unwrap_or_default().is_empty() {
            self.account_id = Some("-".to_owned());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request.http_mut().headers_mut().insert(
            "x-amz-glacier-version",
            http::HeaderValue::from_static("2012-06-01"),
        );
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteVaultNotifications::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteVaultNotifications",
            "glacier",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteVaultNotificationsInput`](crate::input::DeleteVaultNotificationsInput)
    pub fn builder() -> crate::input::delete_vault_notifications_input::Builder {
        crate::input::delete_vault_notifications_input::Builder::default()
    }
}

/// See [`DescribeJobInput`](crate::input::DescribeJobInput)
pub mod describe_job_input {
    /// A builder for [`DescribeJobInput`](crate::input::DescribeJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) vault_name: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID. </p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID. </p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the vault.</p>
        pub fn vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_name = Some(input.into());
            self
        }
        /// <p>The name of the vault.</p>
        pub fn set_vault_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_name = input;
            self
        }
        /// <p>The ID of the job to describe.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID of the job to describe.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeJobInput`](crate::input::DescribeJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeJobInput {
                account_id: self.account_id,
                vault_name: self.vault_name,
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeJobInputOperationOutputAlias = crate::operation::DescribeJob;
#[doc(hidden)]
pub type DescribeJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeJob`](crate::operation::DescribeJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_29 = &_input.account_id;
            let input_29 =
                input_29
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_29, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_30 = &_input.vault_name;
            let input_30 =
                input_30
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let vault_name = aws_smithy_http::label::fmt_string(input_30, false);
            if vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "vault_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_31 = &_input.job_id;
            let input_31 =
                input_31
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    })?;
            let job_id = aws_smithy_http::label::fmt_string(input_31, false);
            if job_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "job_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/{accountId}/vaults/{vaultName}/jobs/{jobId}",
                accountId = account_id,
                vaultName = vault_name,
                jobId = job_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        if self.account_id.as_deref().unwrap_or_default().is_empty() {
            self.account_id = Some("-".to_owned());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request.http_mut().headers_mut().insert(
            "x-amz-glacier-version",
            http::HeaderValue::from_static("2012-06-01"),
        );
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeJob",
            "glacier",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeJobInput`](crate::input::DescribeJobInput)
    pub fn builder() -> crate::input::describe_job_input::Builder {
        crate::input::describe_job_input::Builder::default()
    }
}

/// See [`DescribeVaultInput`](crate::input::DescribeVaultInput)
pub mod describe_vault_input {
    /// A builder for [`DescribeVaultInput`](crate::input::DescribeVaultInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) vault_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID. </p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID. </p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the vault.</p>
        pub fn vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_name = Some(input.into());
            self
        }
        /// <p>The name of the vault.</p>
        pub fn set_vault_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeVaultInput`](crate::input::DescribeVaultInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeVaultInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeVaultInput {
                account_id: self.account_id,
                vault_name: self.vault_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeVaultInputOperationOutputAlias = crate::operation::DescribeVault;
#[doc(hidden)]
pub type DescribeVaultInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeVaultInput {
    /// Consumes the builder and constructs an Operation<[`DescribeVault`](crate::operation::DescribeVault)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeVault,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeVaultInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_32 = &_input.account_id;
            let input_32 =
                input_32
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_32, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_33 = &_input.vault_name;
            let input_33 =
                input_33
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let vault_name = aws_smithy_http::label::fmt_string(input_33, false);
            if vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "vault_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/{accountId}/vaults/{vaultName}",
                accountId = account_id,
                vaultName = vault_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeVaultInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeVaultInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        if self.account_id.as_deref().unwrap_or_default().is_empty() {
            self.account_id = Some("-".to_owned());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request.http_mut().headers_mut().insert(
            "x-amz-glacier-version",
            http::HeaderValue::from_static("2012-06-01"),
        );
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeVault::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeVault",
            "glacier",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeVaultInput`](crate::input::DescribeVaultInput)
    pub fn builder() -> crate::input::describe_vault_input::Builder {
        crate::input::describe_vault_input::Builder::default()
    }
}

/// See [`GetDataRetrievalPolicyInput`](crate::input::GetDataRetrievalPolicyInput)
pub mod get_data_retrieval_policy_input {
    /// A builder for [`GetDataRetrievalPolicyInput`](crate::input::GetDataRetrievalPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS
        /// account ID associated with the credentials used to sign the request. You can either specify
        /// an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon
        /// Glacier uses the AWS account ID associated with the credentials used to sign the request.
        /// If you specify your account ID, do not include any hyphens ('-') in the ID. </p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS
        /// account ID associated with the credentials used to sign the request. You can either specify
        /// an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon
        /// Glacier uses the AWS account ID associated with the credentials used to sign the request.
        /// If you specify your account ID, do not include any hyphens ('-') in the ID. </p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDataRetrievalPolicyInput`](crate::input::GetDataRetrievalPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDataRetrievalPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDataRetrievalPolicyInput {
                account_id: self.account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDataRetrievalPolicyInputOperationOutputAlias = crate::operation::GetDataRetrievalPolicy;
#[doc(hidden)]
pub type GetDataRetrievalPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDataRetrievalPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetDataRetrievalPolicy`](crate::operation::GetDataRetrievalPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDataRetrievalPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDataRetrievalPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_34 = &_input.account_id;
            let input_34 =
                input_34
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_34, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/{accountId}/policies/data-retrieval",
                accountId = account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDataRetrievalPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDataRetrievalPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        if self.account_id.as_deref().unwrap_or_default().is_empty() {
            self.account_id = Some("-".to_owned());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request.http_mut().headers_mut().insert(
            "x-amz-glacier-version",
            http::HeaderValue::from_static("2012-06-01"),
        );
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDataRetrievalPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDataRetrievalPolicy",
            "glacier",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDataRetrievalPolicyInput`](crate::input::GetDataRetrievalPolicyInput)
    pub fn builder() -> crate::input::get_data_retrieval_policy_input::Builder {
        crate::input::get_data_retrieval_policy_input::Builder::default()
    }
}

/// See [`GetJobOutputInput`](crate::input::GetJobOutputInput)
pub mod get_job_output_input {
    /// A builder for [`GetJobOutputInput`](crate::input::GetJobOutputInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) vault_name: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) range: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the vault.</p>
        pub fn vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_name = Some(input.into());
            self
        }
        /// <p>The name of the vault.</p>
        pub fn set_vault_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_name = input;
            self
        }
        /// <p>The job ID whose data is downloaded.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The job ID whose data is downloaded.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The range of bytes to retrieve from the output. For example, if you want to download
        /// the first 1,048,576 bytes, specify the range as <code>bytes=0-1048575</code>. By default, this operation
        /// downloads the entire output.</p>
        ///
        /// <p>If the job output is large, then you can use a range to
        /// retrieve a portion of the output. This allows you to download the entire output in smaller
        /// chunks of bytes. For example, suppose you have 1 GB of job output you want to download and
        /// you decide to download 128 MB chunks of data at a time, which is a total of eight Get Job
        /// Output requests. You use the following process to download the job output:</p>
        ///
        /// <ol>
        /// <li>
        /// <p>Download a 128 MB chunk of output by specifying the appropriate byte range.
        /// Verify that all 128 MB of data was received.</p>
        /// </li>
        /// <li>
        /// <p>Along with the data, the response includes a SHA256 tree hash of the payload.
        /// You compute the checksum of the payload on the client and compare it with the
        /// checksum you received in the response to ensure you received all the expected
        /// data.</p>
        /// </li>
        /// <li>
        /// <p>Repeat steps 1 and 2 for all the eight 128 MB chunks of output data, each time
        /// specifying the appropriate byte range.</p>
        /// </li>
        /// <li>
        /// <p>After downloading all the parts of the job output, you have a list of eight
        /// checksum values. Compute the tree hash of these values to find the checksum of the
        /// entire output. Using the <a>DescribeJob</a> API, obtain job information of
        /// the job that provided you the output. The response includes the checksum of the
        /// entire archive stored in Amazon S3 Glacier. You compare this value with the checksum you
        /// computed to ensure you have downloaded the entire archive content with no
        /// errors.</p>
        /// <p></p>
        /// </li>
        /// </ol>
        pub fn range(mut self, input: impl Into<std::string::String>) -> Self {
            self.range = Some(input.into());
            self
        }
        /// <p>The range of bytes to retrieve from the output. For example, if you want to download
        /// the first 1,048,576 bytes, specify the range as <code>bytes=0-1048575</code>. By default, this operation
        /// downloads the entire output.</p>
        ///
        /// <p>If the job output is large, then you can use a range to
        /// retrieve a portion of the output. This allows you to download the entire output in smaller
        /// chunks of bytes. For example, suppose you have 1 GB of job output you want to download and
        /// you decide to download 128 MB chunks of data at a time, which is a total of eight Get Job
        /// Output requests. You use the following process to download the job output:</p>
        ///
        /// <ol>
        /// <li>
        /// <p>Download a 128 MB chunk of output by specifying the appropriate byte range.
        /// Verify that all 128 MB of data was received.</p>
        /// </li>
        /// <li>
        /// <p>Along with the data, the response includes a SHA256 tree hash of the payload.
        /// You compute the checksum of the payload on the client and compare it with the
        /// checksum you received in the response to ensure you received all the expected
        /// data.</p>
        /// </li>
        /// <li>
        /// <p>Repeat steps 1 and 2 for all the eight 128 MB chunks of output data, each time
        /// specifying the appropriate byte range.</p>
        /// </li>
        /// <li>
        /// <p>After downloading all the parts of the job output, you have a list of eight
        /// checksum values. Compute the tree hash of these values to find the checksum of the
        /// entire output. Using the <a>DescribeJob</a> API, obtain job information of
        /// the job that provided you the output. The response includes the checksum of the
        /// entire archive stored in Amazon S3 Glacier. You compare this value with the checksum you
        /// computed to ensure you have downloaded the entire archive content with no
        /// errors.</p>
        /// <p></p>
        /// </li>
        /// </ol>
        pub fn set_range(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.range = input;
            self
        }
        /// Consumes the builder and constructs a [`GetJobOutputInput`](crate::input::GetJobOutputInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetJobOutputInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetJobOutputInput {
                account_id: self.account_id,
                vault_name: self.vault_name,
                job_id: self.job_id,
                range: self.range,
            })
        }
    }
}
#[doc(hidden)]
pub type GetJobOutputInputOperationOutputAlias = crate::operation::GetJobOutput;
#[doc(hidden)]
pub type GetJobOutputInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetJobOutputInput {
    /// Consumes the builder and constructs an Operation<[`GetJobOutput`](crate::operation::GetJobOutput)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetJobOutput,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetJobOutputInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_35 = &_input.account_id;
            let input_35 =
                input_35
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_35, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_36 = &_input.vault_name;
            let input_36 =
                input_36
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let vault_name = aws_smithy_http::label::fmt_string(input_36, false);
            if vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "vault_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_37 = &_input.job_id;
            let input_37 =
                input_37
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    })?;
            let job_id = aws_smithy_http::label::fmt_string(input_37, false);
            if job_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "job_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/{accountId}/vaults/{vaultName}/jobs/{jobId}/output",
                accountId = account_id,
                vaultName = vault_name,
                jobId = job_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetJobOutputInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_38) = &_input.range {
                let formatted_39 = AsRef::<str>::as_ref(inner_38);
                if !formatted_39.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_39;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "range",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("Range", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetJobOutputInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetJobOutputInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        if self.account_id.as_deref().unwrap_or_default().is_empty() {
            self.account_id = Some("-".to_owned());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request.http_mut().headers_mut().insert(
            "x-amz-glacier-version",
            http::HeaderValue::from_static("2012-06-01"),
        );
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetJobOutput::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetJobOutput",
            "glacier",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetJobOutputInput`](crate::input::GetJobOutputInput)
    pub fn builder() -> crate::input::get_job_output_input::Builder {
        crate::input::get_job_output_input::Builder::default()
    }
}

/// See [`GetVaultAccessPolicyInput`](crate::input::GetVaultAccessPolicyInput)
pub mod get_vault_access_policy_input {
    /// A builder for [`GetVaultAccessPolicyInput`](crate::input::GetVaultAccessPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) vault_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the vault.</p>
        pub fn vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_name = Some(input.into());
            self
        }
        /// <p>The name of the vault.</p>
        pub fn set_vault_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetVaultAccessPolicyInput`](crate::input::GetVaultAccessPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetVaultAccessPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetVaultAccessPolicyInput {
                account_id: self.account_id,
                vault_name: self.vault_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetVaultAccessPolicyInputOperationOutputAlias = crate::operation::GetVaultAccessPolicy;
#[doc(hidden)]
pub type GetVaultAccessPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetVaultAccessPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetVaultAccessPolicy`](crate::operation::GetVaultAccessPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetVaultAccessPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetVaultAccessPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_40 = &_input.account_id;
            let input_40 =
                input_40
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_40, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_41 = &_input.vault_name;
            let input_41 =
                input_41
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let vault_name = aws_smithy_http::label::fmt_string(input_41, false);
            if vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "vault_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/{accountId}/vaults/{vaultName}/access-policy",
                accountId = account_id,
                vaultName = vault_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetVaultAccessPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetVaultAccessPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        if self.account_id.as_deref().unwrap_or_default().is_empty() {
            self.account_id = Some("-".to_owned());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request.http_mut().headers_mut().insert(
            "x-amz-glacier-version",
            http::HeaderValue::from_static("2012-06-01"),
        );
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetVaultAccessPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetVaultAccessPolicy",
            "glacier",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetVaultAccessPolicyInput`](crate::input::GetVaultAccessPolicyInput)
    pub fn builder() -> crate::input::get_vault_access_policy_input::Builder {
        crate::input::get_vault_access_policy_input::Builder::default()
    }
}

/// See [`GetVaultLockInput`](crate::input::GetVaultLockInput)
pub mod get_vault_lock_input {
    /// A builder for [`GetVaultLockInput`](crate::input::GetVaultLockInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) vault_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the vault.</p>
        pub fn vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_name = Some(input.into());
            self
        }
        /// <p>The name of the vault.</p>
        pub fn set_vault_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetVaultLockInput`](crate::input::GetVaultLockInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetVaultLockInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetVaultLockInput {
                account_id: self.account_id,
                vault_name: self.vault_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetVaultLockInputOperationOutputAlias = crate::operation::GetVaultLock;
#[doc(hidden)]
pub type GetVaultLockInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetVaultLockInput {
    /// Consumes the builder and constructs an Operation<[`GetVaultLock`](crate::operation::GetVaultLock)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetVaultLock,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetVaultLockInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_42 = &_input.account_id;
            let input_42 =
                input_42
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_42, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_43 = &_input.vault_name;
            let input_43 =
                input_43
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let vault_name = aws_smithy_http::label::fmt_string(input_43, false);
            if vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "vault_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/{accountId}/vaults/{vaultName}/lock-policy",
                accountId = account_id,
                vaultName = vault_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetVaultLockInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetVaultLockInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        if self.account_id.as_deref().unwrap_or_default().is_empty() {
            self.account_id = Some("-".to_owned());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request.http_mut().headers_mut().insert(
            "x-amz-glacier-version",
            http::HeaderValue::from_static("2012-06-01"),
        );
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetVaultLock::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetVaultLock",
            "glacier",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetVaultLockInput`](crate::input::GetVaultLockInput)
    pub fn builder() -> crate::input::get_vault_lock_input::Builder {
        crate::input::get_vault_lock_input::Builder::default()
    }
}

/// See [`GetVaultNotificationsInput`](crate::input::GetVaultNotificationsInput)
pub mod get_vault_notifications_input {
    /// A builder for [`GetVaultNotificationsInput`](crate::input::GetVaultNotificationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) vault_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the vault.</p>
        pub fn vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_name = Some(input.into());
            self
        }
        /// <p>The name of the vault.</p>
        pub fn set_vault_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetVaultNotificationsInput`](crate::input::GetVaultNotificationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetVaultNotificationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetVaultNotificationsInput {
                account_id: self.account_id,
                vault_name: self.vault_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetVaultNotificationsInputOperationOutputAlias = crate::operation::GetVaultNotifications;
#[doc(hidden)]
pub type GetVaultNotificationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetVaultNotificationsInput {
    /// Consumes the builder and constructs an Operation<[`GetVaultNotifications`](crate::operation::GetVaultNotifications)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetVaultNotifications,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetVaultNotificationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_44 = &_input.account_id;
            let input_44 =
                input_44
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_44, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_45 = &_input.vault_name;
            let input_45 =
                input_45
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let vault_name = aws_smithy_http::label::fmt_string(input_45, false);
            if vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "vault_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/{accountId}/vaults/{vaultName}/notification-configuration",
                accountId = account_id,
                vaultName = vault_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetVaultNotificationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetVaultNotificationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        if self.account_id.as_deref().unwrap_or_default().is_empty() {
            self.account_id = Some("-".to_owned());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request.http_mut().headers_mut().insert(
            "x-amz-glacier-version",
            http::HeaderValue::from_static("2012-06-01"),
        );
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetVaultNotifications::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetVaultNotifications",
            "glacier",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetVaultNotificationsInput`](crate::input::GetVaultNotificationsInput)
    pub fn builder() -> crate::input::get_vault_notifications_input::Builder {
        crate::input::get_vault_notifications_input::Builder::default()
    }
}

/// See [`InitiateJobInput`](crate::input::InitiateJobInput)
pub mod initiate_job_input {
    /// A builder for [`InitiateJobInput`](crate::input::InitiateJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) vault_name: std::option::Option<std::string::String>,
        pub(crate) job_parameters: std::option::Option<crate::model::JobParameters>,
    }
    impl Builder {
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the vault.</p>
        pub fn vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_name = Some(input.into());
            self
        }
        /// <p>The name of the vault.</p>
        pub fn set_vault_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_name = input;
            self
        }
        /// <p>Provides options for specifying job information.</p>
        pub fn job_parameters(mut self, input: crate::model::JobParameters) -> Self {
            self.job_parameters = Some(input);
            self
        }
        /// <p>Provides options for specifying job information.</p>
        pub fn set_job_parameters(
            mut self,
            input: std::option::Option<crate::model::JobParameters>,
        ) -> Self {
            self.job_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`InitiateJobInput`](crate::input::InitiateJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::InitiateJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::InitiateJobInput {
                account_id: self.account_id,
                vault_name: self.vault_name,
                job_parameters: self.job_parameters,
            })
        }
    }
}
#[doc(hidden)]
pub type InitiateJobInputOperationOutputAlias = crate::operation::InitiateJob;
#[doc(hidden)]
pub type InitiateJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl InitiateJobInput {
    /// Consumes the builder and constructs an Operation<[`InitiateJob`](crate::operation::InitiateJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::InitiateJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::InitiateJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_46 = &_input.account_id;
            let input_46 =
                input_46
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_46, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_47 = &_input.vault_name;
            let input_47 =
                input_47
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let vault_name = aws_smithy_http::label::fmt_string(input_47, false);
            if vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "vault_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/{accountId}/vaults/{vaultName}/jobs",
                accountId = account_id,
                vaultName = vault_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::InitiateJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::InitiateJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.account_id.as_deref().unwrap_or_default().is_empty() {
            self.account_id = Some("-".to_owned());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::ser_payload_initiate_job_input(&self.job_parameters)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request.http_mut().headers_mut().insert(
            "x-amz-glacier-version",
            http::HeaderValue::from_static("2012-06-01"),
        );
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::InitiateJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "InitiateJob",
            "glacier",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`InitiateJobInput`](crate::input::InitiateJobInput)
    pub fn builder() -> crate::input::initiate_job_input::Builder {
        crate::input::initiate_job_input::Builder::default()
    }
}

/// See [`InitiateMultipartUploadInput`](crate::input::InitiateMultipartUploadInput)
pub mod initiate_multipart_upload_input {
    /// A builder for [`InitiateMultipartUploadInput`](crate::input::InitiateMultipartUploadInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) vault_name: std::option::Option<std::string::String>,
        pub(crate) archive_description: std::option::Option<std::string::String>,
        pub(crate) part_size: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID. </p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID. </p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the vault.</p>
        pub fn vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_name = Some(input.into());
            self
        }
        /// <p>The name of the vault.</p>
        pub fn set_vault_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_name = input;
            self
        }
        /// <p>The archive description that you are uploading in parts.</p>
        /// <p>The part size must be a megabyte (1024 KB) multiplied by a power of 2, for example
        /// 1048576 (1 MB), 2097152 (2 MB), 4194304 (4 MB), 8388608 (8 MB), and so on. The minimum
        /// allowable part size is 1 MB, and the maximum is 4 GB (4096 MB).</p>
        pub fn archive_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.archive_description = Some(input.into());
            self
        }
        /// <p>The archive description that you are uploading in parts.</p>
        /// <p>The part size must be a megabyte (1024 KB) multiplied by a power of 2, for example
        /// 1048576 (1 MB), 2097152 (2 MB), 4194304 (4 MB), 8388608 (8 MB), and so on. The minimum
        /// allowable part size is 1 MB, and the maximum is 4 GB (4096 MB).</p>
        pub fn set_archive_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.archive_description = input;
            self
        }
        /// <p>The size of each part except the last, in bytes. The last part can be smaller than
        /// this part size.</p>
        pub fn part_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.part_size = Some(input.into());
            self
        }
        /// <p>The size of each part except the last, in bytes. The last part can be smaller than
        /// this part size.</p>
        pub fn set_part_size(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.part_size = input;
            self
        }
        /// Consumes the builder and constructs a [`InitiateMultipartUploadInput`](crate::input::InitiateMultipartUploadInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::InitiateMultipartUploadInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::InitiateMultipartUploadInput {
                account_id: self.account_id,
                vault_name: self.vault_name,
                archive_description: self.archive_description,
                part_size: self.part_size,
            })
        }
    }
}
#[doc(hidden)]
pub type InitiateMultipartUploadInputOperationOutputAlias =
    crate::operation::InitiateMultipartUpload;
#[doc(hidden)]
pub type InitiateMultipartUploadInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl InitiateMultipartUploadInput {
    /// Consumes the builder and constructs an Operation<[`InitiateMultipartUpload`](crate::operation::InitiateMultipartUpload)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::InitiateMultipartUpload,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::InitiateMultipartUploadInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_48 = &_input.account_id;
            let input_48 =
                input_48
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_48, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_49 = &_input.vault_name;
            let input_49 =
                input_49
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let vault_name = aws_smithy_http::label::fmt_string(input_49, false);
            if vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "vault_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/{accountId}/vaults/{vaultName}/multipart-uploads",
                accountId = account_id,
                vaultName = vault_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::InitiateMultipartUploadInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_50) = &_input.archive_description {
                let formatted_51 = AsRef::<str>::as_ref(inner_50);
                if !formatted_51.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_51;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "archive_description",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-archive-description", header_value);
                }
            }
            if let Some(inner_52) = &_input.part_size {
                let formatted_53 = AsRef::<str>::as_ref(inner_52);
                if !formatted_53.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_53;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "part_size",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-part-size", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::InitiateMultipartUploadInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::InitiateMultipartUploadInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        if self.account_id.as_deref().unwrap_or_default().is_empty() {
            self.account_id = Some("-".to_owned());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request.http_mut().headers_mut().insert(
            "x-amz-glacier-version",
            http::HeaderValue::from_static("2012-06-01"),
        );
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::InitiateMultipartUpload::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "InitiateMultipartUpload",
            "glacier",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`InitiateMultipartUploadInput`](crate::input::InitiateMultipartUploadInput)
    pub fn builder() -> crate::input::initiate_multipart_upload_input::Builder {
        crate::input::initiate_multipart_upload_input::Builder::default()
    }
}

/// See [`InitiateVaultLockInput`](crate::input::InitiateVaultLockInput)
pub mod initiate_vault_lock_input {
    /// A builder for [`InitiateVaultLockInput`](crate::input::InitiateVaultLockInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) vault_name: std::option::Option<std::string::String>,
        pub(crate) policy: std::option::Option<crate::model::VaultLockPolicy>,
    }
    impl Builder {
        /// <p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS
        /// account ID associated with the credentials used to sign the request. You can either specify
        /// an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon
        /// Glacier uses the AWS account ID associated with the credentials used to sign the request.
        /// If you specify your account ID, do not include any hyphens ('-') in the ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS
        /// account ID associated with the credentials used to sign the request. You can either specify
        /// an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon
        /// Glacier uses the AWS account ID associated with the credentials used to sign the request.
        /// If you specify your account ID, do not include any hyphens ('-') in the ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the vault.</p>
        pub fn vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_name = Some(input.into());
            self
        }
        /// <p>The name of the vault.</p>
        pub fn set_vault_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_name = input;
            self
        }
        /// <p>The vault lock policy as a JSON string, which uses "\" as an escape
        /// character.</p>
        pub fn policy(mut self, input: crate::model::VaultLockPolicy) -> Self {
            self.policy = Some(input);
            self
        }
        /// <p>The vault lock policy as a JSON string, which uses "\" as an escape
        /// character.</p>
        pub fn set_policy(
            mut self,
            input: std::option::Option<crate::model::VaultLockPolicy>,
        ) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`InitiateVaultLockInput`](crate::input::InitiateVaultLockInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::InitiateVaultLockInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::InitiateVaultLockInput {
                account_id: self.account_id,
                vault_name: self.vault_name,
                policy: self.policy,
            })
        }
    }
}
#[doc(hidden)]
pub type InitiateVaultLockInputOperationOutputAlias = crate::operation::InitiateVaultLock;
#[doc(hidden)]
pub type InitiateVaultLockInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl InitiateVaultLockInput {
    /// Consumes the builder and constructs an Operation<[`InitiateVaultLock`](crate::operation::InitiateVaultLock)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::InitiateVaultLock,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::InitiateVaultLockInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_54 = &_input.account_id;
            let input_54 =
                input_54
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_54, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_55 = &_input.vault_name;
            let input_55 =
                input_55
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let vault_name = aws_smithy_http::label::fmt_string(input_55, false);
            if vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "vault_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/{accountId}/vaults/{vaultName}/lock-policy",
                accountId = account_id,
                vaultName = vault_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::InitiateVaultLockInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::InitiateVaultLockInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.account_id.as_deref().unwrap_or_default().is_empty() {
            self.account_id = Some("-".to_owned());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::ser_payload_initiate_vault_lock_input(&self.policy)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request.http_mut().headers_mut().insert(
            "x-amz-glacier-version",
            http::HeaderValue::from_static("2012-06-01"),
        );
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::InitiateVaultLock::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "InitiateVaultLock",
            "glacier",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`InitiateVaultLockInput`](crate::input::InitiateVaultLockInput)
    pub fn builder() -> crate::input::initiate_vault_lock_input::Builder {
        crate::input::initiate_vault_lock_input::Builder::default()
    }
}

/// See [`ListJobsInput`](crate::input::ListJobsInput)
pub mod list_jobs_input {
    /// A builder for [`ListJobsInput`](crate::input::ListJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) vault_name: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) statuscode: std::option::Option<std::string::String>,
        pub(crate) completed: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID. </p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID. </p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the vault.</p>
        pub fn vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_name = Some(input.into());
            self
        }
        /// <p>The name of the vault.</p>
        pub fn set_vault_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_name = input;
            self
        }
        /// <p>The maximum number of jobs to be returned. The default limit is 50. The number of
        /// jobs returned might be fewer than the specified limit, but the number of returned jobs
        /// never exceeds the limit.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of jobs to be returned. The default limit is 50. The number of
        /// jobs returned might be fewer than the specified limit, but the number of returned jobs
        /// never exceeds the limit.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>An opaque string used for pagination. This value specifies the job at which the
        /// listing of jobs should begin. Get the marker value from a previous List Jobs response. You
        /// only need to include the marker if you are continuing the pagination of results started in
        /// a previous List Jobs request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An opaque string used for pagination. This value specifies the job at which the
        /// listing of jobs should begin. Get the marker value from a previous List Jobs response. You
        /// only need to include the marker if you are continuing the pagination of results started in
        /// a previous List Jobs request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The type of job status to return. You can specify the following values:
        /// <code>InProgress</code>, <code>Succeeded</code>, or <code>Failed</code>.</p>
        pub fn statuscode(mut self, input: impl Into<std::string::String>) -> Self {
            self.statuscode = Some(input.into());
            self
        }
        /// <p>The type of job status to return. You can specify the following values:
        /// <code>InProgress</code>, <code>Succeeded</code>, or <code>Failed</code>.</p>
        pub fn set_statuscode(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.statuscode = input;
            self
        }
        /// <p>The state of the jobs to return. You can specify <code>true</code> or
        /// <code>false</code>.</p>
        pub fn completed(mut self, input: impl Into<std::string::String>) -> Self {
            self.completed = Some(input.into());
            self
        }
        /// <p>The state of the jobs to return. You can specify <code>true</code> or
        /// <code>false</code>.</p>
        pub fn set_completed(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.completed = input;
            self
        }
        /// Consumes the builder and constructs a [`ListJobsInput`](crate::input::ListJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListJobsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListJobsInput {
                account_id: self.account_id,
                vault_name: self.vault_name,
                limit: self.limit,
                marker: self.marker,
                statuscode: self.statuscode,
                completed: self.completed,
            })
        }
    }
}
#[doc(hidden)]
pub type ListJobsInputOperationOutputAlias = crate::operation::ListJobs;
#[doc(hidden)]
pub type ListJobsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListJobs`](crate::operation::ListJobs)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListJobs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_56 = &_input.account_id;
            let input_56 =
                input_56
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_56, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_57 = &_input.vault_name;
            let input_57 =
                input_57
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let vault_name = aws_smithy_http::label::fmt_string(input_57, false);
            if vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "vault_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/{accountId}/vaults/{vaultName}/jobs",
                accountId = account_id,
                vaultName = vault_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListJobsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_58) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_58).encode(),
                );
            }
            if let Some(inner_59) = &_input.marker {
                query.push_kv("marker", &aws_smithy_http::query::fmt_string(&inner_59));
            }
            if let Some(inner_60) = &_input.statuscode {
                query.push_kv("statuscode", &aws_smithy_http::query::fmt_string(&inner_60));
            }
            if let Some(inner_61) = &_input.completed {
                query.push_kv("completed", &aws_smithy_http::query::fmt_string(&inner_61));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        if self.account_id.as_deref().unwrap_or_default().is_empty() {
            self.account_id = Some("-".to_owned());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request.http_mut().headers_mut().insert(
            "x-amz-glacier-version",
            http::HeaderValue::from_static("2012-06-01"),
        );
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListJobs::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListJobs", "glacier",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListJobsInput`](crate::input::ListJobsInput)
    pub fn builder() -> crate::input::list_jobs_input::Builder {
        crate::input::list_jobs_input::Builder::default()
    }
}

/// See [`ListMultipartUploadsInput`](crate::input::ListMultipartUploadsInput)
pub mod list_multipart_uploads_input {
    /// A builder for [`ListMultipartUploadsInput`](crate::input::ListMultipartUploadsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) vault_name: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID. </p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID. </p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the vault.</p>
        pub fn vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_name = Some(input.into());
            self
        }
        /// <p>The name of the vault.</p>
        pub fn set_vault_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_name = input;
            self
        }
        /// <p>Specifies the maximum number of uploads returned in the response body. If this value
        /// is not specified, the List Uploads operation returns up to 50 uploads.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>Specifies the maximum number of uploads returned in the response body. If this value
        /// is not specified, the List Uploads operation returns up to 50 uploads.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>An opaque string used for pagination. This value specifies the upload at which the
        /// listing of uploads should begin. Get the marker value from a previous List Uploads
        /// response. You need only include the marker if you are continuing the pagination of results
        /// started in a previous List Uploads request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An opaque string used for pagination. This value specifies the upload at which the
        /// listing of uploads should begin. Get the marker value from a previous List Uploads
        /// response. You need only include the marker if you are continuing the pagination of results
        /// started in a previous List Uploads request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMultipartUploadsInput`](crate::input::ListMultipartUploadsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListMultipartUploadsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListMultipartUploadsInput {
                account_id: self.account_id,
                vault_name: self.vault_name,
                limit: self.limit,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type ListMultipartUploadsInputOperationOutputAlias = crate::operation::ListMultipartUploads;
#[doc(hidden)]
pub type ListMultipartUploadsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListMultipartUploadsInput {
    /// Consumes the builder and constructs an Operation<[`ListMultipartUploads`](crate::operation::ListMultipartUploads)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListMultipartUploads,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListMultipartUploadsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_62 = &_input.account_id;
            let input_62 =
                input_62
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_62, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_63 = &_input.vault_name;
            let input_63 =
                input_63
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let vault_name = aws_smithy_http::label::fmt_string(input_63, false);
            if vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "vault_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/{accountId}/vaults/{vaultName}/multipart-uploads",
                accountId = account_id,
                vaultName = vault_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListMultipartUploadsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_64) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_64).encode(),
                );
            }
            if let Some(inner_65) = &_input.marker {
                query.push_kv("marker", &aws_smithy_http::query::fmt_string(&inner_65));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListMultipartUploadsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListMultipartUploadsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        if self.account_id.as_deref().unwrap_or_default().is_empty() {
            self.account_id = Some("-".to_owned());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request.http_mut().headers_mut().insert(
            "x-amz-glacier-version",
            http::HeaderValue::from_static("2012-06-01"),
        );
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListMultipartUploads::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListMultipartUploads",
            "glacier",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListMultipartUploadsInput`](crate::input::ListMultipartUploadsInput)
    pub fn builder() -> crate::input::list_multipart_uploads_input::Builder {
        crate::input::list_multipart_uploads_input::Builder::default()
    }
}

/// See [`ListPartsInput`](crate::input::ListPartsInput)
pub mod list_parts_input {
    /// A builder for [`ListPartsInput`](crate::input::ListPartsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) vault_name: std::option::Option<std::string::String>,
        pub(crate) upload_id: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID. </p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID. </p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the vault.</p>
        pub fn vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_name = Some(input.into());
            self
        }
        /// <p>The name of the vault.</p>
        pub fn set_vault_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_name = input;
            self
        }
        /// <p>The upload ID of the multipart upload.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id = Some(input.into());
            self
        }
        /// <p>The upload ID of the multipart upload.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upload_id = input;
            self
        }
        /// <p>An opaque string used for pagination. This value specifies the part at which the
        /// listing of parts should begin. Get the marker value from the response of a previous List
        /// Parts response. You need only include the marker if you are continuing the pagination of
        /// results started in a previous List Parts request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An opaque string used for pagination. This value specifies the part at which the
        /// listing of parts should begin. Get the marker value from the response of a previous List
        /// Parts response. You need only include the marker if you are continuing the pagination of
        /// results started in a previous List Parts request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of parts to be returned. The default limit is 50. The number of
        /// parts returned might be fewer than the specified limit, but the number of returned parts
        /// never exceeds the limit.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of parts to be returned. The default limit is 50. The number of
        /// parts returned might be fewer than the specified limit, but the number of returned parts
        /// never exceeds the limit.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPartsInput`](crate::input::ListPartsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListPartsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListPartsInput {
                account_id: self.account_id,
                vault_name: self.vault_name,
                upload_id: self.upload_id,
                marker: self.marker,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPartsInputOperationOutputAlias = crate::operation::ListParts;
#[doc(hidden)]
pub type ListPartsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListPartsInput {
    /// Consumes the builder and constructs an Operation<[`ListParts`](crate::operation::ListParts)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListParts,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPartsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_66 = &_input.account_id;
            let input_66 =
                input_66
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_66, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_67 = &_input.vault_name;
            let input_67 =
                input_67
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let vault_name = aws_smithy_http::label::fmt_string(input_67, false);
            if vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "vault_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_68 = &_input.upload_id;
            let input_68 =
                input_68
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "upload_id",
                        details: "cannot be empty or unset",
                    })?;
            let upload_id = aws_smithy_http::label::fmt_string(input_68, false);
            if upload_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "upload_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}",
                accountId = account_id,
                vaultName = vault_name,
                uploadId = upload_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListPartsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_69) = &_input.marker {
                query.push_kv("marker", &aws_smithy_http::query::fmt_string(&inner_69));
            }
            if let Some(inner_70) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_70).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPartsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPartsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        if self.account_id.as_deref().unwrap_or_default().is_empty() {
            self.account_id = Some("-".to_owned());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request.http_mut().headers_mut().insert(
            "x-amz-glacier-version",
            http::HeaderValue::from_static("2012-06-01"),
        );
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListParts::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListParts",
                    "glacier",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPartsInput`](crate::input::ListPartsInput)
    pub fn builder() -> crate::input::list_parts_input::Builder {
        crate::input::list_parts_input::Builder::default()
    }
}

/// See [`ListProvisionedCapacityInput`](crate::input::ListProvisionedCapacityInput)
pub mod list_provisioned_capacity_input {
    /// A builder for [`ListProvisionedCapacityInput`](crate::input::ListProvisionedCapacityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The AWS account ID of the account that owns the vault. You can either specify an AWS
        /// account ID or optionally a single '-' (hyphen), in which case Amazon S3 Glacier uses the AWS
        /// account ID associated with the credentials used to sign the request. If you use an account
        /// ID, don't include any hyphens ('-') in the ID. </p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The AWS account ID of the account that owns the vault. You can either specify an AWS
        /// account ID or optionally a single '-' (hyphen), in which case Amazon S3 Glacier uses the AWS
        /// account ID associated with the credentials used to sign the request. If you use an account
        /// ID, don't include any hyphens ('-') in the ID. </p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProvisionedCapacityInput`](crate::input::ListProvisionedCapacityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListProvisionedCapacityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListProvisionedCapacityInput {
                account_id: self.account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListProvisionedCapacityInputOperationOutputAlias =
    crate::operation::ListProvisionedCapacity;
#[doc(hidden)]
pub type ListProvisionedCapacityInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListProvisionedCapacityInput {
    /// Consumes the builder and constructs an Operation<[`ListProvisionedCapacity`](crate::operation::ListProvisionedCapacity)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListProvisionedCapacity,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListProvisionedCapacityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_71 = &_input.account_id;
            let input_71 =
                input_71
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_71, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/{accountId}/provisioned-capacity",
                accountId = account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListProvisionedCapacityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListProvisionedCapacityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        if self.account_id.as_deref().unwrap_or_default().is_empty() {
            self.account_id = Some("-".to_owned());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request.http_mut().headers_mut().insert(
            "x-amz-glacier-version",
            http::HeaderValue::from_static("2012-06-01"),
        );
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListProvisionedCapacity::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListProvisionedCapacity",
            "glacier",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListProvisionedCapacityInput`](crate::input::ListProvisionedCapacityInput)
    pub fn builder() -> crate::input::list_provisioned_capacity_input::Builder {
        crate::input::list_provisioned_capacity_input::Builder::default()
    }
}

/// See [`ListTagsForVaultInput`](crate::input::ListTagsForVaultInput)
pub mod list_tags_for_vault_input {
    /// A builder for [`ListTagsForVaultInput`](crate::input::ListTagsForVaultInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) vault_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the vault.</p>
        pub fn vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_name = Some(input.into());
            self
        }
        /// <p>The name of the vault.</p>
        pub fn set_vault_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForVaultInput`](crate::input::ListTagsForVaultInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForVaultInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForVaultInput {
                account_id: self.account_id,
                vault_name: self.vault_name,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForVaultInputOperationOutputAlias = crate::operation::ListTagsForVault;
#[doc(hidden)]
pub type ListTagsForVaultInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForVaultInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForVault`](crate::operation::ListTagsForVault)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForVault,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForVaultInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_72 = &_input.account_id;
            let input_72 =
                input_72
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_72, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_73 = &_input.vault_name;
            let input_73 =
                input_73
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let vault_name = aws_smithy_http::label::fmt_string(input_73, false);
            if vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "vault_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/{accountId}/vaults/{vaultName}/tags",
                accountId = account_id,
                vaultName = vault_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForVaultInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForVaultInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        if self.account_id.as_deref().unwrap_or_default().is_empty() {
            self.account_id = Some("-".to_owned());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request.http_mut().headers_mut().insert(
            "x-amz-glacier-version",
            http::HeaderValue::from_static("2012-06-01"),
        );
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForVault::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForVault",
            "glacier",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForVaultInput`](crate::input::ListTagsForVaultInput)
    pub fn builder() -> crate::input::list_tags_for_vault_input::Builder {
        crate::input::list_tags_for_vault_input::Builder::default()
    }
}

/// See [`ListVaultsInput`](crate::input::ListVaultsInput)
pub mod list_vaults_input {
    /// A builder for [`ListVaultsInput`](crate::input::ListVaultsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS
        /// account ID associated with the credentials used to sign the request. You can either specify
        /// an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon
        /// Glacier uses the AWS account ID associated with the credentials used to sign the request.
        /// If you specify your account ID, do not include any hyphens ('-') in the ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS
        /// account ID associated with the credentials used to sign the request. You can either specify
        /// an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon
        /// Glacier uses the AWS account ID associated with the credentials used to sign the request.
        /// If you specify your account ID, do not include any hyphens ('-') in the ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>A string used for pagination. The marker specifies the vault ARN after which the
        /// listing of vaults should begin.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A string used for pagination. The marker specifies the vault ARN after which the
        /// listing of vaults should begin.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of vaults to be returned. The default limit is 10. The number of
        /// vaults returned might be fewer than the specified limit, but the number of returned vaults
        /// never exceeds the limit.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of vaults to be returned. The default limit is 10. The number of
        /// vaults returned might be fewer than the specified limit, but the number of returned vaults
        /// never exceeds the limit.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`ListVaultsInput`](crate::input::ListVaultsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListVaultsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListVaultsInput {
                account_id: self.account_id,
                marker: self.marker,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type ListVaultsInputOperationOutputAlias = crate::operation::ListVaults;
#[doc(hidden)]
pub type ListVaultsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListVaultsInput {
    /// Consumes the builder and constructs an Operation<[`ListVaults`](crate::operation::ListVaults)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListVaults,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListVaultsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_74 = &_input.account_id;
            let input_74 =
                input_74
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_74, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{accountId}/vaults", accountId = account_id)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListVaultsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_75) = &_input.marker {
                query.push_kv("marker", &aws_smithy_http::query::fmt_string(&inner_75));
            }
            if let Some(inner_76) = &_input.limit {
                query.push_kv(
                    "limit",
                    &aws_smithy_types::primitive::Encoder::from(*inner_76).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListVaultsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListVaultsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        if self.account_id.as_deref().unwrap_or_default().is_empty() {
            self.account_id = Some("-".to_owned());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request.http_mut().headers_mut().insert(
            "x-amz-glacier-version",
            http::HeaderValue::from_static("2012-06-01"),
        );
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListVaults::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListVaults",
            "glacier",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListVaultsInput`](crate::input::ListVaultsInput)
    pub fn builder() -> crate::input::list_vaults_input::Builder {
        crate::input::list_vaults_input::Builder::default()
    }
}

/// See [`PurchaseProvisionedCapacityInput`](crate::input::PurchaseProvisionedCapacityInput)
pub mod purchase_provisioned_capacity_input {
    /// A builder for [`PurchaseProvisionedCapacityInput`](crate::input::PurchaseProvisionedCapacityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The AWS account ID of the account that owns the vault. You can either specify an AWS
        /// account ID or optionally a single '-' (hyphen), in which case Amazon S3 Glacier uses the AWS
        /// account ID associated with the credentials used to sign the request. If you use an account
        /// ID, don't include any hyphens ('-') in the ID. </p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The AWS account ID of the account that owns the vault. You can either specify an AWS
        /// account ID or optionally a single '-' (hyphen), in which case Amazon S3 Glacier uses the AWS
        /// account ID associated with the credentials used to sign the request. If you use an account
        /// ID, don't include any hyphens ('-') in the ID. </p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PurchaseProvisionedCapacityInput`](crate::input::PurchaseProvisionedCapacityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PurchaseProvisionedCapacityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PurchaseProvisionedCapacityInput {
                account_id: self.account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type PurchaseProvisionedCapacityInputOperationOutputAlias =
    crate::operation::PurchaseProvisionedCapacity;
#[doc(hidden)]
pub type PurchaseProvisionedCapacityInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PurchaseProvisionedCapacityInput {
    /// Consumes the builder and constructs an Operation<[`PurchaseProvisionedCapacity`](crate::operation::PurchaseProvisionedCapacity)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PurchaseProvisionedCapacity,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PurchaseProvisionedCapacityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_77 = &_input.account_id;
            let input_77 =
                input_77
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_77, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/{accountId}/provisioned-capacity",
                accountId = account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PurchaseProvisionedCapacityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PurchaseProvisionedCapacityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        if self.account_id.as_deref().unwrap_or_default().is_empty() {
            self.account_id = Some("-".to_owned());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request.http_mut().headers_mut().insert(
            "x-amz-glacier-version",
            http::HeaderValue::from_static("2012-06-01"),
        );
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PurchaseProvisionedCapacity::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PurchaseProvisionedCapacity",
            "glacier",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PurchaseProvisionedCapacityInput`](crate::input::PurchaseProvisionedCapacityInput)
    pub fn builder() -> crate::input::purchase_provisioned_capacity_input::Builder {
        crate::input::purchase_provisioned_capacity_input::Builder::default()
    }
}

/// See [`RemoveTagsFromVaultInput`](crate::input::RemoveTagsFromVaultInput)
pub mod remove_tags_from_vault_input {
    /// A builder for [`RemoveTagsFromVaultInput`](crate::input::RemoveTagsFromVaultInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) vault_name: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the vault.</p>
        pub fn vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_name = Some(input.into());
            self
        }
        /// <p>The name of the vault.</p>
        pub fn set_vault_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_name = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag keys. Each corresponding tag is removed from the vault.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A list of tag keys. Each corresponding tag is removed from the vault.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveTagsFromVaultInput`](crate::input::RemoveTagsFromVaultInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveTagsFromVaultInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveTagsFromVaultInput {
                account_id: self.account_id,
                vault_name: self.vault_name,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveTagsFromVaultInputOperationOutputAlias = crate::operation::RemoveTagsFromVault;
#[doc(hidden)]
pub type RemoveTagsFromVaultInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemoveTagsFromVaultInput {
    /// Consumes the builder and constructs an Operation<[`RemoveTagsFromVault`](crate::operation::RemoveTagsFromVault)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveTagsFromVault,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveTagsFromVaultInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_78 = &_input.account_id;
            let input_78 =
                input_78
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_78, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_79 = &_input.vault_name;
            let input_79 =
                input_79
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let vault_name = aws_smithy_http::label::fmt_string(input_79, false);
            if vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "vault_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/{accountId}/vaults/{vaultName}/tags",
                accountId = account_id,
                vaultName = vault_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::RemoveTagsFromVaultInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("operation", "remove");
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveTagsFromVaultInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveTagsFromVaultInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.account_id.as_deref().unwrap_or_default().is_empty() {
            self.account_id = Some("-".to_owned());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_remove_tags_from_vault(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request.http_mut().headers_mut().insert(
            "x-amz-glacier-version",
            http::HeaderValue::from_static("2012-06-01"),
        );
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveTagsFromVault::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveTagsFromVault",
            "glacier",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveTagsFromVaultInput`](crate::input::RemoveTagsFromVaultInput)
    pub fn builder() -> crate::input::remove_tags_from_vault_input::Builder {
        crate::input::remove_tags_from_vault_input::Builder::default()
    }
}

/// See [`SetDataRetrievalPolicyInput`](crate::input::SetDataRetrievalPolicyInput)
pub mod set_data_retrieval_policy_input {
    /// A builder for [`SetDataRetrievalPolicyInput`](crate::input::SetDataRetrievalPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) policy: std::option::Option<crate::model::DataRetrievalPolicy>,
    }
    impl Builder {
        /// <p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS
        /// account ID associated with the credentials used to sign the request. You can either specify
        /// an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon
        /// Glacier uses the AWS account ID associated with the credentials used to sign the request.
        /// If you specify your account ID, do not include any hyphens ('-') in the ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS
        /// account ID associated with the credentials used to sign the request. You can either specify
        /// an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon
        /// Glacier uses the AWS account ID associated with the credentials used to sign the request.
        /// If you specify your account ID, do not include any hyphens ('-') in the ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The data retrieval policy in JSON format.</p>
        pub fn policy(mut self, input: crate::model::DataRetrievalPolicy) -> Self {
            self.policy = Some(input);
            self
        }
        /// <p>The data retrieval policy in JSON format.</p>
        pub fn set_policy(
            mut self,
            input: std::option::Option<crate::model::DataRetrievalPolicy>,
        ) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`SetDataRetrievalPolicyInput`](crate::input::SetDataRetrievalPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetDataRetrievalPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetDataRetrievalPolicyInput {
                account_id: self.account_id,
                policy: self.policy,
            })
        }
    }
}
#[doc(hidden)]
pub type SetDataRetrievalPolicyInputOperationOutputAlias = crate::operation::SetDataRetrievalPolicy;
#[doc(hidden)]
pub type SetDataRetrievalPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SetDataRetrievalPolicyInput {
    /// Consumes the builder and constructs an Operation<[`SetDataRetrievalPolicy`](crate::operation::SetDataRetrievalPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetDataRetrievalPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetDataRetrievalPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_80 = &_input.account_id;
            let input_80 =
                input_80
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_80, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/{accountId}/policies/data-retrieval",
                accountId = account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetDataRetrievalPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetDataRetrievalPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.account_id.as_deref().unwrap_or_default().is_empty() {
            self.account_id = Some("-".to_owned());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_data_retrieval_policy(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request.http_mut().headers_mut().insert(
            "x-amz-glacier-version",
            http::HeaderValue::from_static("2012-06-01"),
        );
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetDataRetrievalPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetDataRetrievalPolicy",
            "glacier",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetDataRetrievalPolicyInput`](crate::input::SetDataRetrievalPolicyInput)
    pub fn builder() -> crate::input::set_data_retrieval_policy_input::Builder {
        crate::input::set_data_retrieval_policy_input::Builder::default()
    }
}

/// See [`SetVaultAccessPolicyInput`](crate::input::SetVaultAccessPolicyInput)
pub mod set_vault_access_policy_input {
    /// A builder for [`SetVaultAccessPolicyInput`](crate::input::SetVaultAccessPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) vault_name: std::option::Option<std::string::String>,
        pub(crate) policy: std::option::Option<crate::model::VaultAccessPolicy>,
    }
    impl Builder {
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the vault.</p>
        pub fn vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_name = Some(input.into());
            self
        }
        /// <p>The name of the vault.</p>
        pub fn set_vault_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_name = input;
            self
        }
        /// <p>The vault access policy as a JSON string.</p>
        pub fn policy(mut self, input: crate::model::VaultAccessPolicy) -> Self {
            self.policy = Some(input);
            self
        }
        /// <p>The vault access policy as a JSON string.</p>
        pub fn set_policy(
            mut self,
            input: std::option::Option<crate::model::VaultAccessPolicy>,
        ) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`SetVaultAccessPolicyInput`](crate::input::SetVaultAccessPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetVaultAccessPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetVaultAccessPolicyInput {
                account_id: self.account_id,
                vault_name: self.vault_name,
                policy: self.policy,
            })
        }
    }
}
#[doc(hidden)]
pub type SetVaultAccessPolicyInputOperationOutputAlias = crate::operation::SetVaultAccessPolicy;
#[doc(hidden)]
pub type SetVaultAccessPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SetVaultAccessPolicyInput {
    /// Consumes the builder and constructs an Operation<[`SetVaultAccessPolicy`](crate::operation::SetVaultAccessPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetVaultAccessPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetVaultAccessPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_81 = &_input.account_id;
            let input_81 =
                input_81
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_81, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_82 = &_input.vault_name;
            let input_82 =
                input_82
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let vault_name = aws_smithy_http::label::fmt_string(input_82, false);
            if vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "vault_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/{accountId}/vaults/{vaultName}/access-policy",
                accountId = account_id,
                vaultName = vault_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetVaultAccessPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetVaultAccessPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.account_id.as_deref().unwrap_or_default().is_empty() {
            self.account_id = Some("-".to_owned());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::ser_payload_set_vault_access_policy_input(&self.policy)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request.http_mut().headers_mut().insert(
            "x-amz-glacier-version",
            http::HeaderValue::from_static("2012-06-01"),
        );
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetVaultAccessPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetVaultAccessPolicy",
            "glacier",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetVaultAccessPolicyInput`](crate::input::SetVaultAccessPolicyInput)
    pub fn builder() -> crate::input::set_vault_access_policy_input::Builder {
        crate::input::set_vault_access_policy_input::Builder::default()
    }
}

/// See [`SetVaultNotificationsInput`](crate::input::SetVaultNotificationsInput)
pub mod set_vault_notifications_input {
    /// A builder for [`SetVaultNotificationsInput`](crate::input::SetVaultNotificationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) vault_name: std::option::Option<std::string::String>,
        pub(crate) vault_notification_config:
            std::option::Option<crate::model::VaultNotificationConfig>,
    }
    impl Builder {
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the vault.</p>
        pub fn vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_name = Some(input.into());
            self
        }
        /// <p>The name of the vault.</p>
        pub fn set_vault_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_name = input;
            self
        }
        /// <p>Provides options for specifying notification configuration.</p>
        pub fn vault_notification_config(
            mut self,
            input: crate::model::VaultNotificationConfig,
        ) -> Self {
            self.vault_notification_config = Some(input);
            self
        }
        /// <p>Provides options for specifying notification configuration.</p>
        pub fn set_vault_notification_config(
            mut self,
            input: std::option::Option<crate::model::VaultNotificationConfig>,
        ) -> Self {
            self.vault_notification_config = input;
            self
        }
        /// Consumes the builder and constructs a [`SetVaultNotificationsInput`](crate::input::SetVaultNotificationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetVaultNotificationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetVaultNotificationsInput {
                account_id: self.account_id,
                vault_name: self.vault_name,
                vault_notification_config: self.vault_notification_config,
            })
        }
    }
}
#[doc(hidden)]
pub type SetVaultNotificationsInputOperationOutputAlias = crate::operation::SetVaultNotifications;
#[doc(hidden)]
pub type SetVaultNotificationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SetVaultNotificationsInput {
    /// Consumes the builder and constructs an Operation<[`SetVaultNotifications`](crate::operation::SetVaultNotifications)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetVaultNotifications,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetVaultNotificationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_83 = &_input.account_id;
            let input_83 =
                input_83
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_83, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_84 = &_input.vault_name;
            let input_84 =
                input_84
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let vault_name = aws_smithy_http::label::fmt_string(input_84, false);
            if vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "vault_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/{accountId}/vaults/{vaultName}/notification-configuration",
                accountId = account_id,
                vaultName = vault_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetVaultNotificationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetVaultNotificationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.account_id.as_deref().unwrap_or_default().is_empty() {
            self.account_id = Some("-".to_owned());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::ser_payload_set_vault_notifications_input(
            &self.vault_notification_config,
        )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request.http_mut().headers_mut().insert(
            "x-amz-glacier-version",
            http::HeaderValue::from_static("2012-06-01"),
        );
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetVaultNotifications::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetVaultNotifications",
            "glacier",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetVaultNotificationsInput`](crate::input::SetVaultNotificationsInput)
    pub fn builder() -> crate::input::set_vault_notifications_input::Builder {
        crate::input::set_vault_notifications_input::Builder::default()
    }
}

/// See [`UploadArchiveInput`](crate::input::UploadArchiveInput)
pub mod upload_archive_input {
    /// A builder for [`UploadArchiveInput`](crate::input::UploadArchiveInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vault_name: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) archive_description: std::option::Option<std::string::String>,
        pub(crate) checksum: std::option::Option<std::string::String>,
        pub(crate) body: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
    }
    impl Builder {
        /// <p>The name of the vault.</p>
        pub fn vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_name = Some(input.into());
            self
        }
        /// <p>The name of the vault.</p>
        pub fn set_vault_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_name = input;
            self
        }
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID. </p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID. </p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The optional description of the archive you are uploading.</p>
        pub fn archive_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.archive_description = Some(input.into());
            self
        }
        /// <p>The optional description of the archive you are uploading.</p>
        pub fn set_archive_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.archive_description = input;
            self
        }
        /// <p>The SHA256 tree hash of the data being uploaded.</p>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.checksum = Some(input.into());
            self
        }
        /// <p>The SHA256 tree hash of the data being uploaded.</p>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.checksum = input;
            self
        }
        /// <p>The data to upload.</p>
        pub fn body(mut self, input: aws_smithy_http::byte_stream::ByteStream) -> Self {
            self.body = Some(input);
            self
        }
        /// <p>The data to upload.</p>
        pub fn set_body(
            mut self,
            input: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        ) -> Self {
            self.body = input;
            self
        }
        /// Consumes the builder and constructs a [`UploadArchiveInput`](crate::input::UploadArchiveInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UploadArchiveInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UploadArchiveInput {
                vault_name: self.vault_name,
                account_id: self.account_id,
                archive_description: self.archive_description,
                checksum: self.checksum,
                body: self.body.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type UploadArchiveInputOperationOutputAlias = crate::operation::UploadArchive;
#[doc(hidden)]
pub type UploadArchiveInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UploadArchiveInput {
    /// Consumes the builder and constructs an Operation<[`UploadArchive`](crate::operation::UploadArchive)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UploadArchive,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UploadArchiveInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_85 = &_input.account_id;
            let input_85 =
                input_85
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_85, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_86 = &_input.vault_name;
            let input_86 =
                input_86
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let vault_name = aws_smithy_http::label::fmt_string(input_86, false);
            if vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "vault_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/{accountId}/vaults/{vaultName}/archives",
                accountId = account_id,
                vaultName = vault_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::UploadArchiveInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_87) = &_input.archive_description {
                let formatted_88 = AsRef::<str>::as_ref(inner_87);
                if !formatted_88.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_88;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "archive_description",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-archive-description", header_value);
                }
            }
            if let Some(inner_89) = &_input.checksum {
                let formatted_90 = AsRef::<str>::as_ref(inner_89);
                if !formatted_90.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_90;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "checksum",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-sha256-tree-hash", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UploadArchiveInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UploadArchiveInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/octet-stream",
            );
            Ok(builder)
        }
        if self.account_id.as_deref().unwrap_or_default().is_empty() {
            self.account_id = Some("-".to_owned());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::ser_payload_upload_archive_input(self.body)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request.http_mut().headers_mut().insert(
            "x-amz-glacier-version",
            http::HeaderValue::from_static("2012-06-01"),
        );
        crate::glacier_checksums::add_checksum_treehash(&mut request)
            .await
            .map_err(|e| aws_smithy_http::operation::BuildError::Other(e.into()))?;
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UploadArchive::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UploadArchive",
            "glacier",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UploadArchiveInput`](crate::input::UploadArchiveInput)
    pub fn builder() -> crate::input::upload_archive_input::Builder {
        crate::input::upload_archive_input::Builder::default()
    }
}

/// See [`UploadMultipartPartInput`](crate::input::UploadMultipartPartInput)
pub mod upload_multipart_part_input {
    /// A builder for [`UploadMultipartPartInput`](crate::input::UploadMultipartPartInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) vault_name: std::option::Option<std::string::String>,
        pub(crate) upload_id: std::option::Option<std::string::String>,
        pub(crate) checksum: std::option::Option<std::string::String>,
        pub(crate) range: std::option::Option<std::string::String>,
        pub(crate) body: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
    }
    impl Builder {
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID. </p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
        /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
        /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
        /// credentials used to sign the request. If you use an account ID, do not include any hyphens
        /// ('-') in the ID. </p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the vault.</p>
        pub fn vault_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vault_name = Some(input.into());
            self
        }
        /// <p>The name of the vault.</p>
        pub fn set_vault_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vault_name = input;
            self
        }
        /// <p>The upload ID of the multipart upload.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id = Some(input.into());
            self
        }
        /// <p>The upload ID of the multipart upload.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upload_id = input;
            self
        }
        /// <p>The SHA256 tree hash of the data being uploaded.</p>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.checksum = Some(input.into());
            self
        }
        /// <p>The SHA256 tree hash of the data being uploaded.</p>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.checksum = input;
            self
        }
        /// <p>Identifies the range of bytes in the assembled archive that will be uploaded in this
        /// part. Amazon S3 Glacier uses this information to assemble the archive in the proper sequence.
        /// The format of this header follows RFC 2616. An example header is Content-Range:bytes
        /// 0-4194303/*.</p>
        pub fn range(mut self, input: impl Into<std::string::String>) -> Self {
            self.range = Some(input.into());
            self
        }
        /// <p>Identifies the range of bytes in the assembled archive that will be uploaded in this
        /// part. Amazon S3 Glacier uses this information to assemble the archive in the proper sequence.
        /// The format of this header follows RFC 2616. An example header is Content-Range:bytes
        /// 0-4194303/*.</p>
        pub fn set_range(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.range = input;
            self
        }
        /// <p>The data to upload.</p>
        pub fn body(mut self, input: aws_smithy_http::byte_stream::ByteStream) -> Self {
            self.body = Some(input);
            self
        }
        /// <p>The data to upload.</p>
        pub fn set_body(
            mut self,
            input: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        ) -> Self {
            self.body = input;
            self
        }
        /// Consumes the builder and constructs a [`UploadMultipartPartInput`](crate::input::UploadMultipartPartInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UploadMultipartPartInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UploadMultipartPartInput {
                account_id: self.account_id,
                vault_name: self.vault_name,
                upload_id: self.upload_id,
                checksum: self.checksum,
                range: self.range,
                body: self.body.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type UploadMultipartPartInputOperationOutputAlias = crate::operation::UploadMultipartPart;
#[doc(hidden)]
pub type UploadMultipartPartInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UploadMultipartPartInput {
    /// Consumes the builder and constructs an Operation<[`UploadMultipartPart`](crate::operation::UploadMultipartPart)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UploadMultipartPart,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UploadMultipartPartInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_91 = &_input.account_id;
            let input_91 =
                input_91
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "account_id",
                        details: "cannot be empty or unset",
                    })?;
            let account_id = aws_smithy_http::label::fmt_string(input_91, false);
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_92 = &_input.vault_name;
            let input_92 =
                input_92
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vault_name",
                        details: "cannot be empty or unset",
                    })?;
            let vault_name = aws_smithy_http::label::fmt_string(input_92, false);
            if vault_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "vault_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_93 = &_input.upload_id;
            let input_93 =
                input_93
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "upload_id",
                        details: "cannot be empty or unset",
                    })?;
            let upload_id = aws_smithy_http::label::fmt_string(input_93, false);
            if upload_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "upload_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}",
                accountId = account_id,
                vaultName = vault_name,
                uploadId = upload_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::UploadMultipartPartInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_94) = &_input.checksum {
                let formatted_95 = AsRef::<str>::as_ref(inner_94);
                if !formatted_95.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_95;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "checksum",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-sha256-tree-hash", header_value);
                }
            }
            if let Some(inner_96) = &_input.range {
                let formatted_97 = AsRef::<str>::as_ref(inner_96);
                if !formatted_97.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_97;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "range",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("Content-Range", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UploadMultipartPartInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UploadMultipartPartInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/octet-stream",
            );
            Ok(builder)
        }
        if self.account_id.as_deref().unwrap_or_default().is_empty() {
            self.account_id = Some("-".to_owned());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::ser_payload_upload_multipart_part_input(self.body)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        request.http_mut().headers_mut().insert(
            "x-amz-glacier-version",
            http::HeaderValue::from_static("2012-06-01"),
        );
        crate::glacier_checksums::add_checksum_treehash(&mut request)
            .await
            .map_err(|e| aws_smithy_http::operation::BuildError::Other(e.into()))?;
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UploadMultipartPart::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UploadMultipartPart",
            "glacier",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UploadMultipartPartInput`](crate::input::UploadMultipartPartInput)
    pub fn builder() -> crate::input::upload_multipart_part_input::Builder {
        crate::input::upload_multipart_part_input::Builder::default()
    }
}

/// <p>Provides options to upload a part of an archive in a multipart upload
/// operation.</p>
#[non_exhaustive]
pub struct UploadMultipartPartInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID. </p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the vault.</p>
    pub vault_name: std::option::Option<std::string::String>,
    /// <p>The upload ID of the multipart upload.</p>
    pub upload_id: std::option::Option<std::string::String>,
    /// <p>The SHA256 tree hash of the data being uploaded.</p>
    pub checksum: std::option::Option<std::string::String>,
    /// <p>Identifies the range of bytes in the assembled archive that will be uploaded in this
    /// part. Amazon S3 Glacier uses this information to assemble the archive in the proper sequence.
    /// The format of this header follows RFC 2616. An example header is Content-Range:bytes
    /// 0-4194303/*.</p>
    pub range: std::option::Option<std::string::String>,
    /// <p>The data to upload.</p>
    pub body: aws_smithy_http::byte_stream::ByteStream,
}
impl UploadMultipartPartInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID. </p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the vault.</p>
    pub fn vault_name(&self) -> std::option::Option<&str> {
        self.vault_name.as_deref()
    }
    /// <p>The upload ID of the multipart upload.</p>
    pub fn upload_id(&self) -> std::option::Option<&str> {
        self.upload_id.as_deref()
    }
    /// <p>The SHA256 tree hash of the data being uploaded.</p>
    pub fn checksum(&self) -> std::option::Option<&str> {
        self.checksum.as_deref()
    }
    /// <p>Identifies the range of bytes in the assembled archive that will be uploaded in this
    /// part. Amazon S3 Glacier uses this information to assemble the archive in the proper sequence.
    /// The format of this header follows RFC 2616. An example header is Content-Range:bytes
    /// 0-4194303/*.</p>
    pub fn range(&self) -> std::option::Option<&str> {
        self.range.as_deref()
    }
    /// <p>The data to upload.</p>
    pub fn body(&self) -> &aws_smithy_http::byte_stream::ByteStream {
        &self.body
    }
}
impl std::fmt::Debug for UploadMultipartPartInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UploadMultipartPartInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("vault_name", &self.vault_name);
        formatter.field("upload_id", &self.upload_id);
        formatter.field("checksum", &self.checksum);
        formatter.field("range", &self.range);
        formatter.field("body", &self.body);
        formatter.finish()
    }
}

/// <p>Provides options to add an archive to a vault.</p>
#[non_exhaustive]
pub struct UploadArchiveInput {
    /// <p>The name of the vault.</p>
    pub vault_name: std::option::Option<std::string::String>,
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID. </p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The optional description of the archive you are uploading.</p>
    pub archive_description: std::option::Option<std::string::String>,
    /// <p>The SHA256 tree hash of the data being uploaded.</p>
    pub checksum: std::option::Option<std::string::String>,
    /// <p>The data to upload.</p>
    pub body: aws_smithy_http::byte_stream::ByteStream,
}
impl UploadArchiveInput {
    /// <p>The name of the vault.</p>
    pub fn vault_name(&self) -> std::option::Option<&str> {
        self.vault_name.as_deref()
    }
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID. </p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The optional description of the archive you are uploading.</p>
    pub fn archive_description(&self) -> std::option::Option<&str> {
        self.archive_description.as_deref()
    }
    /// <p>The SHA256 tree hash of the data being uploaded.</p>
    pub fn checksum(&self) -> std::option::Option<&str> {
        self.checksum.as_deref()
    }
    /// <p>The data to upload.</p>
    pub fn body(&self) -> &aws_smithy_http::byte_stream::ByteStream {
        &self.body
    }
}
impl std::fmt::Debug for UploadArchiveInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UploadArchiveInput");
        formatter.field("vault_name", &self.vault_name);
        formatter.field("account_id", &self.account_id);
        formatter.field("archive_description", &self.archive_description);
        formatter.field("checksum", &self.checksum);
        formatter.field("body", &self.body);
        formatter.finish()
    }
}

/// <p>Provides options to configure notifications that will be sent when specific events
/// happen to a vault.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetVaultNotificationsInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the vault.</p>
    pub vault_name: std::option::Option<std::string::String>,
    /// <p>Provides options for specifying notification configuration.</p>
    pub vault_notification_config: std::option::Option<crate::model::VaultNotificationConfig>,
}
impl SetVaultNotificationsInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the vault.</p>
    pub fn vault_name(&self) -> std::option::Option<&str> {
        self.vault_name.as_deref()
    }
    /// <p>Provides options for specifying notification configuration.</p>
    pub fn vault_notification_config(
        &self,
    ) -> std::option::Option<&crate::model::VaultNotificationConfig> {
        self.vault_notification_config.as_ref()
    }
}
impl std::fmt::Debug for SetVaultNotificationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetVaultNotificationsInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("vault_name", &self.vault_name);
        formatter.field("vault_notification_config", &self.vault_notification_config);
        formatter.finish()
    }
}

/// <p>SetVaultAccessPolicy input.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetVaultAccessPolicyInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the vault.</p>
    pub vault_name: std::option::Option<std::string::String>,
    /// <p>The vault access policy as a JSON string.</p>
    pub policy: std::option::Option<crate::model::VaultAccessPolicy>,
}
impl SetVaultAccessPolicyInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the vault.</p>
    pub fn vault_name(&self) -> std::option::Option<&str> {
        self.vault_name.as_deref()
    }
    /// <p>The vault access policy as a JSON string.</p>
    pub fn policy(&self) -> std::option::Option<&crate::model::VaultAccessPolicy> {
        self.policy.as_ref()
    }
}
impl std::fmt::Debug for SetVaultAccessPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetVaultAccessPolicyInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("vault_name", &self.vault_name);
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}

/// <p>SetDataRetrievalPolicy input.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetDataRetrievalPolicyInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS
    /// account ID associated with the credentials used to sign the request. You can either specify
    /// an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon
    /// Glacier uses the AWS account ID associated with the credentials used to sign the request.
    /// If you specify your account ID, do not include any hyphens ('-') in the ID.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The data retrieval policy in JSON format.</p>
    pub policy: std::option::Option<crate::model::DataRetrievalPolicy>,
}
impl SetDataRetrievalPolicyInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS
    /// account ID associated with the credentials used to sign the request. You can either specify
    /// an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon
    /// Glacier uses the AWS account ID associated with the credentials used to sign the request.
    /// If you specify your account ID, do not include any hyphens ('-') in the ID.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The data retrieval policy in JSON format.</p>
    pub fn policy(&self) -> std::option::Option<&crate::model::DataRetrievalPolicy> {
        self.policy.as_ref()
    }
}
impl std::fmt::Debug for SetDataRetrievalPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetDataRetrievalPolicyInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}

/// <p>The input value for <code>RemoveTagsFromVaultInput</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTagsFromVaultInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the vault.</p>
    pub vault_name: std::option::Option<std::string::String>,
    /// <p>A list of tag keys. Each corresponding tag is removed from the vault.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl RemoveTagsFromVaultInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the vault.</p>
    pub fn vault_name(&self) -> std::option::Option<&str> {
        self.vault_name.as_deref()
    }
    /// <p>A list of tag keys. Each corresponding tag is removed from the vault.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for RemoveTagsFromVaultInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTagsFromVaultInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("vault_name", &self.vault_name);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PurchaseProvisionedCapacityInput {
    /// <p>The AWS account ID of the account that owns the vault. You can either specify an AWS
    /// account ID or optionally a single '-' (hyphen), in which case Amazon S3 Glacier uses the AWS
    /// account ID associated with the credentials used to sign the request. If you use an account
    /// ID, don't include any hyphens ('-') in the ID. </p>
    pub account_id: std::option::Option<std::string::String>,
}
impl PurchaseProvisionedCapacityInput {
    /// <p>The AWS account ID of the account that owns the vault. You can either specify an AWS
    /// account ID or optionally a single '-' (hyphen), in which case Amazon S3 Glacier uses the AWS
    /// account ID associated with the credentials used to sign the request. If you use an account
    /// ID, don't include any hyphens ('-') in the ID. </p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
}
impl std::fmt::Debug for PurchaseProvisionedCapacityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PurchaseProvisionedCapacityInput");
        formatter.field("account_id", &self.account_id);
        formatter.finish()
    }
}

/// <p>Provides options to retrieve the vault list owned by the calling user's account. The
/// list provides metadata information for each vault.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListVaultsInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS
    /// account ID associated with the credentials used to sign the request. You can either specify
    /// an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon
    /// Glacier uses the AWS account ID associated with the credentials used to sign the request.
    /// If you specify your account ID, do not include any hyphens ('-') in the ID.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>A string used for pagination. The marker specifies the vault ARN after which the
    /// listing of vaults should begin.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of vaults to be returned. The default limit is 10. The number of
    /// vaults returned might be fewer than the specified limit, but the number of returned vaults
    /// never exceeds the limit.</p>
    pub limit: std::option::Option<i32>,
}
impl ListVaultsInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS
    /// account ID associated with the credentials used to sign the request. You can either specify
    /// an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon
    /// Glacier uses the AWS account ID associated with the credentials used to sign the request.
    /// If you specify your account ID, do not include any hyphens ('-') in the ID.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>A string used for pagination. The marker specifies the vault ARN after which the
    /// listing of vaults should begin.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of vaults to be returned. The default limit is 10. The number of
    /// vaults returned might be fewer than the specified limit, but the number of returned vaults
    /// never exceeds the limit.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for ListVaultsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListVaultsInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("marker", &self.marker);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

/// <p>The input value for <code>ListTagsForVaultInput</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForVaultInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the vault.</p>
    pub vault_name: std::option::Option<std::string::String>,
}
impl ListTagsForVaultInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the vault.</p>
    pub fn vault_name(&self) -> std::option::Option<&str> {
        self.vault_name.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForVaultInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForVaultInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("vault_name", &self.vault_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProvisionedCapacityInput {
    /// <p>The AWS account ID of the account that owns the vault. You can either specify an AWS
    /// account ID or optionally a single '-' (hyphen), in which case Amazon S3 Glacier uses the AWS
    /// account ID associated with the credentials used to sign the request. If you use an account
    /// ID, don't include any hyphens ('-') in the ID. </p>
    pub account_id: std::option::Option<std::string::String>,
}
impl ListProvisionedCapacityInput {
    /// <p>The AWS account ID of the account that owns the vault. You can either specify an AWS
    /// account ID or optionally a single '-' (hyphen), in which case Amazon S3 Glacier uses the AWS
    /// account ID associated with the credentials used to sign the request. If you use an account
    /// ID, don't include any hyphens ('-') in the ID. </p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
}
impl std::fmt::Debug for ListProvisionedCapacityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProvisionedCapacityInput");
        formatter.field("account_id", &self.account_id);
        formatter.finish()
    }
}

/// <p>Provides options for retrieving a list of parts of an archive that have been uploaded
/// in a specific multipart upload.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPartsInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID. </p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the vault.</p>
    pub vault_name: std::option::Option<std::string::String>,
    /// <p>The upload ID of the multipart upload.</p>
    pub upload_id: std::option::Option<std::string::String>,
    /// <p>An opaque string used for pagination. This value specifies the part at which the
    /// listing of parts should begin. Get the marker value from the response of a previous List
    /// Parts response. You need only include the marker if you are continuing the pagination of
    /// results started in a previous List Parts request.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of parts to be returned. The default limit is 50. The number of
    /// parts returned might be fewer than the specified limit, but the number of returned parts
    /// never exceeds the limit.</p>
    pub limit: std::option::Option<i32>,
}
impl ListPartsInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID. </p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the vault.</p>
    pub fn vault_name(&self) -> std::option::Option<&str> {
        self.vault_name.as_deref()
    }
    /// <p>The upload ID of the multipart upload.</p>
    pub fn upload_id(&self) -> std::option::Option<&str> {
        self.upload_id.as_deref()
    }
    /// <p>An opaque string used for pagination. This value specifies the part at which the
    /// listing of parts should begin. Get the marker value from the response of a previous List
    /// Parts response. You need only include the marker if you are continuing the pagination of
    /// results started in a previous List Parts request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of parts to be returned. The default limit is 50. The number of
    /// parts returned might be fewer than the specified limit, but the number of returned parts
    /// never exceeds the limit.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for ListPartsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPartsInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("vault_name", &self.vault_name);
        formatter.field("upload_id", &self.upload_id);
        formatter.field("marker", &self.marker);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

/// <p>Provides options for retrieving list of in-progress multipart uploads for an Amazon
/// Glacier vault.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMultipartUploadsInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID. </p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the vault.</p>
    pub vault_name: std::option::Option<std::string::String>,
    /// <p>Specifies the maximum number of uploads returned in the response body. If this value
    /// is not specified, the List Uploads operation returns up to 50 uploads.</p>
    pub limit: std::option::Option<i32>,
    /// <p>An opaque string used for pagination. This value specifies the upload at which the
    /// listing of uploads should begin. Get the marker value from a previous List Uploads
    /// response. You need only include the marker if you are continuing the pagination of results
    /// started in a previous List Uploads request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListMultipartUploadsInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID. </p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the vault.</p>
    pub fn vault_name(&self) -> std::option::Option<&str> {
        self.vault_name.as_deref()
    }
    /// <p>Specifies the maximum number of uploads returned in the response body. If this value
    /// is not specified, the List Uploads operation returns up to 50 uploads.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
    /// <p>An opaque string used for pagination. This value specifies the upload at which the
    /// listing of uploads should begin. Get the marker value from a previous List Uploads
    /// response. You need only include the marker if you are continuing the pagination of results
    /// started in a previous List Uploads request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListMultipartUploadsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMultipartUploadsInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("vault_name", &self.vault_name);
        formatter.field("limit", &self.limit);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p>Provides options for retrieving a job list for an Amazon S3 Glacier vault.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListJobsInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID. </p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the vault.</p>
    pub vault_name: std::option::Option<std::string::String>,
    /// <p>The maximum number of jobs to be returned. The default limit is 50. The number of
    /// jobs returned might be fewer than the specified limit, but the number of returned jobs
    /// never exceeds the limit.</p>
    pub limit: std::option::Option<i32>,
    /// <p>An opaque string used for pagination. This value specifies the job at which the
    /// listing of jobs should begin. Get the marker value from a previous List Jobs response. You
    /// only need to include the marker if you are continuing the pagination of results started in
    /// a previous List Jobs request.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The type of job status to return. You can specify the following values:
    /// <code>InProgress</code>, <code>Succeeded</code>, or <code>Failed</code>.</p>
    pub statuscode: std::option::Option<std::string::String>,
    /// <p>The state of the jobs to return. You can specify <code>true</code> or
    /// <code>false</code>.</p>
    pub completed: std::option::Option<std::string::String>,
}
impl ListJobsInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID. </p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the vault.</p>
    pub fn vault_name(&self) -> std::option::Option<&str> {
        self.vault_name.as_deref()
    }
    /// <p>The maximum number of jobs to be returned. The default limit is 50. The number of
    /// jobs returned might be fewer than the specified limit, but the number of returned jobs
    /// never exceeds the limit.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
    /// <p>An opaque string used for pagination. This value specifies the job at which the
    /// listing of jobs should begin. Get the marker value from a previous List Jobs response. You
    /// only need to include the marker if you are continuing the pagination of results started in
    /// a previous List Jobs request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The type of job status to return. You can specify the following values:
    /// <code>InProgress</code>, <code>Succeeded</code>, or <code>Failed</code>.</p>
    pub fn statuscode(&self) -> std::option::Option<&str> {
        self.statuscode.as_deref()
    }
    /// <p>The state of the jobs to return. You can specify <code>true</code> or
    /// <code>false</code>.</p>
    pub fn completed(&self) -> std::option::Option<&str> {
        self.completed.as_deref()
    }
}
impl std::fmt::Debug for ListJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListJobsInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("vault_name", &self.vault_name);
        formatter.field("limit", &self.limit);
        formatter.field("marker", &self.marker);
        formatter.field("statuscode", &self.statuscode);
        formatter.field("completed", &self.completed);
        formatter.finish()
    }
}

/// <p>The input values for <code>InitiateVaultLock</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InitiateVaultLockInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS
    /// account ID associated with the credentials used to sign the request. You can either specify
    /// an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon
    /// Glacier uses the AWS account ID associated with the credentials used to sign the request.
    /// If you specify your account ID, do not include any hyphens ('-') in the ID.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the vault.</p>
    pub vault_name: std::option::Option<std::string::String>,
    /// <p>The vault lock policy as a JSON string, which uses "\" as an escape
    /// character.</p>
    pub policy: std::option::Option<crate::model::VaultLockPolicy>,
}
impl InitiateVaultLockInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS
    /// account ID associated with the credentials used to sign the request. You can either specify
    /// an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon
    /// Glacier uses the AWS account ID associated with the credentials used to sign the request.
    /// If you specify your account ID, do not include any hyphens ('-') in the ID.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the vault.</p>
    pub fn vault_name(&self) -> std::option::Option<&str> {
        self.vault_name.as_deref()
    }
    /// <p>The vault lock policy as a JSON string, which uses "\" as an escape
    /// character.</p>
    pub fn policy(&self) -> std::option::Option<&crate::model::VaultLockPolicy> {
        self.policy.as_ref()
    }
}
impl std::fmt::Debug for InitiateVaultLockInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InitiateVaultLockInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("vault_name", &self.vault_name);
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}

/// <p>Provides options for initiating a multipart upload to an Amazon S3 Glacier
/// vault.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InitiateMultipartUploadInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID. </p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the vault.</p>
    pub vault_name: std::option::Option<std::string::String>,
    /// <p>The archive description that you are uploading in parts.</p>
    /// <p>The part size must be a megabyte (1024 KB) multiplied by a power of 2, for example
    /// 1048576 (1 MB), 2097152 (2 MB), 4194304 (4 MB), 8388608 (8 MB), and so on. The minimum
    /// allowable part size is 1 MB, and the maximum is 4 GB (4096 MB).</p>
    pub archive_description: std::option::Option<std::string::String>,
    /// <p>The size of each part except the last, in bytes. The last part can be smaller than
    /// this part size.</p>
    pub part_size: std::option::Option<std::string::String>,
}
impl InitiateMultipartUploadInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID. </p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the vault.</p>
    pub fn vault_name(&self) -> std::option::Option<&str> {
        self.vault_name.as_deref()
    }
    /// <p>The archive description that you are uploading in parts.</p>
    /// <p>The part size must be a megabyte (1024 KB) multiplied by a power of 2, for example
    /// 1048576 (1 MB), 2097152 (2 MB), 4194304 (4 MB), 8388608 (8 MB), and so on. The minimum
    /// allowable part size is 1 MB, and the maximum is 4 GB (4096 MB).</p>
    pub fn archive_description(&self) -> std::option::Option<&str> {
        self.archive_description.as_deref()
    }
    /// <p>The size of each part except the last, in bytes. The last part can be smaller than
    /// this part size.</p>
    pub fn part_size(&self) -> std::option::Option<&str> {
        self.part_size.as_deref()
    }
}
impl std::fmt::Debug for InitiateMultipartUploadInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InitiateMultipartUploadInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("vault_name", &self.vault_name);
        formatter.field("archive_description", &self.archive_description);
        formatter.field("part_size", &self.part_size);
        formatter.finish()
    }
}

/// <p>Provides options for initiating an Amazon S3 Glacier job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InitiateJobInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the vault.</p>
    pub vault_name: std::option::Option<std::string::String>,
    /// <p>Provides options for specifying job information.</p>
    pub job_parameters: std::option::Option<crate::model::JobParameters>,
}
impl InitiateJobInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the vault.</p>
    pub fn vault_name(&self) -> std::option::Option<&str> {
        self.vault_name.as_deref()
    }
    /// <p>Provides options for specifying job information.</p>
    pub fn job_parameters(&self) -> std::option::Option<&crate::model::JobParameters> {
        self.job_parameters.as_ref()
    }
}
impl std::fmt::Debug for InitiateJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InitiateJobInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("vault_name", &self.vault_name);
        formatter.field("job_parameters", &self.job_parameters);
        formatter.finish()
    }
}

/// <p>Provides options for retrieving the notification configuration set on an Amazon
/// Glacier vault.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetVaultNotificationsInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the vault.</p>
    pub vault_name: std::option::Option<std::string::String>,
}
impl GetVaultNotificationsInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the vault.</p>
    pub fn vault_name(&self) -> std::option::Option<&str> {
        self.vault_name.as_deref()
    }
}
impl std::fmt::Debug for GetVaultNotificationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetVaultNotificationsInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("vault_name", &self.vault_name);
        formatter.finish()
    }
}

/// <p>The input values for <code>GetVaultLock</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetVaultLockInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the vault.</p>
    pub vault_name: std::option::Option<std::string::String>,
}
impl GetVaultLockInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the vault.</p>
    pub fn vault_name(&self) -> std::option::Option<&str> {
        self.vault_name.as_deref()
    }
}
impl std::fmt::Debug for GetVaultLockInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetVaultLockInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("vault_name", &self.vault_name);
        formatter.finish()
    }
}

/// <p>Input for GetVaultAccessPolicy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetVaultAccessPolicyInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the vault.</p>
    pub vault_name: std::option::Option<std::string::String>,
}
impl GetVaultAccessPolicyInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the vault.</p>
    pub fn vault_name(&self) -> std::option::Option<&str> {
        self.vault_name.as_deref()
    }
}
impl std::fmt::Debug for GetVaultAccessPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetVaultAccessPolicyInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("vault_name", &self.vault_name);
        formatter.finish()
    }
}

/// <p>Provides options for downloading output of an Amazon S3 Glacier job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetJobOutputInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the vault.</p>
    pub vault_name: std::option::Option<std::string::String>,
    /// <p>The job ID whose data is downloaded.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The range of bytes to retrieve from the output. For example, if you want to download
    /// the first 1,048,576 bytes, specify the range as <code>bytes=0-1048575</code>. By default, this operation
    /// downloads the entire output.</p>
    ///
    /// <p>If the job output is large, then you can use a range to
    /// retrieve a portion of the output. This allows you to download the entire output in smaller
    /// chunks of bytes. For example, suppose you have 1 GB of job output you want to download and
    /// you decide to download 128 MB chunks of data at a time, which is a total of eight Get Job
    /// Output requests. You use the following process to download the job output:</p>
    ///
    /// <ol>
    /// <li>
    /// <p>Download a 128 MB chunk of output by specifying the appropriate byte range.
    /// Verify that all 128 MB of data was received.</p>
    /// </li>
    /// <li>
    /// <p>Along with the data, the response includes a SHA256 tree hash of the payload.
    /// You compute the checksum of the payload on the client and compare it with the
    /// checksum you received in the response to ensure you received all the expected
    /// data.</p>
    /// </li>
    /// <li>
    /// <p>Repeat steps 1 and 2 for all the eight 128 MB chunks of output data, each time
    /// specifying the appropriate byte range.</p>
    /// </li>
    /// <li>
    /// <p>After downloading all the parts of the job output, you have a list of eight
    /// checksum values. Compute the tree hash of these values to find the checksum of the
    /// entire output. Using the <a>DescribeJob</a> API, obtain job information of
    /// the job that provided you the output. The response includes the checksum of the
    /// entire archive stored in Amazon S3 Glacier. You compare this value with the checksum you
    /// computed to ensure you have downloaded the entire archive content with no
    /// errors.</p>
    /// <p></p>
    /// </li>
    /// </ol>
    pub range: std::option::Option<std::string::String>,
}
impl GetJobOutputInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the vault.</p>
    pub fn vault_name(&self) -> std::option::Option<&str> {
        self.vault_name.as_deref()
    }
    /// <p>The job ID whose data is downloaded.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The range of bytes to retrieve from the output. For example, if you want to download
    /// the first 1,048,576 bytes, specify the range as <code>bytes=0-1048575</code>. By default, this operation
    /// downloads the entire output.</p>
    ///
    /// <p>If the job output is large, then you can use a range to
    /// retrieve a portion of the output. This allows you to download the entire output in smaller
    /// chunks of bytes. For example, suppose you have 1 GB of job output you want to download and
    /// you decide to download 128 MB chunks of data at a time, which is a total of eight Get Job
    /// Output requests. You use the following process to download the job output:</p>
    ///
    /// <ol>
    /// <li>
    /// <p>Download a 128 MB chunk of output by specifying the appropriate byte range.
    /// Verify that all 128 MB of data was received.</p>
    /// </li>
    /// <li>
    /// <p>Along with the data, the response includes a SHA256 tree hash of the payload.
    /// You compute the checksum of the payload on the client and compare it with the
    /// checksum you received in the response to ensure you received all the expected
    /// data.</p>
    /// </li>
    /// <li>
    /// <p>Repeat steps 1 and 2 for all the eight 128 MB chunks of output data, each time
    /// specifying the appropriate byte range.</p>
    /// </li>
    /// <li>
    /// <p>After downloading all the parts of the job output, you have a list of eight
    /// checksum values. Compute the tree hash of these values to find the checksum of the
    /// entire output. Using the <a>DescribeJob</a> API, obtain job information of
    /// the job that provided you the output. The response includes the checksum of the
    /// entire archive stored in Amazon S3 Glacier. You compare this value with the checksum you
    /// computed to ensure you have downloaded the entire archive content with no
    /// errors.</p>
    /// <p></p>
    /// </li>
    /// </ol>
    pub fn range(&self) -> std::option::Option<&str> {
        self.range.as_deref()
    }
}
impl std::fmt::Debug for GetJobOutputInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetJobOutputInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("vault_name", &self.vault_name);
        formatter.field("job_id", &self.job_id);
        formatter.field("range", &self.range);
        formatter.finish()
    }
}

/// <p>Input for GetDataRetrievalPolicy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDataRetrievalPolicyInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS
    /// account ID associated with the credentials used to sign the request. You can either specify
    /// an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon
    /// Glacier uses the AWS account ID associated with the credentials used to sign the request.
    /// If you specify your account ID, do not include any hyphens ('-') in the ID. </p>
    pub account_id: std::option::Option<std::string::String>,
}
impl GetDataRetrievalPolicyInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS
    /// account ID associated with the credentials used to sign the request. You can either specify
    /// an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon
    /// Glacier uses the AWS account ID associated with the credentials used to sign the request.
    /// If you specify your account ID, do not include any hyphens ('-') in the ID. </p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
}
impl std::fmt::Debug for GetDataRetrievalPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDataRetrievalPolicyInput");
        formatter.field("account_id", &self.account_id);
        formatter.finish()
    }
}

/// <p>Provides options for retrieving metadata for a specific vault in Amazon
/// Glacier.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeVaultInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID. </p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the vault.</p>
    pub vault_name: std::option::Option<std::string::String>,
}
impl DescribeVaultInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID. </p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the vault.</p>
    pub fn vault_name(&self) -> std::option::Option<&str> {
        self.vault_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeVaultInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeVaultInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("vault_name", &self.vault_name);
        formatter.finish()
    }
}

/// <p>Provides options for retrieving a job description.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeJobInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID. </p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the vault.</p>
    pub vault_name: std::option::Option<std::string::String>,
    /// <p>The ID of the job to describe.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl DescribeJobInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID. </p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the vault.</p>
    pub fn vault_name(&self) -> std::option::Option<&str> {
        self.vault_name.as_deref()
    }
    /// <p>The ID of the job to describe.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeJobInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("vault_name", &self.vault_name);
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

/// <p>Provides options for deleting a vault notification configuration from an Amazon
/// Glacier vault.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVaultNotificationsInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID. </p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the vault.</p>
    pub vault_name: std::option::Option<std::string::String>,
}
impl DeleteVaultNotificationsInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID. </p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the vault.</p>
    pub fn vault_name(&self) -> std::option::Option<&str> {
        self.vault_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteVaultNotificationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVaultNotificationsInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("vault_name", &self.vault_name);
        formatter.finish()
    }
}

/// <p>DeleteVaultAccessPolicy input.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVaultAccessPolicyInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID. </p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the vault.</p>
    pub vault_name: std::option::Option<std::string::String>,
}
impl DeleteVaultAccessPolicyInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID. </p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the vault.</p>
    pub fn vault_name(&self) -> std::option::Option<&str> {
        self.vault_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteVaultAccessPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVaultAccessPolicyInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("vault_name", &self.vault_name);
        formatter.finish()
    }
}

/// <p>Provides options for deleting a vault from Amazon S3 Glacier.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVaultInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the vault.</p>
    pub vault_name: std::option::Option<std::string::String>,
}
impl DeleteVaultInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the vault.</p>
    pub fn vault_name(&self) -> std::option::Option<&str> {
        self.vault_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteVaultInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVaultInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("vault_name", &self.vault_name);
        formatter.finish()
    }
}

/// <p>Provides options for deleting an archive from an Amazon S3 Glacier vault.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteArchiveInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the vault.</p>
    pub vault_name: std::option::Option<std::string::String>,
    /// <p>The ID of the archive to delete.</p>
    pub archive_id: std::option::Option<std::string::String>,
}
impl DeleteArchiveInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the vault.</p>
    pub fn vault_name(&self) -> std::option::Option<&str> {
        self.vault_name.as_deref()
    }
    /// <p>The ID of the archive to delete.</p>
    pub fn archive_id(&self) -> std::option::Option<&str> {
        self.archive_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteArchiveInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteArchiveInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("vault_name", &self.vault_name);
        formatter.field("archive_id", &self.archive_id);
        formatter.finish()
    }
}

/// <p>Provides options to create a vault.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateVaultInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS
    /// account ID associated with the credentials used to sign the request. You can either specify
    /// an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon S3
    /// Glacier uses the AWS account ID associated with the credentials used to sign the request.
    /// If you specify your account ID, do not include any hyphens ('-') in the ID.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the vault.</p>
    pub vault_name: std::option::Option<std::string::String>,
}
impl CreateVaultInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS
    /// account ID associated with the credentials used to sign the request. You can either specify
    /// an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon S3
    /// Glacier uses the AWS account ID associated with the credentials used to sign the request.
    /// If you specify your account ID, do not include any hyphens ('-') in the ID.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the vault.</p>
    pub fn vault_name(&self) -> std::option::Option<&str> {
        self.vault_name.as_deref()
    }
}
impl std::fmt::Debug for CreateVaultInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateVaultInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("vault_name", &self.vault_name);
        formatter.finish()
    }
}

/// <p>The input values for <code>CompleteVaultLock</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CompleteVaultLockInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS
    /// account ID associated with the credentials used to sign the request. You can either specify
    /// an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon
    /// Glacier uses the AWS account ID associated with the credentials used to sign the request.
    /// If you specify your account ID, do not include any hyphens ('-') in the ID.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the vault.</p>
    pub vault_name: std::option::Option<std::string::String>,
    /// <p>The <code>lockId</code> value is the lock ID obtained from a <a>InitiateVaultLock</a> request.</p>
    pub lock_id: std::option::Option<std::string::String>,
}
impl CompleteVaultLockInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS
    /// account ID associated with the credentials used to sign the request. You can either specify
    /// an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon
    /// Glacier uses the AWS account ID associated with the credentials used to sign the request.
    /// If you specify your account ID, do not include any hyphens ('-') in the ID.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the vault.</p>
    pub fn vault_name(&self) -> std::option::Option<&str> {
        self.vault_name.as_deref()
    }
    /// <p>The <code>lockId</code> value is the lock ID obtained from a <a>InitiateVaultLock</a> request.</p>
    pub fn lock_id(&self) -> std::option::Option<&str> {
        self.lock_id.as_deref()
    }
}
impl std::fmt::Debug for CompleteVaultLockInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CompleteVaultLockInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("vault_name", &self.vault_name);
        formatter.field("lock_id", &self.lock_id);
        formatter.finish()
    }
}

/// <p>Provides options to complete a multipart upload operation. This informs Amazon
/// Glacier that all the archive parts have been uploaded and Amazon S3 Glacier (Glacier) can now assemble
/// the archive from the uploaded parts. After assembling and saving the archive to the vault,
/// Glacier returns the URI path of the newly created archive resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CompleteMultipartUploadInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the vault.</p>
    pub vault_name: std::option::Option<std::string::String>,
    /// <p>The upload ID of the multipart upload.</p>
    pub upload_id: std::option::Option<std::string::String>,
    /// <p>The total size, in bytes, of the entire archive. This value should be the sum of all
    /// the sizes of the individual parts that you uploaded.</p>
    pub archive_size: std::option::Option<std::string::String>,
    /// <p>The SHA256 tree hash of the entire archive. It is the tree hash of SHA256 tree hash
    /// of the individual parts. If the value you specify in the request does not match the SHA256
    /// tree hash of the final assembled archive as computed by Amazon S3 Glacier (Glacier),
    /// Glacier returns an error and the request fails.</p>
    pub checksum: std::option::Option<std::string::String>,
}
impl CompleteMultipartUploadInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the vault.</p>
    pub fn vault_name(&self) -> std::option::Option<&str> {
        self.vault_name.as_deref()
    }
    /// <p>The upload ID of the multipart upload.</p>
    pub fn upload_id(&self) -> std::option::Option<&str> {
        self.upload_id.as_deref()
    }
    /// <p>The total size, in bytes, of the entire archive. This value should be the sum of all
    /// the sizes of the individual parts that you uploaded.</p>
    pub fn archive_size(&self) -> std::option::Option<&str> {
        self.archive_size.as_deref()
    }
    /// <p>The SHA256 tree hash of the entire archive. It is the tree hash of SHA256 tree hash
    /// of the individual parts. If the value you specify in the request does not match the SHA256
    /// tree hash of the final assembled archive as computed by Amazon S3 Glacier (Glacier),
    /// Glacier returns an error and the request fails.</p>
    pub fn checksum(&self) -> std::option::Option<&str> {
        self.checksum.as_deref()
    }
}
impl std::fmt::Debug for CompleteMultipartUploadInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CompleteMultipartUploadInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("vault_name", &self.vault_name);
        formatter.field("upload_id", &self.upload_id);
        formatter.field("archive_size", &self.archive_size);
        formatter.field("checksum", &self.checksum);
        formatter.finish()
    }
}

/// <p>The input values for <code>AddTagsToVault</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddTagsToVaultInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the vault.</p>
    pub vault_name: std::option::Option<std::string::String>,
    /// <p>The tags to add to the vault. Each tag is composed of a key and a value. The value
    /// can be an empty string.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl AddTagsToVaultInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the vault.</p>
    pub fn vault_name(&self) -> std::option::Option<&str> {
        self.vault_name.as_deref()
    }
    /// <p>The tags to add to the vault. Each tag is composed of a key and a value. The value
    /// can be an empty string.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for AddTagsToVaultInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddTagsToVaultInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("vault_name", &self.vault_name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>The input values for <code>AbortVaultLock</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AbortVaultLockInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS
    /// account ID associated with the credentials used to sign the request. You can either specify
    /// an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon
    /// Glacier uses the AWS account ID associated with the credentials used to sign the request.
    /// If you specify your account ID, do not include any hyphens ('-') in the ID.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the vault.</p>
    pub vault_name: std::option::Option<std::string::String>,
}
impl AbortVaultLockInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS
    /// account ID associated with the credentials used to sign the request. You can either specify
    /// an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon
    /// Glacier uses the AWS account ID associated with the credentials used to sign the request.
    /// If you specify your account ID, do not include any hyphens ('-') in the ID.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the vault.</p>
    pub fn vault_name(&self) -> std::option::Option<&str> {
        self.vault_name.as_deref()
    }
}
impl std::fmt::Debug for AbortVaultLockInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AbortVaultLockInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("vault_name", &self.vault_name);
        formatter.finish()
    }
}

/// <p>Provides options to abort a multipart upload identified by the upload ID.</p>
///
/// <p>For information about the underlying REST API, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-abort-upload.html">Abort Multipart
/// Upload</a>. For conceptual information, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html">Working with Archives in
/// Amazon S3 Glacier</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AbortMultipartUploadInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the vault.</p>
    pub vault_name: std::option::Option<std::string::String>,
    /// <p>The upload ID of the multipart upload to delete.</p>
    pub upload_id: std::option::Option<std::string::String>,
}
impl AbortMultipartUploadInput {
    /// <p>The <code>AccountId</code> value is the AWS account ID of the account that owns the
    /// vault. You can either specify an AWS account ID or optionally a single '<code>-</code>'
    /// (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the
    /// credentials used to sign the request. If you use an account ID, do not include any hyphens
    /// ('-') in the ID.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the vault.</p>
    pub fn vault_name(&self) -> std::option::Option<&str> {
        self.vault_name.as_deref()
    }
    /// <p>The upload ID of the multipart upload to delete.</p>
    pub fn upload_id(&self) -> std::option::Option<&str> {
        self.upload_id.as_deref()
    }
}
impl std::fmt::Debug for AbortMultipartUploadInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AbortMultipartUploadInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("vault_name", &self.vault_name);
        formatter.field("upload_id", &self.upload_id);
        formatter.finish()
    }
}
