// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AbortMultipartUpload`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`abort_multipart_upload`](crate::client::Client::abort_multipart_upload).
///
/// See [`crate::client::fluent_builders::AbortMultipartUpload`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AbortMultipartUpload {
    _private: (),
}
impl AbortMultipartUpload {
    /// Creates a new builder-style object to manufacture [`AbortMultipartUploadInput`](crate::input::AbortMultipartUploadInput)
    pub fn builder() -> crate::input::abort_multipart_upload_input::Builder {
        crate::input::abort_multipart_upload_input::Builder::default()
    }
    /// Creates a new `AbortMultipartUpload` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AbortMultipartUpload {
    type Output = std::result::Result<
        crate::output::AbortMultipartUploadOutput,
        crate::error::AbortMultipartUploadError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_abort_multipart_upload_error(response)
        } else {
            crate::operation_deser::parse_abort_multipart_upload_response(response)
        }
    }
}

/// Operation shape for `AbortVaultLock`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`abort_vault_lock`](crate::client::Client::abort_vault_lock).
///
/// See [`crate::client::fluent_builders::AbortVaultLock`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AbortVaultLock {
    _private: (),
}
impl AbortVaultLock {
    /// Creates a new builder-style object to manufacture [`AbortVaultLockInput`](crate::input::AbortVaultLockInput)
    pub fn builder() -> crate::input::abort_vault_lock_input::Builder {
        crate::input::abort_vault_lock_input::Builder::default()
    }
    /// Creates a new `AbortVaultLock` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AbortVaultLock {
    type Output =
        std::result::Result<crate::output::AbortVaultLockOutput, crate::error::AbortVaultLockError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_abort_vault_lock_error(response)
        } else {
            crate::operation_deser::parse_abort_vault_lock_response(response)
        }
    }
}

/// Operation shape for `AddTagsToVault`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_tags_to_vault`](crate::client::Client::add_tags_to_vault).
///
/// See [`crate::client::fluent_builders::AddTagsToVault`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddTagsToVault {
    _private: (),
}
impl AddTagsToVault {
    /// Creates a new builder-style object to manufacture [`AddTagsToVaultInput`](crate::input::AddTagsToVaultInput)
    pub fn builder() -> crate::input::add_tags_to_vault_input::Builder {
        crate::input::add_tags_to_vault_input::Builder::default()
    }
    /// Creates a new `AddTagsToVault` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddTagsToVault {
    type Output =
        std::result::Result<crate::output::AddTagsToVaultOutput, crate::error::AddTagsToVaultError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_add_tags_to_vault_error(response)
        } else {
            crate::operation_deser::parse_add_tags_to_vault_response(response)
        }
    }
}

/// Operation shape for `CompleteMultipartUpload`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`complete_multipart_upload`](crate::client::Client::complete_multipart_upload).
///
/// See [`crate::client::fluent_builders::CompleteMultipartUpload`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CompleteMultipartUpload {
    _private: (),
}
impl CompleteMultipartUpload {
    /// Creates a new builder-style object to manufacture [`CompleteMultipartUploadInput`](crate::input::CompleteMultipartUploadInput)
    pub fn builder() -> crate::input::complete_multipart_upload_input::Builder {
        crate::input::complete_multipart_upload_input::Builder::default()
    }
    /// Creates a new `CompleteMultipartUpload` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CompleteMultipartUpload {
    type Output = std::result::Result<
        crate::output::CompleteMultipartUploadOutput,
        crate::error::CompleteMultipartUploadError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_complete_multipart_upload_error(response)
        } else {
            crate::operation_deser::parse_complete_multipart_upload_response(response)
        }
    }
}

/// Operation shape for `CompleteVaultLock`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`complete_vault_lock`](crate::client::Client::complete_vault_lock).
///
/// See [`crate::client::fluent_builders::CompleteVaultLock`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CompleteVaultLock {
    _private: (),
}
impl CompleteVaultLock {
    /// Creates a new builder-style object to manufacture [`CompleteVaultLockInput`](crate::input::CompleteVaultLockInput)
    pub fn builder() -> crate::input::complete_vault_lock_input::Builder {
        crate::input::complete_vault_lock_input::Builder::default()
    }
    /// Creates a new `CompleteVaultLock` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CompleteVaultLock {
    type Output = std::result::Result<
        crate::output::CompleteVaultLockOutput,
        crate::error::CompleteVaultLockError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_complete_vault_lock_error(response)
        } else {
            crate::operation_deser::parse_complete_vault_lock_response(response)
        }
    }
}

/// Operation shape for `CreateVault`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_vault`](crate::client::Client::create_vault).
///
/// See [`crate::client::fluent_builders::CreateVault`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateVault {
    _private: (),
}
impl CreateVault {
    /// Creates a new builder-style object to manufacture [`CreateVaultInput`](crate::input::CreateVaultInput)
    pub fn builder() -> crate::input::create_vault_input::Builder {
        crate::input::create_vault_input::Builder::default()
    }
    /// Creates a new `CreateVault` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateVault {
    type Output =
        std::result::Result<crate::output::CreateVaultOutput, crate::error::CreateVaultError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_vault_error(response)
        } else {
            crate::operation_deser::parse_create_vault_response(response)
        }
    }
}

/// Operation shape for `DeleteArchive`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_archive`](crate::client::Client::delete_archive).
///
/// See [`crate::client::fluent_builders::DeleteArchive`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteArchive {
    _private: (),
}
impl DeleteArchive {
    /// Creates a new builder-style object to manufacture [`DeleteArchiveInput`](crate::input::DeleteArchiveInput)
    pub fn builder() -> crate::input::delete_archive_input::Builder {
        crate::input::delete_archive_input::Builder::default()
    }
    /// Creates a new `DeleteArchive` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteArchive {
    type Output =
        std::result::Result<crate::output::DeleteArchiveOutput, crate::error::DeleteArchiveError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_archive_error(response)
        } else {
            crate::operation_deser::parse_delete_archive_response(response)
        }
    }
}

/// Operation shape for `DeleteVault`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_vault`](crate::client::Client::delete_vault).
///
/// See [`crate::client::fluent_builders::DeleteVault`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVault {
    _private: (),
}
impl DeleteVault {
    /// Creates a new builder-style object to manufacture [`DeleteVaultInput`](crate::input::DeleteVaultInput)
    pub fn builder() -> crate::input::delete_vault_input::Builder {
        crate::input::delete_vault_input::Builder::default()
    }
    /// Creates a new `DeleteVault` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVault {
    type Output =
        std::result::Result<crate::output::DeleteVaultOutput, crate::error::DeleteVaultError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_vault_error(response)
        } else {
            crate::operation_deser::parse_delete_vault_response(response)
        }
    }
}

/// Operation shape for `DeleteVaultAccessPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_vault_access_policy`](crate::client::Client::delete_vault_access_policy).
///
/// See [`crate::client::fluent_builders::DeleteVaultAccessPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVaultAccessPolicy {
    _private: (),
}
impl DeleteVaultAccessPolicy {
    /// Creates a new builder-style object to manufacture [`DeleteVaultAccessPolicyInput`](crate::input::DeleteVaultAccessPolicyInput)
    pub fn builder() -> crate::input::delete_vault_access_policy_input::Builder {
        crate::input::delete_vault_access_policy_input::Builder::default()
    }
    /// Creates a new `DeleteVaultAccessPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVaultAccessPolicy {
    type Output = std::result::Result<
        crate::output::DeleteVaultAccessPolicyOutput,
        crate::error::DeleteVaultAccessPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_vault_access_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_vault_access_policy_response(response)
        }
    }
}

/// Operation shape for `DeleteVaultNotifications`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_vault_notifications`](crate::client::Client::delete_vault_notifications).
///
/// See [`crate::client::fluent_builders::DeleteVaultNotifications`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVaultNotifications {
    _private: (),
}
impl DeleteVaultNotifications {
    /// Creates a new builder-style object to manufacture [`DeleteVaultNotificationsInput`](crate::input::DeleteVaultNotificationsInput)
    pub fn builder() -> crate::input::delete_vault_notifications_input::Builder {
        crate::input::delete_vault_notifications_input::Builder::default()
    }
    /// Creates a new `DeleteVaultNotifications` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVaultNotifications {
    type Output = std::result::Result<
        crate::output::DeleteVaultNotificationsOutput,
        crate::error::DeleteVaultNotificationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_vault_notifications_error(response)
        } else {
            crate::operation_deser::parse_delete_vault_notifications_response(response)
        }
    }
}

/// Operation shape for `DescribeJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_job`](crate::client::Client::describe_job).
///
/// See [`crate::client::fluent_builders::DescribeJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeJob {
    _private: (),
}
impl DescribeJob {
    /// Creates a new builder-style object to manufacture [`DescribeJobInput`](crate::input::DescribeJobInput)
    pub fn builder() -> crate::input::describe_job_input::Builder {
        crate::input::describe_job_input::Builder::default()
    }
    /// Creates a new `DescribeJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeJob {
    type Output =
        std::result::Result<crate::output::DescribeJobOutput, crate::error::DescribeJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_job_error(response)
        } else {
            crate::operation_deser::parse_describe_job_response(response)
        }
    }
}

/// Operation shape for `DescribeVault`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_vault`](crate::client::Client::describe_vault).
///
/// See [`crate::client::fluent_builders::DescribeVault`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeVault {
    _private: (),
}
impl DescribeVault {
    /// Creates a new builder-style object to manufacture [`DescribeVaultInput`](crate::input::DescribeVaultInput)
    pub fn builder() -> crate::input::describe_vault_input::Builder {
        crate::input::describe_vault_input::Builder::default()
    }
    /// Creates a new `DescribeVault` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeVault {
    type Output =
        std::result::Result<crate::output::DescribeVaultOutput, crate::error::DescribeVaultError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_vault_error(response)
        } else {
            crate::operation_deser::parse_describe_vault_response(response)
        }
    }
}

/// Operation shape for `GetDataRetrievalPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_data_retrieval_policy`](crate::client::Client::get_data_retrieval_policy).
///
/// See [`crate::client::fluent_builders::GetDataRetrievalPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDataRetrievalPolicy {
    _private: (),
}
impl GetDataRetrievalPolicy {
    /// Creates a new builder-style object to manufacture [`GetDataRetrievalPolicyInput`](crate::input::GetDataRetrievalPolicyInput)
    pub fn builder() -> crate::input::get_data_retrieval_policy_input::Builder {
        crate::input::get_data_retrieval_policy_input::Builder::default()
    }
    /// Creates a new `GetDataRetrievalPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDataRetrievalPolicy {
    type Output = std::result::Result<
        crate::output::GetDataRetrievalPolicyOutput,
        crate::error::GetDataRetrievalPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_data_retrieval_policy_error(response)
        } else {
            crate::operation_deser::parse_get_data_retrieval_policy_response(response)
        }
    }
}

/// Operation shape for `GetJobOutput`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_job_output`](crate::client::Client::get_job_output).
///
/// See [`crate::client::fluent_builders::GetJobOutput`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetJobOutput {
    _private: (),
}
impl GetJobOutput {
    /// Creates a new builder-style object to manufacture [`GetJobOutputInput`](crate::input::GetJobOutputInput)
    pub fn builder() -> crate::input::get_job_output_input::Builder {
        crate::input::get_job_output_input::Builder::default()
    }
    /// Creates a new `GetJobOutput` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseHttpResponse for GetJobOutput {
    type Output =
        std::result::Result<crate::output::GetJobOutputOutput, crate::error::GetJobOutputError>;
    fn parse_unloaded(
        &self,
        response: &mut aws_smithy_http::operation::Response,
    ) -> Option<Self::Output> {
        // This is an error, defer to the non-streaming parser
        if !response.http().status().is_success() && response.http().status().as_u16() != 200 {
            return None;
        }
        Some(crate::operation_deser::parse_get_job_output(response))
    }
    fn parse_loaded(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        // if streaming, we only hit this case if its an error
        crate::operation_deser::parse_get_job_output_error(response)
    }
}

/// Operation shape for `GetVaultAccessPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_vault_access_policy`](crate::client::Client::get_vault_access_policy).
///
/// See [`crate::client::fluent_builders::GetVaultAccessPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetVaultAccessPolicy {
    _private: (),
}
impl GetVaultAccessPolicy {
    /// Creates a new builder-style object to manufacture [`GetVaultAccessPolicyInput`](crate::input::GetVaultAccessPolicyInput)
    pub fn builder() -> crate::input::get_vault_access_policy_input::Builder {
        crate::input::get_vault_access_policy_input::Builder::default()
    }
    /// Creates a new `GetVaultAccessPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetVaultAccessPolicy {
    type Output = std::result::Result<
        crate::output::GetVaultAccessPolicyOutput,
        crate::error::GetVaultAccessPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_vault_access_policy_error(response)
        } else {
            crate::operation_deser::parse_get_vault_access_policy_response(response)
        }
    }
}

/// Operation shape for `GetVaultLock`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_vault_lock`](crate::client::Client::get_vault_lock).
///
/// See [`crate::client::fluent_builders::GetVaultLock`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetVaultLock {
    _private: (),
}
impl GetVaultLock {
    /// Creates a new builder-style object to manufacture [`GetVaultLockInput`](crate::input::GetVaultLockInput)
    pub fn builder() -> crate::input::get_vault_lock_input::Builder {
        crate::input::get_vault_lock_input::Builder::default()
    }
    /// Creates a new `GetVaultLock` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetVaultLock {
    type Output =
        std::result::Result<crate::output::GetVaultLockOutput, crate::error::GetVaultLockError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_vault_lock_error(response)
        } else {
            crate::operation_deser::parse_get_vault_lock_response(response)
        }
    }
}

/// Operation shape for `GetVaultNotifications`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_vault_notifications`](crate::client::Client::get_vault_notifications).
///
/// See [`crate::client::fluent_builders::GetVaultNotifications`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetVaultNotifications {
    _private: (),
}
impl GetVaultNotifications {
    /// Creates a new builder-style object to manufacture [`GetVaultNotificationsInput`](crate::input::GetVaultNotificationsInput)
    pub fn builder() -> crate::input::get_vault_notifications_input::Builder {
        crate::input::get_vault_notifications_input::Builder::default()
    }
    /// Creates a new `GetVaultNotifications` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetVaultNotifications {
    type Output = std::result::Result<
        crate::output::GetVaultNotificationsOutput,
        crate::error::GetVaultNotificationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_vault_notifications_error(response)
        } else {
            crate::operation_deser::parse_get_vault_notifications_response(response)
        }
    }
}

/// Operation shape for `InitiateJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`initiate_job`](crate::client::Client::initiate_job).
///
/// See [`crate::client::fluent_builders::InitiateJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct InitiateJob {
    _private: (),
}
impl InitiateJob {
    /// Creates a new builder-style object to manufacture [`InitiateJobInput`](crate::input::InitiateJobInput)
    pub fn builder() -> crate::input::initiate_job_input::Builder {
        crate::input::initiate_job_input::Builder::default()
    }
    /// Creates a new `InitiateJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for InitiateJob {
    type Output =
        std::result::Result<crate::output::InitiateJobOutput, crate::error::InitiateJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_initiate_job_error(response)
        } else {
            crate::operation_deser::parse_initiate_job_response(response)
        }
    }
}

/// Operation shape for `InitiateMultipartUpload`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`initiate_multipart_upload`](crate::client::Client::initiate_multipart_upload).
///
/// See [`crate::client::fluent_builders::InitiateMultipartUpload`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct InitiateMultipartUpload {
    _private: (),
}
impl InitiateMultipartUpload {
    /// Creates a new builder-style object to manufacture [`InitiateMultipartUploadInput`](crate::input::InitiateMultipartUploadInput)
    pub fn builder() -> crate::input::initiate_multipart_upload_input::Builder {
        crate::input::initiate_multipart_upload_input::Builder::default()
    }
    /// Creates a new `InitiateMultipartUpload` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for InitiateMultipartUpload {
    type Output = std::result::Result<
        crate::output::InitiateMultipartUploadOutput,
        crate::error::InitiateMultipartUploadError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_initiate_multipart_upload_error(response)
        } else {
            crate::operation_deser::parse_initiate_multipart_upload_response(response)
        }
    }
}

/// Operation shape for `InitiateVaultLock`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`initiate_vault_lock`](crate::client::Client::initiate_vault_lock).
///
/// See [`crate::client::fluent_builders::InitiateVaultLock`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct InitiateVaultLock {
    _private: (),
}
impl InitiateVaultLock {
    /// Creates a new builder-style object to manufacture [`InitiateVaultLockInput`](crate::input::InitiateVaultLockInput)
    pub fn builder() -> crate::input::initiate_vault_lock_input::Builder {
        crate::input::initiate_vault_lock_input::Builder::default()
    }
    /// Creates a new `InitiateVaultLock` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for InitiateVaultLock {
    type Output = std::result::Result<
        crate::output::InitiateVaultLockOutput,
        crate::error::InitiateVaultLockError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_initiate_vault_lock_error(response)
        } else {
            crate::operation_deser::parse_initiate_vault_lock_response(response)
        }
    }
}

/// Operation shape for `ListJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_jobs`](crate::client::Client::list_jobs).
///
/// See [`crate::client::fluent_builders::ListJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListJobs {
    _private: (),
}
impl ListJobs {
    /// Creates a new builder-style object to manufacture [`ListJobsInput`](crate::input::ListJobsInput)
    pub fn builder() -> crate::input::list_jobs_input::Builder {
        crate::input::list_jobs_input::Builder::default()
    }
    /// Creates a new `ListJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListJobs {
    type Output = std::result::Result<crate::output::ListJobsOutput, crate::error::ListJobsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_jobs_response(response)
        }
    }
}

/// Operation shape for `ListMultipartUploads`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_multipart_uploads`](crate::client::Client::list_multipart_uploads).
///
/// See [`crate::client::fluent_builders::ListMultipartUploads`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListMultipartUploads {
    _private: (),
}
impl ListMultipartUploads {
    /// Creates a new builder-style object to manufacture [`ListMultipartUploadsInput`](crate::input::ListMultipartUploadsInput)
    pub fn builder() -> crate::input::list_multipart_uploads_input::Builder {
        crate::input::list_multipart_uploads_input::Builder::default()
    }
    /// Creates a new `ListMultipartUploads` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListMultipartUploads {
    type Output = std::result::Result<
        crate::output::ListMultipartUploadsOutput,
        crate::error::ListMultipartUploadsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_multipart_uploads_error(response)
        } else {
            crate::operation_deser::parse_list_multipart_uploads_response(response)
        }
    }
}

/// Operation shape for `ListParts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_parts`](crate::client::Client::list_parts).
///
/// See [`crate::client::fluent_builders::ListParts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListParts {
    _private: (),
}
impl ListParts {
    /// Creates a new builder-style object to manufacture [`ListPartsInput`](crate::input::ListPartsInput)
    pub fn builder() -> crate::input::list_parts_input::Builder {
        crate::input::list_parts_input::Builder::default()
    }
    /// Creates a new `ListParts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListParts {
    type Output = std::result::Result<crate::output::ListPartsOutput, crate::error::ListPartsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_parts_error(response)
        } else {
            crate::operation_deser::parse_list_parts_response(response)
        }
    }
}

/// Operation shape for `ListProvisionedCapacity`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_provisioned_capacity`](crate::client::Client::list_provisioned_capacity).
///
/// See [`crate::client::fluent_builders::ListProvisionedCapacity`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListProvisionedCapacity {
    _private: (),
}
impl ListProvisionedCapacity {
    /// Creates a new builder-style object to manufacture [`ListProvisionedCapacityInput`](crate::input::ListProvisionedCapacityInput)
    pub fn builder() -> crate::input::list_provisioned_capacity_input::Builder {
        crate::input::list_provisioned_capacity_input::Builder::default()
    }
    /// Creates a new `ListProvisionedCapacity` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListProvisionedCapacity {
    type Output = std::result::Result<
        crate::output::ListProvisionedCapacityOutput,
        crate::error::ListProvisionedCapacityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_provisioned_capacity_error(response)
        } else {
            crate::operation_deser::parse_list_provisioned_capacity_response(response)
        }
    }
}

/// Operation shape for `ListTagsForVault`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_vault`](crate::client::Client::list_tags_for_vault).
///
/// See [`crate::client::fluent_builders::ListTagsForVault`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForVault {
    _private: (),
}
impl ListTagsForVault {
    /// Creates a new builder-style object to manufacture [`ListTagsForVaultInput`](crate::input::ListTagsForVaultInput)
    pub fn builder() -> crate::input::list_tags_for_vault_input::Builder {
        crate::input::list_tags_for_vault_input::Builder::default()
    }
    /// Creates a new `ListTagsForVault` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForVault {
    type Output = std::result::Result<
        crate::output::ListTagsForVaultOutput,
        crate::error::ListTagsForVaultError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_vault_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_vault_response(response)
        }
    }
}

/// Operation shape for `ListVaults`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_vaults`](crate::client::Client::list_vaults).
///
/// See [`crate::client::fluent_builders::ListVaults`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListVaults {
    _private: (),
}
impl ListVaults {
    /// Creates a new builder-style object to manufacture [`ListVaultsInput`](crate::input::ListVaultsInput)
    pub fn builder() -> crate::input::list_vaults_input::Builder {
        crate::input::list_vaults_input::Builder::default()
    }
    /// Creates a new `ListVaults` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListVaults {
    type Output =
        std::result::Result<crate::output::ListVaultsOutput, crate::error::ListVaultsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_vaults_error(response)
        } else {
            crate::operation_deser::parse_list_vaults_response(response)
        }
    }
}

/// Operation shape for `PurchaseProvisionedCapacity`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`purchase_provisioned_capacity`](crate::client::Client::purchase_provisioned_capacity).
///
/// See [`crate::client::fluent_builders::PurchaseProvisionedCapacity`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PurchaseProvisionedCapacity {
    _private: (),
}
impl PurchaseProvisionedCapacity {
    /// Creates a new builder-style object to manufacture [`PurchaseProvisionedCapacityInput`](crate::input::PurchaseProvisionedCapacityInput)
    pub fn builder() -> crate::input::purchase_provisioned_capacity_input::Builder {
        crate::input::purchase_provisioned_capacity_input::Builder::default()
    }
    /// Creates a new `PurchaseProvisionedCapacity` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PurchaseProvisionedCapacity {
    type Output = std::result::Result<
        crate::output::PurchaseProvisionedCapacityOutput,
        crate::error::PurchaseProvisionedCapacityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_purchase_provisioned_capacity_error(response)
        } else {
            crate::operation_deser::parse_purchase_provisioned_capacity_response(response)
        }
    }
}

/// Operation shape for `RemoveTagsFromVault`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_tags_from_vault`](crate::client::Client::remove_tags_from_vault).
///
/// See [`crate::client::fluent_builders::RemoveTagsFromVault`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveTagsFromVault {
    _private: (),
}
impl RemoveTagsFromVault {
    /// Creates a new builder-style object to manufacture [`RemoveTagsFromVaultInput`](crate::input::RemoveTagsFromVaultInput)
    pub fn builder() -> crate::input::remove_tags_from_vault_input::Builder {
        crate::input::remove_tags_from_vault_input::Builder::default()
    }
    /// Creates a new `RemoveTagsFromVault` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveTagsFromVault {
    type Output = std::result::Result<
        crate::output::RemoveTagsFromVaultOutput,
        crate::error::RemoveTagsFromVaultError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_remove_tags_from_vault_error(response)
        } else {
            crate::operation_deser::parse_remove_tags_from_vault_response(response)
        }
    }
}

/// Operation shape for `SetDataRetrievalPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_data_retrieval_policy`](crate::client::Client::set_data_retrieval_policy).
///
/// See [`crate::client::fluent_builders::SetDataRetrievalPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetDataRetrievalPolicy {
    _private: (),
}
impl SetDataRetrievalPolicy {
    /// Creates a new builder-style object to manufacture [`SetDataRetrievalPolicyInput`](crate::input::SetDataRetrievalPolicyInput)
    pub fn builder() -> crate::input::set_data_retrieval_policy_input::Builder {
        crate::input::set_data_retrieval_policy_input::Builder::default()
    }
    /// Creates a new `SetDataRetrievalPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetDataRetrievalPolicy {
    type Output = std::result::Result<
        crate::output::SetDataRetrievalPolicyOutput,
        crate::error::SetDataRetrievalPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_set_data_retrieval_policy_error(response)
        } else {
            crate::operation_deser::parse_set_data_retrieval_policy_response(response)
        }
    }
}

/// Operation shape for `SetVaultAccessPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_vault_access_policy`](crate::client::Client::set_vault_access_policy).
///
/// See [`crate::client::fluent_builders::SetVaultAccessPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetVaultAccessPolicy {
    _private: (),
}
impl SetVaultAccessPolicy {
    /// Creates a new builder-style object to manufacture [`SetVaultAccessPolicyInput`](crate::input::SetVaultAccessPolicyInput)
    pub fn builder() -> crate::input::set_vault_access_policy_input::Builder {
        crate::input::set_vault_access_policy_input::Builder::default()
    }
    /// Creates a new `SetVaultAccessPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetVaultAccessPolicy {
    type Output = std::result::Result<
        crate::output::SetVaultAccessPolicyOutput,
        crate::error::SetVaultAccessPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_set_vault_access_policy_error(response)
        } else {
            crate::operation_deser::parse_set_vault_access_policy_response(response)
        }
    }
}

/// Operation shape for `SetVaultNotifications`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_vault_notifications`](crate::client::Client::set_vault_notifications).
///
/// See [`crate::client::fluent_builders::SetVaultNotifications`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetVaultNotifications {
    _private: (),
}
impl SetVaultNotifications {
    /// Creates a new builder-style object to manufacture [`SetVaultNotificationsInput`](crate::input::SetVaultNotificationsInput)
    pub fn builder() -> crate::input::set_vault_notifications_input::Builder {
        crate::input::set_vault_notifications_input::Builder::default()
    }
    /// Creates a new `SetVaultNotifications` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetVaultNotifications {
    type Output = std::result::Result<
        crate::output::SetVaultNotificationsOutput,
        crate::error::SetVaultNotificationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_set_vault_notifications_error(response)
        } else {
            crate::operation_deser::parse_set_vault_notifications_response(response)
        }
    }
}

/// Operation shape for `UploadArchive`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`upload_archive`](crate::client::Client::upload_archive).
///
/// See [`crate::client::fluent_builders::UploadArchive`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UploadArchive {
    _private: (),
}
impl UploadArchive {
    /// Creates a new builder-style object to manufacture [`UploadArchiveInput`](crate::input::UploadArchiveInput)
    pub fn builder() -> crate::input::upload_archive_input::Builder {
        crate::input::upload_archive_input::Builder::default()
    }
    /// Creates a new `UploadArchive` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UploadArchive {
    type Output =
        std::result::Result<crate::output::UploadArchiveOutput, crate::error::UploadArchiveError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_upload_archive_error(response)
        } else {
            crate::operation_deser::parse_upload_archive_response(response)
        }
    }
}
#[cfg(test)]
#[allow(unreachable_code, unused_variables)]
mod upload_archive_request_test {
    /// Glacier requires that a version header be set on all requests.
    /// Test ID: GlacierVersionHeader
    #[tokio::test]
    async fn glacier_version_header_request() {
        let config = crate::config::Config::builder().build();
        let input = crate::input::UploadArchiveInput::builder()
            .set_account_id(Some("foo".to_string()))
            .set_vault_name(Some("bar".to_string()))
            .build()
            .unwrap()
            .make_operation(&config)
            .await
            .expect("operation failed to build");
        let (http_request, parts) = input.into_request_response().0.into_parts();
        assert_eq!(http_request.method(), "POST");
        assert_eq!(http_request.uri().path(), "/foo/vaults/bar/archives");
        let expected_headers = &[("X-Amz-Glacier-Version", "2012-06-01")];
        aws_smithy_protocol_test::assert_ok(aws_smithy_protocol_test::validate_headers(
            &http_request,
            expected_headers,
        ));
        let body = http_request.body().bytes().expect("body should be strict");
        // No body
        assert_eq!(std::str::from_utf8(body).unwrap(), "");
    }
    /// Glacier requires checksum headers that are cumbersome to provide.
    /// Test ID: GlacierChecksums
    #[tokio::test]
    async fn glacier_checksums_request() {
        let config = crate::config::Config::builder().build();
        let input = crate::input::UploadArchiveInput::builder()
            .set_account_id(Some("foo".to_string()))
            .set_vault_name(Some("bar".to_string()))
            .set_body(Some(aws_smithy_http::byte_stream::ByteStream::from_static(
                b"hello world",
            )))
            .build()
            .unwrap()
            .make_operation(&config)
            .await
            .expect("operation failed to build");
        let (http_request, parts) = input.into_request_response().0.into_parts();
        assert_eq!(http_request.method(), "POST");
        assert_eq!(http_request.uri().path(), "/foo/vaults/bar/archives");
        let expected_headers = &[
            (
                "X-Amz-Content-Sha256",
                "b94d27b9934d3e08a52e52d7da7dabfac484efe37a5380ee9088f7ace2efcde9",
            ),
            ("X-Amz-Glacier-Version", "2012-06-01"),
            (
                "X-Amz-Sha256-Tree-Hash",
                "b94d27b9934d3e08a52e52d7da7dabfac484efe37a5380ee9088f7ace2efcde9",
            ),
        ];
        aws_smithy_protocol_test::assert_ok(aws_smithy_protocol_test::validate_headers(
            &http_request,
            expected_headers,
        ));
        let body = http_request.body().bytes().expect("body should be strict");
        aws_smithy_protocol_test::assert_ok(aws_smithy_protocol_test::validate_body(
            &body,
            "hello world",
            aws_smithy_protocol_test::MediaType::from("unknown"),
        ));
    }
    /// Glacier requires that the account id be set, but you can just use a
    /// hyphen (-) to indicate the current account. This should be default
    /// behavior if the customer provides a null or empty string.
    /// Test ID: GlacierAccountIdEmpty
    #[tokio::test]
    async fn glacier_account_id_empty_request() {
        let config = crate::config::Config::builder().build();
        let input = crate::input::UploadArchiveInput::builder()
            .set_account_id(Some("".to_string()))
            .set_vault_name(Some("bar".to_string()))
            .build()
            .unwrap()
            .make_operation(&config)
            .await
            .expect("operation failed to build");
        let (http_request, parts) = input.into_request_response().0.into_parts();
        assert_eq!(http_request.method(), "POST");
        assert_eq!(http_request.uri().path(), "/-/vaults/bar/archives");
        let expected_headers = &[("X-Amz-Glacier-Version", "2012-06-01")];
        aws_smithy_protocol_test::assert_ok(aws_smithy_protocol_test::validate_headers(
            &http_request,
            expected_headers,
        ));
        let body = http_request.body().bytes().expect("body should be strict");
        // No body
        assert_eq!(std::str::from_utf8(body).unwrap(), "");
    }
    /// Glacier requires that the account id be set, but you can just use a
    /// hyphen (-) to indicate the current account. This should be default
    /// behavior if the customer provides a null or empty string.
    /// Test ID: GlacierAccountIdUnset
    #[tokio::test]
    async fn glacier_account_id_unset_request() {
        let config = crate::config::Config::builder().build();
        let input = crate::input::UploadArchiveInput::builder()
            .set_vault_name(Some("bar".to_string()))
            .set_account_id(None)
            .build()
            .unwrap()
            .make_operation(&config)
            .await
            .expect("operation failed to build");
        let (http_request, parts) = input.into_request_response().0.into_parts();
        assert_eq!(http_request.method(), "POST");
        assert_eq!(http_request.uri().path(), "/-/vaults/bar/archives");
        let expected_headers = &[("X-Amz-Glacier-Version", "2012-06-01")];
        aws_smithy_protocol_test::assert_ok(aws_smithy_protocol_test::validate_headers(
            &http_request,
            expected_headers,
        ));
        let body = http_request.body().bytes().expect("body should be strict");
        // No body
        assert_eq!(std::str::from_utf8(body).unwrap(), "");
    }
}

/// Operation shape for `UploadMultipartPart`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`upload_multipart_part`](crate::client::Client::upload_multipart_part).
///
/// See [`crate::client::fluent_builders::UploadMultipartPart`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UploadMultipartPart {
    _private: (),
}
impl UploadMultipartPart {
    /// Creates a new builder-style object to manufacture [`UploadMultipartPartInput`](crate::input::UploadMultipartPartInput)
    pub fn builder() -> crate::input::upload_multipart_part_input::Builder {
        crate::input::upload_multipart_part_input::Builder::default()
    }
    /// Creates a new `UploadMultipartPart` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UploadMultipartPart {
    type Output = std::result::Result<
        crate::output::UploadMultipartPartOutput,
        crate::error::UploadMultipartPartError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_upload_multipart_part_error(response)
        } else {
            crate::operation_deser::parse_upload_multipart_part_response(response)
        }
    }
}
#[cfg(test)]
#[allow(unreachable_code, unused_variables)]
mod upload_multipart_part_request_test {
    /// Glacier requires checksum headers that are cumbersome to provide.
    /// Test ID: GlacierMultipartChecksums
    #[tokio::test]
    async fn glacier_multipart_checksums_request() {
        let config = crate::config::Config::builder().build();
        let input = crate::input::UploadMultipartPartInput::builder()
            .set_account_id(Some("foo".to_string()))
            .set_vault_name(Some("bar".to_string()))
            .set_upload_id(Some("baz".to_string()))
            .set_body(Some(aws_smithy_http::byte_stream::ByteStream::from_static(
                b"hello world",
            )))
            .build()
            .unwrap()
            .make_operation(&config)
            .await
            .expect("operation failed to build");
        let (http_request, parts) = input.into_request_response().0.into_parts();
        assert_eq!(http_request.method(), "PUT");
        assert_eq!(
            http_request.uri().path(),
            "/foo/vaults/bar/multipart-uploads/baz"
        );
        let expected_headers = &[
            (
                "X-Amz-Content-Sha256",
                "b94d27b9934d3e08a52e52d7da7dabfac484efe37a5380ee9088f7ace2efcde9",
            ),
            ("X-Amz-Glacier-Version", "2012-06-01"),
            (
                "X-Amz-Sha256-Tree-Hash",
                "b94d27b9934d3e08a52e52d7da7dabfac484efe37a5380ee9088f7ace2efcde9",
            ),
        ];
        aws_smithy_protocol_test::assert_ok(aws_smithy_protocol_test::validate_headers(
            &http_request,
            expected_headers,
        ));
        let body = http_request.body().bytes().expect("body should be strict");
        aws_smithy_protocol_test::assert_ok(aws_smithy_protocol_test::validate_body(
            &body,
            "hello world",
            aws_smithy_protocol_test::MediaType::from("unknown"),
        ));
    }
}
