// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AbortMultipartUpload` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AbortMultipartUploadError {
    /// Kind of error that occurred.
    pub kind: AbortMultipartUploadErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AbortMultipartUpload` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AbortMultipartUploadErrorKind {
    /// <p>Returned if a parameter of the request is incorrectly specified.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Returned if a required header or parameter is missing from the request.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>Returned if the specified resource (such as a vault, upload ID, or job ID) doesn't
    /// exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Returned if the service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AbortMultipartUploadError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AbortMultipartUploadErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            AbortMultipartUploadErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            AbortMultipartUploadErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AbortMultipartUploadErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            AbortMultipartUploadErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AbortMultipartUploadError {
    fn code(&self) -> Option<&str> {
        AbortMultipartUploadError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AbortMultipartUploadError {
    /// Creates a new `AbortMultipartUploadError`.
    pub fn new(kind: AbortMultipartUploadErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AbortMultipartUploadError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AbortMultipartUploadErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AbortMultipartUploadError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AbortMultipartUploadErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AbortMultipartUploadErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            AbortMultipartUploadErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `AbortMultipartUploadErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            AbortMultipartUploadErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `AbortMultipartUploadErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AbortMultipartUploadErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AbortMultipartUploadErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            AbortMultipartUploadErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for AbortMultipartUploadError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AbortMultipartUploadErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            AbortMultipartUploadErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            AbortMultipartUploadErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AbortMultipartUploadErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            AbortMultipartUploadErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AbortVaultLock` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AbortVaultLockError {
    /// Kind of error that occurred.
    pub kind: AbortVaultLockErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AbortVaultLock` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AbortVaultLockErrorKind {
    /// <p>Returned if a parameter of the request is incorrectly specified.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Returned if a required header or parameter is missing from the request.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>Returned if the specified resource (such as a vault, upload ID, or job ID) doesn't
    /// exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Returned if the service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AbortVaultLockError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AbortVaultLockErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            AbortVaultLockErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            AbortVaultLockErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AbortVaultLockErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            AbortVaultLockErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AbortVaultLockError {
    fn code(&self) -> Option<&str> {
        AbortVaultLockError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AbortVaultLockError {
    /// Creates a new `AbortVaultLockError`.
    pub fn new(kind: AbortVaultLockErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AbortVaultLockError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AbortVaultLockErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AbortVaultLockError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AbortVaultLockErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AbortVaultLockErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            AbortVaultLockErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `AbortVaultLockErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            AbortVaultLockErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `AbortVaultLockErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AbortVaultLockErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AbortVaultLockErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            AbortVaultLockErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for AbortVaultLockError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AbortVaultLockErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            AbortVaultLockErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            AbortVaultLockErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AbortVaultLockErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            AbortVaultLockErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AddTagsToVault` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddTagsToVaultError {
    /// Kind of error that occurred.
    pub kind: AddTagsToVaultErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddTagsToVault` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddTagsToVaultErrorKind {
    /// <p>Returned if a parameter of the request is incorrectly specified.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Returned if the request results in a vault or account limit being exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Returned if a required header or parameter is missing from the request.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>Returned if the specified resource (such as a vault, upload ID, or job ID) doesn't
    /// exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Returned if the service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddTagsToVaultError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddTagsToVaultErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            AddTagsToVaultErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            AddTagsToVaultErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            AddTagsToVaultErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AddTagsToVaultErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            AddTagsToVaultErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddTagsToVaultError {
    fn code(&self) -> Option<&str> {
        AddTagsToVaultError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddTagsToVaultError {
    /// Creates a new `AddTagsToVaultError`.
    pub fn new(kind: AddTagsToVaultErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddTagsToVaultError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddTagsToVaultErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddTagsToVaultError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddTagsToVaultErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddTagsToVaultErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToVaultErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `AddTagsToVaultErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToVaultErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AddTagsToVaultErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToVaultErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `AddTagsToVaultErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToVaultErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AddTagsToVaultErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToVaultErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for AddTagsToVaultError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddTagsToVaultErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            AddTagsToVaultErrorKind::LimitExceededException(_inner) => Some(_inner),
            AddTagsToVaultErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            AddTagsToVaultErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AddTagsToVaultErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            AddTagsToVaultErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CompleteMultipartUpload` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CompleteMultipartUploadError {
    /// Kind of error that occurred.
    pub kind: CompleteMultipartUploadErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CompleteMultipartUpload` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CompleteMultipartUploadErrorKind {
    /// <p>Returned if a parameter of the request is incorrectly specified.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Returned if a required header or parameter is missing from the request.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>Returned if the specified resource (such as a vault, upload ID, or job ID) doesn't
    /// exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Returned if the service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CompleteMultipartUploadError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CompleteMultipartUploadErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            CompleteMultipartUploadErrorKind::MissingParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            CompleteMultipartUploadErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CompleteMultipartUploadErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CompleteMultipartUploadErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CompleteMultipartUploadError {
    fn code(&self) -> Option<&str> {
        CompleteMultipartUploadError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CompleteMultipartUploadError {
    /// Creates a new `CompleteMultipartUploadError`.
    pub fn new(kind: CompleteMultipartUploadErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CompleteMultipartUploadError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CompleteMultipartUploadErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CompleteMultipartUploadError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CompleteMultipartUploadErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CompleteMultipartUploadErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CompleteMultipartUploadErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CompleteMultipartUploadErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CompleteMultipartUploadErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CompleteMultipartUploadErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CompleteMultipartUploadErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CompleteMultipartUploadErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CompleteMultipartUploadErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for CompleteMultipartUploadError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CompleteMultipartUploadErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            CompleteMultipartUploadErrorKind::MissingParameterValueException(_inner) => {
                Some(_inner)
            }
            CompleteMultipartUploadErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CompleteMultipartUploadErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CompleteMultipartUploadErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CompleteVaultLock` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CompleteVaultLockError {
    /// Kind of error that occurred.
    pub kind: CompleteVaultLockErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CompleteVaultLock` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CompleteVaultLockErrorKind {
    /// <p>Returned if a parameter of the request is incorrectly specified.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Returned if a required header or parameter is missing from the request.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>Returned if the specified resource (such as a vault, upload ID, or job ID) doesn't
    /// exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Returned if the service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CompleteVaultLockError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CompleteVaultLockErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CompleteVaultLockErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            CompleteVaultLockErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CompleteVaultLockErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CompleteVaultLockErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CompleteVaultLockError {
    fn code(&self) -> Option<&str> {
        CompleteVaultLockError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CompleteVaultLockError {
    /// Creates a new `CompleteVaultLockError`.
    pub fn new(kind: CompleteVaultLockErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CompleteVaultLockError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CompleteVaultLockErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CompleteVaultLockError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CompleteVaultLockErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CompleteVaultLockErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CompleteVaultLockErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CompleteVaultLockErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CompleteVaultLockErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CompleteVaultLockErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CompleteVaultLockErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CompleteVaultLockErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CompleteVaultLockErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for CompleteVaultLockError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CompleteVaultLockErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CompleteVaultLockErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            CompleteVaultLockErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CompleteVaultLockErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CompleteVaultLockErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateVault` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateVaultError {
    /// Kind of error that occurred.
    pub kind: CreateVaultErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateVault` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateVaultErrorKind {
    /// <p>Returned if a parameter of the request is incorrectly specified.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Returned if the request results in a vault or account limit being exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Returned if a required header or parameter is missing from the request.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>Returned if the service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateVaultError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateVaultErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CreateVaultErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateVaultErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            CreateVaultErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateVaultErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateVaultError {
    fn code(&self) -> Option<&str> {
        CreateVaultError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateVaultError {
    /// Creates a new `CreateVaultError`.
    pub fn new(kind: CreateVaultErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateVaultError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateVaultErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateVaultError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateVaultErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateVaultErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVaultErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVaultErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateVaultErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateVaultErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVaultErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVaultErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVaultErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for CreateVaultError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateVaultErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CreateVaultErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateVaultErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            CreateVaultErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateVaultErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteArchive` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteArchiveError {
    /// Kind of error that occurred.
    pub kind: DeleteArchiveErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteArchive` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteArchiveErrorKind {
    /// <p>Returned if a parameter of the request is incorrectly specified.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Returned if a required header or parameter is missing from the request.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>Returned if the specified resource (such as a vault, upload ID, or job ID) doesn't
    /// exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Returned if the service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteArchiveError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteArchiveErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteArchiveErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            DeleteArchiveErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteArchiveErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteArchiveErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteArchiveError {
    fn code(&self) -> Option<&str> {
        DeleteArchiveError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteArchiveError {
    /// Creates a new `DeleteArchiveError`.
    pub fn new(kind: DeleteArchiveErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteArchiveError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteArchiveErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteArchiveError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteArchiveErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteArchiveErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteArchiveErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteArchiveErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteArchiveErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteArchiveErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteArchiveErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteArchiveErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteArchiveErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DeleteArchiveError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteArchiveErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteArchiveErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            DeleteArchiveErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteArchiveErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteArchiveErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteVault` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteVaultError {
    /// Kind of error that occurred.
    pub kind: DeleteVaultErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteVault` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteVaultErrorKind {
    /// <p>Returned if a parameter of the request is incorrectly specified.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Returned if a required header or parameter is missing from the request.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>Returned if the specified resource (such as a vault, upload ID, or job ID) doesn't
    /// exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Returned if the service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteVaultError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteVaultErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteVaultErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            DeleteVaultErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteVaultErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteVaultErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteVaultError {
    fn code(&self) -> Option<&str> {
        DeleteVaultError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteVaultError {
    /// Creates a new `DeleteVaultError`.
    pub fn new(kind: DeleteVaultErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteVaultError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteVaultErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteVaultError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteVaultErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteVaultErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVaultErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVaultErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVaultErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVaultErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVaultErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVaultErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVaultErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DeleteVaultError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteVaultErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteVaultErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            DeleteVaultErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteVaultErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteVaultErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteVaultAccessPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteVaultAccessPolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteVaultAccessPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteVaultAccessPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteVaultAccessPolicyErrorKind {
    /// <p>Returned if a parameter of the request is incorrectly specified.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Returned if a required header or parameter is missing from the request.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>Returned if the specified resource (such as a vault, upload ID, or job ID) doesn't
    /// exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Returned if the service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteVaultAccessPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteVaultAccessPolicyErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DeleteVaultAccessPolicyErrorKind::MissingParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DeleteVaultAccessPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteVaultAccessPolicyErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteVaultAccessPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteVaultAccessPolicyError {
    fn code(&self) -> Option<&str> {
        DeleteVaultAccessPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteVaultAccessPolicyError {
    /// Creates a new `DeleteVaultAccessPolicyError`.
    pub fn new(kind: DeleteVaultAccessPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteVaultAccessPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteVaultAccessPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteVaultAccessPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteVaultAccessPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteVaultAccessPolicyErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVaultAccessPolicyErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVaultAccessPolicyErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVaultAccessPolicyErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVaultAccessPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVaultAccessPolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVaultAccessPolicyErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVaultAccessPolicyErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DeleteVaultAccessPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteVaultAccessPolicyErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DeleteVaultAccessPolicyErrorKind::MissingParameterValueException(_inner) => {
                Some(_inner)
            }
            DeleteVaultAccessPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteVaultAccessPolicyErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteVaultAccessPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteVaultNotifications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteVaultNotificationsError {
    /// Kind of error that occurred.
    pub kind: DeleteVaultNotificationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteVaultNotifications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteVaultNotificationsErrorKind {
    /// <p>Returned if a parameter of the request is incorrectly specified.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Returned if a required header or parameter is missing from the request.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>Returned if the specified resource (such as a vault, upload ID, or job ID) doesn't
    /// exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Returned if the service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteVaultNotificationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteVaultNotificationsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DeleteVaultNotificationsErrorKind::MissingParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DeleteVaultNotificationsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteVaultNotificationsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteVaultNotificationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteVaultNotificationsError {
    fn code(&self) -> Option<&str> {
        DeleteVaultNotificationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteVaultNotificationsError {
    /// Creates a new `DeleteVaultNotificationsError`.
    pub fn new(kind: DeleteVaultNotificationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteVaultNotificationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteVaultNotificationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteVaultNotificationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteVaultNotificationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteVaultNotificationsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVaultNotificationsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVaultNotificationsErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVaultNotificationsErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVaultNotificationsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVaultNotificationsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVaultNotificationsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVaultNotificationsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DeleteVaultNotificationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteVaultNotificationsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DeleteVaultNotificationsErrorKind::MissingParameterValueException(_inner) => {
                Some(_inner)
            }
            DeleteVaultNotificationsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteVaultNotificationsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteVaultNotificationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeJobError {
    /// Kind of error that occurred.
    pub kind: DescribeJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeJobErrorKind {
    /// <p>Returned if a parameter of the request is incorrectly specified.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Returned if a required header or parameter is missing from the request.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>Returned if the specified resource (such as a vault, upload ID, or job ID) doesn't
    /// exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Returned if the service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeJobErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DescribeJobErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            DescribeJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeJobErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeJobError {
    fn code(&self) -> Option<&str> {
        DescribeJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeJobError {
    /// Creates a new `DescribeJobError`.
    pub fn new(kind: DescribeJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeJobErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeJobErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeJobErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeJobErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeJobErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeJobErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DescribeJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeJobErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DescribeJobErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            DescribeJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeJobErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeVault` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeVaultError {
    /// Kind of error that occurred.
    pub kind: DescribeVaultErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeVault` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeVaultErrorKind {
    /// <p>Returned if a parameter of the request is incorrectly specified.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Returned if a required header or parameter is missing from the request.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>Returned if the specified resource (such as a vault, upload ID, or job ID) doesn't
    /// exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Returned if the service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeVaultError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeVaultErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DescribeVaultErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            DescribeVaultErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeVaultErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeVaultErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeVaultError {
    fn code(&self) -> Option<&str> {
        DescribeVaultError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeVaultError {
    /// Creates a new `DescribeVaultError`.
    pub fn new(kind: DescribeVaultErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeVaultError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeVaultErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeVaultError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeVaultErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeVaultErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVaultErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeVaultErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVaultErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeVaultErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVaultErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeVaultErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVaultErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DescribeVaultError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeVaultErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DescribeVaultErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            DescribeVaultErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeVaultErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeVaultErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDataRetrievalPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDataRetrievalPolicyError {
    /// Kind of error that occurred.
    pub kind: GetDataRetrievalPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDataRetrievalPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDataRetrievalPolicyErrorKind {
    /// <p>Returned if a parameter of the request is incorrectly specified.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Returned if a required header or parameter is missing from the request.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>Returned if the service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDataRetrievalPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDataRetrievalPolicyErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            GetDataRetrievalPolicyErrorKind::MissingParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            GetDataRetrievalPolicyErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetDataRetrievalPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDataRetrievalPolicyError {
    fn code(&self) -> Option<&str> {
        GetDataRetrievalPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDataRetrievalPolicyError {
    /// Creates a new `GetDataRetrievalPolicyError`.
    pub fn new(kind: GetDataRetrievalPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDataRetrievalPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDataRetrievalPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDataRetrievalPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDataRetrievalPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDataRetrievalPolicyErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDataRetrievalPolicyErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDataRetrievalPolicyErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDataRetrievalPolicyErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDataRetrievalPolicyErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDataRetrievalPolicyErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for GetDataRetrievalPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDataRetrievalPolicyErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            GetDataRetrievalPolicyErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            GetDataRetrievalPolicyErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetDataRetrievalPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetJobOutput` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetJobOutputError {
    /// Kind of error that occurred.
    pub kind: GetJobOutputErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetJobOutput` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetJobOutputErrorKind {
    /// <p>Returned if a parameter of the request is incorrectly specified.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Returned if a required header or parameter is missing from the request.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>Returned if the specified resource (such as a vault, upload ID, or job ID) doesn't
    /// exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Returned if the service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetJobOutputError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetJobOutputErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            GetJobOutputErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            GetJobOutputErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetJobOutputErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetJobOutputErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetJobOutputError {
    fn code(&self) -> Option<&str> {
        GetJobOutputError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetJobOutputError {
    /// Creates a new `GetJobOutputError`.
    pub fn new(kind: GetJobOutputErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetJobOutputError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetJobOutputErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetJobOutputError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetJobOutputErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetJobOutputErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJobOutputErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetJobOutputErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJobOutputErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetJobOutputErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJobOutputErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetJobOutputErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJobOutputErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for GetJobOutputError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetJobOutputErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            GetJobOutputErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            GetJobOutputErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetJobOutputErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetJobOutputErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetVaultAccessPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetVaultAccessPolicyError {
    /// Kind of error that occurred.
    pub kind: GetVaultAccessPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetVaultAccessPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetVaultAccessPolicyErrorKind {
    /// <p>Returned if a parameter of the request is incorrectly specified.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Returned if a required header or parameter is missing from the request.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>Returned if the specified resource (such as a vault, upload ID, or job ID) doesn't
    /// exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Returned if the service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetVaultAccessPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetVaultAccessPolicyErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            GetVaultAccessPolicyErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            GetVaultAccessPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetVaultAccessPolicyErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetVaultAccessPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetVaultAccessPolicyError {
    fn code(&self) -> Option<&str> {
        GetVaultAccessPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetVaultAccessPolicyError {
    /// Creates a new `GetVaultAccessPolicyError`.
    pub fn new(kind: GetVaultAccessPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetVaultAccessPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetVaultAccessPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetVaultAccessPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetVaultAccessPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetVaultAccessPolicyErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVaultAccessPolicyErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVaultAccessPolicyErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVaultAccessPolicyErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVaultAccessPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVaultAccessPolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVaultAccessPolicyErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVaultAccessPolicyErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for GetVaultAccessPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetVaultAccessPolicyErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            GetVaultAccessPolicyErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            GetVaultAccessPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetVaultAccessPolicyErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetVaultAccessPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetVaultLock` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetVaultLockError {
    /// Kind of error that occurred.
    pub kind: GetVaultLockErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetVaultLock` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetVaultLockErrorKind {
    /// <p>Returned if a parameter of the request is incorrectly specified.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Returned if a required header or parameter is missing from the request.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>Returned if the specified resource (such as a vault, upload ID, or job ID) doesn't
    /// exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Returned if the service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetVaultLockError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetVaultLockErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            GetVaultLockErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            GetVaultLockErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetVaultLockErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetVaultLockErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetVaultLockError {
    fn code(&self) -> Option<&str> {
        GetVaultLockError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetVaultLockError {
    /// Creates a new `GetVaultLockError`.
    pub fn new(kind: GetVaultLockErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetVaultLockError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetVaultLockErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetVaultLockError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetVaultLockErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetVaultLockErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVaultLockErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVaultLockErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVaultLockErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVaultLockErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVaultLockErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVaultLockErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVaultLockErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for GetVaultLockError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetVaultLockErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            GetVaultLockErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            GetVaultLockErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetVaultLockErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetVaultLockErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetVaultNotifications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetVaultNotificationsError {
    /// Kind of error that occurred.
    pub kind: GetVaultNotificationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetVaultNotifications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetVaultNotificationsErrorKind {
    /// <p>Returned if a parameter of the request is incorrectly specified.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Returned if a required header or parameter is missing from the request.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>Returned if the specified resource (such as a vault, upload ID, or job ID) doesn't
    /// exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Returned if the service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetVaultNotificationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetVaultNotificationsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            GetVaultNotificationsErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            GetVaultNotificationsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetVaultNotificationsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetVaultNotificationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetVaultNotificationsError {
    fn code(&self) -> Option<&str> {
        GetVaultNotificationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetVaultNotificationsError {
    /// Creates a new `GetVaultNotificationsError`.
    pub fn new(kind: GetVaultNotificationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetVaultNotificationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetVaultNotificationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetVaultNotificationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetVaultNotificationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetVaultNotificationsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVaultNotificationsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVaultNotificationsErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVaultNotificationsErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVaultNotificationsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVaultNotificationsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetVaultNotificationsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVaultNotificationsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for GetVaultNotificationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetVaultNotificationsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            GetVaultNotificationsErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            GetVaultNotificationsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetVaultNotificationsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetVaultNotificationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `InitiateJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct InitiateJobError {
    /// Kind of error that occurred.
    pub kind: InitiateJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `InitiateJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum InitiateJobErrorKind {
    /// <p>Returned if there is insufficient capacity to process this expedited request. This
    /// error only applies to expedited retrievals and not to standard or bulk
    /// retrievals.</p>
    InsufficientCapacityException(crate::error::InsufficientCapacityException),
    /// <p>Returned if a parameter of the request is incorrectly specified.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Returned if a required header or parameter is missing from the request.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>Returned if a retrieval job would exceed the current data policy's retrieval rate
    /// limit. For more information about data retrieval policies,</p>
    PolicyEnforcedException(crate::error::PolicyEnforcedException),
    /// <p>Returned if the specified resource (such as a vault, upload ID, or job ID) doesn't
    /// exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Returned if the service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for InitiateJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            InitiateJobErrorKind::InsufficientCapacityException(_inner) => _inner.fmt(f),
            InitiateJobErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            InitiateJobErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            InitiateJobErrorKind::PolicyEnforcedException(_inner) => _inner.fmt(f),
            InitiateJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            InitiateJobErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            InitiateJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for InitiateJobError {
    fn code(&self) -> Option<&str> {
        InitiateJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl InitiateJobError {
    /// Creates a new `InitiateJobError`.
    pub fn new(kind: InitiateJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `InitiateJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: InitiateJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `InitiateJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: InitiateJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `InitiateJobErrorKind::InsufficientCapacityException`.
    pub fn is_insufficient_capacity_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitiateJobErrorKind::InsufficientCapacityException(_)
        )
    }
    /// Returns `true` if the error kind is `InitiateJobErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitiateJobErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `InitiateJobErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitiateJobErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `InitiateJobErrorKind::PolicyEnforcedException`.
    pub fn is_policy_enforced_exception(&self) -> bool {
        matches!(&self.kind, InitiateJobErrorKind::PolicyEnforcedException(_))
    }
    /// Returns `true` if the error kind is `InitiateJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitiateJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `InitiateJobErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitiateJobErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for InitiateJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            InitiateJobErrorKind::InsufficientCapacityException(_inner) => Some(_inner),
            InitiateJobErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            InitiateJobErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            InitiateJobErrorKind::PolicyEnforcedException(_inner) => Some(_inner),
            InitiateJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            InitiateJobErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            InitiateJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `InitiateMultipartUpload` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct InitiateMultipartUploadError {
    /// Kind of error that occurred.
    pub kind: InitiateMultipartUploadErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `InitiateMultipartUpload` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum InitiateMultipartUploadErrorKind {
    /// <p>Returned if a parameter of the request is incorrectly specified.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Returned if a required header or parameter is missing from the request.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>Returned if the specified resource (such as a vault, upload ID, or job ID) doesn't
    /// exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Returned if the service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for InitiateMultipartUploadError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            InitiateMultipartUploadErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            InitiateMultipartUploadErrorKind::MissingParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            InitiateMultipartUploadErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            InitiateMultipartUploadErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            InitiateMultipartUploadErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for InitiateMultipartUploadError {
    fn code(&self) -> Option<&str> {
        InitiateMultipartUploadError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl InitiateMultipartUploadError {
    /// Creates a new `InitiateMultipartUploadError`.
    pub fn new(kind: InitiateMultipartUploadErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `InitiateMultipartUploadError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: InitiateMultipartUploadErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `InitiateMultipartUploadError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: InitiateMultipartUploadErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `InitiateMultipartUploadErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitiateMultipartUploadErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `InitiateMultipartUploadErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitiateMultipartUploadErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `InitiateMultipartUploadErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitiateMultipartUploadErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `InitiateMultipartUploadErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitiateMultipartUploadErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for InitiateMultipartUploadError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            InitiateMultipartUploadErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            InitiateMultipartUploadErrorKind::MissingParameterValueException(_inner) => {
                Some(_inner)
            }
            InitiateMultipartUploadErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            InitiateMultipartUploadErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            InitiateMultipartUploadErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `InitiateVaultLock` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct InitiateVaultLockError {
    /// Kind of error that occurred.
    pub kind: InitiateVaultLockErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `InitiateVaultLock` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum InitiateVaultLockErrorKind {
    /// <p>Returned if a parameter of the request is incorrectly specified.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Returned if a required header or parameter is missing from the request.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>Returned if the specified resource (such as a vault, upload ID, or job ID) doesn't
    /// exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Returned if the service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for InitiateVaultLockError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            InitiateVaultLockErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            InitiateVaultLockErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            InitiateVaultLockErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            InitiateVaultLockErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            InitiateVaultLockErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for InitiateVaultLockError {
    fn code(&self) -> Option<&str> {
        InitiateVaultLockError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl InitiateVaultLockError {
    /// Creates a new `InitiateVaultLockError`.
    pub fn new(kind: InitiateVaultLockErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `InitiateVaultLockError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: InitiateVaultLockErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `InitiateVaultLockError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: InitiateVaultLockErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `InitiateVaultLockErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitiateVaultLockErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `InitiateVaultLockErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitiateVaultLockErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `InitiateVaultLockErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitiateVaultLockErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `InitiateVaultLockErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitiateVaultLockErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for InitiateVaultLockError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            InitiateVaultLockErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            InitiateVaultLockErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            InitiateVaultLockErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            InitiateVaultLockErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            InitiateVaultLockErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListJobsError {
    /// Kind of error that occurred.
    pub kind: ListJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListJobsErrorKind {
    /// <p>Returned if a parameter of the request is incorrectly specified.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Returned if a required header or parameter is missing from the request.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>Returned if the specified resource (such as a vault, upload ID, or job ID) doesn't
    /// exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Returned if the service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListJobsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListJobsErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            ListJobsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListJobsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListJobsError {
    fn code(&self) -> Option<&str> {
        ListJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListJobsError {
    /// Creates a new `ListJobsError`.
    pub fn new(kind: ListJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListJobsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListJobsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListJobsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListJobsErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListJobsErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListJobsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListJobsErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListJobsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListJobsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListJobsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListJobsErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            ListJobsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListJobsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListMultipartUploads` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListMultipartUploadsError {
    /// Kind of error that occurred.
    pub kind: ListMultipartUploadsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListMultipartUploads` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListMultipartUploadsErrorKind {
    /// <p>Returned if a parameter of the request is incorrectly specified.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Returned if a required header or parameter is missing from the request.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>Returned if the specified resource (such as a vault, upload ID, or job ID) doesn't
    /// exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Returned if the service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListMultipartUploadsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListMultipartUploadsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListMultipartUploadsErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            ListMultipartUploadsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListMultipartUploadsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListMultipartUploadsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListMultipartUploadsError {
    fn code(&self) -> Option<&str> {
        ListMultipartUploadsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListMultipartUploadsError {
    /// Creates a new `ListMultipartUploadsError`.
    pub fn new(kind: ListMultipartUploadsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListMultipartUploadsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListMultipartUploadsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListMultipartUploadsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListMultipartUploadsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListMultipartUploadsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMultipartUploadsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMultipartUploadsErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMultipartUploadsErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMultipartUploadsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMultipartUploadsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMultipartUploadsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMultipartUploadsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListMultipartUploadsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListMultipartUploadsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListMultipartUploadsErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            ListMultipartUploadsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListMultipartUploadsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListMultipartUploadsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListParts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPartsError {
    /// Kind of error that occurred.
    pub kind: ListPartsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListParts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPartsErrorKind {
    /// <p>Returned if a parameter of the request is incorrectly specified.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Returned if a required header or parameter is missing from the request.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>Returned if the specified resource (such as a vault, upload ID, or job ID) doesn't
    /// exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Returned if the service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPartsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPartsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListPartsErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            ListPartsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListPartsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListPartsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPartsError {
    fn code(&self) -> Option<&str> {
        ListPartsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPartsError {
    /// Creates a new `ListPartsError`.
    pub fn new(kind: ListPartsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPartsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPartsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPartsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPartsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPartsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPartsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPartsErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPartsErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPartsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListPartsErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListPartsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPartsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListPartsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPartsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListPartsErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            ListPartsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListPartsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListPartsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListProvisionedCapacity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListProvisionedCapacityError {
    /// Kind of error that occurred.
    pub kind: ListProvisionedCapacityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListProvisionedCapacity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListProvisionedCapacityErrorKind {
    /// <p>Returned if a parameter of the request is incorrectly specified.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Returned if a required header or parameter is missing from the request.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>Returned if the service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListProvisionedCapacityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListProvisionedCapacityErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            ListProvisionedCapacityErrorKind::MissingParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            ListProvisionedCapacityErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListProvisionedCapacityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListProvisionedCapacityError {
    fn code(&self) -> Option<&str> {
        ListProvisionedCapacityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListProvisionedCapacityError {
    /// Creates a new `ListProvisionedCapacityError`.
    pub fn new(kind: ListProvisionedCapacityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListProvisionedCapacityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListProvisionedCapacityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListProvisionedCapacityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListProvisionedCapacityErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListProvisionedCapacityErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProvisionedCapacityErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProvisionedCapacityErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProvisionedCapacityErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProvisionedCapacityErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProvisionedCapacityErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListProvisionedCapacityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListProvisionedCapacityErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            ListProvisionedCapacityErrorKind::MissingParameterValueException(_inner) => {
                Some(_inner)
            }
            ListProvisionedCapacityErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListProvisionedCapacityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForVault` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForVaultError {
    /// Kind of error that occurred.
    pub kind: ListTagsForVaultErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForVault` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForVaultErrorKind {
    /// <p>Returned if a parameter of the request is incorrectly specified.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Returned if a required header or parameter is missing from the request.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>Returned if the specified resource (such as a vault, upload ID, or job ID) doesn't
    /// exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Returned if the service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForVaultError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForVaultErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListTagsForVaultErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            ListTagsForVaultErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForVaultErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListTagsForVaultErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForVaultError {
    fn code(&self) -> Option<&str> {
        ListTagsForVaultError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForVaultError {
    /// Creates a new `ListTagsForVaultError`.
    pub fn new(kind: ListTagsForVaultErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForVaultError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForVaultErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForVaultError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForVaultErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForVaultErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForVaultErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForVaultErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForVaultErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForVaultErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForVaultErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForVaultErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForVaultErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListTagsForVaultError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForVaultErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListTagsForVaultErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            ListTagsForVaultErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForVaultErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListTagsForVaultErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListVaults` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListVaultsError {
    /// Kind of error that occurred.
    pub kind: ListVaultsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListVaults` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListVaultsErrorKind {
    /// <p>Returned if a parameter of the request is incorrectly specified.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Returned if a required header or parameter is missing from the request.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>Returned if the specified resource (such as a vault, upload ID, or job ID) doesn't
    /// exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Returned if the service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListVaultsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListVaultsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListVaultsErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            ListVaultsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListVaultsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListVaultsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListVaultsError {
    fn code(&self) -> Option<&str> {
        ListVaultsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListVaultsError {
    /// Creates a new `ListVaultsError`.
    pub fn new(kind: ListVaultsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListVaultsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListVaultsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListVaultsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListVaultsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListVaultsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVaultsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListVaultsErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVaultsErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListVaultsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVaultsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListVaultsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVaultsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListVaultsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListVaultsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListVaultsErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            ListVaultsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListVaultsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListVaultsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PurchaseProvisionedCapacity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PurchaseProvisionedCapacityError {
    /// Kind of error that occurred.
    pub kind: PurchaseProvisionedCapacityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PurchaseProvisionedCapacity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PurchaseProvisionedCapacityErrorKind {
    /// <p>Returned if a parameter of the request is incorrectly specified.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Returned if the request results in a vault or account limit being exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Returned if a required header or parameter is missing from the request.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>Returned if the service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PurchaseProvisionedCapacityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PurchaseProvisionedCapacityErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            PurchaseProvisionedCapacityErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PurchaseProvisionedCapacityErrorKind::MissingParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            PurchaseProvisionedCapacityErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            PurchaseProvisionedCapacityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PurchaseProvisionedCapacityError {
    fn code(&self) -> Option<&str> {
        PurchaseProvisionedCapacityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PurchaseProvisionedCapacityError {
    /// Creates a new `PurchaseProvisionedCapacityError`.
    pub fn new(kind: PurchaseProvisionedCapacityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PurchaseProvisionedCapacityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PurchaseProvisionedCapacityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PurchaseProvisionedCapacityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PurchaseProvisionedCapacityErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PurchaseProvisionedCapacityErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseProvisionedCapacityErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `PurchaseProvisionedCapacityErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseProvisionedCapacityErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PurchaseProvisionedCapacityErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseProvisionedCapacityErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `PurchaseProvisionedCapacityErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseProvisionedCapacityErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for PurchaseProvisionedCapacityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PurchaseProvisionedCapacityErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            PurchaseProvisionedCapacityErrorKind::LimitExceededException(_inner) => Some(_inner),
            PurchaseProvisionedCapacityErrorKind::MissingParameterValueException(_inner) => {
                Some(_inner)
            }
            PurchaseProvisionedCapacityErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            PurchaseProvisionedCapacityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveTagsFromVault` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveTagsFromVaultError {
    /// Kind of error that occurred.
    pub kind: RemoveTagsFromVaultErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveTagsFromVault` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveTagsFromVaultErrorKind {
    /// <p>Returned if a parameter of the request is incorrectly specified.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Returned if a required header or parameter is missing from the request.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>Returned if the specified resource (such as a vault, upload ID, or job ID) doesn't
    /// exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Returned if the service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveTagsFromVaultError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveTagsFromVaultErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            RemoveTagsFromVaultErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            RemoveTagsFromVaultErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RemoveTagsFromVaultErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            RemoveTagsFromVaultErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveTagsFromVaultError {
    fn code(&self) -> Option<&str> {
        RemoveTagsFromVaultError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveTagsFromVaultError {
    /// Creates a new `RemoveTagsFromVaultError`.
    pub fn new(kind: RemoveTagsFromVaultErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveTagsFromVaultError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveTagsFromVaultErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveTagsFromVaultError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveTagsFromVaultErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveTagsFromVaultErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromVaultErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveTagsFromVaultErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromVaultErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveTagsFromVaultErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromVaultErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveTagsFromVaultErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromVaultErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for RemoveTagsFromVaultError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveTagsFromVaultErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            RemoveTagsFromVaultErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            RemoveTagsFromVaultErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RemoveTagsFromVaultErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            RemoveTagsFromVaultErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetDataRetrievalPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetDataRetrievalPolicyError {
    /// Kind of error that occurred.
    pub kind: SetDataRetrievalPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetDataRetrievalPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetDataRetrievalPolicyErrorKind {
    /// <p>Returned if a parameter of the request is incorrectly specified.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Returned if a required header or parameter is missing from the request.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>Returned if the service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetDataRetrievalPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetDataRetrievalPolicyErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            SetDataRetrievalPolicyErrorKind::MissingParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            SetDataRetrievalPolicyErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            SetDataRetrievalPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetDataRetrievalPolicyError {
    fn code(&self) -> Option<&str> {
        SetDataRetrievalPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetDataRetrievalPolicyError {
    /// Creates a new `SetDataRetrievalPolicyError`.
    pub fn new(kind: SetDataRetrievalPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetDataRetrievalPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetDataRetrievalPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetDataRetrievalPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetDataRetrievalPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SetDataRetrievalPolicyErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetDataRetrievalPolicyErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `SetDataRetrievalPolicyErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetDataRetrievalPolicyErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `SetDataRetrievalPolicyErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetDataRetrievalPolicyErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for SetDataRetrievalPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetDataRetrievalPolicyErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            SetDataRetrievalPolicyErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            SetDataRetrievalPolicyErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            SetDataRetrievalPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetVaultAccessPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetVaultAccessPolicyError {
    /// Kind of error that occurred.
    pub kind: SetVaultAccessPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetVaultAccessPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetVaultAccessPolicyErrorKind {
    /// <p>Returned if a parameter of the request is incorrectly specified.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Returned if a required header or parameter is missing from the request.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>Returned if the specified resource (such as a vault, upload ID, or job ID) doesn't
    /// exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Returned if the service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetVaultAccessPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetVaultAccessPolicyErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            SetVaultAccessPolicyErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            SetVaultAccessPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            SetVaultAccessPolicyErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            SetVaultAccessPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetVaultAccessPolicyError {
    fn code(&self) -> Option<&str> {
        SetVaultAccessPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetVaultAccessPolicyError {
    /// Creates a new `SetVaultAccessPolicyError`.
    pub fn new(kind: SetVaultAccessPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetVaultAccessPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetVaultAccessPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetVaultAccessPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetVaultAccessPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SetVaultAccessPolicyErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetVaultAccessPolicyErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `SetVaultAccessPolicyErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetVaultAccessPolicyErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `SetVaultAccessPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetVaultAccessPolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SetVaultAccessPolicyErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetVaultAccessPolicyErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for SetVaultAccessPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetVaultAccessPolicyErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            SetVaultAccessPolicyErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            SetVaultAccessPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            SetVaultAccessPolicyErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            SetVaultAccessPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetVaultNotifications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetVaultNotificationsError {
    /// Kind of error that occurred.
    pub kind: SetVaultNotificationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetVaultNotifications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetVaultNotificationsErrorKind {
    /// <p>Returned if a parameter of the request is incorrectly specified.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Returned if a required header or parameter is missing from the request.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>Returned if the specified resource (such as a vault, upload ID, or job ID) doesn't
    /// exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Returned if the service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetVaultNotificationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetVaultNotificationsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            SetVaultNotificationsErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            SetVaultNotificationsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            SetVaultNotificationsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            SetVaultNotificationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetVaultNotificationsError {
    fn code(&self) -> Option<&str> {
        SetVaultNotificationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetVaultNotificationsError {
    /// Creates a new `SetVaultNotificationsError`.
    pub fn new(kind: SetVaultNotificationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetVaultNotificationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetVaultNotificationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetVaultNotificationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetVaultNotificationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SetVaultNotificationsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetVaultNotificationsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `SetVaultNotificationsErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetVaultNotificationsErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `SetVaultNotificationsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetVaultNotificationsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SetVaultNotificationsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetVaultNotificationsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for SetVaultNotificationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetVaultNotificationsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            SetVaultNotificationsErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            SetVaultNotificationsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            SetVaultNotificationsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            SetVaultNotificationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UploadArchive` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UploadArchiveError {
    /// Kind of error that occurred.
    pub kind: UploadArchiveErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UploadArchive` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UploadArchiveErrorKind {
    /// <p>Returned if a parameter of the request is incorrectly specified.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Returned if a required header or parameter is missing from the request.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>Returned if, when uploading an archive, Amazon S3 Glacier times out while receiving the
    /// upload.</p>
    RequestTimeoutException(crate::error::RequestTimeoutException),
    /// <p>Returned if the specified resource (such as a vault, upload ID, or job ID) doesn't
    /// exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Returned if the service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UploadArchiveError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UploadArchiveErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UploadArchiveErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            UploadArchiveErrorKind::RequestTimeoutException(_inner) => _inner.fmt(f),
            UploadArchiveErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UploadArchiveErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UploadArchiveErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UploadArchiveError {
    fn code(&self) -> Option<&str> {
        UploadArchiveError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UploadArchiveError {
    /// Creates a new `UploadArchiveError`.
    pub fn new(kind: UploadArchiveErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UploadArchiveError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UploadArchiveErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UploadArchiveError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UploadArchiveErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UploadArchiveErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadArchiveErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UploadArchiveErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadArchiveErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UploadArchiveErrorKind::RequestTimeoutException`.
    pub fn is_request_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadArchiveErrorKind::RequestTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `UploadArchiveErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadArchiveErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UploadArchiveErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadArchiveErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for UploadArchiveError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UploadArchiveErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UploadArchiveErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            UploadArchiveErrorKind::RequestTimeoutException(_inner) => Some(_inner),
            UploadArchiveErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UploadArchiveErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UploadArchiveErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UploadMultipartPart` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UploadMultipartPartError {
    /// Kind of error that occurred.
    pub kind: UploadMultipartPartErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UploadMultipartPart` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UploadMultipartPartErrorKind {
    /// <p>Returned if a parameter of the request is incorrectly specified.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Returned if a required header or parameter is missing from the request.</p>
    MissingParameterValueException(crate::error::MissingParameterValueException),
    /// <p>Returned if, when uploading an archive, Amazon S3 Glacier times out while receiving the
    /// upload.</p>
    RequestTimeoutException(crate::error::RequestTimeoutException),
    /// <p>Returned if the specified resource (such as a vault, upload ID, or job ID) doesn't
    /// exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Returned if the service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UploadMultipartPartError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UploadMultipartPartErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UploadMultipartPartErrorKind::MissingParameterValueException(_inner) => _inner.fmt(f),
            UploadMultipartPartErrorKind::RequestTimeoutException(_inner) => _inner.fmt(f),
            UploadMultipartPartErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UploadMultipartPartErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UploadMultipartPartErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UploadMultipartPartError {
    fn code(&self) -> Option<&str> {
        UploadMultipartPartError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UploadMultipartPartError {
    /// Creates a new `UploadMultipartPartError`.
    pub fn new(kind: UploadMultipartPartErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UploadMultipartPartError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UploadMultipartPartErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UploadMultipartPartError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UploadMultipartPartErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UploadMultipartPartErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadMultipartPartErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UploadMultipartPartErrorKind::MissingParameterValueException`.
    pub fn is_missing_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadMultipartPartErrorKind::MissingParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UploadMultipartPartErrorKind::RequestTimeoutException`.
    pub fn is_request_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadMultipartPartErrorKind::RequestTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `UploadMultipartPartErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadMultipartPartErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UploadMultipartPartErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadMultipartPartErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for UploadMultipartPartError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UploadMultipartPartErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UploadMultipartPartErrorKind::MissingParameterValueException(_inner) => Some(_inner),
            UploadMultipartPartErrorKind::RequestTimeoutException(_inner) => Some(_inner),
            UploadMultipartPartErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UploadMultipartPartErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UploadMultipartPartErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>Returned if the service cannot complete the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceUnavailableException {
    /// <p>Server</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>500 Internal Server Error</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>Returned if the service cannot complete the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceUnavailableException");
        formatter.field("r#type", &self.r#type);
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceUnavailableException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceUnavailableException {}
/// See [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
pub mod service_unavailable_exception {
    /// A builder for [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Server</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>Server</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>500 Internal Server Error</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>500 Internal Server Error</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>Returned if the service cannot complete the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Returned if the service cannot complete the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
        pub fn build(self) -> crate::error::ServiceUnavailableException {
            crate::error::ServiceUnavailableException {
                r#type: self.r#type,
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl ServiceUnavailableException {
    /// Creates a new builder-style object to manufacture [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    pub fn builder() -> crate::error::service_unavailable_exception::Builder {
        crate::error::service_unavailable_exception::Builder::default()
    }
}

/// <p>Returned if the specified resource (such as a vault, upload ID, or job ID) doesn't
/// exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    /// <p>Client</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>404 Not Found</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>Returned if the specified resource (such as a vault, upload ID, or job ID) doesn't
    /// exist.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("r#type", &self.r#type);
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Client</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>Client</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>404 Not Found</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>404 Not Found</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>Returned if the specified resource (such as a vault, upload ID, or job ID) doesn't
        /// exist.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Returned if the specified resource (such as a vault, upload ID, or job ID) doesn't
        /// exist.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                r#type: self.r#type,
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>Returned if, when uploading an archive, Amazon S3 Glacier times out while receiving the
/// upload.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestTimeoutException {
    /// <p>Client</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>408 Request Timeout</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>Returned if, when uploading an archive, Amazon S3 Glacier times out while receiving the
    /// upload.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RequestTimeoutException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequestTimeoutException");
        formatter.field("r#type", &self.r#type);
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RequestTimeoutException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RequestTimeoutException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RequestTimeoutException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for RequestTimeoutException {}
/// See [`RequestTimeoutException`](crate::error::RequestTimeoutException)
pub mod request_timeout_exception {
    /// A builder for [`RequestTimeoutException`](crate::error::RequestTimeoutException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Client</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>Client</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>408 Request Timeout</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>408 Request Timeout</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>Returned if, when uploading an archive, Amazon S3 Glacier times out while receiving the
        /// upload.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Returned if, when uploading an archive, Amazon S3 Glacier times out while receiving the
        /// upload.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestTimeoutException`](crate::error::RequestTimeoutException)
        pub fn build(self) -> crate::error::RequestTimeoutException {
            crate::error::RequestTimeoutException {
                r#type: self.r#type,
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl RequestTimeoutException {
    /// Creates a new builder-style object to manufacture [`RequestTimeoutException`](crate::error::RequestTimeoutException)
    pub fn builder() -> crate::error::request_timeout_exception::Builder {
        crate::error::request_timeout_exception::Builder::default()
    }
}

/// <p>Returned if a required header or parameter is missing from the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MissingParameterValueException {
    /// <p>Client.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>400 Bad Request</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>Returned if no authentication data is found for the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MissingParameterValueException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MissingParameterValueException");
        formatter.field("r#type", &self.r#type);
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MissingParameterValueException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MissingParameterValueException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MissingParameterValueException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for MissingParameterValueException {}
/// See [`MissingParameterValueException`](crate::error::MissingParameterValueException)
pub mod missing_parameter_value_exception {
    /// A builder for [`MissingParameterValueException`](crate::error::MissingParameterValueException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Client.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>Client.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>400 Bad Request</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>400 Bad Request</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>Returned if no authentication data is found for the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Returned if no authentication data is found for the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MissingParameterValueException`](crate::error::MissingParameterValueException)
        pub fn build(self) -> crate::error::MissingParameterValueException {
            crate::error::MissingParameterValueException {
                r#type: self.r#type,
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl MissingParameterValueException {
    /// Creates a new builder-style object to manufacture [`MissingParameterValueException`](crate::error::MissingParameterValueException)
    pub fn builder() -> crate::error::missing_parameter_value_exception::Builder {
        crate::error::missing_parameter_value_exception::Builder::default()
    }
}

/// <p>Returned if a parameter of the request is incorrectly specified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterValueException {
    /// <p>Client</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>400 Bad Request</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>Returned if a parameter of the request is incorrectly specified.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidParameterValueException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterValueException");
        formatter.field("r#type", &self.r#type);
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidParameterValueException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterValueException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterValueException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterValueException {}
/// See [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
pub mod invalid_parameter_value_exception {
    /// A builder for [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Client</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>Client</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>400 Bad Request</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>400 Bad Request</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>Returned if a parameter of the request is incorrectly specified.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Returned if a parameter of the request is incorrectly specified.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
        pub fn build(self) -> crate::error::InvalidParameterValueException {
            crate::error::InvalidParameterValueException {
                r#type: self.r#type,
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl InvalidParameterValueException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
    pub fn builder() -> crate::error::invalid_parameter_value_exception::Builder {
        crate::error::invalid_parameter_value_exception::Builder::default()
    }
}

/// <p>Returned if the request results in a vault or account limit being exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    /// <p>Client</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>400 Bad Request</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>Returned if the request results in a vault limit or tags limit being exceeded.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("r#type", &self.r#type);
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Client</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>Client</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>400 Bad Request</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>400 Bad Request</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>Returned if the request results in a vault limit or tags limit being exceeded.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Returned if the request results in a vault limit or tags limit being exceeded.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                r#type: self.r#type,
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>Returned if a retrieval job would exceed the current data policy's retrieval rate
/// limit. For more information about data retrieval policies,</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyEnforcedException {
    /// <p>Client</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>PolicyEnforcedException</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>InitiateJob request denied by current data retrieval policy.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PolicyEnforcedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyEnforcedException");
        formatter.field("r#type", &self.r#type);
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PolicyEnforcedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PolicyEnforcedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PolicyEnforcedException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for PolicyEnforcedException {}
/// See [`PolicyEnforcedException`](crate::error::PolicyEnforcedException)
pub mod policy_enforced_exception {
    /// A builder for [`PolicyEnforcedException`](crate::error::PolicyEnforcedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Client</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>Client</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>PolicyEnforcedException</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>PolicyEnforcedException</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>InitiateJob request denied by current data retrieval policy.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>InitiateJob request denied by current data retrieval policy.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyEnforcedException`](crate::error::PolicyEnforcedException)
        pub fn build(self) -> crate::error::PolicyEnforcedException {
            crate::error::PolicyEnforcedException {
                r#type: self.r#type,
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl PolicyEnforcedException {
    /// Creates a new builder-style object to manufacture [`PolicyEnforcedException`](crate::error::PolicyEnforcedException)
    pub fn builder() -> crate::error::policy_enforced_exception::Builder {
        crate::error::policy_enforced_exception::Builder::default()
    }
}

/// <p>Returned if there is insufficient capacity to process this expedited request. This
/// error only applies to expedited retrievals and not to standard or bulk
/// retrievals.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsufficientCapacityException {
    #[allow(missing_docs)] // documentation missing in model
    pub r#type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InsufficientCapacityException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsufficientCapacityException");
        formatter.field("r#type", &self.r#type);
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InsufficientCapacityException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InsufficientCapacityException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InsufficientCapacityException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for InsufficientCapacityException {}
/// See [`InsufficientCapacityException`](crate::error::InsufficientCapacityException)
pub mod insufficient_capacity_exception {
    /// A builder for [`InsufficientCapacityException`](crate::error::InsufficientCapacityException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InsufficientCapacityException`](crate::error::InsufficientCapacityException)
        pub fn build(self) -> crate::error::InsufficientCapacityException {
            crate::error::InsufficientCapacityException {
                r#type: self.r#type,
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl InsufficientCapacityException {
    /// Creates a new builder-style object to manufacture [`InsufficientCapacityException`](crate::error::InsufficientCapacityException)
    pub fn builder() -> crate::error::insufficient_capacity_exception::Builder {
        crate::error::insufficient_capacity_exception::Builder::default()
    }
}
