// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateStageOutput {
    /// <p>Properties that provide details of the updated stage.</p>
    pub stage: std::option::Option<crate::model::StageDetails>,
}
impl UpdateStageOutput {
    /// <p>Properties that provide details of the updated stage.</p>
    pub fn stage(&self) -> std::option::Option<&crate::model::StageDetails> {
        self.stage.as_ref()
    }
}
impl std::fmt::Debug for UpdateStageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateStageOutput");
        formatter.field("stage", &self.stage);
        formatter.finish()
    }
}
/// See [`UpdateStageOutput`](crate::output::UpdateStageOutput)
pub mod update_stage_output {
    /// A builder for [`UpdateStageOutput`](crate::output::UpdateStageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stage: std::option::Option<crate::model::StageDetails>,
    }
    impl Builder {
        /// <p>Properties that provide details of the updated stage.</p>
        pub fn stage(mut self, input: crate::model::StageDetails) -> Self {
            self.stage = Some(input);
            self
        }
        /// <p>Properties that provide details of the updated stage.</p>
        pub fn set_stage(mut self, input: std::option::Option<crate::model::StageDetails>) -> Self {
            self.stage = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateStageOutput`](crate::output::UpdateStageOutput)
        pub fn build(self) -> crate::output::UpdateStageOutput {
            crate::output::UpdateStageOutput { stage: self.stage }
        }
    }
}
impl UpdateStageOutput {
    /// Creates a new builder-style object to manufacture [`UpdateStageOutput`](crate::output::UpdateStageOutput)
    pub fn builder() -> crate::output::update_stage_output::Builder {
        crate::output::update_stage_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSnapshotOutput {
    /// <p>Properties that provide details of the updated snapshot.</p>
    pub snapshot: std::option::Option<crate::model::SnapshotDetails>,
}
impl UpdateSnapshotOutput {
    /// <p>Properties that provide details of the updated snapshot.</p>
    pub fn snapshot(&self) -> std::option::Option<&crate::model::SnapshotDetails> {
        self.snapshot.as_ref()
    }
}
impl std::fmt::Debug for UpdateSnapshotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSnapshotOutput");
        formatter.field("snapshot", &self.snapshot);
        formatter.finish()
    }
}
/// See [`UpdateSnapshotOutput`](crate::output::UpdateSnapshotOutput)
pub mod update_snapshot_output {
    /// A builder for [`UpdateSnapshotOutput`](crate::output::UpdateSnapshotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot: std::option::Option<crate::model::SnapshotDetails>,
    }
    impl Builder {
        /// <p>Properties that provide details of the updated snapshot.</p>
        pub fn snapshot(mut self, input: crate::model::SnapshotDetails) -> Self {
            self.snapshot = Some(input);
            self
        }
        /// <p>Properties that provide details of the updated snapshot.</p>
        pub fn set_snapshot(
            mut self,
            input: std::option::Option<crate::model::SnapshotDetails>,
        ) -> Self {
            self.snapshot = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSnapshotOutput`](crate::output::UpdateSnapshotOutput)
        pub fn build(self) -> crate::output::UpdateSnapshotOutput {
            crate::output::UpdateSnapshotOutput {
                snapshot: self.snapshot,
            }
        }
    }
}
impl UpdateSnapshotOutput {
    /// Creates a new builder-style object to manufacture [`UpdateSnapshotOutput`](crate::output::UpdateSnapshotOutput)
    pub fn builder() -> crate::output::update_snapshot_output::Builder {
        crate::output::update_snapshot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGameConfigurationOutput {
    /// <p>Details about the game configuration.</p>
    pub game_configuration: std::option::Option<crate::model::GameConfigurationDetails>,
}
impl UpdateGameConfigurationOutput {
    /// <p>Details about the game configuration.</p>
    pub fn game_configuration(
        &self,
    ) -> std::option::Option<&crate::model::GameConfigurationDetails> {
        self.game_configuration.as_ref()
    }
}
impl std::fmt::Debug for UpdateGameConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGameConfigurationOutput");
        formatter.field("game_configuration", &self.game_configuration);
        formatter.finish()
    }
}
/// See [`UpdateGameConfigurationOutput`](crate::output::UpdateGameConfigurationOutput)
pub mod update_game_configuration_output {
    /// A builder for [`UpdateGameConfigurationOutput`](crate::output::UpdateGameConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_configuration: std::option::Option<crate::model::GameConfigurationDetails>,
    }
    impl Builder {
        /// <p>Details about the game configuration.</p>
        pub fn game_configuration(mut self, input: crate::model::GameConfigurationDetails) -> Self {
            self.game_configuration = Some(input);
            self
        }
        /// <p>Details about the game configuration.</p>
        pub fn set_game_configuration(
            mut self,
            input: std::option::Option<crate::model::GameConfigurationDetails>,
        ) -> Self {
            self.game_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGameConfigurationOutput`](crate::output::UpdateGameConfigurationOutput)
        pub fn build(self) -> crate::output::UpdateGameConfigurationOutput {
            crate::output::UpdateGameConfigurationOutput {
                game_configuration: self.game_configuration,
            }
        }
    }
}
impl UpdateGameConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateGameConfigurationOutput`](crate::output::UpdateGameConfigurationOutput)
    pub fn builder() -> crate::output::update_game_configuration_output::Builder {
        crate::output::update_game_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGameOutput {
    /// <p>The details of the game.</p>
    pub game: std::option::Option<crate::model::GameDetails>,
}
impl UpdateGameOutput {
    /// <p>The details of the game.</p>
    pub fn game(&self) -> std::option::Option<&crate::model::GameDetails> {
        self.game.as_ref()
    }
}
impl std::fmt::Debug for UpdateGameOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGameOutput");
        formatter.field("game", &self.game);
        formatter.finish()
    }
}
/// See [`UpdateGameOutput`](crate::output::UpdateGameOutput)
pub mod update_game_output {
    /// A builder for [`UpdateGameOutput`](crate::output::UpdateGameOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game: std::option::Option<crate::model::GameDetails>,
    }
    impl Builder {
        /// <p>The details of the game.</p>
        pub fn game(mut self, input: crate::model::GameDetails) -> Self {
            self.game = Some(input);
            self
        }
        /// <p>The details of the game.</p>
        pub fn set_game(mut self, input: std::option::Option<crate::model::GameDetails>) -> Self {
            self.game = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGameOutput`](crate::output::UpdateGameOutput)
        pub fn build(self) -> crate::output::UpdateGameOutput {
            crate::output::UpdateGameOutput { game: self.game }
        }
    }
}
impl UpdateGameOutput {
    /// Creates a new builder-style object to manufacture [`UpdateGameOutput`](crate::output::UpdateGameOutput)
    pub fn builder() -> crate::output::update_game_output::Builder {
        crate::output::update_game_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartStageDeploymentOutput {
    /// <p>Properties that describe the stage deployment.</p>
    pub stage_deployment: std::option::Option<crate::model::StageDeploymentDetails>,
}
impl StartStageDeploymentOutput {
    /// <p>Properties that describe the stage deployment.</p>
    pub fn stage_deployment(&self) -> std::option::Option<&crate::model::StageDeploymentDetails> {
        self.stage_deployment.as_ref()
    }
}
impl std::fmt::Debug for StartStageDeploymentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartStageDeploymentOutput");
        formatter.field("stage_deployment", &self.stage_deployment);
        formatter.finish()
    }
}
/// See [`StartStageDeploymentOutput`](crate::output::StartStageDeploymentOutput)
pub mod start_stage_deployment_output {
    /// A builder for [`StartStageDeploymentOutput`](crate::output::StartStageDeploymentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stage_deployment: std::option::Option<crate::model::StageDeploymentDetails>,
    }
    impl Builder {
        /// <p>Properties that describe the stage deployment.</p>
        pub fn stage_deployment(mut self, input: crate::model::StageDeploymentDetails) -> Self {
            self.stage_deployment = Some(input);
            self
        }
        /// <p>Properties that describe the stage deployment.</p>
        pub fn set_stage_deployment(
            mut self,
            input: std::option::Option<crate::model::StageDeploymentDetails>,
        ) -> Self {
            self.stage_deployment = input;
            self
        }
        /// Consumes the builder and constructs a [`StartStageDeploymentOutput`](crate::output::StartStageDeploymentOutput)
        pub fn build(self) -> crate::output::StartStageDeploymentOutput {
            crate::output::StartStageDeploymentOutput {
                stage_deployment: self.stage_deployment,
            }
        }
    }
}
impl StartStageDeploymentOutput {
    /// Creates a new builder-style object to manufacture [`StartStageDeploymentOutput`](crate::output::StartStageDeploymentOutput)
    pub fn builder() -> crate::output::start_stage_deployment_output::Builder {
        crate::output::start_stage_deployment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartGeneratedCodeJobOutput {
    /// <p> The identifier of the code generation job. You can use this identifier in the <code>GetGeneratedCodeJob</code> operation. </p>
    pub generated_code_job_id: std::option::Option<std::string::String>,
}
impl StartGeneratedCodeJobOutput {
    /// <p> The identifier of the code generation job. You can use this identifier in the <code>GetGeneratedCodeJob</code> operation. </p>
    pub fn generated_code_job_id(&self) -> std::option::Option<&str> {
        self.generated_code_job_id.as_deref()
    }
}
impl std::fmt::Debug for StartGeneratedCodeJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartGeneratedCodeJobOutput");
        formatter.field("generated_code_job_id", &self.generated_code_job_id);
        formatter.finish()
    }
}
/// See [`StartGeneratedCodeJobOutput`](crate::output::StartGeneratedCodeJobOutput)
pub mod start_generated_code_job_output {
    /// A builder for [`StartGeneratedCodeJobOutput`](crate::output::StartGeneratedCodeJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) generated_code_job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The identifier of the code generation job. You can use this identifier in the <code>GetGeneratedCodeJob</code> operation. </p>
        pub fn generated_code_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.generated_code_job_id = Some(input.into());
            self
        }
        /// <p> The identifier of the code generation job. You can use this identifier in the <code>GetGeneratedCodeJob</code> operation. </p>
        pub fn set_generated_code_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.generated_code_job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartGeneratedCodeJobOutput`](crate::output::StartGeneratedCodeJobOutput)
        pub fn build(self) -> crate::output::StartGeneratedCodeJobOutput {
            crate::output::StartGeneratedCodeJobOutput {
                generated_code_job_id: self.generated_code_job_id,
            }
        }
    }
}
impl StartGeneratedCodeJobOutput {
    /// Creates a new builder-style object to manufacture [`StartGeneratedCodeJobOutput`](crate::output::StartGeneratedCodeJobOutput)
    pub fn builder() -> crate::output::start_generated_code_job_output::Builder {
        crate::output::start_generated_code_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The tags associated with the resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// <p>The tags associated with the resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags associated with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStagesOutput {
    /// <p> A list of stage summaries. You can use the stage names in the <code>UpdateStage</code> and <code>GetStage</code> actions. </p>
    pub stages: std::option::Option<std::vec::Vec<crate::model::StageSummary>>,
    /// <p>The token that indicates the start of the next sequential page of results.</p>
    /// <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListStagesOutput {
    /// <p> A list of stage summaries. You can use the stage names in the <code>UpdateStage</code> and <code>GetStage</code> actions. </p>
    pub fn stages(&self) -> std::option::Option<&[crate::model::StageSummary]> {
        self.stages.as_deref()
    }
    /// <p>The token that indicates the start of the next sequential page of results.</p>
    /// <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListStagesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStagesOutput");
        formatter.field("stages", &self.stages);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListStagesOutput`](crate::output::ListStagesOutput)
pub mod list_stages_output {
    /// A builder for [`ListStagesOutput`](crate::output::ListStagesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stages: std::option::Option<std::vec::Vec<crate::model::StageSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `stages`.
        ///
        /// To override the contents of this collection use [`set_stages`](Self::set_stages).
        ///
        /// <p> A list of stage summaries. You can use the stage names in the <code>UpdateStage</code> and <code>GetStage</code> actions. </p>
        pub fn stages(mut self, input: crate::model::StageSummary) -> Self {
            let mut v = self.stages.unwrap_or_default();
            v.push(input);
            self.stages = Some(v);
            self
        }
        /// <p> A list of stage summaries. You can use the stage names in the <code>UpdateStage</code> and <code>GetStage</code> actions. </p>
        pub fn set_stages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StageSummary>>,
        ) -> Self {
            self.stages = input;
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStagesOutput`](crate::output::ListStagesOutput)
        pub fn build(self) -> crate::output::ListStagesOutput {
            crate::output::ListStagesOutput {
                stages: self.stages,
                next_token: self.next_token,
            }
        }
    }
}
impl ListStagesOutput {
    /// Creates a new builder-style object to manufacture [`ListStagesOutput`](crate::output::ListStagesOutput)
    pub fn builder() -> crate::output::list_stages_output::Builder {
        crate::output::list_stages_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStageDeploymentsOutput {
    /// <p> A list of stage deployment summaries. You can use the deployment IDs in the <code>UpdateStageDeployment</code> and <code>GetStageDeployment</code> actions. </p>
    pub stage_deployments: std::option::Option<std::vec::Vec<crate::model::StageDeploymentSummary>>,
    /// <p>The token that indicates the start of the next sequential page of results.</p>
    /// <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListStageDeploymentsOutput {
    /// <p> A list of stage deployment summaries. You can use the deployment IDs in the <code>UpdateStageDeployment</code> and <code>GetStageDeployment</code> actions. </p>
    pub fn stage_deployments(
        &self,
    ) -> std::option::Option<&[crate::model::StageDeploymentSummary]> {
        self.stage_deployments.as_deref()
    }
    /// <p>The token that indicates the start of the next sequential page of results.</p>
    /// <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListStageDeploymentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStageDeploymentsOutput");
        formatter.field("stage_deployments", &self.stage_deployments);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListStageDeploymentsOutput`](crate::output::ListStageDeploymentsOutput)
pub mod list_stage_deployments_output {
    /// A builder for [`ListStageDeploymentsOutput`](crate::output::ListStageDeploymentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stage_deployments:
            std::option::Option<std::vec::Vec<crate::model::StageDeploymentSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `stage_deployments`.
        ///
        /// To override the contents of this collection use [`set_stage_deployments`](Self::set_stage_deployments).
        ///
        /// <p> A list of stage deployment summaries. You can use the deployment IDs in the <code>UpdateStageDeployment</code> and <code>GetStageDeployment</code> actions. </p>
        pub fn stage_deployments(mut self, input: crate::model::StageDeploymentSummary) -> Self {
            let mut v = self.stage_deployments.unwrap_or_default();
            v.push(input);
            self.stage_deployments = Some(v);
            self
        }
        /// <p> A list of stage deployment summaries. You can use the deployment IDs in the <code>UpdateStageDeployment</code> and <code>GetStageDeployment</code> actions. </p>
        pub fn set_stage_deployments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StageDeploymentSummary>>,
        ) -> Self {
            self.stage_deployments = input;
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStageDeploymentsOutput`](crate::output::ListStageDeploymentsOutput)
        pub fn build(self) -> crate::output::ListStageDeploymentsOutput {
            crate::output::ListStageDeploymentsOutput {
                stage_deployments: self.stage_deployments,
                next_token: self.next_token,
            }
        }
    }
}
impl ListStageDeploymentsOutput {
    /// Creates a new builder-style object to manufacture [`ListStageDeploymentsOutput`](crate::output::ListStageDeploymentsOutput)
    pub fn builder() -> crate::output::list_stage_deployments_output::Builder {
        crate::output::list_stage_deployments_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSnapshotsOutput {
    /// <p> A list of snapshot summaries. You can use the returned snapshot IDs in the <code>UpdateSnapshot</code> and <code>GetSnapshot</code> operations. </p>
    pub snapshots: std::option::Option<std::vec::Vec<crate::model::SnapshotSummary>>,
    /// <p>The token that indicates the start of the next sequential page of results.</p>
    /// <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListSnapshotsOutput {
    /// <p> A list of snapshot summaries. You can use the returned snapshot IDs in the <code>UpdateSnapshot</code> and <code>GetSnapshot</code> operations. </p>
    pub fn snapshots(&self) -> std::option::Option<&[crate::model::SnapshotSummary]> {
        self.snapshots.as_deref()
    }
    /// <p>The token that indicates the start of the next sequential page of results.</p>
    /// <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListSnapshotsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSnapshotsOutput");
        formatter.field("snapshots", &self.snapshots);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListSnapshotsOutput`](crate::output::ListSnapshotsOutput)
pub mod list_snapshots_output {
    /// A builder for [`ListSnapshotsOutput`](crate::output::ListSnapshotsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshots: std::option::Option<std::vec::Vec<crate::model::SnapshotSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `snapshots`.
        ///
        /// To override the contents of this collection use [`set_snapshots`](Self::set_snapshots).
        ///
        /// <p> A list of snapshot summaries. You can use the returned snapshot IDs in the <code>UpdateSnapshot</code> and <code>GetSnapshot</code> operations. </p>
        pub fn snapshots(mut self, input: crate::model::SnapshotSummary) -> Self {
            let mut v = self.snapshots.unwrap_or_default();
            v.push(input);
            self.snapshots = Some(v);
            self
        }
        /// <p> A list of snapshot summaries. You can use the returned snapshot IDs in the <code>UpdateSnapshot</code> and <code>GetSnapshot</code> operations. </p>
        pub fn set_snapshots(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SnapshotSummary>>,
        ) -> Self {
            self.snapshots = input;
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSnapshotsOutput`](crate::output::ListSnapshotsOutput)
        pub fn build(self) -> crate::output::ListSnapshotsOutput {
            crate::output::ListSnapshotsOutput {
                snapshots: self.snapshots,
                next_token: self.next_token,
            }
        }
    }
}
impl ListSnapshotsOutput {
    /// Creates a new builder-style object to manufacture [`ListSnapshotsOutput`](crate::output::ListSnapshotsOutput)
    pub fn builder() -> crate::output::list_snapshots_output::Builder {
        crate::output::list_snapshots_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGeneratedCodeJobsOutput {
    /// <p>The list of generated code jobs.</p>
    pub generated_code_jobs:
        std::option::Option<std::vec::Vec<crate::model::GeneratedCodeJobDetails>>,
    /// <p>The token that indicates the start of the next sequential page of results.</p>
    /// <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListGeneratedCodeJobsOutput {
    /// <p>The list of generated code jobs.</p>
    pub fn generated_code_jobs(
        &self,
    ) -> std::option::Option<&[crate::model::GeneratedCodeJobDetails]> {
        self.generated_code_jobs.as_deref()
    }
    /// <p>The token that indicates the start of the next sequential page of results.</p>
    /// <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListGeneratedCodeJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGeneratedCodeJobsOutput");
        formatter.field("generated_code_jobs", &self.generated_code_jobs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListGeneratedCodeJobsOutput`](crate::output::ListGeneratedCodeJobsOutput)
pub mod list_generated_code_jobs_output {
    /// A builder for [`ListGeneratedCodeJobsOutput`](crate::output::ListGeneratedCodeJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) generated_code_jobs:
            std::option::Option<std::vec::Vec<crate::model::GeneratedCodeJobDetails>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `generated_code_jobs`.
        ///
        /// To override the contents of this collection use [`set_generated_code_jobs`](Self::set_generated_code_jobs).
        ///
        /// <p>The list of generated code jobs.</p>
        pub fn generated_code_jobs(mut self, input: crate::model::GeneratedCodeJobDetails) -> Self {
            let mut v = self.generated_code_jobs.unwrap_or_default();
            v.push(input);
            self.generated_code_jobs = Some(v);
            self
        }
        /// <p>The list of generated code jobs.</p>
        pub fn set_generated_code_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GeneratedCodeJobDetails>>,
        ) -> Self {
            self.generated_code_jobs = input;
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGeneratedCodeJobsOutput`](crate::output::ListGeneratedCodeJobsOutput)
        pub fn build(self) -> crate::output::ListGeneratedCodeJobsOutput {
            crate::output::ListGeneratedCodeJobsOutput {
                generated_code_jobs: self.generated_code_jobs,
                next_token: self.next_token,
            }
        }
    }
}
impl ListGeneratedCodeJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListGeneratedCodeJobsOutput`](crate::output::ListGeneratedCodeJobsOutput)
    pub fn builder() -> crate::output::list_generated_code_jobs_output::Builder {
        crate::output::list_generated_code_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGamesOutput {
    /// <p>The list of games.</p>
    pub games: std::option::Option<std::vec::Vec<crate::model::GameSummary>>,
    /// <p>The token that indicates the start of the next sequential page of results.</p>
    /// <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListGamesOutput {
    /// <p>The list of games.</p>
    pub fn games(&self) -> std::option::Option<&[crate::model::GameSummary]> {
        self.games.as_deref()
    }
    /// <p>The token that indicates the start of the next sequential page of results.</p>
    /// <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListGamesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGamesOutput");
        formatter.field("games", &self.games);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListGamesOutput`](crate::output::ListGamesOutput)
pub mod list_games_output {
    /// A builder for [`ListGamesOutput`](crate::output::ListGamesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) games: std::option::Option<std::vec::Vec<crate::model::GameSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `games`.
        ///
        /// To override the contents of this collection use [`set_games`](Self::set_games).
        ///
        /// <p>The list of games.</p>
        pub fn games(mut self, input: crate::model::GameSummary) -> Self {
            let mut v = self.games.unwrap_or_default();
            v.push(input);
            self.games = Some(v);
            self
        }
        /// <p>The list of games.</p>
        pub fn set_games(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GameSummary>>,
        ) -> Self {
            self.games = input;
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGamesOutput`](crate::output::ListGamesOutput)
        pub fn build(self) -> crate::output::ListGamesOutput {
            crate::output::ListGamesOutput {
                games: self.games,
                next_token: self.next_token,
            }
        }
    }
}
impl ListGamesOutput {
    /// Creates a new builder-style object to manufacture [`ListGamesOutput`](crate::output::ListGamesOutput)
    pub fn builder() -> crate::output::list_games_output::Builder {
        crate::output::list_games_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListExtensionVersionsOutput {
    /// <p>The list of extension versions.</p>
    pub extension_versions:
        std::option::Option<std::vec::Vec<crate::model::ExtensionVersionDetails>>,
    /// <p>The token that indicates the start of the next sequential page of results.</p>
    /// <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListExtensionVersionsOutput {
    /// <p>The list of extension versions.</p>
    pub fn extension_versions(
        &self,
    ) -> std::option::Option<&[crate::model::ExtensionVersionDetails]> {
        self.extension_versions.as_deref()
    }
    /// <p>The token that indicates the start of the next sequential page of results.</p>
    /// <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListExtensionVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListExtensionVersionsOutput");
        formatter.field("extension_versions", &self.extension_versions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListExtensionVersionsOutput`](crate::output::ListExtensionVersionsOutput)
pub mod list_extension_versions_output {
    /// A builder for [`ListExtensionVersionsOutput`](crate::output::ListExtensionVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) extension_versions:
            std::option::Option<std::vec::Vec<crate::model::ExtensionVersionDetails>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `extension_versions`.
        ///
        /// To override the contents of this collection use [`set_extension_versions`](Self::set_extension_versions).
        ///
        /// <p>The list of extension versions.</p>
        pub fn extension_versions(mut self, input: crate::model::ExtensionVersionDetails) -> Self {
            let mut v = self.extension_versions.unwrap_or_default();
            v.push(input);
            self.extension_versions = Some(v);
            self
        }
        /// <p>The list of extension versions.</p>
        pub fn set_extension_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExtensionVersionDetails>>,
        ) -> Self {
            self.extension_versions = input;
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListExtensionVersionsOutput`](crate::output::ListExtensionVersionsOutput)
        pub fn build(self) -> crate::output::ListExtensionVersionsOutput {
            crate::output::ListExtensionVersionsOutput {
                extension_versions: self.extension_versions,
                next_token: self.next_token,
            }
        }
    }
}
impl ListExtensionVersionsOutput {
    /// Creates a new builder-style object to manufacture [`ListExtensionVersionsOutput`](crate::output::ListExtensionVersionsOutput)
    pub fn builder() -> crate::output::list_extension_versions_output::Builder {
        crate::output::list_extension_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListExtensionsOutput {
    /// <p>The list of extensions.</p>
    pub extensions: std::option::Option<std::vec::Vec<crate::model::ExtensionDetails>>,
    /// <p>The token that indicates the start of the next sequential page of results.</p>
    /// <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListExtensionsOutput {
    /// <p>The list of extensions.</p>
    pub fn extensions(&self) -> std::option::Option<&[crate::model::ExtensionDetails]> {
        self.extensions.as_deref()
    }
    /// <p>The token that indicates the start of the next sequential page of results.</p>
    /// <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListExtensionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListExtensionsOutput");
        formatter.field("extensions", &self.extensions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListExtensionsOutput`](crate::output::ListExtensionsOutput)
pub mod list_extensions_output {
    /// A builder for [`ListExtensionsOutput`](crate::output::ListExtensionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) extensions: std::option::Option<std::vec::Vec<crate::model::ExtensionDetails>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `extensions`.
        ///
        /// To override the contents of this collection use [`set_extensions`](Self::set_extensions).
        ///
        /// <p>The list of extensions.</p>
        pub fn extensions(mut self, input: crate::model::ExtensionDetails) -> Self {
            let mut v = self.extensions.unwrap_or_default();
            v.push(input);
            self.extensions = Some(v);
            self
        }
        /// <p>The list of extensions.</p>
        pub fn set_extensions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExtensionDetails>>,
        ) -> Self {
            self.extensions = input;
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListExtensionsOutput`](crate::output::ListExtensionsOutput)
        pub fn build(self) -> crate::output::ListExtensionsOutput {
            crate::output::ListExtensionsOutput {
                extensions: self.extensions,
                next_token: self.next_token,
            }
        }
    }
}
impl ListExtensionsOutput {
    /// Creates a new builder-style object to manufacture [`ListExtensionsOutput`](crate::output::ListExtensionsOutput)
    pub fn builder() -> crate::output::list_extensions_output::Builder {
        crate::output::list_extensions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportGameConfigurationOutput {
    /// <p>Details about the game configuration.</p>
    pub game_configuration: std::option::Option<crate::model::GameConfigurationDetails>,
}
impl ImportGameConfigurationOutput {
    /// <p>Details about the game configuration.</p>
    pub fn game_configuration(
        &self,
    ) -> std::option::Option<&crate::model::GameConfigurationDetails> {
        self.game_configuration.as_ref()
    }
}
impl std::fmt::Debug for ImportGameConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportGameConfigurationOutput");
        formatter.field("game_configuration", &self.game_configuration);
        formatter.finish()
    }
}
/// See [`ImportGameConfigurationOutput`](crate::output::ImportGameConfigurationOutput)
pub mod import_game_configuration_output {
    /// A builder for [`ImportGameConfigurationOutput`](crate::output::ImportGameConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_configuration: std::option::Option<crate::model::GameConfigurationDetails>,
    }
    impl Builder {
        /// <p>Details about the game configuration.</p>
        pub fn game_configuration(mut self, input: crate::model::GameConfigurationDetails) -> Self {
            self.game_configuration = Some(input);
            self
        }
        /// <p>Details about the game configuration.</p>
        pub fn set_game_configuration(
            mut self,
            input: std::option::Option<crate::model::GameConfigurationDetails>,
        ) -> Self {
            self.game_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportGameConfigurationOutput`](crate::output::ImportGameConfigurationOutput)
        pub fn build(self) -> crate::output::ImportGameConfigurationOutput {
            crate::output::ImportGameConfigurationOutput {
                game_configuration: self.game_configuration,
            }
        }
    }
}
impl ImportGameConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`ImportGameConfigurationOutput`](crate::output::ImportGameConfigurationOutput)
    pub fn builder() -> crate::output::import_game_configuration_output::Builder {
        crate::output::import_game_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetStageDeploymentOutput {
    /// <p>Properties that provide details of the stage deployment.</p>
    pub stage_deployment: std::option::Option<crate::model::StageDeploymentDetails>,
}
impl GetStageDeploymentOutput {
    /// <p>Properties that provide details of the stage deployment.</p>
    pub fn stage_deployment(&self) -> std::option::Option<&crate::model::StageDeploymentDetails> {
        self.stage_deployment.as_ref()
    }
}
impl std::fmt::Debug for GetStageDeploymentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetStageDeploymentOutput");
        formatter.field("stage_deployment", &self.stage_deployment);
        formatter.finish()
    }
}
/// See [`GetStageDeploymentOutput`](crate::output::GetStageDeploymentOutput)
pub mod get_stage_deployment_output {
    /// A builder for [`GetStageDeploymentOutput`](crate::output::GetStageDeploymentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stage_deployment: std::option::Option<crate::model::StageDeploymentDetails>,
    }
    impl Builder {
        /// <p>Properties that provide details of the stage deployment.</p>
        pub fn stage_deployment(mut self, input: crate::model::StageDeploymentDetails) -> Self {
            self.stage_deployment = Some(input);
            self
        }
        /// <p>Properties that provide details of the stage deployment.</p>
        pub fn set_stage_deployment(
            mut self,
            input: std::option::Option<crate::model::StageDeploymentDetails>,
        ) -> Self {
            self.stage_deployment = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStageDeploymentOutput`](crate::output::GetStageDeploymentOutput)
        pub fn build(self) -> crate::output::GetStageDeploymentOutput {
            crate::output::GetStageDeploymentOutput {
                stage_deployment: self.stage_deployment,
            }
        }
    }
}
impl GetStageDeploymentOutput {
    /// Creates a new builder-style object to manufacture [`GetStageDeploymentOutput`](crate::output::GetStageDeploymentOutput)
    pub fn builder() -> crate::output::get_stage_deployment_output::Builder {
        crate::output::get_stage_deployment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetStageOutput {
    /// <p>Properties that provide details of the stage.</p>
    pub stage: std::option::Option<crate::model::StageDetails>,
}
impl GetStageOutput {
    /// <p>Properties that provide details of the stage.</p>
    pub fn stage(&self) -> std::option::Option<&crate::model::StageDetails> {
        self.stage.as_ref()
    }
}
impl std::fmt::Debug for GetStageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetStageOutput");
        formatter.field("stage", &self.stage);
        formatter.finish()
    }
}
/// See [`GetStageOutput`](crate::output::GetStageOutput)
pub mod get_stage_output {
    /// A builder for [`GetStageOutput`](crate::output::GetStageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stage: std::option::Option<crate::model::StageDetails>,
    }
    impl Builder {
        /// <p>Properties that provide details of the stage.</p>
        pub fn stage(mut self, input: crate::model::StageDetails) -> Self {
            self.stage = Some(input);
            self
        }
        /// <p>Properties that provide details of the stage.</p>
        pub fn set_stage(mut self, input: std::option::Option<crate::model::StageDetails>) -> Self {
            self.stage = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStageOutput`](crate::output::GetStageOutput)
        pub fn build(self) -> crate::output::GetStageOutput {
            crate::output::GetStageOutput { stage: self.stage }
        }
    }
}
impl GetStageOutput {
    /// Creates a new builder-style object to manufacture [`GetStageOutput`](crate::output::GetStageOutput)
    pub fn builder() -> crate::output::get_stage_output::Builder {
        crate::output::get_stage_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSnapshotOutput {
    /// <p>Properties that provide details of the snapshot.</p>
    pub snapshot: std::option::Option<crate::model::SnapshotDetails>,
}
impl GetSnapshotOutput {
    /// <p>Properties that provide details of the snapshot.</p>
    pub fn snapshot(&self) -> std::option::Option<&crate::model::SnapshotDetails> {
        self.snapshot.as_ref()
    }
}
impl std::fmt::Debug for GetSnapshotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSnapshotOutput");
        formatter.field("snapshot", &self.snapshot);
        formatter.finish()
    }
}
/// See [`GetSnapshotOutput`](crate::output::GetSnapshotOutput)
pub mod get_snapshot_output {
    /// A builder for [`GetSnapshotOutput`](crate::output::GetSnapshotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot: std::option::Option<crate::model::SnapshotDetails>,
    }
    impl Builder {
        /// <p>Properties that provide details of the snapshot.</p>
        pub fn snapshot(mut self, input: crate::model::SnapshotDetails) -> Self {
            self.snapshot = Some(input);
            self
        }
        /// <p>Properties that provide details of the snapshot.</p>
        pub fn set_snapshot(
            mut self,
            input: std::option::Option<crate::model::SnapshotDetails>,
        ) -> Self {
            self.snapshot = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSnapshotOutput`](crate::output::GetSnapshotOutput)
        pub fn build(self) -> crate::output::GetSnapshotOutput {
            crate::output::GetSnapshotOutput {
                snapshot: self.snapshot,
            }
        }
    }
}
impl GetSnapshotOutput {
    /// Creates a new builder-style object to manufacture [`GetSnapshotOutput`](crate::output::GetSnapshotOutput)
    pub fn builder() -> crate::output::get_snapshot_output::Builder {
        crate::output::get_snapshot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPlayerConnectionStatusOutput {
    /// <p>The list of connection ids, one for each connection in use by the player.</p>
    pub connections: std::option::Option<std::vec::Vec<crate::model::Connection>>,
}
impl GetPlayerConnectionStatusOutput {
    /// <p>The list of connection ids, one for each connection in use by the player.</p>
    pub fn connections(&self) -> std::option::Option<&[crate::model::Connection]> {
        self.connections.as_deref()
    }
}
impl std::fmt::Debug for GetPlayerConnectionStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPlayerConnectionStatusOutput");
        formatter.field("connections", &self.connections);
        formatter.finish()
    }
}
/// See [`GetPlayerConnectionStatusOutput`](crate::output::GetPlayerConnectionStatusOutput)
pub mod get_player_connection_status_output {
    /// A builder for [`GetPlayerConnectionStatusOutput`](crate::output::GetPlayerConnectionStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connections: std::option::Option<std::vec::Vec<crate::model::Connection>>,
    }
    impl Builder {
        /// Appends an item to `connections`.
        ///
        /// To override the contents of this collection use [`set_connections`](Self::set_connections).
        ///
        /// <p>The list of connection ids, one for each connection in use by the player.</p>
        pub fn connections(mut self, input: crate::model::Connection) -> Self {
            let mut v = self.connections.unwrap_or_default();
            v.push(input);
            self.connections = Some(v);
            self
        }
        /// <p>The list of connection ids, one for each connection in use by the player.</p>
        pub fn set_connections(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Connection>>,
        ) -> Self {
            self.connections = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPlayerConnectionStatusOutput`](crate::output::GetPlayerConnectionStatusOutput)
        pub fn build(self) -> crate::output::GetPlayerConnectionStatusOutput {
            crate::output::GetPlayerConnectionStatusOutput {
                connections: self.connections,
            }
        }
    }
}
impl GetPlayerConnectionStatusOutput {
    /// Creates a new builder-style object to manufacture [`GetPlayerConnectionStatusOutput`](crate::output::GetPlayerConnectionStatusOutput)
    pub fn builder() -> crate::output::get_player_connection_status_output::Builder {
        crate::output::get_player_connection_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGeneratedCodeJobOutput {
    /// <p>Details about the generated code job.</p>
    pub generated_code_job: std::option::Option<crate::model::GeneratedCodeJobDetails>,
}
impl GetGeneratedCodeJobOutput {
    /// <p>Details about the generated code job.</p>
    pub fn generated_code_job(
        &self,
    ) -> std::option::Option<&crate::model::GeneratedCodeJobDetails> {
        self.generated_code_job.as_ref()
    }
}
impl std::fmt::Debug for GetGeneratedCodeJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGeneratedCodeJobOutput");
        formatter.field("generated_code_job", &self.generated_code_job);
        formatter.finish()
    }
}
/// See [`GetGeneratedCodeJobOutput`](crate::output::GetGeneratedCodeJobOutput)
pub mod get_generated_code_job_output {
    /// A builder for [`GetGeneratedCodeJobOutput`](crate::output::GetGeneratedCodeJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) generated_code_job: std::option::Option<crate::model::GeneratedCodeJobDetails>,
    }
    impl Builder {
        /// <p>Details about the generated code job.</p>
        pub fn generated_code_job(mut self, input: crate::model::GeneratedCodeJobDetails) -> Self {
            self.generated_code_job = Some(input);
            self
        }
        /// <p>Details about the generated code job.</p>
        pub fn set_generated_code_job(
            mut self,
            input: std::option::Option<crate::model::GeneratedCodeJobDetails>,
        ) -> Self {
            self.generated_code_job = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGeneratedCodeJobOutput`](crate::output::GetGeneratedCodeJobOutput)
        pub fn build(self) -> crate::output::GetGeneratedCodeJobOutput {
            crate::output::GetGeneratedCodeJobOutput {
                generated_code_job: self.generated_code_job,
            }
        }
    }
}
impl GetGeneratedCodeJobOutput {
    /// Creates a new builder-style object to manufacture [`GetGeneratedCodeJobOutput`](crate::output::GetGeneratedCodeJobOutput)
    pub fn builder() -> crate::output::get_generated_code_job_output::Builder {
        crate::output::get_generated_code_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGameConfigurationOutput {
    /// <p>Details about the game configuration.</p>
    pub game_configuration: std::option::Option<crate::model::GameConfigurationDetails>,
}
impl GetGameConfigurationOutput {
    /// <p>Details about the game configuration.</p>
    pub fn game_configuration(
        &self,
    ) -> std::option::Option<&crate::model::GameConfigurationDetails> {
        self.game_configuration.as_ref()
    }
}
impl std::fmt::Debug for GetGameConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGameConfigurationOutput");
        formatter.field("game_configuration", &self.game_configuration);
        formatter.finish()
    }
}
/// See [`GetGameConfigurationOutput`](crate::output::GetGameConfigurationOutput)
pub mod get_game_configuration_output {
    /// A builder for [`GetGameConfigurationOutput`](crate::output::GetGameConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_configuration: std::option::Option<crate::model::GameConfigurationDetails>,
    }
    impl Builder {
        /// <p>Details about the game configuration.</p>
        pub fn game_configuration(mut self, input: crate::model::GameConfigurationDetails) -> Self {
            self.game_configuration = Some(input);
            self
        }
        /// <p>Details about the game configuration.</p>
        pub fn set_game_configuration(
            mut self,
            input: std::option::Option<crate::model::GameConfigurationDetails>,
        ) -> Self {
            self.game_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGameConfigurationOutput`](crate::output::GetGameConfigurationOutput)
        pub fn build(self) -> crate::output::GetGameConfigurationOutput {
            crate::output::GetGameConfigurationOutput {
                game_configuration: self.game_configuration,
            }
        }
    }
}
impl GetGameConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`GetGameConfigurationOutput`](crate::output::GetGameConfigurationOutput)
    pub fn builder() -> crate::output::get_game_configuration_output::Builder {
        crate::output::get_game_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGameOutput {
    /// <p>The details of the game.</p>
    pub game: std::option::Option<crate::model::GameDetails>,
}
impl GetGameOutput {
    /// <p>The details of the game.</p>
    pub fn game(&self) -> std::option::Option<&crate::model::GameDetails> {
        self.game.as_ref()
    }
}
impl std::fmt::Debug for GetGameOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGameOutput");
        formatter.field("game", &self.game);
        formatter.finish()
    }
}
/// See [`GetGameOutput`](crate::output::GetGameOutput)
pub mod get_game_output {
    /// A builder for [`GetGameOutput`](crate::output::GetGameOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game: std::option::Option<crate::model::GameDetails>,
    }
    impl Builder {
        /// <p>The details of the game.</p>
        pub fn game(mut self, input: crate::model::GameDetails) -> Self {
            self.game = Some(input);
            self
        }
        /// <p>The details of the game.</p>
        pub fn set_game(mut self, input: std::option::Option<crate::model::GameDetails>) -> Self {
            self.game = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGameOutput`](crate::output::GetGameOutput)
        pub fn build(self) -> crate::output::GetGameOutput {
            crate::output::GetGameOutput { game: self.game }
        }
    }
}
impl GetGameOutput {
    /// Creates a new builder-style object to manufacture [`GetGameOutput`](crate::output::GetGameOutput)
    pub fn builder() -> crate::output::get_game_output::Builder {
        crate::output::get_game_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetExtensionVersionOutput {
    /// <p>The version of the extension.</p>
    pub extension_version: std::option::Option<crate::model::ExtensionVersionDetails>,
}
impl GetExtensionVersionOutput {
    /// <p>The version of the extension.</p>
    pub fn extension_version(&self) -> std::option::Option<&crate::model::ExtensionVersionDetails> {
        self.extension_version.as_ref()
    }
}
impl std::fmt::Debug for GetExtensionVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetExtensionVersionOutput");
        formatter.field("extension_version", &self.extension_version);
        formatter.finish()
    }
}
/// See [`GetExtensionVersionOutput`](crate::output::GetExtensionVersionOutput)
pub mod get_extension_version_output {
    /// A builder for [`GetExtensionVersionOutput`](crate::output::GetExtensionVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) extension_version: std::option::Option<crate::model::ExtensionVersionDetails>,
    }
    impl Builder {
        /// <p>The version of the extension.</p>
        pub fn extension_version(mut self, input: crate::model::ExtensionVersionDetails) -> Self {
            self.extension_version = Some(input);
            self
        }
        /// <p>The version of the extension.</p>
        pub fn set_extension_version(
            mut self,
            input: std::option::Option<crate::model::ExtensionVersionDetails>,
        ) -> Self {
            self.extension_version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetExtensionVersionOutput`](crate::output::GetExtensionVersionOutput)
        pub fn build(self) -> crate::output::GetExtensionVersionOutput {
            crate::output::GetExtensionVersionOutput {
                extension_version: self.extension_version,
            }
        }
    }
}
impl GetExtensionVersionOutput {
    /// Creates a new builder-style object to manufacture [`GetExtensionVersionOutput`](crate::output::GetExtensionVersionOutput)
    pub fn builder() -> crate::output::get_extension_version_output::Builder {
        crate::output::get_extension_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetExtensionOutput {
    /// <p>Details about the extension.</p>
    pub extension: std::option::Option<crate::model::ExtensionDetails>,
}
impl GetExtensionOutput {
    /// <p>Details about the extension.</p>
    pub fn extension(&self) -> std::option::Option<&crate::model::ExtensionDetails> {
        self.extension.as_ref()
    }
}
impl std::fmt::Debug for GetExtensionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetExtensionOutput");
        formatter.field("extension", &self.extension);
        formatter.finish()
    }
}
/// See [`GetExtensionOutput`](crate::output::GetExtensionOutput)
pub mod get_extension_output {
    /// A builder for [`GetExtensionOutput`](crate::output::GetExtensionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) extension: std::option::Option<crate::model::ExtensionDetails>,
    }
    impl Builder {
        /// <p>Details about the extension.</p>
        pub fn extension(mut self, input: crate::model::ExtensionDetails) -> Self {
            self.extension = Some(input);
            self
        }
        /// <p>Details about the extension.</p>
        pub fn set_extension(
            mut self,
            input: std::option::Option<crate::model::ExtensionDetails>,
        ) -> Self {
            self.extension = input;
            self
        }
        /// Consumes the builder and constructs a [`GetExtensionOutput`](crate::output::GetExtensionOutput)
        pub fn build(self) -> crate::output::GetExtensionOutput {
            crate::output::GetExtensionOutput {
                extension: self.extension,
            }
        }
    }
}
impl GetExtensionOutput {
    /// Creates a new builder-style object to manufacture [`GetExtensionOutput`](crate::output::GetExtensionOutput)
    pub fn builder() -> crate::output::get_extension_output::Builder {
        crate::output::get_extension_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportSnapshotOutput {
    /// <p>The presigned URL for the snapshot data.</p>
    /// <p> This URL will be available for 10 minutes, and can be used to download the snapshot content. If the URL expires, a new one can be requested using the same operation. </p>
    pub s3_url: std::option::Option<std::string::String>,
}
impl ExportSnapshotOutput {
    /// <p>The presigned URL for the snapshot data.</p>
    /// <p> This URL will be available for 10 minutes, and can be used to download the snapshot content. If the URL expires, a new one can be requested using the same operation. </p>
    pub fn s3_url(&self) -> std::option::Option<&str> {
        self.s3_url.as_deref()
    }
}
impl std::fmt::Debug for ExportSnapshotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportSnapshotOutput");
        formatter.field("s3_url", &self.s3_url);
        formatter.finish()
    }
}
/// See [`ExportSnapshotOutput`](crate::output::ExportSnapshotOutput)
pub mod export_snapshot_output {
    /// A builder for [`ExportSnapshotOutput`](crate::output::ExportSnapshotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The presigned URL for the snapshot data.</p>
        /// <p> This URL will be available for 10 minutes, and can be used to download the snapshot content. If the URL expires, a new one can be requested using the same operation. </p>
        pub fn s3_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_url = Some(input.into());
            self
        }
        /// <p>The presigned URL for the snapshot data.</p>
        /// <p> This URL will be available for 10 minutes, and can be used to download the snapshot content. If the URL expires, a new one can be requested using the same operation. </p>
        pub fn set_s3_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_url = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportSnapshotOutput`](crate::output::ExportSnapshotOutput)
        pub fn build(self) -> crate::output::ExportSnapshotOutput {
            crate::output::ExportSnapshotOutput {
                s3_url: self.s3_url,
            }
        }
    }
}
impl ExportSnapshotOutput {
    /// Creates a new builder-style object to manufacture [`ExportSnapshotOutput`](crate::output::ExportSnapshotOutput)
    pub fn builder() -> crate::output::export_snapshot_output::Builder {
        crate::output::export_snapshot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisconnectPlayerOutput {
    /// <p>The list of the connection ids that were disconnected.</p>
    pub disconnect_successes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The list of the connection ids that could not be disconnected.</p>
    pub disconnect_failures: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DisconnectPlayerOutput {
    /// <p>The list of the connection ids that were disconnected.</p>
    pub fn disconnect_successes(&self) -> std::option::Option<&[std::string::String]> {
        self.disconnect_successes.as_deref()
    }
    /// <p>The list of the connection ids that could not be disconnected.</p>
    pub fn disconnect_failures(&self) -> std::option::Option<&[std::string::String]> {
        self.disconnect_failures.as_deref()
    }
}
impl std::fmt::Debug for DisconnectPlayerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisconnectPlayerOutput");
        formatter.field("disconnect_successes", &self.disconnect_successes);
        formatter.field("disconnect_failures", &self.disconnect_failures);
        formatter.finish()
    }
}
/// See [`DisconnectPlayerOutput`](crate::output::DisconnectPlayerOutput)
pub mod disconnect_player_output {
    /// A builder for [`DisconnectPlayerOutput`](crate::output::DisconnectPlayerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) disconnect_successes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) disconnect_failures: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `disconnect_successes`.
        ///
        /// To override the contents of this collection use [`set_disconnect_successes`](Self::set_disconnect_successes).
        ///
        /// <p>The list of the connection ids that were disconnected.</p>
        pub fn disconnect_successes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.disconnect_successes.unwrap_or_default();
            v.push(input.into());
            self.disconnect_successes = Some(v);
            self
        }
        /// <p>The list of the connection ids that were disconnected.</p>
        pub fn set_disconnect_successes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.disconnect_successes = input;
            self
        }
        /// Appends an item to `disconnect_failures`.
        ///
        /// To override the contents of this collection use [`set_disconnect_failures`](Self::set_disconnect_failures).
        ///
        /// <p>The list of the connection ids that could not be disconnected.</p>
        pub fn disconnect_failures(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.disconnect_failures.unwrap_or_default();
            v.push(input.into());
            self.disconnect_failures = Some(v);
            self
        }
        /// <p>The list of the connection ids that could not be disconnected.</p>
        pub fn set_disconnect_failures(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.disconnect_failures = input;
            self
        }
        /// Consumes the builder and constructs a [`DisconnectPlayerOutput`](crate::output::DisconnectPlayerOutput)
        pub fn build(self) -> crate::output::DisconnectPlayerOutput {
            crate::output::DisconnectPlayerOutput {
                disconnect_successes: self.disconnect_successes,
                disconnect_failures: self.disconnect_failures,
            }
        }
    }
}
impl DisconnectPlayerOutput {
    /// Creates a new builder-style object to manufacture [`DisconnectPlayerOutput`](crate::output::DisconnectPlayerOutput)
    pub fn builder() -> crate::output::disconnect_player_output::Builder {
        crate::output::disconnect_player_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteStageOutput {}
impl std::fmt::Debug for DeleteStageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteStageOutput");
        formatter.finish()
    }
}
/// See [`DeleteStageOutput`](crate::output::DeleteStageOutput)
pub mod delete_stage_output {
    /// A builder for [`DeleteStageOutput`](crate::output::DeleteStageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteStageOutput`](crate::output::DeleteStageOutput)
        pub fn build(self) -> crate::output::DeleteStageOutput {
            crate::output::DeleteStageOutput {}
        }
    }
}
impl DeleteStageOutput {
    /// Creates a new builder-style object to manufacture [`DeleteStageOutput`](crate::output::DeleteStageOutput)
    pub fn builder() -> crate::output::delete_stage_output::Builder {
        crate::output::delete_stage_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGameOutput {}
impl std::fmt::Debug for DeleteGameOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGameOutput");
        formatter.finish()
    }
}
/// See [`DeleteGameOutput`](crate::output::DeleteGameOutput)
pub mod delete_game_output {
    /// A builder for [`DeleteGameOutput`](crate::output::DeleteGameOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteGameOutput`](crate::output::DeleteGameOutput)
        pub fn build(self) -> crate::output::DeleteGameOutput {
            crate::output::DeleteGameOutput {}
        }
    }
}
impl DeleteGameOutput {
    /// Creates a new builder-style object to manufacture [`DeleteGameOutput`](crate::output::DeleteGameOutput)
    pub fn builder() -> crate::output::delete_game_output::Builder {
        crate::output::delete_game_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateStageOutput {
    /// <p>Properties that describe the stage.</p>
    pub stage: std::option::Option<crate::model::StageDetails>,
}
impl CreateStageOutput {
    /// <p>Properties that describe the stage.</p>
    pub fn stage(&self) -> std::option::Option<&crate::model::StageDetails> {
        self.stage.as_ref()
    }
}
impl std::fmt::Debug for CreateStageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateStageOutput");
        formatter.field("stage", &self.stage);
        formatter.finish()
    }
}
/// See [`CreateStageOutput`](crate::output::CreateStageOutput)
pub mod create_stage_output {
    /// A builder for [`CreateStageOutput`](crate::output::CreateStageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stage: std::option::Option<crate::model::StageDetails>,
    }
    impl Builder {
        /// <p>Properties that describe the stage.</p>
        pub fn stage(mut self, input: crate::model::StageDetails) -> Self {
            self.stage = Some(input);
            self
        }
        /// <p>Properties that describe the stage.</p>
        pub fn set_stage(mut self, input: std::option::Option<crate::model::StageDetails>) -> Self {
            self.stage = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStageOutput`](crate::output::CreateStageOutput)
        pub fn build(self) -> crate::output::CreateStageOutput {
            crate::output::CreateStageOutput { stage: self.stage }
        }
    }
}
impl CreateStageOutput {
    /// Creates a new builder-style object to manufacture [`CreateStageOutput`](crate::output::CreateStageOutput)
    pub fn builder() -> crate::output::create_stage_output::Builder {
        crate::output::create_stage_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSnapshotOutput {
    /// <p>Properties that provide details of the created snapshot.</p>
    pub snapshot: std::option::Option<crate::model::SnapshotDetails>,
}
impl CreateSnapshotOutput {
    /// <p>Properties that provide details of the created snapshot.</p>
    pub fn snapshot(&self) -> std::option::Option<&crate::model::SnapshotDetails> {
        self.snapshot.as_ref()
    }
}
impl std::fmt::Debug for CreateSnapshotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSnapshotOutput");
        formatter.field("snapshot", &self.snapshot);
        formatter.finish()
    }
}
/// See [`CreateSnapshotOutput`](crate::output::CreateSnapshotOutput)
pub mod create_snapshot_output {
    /// A builder for [`CreateSnapshotOutput`](crate::output::CreateSnapshotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot: std::option::Option<crate::model::SnapshotDetails>,
    }
    impl Builder {
        /// <p>Properties that provide details of the created snapshot.</p>
        pub fn snapshot(mut self, input: crate::model::SnapshotDetails) -> Self {
            self.snapshot = Some(input);
            self
        }
        /// <p>Properties that provide details of the created snapshot.</p>
        pub fn set_snapshot(
            mut self,
            input: std::option::Option<crate::model::SnapshotDetails>,
        ) -> Self {
            self.snapshot = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSnapshotOutput`](crate::output::CreateSnapshotOutput)
        pub fn build(self) -> crate::output::CreateSnapshotOutput {
            crate::output::CreateSnapshotOutput {
                snapshot: self.snapshot,
            }
        }
    }
}
impl CreateSnapshotOutput {
    /// Creates a new builder-style object to manufacture [`CreateSnapshotOutput`](crate::output::CreateSnapshotOutput)
    pub fn builder() -> crate::output::create_snapshot_output::Builder {
        crate::output::create_snapshot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGameOutput {
    /// <p>Details about the game that was created.</p>
    pub game: std::option::Option<crate::model::GameDetails>,
}
impl CreateGameOutput {
    /// <p>Details about the game that was created.</p>
    pub fn game(&self) -> std::option::Option<&crate::model::GameDetails> {
        self.game.as_ref()
    }
}
impl std::fmt::Debug for CreateGameOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGameOutput");
        formatter.field("game", &self.game);
        formatter.finish()
    }
}
/// See [`CreateGameOutput`](crate::output::CreateGameOutput)
pub mod create_game_output {
    /// A builder for [`CreateGameOutput`](crate::output::CreateGameOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game: std::option::Option<crate::model::GameDetails>,
    }
    impl Builder {
        /// <p>Details about the game that was created.</p>
        pub fn game(mut self, input: crate::model::GameDetails) -> Self {
            self.game = Some(input);
            self
        }
        /// <p>Details about the game that was created.</p>
        pub fn set_game(mut self, input: std::option::Option<crate::model::GameDetails>) -> Self {
            self.game = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGameOutput`](crate::output::CreateGameOutput)
        pub fn build(self) -> crate::output::CreateGameOutput {
            crate::output::CreateGameOutput { game: self.game }
        }
    }
}
impl CreateGameOutput {
    /// Creates a new builder-style object to manufacture [`CreateGameOutput`](crate::output::CreateGameOutput)
    pub fn builder() -> crate::output::create_game_output::Builder {
        crate::output::create_game_output::Builder::default()
    }
}
