// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateGame`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_game`](crate::client::Client::create_game).
///
/// See [`crate::client::fluent_builders::CreateGame`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateGame {
    _private: (),
}
impl CreateGame {
    /// Creates a new builder-style object to manufacture [`CreateGameInput`](crate::input::CreateGameInput)
    pub fn builder() -> crate::input::create_game_input::Builder {
        crate::input::create_game_input::Builder::default()
    }
    /// Creates a new `CreateGame` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateGame {
    type Output =
        std::result::Result<crate::output::CreateGameOutput, crate::error::CreateGameError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_game_error(response)
        } else {
            crate::operation_deser::parse_create_game_response(response)
        }
    }
}

/// Operation shape for `CreateSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_snapshot`](crate::client::Client::create_snapshot).
///
/// See [`crate::client::fluent_builders::CreateSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSnapshot {
    _private: (),
}
impl CreateSnapshot {
    /// Creates a new builder-style object to manufacture [`CreateSnapshotInput`](crate::input::CreateSnapshotInput)
    pub fn builder() -> crate::input::create_snapshot_input::Builder {
        crate::input::create_snapshot_input::Builder::default()
    }
    /// Creates a new `CreateSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSnapshot {
    type Output =
        std::result::Result<crate::output::CreateSnapshotOutput, crate::error::CreateSnapshotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_snapshot_error(response)
        } else {
            crate::operation_deser::parse_create_snapshot_response(response)
        }
    }
}

/// Operation shape for `CreateStage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_stage`](crate::client::Client::create_stage).
///
/// See [`crate::client::fluent_builders::CreateStage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateStage {
    _private: (),
}
impl CreateStage {
    /// Creates a new builder-style object to manufacture [`CreateStageInput`](crate::input::CreateStageInput)
    pub fn builder() -> crate::input::create_stage_input::Builder {
        crate::input::create_stage_input::Builder::default()
    }
    /// Creates a new `CreateStage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateStage {
    type Output =
        std::result::Result<crate::output::CreateStageOutput, crate::error::CreateStageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_stage_error(response)
        } else {
            crate::operation_deser::parse_create_stage_response(response)
        }
    }
}

/// Operation shape for `DeleteGame`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_game`](crate::client::Client::delete_game).
///
/// See [`crate::client::fluent_builders::DeleteGame`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteGame {
    _private: (),
}
impl DeleteGame {
    /// Creates a new builder-style object to manufacture [`DeleteGameInput`](crate::input::DeleteGameInput)
    pub fn builder() -> crate::input::delete_game_input::Builder {
        crate::input::delete_game_input::Builder::default()
    }
    /// Creates a new `DeleteGame` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteGame {
    type Output =
        std::result::Result<crate::output::DeleteGameOutput, crate::error::DeleteGameError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_game_error(response)
        } else {
            crate::operation_deser::parse_delete_game_response(response)
        }
    }
}

/// Operation shape for `DeleteStage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_stage`](crate::client::Client::delete_stage).
///
/// See [`crate::client::fluent_builders::DeleteStage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteStage {
    _private: (),
}
impl DeleteStage {
    /// Creates a new builder-style object to manufacture [`DeleteStageInput`](crate::input::DeleteStageInput)
    pub fn builder() -> crate::input::delete_stage_input::Builder {
        crate::input::delete_stage_input::Builder::default()
    }
    /// Creates a new `DeleteStage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteStage {
    type Output =
        std::result::Result<crate::output::DeleteStageOutput, crate::error::DeleteStageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_stage_error(response)
        } else {
            crate::operation_deser::parse_delete_stage_response(response)
        }
    }
}

/// Operation shape for `DisconnectPlayer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disconnect_player`](crate::client::Client::disconnect_player).
///
/// See [`crate::client::fluent_builders::DisconnectPlayer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisconnectPlayer {
    _private: (),
}
impl DisconnectPlayer {
    /// Creates a new builder-style object to manufacture [`DisconnectPlayerInput`](crate::input::DisconnectPlayerInput)
    pub fn builder() -> crate::input::disconnect_player_input::Builder {
        crate::input::disconnect_player_input::Builder::default()
    }
    /// Creates a new `DisconnectPlayer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisconnectPlayer {
    type Output = std::result::Result<
        crate::output::DisconnectPlayerOutput,
        crate::error::DisconnectPlayerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disconnect_player_error(response)
        } else {
            crate::operation_deser::parse_disconnect_player_response(response)
        }
    }
}

/// Operation shape for `ExportSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`export_snapshot`](crate::client::Client::export_snapshot).
///
/// See [`crate::client::fluent_builders::ExportSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ExportSnapshot {
    _private: (),
}
impl ExportSnapshot {
    /// Creates a new builder-style object to manufacture [`ExportSnapshotInput`](crate::input::ExportSnapshotInput)
    pub fn builder() -> crate::input::export_snapshot_input::Builder {
        crate::input::export_snapshot_input::Builder::default()
    }
    /// Creates a new `ExportSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ExportSnapshot {
    type Output =
        std::result::Result<crate::output::ExportSnapshotOutput, crate::error::ExportSnapshotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_export_snapshot_error(response)
        } else {
            crate::operation_deser::parse_export_snapshot_response(response)
        }
    }
}

/// Operation shape for `GetExtension`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_extension`](crate::client::Client::get_extension).
///
/// See [`crate::client::fluent_builders::GetExtension`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetExtension {
    _private: (),
}
impl GetExtension {
    /// Creates a new builder-style object to manufacture [`GetExtensionInput`](crate::input::GetExtensionInput)
    pub fn builder() -> crate::input::get_extension_input::Builder {
        crate::input::get_extension_input::Builder::default()
    }
    /// Creates a new `GetExtension` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetExtension {
    type Output =
        std::result::Result<crate::output::GetExtensionOutput, crate::error::GetExtensionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_extension_error(response)
        } else {
            crate::operation_deser::parse_get_extension_response(response)
        }
    }
}

/// Operation shape for `GetExtensionVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_extension_version`](crate::client::Client::get_extension_version).
///
/// See [`crate::client::fluent_builders::GetExtensionVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetExtensionVersion {
    _private: (),
}
impl GetExtensionVersion {
    /// Creates a new builder-style object to manufacture [`GetExtensionVersionInput`](crate::input::GetExtensionVersionInput)
    pub fn builder() -> crate::input::get_extension_version_input::Builder {
        crate::input::get_extension_version_input::Builder::default()
    }
    /// Creates a new `GetExtensionVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetExtensionVersion {
    type Output = std::result::Result<
        crate::output::GetExtensionVersionOutput,
        crate::error::GetExtensionVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_extension_version_error(response)
        } else {
            crate::operation_deser::parse_get_extension_version_response(response)
        }
    }
}

/// Operation shape for `GetGame`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_game`](crate::client::Client::get_game).
///
/// See [`crate::client::fluent_builders::GetGame`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetGame {
    _private: (),
}
impl GetGame {
    /// Creates a new builder-style object to manufacture [`GetGameInput`](crate::input::GetGameInput)
    pub fn builder() -> crate::input::get_game_input::Builder {
        crate::input::get_game_input::Builder::default()
    }
    /// Creates a new `GetGame` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetGame {
    type Output = std::result::Result<crate::output::GetGameOutput, crate::error::GetGameError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_game_error(response)
        } else {
            crate::operation_deser::parse_get_game_response(response)
        }
    }
}

/// Operation shape for `GetGameConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_game_configuration`](crate::client::Client::get_game_configuration).
///
/// See [`crate::client::fluent_builders::GetGameConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetGameConfiguration {
    _private: (),
}
impl GetGameConfiguration {
    /// Creates a new builder-style object to manufacture [`GetGameConfigurationInput`](crate::input::GetGameConfigurationInput)
    pub fn builder() -> crate::input::get_game_configuration_input::Builder {
        crate::input::get_game_configuration_input::Builder::default()
    }
    /// Creates a new `GetGameConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetGameConfiguration {
    type Output = std::result::Result<
        crate::output::GetGameConfigurationOutput,
        crate::error::GetGameConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_game_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_game_configuration_response(response)
        }
    }
}

/// Operation shape for `GetGeneratedCodeJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_generated_code_job`](crate::client::Client::get_generated_code_job).
///
/// See [`crate::client::fluent_builders::GetGeneratedCodeJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetGeneratedCodeJob {
    _private: (),
}
impl GetGeneratedCodeJob {
    /// Creates a new builder-style object to manufacture [`GetGeneratedCodeJobInput`](crate::input::GetGeneratedCodeJobInput)
    pub fn builder() -> crate::input::get_generated_code_job_input::Builder {
        crate::input::get_generated_code_job_input::Builder::default()
    }
    /// Creates a new `GetGeneratedCodeJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetGeneratedCodeJob {
    type Output = std::result::Result<
        crate::output::GetGeneratedCodeJobOutput,
        crate::error::GetGeneratedCodeJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_generated_code_job_error(response)
        } else {
            crate::operation_deser::parse_get_generated_code_job_response(response)
        }
    }
}

/// Operation shape for `GetPlayerConnectionStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_player_connection_status`](crate::client::Client::get_player_connection_status).
///
/// See [`crate::client::fluent_builders::GetPlayerConnectionStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPlayerConnectionStatus {
    _private: (),
}
impl GetPlayerConnectionStatus {
    /// Creates a new builder-style object to manufacture [`GetPlayerConnectionStatusInput`](crate::input::GetPlayerConnectionStatusInput)
    pub fn builder() -> crate::input::get_player_connection_status_input::Builder {
        crate::input::get_player_connection_status_input::Builder::default()
    }
    /// Creates a new `GetPlayerConnectionStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPlayerConnectionStatus {
    type Output = std::result::Result<
        crate::output::GetPlayerConnectionStatusOutput,
        crate::error::GetPlayerConnectionStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_player_connection_status_error(response)
        } else {
            crate::operation_deser::parse_get_player_connection_status_response(response)
        }
    }
}

/// Operation shape for `GetSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_snapshot`](crate::client::Client::get_snapshot).
///
/// See [`crate::client::fluent_builders::GetSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSnapshot {
    _private: (),
}
impl GetSnapshot {
    /// Creates a new builder-style object to manufacture [`GetSnapshotInput`](crate::input::GetSnapshotInput)
    pub fn builder() -> crate::input::get_snapshot_input::Builder {
        crate::input::get_snapshot_input::Builder::default()
    }
    /// Creates a new `GetSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSnapshot {
    type Output =
        std::result::Result<crate::output::GetSnapshotOutput, crate::error::GetSnapshotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_snapshot_error(response)
        } else {
            crate::operation_deser::parse_get_snapshot_response(response)
        }
    }
}

/// Operation shape for `GetStage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_stage`](crate::client::Client::get_stage).
///
/// See [`crate::client::fluent_builders::GetStage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetStage {
    _private: (),
}
impl GetStage {
    /// Creates a new builder-style object to manufacture [`GetStageInput`](crate::input::GetStageInput)
    pub fn builder() -> crate::input::get_stage_input::Builder {
        crate::input::get_stage_input::Builder::default()
    }
    /// Creates a new `GetStage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetStage {
    type Output = std::result::Result<crate::output::GetStageOutput, crate::error::GetStageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_stage_error(response)
        } else {
            crate::operation_deser::parse_get_stage_response(response)
        }
    }
}

/// Operation shape for `GetStageDeployment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_stage_deployment`](crate::client::Client::get_stage_deployment).
///
/// See [`crate::client::fluent_builders::GetStageDeployment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetStageDeployment {
    _private: (),
}
impl GetStageDeployment {
    /// Creates a new builder-style object to manufacture [`GetStageDeploymentInput`](crate::input::GetStageDeploymentInput)
    pub fn builder() -> crate::input::get_stage_deployment_input::Builder {
        crate::input::get_stage_deployment_input::Builder::default()
    }
    /// Creates a new `GetStageDeployment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetStageDeployment {
    type Output = std::result::Result<
        crate::output::GetStageDeploymentOutput,
        crate::error::GetStageDeploymentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_stage_deployment_error(response)
        } else {
            crate::operation_deser::parse_get_stage_deployment_response(response)
        }
    }
}

/// Operation shape for `ImportGameConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`import_game_configuration`](crate::client::Client::import_game_configuration).
///
/// See [`crate::client::fluent_builders::ImportGameConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ImportGameConfiguration {
    _private: (),
}
impl ImportGameConfiguration {
    /// Creates a new builder-style object to manufacture [`ImportGameConfigurationInput`](crate::input::ImportGameConfigurationInput)
    pub fn builder() -> crate::input::import_game_configuration_input::Builder {
        crate::input::import_game_configuration_input::Builder::default()
    }
    /// Creates a new `ImportGameConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ImportGameConfiguration {
    type Output = std::result::Result<
        crate::output::ImportGameConfigurationOutput,
        crate::error::ImportGameConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_import_game_configuration_error(response)
        } else {
            crate::operation_deser::parse_import_game_configuration_response(response)
        }
    }
}

/// Operation shape for `ListExtensions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_extensions`](crate::client::Client::list_extensions).
///
/// See [`crate::client::fluent_builders::ListExtensions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListExtensions {
    _private: (),
}
impl ListExtensions {
    /// Creates a new builder-style object to manufacture [`ListExtensionsInput`](crate::input::ListExtensionsInput)
    pub fn builder() -> crate::input::list_extensions_input::Builder {
        crate::input::list_extensions_input::Builder::default()
    }
    /// Creates a new `ListExtensions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListExtensions {
    type Output =
        std::result::Result<crate::output::ListExtensionsOutput, crate::error::ListExtensionsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_extensions_error(response)
        } else {
            crate::operation_deser::parse_list_extensions_response(response)
        }
    }
}

/// Operation shape for `ListExtensionVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_extension_versions`](crate::client::Client::list_extension_versions).
///
/// See [`crate::client::fluent_builders::ListExtensionVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListExtensionVersions {
    _private: (),
}
impl ListExtensionVersions {
    /// Creates a new builder-style object to manufacture [`ListExtensionVersionsInput`](crate::input::ListExtensionVersionsInput)
    pub fn builder() -> crate::input::list_extension_versions_input::Builder {
        crate::input::list_extension_versions_input::Builder::default()
    }
    /// Creates a new `ListExtensionVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListExtensionVersions {
    type Output = std::result::Result<
        crate::output::ListExtensionVersionsOutput,
        crate::error::ListExtensionVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_extension_versions_error(response)
        } else {
            crate::operation_deser::parse_list_extension_versions_response(response)
        }
    }
}

/// Operation shape for `ListGames`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_games`](crate::client::Client::list_games).
///
/// See [`crate::client::fluent_builders::ListGames`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListGames {
    _private: (),
}
impl ListGames {
    /// Creates a new builder-style object to manufacture [`ListGamesInput`](crate::input::ListGamesInput)
    pub fn builder() -> crate::input::list_games_input::Builder {
        crate::input::list_games_input::Builder::default()
    }
    /// Creates a new `ListGames` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListGames {
    type Output = std::result::Result<crate::output::ListGamesOutput, crate::error::ListGamesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_games_error(response)
        } else {
            crate::operation_deser::parse_list_games_response(response)
        }
    }
}

/// Operation shape for `ListGeneratedCodeJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_generated_code_jobs`](crate::client::Client::list_generated_code_jobs).
///
/// See [`crate::client::fluent_builders::ListGeneratedCodeJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListGeneratedCodeJobs {
    _private: (),
}
impl ListGeneratedCodeJobs {
    /// Creates a new builder-style object to manufacture [`ListGeneratedCodeJobsInput`](crate::input::ListGeneratedCodeJobsInput)
    pub fn builder() -> crate::input::list_generated_code_jobs_input::Builder {
        crate::input::list_generated_code_jobs_input::Builder::default()
    }
    /// Creates a new `ListGeneratedCodeJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListGeneratedCodeJobs {
    type Output = std::result::Result<
        crate::output::ListGeneratedCodeJobsOutput,
        crate::error::ListGeneratedCodeJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_generated_code_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_generated_code_jobs_response(response)
        }
    }
}

/// Operation shape for `ListSnapshots`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_snapshots`](crate::client::Client::list_snapshots).
///
/// See [`crate::client::fluent_builders::ListSnapshots`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSnapshots {
    _private: (),
}
impl ListSnapshots {
    /// Creates a new builder-style object to manufacture [`ListSnapshotsInput`](crate::input::ListSnapshotsInput)
    pub fn builder() -> crate::input::list_snapshots_input::Builder {
        crate::input::list_snapshots_input::Builder::default()
    }
    /// Creates a new `ListSnapshots` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSnapshots {
    type Output =
        std::result::Result<crate::output::ListSnapshotsOutput, crate::error::ListSnapshotsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_snapshots_error(response)
        } else {
            crate::operation_deser::parse_list_snapshots_response(response)
        }
    }
}

/// Operation shape for `ListStageDeployments`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_stage_deployments`](crate::client::Client::list_stage_deployments).
///
/// See [`crate::client::fluent_builders::ListStageDeployments`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListStageDeployments {
    _private: (),
}
impl ListStageDeployments {
    /// Creates a new builder-style object to manufacture [`ListStageDeploymentsInput`](crate::input::ListStageDeploymentsInput)
    pub fn builder() -> crate::input::list_stage_deployments_input::Builder {
        crate::input::list_stage_deployments_input::Builder::default()
    }
    /// Creates a new `ListStageDeployments` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListStageDeployments {
    type Output = std::result::Result<
        crate::output::ListStageDeploymentsOutput,
        crate::error::ListStageDeploymentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_stage_deployments_error(response)
        } else {
            crate::operation_deser::parse_list_stage_deployments_response(response)
        }
    }
}

/// Operation shape for `ListStages`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_stages`](crate::client::Client::list_stages).
///
/// See [`crate::client::fluent_builders::ListStages`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListStages {
    _private: (),
}
impl ListStages {
    /// Creates a new builder-style object to manufacture [`ListStagesInput`](crate::input::ListStagesInput)
    pub fn builder() -> crate::input::list_stages_input::Builder {
        crate::input::list_stages_input::Builder::default()
    }
    /// Creates a new `ListStages` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListStages {
    type Output =
        std::result::Result<crate::output::ListStagesOutput, crate::error::ListStagesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_stages_error(response)
        } else {
            crate::operation_deser::parse_list_stages_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `StartGeneratedCodeJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_generated_code_job`](crate::client::Client::start_generated_code_job).
///
/// See [`crate::client::fluent_builders::StartGeneratedCodeJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartGeneratedCodeJob {
    _private: (),
}
impl StartGeneratedCodeJob {
    /// Creates a new builder-style object to manufacture [`StartGeneratedCodeJobInput`](crate::input::StartGeneratedCodeJobInput)
    pub fn builder() -> crate::input::start_generated_code_job_input::Builder {
        crate::input::start_generated_code_job_input::Builder::default()
    }
    /// Creates a new `StartGeneratedCodeJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartGeneratedCodeJob {
    type Output = std::result::Result<
        crate::output::StartGeneratedCodeJobOutput,
        crate::error::StartGeneratedCodeJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_generated_code_job_error(response)
        } else {
            crate::operation_deser::parse_start_generated_code_job_response(response)
        }
    }
}

/// Operation shape for `StartStageDeployment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_stage_deployment`](crate::client::Client::start_stage_deployment).
///
/// See [`crate::client::fluent_builders::StartStageDeployment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartStageDeployment {
    _private: (),
}
impl StartStageDeployment {
    /// Creates a new builder-style object to manufacture [`StartStageDeploymentInput`](crate::input::StartStageDeploymentInput)
    pub fn builder() -> crate::input::start_stage_deployment_input::Builder {
        crate::input::start_stage_deployment_input::Builder::default()
    }
    /// Creates a new `StartStageDeployment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartStageDeployment {
    type Output = std::result::Result<
        crate::output::StartStageDeploymentOutput,
        crate::error::StartStageDeploymentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_stage_deployment_error(response)
        } else {
            crate::operation_deser::parse_start_stage_deployment_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateGame`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_game`](crate::client::Client::update_game).
///
/// See [`crate::client::fluent_builders::UpdateGame`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateGame {
    _private: (),
}
impl UpdateGame {
    /// Creates a new builder-style object to manufacture [`UpdateGameInput`](crate::input::UpdateGameInput)
    pub fn builder() -> crate::input::update_game_input::Builder {
        crate::input::update_game_input::Builder::default()
    }
    /// Creates a new `UpdateGame` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateGame {
    type Output =
        std::result::Result<crate::output::UpdateGameOutput, crate::error::UpdateGameError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_game_error(response)
        } else {
            crate::operation_deser::parse_update_game_response(response)
        }
    }
}

/// Operation shape for `UpdateGameConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_game_configuration`](crate::client::Client::update_game_configuration).
///
/// See [`crate::client::fluent_builders::UpdateGameConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateGameConfiguration {
    _private: (),
}
impl UpdateGameConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateGameConfigurationInput`](crate::input::UpdateGameConfigurationInput)
    pub fn builder() -> crate::input::update_game_configuration_input::Builder {
        crate::input::update_game_configuration_input::Builder::default()
    }
    /// Creates a new `UpdateGameConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateGameConfiguration {
    type Output = std::result::Result<
        crate::output::UpdateGameConfigurationOutput,
        crate::error::UpdateGameConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_game_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_game_configuration_response(response)
        }
    }
}

/// Operation shape for `UpdateSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_snapshot`](crate::client::Client::update_snapshot).
///
/// See [`crate::client::fluent_builders::UpdateSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSnapshot {
    _private: (),
}
impl UpdateSnapshot {
    /// Creates a new builder-style object to manufacture [`UpdateSnapshotInput`](crate::input::UpdateSnapshotInput)
    pub fn builder() -> crate::input::update_snapshot_input::Builder {
        crate::input::update_snapshot_input::Builder::default()
    }
    /// Creates a new `UpdateSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSnapshot {
    type Output =
        std::result::Result<crate::output::UpdateSnapshotOutput, crate::error::UpdateSnapshotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_snapshot_error(response)
        } else {
            crate::operation_deser::parse_update_snapshot_response(response)
        }
    }
}

/// Operation shape for `UpdateStage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_stage`](crate::client::Client::update_stage).
///
/// See [`crate::client::fluent_builders::UpdateStage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateStage {
    _private: (),
}
impl UpdateStage {
    /// Creates a new builder-style object to manufacture [`UpdateStageInput`](crate::input::UpdateStageInput)
    pub fn builder() -> crate::input::update_stage_input::Builder {
        crate::input::update_stage_input::Builder::default()
    }
    /// Creates a new `UpdateStage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateStage {
    type Output =
        std::result::Result<crate::output::UpdateStageOutput, crate::error::UpdateStageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_stage_error(response)
        } else {
            crate::operation_deser::parse_update_stage_response(response)
        }
    }
}
