// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Properties that provide details of a stage.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StageDetails {
    /// <p>The name of the stage.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The game key associated with the stage.</p>
    /// <p> The game key is a unique identifier that the game client uses to connect to the GameSparks backend. </p>
    pub game_key: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the stage.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the role used to run the game runtimes deployed to the stage.</p>
    pub role: std::option::Option<std::string::String>,
    /// <p>The description of the stage.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The timestamp of when the stage was created.</p>
    pub created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp of when the stage was last updated.</p>
    pub last_updated: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The state of the stage.</p>
    pub state: std::option::Option<crate::model::StageState>,
    /// <p>The tags associated with the stage.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The Amazon CloudWatch log group for game runtimes deployed to the stage.</p>
    pub log_group: std::option::Option<std::string::String>,
}
impl StageDetails {
    /// <p>The name of the stage.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The game key associated with the stage.</p>
    /// <p> The game key is a unique identifier that the game client uses to connect to the GameSparks backend. </p>
    pub fn game_key(&self) -> std::option::Option<&str> {
        self.game_key.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the stage.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the role used to run the game runtimes deployed to the stage.</p>
    pub fn role(&self) -> std::option::Option<&str> {
        self.role.as_deref()
    }
    /// <p>The description of the stage.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The timestamp of when the stage was created.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created.as_ref()
    }
    /// <p>The timestamp of when the stage was last updated.</p>
    pub fn last_updated(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated.as_ref()
    }
    /// <p>The state of the stage.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::StageState> {
        self.state.as_ref()
    }
    /// <p>The tags associated with the stage.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The Amazon CloudWatch log group for game runtimes deployed to the stage.</p>
    pub fn log_group(&self) -> std::option::Option<&str> {
        self.log_group.as_deref()
    }
}
impl std::fmt::Debug for StageDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StageDetails");
        formatter.field("name", &self.name);
        formatter.field("game_key", &self.game_key);
        formatter.field("arn", &self.arn);
        formatter.field("role", &self.role);
        formatter.field("description", &self.description);
        formatter.field("created", &self.created);
        formatter.field("last_updated", &self.last_updated);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.field("log_group", &self.log_group);
        formatter.finish()
    }
}
/// See [`StageDetails`](crate::model::StageDetails)
pub mod stage_details {
    /// A builder for [`StageDetails`](crate::model::StageDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) game_key: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) state: std::option::Option<crate::model::StageState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) log_group: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the stage.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the stage.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The game key associated with the stage.</p>
        /// <p> The game key is a unique identifier that the game client uses to connect to the GameSparks backend. </p>
        pub fn game_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_key = Some(input.into());
            self
        }
        /// <p>The game key associated with the stage.</p>
        /// <p> The game key is a unique identifier that the game client uses to connect to the GameSparks backend. </p>
        pub fn set_game_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.game_key = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the stage.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the stage.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role used to run the game runtimes deployed to the stage.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role used to run the game runtimes deployed to the stage.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// <p>The description of the stage.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the stage.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The timestamp of when the stage was created.</p>
        pub fn created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>The timestamp of when the stage was created.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created = input;
            self
        }
        /// <p>The timestamp of when the stage was last updated.</p>
        pub fn last_updated(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated = Some(input);
            self
        }
        /// <p>The timestamp of when the stage was last updated.</p>
        pub fn set_last_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated = input;
            self
        }
        /// <p>The state of the stage.</p>
        pub fn state(mut self, input: crate::model::StageState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the stage.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::StageState>) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the stage.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags associated with the stage.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The Amazon CloudWatch log group for game runtimes deployed to the stage.</p>
        pub fn log_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group = Some(input.into());
            self
        }
        /// <p>The Amazon CloudWatch log group for game runtimes deployed to the stage.</p>
        pub fn set_log_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_group = input;
            self
        }
        /// Consumes the builder and constructs a [`StageDetails`](crate::model::StageDetails)
        pub fn build(self) -> crate::model::StageDetails {
            crate::model::StageDetails {
                name: self.name,
                game_key: self.game_key,
                arn: self.arn,
                role: self.role,
                description: self.description,
                created: self.created,
                last_updated: self.last_updated,
                state: self.state,
                tags: self.tags,
                log_group: self.log_group,
            }
        }
    }
}
impl StageDetails {
    /// Creates a new builder-style object to manufacture [`StageDetails`](crate::model::StageDetails)
    pub fn builder() -> crate::model::stage_details::Builder {
        crate::model::stage_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StageState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StageState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => StageState::Active,
            "DELETING" => StageState::Deleting,
            other => StageState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StageState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StageState::from(s))
    }
}
impl StageState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StageState::Active => "ACTIVE",
            StageState::Deleting => "DELETING",
            StageState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "DELETING"]
    }
}
impl AsRef<str> for StageState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Properties that provide details of a snapshot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnapshotDetails {
    /// <p>The identifier of the snapshot.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The description of the snapshot.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The sections in the snapshot.</p>
    pub sections:
        std::option::Option<std::collections::HashMap<std::string::String, crate::model::Section>>,
    /// <p>The timestamp of when the snapshot was created.</p>
    pub created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp of when the snapshot was last updated.</p>
    pub last_updated: std::option::Option<aws_smithy_types::DateTime>,
}
impl SnapshotDetails {
    /// <p>The identifier of the snapshot.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The description of the snapshot.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The sections in the snapshot.</p>
    pub fn sections(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, crate::model::Section>>
    {
        self.sections.as_ref()
    }
    /// <p>The timestamp of when the snapshot was created.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created.as_ref()
    }
    /// <p>The timestamp of when the snapshot was last updated.</p>
    pub fn last_updated(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated.as_ref()
    }
}
impl std::fmt::Debug for SnapshotDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnapshotDetails");
        formatter.field("id", &self.id);
        formatter.field("description", &self.description);
        formatter.field("sections", &self.sections);
        formatter.field("created", &self.created);
        formatter.field("last_updated", &self.last_updated);
        formatter.finish()
    }
}
/// See [`SnapshotDetails`](crate::model::SnapshotDetails)
pub mod snapshot_details {
    /// A builder for [`SnapshotDetails`](crate::model::SnapshotDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) sections: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::Section>,
        >,
        pub(crate) created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The identifier of the snapshot.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the snapshot.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The description of the snapshot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the snapshot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `sections`.
        ///
        /// To override the contents of this collection use [`set_sections`](Self::set_sections).
        ///
        /// <p>The sections in the snapshot.</p>
        pub fn sections(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::Section,
        ) -> Self {
            let mut hash_map = self.sections.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.sections = Some(hash_map);
            self
        }
        /// <p>The sections in the snapshot.</p>
        pub fn set_sections(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Section>,
            >,
        ) -> Self {
            self.sections = input;
            self
        }
        /// <p>The timestamp of when the snapshot was created.</p>
        pub fn created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>The timestamp of when the snapshot was created.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created = input;
            self
        }
        /// <p>The timestamp of when the snapshot was last updated.</p>
        pub fn last_updated(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated = Some(input);
            self
        }
        /// <p>The timestamp of when the snapshot was last updated.</p>
        pub fn set_last_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated = input;
            self
        }
        /// Consumes the builder and constructs a [`SnapshotDetails`](crate::model::SnapshotDetails)
        pub fn build(self) -> crate::model::SnapshotDetails {
            crate::model::SnapshotDetails {
                id: self.id,
                description: self.description,
                sections: self.sections,
                created: self.created,
                last_updated: self.last_updated,
            }
        }
    }
}
impl SnapshotDetails {
    /// Creates a new builder-style object to manufacture [`SnapshotDetails`](crate::model::SnapshotDetails)
    pub fn builder() -> crate::model::snapshot_details::Builder {
        crate::model::snapshot_details::Builder::default()
    }
}

/// <p>The configuration section.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Section {
    /// <p>The name of the section.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The size, in bytes, of the section contents.</p>
    pub size: i32,
    /// <p>The content of a configuration section.</p>
    pub attributes: std::option::Option<aws_smithy_types::Document>,
}
impl Section {
    /// <p>The name of the section.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The size, in bytes, of the section contents.</p>
    pub fn size(&self) -> i32 {
        self.size
    }
    /// <p>The content of a configuration section.</p>
    pub fn attributes(&self) -> std::option::Option<&aws_smithy_types::Document> {
        self.attributes.as_ref()
    }
}
impl std::fmt::Debug for Section {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Section");
        formatter.field("name", &self.name);
        formatter.field("size", &self.size);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`Section`](crate::model::Section)
pub mod section {
    /// A builder for [`Section`](crate::model::Section)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) size: std::option::Option<i32>,
        pub(crate) attributes: std::option::Option<aws_smithy_types::Document>,
    }
    impl Builder {
        /// <p>The name of the section.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the section.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The size, in bytes, of the section contents.</p>
        pub fn size(mut self, input: i32) -> Self {
            self.size = Some(input);
            self
        }
        /// <p>The size, in bytes, of the section contents.</p>
        pub fn set_size(mut self, input: std::option::Option<i32>) -> Self {
            self.size = input;
            self
        }
        /// <p>The content of a configuration section.</p>
        pub fn attributes(mut self, input: aws_smithy_types::Document) -> Self {
            self.attributes = Some(input);
            self
        }
        /// <p>The content of a configuration section.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<aws_smithy_types::Document>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`Section`](crate::model::Section)
        pub fn build(self) -> crate::model::Section {
            crate::model::Section {
                name: self.name,
                size: self.size.unwrap_or_default(),
                attributes: self.attributes,
            }
        }
    }
}
impl Section {
    /// Creates a new builder-style object to manufacture [`Section`](crate::model::Section)
    pub fn builder() -> crate::model::section::Builder {
        crate::model::section::Builder::default()
    }
}

/// <p>Details about the game configuration.</p>
/// <p> The game configuration is organized into named sections, where the schema of each section is defined by an extension. The schema for these sections can be retrieved using the <code>GetExtensionVersion</code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GameConfigurationDetails {
    /// <p>Configuration data, organized by section name.</p>
    pub sections:
        std::option::Option<std::collections::HashMap<std::string::String, crate::model::Section>>,
    /// <p>The date when the game was created.</p>
    pub created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date when the game was last modified.</p>
    pub last_updated: std::option::Option<aws_smithy_types::DateTime>,
}
impl GameConfigurationDetails {
    /// <p>Configuration data, organized by section name.</p>
    pub fn sections(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, crate::model::Section>>
    {
        self.sections.as_ref()
    }
    /// <p>The date when the game was created.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created.as_ref()
    }
    /// <p>The date when the game was last modified.</p>
    pub fn last_updated(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated.as_ref()
    }
}
impl std::fmt::Debug for GameConfigurationDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GameConfigurationDetails");
        formatter.field("sections", &self.sections);
        formatter.field("created", &self.created);
        formatter.field("last_updated", &self.last_updated);
        formatter.finish()
    }
}
/// See [`GameConfigurationDetails`](crate::model::GameConfigurationDetails)
pub mod game_configuration_details {
    /// A builder for [`GameConfigurationDetails`](crate::model::GameConfigurationDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sections: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::Section>,
        >,
        pub(crate) created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// Adds a key-value pair to `sections`.
        ///
        /// To override the contents of this collection use [`set_sections`](Self::set_sections).
        ///
        /// <p>Configuration data, organized by section name.</p>
        pub fn sections(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::Section,
        ) -> Self {
            let mut hash_map = self.sections.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.sections = Some(hash_map);
            self
        }
        /// <p>Configuration data, organized by section name.</p>
        pub fn set_sections(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Section>,
            >,
        ) -> Self {
            self.sections = input;
            self
        }
        /// <p>The date when the game was created.</p>
        pub fn created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>The date when the game was created.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created = input;
            self
        }
        /// <p>The date when the game was last modified.</p>
        pub fn last_updated(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated = Some(input);
            self
        }
        /// <p>The date when the game was last modified.</p>
        pub fn set_last_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated = input;
            self
        }
        /// Consumes the builder and constructs a [`GameConfigurationDetails`](crate::model::GameConfigurationDetails)
        pub fn build(self) -> crate::model::GameConfigurationDetails {
            crate::model::GameConfigurationDetails {
                sections: self.sections,
                created: self.created,
                last_updated: self.last_updated,
            }
        }
    }
}
impl GameConfigurationDetails {
    /// Creates a new builder-style object to manufacture [`GameConfigurationDetails`](crate::model::GameConfigurationDetails)
    pub fn builder() -> crate::model::game_configuration_details::Builder {
        crate::model::game_configuration_details::Builder::default()
    }
}

/// <p>A single modification to the configuration section.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SectionModification {
    /// <p>The name of the section to be modified.</p>
    pub section: std::option::Option<std::string::String>,
    /// <p>The path within the section content to be modified.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>The operation to be performed on a configuration section.</p>
    /// <p> Content can be added, deleted, or replaced within a section. </p>
    pub operation: std::option::Option<crate::model::Operation>,
    /// <p>For add and replace operations, this is the value that will be used.</p>
    /// <p> This field should be omitted for delete operations. </p>
    pub value: std::option::Option<aws_smithy_types::Document>,
}
impl SectionModification {
    /// <p>The name of the section to be modified.</p>
    pub fn section(&self) -> std::option::Option<&str> {
        self.section.as_deref()
    }
    /// <p>The path within the section content to be modified.</p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
    /// <p>The operation to be performed on a configuration section.</p>
    /// <p> Content can be added, deleted, or replaced within a section. </p>
    pub fn operation(&self) -> std::option::Option<&crate::model::Operation> {
        self.operation.as_ref()
    }
    /// <p>For add and replace operations, this is the value that will be used.</p>
    /// <p> This field should be omitted for delete operations. </p>
    pub fn value(&self) -> std::option::Option<&aws_smithy_types::Document> {
        self.value.as_ref()
    }
}
impl std::fmt::Debug for SectionModification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SectionModification");
        formatter.field("section", &self.section);
        formatter.field("path", &self.path);
        formatter.field("operation", &self.operation);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`SectionModification`](crate::model::SectionModification)
pub mod section_modification {
    /// A builder for [`SectionModification`](crate::model::SectionModification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) section: std::option::Option<std::string::String>,
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) operation: std::option::Option<crate::model::Operation>,
        pub(crate) value: std::option::Option<aws_smithy_types::Document>,
    }
    impl Builder {
        /// <p>The name of the section to be modified.</p>
        pub fn section(mut self, input: impl Into<std::string::String>) -> Self {
            self.section = Some(input.into());
            self
        }
        /// <p>The name of the section to be modified.</p>
        pub fn set_section(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.section = input;
            self
        }
        /// <p>The path within the section content to be modified.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The path within the section content to be modified.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The operation to be performed on a configuration section.</p>
        /// <p> Content can be added, deleted, or replaced within a section. </p>
        pub fn operation(mut self, input: crate::model::Operation) -> Self {
            self.operation = Some(input);
            self
        }
        /// <p>The operation to be performed on a configuration section.</p>
        /// <p> Content can be added, deleted, or replaced within a section. </p>
        pub fn set_operation(
            mut self,
            input: std::option::Option<crate::model::Operation>,
        ) -> Self {
            self.operation = input;
            self
        }
        /// <p>For add and replace operations, this is the value that will be used.</p>
        /// <p> This field should be omitted for delete operations. </p>
        pub fn value(mut self, input: aws_smithy_types::Document) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>For add and replace operations, this is the value that will be used.</p>
        /// <p> This field should be omitted for delete operations. </p>
        pub fn set_value(mut self, input: std::option::Option<aws_smithy_types::Document>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`SectionModification`](crate::model::SectionModification)
        pub fn build(self) -> crate::model::SectionModification {
            crate::model::SectionModification {
                section: self.section,
                path: self.path,
                operation: self.operation,
                value: self.value,
            }
        }
    }
}
impl SectionModification {
    /// Creates a new builder-style object to manufacture [`SectionModification`](crate::model::SectionModification)
    pub fn builder() -> crate::model::section_modification::Builder {
        crate::model::section_modification::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Operation {
    #[allow(missing_docs)] // documentation missing in model
    Add,
    #[allow(missing_docs)] // documentation missing in model
    Remove,
    #[allow(missing_docs)] // documentation missing in model
    Replace,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Operation {
    fn from(s: &str) -> Self {
        match s {
            "ADD" => Operation::Add,
            "REMOVE" => Operation::Remove,
            "REPLACE" => Operation::Replace,
            other => Operation::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Operation {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Operation::from(s))
    }
}
impl Operation {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Operation::Add => "ADD",
            Operation::Remove => "REMOVE",
            Operation::Replace => "REPLACE",
            Operation::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ADD", "REMOVE", "REPLACE"]
    }
}
impl AsRef<str> for Operation {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details about a game.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GameDetails {
    /// <p>The name of the game.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of this game.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The description of the game.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date when the game was created.</p>
    pub created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date when the game was last modified.</p>
    pub last_updated: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The state of the game.</p>
    pub state: std::option::Option<crate::model::GameState>,
    /// <p>Determines if the game can be deleted.</p>
    pub enable_termination_protection: bool,
    /// <p>The tags associated with the game.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl GameDetails {
    /// <p>The name of the game.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of this game.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The description of the game.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date when the game was created.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created.as_ref()
    }
    /// <p>The date when the game was last modified.</p>
    pub fn last_updated(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated.as_ref()
    }
    /// <p>The state of the game.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::GameState> {
        self.state.as_ref()
    }
    /// <p>Determines if the game can be deleted.</p>
    pub fn enable_termination_protection(&self) -> bool {
        self.enable_termination_protection
    }
    /// <p>The tags associated with the game.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for GameDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GameDetails");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("description", &self.description);
        formatter.field("created", &self.created);
        formatter.field("last_updated", &self.last_updated);
        formatter.field("state", &self.state);
        formatter.field(
            "enable_termination_protection",
            &self.enable_termination_protection,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GameDetails`](crate::model::GameDetails)
pub mod game_details {
    /// A builder for [`GameDetails`](crate::model::GameDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) state: std::option::Option<crate::model::GameState>,
        pub(crate) enable_termination_protection: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the game.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of this game.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of this game.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The description of the game.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the game.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date when the game was created.</p>
        pub fn created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>The date when the game was created.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created = input;
            self
        }
        /// <p>The date when the game was last modified.</p>
        pub fn last_updated(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated = Some(input);
            self
        }
        /// <p>The date when the game was last modified.</p>
        pub fn set_last_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated = input;
            self
        }
        /// <p>The state of the game.</p>
        pub fn state(mut self, input: crate::model::GameState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the game.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::GameState>) -> Self {
            self.state = input;
            self
        }
        /// <p>Determines if the game can be deleted.</p>
        pub fn enable_termination_protection(mut self, input: bool) -> Self {
            self.enable_termination_protection = Some(input);
            self
        }
        /// <p>Determines if the game can be deleted.</p>
        pub fn set_enable_termination_protection(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_termination_protection = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the game.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags associated with the game.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GameDetails`](crate::model::GameDetails)
        pub fn build(self) -> crate::model::GameDetails {
            crate::model::GameDetails {
                name: self.name,
                arn: self.arn,
                description: self.description,
                created: self.created,
                last_updated: self.last_updated,
                state: self.state,
                enable_termination_protection: self
                    .enable_termination_protection
                    .unwrap_or_default(),
                tags: self.tags,
            }
        }
    }
}
impl GameDetails {
    /// Creates a new builder-style object to manufacture [`GameDetails`](crate::model::GameDetails)
    pub fn builder() -> crate::model::game_details::Builder {
        crate::model::game_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GameState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GameState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => GameState::Active,
            "DELETING" => GameState::Deleting,
            other => GameState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GameState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GameState::from(s))
    }
}
impl GameState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GameState::Active => "ACTIVE",
            GameState::Deleting => "DELETING",
            GameState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "DELETING"]
    }
}
impl AsRef<str> for GameState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Properties that provide details of a stage deployment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StageDeploymentDetails {
    /// <p>The identifier of the deployment.</p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the snapshot associated with the stage deployment.</p>
    pub snapshot_id: std::option::Option<std::string::String>,
    /// <p>The type of action of the stage deployment.</p>
    pub deployment_action: std::option::Option<crate::model::DeploymentAction>,
    /// <p>The state of the deployment.</p>
    pub deployment_state: std::option::Option<crate::model::DeploymentState>,
    /// <p>The timestamp of when the stage deployment was created.</p>
    pub created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp of when the deployment was last updated.</p>
    pub last_updated: std::option::Option<aws_smithy_types::DateTime>,
}
impl StageDeploymentDetails {
    /// <p>The identifier of the deployment.</p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p>The identifier of the snapshot associated with the stage deployment.</p>
    pub fn snapshot_id(&self) -> std::option::Option<&str> {
        self.snapshot_id.as_deref()
    }
    /// <p>The type of action of the stage deployment.</p>
    pub fn deployment_action(&self) -> std::option::Option<&crate::model::DeploymentAction> {
        self.deployment_action.as_ref()
    }
    /// <p>The state of the deployment.</p>
    pub fn deployment_state(&self) -> std::option::Option<&crate::model::DeploymentState> {
        self.deployment_state.as_ref()
    }
    /// <p>The timestamp of when the stage deployment was created.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created.as_ref()
    }
    /// <p>The timestamp of when the deployment was last updated.</p>
    pub fn last_updated(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated.as_ref()
    }
}
impl std::fmt::Debug for StageDeploymentDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StageDeploymentDetails");
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("snapshot_id", &self.snapshot_id);
        formatter.field("deployment_action", &self.deployment_action);
        formatter.field("deployment_state", &self.deployment_state);
        formatter.field("created", &self.created);
        formatter.field("last_updated", &self.last_updated);
        formatter.finish()
    }
}
/// See [`StageDeploymentDetails`](crate::model::StageDeploymentDetails)
pub mod stage_deployment_details {
    /// A builder for [`StageDeploymentDetails`](crate::model::StageDeploymentDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) snapshot_id: std::option::Option<std::string::String>,
        pub(crate) deployment_action: std::option::Option<crate::model::DeploymentAction>,
        pub(crate) deployment_state: std::option::Option<crate::model::DeploymentState>,
        pub(crate) created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The identifier of the deployment.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p>The identifier of the deployment.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p>The identifier of the snapshot associated with the stage deployment.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the snapshot associated with the stage deployment.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.snapshot_id = input;
            self
        }
        /// <p>The type of action of the stage deployment.</p>
        pub fn deployment_action(mut self, input: crate::model::DeploymentAction) -> Self {
            self.deployment_action = Some(input);
            self
        }
        /// <p>The type of action of the stage deployment.</p>
        pub fn set_deployment_action(
            mut self,
            input: std::option::Option<crate::model::DeploymentAction>,
        ) -> Self {
            self.deployment_action = input;
            self
        }
        /// <p>The state of the deployment.</p>
        pub fn deployment_state(mut self, input: crate::model::DeploymentState) -> Self {
            self.deployment_state = Some(input);
            self
        }
        /// <p>The state of the deployment.</p>
        pub fn set_deployment_state(
            mut self,
            input: std::option::Option<crate::model::DeploymentState>,
        ) -> Self {
            self.deployment_state = input;
            self
        }
        /// <p>The timestamp of when the stage deployment was created.</p>
        pub fn created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>The timestamp of when the stage deployment was created.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created = input;
            self
        }
        /// <p>The timestamp of when the deployment was last updated.</p>
        pub fn last_updated(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated = Some(input);
            self
        }
        /// <p>The timestamp of when the deployment was last updated.</p>
        pub fn set_last_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated = input;
            self
        }
        /// Consumes the builder and constructs a [`StageDeploymentDetails`](crate::model::StageDeploymentDetails)
        pub fn build(self) -> crate::model::StageDeploymentDetails {
            crate::model::StageDeploymentDetails {
                deployment_id: self.deployment_id,
                snapshot_id: self.snapshot_id,
                deployment_action: self.deployment_action,
                deployment_state: self.deployment_state,
                created: self.created,
                last_updated: self.last_updated,
            }
        }
    }
}
impl StageDeploymentDetails {
    /// Creates a new builder-style object to manufacture [`StageDeploymentDetails`](crate::model::StageDeploymentDetails)
    pub fn builder() -> crate::model::stage_deployment_details::Builder {
        crate::model::stage_deployment_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeploymentState {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeploymentState {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => DeploymentState::Completed,
            "FAILED" => DeploymentState::Failed,
            "IN_PROGRESS" => DeploymentState::InProgress,
            "PENDING" => DeploymentState::Pending,
            other => DeploymentState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeploymentState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeploymentState::from(s))
    }
}
impl DeploymentState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeploymentState::Completed => "COMPLETED",
            DeploymentState::Failed => "FAILED",
            DeploymentState::InProgress => "IN_PROGRESS",
            DeploymentState::Pending => "PENDING",
            DeploymentState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETED", "FAILED", "IN_PROGRESS", "PENDING"]
    }
}
impl AsRef<str> for DeploymentState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeploymentAction {
    #[allow(missing_docs)] // documentation missing in model
    Deploy,
    #[allow(missing_docs)] // documentation missing in model
    Undeploy,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeploymentAction {
    fn from(s: &str) -> Self {
        match s {
            "DEPLOY" => DeploymentAction::Deploy,
            "UNDEPLOY" => DeploymentAction::Undeploy,
            other => DeploymentAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeploymentAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeploymentAction::from(s))
    }
}
impl DeploymentAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeploymentAction::Deploy => "DEPLOY",
            DeploymentAction::Undeploy => "UNDEPLOY",
            DeploymentAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEPLOY", "UNDEPLOY"]
    }
}
impl AsRef<str> for DeploymentAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Properties that specify the code generator for a generated code job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Generator {
    /// <p>The platform that will be used to run the generated code.</p>
    pub target_platform: std::option::Option<std::string::String>,
    /// <p>The programming language for the generated code.</p>
    /// <p> Not all languages are supported for each platform. For cases where multiple languages are supported, this parameter specifies the language to be used. If this value is omitted, the default language for the target platform will be used. </p>
    pub language: std::option::Option<std::string::String>,
    /// <p>The target version of the GameSparks Game SDK.</p>
    pub game_sdk_version: std::option::Option<std::string::String>,
}
impl Generator {
    /// <p>The platform that will be used to run the generated code.</p>
    pub fn target_platform(&self) -> std::option::Option<&str> {
        self.target_platform.as_deref()
    }
    /// <p>The programming language for the generated code.</p>
    /// <p> Not all languages are supported for each platform. For cases where multiple languages are supported, this parameter specifies the language to be used. If this value is omitted, the default language for the target platform will be used. </p>
    pub fn language(&self) -> std::option::Option<&str> {
        self.language.as_deref()
    }
    /// <p>The target version of the GameSparks Game SDK.</p>
    pub fn game_sdk_version(&self) -> std::option::Option<&str> {
        self.game_sdk_version.as_deref()
    }
}
impl std::fmt::Debug for Generator {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Generator");
        formatter.field("target_platform", &self.target_platform);
        formatter.field("language", &self.language);
        formatter.field("game_sdk_version", &self.game_sdk_version);
        formatter.finish()
    }
}
/// See [`Generator`](crate::model::Generator)
pub mod generator {
    /// A builder for [`Generator`](crate::model::Generator)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_platform: std::option::Option<std::string::String>,
        pub(crate) language: std::option::Option<std::string::String>,
        pub(crate) game_sdk_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The platform that will be used to run the generated code.</p>
        pub fn target_platform(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_platform = Some(input.into());
            self
        }
        /// <p>The platform that will be used to run the generated code.</p>
        pub fn set_target_platform(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_platform = input;
            self
        }
        /// <p>The programming language for the generated code.</p>
        /// <p> Not all languages are supported for each platform. For cases where multiple languages are supported, this parameter specifies the language to be used. If this value is omitted, the default language for the target platform will be used. </p>
        pub fn language(mut self, input: impl Into<std::string::String>) -> Self {
            self.language = Some(input.into());
            self
        }
        /// <p>The programming language for the generated code.</p>
        /// <p> Not all languages are supported for each platform. For cases where multiple languages are supported, this parameter specifies the language to be used. If this value is omitted, the default language for the target platform will be used. </p>
        pub fn set_language(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.language = input;
            self
        }
        /// <p>The target version of the GameSparks Game SDK.</p>
        pub fn game_sdk_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_sdk_version = Some(input.into());
            self
        }
        /// <p>The target version of the GameSparks Game SDK.</p>
        pub fn set_game_sdk_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_sdk_version = input;
            self
        }
        /// Consumes the builder and constructs a [`Generator`](crate::model::Generator)
        pub fn build(self) -> crate::model::Generator {
            crate::model::Generator {
                target_platform: self.target_platform,
                language: self.language,
                game_sdk_version: self.game_sdk_version,
            }
        }
    }
}
impl Generator {
    /// Creates a new builder-style object to manufacture [`Generator`](crate::model::Generator)
    pub fn builder() -> crate::model::generator::Builder {
        crate::model::generator::Builder::default()
    }
}

/// <p>The summary of the properties of a stage.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StageSummary {
    /// <p>The name of the stage.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The game key associated with the stage.</p>
    /// <p> The game key is a unique identifier that the game client uses to connect to the GameSparks backend. </p>
    pub game_key: std::option::Option<std::string::String>,
    /// <p>The description of the stage.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The state of the stage.</p>
    pub state: std::option::Option<crate::model::StageState>,
    /// <p>The tags associated with the stage.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl StageSummary {
    /// <p>The name of the stage.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The game key associated with the stage.</p>
    /// <p> The game key is a unique identifier that the game client uses to connect to the GameSparks backend. </p>
    pub fn game_key(&self) -> std::option::Option<&str> {
        self.game_key.as_deref()
    }
    /// <p>The description of the stage.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The state of the stage.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::StageState> {
        self.state.as_ref()
    }
    /// <p>The tags associated with the stage.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for StageSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StageSummary");
        formatter.field("name", &self.name);
        formatter.field("game_key", &self.game_key);
        formatter.field("description", &self.description);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`StageSummary`](crate::model::StageSummary)
pub mod stage_summary {
    /// A builder for [`StageSummary`](crate::model::StageSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) game_key: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::StageState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the stage.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the stage.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The game key associated with the stage.</p>
        /// <p> The game key is a unique identifier that the game client uses to connect to the GameSparks backend. </p>
        pub fn game_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_key = Some(input.into());
            self
        }
        /// <p>The game key associated with the stage.</p>
        /// <p> The game key is a unique identifier that the game client uses to connect to the GameSparks backend. </p>
        pub fn set_game_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.game_key = input;
            self
        }
        /// <p>The description of the stage.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the stage.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The state of the stage.</p>
        pub fn state(mut self, input: crate::model::StageState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the stage.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::StageState>) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the stage.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags associated with the stage.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`StageSummary`](crate::model::StageSummary)
        pub fn build(self) -> crate::model::StageSummary {
            crate::model::StageSummary {
                name: self.name,
                game_key: self.game_key,
                description: self.description,
                state: self.state,
                tags: self.tags,
            }
        }
    }
}
impl StageSummary {
    /// Creates a new builder-style object to manufacture [`StageSummary`](crate::model::StageSummary)
    pub fn builder() -> crate::model::stage_summary::Builder {
        crate::model::stage_summary::Builder::default()
    }
}

/// <p>The summary of the properties of a stage deployment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StageDeploymentSummary {
    /// <p>The identifier of the deployment.</p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the snapshot associated with the stage deployment.</p>
    pub snapshot_id: std::option::Option<std::string::String>,
    /// <p>The type of action of the deployment.</p>
    pub deployment_action: std::option::Option<crate::model::DeploymentAction>,
    /// <p>The state of the deployment.</p>
    pub deployment_state: std::option::Option<crate::model::DeploymentState>,
    /// <p>The timestamp of when the deployment was last updated.</p>
    pub last_updated: std::option::Option<aws_smithy_types::DateTime>,
}
impl StageDeploymentSummary {
    /// <p>The identifier of the deployment.</p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p>The identifier of the snapshot associated with the stage deployment.</p>
    pub fn snapshot_id(&self) -> std::option::Option<&str> {
        self.snapshot_id.as_deref()
    }
    /// <p>The type of action of the deployment.</p>
    pub fn deployment_action(&self) -> std::option::Option<&crate::model::DeploymentAction> {
        self.deployment_action.as_ref()
    }
    /// <p>The state of the deployment.</p>
    pub fn deployment_state(&self) -> std::option::Option<&crate::model::DeploymentState> {
        self.deployment_state.as_ref()
    }
    /// <p>The timestamp of when the deployment was last updated.</p>
    pub fn last_updated(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated.as_ref()
    }
}
impl std::fmt::Debug for StageDeploymentSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StageDeploymentSummary");
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("snapshot_id", &self.snapshot_id);
        formatter.field("deployment_action", &self.deployment_action);
        formatter.field("deployment_state", &self.deployment_state);
        formatter.field("last_updated", &self.last_updated);
        formatter.finish()
    }
}
/// See [`StageDeploymentSummary`](crate::model::StageDeploymentSummary)
pub mod stage_deployment_summary {
    /// A builder for [`StageDeploymentSummary`](crate::model::StageDeploymentSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) snapshot_id: std::option::Option<std::string::String>,
        pub(crate) deployment_action: std::option::Option<crate::model::DeploymentAction>,
        pub(crate) deployment_state: std::option::Option<crate::model::DeploymentState>,
        pub(crate) last_updated: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The identifier of the deployment.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p>The identifier of the deployment.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p>The identifier of the snapshot associated with the stage deployment.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the snapshot associated with the stage deployment.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.snapshot_id = input;
            self
        }
        /// <p>The type of action of the deployment.</p>
        pub fn deployment_action(mut self, input: crate::model::DeploymentAction) -> Self {
            self.deployment_action = Some(input);
            self
        }
        /// <p>The type of action of the deployment.</p>
        pub fn set_deployment_action(
            mut self,
            input: std::option::Option<crate::model::DeploymentAction>,
        ) -> Self {
            self.deployment_action = input;
            self
        }
        /// <p>The state of the deployment.</p>
        pub fn deployment_state(mut self, input: crate::model::DeploymentState) -> Self {
            self.deployment_state = Some(input);
            self
        }
        /// <p>The state of the deployment.</p>
        pub fn set_deployment_state(
            mut self,
            input: std::option::Option<crate::model::DeploymentState>,
        ) -> Self {
            self.deployment_state = input;
            self
        }
        /// <p>The timestamp of when the deployment was last updated.</p>
        pub fn last_updated(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated = Some(input);
            self
        }
        /// <p>The timestamp of when the deployment was last updated.</p>
        pub fn set_last_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated = input;
            self
        }
        /// Consumes the builder and constructs a [`StageDeploymentSummary`](crate::model::StageDeploymentSummary)
        pub fn build(self) -> crate::model::StageDeploymentSummary {
            crate::model::StageDeploymentSummary {
                deployment_id: self.deployment_id,
                snapshot_id: self.snapshot_id,
                deployment_action: self.deployment_action,
                deployment_state: self.deployment_state,
                last_updated: self.last_updated,
            }
        }
    }
}
impl StageDeploymentSummary {
    /// Creates a new builder-style object to manufacture [`StageDeploymentSummary`](crate::model::StageDeploymentSummary)
    pub fn builder() -> crate::model::stage_deployment_summary::Builder {
        crate::model::stage_deployment_summary::Builder::default()
    }
}

/// <p>The summary of the properties of a snapshot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnapshotSummary {
    /// <p>The identifier of the snapshot.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The description of the snapshot.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The timestamp of when the snapshot was created.</p>
    pub created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Then timestamp of when the snapshot was last updated.</p>
    pub last_updated: std::option::Option<aws_smithy_types::DateTime>,
}
impl SnapshotSummary {
    /// <p>The identifier of the snapshot.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The description of the snapshot.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The timestamp of when the snapshot was created.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created.as_ref()
    }
    /// <p>Then timestamp of when the snapshot was last updated.</p>
    pub fn last_updated(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated.as_ref()
    }
}
impl std::fmt::Debug for SnapshotSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnapshotSummary");
        formatter.field("id", &self.id);
        formatter.field("description", &self.description);
        formatter.field("created", &self.created);
        formatter.field("last_updated", &self.last_updated);
        formatter.finish()
    }
}
/// See [`SnapshotSummary`](crate::model::SnapshotSummary)
pub mod snapshot_summary {
    /// A builder for [`SnapshotSummary`](crate::model::SnapshotSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The identifier of the snapshot.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the snapshot.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The description of the snapshot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the snapshot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The timestamp of when the snapshot was created.</p>
        pub fn created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>The timestamp of when the snapshot was created.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created = input;
            self
        }
        /// <p>Then timestamp of when the snapshot was last updated.</p>
        pub fn last_updated(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated = Some(input);
            self
        }
        /// <p>Then timestamp of when the snapshot was last updated.</p>
        pub fn set_last_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated = input;
            self
        }
        /// Consumes the builder and constructs a [`SnapshotSummary`](crate::model::SnapshotSummary)
        pub fn build(self) -> crate::model::SnapshotSummary {
            crate::model::SnapshotSummary {
                id: self.id,
                description: self.description,
                created: self.created,
                last_updated: self.last_updated,
            }
        }
    }
}
impl SnapshotSummary {
    /// Creates a new builder-style object to manufacture [`SnapshotSummary`](crate::model::SnapshotSummary)
    pub fn builder() -> crate::model::snapshot_summary::Builder {
        crate::model::snapshot_summary::Builder::default()
    }
}

/// <p>Details about a generated code job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GeneratedCodeJobDetails {
    /// <p>A presigned URL that can be used to download the generated code.</p>
    pub s3_url: std::option::Option<std::string::String>,
    /// <p>The status of the generated code job</p>
    pub status: std::option::Option<crate::model::GeneratedCodeJobState>,
    /// <p>The description of the generated code job.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The expiration date and time for the download URL.</p>
    /// <p> The download URL us guaranteed to be available until at least this time. </p>
    pub expiration_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The identifier for the generated code job.</p>
    pub generated_code_job_id: std::option::Option<std::string::String>,
}
impl GeneratedCodeJobDetails {
    /// <p>A presigned URL that can be used to download the generated code.</p>
    pub fn s3_url(&self) -> std::option::Option<&str> {
        self.s3_url.as_deref()
    }
    /// <p>The status of the generated code job</p>
    pub fn status(&self) -> std::option::Option<&crate::model::GeneratedCodeJobState> {
        self.status.as_ref()
    }
    /// <p>The description of the generated code job.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The expiration date and time for the download URL.</p>
    /// <p> The download URL us guaranteed to be available until at least this time. </p>
    pub fn expiration_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.expiration_time.as_ref()
    }
    /// <p>The identifier for the generated code job.</p>
    pub fn generated_code_job_id(&self) -> std::option::Option<&str> {
        self.generated_code_job_id.as_deref()
    }
}
impl std::fmt::Debug for GeneratedCodeJobDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GeneratedCodeJobDetails");
        formatter.field("s3_url", &self.s3_url);
        formatter.field("status", &self.status);
        formatter.field("description", &self.description);
        formatter.field("expiration_time", &self.expiration_time);
        formatter.field("generated_code_job_id", &self.generated_code_job_id);
        formatter.finish()
    }
}
/// See [`GeneratedCodeJobDetails`](crate::model::GeneratedCodeJobDetails)
pub mod generated_code_job_details {
    /// A builder for [`GeneratedCodeJobDetails`](crate::model::GeneratedCodeJobDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_url: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::GeneratedCodeJobState>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) expiration_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) generated_code_job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A presigned URL that can be used to download the generated code.</p>
        pub fn s3_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_url = Some(input.into());
            self
        }
        /// <p>A presigned URL that can be used to download the generated code.</p>
        pub fn set_s3_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_url = input;
            self
        }
        /// <p>The status of the generated code job</p>
        pub fn status(mut self, input: crate::model::GeneratedCodeJobState) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the generated code job</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::GeneratedCodeJobState>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The description of the generated code job.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the generated code job.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The expiration date and time for the download URL.</p>
        /// <p> The download URL us guaranteed to be available until at least this time. </p>
        pub fn expiration_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.expiration_time = Some(input);
            self
        }
        /// <p>The expiration date and time for the download URL.</p>
        /// <p> The download URL us guaranteed to be available until at least this time. </p>
        pub fn set_expiration_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.expiration_time = input;
            self
        }
        /// <p>The identifier for the generated code job.</p>
        pub fn generated_code_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.generated_code_job_id = Some(input.into());
            self
        }
        /// <p>The identifier for the generated code job.</p>
        pub fn set_generated_code_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.generated_code_job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GeneratedCodeJobDetails`](crate::model::GeneratedCodeJobDetails)
        pub fn build(self) -> crate::model::GeneratedCodeJobDetails {
            crate::model::GeneratedCodeJobDetails {
                s3_url: self.s3_url,
                status: self.status,
                description: self.description,
                expiration_time: self.expiration_time,
                generated_code_job_id: self.generated_code_job_id,
            }
        }
    }
}
impl GeneratedCodeJobDetails {
    /// Creates a new builder-style object to manufacture [`GeneratedCodeJobDetails`](crate::model::GeneratedCodeJobDetails)
    pub fn builder() -> crate::model::generated_code_job_details::Builder {
        crate::model::generated_code_job_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GeneratedCodeJobState {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GeneratedCodeJobState {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => GeneratedCodeJobState::Completed,
            "FAILED" => GeneratedCodeJobState::Failed,
            "IN_PROGRESS" => GeneratedCodeJobState::InProgress,
            "PENDING" => GeneratedCodeJobState::Pending,
            other => GeneratedCodeJobState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GeneratedCodeJobState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GeneratedCodeJobState::from(s))
    }
}
impl GeneratedCodeJobState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GeneratedCodeJobState::Completed => "COMPLETED",
            GeneratedCodeJobState::Failed => "FAILED",
            GeneratedCodeJobState::InProgress => "IN_PROGRESS",
            GeneratedCodeJobState::Pending => "PENDING",
            GeneratedCodeJobState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETED", "FAILED", "IN_PROGRESS", "PENDING"]
    }
}
impl AsRef<str> for GeneratedCodeJobState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The summary of the properties of a game.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GameSummary {
    /// <p>The name of the game.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the game.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The state of the game.</p>
    pub state: std::option::Option<crate::model::GameState>,
    /// <p>The tags associated with the game.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl GameSummary {
    /// <p>The name of the game.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the game.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The state of the game.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::GameState> {
        self.state.as_ref()
    }
    /// <p>The tags associated with the game.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for GameSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GameSummary");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GameSummary`](crate::model::GameSummary)
pub mod game_summary {
    /// A builder for [`GameSummary`](crate::model::GameSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::GameState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the game.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the game.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the game.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The state of the game.</p>
        pub fn state(mut self, input: crate::model::GameState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the game.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::GameState>) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the game.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags associated with the game.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GameSummary`](crate::model::GameSummary)
        pub fn build(self) -> crate::model::GameSummary {
            crate::model::GameSummary {
                name: self.name,
                description: self.description,
                state: self.state,
                tags: self.tags,
            }
        }
    }
}
impl GameSummary {
    /// Creates a new builder-style object to manufacture [`GameSummary`](crate::model::GameSummary)
    pub fn builder() -> crate::model::game_summary::Builder {
        crate::model::game_summary::Builder::default()
    }
}

/// <p>Details about the extension version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExtensionVersionDetails {
    /// <p>The namespace (qualifier) of the extension.</p>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>The name of the extension.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The model that defines the interface for this extension version.</p>
    pub schema: std::option::Option<std::string::String>,
    /// <p>The version of the extension.</p>
    pub version: std::option::Option<std::string::String>,
}
impl ExtensionVersionDetails {
    /// <p>The namespace (qualifier) of the extension.</p>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p>The name of the extension.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The model that defines the interface for this extension version.</p>
    pub fn schema(&self) -> std::option::Option<&str> {
        self.schema.as_deref()
    }
    /// <p>The version of the extension.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for ExtensionVersionDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExtensionVersionDetails");
        formatter.field("namespace", &self.namespace);
        formatter.field("name", &self.name);
        formatter.field("schema", &self.schema);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`ExtensionVersionDetails`](crate::model::ExtensionVersionDetails)
pub mod extension_version_details {
    /// A builder for [`ExtensionVersionDetails`](crate::model::ExtensionVersionDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) schema: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The namespace (qualifier) of the extension.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace (qualifier) of the extension.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>The name of the extension.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the extension.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The model that defines the interface for this extension version.</p>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema = Some(input.into());
            self
        }
        /// <p>The model that defines the interface for this extension version.</p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema = input;
            self
        }
        /// <p>The version of the extension.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the extension.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`ExtensionVersionDetails`](crate::model::ExtensionVersionDetails)
        pub fn build(self) -> crate::model::ExtensionVersionDetails {
            crate::model::ExtensionVersionDetails {
                namespace: self.namespace,
                name: self.name,
                schema: self.schema,
                version: self.version,
            }
        }
    }
}
impl ExtensionVersionDetails {
    /// Creates a new builder-style object to manufacture [`ExtensionVersionDetails`](crate::model::ExtensionVersionDetails)
    pub fn builder() -> crate::model::extension_version_details::Builder {
        crate::model::extension_version_details::Builder::default()
    }
}

/// <p>Details about the extension.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExtensionDetails {
    /// <p>The namespace (qualifier) of the extension.</p>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>The name of the extension.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the extension.</p>
    pub description: std::option::Option<std::string::String>,
}
impl ExtensionDetails {
    /// <p>The namespace (qualifier) of the extension.</p>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p>The name of the extension.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the extension.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for ExtensionDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExtensionDetails");
        formatter.field("namespace", &self.namespace);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`ExtensionDetails`](crate::model::ExtensionDetails)
pub mod extension_details {
    /// A builder for [`ExtensionDetails`](crate::model::ExtensionDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The namespace (qualifier) of the extension.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace (qualifier) of the extension.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>The name of the extension.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the extension.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the extension.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the extension.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`ExtensionDetails`](crate::model::ExtensionDetails)
        pub fn build(self) -> crate::model::ExtensionDetails {
            crate::model::ExtensionDetails {
                namespace: self.namespace,
                name: self.name,
                description: self.description,
            }
        }
    }
}
impl ExtensionDetails {
    /// Creates a new builder-style object to manufacture [`ExtensionDetails`](crate::model::ExtensionDetails)
    pub fn builder() -> crate::model::extension_details::Builder {
        crate::model::extension_details::Builder::default()
    }
}

/// <p>The source used to import configuration sections.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportGameConfigurationSource {
    /// <p>The JSON string containing the configuration sections.</p>
    pub file: std::option::Option<aws_smithy_types::Blob>,
}
impl ImportGameConfigurationSource {
    /// <p>The JSON string containing the configuration sections.</p>
    pub fn file(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.file.as_ref()
    }
}
impl std::fmt::Debug for ImportGameConfigurationSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportGameConfigurationSource");
        formatter.field("file", &self.file);
        formatter.finish()
    }
}
/// See [`ImportGameConfigurationSource`](crate::model::ImportGameConfigurationSource)
pub mod import_game_configuration_source {
    /// A builder for [`ImportGameConfigurationSource`](crate::model::ImportGameConfigurationSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>The JSON string containing the configuration sections.</p>
        pub fn file(mut self, input: aws_smithy_types::Blob) -> Self {
            self.file = Some(input);
            self
        }
        /// <p>The JSON string containing the configuration sections.</p>
        pub fn set_file(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.file = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportGameConfigurationSource`](crate::model::ImportGameConfigurationSource)
        pub fn build(self) -> crate::model::ImportGameConfigurationSource {
            crate::model::ImportGameConfigurationSource { file: self.file }
        }
    }
}
impl ImportGameConfigurationSource {
    /// Creates a new builder-style object to manufacture [`ImportGameConfigurationSource`](crate::model::ImportGameConfigurationSource)
    pub fn builder() -> crate::model::import_game_configuration_source::Builder {
        crate::model::import_game_configuration_source::Builder::default()
    }
}

/// <p>Details about a WebSocket connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Connection {
    /// <p>The identifier used to indicate a specific WebSocket connection.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The date and time when the connection was created.</p>
    pub created: std::option::Option<aws_smithy_types::DateTime>,
}
impl Connection {
    /// <p>The identifier used to indicate a specific WebSocket connection.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The date and time when the connection was created.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created.as_ref()
    }
}
impl std::fmt::Debug for Connection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Connection");
        formatter.field("id", &self.id);
        formatter.field("created", &self.created);
        formatter.finish()
    }
}
/// See [`Connection`](crate::model::Connection)
pub mod connection {
    /// A builder for [`Connection`](crate::model::Connection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) created: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The identifier used to indicate a specific WebSocket connection.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier used to indicate a specific WebSocket connection.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The date and time when the connection was created.</p>
        pub fn created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>The date and time when the connection was created.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created = input;
            self
        }
        /// Consumes the builder and constructs a [`Connection`](crate::model::Connection)
        pub fn build(self) -> crate::model::Connection {
            crate::model::Connection {
                id: self.id,
                created: self.created,
            }
        }
    }
}
impl Connection {
    /// Creates a new builder-style object to manufacture [`Connection`](crate::model::Connection)
    pub fn builder() -> crate::model::connection::Builder {
        crate::model::connection::Builder::default()
    }
}
