// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateGameInput`](crate::input::CreateGameInput)
pub mod create_game_input {
    /// A builder for [`CreateGameInput`](crate::input::CreateGameInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_name = Some(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.game_name = input;
            self
        }
        /// <p>The description of the game.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the game.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> A client-defined token. With an active client token in the request, this action is idempotent. </p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p> A client-defined token. With an active client token in the request, this action is idempotent. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags to apply to the game.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of tags to apply to the game.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGameInput`](crate::input::CreateGameInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateGameInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateGameInput {
                game_name: self.game_name,
                description: self.description,
                client_token: self.client_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateGameInputOperationOutputAlias = crate::operation::CreateGame;
#[doc(hidden)]
pub type CreateGameInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateGameInput {
    /// Consumes the builder and constructs an Operation<[`CreateGame`](crate::operation::CreateGame)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateGame,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateGameInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/game").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateGameInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_game(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateGame::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateGame",
            "gamesparks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateGameInput`](crate::input::CreateGameInput)
    pub fn builder() -> crate::input::create_game_input::Builder {
        crate::input::create_game_input::Builder::default()
    }
}

/// See [`CreateSnapshotInput`](crate::input::CreateSnapshotInput)
pub mod create_snapshot_input {
    /// A builder for [`CreateSnapshotInput`](crate::input::CreateSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_name = Some(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.game_name = input;
            self
        }
        /// <p>The description of the snapshot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the snapshot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSnapshotInput`](crate::input::CreateSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSnapshotInput {
                game_name: self.game_name,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSnapshotInputOperationOutputAlias = crate::operation::CreateSnapshot;
#[doc(hidden)]
pub type CreateSnapshotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`CreateSnapshot`](crate::operation::CreateSnapshot)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSnapshot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateSnapshotInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_1 = &_input.game_name;
                let input_1 = input_1.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let game_name = aws_smithy_http::label::fmt_string(input_1, false);
                if game_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/game/{GameName}/snapshot", GameName = game_name)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateSnapshotInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_snapshot(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSnapshot",
            "gamesparks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateSnapshotInput`](crate::input::CreateSnapshotInput)
    pub fn builder() -> crate::input::create_snapshot_input::Builder {
        crate::input::create_snapshot_input::Builder::default()
    }
}

/// See [`CreateStageInput`](crate::input::CreateStageInput)
pub mod create_stage_input {
    /// A builder for [`CreateStageInput`](crate::input::CreateStageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_name: std::option::Option<std::string::String>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_name = Some(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.game_name = input;
            self
        }
        /// <p>The name of the stage.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The name of the stage.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the role to run the game with. This role can be a game-defined role or the default role that GameSparks created. </p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the role to run the game with. This role can be a game-defined role or the default role that GameSparks created. </p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// <p>The description of the stage.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the stage.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> A client-defined token. With an active client token in the request, this action is idempotent. </p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p> A client-defined token. With an active client token in the request, this action is idempotent. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags to apply to the stage.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of tags to apply to the stage.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStageInput`](crate::input::CreateStageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateStageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateStageInput {
                game_name: self.game_name,
                stage_name: self.stage_name,
                role: self.role,
                description: self.description,
                client_token: self.client_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateStageInputOperationOutputAlias = crate::operation::CreateStage;
#[doc(hidden)]
pub type CreateStageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateStageInput {
    /// Consumes the builder and constructs an Operation<[`CreateStage`](crate::operation::CreateStage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateStage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateStageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_2 = &_input.game_name;
                let input_2 = input_2.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let game_name = aws_smithy_http::label::fmt_string(input_2, false);
                if game_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/game/{GameName}/stage", GameName = game_name)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateStageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_stage(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateStage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateStage",
            "gamesparks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateStageInput`](crate::input::CreateStageInput)
    pub fn builder() -> crate::input::create_stage_input::Builder {
        crate::input::create_stage_input::Builder::default()
    }
}

/// See [`DeleteGameInput`](crate::input::DeleteGameInput)
pub mod delete_game_input {
    /// A builder for [`DeleteGameInput`](crate::input::DeleteGameInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the game to delete.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_name = Some(input.into());
            self
        }
        /// <p>The name of the game to delete.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.game_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGameInput`](crate::input::DeleteGameInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteGameInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteGameInput {
                game_name: self.game_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteGameInputOperationOutputAlias = crate::operation::DeleteGame;
#[doc(hidden)]
pub type DeleteGameInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteGameInput {
    /// Consumes the builder and constructs an Operation<[`DeleteGame`](crate::operation::DeleteGame)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteGame,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteGameInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_3 = &_input.game_name;
                let input_3 = input_3.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let game_name = aws_smithy_http::label::fmt_string(input_3, false);
                if game_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/game/{GameName}", GameName = game_name)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteGameInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteGame::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteGame",
            "gamesparks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteGameInput`](crate::input::DeleteGameInput)
    pub fn builder() -> crate::input::delete_game_input::Builder {
        crate::input::delete_game_input::Builder::default()
    }
}

/// See [`DeleteStageInput`](crate::input::DeleteStageInput)
pub mod delete_stage_input {
    /// A builder for [`DeleteStageInput`](crate::input::DeleteStageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_name: std::option::Option<std::string::String>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_name = Some(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.game_name = input;
            self
        }
        /// <p>The name of the stage to delete.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The name of the stage to delete.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteStageInput`](crate::input::DeleteStageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteStageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteStageInput {
                game_name: self.game_name,
                stage_name: self.stage_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteStageInputOperationOutputAlias = crate::operation::DeleteStage;
#[doc(hidden)]
pub type DeleteStageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteStageInput {
    /// Consumes the builder and constructs an Operation<[`DeleteStage`](crate::operation::DeleteStage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteStage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteStageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_4 = &_input.game_name;
                let input_4 = input_4.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let game_name = aws_smithy_http::label::fmt_string(input_4, false);
                if game_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_5 = &_input.stage_name;
                let input_5 = input_5.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "stage_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let stage_name = aws_smithy_http::label::fmt_string(input_5, false);
                if stage_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "stage_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/game/{GameName}/stage/{StageName}",
                    GameName = game_name,
                    StageName = stage_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteStageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteStage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteStage",
            "gamesparks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteStageInput`](crate::input::DeleteStageInput)
    pub fn builder() -> crate::input::delete_stage_input::Builder {
        crate::input::delete_stage_input::Builder::default()
    }
}

/// See [`DisconnectPlayerInput`](crate::input::DisconnectPlayerInput)
pub mod disconnect_player_input {
    /// A builder for [`DisconnectPlayerInput`](crate::input::DisconnectPlayerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) player_id: std::option::Option<std::string::String>,
        pub(crate) game_name: std::option::Option<std::string::String>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier representing a player.</p>
        pub fn player_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.player_id = Some(input.into());
            self
        }
        /// <p>The unique identifier representing a player.</p>
        pub fn set_player_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.player_id = input;
            self
        }
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_name = Some(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.game_name = input;
            self
        }
        /// <p>The name of the stage.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The name of the stage.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DisconnectPlayerInput`](crate::input::DisconnectPlayerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisconnectPlayerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisconnectPlayerInput {
                player_id: self.player_id,
                game_name: self.game_name,
                stage_name: self.stage_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DisconnectPlayerInputOperationOutputAlias = crate::operation::DisconnectPlayer;
#[doc(hidden)]
pub type DisconnectPlayerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DisconnectPlayerInput {
    /// Consumes the builder and constructs an Operation<[`DisconnectPlayer`](crate::operation::DisconnectPlayer)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisconnectPlayer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DisconnectPlayerInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_6 = &_input.game_name;
                let input_6 = input_6.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let game_name = aws_smithy_http::label::fmt_string(input_6, false);
                if game_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_7 = &_input.stage_name;
                let input_7 = input_7.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "stage_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let stage_name = aws_smithy_http::label::fmt_string(input_7, false);
                if stage_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "stage_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_8 = &_input.player_id;
                let input_8 = input_8.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "player_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let player_id = aws_smithy_http::label::fmt_string(input_8, false);
                if player_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "player_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/runtime/game/{GameName}/stage/{StageName}/player/{PlayerId}/disconnect",
                    GameName = game_name,
                    StageName = stage_name,
                    PlayerId = player_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DisconnectPlayerInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisconnectPlayer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisconnectPlayer",
            "gamesparks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DisconnectPlayerInput`](crate::input::DisconnectPlayerInput)
    pub fn builder() -> crate::input::disconnect_player_input::Builder {
        crate::input::disconnect_player_input::Builder::default()
    }
}

/// See [`ExportSnapshotInput`](crate::input::ExportSnapshotInput)
pub mod export_snapshot_input {
    /// A builder for [`ExportSnapshotInput`](crate::input::ExportSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_name: std::option::Option<std::string::String>,
        pub(crate) snapshot_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_name = Some(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.game_name = input;
            self
        }
        /// <p>The identifier of the snapshot to export.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the snapshot to export.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.snapshot_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportSnapshotInput`](crate::input::ExportSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ExportSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ExportSnapshotInput {
                game_name: self.game_name,
                snapshot_id: self.snapshot_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ExportSnapshotInputOperationOutputAlias = crate::operation::ExportSnapshot;
#[doc(hidden)]
pub type ExportSnapshotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ExportSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`ExportSnapshot`](crate::operation::ExportSnapshot)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ExportSnapshot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ExportSnapshotInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_9 = &_input.game_name;
                let input_9 = input_9.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let game_name = aws_smithy_http::label::fmt_string(input_9, false);
                if game_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_10 = &_input.snapshot_id;
                let input_10 = input_10.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "snapshot_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let snapshot_id = aws_smithy_http::label::fmt_string(input_10, false);
                if snapshot_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "snapshot_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/game/{GameName}/snapshot/{SnapshotId}/export",
                    GameName = game_name,
                    SnapshotId = snapshot_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ExportSnapshotInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ExportSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ExportSnapshot",
            "gamesparks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ExportSnapshotInput`](crate::input::ExportSnapshotInput)
    pub fn builder() -> crate::input::export_snapshot_input::Builder {
        crate::input::export_snapshot_input::Builder::default()
    }
}

/// See [`GetExtensionInput`](crate::input::GetExtensionInput)
pub mod get_extension_input {
    /// A builder for [`GetExtensionInput`](crate::input::GetExtensionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The namespace (qualifier) of the extension.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace (qualifier) of the extension.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>The name of the extension.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the extension.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetExtensionInput`](crate::input::GetExtensionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetExtensionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetExtensionInput {
                namespace: self.namespace,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetExtensionInputOperationOutputAlias = crate::operation::GetExtension;
#[doc(hidden)]
pub type GetExtensionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetExtensionInput {
    /// Consumes the builder and constructs an Operation<[`GetExtension`](crate::operation::GetExtension)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetExtension,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetExtensionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_11 = &_input.namespace;
                let input_11 = input_11.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "namespace",
                        details: "cannot be empty or unset",
                    },
                )?;
                let namespace = aws_smithy_http::label::fmt_string(input_11, false);
                if namespace.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "namespace",
                        details: "cannot be empty or unset",
                    });
                }
                let input_12 = &_input.name;
                let input_12 = input_12.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let name = aws_smithy_http::label::fmt_string(input_12, false);
                if name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/extension/{Namespace}/{Name}",
                    Namespace = namespace,
                    Name = name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetExtensionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetExtension::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetExtension",
            "gamesparks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetExtensionInput`](crate::input::GetExtensionInput)
    pub fn builder() -> crate::input::get_extension_input::Builder {
        crate::input::get_extension_input::Builder::default()
    }
}

/// See [`GetExtensionVersionInput`](crate::input::GetExtensionVersionInput)
pub mod get_extension_version_input {
    /// A builder for [`GetExtensionVersionInput`](crate::input::GetExtensionVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) extension_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The namespace (qualifier) of the extension.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace (qualifier) of the extension.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>The name of the extension.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the extension.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the extension.</p>
        pub fn extension_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.extension_version = Some(input.into());
            self
        }
        /// <p>The version of the extension.</p>
        pub fn set_extension_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.extension_version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetExtensionVersionInput`](crate::input::GetExtensionVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetExtensionVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetExtensionVersionInput {
                namespace: self.namespace,
                name: self.name,
                extension_version: self.extension_version,
            })
        }
    }
}
#[doc(hidden)]
pub type GetExtensionVersionInputOperationOutputAlias = crate::operation::GetExtensionVersion;
#[doc(hidden)]
pub type GetExtensionVersionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetExtensionVersionInput {
    /// Consumes the builder and constructs an Operation<[`GetExtensionVersion`](crate::operation::GetExtensionVersion)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetExtensionVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetExtensionVersionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_13 = &_input.namespace;
                let input_13 = input_13.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "namespace",
                        details: "cannot be empty or unset",
                    },
                )?;
                let namespace = aws_smithy_http::label::fmt_string(input_13, false);
                if namespace.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "namespace",
                        details: "cannot be empty or unset",
                    });
                }
                let input_14 = &_input.name;
                let input_14 = input_14.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let name = aws_smithy_http::label::fmt_string(input_14, false);
                if name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_15 = &_input.extension_version;
                let input_15 = input_15.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "extension_version",
                        details: "cannot be empty or unset",
                    },
                )?;
                let extension_version = aws_smithy_http::label::fmt_string(input_15, false);
                if extension_version.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "extension_version",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/extension/{Namespace}/{Name}/version/{ExtensionVersion}",
                    Namespace = namespace,
                    Name = name,
                    ExtensionVersion = extension_version
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetExtensionVersionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetExtensionVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetExtensionVersion",
            "gamesparks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetExtensionVersionInput`](crate::input::GetExtensionVersionInput)
    pub fn builder() -> crate::input::get_extension_version_input::Builder {
        crate::input::get_extension_version_input::Builder::default()
    }
}

/// See [`GetGameInput`](crate::input::GetGameInput)
pub mod get_game_input {
    /// A builder for [`GetGameInput`](crate::input::GetGameInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_name = Some(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.game_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGameInput`](crate::input::GetGameInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetGameInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetGameInput {
                game_name: self.game_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetGameInputOperationOutputAlias = crate::operation::GetGame;
#[doc(hidden)]
pub type GetGameInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetGameInput {
    /// Consumes the builder and constructs an Operation<[`GetGame`](crate::operation::GetGame)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetGame,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetGameInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_16 = &_input.game_name;
                let input_16 = input_16.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let game_name = aws_smithy_http::label::fmt_string(input_16, false);
                if game_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/game/{GameName}", GameName = game_name)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetGameInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetGame::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetGame",
                    "gamesparks",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetGameInput`](crate::input::GetGameInput)
    pub fn builder() -> crate::input::get_game_input::Builder {
        crate::input::get_game_input::Builder::default()
    }
}

/// See [`GetGameConfigurationInput`](crate::input::GetGameConfigurationInput)
pub mod get_game_configuration_input {
    /// A builder for [`GetGameConfigurationInput`](crate::input::GetGameConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_name: std::option::Option<std::string::String>,
        pub(crate) sections: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_name = Some(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.game_name = input;
            self
        }
        /// Appends an item to `sections`.
        ///
        /// To override the contents of this collection use [`set_sections`](Self::set_sections).
        ///
        /// <p>The list of sections to return.</p>
        pub fn sections(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.sections.unwrap_or_default();
            v.push(input.into());
            self.sections = Some(v);
            self
        }
        /// <p>The list of sections to return.</p>
        pub fn set_sections(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.sections = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGameConfigurationInput`](crate::input::GetGameConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetGameConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetGameConfigurationInput {
                game_name: self.game_name,
                sections: self.sections,
            })
        }
    }
}
#[doc(hidden)]
pub type GetGameConfigurationInputOperationOutputAlias = crate::operation::GetGameConfiguration;
#[doc(hidden)]
pub type GetGameConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetGameConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetGameConfiguration`](crate::operation::GetGameConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetGameConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetGameConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_17 = &_input.game_name;
                let input_17 = input_17.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let game_name = aws_smithy_http::label::fmt_string(input_17, false);
                if game_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/game/{GameName}/configuration",
                    GameName = game_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetGameConfigurationInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_18) = &_input.sections {
                    for inner_19 in inner_18 {
                        query.push_kv("Sections", &aws_smithy_http::query::fmt_string(&inner_19));
                    }
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetGameConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetGameConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetGameConfiguration",
            "gamesparks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetGameConfigurationInput`](crate::input::GetGameConfigurationInput)
    pub fn builder() -> crate::input::get_game_configuration_input::Builder {
        crate::input::get_game_configuration_input::Builder::default()
    }
}

/// See [`GetGeneratedCodeJobInput`](crate::input::GetGeneratedCodeJobInput)
pub mod get_generated_code_job_input {
    /// A builder for [`GetGeneratedCodeJobInput`](crate::input::GetGeneratedCodeJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_name: std::option::Option<std::string::String>,
        pub(crate) snapshot_id: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_name = Some(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.game_name = input;
            self
        }
        /// <p>The identifier of the snapshot for the code generation job.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the snapshot for the code generation job.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.snapshot_id = input;
            self
        }
        /// <p>The identifier of the code generation job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identifier of the code generation job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGeneratedCodeJobInput`](crate::input::GetGeneratedCodeJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetGeneratedCodeJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetGeneratedCodeJobInput {
                game_name: self.game_name,
                snapshot_id: self.snapshot_id,
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetGeneratedCodeJobInputOperationOutputAlias = crate::operation::GetGeneratedCodeJob;
#[doc(hidden)]
pub type GetGeneratedCodeJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetGeneratedCodeJobInput {
    /// Consumes the builder and constructs an Operation<[`GetGeneratedCodeJob`](crate::operation::GetGeneratedCodeJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetGeneratedCodeJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetGeneratedCodeJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_20 = &_input.game_name;
                let input_20 = input_20.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let game_name = aws_smithy_http::label::fmt_string(input_20, false);
                if game_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_21 = &_input.snapshot_id;
                let input_21 = input_21.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "snapshot_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let snapshot_id = aws_smithy_http::label::fmt_string(input_21, false);
                if snapshot_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "snapshot_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_22 = &_input.job_id;
                let input_22 = input_22.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let job_id = aws_smithy_http::label::fmt_string(input_22, false);
                if job_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/game/{GameName}/snapshot/{SnapshotId}/generated-sdk-code-job/{JobId}",
                    GameName = game_name,
                    SnapshotId = snapshot_id,
                    JobId = job_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetGeneratedCodeJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetGeneratedCodeJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetGeneratedCodeJob",
            "gamesparks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetGeneratedCodeJobInput`](crate::input::GetGeneratedCodeJobInput)
    pub fn builder() -> crate::input::get_generated_code_job_input::Builder {
        crate::input::get_generated_code_job_input::Builder::default()
    }
}

/// See [`GetPlayerConnectionStatusInput`](crate::input::GetPlayerConnectionStatusInput)
pub mod get_player_connection_status_input {
    /// A builder for [`GetPlayerConnectionStatusInput`](crate::input::GetPlayerConnectionStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) player_id: std::option::Option<std::string::String>,
        pub(crate) game_name: std::option::Option<std::string::String>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier representing a player.</p>
        pub fn player_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.player_id = Some(input.into());
            self
        }
        /// <p>The unique identifier representing a player.</p>
        pub fn set_player_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.player_id = input;
            self
        }
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_name = Some(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.game_name = input;
            self
        }
        /// <p>The name of the stage.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The name of the stage.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPlayerConnectionStatusInput`](crate::input::GetPlayerConnectionStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPlayerConnectionStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPlayerConnectionStatusInput {
                player_id: self.player_id,
                game_name: self.game_name,
                stage_name: self.stage_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPlayerConnectionStatusInputOperationOutputAlias =
    crate::operation::GetPlayerConnectionStatus;
#[doc(hidden)]
pub type GetPlayerConnectionStatusInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetPlayerConnectionStatusInput {
    /// Consumes the builder and constructs an Operation<[`GetPlayerConnectionStatus`](crate::operation::GetPlayerConnectionStatus)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPlayerConnectionStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetPlayerConnectionStatusInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_23 = &_input.game_name;
                let input_23 = input_23.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let game_name = aws_smithy_http::label::fmt_string(input_23, false);
                if game_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_24 = &_input.stage_name;
                let input_24 = input_24.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "stage_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let stage_name = aws_smithy_http::label::fmt_string(input_24, false);
                if stage_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "stage_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_25 = &_input.player_id;
                let input_25 = input_25.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "player_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let player_id = aws_smithy_http::label::fmt_string(input_25, false);
                if player_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "player_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/runtime/game/{GameName}/stage/{StageName}/player/{PlayerId}/connection",
                    GameName = game_name,
                    StageName = stage_name,
                    PlayerId = player_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetPlayerConnectionStatusInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPlayerConnectionStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPlayerConnectionStatus",
            "gamesparks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetPlayerConnectionStatusInput`](crate::input::GetPlayerConnectionStatusInput)
    pub fn builder() -> crate::input::get_player_connection_status_input::Builder {
        crate::input::get_player_connection_status_input::Builder::default()
    }
}

/// See [`GetSnapshotInput`](crate::input::GetSnapshotInput)
pub mod get_snapshot_input {
    /// A builder for [`GetSnapshotInput`](crate::input::GetSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_name: std::option::Option<std::string::String>,
        pub(crate) snapshot_id: std::option::Option<std::string::String>,
        pub(crate) sections: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_name = Some(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.game_name = input;
            self
        }
        /// <p>The identifier of the snapshot.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the snapshot.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.snapshot_id = input;
            self
        }
        /// Appends an item to `sections`.
        ///
        /// To override the contents of this collection use [`set_sections`](Self::set_sections).
        ///
        /// <p>The list of game configuration sections to be described.</p>
        pub fn sections(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.sections.unwrap_or_default();
            v.push(input.into());
            self.sections = Some(v);
            self
        }
        /// <p>The list of game configuration sections to be described.</p>
        pub fn set_sections(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.sections = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSnapshotInput`](crate::input::GetSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSnapshotInput {
                game_name: self.game_name,
                snapshot_id: self.snapshot_id,
                sections: self.sections,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSnapshotInputOperationOutputAlias = crate::operation::GetSnapshot;
#[doc(hidden)]
pub type GetSnapshotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`GetSnapshot`](crate::operation::GetSnapshot)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSnapshot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetSnapshotInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_26 = &_input.game_name;
                let input_26 = input_26.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let game_name = aws_smithy_http::label::fmt_string(input_26, false);
                if game_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_27 = &_input.snapshot_id;
                let input_27 = input_27.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "snapshot_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let snapshot_id = aws_smithy_http::label::fmt_string(input_27, false);
                if snapshot_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "snapshot_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/game/{GameName}/snapshot/{SnapshotId}",
                    GameName = game_name,
                    SnapshotId = snapshot_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetSnapshotInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_28) = &_input.sections {
                    for inner_29 in inner_28 {
                        query.push_kv("Sections", &aws_smithy_http::query::fmt_string(&inner_29));
                    }
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetSnapshotInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSnapshot",
            "gamesparks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetSnapshotInput`](crate::input::GetSnapshotInput)
    pub fn builder() -> crate::input::get_snapshot_input::Builder {
        crate::input::get_snapshot_input::Builder::default()
    }
}

/// See [`GetStageInput`](crate::input::GetStageInput)
pub mod get_stage_input {
    /// A builder for [`GetStageInput`](crate::input::GetStageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_name: std::option::Option<std::string::String>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_name = Some(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.game_name = input;
            self
        }
        /// <p>The name of the stage.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The name of the stage.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStageInput`](crate::input::GetStageInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetStageInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetStageInput {
                game_name: self.game_name,
                stage_name: self.stage_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetStageInputOperationOutputAlias = crate::operation::GetStage;
#[doc(hidden)]
pub type GetStageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetStageInput {
    /// Consumes the builder and constructs an Operation<[`GetStage`](crate::operation::GetStage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetStage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetStageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_30 = &_input.game_name;
                let input_30 = input_30.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let game_name = aws_smithy_http::label::fmt_string(input_30, false);
                if game_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_31 = &_input.stage_name;
                let input_31 = input_31.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "stage_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let stage_name = aws_smithy_http::label::fmt_string(input_31, false);
                if stage_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "stage_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/game/{GameName}/stage/{StageName}",
                    GameName = game_name,
                    StageName = stage_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetStageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetStage::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetStage",
                    "gamesparks",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetStageInput`](crate::input::GetStageInput)
    pub fn builder() -> crate::input::get_stage_input::Builder {
        crate::input::get_stage_input::Builder::default()
    }
}

/// See [`GetStageDeploymentInput`](crate::input::GetStageDeploymentInput)
pub mod get_stage_deployment_input {
    /// A builder for [`GetStageDeploymentInput`](crate::input::GetStageDeploymentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_name: std::option::Option<std::string::String>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
        pub(crate) deployment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_name = Some(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.game_name = input;
            self
        }
        /// <p>The name of the stage.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The name of the stage.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// <p> The identifier of the stage deployment. <code>StartStageDeployment</code> returns the identifier that you use here. </p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p> The identifier of the stage deployment. <code>StartStageDeployment</code> returns the identifier that you use here. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStageDeploymentInput`](crate::input::GetStageDeploymentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetStageDeploymentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetStageDeploymentInput {
                game_name: self.game_name,
                stage_name: self.stage_name,
                deployment_id: self.deployment_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetStageDeploymentInputOperationOutputAlias = crate::operation::GetStageDeployment;
#[doc(hidden)]
pub type GetStageDeploymentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetStageDeploymentInput {
    /// Consumes the builder and constructs an Operation<[`GetStageDeployment`](crate::operation::GetStageDeployment)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetStageDeployment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetStageDeploymentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_32 = &_input.game_name;
                let input_32 = input_32.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let game_name = aws_smithy_http::label::fmt_string(input_32, false);
                if game_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_33 = &_input.stage_name;
                let input_33 = input_33.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "stage_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let stage_name = aws_smithy_http::label::fmt_string(input_33, false);
                if stage_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "stage_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/game/{GameName}/stage/{StageName}/deployment",
                    GameName = game_name,
                    StageName = stage_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetStageDeploymentInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_34) = &_input.deployment_id {
                    query.push_kv(
                        "DeploymentId",
                        &aws_smithy_http::query::fmt_string(&inner_34),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetStageDeploymentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetStageDeployment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetStageDeployment",
            "gamesparks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetStageDeploymentInput`](crate::input::GetStageDeploymentInput)
    pub fn builder() -> crate::input::get_stage_deployment_input::Builder {
        crate::input::get_stage_deployment_input::Builder::default()
    }
}

/// See [`ImportGameConfigurationInput`](crate::input::ImportGameConfigurationInput)
pub mod import_game_configuration_input {
    /// A builder for [`ImportGameConfigurationInput`](crate::input::ImportGameConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_name: std::option::Option<std::string::String>,
        pub(crate) import_source: std::option::Option<crate::model::ImportGameConfigurationSource>,
    }
    impl Builder {
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_name = Some(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.game_name = input;
            self
        }
        /// <p>The source used to import configuration sections.</p>
        pub fn import_source(mut self, input: crate::model::ImportGameConfigurationSource) -> Self {
            self.import_source = Some(input);
            self
        }
        /// <p>The source used to import configuration sections.</p>
        pub fn set_import_source(
            mut self,
            input: std::option::Option<crate::model::ImportGameConfigurationSource>,
        ) -> Self {
            self.import_source = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportGameConfigurationInput`](crate::input::ImportGameConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ImportGameConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ImportGameConfigurationInput {
                game_name: self.game_name,
                import_source: self.import_source,
            })
        }
    }
}
#[doc(hidden)]
pub type ImportGameConfigurationInputOperationOutputAlias =
    crate::operation::ImportGameConfiguration;
#[doc(hidden)]
pub type ImportGameConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ImportGameConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`ImportGameConfiguration`](crate::operation::ImportGameConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ImportGameConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ImportGameConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_35 = &_input.game_name;
                let input_35 = input_35.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let game_name = aws_smithy_http::label::fmt_string(input_35, false);
                if game_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/game/{GameName}/configuration",
                    GameName = game_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ImportGameConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_import_game_configuration(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ImportGameConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ImportGameConfiguration",
            "gamesparks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ImportGameConfigurationInput`](crate::input::ImportGameConfigurationInput)
    pub fn builder() -> crate::input::import_game_configuration_input::Builder {
        crate::input::import_game_configuration_input::Builder::default()
    }
}

/// See [`ListExtensionsInput`](crate::input::ListExtensionsInput)
pub mod list_extensions_input {
    /// A builder for [`ListExtensionsInput`](crate::input::ListExtensionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of results to return.</p>
        /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListExtensionsInput`](crate::input::ListExtensionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListExtensionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListExtensionsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListExtensionsInputOperationOutputAlias = crate::operation::ListExtensions;
#[doc(hidden)]
pub type ListExtensionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListExtensionsInput {
    /// Consumes the builder and constructs an Operation<[`ListExtensions`](crate::operation::ListExtensions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListExtensions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListExtensionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/extension").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListExtensionsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_36) = &_input.max_results {
                    query.push_kv(
                        "MaxResults",
                        aws_smithy_types::primitive::Encoder::from(*inner_36).encode(),
                    );
                }
                if let Some(inner_37) = &_input.next_token {
                    query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_37));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListExtensionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListExtensions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListExtensions",
            "gamesparks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListExtensionsInput`](crate::input::ListExtensionsInput)
    pub fn builder() -> crate::input::list_extensions_input::Builder {
        crate::input::list_extensions_input::Builder::default()
    }
}

/// See [`ListExtensionVersionsInput`](crate::input::ListExtensionVersionsInput)
pub mod list_extension_versions_input {
    /// A builder for [`ListExtensionVersionsInput`](crate::input::ListExtensionVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The namespace (qualifier) of the extension.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace (qualifier) of the extension.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>The name of the extension.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the extension.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListExtensionVersionsInput`](crate::input::ListExtensionVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListExtensionVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListExtensionVersionsInput {
                namespace: self.namespace,
                name: self.name,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListExtensionVersionsInputOperationOutputAlias = crate::operation::ListExtensionVersions;
#[doc(hidden)]
pub type ListExtensionVersionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListExtensionVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListExtensionVersions`](crate::operation::ListExtensionVersions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListExtensionVersions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListExtensionVersionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_38 = &_input.namespace;
                let input_38 = input_38.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "namespace",
                        details: "cannot be empty or unset",
                    },
                )?;
                let namespace = aws_smithy_http::label::fmt_string(input_38, false);
                if namespace.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "namespace",
                        details: "cannot be empty or unset",
                    });
                }
                let input_39 = &_input.name;
                let input_39 = input_39.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let name = aws_smithy_http::label::fmt_string(input_39, false);
                if name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/extension/{Namespace}/{Name}/version",
                    Namespace = namespace,
                    Name = name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListExtensionVersionsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_40) = &_input.next_token {
                    query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_40));
                }
                if let Some(inner_41) = &_input.max_results {
                    query.push_kv(
                        "MaxResults",
                        aws_smithy_types::primitive::Encoder::from(*inner_41).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListExtensionVersionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListExtensionVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListExtensionVersions",
            "gamesparks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListExtensionVersionsInput`](crate::input::ListExtensionVersionsInput)
    pub fn builder() -> crate::input::list_extension_versions_input::Builder {
        crate::input::list_extension_versions_input::Builder::default()
    }
}

/// See [`ListGamesInput`](crate::input::ListGamesInput)
pub mod list_games_input {
    /// A builder for [`ListGamesInput`](crate::input::ListGamesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of results to return.</p>
        /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGamesInput`](crate::input::ListGamesInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListGamesInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListGamesInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListGamesInputOperationOutputAlias = crate::operation::ListGames;
#[doc(hidden)]
pub type ListGamesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListGamesInput {
    /// Consumes the builder and constructs an Operation<[`ListGames`](crate::operation::ListGames)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListGames,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListGamesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/game").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListGamesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_42) = &_input.max_results {
                    query.push_kv(
                        "MaxResults",
                        aws_smithy_types::primitive::Encoder::from(*inner_42).encode(),
                    );
                }
                if let Some(inner_43) = &_input.next_token {
                    query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_43));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListGamesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListGames::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListGames",
                    "gamesparks",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListGamesInput`](crate::input::ListGamesInput)
    pub fn builder() -> crate::input::list_games_input::Builder {
        crate::input::list_games_input::Builder::default()
    }
}

/// See [`ListGeneratedCodeJobsInput`](crate::input::ListGeneratedCodeJobsInput)
pub mod list_generated_code_jobs_input {
    /// A builder for [`ListGeneratedCodeJobsInput`](crate::input::ListGeneratedCodeJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_name: std::option::Option<std::string::String>,
        pub(crate) snapshot_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_name = Some(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.game_name = input;
            self
        }
        /// <p>The identifier of the snapshot.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the snapshot.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.snapshot_id = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGeneratedCodeJobsInput`](crate::input::ListGeneratedCodeJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListGeneratedCodeJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListGeneratedCodeJobsInput {
                game_name: self.game_name,
                snapshot_id: self.snapshot_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListGeneratedCodeJobsInputOperationOutputAlias = crate::operation::ListGeneratedCodeJobs;
#[doc(hidden)]
pub type ListGeneratedCodeJobsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListGeneratedCodeJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListGeneratedCodeJobs`](crate::operation::ListGeneratedCodeJobs)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListGeneratedCodeJobs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListGeneratedCodeJobsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_44 = &_input.game_name;
                let input_44 = input_44.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let game_name = aws_smithy_http::label::fmt_string(input_44, false);
                if game_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_45 = &_input.snapshot_id;
                let input_45 = input_45.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "snapshot_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let snapshot_id = aws_smithy_http::label::fmt_string(input_45, false);
                if snapshot_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "snapshot_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/game/{GameName}/snapshot/{SnapshotId}/generated-sdk-code-jobs",
                    GameName = game_name,
                    SnapshotId = snapshot_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListGeneratedCodeJobsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_46) = &_input.max_results {
                    query.push_kv(
                        "MaxResults",
                        aws_smithy_types::primitive::Encoder::from(*inner_46).encode(),
                    );
                }
                if let Some(inner_47) = &_input.next_token {
                    query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_47));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListGeneratedCodeJobsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListGeneratedCodeJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListGeneratedCodeJobs",
            "gamesparks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListGeneratedCodeJobsInput`](crate::input::ListGeneratedCodeJobsInput)
    pub fn builder() -> crate::input::list_generated_code_jobs_input::Builder {
        crate::input::list_generated_code_jobs_input::Builder::default()
    }
}

/// See [`ListSnapshotsInput`](crate::input::ListSnapshotsInput)
pub mod list_snapshots_input {
    /// A builder for [`ListSnapshotsInput`](crate::input::ListSnapshotsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_name = Some(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.game_name = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSnapshotsInput`](crate::input::ListSnapshotsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSnapshotsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSnapshotsInput {
                game_name: self.game_name,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSnapshotsInputOperationOutputAlias = crate::operation::ListSnapshots;
#[doc(hidden)]
pub type ListSnapshotsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListSnapshotsInput {
    /// Consumes the builder and constructs an Operation<[`ListSnapshots`](crate::operation::ListSnapshots)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSnapshots,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListSnapshotsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_48 = &_input.game_name;
                let input_48 = input_48.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let game_name = aws_smithy_http::label::fmt_string(input_48, false);
                if game_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/game/{GameName}/snapshot", GameName = game_name)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListSnapshotsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_49) = &_input.max_results {
                    query.push_kv(
                        "MaxResults",
                        aws_smithy_types::primitive::Encoder::from(*inner_49).encode(),
                    );
                }
                if let Some(inner_50) = &_input.next_token {
                    query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_50));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListSnapshotsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSnapshots::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSnapshots",
            "gamesparks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListSnapshotsInput`](crate::input::ListSnapshotsInput)
    pub fn builder() -> crate::input::list_snapshots_input::Builder {
        crate::input::list_snapshots_input::Builder::default()
    }
}

/// See [`ListStageDeploymentsInput`](crate::input::ListStageDeploymentsInput)
pub mod list_stage_deployments_input {
    /// A builder for [`ListStageDeploymentsInput`](crate::input::ListStageDeploymentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_name: std::option::Option<std::string::String>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_name = Some(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.game_name = input;
            self
        }
        /// <p>The name of the stage.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The name of the stage.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStageDeploymentsInput`](crate::input::ListStageDeploymentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListStageDeploymentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListStageDeploymentsInput {
                game_name: self.game_name,
                stage_name: self.stage_name,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListStageDeploymentsInputOperationOutputAlias = crate::operation::ListStageDeployments;
#[doc(hidden)]
pub type ListStageDeploymentsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListStageDeploymentsInput {
    /// Consumes the builder and constructs an Operation<[`ListStageDeployments`](crate::operation::ListStageDeployments)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListStageDeployments,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListStageDeploymentsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_51 = &_input.game_name;
                let input_51 = input_51.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let game_name = aws_smithy_http::label::fmt_string(input_51, false);
                if game_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_52 = &_input.stage_name;
                let input_52 = input_52.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "stage_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let stage_name = aws_smithy_http::label::fmt_string(input_52, false);
                if stage_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "stage_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/game/{GameName}/stage/{StageName}/deployments",
                    GameName = game_name,
                    StageName = stage_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListStageDeploymentsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_53) = &_input.next_token {
                    query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_53));
                }
                if let Some(inner_54) = &_input.max_results {
                    query.push_kv(
                        "MaxResults",
                        aws_smithy_types::primitive::Encoder::from(*inner_54).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListStageDeploymentsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListStageDeployments::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListStageDeployments",
            "gamesparks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListStageDeploymentsInput`](crate::input::ListStageDeploymentsInput)
    pub fn builder() -> crate::input::list_stage_deployments_input::Builder {
        crate::input::list_stage_deployments_input::Builder::default()
    }
}

/// See [`ListStagesInput`](crate::input::ListStagesInput)
pub mod list_stages_input {
    /// A builder for [`ListStagesInput`](crate::input::ListStagesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_name = Some(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.game_name = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStagesInput`](crate::input::ListStagesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListStagesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListStagesInput {
                game_name: self.game_name,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListStagesInputOperationOutputAlias = crate::operation::ListStages;
#[doc(hidden)]
pub type ListStagesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListStagesInput {
    /// Consumes the builder and constructs an Operation<[`ListStages`](crate::operation::ListStages)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListStages,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListStagesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_55 = &_input.game_name;
                let input_55 = input_55.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let game_name = aws_smithy_http::label::fmt_string(input_55, false);
                if game_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/game/{GameName}/stage", GameName = game_name)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListStagesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_56) = &_input.max_results {
                    query.push_kv(
                        "MaxResults",
                        aws_smithy_types::primitive::Encoder::from(*inner_56).encode(),
                    );
                }
                if let Some(inner_57) = &_input.next_token {
                    query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_57));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListStagesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListStages::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListStages",
            "gamesparks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListStagesInput`](crate::input::ListStagesInput)
    pub fn builder() -> crate::input::list_stages_input::Builder {
        crate::input::list_stages_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the GameSparks resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the GameSparks resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTagsForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_58 = &_input.resource_arn;
                let input_58 = input_58.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_58, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTagsForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "gamesparks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`StartGeneratedCodeJobInput`](crate::input::StartGeneratedCodeJobInput)
pub mod start_generated_code_job_input {
    /// A builder for [`StartGeneratedCodeJobInput`](crate::input::StartGeneratedCodeJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_name: std::option::Option<std::string::String>,
        pub(crate) snapshot_id: std::option::Option<std::string::String>,
        pub(crate) generator: std::option::Option<crate::model::Generator>,
    }
    impl Builder {
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_name = Some(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.game_name = input;
            self
        }
        /// <p>The identifier of the snapshot for which to generate code.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the snapshot for which to generate code.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.snapshot_id = input;
            self
        }
        /// <p>Properties of the generator to use for the job.</p>
        pub fn generator(mut self, input: crate::model::Generator) -> Self {
            self.generator = Some(input);
            self
        }
        /// <p>Properties of the generator to use for the job.</p>
        pub fn set_generator(
            mut self,
            input: std::option::Option<crate::model::Generator>,
        ) -> Self {
            self.generator = input;
            self
        }
        /// Consumes the builder and constructs a [`StartGeneratedCodeJobInput`](crate::input::StartGeneratedCodeJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartGeneratedCodeJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartGeneratedCodeJobInput {
                game_name: self.game_name,
                snapshot_id: self.snapshot_id,
                generator: self.generator,
            })
        }
    }
}
#[doc(hidden)]
pub type StartGeneratedCodeJobInputOperationOutputAlias = crate::operation::StartGeneratedCodeJob;
#[doc(hidden)]
pub type StartGeneratedCodeJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartGeneratedCodeJobInput {
    /// Consumes the builder and constructs an Operation<[`StartGeneratedCodeJob`](crate::operation::StartGeneratedCodeJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartGeneratedCodeJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::StartGeneratedCodeJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_59 = &_input.game_name;
                let input_59 = input_59.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let game_name = aws_smithy_http::label::fmt_string(input_59, false);
                if game_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_60 = &_input.snapshot_id;
                let input_60 = input_60.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "snapshot_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let snapshot_id = aws_smithy_http::label::fmt_string(input_60, false);
                if snapshot_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "snapshot_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/game/{GameName}/snapshot/{SnapshotId}/generated-sdk-code-job",
                    GameName = game_name,
                    SnapshotId = snapshot_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StartGeneratedCodeJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_generated_code_job(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartGeneratedCodeJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartGeneratedCodeJob",
            "gamesparks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StartGeneratedCodeJobInput`](crate::input::StartGeneratedCodeJobInput)
    pub fn builder() -> crate::input::start_generated_code_job_input::Builder {
        crate::input::start_generated_code_job_input::Builder::default()
    }
}

/// See [`StartStageDeploymentInput`](crate::input::StartStageDeploymentInput)
pub mod start_stage_deployment_input {
    /// A builder for [`StartStageDeploymentInput`](crate::input::StartStageDeploymentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_name: std::option::Option<std::string::String>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
        pub(crate) snapshot_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_name = Some(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.game_name = input;
            self
        }
        /// <p>The name of the stage to deploy the snapshot onto.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The name of the stage to deploy the snapshot onto.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// <p>The identifier of the snapshot to deploy.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the snapshot to deploy.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.snapshot_id = input;
            self
        }
        /// <p> A client-defined token. With an active client token in the request, this action is idempotent. </p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p> A client-defined token. With an active client token in the request, this action is idempotent. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`StartStageDeploymentInput`](crate::input::StartStageDeploymentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartStageDeploymentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartStageDeploymentInput {
                game_name: self.game_name,
                stage_name: self.stage_name,
                snapshot_id: self.snapshot_id,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type StartStageDeploymentInputOperationOutputAlias = crate::operation::StartStageDeployment;
#[doc(hidden)]
pub type StartStageDeploymentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartStageDeploymentInput {
    /// Consumes the builder and constructs an Operation<[`StartStageDeployment`](crate::operation::StartStageDeployment)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartStageDeployment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::StartStageDeploymentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_61 = &_input.game_name;
                let input_61 = input_61.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let game_name = aws_smithy_http::label::fmt_string(input_61, false);
                if game_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_62 = &_input.stage_name;
                let input_62 = input_62.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "stage_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let stage_name = aws_smithy_http::label::fmt_string(input_62, false);
                if stage_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "stage_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/game/{GameName}/stage/{StageName}/deployment",
                    GameName = game_name,
                    StageName = stage_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StartStageDeploymentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_stage_deployment(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartStageDeployment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartStageDeployment",
            "gamesparks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StartStageDeploymentInput`](crate::input::StartStageDeploymentInput)
    pub fn builder() -> crate::input::start_stage_deployment_input::Builder {
        crate::input::start_stage_deployment_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource to add the tags to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to add the tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to add to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_63 = &_input.resource_arn;
                let input_63 = input_63.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_63, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "gamesparks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource to remove the tags from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to remove the tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the tags to remove.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The keys of the tags to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UntagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_64 = &_input.resource_arn;
                let input_64 = input_64.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_64, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UntagResourceInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_65) = &_input.tag_keys {
                    for inner_66 in inner_65 {
                        query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_66));
                    }
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UntagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "gamesparks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateGameInput`](crate::input::UpdateGameInput)
pub mod update_game_input {
    /// A builder for [`UpdateGameInput`](crate::input::UpdateGameInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_name = Some(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.game_name = input;
            self
        }
        /// <p>The description of the game.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the game.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGameInput`](crate::input::UpdateGameInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateGameInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateGameInput {
                game_name: self.game_name,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateGameInputOperationOutputAlias = crate::operation::UpdateGame;
#[doc(hidden)]
pub type UpdateGameInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateGameInput {
    /// Consumes the builder and constructs an Operation<[`UpdateGame`](crate::operation::UpdateGame)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateGame,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateGameInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_67 = &_input.game_name;
                let input_67 = input_67.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let game_name = aws_smithy_http::label::fmt_string(input_67, false);
                if game_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/game/{GameName}", GameName = game_name)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateGameInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_game(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateGame::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateGame",
            "gamesparks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateGameInput`](crate::input::UpdateGameInput)
    pub fn builder() -> crate::input::update_game_input::Builder {
        crate::input::update_game_input::Builder::default()
    }
}

/// See [`UpdateGameConfigurationInput`](crate::input::UpdateGameConfigurationInput)
pub mod update_game_configuration_input {
    /// A builder for [`UpdateGameConfigurationInput`](crate::input::UpdateGameConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_name: std::option::Option<std::string::String>,
        pub(crate) modifications:
            std::option::Option<std::vec::Vec<crate::model::SectionModification>>,
    }
    impl Builder {
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_name = Some(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.game_name = input;
            self
        }
        /// Appends an item to `modifications`.
        ///
        /// To override the contents of this collection use [`set_modifications`](Self::set_modifications).
        ///
        /// <p>The list of modifications to make.</p>
        pub fn modifications(mut self, input: crate::model::SectionModification) -> Self {
            let mut v = self.modifications.unwrap_or_default();
            v.push(input);
            self.modifications = Some(v);
            self
        }
        /// <p>The list of modifications to make.</p>
        pub fn set_modifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SectionModification>>,
        ) -> Self {
            self.modifications = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGameConfigurationInput`](crate::input::UpdateGameConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateGameConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateGameConfigurationInput {
                game_name: self.game_name,
                modifications: self.modifications,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateGameConfigurationInputOperationOutputAlias =
    crate::operation::UpdateGameConfiguration;
#[doc(hidden)]
pub type UpdateGameConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateGameConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateGameConfiguration`](crate::operation::UpdateGameConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateGameConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateGameConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_68 = &_input.game_name;
                let input_68 = input_68.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let game_name = aws_smithy_http::label::fmt_string(input_68, false);
                if game_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/game/{GameName}/configuration",
                    GameName = game_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateGameConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_game_configuration(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateGameConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateGameConfiguration",
            "gamesparks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateGameConfigurationInput`](crate::input::UpdateGameConfigurationInput)
    pub fn builder() -> crate::input::update_game_configuration_input::Builder {
        crate::input::update_game_configuration_input::Builder::default()
    }
}

/// See [`UpdateSnapshotInput`](crate::input::UpdateSnapshotInput)
pub mod update_snapshot_input {
    /// A builder for [`UpdateSnapshotInput`](crate::input::UpdateSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_name: std::option::Option<std::string::String>,
        pub(crate) snapshot_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_name = Some(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.game_name = input;
            self
        }
        /// <p>The identifier of the snapshot.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the snapshot.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.snapshot_id = input;
            self
        }
        /// <p>The description of the snapshot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the snapshot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSnapshotInput`](crate::input::UpdateSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateSnapshotInput {
                game_name: self.game_name,
                snapshot_id: self.snapshot_id,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateSnapshotInputOperationOutputAlias = crate::operation::UpdateSnapshot;
#[doc(hidden)]
pub type UpdateSnapshotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`UpdateSnapshot`](crate::operation::UpdateSnapshot)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateSnapshot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateSnapshotInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_69 = &_input.game_name;
                let input_69 = input_69.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let game_name = aws_smithy_http::label::fmt_string(input_69, false);
                if game_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_70 = &_input.snapshot_id;
                let input_70 = input_70.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "snapshot_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let snapshot_id = aws_smithy_http::label::fmt_string(input_70, false);
                if snapshot_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "snapshot_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/game/{GameName}/snapshot/{SnapshotId}",
                    GameName = game_name,
                    SnapshotId = snapshot_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateSnapshotInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_snapshot(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateSnapshot",
            "gamesparks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateSnapshotInput`](crate::input::UpdateSnapshotInput)
    pub fn builder() -> crate::input::update_snapshot_input::Builder {
        crate::input::update_snapshot_input::Builder::default()
    }
}

/// See [`UpdateStageInput`](crate::input::UpdateStageInput)
pub mod update_stage_input {
    /// A builder for [`UpdateStageInput`](crate::input::UpdateStageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_name: std::option::Option<std::string::String>,
        pub(crate) stage_name: std::option::Option<std::string::String>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_name = Some(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.game_name = input;
            self
        }
        /// <p>The name of the stage.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_name = Some(input.into());
            self
        }
        /// <p>The name of the stage.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role to use for the game snapshots deployed to this stage.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role to use for the game snapshots deployed to this stage.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// <p>The description of the stage.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the stage.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateStageInput`](crate::input::UpdateStageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateStageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateStageInput {
                game_name: self.game_name,
                stage_name: self.stage_name,
                role: self.role,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateStageInputOperationOutputAlias = crate::operation::UpdateStage;
#[doc(hidden)]
pub type UpdateStageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateStageInput {
    /// Consumes the builder and constructs an Operation<[`UpdateStage`](crate::operation::UpdateStage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateStage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateStageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_71 = &_input.game_name;
                let input_71 = input_71.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let game_name = aws_smithy_http::label::fmt_string(input_71, false);
                if game_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "game_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_72 = &_input.stage_name;
                let input_72 = input_72.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "stage_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let stage_name = aws_smithy_http::label::fmt_string(input_72, false);
                if stage_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "stage_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/game/{GameName}/stage/{StageName}",
                    GameName = game_name,
                    StageName = stage_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateStageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_stage(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateStage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateStage",
            "gamesparks",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateStageInput`](crate::input::UpdateStageInput)
    pub fn builder() -> crate::input::update_stage_input::Builder {
        crate::input::update_stage_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateStageInput {
    /// <p>The name of the game.</p>
    pub game_name: std::option::Option<std::string::String>,
    /// <p>The name of the stage.</p>
    pub stage_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the role to use for the game snapshots deployed to this stage.</p>
    pub role: std::option::Option<std::string::String>,
    /// <p>The description of the stage.</p>
    pub description: std::option::Option<std::string::String>,
}
impl UpdateStageInput {
    /// <p>The name of the game.</p>
    pub fn game_name(&self) -> std::option::Option<&str> {
        self.game_name.as_deref()
    }
    /// <p>The name of the stage.</p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the role to use for the game snapshots deployed to this stage.</p>
    pub fn role(&self) -> std::option::Option<&str> {
        self.role.as_deref()
    }
    /// <p>The description of the stage.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for UpdateStageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateStageInput");
        formatter.field("game_name", &self.game_name);
        formatter.field("stage_name", &self.stage_name);
        formatter.field("role", &self.role);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSnapshotInput {
    /// <p>The name of the game.</p>
    pub game_name: std::option::Option<std::string::String>,
    /// <p>The identifier of the snapshot.</p>
    pub snapshot_id: std::option::Option<std::string::String>,
    /// <p>The description of the snapshot.</p>
    pub description: std::option::Option<std::string::String>,
}
impl UpdateSnapshotInput {
    /// <p>The name of the game.</p>
    pub fn game_name(&self) -> std::option::Option<&str> {
        self.game_name.as_deref()
    }
    /// <p>The identifier of the snapshot.</p>
    pub fn snapshot_id(&self) -> std::option::Option<&str> {
        self.snapshot_id.as_deref()
    }
    /// <p>The description of the snapshot.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for UpdateSnapshotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSnapshotInput");
        formatter.field("game_name", &self.game_name);
        formatter.field("snapshot_id", &self.snapshot_id);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGameConfigurationInput {
    /// <p>The name of the game.</p>
    pub game_name: std::option::Option<std::string::String>,
    /// <p>The list of modifications to make.</p>
    pub modifications: std::option::Option<std::vec::Vec<crate::model::SectionModification>>,
}
impl UpdateGameConfigurationInput {
    /// <p>The name of the game.</p>
    pub fn game_name(&self) -> std::option::Option<&str> {
        self.game_name.as_deref()
    }
    /// <p>The list of modifications to make.</p>
    pub fn modifications(&self) -> std::option::Option<&[crate::model::SectionModification]> {
        self.modifications.as_deref()
    }
}
impl std::fmt::Debug for UpdateGameConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGameConfigurationInput");
        formatter.field("game_name", &self.game_name);
        formatter.field("modifications", &self.modifications);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGameInput {
    /// <p>The name of the game.</p>
    pub game_name: std::option::Option<std::string::String>,
    /// <p>The description of the game.</p>
    pub description: std::option::Option<std::string::String>,
}
impl UpdateGameInput {
    /// <p>The name of the game.</p>
    pub fn game_name(&self) -> std::option::Option<&str> {
        self.game_name.as_deref()
    }
    /// <p>The description of the game.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for UpdateGameInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGameInput");
        formatter.field("game_name", &self.game_name);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource to remove the tags from.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The keys of the tags to remove.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource to remove the tags from.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The keys of the tags to remove.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource to add the tags to.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags to add to the resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource to add the tags to.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tags to add to the resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartStageDeploymentInput {
    /// <p>The name of the game.</p>
    pub game_name: std::option::Option<std::string::String>,
    /// <p>The name of the stage to deploy the snapshot onto.</p>
    pub stage_name: std::option::Option<std::string::String>,
    /// <p>The identifier of the snapshot to deploy.</p>
    pub snapshot_id: std::option::Option<std::string::String>,
    /// <p> A client-defined token. With an active client token in the request, this action is idempotent. </p>
    pub client_token: std::option::Option<std::string::String>,
}
impl StartStageDeploymentInput {
    /// <p>The name of the game.</p>
    pub fn game_name(&self) -> std::option::Option<&str> {
        self.game_name.as_deref()
    }
    /// <p>The name of the stage to deploy the snapshot onto.</p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
    /// <p>The identifier of the snapshot to deploy.</p>
    pub fn snapshot_id(&self) -> std::option::Option<&str> {
        self.snapshot_id.as_deref()
    }
    /// <p> A client-defined token. With an active client token in the request, this action is idempotent. </p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for StartStageDeploymentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartStageDeploymentInput");
        formatter.field("game_name", &self.game_name);
        formatter.field("stage_name", &self.stage_name);
        formatter.field("snapshot_id", &self.snapshot_id);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartGeneratedCodeJobInput {
    /// <p>The name of the game.</p>
    pub game_name: std::option::Option<std::string::String>,
    /// <p>The identifier of the snapshot for which to generate code.</p>
    pub snapshot_id: std::option::Option<std::string::String>,
    /// <p>Properties of the generator to use for the job.</p>
    pub generator: std::option::Option<crate::model::Generator>,
}
impl StartGeneratedCodeJobInput {
    /// <p>The name of the game.</p>
    pub fn game_name(&self) -> std::option::Option<&str> {
        self.game_name.as_deref()
    }
    /// <p>The identifier of the snapshot for which to generate code.</p>
    pub fn snapshot_id(&self) -> std::option::Option<&str> {
        self.snapshot_id.as_deref()
    }
    /// <p>Properties of the generator to use for the job.</p>
    pub fn generator(&self) -> std::option::Option<&crate::model::Generator> {
        self.generator.as_ref()
    }
}
impl std::fmt::Debug for StartGeneratedCodeJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartGeneratedCodeJobInput");
        formatter.field("game_name", &self.game_name);
        formatter.field("snapshot_id", &self.snapshot_id);
        formatter.field("generator", &self.generator);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the GameSparks resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the GameSparks resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStagesInput {
    /// <p>The name of the game.</p>
    pub game_name: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return.</p>
    /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token that indicates the start of the next sequential page of results.</p>
    /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListStagesInput {
    /// <p>The name of the game.</p>
    pub fn game_name(&self) -> std::option::Option<&str> {
        self.game_name.as_deref()
    }
    /// <p>The maximum number of results to return.</p>
    /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token that indicates the start of the next sequential page of results.</p>
    /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListStagesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStagesInput");
        formatter.field("game_name", &self.game_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStageDeploymentsInput {
    /// <p>The name of the game.</p>
    pub game_name: std::option::Option<std::string::String>,
    /// <p>The name of the stage.</p>
    pub stage_name: std::option::Option<std::string::String>,
    /// <p>The token that indicates the start of the next sequential page of results.</p>
    /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return.</p>
    /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
    pub max_results: std::option::Option<i32>,
}
impl ListStageDeploymentsInput {
    /// <p>The name of the game.</p>
    pub fn game_name(&self) -> std::option::Option<&str> {
        self.game_name.as_deref()
    }
    /// <p>The name of the stage.</p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
    /// <p>The token that indicates the start of the next sequential page of results.</p>
    /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return.</p>
    /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListStageDeploymentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStageDeploymentsInput");
        formatter.field("game_name", &self.game_name);
        formatter.field("stage_name", &self.stage_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSnapshotsInput {
    /// <p>The name of the game.</p>
    pub game_name: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return.</p>
    /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token that indicates the start of the next sequential page of results.</p>
    /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListSnapshotsInput {
    /// <p>The name of the game.</p>
    pub fn game_name(&self) -> std::option::Option<&str> {
        self.game_name.as_deref()
    }
    /// <p>The maximum number of results to return.</p>
    /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token that indicates the start of the next sequential page of results.</p>
    /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListSnapshotsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSnapshotsInput");
        formatter.field("game_name", &self.game_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGeneratedCodeJobsInput {
    /// <p>The name of the game.</p>
    pub game_name: std::option::Option<std::string::String>,
    /// <p>The identifier of the snapshot.</p>
    pub snapshot_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return.</p>
    /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token that indicates the start of the next sequential page of results.</p>
    /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListGeneratedCodeJobsInput {
    /// <p>The name of the game.</p>
    pub fn game_name(&self) -> std::option::Option<&str> {
        self.game_name.as_deref()
    }
    /// <p>The identifier of the snapshot.</p>
    pub fn snapshot_id(&self) -> std::option::Option<&str> {
        self.snapshot_id.as_deref()
    }
    /// <p>The maximum number of results to return.</p>
    /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token that indicates the start of the next sequential page of results.</p>
    /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListGeneratedCodeJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGeneratedCodeJobsInput");
        formatter.field("game_name", &self.game_name);
        formatter.field("snapshot_id", &self.snapshot_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGamesInput {
    /// <p>The maximum number of results to return.</p>
    /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token that indicates the start of the next sequential page of results.</p>
    /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListGamesInput {
    /// <p>The maximum number of results to return.</p>
    /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token that indicates the start of the next sequential page of results.</p>
    /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListGamesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGamesInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListExtensionVersionsInput {
    /// <p>The namespace (qualifier) of the extension.</p>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>The name of the extension.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The token that indicates the start of the next sequential page of results.</p>
    /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return.</p>
    /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
    pub max_results: std::option::Option<i32>,
}
impl ListExtensionVersionsInput {
    /// <p>The namespace (qualifier) of the extension.</p>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p>The name of the extension.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The token that indicates the start of the next sequential page of results.</p>
    /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return.</p>
    /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListExtensionVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListExtensionVersionsInput");
        formatter.field("namespace", &self.namespace);
        formatter.field("name", &self.name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListExtensionsInput {
    /// <p>The maximum number of results to return.</p>
    /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token that indicates the start of the next sequential page of results.</p>
    /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListExtensionsInput {
    /// <p>The maximum number of results to return.</p>
    /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token that indicates the start of the next sequential page of results.</p>
    /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListExtensionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListExtensionsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportGameConfigurationInput {
    /// <p>The name of the game.</p>
    pub game_name: std::option::Option<std::string::String>,
    /// <p>The source used to import configuration sections.</p>
    pub import_source: std::option::Option<crate::model::ImportGameConfigurationSource>,
}
impl ImportGameConfigurationInput {
    /// <p>The name of the game.</p>
    pub fn game_name(&self) -> std::option::Option<&str> {
        self.game_name.as_deref()
    }
    /// <p>The source used to import configuration sections.</p>
    pub fn import_source(
        &self,
    ) -> std::option::Option<&crate::model::ImportGameConfigurationSource> {
        self.import_source.as_ref()
    }
}
impl std::fmt::Debug for ImportGameConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportGameConfigurationInput");
        formatter.field("game_name", &self.game_name);
        formatter.field("import_source", &self.import_source);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetStageDeploymentInput {
    /// <p>The name of the game.</p>
    pub game_name: std::option::Option<std::string::String>,
    /// <p>The name of the stage.</p>
    pub stage_name: std::option::Option<std::string::String>,
    /// <p> The identifier of the stage deployment. <code>StartStageDeployment</code> returns the identifier that you use here. </p>
    pub deployment_id: std::option::Option<std::string::String>,
}
impl GetStageDeploymentInput {
    /// <p>The name of the game.</p>
    pub fn game_name(&self) -> std::option::Option<&str> {
        self.game_name.as_deref()
    }
    /// <p>The name of the stage.</p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
    /// <p> The identifier of the stage deployment. <code>StartStageDeployment</code> returns the identifier that you use here. </p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
}
impl std::fmt::Debug for GetStageDeploymentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetStageDeploymentInput");
        formatter.field("game_name", &self.game_name);
        formatter.field("stage_name", &self.stage_name);
        formatter.field("deployment_id", &self.deployment_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetStageInput {
    /// <p>The name of the game.</p>
    pub game_name: std::option::Option<std::string::String>,
    /// <p>The name of the stage.</p>
    pub stage_name: std::option::Option<std::string::String>,
}
impl GetStageInput {
    /// <p>The name of the game.</p>
    pub fn game_name(&self) -> std::option::Option<&str> {
        self.game_name.as_deref()
    }
    /// <p>The name of the stage.</p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
}
impl std::fmt::Debug for GetStageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetStageInput");
        formatter.field("game_name", &self.game_name);
        formatter.field("stage_name", &self.stage_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSnapshotInput {
    /// <p>The name of the game.</p>
    pub game_name: std::option::Option<std::string::String>,
    /// <p>The identifier of the snapshot.</p>
    pub snapshot_id: std::option::Option<std::string::String>,
    /// <p>The list of game configuration sections to be described.</p>
    pub sections: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl GetSnapshotInput {
    /// <p>The name of the game.</p>
    pub fn game_name(&self) -> std::option::Option<&str> {
        self.game_name.as_deref()
    }
    /// <p>The identifier of the snapshot.</p>
    pub fn snapshot_id(&self) -> std::option::Option<&str> {
        self.snapshot_id.as_deref()
    }
    /// <p>The list of game configuration sections to be described.</p>
    pub fn sections(&self) -> std::option::Option<&[std::string::String]> {
        self.sections.as_deref()
    }
}
impl std::fmt::Debug for GetSnapshotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSnapshotInput");
        formatter.field("game_name", &self.game_name);
        formatter.field("snapshot_id", &self.snapshot_id);
        formatter.field("sections", &self.sections);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPlayerConnectionStatusInput {
    /// <p>The unique identifier representing a player.</p>
    pub player_id: std::option::Option<std::string::String>,
    /// <p>The name of the game.</p>
    pub game_name: std::option::Option<std::string::String>,
    /// <p>The name of the stage.</p>
    pub stage_name: std::option::Option<std::string::String>,
}
impl GetPlayerConnectionStatusInput {
    /// <p>The unique identifier representing a player.</p>
    pub fn player_id(&self) -> std::option::Option<&str> {
        self.player_id.as_deref()
    }
    /// <p>The name of the game.</p>
    pub fn game_name(&self) -> std::option::Option<&str> {
        self.game_name.as_deref()
    }
    /// <p>The name of the stage.</p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
}
impl std::fmt::Debug for GetPlayerConnectionStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPlayerConnectionStatusInput");
        formatter.field("player_id", &self.player_id);
        formatter.field("game_name", &self.game_name);
        formatter.field("stage_name", &self.stage_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGeneratedCodeJobInput {
    /// <p>The name of the game.</p>
    pub game_name: std::option::Option<std::string::String>,
    /// <p>The identifier of the snapshot for the code generation job.</p>
    pub snapshot_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the code generation job.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl GetGeneratedCodeJobInput {
    /// <p>The name of the game.</p>
    pub fn game_name(&self) -> std::option::Option<&str> {
        self.game_name.as_deref()
    }
    /// <p>The identifier of the snapshot for the code generation job.</p>
    pub fn snapshot_id(&self) -> std::option::Option<&str> {
        self.snapshot_id.as_deref()
    }
    /// <p>The identifier of the code generation job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for GetGeneratedCodeJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGeneratedCodeJobInput");
        formatter.field("game_name", &self.game_name);
        formatter.field("snapshot_id", &self.snapshot_id);
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGameConfigurationInput {
    /// <p>The name of the game.</p>
    pub game_name: std::option::Option<std::string::String>,
    /// <p>The list of sections to return.</p>
    pub sections: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl GetGameConfigurationInput {
    /// <p>The name of the game.</p>
    pub fn game_name(&self) -> std::option::Option<&str> {
        self.game_name.as_deref()
    }
    /// <p>The list of sections to return.</p>
    pub fn sections(&self) -> std::option::Option<&[std::string::String]> {
        self.sections.as_deref()
    }
}
impl std::fmt::Debug for GetGameConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGameConfigurationInput");
        formatter.field("game_name", &self.game_name);
        formatter.field("sections", &self.sections);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGameInput {
    /// <p>The name of the game.</p>
    pub game_name: std::option::Option<std::string::String>,
}
impl GetGameInput {
    /// <p>The name of the game.</p>
    pub fn game_name(&self) -> std::option::Option<&str> {
        self.game_name.as_deref()
    }
}
impl std::fmt::Debug for GetGameInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGameInput");
        formatter.field("game_name", &self.game_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetExtensionVersionInput {
    /// <p>The namespace (qualifier) of the extension.</p>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>The name of the extension.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version of the extension.</p>
    pub extension_version: std::option::Option<std::string::String>,
}
impl GetExtensionVersionInput {
    /// <p>The namespace (qualifier) of the extension.</p>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p>The name of the extension.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The version of the extension.</p>
    pub fn extension_version(&self) -> std::option::Option<&str> {
        self.extension_version.as_deref()
    }
}
impl std::fmt::Debug for GetExtensionVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetExtensionVersionInput");
        formatter.field("namespace", &self.namespace);
        formatter.field("name", &self.name);
        formatter.field("extension_version", &self.extension_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetExtensionInput {
    /// <p>The namespace (qualifier) of the extension.</p>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>The name of the extension.</p>
    pub name: std::option::Option<std::string::String>,
}
impl GetExtensionInput {
    /// <p>The namespace (qualifier) of the extension.</p>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p>The name of the extension.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for GetExtensionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetExtensionInput");
        formatter.field("namespace", &self.namespace);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportSnapshotInput {
    /// <p>The name of the game.</p>
    pub game_name: std::option::Option<std::string::String>,
    /// <p>The identifier of the snapshot to export.</p>
    pub snapshot_id: std::option::Option<std::string::String>,
}
impl ExportSnapshotInput {
    /// <p>The name of the game.</p>
    pub fn game_name(&self) -> std::option::Option<&str> {
        self.game_name.as_deref()
    }
    /// <p>The identifier of the snapshot to export.</p>
    pub fn snapshot_id(&self) -> std::option::Option<&str> {
        self.snapshot_id.as_deref()
    }
}
impl std::fmt::Debug for ExportSnapshotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportSnapshotInput");
        formatter.field("game_name", &self.game_name);
        formatter.field("snapshot_id", &self.snapshot_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisconnectPlayerInput {
    /// <p>The unique identifier representing a player.</p>
    pub player_id: std::option::Option<std::string::String>,
    /// <p>The name of the game.</p>
    pub game_name: std::option::Option<std::string::String>,
    /// <p>The name of the stage.</p>
    pub stage_name: std::option::Option<std::string::String>,
}
impl DisconnectPlayerInput {
    /// <p>The unique identifier representing a player.</p>
    pub fn player_id(&self) -> std::option::Option<&str> {
        self.player_id.as_deref()
    }
    /// <p>The name of the game.</p>
    pub fn game_name(&self) -> std::option::Option<&str> {
        self.game_name.as_deref()
    }
    /// <p>The name of the stage.</p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
}
impl std::fmt::Debug for DisconnectPlayerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisconnectPlayerInput");
        formatter.field("player_id", &self.player_id);
        formatter.field("game_name", &self.game_name);
        formatter.field("stage_name", &self.stage_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteStageInput {
    /// <p>The name of the game.</p>
    pub game_name: std::option::Option<std::string::String>,
    /// <p>The name of the stage to delete.</p>
    pub stage_name: std::option::Option<std::string::String>,
}
impl DeleteStageInput {
    /// <p>The name of the game.</p>
    pub fn game_name(&self) -> std::option::Option<&str> {
        self.game_name.as_deref()
    }
    /// <p>The name of the stage to delete.</p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteStageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteStageInput");
        formatter.field("game_name", &self.game_name);
        formatter.field("stage_name", &self.stage_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGameInput {
    /// <p>The name of the game to delete.</p>
    pub game_name: std::option::Option<std::string::String>,
}
impl DeleteGameInput {
    /// <p>The name of the game to delete.</p>
    pub fn game_name(&self) -> std::option::Option<&str> {
        self.game_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteGameInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGameInput");
        formatter.field("game_name", &self.game_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateStageInput {
    /// <p>The name of the game.</p>
    pub game_name: std::option::Option<std::string::String>,
    /// <p>The name of the stage.</p>
    pub stage_name: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) of the role to run the game with. This role can be a game-defined role or the default role that GameSparks created. </p>
    pub role: std::option::Option<std::string::String>,
    /// <p>The description of the stage.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p> A client-defined token. With an active client token in the request, this action is idempotent. </p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The list of tags to apply to the stage.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateStageInput {
    /// <p>The name of the game.</p>
    pub fn game_name(&self) -> std::option::Option<&str> {
        self.game_name.as_deref()
    }
    /// <p>The name of the stage.</p>
    pub fn stage_name(&self) -> std::option::Option<&str> {
        self.stage_name.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) of the role to run the game with. This role can be a game-defined role or the default role that GameSparks created. </p>
    pub fn role(&self) -> std::option::Option<&str> {
        self.role.as_deref()
    }
    /// <p>The description of the stage.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> A client-defined token. With an active client token in the request, this action is idempotent. </p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The list of tags to apply to the stage.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateStageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateStageInput");
        formatter.field("game_name", &self.game_name);
        formatter.field("stage_name", &self.stage_name);
        formatter.field("role", &self.role);
        formatter.field("description", &self.description);
        formatter.field("client_token", &self.client_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSnapshotInput {
    /// <p>The name of the game.</p>
    pub game_name: std::option::Option<std::string::String>,
    /// <p>The description of the snapshot.</p>
    pub description: std::option::Option<std::string::String>,
}
impl CreateSnapshotInput {
    /// <p>The name of the game.</p>
    pub fn game_name(&self) -> std::option::Option<&str> {
        self.game_name.as_deref()
    }
    /// <p>The description of the snapshot.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for CreateSnapshotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSnapshotInput");
        formatter.field("game_name", &self.game_name);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGameInput {
    /// <p>The name of the game.</p>
    pub game_name: std::option::Option<std::string::String>,
    /// <p>The description of the game.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p> A client-defined token. With an active client token in the request, this action is idempotent. </p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The list of tags to apply to the game.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateGameInput {
    /// <p>The name of the game.</p>
    pub fn game_name(&self) -> std::option::Option<&str> {
        self.game_name.as_deref()
    }
    /// <p>The description of the game.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> A client-defined token. With an active client token in the request, this action is idempotent. </p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The list of tags to apply to the game.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateGameInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGameInput");
        formatter.field("game_name", &self.game_name);
        formatter.field("description", &self.description);
        formatter.field("client_token", &self.client_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
