// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateGame` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateGameError {
    /// Kind of error that occurred.
    pub kind: CreateGameErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateGame` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateGameErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The resource already exists, or another operation is in progress.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request would result in exceeding service quota.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request throughput limit was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the parameters in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateGameError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateGameErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateGameErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateGameErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateGameErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateGameErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateGameErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateGameErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateGameError {
    fn code(&self) -> Option<&str> {
        CreateGameError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateGameError {
    /// Creates a new `CreateGameError`.
    pub fn new(kind: CreateGameErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateGameError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateGameErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateGameError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateGameErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateGameErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateGameErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateGameErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateGameErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateGameErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, CreateGameErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `CreateGameErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGameErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGameErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateGameErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateGameErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateGameErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateGameError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateGameErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateGameErrorKind::ConflictException(_inner) => Some(_inner),
            CreateGameErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateGameErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateGameErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateGameErrorKind::ValidationException(_inner) => Some(_inner),
            CreateGameErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSnapshotError {
    /// Kind of error that occurred.
    pub kind: CreateSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSnapshotErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The resource already exists, or another operation is in progress.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request throughput limit was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the parameters in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSnapshotErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateSnapshotErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateSnapshotErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateSnapshotErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateSnapshotErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateSnapshotErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSnapshotError {
    fn code(&self) -> Option<&str> {
        CreateSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSnapshotError {
    /// Creates a new `CreateSnapshotError`.
    pub fn new(kind: CreateSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSnapshotErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSnapshotErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSnapshotErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateSnapshotErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateSnapshotErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSnapshotErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSnapshotErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSnapshotErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSnapshotErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateSnapshotErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateSnapshotErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateSnapshotErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSnapshotErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateSnapshotErrorKind::ConflictException(_inner) => Some(_inner),
            CreateSnapshotErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateSnapshotErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateSnapshotErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateSnapshotErrorKind::ValidationException(_inner) => Some(_inner),
            CreateSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateStage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateStageError {
    /// Kind of error that occurred.
    pub kind: CreateStageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateStage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateStageErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The resource already exists, or another operation is in progress.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request throughput limit was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the parameters in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateStageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateStageErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateStageErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateStageErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateStageErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateStageErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateStageErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateStageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateStageError {
    fn code(&self) -> Option<&str> {
        CreateStageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateStageError {
    /// Creates a new `CreateStageError`.
    pub fn new(kind: CreateStageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateStageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateStageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateStageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateStageErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateStageErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateStageErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateStageErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateStageErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateStageErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, CreateStageErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `CreateStageErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStageErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStageErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateStageErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateStageErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateStageErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateStageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateStageErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateStageErrorKind::ConflictException(_inner) => Some(_inner),
            CreateStageErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateStageErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateStageErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateStageErrorKind::ValidationException(_inner) => Some(_inner),
            CreateStageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteGame` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteGameError {
    /// Kind of error that occurred.
    pub kind: DeleteGameErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteGame` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteGameErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The resource already exists, or another operation is in progress.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request throughput limit was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the parameters in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteGameError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteGameErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteGameErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteGameErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteGameErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteGameErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteGameErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteGameError {
    fn code(&self) -> Option<&str> {
        DeleteGameError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteGameError {
    /// Creates a new `DeleteGameError`.
    pub fn new(kind: DeleteGameErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteGameError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteGameErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteGameError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteGameErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteGameErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteGameErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteGameErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteGameErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteGameErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, DeleteGameErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `DeleteGameErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteGameErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteGameErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteGameErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteGameError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteGameErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteGameErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteGameErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteGameErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteGameErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteGameErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteStage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteStageError {
    /// Kind of error that occurred.
    pub kind: DeleteStageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteStage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteStageErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The resource already exists, or another operation is in progress.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request throughput limit was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the parameters in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteStageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteStageErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteStageErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteStageErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteStageErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteStageErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteStageErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteStageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteStageError {
    fn code(&self) -> Option<&str> {
        DeleteStageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteStageError {
    /// Creates a new `DeleteStageError`.
    pub fn new(kind: DeleteStageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteStageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteStageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteStageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteStageErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteStageErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteStageErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteStageErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteStageErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteStageErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, DeleteStageErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `DeleteStageErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStageErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteStageErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteStageErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteStageErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteStageErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteStageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteStageErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteStageErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteStageErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteStageErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteStageErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteStageErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteStageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisconnectPlayer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisconnectPlayerError {
    /// Kind of error that occurred.
    pub kind: DisconnectPlayerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisconnectPlayer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisconnectPlayerErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The service encountered an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request throughput limit was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the parameters in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisconnectPlayerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisconnectPlayerErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DisconnectPlayerErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DisconnectPlayerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisconnectPlayerErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisconnectPlayerErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DisconnectPlayerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisconnectPlayerError {
    fn code(&self) -> Option<&str> {
        DisconnectPlayerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisconnectPlayerError {
    /// Creates a new `DisconnectPlayerError`.
    pub fn new(kind: DisconnectPlayerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisconnectPlayerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisconnectPlayerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisconnectPlayerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisconnectPlayerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisconnectPlayerErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisconnectPlayerErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisconnectPlayerErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisconnectPlayerErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DisconnectPlayerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisconnectPlayerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisconnectPlayerErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisconnectPlayerErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DisconnectPlayerErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisconnectPlayerErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisconnectPlayerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisconnectPlayerErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DisconnectPlayerErrorKind::InternalServerException(_inner) => Some(_inner),
            DisconnectPlayerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisconnectPlayerErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisconnectPlayerErrorKind::ValidationException(_inner) => Some(_inner),
            DisconnectPlayerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ExportSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ExportSnapshotError {
    /// Kind of error that occurred.
    pub kind: ExportSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ExportSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ExportSnapshotErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The service encountered an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request throughput limit was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the parameters in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ExportSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ExportSnapshotErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ExportSnapshotErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ExportSnapshotErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ExportSnapshotErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ExportSnapshotErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ExportSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ExportSnapshotError {
    fn code(&self) -> Option<&str> {
        ExportSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ExportSnapshotError {
    /// Creates a new `ExportSnapshotError`.
    pub fn new(kind: ExportSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ExportSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ExportSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ExportSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ExportSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ExportSnapshotErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExportSnapshotErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ExportSnapshotErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExportSnapshotErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ExportSnapshotErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExportSnapshotErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ExportSnapshotErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ExportSnapshotErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ExportSnapshotErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ExportSnapshotErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ExportSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ExportSnapshotErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ExportSnapshotErrorKind::InternalServerException(_inner) => Some(_inner),
            ExportSnapshotErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ExportSnapshotErrorKind::ThrottlingException(_inner) => Some(_inner),
            ExportSnapshotErrorKind::ValidationException(_inner) => Some(_inner),
            ExportSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetExtension` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetExtensionError {
    /// Kind of error that occurred.
    pub kind: GetExtensionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetExtension` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetExtensionErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The service encountered an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request throughput limit was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the parameters in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetExtensionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetExtensionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetExtensionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetExtensionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetExtensionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetExtensionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetExtensionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetExtensionError {
    fn code(&self) -> Option<&str> {
        GetExtensionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetExtensionError {
    /// Creates a new `GetExtensionError`.
    pub fn new(kind: GetExtensionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetExtensionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetExtensionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetExtensionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetExtensionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetExtensionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetExtensionErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetExtensionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExtensionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetExtensionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExtensionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetExtensionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetExtensionErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetExtensionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetExtensionErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetExtensionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetExtensionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetExtensionErrorKind::InternalServerException(_inner) => Some(_inner),
            GetExtensionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetExtensionErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetExtensionErrorKind::ValidationException(_inner) => Some(_inner),
            GetExtensionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetExtensionVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetExtensionVersionError {
    /// Kind of error that occurred.
    pub kind: GetExtensionVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetExtensionVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetExtensionVersionErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The service encountered an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request throughput limit was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the parameters in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetExtensionVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetExtensionVersionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetExtensionVersionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetExtensionVersionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetExtensionVersionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetExtensionVersionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetExtensionVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetExtensionVersionError {
    fn code(&self) -> Option<&str> {
        GetExtensionVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetExtensionVersionError {
    /// Creates a new `GetExtensionVersionError`.
    pub fn new(kind: GetExtensionVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetExtensionVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetExtensionVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetExtensionVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetExtensionVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetExtensionVersionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExtensionVersionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetExtensionVersionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExtensionVersionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetExtensionVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExtensionVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetExtensionVersionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExtensionVersionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetExtensionVersionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExtensionVersionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetExtensionVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetExtensionVersionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetExtensionVersionErrorKind::InternalServerException(_inner) => Some(_inner),
            GetExtensionVersionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetExtensionVersionErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetExtensionVersionErrorKind::ValidationException(_inner) => Some(_inner),
            GetExtensionVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetGame` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetGameError {
    /// Kind of error that occurred.
    pub kind: GetGameErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetGame` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetGameErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The service encountered an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request throughput limit was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the parameters in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetGameError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetGameErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetGameErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetGameErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetGameErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetGameErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetGameErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetGameError {
    fn code(&self) -> Option<&str> {
        GetGameError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetGameError {
    /// Creates a new `GetGameError`.
    pub fn new(kind: GetGameErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetGameError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetGameErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetGameError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetGameErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetGameErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetGameErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetGameErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetGameErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `GetGameErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetGameErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetGameErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetGameErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetGameErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetGameErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetGameError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetGameErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetGameErrorKind::InternalServerException(_inner) => Some(_inner),
            GetGameErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetGameErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetGameErrorKind::ValidationException(_inner) => Some(_inner),
            GetGameErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetGameConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetGameConfigurationError {
    /// Kind of error that occurred.
    pub kind: GetGameConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetGameConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetGameConfigurationErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The service encountered an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request throughput limit was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the parameters in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetGameConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetGameConfigurationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetGameConfigurationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetGameConfigurationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetGameConfigurationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetGameConfigurationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetGameConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetGameConfigurationError {
    fn code(&self) -> Option<&str> {
        GetGameConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetGameConfigurationError {
    /// Creates a new `GetGameConfigurationError`.
    pub fn new(kind: GetGameConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetGameConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetGameConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetGameConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetGameConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetGameConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGameConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetGameConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGameConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetGameConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGameConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetGameConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGameConfigurationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetGameConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGameConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetGameConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetGameConfigurationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetGameConfigurationErrorKind::InternalServerException(_inner) => Some(_inner),
            GetGameConfigurationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetGameConfigurationErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetGameConfigurationErrorKind::ValidationException(_inner) => Some(_inner),
            GetGameConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetGeneratedCodeJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetGeneratedCodeJobError {
    /// Kind of error that occurred.
    pub kind: GetGeneratedCodeJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetGeneratedCodeJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetGeneratedCodeJobErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The service encountered an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request throughput limit was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the parameters in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetGeneratedCodeJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetGeneratedCodeJobErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetGeneratedCodeJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetGeneratedCodeJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetGeneratedCodeJobErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetGeneratedCodeJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetGeneratedCodeJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetGeneratedCodeJobError {
    fn code(&self) -> Option<&str> {
        GetGeneratedCodeJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetGeneratedCodeJobError {
    /// Creates a new `GetGeneratedCodeJobError`.
    pub fn new(kind: GetGeneratedCodeJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetGeneratedCodeJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetGeneratedCodeJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetGeneratedCodeJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetGeneratedCodeJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetGeneratedCodeJobErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGeneratedCodeJobErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetGeneratedCodeJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGeneratedCodeJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetGeneratedCodeJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGeneratedCodeJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetGeneratedCodeJobErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGeneratedCodeJobErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetGeneratedCodeJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGeneratedCodeJobErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetGeneratedCodeJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetGeneratedCodeJobErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetGeneratedCodeJobErrorKind::InternalServerException(_inner) => Some(_inner),
            GetGeneratedCodeJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetGeneratedCodeJobErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetGeneratedCodeJobErrorKind::ValidationException(_inner) => Some(_inner),
            GetGeneratedCodeJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPlayerConnectionStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPlayerConnectionStatusError {
    /// Kind of error that occurred.
    pub kind: GetPlayerConnectionStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPlayerConnectionStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPlayerConnectionStatusErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The service encountered an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request throughput limit was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the parameters in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPlayerConnectionStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPlayerConnectionStatusErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetPlayerConnectionStatusErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetPlayerConnectionStatusErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetPlayerConnectionStatusErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetPlayerConnectionStatusErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetPlayerConnectionStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPlayerConnectionStatusError {
    fn code(&self) -> Option<&str> {
        GetPlayerConnectionStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPlayerConnectionStatusError {
    /// Creates a new `GetPlayerConnectionStatusError`.
    pub fn new(kind: GetPlayerConnectionStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPlayerConnectionStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPlayerConnectionStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPlayerConnectionStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPlayerConnectionStatusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPlayerConnectionStatusErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPlayerConnectionStatusErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPlayerConnectionStatusErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPlayerConnectionStatusErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPlayerConnectionStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPlayerConnectionStatusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPlayerConnectionStatusErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPlayerConnectionStatusErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPlayerConnectionStatusErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPlayerConnectionStatusErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetPlayerConnectionStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPlayerConnectionStatusErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetPlayerConnectionStatusErrorKind::InternalServerException(_inner) => Some(_inner),
            GetPlayerConnectionStatusErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetPlayerConnectionStatusErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetPlayerConnectionStatusErrorKind::ValidationException(_inner) => Some(_inner),
            GetPlayerConnectionStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSnapshotError {
    /// Kind of error that occurred.
    pub kind: GetSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSnapshotErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The service encountered an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request throughput limit was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the parameters in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSnapshotErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetSnapshotErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetSnapshotErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetSnapshotErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetSnapshotErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSnapshotError {
    fn code(&self) -> Option<&str> {
        GetSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSnapshotError {
    /// Creates a new `GetSnapshotError`.
    pub fn new(kind: GetSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSnapshotErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetSnapshotErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetSnapshotErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetSnapshotErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `GetSnapshotErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSnapshotErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSnapshotErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetSnapshotErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetSnapshotErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetSnapshotErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSnapshotErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetSnapshotErrorKind::InternalServerException(_inner) => Some(_inner),
            GetSnapshotErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetSnapshotErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetSnapshotErrorKind::ValidationException(_inner) => Some(_inner),
            GetSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetStage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetStageError {
    /// Kind of error that occurred.
    pub kind: GetStageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetStage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetStageErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The service encountered an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request throughput limit was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the parameters in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetStageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetStageErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetStageErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetStageErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetStageErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetStageErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetStageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetStageError {
    fn code(&self) -> Option<&str> {
        GetStageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetStageError {
    /// Creates a new `GetStageError`.
    pub fn new(kind: GetStageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetStageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetStageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetStageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetStageErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetStageErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetStageErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetStageErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetStageErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `GetStageErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetStageErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetStageErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetStageErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetStageErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetStageErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetStageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetStageErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetStageErrorKind::InternalServerException(_inner) => Some(_inner),
            GetStageErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetStageErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetStageErrorKind::ValidationException(_inner) => Some(_inner),
            GetStageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetStageDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetStageDeploymentError {
    /// Kind of error that occurred.
    pub kind: GetStageDeploymentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetStageDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetStageDeploymentErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The service encountered an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request throughput limit was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the parameters in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetStageDeploymentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetStageDeploymentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetStageDeploymentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetStageDeploymentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetStageDeploymentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetStageDeploymentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetStageDeploymentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetStageDeploymentError {
    fn code(&self) -> Option<&str> {
        GetStageDeploymentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetStageDeploymentError {
    /// Creates a new `GetStageDeploymentError`.
    pub fn new(kind: GetStageDeploymentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetStageDeploymentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetStageDeploymentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetStageDeploymentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetStageDeploymentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetStageDeploymentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStageDeploymentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetStageDeploymentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStageDeploymentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetStageDeploymentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStageDeploymentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetStageDeploymentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStageDeploymentErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetStageDeploymentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStageDeploymentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetStageDeploymentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetStageDeploymentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetStageDeploymentErrorKind::InternalServerException(_inner) => Some(_inner),
            GetStageDeploymentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetStageDeploymentErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetStageDeploymentErrorKind::ValidationException(_inner) => Some(_inner),
            GetStageDeploymentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ImportGameConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ImportGameConfigurationError {
    /// Kind of error that occurred.
    pub kind: ImportGameConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ImportGameConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ImportGameConfigurationErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The service encountered an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request would result in exceeding service quota.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request throughput limit was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the parameters in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ImportGameConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ImportGameConfigurationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ImportGameConfigurationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ImportGameConfigurationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ImportGameConfigurationErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            ImportGameConfigurationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ImportGameConfigurationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ImportGameConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ImportGameConfigurationError {
    fn code(&self) -> Option<&str> {
        ImportGameConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ImportGameConfigurationError {
    /// Creates a new `ImportGameConfigurationError`.
    pub fn new(kind: ImportGameConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ImportGameConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ImportGameConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ImportGameConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ImportGameConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ImportGameConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportGameConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportGameConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportGameConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportGameConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportGameConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportGameConfigurationErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportGameConfigurationErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportGameConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportGameConfigurationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportGameConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportGameConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ImportGameConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ImportGameConfigurationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ImportGameConfigurationErrorKind::InternalServerException(_inner) => Some(_inner),
            ImportGameConfigurationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ImportGameConfigurationErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            ImportGameConfigurationErrorKind::ThrottlingException(_inner) => Some(_inner),
            ImportGameConfigurationErrorKind::ValidationException(_inner) => Some(_inner),
            ImportGameConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListExtensions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListExtensionsError {
    /// Kind of error that occurred.
    pub kind: ListExtensionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListExtensions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListExtensionsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The service encountered an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request throughput limit was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the parameters in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListExtensionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListExtensionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListExtensionsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListExtensionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListExtensionsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListExtensionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListExtensionsError {
    fn code(&self) -> Option<&str> {
        ListExtensionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListExtensionsError {
    /// Creates a new `ListExtensionsError`.
    pub fn new(kind: ListExtensionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListExtensionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListExtensionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListExtensionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListExtensionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListExtensionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListExtensionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListExtensionsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListExtensionsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListExtensionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListExtensionsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListExtensionsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListExtensionsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListExtensionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListExtensionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListExtensionsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListExtensionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListExtensionsErrorKind::ValidationException(_inner) => Some(_inner),
            ListExtensionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListExtensionVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListExtensionVersionsError {
    /// Kind of error that occurred.
    pub kind: ListExtensionVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListExtensionVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListExtensionVersionsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The service encountered an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request throughput limit was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the parameters in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListExtensionVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListExtensionVersionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListExtensionVersionsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListExtensionVersionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListExtensionVersionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListExtensionVersionsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListExtensionVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListExtensionVersionsError {
    fn code(&self) -> Option<&str> {
        ListExtensionVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListExtensionVersionsError {
    /// Creates a new `ListExtensionVersionsError`.
    pub fn new(kind: ListExtensionVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListExtensionVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListExtensionVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListExtensionVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListExtensionVersionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListExtensionVersionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListExtensionVersionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListExtensionVersionsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListExtensionVersionsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListExtensionVersionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListExtensionVersionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListExtensionVersionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListExtensionVersionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListExtensionVersionsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListExtensionVersionsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListExtensionVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListExtensionVersionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListExtensionVersionsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListExtensionVersionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListExtensionVersionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListExtensionVersionsErrorKind::ValidationException(_inner) => Some(_inner),
            ListExtensionVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListGames` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListGamesError {
    /// Kind of error that occurred.
    pub kind: ListGamesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListGames` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListGamesErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The service encountered an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request throughput limit was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the parameters in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListGamesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListGamesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListGamesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListGamesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListGamesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListGamesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListGamesError {
    fn code(&self) -> Option<&str> {
        ListGamesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListGamesError {
    /// Creates a new `ListGamesError`.
    pub fn new(kind: ListGamesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListGamesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListGamesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListGamesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListGamesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListGamesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListGamesErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListGamesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListGamesErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `ListGamesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListGamesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListGamesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListGamesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListGamesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListGamesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListGamesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListGamesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListGamesErrorKind::ValidationException(_inner) => Some(_inner),
            ListGamesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListGeneratedCodeJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListGeneratedCodeJobsError {
    /// Kind of error that occurred.
    pub kind: ListGeneratedCodeJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListGeneratedCodeJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListGeneratedCodeJobsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The service encountered an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request throughput limit was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the parameters in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListGeneratedCodeJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListGeneratedCodeJobsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListGeneratedCodeJobsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListGeneratedCodeJobsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListGeneratedCodeJobsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListGeneratedCodeJobsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListGeneratedCodeJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListGeneratedCodeJobsError {
    fn code(&self) -> Option<&str> {
        ListGeneratedCodeJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListGeneratedCodeJobsError {
    /// Creates a new `ListGeneratedCodeJobsError`.
    pub fn new(kind: ListGeneratedCodeJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListGeneratedCodeJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListGeneratedCodeJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListGeneratedCodeJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListGeneratedCodeJobsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListGeneratedCodeJobsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGeneratedCodeJobsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGeneratedCodeJobsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGeneratedCodeJobsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGeneratedCodeJobsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGeneratedCodeJobsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGeneratedCodeJobsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGeneratedCodeJobsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGeneratedCodeJobsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGeneratedCodeJobsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListGeneratedCodeJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListGeneratedCodeJobsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListGeneratedCodeJobsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListGeneratedCodeJobsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListGeneratedCodeJobsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListGeneratedCodeJobsErrorKind::ValidationException(_inner) => Some(_inner),
            ListGeneratedCodeJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSnapshots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSnapshotsError {
    /// Kind of error that occurred.
    pub kind: ListSnapshotsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSnapshots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSnapshotsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The service encountered an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request throughput limit was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the parameters in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSnapshotsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSnapshotsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListSnapshotsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListSnapshotsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListSnapshotsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListSnapshotsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListSnapshotsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSnapshotsError {
    fn code(&self) -> Option<&str> {
        ListSnapshotsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSnapshotsError {
    /// Creates a new `ListSnapshotsError`.
    pub fn new(kind: ListSnapshotsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSnapshotsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSnapshotsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSnapshotsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSnapshotsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSnapshotsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListSnapshotsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListSnapshotsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSnapshotsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSnapshotsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSnapshotsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSnapshotsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListSnapshotsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListSnapshotsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListSnapshotsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListSnapshotsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSnapshotsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListSnapshotsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListSnapshotsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListSnapshotsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListSnapshotsErrorKind::ValidationException(_inner) => Some(_inner),
            ListSnapshotsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListStageDeployments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListStageDeploymentsError {
    /// Kind of error that occurred.
    pub kind: ListStageDeploymentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListStageDeployments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListStageDeploymentsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The service encountered an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request throughput limit was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the parameters in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListStageDeploymentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListStageDeploymentsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListStageDeploymentsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListStageDeploymentsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListStageDeploymentsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListStageDeploymentsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListStageDeploymentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListStageDeploymentsError {
    fn code(&self) -> Option<&str> {
        ListStageDeploymentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListStageDeploymentsError {
    /// Creates a new `ListStageDeploymentsError`.
    pub fn new(kind: ListStageDeploymentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListStageDeploymentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListStageDeploymentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListStageDeploymentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListStageDeploymentsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListStageDeploymentsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStageDeploymentsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListStageDeploymentsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStageDeploymentsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListStageDeploymentsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStageDeploymentsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListStageDeploymentsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStageDeploymentsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListStageDeploymentsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStageDeploymentsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListStageDeploymentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListStageDeploymentsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListStageDeploymentsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListStageDeploymentsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListStageDeploymentsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListStageDeploymentsErrorKind::ValidationException(_inner) => Some(_inner),
            ListStageDeploymentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListStages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListStagesError {
    /// Kind of error that occurred.
    pub kind: ListStagesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListStages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListStagesErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The service encountered an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request throughput limit was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the parameters in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListStagesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListStagesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListStagesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListStagesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListStagesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListStagesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListStagesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListStagesError {
    fn code(&self) -> Option<&str> {
        ListStagesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListStagesError {
    /// Creates a new `ListStagesError`.
    pub fn new(kind: ListStagesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListStagesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListStagesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListStagesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListStagesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListStagesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListStagesErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListStagesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListStagesErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `ListStagesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStagesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListStagesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListStagesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListStagesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListStagesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListStagesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListStagesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListStagesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListStagesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListStagesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListStagesErrorKind::ValidationException(_inner) => Some(_inner),
            ListStagesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>The service encountered an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One of the parameters in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartGeneratedCodeJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartGeneratedCodeJobError {
    /// Kind of error that occurred.
    pub kind: StartGeneratedCodeJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartGeneratedCodeJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartGeneratedCodeJobErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The service encountered an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request throughput limit was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the parameters in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartGeneratedCodeJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartGeneratedCodeJobErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            StartGeneratedCodeJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StartGeneratedCodeJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartGeneratedCodeJobErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StartGeneratedCodeJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StartGeneratedCodeJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartGeneratedCodeJobError {
    fn code(&self) -> Option<&str> {
        StartGeneratedCodeJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartGeneratedCodeJobError {
    /// Creates a new `StartGeneratedCodeJobError`.
    pub fn new(kind: StartGeneratedCodeJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartGeneratedCodeJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartGeneratedCodeJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartGeneratedCodeJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartGeneratedCodeJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartGeneratedCodeJobErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartGeneratedCodeJobErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `StartGeneratedCodeJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartGeneratedCodeJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StartGeneratedCodeJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartGeneratedCodeJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartGeneratedCodeJobErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartGeneratedCodeJobErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `StartGeneratedCodeJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartGeneratedCodeJobErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for StartGeneratedCodeJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartGeneratedCodeJobErrorKind::AccessDeniedException(_inner) => Some(_inner),
            StartGeneratedCodeJobErrorKind::InternalServerException(_inner) => Some(_inner),
            StartGeneratedCodeJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartGeneratedCodeJobErrorKind::ThrottlingException(_inner) => Some(_inner),
            StartGeneratedCodeJobErrorKind::ValidationException(_inner) => Some(_inner),
            StartGeneratedCodeJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartStageDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartStageDeploymentError {
    /// Kind of error that occurred.
    pub kind: StartStageDeploymentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartStageDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartStageDeploymentErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The resource already exists, or another operation is in progress.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request throughput limit was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the parameters in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartStageDeploymentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartStageDeploymentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            StartStageDeploymentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            StartStageDeploymentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StartStageDeploymentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartStageDeploymentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StartStageDeploymentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StartStageDeploymentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartStageDeploymentError {
    fn code(&self) -> Option<&str> {
        StartStageDeploymentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartStageDeploymentError {
    /// Creates a new `StartStageDeploymentError`.
    pub fn new(kind: StartStageDeploymentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartStageDeploymentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartStageDeploymentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartStageDeploymentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartStageDeploymentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartStageDeploymentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartStageDeploymentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `StartStageDeploymentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartStageDeploymentErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `StartStageDeploymentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartStageDeploymentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StartStageDeploymentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartStageDeploymentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartStageDeploymentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartStageDeploymentErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `StartStageDeploymentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartStageDeploymentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for StartStageDeploymentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartStageDeploymentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            StartStageDeploymentErrorKind::ConflictException(_inner) => Some(_inner),
            StartStageDeploymentErrorKind::InternalServerException(_inner) => Some(_inner),
            StartStageDeploymentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartStageDeploymentErrorKind::ThrottlingException(_inner) => Some(_inner),
            StartStageDeploymentErrorKind::ValidationException(_inner) => Some(_inner),
            StartStageDeploymentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>The service encountered an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One of the parameters in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>The service encountered an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>One of the parameters in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateGame` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateGameError {
    /// Kind of error that occurred.
    pub kind: UpdateGameErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateGame` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateGameErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The service encountered an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request throughput limit was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the parameters in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateGameError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateGameErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateGameErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateGameErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateGameErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateGameErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateGameErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateGameError {
    fn code(&self) -> Option<&str> {
        UpdateGameError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateGameError {
    /// Creates a new `UpdateGameError`.
    pub fn new(kind: UpdateGameErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateGameError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateGameErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateGameError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateGameErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateGameErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateGameErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdateGameErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, UpdateGameErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `UpdateGameErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGameErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGameErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateGameErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateGameErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateGameErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateGameError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateGameErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateGameErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateGameErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateGameErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateGameErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateGameErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateGameConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateGameConfigurationError {
    /// Kind of error that occurred.
    pub kind: UpdateGameConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateGameConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateGameConfigurationErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The service encountered an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request would result in exceeding service quota.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request throughput limit was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the parameters in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateGameConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateGameConfigurationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateGameConfigurationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateGameConfigurationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateGameConfigurationErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            UpdateGameConfigurationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateGameConfigurationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateGameConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateGameConfigurationError {
    fn code(&self) -> Option<&str> {
        UpdateGameConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateGameConfigurationError {
    /// Creates a new `UpdateGameConfigurationError`.
    pub fn new(kind: UpdateGameConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateGameConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateGameConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateGameConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateGameConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateGameConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGameConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGameConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGameConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGameConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGameConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGameConfigurationErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGameConfigurationErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGameConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGameConfigurationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGameConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGameConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateGameConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateGameConfigurationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateGameConfigurationErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateGameConfigurationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateGameConfigurationErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            UpdateGameConfigurationErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateGameConfigurationErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateGameConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateSnapshotError {
    /// Kind of error that occurred.
    pub kind: UpdateSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateSnapshotErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The service encountered an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request throughput limit was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the parameters in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateSnapshotErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateSnapshotErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateSnapshotErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateSnapshotErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateSnapshotErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateSnapshotError {
    fn code(&self) -> Option<&str> {
        UpdateSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateSnapshotError {
    /// Creates a new `UpdateSnapshotError`.
    pub fn new(kind: UpdateSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateSnapshotErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSnapshotErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSnapshotErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSnapshotErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSnapshotErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSnapshotErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSnapshotErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateSnapshotErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateSnapshotErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateSnapshotErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateSnapshotErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateSnapshotErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateSnapshotErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateSnapshotErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateSnapshotErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateStage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateStageError {
    /// Kind of error that occurred.
    pub kind: UpdateStageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateStage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateStageErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The service encountered an internal error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request throughput limit was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the parameters in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateStageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateStageErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateStageErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateStageErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateStageErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateStageErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateStageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateStageError {
    fn code(&self) -> Option<&str> {
        UpdateStageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateStageError {
    /// Creates a new `UpdateStageError`.
    pub fn new(kind: UpdateStageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateStageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateStageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateStageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateStageErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateStageErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateStageErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdateStageErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, UpdateStageErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `UpdateStageErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStageErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStageErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateStageErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateStageErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateStageErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateStageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateStageErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateStageErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateStageErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateStageErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateStageErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateStageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>One of the parameters in the request is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>The request throughput limit was exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>The resource specified in the request does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The service encountered an internal error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>You do not have sufficient access to perform this action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>The request would result in exceeding service quota.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}

/// <p>The resource already exists, or another operation is in progress.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}
