// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for GameSparks
///
/// Client for invoking operations on GameSparks. Each operation on GameSparks is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_gamesparks::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_gamesparks::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_gamesparks::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateGame`](crate::client::fluent_builders::CreateGame) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`game_name(impl Into<String>)`](crate::client::fluent_builders::CreateGame::game_name) / [`set_game_name(Option<String>)`](crate::client::fluent_builders::CreateGame::set_game_name): <p>The name of the game.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateGame::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateGame::set_description): <p>The description of the game.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateGame::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateGame::set_client_token): <p> A client-defined token. With an active client token in the request, this action is idempotent. </p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateGame::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateGame::set_tags): <p>The list of tags to apply to the game.</p>
    /// - On success, responds with [`CreateGameOutput`](crate::output::CreateGameOutput) with field(s):
    ///   - [`game(Option<GameDetails>)`](crate::output::CreateGameOutput::game): <p>Details about the game that was created.</p>
    /// - On failure, responds with [`SdkError<CreateGameError>`](crate::error::CreateGameError)
    pub fn create_game(&self) -> fluent_builders::CreateGame {
        fluent_builders::CreateGame::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSnapshot`](crate::client::fluent_builders::CreateSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`game_name(impl Into<String>)`](crate::client::fluent_builders::CreateSnapshot::game_name) / [`set_game_name(Option<String>)`](crate::client::fluent_builders::CreateSnapshot::set_game_name): <p>The name of the game.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateSnapshot::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateSnapshot::set_description): <p>The description of the snapshot.</p>
    /// - On success, responds with [`CreateSnapshotOutput`](crate::output::CreateSnapshotOutput) with field(s):
    ///   - [`snapshot(Option<SnapshotDetails>)`](crate::output::CreateSnapshotOutput::snapshot): <p>Properties that provide details of the created snapshot.</p>
    /// - On failure, responds with [`SdkError<CreateSnapshotError>`](crate::error::CreateSnapshotError)
    pub fn create_snapshot(&self) -> fluent_builders::CreateSnapshot {
        fluent_builders::CreateSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateStage`](crate::client::fluent_builders::CreateStage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`game_name(impl Into<String>)`](crate::client::fluent_builders::CreateStage::game_name) / [`set_game_name(Option<String>)`](crate::client::fluent_builders::CreateStage::set_game_name): <p>The name of the game.</p>
    ///   - [`stage_name(impl Into<String>)`](crate::client::fluent_builders::CreateStage::stage_name) / [`set_stage_name(Option<String>)`](crate::client::fluent_builders::CreateStage::set_stage_name): <p>The name of the stage.</p>
    ///   - [`role(impl Into<String>)`](crate::client::fluent_builders::CreateStage::role) / [`set_role(Option<String>)`](crate::client::fluent_builders::CreateStage::set_role): <p> The Amazon Resource Name (ARN) of the role to run the game with. This role can be a game-defined role or the default role that GameSparks created. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateStage::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateStage::set_description): <p>The description of the stage.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateStage::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateStage::set_client_token): <p> A client-defined token. With an active client token in the request, this action is idempotent. </p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateStage::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateStage::set_tags): <p>The list of tags to apply to the stage.</p>
    /// - On success, responds with [`CreateStageOutput`](crate::output::CreateStageOutput) with field(s):
    ///   - [`stage(Option<StageDetails>)`](crate::output::CreateStageOutput::stage): <p>Properties that describe the stage.</p>
    /// - On failure, responds with [`SdkError<CreateStageError>`](crate::error::CreateStageError)
    pub fn create_stage(&self) -> fluent_builders::CreateStage {
        fluent_builders::CreateStage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteGame`](crate::client::fluent_builders::DeleteGame) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`game_name(impl Into<String>)`](crate::client::fluent_builders::DeleteGame::game_name) / [`set_game_name(Option<String>)`](crate::client::fluent_builders::DeleteGame::set_game_name): <p>The name of the game to delete.</p>
    /// - On success, responds with [`DeleteGameOutput`](crate::output::DeleteGameOutput)

    /// - On failure, responds with [`SdkError<DeleteGameError>`](crate::error::DeleteGameError)
    pub fn delete_game(&self) -> fluent_builders::DeleteGame {
        fluent_builders::DeleteGame::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteStage`](crate::client::fluent_builders::DeleteStage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`game_name(impl Into<String>)`](crate::client::fluent_builders::DeleteStage::game_name) / [`set_game_name(Option<String>)`](crate::client::fluent_builders::DeleteStage::set_game_name): <p>The name of the game.</p>
    ///   - [`stage_name(impl Into<String>)`](crate::client::fluent_builders::DeleteStage::stage_name) / [`set_stage_name(Option<String>)`](crate::client::fluent_builders::DeleteStage::set_stage_name): <p>The name of the stage to delete.</p>
    /// - On success, responds with [`DeleteStageOutput`](crate::output::DeleteStageOutput)

    /// - On failure, responds with [`SdkError<DeleteStageError>`](crate::error::DeleteStageError)
    pub fn delete_stage(&self) -> fluent_builders::DeleteStage {
        fluent_builders::DeleteStage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisconnectPlayer`](crate::client::fluent_builders::DisconnectPlayer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`player_id(impl Into<String>)`](crate::client::fluent_builders::DisconnectPlayer::player_id) / [`set_player_id(Option<String>)`](crate::client::fluent_builders::DisconnectPlayer::set_player_id): <p>The unique identifier representing a player.</p>
    ///   - [`game_name(impl Into<String>)`](crate::client::fluent_builders::DisconnectPlayer::game_name) / [`set_game_name(Option<String>)`](crate::client::fluent_builders::DisconnectPlayer::set_game_name): <p>The name of the game.</p>
    ///   - [`stage_name(impl Into<String>)`](crate::client::fluent_builders::DisconnectPlayer::stage_name) / [`set_stage_name(Option<String>)`](crate::client::fluent_builders::DisconnectPlayer::set_stage_name): <p>The name of the stage.</p>
    /// - On success, responds with [`DisconnectPlayerOutput`](crate::output::DisconnectPlayerOutput) with field(s):
    ///   - [`disconnect_successes(Option<Vec<String>>)`](crate::output::DisconnectPlayerOutput::disconnect_successes): <p>The list of the connection ids that were disconnected.</p>
    ///   - [`disconnect_failures(Option<Vec<String>>)`](crate::output::DisconnectPlayerOutput::disconnect_failures): <p>The list of the connection ids that could not be disconnected.</p>
    /// - On failure, responds with [`SdkError<DisconnectPlayerError>`](crate::error::DisconnectPlayerError)
    pub fn disconnect_player(&self) -> fluent_builders::DisconnectPlayer {
        fluent_builders::DisconnectPlayer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ExportSnapshot`](crate::client::fluent_builders::ExportSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`game_name(impl Into<String>)`](crate::client::fluent_builders::ExportSnapshot::game_name) / [`set_game_name(Option<String>)`](crate::client::fluent_builders::ExportSnapshot::set_game_name): <p>The name of the game.</p>
    ///   - [`snapshot_id(impl Into<String>)`](crate::client::fluent_builders::ExportSnapshot::snapshot_id) / [`set_snapshot_id(Option<String>)`](crate::client::fluent_builders::ExportSnapshot::set_snapshot_id): <p>The identifier of the snapshot to export.</p>
    /// - On success, responds with [`ExportSnapshotOutput`](crate::output::ExportSnapshotOutput) with field(s):
    ///   - [`s3_url(Option<String>)`](crate::output::ExportSnapshotOutput::s3_url): <p>The presigned URL for the snapshot data.</p>  <p> This URL will be available for 10 minutes, and can be used to download the snapshot content. If the URL expires, a new one can be requested using the same operation. </p>
    /// - On failure, responds with [`SdkError<ExportSnapshotError>`](crate::error::ExportSnapshotError)
    pub fn export_snapshot(&self) -> fluent_builders::ExportSnapshot {
        fluent_builders::ExportSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetExtension`](crate::client::fluent_builders::GetExtension) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::GetExtension::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::GetExtension::set_namespace): <p>The namespace (qualifier) of the extension.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetExtension::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetExtension::set_name): <p>The name of the extension.</p>
    /// - On success, responds with [`GetExtensionOutput`](crate::output::GetExtensionOutput) with field(s):
    ///   - [`extension(Option<ExtensionDetails>)`](crate::output::GetExtensionOutput::extension): <p>Details about the extension.</p>
    /// - On failure, responds with [`SdkError<GetExtensionError>`](crate::error::GetExtensionError)
    pub fn get_extension(&self) -> fluent_builders::GetExtension {
        fluent_builders::GetExtension::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetExtensionVersion`](crate::client::fluent_builders::GetExtensionVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::GetExtensionVersion::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::GetExtensionVersion::set_namespace): <p>The namespace (qualifier) of the extension.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetExtensionVersion::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetExtensionVersion::set_name): <p>The name of the extension.</p>
    ///   - [`extension_version(impl Into<String>)`](crate::client::fluent_builders::GetExtensionVersion::extension_version) / [`set_extension_version(Option<String>)`](crate::client::fluent_builders::GetExtensionVersion::set_extension_version): <p>The version of the extension.</p>
    /// - On success, responds with [`GetExtensionVersionOutput`](crate::output::GetExtensionVersionOutput) with field(s):
    ///   - [`extension_version(Option<ExtensionVersionDetails>)`](crate::output::GetExtensionVersionOutput::extension_version): <p>The version of the extension.</p>
    /// - On failure, responds with [`SdkError<GetExtensionVersionError>`](crate::error::GetExtensionVersionError)
    pub fn get_extension_version(&self) -> fluent_builders::GetExtensionVersion {
        fluent_builders::GetExtensionVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetGame`](crate::client::fluent_builders::GetGame) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`game_name(impl Into<String>)`](crate::client::fluent_builders::GetGame::game_name) / [`set_game_name(Option<String>)`](crate::client::fluent_builders::GetGame::set_game_name): <p>The name of the game.</p>
    /// - On success, responds with [`GetGameOutput`](crate::output::GetGameOutput) with field(s):
    ///   - [`game(Option<GameDetails>)`](crate::output::GetGameOutput::game): <p>The details of the game.</p>
    /// - On failure, responds with [`SdkError<GetGameError>`](crate::error::GetGameError)
    pub fn get_game(&self) -> fluent_builders::GetGame {
        fluent_builders::GetGame::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetGameConfiguration`](crate::client::fluent_builders::GetGameConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`game_name(impl Into<String>)`](crate::client::fluent_builders::GetGameConfiguration::game_name) / [`set_game_name(Option<String>)`](crate::client::fluent_builders::GetGameConfiguration::set_game_name): <p>The name of the game.</p>
    ///   - [`sections(Vec<String>)`](crate::client::fluent_builders::GetGameConfiguration::sections) / [`set_sections(Option<Vec<String>>)`](crate::client::fluent_builders::GetGameConfiguration::set_sections): <p>The list of sections to return.</p>
    /// - On success, responds with [`GetGameConfigurationOutput`](crate::output::GetGameConfigurationOutput) with field(s):
    ///   - [`game_configuration(Option<GameConfigurationDetails>)`](crate::output::GetGameConfigurationOutput::game_configuration): <p>Details about the game configuration.</p>
    /// - On failure, responds with [`SdkError<GetGameConfigurationError>`](crate::error::GetGameConfigurationError)
    pub fn get_game_configuration(&self) -> fluent_builders::GetGameConfiguration {
        fluent_builders::GetGameConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetGeneratedCodeJob`](crate::client::fluent_builders::GetGeneratedCodeJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`game_name(impl Into<String>)`](crate::client::fluent_builders::GetGeneratedCodeJob::game_name) / [`set_game_name(Option<String>)`](crate::client::fluent_builders::GetGeneratedCodeJob::set_game_name): <p>The name of the game.</p>
    ///   - [`snapshot_id(impl Into<String>)`](crate::client::fluent_builders::GetGeneratedCodeJob::snapshot_id) / [`set_snapshot_id(Option<String>)`](crate::client::fluent_builders::GetGeneratedCodeJob::set_snapshot_id): <p>The identifier of the snapshot for the code generation job.</p>
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::GetGeneratedCodeJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::GetGeneratedCodeJob::set_job_id): <p>The identifier of the code generation job.</p>
    /// - On success, responds with [`GetGeneratedCodeJobOutput`](crate::output::GetGeneratedCodeJobOutput) with field(s):
    ///   - [`generated_code_job(Option<GeneratedCodeJobDetails>)`](crate::output::GetGeneratedCodeJobOutput::generated_code_job): <p>Details about the generated code job.</p>
    /// - On failure, responds with [`SdkError<GetGeneratedCodeJobError>`](crate::error::GetGeneratedCodeJobError)
    pub fn get_generated_code_job(&self) -> fluent_builders::GetGeneratedCodeJob {
        fluent_builders::GetGeneratedCodeJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPlayerConnectionStatus`](crate::client::fluent_builders::GetPlayerConnectionStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`player_id(impl Into<String>)`](crate::client::fluent_builders::GetPlayerConnectionStatus::player_id) / [`set_player_id(Option<String>)`](crate::client::fluent_builders::GetPlayerConnectionStatus::set_player_id): <p>The unique identifier representing a player.</p>
    ///   - [`game_name(impl Into<String>)`](crate::client::fluent_builders::GetPlayerConnectionStatus::game_name) / [`set_game_name(Option<String>)`](crate::client::fluent_builders::GetPlayerConnectionStatus::set_game_name): <p>The name of the game.</p>
    ///   - [`stage_name(impl Into<String>)`](crate::client::fluent_builders::GetPlayerConnectionStatus::stage_name) / [`set_stage_name(Option<String>)`](crate::client::fluent_builders::GetPlayerConnectionStatus::set_stage_name): <p>The name of the stage.</p>
    /// - On success, responds with [`GetPlayerConnectionStatusOutput`](crate::output::GetPlayerConnectionStatusOutput) with field(s):
    ///   - [`connections(Option<Vec<Connection>>)`](crate::output::GetPlayerConnectionStatusOutput::connections): <p>The list of connection ids, one for each connection in use by the player.</p>
    /// - On failure, responds with [`SdkError<GetPlayerConnectionStatusError>`](crate::error::GetPlayerConnectionStatusError)
    pub fn get_player_connection_status(&self) -> fluent_builders::GetPlayerConnectionStatus {
        fluent_builders::GetPlayerConnectionStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSnapshot`](crate::client::fluent_builders::GetSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`game_name(impl Into<String>)`](crate::client::fluent_builders::GetSnapshot::game_name) / [`set_game_name(Option<String>)`](crate::client::fluent_builders::GetSnapshot::set_game_name): <p>The name of the game.</p>
    ///   - [`snapshot_id(impl Into<String>)`](crate::client::fluent_builders::GetSnapshot::snapshot_id) / [`set_snapshot_id(Option<String>)`](crate::client::fluent_builders::GetSnapshot::set_snapshot_id): <p>The identifier of the snapshot.</p>
    ///   - [`sections(Vec<String>)`](crate::client::fluent_builders::GetSnapshot::sections) / [`set_sections(Option<Vec<String>>)`](crate::client::fluent_builders::GetSnapshot::set_sections): <p>The list of game configuration sections to be described.</p>
    /// - On success, responds with [`GetSnapshotOutput`](crate::output::GetSnapshotOutput) with field(s):
    ///   - [`snapshot(Option<SnapshotDetails>)`](crate::output::GetSnapshotOutput::snapshot): <p>Properties that provide details of the snapshot.</p>
    /// - On failure, responds with [`SdkError<GetSnapshotError>`](crate::error::GetSnapshotError)
    pub fn get_snapshot(&self) -> fluent_builders::GetSnapshot {
        fluent_builders::GetSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetStage`](crate::client::fluent_builders::GetStage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`game_name(impl Into<String>)`](crate::client::fluent_builders::GetStage::game_name) / [`set_game_name(Option<String>)`](crate::client::fluent_builders::GetStage::set_game_name): <p>The name of the game.</p>
    ///   - [`stage_name(impl Into<String>)`](crate::client::fluent_builders::GetStage::stage_name) / [`set_stage_name(Option<String>)`](crate::client::fluent_builders::GetStage::set_stage_name): <p>The name of the stage.</p>
    /// - On success, responds with [`GetStageOutput`](crate::output::GetStageOutput) with field(s):
    ///   - [`stage(Option<StageDetails>)`](crate::output::GetStageOutput::stage): <p>Properties that provide details of the stage.</p>
    /// - On failure, responds with [`SdkError<GetStageError>`](crate::error::GetStageError)
    pub fn get_stage(&self) -> fluent_builders::GetStage {
        fluent_builders::GetStage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetStageDeployment`](crate::client::fluent_builders::GetStageDeployment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`game_name(impl Into<String>)`](crate::client::fluent_builders::GetStageDeployment::game_name) / [`set_game_name(Option<String>)`](crate::client::fluent_builders::GetStageDeployment::set_game_name): <p>The name of the game.</p>
    ///   - [`stage_name(impl Into<String>)`](crate::client::fluent_builders::GetStageDeployment::stage_name) / [`set_stage_name(Option<String>)`](crate::client::fluent_builders::GetStageDeployment::set_stage_name): <p>The name of the stage.</p>
    ///   - [`deployment_id(impl Into<String>)`](crate::client::fluent_builders::GetStageDeployment::deployment_id) / [`set_deployment_id(Option<String>)`](crate::client::fluent_builders::GetStageDeployment::set_deployment_id): <p> The identifier of the stage deployment. <code>StartStageDeployment</code> returns the identifier that you use here. </p>
    /// - On success, responds with [`GetStageDeploymentOutput`](crate::output::GetStageDeploymentOutput) with field(s):
    ///   - [`stage_deployment(Option<StageDeploymentDetails>)`](crate::output::GetStageDeploymentOutput::stage_deployment): <p>Properties that provide details of the stage deployment.</p>
    /// - On failure, responds with [`SdkError<GetStageDeploymentError>`](crate::error::GetStageDeploymentError)
    pub fn get_stage_deployment(&self) -> fluent_builders::GetStageDeployment {
        fluent_builders::GetStageDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ImportGameConfiguration`](crate::client::fluent_builders::ImportGameConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`game_name(impl Into<String>)`](crate::client::fluent_builders::ImportGameConfiguration::game_name) / [`set_game_name(Option<String>)`](crate::client::fluent_builders::ImportGameConfiguration::set_game_name): <p>The name of the game.</p>
    ///   - [`import_source(ImportGameConfigurationSource)`](crate::client::fluent_builders::ImportGameConfiguration::import_source) / [`set_import_source(Option<ImportGameConfigurationSource>)`](crate::client::fluent_builders::ImportGameConfiguration::set_import_source): <p>The source used to import configuration sections.</p>
    /// - On success, responds with [`ImportGameConfigurationOutput`](crate::output::ImportGameConfigurationOutput) with field(s):
    ///   - [`game_configuration(Option<GameConfigurationDetails>)`](crate::output::ImportGameConfigurationOutput::game_configuration): <p>Details about the game configuration.</p>
    /// - On failure, responds with [`SdkError<ImportGameConfigurationError>`](crate::error::ImportGameConfigurationError)
    pub fn import_game_configuration(&self) -> fluent_builders::ImportGameConfiguration {
        fluent_builders::ImportGameConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListExtensions`](crate::client::fluent_builders::ListExtensions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListExtensions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListExtensions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListExtensions::set_max_results): <p>The maximum number of results to return.</p>  <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListExtensions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListExtensions::set_next_token): <p>The token that indicates the start of the next sequential page of results.</p>  <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
    /// - On success, responds with [`ListExtensionsOutput`](crate::output::ListExtensionsOutput) with field(s):
    ///   - [`extensions(Option<Vec<ExtensionDetails>>)`](crate::output::ListExtensionsOutput::extensions): <p>The list of extensions.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListExtensionsOutput::next_token): <p>The token that indicates the start of the next sequential page of results.</p>  <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
    /// - On failure, responds with [`SdkError<ListExtensionsError>`](crate::error::ListExtensionsError)
    pub fn list_extensions(&self) -> fluent_builders::ListExtensions {
        fluent_builders::ListExtensions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListExtensionVersions`](crate::client::fluent_builders::ListExtensionVersions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListExtensionVersions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::ListExtensionVersions::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::ListExtensionVersions::set_namespace): <p>The namespace (qualifier) of the extension.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::ListExtensionVersions::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::ListExtensionVersions::set_name): <p>The name of the extension.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListExtensionVersions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListExtensionVersions::set_next_token): <p>The token that indicates the start of the next sequential page of results.</p>  <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListExtensionVersions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListExtensionVersions::set_max_results): <p>The maximum number of results to return.</p>  <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
    /// - On success, responds with [`ListExtensionVersionsOutput`](crate::output::ListExtensionVersionsOutput) with field(s):
    ///   - [`extension_versions(Option<Vec<ExtensionVersionDetails>>)`](crate::output::ListExtensionVersionsOutput::extension_versions): <p>The list of extension versions.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListExtensionVersionsOutput::next_token): <p>The token that indicates the start of the next sequential page of results.</p>  <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
    /// - On failure, responds with [`SdkError<ListExtensionVersionsError>`](crate::error::ListExtensionVersionsError)
    pub fn list_extension_versions(&self) -> fluent_builders::ListExtensionVersions {
        fluent_builders::ListExtensionVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListGames`](crate::client::fluent_builders::ListGames) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListGames::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListGames::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListGames::set_max_results): <p>The maximum number of results to return.</p>  <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListGames::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListGames::set_next_token): <p>The token that indicates the start of the next sequential page of results.</p>  <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
    /// - On success, responds with [`ListGamesOutput`](crate::output::ListGamesOutput) with field(s):
    ///   - [`games(Option<Vec<GameSummary>>)`](crate::output::ListGamesOutput::games): <p>The list of games.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListGamesOutput::next_token): <p>The token that indicates the start of the next sequential page of results.</p>  <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
    /// - On failure, responds with [`SdkError<ListGamesError>`](crate::error::ListGamesError)
    pub fn list_games(&self) -> fluent_builders::ListGames {
        fluent_builders::ListGames::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListGeneratedCodeJobs`](crate::client::fluent_builders::ListGeneratedCodeJobs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListGeneratedCodeJobs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`game_name(impl Into<String>)`](crate::client::fluent_builders::ListGeneratedCodeJobs::game_name) / [`set_game_name(Option<String>)`](crate::client::fluent_builders::ListGeneratedCodeJobs::set_game_name): <p>The name of the game.</p>
    ///   - [`snapshot_id(impl Into<String>)`](crate::client::fluent_builders::ListGeneratedCodeJobs::snapshot_id) / [`set_snapshot_id(Option<String>)`](crate::client::fluent_builders::ListGeneratedCodeJobs::set_snapshot_id): <p>The identifier of the snapshot.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListGeneratedCodeJobs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListGeneratedCodeJobs::set_max_results): <p>The maximum number of results to return.</p>  <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListGeneratedCodeJobs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListGeneratedCodeJobs::set_next_token): <p>The token that indicates the start of the next sequential page of results.</p>  <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
    /// - On success, responds with [`ListGeneratedCodeJobsOutput`](crate::output::ListGeneratedCodeJobsOutput) with field(s):
    ///   - [`generated_code_jobs(Option<Vec<GeneratedCodeJobDetails>>)`](crate::output::ListGeneratedCodeJobsOutput::generated_code_jobs): <p>The list of generated code jobs.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListGeneratedCodeJobsOutput::next_token): <p>The token that indicates the start of the next sequential page of results.</p>  <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
    /// - On failure, responds with [`SdkError<ListGeneratedCodeJobsError>`](crate::error::ListGeneratedCodeJobsError)
    pub fn list_generated_code_jobs(&self) -> fluent_builders::ListGeneratedCodeJobs {
        fluent_builders::ListGeneratedCodeJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSnapshots`](crate::client::fluent_builders::ListSnapshots) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListSnapshots::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`game_name(impl Into<String>)`](crate::client::fluent_builders::ListSnapshots::game_name) / [`set_game_name(Option<String>)`](crate::client::fluent_builders::ListSnapshots::set_game_name): <p>The name of the game.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListSnapshots::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListSnapshots::set_max_results): <p>The maximum number of results to return.</p>  <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListSnapshots::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListSnapshots::set_next_token): <p>The token that indicates the start of the next sequential page of results.</p>  <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
    /// - On success, responds with [`ListSnapshotsOutput`](crate::output::ListSnapshotsOutput) with field(s):
    ///   - [`snapshots(Option<Vec<SnapshotSummary>>)`](crate::output::ListSnapshotsOutput::snapshots): <p> A list of snapshot summaries. You can use the returned snapshot IDs in the <code>UpdateSnapshot</code> and <code>GetSnapshot</code> operations. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListSnapshotsOutput::next_token): <p>The token that indicates the start of the next sequential page of results.</p>  <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
    /// - On failure, responds with [`SdkError<ListSnapshotsError>`](crate::error::ListSnapshotsError)
    pub fn list_snapshots(&self) -> fluent_builders::ListSnapshots {
        fluent_builders::ListSnapshots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListStageDeployments`](crate::client::fluent_builders::ListStageDeployments) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListStageDeployments::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`game_name(impl Into<String>)`](crate::client::fluent_builders::ListStageDeployments::game_name) / [`set_game_name(Option<String>)`](crate::client::fluent_builders::ListStageDeployments::set_game_name): <p>The name of the game.</p>
    ///   - [`stage_name(impl Into<String>)`](crate::client::fluent_builders::ListStageDeployments::stage_name) / [`set_stage_name(Option<String>)`](crate::client::fluent_builders::ListStageDeployments::set_stage_name): <p>The name of the stage.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListStageDeployments::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListStageDeployments::set_next_token): <p>The token that indicates the start of the next sequential page of results.</p>  <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListStageDeployments::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListStageDeployments::set_max_results): <p>The maximum number of results to return.</p>  <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
    /// - On success, responds with [`ListStageDeploymentsOutput`](crate::output::ListStageDeploymentsOutput) with field(s):
    ///   - [`stage_deployments(Option<Vec<StageDeploymentSummary>>)`](crate::output::ListStageDeploymentsOutput::stage_deployments): <p> A list of stage deployment summaries. You can use the deployment IDs in the <code>UpdateStageDeployment</code> and <code>GetStageDeployment</code> actions. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListStageDeploymentsOutput::next_token): <p>The token that indicates the start of the next sequential page of results.</p>  <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
    /// - On failure, responds with [`SdkError<ListStageDeploymentsError>`](crate::error::ListStageDeploymentsError)
    pub fn list_stage_deployments(&self) -> fluent_builders::ListStageDeployments {
        fluent_builders::ListStageDeployments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListStages`](crate::client::fluent_builders::ListStages) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListStages::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`game_name(impl Into<String>)`](crate::client::fluent_builders::ListStages::game_name) / [`set_game_name(Option<String>)`](crate::client::fluent_builders::ListStages::set_game_name): <p>The name of the game.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListStages::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListStages::set_max_results): <p>The maximum number of results to return.</p>  <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListStages::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListStages::set_next_token): <p>The token that indicates the start of the next sequential page of results.</p>  <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
    /// - On success, responds with [`ListStagesOutput`](crate::output::ListStagesOutput) with field(s):
    ///   - [`stages(Option<Vec<StageSummary>>)`](crate::output::ListStagesOutput::stages): <p> A list of stage summaries. You can use the stage names in the <code>UpdateStage</code> and <code>GetStage</code> actions. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListStagesOutput::next_token): <p>The token that indicates the start of the next sequential page of results.</p>  <p> Use this value when making the next call to this operation to continue where the last one finished. </p>
    /// - On failure, responds with [`SdkError<ListStagesError>`](crate::error::ListStagesError)
    pub fn list_stages(&self) -> fluent_builders::ListStages {
        fluent_builders::ListStages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the GameSparks resource.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tags associated with the resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartGeneratedCodeJob`](crate::client::fluent_builders::StartGeneratedCodeJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`game_name(impl Into<String>)`](crate::client::fluent_builders::StartGeneratedCodeJob::game_name) / [`set_game_name(Option<String>)`](crate::client::fluent_builders::StartGeneratedCodeJob::set_game_name): <p>The name of the game.</p>
    ///   - [`snapshot_id(impl Into<String>)`](crate::client::fluent_builders::StartGeneratedCodeJob::snapshot_id) / [`set_snapshot_id(Option<String>)`](crate::client::fluent_builders::StartGeneratedCodeJob::set_snapshot_id): <p>The identifier of the snapshot for which to generate code.</p>
    ///   - [`generator(Generator)`](crate::client::fluent_builders::StartGeneratedCodeJob::generator) / [`set_generator(Option<Generator>)`](crate::client::fluent_builders::StartGeneratedCodeJob::set_generator): <p>Properties of the generator to use for the job.</p>
    /// - On success, responds with [`StartGeneratedCodeJobOutput`](crate::output::StartGeneratedCodeJobOutput) with field(s):
    ///   - [`generated_code_job_id(Option<String>)`](crate::output::StartGeneratedCodeJobOutput::generated_code_job_id): <p> The identifier of the code generation job. You can use this identifier in the <code>GetGeneratedCodeJob</code> operation. </p>
    /// - On failure, responds with [`SdkError<StartGeneratedCodeJobError>`](crate::error::StartGeneratedCodeJobError)
    pub fn start_generated_code_job(&self) -> fluent_builders::StartGeneratedCodeJob {
        fluent_builders::StartGeneratedCodeJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartStageDeployment`](crate::client::fluent_builders::StartStageDeployment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`game_name(impl Into<String>)`](crate::client::fluent_builders::StartStageDeployment::game_name) / [`set_game_name(Option<String>)`](crate::client::fluent_builders::StartStageDeployment::set_game_name): <p>The name of the game.</p>
    ///   - [`stage_name(impl Into<String>)`](crate::client::fluent_builders::StartStageDeployment::stage_name) / [`set_stage_name(Option<String>)`](crate::client::fluent_builders::StartStageDeployment::set_stage_name): <p>The name of the stage to deploy the snapshot onto.</p>
    ///   - [`snapshot_id(impl Into<String>)`](crate::client::fluent_builders::StartStageDeployment::snapshot_id) / [`set_snapshot_id(Option<String>)`](crate::client::fluent_builders::StartStageDeployment::set_snapshot_id): <p>The identifier of the snapshot to deploy.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::StartStageDeployment::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::StartStageDeployment::set_client_token): <p> A client-defined token. With an active client token in the request, this action is idempotent. </p>
    /// - On success, responds with [`StartStageDeploymentOutput`](crate::output::StartStageDeploymentOutput) with field(s):
    ///   - [`stage_deployment(Option<StageDeploymentDetails>)`](crate::output::StartStageDeploymentOutput::stage_deployment): <p>Properties that describe the stage deployment.</p>
    /// - On failure, responds with [`SdkError<StartStageDeploymentError>`](crate::error::StartStageDeploymentError)
    pub fn start_stage_deployment(&self) -> fluent_builders::StartStageDeployment {
        fluent_builders::StartStageDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource to add the tags to.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags to add to the resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource to remove the tags from.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The keys of the tags to remove.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateGame`](crate::client::fluent_builders::UpdateGame) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`game_name(impl Into<String>)`](crate::client::fluent_builders::UpdateGame::game_name) / [`set_game_name(Option<String>)`](crate::client::fluent_builders::UpdateGame::set_game_name): <p>The name of the game.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateGame::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateGame::set_description): <p>The description of the game.</p>
    /// - On success, responds with [`UpdateGameOutput`](crate::output::UpdateGameOutput) with field(s):
    ///   - [`game(Option<GameDetails>)`](crate::output::UpdateGameOutput::game): <p>The details of the game.</p>
    /// - On failure, responds with [`SdkError<UpdateGameError>`](crate::error::UpdateGameError)
    pub fn update_game(&self) -> fluent_builders::UpdateGame {
        fluent_builders::UpdateGame::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateGameConfiguration`](crate::client::fluent_builders::UpdateGameConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`game_name(impl Into<String>)`](crate::client::fluent_builders::UpdateGameConfiguration::game_name) / [`set_game_name(Option<String>)`](crate::client::fluent_builders::UpdateGameConfiguration::set_game_name): <p>The name of the game.</p>
    ///   - [`modifications(Vec<SectionModification>)`](crate::client::fluent_builders::UpdateGameConfiguration::modifications) / [`set_modifications(Option<Vec<SectionModification>>)`](crate::client::fluent_builders::UpdateGameConfiguration::set_modifications): <p>The list of modifications to make.</p>
    /// - On success, responds with [`UpdateGameConfigurationOutput`](crate::output::UpdateGameConfigurationOutput) with field(s):
    ///   - [`game_configuration(Option<GameConfigurationDetails>)`](crate::output::UpdateGameConfigurationOutput::game_configuration): <p>Details about the game configuration.</p>
    /// - On failure, responds with [`SdkError<UpdateGameConfigurationError>`](crate::error::UpdateGameConfigurationError)
    pub fn update_game_configuration(&self) -> fluent_builders::UpdateGameConfiguration {
        fluent_builders::UpdateGameConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSnapshot`](crate::client::fluent_builders::UpdateSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`game_name(impl Into<String>)`](crate::client::fluent_builders::UpdateSnapshot::game_name) / [`set_game_name(Option<String>)`](crate::client::fluent_builders::UpdateSnapshot::set_game_name): <p>The name of the game.</p>
    ///   - [`snapshot_id(impl Into<String>)`](crate::client::fluent_builders::UpdateSnapshot::snapshot_id) / [`set_snapshot_id(Option<String>)`](crate::client::fluent_builders::UpdateSnapshot::set_snapshot_id): <p>The identifier of the snapshot.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateSnapshot::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateSnapshot::set_description): <p>The description of the snapshot.</p>
    /// - On success, responds with [`UpdateSnapshotOutput`](crate::output::UpdateSnapshotOutput) with field(s):
    ///   - [`snapshot(Option<SnapshotDetails>)`](crate::output::UpdateSnapshotOutput::snapshot): <p>Properties that provide details of the updated snapshot.</p>
    /// - On failure, responds with [`SdkError<UpdateSnapshotError>`](crate::error::UpdateSnapshotError)
    pub fn update_snapshot(&self) -> fluent_builders::UpdateSnapshot {
        fluent_builders::UpdateSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateStage`](crate::client::fluent_builders::UpdateStage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`game_name(impl Into<String>)`](crate::client::fluent_builders::UpdateStage::game_name) / [`set_game_name(Option<String>)`](crate::client::fluent_builders::UpdateStage::set_game_name): <p>The name of the game.</p>
    ///   - [`stage_name(impl Into<String>)`](crate::client::fluent_builders::UpdateStage::stage_name) / [`set_stage_name(Option<String>)`](crate::client::fluent_builders::UpdateStage::set_stage_name): <p>The name of the stage.</p>
    ///   - [`role(impl Into<String>)`](crate::client::fluent_builders::UpdateStage::role) / [`set_role(Option<String>)`](crate::client::fluent_builders::UpdateStage::set_role): <p>The Amazon Resource Name (ARN) of the role to use for the game snapshots deployed to this stage.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateStage::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateStage::set_description): <p>The description of the stage.</p>
    /// - On success, responds with [`UpdateStageOutput`](crate::output::UpdateStageOutput) with field(s):
    ///   - [`stage(Option<StageDetails>)`](crate::output::UpdateStageOutput::stage): <p>Properties that provide details of the updated stage.</p>
    /// - On failure, responds with [`SdkError<UpdateStageError>`](crate::error::UpdateStageError)
    pub fn update_stage(&self) -> fluent_builders::UpdateStage {
        fluent_builders::UpdateStage::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateGame`.
    ///
    /// <p> Creates a new game with an empty configuration. After creating your game, you can update the configuration using <code>UpdateGameConfiguration</code> or <code>ImportGameConfiguration</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateGame {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_game_input::Builder,
    }
    impl CreateGame {
        /// Creates a new `CreateGame`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGameOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGameError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.game_name(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_game_name(input);
            self
        }
        /// <p>The description of the game.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the game.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> A client-defined token. With an active client token in the request, this action is idempotent. </p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p> A client-defined token. With an active client token in the request, this action is idempotent. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags to apply to the game.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The list of tags to apply to the game.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSnapshot`.
    ///
    /// <p>Creates a snapshot of the game configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSnapshot {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_snapshot_input::Builder,
    }
    impl CreateSnapshot {
        /// Creates a new `CreateSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSnapshotError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.game_name(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_game_name(input);
            self
        }
        /// <p>The description of the snapshot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the snapshot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStage`.
    ///
    /// <p>Creates a new stage for stage-by-stage game development and deployment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateStage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_stage_input::Builder,
    }
    impl CreateStage {
        /// Creates a new `CreateStage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStageOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.game_name(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_game_name(input);
            self
        }
        /// <p>The name of the stage.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>The name of the stage.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the role to run the game with. This role can be a game-defined role or the default role that GameSparks created. </p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the role to run the game with. This role can be a game-defined role or the default role that GameSparks created. </p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role(input);
            self
        }
        /// <p>The description of the stage.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the stage.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> A client-defined token. With an active client token in the request, this action is idempotent. </p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p> A client-defined token. With an active client token in the request, this action is idempotent. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags to apply to the stage.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The list of tags to apply to the stage.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGame`.
    ///
    /// <p>Deletes a game.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteGame {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_game_input::Builder,
    }
    impl DeleteGame {
        /// Creates a new `DeleteGame`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGameOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGameError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the game to delete.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.game_name(input.into());
            self
        }
        /// <p>The name of the game to delete.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_game_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStage`.
    ///
    /// <p>Deletes a stage from a game, along with the associated game runtime.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteStage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_stage_input::Builder,
    }
    impl DeleteStage {
        /// Creates a new `DeleteStage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStageOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.game_name(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_game_name(input);
            self
        }
        /// <p>The name of the stage to delete.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>The name of the stage to delete.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisconnectPlayer`.
    ///
    /// <p>Disconnects a player from the game runtime.</p>
    /// <p> If a player has multiple connections, this operation attempts to close all of them. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisconnectPlayer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disconnect_player_input::Builder,
    }
    impl DisconnectPlayer {
        /// Creates a new `DisconnectPlayer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisconnectPlayerOutput,
            aws_smithy_http::result::SdkError<crate::error::DisconnectPlayerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier representing a player.</p>
        pub fn player_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.player_id(input.into());
            self
        }
        /// <p>The unique identifier representing a player.</p>
        pub fn set_player_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_player_id(input);
            self
        }
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.game_name(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_game_name(input);
            self
        }
        /// <p>The name of the stage.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>The name of the stage.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExportSnapshot`.
    ///
    /// <p>Exports a game configuration snapshot.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ExportSnapshot {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::export_snapshot_input::Builder,
    }
    impl ExportSnapshot {
        /// Creates a new `ExportSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExportSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::ExportSnapshotError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.game_name(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_game_name(input);
            self
        }
        /// <p>The identifier of the snapshot to export.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_id(input.into());
            self
        }
        /// <p>The identifier of the snapshot to export.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_snapshot_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetExtension`.
    ///
    /// <p>Gets details about a specified extension.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetExtension {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_extension_input::Builder,
    }
    impl GetExtension {
        /// Creates a new `GetExtension`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetExtensionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetExtensionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The namespace (qualifier) of the extension.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p>The namespace (qualifier) of the extension.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p>The name of the extension.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the extension.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetExtensionVersion`.
    ///
    /// <p>Gets details about a specified extension version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetExtensionVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_extension_version_input::Builder,
    }
    impl GetExtensionVersion {
        /// Creates a new `GetExtensionVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetExtensionVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetExtensionVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The namespace (qualifier) of the extension.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p>The namespace (qualifier) of the extension.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p>The name of the extension.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the extension.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The version of the extension.</p>
        pub fn extension_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.extension_version(input.into());
            self
        }
        /// <p>The version of the extension.</p>
        pub fn set_extension_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_extension_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGame`.
    ///
    /// <p>Gets details about a game.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetGame {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_game_input::Builder,
    }
    impl GetGame {
        /// Creates a new `GetGame`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGameOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGameError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.game_name(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_game_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGameConfiguration`.
    ///
    /// <p>Gets the configuration of the game.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetGameConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_game_configuration_input::Builder,
    }
    impl GetGameConfiguration {
        /// Creates a new `GetGameConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGameConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGameConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.game_name(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_game_name(input);
            self
        }
        /// Appends an item to `Sections`.
        ///
        /// To override the contents of this collection use [`set_sections`](Self::set_sections).
        ///
        /// <p>The list of sections to return.</p>
        pub fn sections(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sections(input.into());
            self
        }
        /// <p>The list of sections to return.</p>
        pub fn set_sections(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_sections(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGeneratedCodeJob`.
    ///
    /// <p>Gets details about a job that is generating code for a snapshot.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetGeneratedCodeJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_generated_code_job_input::Builder,
    }
    impl GetGeneratedCodeJob {
        /// Creates a new `GetGeneratedCodeJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGeneratedCodeJobOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGeneratedCodeJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.game_name(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_game_name(input);
            self
        }
        /// <p>The identifier of the snapshot for the code generation job.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_id(input.into());
            self
        }
        /// <p>The identifier of the snapshot for the code generation job.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_snapshot_id(input);
            self
        }
        /// <p>The identifier of the code generation job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The identifier of the code generation job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPlayerConnectionStatus`.
    ///
    /// <p>Gets the status of a player's connection to the game runtime.</p>
    /// <p> It's possible for a single player to have multiple connections to the game runtime. If a player is not connected, this operation returns an empty list. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPlayerConnectionStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_player_connection_status_input::Builder,
    }
    impl GetPlayerConnectionStatus {
        /// Creates a new `GetPlayerConnectionStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPlayerConnectionStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPlayerConnectionStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier representing a player.</p>
        pub fn player_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.player_id(input.into());
            self
        }
        /// <p>The unique identifier representing a player.</p>
        pub fn set_player_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_player_id(input);
            self
        }
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.game_name(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_game_name(input);
            self
        }
        /// <p>The name of the stage.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>The name of the stage.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSnapshot`.
    ///
    /// <p>Gets a copy of the game configuration in a snapshot.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSnapshot {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_snapshot_input::Builder,
    }
    impl GetSnapshot {
        /// Creates a new `GetSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSnapshotError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.game_name(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_game_name(input);
            self
        }
        /// <p>The identifier of the snapshot.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_id(input.into());
            self
        }
        /// <p>The identifier of the snapshot.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_snapshot_id(input);
            self
        }
        /// Appends an item to `Sections`.
        ///
        /// To override the contents of this collection use [`set_sections`](Self::set_sections).
        ///
        /// <p>The list of game configuration sections to be described.</p>
        pub fn sections(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sections(input.into());
            self
        }
        /// <p>The list of game configuration sections to be described.</p>
        pub fn set_sections(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_sections(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStage`.
    ///
    /// <p>Gets information about a stage.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetStage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_stage_input::Builder,
    }
    impl GetStage {
        /// Creates a new `GetStage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStageOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.game_name(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_game_name(input);
            self
        }
        /// <p>The name of the stage.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>The name of the stage.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStageDeployment`.
    ///
    /// <p>Gets information about a stage deployment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetStageDeployment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_stage_deployment_input::Builder,
    }
    impl GetStageDeployment {
        /// Creates a new `GetStageDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStageDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStageDeploymentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.game_name(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_game_name(input);
            self
        }
        /// <p>The name of the stage.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>The name of the stage.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
        /// <p> The identifier of the stage deployment. <code>StartStageDeployment</code> returns the identifier that you use here. </p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(input.into());
            self
        }
        /// <p> The identifier of the stage deployment. <code>StartStageDeployment</code> returns the identifier that you use here. </p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportGameConfiguration`.
    ///
    /// <p>Imports a game configuration.</p>
    /// <p> This operation replaces the current configuration of the game with the provided input. This is not a reversible operation. If you want to preserve the previous configuration, use <code>CreateSnapshot</code> to make a new snapshot before importing. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ImportGameConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::import_game_configuration_input::Builder,
    }
    impl ImportGameConfiguration {
        /// Creates a new `ImportGameConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportGameConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportGameConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.game_name(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_game_name(input);
            self
        }
        /// <p>The source used to import configuration sections.</p>
        pub fn import_source(mut self, input: crate::model::ImportGameConfigurationSource) -> Self {
            self.inner = self.inner.import_source(input);
            self
        }
        /// <p>The source used to import configuration sections.</p>
        pub fn set_import_source(
            mut self,
            input: std::option::Option<crate::model::ImportGameConfigurationSource>,
        ) -> Self {
            self.inner = self.inner.set_import_source(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListExtensions`.
    ///
    /// <p>Gets a paginated list of available extensions.</p>
    /// <p> Extensions provide features that games can use from scripts. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListExtensions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_extensions_input::Builder,
    }
    impl ListExtensions {
        /// Creates a new `ListExtensions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListExtensionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListExtensionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListExtensionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListExtensionsPaginator {
            crate::paginator::ListExtensionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return.</p>
        /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListExtensionVersions`.
    ///
    /// <p>Gets a paginated list of available versions for the extension.</p>
    /// <p> Each time an API change is made to an extension, the version is incremented. The list retrieved by this operation shows the versions that are currently available. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListExtensionVersions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_extension_versions_input::Builder,
    }
    impl ListExtensionVersions {
        /// Creates a new `ListExtensionVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListExtensionVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListExtensionVersionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListExtensionVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListExtensionVersionsPaginator {
            crate::paginator::ListExtensionVersionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The namespace (qualifier) of the extension.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p>The namespace (qualifier) of the extension.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p>The name of the extension.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the extension.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGames`.
    ///
    /// <p>Gets a paginated list of games.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListGames {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_games_input::Builder,
    }
    impl ListGames {
        /// Creates a new `ListGames`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGamesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGamesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListGamesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListGamesPaginator {
            crate::paginator::ListGamesPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return.</p>
        /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGeneratedCodeJobs`.
    ///
    /// <p>Gets a paginated list of code generation jobs for a snapshot.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListGeneratedCodeJobs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_generated_code_jobs_input::Builder,
    }
    impl ListGeneratedCodeJobs {
        /// Creates a new `ListGeneratedCodeJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGeneratedCodeJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGeneratedCodeJobsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListGeneratedCodeJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListGeneratedCodeJobsPaginator {
            crate::paginator::ListGeneratedCodeJobsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.game_name(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_game_name(input);
            self
        }
        /// <p>The identifier of the snapshot.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_id(input.into());
            self
        }
        /// <p>The identifier of the snapshot.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_snapshot_id(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSnapshots`.
    ///
    /// <p>Gets a paginated list of snapshot summaries from the game.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSnapshots {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_snapshots_input::Builder,
    }
    impl ListSnapshots {
        /// Creates a new `ListSnapshots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSnapshotsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSnapshotsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSnapshotsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListSnapshotsPaginator {
            crate::paginator::ListSnapshotsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.game_name(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_game_name(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStageDeployments`.
    ///
    /// <p>Gets a paginated list of stage deployment summaries from the game.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListStageDeployments {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_stage_deployments_input::Builder,
    }
    impl ListStageDeployments {
        /// Creates a new `ListStageDeployments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStageDeploymentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStageDeploymentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListStageDeploymentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListStageDeploymentsPaginator {
            crate::paginator::ListStageDeploymentsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.game_name(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_game_name(input);
            self
        }
        /// <p>The name of the stage.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>The name of the stage.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStages`.
    ///
    /// <p>Gets a paginated list of stage summaries from the game.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListStages {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_stages_input::Builder,
    }
    impl ListStages {
        /// Creates a new `ListStages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStagesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStagesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListStagesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListStagesPaginator {
            crate::paginator::ListStagesPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.game_name(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_game_name(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        /// <p> Use this parameter with NextToken to get results as a set of sequential pages. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that indicates the start of the next sequential page of results.</p>
        /// <p> Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags associated with a GameSparks resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the GameSparks resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the GameSparks resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartGeneratedCodeJob`.
    ///
    /// <p> Starts an asynchronous process that generates client code for system-defined and custom messages. The resulting code is collected as a .zip file and uploaded to a pre-signed Amazon S3 URL. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartGeneratedCodeJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_generated_code_job_input::Builder,
    }
    impl StartGeneratedCodeJob {
        /// Creates a new `StartGeneratedCodeJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartGeneratedCodeJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartGeneratedCodeJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.game_name(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_game_name(input);
            self
        }
        /// <p>The identifier of the snapshot for which to generate code.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_id(input.into());
            self
        }
        /// <p>The identifier of the snapshot for which to generate code.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_snapshot_id(input);
            self
        }
        /// <p>Properties of the generator to use for the job.</p>
        pub fn generator(mut self, input: crate::model::Generator) -> Self {
            self.inner = self.inner.generator(input);
            self
        }
        /// <p>Properties of the generator to use for the job.</p>
        pub fn set_generator(
            mut self,
            input: std::option::Option<crate::model::Generator>,
        ) -> Self {
            self.inner = self.inner.set_generator(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartStageDeployment`.
    ///
    /// <p>Deploys a snapshot to the stage and creates a new game runtime.</p>
    /// <p> After you call this operation, you can check the deployment status by using <code>GetStageDeployment</code>. </p>
    /// <p> If there are any players connected to the previous game runtime, then both runtimes persist. Existing connections to the previous runtime are maintained. When players disconnect and reconnect, they connect to the new runtime. After there are no connections to the previous game runtime, it is deleted. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartStageDeployment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_stage_deployment_input::Builder,
    }
    impl StartStageDeployment {
        /// Creates a new `StartStageDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartStageDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::StartStageDeploymentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.game_name(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_game_name(input);
            self
        }
        /// <p>The name of the stage to deploy the snapshot onto.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>The name of the stage to deploy the snapshot onto.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
        /// <p>The identifier of the snapshot to deploy.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_id(input.into());
            self
        }
        /// <p>The identifier of the snapshot to deploy.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_snapshot_id(input);
            self
        }
        /// <p> A client-defined token. With an active client token in the request, this action is idempotent. </p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p> A client-defined token. With an active client token in the request, this action is idempotent. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds tags to a GameSparks resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to add the tags to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to add the tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to add to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from a GameSparks resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to remove the tags from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to remove the tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the tags to remove.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The keys of the tags to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGame`.
    ///
    /// <p>Updates details of the game.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateGame {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_game_input::Builder,
    }
    impl UpdateGame {
        /// Creates a new `UpdateGame`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGameOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGameError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.game_name(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_game_name(input);
            self
        }
        /// <p>The description of the game.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the game.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGameConfiguration`.
    ///
    /// <p>Updates one or more sections of the game configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateGameConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_game_configuration_input::Builder,
    }
    impl UpdateGameConfiguration {
        /// Creates a new `UpdateGameConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGameConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGameConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.game_name(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_game_name(input);
            self
        }
        /// Appends an item to `Modifications`.
        ///
        /// To override the contents of this collection use [`set_modifications`](Self::set_modifications).
        ///
        /// <p>The list of modifications to make.</p>
        pub fn modifications(mut self, input: crate::model::SectionModification) -> Self {
            self.inner = self.inner.modifications(input);
            self
        }
        /// <p>The list of modifications to make.</p>
        pub fn set_modifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SectionModification>>,
        ) -> Self {
            self.inner = self.inner.set_modifications(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSnapshot`.
    ///
    /// <p>Updates the metadata of a GameSparks snapshot.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSnapshot {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_snapshot_input::Builder,
    }
    impl UpdateSnapshot {
        /// Creates a new `UpdateSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSnapshotError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.game_name(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_game_name(input);
            self
        }
        /// <p>The identifier of the snapshot.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_id(input.into());
            self
        }
        /// <p>The identifier of the snapshot.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_snapshot_id(input);
            self
        }
        /// <p>The description of the snapshot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the snapshot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateStage`.
    ///
    /// <p>Updates the metadata of a stage.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateStage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_stage_input::Builder,
    }
    impl UpdateStage {
        /// Creates a new `UpdateStage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateStageOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateStageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the game.</p>
        pub fn game_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.game_name(input.into());
            self
        }
        /// <p>The name of the game.</p>
        pub fn set_game_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_game_name(input);
            self
        }
        /// <p>The name of the stage.</p>
        pub fn stage_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stage_name(input.into());
            self
        }
        /// <p>The name of the stage.</p>
        pub fn set_stage_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stage_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role to use for the game snapshots deployed to this stage.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role to use for the game snapshots deployed to this stage.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role(input);
            self
        }
        /// <p>The description of the stage.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the stage.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
