// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AcceptMatchInput`](crate::input::AcceptMatchInput)
pub mod accept_match_input {
    /// A builder for [`AcceptMatchInput`](crate::input::AcceptMatchInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ticket_id: std::option::Option<std::string::String>,
        pub(crate) player_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) acceptance_type: std::option::Option<crate::model::AcceptanceType>,
    }
    impl Builder {
        /// <p>A unique identifier for a matchmaking ticket. The ticket must be in status <code>REQUIRES_ACCEPTANCE</code>; otherwise this request will fail.</p>
        pub fn ticket_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ticket_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a matchmaking ticket. The ticket must be in status <code>REQUIRES_ACCEPTANCE</code>; otherwise this request will fail.</p>
        pub fn set_ticket_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ticket_id = input;
            self
        }
        /// Appends an item to `player_ids`.
        ///
        /// To override the contents of this collection use [`set_player_ids`](Self::set_player_ids).
        ///
        /// <p>A unique identifier for a player delivering the response. This parameter can include one or multiple player IDs.</p>
        pub fn player_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.player_ids.unwrap_or_default();
            v.push(input.into());
            self.player_ids = Some(v);
            self
        }
        /// <p>A unique identifier for a player delivering the response. This parameter can include one or multiple player IDs.</p>
        pub fn set_player_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.player_ids = input;
            self
        }
        /// <p>Player response to the proposed match.</p>
        pub fn acceptance_type(mut self, input: crate::model::AcceptanceType) -> Self {
            self.acceptance_type = Some(input);
            self
        }
        /// <p>Player response to the proposed match.</p>
        pub fn set_acceptance_type(
            mut self,
            input: std::option::Option<crate::model::AcceptanceType>,
        ) -> Self {
            self.acceptance_type = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptMatchInput`](crate::input::AcceptMatchInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AcceptMatchInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AcceptMatchInput {
                ticket_id: self.ticket_id,
                player_ids: self.player_ids,
                acceptance_type: self.acceptance_type,
            })
        }
    }
}
#[doc(hidden)]
pub type AcceptMatchInputOperationOutputAlias = crate::operation::AcceptMatch;
#[doc(hidden)]
pub type AcceptMatchInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AcceptMatchInput {
    /// Consumes the builder and constructs an Operation<[`AcceptMatch`](crate::operation::AcceptMatch)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AcceptMatch,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AcceptMatchInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AcceptMatchInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AcceptMatchInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.AcceptMatch",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_accept_match(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AcceptMatch::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AcceptMatch",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AcceptMatchInput`](crate::input::AcceptMatchInput)
    pub fn builder() -> crate::input::accept_match_input::Builder {
        crate::input::accept_match_input::Builder::default()
    }
}

/// See [`ClaimGameServerInput`](crate::input::ClaimGameServerInput)
pub mod claim_game_server_input {
    /// A builder for [`ClaimGameServerInput`](crate::input::ClaimGameServerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_server_group_name: std::option::Option<std::string::String>,
        pub(crate) game_server_id: std::option::Option<std::string::String>,
        pub(crate) game_server_data: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the game server group where the game server is running. Use either the <code>GameServerGroup</code> name or ARN value. If you are not specifying a game server to claim, this value identifies where you want GameLift FleetIQ to look for an available game server to claim. </p>
        pub fn game_server_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_server_group_name = Some(input.into());
            self
        }
        /// <p>A unique identifier for the game server group where the game server is running. Use either the <code>GameServerGroup</code> name or ARN value. If you are not specifying a game server to claim, this value identifies where you want GameLift FleetIQ to look for an available game server to claim. </p>
        pub fn set_game_server_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_server_group_name = input;
            self
        }
        /// <p>A custom string that uniquely identifies the game server to claim. If this parameter is left empty, GameLift FleetIQ searches for an available game server in the specified game server group.</p>
        pub fn game_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_server_id = Some(input.into());
            self
        }
        /// <p>A custom string that uniquely identifies the game server to claim. If this parameter is left empty, GameLift FleetIQ searches for an available game server in the specified game server group.</p>
        pub fn set_game_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_server_id = input;
            self
        }
        /// <p>A set of custom game server properties, formatted as a single string value. This data is passed to a game client or service when it requests information on game servers using <code>ListGameServers</code> or <code>ClaimGameServer</code>. </p>
        pub fn game_server_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_server_data = Some(input.into());
            self
        }
        /// <p>A set of custom game server properties, formatted as a single string value. This data is passed to a game client or service when it requests information on game servers using <code>ListGameServers</code> or <code>ClaimGameServer</code>. </p>
        pub fn set_game_server_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_server_data = input;
            self
        }
        /// Consumes the builder and constructs a [`ClaimGameServerInput`](crate::input::ClaimGameServerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ClaimGameServerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ClaimGameServerInput {
                game_server_group_name: self.game_server_group_name,
                game_server_id: self.game_server_id,
                game_server_data: self.game_server_data,
            })
        }
    }
}
#[doc(hidden)]
pub type ClaimGameServerInputOperationOutputAlias = crate::operation::ClaimGameServer;
#[doc(hidden)]
pub type ClaimGameServerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ClaimGameServerInput {
    /// Consumes the builder and constructs an Operation<[`ClaimGameServer`](crate::operation::ClaimGameServer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ClaimGameServer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ClaimGameServerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ClaimGameServerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ClaimGameServerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.ClaimGameServer",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_claim_game_server(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ClaimGameServer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ClaimGameServer",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ClaimGameServerInput`](crate::input::ClaimGameServerInput)
    pub fn builder() -> crate::input::claim_game_server_input::Builder {
        crate::input::claim_game_server_input::Builder::default()
    }
}

/// See [`CreateAliasInput`](crate::input::CreateAliasInput)
pub mod create_alias_input {
    /// A builder for [`CreateAliasInput`](crate::input::CreateAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) routing_strategy: std::option::Option<crate::model::RoutingStrategy>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>A descriptive label that is associated with an alias. Alias names do not need to be unique.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A descriptive label that is associated with an alias. Alias names do not need to be unique.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A human-readable description of the alias.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A human-readable description of the alias.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The routing configuration, including routing type and fleet target, for the alias. </p>
        pub fn routing_strategy(mut self, input: crate::model::RoutingStrategy) -> Self {
            self.routing_strategy = Some(input);
            self
        }
        /// <p>The routing configuration, including routing type and fleet target, for the alias. </p>
        pub fn set_routing_strategy(
            mut self,
            input: std::option::Option<crate::model::RoutingStrategy>,
        ) -> Self {
            self.routing_strategy = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of labels to assign to the new alias resource. Tags are developer-defined key-value pairs. Tagging AWS resources are useful for resource management, access management and cost allocation. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources</a> in the <i>AWS General Reference</i>. Once the resource is created, you can use <code>TagResource</code>, <code>UntagResource</code>, and <code>ListTagsForResource</code> to add, remove, and view tags. The maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of labels to assign to the new alias resource. Tags are developer-defined key-value pairs. Tagging AWS resources are useful for resource management, access management and cost allocation. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources</a> in the <i>AWS General Reference</i>. Once the resource is created, you can use <code>TagResource</code>, <code>UntagResource</code>, and <code>ListTagsForResource</code> to add, remove, and view tags. The maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAliasInput`](crate::input::CreateAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAliasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAliasInput {
                name: self.name,
                description: self.description,
                routing_strategy: self.routing_strategy,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAliasInputOperationOutputAlias = crate::operation::CreateAlias;
#[doc(hidden)]
pub type CreateAliasInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateAliasInput {
    /// Consumes the builder and constructs an Operation<[`CreateAlias`](crate::operation::CreateAlias)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAlias,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAliasInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAliasInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAliasInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.CreateAlias",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_alias(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAlias::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAlias",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAliasInput`](crate::input::CreateAliasInput)
    pub fn builder() -> crate::input::create_alias_input::Builder {
        crate::input::create_alias_input::Builder::default()
    }
}

/// See [`CreateBuildInput`](crate::input::CreateBuildInput)
pub mod create_build_input {
    /// A builder for [`CreateBuildInput`](crate::input::CreateBuildInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) storage_location: std::option::Option<crate::model::S3Location>,
        pub(crate) operating_system: std::option::Option<crate::model::OperatingSystem>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>A descriptive label that is associated with a build. Build names do not need to be unique. You can use <code>UpdateBuild</code> to change this value later. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A descriptive label that is associated with a build. Build names do not need to be unique. You can use <code>UpdateBuild</code> to change this value later. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Version information that is associated with a build or script. Version strings do not need to be unique. You can use <code>UpdateBuild</code> to change this value later. </p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>Version information that is associated with a build or script. Version strings do not need to be unique. You can use <code>UpdateBuild</code> to change this value later. </p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>Information indicating where your game build files are stored. Use this parameter only when creating a build with files stored in an Amazon S3 bucket that you own. The storage location must specify an Amazon S3 bucket name and key. The location must also specify a role ARN that you set up to allow Amazon GameLift to access your Amazon S3 bucket. The S3 bucket and your new build must be in the same Region.</p>
        pub fn storage_location(mut self, input: crate::model::S3Location) -> Self {
            self.storage_location = Some(input);
            self
        }
        /// <p>Information indicating where your game build files are stored. Use this parameter only when creating a build with files stored in an Amazon S3 bucket that you own. The storage location must specify an Amazon S3 bucket name and key. The location must also specify a role ARN that you set up to allow Amazon GameLift to access your Amazon S3 bucket. The S3 bucket and your new build must be in the same Region.</p>
        pub fn set_storage_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.storage_location = input;
            self
        }
        /// <p>The operating system that the game server binaries are built to run on. This value determines the type of fleet resources that you can use for this build. If your game build contains multiple executables, they all must run on the same operating system. If an operating system is not specified when creating a build, Amazon GameLift uses the default value (WINDOWS_2012). This value cannot be changed later.</p>
        pub fn operating_system(mut self, input: crate::model::OperatingSystem) -> Self {
            self.operating_system = Some(input);
            self
        }
        /// <p>The operating system that the game server binaries are built to run on. This value determines the type of fleet resources that you can use for this build. If your game build contains multiple executables, they all must run on the same operating system. If an operating system is not specified when creating a build, Amazon GameLift uses the default value (WINDOWS_2012). This value cannot be changed later.</p>
        pub fn set_operating_system(
            mut self,
            input: std::option::Option<crate::model::OperatingSystem>,
        ) -> Self {
            self.operating_system = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of labels to assign to the new build resource. Tags are developer-defined key-value pairs. Tagging AWS resources are useful for resource management, access management and cost allocation. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources</a> in the <i>AWS General Reference</i>. Once the resource is created, you can use <code>TagResource</code>, <code>UntagResource</code>, and <code>ListTagsForResource</code> to add, remove, and view tags. The maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of labels to assign to the new build resource. Tags are developer-defined key-value pairs. Tagging AWS resources are useful for resource management, access management and cost allocation. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources</a> in the <i>AWS General Reference</i>. Once the resource is created, you can use <code>TagResource</code>, <code>UntagResource</code>, and <code>ListTagsForResource</code> to add, remove, and view tags. The maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBuildInput`](crate::input::CreateBuildInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBuildInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBuildInput {
                name: self.name,
                version: self.version,
                storage_location: self.storage_location,
                operating_system: self.operating_system,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBuildInputOperationOutputAlias = crate::operation::CreateBuild;
#[doc(hidden)]
pub type CreateBuildInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateBuildInput {
    /// Consumes the builder and constructs an Operation<[`CreateBuild`](crate::operation::CreateBuild)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBuild,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateBuildInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateBuildInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateBuildInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.CreateBuild",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_build(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBuild::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBuild",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateBuildInput`](crate::input::CreateBuildInput)
    pub fn builder() -> crate::input::create_build_input::Builder {
        crate::input::create_build_input::Builder::default()
    }
}

/// See [`CreateFleetInput`](crate::input::CreateFleetInput)
pub mod create_fleet_input {
    /// A builder for [`CreateFleetInput`](crate::input::CreateFleetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) build_id: std::option::Option<std::string::String>,
        pub(crate) script_id: std::option::Option<std::string::String>,
        pub(crate) server_launch_path: std::option::Option<std::string::String>,
        pub(crate) server_launch_parameters: std::option::Option<std::string::String>,
        pub(crate) log_paths: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) ec2_instance_type: std::option::Option<crate::model::Ec2InstanceType>,
        pub(crate) ec2_inbound_permissions:
            std::option::Option<std::vec::Vec<crate::model::IpPermission>>,
        pub(crate) new_game_session_protection_policy:
            std::option::Option<crate::model::ProtectionPolicy>,
        pub(crate) runtime_configuration: std::option::Option<crate::model::RuntimeConfiguration>,
        pub(crate) resource_creation_limit_policy:
            std::option::Option<crate::model::ResourceCreationLimitPolicy>,
        pub(crate) metric_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) peer_vpc_aws_account_id: std::option::Option<std::string::String>,
        pub(crate) peer_vpc_id: std::option::Option<std::string::String>,
        pub(crate) fleet_type: std::option::Option<crate::model::FleetType>,
        pub(crate) instance_role_arn: std::option::Option<std::string::String>,
        pub(crate) certificate_configuration:
            std::option::Option<crate::model::CertificateConfiguration>,
        pub(crate) locations:
            std::option::Option<std::vec::Vec<crate::model::LocationConfiguration>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>A descriptive label that is associated with a fleet. Fleet names do not need to be unique.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A descriptive label that is associated with a fleet. Fleet names do not need to be unique.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A human-readable description of the fleet.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A human-readable description of the fleet.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The unique identifier for a custom game server build to be deployed on fleet instances. You can use either the build ID or ARN. The build must be uploaded to GameLift and in <code>READY</code> status. This fleet property cannot be changed later.</p>
        pub fn build_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.build_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a custom game server build to be deployed on fleet instances. You can use either the build ID or ARN. The build must be uploaded to GameLift and in <code>READY</code> status. This fleet property cannot be changed later.</p>
        pub fn set_build_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.build_id = input;
            self
        }
        /// <p>The unique identifier for a Realtime configuration script to be deployed on fleet instances. You can use either the script ID or ARN. Scripts must be uploaded to GameLift prior to creating the fleet. This fleet property cannot be changed later.</p>
        pub fn script_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.script_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a Realtime configuration script to be deployed on fleet instances. You can use either the script ID or ARN. Scripts must be uploaded to GameLift prior to creating the fleet. This fleet property cannot be changed later.</p>
        pub fn set_script_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.script_id = input;
            self
        }
        /// <p> <b>This parameter is no longer used.</b> Specify a server launch path using the <code>RuntimeConfiguration</code> parameter. Requests that use this parameter instead continue to be valid.</p>
        pub fn server_launch_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_launch_path = Some(input.into());
            self
        }
        /// <p> <b>This parameter is no longer used.</b> Specify a server launch path using the <code>RuntimeConfiguration</code> parameter. Requests that use this parameter instead continue to be valid.</p>
        pub fn set_server_launch_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.server_launch_path = input;
            self
        }
        /// <p> <b>This parameter is no longer used.</b> Specify server launch parameters using the <code>RuntimeConfiguration</code> parameter. Requests that use this parameter instead continue to be valid.</p>
        pub fn server_launch_parameters(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_launch_parameters = Some(input.into());
            self
        }
        /// <p> <b>This parameter is no longer used.</b> Specify server launch parameters using the <code>RuntimeConfiguration</code> parameter. Requests that use this parameter instead continue to be valid.</p>
        pub fn set_server_launch_parameters(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.server_launch_parameters = input;
            self
        }
        /// Appends an item to `log_paths`.
        ///
        /// To override the contents of this collection use [`set_log_paths`](Self::set_log_paths).
        ///
        /// <p> <b>This parameter is no longer used.</b> To specify where GameLift should store log files once a server process shuts down, use the GameLift server API <code>ProcessReady()</code> and specify one or more directory paths in <code>logParameters</code>. See more information in the <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process">Server API Reference</a>. </p>
        pub fn log_paths(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.log_paths.unwrap_or_default();
            v.push(input.into());
            self.log_paths = Some(v);
            self
        }
        /// <p> <b>This parameter is no longer used.</b> To specify where GameLift should store log files once a server process shuts down, use the GameLift server API <code>ProcessReady()</code> and specify one or more directory paths in <code>logParameters</code>. See more information in the <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process">Server API Reference</a>. </p>
        pub fn set_log_paths(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.log_paths = input;
            self
        }
        /// <p>The GameLift-supported EC2 instance type to use for all fleet instances. Instance type determines the computing resources that will be used to host your game servers, including CPU, memory, storage, and networking capacity. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a> for detailed descriptions of EC2 instance types.</p>
        pub fn ec2_instance_type(mut self, input: crate::model::Ec2InstanceType) -> Self {
            self.ec2_instance_type = Some(input);
            self
        }
        /// <p>The GameLift-supported EC2 instance type to use for all fleet instances. Instance type determines the computing resources that will be used to host your game servers, including CPU, memory, storage, and networking capacity. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a> for detailed descriptions of EC2 instance types.</p>
        pub fn set_ec2_instance_type(
            mut self,
            input: std::option::Option<crate::model::Ec2InstanceType>,
        ) -> Self {
            self.ec2_instance_type = input;
            self
        }
        /// Appends an item to `ec2_inbound_permissions`.
        ///
        /// To override the contents of this collection use [`set_ec2_inbound_permissions`](Self::set_ec2_inbound_permissions).
        ///
        /// <p>The allowed IP address ranges and port settings that allow inbound traffic to access game sessions on this fleet. If the fleet is hosting a custom game build, this property must be set before players can connect to game sessions. For Realtime Servers fleets, GameLift automatically sets TCP and UDP ranges. </p>
        pub fn ec2_inbound_permissions(mut self, input: crate::model::IpPermission) -> Self {
            let mut v = self.ec2_inbound_permissions.unwrap_or_default();
            v.push(input);
            self.ec2_inbound_permissions = Some(v);
            self
        }
        /// <p>The allowed IP address ranges and port settings that allow inbound traffic to access game sessions on this fleet. If the fleet is hosting a custom game build, this property must be set before players can connect to game sessions. For Realtime Servers fleets, GameLift automatically sets TCP and UDP ranges. </p>
        pub fn set_ec2_inbound_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpPermission>>,
        ) -> Self {
            self.ec2_inbound_permissions = input;
            self
        }
        /// <p>The status of termination protection for active game sessions on the fleet. By default, this property is set to <code>NoProtection</code>. You can also set game session protection for an individual game session by calling <code>UpdateGameSession</code>.</p>
        /// <ul>
        /// <li> <p> <b>NoProtection</b> - Game sessions can be terminated during active gameplay as a result of a scale-down event. </p> </li>
        /// <li> <p> <b>FullProtection</b> - Game sessions in <code>ACTIVE</code> status cannot be terminated during a scale-down event.</p> </li>
        /// </ul>
        pub fn new_game_session_protection_policy(
            mut self,
            input: crate::model::ProtectionPolicy,
        ) -> Self {
            self.new_game_session_protection_policy = Some(input);
            self
        }
        /// <p>The status of termination protection for active game sessions on the fleet. By default, this property is set to <code>NoProtection</code>. You can also set game session protection for an individual game session by calling <code>UpdateGameSession</code>.</p>
        /// <ul>
        /// <li> <p> <b>NoProtection</b> - Game sessions can be terminated during active gameplay as a result of a scale-down event. </p> </li>
        /// <li> <p> <b>FullProtection</b> - Game sessions in <code>ACTIVE</code> status cannot be terminated during a scale-down event.</p> </li>
        /// </ul>
        pub fn set_new_game_session_protection_policy(
            mut self,
            input: std::option::Option<crate::model::ProtectionPolicy>,
        ) -> Self {
            self.new_game_session_protection_policy = input;
            self
        }
        /// <p>Instructions for how to launch and maintain server processes on instances in the fleet. The runtime configuration defines one or more server process configurations, each identifying a build executable or Realtime script file and the number of processes of that type to run concurrently. </p> <note>
        /// <p>The <code>RuntimeConfiguration</code> parameter is required unless the fleet is being configured using the older parameters <code>ServerLaunchPath</code> and <code>ServerLaunchParameters</code>, which are still supported for backward compatibility.</p>
        /// </note>
        pub fn runtime_configuration(mut self, input: crate::model::RuntimeConfiguration) -> Self {
            self.runtime_configuration = Some(input);
            self
        }
        /// <p>Instructions for how to launch and maintain server processes on instances in the fleet. The runtime configuration defines one or more server process configurations, each identifying a build executable or Realtime script file and the number of processes of that type to run concurrently. </p> <note>
        /// <p>The <code>RuntimeConfiguration</code> parameter is required unless the fleet is being configured using the older parameters <code>ServerLaunchPath</code> and <code>ServerLaunchParameters</code>, which are still supported for backward compatibility.</p>
        /// </note>
        pub fn set_runtime_configuration(
            mut self,
            input: std::option::Option<crate::model::RuntimeConfiguration>,
        ) -> Self {
            self.runtime_configuration = input;
            self
        }
        /// <p>A policy that limits the number of game sessions that an individual player can create on instances in this fleet within a specified span of time.</p>
        pub fn resource_creation_limit_policy(
            mut self,
            input: crate::model::ResourceCreationLimitPolicy,
        ) -> Self {
            self.resource_creation_limit_policy = Some(input);
            self
        }
        /// <p>A policy that limits the number of game sessions that an individual player can create on instances in this fleet within a specified span of time.</p>
        pub fn set_resource_creation_limit_policy(
            mut self,
            input: std::option::Option<crate::model::ResourceCreationLimitPolicy>,
        ) -> Self {
            self.resource_creation_limit_policy = input;
            self
        }
        /// Appends an item to `metric_groups`.
        ///
        /// To override the contents of this collection use [`set_metric_groups`](Self::set_metric_groups).
        ///
        /// <p>The name of an AWS CloudWatch metric group to add this fleet to. A metric group is used to aggregate the metrics for multiple fleets. You can specify an existing metric group name or set a new name to create a new metric group. A fleet can be included in only one metric group at a time. </p>
        pub fn metric_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.metric_groups.unwrap_or_default();
            v.push(input.into());
            self.metric_groups = Some(v);
            self
        }
        /// <p>The name of an AWS CloudWatch metric group to add this fleet to. A metric group is used to aggregate the metrics for multiple fleets. You can specify an existing metric group name or set a new name to create a new metric group. A fleet can be included in only one metric group at a time. </p>
        pub fn set_metric_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.metric_groups = input;
            self
        }
        /// <p>Used when peering your GameLift fleet with a VPC, the unique identifier for the AWS account that owns the VPC. You can find your account ID in the AWS Management Console under account settings. </p>
        pub fn peer_vpc_aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.peer_vpc_aws_account_id = Some(input.into());
            self
        }
        /// <p>Used when peering your GameLift fleet with a VPC, the unique identifier for the AWS account that owns the VPC. You can find your account ID in the AWS Management Console under account settings. </p>
        pub fn set_peer_vpc_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.peer_vpc_aws_account_id = input;
            self
        }
        /// <p>A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in the same Region as your fleet. To look up a VPC ID, use the <a href="https://console.aws.amazon.com/vpc/">VPC Dashboard</a> in the AWS Management Console. Learn more about VPC peering in <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift Fleets</a>. </p>
        pub fn peer_vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.peer_vpc_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in the same Region as your fleet. To look up a VPC ID, use the <a href="https://console.aws.amazon.com/vpc/">VPC Dashboard</a> in the AWS Management Console. Learn more about VPC peering in <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift Fleets</a>. </p>
        pub fn set_peer_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.peer_vpc_id = input;
            self
        }
        /// <p>Indicates whether to use On-Demand or Spot instances for this fleet. By default, this property is set to <code>ON_DEMAND</code>. Learn more about when to use <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot"> On-Demand versus Spot Instances</a>. This property cannot be changed after the fleet is created.</p>
        pub fn fleet_type(mut self, input: crate::model::FleetType) -> Self {
            self.fleet_type = Some(input);
            self
        }
        /// <p>Indicates whether to use On-Demand or Spot instances for this fleet. By default, this property is set to <code>ON_DEMAND</code>. Learn more about when to use <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot"> On-Demand versus Spot Instances</a>. This property cannot be changed after the fleet is created.</p>
        pub fn set_fleet_type(
            mut self,
            input: std::option::Option<crate::model::FleetType>,
        ) -> Self {
            self.fleet_type = input;
            self
        }
        /// <p>A unique identifier for an AWS IAM role that manages access to your AWS services. With an instance role ARN set, any application that runs on an instance in this fleet can assume the role, including install scripts, server processes, and daemons (background processes). Create a role or look up a role's ARN by using the <a href="https://console.aws.amazon.com/iam/">IAM dashboard</a> in the AWS Management Console. Learn more about using on-box credentials for your game servers at <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html"> Access external resources from a game server</a>. This property cannot be changed after the fleet is created.</p>
        pub fn instance_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_role_arn = Some(input.into());
            self
        }
        /// <p>A unique identifier for an AWS IAM role that manages access to your AWS services. With an instance role ARN set, any application that runs on an instance in this fleet can assume the role, including install scripts, server processes, and daemons (background processes). Create a role or look up a role's ARN by using the <a href="https://console.aws.amazon.com/iam/">IAM dashboard</a> in the AWS Management Console. Learn more about using on-box credentials for your game servers at <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html"> Access external resources from a game server</a>. This property cannot be changed after the fleet is created.</p>
        pub fn set_instance_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_role_arn = input;
            self
        }
        /// <p>Prompts GameLift to generate a TLS/SSL certificate for the fleet. TLS certificates are used for encrypting traffic between game clients and the game servers that are running on GameLift. By default, the <code>CertificateConfiguration</code> is set to <code>DISABLED</code>. Learn more at <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-howitworks.html#gamelift-howitworks-security">Securing Client/Server Communication</a>. This property cannot be changed after the fleet is created. </p>
        /// <p>Note: This feature requires the AWS Certificate Manager (ACM) service, which is not available in all AWS regions. When working in a region that does not support this feature, a fleet creation request with certificate generation fails with a 4xx error.</p>
        pub fn certificate_configuration(
            mut self,
            input: crate::model::CertificateConfiguration,
        ) -> Self {
            self.certificate_configuration = Some(input);
            self
        }
        /// <p>Prompts GameLift to generate a TLS/SSL certificate for the fleet. TLS certificates are used for encrypting traffic between game clients and the game servers that are running on GameLift. By default, the <code>CertificateConfiguration</code> is set to <code>DISABLED</code>. Learn more at <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-howitworks.html#gamelift-howitworks-security">Securing Client/Server Communication</a>. This property cannot be changed after the fleet is created. </p>
        /// <p>Note: This feature requires the AWS Certificate Manager (ACM) service, which is not available in all AWS regions. When working in a region that does not support this feature, a fleet creation request with certificate generation fails with a 4xx error.</p>
        pub fn set_certificate_configuration(
            mut self,
            input: std::option::Option<crate::model::CertificateConfiguration>,
        ) -> Self {
            self.certificate_configuration = input;
            self
        }
        /// Appends an item to `locations`.
        ///
        /// To override the contents of this collection use [`set_locations`](Self::set_locations).
        ///
        /// <p>A set of remote locations to deploy additional instances to and manage as part of the fleet. This parameter can only be used when creating fleets in AWS Regions that support multiple locations. You can add any GameLift-supported AWS Region as a remote location, in the form of an AWS Region code such as <code>us-west-2</code>. To create a fleet with instances in the home Region only, omit this parameter. </p>
        pub fn locations(mut self, input: crate::model::LocationConfiguration) -> Self {
            let mut v = self.locations.unwrap_or_default();
            v.push(input);
            self.locations = Some(v);
            self
        }
        /// <p>A set of remote locations to deploy additional instances to and manage as part of the fleet. This parameter can only be used when creating fleets in AWS Regions that support multiple locations. You can add any GameLift-supported AWS Region as a remote location, in the form of an AWS Region code such as <code>us-west-2</code>. To create a fleet with instances in the home Region only, omit this parameter. </p>
        pub fn set_locations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LocationConfiguration>>,
        ) -> Self {
            self.locations = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of labels to assign to the new fleet resource. Tags are developer-defined key-value pairs. Tagging AWS resources are useful for resource management, access management and cost allocation. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources</a> in the <i>AWS General Reference</i>. Once the fleet is created, you can use <code>TagResource</code>, <code>UntagResource</code>, and <code>ListTagsForResource</code> to add, remove, and view tags. The maximum tag limit may be lower than stated. See the <i>AWS General Reference</i> for actual tagging limits.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of labels to assign to the new fleet resource. Tags are developer-defined key-value pairs. Tagging AWS resources are useful for resource management, access management and cost allocation. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources</a> in the <i>AWS General Reference</i>. Once the fleet is created, you can use <code>TagResource</code>, <code>UntagResource</code>, and <code>ListTagsForResource</code> to add, remove, and view tags. The maximum tag limit may be lower than stated. See the <i>AWS General Reference</i> for actual tagging limits.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFleetInput`](crate::input::CreateFleetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFleetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFleetInput {
                name: self.name,
                description: self.description,
                build_id: self.build_id,
                script_id: self.script_id,
                server_launch_path: self.server_launch_path,
                server_launch_parameters: self.server_launch_parameters,
                log_paths: self.log_paths,
                ec2_instance_type: self.ec2_instance_type,
                ec2_inbound_permissions: self.ec2_inbound_permissions,
                new_game_session_protection_policy: self.new_game_session_protection_policy,
                runtime_configuration: self.runtime_configuration,
                resource_creation_limit_policy: self.resource_creation_limit_policy,
                metric_groups: self.metric_groups,
                peer_vpc_aws_account_id: self.peer_vpc_aws_account_id,
                peer_vpc_id: self.peer_vpc_id,
                fleet_type: self.fleet_type,
                instance_role_arn: self.instance_role_arn,
                certificate_configuration: self.certificate_configuration,
                locations: self.locations,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFleetInputOperationOutputAlias = crate::operation::CreateFleet;
#[doc(hidden)]
pub type CreateFleetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateFleetInput {
    /// Consumes the builder and constructs an Operation<[`CreateFleet`](crate::operation::CreateFleet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFleet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateFleetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateFleetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateFleetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.CreateFleet",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_fleet(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFleet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFleet",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateFleetInput`](crate::input::CreateFleetInput)
    pub fn builder() -> crate::input::create_fleet_input::Builder {
        crate::input::create_fleet_input::Builder::default()
    }
}

/// See [`CreateFleetLocationsInput`](crate::input::CreateFleetLocationsInput)
pub mod create_fleet_locations_input {
    /// A builder for [`CreateFleetLocationsInput`](crate::input::CreateFleetLocationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) locations:
            std::option::Option<std::vec::Vec<crate::model::LocationConfiguration>>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet to add locations to. You can use either the fleet ID or ARN value.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet to add locations to. You can use either the fleet ID or ARN value.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// Appends an item to `locations`.
        ///
        /// To override the contents of this collection use [`set_locations`](Self::set_locations).
        ///
        /// <p>A list of locations to deploy additional instances to and manage as part of the fleet. You can add any GameLift-supported AWS Region as a remote location, in the form of an AWS Region code such as <code>us-west-2</code>. </p>
        pub fn locations(mut self, input: crate::model::LocationConfiguration) -> Self {
            let mut v = self.locations.unwrap_or_default();
            v.push(input);
            self.locations = Some(v);
            self
        }
        /// <p>A list of locations to deploy additional instances to and manage as part of the fleet. You can add any GameLift-supported AWS Region as a remote location, in the form of an AWS Region code such as <code>us-west-2</code>. </p>
        pub fn set_locations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LocationConfiguration>>,
        ) -> Self {
            self.locations = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFleetLocationsInput`](crate::input::CreateFleetLocationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFleetLocationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFleetLocationsInput {
                fleet_id: self.fleet_id,
                locations: self.locations,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFleetLocationsInputOperationOutputAlias = crate::operation::CreateFleetLocations;
#[doc(hidden)]
pub type CreateFleetLocationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateFleetLocationsInput {
    /// Consumes the builder and constructs an Operation<[`CreateFleetLocations`](crate::operation::CreateFleetLocations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFleetLocations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateFleetLocationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateFleetLocationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateFleetLocationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.CreateFleetLocations",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_fleet_locations(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFleetLocations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFleetLocations",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateFleetLocationsInput`](crate::input::CreateFleetLocationsInput)
    pub fn builder() -> crate::input::create_fleet_locations_input::Builder {
        crate::input::create_fleet_locations_input::Builder::default()
    }
}

/// See [`CreateGameServerGroupInput`](crate::input::CreateGameServerGroupInput)
pub mod create_game_server_group_input {
    /// A builder for [`CreateGameServerGroupInput`](crate::input::CreateGameServerGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_server_group_name: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) min_size: std::option::Option<i32>,
        pub(crate) max_size: std::option::Option<i32>,
        pub(crate) launch_template: std::option::Option<crate::model::LaunchTemplateSpecification>,
        pub(crate) instance_definitions:
            std::option::Option<std::vec::Vec<crate::model::InstanceDefinition>>,
        pub(crate) auto_scaling_policy:
            std::option::Option<crate::model::GameServerGroupAutoScalingPolicy>,
        pub(crate) balancing_strategy: std::option::Option<crate::model::BalancingStrategy>,
        pub(crate) game_server_protection_policy:
            std::option::Option<crate::model::GameServerProtectionPolicy>,
        pub(crate) vpc_subnets: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>An identifier for the new game server group. This value is used to generate unique ARN identifiers for the EC2 Auto Scaling group and the GameLift FleetIQ game server group. The name must be unique per Region per AWS account.</p>
        pub fn game_server_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_server_group_name = Some(input.into());
            self
        }
        /// <p>An identifier for the new game server group. This value is used to generate unique ARN identifiers for the EC2 Auto Scaling group and the GameLift FleetIQ game server group. The name must be unique per Region per AWS account.</p>
        pub fn set_game_server_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_server_group_name = input;
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) for an IAM role that allows Amazon GameLift to access your EC2 Auto Scaling groups.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) for an IAM role that allows Amazon GameLift to access your EC2 Auto Scaling groups.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The minimum number of instances allowed in the EC2 Auto Scaling group. During automatic scaling events, GameLift FleetIQ and EC2 do not scale down the group below this minimum. In production, this value should be set to at least 1. After the Auto Scaling group is created, update this value directly in the Auto Scaling group using the AWS console or APIs.</p>
        pub fn min_size(mut self, input: i32) -> Self {
            self.min_size = Some(input);
            self
        }
        /// <p>The minimum number of instances allowed in the EC2 Auto Scaling group. During automatic scaling events, GameLift FleetIQ and EC2 do not scale down the group below this minimum. In production, this value should be set to at least 1. After the Auto Scaling group is created, update this value directly in the Auto Scaling group using the AWS console or APIs.</p>
        pub fn set_min_size(mut self, input: std::option::Option<i32>) -> Self {
            self.min_size = input;
            self
        }
        /// <p>The maximum number of instances allowed in the EC2 Auto Scaling group. During automatic scaling events, GameLift FleetIQ and EC2 do not scale up the group above this maximum. After the Auto Scaling group is created, update this value directly in the Auto Scaling group using the AWS console or APIs.</p>
        pub fn max_size(mut self, input: i32) -> Self {
            self.max_size = Some(input);
            self
        }
        /// <p>The maximum number of instances allowed in the EC2 Auto Scaling group. During automatic scaling events, GameLift FleetIQ and EC2 do not scale up the group above this maximum. After the Auto Scaling group is created, update this value directly in the Auto Scaling group using the AWS console or APIs.</p>
        pub fn set_max_size(mut self, input: std::option::Option<i32>) -> Self {
            self.max_size = input;
            self
        }
        /// <p>The EC2 launch template that contains configuration settings and game server code to be deployed to all instances in the game server group. You can specify the template using either the template name or ID. For help with creating a launch template, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html">Creating a Launch Template for an Auto Scaling Group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. After the Auto Scaling group is created, update this value directly in the Auto Scaling group using the AWS console or APIs.</p> <note>
        /// <p>If you specify network interfaces in your launch template, you must explicitly set the property <code>AssociatePublicIpAddress</code> to "true". If no network interface is specified in the launch template, GameLift FleetIQ uses your account's default VPC.</p>
        /// </note>
        pub fn launch_template(mut self, input: crate::model::LaunchTemplateSpecification) -> Self {
            self.launch_template = Some(input);
            self
        }
        /// <p>The EC2 launch template that contains configuration settings and game server code to be deployed to all instances in the game server group. You can specify the template using either the template name or ID. For help with creating a launch template, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html">Creating a Launch Template for an Auto Scaling Group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. After the Auto Scaling group is created, update this value directly in the Auto Scaling group using the AWS console or APIs.</p> <note>
        /// <p>If you specify network interfaces in your launch template, you must explicitly set the property <code>AssociatePublicIpAddress</code> to "true". If no network interface is specified in the launch template, GameLift FleetIQ uses your account's default VPC.</p>
        /// </note>
        pub fn set_launch_template(
            mut self,
            input: std::option::Option<crate::model::LaunchTemplateSpecification>,
        ) -> Self {
            self.launch_template = input;
            self
        }
        /// Appends an item to `instance_definitions`.
        ///
        /// To override the contents of this collection use [`set_instance_definitions`](Self::set_instance_definitions).
        ///
        /// <p>The EC2 instance types and sizes to use in the Auto Scaling group. The instance definitions must specify at least two different instance types that are supported by GameLift FleetIQ. For more information on instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">EC2 Instance Types</a> in the <i>Amazon EC2 User Guide</i>. You can optionally specify capacity weighting for each instance type. If no weight value is specified for an instance type, it is set to the default value "1". For more information about capacity weighting, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html"> Instance Weighting for Amazon EC2 Auto Scaling</a> in the Amazon EC2 Auto Scaling User Guide.</p>
        pub fn instance_definitions(mut self, input: crate::model::InstanceDefinition) -> Self {
            let mut v = self.instance_definitions.unwrap_or_default();
            v.push(input);
            self.instance_definitions = Some(v);
            self
        }
        /// <p>The EC2 instance types and sizes to use in the Auto Scaling group. The instance definitions must specify at least two different instance types that are supported by GameLift FleetIQ. For more information on instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">EC2 Instance Types</a> in the <i>Amazon EC2 User Guide</i>. You can optionally specify capacity weighting for each instance type. If no weight value is specified for an instance type, it is set to the default value "1". For more information about capacity weighting, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html"> Instance Weighting for Amazon EC2 Auto Scaling</a> in the Amazon EC2 Auto Scaling User Guide.</p>
        pub fn set_instance_definitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceDefinition>>,
        ) -> Self {
            self.instance_definitions = input;
            self
        }
        /// <p>Configuration settings to define a scaling policy for the Auto Scaling group that is optimized for game hosting. The scaling policy uses the metric <code>"PercentUtilizedGameServers"</code> to maintain a buffer of idle game servers that can immediately accommodate new games and players. After the Auto Scaling group is created, update this value directly in the Auto Scaling group using the AWS console or APIs.</p>
        pub fn auto_scaling_policy(
            mut self,
            input: crate::model::GameServerGroupAutoScalingPolicy,
        ) -> Self {
            self.auto_scaling_policy = Some(input);
            self
        }
        /// <p>Configuration settings to define a scaling policy for the Auto Scaling group that is optimized for game hosting. The scaling policy uses the metric <code>"PercentUtilizedGameServers"</code> to maintain a buffer of idle game servers that can immediately accommodate new games and players. After the Auto Scaling group is created, update this value directly in the Auto Scaling group using the AWS console or APIs.</p>
        pub fn set_auto_scaling_policy(
            mut self,
            input: std::option::Option<crate::model::GameServerGroupAutoScalingPolicy>,
        ) -> Self {
            self.auto_scaling_policy = input;
            self
        }
        /// <p>Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game server group. Method options include the following:</p>
        /// <ul>
        /// <li> <p> <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are unavailable or not viable for game hosting, the game server group provides no hosting capacity until Spot Instances can again be used. Until then, no new instances are started, and the existing nonviable Spot Instances are terminated (after current gameplay ends) and are not replaced.</p> </li>
        /// <li> <p> <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game server group. If Spot Instances are unavailable, the game server group continues to provide hosting capacity by falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after current gameplay ends) and are replaced with new On-Demand Instances.</p> </li>
        /// <li> <p> <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot Instances are used, even when available, while this balancing strategy is in force.</p> </li>
        /// </ul>
        pub fn balancing_strategy(mut self, input: crate::model::BalancingStrategy) -> Self {
            self.balancing_strategy = Some(input);
            self
        }
        /// <p>Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game server group. Method options include the following:</p>
        /// <ul>
        /// <li> <p> <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are unavailable or not viable for game hosting, the game server group provides no hosting capacity until Spot Instances can again be used. Until then, no new instances are started, and the existing nonviable Spot Instances are terminated (after current gameplay ends) and are not replaced.</p> </li>
        /// <li> <p> <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game server group. If Spot Instances are unavailable, the game server group continues to provide hosting capacity by falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after current gameplay ends) and are replaced with new On-Demand Instances.</p> </li>
        /// <li> <p> <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot Instances are used, even when available, while this balancing strategy is in force.</p> </li>
        /// </ul>
        pub fn set_balancing_strategy(
            mut self,
            input: std::option::Option<crate::model::BalancingStrategy>,
        ) -> Self {
            self.balancing_strategy = input;
            self
        }
        /// <p>A flag that indicates whether instances in the game server group are protected from early termination. Unprotected instances that have active game servers running might be terminated during a scale-down event, causing players to be dropped from the game. Protected instances cannot be terminated while there are active game servers running except in the event of a forced game server group deletion (see ). An exception to this is with Spot Instances, which can be terminated by AWS regardless of protection status. This property is set to <code>NO_PROTECTION</code> by default.</p>
        pub fn game_server_protection_policy(
            mut self,
            input: crate::model::GameServerProtectionPolicy,
        ) -> Self {
            self.game_server_protection_policy = Some(input);
            self
        }
        /// <p>A flag that indicates whether instances in the game server group are protected from early termination. Unprotected instances that have active game servers running might be terminated during a scale-down event, causing players to be dropped from the game. Protected instances cannot be terminated while there are active game servers running except in the event of a forced game server group deletion (see ). An exception to this is with Spot Instances, which can be terminated by AWS regardless of protection status. This property is set to <code>NO_PROTECTION</code> by default.</p>
        pub fn set_game_server_protection_policy(
            mut self,
            input: std::option::Option<crate::model::GameServerProtectionPolicy>,
        ) -> Self {
            self.game_server_protection_policy = input;
            self
        }
        /// Appends an item to `vpc_subnets`.
        ///
        /// To override the contents of this collection use [`set_vpc_subnets`](Self::set_vpc_subnets).
        ///
        /// <p>A list of virtual private cloud (VPC) subnets to use with instances in the game server group. By default, all GameLift FleetIQ-supported Availability Zones are used. You can use this parameter to specify VPCs that you've set up. This property cannot be updated after the game server group is created, and the corresponding Auto Scaling group will always use the property value that is set with this request, even if the Auto Scaling group is updated directly.</p>
        pub fn vpc_subnets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.vpc_subnets.unwrap_or_default();
            v.push(input.into());
            self.vpc_subnets = Some(v);
            self
        }
        /// <p>A list of virtual private cloud (VPC) subnets to use with instances in the game server group. By default, all GameLift FleetIQ-supported Availability Zones are used. You can use this parameter to specify VPCs that you've set up. This property cannot be updated after the game server group is created, and the corresponding Auto Scaling group will always use the property value that is set with this request, even if the Auto Scaling group is updated directly.</p>
        pub fn set_vpc_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vpc_subnets = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of labels to assign to the new game server group resource. Tags are developer-defined key-value pairs. Tagging AWS resources is useful for resource management, access management, and cost allocation. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources</a> in the <i>AWS General Reference</i>. Once the resource is created, you can use <code>TagResource</code>, <code>UntagResource</code>, and <code>ListTagsForResource</code> to add, remove, and view tags, respectively. The maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of labels to assign to the new game server group resource. Tags are developer-defined key-value pairs. Tagging AWS resources is useful for resource management, access management, and cost allocation. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources</a> in the <i>AWS General Reference</i>. Once the resource is created, you can use <code>TagResource</code>, <code>UntagResource</code>, and <code>ListTagsForResource</code> to add, remove, and view tags, respectively. The maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGameServerGroupInput`](crate::input::CreateGameServerGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateGameServerGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateGameServerGroupInput {
                game_server_group_name: self.game_server_group_name,
                role_arn: self.role_arn,
                min_size: self.min_size,
                max_size: self.max_size,
                launch_template: self.launch_template,
                instance_definitions: self.instance_definitions,
                auto_scaling_policy: self.auto_scaling_policy,
                balancing_strategy: self.balancing_strategy,
                game_server_protection_policy: self.game_server_protection_policy,
                vpc_subnets: self.vpc_subnets,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateGameServerGroupInputOperationOutputAlias = crate::operation::CreateGameServerGroup;
#[doc(hidden)]
pub type CreateGameServerGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateGameServerGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateGameServerGroup`](crate::operation::CreateGameServerGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateGameServerGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateGameServerGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateGameServerGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateGameServerGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.CreateGameServerGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_game_server_group(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateGameServerGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateGameServerGroup",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateGameServerGroupInput`](crate::input::CreateGameServerGroupInput)
    pub fn builder() -> crate::input::create_game_server_group_input::Builder {
        crate::input::create_game_server_group_input::Builder::default()
    }
}

/// See [`CreateGameSessionInput`](crate::input::CreateGameSessionInput)
pub mod create_game_session_input {
    /// A builder for [`CreateGameSessionInput`](crate::input::CreateGameSessionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) alias_id: std::option::Option<std::string::String>,
        pub(crate) maximum_player_session_count: std::option::Option<i32>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) game_properties: std::option::Option<std::vec::Vec<crate::model::GameProperty>>,
        pub(crate) creator_id: std::option::Option<std::string::String>,
        pub(crate) game_session_id: std::option::Option<std::string::String>,
        pub(crate) idempotency_token: std::option::Option<std::string::String>,
        pub(crate) game_session_data: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet to create a game session in. You can use either the fleet ID or ARN value. Each request must reference either a fleet ID or alias ID, but not both.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet to create a game session in. You can use either the fleet ID or ARN value. Each request must reference either a fleet ID or alias ID, but not both.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p>A unique identifier for the alias associated with the fleet to create a game session in. You can use either the alias ID or ARN value. Each request must reference either a fleet ID or alias ID, but not both.</p>
        pub fn alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the alias associated with the fleet to create a game session in. You can use either the alias ID or ARN value. Each request must reference either a fleet ID or alias ID, but not both.</p>
        pub fn set_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_id = input;
            self
        }
        /// <p>The maximum number of players that can be connected simultaneously to the game session.</p>
        pub fn maximum_player_session_count(mut self, input: i32) -> Self {
            self.maximum_player_session_count = Some(input);
            self
        }
        /// <p>The maximum number of players that can be connected simultaneously to the game session.</p>
        pub fn set_maximum_player_session_count(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_player_session_count = input;
            self
        }
        /// <p>A descriptive label that is associated with a game session. Session names do not need to be unique.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A descriptive label that is associated with a game session. Session names do not need to be unique.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `game_properties`.
        ///
        /// To override the contents of this collection use [`set_game_properties`](Self::set_game_properties).
        ///
        /// <p>A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the <code>GameSession</code> object with a request to start a new game session.</p>
        pub fn game_properties(mut self, input: crate::model::GameProperty) -> Self {
            let mut v = self.game_properties.unwrap_or_default();
            v.push(input);
            self.game_properties = Some(v);
            self
        }
        /// <p>A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the <code>GameSession</code> object with a request to start a new game session.</p>
        pub fn set_game_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GameProperty>>,
        ) -> Self {
            self.game_properties = input;
            self
        }
        /// <p>A unique identifier for a player or entity creating the game session. This parameter is required when requesting a new game session on a fleet with a resource creation limit policy. This type of policy limits the number of concurrent active game sessions that one player can create within a certain time span. GameLift uses the CreatorId to evaluate the new request against the policy.</p>
        pub fn creator_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a player or entity creating the game session. This parameter is required when requesting a new game session on a fleet with a resource creation limit policy. This type of policy limits the number of concurrent active game sessions that one player can create within a certain time span. GameLift uses the CreatorId to evaluate the new request against the policy.</p>
        pub fn set_creator_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.creator_id = input;
            self
        }
        /// <p> <i>This parameter is no longer preferred. Please use <code>IdempotencyToken</code> instead.</i> Custom string that uniquely identifies a request for a new game session. Maximum token length is 48 characters. If provided, this string is included in the new game session's ID.</p>
        pub fn game_session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_session_id = Some(input.into());
            self
        }
        /// <p> <i>This parameter is no longer preferred. Please use <code>IdempotencyToken</code> instead.</i> Custom string that uniquely identifies a request for a new game session. Maximum token length is 48 characters. If provided, this string is included in the new game session's ID.</p>
        pub fn set_game_session_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_session_id = input;
            self
        }
        /// <p>Custom string that uniquely identifies the new game session request. This is useful for ensuring that game session requests with the same idempotency token are processed only once. Subsequent requests with the same string return the original <code>GameSession</code> object, with an updated status. Maximum token length is 48 characters. If provided, this string is included in the new game session's ID. A game session ARN has the following format: <code>arn:aws:gamelift:
        /// <region>
        /// ::gamesession/
        /// <fleet id>
        /// /
        /// <custom id string or idempotency token></custom>
        /// </fleet>
        /// </region></code>. Idempotency tokens remain in use for 30 days after a game session has ended; game session objects are retained for this time period and then deleted.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.idempotency_token = Some(input.into());
            self
        }
        /// <p>Custom string that uniquely identifies the new game session request. This is useful for ensuring that game session requests with the same idempotency token are processed only once. Subsequent requests with the same string return the original <code>GameSession</code> object, with an updated status. Maximum token length is 48 characters. If provided, this string is included in the new game session's ID. A game session ARN has the following format: <code>arn:aws:gamelift:
        /// <region>
        /// ::gamesession/
        /// <fleet id>
        /// /
        /// <custom id string or idempotency token></custom>
        /// </fleet>
        /// </region></code>. Idempotency tokens remain in use for 30 days after a game session has ended; game session objects are retained for this time period and then deleted.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idempotency_token = input;
            self
        }
        /// <p>A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the <code>GameSession</code> object with a request to start a new game session.</p>
        pub fn game_session_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_session_data = Some(input.into());
            self
        }
        /// <p>A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the <code>GameSession</code> object with a request to start a new game session.</p>
        pub fn set_game_session_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_session_data = input;
            self
        }
        /// <p>A fleet's remote location to place the new game session in. If this parameter is not set, the new game session is placed in the fleet's home Region. Specify a remote location with an AWS Region code such as <code>us-west-2</code>. </p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>A fleet's remote location to place the new game session in. If this parameter is not set, the new game session is placed in the fleet's home Region. Specify a remote location with an AWS Region code such as <code>us-west-2</code>. </p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGameSessionInput`](crate::input::CreateGameSessionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateGameSessionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateGameSessionInput {
                fleet_id: self.fleet_id,
                alias_id: self.alias_id,
                maximum_player_session_count: self.maximum_player_session_count,
                name: self.name,
                game_properties: self.game_properties,
                creator_id: self.creator_id,
                game_session_id: self.game_session_id,
                idempotency_token: self.idempotency_token,
                game_session_data: self.game_session_data,
                location: self.location,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateGameSessionInputOperationOutputAlias = crate::operation::CreateGameSession;
#[doc(hidden)]
pub type CreateGameSessionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateGameSessionInput {
    /// Consumes the builder and constructs an Operation<[`CreateGameSession`](crate::operation::CreateGameSession)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateGameSession,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateGameSessionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateGameSessionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateGameSessionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.CreateGameSession",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_game_session(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateGameSession::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateGameSession",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateGameSessionInput`](crate::input::CreateGameSessionInput)
    pub fn builder() -> crate::input::create_game_session_input::Builder {
        crate::input::create_game_session_input::Builder::default()
    }
}

/// See [`CreateGameSessionQueueInput`](crate::input::CreateGameSessionQueueInput)
pub mod create_game_session_queue_input {
    /// A builder for [`CreateGameSessionQueueInput`](crate::input::CreateGameSessionQueueInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) timeout_in_seconds: std::option::Option<i32>,
        pub(crate) player_latency_policies:
            std::option::Option<std::vec::Vec<crate::model::PlayerLatencyPolicy>>,
        pub(crate) destinations:
            std::option::Option<std::vec::Vec<crate::model::GameSessionQueueDestination>>,
        pub(crate) filter_configuration: std::option::Option<crate::model::FilterConfiguration>,
        pub(crate) priority_configuration: std::option::Option<crate::model::PriorityConfiguration>,
        pub(crate) custom_event_data: std::option::Option<std::string::String>,
        pub(crate) notification_target: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>A descriptive label that is associated with game session queue. Queue names must be unique within each Region.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A descriptive label that is associated with game session queue. Queue names must be unique within each Region.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The maximum time, in seconds, that a new game session placement request remains in the queue. When a request exceeds this time, the game session placement changes to a <code>TIMED_OUT</code> status.</p>
        pub fn timeout_in_seconds(mut self, input: i32) -> Self {
            self.timeout_in_seconds = Some(input);
            self
        }
        /// <p>The maximum time, in seconds, that a new game session placement request remains in the queue. When a request exceeds this time, the game session placement changes to a <code>TIMED_OUT</code> status.</p>
        pub fn set_timeout_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_in_seconds = input;
            self
        }
        /// Appends an item to `player_latency_policies`.
        ///
        /// To override the contents of this collection use [`set_player_latency_policies`](Self::set_player_latency_policies).
        ///
        /// <p>A set of policies that act as a sliding cap on player latency. FleetIQ works to deliver low latency for most players in a game session. These policies ensure that no individual player can be placed into a game with unreasonably high latency. Use multiple policies to gradually relax latency requirements a step at a time. Multiple policies are applied based on their maximum allowed latency, starting with the lowest value.</p>
        pub fn player_latency_policies(mut self, input: crate::model::PlayerLatencyPolicy) -> Self {
            let mut v = self.player_latency_policies.unwrap_or_default();
            v.push(input);
            self.player_latency_policies = Some(v);
            self
        }
        /// <p>A set of policies that act as a sliding cap on player latency. FleetIQ works to deliver low latency for most players in a game session. These policies ensure that no individual player can be placed into a game with unreasonably high latency. Use multiple policies to gradually relax latency requirements a step at a time. Multiple policies are applied based on their maximum allowed latency, starting with the lowest value.</p>
        pub fn set_player_latency_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlayerLatencyPolicy>>,
        ) -> Self {
            self.player_latency_policies = input;
            self
        }
        /// Appends an item to `destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// <p>A list of fleets and/or fleet aliases that can be used to fulfill game session placement requests in the queue. Destinations are identified by either a fleet ARN or a fleet alias ARN, and are listed in order of placement preference.</p>
        pub fn destinations(mut self, input: crate::model::GameSessionQueueDestination) -> Self {
            let mut v = self.destinations.unwrap_or_default();
            v.push(input);
            self.destinations = Some(v);
            self
        }
        /// <p>A list of fleets and/or fleet aliases that can be used to fulfill game session placement requests in the queue. Destinations are identified by either a fleet ARN or a fleet alias ARN, and are listed in order of placement preference.</p>
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GameSessionQueueDestination>>,
        ) -> Self {
            self.destinations = input;
            self
        }
        /// <p>A list of locations where a queue is allowed to place new game sessions. Locations are specified in the form of AWS Region codes, such as <code>us-west-2</code>. If this parameter is not set, game sessions can be placed in any queue location. </p>
        pub fn filter_configuration(mut self, input: crate::model::FilterConfiguration) -> Self {
            self.filter_configuration = Some(input);
            self
        }
        /// <p>A list of locations where a queue is allowed to place new game sessions. Locations are specified in the form of AWS Region codes, such as <code>us-west-2</code>. If this parameter is not set, game sessions can be placed in any queue location. </p>
        pub fn set_filter_configuration(
            mut self,
            input: std::option::Option<crate::model::FilterConfiguration>,
        ) -> Self {
            self.filter_configuration = input;
            self
        }
        /// <p>Custom settings to use when prioritizing destinations and locations for game session placements. This configuration replaces the FleetIQ default prioritization process. Priority types that are not explicitly named will be automatically applied at the end of the prioritization process. </p>
        pub fn priority_configuration(
            mut self,
            input: crate::model::PriorityConfiguration,
        ) -> Self {
            self.priority_configuration = Some(input);
            self
        }
        /// <p>Custom settings to use when prioritizing destinations and locations for game session placements. This configuration replaces the FleetIQ default prioritization process. Priority types that are not explicitly named will be automatically applied at the end of the prioritization process. </p>
        pub fn set_priority_configuration(
            mut self,
            input: std::option::Option<crate::model::PriorityConfiguration>,
        ) -> Self {
            self.priority_configuration = input;
            self
        }
        /// <p> Information to be added to all events that are related to this game session queue. </p>
        pub fn custom_event_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_event_data = Some(input.into());
            self
        }
        /// <p> Information to be added to all events that are related to this game session queue. </p>
        pub fn set_custom_event_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_event_data = input;
            self
        }
        /// <p>An SNS topic ARN that is set up to receive game session placement notifications. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queue-notification.html"> Setting up notifications for game session placement</a>.</p>
        pub fn notification_target(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_target = Some(input.into());
            self
        }
        /// <p>An SNS topic ARN that is set up to receive game session placement notifications. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queue-notification.html"> Setting up notifications for game session placement</a>.</p>
        pub fn set_notification_target(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_target = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of labels to assign to the new game session queue resource. Tags are developer-defined key-value pairs. Tagging AWS resources are useful for resource management, access management and cost allocation. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources</a> in the <i>AWS General Reference</i>. Once the resource is created, you can use <code>TagResource</code>, <code>UntagResource</code>, and <code>ListTagsForResource</code> to add, remove, and view tags. The maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of labels to assign to the new game session queue resource. Tags are developer-defined key-value pairs. Tagging AWS resources are useful for resource management, access management and cost allocation. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources</a> in the <i>AWS General Reference</i>. Once the resource is created, you can use <code>TagResource</code>, <code>UntagResource</code>, and <code>ListTagsForResource</code> to add, remove, and view tags. The maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGameSessionQueueInput`](crate::input::CreateGameSessionQueueInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateGameSessionQueueInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateGameSessionQueueInput {
                name: self.name,
                timeout_in_seconds: self.timeout_in_seconds,
                player_latency_policies: self.player_latency_policies,
                destinations: self.destinations,
                filter_configuration: self.filter_configuration,
                priority_configuration: self.priority_configuration,
                custom_event_data: self.custom_event_data,
                notification_target: self.notification_target,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateGameSessionQueueInputOperationOutputAlias = crate::operation::CreateGameSessionQueue;
#[doc(hidden)]
pub type CreateGameSessionQueueInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateGameSessionQueueInput {
    /// Consumes the builder and constructs an Operation<[`CreateGameSessionQueue`](crate::operation::CreateGameSessionQueue)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateGameSessionQueue,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateGameSessionQueueInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateGameSessionQueueInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateGameSessionQueueInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.CreateGameSessionQueue",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_game_session_queue(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateGameSessionQueue::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateGameSessionQueue",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateGameSessionQueueInput`](crate::input::CreateGameSessionQueueInput)
    pub fn builder() -> crate::input::create_game_session_queue_input::Builder {
        crate::input::create_game_session_queue_input::Builder::default()
    }
}

/// See [`CreateMatchmakingConfigurationInput`](crate::input::CreateMatchmakingConfigurationInput)
pub mod create_matchmaking_configuration_input {
    /// A builder for [`CreateMatchmakingConfigurationInput`](crate::input::CreateMatchmakingConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) game_session_queue_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) request_timeout_seconds: std::option::Option<i32>,
        pub(crate) acceptance_timeout_seconds: std::option::Option<i32>,
        pub(crate) acceptance_required: std::option::Option<bool>,
        pub(crate) rule_set_name: std::option::Option<std::string::String>,
        pub(crate) notification_target: std::option::Option<std::string::String>,
        pub(crate) additional_player_count: std::option::Option<i32>,
        pub(crate) custom_event_data: std::option::Option<std::string::String>,
        pub(crate) game_properties: std::option::Option<std::vec::Vec<crate::model::GameProperty>>,
        pub(crate) game_session_data: std::option::Option<std::string::String>,
        pub(crate) backfill_mode: std::option::Option<crate::model::BackfillMode>,
        pub(crate) flex_match_mode: std::option::Option<crate::model::FlexMatchMode>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>A unique identifier for the matchmaking configuration. This name is used to identify the configuration associated with a matchmaking request or ticket.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A unique identifier for the matchmaking configuration. This name is used to identify the configuration associated with a matchmaking request or ticket.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A human-readable description of the matchmaking configuration. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A human-readable description of the matchmaking configuration. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `game_session_queue_arns`.
        ///
        /// To override the contents of this collection use [`set_game_session_queue_arns`](Self::set_game_session_queue_arns).
        ///
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift game session queue resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::gamesessionqueue/
        /// <queue name></queue>
        /// </region></code>. Queues can be located in any Region. Queues are used to start new GameLift-hosted game sessions for matches that are created with this matchmaking configuration. If <code>FlexMatchMode</code> is set to <code>STANDALONE</code>, do not set this parameter. </p>
        pub fn game_session_queue_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.game_session_queue_arns.unwrap_or_default();
            v.push(input.into());
            self.game_session_queue_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift game session queue resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::gamesessionqueue/
        /// <queue name></queue>
        /// </region></code>. Queues can be located in any Region. Queues are used to start new GameLift-hosted game sessions for matches that are created with this matchmaking configuration. If <code>FlexMatchMode</code> is set to <code>STANDALONE</code>, do not set this parameter. </p>
        pub fn set_game_session_queue_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.game_session_queue_arns = input;
            self
        }
        /// <p>The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out. Requests that fail due to timing out can be resubmitted as needed.</p>
        pub fn request_timeout_seconds(mut self, input: i32) -> Self {
            self.request_timeout_seconds = Some(input);
            self
        }
        /// <p>The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out. Requests that fail due to timing out can be resubmitted as needed.</p>
        pub fn set_request_timeout_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.request_timeout_seconds = input;
            self
        }
        /// <p>The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required. </p>
        pub fn acceptance_timeout_seconds(mut self, input: i32) -> Self {
            self.acceptance_timeout_seconds = Some(input);
            self
        }
        /// <p>The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required. </p>
        pub fn set_acceptance_timeout_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.acceptance_timeout_seconds = input;
            self
        }
        /// <p>A flag that determines whether a match that was created with this configuration must be accepted by the matched players. To require acceptance, set to <code>TRUE</code>. With this option enabled, matchmaking tickets use the status <code>REQUIRES_ACCEPTANCE</code> to indicate when a completed potential match is waiting for player acceptance. </p>
        pub fn acceptance_required(mut self, input: bool) -> Self {
            self.acceptance_required = Some(input);
            self
        }
        /// <p>A flag that determines whether a match that was created with this configuration must be accepted by the matched players. To require acceptance, set to <code>TRUE</code>. With this option enabled, matchmaking tickets use the status <code>REQUIRES_ACCEPTANCE</code> to indicate when a completed potential match is waiting for player acceptance. </p>
        pub fn set_acceptance_required(mut self, input: std::option::Option<bool>) -> Self {
            self.acceptance_required = input;
            self
        }
        /// <p>A unique identifier for the matchmaking rule set to use with this configuration. You can use either the rule set name or ARN value. A matchmaking configuration can only use rule sets that are defined in the same Region.</p>
        pub fn rule_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_set_name = Some(input.into());
            self
        }
        /// <p>A unique identifier for the matchmaking rule set to use with this configuration. You can use either the rule set name or ARN value. A matchmaking configuration can only use rule sets that are defined in the same Region.</p>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rule_set_name = input;
            self
        }
        /// <p>An SNS topic ARN that is set up to receive matchmaking notifications. See <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html"> Setting up notifications for matchmaking</a> for more information.</p>
        pub fn notification_target(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_target = Some(input.into());
            self
        }
        /// <p>An SNS topic ARN that is set up to receive matchmaking notifications. See <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html"> Setting up notifications for matchmaking</a> for more information.</p>
        pub fn set_notification_target(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_target = input;
            self
        }
        /// <p>The number of player slots in a match to keep open for future players. For example, if the configuration's rule set specifies a match for a single 12-person team, and the additional player count is set to 2, only 10 players are selected for the match. This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
        pub fn additional_player_count(mut self, input: i32) -> Self {
            self.additional_player_count = Some(input);
            self
        }
        /// <p>The number of player slots in a match to keep open for future players. For example, if the configuration's rule set specifies a match for a single 12-person team, and the additional player count is set to 2, only 10 players are selected for the match. This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
        pub fn set_additional_player_count(mut self, input: std::option::Option<i32>) -> Self {
            self.additional_player_count = input;
            self
        }
        /// <p>Information to be added to all events related to this matchmaking configuration. </p>
        pub fn custom_event_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_event_data = Some(input.into());
            self
        }
        /// <p>Information to be added to all events related to this matchmaking configuration. </p>
        pub fn set_custom_event_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_event_data = input;
            self
        }
        /// Appends an item to `game_properties`.
        ///
        /// To override the contents of this collection use [`set_game_properties`](Self::set_game_properties).
        ///
        /// <p>A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). This information is added to the new <code>GameSession</code> object that is created for a successful match. This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
        pub fn game_properties(mut self, input: crate::model::GameProperty) -> Self {
            let mut v = self.game_properties.unwrap_or_default();
            v.push(input);
            self.game_properties = Some(v);
            self
        }
        /// <p>A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). This information is added to the new <code>GameSession</code> object that is created for a successful match. This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
        pub fn set_game_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GameProperty>>,
        ) -> Self {
            self.game_properties = input;
            self
        }
        /// <p>A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). This information is added to the new <code>GameSession</code> object that is created for a successful match. This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
        pub fn game_session_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_session_data = Some(input.into());
            self
        }
        /// <p>A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). This information is added to the new <code>GameSession</code> object that is created for a successful match. This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
        pub fn set_game_session_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_session_data = input;
            self
        }
        /// <p>The method used to backfill game sessions that are created with this matchmaking configuration. Specify <code>MANUAL</code> when your game manages backfill requests manually or does not use the match backfill feature. Specify <code>AUTOMATIC</code> to have GameLift create a <code>StartMatchBackfill</code> request whenever a game session has one or more open slots. Learn more about manual and automatic backfill in <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html"> Backfill Existing Games with FlexMatch</a>. Automatic backfill is not available when <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
        pub fn backfill_mode(mut self, input: crate::model::BackfillMode) -> Self {
            self.backfill_mode = Some(input);
            self
        }
        /// <p>The method used to backfill game sessions that are created with this matchmaking configuration. Specify <code>MANUAL</code> when your game manages backfill requests manually or does not use the match backfill feature. Specify <code>AUTOMATIC</code> to have GameLift create a <code>StartMatchBackfill</code> request whenever a game session has one or more open slots. Learn more about manual and automatic backfill in <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html"> Backfill Existing Games with FlexMatch</a>. Automatic backfill is not available when <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
        pub fn set_backfill_mode(
            mut self,
            input: std::option::Option<crate::model::BackfillMode>,
        ) -> Self {
            self.backfill_mode = input;
            self
        }
        /// <p>Indicates whether this matchmaking configuration is being used with GameLift hosting or as a standalone matchmaking solution. </p>
        /// <ul>
        /// <li> <p> <b>STANDALONE</b> - FlexMatch forms matches and returns match information, including players and team assignments, in a <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html#match-events-matchmakingsucceeded"> MatchmakingSucceeded</a> event.</p> </li>
        /// <li> <p> <b>WITH_QUEUE</b> - FlexMatch forms matches and uses the specified GameLift queue to start a game session for the match. </p> </li>
        /// </ul>
        pub fn flex_match_mode(mut self, input: crate::model::FlexMatchMode) -> Self {
            self.flex_match_mode = Some(input);
            self
        }
        /// <p>Indicates whether this matchmaking configuration is being used with GameLift hosting or as a standalone matchmaking solution. </p>
        /// <ul>
        /// <li> <p> <b>STANDALONE</b> - FlexMatch forms matches and returns match information, including players and team assignments, in a <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html#match-events-matchmakingsucceeded"> MatchmakingSucceeded</a> event.</p> </li>
        /// <li> <p> <b>WITH_QUEUE</b> - FlexMatch forms matches and uses the specified GameLift queue to start a game session for the match. </p> </li>
        /// </ul>
        pub fn set_flex_match_mode(
            mut self,
            input: std::option::Option<crate::model::FlexMatchMode>,
        ) -> Self {
            self.flex_match_mode = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of labels to assign to the new matchmaking configuration resource. Tags are developer-defined key-value pairs. Tagging AWS resources are useful for resource management, access management and cost allocation. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources</a> in the <i>AWS General Reference</i>. Once the resource is created, you can use <code>TagResource</code>, <code>UntagResource</code>, and <code>ListTagsForResource</code> to add, remove, and view tags. The maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of labels to assign to the new matchmaking configuration resource. Tags are developer-defined key-value pairs. Tagging AWS resources are useful for resource management, access management and cost allocation. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources</a> in the <i>AWS General Reference</i>. Once the resource is created, you can use <code>TagResource</code>, <code>UntagResource</code>, and <code>ListTagsForResource</code> to add, remove, and view tags. The maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMatchmakingConfigurationInput`](crate::input::CreateMatchmakingConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateMatchmakingConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateMatchmakingConfigurationInput {
                name: self.name,
                description: self.description,
                game_session_queue_arns: self.game_session_queue_arns,
                request_timeout_seconds: self.request_timeout_seconds,
                acceptance_timeout_seconds: self.acceptance_timeout_seconds,
                acceptance_required: self.acceptance_required,
                rule_set_name: self.rule_set_name,
                notification_target: self.notification_target,
                additional_player_count: self.additional_player_count,
                custom_event_data: self.custom_event_data,
                game_properties: self.game_properties,
                game_session_data: self.game_session_data,
                backfill_mode: self.backfill_mode,
                flex_match_mode: self.flex_match_mode,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateMatchmakingConfigurationInputOperationOutputAlias =
    crate::operation::CreateMatchmakingConfiguration;
#[doc(hidden)]
pub type CreateMatchmakingConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateMatchmakingConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`CreateMatchmakingConfiguration`](crate::operation::CreateMatchmakingConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateMatchmakingConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateMatchmakingConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateMatchmakingConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateMatchmakingConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.CreateMatchmakingConfiguration",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_matchmaking_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateMatchmakingConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateMatchmakingConfiguration",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateMatchmakingConfigurationInput`](crate::input::CreateMatchmakingConfigurationInput)
    pub fn builder() -> crate::input::create_matchmaking_configuration_input::Builder {
        crate::input::create_matchmaking_configuration_input::Builder::default()
    }
}

/// See [`CreateMatchmakingRuleSetInput`](crate::input::CreateMatchmakingRuleSetInput)
pub mod create_matchmaking_rule_set_input {
    /// A builder for [`CreateMatchmakingRuleSetInput`](crate::input::CreateMatchmakingRuleSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) rule_set_body: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>A unique identifier for the matchmaking rule set. A matchmaking configuration identifies the rule set it uses by this name value. Note that the rule set name is different from the optional <code>name</code> field in the rule set body.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A unique identifier for the matchmaking rule set. A matchmaking configuration identifies the rule set it uses by this name value. Note that the rule set name is different from the optional <code>name</code> field in the rule set body.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A collection of matchmaking rules, formatted as a JSON string. Comments are not allowed in JSON, but most elements support a description field.</p>
        pub fn rule_set_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_set_body = Some(input.into());
            self
        }
        /// <p>A collection of matchmaking rules, formatted as a JSON string. Comments are not allowed in JSON, but most elements support a description field.</p>
        pub fn set_rule_set_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rule_set_body = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of labels to assign to the new matchmaking rule set resource. Tags are developer-defined key-value pairs. Tagging AWS resources are useful for resource management, access management and cost allocation. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources</a> in the <i>AWS General Reference</i>. Once the resource is created, you can use <code>TagResource</code>, <code>UntagResource</code>, and <code>ListTagsForResource</code> to add, remove, and view tags. The maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of labels to assign to the new matchmaking rule set resource. Tags are developer-defined key-value pairs. Tagging AWS resources are useful for resource management, access management and cost allocation. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources</a> in the <i>AWS General Reference</i>. Once the resource is created, you can use <code>TagResource</code>, <code>UntagResource</code>, and <code>ListTagsForResource</code> to add, remove, and view tags. The maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMatchmakingRuleSetInput`](crate::input::CreateMatchmakingRuleSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateMatchmakingRuleSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateMatchmakingRuleSetInput {
                name: self.name,
                rule_set_body: self.rule_set_body,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateMatchmakingRuleSetInputOperationOutputAlias =
    crate::operation::CreateMatchmakingRuleSet;
#[doc(hidden)]
pub type CreateMatchmakingRuleSetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateMatchmakingRuleSetInput {
    /// Consumes the builder and constructs an Operation<[`CreateMatchmakingRuleSet`](crate::operation::CreateMatchmakingRuleSet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateMatchmakingRuleSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateMatchmakingRuleSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateMatchmakingRuleSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateMatchmakingRuleSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.CreateMatchmakingRuleSet",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_matchmaking_rule_set(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateMatchmakingRuleSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateMatchmakingRuleSet",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateMatchmakingRuleSetInput`](crate::input::CreateMatchmakingRuleSetInput)
    pub fn builder() -> crate::input::create_matchmaking_rule_set_input::Builder {
        crate::input::create_matchmaking_rule_set_input::Builder::default()
    }
}

/// See [`CreatePlayerSessionInput`](crate::input::CreatePlayerSessionInput)
pub mod create_player_session_input {
    /// A builder for [`CreatePlayerSessionInput`](crate::input::CreatePlayerSessionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_session_id: std::option::Option<std::string::String>,
        pub(crate) player_id: std::option::Option<std::string::String>,
        pub(crate) player_data: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the game session to add a player to.</p>
        pub fn game_session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_session_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the game session to add a player to.</p>
        pub fn set_game_session_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_session_id = input;
            self
        }
        /// <p>A unique identifier for a player. Player IDs are developer-defined.</p>
        pub fn player_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.player_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a player. Player IDs are developer-defined.</p>
        pub fn set_player_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.player_id = input;
            self
        }
        /// <p>Developer-defined information related to a player. GameLift does not use this data, so it can be formatted as needed for use in the game.</p>
        pub fn player_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.player_data = Some(input.into());
            self
        }
        /// <p>Developer-defined information related to a player. GameLift does not use this data, so it can be formatted as needed for use in the game.</p>
        pub fn set_player_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.player_data = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePlayerSessionInput`](crate::input::CreatePlayerSessionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePlayerSessionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePlayerSessionInput {
                game_session_id: self.game_session_id,
                player_id: self.player_id,
                player_data: self.player_data,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePlayerSessionInputOperationOutputAlias = crate::operation::CreatePlayerSession;
#[doc(hidden)]
pub type CreatePlayerSessionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreatePlayerSessionInput {
    /// Consumes the builder and constructs an Operation<[`CreatePlayerSession`](crate::operation::CreatePlayerSession)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePlayerSession,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreatePlayerSessionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreatePlayerSessionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreatePlayerSessionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.CreatePlayerSession",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_player_session(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePlayerSession::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePlayerSession",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreatePlayerSessionInput`](crate::input::CreatePlayerSessionInput)
    pub fn builder() -> crate::input::create_player_session_input::Builder {
        crate::input::create_player_session_input::Builder::default()
    }
}

/// See [`CreatePlayerSessionsInput`](crate::input::CreatePlayerSessionsInput)
pub mod create_player_sessions_input {
    /// A builder for [`CreatePlayerSessionsInput`](crate::input::CreatePlayerSessionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_session_id: std::option::Option<std::string::String>,
        pub(crate) player_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) player_data_map: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>A unique identifier for the game session to add players to.</p>
        pub fn game_session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_session_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the game session to add players to.</p>
        pub fn set_game_session_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_session_id = input;
            self
        }
        /// Appends an item to `player_ids`.
        ///
        /// To override the contents of this collection use [`set_player_ids`](Self::set_player_ids).
        ///
        /// <p>List of unique identifiers for the players to be added.</p>
        pub fn player_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.player_ids.unwrap_or_default();
            v.push(input.into());
            self.player_ids = Some(v);
            self
        }
        /// <p>List of unique identifiers for the players to be added.</p>
        pub fn set_player_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.player_ids = input;
            self
        }
        /// Adds a key-value pair to `player_data_map`.
        ///
        /// To override the contents of this collection use [`set_player_data_map`](Self::set_player_data_map).
        ///
        /// <p>Map of string pairs, each specifying a player ID and a set of developer-defined information related to the player. Amazon GameLift does not use this data, so it can be formatted as needed for use in the game. Any player data strings for player IDs that are not included in the <code>PlayerIds</code> parameter are ignored. </p>
        pub fn player_data_map(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.player_data_map.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.player_data_map = Some(hash_map);
            self
        }
        /// <p>Map of string pairs, each specifying a player ID and a set of developer-defined information related to the player. Amazon GameLift does not use this data, so it can be formatted as needed for use in the game. Any player data strings for player IDs that are not included in the <code>PlayerIds</code> parameter are ignored. </p>
        pub fn set_player_data_map(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.player_data_map = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePlayerSessionsInput`](crate::input::CreatePlayerSessionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePlayerSessionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePlayerSessionsInput {
                game_session_id: self.game_session_id,
                player_ids: self.player_ids,
                player_data_map: self.player_data_map,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePlayerSessionsInputOperationOutputAlias = crate::operation::CreatePlayerSessions;
#[doc(hidden)]
pub type CreatePlayerSessionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreatePlayerSessionsInput {
    /// Consumes the builder and constructs an Operation<[`CreatePlayerSessions`](crate::operation::CreatePlayerSessions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePlayerSessions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreatePlayerSessionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreatePlayerSessionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreatePlayerSessionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.CreatePlayerSessions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_player_sessions(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePlayerSessions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePlayerSessions",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreatePlayerSessionsInput`](crate::input::CreatePlayerSessionsInput)
    pub fn builder() -> crate::input::create_player_sessions_input::Builder {
        crate::input::create_player_sessions_input::Builder::default()
    }
}

/// See [`CreateScriptInput`](crate::input::CreateScriptInput)
pub mod create_script_input {
    /// A builder for [`CreateScriptInput`](crate::input::CreateScriptInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) storage_location: std::option::Option<crate::model::S3Location>,
        pub(crate) zip_file: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>A descriptive label that is associated with a script. Script names do not need to be unique. You can use <code>UpdateScript</code> to change this value later. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A descriptive label that is associated with a script. Script names do not need to be unique. You can use <code>UpdateScript</code> to change this value later. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Version information that is associated with a build or script. Version strings do not need to be unique. You can use <code>UpdateScript</code> to change this value later. </p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>Version information that is associated with a build or script. Version strings do not need to be unique. You can use <code>UpdateScript</code> to change this value later. </p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The location of the Amazon S3 bucket where a zipped file containing your Realtime scripts is stored. The storage location must specify the Amazon S3 bucket name, the zip file name (the "key"), and a role ARN that allows Amazon GameLift to access the Amazon S3 storage location. The S3 bucket must be in the same Region where you want to create a new script. By default, Amazon GameLift uploads the latest version of the zip file; if you have S3 object versioning turned on, you can use the <code>ObjectVersion</code> parameter to specify an earlier version. </p>
        pub fn storage_location(mut self, input: crate::model::S3Location) -> Self {
            self.storage_location = Some(input);
            self
        }
        /// <p>The location of the Amazon S3 bucket where a zipped file containing your Realtime scripts is stored. The storage location must specify the Amazon S3 bucket name, the zip file name (the "key"), and a role ARN that allows Amazon GameLift to access the Amazon S3 storage location. The S3 bucket must be in the same Region where you want to create a new script. By default, Amazon GameLift uploads the latest version of the zip file; if you have S3 object versioning turned on, you can use the <code>ObjectVersion</code> parameter to specify an earlier version. </p>
        pub fn set_storage_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.storage_location = input;
            self
        }
        /// <p>A data object containing your Realtime scripts and dependencies as a zip file. The zip file can have one or multiple files. Maximum size of a zip file is 5 MB.</p>
        /// <p>When using the AWS CLI tool to create a script, this parameter is set to the zip file name. It must be prepended with the string "fileb://" to indicate that the file data is a binary object. For example: <code>--zip-file fileb://myRealtimeScript.zip</code>.</p>
        pub fn zip_file(mut self, input: aws_smithy_types::Blob) -> Self {
            self.zip_file = Some(input);
            self
        }
        /// <p>A data object containing your Realtime scripts and dependencies as a zip file. The zip file can have one or multiple files. Maximum size of a zip file is 5 MB.</p>
        /// <p>When using the AWS CLI tool to create a script, this parameter is set to the zip file name. It must be prepended with the string "fileb://" to indicate that the file data is a binary object. For example: <code>--zip-file fileb://myRealtimeScript.zip</code>.</p>
        pub fn set_zip_file(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.zip_file = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of labels to assign to the new script resource. Tags are developer-defined key-value pairs. Tagging AWS resources are useful for resource management, access management and cost allocation. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources</a> in the <i>AWS General Reference</i>. Once the resource is created, you can use <code>TagResource</code>, <code>UntagResource</code>, and <code>ListTagsForResource</code> to add, remove, and view tags. The maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of labels to assign to the new script resource. Tags are developer-defined key-value pairs. Tagging AWS resources are useful for resource management, access management and cost allocation. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources</a> in the <i>AWS General Reference</i>. Once the resource is created, you can use <code>TagResource</code>, <code>UntagResource</code>, and <code>ListTagsForResource</code> to add, remove, and view tags. The maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateScriptInput`](crate::input::CreateScriptInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateScriptInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateScriptInput {
                name: self.name,
                version: self.version,
                storage_location: self.storage_location,
                zip_file: self.zip_file,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateScriptInputOperationOutputAlias = crate::operation::CreateScript;
#[doc(hidden)]
pub type CreateScriptInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateScriptInput {
    /// Consumes the builder and constructs an Operation<[`CreateScript`](crate::operation::CreateScript)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateScript,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateScriptInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateScriptInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateScriptInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.CreateScript",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_script(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateScript::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateScript",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateScriptInput`](crate::input::CreateScriptInput)
    pub fn builder() -> crate::input::create_script_input::Builder {
        crate::input::create_script_input::Builder::default()
    }
}

/// See [`CreateVpcPeeringAuthorizationInput`](crate::input::CreateVpcPeeringAuthorizationInput)
pub mod create_vpc_peering_authorization_input {
    /// A builder for [`CreateVpcPeeringAuthorizationInput`](crate::input::CreateVpcPeeringAuthorizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_lift_aws_account_id: std::option::Option<std::string::String>,
        pub(crate) peer_vpc_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the AWS account that you use to manage your GameLift fleet. You can find your Account ID in the AWS Management Console under account settings.</p>
        pub fn game_lift_aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_lift_aws_account_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the AWS account that you use to manage your GameLift fleet. You can find your Account ID in the AWS Management Console under account settings.</p>
        pub fn set_game_lift_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_lift_aws_account_id = input;
            self
        }
        /// <p>A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in the same Region as your fleet. To look up a VPC ID, use the <a href="https://console.aws.amazon.com/vpc/">VPC Dashboard</a> in the AWS Management Console. Learn more about VPC peering in <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift Fleets</a>.</p>
        pub fn peer_vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.peer_vpc_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in the same Region as your fleet. To look up a VPC ID, use the <a href="https://console.aws.amazon.com/vpc/">VPC Dashboard</a> in the AWS Management Console. Learn more about VPC peering in <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift Fleets</a>.</p>
        pub fn set_peer_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.peer_vpc_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateVpcPeeringAuthorizationInput`](crate::input::CreateVpcPeeringAuthorizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateVpcPeeringAuthorizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateVpcPeeringAuthorizationInput {
                game_lift_aws_account_id: self.game_lift_aws_account_id,
                peer_vpc_id: self.peer_vpc_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateVpcPeeringAuthorizationInputOperationOutputAlias =
    crate::operation::CreateVpcPeeringAuthorization;
#[doc(hidden)]
pub type CreateVpcPeeringAuthorizationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateVpcPeeringAuthorizationInput {
    /// Consumes the builder and constructs an Operation<[`CreateVpcPeeringAuthorization`](crate::operation::CreateVpcPeeringAuthorization)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateVpcPeeringAuthorization,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateVpcPeeringAuthorizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateVpcPeeringAuthorizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateVpcPeeringAuthorizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.CreateVpcPeeringAuthorization",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_vpc_peering_authorization(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateVpcPeeringAuthorization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateVpcPeeringAuthorization",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateVpcPeeringAuthorizationInput`](crate::input::CreateVpcPeeringAuthorizationInput)
    pub fn builder() -> crate::input::create_vpc_peering_authorization_input::Builder {
        crate::input::create_vpc_peering_authorization_input::Builder::default()
    }
}

/// See [`CreateVpcPeeringConnectionInput`](crate::input::CreateVpcPeeringConnectionInput)
pub mod create_vpc_peering_connection_input {
    /// A builder for [`CreateVpcPeeringConnectionInput`](crate::input::CreateVpcPeeringConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) peer_vpc_aws_account_id: std::option::Option<std::string::String>,
        pub(crate) peer_vpc_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet. You can use either the fleet ID or ARN value. This tells Amazon GameLift which GameLift VPC to peer with. </p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet. You can use either the fleet ID or ARN value. This tells Amazon GameLift which GameLift VPC to peer with. </p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p>A unique identifier for the AWS account with the VPC that you want to peer your Amazon GameLift fleet with. You can find your Account ID in the AWS Management Console under account settings.</p>
        pub fn peer_vpc_aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.peer_vpc_aws_account_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the AWS account with the VPC that you want to peer your Amazon GameLift fleet with. You can find your Account ID in the AWS Management Console under account settings.</p>
        pub fn set_peer_vpc_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.peer_vpc_aws_account_id = input;
            self
        }
        /// <p>A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in the same Region as your fleet. To look up a VPC ID, use the <a href="https://console.aws.amazon.com/vpc/">VPC Dashboard</a> in the AWS Management Console. Learn more about VPC peering in <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift Fleets</a>.</p>
        pub fn peer_vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.peer_vpc_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in the same Region as your fleet. To look up a VPC ID, use the <a href="https://console.aws.amazon.com/vpc/">VPC Dashboard</a> in the AWS Management Console. Learn more about VPC peering in <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift Fleets</a>.</p>
        pub fn set_peer_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.peer_vpc_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateVpcPeeringConnectionInput`](crate::input::CreateVpcPeeringConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateVpcPeeringConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateVpcPeeringConnectionInput {
                fleet_id: self.fleet_id,
                peer_vpc_aws_account_id: self.peer_vpc_aws_account_id,
                peer_vpc_id: self.peer_vpc_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateVpcPeeringConnectionInputOperationOutputAlias =
    crate::operation::CreateVpcPeeringConnection;
#[doc(hidden)]
pub type CreateVpcPeeringConnectionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateVpcPeeringConnectionInput {
    /// Consumes the builder and constructs an Operation<[`CreateVpcPeeringConnection`](crate::operation::CreateVpcPeeringConnection)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateVpcPeeringConnection,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateVpcPeeringConnectionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateVpcPeeringConnectionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateVpcPeeringConnectionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.CreateVpcPeeringConnection",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_vpc_peering_connection(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateVpcPeeringConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateVpcPeeringConnection",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateVpcPeeringConnectionInput`](crate::input::CreateVpcPeeringConnectionInput)
    pub fn builder() -> crate::input::create_vpc_peering_connection_input::Builder {
        crate::input::create_vpc_peering_connection_input::Builder::default()
    }
}

/// See [`DeleteAliasInput`](crate::input::DeleteAliasInput)
pub mod delete_alias_input {
    /// A builder for [`DeleteAliasInput`](crate::input::DeleteAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alias_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier of the alias that you want to delete. You can use either the alias ID or ARN value.</p>
        pub fn alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_id = Some(input.into());
            self
        }
        /// <p>A unique identifier of the alias that you want to delete. You can use either the alias ID or ARN value.</p>
        pub fn set_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAliasInput`](crate::input::DeleteAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAliasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAliasInput {
                alias_id: self.alias_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAliasInputOperationOutputAlias = crate::operation::DeleteAlias;
#[doc(hidden)]
pub type DeleteAliasInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAliasInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAlias`](crate::operation::DeleteAlias)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAlias,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAliasInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAliasInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAliasInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DeleteAlias",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_alias(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAlias::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAlias",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAliasInput`](crate::input::DeleteAliasInput)
    pub fn builder() -> crate::input::delete_alias_input::Builder {
        crate::input::delete_alias_input::Builder::default()
    }
}

/// See [`DeleteBuildInput`](crate::input::DeleteBuildInput)
pub mod delete_build_input {
    /// A builder for [`DeleteBuildInput`](crate::input::DeleteBuildInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) build_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the build to delete. You can use either the build ID or ARN value. </p>
        pub fn build_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.build_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the build to delete. You can use either the build ID or ARN value. </p>
        pub fn set_build_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.build_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBuildInput`](crate::input::DeleteBuildInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBuildInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBuildInput {
                build_id: self.build_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBuildInputOperationOutputAlias = crate::operation::DeleteBuild;
#[doc(hidden)]
pub type DeleteBuildInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBuildInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBuild`](crate::operation::DeleteBuild)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBuild,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBuildInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBuildInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBuildInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DeleteBuild",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_build(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBuild::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBuild",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBuildInput`](crate::input::DeleteBuildInput)
    pub fn builder() -> crate::input::delete_build_input::Builder {
        crate::input::delete_build_input::Builder::default()
    }
}

/// See [`DeleteFleetInput`](crate::input::DeleteFleetInput)
pub mod delete_fleet_input {
    /// A builder for [`DeleteFleetInput`](crate::input::DeleteFleetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet to be deleted. You can use either the fleet ID or ARN value.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet to be deleted. You can use either the fleet ID or ARN value.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFleetInput`](crate::input::DeleteFleetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFleetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFleetInput {
                fleet_id: self.fleet_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFleetInputOperationOutputAlias = crate::operation::DeleteFleet;
#[doc(hidden)]
pub type DeleteFleetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteFleetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFleet`](crate::operation::DeleteFleet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFleet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteFleetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteFleetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteFleetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DeleteFleet",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_fleet(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFleet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFleet",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteFleetInput`](crate::input::DeleteFleetInput)
    pub fn builder() -> crate::input::delete_fleet_input::Builder {
        crate::input::delete_fleet_input::Builder::default()
    }
}

/// See [`DeleteFleetLocationsInput`](crate::input::DeleteFleetLocationsInput)
pub mod delete_fleet_locations_input {
    /// A builder for [`DeleteFleetLocationsInput`](crate::input::DeleteFleetLocationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) locations: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet to delete locations for. You can use either the fleet ID or ARN value.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet to delete locations for. You can use either the fleet ID or ARN value.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// Appends an item to `locations`.
        ///
        /// To override the contents of this collection use [`set_locations`](Self::set_locations).
        ///
        /// <p>The list of fleet locations to delete. Specify locations in the form of an AWS Region code, such as <code>us-west-2</code>.</p>
        pub fn locations(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.locations.unwrap_or_default();
            v.push(input.into());
            self.locations = Some(v);
            self
        }
        /// <p>The list of fleet locations to delete. Specify locations in the form of an AWS Region code, such as <code>us-west-2</code>.</p>
        pub fn set_locations(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.locations = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFleetLocationsInput`](crate::input::DeleteFleetLocationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFleetLocationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFleetLocationsInput {
                fleet_id: self.fleet_id,
                locations: self.locations,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFleetLocationsInputOperationOutputAlias = crate::operation::DeleteFleetLocations;
#[doc(hidden)]
pub type DeleteFleetLocationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteFleetLocationsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFleetLocations`](crate::operation::DeleteFleetLocations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFleetLocations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteFleetLocationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteFleetLocationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteFleetLocationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DeleteFleetLocations",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_fleet_locations(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFleetLocations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFleetLocations",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteFleetLocationsInput`](crate::input::DeleteFleetLocationsInput)
    pub fn builder() -> crate::input::delete_fleet_locations_input::Builder {
        crate::input::delete_fleet_locations_input::Builder::default()
    }
}

/// See [`DeleteGameServerGroupInput`](crate::input::DeleteGameServerGroupInput)
pub mod delete_game_server_group_input {
    /// A builder for [`DeleteGameServerGroupInput`](crate::input::DeleteGameServerGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_server_group_name: std::option::Option<std::string::String>,
        pub(crate) delete_option: std::option::Option<crate::model::GameServerGroupDeleteOption>,
    }
    impl Builder {
        /// <p>A unique identifier for the game server group. Use either the <code>GameServerGroup</code> name or ARN value.</p>
        pub fn game_server_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_server_group_name = Some(input.into());
            self
        }
        /// <p>A unique identifier for the game server group. Use either the <code>GameServerGroup</code> name or ARN value.</p>
        pub fn set_game_server_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_server_group_name = input;
            self
        }
        /// <p>The type of delete to perform. Options include the following:</p>
        /// <ul>
        /// <li> <p> <code>SAFE_DELETE</code> – (default) Terminates the game server group and EC2 Auto Scaling group only when it has no game servers that are in <code>UTILIZED</code> status.</p> </li>
        /// <li> <p> <code>FORCE_DELETE</code> – Terminates the game server group, including all active game servers regardless of their utilization status, and the EC2 Auto Scaling group. </p> </li>
        /// <li> <p> <code>RETAIN</code> – Does a safe delete of the game server group but retains the EC2 Auto Scaling group as is.</p> </li>
        /// </ul>
        pub fn delete_option(mut self, input: crate::model::GameServerGroupDeleteOption) -> Self {
            self.delete_option = Some(input);
            self
        }
        /// <p>The type of delete to perform. Options include the following:</p>
        /// <ul>
        /// <li> <p> <code>SAFE_DELETE</code> – (default) Terminates the game server group and EC2 Auto Scaling group only when it has no game servers that are in <code>UTILIZED</code> status.</p> </li>
        /// <li> <p> <code>FORCE_DELETE</code> – Terminates the game server group, including all active game servers regardless of their utilization status, and the EC2 Auto Scaling group. </p> </li>
        /// <li> <p> <code>RETAIN</code> – Does a safe delete of the game server group but retains the EC2 Auto Scaling group as is.</p> </li>
        /// </ul>
        pub fn set_delete_option(
            mut self,
            input: std::option::Option<crate::model::GameServerGroupDeleteOption>,
        ) -> Self {
            self.delete_option = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGameServerGroupInput`](crate::input::DeleteGameServerGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteGameServerGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteGameServerGroupInput {
                game_server_group_name: self.game_server_group_name,
                delete_option: self.delete_option,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteGameServerGroupInputOperationOutputAlias = crate::operation::DeleteGameServerGroup;
#[doc(hidden)]
pub type DeleteGameServerGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteGameServerGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteGameServerGroup`](crate::operation::DeleteGameServerGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteGameServerGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteGameServerGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteGameServerGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteGameServerGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DeleteGameServerGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_game_server_group(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteGameServerGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteGameServerGroup",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteGameServerGroupInput`](crate::input::DeleteGameServerGroupInput)
    pub fn builder() -> crate::input::delete_game_server_group_input::Builder {
        crate::input::delete_game_server_group_input::Builder::default()
    }
}

/// See [`DeleteGameSessionQueueInput`](crate::input::DeleteGameSessionQueueInput)
pub mod delete_game_session_queue_input {
    /// A builder for [`DeleteGameSessionQueueInput`](crate::input::DeleteGameSessionQueueInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A descriptive label that is associated with game session queue. Queue names must be unique within each Region. You can use either the queue ID or ARN value. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A descriptive label that is associated with game session queue. Queue names must be unique within each Region. You can use either the queue ID or ARN value. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGameSessionQueueInput`](crate::input::DeleteGameSessionQueueInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteGameSessionQueueInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteGameSessionQueueInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteGameSessionQueueInputOperationOutputAlias = crate::operation::DeleteGameSessionQueue;
#[doc(hidden)]
pub type DeleteGameSessionQueueInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteGameSessionQueueInput {
    /// Consumes the builder and constructs an Operation<[`DeleteGameSessionQueue`](crate::operation::DeleteGameSessionQueue)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteGameSessionQueue,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteGameSessionQueueInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteGameSessionQueueInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteGameSessionQueueInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DeleteGameSessionQueue",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_game_session_queue(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteGameSessionQueue::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteGameSessionQueue",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteGameSessionQueueInput`](crate::input::DeleteGameSessionQueueInput)
    pub fn builder() -> crate::input::delete_game_session_queue_input::Builder {
        crate::input::delete_game_session_queue_input::Builder::default()
    }
}

/// See [`DeleteMatchmakingConfigurationInput`](crate::input::DeleteMatchmakingConfigurationInput)
pub mod delete_matchmaking_configuration_input {
    /// A builder for [`DeleteMatchmakingConfigurationInput`](crate::input::DeleteMatchmakingConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the matchmaking configuration. You can use either the configuration name or ARN value.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A unique identifier for the matchmaking configuration. You can use either the configuration name or ARN value.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMatchmakingConfigurationInput`](crate::input::DeleteMatchmakingConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteMatchmakingConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteMatchmakingConfigurationInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteMatchmakingConfigurationInputOperationOutputAlias =
    crate::operation::DeleteMatchmakingConfiguration;
#[doc(hidden)]
pub type DeleteMatchmakingConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteMatchmakingConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteMatchmakingConfiguration`](crate::operation::DeleteMatchmakingConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteMatchmakingConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteMatchmakingConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteMatchmakingConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteMatchmakingConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DeleteMatchmakingConfiguration",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_matchmaking_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteMatchmakingConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteMatchmakingConfiguration",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteMatchmakingConfigurationInput`](crate::input::DeleteMatchmakingConfigurationInput)
    pub fn builder() -> crate::input::delete_matchmaking_configuration_input::Builder {
        crate::input::delete_matchmaking_configuration_input::Builder::default()
    }
}

/// See [`DeleteMatchmakingRuleSetInput`](crate::input::DeleteMatchmakingRuleSetInput)
pub mod delete_matchmaking_rule_set_input {
    /// A builder for [`DeleteMatchmakingRuleSetInput`](crate::input::DeleteMatchmakingRuleSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the matchmaking rule set to be deleted. (Note: The rule set name is different from the optional "name" field in the rule set body.) You can use either the rule set name or ARN value.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A unique identifier for the matchmaking rule set to be deleted. (Note: The rule set name is different from the optional "name" field in the rule set body.) You can use either the rule set name or ARN value.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMatchmakingRuleSetInput`](crate::input::DeleteMatchmakingRuleSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteMatchmakingRuleSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteMatchmakingRuleSetInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteMatchmakingRuleSetInputOperationOutputAlias =
    crate::operation::DeleteMatchmakingRuleSet;
#[doc(hidden)]
pub type DeleteMatchmakingRuleSetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteMatchmakingRuleSetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteMatchmakingRuleSet`](crate::operation::DeleteMatchmakingRuleSet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteMatchmakingRuleSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteMatchmakingRuleSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteMatchmakingRuleSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteMatchmakingRuleSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DeleteMatchmakingRuleSet",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_matchmaking_rule_set(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteMatchmakingRuleSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteMatchmakingRuleSet",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteMatchmakingRuleSetInput`](crate::input::DeleteMatchmakingRuleSetInput)
    pub fn builder() -> crate::input::delete_matchmaking_rule_set_input::Builder {
        crate::input::delete_matchmaking_rule_set_input::Builder::default()
    }
}

/// See [`DeleteScalingPolicyInput`](crate::input::DeleteScalingPolicyInput)
pub mod delete_scaling_policy_input {
    /// A builder for [`DeleteScalingPolicyInput`](crate::input::DeleteScalingPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) fleet_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A descriptive label that is associated with a fleet's scaling policy. Policy names do not need to be unique.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A descriptive label that is associated with a fleet's scaling policy. Policy names do not need to be unique.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A unique identifier for the fleet to be deleted. You can use either the fleet ID or ARN value.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet to be deleted. You can use either the fleet ID or ARN value.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteScalingPolicyInput`](crate::input::DeleteScalingPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteScalingPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteScalingPolicyInput {
                name: self.name,
                fleet_id: self.fleet_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteScalingPolicyInputOperationOutputAlias = crate::operation::DeleteScalingPolicy;
#[doc(hidden)]
pub type DeleteScalingPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteScalingPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteScalingPolicy`](crate::operation::DeleteScalingPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteScalingPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteScalingPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteScalingPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteScalingPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DeleteScalingPolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_scaling_policy(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteScalingPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteScalingPolicy",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteScalingPolicyInput`](crate::input::DeleteScalingPolicyInput)
    pub fn builder() -> crate::input::delete_scaling_policy_input::Builder {
        crate::input::delete_scaling_policy_input::Builder::default()
    }
}

/// See [`DeleteScriptInput`](crate::input::DeleteScriptInput)
pub mod delete_script_input {
    /// A builder for [`DeleteScriptInput`](crate::input::DeleteScriptInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) script_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the Realtime script to delete. You can use either the script ID or ARN value.</p>
        pub fn script_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.script_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the Realtime script to delete. You can use either the script ID or ARN value.</p>
        pub fn set_script_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.script_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteScriptInput`](crate::input::DeleteScriptInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteScriptInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteScriptInput {
                script_id: self.script_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteScriptInputOperationOutputAlias = crate::operation::DeleteScript;
#[doc(hidden)]
pub type DeleteScriptInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteScriptInput {
    /// Consumes the builder and constructs an Operation<[`DeleteScript`](crate::operation::DeleteScript)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteScript,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteScriptInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteScriptInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteScriptInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DeleteScript",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_script(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteScript::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteScript",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteScriptInput`](crate::input::DeleteScriptInput)
    pub fn builder() -> crate::input::delete_script_input::Builder {
        crate::input::delete_script_input::Builder::default()
    }
}

/// See [`DeleteVpcPeeringAuthorizationInput`](crate::input::DeleteVpcPeeringAuthorizationInput)
pub mod delete_vpc_peering_authorization_input {
    /// A builder for [`DeleteVpcPeeringAuthorizationInput`](crate::input::DeleteVpcPeeringAuthorizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_lift_aws_account_id: std::option::Option<std::string::String>,
        pub(crate) peer_vpc_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the AWS account that you use to manage your GameLift fleet. You can find your Account ID in the AWS Management Console under account settings.</p>
        pub fn game_lift_aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_lift_aws_account_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the AWS account that you use to manage your GameLift fleet. You can find your Account ID in the AWS Management Console under account settings.</p>
        pub fn set_game_lift_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_lift_aws_account_id = input;
            self
        }
        /// <p>A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in the same Region as your fleet. To look up a VPC ID, use the <a href="https://console.aws.amazon.com/vpc/">VPC Dashboard</a> in the AWS Management Console. Learn more about VPC peering in <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift Fleets</a>.</p>
        pub fn peer_vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.peer_vpc_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in the same Region as your fleet. To look up a VPC ID, use the <a href="https://console.aws.amazon.com/vpc/">VPC Dashboard</a> in the AWS Management Console. Learn more about VPC peering in <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift Fleets</a>.</p>
        pub fn set_peer_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.peer_vpc_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVpcPeeringAuthorizationInput`](crate::input::DeleteVpcPeeringAuthorizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteVpcPeeringAuthorizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteVpcPeeringAuthorizationInput {
                game_lift_aws_account_id: self.game_lift_aws_account_id,
                peer_vpc_id: self.peer_vpc_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteVpcPeeringAuthorizationInputOperationOutputAlias =
    crate::operation::DeleteVpcPeeringAuthorization;
#[doc(hidden)]
pub type DeleteVpcPeeringAuthorizationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteVpcPeeringAuthorizationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteVpcPeeringAuthorization`](crate::operation::DeleteVpcPeeringAuthorization)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteVpcPeeringAuthorization,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteVpcPeeringAuthorizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteVpcPeeringAuthorizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteVpcPeeringAuthorizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DeleteVpcPeeringAuthorization",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_vpc_peering_authorization(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteVpcPeeringAuthorization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteVpcPeeringAuthorization",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteVpcPeeringAuthorizationInput`](crate::input::DeleteVpcPeeringAuthorizationInput)
    pub fn builder() -> crate::input::delete_vpc_peering_authorization_input::Builder {
        crate::input::delete_vpc_peering_authorization_input::Builder::default()
    }
}

/// See [`DeleteVpcPeeringConnectionInput`](crate::input::DeleteVpcPeeringConnectionInput)
pub mod delete_vpc_peering_connection_input {
    /// A builder for [`DeleteVpcPeeringConnectionInput`](crate::input::DeleteVpcPeeringConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) vpc_peering_connection_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet. This fleet specified must match the fleet referenced in the VPC peering connection record. You can use either the fleet ID or ARN value.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet. This fleet specified must match the fleet referenced in the VPC peering connection record. You can use either the fleet ID or ARN value.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p>A unique identifier for a VPC peering connection. This value is included in the <code>VpcPeeringConnection</code> object, which can be retrieved by calling <code>DescribeVpcPeeringConnections</code>.</p>
        pub fn vpc_peering_connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_peering_connection_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a VPC peering connection. This value is included in the <code>VpcPeeringConnection</code> object, which can be retrieved by calling <code>DescribeVpcPeeringConnections</code>.</p>
        pub fn set_vpc_peering_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_peering_connection_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVpcPeeringConnectionInput`](crate::input::DeleteVpcPeeringConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteVpcPeeringConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteVpcPeeringConnectionInput {
                fleet_id: self.fleet_id,
                vpc_peering_connection_id: self.vpc_peering_connection_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteVpcPeeringConnectionInputOperationOutputAlias =
    crate::operation::DeleteVpcPeeringConnection;
#[doc(hidden)]
pub type DeleteVpcPeeringConnectionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteVpcPeeringConnectionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteVpcPeeringConnection`](crate::operation::DeleteVpcPeeringConnection)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteVpcPeeringConnection,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteVpcPeeringConnectionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteVpcPeeringConnectionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteVpcPeeringConnectionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DeleteVpcPeeringConnection",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_vpc_peering_connection(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteVpcPeeringConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteVpcPeeringConnection",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteVpcPeeringConnectionInput`](crate::input::DeleteVpcPeeringConnectionInput)
    pub fn builder() -> crate::input::delete_vpc_peering_connection_input::Builder {
        crate::input::delete_vpc_peering_connection_input::Builder::default()
    }
}

/// See [`DeregisterGameServerInput`](crate::input::DeregisterGameServerInput)
pub mod deregister_game_server_input {
    /// A builder for [`DeregisterGameServerInput`](crate::input::DeregisterGameServerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_server_group_name: std::option::Option<std::string::String>,
        pub(crate) game_server_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the game server group where the game server is running. Use either the <code>GameServerGroup</code> name or ARN value.</p>
        pub fn game_server_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_server_group_name = Some(input.into());
            self
        }
        /// <p>A unique identifier for the game server group where the game server is running. Use either the <code>GameServerGroup</code> name or ARN value.</p>
        pub fn set_game_server_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_server_group_name = input;
            self
        }
        /// <p>A custom string that uniquely identifies the game server to deregister.</p>
        pub fn game_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_server_id = Some(input.into());
            self
        }
        /// <p>A custom string that uniquely identifies the game server to deregister.</p>
        pub fn set_game_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_server_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterGameServerInput`](crate::input::DeregisterGameServerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeregisterGameServerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeregisterGameServerInput {
                game_server_group_name: self.game_server_group_name,
                game_server_id: self.game_server_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeregisterGameServerInputOperationOutputAlias = crate::operation::DeregisterGameServer;
#[doc(hidden)]
pub type DeregisterGameServerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeregisterGameServerInput {
    /// Consumes the builder and constructs an Operation<[`DeregisterGameServer`](crate::operation::DeregisterGameServer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeregisterGameServer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeregisterGameServerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeregisterGameServerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeregisterGameServerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DeregisterGameServer",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deregister_game_server(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeregisterGameServer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeregisterGameServer",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeregisterGameServerInput`](crate::input::DeregisterGameServerInput)
    pub fn builder() -> crate::input::deregister_game_server_input::Builder {
        crate::input::deregister_game_server_input::Builder::default()
    }
}

/// See [`DescribeAliasInput`](crate::input::DescribeAliasInput)
pub mod describe_alias_input {
    /// A builder for [`DescribeAliasInput`](crate::input::DescribeAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alias_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the fleet alias that you want to retrieve. You can use either the alias ID or ARN value. </p>
        pub fn alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the fleet alias that you want to retrieve. You can use either the alias ID or ARN value. </p>
        pub fn set_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAliasInput`](crate::input::DescribeAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAliasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAliasInput {
                alias_id: self.alias_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAliasInputOperationOutputAlias = crate::operation::DescribeAlias;
#[doc(hidden)]
pub type DescribeAliasInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAliasInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAlias`](crate::operation::DescribeAlias)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAlias,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAliasInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAliasInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAliasInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DescribeAlias",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_describe_alias(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAlias::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAlias",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAliasInput`](crate::input::DescribeAliasInput)
    pub fn builder() -> crate::input::describe_alias_input::Builder {
        crate::input::describe_alias_input::Builder::default()
    }
}

/// See [`DescribeBuildInput`](crate::input::DescribeBuildInput)
pub mod describe_build_input {
    /// A builder for [`DescribeBuildInput`](crate::input::DescribeBuildInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) build_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the build to retrieve properties for. You can use either the build ID or ARN value. </p>
        pub fn build_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.build_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the build to retrieve properties for. You can use either the build ID or ARN value. </p>
        pub fn set_build_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.build_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBuildInput`](crate::input::DescribeBuildInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeBuildInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeBuildInput {
                build_id: self.build_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeBuildInputOperationOutputAlias = crate::operation::DescribeBuild;
#[doc(hidden)]
pub type DescribeBuildInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeBuildInput {
    /// Consumes the builder and constructs an Operation<[`DescribeBuild`](crate::operation::DescribeBuild)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeBuild,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeBuildInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeBuildInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeBuildInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DescribeBuild",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_describe_build(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeBuild::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeBuild",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeBuildInput`](crate::input::DescribeBuildInput)
    pub fn builder() -> crate::input::describe_build_input::Builder {
        crate::input::describe_build_input::Builder::default()
    }
}

/// See [`DescribeEc2InstanceLimitsInput`](crate::input::DescribeEc2InstanceLimitsInput)
pub mod describe_ec2_instance_limits_input {
    /// A builder for [`DescribeEc2InstanceLimitsInput`](crate::input::DescribeEc2InstanceLimitsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ec2_instance_type: std::option::Option<crate::model::Ec2InstanceType>,
        pub(crate) location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of an EC2 instance type that is supported in GameLift. A fleet instance type determines the computing resources of each instance in the fleet, including CPU, memory, storage, and networking capacity. Do not specify a value for this parameter to retrieve limits for all instance types.</p>
        pub fn ec2_instance_type(mut self, input: crate::model::Ec2InstanceType) -> Self {
            self.ec2_instance_type = Some(input);
            self
        }
        /// <p>Name of an EC2 instance type that is supported in GameLift. A fleet instance type determines the computing resources of each instance in the fleet, including CPU, memory, storage, and networking capacity. Do not specify a value for this parameter to retrieve limits for all instance types.</p>
        pub fn set_ec2_instance_type(
            mut self,
            input: std::option::Option<crate::model::Ec2InstanceType>,
        ) -> Self {
            self.ec2_instance_type = input;
            self
        }
        /// <p>The name of a remote location to request instance limits for, in the form of an AWS Region code such as <code>us-west-2</code>.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The name of a remote location to request instance limits for, in the form of an AWS Region code such as <code>us-west-2</code>.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEc2InstanceLimitsInput`](crate::input::DescribeEc2InstanceLimitsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEc2InstanceLimitsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEc2InstanceLimitsInput {
                ec2_instance_type: self.ec2_instance_type,
                location: self.location,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEc2InstanceLimitsInputOperationOutputAlias =
    crate::operation::DescribeEC2InstanceLimits;
#[doc(hidden)]
pub type DescribeEc2InstanceLimitsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeEc2InstanceLimitsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEC2InstanceLimits`](crate::operation::DescribeEC2InstanceLimits)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEC2InstanceLimits,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEc2InstanceLimitsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEc2InstanceLimitsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEc2InstanceLimitsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DescribeEC2InstanceLimits",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_ec2_instance_limits(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEC2InstanceLimits::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEC2InstanceLimits",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEc2InstanceLimitsInput`](crate::input::DescribeEc2InstanceLimitsInput)
    pub fn builder() -> crate::input::describe_ec2_instance_limits_input::Builder {
        crate::input::describe_ec2_instance_limits_input::Builder::default()
    }
}

/// See [`DescribeFleetAttributesInput`](crate::input::DescribeFleetAttributesInput)
pub mod describe_fleet_attributes_input {
    /// A builder for [`DescribeFleetAttributesInput`](crate::input::DescribeFleetAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `fleet_ids`.
        ///
        /// To override the contents of this collection use [`set_fleet_ids`](Self::set_fleet_ids).
        ///
        /// <p>A list of unique fleet identifiers to retrieve attributes for. You can use either the fleet ID or ARN value. To retrieve attributes for all current fleets, do not include this parameter. </p>
        pub fn fleet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.fleet_ids.unwrap_or_default();
            v.push(input.into());
            self.fleet_ids = Some(v);
            self
        }
        /// <p>A list of unique fleet identifiers to retrieve attributes for. You can use either the fleet ID or ARN value. To retrieve attributes for all current fleets, do not include this parameter. </p>
        pub fn set_fleet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.fleet_ids = input;
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages. This parameter is ignored when the request specifies one or a list of fleet IDs.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages. This parameter is ignored when the request specifies one or a list of fleet IDs.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. This parameter is ignored when the request specifies one or a list of fleet IDs.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. This parameter is ignored when the request specifies one or a list of fleet IDs.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFleetAttributesInput`](crate::input::DescribeFleetAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeFleetAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeFleetAttributesInput {
                fleet_ids: self.fleet_ids,
                limit: self.limit,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeFleetAttributesInputOperationOutputAlias =
    crate::operation::DescribeFleetAttributes;
#[doc(hidden)]
pub type DescribeFleetAttributesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeFleetAttributesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeFleetAttributes`](crate::operation::DescribeFleetAttributes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeFleetAttributes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeFleetAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeFleetAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeFleetAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DescribeFleetAttributes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_fleet_attributes(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeFleetAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeFleetAttributes",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeFleetAttributesInput`](crate::input::DescribeFleetAttributesInput)
    pub fn builder() -> crate::input::describe_fleet_attributes_input::Builder {
        crate::input::describe_fleet_attributes_input::Builder::default()
    }
}

/// See [`DescribeFleetCapacityInput`](crate::input::DescribeFleetCapacityInput)
pub mod describe_fleet_capacity_input {
    /// A builder for [`DescribeFleetCapacityInput`](crate::input::DescribeFleetCapacityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `fleet_ids`.
        ///
        /// To override the contents of this collection use [`set_fleet_ids`](Self::set_fleet_ids).
        ///
        /// <p>A unique identifier for the fleet(s) to retrieve capacity information for. You can use either the fleet ID or ARN value. Leave this parameter empty to retrieve capacity information for all fleets.</p>
        pub fn fleet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.fleet_ids.unwrap_or_default();
            v.push(input.into());
            self.fleet_ids = Some(v);
            self
        }
        /// <p>A unique identifier for the fleet(s) to retrieve capacity information for. You can use either the fleet ID or ARN value. Leave this parameter empty to retrieve capacity information for all fleets.</p>
        pub fn set_fleet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.fleet_ids = input;
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages. This parameter is ignored when the request specifies one or a list of fleet IDs.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages. This parameter is ignored when the request specifies one or a list of fleet IDs.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. This parameter is ignored when the request specifies one or a list of fleet IDs.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. This parameter is ignored when the request specifies one or a list of fleet IDs.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFleetCapacityInput`](crate::input::DescribeFleetCapacityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeFleetCapacityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeFleetCapacityInput {
                fleet_ids: self.fleet_ids,
                limit: self.limit,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeFleetCapacityInputOperationOutputAlias = crate::operation::DescribeFleetCapacity;
#[doc(hidden)]
pub type DescribeFleetCapacityInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeFleetCapacityInput {
    /// Consumes the builder and constructs an Operation<[`DescribeFleetCapacity`](crate::operation::DescribeFleetCapacity)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeFleetCapacity,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeFleetCapacityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeFleetCapacityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeFleetCapacityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DescribeFleetCapacity",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_fleet_capacity(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeFleetCapacity::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeFleetCapacity",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeFleetCapacityInput`](crate::input::DescribeFleetCapacityInput)
    pub fn builder() -> crate::input::describe_fleet_capacity_input::Builder {
        crate::input::describe_fleet_capacity_input::Builder::default()
    }
}

/// See [`DescribeFleetEventsInput`](crate::input::DescribeFleetEventsInput)
pub mod describe_fleet_events_input {
    /// A builder for [`DescribeFleetEventsInput`](crate::input::DescribeFleetEventsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet to get event logs for. You can use either the fleet ID or ARN value.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet to get event logs for. You can use either the fleet ID or ARN value.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p>The earliest date to retrieve event logs for. If no start time is specified, this call returns entries starting from when the fleet was created to the specified end time. Format is a number expressed in Unix time as milliseconds (ex: "1469498468.057").</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The earliest date to retrieve event logs for. If no start time is specified, this call returns entries starting from when the fleet was created to the specified end time. Format is a number expressed in Unix time as milliseconds (ex: "1469498468.057").</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The most recent date to retrieve event logs for. If no end time is specified, this call returns entries from the specified start time up to the present. Format is a number expressed in Unix time as milliseconds (ex: "1469498468.057").</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The most recent date to retrieve event logs for. If no end time is specified, this call returns entries from the specified start time up to the present. Format is a number expressed in Unix time as milliseconds (ex: "1469498468.057").</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFleetEventsInput`](crate::input::DescribeFleetEventsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeFleetEventsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeFleetEventsInput {
                fleet_id: self.fleet_id,
                start_time: self.start_time,
                end_time: self.end_time,
                limit: self.limit,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeFleetEventsInputOperationOutputAlias = crate::operation::DescribeFleetEvents;
#[doc(hidden)]
pub type DescribeFleetEventsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeFleetEventsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeFleetEvents`](crate::operation::DescribeFleetEvents)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeFleetEvents,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeFleetEventsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeFleetEventsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeFleetEventsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DescribeFleetEvents",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_fleet_events(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeFleetEvents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeFleetEvents",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeFleetEventsInput`](crate::input::DescribeFleetEventsInput)
    pub fn builder() -> crate::input::describe_fleet_events_input::Builder {
        crate::input::describe_fleet_events_input::Builder::default()
    }
}

/// See [`DescribeFleetLocationAttributesInput`](crate::input::DescribeFleetLocationAttributesInput)
pub mod describe_fleet_location_attributes_input {
    /// A builder for [`DescribeFleetLocationAttributesInput`](crate::input::DescribeFleetLocationAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) locations: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet to retrieve remote locations for. You can use either the fleet ID or ARN value.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet to retrieve remote locations for. You can use either the fleet ID or ARN value.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// Appends an item to `locations`.
        ///
        /// To override the contents of this collection use [`set_locations`](Self::set_locations).
        ///
        /// <p>A list of fleet locations to retrieve information for. Specify locations in the form of an AWS Region code, such as <code>us-west-2</code>.</p>
        pub fn locations(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.locations.unwrap_or_default();
            v.push(input.into());
            self.locations = Some(v);
            self
        }
        /// <p>A list of fleet locations to retrieve information for. Specify locations in the form of an AWS Region code, such as <code>us-west-2</code>.</p>
        pub fn set_locations(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.locations = input;
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages. This limit is not currently enforced. </p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages. This limit is not currently enforced. </p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFleetLocationAttributesInput`](crate::input::DescribeFleetLocationAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeFleetLocationAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeFleetLocationAttributesInput {
                fleet_id: self.fleet_id,
                locations: self.locations,
                limit: self.limit,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeFleetLocationAttributesInputOperationOutputAlias =
    crate::operation::DescribeFleetLocationAttributes;
#[doc(hidden)]
pub type DescribeFleetLocationAttributesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeFleetLocationAttributesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeFleetLocationAttributes`](crate::operation::DescribeFleetLocationAttributes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeFleetLocationAttributes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeFleetLocationAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeFleetLocationAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeFleetLocationAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DescribeFleetLocationAttributes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_fleet_location_attributes(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeFleetLocationAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeFleetLocationAttributes",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeFleetLocationAttributesInput`](crate::input::DescribeFleetLocationAttributesInput)
    pub fn builder() -> crate::input::describe_fleet_location_attributes_input::Builder {
        crate::input::describe_fleet_location_attributes_input::Builder::default()
    }
}

/// See [`DescribeFleetLocationCapacityInput`](crate::input::DescribeFleetLocationCapacityInput)
pub mod describe_fleet_location_capacity_input {
    /// A builder for [`DescribeFleetLocationCapacityInput`](crate::input::DescribeFleetLocationCapacityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet to request location capacity for. You can use either the fleet ID or ARN value.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet to request location capacity for. You can use either the fleet ID or ARN value.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p>The fleet location to retrieve capacity information for. Specify a location in the form of an AWS Region code, such as <code>us-west-2</code>.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The fleet location to retrieve capacity information for. Specify a location in the form of an AWS Region code, such as <code>us-west-2</code>.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFleetLocationCapacityInput`](crate::input::DescribeFleetLocationCapacityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeFleetLocationCapacityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeFleetLocationCapacityInput {
                fleet_id: self.fleet_id,
                location: self.location,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeFleetLocationCapacityInputOperationOutputAlias =
    crate::operation::DescribeFleetLocationCapacity;
#[doc(hidden)]
pub type DescribeFleetLocationCapacityInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeFleetLocationCapacityInput {
    /// Consumes the builder and constructs an Operation<[`DescribeFleetLocationCapacity`](crate::operation::DescribeFleetLocationCapacity)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeFleetLocationCapacity,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeFleetLocationCapacityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeFleetLocationCapacityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeFleetLocationCapacityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DescribeFleetLocationCapacity",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_fleet_location_capacity(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeFleetLocationCapacity::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeFleetLocationCapacity",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeFleetLocationCapacityInput`](crate::input::DescribeFleetLocationCapacityInput)
    pub fn builder() -> crate::input::describe_fleet_location_capacity_input::Builder {
        crate::input::describe_fleet_location_capacity_input::Builder::default()
    }
}

/// See [`DescribeFleetLocationUtilizationInput`](crate::input::DescribeFleetLocationUtilizationInput)
pub mod describe_fleet_location_utilization_input {
    /// A builder for [`DescribeFleetLocationUtilizationInput`](crate::input::DescribeFleetLocationUtilizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet to request location utilization for. You can use either the fleet ID or ARN value.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet to request location utilization for. You can use either the fleet ID or ARN value.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p>The fleet location to retrieve utilization information for. Specify a location in the form of an AWS Region code, such as <code>us-west-2</code>.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The fleet location to retrieve utilization information for. Specify a location in the form of an AWS Region code, such as <code>us-west-2</code>.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFleetLocationUtilizationInput`](crate::input::DescribeFleetLocationUtilizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeFleetLocationUtilizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeFleetLocationUtilizationInput {
                fleet_id: self.fleet_id,
                location: self.location,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeFleetLocationUtilizationInputOperationOutputAlias =
    crate::operation::DescribeFleetLocationUtilization;
#[doc(hidden)]
pub type DescribeFleetLocationUtilizationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeFleetLocationUtilizationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeFleetLocationUtilization`](crate::operation::DescribeFleetLocationUtilization)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeFleetLocationUtilization,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeFleetLocationUtilizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeFleetLocationUtilizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeFleetLocationUtilizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DescribeFleetLocationUtilization",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_fleet_location_utilization(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeFleetLocationUtilization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeFleetLocationUtilization",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeFleetLocationUtilizationInput`](crate::input::DescribeFleetLocationUtilizationInput)
    pub fn builder() -> crate::input::describe_fleet_location_utilization_input::Builder {
        crate::input::describe_fleet_location_utilization_input::Builder::default()
    }
}

/// See [`DescribeFleetPortSettingsInput`](crate::input::DescribeFleetPortSettingsInput)
pub mod describe_fleet_port_settings_input {
    /// A builder for [`DescribeFleetPortSettingsInput`](crate::input::DescribeFleetPortSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet to retrieve port settings for. You can use either the fleet ID or ARN value.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet to retrieve port settings for. You can use either the fleet ID or ARN value.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p>A remote location to check for status of port setting updates. Use the AWS Region code format, such as <code>us-west-2</code>.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>A remote location to check for status of port setting updates. Use the AWS Region code format, such as <code>us-west-2</code>.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFleetPortSettingsInput`](crate::input::DescribeFleetPortSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeFleetPortSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeFleetPortSettingsInput {
                fleet_id: self.fleet_id,
                location: self.location,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeFleetPortSettingsInputOperationOutputAlias =
    crate::operation::DescribeFleetPortSettings;
#[doc(hidden)]
pub type DescribeFleetPortSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeFleetPortSettingsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeFleetPortSettings`](crate::operation::DescribeFleetPortSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeFleetPortSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeFleetPortSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeFleetPortSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeFleetPortSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DescribeFleetPortSettings",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_fleet_port_settings(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeFleetPortSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeFleetPortSettings",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeFleetPortSettingsInput`](crate::input::DescribeFleetPortSettingsInput)
    pub fn builder() -> crate::input::describe_fleet_port_settings_input::Builder {
        crate::input::describe_fleet_port_settings_input::Builder::default()
    }
}

/// See [`DescribeFleetUtilizationInput`](crate::input::DescribeFleetUtilizationInput)
pub mod describe_fleet_utilization_input {
    /// A builder for [`DescribeFleetUtilizationInput`](crate::input::DescribeFleetUtilizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `fleet_ids`.
        ///
        /// To override the contents of this collection use [`set_fleet_ids`](Self::set_fleet_ids).
        ///
        /// <p>A unique identifier for the fleet(s) to retrieve utilization data for. You can use either the fleet ID or ARN value. To retrieve attributes for all current fleets, do not include this parameter. </p>
        pub fn fleet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.fleet_ids.unwrap_or_default();
            v.push(input.into());
            self.fleet_ids = Some(v);
            self
        }
        /// <p>A unique identifier for the fleet(s) to retrieve utilization data for. You can use either the fleet ID or ARN value. To retrieve attributes for all current fleets, do not include this parameter. </p>
        pub fn set_fleet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.fleet_ids = input;
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages. This parameter is ignored when the request specifies one or a list of fleet IDs.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages. This parameter is ignored when the request specifies one or a list of fleet IDs.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. This parameter is ignored when the request specifies one or a list of fleet IDs.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. This parameter is ignored when the request specifies one or a list of fleet IDs.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFleetUtilizationInput`](crate::input::DescribeFleetUtilizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeFleetUtilizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeFleetUtilizationInput {
                fleet_ids: self.fleet_ids,
                limit: self.limit,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeFleetUtilizationInputOperationOutputAlias =
    crate::operation::DescribeFleetUtilization;
#[doc(hidden)]
pub type DescribeFleetUtilizationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeFleetUtilizationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeFleetUtilization`](crate::operation::DescribeFleetUtilization)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeFleetUtilization,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeFleetUtilizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeFleetUtilizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeFleetUtilizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DescribeFleetUtilization",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_fleet_utilization(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeFleetUtilization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeFleetUtilization",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeFleetUtilizationInput`](crate::input::DescribeFleetUtilizationInput)
    pub fn builder() -> crate::input::describe_fleet_utilization_input::Builder {
        crate::input::describe_fleet_utilization_input::Builder::default()
    }
}

/// See [`DescribeGameServerInput`](crate::input::DescribeGameServerInput)
pub mod describe_game_server_input {
    /// A builder for [`DescribeGameServerInput`](crate::input::DescribeGameServerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_server_group_name: std::option::Option<std::string::String>,
        pub(crate) game_server_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the game server group where the game server is running. Use either the <code>GameServerGroup</code> name or ARN value.</p>
        pub fn game_server_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_server_group_name = Some(input.into());
            self
        }
        /// <p>A unique identifier for the game server group where the game server is running. Use either the <code>GameServerGroup</code> name or ARN value.</p>
        pub fn set_game_server_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_server_group_name = input;
            self
        }
        /// <p>A custom string that uniquely identifies the game server information to be retrieved.</p>
        pub fn game_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_server_id = Some(input.into());
            self
        }
        /// <p>A custom string that uniquely identifies the game server information to be retrieved.</p>
        pub fn set_game_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_server_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGameServerInput`](crate::input::DescribeGameServerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeGameServerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeGameServerInput {
                game_server_group_name: self.game_server_group_name,
                game_server_id: self.game_server_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeGameServerInputOperationOutputAlias = crate::operation::DescribeGameServer;
#[doc(hidden)]
pub type DescribeGameServerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeGameServerInput {
    /// Consumes the builder and constructs an Operation<[`DescribeGameServer`](crate::operation::DescribeGameServer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeGameServer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeGameServerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeGameServerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeGameServerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DescribeGameServer",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_game_server(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeGameServer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeGameServer",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeGameServerInput`](crate::input::DescribeGameServerInput)
    pub fn builder() -> crate::input::describe_game_server_input::Builder {
        crate::input::describe_game_server_input::Builder::default()
    }
}

/// See [`DescribeGameServerGroupInput`](crate::input::DescribeGameServerGroupInput)
pub mod describe_game_server_group_input {
    /// A builder for [`DescribeGameServerGroupInput`](crate::input::DescribeGameServerGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_server_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the game server group. Use either the <code>GameServerGroup</code> name or ARN value.</p>
        pub fn game_server_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_server_group_name = Some(input.into());
            self
        }
        /// <p>A unique identifier for the game server group. Use either the <code>GameServerGroup</code> name or ARN value.</p>
        pub fn set_game_server_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_server_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGameServerGroupInput`](crate::input::DescribeGameServerGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeGameServerGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeGameServerGroupInput {
                game_server_group_name: self.game_server_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeGameServerGroupInputOperationOutputAlias =
    crate::operation::DescribeGameServerGroup;
#[doc(hidden)]
pub type DescribeGameServerGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeGameServerGroupInput {
    /// Consumes the builder and constructs an Operation<[`DescribeGameServerGroup`](crate::operation::DescribeGameServerGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeGameServerGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeGameServerGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeGameServerGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeGameServerGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DescribeGameServerGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_game_server_group(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeGameServerGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeGameServerGroup",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeGameServerGroupInput`](crate::input::DescribeGameServerGroupInput)
    pub fn builder() -> crate::input::describe_game_server_group_input::Builder {
        crate::input::describe_game_server_group_input::Builder::default()
    }
}

/// See [`DescribeGameServerInstancesInput`](crate::input::DescribeGameServerInstancesInput)
pub mod describe_game_server_instances_input {
    /// A builder for [`DescribeGameServerInstancesInput`](crate::input::DescribeGameServerInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_server_group_name: std::option::Option<std::string::String>,
        pub(crate) instance_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the game server group. Use either the <code>GameServerGroup</code> name or ARN value.</p>
        pub fn game_server_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_server_group_name = Some(input.into());
            self
        }
        /// <p>A unique identifier for the game server group. Use either the <code>GameServerGroup</code> name or ARN value.</p>
        pub fn set_game_server_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_server_group_name = input;
            self
        }
        /// Appends an item to `instance_ids`.
        ///
        /// To override the contents of this collection use [`set_instance_ids`](Self::set_instance_ids).
        ///
        /// <p>The EC2 instance IDs that you want to retrieve status on. EC2 instance IDs use a 17-character format, for example: <code>i-1234567890abcdef0</code>. To retrieve all instances in the game server group, leave this parameter empty. </p>
        pub fn instance_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instance_ids.unwrap_or_default();
            v.push(input.into());
            self.instance_ids = Some(v);
            self
        }
        /// <p>The EC2 instance IDs that you want to retrieve status on. EC2 instance IDs use a 17-character format, for example: <code>i-1234567890abcdef0</code>. To retrieve all instances in the game server group, leave this parameter empty. </p>
        pub fn set_instance_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instance_ids = input;
            self
        }
        /// <p> The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages. </p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p> The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages. </p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p> A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGameServerInstancesInput`](crate::input::DescribeGameServerInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeGameServerInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeGameServerInstancesInput {
                game_server_group_name: self.game_server_group_name,
                instance_ids: self.instance_ids,
                limit: self.limit,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeGameServerInstancesInputOperationOutputAlias =
    crate::operation::DescribeGameServerInstances;
#[doc(hidden)]
pub type DescribeGameServerInstancesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeGameServerInstancesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeGameServerInstances`](crate::operation::DescribeGameServerInstances)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeGameServerInstances,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeGameServerInstancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeGameServerInstancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeGameServerInstancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DescribeGameServerInstances",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_game_server_instances(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeGameServerInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeGameServerInstances",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeGameServerInstancesInput`](crate::input::DescribeGameServerInstancesInput)
    pub fn builder() -> crate::input::describe_game_server_instances_input::Builder {
        crate::input::describe_game_server_instances_input::Builder::default()
    }
}

/// See [`DescribeGameSessionDetailsInput`](crate::input::DescribeGameSessionDetailsInput)
pub mod describe_game_session_details_input {
    /// A builder for [`DescribeGameSessionDetailsInput`](crate::input::DescribeGameSessionDetailsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) game_session_id: std::option::Option<std::string::String>,
        pub(crate) alias_id: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) status_filter: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet to retrieve all game sessions active on the fleet. You can use either the fleet ID or ARN value.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet to retrieve all game sessions active on the fleet. You can use either the fleet ID or ARN value.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p>A unique identifier for the game session to retrieve. </p>
        pub fn game_session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_session_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the game session to retrieve. </p>
        pub fn set_game_session_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_session_id = input;
            self
        }
        /// <p>A unique identifier for the alias associated with the fleet to retrieve all game sessions for. You can use either the alias ID or ARN value.</p>
        pub fn alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the alias associated with the fleet to retrieve all game sessions for. You can use either the alias ID or ARN value.</p>
        pub fn set_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_id = input;
            self
        }
        /// <p>A fleet location to get game sessions for. You can specify a fleet's home Region or a remote location. Use the AWS Region code format, such as <code>us-west-2</code>. </p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>A fleet location to get game sessions for. You can specify a fleet's home Region or a remote location. Use the AWS Region code format, such as <code>us-west-2</code>. </p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>Game session status to filter results on. Possible game session statuses include <code>ACTIVE</code>, <code>TERMINATED</code>, <code>ACTIVATING</code> and <code>TERMINATING</code> (the last two are transitory). </p>
        pub fn status_filter(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_filter = Some(input.into());
            self
        }
        /// <p>Game session status to filter results on. Possible game session statuses include <code>ACTIVE</code>, <code>TERMINATED</code>, <code>ACTIVATING</code> and <code>TERMINATING</code> (the last two are transitory). </p>
        pub fn set_status_filter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_filter = input;
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGameSessionDetailsInput`](crate::input::DescribeGameSessionDetailsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeGameSessionDetailsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeGameSessionDetailsInput {
                fleet_id: self.fleet_id,
                game_session_id: self.game_session_id,
                alias_id: self.alias_id,
                location: self.location,
                status_filter: self.status_filter,
                limit: self.limit,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeGameSessionDetailsInputOperationOutputAlias =
    crate::operation::DescribeGameSessionDetails;
#[doc(hidden)]
pub type DescribeGameSessionDetailsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeGameSessionDetailsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeGameSessionDetails`](crate::operation::DescribeGameSessionDetails)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeGameSessionDetails,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeGameSessionDetailsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeGameSessionDetailsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeGameSessionDetailsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DescribeGameSessionDetails",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_game_session_details(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeGameSessionDetails::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeGameSessionDetails",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeGameSessionDetailsInput`](crate::input::DescribeGameSessionDetailsInput)
    pub fn builder() -> crate::input::describe_game_session_details_input::Builder {
        crate::input::describe_game_session_details_input::Builder::default()
    }
}

/// See [`DescribeGameSessionPlacementInput`](crate::input::DescribeGameSessionPlacementInput)
pub mod describe_game_session_placement_input {
    /// A builder for [`DescribeGameSessionPlacementInput`](crate::input::DescribeGameSessionPlacementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) placement_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for a game session placement to retrieve.</p>
        pub fn placement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.placement_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a game session placement to retrieve.</p>
        pub fn set_placement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.placement_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGameSessionPlacementInput`](crate::input::DescribeGameSessionPlacementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeGameSessionPlacementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeGameSessionPlacementInput {
                placement_id: self.placement_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeGameSessionPlacementInputOperationOutputAlias =
    crate::operation::DescribeGameSessionPlacement;
#[doc(hidden)]
pub type DescribeGameSessionPlacementInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeGameSessionPlacementInput {
    /// Consumes the builder and constructs an Operation<[`DescribeGameSessionPlacement`](crate::operation::DescribeGameSessionPlacement)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeGameSessionPlacement,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeGameSessionPlacementInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeGameSessionPlacementInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeGameSessionPlacementInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DescribeGameSessionPlacement",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_game_session_placement(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeGameSessionPlacement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeGameSessionPlacement",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeGameSessionPlacementInput`](crate::input::DescribeGameSessionPlacementInput)
    pub fn builder() -> crate::input::describe_game_session_placement_input::Builder {
        crate::input::describe_game_session_placement_input::Builder::default()
    }
}

/// See [`DescribeGameSessionQueuesInput`](crate::input::DescribeGameSessionQueuesInput)
pub mod describe_game_session_queues_input {
    /// A builder for [`DescribeGameSessionQueuesInput`](crate::input::DescribeGameSessionQueuesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>A list of queue names to retrieve information for. You can use either the queue ID or ARN value. To request settings for all queues, leave this parameter empty. </p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.names.unwrap_or_default();
            v.push(input.into());
            self.names = Some(v);
            self
        }
        /// <p>A list of queue names to retrieve information for. You can use either the queue ID or ARN value. To request settings for all queues, leave this parameter empty. </p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.names = input;
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages. You can request up to 50 results.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages. You can request up to 50 results.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGameSessionQueuesInput`](crate::input::DescribeGameSessionQueuesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeGameSessionQueuesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeGameSessionQueuesInput {
                names: self.names,
                limit: self.limit,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeGameSessionQueuesInputOperationOutputAlias =
    crate::operation::DescribeGameSessionQueues;
#[doc(hidden)]
pub type DescribeGameSessionQueuesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeGameSessionQueuesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeGameSessionQueues`](crate::operation::DescribeGameSessionQueues)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeGameSessionQueues,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeGameSessionQueuesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeGameSessionQueuesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeGameSessionQueuesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DescribeGameSessionQueues",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_game_session_queues(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeGameSessionQueues::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeGameSessionQueues",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeGameSessionQueuesInput`](crate::input::DescribeGameSessionQueuesInput)
    pub fn builder() -> crate::input::describe_game_session_queues_input::Builder {
        crate::input::describe_game_session_queues_input::Builder::default()
    }
}

/// See [`DescribeGameSessionsInput`](crate::input::DescribeGameSessionsInput)
pub mod describe_game_sessions_input {
    /// A builder for [`DescribeGameSessionsInput`](crate::input::DescribeGameSessionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) game_session_id: std::option::Option<std::string::String>,
        pub(crate) alias_id: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) status_filter: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet to retrieve game sessions for. You can use either the fleet ID or ARN value. </p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet to retrieve game sessions for. You can use either the fleet ID or ARN value. </p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p>A unique identifier for the game session to retrieve. </p>
        pub fn game_session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_session_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the game session to retrieve. </p>
        pub fn set_game_session_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_session_id = input;
            self
        }
        /// <p>A unique identifier for the alias associated with the fleet to retrieve game sessions for. You can use either the alias ID or ARN value.</p>
        pub fn alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the alias associated with the fleet to retrieve game sessions for. You can use either the alias ID or ARN value.</p>
        pub fn set_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_id = input;
            self
        }
        /// <p>A fleet location to get game session details for. You can specify a fleet's home Region or a remote location. Use the AWS Region code format, such as <code>us-west-2</code>. </p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>A fleet location to get game session details for. You can specify a fleet's home Region or a remote location. Use the AWS Region code format, such as <code>us-west-2</code>. </p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>Game session status to filter results on. You can filter on the following states: <code>ACTIVE</code>, <code>TERMINATED</code>, <code>ACTIVATING</code>, and <code>TERMINATING</code>. The last two are transitory and used for only very brief periods of time. </p>
        pub fn status_filter(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_filter = Some(input.into());
            self
        }
        /// <p>Game session status to filter results on. You can filter on the following states: <code>ACTIVE</code>, <code>TERMINATED</code>, <code>ACTIVATING</code>, and <code>TERMINATING</code>. The last two are transitory and used for only very brief periods of time. </p>
        pub fn set_status_filter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_filter = input;
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGameSessionsInput`](crate::input::DescribeGameSessionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeGameSessionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeGameSessionsInput {
                fleet_id: self.fleet_id,
                game_session_id: self.game_session_id,
                alias_id: self.alias_id,
                location: self.location,
                status_filter: self.status_filter,
                limit: self.limit,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeGameSessionsInputOperationOutputAlias = crate::operation::DescribeGameSessions;
#[doc(hidden)]
pub type DescribeGameSessionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeGameSessionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeGameSessions`](crate::operation::DescribeGameSessions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeGameSessions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeGameSessionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeGameSessionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeGameSessionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DescribeGameSessions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_game_sessions(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeGameSessions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeGameSessions",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeGameSessionsInput`](crate::input::DescribeGameSessionsInput)
    pub fn builder() -> crate::input::describe_game_sessions_input::Builder {
        crate::input::describe_game_sessions_input::Builder::default()
    }
}

/// See [`DescribeInstancesInput`](crate::input::DescribeInstancesInput)
pub mod describe_instances_input {
    /// A builder for [`DescribeInstancesInput`](crate::input::DescribeInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet to retrieve instance information for. You can use either the fleet ID or ARN value.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet to retrieve instance information for. You can use either the fleet ID or ARN value.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p>A unique identifier for an instance to retrieve. Specify an instance ID or leave blank to retrieve all instances in the fleet.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for an instance to retrieve. Specify an instance ID or leave blank to retrieve all instances in the fleet.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The name of a location to retrieve instance information for, in the form of an AWS Region code such as <code>us-west-2</code>. </p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The name of a location to retrieve instance information for, in the form of an AWS Region code such as <code>us-west-2</code>. </p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInstancesInput`](crate::input::DescribeInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeInstancesInput {
                fleet_id: self.fleet_id,
                instance_id: self.instance_id,
                limit: self.limit,
                next_token: self.next_token,
                location: self.location,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeInstancesInputOperationOutputAlias = crate::operation::DescribeInstances;
#[doc(hidden)]
pub type DescribeInstancesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeInstancesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeInstances`](crate::operation::DescribeInstances)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeInstances,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeInstancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeInstancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeInstancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DescribeInstances",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_instances(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeInstances",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeInstancesInput`](crate::input::DescribeInstancesInput)
    pub fn builder() -> crate::input::describe_instances_input::Builder {
        crate::input::describe_instances_input::Builder::default()
    }
}

/// See [`DescribeMatchmakingInput`](crate::input::DescribeMatchmakingInput)
pub mod describe_matchmaking_input {
    /// A builder for [`DescribeMatchmakingInput`](crate::input::DescribeMatchmakingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ticket_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `ticket_ids`.
        ///
        /// To override the contents of this collection use [`set_ticket_ids`](Self::set_ticket_ids).
        ///
        /// <p>A unique identifier for a matchmaking ticket. You can include up to 10 ID values. </p>
        pub fn ticket_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ticket_ids.unwrap_or_default();
            v.push(input.into());
            self.ticket_ids = Some(v);
            self
        }
        /// <p>A unique identifier for a matchmaking ticket. You can include up to 10 ID values. </p>
        pub fn set_ticket_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ticket_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMatchmakingInput`](crate::input::DescribeMatchmakingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeMatchmakingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeMatchmakingInput {
                ticket_ids: self.ticket_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeMatchmakingInputOperationOutputAlias = crate::operation::DescribeMatchmaking;
#[doc(hidden)]
pub type DescribeMatchmakingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeMatchmakingInput {
    /// Consumes the builder and constructs an Operation<[`DescribeMatchmaking`](crate::operation::DescribeMatchmaking)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeMatchmaking,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeMatchmakingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeMatchmakingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeMatchmakingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DescribeMatchmaking",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_matchmaking(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeMatchmaking::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeMatchmaking",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeMatchmakingInput`](crate::input::DescribeMatchmakingInput)
    pub fn builder() -> crate::input::describe_matchmaking_input::Builder {
        crate::input::describe_matchmaking_input::Builder::default()
    }
}

/// See [`DescribeMatchmakingConfigurationsInput`](crate::input::DescribeMatchmakingConfigurationsInput)
pub mod describe_matchmaking_configurations_input {
    /// A builder for [`DescribeMatchmakingConfigurationsInput`](crate::input::DescribeMatchmakingConfigurationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) rule_set_name: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>A unique identifier for the matchmaking configuration(s) to retrieve. You can use either the configuration name or ARN value. To request all existing configurations, leave this parameter empty.</p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.names.unwrap_or_default();
            v.push(input.into());
            self.names = Some(v);
            self
        }
        /// <p>A unique identifier for the matchmaking configuration(s) to retrieve. You can use either the configuration name or ARN value. To request all existing configurations, leave this parameter empty.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.names = input;
            self
        }
        /// <p>A unique identifier for the matchmaking rule set. You can use either the rule set name or ARN value. Use this parameter to retrieve all matchmaking configurations that use this rule set.</p>
        pub fn rule_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_set_name = Some(input.into());
            self
        }
        /// <p>A unique identifier for the matchmaking rule set. You can use either the rule set name or ARN value. Use this parameter to retrieve all matchmaking configurations that use this rule set.</p>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rule_set_name = input;
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages. This parameter is limited to 10.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages. This parameter is limited to 10.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMatchmakingConfigurationsInput`](crate::input::DescribeMatchmakingConfigurationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeMatchmakingConfigurationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeMatchmakingConfigurationsInput {
                names: self.names,
                rule_set_name: self.rule_set_name,
                limit: self.limit,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeMatchmakingConfigurationsInputOperationOutputAlias =
    crate::operation::DescribeMatchmakingConfigurations;
#[doc(hidden)]
pub type DescribeMatchmakingConfigurationsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeMatchmakingConfigurationsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeMatchmakingConfigurations`](crate::operation::DescribeMatchmakingConfigurations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeMatchmakingConfigurations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeMatchmakingConfigurationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeMatchmakingConfigurationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeMatchmakingConfigurationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DescribeMatchmakingConfigurations",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_matchmaking_configurations(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeMatchmakingConfigurations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeMatchmakingConfigurations",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeMatchmakingConfigurationsInput`](crate::input::DescribeMatchmakingConfigurationsInput)
    pub fn builder() -> crate::input::describe_matchmaking_configurations_input::Builder {
        crate::input::describe_matchmaking_configurations_input::Builder::default()
    }
}

/// See [`DescribeMatchmakingRuleSetsInput`](crate::input::DescribeMatchmakingRuleSetsInput)
pub mod describe_matchmaking_rule_sets_input {
    /// A builder for [`DescribeMatchmakingRuleSetsInput`](crate::input::DescribeMatchmakingRuleSetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>A list of one or more matchmaking rule set names to retrieve details for. (Note: The rule set name is different from the optional "name" field in the rule set body.) You can use either the rule set name or ARN value. </p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.names.unwrap_or_default();
            v.push(input.into());
            self.names = Some(v);
            self
        }
        /// <p>A list of one or more matchmaking rule set names to retrieve details for. (Note: The rule set name is different from the optional "name" field in the rule set body.) You can use either the rule set name or ARN value. </p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.names = input;
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMatchmakingRuleSetsInput`](crate::input::DescribeMatchmakingRuleSetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeMatchmakingRuleSetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeMatchmakingRuleSetsInput {
                names: self.names,
                limit: self.limit,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeMatchmakingRuleSetsInputOperationOutputAlias =
    crate::operation::DescribeMatchmakingRuleSets;
#[doc(hidden)]
pub type DescribeMatchmakingRuleSetsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeMatchmakingRuleSetsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeMatchmakingRuleSets`](crate::operation::DescribeMatchmakingRuleSets)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeMatchmakingRuleSets,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeMatchmakingRuleSetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeMatchmakingRuleSetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeMatchmakingRuleSetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DescribeMatchmakingRuleSets",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_matchmaking_rule_sets(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeMatchmakingRuleSets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeMatchmakingRuleSets",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeMatchmakingRuleSetsInput`](crate::input::DescribeMatchmakingRuleSetsInput)
    pub fn builder() -> crate::input::describe_matchmaking_rule_sets_input::Builder {
        crate::input::describe_matchmaking_rule_sets_input::Builder::default()
    }
}

/// See [`DescribePlayerSessionsInput`](crate::input::DescribePlayerSessionsInput)
pub mod describe_player_sessions_input {
    /// A builder for [`DescribePlayerSessionsInput`](crate::input::DescribePlayerSessionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_session_id: std::option::Option<std::string::String>,
        pub(crate) player_id: std::option::Option<std::string::String>,
        pub(crate) player_session_id: std::option::Option<std::string::String>,
        pub(crate) player_session_status_filter: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the game session to retrieve player sessions for.</p>
        pub fn game_session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_session_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the game session to retrieve player sessions for.</p>
        pub fn set_game_session_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_session_id = input;
            self
        }
        /// <p>A unique identifier for a player to retrieve player sessions for.</p>
        pub fn player_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.player_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a player to retrieve player sessions for.</p>
        pub fn set_player_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.player_id = input;
            self
        }
        /// <p>A unique identifier for a player session to retrieve.</p>
        pub fn player_session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.player_session_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a player session to retrieve.</p>
        pub fn set_player_session_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.player_session_id = input;
            self
        }
        /// <p>Player session status to filter results on.</p>
        /// <p>Possible player session statuses include the following:</p>
        /// <ul>
        /// <li> <p> <b>RESERVED</b> -- The player session request has been received, but the player has not yet connected to the server process and/or been validated. </p> </li>
        /// <li> <p> <b>ACTIVE</b> -- The player has been validated by the server process and is currently connected.</p> </li>
        /// <li> <p> <b>COMPLETED</b> -- The player connection has been dropped.</p> </li>
        /// <li> <p> <b>TIMEDOUT</b> -- A player session request was received, but the player did not connect and/or was not validated within the timeout limit (60 seconds).</p> </li>
        /// </ul>
        pub fn player_session_status_filter(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.player_session_status_filter = Some(input.into());
            self
        }
        /// <p>Player session status to filter results on.</p>
        /// <p>Possible player session statuses include the following:</p>
        /// <ul>
        /// <li> <p> <b>RESERVED</b> -- The player session request has been received, but the player has not yet connected to the server process and/or been validated. </p> </li>
        /// <li> <p> <b>ACTIVE</b> -- The player has been validated by the server process and is currently connected.</p> </li>
        /// <li> <p> <b>COMPLETED</b> -- The player connection has been dropped.</p> </li>
        /// <li> <p> <b>TIMEDOUT</b> -- A player session request was received, but the player did not connect and/or was not validated within the timeout limit (60 seconds).</p> </li>
        /// </ul>
        pub fn set_player_session_status_filter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.player_session_status_filter = input;
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages. If a player session ID is specified, this parameter is ignored.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages. If a player session ID is specified, this parameter is ignored.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. If a player session ID is specified, this parameter is ignored.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. If a player session ID is specified, this parameter is ignored.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePlayerSessionsInput`](crate::input::DescribePlayerSessionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePlayerSessionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePlayerSessionsInput {
                game_session_id: self.game_session_id,
                player_id: self.player_id,
                player_session_id: self.player_session_id,
                player_session_status_filter: self.player_session_status_filter,
                limit: self.limit,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePlayerSessionsInputOperationOutputAlias = crate::operation::DescribePlayerSessions;
#[doc(hidden)]
pub type DescribePlayerSessionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribePlayerSessionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribePlayerSessions`](crate::operation::DescribePlayerSessions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePlayerSessions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribePlayerSessionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribePlayerSessionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribePlayerSessionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DescribePlayerSessions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_player_sessions(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePlayerSessions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePlayerSessions",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribePlayerSessionsInput`](crate::input::DescribePlayerSessionsInput)
    pub fn builder() -> crate::input::describe_player_sessions_input::Builder {
        crate::input::describe_player_sessions_input::Builder::default()
    }
}

/// See [`DescribeRuntimeConfigurationInput`](crate::input::DescribeRuntimeConfigurationInput)
pub mod describe_runtime_configuration_input {
    /// A builder for [`DescribeRuntimeConfigurationInput`](crate::input::DescribeRuntimeConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet to get the runtime configuration for. You can use either the fleet ID or ARN value.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet to get the runtime configuration for. You can use either the fleet ID or ARN value.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRuntimeConfigurationInput`](crate::input::DescribeRuntimeConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRuntimeConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRuntimeConfigurationInput {
                fleet_id: self.fleet_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRuntimeConfigurationInputOperationOutputAlias =
    crate::operation::DescribeRuntimeConfiguration;
#[doc(hidden)]
pub type DescribeRuntimeConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeRuntimeConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRuntimeConfiguration`](crate::operation::DescribeRuntimeConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRuntimeConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeRuntimeConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeRuntimeConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeRuntimeConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DescribeRuntimeConfiguration",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_runtime_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRuntimeConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRuntimeConfiguration",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeRuntimeConfigurationInput`](crate::input::DescribeRuntimeConfigurationInput)
    pub fn builder() -> crate::input::describe_runtime_configuration_input::Builder {
        crate::input::describe_runtime_configuration_input::Builder::default()
    }
}

/// See [`DescribeScalingPoliciesInput`](crate::input::DescribeScalingPoliciesInput)
pub mod describe_scaling_policies_input {
    /// A builder for [`DescribeScalingPoliciesInput`](crate::input::DescribeScalingPoliciesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) status_filter: std::option::Option<crate::model::ScalingStatusType>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet to retrieve scaling policies for. You can use either the fleet ID or ARN value.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet to retrieve scaling policies for. You can use either the fleet ID or ARN value.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p>Scaling policy status to filter results on. A scaling policy is only in force when in an <code>ACTIVE</code> status.</p>
        /// <ul>
        /// <li> <p> <b>ACTIVE</b> -- The scaling policy is currently in force.</p> </li>
        /// <li> <p> <b>UPDATEREQUESTED</b> -- A request to update the scaling policy has been received.</p> </li>
        /// <li> <p> <b>UPDATING</b> -- A change is being made to the scaling policy.</p> </li>
        /// <li> <p> <b>DELETEREQUESTED</b> -- A request to delete the scaling policy has been received.</p> </li>
        /// <li> <p> <b>DELETING</b> -- The scaling policy is being deleted.</p> </li>
        /// <li> <p> <b>DELETED</b> -- The scaling policy has been deleted.</p> </li>
        /// <li> <p> <b>ERROR</b> -- An error occurred in creating the policy. It should be removed and recreated.</p> </li>
        /// </ul>
        pub fn status_filter(mut self, input: crate::model::ScalingStatusType) -> Self {
            self.status_filter = Some(input);
            self
        }
        /// <p>Scaling policy status to filter results on. A scaling policy is only in force when in an <code>ACTIVE</code> status.</p>
        /// <ul>
        /// <li> <p> <b>ACTIVE</b> -- The scaling policy is currently in force.</p> </li>
        /// <li> <p> <b>UPDATEREQUESTED</b> -- A request to update the scaling policy has been received.</p> </li>
        /// <li> <p> <b>UPDATING</b> -- A change is being made to the scaling policy.</p> </li>
        /// <li> <p> <b>DELETEREQUESTED</b> -- A request to delete the scaling policy has been received.</p> </li>
        /// <li> <p> <b>DELETING</b> -- The scaling policy is being deleted.</p> </li>
        /// <li> <p> <b>DELETED</b> -- The scaling policy has been deleted.</p> </li>
        /// <li> <p> <b>ERROR</b> -- An error occurred in creating the policy. It should be removed and recreated.</p> </li>
        /// </ul>
        pub fn set_status_filter(
            mut self,
            input: std::option::Option<crate::model::ScalingStatusType>,
        ) -> Self {
            self.status_filter = input;
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> CONTENT TODO </p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p> CONTENT TODO </p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeScalingPoliciesInput`](crate::input::DescribeScalingPoliciesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeScalingPoliciesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeScalingPoliciesInput {
                fleet_id: self.fleet_id,
                status_filter: self.status_filter,
                limit: self.limit,
                next_token: self.next_token,
                location: self.location,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeScalingPoliciesInputOperationOutputAlias =
    crate::operation::DescribeScalingPolicies;
#[doc(hidden)]
pub type DescribeScalingPoliciesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeScalingPoliciesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeScalingPolicies`](crate::operation::DescribeScalingPolicies)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeScalingPolicies,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeScalingPoliciesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeScalingPoliciesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeScalingPoliciesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DescribeScalingPolicies",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_scaling_policies(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeScalingPolicies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeScalingPolicies",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeScalingPoliciesInput`](crate::input::DescribeScalingPoliciesInput)
    pub fn builder() -> crate::input::describe_scaling_policies_input::Builder {
        crate::input::describe_scaling_policies_input::Builder::default()
    }
}

/// See [`DescribeScriptInput`](crate::input::DescribeScriptInput)
pub mod describe_script_input {
    /// A builder for [`DescribeScriptInput`](crate::input::DescribeScriptInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) script_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the Realtime script to retrieve properties for. You can use either the script ID or ARN value.</p>
        pub fn script_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.script_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the Realtime script to retrieve properties for. You can use either the script ID or ARN value.</p>
        pub fn set_script_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.script_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeScriptInput`](crate::input::DescribeScriptInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeScriptInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeScriptInput {
                script_id: self.script_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeScriptInputOperationOutputAlias = crate::operation::DescribeScript;
#[doc(hidden)]
pub type DescribeScriptInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeScriptInput {
    /// Consumes the builder and constructs an Operation<[`DescribeScript`](crate::operation::DescribeScript)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeScript,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeScriptInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeScriptInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeScriptInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DescribeScript",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_script(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeScript::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeScript",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeScriptInput`](crate::input::DescribeScriptInput)
    pub fn builder() -> crate::input::describe_script_input::Builder {
        crate::input::describe_script_input::Builder::default()
    }
}

/// See [`DescribeVpcPeeringAuthorizationsInput`](crate::input::DescribeVpcPeeringAuthorizationsInput)
pub mod describe_vpc_peering_authorizations_input {
    /// A builder for [`DescribeVpcPeeringAuthorizationsInput`](crate::input::DescribeVpcPeeringAuthorizationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeVpcPeeringAuthorizationsInput`](crate::input::DescribeVpcPeeringAuthorizationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeVpcPeeringAuthorizationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeVpcPeeringAuthorizationsInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeVpcPeeringAuthorizationsInputOperationOutputAlias =
    crate::operation::DescribeVpcPeeringAuthorizations;
#[doc(hidden)]
pub type DescribeVpcPeeringAuthorizationsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeVpcPeeringAuthorizationsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeVpcPeeringAuthorizations`](crate::operation::DescribeVpcPeeringAuthorizations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeVpcPeeringAuthorizations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeVpcPeeringAuthorizationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeVpcPeeringAuthorizationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeVpcPeeringAuthorizationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DescribeVpcPeeringAuthorizations",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_vpc_peering_authorizations(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeVpcPeeringAuthorizations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeVpcPeeringAuthorizations",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeVpcPeeringAuthorizationsInput`](crate::input::DescribeVpcPeeringAuthorizationsInput)
    pub fn builder() -> crate::input::describe_vpc_peering_authorizations_input::Builder {
        crate::input::describe_vpc_peering_authorizations_input::Builder::default()
    }
}

/// See [`DescribeVpcPeeringConnectionsInput`](crate::input::DescribeVpcPeeringConnectionsInput)
pub mod describe_vpc_peering_connections_input {
    /// A builder for [`DescribeVpcPeeringConnectionsInput`](crate::input::DescribeVpcPeeringConnectionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet. You can use either the fleet ID or ARN value.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet. You can use either the fleet ID or ARN value.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeVpcPeeringConnectionsInput`](crate::input::DescribeVpcPeeringConnectionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeVpcPeeringConnectionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeVpcPeeringConnectionsInput {
                fleet_id: self.fleet_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeVpcPeeringConnectionsInputOperationOutputAlias =
    crate::operation::DescribeVpcPeeringConnections;
#[doc(hidden)]
pub type DescribeVpcPeeringConnectionsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeVpcPeeringConnectionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeVpcPeeringConnections`](crate::operation::DescribeVpcPeeringConnections)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeVpcPeeringConnections,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeVpcPeeringConnectionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeVpcPeeringConnectionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeVpcPeeringConnectionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.DescribeVpcPeeringConnections",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_vpc_peering_connections(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeVpcPeeringConnections::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeVpcPeeringConnections",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeVpcPeeringConnectionsInput`](crate::input::DescribeVpcPeeringConnectionsInput)
    pub fn builder() -> crate::input::describe_vpc_peering_connections_input::Builder {
        crate::input::describe_vpc_peering_connections_input::Builder::default()
    }
}

/// See [`GetGameSessionLogUrlInput`](crate::input::GetGameSessionLogUrlInput)
pub mod get_game_session_log_url_input {
    /// A builder for [`GetGameSessionLogUrlInput`](crate::input::GetGameSessionLogUrlInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_session_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the game session to get logs for. </p>
        pub fn game_session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_session_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the game session to get logs for. </p>
        pub fn set_game_session_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_session_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGameSessionLogUrlInput`](crate::input::GetGameSessionLogUrlInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetGameSessionLogUrlInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetGameSessionLogUrlInput {
                game_session_id: self.game_session_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetGameSessionLogUrlInputOperationOutputAlias = crate::operation::GetGameSessionLogUrl;
#[doc(hidden)]
pub type GetGameSessionLogUrlInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetGameSessionLogUrlInput {
    /// Consumes the builder and constructs an Operation<[`GetGameSessionLogUrl`](crate::operation::GetGameSessionLogUrl)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetGameSessionLogUrl,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetGameSessionLogUrlInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetGameSessionLogUrlInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetGameSessionLogUrlInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.GetGameSessionLogUrl",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_game_session_log_url(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetGameSessionLogUrl::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetGameSessionLogUrl",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetGameSessionLogUrlInput`](crate::input::GetGameSessionLogUrlInput)
    pub fn builder() -> crate::input::get_game_session_log_url_input::Builder {
        crate::input::get_game_session_log_url_input::Builder::default()
    }
}

/// See [`GetInstanceAccessInput`](crate::input::GetInstanceAccessInput)
pub mod get_instance_access_input {
    /// A builder for [`GetInstanceAccessInput`](crate::input::GetInstanceAccessInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet that contains the instance you want access to. You can use either the fleet ID or ARN value. The fleet can be in any of the following statuses: <code>ACTIVATING</code>, <code>ACTIVE</code>, or <code>ERROR</code>. Fleets with an <code>ERROR</code> status may be accessible for a short time before they are deleted.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet that contains the instance you want access to. You can use either the fleet ID or ARN value. The fleet can be in any of the following statuses: <code>ACTIVATING</code>, <code>ACTIVE</code>, or <code>ERROR</code>. Fleets with an <code>ERROR</code> status may be accessible for a short time before they are deleted.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p>A unique identifier for the instance you want to get access to. You can access an instance in any status.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the instance you want to get access to. You can access an instance in any status.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInstanceAccessInput`](crate::input::GetInstanceAccessInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetInstanceAccessInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetInstanceAccessInput {
                fleet_id: self.fleet_id,
                instance_id: self.instance_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetInstanceAccessInputOperationOutputAlias = crate::operation::GetInstanceAccess;
#[doc(hidden)]
pub type GetInstanceAccessInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetInstanceAccessInput {
    /// Consumes the builder and constructs an Operation<[`GetInstanceAccess`](crate::operation::GetInstanceAccess)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetInstanceAccess,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetInstanceAccessInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetInstanceAccessInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetInstanceAccessInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.GetInstanceAccess",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_instance_access(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetInstanceAccess::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetInstanceAccess",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetInstanceAccessInput`](crate::input::GetInstanceAccessInput)
    pub fn builder() -> crate::input::get_instance_access_input::Builder {
        crate::input::get_instance_access_input::Builder::default()
    }
}

/// See [`ListAliasesInput`](crate::input::ListAliasesInput)
pub mod list_aliases_input {
    /// A builder for [`ListAliasesInput`](crate::input::ListAliasesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) routing_strategy_type: std::option::Option<crate::model::RoutingStrategyType>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The routing type to filter results on. Use this parameter to retrieve only aliases with a certain routing type. To retrieve all aliases, leave this parameter empty.</p>
        /// <p>Possible routing types include the following:</p>
        /// <ul>
        /// <li> <p> <b>SIMPLE</b> -- The alias resolves to one specific fleet. Use this type when routing to active fleets.</p> </li>
        /// <li> <p> <b>TERMINAL</b> -- The alias does not resolve to a fleet but instead can be used to display a message to the user. A terminal alias throws a TerminalRoutingStrategyException with the <code>RoutingStrategy</code> message embedded.</p> </li>
        /// </ul>
        pub fn routing_strategy_type(mut self, input: crate::model::RoutingStrategyType) -> Self {
            self.routing_strategy_type = Some(input);
            self
        }
        /// <p>The routing type to filter results on. Use this parameter to retrieve only aliases with a certain routing type. To retrieve all aliases, leave this parameter empty.</p>
        /// <p>Possible routing types include the following:</p>
        /// <ul>
        /// <li> <p> <b>SIMPLE</b> -- The alias resolves to one specific fleet. Use this type when routing to active fleets.</p> </li>
        /// <li> <p> <b>TERMINAL</b> -- The alias does not resolve to a fleet but instead can be used to display a message to the user. A terminal alias throws a TerminalRoutingStrategyException with the <code>RoutingStrategy</code> message embedded.</p> </li>
        /// </ul>
        pub fn set_routing_strategy_type(
            mut self,
            input: std::option::Option<crate::model::RoutingStrategyType>,
        ) -> Self {
            self.routing_strategy_type = input;
            self
        }
        /// <p>A descriptive label that is associated with an alias. Alias names do not need to be unique.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A descriptive label that is associated with an alias. Alias names do not need to be unique.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAliasesInput`](crate::input::ListAliasesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAliasesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAliasesInput {
                routing_strategy_type: self.routing_strategy_type,
                name: self.name,
                limit: self.limit,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAliasesInputOperationOutputAlias = crate::operation::ListAliases;
#[doc(hidden)]
pub type ListAliasesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAliasesInput {
    /// Consumes the builder and constructs an Operation<[`ListAliases`](crate::operation::ListAliases)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAliases,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAliasesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAliasesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAliasesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.ListAliases",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_aliases(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAliases::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAliases",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAliasesInput`](crate::input::ListAliasesInput)
    pub fn builder() -> crate::input::list_aliases_input::Builder {
        crate::input::list_aliases_input::Builder::default()
    }
}

/// See [`ListBuildsInput`](crate::input::ListBuildsInput)
pub mod list_builds_input {
    /// A builder for [`ListBuildsInput`](crate::input::ListBuildsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::BuildStatus>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Build status to filter results by. To retrieve all builds, leave this parameter empty.</p>
        /// <p>Possible build statuses include the following:</p>
        /// <ul>
        /// <li> <p> <b>INITIALIZED</b> -- A new build has been defined, but no files have been uploaded. You cannot create fleets for builds that are in this status. When a build is successfully created, the build status is set to this value. </p> </li>
        /// <li> <p> <b>READY</b> -- The game build has been successfully uploaded. You can now create new fleets for this build.</p> </li>
        /// <li> <p> <b>FAILED</b> -- The game build upload failed. You cannot create new fleets for this build. </p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::BuildStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Build status to filter results by. To retrieve all builds, leave this parameter empty.</p>
        /// <p>Possible build statuses include the following:</p>
        /// <ul>
        /// <li> <p> <b>INITIALIZED</b> -- A new build has been defined, but no files have been uploaded. You cannot create fleets for builds that are in this status. When a build is successfully created, the build status is set to this value. </p> </li>
        /// <li> <p> <b>READY</b> -- The game build has been successfully uploaded. You can now create new fleets for this build.</p> </li>
        /// <li> <p> <b>FAILED</b> -- The game build upload failed. You cannot create new fleets for this build. </p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<crate::model::BuildStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBuildsInput`](crate::input::ListBuildsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBuildsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBuildsInput {
                status: self.status,
                limit: self.limit,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBuildsInputOperationOutputAlias = crate::operation::ListBuilds;
#[doc(hidden)]
pub type ListBuildsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListBuildsInput {
    /// Consumes the builder and constructs an Operation<[`ListBuilds`](crate::operation::ListBuilds)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBuilds,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListBuildsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListBuildsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListBuildsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.ListBuilds",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_builds(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBuilds::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBuilds",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListBuildsInput`](crate::input::ListBuildsInput)
    pub fn builder() -> crate::input::list_builds_input::Builder {
        crate::input::list_builds_input::Builder::default()
    }
}

/// See [`ListFleetsInput`](crate::input::ListFleetsInput)
pub mod list_fleets_input {
    /// A builder for [`ListFleetsInput`](crate::input::ListFleetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) build_id: std::option::Option<std::string::String>,
        pub(crate) script_id: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the build to request fleets for. Use this parameter to return only fleets using a specified build. Use either the build ID or ARN value.</p>
        pub fn build_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.build_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the build to request fleets for. Use this parameter to return only fleets using a specified build. Use either the build ID or ARN value.</p>
        pub fn set_build_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.build_id = input;
            self
        }
        /// <p>A unique identifier for the Realtime script to request fleets for. Use this parameter to return only fleets using a specified script. Use either the script ID or ARN value.</p>
        pub fn script_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.script_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the Realtime script to request fleets for. Use this parameter to return only fleets using a specified script. Use either the script ID or ARN value.</p>
        pub fn set_script_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.script_id = input;
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFleetsInput`](crate::input::ListFleetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFleetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFleetsInput {
                build_id: self.build_id,
                script_id: self.script_id,
                limit: self.limit,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFleetsInputOperationOutputAlias = crate::operation::ListFleets;
#[doc(hidden)]
pub type ListFleetsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListFleetsInput {
    /// Consumes the builder and constructs an Operation<[`ListFleets`](crate::operation::ListFleets)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFleets,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListFleetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListFleetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListFleetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.ListFleets",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_fleets(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFleets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFleets",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListFleetsInput`](crate::input::ListFleetsInput)
    pub fn builder() -> crate::input::list_fleets_input::Builder {
        crate::input::list_fleets_input::Builder::default()
    }
}

/// See [`ListGameServerGroupsInput`](crate::input::ListGameServerGroupsInput)
pub mod list_game_server_groups_input {
    /// A builder for [`ListGameServerGroupsInput`](crate::input::ListGameServerGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGameServerGroupsInput`](crate::input::ListGameServerGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListGameServerGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListGameServerGroupsInput {
                limit: self.limit,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListGameServerGroupsInputOperationOutputAlias = crate::operation::ListGameServerGroups;
#[doc(hidden)]
pub type ListGameServerGroupsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListGameServerGroupsInput {
    /// Consumes the builder and constructs an Operation<[`ListGameServerGroups`](crate::operation::ListGameServerGroups)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListGameServerGroups,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListGameServerGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListGameServerGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListGameServerGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.ListGameServerGroups",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_game_server_groups(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListGameServerGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListGameServerGroups",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListGameServerGroupsInput`](crate::input::ListGameServerGroupsInput)
    pub fn builder() -> crate::input::list_game_server_groups_input::Builder {
        crate::input::list_game_server_groups_input::Builder::default()
    }
}

/// See [`ListGameServersInput`](crate::input::ListGameServersInput)
pub mod list_game_servers_input {
    /// A builder for [`ListGameServersInput`](crate::input::ListGameServersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_server_group_name: std::option::Option<std::string::String>,
        pub(crate) sort_order: std::option::Option<crate::model::SortOrder>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An identifier for the game server group to retrieve a list of game servers from. Use either the <code>GameServerGroup</code> name or ARN value.</p>
        pub fn game_server_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_server_group_name = Some(input.into());
            self
        }
        /// <p>An identifier for the game server group to retrieve a list of game servers from. Use either the <code>GameServerGroup</code> name or ARN value.</p>
        pub fn set_game_server_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_server_group_name = input;
            self
        }
        /// <p>Indicates how to sort the returned data based on game server registration timestamp. Use <code>ASCENDING</code> to retrieve oldest game servers first, or use <code>DESCENDING</code> to retrieve newest game servers first. If this parameter is left empty, game servers are returned in no particular order.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.sort_order = Some(input);
            self
        }
        /// <p>Indicates how to sort the returned data based on game server registration timestamp. Use <code>ASCENDING</code> to retrieve oldest game servers first, or use <code>DESCENDING</code> to retrieve newest game servers first. If this parameter is left empty, game servers are returned in no particular order.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.sort_order = input;
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGameServersInput`](crate::input::ListGameServersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListGameServersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListGameServersInput {
                game_server_group_name: self.game_server_group_name,
                sort_order: self.sort_order,
                limit: self.limit,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListGameServersInputOperationOutputAlias = crate::operation::ListGameServers;
#[doc(hidden)]
pub type ListGameServersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListGameServersInput {
    /// Consumes the builder and constructs an Operation<[`ListGameServers`](crate::operation::ListGameServers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListGameServers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListGameServersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListGameServersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListGameServersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.ListGameServers",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_game_servers(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListGameServers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListGameServers",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListGameServersInput`](crate::input::ListGameServersInput)
    pub fn builder() -> crate::input::list_game_servers_input::Builder {
        crate::input::list_game_servers_input::Builder::default()
    }
}

/// See [`ListScriptsInput`](crate::input::ListScriptsInput)
pub mod list_scripts_input {
    /// A builder for [`ListScriptsInput`](crate::input::ListScriptsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListScriptsInput`](crate::input::ListScriptsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListScriptsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListScriptsInput {
                limit: self.limit,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListScriptsInputOperationOutputAlias = crate::operation::ListScripts;
#[doc(hidden)]
pub type ListScriptsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListScriptsInput {
    /// Consumes the builder and constructs an Operation<[`ListScripts`](crate::operation::ListScripts)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListScripts,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListScriptsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListScriptsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListScriptsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.ListScripts",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_scripts(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListScripts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListScripts",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListScriptsInput`](crate::input::ListScriptsInput)
    pub fn builder() -> crate::input::list_scripts_input::Builder {
        crate::input::list_scripts_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to and uniquely identifies the GameLift resource that you want to retrieve tags for. GameLift resource ARNs are included in the data object for the resource, which can be retrieved by calling a List or Describe operation for the resource type. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to and uniquely identifies the GameLift resource that you want to retrieve tags for. GameLift resource ARNs are included in the data object for the resource, which can be retrieved by calling a List or Describe operation for the resource type. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.ListTagsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`PutScalingPolicyInput`](crate::input::PutScalingPolicyInput)
pub mod put_scaling_policy_input {
    /// A builder for [`PutScalingPolicyInput`](crate::input::PutScalingPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) scaling_adjustment: std::option::Option<i32>,
        pub(crate) scaling_adjustment_type:
            std::option::Option<crate::model::ScalingAdjustmentType>,
        pub(crate) threshold: std::option::Option<f64>,
        pub(crate) comparison_operator: std::option::Option<crate::model::ComparisonOperatorType>,
        pub(crate) evaluation_periods: std::option::Option<i32>,
        pub(crate) metric_name: std::option::Option<crate::model::MetricName>,
        pub(crate) policy_type: std::option::Option<crate::model::PolicyType>,
        pub(crate) target_configuration: std::option::Option<crate::model::TargetConfiguration>,
    }
    impl Builder {
        /// <p>A descriptive label that is associated with a fleet's scaling policy. Policy names do not need to be unique. A fleet can have only one scaling policy with the same name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A descriptive label that is associated with a fleet's scaling policy. Policy names do not need to be unique. A fleet can have only one scaling policy with the same name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A unique identifier for the fleet to apply this policy to. You can use either the fleet ID or ARN value. The fleet cannot be in any of the following statuses: ERROR or DELETING.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet to apply this policy to. You can use either the fleet ID or ARN value. The fleet cannot be in any of the following statuses: ERROR or DELETING.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p>Amount of adjustment to make, based on the scaling adjustment type.</p>
        pub fn scaling_adjustment(mut self, input: i32) -> Self {
            self.scaling_adjustment = Some(input);
            self
        }
        /// <p>Amount of adjustment to make, based on the scaling adjustment type.</p>
        pub fn set_scaling_adjustment(mut self, input: std::option::Option<i32>) -> Self {
            self.scaling_adjustment = input;
            self
        }
        /// <p>The type of adjustment to make to a fleet's instance count (see <code>FleetCapacity</code>):</p>
        /// <ul>
        /// <li> <p> <b>ChangeInCapacity</b> -- add (or subtract) the scaling adjustment value from the current instance count. Positive values scale up while negative values scale down.</p> </li>
        /// <li> <p> <b>ExactCapacity</b> -- set the instance count to the scaling adjustment value.</p> </li>
        /// <li> <p> <b>PercentChangeInCapacity</b> -- increase or reduce the current instance count by the scaling adjustment, read as a percentage. Positive values scale up while negative values scale down; for example, a value of "-10" scales the fleet down by 10%.</p> </li>
        /// </ul>
        pub fn scaling_adjustment_type(
            mut self,
            input: crate::model::ScalingAdjustmentType,
        ) -> Self {
            self.scaling_adjustment_type = Some(input);
            self
        }
        /// <p>The type of adjustment to make to a fleet's instance count (see <code>FleetCapacity</code>):</p>
        /// <ul>
        /// <li> <p> <b>ChangeInCapacity</b> -- add (or subtract) the scaling adjustment value from the current instance count. Positive values scale up while negative values scale down.</p> </li>
        /// <li> <p> <b>ExactCapacity</b> -- set the instance count to the scaling adjustment value.</p> </li>
        /// <li> <p> <b>PercentChangeInCapacity</b> -- increase or reduce the current instance count by the scaling adjustment, read as a percentage. Positive values scale up while negative values scale down; for example, a value of "-10" scales the fleet down by 10%.</p> </li>
        /// </ul>
        pub fn set_scaling_adjustment_type(
            mut self,
            input: std::option::Option<crate::model::ScalingAdjustmentType>,
        ) -> Self {
            self.scaling_adjustment_type = input;
            self
        }
        /// <p>Metric value used to trigger a scaling event.</p>
        pub fn threshold(mut self, input: f64) -> Self {
            self.threshold = Some(input);
            self
        }
        /// <p>Metric value used to trigger a scaling event.</p>
        pub fn set_threshold(mut self, input: std::option::Option<f64>) -> Self {
            self.threshold = input;
            self
        }
        /// <p>Comparison operator to use when measuring the metric against the threshold value.</p>
        pub fn comparison_operator(mut self, input: crate::model::ComparisonOperatorType) -> Self {
            self.comparison_operator = Some(input);
            self
        }
        /// <p>Comparison operator to use when measuring the metric against the threshold value.</p>
        pub fn set_comparison_operator(
            mut self,
            input: std::option::Option<crate::model::ComparisonOperatorType>,
        ) -> Self {
            self.comparison_operator = input;
            self
        }
        /// <p>Length of time (in minutes) the metric must be at or beyond the threshold before a scaling event is triggered.</p>
        pub fn evaluation_periods(mut self, input: i32) -> Self {
            self.evaluation_periods = Some(input);
            self
        }
        /// <p>Length of time (in minutes) the metric must be at or beyond the threshold before a scaling event is triggered.</p>
        pub fn set_evaluation_periods(mut self, input: std::option::Option<i32>) -> Self {
            self.evaluation_periods = input;
            self
        }
        /// <p>Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment. For detailed descriptions of fleet metrics, see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html">Monitor Amazon GameLift with Amazon CloudWatch</a>. </p>
        /// <ul>
        /// <li> <p> <b>ActivatingGameSessions</b> -- Game sessions in the process of being created.</p> </li>
        /// <li> <p> <b>ActiveGameSessions</b> -- Game sessions that are currently running.</p> </li>
        /// <li> <p> <b>ActiveInstances</b> -- Fleet instances that are currently running at least one game session.</p> </li>
        /// <li> <p> <b>AvailableGameSessions</b> -- Additional game sessions that fleet could host simultaneously, given current capacity.</p> </li>
        /// <li> <p> <b>AvailablePlayerSessions</b> -- Empty player slots in currently active game sessions. This includes game sessions that are not currently accepting players. Reserved player slots are not included.</p> </li>
        /// <li> <p> <b>CurrentPlayerSessions</b> -- Player slots in active game sessions that are being used by a player or are reserved for a player. </p> </li>
        /// <li> <p> <b>IdleInstances</b> -- Active instances that are currently hosting zero game sessions. </p> </li>
        /// <li> <p> <b>PercentAvailableGameSessions</b> -- Unused percentage of the total number of game sessions that a fleet could host simultaneously, given current capacity. Use this metric for a target-based scaling policy.</p> </li>
        /// <li> <p> <b>PercentIdleInstances</b> -- Percentage of the total number of active instances that are hosting zero game sessions.</p> </li>
        /// <li> <p> <b>QueueDepth</b> -- Pending game session placement requests, in any queue, where the current fleet is the top-priority destination.</p> </li>
        /// <li> <p> <b>WaitTime</b> -- Current wait time for pending game session placement requests, in any queue, where the current fleet is the top-priority destination. </p> </li>
        /// </ul>
        pub fn metric_name(mut self, input: crate::model::MetricName) -> Self {
            self.metric_name = Some(input);
            self
        }
        /// <p>Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment. For detailed descriptions of fleet metrics, see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html">Monitor Amazon GameLift with Amazon CloudWatch</a>. </p>
        /// <ul>
        /// <li> <p> <b>ActivatingGameSessions</b> -- Game sessions in the process of being created.</p> </li>
        /// <li> <p> <b>ActiveGameSessions</b> -- Game sessions that are currently running.</p> </li>
        /// <li> <p> <b>ActiveInstances</b> -- Fleet instances that are currently running at least one game session.</p> </li>
        /// <li> <p> <b>AvailableGameSessions</b> -- Additional game sessions that fleet could host simultaneously, given current capacity.</p> </li>
        /// <li> <p> <b>AvailablePlayerSessions</b> -- Empty player slots in currently active game sessions. This includes game sessions that are not currently accepting players. Reserved player slots are not included.</p> </li>
        /// <li> <p> <b>CurrentPlayerSessions</b> -- Player slots in active game sessions that are being used by a player or are reserved for a player. </p> </li>
        /// <li> <p> <b>IdleInstances</b> -- Active instances that are currently hosting zero game sessions. </p> </li>
        /// <li> <p> <b>PercentAvailableGameSessions</b> -- Unused percentage of the total number of game sessions that a fleet could host simultaneously, given current capacity. Use this metric for a target-based scaling policy.</p> </li>
        /// <li> <p> <b>PercentIdleInstances</b> -- Percentage of the total number of active instances that are hosting zero game sessions.</p> </li>
        /// <li> <p> <b>QueueDepth</b> -- Pending game session placement requests, in any queue, where the current fleet is the top-priority destination.</p> </li>
        /// <li> <p> <b>WaitTime</b> -- Current wait time for pending game session placement requests, in any queue, where the current fleet is the top-priority destination. </p> </li>
        /// </ul>
        pub fn set_metric_name(
            mut self,
            input: std::option::Option<crate::model::MetricName>,
        ) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>The type of scaling policy to create. For a target-based policy, set the parameter <i>MetricName</i> to 'PercentAvailableGameSessions' and specify a <i>TargetConfiguration</i>. For a rule-based policy set the following parameters: <i>MetricName</i>, <i>ComparisonOperator</i>, <i>Threshold</i>, <i>EvaluationPeriods</i>, <i>ScalingAdjustmentType</i>, and <i>ScalingAdjustment</i>.</p>
        pub fn policy_type(mut self, input: crate::model::PolicyType) -> Self {
            self.policy_type = Some(input);
            self
        }
        /// <p>The type of scaling policy to create. For a target-based policy, set the parameter <i>MetricName</i> to 'PercentAvailableGameSessions' and specify a <i>TargetConfiguration</i>. For a rule-based policy set the following parameters: <i>MetricName</i>, <i>ComparisonOperator</i>, <i>Threshold</i>, <i>EvaluationPeriods</i>, <i>ScalingAdjustmentType</i>, and <i>ScalingAdjustment</i>.</p>
        pub fn set_policy_type(
            mut self,
            input: std::option::Option<crate::model::PolicyType>,
        ) -> Self {
            self.policy_type = input;
            self
        }
        /// <p>An object that contains settings for a target-based scaling policy.</p>
        pub fn target_configuration(mut self, input: crate::model::TargetConfiguration) -> Self {
            self.target_configuration = Some(input);
            self
        }
        /// <p>An object that contains settings for a target-based scaling policy.</p>
        pub fn set_target_configuration(
            mut self,
            input: std::option::Option<crate::model::TargetConfiguration>,
        ) -> Self {
            self.target_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`PutScalingPolicyInput`](crate::input::PutScalingPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutScalingPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutScalingPolicyInput {
                name: self.name,
                fleet_id: self.fleet_id,
                scaling_adjustment: self.scaling_adjustment.unwrap_or_default(),
                scaling_adjustment_type: self.scaling_adjustment_type,
                threshold: self.threshold.unwrap_or_default(),
                comparison_operator: self.comparison_operator,
                evaluation_periods: self.evaluation_periods,
                metric_name: self.metric_name,
                policy_type: self.policy_type,
                target_configuration: self.target_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type PutScalingPolicyInputOperationOutputAlias = crate::operation::PutScalingPolicy;
#[doc(hidden)]
pub type PutScalingPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutScalingPolicyInput {
    /// Consumes the builder and constructs an Operation<[`PutScalingPolicy`](crate::operation::PutScalingPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutScalingPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutScalingPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutScalingPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutScalingPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.PutScalingPolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_scaling_policy(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutScalingPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutScalingPolicy",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutScalingPolicyInput`](crate::input::PutScalingPolicyInput)
    pub fn builder() -> crate::input::put_scaling_policy_input::Builder {
        crate::input::put_scaling_policy_input::Builder::default()
    }
}

/// See [`RegisterGameServerInput`](crate::input::RegisterGameServerInput)
pub mod register_game_server_input {
    /// A builder for [`RegisterGameServerInput`](crate::input::RegisterGameServerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_server_group_name: std::option::Option<std::string::String>,
        pub(crate) game_server_id: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) connection_info: std::option::Option<std::string::String>,
        pub(crate) game_server_data: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the game server group where the game server is running. Use either the <code>GameServerGroup</code> name or ARN value.</p>
        pub fn game_server_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_server_group_name = Some(input.into());
            self
        }
        /// <p>A unique identifier for the game server group where the game server is running. Use either the <code>GameServerGroup</code> name or ARN value.</p>
        pub fn set_game_server_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_server_group_name = input;
            self
        }
        /// <p>A custom string that uniquely identifies the game server to register. Game server IDs are developer-defined and must be unique across all game server groups in your AWS account.</p>
        pub fn game_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_server_id = Some(input.into());
            self
        }
        /// <p>A custom string that uniquely identifies the game server to register. Game server IDs are developer-defined and must be unique across all game server groups in your AWS account.</p>
        pub fn set_game_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_server_id = input;
            self
        }
        /// <p>The unique identifier for the instance where the game server is running. This ID is available in the instance metadata. EC2 instance IDs use a 17-character format, for example: <code>i-1234567890abcdef0</code>.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the instance where the game server is running. This ID is available in the instance metadata. EC2 instance IDs use a 17-character format, for example: <code>i-1234567890abcdef0</code>.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>Information that is needed to make inbound client connections to the game server. This might include the IP address and port, DNS name, and other information.</p>
        pub fn connection_info(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_info = Some(input.into());
            self
        }
        /// <p>Information that is needed to make inbound client connections to the game server. This might include the IP address and port, DNS name, and other information.</p>
        pub fn set_connection_info(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_info = input;
            self
        }
        /// <p>A set of custom game server properties, formatted as a single string value. This data is passed to a game client or service when it requests information on game servers using <code>ListGameServers</code> or <code>ClaimGameServer</code>. </p>
        pub fn game_server_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_server_data = Some(input.into());
            self
        }
        /// <p>A set of custom game server properties, formatted as a single string value. This data is passed to a game client or service when it requests information on game servers using <code>ListGameServers</code> or <code>ClaimGameServer</code>. </p>
        pub fn set_game_server_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_server_data = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterGameServerInput`](crate::input::RegisterGameServerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterGameServerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterGameServerInput {
                game_server_group_name: self.game_server_group_name,
                game_server_id: self.game_server_id,
                instance_id: self.instance_id,
                connection_info: self.connection_info,
                game_server_data: self.game_server_data,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterGameServerInputOperationOutputAlias = crate::operation::RegisterGameServer;
#[doc(hidden)]
pub type RegisterGameServerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RegisterGameServerInput {
    /// Consumes the builder and constructs an Operation<[`RegisterGameServer`](crate::operation::RegisterGameServer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterGameServer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RegisterGameServerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RegisterGameServerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RegisterGameServerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.RegisterGameServer",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_register_game_server(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterGameServer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterGameServer",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RegisterGameServerInput`](crate::input::RegisterGameServerInput)
    pub fn builder() -> crate::input::register_game_server_input::Builder {
        crate::input::register_game_server_input::Builder::default()
    }
}

/// See [`RequestUploadCredentialsInput`](crate::input::RequestUploadCredentialsInput)
pub mod request_upload_credentials_input {
    /// A builder for [`RequestUploadCredentialsInput`](crate::input::RequestUploadCredentialsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) build_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the build to get credentials for. You can use either the build ID or ARN value. </p>
        pub fn build_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.build_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the build to get credentials for. You can use either the build ID or ARN value. </p>
        pub fn set_build_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.build_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestUploadCredentialsInput`](crate::input::RequestUploadCredentialsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RequestUploadCredentialsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RequestUploadCredentialsInput {
                build_id: self.build_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RequestUploadCredentialsInputOperationOutputAlias =
    crate::operation::RequestUploadCredentials;
#[doc(hidden)]
pub type RequestUploadCredentialsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RequestUploadCredentialsInput {
    /// Consumes the builder and constructs an Operation<[`RequestUploadCredentials`](crate::operation::RequestUploadCredentials)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RequestUploadCredentials,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RequestUploadCredentialsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RequestUploadCredentialsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RequestUploadCredentialsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.RequestUploadCredentials",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_request_upload_credentials(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RequestUploadCredentials::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RequestUploadCredentials",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RequestUploadCredentialsInput`](crate::input::RequestUploadCredentialsInput)
    pub fn builder() -> crate::input::request_upload_credentials_input::Builder {
        crate::input::request_upload_credentials_input::Builder::default()
    }
}

/// See [`ResolveAliasInput`](crate::input::ResolveAliasInput)
pub mod resolve_alias_input {
    /// A builder for [`ResolveAliasInput`](crate::input::ResolveAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alias_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the alias that you want to retrieve a fleet ID for. You can use either the alias ID or ARN value.</p>
        pub fn alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the alias that you want to retrieve a fleet ID for. You can use either the alias ID or ARN value.</p>
        pub fn set_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ResolveAliasInput`](crate::input::ResolveAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ResolveAliasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ResolveAliasInput {
                alias_id: self.alias_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ResolveAliasInputOperationOutputAlias = crate::operation::ResolveAlias;
#[doc(hidden)]
pub type ResolveAliasInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ResolveAliasInput {
    /// Consumes the builder and constructs an Operation<[`ResolveAlias`](crate::operation::ResolveAlias)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ResolveAlias,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ResolveAliasInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ResolveAliasInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ResolveAliasInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.ResolveAlias",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_resolve_alias(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ResolveAlias::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ResolveAlias",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ResolveAliasInput`](crate::input::ResolveAliasInput)
    pub fn builder() -> crate::input::resolve_alias_input::Builder {
        crate::input::resolve_alias_input::Builder::default()
    }
}

/// See [`ResumeGameServerGroupInput`](crate::input::ResumeGameServerGroupInput)
pub mod resume_game_server_group_input {
    /// A builder for [`ResumeGameServerGroupInput`](crate::input::ResumeGameServerGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_server_group_name: std::option::Option<std::string::String>,
        pub(crate) resume_actions:
            std::option::Option<std::vec::Vec<crate::model::GameServerGroupAction>>,
    }
    impl Builder {
        /// <p>A unique identifier for the game server group. Use either the <code>GameServerGroup</code> name or ARN value.</p>
        pub fn game_server_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_server_group_name = Some(input.into());
            self
        }
        /// <p>A unique identifier for the game server group. Use either the <code>GameServerGroup</code> name or ARN value.</p>
        pub fn set_game_server_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_server_group_name = input;
            self
        }
        /// Appends an item to `resume_actions`.
        ///
        /// To override the contents of this collection use [`set_resume_actions`](Self::set_resume_actions).
        ///
        /// <p>The activity to resume for this game server group.</p>
        pub fn resume_actions(mut self, input: crate::model::GameServerGroupAction) -> Self {
            let mut v = self.resume_actions.unwrap_or_default();
            v.push(input);
            self.resume_actions = Some(v);
            self
        }
        /// <p>The activity to resume for this game server group.</p>
        pub fn set_resume_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GameServerGroupAction>>,
        ) -> Self {
            self.resume_actions = input;
            self
        }
        /// Consumes the builder and constructs a [`ResumeGameServerGroupInput`](crate::input::ResumeGameServerGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ResumeGameServerGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ResumeGameServerGroupInput {
                game_server_group_name: self.game_server_group_name,
                resume_actions: self.resume_actions,
            })
        }
    }
}
#[doc(hidden)]
pub type ResumeGameServerGroupInputOperationOutputAlias = crate::operation::ResumeGameServerGroup;
#[doc(hidden)]
pub type ResumeGameServerGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ResumeGameServerGroupInput {
    /// Consumes the builder and constructs an Operation<[`ResumeGameServerGroup`](crate::operation::ResumeGameServerGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ResumeGameServerGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ResumeGameServerGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ResumeGameServerGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ResumeGameServerGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.ResumeGameServerGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_resume_game_server_group(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ResumeGameServerGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ResumeGameServerGroup",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ResumeGameServerGroupInput`](crate::input::ResumeGameServerGroupInput)
    pub fn builder() -> crate::input::resume_game_server_group_input::Builder {
        crate::input::resume_game_server_group_input::Builder::default()
    }
}

/// See [`SearchGameSessionsInput`](crate::input::SearchGameSessionsInput)
pub mod search_game_sessions_input {
    /// A builder for [`SearchGameSessionsInput`](crate::input::SearchGameSessionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) alias_id: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) filter_expression: std::option::Option<std::string::String>,
        pub(crate) sort_expression: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet to search for active game sessions. You can use either the fleet ID or ARN value. Each request must reference either a fleet ID or alias ID, but not both.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet to search for active game sessions. You can use either the fleet ID or ARN value. Each request must reference either a fleet ID or alias ID, but not both.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p>A unique identifier for the alias associated with the fleet to search for active game sessions. You can use either the alias ID or ARN value. Each request must reference either a fleet ID or alias ID, but not both.</p>
        pub fn alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the alias associated with the fleet to search for active game sessions. You can use either the alias ID or ARN value. Each request must reference either a fleet ID or alias ID, but not both.</p>
        pub fn set_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_id = input;
            self
        }
        /// <p>A fleet location to search for game sessions. You can specify a fleet's home Region or a remote location. Use the AWS Region code format, such as <code>us-west-2</code>. </p>
        /// <p> </p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>A fleet location to search for game sessions. You can specify a fleet's home Region or a remote location. Use the AWS Region code format, such as <code>us-west-2</code>. </p>
        /// <p> </p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>String containing the search criteria for the session search. If no filter expression is included, the request returns results for all game sessions in the fleet that are in <code>ACTIVE</code> status.</p>
        /// <p>A filter expression can contain one or multiple conditions. Each condition consists of the following:</p>
        /// <ul>
        /// <li> <p> <b>Operand</b> -- Name of a game session attribute. Valid values are <code>gameSessionName</code>, <code>gameSessionId</code>, <code>gameSessionProperties</code>, <code>maximumSessions</code>, <code>creationTimeMillis</code>, <code>playerSessionCount</code>, <code>hasAvailablePlayerSessions</code>.</p> </li>
        /// <li> <p> <b>Comparator</b> -- Valid comparators are: <code>=</code>, <code>&lt;&gt;</code>, <code>&lt;</code>, <code>&gt;</code>, <code>&lt;=</code>, <code>&gt;=</code>. </p> </li>
        /// <li> <p> <b>Value</b> -- Value to be searched for. Values may be numbers, boolean values (true/false) or strings depending on the operand. String values are case sensitive and must be enclosed in single quotes. Special characters must be escaped. Boolean and string values can only be used with the comparators <code>=</code> and <code>&lt;&gt;</code>. For example, the following filter expression searches on <code>gameSessionName</code>: "<code>FilterExpression": "gameSessionName = 'Matt\\'s Awesome Game 1'"</code>. </p> </li>
        /// </ul>
        /// <p>To chain multiple conditions in a single expression, use the logical keywords <code>AND</code>, <code>OR</code>, and <code>NOT</code> and parentheses as needed. For example: <code>x AND y AND NOT z</code>, <code>NOT (x OR y)</code>.</p>
        /// <p>Session search evaluates conditions from left to right using the following precedence rules:</p>
        /// <ol>
        /// <li> <p> <code>=</code>, <code>&lt;&gt;</code>, <code>&lt;</code>, <code>&gt;</code>, <code>&lt;=</code>, <code>&gt;=</code> </p> </li>
        /// <li> <p>Parentheses</p> </li>
        /// <li> <p>NOT</p> </li>
        /// <li> <p>AND</p> </li>
        /// <li> <p>OR</p> </li>
        /// </ol>
        /// <p>For example, this filter expression retrieves game sessions hosting at least ten players that have an open player slot: <code>"maximumSessions&gt;=10 AND hasAvailablePlayerSessions=true"</code>. </p>
        pub fn filter_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.filter_expression = Some(input.into());
            self
        }
        /// <p>String containing the search criteria for the session search. If no filter expression is included, the request returns results for all game sessions in the fleet that are in <code>ACTIVE</code> status.</p>
        /// <p>A filter expression can contain one or multiple conditions. Each condition consists of the following:</p>
        /// <ul>
        /// <li> <p> <b>Operand</b> -- Name of a game session attribute. Valid values are <code>gameSessionName</code>, <code>gameSessionId</code>, <code>gameSessionProperties</code>, <code>maximumSessions</code>, <code>creationTimeMillis</code>, <code>playerSessionCount</code>, <code>hasAvailablePlayerSessions</code>.</p> </li>
        /// <li> <p> <b>Comparator</b> -- Valid comparators are: <code>=</code>, <code>&lt;&gt;</code>, <code>&lt;</code>, <code>&gt;</code>, <code>&lt;=</code>, <code>&gt;=</code>. </p> </li>
        /// <li> <p> <b>Value</b> -- Value to be searched for. Values may be numbers, boolean values (true/false) or strings depending on the operand. String values are case sensitive and must be enclosed in single quotes. Special characters must be escaped. Boolean and string values can only be used with the comparators <code>=</code> and <code>&lt;&gt;</code>. For example, the following filter expression searches on <code>gameSessionName</code>: "<code>FilterExpression": "gameSessionName = 'Matt\\'s Awesome Game 1'"</code>. </p> </li>
        /// </ul>
        /// <p>To chain multiple conditions in a single expression, use the logical keywords <code>AND</code>, <code>OR</code>, and <code>NOT</code> and parentheses as needed. For example: <code>x AND y AND NOT z</code>, <code>NOT (x OR y)</code>.</p>
        /// <p>Session search evaluates conditions from left to right using the following precedence rules:</p>
        /// <ol>
        /// <li> <p> <code>=</code>, <code>&lt;&gt;</code>, <code>&lt;</code>, <code>&gt;</code>, <code>&lt;=</code>, <code>&gt;=</code> </p> </li>
        /// <li> <p>Parentheses</p> </li>
        /// <li> <p>NOT</p> </li>
        /// <li> <p>AND</p> </li>
        /// <li> <p>OR</p> </li>
        /// </ol>
        /// <p>For example, this filter expression retrieves game sessions hosting at least ten players that have an open player slot: <code>"maximumSessions&gt;=10 AND hasAvailablePlayerSessions=true"</code>. </p>
        pub fn set_filter_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.filter_expression = input;
            self
        }
        /// <p>Instructions on how to sort the search results. If no sort expression is included, the request returns results in random order. A sort expression consists of the following elements:</p>
        /// <ul>
        /// <li> <p> <b>Operand</b> -- Name of a game session attribute. Valid values are <code>gameSessionName</code>, <code>gameSessionId</code>, <code>gameSessionProperties</code>, <code>maximumSessions</code>, <code>creationTimeMillis</code>, <code>playerSessionCount</code>, <code>hasAvailablePlayerSessions</code>.</p> </li>
        /// <li> <p> <b>Order</b> -- Valid sort orders are <code>ASC</code> (ascending) and <code>DESC</code> (descending).</p> </li>
        /// </ul>
        /// <p>For example, this sort expression returns the oldest active sessions first: <code>"SortExpression": "creationTimeMillis ASC"</code>. Results with a null value for the sort operand are returned at the end of the list.</p>
        pub fn sort_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.sort_expression = Some(input.into());
            self
        }
        /// <p>Instructions on how to sort the search results. If no sort expression is included, the request returns results in random order. A sort expression consists of the following elements:</p>
        /// <ul>
        /// <li> <p> <b>Operand</b> -- Name of a game session attribute. Valid values are <code>gameSessionName</code>, <code>gameSessionId</code>, <code>gameSessionProperties</code>, <code>maximumSessions</code>, <code>creationTimeMillis</code>, <code>playerSessionCount</code>, <code>hasAvailablePlayerSessions</code>.</p> </li>
        /// <li> <p> <b>Order</b> -- Valid sort orders are <code>ASC</code> (ascending) and <code>DESC</code> (descending).</p> </li>
        /// </ul>
        /// <p>For example, this sort expression returns the oldest active sessions first: <code>"SortExpression": "creationTimeMillis ASC"</code>. Results with a null value for the sort operand are returned at the end of the list.</p>
        pub fn set_sort_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sort_expression = input;
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages. The maximum number of results returned is 20, even if this value is not set or is set higher than 20. </p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages. The maximum number of results returned is 20, even if this value is not set or is set higher than 20. </p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchGameSessionsInput`](crate::input::SearchGameSessionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchGameSessionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchGameSessionsInput {
                fleet_id: self.fleet_id,
                alias_id: self.alias_id,
                location: self.location,
                filter_expression: self.filter_expression,
                sort_expression: self.sort_expression,
                limit: self.limit,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchGameSessionsInputOperationOutputAlias = crate::operation::SearchGameSessions;
#[doc(hidden)]
pub type SearchGameSessionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SearchGameSessionsInput {
    /// Consumes the builder and constructs an Operation<[`SearchGameSessions`](crate::operation::SearchGameSessions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchGameSessions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SearchGameSessionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SearchGameSessionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SearchGameSessionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.SearchGameSessions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_search_game_sessions(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchGameSessions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchGameSessions",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SearchGameSessionsInput`](crate::input::SearchGameSessionsInput)
    pub fn builder() -> crate::input::search_game_sessions_input::Builder {
        crate::input::search_game_sessions_input::Builder::default()
    }
}

/// See [`StartFleetActionsInput`](crate::input::StartFleetActionsInput)
pub mod start_fleet_actions_input {
    /// A builder for [`StartFleetActionsInput`](crate::input::StartFleetActionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) actions: std::option::Option<std::vec::Vec<crate::model::FleetAction>>,
        pub(crate) location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet to restart actions on. You can use either the fleet ID or ARN value.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet to restart actions on. You can use either the fleet ID or ARN value.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>List of actions to restart on the fleet.</p>
        pub fn actions(mut self, input: crate::model::FleetAction) -> Self {
            let mut v = self.actions.unwrap_or_default();
            v.push(input);
            self.actions = Some(v);
            self
        }
        /// <p>List of actions to restart on the fleet.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FleetAction>>,
        ) -> Self {
            self.actions = input;
            self
        }
        /// <p>The fleet location to restart fleet actions for. Specify a location in the form of an AWS Region code, such as <code>us-west-2</code>.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The fleet location to restart fleet actions for. Specify a location in the form of an AWS Region code, such as <code>us-west-2</code>.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`StartFleetActionsInput`](crate::input::StartFleetActionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartFleetActionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartFleetActionsInput {
                fleet_id: self.fleet_id,
                actions: self.actions,
                location: self.location,
            })
        }
    }
}
#[doc(hidden)]
pub type StartFleetActionsInputOperationOutputAlias = crate::operation::StartFleetActions;
#[doc(hidden)]
pub type StartFleetActionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartFleetActionsInput {
    /// Consumes the builder and constructs an Operation<[`StartFleetActions`](crate::operation::StartFleetActions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartFleetActions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartFleetActionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartFleetActionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartFleetActionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.StartFleetActions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_fleet_actions(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartFleetActions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartFleetActions",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartFleetActionsInput`](crate::input::StartFleetActionsInput)
    pub fn builder() -> crate::input::start_fleet_actions_input::Builder {
        crate::input::start_fleet_actions_input::Builder::default()
    }
}

/// See [`StartGameSessionPlacementInput`](crate::input::StartGameSessionPlacementInput)
pub mod start_game_session_placement_input {
    /// A builder for [`StartGameSessionPlacementInput`](crate::input::StartGameSessionPlacementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) placement_id: std::option::Option<std::string::String>,
        pub(crate) game_session_queue_name: std::option::Option<std::string::String>,
        pub(crate) game_properties: std::option::Option<std::vec::Vec<crate::model::GameProperty>>,
        pub(crate) maximum_player_session_count: std::option::Option<i32>,
        pub(crate) game_session_name: std::option::Option<std::string::String>,
        pub(crate) player_latencies:
            std::option::Option<std::vec::Vec<crate::model::PlayerLatency>>,
        pub(crate) desired_player_sessions:
            std::option::Option<std::vec::Vec<crate::model::DesiredPlayerSession>>,
        pub(crate) game_session_data: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier to assign to the new game session placement. This value is developer-defined. The value must be unique across all Regions and cannot be reused unless you are resubmitting a canceled or timed-out placement request.</p>
        pub fn placement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.placement_id = Some(input.into());
            self
        }
        /// <p>A unique identifier to assign to the new game session placement. This value is developer-defined. The value must be unique across all Regions and cannot be reused unless you are resubmitting a canceled or timed-out placement request.</p>
        pub fn set_placement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.placement_id = input;
            self
        }
        /// <p>Name of the queue to use to place the new game session. You can use either the queue name or ARN value. </p>
        pub fn game_session_queue_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_session_queue_name = Some(input.into());
            self
        }
        /// <p>Name of the queue to use to place the new game session. You can use either the queue name or ARN value. </p>
        pub fn set_game_session_queue_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_session_queue_name = input;
            self
        }
        /// Appends an item to `game_properties`.
        ///
        /// To override the contents of this collection use [`set_game_properties`](Self::set_game_properties).
        ///
        /// <p>A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>).</p>
        pub fn game_properties(mut self, input: crate::model::GameProperty) -> Self {
            let mut v = self.game_properties.unwrap_or_default();
            v.push(input);
            self.game_properties = Some(v);
            self
        }
        /// <p>A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>).</p>
        pub fn set_game_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GameProperty>>,
        ) -> Self {
            self.game_properties = input;
            self
        }
        /// <p>The maximum number of players that can be connected simultaneously to the game session.</p>
        pub fn maximum_player_session_count(mut self, input: i32) -> Self {
            self.maximum_player_session_count = Some(input);
            self
        }
        /// <p>The maximum number of players that can be connected simultaneously to the game session.</p>
        pub fn set_maximum_player_session_count(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_player_session_count = input;
            self
        }
        /// <p>A descriptive label that is associated with a game session. Session names do not need to be unique.</p>
        pub fn game_session_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_session_name = Some(input.into());
            self
        }
        /// <p>A descriptive label that is associated with a game session. Session names do not need to be unique.</p>
        pub fn set_game_session_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_session_name = input;
            self
        }
        /// Appends an item to `player_latencies`.
        ///
        /// To override the contents of this collection use [`set_player_latencies`](Self::set_player_latencies).
        ///
        /// <p>A set of values, expressed in milliseconds, that indicates the amount of latency that a player experiences when connected to AWS Regions. This information is used to try to place the new game session where it can offer the best possible gameplay experience for the players. </p>
        pub fn player_latencies(mut self, input: crate::model::PlayerLatency) -> Self {
            let mut v = self.player_latencies.unwrap_or_default();
            v.push(input);
            self.player_latencies = Some(v);
            self
        }
        /// <p>A set of values, expressed in milliseconds, that indicates the amount of latency that a player experiences when connected to AWS Regions. This information is used to try to place the new game session where it can offer the best possible gameplay experience for the players. </p>
        pub fn set_player_latencies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlayerLatency>>,
        ) -> Self {
            self.player_latencies = input;
            self
        }
        /// Appends an item to `desired_player_sessions`.
        ///
        /// To override the contents of this collection use [`set_desired_player_sessions`](Self::set_desired_player_sessions).
        ///
        /// <p>Set of information on each player to create a player session for.</p>
        pub fn desired_player_sessions(
            mut self,
            input: crate::model::DesiredPlayerSession,
        ) -> Self {
            let mut v = self.desired_player_sessions.unwrap_or_default();
            v.push(input);
            self.desired_player_sessions = Some(v);
            self
        }
        /// <p>Set of information on each player to create a player session for.</p>
        pub fn set_desired_player_sessions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DesiredPlayerSession>>,
        ) -> Self {
            self.desired_player_sessions = input;
            self
        }
        /// <p>A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>).</p>
        pub fn game_session_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_session_data = Some(input.into());
            self
        }
        /// <p>A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>).</p>
        pub fn set_game_session_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_session_data = input;
            self
        }
        /// Consumes the builder and constructs a [`StartGameSessionPlacementInput`](crate::input::StartGameSessionPlacementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartGameSessionPlacementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartGameSessionPlacementInput {
                placement_id: self.placement_id,
                game_session_queue_name: self.game_session_queue_name,
                game_properties: self.game_properties,
                maximum_player_session_count: self.maximum_player_session_count,
                game_session_name: self.game_session_name,
                player_latencies: self.player_latencies,
                desired_player_sessions: self.desired_player_sessions,
                game_session_data: self.game_session_data,
            })
        }
    }
}
#[doc(hidden)]
pub type StartGameSessionPlacementInputOperationOutputAlias =
    crate::operation::StartGameSessionPlacement;
#[doc(hidden)]
pub type StartGameSessionPlacementInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartGameSessionPlacementInput {
    /// Consumes the builder and constructs an Operation<[`StartGameSessionPlacement`](crate::operation::StartGameSessionPlacement)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartGameSessionPlacement,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartGameSessionPlacementInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartGameSessionPlacementInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartGameSessionPlacementInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.StartGameSessionPlacement",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_game_session_placement(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartGameSessionPlacement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartGameSessionPlacement",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartGameSessionPlacementInput`](crate::input::StartGameSessionPlacementInput)
    pub fn builder() -> crate::input::start_game_session_placement_input::Builder {
        crate::input::start_game_session_placement_input::Builder::default()
    }
}

/// See [`StartMatchBackfillInput`](crate::input::StartMatchBackfillInput)
pub mod start_match_backfill_input {
    /// A builder for [`StartMatchBackfillInput`](crate::input::StartMatchBackfillInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ticket_id: std::option::Option<std::string::String>,
        pub(crate) configuration_name: std::option::Option<std::string::String>,
        pub(crate) game_session_arn: std::option::Option<std::string::String>,
        pub(crate) players: std::option::Option<std::vec::Vec<crate::model::Player>>,
    }
    impl Builder {
        /// <p>A unique identifier for a matchmaking ticket. If no ticket ID is specified here, Amazon GameLift will generate one in the form of a UUID. Use this identifier to track the match backfill ticket status and retrieve match results.</p>
        pub fn ticket_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ticket_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a matchmaking ticket. If no ticket ID is specified here, Amazon GameLift will generate one in the form of a UUID. Use this identifier to track the match backfill ticket status and retrieve match results.</p>
        pub fn set_ticket_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ticket_id = input;
            self
        }
        /// <p>Name of the matchmaker to use for this request. You can use either the configuration name or ARN value. The ARN of the matchmaker that was used with the original game session is listed in the <code>GameSession</code> object, <code>MatchmakerData</code> property.</p>
        pub fn configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_name = Some(input.into());
            self
        }
        /// <p>Name of the matchmaker to use for this request. You can use either the configuration name or ARN value. The ARN of the matchmaker that was used with the original game session is listed in the <code>GameSession</code> object, <code>MatchmakerData</code> property.</p>
        pub fn set_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_name = input;
            self
        }
        /// <p>A unique identifier for the game session. Use the game session ID. When using FlexMatch as a standalone matchmaking solution, this parameter is not needed. </p>
        pub fn game_session_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_session_arn = Some(input.into());
            self
        }
        /// <p>A unique identifier for the game session. Use the game session ID. When using FlexMatch as a standalone matchmaking solution, this parameter is not needed. </p>
        pub fn set_game_session_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_session_arn = input;
            self
        }
        /// Appends an item to `players`.
        ///
        /// To override the contents of this collection use [`set_players`](Self::set_players).
        ///
        /// <p>Match information on all players that are currently assigned to the game session. This information is used by the matchmaker to find new players and add them to the existing game.</p>
        /// <ul>
        /// <li> <p>PlayerID, PlayerAttributes, Team -- This information is maintained in the <code>GameSession</code> object, <code>MatchmakerData</code> property, for all players who are currently assigned to the game session. The matchmaker data is in JSON syntax, formatted as a string. For more details, see <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-server.html#match-server-data"> Match Data</a>. </p> </li>
        /// <li> <p>LatencyInMs -- If the matchmaker uses player latency, include a latency value, in milliseconds, for the Region that the game session is currently in. Do not include latency values for any other Region.</p> </li>
        /// </ul>
        pub fn players(mut self, input: crate::model::Player) -> Self {
            let mut v = self.players.unwrap_or_default();
            v.push(input);
            self.players = Some(v);
            self
        }
        /// <p>Match information on all players that are currently assigned to the game session. This information is used by the matchmaker to find new players and add them to the existing game.</p>
        /// <ul>
        /// <li> <p>PlayerID, PlayerAttributes, Team -- This information is maintained in the <code>GameSession</code> object, <code>MatchmakerData</code> property, for all players who are currently assigned to the game session. The matchmaker data is in JSON syntax, formatted as a string. For more details, see <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-server.html#match-server-data"> Match Data</a>. </p> </li>
        /// <li> <p>LatencyInMs -- If the matchmaker uses player latency, include a latency value, in milliseconds, for the Region that the game session is currently in. Do not include latency values for any other Region.</p> </li>
        /// </ul>
        pub fn set_players(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Player>>,
        ) -> Self {
            self.players = input;
            self
        }
        /// Consumes the builder and constructs a [`StartMatchBackfillInput`](crate::input::StartMatchBackfillInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartMatchBackfillInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartMatchBackfillInput {
                ticket_id: self.ticket_id,
                configuration_name: self.configuration_name,
                game_session_arn: self.game_session_arn,
                players: self.players,
            })
        }
    }
}
#[doc(hidden)]
pub type StartMatchBackfillInputOperationOutputAlias = crate::operation::StartMatchBackfill;
#[doc(hidden)]
pub type StartMatchBackfillInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartMatchBackfillInput {
    /// Consumes the builder and constructs an Operation<[`StartMatchBackfill`](crate::operation::StartMatchBackfill)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartMatchBackfill,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartMatchBackfillInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartMatchBackfillInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartMatchBackfillInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.StartMatchBackfill",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_match_backfill(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartMatchBackfill::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartMatchBackfill",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartMatchBackfillInput`](crate::input::StartMatchBackfillInput)
    pub fn builder() -> crate::input::start_match_backfill_input::Builder {
        crate::input::start_match_backfill_input::Builder::default()
    }
}

/// See [`StartMatchmakingInput`](crate::input::StartMatchmakingInput)
pub mod start_matchmaking_input {
    /// A builder for [`StartMatchmakingInput`](crate::input::StartMatchmakingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ticket_id: std::option::Option<std::string::String>,
        pub(crate) configuration_name: std::option::Option<std::string::String>,
        pub(crate) players: std::option::Option<std::vec::Vec<crate::model::Player>>,
    }
    impl Builder {
        /// <p>A unique identifier for a matchmaking ticket. If no ticket ID is specified here, Amazon GameLift will generate one in the form of a UUID. Use this identifier to track the matchmaking ticket status and retrieve match results.</p>
        pub fn ticket_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ticket_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a matchmaking ticket. If no ticket ID is specified here, Amazon GameLift will generate one in the form of a UUID. Use this identifier to track the matchmaking ticket status and retrieve match results.</p>
        pub fn set_ticket_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ticket_id = input;
            self
        }
        /// <p>Name of the matchmaking configuration to use for this request. Matchmaking configurations must exist in the same Region as this request. You can use either the configuration name or ARN value.</p>
        pub fn configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_name = Some(input.into());
            self
        }
        /// <p>Name of the matchmaking configuration to use for this request. Matchmaking configurations must exist in the same Region as this request. You can use either the configuration name or ARN value.</p>
        pub fn set_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_name = input;
            self
        }
        /// Appends an item to `players`.
        ///
        /// To override the contents of this collection use [`set_players`](Self::set_players).
        ///
        /// <p>Information on each player to be matched. This information must include a player ID, and may contain player attributes and latency data to be used in the matchmaking process. After a successful match, <code>Player</code> objects contain the name of the team the player is assigned to.</p>
        pub fn players(mut self, input: crate::model::Player) -> Self {
            let mut v = self.players.unwrap_or_default();
            v.push(input);
            self.players = Some(v);
            self
        }
        /// <p>Information on each player to be matched. This information must include a player ID, and may contain player attributes and latency data to be used in the matchmaking process. After a successful match, <code>Player</code> objects contain the name of the team the player is assigned to.</p>
        pub fn set_players(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Player>>,
        ) -> Self {
            self.players = input;
            self
        }
        /// Consumes the builder and constructs a [`StartMatchmakingInput`](crate::input::StartMatchmakingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartMatchmakingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartMatchmakingInput {
                ticket_id: self.ticket_id,
                configuration_name: self.configuration_name,
                players: self.players,
            })
        }
    }
}
#[doc(hidden)]
pub type StartMatchmakingInputOperationOutputAlias = crate::operation::StartMatchmaking;
#[doc(hidden)]
pub type StartMatchmakingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartMatchmakingInput {
    /// Consumes the builder and constructs an Operation<[`StartMatchmaking`](crate::operation::StartMatchmaking)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartMatchmaking,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartMatchmakingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartMatchmakingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartMatchmakingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.StartMatchmaking",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_matchmaking(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartMatchmaking::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartMatchmaking",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartMatchmakingInput`](crate::input::StartMatchmakingInput)
    pub fn builder() -> crate::input::start_matchmaking_input::Builder {
        crate::input::start_matchmaking_input::Builder::default()
    }
}

/// See [`StopFleetActionsInput`](crate::input::StopFleetActionsInput)
pub mod stop_fleet_actions_input {
    /// A builder for [`StopFleetActionsInput`](crate::input::StopFleetActionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) actions: std::option::Option<std::vec::Vec<crate::model::FleetAction>>,
        pub(crate) location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet to stop actions on. You can use either the fleet ID or ARN value.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet to stop actions on. You can use either the fleet ID or ARN value.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>List of actions to suspend on the fleet. </p>
        pub fn actions(mut self, input: crate::model::FleetAction) -> Self {
            let mut v = self.actions.unwrap_or_default();
            v.push(input);
            self.actions = Some(v);
            self
        }
        /// <p>List of actions to suspend on the fleet. </p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FleetAction>>,
        ) -> Self {
            self.actions = input;
            self
        }
        /// <p>The fleet location to stop fleet actions for. Specify a location in the form of an AWS Region code, such as <code>us-west-2</code>.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The fleet location to stop fleet actions for. Specify a location in the form of an AWS Region code, such as <code>us-west-2</code>.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`StopFleetActionsInput`](crate::input::StopFleetActionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopFleetActionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopFleetActionsInput {
                fleet_id: self.fleet_id,
                actions: self.actions,
                location: self.location,
            })
        }
    }
}
#[doc(hidden)]
pub type StopFleetActionsInputOperationOutputAlias = crate::operation::StopFleetActions;
#[doc(hidden)]
pub type StopFleetActionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopFleetActionsInput {
    /// Consumes the builder and constructs an Operation<[`StopFleetActions`](crate::operation::StopFleetActions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopFleetActions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopFleetActionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopFleetActionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopFleetActionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.StopFleetActions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_stop_fleet_actions(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopFleetActions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopFleetActions",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopFleetActionsInput`](crate::input::StopFleetActionsInput)
    pub fn builder() -> crate::input::stop_fleet_actions_input::Builder {
        crate::input::stop_fleet_actions_input::Builder::default()
    }
}

/// See [`StopGameSessionPlacementInput`](crate::input::StopGameSessionPlacementInput)
pub mod stop_game_session_placement_input {
    /// A builder for [`StopGameSessionPlacementInput`](crate::input::StopGameSessionPlacementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) placement_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for a game session placement to cancel.</p>
        pub fn placement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.placement_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a game session placement to cancel.</p>
        pub fn set_placement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.placement_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StopGameSessionPlacementInput`](crate::input::StopGameSessionPlacementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopGameSessionPlacementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopGameSessionPlacementInput {
                placement_id: self.placement_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StopGameSessionPlacementInputOperationOutputAlias =
    crate::operation::StopGameSessionPlacement;
#[doc(hidden)]
pub type StopGameSessionPlacementInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopGameSessionPlacementInput {
    /// Consumes the builder and constructs an Operation<[`StopGameSessionPlacement`](crate::operation::StopGameSessionPlacement)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopGameSessionPlacement,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopGameSessionPlacementInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopGameSessionPlacementInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopGameSessionPlacementInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.StopGameSessionPlacement",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_stop_game_session_placement(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopGameSessionPlacement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopGameSessionPlacement",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopGameSessionPlacementInput`](crate::input::StopGameSessionPlacementInput)
    pub fn builder() -> crate::input::stop_game_session_placement_input::Builder {
        crate::input::stop_game_session_placement_input::Builder::default()
    }
}

/// See [`StopMatchmakingInput`](crate::input::StopMatchmakingInput)
pub mod stop_matchmaking_input {
    /// A builder for [`StopMatchmakingInput`](crate::input::StopMatchmakingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ticket_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for a matchmaking ticket.</p>
        pub fn ticket_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ticket_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a matchmaking ticket.</p>
        pub fn set_ticket_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ticket_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StopMatchmakingInput`](crate::input::StopMatchmakingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopMatchmakingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopMatchmakingInput {
                ticket_id: self.ticket_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StopMatchmakingInputOperationOutputAlias = crate::operation::StopMatchmaking;
#[doc(hidden)]
pub type StopMatchmakingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopMatchmakingInput {
    /// Consumes the builder and constructs an Operation<[`StopMatchmaking`](crate::operation::StopMatchmaking)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopMatchmaking,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopMatchmakingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopMatchmakingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopMatchmakingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.StopMatchmaking",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_stop_matchmaking(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopMatchmaking::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopMatchmaking",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopMatchmakingInput`](crate::input::StopMatchmakingInput)
    pub fn builder() -> crate::input::stop_matchmaking_input::Builder {
        crate::input::stop_matchmaking_input::Builder::default()
    }
}

/// See [`SuspendGameServerGroupInput`](crate::input::SuspendGameServerGroupInput)
pub mod suspend_game_server_group_input {
    /// A builder for [`SuspendGameServerGroupInput`](crate::input::SuspendGameServerGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_server_group_name: std::option::Option<std::string::String>,
        pub(crate) suspend_actions:
            std::option::Option<std::vec::Vec<crate::model::GameServerGroupAction>>,
    }
    impl Builder {
        /// <p>A unique identifier for the game server group. Use either the <code>GameServerGroup</code> name or ARN value.</p>
        pub fn game_server_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_server_group_name = Some(input.into());
            self
        }
        /// <p>A unique identifier for the game server group. Use either the <code>GameServerGroup</code> name or ARN value.</p>
        pub fn set_game_server_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_server_group_name = input;
            self
        }
        /// Appends an item to `suspend_actions`.
        ///
        /// To override the contents of this collection use [`set_suspend_actions`](Self::set_suspend_actions).
        ///
        /// <p>The activity to suspend for this game server group.</p>
        pub fn suspend_actions(mut self, input: crate::model::GameServerGroupAction) -> Self {
            let mut v = self.suspend_actions.unwrap_or_default();
            v.push(input);
            self.suspend_actions = Some(v);
            self
        }
        /// <p>The activity to suspend for this game server group.</p>
        pub fn set_suspend_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GameServerGroupAction>>,
        ) -> Self {
            self.suspend_actions = input;
            self
        }
        /// Consumes the builder and constructs a [`SuspendGameServerGroupInput`](crate::input::SuspendGameServerGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SuspendGameServerGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SuspendGameServerGroupInput {
                game_server_group_name: self.game_server_group_name,
                suspend_actions: self.suspend_actions,
            })
        }
    }
}
#[doc(hidden)]
pub type SuspendGameServerGroupInputOperationOutputAlias = crate::operation::SuspendGameServerGroup;
#[doc(hidden)]
pub type SuspendGameServerGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SuspendGameServerGroupInput {
    /// Consumes the builder and constructs an Operation<[`SuspendGameServerGroup`](crate::operation::SuspendGameServerGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SuspendGameServerGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SuspendGameServerGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SuspendGameServerGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SuspendGameServerGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.SuspendGameServerGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_suspend_game_server_group(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SuspendGameServerGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SuspendGameServerGroup",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SuspendGameServerGroupInput`](crate::input::SuspendGameServerGroupInput)
    pub fn builder() -> crate::input::suspend_game_server_group_input::Builder {
        crate::input::suspend_game_server_group_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to and uniquely identifies the GameLift resource that you want to assign tags to. GameLift resource ARNs are included in the data object for the resource, which can be retrieved by calling a List or Describe operation for the resource type. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to and uniquely identifies the GameLift resource that you want to assign tags to. GameLift resource ARNs are included in the data object for the resource, which can be retrieved by calling a List or Describe operation for the resource type. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of one or more tags to assign to the specified GameLift resource. Tags are developer-defined and structured as key-value pairs. The maximum tag limit may be lower than stated. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources</a> for actual tagging limits.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of one or more tags to assign to the specified GameLift resource. Tags are developer-defined and structured as key-value pairs. The maximum tag limit may be lower than stated. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources</a> for actual tagging limits.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.TagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to and uniquely identifies the GameLift resource that you want to remove tags from. GameLift resource ARNs are included in the data object for the resource, which can be retrieved by calling a List or Describe operation for the resource type. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to and uniquely identifies the GameLift resource that you want to remove tags from. GameLift resource ARNs are included in the data object for the resource, which can be retrieved by calling a List or Describe operation for the resource type. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of one or more tag keys to remove from the specified GameLift resource. An AWS resource can have only one tag with a specific tag key, so specifying the tag key identifies which tag to remove. </p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A list of one or more tag keys to remove from the specified GameLift resource. An AWS resource can have only one tag with a specific tag key, so specifying the tag key identifies which tag to remove. </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.UntagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateAliasInput`](crate::input::UpdateAliasInput)
pub mod update_alias_input {
    /// A builder for [`UpdateAliasInput`](crate::input::UpdateAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alias_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) routing_strategy: std::option::Option<crate::model::RoutingStrategy>,
    }
    impl Builder {
        /// <p>A unique identifier for the alias that you want to update. You can use either the alias ID or ARN value.</p>
        pub fn alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the alias that you want to update. You can use either the alias ID or ARN value.</p>
        pub fn set_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_id = input;
            self
        }
        /// <p>A descriptive label that is associated with an alias. Alias names do not need to be unique.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A descriptive label that is associated with an alias. Alias names do not need to be unique.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A human-readable description of the alias.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A human-readable description of the alias.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The routing configuration, including routing type and fleet target, for the alias.</p>
        pub fn routing_strategy(mut self, input: crate::model::RoutingStrategy) -> Self {
            self.routing_strategy = Some(input);
            self
        }
        /// <p>The routing configuration, including routing type and fleet target, for the alias.</p>
        pub fn set_routing_strategy(
            mut self,
            input: std::option::Option<crate::model::RoutingStrategy>,
        ) -> Self {
            self.routing_strategy = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAliasInput`](crate::input::UpdateAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAliasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAliasInput {
                alias_id: self.alias_id,
                name: self.name,
                description: self.description,
                routing_strategy: self.routing_strategy,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAliasInputOperationOutputAlias = crate::operation::UpdateAlias;
#[doc(hidden)]
pub type UpdateAliasInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateAliasInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAlias`](crate::operation::UpdateAlias)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAlias,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAliasInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAliasInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAliasInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.UpdateAlias",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_alias(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAlias::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAlias",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAliasInput`](crate::input::UpdateAliasInput)
    pub fn builder() -> crate::input::update_alias_input::Builder {
        crate::input::update_alias_input::Builder::default()
    }
}

/// See [`UpdateBuildInput`](crate::input::UpdateBuildInput)
pub mod update_build_input {
    /// A builder for [`UpdateBuildInput`](crate::input::UpdateBuildInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) build_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the build to update. You can use either the build ID or ARN value. </p>
        pub fn build_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.build_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the build to update. You can use either the build ID or ARN value. </p>
        pub fn set_build_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.build_id = input;
            self
        }
        /// <p>A descriptive label that is associated with a build. Build names do not need to be unique. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A descriptive label that is associated with a build. Build names do not need to be unique. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Version information that is associated with a build or script. Version strings do not need to be unique.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>Version information that is associated with a build or script. Version strings do not need to be unique.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBuildInput`](crate::input::UpdateBuildInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateBuildInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateBuildInput {
                build_id: self.build_id,
                name: self.name,
                version: self.version,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateBuildInputOperationOutputAlias = crate::operation::UpdateBuild;
#[doc(hidden)]
pub type UpdateBuildInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateBuildInput {
    /// Consumes the builder and constructs an Operation<[`UpdateBuild`](crate::operation::UpdateBuild)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateBuild,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateBuildInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateBuildInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateBuildInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.UpdateBuild",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_build(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateBuild::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateBuild",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateBuildInput`](crate::input::UpdateBuildInput)
    pub fn builder() -> crate::input::update_build_input::Builder {
        crate::input::update_build_input::Builder::default()
    }
}

/// See [`UpdateFleetAttributesInput`](crate::input::UpdateFleetAttributesInput)
pub mod update_fleet_attributes_input {
    /// A builder for [`UpdateFleetAttributesInput`](crate::input::UpdateFleetAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) new_game_session_protection_policy:
            std::option::Option<crate::model::ProtectionPolicy>,
        pub(crate) resource_creation_limit_policy:
            std::option::Option<crate::model::ResourceCreationLimitPolicy>,
        pub(crate) metric_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet to update attribute metadata for. You can use either the fleet ID or ARN value.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet to update attribute metadata for. You can use either the fleet ID or ARN value.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p>A descriptive label that is associated with a fleet. Fleet names do not need to be unique.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A descriptive label that is associated with a fleet. Fleet names do not need to be unique.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A human-readable description of a fleet.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A human-readable description of a fleet.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The game session protection policy to apply to all new instances created in this fleet. Instances that already exist are not affected. You can set protection for individual instances using <code>UpdateGameSession</code>.</p>
        /// <ul>
        /// <li> <p> <b>NoProtection</b> -- The game session can be terminated during a scale-down event.</p> </li>
        /// <li> <p> <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during a scale-down event.</p> </li>
        /// </ul>
        pub fn new_game_session_protection_policy(
            mut self,
            input: crate::model::ProtectionPolicy,
        ) -> Self {
            self.new_game_session_protection_policy = Some(input);
            self
        }
        /// <p>The game session protection policy to apply to all new instances created in this fleet. Instances that already exist are not affected. You can set protection for individual instances using <code>UpdateGameSession</code>.</p>
        /// <ul>
        /// <li> <p> <b>NoProtection</b> -- The game session can be terminated during a scale-down event.</p> </li>
        /// <li> <p> <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during a scale-down event.</p> </li>
        /// </ul>
        pub fn set_new_game_session_protection_policy(
            mut self,
            input: std::option::Option<crate::model::ProtectionPolicy>,
        ) -> Self {
            self.new_game_session_protection_policy = input;
            self
        }
        /// <p>Policy settings that limit the number of game sessions an individual player can create over a span of time. </p>
        pub fn resource_creation_limit_policy(
            mut self,
            input: crate::model::ResourceCreationLimitPolicy,
        ) -> Self {
            self.resource_creation_limit_policy = Some(input);
            self
        }
        /// <p>Policy settings that limit the number of game sessions an individual player can create over a span of time. </p>
        pub fn set_resource_creation_limit_policy(
            mut self,
            input: std::option::Option<crate::model::ResourceCreationLimitPolicy>,
        ) -> Self {
            self.resource_creation_limit_policy = input;
            self
        }
        /// Appends an item to `metric_groups`.
        ///
        /// To override the contents of this collection use [`set_metric_groups`](Self::set_metric_groups).
        ///
        /// <p>The name of a metric group to add this fleet to. Use a metric group in Amazon CloudWatch to aggregate the metrics from multiple fleets. Provide an existing metric group name, or create a new metric group by providing a new name. A fleet can only be in one metric group at a time.</p>
        pub fn metric_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.metric_groups.unwrap_or_default();
            v.push(input.into());
            self.metric_groups = Some(v);
            self
        }
        /// <p>The name of a metric group to add this fleet to. Use a metric group in Amazon CloudWatch to aggregate the metrics from multiple fleets. Provide an existing metric group name, or create a new metric group by providing a new name. A fleet can only be in one metric group at a time.</p>
        pub fn set_metric_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.metric_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFleetAttributesInput`](crate::input::UpdateFleetAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFleetAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFleetAttributesInput {
                fleet_id: self.fleet_id,
                name: self.name,
                description: self.description,
                new_game_session_protection_policy: self.new_game_session_protection_policy,
                resource_creation_limit_policy: self.resource_creation_limit_policy,
                metric_groups: self.metric_groups,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFleetAttributesInputOperationOutputAlias = crate::operation::UpdateFleetAttributes;
#[doc(hidden)]
pub type UpdateFleetAttributesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateFleetAttributesInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFleetAttributes`](crate::operation::UpdateFleetAttributes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFleetAttributes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateFleetAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateFleetAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateFleetAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.UpdateFleetAttributes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_fleet_attributes(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFleetAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFleetAttributes",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateFleetAttributesInput`](crate::input::UpdateFleetAttributesInput)
    pub fn builder() -> crate::input::update_fleet_attributes_input::Builder {
        crate::input::update_fleet_attributes_input::Builder::default()
    }
}

/// See [`UpdateFleetCapacityInput`](crate::input::UpdateFleetCapacityInput)
pub mod update_fleet_capacity_input {
    /// A builder for [`UpdateFleetCapacityInput`](crate::input::UpdateFleetCapacityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) desired_instances: std::option::Option<i32>,
        pub(crate) min_size: std::option::Option<i32>,
        pub(crate) max_size: std::option::Option<i32>,
        pub(crate) location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet to update capacity settings for. You can use either the fleet ID or ARN value.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet to update capacity settings for. You can use either the fleet ID or ARN value.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p>The number of EC2 instances you want to maintain in the specified fleet location. This value must fall between the minimum and maximum size limits.</p>
        pub fn desired_instances(mut self, input: i32) -> Self {
            self.desired_instances = Some(input);
            self
        }
        /// <p>The number of EC2 instances you want to maintain in the specified fleet location. This value must fall between the minimum and maximum size limits.</p>
        pub fn set_desired_instances(mut self, input: std::option::Option<i32>) -> Self {
            self.desired_instances = input;
            self
        }
        /// <p>The minimum number of instances that are allowed in the specified fleet location. If this parameter is not set, the default is 0.</p>
        pub fn min_size(mut self, input: i32) -> Self {
            self.min_size = Some(input);
            self
        }
        /// <p>The minimum number of instances that are allowed in the specified fleet location. If this parameter is not set, the default is 0.</p>
        pub fn set_min_size(mut self, input: std::option::Option<i32>) -> Self {
            self.min_size = input;
            self
        }
        /// <p>The maximum number of instances that are allowed in the specified fleet location. If this parameter is not set, the default is 1.</p>
        pub fn max_size(mut self, input: i32) -> Self {
            self.max_size = Some(input);
            self
        }
        /// <p>The maximum number of instances that are allowed in the specified fleet location. If this parameter is not set, the default is 1.</p>
        pub fn set_max_size(mut self, input: std::option::Option<i32>) -> Self {
            self.max_size = input;
            self
        }
        /// <p>The name of a remote location to update fleet capacity settings for, in the form of an AWS Region code such as <code>us-west-2</code>.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The name of a remote location to update fleet capacity settings for, in the form of an AWS Region code such as <code>us-west-2</code>.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFleetCapacityInput`](crate::input::UpdateFleetCapacityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFleetCapacityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFleetCapacityInput {
                fleet_id: self.fleet_id,
                desired_instances: self.desired_instances,
                min_size: self.min_size,
                max_size: self.max_size,
                location: self.location,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFleetCapacityInputOperationOutputAlias = crate::operation::UpdateFleetCapacity;
#[doc(hidden)]
pub type UpdateFleetCapacityInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateFleetCapacityInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFleetCapacity`](crate::operation::UpdateFleetCapacity)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFleetCapacity,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateFleetCapacityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateFleetCapacityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateFleetCapacityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.UpdateFleetCapacity",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_fleet_capacity(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFleetCapacity::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFleetCapacity",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateFleetCapacityInput`](crate::input::UpdateFleetCapacityInput)
    pub fn builder() -> crate::input::update_fleet_capacity_input::Builder {
        crate::input::update_fleet_capacity_input::Builder::default()
    }
}

/// See [`UpdateFleetPortSettingsInput`](crate::input::UpdateFleetPortSettingsInput)
pub mod update_fleet_port_settings_input {
    /// A builder for [`UpdateFleetPortSettingsInput`](crate::input::UpdateFleetPortSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) inbound_permission_authorizations:
            std::option::Option<std::vec::Vec<crate::model::IpPermission>>,
        pub(crate) inbound_permission_revocations:
            std::option::Option<std::vec::Vec<crate::model::IpPermission>>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet to update port settings for. You can use either the fleet ID or ARN value.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet to update port settings for. You can use either the fleet ID or ARN value.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// Appends an item to `inbound_permission_authorizations`.
        ///
        /// To override the contents of this collection use [`set_inbound_permission_authorizations`](Self::set_inbound_permission_authorizations).
        ///
        /// <p>A collection of port settings to be added to the fleet resource.</p>
        pub fn inbound_permission_authorizations(
            mut self,
            input: crate::model::IpPermission,
        ) -> Self {
            let mut v = self.inbound_permission_authorizations.unwrap_or_default();
            v.push(input);
            self.inbound_permission_authorizations = Some(v);
            self
        }
        /// <p>A collection of port settings to be added to the fleet resource.</p>
        pub fn set_inbound_permission_authorizations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpPermission>>,
        ) -> Self {
            self.inbound_permission_authorizations = input;
            self
        }
        /// Appends an item to `inbound_permission_revocations`.
        ///
        /// To override the contents of this collection use [`set_inbound_permission_revocations`](Self::set_inbound_permission_revocations).
        ///
        /// <p>A collection of port settings to be removed from the fleet resource.</p>
        pub fn inbound_permission_revocations(mut self, input: crate::model::IpPermission) -> Self {
            let mut v = self.inbound_permission_revocations.unwrap_or_default();
            v.push(input);
            self.inbound_permission_revocations = Some(v);
            self
        }
        /// <p>A collection of port settings to be removed from the fleet resource.</p>
        pub fn set_inbound_permission_revocations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpPermission>>,
        ) -> Self {
            self.inbound_permission_revocations = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFleetPortSettingsInput`](crate::input::UpdateFleetPortSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFleetPortSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFleetPortSettingsInput {
                fleet_id: self.fleet_id,
                inbound_permission_authorizations: self.inbound_permission_authorizations,
                inbound_permission_revocations: self.inbound_permission_revocations,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFleetPortSettingsInputOperationOutputAlias =
    crate::operation::UpdateFleetPortSettings;
#[doc(hidden)]
pub type UpdateFleetPortSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateFleetPortSettingsInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFleetPortSettings`](crate::operation::UpdateFleetPortSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFleetPortSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateFleetPortSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateFleetPortSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateFleetPortSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.UpdateFleetPortSettings",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_fleet_port_settings(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFleetPortSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFleetPortSettings",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateFleetPortSettingsInput`](crate::input::UpdateFleetPortSettingsInput)
    pub fn builder() -> crate::input::update_fleet_port_settings_input::Builder {
        crate::input::update_fleet_port_settings_input::Builder::default()
    }
}

/// See [`UpdateGameServerInput`](crate::input::UpdateGameServerInput)
pub mod update_game_server_input {
    /// A builder for [`UpdateGameServerInput`](crate::input::UpdateGameServerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_server_group_name: std::option::Option<std::string::String>,
        pub(crate) game_server_id: std::option::Option<std::string::String>,
        pub(crate) game_server_data: std::option::Option<std::string::String>,
        pub(crate) utilization_status:
            std::option::Option<crate::model::GameServerUtilizationStatus>,
        pub(crate) health_check: std::option::Option<crate::model::GameServerHealthCheck>,
    }
    impl Builder {
        /// <p>A unique identifier for the game server group where the game server is running. Use either the <code>GameServerGroup</code> name or ARN value.</p>
        pub fn game_server_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_server_group_name = Some(input.into());
            self
        }
        /// <p>A unique identifier for the game server group where the game server is running. Use either the <code>GameServerGroup</code> name or ARN value.</p>
        pub fn set_game_server_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_server_group_name = input;
            self
        }
        /// <p>A custom string that uniquely identifies the game server to update.</p>
        pub fn game_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_server_id = Some(input.into());
            self
        }
        /// <p>A custom string that uniquely identifies the game server to update.</p>
        pub fn set_game_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_server_id = input;
            self
        }
        /// <p>A set of custom game server properties, formatted as a single string value. This data is passed to a game client or service when it requests information on game servers using <code>ListGameServers</code> or <code>ClaimGameServer</code>. </p>
        pub fn game_server_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_server_data = Some(input.into());
            self
        }
        /// <p>A set of custom game server properties, formatted as a single string value. This data is passed to a game client or service when it requests information on game servers using <code>ListGameServers</code> or <code>ClaimGameServer</code>. </p>
        pub fn set_game_server_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_server_data = input;
            self
        }
        /// <p>Indicates whether the game server is available or is currently hosting gameplay.</p>
        pub fn utilization_status(
            mut self,
            input: crate::model::GameServerUtilizationStatus,
        ) -> Self {
            self.utilization_status = Some(input);
            self
        }
        /// <p>Indicates whether the game server is available or is currently hosting gameplay.</p>
        pub fn set_utilization_status(
            mut self,
            input: std::option::Option<crate::model::GameServerUtilizationStatus>,
        ) -> Self {
            self.utilization_status = input;
            self
        }
        /// <p>Indicates health status of the game server. A request that includes this parameter updates the game server's <i>LastHealthCheckTime</i> timestamp. </p>
        pub fn health_check(mut self, input: crate::model::GameServerHealthCheck) -> Self {
            self.health_check = Some(input);
            self
        }
        /// <p>Indicates health status of the game server. A request that includes this parameter updates the game server's <i>LastHealthCheckTime</i> timestamp. </p>
        pub fn set_health_check(
            mut self,
            input: std::option::Option<crate::model::GameServerHealthCheck>,
        ) -> Self {
            self.health_check = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGameServerInput`](crate::input::UpdateGameServerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateGameServerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateGameServerInput {
                game_server_group_name: self.game_server_group_name,
                game_server_id: self.game_server_id,
                game_server_data: self.game_server_data,
                utilization_status: self.utilization_status,
                health_check: self.health_check,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateGameServerInputOperationOutputAlias = crate::operation::UpdateGameServer;
#[doc(hidden)]
pub type UpdateGameServerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateGameServerInput {
    /// Consumes the builder and constructs an Operation<[`UpdateGameServer`](crate::operation::UpdateGameServer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateGameServer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateGameServerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateGameServerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateGameServerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.UpdateGameServer",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_game_server(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateGameServer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateGameServer",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateGameServerInput`](crate::input::UpdateGameServerInput)
    pub fn builder() -> crate::input::update_game_server_input::Builder {
        crate::input::update_game_server_input::Builder::default()
    }
}

/// See [`UpdateGameServerGroupInput`](crate::input::UpdateGameServerGroupInput)
pub mod update_game_server_group_input {
    /// A builder for [`UpdateGameServerGroupInput`](crate::input::UpdateGameServerGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_server_group_name: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) instance_definitions:
            std::option::Option<std::vec::Vec<crate::model::InstanceDefinition>>,
        pub(crate) game_server_protection_policy:
            std::option::Option<crate::model::GameServerProtectionPolicy>,
        pub(crate) balancing_strategy: std::option::Option<crate::model::BalancingStrategy>,
    }
    impl Builder {
        /// <p>A unique identifier for the game server group. Use either the <code>GameServerGroup</code> name or ARN value.</p>
        pub fn game_server_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_server_group_name = Some(input.into());
            self
        }
        /// <p>A unique identifier for the game server group. Use either the <code>GameServerGroup</code> name or ARN value.</p>
        pub fn set_game_server_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_server_group_name = input;
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) for an IAM role that allows Amazon GameLift to access your EC2 Auto Scaling groups.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) for an IAM role that allows Amazon GameLift to access your EC2 Auto Scaling groups.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `instance_definitions`.
        ///
        /// To override the contents of this collection use [`set_instance_definitions`](Self::set_instance_definitions).
        ///
        /// <p>An updated list of EC2 instance types to use in the Auto Scaling group. The instance definitions must specify at least two different instance types that are supported by GameLift FleetIQ. This updated list replaces the entire current list of instance definitions for the game server group. For more information on instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">EC2 Instance Types</a> in the <i>Amazon EC2 User Guide</i>. You can optionally specify capacity weighting for each instance type. If no weight value is specified for an instance type, it is set to the default value "1". For more information about capacity weighting, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html"> Instance Weighting for Amazon EC2 Auto Scaling</a> in the Amazon EC2 Auto Scaling User Guide.</p>
        pub fn instance_definitions(mut self, input: crate::model::InstanceDefinition) -> Self {
            let mut v = self.instance_definitions.unwrap_or_default();
            v.push(input);
            self.instance_definitions = Some(v);
            self
        }
        /// <p>An updated list of EC2 instance types to use in the Auto Scaling group. The instance definitions must specify at least two different instance types that are supported by GameLift FleetIQ. This updated list replaces the entire current list of instance definitions for the game server group. For more information on instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">EC2 Instance Types</a> in the <i>Amazon EC2 User Guide</i>. You can optionally specify capacity weighting for each instance type. If no weight value is specified for an instance type, it is set to the default value "1". For more information about capacity weighting, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html"> Instance Weighting for Amazon EC2 Auto Scaling</a> in the Amazon EC2 Auto Scaling User Guide.</p>
        pub fn set_instance_definitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceDefinition>>,
        ) -> Self {
            self.instance_definitions = input;
            self
        }
        /// <p>A flag that indicates whether instances in the game server group are protected from early termination. Unprotected instances that have active game servers running might be terminated during a scale-down event, causing players to be dropped from the game. Protected instances cannot be terminated while there are active game servers running except in the event of a forced game server group deletion (see ). An exception to this is with Spot Instances, which can be terminated by AWS regardless of protection status. This property is set to <code>NO_PROTECTION</code> by default.</p>
        pub fn game_server_protection_policy(
            mut self,
            input: crate::model::GameServerProtectionPolicy,
        ) -> Self {
            self.game_server_protection_policy = Some(input);
            self
        }
        /// <p>A flag that indicates whether instances in the game server group are protected from early termination. Unprotected instances that have active game servers running might be terminated during a scale-down event, causing players to be dropped from the game. Protected instances cannot be terminated while there are active game servers running except in the event of a forced game server group deletion (see ). An exception to this is with Spot Instances, which can be terminated by AWS regardless of protection status. This property is set to <code>NO_PROTECTION</code> by default.</p>
        pub fn set_game_server_protection_policy(
            mut self,
            input: std::option::Option<crate::model::GameServerProtectionPolicy>,
        ) -> Self {
            self.game_server_protection_policy = input;
            self
        }
        /// <p>Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game server group. Method options include the following:</p>
        /// <ul>
        /// <li> <p> <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are unavailable or not viable for game hosting, the game server group provides no hosting capacity until Spot Instances can again be used. Until then, no new instances are started, and the existing nonviable Spot Instances are terminated (after current gameplay ends) and are not replaced.</p> </li>
        /// <li> <p> <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game server group. If Spot Instances are unavailable, the game server group continues to provide hosting capacity by falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after current gameplay ends) and are replaced with new On-Demand Instances.</p> </li>
        /// <li> <p> <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot Instances are used, even when available, while this balancing strategy is in force.</p> </li>
        /// </ul>
        pub fn balancing_strategy(mut self, input: crate::model::BalancingStrategy) -> Self {
            self.balancing_strategy = Some(input);
            self
        }
        /// <p>Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game server group. Method options include the following:</p>
        /// <ul>
        /// <li> <p> <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are unavailable or not viable for game hosting, the game server group provides no hosting capacity until Spot Instances can again be used. Until then, no new instances are started, and the existing nonviable Spot Instances are terminated (after current gameplay ends) and are not replaced.</p> </li>
        /// <li> <p> <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game server group. If Spot Instances are unavailable, the game server group continues to provide hosting capacity by falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after current gameplay ends) and are replaced with new On-Demand Instances.</p> </li>
        /// <li> <p> <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot Instances are used, even when available, while this balancing strategy is in force.</p> </li>
        /// </ul>
        pub fn set_balancing_strategy(
            mut self,
            input: std::option::Option<crate::model::BalancingStrategy>,
        ) -> Self {
            self.balancing_strategy = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGameServerGroupInput`](crate::input::UpdateGameServerGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateGameServerGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateGameServerGroupInput {
                game_server_group_name: self.game_server_group_name,
                role_arn: self.role_arn,
                instance_definitions: self.instance_definitions,
                game_server_protection_policy: self.game_server_protection_policy,
                balancing_strategy: self.balancing_strategy,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateGameServerGroupInputOperationOutputAlias = crate::operation::UpdateGameServerGroup;
#[doc(hidden)]
pub type UpdateGameServerGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateGameServerGroupInput {
    /// Consumes the builder and constructs an Operation<[`UpdateGameServerGroup`](crate::operation::UpdateGameServerGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateGameServerGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateGameServerGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateGameServerGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateGameServerGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.UpdateGameServerGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_game_server_group(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateGameServerGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateGameServerGroup",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateGameServerGroupInput`](crate::input::UpdateGameServerGroupInput)
    pub fn builder() -> crate::input::update_game_server_group_input::Builder {
        crate::input::update_game_server_group_input::Builder::default()
    }
}

/// See [`UpdateGameSessionInput`](crate::input::UpdateGameSessionInput)
pub mod update_game_session_input {
    /// A builder for [`UpdateGameSessionInput`](crate::input::UpdateGameSessionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_session_id: std::option::Option<std::string::String>,
        pub(crate) maximum_player_session_count: std::option::Option<i32>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) player_session_creation_policy:
            std::option::Option<crate::model::PlayerSessionCreationPolicy>,
        pub(crate) protection_policy: std::option::Option<crate::model::ProtectionPolicy>,
    }
    impl Builder {
        /// <p>A unique identifier for the game session to update. </p>
        pub fn game_session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_session_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the game session to update. </p>
        pub fn set_game_session_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_session_id = input;
            self
        }
        /// <p>The maximum number of players that can be connected simultaneously to the game session.</p>
        pub fn maximum_player_session_count(mut self, input: i32) -> Self {
            self.maximum_player_session_count = Some(input);
            self
        }
        /// <p>The maximum number of players that can be connected simultaneously to the game session.</p>
        pub fn set_maximum_player_session_count(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_player_session_count = input;
            self
        }
        /// <p>A descriptive label that is associated with a game session. Session names do not need to be unique.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A descriptive label that is associated with a game session. Session names do not need to be unique.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A policy that determines whether the game session is accepting new players.</p>
        pub fn player_session_creation_policy(
            mut self,
            input: crate::model::PlayerSessionCreationPolicy,
        ) -> Self {
            self.player_session_creation_policy = Some(input);
            self
        }
        /// <p>A policy that determines whether the game session is accepting new players.</p>
        pub fn set_player_session_creation_policy(
            mut self,
            input: std::option::Option<crate::model::PlayerSessionCreationPolicy>,
        ) -> Self {
            self.player_session_creation_policy = input;
            self
        }
        /// <p>Game session protection policy to apply to this game session only.</p>
        /// <ul>
        /// <li> <p> <b>NoProtection</b> -- The game session can be terminated during a scale-down event.</p> </li>
        /// <li> <p> <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during a scale-down event.</p> </li>
        /// </ul>
        pub fn protection_policy(mut self, input: crate::model::ProtectionPolicy) -> Self {
            self.protection_policy = Some(input);
            self
        }
        /// <p>Game session protection policy to apply to this game session only.</p>
        /// <ul>
        /// <li> <p> <b>NoProtection</b> -- The game session can be terminated during a scale-down event.</p> </li>
        /// <li> <p> <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during a scale-down event.</p> </li>
        /// </ul>
        pub fn set_protection_policy(
            mut self,
            input: std::option::Option<crate::model::ProtectionPolicy>,
        ) -> Self {
            self.protection_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGameSessionInput`](crate::input::UpdateGameSessionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateGameSessionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateGameSessionInput {
                game_session_id: self.game_session_id,
                maximum_player_session_count: self.maximum_player_session_count,
                name: self.name,
                player_session_creation_policy: self.player_session_creation_policy,
                protection_policy: self.protection_policy,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateGameSessionInputOperationOutputAlias = crate::operation::UpdateGameSession;
#[doc(hidden)]
pub type UpdateGameSessionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateGameSessionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateGameSession`](crate::operation::UpdateGameSession)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateGameSession,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateGameSessionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateGameSessionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateGameSessionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.UpdateGameSession",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_game_session(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateGameSession::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateGameSession",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateGameSessionInput`](crate::input::UpdateGameSessionInput)
    pub fn builder() -> crate::input::update_game_session_input::Builder {
        crate::input::update_game_session_input::Builder::default()
    }
}

/// See [`UpdateGameSessionQueueInput`](crate::input::UpdateGameSessionQueueInput)
pub mod update_game_session_queue_input {
    /// A builder for [`UpdateGameSessionQueueInput`](crate::input::UpdateGameSessionQueueInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) timeout_in_seconds: std::option::Option<i32>,
        pub(crate) player_latency_policies:
            std::option::Option<std::vec::Vec<crate::model::PlayerLatencyPolicy>>,
        pub(crate) destinations:
            std::option::Option<std::vec::Vec<crate::model::GameSessionQueueDestination>>,
        pub(crate) filter_configuration: std::option::Option<crate::model::FilterConfiguration>,
        pub(crate) priority_configuration: std::option::Option<crate::model::PriorityConfiguration>,
        pub(crate) custom_event_data: std::option::Option<std::string::String>,
        pub(crate) notification_target: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A descriptive label that is associated with game session queue. Queue names must be unique within each Region. You can use either the queue ID or ARN value. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A descriptive label that is associated with game session queue. Queue names must be unique within each Region. You can use either the queue ID or ARN value. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The maximum time, in seconds, that a new game session placement request remains in the queue. When a request exceeds this time, the game session placement changes to a <code>TIMED_OUT</code> status.</p>
        pub fn timeout_in_seconds(mut self, input: i32) -> Self {
            self.timeout_in_seconds = Some(input);
            self
        }
        /// <p>The maximum time, in seconds, that a new game session placement request remains in the queue. When a request exceeds this time, the game session placement changes to a <code>TIMED_OUT</code> status.</p>
        pub fn set_timeout_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_in_seconds = input;
            self
        }
        /// Appends an item to `player_latency_policies`.
        ///
        /// To override the contents of this collection use [`set_player_latency_policies`](Self::set_player_latency_policies).
        ///
        /// <p>A set of policies that act as a sliding cap on player latency. FleetIQ works to deliver low latency for most players in a game session. These policies ensure that no individual player can be placed into a game with unreasonably high latency. Use multiple policies to gradually relax latency requirements a step at a time. Multiple policies are applied based on their maximum allowed latency, starting with the lowest value. When updating policies, provide a complete collection of policies.</p>
        pub fn player_latency_policies(mut self, input: crate::model::PlayerLatencyPolicy) -> Self {
            let mut v = self.player_latency_policies.unwrap_or_default();
            v.push(input);
            self.player_latency_policies = Some(v);
            self
        }
        /// <p>A set of policies that act as a sliding cap on player latency. FleetIQ works to deliver low latency for most players in a game session. These policies ensure that no individual player can be placed into a game with unreasonably high latency. Use multiple policies to gradually relax latency requirements a step at a time. Multiple policies are applied based on their maximum allowed latency, starting with the lowest value. When updating policies, provide a complete collection of policies.</p>
        pub fn set_player_latency_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlayerLatencyPolicy>>,
        ) -> Self {
            self.player_latency_policies = input;
            self
        }
        /// Appends an item to `destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// <p>A list of fleets and/or fleet aliases that can be used to fulfill game session placement requests in the queue. Destinations are identified by either a fleet ARN or a fleet alias ARN, and are listed in order of placement preference. When updating this list, provide a complete list of destinations.</p>
        pub fn destinations(mut self, input: crate::model::GameSessionQueueDestination) -> Self {
            let mut v = self.destinations.unwrap_or_default();
            v.push(input);
            self.destinations = Some(v);
            self
        }
        /// <p>A list of fleets and/or fleet aliases that can be used to fulfill game session placement requests in the queue. Destinations are identified by either a fleet ARN or a fleet alias ARN, and are listed in order of placement preference. When updating this list, provide a complete list of destinations.</p>
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GameSessionQueueDestination>>,
        ) -> Self {
            self.destinations = input;
            self
        }
        /// <p>A list of locations where a queue is allowed to place new game sessions. Locations are specified in the form of AWS Region codes, such as <code>us-west-2</code>. If this parameter is not set, game sessions can be placed in any queue location. To remove an existing filter configuration, pass in an empty set.</p>
        pub fn filter_configuration(mut self, input: crate::model::FilterConfiguration) -> Self {
            self.filter_configuration = Some(input);
            self
        }
        /// <p>A list of locations where a queue is allowed to place new game sessions. Locations are specified in the form of AWS Region codes, such as <code>us-west-2</code>. If this parameter is not set, game sessions can be placed in any queue location. To remove an existing filter configuration, pass in an empty set.</p>
        pub fn set_filter_configuration(
            mut self,
            input: std::option::Option<crate::model::FilterConfiguration>,
        ) -> Self {
            self.filter_configuration = input;
            self
        }
        /// <p>Custom settings to use when prioritizing destinations and locations for game session placements. This configuration replaces the FleetIQ default prioritization process. Priority types that are not explicitly named will be automatically applied at the end of the prioritization process. To remove an existing priority configuration, pass in an empty set.</p>
        pub fn priority_configuration(
            mut self,
            input: crate::model::PriorityConfiguration,
        ) -> Self {
            self.priority_configuration = Some(input);
            self
        }
        /// <p>Custom settings to use when prioritizing destinations and locations for game session placements. This configuration replaces the FleetIQ default prioritization process. Priority types that are not explicitly named will be automatically applied at the end of the prioritization process. To remove an existing priority configuration, pass in an empty set.</p>
        pub fn set_priority_configuration(
            mut self,
            input: std::option::Option<crate::model::PriorityConfiguration>,
        ) -> Self {
            self.priority_configuration = input;
            self
        }
        /// <p> Information to be added to all events that are related to this game session queue. </p>
        pub fn custom_event_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_event_data = Some(input.into());
            self
        }
        /// <p> Information to be added to all events that are related to this game session queue. </p>
        pub fn set_custom_event_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_event_data = input;
            self
        }
        /// <p>An SNS topic ARN that is set up to receive game session placement notifications. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queue-notification.html"> Setting up notifications for game session placement</a>.</p>
        pub fn notification_target(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_target = Some(input.into());
            self
        }
        /// <p>An SNS topic ARN that is set up to receive game session placement notifications. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queue-notification.html"> Setting up notifications for game session placement</a>.</p>
        pub fn set_notification_target(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_target = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGameSessionQueueInput`](crate::input::UpdateGameSessionQueueInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateGameSessionQueueInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateGameSessionQueueInput {
                name: self.name,
                timeout_in_seconds: self.timeout_in_seconds,
                player_latency_policies: self.player_latency_policies,
                destinations: self.destinations,
                filter_configuration: self.filter_configuration,
                priority_configuration: self.priority_configuration,
                custom_event_data: self.custom_event_data,
                notification_target: self.notification_target,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateGameSessionQueueInputOperationOutputAlias = crate::operation::UpdateGameSessionQueue;
#[doc(hidden)]
pub type UpdateGameSessionQueueInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateGameSessionQueueInput {
    /// Consumes the builder and constructs an Operation<[`UpdateGameSessionQueue`](crate::operation::UpdateGameSessionQueue)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateGameSessionQueue,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateGameSessionQueueInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateGameSessionQueueInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateGameSessionQueueInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.UpdateGameSessionQueue",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_game_session_queue(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateGameSessionQueue::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateGameSessionQueue",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateGameSessionQueueInput`](crate::input::UpdateGameSessionQueueInput)
    pub fn builder() -> crate::input::update_game_session_queue_input::Builder {
        crate::input::update_game_session_queue_input::Builder::default()
    }
}

/// See [`UpdateMatchmakingConfigurationInput`](crate::input::UpdateMatchmakingConfigurationInput)
pub mod update_matchmaking_configuration_input {
    /// A builder for [`UpdateMatchmakingConfigurationInput`](crate::input::UpdateMatchmakingConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) game_session_queue_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) request_timeout_seconds: std::option::Option<i32>,
        pub(crate) acceptance_timeout_seconds: std::option::Option<i32>,
        pub(crate) acceptance_required: std::option::Option<bool>,
        pub(crate) rule_set_name: std::option::Option<std::string::String>,
        pub(crate) notification_target: std::option::Option<std::string::String>,
        pub(crate) additional_player_count: std::option::Option<i32>,
        pub(crate) custom_event_data: std::option::Option<std::string::String>,
        pub(crate) game_properties: std::option::Option<std::vec::Vec<crate::model::GameProperty>>,
        pub(crate) game_session_data: std::option::Option<std::string::String>,
        pub(crate) backfill_mode: std::option::Option<crate::model::BackfillMode>,
        pub(crate) flex_match_mode: std::option::Option<crate::model::FlexMatchMode>,
    }
    impl Builder {
        /// <p>A unique identifier for the matchmaking configuration to update. You can use either the configuration name or ARN value. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A unique identifier for the matchmaking configuration to update. You can use either the configuration name or ARN value. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A descriptive label that is associated with matchmaking configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A descriptive label that is associated with matchmaking configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `game_session_queue_arns`.
        ///
        /// To override the contents of this collection use [`set_game_session_queue_arns`](Self::set_game_session_queue_arns).
        ///
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift game session queue resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::gamesessionqueue/
        /// <queue name></queue>
        /// </region></code>. Queues can be located in any Region. Queues are used to start new GameLift-hosted game sessions for matches that are created with this matchmaking configuration. If <code>FlexMatchMode</code> is set to <code>STANDALONE</code>, do not set this parameter.</p>
        pub fn game_session_queue_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.game_session_queue_arns.unwrap_or_default();
            v.push(input.into());
            self.game_session_queue_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift game session queue resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::gamesessionqueue/
        /// <queue name></queue>
        /// </region></code>. Queues can be located in any Region. Queues are used to start new GameLift-hosted game sessions for matches that are created with this matchmaking configuration. If <code>FlexMatchMode</code> is set to <code>STANDALONE</code>, do not set this parameter.</p>
        pub fn set_game_session_queue_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.game_session_queue_arns = input;
            self
        }
        /// <p>The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out. Requests that fail due to timing out can be resubmitted as needed.</p>
        pub fn request_timeout_seconds(mut self, input: i32) -> Self {
            self.request_timeout_seconds = Some(input);
            self
        }
        /// <p>The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out. Requests that fail due to timing out can be resubmitted as needed.</p>
        pub fn set_request_timeout_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.request_timeout_seconds = input;
            self
        }
        /// <p>The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required.</p>
        pub fn acceptance_timeout_seconds(mut self, input: i32) -> Self {
            self.acceptance_timeout_seconds = Some(input);
            self
        }
        /// <p>The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required.</p>
        pub fn set_acceptance_timeout_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.acceptance_timeout_seconds = input;
            self
        }
        /// <p>A flag that indicates whether a match that was created with this configuration must be accepted by the matched players. To require acceptance, set to TRUE. With this option enabled, matchmaking tickets use the status <code>REQUIRES_ACCEPTANCE</code> to indicate when a completed potential match is waiting for player acceptance. </p>
        pub fn acceptance_required(mut self, input: bool) -> Self {
            self.acceptance_required = Some(input);
            self
        }
        /// <p>A flag that indicates whether a match that was created with this configuration must be accepted by the matched players. To require acceptance, set to TRUE. With this option enabled, matchmaking tickets use the status <code>REQUIRES_ACCEPTANCE</code> to indicate when a completed potential match is waiting for player acceptance. </p>
        pub fn set_acceptance_required(mut self, input: std::option::Option<bool>) -> Self {
            self.acceptance_required = input;
            self
        }
        /// <p>A unique identifier for the matchmaking rule set to use with this configuration. You can use either the rule set name or ARN value. A matchmaking configuration can only use rule sets that are defined in the same Region.</p>
        pub fn rule_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_set_name = Some(input.into());
            self
        }
        /// <p>A unique identifier for the matchmaking rule set to use with this configuration. You can use either the rule set name or ARN value. A matchmaking configuration can only use rule sets that are defined in the same Region.</p>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rule_set_name = input;
            self
        }
        /// <p>An SNS topic ARN that is set up to receive matchmaking notifications. See <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html"> Setting up notifications for matchmaking</a> for more information.</p>
        pub fn notification_target(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_target = Some(input.into());
            self
        }
        /// <p>An SNS topic ARN that is set up to receive matchmaking notifications. See <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html"> Setting up notifications for matchmaking</a> for more information.</p>
        pub fn set_notification_target(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_target = input;
            self
        }
        /// <p>The number of player slots in a match to keep open for future players. For example, if the configuration's rule set specifies a match for a single 12-person team, and the additional player count is set to 2, only 10 players are selected for the match. This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
        pub fn additional_player_count(mut self, input: i32) -> Self {
            self.additional_player_count = Some(input);
            self
        }
        /// <p>The number of player slots in a match to keep open for future players. For example, if the configuration's rule set specifies a match for a single 12-person team, and the additional player count is set to 2, only 10 players are selected for the match. This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
        pub fn set_additional_player_count(mut self, input: std::option::Option<i32>) -> Self {
            self.additional_player_count = input;
            self
        }
        /// <p>Information to add to all events related to the matchmaking configuration. </p>
        pub fn custom_event_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_event_data = Some(input.into());
            self
        }
        /// <p>Information to add to all events related to the matchmaking configuration. </p>
        pub fn set_custom_event_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_event_data = input;
            self
        }
        /// Appends an item to `game_properties`.
        ///
        /// To override the contents of this collection use [`set_game_properties`](Self::set_game_properties).
        ///
        /// <p>A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). This information is added to the new <code>GameSession</code> object that is created for a successful match. This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
        pub fn game_properties(mut self, input: crate::model::GameProperty) -> Self {
            let mut v = self.game_properties.unwrap_or_default();
            v.push(input);
            self.game_properties = Some(v);
            self
        }
        /// <p>A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). This information is added to the new <code>GameSession</code> object that is created for a successful match. This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
        pub fn set_game_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GameProperty>>,
        ) -> Self {
            self.game_properties = input;
            self
        }
        /// <p>A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). This information is added to the new <code>GameSession</code> object that is created for a successful match. This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
        pub fn game_session_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_session_data = Some(input.into());
            self
        }
        /// <p>A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). This information is added to the new <code>GameSession</code> object that is created for a successful match. This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
        pub fn set_game_session_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_session_data = input;
            self
        }
        /// <p>The method that is used to backfill game sessions created with this matchmaking configuration. Specify MANUAL when your game manages backfill requests manually or does not use the match backfill feature. Specify AUTOMATIC to have GameLift create a <code>StartMatchBackfill</code> request whenever a game session has one or more open slots. Learn more about manual and automatic backfill in <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html">Backfill Existing Games with FlexMatch</a>. Automatic backfill is not available when <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
        pub fn backfill_mode(mut self, input: crate::model::BackfillMode) -> Self {
            self.backfill_mode = Some(input);
            self
        }
        /// <p>The method that is used to backfill game sessions created with this matchmaking configuration. Specify MANUAL when your game manages backfill requests manually or does not use the match backfill feature. Specify AUTOMATIC to have GameLift create a <code>StartMatchBackfill</code> request whenever a game session has one or more open slots. Learn more about manual and automatic backfill in <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html">Backfill Existing Games with FlexMatch</a>. Automatic backfill is not available when <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
        pub fn set_backfill_mode(
            mut self,
            input: std::option::Option<crate::model::BackfillMode>,
        ) -> Self {
            self.backfill_mode = input;
            self
        }
        /// <p>Indicates whether this matchmaking configuration is being used with GameLift hosting or as a standalone matchmaking solution. </p>
        /// <ul>
        /// <li> <p> <b>STANDALONE</b> - FlexMatch forms matches and returns match information, including players and team assignments, in a <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html#match-events-matchmakingsucceeded"> MatchmakingSucceeded</a> event.</p> </li>
        /// <li> <p> <b>WITH_QUEUE</b> - FlexMatch forms matches and uses the specified GameLift queue to start a game session for the match. </p> </li>
        /// </ul>
        pub fn flex_match_mode(mut self, input: crate::model::FlexMatchMode) -> Self {
            self.flex_match_mode = Some(input);
            self
        }
        /// <p>Indicates whether this matchmaking configuration is being used with GameLift hosting or as a standalone matchmaking solution. </p>
        /// <ul>
        /// <li> <p> <b>STANDALONE</b> - FlexMatch forms matches and returns match information, including players and team assignments, in a <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html#match-events-matchmakingsucceeded"> MatchmakingSucceeded</a> event.</p> </li>
        /// <li> <p> <b>WITH_QUEUE</b> - FlexMatch forms matches and uses the specified GameLift queue to start a game session for the match. </p> </li>
        /// </ul>
        pub fn set_flex_match_mode(
            mut self,
            input: std::option::Option<crate::model::FlexMatchMode>,
        ) -> Self {
            self.flex_match_mode = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMatchmakingConfigurationInput`](crate::input::UpdateMatchmakingConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateMatchmakingConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateMatchmakingConfigurationInput {
                name: self.name,
                description: self.description,
                game_session_queue_arns: self.game_session_queue_arns,
                request_timeout_seconds: self.request_timeout_seconds,
                acceptance_timeout_seconds: self.acceptance_timeout_seconds,
                acceptance_required: self.acceptance_required,
                rule_set_name: self.rule_set_name,
                notification_target: self.notification_target,
                additional_player_count: self.additional_player_count,
                custom_event_data: self.custom_event_data,
                game_properties: self.game_properties,
                game_session_data: self.game_session_data,
                backfill_mode: self.backfill_mode,
                flex_match_mode: self.flex_match_mode,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateMatchmakingConfigurationInputOperationOutputAlias =
    crate::operation::UpdateMatchmakingConfiguration;
#[doc(hidden)]
pub type UpdateMatchmakingConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdateMatchmakingConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateMatchmakingConfiguration`](crate::operation::UpdateMatchmakingConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateMatchmakingConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateMatchmakingConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateMatchmakingConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateMatchmakingConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.UpdateMatchmakingConfiguration",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_matchmaking_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateMatchmakingConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateMatchmakingConfiguration",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateMatchmakingConfigurationInput`](crate::input::UpdateMatchmakingConfigurationInput)
    pub fn builder() -> crate::input::update_matchmaking_configuration_input::Builder {
        crate::input::update_matchmaking_configuration_input::Builder::default()
    }
}

/// See [`UpdateRuntimeConfigurationInput`](crate::input::UpdateRuntimeConfigurationInput)
pub mod update_runtime_configuration_input {
    /// A builder for [`UpdateRuntimeConfigurationInput`](crate::input::UpdateRuntimeConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) runtime_configuration: std::option::Option<crate::model::RuntimeConfiguration>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet to update runtime configuration for. You can use either the fleet ID or ARN value.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet to update runtime configuration for. You can use either the fleet ID or ARN value.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p>Instructions for launching server processes on each instance in the fleet. Server processes run either a custom game build executable or a Realtime Servers script. The runtime configuration lists the types of server processes to run on an instance, how to launch them, and the number of processes to run concurrently.</p>
        pub fn runtime_configuration(mut self, input: crate::model::RuntimeConfiguration) -> Self {
            self.runtime_configuration = Some(input);
            self
        }
        /// <p>Instructions for launching server processes on each instance in the fleet. Server processes run either a custom game build executable or a Realtime Servers script. The runtime configuration lists the types of server processes to run on an instance, how to launch them, and the number of processes to run concurrently.</p>
        pub fn set_runtime_configuration(
            mut self,
            input: std::option::Option<crate::model::RuntimeConfiguration>,
        ) -> Self {
            self.runtime_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRuntimeConfigurationInput`](crate::input::UpdateRuntimeConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateRuntimeConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateRuntimeConfigurationInput {
                fleet_id: self.fleet_id,
                runtime_configuration: self.runtime_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateRuntimeConfigurationInputOperationOutputAlias =
    crate::operation::UpdateRuntimeConfiguration;
#[doc(hidden)]
pub type UpdateRuntimeConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateRuntimeConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateRuntimeConfiguration`](crate::operation::UpdateRuntimeConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateRuntimeConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateRuntimeConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateRuntimeConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateRuntimeConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.UpdateRuntimeConfiguration",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_runtime_configuration(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateRuntimeConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateRuntimeConfiguration",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateRuntimeConfigurationInput`](crate::input::UpdateRuntimeConfigurationInput)
    pub fn builder() -> crate::input::update_runtime_configuration_input::Builder {
        crate::input::update_runtime_configuration_input::Builder::default()
    }
}

/// See [`UpdateScriptInput`](crate::input::UpdateScriptInput)
pub mod update_script_input {
    /// A builder for [`UpdateScriptInput`](crate::input::UpdateScriptInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) script_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) storage_location: std::option::Option<crate::model::S3Location>,
        pub(crate) zip_file: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>A unique identifier for the Realtime script to update. You can use either the script ID or ARN value.</p>
        pub fn script_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.script_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the Realtime script to update. You can use either the script ID or ARN value.</p>
        pub fn set_script_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.script_id = input;
            self
        }
        /// <p>A descriptive label that is associated with a script. Script names do not need to be unique.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A descriptive label that is associated with a script. Script names do not need to be unique.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Version information that is associated with a build or script. Version strings do not need to be unique.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>Version information that is associated with a build or script. Version strings do not need to be unique.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The location of the Amazon S3 bucket where a zipped file containing your Realtime scripts is stored. The storage location must specify the Amazon S3 bucket name, the zip file name (the "key"), and a role ARN that allows Amazon GameLift to access the Amazon S3 storage location. The S3 bucket must be in the same Region where you want to create a new script. By default, Amazon GameLift uploads the latest version of the zip file; if you have S3 object versioning turned on, you can use the <code>ObjectVersion</code> parameter to specify an earlier version. </p>
        pub fn storage_location(mut self, input: crate::model::S3Location) -> Self {
            self.storage_location = Some(input);
            self
        }
        /// <p>The location of the Amazon S3 bucket where a zipped file containing your Realtime scripts is stored. The storage location must specify the Amazon S3 bucket name, the zip file name (the "key"), and a role ARN that allows Amazon GameLift to access the Amazon S3 storage location. The S3 bucket must be in the same Region where you want to create a new script. By default, Amazon GameLift uploads the latest version of the zip file; if you have S3 object versioning turned on, you can use the <code>ObjectVersion</code> parameter to specify an earlier version. </p>
        pub fn set_storage_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.storage_location = input;
            self
        }
        /// <p>A data object containing your Realtime scripts and dependencies as a zip file. The zip file can have one or multiple files. Maximum size of a zip file is 5 MB.</p>
        /// <p>When using the AWS CLI tool to create a script, this parameter is set to the zip file name. It must be prepended with the string "fileb://" to indicate that the file data is a binary object. For example: <code>--zip-file fileb://myRealtimeScript.zip</code>.</p>
        pub fn zip_file(mut self, input: aws_smithy_types::Blob) -> Self {
            self.zip_file = Some(input);
            self
        }
        /// <p>A data object containing your Realtime scripts and dependencies as a zip file. The zip file can have one or multiple files. Maximum size of a zip file is 5 MB.</p>
        /// <p>When using the AWS CLI tool to create a script, this parameter is set to the zip file name. It must be prepended with the string "fileb://" to indicate that the file data is a binary object. For example: <code>--zip-file fileb://myRealtimeScript.zip</code>.</p>
        pub fn set_zip_file(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.zip_file = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateScriptInput`](crate::input::UpdateScriptInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateScriptInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateScriptInput {
                script_id: self.script_id,
                name: self.name,
                version: self.version,
                storage_location: self.storage_location,
                zip_file: self.zip_file,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateScriptInputOperationOutputAlias = crate::operation::UpdateScript;
#[doc(hidden)]
pub type UpdateScriptInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateScriptInput {
    /// Consumes the builder and constructs an Operation<[`UpdateScript`](crate::operation::UpdateScript)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateScript,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateScriptInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateScriptInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateScriptInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.UpdateScript",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_script(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateScript::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateScript",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateScriptInput`](crate::input::UpdateScriptInput)
    pub fn builder() -> crate::input::update_script_input::Builder {
        crate::input::update_script_input::Builder::default()
    }
}

/// See [`ValidateMatchmakingRuleSetInput`](crate::input::ValidateMatchmakingRuleSetInput)
pub mod validate_matchmaking_rule_set_input {
    /// A builder for [`ValidateMatchmakingRuleSetInput`](crate::input::ValidateMatchmakingRuleSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_set_body: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A collection of matchmaking rules to validate, formatted as a JSON string.</p>
        pub fn rule_set_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_set_body = Some(input.into());
            self
        }
        /// <p>A collection of matchmaking rules to validate, formatted as a JSON string.</p>
        pub fn set_rule_set_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rule_set_body = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidateMatchmakingRuleSetInput`](crate::input::ValidateMatchmakingRuleSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ValidateMatchmakingRuleSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ValidateMatchmakingRuleSetInput {
                rule_set_body: self.rule_set_body,
            })
        }
    }
}
#[doc(hidden)]
pub type ValidateMatchmakingRuleSetInputOperationOutputAlias =
    crate::operation::ValidateMatchmakingRuleSet;
#[doc(hidden)]
pub type ValidateMatchmakingRuleSetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ValidateMatchmakingRuleSetInput {
    /// Consumes the builder and constructs an Operation<[`ValidateMatchmakingRuleSet`](crate::operation::ValidateMatchmakingRuleSet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ValidateMatchmakingRuleSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ValidateMatchmakingRuleSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ValidateMatchmakingRuleSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ValidateMatchmakingRuleSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GameLift.ValidateMatchmakingRuleSet",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_validate_matchmaking_rule_set(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ValidateMatchmakingRuleSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ValidateMatchmakingRuleSet",
            "gamelift",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ValidateMatchmakingRuleSetInput`](crate::input::ValidateMatchmakingRuleSetInput)
    pub fn builder() -> crate::input::validate_matchmaking_rule_set_input::Builder {
        crate::input::validate_matchmaking_rule_set_input::Builder::default()
    }
}

/// <p>Represents the input for a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidateMatchmakingRuleSetInput {
    /// <p>A collection of matchmaking rules to validate, formatted as a JSON string.</p>
    pub rule_set_body: std::option::Option<std::string::String>,
}
impl ValidateMatchmakingRuleSetInput {
    /// <p>A collection of matchmaking rules to validate, formatted as a JSON string.</p>
    pub fn rule_set_body(&self) -> std::option::Option<&str> {
        self.rule_set_body.as_deref()
    }
}
impl std::fmt::Debug for ValidateMatchmakingRuleSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidateMatchmakingRuleSetInput");
        formatter.field("rule_set_body", &self.rule_set_body);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateScriptInput {
    /// <p>A unique identifier for the Realtime script to update. You can use either the script ID or ARN value.</p>
    pub script_id: std::option::Option<std::string::String>,
    /// <p>A descriptive label that is associated with a script. Script names do not need to be unique.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Version information that is associated with a build or script. Version strings do not need to be unique.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The location of the Amazon S3 bucket where a zipped file containing your Realtime scripts is stored. The storage location must specify the Amazon S3 bucket name, the zip file name (the "key"), and a role ARN that allows Amazon GameLift to access the Amazon S3 storage location. The S3 bucket must be in the same Region where you want to create a new script. By default, Amazon GameLift uploads the latest version of the zip file; if you have S3 object versioning turned on, you can use the <code>ObjectVersion</code> parameter to specify an earlier version. </p>
    pub storage_location: std::option::Option<crate::model::S3Location>,
    /// <p>A data object containing your Realtime scripts and dependencies as a zip file. The zip file can have one or multiple files. Maximum size of a zip file is 5 MB.</p>
    /// <p>When using the AWS CLI tool to create a script, this parameter is set to the zip file name. It must be prepended with the string "fileb://" to indicate that the file data is a binary object. For example: <code>--zip-file fileb://myRealtimeScript.zip</code>.</p>
    pub zip_file: std::option::Option<aws_smithy_types::Blob>,
}
impl UpdateScriptInput {
    /// <p>A unique identifier for the Realtime script to update. You can use either the script ID or ARN value.</p>
    pub fn script_id(&self) -> std::option::Option<&str> {
        self.script_id.as_deref()
    }
    /// <p>A descriptive label that is associated with a script. Script names do not need to be unique.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Version information that is associated with a build or script. Version strings do not need to be unique.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The location of the Amazon S3 bucket where a zipped file containing your Realtime scripts is stored. The storage location must specify the Amazon S3 bucket name, the zip file name (the "key"), and a role ARN that allows Amazon GameLift to access the Amazon S3 storage location. The S3 bucket must be in the same Region where you want to create a new script. By default, Amazon GameLift uploads the latest version of the zip file; if you have S3 object versioning turned on, you can use the <code>ObjectVersion</code> parameter to specify an earlier version. </p>
    pub fn storage_location(&self) -> std::option::Option<&crate::model::S3Location> {
        self.storage_location.as_ref()
    }
    /// <p>A data object containing your Realtime scripts and dependencies as a zip file. The zip file can have one or multiple files. Maximum size of a zip file is 5 MB.</p>
    /// <p>When using the AWS CLI tool to create a script, this parameter is set to the zip file name. It must be prepended with the string "fileb://" to indicate that the file data is a binary object. For example: <code>--zip-file fileb://myRealtimeScript.zip</code>.</p>
    pub fn zip_file(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.zip_file.as_ref()
    }
}
impl std::fmt::Debug for UpdateScriptInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateScriptInput");
        formatter.field("script_id", &self.script_id);
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.field("storage_location", &self.storage_location);
        formatter.field("zip_file", &self.zip_file);
        formatter.finish()
    }
}

/// <p>Represents the input for a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRuntimeConfigurationInput {
    /// <p>A unique identifier for the fleet to update runtime configuration for. You can use either the fleet ID or ARN value.</p>
    pub fleet_id: std::option::Option<std::string::String>,
    /// <p>Instructions for launching server processes on each instance in the fleet. Server processes run either a custom game build executable or a Realtime Servers script. The runtime configuration lists the types of server processes to run on an instance, how to launch them, and the number of processes to run concurrently.</p>
    pub runtime_configuration: std::option::Option<crate::model::RuntimeConfiguration>,
}
impl UpdateRuntimeConfigurationInput {
    /// <p>A unique identifier for the fleet to update runtime configuration for. You can use either the fleet ID or ARN value.</p>
    pub fn fleet_id(&self) -> std::option::Option<&str> {
        self.fleet_id.as_deref()
    }
    /// <p>Instructions for launching server processes on each instance in the fleet. Server processes run either a custom game build executable or a Realtime Servers script. The runtime configuration lists the types of server processes to run on an instance, how to launch them, and the number of processes to run concurrently.</p>
    pub fn runtime_configuration(
        &self,
    ) -> std::option::Option<&crate::model::RuntimeConfiguration> {
        self.runtime_configuration.as_ref()
    }
}
impl std::fmt::Debug for UpdateRuntimeConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRuntimeConfigurationInput");
        formatter.field("fleet_id", &self.fleet_id);
        formatter.field("runtime_configuration", &self.runtime_configuration);
        formatter.finish()
    }
}

/// <p>Represents the input for a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMatchmakingConfigurationInput {
    /// <p>A unique identifier for the matchmaking configuration to update. You can use either the configuration name or ARN value. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A descriptive label that is associated with matchmaking configuration.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift game session queue resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::gamesessionqueue/
    /// <queue name></queue>
    /// </region></code>. Queues can be located in any Region. Queues are used to start new GameLift-hosted game sessions for matches that are created with this matchmaking configuration. If <code>FlexMatchMode</code> is set to <code>STANDALONE</code>, do not set this parameter.</p>
    pub game_session_queue_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out. Requests that fail due to timing out can be resubmitted as needed.</p>
    pub request_timeout_seconds: std::option::Option<i32>,
    /// <p>The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required.</p>
    pub acceptance_timeout_seconds: std::option::Option<i32>,
    /// <p>A flag that indicates whether a match that was created with this configuration must be accepted by the matched players. To require acceptance, set to TRUE. With this option enabled, matchmaking tickets use the status <code>REQUIRES_ACCEPTANCE</code> to indicate when a completed potential match is waiting for player acceptance. </p>
    pub acceptance_required: std::option::Option<bool>,
    /// <p>A unique identifier for the matchmaking rule set to use with this configuration. You can use either the rule set name or ARN value. A matchmaking configuration can only use rule sets that are defined in the same Region.</p>
    pub rule_set_name: std::option::Option<std::string::String>,
    /// <p>An SNS topic ARN that is set up to receive matchmaking notifications. See <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html"> Setting up notifications for matchmaking</a> for more information.</p>
    pub notification_target: std::option::Option<std::string::String>,
    /// <p>The number of player slots in a match to keep open for future players. For example, if the configuration's rule set specifies a match for a single 12-person team, and the additional player count is set to 2, only 10 players are selected for the match. This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
    pub additional_player_count: std::option::Option<i32>,
    /// <p>Information to add to all events related to the matchmaking configuration. </p>
    pub custom_event_data: std::option::Option<std::string::String>,
    /// <p>A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). This information is added to the new <code>GameSession</code> object that is created for a successful match. This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
    pub game_properties: std::option::Option<std::vec::Vec<crate::model::GameProperty>>,
    /// <p>A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). This information is added to the new <code>GameSession</code> object that is created for a successful match. This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
    pub game_session_data: std::option::Option<std::string::String>,
    /// <p>The method that is used to backfill game sessions created with this matchmaking configuration. Specify MANUAL when your game manages backfill requests manually or does not use the match backfill feature. Specify AUTOMATIC to have GameLift create a <code>StartMatchBackfill</code> request whenever a game session has one or more open slots. Learn more about manual and automatic backfill in <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html">Backfill Existing Games with FlexMatch</a>. Automatic backfill is not available when <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
    pub backfill_mode: std::option::Option<crate::model::BackfillMode>,
    /// <p>Indicates whether this matchmaking configuration is being used with GameLift hosting or as a standalone matchmaking solution. </p>
    /// <ul>
    /// <li> <p> <b>STANDALONE</b> - FlexMatch forms matches and returns match information, including players and team assignments, in a <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html#match-events-matchmakingsucceeded"> MatchmakingSucceeded</a> event.</p> </li>
    /// <li> <p> <b>WITH_QUEUE</b> - FlexMatch forms matches and uses the specified GameLift queue to start a game session for the match. </p> </li>
    /// </ul>
    pub flex_match_mode: std::option::Option<crate::model::FlexMatchMode>,
}
impl UpdateMatchmakingConfigurationInput {
    /// <p>A unique identifier for the matchmaking configuration to update. You can use either the configuration name or ARN value. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A descriptive label that is associated with matchmaking configuration.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift game session queue resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::gamesessionqueue/
    /// <queue name></queue>
    /// </region></code>. Queues can be located in any Region. Queues are used to start new GameLift-hosted game sessions for matches that are created with this matchmaking configuration. If <code>FlexMatchMode</code> is set to <code>STANDALONE</code>, do not set this parameter.</p>
    pub fn game_session_queue_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.game_session_queue_arns.as_deref()
    }
    /// <p>The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out. Requests that fail due to timing out can be resubmitted as needed.</p>
    pub fn request_timeout_seconds(&self) -> std::option::Option<i32> {
        self.request_timeout_seconds
    }
    /// <p>The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required.</p>
    pub fn acceptance_timeout_seconds(&self) -> std::option::Option<i32> {
        self.acceptance_timeout_seconds
    }
    /// <p>A flag that indicates whether a match that was created with this configuration must be accepted by the matched players. To require acceptance, set to TRUE. With this option enabled, matchmaking tickets use the status <code>REQUIRES_ACCEPTANCE</code> to indicate when a completed potential match is waiting for player acceptance. </p>
    pub fn acceptance_required(&self) -> std::option::Option<bool> {
        self.acceptance_required
    }
    /// <p>A unique identifier for the matchmaking rule set to use with this configuration. You can use either the rule set name or ARN value. A matchmaking configuration can only use rule sets that are defined in the same Region.</p>
    pub fn rule_set_name(&self) -> std::option::Option<&str> {
        self.rule_set_name.as_deref()
    }
    /// <p>An SNS topic ARN that is set up to receive matchmaking notifications. See <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html"> Setting up notifications for matchmaking</a> for more information.</p>
    pub fn notification_target(&self) -> std::option::Option<&str> {
        self.notification_target.as_deref()
    }
    /// <p>The number of player slots in a match to keep open for future players. For example, if the configuration's rule set specifies a match for a single 12-person team, and the additional player count is set to 2, only 10 players are selected for the match. This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
    pub fn additional_player_count(&self) -> std::option::Option<i32> {
        self.additional_player_count
    }
    /// <p>Information to add to all events related to the matchmaking configuration. </p>
    pub fn custom_event_data(&self) -> std::option::Option<&str> {
        self.custom_event_data.as_deref()
    }
    /// <p>A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). This information is added to the new <code>GameSession</code> object that is created for a successful match. This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
    pub fn game_properties(&self) -> std::option::Option<&[crate::model::GameProperty]> {
        self.game_properties.as_deref()
    }
    /// <p>A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). This information is added to the new <code>GameSession</code> object that is created for a successful match. This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
    pub fn game_session_data(&self) -> std::option::Option<&str> {
        self.game_session_data.as_deref()
    }
    /// <p>The method that is used to backfill game sessions created with this matchmaking configuration. Specify MANUAL when your game manages backfill requests manually or does not use the match backfill feature. Specify AUTOMATIC to have GameLift create a <code>StartMatchBackfill</code> request whenever a game session has one or more open slots. Learn more about manual and automatic backfill in <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html">Backfill Existing Games with FlexMatch</a>. Automatic backfill is not available when <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
    pub fn backfill_mode(&self) -> std::option::Option<&crate::model::BackfillMode> {
        self.backfill_mode.as_ref()
    }
    /// <p>Indicates whether this matchmaking configuration is being used with GameLift hosting or as a standalone matchmaking solution. </p>
    /// <ul>
    /// <li> <p> <b>STANDALONE</b> - FlexMatch forms matches and returns match information, including players and team assignments, in a <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html#match-events-matchmakingsucceeded"> MatchmakingSucceeded</a> event.</p> </li>
    /// <li> <p> <b>WITH_QUEUE</b> - FlexMatch forms matches and uses the specified GameLift queue to start a game session for the match. </p> </li>
    /// </ul>
    pub fn flex_match_mode(&self) -> std::option::Option<&crate::model::FlexMatchMode> {
        self.flex_match_mode.as_ref()
    }
}
impl std::fmt::Debug for UpdateMatchmakingConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMatchmakingConfigurationInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("game_session_queue_arns", &self.game_session_queue_arns);
        formatter.field("request_timeout_seconds", &self.request_timeout_seconds);
        formatter.field(
            "acceptance_timeout_seconds",
            &self.acceptance_timeout_seconds,
        );
        formatter.field("acceptance_required", &self.acceptance_required);
        formatter.field("rule_set_name", &self.rule_set_name);
        formatter.field("notification_target", &self.notification_target);
        formatter.field("additional_player_count", &self.additional_player_count);
        formatter.field("custom_event_data", &self.custom_event_data);
        formatter.field("game_properties", &self.game_properties);
        formatter.field("game_session_data", &self.game_session_data);
        formatter.field("backfill_mode", &self.backfill_mode);
        formatter.field("flex_match_mode", &self.flex_match_mode);
        formatter.finish()
    }
}

/// <p>Represents the input for a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGameSessionQueueInput {
    /// <p>A descriptive label that is associated with game session queue. Queue names must be unique within each Region. You can use either the queue ID or ARN value. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The maximum time, in seconds, that a new game session placement request remains in the queue. When a request exceeds this time, the game session placement changes to a <code>TIMED_OUT</code> status.</p>
    pub timeout_in_seconds: std::option::Option<i32>,
    /// <p>A set of policies that act as a sliding cap on player latency. FleetIQ works to deliver low latency for most players in a game session. These policies ensure that no individual player can be placed into a game with unreasonably high latency. Use multiple policies to gradually relax latency requirements a step at a time. Multiple policies are applied based on their maximum allowed latency, starting with the lowest value. When updating policies, provide a complete collection of policies.</p>
    pub player_latency_policies:
        std::option::Option<std::vec::Vec<crate::model::PlayerLatencyPolicy>>,
    /// <p>A list of fleets and/or fleet aliases that can be used to fulfill game session placement requests in the queue. Destinations are identified by either a fleet ARN or a fleet alias ARN, and are listed in order of placement preference. When updating this list, provide a complete list of destinations.</p>
    pub destinations: std::option::Option<std::vec::Vec<crate::model::GameSessionQueueDestination>>,
    /// <p>A list of locations where a queue is allowed to place new game sessions. Locations are specified in the form of AWS Region codes, such as <code>us-west-2</code>. If this parameter is not set, game sessions can be placed in any queue location. To remove an existing filter configuration, pass in an empty set.</p>
    pub filter_configuration: std::option::Option<crate::model::FilterConfiguration>,
    /// <p>Custom settings to use when prioritizing destinations and locations for game session placements. This configuration replaces the FleetIQ default prioritization process. Priority types that are not explicitly named will be automatically applied at the end of the prioritization process. To remove an existing priority configuration, pass in an empty set.</p>
    pub priority_configuration: std::option::Option<crate::model::PriorityConfiguration>,
    /// <p> Information to be added to all events that are related to this game session queue. </p>
    pub custom_event_data: std::option::Option<std::string::String>,
    /// <p>An SNS topic ARN that is set up to receive game session placement notifications. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queue-notification.html"> Setting up notifications for game session placement</a>.</p>
    pub notification_target: std::option::Option<std::string::String>,
}
impl UpdateGameSessionQueueInput {
    /// <p>A descriptive label that is associated with game session queue. Queue names must be unique within each Region. You can use either the queue ID or ARN value. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The maximum time, in seconds, that a new game session placement request remains in the queue. When a request exceeds this time, the game session placement changes to a <code>TIMED_OUT</code> status.</p>
    pub fn timeout_in_seconds(&self) -> std::option::Option<i32> {
        self.timeout_in_seconds
    }
    /// <p>A set of policies that act as a sliding cap on player latency. FleetIQ works to deliver low latency for most players in a game session. These policies ensure that no individual player can be placed into a game with unreasonably high latency. Use multiple policies to gradually relax latency requirements a step at a time. Multiple policies are applied based on their maximum allowed latency, starting with the lowest value. When updating policies, provide a complete collection of policies.</p>
    pub fn player_latency_policies(
        &self,
    ) -> std::option::Option<&[crate::model::PlayerLatencyPolicy]> {
        self.player_latency_policies.as_deref()
    }
    /// <p>A list of fleets and/or fleet aliases that can be used to fulfill game session placement requests in the queue. Destinations are identified by either a fleet ARN or a fleet alias ARN, and are listed in order of placement preference. When updating this list, provide a complete list of destinations.</p>
    pub fn destinations(
        &self,
    ) -> std::option::Option<&[crate::model::GameSessionQueueDestination]> {
        self.destinations.as_deref()
    }
    /// <p>A list of locations where a queue is allowed to place new game sessions. Locations are specified in the form of AWS Region codes, such as <code>us-west-2</code>. If this parameter is not set, game sessions can be placed in any queue location. To remove an existing filter configuration, pass in an empty set.</p>
    pub fn filter_configuration(&self) -> std::option::Option<&crate::model::FilterConfiguration> {
        self.filter_configuration.as_ref()
    }
    /// <p>Custom settings to use when prioritizing destinations and locations for game session placements. This configuration replaces the FleetIQ default prioritization process. Priority types that are not explicitly named will be automatically applied at the end of the prioritization process. To remove an existing priority configuration, pass in an empty set.</p>
    pub fn priority_configuration(
        &self,
    ) -> std::option::Option<&crate::model::PriorityConfiguration> {
        self.priority_configuration.as_ref()
    }
    /// <p> Information to be added to all events that are related to this game session queue. </p>
    pub fn custom_event_data(&self) -> std::option::Option<&str> {
        self.custom_event_data.as_deref()
    }
    /// <p>An SNS topic ARN that is set up to receive game session placement notifications. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queue-notification.html"> Setting up notifications for game session placement</a>.</p>
    pub fn notification_target(&self) -> std::option::Option<&str> {
        self.notification_target.as_deref()
    }
}
impl std::fmt::Debug for UpdateGameSessionQueueInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGameSessionQueueInput");
        formatter.field("name", &self.name);
        formatter.field("timeout_in_seconds", &self.timeout_in_seconds);
        formatter.field("player_latency_policies", &self.player_latency_policies);
        formatter.field("destinations", &self.destinations);
        formatter.field("filter_configuration", &self.filter_configuration);
        formatter.field("priority_configuration", &self.priority_configuration);
        formatter.field("custom_event_data", &self.custom_event_data);
        formatter.field("notification_target", &self.notification_target);
        formatter.finish()
    }
}

/// <p>Represents the input for a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGameSessionInput {
    /// <p>A unique identifier for the game session to update. </p>
    pub game_session_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of players that can be connected simultaneously to the game session.</p>
    pub maximum_player_session_count: std::option::Option<i32>,
    /// <p>A descriptive label that is associated with a game session. Session names do not need to be unique.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A policy that determines whether the game session is accepting new players.</p>
    pub player_session_creation_policy:
        std::option::Option<crate::model::PlayerSessionCreationPolicy>,
    /// <p>Game session protection policy to apply to this game session only.</p>
    /// <ul>
    /// <li> <p> <b>NoProtection</b> -- The game session can be terminated during a scale-down event.</p> </li>
    /// <li> <p> <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during a scale-down event.</p> </li>
    /// </ul>
    pub protection_policy: std::option::Option<crate::model::ProtectionPolicy>,
}
impl UpdateGameSessionInput {
    /// <p>A unique identifier for the game session to update. </p>
    pub fn game_session_id(&self) -> std::option::Option<&str> {
        self.game_session_id.as_deref()
    }
    /// <p>The maximum number of players that can be connected simultaneously to the game session.</p>
    pub fn maximum_player_session_count(&self) -> std::option::Option<i32> {
        self.maximum_player_session_count
    }
    /// <p>A descriptive label that is associated with a game session. Session names do not need to be unique.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A policy that determines whether the game session is accepting new players.</p>
    pub fn player_session_creation_policy(
        &self,
    ) -> std::option::Option<&crate::model::PlayerSessionCreationPolicy> {
        self.player_session_creation_policy.as_ref()
    }
    /// <p>Game session protection policy to apply to this game session only.</p>
    /// <ul>
    /// <li> <p> <b>NoProtection</b> -- The game session can be terminated during a scale-down event.</p> </li>
    /// <li> <p> <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during a scale-down event.</p> </li>
    /// </ul>
    pub fn protection_policy(&self) -> std::option::Option<&crate::model::ProtectionPolicy> {
        self.protection_policy.as_ref()
    }
}
impl std::fmt::Debug for UpdateGameSessionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGameSessionInput");
        formatter.field("game_session_id", &self.game_session_id);
        formatter.field(
            "maximum_player_session_count",
            &self.maximum_player_session_count,
        );
        formatter.field("name", &self.name);
        formatter.field(
            "player_session_creation_policy",
            &self.player_session_creation_policy,
        );
        formatter.field("protection_policy", &self.protection_policy);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGameServerGroupInput {
    /// <p>A unique identifier for the game server group. Use either the <code>GameServerGroup</code> name or ARN value.</p>
    pub game_server_group_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) for an IAM role that allows Amazon GameLift to access your EC2 Auto Scaling groups.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>An updated list of EC2 instance types to use in the Auto Scaling group. The instance definitions must specify at least two different instance types that are supported by GameLift FleetIQ. This updated list replaces the entire current list of instance definitions for the game server group. For more information on instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">EC2 Instance Types</a> in the <i>Amazon EC2 User Guide</i>. You can optionally specify capacity weighting for each instance type. If no weight value is specified for an instance type, it is set to the default value "1". For more information about capacity weighting, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html"> Instance Weighting for Amazon EC2 Auto Scaling</a> in the Amazon EC2 Auto Scaling User Guide.</p>
    pub instance_definitions: std::option::Option<std::vec::Vec<crate::model::InstanceDefinition>>,
    /// <p>A flag that indicates whether instances in the game server group are protected from early termination. Unprotected instances that have active game servers running might be terminated during a scale-down event, causing players to be dropped from the game. Protected instances cannot be terminated while there are active game servers running except in the event of a forced game server group deletion (see ). An exception to this is with Spot Instances, which can be terminated by AWS regardless of protection status. This property is set to <code>NO_PROTECTION</code> by default.</p>
    pub game_server_protection_policy:
        std::option::Option<crate::model::GameServerProtectionPolicy>,
    /// <p>Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game server group. Method options include the following:</p>
    /// <ul>
    /// <li> <p> <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are unavailable or not viable for game hosting, the game server group provides no hosting capacity until Spot Instances can again be used. Until then, no new instances are started, and the existing nonviable Spot Instances are terminated (after current gameplay ends) and are not replaced.</p> </li>
    /// <li> <p> <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game server group. If Spot Instances are unavailable, the game server group continues to provide hosting capacity by falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after current gameplay ends) and are replaced with new On-Demand Instances.</p> </li>
    /// <li> <p> <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot Instances are used, even when available, while this balancing strategy is in force.</p> </li>
    /// </ul>
    pub balancing_strategy: std::option::Option<crate::model::BalancingStrategy>,
}
impl UpdateGameServerGroupInput {
    /// <p>A unique identifier for the game server group. Use either the <code>GameServerGroup</code> name or ARN value.</p>
    pub fn game_server_group_name(&self) -> std::option::Option<&str> {
        self.game_server_group_name.as_deref()
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) for an IAM role that allows Amazon GameLift to access your EC2 Auto Scaling groups.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>An updated list of EC2 instance types to use in the Auto Scaling group. The instance definitions must specify at least two different instance types that are supported by GameLift FleetIQ. This updated list replaces the entire current list of instance definitions for the game server group. For more information on instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">EC2 Instance Types</a> in the <i>Amazon EC2 User Guide</i>. You can optionally specify capacity weighting for each instance type. If no weight value is specified for an instance type, it is set to the default value "1". For more information about capacity weighting, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html"> Instance Weighting for Amazon EC2 Auto Scaling</a> in the Amazon EC2 Auto Scaling User Guide.</p>
    pub fn instance_definitions(&self) -> std::option::Option<&[crate::model::InstanceDefinition]> {
        self.instance_definitions.as_deref()
    }
    /// <p>A flag that indicates whether instances in the game server group are protected from early termination. Unprotected instances that have active game servers running might be terminated during a scale-down event, causing players to be dropped from the game. Protected instances cannot be terminated while there are active game servers running except in the event of a forced game server group deletion (see ). An exception to this is with Spot Instances, which can be terminated by AWS regardless of protection status. This property is set to <code>NO_PROTECTION</code> by default.</p>
    pub fn game_server_protection_policy(
        &self,
    ) -> std::option::Option<&crate::model::GameServerProtectionPolicy> {
        self.game_server_protection_policy.as_ref()
    }
    /// <p>Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game server group. Method options include the following:</p>
    /// <ul>
    /// <li> <p> <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are unavailable or not viable for game hosting, the game server group provides no hosting capacity until Spot Instances can again be used. Until then, no new instances are started, and the existing nonviable Spot Instances are terminated (after current gameplay ends) and are not replaced.</p> </li>
    /// <li> <p> <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game server group. If Spot Instances are unavailable, the game server group continues to provide hosting capacity by falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after current gameplay ends) and are replaced with new On-Demand Instances.</p> </li>
    /// <li> <p> <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot Instances are used, even when available, while this balancing strategy is in force.</p> </li>
    /// </ul>
    pub fn balancing_strategy(&self) -> std::option::Option<&crate::model::BalancingStrategy> {
        self.balancing_strategy.as_ref()
    }
}
impl std::fmt::Debug for UpdateGameServerGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGameServerGroupInput");
        formatter.field("game_server_group_name", &self.game_server_group_name);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("instance_definitions", &self.instance_definitions);
        formatter.field(
            "game_server_protection_policy",
            &self.game_server_protection_policy,
        );
        formatter.field("balancing_strategy", &self.balancing_strategy);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGameServerInput {
    /// <p>A unique identifier for the game server group where the game server is running. Use either the <code>GameServerGroup</code> name or ARN value.</p>
    pub game_server_group_name: std::option::Option<std::string::String>,
    /// <p>A custom string that uniquely identifies the game server to update.</p>
    pub game_server_id: std::option::Option<std::string::String>,
    /// <p>A set of custom game server properties, formatted as a single string value. This data is passed to a game client or service when it requests information on game servers using <code>ListGameServers</code> or <code>ClaimGameServer</code>. </p>
    pub game_server_data: std::option::Option<std::string::String>,
    /// <p>Indicates whether the game server is available or is currently hosting gameplay.</p>
    pub utilization_status: std::option::Option<crate::model::GameServerUtilizationStatus>,
    /// <p>Indicates health status of the game server. A request that includes this parameter updates the game server's <i>LastHealthCheckTime</i> timestamp. </p>
    pub health_check: std::option::Option<crate::model::GameServerHealthCheck>,
}
impl UpdateGameServerInput {
    /// <p>A unique identifier for the game server group where the game server is running. Use either the <code>GameServerGroup</code> name or ARN value.</p>
    pub fn game_server_group_name(&self) -> std::option::Option<&str> {
        self.game_server_group_name.as_deref()
    }
    /// <p>A custom string that uniquely identifies the game server to update.</p>
    pub fn game_server_id(&self) -> std::option::Option<&str> {
        self.game_server_id.as_deref()
    }
    /// <p>A set of custom game server properties, formatted as a single string value. This data is passed to a game client or service when it requests information on game servers using <code>ListGameServers</code> or <code>ClaimGameServer</code>. </p>
    pub fn game_server_data(&self) -> std::option::Option<&str> {
        self.game_server_data.as_deref()
    }
    /// <p>Indicates whether the game server is available or is currently hosting gameplay.</p>
    pub fn utilization_status(
        &self,
    ) -> std::option::Option<&crate::model::GameServerUtilizationStatus> {
        self.utilization_status.as_ref()
    }
    /// <p>Indicates health status of the game server. A request that includes this parameter updates the game server's <i>LastHealthCheckTime</i> timestamp. </p>
    pub fn health_check(&self) -> std::option::Option<&crate::model::GameServerHealthCheck> {
        self.health_check.as_ref()
    }
}
impl std::fmt::Debug for UpdateGameServerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGameServerInput");
        formatter.field("game_server_group_name", &self.game_server_group_name);
        formatter.field("game_server_id", &self.game_server_id);
        formatter.field("game_server_data", &self.game_server_data);
        formatter.field("utilization_status", &self.utilization_status);
        formatter.field("health_check", &self.health_check);
        formatter.finish()
    }
}

/// <p>Represents the input for a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFleetPortSettingsInput {
    /// <p>A unique identifier for the fleet to update port settings for. You can use either the fleet ID or ARN value.</p>
    pub fleet_id: std::option::Option<std::string::String>,
    /// <p>A collection of port settings to be added to the fleet resource.</p>
    pub inbound_permission_authorizations:
        std::option::Option<std::vec::Vec<crate::model::IpPermission>>,
    /// <p>A collection of port settings to be removed from the fleet resource.</p>
    pub inbound_permission_revocations:
        std::option::Option<std::vec::Vec<crate::model::IpPermission>>,
}
impl UpdateFleetPortSettingsInput {
    /// <p>A unique identifier for the fleet to update port settings for. You can use either the fleet ID or ARN value.</p>
    pub fn fleet_id(&self) -> std::option::Option<&str> {
        self.fleet_id.as_deref()
    }
    /// <p>A collection of port settings to be added to the fleet resource.</p>
    pub fn inbound_permission_authorizations(
        &self,
    ) -> std::option::Option<&[crate::model::IpPermission]> {
        self.inbound_permission_authorizations.as_deref()
    }
    /// <p>A collection of port settings to be removed from the fleet resource.</p>
    pub fn inbound_permission_revocations(
        &self,
    ) -> std::option::Option<&[crate::model::IpPermission]> {
        self.inbound_permission_revocations.as_deref()
    }
}
impl std::fmt::Debug for UpdateFleetPortSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFleetPortSettingsInput");
        formatter.field("fleet_id", &self.fleet_id);
        formatter.field(
            "inbound_permission_authorizations",
            &self.inbound_permission_authorizations,
        );
        formatter.field(
            "inbound_permission_revocations",
            &self.inbound_permission_revocations,
        );
        formatter.finish()
    }
}

/// <p>Represents the input for a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFleetCapacityInput {
    /// <p>A unique identifier for the fleet to update capacity settings for. You can use either the fleet ID or ARN value.</p>
    pub fleet_id: std::option::Option<std::string::String>,
    /// <p>The number of EC2 instances you want to maintain in the specified fleet location. This value must fall between the minimum and maximum size limits.</p>
    pub desired_instances: std::option::Option<i32>,
    /// <p>The minimum number of instances that are allowed in the specified fleet location. If this parameter is not set, the default is 0.</p>
    pub min_size: std::option::Option<i32>,
    /// <p>The maximum number of instances that are allowed in the specified fleet location. If this parameter is not set, the default is 1.</p>
    pub max_size: std::option::Option<i32>,
    /// <p>The name of a remote location to update fleet capacity settings for, in the form of an AWS Region code such as <code>us-west-2</code>.</p>
    pub location: std::option::Option<std::string::String>,
}
impl UpdateFleetCapacityInput {
    /// <p>A unique identifier for the fleet to update capacity settings for. You can use either the fleet ID or ARN value.</p>
    pub fn fleet_id(&self) -> std::option::Option<&str> {
        self.fleet_id.as_deref()
    }
    /// <p>The number of EC2 instances you want to maintain in the specified fleet location. This value must fall between the minimum and maximum size limits.</p>
    pub fn desired_instances(&self) -> std::option::Option<i32> {
        self.desired_instances
    }
    /// <p>The minimum number of instances that are allowed in the specified fleet location. If this parameter is not set, the default is 0.</p>
    pub fn min_size(&self) -> std::option::Option<i32> {
        self.min_size
    }
    /// <p>The maximum number of instances that are allowed in the specified fleet location. If this parameter is not set, the default is 1.</p>
    pub fn max_size(&self) -> std::option::Option<i32> {
        self.max_size
    }
    /// <p>The name of a remote location to update fleet capacity settings for, in the form of an AWS Region code such as <code>us-west-2</code>.</p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
}
impl std::fmt::Debug for UpdateFleetCapacityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFleetCapacityInput");
        formatter.field("fleet_id", &self.fleet_id);
        formatter.field("desired_instances", &self.desired_instances);
        formatter.field("min_size", &self.min_size);
        formatter.field("max_size", &self.max_size);
        formatter.field("location", &self.location);
        formatter.finish()
    }
}

/// <p>Represents the input for a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFleetAttributesInput {
    /// <p>A unique identifier for the fleet to update attribute metadata for. You can use either the fleet ID or ARN value.</p>
    pub fleet_id: std::option::Option<std::string::String>,
    /// <p>A descriptive label that is associated with a fleet. Fleet names do not need to be unique.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A human-readable description of a fleet.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The game session protection policy to apply to all new instances created in this fleet. Instances that already exist are not affected. You can set protection for individual instances using <code>UpdateGameSession</code>.</p>
    /// <ul>
    /// <li> <p> <b>NoProtection</b> -- The game session can be terminated during a scale-down event.</p> </li>
    /// <li> <p> <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during a scale-down event.</p> </li>
    /// </ul>
    pub new_game_session_protection_policy: std::option::Option<crate::model::ProtectionPolicy>,
    /// <p>Policy settings that limit the number of game sessions an individual player can create over a span of time. </p>
    pub resource_creation_limit_policy:
        std::option::Option<crate::model::ResourceCreationLimitPolicy>,
    /// <p>The name of a metric group to add this fleet to. Use a metric group in Amazon CloudWatch to aggregate the metrics from multiple fleets. Provide an existing metric group name, or create a new metric group by providing a new name. A fleet can only be in one metric group at a time.</p>
    pub metric_groups: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UpdateFleetAttributesInput {
    /// <p>A unique identifier for the fleet to update attribute metadata for. You can use either the fleet ID or ARN value.</p>
    pub fn fleet_id(&self) -> std::option::Option<&str> {
        self.fleet_id.as_deref()
    }
    /// <p>A descriptive label that is associated with a fleet. Fleet names do not need to be unique.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A human-readable description of a fleet.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The game session protection policy to apply to all new instances created in this fleet. Instances that already exist are not affected. You can set protection for individual instances using <code>UpdateGameSession</code>.</p>
    /// <ul>
    /// <li> <p> <b>NoProtection</b> -- The game session can be terminated during a scale-down event.</p> </li>
    /// <li> <p> <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during a scale-down event.</p> </li>
    /// </ul>
    pub fn new_game_session_protection_policy(
        &self,
    ) -> std::option::Option<&crate::model::ProtectionPolicy> {
        self.new_game_session_protection_policy.as_ref()
    }
    /// <p>Policy settings that limit the number of game sessions an individual player can create over a span of time. </p>
    pub fn resource_creation_limit_policy(
        &self,
    ) -> std::option::Option<&crate::model::ResourceCreationLimitPolicy> {
        self.resource_creation_limit_policy.as_ref()
    }
    /// <p>The name of a metric group to add this fleet to. Use a metric group in Amazon CloudWatch to aggregate the metrics from multiple fleets. Provide an existing metric group name, or create a new metric group by providing a new name. A fleet can only be in one metric group at a time.</p>
    pub fn metric_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.metric_groups.as_deref()
    }
}
impl std::fmt::Debug for UpdateFleetAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFleetAttributesInput");
        formatter.field("fleet_id", &self.fleet_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field(
            "new_game_session_protection_policy",
            &self.new_game_session_protection_policy,
        );
        formatter.field(
            "resource_creation_limit_policy",
            &self.resource_creation_limit_policy,
        );
        formatter.field("metric_groups", &self.metric_groups);
        formatter.finish()
    }
}

/// <p>Represents the input for a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBuildInput {
    /// <p>A unique identifier for the build to update. You can use either the build ID or ARN value. </p>
    pub build_id: std::option::Option<std::string::String>,
    /// <p>A descriptive label that is associated with a build. Build names do not need to be unique. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Version information that is associated with a build or script. Version strings do not need to be unique.</p>
    pub version: std::option::Option<std::string::String>,
}
impl UpdateBuildInput {
    /// <p>A unique identifier for the build to update. You can use either the build ID or ARN value. </p>
    pub fn build_id(&self) -> std::option::Option<&str> {
        self.build_id.as_deref()
    }
    /// <p>A descriptive label that is associated with a build. Build names do not need to be unique. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Version information that is associated with a build or script. Version strings do not need to be unique.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for UpdateBuildInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBuildInput");
        formatter.field("build_id", &self.build_id);
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}

/// <p>Represents the input for a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAliasInput {
    /// <p>A unique identifier for the alias that you want to update. You can use either the alias ID or ARN value.</p>
    pub alias_id: std::option::Option<std::string::String>,
    /// <p>A descriptive label that is associated with an alias. Alias names do not need to be unique.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A human-readable description of the alias.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The routing configuration, including routing type and fleet target, for the alias.</p>
    pub routing_strategy: std::option::Option<crate::model::RoutingStrategy>,
}
impl UpdateAliasInput {
    /// <p>A unique identifier for the alias that you want to update. You can use either the alias ID or ARN value.</p>
    pub fn alias_id(&self) -> std::option::Option<&str> {
        self.alias_id.as_deref()
    }
    /// <p>A descriptive label that is associated with an alias. Alias names do not need to be unique.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A human-readable description of the alias.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The routing configuration, including routing type and fleet target, for the alias.</p>
    pub fn routing_strategy(&self) -> std::option::Option<&crate::model::RoutingStrategy> {
        self.routing_strategy.as_ref()
    }
}
impl std::fmt::Debug for UpdateAliasInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAliasInput");
        formatter.field("alias_id", &self.alias_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("routing_strategy", &self.routing_strategy);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to and uniquely identifies the GameLift resource that you want to remove tags from. GameLift resource ARNs are included in the data object for the resource, which can be retrieved by calling a List or Describe operation for the resource type. </p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of one or more tag keys to remove from the specified GameLift resource. An AWS resource can have only one tag with a specific tag key, so specifying the tag key identifies which tag to remove. </p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to and uniquely identifies the GameLift resource that you want to remove tags from. GameLift resource ARNs are included in the data object for the resource, which can be retrieved by calling a List or Describe operation for the resource type. </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of one or more tag keys to remove from the specified GameLift resource. An AWS resource can have only one tag with a specific tag key, so specifying the tag key identifies which tag to remove. </p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to and uniquely identifies the GameLift resource that you want to assign tags to. GameLift resource ARNs are included in the data object for the resource, which can be retrieved by calling a List or Describe operation for the resource type. </p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of one or more tags to assign to the specified GameLift resource. Tags are developer-defined and structured as key-value pairs. The maximum tag limit may be lower than stated. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources</a> for actual tagging limits.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to and uniquely identifies the GameLift resource that you want to assign tags to. GameLift resource ARNs are included in the data object for the resource, which can be retrieved by calling a List or Describe operation for the resource type. </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of one or more tags to assign to the specified GameLift resource. Tags are developer-defined and structured as key-value pairs. The maximum tag limit may be lower than stated. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources</a> for actual tagging limits.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SuspendGameServerGroupInput {
    /// <p>A unique identifier for the game server group. Use either the <code>GameServerGroup</code> name or ARN value.</p>
    pub game_server_group_name: std::option::Option<std::string::String>,
    /// <p>The activity to suspend for this game server group.</p>
    pub suspend_actions: std::option::Option<std::vec::Vec<crate::model::GameServerGroupAction>>,
}
impl SuspendGameServerGroupInput {
    /// <p>A unique identifier for the game server group. Use either the <code>GameServerGroup</code> name or ARN value.</p>
    pub fn game_server_group_name(&self) -> std::option::Option<&str> {
        self.game_server_group_name.as_deref()
    }
    /// <p>The activity to suspend for this game server group.</p>
    pub fn suspend_actions(&self) -> std::option::Option<&[crate::model::GameServerGroupAction]> {
        self.suspend_actions.as_deref()
    }
}
impl std::fmt::Debug for SuspendGameServerGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SuspendGameServerGroupInput");
        formatter.field("game_server_group_name", &self.game_server_group_name);
        formatter.field("suspend_actions", &self.suspend_actions);
        formatter.finish()
    }
}

/// <p>Represents the input for a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopMatchmakingInput {
    /// <p>A unique identifier for a matchmaking ticket.</p>
    pub ticket_id: std::option::Option<std::string::String>,
}
impl StopMatchmakingInput {
    /// <p>A unique identifier for a matchmaking ticket.</p>
    pub fn ticket_id(&self) -> std::option::Option<&str> {
        self.ticket_id.as_deref()
    }
}
impl std::fmt::Debug for StopMatchmakingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopMatchmakingInput");
        formatter.field("ticket_id", &self.ticket_id);
        formatter.finish()
    }
}

/// <p>Represents the input for a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopGameSessionPlacementInput {
    /// <p>A unique identifier for a game session placement to cancel.</p>
    pub placement_id: std::option::Option<std::string::String>,
}
impl StopGameSessionPlacementInput {
    /// <p>A unique identifier for a game session placement to cancel.</p>
    pub fn placement_id(&self) -> std::option::Option<&str> {
        self.placement_id.as_deref()
    }
}
impl std::fmt::Debug for StopGameSessionPlacementInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopGameSessionPlacementInput");
        formatter.field("placement_id", &self.placement_id);
        formatter.finish()
    }
}

/// <p>Represents the input for a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopFleetActionsInput {
    /// <p>A unique identifier for the fleet to stop actions on. You can use either the fleet ID or ARN value.</p>
    pub fleet_id: std::option::Option<std::string::String>,
    /// <p>List of actions to suspend on the fleet. </p>
    pub actions: std::option::Option<std::vec::Vec<crate::model::FleetAction>>,
    /// <p>The fleet location to stop fleet actions for. Specify a location in the form of an AWS Region code, such as <code>us-west-2</code>.</p>
    pub location: std::option::Option<std::string::String>,
}
impl StopFleetActionsInput {
    /// <p>A unique identifier for the fleet to stop actions on. You can use either the fleet ID or ARN value.</p>
    pub fn fleet_id(&self) -> std::option::Option<&str> {
        self.fleet_id.as_deref()
    }
    /// <p>List of actions to suspend on the fleet. </p>
    pub fn actions(&self) -> std::option::Option<&[crate::model::FleetAction]> {
        self.actions.as_deref()
    }
    /// <p>The fleet location to stop fleet actions for. Specify a location in the form of an AWS Region code, such as <code>us-west-2</code>.</p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
}
impl std::fmt::Debug for StopFleetActionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopFleetActionsInput");
        formatter.field("fleet_id", &self.fleet_id);
        formatter.field("actions", &self.actions);
        formatter.field("location", &self.location);
        formatter.finish()
    }
}

/// <p>Represents the input for a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartMatchmakingInput {
    /// <p>A unique identifier for a matchmaking ticket. If no ticket ID 