// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AcceptMatch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AcceptMatchError {
    /// Kind of error that occurred.
    pub kind: AcceptMatchErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AcceptMatch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AcceptMatchErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The requested operation is not supported in the Region specified.</p>
    UnsupportedRegionException(crate::error::UnsupportedRegionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AcceptMatchError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AcceptMatchErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            AcceptMatchErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            AcceptMatchErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            AcceptMatchErrorKind::UnsupportedRegionException(_inner) => _inner.fmt(f),
            AcceptMatchErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AcceptMatchError {
    fn code(&self) -> Option<&str> {
        AcceptMatchError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AcceptMatchError {
    /// Creates a new `AcceptMatchError`.
    pub fn new(kind: AcceptMatchErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AcceptMatchError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AcceptMatchErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AcceptMatchError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AcceptMatchErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AcceptMatchErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptMatchErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptMatchErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, AcceptMatchErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `AcceptMatchErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, AcceptMatchErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `AcceptMatchErrorKind::UnsupportedRegionException`.
    pub fn is_unsupported_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptMatchErrorKind::UnsupportedRegionException(_)
        )
    }
}
impl std::error::Error for AcceptMatchError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AcceptMatchErrorKind::InternalServiceException(_inner) => Some(_inner),
            AcceptMatchErrorKind::InvalidRequestException(_inner) => Some(_inner),
            AcceptMatchErrorKind::NotFoundException(_inner) => Some(_inner),
            AcceptMatchErrorKind::UnsupportedRegionException(_inner) => Some(_inner),
            AcceptMatchErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ClaimGameServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ClaimGameServerError {
    /// Kind of error that occurred.
    pub kind: ClaimGameServerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ClaimGameServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ClaimGameServerErrorKind {
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The specified game server group has no available game servers to fulfill a <code>ClaimGameServer</code> request. Clients can retry such requests immediately or after a waiting period. </p>
    OutOfCapacityException(crate::error::OutOfCapacityException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ClaimGameServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ClaimGameServerErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ClaimGameServerErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ClaimGameServerErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ClaimGameServerErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ClaimGameServerErrorKind::OutOfCapacityException(_inner) => _inner.fmt(f),
            ClaimGameServerErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ClaimGameServerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ClaimGameServerError {
    fn code(&self) -> Option<&str> {
        ClaimGameServerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ClaimGameServerError {
    /// Creates a new `ClaimGameServerError`.
    pub fn new(kind: ClaimGameServerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ClaimGameServerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ClaimGameServerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ClaimGameServerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ClaimGameServerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ClaimGameServerErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, ClaimGameServerErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `ClaimGameServerErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ClaimGameServerErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ClaimGameServerErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ClaimGameServerErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ClaimGameServerErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ClaimGameServerErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `ClaimGameServerErrorKind::OutOfCapacityException`.
    pub fn is_out_of_capacity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ClaimGameServerErrorKind::OutOfCapacityException(_)
        )
    }
    /// Returns `true` if the error kind is `ClaimGameServerErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ClaimGameServerErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ClaimGameServerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ClaimGameServerErrorKind::ConflictException(_inner) => Some(_inner),
            ClaimGameServerErrorKind::InternalServiceException(_inner) => Some(_inner),
            ClaimGameServerErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ClaimGameServerErrorKind::NotFoundException(_inner) => Some(_inner),
            ClaimGameServerErrorKind::OutOfCapacityException(_inner) => Some(_inner),
            ClaimGameServerErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ClaimGameServerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAliasError {
    /// Kind of error that occurred.
    pub kind: CreateAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAliasErrorKind {
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested operation would cause the resource to exceed the allowed service limit. Resolve the issue before retrying.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p> The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying. </p>
    TaggingFailedException(crate::error::TaggingFailedException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAliasErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateAliasErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateAliasErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateAliasErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateAliasErrorKind::TaggingFailedException(_inner) => _inner.fmt(f),
            CreateAliasErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAliasError {
    fn code(&self) -> Option<&str> {
        CreateAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAliasError {
    /// Creates a new `CreateAliasError`.
    pub fn new(kind: CreateAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAliasErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAliasErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateAliasErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateAliasErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAliasErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAliasErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, CreateAliasErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateAliasErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateAliasErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateAliasErrorKind::TaggingFailedException`.
    pub fn is_tagging_failed_exception(&self) -> bool {
        matches!(&self.kind, CreateAliasErrorKind::TaggingFailedException(_))
    }
    /// Returns `true` if the error kind is `CreateAliasErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, CreateAliasErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for CreateAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAliasErrorKind::ConflictException(_inner) => Some(_inner),
            CreateAliasErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateAliasErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateAliasErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateAliasErrorKind::TaggingFailedException(_inner) => Some(_inner),
            CreateAliasErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateBuild` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBuildError {
    /// Kind of error that occurred.
    pub kind: CreateBuildErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBuild` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBuildErrorKind {
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p> The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying. </p>
    TaggingFailedException(crate::error::TaggingFailedException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBuildError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBuildErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateBuildErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateBuildErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateBuildErrorKind::TaggingFailedException(_inner) => _inner.fmt(f),
            CreateBuildErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateBuildErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBuildError {
    fn code(&self) -> Option<&str> {
        CreateBuildError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBuildError {
    /// Creates a new `CreateBuildError`.
    pub fn new(kind: CreateBuildErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBuildError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBuildErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBuildError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBuildErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateBuildErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateBuildErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateBuildErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBuildErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBuildErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, CreateBuildErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateBuildErrorKind::TaggingFailedException`.
    pub fn is_tagging_failed_exception(&self) -> bool {
        matches!(&self.kind, CreateBuildErrorKind::TaggingFailedException(_))
    }
    /// Returns `true` if the error kind is `CreateBuildErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, CreateBuildErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for CreateBuildError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBuildErrorKind::ConflictException(_inner) => Some(_inner),
            CreateBuildErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateBuildErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateBuildErrorKind::TaggingFailedException(_inner) => Some(_inner),
            CreateBuildErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateBuildErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateFleet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateFleetError {
    /// Kind of error that occurred.
    pub kind: CreateFleetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateFleet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateFleetErrorKind {
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested operation would cause the resource to exceed the allowed service limit. Resolve the issue before retrying.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying. </p>
    TaggingFailedException(crate::error::TaggingFailedException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// <p>The requested operation is not supported in the Region specified.</p>
    UnsupportedRegionException(crate::error::UnsupportedRegionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateFleetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateFleetErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateFleetErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateFleetErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateFleetErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateFleetErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateFleetErrorKind::TaggingFailedException(_inner) => _inner.fmt(f),
            CreateFleetErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateFleetErrorKind::UnsupportedRegionException(_inner) => _inner.fmt(f),
            CreateFleetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateFleetError {
    fn code(&self) -> Option<&str> {
        CreateFleetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateFleetError {
    /// Creates a new `CreateFleetError`.
    pub fn new(kind: CreateFleetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateFleetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateFleetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateFleetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateFleetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateFleetErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateFleetErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateFleetErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFleetErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFleetErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, CreateFleetErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateFleetErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateFleetErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateFleetErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateFleetErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateFleetErrorKind::TaggingFailedException`.
    pub fn is_tagging_failed_exception(&self) -> bool {
        matches!(&self.kind, CreateFleetErrorKind::TaggingFailedException(_))
    }
    /// Returns `true` if the error kind is `CreateFleetErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, CreateFleetErrorKind::UnauthorizedException(_))
    }
    /// Returns `true` if the error kind is `CreateFleetErrorKind::UnsupportedRegionException`.
    pub fn is_unsupported_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFleetErrorKind::UnsupportedRegionException(_)
        )
    }
}
impl std::error::Error for CreateFleetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateFleetErrorKind::ConflictException(_inner) => Some(_inner),
            CreateFleetErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateFleetErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateFleetErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateFleetErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateFleetErrorKind::TaggingFailedException(_inner) => Some(_inner),
            CreateFleetErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateFleetErrorKind::UnsupportedRegionException(_inner) => Some(_inner),
            CreateFleetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateFleetLocations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateFleetLocationsError {
    /// Kind of error that occurred.
    pub kind: CreateFleetLocationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateFleetLocations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateFleetLocationsErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The requested operation would cause a conflict with the current state of a resource associated with the request and/or the fleet. Resolve the conflict before retrying.</p>
    InvalidFleetStatusException(crate::error::InvalidFleetStatusException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// <p>The requested operation is not supported in the Region specified.</p>
    UnsupportedRegionException(crate::error::UnsupportedRegionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateFleetLocationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateFleetLocationsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateFleetLocationsErrorKind::InvalidFleetStatusException(_inner) => _inner.fmt(f),
            CreateFleetLocationsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateFleetLocationsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateFleetLocationsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateFleetLocationsErrorKind::UnsupportedRegionException(_inner) => _inner.fmt(f),
            CreateFleetLocationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateFleetLocationsError {
    fn code(&self) -> Option<&str> {
        CreateFleetLocationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateFleetLocationsError {
    /// Creates a new `CreateFleetLocationsError`.
    pub fn new(kind: CreateFleetLocationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateFleetLocationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateFleetLocationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateFleetLocationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateFleetLocationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateFleetLocationsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFleetLocationsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFleetLocationsErrorKind::InvalidFleetStatusException`.
    pub fn is_invalid_fleet_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFleetLocationsErrorKind::InvalidFleetStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFleetLocationsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFleetLocationsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFleetLocationsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFleetLocationsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFleetLocationsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFleetLocationsErrorKind::UnauthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFleetLocationsErrorKind::UnsupportedRegionException`.
    pub fn is_unsupported_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFleetLocationsErrorKind::UnsupportedRegionException(_)
        )
    }
}
impl std::error::Error for CreateFleetLocationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateFleetLocationsErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateFleetLocationsErrorKind::InvalidFleetStatusException(_inner) => Some(_inner),
            CreateFleetLocationsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateFleetLocationsErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateFleetLocationsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateFleetLocationsErrorKind::UnsupportedRegionException(_inner) => Some(_inner),
            CreateFleetLocationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateGameServerGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateGameServerGroupError {
    /// Kind of error that occurred.
    pub kind: CreateGameServerGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateGameServerGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateGameServerGroupErrorKind {
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested operation would cause the resource to exceed the allowed service limit. Resolve the issue before retrying.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateGameServerGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateGameServerGroupErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateGameServerGroupErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateGameServerGroupErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateGameServerGroupErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateGameServerGroupErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateGameServerGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateGameServerGroupError {
    fn code(&self) -> Option<&str> {
        CreateGameServerGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateGameServerGroupError {
    /// Creates a new `CreateGameServerGroupError`.
    pub fn new(kind: CreateGameServerGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateGameServerGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateGameServerGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateGameServerGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateGameServerGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateGameServerGroupErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGameServerGroupErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGameServerGroupErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGameServerGroupErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGameServerGroupErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGameServerGroupErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGameServerGroupErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGameServerGroupErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGameServerGroupErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGameServerGroupErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateGameServerGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateGameServerGroupErrorKind::ConflictException(_inner) => Some(_inner),
            CreateGameServerGroupErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateGameServerGroupErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateGameServerGroupErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateGameServerGroupErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateGameServerGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateGameSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateGameSessionError {
    /// Kind of error that occurred.
    pub kind: CreateGameSessionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateGameSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateGameSessionErrorKind {
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The specified fleet has no available instances to fulfill a <code>CreateGameSession</code> request. Clients can retry such requests immediately or after a waiting period.</p>
    FleetCapacityExceededException(crate::error::FleetCapacityExceededException),
    /// <p>A game session with this custom ID string already exists in this fleet. Resolve this conflict before retrying this request.</p>
    IdempotentParameterMismatchException(crate::error::IdempotentParameterMismatchException),
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The requested operation would cause a conflict with the current state of a resource associated with the request and/or the fleet. Resolve the conflict before retrying.</p>
    InvalidFleetStatusException(crate::error::InvalidFleetStatusException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested operation would cause the resource to exceed the allowed service limit. Resolve the issue before retrying.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service is unable to resolve the routing for a particular alias because it has a terminal <code>RoutingStrategy</code> associated with it. The message returned in this exception is the message defined in the routing strategy itself. Such requests should only be retried if the routing strategy for the specified alias is modified. </p>
    TerminalRoutingStrategyException(crate::error::TerminalRoutingStrategyException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// <p>The requested operation is not supported in the Region specified.</p>
    UnsupportedRegionException(crate::error::UnsupportedRegionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateGameSessionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateGameSessionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateGameSessionErrorKind::FleetCapacityExceededException(_inner) => _inner.fmt(f),
            CreateGameSessionErrorKind::IdempotentParameterMismatchException(_inner) => {
                _inner.fmt(f)
            }
            CreateGameSessionErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateGameSessionErrorKind::InvalidFleetStatusException(_inner) => _inner.fmt(f),
            CreateGameSessionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateGameSessionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateGameSessionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateGameSessionErrorKind::TerminalRoutingStrategyException(_inner) => _inner.fmt(f),
            CreateGameSessionErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateGameSessionErrorKind::UnsupportedRegionException(_inner) => _inner.fmt(f),
            CreateGameSessionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateGameSessionError {
    fn code(&self) -> Option<&str> {
        CreateGameSessionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateGameSessionError {
    /// Creates a new `CreateGameSessionError`.
    pub fn new(kind: CreateGameSessionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateGameSessionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateGameSessionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateGameSessionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateGameSessionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateGameSessionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateGameSessionErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateGameSessionErrorKind::FleetCapacityExceededException`.
    pub fn is_fleet_capacity_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGameSessionErrorKind::FleetCapacityExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGameSessionErrorKind::IdempotentParameterMismatchException`.
    pub fn is_idempotent_parameter_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGameSessionErrorKind::IdempotentParameterMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGameSessionErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGameSessionErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGameSessionErrorKind::InvalidFleetStatusException`.
    pub fn is_invalid_fleet_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGameSessionErrorKind::InvalidFleetStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGameSessionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGameSessionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGameSessionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGameSessionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGameSessionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateGameSessionErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateGameSessionErrorKind::TerminalRoutingStrategyException`.
    pub fn is_terminal_routing_strategy_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGameSessionErrorKind::TerminalRoutingStrategyException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGameSessionErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGameSessionErrorKind::UnauthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGameSessionErrorKind::UnsupportedRegionException`.
    pub fn is_unsupported_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGameSessionErrorKind::UnsupportedRegionException(_)
        )
    }
}
impl std::error::Error for CreateGameSessionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateGameSessionErrorKind::ConflictException(_inner) => Some(_inner),
            CreateGameSessionErrorKind::FleetCapacityExceededException(_inner) => Some(_inner),
            CreateGameSessionErrorKind::IdempotentParameterMismatchException(_inner) => {
                Some(_inner)
            }
            CreateGameSessionErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateGameSessionErrorKind::InvalidFleetStatusException(_inner) => Some(_inner),
            CreateGameSessionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateGameSessionErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateGameSessionErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateGameSessionErrorKind::TerminalRoutingStrategyException(_inner) => Some(_inner),
            CreateGameSessionErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateGameSessionErrorKind::UnsupportedRegionException(_inner) => Some(_inner),
            CreateGameSessionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateGameSessionQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateGameSessionQueueError {
    /// Kind of error that occurred.
    pub kind: CreateGameSessionQueueErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateGameSessionQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateGameSessionQueueErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested operation would cause the resource to exceed the allowed service limit. Resolve the issue before retrying.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying. </p>
    TaggingFailedException(crate::error::TaggingFailedException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateGameSessionQueueError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateGameSessionQueueErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateGameSessionQueueErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateGameSessionQueueErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateGameSessionQueueErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateGameSessionQueueErrorKind::TaggingFailedException(_inner) => _inner.fmt(f),
            CreateGameSessionQueueErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateGameSessionQueueErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateGameSessionQueueError {
    fn code(&self) -> Option<&str> {
        CreateGameSessionQueueError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateGameSessionQueueError {
    /// Creates a new `CreateGameSessionQueueError`.
    pub fn new(kind: CreateGameSessionQueueErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateGameSessionQueueError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateGameSessionQueueErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateGameSessionQueueError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateGameSessionQueueErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateGameSessionQueueErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGameSessionQueueErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGameSessionQueueErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGameSessionQueueErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGameSessionQueueErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGameSessionQueueErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGameSessionQueueErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGameSessionQueueErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGameSessionQueueErrorKind::TaggingFailedException`.
    pub fn is_tagging_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGameSessionQueueErrorKind::TaggingFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGameSessionQueueErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGameSessionQueueErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateGameSessionQueueError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateGameSessionQueueErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateGameSessionQueueErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateGameSessionQueueErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateGameSessionQueueErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateGameSessionQueueErrorKind::TaggingFailedException(_inner) => Some(_inner),
            CreateGameSessionQueueErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateGameSessionQueueErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateMatchmakingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateMatchmakingConfigurationError {
    /// Kind of error that occurred.
    pub kind: CreateMatchmakingConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateMatchmakingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateMatchmakingConfigurationErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested operation would cause the resource to exceed the allowed service limit. Resolve the issue before retrying.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying. </p>
    TaggingFailedException(crate::error::TaggingFailedException),
    /// <p>The requested operation is not supported in the Region specified.</p>
    UnsupportedRegionException(crate::error::UnsupportedRegionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateMatchmakingConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateMatchmakingConfigurationErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            CreateMatchmakingConfigurationErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            CreateMatchmakingConfigurationErrorKind::LimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateMatchmakingConfigurationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateMatchmakingConfigurationErrorKind::TaggingFailedException(_inner) => {
                _inner.fmt(f)
            }
            CreateMatchmakingConfigurationErrorKind::UnsupportedRegionException(_inner) => {
                _inner.fmt(f)
            }
            CreateMatchmakingConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateMatchmakingConfigurationError {
    fn code(&self) -> Option<&str> {
        CreateMatchmakingConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateMatchmakingConfigurationError {
    /// Creates a new `CreateMatchmakingConfigurationError`.
    pub fn new(
        kind: CreateMatchmakingConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateMatchmakingConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateMatchmakingConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateMatchmakingConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateMatchmakingConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateMatchmakingConfigurationErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMatchmakingConfigurationErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMatchmakingConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMatchmakingConfigurationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMatchmakingConfigurationErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMatchmakingConfigurationErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMatchmakingConfigurationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMatchmakingConfigurationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMatchmakingConfigurationErrorKind::TaggingFailedException`.
    pub fn is_tagging_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMatchmakingConfigurationErrorKind::TaggingFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMatchmakingConfigurationErrorKind::UnsupportedRegionException`.
    pub fn is_unsupported_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMatchmakingConfigurationErrorKind::UnsupportedRegionException(_)
        )
    }
}
impl std::error::Error for CreateMatchmakingConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateMatchmakingConfigurationErrorKind::InternalServiceException(_inner) => {
                Some(_inner)
            }
            CreateMatchmakingConfigurationErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            CreateMatchmakingConfigurationErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateMatchmakingConfigurationErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateMatchmakingConfigurationErrorKind::TaggingFailedException(_inner) => Some(_inner),
            CreateMatchmakingConfigurationErrorKind::UnsupportedRegionException(_inner) => {
                Some(_inner)
            }
            CreateMatchmakingConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateMatchmakingRuleSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateMatchmakingRuleSetError {
    /// Kind of error that occurred.
    pub kind: CreateMatchmakingRuleSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateMatchmakingRuleSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateMatchmakingRuleSetErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p> The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying. </p>
    TaggingFailedException(crate::error::TaggingFailedException),
    /// <p>The requested operation is not supported in the Region specified.</p>
    UnsupportedRegionException(crate::error::UnsupportedRegionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateMatchmakingRuleSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateMatchmakingRuleSetErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateMatchmakingRuleSetErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateMatchmakingRuleSetErrorKind::TaggingFailedException(_inner) => _inner.fmt(f),
            CreateMatchmakingRuleSetErrorKind::UnsupportedRegionException(_inner) => _inner.fmt(f),
            CreateMatchmakingRuleSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateMatchmakingRuleSetError {
    fn code(&self) -> Option<&str> {
        CreateMatchmakingRuleSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateMatchmakingRuleSetError {
    /// Creates a new `CreateMatchmakingRuleSetError`.
    pub fn new(kind: CreateMatchmakingRuleSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateMatchmakingRuleSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateMatchmakingRuleSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateMatchmakingRuleSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateMatchmakingRuleSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateMatchmakingRuleSetErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMatchmakingRuleSetErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMatchmakingRuleSetErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMatchmakingRuleSetErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMatchmakingRuleSetErrorKind::TaggingFailedException`.
    pub fn is_tagging_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMatchmakingRuleSetErrorKind::TaggingFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMatchmakingRuleSetErrorKind::UnsupportedRegionException`.
    pub fn is_unsupported_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMatchmakingRuleSetErrorKind::UnsupportedRegionException(_)
        )
    }
}
impl std::error::Error for CreateMatchmakingRuleSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateMatchmakingRuleSetErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateMatchmakingRuleSetErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateMatchmakingRuleSetErrorKind::TaggingFailedException(_inner) => Some(_inner),
            CreateMatchmakingRuleSetErrorKind::UnsupportedRegionException(_inner) => Some(_inner),
            CreateMatchmakingRuleSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePlayerSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePlayerSessionError {
    /// Kind of error that occurred.
    pub kind: CreatePlayerSessionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePlayerSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePlayerSessionErrorKind {
    /// <p>The game instance is currently full and cannot allow the requested player(s) to join. Clients can retry such requests immediately or after a waiting period.</p>
    GameSessionFullException(crate::error::GameSessionFullException),
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The requested operation would cause a conflict with the current state of a resource associated with the request and/or the game instance. Resolve the conflict before retrying.</p>
    InvalidGameSessionStatusException(crate::error::InvalidGameSessionStatusException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service is unable to resolve the routing for a particular alias because it has a terminal <code>RoutingStrategy</code> associated with it. The message returned in this exception is the message defined in the routing strategy itself. Such requests should only be retried if the routing strategy for the specified alias is modified. </p>
    TerminalRoutingStrategyException(crate::error::TerminalRoutingStrategyException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePlayerSessionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePlayerSessionErrorKind::GameSessionFullException(_inner) => _inner.fmt(f),
            CreatePlayerSessionErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreatePlayerSessionErrorKind::InvalidGameSessionStatusException(_inner) => {
                _inner.fmt(f)
            }
            CreatePlayerSessionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreatePlayerSessionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreatePlayerSessionErrorKind::TerminalRoutingStrategyException(_inner) => _inner.fmt(f),
            CreatePlayerSessionErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreatePlayerSessionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePlayerSessionError {
    fn code(&self) -> Option<&str> {
        CreatePlayerSessionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePlayerSessionError {
    /// Creates a new `CreatePlayerSessionError`.
    pub fn new(kind: CreatePlayerSessionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePlayerSessionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePlayerSessionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePlayerSessionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePlayerSessionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePlayerSessionErrorKind::GameSessionFullException`.
    pub fn is_game_session_full_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePlayerSessionErrorKind::GameSessionFullException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePlayerSessionErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePlayerSessionErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePlayerSessionErrorKind::InvalidGameSessionStatusException`.
    pub fn is_invalid_game_session_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePlayerSessionErrorKind::InvalidGameSessionStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePlayerSessionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePlayerSessionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePlayerSessionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePlayerSessionErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePlayerSessionErrorKind::TerminalRoutingStrategyException`.
    pub fn is_terminal_routing_strategy_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePlayerSessionErrorKind::TerminalRoutingStrategyException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePlayerSessionErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePlayerSessionErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreatePlayerSessionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePlayerSessionErrorKind::GameSessionFullException(_inner) => Some(_inner),
            CreatePlayerSessionErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreatePlayerSessionErrorKind::InvalidGameSessionStatusException(_inner) => Some(_inner),
            CreatePlayerSessionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreatePlayerSessionErrorKind::NotFoundException(_inner) => Some(_inner),
            CreatePlayerSessionErrorKind::TerminalRoutingStrategyException(_inner) => Some(_inner),
            CreatePlayerSessionErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreatePlayerSessionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePlayerSessions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePlayerSessionsError {
    /// Kind of error that occurred.
    pub kind: CreatePlayerSessionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePlayerSessions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePlayerSessionsErrorKind {
    /// <p>The game instance is currently full and cannot allow the requested player(s) to join. Clients can retry such requests immediately or after a waiting period.</p>
    GameSessionFullException(crate::error::GameSessionFullException),
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The requested operation would cause a conflict with the current state of a resource associated with the request and/or the game instance. Resolve the conflict before retrying.</p>
    InvalidGameSessionStatusException(crate::error::InvalidGameSessionStatusException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service is unable to resolve the routing for a particular alias because it has a terminal <code>RoutingStrategy</code> associated with it. The message returned in this exception is the message defined in the routing strategy itself. Such requests should only be retried if the routing strategy for the specified alias is modified. </p>
    TerminalRoutingStrategyException(crate::error::TerminalRoutingStrategyException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePlayerSessionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePlayerSessionsErrorKind::GameSessionFullException(_inner) => _inner.fmt(f),
            CreatePlayerSessionsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreatePlayerSessionsErrorKind::InvalidGameSessionStatusException(_inner) => {
                _inner.fmt(f)
            }
            CreatePlayerSessionsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreatePlayerSessionsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreatePlayerSessionsErrorKind::TerminalRoutingStrategyException(_inner) => {
                _inner.fmt(f)
            }
            CreatePlayerSessionsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreatePlayerSessionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePlayerSessionsError {
    fn code(&self) -> Option<&str> {
        CreatePlayerSessionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePlayerSessionsError {
    /// Creates a new `CreatePlayerSessionsError`.
    pub fn new(kind: CreatePlayerSessionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePlayerSessionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePlayerSessionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePlayerSessionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePlayerSessionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePlayerSessionsErrorKind::GameSessionFullException`.
    pub fn is_game_session_full_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePlayerSessionsErrorKind::GameSessionFullException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePlayerSessionsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePlayerSessionsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePlayerSessionsErrorKind::InvalidGameSessionStatusException`.
    pub fn is_invalid_game_session_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePlayerSessionsErrorKind::InvalidGameSessionStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePlayerSessionsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePlayerSessionsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePlayerSessionsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePlayerSessionsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePlayerSessionsErrorKind::TerminalRoutingStrategyException`.
    pub fn is_terminal_routing_strategy_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePlayerSessionsErrorKind::TerminalRoutingStrategyException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePlayerSessionsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePlayerSessionsErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreatePlayerSessionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePlayerSessionsErrorKind::GameSessionFullException(_inner) => Some(_inner),
            CreatePlayerSessionsErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreatePlayerSessionsErrorKind::InvalidGameSessionStatusException(_inner) => {
                Some(_inner)
            }
            CreatePlayerSessionsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreatePlayerSessionsErrorKind::NotFoundException(_inner) => Some(_inner),
            CreatePlayerSessionsErrorKind::TerminalRoutingStrategyException(_inner) => Some(_inner),
            CreatePlayerSessionsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreatePlayerSessionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateScript` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateScriptError {
    /// Kind of error that occurred.
    pub kind: CreateScriptErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateScript` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateScriptErrorKind {
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p> The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying. </p>
    TaggingFailedException(crate::error::TaggingFailedException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateScriptError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateScriptErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateScriptErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateScriptErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateScriptErrorKind::TaggingFailedException(_inner) => _inner.fmt(f),
            CreateScriptErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateScriptErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateScriptError {
    fn code(&self) -> Option<&str> {
        CreateScriptError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateScriptError {
    /// Creates a new `CreateScriptError`.
    pub fn new(kind: CreateScriptErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateScriptError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateScriptErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateScriptError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateScriptErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateScriptErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateScriptErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateScriptErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateScriptErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateScriptErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateScriptErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateScriptErrorKind::TaggingFailedException`.
    pub fn is_tagging_failed_exception(&self) -> bool {
        matches!(&self.kind, CreateScriptErrorKind::TaggingFailedException(_))
    }
    /// Returns `true` if the error kind is `CreateScriptErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, CreateScriptErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for CreateScriptError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateScriptErrorKind::ConflictException(_inner) => Some(_inner),
            CreateScriptErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateScriptErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateScriptErrorKind::TaggingFailedException(_inner) => Some(_inner),
            CreateScriptErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateScriptErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateVpcPeeringAuthorization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateVpcPeeringAuthorizationError {
    /// Kind of error that occurred.
    pub kind: CreateVpcPeeringAuthorizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateVpcPeeringAuthorization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateVpcPeeringAuthorizationErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateVpcPeeringAuthorizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateVpcPeeringAuthorizationErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            CreateVpcPeeringAuthorizationErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            CreateVpcPeeringAuthorizationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateVpcPeeringAuthorizationErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateVpcPeeringAuthorizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateVpcPeeringAuthorizationError {
    fn code(&self) -> Option<&str> {
        CreateVpcPeeringAuthorizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateVpcPeeringAuthorizationError {
    /// Creates a new `CreateVpcPeeringAuthorizationError`.
    pub fn new(
        kind: CreateVpcPeeringAuthorizationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateVpcPeeringAuthorizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateVpcPeeringAuthorizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateVpcPeeringAuthorizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateVpcPeeringAuthorizationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateVpcPeeringAuthorizationErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVpcPeeringAuthorizationErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVpcPeeringAuthorizationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVpcPeeringAuthorizationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVpcPeeringAuthorizationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVpcPeeringAuthorizationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVpcPeeringAuthorizationErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVpcPeeringAuthorizationErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateVpcPeeringAuthorizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateVpcPeeringAuthorizationErrorKind::InternalServiceException(_inner) => {
                Some(_inner)
            }
            CreateVpcPeeringAuthorizationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateVpcPeeringAuthorizationErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateVpcPeeringAuthorizationErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateVpcPeeringAuthorizationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateVpcPeeringConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateVpcPeeringConnectionError {
    /// Kind of error that occurred.
    pub kind: CreateVpcPeeringConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateVpcPeeringConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateVpcPeeringConnectionErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateVpcPeeringConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateVpcPeeringConnectionErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateVpcPeeringConnectionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateVpcPeeringConnectionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateVpcPeeringConnectionErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateVpcPeeringConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateVpcPeeringConnectionError {
    fn code(&self) -> Option<&str> {
        CreateVpcPeeringConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateVpcPeeringConnectionError {
    /// Creates a new `CreateVpcPeeringConnectionError`.
    pub fn new(kind: CreateVpcPeeringConnectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateVpcPeeringConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateVpcPeeringConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateVpcPeeringConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateVpcPeeringConnectionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateVpcPeeringConnectionErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVpcPeeringConnectionErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVpcPeeringConnectionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVpcPeeringConnectionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVpcPeeringConnectionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVpcPeeringConnectionErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVpcPeeringConnectionErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVpcPeeringConnectionErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateVpcPeeringConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateVpcPeeringConnectionErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateVpcPeeringConnectionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateVpcPeeringConnectionErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateVpcPeeringConnectionErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateVpcPeeringConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAliasError {
    /// Kind of error that occurred.
    pub kind: DeleteAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAliasErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying. </p>
    TaggingFailedException(crate::error::TaggingFailedException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAliasErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteAliasErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteAliasErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteAliasErrorKind::TaggingFailedException(_inner) => _inner.fmt(f),
            DeleteAliasErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAliasError {
    fn code(&self) -> Option<&str> {
        DeleteAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAliasError {
    /// Creates a new `DeleteAliasError`.
    pub fn new(kind: DeleteAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAliasErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAliasErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAliasErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAliasErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteAliasErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteAliasErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteAliasErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteAliasErrorKind::TaggingFailedException`.
    pub fn is_tagging_failed_exception(&self) -> bool {
        matches!(&self.kind, DeleteAliasErrorKind::TaggingFailedException(_))
    }
    /// Returns `true` if the error kind is `DeleteAliasErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, DeleteAliasErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for DeleteAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAliasErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteAliasErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteAliasErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteAliasErrorKind::TaggingFailedException(_inner) => Some(_inner),
            DeleteAliasErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBuild` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBuildError {
    /// Kind of error that occurred.
    pub kind: DeleteBuildErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBuild` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBuildErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying. </p>
    TaggingFailedException(crate::error::TaggingFailedException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBuildError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBuildErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteBuildErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteBuildErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteBuildErrorKind::TaggingFailedException(_inner) => _inner.fmt(f),
            DeleteBuildErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteBuildErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBuildError {
    fn code(&self) -> Option<&str> {
        DeleteBuildError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBuildError {
    /// Creates a new `DeleteBuildError`.
    pub fn new(kind: DeleteBuildErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBuildError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBuildErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBuildError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBuildErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBuildErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBuildErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBuildErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteBuildErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteBuildErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteBuildErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteBuildErrorKind::TaggingFailedException`.
    pub fn is_tagging_failed_exception(&self) -> bool {
        matches!(&self.kind, DeleteBuildErrorKind::TaggingFailedException(_))
    }
    /// Returns `true` if the error kind is `DeleteBuildErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, DeleteBuildErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for DeleteBuildError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBuildErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteBuildErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteBuildErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteBuildErrorKind::TaggingFailedException(_inner) => Some(_inner),
            DeleteBuildErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteBuildErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFleet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFleetError {
    /// Kind of error that occurred.
    pub kind: DeleteFleetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFleet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFleetErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The requested operation would cause a conflict with the current state of a resource associated with the request and/or the fleet. Resolve the conflict before retrying.</p>
    InvalidFleetStatusException(crate::error::InvalidFleetStatusException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying. </p>
    TaggingFailedException(crate::error::TaggingFailedException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFleetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFleetErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteFleetErrorKind::InvalidFleetStatusException(_inner) => _inner.fmt(f),
            DeleteFleetErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteFleetErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteFleetErrorKind::TaggingFailedException(_inner) => _inner.fmt(f),
            DeleteFleetErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteFleetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFleetError {
    fn code(&self) -> Option<&str> {
        DeleteFleetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFleetError {
    /// Creates a new `DeleteFleetError`.
    pub fn new(kind: DeleteFleetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFleetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFleetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFleetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFleetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteFleetErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFleetErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFleetErrorKind::InvalidFleetStatusException`.
    pub fn is_invalid_fleet_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFleetErrorKind::InvalidFleetStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFleetErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteFleetErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteFleetErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteFleetErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteFleetErrorKind::TaggingFailedException`.
    pub fn is_tagging_failed_exception(&self) -> bool {
        matches!(&self.kind, DeleteFleetErrorKind::TaggingFailedException(_))
    }
    /// Returns `true` if the error kind is `DeleteFleetErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, DeleteFleetErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for DeleteFleetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFleetErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteFleetErrorKind::InvalidFleetStatusException(_inner) => Some(_inner),
            DeleteFleetErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteFleetErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteFleetErrorKind::TaggingFailedException(_inner) => Some(_inner),
            DeleteFleetErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteFleetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFleetLocations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFleetLocationsError {
    /// Kind of error that occurred.
    pub kind: DeleteFleetLocationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFleetLocations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFleetLocationsErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// <p>The requested operation is not supported in the Region specified.</p>
    UnsupportedRegionException(crate::error::UnsupportedRegionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFleetLocationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFleetLocationsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteFleetLocationsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteFleetLocationsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteFleetLocationsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteFleetLocationsErrorKind::UnsupportedRegionException(_inner) => _inner.fmt(f),
            DeleteFleetLocationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFleetLocationsError {
    fn code(&self) -> Option<&str> {
        DeleteFleetLocationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFleetLocationsError {
    /// Creates a new `DeleteFleetLocationsError`.
    pub fn new(kind: DeleteFleetLocationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFleetLocationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFleetLocationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFleetLocationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFleetLocationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteFleetLocationsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFleetLocationsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFleetLocationsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFleetLocationsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFleetLocationsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFleetLocationsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFleetLocationsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFleetLocationsErrorKind::UnauthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFleetLocationsErrorKind::UnsupportedRegionException`.
    pub fn is_unsupported_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFleetLocationsErrorKind::UnsupportedRegionException(_)
        )
    }
}
impl std::error::Error for DeleteFleetLocationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFleetLocationsErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteFleetLocationsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteFleetLocationsErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteFleetLocationsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteFleetLocationsErrorKind::UnsupportedRegionException(_inner) => Some(_inner),
            DeleteFleetLocationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteGameServerGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteGameServerGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteGameServerGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteGameServerGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteGameServerGroupErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteGameServerGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteGameServerGroupErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteGameServerGroupErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteGameServerGroupErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteGameServerGroupErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteGameServerGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteGameServerGroupError {
    fn code(&self) -> Option<&str> {
        DeleteGameServerGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteGameServerGroupError {
    /// Creates a new `DeleteGameServerGroupError`.
    pub fn new(kind: DeleteGameServerGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteGameServerGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteGameServerGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteGameServerGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteGameServerGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteGameServerGroupErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGameServerGroupErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGameServerGroupErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGameServerGroupErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGameServerGroupErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGameServerGroupErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGameServerGroupErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGameServerGroupErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteGameServerGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteGameServerGroupErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteGameServerGroupErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteGameServerGroupErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteGameServerGroupErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteGameServerGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteGameSessionQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteGameSessionQueueError {
    /// Kind of error that occurred.
    pub kind: DeleteGameSessionQueueErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteGameSessionQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteGameSessionQueueErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying. </p>
    TaggingFailedException(crate::error::TaggingFailedException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteGameSessionQueueError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteGameSessionQueueErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteGameSessionQueueErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteGameSessionQueueErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteGameSessionQueueErrorKind::TaggingFailedException(_inner) => _inner.fmt(f),
            DeleteGameSessionQueueErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteGameSessionQueueErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteGameSessionQueueError {
    fn code(&self) -> Option<&str> {
        DeleteGameSessionQueueError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteGameSessionQueueError {
    /// Creates a new `DeleteGameSessionQueueError`.
    pub fn new(kind: DeleteGameSessionQueueErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteGameSessionQueueError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteGameSessionQueueErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteGameSessionQueueError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteGameSessionQueueErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteGameSessionQueueErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGameSessionQueueErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGameSessionQueueErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGameSessionQueueErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGameSessionQueueErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGameSessionQueueErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGameSessionQueueErrorKind::TaggingFailedException`.
    pub fn is_tagging_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGameSessionQueueErrorKind::TaggingFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGameSessionQueueErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGameSessionQueueErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteGameSessionQueueError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteGameSessionQueueErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteGameSessionQueueErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteGameSessionQueueErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteGameSessionQueueErrorKind::TaggingFailedException(_inner) => Some(_inner),
            DeleteGameSessionQueueErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteGameSessionQueueErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteMatchmakingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteMatchmakingConfigurationError {
    /// Kind of error that occurred.
    pub kind: DeleteMatchmakingConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteMatchmakingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteMatchmakingConfigurationErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying. </p>
    TaggingFailedException(crate::error::TaggingFailedException),
    /// <p>The requested operation is not supported in the Region specified.</p>
    UnsupportedRegionException(crate::error::UnsupportedRegionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteMatchmakingConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteMatchmakingConfigurationErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            DeleteMatchmakingConfigurationErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DeleteMatchmakingConfigurationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteMatchmakingConfigurationErrorKind::TaggingFailedException(_inner) => {
                _inner.fmt(f)
            }
            DeleteMatchmakingConfigurationErrorKind::UnsupportedRegionException(_inner) => {
                _inner.fmt(f)
            }
            DeleteMatchmakingConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteMatchmakingConfigurationError {
    fn code(&self) -> Option<&str> {
        DeleteMatchmakingConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteMatchmakingConfigurationError {
    /// Creates a new `DeleteMatchmakingConfigurationError`.
    pub fn new(
        kind: DeleteMatchmakingConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteMatchmakingConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteMatchmakingConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteMatchmakingConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteMatchmakingConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteMatchmakingConfigurationErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMatchmakingConfigurationErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMatchmakingConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMatchmakingConfigurationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMatchmakingConfigurationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMatchmakingConfigurationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMatchmakingConfigurationErrorKind::TaggingFailedException`.
    pub fn is_tagging_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMatchmakingConfigurationErrorKind::TaggingFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMatchmakingConfigurationErrorKind::UnsupportedRegionException`.
    pub fn is_unsupported_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMatchmakingConfigurationErrorKind::UnsupportedRegionException(_)
        )
    }
}
impl std::error::Error for DeleteMatchmakingConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteMatchmakingConfigurationErrorKind::InternalServiceException(_inner) => {
                Some(_inner)
            }
            DeleteMatchmakingConfigurationErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            DeleteMatchmakingConfigurationErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteMatchmakingConfigurationErrorKind::TaggingFailedException(_inner) => Some(_inner),
            DeleteMatchmakingConfigurationErrorKind::UnsupportedRegionException(_inner) => {
                Some(_inner)
            }
            DeleteMatchmakingConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteMatchmakingRuleSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteMatchmakingRuleSetError {
    /// Kind of error that occurred.
    pub kind: DeleteMatchmakingRuleSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteMatchmakingRuleSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteMatchmakingRuleSetErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying. </p>
    TaggingFailedException(crate::error::TaggingFailedException),
    /// <p>The requested operation is not supported in the Region specified.</p>
    UnsupportedRegionException(crate::error::UnsupportedRegionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteMatchmakingRuleSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteMatchmakingRuleSetErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteMatchmakingRuleSetErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteMatchmakingRuleSetErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteMatchmakingRuleSetErrorKind::TaggingFailedException(_inner) => _inner.fmt(f),
            DeleteMatchmakingRuleSetErrorKind::UnsupportedRegionException(_inner) => _inner.fmt(f),
            DeleteMatchmakingRuleSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteMatchmakingRuleSetError {
    fn code(&self) -> Option<&str> {
        DeleteMatchmakingRuleSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteMatchmakingRuleSetError {
    /// Creates a new `DeleteMatchmakingRuleSetError`.
    pub fn new(kind: DeleteMatchmakingRuleSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteMatchmakingRuleSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteMatchmakingRuleSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteMatchmakingRuleSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteMatchmakingRuleSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteMatchmakingRuleSetErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMatchmakingRuleSetErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMatchmakingRuleSetErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMatchmakingRuleSetErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMatchmakingRuleSetErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMatchmakingRuleSetErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMatchmakingRuleSetErrorKind::TaggingFailedException`.
    pub fn is_tagging_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMatchmakingRuleSetErrorKind::TaggingFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMatchmakingRuleSetErrorKind::UnsupportedRegionException`.
    pub fn is_unsupported_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMatchmakingRuleSetErrorKind::UnsupportedRegionException(_)
        )
    }
}
impl std::error::Error for DeleteMatchmakingRuleSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteMatchmakingRuleSetErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteMatchmakingRuleSetErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteMatchmakingRuleSetErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteMatchmakingRuleSetErrorKind::TaggingFailedException(_inner) => Some(_inner),
            DeleteMatchmakingRuleSetErrorKind::UnsupportedRegionException(_inner) => Some(_inner),
            DeleteMatchmakingRuleSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteScalingPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteScalingPolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteScalingPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteScalingPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteScalingPolicyErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteScalingPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteScalingPolicyErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteScalingPolicyErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteScalingPolicyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteScalingPolicyErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteScalingPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteScalingPolicyError {
    fn code(&self) -> Option<&str> {
        DeleteScalingPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteScalingPolicyError {
    /// Creates a new `DeleteScalingPolicyError`.
    pub fn new(kind: DeleteScalingPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteScalingPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteScalingPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteScalingPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteScalingPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteScalingPolicyErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteScalingPolicyErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteScalingPolicyErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteScalingPolicyErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteScalingPolicyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteScalingPolicyErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteScalingPolicyErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteScalingPolicyErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteScalingPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteScalingPolicyErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteScalingPolicyErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteScalingPolicyErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteScalingPolicyErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteScalingPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteScript` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteScriptError {
    /// Kind of error that occurred.
    pub kind: DeleteScriptErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteScript` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteScriptErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying. </p>
    TaggingFailedException(crate::error::TaggingFailedException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteScriptError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteScriptErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteScriptErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteScriptErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteScriptErrorKind::TaggingFailedException(_inner) => _inner.fmt(f),
            DeleteScriptErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteScriptErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteScriptError {
    fn code(&self) -> Option<&str> {
        DeleteScriptError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteScriptError {
    /// Creates a new `DeleteScriptError`.
    pub fn new(kind: DeleteScriptErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteScriptError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteScriptErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteScriptError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteScriptErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteScriptErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteScriptErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteScriptErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteScriptErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteScriptErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteScriptErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteScriptErrorKind::TaggingFailedException`.
    pub fn is_tagging_failed_exception(&self) -> bool {
        matches!(&self.kind, DeleteScriptErrorKind::TaggingFailedException(_))
    }
    /// Returns `true` if the error kind is `DeleteScriptErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, DeleteScriptErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for DeleteScriptError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteScriptErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteScriptErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteScriptErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteScriptErrorKind::TaggingFailedException(_inner) => Some(_inner),
            DeleteScriptErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteScriptErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteVpcPeeringAuthorization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteVpcPeeringAuthorizationError {
    /// Kind of error that occurred.
    pub kind: DeleteVpcPeeringAuthorizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteVpcPeeringAuthorization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteVpcPeeringAuthorizationErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteVpcPeeringAuthorizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteVpcPeeringAuthorizationErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            DeleteVpcPeeringAuthorizationErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DeleteVpcPeeringAuthorizationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteVpcPeeringAuthorizationErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteVpcPeeringAuthorizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteVpcPeeringAuthorizationError {
    fn code(&self) -> Option<&str> {
        DeleteVpcPeeringAuthorizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteVpcPeeringAuthorizationError {
    /// Creates a new `DeleteVpcPeeringAuthorizationError`.
    pub fn new(
        kind: DeleteVpcPeeringAuthorizationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteVpcPeeringAuthorizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteVpcPeeringAuthorizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteVpcPeeringAuthorizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteVpcPeeringAuthorizationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteVpcPeeringAuthorizationErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVpcPeeringAuthorizationErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVpcPeeringAuthorizationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVpcPeeringAuthorizationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVpcPeeringAuthorizationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVpcPeeringAuthorizationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVpcPeeringAuthorizationErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVpcPeeringAuthorizationErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteVpcPeeringAuthorizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteVpcPeeringAuthorizationErrorKind::InternalServiceException(_inner) => {
                Some(_inner)
            }
            DeleteVpcPeeringAuthorizationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteVpcPeeringAuthorizationErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteVpcPeeringAuthorizationErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteVpcPeeringAuthorizationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteVpcPeeringConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteVpcPeeringConnectionError {
    /// Kind of error that occurred.
    pub kind: DeleteVpcPeeringConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteVpcPeeringConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteVpcPeeringConnectionErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteVpcPeeringConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteVpcPeeringConnectionErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteVpcPeeringConnectionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteVpcPeeringConnectionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteVpcPeeringConnectionErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteVpcPeeringConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteVpcPeeringConnectionError {
    fn code(&self) -> Option<&str> {
        DeleteVpcPeeringConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteVpcPeeringConnectionError {
    /// Creates a new `DeleteVpcPeeringConnectionError`.
    pub fn new(kind: DeleteVpcPeeringConnectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteVpcPeeringConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteVpcPeeringConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteVpcPeeringConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteVpcPeeringConnectionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteVpcPeeringConnectionErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVpcPeeringConnectionErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVpcPeeringConnectionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVpcPeeringConnectionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVpcPeeringConnectionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVpcPeeringConnectionErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVpcPeeringConnectionErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVpcPeeringConnectionErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteVpcPeeringConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteVpcPeeringConnectionErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteVpcPeeringConnectionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteVpcPeeringConnectionErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteVpcPeeringConnectionErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteVpcPeeringConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeregisterGameServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeregisterGameServerError {
    /// Kind of error that occurred.
    pub kind: DeregisterGameServerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeregisterGameServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeregisterGameServerErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeregisterGameServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeregisterGameServerErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeregisterGameServerErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeregisterGameServerErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeregisterGameServerErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeregisterGameServerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeregisterGameServerError {
    fn code(&self) -> Option<&str> {
        DeregisterGameServerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeregisterGameServerError {
    /// Creates a new `DeregisterGameServerError`.
    pub fn new(kind: DeregisterGameServerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeregisterGameServerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeregisterGameServerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeregisterGameServerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeregisterGameServerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeregisterGameServerErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterGameServerErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterGameServerErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterGameServerErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterGameServerErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterGameServerErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterGameServerErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterGameServerErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeregisterGameServerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeregisterGameServerErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeregisterGameServerErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeregisterGameServerErrorKind::NotFoundException(_inner) => Some(_inner),
            DeregisterGameServerErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeregisterGameServerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAliasError {
    /// Kind of error that occurred.
    pub kind: DescribeAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAliasErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAliasErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeAliasErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeAliasErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeAliasErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAliasError {
    fn code(&self) -> Option<&str> {
        DescribeAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAliasError {
    /// Creates a new `DescribeAliasError`.
    pub fn new(kind: DescribeAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAliasErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAliasErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAliasErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAliasErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAliasErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAliasErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DescribeAliasErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DescribeAliasErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, DescribeAliasErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for DescribeAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAliasErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeAliasErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeAliasErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeAliasErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeBuild` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeBuildError {
    /// Kind of error that occurred.
    pub kind: DescribeBuildErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeBuild` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeBuildErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeBuildError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeBuildErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeBuildErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeBuildErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeBuildErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeBuildErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeBuildError {
    fn code(&self) -> Option<&str> {
        DescribeBuildError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeBuildError {
    /// Creates a new `DescribeBuildError`.
    pub fn new(kind: DescribeBuildErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeBuildError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeBuildErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeBuildError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeBuildErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeBuildErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBuildErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBuildErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBuildErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBuildErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DescribeBuildErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DescribeBuildErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, DescribeBuildErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for DescribeBuildError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeBuildErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeBuildErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeBuildErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeBuildErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeBuildErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEC2InstanceLimits` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEC2InstanceLimitsError {
    /// Kind of error that occurred.
    pub kind: DescribeEC2InstanceLimitsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEC2InstanceLimits` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEC2InstanceLimitsErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// <p>The requested operation is not supported in the Region specified.</p>
    UnsupportedRegionException(crate::error::UnsupportedRegionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEC2InstanceLimitsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEC2InstanceLimitsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeEC2InstanceLimitsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeEC2InstanceLimitsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeEC2InstanceLimitsErrorKind::UnsupportedRegionException(_inner) => _inner.fmt(f),
            DescribeEC2InstanceLimitsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEC2InstanceLimitsError {
    fn code(&self) -> Option<&str> {
        DescribeEC2InstanceLimitsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEC2InstanceLimitsError {
    /// Creates a new `DescribeEC2InstanceLimitsError`.
    pub fn new(kind: DescribeEC2InstanceLimitsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEC2InstanceLimitsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEC2InstanceLimitsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEC2InstanceLimitsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEC2InstanceLimitsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeEC2InstanceLimitsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEC2InstanceLimitsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEC2InstanceLimitsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEC2InstanceLimitsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEC2InstanceLimitsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEC2InstanceLimitsErrorKind::UnauthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEC2InstanceLimitsErrorKind::UnsupportedRegionException`.
    pub fn is_unsupported_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEC2InstanceLimitsErrorKind::UnsupportedRegionException(_)
        )
    }
}
impl std::error::Error for DescribeEC2InstanceLimitsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEC2InstanceLimitsErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeEC2InstanceLimitsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeEC2InstanceLimitsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeEC2InstanceLimitsErrorKind::UnsupportedRegionException(_inner) => Some(_inner),
            DescribeEC2InstanceLimitsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFleetAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFleetAttributesError {
    /// Kind of error that occurred.
    pub kind: DescribeFleetAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFleetAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFleetAttributesErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFleetAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFleetAttributesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeFleetAttributesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeFleetAttributesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeFleetAttributesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeFleetAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFleetAttributesError {
    fn code(&self) -> Option<&str> {
        DescribeFleetAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFleetAttributesError {
    /// Creates a new `DescribeFleetAttributesError`.
    pub fn new(kind: DescribeFleetAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFleetAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFleetAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFleetAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFleetAttributesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeFleetAttributesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetAttributesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetAttributesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetAttributesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetAttributesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetAttributesErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetAttributesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetAttributesErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeFleetAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFleetAttributesErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeFleetAttributesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeFleetAttributesErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeFleetAttributesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeFleetAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFleetCapacity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFleetCapacityError {
    /// Kind of error that occurred.
    pub kind: DescribeFleetCapacityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFleetCapacity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFleetCapacityErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFleetCapacityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFleetCapacityErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeFleetCapacityErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeFleetCapacityErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeFleetCapacityErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeFleetCapacityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFleetCapacityError {
    fn code(&self) -> Option<&str> {
        DescribeFleetCapacityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFleetCapacityError {
    /// Creates a new `DescribeFleetCapacityError`.
    pub fn new(kind: DescribeFleetCapacityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFleetCapacityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFleetCapacityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFleetCapacityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFleetCapacityErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeFleetCapacityErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetCapacityErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetCapacityErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetCapacityErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetCapacityErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetCapacityErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetCapacityErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetCapacityErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeFleetCapacityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFleetCapacityErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeFleetCapacityErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeFleetCapacityErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeFleetCapacityErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeFleetCapacityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFleetEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFleetEventsError {
    /// Kind of error that occurred.
    pub kind: DescribeFleetEventsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFleetEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFleetEventsErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFleetEventsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFleetEventsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeFleetEventsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeFleetEventsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeFleetEventsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeFleetEventsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFleetEventsError {
    fn code(&self) -> Option<&str> {
        DescribeFleetEventsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFleetEventsError {
    /// Creates a new `DescribeFleetEventsError`.
    pub fn new(kind: DescribeFleetEventsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFleetEventsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFleetEventsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFleetEventsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFleetEventsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeFleetEventsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetEventsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetEventsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetEventsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetEventsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetEventsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetEventsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetEventsErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeFleetEventsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFleetEventsErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeFleetEventsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeFleetEventsErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeFleetEventsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeFleetEventsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFleetLocationAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFleetLocationAttributesError {
    /// Kind of error that occurred.
    pub kind: DescribeFleetLocationAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFleetLocationAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFleetLocationAttributesErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// <p>The requested operation is not supported in the Region specified.</p>
    UnsupportedRegionException(crate::error::UnsupportedRegionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFleetLocationAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFleetLocationAttributesErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            DescribeFleetLocationAttributesErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeFleetLocationAttributesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeFleetLocationAttributesErrorKind::UnauthorizedException(_inner) => {
                _inner.fmt(f)
            }
            DescribeFleetLocationAttributesErrorKind::UnsupportedRegionException(_inner) => {
                _inner.fmt(f)
            }
            DescribeFleetLocationAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFleetLocationAttributesError {
    fn code(&self) -> Option<&str> {
        DescribeFleetLocationAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFleetLocationAttributesError {
    /// Creates a new `DescribeFleetLocationAttributesError`.
    pub fn new(
        kind: DescribeFleetLocationAttributesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFleetLocationAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFleetLocationAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFleetLocationAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFleetLocationAttributesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeFleetLocationAttributesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetLocationAttributesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetLocationAttributesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetLocationAttributesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetLocationAttributesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetLocationAttributesErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetLocationAttributesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetLocationAttributesErrorKind::UnauthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetLocationAttributesErrorKind::UnsupportedRegionException`.
    pub fn is_unsupported_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetLocationAttributesErrorKind::UnsupportedRegionException(_)
        )
    }
}
impl std::error::Error for DescribeFleetLocationAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFleetLocationAttributesErrorKind::InternalServiceException(_inner) => {
                Some(_inner)
            }
            DescribeFleetLocationAttributesErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            DescribeFleetLocationAttributesErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeFleetLocationAttributesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeFleetLocationAttributesErrorKind::UnsupportedRegionException(_inner) => {
                Some(_inner)
            }
            DescribeFleetLocationAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFleetLocationCapacity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFleetLocationCapacityError {
    /// Kind of error that occurred.
    pub kind: DescribeFleetLocationCapacityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFleetLocationCapacity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFleetLocationCapacityErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// <p>The requested operation is not supported in the Region specified.</p>
    UnsupportedRegionException(crate::error::UnsupportedRegionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFleetLocationCapacityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFleetLocationCapacityErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            DescribeFleetLocationCapacityErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeFleetLocationCapacityErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeFleetLocationCapacityErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeFleetLocationCapacityErrorKind::UnsupportedRegionException(_inner) => {
                _inner.fmt(f)
            }
            DescribeFleetLocationCapacityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFleetLocationCapacityError {
    fn code(&self) -> Option<&str> {
        DescribeFleetLocationCapacityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFleetLocationCapacityError {
    /// Creates a new `DescribeFleetLocationCapacityError`.
    pub fn new(
        kind: DescribeFleetLocationCapacityErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFleetLocationCapacityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFleetLocationCapacityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFleetLocationCapacityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFleetLocationCapacityErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeFleetLocationCapacityErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetLocationCapacityErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetLocationCapacityErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetLocationCapacityErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetLocationCapacityErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetLocationCapacityErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetLocationCapacityErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetLocationCapacityErrorKind::UnauthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetLocationCapacityErrorKind::UnsupportedRegionException`.
    pub fn is_unsupported_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetLocationCapacityErrorKind::UnsupportedRegionException(_)
        )
    }
}
impl std::error::Error for DescribeFleetLocationCapacityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFleetLocationCapacityErrorKind::InternalServiceException(_inner) => {
                Some(_inner)
            }
            DescribeFleetLocationCapacityErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeFleetLocationCapacityErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeFleetLocationCapacityErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeFleetLocationCapacityErrorKind::UnsupportedRegionException(_inner) => {
                Some(_inner)
            }
            DescribeFleetLocationCapacityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFleetLocationUtilization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFleetLocationUtilizationError {
    /// Kind of error that occurred.
    pub kind: DescribeFleetLocationUtilizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFleetLocationUtilization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFleetLocationUtilizationErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// <p>The requested operation is not supported in the Region specified.</p>
    UnsupportedRegionException(crate::error::UnsupportedRegionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFleetLocationUtilizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFleetLocationUtilizationErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            DescribeFleetLocationUtilizationErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeFleetLocationUtilizationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeFleetLocationUtilizationErrorKind::UnauthorizedException(_inner) => {
                _inner.fmt(f)
            }
            DescribeFleetLocationUtilizationErrorKind::UnsupportedRegionException(_inner) => {
                _inner.fmt(f)
            }
            DescribeFleetLocationUtilizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFleetLocationUtilizationError {
    fn code(&self) -> Option<&str> {
        DescribeFleetLocationUtilizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFleetLocationUtilizationError {
    /// Creates a new `DescribeFleetLocationUtilizationError`.
    pub fn new(
        kind: DescribeFleetLocationUtilizationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFleetLocationUtilizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFleetLocationUtilizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFleetLocationUtilizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFleetLocationUtilizationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeFleetLocationUtilizationErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetLocationUtilizationErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetLocationUtilizationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetLocationUtilizationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetLocationUtilizationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetLocationUtilizationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetLocationUtilizationErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetLocationUtilizationErrorKind::UnauthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetLocationUtilizationErrorKind::UnsupportedRegionException`.
    pub fn is_unsupported_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetLocationUtilizationErrorKind::UnsupportedRegionException(_)
        )
    }
}
impl std::error::Error for DescribeFleetLocationUtilizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFleetLocationUtilizationErrorKind::InternalServiceException(_inner) => {
                Some(_inner)
            }
            DescribeFleetLocationUtilizationErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            DescribeFleetLocationUtilizationErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeFleetLocationUtilizationErrorKind::UnauthorizedException(_inner) => {
                Some(_inner)
            }
            DescribeFleetLocationUtilizationErrorKind::UnsupportedRegionException(_inner) => {
                Some(_inner)
            }
            DescribeFleetLocationUtilizationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFleetPortSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFleetPortSettingsError {
    /// Kind of error that occurred.
    pub kind: DescribeFleetPortSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFleetPortSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFleetPortSettingsErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFleetPortSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFleetPortSettingsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeFleetPortSettingsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeFleetPortSettingsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeFleetPortSettingsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeFleetPortSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFleetPortSettingsError {
    fn code(&self) -> Option<&str> {
        DescribeFleetPortSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFleetPortSettingsError {
    /// Creates a new `DescribeFleetPortSettingsError`.
    pub fn new(kind: DescribeFleetPortSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFleetPortSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFleetPortSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFleetPortSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFleetPortSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeFleetPortSettingsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetPortSettingsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetPortSettingsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetPortSettingsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetPortSettingsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetPortSettingsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetPortSettingsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetPortSettingsErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeFleetPortSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFleetPortSettingsErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeFleetPortSettingsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeFleetPortSettingsErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeFleetPortSettingsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeFleetPortSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFleetUtilization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFleetUtilizationError {
    /// Kind of error that occurred.
    pub kind: DescribeFleetUtilizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFleetUtilization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFleetUtilizationErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFleetUtilizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFleetUtilizationErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeFleetUtilizationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeFleetUtilizationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeFleetUtilizationErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeFleetUtilizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFleetUtilizationError {
    fn code(&self) -> Option<&str> {
        DescribeFleetUtilizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFleetUtilizationError {
    /// Creates a new `DescribeFleetUtilizationError`.
    pub fn new(kind: DescribeFleetUtilizationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFleetUtilizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFleetUtilizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFleetUtilizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFleetUtilizationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeFleetUtilizationErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetUtilizationErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetUtilizationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetUtilizationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetUtilizationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetUtilizationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetUtilizationErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetUtilizationErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeFleetUtilizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFleetUtilizationErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeFleetUtilizationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeFleetUtilizationErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeFleetUtilizationErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeFleetUtilizationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeGameServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeGameServerError {
    /// Kind of error that occurred.
    pub kind: DescribeGameServerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeGameServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeGameServerErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeGameServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeGameServerErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeGameServerErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeGameServerErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeGameServerErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeGameServerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeGameServerError {
    fn code(&self) -> Option<&str> {
        DescribeGameServerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeGameServerError {
    /// Creates a new `DescribeGameServerError`.
    pub fn new(kind: DescribeGameServerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeGameServerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeGameServerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeGameServerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeGameServerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeGameServerErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGameServerErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGameServerErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGameServerErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGameServerErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGameServerErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGameServerErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGameServerErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeGameServerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeGameServerErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeGameServerErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeGameServerErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeGameServerErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeGameServerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeGameServerGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeGameServerGroupError {
    /// Kind of error that occurred.
    pub kind: DescribeGameServerGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeGameServerGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeGameServerGroupErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeGameServerGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeGameServerGroupErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeGameServerGroupErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeGameServerGroupErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeGameServerGroupErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeGameServerGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeGameServerGroupError {
    fn code(&self) -> Option<&str> {
        DescribeGameServerGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeGameServerGroupError {
    /// Creates a new `DescribeGameServerGroupError`.
    pub fn new(kind: DescribeGameServerGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeGameServerGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeGameServerGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeGameServerGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeGameServerGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeGameServerGroupErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGameServerGroupErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGameServerGroupErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGameServerGroupErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGameServerGroupErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGameServerGroupErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGameServerGroupErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGameServerGroupErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeGameServerGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeGameServerGroupErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeGameServerGroupErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeGameServerGroupErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeGameServerGroupErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeGameServerGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeGameServerInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeGameServerInstancesError {
    /// Kind of error that occurred.
    pub kind: DescribeGameServerInstancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeGameServerInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeGameServerInstancesErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeGameServerInstancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeGameServerInstancesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeGameServerInstancesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeGameServerInstancesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeGameServerInstancesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeGameServerInstancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeGameServerInstancesError {
    fn code(&self) -> Option<&str> {
        DescribeGameServerInstancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeGameServerInstancesError {
    /// Creates a new `DescribeGameServerInstancesError`.
    pub fn new(kind: DescribeGameServerInstancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeGameServerInstancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeGameServerInstancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeGameServerInstancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeGameServerInstancesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeGameServerInstancesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGameServerInstancesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGameServerInstancesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGameServerInstancesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGameServerInstancesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGameServerInstancesErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGameServerInstancesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGameServerInstancesErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeGameServerInstancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeGameServerInstancesErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeGameServerInstancesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeGameServerInstancesErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeGameServerInstancesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeGameServerInstancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeGameSessionDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeGameSessionDetailsError {
    /// Kind of error that occurred.
    pub kind: DescribeGameSessionDetailsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeGameSessionDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeGameSessionDetailsErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service is unable to resolve the routing for a particular alias because it has a terminal <code>RoutingStrategy</code> associated with it. The message returned in this exception is the message defined in the routing strategy itself. Such requests should only be retried if the routing strategy for the specified alias is modified. </p>
    TerminalRoutingStrategyException(crate::error::TerminalRoutingStrategyException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// <p>The requested operation is not supported in the Region specified.</p>
    UnsupportedRegionException(crate::error::UnsupportedRegionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeGameSessionDetailsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeGameSessionDetailsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeGameSessionDetailsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeGameSessionDetailsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeGameSessionDetailsErrorKind::TerminalRoutingStrategyException(_inner) => {
                _inner.fmt(f)
            }
            DescribeGameSessionDetailsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeGameSessionDetailsErrorKind::UnsupportedRegionException(_inner) => {
                _inner.fmt(f)
            }
            DescribeGameSessionDetailsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeGameSessionDetailsError {
    fn code(&self) -> Option<&str> {
        DescribeGameSessionDetailsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeGameSessionDetailsError {
    /// Creates a new `DescribeGameSessionDetailsError`.
    pub fn new(kind: DescribeGameSessionDetailsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeGameSessionDetailsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeGameSessionDetailsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeGameSessionDetailsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeGameSessionDetailsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeGameSessionDetailsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGameSessionDetailsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGameSessionDetailsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGameSessionDetailsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGameSessionDetailsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGameSessionDetailsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGameSessionDetailsErrorKind::TerminalRoutingStrategyException`.
    pub fn is_terminal_routing_strategy_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGameSessionDetailsErrorKind::TerminalRoutingStrategyException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGameSessionDetailsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGameSessionDetailsErrorKind::UnauthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGameSessionDetailsErrorKind::UnsupportedRegionException`.
    pub fn is_unsupported_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGameSessionDetailsErrorKind::UnsupportedRegionException(_)
        )
    }
}
impl std::error::Error for DescribeGameSessionDetailsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeGameSessionDetailsErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeGameSessionDetailsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeGameSessionDetailsErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeGameSessionDetailsErrorKind::TerminalRoutingStrategyException(_inner) => {
                Some(_inner)
            }
            DescribeGameSessionDetailsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeGameSessionDetailsErrorKind::UnsupportedRegionException(_inner) => Some(_inner),
            DescribeGameSessionDetailsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeGameSessionPlacement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeGameSessionPlacementError {
    /// Kind of error that occurred.
    pub kind: DescribeGameSessionPlacementErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeGameSessionPlacement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeGameSessionPlacementErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeGameSessionPlacementError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeGameSessionPlacementErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            DescribeGameSessionPlacementErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeGameSessionPlacementErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeGameSessionPlacementErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeGameSessionPlacementErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeGameSessionPlacementError {
    fn code(&self) -> Option<&str> {
        DescribeGameSessionPlacementError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeGameSessionPlacementError {
    /// Creates a new `DescribeGameSessionPlacementError`.
    pub fn new(kind: DescribeGameSessionPlacementErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeGameSessionPlacementError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeGameSessionPlacementErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeGameSessionPlacementError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeGameSessionPlacementErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeGameSessionPlacementErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGameSessionPlacementErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGameSessionPlacementErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGameSessionPlacementErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGameSessionPlacementErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGameSessionPlacementErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGameSessionPlacementErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGameSessionPlacementErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeGameSessionPlacementError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeGameSessionPlacementErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeGameSessionPlacementErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeGameSessionPlacementErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeGameSessionPlacementErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeGameSessionPlacementErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeGameSessionQueues` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeGameSessionQueuesError {
    /// Kind of error that occurred.
    pub kind: DescribeGameSessionQueuesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeGameSessionQueues` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeGameSessionQueuesErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeGameSessionQueuesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeGameSessionQueuesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeGameSessionQueuesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeGameSessionQueuesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeGameSessionQueuesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeGameSessionQueuesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeGameSessionQueuesError {
    fn code(&self) -> Option<&str> {
        DescribeGameSessionQueuesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeGameSessionQueuesError {
    /// Creates a new `DescribeGameSessionQueuesError`.
    pub fn new(kind: DescribeGameSessionQueuesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeGameSessionQueuesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeGameSessionQueuesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeGameSessionQueuesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeGameSessionQueuesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeGameSessionQueuesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGameSessionQueuesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGameSessionQueuesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGameSessionQueuesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGameSessionQueuesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGameSessionQueuesErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGameSessionQueuesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGameSessionQueuesErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeGameSessionQueuesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeGameSessionQueuesErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeGameSessionQueuesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeGameSessionQueuesErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeGameSessionQueuesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeGameSessionQueuesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeGameSessions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeGameSessionsError {
    /// Kind of error that occurred.
    pub kind: DescribeGameSessionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeGameSessions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeGameSessionsErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service is unable to resolve the routing for a particular alias because it has a terminal <code>RoutingStrategy</code> associated with it. The message returned in this exception is the message defined in the routing strategy itself. Such requests should only be retried if the routing strategy for the specified alias is modified. </p>
    TerminalRoutingStrategyException(crate::error::TerminalRoutingStrategyException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// <p>The requested operation is not supported in the Region specified.</p>
    UnsupportedRegionException(crate::error::UnsupportedRegionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeGameSessionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeGameSessionsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeGameSessionsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeGameSessionsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeGameSessionsErrorKind::TerminalRoutingStrategyException(_inner) => {
                _inner.fmt(f)
            }
            DescribeGameSessionsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeGameSessionsErrorKind::UnsupportedRegionException(_inner) => _inner.fmt(f),
            DescribeGameSessionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeGameSessionsError {
    fn code(&self) -> Option<&str> {
        DescribeGameSessionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeGameSessionsError {
    /// Creates a new `DescribeGameSessionsError`.
    pub fn new(kind: DescribeGameSessionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeGameSessionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeGameSessionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeGameSessionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeGameSessionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeGameSessionsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGameSessionsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGameSessionsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGameSessionsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGameSessionsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGameSessionsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGameSessionsErrorKind::TerminalRoutingStrategyException`.
    pub fn is_terminal_routing_strategy_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGameSessionsErrorKind::TerminalRoutingStrategyException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGameSessionsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGameSessionsErrorKind::UnauthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGameSessionsErrorKind::UnsupportedRegionException`.
    pub fn is_unsupported_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGameSessionsErrorKind::UnsupportedRegionException(_)
        )
    }
}
impl std::error::Error for DescribeGameSessionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeGameSessionsErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeGameSessionsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeGameSessionsErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeGameSessionsErrorKind::TerminalRoutingStrategyException(_inner) => Some(_inner),
            DescribeGameSessionsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeGameSessionsErrorKind::UnsupportedRegionException(_inner) => Some(_inner),
            DescribeGameSessionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeInstancesError {
    /// Kind of error that occurred.
    pub kind: DescribeInstancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeInstancesErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// <p>The requested operation is not supported in the Region specified.</p>
    UnsupportedRegionException(crate::error::UnsupportedRegionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeInstancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeInstancesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeInstancesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeInstancesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeInstancesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeInstancesErrorKind::UnsupportedRegionException(_inner) => _inner.fmt(f),
            DescribeInstancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeInstancesError {
    fn code(&self) -> Option<&str> {
        DescribeInstancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeInstancesError {
    /// Creates a new `DescribeInstancesError`.
    pub fn new(kind: DescribeInstancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeInstancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeInstancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeInstancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeInstancesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeInstancesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstancesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInstancesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstancesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInstancesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DescribeInstancesErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DescribeInstancesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstancesErrorKind::UnauthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInstancesErrorKind::UnsupportedRegionException`.
    pub fn is_unsupported_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstancesErrorKind::UnsupportedRegionException(_)
        )
    }
}
impl std::error::Error for DescribeInstancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeInstancesErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeInstancesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeInstancesErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeInstancesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeInstancesErrorKind::UnsupportedRegionException(_inner) => Some(_inner),
            DescribeInstancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeMatchmaking` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeMatchmakingError {
    /// Kind of error that occurred.
    pub kind: DescribeMatchmakingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeMatchmaking` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeMatchmakingErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested operation is not supported in the Region specified.</p>
    UnsupportedRegionException(crate::error::UnsupportedRegionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeMatchmakingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeMatchmakingErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeMatchmakingErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeMatchmakingErrorKind::UnsupportedRegionException(_inner) => _inner.fmt(f),
            DescribeMatchmakingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeMatchmakingError {
    fn code(&self) -> Option<&str> {
        DescribeMatchmakingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeMatchmakingError {
    /// Creates a new `DescribeMatchmakingError`.
    pub fn new(kind: DescribeMatchmakingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeMatchmakingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeMatchmakingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeMatchmakingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeMatchmakingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeMatchmakingErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMatchmakingErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMatchmakingErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMatchmakingErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMatchmakingErrorKind::UnsupportedRegionException`.
    pub fn is_unsupported_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMatchmakingErrorKind::UnsupportedRegionException(_)
        )
    }
}
impl std::error::Error for DescribeMatchmakingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeMatchmakingErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeMatchmakingErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeMatchmakingErrorKind::UnsupportedRegionException(_inner) => Some(_inner),
            DescribeMatchmakingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeMatchmakingConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeMatchmakingConfigurationsError {
    /// Kind of error that occurred.
    pub kind: DescribeMatchmakingConfigurationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeMatchmakingConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeMatchmakingConfigurationsErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested operation is not supported in the Region specified.</p>
    UnsupportedRegionException(crate::error::UnsupportedRegionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeMatchmakingConfigurationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeMatchmakingConfigurationsErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            DescribeMatchmakingConfigurationsErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeMatchmakingConfigurationsErrorKind::UnsupportedRegionException(_inner) => {
                _inner.fmt(f)
            }
            DescribeMatchmakingConfigurationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeMatchmakingConfigurationsError {
    fn code(&self) -> Option<&str> {
        DescribeMatchmakingConfigurationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeMatchmakingConfigurationsError {
    /// Creates a new `DescribeMatchmakingConfigurationsError`.
    pub fn new(
        kind: DescribeMatchmakingConfigurationsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeMatchmakingConfigurationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeMatchmakingConfigurationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeMatchmakingConfigurationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeMatchmakingConfigurationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeMatchmakingConfigurationsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMatchmakingConfigurationsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMatchmakingConfigurationsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMatchmakingConfigurationsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMatchmakingConfigurationsErrorKind::UnsupportedRegionException`.
    pub fn is_unsupported_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMatchmakingConfigurationsErrorKind::UnsupportedRegionException(_)
        )
    }
}
impl std::error::Error for DescribeMatchmakingConfigurationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeMatchmakingConfigurationsErrorKind::InternalServiceException(_inner) => {
                Some(_inner)
            }
            DescribeMatchmakingConfigurationsErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            DescribeMatchmakingConfigurationsErrorKind::UnsupportedRegionException(_inner) => {
                Some(_inner)
            }
            DescribeMatchmakingConfigurationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeMatchmakingRuleSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeMatchmakingRuleSetsError {
    /// Kind of error that occurred.
    pub kind: DescribeMatchmakingRuleSetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeMatchmakingRuleSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeMatchmakingRuleSetsErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The requested operation is not supported in the Region specified.</p>
    UnsupportedRegionException(crate::error::UnsupportedRegionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeMatchmakingRuleSetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeMatchmakingRuleSetsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeMatchmakingRuleSetsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeMatchmakingRuleSetsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeMatchmakingRuleSetsErrorKind::UnsupportedRegionException(_inner) => {
                _inner.fmt(f)
            }
            DescribeMatchmakingRuleSetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeMatchmakingRuleSetsError {
    fn code(&self) -> Option<&str> {
        DescribeMatchmakingRuleSetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeMatchmakingRuleSetsError {
    /// Creates a new `DescribeMatchmakingRuleSetsError`.
    pub fn new(kind: DescribeMatchmakingRuleSetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeMatchmakingRuleSetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeMatchmakingRuleSetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeMatchmakingRuleSetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeMatchmakingRuleSetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeMatchmakingRuleSetsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMatchmakingRuleSetsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMatchmakingRuleSetsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMatchmakingRuleSetsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMatchmakingRuleSetsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMatchmakingRuleSetsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMatchmakingRuleSetsErrorKind::UnsupportedRegionException`.
    pub fn is_unsupported_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMatchmakingRuleSetsErrorKind::UnsupportedRegionException(_)
        )
    }
}
impl std::error::Error for DescribeMatchmakingRuleSetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeMatchmakingRuleSetsErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeMatchmakingRuleSetsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeMatchmakingRuleSetsErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeMatchmakingRuleSetsErrorKind::UnsupportedRegionException(_inner) => {
                Some(_inner)
            }
            DescribeMatchmakingRuleSetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePlayerSessions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePlayerSessionsError {
    /// Kind of error that occurred.
    pub kind: DescribePlayerSessionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePlayerSessions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePlayerSessionsErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePlayerSessionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePlayerSessionsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribePlayerSessionsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribePlayerSessionsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribePlayerSessionsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribePlayerSessionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePlayerSessionsError {
    fn code(&self) -> Option<&str> {
        DescribePlayerSessionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePlayerSessionsError {
    /// Creates a new `DescribePlayerSessionsError`.
    pub fn new(kind: DescribePlayerSessionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePlayerSessionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePlayerSessionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePlayerSessionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePlayerSessionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribePlayerSessionsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePlayerSessionsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePlayerSessionsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePlayerSessionsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePlayerSessionsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePlayerSessionsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePlayerSessionsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePlayerSessionsErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribePlayerSessionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePlayerSessionsErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribePlayerSessionsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribePlayerSessionsErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribePlayerSessionsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribePlayerSessionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeRuntimeConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeRuntimeConfigurationError {
    /// Kind of error that occurred.
    pub kind: DescribeRuntimeConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeRuntimeConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeRuntimeConfigurationErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeRuntimeConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeRuntimeConfigurationErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            DescribeRuntimeConfigurationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeRuntimeConfigurationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeRuntimeConfigurationErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeRuntimeConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeRuntimeConfigurationError {
    fn code(&self) -> Option<&str> {
        DescribeRuntimeConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeRuntimeConfigurationError {
    /// Creates a new `DescribeRuntimeConfigurationError`.
    pub fn new(kind: DescribeRuntimeConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeRuntimeConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeRuntimeConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeRuntimeConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeRuntimeConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeRuntimeConfigurationErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRuntimeConfigurationErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRuntimeConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRuntimeConfigurationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRuntimeConfigurationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRuntimeConfigurationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRuntimeConfigurationErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRuntimeConfigurationErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeRuntimeConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeRuntimeConfigurationErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeRuntimeConfigurationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeRuntimeConfigurationErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeRuntimeConfigurationErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeRuntimeConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeScalingPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeScalingPoliciesError {
    /// Kind of error that occurred.
    pub kind: DescribeScalingPoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeScalingPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeScalingPoliciesErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// <p>The requested operation is not supported in the Region specified.</p>
    UnsupportedRegionException(crate::error::UnsupportedRegionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeScalingPoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeScalingPoliciesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeScalingPoliciesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeScalingPoliciesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeScalingPoliciesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeScalingPoliciesErrorKind::UnsupportedRegionException(_inner) => _inner.fmt(f),
            DescribeScalingPoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeScalingPoliciesError {
    fn code(&self) -> Option<&str> {
        DescribeScalingPoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeScalingPoliciesError {
    /// Creates a new `DescribeScalingPoliciesError`.
    pub fn new(kind: DescribeScalingPoliciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeScalingPoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeScalingPoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeScalingPoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeScalingPoliciesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeScalingPoliciesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScalingPoliciesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScalingPoliciesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScalingPoliciesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScalingPoliciesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScalingPoliciesErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScalingPoliciesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScalingPoliciesErrorKind::UnauthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScalingPoliciesErrorKind::UnsupportedRegionException`.
    pub fn is_unsupported_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScalingPoliciesErrorKind::UnsupportedRegionException(_)
        )
    }
}
impl std::error::Error for DescribeScalingPoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeScalingPoliciesErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeScalingPoliciesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeScalingPoliciesErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeScalingPoliciesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeScalingPoliciesErrorKind::UnsupportedRegionException(_inner) => Some(_inner),
            DescribeScalingPoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeScript` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeScriptError {
    /// Kind of error that occurred.
    pub kind: DescribeScriptErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeScript` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeScriptErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeScriptError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeScriptErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeScriptErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeScriptErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeScriptErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeScriptErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeScriptError {
    fn code(&self) -> Option<&str> {
        DescribeScriptError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeScriptError {
    /// Creates a new `DescribeScriptError`.
    pub fn new(kind: DescribeScriptErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeScriptError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeScriptErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeScriptError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeScriptErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeScriptErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScriptErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScriptErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScriptErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScriptErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DescribeScriptErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DescribeScriptErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScriptErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeScriptError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeScriptErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeScriptErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeScriptErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeScriptErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeScriptErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeVpcPeeringAuthorizations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeVpcPeeringAuthorizationsError {
    /// Kind of error that occurred.
    pub kind: DescribeVpcPeeringAuthorizationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeVpcPeeringAuthorizations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeVpcPeeringAuthorizationsErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeVpcPeeringAuthorizationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeVpcPeeringAuthorizationsErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            DescribeVpcPeeringAuthorizationsErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeVpcPeeringAuthorizationsErrorKind::UnauthorizedException(_inner) => {
                _inner.fmt(f)
            }
            DescribeVpcPeeringAuthorizationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeVpcPeeringAuthorizationsError {
    fn code(&self) -> Option<&str> {
        DescribeVpcPeeringAuthorizationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeVpcPeeringAuthorizationsError {
    /// Creates a new `DescribeVpcPeeringAuthorizationsError`.
    pub fn new(
        kind: DescribeVpcPeeringAuthorizationsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeVpcPeeringAuthorizationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeVpcPeeringAuthorizationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeVpcPeeringAuthorizationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeVpcPeeringAuthorizationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeVpcPeeringAuthorizationsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVpcPeeringAuthorizationsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeVpcPeeringAuthorizationsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVpcPeeringAuthorizationsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeVpcPeeringAuthorizationsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVpcPeeringAuthorizationsErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeVpcPeeringAuthorizationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeVpcPeeringAuthorizationsErrorKind::InternalServiceException(_inner) => {
                Some(_inner)
            }
            DescribeVpcPeeringAuthorizationsErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            DescribeVpcPeeringAuthorizationsErrorKind::UnauthorizedException(_inner) => {
                Some(_inner)
            }
            DescribeVpcPeeringAuthorizationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeVpcPeeringConnections` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeVpcPeeringConnectionsError {
    /// Kind of error that occurred.
    pub kind: DescribeVpcPeeringConnectionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeVpcPeeringConnections` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeVpcPeeringConnectionsErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeVpcPeeringConnectionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeVpcPeeringConnectionsErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            DescribeVpcPeeringConnectionsErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeVpcPeeringConnectionsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeVpcPeeringConnectionsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeVpcPeeringConnectionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeVpcPeeringConnectionsError {
    fn code(&self) -> Option<&str> {
        DescribeVpcPeeringConnectionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeVpcPeeringConnectionsError {
    /// Creates a new `DescribeVpcPeeringConnectionsError`.
    pub fn new(
        kind: DescribeVpcPeeringConnectionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeVpcPeeringConnectionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeVpcPeeringConnectionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeVpcPeeringConnectionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeVpcPeeringConnectionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeVpcPeeringConnectionsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVpcPeeringConnectionsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeVpcPeeringConnectionsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVpcPeeringConnectionsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeVpcPeeringConnectionsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVpcPeeringConnectionsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeVpcPeeringConnectionsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVpcPeeringConnectionsErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeVpcPeeringConnectionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeVpcPeeringConnectionsErrorKind::InternalServiceException(_inner) => {
                Some(_inner)
            }
            DescribeVpcPeeringConnectionsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeVpcPeeringConnectionsErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeVpcPeeringConnectionsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeVpcPeeringConnectionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetGameSessionLogUrl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetGameSessionLogUrlError {
    /// Kind of error that occurred.
    pub kind: GetGameSessionLogUrlErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetGameSessionLogUrl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetGameSessionLogUrlErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetGameSessionLogUrlError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetGameSessionLogUrlErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetGameSessionLogUrlErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetGameSessionLogUrlErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetGameSessionLogUrlErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetGameSessionLogUrlErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetGameSessionLogUrlError {
    fn code(&self) -> Option<&str> {
        GetGameSessionLogUrlError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetGameSessionLogUrlError {
    /// Creates a new `GetGameSessionLogUrlError`.
    pub fn new(kind: GetGameSessionLogUrlErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetGameSessionLogUrlError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetGameSessionLogUrlErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetGameSessionLogUrlError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetGameSessionLogUrlErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetGameSessionLogUrlErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGameSessionLogUrlErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetGameSessionLogUrlErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGameSessionLogUrlErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetGameSessionLogUrlErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGameSessionLogUrlErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetGameSessionLogUrlErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGameSessionLogUrlErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetGameSessionLogUrlError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetGameSessionLogUrlErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetGameSessionLogUrlErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetGameSessionLogUrlErrorKind::NotFoundException(_inner) => Some(_inner),
            GetGameSessionLogUrlErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetGameSessionLogUrlErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetInstanceAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetInstanceAccessError {
    /// Kind of error that occurred.
    pub kind: GetInstanceAccessErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetInstanceAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetInstanceAccessErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetInstanceAccessError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetInstanceAccessErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetInstanceAccessErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetInstanceAccessErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetInstanceAccessErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetInstanceAccessErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetInstanceAccessError {
    fn code(&self) -> Option<&str> {
        GetInstanceAccessError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetInstanceAccessError {
    /// Creates a new `GetInstanceAccessError`.
    pub fn new(kind: GetInstanceAccessErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetInstanceAccessError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetInstanceAccessErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetInstanceAccessError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetInstanceAccessErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetInstanceAccessErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceAccessErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstanceAccessErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceAccessErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstanceAccessErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetInstanceAccessErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetInstanceAccessErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceAccessErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetInstanceAccessError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetInstanceAccessErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetInstanceAccessErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetInstanceAccessErrorKind::NotFoundException(_inner) => Some(_inner),
            GetInstanceAccessErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetInstanceAccessErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAliases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAliasesError {
    /// Kind of error that occurred.
    pub kind: ListAliasesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAliases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAliasesErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAliasesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAliasesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListAliasesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListAliasesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListAliasesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAliasesError {
    fn code(&self) -> Option<&str> {
        ListAliasesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAliasesError {
    /// Creates a new `ListAliasesError`.
    pub fn new(kind: ListAliasesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAliasesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAliasesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAliasesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAliasesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAliasesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAliasesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAliasesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, ListAliasesErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `ListAliasesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, ListAliasesErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for ListAliasesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAliasesErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListAliasesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListAliasesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListAliasesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBuilds` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBuildsError {
    /// Kind of error that occurred.
    pub kind: ListBuildsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBuilds` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBuildsErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBuildsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBuildsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListBuildsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListBuildsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListBuildsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBuildsError {
    fn code(&self) -> Option<&str> {
        ListBuildsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBuildsError {
    /// Creates a new `ListBuildsError`.
    pub fn new(kind: ListBuildsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBuildsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBuildsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBuildsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBuildsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListBuildsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(&self.kind, ListBuildsErrorKind::InternalServiceException(_))
    }
    /// Returns `true` if the error kind is `ListBuildsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, ListBuildsErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `ListBuildsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, ListBuildsErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for ListBuildsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBuildsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListBuildsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListBuildsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListBuildsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFleets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFleetsError {
    /// Kind of error that occurred.
    pub kind: ListFleetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFleets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFleetsErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFleetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFleetsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListFleetsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListFleetsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListFleetsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListFleetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFleetsError {
    fn code(&self) -> Option<&str> {
        ListFleetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFleetsError {
    /// Creates a new `ListFleetsError`.
    pub fn new(kind: ListFleetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFleetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFleetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFleetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFleetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListFleetsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(&self.kind, ListFleetsErrorKind::InternalServiceException(_))
    }
    /// Returns `true` if the error kind is `ListFleetsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, ListFleetsErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `ListFleetsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListFleetsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListFleetsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, ListFleetsErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for ListFleetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFleetsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListFleetsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListFleetsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListFleetsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListFleetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListGameServerGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListGameServerGroupsError {
    /// Kind of error that occurred.
    pub kind: ListGameServerGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListGameServerGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListGameServerGroupsErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListGameServerGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListGameServerGroupsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListGameServerGroupsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListGameServerGroupsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListGameServerGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListGameServerGroupsError {
    fn code(&self) -> Option<&str> {
        ListGameServerGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListGameServerGroupsError {
    /// Creates a new `ListGameServerGroupsError`.
    pub fn new(kind: ListGameServerGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListGameServerGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListGameServerGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListGameServerGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListGameServerGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListGameServerGroupsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGameServerGroupsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGameServerGroupsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGameServerGroupsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGameServerGroupsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGameServerGroupsErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListGameServerGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListGameServerGroupsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListGameServerGroupsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListGameServerGroupsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListGameServerGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListGameServers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListGameServersError {
    /// Kind of error that occurred.
    pub kind: ListGameServersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListGameServers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListGameServersErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListGameServersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListGameServersErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListGameServersErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListGameServersErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListGameServersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListGameServersError {
    fn code(&self) -> Option<&str> {
        ListGameServersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListGameServersError {
    /// Creates a new `ListGameServersError`.
    pub fn new(kind: ListGameServersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListGameServersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListGameServersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListGameServersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListGameServersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListGameServersErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGameServersErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGameServersErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGameServersErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGameServersErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGameServersErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListGameServersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListGameServersErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListGameServersErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListGameServersErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListGameServersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListScripts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListScriptsError {
    /// Kind of error that occurred.
    pub kind: ListScriptsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListScripts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListScriptsErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListScriptsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListScriptsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListScriptsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListScriptsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListScriptsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListScriptsError {
    fn code(&self) -> Option<&str> {
        ListScriptsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListScriptsError {
    /// Creates a new `ListScriptsError`.
    pub fn new(kind: ListScriptsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListScriptsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListScriptsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListScriptsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListScriptsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListScriptsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListScriptsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListScriptsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, ListScriptsErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `ListScriptsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, ListScriptsErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for ListScriptsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListScriptsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListScriptsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListScriptsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListScriptsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying. </p>
    TaggingFailedException(crate::error::TaggingFailedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::TaggingFailedException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::TaggingFailedException`.
    pub fn is_tagging_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::TaggingFailedException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::TaggingFailedException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutScalingPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutScalingPolicyError {
    /// Kind of error that occurred.
    pub kind: PutScalingPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutScalingPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutScalingPolicyErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutScalingPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutScalingPolicyErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            PutScalingPolicyErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            PutScalingPolicyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PutScalingPolicyErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            PutScalingPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutScalingPolicyError {
    fn code(&self) -> Option<&str> {
        PutScalingPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutScalingPolicyError {
    /// Creates a new `PutScalingPolicyError`.
    pub fn new(kind: PutScalingPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutScalingPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutScalingPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutScalingPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutScalingPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutScalingPolicyErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutScalingPolicyErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `PutScalingPolicyErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutScalingPolicyErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `PutScalingPolicyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, PutScalingPolicyErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `PutScalingPolicyErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutScalingPolicyErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for PutScalingPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutScalingPolicyErrorKind::InternalServiceException(_inner) => Some(_inner),
            PutScalingPolicyErrorKind::InvalidRequestException(_inner) => Some(_inner),
            PutScalingPolicyErrorKind::NotFoundException(_inner) => Some(_inner),
            PutScalingPolicyErrorKind::UnauthorizedException(_inner) => Some(_inner),
            PutScalingPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterGameServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterGameServerError {
    /// Kind of error that occurred.
    pub kind: RegisterGameServerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterGameServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterGameServerErrorKind {
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested operation would cause the resource to exceed the allowed service limit. Resolve the issue before retrying.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterGameServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterGameServerErrorKind::ConflictException(_inner) => _inner.fmt(f),
            RegisterGameServerErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            RegisterGameServerErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            RegisterGameServerErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            RegisterGameServerErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            RegisterGameServerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterGameServerError {
    fn code(&self) -> Option<&str> {
        RegisterGameServerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterGameServerError {
    /// Creates a new `RegisterGameServerError`.
    pub fn new(kind: RegisterGameServerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterGameServerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterGameServerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterGameServerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterGameServerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterGameServerErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterGameServerErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterGameServerErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterGameServerErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterGameServerErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterGameServerErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterGameServerErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterGameServerErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterGameServerErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterGameServerErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for RegisterGameServerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterGameServerErrorKind::ConflictException(_inner) => Some(_inner),
            RegisterGameServerErrorKind::InternalServiceException(_inner) => Some(_inner),
            RegisterGameServerErrorKind::InvalidRequestException(_inner) => Some(_inner),
            RegisterGameServerErrorKind::LimitExceededException(_inner) => Some(_inner),
            RegisterGameServerErrorKind::UnauthorizedException(_inner) => Some(_inner),
            RegisterGameServerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RequestUploadCredentials` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RequestUploadCredentialsError {
    /// Kind of error that occurred.
    pub kind: RequestUploadCredentialsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RequestUploadCredentials` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RequestUploadCredentialsErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RequestUploadCredentialsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RequestUploadCredentialsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            RequestUploadCredentialsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            RequestUploadCredentialsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            RequestUploadCredentialsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            RequestUploadCredentialsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RequestUploadCredentialsError {
    fn code(&self) -> Option<&str> {
        RequestUploadCredentialsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RequestUploadCredentialsError {
    /// Creates a new `RequestUploadCredentialsError`.
    pub fn new(kind: RequestUploadCredentialsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RequestUploadCredentialsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RequestUploadCredentialsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RequestUploadCredentialsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RequestUploadCredentialsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RequestUploadCredentialsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            RequestUploadCredentialsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `RequestUploadCredentialsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            RequestUploadCredentialsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `RequestUploadCredentialsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RequestUploadCredentialsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RequestUploadCredentialsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            RequestUploadCredentialsErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for RequestUploadCredentialsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RequestUploadCredentialsErrorKind::InternalServiceException(_inner) => Some(_inner),
            RequestUploadCredentialsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            RequestUploadCredentialsErrorKind::NotFoundException(_inner) => Some(_inner),
            RequestUploadCredentialsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            RequestUploadCredentialsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ResolveAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ResolveAliasError {
    /// Kind of error that occurred.
    pub kind: ResolveAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ResolveAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ResolveAliasErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service is unable to resolve the routing for a particular alias because it has a terminal <code>RoutingStrategy</code> associated with it. The message returned in this exception is the message defined in the routing strategy itself. Such requests should only be retried if the routing strategy for the specified alias is modified. </p>
    TerminalRoutingStrategyException(crate::error::TerminalRoutingStrategyException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ResolveAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ResolveAliasErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ResolveAliasErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ResolveAliasErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ResolveAliasErrorKind::TerminalRoutingStrategyException(_inner) => _inner.fmt(f),
            ResolveAliasErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ResolveAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ResolveAliasError {
    fn code(&self) -> Option<&str> {
        ResolveAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ResolveAliasError {
    /// Creates a new `ResolveAliasError`.
    pub fn new(kind: ResolveAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ResolveAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ResolveAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ResolveAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ResolveAliasErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ResolveAliasErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResolveAliasErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ResolveAliasErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResolveAliasErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ResolveAliasErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ResolveAliasErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `ResolveAliasErrorKind::TerminalRoutingStrategyException`.
    pub fn is_terminal_routing_strategy_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResolveAliasErrorKind::TerminalRoutingStrategyException(_)
        )
    }
    /// Returns `true` if the error kind is `ResolveAliasErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, ResolveAliasErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for ResolveAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ResolveAliasErrorKind::InternalServiceException(_inner) => Some(_inner),
            ResolveAliasErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ResolveAliasErrorKind::NotFoundException(_inner) => Some(_inner),
            ResolveAliasErrorKind::TerminalRoutingStrategyException(_inner) => Some(_inner),
            ResolveAliasErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ResolveAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ResumeGameServerGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ResumeGameServerGroupError {
    /// Kind of error that occurred.
    pub kind: ResumeGameServerGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ResumeGameServerGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ResumeGameServerGroupErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ResumeGameServerGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ResumeGameServerGroupErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ResumeGameServerGroupErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ResumeGameServerGroupErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ResumeGameServerGroupErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ResumeGameServerGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ResumeGameServerGroupError {
    fn code(&self) -> Option<&str> {
        ResumeGameServerGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ResumeGameServerGroupError {
    /// Creates a new `ResumeGameServerGroupError`.
    pub fn new(kind: ResumeGameServerGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ResumeGameServerGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ResumeGameServerGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ResumeGameServerGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ResumeGameServerGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ResumeGameServerGroupErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResumeGameServerGroupErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ResumeGameServerGroupErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResumeGameServerGroupErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ResumeGameServerGroupErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResumeGameServerGroupErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ResumeGameServerGroupErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResumeGameServerGroupErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ResumeGameServerGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ResumeGameServerGroupErrorKind::InternalServiceException(_inner) => Some(_inner),
            ResumeGameServerGroupErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ResumeGameServerGroupErrorKind::NotFoundException(_inner) => Some(_inner),
            ResumeGameServerGroupErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ResumeGameServerGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SearchGameSessions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SearchGameSessionsError {
    /// Kind of error that occurred.
    pub kind: SearchGameSessionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SearchGameSessions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SearchGameSessionsErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service is unable to resolve the routing for a particular alias because it has a terminal <code>RoutingStrategy</code> associated with it. The message returned in this exception is the message defined in the routing strategy itself. Such requests should only be retried if the routing strategy for the specified alias is modified. </p>
    TerminalRoutingStrategyException(crate::error::TerminalRoutingStrategyException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// <p>The requested operation is not supported in the Region specified.</p>
    UnsupportedRegionException(crate::error::UnsupportedRegionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SearchGameSessionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SearchGameSessionsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            SearchGameSessionsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            SearchGameSessionsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            SearchGameSessionsErrorKind::TerminalRoutingStrategyException(_inner) => _inner.fmt(f),
            SearchGameSessionsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            SearchGameSessionsErrorKind::UnsupportedRegionException(_inner) => _inner.fmt(f),
            SearchGameSessionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SearchGameSessionsError {
    fn code(&self) -> Option<&str> {
        SearchGameSessionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SearchGameSessionsError {
    /// Creates a new `SearchGameSessionsError`.
    pub fn new(kind: SearchGameSessionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SearchGameSessionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SearchGameSessionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SearchGameSessionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SearchGameSessionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SearchGameSessionsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchGameSessionsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `SearchGameSessionsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchGameSessionsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `SearchGameSessionsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchGameSessionsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SearchGameSessionsErrorKind::TerminalRoutingStrategyException`.
    pub fn is_terminal_routing_strategy_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchGameSessionsErrorKind::TerminalRoutingStrategyException(_)
        )
    }
    /// Returns `true` if the error kind is `SearchGameSessionsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchGameSessionsErrorKind::UnauthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `SearchGameSessionsErrorKind::UnsupportedRegionException`.
    pub fn is_unsupported_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchGameSessionsErrorKind::UnsupportedRegionException(_)
        )
    }
}
impl std::error::Error for SearchGameSessionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SearchGameSessionsErrorKind::InternalServiceException(_inner) => Some(_inner),
            SearchGameSessionsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            SearchGameSessionsErrorKind::NotFoundException(_inner) => Some(_inner),
            SearchGameSessionsErrorKind::TerminalRoutingStrategyException(_inner) => Some(_inner),
            SearchGameSessionsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            SearchGameSessionsErrorKind::UnsupportedRegionException(_inner) => Some(_inner),
            SearchGameSessionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartFleetActions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartFleetActionsError {
    /// Kind of error that occurred.
    pub kind: StartFleetActionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartFleetActions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartFleetActionsErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// <p>The requested operation is not supported in the Region specified.</p>
    UnsupportedRegionException(crate::error::UnsupportedRegionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartFleetActionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartFleetActionsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            StartFleetActionsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StartFleetActionsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            StartFleetActionsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            StartFleetActionsErrorKind::UnsupportedRegionException(_inner) => _inner.fmt(f),
            StartFleetActionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartFleetActionsError {
    fn code(&self) -> Option<&str> {
        StartFleetActionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartFleetActionsError {
    /// Creates a new `StartFleetActionsError`.
    pub fn new(kind: StartFleetActionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartFleetActionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartFleetActionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartFleetActionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartFleetActionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartFleetActionsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFleetActionsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `StartFleetActionsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFleetActionsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StartFleetActionsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, StartFleetActionsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `StartFleetActionsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFleetActionsErrorKind::UnauthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `StartFleetActionsErrorKind::UnsupportedRegionException`.
    pub fn is_unsupported_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFleetActionsErrorKind::UnsupportedRegionException(_)
        )
    }
}
impl std::error::Error for StartFleetActionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartFleetActionsErrorKind::InternalServiceException(_inner) => Some(_inner),
            StartFleetActionsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StartFleetActionsErrorKind::NotFoundException(_inner) => Some(_inner),
            StartFleetActionsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            StartFleetActionsErrorKind::UnsupportedRegionException(_inner) => Some(_inner),
            StartFleetActionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartGameSessionPlacement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartGameSessionPlacementError {
    /// Kind of error that occurred.
    pub kind: StartGameSessionPlacementErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartGameSessionPlacement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartGameSessionPlacementErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartGameSessionPlacementError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartGameSessionPlacementErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            StartGameSessionPlacementErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StartGameSessionPlacementErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            StartGameSessionPlacementErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            StartGameSessionPlacementErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartGameSessionPlacementError {
    fn code(&self) -> Option<&str> {
        StartGameSessionPlacementError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartGameSessionPlacementError {
    /// Creates a new `StartGameSessionPlacementError`.
    pub fn new(kind: StartGameSessionPlacementErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartGameSessionPlacementError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartGameSessionPlacementErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartGameSessionPlacementError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartGameSessionPlacementErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartGameSessionPlacementErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartGameSessionPlacementErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `StartGameSessionPlacementErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartGameSessionPlacementErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StartGameSessionPlacementErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartGameSessionPlacementErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartGameSessionPlacementErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartGameSessionPlacementErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for StartGameSessionPlacementError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartGameSessionPlacementErrorKind::InternalServiceException(_inner) => Some(_inner),
            StartGameSessionPlacementErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StartGameSessionPlacementErrorKind::NotFoundException(_inner) => Some(_inner),
            StartGameSessionPlacementErrorKind::UnauthorizedException(_inner) => Some(_inner),
            StartGameSessionPlacementErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartMatchBackfill` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartMatchBackfillError {
    /// Kind of error that occurred.
    pub kind: StartMatchBackfillErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartMatchBackfill` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartMatchBackfillErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The requested operation is not supported in the Region specified.</p>
    UnsupportedRegionException(crate::error::UnsupportedRegionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartMatchBackfillError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartMatchBackfillErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            StartMatchBackfillErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StartMatchBackfillErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            StartMatchBackfillErrorKind::UnsupportedRegionException(_inner) => _inner.fmt(f),
            StartMatchBackfillErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartMatchBackfillError {
    fn code(&self) -> Option<&str> {
        StartMatchBackfillError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartMatchBackfillError {
    /// Creates a new `StartMatchBackfillError`.
    pub fn new(kind: StartMatchBackfillErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartMatchBackfillError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartMatchBackfillErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartMatchBackfillError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartMatchBackfillErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartMatchBackfillErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMatchBackfillErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMatchBackfillErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMatchBackfillErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMatchBackfillErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMatchBackfillErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMatchBackfillErrorKind::UnsupportedRegionException`.
    pub fn is_unsupported_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMatchBackfillErrorKind::UnsupportedRegionException(_)
        )
    }
}
impl std::error::Error for StartMatchBackfillError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartMatchBackfillErrorKind::InternalServiceException(_inner) => Some(_inner),
            StartMatchBackfillErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StartMatchBackfillErrorKind::NotFoundException(_inner) => Some(_inner),
            StartMatchBackfillErrorKind::UnsupportedRegionException(_inner) => Some(_inner),
            StartMatchBackfillErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartMatchmaking` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartMatchmakingError {
    /// Kind of error that occurred.
    pub kind: StartMatchmakingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartMatchmaking` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartMatchmakingErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The requested operation is not supported in the Region specified.</p>
    UnsupportedRegionException(crate::error::UnsupportedRegionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartMatchmakingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartMatchmakingErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            StartMatchmakingErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StartMatchmakingErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            StartMatchmakingErrorKind::UnsupportedRegionException(_inner) => _inner.fmt(f),
            StartMatchmakingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartMatchmakingError {
    fn code(&self) -> Option<&str> {
        StartMatchmakingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartMatchmakingError {
    /// Creates a new `StartMatchmakingError`.
    pub fn new(kind: StartMatchmakingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartMatchmakingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartMatchmakingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartMatchmakingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartMatchmakingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartMatchmakingErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMatchmakingErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMatchmakingErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMatchmakingErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMatchmakingErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, StartMatchmakingErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `StartMatchmakingErrorKind::UnsupportedRegionException`.
    pub fn is_unsupported_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMatchmakingErrorKind::UnsupportedRegionException(_)
        )
    }
}
impl std::error::Error for StartMatchmakingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartMatchmakingErrorKind::InternalServiceException(_inner) => Some(_inner),
            StartMatchmakingErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StartMatchmakingErrorKind::NotFoundException(_inner) => Some(_inner),
            StartMatchmakingErrorKind::UnsupportedRegionException(_inner) => Some(_inner),
            StartMatchmakingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopFleetActions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopFleetActionsError {
    /// Kind of error that occurred.
    pub kind: StopFleetActionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopFleetActions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopFleetActionsErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// <p>The requested operation is not supported in the Region specified.</p>
    UnsupportedRegionException(crate::error::UnsupportedRegionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopFleetActionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopFleetActionsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            StopFleetActionsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StopFleetActionsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            StopFleetActionsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            StopFleetActionsErrorKind::UnsupportedRegionException(_inner) => _inner.fmt(f),
            StopFleetActionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopFleetActionsError {
    fn code(&self) -> Option<&str> {
        StopFleetActionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopFleetActionsError {
    /// Creates a new `StopFleetActionsError`.
    pub fn new(kind: StopFleetActionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopFleetActionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopFleetActionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopFleetActionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopFleetActionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopFleetActionsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopFleetActionsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `StopFleetActionsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopFleetActionsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StopFleetActionsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, StopFleetActionsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `StopFleetActionsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopFleetActionsErrorKind::UnauthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `StopFleetActionsErrorKind::UnsupportedRegionException`.
    pub fn is_unsupported_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopFleetActionsErrorKind::UnsupportedRegionException(_)
        )
    }
}
impl std::error::Error for StopFleetActionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopFleetActionsErrorKind::InternalServiceException(_inner) => Some(_inner),
            StopFleetActionsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StopFleetActionsErrorKind::NotFoundException(_inner) => Some(_inner),
            StopFleetActionsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            StopFleetActionsErrorKind::UnsupportedRegionException(_inner) => Some(_inner),
            StopFleetActionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopGameSessionPlacement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopGameSessionPlacementError {
    /// Kind of error that occurred.
    pub kind: StopGameSessionPlacementErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopGameSessionPlacement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopGameSessionPlacementErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopGameSessionPlacementError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopGameSessionPlacementErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            StopGameSessionPlacementErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StopGameSessionPlacementErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            StopGameSessionPlacementErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            StopGameSessionPlacementErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopGameSessionPlacementError {
    fn code(&self) -> Option<&str> {
        StopGameSessionPlacementError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopGameSessionPlacementError {
    /// Creates a new `StopGameSessionPlacementError`.
    pub fn new(kind: StopGameSessionPlacementErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopGameSessionPlacementError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopGameSessionPlacementErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopGameSessionPlacementError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopGameSessionPlacementErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopGameSessionPlacementErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopGameSessionPlacementErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `StopGameSessionPlacementErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopGameSessionPlacementErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StopGameSessionPlacementErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopGameSessionPlacementErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StopGameSessionPlacementErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopGameSessionPlacementErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for StopGameSessionPlacementError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopGameSessionPlacementErrorKind::InternalServiceException(_inner) => Some(_inner),
            StopGameSessionPlacementErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StopGameSessionPlacementErrorKind::NotFoundException(_inner) => Some(_inner),
            StopGameSessionPlacementErrorKind::UnauthorizedException(_inner) => Some(_inner),
            StopGameSessionPlacementErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopMatchmaking` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopMatchmakingError {
    /// Kind of error that occurred.
    pub kind: StopMatchmakingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopMatchmaking` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopMatchmakingErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The requested operation is not supported in the Region specified.</p>
    UnsupportedRegionException(crate::error::UnsupportedRegionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopMatchmakingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopMatchmakingErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            StopMatchmakingErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StopMatchmakingErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            StopMatchmakingErrorKind::UnsupportedRegionException(_inner) => _inner.fmt(f),
            StopMatchmakingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopMatchmakingError {
    fn code(&self) -> Option<&str> {
        StopMatchmakingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopMatchmakingError {
    /// Creates a new `StopMatchmakingError`.
    pub fn new(kind: StopMatchmakingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopMatchmakingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopMatchmakingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopMatchmakingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopMatchmakingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopMatchmakingErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopMatchmakingErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `StopMatchmakingErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopMatchmakingErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StopMatchmakingErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, StopMatchmakingErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `StopMatchmakingErrorKind::UnsupportedRegionException`.
    pub fn is_unsupported_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopMatchmakingErrorKind::UnsupportedRegionException(_)
        )
    }
}
impl std::error::Error for StopMatchmakingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopMatchmakingErrorKind::InternalServiceException(_inner) => Some(_inner),
            StopMatchmakingErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StopMatchmakingErrorKind::NotFoundException(_inner) => Some(_inner),
            StopMatchmakingErrorKind::UnsupportedRegionException(_inner) => Some(_inner),
            StopMatchmakingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SuspendGameServerGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SuspendGameServerGroupError {
    /// Kind of error that occurred.
    pub kind: SuspendGameServerGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SuspendGameServerGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SuspendGameServerGroupErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SuspendGameServerGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SuspendGameServerGroupErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            SuspendGameServerGroupErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            SuspendGameServerGroupErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            SuspendGameServerGroupErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            SuspendGameServerGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SuspendGameServerGroupError {
    fn code(&self) -> Option<&str> {
        SuspendGameServerGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SuspendGameServerGroupError {
    /// Creates a new `SuspendGameServerGroupError`.
    pub fn new(kind: SuspendGameServerGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SuspendGameServerGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SuspendGameServerGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SuspendGameServerGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SuspendGameServerGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SuspendGameServerGroupErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            SuspendGameServerGroupErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `SuspendGameServerGroupErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            SuspendGameServerGroupErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `SuspendGameServerGroupErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SuspendGameServerGroupErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SuspendGameServerGroupErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            SuspendGameServerGroupErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for SuspendGameServerGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SuspendGameServerGroupErrorKind::InternalServiceException(_inner) => Some(_inner),
            SuspendGameServerGroupErrorKind::InvalidRequestException(_inner) => Some(_inner),
            SuspendGameServerGroupErrorKind::NotFoundException(_inner) => Some(_inner),
            SuspendGameServerGroupErrorKind::UnauthorizedException(_inner) => Some(_inner),
            SuspendGameServerGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying. </p>
    TaggingFailedException(crate::error::TaggingFailedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TaggingFailedException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TaggingFailedException`.
    pub fn is_tagging_failed_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::TaggingFailedException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InternalServiceException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            TagResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::TaggingFailedException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying. </p>
    TaggingFailedException(crate::error::TaggingFailedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::TaggingFailedException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::TaggingFailedException`.
    pub fn is_tagging_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::TaggingFailedException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InternalServiceException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UntagResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::TaggingFailedException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAliasError {
    /// Kind of error that occurred.
    pub kind: UpdateAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAliasErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAliasErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateAliasErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateAliasErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateAliasErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAliasError {
    fn code(&self) -> Option<&str> {
        UpdateAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAliasError {
    /// Creates a new `UpdateAliasError`.
    pub fn new(kind: UpdateAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAliasErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateAliasErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAliasErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAliasErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateAliasErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `UpdateAliasErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateAliasErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateAliasErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, UpdateAliasErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for UpdateAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAliasErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateAliasErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateAliasErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateAliasErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateBuild` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateBuildError {
    /// Kind of error that occurred.
    pub kind: UpdateBuildErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateBuild` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateBuildErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateBuildError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateBuildErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateBuildErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateBuildErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateBuildErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateBuildErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateBuildError {
    fn code(&self) -> Option<&str> {
        UpdateBuildError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateBuildError {
    /// Creates a new `UpdateBuildError`.
    pub fn new(kind: UpdateBuildErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateBuildError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateBuildErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateBuildError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateBuildErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateBuildErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBuildErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBuildErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateBuildErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `UpdateBuildErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateBuildErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateBuildErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, UpdateBuildErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for UpdateBuildError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateBuildErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateBuildErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateBuildErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateBuildErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateBuildErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateFleetAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFleetAttributesError {
    /// Kind of error that occurred.
    pub kind: UpdateFleetAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFleetAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFleetAttributesErrorKind {
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The requested operation would cause a conflict with the current state of a resource associated with the request and/or the fleet. Resolve the conflict before retrying.</p>
    InvalidFleetStatusException(crate::error::InvalidFleetStatusException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested operation would cause the resource to exceed the allowed service limit. Resolve the issue before retrying.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFleetAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFleetAttributesErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateFleetAttributesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateFleetAttributesErrorKind::InvalidFleetStatusException(_inner) => _inner.fmt(f),
            UpdateFleetAttributesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateFleetAttributesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateFleetAttributesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateFleetAttributesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateFleetAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFleetAttributesError {
    fn code(&self) -> Option<&str> {
        UpdateFleetAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFleetAttributesError {
    /// Creates a new `UpdateFleetAttributesError`.
    pub fn new(kind: UpdateFleetAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFleetAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFleetAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFleetAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFleetAttributesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateFleetAttributesErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetAttributesErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFleetAttributesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetAttributesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFleetAttributesErrorKind::InvalidFleetStatusException`.
    pub fn is_invalid_fleet_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetAttributesErrorKind::InvalidFleetStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFleetAttributesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetAttributesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFleetAttributesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetAttributesErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFleetAttributesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetAttributesErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFleetAttributesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetAttributesErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateFleetAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFleetAttributesErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateFleetAttributesErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateFleetAttributesErrorKind::InvalidFleetStatusException(_inner) => Some(_inner),
            UpdateFleetAttributesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateFleetAttributesErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateFleetAttributesErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateFleetAttributesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateFleetAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateFleetCapacity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFleetCapacityError {
    /// Kind of error that occurred.
    pub kind: UpdateFleetCapacityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFleetCapacity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFleetCapacityErrorKind {
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The requested operation would cause a conflict with the current state of a resource associated with the request and/or the fleet. Resolve the conflict before retrying.</p>
    InvalidFleetStatusException(crate::error::InvalidFleetStatusException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested operation would cause the resource to exceed the allowed service limit. Resolve the issue before retrying.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// <p>The requested operation is not supported in the Region specified.</p>
    UnsupportedRegionException(crate::error::UnsupportedRegionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFleetCapacityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFleetCapacityErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateFleetCapacityErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateFleetCapacityErrorKind::InvalidFleetStatusException(_inner) => _inner.fmt(f),
            UpdateFleetCapacityErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateFleetCapacityErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateFleetCapacityErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateFleetCapacityErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateFleetCapacityErrorKind::UnsupportedRegionException(_inner) => _inner.fmt(f),
            UpdateFleetCapacityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFleetCapacityError {
    fn code(&self) -> Option<&str> {
        UpdateFleetCapacityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFleetCapacityError {
    /// Creates a new `UpdateFleetCapacityError`.
    pub fn new(kind: UpdateFleetCapacityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFleetCapacityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFleetCapacityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFleetCapacityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFleetCapacityErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateFleetCapacityErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetCapacityErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFleetCapacityErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetCapacityErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFleetCapacityErrorKind::InvalidFleetStatusException`.
    pub fn is_invalid_fleet_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetCapacityErrorKind::InvalidFleetStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFleetCapacityErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetCapacityErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFleetCapacityErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetCapacityErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFleetCapacityErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetCapacityErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFleetCapacityErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetCapacityErrorKind::UnauthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFleetCapacityErrorKind::UnsupportedRegionException`.
    pub fn is_unsupported_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetCapacityErrorKind::UnsupportedRegionException(_)
        )
    }
}
impl std::error::Error for UpdateFleetCapacityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFleetCapacityErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateFleetCapacityErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateFleetCapacityErrorKind::InvalidFleetStatusException(_inner) => Some(_inner),
            UpdateFleetCapacityErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateFleetCapacityErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateFleetCapacityErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateFleetCapacityErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateFleetCapacityErrorKind::UnsupportedRegionException(_inner) => Some(_inner),
            UpdateFleetCapacityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateFleetPortSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFleetPortSettingsError {
    /// Kind of error that occurred.
    pub kind: UpdateFleetPortSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFleetPortSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFleetPortSettingsErrorKind {
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The requested operation would cause a conflict with the current state of a resource associated with the request and/or the fleet. Resolve the conflict before retrying.</p>
    InvalidFleetStatusException(crate::error::InvalidFleetStatusException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested operation would cause the resource to exceed the allowed service limit. Resolve the issue before retrying.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFleetPortSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFleetPortSettingsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateFleetPortSettingsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateFleetPortSettingsErrorKind::InvalidFleetStatusException(_inner) => _inner.fmt(f),
            UpdateFleetPortSettingsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateFleetPortSettingsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateFleetPortSettingsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateFleetPortSettingsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateFleetPortSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFleetPortSettingsError {
    fn code(&self) -> Option<&str> {
        UpdateFleetPortSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFleetPortSettingsError {
    /// Creates a new `UpdateFleetPortSettingsError`.
    pub fn new(kind: UpdateFleetPortSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFleetPortSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFleetPortSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFleetPortSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFleetPortSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateFleetPortSettingsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetPortSettingsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFleetPortSettingsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetPortSettingsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFleetPortSettingsErrorKind::InvalidFleetStatusException`.
    pub fn is_invalid_fleet_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetPortSettingsErrorKind::InvalidFleetStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFleetPortSettingsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetPortSettingsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFleetPortSettingsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetPortSettingsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFleetPortSettingsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetPortSettingsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFleetPortSettingsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetPortSettingsErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateFleetPortSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFleetPortSettingsErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateFleetPortSettingsErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateFleetPortSettingsErrorKind::InvalidFleetStatusException(_inner) => Some(_inner),
            UpdateFleetPortSettingsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateFleetPortSettingsErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateFleetPortSettingsErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateFleetPortSettingsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateFleetPortSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateGameServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateGameServerError {
    /// Kind of error that occurred.
    pub kind: UpdateGameServerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateGameServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateGameServerErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateGameServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateGameServerErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateGameServerErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateGameServerErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateGameServerErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateGameServerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateGameServerError {
    fn code(&self) -> Option<&str> {
        UpdateGameServerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateGameServerError {
    /// Creates a new `UpdateGameServerError`.
    pub fn new(kind: UpdateGameServerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateGameServerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateGameServerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateGameServerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateGameServerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateGameServerErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGameServerErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGameServerErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGameServerErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGameServerErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateGameServerErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateGameServerErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGameServerErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateGameServerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateGameServerErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateGameServerErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateGameServerErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateGameServerErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateGameServerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateGameServerGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateGameServerGroupError {
    /// Kind of error that occurred.
    pub kind: UpdateGameServerGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateGameServerGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateGameServerGroupErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateGameServerGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateGameServerGroupErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateGameServerGroupErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateGameServerGroupErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateGameServerGroupErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateGameServerGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateGameServerGroupError {
    fn code(&self) -> Option<&str> {
        UpdateGameServerGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateGameServerGroupError {
    /// Creates a new `UpdateGameServerGroupError`.
    pub fn new(kind: UpdateGameServerGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateGameServerGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateGameServerGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateGameServerGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateGameServerGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateGameServerGroupErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGameServerGroupErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGameServerGroupErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGameServerGroupErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGameServerGroupErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGameServerGroupErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGameServerGroupErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGameServerGroupErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateGameServerGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateGameServerGroupErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateGameServerGroupErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateGameServerGroupErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateGameServerGroupErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateGameServerGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateGameSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateGameSessionError {
    /// Kind of error that occurred.
    pub kind: UpdateGameSessionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateGameSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateGameSessionErrorKind {
    /// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The requested operation would cause a conflict with the current state of a resource associated with the request and/or the game instance. Resolve the conflict before retrying.</p>
    InvalidGameSessionStatusException(crate::error::InvalidGameSessionStatusException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateGameSessionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateGameSessionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateGameSessionErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateGameSessionErrorKind::InvalidGameSessionStatusException(_inner) => _inner.fmt(f),
            UpdateGameSessionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateGameSessionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateGameSessionErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateGameSessionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateGameSessionError {
    fn code(&self) -> Option<&str> {
        UpdateGameSessionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateGameSessionError {
    /// Creates a new `UpdateGameSessionError`.
    pub fn new(kind: UpdateGameSessionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateGameSessionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateGameSessionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateGameSessionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateGameSessionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateGameSessionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateGameSessionErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateGameSessionErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGameSessionErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGameSessionErrorKind::InvalidGameSessionStatusException`.
    pub fn is_invalid_game_session_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGameSessionErrorKind::InvalidGameSessionStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGameSessionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGameSessionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGameSessionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateGameSessionErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateGameSessionErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGameSessionErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateGameSessionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateGameSessionErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateGameSessionErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateGameSessionErrorKind::InvalidGameSessionStatusException(_inner) => Some(_inner),
            UpdateGameSessionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateGameSessionErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateGameSessionErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateGameSessionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateGameSessionQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateGameSessionQueueError {
    /// Kind of error that occurred.
    pub kind: UpdateGameSessionQueueErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateGameSessionQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateGameSessionQueueErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateGameSessionQueueError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateGameSessionQueueErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateGameSessionQueueErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateGameSessionQueueErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateGameSessionQueueErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateGameSessionQueueErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateGameSessionQueueError {
    fn code(&self) -> Option<&str> {
        UpdateGameSessionQueueError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateGameSessionQueueError {
    /// Creates a new `UpdateGameSessionQueueError`.
    pub fn new(kind: UpdateGameSessionQueueErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateGameSessionQueueError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateGameSessionQueueErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateGameSessionQueueError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateGameSessionQueueErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateGameSessionQueueErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGameSessionQueueErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGameSessionQueueErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGameSessionQueueErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGameSessionQueueErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGameSessionQueueErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGameSessionQueueErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGameSessionQueueErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateGameSessionQueueError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateGameSessionQueueErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateGameSessionQueueErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateGameSessionQueueErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateGameSessionQueueErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateGameSessionQueueErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateMatchmakingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateMatchmakingConfigurationError {
    /// Kind of error that occurred.
    pub kind: UpdateMatchmakingConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateMatchmakingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateMatchmakingConfigurationErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The requested operation is not supported in the Region specified.</p>
    UnsupportedRegionException(crate::error::UnsupportedRegionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateMatchmakingConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateMatchmakingConfigurationErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            UpdateMatchmakingConfigurationErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            UpdateMatchmakingConfigurationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateMatchmakingConfigurationErrorKind::UnsupportedRegionException(_inner) => {
                _inner.fmt(f)
            }
            UpdateMatchmakingConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateMatchmakingConfigurationError {
    fn code(&self) -> Option<&str> {
        UpdateMatchmakingConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateMatchmakingConfigurationError {
    /// Creates a new `UpdateMatchmakingConfigurationError`.
    pub fn new(
        kind: UpdateMatchmakingConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateMatchmakingConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateMatchmakingConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateMatchmakingConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateMatchmakingConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateMatchmakingConfigurationErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMatchmakingConfigurationErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMatchmakingConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMatchmakingConfigurationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMatchmakingConfigurationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMatchmakingConfigurationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMatchmakingConfigurationErrorKind::UnsupportedRegionException`.
    pub fn is_unsupported_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMatchmakingConfigurationErrorKind::UnsupportedRegionException(_)
        )
    }
}
impl std::error::Error for UpdateMatchmakingConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateMatchmakingConfigurationErrorKind::InternalServiceException(_inner) => {
                Some(_inner)
            }
            UpdateMatchmakingConfigurationErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            UpdateMatchmakingConfigurationErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateMatchmakingConfigurationErrorKind::UnsupportedRegionException(_inner) => {
                Some(_inner)
            }
            UpdateMatchmakingConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRuntimeConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRuntimeConfigurationError {
    /// Kind of error that occurred.
    pub kind: UpdateRuntimeConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRuntimeConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRuntimeConfigurationErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The requested operation would cause a conflict with the current state of a resource associated with the request and/or the fleet. Resolve the conflict before retrying.</p>
    InvalidFleetStatusException(crate::error::InvalidFleetStatusException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRuntimeConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRuntimeConfigurationErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateRuntimeConfigurationErrorKind::InvalidFleetStatusException(_inner) => {
                _inner.fmt(f)
            }
            UpdateRuntimeConfigurationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateRuntimeConfigurationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateRuntimeConfigurationErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateRuntimeConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRuntimeConfigurationError {
    fn code(&self) -> Option<&str> {
        UpdateRuntimeConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRuntimeConfigurationError {
    /// Creates a new `UpdateRuntimeConfigurationError`.
    pub fn new(kind: UpdateRuntimeConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRuntimeConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRuntimeConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRuntimeConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRuntimeConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateRuntimeConfigurationErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuntimeConfigurationErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRuntimeConfigurationErrorKind::InvalidFleetStatusException`.
    pub fn is_invalid_fleet_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuntimeConfigurationErrorKind::InvalidFleetStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRuntimeConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuntimeConfigurationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRuntimeConfigurationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuntimeConfigurationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRuntimeConfigurationErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuntimeConfigurationErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateRuntimeConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRuntimeConfigurationErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateRuntimeConfigurationErrorKind::InvalidFleetStatusException(_inner) => {
                Some(_inner)
            }
            UpdateRuntimeConfigurationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateRuntimeConfigurationErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateRuntimeConfigurationErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateRuntimeConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateScript` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateScriptError {
    /// Kind of error that occurred.
    pub kind: UpdateScriptErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateScript` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateScriptErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The client failed authentication. Clients should not retry such requests.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateScriptError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateScriptErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateScriptErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateScriptErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateScriptErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateScriptErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateScriptError {
    fn code(&self) -> Option<&str> {
        UpdateScriptError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateScriptError {
    /// Creates a new `UpdateScriptError`.
    pub fn new(kind: UpdateScriptErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateScriptError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateScriptErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateScriptError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateScriptErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateScriptErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateScriptErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateScriptErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateScriptErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateScriptErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateScriptErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateScriptErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, UpdateScriptErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for UpdateScriptError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateScriptErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateScriptErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateScriptErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateScriptErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateScriptErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ValidateMatchmakingRuleSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ValidateMatchmakingRuleSetError {
    /// Kind of error that occurred.
    pub kind: ValidateMatchmakingRuleSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ValidateMatchmakingRuleSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ValidateMatchmakingRuleSetErrorKind {
    /// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested operation is not supported in the Region specified.</p>
    UnsupportedRegionException(crate::error::UnsupportedRegionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ValidateMatchmakingRuleSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ValidateMatchmakingRuleSetErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ValidateMatchmakingRuleSetErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ValidateMatchmakingRuleSetErrorKind::UnsupportedRegionException(_inner) => {
                _inner.fmt(f)
            }
            ValidateMatchmakingRuleSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ValidateMatchmakingRuleSetError {
    fn code(&self) -> Option<&str> {
        ValidateMatchmakingRuleSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ValidateMatchmakingRuleSetError {
    /// Creates a new `ValidateMatchmakingRuleSetError`.
    pub fn new(kind: ValidateMatchmakingRuleSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ValidateMatchmakingRuleSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ValidateMatchmakingRuleSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ValidateMatchmakingRuleSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ValidateMatchmakingRuleSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ValidateMatchmakingRuleSetErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ValidateMatchmakingRuleSetErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ValidateMatchmakingRuleSetErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ValidateMatchmakingRuleSetErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ValidateMatchmakingRuleSetErrorKind::UnsupportedRegionException`.
    pub fn is_unsupported_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            ValidateMatchmakingRuleSetErrorKind::UnsupportedRegionException(_)
        )
    }
}
impl std::error::Error for ValidateMatchmakingRuleSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ValidateMatchmakingRuleSetErrorKind::InternalServiceException(_inner) => Some(_inner),
            ValidateMatchmakingRuleSetErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ValidateMatchmakingRuleSetErrorKind::UnsupportedRegionException(_inner) => Some(_inner),
            ValidateMatchmakingRuleSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The requested operation is not supported in the Region specified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedRegionException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedRegionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedRegionException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedRegionException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedRegionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedRegionException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedRegionException {}
/// See [`UnsupportedRegionException`](crate::error::UnsupportedRegionException)
pub mod unsupported_region_exception {
    /// A builder for [`UnsupportedRegionException`](crate::error::UnsupportedRegionException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedRegionException`](crate::error::UnsupportedRegionException)
        pub fn build(self) -> crate::error::UnsupportedRegionException {
            crate::error::UnsupportedRegionException {
                message: self.message,
            }
        }
    }
}
impl UnsupportedRegionException {
    /// Creates a new builder-style object to manufacture [`UnsupportedRegionException`](crate::error::UnsupportedRegionException)
    pub fn builder() -> crate::error::unsupported_region_exception::Builder {
        crate::error::unsupported_region_exception::Builder::default()
    }
}

/// <p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRequestException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRequestException {}
/// See [`InvalidRequestException`](crate::error::InvalidRequestException)
pub mod invalid_request_exception {
    /// A builder for [`InvalidRequestException`](crate::error::InvalidRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRequestException`](crate::error::InvalidRequestException)
        pub fn build(self) -> crate::error::InvalidRequestException {
            crate::error::InvalidRequestException {
                message: self.message,
            }
        }
    }
}
impl InvalidRequestException {
    /// Creates a new builder-style object to manufacture [`InvalidRequestException`](crate::error::InvalidRequestException)
    pub fn builder() -> crate::error::invalid_request_exception::Builder {
        crate::error::invalid_request_exception::Builder::default()
    }
}

/// <p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServiceException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServiceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServiceException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServiceException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServiceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServiceException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServiceException {}
/// See [`InternalServiceException`](crate::error::InternalServiceException)
pub mod internal_service_exception {
    /// A builder for [`InternalServiceException`](crate::error::InternalServiceException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServiceException`](crate::error::InternalServiceException)
        pub fn build(self) -> crate::error::InternalServiceException {
            crate::error::InternalServiceException {
                message: self.message,
            }
        }
    }
}
impl InternalServiceException {
    /// Creates a new builder-style object to manufacture [`InternalServiceException`](crate::error::InternalServiceException)
    pub fn builder() -> crate::error::internal_service_exception::Builder {
        crate::error::internal_service_exception::Builder::default()
    }
}

/// <p>The client failed authentication. Clients should not retry such requests.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnauthorizedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnauthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnauthorizedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnauthorizedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnauthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnauthorizedException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnauthorizedException {}
/// See [`UnauthorizedException`](crate::error::UnauthorizedException)
pub mod unauthorized_exception {
    /// A builder for [`UnauthorizedException`](crate::error::UnauthorizedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnauthorizedException`](crate::error::UnauthorizedException)
        pub fn build(self) -> crate::error::UnauthorizedException {
            crate::error::UnauthorizedException {
                message: self.message,
            }
        }
    }
}
impl UnauthorizedException {
    /// Creates a new builder-style object to manufacture [`UnauthorizedException`](crate::error::UnauthorizedException)
    pub fn builder() -> crate::error::unauthorized_exception::Builder {
        crate::error::unauthorized_exception::Builder::default()
    }
}

/// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotFoundException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotFoundException {}
/// See [`NotFoundException`](crate::error::NotFoundException)
pub mod not_found_exception {
    /// A builder for [`NotFoundException`](crate::error::NotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotFoundException`](crate::error::NotFoundException)
        pub fn build(self) -> crate::error::NotFoundException {
            crate::error::NotFoundException {
                message: self.message,
            }
        }
    }
}
impl NotFoundException {
    /// Creates a new builder-style object to manufacture [`NotFoundException`](crate::error::NotFoundException)
    pub fn builder() -> crate::error::not_found_exception::Builder {
        crate::error::not_found_exception::Builder::default()
    }
}

/// <p>The requested operation would cause a conflict with the current state of a resource associated with the request and/or the fleet. Resolve the conflict before retrying.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidFleetStatusException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidFleetStatusException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidFleetStatusException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidFleetStatusException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidFleetStatusException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidFleetStatusException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidFleetStatusException {}
/// See [`InvalidFleetStatusException`](crate::error::InvalidFleetStatusException)
pub mod invalid_fleet_status_exception {
    /// A builder for [`InvalidFleetStatusException`](crate::error::InvalidFleetStatusException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidFleetStatusException`](crate::error::InvalidFleetStatusException)
        pub fn build(self) -> crate::error::InvalidFleetStatusException {
            crate::error::InvalidFleetStatusException {
                message: self.message,
            }
        }
    }
}
impl InvalidFleetStatusException {
    /// Creates a new builder-style object to manufacture [`InvalidFleetStatusException`](crate::error::InvalidFleetStatusException)
    pub fn builder() -> crate::error::invalid_fleet_status_exception::Builder {
        crate::error::invalid_fleet_status_exception::Builder::default()
    }
}

/// <p>The requested operation would cause a conflict with the current state of a resource associated with the request and/or the game instance. Resolve the conflict before retrying.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidGameSessionStatusException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidGameSessionStatusException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidGameSessionStatusException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidGameSessionStatusException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidGameSessionStatusException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidGameSessionStatusException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidGameSessionStatusException {}
/// See [`InvalidGameSessionStatusException`](crate::error::InvalidGameSessionStatusException)
pub mod invalid_game_session_status_exception {
    /// A builder for [`InvalidGameSessionStatusException`](crate::error::InvalidGameSessionStatusException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidGameSessionStatusException`](crate::error::InvalidGameSessionStatusException)
        pub fn build(self) -> crate::error::InvalidGameSessionStatusException {
            crate::error::InvalidGameSessionStatusException {
                message: self.message,
            }
        }
    }
}
impl InvalidGameSessionStatusException {
    /// Creates a new builder-style object to manufacture [`InvalidGameSessionStatusException`](crate::error::InvalidGameSessionStatusException)
    pub fn builder() -> crate::error::invalid_game_session_status_exception::Builder {
        crate::error::invalid_game_session_status_exception::Builder::default()
    }
}

/// <p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>The requested operation would cause the resource to exceed the allowed service limit. Resolve the issue before retrying.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p> The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TaggingFailedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TaggingFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TaggingFailedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TaggingFailedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TaggingFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TaggingFailedException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for TaggingFailedException {}
/// See [`TaggingFailedException`](crate::error::TaggingFailedException)
pub mod tagging_failed_exception {
    /// A builder for [`TaggingFailedException`](crate::error::TaggingFailedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TaggingFailedException`](crate::error::TaggingFailedException)
        pub fn build(self) -> crate::error::TaggingFailedException {
            crate::error::TaggingFailedException {
                message: self.message,
            }
        }
    }
}
impl TaggingFailedException {
    /// Creates a new builder-style object to manufacture [`TaggingFailedException`](crate::error::TaggingFailedException)
    pub fn builder() -> crate::error::tagging_failed_exception::Builder {
        crate::error::tagging_failed_exception::Builder::default()
    }
}

/// <p>The service is unable to resolve the routing for a particular alias because it has a terminal <code>RoutingStrategy</code> associated with it. The message returned in this exception is the message defined in the routing strategy itself. Such requests should only be retried if the routing strategy for the specified alias is modified. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TerminalRoutingStrategyException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TerminalRoutingStrategyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TerminalRoutingStrategyException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TerminalRoutingStrategyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TerminalRoutingStrategyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TerminalRoutingStrategyException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for TerminalRoutingStrategyException {}
/// See [`TerminalRoutingStrategyException`](crate::error::TerminalRoutingStrategyException)
pub mod terminal_routing_strategy_exception {
    /// A builder for [`TerminalRoutingStrategyException`](crate::error::TerminalRoutingStrategyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TerminalRoutingStrategyException`](crate::error::TerminalRoutingStrategyException)
        pub fn build(self) -> crate::error::TerminalRoutingStrategyException {
            crate::error::TerminalRoutingStrategyException {
                message: self.message,
            }
        }
    }
}
impl TerminalRoutingStrategyException {
    /// Creates a new builder-style object to manufacture [`TerminalRoutingStrategyException`](crate::error::TerminalRoutingStrategyException)
    pub fn builder() -> crate::error::terminal_routing_strategy_exception::Builder {
        crate::error::terminal_routing_strategy_exception::Builder::default()
    }
}

/// <p>The game instance is currently full and cannot allow the requested player(s) to join. Clients can retry such requests immediately or after a waiting period.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GameSessionFullException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GameSessionFullException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GameSessionFullException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl GameSessionFullException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for GameSessionFullException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "GameSessionFullException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for GameSessionFullException {}
/// See [`GameSessionFullException`](crate::error::GameSessionFullException)
pub mod game_session_full_exception {
    /// A builder for [`GameSessionFullException`](crate::error::GameSessionFullException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`GameSessionFullException`](crate::error::GameSessionFullException)
        pub fn build(self) -> crate::error::GameSessionFullException {
            crate::error::GameSessionFullException {
                message: self.message,
            }
        }
    }
}
impl GameSessionFullException {
    /// Creates a new builder-style object to manufacture [`GameSessionFullException`](crate::error::GameSessionFullException)
    pub fn builder() -> crate::error::game_session_full_exception::Builder {
        crate::error::game_session_full_exception::Builder::default()
    }
}

/// <p>A game session with this custom ID string already exists in this fleet. Resolve this conflict before retrying this request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IdempotentParameterMismatchException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IdempotentParameterMismatchException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IdempotentParameterMismatchException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IdempotentParameterMismatchException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IdempotentParameterMismatchException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IdempotentParameterMismatchException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for IdempotentParameterMismatchException {}
/// See [`IdempotentParameterMismatchException`](crate::error::IdempotentParameterMismatchException)
pub mod idempotent_parameter_mismatch_exception {
    /// A builder for [`IdempotentParameterMismatchException`](crate::error::IdempotentParameterMismatchException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IdempotentParameterMismatchException`](crate::error::IdempotentParameterMismatchException)
        pub fn build(self) -> crate::error::IdempotentParameterMismatchException {
            crate::error::IdempotentParameterMismatchException {
                message: self.message,
            }
        }
    }
}
impl IdempotentParameterMismatchException {
    /// Creates a new builder-style object to manufacture [`IdempotentParameterMismatchException`](crate::error::IdempotentParameterMismatchException)
    pub fn builder() -> crate::error::idempotent_parameter_mismatch_exception::Builder {
        crate::error::idempotent_parameter_mismatch_exception::Builder::default()
    }
}

/// <p>The specified fleet has no available instances to fulfill a <code>CreateGameSession</code> request. Clients can retry such requests immediately or after a waiting period.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FleetCapacityExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FleetCapacityExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FleetCapacityExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl FleetCapacityExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for FleetCapacityExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "FleetCapacityExceededException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for FleetCapacityExceededException {}
/// See [`FleetCapacityExceededException`](crate::error::FleetCapacityExceededException)
pub mod fleet_capacity_exceeded_exception {
    /// A builder for [`FleetCapacityExceededException`](crate::error::FleetCapacityExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`FleetCapacityExceededException`](crate::error::FleetCapacityExceededException)
        pub fn build(self) -> crate::error::FleetCapacityExceededException {
            crate::error::FleetCapacityExceededException {
                message: self.message,
            }
        }
    }
}
impl FleetCapacityExceededException {
    /// Creates a new builder-style object to manufacture [`FleetCapacityExceededException`](crate::error::FleetCapacityExceededException)
    pub fn builder() -> crate::error::fleet_capacity_exceeded_exception::Builder {
        crate::error::fleet_capacity_exceeded_exception::Builder::default()
    }
}

/// <p>The specified game server group has no available game servers to fulfill a <code>ClaimGameServer</code> request. Clients can retry such requests immediately or after a waiting period. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutOfCapacityException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OutOfCapacityException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutOfCapacityException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OutOfCapacityException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OutOfCapacityException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OutOfCapacityException")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for OutOfCapacityException {}
/// See [`OutOfCapacityException`](crate::error::OutOfCapacityException)
pub mod out_of_capacity_exception {
    /// A builder for [`OutOfCapacityException`](crate::error::OutOfCapacityException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OutOfCapacityException`](crate::error::OutOfCapacityException)
        pub fn build(self) -> crate::error::OutOfCapacityException {
            crate::error::OutOfCapacityException {
                message: self.message,
            }
        }
    }
}
impl OutOfCapacityException {
    /// Creates a new builder-style object to manufacture [`OutOfCapacityException`](crate::error::OutOfCapacityException)
    pub fn builder() -> crate::error::out_of_capacity_exception::Builder {
        crate::error::out_of_capacity_exception::Builder::default()
    }
}
