// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AcceptMatch`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`accept_match`](crate::client::Client::accept_match).
///
/// See [`crate::client::fluent_builders::AcceptMatch`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AcceptMatch {
    _private: (),
}
impl AcceptMatch {
    /// Creates a new builder-style object to manufacture [`AcceptMatchInput`](crate::input::AcceptMatchInput)
    pub fn builder() -> crate::input::accept_match_input::Builder {
        crate::input::accept_match_input::Builder::default()
    }
    /// Creates a new `AcceptMatch` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AcceptMatch {
    type Output =
        std::result::Result<crate::output::AcceptMatchOutput, crate::error::AcceptMatchError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_accept_match_error(response)
        } else {
            crate::operation_deser::parse_accept_match_response(response)
        }
    }
}

/// Operation shape for `ClaimGameServer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`claim_game_server`](crate::client::Client::claim_game_server).
///
/// See [`crate::client::fluent_builders::ClaimGameServer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ClaimGameServer {
    _private: (),
}
impl ClaimGameServer {
    /// Creates a new builder-style object to manufacture [`ClaimGameServerInput`](crate::input::ClaimGameServerInput)
    pub fn builder() -> crate::input::claim_game_server_input::Builder {
        crate::input::claim_game_server_input::Builder::default()
    }
    /// Creates a new `ClaimGameServer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ClaimGameServer {
    type Output = std::result::Result<
        crate::output::ClaimGameServerOutput,
        crate::error::ClaimGameServerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_claim_game_server_error(response)
        } else {
            crate::operation_deser::parse_claim_game_server_response(response)
        }
    }
}

/// Operation shape for `CreateAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_alias`](crate::client::Client::create_alias).
///
/// See [`crate::client::fluent_builders::CreateAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAlias {
    _private: (),
}
impl CreateAlias {
    /// Creates a new builder-style object to manufacture [`CreateAliasInput`](crate::input::CreateAliasInput)
    pub fn builder() -> crate::input::create_alias_input::Builder {
        crate::input::create_alias_input::Builder::default()
    }
    /// Creates a new `CreateAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAlias {
    type Output =
        std::result::Result<crate::output::CreateAliasOutput, crate::error::CreateAliasError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_alias_error(response)
        } else {
            crate::operation_deser::parse_create_alias_response(response)
        }
    }
}

/// Operation shape for `CreateBuild`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_build`](crate::client::Client::create_build).
///
/// See [`crate::client::fluent_builders::CreateBuild`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateBuild {
    _private: (),
}
impl CreateBuild {
    /// Creates a new builder-style object to manufacture [`CreateBuildInput`](crate::input::CreateBuildInput)
    pub fn builder() -> crate::input::create_build_input::Builder {
        crate::input::create_build_input::Builder::default()
    }
    /// Creates a new `CreateBuild` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateBuild {
    type Output =
        std::result::Result<crate::output::CreateBuildOutput, crate::error::CreateBuildError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_build_error(response)
        } else {
            crate::operation_deser::parse_create_build_response(response)
        }
    }
}

/// Operation shape for `CreateFleet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_fleet`](crate::client::Client::create_fleet).
///
/// See [`crate::client::fluent_builders::CreateFleet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFleet {
    _private: (),
}
impl CreateFleet {
    /// Creates a new builder-style object to manufacture [`CreateFleetInput`](crate::input::CreateFleetInput)
    pub fn builder() -> crate::input::create_fleet_input::Builder {
        crate::input::create_fleet_input::Builder::default()
    }
    /// Creates a new `CreateFleet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFleet {
    type Output =
        std::result::Result<crate::output::CreateFleetOutput, crate::error::CreateFleetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_fleet_error(response)
        } else {
            crate::operation_deser::parse_create_fleet_response(response)
        }
    }
}

/// Operation shape for `CreateFleetLocations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_fleet_locations`](crate::client::Client::create_fleet_locations).
///
/// See [`crate::client::fluent_builders::CreateFleetLocations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFleetLocations {
    _private: (),
}
impl CreateFleetLocations {
    /// Creates a new builder-style object to manufacture [`CreateFleetLocationsInput`](crate::input::CreateFleetLocationsInput)
    pub fn builder() -> crate::input::create_fleet_locations_input::Builder {
        crate::input::create_fleet_locations_input::Builder::default()
    }
    /// Creates a new `CreateFleetLocations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFleetLocations {
    type Output = std::result::Result<
        crate::output::CreateFleetLocationsOutput,
        crate::error::CreateFleetLocationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_fleet_locations_error(response)
        } else {
            crate::operation_deser::parse_create_fleet_locations_response(response)
        }
    }
}

/// Operation shape for `CreateGameServerGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_game_server_group`](crate::client::Client::create_game_server_group).
///
/// See [`crate::client::fluent_builders::CreateGameServerGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateGameServerGroup {
    _private: (),
}
impl CreateGameServerGroup {
    /// Creates a new builder-style object to manufacture [`CreateGameServerGroupInput`](crate::input::CreateGameServerGroupInput)
    pub fn builder() -> crate::input::create_game_server_group_input::Builder {
        crate::input::create_game_server_group_input::Builder::default()
    }
    /// Creates a new `CreateGameServerGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateGameServerGroup {
    type Output = std::result::Result<
        crate::output::CreateGameServerGroupOutput,
        crate::error::CreateGameServerGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_game_server_group_error(response)
        } else {
            crate::operation_deser::parse_create_game_server_group_response(response)
        }
    }
}

/// Operation shape for `CreateGameSession`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_game_session`](crate::client::Client::create_game_session).
///
/// See [`crate::client::fluent_builders::CreateGameSession`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateGameSession {
    _private: (),
}
impl CreateGameSession {
    /// Creates a new builder-style object to manufacture [`CreateGameSessionInput`](crate::input::CreateGameSessionInput)
    pub fn builder() -> crate::input::create_game_session_input::Builder {
        crate::input::create_game_session_input::Builder::default()
    }
    /// Creates a new `CreateGameSession` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateGameSession {
    type Output = std::result::Result<
        crate::output::CreateGameSessionOutput,
        crate::error::CreateGameSessionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_game_session_error(response)
        } else {
            crate::operation_deser::parse_create_game_session_response(response)
        }
    }
}

/// Operation shape for `CreateGameSessionQueue`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_game_session_queue`](crate::client::Client::create_game_session_queue).
///
/// See [`crate::client::fluent_builders::CreateGameSessionQueue`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateGameSessionQueue {
    _private: (),
}
impl CreateGameSessionQueue {
    /// Creates a new builder-style object to manufacture [`CreateGameSessionQueueInput`](crate::input::CreateGameSessionQueueInput)
    pub fn builder() -> crate::input::create_game_session_queue_input::Builder {
        crate::input::create_game_session_queue_input::Builder::default()
    }
    /// Creates a new `CreateGameSessionQueue` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateGameSessionQueue {
    type Output = std::result::Result<
        crate::output::CreateGameSessionQueueOutput,
        crate::error::CreateGameSessionQueueError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_game_session_queue_error(response)
        } else {
            crate::operation_deser::parse_create_game_session_queue_response(response)
        }
    }
}

/// Operation shape for `CreateMatchmakingConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_matchmaking_configuration`](crate::client::Client::create_matchmaking_configuration).
///
/// See [`crate::client::fluent_builders::CreateMatchmakingConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateMatchmakingConfiguration {
    _private: (),
}
impl CreateMatchmakingConfiguration {
    /// Creates a new builder-style object to manufacture [`CreateMatchmakingConfigurationInput`](crate::input::CreateMatchmakingConfigurationInput)
    pub fn builder() -> crate::input::create_matchmaking_configuration_input::Builder {
        crate::input::create_matchmaking_configuration_input::Builder::default()
    }
    /// Creates a new `CreateMatchmakingConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateMatchmakingConfiguration {
    type Output = std::result::Result<
        crate::output::CreateMatchmakingConfigurationOutput,
        crate::error::CreateMatchmakingConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_matchmaking_configuration_error(response)
        } else {
            crate::operation_deser::parse_create_matchmaking_configuration_response(response)
        }
    }
}

/// Operation shape for `CreateMatchmakingRuleSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_matchmaking_rule_set`](crate::client::Client::create_matchmaking_rule_set).
///
/// See [`crate::client::fluent_builders::CreateMatchmakingRuleSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateMatchmakingRuleSet {
    _private: (),
}
impl CreateMatchmakingRuleSet {
    /// Creates a new builder-style object to manufacture [`CreateMatchmakingRuleSetInput`](crate::input::CreateMatchmakingRuleSetInput)
    pub fn builder() -> crate::input::create_matchmaking_rule_set_input::Builder {
        crate::input::create_matchmaking_rule_set_input::Builder::default()
    }
    /// Creates a new `CreateMatchmakingRuleSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateMatchmakingRuleSet {
    type Output = std::result::Result<
        crate::output::CreateMatchmakingRuleSetOutput,
        crate::error::CreateMatchmakingRuleSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_matchmaking_rule_set_error(response)
        } else {
            crate::operation_deser::parse_create_matchmaking_rule_set_response(response)
        }
    }
}

/// Operation shape for `CreatePlayerSession`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_player_session`](crate::client::Client::create_player_session).
///
/// See [`crate::client::fluent_builders::CreatePlayerSession`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePlayerSession {
    _private: (),
}
impl CreatePlayerSession {
    /// Creates a new builder-style object to manufacture [`CreatePlayerSessionInput`](crate::input::CreatePlayerSessionInput)
    pub fn builder() -> crate::input::create_player_session_input::Builder {
        crate::input::create_player_session_input::Builder::default()
    }
    /// Creates a new `CreatePlayerSession` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePlayerSession {
    type Output = std::result::Result<
        crate::output::CreatePlayerSessionOutput,
        crate::error::CreatePlayerSessionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_player_session_error(response)
        } else {
            crate::operation_deser::parse_create_player_session_response(response)
        }
    }
}

/// Operation shape for `CreatePlayerSessions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_player_sessions`](crate::client::Client::create_player_sessions).
///
/// See [`crate::client::fluent_builders::CreatePlayerSessions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePlayerSessions {
    _private: (),
}
impl CreatePlayerSessions {
    /// Creates a new builder-style object to manufacture [`CreatePlayerSessionsInput`](crate::input::CreatePlayerSessionsInput)
    pub fn builder() -> crate::input::create_player_sessions_input::Builder {
        crate::input::create_player_sessions_input::Builder::default()
    }
    /// Creates a new `CreatePlayerSessions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePlayerSessions {
    type Output = std::result::Result<
        crate::output::CreatePlayerSessionsOutput,
        crate::error::CreatePlayerSessionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_player_sessions_error(response)
        } else {
            crate::operation_deser::parse_create_player_sessions_response(response)
        }
    }
}

/// Operation shape for `CreateScript`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_script`](crate::client::Client::create_script).
///
/// See [`crate::client::fluent_builders::CreateScript`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateScript {
    _private: (),
}
impl CreateScript {
    /// Creates a new builder-style object to manufacture [`CreateScriptInput`](crate::input::CreateScriptInput)
    pub fn builder() -> crate::input::create_script_input::Builder {
        crate::input::create_script_input::Builder::default()
    }
    /// Creates a new `CreateScript` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateScript {
    type Output =
        std::result::Result<crate::output::CreateScriptOutput, crate::error::CreateScriptError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_script_error(response)
        } else {
            crate::operation_deser::parse_create_script_response(response)
        }
    }
}

/// Operation shape for `CreateVpcPeeringAuthorization`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_vpc_peering_authorization`](crate::client::Client::create_vpc_peering_authorization).
///
/// See [`crate::client::fluent_builders::CreateVpcPeeringAuthorization`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateVpcPeeringAuthorization {
    _private: (),
}
impl CreateVpcPeeringAuthorization {
    /// Creates a new builder-style object to manufacture [`CreateVpcPeeringAuthorizationInput`](crate::input::CreateVpcPeeringAuthorizationInput)
    pub fn builder() -> crate::input::create_vpc_peering_authorization_input::Builder {
        crate::input::create_vpc_peering_authorization_input::Builder::default()
    }
    /// Creates a new `CreateVpcPeeringAuthorization` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateVpcPeeringAuthorization {
    type Output = std::result::Result<
        crate::output::CreateVpcPeeringAuthorizationOutput,
        crate::error::CreateVpcPeeringAuthorizationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_vpc_peering_authorization_error(response)
        } else {
            crate::operation_deser::parse_create_vpc_peering_authorization_response(response)
        }
    }
}

/// Operation shape for `CreateVpcPeeringConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_vpc_peering_connection`](crate::client::Client::create_vpc_peering_connection).
///
/// See [`crate::client::fluent_builders::CreateVpcPeeringConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateVpcPeeringConnection {
    _private: (),
}
impl CreateVpcPeeringConnection {
    /// Creates a new builder-style object to manufacture [`CreateVpcPeeringConnectionInput`](crate::input::CreateVpcPeeringConnectionInput)
    pub fn builder() -> crate::input::create_vpc_peering_connection_input::Builder {
        crate::input::create_vpc_peering_connection_input::Builder::default()
    }
    /// Creates a new `CreateVpcPeeringConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateVpcPeeringConnection {
    type Output = std::result::Result<
        crate::output::CreateVpcPeeringConnectionOutput,
        crate::error::CreateVpcPeeringConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_vpc_peering_connection_error(response)
        } else {
            crate::operation_deser::parse_create_vpc_peering_connection_response(response)
        }
    }
}

/// Operation shape for `DeleteAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_alias`](crate::client::Client::delete_alias).
///
/// See [`crate::client::fluent_builders::DeleteAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAlias {
    _private: (),
}
impl DeleteAlias {
    /// Creates a new builder-style object to manufacture [`DeleteAliasInput`](crate::input::DeleteAliasInput)
    pub fn builder() -> crate::input::delete_alias_input::Builder {
        crate::input::delete_alias_input::Builder::default()
    }
    /// Creates a new `DeleteAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAlias {
    type Output =
        std::result::Result<crate::output::DeleteAliasOutput, crate::error::DeleteAliasError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_alias_error(response)
        } else {
            crate::operation_deser::parse_delete_alias_response(response)
        }
    }
}

/// Operation shape for `DeleteBuild`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_build`](crate::client::Client::delete_build).
///
/// See [`crate::client::fluent_builders::DeleteBuild`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBuild {
    _private: (),
}
impl DeleteBuild {
    /// Creates a new builder-style object to manufacture [`DeleteBuildInput`](crate::input::DeleteBuildInput)
    pub fn builder() -> crate::input::delete_build_input::Builder {
        crate::input::delete_build_input::Builder::default()
    }
    /// Creates a new `DeleteBuild` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBuild {
    type Output =
        std::result::Result<crate::output::DeleteBuildOutput, crate::error::DeleteBuildError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_build_error(response)
        } else {
            crate::operation_deser::parse_delete_build_response(response)
        }
    }
}

/// Operation shape for `DeleteFleet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_fleet`](crate::client::Client::delete_fleet).
///
/// See [`crate::client::fluent_builders::DeleteFleet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFleet {
    _private: (),
}
impl DeleteFleet {
    /// Creates a new builder-style object to manufacture [`DeleteFleetInput`](crate::input::DeleteFleetInput)
    pub fn builder() -> crate::input::delete_fleet_input::Builder {
        crate::input::delete_fleet_input::Builder::default()
    }
    /// Creates a new `DeleteFleet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFleet {
    type Output =
        std::result::Result<crate::output::DeleteFleetOutput, crate::error::DeleteFleetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_fleet_error(response)
        } else {
            crate::operation_deser::parse_delete_fleet_response(response)
        }
    }
}

/// Operation shape for `DeleteFleetLocations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_fleet_locations`](crate::client::Client::delete_fleet_locations).
///
/// See [`crate::client::fluent_builders::DeleteFleetLocations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFleetLocations {
    _private: (),
}
impl DeleteFleetLocations {
    /// Creates a new builder-style object to manufacture [`DeleteFleetLocationsInput`](crate::input::DeleteFleetLocationsInput)
    pub fn builder() -> crate::input::delete_fleet_locations_input::Builder {
        crate::input::delete_fleet_locations_input::Builder::default()
    }
    /// Creates a new `DeleteFleetLocations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFleetLocations {
    type Output = std::result::Result<
        crate::output::DeleteFleetLocationsOutput,
        crate::error::DeleteFleetLocationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_fleet_locations_error(response)
        } else {
            crate::operation_deser::parse_delete_fleet_locations_response(response)
        }
    }
}

/// Operation shape for `DeleteGameServerGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_game_server_group`](crate::client::Client::delete_game_server_group).
///
/// See [`crate::client::fluent_builders::DeleteGameServerGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteGameServerGroup {
    _private: (),
}
impl DeleteGameServerGroup {
    /// Creates a new builder-style object to manufacture [`DeleteGameServerGroupInput`](crate::input::DeleteGameServerGroupInput)
    pub fn builder() -> crate::input::delete_game_server_group_input::Builder {
        crate::input::delete_game_server_group_input::Builder::default()
    }
    /// Creates a new `DeleteGameServerGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteGameServerGroup {
    type Output = std::result::Result<
        crate::output::DeleteGameServerGroupOutput,
        crate::error::DeleteGameServerGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_game_server_group_error(response)
        } else {
            crate::operation_deser::parse_delete_game_server_group_response(response)
        }
    }
}

/// Operation shape for `DeleteGameSessionQueue`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_game_session_queue`](crate::client::Client::delete_game_session_queue).
///
/// See [`crate::client::fluent_builders::DeleteGameSessionQueue`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteGameSessionQueue {
    _private: (),
}
impl DeleteGameSessionQueue {
    /// Creates a new builder-style object to manufacture [`DeleteGameSessionQueueInput`](crate::input::DeleteGameSessionQueueInput)
    pub fn builder() -> crate::input::delete_game_session_queue_input::Builder {
        crate::input::delete_game_session_queue_input::Builder::default()
    }
    /// Creates a new `DeleteGameSessionQueue` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteGameSessionQueue {
    type Output = std::result::Result<
        crate::output::DeleteGameSessionQueueOutput,
        crate::error::DeleteGameSessionQueueError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_game_session_queue_error(response)
        } else {
            crate::operation_deser::parse_delete_game_session_queue_response(response)
        }
    }
}

/// Operation shape for `DeleteMatchmakingConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_matchmaking_configuration`](crate::client::Client::delete_matchmaking_configuration).
///
/// See [`crate::client::fluent_builders::DeleteMatchmakingConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteMatchmakingConfiguration {
    _private: (),
}
impl DeleteMatchmakingConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteMatchmakingConfigurationInput`](crate::input::DeleteMatchmakingConfigurationInput)
    pub fn builder() -> crate::input::delete_matchmaking_configuration_input::Builder {
        crate::input::delete_matchmaking_configuration_input::Builder::default()
    }
    /// Creates a new `DeleteMatchmakingConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteMatchmakingConfiguration {
    type Output = std::result::Result<
        crate::output::DeleteMatchmakingConfigurationOutput,
        crate::error::DeleteMatchmakingConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_matchmaking_configuration_error(response)
        } else {
            crate::operation_deser::parse_delete_matchmaking_configuration_response(response)
        }
    }
}

/// Operation shape for `DeleteMatchmakingRuleSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_matchmaking_rule_set`](crate::client::Client::delete_matchmaking_rule_set).
///
/// See [`crate::client::fluent_builders::DeleteMatchmakingRuleSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteMatchmakingRuleSet {
    _private: (),
}
impl DeleteMatchmakingRuleSet {
    /// Creates a new builder-style object to manufacture [`DeleteMatchmakingRuleSetInput`](crate::input::DeleteMatchmakingRuleSetInput)
    pub fn builder() -> crate::input::delete_matchmaking_rule_set_input::Builder {
        crate::input::delete_matchmaking_rule_set_input::Builder::default()
    }
    /// Creates a new `DeleteMatchmakingRuleSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteMatchmakingRuleSet {
    type Output = std::result::Result<
        crate::output::DeleteMatchmakingRuleSetOutput,
        crate::error::DeleteMatchmakingRuleSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_matchmaking_rule_set_error(response)
        } else {
            crate::operation_deser::parse_delete_matchmaking_rule_set_response(response)
        }
    }
}

/// Operation shape for `DeleteScalingPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_scaling_policy`](crate::client::Client::delete_scaling_policy).
///
/// See [`crate::client::fluent_builders::DeleteScalingPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteScalingPolicy {
    _private: (),
}
impl DeleteScalingPolicy {
    /// Creates a new builder-style object to manufacture [`DeleteScalingPolicyInput`](crate::input::DeleteScalingPolicyInput)
    pub fn builder() -> crate::input::delete_scaling_policy_input::Builder {
        crate::input::delete_scaling_policy_input::Builder::default()
    }
    /// Creates a new `DeleteScalingPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteScalingPolicy {
    type Output = std::result::Result<
        crate::output::DeleteScalingPolicyOutput,
        crate::error::DeleteScalingPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_scaling_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_scaling_policy_response(response)
        }
    }
}

/// Operation shape for `DeleteScript`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_script`](crate::client::Client::delete_script).
///
/// See [`crate::client::fluent_builders::DeleteScript`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteScript {
    _private: (),
}
impl DeleteScript {
    /// Creates a new builder-style object to manufacture [`DeleteScriptInput`](crate::input::DeleteScriptInput)
    pub fn builder() -> crate::input::delete_script_input::Builder {
        crate::input::delete_script_input::Builder::default()
    }
    /// Creates a new `DeleteScript` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteScript {
    type Output =
        std::result::Result<crate::output::DeleteScriptOutput, crate::error::DeleteScriptError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_script_error(response)
        } else {
            crate::operation_deser::parse_delete_script_response(response)
        }
    }
}

/// Operation shape for `DeleteVpcPeeringAuthorization`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_vpc_peering_authorization`](crate::client::Client::delete_vpc_peering_authorization).
///
/// See [`crate::client::fluent_builders::DeleteVpcPeeringAuthorization`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVpcPeeringAuthorization {
    _private: (),
}
impl DeleteVpcPeeringAuthorization {
    /// Creates a new builder-style object to manufacture [`DeleteVpcPeeringAuthorizationInput`](crate::input::DeleteVpcPeeringAuthorizationInput)
    pub fn builder() -> crate::input::delete_vpc_peering_authorization_input::Builder {
        crate::input::delete_vpc_peering_authorization_input::Builder::default()
    }
    /// Creates a new `DeleteVpcPeeringAuthorization` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVpcPeeringAuthorization {
    type Output = std::result::Result<
        crate::output::DeleteVpcPeeringAuthorizationOutput,
        crate::error::DeleteVpcPeeringAuthorizationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_vpc_peering_authorization_error(response)
        } else {
            crate::operation_deser::parse_delete_vpc_peering_authorization_response(response)
        }
    }
}

/// Operation shape for `DeleteVpcPeeringConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_vpc_peering_connection`](crate::client::Client::delete_vpc_peering_connection).
///
/// See [`crate::client::fluent_builders::DeleteVpcPeeringConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVpcPeeringConnection {
    _private: (),
}
impl DeleteVpcPeeringConnection {
    /// Creates a new builder-style object to manufacture [`DeleteVpcPeeringConnectionInput`](crate::input::DeleteVpcPeeringConnectionInput)
    pub fn builder() -> crate::input::delete_vpc_peering_connection_input::Builder {
        crate::input::delete_vpc_peering_connection_input::Builder::default()
    }
    /// Creates a new `DeleteVpcPeeringConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVpcPeeringConnection {
    type Output = std::result::Result<
        crate::output::DeleteVpcPeeringConnectionOutput,
        crate::error::DeleteVpcPeeringConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_vpc_peering_connection_error(response)
        } else {
            crate::operation_deser::parse_delete_vpc_peering_connection_response(response)
        }
    }
}

/// Operation shape for `DeregisterGameServer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_game_server`](crate::client::Client::deregister_game_server).
///
/// See [`crate::client::fluent_builders::DeregisterGameServer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterGameServer {
    _private: (),
}
impl DeregisterGameServer {
    /// Creates a new builder-style object to manufacture [`DeregisterGameServerInput`](crate::input::DeregisterGameServerInput)
    pub fn builder() -> crate::input::deregister_game_server_input::Builder {
        crate::input::deregister_game_server_input::Builder::default()
    }
    /// Creates a new `DeregisterGameServer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeregisterGameServer {
    type Output = std::result::Result<
        crate::output::DeregisterGameServerOutput,
        crate::error::DeregisterGameServerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_game_server_error(response)
        } else {
            crate::operation_deser::parse_deregister_game_server_response(response)
        }
    }
}

/// Operation shape for `DescribeAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_alias`](crate::client::Client::describe_alias).
///
/// See [`crate::client::fluent_builders::DescribeAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAlias {
    _private: (),
}
impl DescribeAlias {
    /// Creates a new builder-style object to manufacture [`DescribeAliasInput`](crate::input::DescribeAliasInput)
    pub fn builder() -> crate::input::describe_alias_input::Builder {
        crate::input::describe_alias_input::Builder::default()
    }
    /// Creates a new `DescribeAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAlias {
    type Output =
        std::result::Result<crate::output::DescribeAliasOutput, crate::error::DescribeAliasError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_alias_error(response)
        } else {
            crate::operation_deser::parse_describe_alias_response(response)
        }
    }
}

/// Operation shape for `DescribeBuild`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_build`](crate::client::Client::describe_build).
///
/// See [`crate::client::fluent_builders::DescribeBuild`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeBuild {
    _private: (),
}
impl DescribeBuild {
    /// Creates a new builder-style object to manufacture [`DescribeBuildInput`](crate::input::DescribeBuildInput)
    pub fn builder() -> crate::input::describe_build_input::Builder {
        crate::input::describe_build_input::Builder::default()
    }
    /// Creates a new `DescribeBuild` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeBuild {
    type Output =
        std::result::Result<crate::output::DescribeBuildOutput, crate::error::DescribeBuildError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_build_error(response)
        } else {
            crate::operation_deser::parse_describe_build_response(response)
        }
    }
}

/// Operation shape for `DescribeEC2InstanceLimits`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_ec2_instance_limits`](crate::client::Client::describe_ec2_instance_limits).
///
/// See [`crate::client::fluent_builders::DescribeEC2InstanceLimits`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEC2InstanceLimits {
    _private: (),
}
impl DescribeEC2InstanceLimits {
    /// Creates a new builder-style object to manufacture [`DescribeEc2InstanceLimitsInput`](crate::input::DescribeEc2InstanceLimitsInput)
    pub fn builder() -> crate::input::describe_ec2_instance_limits_input::Builder {
        crate::input::describe_ec2_instance_limits_input::Builder::default()
    }
    /// Creates a new `DescribeEC2InstanceLimits` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEC2InstanceLimits {
    type Output = std::result::Result<
        crate::output::DescribeEc2InstanceLimitsOutput,
        crate::error::DescribeEC2InstanceLimitsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_ec2_instance_limits_error(response)
        } else {
            crate::operation_deser::parse_describe_ec2_instance_limits_response(response)
        }
    }
}

/// Operation shape for `DescribeFleetAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_fleet_attributes`](crate::client::Client::describe_fleet_attributes).
///
/// See [`crate::client::fluent_builders::DescribeFleetAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFleetAttributes {
    _private: (),
}
impl DescribeFleetAttributes {
    /// Creates a new builder-style object to manufacture [`DescribeFleetAttributesInput`](crate::input::DescribeFleetAttributesInput)
    pub fn builder() -> crate::input::describe_fleet_attributes_input::Builder {
        crate::input::describe_fleet_attributes_input::Builder::default()
    }
    /// Creates a new `DescribeFleetAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFleetAttributes {
    type Output = std::result::Result<
        crate::output::DescribeFleetAttributesOutput,
        crate::error::DescribeFleetAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_fleet_attributes_error(response)
        } else {
            crate::operation_deser::parse_describe_fleet_attributes_response(response)
        }
    }
}

/// Operation shape for `DescribeFleetCapacity`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_fleet_capacity`](crate::client::Client::describe_fleet_capacity).
///
/// See [`crate::client::fluent_builders::DescribeFleetCapacity`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFleetCapacity {
    _private: (),
}
impl DescribeFleetCapacity {
    /// Creates a new builder-style object to manufacture [`DescribeFleetCapacityInput`](crate::input::DescribeFleetCapacityInput)
    pub fn builder() -> crate::input::describe_fleet_capacity_input::Builder {
        crate::input::describe_fleet_capacity_input::Builder::default()
    }
    /// Creates a new `DescribeFleetCapacity` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFleetCapacity {
    type Output = std::result::Result<
        crate::output::DescribeFleetCapacityOutput,
        crate::error::DescribeFleetCapacityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_fleet_capacity_error(response)
        } else {
            crate::operation_deser::parse_describe_fleet_capacity_response(response)
        }
    }
}

/// Operation shape for `DescribeFleetEvents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_fleet_events`](crate::client::Client::describe_fleet_events).
///
/// See [`crate::client::fluent_builders::DescribeFleetEvents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFleetEvents {
    _private: (),
}
impl DescribeFleetEvents {
    /// Creates a new builder-style object to manufacture [`DescribeFleetEventsInput`](crate::input::DescribeFleetEventsInput)
    pub fn builder() -> crate::input::describe_fleet_events_input::Builder {
        crate::input::describe_fleet_events_input::Builder::default()
    }
    /// Creates a new `DescribeFleetEvents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFleetEvents {
    type Output = std::result::Result<
        crate::output::DescribeFleetEventsOutput,
        crate::error::DescribeFleetEventsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_fleet_events_error(response)
        } else {
            crate::operation_deser::parse_describe_fleet_events_response(response)
        }
    }
}

/// Operation shape for `DescribeFleetLocationAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_fleet_location_attributes`](crate::client::Client::describe_fleet_location_attributes).
///
/// See [`crate::client::fluent_builders::DescribeFleetLocationAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFleetLocationAttributes {
    _private: (),
}
impl DescribeFleetLocationAttributes {
    /// Creates a new builder-style object to manufacture [`DescribeFleetLocationAttributesInput`](crate::input::DescribeFleetLocationAttributesInput)
    pub fn builder() -> crate::input::describe_fleet_location_attributes_input::Builder {
        crate::input::describe_fleet_location_attributes_input::Builder::default()
    }
    /// Creates a new `DescribeFleetLocationAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFleetLocationAttributes {
    type Output = std::result::Result<
        crate::output::DescribeFleetLocationAttributesOutput,
        crate::error::DescribeFleetLocationAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_fleet_location_attributes_error(response)
        } else {
            crate::operation_deser::parse_describe_fleet_location_attributes_response(response)
        }
    }
}

/// Operation shape for `DescribeFleetLocationCapacity`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_fleet_location_capacity`](crate::client::Client::describe_fleet_location_capacity).
///
/// See [`crate::client::fluent_builders::DescribeFleetLocationCapacity`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFleetLocationCapacity {
    _private: (),
}
impl DescribeFleetLocationCapacity {
    /// Creates a new builder-style object to manufacture [`DescribeFleetLocationCapacityInput`](crate::input::DescribeFleetLocationCapacityInput)
    pub fn builder() -> crate::input::describe_fleet_location_capacity_input::Builder {
        crate::input::describe_fleet_location_capacity_input::Builder::default()
    }
    /// Creates a new `DescribeFleetLocationCapacity` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFleetLocationCapacity {
    type Output = std::result::Result<
        crate::output::DescribeFleetLocationCapacityOutput,
        crate::error::DescribeFleetLocationCapacityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_fleet_location_capacity_error(response)
        } else {
            crate::operation_deser::parse_describe_fleet_location_capacity_response(response)
        }
    }
}

/// Operation shape for `DescribeFleetLocationUtilization`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_fleet_location_utilization`](crate::client::Client::describe_fleet_location_utilization).
///
/// See [`crate::client::fluent_builders::DescribeFleetLocationUtilization`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFleetLocationUtilization {
    _private: (),
}
impl DescribeFleetLocationUtilization {
    /// Creates a new builder-style object to manufacture [`DescribeFleetLocationUtilizationInput`](crate::input::DescribeFleetLocationUtilizationInput)
    pub fn builder() -> crate::input::describe_fleet_location_utilization_input::Builder {
        crate::input::describe_fleet_location_utilization_input::Builder::default()
    }
    /// Creates a new `DescribeFleetLocationUtilization` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFleetLocationUtilization {
    type Output = std::result::Result<
        crate::output::DescribeFleetLocationUtilizationOutput,
        crate::error::DescribeFleetLocationUtilizationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_fleet_location_utilization_error(response)
        } else {
            crate::operation_deser::parse_describe_fleet_location_utilization_response(response)
        }
    }
}

/// Operation shape for `DescribeFleetPortSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_fleet_port_settings`](crate::client::Client::describe_fleet_port_settings).
///
/// See [`crate::client::fluent_builders::DescribeFleetPortSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFleetPortSettings {
    _private: (),
}
impl DescribeFleetPortSettings {
    /// Creates a new builder-style object to manufacture [`DescribeFleetPortSettingsInput`](crate::input::DescribeFleetPortSettingsInput)
    pub fn builder() -> crate::input::describe_fleet_port_settings_input::Builder {
        crate::input::describe_fleet_port_settings_input::Builder::default()
    }
    /// Creates a new `DescribeFleetPortSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFleetPortSettings {
    type Output = std::result::Result<
        crate::output::DescribeFleetPortSettingsOutput,
        crate::error::DescribeFleetPortSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_fleet_port_settings_error(response)
        } else {
            crate::operation_deser::parse_describe_fleet_port_settings_response(response)
        }
    }
}

/// Operation shape for `DescribeFleetUtilization`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_fleet_utilization`](crate::client::Client::describe_fleet_utilization).
///
/// See [`crate::client::fluent_builders::DescribeFleetUtilization`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFleetUtilization {
    _private: (),
}
impl DescribeFleetUtilization {
    /// Creates a new builder-style object to manufacture [`DescribeFleetUtilizationInput`](crate::input::DescribeFleetUtilizationInput)
    pub fn builder() -> crate::input::describe_fleet_utilization_input::Builder {
        crate::input::describe_fleet_utilization_input::Builder::default()
    }
    /// Creates a new `DescribeFleetUtilization` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFleetUtilization {
    type Output = std::result::Result<
        crate::output::DescribeFleetUtilizationOutput,
        crate::error::DescribeFleetUtilizationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_fleet_utilization_error(response)
        } else {
            crate::operation_deser::parse_describe_fleet_utilization_response(response)
        }
    }
}

/// Operation shape for `DescribeGameServer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_game_server`](crate::client::Client::describe_game_server).
///
/// See [`crate::client::fluent_builders::DescribeGameServer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeGameServer {
    _private: (),
}
impl DescribeGameServer {
    /// Creates a new builder-style object to manufacture [`DescribeGameServerInput`](crate::input::DescribeGameServerInput)
    pub fn builder() -> crate::input::describe_game_server_input::Builder {
        crate::input::describe_game_server_input::Builder::default()
    }
    /// Creates a new `DescribeGameServer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeGameServer {
    type Output = std::result::Result<
        crate::output::DescribeGameServerOutput,
        crate::error::DescribeGameServerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_game_server_error(response)
        } else {
            crate::operation_deser::parse_describe_game_server_response(response)
        }
    }
}

/// Operation shape for `DescribeGameServerGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_game_server_group`](crate::client::Client::describe_game_server_group).
///
/// See [`crate::client::fluent_builders::DescribeGameServerGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeGameServerGroup {
    _private: (),
}
impl DescribeGameServerGroup {
    /// Creates a new builder-style object to manufacture [`DescribeGameServerGroupInput`](crate::input::DescribeGameServerGroupInput)
    pub fn builder() -> crate::input::describe_game_server_group_input::Builder {
        crate::input::describe_game_server_group_input::Builder::default()
    }
    /// Creates a new `DescribeGameServerGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeGameServerGroup {
    type Output = std::result::Result<
        crate::output::DescribeGameServerGroupOutput,
        crate::error::DescribeGameServerGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_game_server_group_error(response)
        } else {
            crate::operation_deser::parse_describe_game_server_group_response(response)
        }
    }
}

/// Operation shape for `DescribeGameServerInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_game_server_instances`](crate::client::Client::describe_game_server_instances).
///
/// See [`crate::client::fluent_builders::DescribeGameServerInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeGameServerInstances {
    _private: (),
}
impl DescribeGameServerInstances {
    /// Creates a new builder-style object to manufacture [`DescribeGameServerInstancesInput`](crate::input::DescribeGameServerInstancesInput)
    pub fn builder() -> crate::input::describe_game_server_instances_input::Builder {
        crate::input::describe_game_server_instances_input::Builder::default()
    }
    /// Creates a new `DescribeGameServerInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeGameServerInstances {
    type Output = std::result::Result<
        crate::output::DescribeGameServerInstancesOutput,
        crate::error::DescribeGameServerInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_game_server_instances_error(response)
        } else {
            crate::operation_deser::parse_describe_game_server_instances_response(response)
        }
    }
}

/// Operation shape for `DescribeGameSessionDetails`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_game_session_details`](crate::client::Client::describe_game_session_details).
///
/// See [`crate::client::fluent_builders::DescribeGameSessionDetails`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeGameSessionDetails {
    _private: (),
}
impl DescribeGameSessionDetails {
    /// Creates a new builder-style object to manufacture [`DescribeGameSessionDetailsInput`](crate::input::DescribeGameSessionDetailsInput)
    pub fn builder() -> crate::input::describe_game_session_details_input::Builder {
        crate::input::describe_game_session_details_input::Builder::default()
    }
    /// Creates a new `DescribeGameSessionDetails` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeGameSessionDetails {
    type Output = std::result::Result<
        crate::output::DescribeGameSessionDetailsOutput,
        crate::error::DescribeGameSessionDetailsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_game_session_details_error(response)
        } else {
            crate::operation_deser::parse_describe_game_session_details_response(response)
        }
    }
}

/// Operation shape for `DescribeGameSessionPlacement`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_game_session_placement`](crate::client::Client::describe_game_session_placement).
///
/// See [`crate::client::fluent_builders::DescribeGameSessionPlacement`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeGameSessionPlacement {
    _private: (),
}
impl DescribeGameSessionPlacement {
    /// Creates a new builder-style object to manufacture [`DescribeGameSessionPlacementInput`](crate::input::DescribeGameSessionPlacementInput)
    pub fn builder() -> crate::input::describe_game_session_placement_input::Builder {
        crate::input::describe_game_session_placement_input::Builder::default()
    }
    /// Creates a new `DescribeGameSessionPlacement` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeGameSessionPlacement {
    type Output = std::result::Result<
        crate::output::DescribeGameSessionPlacementOutput,
        crate::error::DescribeGameSessionPlacementError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_game_session_placement_error(response)
        } else {
            crate::operation_deser::parse_describe_game_session_placement_response(response)
        }
    }
}

/// Operation shape for `DescribeGameSessionQueues`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_game_session_queues`](crate::client::Client::describe_game_session_queues).
///
/// See [`crate::client::fluent_builders::DescribeGameSessionQueues`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeGameSessionQueues {
    _private: (),
}
impl DescribeGameSessionQueues {
    /// Creates a new builder-style object to manufacture [`DescribeGameSessionQueuesInput`](crate::input::DescribeGameSessionQueuesInput)
    pub fn builder() -> crate::input::describe_game_session_queues_input::Builder {
        crate::input::describe_game_session_queues_input::Builder::default()
    }
    /// Creates a new `DescribeGameSessionQueues` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeGameSessionQueues {
    type Output = std::result::Result<
        crate::output::DescribeGameSessionQueuesOutput,
        crate::error::DescribeGameSessionQueuesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_game_session_queues_error(response)
        } else {
            crate::operation_deser::parse_describe_game_session_queues_response(response)
        }
    }
}

/// Operation shape for `DescribeGameSessions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_game_sessions`](crate::client::Client::describe_game_sessions).
///
/// See [`crate::client::fluent_builders::DescribeGameSessions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeGameSessions {
    _private: (),
}
impl DescribeGameSessions {
    /// Creates a new builder-style object to manufacture [`DescribeGameSessionsInput`](crate::input::DescribeGameSessionsInput)
    pub fn builder() -> crate::input::describe_game_sessions_input::Builder {
        crate::input::describe_game_sessions_input::Builder::default()
    }
    /// Creates a new `DescribeGameSessions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeGameSessions {
    type Output = std::result::Result<
        crate::output::DescribeGameSessionsOutput,
        crate::error::DescribeGameSessionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_game_sessions_error(response)
        } else {
            crate::operation_deser::parse_describe_game_sessions_response(response)
        }
    }
}

/// Operation shape for `DescribeInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_instances`](crate::client::Client::describe_instances).
///
/// See [`crate::client::fluent_builders::DescribeInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeInstances {
    _private: (),
}
impl DescribeInstances {
    /// Creates a new builder-style object to manufacture [`DescribeInstancesInput`](crate::input::DescribeInstancesInput)
    pub fn builder() -> crate::input::describe_instances_input::Builder {
        crate::input::describe_instances_input::Builder::default()
    }
    /// Creates a new `DescribeInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeInstances {
    type Output = std::result::Result<
        crate::output::DescribeInstancesOutput,
        crate::error::DescribeInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_instances_error(response)
        } else {
            crate::operation_deser::parse_describe_instances_response(response)
        }
    }
}

/// Operation shape for `DescribeMatchmaking`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_matchmaking`](crate::client::Client::describe_matchmaking).
///
/// See [`crate::client::fluent_builders::DescribeMatchmaking`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeMatchmaking {
    _private: (),
}
impl DescribeMatchmaking {
    /// Creates a new builder-style object to manufacture [`DescribeMatchmakingInput`](crate::input::DescribeMatchmakingInput)
    pub fn builder() -> crate::input::describe_matchmaking_input::Builder {
        crate::input::describe_matchmaking_input::Builder::default()
    }
    /// Creates a new `DescribeMatchmaking` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeMatchmaking {
    type Output = std::result::Result<
        crate::output::DescribeMatchmakingOutput,
        crate::error::DescribeMatchmakingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_matchmaking_error(response)
        } else {
            crate::operation_deser::parse_describe_matchmaking_response(response)
        }
    }
}

/// Operation shape for `DescribeMatchmakingConfigurations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_matchmaking_configurations`](crate::client::Client::describe_matchmaking_configurations).
///
/// See [`crate::client::fluent_builders::DescribeMatchmakingConfigurations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeMatchmakingConfigurations {
    _private: (),
}
impl DescribeMatchmakingConfigurations {
    /// Creates a new builder-style object to manufacture [`DescribeMatchmakingConfigurationsInput`](crate::input::DescribeMatchmakingConfigurationsInput)
    pub fn builder() -> crate::input::describe_matchmaking_configurations_input::Builder {
        crate::input::describe_matchmaking_configurations_input::Builder::default()
    }
    /// Creates a new `DescribeMatchmakingConfigurations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeMatchmakingConfigurations {
    type Output = std::result::Result<
        crate::output::DescribeMatchmakingConfigurationsOutput,
        crate::error::DescribeMatchmakingConfigurationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_matchmaking_configurations_error(response)
        } else {
            crate::operation_deser::parse_describe_matchmaking_configurations_response(response)
        }
    }
}

/// Operation shape for `DescribeMatchmakingRuleSets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_matchmaking_rule_sets`](crate::client::Client::describe_matchmaking_rule_sets).
///
/// See [`crate::client::fluent_builders::DescribeMatchmakingRuleSets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeMatchmakingRuleSets {
    _private: (),
}
impl DescribeMatchmakingRuleSets {
    /// Creates a new builder-style object to manufacture [`DescribeMatchmakingRuleSetsInput`](crate::input::DescribeMatchmakingRuleSetsInput)
    pub fn builder() -> crate::input::describe_matchmaking_rule_sets_input::Builder {
        crate::input::describe_matchmaking_rule_sets_input::Builder::default()
    }
    /// Creates a new `DescribeMatchmakingRuleSets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeMatchmakingRuleSets {
    type Output = std::result::Result<
        crate::output::DescribeMatchmakingRuleSetsOutput,
        crate::error::DescribeMatchmakingRuleSetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_matchmaking_rule_sets_error(response)
        } else {
            crate::operation_deser::parse_describe_matchmaking_rule_sets_response(response)
        }
    }
}

/// Operation shape for `DescribePlayerSessions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_player_sessions`](crate::client::Client::describe_player_sessions).
///
/// See [`crate::client::fluent_builders::DescribePlayerSessions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePlayerSessions {
    _private: (),
}
impl DescribePlayerSessions {
    /// Creates a new builder-style object to manufacture [`DescribePlayerSessionsInput`](crate::input::DescribePlayerSessionsInput)
    pub fn builder() -> crate::input::describe_player_sessions_input::Builder {
        crate::input::describe_player_sessions_input::Builder::default()
    }
    /// Creates a new `DescribePlayerSessions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePlayerSessions {
    type Output = std::result::Result<
        crate::output::DescribePlayerSessionsOutput,
        crate::error::DescribePlayerSessionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_player_sessions_error(response)
        } else {
            crate::operation_deser::parse_describe_player_sessions_response(response)
        }
    }
}

/// Operation shape for `DescribeRuntimeConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_runtime_configuration`](crate::client::Client::describe_runtime_configuration).
///
/// See [`crate::client::fluent_builders::DescribeRuntimeConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRuntimeConfiguration {
    _private: (),
}
impl DescribeRuntimeConfiguration {
    /// Creates a new builder-style object to manufacture [`DescribeRuntimeConfigurationInput`](crate::input::DescribeRuntimeConfigurationInput)
    pub fn builder() -> crate::input::describe_runtime_configuration_input::Builder {
        crate::input::describe_runtime_configuration_input::Builder::default()
    }
    /// Creates a new `DescribeRuntimeConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRuntimeConfiguration {
    type Output = std::result::Result<
        crate::output::DescribeRuntimeConfigurationOutput,
        crate::error::DescribeRuntimeConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_runtime_configuration_error(response)
        } else {
            crate::operation_deser::parse_describe_runtime_configuration_response(response)
        }
    }
}

/// Operation shape for `DescribeScalingPolicies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_scaling_policies`](crate::client::Client::describe_scaling_policies).
///
/// See [`crate::client::fluent_builders::DescribeScalingPolicies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeScalingPolicies {
    _private: (),
}
impl DescribeScalingPolicies {
    /// Creates a new builder-style object to manufacture [`DescribeScalingPoliciesInput`](crate::input::DescribeScalingPoliciesInput)
    pub fn builder() -> crate::input::describe_scaling_policies_input::Builder {
        crate::input::describe_scaling_policies_input::Builder::default()
    }
    /// Creates a new `DescribeScalingPolicies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeScalingPolicies {
    type Output = std::result::Result<
        crate::output::DescribeScalingPoliciesOutput,
        crate::error::DescribeScalingPoliciesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_scaling_policies_error(response)
        } else {
            crate::operation_deser::parse_describe_scaling_policies_response(response)
        }
    }
}

/// Operation shape for `DescribeScript`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_script`](crate::client::Client::describe_script).
///
/// See [`crate::client::fluent_builders::DescribeScript`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeScript {
    _private: (),
}
impl DescribeScript {
    /// Creates a new builder-style object to manufacture [`DescribeScriptInput`](crate::input::DescribeScriptInput)
    pub fn builder() -> crate::input::describe_script_input::Builder {
        crate::input::describe_script_input::Builder::default()
    }
    /// Creates a new `DescribeScript` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeScript {
    type Output =
        std::result::Result<crate::output::DescribeScriptOutput, crate::error::DescribeScriptError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_script_error(response)
        } else {
            crate::operation_deser::parse_describe_script_response(response)
        }
    }
}

/// Operation shape for `DescribeVpcPeeringAuthorizations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_vpc_peering_authorizations`](crate::client::Client::describe_vpc_peering_authorizations).
///
/// See [`crate::client::fluent_builders::DescribeVpcPeeringAuthorizations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeVpcPeeringAuthorizations {
    _private: (),
}
impl DescribeVpcPeeringAuthorizations {
    /// Creates a new builder-style object to manufacture [`DescribeVpcPeeringAuthorizationsInput`](crate::input::DescribeVpcPeeringAuthorizationsInput)
    pub fn builder() -> crate::input::describe_vpc_peering_authorizations_input::Builder {
        crate::input::describe_vpc_peering_authorizations_input::Builder::default()
    }
    /// Creates a new `DescribeVpcPeeringAuthorizations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeVpcPeeringAuthorizations {
    type Output = std::result::Result<
        crate::output::DescribeVpcPeeringAuthorizationsOutput,
        crate::error::DescribeVpcPeeringAuthorizationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_vpc_peering_authorizations_error(response)
        } else {
            crate::operation_deser::parse_describe_vpc_peering_authorizations_response(response)
        }
    }
}

/// Operation shape for `DescribeVpcPeeringConnections`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_vpc_peering_connections`](crate::client::Client::describe_vpc_peering_connections).
///
/// See [`crate::client::fluent_builders::DescribeVpcPeeringConnections`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeVpcPeeringConnections {
    _private: (),
}
impl DescribeVpcPeeringConnections {
    /// Creates a new builder-style object to manufacture [`DescribeVpcPeeringConnectionsInput`](crate::input::DescribeVpcPeeringConnectionsInput)
    pub fn builder() -> crate::input::describe_vpc_peering_connections_input::Builder {
        crate::input::describe_vpc_peering_connections_input::Builder::default()
    }
    /// Creates a new `DescribeVpcPeeringConnections` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeVpcPeeringConnections {
    type Output = std::result::Result<
        crate::output::DescribeVpcPeeringConnectionsOutput,
        crate::error::DescribeVpcPeeringConnectionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_vpc_peering_connections_error(response)
        } else {
            crate::operation_deser::parse_describe_vpc_peering_connections_response(response)
        }
    }
}

/// Operation shape for `GetGameSessionLogUrl`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_game_session_log_url`](crate::client::Client::get_game_session_log_url).
///
/// See [`crate::client::fluent_builders::GetGameSessionLogUrl`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetGameSessionLogUrl {
    _private: (),
}
impl GetGameSessionLogUrl {
    /// Creates a new builder-style object to manufacture [`GetGameSessionLogUrlInput`](crate::input::GetGameSessionLogUrlInput)
    pub fn builder() -> crate::input::get_game_session_log_url_input::Builder {
        crate::input::get_game_session_log_url_input::Builder::default()
    }
    /// Creates a new `GetGameSessionLogUrl` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetGameSessionLogUrl {
    type Output = std::result::Result<
        crate::output::GetGameSessionLogUrlOutput,
        crate::error::GetGameSessionLogUrlError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_game_session_log_url_error(response)
        } else {
            crate::operation_deser::parse_get_game_session_log_url_response(response)
        }
    }
}

/// Operation shape for `GetInstanceAccess`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_instance_access`](crate::client::Client::get_instance_access).
///
/// See [`crate::client::fluent_builders::GetInstanceAccess`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetInstanceAccess {
    _private: (),
}
impl GetInstanceAccess {
    /// Creates a new builder-style object to manufacture [`GetInstanceAccessInput`](crate::input::GetInstanceAccessInput)
    pub fn builder() -> crate::input::get_instance_access_input::Builder {
        crate::input::get_instance_access_input::Builder::default()
    }
    /// Creates a new `GetInstanceAccess` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetInstanceAccess {
    type Output = std::result::Result<
        crate::output::GetInstanceAccessOutput,
        crate::error::GetInstanceAccessError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_instance_access_error(response)
        } else {
            crate::operation_deser::parse_get_instance_access_response(response)
        }
    }
}

/// Operation shape for `ListAliases`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_aliases`](crate::client::Client::list_aliases).
///
/// See [`crate::client::fluent_builders::ListAliases`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAliases {
    _private: (),
}
impl ListAliases {
    /// Creates a new builder-style object to manufacture [`ListAliasesInput`](crate::input::ListAliasesInput)
    pub fn builder() -> crate::input::list_aliases_input::Builder {
        crate::input::list_aliases_input::Builder::default()
    }
    /// Creates a new `ListAliases` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAliases {
    type Output =
        std::result::Result<crate::output::ListAliasesOutput, crate::error::ListAliasesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_aliases_error(response)
        } else {
            crate::operation_deser::parse_list_aliases_response(response)
        }
    }
}

/// Operation shape for `ListBuilds`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_builds`](crate::client::Client::list_builds).
///
/// See [`crate::client::fluent_builders::ListBuilds`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBuilds {
    _private: (),
}
impl ListBuilds {
    /// Creates a new builder-style object to manufacture [`ListBuildsInput`](crate::input::ListBuildsInput)
    pub fn builder() -> crate::input::list_builds_input::Builder {
        crate::input::list_builds_input::Builder::default()
    }
    /// Creates a new `ListBuilds` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBuilds {
    type Output =
        std::result::Result<crate::output::ListBuildsOutput, crate::error::ListBuildsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_builds_error(response)
        } else {
            crate::operation_deser::parse_list_builds_response(response)
        }
    }
}

/// Operation shape for `ListFleets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_fleets`](crate::client::Client::list_fleets).
///
/// See [`crate::client::fluent_builders::ListFleets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFleets {
    _private: (),
}
impl ListFleets {
    /// Creates a new builder-style object to manufacture [`ListFleetsInput`](crate::input::ListFleetsInput)
    pub fn builder() -> crate::input::list_fleets_input::Builder {
        crate::input::list_fleets_input::Builder::default()
    }
    /// Creates a new `ListFleets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFleets {
    type Output =
        std::result::Result<crate::output::ListFleetsOutput, crate::error::ListFleetsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_fleets_error(response)
        } else {
            crate::operation_deser::parse_list_fleets_response(response)
        }
    }
}

/// Operation shape for `ListGameServerGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_game_server_groups`](crate::client::Client::list_game_server_groups).
///
/// See [`crate::client::fluent_builders::ListGameServerGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListGameServerGroups {
    _private: (),
}
impl ListGameServerGroups {
    /// Creates a new builder-style object to manufacture [`ListGameServerGroupsInput`](crate::input::ListGameServerGroupsInput)
    pub fn builder() -> crate::input::list_game_server_groups_input::Builder {
        crate::input::list_game_server_groups_input::Builder::default()
    }
    /// Creates a new `ListGameServerGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListGameServerGroups {
    type Output = std::result::Result<
        crate::output::ListGameServerGroupsOutput,
        crate::error::ListGameServerGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_game_server_groups_error(response)
        } else {
            crate::operation_deser::parse_list_game_server_groups_response(response)
        }
    }
}

/// Operation shape for `ListGameServers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_game_servers`](crate::client::Client::list_game_servers).
///
/// See [`crate::client::fluent_builders::ListGameServers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListGameServers {
    _private: (),
}
impl ListGameServers {
    /// Creates a new builder-style object to manufacture [`ListGameServersInput`](crate::input::ListGameServersInput)
    pub fn builder() -> crate::input::list_game_servers_input::Builder {
        crate::input::list_game_servers_input::Builder::default()
    }
    /// Creates a new `ListGameServers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListGameServers {
    type Output = std::result::Result<
        crate::output::ListGameServersOutput,
        crate::error::ListGameServersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_game_servers_error(response)
        } else {
            crate::operation_deser::parse_list_game_servers_response(response)
        }
    }
}

/// Operation shape for `ListScripts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_scripts`](crate::client::Client::list_scripts).
///
/// See [`crate::client::fluent_builders::ListScripts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListScripts {
    _private: (),
}
impl ListScripts {
    /// Creates a new builder-style object to manufacture [`ListScriptsInput`](crate::input::ListScriptsInput)
    pub fn builder() -> crate::input::list_scripts_input::Builder {
        crate::input::list_scripts_input::Builder::default()
    }
    /// Creates a new `ListScripts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListScripts {
    type Output =
        std::result::Result<crate::output::ListScriptsOutput, crate::error::ListScriptsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_scripts_error(response)
        } else {
            crate::operation_deser::parse_list_scripts_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `PutScalingPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_scaling_policy`](crate::client::Client::put_scaling_policy).
///
/// See [`crate::client::fluent_builders::PutScalingPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutScalingPolicy {
    _private: (),
}
impl PutScalingPolicy {
    /// Creates a new builder-style object to manufacture [`PutScalingPolicyInput`](crate::input::PutScalingPolicyInput)
    pub fn builder() -> crate::input::put_scaling_policy_input::Builder {
        crate::input::put_scaling_policy_input::Builder::default()
    }
    /// Creates a new `PutScalingPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutScalingPolicy {
    type Output = std::result::Result<
        crate::output::PutScalingPolicyOutput,
        crate::error::PutScalingPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_scaling_policy_error(response)
        } else {
            crate::operation_deser::parse_put_scaling_policy_response(response)
        }
    }
}

/// Operation shape for `RegisterGameServer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_game_server`](crate::client::Client::register_game_server).
///
/// See [`crate::client::fluent_builders::RegisterGameServer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterGameServer {
    _private: (),
}
impl RegisterGameServer {
    /// Creates a new builder-style object to manufacture [`RegisterGameServerInput`](crate::input::RegisterGameServerInput)
    pub fn builder() -> crate::input::register_game_server_input::Builder {
        crate::input::register_game_server_input::Builder::default()
    }
    /// Creates a new `RegisterGameServer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterGameServer {
    type Output = std::result::Result<
        crate::output::RegisterGameServerOutput,
        crate::error::RegisterGameServerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_game_server_error(response)
        } else {
            crate::operation_deser::parse_register_game_server_response(response)
        }
    }
}

/// Operation shape for `RequestUploadCredentials`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`request_upload_credentials`](crate::client::Client::request_upload_credentials).
///
/// See [`crate::client::fluent_builders::RequestUploadCredentials`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RequestUploadCredentials {
    _private: (),
}
impl RequestUploadCredentials {
    /// Creates a new builder-style object to manufacture [`RequestUploadCredentialsInput`](crate::input::RequestUploadCredentialsInput)
    pub fn builder() -> crate::input::request_upload_credentials_input::Builder {
        crate::input::request_upload_credentials_input::Builder::default()
    }
    /// Creates a new `RequestUploadCredentials` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RequestUploadCredentials {
    type Output = std::result::Result<
        crate::output::RequestUploadCredentialsOutput,
        crate::error::RequestUploadCredentialsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_request_upload_credentials_error(response)
        } else {
            crate::operation_deser::parse_request_upload_credentials_response(response)
        }
    }
}

/// Operation shape for `ResolveAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`resolve_alias`](crate::client::Client::resolve_alias).
///
/// See [`crate::client::fluent_builders::ResolveAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResolveAlias {
    _private: (),
}
impl ResolveAlias {
    /// Creates a new builder-style object to manufacture [`ResolveAliasInput`](crate::input::ResolveAliasInput)
    pub fn builder() -> crate::input::resolve_alias_input::Builder {
        crate::input::resolve_alias_input::Builder::default()
    }
    /// Creates a new `ResolveAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResolveAlias {
    type Output =
        std::result::Result<crate::output::ResolveAliasOutput, crate::error::ResolveAliasError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_resolve_alias_error(response)
        } else {
            crate::operation_deser::parse_resolve_alias_response(response)
        }
    }
}

/// Operation shape for `ResumeGameServerGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`resume_game_server_group`](crate::client::Client::resume_game_server_group).
///
/// See [`crate::client::fluent_builders::ResumeGameServerGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResumeGameServerGroup {
    _private: (),
}
impl ResumeGameServerGroup {
    /// Creates a new builder-style object to manufacture [`ResumeGameServerGroupInput`](crate::input::ResumeGameServerGroupInput)
    pub fn builder() -> crate::input::resume_game_server_group_input::Builder {
        crate::input::resume_game_server_group_input::Builder::default()
    }
    /// Creates a new `ResumeGameServerGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResumeGameServerGroup {
    type Output = std::result::Result<
        crate::output::ResumeGameServerGroupOutput,
        crate::error::ResumeGameServerGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_resume_game_server_group_error(response)
        } else {
            crate::operation_deser::parse_resume_game_server_group_response(response)
        }
    }
}

/// Operation shape for `SearchGameSessions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_game_sessions`](crate::client::Client::search_game_sessions).
///
/// See [`crate::client::fluent_builders::SearchGameSessions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchGameSessions {
    _private: (),
}
impl SearchGameSessions {
    /// Creates a new builder-style object to manufacture [`SearchGameSessionsInput`](crate::input::SearchGameSessionsInput)
    pub fn builder() -> crate::input::search_game_sessions_input::Builder {
        crate::input::search_game_sessions_input::Builder::default()
    }
    /// Creates a new `SearchGameSessions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchGameSessions {
    type Output = std::result::Result<
        crate::output::SearchGameSessionsOutput,
        crate::error::SearchGameSessionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_game_sessions_error(response)
        } else {
            crate::operation_deser::parse_search_game_sessions_response(response)
        }
    }
}

/// Operation shape for `StartFleetActions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_fleet_actions`](crate::client::Client::start_fleet_actions).
///
/// See [`crate::client::fluent_builders::StartFleetActions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartFleetActions {
    _private: (),
}
impl StartFleetActions {
    /// Creates a new builder-style object to manufacture [`StartFleetActionsInput`](crate::input::StartFleetActionsInput)
    pub fn builder() -> crate::input::start_fleet_actions_input::Builder {
        crate::input::start_fleet_actions_input::Builder::default()
    }
    /// Creates a new `StartFleetActions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartFleetActions {
    type Output = std::result::Result<
        crate::output::StartFleetActionsOutput,
        crate::error::StartFleetActionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_fleet_actions_error(response)
        } else {
            crate::operation_deser::parse_start_fleet_actions_response(response)
        }
    }
}

/// Operation shape for `StartGameSessionPlacement`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_game_session_placement`](crate::client::Client::start_game_session_placement).
///
/// See [`crate::client::fluent_builders::StartGameSessionPlacement`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartGameSessionPlacement {
    _private: (),
}
impl StartGameSessionPlacement {
    /// Creates a new builder-style object to manufacture [`StartGameSessionPlacementInput`](crate::input::StartGameSessionPlacementInput)
    pub fn builder() -> crate::input::start_game_session_placement_input::Builder {
        crate::input::start_game_session_placement_input::Builder::default()
    }
    /// Creates a new `StartGameSessionPlacement` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartGameSessionPlacement {
    type Output = std::result::Result<
        crate::output::StartGameSessionPlacementOutput,
        crate::error::StartGameSessionPlacementError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_game_session_placement_error(response)
        } else {
            crate::operation_deser::parse_start_game_session_placement_response(response)
        }
    }
}

/// Operation shape for `StartMatchBackfill`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_match_backfill`](crate::client::Client::start_match_backfill).
///
/// See [`crate::client::fluent_builders::StartMatchBackfill`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartMatchBackfill {
    _private: (),
}
impl StartMatchBackfill {
    /// Creates a new builder-style object to manufacture [`StartMatchBackfillInput`](crate::input::StartMatchBackfillInput)
    pub fn builder() -> crate::input::start_match_backfill_input::Builder {
        crate::input::start_match_backfill_input::Builder::default()
    }
    /// Creates a new `StartMatchBackfill` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartMatchBackfill {
    type Output = std::result::Result<
        crate::output::StartMatchBackfillOutput,
        crate::error::StartMatchBackfillError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_match_backfill_error(response)
        } else {
            crate::operation_deser::parse_start_match_backfill_response(response)
        }
    }
}

/// Operation shape for `StartMatchmaking`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_matchmaking`](crate::client::Client::start_matchmaking).
///
/// See [`crate::client::fluent_builders::StartMatchmaking`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartMatchmaking {
    _private: (),
}
impl StartMatchmaking {
    /// Creates a new builder-style object to manufacture [`StartMatchmakingInput`](crate::input::StartMatchmakingInput)
    pub fn builder() -> crate::input::start_matchmaking_input::Builder {
        crate::input::start_matchmaking_input::Builder::default()
    }
    /// Creates a new `StartMatchmaking` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartMatchmaking {
    type Output = std::result::Result<
        crate::output::StartMatchmakingOutput,
        crate::error::StartMatchmakingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_matchmaking_error(response)
        } else {
            crate::operation_deser::parse_start_matchmaking_response(response)
        }
    }
}

/// Operation shape for `StopFleetActions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_fleet_actions`](crate::client::Client::stop_fleet_actions).
///
/// See [`crate::client::fluent_builders::StopFleetActions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopFleetActions {
    _private: (),
}
impl StopFleetActions {
    /// Creates a new builder-style object to manufacture [`StopFleetActionsInput`](crate::input::StopFleetActionsInput)
    pub fn builder() -> crate::input::stop_fleet_actions_input::Builder {
        crate::input::stop_fleet_actions_input::Builder::default()
    }
    /// Creates a new `StopFleetActions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopFleetActions {
    type Output = std::result::Result<
        crate::output::StopFleetActionsOutput,
        crate::error::StopFleetActionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_fleet_actions_error(response)
        } else {
            crate::operation_deser::parse_stop_fleet_actions_response(response)
        }
    }
}

/// Operation shape for `StopGameSessionPlacement`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_game_session_placement`](crate::client::Client::stop_game_session_placement).
///
/// See [`crate::client::fluent_builders::StopGameSessionPlacement`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopGameSessionPlacement {
    _private: (),
}
impl StopGameSessionPlacement {
    /// Creates a new builder-style object to manufacture [`StopGameSessionPlacementInput`](crate::input::StopGameSessionPlacementInput)
    pub fn builder() -> crate::input::stop_game_session_placement_input::Builder {
        crate::input::stop_game_session_placement_input::Builder::default()
    }
    /// Creates a new `StopGameSessionPlacement` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopGameSessionPlacement {
    type Output = std::result::Result<
        crate::output::StopGameSessionPlacementOutput,
        crate::error::StopGameSessionPlacementError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_game_session_placement_error(response)
        } else {
            crate::operation_deser::parse_stop_game_session_placement_response(response)
        }
    }
}

/// Operation shape for `StopMatchmaking`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_matchmaking`](crate::client::Client::stop_matchmaking).
///
/// See [`crate::client::fluent_builders::StopMatchmaking`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopMatchmaking {
    _private: (),
}
impl StopMatchmaking {
    /// Creates a new builder-style object to manufacture [`StopMatchmakingInput`](crate::input::StopMatchmakingInput)
    pub fn builder() -> crate::input::stop_matchmaking_input::Builder {
        crate::input::stop_matchmaking_input::Builder::default()
    }
    /// Creates a new `StopMatchmaking` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopMatchmaking {
    type Output = std::result::Result<
        crate::output::StopMatchmakingOutput,
        crate::error::StopMatchmakingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_matchmaking_error(response)
        } else {
            crate::operation_deser::parse_stop_matchmaking_response(response)
        }
    }
}

/// Operation shape for `SuspendGameServerGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`suspend_game_server_group`](crate::client::Client::suspend_game_server_group).
///
/// See [`crate::client::fluent_builders::SuspendGameServerGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SuspendGameServerGroup {
    _private: (),
}
impl SuspendGameServerGroup {
    /// Creates a new builder-style object to manufacture [`SuspendGameServerGroupInput`](crate::input::SuspendGameServerGroupInput)
    pub fn builder() -> crate::input::suspend_game_server_group_input::Builder {
        crate::input::suspend_game_server_group_input::Builder::default()
    }
    /// Creates a new `SuspendGameServerGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SuspendGameServerGroup {
    type Output = std::result::Result<
        crate::output::SuspendGameServerGroupOutput,
        crate::error::SuspendGameServerGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_suspend_game_server_group_error(response)
        } else {
            crate::operation_deser::parse_suspend_game_server_group_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_alias`](crate::client::Client::update_alias).
///
/// See [`crate::client::fluent_builders::UpdateAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAlias {
    _private: (),
}
impl UpdateAlias {
    /// Creates a new builder-style object to manufacture [`UpdateAliasInput`](crate::input::UpdateAliasInput)
    pub fn builder() -> crate::input::update_alias_input::Builder {
        crate::input::update_alias_input::Builder::default()
    }
    /// Creates a new `UpdateAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAlias {
    type Output =
        std::result::Result<crate::output::UpdateAliasOutput, crate::error::UpdateAliasError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_alias_error(response)
        } else {
            crate::operation_deser::parse_update_alias_response(response)
        }
    }
}

/// Operation shape for `UpdateBuild`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_build`](crate::client::Client::update_build).
///
/// See [`crate::client::fluent_builders::UpdateBuild`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateBuild {
    _private: (),
}
impl UpdateBuild {
    /// Creates a new builder-style object to manufacture [`UpdateBuildInput`](crate::input::UpdateBuildInput)
    pub fn builder() -> crate::input::update_build_input::Builder {
        crate::input::update_build_input::Builder::default()
    }
    /// Creates a new `UpdateBuild` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateBuild {
    type Output =
        std::result::Result<crate::output::UpdateBuildOutput, crate::error::UpdateBuildError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_build_error(response)
        } else {
            crate::operation_deser::parse_update_build_response(response)
        }
    }
}

/// Operation shape for `UpdateFleetAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_fleet_attributes`](crate::client::Client::update_fleet_attributes).
///
/// See [`crate::client::fluent_builders::UpdateFleetAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFleetAttributes {
    _private: (),
}
impl UpdateFleetAttributes {
    /// Creates a new builder-style object to manufacture [`UpdateFleetAttributesInput`](crate::input::UpdateFleetAttributesInput)
    pub fn builder() -> crate::input::update_fleet_attributes_input::Builder {
        crate::input::update_fleet_attributes_input::Builder::default()
    }
    /// Creates a new `UpdateFleetAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFleetAttributes {
    type Output = std::result::Result<
        crate::output::UpdateFleetAttributesOutput,
        crate::error::UpdateFleetAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_fleet_attributes_error(response)
        } else {
            crate::operation_deser::parse_update_fleet_attributes_response(response)
        }
    }
}

/// Operation shape for `UpdateFleetCapacity`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_fleet_capacity`](crate::client::Client::update_fleet_capacity).
///
/// See [`crate::client::fluent_builders::UpdateFleetCapacity`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFleetCapacity {
    _private: (),
}
impl UpdateFleetCapacity {
    /// Creates a new builder-style object to manufacture [`UpdateFleetCapacityInput`](crate::input::UpdateFleetCapacityInput)
    pub fn builder() -> crate::input::update_fleet_capacity_input::Builder {
        crate::input::update_fleet_capacity_input::Builder::default()
    }
    /// Creates a new `UpdateFleetCapacity` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFleetCapacity {
    type Output = std::result::Result<
        crate::output::UpdateFleetCapacityOutput,
        crate::error::UpdateFleetCapacityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_fleet_capacity_error(response)
        } else {
            crate::operation_deser::parse_update_fleet_capacity_response(response)
        }
    }
}

/// Operation shape for `UpdateFleetPortSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_fleet_port_settings`](crate::client::Client::update_fleet_port_settings).
///
/// See [`crate::client::fluent_builders::UpdateFleetPortSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFleetPortSettings {
    _private: (),
}
impl UpdateFleetPortSettings {
    /// Creates a new builder-style object to manufacture [`UpdateFleetPortSettingsInput`](crate::input::UpdateFleetPortSettingsInput)
    pub fn builder() -> crate::input::update_fleet_port_settings_input::Builder {
        crate::input::update_fleet_port_settings_input::Builder::default()
    }
    /// Creates a new `UpdateFleetPortSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFleetPortSettings {
    type Output = std::result::Result<
        crate::output::UpdateFleetPortSettingsOutput,
        crate::error::UpdateFleetPortSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_fleet_port_settings_error(response)
        } else {
            crate::operation_deser::parse_update_fleet_port_settings_response(response)
        }
    }
}

/// Operation shape for `UpdateGameServer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_game_server`](crate::client::Client::update_game_server).
///
/// See [`crate::client::fluent_builders::UpdateGameServer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateGameServer {
    _private: (),
}
impl UpdateGameServer {
    /// Creates a new builder-style object to manufacture [`UpdateGameServerInput`](crate::input::UpdateGameServerInput)
    pub fn builder() -> crate::input::update_game_server_input::Builder {
        crate::input::update_game_server_input::Builder::default()
    }
    /// Creates a new `UpdateGameServer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateGameServer {
    type Output = std::result::Result<
        crate::output::UpdateGameServerOutput,
        crate::error::UpdateGameServerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_game_server_error(response)
        } else {
            crate::operation_deser::parse_update_game_server_response(response)
        }
    }
}

/// Operation shape for `UpdateGameServerGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_game_server_group`](crate::client::Client::update_game_server_group).
///
/// See [`crate::client::fluent_builders::UpdateGameServerGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateGameServerGroup {
    _private: (),
}
impl UpdateGameServerGroup {
    /// Creates a new builder-style object to manufacture [`UpdateGameServerGroupInput`](crate::input::UpdateGameServerGroupInput)
    pub fn builder() -> crate::input::update_game_server_group_input::Builder {
        crate::input::update_game_server_group_input::Builder::default()
    }
    /// Creates a new `UpdateGameServerGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateGameServerGroup {
    type Output = std::result::Result<
        crate::output::UpdateGameServerGroupOutput,
        crate::error::UpdateGameServerGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_game_server_group_error(response)
        } else {
            crate::operation_deser::parse_update_game_server_group_response(response)
        }
    }
}

/// Operation shape for `UpdateGameSession`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_game_session`](crate::client::Client::update_game_session).
///
/// See [`crate::client::fluent_builders::UpdateGameSession`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateGameSession {
    _private: (),
}
impl UpdateGameSession {
    /// Creates a new builder-style object to manufacture [`UpdateGameSessionInput`](crate::input::UpdateGameSessionInput)
    pub fn builder() -> crate::input::update_game_session_input::Builder {
        crate::input::update_game_session_input::Builder::default()
    }
    /// Creates a new `UpdateGameSession` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateGameSession {
    type Output = std::result::Result<
        crate::output::UpdateGameSessionOutput,
        crate::error::UpdateGameSessionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_game_session_error(response)
        } else {
            crate::operation_deser::parse_update_game_session_response(response)
        }
    }
}

/// Operation shape for `UpdateGameSessionQueue`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_game_session_queue`](crate::client::Client::update_game_session_queue).
///
/// See [`crate::client::fluent_builders::UpdateGameSessionQueue`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateGameSessionQueue {
    _private: (),
}
impl UpdateGameSessionQueue {
    /// Creates a new builder-style object to manufacture [`UpdateGameSessionQueueInput`](crate::input::UpdateGameSessionQueueInput)
    pub fn builder() -> crate::input::update_game_session_queue_input::Builder {
        crate::input::update_game_session_queue_input::Builder::default()
    }
    /// Creates a new `UpdateGameSessionQueue` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateGameSessionQueue {
    type Output = std::result::Result<
        crate::output::UpdateGameSessionQueueOutput,
        crate::error::UpdateGameSessionQueueError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_game_session_queue_error(response)
        } else {
            crate::operation_deser::parse_update_game_session_queue_response(response)
        }
    }
}

/// Operation shape for `UpdateMatchmakingConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_matchmaking_configuration`](crate::client::Client::update_matchmaking_configuration).
///
/// See [`crate::client::fluent_builders::UpdateMatchmakingConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateMatchmakingConfiguration {
    _private: (),
}
impl UpdateMatchmakingConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateMatchmakingConfigurationInput`](crate::input::UpdateMatchmakingConfigurationInput)
    pub fn builder() -> crate::input::update_matchmaking_configuration_input::Builder {
        crate::input::update_matchmaking_configuration_input::Builder::default()
    }
    /// Creates a new `UpdateMatchmakingConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateMatchmakingConfiguration {
    type Output = std::result::Result<
        crate::output::UpdateMatchmakingConfigurationOutput,
        crate::error::UpdateMatchmakingConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_matchmaking_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_matchmaking_configuration_response(response)
        }
    }
}

/// Operation shape for `UpdateRuntimeConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_runtime_configuration`](crate::client::Client::update_runtime_configuration).
///
/// See [`crate::client::fluent_builders::UpdateRuntimeConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRuntimeConfiguration {
    _private: (),
}
impl UpdateRuntimeConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateRuntimeConfigurationInput`](crate::input::UpdateRuntimeConfigurationInput)
    pub fn builder() -> crate::input::update_runtime_configuration_input::Builder {
        crate::input::update_runtime_configuration_input::Builder::default()
    }
    /// Creates a new `UpdateRuntimeConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRuntimeConfiguration {
    type Output = std::result::Result<
        crate::output::UpdateRuntimeConfigurationOutput,
        crate::error::UpdateRuntimeConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_runtime_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_runtime_configuration_response(response)
        }
    }
}

/// Operation shape for `UpdateScript`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_script`](crate::client::Client::update_script).
///
/// See [`crate::client::fluent_builders::UpdateScript`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateScript {
    _private: (),
}
impl UpdateScript {
    /// Creates a new builder-style object to manufacture [`UpdateScriptInput`](crate::input::UpdateScriptInput)
    pub fn builder() -> crate::input::update_script_input::Builder {
        crate::input::update_script_input::Builder::default()
    }
    /// Creates a new `UpdateScript` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateScript {
    type Output =
        std::result::Result<crate::output::UpdateScriptOutput, crate::error::UpdateScriptError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_script_error(response)
        } else {
            crate::operation_deser::parse_update_script_response(response)
        }
    }
}

/// Operation shape for `ValidateMatchmakingRuleSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`validate_matchmaking_rule_set`](crate::client::Client::validate_matchmaking_rule_set).
///
/// See [`crate::client::fluent_builders::ValidateMatchmakingRuleSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ValidateMatchmakingRuleSet {
    _private: (),
}
impl ValidateMatchmakingRuleSet {
    /// Creates a new builder-style object to manufacture [`ValidateMatchmakingRuleSetInput`](crate::input::ValidateMatchmakingRuleSetInput)
    pub fn builder() -> crate::input::validate_matchmaking_rule_set_input::Builder {
        crate::input::validate_matchmaking_rule_set_input::Builder::default()
    }
    /// Creates a new `ValidateMatchmakingRuleSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ValidateMatchmakingRuleSet {
    type Output = std::result::Result<
        crate::output::ValidateMatchmakingRuleSetOutput,
        crate::error::ValidateMatchmakingRuleSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_validate_matchmaking_rule_set_error(response)
        } else {
            crate::operation_deser::parse_validate_matchmaking_rule_set_response(response)
        }
    }
}
