// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidateMatchmakingRuleSetOutput {
    /// <p>A response indicating whether the rule set is valid.</p>
    pub valid: std::option::Option<bool>,
}
impl ValidateMatchmakingRuleSetOutput {
    /// <p>A response indicating whether the rule set is valid.</p>
    pub fn valid(&self) -> std::option::Option<bool> {
        self.valid
    }
}
impl std::fmt::Debug for ValidateMatchmakingRuleSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidateMatchmakingRuleSetOutput");
        formatter.field("valid", &self.valid);
        formatter.finish()
    }
}
/// See [`ValidateMatchmakingRuleSetOutput`](crate::output::ValidateMatchmakingRuleSetOutput)
pub mod validate_matchmaking_rule_set_output {
    /// A builder for [`ValidateMatchmakingRuleSetOutput`](crate::output::ValidateMatchmakingRuleSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) valid: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A response indicating whether the rule set is valid.</p>
        pub fn valid(mut self, input: bool) -> Self {
            self.valid = Some(input);
            self
        }
        /// <p>A response indicating whether the rule set is valid.</p>
        pub fn set_valid(mut self, input: std::option::Option<bool>) -> Self {
            self.valid = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidateMatchmakingRuleSetOutput`](crate::output::ValidateMatchmakingRuleSetOutput)
        pub fn build(self) -> crate::output::ValidateMatchmakingRuleSetOutput {
            crate::output::ValidateMatchmakingRuleSetOutput { valid: self.valid }
        }
    }
}
impl ValidateMatchmakingRuleSetOutput {
    /// Creates a new builder-style object to manufacture [`ValidateMatchmakingRuleSetOutput`](crate::output::ValidateMatchmakingRuleSetOutput)
    pub fn builder() -> crate::output::validate_matchmaking_rule_set_output::Builder {
        crate::output::validate_matchmaking_rule_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateScriptOutput {
    /// <p>The newly created script record with a unique script ID. The new script's storage location reflects an Amazon S3 location: (1) If the script was uploaded from an S3 bucket under your account, the storage location reflects the information that was provided in the <i>CreateScript</i> request; (2) If the script file was uploaded from a local zip file, the storage location reflects an S3 location controls by the Amazon GameLift service.</p>
    pub script: std::option::Option<crate::model::Script>,
}
impl UpdateScriptOutput {
    /// <p>The newly created script record with a unique script ID. The new script's storage location reflects an Amazon S3 location: (1) If the script was uploaded from an S3 bucket under your account, the storage location reflects the information that was provided in the <i>CreateScript</i> request; (2) If the script file was uploaded from a local zip file, the storage location reflects an S3 location controls by the Amazon GameLift service.</p>
    pub fn script(&self) -> std::option::Option<&crate::model::Script> {
        self.script.as_ref()
    }
}
impl std::fmt::Debug for UpdateScriptOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateScriptOutput");
        formatter.field("script", &self.script);
        formatter.finish()
    }
}
/// See [`UpdateScriptOutput`](crate::output::UpdateScriptOutput)
pub mod update_script_output {
    /// A builder for [`UpdateScriptOutput`](crate::output::UpdateScriptOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) script: std::option::Option<crate::model::Script>,
    }
    impl Builder {
        /// <p>The newly created script record with a unique script ID. The new script's storage location reflects an Amazon S3 location: (1) If the script was uploaded from an S3 bucket under your account, the storage location reflects the information that was provided in the <i>CreateScript</i> request; (2) If the script file was uploaded from a local zip file, the storage location reflects an S3 location controls by the Amazon GameLift service.</p>
        pub fn script(mut self, input: crate::model::Script) -> Self {
            self.script = Some(input);
            self
        }
        /// <p>The newly created script record with a unique script ID. The new script's storage location reflects an Amazon S3 location: (1) If the script was uploaded from an S3 bucket under your account, the storage location reflects the information that was provided in the <i>CreateScript</i> request; (2) If the script file was uploaded from a local zip file, the storage location reflects an S3 location controls by the Amazon GameLift service.</p>
        pub fn set_script(mut self, input: std::option::Option<crate::model::Script>) -> Self {
            self.script = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateScriptOutput`](crate::output::UpdateScriptOutput)
        pub fn build(self) -> crate::output::UpdateScriptOutput {
            crate::output::UpdateScriptOutput {
                script: self.script,
            }
        }
    }
}
impl UpdateScriptOutput {
    /// Creates a new builder-style object to manufacture [`UpdateScriptOutput`](crate::output::UpdateScriptOutput)
    pub fn builder() -> crate::output::update_script_output::Builder {
        crate::output::update_script_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRuntimeConfigurationOutput {
    /// <p>The runtime configuration currently in use by all instances in the fleet. If the update was successful, all property changes are shown. </p>
    pub runtime_configuration: std::option::Option<crate::model::RuntimeConfiguration>,
}
impl UpdateRuntimeConfigurationOutput {
    /// <p>The runtime configuration currently in use by all instances in the fleet. If the update was successful, all property changes are shown. </p>
    pub fn runtime_configuration(
        &self,
    ) -> std::option::Option<&crate::model::RuntimeConfiguration> {
        self.runtime_configuration.as_ref()
    }
}
impl std::fmt::Debug for UpdateRuntimeConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRuntimeConfigurationOutput");
        formatter.field("runtime_configuration", &self.runtime_configuration);
        formatter.finish()
    }
}
/// See [`UpdateRuntimeConfigurationOutput`](crate::output::UpdateRuntimeConfigurationOutput)
pub mod update_runtime_configuration_output {
    /// A builder for [`UpdateRuntimeConfigurationOutput`](crate::output::UpdateRuntimeConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) runtime_configuration: std::option::Option<crate::model::RuntimeConfiguration>,
    }
    impl Builder {
        /// <p>The runtime configuration currently in use by all instances in the fleet. If the update was successful, all property changes are shown. </p>
        pub fn runtime_configuration(mut self, input: crate::model::RuntimeConfiguration) -> Self {
            self.runtime_configuration = Some(input);
            self
        }
        /// <p>The runtime configuration currently in use by all instances in the fleet. If the update was successful, all property changes are shown. </p>
        pub fn set_runtime_configuration(
            mut self,
            input: std::option::Option<crate::model::RuntimeConfiguration>,
        ) -> Self {
            self.runtime_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRuntimeConfigurationOutput`](crate::output::UpdateRuntimeConfigurationOutput)
        pub fn build(self) -> crate::output::UpdateRuntimeConfigurationOutput {
            crate::output::UpdateRuntimeConfigurationOutput {
                runtime_configuration: self.runtime_configuration,
            }
        }
    }
}
impl UpdateRuntimeConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRuntimeConfigurationOutput`](crate::output::UpdateRuntimeConfigurationOutput)
    pub fn builder() -> crate::output::update_runtime_configuration_output::Builder {
        crate::output::update_runtime_configuration_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMatchmakingConfigurationOutput {
    /// <p>The updated matchmaking configuration.</p>
    pub configuration: std::option::Option<crate::model::MatchmakingConfiguration>,
}
impl UpdateMatchmakingConfigurationOutput {
    /// <p>The updated matchmaking configuration.</p>
    pub fn configuration(&self) -> std::option::Option<&crate::model::MatchmakingConfiguration> {
        self.configuration.as_ref()
    }
}
impl std::fmt::Debug for UpdateMatchmakingConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMatchmakingConfigurationOutput");
        formatter.field("configuration", &self.configuration);
        formatter.finish()
    }
}
/// See [`UpdateMatchmakingConfigurationOutput`](crate::output::UpdateMatchmakingConfigurationOutput)
pub mod update_matchmaking_configuration_output {
    /// A builder for [`UpdateMatchmakingConfigurationOutput`](crate::output::UpdateMatchmakingConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration: std::option::Option<crate::model::MatchmakingConfiguration>,
    }
    impl Builder {
        /// <p>The updated matchmaking configuration.</p>
        pub fn configuration(mut self, input: crate::model::MatchmakingConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>The updated matchmaking configuration.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::MatchmakingConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMatchmakingConfigurationOutput`](crate::output::UpdateMatchmakingConfigurationOutput)
        pub fn build(self) -> crate::output::UpdateMatchmakingConfigurationOutput {
            crate::output::UpdateMatchmakingConfigurationOutput {
                configuration: self.configuration,
            }
        }
    }
}
impl UpdateMatchmakingConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateMatchmakingConfigurationOutput`](crate::output::UpdateMatchmakingConfigurationOutput)
    pub fn builder() -> crate::output::update_matchmaking_configuration_output::Builder {
        crate::output::update_matchmaking_configuration_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGameSessionQueueOutput {
    /// <p>An object that describes the newly updated game session queue.</p>
    pub game_session_queue: std::option::Option<crate::model::GameSessionQueue>,
}
impl UpdateGameSessionQueueOutput {
    /// <p>An object that describes the newly updated game session queue.</p>
    pub fn game_session_queue(&self) -> std::option::Option<&crate::model::GameSessionQueue> {
        self.game_session_queue.as_ref()
    }
}
impl std::fmt::Debug for UpdateGameSessionQueueOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGameSessionQueueOutput");
        formatter.field("game_session_queue", &self.game_session_queue);
        formatter.finish()
    }
}
/// See [`UpdateGameSessionQueueOutput`](crate::output::UpdateGameSessionQueueOutput)
pub mod update_game_session_queue_output {
    /// A builder for [`UpdateGameSessionQueueOutput`](crate::output::UpdateGameSessionQueueOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_session_queue: std::option::Option<crate::model::GameSessionQueue>,
    }
    impl Builder {
        /// <p>An object that describes the newly updated game session queue.</p>
        pub fn game_session_queue(mut self, input: crate::model::GameSessionQueue) -> Self {
            self.game_session_queue = Some(input);
            self
        }
        /// <p>An object that describes the newly updated game session queue.</p>
        pub fn set_game_session_queue(
            mut self,
            input: std::option::Option<crate::model::GameSessionQueue>,
        ) -> Self {
            self.game_session_queue = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGameSessionQueueOutput`](crate::output::UpdateGameSessionQueueOutput)
        pub fn build(self) -> crate::output::UpdateGameSessionQueueOutput {
            crate::output::UpdateGameSessionQueueOutput {
                game_session_queue: self.game_session_queue,
            }
        }
    }
}
impl UpdateGameSessionQueueOutput {
    /// Creates a new builder-style object to manufacture [`UpdateGameSessionQueueOutput`](crate::output::UpdateGameSessionQueueOutput)
    pub fn builder() -> crate::output::update_game_session_queue_output::Builder {
        crate::output::update_game_session_queue_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGameSessionOutput {
    /// <p>The updated game session properties.</p>
    pub game_session: std::option::Option<crate::model::GameSession>,
}
impl UpdateGameSessionOutput {
    /// <p>The updated game session properties.</p>
    pub fn game_session(&self) -> std::option::Option<&crate::model::GameSession> {
        self.game_session.as_ref()
    }
}
impl std::fmt::Debug for UpdateGameSessionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGameSessionOutput");
        formatter.field("game_session", &self.game_session);
        formatter.finish()
    }
}
/// See [`UpdateGameSessionOutput`](crate::output::UpdateGameSessionOutput)
pub mod update_game_session_output {
    /// A builder for [`UpdateGameSessionOutput`](crate::output::UpdateGameSessionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_session: std::option::Option<crate::model::GameSession>,
    }
    impl Builder {
        /// <p>The updated game session properties.</p>
        pub fn game_session(mut self, input: crate::model::GameSession) -> Self {
            self.game_session = Some(input);
            self
        }
        /// <p>The updated game session properties.</p>
        pub fn set_game_session(
            mut self,
            input: std::option::Option<crate::model::GameSession>,
        ) -> Self {
            self.game_session = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGameSessionOutput`](crate::output::UpdateGameSessionOutput)
        pub fn build(self) -> crate::output::UpdateGameSessionOutput {
            crate::output::UpdateGameSessionOutput {
                game_session: self.game_session,
            }
        }
    }
}
impl UpdateGameSessionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateGameSessionOutput`](crate::output::UpdateGameSessionOutput)
    pub fn builder() -> crate::output::update_game_session_output::Builder {
        crate::output::update_game_session_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGameServerGroupOutput {
    /// <p>An object that describes the game server group resource with updated properties. </p>
    pub game_server_group: std::option::Option<crate::model::GameServerGroup>,
}
impl UpdateGameServerGroupOutput {
    /// <p>An object that describes the game server group resource with updated properties. </p>
    pub fn game_server_group(&self) -> std::option::Option<&crate::model::GameServerGroup> {
        self.game_server_group.as_ref()
    }
}
impl std::fmt::Debug for UpdateGameServerGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGameServerGroupOutput");
        formatter.field("game_server_group", &self.game_server_group);
        formatter.finish()
    }
}
/// See [`UpdateGameServerGroupOutput`](crate::output::UpdateGameServerGroupOutput)
pub mod update_game_server_group_output {
    /// A builder for [`UpdateGameServerGroupOutput`](crate::output::UpdateGameServerGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_server_group: std::option::Option<crate::model::GameServerGroup>,
    }
    impl Builder {
        /// <p>An object that describes the game server group resource with updated properties. </p>
        pub fn game_server_group(mut self, input: crate::model::GameServerGroup) -> Self {
            self.game_server_group = Some(input);
            self
        }
        /// <p>An object that describes the game server group resource with updated properties. </p>
        pub fn set_game_server_group(
            mut self,
            input: std::option::Option<crate::model::GameServerGroup>,
        ) -> Self {
            self.game_server_group = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGameServerGroupOutput`](crate::output::UpdateGameServerGroupOutput)
        pub fn build(self) -> crate::output::UpdateGameServerGroupOutput {
            crate::output::UpdateGameServerGroupOutput {
                game_server_group: self.game_server_group,
            }
        }
    }
}
impl UpdateGameServerGroupOutput {
    /// Creates a new builder-style object to manufacture [`UpdateGameServerGroupOutput`](crate::output::UpdateGameServerGroupOutput)
    pub fn builder() -> crate::output::update_game_server_group_output::Builder {
        crate::output::update_game_server_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGameServerOutput {
    /// <p>Object that describes the newly updated game server.</p>
    pub game_server: std::option::Option<crate::model::GameServer>,
}
impl UpdateGameServerOutput {
    /// <p>Object that describes the newly updated game server.</p>
    pub fn game_server(&self) -> std::option::Option<&crate::model::GameServer> {
        self.game_server.as_ref()
    }
}
impl std::fmt::Debug for UpdateGameServerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGameServerOutput");
        formatter.field("game_server", &self.game_server);
        formatter.finish()
    }
}
/// See [`UpdateGameServerOutput`](crate::output::UpdateGameServerOutput)
pub mod update_game_server_output {
    /// A builder for [`UpdateGameServerOutput`](crate::output::UpdateGameServerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_server: std::option::Option<crate::model::GameServer>,
    }
    impl Builder {
        /// <p>Object that describes the newly updated game server.</p>
        pub fn game_server(mut self, input: crate::model::GameServer) -> Self {
            self.game_server = Some(input);
            self
        }
        /// <p>Object that describes the newly updated game server.</p>
        pub fn set_game_server(
            mut self,
            input: std::option::Option<crate::model::GameServer>,
        ) -> Self {
            self.game_server = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGameServerOutput`](crate::output::UpdateGameServerOutput)
        pub fn build(self) -> crate::output::UpdateGameServerOutput {
            crate::output::UpdateGameServerOutput {
                game_server: self.game_server,
            }
        }
    }
}
impl UpdateGameServerOutput {
    /// Creates a new builder-style object to manufacture [`UpdateGameServerOutput`](crate::output::UpdateGameServerOutput)
    pub fn builder() -> crate::output::update_game_server_output::Builder {
        crate::output::update_game_server_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFleetPortSettingsOutput {
    /// <p>A unique identifier for the fleet that was updated.</p>
    pub fleet_id: std::option::Option<std::string::String>,
}
impl UpdateFleetPortSettingsOutput {
    /// <p>A unique identifier for the fleet that was updated.</p>
    pub fn fleet_id(&self) -> std::option::Option<&str> {
        self.fleet_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateFleetPortSettingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFleetPortSettingsOutput");
        formatter.field("fleet_id", &self.fleet_id);
        formatter.finish()
    }
}
/// See [`UpdateFleetPortSettingsOutput`](crate::output::UpdateFleetPortSettingsOutput)
pub mod update_fleet_port_settings_output {
    /// A builder for [`UpdateFleetPortSettingsOutput`](crate::output::UpdateFleetPortSettingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet that was updated.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet that was updated.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFleetPortSettingsOutput`](crate::output::UpdateFleetPortSettingsOutput)
        pub fn build(self) -> crate::output::UpdateFleetPortSettingsOutput {
            crate::output::UpdateFleetPortSettingsOutput {
                fleet_id: self.fleet_id,
            }
        }
    }
}
impl UpdateFleetPortSettingsOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFleetPortSettingsOutput`](crate::output::UpdateFleetPortSettingsOutput)
    pub fn builder() -> crate::output::update_fleet_port_settings_output::Builder {
        crate::output::update_fleet_port_settings_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFleetCapacityOutput {
    /// <p>A unique identifier for the fleet that was updated.</p>
    pub fleet_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
    /// </region></code>. </p>
    pub fleet_arn: std::option::Option<std::string::String>,
    /// <p>The remote location being updated, expressed as an Amazon Web Services Region code, such as <code>us-west-2</code>.</p>
    pub location: std::option::Option<std::string::String>,
}
impl UpdateFleetCapacityOutput {
    /// <p>A unique identifier for the fleet that was updated.</p>
    pub fn fleet_id(&self) -> std::option::Option<&str> {
        self.fleet_id.as_deref()
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
    /// </region></code>. </p>
    pub fn fleet_arn(&self) -> std::option::Option<&str> {
        self.fleet_arn.as_deref()
    }
    /// <p>The remote location being updated, expressed as an Amazon Web Services Region code, such as <code>us-west-2</code>.</p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
}
impl std::fmt::Debug for UpdateFleetCapacityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFleetCapacityOutput");
        formatter.field("fleet_id", &self.fleet_id);
        formatter.field("fleet_arn", &self.fleet_arn);
        formatter.field("location", &self.location);
        formatter.finish()
    }
}
/// See [`UpdateFleetCapacityOutput`](crate::output::UpdateFleetCapacityOutput)
pub mod update_fleet_capacity_output {
    /// A builder for [`UpdateFleetCapacityOutput`](crate::output::UpdateFleetCapacityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) fleet_arn: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet that was updated.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet that was updated.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
        /// </region></code>. </p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
        /// </region></code>. </p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_arn = input;
            self
        }
        /// <p>The remote location being updated, expressed as an Amazon Web Services Region code, such as <code>us-west-2</code>.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The remote location being updated, expressed as an Amazon Web Services Region code, such as <code>us-west-2</code>.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFleetCapacityOutput`](crate::output::UpdateFleetCapacityOutput)
        pub fn build(self) -> crate::output::UpdateFleetCapacityOutput {
            crate::output::UpdateFleetCapacityOutput {
                fleet_id: self.fleet_id,
                fleet_arn: self.fleet_arn,
                location: self.location,
            }
        }
    }
}
impl UpdateFleetCapacityOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFleetCapacityOutput`](crate::output::UpdateFleetCapacityOutput)
    pub fn builder() -> crate::output::update_fleet_capacity_output::Builder {
        crate::output::update_fleet_capacity_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFleetAttributesOutput {
    /// <p>A unique identifier for the fleet that was updated.</p>
    pub fleet_id: std::option::Option<std::string::String>,
}
impl UpdateFleetAttributesOutput {
    /// <p>A unique identifier for the fleet that was updated.</p>
    pub fn fleet_id(&self) -> std::option::Option<&str> {
        self.fleet_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateFleetAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFleetAttributesOutput");
        formatter.field("fleet_id", &self.fleet_id);
        formatter.finish()
    }
}
/// See [`UpdateFleetAttributesOutput`](crate::output::UpdateFleetAttributesOutput)
pub mod update_fleet_attributes_output {
    /// A builder for [`UpdateFleetAttributesOutput`](crate::output::UpdateFleetAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet that was updated.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet that was updated.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFleetAttributesOutput`](crate::output::UpdateFleetAttributesOutput)
        pub fn build(self) -> crate::output::UpdateFleetAttributesOutput {
            crate::output::UpdateFleetAttributesOutput {
                fleet_id: self.fleet_id,
            }
        }
    }
}
impl UpdateFleetAttributesOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFleetAttributesOutput`](crate::output::UpdateFleetAttributesOutput)
    pub fn builder() -> crate::output::update_fleet_attributes_output::Builder {
        crate::output::update_fleet_attributes_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBuildOutput {
    /// <p>The updated build resource.</p>
    ///
    /// _Note: This member has been renamed from `build`._
    pub build_value: std::option::Option<crate::model::Build>,
}
impl UpdateBuildOutput {
    /// <p>The updated build resource.</p>
    ///
    /// _Note: This member has been renamed from `build`._
    pub fn build_value(&self) -> std::option::Option<&crate::model::Build> {
        self.build_value.as_ref()
    }
}
impl std::fmt::Debug for UpdateBuildOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBuildOutput");
        formatter.field("build_value", &self.build_value);
        formatter.finish()
    }
}
/// See [`UpdateBuildOutput`](crate::output::UpdateBuildOutput)
pub mod update_build_output {
    /// A builder for [`UpdateBuildOutput`](crate::output::UpdateBuildOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) build_value: std::option::Option<crate::model::Build>,
    }
    impl Builder {
        /// <p>The updated build resource.</p>
        pub fn build_value(mut self, input: crate::model::Build) -> Self {
            self.build_value = Some(input);
            self
        }
        /// <p>The updated build resource.</p>
        pub fn set_build(mut self, input: std::option::Option<crate::model::Build>) -> Self {
            self.build_value = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBuildOutput`](crate::output::UpdateBuildOutput)
        pub fn build(self) -> crate::output::UpdateBuildOutput {
            crate::output::UpdateBuildOutput {
                build_value: self.build_value,
            }
        }
    }
}
impl UpdateBuildOutput {
    /// Creates a new builder-style object to manufacture [`UpdateBuildOutput`](crate::output::UpdateBuildOutput)
    pub fn builder() -> crate::output::update_build_output::Builder {
        crate::output::update_build_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAliasOutput {
    /// <p>The updated alias resource.</p>
    pub alias: std::option::Option<crate::model::Alias>,
}
impl UpdateAliasOutput {
    /// <p>The updated alias resource.</p>
    pub fn alias(&self) -> std::option::Option<&crate::model::Alias> {
        self.alias.as_ref()
    }
}
impl std::fmt::Debug for UpdateAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAliasOutput");
        formatter.field("alias", &self.alias);
        formatter.finish()
    }
}
/// See [`UpdateAliasOutput`](crate::output::UpdateAliasOutput)
pub mod update_alias_output {
    /// A builder for [`UpdateAliasOutput`](crate::output::UpdateAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alias: std::option::Option<crate::model::Alias>,
    }
    impl Builder {
        /// <p>The updated alias resource.</p>
        pub fn alias(mut self, input: crate::model::Alias) -> Self {
            self.alias = Some(input);
            self
        }
        /// <p>The updated alias resource.</p>
        pub fn set_alias(mut self, input: std::option::Option<crate::model::Alias>) -> Self {
            self.alias = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAliasOutput`](crate::output::UpdateAliasOutput)
        pub fn build(self) -> crate::output::UpdateAliasOutput {
            crate::output::UpdateAliasOutput { alias: self.alias }
        }
    }
}
impl UpdateAliasOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAliasOutput`](crate::output::UpdateAliasOutput)
    pub fn builder() -> crate::output::update_alias_output::Builder {
        crate::output::update_alias_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SuspendGameServerGroupOutput {
    /// <p>An object that describes the game server group resource, with the <code>SuspendedActions</code> property updated to reflect the suspended activity.</p>
    pub game_server_group: std::option::Option<crate::model::GameServerGroup>,
}
impl SuspendGameServerGroupOutput {
    /// <p>An object that describes the game server group resource, with the <code>SuspendedActions</code> property updated to reflect the suspended activity.</p>
    pub fn game_server_group(&self) -> std::option::Option<&crate::model::GameServerGroup> {
        self.game_server_group.as_ref()
    }
}
impl std::fmt::Debug for SuspendGameServerGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SuspendGameServerGroupOutput");
        formatter.field("game_server_group", &self.game_server_group);
        formatter.finish()
    }
}
/// See [`SuspendGameServerGroupOutput`](crate::output::SuspendGameServerGroupOutput)
pub mod suspend_game_server_group_output {
    /// A builder for [`SuspendGameServerGroupOutput`](crate::output::SuspendGameServerGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_server_group: std::option::Option<crate::model::GameServerGroup>,
    }
    impl Builder {
        /// <p>An object that describes the game server group resource, with the <code>SuspendedActions</code> property updated to reflect the suspended activity.</p>
        pub fn game_server_group(mut self, input: crate::model::GameServerGroup) -> Self {
            self.game_server_group = Some(input);
            self
        }
        /// <p>An object that describes the game server group resource, with the <code>SuspendedActions</code> property updated to reflect the suspended activity.</p>
        pub fn set_game_server_group(
            mut self,
            input: std::option::Option<crate::model::GameServerGroup>,
        ) -> Self {
            self.game_server_group = input;
            self
        }
        /// Consumes the builder and constructs a [`SuspendGameServerGroupOutput`](crate::output::SuspendGameServerGroupOutput)
        pub fn build(self) -> crate::output::SuspendGameServerGroupOutput {
            crate::output::SuspendGameServerGroupOutput {
                game_server_group: self.game_server_group,
            }
        }
    }
}
impl SuspendGameServerGroupOutput {
    /// Creates a new builder-style object to manufacture [`SuspendGameServerGroupOutput`](crate::output::SuspendGameServerGroupOutput)
    pub fn builder() -> crate::output::suspend_game_server_group_output::Builder {
        crate::output::suspend_game_server_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopMatchmakingOutput {}
impl std::fmt::Debug for StopMatchmakingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopMatchmakingOutput");
        formatter.finish()
    }
}
/// See [`StopMatchmakingOutput`](crate::output::StopMatchmakingOutput)
pub mod stop_matchmaking_output {
    /// A builder for [`StopMatchmakingOutput`](crate::output::StopMatchmakingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StopMatchmakingOutput`](crate::output::StopMatchmakingOutput)
        pub fn build(self) -> crate::output::StopMatchmakingOutput {
            crate::output::StopMatchmakingOutput {}
        }
    }
}
impl StopMatchmakingOutput {
    /// Creates a new builder-style object to manufacture [`StopMatchmakingOutput`](crate::output::StopMatchmakingOutput)
    pub fn builder() -> crate::output::stop_matchmaking_output::Builder {
        crate::output::stop_matchmaking_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopGameSessionPlacementOutput {
    /// <p>Object that describes the canceled game session placement, with <code>CANCELLED</code> status and an end time stamp. </p>
    pub game_session_placement: std::option::Option<crate::model::GameSessionPlacement>,
}
impl StopGameSessionPlacementOutput {
    /// <p>Object that describes the canceled game session placement, with <code>CANCELLED</code> status and an end time stamp. </p>
    pub fn game_session_placement(
        &self,
    ) -> std::option::Option<&crate::model::GameSessionPlacement> {
        self.game_session_placement.as_ref()
    }
}
impl std::fmt::Debug for StopGameSessionPlacementOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopGameSessionPlacementOutput");
        formatter.field("game_session_placement", &self.game_session_placement);
        formatter.finish()
    }
}
/// See [`StopGameSessionPlacementOutput`](crate::output::StopGameSessionPlacementOutput)
pub mod stop_game_session_placement_output {
    /// A builder for [`StopGameSessionPlacementOutput`](crate::output::StopGameSessionPlacementOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_session_placement: std::option::Option<crate::model::GameSessionPlacement>,
    }
    impl Builder {
        /// <p>Object that describes the canceled game session placement, with <code>CANCELLED</code> status and an end time stamp. </p>
        pub fn game_session_placement(mut self, input: crate::model::GameSessionPlacement) -> Self {
            self.game_session_placement = Some(input);
            self
        }
        /// <p>Object that describes the canceled game session placement, with <code>CANCELLED</code> status and an end time stamp. </p>
        pub fn set_game_session_placement(
            mut self,
            input: std::option::Option<crate::model::GameSessionPlacement>,
        ) -> Self {
            self.game_session_placement = input;
            self
        }
        /// Consumes the builder and constructs a [`StopGameSessionPlacementOutput`](crate::output::StopGameSessionPlacementOutput)
        pub fn build(self) -> crate::output::StopGameSessionPlacementOutput {
            crate::output::StopGameSessionPlacementOutput {
                game_session_placement: self.game_session_placement,
            }
        }
    }
}
impl StopGameSessionPlacementOutput {
    /// Creates a new builder-style object to manufacture [`StopGameSessionPlacementOutput`](crate::output::StopGameSessionPlacementOutput)
    pub fn builder() -> crate::output::stop_game_session_placement_output::Builder {
        crate::output::stop_game_session_placement_output::Builder::default()
    }
}

/// <p>Represents the input for a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopFleetActionsOutput {
    /// <p>A unique identifier for the fleet to stop actions on.</p>
    pub fleet_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
    /// </region></code>.</p>
    pub fleet_arn: std::option::Option<std::string::String>,
}
impl StopFleetActionsOutput {
    /// <p>A unique identifier for the fleet to stop actions on.</p>
    pub fn fleet_id(&self) -> std::option::Option<&str> {
        self.fleet_id.as_deref()
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
    /// </region></code>.</p>
    pub fn fleet_arn(&self) -> std::option::Option<&str> {
        self.fleet_arn.as_deref()
    }
}
impl std::fmt::Debug for StopFleetActionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopFleetActionsOutput");
        formatter.field("fleet_id", &self.fleet_id);
        formatter.field("fleet_arn", &self.fleet_arn);
        formatter.finish()
    }
}
/// See [`StopFleetActionsOutput`](crate::output::StopFleetActionsOutput)
pub mod stop_fleet_actions_output {
    /// A builder for [`StopFleetActionsOutput`](crate::output::StopFleetActionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) fleet_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet to stop actions on.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet to stop actions on.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
        /// </region></code>.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
        /// </region></code>.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`StopFleetActionsOutput`](crate::output::StopFleetActionsOutput)
        pub fn build(self) -> crate::output::StopFleetActionsOutput {
            crate::output::StopFleetActionsOutput {
                fleet_id: self.fleet_id,
                fleet_arn: self.fleet_arn,
            }
        }
    }
}
impl StopFleetActionsOutput {
    /// Creates a new builder-style object to manufacture [`StopFleetActionsOutput`](crate::output::StopFleetActionsOutput)
    pub fn builder() -> crate::output::stop_fleet_actions_output::Builder {
        crate::output::stop_fleet_actions_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartMatchmakingOutput {
    /// <p>Ticket representing the matchmaking request. This object include the information included in the request, ticket status, and match results as generated during the matchmaking process.</p>
    pub matchmaking_ticket: std::option::Option<crate::model::MatchmakingTicket>,
}
impl StartMatchmakingOutput {
    /// <p>Ticket representing the matchmaking request. This object include the information included in the request, ticket status, and match results as generated during the matchmaking process.</p>
    pub fn matchmaking_ticket(&self) -> std::option::Option<&crate::model::MatchmakingTicket> {
        self.matchmaking_ticket.as_ref()
    }
}
impl std::fmt::Debug for StartMatchmakingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartMatchmakingOutput");
        formatter.field("matchmaking_ticket", &self.matchmaking_ticket);
        formatter.finish()
    }
}
/// See [`StartMatchmakingOutput`](crate::output::StartMatchmakingOutput)
pub mod start_matchmaking_output {
    /// A builder for [`StartMatchmakingOutput`](crate::output::StartMatchmakingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) matchmaking_ticket: std::option::Option<crate::model::MatchmakingTicket>,
    }
    impl Builder {
        /// <p>Ticket representing the matchmaking request. This object include the information included in the request, ticket status, and match results as generated during the matchmaking process.</p>
        pub fn matchmaking_ticket(mut self, input: crate::model::MatchmakingTicket) -> Self {
            self.matchmaking_ticket = Some(input);
            self
        }
        /// <p>Ticket representing the matchmaking request. This object include the information included in the request, ticket status, and match results as generated during the matchmaking process.</p>
        pub fn set_matchmaking_ticket(
            mut self,
            input: std::option::Option<crate::model::MatchmakingTicket>,
        ) -> Self {
            self.matchmaking_ticket = input;
            self
        }
        /// Consumes the builder and constructs a [`StartMatchmakingOutput`](crate::output::StartMatchmakingOutput)
        pub fn build(self) -> crate::output::StartMatchmakingOutput {
            crate::output::StartMatchmakingOutput {
                matchmaking_ticket: self.matchmaking_ticket,
            }
        }
    }
}
impl StartMatchmakingOutput {
    /// Creates a new builder-style object to manufacture [`StartMatchmakingOutput`](crate::output::StartMatchmakingOutput)
    pub fn builder() -> crate::output::start_matchmaking_output::Builder {
        crate::output::start_matchmaking_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartMatchBackfillOutput {
    /// <p>Ticket representing the backfill matchmaking request. This object includes the information in the request, ticket status, and match results as generated during the matchmaking process.</p>
    pub matchmaking_ticket: std::option::Option<crate::model::MatchmakingTicket>,
}
impl StartMatchBackfillOutput {
    /// <p>Ticket representing the backfill matchmaking request. This object includes the information in the request, ticket status, and match results as generated during the matchmaking process.</p>
    pub fn matchmaking_ticket(&self) -> std::option::Option<&crate::model::MatchmakingTicket> {
        self.matchmaking_ticket.as_ref()
    }
}
impl std::fmt::Debug for StartMatchBackfillOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartMatchBackfillOutput");
        formatter.field("matchmaking_ticket", &self.matchmaking_ticket);
        formatter.finish()
    }
}
/// See [`StartMatchBackfillOutput`](crate::output::StartMatchBackfillOutput)
pub mod start_match_backfill_output {
    /// A builder for [`StartMatchBackfillOutput`](crate::output::StartMatchBackfillOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) matchmaking_ticket: std::option::Option<crate::model::MatchmakingTicket>,
    }
    impl Builder {
        /// <p>Ticket representing the backfill matchmaking request. This object includes the information in the request, ticket status, and match results as generated during the matchmaking process.</p>
        pub fn matchmaking_ticket(mut self, input: crate::model::MatchmakingTicket) -> Self {
            self.matchmaking_ticket = Some(input);
            self
        }
        /// <p>Ticket representing the backfill matchmaking request. This object includes the information in the request, ticket status, and match results as generated during the matchmaking process.</p>
        pub fn set_matchmaking_ticket(
            mut self,
            input: std::option::Option<crate::model::MatchmakingTicket>,
        ) -> Self {
            self.matchmaking_ticket = input;
            self
        }
        /// Consumes the builder and constructs a [`StartMatchBackfillOutput`](crate::output::StartMatchBackfillOutput)
        pub fn build(self) -> crate::output::StartMatchBackfillOutput {
            crate::output::StartMatchBackfillOutput {
                matchmaking_ticket: self.matchmaking_ticket,
            }
        }
    }
}
impl StartMatchBackfillOutput {
    /// Creates a new builder-style object to manufacture [`StartMatchBackfillOutput`](crate::output::StartMatchBackfillOutput)
    pub fn builder() -> crate::output::start_match_backfill_output::Builder {
        crate::output::start_match_backfill_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartGameSessionPlacementOutput {
    /// <p>Object that describes the newly created game session placement. This object includes all the information provided in the request, as well as start/end time stamps and placement status. </p>
    pub game_session_placement: std::option::Option<crate::model::GameSessionPlacement>,
}
impl StartGameSessionPlacementOutput {
    /// <p>Object that describes the newly created game session placement. This object includes all the information provided in the request, as well as start/end time stamps and placement status. </p>
    pub fn game_session_placement(
        &self,
    ) -> std::option::Option<&crate::model::GameSessionPlacement> {
        self.game_session_placement.as_ref()
    }
}
impl std::fmt::Debug for StartGameSessionPlacementOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartGameSessionPlacementOutput");
        formatter.field("game_session_placement", &self.game_session_placement);
        formatter.finish()
    }
}
/// See [`StartGameSessionPlacementOutput`](crate::output::StartGameSessionPlacementOutput)
pub mod start_game_session_placement_output {
    /// A builder for [`StartGameSessionPlacementOutput`](crate::output::StartGameSessionPlacementOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_session_placement: std::option::Option<crate::model::GameSessionPlacement>,
    }
    impl Builder {
        /// <p>Object that describes the newly created game session placement. This object includes all the information provided in the request, as well as start/end time stamps and placement status. </p>
        pub fn game_session_placement(mut self, input: crate::model::GameSessionPlacement) -> Self {
            self.game_session_placement = Some(input);
            self
        }
        /// <p>Object that describes the newly created game session placement. This object includes all the information provided in the request, as well as start/end time stamps and placement status. </p>
        pub fn set_game_session_placement(
            mut self,
            input: std::option::Option<crate::model::GameSessionPlacement>,
        ) -> Self {
            self.game_session_placement = input;
            self
        }
        /// Consumes the builder and constructs a [`StartGameSessionPlacementOutput`](crate::output::StartGameSessionPlacementOutput)
        pub fn build(self) -> crate::output::StartGameSessionPlacementOutput {
            crate::output::StartGameSessionPlacementOutput {
                game_session_placement: self.game_session_placement,
            }
        }
    }
}
impl StartGameSessionPlacementOutput {
    /// Creates a new builder-style object to manufacture [`StartGameSessionPlacementOutput`](crate::output::StartGameSessionPlacementOutput)
    pub fn builder() -> crate::output::start_game_session_placement_output::Builder {
        crate::output::start_game_session_placement_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartFleetActionsOutput {
    /// <p>A unique identifier for the fleet to restart actions on.</p>
    pub fleet_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
    /// </region></code>.</p>
    pub fleet_arn: std::option::Option<std::string::String>,
}
impl StartFleetActionsOutput {
    /// <p>A unique identifier for the fleet to restart actions on.</p>
    pub fn fleet_id(&self) -> std::option::Option<&str> {
        self.fleet_id.as_deref()
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
    /// </region></code>.</p>
    pub fn fleet_arn(&self) -> std::option::Option<&str> {
        self.fleet_arn.as_deref()
    }
}
impl std::fmt::Debug for StartFleetActionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartFleetActionsOutput");
        formatter.field("fleet_id", &self.fleet_id);
        formatter.field("fleet_arn", &self.fleet_arn);
        formatter.finish()
    }
}
/// See [`StartFleetActionsOutput`](crate::output::StartFleetActionsOutput)
pub mod start_fleet_actions_output {
    /// A builder for [`StartFleetActionsOutput`](crate::output::StartFleetActionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) fleet_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet to restart actions on.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet to restart actions on.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
        /// </region></code>.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
        /// </region></code>.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`StartFleetActionsOutput`](crate::output::StartFleetActionsOutput)
        pub fn build(self) -> crate::output::StartFleetActionsOutput {
            crate::output::StartFleetActionsOutput {
                fleet_id: self.fleet_id,
                fleet_arn: self.fleet_arn,
            }
        }
    }
}
impl StartFleetActionsOutput {
    /// Creates a new builder-style object to manufacture [`StartFleetActionsOutput`](crate::output::StartFleetActionsOutput)
    pub fn builder() -> crate::output::start_fleet_actions_output::Builder {
        crate::output::start_fleet_actions_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchGameSessionsOutput {
    /// <p>A collection of objects containing game session properties for each session that matches the request.</p>
    pub game_sessions: std::option::Option<std::vec::Vec<crate::model::GameSession>>,
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl SearchGameSessionsOutput {
    /// <p>A collection of objects containing game session properties for each session that matches the request.</p>
    pub fn game_sessions(&self) -> std::option::Option<&[crate::model::GameSession]> {
        self.game_sessions.as_deref()
    }
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for SearchGameSessionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchGameSessionsOutput");
        formatter.field("game_sessions", &self.game_sessions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`SearchGameSessionsOutput`](crate::output::SearchGameSessionsOutput)
pub mod search_game_sessions_output {
    /// A builder for [`SearchGameSessionsOutput`](crate::output::SearchGameSessionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_sessions: std::option::Option<std::vec::Vec<crate::model::GameSession>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `game_sessions`.
        ///
        /// To override the contents of this collection use [`set_game_sessions`](Self::set_game_sessions).
        ///
        /// <p>A collection of objects containing game session properties for each session that matches the request.</p>
        pub fn game_sessions(mut self, input: crate::model::GameSession) -> Self {
            let mut v = self.game_sessions.unwrap_or_default();
            v.push(input);
            self.game_sessions = Some(v);
            self
        }
        /// <p>A collection of objects containing game session properties for each session that matches the request.</p>
        pub fn set_game_sessions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GameSession>>,
        ) -> Self {
            self.game_sessions = input;
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchGameSessionsOutput`](crate::output::SearchGameSessionsOutput)
        pub fn build(self) -> crate::output::SearchGameSessionsOutput {
            crate::output::SearchGameSessionsOutput {
                game_sessions: self.game_sessions,
                next_token: self.next_token,
            }
        }
    }
}
impl SearchGameSessionsOutput {
    /// Creates a new builder-style object to manufacture [`SearchGameSessionsOutput`](crate::output::SearchGameSessionsOutput)
    pub fn builder() -> crate::output::search_game_sessions_output::Builder {
        crate::output::search_game_sessions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResumeGameServerGroupOutput {
    /// <p>An object that describes the game server group resource, with the <code>SuspendedActions</code> property updated to reflect the resumed activity.</p>
    pub game_server_group: std::option::Option<crate::model::GameServerGroup>,
}
impl ResumeGameServerGroupOutput {
    /// <p>An object that describes the game server group resource, with the <code>SuspendedActions</code> property updated to reflect the resumed activity.</p>
    pub fn game_server_group(&self) -> std::option::Option<&crate::model::GameServerGroup> {
        self.game_server_group.as_ref()
    }
}
impl std::fmt::Debug for ResumeGameServerGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResumeGameServerGroupOutput");
        formatter.field("game_server_group", &self.game_server_group);
        formatter.finish()
    }
}
/// See [`ResumeGameServerGroupOutput`](crate::output::ResumeGameServerGroupOutput)
pub mod resume_game_server_group_output {
    /// A builder for [`ResumeGameServerGroupOutput`](crate::output::ResumeGameServerGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_server_group: std::option::Option<crate::model::GameServerGroup>,
    }
    impl Builder {
        /// <p>An object that describes the game server group resource, with the <code>SuspendedActions</code> property updated to reflect the resumed activity.</p>
        pub fn game_server_group(mut self, input: crate::model::GameServerGroup) -> Self {
            self.game_server_group = Some(input);
            self
        }
        /// <p>An object that describes the game server group resource, with the <code>SuspendedActions</code> property updated to reflect the resumed activity.</p>
        pub fn set_game_server_group(
            mut self,
            input: std::option::Option<crate::model::GameServerGroup>,
        ) -> Self {
            self.game_server_group = input;
            self
        }
        /// Consumes the builder and constructs a [`ResumeGameServerGroupOutput`](crate::output::ResumeGameServerGroupOutput)
        pub fn build(self) -> crate::output::ResumeGameServerGroupOutput {
            crate::output::ResumeGameServerGroupOutput {
                game_server_group: self.game_server_group,
            }
        }
    }
}
impl ResumeGameServerGroupOutput {
    /// Creates a new builder-style object to manufacture [`ResumeGameServerGroupOutput`](crate::output::ResumeGameServerGroupOutput)
    pub fn builder() -> crate::output::resume_game_server_group_output::Builder {
        crate::output::resume_game_server_group_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResolveAliasOutput {
    /// <p>The fleet identifier that the alias is pointing to.</p>
    pub fleet_id: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift fleet resource that this alias points to. </p>
    pub fleet_arn: std::option::Option<std::string::String>,
}
impl ResolveAliasOutput {
    /// <p>The fleet identifier that the alias is pointing to.</p>
    pub fn fleet_id(&self) -> std::option::Option<&str> {
        self.fleet_id.as_deref()
    }
    /// <p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift fleet resource that this alias points to. </p>
    pub fn fleet_arn(&self) -> std::option::Option<&str> {
        self.fleet_arn.as_deref()
    }
}
impl std::fmt::Debug for ResolveAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResolveAliasOutput");
        formatter.field("fleet_id", &self.fleet_id);
        formatter.field("fleet_arn", &self.fleet_arn);
        formatter.finish()
    }
}
/// See [`ResolveAliasOutput`](crate::output::ResolveAliasOutput)
pub mod resolve_alias_output {
    /// A builder for [`ResolveAliasOutput`](crate::output::ResolveAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) fleet_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The fleet identifier that the alias is pointing to.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>The fleet identifier that the alias is pointing to.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift fleet resource that this alias points to. </p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift fleet resource that this alias points to. </p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ResolveAliasOutput`](crate::output::ResolveAliasOutput)
        pub fn build(self) -> crate::output::ResolveAliasOutput {
            crate::output::ResolveAliasOutput {
                fleet_id: self.fleet_id,
                fleet_arn: self.fleet_arn,
            }
        }
    }
}
impl ResolveAliasOutput {
    /// Creates a new builder-style object to manufacture [`ResolveAliasOutput`](crate::output::ResolveAliasOutput)
    pub fn builder() -> crate::output::resolve_alias_output::Builder {
        crate::output::resolve_alias_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestUploadCredentialsOutput {
    /// <p>Amazon Web Services credentials required when uploading a game build to the storage location. These credentials have a limited lifespan and are valid only for the build they were issued for.</p>
    pub upload_credentials: std::option::Option<crate::model::AwsCredentials>,
    /// <p>Amazon S3 path and key, identifying where the game build files are stored.</p>
    pub storage_location: std::option::Option<crate::model::S3Location>,
}
impl RequestUploadCredentialsOutput {
    /// <p>Amazon Web Services credentials required when uploading a game build to the storage location. These credentials have a limited lifespan and are valid only for the build they were issued for.</p>
    pub fn upload_credentials(&self) -> std::option::Option<&crate::model::AwsCredentials> {
        self.upload_credentials.as_ref()
    }
    /// <p>Amazon S3 path and key, identifying where the game build files are stored.</p>
    pub fn storage_location(&self) -> std::option::Option<&crate::model::S3Location> {
        self.storage_location.as_ref()
    }
}
impl std::fmt::Debug for RequestUploadCredentialsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequestUploadCredentialsOutput");
        formatter.field("upload_credentials", &"*** Sensitive Data Redacted ***");
        formatter.field("storage_location", &self.storage_location);
        formatter.finish()
    }
}
/// See [`RequestUploadCredentialsOutput`](crate::output::RequestUploadCredentialsOutput)
pub mod request_upload_credentials_output {
    /// A builder for [`RequestUploadCredentialsOutput`](crate::output::RequestUploadCredentialsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) upload_credentials: std::option::Option<crate::model::AwsCredentials>,
        pub(crate) storage_location: std::option::Option<crate::model::S3Location>,
    }
    impl Builder {
        /// <p>Amazon Web Services credentials required when uploading a game build to the storage location. These credentials have a limited lifespan and are valid only for the build they were issued for.</p>
        pub fn upload_credentials(mut self, input: crate::model::AwsCredentials) -> Self {
            self.upload_credentials = Some(input);
            self
        }
        /// <p>Amazon Web Services credentials required when uploading a game build to the storage location. These credentials have a limited lifespan and are valid only for the build they were issued for.</p>
        pub fn set_upload_credentials(
            mut self,
            input: std::option::Option<crate::model::AwsCredentials>,
        ) -> Self {
            self.upload_credentials = input;
            self
        }
        /// <p>Amazon S3 path and key, identifying where the game build files are stored.</p>
        pub fn storage_location(mut self, input: crate::model::S3Location) -> Self {
            self.storage_location = Some(input);
            self
        }
        /// <p>Amazon S3 path and key, identifying where the game build files are stored.</p>
        pub fn set_storage_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.storage_location = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestUploadCredentialsOutput`](crate::output::RequestUploadCredentialsOutput)
        pub fn build(self) -> crate::output::RequestUploadCredentialsOutput {
            crate::output::RequestUploadCredentialsOutput {
                upload_credentials: self.upload_credentials,
                storage_location: self.storage_location,
            }
        }
    }
}
impl RequestUploadCredentialsOutput {
    /// Creates a new builder-style object to manufacture [`RequestUploadCredentialsOutput`](crate::output::RequestUploadCredentialsOutput)
    pub fn builder() -> crate::output::request_upload_credentials_output::Builder {
        crate::output::request_upload_credentials_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterGameServerOutput {
    /// <p>Object that describes the newly registered game server.</p>
    pub game_server: std::option::Option<crate::model::GameServer>,
}
impl RegisterGameServerOutput {
    /// <p>Object that describes the newly registered game server.</p>
    pub fn game_server(&self) -> std::option::Option<&crate::model::GameServer> {
        self.game_server.as_ref()
    }
}
impl std::fmt::Debug for RegisterGameServerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterGameServerOutput");
        formatter.field("game_server", &self.game_server);
        formatter.finish()
    }
}
/// See [`RegisterGameServerOutput`](crate::output::RegisterGameServerOutput)
pub mod register_game_server_output {
    /// A builder for [`RegisterGameServerOutput`](crate::output::RegisterGameServerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_server: std::option::Option<crate::model::GameServer>,
    }
    impl Builder {
        /// <p>Object that describes the newly registered game server.</p>
        pub fn game_server(mut self, input: crate::model::GameServer) -> Self {
            self.game_server = Some(input);
            self
        }
        /// <p>Object that describes the newly registered game server.</p>
        pub fn set_game_server(
            mut self,
            input: std::option::Option<crate::model::GameServer>,
        ) -> Self {
            self.game_server = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterGameServerOutput`](crate::output::RegisterGameServerOutput)
        pub fn build(self) -> crate::output::RegisterGameServerOutput {
            crate::output::RegisterGameServerOutput {
                game_server: self.game_server,
            }
        }
    }
}
impl RegisterGameServerOutput {
    /// Creates a new builder-style object to manufacture [`RegisterGameServerOutput`](crate::output::RegisterGameServerOutput)
    pub fn builder() -> crate::output::register_game_server_output::Builder {
        crate::output::register_game_server_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutScalingPolicyOutput {
    /// <p>A descriptive label that is associated with a fleet's scaling policy. Policy names do not need to be unique.</p>
    pub name: std::option::Option<std::string::String>,
}
impl PutScalingPolicyOutput {
    /// <p>A descriptive label that is associated with a fleet's scaling policy. Policy names do not need to be unique.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for PutScalingPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutScalingPolicyOutput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`PutScalingPolicyOutput`](crate::output::PutScalingPolicyOutput)
pub mod put_scaling_policy_output {
    /// A builder for [`PutScalingPolicyOutput`](crate::output::PutScalingPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A descriptive label that is associated with a fleet's scaling policy. Policy names do not need to be unique.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A descriptive label that is associated with a fleet's scaling policy. Policy names do not need to be unique.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`PutScalingPolicyOutput`](crate::output::PutScalingPolicyOutput)
        pub fn build(self) -> crate::output::PutScalingPolicyOutput {
            crate::output::PutScalingPolicyOutput { name: self.name }
        }
    }
}
impl PutScalingPolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutScalingPolicyOutput`](crate::output::PutScalingPolicyOutput)
    pub fn builder() -> crate::output::put_scaling_policy_output::Builder {
        crate::output::put_scaling_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p> The collection of tags that have been assigned to the specified resource. </p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ListTagsForResourceOutput {
    /// <p> The collection of tags that have been assigned to the specified resource. </p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The collection of tags that have been assigned to the specified resource. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p> The collection of tags that have been assigned to the specified resource. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListScriptsOutput {
    /// <p>A set of properties describing the requested script.</p>
    pub scripts: std::option::Option<std::vec::Vec<crate::model::Script>>,
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListScriptsOutput {
    /// <p>A set of properties describing the requested script.</p>
    pub fn scripts(&self) -> std::option::Option<&[crate::model::Script]> {
        self.scripts.as_deref()
    }
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListScriptsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListScriptsOutput");
        formatter.field("scripts", &self.scripts);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListScriptsOutput`](crate::output::ListScriptsOutput)
pub mod list_scripts_output {
    /// A builder for [`ListScriptsOutput`](crate::output::ListScriptsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scripts: std::option::Option<std::vec::Vec<crate::model::Script>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `scripts`.
        ///
        /// To override the contents of this collection use [`set_scripts`](Self::set_scripts).
        ///
        /// <p>A set of properties describing the requested script.</p>
        pub fn scripts(mut self, input: crate::model::Script) -> Self {
            let mut v = self.scripts.unwrap_or_default();
            v.push(input);
            self.scripts = Some(v);
            self
        }
        /// <p>A set of properties describing the requested script.</p>
        pub fn set_scripts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Script>>,
        ) -> Self {
            self.scripts = input;
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListScriptsOutput`](crate::output::ListScriptsOutput)
        pub fn build(self) -> crate::output::ListScriptsOutput {
            crate::output::ListScriptsOutput {
                scripts: self.scripts,
                next_token: self.next_token,
            }
        }
    }
}
impl ListScriptsOutput {
    /// Creates a new builder-style object to manufacture [`ListScriptsOutput`](crate::output::ListScriptsOutput)
    pub fn builder() -> crate::output::list_scripts_output::Builder {
        crate::output::list_scripts_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGameServersOutput {
    /// <p>A collection of game server objects that match the request.</p>
    pub game_servers: std::option::Option<std::vec::Vec<crate::model::GameServer>>,
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListGameServersOutput {
    /// <p>A collection of game server objects that match the request.</p>
    pub fn game_servers(&self) -> std::option::Option<&[crate::model::GameServer]> {
        self.game_servers.as_deref()
    }
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListGameServersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGameServersOutput");
        formatter.field("game_servers", &self.game_servers);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListGameServersOutput`](crate::output::ListGameServersOutput)
pub mod list_game_servers_output {
    /// A builder for [`ListGameServersOutput`](crate::output::ListGameServersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_servers: std::option::Option<std::vec::Vec<crate::model::GameServer>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `game_servers`.
        ///
        /// To override the contents of this collection use [`set_game_servers`](Self::set_game_servers).
        ///
        /// <p>A collection of game server objects that match the request.</p>
        pub fn game_servers(mut self, input: crate::model::GameServer) -> Self {
            let mut v = self.game_servers.unwrap_or_default();
            v.push(input);
            self.game_servers = Some(v);
            self
        }
        /// <p>A collection of game server objects that match the request.</p>
        pub fn set_game_servers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GameServer>>,
        ) -> Self {
            self.game_servers = input;
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGameServersOutput`](crate::output::ListGameServersOutput)
        pub fn build(self) -> crate::output::ListGameServersOutput {
            crate::output::ListGameServersOutput {
                game_servers: self.game_servers,
                next_token: self.next_token,
            }
        }
    }
}
impl ListGameServersOutput {
    /// Creates a new builder-style object to manufacture [`ListGameServersOutput`](crate::output::ListGameServersOutput)
    pub fn builder() -> crate::output::list_game_servers_output::Builder {
        crate::output::list_game_servers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGameServerGroupsOutput {
    /// <p>A collection of game server group objects that match the request.</p>
    pub game_server_groups: std::option::Option<std::vec::Vec<crate::model::GameServerGroup>>,
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListGameServerGroupsOutput {
    /// <p>A collection of game server group objects that match the request.</p>
    pub fn game_server_groups(&self) -> std::option::Option<&[crate::model::GameServerGroup]> {
        self.game_server_groups.as_deref()
    }
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListGameServerGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGameServerGroupsOutput");
        formatter.field("game_server_groups", &self.game_server_groups);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListGameServerGroupsOutput`](crate::output::ListGameServerGroupsOutput)
pub mod list_game_server_groups_output {
    /// A builder for [`ListGameServerGroupsOutput`](crate::output::ListGameServerGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_server_groups:
            std::option::Option<std::vec::Vec<crate::model::GameServerGroup>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `game_server_groups`.
        ///
        /// To override the contents of this collection use [`set_game_server_groups`](Self::set_game_server_groups).
        ///
        /// <p>A collection of game server group objects that match the request.</p>
        pub fn game_server_groups(mut self, input: crate::model::GameServerGroup) -> Self {
            let mut v = self.game_server_groups.unwrap_or_default();
            v.push(input);
            self.game_server_groups = Some(v);
            self
        }
        /// <p>A collection of game server group objects that match the request.</p>
        pub fn set_game_server_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GameServerGroup>>,
        ) -> Self {
            self.game_server_groups = input;
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGameServerGroupsOutput`](crate::output::ListGameServerGroupsOutput)
        pub fn build(self) -> crate::output::ListGameServerGroupsOutput {
            crate::output::ListGameServerGroupsOutput {
                game_server_groups: self.game_server_groups,
                next_token: self.next_token,
            }
        }
    }
}
impl ListGameServerGroupsOutput {
    /// Creates a new builder-style object to manufacture [`ListGameServerGroupsOutput`](crate::output::ListGameServerGroupsOutput)
    pub fn builder() -> crate::output::list_game_server_groups_output::Builder {
        crate::output::list_game_server_groups_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFleetsOutput {
    /// <p>A set of fleet IDs that match the list request. You can retrieve additional information about all returned fleets by passing this result set to a <code>DescribeFleetAttributes</code>, <code>DescribeFleetCapacity</code>, or <code>DescribeFleetUtilization</code> call.</p>
    pub fleet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListFleetsOutput {
    /// <p>A set of fleet IDs that match the list request. You can retrieve additional information about all returned fleets by passing this result set to a <code>DescribeFleetAttributes</code>, <code>DescribeFleetCapacity</code>, or <code>DescribeFleetUtilization</code> call.</p>
    pub fn fleet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.fleet_ids.as_deref()
    }
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListFleetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFleetsOutput");
        formatter.field("fleet_ids", &self.fleet_ids);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListFleetsOutput`](crate::output::ListFleetsOutput)
pub mod list_fleets_output {
    /// A builder for [`ListFleetsOutput`](crate::output::ListFleetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `fleet_ids`.
        ///
        /// To override the contents of this collection use [`set_fleet_ids`](Self::set_fleet_ids).
        ///
        /// <p>A set of fleet IDs that match the list request. You can retrieve additional information about all returned fleets by passing this result set to a <code>DescribeFleetAttributes</code>, <code>DescribeFleetCapacity</code>, or <code>DescribeFleetUtilization</code> call.</p>
        pub fn fleet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.fleet_ids.unwrap_or_default();
            v.push(input.into());
            self.fleet_ids = Some(v);
            self
        }
        /// <p>A set of fleet IDs that match the list request. You can retrieve additional information about all returned fleets by passing this result set to a <code>DescribeFleetAttributes</code>, <code>DescribeFleetCapacity</code>, or <code>DescribeFleetUtilization</code> call.</p>
        pub fn set_fleet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.fleet_ids = input;
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFleetsOutput`](crate::output::ListFleetsOutput)
        pub fn build(self) -> crate::output::ListFleetsOutput {
            crate::output::ListFleetsOutput {
                fleet_ids: self.fleet_ids,
                next_token: self.next_token,
            }
        }
    }
}
impl ListFleetsOutput {
    /// Creates a new builder-style object to manufacture [`ListFleetsOutput`](crate::output::ListFleetsOutput)
    pub fn builder() -> crate::output::list_fleets_output::Builder {
        crate::output::list_fleets_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBuildsOutput {
    /// <p>A collection of build resources that match the request.</p>
    pub builds: std::option::Option<std::vec::Vec<crate::model::Build>>,
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListBuildsOutput {
    /// <p>A collection of build resources that match the request.</p>
    pub fn builds(&self) -> std::option::Option<&[crate::model::Build]> {
        self.builds.as_deref()
    }
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListBuildsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBuildsOutput");
        formatter.field("builds", &self.builds);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListBuildsOutput`](crate::output::ListBuildsOutput)
pub mod list_builds_output {
    /// A builder for [`ListBuildsOutput`](crate::output::ListBuildsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) builds: std::option::Option<std::vec::Vec<crate::model::Build>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `builds`.
        ///
        /// To override the contents of this collection use [`set_builds`](Self::set_builds).
        ///
        /// <p>A collection of build resources that match the request.</p>
        pub fn builds(mut self, input: crate::model::Build) -> Self {
            let mut v = self.builds.unwrap_or_default();
            v.push(input);
            self.builds = Some(v);
            self
        }
        /// <p>A collection of build resources that match the request.</p>
        pub fn set_builds(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Build>>,
        ) -> Self {
            self.builds = input;
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBuildsOutput`](crate::output::ListBuildsOutput)
        pub fn build(self) -> crate::output::ListBuildsOutput {
            crate::output::ListBuildsOutput {
                builds: self.builds,
                next_token: self.next_token,
            }
        }
    }
}
impl ListBuildsOutput {
    /// Creates a new builder-style object to manufacture [`ListBuildsOutput`](crate::output::ListBuildsOutput)
    pub fn builder() -> crate::output::list_builds_output::Builder {
        crate::output::list_builds_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAliasesOutput {
    /// <p>A collection of alias resources that match the request parameters.</p>
    pub aliases: std::option::Option<std::vec::Vec<crate::model::Alias>>,
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAliasesOutput {
    /// <p>A collection of alias resources that match the request parameters.</p>
    pub fn aliases(&self) -> std::option::Option<&[crate::model::Alias]> {
        self.aliases.as_deref()
    }
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAliasesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAliasesOutput");
        formatter.field("aliases", &self.aliases);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAliasesOutput`](crate::output::ListAliasesOutput)
pub mod list_aliases_output {
    /// A builder for [`ListAliasesOutput`](crate::output::ListAliasesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aliases: std::option::Option<std::vec::Vec<crate::model::Alias>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `aliases`.
        ///
        /// To override the contents of this collection use [`set_aliases`](Self::set_aliases).
        ///
        /// <p>A collection of alias resources that match the request parameters.</p>
        pub fn aliases(mut self, input: crate::model::Alias) -> Self {
            let mut v = self.aliases.unwrap_or_default();
            v.push(input);
            self.aliases = Some(v);
            self
        }
        /// <p>A collection of alias resources that match the request parameters.</p>
        pub fn set_aliases(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Alias>>,
        ) -> Self {
            self.aliases = input;
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAliasesOutput`](crate::output::ListAliasesOutput)
        pub fn build(self) -> crate::output::ListAliasesOutput {
            crate::output::ListAliasesOutput {
                aliases: self.aliases,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAliasesOutput {
    /// Creates a new builder-style object to manufacture [`ListAliasesOutput`](crate::output::ListAliasesOutput)
    pub fn builder() -> crate::output::list_aliases_output::Builder {
        crate::output::list_aliases_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetInstanceAccessOutput {
    /// <p>The connection information for a fleet instance, including IP address and access credentials.</p>
    pub instance_access: std::option::Option<crate::model::InstanceAccess>,
}
impl GetInstanceAccessOutput {
    /// <p>The connection information for a fleet instance, including IP address and access credentials.</p>
    pub fn instance_access(&self) -> std::option::Option<&crate::model::InstanceAccess> {
        self.instance_access.as_ref()
    }
}
impl std::fmt::Debug for GetInstanceAccessOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetInstanceAccessOutput");
        formatter.field("instance_access", &self.instance_access);
        formatter.finish()
    }
}
/// See [`GetInstanceAccessOutput`](crate::output::GetInstanceAccessOutput)
pub mod get_instance_access_output {
    /// A builder for [`GetInstanceAccessOutput`](crate::output::GetInstanceAccessOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_access: std::option::Option<crate::model::InstanceAccess>,
    }
    impl Builder {
        /// <p>The connection information for a fleet instance, including IP address and access credentials.</p>
        pub fn instance_access(mut self, input: crate::model::InstanceAccess) -> Self {
            self.instance_access = Some(input);
            self
        }
        /// <p>The connection information for a fleet instance, including IP address and access credentials.</p>
        pub fn set_instance_access(
            mut self,
            input: std::option::Option<crate::model::InstanceAccess>,
        ) -> Self {
            self.instance_access = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInstanceAccessOutput`](crate::output::GetInstanceAccessOutput)
        pub fn build(self) -> crate::output::GetInstanceAccessOutput {
            crate::output::GetInstanceAccessOutput {
                instance_access: self.instance_access,
            }
        }
    }
}
impl GetInstanceAccessOutput {
    /// Creates a new builder-style object to manufacture [`GetInstanceAccessOutput`](crate::output::GetInstanceAccessOutput)
    pub fn builder() -> crate::output::get_instance_access_output::Builder {
        crate::output::get_instance_access_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGameSessionLogUrlOutput {
    /// <p>Location of the requested game session logs, available for download. This URL is valid for 15 minutes, after which S3 will reject any download request using this URL. You can request a new URL any time within the 14-day period that the logs are retained.</p>
    pub pre_signed_url: std::option::Option<std::string::String>,
}
impl GetGameSessionLogUrlOutput {
    /// <p>Location of the requested game session logs, available for download. This URL is valid for 15 minutes, after which S3 will reject any download request using this URL. You can request a new URL any time within the 14-day period that the logs are retained.</p>
    pub fn pre_signed_url(&self) -> std::option::Option<&str> {
        self.pre_signed_url.as_deref()
    }
}
impl std::fmt::Debug for GetGameSessionLogUrlOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGameSessionLogUrlOutput");
        formatter.field("pre_signed_url", &self.pre_signed_url);
        formatter.finish()
    }
}
/// See [`GetGameSessionLogUrlOutput`](crate::output::GetGameSessionLogUrlOutput)
pub mod get_game_session_log_url_output {
    /// A builder for [`GetGameSessionLogUrlOutput`](crate::output::GetGameSessionLogUrlOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pre_signed_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Location of the requested game session logs, available for download. This URL is valid for 15 minutes, after which S3 will reject any download request using this URL. You can request a new URL any time within the 14-day period that the logs are retained.</p>
        pub fn pre_signed_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.pre_signed_url = Some(input.into());
            self
        }
        /// <p>Location of the requested game session logs, available for download. This URL is valid for 15 minutes, after which S3 will reject any download request using this URL. You can request a new URL any time within the 14-day period that the logs are retained.</p>
        pub fn set_pre_signed_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pre_signed_url = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGameSessionLogUrlOutput`](crate::output::GetGameSessionLogUrlOutput)
        pub fn build(self) -> crate::output::GetGameSessionLogUrlOutput {
            crate::output::GetGameSessionLogUrlOutput {
                pre_signed_url: self.pre_signed_url,
            }
        }
    }
}
impl GetGameSessionLogUrlOutput {
    /// Creates a new builder-style object to manufacture [`GetGameSessionLogUrlOutput`](crate::output::GetGameSessionLogUrlOutput)
    pub fn builder() -> crate::output::get_game_session_log_url_output::Builder {
        crate::output::get_game_session_log_url_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeVpcPeeringConnectionsOutput {
    /// <p>A collection of VPC peering connection records that match the request.</p>
    pub vpc_peering_connections:
        std::option::Option<std::vec::Vec<crate::model::VpcPeeringConnection>>,
}
impl DescribeVpcPeeringConnectionsOutput {
    /// <p>A collection of VPC peering connection records that match the request.</p>
    pub fn vpc_peering_connections(
        &self,
    ) -> std::option::Option<&[crate::model::VpcPeeringConnection]> {
        self.vpc_peering_connections.as_deref()
    }
}
impl std::fmt::Debug for DescribeVpcPeeringConnectionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeVpcPeeringConnectionsOutput");
        formatter.field("vpc_peering_connections", &self.vpc_peering_connections);
        formatter.finish()
    }
}
/// See [`DescribeVpcPeeringConnectionsOutput`](crate::output::DescribeVpcPeeringConnectionsOutput)
pub mod describe_vpc_peering_connections_output {
    /// A builder for [`DescribeVpcPeeringConnectionsOutput`](crate::output::DescribeVpcPeeringConnectionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpc_peering_connections:
            std::option::Option<std::vec::Vec<crate::model::VpcPeeringConnection>>,
    }
    impl Builder {
        /// Appends an item to `vpc_peering_connections`.
        ///
        /// To override the contents of this collection use [`set_vpc_peering_connections`](Self::set_vpc_peering_connections).
        ///
        /// <p>A collection of VPC peering connection records that match the request.</p>
        pub fn vpc_peering_connections(
            mut self,
            input: crate::model::VpcPeeringConnection,
        ) -> Self {
            let mut v = self.vpc_peering_connections.unwrap_or_default();
            v.push(input);
            self.vpc_peering_connections = Some(v);
            self
        }
        /// <p>A collection of VPC peering connection records that match the request.</p>
        pub fn set_vpc_peering_connections(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VpcPeeringConnection>>,
        ) -> Self {
            self.vpc_peering_connections = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeVpcPeeringConnectionsOutput`](crate::output::DescribeVpcPeeringConnectionsOutput)
        pub fn build(self) -> crate::output::DescribeVpcPeeringConnectionsOutput {
            crate::output::DescribeVpcPeeringConnectionsOutput {
                vpc_peering_connections: self.vpc_peering_connections,
            }
        }
    }
}
impl DescribeVpcPeeringConnectionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeVpcPeeringConnectionsOutput`](crate::output::DescribeVpcPeeringConnectionsOutput)
    pub fn builder() -> crate::output::describe_vpc_peering_connections_output::Builder {
        crate::output::describe_vpc_peering_connections_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeVpcPeeringAuthorizationsOutput {
    /// <p>A collection of objects that describe all valid VPC peering operations for the current Amazon Web Services account.</p>
    pub vpc_peering_authorizations:
        std::option::Option<std::vec::Vec<crate::model::VpcPeeringAuthorization>>,
}
impl DescribeVpcPeeringAuthorizationsOutput {
    /// <p>A collection of objects that describe all valid VPC peering operations for the current Amazon Web Services account.</p>
    pub fn vpc_peering_authorizations(
        &self,
    ) -> std::option::Option<&[crate::model::VpcPeeringAuthorization]> {
        self.vpc_peering_authorizations.as_deref()
    }
}
impl std::fmt::Debug for DescribeVpcPeeringAuthorizationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeVpcPeeringAuthorizationsOutput");
        formatter.field(
            "vpc_peering_authorizations",
            &self.vpc_peering_authorizations,
        );
        formatter.finish()
    }
}
/// See [`DescribeVpcPeeringAuthorizationsOutput`](crate::output::DescribeVpcPeeringAuthorizationsOutput)
pub mod describe_vpc_peering_authorizations_output {
    /// A builder for [`DescribeVpcPeeringAuthorizationsOutput`](crate::output::DescribeVpcPeeringAuthorizationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpc_peering_authorizations:
            std::option::Option<std::vec::Vec<crate::model::VpcPeeringAuthorization>>,
    }
    impl Builder {
        /// Appends an item to `vpc_peering_authorizations`.
        ///
        /// To override the contents of this collection use [`set_vpc_peering_authorizations`](Self::set_vpc_peering_authorizations).
        ///
        /// <p>A collection of objects that describe all valid VPC peering operations for the current Amazon Web Services account.</p>
        pub fn vpc_peering_authorizations(
            mut self,
            input: crate::model::VpcPeeringAuthorization,
        ) -> Self {
            let mut v = self.vpc_peering_authorizations.unwrap_or_default();
            v.push(input);
            self.vpc_peering_authorizations = Some(v);
            self
        }
        /// <p>A collection of objects that describe all valid VPC peering operations for the current Amazon Web Services account.</p>
        pub fn set_vpc_peering_authorizations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VpcPeeringAuthorization>>,
        ) -> Self {
            self.vpc_peering_authorizations = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeVpcPeeringAuthorizationsOutput`](crate::output::DescribeVpcPeeringAuthorizationsOutput)
        pub fn build(self) -> crate::output::DescribeVpcPeeringAuthorizationsOutput {
            crate::output::DescribeVpcPeeringAuthorizationsOutput {
                vpc_peering_authorizations: self.vpc_peering_authorizations,
            }
        }
    }
}
impl DescribeVpcPeeringAuthorizationsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeVpcPeeringAuthorizationsOutput`](crate::output::DescribeVpcPeeringAuthorizationsOutput)
    pub fn builder() -> crate::output::describe_vpc_peering_authorizations_output::Builder {
        crate::output::describe_vpc_peering_authorizations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeScriptOutput {
    /// <p>A set of properties describing the requested script.</p>
    pub script: std::option::Option<crate::model::Script>,
}
impl DescribeScriptOutput {
    /// <p>A set of properties describing the requested script.</p>
    pub fn script(&self) -> std::option::Option<&crate::model::Script> {
        self.script.as_ref()
    }
}
impl std::fmt::Debug for DescribeScriptOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeScriptOutput");
        formatter.field("script", &self.script);
        formatter.finish()
    }
}
/// See [`DescribeScriptOutput`](crate::output::DescribeScriptOutput)
pub mod describe_script_output {
    /// A builder for [`DescribeScriptOutput`](crate::output::DescribeScriptOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) script: std::option::Option<crate::model::Script>,
    }
    impl Builder {
        /// <p>A set of properties describing the requested script.</p>
        pub fn script(mut self, input: crate::model::Script) -> Self {
            self.script = Some(input);
            self
        }
        /// <p>A set of properties describing the requested script.</p>
        pub fn set_script(mut self, input: std::option::Option<crate::model::Script>) -> Self {
            self.script = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeScriptOutput`](crate::output::DescribeScriptOutput)
        pub fn build(self) -> crate::output::DescribeScriptOutput {
            crate::output::DescribeScriptOutput {
                script: self.script,
            }
        }
    }
}
impl DescribeScriptOutput {
    /// Creates a new builder-style object to manufacture [`DescribeScriptOutput`](crate::output::DescribeScriptOutput)
    pub fn builder() -> crate::output::describe_script_output::Builder {
        crate::output::describe_script_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeScalingPoliciesOutput {
    /// <p>A collection of objects containing the scaling policies matching the request.</p>
    pub scaling_policies: std::option::Option<std::vec::Vec<crate::model::ScalingPolicy>>,
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeScalingPoliciesOutput {
    /// <p>A collection of objects containing the scaling policies matching the request.</p>
    pub fn scaling_policies(&self) -> std::option::Option<&[crate::model::ScalingPolicy]> {
        self.scaling_policies.as_deref()
    }
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeScalingPoliciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeScalingPoliciesOutput");
        formatter.field("scaling_policies", &self.scaling_policies);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeScalingPoliciesOutput`](crate::output::DescribeScalingPoliciesOutput)
pub mod describe_scaling_policies_output {
    /// A builder for [`DescribeScalingPoliciesOutput`](crate::output::DescribeScalingPoliciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scaling_policies:
            std::option::Option<std::vec::Vec<crate::model::ScalingPolicy>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `scaling_policies`.
        ///
        /// To override the contents of this collection use [`set_scaling_policies`](Self::set_scaling_policies).
        ///
        /// <p>A collection of objects containing the scaling policies matching the request.</p>
        pub fn scaling_policies(mut self, input: crate::model::ScalingPolicy) -> Self {
            let mut v = self.scaling_policies.unwrap_or_default();
            v.push(input);
            self.scaling_policies = Some(v);
            self
        }
        /// <p>A collection of objects containing the scaling policies matching the request.</p>
        pub fn set_scaling_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ScalingPolicy>>,
        ) -> Self {
            self.scaling_policies = input;
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeScalingPoliciesOutput`](crate::output::DescribeScalingPoliciesOutput)
        pub fn build(self) -> crate::output::DescribeScalingPoliciesOutput {
            crate::output::DescribeScalingPoliciesOutput {
                scaling_policies: self.scaling_policies,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeScalingPoliciesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeScalingPoliciesOutput`](crate::output::DescribeScalingPoliciesOutput)
    pub fn builder() -> crate::output::describe_scaling_policies_output::Builder {
        crate::output::describe_scaling_policies_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRuntimeConfigurationOutput {
    /// <p>Instructions that describe how server processes should be launched and maintained on each instance in the fleet.</p>
    pub runtime_configuration: std::option::Option<crate::model::RuntimeConfiguration>,
}
impl DescribeRuntimeConfigurationOutput {
    /// <p>Instructions that describe how server processes should be launched and maintained on each instance in the fleet.</p>
    pub fn runtime_configuration(
        &self,
    ) -> std::option::Option<&crate::model::RuntimeConfiguration> {
        self.runtime_configuration.as_ref()
    }
}
impl std::fmt::Debug for DescribeRuntimeConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRuntimeConfigurationOutput");
        formatter.field("runtime_configuration", &self.runtime_configuration);
        formatter.finish()
    }
}
/// See [`DescribeRuntimeConfigurationOutput`](crate::output::DescribeRuntimeConfigurationOutput)
pub mod describe_runtime_configuration_output {
    /// A builder for [`DescribeRuntimeConfigurationOutput`](crate::output::DescribeRuntimeConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) runtime_configuration: std::option::Option<crate::model::RuntimeConfiguration>,
    }
    impl Builder {
        /// <p>Instructions that describe how server processes should be launched and maintained on each instance in the fleet.</p>
        pub fn runtime_configuration(mut self, input: crate::model::RuntimeConfiguration) -> Self {
            self.runtime_configuration = Some(input);
            self
        }
        /// <p>Instructions that describe how server processes should be launched and maintained on each instance in the fleet.</p>
        pub fn set_runtime_configuration(
            mut self,
            input: std::option::Option<crate::model::RuntimeConfiguration>,
        ) -> Self {
            self.runtime_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRuntimeConfigurationOutput`](crate::output::DescribeRuntimeConfigurationOutput)
        pub fn build(self) -> crate::output::DescribeRuntimeConfigurationOutput {
            crate::output::DescribeRuntimeConfigurationOutput {
                runtime_configuration: self.runtime_configuration,
            }
        }
    }
}
impl DescribeRuntimeConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeRuntimeConfigurationOutput`](crate::output::DescribeRuntimeConfigurationOutput)
    pub fn builder() -> crate::output::describe_runtime_configuration_output::Builder {
        crate::output::describe_runtime_configuration_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePlayerSessionsOutput {
    /// <p>A collection of objects containing properties for each player session that matches the request.</p>
    pub player_sessions: std::option::Option<std::vec::Vec<crate::model::PlayerSession>>,
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribePlayerSessionsOutput {
    /// <p>A collection of objects containing properties for each player session that matches the request.</p>
    pub fn player_sessions(&self) -> std::option::Option<&[crate::model::PlayerSession]> {
        self.player_sessions.as_deref()
    }
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribePlayerSessionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePlayerSessionsOutput");
        formatter.field("player_sessions", &self.player_sessions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribePlayerSessionsOutput`](crate::output::DescribePlayerSessionsOutput)
pub mod describe_player_sessions_output {
    /// A builder for [`DescribePlayerSessionsOutput`](crate::output::DescribePlayerSessionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) player_sessions: std::option::Option<std::vec::Vec<crate::model::PlayerSession>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `player_sessions`.
        ///
        /// To override the contents of this collection use [`set_player_sessions`](Self::set_player_sessions).
        ///
        /// <p>A collection of objects containing properties for each player session that matches the request.</p>
        pub fn player_sessions(mut self, input: crate::model::PlayerSession) -> Self {
            let mut v = self.player_sessions.unwrap_or_default();
            v.push(input);
            self.player_sessions = Some(v);
            self
        }
        /// <p>A collection of objects containing properties for each player session that matches the request.</p>
        pub fn set_player_sessions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlayerSession>>,
        ) -> Self {
            self.player_sessions = input;
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePlayerSessionsOutput`](crate::output::DescribePlayerSessionsOutput)
        pub fn build(self) -> crate::output::DescribePlayerSessionsOutput {
            crate::output::DescribePlayerSessionsOutput {
                player_sessions: self.player_sessions,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribePlayerSessionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribePlayerSessionsOutput`](crate::output::DescribePlayerSessionsOutput)
    pub fn builder() -> crate::output::describe_player_sessions_output::Builder {
        crate::output::describe_player_sessions_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMatchmakingRuleSetsOutput {
    /// <p>A collection of requested matchmaking rule set objects. </p>
    pub rule_sets: std::option::Option<std::vec::Vec<crate::model::MatchmakingRuleSet>>,
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeMatchmakingRuleSetsOutput {
    /// <p>A collection of requested matchmaking rule set objects. </p>
    pub fn rule_sets(&self) -> std::option::Option<&[crate::model::MatchmakingRuleSet]> {
        self.rule_sets.as_deref()
    }
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeMatchmakingRuleSetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMatchmakingRuleSetsOutput");
        formatter.field("rule_sets", &self.rule_sets);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeMatchmakingRuleSetsOutput`](crate::output::DescribeMatchmakingRuleSetsOutput)
pub mod describe_matchmaking_rule_sets_output {
    /// A builder for [`DescribeMatchmakingRuleSetsOutput`](crate::output::DescribeMatchmakingRuleSetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_sets: std::option::Option<std::vec::Vec<crate::model::MatchmakingRuleSet>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `rule_sets`.
        ///
        /// To override the contents of this collection use [`set_rule_sets`](Self::set_rule_sets).
        ///
        /// <p>A collection of requested matchmaking rule set objects. </p>
        pub fn rule_sets(mut self, input: crate::model::MatchmakingRuleSet) -> Self {
            let mut v = self.rule_sets.unwrap_or_default();
            v.push(input);
            self.rule_sets = Some(v);
            self
        }
        /// <p>A collection of requested matchmaking rule set objects. </p>
        pub fn set_rule_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MatchmakingRuleSet>>,
        ) -> Self {
            self.rule_sets = input;
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMatchmakingRuleSetsOutput`](crate::output::DescribeMatchmakingRuleSetsOutput)
        pub fn build(self) -> crate::output::DescribeMatchmakingRuleSetsOutput {
            crate::output::DescribeMatchmakingRuleSetsOutput {
                rule_sets: self.rule_sets,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeMatchmakingRuleSetsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeMatchmakingRuleSetsOutput`](crate::output::DescribeMatchmakingRuleSetsOutput)
    pub fn builder() -> crate::output::describe_matchmaking_rule_sets_output::Builder {
        crate::output::describe_matchmaking_rule_sets_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMatchmakingConfigurationsOutput {
    /// <p>A collection of requested matchmaking configurations.</p>
    pub configurations: std::option::Option<std::vec::Vec<crate::model::MatchmakingConfiguration>>,
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeMatchmakingConfigurationsOutput {
    /// <p>A collection of requested matchmaking configurations.</p>
    pub fn configurations(&self) -> std::option::Option<&[crate::model::MatchmakingConfiguration]> {
        self.configurations.as_deref()
    }
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeMatchmakingConfigurationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMatchmakingConfigurationsOutput");
        formatter.field("configurations", &self.configurations);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeMatchmakingConfigurationsOutput`](crate::output::DescribeMatchmakingConfigurationsOutput)
pub mod describe_matchmaking_configurations_output {
    /// A builder for [`DescribeMatchmakingConfigurationsOutput`](crate::output::DescribeMatchmakingConfigurationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configurations:
            std::option::Option<std::vec::Vec<crate::model::MatchmakingConfiguration>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `configurations`.
        ///
        /// To override the contents of this collection use [`set_configurations`](Self::set_configurations).
        ///
        /// <p>A collection of requested matchmaking configurations.</p>
        pub fn configurations(mut self, input: crate::model::MatchmakingConfiguration) -> Self {
            let mut v = self.configurations.unwrap_or_default();
            v.push(input);
            self.configurations = Some(v);
            self
        }
        /// <p>A collection of requested matchmaking configurations.</p>
        pub fn set_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MatchmakingConfiguration>>,
        ) -> Self {
            self.configurations = input;
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMatchmakingConfigurationsOutput`](crate::output::DescribeMatchmakingConfigurationsOutput)
        pub fn build(self) -> crate::output::DescribeMatchmakingConfigurationsOutput {
            crate::output::DescribeMatchmakingConfigurationsOutput {
                configurations: self.configurations,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeMatchmakingConfigurationsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeMatchmakingConfigurationsOutput`](crate::output::DescribeMatchmakingConfigurationsOutput)
    pub fn builder() -> crate::output::describe_matchmaking_configurations_output::Builder {
        crate::output::describe_matchmaking_configurations_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMatchmakingOutput {
    /// <p>A collection of existing matchmaking ticket objects matching the request.</p>
    pub ticket_list: std::option::Option<std::vec::Vec<crate::model::MatchmakingTicket>>,
}
impl DescribeMatchmakingOutput {
    /// <p>A collection of existing matchmaking ticket objects matching the request.</p>
    pub fn ticket_list(&self) -> std::option::Option<&[crate::model::MatchmakingTicket]> {
        self.ticket_list.as_deref()
    }
}
impl std::fmt::Debug for DescribeMatchmakingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMatchmakingOutput");
        formatter.field("ticket_list", &self.ticket_list);
        formatter.finish()
    }
}
/// See [`DescribeMatchmakingOutput`](crate::output::DescribeMatchmakingOutput)
pub mod describe_matchmaking_output {
    /// A builder for [`DescribeMatchmakingOutput`](crate::output::DescribeMatchmakingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ticket_list: std::option::Option<std::vec::Vec<crate::model::MatchmakingTicket>>,
    }
    impl Builder {
        /// Appends an item to `ticket_list`.
        ///
        /// To override the contents of this collection use [`set_ticket_list`](Self::set_ticket_list).
        ///
        /// <p>A collection of existing matchmaking ticket objects matching the request.</p>
        pub fn ticket_list(mut self, input: crate::model::MatchmakingTicket) -> Self {
            let mut v = self.ticket_list.unwrap_or_default();
            v.push(input);
            self.ticket_list = Some(v);
            self
        }
        /// <p>A collection of existing matchmaking ticket objects matching the request.</p>
        pub fn set_ticket_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MatchmakingTicket>>,
        ) -> Self {
            self.ticket_list = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMatchmakingOutput`](crate::output::DescribeMatchmakingOutput)
        pub fn build(self) -> crate::output::DescribeMatchmakingOutput {
            crate::output::DescribeMatchmakingOutput {
                ticket_list: self.ticket_list,
            }
        }
    }
}
impl DescribeMatchmakingOutput {
    /// Creates a new builder-style object to manufacture [`DescribeMatchmakingOutput`](crate::output::DescribeMatchmakingOutput)
    pub fn builder() -> crate::output::describe_matchmaking_output::Builder {
        crate::output::describe_matchmaking_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInstancesOutput {
    /// <p>A collection of objects containing properties for each instance returned.</p>
    pub instances: std::option::Option<std::vec::Vec<crate::model::Instance>>,
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeInstancesOutput {
    /// <p>A collection of objects containing properties for each instance returned.</p>
    pub fn instances(&self) -> std::option::Option<&[crate::model::Instance]> {
        self.instances.as_deref()
    }
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeInstancesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInstancesOutput");
        formatter.field("instances", &self.instances);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeInstancesOutput`](crate::output::DescribeInstancesOutput)
pub mod describe_instances_output {
    /// A builder for [`DescribeInstancesOutput`](crate::output::DescribeInstancesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instances: std::option::Option<std::vec::Vec<crate::model::Instance>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `instances`.
        ///
        /// To override the contents of this collection use [`set_instances`](Self::set_instances).
        ///
        /// <p>A collection of objects containing properties for each instance returned.</p>
        pub fn instances(mut self, input: crate::model::Instance) -> Self {
            let mut v = self.instances.unwrap_or_default();
            v.push(input);
            self.instances = Some(v);
            self
        }
        /// <p>A collection of objects containing properties for each instance returned.</p>
        pub fn set_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Instance>>,
        ) -> Self {
            self.instances = input;
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInstancesOutput`](crate::output::DescribeInstancesOutput)
        pub fn build(self) -> crate::output::DescribeInstancesOutput {
            crate::output::DescribeInstancesOutput {
                instances: self.instances,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeInstancesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeInstancesOutput`](crate::output::DescribeInstancesOutput)
    pub fn builder() -> crate::output::describe_instances_output::Builder {
        crate::output::describe_instances_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGameSessionsOutput {
    /// <p>A collection of properties for each game session that matches the request.</p>
    pub game_sessions: std::option::Option<std::vec::Vec<crate::model::GameSession>>,
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeGameSessionsOutput {
    /// <p>A collection of properties for each game session that matches the request.</p>
    pub fn game_sessions(&self) -> std::option::Option<&[crate::model::GameSession]> {
        self.game_sessions.as_deref()
    }
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeGameSessionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGameSessionsOutput");
        formatter.field("game_sessions", &self.game_sessions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeGameSessionsOutput`](crate::output::DescribeGameSessionsOutput)
pub mod describe_game_sessions_output {
    /// A builder for [`DescribeGameSessionsOutput`](crate::output::DescribeGameSessionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_sessions: std::option::Option<std::vec::Vec<crate::model::GameSession>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `game_sessions`.
        ///
        /// To override the contents of this collection use [`set_game_sessions`](Self::set_game_sessions).
        ///
        /// <p>A collection of properties for each game session that matches the request.</p>
        pub fn game_sessions(mut self, input: crate::model::GameSession) -> Self {
            let mut v = self.game_sessions.unwrap_or_default();
            v.push(input);
            self.game_sessions = Some(v);
            self
        }
        /// <p>A collection of properties for each game session that matches the request.</p>
        pub fn set_game_sessions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GameSession>>,
        ) -> Self {
            self.game_sessions = input;
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGameSessionsOutput`](crate::output::DescribeGameSessionsOutput)
        pub fn build(self) -> crate::output::DescribeGameSessionsOutput {
            crate::output::DescribeGameSessionsOutput {
                game_sessions: self.game_sessions,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeGameSessionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeGameSessionsOutput`](crate::output::DescribeGameSessionsOutput)
    pub fn builder() -> crate::output::describe_game_sessions_output::Builder {
        crate::output::describe_game_sessions_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGameSessionQueuesOutput {
    /// <p>A collection of objects that describe the requested game session queues.</p>
    pub game_session_queues: std::option::Option<std::vec::Vec<crate::model::GameSessionQueue>>,
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeGameSessionQueuesOutput {
    /// <p>A collection of objects that describe the requested game session queues.</p>
    pub fn game_session_queues(&self) -> std::option::Option<&[crate::model::GameSessionQueue]> {
        self.game_session_queues.as_deref()
    }
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeGameSessionQueuesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGameSessionQueuesOutput");
        formatter.field("game_session_queues", &self.game_session_queues);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeGameSessionQueuesOutput`](crate::output::DescribeGameSessionQueuesOutput)
pub mod describe_game_session_queues_output {
    /// A builder for [`DescribeGameSessionQueuesOutput`](crate::output::DescribeGameSessionQueuesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_session_queues:
            std::option::Option<std::vec::Vec<crate::model::GameSessionQueue>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `game_session_queues`.
        ///
        /// To override the contents of this collection use [`set_game_session_queues`](Self::set_game_session_queues).
        ///
        /// <p>A collection of objects that describe the requested game session queues.</p>
        pub fn game_session_queues(mut self, input: crate::model::GameSessionQueue) -> Self {
            let mut v = self.game_session_queues.unwrap_or_default();
            v.push(input);
            self.game_session_queues = Some(v);
            self
        }
        /// <p>A collection of objects that describe the requested game session queues.</p>
        pub fn set_game_session_queues(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GameSessionQueue>>,
        ) -> Self {
            self.game_session_queues = input;
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGameSessionQueuesOutput`](crate::output::DescribeGameSessionQueuesOutput)
        pub fn build(self) -> crate::output::DescribeGameSessionQueuesOutput {
            crate::output::DescribeGameSessionQueuesOutput {
                game_session_queues: self.game_session_queues,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeGameSessionQueuesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeGameSessionQueuesOutput`](crate::output::DescribeGameSessionQueuesOutput)
    pub fn builder() -> crate::output::describe_game_session_queues_output::Builder {
        crate::output::describe_game_session_queues_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGameSessionPlacementOutput {
    /// <p>Object that describes the requested game session placement.</p>
    pub game_session_placement: std::option::Option<crate::model::GameSessionPlacement>,
}
impl DescribeGameSessionPlacementOutput {
    /// <p>Object that describes the requested game session placement.</p>
    pub fn game_session_placement(
        &self,
    ) -> std::option::Option<&crate::model::GameSessionPlacement> {
        self.game_session_placement.as_ref()
    }
}
impl std::fmt::Debug for DescribeGameSessionPlacementOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGameSessionPlacementOutput");
        formatter.field("game_session_placement", &self.game_session_placement);
        formatter.finish()
    }
}
/// See [`DescribeGameSessionPlacementOutput`](crate::output::DescribeGameSessionPlacementOutput)
pub mod describe_game_session_placement_output {
    /// A builder for [`DescribeGameSessionPlacementOutput`](crate::output::DescribeGameSessionPlacementOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_session_placement: std::option::Option<crate::model::GameSessionPlacement>,
    }
    impl Builder {
        /// <p>Object that describes the requested game session placement.</p>
        pub fn game_session_placement(mut self, input: crate::model::GameSessionPlacement) -> Self {
            self.game_session_placement = Some(input);
            self
        }
        /// <p>Object that describes the requested game session placement.</p>
        pub fn set_game_session_placement(
            mut self,
            input: std::option::Option<crate::model::GameSessionPlacement>,
        ) -> Self {
            self.game_session_placement = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGameSessionPlacementOutput`](crate::output::DescribeGameSessionPlacementOutput)
        pub fn build(self) -> crate::output::DescribeGameSessionPlacementOutput {
            crate::output::DescribeGameSessionPlacementOutput {
                game_session_placement: self.game_session_placement,
            }
        }
    }
}
impl DescribeGameSessionPlacementOutput {
    /// Creates a new builder-style object to manufacture [`DescribeGameSessionPlacementOutput`](crate::output::DescribeGameSessionPlacementOutput)
    pub fn builder() -> crate::output::describe_game_session_placement_output::Builder {
        crate::output::describe_game_session_placement_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGameSessionDetailsOutput {
    /// <p>A collection of properties for each game session that matches the request.</p>
    pub game_session_details: std::option::Option<std::vec::Vec<crate::model::GameSessionDetail>>,
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeGameSessionDetailsOutput {
    /// <p>A collection of properties for each game session that matches the request.</p>
    pub fn game_session_details(&self) -> std::option::Option<&[crate::model::GameSessionDetail]> {
        self.game_session_details.as_deref()
    }
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeGameSessionDetailsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGameSessionDetailsOutput");
        formatter.field("game_session_details", &self.game_session_details);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeGameSessionDetailsOutput`](crate::output::DescribeGameSessionDetailsOutput)
pub mod describe_game_session_details_output {
    /// A builder for [`DescribeGameSessionDetailsOutput`](crate::output::DescribeGameSessionDetailsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_session_details:
            std::option::Option<std::vec::Vec<crate::model::GameSessionDetail>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `game_session_details`.
        ///
        /// To override the contents of this collection use [`set_game_session_details`](Self::set_game_session_details).
        ///
        /// <p>A collection of properties for each game session that matches the request.</p>
        pub fn game_session_details(mut self, input: crate::model::GameSessionDetail) -> Self {
            let mut v = self.game_session_details.unwrap_or_default();
            v.push(input);
            self.game_session_details = Some(v);
            self
        }
        /// <p>A collection of properties for each game session that matches the request.</p>
        pub fn set_game_session_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GameSessionDetail>>,
        ) -> Self {
            self.game_session_details = input;
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGameSessionDetailsOutput`](crate::output::DescribeGameSessionDetailsOutput)
        pub fn build(self) -> crate::output::DescribeGameSessionDetailsOutput {
            crate::output::DescribeGameSessionDetailsOutput {
                game_session_details: self.game_session_details,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeGameSessionDetailsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeGameSessionDetailsOutput`](crate::output::DescribeGameSessionDetailsOutput)
    pub fn builder() -> crate::output::describe_game_session_details_output::Builder {
        crate::output::describe_game_session_details_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGameServerInstancesOutput {
    /// <p> The collection of requested game server instances. </p>
    pub game_server_instances: std::option::Option<std::vec::Vec<crate::model::GameServerInstance>>,
    /// <p> A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeGameServerInstancesOutput {
    /// <p> The collection of requested game server instances. </p>
    pub fn game_server_instances(
        &self,
    ) -> std::option::Option<&[crate::model::GameServerInstance]> {
        self.game_server_instances.as_deref()
    }
    /// <p> A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeGameServerInstancesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGameServerInstancesOutput");
        formatter.field("game_server_instances", &self.game_server_instances);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeGameServerInstancesOutput`](crate::output::DescribeGameServerInstancesOutput)
pub mod describe_game_server_instances_output {
    /// A builder for [`DescribeGameServerInstancesOutput`](crate::output::DescribeGameServerInstancesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_server_instances:
            std::option::Option<std::vec::Vec<crate::model::GameServerInstance>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `game_server_instances`.
        ///
        /// To override the contents of this collection use [`set_game_server_instances`](Self::set_game_server_instances).
        ///
        /// <p> The collection of requested game server instances. </p>
        pub fn game_server_instances(mut self, input: crate::model::GameServerInstance) -> Self {
            let mut v = self.game_server_instances.unwrap_or_default();
            v.push(input);
            self.game_server_instances = Some(v);
            self
        }
        /// <p> The collection of requested game server instances. </p>
        pub fn set_game_server_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GameServerInstance>>,
        ) -> Self {
            self.game_server_instances = input;
            self
        }
        /// <p> A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGameServerInstancesOutput`](crate::output::DescribeGameServerInstancesOutput)
        pub fn build(self) -> crate::output::DescribeGameServerInstancesOutput {
            crate::output::DescribeGameServerInstancesOutput {
                game_server_instances: self.game_server_instances,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeGameServerInstancesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeGameServerInstancesOutput`](crate::output::DescribeGameServerInstancesOutput)
    pub fn builder() -> crate::output::describe_game_server_instances_output::Builder {
        crate::output::describe_game_server_instances_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGameServerGroupOutput {
    /// <p>An object with the property settings for the requested game server group resource. </p>
    pub game_server_group: std::option::Option<crate::model::GameServerGroup>,
}
impl DescribeGameServerGroupOutput {
    /// <p>An object with the property settings for the requested game server group resource. </p>
    pub fn game_server_group(&self) -> std::option::Option<&crate::model::GameServerGroup> {
        self.game_server_group.as_ref()
    }
}
impl std::fmt::Debug for DescribeGameServerGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGameServerGroupOutput");
        formatter.field("game_server_group", &self.game_server_group);
        formatter.finish()
    }
}
/// See [`DescribeGameServerGroupOutput`](crate::output::DescribeGameServerGroupOutput)
pub mod describe_game_server_group_output {
    /// A builder for [`DescribeGameServerGroupOutput`](crate::output::DescribeGameServerGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_server_group: std::option::Option<crate::model::GameServerGroup>,
    }
    impl Builder {
        /// <p>An object with the property settings for the requested game server group resource. </p>
        pub fn game_server_group(mut self, input: crate::model::GameServerGroup) -> Self {
            self.game_server_group = Some(input);
            self
        }
        /// <p>An object with the property settings for the requested game server group resource. </p>
        pub fn set_game_server_group(
            mut self,
            input: std::option::Option<crate::model::GameServerGroup>,
        ) -> Self {
            self.game_server_group = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGameServerGroupOutput`](crate::output::DescribeGameServerGroupOutput)
        pub fn build(self) -> crate::output::DescribeGameServerGroupOutput {
            crate::output::DescribeGameServerGroupOutput {
                game_server_group: self.game_server_group,
            }
        }
    }
}
impl DescribeGameServerGroupOutput {
    /// Creates a new builder-style object to manufacture [`DescribeGameServerGroupOutput`](crate::output::DescribeGameServerGroupOutput)
    pub fn builder() -> crate::output::describe_game_server_group_output::Builder {
        crate::output::describe_game_server_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGameServerOutput {
    /// <p>Object that describes the requested game server.</p>
    pub game_server: std::option::Option<crate::model::GameServer>,
}
impl DescribeGameServerOutput {
    /// <p>Object that describes the requested game server.</p>
    pub fn game_server(&self) -> std::option::Option<&crate::model::GameServer> {
        self.game_server.as_ref()
    }
}
impl std::fmt::Debug for DescribeGameServerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGameServerOutput");
        formatter.field("game_server", &self.game_server);
        formatter.finish()
    }
}
/// See [`DescribeGameServerOutput`](crate::output::DescribeGameServerOutput)
pub mod describe_game_server_output {
    /// A builder for [`DescribeGameServerOutput`](crate::output::DescribeGameServerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_server: std::option::Option<crate::model::GameServer>,
    }
    impl Builder {
        /// <p>Object that describes the requested game server.</p>
        pub fn game_server(mut self, input: crate::model::GameServer) -> Self {
            self.game_server = Some(input);
            self
        }
        /// <p>Object that describes the requested game server.</p>
        pub fn set_game_server(
            mut self,
            input: std::option::Option<crate::model::GameServer>,
        ) -> Self {
            self.game_server = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGameServerOutput`](crate::output::DescribeGameServerOutput)
        pub fn build(self) -> crate::output::DescribeGameServerOutput {
            crate::output::DescribeGameServerOutput {
                game_server: self.game_server,
            }
        }
    }
}
impl DescribeGameServerOutput {
    /// Creates a new builder-style object to manufacture [`DescribeGameServerOutput`](crate::output::DescribeGameServerOutput)
    pub fn builder() -> crate::output::describe_game_server_output::Builder {
        crate::output::describe_game_server_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFleetUtilizationOutput {
    /// <p>A collection of objects containing utilization information for each requested fleet ID. Utilization objects are returned only for fleets that currently exist.</p>
    pub fleet_utilization: std::option::Option<std::vec::Vec<crate::model::FleetUtilization>>,
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeFleetUtilizationOutput {
    /// <p>A collection of objects containing utilization information for each requested fleet ID. Utilization objects are returned only for fleets that currently exist.</p>
    pub fn fleet_utilization(&self) -> std::option::Option<&[crate::model::FleetUtilization]> {
        self.fleet_utilization.as_deref()
    }
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeFleetUtilizationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFleetUtilizationOutput");
        formatter.field("fleet_utilization", &self.fleet_utilization);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeFleetUtilizationOutput`](crate::output::DescribeFleetUtilizationOutput)
pub mod describe_fleet_utilization_output {
    /// A builder for [`DescribeFleetUtilizationOutput`](crate::output::DescribeFleetUtilizationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_utilization:
            std::option::Option<std::vec::Vec<crate::model::FleetUtilization>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `fleet_utilization`.
        ///
        /// To override the contents of this collection use [`set_fleet_utilization`](Self::set_fleet_utilization).
        ///
        /// <p>A collection of objects containing utilization information for each requested fleet ID. Utilization objects are returned only for fleets that currently exist.</p>
        pub fn fleet_utilization(mut self, input: crate::model::FleetUtilization) -> Self {
            let mut v = self.fleet_utilization.unwrap_or_default();
            v.push(input);
            self.fleet_utilization = Some(v);
            self
        }
        /// <p>A collection of objects containing utilization information for each requested fleet ID. Utilization objects are returned only for fleets that currently exist.</p>
        pub fn set_fleet_utilization(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FleetUtilization>>,
        ) -> Self {
            self.fleet_utilization = input;
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFleetUtilizationOutput`](crate::output::DescribeFleetUtilizationOutput)
        pub fn build(self) -> crate::output::DescribeFleetUtilizationOutput {
            crate::output::DescribeFleetUtilizationOutput {
                fleet_utilization: self.fleet_utilization,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeFleetUtilizationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFleetUtilizationOutput`](crate::output::DescribeFleetUtilizationOutput)
    pub fn builder() -> crate::output::describe_fleet_utilization_output::Builder {
        crate::output::describe_fleet_utilization_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFleetPortSettingsOutput {
    /// <p>A unique identifier for the fleet that was requested. </p>
    pub fleet_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
    /// </region></code>.</p>
    pub fleet_arn: std::option::Option<std::string::String>,
    /// <p>The port settings for the requested fleet ID.</p>
    pub inbound_permissions: std::option::Option<std::vec::Vec<crate::model::IpPermission>>,
    /// <p>The current status of updates to the fleet's port settings in the requested fleet location. A status of <code>PENDING_UPDATE</code> indicates that an update was requested for the fleet but has not yet been completed for the location.</p>
    pub update_status: std::option::Option<crate::model::LocationUpdateStatus>,
    /// <p>The requested fleet location, expressed as an Amazon Web Services Region code, such as <code>us-west-2</code>. </p>
    pub location: std::option::Option<std::string::String>,
}
impl DescribeFleetPortSettingsOutput {
    /// <p>A unique identifier for the fleet that was requested. </p>
    pub fn fleet_id(&self) -> std::option::Option<&str> {
        self.fleet_id.as_deref()
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
    /// </region></code>.</p>
    pub fn fleet_arn(&self) -> std::option::Option<&str> {
        self.fleet_arn.as_deref()
    }
    /// <p>The port settings for the requested fleet ID.</p>
    pub fn inbound_permissions(&self) -> std::option::Option<&[crate::model::IpPermission]> {
        self.inbound_permissions.as_deref()
    }
    /// <p>The current status of updates to the fleet's port settings in the requested fleet location. A status of <code>PENDING_UPDATE</code> indicates that an update was requested for the fleet but has not yet been completed for the location.</p>
    pub fn update_status(&self) -> std::option::Option<&crate::model::LocationUpdateStatus> {
        self.update_status.as_ref()
    }
    /// <p>The requested fleet location, expressed as an Amazon Web Services Region code, such as <code>us-west-2</code>. </p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
}
impl std::fmt::Debug for DescribeFleetPortSettingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFleetPortSettingsOutput");
        formatter.field("fleet_id", &self.fleet_id);
        formatter.field("fleet_arn", &self.fleet_arn);
        formatter.field("inbound_permissions", &self.inbound_permissions);
        formatter.field("update_status", &self.update_status);
        formatter.field("location", &self.location);
        formatter.finish()
    }
}
/// See [`DescribeFleetPortSettingsOutput`](crate::output::DescribeFleetPortSettingsOutput)
pub mod describe_fleet_port_settings_output {
    /// A builder for [`DescribeFleetPortSettingsOutput`](crate::output::DescribeFleetPortSettingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) fleet_arn: std::option::Option<std::string::String>,
        pub(crate) inbound_permissions:
            std::option::Option<std::vec::Vec<crate::model::IpPermission>>,
        pub(crate) update_status: std::option::Option<crate::model::LocationUpdateStatus>,
        pub(crate) location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet that was requested. </p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet that was requested. </p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
        /// </region></code>.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
        /// </region></code>.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_arn = input;
            self
        }
        /// Appends an item to `inbound_permissions`.
        ///
        /// To override the contents of this collection use [`set_inbound_permissions`](Self::set_inbound_permissions).
        ///
        /// <p>The port settings for the requested fleet ID.</p>
        pub fn inbound_permissions(mut self, input: crate::model::IpPermission) -> Self {
            let mut v = self.inbound_permissions.unwrap_or_default();
            v.push(input);
            self.inbound_permissions = Some(v);
            self
        }
        /// <p>The port settings for the requested fleet ID.</p>
        pub fn set_inbound_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpPermission>>,
        ) -> Self {
            self.inbound_permissions = input;
            self
        }
        /// <p>The current status of updates to the fleet's port settings in the requested fleet location. A status of <code>PENDING_UPDATE</code> indicates that an update was requested for the fleet but has not yet been completed for the location.</p>
        pub fn update_status(mut self, input: crate::model::LocationUpdateStatus) -> Self {
            self.update_status = Some(input);
            self
        }
        /// <p>The current status of updates to the fleet's port settings in the requested fleet location. A status of <code>PENDING_UPDATE</code> indicates that an update was requested for the fleet but has not yet been completed for the location.</p>
        pub fn set_update_status(
            mut self,
            input: std::option::Option<crate::model::LocationUpdateStatus>,
        ) -> Self {
            self.update_status = input;
            self
        }
        /// <p>The requested fleet location, expressed as an Amazon Web Services Region code, such as <code>us-west-2</code>. </p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The requested fleet location, expressed as an Amazon Web Services Region code, such as <code>us-west-2</code>. </p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFleetPortSettingsOutput`](crate::output::DescribeFleetPortSettingsOutput)
        pub fn build(self) -> crate::output::DescribeFleetPortSettingsOutput {
            crate::output::DescribeFleetPortSettingsOutput {
                fleet_id: self.fleet_id,
                fleet_arn: self.fleet_arn,
                inbound_permissions: self.inbound_permissions,
                update_status: self.update_status,
                location: self.location,
            }
        }
    }
}
impl DescribeFleetPortSettingsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFleetPortSettingsOutput`](crate::output::DescribeFleetPortSettingsOutput)
    pub fn builder() -> crate::output::describe_fleet_port_settings_output::Builder {
        crate::output::describe_fleet_port_settings_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFleetLocationUtilizationOutput {
    /// <p>Utilization information for the requested fleet location. Utilization objects are returned only for fleets and locations that currently exist.</p>
    pub fleet_utilization: std::option::Option<crate::model::FleetUtilization>,
}
impl DescribeFleetLocationUtilizationOutput {
    /// <p>Utilization information for the requested fleet location. Utilization objects are returned only for fleets and locations that currently exist.</p>
    pub fn fleet_utilization(&self) -> std::option::Option<&crate::model::FleetUtilization> {
        self.fleet_utilization.as_ref()
    }
}
impl std::fmt::Debug for DescribeFleetLocationUtilizationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFleetLocationUtilizationOutput");
        formatter.field("fleet_utilization", &self.fleet_utilization);
        formatter.finish()
    }
}
/// See [`DescribeFleetLocationUtilizationOutput`](crate::output::DescribeFleetLocationUtilizationOutput)
pub mod describe_fleet_location_utilization_output {
    /// A builder for [`DescribeFleetLocationUtilizationOutput`](crate::output::DescribeFleetLocationUtilizationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_utilization: std::option::Option<crate::model::FleetUtilization>,
    }
    impl Builder {
        /// <p>Utilization information for the requested fleet location. Utilization objects are returned only for fleets and locations that currently exist.</p>
        pub fn fleet_utilization(mut self, input: crate::model::FleetUtilization) -> Self {
            self.fleet_utilization = Some(input);
            self
        }
        /// <p>Utilization information for the requested fleet location. Utilization objects are returned only for fleets and locations that currently exist.</p>
        pub fn set_fleet_utilization(
            mut self,
            input: std::option::Option<crate::model::FleetUtilization>,
        ) -> Self {
            self.fleet_utilization = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFleetLocationUtilizationOutput`](crate::output::DescribeFleetLocationUtilizationOutput)
        pub fn build(self) -> crate::output::DescribeFleetLocationUtilizationOutput {
            crate::output::DescribeFleetLocationUtilizationOutput {
                fleet_utilization: self.fleet_utilization,
            }
        }
    }
}
impl DescribeFleetLocationUtilizationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFleetLocationUtilizationOutput`](crate::output::DescribeFleetLocationUtilizationOutput)
    pub fn builder() -> crate::output::describe_fleet_location_utilization_output::Builder {
        crate::output::describe_fleet_location_utilization_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFleetLocationCapacityOutput {
    /// <p>Resource capacity information for the requested fleet location. Capacity objects are returned only for fleets and locations that currently exist.</p>
    pub fleet_capacity: std::option::Option<crate::model::FleetCapacity>,
}
impl DescribeFleetLocationCapacityOutput {
    /// <p>Resource capacity information for the requested fleet location. Capacity objects are returned only for fleets and locations that currently exist.</p>
    pub fn fleet_capacity(&self) -> std::option::Option<&crate::model::FleetCapacity> {
        self.fleet_capacity.as_ref()
    }
}
impl std::fmt::Debug for DescribeFleetLocationCapacityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFleetLocationCapacityOutput");
        formatter.field("fleet_capacity", &self.fleet_capacity);
        formatter.finish()
    }
}
/// See [`DescribeFleetLocationCapacityOutput`](crate::output::DescribeFleetLocationCapacityOutput)
pub mod describe_fleet_location_capacity_output {
    /// A builder for [`DescribeFleetLocationCapacityOutput`](crate::output::DescribeFleetLocationCapacityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_capacity: std::option::Option<crate::model::FleetCapacity>,
    }
    impl Builder {
        /// <p>Resource capacity information for the requested fleet location. Capacity objects are returned only for fleets and locations that currently exist.</p>
        pub fn fleet_capacity(mut self, input: crate::model::FleetCapacity) -> Self {
            self.fleet_capacity = Some(input);
            self
        }
        /// <p>Resource capacity information for the requested fleet location. Capacity objects are returned only for fleets and locations that currently exist.</p>
        pub fn set_fleet_capacity(
            mut self,
            input: std::option::Option<crate::model::FleetCapacity>,
        ) -> Self {
            self.fleet_capacity = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFleetLocationCapacityOutput`](crate::output::DescribeFleetLocationCapacityOutput)
        pub fn build(self) -> crate::output::DescribeFleetLocationCapacityOutput {
            crate::output::DescribeFleetLocationCapacityOutput {
                fleet_capacity: self.fleet_capacity,
            }
        }
    }
}
impl DescribeFleetLocationCapacityOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFleetLocationCapacityOutput`](crate::output::DescribeFleetLocationCapacityOutput)
    pub fn builder() -> crate::output::describe_fleet_location_capacity_output::Builder {
        crate::output::describe_fleet_location_capacity_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFleetLocationAttributesOutput {
    /// <p>A unique identifier for the fleet that location attributes were requested for.</p>
    pub fleet_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
    /// </region></code>. </p>
    pub fleet_arn: std::option::Option<std::string::String>,
    /// <p> Location-specific information on the requested fleet's remote locations. </p>
    pub location_attributes: std::option::Option<std::vec::Vec<crate::model::LocationAttributes>>,
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeFleetLocationAttributesOutput {
    /// <p>A unique identifier for the fleet that location attributes were requested for.</p>
    pub fn fleet_id(&self) -> std::option::Option<&str> {
        self.fleet_id.as_deref()
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
    /// </region></code>. </p>
    pub fn fleet_arn(&self) -> std::option::Option<&str> {
        self.fleet_arn.as_deref()
    }
    /// <p> Location-specific information on the requested fleet's remote locations. </p>
    pub fn location_attributes(&self) -> std::option::Option<&[crate::model::LocationAttributes]> {
        self.location_attributes.as_deref()
    }
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeFleetLocationAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFleetLocationAttributesOutput");
        formatter.field("fleet_id", &self.fleet_id);
        formatter.field("fleet_arn", &self.fleet_arn);
        formatter.field("location_attributes", &self.location_attributes);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeFleetLocationAttributesOutput`](crate::output::DescribeFleetLocationAttributesOutput)
pub mod describe_fleet_location_attributes_output {
    /// A builder for [`DescribeFleetLocationAttributesOutput`](crate::output::DescribeFleetLocationAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) fleet_arn: std::option::Option<std::string::String>,
        pub(crate) location_attributes:
            std::option::Option<std::vec::Vec<crate::model::LocationAttributes>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet that location attributes were requested for.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet that location attributes were requested for.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
        /// </region></code>. </p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
        /// </region></code>. </p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_arn = input;
            self
        }
        /// Appends an item to `location_attributes`.
        ///
        /// To override the contents of this collection use [`set_location_attributes`](Self::set_location_attributes).
        ///
        /// <p> Location-specific information on the requested fleet's remote locations. </p>
        pub fn location_attributes(mut self, input: crate::model::LocationAttributes) -> Self {
            let mut v = self.location_attributes.unwrap_or_default();
            v.push(input);
            self.location_attributes = Some(v);
            self
        }
        /// <p> Location-specific information on the requested fleet's remote locations. </p>
        pub fn set_location_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LocationAttributes>>,
        ) -> Self {
            self.location_attributes = input;
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFleetLocationAttributesOutput`](crate::output::DescribeFleetLocationAttributesOutput)
        pub fn build(self) -> crate::output::DescribeFleetLocationAttributesOutput {
            crate::output::DescribeFleetLocationAttributesOutput {
                fleet_id: self.fleet_id,
                fleet_arn: self.fleet_arn,
                location_attributes: self.location_attributes,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeFleetLocationAttributesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFleetLocationAttributesOutput`](crate::output::DescribeFleetLocationAttributesOutput)
    pub fn builder() -> crate::output::describe_fleet_location_attributes_output::Builder {
        crate::output::describe_fleet_location_attributes_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFleetEventsOutput {
    /// <p>A collection of objects containing event log entries for the specified fleet.</p>
    pub events: std::option::Option<std::vec::Vec<crate::model::Event>>,
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeFleetEventsOutput {
    /// <p>A collection of objects containing event log entries for the specified fleet.</p>
    pub fn events(&self) -> std::option::Option<&[crate::model::Event]> {
        self.events.as_deref()
    }
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeFleetEventsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFleetEventsOutput");
        formatter.field("events", &self.events);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeFleetEventsOutput`](crate::output::DescribeFleetEventsOutput)
pub mod describe_fleet_events_output {
    /// A builder for [`DescribeFleetEventsOutput`](crate::output::DescribeFleetEventsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) events: std::option::Option<std::vec::Vec<crate::model::Event>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>A collection of objects containing event log entries for the specified fleet.</p>
        pub fn events(mut self, input: crate::model::Event) -> Self {
            let mut v = self.events.unwrap_or_default();
            v.push(input);
            self.events = Some(v);
            self
        }
        /// <p>A collection of objects containing event log entries for the specified fleet.</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Event>>,
        ) -> Self {
            self.events = input;
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFleetEventsOutput`](crate::output::DescribeFleetEventsOutput)
        pub fn build(self) -> crate::output::DescribeFleetEventsOutput {
            crate::output::DescribeFleetEventsOutput {
                events: self.events,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeFleetEventsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFleetEventsOutput`](crate::output::DescribeFleetEventsOutput)
    pub fn builder() -> crate::output::describe_fleet_events_output::Builder {
        crate::output::describe_fleet_events_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFleetCapacityOutput {
    /// <p>A collection of objects that contains capacity information for each requested fleet ID. Capacity objects are returned only for fleets that currently exist.</p>
    pub fleet_capacity: std::option::Option<std::vec::Vec<crate::model::FleetCapacity>>,
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeFleetCapacityOutput {
    /// <p>A collection of objects that contains capacity information for each requested fleet ID. Capacity objects are returned only for fleets that currently exist.</p>
    pub fn fleet_capacity(&self) -> std::option::Option<&[crate::model::FleetCapacity]> {
        self.fleet_capacity.as_deref()
    }
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeFleetCapacityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFleetCapacityOutput");
        formatter.field("fleet_capacity", &self.fleet_capacity);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeFleetCapacityOutput`](crate::output::DescribeFleetCapacityOutput)
pub mod describe_fleet_capacity_output {
    /// A builder for [`DescribeFleetCapacityOutput`](crate::output::DescribeFleetCapacityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_capacity: std::option::Option<std::vec::Vec<crate::model::FleetCapacity>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `fleet_capacity`.
        ///
        /// To override the contents of this collection use [`set_fleet_capacity`](Self::set_fleet_capacity).
        ///
        /// <p>A collection of objects that contains capacity information for each requested fleet ID. Capacity objects are returned only for fleets that currently exist.</p>
        pub fn fleet_capacity(mut self, input: crate::model::FleetCapacity) -> Self {
            let mut v = self.fleet_capacity.unwrap_or_default();
            v.push(input);
            self.fleet_capacity = Some(v);
            self
        }
        /// <p>A collection of objects that contains capacity information for each requested fleet ID. Capacity objects are returned only for fleets that currently exist.</p>
        pub fn set_fleet_capacity(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FleetCapacity>>,
        ) -> Self {
            self.fleet_capacity = input;
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFleetCapacityOutput`](crate::output::DescribeFleetCapacityOutput)
        pub fn build(self) -> crate::output::DescribeFleetCapacityOutput {
            crate::output::DescribeFleetCapacityOutput {
                fleet_capacity: self.fleet_capacity,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeFleetCapacityOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFleetCapacityOutput`](crate::output::DescribeFleetCapacityOutput)
    pub fn builder() -> crate::output::describe_fleet_capacity_output::Builder {
        crate::output::describe_fleet_capacity_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFleetAttributesOutput {
    /// <p>A collection of objects containing attribute metadata for each requested fleet ID. Attribute objects are returned only for fleets that currently exist.</p>
    pub fleet_attributes: std::option::Option<std::vec::Vec<crate::model::FleetAttributes>>,
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeFleetAttributesOutput {
    /// <p>A collection of objects containing attribute metadata for each requested fleet ID. Attribute objects are returned only for fleets that currently exist.</p>
    pub fn fleet_attributes(&self) -> std::option::Option<&[crate::model::FleetAttributes]> {
        self.fleet_attributes.as_deref()
    }
    /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeFleetAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFleetAttributesOutput");
        formatter.field("fleet_attributes", &self.fleet_attributes);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeFleetAttributesOutput`](crate::output::DescribeFleetAttributesOutput)
pub mod describe_fleet_attributes_output {
    /// A builder for [`DescribeFleetAttributesOutput`](crate::output::DescribeFleetAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_attributes:
            std::option::Option<std::vec::Vec<crate::model::FleetAttributes>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `fleet_attributes`.
        ///
        /// To override the contents of this collection use [`set_fleet_attributes`](Self::set_fleet_attributes).
        ///
        /// <p>A collection of objects containing attribute metadata for each requested fleet ID. Attribute objects are returned only for fleets that currently exist.</p>
        pub fn fleet_attributes(mut self, input: crate::model::FleetAttributes) -> Self {
            let mut v = self.fleet_attributes.unwrap_or_default();
            v.push(input);
            self.fleet_attributes = Some(v);
            self
        }
        /// <p>A collection of objects containing attribute metadata for each requested fleet ID. Attribute objects are returned only for fleets that currently exist.</p>
        pub fn set_fleet_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FleetAttributes>>,
        ) -> Self {
            self.fleet_attributes = input;
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFleetAttributesOutput`](crate::output::DescribeFleetAttributesOutput)
        pub fn build(self) -> crate::output::DescribeFleetAttributesOutput {
            crate::output::DescribeFleetAttributesOutput {
                fleet_attributes: self.fleet_attributes,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeFleetAttributesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFleetAttributesOutput`](crate::output::DescribeFleetAttributesOutput)
    pub fn builder() -> crate::output::describe_fleet_attributes_output::Builder {
        crate::output::describe_fleet_attributes_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEc2InstanceLimitsOutput {
    /// <p>The maximum number of instances for the specified instance type.</p>
    pub ec2_instance_limits: std::option::Option<std::vec::Vec<crate::model::Ec2InstanceLimit>>,
}
impl DescribeEc2InstanceLimitsOutput {
    /// <p>The maximum number of instances for the specified instance type.</p>
    pub fn ec2_instance_limits(&self) -> std::option::Option<&[crate::model::Ec2InstanceLimit]> {
        self.ec2_instance_limits.as_deref()
    }
}
impl std::fmt::Debug for DescribeEc2InstanceLimitsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEc2InstanceLimitsOutput");
        formatter.field("ec2_instance_limits", &self.ec2_instance_limits);
        formatter.finish()
    }
}
/// See [`DescribeEc2InstanceLimitsOutput`](crate::output::DescribeEc2InstanceLimitsOutput)
pub mod describe_ec2_instance_limits_output {
    /// A builder for [`DescribeEc2InstanceLimitsOutput`](crate::output::DescribeEc2InstanceLimitsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ec2_instance_limits:
            std::option::Option<std::vec::Vec<crate::model::Ec2InstanceLimit>>,
    }
    impl Builder {
        /// Appends an item to `ec2_instance_limits`.
        ///
        /// To override the contents of this collection use [`set_ec2_instance_limits`](Self::set_ec2_instance_limits).
        ///
        /// <p>The maximum number of instances for the specified instance type.</p>
        pub fn ec2_instance_limits(mut self, input: crate::model::Ec2InstanceLimit) -> Self {
            let mut v = self.ec2_instance_limits.unwrap_or_default();
            v.push(input);
            self.ec2_instance_limits = Some(v);
            self
        }
        /// <p>The maximum number of instances for the specified instance type.</p>
        pub fn set_ec2_instance_limits(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Ec2InstanceLimit>>,
        ) -> Self {
            self.ec2_instance_limits = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEc2InstanceLimitsOutput`](crate::output::DescribeEc2InstanceLimitsOutput)
        pub fn build(self) -> crate::output::DescribeEc2InstanceLimitsOutput {
            crate::output::DescribeEc2InstanceLimitsOutput {
                ec2_instance_limits: self.ec2_instance_limits,
            }
        }
    }
}
impl DescribeEc2InstanceLimitsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEc2InstanceLimitsOutput`](crate::output::DescribeEc2InstanceLimitsOutput)
    pub fn builder() -> crate::output::describe_ec2_instance_limits_output::Builder {
        crate::output::describe_ec2_instance_limits_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBuildOutput {
    /// <p>Set of properties describing the requested build.</p>
    ///
    /// _Note: This member has been renamed from `build`._
    pub build_value: std::option::Option<crate::model::Build>,
}
impl DescribeBuildOutput {
    /// <p>Set of properties describing the requested build.</p>
    ///
    /// _Note: This member has been renamed from `build`._
    pub fn build_value(&self) -> std::option::Option<&crate::model::Build> {
        self.build_value.as_ref()
    }
}
impl std::fmt::Debug for DescribeBuildOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBuildOutput");
        formatter.field("build_value", &self.build_value);
        formatter.finish()
    }
}
/// See [`DescribeBuildOutput`](crate::output::DescribeBuildOutput)
pub mod describe_build_output {
    /// A builder for [`DescribeBuildOutput`](crate::output::DescribeBuildOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) build_value: std::option::Option<crate::model::Build>,
    }
    impl Builder {
        /// <p>Set of properties describing the requested build.</p>
        pub fn build_value(mut self, input: crate::model::Build) -> Self {
            self.build_value = Some(input);
            self
        }
        /// <p>Set of properties describing the requested build.</p>
        pub fn set_build(mut self, input: std::option::Option<crate::model::Build>) -> Self {
            self.build_value = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBuildOutput`](crate::output::DescribeBuildOutput)
        pub fn build(self) -> crate::output::DescribeBuildOutput {
            crate::output::DescribeBuildOutput {
                build_value: self.build_value,
            }
        }
    }
}
impl DescribeBuildOutput {
    /// Creates a new builder-style object to manufacture [`DescribeBuildOutput`](crate::output::DescribeBuildOutput)
    pub fn builder() -> crate::output::describe_build_output::Builder {
        crate::output::describe_build_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAliasOutput {
    /// <p>The requested alias resource.</p>
    pub alias: std::option::Option<crate::model::Alias>,
}
impl DescribeAliasOutput {
    /// <p>The requested alias resource.</p>
    pub fn alias(&self) -> std::option::Option<&crate::model::Alias> {
        self.alias.as_ref()
    }
}
impl std::fmt::Debug for DescribeAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAliasOutput");
        formatter.field("alias", &self.alias);
        formatter.finish()
    }
}
/// See [`DescribeAliasOutput`](crate::output::DescribeAliasOutput)
pub mod describe_alias_output {
    /// A builder for [`DescribeAliasOutput`](crate::output::DescribeAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alias: std::option::Option<crate::model::Alias>,
    }
    impl Builder {
        /// <p>The requested alias resource.</p>
        pub fn alias(mut self, input: crate::model::Alias) -> Self {
            self.alias = Some(input);
            self
        }
        /// <p>The requested alias resource.</p>
        pub fn set_alias(mut self, input: std::option::Option<crate::model::Alias>) -> Self {
            self.alias = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAliasOutput`](crate::output::DescribeAliasOutput)
        pub fn build(self) -> crate::output::DescribeAliasOutput {
            crate::output::DescribeAliasOutput { alias: self.alias }
        }
    }
}
impl DescribeAliasOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAliasOutput`](crate::output::DescribeAliasOutput)
    pub fn builder() -> crate::output::describe_alias_output::Builder {
        crate::output::describe_alias_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterGameServerOutput {}
impl std::fmt::Debug for DeregisterGameServerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterGameServerOutput");
        formatter.finish()
    }
}
/// See [`DeregisterGameServerOutput`](crate::output::DeregisterGameServerOutput)
pub mod deregister_game_server_output {
    /// A builder for [`DeregisterGameServerOutput`](crate::output::DeregisterGameServerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeregisterGameServerOutput`](crate::output::DeregisterGameServerOutput)
        pub fn build(self) -> crate::output::DeregisterGameServerOutput {
            crate::output::DeregisterGameServerOutput {}
        }
    }
}
impl DeregisterGameServerOutput {
    /// Creates a new builder-style object to manufacture [`DeregisterGameServerOutput`](crate::output::DeregisterGameServerOutput)
    pub fn builder() -> crate::output::deregister_game_server_output::Builder {
        crate::output::deregister_game_server_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVpcPeeringConnectionOutput {}
impl std::fmt::Debug for DeleteVpcPeeringConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVpcPeeringConnectionOutput");
        formatter.finish()
    }
}
/// See [`DeleteVpcPeeringConnectionOutput`](crate::output::DeleteVpcPeeringConnectionOutput)
pub mod delete_vpc_peering_connection_output {
    /// A builder for [`DeleteVpcPeeringConnectionOutput`](crate::output::DeleteVpcPeeringConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteVpcPeeringConnectionOutput`](crate::output::DeleteVpcPeeringConnectionOutput)
        pub fn build(self) -> crate::output::DeleteVpcPeeringConnectionOutput {
            crate::output::DeleteVpcPeeringConnectionOutput {}
        }
    }
}
impl DeleteVpcPeeringConnectionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteVpcPeeringConnectionOutput`](crate::output::DeleteVpcPeeringConnectionOutput)
    pub fn builder() -> crate::output::delete_vpc_peering_connection_output::Builder {
        crate::output::delete_vpc_peering_connection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVpcPeeringAuthorizationOutput {}
impl std::fmt::Debug for DeleteVpcPeeringAuthorizationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVpcPeeringAuthorizationOutput");
        formatter.finish()
    }
}
/// See [`DeleteVpcPeeringAuthorizationOutput`](crate::output::DeleteVpcPeeringAuthorizationOutput)
pub mod delete_vpc_peering_authorization_output {
    /// A builder for [`DeleteVpcPeeringAuthorizationOutput`](crate::output::DeleteVpcPeeringAuthorizationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteVpcPeeringAuthorizationOutput`](crate::output::DeleteVpcPeeringAuthorizationOutput)
        pub fn build(self) -> crate::output::DeleteVpcPeeringAuthorizationOutput {
            crate::output::DeleteVpcPeeringAuthorizationOutput {}
        }
    }
}
impl DeleteVpcPeeringAuthorizationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteVpcPeeringAuthorizationOutput`](crate::output::DeleteVpcPeeringAuthorizationOutput)
    pub fn builder() -> crate::output::delete_vpc_peering_authorization_output::Builder {
        crate::output::delete_vpc_peering_authorization_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteScriptOutput {}
impl std::fmt::Debug for DeleteScriptOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteScriptOutput");
        formatter.finish()
    }
}
/// See [`DeleteScriptOutput`](crate::output::DeleteScriptOutput)
pub mod delete_script_output {
    /// A builder for [`DeleteScriptOutput`](crate::output::DeleteScriptOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteScriptOutput`](crate::output::DeleteScriptOutput)
        pub fn build(self) -> crate::output::DeleteScriptOutput {
            crate::output::DeleteScriptOutput {}
        }
    }
}
impl DeleteScriptOutput {
    /// Creates a new builder-style object to manufacture [`DeleteScriptOutput`](crate::output::DeleteScriptOutput)
    pub fn builder() -> crate::output::delete_script_output::Builder {
        crate::output::delete_script_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteScalingPolicyOutput {}
impl std::fmt::Debug for DeleteScalingPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteScalingPolicyOutput");
        formatter.finish()
    }
}
/// See [`DeleteScalingPolicyOutput`](crate::output::DeleteScalingPolicyOutput)
pub mod delete_scaling_policy_output {
    /// A builder for [`DeleteScalingPolicyOutput`](crate::output::DeleteScalingPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteScalingPolicyOutput`](crate::output::DeleteScalingPolicyOutput)
        pub fn build(self) -> crate::output::DeleteScalingPolicyOutput {
            crate::output::DeleteScalingPolicyOutput {}
        }
    }
}
impl DeleteScalingPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteScalingPolicyOutput`](crate::output::DeleteScalingPolicyOutput)
    pub fn builder() -> crate::output::delete_scaling_policy_output::Builder {
        crate::output::delete_scaling_policy_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMatchmakingRuleSetOutput {}
impl std::fmt::Debug for DeleteMatchmakingRuleSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMatchmakingRuleSetOutput");
        formatter.finish()
    }
}
/// See [`DeleteMatchmakingRuleSetOutput`](crate::output::DeleteMatchmakingRuleSetOutput)
pub mod delete_matchmaking_rule_set_output {
    /// A builder for [`DeleteMatchmakingRuleSetOutput`](crate::output::DeleteMatchmakingRuleSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteMatchmakingRuleSetOutput`](crate::output::DeleteMatchmakingRuleSetOutput)
        pub fn build(self) -> crate::output::DeleteMatchmakingRuleSetOutput {
            crate::output::DeleteMatchmakingRuleSetOutput {}
        }
    }
}
impl DeleteMatchmakingRuleSetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteMatchmakingRuleSetOutput`](crate::output::DeleteMatchmakingRuleSetOutput)
    pub fn builder() -> crate::output::delete_matchmaking_rule_set_output::Builder {
        crate::output::delete_matchmaking_rule_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMatchmakingConfigurationOutput {}
impl std::fmt::Debug for DeleteMatchmakingConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMatchmakingConfigurationOutput");
        formatter.finish()
    }
}
/// See [`DeleteMatchmakingConfigurationOutput`](crate::output::DeleteMatchmakingConfigurationOutput)
pub mod delete_matchmaking_configuration_output {
    /// A builder for [`DeleteMatchmakingConfigurationOutput`](crate::output::DeleteMatchmakingConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteMatchmakingConfigurationOutput`](crate::output::DeleteMatchmakingConfigurationOutput)
        pub fn build(self) -> crate::output::DeleteMatchmakingConfigurationOutput {
            crate::output::DeleteMatchmakingConfigurationOutput {}
        }
    }
}
impl DeleteMatchmakingConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteMatchmakingConfigurationOutput`](crate::output::DeleteMatchmakingConfigurationOutput)
    pub fn builder() -> crate::output::delete_matchmaking_configuration_output::Builder {
        crate::output::delete_matchmaking_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGameSessionQueueOutput {}
impl std::fmt::Debug for DeleteGameSessionQueueOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGameSessionQueueOutput");
        formatter.finish()
    }
}
/// See [`DeleteGameSessionQueueOutput`](crate::output::DeleteGameSessionQueueOutput)
pub mod delete_game_session_queue_output {
    /// A builder for [`DeleteGameSessionQueueOutput`](crate::output::DeleteGameSessionQueueOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteGameSessionQueueOutput`](crate::output::DeleteGameSessionQueueOutput)
        pub fn build(self) -> crate::output::DeleteGameSessionQueueOutput {
            crate::output::DeleteGameSessionQueueOutput {}
        }
    }
}
impl DeleteGameSessionQueueOutput {
    /// Creates a new builder-style object to manufacture [`DeleteGameSessionQueueOutput`](crate::output::DeleteGameSessionQueueOutput)
    pub fn builder() -> crate::output::delete_game_session_queue_output::Builder {
        crate::output::delete_game_session_queue_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGameServerGroupOutput {
    /// <p>An object that describes the deleted game server group resource, with status updated to <code>DELETE_SCHEDULED</code>. </p>
    pub game_server_group: std::option::Option<crate::model::GameServerGroup>,
}
impl DeleteGameServerGroupOutput {
    /// <p>An object that describes the deleted game server group resource, with status updated to <code>DELETE_SCHEDULED</code>. </p>
    pub fn game_server_group(&self) -> std::option::Option<&crate::model::GameServerGroup> {
        self.game_server_group.as_ref()
    }
}
impl std::fmt::Debug for DeleteGameServerGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGameServerGroupOutput");
        formatter.field("game_server_group", &self.game_server_group);
        formatter.finish()
    }
}
/// See [`DeleteGameServerGroupOutput`](crate::output::DeleteGameServerGroupOutput)
pub mod delete_game_server_group_output {
    /// A builder for [`DeleteGameServerGroupOutput`](crate::output::DeleteGameServerGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_server_group: std::option::Option<crate::model::GameServerGroup>,
    }
    impl Builder {
        /// <p>An object that describes the deleted game server group resource, with status updated to <code>DELETE_SCHEDULED</code>. </p>
        pub fn game_server_group(mut self, input: crate::model::GameServerGroup) -> Self {
            self.game_server_group = Some(input);
            self
        }
        /// <p>An object that describes the deleted game server group resource, with status updated to <code>DELETE_SCHEDULED</code>. </p>
        pub fn set_game_server_group(
            mut self,
            input: std::option::Option<crate::model::GameServerGroup>,
        ) -> Self {
            self.game_server_group = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGameServerGroupOutput`](crate::output::DeleteGameServerGroupOutput)
        pub fn build(self) -> crate::output::DeleteGameServerGroupOutput {
            crate::output::DeleteGameServerGroupOutput {
                game_server_group: self.game_server_group,
            }
        }
    }
}
impl DeleteGameServerGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteGameServerGroupOutput`](crate::output::DeleteGameServerGroupOutput)
    pub fn builder() -> crate::output::delete_game_server_group_output::Builder {
        crate::output::delete_game_server_group_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFleetLocationsOutput {
    /// <p>A unique identifier for the fleet that location attributes are being deleted for.</p>
    pub fleet_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
    /// </region></code>.</p>
    pub fleet_arn: std::option::Option<std::string::String>,
    /// <p>The remote locations that are being deleted, with each location status set to <code>DELETING</code>.</p>
    pub location_states: std::option::Option<std::vec::Vec<crate::model::LocationState>>,
}
impl DeleteFleetLocationsOutput {
    /// <p>A unique identifier for the fleet that location attributes are being deleted for.</p>
    pub fn fleet_id(&self) -> std::option::Option<&str> {
        self.fleet_id.as_deref()
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
    /// </region></code>.</p>
    pub fn fleet_arn(&self) -> std::option::Option<&str> {
        self.fleet_arn.as_deref()
    }
    /// <p>The remote locations that are being deleted, with each location status set to <code>DELETING</code>.</p>
    pub fn location_states(&self) -> std::option::Option<&[crate::model::LocationState]> {
        self.location_states.as_deref()
    }
}
impl std::fmt::Debug for DeleteFleetLocationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFleetLocationsOutput");
        formatter.field("fleet_id", &self.fleet_id);
        formatter.field("fleet_arn", &self.fleet_arn);
        formatter.field("location_states", &self.location_states);
        formatter.finish()
    }
}
/// See [`DeleteFleetLocationsOutput`](crate::output::DeleteFleetLocationsOutput)
pub mod delete_fleet_locations_output {
    /// A builder for [`DeleteFleetLocationsOutput`](crate::output::DeleteFleetLocationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) fleet_arn: std::option::Option<std::string::String>,
        pub(crate) location_states: std::option::Option<std::vec::Vec<crate::model::LocationState>>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet that location attributes are being deleted for.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet that location attributes are being deleted for.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
        /// </region></code>.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
        /// </region></code>.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_arn = input;
            self
        }
        /// Appends an item to `location_states`.
        ///
        /// To override the contents of this collection use [`set_location_states`](Self::set_location_states).
        ///
        /// <p>The remote locations that are being deleted, with each location status set to <code>DELETING</code>.</p>
        pub fn location_states(mut self, input: crate::model::LocationState) -> Self {
            let mut v = self.location_states.unwrap_or_default();
            v.push(input);
            self.location_states = Some(v);
            self
        }
        /// <p>The remote locations that are being deleted, with each location status set to <code>DELETING</code>.</p>
        pub fn set_location_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LocationState>>,
        ) -> Self {
            self.location_states = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFleetLocationsOutput`](crate::output::DeleteFleetLocationsOutput)
        pub fn build(self) -> crate::output::DeleteFleetLocationsOutput {
            crate::output::DeleteFleetLocationsOutput {
                fleet_id: self.fleet_id,
                fleet_arn: self.fleet_arn,
                location_states: self.location_states,
            }
        }
    }
}
impl DeleteFleetLocationsOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFleetLocationsOutput`](crate::output::DeleteFleetLocationsOutput)
    pub fn builder() -> crate::output::delete_fleet_locations_output::Builder {
        crate::output::delete_fleet_locations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFleetOutput {}
impl std::fmt::Debug for DeleteFleetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFleetOutput");
        formatter.finish()
    }
}
/// See [`DeleteFleetOutput`](crate::output::DeleteFleetOutput)
pub mod delete_fleet_output {
    /// A builder for [`DeleteFleetOutput`](crate::output::DeleteFleetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteFleetOutput`](crate::output::DeleteFleetOutput)
        pub fn build(self) -> crate::output::DeleteFleetOutput {
            crate::output::DeleteFleetOutput {}
        }
    }
}
impl DeleteFleetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFleetOutput`](crate::output::DeleteFleetOutput)
    pub fn builder() -> crate::output::delete_fleet_output::Builder {
        crate::output::delete_fleet_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBuildOutput {}
impl std::fmt::Debug for DeleteBuildOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBuildOutput");
        formatter.finish()
    }
}
/// See [`DeleteBuildOutput`](crate::output::DeleteBuildOutput)
pub mod delete_build_output {
    /// A builder for [`DeleteBuildOutput`](crate::output::DeleteBuildOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteBuildOutput`](crate::output::DeleteBuildOutput)
        pub fn build(self) -> crate::output::DeleteBuildOutput {
            crate::output::DeleteBuildOutput {}
        }
    }
}
impl DeleteBuildOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBuildOutput`](crate::output::DeleteBuildOutput)
    pub fn builder() -> crate::output::delete_build_output::Builder {
        crate::output::delete_build_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAliasOutput {}
impl std::fmt::Debug for DeleteAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAliasOutput");
        formatter.finish()
    }
}
/// See [`DeleteAliasOutput`](crate::output::DeleteAliasOutput)
pub mod delete_alias_output {
    /// A builder for [`DeleteAliasOutput`](crate::output::DeleteAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAliasOutput`](crate::output::DeleteAliasOutput)
        pub fn build(self) -> crate::output::DeleteAliasOutput {
            crate::output::DeleteAliasOutput {}
        }
    }
}
impl DeleteAliasOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAliasOutput`](crate::output::DeleteAliasOutput)
    pub fn builder() -> crate::output::delete_alias_output::Builder {
        crate::output::delete_alias_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateVpcPeeringConnectionOutput {}
impl std::fmt::Debug for CreateVpcPeeringConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateVpcPeeringConnectionOutput");
        formatter.finish()
    }
}
/// See [`CreateVpcPeeringConnectionOutput`](crate::output::CreateVpcPeeringConnectionOutput)
pub mod create_vpc_peering_connection_output {
    /// A builder for [`CreateVpcPeeringConnectionOutput`](crate::output::CreateVpcPeeringConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateVpcPeeringConnectionOutput`](crate::output::CreateVpcPeeringConnectionOutput)
        pub fn build(self) -> crate::output::CreateVpcPeeringConnectionOutput {
            crate::output::CreateVpcPeeringConnectionOutput {}
        }
    }
}
impl CreateVpcPeeringConnectionOutput {
    /// Creates a new builder-style object to manufacture [`CreateVpcPeeringConnectionOutput`](crate::output::CreateVpcPeeringConnectionOutput)
    pub fn builder() -> crate::output::create_vpc_peering_connection_output::Builder {
        crate::output::create_vpc_peering_connection_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateVpcPeeringAuthorizationOutput {
    /// <p>Details on the requested VPC peering authorization, including expiration.</p>
    pub vpc_peering_authorization: std::option::Option<crate::model::VpcPeeringAuthorization>,
}
impl CreateVpcPeeringAuthorizationOutput {
    /// <p>Details on the requested VPC peering authorization, including expiration.</p>
    pub fn vpc_peering_authorization(
        &self,
    ) -> std::option::Option<&crate::model::VpcPeeringAuthorization> {
        self.vpc_peering_authorization.as_ref()
    }
}
impl std::fmt::Debug for CreateVpcPeeringAuthorizationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateVpcPeeringAuthorizationOutput");
        formatter.field("vpc_peering_authorization", &self.vpc_peering_authorization);
        formatter.finish()
    }
}
/// See [`CreateVpcPeeringAuthorizationOutput`](crate::output::CreateVpcPeeringAuthorizationOutput)
pub mod create_vpc_peering_authorization_output {
    /// A builder for [`CreateVpcPeeringAuthorizationOutput`](crate::output::CreateVpcPeeringAuthorizationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpc_peering_authorization:
            std::option::Option<crate::model::VpcPeeringAuthorization>,
    }
    impl Builder {
        /// <p>Details on the requested VPC peering authorization, including expiration.</p>
        pub fn vpc_peering_authorization(
            mut self,
            input: crate::model::VpcPeeringAuthorization,
        ) -> Self {
            self.vpc_peering_authorization = Some(input);
            self
        }
        /// <p>Details on the requested VPC peering authorization, including expiration.</p>
        pub fn set_vpc_peering_authorization(
            mut self,
            input: std::option::Option<crate::model::VpcPeeringAuthorization>,
        ) -> Self {
            self.vpc_peering_authorization = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateVpcPeeringAuthorizationOutput`](crate::output::CreateVpcPeeringAuthorizationOutput)
        pub fn build(self) -> crate::output::CreateVpcPeeringAuthorizationOutput {
            crate::output::CreateVpcPeeringAuthorizationOutput {
                vpc_peering_authorization: self.vpc_peering_authorization,
            }
        }
    }
}
impl CreateVpcPeeringAuthorizationOutput {
    /// Creates a new builder-style object to manufacture [`CreateVpcPeeringAuthorizationOutput`](crate::output::CreateVpcPeeringAuthorizationOutput)
    pub fn builder() -> crate::output::create_vpc_peering_authorization_output::Builder {
        crate::output::create_vpc_peering_authorization_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateScriptOutput {
    /// <p>The newly created script record with a unique script ID and ARN. The new script's storage location reflects an Amazon S3 location: (1) If the script was uploaded from an S3 bucket under your account, the storage location reflects the information that was provided in the <i>CreateScript</i> request; (2) If the script file was uploaded from a local zip file, the storage location reflects an S3 location controls by the Amazon GameLift service.</p>
    pub script: std::option::Option<crate::model::Script>,
}
impl CreateScriptOutput {
    /// <p>The newly created script record with a unique script ID and ARN. The new script's storage location reflects an Amazon S3 location: (1) If the script was uploaded from an S3 bucket under your account, the storage location reflects the information that was provided in the <i>CreateScript</i> request; (2) If the script file was uploaded from a local zip file, the storage location reflects an S3 location controls by the Amazon GameLift service.</p>
    pub fn script(&self) -> std::option::Option<&crate::model::Script> {
        self.script.as_ref()
    }
}
impl std::fmt::Debug for CreateScriptOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateScriptOutput");
        formatter.field("script", &self.script);
        formatter.finish()
    }
}
/// See [`CreateScriptOutput`](crate::output::CreateScriptOutput)
pub mod create_script_output {
    /// A builder for [`CreateScriptOutput`](crate::output::CreateScriptOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) script: std::option::Option<crate::model::Script>,
    }
    impl Builder {
        /// <p>The newly created script record with a unique script ID and ARN. The new script's storage location reflects an Amazon S3 location: (1) If the script was uploaded from an S3 bucket under your account, the storage location reflects the information that was provided in the <i>CreateScript</i> request; (2) If the script file was uploaded from a local zip file, the storage location reflects an S3 location controls by the Amazon GameLift service.</p>
        pub fn script(mut self, input: crate::model::Script) -> Self {
            self.script = Some(input);
            self
        }
        /// <p>The newly created script record with a unique script ID and ARN. The new script's storage location reflects an Amazon S3 location: (1) If the script was uploaded from an S3 bucket under your account, the storage location reflects the information that was provided in the <i>CreateScript</i> request; (2) If the script file was uploaded from a local zip file, the storage location reflects an S3 location controls by the Amazon GameLift service.</p>
        pub fn set_script(mut self, input: std::option::Option<crate::model::Script>) -> Self {
            self.script = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateScriptOutput`](crate::output::CreateScriptOutput)
        pub fn build(self) -> crate::output::CreateScriptOutput {
            crate::output::CreateScriptOutput {
                script: self.script,
            }
        }
    }
}
impl CreateScriptOutput {
    /// Creates a new builder-style object to manufacture [`CreateScriptOutput`](crate::output::CreateScriptOutput)
    pub fn builder() -> crate::output::create_script_output::Builder {
        crate::output::create_script_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePlayerSessionsOutput {
    /// <p>A collection of player session objects created for the added players.</p>
    pub player_sessions: std::option::Option<std::vec::Vec<crate::model::PlayerSession>>,
}
impl CreatePlayerSessionsOutput {
    /// <p>A collection of player session objects created for the added players.</p>
    pub fn player_sessions(&self) -> std::option::Option<&[crate::model::PlayerSession]> {
        self.player_sessions.as_deref()
    }
}
impl std::fmt::Debug for CreatePlayerSessionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePlayerSessionsOutput");
        formatter.field("player_sessions", &self.player_sessions);
        formatter.finish()
    }
}
/// See [`CreatePlayerSessionsOutput`](crate::output::CreatePlayerSessionsOutput)
pub mod create_player_sessions_output {
    /// A builder for [`CreatePlayerSessionsOutput`](crate::output::CreatePlayerSessionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) player_sessions: std::option::Option<std::vec::Vec<crate::model::PlayerSession>>,
    }
    impl Builder {
        /// Appends an item to `player_sessions`.
        ///
        /// To override the contents of this collection use [`set_player_sessions`](Self::set_player_sessions).
        ///
        /// <p>A collection of player session objects created for the added players.</p>
        pub fn player_sessions(mut self, input: crate::model::PlayerSession) -> Self {
            let mut v = self.player_sessions.unwrap_or_default();
            v.push(input);
            self.player_sessions = Some(v);
            self
        }
        /// <p>A collection of player session objects created for the added players.</p>
        pub fn set_player_sessions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlayerSession>>,
        ) -> Self {
            self.player_sessions = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePlayerSessionsOutput`](crate::output::CreatePlayerSessionsOutput)
        pub fn build(self) -> crate::output::CreatePlayerSessionsOutput {
            crate::output::CreatePlayerSessionsOutput {
                player_sessions: self.player_sessions,
            }
        }
    }
}
impl CreatePlayerSessionsOutput {
    /// Creates a new builder-style object to manufacture [`CreatePlayerSessionsOutput`](crate::output::CreatePlayerSessionsOutput)
    pub fn builder() -> crate::output::create_player_sessions_output::Builder {
        crate::output::create_player_sessions_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePlayerSessionOutput {
    /// <p>Object that describes the newly created player session record.</p>
    pub player_session: std::option::Option<crate::model::PlayerSession>,
}
impl CreatePlayerSessionOutput {
    /// <p>Object that describes the newly created player session record.</p>
    pub fn player_session(&self) -> std::option::Option<&crate::model::PlayerSession> {
        self.player_session.as_ref()
    }
}
impl std::fmt::Debug for CreatePlayerSessionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePlayerSessionOutput");
        formatter.field("player_session", &self.player_session);
        formatter.finish()
    }
}
/// See [`CreatePlayerSessionOutput`](crate::output::CreatePlayerSessionOutput)
pub mod create_player_session_output {
    /// A builder for [`CreatePlayerSessionOutput`](crate::output::CreatePlayerSessionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) player_session: std::option::Option<crate::model::PlayerSession>,
    }
    impl Builder {
        /// <p>Object that describes the newly created player session record.</p>
        pub fn player_session(mut self, input: crate::model::PlayerSession) -> Self {
            self.player_session = Some(input);
            self
        }
        /// <p>Object that describes the newly created player session record.</p>
        pub fn set_player_session(
            mut self,
            input: std::option::Option<crate::model::PlayerSession>,
        ) -> Self {
            self.player_session = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePlayerSessionOutput`](crate::output::CreatePlayerSessionOutput)
        pub fn build(self) -> crate::output::CreatePlayerSessionOutput {
            crate::output::CreatePlayerSessionOutput {
                player_session: self.player_session,
            }
        }
    }
}
impl CreatePlayerSessionOutput {
    /// Creates a new builder-style object to manufacture [`CreatePlayerSessionOutput`](crate::output::CreatePlayerSessionOutput)
    pub fn builder() -> crate::output::create_player_session_output::Builder {
        crate::output::create_player_session_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMatchmakingRuleSetOutput {
    /// <p>The newly created matchmaking rule set.</p>
    pub rule_set: std::option::Option<crate::model::MatchmakingRuleSet>,
}
impl CreateMatchmakingRuleSetOutput {
    /// <p>The newly created matchmaking rule set.</p>
    pub fn rule_set(&self) -> std::option::Option<&crate::model::MatchmakingRuleSet> {
        self.rule_set.as_ref()
    }
}
impl std::fmt::Debug for CreateMatchmakingRuleSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMatchmakingRuleSetOutput");
        formatter.field("rule_set", &self.rule_set);
        formatter.finish()
    }
}
/// See [`CreateMatchmakingRuleSetOutput`](crate::output::CreateMatchmakingRuleSetOutput)
pub mod create_matchmaking_rule_set_output {
    /// A builder for [`CreateMatchmakingRuleSetOutput`](crate::output::CreateMatchmakingRuleSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_set: std::option::Option<crate::model::MatchmakingRuleSet>,
    }
    impl Builder {
        /// <p>The newly created matchmaking rule set.</p>
        pub fn rule_set(mut self, input: crate::model::MatchmakingRuleSet) -> Self {
            self.rule_set = Some(input);
            self
        }
        /// <p>The newly created matchmaking rule set.</p>
        pub fn set_rule_set(
            mut self,
            input: std::option::Option<crate::model::MatchmakingRuleSet>,
        ) -> Self {
            self.rule_set = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMatchmakingRuleSetOutput`](crate::output::CreateMatchmakingRuleSetOutput)
        pub fn build(self) -> crate::output::CreateMatchmakingRuleSetOutput {
            crate::output::CreateMatchmakingRuleSetOutput {
                rule_set: self.rule_set,
            }
        }
    }
}
impl CreateMatchmakingRuleSetOutput {
    /// Creates a new builder-style object to manufacture [`CreateMatchmakingRuleSetOutput`](crate::output::CreateMatchmakingRuleSetOutput)
    pub fn builder() -> crate::output::create_matchmaking_rule_set_output::Builder {
        crate::output::create_matchmaking_rule_set_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMatchmakingConfigurationOutput {
    /// <p>Object that describes the newly created matchmaking configuration.</p>
    pub configuration: std::option::Option<crate::model::MatchmakingConfiguration>,
}
impl CreateMatchmakingConfigurationOutput {
    /// <p>Object that describes the newly created matchmaking configuration.</p>
    pub fn configuration(&self) -> std::option::Option<&crate::model::MatchmakingConfiguration> {
        self.configuration.as_ref()
    }
}
impl std::fmt::Debug for CreateMatchmakingConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMatchmakingConfigurationOutput");
        formatter.field("configuration", &self.configuration);
        formatter.finish()
    }
}
/// See [`CreateMatchmakingConfigurationOutput`](crate::output::CreateMatchmakingConfigurationOutput)
pub mod create_matchmaking_configuration_output {
    /// A builder for [`CreateMatchmakingConfigurationOutput`](crate::output::CreateMatchmakingConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration: std::option::Option<crate::model::MatchmakingConfiguration>,
    }
    impl Builder {
        /// <p>Object that describes the newly created matchmaking configuration.</p>
        pub fn configuration(mut self, input: crate::model::MatchmakingConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>Object that describes the newly created matchmaking configuration.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::MatchmakingConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMatchmakingConfigurationOutput`](crate::output::CreateMatchmakingConfigurationOutput)
        pub fn build(self) -> crate::output::CreateMatchmakingConfigurationOutput {
            crate::output::CreateMatchmakingConfigurationOutput {
                configuration: self.configuration,
            }
        }
    }
}
impl CreateMatchmakingConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`CreateMatchmakingConfigurationOutput`](crate::output::CreateMatchmakingConfigurationOutput)
    pub fn builder() -> crate::output::create_matchmaking_configuration_output::Builder {
        crate::output::create_matchmaking_configuration_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGameSessionQueueOutput {
    /// <p>An object that describes the newly created game session queue.</p>
    pub game_session_queue: std::option::Option<crate::model::GameSessionQueue>,
}
impl CreateGameSessionQueueOutput {
    /// <p>An object that describes the newly created game session queue.</p>
    pub fn game_session_queue(&self) -> std::option::Option<&crate::model::GameSessionQueue> {
        self.game_session_queue.as_ref()
    }
}
impl std::fmt::Debug for CreateGameSessionQueueOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGameSessionQueueOutput");
        formatter.field("game_session_queue", &self.game_session_queue);
        formatter.finish()
    }
}
/// See [`CreateGameSessionQueueOutput`](crate::output::CreateGameSessionQueueOutput)
pub mod create_game_session_queue_output {
    /// A builder for [`CreateGameSessionQueueOutput`](crate::output::CreateGameSessionQueueOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_session_queue: std::option::Option<crate::model::GameSessionQueue>,
    }
    impl Builder {
        /// <p>An object that describes the newly created game session queue.</p>
        pub fn game_session_queue(mut self, input: crate::model::GameSessionQueue) -> Self {
            self.game_session_queue = Some(input);
            self
        }
        /// <p>An object that describes the newly created game session queue.</p>
        pub fn set_game_session_queue(
            mut self,
            input: std::option::Option<crate::model::GameSessionQueue>,
        ) -> Self {
            self.game_session_queue = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGameSessionQueueOutput`](crate::output::CreateGameSessionQueueOutput)
        pub fn build(self) -> crate::output::CreateGameSessionQueueOutput {
            crate::output::CreateGameSessionQueueOutput {
                game_session_queue: self.game_session_queue,
            }
        }
    }
}
impl CreateGameSessionQueueOutput {
    /// Creates a new builder-style object to manufacture [`CreateGameSessionQueueOutput`](crate::output::CreateGameSessionQueueOutput)
    pub fn builder() -> crate::output::create_game_session_queue_output::Builder {
        crate::output::create_game_session_queue_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGameSessionOutput {
    /// <p>Object that describes the newly created game session record.</p>
    pub game_session: std::option::Option<crate::model::GameSession>,
}
impl CreateGameSessionOutput {
    /// <p>Object that describes the newly created game session record.</p>
    pub fn game_session(&self) -> std::option::Option<&crate::model::GameSession> {
        self.game_session.as_ref()
    }
}
impl std::fmt::Debug for CreateGameSessionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGameSessionOutput");
        formatter.field("game_session", &self.game_session);
        formatter.finish()
    }
}
/// See [`CreateGameSessionOutput`](crate::output::CreateGameSessionOutput)
pub mod create_game_session_output {
    /// A builder for [`CreateGameSessionOutput`](crate::output::CreateGameSessionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_session: std::option::Option<crate::model::GameSession>,
    }
    impl Builder {
        /// <p>Object that describes the newly created game session record.</p>
        pub fn game_session(mut self, input: crate::model::GameSession) -> Self {
            self.game_session = Some(input);
            self
        }
        /// <p>Object that describes the newly created game session record.</p>
        pub fn set_game_session(
            mut self,
            input: std::option::Option<crate::model::GameSession>,
        ) -> Self {
            self.game_session = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGameSessionOutput`](crate::output::CreateGameSessionOutput)
        pub fn build(self) -> crate::output::CreateGameSessionOutput {
            crate::output::CreateGameSessionOutput {
                game_session: self.game_session,
            }
        }
    }
}
impl CreateGameSessionOutput {
    /// Creates a new builder-style object to manufacture [`CreateGameSessionOutput`](crate::output::CreateGameSessionOutput)
    pub fn builder() -> crate::output::create_game_session_output::Builder {
        crate::output::create_game_session_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGameServerGroupOutput {
    /// <p>The newly created game server group object, including the new ARN value for the GameLift FleetIQ game server group and the object's status. The Amazon EC2 Auto Scaling group ARN is initially null, since the group has not yet been created. This value is added once the game server group status reaches <code>ACTIVE</code>. </p>
    pub game_server_group: std::option::Option<crate::model::GameServerGroup>,
}
impl CreateGameServerGroupOutput {
    /// <p>The newly created game server group object, including the new ARN value for the GameLift FleetIQ game server group and the object's status. The Amazon EC2 Auto Scaling group ARN is initially null, since the group has not yet been created. This value is added once the game server group status reaches <code>ACTIVE</code>. </p>
    pub fn game_server_group(&self) -> std::option::Option<&crate::model::GameServerGroup> {
        self.game_server_group.as_ref()
    }
}
impl std::fmt::Debug for CreateGameServerGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGameServerGroupOutput");
        formatter.field("game_server_group", &self.game_server_group);
        formatter.finish()
    }
}
/// See [`CreateGameServerGroupOutput`](crate::output::CreateGameServerGroupOutput)
pub mod create_game_server_group_output {
    /// A builder for [`CreateGameServerGroupOutput`](crate::output::CreateGameServerGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_server_group: std::option::Option<crate::model::GameServerGroup>,
    }
    impl Builder {
        /// <p>The newly created game server group object, including the new ARN value for the GameLift FleetIQ game server group and the object's status. The Amazon EC2 Auto Scaling group ARN is initially null, since the group has not yet been created. This value is added once the game server group status reaches <code>ACTIVE</code>. </p>
        pub fn game_server_group(mut self, input: crate::model::GameServerGroup) -> Self {
            self.game_server_group = Some(input);
            self
        }
        /// <p>The newly created game server group object, including the new ARN value for the GameLift FleetIQ game server group and the object's status. The Amazon EC2 Auto Scaling group ARN is initially null, since the group has not yet been created. This value is added once the game server group status reaches <code>ACTIVE</code>. </p>
        pub fn set_game_server_group(
            mut self,
            input: std::option::Option<crate::model::GameServerGroup>,
        ) -> Self {
            self.game_server_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGameServerGroupOutput`](crate::output::CreateGameServerGroupOutput)
        pub fn build(self) -> crate::output::CreateGameServerGroupOutput {
            crate::output::CreateGameServerGroupOutput {
                game_server_group: self.game_server_group,
            }
        }
    }
}
impl CreateGameServerGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateGameServerGroupOutput`](crate::output::CreateGameServerGroupOutput)
    pub fn builder() -> crate::output::create_game_server_group_output::Builder {
        crate::output::create_game_server_group_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFleetLocationsOutput {
    /// <p>A unique identifier for the fleet that was updated with new locations.</p>
    pub fleet_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
    /// </region></code>. </p>
    pub fleet_arn: std::option::Option<std::string::String>,
    /// <p>The remote locations that are being added to the fleet, and the life-cycle status of each location. For new locations, the status is set to <code>NEW</code>. During location creation, GameLift updates each location's status as instances are deployed there and prepared for game hosting. This list does not include the fleet home Region or any remote locations that were already added to the fleet.</p>
    pub location_states: std::option::Option<std::vec::Vec<crate::model::LocationState>>,
}
impl CreateFleetLocationsOutput {
    /// <p>A unique identifier for the fleet that was updated with new locations.</p>
    pub fn fleet_id(&self) -> std::option::Option<&str> {
        self.fleet_id.as_deref()
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
    /// </region></code>. </p>
    pub fn fleet_arn(&self) -> std::option::Option<&str> {
        self.fleet_arn.as_deref()
    }
    /// <p>The remote locations that are being added to the fleet, and the life-cycle status of each location. For new locations, the status is set to <code>NEW</code>. During location creation, GameLift updates each location's status as instances are deployed there and prepared for game hosting. This list does not include the fleet home Region or any remote locations that were already added to the fleet.</p>
    pub fn location_states(&self) -> std::option::Option<&[crate::model::LocationState]> {
        self.location_states.as_deref()
    }
}
impl std::fmt::Debug for CreateFleetLocationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFleetLocationsOutput");
        formatter.field("fleet_id", &self.fleet_id);
        formatter.field("fleet_arn", &self.fleet_arn);
        formatter.field("location_states", &self.location_states);
        formatter.finish()
    }
}
/// See [`CreateFleetLocationsOutput`](crate::output::CreateFleetLocationsOutput)
pub mod create_fleet_locations_output {
    /// A builder for [`CreateFleetLocationsOutput`](crate::output::CreateFleetLocationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) fleet_arn: std::option::Option<std::string::String>,
        pub(crate) location_states: std::option::Option<std::vec::Vec<crate::model::LocationState>>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet that was updated with new locations.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet that was updated with new locations.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
        /// </region></code>. </p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
        /// </region></code>. </p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_arn = input;
            self
        }
        /// Appends an item to `location_states`.
        ///
        /// To override the contents of this collection use [`set_location_states`](Self::set_location_states).
        ///
        /// <p>The remote locations that are being added to the fleet, and the life-cycle status of each location. For new locations, the status is set to <code>NEW</code>. During location creation, GameLift updates each location's status as instances are deployed there and prepared for game hosting. This list does not include the fleet home Region or any remote locations that were already added to the fleet.</p>
        pub fn location_states(mut self, input: crate::model::LocationState) -> Self {
            let mut v = self.location_states.unwrap_or_default();
            v.push(input);
            self.location_states = Some(v);
            self
        }
        /// <p>The remote locations that are being added to the fleet, and the life-cycle status of each location. For new locations, the status is set to <code>NEW</code>. During location creation, GameLift updates each location's status as instances are deployed there and prepared for game hosting. This list does not include the fleet home Region or any remote locations that were already added to the fleet.</p>
        pub fn set_location_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LocationState>>,
        ) -> Self {
            self.location_states = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFleetLocationsOutput`](crate::output::CreateFleetLocationsOutput)
        pub fn build(self) -> crate::output::CreateFleetLocationsOutput {
            crate::output::CreateFleetLocationsOutput {
                fleet_id: self.fleet_id,
                fleet_arn: self.fleet_arn,
                location_states: self.location_states,
            }
        }
    }
}
impl CreateFleetLocationsOutput {
    /// Creates a new builder-style object to manufacture [`CreateFleetLocationsOutput`](crate::output::CreateFleetLocationsOutput)
    pub fn builder() -> crate::output::create_fleet_locations_output::Builder {
        crate::output::create_fleet_locations_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFleetOutput {
    /// <p>The properties for the new fleet, including the current status. All fleets are placed in <code>NEW</code> status on creation. </p>
    pub fleet_attributes: std::option::Option<crate::model::FleetAttributes>,
    /// <p>The fleet's locations and life-cycle status of each location. For new fleets, the status of all locations is set to <code>NEW</code>. During fleet creation, GameLift updates each location status as instances are deployed there and prepared for game hosting. This list includes an entry for the fleet's home Region. For fleets with no remote locations, only one entry, representing the home Region, is returned.</p>
    pub location_states: std::option::Option<std::vec::Vec<crate::model::LocationState>>,
}
impl CreateFleetOutput {
    /// <p>The properties for the new fleet, including the current status. All fleets are placed in <code>NEW</code> status on creation. </p>
    pub fn fleet_attributes(&self) -> std::option::Option<&crate::model::FleetAttributes> {
        self.fleet_attributes.as_ref()
    }
    /// <p>The fleet's locations and life-cycle status of each location. For new fleets, the status of all locations is set to <code>NEW</code>. During fleet creation, GameLift updates each location status as instances are deployed there and prepared for game hosting. This list includes an entry for the fleet's home Region. For fleets with no remote locations, only one entry, representing the home Region, is returned.</p>
    pub fn location_states(&self) -> std::option::Option<&[crate::model::LocationState]> {
        self.location_states.as_deref()
    }
}
impl std::fmt::Debug for CreateFleetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFleetOutput");
        formatter.field("fleet_attributes", &self.fleet_attributes);
        formatter.field("location_states", &self.location_states);
        formatter.finish()
    }
}
/// See [`CreateFleetOutput`](crate::output::CreateFleetOutput)
pub mod create_fleet_output {
    /// A builder for [`CreateFleetOutput`](crate::output::CreateFleetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_attributes: std::option::Option<crate::model::FleetAttributes>,
        pub(crate) location_states: std::option::Option<std::vec::Vec<crate::model::LocationState>>,
    }
    impl Builder {
        /// <p>The properties for the new fleet, including the current status. All fleets are placed in <code>NEW</code> status on creation. </p>
        pub fn fleet_attributes(mut self, input: crate::model::FleetAttributes) -> Self {
            self.fleet_attributes = Some(input);
            self
        }
        /// <p>The properties for the new fleet, including the current status. All fleets are placed in <code>NEW</code> status on creation. </p>
        pub fn set_fleet_attributes(
            mut self,
            input: std::option::Option<crate::model::FleetAttributes>,
        ) -> Self {
            self.fleet_attributes = input;
            self
        }
        /// Appends an item to `location_states`.
        ///
        /// To override the contents of this collection use [`set_location_states`](Self::set_location_states).
        ///
        /// <p>The fleet's locations and life-cycle status of each location. For new fleets, the status of all locations is set to <code>NEW</code>. During fleet creation, GameLift updates each location status as instances are deployed there and prepared for game hosting. This list includes an entry for the fleet's home Region. For fleets with no remote locations, only one entry, representing the home Region, is returned.</p>
        pub fn location_states(mut self, input: crate::model::LocationState) -> Self {
            let mut v = self.location_states.unwrap_or_default();
            v.push(input);
            self.location_states = Some(v);
            self
        }
        /// <p>The fleet's locations and life-cycle status of each location. For new fleets, the status of all locations is set to <code>NEW</code>. During fleet creation, GameLift updates each location status as instances are deployed there and prepared for game hosting. This list includes an entry for the fleet's home Region. For fleets with no remote locations, only one entry, representing the home Region, is returned.</p>
        pub fn set_location_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LocationState>>,
        ) -> Self {
            self.location_states = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFleetOutput`](crate::output::CreateFleetOutput)
        pub fn build(self) -> crate::output::CreateFleetOutput {
            crate::output::CreateFleetOutput {
                fleet_attributes: self.fleet_attributes,
                location_states: self.location_states,
            }
        }
    }
}
impl CreateFleetOutput {
    /// Creates a new builder-style object to manufacture [`CreateFleetOutput`](crate::output::CreateFleetOutput)
    pub fn builder() -> crate::output::create_fleet_output::Builder {
        crate::output::create_fleet_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBuildOutput {
    /// <p>The newly created build resource, including a unique build IDs and status. </p>
    ///
    /// _Note: This member has been renamed from `build`._
    pub build_value: std::option::Option<crate::model::Build>,
    /// <p>This element is returned only when the operation is called without a storage location. It contains credentials to use when you are uploading a build file to an Amazon S3 bucket that is owned by Amazon GameLift. Credentials have a limited life span. To refresh these credentials, call <code>RequestUploadCredentials</code>. </p>
    pub upload_credentials: std::option::Option<crate::model::AwsCredentials>,
    /// <p>Amazon S3 location for your game build file, including bucket name and key.</p>
    pub storage_location: std::option::Option<crate::model::S3Location>,
}
impl CreateBuildOutput {
    /// <p>The newly created build resource, including a unique build IDs and status. </p>
    ///
    /// _Note: This member has been renamed from `build`._
    pub fn build_value(&self) -> std::option::Option<&crate::model::Build> {
        self.build_value.as_ref()
    }
    /// <p>This element is returned only when the operation is called without a storage location. It contains credentials to use when you are uploading a build file to an Amazon S3 bucket that is owned by Amazon GameLift. Credentials have a limited life span. To refresh these credentials, call <code>RequestUploadCredentials</code>. </p>
    pub fn upload_credentials(&self) -> std::option::Option<&crate::model::AwsCredentials> {
        self.upload_credentials.as_ref()
    }
    /// <p>Amazon S3 location for your game build file, including bucket name and key.</p>
    pub fn storage_location(&self) -> std::option::Option<&crate::model::S3Location> {
        self.storage_location.as_ref()
    }
}
impl std::fmt::Debug for CreateBuildOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBuildOutput");
        formatter.field("build_value", &self.build_value);
        formatter.field("upload_credentials", &"*** Sensitive Data Redacted ***");
        formatter.field("storage_location", &self.storage_location);
        formatter.finish()
    }
}
/// See [`CreateBuildOutput`](crate::output::CreateBuildOutput)
pub mod create_build_output {
    /// A builder for [`CreateBuildOutput`](crate::output::CreateBuildOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) build_value: std::option::Option<crate::model::Build>,
        pub(crate) upload_credentials: std::option::Option<crate::model::AwsCredentials>,
        pub(crate) storage_location: std::option::Option<crate::model::S3Location>,
    }
    impl Builder {
        /// <p>The newly created build resource, including a unique build IDs and status. </p>
        pub fn build_value(mut self, input: crate::model::Build) -> Self {
            self.build_value = Some(input);
            self
        }
        /// <p>The newly created build resource, including a unique build IDs and status. </p>
        pub fn set_build(mut self, input: std::option::Option<crate::model::Build>) -> Self {
            self.build_value = input;
            self
        }
        /// <p>This element is returned only when the operation is called without a storage location. It contains credentials to use when you are uploading a build file to an Amazon S3 bucket that is owned by Amazon GameLift. Credentials have a limited life span. To refresh these credentials, call <code>RequestUploadCredentials</code>. </p>
        pub fn upload_credentials(mut self, input: crate::model::AwsCredentials) -> Self {
            self.upload_credentials = Some(input);
            self
        }
        /// <p>This element is returned only when the operation is called without a storage location. It contains credentials to use when you are uploading a build file to an Amazon S3 bucket that is owned by Amazon GameLift. Credentials have a limited life span. To refresh these credentials, call <code>RequestUploadCredentials</code>. </p>
        pub fn set_upload_credentials(
            mut self,
            input: std::option::Option<crate::model::AwsCredentials>,
        ) -> Self {
            self.upload_credentials = input;
            self
        }
        /// <p>Amazon S3 location for your game build file, including bucket name and key.</p>
        pub fn storage_location(mut self, input: crate::model::S3Location) -> Self {
            self.storage_location = Some(input);
            self
        }
        /// <p>Amazon S3 location for your game build file, including bucket name and key.</p>
        pub fn set_storage_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.storage_location = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBuildOutput`](crate::output::CreateBuildOutput)
        pub fn build(self) -> crate::output::CreateBuildOutput {
            crate::output::CreateBuildOutput {
                build_value: self.build_value,
                upload_credentials: self.upload_credentials,
                storage_location: self.storage_location,
            }
        }
    }
}
impl CreateBuildOutput {
    /// Creates a new builder-style object to manufacture [`CreateBuildOutput`](crate::output::CreateBuildOutput)
    pub fn builder() -> crate::output::create_build_output::Builder {
        crate::output::create_build_output::Builder::default()
    }
}

/// <p>Represents the returned data in response to a request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAliasOutput {
    /// <p>The newly created alias resource.</p>
    pub alias: std::option::Option<crate::model::Alias>,
}
impl CreateAliasOutput {
    /// <p>The newly created alias resource.</p>
    pub fn alias(&self) -> std::option::Option<&crate::model::Alias> {
        self.alias.as_ref()
    }
}
impl std::fmt::Debug for CreateAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAliasOutput");
        formatter.field("alias", &self.alias);
        formatter.finish()
    }
}
/// See [`CreateAliasOutput`](crate::output::CreateAliasOutput)
pub mod create_alias_output {
    /// A builder for [`CreateAliasOutput`](crate::output::CreateAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alias: std::option::Option<crate::model::Alias>,
    }
    impl Builder {
        /// <p>The newly created alias resource.</p>
        pub fn alias(mut self, input: crate::model::Alias) -> Self {
            self.alias = Some(input);
            self
        }
        /// <p>The newly created alias resource.</p>
        pub fn set_alias(mut self, input: std::option::Option<crate::model::Alias>) -> Self {
            self.alias = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAliasOutput`](crate::output::CreateAliasOutput)
        pub fn build(self) -> crate::output::CreateAliasOutput {
            crate::output::CreateAliasOutput { alias: self.alias }
        }
    }
}
impl CreateAliasOutput {
    /// Creates a new builder-style object to manufacture [`CreateAliasOutput`](crate::output::CreateAliasOutput)
    pub fn builder() -> crate::output::create_alias_output::Builder {
        crate::output::create_alias_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClaimGameServerOutput {
    /// <p>Object that describes the newly claimed game server.</p>
    pub game_server: std::option::Option<crate::model::GameServer>,
}
impl ClaimGameServerOutput {
    /// <p>Object that describes the newly claimed game server.</p>
    pub fn game_server(&self) -> std::option::Option<&crate::model::GameServer> {
        self.game_server.as_ref()
    }
}
impl std::fmt::Debug for ClaimGameServerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClaimGameServerOutput");
        formatter.field("game_server", &self.game_server);
        formatter.finish()
    }
}
/// See [`ClaimGameServerOutput`](crate::output::ClaimGameServerOutput)
pub mod claim_game_server_output {
    /// A builder for [`ClaimGameServerOutput`](crate::output::ClaimGameServerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_server: std::option::Option<crate::model::GameServer>,
    }
    impl Builder {
        /// <p>Object that describes the newly claimed game server.</p>
        pub fn game_server(mut self, input: crate::model::GameServer) -> Self {
            self.game_server = Some(input);
            self
        }
        /// <p>Object that describes the newly claimed game server.</p>
        pub fn set_game_server(
            mut self,
            input: std::option::Option<crate::model::GameServer>,
        ) -> Self {
            self.game_server = input;
            self
        }
        /// Consumes the builder and constructs a [`ClaimGameServerOutput`](crate::output::ClaimGameServerOutput)
        pub fn build(self) -> crate::output::ClaimGameServerOutput {
            crate::output::ClaimGameServerOutput {
                game_server: self.game_server,
            }
        }
    }
}
impl ClaimGameServerOutput {
    /// Creates a new builder-style object to manufacture [`ClaimGameServerOutput`](crate::output::ClaimGameServerOutput)
    pub fn builder() -> crate::output::claim_game_server_output::Builder {
        crate::output::claim_game_server_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceptMatchOutput {}
impl std::fmt::Debug for AcceptMatchOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceptMatchOutput");
        formatter.finish()
    }
}
/// See [`AcceptMatchOutput`](crate::output::AcceptMatchOutput)
pub mod accept_match_output {
    /// A builder for [`AcceptMatchOutput`](crate::output::AcceptMatchOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AcceptMatchOutput`](crate::output::AcceptMatchOutput)
        pub fn build(self) -> crate::output::AcceptMatchOutput {
            crate::output::AcceptMatchOutput {}
        }
    }
}
impl AcceptMatchOutput {
    /// Creates a new builder-style object to manufacture [`AcceptMatchOutput`](crate::output::AcceptMatchOutput)
    pub fn builder() -> crate::output::accept_match_output::Builder {
        crate::output::accept_match_output::Builder::default()
    }
}
