// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Properties describing a Realtime script.</p>
/// <p> <b>Related actions</b> </p>
/// <p> <code>CreateScript</code> | <code>ListScripts</code> | <code>DescribeScript</code> | <code>UpdateScript</code> | <code>DeleteScript</code> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Script {
    /// <p>A unique identifier for the Realtime script</p>
    pub script_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift script resource and uniquely identifies it. ARNs are unique across all Regions. In a GameLift script ARN, the resource ID matches the <i>ScriptId</i> value.</p>
    pub script_arn: std::option::Option<std::string::String>,
    /// <p>A descriptive label that is associated with a script. Script names do not need to be unique.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Version information that is associated with a build or script. Version strings do not need to be unique.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The file size of the uploaded Realtime script, expressed in bytes. When files are uploaded from an S3 location, this value remains at "0".</p>
    pub size_on_disk: std::option::Option<i64>,
    /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The location in Amazon S3 where build or script files are stored for access by Amazon GameLift. This location is specified in <code>CreateBuild</code>, <code>CreateScript</code>, and <code>UpdateScript</code> requests. </p>
    pub storage_location: std::option::Option<crate::model::S3Location>,
}
impl Script {
    /// <p>A unique identifier for the Realtime script</p>
    pub fn script_id(&self) -> std::option::Option<&str> {
        self.script_id.as_deref()
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift script resource and uniquely identifies it. ARNs are unique across all Regions. In a GameLift script ARN, the resource ID matches the <i>ScriptId</i> value.</p>
    pub fn script_arn(&self) -> std::option::Option<&str> {
        self.script_arn.as_deref()
    }
    /// <p>A descriptive label that is associated with a script. Script names do not need to be unique.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Version information that is associated with a build or script. Version strings do not need to be unique.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The file size of the uploaded Realtime script, expressed in bytes. When files are uploaded from an S3 location, this value remains at "0".</p>
    pub fn size_on_disk(&self) -> std::option::Option<i64> {
        self.size_on_disk
    }
    /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The location in Amazon S3 where build or script files are stored for access by Amazon GameLift. This location is specified in <code>CreateBuild</code>, <code>CreateScript</code>, and <code>UpdateScript</code> requests. </p>
    pub fn storage_location(&self) -> std::option::Option<&crate::model::S3Location> {
        self.storage_location.as_ref()
    }
}
impl std::fmt::Debug for Script {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Script");
        formatter.field("script_id", &self.script_id);
        formatter.field("script_arn", &self.script_arn);
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.field("size_on_disk", &self.size_on_disk);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("storage_location", &self.storage_location);
        formatter.finish()
    }
}
/// See [`Script`](crate::model::Script)
pub mod script {
    /// A builder for [`Script`](crate::model::Script)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) script_id: std::option::Option<std::string::String>,
        pub(crate) script_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) size_on_disk: std::option::Option<i64>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) storage_location: std::option::Option<crate::model::S3Location>,
    }
    impl Builder {
        /// <p>A unique identifier for the Realtime script</p>
        pub fn script_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.script_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the Realtime script</p>
        pub fn set_script_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.script_id = input;
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift script resource and uniquely identifies it. ARNs are unique across all Regions. In a GameLift script ARN, the resource ID matches the <i>ScriptId</i> value.</p>
        pub fn script_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.script_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift script resource and uniquely identifies it. ARNs are unique across all Regions. In a GameLift script ARN, the resource ID matches the <i>ScriptId</i> value.</p>
        pub fn set_script_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.script_arn = input;
            self
        }
        /// <p>A descriptive label that is associated with a script. Script names do not need to be unique.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A descriptive label that is associated with a script. Script names do not need to be unique.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Version information that is associated with a build or script. Version strings do not need to be unique.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>Version information that is associated with a build or script. Version strings do not need to be unique.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The file size of the uploaded Realtime script, expressed in bytes. When files are uploaded from an S3 location, this value remains at "0".</p>
        pub fn size_on_disk(mut self, input: i64) -> Self {
            self.size_on_disk = Some(input);
            self
        }
        /// <p>The file size of the uploaded Realtime script, expressed in bytes. When files are uploaded from an S3 location, this value remains at "0".</p>
        pub fn set_size_on_disk(mut self, input: std::option::Option<i64>) -> Self {
            self.size_on_disk = input;
            self
        }
        /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The location in Amazon S3 where build or script files are stored for access by Amazon GameLift. This location is specified in <code>CreateBuild</code>, <code>CreateScript</code>, and <code>UpdateScript</code> requests. </p>
        pub fn storage_location(mut self, input: crate::model::S3Location) -> Self {
            self.storage_location = Some(input);
            self
        }
        /// <p>The location in Amazon S3 where build or script files are stored for access by Amazon GameLift. This location is specified in <code>CreateBuild</code>, <code>CreateScript</code>, and <code>UpdateScript</code> requests. </p>
        pub fn set_storage_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.storage_location = input;
            self
        }
        /// Consumes the builder and constructs a [`Script`](crate::model::Script)
        pub fn build(self) -> crate::model::Script {
            crate::model::Script {
                script_id: self.script_id,
                script_arn: self.script_arn,
                name: self.name,
                version: self.version,
                size_on_disk: self.size_on_disk,
                creation_time: self.creation_time,
                storage_location: self.storage_location,
            }
        }
    }
}
impl Script {
    /// Creates a new builder-style object to manufacture [`Script`](crate::model::Script)
    pub fn builder() -> crate::model::script::Builder {
        crate::model::script::Builder::default()
    }
}

/// <p>The location in Amazon S3 where build or script files are stored for access by Amazon GameLift. This location is specified in <code>CreateBuild</code>, <code>CreateScript</code>, and <code>UpdateScript</code> requests. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Location {
    /// <p>An Amazon S3 bucket identifier. This is the name of the S3 bucket.</p> <note>
    /// <p>GameLift currently does not support uploading from Amazon S3 buckets with names that contain a dot (.).</p>
    /// </note>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>The name of the zip file that contains the build files or script files. </p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) for an IAM role that allows Amazon GameLift to access the S3 bucket.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The version of the file, if object versioning is turned on for the bucket. Amazon GameLift uses this information when retrieving files from an S3 bucket that you own. Use this parameter to specify a specific version of the file. If not set, the latest version of the file is retrieved. </p>
    pub object_version: std::option::Option<std::string::String>,
}
impl S3Location {
    /// <p>An Amazon S3 bucket identifier. This is the name of the S3 bucket.</p> <note>
    /// <p>GameLift currently does not support uploading from Amazon S3 buckets with names that contain a dot (.).</p>
    /// </note>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The name of the zip file that contains the build files or script files. </p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) for an IAM role that allows Amazon GameLift to access the S3 bucket.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The version of the file, if object versioning is turned on for the bucket. Amazon GameLift uses this information when retrieving files from an S3 bucket that you own. Use this parameter to specify a specific version of the file. If not set, the latest version of the file is retrieved. </p>
    pub fn object_version(&self) -> std::option::Option<&str> {
        self.object_version.as_deref()
    }
}
impl std::fmt::Debug for S3Location {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Location");
        formatter.field("bucket", &self.bucket);
        formatter.field("key", &self.key);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("object_version", &self.object_version);
        formatter.finish()
    }
}
/// See [`S3Location`](crate::model::S3Location)
pub mod s3_location {
    /// A builder for [`S3Location`](crate::model::S3Location)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) object_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An Amazon S3 bucket identifier. This is the name of the S3 bucket.</p> <note>
        /// <p>GameLift currently does not support uploading from Amazon S3 buckets with names that contain a dot (.).</p>
        /// </note>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>An Amazon S3 bucket identifier. This is the name of the S3 bucket.</p> <note>
        /// <p>GameLift currently does not support uploading from Amazon S3 buckets with names that contain a dot (.).</p>
        /// </note>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The name of the zip file that contains the build files or script files. </p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The name of the zip file that contains the build files or script files. </p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) for an IAM role that allows Amazon GameLift to access the S3 bucket.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) for an IAM role that allows Amazon GameLift to access the S3 bucket.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The version of the file, if object versioning is turned on for the bucket. Amazon GameLift uses this information when retrieving files from an S3 bucket that you own. Use this parameter to specify a specific version of the file. If not set, the latest version of the file is retrieved. </p>
        pub fn object_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_version = Some(input.into());
            self
        }
        /// <p>The version of the file, if object versioning is turned on for the bucket. Amazon GameLift uses this information when retrieving files from an S3 bucket that you own. Use this parameter to specify a specific version of the file. If not set, the latest version of the file is retrieved. </p>
        pub fn set_object_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_version = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Location`](crate::model::S3Location)
        pub fn build(self) -> crate::model::S3Location {
            crate::model::S3Location {
                bucket: self.bucket,
                key: self.key,
                role_arn: self.role_arn,
                object_version: self.object_version,
            }
        }
    }
}
impl S3Location {
    /// Creates a new builder-style object to manufacture [`S3Location`](crate::model::S3Location)
    pub fn builder() -> crate::model::s3_location::Builder {
        crate::model::s3_location::Builder::default()
    }
}

/// <p>A collection of server process configurations that describe the set of processes to run on each instance in a fleet. Server processes run either an executable in a custom game build or a Realtime Servers script. GameLift launches the configured processes, manages their life cycle, and replaces them as needed. Each instance checks regularly for an updated runtime configuration. </p>
/// <p>A GameLift instance is limited to 50 processes running concurrently. To calculate the total number of processes in a runtime configuration, add the values of the <code>ConcurrentExecutions</code> parameter for each <code>ServerProcess</code>. Learn more about <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-multiprocess.html"> Running Multiple Processes on a Fleet</a>.</p>
/// <p> <b>Related actions</b> </p>
/// <p> <code>DescribeRuntimeConfiguration</code> | <code>UpdateRuntimeConfiguration</code> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RuntimeConfiguration {
    /// <p>A collection of server process configurations that identify what server processes to run on each instance in a fleet.</p>
    pub server_processes: std::option::Option<std::vec::Vec<crate::model::ServerProcess>>,
    /// <p>The number of game sessions in status <code>ACTIVATING</code> to allow on an instance. This setting limits the instance resources that can be used for new game activations at any one time.</p>
    pub max_concurrent_game_session_activations: std::option::Option<i32>,
    /// <p>The maximum amount of time (in seconds) allowed to launch a new game session and have it report ready to host players. During this time, the game session is in status <code>ACTIVATING</code>. If the game session does not become active before the timeout, it is ended and the game session status is changed to <code>TERMINATED</code>.</p>
    pub game_session_activation_timeout_seconds: std::option::Option<i32>,
}
impl RuntimeConfiguration {
    /// <p>A collection of server process configurations that identify what server processes to run on each instance in a fleet.</p>
    pub fn server_processes(&self) -> std::option::Option<&[crate::model::ServerProcess]> {
        self.server_processes.as_deref()
    }
    /// <p>The number of game sessions in status <code>ACTIVATING</code> to allow on an instance. This setting limits the instance resources that can be used for new game activations at any one time.</p>
    pub fn max_concurrent_game_session_activations(&self) -> std::option::Option<i32> {
        self.max_concurrent_game_session_activations
    }
    /// <p>The maximum amount of time (in seconds) allowed to launch a new game session and have it report ready to host players. During this time, the game session is in status <code>ACTIVATING</code>. If the game session does not become active before the timeout, it is ended and the game session status is changed to <code>TERMINATED</code>.</p>
    pub fn game_session_activation_timeout_seconds(&self) -> std::option::Option<i32> {
        self.game_session_activation_timeout_seconds
    }
}
impl std::fmt::Debug for RuntimeConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RuntimeConfiguration");
        formatter.field("server_processes", &self.server_processes);
        formatter.field(
            "max_concurrent_game_session_activations",
            &self.max_concurrent_game_session_activations,
        );
        formatter.field(
            "game_session_activation_timeout_seconds",
            &self.game_session_activation_timeout_seconds,
        );
        formatter.finish()
    }
}
/// See [`RuntimeConfiguration`](crate::model::RuntimeConfiguration)
pub mod runtime_configuration {
    /// A builder for [`RuntimeConfiguration`](crate::model::RuntimeConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_processes:
            std::option::Option<std::vec::Vec<crate::model::ServerProcess>>,
        pub(crate) max_concurrent_game_session_activations: std::option::Option<i32>,
        pub(crate) game_session_activation_timeout_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `server_processes`.
        ///
        /// To override the contents of this collection use [`set_server_processes`](Self::set_server_processes).
        ///
        /// <p>A collection of server process configurations that identify what server processes to run on each instance in a fleet.</p>
        pub fn server_processes(mut self, input: crate::model::ServerProcess) -> Self {
            let mut v = self.server_processes.unwrap_or_default();
            v.push(input);
            self.server_processes = Some(v);
            self
        }
        /// <p>A collection of server process configurations that identify what server processes to run on each instance in a fleet.</p>
        pub fn set_server_processes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServerProcess>>,
        ) -> Self {
            self.server_processes = input;
            self
        }
        /// <p>The number of game sessions in status <code>ACTIVATING</code> to allow on an instance. This setting limits the instance resources that can be used for new game activations at any one time.</p>
        pub fn max_concurrent_game_session_activations(mut self, input: i32) -> Self {
            self.max_concurrent_game_session_activations = Some(input);
            self
        }
        /// <p>The number of game sessions in status <code>ACTIVATING</code> to allow on an instance. This setting limits the instance resources that can be used for new game activations at any one time.</p>
        pub fn set_max_concurrent_game_session_activations(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.max_concurrent_game_session_activations = input;
            self
        }
        /// <p>The maximum amount of time (in seconds) allowed to launch a new game session and have it report ready to host players. During this time, the game session is in status <code>ACTIVATING</code>. If the game session does not become active before the timeout, it is ended and the game session status is changed to <code>TERMINATED</code>.</p>
        pub fn game_session_activation_timeout_seconds(mut self, input: i32) -> Self {
            self.game_session_activation_timeout_seconds = Some(input);
            self
        }
        /// <p>The maximum amount of time (in seconds) allowed to launch a new game session and have it report ready to host players. During this time, the game session is in status <code>ACTIVATING</code>. If the game session does not become active before the timeout, it is ended and the game session status is changed to <code>TERMINATED</code>.</p>
        pub fn set_game_session_activation_timeout_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.game_session_activation_timeout_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`RuntimeConfiguration`](crate::model::RuntimeConfiguration)
        pub fn build(self) -> crate::model::RuntimeConfiguration {
            crate::model::RuntimeConfiguration {
                server_processes: self.server_processes,
                max_concurrent_game_session_activations: self
                    .max_concurrent_game_session_activations,
                game_session_activation_timeout_seconds: self
                    .game_session_activation_timeout_seconds,
            }
        }
    }
}
impl RuntimeConfiguration {
    /// Creates a new builder-style object to manufacture [`RuntimeConfiguration`](crate::model::RuntimeConfiguration)
    pub fn builder() -> crate::model::runtime_configuration::Builder {
        crate::model::runtime_configuration::Builder::default()
    }
}

/// <p>A set of instructions for launching server processes on each instance in a fleet. Server processes run either an executable in a custom game build or a Realtime Servers script. Server process configurations are part of a fleet's <code>RuntimeConfiguration</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServerProcess {
    /// <p>The location of a game build executable or the Realtime script file that contains the <code>Init()</code> function. Game builds and Realtime scripts are installed on instances at the root: </p>
    /// <ul>
    /// <li> <p>Windows (custom game builds only): <code>C:\game</code>. Example: "<code>C:\game\MyGame\server.exe</code>" </p> </li>
    /// <li> <p>Linux: <code>/local/game</code>. Examples: "<code>/local/game/MyGame/server.exe</code>" or "<code>/local/game/MyRealtimeScript.js</code>"</p> </li>
    /// </ul>
    pub launch_path: std::option::Option<std::string::String>,
    /// <p>An optional list of parameters to pass to the server executable or Realtime script on launch.</p>
    pub parameters: std::option::Option<std::string::String>,
    /// <p>The number of server processes using this configuration that run concurrently on each instance.</p>
    pub concurrent_executions: std::option::Option<i32>,
}
impl ServerProcess {
    /// <p>The location of a game build executable or the Realtime script file that contains the <code>Init()</code> function. Game builds and Realtime scripts are installed on instances at the root: </p>
    /// <ul>
    /// <li> <p>Windows (custom game builds only): <code>C:\game</code>. Example: "<code>C:\game\MyGame\server.exe</code>" </p> </li>
    /// <li> <p>Linux: <code>/local/game</code>. Examples: "<code>/local/game/MyGame/server.exe</code>" or "<code>/local/game/MyRealtimeScript.js</code>"</p> </li>
    /// </ul>
    pub fn launch_path(&self) -> std::option::Option<&str> {
        self.launch_path.as_deref()
    }
    /// <p>An optional list of parameters to pass to the server executable or Realtime script on launch.</p>
    pub fn parameters(&self) -> std::option::Option<&str> {
        self.parameters.as_deref()
    }
    /// <p>The number of server processes using this configuration that run concurrently on each instance.</p>
    pub fn concurrent_executions(&self) -> std::option::Option<i32> {
        self.concurrent_executions
    }
}
impl std::fmt::Debug for ServerProcess {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServerProcess");
        formatter.field("launch_path", &self.launch_path);
        formatter.field("parameters", &self.parameters);
        formatter.field("concurrent_executions", &self.concurrent_executions);
        formatter.finish()
    }
}
/// See [`ServerProcess`](crate::model::ServerProcess)
pub mod server_process {
    /// A builder for [`ServerProcess`](crate::model::ServerProcess)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) launch_path: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<std::string::String>,
        pub(crate) concurrent_executions: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The location of a game build executable or the Realtime script file that contains the <code>Init()</code> function. Game builds and Realtime scripts are installed on instances at the root: </p>
        /// <ul>
        /// <li> <p>Windows (custom game builds only): <code>C:\game</code>. Example: "<code>C:\game\MyGame\server.exe</code>" </p> </li>
        /// <li> <p>Linux: <code>/local/game</code>. Examples: "<code>/local/game/MyGame/server.exe</code>" or "<code>/local/game/MyRealtimeScript.js</code>"</p> </li>
        /// </ul>
        pub fn launch_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_path = Some(input.into());
            self
        }
        /// <p>The location of a game build executable or the Realtime script file that contains the <code>Init()</code> function. Game builds and Realtime scripts are installed on instances at the root: </p>
        /// <ul>
        /// <li> <p>Windows (custom game builds only): <code>C:\game</code>. Example: "<code>C:\game\MyGame\server.exe</code>" </p> </li>
        /// <li> <p>Linux: <code>/local/game</code>. Examples: "<code>/local/game/MyGame/server.exe</code>" or "<code>/local/game/MyRealtimeScript.js</code>"</p> </li>
        /// </ul>
        pub fn set_launch_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.launch_path = input;
            self
        }
        /// <p>An optional list of parameters to pass to the server executable or Realtime script on launch.</p>
        pub fn parameters(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameters = Some(input.into());
            self
        }
        /// <p>An optional list of parameters to pass to the server executable or Realtime script on launch.</p>
        pub fn set_parameters(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.parameters = input;
            self
        }
        /// <p>The number of server processes using this configuration that run concurrently on each instance.</p>
        pub fn concurrent_executions(mut self, input: i32) -> Self {
            self.concurrent_executions = Some(input);
            self
        }
        /// <p>The number of server processes using this configuration that run concurrently on each instance.</p>
        pub fn set_concurrent_executions(mut self, input: std::option::Option<i32>) -> Self {
            self.concurrent_executions = input;
            self
        }
        /// Consumes the builder and constructs a [`ServerProcess`](crate::model::ServerProcess)
        pub fn build(self) -> crate::model::ServerProcess {
            crate::model::ServerProcess {
                launch_path: self.launch_path,
                parameters: self.parameters,
                concurrent_executions: self.concurrent_executions,
            }
        }
    }
}
impl ServerProcess {
    /// Creates a new builder-style object to manufacture [`ServerProcess`](crate::model::ServerProcess)
    pub fn builder() -> crate::model::server_process::Builder {
        crate::model::server_process::Builder::default()
    }
}

/// <p>Guidelines for use with FlexMatch to match players into games. All matchmaking requests must specify a matchmaking configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MatchmakingConfiguration {
    /// <p>A unique identifier for the matchmaking configuration. This name is used to identify the configuration associated with a matchmaking request or ticket.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift matchmaking configuration resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::matchmakingconfiguration/
    /// <matchmaking configuration name></matchmaking>
    /// </region></code>. In a GameLift configuration ARN, the resource ID matches the <i>Name</i> value.</p>
    pub configuration_arn: std::option::Option<std::string::String>,
    /// <p>A descriptive label that is associated with matchmaking configuration.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift game session queue resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::gamesessionqueue/
    /// <queue name></queue>
    /// </region></code>. Queues can be located in any Region. Queues are used to start new GameLift-hosted game sessions for matches that are created with this matchmaking configuration. This property is not set when <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
    pub game_session_queue_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out. Requests that fail due to timing out can be resubmitted as needed.</p>
    pub request_timeout_seconds: std::option::Option<i32>,
    /// <p>The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required. If any player rejects the match or fails to accept before the timeout, the ticket continues to look for an acceptable match.</p>
    pub acceptance_timeout_seconds: std::option::Option<i32>,
    /// <p>A flag that indicates whether a match that was created with this configuration must be accepted by the matched players. To require acceptance, set to TRUE. When this option is enabled, matchmaking tickets use the status <code>REQUIRES_ACCEPTANCE</code> to indicate when a completed potential match is waiting for player acceptance.</p>
    pub acceptance_required: std::option::Option<bool>,
    /// <p>A unique identifier for the matchmaking rule set to use with this configuration. A matchmaking configuration can only use rule sets that are defined in the same Region.</p>
    pub rule_set_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift matchmaking rule set resource that this configuration uses.</p>
    pub rule_set_arn: std::option::Option<std::string::String>,
    /// <p>An SNS topic ARN that is set up to receive matchmaking notifications.</p>
    pub notification_target: std::option::Option<std::string::String>,
    /// <p>The number of player slots in a match to keep open for future players. For example, if the configuration's rule set specifies a match for a single 12-person team, and the additional player count is set to 2, only 10 players are selected for the match. This parameter is not used when <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
    pub additional_player_count: std::option::Option<i32>,
    /// <p>Information to attach to all events related to the matchmaking configuration. </p>
    pub custom_event_data: std::option::Option<std::string::String>,
    /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). This information is added to the new <code>GameSession</code> object that is created for a successful match. This parameter is not used when <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
    pub game_properties: std::option::Option<std::vec::Vec<crate::model::GameProperty>>,
    /// <p>A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). This information is added to the new <code>GameSession</code> object that is created for a successful match. This parameter is not used when <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
    pub game_session_data: std::option::Option<std::string::String>,
    /// <p>The method used to backfill game sessions created with this matchmaking configuration. MANUAL indicates that the game makes backfill requests or does not use the match backfill feature. AUTOMATIC indicates that GameLift creates <code>StartMatchBackfill</code> requests whenever a game session has one or more open slots. Learn more about manual and automatic backfill in <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html">Backfill existing games with FlexMatch</a>. Automatic backfill is not available when <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
    pub backfill_mode: std::option::Option<crate::model::BackfillMode>,
    /// <p>Indicates whether this matchmaking configuration is being used with GameLift hosting or as a standalone matchmaking solution. </p>
    /// <ul>
    /// <li> <p> <b>STANDALONE</b> - FlexMatch forms matches and returns match information, including players and team assignments, in a <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html#match-events-matchmakingsucceeded"> MatchmakingSucceeded</a> event.</p> </li>
    /// <li> <p> <b>WITH_QUEUE</b> - FlexMatch forms matches and uses the specified GameLift queue to start a game session for the match. </p> </li>
    /// </ul>
    pub flex_match_mode: std::option::Option<crate::model::FlexMatchMode>,
}
impl MatchmakingConfiguration {
    /// <p>A unique identifier for the matchmaking configuration. This name is used to identify the configuration associated with a matchmaking request or ticket.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift matchmaking configuration resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::matchmakingconfiguration/
    /// <matchmaking configuration name></matchmaking>
    /// </region></code>. In a GameLift configuration ARN, the resource ID matches the <i>Name</i> value.</p>
    pub fn configuration_arn(&self) -> std::option::Option<&str> {
        self.configuration_arn.as_deref()
    }
    /// <p>A descriptive label that is associated with matchmaking configuration.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift game session queue resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::gamesessionqueue/
    /// <queue name></queue>
    /// </region></code>. Queues can be located in any Region. Queues are used to start new GameLift-hosted game sessions for matches that are created with this matchmaking configuration. This property is not set when <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
    pub fn game_session_queue_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.game_session_queue_arns.as_deref()
    }
    /// <p>The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out. Requests that fail due to timing out can be resubmitted as needed.</p>
    pub fn request_timeout_seconds(&self) -> std::option::Option<i32> {
        self.request_timeout_seconds
    }
    /// <p>The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required. If any player rejects the match or fails to accept before the timeout, the ticket continues to look for an acceptable match.</p>
    pub fn acceptance_timeout_seconds(&self) -> std::option::Option<i32> {
        self.acceptance_timeout_seconds
    }
    /// <p>A flag that indicates whether a match that was created with this configuration must be accepted by the matched players. To require acceptance, set to TRUE. When this option is enabled, matchmaking tickets use the status <code>REQUIRES_ACCEPTANCE</code> to indicate when a completed potential match is waiting for player acceptance.</p>
    pub fn acceptance_required(&self) -> std::option::Option<bool> {
        self.acceptance_required
    }
    /// <p>A unique identifier for the matchmaking rule set to use with this configuration. A matchmaking configuration can only use rule sets that are defined in the same Region.</p>
    pub fn rule_set_name(&self) -> std::option::Option<&str> {
        self.rule_set_name.as_deref()
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift matchmaking rule set resource that this configuration uses.</p>
    pub fn rule_set_arn(&self) -> std::option::Option<&str> {
        self.rule_set_arn.as_deref()
    }
    /// <p>An SNS topic ARN that is set up to receive matchmaking notifications.</p>
    pub fn notification_target(&self) -> std::option::Option<&str> {
        self.notification_target.as_deref()
    }
    /// <p>The number of player slots in a match to keep open for future players. For example, if the configuration's rule set specifies a match for a single 12-person team, and the additional player count is set to 2, only 10 players are selected for the match. This parameter is not used when <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
    pub fn additional_player_count(&self) -> std::option::Option<i32> {
        self.additional_player_count
    }
    /// <p>Information to attach to all events related to the matchmaking configuration. </p>
    pub fn custom_event_data(&self) -> std::option::Option<&str> {
        self.custom_event_data.as_deref()
    }
    /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). This information is added to the new <code>GameSession</code> object that is created for a successful match. This parameter is not used when <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
    pub fn game_properties(&self) -> std::option::Option<&[crate::model::GameProperty]> {
        self.game_properties.as_deref()
    }
    /// <p>A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). This information is added to the new <code>GameSession</code> object that is created for a successful match. This parameter is not used when <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
    pub fn game_session_data(&self) -> std::option::Option<&str> {
        self.game_session_data.as_deref()
    }
    /// <p>The method used to backfill game sessions created with this matchmaking configuration. MANUAL indicates that the game makes backfill requests or does not use the match backfill feature. AUTOMATIC indicates that GameLift creates <code>StartMatchBackfill</code> requests whenever a game session has one or more open slots. Learn more about manual and automatic backfill in <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html">Backfill existing games with FlexMatch</a>. Automatic backfill is not available when <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
    pub fn backfill_mode(&self) -> std::option::Option<&crate::model::BackfillMode> {
        self.backfill_mode.as_ref()
    }
    /// <p>Indicates whether this matchmaking configuration is being used with GameLift hosting or as a standalone matchmaking solution. </p>
    /// <ul>
    /// <li> <p> <b>STANDALONE</b> - FlexMatch forms matches and returns match information, including players and team assignments, in a <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html#match-events-matchmakingsucceeded"> MatchmakingSucceeded</a> event.</p> </li>
    /// <li> <p> <b>WITH_QUEUE</b> - FlexMatch forms matches and uses the specified GameLift queue to start a game session for the match. </p> </li>
    /// </ul>
    pub fn flex_match_mode(&self) -> std::option::Option<&crate::model::FlexMatchMode> {
        self.flex_match_mode.as_ref()
    }
}
impl std::fmt::Debug for MatchmakingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MatchmakingConfiguration");
        formatter.field("name", &self.name);
        formatter.field("configuration_arn", &self.configuration_arn);
        formatter.field("description", &self.description);
        formatter.field("game_session_queue_arns", &self.game_session_queue_arns);
        formatter.field("request_timeout_seconds", &self.request_timeout_seconds);
        formatter.field(
            "acceptance_timeout_seconds",
            &self.acceptance_timeout_seconds,
        );
        formatter.field("acceptance_required", &self.acceptance_required);
        formatter.field("rule_set_name", &self.rule_set_name);
        formatter.field("rule_set_arn", &self.rule_set_arn);
        formatter.field("notification_target", &self.notification_target);
        formatter.field("additional_player_count", &self.additional_player_count);
        formatter.field("custom_event_data", &self.custom_event_data);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("game_properties", &self.game_properties);
        formatter.field("game_session_data", &self.game_session_data);
        formatter.field("backfill_mode", &self.backfill_mode);
        formatter.field("flex_match_mode", &self.flex_match_mode);
        formatter.finish()
    }
}
/// See [`MatchmakingConfiguration`](crate::model::MatchmakingConfiguration)
pub mod matchmaking_configuration {
    /// A builder for [`MatchmakingConfiguration`](crate::model::MatchmakingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) configuration_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) game_session_queue_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) request_timeout_seconds: std::option::Option<i32>,
        pub(crate) acceptance_timeout_seconds: std::option::Option<i32>,
        pub(crate) acceptance_required: std::option::Option<bool>,
        pub(crate) rule_set_name: std::option::Option<std::string::String>,
        pub(crate) rule_set_arn: std::option::Option<std::string::String>,
        pub(crate) notification_target: std::option::Option<std::string::String>,
        pub(crate) additional_player_count: std::option::Option<i32>,
        pub(crate) custom_event_data: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) game_properties: std::option::Option<std::vec::Vec<crate::model::GameProperty>>,
        pub(crate) game_session_data: std::option::Option<std::string::String>,
        pub(crate) backfill_mode: std::option::Option<crate::model::BackfillMode>,
        pub(crate) flex_match_mode: std::option::Option<crate::model::FlexMatchMode>,
    }
    impl Builder {
        /// <p>A unique identifier for the matchmaking configuration. This name is used to identify the configuration associated with a matchmaking request or ticket.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A unique identifier for the matchmaking configuration. This name is used to identify the configuration associated with a matchmaking request or ticket.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift matchmaking configuration resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::matchmakingconfiguration/
        /// <matchmaking configuration name></matchmaking>
        /// </region></code>. In a GameLift configuration ARN, the resource ID matches the <i>Name</i> value.</p>
        pub fn configuration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift matchmaking configuration resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::matchmakingconfiguration/
        /// <matchmaking configuration name></matchmaking>
        /// </region></code>. In a GameLift configuration ARN, the resource ID matches the <i>Name</i> value.</p>
        pub fn set_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_arn = input;
            self
        }
        /// <p>A descriptive label that is associated with matchmaking configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A descriptive label that is associated with matchmaking configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `game_session_queue_arns`.
        ///
        /// To override the contents of this collection use [`set_game_session_queue_arns`](Self::set_game_session_queue_arns).
        ///
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift game session queue resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::gamesessionqueue/
        /// <queue name></queue>
        /// </region></code>. Queues can be located in any Region. Queues are used to start new GameLift-hosted game sessions for matches that are created with this matchmaking configuration. This property is not set when <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
        pub fn game_session_queue_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.game_session_queue_arns.unwrap_or_default();
            v.push(input.into());
            self.game_session_queue_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift game session queue resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::gamesessionqueue/
        /// <queue name></queue>
        /// </region></code>. Queues can be located in any Region. Queues are used to start new GameLift-hosted game sessions for matches that are created with this matchmaking configuration. This property is not set when <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
        pub fn set_game_session_queue_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.game_session_queue_arns = input;
            self
        }
        /// <p>The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out. Requests that fail due to timing out can be resubmitted as needed.</p>
        pub fn request_timeout_seconds(mut self, input: i32) -> Self {
            self.request_timeout_seconds = Some(input);
            self
        }
        /// <p>The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out. Requests that fail due to timing out can be resubmitted as needed.</p>
        pub fn set_request_timeout_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.request_timeout_seconds = input;
            self
        }
        /// <p>The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required. If any player rejects the match or fails to accept before the timeout, the ticket continues to look for an acceptable match.</p>
        pub fn acceptance_timeout_seconds(mut self, input: i32) -> Self {
            self.acceptance_timeout_seconds = Some(input);
            self
        }
        /// <p>The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required. If any player rejects the match or fails to accept before the timeout, the ticket continues to look for an acceptable match.</p>
        pub fn set_acceptance_timeout_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.acceptance_timeout_seconds = input;
            self
        }
        /// <p>A flag that indicates whether a match that was created with this configuration must be accepted by the matched players. To require acceptance, set to TRUE. When this option is enabled, matchmaking tickets use the status <code>REQUIRES_ACCEPTANCE</code> to indicate when a completed potential match is waiting for player acceptance.</p>
        pub fn acceptance_required(mut self, input: bool) -> Self {
            self.acceptance_required = Some(input);
            self
        }
        /// <p>A flag that indicates whether a match that was created with this configuration must be accepted by the matched players. To require acceptance, set to TRUE. When this option is enabled, matchmaking tickets use the status <code>REQUIRES_ACCEPTANCE</code> to indicate when a completed potential match is waiting for player acceptance.</p>
        pub fn set_acceptance_required(mut self, input: std::option::Option<bool>) -> Self {
            self.acceptance_required = input;
            self
        }
        /// <p>A unique identifier for the matchmaking rule set to use with this configuration. A matchmaking configuration can only use rule sets that are defined in the same Region.</p>
        pub fn rule_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_set_name = Some(input.into());
            self
        }
        /// <p>A unique identifier for the matchmaking rule set to use with this configuration. A matchmaking configuration can only use rule sets that are defined in the same Region.</p>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rule_set_name = input;
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift matchmaking rule set resource that this configuration uses.</p>
        pub fn rule_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_set_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift matchmaking rule set resource that this configuration uses.</p>
        pub fn set_rule_set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_set_arn = input;
            self
        }
        /// <p>An SNS topic ARN that is set up to receive matchmaking notifications.</p>
        pub fn notification_target(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_target = Some(input.into());
            self
        }
        /// <p>An SNS topic ARN that is set up to receive matchmaking notifications.</p>
        pub fn set_notification_target(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_target = input;
            self
        }
        /// <p>The number of player slots in a match to keep open for future players. For example, if the configuration's rule set specifies a match for a single 12-person team, and the additional player count is set to 2, only 10 players are selected for the match. This parameter is not used when <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
        pub fn additional_player_count(mut self, input: i32) -> Self {
            self.additional_player_count = Some(input);
            self
        }
        /// <p>The number of player slots in a match to keep open for future players. For example, if the configuration's rule set specifies a match for a single 12-person team, and the additional player count is set to 2, only 10 players are selected for the match. This parameter is not used when <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
        pub fn set_additional_player_count(mut self, input: std::option::Option<i32>) -> Self {
            self.additional_player_count = input;
            self
        }
        /// <p>Information to attach to all events related to the matchmaking configuration. </p>
        pub fn custom_event_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_event_data = Some(input.into());
            self
        }
        /// <p>Information to attach to all events related to the matchmaking configuration. </p>
        pub fn set_custom_event_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_event_data = input;
            self
        }
        /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Appends an item to `game_properties`.
        ///
        /// To override the contents of this collection use [`set_game_properties`](Self::set_game_properties).
        ///
        /// <p>A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). This information is added to the new <code>GameSession</code> object that is created for a successful match. This parameter is not used when <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
        pub fn game_properties(mut self, input: crate::model::GameProperty) -> Self {
            let mut v = self.game_properties.unwrap_or_default();
            v.push(input);
            self.game_properties = Some(v);
            self
        }
        /// <p>A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). This information is added to the new <code>GameSession</code> object that is created for a successful match. This parameter is not used when <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
        pub fn set_game_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GameProperty>>,
        ) -> Self {
            self.game_properties = input;
            self
        }
        /// <p>A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). This information is added to the new <code>GameSession</code> object that is created for a successful match. This parameter is not used when <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
        pub fn game_session_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_session_data = Some(input.into());
            self
        }
        /// <p>A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). This information is added to the new <code>GameSession</code> object that is created for a successful match. This parameter is not used when <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
        pub fn set_game_session_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_session_data = input;
            self
        }
        /// <p>The method used to backfill game sessions created with this matchmaking configuration. MANUAL indicates that the game makes backfill requests or does not use the match backfill feature. AUTOMATIC indicates that GameLift creates <code>StartMatchBackfill</code> requests whenever a game session has one or more open slots. Learn more about manual and automatic backfill in <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html">Backfill existing games with FlexMatch</a>. Automatic backfill is not available when <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
        pub fn backfill_mode(mut self, input: crate::model::BackfillMode) -> Self {
            self.backfill_mode = Some(input);
            self
        }
        /// <p>The method used to backfill game sessions created with this matchmaking configuration. MANUAL indicates that the game makes backfill requests or does not use the match backfill feature. AUTOMATIC indicates that GameLift creates <code>StartMatchBackfill</code> requests whenever a game session has one or more open slots. Learn more about manual and automatic backfill in <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html">Backfill existing games with FlexMatch</a>. Automatic backfill is not available when <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>
        pub fn set_backfill_mode(
            mut self,
            input: std::option::Option<crate::model::BackfillMode>,
        ) -> Self {
            self.backfill_mode = input;
            self
        }
        /// <p>Indicates whether this matchmaking configuration is being used with GameLift hosting or as a standalone matchmaking solution. </p>
        /// <ul>
        /// <li> <p> <b>STANDALONE</b> - FlexMatch forms matches and returns match information, including players and team assignments, in a <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html#match-events-matchmakingsucceeded"> MatchmakingSucceeded</a> event.</p> </li>
        /// <li> <p> <b>WITH_QUEUE</b> - FlexMatch forms matches and uses the specified GameLift queue to start a game session for the match. </p> </li>
        /// </ul>
        pub fn flex_match_mode(mut self, input: crate::model::FlexMatchMode) -> Self {
            self.flex_match_mode = Some(input);
            self
        }
        /// <p>Indicates whether this matchmaking configuration is being used with GameLift hosting or as a standalone matchmaking solution. </p>
        /// <ul>
        /// <li> <p> <b>STANDALONE</b> - FlexMatch forms matches and returns match information, including players and team assignments, in a <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html#match-events-matchmakingsucceeded"> MatchmakingSucceeded</a> event.</p> </li>
        /// <li> <p> <b>WITH_QUEUE</b> - FlexMatch forms matches and uses the specified GameLift queue to start a game session for the match. </p> </li>
        /// </ul>
        pub fn set_flex_match_mode(
            mut self,
            input: std::option::Option<crate::model::FlexMatchMode>,
        ) -> Self {
            self.flex_match_mode = input;
            self
        }
        /// Consumes the builder and constructs a [`MatchmakingConfiguration`](crate::model::MatchmakingConfiguration)
        pub fn build(self) -> crate::model::MatchmakingConfiguration {
            crate::model::MatchmakingConfiguration {
                name: self.name,
                configuration_arn: self.configuration_arn,
                description: self.description,
                game_session_queue_arns: self.game_session_queue_arns,
                request_timeout_seconds: self.request_timeout_seconds,
                acceptance_timeout_seconds: self.acceptance_timeout_seconds,
                acceptance_required: self.acceptance_required,
                rule_set_name: self.rule_set_name,
                rule_set_arn: self.rule_set_arn,
                notification_target: self.notification_target,
                additional_player_count: self.additional_player_count,
                custom_event_data: self.custom_event_data,
                creation_time: self.creation_time,
                game_properties: self.game_properties,
                game_session_data: self.game_session_data,
                backfill_mode: self.backfill_mode,
                flex_match_mode: self.flex_match_mode,
            }
        }
    }
}
impl MatchmakingConfiguration {
    /// Creates a new builder-style object to manufacture [`MatchmakingConfiguration`](crate::model::MatchmakingConfiguration)
    pub fn builder() -> crate::model::matchmaking_configuration::Builder {
        crate::model::matchmaking_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FlexMatchMode {
    #[allow(missing_docs)] // documentation missing in model
    Standalone,
    #[allow(missing_docs)] // documentation missing in model
    WithQueue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FlexMatchMode {
    fn from(s: &str) -> Self {
        match s {
            "STANDALONE" => FlexMatchMode::Standalone,
            "WITH_QUEUE" => FlexMatchMode::WithQueue,
            other => FlexMatchMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FlexMatchMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FlexMatchMode::from(s))
    }
}
impl FlexMatchMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FlexMatchMode::Standalone => "STANDALONE",
            FlexMatchMode::WithQueue => "WITH_QUEUE",
            FlexMatchMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["STANDALONE", "WITH_QUEUE"]
    }
}
impl AsRef<str> for FlexMatchMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BackfillMode {
    #[allow(missing_docs)] // documentation missing in model
    Automatic,
    #[allow(missing_docs)] // documentation missing in model
    Manual,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BackfillMode {
    fn from(s: &str) -> Self {
        match s {
            "AUTOMATIC" => BackfillMode::Automatic,
            "MANUAL" => BackfillMode::Manual,
            other => BackfillMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BackfillMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BackfillMode::from(s))
    }
}
impl BackfillMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BackfillMode::Automatic => "AUTOMATIC",
            BackfillMode::Manual => "MANUAL",
            BackfillMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTOMATIC", "MANUAL"]
    }
}
impl AsRef<str> for BackfillMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Set of key-value pairs that contain information about a game session. When included in a game session request, these properties communicate details to be used when setting up the new game session. For example, a game property might specify a game mode, level, or map. Game properties are passed to the game server process when initiating a new game session. For more information, see the <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#gamelift-sdk-client-api-create"> GameLift Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GameProperty {
    /// <p>The game property identifier.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The game property value.</p>
    pub value: std::option::Option<std::string::String>,
}
impl GameProperty {
    /// <p>The game property identifier.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The game property value.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for GameProperty {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GameProperty");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`GameProperty`](crate::model::GameProperty)
pub mod game_property {
    /// A builder for [`GameProperty`](crate::model::GameProperty)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The game property identifier.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The game property identifier.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The game property value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The game property value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`GameProperty`](crate::model::GameProperty)
        pub fn build(self) -> crate::model::GameProperty {
            crate::model::GameProperty {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl GameProperty {
    /// Creates a new builder-style object to manufacture [`GameProperty`](crate::model::GameProperty)
    pub fn builder() -> crate::model::game_property::Builder {
        crate::model::game_property::Builder::default()
    }
}

/// <p>Configuration for a game session placement mechanism that processes requests for new game sessions. A queue can be used on its own or as part of a matchmaking solution.</p>
/// <p> <b>Related actions</b> </p>
/// <p> <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateGameSessionQueue.html">CreateGameSessionQueue</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessionQueues.html">DescribeGameSessionQueues</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameSessionQueue.html">UpdateGameSessionQueue</a> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GameSessionQueue {
    /// <p>A descriptive label that is associated with game session queue. Queue names must be unique within each Region.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift game session queue resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::gamesessionqueue/
    /// <queue name></queue>
    /// </region></code>. In a GameLift game session queue ARN, the resource ID matches the <i>Name</i> value.</p>
    pub game_session_queue_arn: std::option::Option<std::string::String>,
    /// <p>The maximum time, in seconds, that a new game session placement request remains in the queue. When a request exceeds this time, the game session placement changes to a <code>TIMED_OUT</code> status.</p>
    pub timeout_in_seconds: std::option::Option<i32>,
    /// <p>A set of policies that act as a sliding cap on player latency. FleetIQ works to deliver low latency for most players in a game session. These policies ensure that no individual player can be placed into a game with unreasonably high latency. Use multiple policies to gradually relax latency requirements a step at a time. Multiple policies are applied based on their maximum allowed latency, starting with the lowest value. </p>
    pub player_latency_policies:
        std::option::Option<std::vec::Vec<crate::model::PlayerLatencyPolicy>>,
    /// <p>A list of fleets and/or fleet aliases that can be used to fulfill game session placement requests in the queue. Destinations are identified by either a fleet ARN or a fleet alias ARN, and are listed in order of placement preference.</p>
    pub destinations: std::option::Option<std::vec::Vec<crate::model::GameSessionQueueDestination>>,
    /// <p>A list of locations where a queue is allowed to place new game sessions. Locations are specified in the form of Amazon Web Services Region codes, such as <code>us-west-2</code>. If this parameter is not set, game sessions can be placed in any queue location. </p>
    pub filter_configuration: std::option::Option<crate::model::FilterConfiguration>,
    /// <p>Custom settings to use when prioritizing destinations and locations for game session placements. This configuration replaces the FleetIQ default prioritization process. Priority types that are not explicitly named will be automatically applied at the end of the prioritization process. </p>
    pub priority_configuration: std::option::Option<crate::model::PriorityConfiguration>,
    /// <p> Information that is added to all events that are related to this game session queue. </p>
    pub custom_event_data: std::option::Option<std::string::String>,
    /// <p>An SNS topic ARN that is set up to receive game session placement notifications. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queue-notification.html"> Setting up notifications for game session placement</a>.</p>
    pub notification_target: std::option::Option<std::string::String>,
}
impl GameSessionQueue {
    /// <p>A descriptive label that is associated with game session queue. Queue names must be unique within each Region.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift game session queue resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::gamesessionqueue/
    /// <queue name></queue>
    /// </region></code>. In a GameLift game session queue ARN, the resource ID matches the <i>Name</i> value.</p>
    pub fn game_session_queue_arn(&self) -> std::option::Option<&str> {
        self.game_session_queue_arn.as_deref()
    }
    /// <p>The maximum time, in seconds, that a new game session placement request remains in the queue. When a request exceeds this time, the game session placement changes to a <code>TIMED_OUT</code> status.</p>
    pub fn timeout_in_seconds(&self) -> std::option::Option<i32> {
        self.timeout_in_seconds
    }
    /// <p>A set of policies that act as a sliding cap on player latency. FleetIQ works to deliver low latency for most players in a game session. These policies ensure that no individual player can be placed into a game with unreasonably high latency. Use multiple policies to gradually relax latency requirements a step at a time. Multiple policies are applied based on their maximum allowed latency, starting with the lowest value. </p>
    pub fn player_latency_policies(
        &self,
    ) -> std::option::Option<&[crate::model::PlayerLatencyPolicy]> {
        self.player_latency_policies.as_deref()
    }
    /// <p>A list of fleets and/or fleet aliases that can be used to fulfill game session placement requests in the queue. Destinations are identified by either a fleet ARN or a fleet alias ARN, and are listed in order of placement preference.</p>
    pub fn destinations(
        &self,
    ) -> std::option::Option<&[crate::model::GameSessionQueueDestination]> {
        self.destinations.as_deref()
    }
    /// <p>A list of locations where a queue is allowed to place new game sessions. Locations are specified in the form of Amazon Web Services Region codes, such as <code>us-west-2</code>. If this parameter is not set, game sessions can be placed in any queue location. </p>
    pub fn filter_configuration(&self) -> std::option::Option<&crate::model::FilterConfiguration> {
        self.filter_configuration.as_ref()
    }
    /// <p>Custom settings to use when prioritizing destinations and locations for game session placements. This configuration replaces the FleetIQ default prioritization process. Priority types that are not explicitly named will be automatically applied at the end of the prioritization process. </p>
    pub fn priority_configuration(
        &self,
    ) -> std::option::Option<&crate::model::PriorityConfiguration> {
        self.priority_configuration.as_ref()
    }
    /// <p> Information that is added to all events that are related to this game session queue. </p>
    pub fn custom_event_data(&self) -> std::option::Option<&str> {
        self.custom_event_data.as_deref()
    }
    /// <p>An SNS topic ARN that is set up to receive game session placement notifications. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queue-notification.html"> Setting up notifications for game session placement</a>.</p>
    pub fn notification_target(&self) -> std::option::Option<&str> {
        self.notification_target.as_deref()
    }
}
impl std::fmt::Debug for GameSessionQueue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GameSessionQueue");
        formatter.field("name", &self.name);
        formatter.field("game_session_queue_arn", &self.game_session_queue_arn);
        formatter.field("timeout_in_seconds", &self.timeout_in_seconds);
        formatter.field("player_latency_policies", &self.player_latency_policies);
        formatter.field("destinations", &self.destinations);
        formatter.field("filter_configuration", &self.filter_configuration);
        formatter.field("priority_configuration", &self.priority_configuration);
        formatter.field("custom_event_data", &self.custom_event_data);
        formatter.field("notification_target", &self.notification_target);
        formatter.finish()
    }
}
/// See [`GameSessionQueue`](crate::model::GameSessionQueue)
pub mod game_session_queue {
    /// A builder for [`GameSessionQueue`](crate::model::GameSessionQueue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) game_session_queue_arn: std::option::Option<std::string::String>,
        pub(crate) timeout_in_seconds: std::option::Option<i32>,
        pub(crate) player_latency_policies:
            std::option::Option<std::vec::Vec<crate::model::PlayerLatencyPolicy>>,
        pub(crate) destinations:
            std::option::Option<std::vec::Vec<crate::model::GameSessionQueueDestination>>,
        pub(crate) filter_configuration: std::option::Option<crate::model::FilterConfiguration>,
        pub(crate) priority_configuration: std::option::Option<crate::model::PriorityConfiguration>,
        pub(crate) custom_event_data: std::option::Option<std::string::String>,
        pub(crate) notification_target: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A descriptive label that is associated with game session queue. Queue names must be unique within each Region.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A descriptive label that is associated with game session queue. Queue names must be unique within each Region.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift game session queue resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::gamesessionqueue/
        /// <queue name></queue>
        /// </region></code>. In a GameLift game session queue ARN, the resource ID matches the <i>Name</i> value.</p>
        pub fn game_session_queue_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_session_queue_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift game session queue resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::gamesessionqueue/
        /// <queue name></queue>
        /// </region></code>. In a GameLift game session queue ARN, the resource ID matches the <i>Name</i> value.</p>
        pub fn set_game_session_queue_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_session_queue_arn = input;
            self
        }
        /// <p>The maximum time, in seconds, that a new game session placement request remains in the queue. When a request exceeds this time, the game session placement changes to a <code>TIMED_OUT</code> status.</p>
        pub fn timeout_in_seconds(mut self, input: i32) -> Self {
            self.timeout_in_seconds = Some(input);
            self
        }
        /// <p>The maximum time, in seconds, that a new game session placement request remains in the queue. When a request exceeds this time, the game session placement changes to a <code>TIMED_OUT</code> status.</p>
        pub fn set_timeout_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_in_seconds = input;
            self
        }
        /// Appends an item to `player_latency_policies`.
        ///
        /// To override the contents of this collection use [`set_player_latency_policies`](Self::set_player_latency_policies).
        ///
        /// <p>A set of policies that act as a sliding cap on player latency. FleetIQ works to deliver low latency for most players in a game session. These policies ensure that no individual player can be placed into a game with unreasonably high latency. Use multiple policies to gradually relax latency requirements a step at a time. Multiple policies are applied based on their maximum allowed latency, starting with the lowest value. </p>
        pub fn player_latency_policies(mut self, input: crate::model::PlayerLatencyPolicy) -> Self {
            let mut v = self.player_latency_policies.unwrap_or_default();
            v.push(input);
            self.player_latency_policies = Some(v);
            self
        }
        /// <p>A set of policies that act as a sliding cap on player latency. FleetIQ works to deliver low latency for most players in a game session. These policies ensure that no individual player can be placed into a game with unreasonably high latency. Use multiple policies to gradually relax latency requirements a step at a time. Multiple policies are applied based on their maximum allowed latency, starting with the lowest value. </p>
        pub fn set_player_latency_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlayerLatencyPolicy>>,
        ) -> Self {
            self.player_latency_policies = input;
            self
        }
        /// Appends an item to `destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// <p>A list of fleets and/or fleet aliases that can be used to fulfill game session placement requests in the queue. Destinations are identified by either a fleet ARN or a fleet alias ARN, and are listed in order of placement preference.</p>
        pub fn destinations(mut self, input: crate::model::GameSessionQueueDestination) -> Self {
            let mut v = self.destinations.unwrap_or_default();
            v.push(input);
            self.destinations = Some(v);
            self
        }
        /// <p>A list of fleets and/or fleet aliases that can be used to fulfill game session placement requests in the queue. Destinations are identified by either a fleet ARN or a fleet alias ARN, and are listed in order of placement preference.</p>
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GameSessionQueueDestination>>,
        ) -> Self {
            self.destinations = input;
            self
        }
        /// <p>A list of locations where a queue is allowed to place new game sessions. Locations are specified in the form of Amazon Web Services Region codes, such as <code>us-west-2</code>. If this parameter is not set, game sessions can be placed in any queue location. </p>
        pub fn filter_configuration(mut self, input: crate::model::FilterConfiguration) -> Self {
            self.filter_configuration = Some(input);
            self
        }
        /// <p>A list of locations where a queue is allowed to place new game sessions. Locations are specified in the form of Amazon Web Services Region codes, such as <code>us-west-2</code>. If this parameter is not set, game sessions can be placed in any queue location. </p>
        pub fn set_filter_configuration(
            mut self,
            input: std::option::Option<crate::model::FilterConfiguration>,
        ) -> Self {
            self.filter_configuration = input;
            self
        }
        /// <p>Custom settings to use when prioritizing destinations and locations for game session placements. This configuration replaces the FleetIQ default prioritization process. Priority types that are not explicitly named will be automatically applied at the end of the prioritization process. </p>
        pub fn priority_configuration(
            mut self,
            input: crate::model::PriorityConfiguration,
        ) -> Self {
            self.priority_configuration = Some(input);
            self
        }
        /// <p>Custom settings to use when prioritizing destinations and locations for game session placements. This configuration replaces the FleetIQ default prioritization process. Priority types that are not explicitly named will be automatically applied at the end of the prioritization process. </p>
        pub fn set_priority_configuration(
            mut self,
            input: std::option::Option<crate::model::PriorityConfiguration>,
        ) -> Self {
            self.priority_configuration = input;
            self
        }
        /// <p> Information that is added to all events that are related to this game session queue. </p>
        pub fn custom_event_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_event_data = Some(input.into());
            self
        }
        /// <p> Information that is added to all events that are related to this game session queue. </p>
        pub fn set_custom_event_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_event_data = input;
            self
        }
        /// <p>An SNS topic ARN that is set up to receive game session placement notifications. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queue-notification.html"> Setting up notifications for game session placement</a>.</p>
        pub fn notification_target(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_target = Some(input.into());
            self
        }
        /// <p>An SNS topic ARN that is set up to receive game session placement notifications. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queue-notification.html"> Setting up notifications for game session placement</a>.</p>
        pub fn set_notification_target(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_target = input;
            self
        }
        /// Consumes the builder and constructs a [`GameSessionQueue`](crate::model::GameSessionQueue)
        pub fn build(self) -> crate::model::GameSessionQueue {
            crate::model::GameSessionQueue {
                name: self.name,
                game_session_queue_arn: self.game_session_queue_arn,
                timeout_in_seconds: self.timeout_in_seconds,
                player_latency_policies: self.player_latency_policies,
                destinations: self.destinations,
                filter_configuration: self.filter_configuration,
                priority_configuration: self.priority_configuration,
                custom_event_data: self.custom_event_data,
                notification_target: self.notification_target,
            }
        }
    }
}
impl GameSessionQueue {
    /// Creates a new builder-style object to manufacture [`GameSessionQueue`](crate::model::GameSessionQueue)
    pub fn builder() -> crate::model::game_session_queue::Builder {
        crate::model::game_session_queue::Builder::default()
    }
}

/// <p>Custom prioritization settings for use by a game session queue when placing new game sessions with available game servers. When defined, this configuration replaces the default FleetIQ prioritization process, which is as follows:</p>
/// <ul>
/// <li> <p>If player latency data is included in a game session request, destinations and locations are prioritized first based on lowest average latency (1), then on lowest hosting cost (2), then on destination list order (3), and finally on location (alphabetical) (4). This approach ensures that the queue's top priority is to place game sessions where average player latency is lowest, and--if latency is the same--where the hosting cost is less, etc.</p> </li>
/// <li> <p>If player latency data is not included, destinations and locations are prioritized first on destination list order (1), and then on location (alphabetical) (2). This approach ensures that the queue's top priority is to place game sessions on the first destination fleet listed. If that fleet has multiple locations, the game session is placed on the first location (when listed alphabetically).</p> </li>
/// </ul>
/// <p>Changing the priority order will affect how game sessions are placed.</p>
/// <p>Priority configurations are part of a <code>GameSessionQueue</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PriorityConfiguration {
    /// <p>The recommended sequence to use when prioritizing where to place new game sessions. Each type can only be listed once.</p>
    /// <ul>
    /// <li> <p> <code>LATENCY</code> -- FleetIQ prioritizes locations where the average player latency (provided in each game session request) is lowest. </p> </li>
    /// <li> <p> <code>COST</code> -- FleetIQ prioritizes destinations with the lowest current hosting costs. Cost is evaluated based on the location, instance type, and fleet type (Spot or On-Demand) for each destination in the queue.</p> </li>
    /// <li> <p> <code>DESTINATION</code> -- FleetIQ prioritizes based on the order that destinations are listed in the queue configuration.</p> </li>
    /// <li> <p> <code>LOCATION</code> -- FleetIQ prioritizes based on the provided order of locations, as defined in <code>LocationOrder</code>. </p> </li>
    /// </ul>
    pub priority_order: std::option::Option<std::vec::Vec<crate::model::PriorityType>>,
    /// <p>The prioritization order to use for fleet locations, when the <code>PriorityOrder</code> property includes <code>LOCATION</code>. Locations are identified by Amazon Web Services Region codes such as <code>us-west-2</code>. Each location can only be listed once. </p>
    pub location_order: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl PriorityConfiguration {
    /// <p>The recommended sequence to use when prioritizing where to place new game sessions. Each type can only be listed once.</p>
    /// <ul>
    /// <li> <p> <code>LATENCY</code> -- FleetIQ prioritizes locations where the average player latency (provided in each game session request) is lowest. </p> </li>
    /// <li> <p> <code>COST</code> -- FleetIQ prioritizes destinations with the lowest current hosting costs. Cost is evaluated based on the location, instance type, and fleet type (Spot or On-Demand) for each destination in the queue.</p> </li>
    /// <li> <p> <code>DESTINATION</code> -- FleetIQ prioritizes based on the order that destinations are listed in the queue configuration.</p> </li>
    /// <li> <p> <code>LOCATION</code> -- FleetIQ prioritizes based on the provided order of locations, as defined in <code>LocationOrder</code>. </p> </li>
    /// </ul>
    pub fn priority_order(&self) -> std::option::Option<&[crate::model::PriorityType]> {
        self.priority_order.as_deref()
    }
    /// <p>The prioritization order to use for fleet locations, when the <code>PriorityOrder</code> property includes <code>LOCATION</code>. Locations are identified by Amazon Web Services Region codes such as <code>us-west-2</code>. Each location can only be listed once. </p>
    pub fn location_order(&self) -> std::option::Option<&[std::string::String]> {
        self.location_order.as_deref()
    }
}
impl std::fmt::Debug for PriorityConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PriorityConfiguration");
        formatter.field("priority_order", &self.priority_order);
        formatter.field("location_order", &self.location_order);
        formatter.finish()
    }
}
/// See [`PriorityConfiguration`](crate::model::PriorityConfiguration)
pub mod priority_configuration {
    /// A builder for [`PriorityConfiguration`](crate::model::PriorityConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) priority_order: std::option::Option<std::vec::Vec<crate::model::PriorityType>>,
        pub(crate) location_order: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `priority_order`.
        ///
        /// To override the contents of this collection use [`set_priority_order`](Self::set_priority_order).
        ///
        /// <p>The recommended sequence to use when prioritizing where to place new game sessions. Each type can only be listed once.</p>
        /// <ul>
        /// <li> <p> <code>LATENCY</code> -- FleetIQ prioritizes locations where the average player latency (provided in each game session request) is lowest. </p> </li>
        /// <li> <p> <code>COST</code> -- FleetIQ prioritizes destinations with the lowest current hosting costs. Cost is evaluated based on the location, instance type, and fleet type (Spot or On-Demand) for each destination in the queue.</p> </li>
        /// <li> <p> <code>DESTINATION</code> -- FleetIQ prioritizes based on the order that destinations are listed in the queue configuration.</p> </li>
        /// <li> <p> <code>LOCATION</code> -- FleetIQ prioritizes based on the provided order of locations, as defined in <code>LocationOrder</code>. </p> </li>
        /// </ul>
        pub fn priority_order(mut self, input: crate::model::PriorityType) -> Self {
            let mut v = self.priority_order.unwrap_or_default();
            v.push(input);
            self.priority_order = Some(v);
            self
        }
        /// <p>The recommended sequence to use when prioritizing where to place new game sessions. Each type can only be listed once.</p>
        /// <ul>
        /// <li> <p> <code>LATENCY</code> -- FleetIQ prioritizes locations where the average player latency (provided in each game session request) is lowest. </p> </li>
        /// <li> <p> <code>COST</code> -- FleetIQ prioritizes destinations with the lowest current hosting costs. Cost is evaluated based on the location, instance type, and fleet type (Spot or On-Demand) for each destination in the queue.</p> </li>
        /// <li> <p> <code>DESTINATION</code> -- FleetIQ prioritizes based on the order that destinations are listed in the queue configuration.</p> </li>
        /// <li> <p> <code>LOCATION</code> -- FleetIQ prioritizes based on the provided order of locations, as defined in <code>LocationOrder</code>. </p> </li>
        /// </ul>
        pub fn set_priority_order(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PriorityType>>,
        ) -> Self {
            self.priority_order = input;
            self
        }
        /// Appends an item to `location_order`.
        ///
        /// To override the contents of this collection use [`set_location_order`](Self::set_location_order).
        ///
        /// <p>The prioritization order to use for fleet locations, when the <code>PriorityOrder</code> property includes <code>LOCATION</code>. Locations are identified by Amazon Web Services Region codes such as <code>us-west-2</code>. Each location can only be listed once. </p>
        pub fn location_order(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.location_order.unwrap_or_default();
            v.push(input.into());
            self.location_order = Some(v);
            self
        }
        /// <p>The prioritization order to use for fleet locations, when the <code>PriorityOrder</code> property includes <code>LOCATION</code>. Locations are identified by Amazon Web Services Region codes such as <code>us-west-2</code>. Each location can only be listed once. </p>
        pub fn set_location_order(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.location_order = input;
            self
        }
        /// Consumes the builder and constructs a [`PriorityConfiguration`](crate::model::PriorityConfiguration)
        pub fn build(self) -> crate::model::PriorityConfiguration {
            crate::model::PriorityConfiguration {
                priority_order: self.priority_order,
                location_order: self.location_order,
            }
        }
    }
}
impl PriorityConfiguration {
    /// Creates a new builder-style object to manufacture [`PriorityConfiguration`](crate::model::PriorityConfiguration)
    pub fn builder() -> crate::model::priority_configuration::Builder {
        crate::model::priority_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PriorityType {
    #[allow(missing_docs)] // documentation missing in model
    Cost,
    #[allow(missing_docs)] // documentation missing in model
    Destination,
    #[allow(missing_docs)] // documentation missing in model
    Latency,
    #[allow(missing_docs)] // documentation missing in model
    Location,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PriorityType {
    fn from(s: &str) -> Self {
        match s {
            "COST" => PriorityType::Cost,
            "DESTINATION" => PriorityType::Destination,
            "LATENCY" => PriorityType::Latency,
            "LOCATION" => PriorityType::Location,
            other => PriorityType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PriorityType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PriorityType::from(s))
    }
}
impl PriorityType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PriorityType::Cost => "COST",
            PriorityType::Destination => "DESTINATION",
            PriorityType::Latency => "LATENCY",
            PriorityType::Location => "LOCATION",
            PriorityType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COST", "DESTINATION", "LATENCY", "LOCATION"]
    }
}
impl AsRef<str> for PriorityType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A list of fleet locations where a game session queue can place new game sessions. You can use a filter to temporarily turn off placements for specific locations. For queues that have multi-location fleets, you can use a filter configuration allow placement with some, but not all of these locations.</p>
/// <p>Filter configurations are part of a <code>GameSessionQueue</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FilterConfiguration {
    /// <p> A list of locations to allow game session placement in, in the form of Amazon Web Services Region codes such as <code>us-west-2</code>. </p>
    pub allowed_locations: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl FilterConfiguration {
    /// <p> A list of locations to allow game session placement in, in the form of Amazon Web Services Region codes such as <code>us-west-2</code>. </p>
    pub fn allowed_locations(&self) -> std::option::Option<&[std::string::String]> {
        self.allowed_locations.as_deref()
    }
}
impl std::fmt::Debug for FilterConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FilterConfiguration");
        formatter.field("allowed_locations", &self.allowed_locations);
        formatter.finish()
    }
}
/// See [`FilterConfiguration`](crate::model::FilterConfiguration)
pub mod filter_configuration {
    /// A builder for [`FilterConfiguration`](crate::model::FilterConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) allowed_locations: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `allowed_locations`.
        ///
        /// To override the contents of this collection use [`set_allowed_locations`](Self::set_allowed_locations).
        ///
        /// <p> A list of locations to allow game session placement in, in the form of Amazon Web Services Region codes such as <code>us-west-2</code>. </p>
        pub fn allowed_locations(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.allowed_locations.unwrap_or_default();
            v.push(input.into());
            self.allowed_locations = Some(v);
            self
        }
        /// <p> A list of locations to allow game session placement in, in the form of Amazon Web Services Region codes such as <code>us-west-2</code>. </p>
        pub fn set_allowed_locations(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.allowed_locations = input;
            self
        }
        /// Consumes the builder and constructs a [`FilterConfiguration`](crate::model::FilterConfiguration)
        pub fn build(self) -> crate::model::FilterConfiguration {
            crate::model::FilterConfiguration {
                allowed_locations: self.allowed_locations,
            }
        }
    }
}
impl FilterConfiguration {
    /// Creates a new builder-style object to manufacture [`FilterConfiguration`](crate::model::FilterConfiguration)
    pub fn builder() -> crate::model::filter_configuration::Builder {
        crate::model::filter_configuration::Builder::default()
    }
}

/// <p>A fleet or alias designated in a game session queue. Queues fulfill requests for new game sessions by placing a new game session on any of the queue's destinations. </p>
/// <p>Destinations are part of a <code>GameSessionQueue</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GameSessionQueueDestination {
    /// <p>The Amazon Resource Name (ARN) that is assigned to fleet or fleet alias. ARNs, which include a fleet ID or alias ID and a Region name, provide a unique identifier across all Regions. </p>
    pub destination_arn: std::option::Option<std::string::String>,
}
impl GameSessionQueueDestination {
    /// <p>The Amazon Resource Name (ARN) that is assigned to fleet or fleet alias. ARNs, which include a fleet ID or alias ID and a Region name, provide a unique identifier across all Regions. </p>
    pub fn destination_arn(&self) -> std::option::Option<&str> {
        self.destination_arn.as_deref()
    }
}
impl std::fmt::Debug for GameSessionQueueDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GameSessionQueueDestination");
        formatter.field("destination_arn", &self.destination_arn);
        formatter.finish()
    }
}
/// See [`GameSessionQueueDestination`](crate::model::GameSessionQueueDestination)
pub mod game_session_queue_destination {
    /// A builder for [`GameSessionQueueDestination`](crate::model::GameSessionQueueDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that is assigned to fleet or fleet alias. ARNs, which include a fleet ID or alias ID and a Region name, provide a unique identifier across all Regions. </p>
        pub fn destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that is assigned to fleet or fleet alias. ARNs, which include a fleet ID or alias ID and a Region name, provide a unique identifier across all Regions. </p>
        pub fn set_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GameSessionQueueDestination`](crate::model::GameSessionQueueDestination)
        pub fn build(self) -> crate::model::GameSessionQueueDestination {
            crate::model::GameSessionQueueDestination {
                destination_arn: self.destination_arn,
            }
        }
    }
}
impl GameSessionQueueDestination {
    /// Creates a new builder-style object to manufacture [`GameSessionQueueDestination`](crate::model::GameSessionQueueDestination)
    pub fn builder() -> crate::model::game_session_queue_destination::Builder {
        crate::model::game_session_queue_destination::Builder::default()
    }
}

/// <p>Sets a latency cap for individual players when placing a game session. With a latency policy in force, a game session cannot be placed in a fleet location where a player reports latency higher than the cap. Latency policies are used only with placement request that provide player latency information. Player latency policies can be stacked to gradually relax latency requirements over time. </p>
/// <p>Latency policies are part of a <code>GameSessionQueue</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PlayerLatencyPolicy {
    /// <p>The maximum latency value that is allowed for any player, in milliseconds. All policies must have a value set for this property.</p>
    pub maximum_individual_player_latency_milliseconds: std::option::Option<i32>,
    /// <p>The length of time, in seconds, that the policy is enforced while placing a new game session. A null value for this property means that the policy is enforced until the queue times out.</p>
    pub policy_duration_seconds: std::option::Option<i32>,
}
impl PlayerLatencyPolicy {
    /// <p>The maximum latency value that is allowed for any player, in milliseconds. All policies must have a value set for this property.</p>
    pub fn maximum_individual_player_latency_milliseconds(&self) -> std::option::Option<i32> {
        self.maximum_individual_player_latency_milliseconds
    }
    /// <p>The length of time, in seconds, that the policy is enforced while placing a new game session. A null value for this property means that the policy is enforced until the queue times out.</p>
    pub fn policy_duration_seconds(&self) -> std::option::Option<i32> {
        self.policy_duration_seconds
    }
}
impl std::fmt::Debug for PlayerLatencyPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PlayerLatencyPolicy");
        formatter.field(
            "maximum_individual_player_latency_milliseconds",
            &self.maximum_individual_player_latency_milliseconds,
        );
        formatter.field("policy_duration_seconds", &self.policy_duration_seconds);
        formatter.finish()
    }
}
/// See [`PlayerLatencyPolicy`](crate::model::PlayerLatencyPolicy)
pub mod player_latency_policy {
    /// A builder for [`PlayerLatencyPolicy`](crate::model::PlayerLatencyPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) maximum_individual_player_latency_milliseconds: std::option::Option<i32>,
        pub(crate) policy_duration_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The maximum latency value that is allowed for any player, in milliseconds. All policies must have a value set for this property.</p>
        pub fn maximum_individual_player_latency_milliseconds(mut self, input: i32) -> Self {
            self.maximum_individual_player_latency_milliseconds = Some(input);
            self
        }
        /// <p>The maximum latency value that is allowed for any player, in milliseconds. All policies must have a value set for this property.</p>
        pub fn set_maximum_individual_player_latency_milliseconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.maximum_individual_player_latency_milliseconds = input;
            self
        }
        /// <p>The length of time, in seconds, that the policy is enforced while placing a new game session. A null value for this property means that the policy is enforced until the queue times out.</p>
        pub fn policy_duration_seconds(mut self, input: i32) -> Self {
            self.policy_duration_seconds = Some(input);
            self
        }
        /// <p>The length of time, in seconds, that the policy is enforced while placing a new game session. A null value for this property means that the policy is enforced until the queue times out.</p>
        pub fn set_policy_duration_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.policy_duration_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`PlayerLatencyPolicy`](crate::model::PlayerLatencyPolicy)
        pub fn build(self) -> crate::model::PlayerLatencyPolicy {
            crate::model::PlayerLatencyPolicy {
                maximum_individual_player_latency_milliseconds: self
                    .maximum_individual_player_latency_milliseconds,
                policy_duration_seconds: self.policy_duration_seconds,
            }
        }
    }
}
impl PlayerLatencyPolicy {
    /// Creates a new builder-style object to manufacture [`PlayerLatencyPolicy`](crate::model::PlayerLatencyPolicy)
    pub fn builder() -> crate::model::player_latency_policy::Builder {
        crate::model::player_latency_policy::Builder::default()
    }
}

/// <p>Properties describing a game session.</p>
/// <p>A game session in ACTIVE status can host players. When a game session ends, its status is set to <code>TERMINATED</code>. </p>
/// <p>Once the session ends, the game session object is retained for 30 days. This means you can reuse idempotency token values after this time. Game session logs are retained for 14 days.</p>
/// <p> <b>Related actions</b> </p>
/// <p> <code>CreateGameSession</code> | <code>DescribeGameSessions</code> | <code>DescribeGameSessionDetails</code> | <code>SearchGameSessions</code> | <code>UpdateGameSession</code> | <code>GetGameSessionLogUrl</code> | <code>StartGameSessionPlacement</code> | <code>DescribeGameSessionPlacement</code> | <code>StopGameSessionPlacement</code> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GameSession {
    /// <p>A unique identifier for the game session. A game session ARN has the following format: <code>arn:aws:gamelift:
    /// <region>
    /// ::gamesession/
    /// <fleet id>
    /// /
    /// <custom id string or idempotency token></custom>
    /// </fleet>
    /// </region></code>.</p>
    pub game_session_id: std::option::Option<std::string::String>,
    /// <p>A descriptive label that is associated with a game session. Session names do not need to be unique.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the fleet that the game session is running on.</p>
    pub fleet_id: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift fleet that this game session is running on. </p>
    pub fleet_arn: std::option::Option<std::string::String>,
    /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A time stamp indicating when this data object was terminated. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub termination_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Number of players currently in the game session.</p>
    pub current_player_session_count: std::option::Option<i32>,
    /// <p>The maximum number of players that can be connected simultaneously to the game session.</p>
    pub maximum_player_session_count: std::option::Option<i32>,
    /// <p>Current status of the game session. A game session must have an <code>ACTIVE</code> status to have player sessions.</p>
    pub status: std::option::Option<crate::model::GameSessionStatus>,
    /// <p>Provides additional information about game session status. <code>INTERRUPTED</code> indicates that the game session was hosted on a spot instance that was reclaimed, causing the active game session to be terminated.</p>
    pub status_reason: std::option::Option<crate::model::GameSessionStatusReason>,
    /// <p>A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). You can search for active game sessions based on this custom data with <code>SearchGameSessions</code>.</p>
    pub game_properties: std::option::Option<std::vec::Vec<crate::model::GameProperty>>,
    /// <p>The IP address of the game session. To connect to a GameLift game server, an app needs both the IP address and port number.</p>
    pub ip_address: std::option::Option<std::string::String>,
    /// <p>The DNS identifier assigned to the instance that is running the game session. Values have the following format:</p>
    /// <ul>
    /// <li> <p>TLS-enabled fleets: <code>
    /// <unique identifier>
    /// .
    /// <region identifier>
    /// .amazongamelift.com
    /// </region>
    /// </unique></code>.</p> </li>
    /// <li> <p>Non-TLS-enabled fleets: <code>ec2-
    /// <unique identifier>
    /// .compute.amazonaws.com
    /// </unique></code>. (See <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses">Amazon EC2 Instance IP Addressing</a>.)</p> </li>
    /// </ul>
    /// <p>When connecting to a game session that is running on a TLS-enabled fleet, you must use the DNS name, not the IP address.</p>
    pub dns_name: std::option::Option<std::string::String>,
    /// <p>The port number for the game session. To connect to a GameLift game server, an app needs both the IP address and port number.</p>
    pub port: std::option::Option<i32>,
    /// <p>Indicates whether or not the game session is accepting new players.</p>
    pub player_session_creation_policy:
        std::option::Option<crate::model::PlayerSessionCreationPolicy>,
    /// <p>A unique identifier for a player. This ID is used to enforce a resource protection policy (if one exists), that limits the number of game sessions a player can create.</p>
    pub creator_id: std::option::Option<std::string::String>,
    /// <p>A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>).</p>
    pub game_session_data: std::option::Option<std::string::String>,
    /// <p>Information about the matchmaking process that was used to create the game session. It is in JSON syntax, formatted as a string. In addition the matchmaking configuration used, it contains data on all players assigned to the match, including player attributes and team assignments. For more details on matchmaker data, see <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-server.html#match-server-data">Match Data</a>. Matchmaker data is useful when requesting match backfills, and is updated whenever new players are added during a successful backfill (see <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartMatchBackfill.html">StartMatchBackfill</a>). </p>
    pub matchmaker_data: std::option::Option<std::string::String>,
    /// <p>The fleet location where the game session is running. This value might specify the fleet's home Region or a remote location. Location is expressed as an Amazon Web Services Region code such as <code>us-west-2</code>. </p>
    pub location: std::option::Option<std::string::String>,
}
impl GameSession {
    /// <p>A unique identifier for the game session. A game session ARN has the following format: <code>arn:aws:gamelift:
    /// <region>
    /// ::gamesession/
    /// <fleet id>
    /// /
    /// <custom id string or idempotency token></custom>
    /// </fleet>
    /// </region></code>.</p>
    pub fn game_session_id(&self) -> std::option::Option<&str> {
        self.game_session_id.as_deref()
    }
    /// <p>A descriptive label that is associated with a game session. Session names do not need to be unique.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A unique identifier for the fleet that the game session is running on.</p>
    pub fn fleet_id(&self) -> std::option::Option<&str> {
        self.fleet_id.as_deref()
    }
    /// <p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift fleet that this game session is running on. </p>
    pub fn fleet_arn(&self) -> std::option::Option<&str> {
        self.fleet_arn.as_deref()
    }
    /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>A time stamp indicating when this data object was terminated. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub fn termination_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.termination_time.as_ref()
    }
    /// <p>Number of players currently in the game session.</p>
    pub fn current_player_session_count(&self) -> std::option::Option<i32> {
        self.current_player_session_count
    }
    /// <p>The maximum number of players that can be connected simultaneously to the game session.</p>
    pub fn maximum_player_session_count(&self) -> std::option::Option<i32> {
        self.maximum_player_session_count
    }
    /// <p>Current status of the game session. A game session must have an <code>ACTIVE</code> status to have player sessions.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::GameSessionStatus> {
        self.status.as_ref()
    }
    /// <p>Provides additional information about game session status. <code>INTERRUPTED</code> indicates that the game session was hosted on a spot instance that was reclaimed, causing the active game session to be terminated.</p>
    pub fn status_reason(&self) -> std::option::Option<&crate::model::GameSessionStatusReason> {
        self.status_reason.as_ref()
    }
    /// <p>A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). You can search for active game sessions based on this custom data with <code>SearchGameSessions</code>.</p>
    pub fn game_properties(&self) -> std::option::Option<&[crate::model::GameProperty]> {
        self.game_properties.as_deref()
    }
    /// <p>The IP address of the game session. To connect to a GameLift game server, an app needs both the IP address and port number.</p>
    pub fn ip_address(&self) -> std::option::Option<&str> {
        self.ip_address.as_deref()
    }
    /// <p>The DNS identifier assigned to the instance that is running the game session. Values have the following format:</p>
    /// <ul>
    /// <li> <p>TLS-enabled fleets: <code>
    /// <unique identifier>
    /// .
    /// <region identifier>
    /// .amazongamelift.com
    /// </region>
    /// </unique></code>.</p> </li>
    /// <li> <p>Non-TLS-enabled fleets: <code>ec2-
    /// <unique identifier>
    /// .compute.amazonaws.com
    /// </unique></code>. (See <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses">Amazon EC2 Instance IP Addressing</a>.)</p> </li>
    /// </ul>
    /// <p>When connecting to a game session that is running on a TLS-enabled fleet, you must use the DNS name, not the IP address.</p>
    pub fn dns_name(&self) -> std::option::Option<&str> {
        self.dns_name.as_deref()
    }
    /// <p>The port number for the game session. To connect to a GameLift game server, an app needs both the IP address and port number.</p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
    /// <p>Indicates whether or not the game session is accepting new players.</p>
    pub fn player_session_creation_policy(
        &self,
    ) -> std::option::Option<&crate::model::PlayerSessionCreationPolicy> {
        self.player_session_creation_policy.as_ref()
    }
    /// <p>A unique identifier for a player. This ID is used to enforce a resource protection policy (if one exists), that limits the number of game sessions a player can create.</p>
    pub fn creator_id(&self) -> std::option::Option<&str> {
        self.creator_id.as_deref()
    }
    /// <p>A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>).</p>
    pub fn game_session_data(&self) -> std::option::Option<&str> {
        self.game_session_data.as_deref()
    }
    /// <p>Information about the matchmaking process that was used to create the game session. It is in JSON syntax, formatted as a string. In addition the matchmaking configuration used, it contains data on all players assigned to the match, including player attributes and team assignments. For more details on matchmaker data, see <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-server.html#match-server-data">Match Data</a>. Matchmaker data is useful when requesting match backfills, and is updated whenever new players are added during a successful backfill (see <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartMatchBackfill.html">StartMatchBackfill</a>). </p>
    pub fn matchmaker_data(&self) -> std::option::Option<&str> {
        self.matchmaker_data.as_deref()
    }
    /// <p>The fleet location where the game session is running. This value might specify the fleet's home Region or a remote location. Location is expressed as an Amazon Web Services Region code such as <code>us-west-2</code>. </p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
}
impl std::fmt::Debug for GameSession {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GameSession");
        formatter.field("game_session_id", &self.game_session_id);
        formatter.field("name", &self.name);
        formatter.field("fleet_id", &self.fleet_id);
        formatter.field("fleet_arn", &self.fleet_arn);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("termination_time", &self.termination_time);
        formatter.field(
            "current_player_session_count",
            &self.current_player_session_count,
        );
        formatter.field(
            "maximum_player_session_count",
            &self.maximum_player_session_count,
        );
        formatter.field("status", &self.status);
        formatter.field("status_reason", &self.status_reason);
        formatter.field("game_properties", &self.game_properties);
        formatter.field("ip_address", &self.ip_address);
        formatter.field("dns_name", &self.dns_name);
        formatter.field("port", &self.port);
        formatter.field(
            "player_session_creation_policy",
            &self.player_session_creation_policy,
        );
        formatter.field("creator_id", &self.creator_id);
        formatter.field("game_session_data", &self.game_session_data);
        formatter.field("matchmaker_data", &self.matchmaker_data);
        formatter.field("location", &self.location);
        formatter.finish()
    }
}
/// See [`GameSession`](crate::model::GameSession)
pub mod game_session {
    /// A builder for [`GameSession`](crate::model::GameSession)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_session_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) fleet_arn: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) termination_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) current_player_session_count: std::option::Option<i32>,
        pub(crate) maximum_player_session_count: std::option::Option<i32>,
        pub(crate) status: std::option::Option<crate::model::GameSessionStatus>,
        pub(crate) status_reason: std::option::Option<crate::model::GameSessionStatusReason>,
        pub(crate) game_properties: std::option::Option<std::vec::Vec<crate::model::GameProperty>>,
        pub(crate) ip_address: std::option::Option<std::string::String>,
        pub(crate) dns_name: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) player_session_creation_policy:
            std::option::Option<crate::model::PlayerSessionCreationPolicy>,
        pub(crate) creator_id: std::option::Option<std::string::String>,
        pub(crate) game_session_data: std::option::Option<std::string::String>,
        pub(crate) matchmaker_data: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the game session. A game session ARN has the following format: <code>arn:aws:gamelift:
        /// <region>
        /// ::gamesession/
        /// <fleet id>
        /// /
        /// <custom id string or idempotency token></custom>
        /// </fleet>
        /// </region></code>.</p>
        pub fn game_session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_session_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the game session. A game session ARN has the following format: <code>arn:aws:gamelift:
        /// <region>
        /// ::gamesession/
        /// <fleet id>
        /// /
        /// <custom id string or idempotency token></custom>
        /// </fleet>
        /// </region></code>.</p>
        pub fn set_game_session_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_session_id = input;
            self
        }
        /// <p>A descriptive label that is associated with a game session. Session names do not need to be unique.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A descriptive label that is associated with a game session. Session names do not need to be unique.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A unique identifier for the fleet that the game session is running on.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet that the game session is running on.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift fleet that this game session is running on. </p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift fleet that this game session is running on. </p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_arn = input;
            self
        }
        /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>A time stamp indicating when this data object was terminated. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn termination_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.termination_time = Some(input);
            self
        }
        /// <p>A time stamp indicating when this data object was terminated. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn set_termination_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.termination_time = input;
            self
        }
        /// <p>Number of players currently in the game session.</p>
        pub fn current_player_session_count(mut self, input: i32) -> Self {
            self.current_player_session_count = Some(input);
            self
        }
        /// <p>Number of players currently in the game session.</p>
        pub fn set_current_player_session_count(mut self, input: std::option::Option<i32>) -> Self {
            self.current_player_session_count = input;
            self
        }
        /// <p>The maximum number of players that can be connected simultaneously to the game session.</p>
        pub fn maximum_player_session_count(mut self, input: i32) -> Self {
            self.maximum_player_session_count = Some(input);
            self
        }
        /// <p>The maximum number of players that can be connected simultaneously to the game session.</p>
        pub fn set_maximum_player_session_count(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_player_session_count = input;
            self
        }
        /// <p>Current status of the game session. A game session must have an <code>ACTIVE</code> status to have player sessions.</p>
        pub fn status(mut self, input: crate::model::GameSessionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Current status of the game session. A game session must have an <code>ACTIVE</code> status to have player sessions.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::GameSessionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Provides additional information about game session status. <code>INTERRUPTED</code> indicates that the game session was hosted on a spot instance that was reclaimed, causing the active game session to be terminated.</p>
        pub fn status_reason(mut self, input: crate::model::GameSessionStatusReason) -> Self {
            self.status_reason = Some(input);
            self
        }
        /// <p>Provides additional information about game session status. <code>INTERRUPTED</code> indicates that the game session was hosted on a spot instance that was reclaimed, causing the active game session to be terminated.</p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<crate::model::GameSessionStatusReason>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// Appends an item to `game_properties`.
        ///
        /// To override the contents of this collection use [`set_game_properties`](Self::set_game_properties).
        ///
        /// <p>A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). You can search for active game sessions based on this custom data with <code>SearchGameSessions</code>.</p>
        pub fn game_properties(mut self, input: crate::model::GameProperty) -> Self {
            let mut v = self.game_properties.unwrap_or_default();
            v.push(input);
            self.game_properties = Some(v);
            self
        }
        /// <p>A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). You can search for active game sessions based on this custom data with <code>SearchGameSessions</code>.</p>
        pub fn set_game_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GameProperty>>,
        ) -> Self {
            self.game_properties = input;
            self
        }
        /// <p>The IP address of the game session. To connect to a GameLift game server, an app needs both the IP address and port number.</p>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address = Some(input.into());
            self
        }
        /// <p>The IP address of the game session. To connect to a GameLift game server, an app needs both the IP address and port number.</p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_address = input;
            self
        }
        /// <p>The DNS identifier assigned to the instance that is running the game session. Values have the following format:</p>
        /// <ul>
        /// <li> <p>TLS-enabled fleets: <code>
        /// <unique identifier>
        /// .
        /// <region identifier>
        /// .amazongamelift.com
        /// </region>
        /// </unique></code>.</p> </li>
        /// <li> <p>Non-TLS-enabled fleets: <code>ec2-
        /// <unique identifier>
        /// .compute.amazonaws.com
        /// </unique></code>. (See <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses">Amazon EC2 Instance IP Addressing</a>.)</p> </li>
        /// </ul>
        /// <p>When connecting to a game session that is running on a TLS-enabled fleet, you must use the DNS name, not the IP address.</p>
        pub fn dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dns_name = Some(input.into());
            self
        }
        /// <p>The DNS identifier assigned to the instance that is running the game session. Values have the following format:</p>
        /// <ul>
        /// <li> <p>TLS-enabled fleets: <code>
        /// <unique identifier>
        /// .
        /// <region identifier>
        /// .amazongamelift.com
        /// </region>
        /// </unique></code>.</p> </li>
        /// <li> <p>Non-TLS-enabled fleets: <code>ec2-
        /// <unique identifier>
        /// .compute.amazonaws.com
        /// </unique></code>. (See <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses">Amazon EC2 Instance IP Addressing</a>.)</p> </li>
        /// </ul>
        /// <p>When connecting to a game session that is running on a TLS-enabled fleet, you must use the DNS name, not the IP address.</p>
        pub fn set_dns_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dns_name = input;
            self
        }
        /// <p>The port number for the game session. To connect to a GameLift game server, an app needs both the IP address and port number.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port number for the game session. To connect to a GameLift game server, an app needs both the IP address and port number.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>Indicates whether or not the game session is accepting new players.</p>
        pub fn player_session_creation_policy(
            mut self,
            input: crate::model::PlayerSessionCreationPolicy,
        ) -> Self {
            self.player_session_creation_policy = Some(input);
            self
        }
        /// <p>Indicates whether or not the game session is accepting new players.</p>
        pub fn set_player_session_creation_policy(
            mut self,
            input: std::option::Option<crate::model::PlayerSessionCreationPolicy>,
        ) -> Self {
            self.player_session_creation_policy = input;
            self
        }
        /// <p>A unique identifier for a player. This ID is used to enforce a resource protection policy (if one exists), that limits the number of game sessions a player can create.</p>
        pub fn creator_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a player. This ID is used to enforce a resource protection policy (if one exists), that limits the number of game sessions a player can create.</p>
        pub fn set_creator_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.creator_id = input;
            self
        }
        /// <p>A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>).</p>
        pub fn game_session_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_session_data = Some(input.into());
            self
        }
        /// <p>A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>).</p>
        pub fn set_game_session_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_session_data = input;
            self
        }
        /// <p>Information about the matchmaking process that was used to create the game session. It is in JSON syntax, formatted as a string. In addition the matchmaking configuration used, it contains data on all players assigned to the match, including player attributes and team assignments. For more details on matchmaker data, see <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-server.html#match-server-data">Match Data</a>. Matchmaker data is useful when requesting match backfills, and is updated whenever new players are added during a successful backfill (see <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartMatchBackfill.html">StartMatchBackfill</a>). </p>
        pub fn matchmaker_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.matchmaker_data = Some(input.into());
            self
        }
        /// <p>Information about the matchmaking process that was used to create the game session. It is in JSON syntax, formatted as a string. In addition the matchmaking configuration used, it contains data on all players assigned to the match, including player attributes and team assignments. For more details on matchmaker data, see <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-server.html#match-server-data">Match Data</a>. Matchmaker data is useful when requesting match backfills, and is updated whenever new players are added during a successful backfill (see <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartMatchBackfill.html">StartMatchBackfill</a>). </p>
        pub fn set_matchmaker_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.matchmaker_data = input;
            self
        }
        /// <p>The fleet location where the game session is running. This value might specify the fleet's home Region or a remote location. Location is expressed as an Amazon Web Services Region code such as <code>us-west-2</code>. </p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The fleet location where the game session is running. This value might specify the fleet's home Region or a remote location. Location is expressed as an Amazon Web Services Region code such as <code>us-west-2</code>. </p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`GameSession`](crate::model::GameSession)
        pub fn build(self) -> crate::model::GameSession {
            crate::model::GameSession {
                game_session_id: self.game_session_id,
                name: self.name,
                fleet_id: self.fleet_id,
                fleet_arn: self.fleet_arn,
                creation_time: self.creation_time,
                termination_time: self.termination_time,
                current_player_session_count: self.current_player_session_count,
                maximum_player_session_count: self.maximum_player_session_count,
                status: self.status,
                status_reason: self.status_reason,
                game_properties: self.game_properties,
                ip_address: self.ip_address,
                dns_name: self.dns_name,
                port: self.port,
                player_session_creation_policy: self.player_session_creation_policy,
                creator_id: self.creator_id,
                game_session_data: self.game_session_data,
                matchmaker_data: self.matchmaker_data,
                location: self.location,
            }
        }
    }
}
impl GameSession {
    /// Creates a new builder-style object to manufacture [`GameSession`](crate::model::GameSession)
    pub fn builder() -> crate::model::game_session::Builder {
        crate::model::game_session::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PlayerSessionCreationPolicy {
    #[allow(missing_docs)] // documentation missing in model
    AcceptAll,
    #[allow(missing_docs)] // documentation missing in model
    DenyAll,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PlayerSessionCreationPolicy {
    fn from(s: &str) -> Self {
        match s {
            "ACCEPT_ALL" => PlayerSessionCreationPolicy::AcceptAll,
            "DENY_ALL" => PlayerSessionCreationPolicy::DenyAll,
            other => PlayerSessionCreationPolicy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PlayerSessionCreationPolicy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PlayerSessionCreationPolicy::from(s))
    }
}
impl PlayerSessionCreationPolicy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PlayerSessionCreationPolicy::AcceptAll => "ACCEPT_ALL",
            PlayerSessionCreationPolicy::DenyAll => "DENY_ALL",
            PlayerSessionCreationPolicy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACCEPT_ALL", "DENY_ALL"]
    }
}
impl AsRef<str> for PlayerSessionCreationPolicy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GameSessionStatusReason {
    #[allow(missing_docs)] // documentation missing in model
    Interrupted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GameSessionStatusReason {
    fn from(s: &str) -> Self {
        match s {
            "INTERRUPTED" => GameSessionStatusReason::Interrupted,
            other => GameSessionStatusReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GameSessionStatusReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GameSessionStatusReason::from(s))
    }
}
impl GameSessionStatusReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GameSessionStatusReason::Interrupted => "INTERRUPTED",
            GameSessionStatusReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INTERRUPTED"]
    }
}
impl AsRef<str> for GameSessionStatusReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GameSessionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Activating,
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Terminated,
    #[allow(missing_docs)] // documentation missing in model
    Terminating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GameSessionStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVATING" => GameSessionStatus::Activating,
            "ACTIVE" => GameSessionStatus::Active,
            "ERROR" => GameSessionStatus::Error,
            "TERMINATED" => GameSessionStatus::Terminated,
            "TERMINATING" => GameSessionStatus::Terminating,
            other => GameSessionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GameSessionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GameSessionStatus::from(s))
    }
}
impl GameSessionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GameSessionStatus::Activating => "ACTIVATING",
            GameSessionStatus::Active => "ACTIVE",
            GameSessionStatus::Error => "ERROR",
            GameSessionStatus::Terminated => "TERMINATED",
            GameSessionStatus::Terminating => "TERMINATING",
            GameSessionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVATING", "ACTIVE", "ERROR", "TERMINATED", "TERMINATING"]
    }
}
impl AsRef<str> for GameSessionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProtectionPolicy {
    #[allow(missing_docs)] // documentation missing in model
    FullProtection,
    #[allow(missing_docs)] // documentation missing in model
    NoProtection,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProtectionPolicy {
    fn from(s: &str) -> Self {
        match s {
            "FullProtection" => ProtectionPolicy::FullProtection,
            "NoProtection" => ProtectionPolicy::NoProtection,
            other => ProtectionPolicy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProtectionPolicy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProtectionPolicy::from(s))
    }
}
impl ProtectionPolicy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProtectionPolicy::FullProtection => "FullProtection",
            ProtectionPolicy::NoProtection => "NoProtection",
            ProtectionPolicy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FullProtection", "NoProtection"]
    }
}
impl AsRef<str> for ProtectionPolicy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> <b>This data type is used with the GameLift FleetIQ and game server groups.</b> </p>
/// <p>Properties that describe a game server group resource. A game server group manages certain properties related to a corresponding Amazon EC2 Auto Scaling group. </p>
/// <p>A game server group is created by a successful call to <code>CreateGameServerGroup</code> and deleted by calling <code>DeleteGameServerGroup</code>. Game server group activity can be temporarily suspended and resumed by calling <code>SuspendGameServerGroup</code> and <code>ResumeGameServerGroup</code>, respectively. </p>
/// <p> <b>Related actions</b> </p>
/// <p> <code>CreateGameServerGroup</code> | <code>ListGameServerGroups</code> | <code>DescribeGameServerGroup</code> | <code>UpdateGameServerGroup</code> | <code>DeleteGameServerGroup</code> | <code>ResumeGameServerGroup</code> | <code>SuspendGameServerGroup</code> | <code>DescribeGameServerInstances</code> | <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/reference-awssdk-fleetiq.html">All APIs by task</a> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GameServerGroup {
    /// <p>A developer-defined identifier for the game server group. The name is unique for each Region in each Amazon Web Services account.</p>
    pub game_server_group_name: std::option::Option<std::string::String>,
    /// <p>A generated unique ID for the game server group.</p>
    pub game_server_group_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) for an IAM role that allows Amazon GameLift to access your Amazon EC2 Auto Scaling groups.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The set of Amazon EC2 instance types that GameLift FleetIQ can use when balancing and automatically scaling instances in the corresponding Auto Scaling group. </p>
    pub instance_definitions: std::option::Option<std::vec::Vec<crate::model::InstanceDefinition>>,
    /// <p>Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game server group. Method options include the following:</p>
    /// <ul>
    /// <li> <p> <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are unavailable or not viable for game hosting, the game server group provides no hosting capacity until Spot Instances can again be used. Until then, no new instances are started, and the existing nonviable Spot Instances are terminated (after current gameplay ends) and are not replaced.</p> </li>
    /// <li> <p> <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game server group. If Spot Instances are unavailable, the game server group continues to provide hosting capacity by falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after current gameplay ends) and are replaced with new On-Demand Instances.</p> </li>
    /// <li> <p> <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot Instances are used, even when available, while this balancing strategy is in force.</p> </li>
    /// </ul>
    pub balancing_strategy: std::option::Option<crate::model::BalancingStrategy>,
    /// <p>A flag that indicates whether instances in the game server group are protected from early termination. Unprotected instances that have active game servers running might be terminated during a scale-down event, causing players to be dropped from the game. Protected instances cannot be terminated while there are active game servers running except in the event of a forced game server group deletion (see ). An exception to this is with Spot Instances, which can be terminated by Amazon Web Services regardless of protection status. </p>
    pub game_server_protection_policy:
        std::option::Option<crate::model::GameServerProtectionPolicy>,
    /// <p>A generated unique ID for the Amazon EC2 Auto Scaling group that is associated with this game server group.</p>
    pub auto_scaling_group_arn: std::option::Option<std::string::String>,
    /// <p>The current status of the game server group. Possible statuses include:</p>
    /// <ul>
    /// <li> <p> <code>NEW</code> - GameLift FleetIQ has validated the <code>CreateGameServerGroup()</code> request. </p> </li>
    /// <li> <p> <code>ACTIVATING</code> - GameLift FleetIQ is setting up a game server group, which includes creating an Auto Scaling group in your Amazon Web Services account. </p> </li>
    /// <li> <p> <code>ACTIVE</code> - The game server group has been successfully created. </p> </li>
    /// <li> <p> <code>DELETE_SCHEDULED</code> - A request to delete the game server group has been received. </p> </li>
    /// <li> <p> <code>DELETING</code> - GameLift FleetIQ has received a valid <code>DeleteGameServerGroup()</code> request and is processing it. GameLift FleetIQ must first complete and release hosts before it deletes the Auto Scaling group and the game server group. </p> </li>
    /// <li> <p> <code>DELETED</code> - The game server group has been successfully deleted. </p> </li>
    /// <li> <p> <code>ERROR</code> - The asynchronous processes of activating or deleting a game server group has failed, resulting in an error state.</p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::GameServerGroupStatus>,
    /// <p>Additional information about the current game server group status. This information might provide additional insight on groups that are in <code>ERROR</code> status.</p>
    pub status_reason: std::option::Option<std::string::String>,
    /// <p>A list of activities that are currently suspended for this game server group. If this property is empty, all activities are occurring.</p>
    pub suspended_actions: std::option::Option<std::vec::Vec<crate::model::GameServerGroupAction>>,
    /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp that indicates when this game server group was last updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl GameServerGroup {
    /// <p>A developer-defined identifier for the game server group. The name is unique for each Region in each Amazon Web Services account.</p>
    pub fn game_server_group_name(&self) -> std::option::Option<&str> {
        self.game_server_group_name.as_deref()
    }
    /// <p>A generated unique ID for the game server group.</p>
    pub fn game_server_group_arn(&self) -> std::option::Option<&str> {
        self.game_server_group_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) for an IAM role that allows Amazon GameLift to access your Amazon EC2 Auto Scaling groups.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The set of Amazon EC2 instance types that GameLift FleetIQ can use when balancing and automatically scaling instances in the corresponding Auto Scaling group. </p>
    pub fn instance_definitions(&self) -> std::option::Option<&[crate::model::InstanceDefinition]> {
        self.instance_definitions.as_deref()
    }
    /// <p>Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game server group. Method options include the following:</p>
    /// <ul>
    /// <li> <p> <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are unavailable or not viable for game hosting, the game server group provides no hosting capacity until Spot Instances can again be used. Until then, no new instances are started, and the existing nonviable Spot Instances are terminated (after current gameplay ends) and are not replaced.</p> </li>
    /// <li> <p> <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game server group. If Spot Instances are unavailable, the game server group continues to provide hosting capacity by falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after current gameplay ends) and are replaced with new On-Demand Instances.</p> </li>
    /// <li> <p> <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot Instances are used, even when available, while this balancing strategy is in force.</p> </li>
    /// </ul>
    pub fn balancing_strategy(&self) -> std::option::Option<&crate::model::BalancingStrategy> {
        self.balancing_strategy.as_ref()
    }
    /// <p>A flag that indicates whether instances in the game server group are protected from early termination. Unprotected instances that have active game servers running might be terminated during a scale-down event, causing players to be dropped from the game. Protected instances cannot be terminated while there are active game servers running except in the event of a forced game server group deletion (see ). An exception to this is with Spot Instances, which can be terminated by Amazon Web Services regardless of protection status. </p>
    pub fn game_server_protection_policy(
        &self,
    ) -> std::option::Option<&crate::model::GameServerProtectionPolicy> {
        self.game_server_protection_policy.as_ref()
    }
    /// <p>A generated unique ID for the Amazon EC2 Auto Scaling group that is associated with this game server group.</p>
    pub fn auto_scaling_group_arn(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_arn.as_deref()
    }
    /// <p>The current status of the game server group. Possible statuses include:</p>
    /// <ul>
    /// <li> <p> <code>NEW</code> - GameLift FleetIQ has validated the <code>CreateGameServerGroup()</code> request. </p> </li>
    /// <li> <p> <code>ACTIVATING</code> - GameLift FleetIQ is setting up a game server group, which includes creating an Auto Scaling group in your Amazon Web Services account. </p> </li>
    /// <li> <p> <code>ACTIVE</code> - The game server group has been successfully created. </p> </li>
    /// <li> <p> <code>DELETE_SCHEDULED</code> - A request to delete the game server group has been received. </p> </li>
    /// <li> <p> <code>DELETING</code> - GameLift FleetIQ has received a valid <code>DeleteGameServerGroup()</code> request and is processing it. GameLift FleetIQ must first complete and release hosts before it deletes the Auto Scaling group and the game server group. </p> </li>
    /// <li> <p> <code>DELETED</code> - The game server group has been successfully deleted. </p> </li>
    /// <li> <p> <code>ERROR</code> - The asynchronous processes of activating or deleting a game server group has failed, resulting in an error state.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::GameServerGroupStatus> {
        self.status.as_ref()
    }
    /// <p>Additional information about the current game server group status. This information might provide additional insight on groups that are in <code>ERROR</code> status.</p>
    pub fn status_reason(&self) -> std::option::Option<&str> {
        self.status_reason.as_deref()
    }
    /// <p>A list of activities that are currently suspended for this game server group. If this property is empty, all activities are occurring.</p>
    pub fn suspended_actions(&self) -> std::option::Option<&[crate::model::GameServerGroupAction]> {
        self.suspended_actions.as_deref()
    }
    /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>A timestamp that indicates when this game server group was last updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
}
impl std::fmt::Debug for GameServerGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GameServerGroup");
        formatter.field("game_server_group_name", &self.game_server_group_name);
        formatter.field("game_server_group_arn", &self.game_server_group_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("instance_definitions", &self.instance_definitions);
        formatter.field("balancing_strategy", &self.balancing_strategy);
        formatter.field(
            "game_server_protection_policy",
            &self.game_server_protection_policy,
        );
        formatter.field("auto_scaling_group_arn", &self.auto_scaling_group_arn);
        formatter.field("status", &self.status);
        formatter.field("status_reason", &self.status_reason);
        formatter.field("suspended_actions", &self.suspended_actions);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.finish()
    }
}
/// See [`GameServerGroup`](crate::model::GameServerGroup)
pub mod game_server_group {
    /// A builder for [`GameServerGroup`](crate::model::GameServerGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_server_group_name: std::option::Option<std::string::String>,
        pub(crate) game_server_group_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) instance_definitions:
            std::option::Option<std::vec::Vec<crate::model::InstanceDefinition>>,
        pub(crate) balancing_strategy: std::option::Option<crate::model::BalancingStrategy>,
        pub(crate) game_server_protection_policy:
            std::option::Option<crate::model::GameServerProtectionPolicy>,
        pub(crate) auto_scaling_group_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::GameServerGroupStatus>,
        pub(crate) status_reason: std::option::Option<std::string::String>,
        pub(crate) suspended_actions:
            std::option::Option<std::vec::Vec<crate::model::GameServerGroupAction>>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>A developer-defined identifier for the game server group. The name is unique for each Region in each Amazon Web Services account.</p>
        pub fn game_server_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_server_group_name = Some(input.into());
            self
        }
        /// <p>A developer-defined identifier for the game server group. The name is unique for each Region in each Amazon Web Services account.</p>
        pub fn set_game_server_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_server_group_name = input;
            self
        }
        /// <p>A generated unique ID for the game server group.</p>
        pub fn game_server_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_server_group_arn = Some(input.into());
            self
        }
        /// <p>A generated unique ID for the game server group.</p>
        pub fn set_game_server_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_server_group_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) for an IAM role that allows Amazon GameLift to access your Amazon EC2 Auto Scaling groups.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) for an IAM role that allows Amazon GameLift to access your Amazon EC2 Auto Scaling groups.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `instance_definitions`.
        ///
        /// To override the contents of this collection use [`set_instance_definitions`](Self::set_instance_definitions).
        ///
        /// <p>The set of Amazon EC2 instance types that GameLift FleetIQ can use when balancing and automatically scaling instances in the corresponding Auto Scaling group. </p>
        pub fn instance_definitions(mut self, input: crate::model::InstanceDefinition) -> Self {
            let mut v = self.instance_definitions.unwrap_or_default();
            v.push(input);
            self.instance_definitions = Some(v);
            self
        }
        /// <p>The set of Amazon EC2 instance types that GameLift FleetIQ can use when balancing and automatically scaling instances in the corresponding Auto Scaling group. </p>
        pub fn set_instance_definitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceDefinition>>,
        ) -> Self {
            self.instance_definitions = input;
            self
        }
        /// <p>Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game server group. Method options include the following:</p>
        /// <ul>
        /// <li> <p> <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are unavailable or not viable for game hosting, the game server group provides no hosting capacity until Spot Instances can again be used. Until then, no new instances are started, and the existing nonviable Spot Instances are terminated (after current gameplay ends) and are not replaced.</p> </li>
        /// <li> <p> <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game server group. If Spot Instances are unavailable, the game server group continues to provide hosting capacity by falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after current gameplay ends) and are replaced with new On-Demand Instances.</p> </li>
        /// <li> <p> <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot Instances are used, even when available, while this balancing strategy is in force.</p> </li>
        /// </ul>
        pub fn balancing_strategy(mut self, input: crate::model::BalancingStrategy) -> Self {
            self.balancing_strategy = Some(input);
            self
        }
        /// <p>Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game server group. Method options include the following:</p>
        /// <ul>
        /// <li> <p> <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are unavailable or not viable for game hosting, the game server group provides no hosting capacity until Spot Instances can again be used. Until then, no new instances are started, and the existing nonviable Spot Instances are terminated (after current gameplay ends) and are not replaced.</p> </li>
        /// <li> <p> <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game server group. If Spot Instances are unavailable, the game server group continues to provide hosting capacity by falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after current gameplay ends) and are replaced with new On-Demand Instances.</p> </li>
        /// <li> <p> <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot Instances are used, even when available, while this balancing strategy is in force.</p> </li>
        /// </ul>
        pub fn set_balancing_strategy(
            mut self,
            input: std::option::Option<crate::model::BalancingStrategy>,
        ) -> Self {
            self.balancing_strategy = input;
            self
        }
        /// <p>A flag that indicates whether instances in the game server group are protected from early termination. Unprotected instances that have active game servers running might be terminated during a scale-down event, causing players to be dropped from the game. Protected instances cannot be terminated while there are active game servers running except in the event of a forced game server group deletion (see ). An exception to this is with Spot Instances, which can be terminated by Amazon Web Services regardless of protection status. </p>
        pub fn game_server_protection_policy(
            mut self,
            input: crate::model::GameServerProtectionPolicy,
        ) -> Self {
            self.game_server_protection_policy = Some(input);
            self
        }
        /// <p>A flag that indicates whether instances in the game server group are protected from early termination. Unprotected instances that have active game servers running might be terminated during a scale-down event, causing players to be dropped from the game. Protected instances cannot be terminated while there are active game servers running except in the event of a forced game server group deletion (see ). An exception to this is with Spot Instances, which can be terminated by Amazon Web Services regardless of protection status. </p>
        pub fn set_game_server_protection_policy(
            mut self,
            input: std::option::Option<crate::model::GameServerProtectionPolicy>,
        ) -> Self {
            self.game_server_protection_policy = input;
            self
        }
        /// <p>A generated unique ID for the Amazon EC2 Auto Scaling group that is associated with this game server group.</p>
        pub fn auto_scaling_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_arn = Some(input.into());
            self
        }
        /// <p>A generated unique ID for the Amazon EC2 Auto Scaling group that is associated with this game server group.</p>
        pub fn set_auto_scaling_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_arn = input;
            self
        }
        /// <p>The current status of the game server group. Possible statuses include:</p>
        /// <ul>
        /// <li> <p> <code>NEW</code> - GameLift FleetIQ has validated the <code>CreateGameServerGroup()</code> request. </p> </li>
        /// <li> <p> <code>ACTIVATING</code> - GameLift FleetIQ is setting up a game server group, which includes creating an Auto Scaling group in your Amazon Web Services account. </p> </li>
        /// <li> <p> <code>ACTIVE</code> - The game server group has been successfully created. </p> </li>
        /// <li> <p> <code>DELETE_SCHEDULED</code> - A request to delete the game server group has been received. </p> </li>
        /// <li> <p> <code>DELETING</code> - GameLift FleetIQ has received a valid <code>DeleteGameServerGroup()</code> request and is processing it. GameLift FleetIQ must first complete and release hosts before it deletes the Auto Scaling group and the game server group. </p> </li>
        /// <li> <p> <code>DELETED</code> - The game server group has been successfully deleted. </p> </li>
        /// <li> <p> <code>ERROR</code> - The asynchronous processes of activating or deleting a game server group has failed, resulting in an error state.</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::GameServerGroupStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the game server group. Possible statuses include:</p>
        /// <ul>
        /// <li> <p> <code>NEW</code> - GameLift FleetIQ has validated the <code>CreateGameServerGroup()</code> request. </p> </li>
        /// <li> <p> <code>ACTIVATING</code> - GameLift FleetIQ is setting up a game server group, which includes creating an Auto Scaling group in your Amazon Web Services account. </p> </li>
        /// <li> <p> <code>ACTIVE</code> - The game server group has been successfully created. </p> </li>
        /// <li> <p> <code>DELETE_SCHEDULED</code> - A request to delete the game server group has been received. </p> </li>
        /// <li> <p> <code>DELETING</code> - GameLift FleetIQ has received a valid <code>DeleteGameServerGroup()</code> request and is processing it. GameLift FleetIQ must first complete and release hosts before it deletes the Auto Scaling group and the game server group. </p> </li>
        /// <li> <p> <code>DELETED</code> - The game server group has been successfully deleted. </p> </li>
        /// <li> <p> <code>ERROR</code> - The asynchronous processes of activating or deleting a game server group has failed, resulting in an error state.</p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::GameServerGroupStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Additional information about the current game server group status. This information might provide additional insight on groups that are in <code>ERROR</code> status.</p>
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_reason = Some(input.into());
            self
        }
        /// <p>Additional information about the current game server group status. This information might provide additional insight on groups that are in <code>ERROR</code> status.</p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// Appends an item to `suspended_actions`.
        ///
        /// To override the contents of this collection use [`set_suspended_actions`](Self::set_suspended_actions).
        ///
        /// <p>A list of activities that are currently suspended for this game server group. If this property is empty, all activities are occurring.</p>
        pub fn suspended_actions(mut self, input: crate::model::GameServerGroupAction) -> Self {
            let mut v = self.suspended_actions.unwrap_or_default();
            v.push(input);
            self.suspended_actions = Some(v);
            self
        }
        /// <p>A list of activities that are currently suspended for this game server group. If this property is empty, all activities are occurring.</p>
        pub fn set_suspended_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GameServerGroupAction>>,
        ) -> Self {
            self.suspended_actions = input;
            self
        }
        /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>A timestamp that indicates when this game server group was last updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when this game server group was last updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// Consumes the builder and constructs a [`GameServerGroup`](crate::model::GameServerGroup)
        pub fn build(self) -> crate::model::GameServerGroup {
            crate::model::GameServerGroup {
                game_server_group_name: self.game_server_group_name,
                game_server_group_arn: self.game_server_group_arn,
                role_arn: self.role_arn,
                instance_definitions: self.instance_definitions,
                balancing_strategy: self.balancing_strategy,
                game_server_protection_policy: self.game_server_protection_policy,
                auto_scaling_group_arn: self.auto_scaling_group_arn,
                status: self.status,
                status_reason: self.status_reason,
                suspended_actions: self.suspended_actions,
                creation_time: self.creation_time,
                last_updated_time: self.last_updated_time,
            }
        }
    }
}
impl GameServerGroup {
    /// Creates a new builder-style object to manufacture [`GameServerGroup`](crate::model::GameServerGroup)
    pub fn builder() -> crate::model::game_server_group::Builder {
        crate::model::game_server_group::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GameServerGroupAction {
    #[allow(missing_docs)] // documentation missing in model
    ReplaceInstanceTypes,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GameServerGroupAction {
    fn from(s: &str) -> Self {
        match s {
            "REPLACE_INSTANCE_TYPES" => GameServerGroupAction::ReplaceInstanceTypes,
            other => GameServerGroupAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GameServerGroupAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GameServerGroupAction::from(s))
    }
}
impl GameServerGroupAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GameServerGroupAction::ReplaceInstanceTypes => "REPLACE_INSTANCE_TYPES",
            GameServerGroupAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["REPLACE_INSTANCE_TYPES"]
    }
}
impl AsRef<str> for GameServerGroupAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GameServerGroupStatus {
    #[allow(missing_docs)] // documentation missing in model
    Activating,
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    DeleteScheduled,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    New,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GameServerGroupStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVATING" => GameServerGroupStatus::Activating,
            "ACTIVE" => GameServerGroupStatus::Active,
            "DELETED" => GameServerGroupStatus::Deleted,
            "DELETE_SCHEDULED" => GameServerGroupStatus::DeleteScheduled,
            "DELETING" => GameServerGroupStatus::Deleting,
            "ERROR" => GameServerGroupStatus::Error,
            "NEW" => GameServerGroupStatus::New,
            other => GameServerGroupStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GameServerGroupStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GameServerGroupStatus::from(s))
    }
}
impl GameServerGroupStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GameServerGroupStatus::Activating => "ACTIVATING",
            GameServerGroupStatus::Active => "ACTIVE",
            GameServerGroupStatus::Deleted => "DELETED",
            GameServerGroupStatus::DeleteScheduled => "DELETE_SCHEDULED",
            GameServerGroupStatus::Deleting => "DELETING",
            GameServerGroupStatus::Error => "ERROR",
            GameServerGroupStatus::New => "NEW",
            GameServerGroupStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVATING",
            "ACTIVE",
            "DELETED",
            "DELETE_SCHEDULED",
            "DELETING",
            "ERROR",
            "NEW",
        ]
    }
}
impl AsRef<str> for GameServerGroupStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GameServerProtectionPolicy {
    #[allow(missing_docs)] // documentation missing in model
    FullProtection,
    #[allow(missing_docs)] // documentation missing in model
    NoProtection,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GameServerProtectionPolicy {
    fn from(s: &str) -> Self {
        match s {
            "FULL_PROTECTION" => GameServerProtectionPolicy::FullProtection,
            "NO_PROTECTION" => GameServerProtectionPolicy::NoProtection,
            other => GameServerProtectionPolicy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GameServerProtectionPolicy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GameServerProtectionPolicy::from(s))
    }
}
impl GameServerProtectionPolicy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GameServerProtectionPolicy::FullProtection => "FULL_PROTECTION",
            GameServerProtectionPolicy::NoProtection => "NO_PROTECTION",
            GameServerProtectionPolicy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FULL_PROTECTION", "NO_PROTECTION"]
    }
}
impl AsRef<str> for GameServerProtectionPolicy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BalancingStrategy {
    #[allow(missing_docs)] // documentation missing in model
    OnDemandOnly,
    #[allow(missing_docs)] // documentation missing in model
    SpotOnly,
    #[allow(missing_docs)] // documentation missing in model
    SpotPreferred,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BalancingStrategy {
    fn from(s: &str) -> Self {
        match s {
            "ON_DEMAND_ONLY" => BalancingStrategy::OnDemandOnly,
            "SPOT_ONLY" => BalancingStrategy::SpotOnly,
            "SPOT_PREFERRED" => BalancingStrategy::SpotPreferred,
            other => BalancingStrategy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BalancingStrategy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BalancingStrategy::from(s))
    }
}
impl BalancingStrategy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BalancingStrategy::OnDemandOnly => "ON_DEMAND_ONLY",
            BalancingStrategy::SpotOnly => "SPOT_ONLY",
            BalancingStrategy::SpotPreferred => "SPOT_PREFERRED",
            BalancingStrategy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ON_DEMAND_ONLY", "SPOT_ONLY", "SPOT_PREFERRED"]
    }
}
impl AsRef<str> for BalancingStrategy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> <b>This data type is used with the GameLift FleetIQ and game server groups.</b> </p>
/// <p>An allowed instance type for a <code>GameServerGroup</code>. All game server groups must have at least two instance types defined for it. GameLift FleetIQ periodically evaluates each defined instance type for viability. It then updates the Auto Scaling group with the list of viable instance types.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceDefinition {
    /// <p>An Amazon EC2 instance type designation.</p>
    pub instance_type: std::option::Option<crate::model::GameServerGroupInstanceType>,
    /// <p>Instance weighting that indicates how much this instance type contributes to the total capacity of a game server group. Instance weights are used by GameLift FleetIQ to calculate the instance type's cost per unit hour and better identify the most cost-effective options. For detailed information on weighting instance capacity, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html">Instance Weighting</a> in the <i>Amazon Elastic Compute Cloud Auto Scaling User Guide</i>. Default value is "1".</p>
    pub weighted_capacity: std::option::Option<std::string::String>,
}
impl InstanceDefinition {
    /// <p>An Amazon EC2 instance type designation.</p>
    pub fn instance_type(&self) -> std::option::Option<&crate::model::GameServerGroupInstanceType> {
        self.instance_type.as_ref()
    }
    /// <p>Instance weighting that indicates how much this instance type contributes to the total capacity of a game server group. Instance weights are used by GameLift FleetIQ to calculate the instance type's cost per unit hour and better identify the most cost-effective options. For detailed information on weighting instance capacity, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html">Instance Weighting</a> in the <i>Amazon Elastic Compute Cloud Auto Scaling User Guide</i>. Default value is "1".</p>
    pub fn weighted_capacity(&self) -> std::option::Option<&str> {
        self.weighted_capacity.as_deref()
    }
}
impl std::fmt::Debug for InstanceDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceDefinition");
        formatter.field("instance_type", &self.instance_type);
        formatter.field("weighted_capacity", &self.weighted_capacity);
        formatter.finish()
    }
}
/// See [`InstanceDefinition`](crate::model::InstanceDefinition)
pub mod instance_definition {
    /// A builder for [`InstanceDefinition`](crate::model::InstanceDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_type: std::option::Option<crate::model::GameServerGroupInstanceType>,
        pub(crate) weighted_capacity: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An Amazon EC2 instance type designation.</p>
        pub fn instance_type(mut self, input: crate::model::GameServerGroupInstanceType) -> Self {
            self.instance_type = Some(input);
            self
        }
        /// <p>An Amazon EC2 instance type designation.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<crate::model::GameServerGroupInstanceType>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>Instance weighting that indicates how much this instance type contributes to the total capacity of a game server group. Instance weights are used by GameLift FleetIQ to calculate the instance type's cost per unit hour and better identify the most cost-effective options. For detailed information on weighting instance capacity, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html">Instance Weighting</a> in the <i>Amazon Elastic Compute Cloud Auto Scaling User Guide</i>. Default value is "1".</p>
        pub fn weighted_capacity(mut self, input: impl Into<std::string::String>) -> Self {
            self.weighted_capacity = Some(input.into());
            self
        }
        /// <p>Instance weighting that indicates how much this instance type contributes to the total capacity of a game server group. Instance weights are used by GameLift FleetIQ to calculate the instance type's cost per unit hour and better identify the most cost-effective options. For detailed information on weighting instance capacity, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html">Instance Weighting</a> in the <i>Amazon Elastic Compute Cloud Auto Scaling User Guide</i>. Default value is "1".</p>
        pub fn set_weighted_capacity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.weighted_capacity = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceDefinition`](crate::model::InstanceDefinition)
        pub fn build(self) -> crate::model::InstanceDefinition {
            crate::model::InstanceDefinition {
                instance_type: self.instance_type,
                weighted_capacity: self.weighted_capacity,
            }
        }
    }
}
impl InstanceDefinition {
    /// Creates a new builder-style object to manufacture [`InstanceDefinition`](crate::model::InstanceDefinition)
    pub fn builder() -> crate::model::instance_definition::Builder {
        crate::model::instance_definition::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GameServerGroupInstanceType {
    #[allow(missing_docs)] // documentation missing in model
    C42xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C44xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C48xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C4Large,
    #[allow(missing_docs)] // documentation missing in model
    C4Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C512xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C518xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C524xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C52xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C54xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C59xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5Large,
    #[allow(missing_docs)] // documentation missing in model
    C5Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5a12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5a16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5a24xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5a2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5a4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5a8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5aLarge,
    #[allow(missing_docs)] // documentation missing in model
    C5aXlarge,
    #[allow(missing_docs)] // documentation missing in model
    C6g12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C6g16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C6g2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C6g4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C6g8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C6gLarge,
    #[allow(missing_docs)] // documentation missing in model
    C6gMedium,
    #[allow(missing_docs)] // documentation missing in model
    C6gXlarge,
    #[allow(missing_docs)] // documentation missing in model
    M410xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M42xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M44xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M4Large,
    #[allow(missing_docs)] // documentation missing in model
    M4Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M512xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M516xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M524xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M52xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M54xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M58xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5Large,
    #[allow(missing_docs)] // documentation missing in model
    M5Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5a12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5a16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5a24xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5a2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5a4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5a8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5aLarge,
    #[allow(missing_docs)] // documentation missing in model
    M5aXlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6g12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6g16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6g2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6g4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6g8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6gLarge,
    #[allow(missing_docs)] // documentation missing in model
    M6gMedium,
    #[allow(missing_docs)] // documentation missing in model
    M6gXlarge,
    #[allow(missing_docs)] // documentation missing in model
    R416xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R42xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R44xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R48xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R4Large,
    #[allow(missing_docs)] // documentation missing in model
    R4Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R512xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R516xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R524xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R52xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R54xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R58xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5Large,
    #[allow(missing_docs)] // documentation missing in model
    R5Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5a12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5a16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5a24xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5a2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5a4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5a8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5aLarge,
    #[allow(missing_docs)] // documentation missing in model
    R5aXlarge,
    #[allow(missing_docs)] // documentation missing in model
    R6g12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R6g16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R6g2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R6g4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R6g8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R6gLarge,
    #[allow(missing_docs)] // documentation missing in model
    R6gMedium,
    #[allow(missing_docs)] // documentation missing in model
    R6gXlarge,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GameServerGroupInstanceType {
    fn from(s: &str) -> Self {
        match s {
            "c4.2xlarge" => GameServerGroupInstanceType::C42xlarge,
            "c4.4xlarge" => GameServerGroupInstanceType::C44xlarge,
            "c4.8xlarge" => GameServerGroupInstanceType::C48xlarge,
            "c4.large" => GameServerGroupInstanceType::C4Large,
            "c4.xlarge" => GameServerGroupInstanceType::C4Xlarge,
            "c5.12xlarge" => GameServerGroupInstanceType::C512xlarge,
            "c5.18xlarge" => GameServerGroupInstanceType::C518xlarge,
            "c5.24xlarge" => GameServerGroupInstanceType::C524xlarge,
            "c5.2xlarge" => GameServerGroupInstanceType::C52xlarge,
            "c5.4xlarge" => GameServerGroupInstanceType::C54xlarge,
            "c5.9xlarge" => GameServerGroupInstanceType::C59xlarge,
            "c5.large" => GameServerGroupInstanceType::C5Large,
            "c5.xlarge" => GameServerGroupInstanceType::C5Xlarge,
            "c5a.12xlarge" => GameServerGroupInstanceType::C5a12xlarge,
            "c5a.16xlarge" => GameServerGroupInstanceType::C5a16xlarge,
            "c5a.24xlarge" => GameServerGroupInstanceType::C5a24xlarge,
            "c5a.2xlarge" => GameServerGroupInstanceType::C5a2xlarge,
            "c5a.4xlarge" => GameServerGroupInstanceType::C5a4xlarge,
            "c5a.8xlarge" => GameServerGroupInstanceType::C5a8xlarge,
            "c5a.large" => GameServerGroupInstanceType::C5aLarge,
            "c5a.xlarge" => GameServerGroupInstanceType::C5aXlarge,
            "c6g.12xlarge" => GameServerGroupInstanceType::C6g12xlarge,
            "c6g.16xlarge" => GameServerGroupInstanceType::C6g16xlarge,
            "c6g.2xlarge" => GameServerGroupInstanceType::C6g2xlarge,
            "c6g.4xlarge" => GameServerGroupInstanceType::C6g4xlarge,
            "c6g.8xlarge" => GameServerGroupInstanceType::C6g8xlarge,
            "c6g.large" => GameServerGroupInstanceType::C6gLarge,
            "c6g.medium" => GameServerGroupInstanceType::C6gMedium,
            "c6g.xlarge" => GameServerGroupInstanceType::C6gXlarge,
            "m4.10xlarge" => GameServerGroupInstanceType::M410xlarge,
            "m4.2xlarge" => GameServerGroupInstanceType::M42xlarge,
            "m4.4xlarge" => GameServerGroupInstanceType::M44xlarge,
            "m4.large" => GameServerGroupInstanceType::M4Large,
            "m4.xlarge" => GameServerGroupInstanceType::M4Xlarge,
            "m5.12xlarge" => GameServerGroupInstanceType::M512xlarge,
            "m5.16xlarge" => GameServerGroupInstanceType::M516xlarge,
            "m5.24xlarge" => GameServerGroupInstanceType::M524xlarge,
            "m5.2xlarge" => GameServerGroupInstanceType::M52xlarge,
            "m5.4xlarge" => GameServerGroupInstanceType::M54xlarge,
            "m5.8xlarge" => GameServerGroupInstanceType::M58xlarge,
            "m5.large" => GameServerGroupInstanceType::M5Large,
            "m5.xlarge" => GameServerGroupInstanceType::M5Xlarge,
            "m5a.12xlarge" => GameServerGroupInstanceType::M5a12xlarge,
            "m5a.16xlarge" => GameServerGroupInstanceType::M5a16xlarge,
            "m5a.24xlarge" => GameServerGroupInstanceType::M5a24xlarge,
            "m5a.2xlarge" => GameServerGroupInstanceType::M5a2xlarge,
            "m5a.4xlarge" => GameServerGroupInstanceType::M5a4xlarge,
            "m5a.8xlarge" => GameServerGroupInstanceType::M5a8xlarge,
            "m5a.large" => GameServerGroupInstanceType::M5aLarge,
            "m5a.xlarge" => GameServerGroupInstanceType::M5aXlarge,
            "m6g.12xlarge" => GameServerGroupInstanceType::M6g12xlarge,
            "m6g.16xlarge" => GameServerGroupInstanceType::M6g16xlarge,
            "m6g.2xlarge" => GameServerGroupInstanceType::M6g2xlarge,
            "m6g.4xlarge" => GameServerGroupInstanceType::M6g4xlarge,
            "m6g.8xlarge" => GameServerGroupInstanceType::M6g8xlarge,
            "m6g.large" => GameServerGroupInstanceType::M6gLarge,
            "m6g.medium" => GameServerGroupInstanceType::M6gMedium,
            "m6g.xlarge" => GameServerGroupInstanceType::M6gXlarge,
            "r4.16xlarge" => GameServerGroupInstanceType::R416xlarge,
            "r4.2xlarge" => GameServerGroupInstanceType::R42xlarge,
            "r4.4xlarge" => GameServerGroupInstanceType::R44xlarge,
            "r4.8xlarge" => GameServerGroupInstanceType::R48xlarge,
            "r4.large" => GameServerGroupInstanceType::R4Large,
            "r4.xlarge" => GameServerGroupInstanceType::R4Xlarge,
            "r5.12xlarge" => GameServerGroupInstanceType::R512xlarge,
            "r5.16xlarge" => GameServerGroupInstanceType::R516xlarge,
            "r5.24xlarge" => GameServerGroupInstanceType::R524xlarge,
            "r5.2xlarge" => GameServerGroupInstanceType::R52xlarge,
            "r5.4xlarge" => GameServerGroupInstanceType::R54xlarge,
            "r5.8xlarge" => GameServerGroupInstanceType::R58xlarge,
            "r5.large" => GameServerGroupInstanceType::R5Large,
            "r5.xlarge" => GameServerGroupInstanceType::R5Xlarge,
            "r5a.12xlarge" => GameServerGroupInstanceType::R5a12xlarge,
            "r5a.16xlarge" => GameServerGroupInstanceType::R5a16xlarge,
            "r5a.24xlarge" => GameServerGroupInstanceType::R5a24xlarge,
            "r5a.2xlarge" => GameServerGroupInstanceType::R5a2xlarge,
            "r5a.4xlarge" => GameServerGroupInstanceType::R5a4xlarge,
            "r5a.8xlarge" => GameServerGroupInstanceType::R5a8xlarge,
            "r5a.large" => GameServerGroupInstanceType::R5aLarge,
            "r5a.xlarge" => GameServerGroupInstanceType::R5aXlarge,
            "r6g.12xlarge" => GameServerGroupInstanceType::R6g12xlarge,
            "r6g.16xlarge" => GameServerGroupInstanceType::R6g16xlarge,
            "r6g.2xlarge" => GameServerGroupInstanceType::R6g2xlarge,
            "r6g.4xlarge" => GameServerGroupInstanceType::R6g4xlarge,
            "r6g.8xlarge" => GameServerGroupInstanceType::R6g8xlarge,
            "r6g.large" => GameServerGroupInstanceType::R6gLarge,
            "r6g.medium" => GameServerGroupInstanceType::R6gMedium,
            "r6g.xlarge" => GameServerGroupInstanceType::R6gXlarge,
            other => GameServerGroupInstanceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GameServerGroupInstanceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GameServerGroupInstanceType::from(s))
    }
}
impl GameServerGroupInstanceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GameServerGroupInstanceType::C42xlarge => "c4.2xlarge",
            GameServerGroupInstanceType::C44xlarge => "c4.4xlarge",
            GameServerGroupInstanceType::C48xlarge => "c4.8xlarge",
            GameServerGroupInstanceType::C4Large => "c4.large",
            GameServerGroupInstanceType::C4Xlarge => "c4.xlarge",
            GameServerGroupInstanceType::C512xlarge => "c5.12xlarge",
            GameServerGroupInstanceType::C518xlarge => "c5.18xlarge",
            GameServerGroupInstanceType::C524xlarge => "c5.24xlarge",
            GameServerGroupInstanceType::C52xlarge => "c5.2xlarge",
            GameServerGroupInstanceType::C54xlarge => "c5.4xlarge",
            GameServerGroupInstanceType::C59xlarge => "c5.9xlarge",
            GameServerGroupInstanceType::C5Large => "c5.large",
            GameServerGroupInstanceType::C5Xlarge => "c5.xlarge",
            GameServerGroupInstanceType::C5a12xlarge => "c5a.12xlarge",
            GameServerGroupInstanceType::C5a16xlarge => "c5a.16xlarge",
            GameServerGroupInstanceType::C5a24xlarge => "c5a.24xlarge",
            GameServerGroupInstanceType::C5a2xlarge => "c5a.2xlarge",
            GameServerGroupInstanceType::C5a4xlarge => "c5a.4xlarge",
            GameServerGroupInstanceType::C5a8xlarge => "c5a.8xlarge",
            GameServerGroupInstanceType::C5aLarge => "c5a.large",
            GameServerGroupInstanceType::C5aXlarge => "c5a.xlarge",
            GameServerGroupInstanceType::C6g12xlarge => "c6g.12xlarge",
            GameServerGroupInstanceType::C6g16xlarge => "c6g.16xlarge",
            GameServerGroupInstanceType::C6g2xlarge => "c6g.2xlarge",
            GameServerGroupInstanceType::C6g4xlarge => "c6g.4xlarge",
            GameServerGroupInstanceType::C6g8xlarge => "c6g.8xlarge",
            GameServerGroupInstanceType::C6gLarge => "c6g.large",
            GameServerGroupInstanceType::C6gMedium => "c6g.medium",
            GameServerGroupInstanceType::C6gXlarge => "c6g.xlarge",
            GameServerGroupInstanceType::M410xlarge => "m4.10xlarge",
            GameServerGroupInstanceType::M42xlarge => "m4.2xlarge",
            GameServerGroupInstanceType::M44xlarge => "m4.4xlarge",
            GameServerGroupInstanceType::M4Large => "m4.large",
            GameServerGroupInstanceType::M4Xlarge => "m4.xlarge",
            GameServerGroupInstanceType::M512xlarge => "m5.12xlarge",
            GameServerGroupInstanceType::M516xlarge => "m5.16xlarge",
            GameServerGroupInstanceType::M524xlarge => "m5.24xlarge",
            GameServerGroupInstanceType::M52xlarge => "m5.2xlarge",
            GameServerGroupInstanceType::M54xlarge => "m5.4xlarge",
            GameServerGroupInstanceType::M58xlarge => "m5.8xlarge",
            GameServerGroupInstanceType::M5Large => "m5.large",
            GameServerGroupInstanceType::M5Xlarge => "m5.xlarge",
            GameServerGroupInstanceType::M5a12xlarge => "m5a.12xlarge",
            GameServerGroupInstanceType::M5a16xlarge => "m5a.16xlarge",
            GameServerGroupInstanceType::M5a24xlarge => "m5a.24xlarge",
            GameServerGroupInstanceType::M5a2xlarge => "m5a.2xlarge",
            GameServerGroupInstanceType::M5a4xlarge => "m5a.4xlarge",
            GameServerGroupInstanceType::M5a8xlarge => "m5a.8xlarge",
            GameServerGroupInstanceType::M5aLarge => "m5a.large",
            GameServerGroupInstanceType::M5aXlarge => "m5a.xlarge",
            GameServerGroupInstanceType::M6g12xlarge => "m6g.12xlarge",
            GameServerGroupInstanceType::M6g16xlarge => "m6g.16xlarge",
            GameServerGroupInstanceType::M6g2xlarge => "m6g.2xlarge",
            GameServerGroupInstanceType::M6g4xlarge => "m6g.4xlarge",
            GameServerGroupInstanceType::M6g8xlarge => "m6g.8xlarge",
            GameServerGroupInstanceType::M6gLarge => "m6g.large",
            GameServerGroupInstanceType::M6gMedium => "m6g.medium",
            GameServerGroupInstanceType::M6gXlarge => "m6g.xlarge",
            GameServerGroupInstanceType::R416xlarge => "r4.16xlarge",
            GameServerGroupInstanceType::R42xlarge => "r4.2xlarge",
            GameServerGroupInstanceType::R44xlarge => "r4.4xlarge",
            GameServerGroupInstanceType::R48xlarge => "r4.8xlarge",
            GameServerGroupInstanceType::R4Large => "r4.large",
            GameServerGroupInstanceType::R4Xlarge => "r4.xlarge",
            GameServerGroupInstanceType::R512xlarge => "r5.12xlarge",
            GameServerGroupInstanceType::R516xlarge => "r5.16xlarge",
            GameServerGroupInstanceType::R524xlarge => "r5.24xlarge",
            GameServerGroupInstanceType::R52xlarge => "r5.2xlarge",
            GameServerGroupInstanceType::R54xlarge => "r5.4xlarge",
            GameServerGroupInstanceType::R58xlarge => "r5.8xlarge",
            GameServerGroupInstanceType::R5Large => "r5.large",
            GameServerGroupInstanceType::R5Xlarge => "r5.xlarge",
            GameServerGroupInstanceType::R5a12xlarge => "r5a.12xlarge",
            GameServerGroupInstanceType::R5a16xlarge => "r5a.16xlarge",
            GameServerGroupInstanceType::R5a24xlarge => "r5a.24xlarge",
            GameServerGroupInstanceType::R5a2xlarge => "r5a.2xlarge",
            GameServerGroupInstanceType::R5a4xlarge => "r5a.4xlarge",
            GameServerGroupInstanceType::R5a8xlarge => "r5a.8xlarge",
            GameServerGroupInstanceType::R5aLarge => "r5a.large",
            GameServerGroupInstanceType::R5aXlarge => "r5a.xlarge",
            GameServerGroupInstanceType::R6g12xlarge => "r6g.12xlarge",
            GameServerGroupInstanceType::R6g16xlarge => "r6g.16xlarge",
            GameServerGroupInstanceType::R6g2xlarge => "r6g.2xlarge",
            GameServerGroupInstanceType::R6g4xlarge => "r6g.4xlarge",
            GameServerGroupInstanceType::R6g8xlarge => "r6g.8xlarge",
            GameServerGroupInstanceType::R6gLarge => "r6g.large",
            GameServerGroupInstanceType::R6gMedium => "r6g.medium",
            GameServerGroupInstanceType::R6gXlarge => "r6g.xlarge",
            GameServerGroupInstanceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "c4.2xlarge",
            "c4.4xlarge",
            "c4.8xlarge",
            "c4.large",
            "c4.xlarge",
            "c5.12xlarge",
            "c5.18xlarge",
            "c5.24xlarge",
            "c5.2xlarge",
            "c5.4xlarge",
            "c5.9xlarge",
            "c5.large",
            "c5.xlarge",
            "c5a.12xlarge",
            "c5a.16xlarge",
            "c5a.24xlarge",
            "c5a.2xlarge",
            "c5a.4xlarge",
            "c5a.8xlarge",
            "c5a.large",
            "c5a.xlarge",
            "c6g.12xlarge",
            "c6g.16xlarge",
            "c6g.2xlarge",
            "c6g.4xlarge",
            "c6g.8xlarge",
            "c6g.large",
            "c6g.medium",
            "c6g.xlarge",
            "m4.10xlarge",
            "m4.2xlarge",
            "m4.4xlarge",
            "m4.large",
            "m4.xlarge",
            "m5.12xlarge",
            "m5.16xlarge",
            "m5.24xlarge",
            "m5.2xlarge",
            "m5.4xlarge",
            "m5.8xlarge",
            "m5.large",
            "m5.xlarge",
            "m5a.12xlarge",
            "m5a.16xlarge",
            "m5a.24xlarge",
            "m5a.2xlarge",
            "m5a.4xlarge",
            "m5a.8xlarge",
            "m5a.large",
            "m5a.xlarge",
            "m6g.12xlarge",
            "m6g.16xlarge",
            "m6g.2xlarge",
            "m6g.4xlarge",
            "m6g.8xlarge",
            "m6g.large",
            "m6g.medium",
            "m6g.xlarge",
            "r4.16xlarge",
            "r4.2xlarge",
            "r4.4xlarge",
            "r4.8xlarge",
            "r4.large",
            "r4.xlarge",
            "r5.12xlarge",
            "r5.16xlarge",
            "r5.24xlarge",
            "r5.2xlarge",
            "r5.4xlarge",
            "r5.8xlarge",
            "r5.large",
            "r5.xlarge",
            "r5a.12xlarge",
            "r5a.16xlarge",
            "r5a.24xlarge",
            "r5a.2xlarge",
            "r5a.4xlarge",
            "r5a.8xlarge",
            "r5a.large",
            "r5a.xlarge",
            "r6g.12xlarge",
            "r6g.16xlarge",
            "r6g.2xlarge",
            "r6g.4xlarge",
            "r6g.8xlarge",
            "r6g.large",
            "r6g.medium",
            "r6g.xlarge",
        ]
    }
}
impl AsRef<str> for GameServerGroupInstanceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> <b>This data type is used with the GameLift FleetIQ and game server groups.</b> </p>
/// <p>Properties describing a game server that is running on an instance in a <code>GameServerGroup</code>. </p>
/// <p>A game server is created by a successful call to <code>RegisterGameServer</code> and deleted by calling <code>DeregisterGameServer</code>. A game server is claimed to host a game session by calling <code>ClaimGameServer</code>. </p>
/// <p> <b>Related actions</b> </p>
/// <p> <code>RegisterGameServer</code> | <code>ListGameServers</code> | <code>ClaimGameServer</code> | <code>DescribeGameServer</code> | <code>UpdateGameServer</code> | <code>DeregisterGameServer</code> | <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/reference-awssdk-fleetiq.html">All APIs by task</a> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GameServer {
    /// <p>A unique identifier for the game server group where the game server is running. Use either the <code>GameServerGroup</code> name or ARN value.</p>
    pub game_server_group_name: std::option::Option<std::string::String>,
    /// <p>The ARN identifier for the game server group where the game server is located.</p>
    pub game_server_group_arn: std::option::Option<std::string::String>,
    /// <p>A custom string that uniquely identifies the game server. Game server IDs are developer-defined and are unique across all game server groups in an Amazon Web Services account.</p>
    pub game_server_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the instance where the game server is running. This ID is available in the instance metadata. EC2 instance IDs use a 17-character format, for example: <code>i-1234567890abcdef0</code>.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>The port and IP address that must be used to establish a client connection to the game server.</p>
    pub connection_info: std::option::Option<std::string::String>,
    /// <p>A set of custom game server properties, formatted as a single string value. This data is passed to a game client or service when it requests information on game servers using <code>ListGameServers</code> or <code>ClaimGameServer</code>.</p>
    pub game_server_data: std::option::Option<std::string::String>,
    /// <p>Indicates when an available game server has been reserved for gameplay but has not yet started hosting a game. Once it is claimed, the game server remains in <code>CLAIMED</code> status for a maximum of one minute. During this time, game clients connect to the game server to start the game and trigger the game server to update its utilization status. After one minute, the game server claim status reverts to null.</p>
    pub claim_status: std::option::Option<crate::model::GameServerClaimStatus>,
    /// <p>Indicates whether the game server is currently available for new games or is busy. Possible statuses include:</p>
    /// <ul>
    /// <li> <p> <code>AVAILABLE</code> - The game server is available to be claimed. A game server that has been claimed remains in this status until it reports game hosting activity. </p> </li>
    /// <li> <p> <code>UTILIZED</code> - The game server is currently hosting a game session with players. </p> </li>
    /// </ul>
    pub utilization_status: std::option::Option<crate::model::GameServerUtilizationStatus>,
    /// <p>Timestamp that indicates when the game server was created with a <code>RegisterGameServer</code> request. The format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub registration_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Timestamp that indicates the last time the game server was claimed with a <code>ClaimGameServer</code> request. The format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>). This value is used to calculate when a claimed game server's status should revert to null.</p>
    pub last_claim_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Timestamp that indicates the last time the game server was updated with health status using an <code>UpdateGameServer</code> request. The format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>). After game server registration, this property is only changed when a game server update specifies a health check value.</p>
    pub last_health_check_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl GameServer {
    /// <p>A unique identifier for the game server group where the game server is running. Use either the <code>GameServerGroup</code> name or ARN value.</p>
    pub fn game_server_group_name(&self) -> std::option::Option<&str> {
        self.game_server_group_name.as_deref()
    }
    /// <p>The ARN identifier for the game server group where the game server is located.</p>
    pub fn game_server_group_arn(&self) -> std::option::Option<&str> {
        self.game_server_group_arn.as_deref()
    }
    /// <p>A custom string that uniquely identifies the game server. Game server IDs are developer-defined and are unique across all game server groups in an Amazon Web Services account.</p>
    pub fn game_server_id(&self) -> std::option::Option<&str> {
        self.game_server_id.as_deref()
    }
    /// <p>The unique identifier for the instance where the game server is running. This ID is available in the instance metadata. EC2 instance IDs use a 17-character format, for example: <code>i-1234567890abcdef0</code>.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>The port and IP address that must be used to establish a client connection to the game server.</p>
    pub fn connection_info(&self) -> std::option::Option<&str> {
        self.connection_info.as_deref()
    }
    /// <p>A set of custom game server properties, formatted as a single string value. This data is passed to a game client or service when it requests information on game servers using <code>ListGameServers</code> or <code>ClaimGameServer</code>.</p>
    pub fn game_server_data(&self) -> std::option::Option<&str> {
        self.game_server_data.as_deref()
    }
    /// <p>Indicates when an available game server has been reserved for gameplay but has not yet started hosting a game. Once it is claimed, the game server remains in <code>CLAIMED</code> status for a maximum of one minute. During this time, game clients connect to the game server to start the game and trigger the game server to update its utilization status. After one minute, the game server claim status reverts to null.</p>
    pub fn claim_status(&self) -> std::option::Option<&crate::model::GameServerClaimStatus> {
        self.claim_status.as_ref()
    }
    /// <p>Indicates whether the game server is currently available for new games or is busy. Possible statuses include:</p>
    /// <ul>
    /// <li> <p> <code>AVAILABLE</code> - The game server is available to be claimed. A game server that has been claimed remains in this status until it reports game hosting activity. </p> </li>
    /// <li> <p> <code>UTILIZED</code> - The game server is currently hosting a game session with players. </p> </li>
    /// </ul>
    pub fn utilization_status(
        &self,
    ) -> std::option::Option<&crate::model::GameServerUtilizationStatus> {
        self.utilization_status.as_ref()
    }
    /// <p>Timestamp that indicates when the game server was created with a <code>RegisterGameServer</code> request. The format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub fn registration_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.registration_time.as_ref()
    }
    /// <p>Timestamp that indicates the last time the game server was claimed with a <code>ClaimGameServer</code> request. The format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>). This value is used to calculate when a claimed game server's status should revert to null.</p>
    pub fn last_claim_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_claim_time.as_ref()
    }
    /// <p>Timestamp that indicates the last time the game server was updated with health status using an <code>UpdateGameServer</code> request. The format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>). After game server registration, this property is only changed when a game server update specifies a health check value.</p>
    pub fn last_health_check_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_health_check_time.as_ref()
    }
}
impl std::fmt::Debug for GameServer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GameServer");
        formatter.field("game_server_group_name", &self.game_server_group_name);
        formatter.field("game_server_group_arn", &self.game_server_group_arn);
        formatter.field("game_server_id", &self.game_server_id);
        formatter.field("instance_id", &self.instance_id);
        formatter.field("connection_info", &self.connection_info);
        formatter.field("game_server_data", &self.game_server_data);
        formatter.field("claim_status", &self.claim_status);
        formatter.field("utilization_status", &self.utilization_status);
        formatter.field("registration_time", &self.registration_time);
        formatter.field("last_claim_time", &self.last_claim_time);
        formatter.field("last_health_check_time", &self.last_health_check_time);
        formatter.finish()
    }
}
/// See [`GameServer`](crate::model::GameServer)
pub mod game_server {
    /// A builder for [`GameServer`](crate::model::GameServer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_server_group_name: std::option::Option<std::string::String>,
        pub(crate) game_server_group_arn: std::option::Option<std::string::String>,
        pub(crate) game_server_id: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) connection_info: std::option::Option<std::string::String>,
        pub(crate) game_server_data: std::option::Option<std::string::String>,
        pub(crate) claim_status: std::option::Option<crate::model::GameServerClaimStatus>,
        pub(crate) utilization_status:
            std::option::Option<crate::model::GameServerUtilizationStatus>,
        pub(crate) registration_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_claim_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_health_check_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>A unique identifier for the game server group where the game server is running. Use either the <code>GameServerGroup</code> name or ARN value.</p>
        pub fn game_server_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_server_group_name = Some(input.into());
            self
        }
        /// <p>A unique identifier for the game server group where the game server is running. Use either the <code>GameServerGroup</code> name or ARN value.</p>
        pub fn set_game_server_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_server_group_name = input;
            self
        }
        /// <p>The ARN identifier for the game server group where the game server is located.</p>
        pub fn game_server_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_server_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN identifier for the game server group where the game server is located.</p>
        pub fn set_game_server_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_server_group_arn = input;
            self
        }
        /// <p>A custom string that uniquely identifies the game server. Game server IDs are developer-defined and are unique across all game server groups in an Amazon Web Services account.</p>
        pub fn game_server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_server_id = Some(input.into());
            self
        }
        /// <p>A custom string that uniquely identifies the game server. Game server IDs are developer-defined and are unique across all game server groups in an Amazon Web Services account.</p>
        pub fn set_game_server_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_server_id = input;
            self
        }
        /// <p>The unique identifier for the instance where the game server is running. This ID is available in the instance metadata. EC2 instance IDs use a 17-character format, for example: <code>i-1234567890abcdef0</code>.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the instance where the game server is running. This ID is available in the instance metadata. EC2 instance IDs use a 17-character format, for example: <code>i-1234567890abcdef0</code>.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The port and IP address that must be used to establish a client connection to the game server.</p>
        pub fn connection_info(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_info = Some(input.into());
            self
        }
        /// <p>The port and IP address that must be used to establish a client connection to the game server.</p>
        pub fn set_connection_info(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_info = input;
            self
        }
        /// <p>A set of custom game server properties, formatted as a single string value. This data is passed to a game client or service when it requests information on game servers using <code>ListGameServers</code> or <code>ClaimGameServer</code>.</p>
        pub fn game_server_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_server_data = Some(input.into());
            self
        }
        /// <p>A set of custom game server properties, formatted as a single string value. This data is passed to a game client or service when it requests information on game servers using <code>ListGameServers</code> or <code>ClaimGameServer</code>.</p>
        pub fn set_game_server_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_server_data = input;
            self
        }
        /// <p>Indicates when an available game server has been reserved for gameplay but has not yet started hosting a game. Once it is claimed, the game server remains in <code>CLAIMED</code> status for a maximum of one minute. During this time, game clients connect to the game server to start the game and trigger the game server to update its utilization status. After one minute, the game server claim status reverts to null.</p>
        pub fn claim_status(mut self, input: crate::model::GameServerClaimStatus) -> Self {
            self.claim_status = Some(input);
            self
        }
        /// <p>Indicates when an available game server has been reserved for gameplay but has not yet started hosting a game. Once it is claimed, the game server remains in <code>CLAIMED</code> status for a maximum of one minute. During this time, game clients connect to the game server to start the game and trigger the game server to update its utilization status. After one minute, the game server claim status reverts to null.</p>
        pub fn set_claim_status(
            mut self,
            input: std::option::Option<crate::model::GameServerClaimStatus>,
        ) -> Self {
            self.claim_status = input;
            self
        }
        /// <p>Indicates whether the game server is currently available for new games or is busy. Possible statuses include:</p>
        /// <ul>
        /// <li> <p> <code>AVAILABLE</code> - The game server is available to be claimed. A game server that has been claimed remains in this status until it reports game hosting activity. </p> </li>
        /// <li> <p> <code>UTILIZED</code> - The game server is currently hosting a game session with players. </p> </li>
        /// </ul>
        pub fn utilization_status(
            mut self,
            input: crate::model::GameServerUtilizationStatus,
        ) -> Self {
            self.utilization_status = Some(input);
            self
        }
        /// <p>Indicates whether the game server is currently available for new games or is busy. Possible statuses include:</p>
        /// <ul>
        /// <li> <p> <code>AVAILABLE</code> - The game server is available to be claimed. A game server that has been claimed remains in this status until it reports game hosting activity. </p> </li>
        /// <li> <p> <code>UTILIZED</code> - The game server is currently hosting a game session with players. </p> </li>
        /// </ul>
        pub fn set_utilization_status(
            mut self,
            input: std::option::Option<crate::model::GameServerUtilizationStatus>,
        ) -> Self {
            self.utilization_status = input;
            self
        }
        /// <p>Timestamp that indicates when the game server was created with a <code>RegisterGameServer</code> request. The format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn registration_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.registration_time = Some(input);
            self
        }
        /// <p>Timestamp that indicates when the game server was created with a <code>RegisterGameServer</code> request. The format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn set_registration_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.registration_time = input;
            self
        }
        /// <p>Timestamp that indicates the last time the game server was claimed with a <code>ClaimGameServer</code> request. The format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>). This value is used to calculate when a claimed game server's status should revert to null.</p>
        pub fn last_claim_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_claim_time = Some(input);
            self
        }
        /// <p>Timestamp that indicates the last time the game server was claimed with a <code>ClaimGameServer</code> request. The format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>). This value is used to calculate when a claimed game server's status should revert to null.</p>
        pub fn set_last_claim_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_claim_time = input;
            self
        }
        /// <p>Timestamp that indicates the last time the game server was updated with health status using an <code>UpdateGameServer</code> request. The format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>). After game server registration, this property is only changed when a game server update specifies a health check value.</p>
        pub fn last_health_check_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_health_check_time = Some(input);
            self
        }
        /// <p>Timestamp that indicates the last time the game server was updated with health status using an <code>UpdateGameServer</code> request. The format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>). After game server registration, this property is only changed when a game server update specifies a health check value.</p>
        pub fn set_last_health_check_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_health_check_time = input;
            self
        }
        /// Consumes the builder and constructs a [`GameServer`](crate::model::GameServer)
        pub fn build(self) -> crate::model::GameServer {
            crate::model::GameServer {
                game_server_group_name: self.game_server_group_name,
                game_server_group_arn: self.game_server_group_arn,
                game_server_id: self.game_server_id,
                instance_id: self.instance_id,
                connection_info: self.connection_info,
                game_server_data: self.game_server_data,
                claim_status: self.claim_status,
                utilization_status: self.utilization_status,
                registration_time: self.registration_time,
                last_claim_time: self.last_claim_time,
                last_health_check_time: self.last_health_check_time,
            }
        }
    }
}
impl GameServer {
    /// Creates a new builder-style object to manufacture [`GameServer`](crate::model::GameServer)
    pub fn builder() -> crate::model::game_server::Builder {
        crate::model::game_server::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GameServerUtilizationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Utilized,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GameServerUtilizationStatus {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => GameServerUtilizationStatus::Available,
            "UTILIZED" => GameServerUtilizationStatus::Utilized,
            other => GameServerUtilizationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GameServerUtilizationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GameServerUtilizationStatus::from(s))
    }
}
impl GameServerUtilizationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GameServerUtilizationStatus::Available => "AVAILABLE",
            GameServerUtilizationStatus::Utilized => "UTILIZED",
            GameServerUtilizationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "UTILIZED"]
    }
}
impl AsRef<str> for GameServerUtilizationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GameServerClaimStatus {
    #[allow(missing_docs)] // documentation missing in model
    Claimed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GameServerClaimStatus {
    fn from(s: &str) -> Self {
        match s {
            "CLAIMED" => GameServerClaimStatus::Claimed,
            other => GameServerClaimStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GameServerClaimStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GameServerClaimStatus::from(s))
    }
}
impl GameServerClaimStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GameServerClaimStatus::Claimed => "CLAIMED",
            GameServerClaimStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CLAIMED"]
    }
}
impl AsRef<str> for GameServerClaimStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GameServerHealthCheck {
    #[allow(missing_docs)] // documentation missing in model
    Healthy,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GameServerHealthCheck {
    fn from(s: &str) -> Self {
        match s {
            "HEALTHY" => GameServerHealthCheck::Healthy,
            other => GameServerHealthCheck::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GameServerHealthCheck {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GameServerHealthCheck::from(s))
    }
}
impl GameServerHealthCheck {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GameServerHealthCheck::Healthy => "HEALTHY",
            GameServerHealthCheck::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HEALTHY"]
    }
}
impl AsRef<str> for GameServerHealthCheck {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A range of IP addresses and port settings that allow inbound traffic to connect to server processes on an instance in a fleet. New game sessions are assigned an IP address/port number combination, which must fall into the fleet's allowed ranges. Fleets with custom game builds must have permissions explicitly set. For Realtime Servers fleets, GameLift automatically opens two port ranges, one for TCP messaging and one for UDP.</p>
/// <p> <b>Related actions</b> </p>
/// <p> <code>DescribeFleetPortSettings</code> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IpPermission {
    /// <p>A starting value for a range of allowed port numbers.</p>
    /// <p>For fleets using Windows and Linux builds, only ports 1026-60000 are valid.</p>
    pub from_port: std::option::Option<i32>,
    /// <p>An ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than <code>FromPort</code>.</p>
    /// <p>For fleets using Windows and Linux builds, only ports 1026-60000 are valid.</p>
    pub to_port: std::option::Option<i32>,
    /// <p>A range of allowed IP addresses. This value must be expressed in CIDR notation. Example: "<code>000.000.000.000/[subnet mask]</code>" or optionally the shortened version "<code>0.0.0.0/[subnet mask]</code>".</p>
    pub ip_range: std::option::Option<std::string::String>,
    /// <p>The network communication protocol used by the fleet.</p>
    pub protocol: std::option::Option<crate::model::IpProtocol>,
}
impl IpPermission {
    /// <p>A starting value for a range of allowed port numbers.</p>
    /// <p>For fleets using Windows and Linux builds, only ports 1026-60000 are valid.</p>
    pub fn from_port(&self) -> std::option::Option<i32> {
        self.from_port
    }
    /// <p>An ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than <code>FromPort</code>.</p>
    /// <p>For fleets using Windows and Linux builds, only ports 1026-60000 are valid.</p>
    pub fn to_port(&self) -> std::option::Option<i32> {
        self.to_port
    }
    /// <p>A range of allowed IP addresses. This value must be expressed in CIDR notation. Example: "<code>000.000.000.000/[subnet mask]</code>" or optionally the shortened version "<code>0.0.0.0/[subnet mask]</code>".</p>
    pub fn ip_range(&self) -> std::option::Option<&str> {
        self.ip_range.as_deref()
    }
    /// <p>The network communication protocol used by the fleet.</p>
    pub fn protocol(&self) -> std::option::Option<&crate::model::IpProtocol> {
        self.protocol.as_ref()
    }
}
impl std::fmt::Debug for IpPermission {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IpPermission");
        formatter.field("from_port", &self.from_port);
        formatter.field("to_port", &self.to_port);
        formatter.field("ip_range", &self.ip_range);
        formatter.field("protocol", &self.protocol);
        formatter.finish()
    }
}
/// See [`IpPermission`](crate::model::IpPermission)
pub mod ip_permission {
    /// A builder for [`IpPermission`](crate::model::IpPermission)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) from_port: std::option::Option<i32>,
        pub(crate) to_port: std::option::Option<i32>,
        pub(crate) ip_range: std::option::Option<std::string::String>,
        pub(crate) protocol: std::option::Option<crate::model::IpProtocol>,
    }
    impl Builder {
        /// <p>A starting value for a range of allowed port numbers.</p>
        /// <p>For fleets using Windows and Linux builds, only ports 1026-60000 are valid.</p>
        pub fn from_port(mut self, input: i32) -> Self {
            self.from_port = Some(input);
            self
        }
        /// <p>A starting value for a range of allowed port numbers.</p>
        /// <p>For fleets using Windows and Linux builds, only ports 1026-60000 are valid.</p>
        pub fn set_from_port(mut self, input: std::option::Option<i32>) -> Self {
            self.from_port = input;
            self
        }
        /// <p>An ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than <code>FromPort</code>.</p>
        /// <p>For fleets using Windows and Linux builds, only ports 1026-60000 are valid.</p>
        pub fn to_port(mut self, input: i32) -> Self {
            self.to_port = Some(input);
            self
        }
        /// <p>An ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than <code>FromPort</code>.</p>
        /// <p>For fleets using Windows and Linux builds, only ports 1026-60000 are valid.</p>
        pub fn set_to_port(mut self, input: std::option::Option<i32>) -> Self {
            self.to_port = input;
            self
        }
        /// <p>A range of allowed IP addresses. This value must be expressed in CIDR notation. Example: "<code>000.000.000.000/[subnet mask]</code>" or optionally the shortened version "<code>0.0.0.0/[subnet mask]</code>".</p>
        pub fn ip_range(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_range = Some(input.into());
            self
        }
        /// <p>A range of allowed IP addresses. This value must be expressed in CIDR notation. Example: "<code>000.000.000.000/[subnet mask]</code>" or optionally the shortened version "<code>0.0.0.0/[subnet mask]</code>".</p>
        pub fn set_ip_range(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_range = input;
            self
        }
        /// <p>The network communication protocol used by the fleet.</p>
        pub fn protocol(mut self, input: crate::model::IpProtocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>The network communication protocol used by the fleet.</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::IpProtocol>,
        ) -> Self {
            self.protocol = input;
            self
        }
        /// Consumes the builder and constructs a [`IpPermission`](crate::model::IpPermission)
        pub fn build(self) -> crate::model::IpPermission {
            crate::model::IpPermission {
                from_port: self.from_port,
                to_port: self.to_port,
                ip_range: self.ip_range,
                protocol: self.protocol,
            }
        }
    }
}
impl IpPermission {
    /// Creates a new builder-style object to manufacture [`IpPermission`](crate::model::IpPermission)
    pub fn builder() -> crate::model::ip_permission::Builder {
        crate::model::ip_permission::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IpProtocol {
    #[allow(missing_docs)] // documentation missing in model
    Tcp,
    #[allow(missing_docs)] // documentation missing in model
    Udp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IpProtocol {
    fn from(s: &str) -> Self {
        match s {
            "TCP" => IpProtocol::Tcp,
            "UDP" => IpProtocol::Udp,
            other => IpProtocol::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IpProtocol {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IpProtocol::from(s))
    }
}
impl IpProtocol {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IpProtocol::Tcp => "TCP",
            IpProtocol::Udp => "UDP",
            IpProtocol::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["TCP", "UDP"]
    }
}
impl AsRef<str> for IpProtocol {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A policy that puts limits on the number of game sessions that a player can create within a specified span of time. With this policy, you can control players' ability to consume available resources.</p>
/// <p>The policy is evaluated when a player tries to create a new game session. On receiving a <code>CreateGameSession</code> request, GameLift checks that the player (identified by <code>CreatorId</code>) has created fewer than game session limit in the specified time period.</p>
/// <p>The resource creation limit policy is included in <code>FleetAttributes</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceCreationLimitPolicy {
    /// <p>The maximum number of game sessions that an individual can create during the policy period. </p>
    pub new_game_sessions_per_creator: std::option::Option<i32>,
    /// <p>The time span used in evaluating the resource creation limit policy. </p>
    pub policy_period_in_minutes: std::option::Option<i32>,
}
impl ResourceCreationLimitPolicy {
    /// <p>The maximum number of game sessions that an individual can create during the policy period. </p>
    pub fn new_game_sessions_per_creator(&self) -> std::option::Option<i32> {
        self.new_game_sessions_per_creator
    }
    /// <p>The time span used in evaluating the resource creation limit policy. </p>
    pub fn policy_period_in_minutes(&self) -> std::option::Option<i32> {
        self.policy_period_in_minutes
    }
}
impl std::fmt::Debug for ResourceCreationLimitPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceCreationLimitPolicy");
        formatter.field(
            "new_game_sessions_per_creator",
            &self.new_game_sessions_per_creator,
        );
        formatter.field("policy_period_in_minutes", &self.policy_period_in_minutes);
        formatter.finish()
    }
}
/// See [`ResourceCreationLimitPolicy`](crate::model::ResourceCreationLimitPolicy)
pub mod resource_creation_limit_policy {
    /// A builder for [`ResourceCreationLimitPolicy`](crate::model::ResourceCreationLimitPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) new_game_sessions_per_creator: std::option::Option<i32>,
        pub(crate) policy_period_in_minutes: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The maximum number of game sessions that an individual can create during the policy period. </p>
        pub fn new_game_sessions_per_creator(mut self, input: i32) -> Self {
            self.new_game_sessions_per_creator = Some(input);
            self
        }
        /// <p>The maximum number of game sessions that an individual can create during the policy period. </p>
        pub fn set_new_game_sessions_per_creator(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.new_game_sessions_per_creator = input;
            self
        }
        /// <p>The time span used in evaluating the resource creation limit policy. </p>
        pub fn policy_period_in_minutes(mut self, input: i32) -> Self {
            self.policy_period_in_minutes = Some(input);
            self
        }
        /// <p>The time span used in evaluating the resource creation limit policy. </p>
        pub fn set_policy_period_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.policy_period_in_minutes = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceCreationLimitPolicy`](crate::model::ResourceCreationLimitPolicy)
        pub fn build(self) -> crate::model::ResourceCreationLimitPolicy {
            crate::model::ResourceCreationLimitPolicy {
                new_game_sessions_per_creator: self.new_game_sessions_per_creator,
                policy_period_in_minutes: self.policy_period_in_minutes,
            }
        }
    }
}
impl ResourceCreationLimitPolicy {
    /// Creates a new builder-style object to manufacture [`ResourceCreationLimitPolicy`](crate::model::ResourceCreationLimitPolicy)
    pub fn builder() -> crate::model::resource_creation_limit_policy::Builder {
        crate::model::resource_creation_limit_policy::Builder::default()
    }
}

/// <p>Properties describing a custom game build.</p>
/// <p> <b>Related actions</b> </p>
/// <p> <code>CreateBuild</code> | <code>ListBuilds</code> | <code>DescribeBuild</code> | <code>UpdateBuild</code> | <code>DeleteBuild</code> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Build {
    /// <p>A unique identifier for the build.</p>
    pub build_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift build resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::build/build-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
    /// </region></code>. In a GameLift build ARN, the resource ID matches the <i>BuildId</i> value.</p>
    pub build_arn: std::option::Option<std::string::String>,
    /// <p>A descriptive label that is associated with a build. Build names do not need to be unique. It can be set using <code>CreateBuild</code> or <code>UpdateBuild</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Version information that is associated with a build or script. Version strings do not need to be unique. This value can be set using <code>CreateBuild</code> or <code>UpdateBuild</code>.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>Current status of the build.</p>
    /// <p>Possible build statuses include the following:</p>
    /// <ul>
    /// <li> <p> <b>INITIALIZED</b> -- A new build has been defined, but no files have been uploaded. You cannot create fleets for builds that are in this status. When a build is successfully created, the build status is set to this value. </p> </li>
    /// <li> <p> <b>READY</b> -- The game build has been successfully uploaded. You can now create new fleets for this build.</p> </li>
    /// <li> <p> <b>FAILED</b> -- The game build upload failed. You cannot create new fleets for this build. </p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::BuildStatus>,
    /// <p>File size of the uploaded game build, expressed in bytes. When the build status is <code>INITIALIZED</code> or when using a custom Amazon S3 storage location, this value is 0.</p>
    pub size_on_disk: std::option::Option<i64>,
    /// <p>Operating system that the game server binaries are built to run on. This value determines the type of fleet resources that you can use for this build.</p>
    pub operating_system: std::option::Option<crate::model::OperatingSystem>,
    /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl Build {
    /// <p>A unique identifier for the build.</p>
    pub fn build_id(&self) -> std::option::Option<&str> {
        self.build_id.as_deref()
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift build resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::build/build-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
    /// </region></code>. In a GameLift build ARN, the resource ID matches the <i>BuildId</i> value.</p>
    pub fn build_arn(&self) -> std::option::Option<&str> {
        self.build_arn.as_deref()
    }
    /// <p>A descriptive label that is associated with a build. Build names do not need to be unique. It can be set using <code>CreateBuild</code> or <code>UpdateBuild</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Version information that is associated with a build or script. Version strings do not need to be unique. This value can be set using <code>CreateBuild</code> or <code>UpdateBuild</code>.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>Current status of the build.</p>
    /// <p>Possible build statuses include the following:</p>
    /// <ul>
    /// <li> <p> <b>INITIALIZED</b> -- A new build has been defined, but no files have been uploaded. You cannot create fleets for builds that are in this status. When a build is successfully created, the build status is set to this value. </p> </li>
    /// <li> <p> <b>READY</b> -- The game build has been successfully uploaded. You can now create new fleets for this build.</p> </li>
    /// <li> <p> <b>FAILED</b> -- The game build upload failed. You cannot create new fleets for this build. </p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::BuildStatus> {
        self.status.as_ref()
    }
    /// <p>File size of the uploaded game build, expressed in bytes. When the build status is <code>INITIALIZED</code> or when using a custom Amazon S3 storage location, this value is 0.</p>
    pub fn size_on_disk(&self) -> std::option::Option<i64> {
        self.size_on_disk
    }
    /// <p>Operating system that the game server binaries are built to run on. This value determines the type of fleet resources that you can use for this build.</p>
    pub fn operating_system(&self) -> std::option::Option<&crate::model::OperatingSystem> {
        self.operating_system.as_ref()
    }
    /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
}
impl std::fmt::Debug for Build {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Build");
        formatter.field("build_id", &self.build_id);
        formatter.field("build_arn", &self.build_arn);
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.field("status", &self.status);
        formatter.field("size_on_disk", &self.size_on_disk);
        formatter.field("operating_system", &self.operating_system);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`Build`](crate::model::Build)
pub mod build {
    /// A builder for [`Build`](crate::model::Build)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) build_id: std::option::Option<std::string::String>,
        pub(crate) build_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::BuildStatus>,
        pub(crate) size_on_disk: std::option::Option<i64>,
        pub(crate) operating_system: std::option::Option<crate::model::OperatingSystem>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>A unique identifier for the build.</p>
        pub fn build_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.build_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the build.</p>
        pub fn set_build_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.build_id = input;
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift build resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::build/build-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
        /// </region></code>. In a GameLift build ARN, the resource ID matches the <i>BuildId</i> value.</p>
        pub fn build_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.build_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift build resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::build/build-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
        /// </region></code>. In a GameLift build ARN, the resource ID matches the <i>BuildId</i> value.</p>
        pub fn set_build_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.build_arn = input;
            self
        }
        /// <p>A descriptive label that is associated with a build. Build names do not need to be unique. It can be set using <code>CreateBuild</code> or <code>UpdateBuild</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A descriptive label that is associated with a build. Build names do not need to be unique. It can be set using <code>CreateBuild</code> or <code>UpdateBuild</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Version information that is associated with a build or script. Version strings do not need to be unique. This value can be set using <code>CreateBuild</code> or <code>UpdateBuild</code>.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>Version information that is associated with a build or script. Version strings do not need to be unique. This value can be set using <code>CreateBuild</code> or <code>UpdateBuild</code>.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>Current status of the build.</p>
        /// <p>Possible build statuses include the following:</p>
        /// <ul>
        /// <li> <p> <b>INITIALIZED</b> -- A new build has been defined, but no files have been uploaded. You cannot create fleets for builds that are in this status. When a build is successfully created, the build status is set to this value. </p> </li>
        /// <li> <p> <b>READY</b> -- The game build has been successfully uploaded. You can now create new fleets for this build.</p> </li>
        /// <li> <p> <b>FAILED</b> -- The game build upload failed. You cannot create new fleets for this build. </p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::BuildStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Current status of the build.</p>
        /// <p>Possible build statuses include the following:</p>
        /// <ul>
        /// <li> <p> <b>INITIALIZED</b> -- A new build has been defined, but no files have been uploaded. You cannot create fleets for builds that are in this status. When a build is successfully created, the build status is set to this value. </p> </li>
        /// <li> <p> <b>READY</b> -- The game build has been successfully uploaded. You can now create new fleets for this build.</p> </li>
        /// <li> <p> <b>FAILED</b> -- The game build upload failed. You cannot create new fleets for this build. </p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<crate::model::BuildStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>File size of the uploaded game build, expressed in bytes. When the build status is <code>INITIALIZED</code> or when using a custom Amazon S3 storage location, this value is 0.</p>
        pub fn size_on_disk(mut self, input: i64) -> Self {
            self.size_on_disk = Some(input);
            self
        }
        /// <p>File size of the uploaded game build, expressed in bytes. When the build status is <code>INITIALIZED</code> or when using a custom Amazon S3 storage location, this value is 0.</p>
        pub fn set_size_on_disk(mut self, input: std::option::Option<i64>) -> Self {
            self.size_on_disk = input;
            self
        }
        /// <p>Operating system that the game server binaries are built to run on. This value determines the type of fleet resources that you can use for this build.</p>
        pub fn operating_system(mut self, input: crate::model::OperatingSystem) -> Self {
            self.operating_system = Some(input);
            self
        }
        /// <p>Operating system that the game server binaries are built to run on. This value determines the type of fleet resources that you can use for this build.</p>
        pub fn set_operating_system(
            mut self,
            input: std::option::Option<crate::model::OperatingSystem>,
        ) -> Self {
            self.operating_system = input;
            self
        }
        /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Build`](crate::model::Build)
        pub fn build(self) -> crate::model::Build {
            crate::model::Build {
                build_id: self.build_id,
                build_arn: self.build_arn,
                name: self.name,
                version: self.version,
                status: self.status,
                size_on_disk: self.size_on_disk,
                operating_system: self.operating_system,
                creation_time: self.creation_time,
            }
        }
    }
}
impl Build {
    /// Creates a new builder-style object to manufacture [`Build`](crate::model::Build)
    pub fn builder() -> crate::model::build::Builder {
        crate::model::build::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OperatingSystem {
    #[allow(missing_docs)] // documentation missing in model
    AmazonLinux,
    #[allow(missing_docs)] // documentation missing in model
    AmazonLinux2,
    #[allow(missing_docs)] // documentation missing in model
    Windows2012,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OperatingSystem {
    fn from(s: &str) -> Self {
        match s {
            "AMAZON_LINUX" => OperatingSystem::AmazonLinux,
            "AMAZON_LINUX_2" => OperatingSystem::AmazonLinux2,
            "WINDOWS_2012" => OperatingSystem::Windows2012,
            other => OperatingSystem::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OperatingSystem {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OperatingSystem::from(s))
    }
}
impl OperatingSystem {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OperatingSystem::AmazonLinux => "AMAZON_LINUX",
            OperatingSystem::AmazonLinux2 => "AMAZON_LINUX_2",
            OperatingSystem::Windows2012 => "WINDOWS_2012",
            OperatingSystem::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AMAZON_LINUX", "AMAZON_LINUX_2", "WINDOWS_2012"]
    }
}
impl AsRef<str> for OperatingSystem {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BuildStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Initialized,
    #[allow(missing_docs)] // documentation missing in model
    Ready,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BuildStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => BuildStatus::Failed,
            "INITIALIZED" => BuildStatus::Initialized,
            "READY" => BuildStatus::Ready,
            other => BuildStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BuildStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BuildStatus::from(s))
    }
}
impl BuildStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BuildStatus::Failed => "FAILED",
            BuildStatus::Initialized => "INITIALIZED",
            BuildStatus::Ready => "READY",
            BuildStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "INITIALIZED", "READY"]
    }
}
impl AsRef<str> for BuildStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Properties that describe an alias resource.</p>
/// <p> <b>Related actions</b> </p>
/// <p> <code>CreateAlias</code> | <code>ListAliases</code> | <code>DescribeAlias</code> | <code>UpdateAlias</code> | <code>DeleteAlias</code> | <code>ResolveAlias</code> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Alias {
    /// <p>A unique identifier for the alias. Alias IDs are unique within a Region.</p>
    pub alias_id: std::option::Option<std::string::String>,
    /// <p>A descriptive label that is associated with an alias. Alias names do not need to be unique.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift alias resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::alias/alias-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
    /// </region></code>. In a GameLift alias ARN, the resource ID matches the alias ID value.</p>
    pub alias_arn: std::option::Option<std::string::String>,
    /// <p>A human-readable description of an alias.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The routing configuration, including routing type and fleet target, for the alias. </p>
    pub routing_strategy: std::option::Option<crate::model::RoutingStrategy>,
    /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time that this data object was last modified. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl Alias {
    /// <p>A unique identifier for the alias. Alias IDs are unique within a Region.</p>
    pub fn alias_id(&self) -> std::option::Option<&str> {
        self.alias_id.as_deref()
    }
    /// <p>A descriptive label that is associated with an alias. Alias names do not need to be unique.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift alias resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::alias/alias-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
    /// </region></code>. In a GameLift alias ARN, the resource ID matches the alias ID value.</p>
    pub fn alias_arn(&self) -> std::option::Option<&str> {
        self.alias_arn.as_deref()
    }
    /// <p>A human-readable description of an alias.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The routing configuration, including routing type and fleet target, for the alias. </p>
    pub fn routing_strategy(&self) -> std::option::Option<&crate::model::RoutingStrategy> {
        self.routing_strategy.as_ref()
    }
    /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The time that this data object was last modified. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
}
impl std::fmt::Debug for Alias {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Alias");
        formatter.field("alias_id", &self.alias_id);
        formatter.field("name", &self.name);
        formatter.field("alias_arn", &self.alias_arn);
        formatter.field("description", &self.description);
        formatter.field("routing_strategy", &self.routing_strategy);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.finish()
    }
}
/// See [`Alias`](crate::model::Alias)
pub mod alias {
    /// A builder for [`Alias`](crate::model::Alias)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alias_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) alias_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) routing_strategy: std::option::Option<crate::model::RoutingStrategy>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>A unique identifier for the alias. Alias IDs are unique within a Region.</p>
        pub fn alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the alias. Alias IDs are unique within a Region.</p>
        pub fn set_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_id = input;
            self
        }
        /// <p>A descriptive label that is associated with an alias. Alias names do not need to be unique.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A descriptive label that is associated with an alias. Alias names do not need to be unique.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift alias resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::alias/alias-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
        /// </region></code>. In a GameLift alias ARN, the resource ID matches the alias ID value.</p>
        pub fn alias_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift alias resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::alias/alias-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
        /// </region></code>. In a GameLift alias ARN, the resource ID matches the alias ID value.</p>
        pub fn set_alias_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_arn = input;
            self
        }
        /// <p>A human-readable description of an alias.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A human-readable description of an alias.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The routing configuration, including routing type and fleet target, for the alias. </p>
        pub fn routing_strategy(mut self, input: crate::model::RoutingStrategy) -> Self {
            self.routing_strategy = Some(input);
            self
        }
        /// <p>The routing configuration, including routing type and fleet target, for the alias. </p>
        pub fn set_routing_strategy(
            mut self,
            input: std::option::Option<crate::model::RoutingStrategy>,
        ) -> Self {
            self.routing_strategy = input;
            self
        }
        /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time that this data object was last modified. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The time that this data object was last modified. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Alias`](crate::model::Alias)
        pub fn build(self) -> crate::model::Alias {
            crate::model::Alias {
                alias_id: self.alias_id,
                name: self.name,
                alias_arn: self.alias_arn,
                description: self.description,
                routing_strategy: self.routing_strategy,
                creation_time: self.creation_time,
                last_updated_time: self.last_updated_time,
            }
        }
    }
}
impl Alias {
    /// Creates a new builder-style object to manufacture [`Alias`](crate::model::Alias)
    pub fn builder() -> crate::model::alias::Builder {
        crate::model::alias::Builder::default()
    }
}

/// <p>The routing configuration for a fleet alias.</p>
/// <p> <b>Related actions</b> </p>
/// <p> <code>CreateAlias</code> | <code>ListAliases</code> | <code>DescribeAlias</code> | <code>UpdateAlias</code> | <code>DeleteAlias</code> | <code>ResolveAlias</code> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RoutingStrategy {
    /// <p>The type of routing strategy for the alias.</p>
    /// <p>Possible routing types include the following:</p>
    /// <ul>
    /// <li> <p> <b>SIMPLE</b> - The alias resolves to one specific fleet. Use this type when routing to active fleets.</p> </li>
    /// <li> <p> <b>TERMINAL</b> - The alias does not resolve to a fleet but instead can be used to display a message to the user. A terminal alias throws a TerminalRoutingStrategyException with the <code>RoutingStrategy</code> message embedded.</p> </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::RoutingStrategyType>,
    /// <p>A unique identifier for the fleet that the alias points to. This value is the fleet ID, not the fleet ARN.</p>
    pub fleet_id: std::option::Option<std::string::String>,
    /// <p>The message text to be used with a terminal routing strategy.</p>
    pub message: std::option::Option<std::string::String>,
}
impl RoutingStrategy {
    /// <p>The type of routing strategy for the alias.</p>
    /// <p>Possible routing types include the following:</p>
    /// <ul>
    /// <li> <p> <b>SIMPLE</b> - The alias resolves to one specific fleet. Use this type when routing to active fleets.</p> </li>
    /// <li> <p> <b>TERMINAL</b> - The alias does not resolve to a fleet but instead can be used to display a message to the user. A terminal alias throws a TerminalRoutingStrategyException with the <code>RoutingStrategy</code> message embedded.</p> </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::RoutingStrategyType> {
        self.r#type.as_ref()
    }
    /// <p>A unique identifier for the fleet that the alias points to. This value is the fleet ID, not the fleet ARN.</p>
    pub fn fleet_id(&self) -> std::option::Option<&str> {
        self.fleet_id.as_deref()
    }
    /// <p>The message text to be used with a terminal routing strategy.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for RoutingStrategy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RoutingStrategy");
        formatter.field("r#type", &self.r#type);
        formatter.field("fleet_id", &self.fleet_id);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`RoutingStrategy`](crate::model::RoutingStrategy)
pub mod routing_strategy {
    /// A builder for [`RoutingStrategy`](crate::model::RoutingStrategy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::RoutingStrategyType>,
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of routing strategy for the alias.</p>
        /// <p>Possible routing types include the following:</p>
        /// <ul>
        /// <li> <p> <b>SIMPLE</b> - The alias resolves to one specific fleet. Use this type when routing to active fleets.</p> </li>
        /// <li> <p> <b>TERMINAL</b> - The alias does not resolve to a fleet but instead can be used to display a message to the user. A terminal alias throws a TerminalRoutingStrategyException with the <code>RoutingStrategy</code> message embedded.</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::RoutingStrategyType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of routing strategy for the alias.</p>
        /// <p>Possible routing types include the following:</p>
        /// <ul>
        /// <li> <p> <b>SIMPLE</b> - The alias resolves to one specific fleet. Use this type when routing to active fleets.</p> </li>
        /// <li> <p> <b>TERMINAL</b> - The alias does not resolve to a fleet but instead can be used to display a message to the user. A terminal alias throws a TerminalRoutingStrategyException with the <code>RoutingStrategy</code> message embedded.</p> </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::RoutingStrategyType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>A unique identifier for the fleet that the alias points to. This value is the fleet ID, not the fleet ARN.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet that the alias points to. This value is the fleet ID, not the fleet ARN.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p>The message text to be used with a terminal routing strategy.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message text to be used with a terminal routing strategy.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RoutingStrategy`](crate::model::RoutingStrategy)
        pub fn build(self) -> crate::model::RoutingStrategy {
            crate::model::RoutingStrategy {
                r#type: self.r#type,
                fleet_id: self.fleet_id,
                message: self.message,
            }
        }
    }
}
impl RoutingStrategy {
    /// Creates a new builder-style object to manufacture [`RoutingStrategy`](crate::model::RoutingStrategy)
    pub fn builder() -> crate::model::routing_strategy::Builder {
        crate::model::routing_strategy::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RoutingStrategyType {
    #[allow(missing_docs)] // documentation missing in model
    Simple,
    #[allow(missing_docs)] // documentation missing in model
    Terminal,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RoutingStrategyType {
    fn from(s: &str) -> Self {
        match s {
            "SIMPLE" => RoutingStrategyType::Simple,
            "TERMINAL" => RoutingStrategyType::Terminal,
            other => RoutingStrategyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RoutingStrategyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RoutingStrategyType::from(s))
    }
}
impl RoutingStrategyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RoutingStrategyType::Simple => "SIMPLE",
            RoutingStrategyType::Terminal => "TERMINAL",
            RoutingStrategyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SIMPLE", "TERMINAL"]
    }
}
impl AsRef<str> for RoutingStrategyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> A label that can be assigned to a GameLift resource. </p>
/// <p> <b>Learn more</b> </p>
/// <p> <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a> in the <i>Amazon Web Services General Reference</i> </p>
/// <p> <a href="http://aws.amazon.com/answers/account-management/aws-tagging-strategies/"> Amazon Web Services Tagging Strategies</a> </p>
/// <p> <b>Related actions</b> </p>
/// <p> <code>TagResource</code> | <code>UntagResource</code> | <code>ListTagsForResource</code> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p> The key for a developer-defined key:value pair for tagging an Amazon Web Services resource. </p>
    pub key: std::option::Option<std::string::String>,
    /// <p> The value for a developer-defined key:value pair for tagging an Amazon Web Services resource. </p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p> The key for a developer-defined key:value pair for tagging an Amazon Web Services resource. </p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p> The value for a developer-defined key:value pair for tagging an Amazon Web Services resource. </p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The key for a developer-defined key:value pair for tagging an Amazon Web Services resource. </p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p> The key for a developer-defined key:value pair for tagging an Amazon Web Services resource. </p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p> The value for a developer-defined key:value pair for tagging an Amazon Web Services resource. </p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p> The value for a developer-defined key:value pair for tagging an Amazon Web Services resource. </p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Object that describes a <code>StartGameSessionPlacement</code> request. This object includes the full details of the original request plus the current status and start/end time stamps.</p>
/// <p>Game session placement-related operations include:</p>
/// <ul>
/// <li> <p> <code>StartGameSessionPlacement</code> </p> </li>
/// <li> <p> <code>DescribeGameSessionPlacement</code> </p> </li>
/// <li> <p> <code>StopGameSessionPlacement</code> </p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GameSessionPlacement {
    /// <p>A unique identifier for a game session placement.</p>
    pub placement_id: std::option::Option<std::string::String>,
    /// <p>A descriptive label that is associated with game session queue. Queue names must be unique within each Region.</p>
    pub game_session_queue_name: std::option::Option<std::string::String>,
    /// <p>Current status of the game session placement request.</p>
    /// <ul>
    /// <li> <p> <b>PENDING</b> -- The placement request is currently in the queue waiting to be processed.</p> </li>
    /// <li> <p> <b>FULFILLED</b> -- A new game session and player sessions (if requested) have been successfully created. Values for <i>GameSessionArn</i> and <i>GameSessionRegion</i> are available. </p> </li>
    /// <li> <p> <b>CANCELLED</b> -- The placement request was canceled with a call to <code>StopGameSessionPlacement</code>.</p> </li>
    /// <li> <p> <b>TIMED_OUT</b> -- A new game session was not successfully created before the time limit expired. You can resubmit the placement request as needed.</p> </li>
    /// <li> <p> <b>FAILED</b> -- GameLift is not able to complete the process of placing the game session. Common reasons are the game session terminated before the placement process was completed, or an unexpected internal error.</p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::GameSessionPlacementState>,
    /// <p>A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>).</p>
    pub game_properties: std::option::Option<std::vec::Vec<crate::model::GameProperty>>,
    /// <p>The maximum number of players that can be connected simultaneously to the game session.</p>
    pub maximum_player_session_count: std::option::Option<i32>,
    /// <p>A descriptive label that is associated with a game session. Session names do not need to be unique.</p>
    pub game_session_name: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the game session. This value is set once the new game session is placed (placement status is <code>FULFILLED</code>).</p>
    pub game_session_id: std::option::Option<std::string::String>,
    /// <p>Identifier for the game session created by this placement request. This value is set once the new game session is placed (placement status is <code>FULFILLED</code>). This identifier is unique across all Regions. You can use this value as a <code>GameSessionId</code> value as needed.</p>
    pub game_session_arn: std::option::Option<std::string::String>,
    /// <p>Name of the Region where the game session created by this placement request is running. This value is set once the new game session is placed (placement status is <code>FULFILLED</code>).</p>
    pub game_session_region: std::option::Option<std::string::String>,
    /// <p>A set of values, expressed in milliseconds, that indicates the amount of latency that a player experiences when connected to @aws; Regions.</p>
    pub player_latencies: std::option::Option<std::vec::Vec<crate::model::PlayerLatency>>,
    /// <p>Time stamp indicating when this request was placed in the queue. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Time stamp indicating when this request was completed, canceled, or timed out.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The IP address of the game session. To connect to a GameLift game server, an app needs both the IP address and port number. This value is set once the new game session is placed (placement status is <code>FULFILLED</code>). </p>
    pub ip_address: std::option::Option<std::string::String>,
    /// <p>The DNS identifier assigned to the instance that is running the game session. Values have the following format:</p>
    /// <ul>
    /// <li> <p>TLS-enabled fleets: <code>
    /// <unique identifier>
    /// .
    /// <region identifier>
    /// .amazongamelift.com
    /// </region>
    /// </unique></code>.</p> </li>
    /// <li> <p>Non-TLS-enabled fleets: <code>ec2-
    /// <unique identifier>
    /// .compute.amazonaws.com
    /// </unique></code>. (See <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses">Amazon EC2 Instance IP Addressing</a>.)</p> </li>
    /// </ul>
    /// <p>When connecting to a game session that is running on a TLS-enabled fleet, you must use the DNS name, not the IP address.</p>
    pub dns_name: std::option::Option<std::string::String>,
    /// <p>The port number for the game session. To connect to a GameLift game server, an app needs both the IP address and port number. This value is set once the new game session is placed (placement status is <code>FULFILLED</code>).</p>
    pub port: std::option::Option<i32>,
    /// <p>A collection of information on player sessions created in response to the game session placement request. These player sessions are created only once a new game session is successfully placed (placement status is <code>FULFILLED</code>). This information includes the player ID (as provided in the placement request) and the corresponding player session ID. Retrieve full player sessions by calling <code>DescribePlayerSessions</code> with the player session ID.</p>
    pub placed_player_sessions:
        std::option::Option<std::vec::Vec<crate::model::PlacedPlayerSession>>,
    /// <p>A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>).</p>
    pub game_session_data: std::option::Option<std::string::String>,
    /// <p>Information on the matchmaking process for this game. Data is in JSON syntax, formatted as a string. It identifies the matchmaking configuration used to create the match, and contains data on all players assigned to the match, including player attributes and team assignments. For more details on matchmaker data, see <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-server.html#match-server-data">Match Data</a>.</p>
    pub matchmaker_data: std::option::Option<std::string::String>,
}
impl GameSessionPlacement {
    /// <p>A unique identifier for a game session placement.</p>
    pub fn placement_id(&self) -> std::option::Option<&str> {
        self.placement_id.as_deref()
    }
    /// <p>A descriptive label that is associated with game session queue. Queue names must be unique within each Region.</p>
    pub fn game_session_queue_name(&self) -> std::option::Option<&str> {
        self.game_session_queue_name.as_deref()
    }
    /// <p>Current status of the game session placement request.</p>
    /// <ul>
    /// <li> <p> <b>PENDING</b> -- The placement request is currently in the queue waiting to be processed.</p> </li>
    /// <li> <p> <b>FULFILLED</b> -- A new game session and player sessions (if requested) have been successfully created. Values for <i>GameSessionArn</i> and <i>GameSessionRegion</i> are available. </p> </li>
    /// <li> <p> <b>CANCELLED</b> -- The placement request was canceled with a call to <code>StopGameSessionPlacement</code>.</p> </li>
    /// <li> <p> <b>TIMED_OUT</b> -- A new game session was not successfully created before the time limit expired. You can resubmit the placement request as needed.</p> </li>
    /// <li> <p> <b>FAILED</b> -- GameLift is not able to complete the process of placing the game session. Common reasons are the game session terminated before the placement process was completed, or an unexpected internal error.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::GameSessionPlacementState> {
        self.status.as_ref()
    }
    /// <p>A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>).</p>
    pub fn game_properties(&self) -> std::option::Option<&[crate::model::GameProperty]> {
        self.game_properties.as_deref()
    }
    /// <p>The maximum number of players that can be connected simultaneously to the game session.</p>
    pub fn maximum_player_session_count(&self) -> std::option::Option<i32> {
        self.maximum_player_session_count
    }
    /// <p>A descriptive label that is associated with a game session. Session names do not need to be unique.</p>
    pub fn game_session_name(&self) -> std::option::Option<&str> {
        self.game_session_name.as_deref()
    }
    /// <p>A unique identifier for the game session. This value is set once the new game session is placed (placement status is <code>FULFILLED</code>).</p>
    pub fn game_session_id(&self) -> std::option::Option<&str> {
        self.game_session_id.as_deref()
    }
    /// <p>Identifier for the game session created by this placement request. This value is set once the new game session is placed (placement status is <code>FULFILLED</code>). This identifier is unique across all Regions. You can use this value as a <code>GameSessionId</code> value as needed.</p>
    pub fn game_session_arn(&self) -> std::option::Option<&str> {
        self.game_session_arn.as_deref()
    }
    /// <p>Name of the Region where the game session created by this placement request is running. This value is set once the new game session is placed (placement status is <code>FULFILLED</code>).</p>
    pub fn game_session_region(&self) -> std::option::Option<&str> {
        self.game_session_region.as_deref()
    }
    /// <p>A set of values, expressed in milliseconds, that indicates the amount of latency that a player experiences when connected to @aws; Regions.</p>
    pub fn player_latencies(&self) -> std::option::Option<&[crate::model::PlayerLatency]> {
        self.player_latencies.as_deref()
    }
    /// <p>Time stamp indicating when this request was placed in the queue. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>Time stamp indicating when this request was completed, canceled, or timed out.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>The IP address of the game session. To connect to a GameLift game server, an app needs both the IP address and port number. This value is set once the new game session is placed (placement status is <code>FULFILLED</code>). </p>
    pub fn ip_address(&self) -> std::option::Option<&str> {
        self.ip_address.as_deref()
    }
    /// <p>The DNS identifier assigned to the instance that is running the game session. Values have the following format:</p>
    /// <ul>
    /// <li> <p>TLS-enabled fleets: <code>
    /// <unique identifier>
    /// .
    /// <region identifier>
    /// .amazongamelift.com
    /// </region>
    /// </unique></code>.</p> </li>
    /// <li> <p>Non-TLS-enabled fleets: <code>ec2-
    /// <unique identifier>
    /// .compute.amazonaws.com
    /// </unique></code>. (See <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses">Amazon EC2 Instance IP Addressing</a>.)</p> </li>
    /// </ul>
    /// <p>When connecting to a game session that is running on a TLS-enabled fleet, you must use the DNS name, not the IP address.</p>
    pub fn dns_name(&self) -> std::option::Option<&str> {
        self.dns_name.as_deref()
    }
    /// <p>The port number for the game session. To connect to a GameLift game server, an app needs both the IP address and port number. This value is set once the new game session is placed (placement status is <code>FULFILLED</code>).</p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
    /// <p>A collection of information on player sessions created in response to the game session placement request. These player sessions are created only once a new game session is successfully placed (placement status is <code>FULFILLED</code>). This information includes the player ID (as provided in the placement request) and the corresponding player session ID. Retrieve full player sessions by calling <code>DescribePlayerSessions</code> with the player session ID.</p>
    pub fn placed_player_sessions(
        &self,
    ) -> std::option::Option<&[crate::model::PlacedPlayerSession]> {
        self.placed_player_sessions.as_deref()
    }
    /// <p>A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>).</p>
    pub fn game_session_data(&self) -> std::option::Option<&str> {
        self.game_session_data.as_deref()
    }
    /// <p>Information on the matchmaking process for this game. Data is in JSON syntax, formatted as a string. It identifies the matchmaking configuration used to create the match, and contains data on all players assigned to the match, including player attributes and team assignments. For more details on matchmaker data, see <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-server.html#match-server-data">Match Data</a>.</p>
    pub fn matchmaker_data(&self) -> std::option::Option<&str> {
        self.matchmaker_data.as_deref()
    }
}
impl std::fmt::Debug for GameSessionPlacement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GameSessionPlacement");
        formatter.field("placement_id", &self.placement_id);
        formatter.field("game_session_queue_name", &self.game_session_queue_name);
        formatter.field("status", &self.status);
        formatter.field("game_properties", &self.game_properties);
        formatter.field(
            "maximum_player_session_count",
            &self.maximum_player_session_count,
        );
        formatter.field("game_session_name", &self.game_session_name);
        formatter.field("game_session_id", &self.game_session_id);
        formatter.field("game_session_arn", &self.game_session_arn);
        formatter.field("game_session_region", &self.game_session_region);
        formatter.field("player_latencies", &self.player_latencies);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("ip_address", &self.ip_address);
        formatter.field("dns_name", &self.dns_name);
        formatter.field("port", &self.port);
        formatter.field("placed_player_sessions", &self.placed_player_sessions);
        formatter.field("game_session_data", &self.game_session_data);
        formatter.field("matchmaker_data", &self.matchmaker_data);
        formatter.finish()
    }
}
/// See [`GameSessionPlacement`](crate::model::GameSessionPlacement)
pub mod game_session_placement {
    /// A builder for [`GameSessionPlacement`](crate::model::GameSessionPlacement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) placement_id: std::option::Option<std::string::String>,
        pub(crate) game_session_queue_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::GameSessionPlacementState>,
        pub(crate) game_properties: std::option::Option<std::vec::Vec<crate::model::GameProperty>>,
        pub(crate) maximum_player_session_count: std::option::Option<i32>,
        pub(crate) game_session_name: std::option::Option<std::string::String>,
        pub(crate) game_session_id: std::option::Option<std::string::String>,
        pub(crate) game_session_arn: std::option::Option<std::string::String>,
        pub(crate) game_session_region: std::option::Option<std::string::String>,
        pub(crate) player_latencies:
            std::option::Option<std::vec::Vec<crate::model::PlayerLatency>>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) ip_address: std::option::Option<std::string::String>,
        pub(crate) dns_name: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) placed_player_sessions:
            std::option::Option<std::vec::Vec<crate::model::PlacedPlayerSession>>,
        pub(crate) game_session_data: std::option::Option<std::string::String>,
        pub(crate) matchmaker_data: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for a game session placement.</p>
        pub fn placement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.placement_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a game session placement.</p>
        pub fn set_placement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.placement_id = input;
            self
        }
        /// <p>A descriptive label that is associated with game session queue. Queue names must be unique within each Region.</p>
        pub fn game_session_queue_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_session_queue_name = Some(input.into());
            self
        }
        /// <p>A descriptive label that is associated with game session queue. Queue names must be unique within each Region.</p>
        pub fn set_game_session_queue_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_session_queue_name = input;
            self
        }
        /// <p>Current status of the game session placement request.</p>
        /// <ul>
        /// <li> <p> <b>PENDING</b> -- The placement request is currently in the queue waiting to be processed.</p> </li>
        /// <li> <p> <b>FULFILLED</b> -- A new game session and player sessions (if requested) have been successfully created. Values for <i>GameSessionArn</i> and <i>GameSessionRegion</i> are available. </p> </li>
        /// <li> <p> <b>CANCELLED</b> -- The placement request was canceled with a call to <code>StopGameSessionPlacement</code>.</p> </li>
        /// <li> <p> <b>TIMED_OUT</b> -- A new game session was not successfully created before the time limit expired. You can resubmit the placement request as needed.</p> </li>
        /// <li> <p> <b>FAILED</b> -- GameLift is not able to complete the process of placing the game session. Common reasons are the game session terminated before the placement process was completed, or an unexpected internal error.</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::GameSessionPlacementState) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Current status of the game session placement request.</p>
        /// <ul>
        /// <li> <p> <b>PENDING</b> -- The placement request is currently in the queue waiting to be processed.</p> </li>
        /// <li> <p> <b>FULFILLED</b> -- A new game session and player sessions (if requested) have been successfully created. Values for <i>GameSessionArn</i> and <i>GameSessionRegion</i> are available. </p> </li>
        /// <li> <p> <b>CANCELLED</b> -- The placement request was canceled with a call to <code>StopGameSessionPlacement</code>.</p> </li>
        /// <li> <p> <b>TIMED_OUT</b> -- A new game session was not successfully created before the time limit expired. You can resubmit the placement request as needed.</p> </li>
        /// <li> <p> <b>FAILED</b> -- GameLift is not able to complete the process of placing the game session. Common reasons are the game session terminated before the placement process was completed, or an unexpected internal error.</p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::GameSessionPlacementState>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `game_properties`.
        ///
        /// To override the contents of this collection use [`set_game_properties`](Self::set_game_properties).
        ///
        /// <p>A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>).</p>
        pub fn game_properties(mut self, input: crate::model::GameProperty) -> Self {
            let mut v = self.game_properties.unwrap_or_default();
            v.push(input);
            self.game_properties = Some(v);
            self
        }
        /// <p>A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>).</p>
        pub fn set_game_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GameProperty>>,
        ) -> Self {
            self.game_properties = input;
            self
        }
        /// <p>The maximum number of players that can be connected simultaneously to the game session.</p>
        pub fn maximum_player_session_count(mut self, input: i32) -> Self {
            self.maximum_player_session_count = Some(input);
            self
        }
        /// <p>The maximum number of players that can be connected simultaneously to the game session.</p>
        pub fn set_maximum_player_session_count(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_player_session_count = input;
            self
        }
        /// <p>A descriptive label that is associated with a game session. Session names do not need to be unique.</p>
        pub fn game_session_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_session_name = Some(input.into());
            self
        }
        /// <p>A descriptive label that is associated with a game session. Session names do not need to be unique.</p>
        pub fn set_game_session_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_session_name = input;
            self
        }
        /// <p>A unique identifier for the game session. This value is set once the new game session is placed (placement status is <code>FULFILLED</code>).</p>
        pub fn game_session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_session_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the game session. This value is set once the new game session is placed (placement status is <code>FULFILLED</code>).</p>
        pub fn set_game_session_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_session_id = input;
            self
        }
        /// <p>Identifier for the game session created by this placement request. This value is set once the new game session is placed (placement status is <code>FULFILLED</code>). This identifier is unique across all Regions. You can use this value as a <code>GameSessionId</code> value as needed.</p>
        pub fn game_session_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_session_arn = Some(input.into());
            self
        }
        /// <p>Identifier for the game session created by this placement request. This value is set once the new game session is placed (placement status is <code>FULFILLED</code>). This identifier is unique across all Regions. You can use this value as a <code>GameSessionId</code> value as needed.</p>
        pub fn set_game_session_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_session_arn = input;
            self
        }
        /// <p>Name of the Region where the game session created by this placement request is running. This value is set once the new game session is placed (placement status is <code>FULFILLED</code>).</p>
        pub fn game_session_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_session_region = Some(input.into());
            self
        }
        /// <p>Name of the Region where the game session created by this placement request is running. This value is set once the new game session is placed (placement status is <code>FULFILLED</code>).</p>
        pub fn set_game_session_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_session_region = input;
            self
        }
        /// Appends an item to `player_latencies`.
        ///
        /// To override the contents of this collection use [`set_player_latencies`](Self::set_player_latencies).
        ///
        /// <p>A set of values, expressed in milliseconds, that indicates the amount of latency that a player experiences when connected to @aws; Regions.</p>
        pub fn player_latencies(mut self, input: crate::model::PlayerLatency) -> Self {
            let mut v = self.player_latencies.unwrap_or_default();
            v.push(input);
            self.player_latencies = Some(v);
            self
        }
        /// <p>A set of values, expressed in milliseconds, that indicates the amount of latency that a player experiences when connected to @aws; Regions.</p>
        pub fn set_player_latencies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlayerLatency>>,
        ) -> Self {
            self.player_latencies = input;
            self
        }
        /// <p>Time stamp indicating when this request was placed in the queue. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>Time stamp indicating when this request was placed in the queue. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>Time stamp indicating when this request was completed, canceled, or timed out.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>Time stamp indicating when this request was completed, canceled, or timed out.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The IP address of the game session. To connect to a GameLift game server, an app needs both the IP address and port number. This value is set once the new game session is placed (placement status is <code>FULFILLED</code>). </p>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address = Some(input.into());
            self
        }
        /// <p>The IP address of the game session. To connect to a GameLift game server, an app needs both the IP address and port number. This value is set once the new game session is placed (placement status is <code>FULFILLED</code>). </p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_address = input;
            self
        }
        /// <p>The DNS identifier assigned to the instance that is running the game session. Values have the following format:</p>
        /// <ul>
        /// <li> <p>TLS-enabled fleets: <code>
        /// <unique identifier>
        /// .
        /// <region identifier>
        /// .amazongamelift.com
        /// </region>
        /// </unique></code>.</p> </li>
        /// <li> <p>Non-TLS-enabled fleets: <code>ec2-
        /// <unique identifier>
        /// .compute.amazonaws.com
        /// </unique></code>. (See <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses">Amazon EC2 Instance IP Addressing</a>.)</p> </li>
        /// </ul>
        /// <p>When connecting to a game session that is running on a TLS-enabled fleet, you must use the DNS name, not the IP address.</p>
        pub fn dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dns_name = Some(input.into());
            self
        }
        /// <p>The DNS identifier assigned to the instance that is running the game session. Values have the following format:</p>
        /// <ul>
        /// <li> <p>TLS-enabled fleets: <code>
        /// <unique identifier>
        /// .
        /// <region identifier>
        /// .amazongamelift.com
        /// </region>
        /// </unique></code>.</p> </li>
        /// <li> <p>Non-TLS-enabled fleets: <code>ec2-
        /// <unique identifier>
        /// .compute.amazonaws.com
        /// </unique></code>. (See <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses">Amazon EC2 Instance IP Addressing</a>.)</p> </li>
        /// </ul>
        /// <p>When connecting to a game session that is running on a TLS-enabled fleet, you must use the DNS name, not the IP address.</p>
        pub fn set_dns_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dns_name = input;
            self
        }
        /// <p>The port number for the game session. To connect to a GameLift game server, an app needs both the IP address and port number. This value is set once the new game session is placed (placement status is <code>FULFILLED</code>).</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port number for the game session. To connect to a GameLift game server, an app needs both the IP address and port number. This value is set once the new game session is placed (placement status is <code>FULFILLED</code>).</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// Appends an item to `placed_player_sessions`.
        ///
        /// To override the contents of this collection use [`set_placed_player_sessions`](Self::set_placed_player_sessions).
        ///
        /// <p>A collection of information on player sessions created in response to the game session placement request. These player sessions are created only once a new game session is successfully placed (placement status is <code>FULFILLED</code>). This information includes the player ID (as provided in the placement request) and the corresponding player session ID. Retrieve full player sessions by calling <code>DescribePlayerSessions</code> with the player session ID.</p>
        pub fn placed_player_sessions(mut self, input: crate::model::PlacedPlayerSession) -> Self {
            let mut v = self.placed_player_sessions.unwrap_or_default();
            v.push(input);
            self.placed_player_sessions = Some(v);
            self
        }
        /// <p>A collection of information on player sessions created in response to the game session placement request. These player sessions are created only once a new game session is successfully placed (placement status is <code>FULFILLED</code>). This information includes the player ID (as provided in the placement request) and the corresponding player session ID. Retrieve full player sessions by calling <code>DescribePlayerSessions</code> with the player session ID.</p>
        pub fn set_placed_player_sessions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlacedPlayerSession>>,
        ) -> Self {
            self.placed_player_sessions = input;
            self
        }
        /// <p>A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>).</p>
        pub fn game_session_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_session_data = Some(input.into());
            self
        }
        /// <p>A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the <code>GameSession</code> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>).</p>
        pub fn set_game_session_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_session_data = input;
            self
        }
        /// <p>Information on the matchmaking process for this game. Data is in JSON syntax, formatted as a string. It identifies the matchmaking configuration used to create the match, and contains data on all players assigned to the match, including player attributes and team assignments. For more details on matchmaker data, see <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-server.html#match-server-data">Match Data</a>.</p>
        pub fn matchmaker_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.matchmaker_data = Some(input.into());
            self
        }
        /// <p>Information on the matchmaking process for this game. Data is in JSON syntax, formatted as a string. It identifies the matchmaking configuration used to create the match, and contains data on all players assigned to the match, including player attributes and team assignments. For more details on matchmaker data, see <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-server.html#match-server-data">Match Data</a>.</p>
        pub fn set_matchmaker_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.matchmaker_data = input;
            self
        }
        /// Consumes the builder and constructs a [`GameSessionPlacement`](crate::model::GameSessionPlacement)
        pub fn build(self) -> crate::model::GameSessionPlacement {
            crate::model::GameSessionPlacement {
                placement_id: self.placement_id,
                game_session_queue_name: self.game_session_queue_name,
                status: self.status,
                game_properties: self.game_properties,
                maximum_player_session_count: self.maximum_player_session_count,
                game_session_name: self.game_session_name,
                game_session_id: self.game_session_id,
                game_session_arn: self.game_session_arn,
                game_session_region: self.game_session_region,
                player_latencies: self.player_latencies,
                start_time: self.start_time,
                end_time: self.end_time,
                ip_address: self.ip_address,
                dns_name: self.dns_name,
                port: self.port,
                placed_player_sessions: self.placed_player_sessions,
                game_session_data: self.game_session_data,
                matchmaker_data: self.matchmaker_data,
            }
        }
    }
}
impl GameSessionPlacement {
    /// Creates a new builder-style object to manufacture [`GameSessionPlacement`](crate::model::GameSessionPlacement)
    pub fn builder() -> crate::model::game_session_placement::Builder {
        crate::model::game_session_placement::Builder::default()
    }
}

/// <p>Information about a player session that was created as part of a <code>StartGameSessionPlacement</code> request. This object contains only the player ID and player session ID. To retrieve full details on a player session, call <code>DescribePlayerSessions</code> with the player session ID.</p>
/// <p> <b>Related actions</b> </p>
/// <p> <code>CreatePlayerSession</code> | <code>CreatePlayerSessions</code> | <code>DescribePlayerSessions</code> | <code>StartGameSessionPlacement</code> | <code>DescribeGameSessionPlacement</code> | <code>StopGameSessionPlacement</code> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PlacedPlayerSession {
    /// <p>A unique identifier for a player that is associated with this player session.</p>
    pub player_id: std::option::Option<std::string::String>,
    /// <p>A unique identifier for a player session.</p>
    pub player_session_id: std::option::Option<std::string::String>,
}
impl PlacedPlayerSession {
    /// <p>A unique identifier for a player that is associated with this player session.</p>
    pub fn player_id(&self) -> std::option::Option<&str> {
        self.player_id.as_deref()
    }
    /// <p>A unique identifier for a player session.</p>
    pub fn player_session_id(&self) -> std::option::Option<&str> {
        self.player_session_id.as_deref()
    }
}
impl std::fmt::Debug for PlacedPlayerSession {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PlacedPlayerSession");
        formatter.field("player_id", &self.player_id);
        formatter.field("player_session_id", &self.player_session_id);
        formatter.finish()
    }
}
/// See [`PlacedPlayerSession`](crate::model::PlacedPlayerSession)
pub mod placed_player_session {
    /// A builder for [`PlacedPlayerSession`](crate::model::PlacedPlayerSession)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) player_id: std::option::Option<std::string::String>,
        pub(crate) player_session_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for a player that is associated with this player session.</p>
        pub fn player_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.player_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a player that is associated with this player session.</p>
        pub fn set_player_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.player_id = input;
            self
        }
        /// <p>A unique identifier for a player session.</p>
        pub fn player_session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.player_session_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a player session.</p>
        pub fn set_player_session_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.player_session_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PlacedPlayerSession`](crate::model::PlacedPlayerSession)
        pub fn build(self) -> crate::model::PlacedPlayerSession {
            crate::model::PlacedPlayerSession {
                player_id: self.player_id,
                player_session_id: self.player_session_id,
            }
        }
    }
}
impl PlacedPlayerSession {
    /// Creates a new builder-style object to manufacture [`PlacedPlayerSession`](crate::model::PlacedPlayerSession)
    pub fn builder() -> crate::model::placed_player_session::Builder {
        crate::model::placed_player_session::Builder::default()
    }
}

/// <p>Regional latency information for a player, used when requesting a new game session with <code>StartGameSessionPlacement</code>. This value indicates the amount of time lag that exists when the player is connected to a fleet in the specified Region. The relative difference between a player's latency values for multiple Regions are used to determine which fleets are best suited to place a new game session for the player. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PlayerLatency {
    /// <p>A unique identifier for a player associated with the latency data.</p>
    pub player_id: std::option::Option<std::string::String>,
    /// <p>Name of the Region that is associated with the latency value.</p>
    pub region_identifier: std::option::Option<std::string::String>,
    /// <p>Amount of time that represents the time lag experienced by the player when connected to the specified Region.</p>
    pub latency_in_milliseconds: f32,
}
impl PlayerLatency {
    /// <p>A unique identifier for a player associated with the latency data.</p>
    pub fn player_id(&self) -> std::option::Option<&str> {
        self.player_id.as_deref()
    }
    /// <p>Name of the Region that is associated with the latency value.</p>
    pub fn region_identifier(&self) -> std::option::Option<&str> {
        self.region_identifier.as_deref()
    }
    /// <p>Amount of time that represents the time lag experienced by the player when connected to the specified Region.</p>
    pub fn latency_in_milliseconds(&self) -> f32 {
        self.latency_in_milliseconds
    }
}
impl std::fmt::Debug for PlayerLatency {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PlayerLatency");
        formatter.field("player_id", &self.player_id);
        formatter.field("region_identifier", &self.region_identifier);
        formatter.field("latency_in_milliseconds", &self.latency_in_milliseconds);
        formatter.finish()
    }
}
/// See [`PlayerLatency`](crate::model::PlayerLatency)
pub mod player_latency {
    /// A builder for [`PlayerLatency`](crate::model::PlayerLatency)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) player_id: std::option::Option<std::string::String>,
        pub(crate) region_identifier: std::option::Option<std::string::String>,
        pub(crate) latency_in_milliseconds: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>A unique identifier for a player associated with the latency data.</p>
        pub fn player_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.player_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a player associated with the latency data.</p>
        pub fn set_player_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.player_id = input;
            self
        }
        /// <p>Name of the Region that is associated with the latency value.</p>
        pub fn region_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.region_identifier = Some(input.into());
            self
        }
        /// <p>Name of the Region that is associated with the latency value.</p>
        pub fn set_region_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.region_identifier = input;
            self
        }
        /// <p>Amount of time that represents the time lag experienced by the player when connected to the specified Region.</p>
        pub fn latency_in_milliseconds(mut self, input: f32) -> Self {
            self.latency_in_milliseconds = Some(input);
            self
        }
        /// <p>Amount of time that represents the time lag experienced by the player when connected to the specified Region.</p>
        pub fn set_latency_in_milliseconds(mut self, input: std::option::Option<f32>) -> Self {
            self.latency_in_milliseconds = input;
            self
        }
        /// Consumes the builder and constructs a [`PlayerLatency`](crate::model::PlayerLatency)
        pub fn build(self) -> crate::model::PlayerLatency {
            crate::model::PlayerLatency {
                player_id: self.player_id,
                region_identifier: self.region_identifier,
                latency_in_milliseconds: self.latency_in_milliseconds.unwrap_or_default(),
            }
        }
    }
}
impl PlayerLatency {
    /// Creates a new builder-style object to manufacture [`PlayerLatency`](crate::model::PlayerLatency)
    pub fn builder() -> crate::model::player_latency::Builder {
        crate::model::player_latency::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GameSessionPlacementState {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Fulfilled,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    TimedOut,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GameSessionPlacementState {
    fn from(s: &str) -> Self {
        match s {
            "CANCELLED" => GameSessionPlacementState::Cancelled,
            "FAILED" => GameSessionPlacementState::Failed,
            "FULFILLED" => GameSessionPlacementState::Fulfilled,
            "PENDING" => GameSessionPlacementState::Pending,
            "TIMED_OUT" => GameSessionPlacementState::TimedOut,
            other => GameSessionPlacementState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GameSessionPlacementState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GameSessionPlacementState::from(s))
    }
}
impl GameSessionPlacementState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GameSessionPlacementState::Cancelled => "CANCELLED",
            GameSessionPlacementState::Failed => "FAILED",
            GameSessionPlacementState::Fulfilled => "FULFILLED",
            GameSessionPlacementState::Pending => "PENDING",
            GameSessionPlacementState::TimedOut => "TIMED_OUT",
            GameSessionPlacementState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CANCELLED", "FAILED", "FULFILLED", "PENDING", "TIMED_OUT"]
    }
}
impl AsRef<str> for GameSessionPlacementState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FleetAction {
    #[allow(missing_docs)] // documentation missing in model
    AutoScaling,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FleetAction {
    fn from(s: &str) -> Self {
        match s {
            "AUTO_SCALING" => FleetAction::AutoScaling,
            other => FleetAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FleetAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FleetAction::from(s))
    }
}
impl FleetAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FleetAction::AutoScaling => "AUTO_SCALING",
            FleetAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTO_SCALING"]
    }
}
impl AsRef<str> for FleetAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Ticket generated to track the progress of a matchmaking request. Each ticket is uniquely identified by a ticket ID, supplied by the requester, when creating a matchmaking request with <code>StartMatchmaking</code>. Tickets can be retrieved by calling <code>DescribeMatchmaking</code> with the ticket ID.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MatchmakingTicket {
    /// <p>A unique identifier for a matchmaking ticket.</p>
    pub ticket_id: std::option::Option<std::string::String>,
    /// <p>Name of the <code>MatchmakingConfiguration</code> that is used with this ticket. Matchmaking configurations determine how players are grouped into a match and how a new game session is created for the match.</p>
    pub configuration_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift matchmaking configuration resource that is used with this ticket.</p>
    pub configuration_arn: std::option::Option<std::string::String>,
    /// <p>Current status of the matchmaking request.</p>
    /// <ul>
    /// <li> <p> <b>QUEUED</b> -- The matchmaking request has been received and is currently waiting to be processed.</p> </li>
    /// <li> <p> <b>SEARCHING</b> -- The matchmaking request is currently being processed. </p> </li>
    /// <li> <p> <b>REQUIRES_ACCEPTANCE</b> -- A match has been proposed and the players must accept the match (see <code>AcceptMatch</code>). This status is used only with requests that use a matchmaking configuration with a player acceptance requirement.</p> </li>
    /// <li> <p> <b>PLACING</b> -- The FlexMatch engine has matched players and is in the process of placing a new game session for the match.</p> </li>
    /// <li> <p> <b>COMPLETED</b> -- Players have been matched and a game session is ready to host the players. A ticket in this state contains the necessary connection information for players.</p> </li>
    /// <li> <p> <b>FAILED</b> -- The matchmaking request was not completed.</p> </li>
    /// <li> <p> <b>CANCELLED</b> -- The matchmaking request was canceled. This may be the result of a call to <code>StopMatchmaking</code> or a proposed match that one or more players failed to accept.</p> </li>
    /// <li> <p> <b>TIMED_OUT</b> -- The matchmaking request was not successful within the duration specified in the matchmaking configuration. </p> </li>
    /// </ul> <note>
    /// <p>Matchmaking requests that fail to successfully complete (statuses FAILED, CANCELLED, TIMED_OUT) can be resubmitted as new requests with new ticket IDs.</p>
    /// </note>
    pub status: std::option::Option<crate::model::MatchmakingConfigurationStatus>,
    /// <p>Code to explain the current status. For example, a status reason may indicate when a ticket has returned to <code>SEARCHING</code> status after a proposed match fails to receive player acceptances.</p>
    pub status_reason: std::option::Option<std::string::String>,
    /// <p>Additional information about the current status.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>Time stamp indicating when this matchmaking request was received. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Time stamp indicating when this matchmaking request stopped being processed due to success, failure, or cancellation. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A set of <code>Player</code> objects, each representing a player to find matches for. Players are identified by a unique player ID and may include latency data for use during matchmaking. If the ticket is in status <code>COMPLETED</code>, the <code>Player</code> objects include the team the players were assigned to in the resulting match.</p>
    pub players: std::option::Option<std::vec::Vec<crate::model::Player>>,
    /// <p>Identifier and connection information of the game session created for the match. This information is added to the ticket only after the matchmaking request has been successfully completed. This parameter is not set when FlexMatch is being used without GameLift hosting.</p>
    pub game_session_connection_info: std::option::Option<crate::model::GameSessionConnectionInfo>,
    /// <p>Average amount of time (in seconds) that players are currently waiting for a match. If there is not enough recent data, this property may be empty.</p>
    pub estimated_wait_time: std::option::Option<i32>,
}
impl MatchmakingTicket {
    /// <p>A unique identifier for a matchmaking ticket.</p>
    pub fn ticket_id(&self) -> std::option::Option<&str> {
        self.ticket_id.as_deref()
    }
    /// <p>Name of the <code>MatchmakingConfiguration</code> that is used with this ticket. Matchmaking configurations determine how players are grouped into a match and how a new game session is created for the match.</p>
    pub fn configuration_name(&self) -> std::option::Option<&str> {
        self.configuration_name.as_deref()
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift matchmaking configuration resource that is used with this ticket.</p>
    pub fn configuration_arn(&self) -> std::option::Option<&str> {
        self.configuration_arn.as_deref()
    }
    /// <p>Current status of the matchmaking request.</p>
    /// <ul>
    /// <li> <p> <b>QUEUED</b> -- The matchmaking request has been received and is currently waiting to be processed.</p> </li>
    /// <li> <p> <b>SEARCHING</b> -- The matchmaking request is currently being processed. </p> </li>
    /// <li> <p> <b>REQUIRES_ACCEPTANCE</b> -- A match has been proposed and the players must accept the match (see <code>AcceptMatch</code>). This status is used only with requests that use a matchmaking configuration with a player acceptance requirement.</p> </li>
    /// <li> <p> <b>PLACING</b> -- The FlexMatch engine has matched players and is in the process of placing a new game session for the match.</p> </li>
    /// <li> <p> <b>COMPLETED</b> -- Players have been matched and a game session is ready to host the players. A ticket in this state contains the necessary connection information for players.</p> </li>
    /// <li> <p> <b>FAILED</b> -- The matchmaking request was not completed.</p> </li>
    /// <li> <p> <b>CANCELLED</b> -- The matchmaking request was canceled. This may be the result of a call to <code>StopMatchmaking</code> or a proposed match that one or more players failed to accept.</p> </li>
    /// <li> <p> <b>TIMED_OUT</b> -- The matchmaking request was not successful within the duration specified in the matchmaking configuration. </p> </li>
    /// </ul> <note>
    /// <p>Matchmaking requests that fail to successfully complete (statuses FAILED, CANCELLED, TIMED_OUT) can be resubmitted as new requests with new ticket IDs.</p>
    /// </note>
    pub fn status(&self) -> std::option::Option<&crate::model::MatchmakingConfigurationStatus> {
        self.status.as_ref()
    }
    /// <p>Code to explain the current status. For example, a status reason may indicate when a ticket has returned to <code>SEARCHING</code> status after a proposed match fails to receive player acceptances.</p>
    pub fn status_reason(&self) -> std::option::Option<&str> {
        self.status_reason.as_deref()
    }
    /// <p>Additional information about the current status.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>Time stamp indicating when this matchmaking request was received. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>Time stamp indicating when this matchmaking request stopped being processed due to success, failure, or cancellation. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>A set of <code>Player</code> objects, each representing a player to find matches for. Players are identified by a unique player ID and may include latency data for use during matchmaking. If the ticket is in status <code>COMPLETED</code>, the <code>Player</code> objects include the team the players were assigned to in the resulting match.</p>
    pub fn players(&self) -> std::option::Option<&[crate::model::Player]> {
        self.players.as_deref()
    }
    /// <p>Identifier and connection information of the game session created for the match. This information is added to the ticket only after the matchmaking request has been successfully completed. This parameter is not set when FlexMatch is being used without GameLift hosting.</p>
    pub fn game_session_connection_info(
        &self,
    ) -> std::option::Option<&crate::model::GameSessionConnectionInfo> {
        self.game_session_connection_info.as_ref()
    }
    /// <p>Average amount of time (in seconds) that players are currently waiting for a match. If there is not enough recent data, this property may be empty.</p>
    pub fn estimated_wait_time(&self) -> std::option::Option<i32> {
        self.estimated_wait_time
    }
}
impl std::fmt::Debug for MatchmakingTicket {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MatchmakingTicket");
        formatter.field("ticket_id", &self.ticket_id);
        formatter.field("configuration_name", &self.configuration_name);
        formatter.field("configuration_arn", &self.configuration_arn);
        formatter.field("status", &self.status);
        formatter.field("status_reason", &self.status_reason);
        formatter.field("status_message", &self.status_message);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("players", &self.players);
        formatter.field(
            "game_session_connection_info",
            &self.game_session_connection_info,
        );
        formatter.field("estimated_wait_time", &self.estimated_wait_time);
        formatter.finish()
    }
}
/// See [`MatchmakingTicket`](crate::model::MatchmakingTicket)
pub mod matchmaking_ticket {
    /// A builder for [`MatchmakingTicket`](crate::model::MatchmakingTicket)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ticket_id: std::option::Option<std::string::String>,
        pub(crate) configuration_name: std::option::Option<std::string::String>,
        pub(crate) configuration_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::MatchmakingConfigurationStatus>,
        pub(crate) status_reason: std::option::Option<std::string::String>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) players: std::option::Option<std::vec::Vec<crate::model::Player>>,
        pub(crate) game_session_connection_info:
            std::option::Option<crate::model::GameSessionConnectionInfo>,
        pub(crate) estimated_wait_time: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A unique identifier for a matchmaking ticket.</p>
        pub fn ticket_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ticket_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a matchmaking ticket.</p>
        pub fn set_ticket_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ticket_id = input;
            self
        }
        /// <p>Name of the <code>MatchmakingConfiguration</code> that is used with this ticket. Matchmaking configurations determine how players are grouped into a match and how a new game session is created for the match.</p>
        pub fn configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_name = Some(input.into());
            self
        }
        /// <p>Name of the <code>MatchmakingConfiguration</code> that is used with this ticket. Matchmaking configurations determine how players are grouped into a match and how a new game session is created for the match.</p>
        pub fn set_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_name = input;
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift matchmaking configuration resource that is used with this ticket.</p>
        pub fn configuration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift matchmaking configuration resource that is used with this ticket.</p>
        pub fn set_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_arn = input;
            self
        }
        /// <p>Current status of the matchmaking request.</p>
        /// <ul>
        /// <li> <p> <b>QUEUED</b> -- The matchmaking request has been received and is currently waiting to be processed.</p> </li>
        /// <li> <p> <b>SEARCHING</b> -- The matchmaking request is currently being processed. </p> </li>
        /// <li> <p> <b>REQUIRES_ACCEPTANCE</b> -- A match has been proposed and the players must accept the match (see <code>AcceptMatch</code>). This status is used only with requests that use a matchmaking configuration with a player acceptance requirement.</p> </li>
        /// <li> <p> <b>PLACING</b> -- The FlexMatch engine has matched players and is in the process of placing a new game session for the match.</p> </li>
        /// <li> <p> <b>COMPLETED</b> -- Players have been matched and a game session is ready to host the players. A ticket in this state contains the necessary connection information for players.</p> </li>
        /// <li> <p> <b>FAILED</b> -- The matchmaking request was not completed.</p> </li>
        /// <li> <p> <b>CANCELLED</b> -- The matchmaking request was canceled. This may be the result of a call to <code>StopMatchmaking</code> or a proposed match that one or more players failed to accept.</p> </li>
        /// <li> <p> <b>TIMED_OUT</b> -- The matchmaking request was not successful within the duration specified in the matchmaking configuration. </p> </li>
        /// </ul> <note>
        /// <p>Matchmaking requests that fail to successfully complete (statuses FAILED, CANCELLED, TIMED_OUT) can be resubmitted as new requests with new ticket IDs.</p>
        /// </note>
        pub fn status(mut self, input: crate::model::MatchmakingConfigurationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Current status of the matchmaking request.</p>
        /// <ul>
        /// <li> <p> <b>QUEUED</b> -- The matchmaking request has been received and is currently waiting to be processed.</p> </li>
        /// <li> <p> <b>SEARCHING</b> -- The matchmaking request is currently being processed. </p> </li>
        /// <li> <p> <b>REQUIRES_ACCEPTANCE</b> -- A match has been proposed and the players must accept the match (see <code>AcceptMatch</code>). This status is used only with requests that use a matchmaking configuration with a player acceptance requirement.</p> </li>
        /// <li> <p> <b>PLACING</b> -- The FlexMatch engine has matched players and is in the process of placing a new game session for the match.</p> </li>
        /// <li> <p> <b>COMPLETED</b> -- Players have been matched and a game session is ready to host the players. A ticket in this state contains the necessary connection information for players.</p> </li>
        /// <li> <p> <b>FAILED</b> -- The matchmaking request was not completed.</p> </li>
        /// <li> <p> <b>CANCELLED</b> -- The matchmaking request was canceled. This may be the result of a call to <code>StopMatchmaking</code> or a proposed match that one or more players failed to accept.</p> </li>
        /// <li> <p> <b>TIMED_OUT</b> -- The matchmaking request was not successful within the duration specified in the matchmaking configuration. </p> </li>
        /// </ul> <note>
        /// <p>Matchmaking requests that fail to successfully complete (statuses FAILED, CANCELLED, TIMED_OUT) can be resubmitted as new requests with new ticket IDs.</p>
        /// </note>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::MatchmakingConfigurationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Code to explain the current status. For example, a status reason may indicate when a ticket has returned to <code>SEARCHING</code> status after a proposed match fails to receive player acceptances.</p>
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_reason = Some(input.into());
            self
        }
        /// <p>Code to explain the current status. For example, a status reason may indicate when a ticket has returned to <code>SEARCHING</code> status after a proposed match fails to receive player acceptances.</p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// <p>Additional information about the current status.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>Additional information about the current status.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>Time stamp indicating when this matchmaking request was received. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>Time stamp indicating when this matchmaking request was received. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>Time stamp indicating when this matchmaking request stopped being processed due to success, failure, or cancellation. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>Time stamp indicating when this matchmaking request stopped being processed due to success, failure, or cancellation. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Appends an item to `players`.
        ///
        /// To override the contents of this collection use [`set_players`](Self::set_players).
        ///
        /// <p>A set of <code>Player</code> objects, each representing a player to find matches for. Players are identified by a unique player ID and may include latency data for use during matchmaking. If the ticket is in status <code>COMPLETED</code>, the <code>Player</code> objects include the team the players were assigned to in the resulting match.</p>
        pub fn players(mut self, input: crate::model::Player) -> Self {
            let mut v = self.players.unwrap_or_default();
            v.push(input);
            self.players = Some(v);
            self
        }
        /// <p>A set of <code>Player</code> objects, each representing a player to find matches for. Players are identified by a unique player ID and may include latency data for use during matchmaking. If the ticket is in status <code>COMPLETED</code>, the <code>Player</code> objects include the team the players were assigned to in the resulting match.</p>
        pub fn set_players(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Player>>,
        ) -> Self {
            self.players = input;
            self
        }
        /// <p>Identifier and connection information of the game session created for the match. This information is added to the ticket only after the matchmaking request has been successfully completed. This parameter is not set when FlexMatch is being used without GameLift hosting.</p>
        pub fn game_session_connection_info(
            mut self,
            input: crate::model::GameSessionConnectionInfo,
        ) -> Self {
            self.game_session_connection_info = Some(input);
            self
        }
        /// <p>Identifier and connection information of the game session created for the match. This information is added to the ticket only after the matchmaking request has been successfully completed. This parameter is not set when FlexMatch is being used without GameLift hosting.</p>
        pub fn set_game_session_connection_info(
            mut self,
            input: std::option::Option<crate::model::GameSessionConnectionInfo>,
        ) -> Self {
            self.game_session_connection_info = input;
            self
        }
        /// <p>Average amount of time (in seconds) that players are currently waiting for a match. If there is not enough recent data, this property may be empty.</p>
        pub fn estimated_wait_time(mut self, input: i32) -> Self {
            self.estimated_wait_time = Some(input);
            self
        }
        /// <p>Average amount of time (in seconds) that players are currently waiting for a match. If there is not enough recent data, this property may be empty.</p>
        pub fn set_estimated_wait_time(mut self, input: std::option::Option<i32>) -> Self {
            self.estimated_wait_time = input;
            self
        }
        /// Consumes the builder and constructs a [`MatchmakingTicket`](crate::model::MatchmakingTicket)
        pub fn build(self) -> crate::model::MatchmakingTicket {
            crate::model::MatchmakingTicket {
                ticket_id: self.ticket_id,
                configuration_name: self.configuration_name,
                configuration_arn: self.configuration_arn,
                status: self.status,
                status_reason: self.status_reason,
                status_message: self.status_message,
                start_time: self.start_time,
                end_time: self.end_time,
                players: self.players,
                game_session_connection_info: self.game_session_connection_info,
                estimated_wait_time: self.estimated_wait_time,
            }
        }
    }
}
impl MatchmakingTicket {
    /// Creates a new builder-style object to manufacture [`MatchmakingTicket`](crate::model::MatchmakingTicket)
    pub fn builder() -> crate::model::matchmaking_ticket::Builder {
        crate::model::matchmaking_ticket::Builder::default()
    }
}

/// <p>Connection information for a new game session that is created in response to a <code>StartMatchmaking</code> request. Once a match is made, the FlexMatch engine creates a new game session for it. This information, including the game session endpoint and player sessions for each player in the original matchmaking request, is added to the <code>MatchmakingTicket</code>, which can be retrieved by calling <code>DescribeMatchmaking</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GameSessionConnectionInfo {
    /// <p>A unique identifier for the game session. Use the game session ID.</p>
    pub game_session_arn: std::option::Option<std::string::String>,
    /// <p>The IP address of the game session. To connect to a GameLift game server, an app needs both the IP address and port number.</p>
    pub ip_address: std::option::Option<std::string::String>,
    /// <p>The DNS identifier assigned to the instance that is running the game session. Values have the following format:</p>
    /// <ul>
    /// <li> <p>TLS-enabled fleets: <code>
    /// <unique identifier>
    /// .
    /// <region identifier>
    /// .amazongamelift.com
    /// </region>
    /// </unique></code>.</p> </li>
    /// <li> <p>Non-TLS-enabled fleets: <code>ec2-
    /// <unique identifier>
    /// .compute.amazonaws.com
    /// </unique></code>. (See <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses">Amazon EC2 Instance IP Addressing</a>.)</p> </li>
    /// </ul>
    /// <p>When connecting to a game session that is running on a TLS-enabled fleet, you must use the DNS name, not the IP address.</p>
    pub dns_name: std::option::Option<std::string::String>,
    /// <p>The port number for the game session. To connect to a GameLift game server, an app needs both the IP address and port number.</p>
    pub port: std::option::Option<i32>,
    /// <p>A collection of player session IDs, one for each player ID that was included in the original matchmaking request. </p>
    pub matched_player_sessions:
        std::option::Option<std::vec::Vec<crate::model::MatchedPlayerSession>>,
}
impl GameSessionConnectionInfo {
    /// <p>A unique identifier for the game session. Use the game session ID.</p>
    pub fn game_session_arn(&self) -> std::option::Option<&str> {
        self.game_session_arn.as_deref()
    }
    /// <p>The IP address of the game session. To connect to a GameLift game server, an app needs both the IP address and port number.</p>
    pub fn ip_address(&self) -> std::option::Option<&str> {
        self.ip_address.as_deref()
    }
    /// <p>The DNS identifier assigned to the instance that is running the game session. Values have the following format:</p>
    /// <ul>
    /// <li> <p>TLS-enabled fleets: <code>
    /// <unique identifier>
    /// .
    /// <region identifier>
    /// .amazongamelift.com
    /// </region>
    /// </unique></code>.</p> </li>
    /// <li> <p>Non-TLS-enabled fleets: <code>ec2-
    /// <unique identifier>
    /// .compute.amazonaws.com
    /// </unique></code>. (See <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses">Amazon EC2 Instance IP Addressing</a>.)</p> </li>
    /// </ul>
    /// <p>When connecting to a game session that is running on a TLS-enabled fleet, you must use the DNS name, not the IP address.</p>
    pub fn dns_name(&self) -> std::option::Option<&str> {
        self.dns_name.as_deref()
    }
    /// <p>The port number for the game session. To connect to a GameLift game server, an app needs both the IP address and port number.</p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
    /// <p>A collection of player session IDs, one for each player ID that was included in the original matchmaking request. </p>
    pub fn matched_player_sessions(
        &self,
    ) -> std::option::Option<&[crate::model::MatchedPlayerSession]> {
        self.matched_player_sessions.as_deref()
    }
}
impl std::fmt::Debug for GameSessionConnectionInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GameSessionConnectionInfo");
        formatter.field("game_session_arn", &self.game_session_arn);
        formatter.field("ip_address", &self.ip_address);
        formatter.field("dns_name", &self.dns_name);
        formatter.field("port", &self.port);
        formatter.field("matched_player_sessions", &self.matched_player_sessions);
        formatter.finish()
    }
}
/// See [`GameSessionConnectionInfo`](crate::model::GameSessionConnectionInfo)
pub mod game_session_connection_info {
    /// A builder for [`GameSessionConnectionInfo`](crate::model::GameSessionConnectionInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_session_arn: std::option::Option<std::string::String>,
        pub(crate) ip_address: std::option::Option<std::string::String>,
        pub(crate) dns_name: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) matched_player_sessions:
            std::option::Option<std::vec::Vec<crate::model::MatchedPlayerSession>>,
    }
    impl Builder {
        /// <p>A unique identifier for the game session. Use the game session ID.</p>
        pub fn game_session_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_session_arn = Some(input.into());
            self
        }
        /// <p>A unique identifier for the game session. Use the game session ID.</p>
        pub fn set_game_session_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_session_arn = input;
            self
        }
        /// <p>The IP address of the game session. To connect to a GameLift game server, an app needs both the IP address and port number.</p>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address = Some(input.into());
            self
        }
        /// <p>The IP address of the game session. To connect to a GameLift game server, an app needs both the IP address and port number.</p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_address = input;
            self
        }
        /// <p>The DNS identifier assigned to the instance that is running the game session. Values have the following format:</p>
        /// <ul>
        /// <li> <p>TLS-enabled fleets: <code>
        /// <unique identifier>
        /// .
        /// <region identifier>
        /// .amazongamelift.com
        /// </region>
        /// </unique></code>.</p> </li>
        /// <li> <p>Non-TLS-enabled fleets: <code>ec2-
        /// <unique identifier>
        /// .compute.amazonaws.com
        /// </unique></code>. (See <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses">Amazon EC2 Instance IP Addressing</a>.)</p> </li>
        /// </ul>
        /// <p>When connecting to a game session that is running on a TLS-enabled fleet, you must use the DNS name, not the IP address.</p>
        pub fn dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dns_name = Some(input.into());
            self
        }
        /// <p>The DNS identifier assigned to the instance that is running the game session. Values have the following format:</p>
        /// <ul>
        /// <li> <p>TLS-enabled fleets: <code>
        /// <unique identifier>
        /// .
        /// <region identifier>
        /// .amazongamelift.com
        /// </region>
        /// </unique></code>.</p> </li>
        /// <li> <p>Non-TLS-enabled fleets: <code>ec2-
        /// <unique identifier>
        /// .compute.amazonaws.com
        /// </unique></code>. (See <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses">Amazon EC2 Instance IP Addressing</a>.)</p> </li>
        /// </ul>
        /// <p>When connecting to a game session that is running on a TLS-enabled fleet, you must use the DNS name, not the IP address.</p>
        pub fn set_dns_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dns_name = input;
            self
        }
        /// <p>The port number for the game session. To connect to a GameLift game server, an app needs both the IP address and port number.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port number for the game session. To connect to a GameLift game server, an app needs both the IP address and port number.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// Appends an item to `matched_player_sessions`.
        ///
        /// To override the contents of this collection use [`set_matched_player_sessions`](Self::set_matched_player_sessions).
        ///
        /// <p>A collection of player session IDs, one for each player ID that was included in the original matchmaking request. </p>
        pub fn matched_player_sessions(
            mut self,
            input: crate::model::MatchedPlayerSession,
        ) -> Self {
            let mut v = self.matched_player_sessions.unwrap_or_default();
            v.push(input);
            self.matched_player_sessions = Some(v);
            self
        }
        /// <p>A collection of player session IDs, one for each player ID that was included in the original matchmaking request. </p>
        pub fn set_matched_player_sessions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MatchedPlayerSession>>,
        ) -> Self {
            self.matched_player_sessions = input;
            self
        }
        /// Consumes the builder and constructs a [`GameSessionConnectionInfo`](crate::model::GameSessionConnectionInfo)
        pub fn build(self) -> crate::model::GameSessionConnectionInfo {
            crate::model::GameSessionConnectionInfo {
                game_session_arn: self.game_session_arn,
                ip_address: self.ip_address,
                dns_name: self.dns_name,
                port: self.port,
                matched_player_sessions: self.matched_player_sessions,
            }
        }
    }
}
impl GameSessionConnectionInfo {
    /// Creates a new builder-style object to manufacture [`GameSessionConnectionInfo`](crate::model::GameSessionConnectionInfo)
    pub fn builder() -> crate::model::game_session_connection_info::Builder {
        crate::model::game_session_connection_info::Builder::default()
    }
}

/// <p>Represents a new player session that is created as a result of a successful FlexMatch match. A successful match automatically creates new player sessions for every player ID in the original matchmaking request. </p>
/// <p>When players connect to the match's game session, they must include both player ID and player session ID in order to claim their assigned player slot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MatchedPlayerSession {
    /// <p>A unique identifier for a player </p>
    pub player_id: std::option::Option<std::string::String>,
    /// <p>A unique identifier for a player session</p>
    pub player_session_id: std::option::Option<std::string::String>,
}
impl MatchedPlayerSession {
    /// <p>A unique identifier for a player </p>
    pub fn player_id(&self) -> std::option::Option<&str> {
        self.player_id.as_deref()
    }
    /// <p>A unique identifier for a player session</p>
    pub fn player_session_id(&self) -> std::option::Option<&str> {
        self.player_session_id.as_deref()
    }
}
impl std::fmt::Debug for MatchedPlayerSession {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MatchedPlayerSession");
        formatter.field("player_id", &self.player_id);
        formatter.field("player_session_id", &self.player_session_id);
        formatter.finish()
    }
}
/// See [`MatchedPlayerSession`](crate::model::MatchedPlayerSession)
pub mod matched_player_session {
    /// A builder for [`MatchedPlayerSession`](crate::model::MatchedPlayerSession)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) player_id: std::option::Option<std::string::String>,
        pub(crate) player_session_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for a player </p>
        pub fn player_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.player_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a player </p>
        pub fn set_player_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.player_id = input;
            self
        }
        /// <p>A unique identifier for a player session</p>
        pub fn player_session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.player_session_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a player session</p>
        pub fn set_player_session_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.player_session_id = input;
            self
        }
        /// Consumes the builder and constructs a [`MatchedPlayerSession`](crate::model::MatchedPlayerSession)
        pub fn build(self) -> crate::model::MatchedPlayerSession {
            crate::model::MatchedPlayerSession {
                player_id: self.player_id,
                player_session_id: self.player_session_id,
            }
        }
    }
}
impl MatchedPlayerSession {
    /// Creates a new builder-style object to manufacture [`MatchedPlayerSession`](crate::model::MatchedPlayerSession)
    pub fn builder() -> crate::model::matched_player_session::Builder {
        crate::model::matched_player_session::Builder::default()
    }
}

/// <p>Represents a player in matchmaking. When starting a matchmaking request, a player has a player ID, attributes, and may have latency data. Team information is added after a match has been successfully completed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Player {
    /// <p>A unique identifier for a player</p>
    pub player_id: std::option::Option<std::string::String>,
    /// <p>A collection of key:value pairs containing player information for use in matchmaking. Player attribute keys must match the <i>playerAttributes</i> used in a matchmaking rule set. Example: <code>"PlayerAttributes": {"skill": {"N": "23"}, "gameMode": {"S": "deathmatch"}}</code>.</p>
    pub player_attributes: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    >,
    /// <p>Name of the team that the player is assigned to in a match. Team names are defined in a matchmaking rule set.</p>
    pub team: std::option::Option<std::string::String>,
    /// <p>A set of values, expressed in milliseconds, that indicates the amount of latency that a player experiences when connected to @aws; Regions. If this property is present, FlexMatch considers placing the match only in Regions for which latency is reported. </p>
    /// <p>If a matchmaker has a rule that evaluates player latency, players must report latency in order to be matched. If no latency is reported in this scenario, FlexMatch assumes that no Regions are available to the player and the ticket is not matchable. </p>
    pub latency_in_ms: std::option::Option<std::collections::HashMap<std::string::String, i32>>,
}
impl Player {
    /// <p>A unique identifier for a player</p>
    pub fn player_id(&self) -> std::option::Option<&str> {
        self.player_id.as_deref()
    }
    /// <p>A collection of key:value pairs containing player information for use in matchmaking. Player attribute keys must match the <i>playerAttributes</i> used in a matchmaking rule set. Example: <code>"PlayerAttributes": {"skill": {"N": "23"}, "gameMode": {"S": "deathmatch"}}</code>.</p>
    pub fn player_attributes(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    > {
        self.player_attributes.as_ref()
    }
    /// <p>Name of the team that the player is assigned to in a match. Team names are defined in a matchmaking rule set.</p>
    pub fn team(&self) -> std::option::Option<&str> {
        self.team.as_deref()
    }
    /// <p>A set of values, expressed in milliseconds, that indicates the amount of latency that a player experiences when connected to @aws; Regions. If this property is present, FlexMatch considers placing the match only in Regions for which latency is reported. </p>
    /// <p>If a matchmaker has a rule that evaluates player latency, players must report latency in order to be matched. If no latency is reported in this scenario, FlexMatch assumes that no Regions are available to the player and the ticket is not matchable. </p>
    pub fn latency_in_ms(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, i32>> {
        self.latency_in_ms.as_ref()
    }
}
impl std::fmt::Debug for Player {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Player");
        formatter.field("player_id", &self.player_id);
        formatter.field("player_attributes", &self.player_attributes);
        formatter.field("team", &self.team);
        formatter.field("latency_in_ms", &self.latency_in_ms);
        formatter.finish()
    }
}
/// See [`Player`](crate::model::Player)
pub mod player {
    /// A builder for [`Player`](crate::model::Player)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) player_id: std::option::Option<std::string::String>,
        pub(crate) player_attributes: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        >,
        pub(crate) team: std::option::Option<std::string::String>,
        pub(crate) latency_in_ms:
            std::option::Option<std::collections::HashMap<std::string::String, i32>>,
    }
    impl Builder {
        /// <p>A unique identifier for a player</p>
        pub fn player_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.player_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a player</p>
        pub fn set_player_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.player_id = input;
            self
        }
        /// Adds a key-value pair to `player_attributes`.
        ///
        /// To override the contents of this collection use [`set_player_attributes`](Self::set_player_attributes).
        ///
        /// <p>A collection of key:value pairs containing player information for use in matchmaking. Player attribute keys must match the <i>playerAttributes</i> used in a matchmaking rule set. Example: <code>"PlayerAttributes": {"skill": {"N": "23"}, "gameMode": {"S": "deathmatch"}}</code>.</p>
        pub fn player_attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::AttributeValue,
        ) -> Self {
            let mut hash_map = self.player_attributes.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.player_attributes = Some(hash_map);
            self
        }
        /// <p>A collection of key:value pairs containing player information for use in matchmaking. Player attribute keys must match the <i>playerAttributes</i> used in a matchmaking rule set. Example: <code>"PlayerAttributes": {"skill": {"N": "23"}, "gameMode": {"S": "deathmatch"}}</code>.</p>
        pub fn set_player_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.player_attributes = input;
            self
        }
        /// <p>Name of the team that the player is assigned to in a match. Team names are defined in a matchmaking rule set.</p>
        pub fn team(mut self, input: impl Into<std::string::String>) -> Self {
            self.team = Some(input.into());
            self
        }
        /// <p>Name of the team that the player is assigned to in a match. Team names are defined in a matchmaking rule set.</p>
        pub fn set_team(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.team = input;
            self
        }
        /// Adds a key-value pair to `latency_in_ms`.
        ///
        /// To override the contents of this collection use [`set_latency_in_ms`](Self::set_latency_in_ms).
        ///
        /// <p>A set of values, expressed in milliseconds, that indicates the amount of latency that a player experiences when connected to @aws; Regions. If this property is present, FlexMatch considers placing the match only in Regions for which latency is reported. </p>
        /// <p>If a matchmaker has a rule that evaluates player latency, players must report latency in order to be matched. If no latency is reported in this scenario, FlexMatch assumes that no Regions are available to the player and the ticket is not matchable. </p>
        pub fn latency_in_ms(mut self, k: impl Into<std::string::String>, v: i32) -> Self {
            let mut hash_map = self.latency_in_ms.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.latency_in_ms = Some(hash_map);
            self
        }
        /// <p>A set of values, expressed in milliseconds, that indicates the amount of latency that a player experiences when connected to @aws; Regions. If this property is present, FlexMatch considers placing the match only in Regions for which latency is reported. </p>
        /// <p>If a matchmaker has a rule that evaluates player latency, players must report latency in order to be matched. If no latency is reported in this scenario, FlexMatch assumes that no Regions are available to the player and the ticket is not matchable. </p>
        pub fn set_latency_in_ms(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, i32>>,
        ) -> Self {
            self.latency_in_ms = input;
            self
        }
        /// Consumes the builder and constructs a [`Player`](crate::model::Player)
        pub fn build(self) -> crate::model::Player {
            crate::model::Player {
                player_id: self.player_id,
                player_attributes: self.player_attributes,
                team: self.team,
                latency_in_ms: self.latency_in_ms,
            }
        }
    }
}
impl Player {
    /// Creates a new builder-style object to manufacture [`Player`](crate::model::Player)
    pub fn builder() -> crate::model::player::Builder {
        crate::model::player::Builder::default()
    }
}

/// <p>Values for use in <code>Player</code> attribute key-value pairs. This object lets you specify an attribute value using any of the valid data types: string, number, string array, or data map. Each <code>AttributeValue</code> object can use only one of the available properties.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttributeValue {
    /// <p>For single string values. Maximum string length is 100 characters.</p>
    pub s: std::option::Option<std::string::String>,
    /// <p>For number values, expressed as double.</p>
    pub n: std::option::Option<f64>,
    /// <p>For a list of up to 100 strings. Maximum length for each string is 100 characters. Duplicate values are not recognized; all occurrences of the repeated value after the first of a repeated value are ignored.</p>
    pub sl: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>For a map of up to 10 data type:value pairs. Maximum length for each string value is 100 characters. </p>
    pub sdm: std::option::Option<std::collections::HashMap<std::string::String, f64>>,
}
impl AttributeValue {
    /// <p>For single string values. Maximum string length is 100 characters.</p>
    pub fn s(&self) -> std::option::Option<&str> {
        self.s.as_deref()
    }
    /// <p>For number values, expressed as double.</p>
    pub fn n(&self) -> std::option::Option<f64> {
        self.n
    }
    /// <p>For a list of up to 100 strings. Maximum length for each string is 100 characters. Duplicate values are not recognized; all occurrences of the repeated value after the first of a repeated value are ignored.</p>
    pub fn sl(&self) -> std::option::Option<&[std::string::String]> {
        self.sl.as_deref()
    }
    /// <p>For a map of up to 10 data type:value pairs. Maximum length for each string value is 100 characters. </p>
    pub fn sdm(&self) -> std::option::Option<&std::collections::HashMap<std::string::String, f64>> {
        self.sdm.as_ref()
    }
}
impl std::fmt::Debug for AttributeValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttributeValue");
        formatter.field("s", &self.s);
        formatter.field("n", &self.n);
        formatter.field("sl", &self.sl);
        formatter.field("sdm", &self.sdm);
        formatter.finish()
    }
}
/// See [`AttributeValue`](crate::model::AttributeValue)
pub mod attribute_value {
    /// A builder for [`AttributeValue`](crate::model::AttributeValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s: std::option::Option<std::string::String>,
        pub(crate) n: std::option::Option<f64>,
        pub(crate) sl: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) sdm: std::option::Option<std::collections::HashMap<std::string::String, f64>>,
    }
    impl Builder {
        /// <p>For single string values. Maximum string length is 100 characters.</p>
        pub fn s(mut self, input: impl Into<std::string::String>) -> Self {
            self.s = Some(input.into());
            self
        }
        /// <p>For single string values. Maximum string length is 100 characters.</p>
        pub fn set_s(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s = input;
            self
        }
        /// <p>For number values, expressed as double.</p>
        pub fn n(mut self, input: f64) -> Self {
            self.n = Some(input);
            self
        }
        /// <p>For number values, expressed as double.</p>
        pub fn set_n(mut self, input: std::option::Option<f64>) -> Self {
            self.n = input;
            self
        }
        /// Appends an item to `sl`.
        ///
        /// To override the contents of this collection use [`set_sl`](Self::set_sl).
        ///
        /// <p>For a list of up to 100 strings. Maximum length for each string is 100 characters. Duplicate values are not recognized; all occurrences of the repeated value after the first of a repeated value are ignored.</p>
        pub fn sl(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.sl.unwrap_or_default();
            v.push(input.into());
            self.sl = Some(v);
            self
        }
        /// <p>For a list of up to 100 strings. Maximum length for each string is 100 characters. Duplicate values are not recognized; all occurrences of the repeated value after the first of a repeated value are ignored.</p>
        pub fn set_sl(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.sl = input;
            self
        }
        /// Adds a key-value pair to `sdm`.
        ///
        /// To override the contents of this collection use [`set_sdm`](Self::set_sdm).
        ///
        /// <p>For a map of up to 10 data type:value pairs. Maximum length for each string value is 100 characters. </p>
        pub fn sdm(mut self, k: impl Into<std::string::String>, v: f64) -> Self {
            let mut hash_map = self.sdm.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.sdm = Some(hash_map);
            self
        }
        /// <p>For a map of up to 10 data type:value pairs. Maximum length for each string value is 100 characters. </p>
        pub fn set_sdm(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, f64>>,
        ) -> Self {
            self.sdm = input;
            self
        }
        /// Consumes the builder and constructs a [`AttributeValue`](crate::model::AttributeValue)
        pub fn build(self) -> crate::model::AttributeValue {
            crate::model::AttributeValue {
                s: self.s,
                n: self.n,
                sl: self.sl,
                sdm: self.sdm,
            }
        }
    }
}
impl AttributeValue {
    /// Creates a new builder-style object to manufacture [`AttributeValue`](crate::model::AttributeValue)
    pub fn builder() -> crate::model::attribute_value::Builder {
        crate::model::attribute_value::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MatchmakingConfigurationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Placing,
    #[allow(missing_docs)] // documentation missing in model
    Queued,
    #[allow(missing_docs)] // documentation missing in model
    RequiresAcceptance,
    #[allow(missing_docs)] // documentation missing in model
    Searching,
    #[allow(missing_docs)] // documentation missing in model
    TimedOut,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MatchmakingConfigurationStatus {
    fn from(s: &str) -> Self {
        match s {
            "CANCELLED" => MatchmakingConfigurationStatus::Cancelled,
            "COMPLETED" => MatchmakingConfigurationStatus::Completed,
            "FAILED" => MatchmakingConfigurationStatus::Failed,
            "PLACING" => MatchmakingConfigurationStatus::Placing,
            "QUEUED" => MatchmakingConfigurationStatus::Queued,
            "REQUIRES_ACCEPTANCE" => MatchmakingConfigurationStatus::RequiresAcceptance,
            "SEARCHING" => MatchmakingConfigurationStatus::Searching,
            "TIMED_OUT" => MatchmakingConfigurationStatus::TimedOut,
            other => MatchmakingConfigurationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MatchmakingConfigurationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MatchmakingConfigurationStatus::from(s))
    }
}
impl MatchmakingConfigurationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MatchmakingConfigurationStatus::Cancelled => "CANCELLED",
            MatchmakingConfigurationStatus::Completed => "COMPLETED",
            MatchmakingConfigurationStatus::Failed => "FAILED",
            MatchmakingConfigurationStatus::Placing => "PLACING",
            MatchmakingConfigurationStatus::Queued => "QUEUED",
            MatchmakingConfigurationStatus::RequiresAcceptance => "REQUIRES_ACCEPTANCE",
            MatchmakingConfigurationStatus::Searching => "SEARCHING",
            MatchmakingConfigurationStatus::TimedOut => "TIMED_OUT",
            MatchmakingConfigurationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANCELLED",
            "COMPLETED",
            "FAILED",
            "PLACING",
            "QUEUED",
            "REQUIRES_ACCEPTANCE",
            "SEARCHING",
            "TIMED_OUT",
        ]
    }
}
impl AsRef<str> for MatchmakingConfigurationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Player information for use when creating player sessions using a game session placement request with <code>StartGameSessionPlacement</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DesiredPlayerSession {
    /// <p>A unique identifier for a player to associate with the player session.</p>
    pub player_id: std::option::Option<std::string::String>,
    /// <p>Developer-defined information related to a player. GameLift does not use this data, so it can be formatted as needed for use in the game.</p>
    pub player_data: std::option::Option<std::string::String>,
}
impl DesiredPlayerSession {
    /// <p>A unique identifier for a player to associate with the player session.</p>
    pub fn player_id(&self) -> std::option::Option<&str> {
        self.player_id.as_deref()
    }
    /// <p>Developer-defined information related to a player. GameLift does not use this data, so it can be formatted as needed for use in the game.</p>
    pub fn player_data(&self) -> std::option::Option<&str> {
        self.player_data.as_deref()
    }
}
impl std::fmt::Debug for DesiredPlayerSession {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DesiredPlayerSession");
        formatter.field("player_id", &self.player_id);
        formatter.field("player_data", &self.player_data);
        formatter.finish()
    }
}
/// See [`DesiredPlayerSession`](crate::model::DesiredPlayerSession)
pub mod desired_player_session {
    /// A builder for [`DesiredPlayerSession`](crate::model::DesiredPlayerSession)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) player_id: std::option::Option<std::string::String>,
        pub(crate) player_data: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for a player to associate with the player session.</p>
        pub fn player_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.player_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a player to associate with the player session.</p>
        pub fn set_player_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.player_id = input;
            self
        }
        /// <p>Developer-defined information related to a player. GameLift does not use this data, so it can be formatted as needed for use in the game.</p>
        pub fn player_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.player_data = Some(input.into());
            self
        }
        /// <p>Developer-defined information related to a player. GameLift does not use this data, so it can be formatted as needed for use in the game.</p>
        pub fn set_player_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.player_data = input;
            self
        }
        /// Consumes the builder and constructs a [`DesiredPlayerSession`](crate::model::DesiredPlayerSession)
        pub fn build(self) -> crate::model::DesiredPlayerSession {
            crate::model::DesiredPlayerSession {
                player_id: self.player_id,
                player_data: self.player_data,
            }
        }
    }
}
impl DesiredPlayerSession {
    /// Creates a new builder-style object to manufacture [`DesiredPlayerSession`](crate::model::DesiredPlayerSession)
    pub fn builder() -> crate::model::desired_player_session::Builder {
        crate::model::desired_player_session::Builder::default()
    }
}

/// <p>Temporary access credentials used for uploading game build files to Amazon GameLift. They are valid for a limited time. If they expire before you upload your game build, get a new set by calling <code>RequestUploadCredentials</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsCredentials {
    /// <p>Temporary key allowing access to the Amazon GameLift S3 account.</p>
    pub access_key_id: std::option::Option<std::string::String>,
    /// <p>Temporary secret key allowing access to the Amazon GameLift S3 account.</p>
    pub secret_access_key: std::option::Option<std::string::String>,
    /// <p>Token used to associate a specific build ID with the files uploaded using these credentials.</p>
    pub session_token: std::option::Option<std::string::String>,
}
impl AwsCredentials {
    /// <p>Temporary key allowing access to the Amazon GameLift S3 account.</p>
    pub fn access_key_id(&self) -> std::option::Option<&str> {
        self.access_key_id.as_deref()
    }
    /// <p>Temporary secret key allowing access to the Amazon GameLift S3 account.</p>
    pub fn secret_access_key(&self) -> std::option::Option<&str> {
        self.secret_access_key.as_deref()
    }
    /// <p>Token used to associate a specific build ID with the files uploaded using these credentials.</p>
    pub fn session_token(&self) -> std::option::Option<&str> {
        self.session_token.as_deref()
    }
}
impl std::fmt::Debug for AwsCredentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsCredentials");
        formatter.field("access_key_id", &self.access_key_id);
        formatter.field("secret_access_key", &self.secret_access_key);
        formatter.field("session_token", &self.session_token);
        formatter.finish()
    }
}
/// See [`AwsCredentials`](crate::model::AwsCredentials)
pub mod aws_credentials {
    /// A builder for [`AwsCredentials`](crate::model::AwsCredentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_key_id: std::option::Option<std::string::String>,
        pub(crate) secret_access_key: std::option::Option<std::string::String>,
        pub(crate) session_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Temporary key allowing access to the Amazon GameLift S3 account.</p>
        pub fn access_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_key_id = Some(input.into());
            self
        }
        /// <p>Temporary key allowing access to the Amazon GameLift S3 account.</p>
        pub fn set_access_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_key_id = input;
            self
        }
        /// <p>Temporary secret key allowing access to the Amazon GameLift S3 account.</p>
        pub fn secret_access_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_access_key = Some(input.into());
            self
        }
        /// <p>Temporary secret key allowing access to the Amazon GameLift S3 account.</p>
        pub fn set_secret_access_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secret_access_key = input;
            self
        }
        /// <p>Token used to associate a specific build ID with the files uploaded using these credentials.</p>
        pub fn session_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_token = Some(input.into());
            self
        }
        /// <p>Token used to associate a specific build ID with the files uploaded using these credentials.</p>
        pub fn set_session_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.session_token = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsCredentials`](crate::model::AwsCredentials)
        pub fn build(self) -> crate::model::AwsCredentials {
            crate::model::AwsCredentials {
                access_key_id: self.access_key_id,
                secret_access_key: self.secret_access_key,
                session_token: self.session_token,
            }
        }
    }
}
impl AwsCredentials {
    /// Creates a new builder-style object to manufacture [`AwsCredentials`](crate::model::AwsCredentials)
    pub fn builder() -> crate::model::aws_credentials::Builder {
        crate::model::aws_credentials::Builder::default()
    }
}

/// <p>Settings for a target-based scaling policy (see <code>ScalingPolicy</code>. A target-based policy tracks a particular fleet metric specifies a target value for the metric. As player usage changes, the policy triggers Amazon GameLift to adjust capacity so that the metric returns to the target value. The target configuration specifies settings as needed for the target based policy, including the target value. </p>
/// <p> <b>Related actions</b> </p>
/// <p> <code>DescribeFleetCapacity</code> | <code>UpdateFleetCapacity</code> | <code>DescribeEC2InstanceLimits</code> | <code>PutScalingPolicy</code> | <code>DescribeScalingPolicies</code> | <code>DeleteScalingPolicy</code> | <code>StopFleetActions</code> | <code>StartFleetActions</code> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TargetConfiguration {
    /// <p>Desired value to use with a target-based scaling policy. The value must be relevant for whatever metric the scaling policy is using. For example, in a policy using the metric PercentAvailableGameSessions, the target value should be the preferred size of the fleet's buffer (the percent of capacity that should be idle and ready for new game sessions).</p>
    pub target_value: f64,
}
impl TargetConfiguration {
    /// <p>Desired value to use with a target-based scaling policy. The value must be relevant for whatever metric the scaling policy is using. For example, in a policy using the metric PercentAvailableGameSessions, the target value should be the preferred size of the fleet's buffer (the percent of capacity that should be idle and ready for new game sessions).</p>
    pub fn target_value(&self) -> f64 {
        self.target_value
    }
}
impl std::fmt::Debug for TargetConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TargetConfiguration");
        formatter.field("target_value", &self.target_value);
        formatter.finish()
    }
}
/// See [`TargetConfiguration`](crate::model::TargetConfiguration)
pub mod target_configuration {
    /// A builder for [`TargetConfiguration`](crate::model::TargetConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_value: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>Desired value to use with a target-based scaling policy. The value must be relevant for whatever metric the scaling policy is using. For example, in a policy using the metric PercentAvailableGameSessions, the target value should be the preferred size of the fleet's buffer (the percent of capacity that should be idle and ready for new game sessions).</p>
        pub fn target_value(mut self, input: f64) -> Self {
            self.target_value = Some(input);
            self
        }
        /// <p>Desired value to use with a target-based scaling policy. The value must be relevant for whatever metric the scaling policy is using. For example, in a policy using the metric PercentAvailableGameSessions, the target value should be the preferred size of the fleet's buffer (the percent of capacity that should be idle and ready for new game sessions).</p>
        pub fn set_target_value(mut self, input: std::option::Option<f64>) -> Self {
            self.target_value = input;
            self
        }
        /// Consumes the builder and constructs a [`TargetConfiguration`](crate::model::TargetConfiguration)
        pub fn build(self) -> crate::model::TargetConfiguration {
            crate::model::TargetConfiguration {
                target_value: self.target_value.unwrap_or_default(),
            }
        }
    }
}
impl TargetConfiguration {
    /// Creates a new builder-style object to manufacture [`TargetConfiguration`](crate::model::TargetConfiguration)
    pub fn builder() -> crate::model::target_configuration::Builder {
        crate::model::target_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PolicyType {
    #[allow(missing_docs)] // documentation missing in model
    RuleBased,
    #[allow(missing_docs)] // documentation missing in model
    TargetBased,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PolicyType {
    fn from(s: &str) -> Self {
        match s {
            "RuleBased" => PolicyType::RuleBased,
            "TargetBased" => PolicyType::TargetBased,
            other => PolicyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PolicyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PolicyType::from(s))
    }
}
impl PolicyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PolicyType::RuleBased => "RuleBased",
            PolicyType::TargetBased => "TargetBased",
            PolicyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["RuleBased", "TargetBased"]
    }
}
impl AsRef<str> for PolicyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MetricName {
    #[allow(missing_docs)] // documentation missing in model
    ActivatingGameSessions,
    #[allow(missing_docs)] // documentation missing in model
    ActiveGameSessions,
    #[allow(missing_docs)] // documentation missing in model
    ActiveInstances,
    #[allow(missing_docs)] // documentation missing in model
    AvailableGameSessions,
    #[allow(missing_docs)] // documentation missing in model
    AvailablePlayerSessions,
    #[allow(missing_docs)] // documentation missing in model
    CurrentPlayerSessions,
    #[allow(missing_docs)] // documentation missing in model
    IdleInstances,
    #[allow(missing_docs)] // documentation missing in model
    PercentAvailableGameSessions,
    #[allow(missing_docs)] // documentation missing in model
    PercentIdleInstances,
    #[allow(missing_docs)] // documentation missing in model
    QueueDepth,
    #[allow(missing_docs)] // documentation missing in model
    WaitTime,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MetricName {
    fn from(s: &str) -> Self {
        match s {
            "ActivatingGameSessions" => MetricName::ActivatingGameSessions,
            "ActiveGameSessions" => MetricName::ActiveGameSessions,
            "ActiveInstances" => MetricName::ActiveInstances,
            "AvailableGameSessions" => MetricName::AvailableGameSessions,
            "AvailablePlayerSessions" => MetricName::AvailablePlayerSessions,
            "CurrentPlayerSessions" => MetricName::CurrentPlayerSessions,
            "IdleInstances" => MetricName::IdleInstances,
            "PercentAvailableGameSessions" => MetricName::PercentAvailableGameSessions,
            "PercentIdleInstances" => MetricName::PercentIdleInstances,
            "QueueDepth" => MetricName::QueueDepth,
            "WaitTime" => MetricName::WaitTime,
            other => MetricName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MetricName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MetricName::from(s))
    }
}
impl MetricName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MetricName::ActivatingGameSessions => "ActivatingGameSessions",
            MetricName::ActiveGameSessions => "ActiveGameSessions",
            MetricName::ActiveInstances => "ActiveInstances",
            MetricName::AvailableGameSessions => "AvailableGameSessions",
            MetricName::AvailablePlayerSessions => "AvailablePlayerSessions",
            MetricName::CurrentPlayerSessions => "CurrentPlayerSessions",
            MetricName::IdleInstances => "IdleInstances",
            MetricName::PercentAvailableGameSessions => "PercentAvailableGameSessions",
            MetricName::PercentIdleInstances => "PercentIdleInstances",
            MetricName::QueueDepth => "QueueDepth",
            MetricName::WaitTime => "WaitTime",
            MetricName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ActivatingGameSessions",
            "ActiveGameSessions",
            "ActiveInstances",
            "AvailableGameSessions",
            "AvailablePlayerSessions",
            "CurrentPlayerSessions",
            "IdleInstances",
            "PercentAvailableGameSessions",
            "PercentIdleInstances",
            "QueueDepth",
            "WaitTime",
        ]
    }
}
impl AsRef<str> for MetricName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ComparisonOperatorType {
    #[allow(missing_docs)] // documentation missing in model
    GreaterThanOrEqualToThreshold,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThanThreshold,
    #[allow(missing_docs)] // documentation missing in model
    LessThanOrEqualToThreshold,
    #[allow(missing_docs)] // documentation missing in model
    LessThanThreshold,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ComparisonOperatorType {
    fn from(s: &str) -> Self {
        match s {
            "GreaterThanOrEqualToThreshold" => {
                ComparisonOperatorType::GreaterThanOrEqualToThreshold
            }
            "GreaterThanThreshold" => ComparisonOperatorType::GreaterThanThreshold,
            "LessThanOrEqualToThreshold" => ComparisonOperatorType::LessThanOrEqualToThreshold,
            "LessThanThreshold" => ComparisonOperatorType::LessThanThreshold,
            other => ComparisonOperatorType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ComparisonOperatorType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ComparisonOperatorType::from(s))
    }
}
impl ComparisonOperatorType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ComparisonOperatorType::GreaterThanOrEqualToThreshold => {
                "GreaterThanOrEqualToThreshold"
            }
            ComparisonOperatorType::GreaterThanThreshold => "GreaterThanThreshold",
            ComparisonOperatorType::LessThanOrEqualToThreshold => "LessThanOrEqualToThreshold",
            ComparisonOperatorType::LessThanThreshold => "LessThanThreshold",
            ComparisonOperatorType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "GreaterThanOrEqualToThreshold",
            "GreaterThanThreshold",
            "LessThanOrEqualToThreshold",
            "LessThanThreshold",
        ]
    }
}
impl AsRef<str> for ComparisonOperatorType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScalingAdjustmentType {
    #[allow(missing_docs)] // documentation missing in model
    ChangeInCapacity,
    #[allow(missing_docs)] // documentation missing in model
    ExactCapacity,
    #[allow(missing_docs)] // documentation missing in model
    PercentChangeInCapacity,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScalingAdjustmentType {
    fn from(s: &str) -> Self {
        match s {
            "ChangeInCapacity" => ScalingAdjustmentType::ChangeInCapacity,
            "ExactCapacity" => ScalingAdjustmentType::ExactCapacity,
            "PercentChangeInCapacity" => ScalingAdjustmentType::PercentChangeInCapacity,
            other => ScalingAdjustmentType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScalingAdjustmentType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScalingAdjustmentType::from(s))
    }
}
impl ScalingAdjustmentType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScalingAdjustmentType::ChangeInCapacity => "ChangeInCapacity",
            ScalingAdjustmentType::ExactCapacity => "ExactCapacity",
            ScalingAdjustmentType::PercentChangeInCapacity => "PercentChangeInCapacity",
            ScalingAdjustmentType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ChangeInCapacity",
            "ExactCapacity",
            "PercentChangeInCapacity",
        ]
    }
}
impl AsRef<str> for ScalingAdjustmentType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SortOrder {
    #[allow(missing_docs)] // documentation missing in model
    Ascending,
    #[allow(missing_docs)] // documentation missing in model
    Descending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SortOrder {
    fn from(s: &str) -> Self {
        match s {
            "ASCENDING" => SortOrder::Ascending,
            "DESCENDING" => SortOrder::Descending,
            other => SortOrder::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SortOrder {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SortOrder::from(s))
    }
}
impl SortOrder {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SortOrder::Ascending => "ASCENDING",
            SortOrder::Descending => "DESCENDING",
            SortOrder::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASCENDING", "DESCENDING"]
    }
}
impl AsRef<str> for SortOrder {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information required to remotely connect to a fleet instance. Access is requested by calling <code>GetInstanceAccess</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceAccess {
    /// <p>A unique identifier for the fleet containing the instance being accessed.</p>
    pub fleet_id: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the instance being accessed.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>IP address that is assigned to the instance.</p>
    pub ip_address: std::option::Option<std::string::String>,
    /// <p>Operating system that is running on the instance.</p>
    pub operating_system: std::option::Option<crate::model::OperatingSystem>,
    /// <p>Credentials required to access the instance.</p>
    pub credentials: std::option::Option<crate::model::InstanceCredentials>,
}
impl InstanceAccess {
    /// <p>A unique identifier for the fleet containing the instance being accessed.</p>
    pub fn fleet_id(&self) -> std::option::Option<&str> {
        self.fleet_id.as_deref()
    }
    /// <p>A unique identifier for the instance being accessed.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>IP address that is assigned to the instance.</p>
    pub fn ip_address(&self) -> std::option::Option<&str> {
        self.ip_address.as_deref()
    }
    /// <p>Operating system that is running on the instance.</p>
    pub fn operating_system(&self) -> std::option::Option<&crate::model::OperatingSystem> {
        self.operating_system.as_ref()
    }
    /// <p>Credentials required to access the instance.</p>
    pub fn credentials(&self) -> std::option::Option<&crate::model::InstanceCredentials> {
        self.credentials.as_ref()
    }
}
impl std::fmt::Debug for InstanceAccess {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceAccess");
        formatter.field("fleet_id", &self.fleet_id);
        formatter.field("instance_id", &self.instance_id);
        formatter.field("ip_address", &self.ip_address);
        formatter.field("operating_system", &self.operating_system);
        formatter.field("credentials", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`InstanceAccess`](crate::model::InstanceAccess)
pub mod instance_access {
    /// A builder for [`InstanceAccess`](crate::model::InstanceAccess)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) ip_address: std::option::Option<std::string::String>,
        pub(crate) operating_system: std::option::Option<crate::model::OperatingSystem>,
        pub(crate) credentials: std::option::Option<crate::model::InstanceCredentials>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet containing the instance being accessed.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet containing the instance being accessed.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p>A unique identifier for the instance being accessed.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the instance being accessed.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>IP address that is assigned to the instance.</p>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address = Some(input.into());
            self
        }
        /// <p>IP address that is assigned to the instance.</p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_address = input;
            self
        }
        /// <p>Operating system that is running on the instance.</p>
        pub fn operating_system(mut self, input: crate::model::OperatingSystem) -> Self {
            self.operating_system = Some(input);
            self
        }
        /// <p>Operating system that is running on the instance.</p>
        pub fn set_operating_system(
            mut self,
            input: std::option::Option<crate::model::OperatingSystem>,
        ) -> Self {
            self.operating_system = input;
            self
        }
        /// <p>Credentials required to access the instance.</p>
        pub fn credentials(mut self, input: crate::model::InstanceCredentials) -> Self {
            self.credentials = Some(input);
            self
        }
        /// <p>Credentials required to access the instance.</p>
        pub fn set_credentials(
            mut self,
            input: std::option::Option<crate::model::InstanceCredentials>,
        ) -> Self {
            self.credentials = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceAccess`](crate::model::InstanceAccess)
        pub fn build(self) -> crate::model::InstanceAccess {
            crate::model::InstanceAccess {
                fleet_id: self.fleet_id,
                instance_id: self.instance_id,
                ip_address: self.ip_address,
                operating_system: self.operating_system,
                credentials: self.credentials,
            }
        }
    }
}
impl InstanceAccess {
    /// Creates a new builder-style object to manufacture [`InstanceAccess`](crate::model::InstanceAccess)
    pub fn builder() -> crate::model::instance_access::Builder {
        crate::model::instance_access::Builder::default()
    }
}

/// <p>Set of credentials required to remotely access a fleet instance. Access credentials are requested by calling <code>GetInstanceAccess</code> and returned in an <code>InstanceAccess</code> object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceCredentials {
    /// <p>User login string.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>Secret string. For Windows instances, the secret is a password for use with Windows Remote Desktop. For Linux instances, it is a private key (which must be saved as a <code>.pem</code> file) for use with SSH.</p>
    pub secret: std::option::Option<std::string::String>,
}
impl InstanceCredentials {
    /// <p>User login string.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>Secret string. For Windows instances, the secret is a password for use with Windows Remote Desktop. For Linux instances, it is a private key (which must be saved as a <code>.pem</code> file) for use with SSH.</p>
    pub fn secret(&self) -> std::option::Option<&str> {
        self.secret.as_deref()
    }
}
impl std::fmt::Debug for InstanceCredentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceCredentials");
        formatter.field("user_name", &self.user_name);
        formatter.field("secret", &self.secret);
        formatter.finish()
    }
}
/// See [`InstanceCredentials`](crate::model::InstanceCredentials)
pub mod instance_credentials {
    /// A builder for [`InstanceCredentials`](crate::model::InstanceCredentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) secret: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>User login string.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>User login string.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>Secret string. For Windows instances, the secret is a password for use with Windows Remote Desktop. For Linux instances, it is a private key (which must be saved as a <code>.pem</code> file) for use with SSH.</p>
        pub fn secret(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret = Some(input.into());
            self
        }
        /// <p>Secret string. For Windows instances, the secret is a password for use with Windows Remote Desktop. For Linux instances, it is a private key (which must be saved as a <code>.pem</code> file) for use with SSH.</p>
        pub fn set_secret(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceCredentials`](crate::model::InstanceCredentials)
        pub fn build(self) -> crate::model::InstanceCredentials {
            crate::model::InstanceCredentials {
                user_name: self.user_name,
                secret: self.secret,
            }
        }
    }
}
impl InstanceCredentials {
    /// Creates a new builder-style object to manufacture [`InstanceCredentials`](crate::model::InstanceCredentials)
    pub fn builder() -> crate::model::instance_credentials::Builder {
        crate::model::instance_credentials::Builder::default()
    }
}

/// <p>Represents a peering connection between a VPC on one of your Amazon Web Services accounts and the VPC for your Amazon GameLift fleets. This record may be for an active peering connection or a pending connection that has not yet been established.</p>
/// <p> <b>Related actions</b> </p>
/// <p> <code>CreateVpcPeeringAuthorization</code> | <code>DescribeVpcPeeringAuthorizations</code> | <code>DeleteVpcPeeringAuthorization</code> | <code>CreateVpcPeeringConnection</code> | <code>DescribeVpcPeeringConnections</code> | <code>DeleteVpcPeeringConnection</code> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcPeeringConnection {
    /// <p>A unique identifier for the fleet. This ID determines the ID of the Amazon GameLift VPC for your fleet.</p>
    pub fleet_id: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift fleet resource for this connection. </p>
    pub fleet_arn: std::option::Option<std::string::String>,
    /// <p>CIDR block of IPv4 addresses assigned to the VPC peering connection for the GameLift VPC. The peered VPC also has an IPv4 CIDR block associated with it; these blocks cannot overlap or the peering connection cannot be created. </p>
    pub ip_v4_cidr_block: std::option::Option<std::string::String>,
    /// <p>A unique identifier that is automatically assigned to the connection record. This ID is referenced in VPC peering connection events, and is used when deleting a connection with <code>DeleteVpcPeeringConnection</code>. </p>
    pub vpc_peering_connection_id: std::option::Option<std::string::String>,
    /// <p>The status information about the connection. Status indicates if a connection is pending, successful, or failed.</p>
    pub status: std::option::Option<crate::model::VpcPeeringConnectionStatus>,
    /// <p>A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in the same Region as your fleet. To look up a VPC ID, use the <a href="https://console.aws.amazon.com/vpc/">VPC Dashboard</a> in the Amazon Web Services Management Console. Learn more about VPC peering in <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift Fleets</a>.</p>
    pub peer_vpc_id: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the VPC that contains the Amazon GameLift fleet for this connection. This VPC is managed by Amazon GameLift and does not appear in your Amazon Web Services account. </p>
    pub game_lift_vpc_id: std::option::Option<std::string::String>,
}
impl VpcPeeringConnection {
    /// <p>A unique identifier for the fleet. This ID determines the ID of the Amazon GameLift VPC for your fleet.</p>
    pub fn fleet_id(&self) -> std::option::Option<&str> {
        self.fleet_id.as_deref()
    }
    /// <p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift fleet resource for this connection. </p>
    pub fn fleet_arn(&self) -> std::option::Option<&str> {
        self.fleet_arn.as_deref()
    }
    /// <p>CIDR block of IPv4 addresses assigned to the VPC peering connection for the GameLift VPC. The peered VPC also has an IPv4 CIDR block associated with it; these blocks cannot overlap or the peering connection cannot be created. </p>
    pub fn ip_v4_cidr_block(&self) -> std::option::Option<&str> {
        self.ip_v4_cidr_block.as_deref()
    }
    /// <p>A unique identifier that is automatically assigned to the connection record. This ID is referenced in VPC peering connection events, and is used when deleting a connection with <code>DeleteVpcPeeringConnection</code>. </p>
    pub fn vpc_peering_connection_id(&self) -> std::option::Option<&str> {
        self.vpc_peering_connection_id.as_deref()
    }
    /// <p>The status information about the connection. Status indicates if a connection is pending, successful, or failed.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::VpcPeeringConnectionStatus> {
        self.status.as_ref()
    }
    /// <p>A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in the same Region as your fleet. To look up a VPC ID, use the <a href="https://console.aws.amazon.com/vpc/">VPC Dashboard</a> in the Amazon Web Services Management Console. Learn more about VPC peering in <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift Fleets</a>.</p>
    pub fn peer_vpc_id(&self) -> std::option::Option<&str> {
        self.peer_vpc_id.as_deref()
    }
    /// <p>A unique identifier for the VPC that contains the Amazon GameLift fleet for this connection. This VPC is managed by Amazon GameLift and does not appear in your Amazon Web Services account. </p>
    pub fn game_lift_vpc_id(&self) -> std::option::Option<&str> {
        self.game_lift_vpc_id.as_deref()
    }
}
impl std::fmt::Debug for VpcPeeringConnection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcPeeringConnection");
        formatter.field("fleet_id", &self.fleet_id);
        formatter.field("fleet_arn", &self.fleet_arn);
        formatter.field("ip_v4_cidr_block", &self.ip_v4_cidr_block);
        formatter.field("vpc_peering_connection_id", &self.vpc_peering_connection_id);
        formatter.field("status", &self.status);
        formatter.field("peer_vpc_id", &self.peer_vpc_id);
        formatter.field("game_lift_vpc_id", &self.game_lift_vpc_id);
        formatter.finish()
    }
}
/// See [`VpcPeeringConnection`](crate::model::VpcPeeringConnection)
pub mod vpc_peering_connection {
    /// A builder for [`VpcPeeringConnection`](crate::model::VpcPeeringConnection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) fleet_arn: std::option::Option<std::string::String>,
        pub(crate) ip_v4_cidr_block: std::option::Option<std::string::String>,
        pub(crate) vpc_peering_connection_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::VpcPeeringConnectionStatus>,
        pub(crate) peer_vpc_id: std::option::Option<std::string::String>,
        pub(crate) game_lift_vpc_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet. This ID determines the ID of the Amazon GameLift VPC for your fleet.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet. This ID determines the ID of the Amazon GameLift VPC for your fleet.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift fleet resource for this connection. </p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift fleet resource for this connection. </p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_arn = input;
            self
        }
        /// <p>CIDR block of IPv4 addresses assigned to the VPC peering connection for the GameLift VPC. The peered VPC also has an IPv4 CIDR block associated with it; these blocks cannot overlap or the peering connection cannot be created. </p>
        pub fn ip_v4_cidr_block(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_v4_cidr_block = Some(input.into());
            self
        }
        /// <p>CIDR block of IPv4 addresses assigned to the VPC peering connection for the GameLift VPC. The peered VPC also has an IPv4 CIDR block associated with it; these blocks cannot overlap or the peering connection cannot be created. </p>
        pub fn set_ip_v4_cidr_block(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ip_v4_cidr_block = input;
            self
        }
        /// <p>A unique identifier that is automatically assigned to the connection record. This ID is referenced in VPC peering connection events, and is used when deleting a connection with <code>DeleteVpcPeeringConnection</code>. </p>
        pub fn vpc_peering_connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_peering_connection_id = Some(input.into());
            self
        }
        /// <p>A unique identifier that is automatically assigned to the connection record. This ID is referenced in VPC peering connection events, and is used when deleting a connection with <code>DeleteVpcPeeringConnection</code>. </p>
        pub fn set_vpc_peering_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_peering_connection_id = input;
            self
        }
        /// <p>The status information about the connection. Status indicates if a connection is pending, successful, or failed.</p>
        pub fn status(mut self, input: crate::model::VpcPeeringConnectionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status information about the connection. Status indicates if a connection is pending, successful, or failed.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::VpcPeeringConnectionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in the same Region as your fleet. To look up a VPC ID, use the <a href="https://console.aws.amazon.com/vpc/">VPC Dashboard</a> in the Amazon Web Services Management Console. Learn more about VPC peering in <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift Fleets</a>.</p>
        pub fn peer_vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.peer_vpc_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in the same Region as your fleet. To look up a VPC ID, use the <a href="https://console.aws.amazon.com/vpc/">VPC Dashboard</a> in the Amazon Web Services Management Console. Learn more about VPC peering in <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift Fleets</a>.</p>
        pub fn set_peer_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.peer_vpc_id = input;
            self
        }
        /// <p>A unique identifier for the VPC that contains the Amazon GameLift fleet for this connection. This VPC is managed by Amazon GameLift and does not appear in your Amazon Web Services account. </p>
        pub fn game_lift_vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_lift_vpc_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the VPC that contains the Amazon GameLift fleet for this connection. This VPC is managed by Amazon GameLift and does not appear in your Amazon Web Services account. </p>
        pub fn set_game_lift_vpc_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_lift_vpc_id = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcPeeringConnection`](crate::model::VpcPeeringConnection)
        pub fn build(self) -> crate::model::VpcPeeringConnection {
            crate::model::VpcPeeringConnection {
                fleet_id: self.fleet_id,
                fleet_arn: self.fleet_arn,
                ip_v4_cidr_block: self.ip_v4_cidr_block,
                vpc_peering_connection_id: self.vpc_peering_connection_id,
                status: self.status,
                peer_vpc_id: self.peer_vpc_id,
                game_lift_vpc_id: self.game_lift_vpc_id,
            }
        }
    }
}
impl VpcPeeringConnection {
    /// Creates a new builder-style object to manufacture [`VpcPeeringConnection`](crate::model::VpcPeeringConnection)
    pub fn builder() -> crate::model::vpc_peering_connection::Builder {
        crate::model::vpc_peering_connection::Builder::default()
    }
}

/// <p>Represents status information for a VPC peering connection. Status is associated with a <code>VpcPeeringConnection</code> object. Status codes and messages are provided from EC2 (see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_VpcPeeringConnectionStateReason.html">VpcPeeringConnectionStateReason</a>). Connection status information is also communicated as a fleet <code>Event</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcPeeringConnectionStatus {
    /// <p>Code indicating the status of a VPC peering connection.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>Additional messaging associated with the connection status. </p>
    pub message: std::option::Option<std::string::String>,
}
impl VpcPeeringConnectionStatus {
    /// <p>Code indicating the status of a VPC peering connection.</p>
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>Additional messaging associated with the connection status. </p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for VpcPeeringConnectionStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcPeeringConnectionStatus");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`VpcPeeringConnectionStatus`](crate::model::VpcPeeringConnectionStatus)
pub mod vpc_peering_connection_status {
    /// A builder for [`VpcPeeringConnectionStatus`](crate::model::VpcPeeringConnectionStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Code indicating the status of a VPC peering connection.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>Code indicating the status of a VPC peering connection.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>Additional messaging associated with the connection status. </p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Additional messaging associated with the connection status. </p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcPeeringConnectionStatus`](crate::model::VpcPeeringConnectionStatus)
        pub fn build(self) -> crate::model::VpcPeeringConnectionStatus {
            crate::model::VpcPeeringConnectionStatus {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl VpcPeeringConnectionStatus {
    /// Creates a new builder-style object to manufacture [`VpcPeeringConnectionStatus`](crate::model::VpcPeeringConnectionStatus)
    pub fn builder() -> crate::model::vpc_peering_connection_status::Builder {
        crate::model::vpc_peering_connection_status::Builder::default()
    }
}

/// <p>Represents an authorization for a VPC peering connection between the VPC for an Amazon GameLift fleet and another VPC on an account you have access to. This authorization must exist and be valid for the peering connection to be established. Authorizations are valid for 24 hours after they are issued.</p>
/// <p> <b>Related actions</b> </p>
/// <p> <code>CreateVpcPeeringAuthorization</code> | <code>DescribeVpcPeeringAuthorizations</code> | <code>DeleteVpcPeeringAuthorization</code> | <code>CreateVpcPeeringConnection</code> | <code>DescribeVpcPeeringConnections</code> | <code>DeleteVpcPeeringConnection</code> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcPeeringAuthorization {
    /// <p>A unique identifier for the Amazon Web Services account that you use to manage your GameLift fleet. You can find your Account ID in the Amazon Web Services Management Console under account settings.</p>
    pub game_lift_aws_account_id: std::option::Option<std::string::String>,
    /// <p></p>
    pub peer_vpc_aws_account_id: std::option::Option<std::string::String>,
    /// <p>A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in the same Region as your fleet. To look up a VPC ID, use the <a href="https://console.aws.amazon.com/vpc/">VPC Dashboard</a> in the Amazon Web Services Management Console. Learn more about VPC peering in <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift Fleets</a>.</p>
    pub peer_vpc_id: std::option::Option<std::string::String>,
    /// <p>Time stamp indicating when this authorization was issued. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Time stamp indicating when this authorization expires (24 hours after issuance). Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub expiration_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl VpcPeeringAuthorization {
    /// <p>A unique identifier for the Amazon Web Services account that you use to manage your GameLift fleet. You can find your Account ID in the Amazon Web Services Management Console under account settings.</p>
    pub fn game_lift_aws_account_id(&self) -> std::option::Option<&str> {
        self.game_lift_aws_account_id.as_deref()
    }
    /// <p></p>
    pub fn peer_vpc_aws_account_id(&self) -> std::option::Option<&str> {
        self.peer_vpc_aws_account_id.as_deref()
    }
    /// <p>A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in the same Region as your fleet. To look up a VPC ID, use the <a href="https://console.aws.amazon.com/vpc/">VPC Dashboard</a> in the Amazon Web Services Management Console. Learn more about VPC peering in <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift Fleets</a>.</p>
    pub fn peer_vpc_id(&self) -> std::option::Option<&str> {
        self.peer_vpc_id.as_deref()
    }
    /// <p>Time stamp indicating when this authorization was issued. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>Time stamp indicating when this authorization expires (24 hours after issuance). Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub fn expiration_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.expiration_time.as_ref()
    }
}
impl std::fmt::Debug for VpcPeeringAuthorization {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcPeeringAuthorization");
        formatter.field("game_lift_aws_account_id", &self.game_lift_aws_account_id);
        formatter.field("peer_vpc_aws_account_id", &self.peer_vpc_aws_account_id);
        formatter.field("peer_vpc_id", &self.peer_vpc_id);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("expiration_time", &self.expiration_time);
        formatter.finish()
    }
}
/// See [`VpcPeeringAuthorization`](crate::model::VpcPeeringAuthorization)
pub mod vpc_peering_authorization {
    /// A builder for [`VpcPeeringAuthorization`](crate::model::VpcPeeringAuthorization)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_lift_aws_account_id: std::option::Option<std::string::String>,
        pub(crate) peer_vpc_aws_account_id: std::option::Option<std::string::String>,
        pub(crate) peer_vpc_id: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) expiration_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>A unique identifier for the Amazon Web Services account that you use to manage your GameLift fleet. You can find your Account ID in the Amazon Web Services Management Console under account settings.</p>
        pub fn game_lift_aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_lift_aws_account_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the Amazon Web Services account that you use to manage your GameLift fleet. You can find your Account ID in the Amazon Web Services Management Console under account settings.</p>
        pub fn set_game_lift_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_lift_aws_account_id = input;
            self
        }
        /// <p></p>
        pub fn peer_vpc_aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.peer_vpc_aws_account_id = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_peer_vpc_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.peer_vpc_aws_account_id = input;
            self
        }
        /// <p>A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in the same Region as your fleet. To look up a VPC ID, use the <a href="https://console.aws.amazon.com/vpc/">VPC Dashboard</a> in the Amazon Web Services Management Console. Learn more about VPC peering in <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift Fleets</a>.</p>
        pub fn peer_vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.peer_vpc_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in the same Region as your fleet. To look up a VPC ID, use the <a href="https://console.aws.amazon.com/vpc/">VPC Dashboard</a> in the Amazon Web Services Management Console. Learn more about VPC peering in <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift Fleets</a>.</p>
        pub fn set_peer_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.peer_vpc_id = input;
            self
        }
        /// <p>Time stamp indicating when this authorization was issued. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>Time stamp indicating when this authorization was issued. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>Time stamp indicating when this authorization expires (24 hours after issuance). Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn expiration_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.expiration_time = Some(input);
            self
        }
        /// <p>Time stamp indicating when this authorization expires (24 hours after issuance). Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn set_expiration_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.expiration_time = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcPeeringAuthorization`](crate::model::VpcPeeringAuthorization)
        pub fn build(self) -> crate::model::VpcPeeringAuthorization {
            crate::model::VpcPeeringAuthorization {
                game_lift_aws_account_id: self.game_lift_aws_account_id,
                peer_vpc_aws_account_id: self.peer_vpc_aws_account_id,
                peer_vpc_id: self.peer_vpc_id,
                creation_time: self.creation_time,
                expiration_time: self.expiration_time,
            }
        }
    }
}
impl VpcPeeringAuthorization {
    /// Creates a new builder-style object to manufacture [`VpcPeeringAuthorization`](crate::model::VpcPeeringAuthorization)
    pub fn builder() -> crate::model::vpc_peering_authorization::Builder {
        crate::model::vpc_peering_authorization::Builder::default()
    }
}

/// <p>Rule that controls how a fleet is scaled. Scaling policies are uniquely identified by the combination of name and fleet ID.</p>
/// <p> <b>Related actions</b> </p>
/// <p> <code>DescribeFleetCapacity</code> | <code>UpdateFleetCapacity</code> | <code>DescribeEC2InstanceLimits</code> | <code>PutScalingPolicy</code> | <code>DescribeScalingPolicies</code> | <code>DeleteScalingPolicy</code> | <code>StopFleetActions</code> | <code>StartFleetActions</code> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScalingPolicy {
    /// <p>A unique identifier for the fleet that is associated with this scaling policy.</p>
    pub fleet_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
    /// </region></code>.</p>
    pub fleet_arn: std::option::Option<std::string::String>,
    /// <p>A descriptive label that is associated with a fleet's scaling policy. Policy names do not need to be unique.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Current status of the scaling policy. The scaling policy can be in force only when in an <code>ACTIVE</code> status. Scaling policies can be suspended for individual fleets (see <code>StopFleetActions</code>; if suspended for a fleet, the policy status does not change. View a fleet's stopped actions by calling <code>DescribeFleetCapacity</code>.</p>
    /// <ul>
    /// <li> <p> <b>ACTIVE</b> -- The scaling policy can be used for auto-scaling a fleet.</p> </li>
    /// <li> <p> <b>UPDATE_REQUESTED</b> -- A request to update the scaling policy has been received.</p> </li>
    /// <li> <p> <b>UPDATING</b> -- A change is being made to the scaling policy.</p> </li>
    /// <li> <p> <b>DELETE_REQUESTED</b> -- A request to delete the scaling policy has been received.</p> </li>
    /// <li> <p> <b>DELETING</b> -- The scaling policy is being deleted.</p> </li>
    /// <li> <p> <b>DELETED</b> -- The scaling policy has been deleted.</p> </li>
    /// <li> <p> <b>ERROR</b> -- An error occurred in creating the policy. It should be removed and recreated.</p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::ScalingStatusType>,
    /// <p>Amount of adjustment to make, based on the scaling adjustment type.</p>
    pub scaling_adjustment: i32,
    /// <p>The type of adjustment to make to a fleet's instance count (see <code>FleetCapacity</code>):</p>
    /// <ul>
    /// <li> <p> <b>ChangeInCapacity</b> -- add (or subtract) the scaling adjustment value from the current instance count. Positive values scale up while negative values scale down.</p> </li>
    /// <li> <p> <b>ExactCapacity</b> -- set the instance count to the scaling adjustment value.</p> </li>
    /// <li> <p> <b>PercentChangeInCapacity</b> -- increase or reduce the current instance count by the scaling adjustment, read as a percentage. Positive values scale up while negative values scale down.</p> </li>
    /// </ul>
    pub scaling_adjustment_type: std::option::Option<crate::model::ScalingAdjustmentType>,
    /// <p>Comparison operator to use when measuring a metric against the threshold value.</p>
    pub comparison_operator: std::option::Option<crate::model::ComparisonOperatorType>,
    /// <p>Metric value used to trigger a scaling event.</p>
    pub threshold: f64,
    /// <p>Length of time (in minutes) the metric must be at or beyond the threshold before a scaling event is triggered.</p>
    pub evaluation_periods: std::option::Option<i32>,
    /// <p>Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment. For detailed descriptions of fleet metrics, see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html">Monitor Amazon GameLift with Amazon CloudWatch</a>. </p>
    /// <ul>
    /// <li> <p> <b>ActivatingGameSessions</b> -- Game sessions in the process of being created.</p> </li>
    /// <li> <p> <b>ActiveGameSessions</b> -- Game sessions that are currently running.</p> </li>
    /// <li> <p> <b>ActiveInstances</b> -- Fleet instances that are currently running at least one game session.</p> </li>
    /// <li> <p> <b>AvailableGameSessions</b> -- Additional game sessions that fleet could host simultaneously, given current capacity.</p> </li>
    /// <li> <p> <b>AvailablePlayerSessions</b> -- Empty player slots in currently active game sessions. This includes game sessions that are not currently accepting players. Reserved player slots are not included.</p> </li>
    /// <li> <p> <b>CurrentPlayerSessions</b> -- Player slots in active game sessions that are being used by a player or are reserved for a player. </p> </li>
    /// <li> <p> <b>IdleInstances</b> -- Active instances that are currently hosting zero game sessions. </p> </li>
    /// <li> <p> <b>PercentAvailableGameSessions</b> -- Unused percentage of the total number of game sessions that a fleet could host simultaneously, given current capacity. Use this metric for a target-based scaling policy.</p> </li>
    /// <li> <p> <b>PercentIdleInstances</b> -- Percentage of the total number of active instances that are hosting zero game sessions.</p> </li>
    /// <li> <p> <b>QueueDepth</b> -- Pending game session placement requests, in any queue, where the current fleet is the top-priority destination.</p> </li>
    /// <li> <p> <b>WaitTime</b> -- Current wait time for pending game session placement requests, in any queue, where the current fleet is the top-priority destination. </p> </li>
    /// </ul>
    pub metric_name: std::option::Option<crate::model::MetricName>,
    /// <p>The type of scaling policy to create. For a target-based policy, set the parameter <i>MetricName</i> to 'PercentAvailableGameSessions' and specify a <i>TargetConfiguration</i>. For a rule-based policy set the following parameters: <i>MetricName</i>, <i>ComparisonOperator</i>, <i>Threshold</i>, <i>EvaluationPeriods</i>, <i>ScalingAdjustmentType</i>, and <i>ScalingAdjustment</i>.</p>
    pub policy_type: std::option::Option<crate::model::PolicyType>,
    /// <p>An object that contains settings for a target-based scaling policy.</p>
    pub target_configuration: std::option::Option<crate::model::TargetConfiguration>,
    /// <p>The current status of the fleet's scaling policies in a requested fleet location. The status <code>PENDING_UPDATE</code> indicates that an update was requested for the fleet but has not yet been completed for the location.</p>
    pub update_status: std::option::Option<crate::model::LocationUpdateStatus>,
    /// <p> The fleet location. </p>
    pub location: std::option::Option<std::string::String>,
}
impl ScalingPolicy {
    /// <p>A unique identifier for the fleet that is associated with this scaling policy.</p>
    pub fn fleet_id(&self) -> std::option::Option<&str> {
        self.fleet_id.as_deref()
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
    /// </region></code>.</p>
    pub fn fleet_arn(&self) -> std::option::Option<&str> {
        self.fleet_arn.as_deref()
    }
    /// <p>A descriptive label that is associated with a fleet's scaling policy. Policy names do not need to be unique.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Current status of the scaling policy. The scaling policy can be in force only when in an <code>ACTIVE</code> status. Scaling policies can be suspended for individual fleets (see <code>StopFleetActions</code>; if suspended for a fleet, the policy status does not change. View a fleet's stopped actions by calling <code>DescribeFleetCapacity</code>.</p>
    /// <ul>
    /// <li> <p> <b>ACTIVE</b> -- The scaling policy can be used for auto-scaling a fleet.</p> </li>
    /// <li> <p> <b>UPDATE_REQUESTED</b> -- A request to update the scaling policy has been received.</p> </li>
    /// <li> <p> <b>UPDATING</b> -- A change is being made to the scaling policy.</p> </li>
    /// <li> <p> <b>DELETE_REQUESTED</b> -- A request to delete the scaling policy has been received.</p> </li>
    /// <li> <p> <b>DELETING</b> -- The scaling policy is being deleted.</p> </li>
    /// <li> <p> <b>DELETED</b> -- The scaling policy has been deleted.</p> </li>
    /// <li> <p> <b>ERROR</b> -- An error occurred in creating the policy. It should be removed and recreated.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::ScalingStatusType> {
        self.status.as_ref()
    }
    /// <p>Amount of adjustment to make, based on the scaling adjustment type.</p>
    pub fn scaling_adjustment(&self) -> i32 {
        self.scaling_adjustment
    }
    /// <p>The type of adjustment to make to a fleet's instance count (see <code>FleetCapacity</code>):</p>
    /// <ul>
    /// <li> <p> <b>ChangeInCapacity</b> -- add (or subtract) the scaling adjustment value from the current instance count. Positive values scale up while negative values scale down.</p> </li>
    /// <li> <p> <b>ExactCapacity</b> -- set the instance count to the scaling adjustment value.</p> </li>
    /// <li> <p> <b>PercentChangeInCapacity</b> -- increase or reduce the current instance count by the scaling adjustment, read as a percentage. Positive values scale up while negative values scale down.</p> </li>
    /// </ul>
    pub fn scaling_adjustment_type(
        &self,
    ) -> std::option::Option<&crate::model::ScalingAdjustmentType> {
        self.scaling_adjustment_type.as_ref()
    }
    /// <p>Comparison operator to use when measuring a metric against the threshold value.</p>
    pub fn comparison_operator(
        &self,
    ) -> std::option::Option<&crate::model::ComparisonOperatorType> {
        self.comparison_operator.as_ref()
    }
    /// <p>Metric value used to trigger a scaling event.</p>
    pub fn threshold(&self) -> f64 {
        self.threshold
    }
    /// <p>Length of time (in minutes) the metric must be at or beyond the threshold before a scaling event is triggered.</p>
    pub fn evaluation_periods(&self) -> std::option::Option<i32> {
        self.evaluation_periods
    }
    /// <p>Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment. For detailed descriptions of fleet metrics, see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html">Monitor Amazon GameLift with Amazon CloudWatch</a>. </p>
    /// <ul>
    /// <li> <p> <b>ActivatingGameSessions</b> -- Game sessions in the process of being created.</p> </li>
    /// <li> <p> <b>ActiveGameSessions</b> -- Game sessions that are currently running.</p> </li>
    /// <li> <p> <b>ActiveInstances</b> -- Fleet instances that are currently running at least one game session.</p> </li>
    /// <li> <p> <b>AvailableGameSessions</b> -- Additional game sessions that fleet could host simultaneously, given current capacity.</p> </li>
    /// <li> <p> <b>AvailablePlayerSessions</b> -- Empty player slots in currently active game sessions. This includes game sessions that are not currently accepting players. Reserved player slots are not included.</p> </li>
    /// <li> <p> <b>CurrentPlayerSessions</b> -- Player slots in active game sessions that are being used by a player or are reserved for a player. </p> </li>
    /// <li> <p> <b>IdleInstances</b> -- Active instances that are currently hosting zero game sessions. </p> </li>
    /// <li> <p> <b>PercentAvailableGameSessions</b> -- Unused percentage of the total number of game sessions that a fleet could host simultaneously, given current capacity. Use this metric for a target-based scaling policy.</p> </li>
    /// <li> <p> <b>PercentIdleInstances</b> -- Percentage of the total number of active instances that are hosting zero game sessions.</p> </li>
    /// <li> <p> <b>QueueDepth</b> -- Pending game session placement requests, in any queue, where the current fleet is the top-priority destination.</p> </li>
    /// <li> <p> <b>WaitTime</b> -- Current wait time for pending game session placement requests, in any queue, where the current fleet is the top-priority destination. </p> </li>
    /// </ul>
    pub fn metric_name(&self) -> std::option::Option<&crate::model::MetricName> {
        self.metric_name.as_ref()
    }
    /// <p>The type of scaling policy to create. For a target-based policy, set the parameter <i>MetricName</i> to 'PercentAvailableGameSessions' and specify a <i>TargetConfiguration</i>. For a rule-based policy set the following parameters: <i>MetricName</i>, <i>ComparisonOperator</i>, <i>Threshold</i>, <i>EvaluationPeriods</i>, <i>ScalingAdjustmentType</i>, and <i>ScalingAdjustment</i>.</p>
    pub fn policy_type(&self) -> std::option::Option<&crate::model::PolicyType> {
        self.policy_type.as_ref()
    }
    /// <p>An object that contains settings for a target-based scaling policy.</p>
    pub fn target_configuration(&self) -> std::option::Option<&crate::model::TargetConfiguration> {
        self.target_configuration.as_ref()
    }
    /// <p>The current status of the fleet's scaling policies in a requested fleet location. The status <code>PENDING_UPDATE</code> indicates that an update was requested for the fleet but has not yet been completed for the location.</p>
    pub fn update_status(&self) -> std::option::Option<&crate::model::LocationUpdateStatus> {
        self.update_status.as_ref()
    }
    /// <p> The fleet location. </p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
}
impl std::fmt::Debug for ScalingPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScalingPolicy");
        formatter.field("fleet_id", &self.fleet_id);
        formatter.field("fleet_arn", &self.fleet_arn);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("scaling_adjustment", &self.scaling_adjustment);
        formatter.field("scaling_adjustment_type", &self.scaling_adjustment_type);
        formatter.field("comparison_operator", &self.comparison_operator);
        formatter.field("threshold", &self.threshold);
        formatter.field("evaluation_periods", &self.evaluation_periods);
        formatter.field("metric_name", &self.metric_name);
        formatter.field("policy_type", &self.policy_type);
        formatter.field("target_configuration", &self.target_configuration);
        formatter.field("update_status", &self.update_status);
        formatter.field("location", &self.location);
        formatter.finish()
    }
}
/// See [`ScalingPolicy`](crate::model::ScalingPolicy)
pub mod scaling_policy {
    /// A builder for [`ScalingPolicy`](crate::model::ScalingPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) fleet_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ScalingStatusType>,
        pub(crate) scaling_adjustment: std::option::Option<i32>,
        pub(crate) scaling_adjustment_type:
            std::option::Option<crate::model::ScalingAdjustmentType>,
        pub(crate) comparison_operator: std::option::Option<crate::model::ComparisonOperatorType>,
        pub(crate) threshold: std::option::Option<f64>,
        pub(crate) evaluation_periods: std::option::Option<i32>,
        pub(crate) metric_name: std::option::Option<crate::model::MetricName>,
        pub(crate) policy_type: std::option::Option<crate::model::PolicyType>,
        pub(crate) target_configuration: std::option::Option<crate::model::TargetConfiguration>,
        pub(crate) update_status: std::option::Option<crate::model::LocationUpdateStatus>,
        pub(crate) location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet that is associated with this scaling policy.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet that is associated with this scaling policy.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
        /// </region></code>.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
        /// </region></code>.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_arn = input;
            self
        }
        /// <p>A descriptive label that is associated with a fleet's scaling policy. Policy names do not need to be unique.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A descriptive label that is associated with a fleet's scaling policy. Policy names do not need to be unique.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Current status of the scaling policy. The scaling policy can be in force only when in an <code>ACTIVE</code> status. Scaling policies can be suspended for individual fleets (see <code>StopFleetActions</code>; if suspended for a fleet, the policy status does not change. View a fleet's stopped actions by calling <code>DescribeFleetCapacity</code>.</p>
        /// <ul>
        /// <li> <p> <b>ACTIVE</b> -- The scaling policy can be used for auto-scaling a fleet.</p> </li>
        /// <li> <p> <b>UPDATE_REQUESTED</b> -- A request to update the scaling policy has been received.</p> </li>
        /// <li> <p> <b>UPDATING</b> -- A change is being made to the scaling policy.</p> </li>
        /// <li> <p> <b>DELETE_REQUESTED</b> -- A request to delete the scaling policy has been received.</p> </li>
        /// <li> <p> <b>DELETING</b> -- The scaling policy is being deleted.</p> </li>
        /// <li> <p> <b>DELETED</b> -- The scaling policy has been deleted.</p> </li>
        /// <li> <p> <b>ERROR</b> -- An error occurred in creating the policy. It should be removed and recreated.</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::ScalingStatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Current status of the scaling policy. The scaling policy can be in force only when in an <code>ACTIVE</code> status. Scaling policies can be suspended for individual fleets (see <code>StopFleetActions</code>; if suspended for a fleet, the policy status does not change. View a fleet's stopped actions by calling <code>DescribeFleetCapacity</code>.</p>
        /// <ul>
        /// <li> <p> <b>ACTIVE</b> -- The scaling policy can be used for auto-scaling a fleet.</p> </li>
        /// <li> <p> <b>UPDATE_REQUESTED</b> -- A request to update the scaling policy has been received.</p> </li>
        /// <li> <p> <b>UPDATING</b> -- A change is being made to the scaling policy.</p> </li>
        /// <li> <p> <b>DELETE_REQUESTED</b> -- A request to delete the scaling policy has been received.</p> </li>
        /// <li> <p> <b>DELETING</b> -- The scaling policy is being deleted.</p> </li>
        /// <li> <p> <b>DELETED</b> -- The scaling policy has been deleted.</p> </li>
        /// <li> <p> <b>ERROR</b> -- An error occurred in creating the policy. It should be removed and recreated.</p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ScalingStatusType>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Amount of adjustment to make, based on the scaling adjustment type.</p>
        pub fn scaling_adjustment(mut self, input: i32) -> Self {
            self.scaling_adjustment = Some(input);
            self
        }
        /// <p>Amount of adjustment to make, based on the scaling adjustment type.</p>
        pub fn set_scaling_adjustment(mut self, input: std::option::Option<i32>) -> Self {
            self.scaling_adjustment = input;
            self
        }
        /// <p>The type of adjustment to make to a fleet's instance count (see <code>FleetCapacity</code>):</p>
        /// <ul>
        /// <li> <p> <b>ChangeInCapacity</b> -- add (or subtract) the scaling adjustment value from the current instance count. Positive values scale up while negative values scale down.</p> </li>
        /// <li> <p> <b>ExactCapacity</b> -- set the instance count to the scaling adjustment value.</p> </li>
        /// <li> <p> <b>PercentChangeInCapacity</b> -- increase or reduce the current instance count by the scaling adjustment, read as a percentage. Positive values scale up while negative values scale down.</p> </li>
        /// </ul>
        pub fn scaling_adjustment_type(
            mut self,
            input: crate::model::ScalingAdjustmentType,
        ) -> Self {
            self.scaling_adjustment_type = Some(input);
            self
        }
        /// <p>The type of adjustment to make to a fleet's instance count (see <code>FleetCapacity</code>):</p>
        /// <ul>
        /// <li> <p> <b>ChangeInCapacity</b> -- add (or subtract) the scaling adjustment value from the current instance count. Positive values scale up while negative values scale down.</p> </li>
        /// <li> <p> <b>ExactCapacity</b> -- set the instance count to the scaling adjustment value.</p> </li>
        /// <li> <p> <b>PercentChangeInCapacity</b> -- increase or reduce the current instance count by the scaling adjustment, read as a percentage. Positive values scale up while negative values scale down.</p> </li>
        /// </ul>
        pub fn set_scaling_adjustment_type(
            mut self,
            input: std::option::Option<crate::model::ScalingAdjustmentType>,
        ) -> Self {
            self.scaling_adjustment_type = input;
            self
        }
        /// <p>Comparison operator to use when measuring a metric against the threshold value.</p>
        pub fn comparison_operator(mut self, input: crate::model::ComparisonOperatorType) -> Self {
            self.comparison_operator = Some(input);
            self
        }
        /// <p>Comparison operator to use when measuring a metric against the threshold value.</p>
        pub fn set_comparison_operator(
            mut self,
            input: std::option::Option<crate::model::ComparisonOperatorType>,
        ) -> Self {
            self.comparison_operator = input;
            self
        }
        /// <p>Metric value used to trigger a scaling event.</p>
        pub fn threshold(mut self, input: f64) -> Self {
            self.threshold = Some(input);
            self
        }
        /// <p>Metric value used to trigger a scaling event.</p>
        pub fn set_threshold(mut self, input: std::option::Option<f64>) -> Self {
            self.threshold = input;
            self
        }
        /// <p>Length of time (in minutes) the metric must be at or beyond the threshold before a scaling event is triggered.</p>
        pub fn evaluation_periods(mut self, input: i32) -> Self {
            self.evaluation_periods = Some(input);
            self
        }
        /// <p>Length of time (in minutes) the metric must be at or beyond the threshold before a scaling event is triggered.</p>
        pub fn set_evaluation_periods(mut self, input: std::option::Option<i32>) -> Self {
            self.evaluation_periods = input;
            self
        }
        /// <p>Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment. For detailed descriptions of fleet metrics, see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html">Monitor Amazon GameLift with Amazon CloudWatch</a>. </p>
        /// <ul>
        /// <li> <p> <b>ActivatingGameSessions</b> -- Game sessions in the process of being created.</p> </li>
        /// <li> <p> <b>ActiveGameSessions</b> -- Game sessions that are currently running.</p> </li>
        /// <li> <p> <b>ActiveInstances</b> -- Fleet instances that are currently running at least one game session.</p> </li>
        /// <li> <p> <b>AvailableGameSessions</b> -- Additional game sessions that fleet could host simultaneously, given current capacity.</p> </li>
        /// <li> <p> <b>AvailablePlayerSessions</b> -- Empty player slots in currently active game sessions. This includes game sessions that are not currently accepting players. Reserved player slots are not included.</p> </li>
        /// <li> <p> <b>CurrentPlayerSessions</b> -- Player slots in active game sessions that are being used by a player or are reserved for a player. </p> </li>
        /// <li> <p> <b>IdleInstances</b> -- Active instances that are currently hosting zero game sessions. </p> </li>
        /// <li> <p> <b>PercentAvailableGameSessions</b> -- Unused percentage of the total number of game sessions that a fleet could host simultaneously, given current capacity. Use this metric for a target-based scaling policy.</p> </li>
        /// <li> <p> <b>PercentIdleInstances</b> -- Percentage of the total number of active instances that are hosting zero game sessions.</p> </li>
        /// <li> <p> <b>QueueDepth</b> -- Pending game session placement requests, in any queue, where the current fleet is the top-priority destination.</p> </li>
        /// <li> <p> <b>WaitTime</b> -- Current wait time for pending game session placement requests, in any queue, where the current fleet is the top-priority destination. </p> </li>
        /// </ul>
        pub fn metric_name(mut self, input: crate::model::MetricName) -> Self {
            self.metric_name = Some(input);
            self
        }
        /// <p>Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment. For detailed descriptions of fleet metrics, see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html">Monitor Amazon GameLift with Amazon CloudWatch</a>. </p>
        /// <ul>
        /// <li> <p> <b>ActivatingGameSessions</b> -- Game sessions in the process of being created.</p> </li>
        /// <li> <p> <b>ActiveGameSessions</b> -- Game sessions that are currently running.</p> </li>
        /// <li> <p> <b>ActiveInstances</b> -- Fleet instances that are currently running at least one game session.</p> </li>
        /// <li> <p> <b>AvailableGameSessions</b> -- Additional game sessions that fleet could host simultaneously, given current capacity.</p> </li>
        /// <li> <p> <b>AvailablePlayerSessions</b> -- Empty player slots in currently active game sessions. This includes game sessions that are not currently accepting players. Reserved player slots are not included.</p> </li>
        /// <li> <p> <b>CurrentPlayerSessions</b> -- Player slots in active game sessions that are being used by a player or are reserved for a player. </p> </li>
        /// <li> <p> <b>IdleInstances</b> -- Active instances that are currently hosting zero game sessions. </p> </li>
        /// <li> <p> <b>PercentAvailableGameSessions</b> -- Unused percentage of the total number of game sessions that a fleet could host simultaneously, given current capacity. Use this metric for a target-based scaling policy.</p> </li>
        /// <li> <p> <b>PercentIdleInstances</b> -- Percentage of the total number of active instances that are hosting zero game sessions.</p> </li>
        /// <li> <p> <b>QueueDepth</b> -- Pending game session placement requests, in any queue, where the current fleet is the top-priority destination.</p> </li>
        /// <li> <p> <b>WaitTime</b> -- Current wait time for pending game session placement requests, in any queue, where the current fleet is the top-priority destination. </p> </li>
        /// </ul>
        pub fn set_metric_name(
            mut self,
            input: std::option::Option<crate::model::MetricName>,
        ) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>The type of scaling policy to create. For a target-based policy, set the parameter <i>MetricName</i> to 'PercentAvailableGameSessions' and specify a <i>TargetConfiguration</i>. For a rule-based policy set the following parameters: <i>MetricName</i>, <i>ComparisonOperator</i>, <i>Threshold</i>, <i>EvaluationPeriods</i>, <i>ScalingAdjustmentType</i>, and <i>ScalingAdjustment</i>.</p>
        pub fn policy_type(mut self, input: crate::model::PolicyType) -> Self {
            self.policy_type = Some(input);
            self
        }
        /// <p>The type of scaling policy to create. For a target-based policy, set the parameter <i>MetricName</i> to 'PercentAvailableGameSessions' and specify a <i>TargetConfiguration</i>. For a rule-based policy set the following parameters: <i>MetricName</i>, <i>ComparisonOperator</i>, <i>Threshold</i>, <i>EvaluationPeriods</i>, <i>ScalingAdjustmentType</i>, and <i>ScalingAdjustment</i>.</p>
        pub fn set_policy_type(
            mut self,
            input: std::option::Option<crate::model::PolicyType>,
        ) -> Self {
            self.policy_type = input;
            self
        }
        /// <p>An object that contains settings for a target-based scaling policy.</p>
        pub fn target_configuration(mut self, input: crate::model::TargetConfiguration) -> Self {
            self.target_configuration = Some(input);
            self
        }
        /// <p>An object that contains settings for a target-based scaling policy.</p>
        pub fn set_target_configuration(
            mut self,
            input: std::option::Option<crate::model::TargetConfiguration>,
        ) -> Self {
            self.target_configuration = input;
            self
        }
        /// <p>The current status of the fleet's scaling policies in a requested fleet location. The status <code>PENDING_UPDATE</code> indicates that an update was requested for the fleet but has not yet been completed for the location.</p>
        pub fn update_status(mut self, input: crate::model::LocationUpdateStatus) -> Self {
            self.update_status = Some(input);
            self
        }
        /// <p>The current status of the fleet's scaling policies in a requested fleet location. The status <code>PENDING_UPDATE</code> indicates that an update was requested for the fleet but has not yet been completed for the location.</p>
        pub fn set_update_status(
            mut self,
            input: std::option::Option<crate::model::LocationUpdateStatus>,
        ) -> Self {
            self.update_status = input;
            self
        }
        /// <p> The fleet location. </p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p> The fleet location. </p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`ScalingPolicy`](crate::model::ScalingPolicy)
        pub fn build(self) -> crate::model::ScalingPolicy {
            crate::model::ScalingPolicy {
                fleet_id: self.fleet_id,
                fleet_arn: self.fleet_arn,
                name: self.name,
                status: self.status,
                scaling_adjustment: self.scaling_adjustment.unwrap_or_default(),
                scaling_adjustment_type: self.scaling_adjustment_type,
                comparison_operator: self.comparison_operator,
                threshold: self.threshold.unwrap_or_default(),
                evaluation_periods: self.evaluation_periods,
                metric_name: self.metric_name,
                policy_type: self.policy_type,
                target_configuration: self.target_configuration,
                update_status: self.update_status,
                location: self.location,
            }
        }
    }
}
impl ScalingPolicy {
    /// Creates a new builder-style object to manufacture [`ScalingPolicy`](crate::model::ScalingPolicy)
    pub fn builder() -> crate::model::scaling_policy::Builder {
        crate::model::scaling_policy::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LocationUpdateStatus {
    #[allow(missing_docs)] // documentation missing in model
    PendingUpdate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LocationUpdateStatus {
    fn from(s: &str) -> Self {
        match s {
            "PENDING_UPDATE" => LocationUpdateStatus::PendingUpdate,
            other => LocationUpdateStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LocationUpdateStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LocationUpdateStatus::from(s))
    }
}
impl LocationUpdateStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LocationUpdateStatus::PendingUpdate => "PENDING_UPDATE",
            LocationUpdateStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PENDING_UPDATE"]
    }
}
impl AsRef<str> for LocationUpdateStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScalingStatusType {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    DeleteRequested,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    UpdateRequested,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScalingStatusType {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ScalingStatusType::Active,
            "DELETED" => ScalingStatusType::Deleted,
            "DELETE_REQUESTED" => ScalingStatusType::DeleteRequested,
            "DELETING" => ScalingStatusType::Deleting,
            "ERROR" => ScalingStatusType::Error,
            "UPDATE_REQUESTED" => ScalingStatusType::UpdateRequested,
            "UPDATING" => ScalingStatusType::Updating,
            other => ScalingStatusType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScalingStatusType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScalingStatusType::from(s))
    }
}
impl ScalingStatusType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScalingStatusType::Active => "ACTIVE",
            ScalingStatusType::Deleted => "DELETED",
            ScalingStatusType::DeleteRequested => "DELETE_REQUESTED",
            ScalingStatusType::Deleting => "DELETING",
            ScalingStatusType::Error => "ERROR",
            ScalingStatusType::UpdateRequested => "UPDATE_REQUESTED",
            ScalingStatusType::Updating => "UPDATING",
            ScalingStatusType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "DELETED",
            "DELETE_REQUESTED",
            "DELETING",
            "ERROR",
            "UPDATE_REQUESTED",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for ScalingStatusType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a player session. Player sessions are created either for a specific game session, or as part of a game session placement or matchmaking request. A player session can represents a reserved player slot in a game session (when status is <code>RESERVED</code>) or actual player activity in a game session (when status is <code>ACTIVE</code>). A player session object, including player data, is automatically passed to a game session when the player connects to the game session and is validated. After the game session ends, player sessions information is retained for 30 days and then removed.</p>
/// <p> <b>Related actions</b> </p>
/// <p> <code>CreatePlayerSession</code> | <code>CreatePlayerSessions</code> | <code>DescribePlayerSessions</code> | <code>StartGameSessionPlacement</code> | <code>DescribeGameSessionPlacement</code> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PlayerSession {
    /// <p>A unique identifier for a player session.</p>
    pub player_session_id: std::option::Option<std::string::String>,
    /// <p>A unique identifier for a player that is associated with this player session.</p>
    pub player_id: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the game session that the player session is connected to.</p>
    pub game_session_id: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the fleet that the player's game session is running on.</p>
    pub fleet_id: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift fleet that the player's game session is running on. </p>
    pub fleet_arn: std::option::Option<std::string::String>,
    /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A time stamp indicating when this data object was terminated. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub termination_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Current status of the player session.</p>
    /// <p>Possible player session statuses include the following:</p>
    /// <ul>
    /// <li> <p> <b>RESERVED</b> -- The player session request has been received, but the player has not yet connected to the server process and/or been validated. </p> </li>
    /// <li> <p> <b>ACTIVE</b> -- The player has been validated by the server process and is currently connected.</p> </li>
    /// <li> <p> <b>COMPLETED</b> -- The player connection has been dropped.</p> </li>
    /// <li> <p> <b>TIMEDOUT</b> -- A player session request was received, but the player did not connect and/or was not validated within the timeout limit (60 seconds).</p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::PlayerSessionStatus>,
    /// <p>The IP address of the game session. To connect to a GameLift game server, an app needs both the IP address and port number.</p>
    pub ip_address: std::option::Option<std::string::String>,
    /// <p>The DNS identifier assigned to the instance that is running the game session. Values have the following format:</p>
    /// <ul>
    /// <li> <p>TLS-enabled fleets: <code>
    /// <unique identifier>
    /// .
    /// <region identifier>
    /// .amazongamelift.com
    /// </region>
    /// </unique></code>.</p> </li>
    /// <li> <p>Non-TLS-enabled fleets: <code>ec2-
    /// <unique identifier>
    /// .compute.amazonaws.com
    /// </unique></code>. (See <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses">Amazon EC2 Instance IP Addressing</a>.)</p> </li>
    /// </ul>
    /// <p>When connecting to a game session that is running on a TLS-enabled fleet, you must use the DNS name, not the IP address.</p>
    pub dns_name: std::option::Option<std::string::String>,
    /// <p>Port number for the game session. To connect to a Amazon GameLift server process, an app needs both the IP address and port number.</p>
    pub port: std::option::Option<i32>,
    /// <p>Developer-defined information related to a player. GameLift does not use this data, so it can be formatted as needed for use in the game. </p>
    pub player_data: std::option::Option<std::string::String>,
}
impl PlayerSession {
    /// <p>A unique identifier for a player session.</p>
    pub fn player_session_id(&self) -> std::option::Option<&str> {
        self.player_session_id.as_deref()
    }
    /// <p>A unique identifier for a player that is associated with this player session.</p>
    pub fn player_id(&self) -> std::option::Option<&str> {
        self.player_id.as_deref()
    }
    /// <p>A unique identifier for the game session that the player session is connected to.</p>
    pub fn game_session_id(&self) -> std::option::Option<&str> {
        self.game_session_id.as_deref()
    }
    /// <p>A unique identifier for the fleet that the player's game session is running on.</p>
    pub fn fleet_id(&self) -> std::option::Option<&str> {
        self.fleet_id.as_deref()
    }
    /// <p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift fleet that the player's game session is running on. </p>
    pub fn fleet_arn(&self) -> std::option::Option<&str> {
        self.fleet_arn.as_deref()
    }
    /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>A time stamp indicating when this data object was terminated. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub fn termination_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.termination_time.as_ref()
    }
    /// <p>Current status of the player session.</p>
    /// <p>Possible player session statuses include the following:</p>
    /// <ul>
    /// <li> <p> <b>RESERVED</b> -- The player session request has been received, but the player has not yet connected to the server process and/or been validated. </p> </li>
    /// <li> <p> <b>ACTIVE</b> -- The player has been validated by the server process and is currently connected.</p> </li>
    /// <li> <p> <b>COMPLETED</b> -- The player connection has been dropped.</p> </li>
    /// <li> <p> <b>TIMEDOUT</b> -- A player session request was received, but the player did not connect and/or was not validated within the timeout limit (60 seconds).</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::PlayerSessionStatus> {
        self.status.as_ref()
    }
    /// <p>The IP address of the game session. To connect to a GameLift game server, an app needs both the IP address and port number.</p>
    pub fn ip_address(&self) -> std::option::Option<&str> {
        self.ip_address.as_deref()
    }
    /// <p>The DNS identifier assigned to the instance that is running the game session. Values have the following format:</p>
    /// <ul>
    /// <li> <p>TLS-enabled fleets: <code>
    /// <unique identifier>
    /// .
    /// <region identifier>
    /// .amazongamelift.com
    /// </region>
    /// </unique></code>.</p> </li>
    /// <li> <p>Non-TLS-enabled fleets: <code>ec2-
    /// <unique identifier>
    /// .compute.amazonaws.com
    /// </unique></code>. (See <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses">Amazon EC2 Instance IP Addressing</a>.)</p> </li>
    /// </ul>
    /// <p>When connecting to a game session that is running on a TLS-enabled fleet, you must use the DNS name, not the IP address.</p>
    pub fn dns_name(&self) -> std::option::Option<&str> {
        self.dns_name.as_deref()
    }
    /// <p>Port number for the game session. To connect to a Amazon GameLift server process, an app needs both the IP address and port number.</p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
    /// <p>Developer-defined information related to a player. GameLift does not use this data, so it can be formatted as needed for use in the game. </p>
    pub fn player_data(&self) -> std::option::Option<&str> {
        self.player_data.as_deref()
    }
}
impl std::fmt::Debug for PlayerSession {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PlayerSession");
        formatter.field("player_session_id", &self.player_session_id);
        formatter.field("player_id", &self.player_id);
        formatter.field("game_session_id", &self.game_session_id);
        formatter.field("fleet_id", &self.fleet_id);
        formatter.field("fleet_arn", &self.fleet_arn);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("termination_time", &self.termination_time);
        formatter.field("status", &self.status);
        formatter.field("ip_address", &self.ip_address);
        formatter.field("dns_name", &self.dns_name);
        formatter.field("port", &self.port);
        formatter.field("player_data", &self.player_data);
        formatter.finish()
    }
}
/// See [`PlayerSession`](crate::model::PlayerSession)
pub mod player_session {
    /// A builder for [`PlayerSession`](crate::model::PlayerSession)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) player_session_id: std::option::Option<std::string::String>,
        pub(crate) player_id: std::option::Option<std::string::String>,
        pub(crate) game_session_id: std::option::Option<std::string::String>,
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) fleet_arn: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) termination_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::PlayerSessionStatus>,
        pub(crate) ip_address: std::option::Option<std::string::String>,
        pub(crate) dns_name: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) player_data: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for a player session.</p>
        pub fn player_session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.player_session_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a player session.</p>
        pub fn set_player_session_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.player_session_id = input;
            self
        }
        /// <p>A unique identifier for a player that is associated with this player session.</p>
        pub fn player_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.player_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a player that is associated with this player session.</p>
        pub fn set_player_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.player_id = input;
            self
        }
        /// <p>A unique identifier for the game session that the player session is connected to.</p>
        pub fn game_session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_session_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the game session that the player session is connected to.</p>
        pub fn set_game_session_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_session_id = input;
            self
        }
        /// <p>A unique identifier for the fleet that the player's game session is running on.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet that the player's game session is running on.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift fleet that the player's game session is running on. </p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift fleet that the player's game session is running on. </p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_arn = input;
            self
        }
        /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>A time stamp indicating when this data object was terminated. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn termination_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.termination_time = Some(input);
            self
        }
        /// <p>A time stamp indicating when this data object was terminated. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn set_termination_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.termination_time = input;
            self
        }
        /// <p>Current status of the player session.</p>
        /// <p>Possible player session statuses include the following:</p>
        /// <ul>
        /// <li> <p> <b>RESERVED</b> -- The player session request has been received, but the player has not yet connected to the server process and/or been validated. </p> </li>
        /// <li> <p> <b>ACTIVE</b> -- The player has been validated by the server process and is currently connected.</p> </li>
        /// <li> <p> <b>COMPLETED</b> -- The player connection has been dropped.</p> </li>
        /// <li> <p> <b>TIMEDOUT</b> -- A player session request was received, but the player did not connect and/or was not validated within the timeout limit (60 seconds).</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::PlayerSessionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Current status of the player session.</p>
        /// <p>Possible player session statuses include the following:</p>
        /// <ul>
        /// <li> <p> <b>RESERVED</b> -- The player session request has been received, but the player has not yet connected to the server process and/or been validated. </p> </li>
        /// <li> <p> <b>ACTIVE</b> -- The player has been validated by the server process and is currently connected.</p> </li>
        /// <li> <p> <b>COMPLETED</b> -- The player connection has been dropped.</p> </li>
        /// <li> <p> <b>TIMEDOUT</b> -- A player session request was received, but the player did not connect and/or was not validated within the timeout limit (60 seconds).</p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::PlayerSessionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The IP address of the game session. To connect to a GameLift game server, an app needs both the IP address and port number.</p>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address = Some(input.into());
            self
        }
        /// <p>The IP address of the game session. To connect to a GameLift game server, an app needs both the IP address and port number.</p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_address = input;
            self
        }
        /// <p>The DNS identifier assigned to the instance that is running the game session. Values have the following format:</p>
        /// <ul>
        /// <li> <p>TLS-enabled fleets: <code>
        /// <unique identifier>
        /// .
        /// <region identifier>
        /// .amazongamelift.com
        /// </region>
        /// </unique></code>.</p> </li>
        /// <li> <p>Non-TLS-enabled fleets: <code>ec2-
        /// <unique identifier>
        /// .compute.amazonaws.com
        /// </unique></code>. (See <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses">Amazon EC2 Instance IP Addressing</a>.)</p> </li>
        /// </ul>
        /// <p>When connecting to a game session that is running on a TLS-enabled fleet, you must use the DNS name, not the IP address.</p>
        pub fn dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dns_name = Some(input.into());
            self
        }
        /// <p>The DNS identifier assigned to the instance that is running the game session. Values have the following format:</p>
        /// <ul>
        /// <li> <p>TLS-enabled fleets: <code>
        /// <unique identifier>
        /// .
        /// <region identifier>
        /// .amazongamelift.com
        /// </region>
        /// </unique></code>.</p> </li>
        /// <li> <p>Non-TLS-enabled fleets: <code>ec2-
        /// <unique identifier>
        /// .compute.amazonaws.com
        /// </unique></code>. (See <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses">Amazon EC2 Instance IP Addressing</a>.)</p> </li>
        /// </ul>
        /// <p>When connecting to a game session that is running on a TLS-enabled fleet, you must use the DNS name, not the IP address.</p>
        pub fn set_dns_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dns_name = input;
            self
        }
        /// <p>Port number for the game session. To connect to a Amazon GameLift server process, an app needs both the IP address and port number.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>Port number for the game session. To connect to a Amazon GameLift server process, an app needs both the IP address and port number.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>Developer-defined information related to a player. GameLift does not use this data, so it can be formatted as needed for use in the game. </p>
        pub fn player_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.player_data = Some(input.into());
            self
        }
        /// <p>Developer-defined information related to a player. GameLift does not use this data, so it can be formatted as needed for use in the game. </p>
        pub fn set_player_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.player_data = input;
            self
        }
        /// Consumes the builder and constructs a [`PlayerSession`](crate::model::PlayerSession)
        pub fn build(self) -> crate::model::PlayerSession {
            crate::model::PlayerSession {
                player_session_id: self.player_session_id,
                player_id: self.player_id,
                game_session_id: self.game_session_id,
                fleet_id: self.fleet_id,
                fleet_arn: self.fleet_arn,
                creation_time: self.creation_time,
                termination_time: self.termination_time,
                status: self.status,
                ip_address: self.ip_address,
                dns_name: self.dns_name,
                port: self.port,
                player_data: self.player_data,
            }
        }
    }
}
impl PlayerSession {
    /// Creates a new builder-style object to manufacture [`PlayerSession`](crate::model::PlayerSession)
    pub fn builder() -> crate::model::player_session::Builder {
        crate::model::player_session::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PlayerSessionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Reserved,
    #[allow(missing_docs)] // documentation missing in model
    Timedout,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PlayerSessionStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => PlayerSessionStatus::Active,
            "COMPLETED" => PlayerSessionStatus::Completed,
            "RESERVED" => PlayerSessionStatus::Reserved,
            "TIMEDOUT" => PlayerSessionStatus::Timedout,
            other => PlayerSessionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PlayerSessionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PlayerSessionStatus::from(s))
    }
}
impl PlayerSessionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PlayerSessionStatus::Active => "ACTIVE",
            PlayerSessionStatus::Completed => "COMPLETED",
            PlayerSessionStatus::Reserved => "RESERVED",
            PlayerSessionStatus::Timedout => "TIMEDOUT",
            PlayerSessionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "COMPLETED", "RESERVED", "TIMEDOUT"]
    }
}
impl AsRef<str> for PlayerSessionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Set of rule statements, used with FlexMatch, that determine how to build your player matches. Each rule set describes a type of group to be created and defines the parameters for acceptable player matches. Rule sets are used in <code>MatchmakingConfiguration</code> objects.</p>
/// <p>A rule set may define the following elements for a match. For detailed information and examples showing how to construct a rule set, see <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html">Build a FlexMatch rule set</a>. </p>
/// <ul>
/// <li> <p>Teams -- Required. A rule set must define one or multiple teams for the match and set minimum and maximum team sizes. For example, a rule set might describe a 4x4 match that requires all eight slots to be filled. </p> </li>
/// <li> <p>Player attributes -- Optional. These attributes specify a set of player characteristics to evaluate when looking for a match. Matchmaking requests that use a rule set with player attributes must provide the corresponding attribute values. For example, an attribute might specify a player's skill or level.</p> </li>
/// <li> <p>Rules -- Optional. Rules define how to evaluate potential players for a match based on player attributes. A rule might specify minimum requirements for individual players, teams, or entire matches. For example, a rule might require each player to meet a certain skill level, each team to have at least one player in a certain role, or the match to have a minimum average skill level. or may describe an entire group--such as all teams must be evenly matched or have at least one player in a certain role. </p> </li>
/// <li> <p>Expansions -- Optional. Expansions allow you to relax the rules after a period of time when no acceptable matches are found. This feature lets you balance getting players into games in a reasonable amount of time instead of making them wait indefinitely for the best possible match. For example, you might use an expansion to increase the maximum skill variance between players after 30 seconds.</p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MatchmakingRuleSet {
    /// <p>A unique identifier for the matchmaking rule set</p>
    pub rule_set_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift matchmaking rule set resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::matchmakingruleset/
    /// <ruleset name></ruleset>
    /// </region></code>. In a GameLift rule set ARN, the resource ID matches the <i>RuleSetName</i> value.</p>
    pub rule_set_arn: std::option::Option<std::string::String>,
    /// <p>A collection of matchmaking rules, formatted as a JSON string. Comments are not allowed in JSON, but most elements support a description field.</p>
    pub rule_set_body: std::option::Option<std::string::String>,
    /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl MatchmakingRuleSet {
    /// <p>A unique identifier for the matchmaking rule set</p>
    pub fn rule_set_name(&self) -> std::option::Option<&str> {
        self.rule_set_name.as_deref()
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift matchmaking rule set resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::matchmakingruleset/
    /// <ruleset name></ruleset>
    /// </region></code>. In a GameLift rule set ARN, the resource ID matches the <i>RuleSetName</i> value.</p>
    pub fn rule_set_arn(&self) -> std::option::Option<&str> {
        self.rule_set_arn.as_deref()
    }
    /// <p>A collection of matchmaking rules, formatted as a JSON string. Comments are not allowed in JSON, but most elements support a description field.</p>
    pub fn rule_set_body(&self) -> std::option::Option<&str> {
        self.rule_set_body.as_deref()
    }
    /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
}
impl std::fmt::Debug for MatchmakingRuleSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MatchmakingRuleSet");
        formatter.field("rule_set_name", &self.rule_set_name);
        formatter.field("rule_set_arn", &self.rule_set_arn);
        formatter.field("rule_set_body", &self.rule_set_body);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`MatchmakingRuleSet`](crate::model::MatchmakingRuleSet)
pub mod matchmaking_rule_set {
    /// A builder for [`MatchmakingRuleSet`](crate::model::MatchmakingRuleSet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_set_name: std::option::Option<std::string::String>,
        pub(crate) rule_set_arn: std::option::Option<std::string::String>,
        pub(crate) rule_set_body: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>A unique identifier for the matchmaking rule set</p>
        pub fn rule_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_set_name = Some(input.into());
            self
        }
        /// <p>A unique identifier for the matchmaking rule set</p>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rule_set_name = input;
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift matchmaking rule set resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::matchmakingruleset/
        /// <ruleset name></ruleset>
        /// </region></code>. In a GameLift rule set ARN, the resource ID matches the <i>RuleSetName</i> value.</p>
        pub fn rule_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_set_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift matchmaking rule set resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::matchmakingruleset/
        /// <ruleset name></ruleset>
        /// </region></code>. In a GameLift rule set ARN, the resource ID matches the <i>RuleSetName</i> value.</p>
        pub fn set_rule_set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_set_arn = input;
            self
        }
        /// <p>A collection of matchmaking rules, formatted as a JSON string. Comments are not allowed in JSON, but most elements support a description field.</p>
        pub fn rule_set_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_set_body = Some(input.into());
            self
        }
        /// <p>A collection of matchmaking rules, formatted as a JSON string. Comments are not allowed in JSON, but most elements support a description field.</p>
        pub fn set_rule_set_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rule_set_body = input;
            self
        }
        /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`MatchmakingRuleSet`](crate::model::MatchmakingRuleSet)
        pub fn build(self) -> crate::model::MatchmakingRuleSet {
            crate::model::MatchmakingRuleSet {
                rule_set_name: self.rule_set_name,
                rule_set_arn: self.rule_set_arn,
                rule_set_body: self.rule_set_body,
                creation_time: self.creation_time,
            }
        }
    }
}
impl MatchmakingRuleSet {
    /// Creates a new builder-style object to manufacture [`MatchmakingRuleSet`](crate::model::MatchmakingRuleSet)
    pub fn builder() -> crate::model::matchmaking_rule_set::Builder {
        crate::model::matchmaking_rule_set::Builder::default()
    }
}

/// <p>Represents an EC2 instance of virtual computing resources that hosts one or more game servers. In GameLift, a fleet can contain zero or more instances.</p>
/// <p> <b>Related actions</b> </p>
/// <p> <code>DescribeInstances</code> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Instance {
    /// <p>A unique identifier for the fleet that the instance is in.</p>
    pub fleet_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
    /// </region></code>.</p>
    pub fleet_arn: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the instance.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>IP address that is assigned to the instance.</p>
    pub ip_address: std::option::Option<std::string::String>,
    /// <p>The DNS identifier assigned to the instance that is running the game session. Values have the following format:</p>
    /// <ul>
    /// <li> <p>TLS-enabled fleets: <code>
    /// <unique identifier>
    /// .
    /// <region identifier>
    /// .amazongamelift.com
    /// </region>
    /// </unique></code>.</p> </li>
    /// <li> <p>Non-TLS-enabled fleets: <code>ec2-
    /// <unique identifier>
    /// .compute.amazonaws.com
    /// </unique></code>. (See <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses">Amazon EC2 Instance IP Addressing</a>.)</p> </li>
    /// </ul>
    /// <p>When connecting to a game session that is running on a TLS-enabled fleet, you must use the DNS name, not the IP address.</p>
    pub dns_name: std::option::Option<std::string::String>,
    /// <p>Operating system that is running on this instance. </p>
    pub operating_system: std::option::Option<crate::model::OperatingSystem>,
    /// <p>Amazon EC2 instance type that defines the computing resources of this instance. </p>
    pub r#type: std::option::Option<crate::model::Ec2InstanceType>,
    /// <p>Current status of the instance. Possible statuses include the following:</p>
    /// <ul>
    /// <li> <p> <b>PENDING</b> -- The instance is in the process of being created and launching server processes as defined in the fleet's run-time configuration. </p> </li>
    /// <li> <p> <b>ACTIVE</b> -- The instance has been successfully created and at least one server process has successfully launched and reported back to GameLift that it is ready to host a game session. The instance is now considered ready to host game sessions. </p> </li>
    /// <li> <p> <b>TERMINATING</b> -- The instance is in the process of shutting down. This may happen to reduce capacity during a scaling down event or to recycle resources in the event of a problem.</p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::InstanceStatus>,
    /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The fleet location of the instance, expressed as an Amazon Web Services Region code, such as <code>us-west-2</code>. </p>
    pub location: std::option::Option<std::string::String>,
}
impl Instance {
    /// <p>A unique identifier for the fleet that the instance is in.</p>
    pub fn fleet_id(&self) -> std::option::Option<&str> {
        self.fleet_id.as_deref()
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
    /// </region></code>.</p>
    pub fn fleet_arn(&self) -> std::option::Option<&str> {
        self.fleet_arn.as_deref()
    }
    /// <p>A unique identifier for the instance.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>IP address that is assigned to the instance.</p>
    pub fn ip_address(&self) -> std::option::Option<&str> {
        self.ip_address.as_deref()
    }
    /// <p>The DNS identifier assigned to the instance that is running the game session. Values have the following format:</p>
    /// <ul>
    /// <li> <p>TLS-enabled fleets: <code>
    /// <unique identifier>
    /// .
    /// <region identifier>
    /// .amazongamelift.com
    /// </region>
    /// </unique></code>.</p> </li>
    /// <li> <p>Non-TLS-enabled fleets: <code>ec2-
    /// <unique identifier>
    /// .compute.amazonaws.com
    /// </unique></code>. (See <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses">Amazon EC2 Instance IP Addressing</a>.)</p> </li>
    /// </ul>
    /// <p>When connecting to a game session that is running on a TLS-enabled fleet, you must use the DNS name, not the IP address.</p>
    pub fn dns_name(&self) -> std::option::Option<&str> {
        self.dns_name.as_deref()
    }
    /// <p>Operating system that is running on this instance. </p>
    pub fn operating_system(&self) -> std::option::Option<&crate::model::OperatingSystem> {
        self.operating_system.as_ref()
    }
    /// <p>Amazon EC2 instance type that defines the computing resources of this instance. </p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::Ec2InstanceType> {
        self.r#type.as_ref()
    }
    /// <p>Current status of the instance. Possible statuses include the following:</p>
    /// <ul>
    /// <li> <p> <b>PENDING</b> -- The instance is in the process of being created and launching server processes as defined in the fleet's run-time configuration. </p> </li>
    /// <li> <p> <b>ACTIVE</b> -- The instance has been successfully created and at least one server process has successfully launched and reported back to GameLift that it is ready to host a game session. The instance is now considered ready to host game sessions. </p> </li>
    /// <li> <p> <b>TERMINATING</b> -- The instance is in the process of shutting down. This may happen to reduce capacity during a scaling down event or to recycle resources in the event of a problem.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::InstanceStatus> {
        self.status.as_ref()
    }
    /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The fleet location of the instance, expressed as an Amazon Web Services Region code, such as <code>us-west-2</code>. </p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
}
impl std::fmt::Debug for Instance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Instance");
        formatter.field("fleet_id", &self.fleet_id);
        formatter.field("fleet_arn", &self.fleet_arn);
        formatter.field("instance_id", &self.instance_id);
        formatter.field("ip_address", &self.ip_address);
        formatter.field("dns_name", &self.dns_name);
        formatter.field("operating_system", &self.operating_system);
        formatter.field("r#type", &self.r#type);
        formatter.field("status", &self.status);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("location", &self.location);
        formatter.finish()
    }
}
/// See [`Instance`](crate::model::Instance)
pub mod instance {
    /// A builder for [`Instance`](crate::model::Instance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) fleet_arn: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) ip_address: std::option::Option<std::string::String>,
        pub(crate) dns_name: std::option::Option<std::string::String>,
        pub(crate) operating_system: std::option::Option<crate::model::OperatingSystem>,
        pub(crate) r#type: std::option::Option<crate::model::Ec2InstanceType>,
        pub(crate) status: std::option::Option<crate::model::InstanceStatus>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet that the instance is in.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet that the instance is in.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
        /// </region></code>.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
        /// </region></code>.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_arn = input;
            self
        }
        /// <p>A unique identifier for the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>IP address that is assigned to the instance.</p>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address = Some(input.into());
            self
        }
        /// <p>IP address that is assigned to the instance.</p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_address = input;
            self
        }
        /// <p>The DNS identifier assigned to the instance that is running the game session. Values have the following format:</p>
        /// <ul>
        /// <li> <p>TLS-enabled fleets: <code>
        /// <unique identifier>
        /// .
        /// <region identifier>
        /// .amazongamelift.com
        /// </region>
        /// </unique></code>.</p> </li>
        /// <li> <p>Non-TLS-enabled fleets: <code>ec2-
        /// <unique identifier>
        /// .compute.amazonaws.com
        /// </unique></code>. (See <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses">Amazon EC2 Instance IP Addressing</a>.)</p> </li>
        /// </ul>
        /// <p>When connecting to a game session that is running on a TLS-enabled fleet, you must use the DNS name, not the IP address.</p>
        pub fn dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dns_name = Some(input.into());
            self
        }
        /// <p>The DNS identifier assigned to the instance that is running the game session. Values have the following format:</p>
        /// <ul>
        /// <li> <p>TLS-enabled fleets: <code>
        /// <unique identifier>
        /// .
        /// <region identifier>
        /// .amazongamelift.com
        /// </region>
        /// </unique></code>.</p> </li>
        /// <li> <p>Non-TLS-enabled fleets: <code>ec2-
        /// <unique identifier>
        /// .compute.amazonaws.com
        /// </unique></code>. (See <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses">Amazon EC2 Instance IP Addressing</a>.)</p> </li>
        /// </ul>
        /// <p>When connecting to a game session that is running on a TLS-enabled fleet, you must use the DNS name, not the IP address.</p>
        pub fn set_dns_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dns_name = input;
            self
        }
        /// <p>Operating system that is running on this instance. </p>
        pub fn operating_system(mut self, input: crate::model::OperatingSystem) -> Self {
            self.operating_system = Some(input);
            self
        }
        /// <p>Operating system that is running on this instance. </p>
        pub fn set_operating_system(
            mut self,
            input: std::option::Option<crate::model::OperatingSystem>,
        ) -> Self {
            self.operating_system = input;
            self
        }
        /// <p>Amazon EC2 instance type that defines the computing resources of this instance. </p>
        pub fn r#type(mut self, input: crate::model::Ec2InstanceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Amazon EC2 instance type that defines the computing resources of this instance. </p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::Ec2InstanceType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Current status of the instance. Possible statuses include the following:</p>
        /// <ul>
        /// <li> <p> <b>PENDING</b> -- The instance is in the process of being created and launching server processes as defined in the fleet's run-time configuration. </p> </li>
        /// <li> <p> <b>ACTIVE</b> -- The instance has been successfully created and at least one server process has successfully launched and reported back to GameLift that it is ready to host a game session. The instance is now considered ready to host game sessions. </p> </li>
        /// <li> <p> <b>TERMINATING</b> -- The instance is in the process of shutting down. This may happen to reduce capacity during a scaling down event or to recycle resources in the event of a problem.</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::InstanceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Current status of the instance. Possible statuses include the following:</p>
        /// <ul>
        /// <li> <p> <b>PENDING</b> -- The instance is in the process of being created and launching server processes as defined in the fleet's run-time configuration. </p> </li>
        /// <li> <p> <b>ACTIVE</b> -- The instance has been successfully created and at least one server process has successfully launched and reported back to GameLift that it is ready to host a game session. The instance is now considered ready to host game sessions. </p> </li>
        /// <li> <p> <b>TERMINATING</b> -- The instance is in the process of shutting down. This may happen to reduce capacity during a scaling down event or to recycle resources in the event of a problem.</p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::InstanceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The fleet location of the instance, expressed as an Amazon Web Services Region code, such as <code>us-west-2</code>. </p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The fleet location of the instance, expressed as an Amazon Web Services Region code, such as <code>us-west-2</code>. </p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`Instance`](crate::model::Instance)
        pub fn build(self) -> crate::model::Instance {
            crate::model::Instance {
                fleet_id: self.fleet_id,
                fleet_arn: self.fleet_arn,
                instance_id: self.instance_id,
                ip_address: self.ip_address,
                dns_name: self.dns_name,
                operating_system: self.operating_system,
                r#type: self.r#type,
                status: self.status,
                creation_time: self.creation_time,
                location: self.location,
            }
        }
    }
}
impl Instance {
    /// Creates a new builder-style object to manufacture [`Instance`](crate::model::Instance)
    pub fn builder() -> crate::model::instance::Builder {
        crate::model::instance::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Terminating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => InstanceStatus::Active,
            "PENDING" => InstanceStatus::Pending,
            "TERMINATING" => InstanceStatus::Terminating,
            other => InstanceStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceStatus::from(s))
    }
}
impl InstanceStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceStatus::Active => "ACTIVE",
            InstanceStatus::Pending => "PENDING",
            InstanceStatus::Terminating => "TERMINATING",
            InstanceStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "PENDING", "TERMINATING"]
    }
}
impl AsRef<str> for InstanceStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Ec2InstanceType {
    #[allow(missing_docs)] // documentation missing in model
    C32xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C34xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C38xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C3Large,
    #[allow(missing_docs)] // documentation missing in model
    C3Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C42xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C44xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C48xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C4Large,
    #[allow(missing_docs)] // documentation missing in model
    C4Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C512xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C518xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C524xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C52xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C54xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C59xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5Large,
    #[allow(missing_docs)] // documentation missing in model
    C5Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5a12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5a16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5a24xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5a2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5a4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5a8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5aLarge,
    #[allow(missing_docs)] // documentation missing in model
    C5aXlarge,
    #[allow(missing_docs)] // documentation missing in model
    M32xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M3Large,
    #[allow(missing_docs)] // documentation missing in model
    M3Medium,
    #[allow(missing_docs)] // documentation missing in model
    M3Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M410xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M42xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M44xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M4Large,
    #[allow(missing_docs)] // documentation missing in model
    M4Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M512xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M516xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M524xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M52xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M54xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M58xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5Large,
    #[allow(missing_docs)] // documentation missing in model
    M5Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5a12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5a16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5a24xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5a2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5a4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5a8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5aLarge,
    #[allow(missing_docs)] // documentation missing in model
    M5aXlarge,
    #[allow(missing_docs)] // documentation missing in model
    R32xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R34xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R38xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R3Large,
    #[allow(missing_docs)] // documentation missing in model
    R3Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R416xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R42xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R44xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R48xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R4Large,
    #[allow(missing_docs)] // documentation missing in model
    R4Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R512xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R516xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R524xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R52xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R54xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R58xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5Large,
    #[allow(missing_docs)] // documentation missing in model
    R5Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5a12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5a16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5a24xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5a2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5a4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5a8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5aLarge,
    #[allow(missing_docs)] // documentation missing in model
    R5aXlarge,
    #[allow(missing_docs)] // documentation missing in model
    T2Large,
    #[allow(missing_docs)] // documentation missing in model
    T2Medium,
    #[allow(missing_docs)] // documentation missing in model
    T2Micro,
    #[allow(missing_docs)] // documentation missing in model
    T2Small,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Ec2InstanceType {
    fn from(s: &str) -> Self {
        match s {
            "c3.2xlarge" => Ec2InstanceType::C32xlarge,
            "c3.4xlarge" => Ec2InstanceType::C34xlarge,
            "c3.8xlarge" => Ec2InstanceType::C38xlarge,
            "c3.large" => Ec2InstanceType::C3Large,
            "c3.xlarge" => Ec2InstanceType::C3Xlarge,
            "c4.2xlarge" => Ec2InstanceType::C42xlarge,
            "c4.4xlarge" => Ec2InstanceType::C44xlarge,
            "c4.8xlarge" => Ec2InstanceType::C48xlarge,
            "c4.large" => Ec2InstanceType::C4Large,
            "c4.xlarge" => Ec2InstanceType::C4Xlarge,
            "c5.12xlarge" => Ec2InstanceType::C512xlarge,
            "c5.18xlarge" => Ec2InstanceType::C518xlarge,
            "c5.24xlarge" => Ec2InstanceType::C524xlarge,
            "c5.2xlarge" => Ec2InstanceType::C52xlarge,
            "c5.4xlarge" => Ec2InstanceType::C54xlarge,
            "c5.9xlarge" => Ec2InstanceType::C59xlarge,
            "c5.large" => Ec2InstanceType::C5Large,
            "c5.xlarge" => Ec2InstanceType::C5Xlarge,
            "c5a.12xlarge" => Ec2InstanceType::C5a12xlarge,
            "c5a.16xlarge" => Ec2InstanceType::C5a16xlarge,
            "c5a.24xlarge" => Ec2InstanceType::C5a24xlarge,
            "c5a.2xlarge" => Ec2InstanceType::C5a2xlarge,
            "c5a.4xlarge" => Ec2InstanceType::C5a4xlarge,
            "c5a.8xlarge" => Ec2InstanceType::C5a8xlarge,
            "c5a.large" => Ec2InstanceType::C5aLarge,
            "c5a.xlarge" => Ec2InstanceType::C5aXlarge,
            "m3.2xlarge" => Ec2InstanceType::M32xlarge,
            "m3.large" => Ec2InstanceType::M3Large,
            "m3.medium" => Ec2InstanceType::M3Medium,
            "m3.xlarge" => Ec2InstanceType::M3Xlarge,
            "m4.10xlarge" => Ec2InstanceType::M410xlarge,
            "m4.2xlarge" => Ec2InstanceType::M42xlarge,
            "m4.4xlarge" => Ec2InstanceType::M44xlarge,
            "m4.large" => Ec2InstanceType::M4Large,
            "m4.xlarge" => Ec2InstanceType::M4Xlarge,
            "m5.12xlarge" => Ec2InstanceType::M512xlarge,
            "m5.16xlarge" => Ec2InstanceType::M516xlarge,
            "m5.24xlarge" => Ec2InstanceType::M524xlarge,
            "m5.2xlarge" => Ec2InstanceType::M52xlarge,
            "m5.4xlarge" => Ec2InstanceType::M54xlarge,
            "m5.8xlarge" => Ec2InstanceType::M58xlarge,
            "m5.large" => Ec2InstanceType::M5Large,
            "m5.xlarge" => Ec2InstanceType::M5Xlarge,
            "m5a.12xlarge" => Ec2InstanceType::M5a12xlarge,
            "m5a.16xlarge" => Ec2InstanceType::M5a16xlarge,
            "m5a.24xlarge" => Ec2InstanceType::M5a24xlarge,
            "m5a.2xlarge" => Ec2InstanceType::M5a2xlarge,
            "m5a.4xlarge" => Ec2InstanceType::M5a4xlarge,
            "m5a.8xlarge" => Ec2InstanceType::M5a8xlarge,
            "m5a.large" => Ec2InstanceType::M5aLarge,
            "m5a.xlarge" => Ec2InstanceType::M5aXlarge,
            "r3.2xlarge" => Ec2InstanceType::R32xlarge,
            "r3.4xlarge" => Ec2InstanceType::R34xlarge,
            "r3.8xlarge" => Ec2InstanceType::R38xlarge,
            "r3.large" => Ec2InstanceType::R3Large,
            "r3.xlarge" => Ec2InstanceType::R3Xlarge,
            "r4.16xlarge" => Ec2InstanceType::R416xlarge,
            "r4.2xlarge" => Ec2InstanceType::R42xlarge,
            "r4.4xlarge" => Ec2InstanceType::R44xlarge,
            "r4.8xlarge" => Ec2InstanceType::R48xlarge,
            "r4.large" => Ec2InstanceType::R4Large,
            "r4.xlarge" => Ec2InstanceType::R4Xlarge,
            "r5.12xlarge" => Ec2InstanceType::R512xlarge,
            "r5.16xlarge" => Ec2InstanceType::R516xlarge,
            "r5.24xlarge" => Ec2InstanceType::R524xlarge,
            "r5.2xlarge" => Ec2InstanceType::R52xlarge,
            "r5.4xlarge" => Ec2InstanceType::R54xlarge,
            "r5.8xlarge" => Ec2InstanceType::R58xlarge,
            "r5.large" => Ec2InstanceType::R5Large,
            "r5.xlarge" => Ec2InstanceType::R5Xlarge,
            "r5a.12xlarge" => Ec2InstanceType::R5a12xlarge,
            "r5a.16xlarge" => Ec2InstanceType::R5a16xlarge,
            "r5a.24xlarge" => Ec2InstanceType::R5a24xlarge,
            "r5a.2xlarge" => Ec2InstanceType::R5a2xlarge,
            "r5a.4xlarge" => Ec2InstanceType::R5a4xlarge,
            "r5a.8xlarge" => Ec2InstanceType::R5a8xlarge,
            "r5a.large" => Ec2InstanceType::R5aLarge,
            "r5a.xlarge" => Ec2InstanceType::R5aXlarge,
            "t2.large" => Ec2InstanceType::T2Large,
            "t2.medium" => Ec2InstanceType::T2Medium,
            "t2.micro" => Ec2InstanceType::T2Micro,
            "t2.small" => Ec2InstanceType::T2Small,
            other => Ec2InstanceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Ec2InstanceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Ec2InstanceType::from(s))
    }
}
impl Ec2InstanceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Ec2InstanceType::C32xlarge => "c3.2xlarge",
            Ec2InstanceType::C34xlarge => "c3.4xlarge",
            Ec2InstanceType::C38xlarge => "c3.8xlarge",
            Ec2InstanceType::C3Large => "c3.large",
            Ec2InstanceType::C3Xlarge => "c3.xlarge",
            Ec2InstanceType::C42xlarge => "c4.2xlarge",
            Ec2InstanceType::C44xlarge => "c4.4xlarge",
            Ec2InstanceType::C48xlarge => "c4.8xlarge",
            Ec2InstanceType::C4Large => "c4.large",
            Ec2InstanceType::C4Xlarge => "c4.xlarge",
            Ec2InstanceType::C512xlarge => "c5.12xlarge",
            Ec2InstanceType::C518xlarge => "c5.18xlarge",
            Ec2InstanceType::C524xlarge => "c5.24xlarge",
            Ec2InstanceType::C52xlarge => "c5.2xlarge",
            Ec2InstanceType::C54xlarge => "c5.4xlarge",
            Ec2InstanceType::C59xlarge => "c5.9xlarge",
            Ec2InstanceType::C5Large => "c5.large",
            Ec2InstanceType::C5Xlarge => "c5.xlarge",
            Ec2InstanceType::C5a12xlarge => "c5a.12xlarge",
            Ec2InstanceType::C5a16xlarge => "c5a.16xlarge",
            Ec2InstanceType::C5a24xlarge => "c5a.24xlarge",
            Ec2InstanceType::C5a2xlarge => "c5a.2xlarge",
            Ec2InstanceType::C5a4xlarge => "c5a.4xlarge",
            Ec2InstanceType::C5a8xlarge => "c5a.8xlarge",
            Ec2InstanceType::C5aLarge => "c5a.large",
            Ec2InstanceType::C5aXlarge => "c5a.xlarge",
            Ec2InstanceType::M32xlarge => "m3.2xlarge",
            Ec2InstanceType::M3Large => "m3.large",
            Ec2InstanceType::M3Medium => "m3.medium",
            Ec2InstanceType::M3Xlarge => "m3.xlarge",
            Ec2InstanceType::M410xlarge => "m4.10xlarge",
            Ec2InstanceType::M42xlarge => "m4.2xlarge",
            Ec2InstanceType::M44xlarge => "m4.4xlarge",
            Ec2InstanceType::M4Large => "m4.large",
            Ec2InstanceType::M4Xlarge => "m4.xlarge",
            Ec2InstanceType::M512xlarge => "m5.12xlarge",
            Ec2InstanceType::M516xlarge => "m5.16xlarge",
            Ec2InstanceType::M524xlarge => "m5.24xlarge",
            Ec2InstanceType::M52xlarge => "m5.2xlarge",
            Ec2InstanceType::M54xlarge => "m5.4xlarge",
            Ec2InstanceType::M58xlarge => "m5.8xlarge",
            Ec2InstanceType::M5Large => "m5.large",
            Ec2InstanceType::M5Xlarge => "m5.xlarge",
            Ec2InstanceType::M5a12xlarge => "m5a.12xlarge",
            Ec2InstanceType::M5a16xlarge => "m5a.16xlarge",
            Ec2InstanceType::M5a24xlarge => "m5a.24xlarge",
            Ec2InstanceType::M5a2xlarge => "m5a.2xlarge",
            Ec2InstanceType::M5a4xlarge => "m5a.4xlarge",
            Ec2InstanceType::M5a8xlarge => "m5a.8xlarge",
            Ec2InstanceType::M5aLarge => "m5a.large",
            Ec2InstanceType::M5aXlarge => "m5a.xlarge",
            Ec2InstanceType::R32xlarge => "r3.2xlarge",
            Ec2InstanceType::R34xlarge => "r3.4xlarge",
            Ec2InstanceType::R38xlarge => "r3.8xlarge",
            Ec2InstanceType::R3Large => "r3.large",
            Ec2InstanceType::R3Xlarge => "r3.xlarge",
            Ec2InstanceType::R416xlarge => "r4.16xlarge",
            Ec2InstanceType::R42xlarge => "r4.2xlarge",
            Ec2InstanceType::R44xlarge => "r4.4xlarge",
            Ec2InstanceType::R48xlarge => "r4.8xlarge",
            Ec2InstanceType::R4Large => "r4.large",
            Ec2InstanceType::R4Xlarge => "r4.xlarge",
            Ec2InstanceType::R512xlarge => "r5.12xlarge",
            Ec2InstanceType::R516xlarge => "r5.16xlarge",
            Ec2InstanceType::R524xlarge => "r5.24xlarge",
            Ec2InstanceType::R52xlarge => "r5.2xlarge",
            Ec2InstanceType::R54xlarge => "r5.4xlarge",
            Ec2InstanceType::R58xlarge => "r5.8xlarge",
            Ec2InstanceType::R5Large => "r5.large",
            Ec2InstanceType::R5Xlarge => "r5.xlarge",
            Ec2InstanceType::R5a12xlarge => "r5a.12xlarge",
            Ec2InstanceType::R5a16xlarge => "r5a.16xlarge",
            Ec2InstanceType::R5a24xlarge => "r5a.24xlarge",
            Ec2InstanceType::R5a2xlarge => "r5a.2xlarge",
            Ec2InstanceType::R5a4xlarge => "r5a.4xlarge",
            Ec2InstanceType::R5a8xlarge => "r5a.8xlarge",
            Ec2InstanceType::R5aLarge => "r5a.large",
            Ec2InstanceType::R5aXlarge => "r5a.xlarge",
            Ec2InstanceType::T2Large => "t2.large",
            Ec2InstanceType::T2Medium => "t2.medium",
            Ec2InstanceType::T2Micro => "t2.micro",
            Ec2InstanceType::T2Small => "t2.small",
            Ec2InstanceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "c3.2xlarge",
            "c3.4xlarge",
            "c3.8xlarge",
            "c3.large",
            "c3.xlarge",
            "c4.2xlarge",
            "c4.4xlarge",
            "c4.8xlarge",
            "c4.large",
            "c4.xlarge",
            "c5.12xlarge",
            "c5.18xlarge",
            "c5.24xlarge",
            "c5.2xlarge",
            "c5.4xlarge",
            "c5.9xlarge",
            "c5.large",
            "c5.xlarge",
            "c5a.12xlarge",
            "c5a.16xlarge",
            "c5a.24xlarge",
            "c5a.2xlarge",
            "c5a.4xlarge",
            "c5a.8xlarge",
            "c5a.large",
            "c5a.xlarge",
            "m3.2xlarge",
            "m3.large",
            "m3.medium",
            "m3.xlarge",
            "m4.10xlarge",
            "m4.2xlarge",
            "m4.4xlarge",
            "m4.large",
            "m4.xlarge",
            "m5.12xlarge",
            "m5.16xlarge",
            "m5.24xlarge",
            "m5.2xlarge",
            "m5.4xlarge",
            "m5.8xlarge",
            "m5.large",
            "m5.xlarge",
            "m5a.12xlarge",
            "m5a.16xlarge",
            "m5a.24xlarge",
            "m5a.2xlarge",
            "m5a.4xlarge",
            "m5a.8xlarge",
            "m5a.large",
            "m5a.xlarge",
            "r3.2xlarge",
            "r3.4xlarge",
            "r3.8xlarge",
            "r3.large",
            "r3.xlarge",
            "r4.16xlarge",
            "r4.2xlarge",
            "r4.4xlarge",
            "r4.8xlarge",
            "r4.large",
            "r4.xlarge",
            "r5.12xlarge",
            "r5.16xlarge",
            "r5.24xlarge",
            "r5.2xlarge",
            "r5.4xlarge",
            "r5.8xlarge",
            "r5.large",
            "r5.xlarge",
            "r5a.12xlarge",
            "r5a.16xlarge",
            "r5a.24xlarge",
            "r5a.2xlarge",
            "r5a.4xlarge",
            "r5a.8xlarge",
            "r5a.large",
            "r5a.xlarge",
            "t2.large",
            "t2.medium",
            "t2.micro",
            "t2.small",
        ]
    }
}
impl AsRef<str> for Ec2InstanceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A game session's properties plus the protection policy currently in force.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GameSessionDetail {
    /// <p>Object that describes a game session.</p>
    pub game_session: std::option::Option<crate::model::GameSession>,
    /// <p>Current status of protection for the game session.</p>
    /// <ul>
    /// <li> <p> <b>NoProtection</b> -- The game session can be terminated during a scale-down event.</p> </li>
    /// <li> <p> <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during a scale-down event.</p> </li>
    /// </ul>
    pub protection_policy: std::option::Option<crate::model::ProtectionPolicy>,
}
impl GameSessionDetail {
    /// <p>Object that describes a game session.</p>
    pub fn game_session(&self) -> std::option::Option<&crate::model::GameSession> {
        self.game_session.as_ref()
    }
    /// <p>Current status of protection for the game session.</p>
    /// <ul>
    /// <li> <p> <b>NoProtection</b> -- The game session can be terminated during a scale-down event.</p> </li>
    /// <li> <p> <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during a scale-down event.</p> </li>
    /// </ul>
    pub fn protection_policy(&self) -> std::option::Option<&crate::model::ProtectionPolicy> {
        self.protection_policy.as_ref()
    }
}
impl std::fmt::Debug for GameSessionDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GameSessionDetail");
        formatter.field("game_session", &self.game_session);
        formatter.field("protection_policy", &self.protection_policy);
        formatter.finish()
    }
}
/// See [`GameSessionDetail`](crate::model::GameSessionDetail)
pub mod game_session_detail {
    /// A builder for [`GameSessionDetail`](crate::model::GameSessionDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_session: std::option::Option<crate::model::GameSession>,
        pub(crate) protection_policy: std::option::Option<crate::model::ProtectionPolicy>,
    }
    impl Builder {
        /// <p>Object that describes a game session.</p>
        pub fn game_session(mut self, input: crate::model::GameSession) -> Self {
            self.game_session = Some(input);
            self
        }
        /// <p>Object that describes a game session.</p>
        pub fn set_game_session(
            mut self,
            input: std::option::Option<crate::model::GameSession>,
        ) -> Self {
            self.game_session = input;
            self
        }
        /// <p>Current status of protection for the game session.</p>
        /// <ul>
        /// <li> <p> <b>NoProtection</b> -- The game session can be terminated during a scale-down event.</p> </li>
        /// <li> <p> <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during a scale-down event.</p> </li>
        /// </ul>
        pub fn protection_policy(mut self, input: crate::model::ProtectionPolicy) -> Self {
            self.protection_policy = Some(input);
            self
        }
        /// <p>Current status of protection for the game session.</p>
        /// <ul>
        /// <li> <p> <b>NoProtection</b> -- The game session can be terminated during a scale-down event.</p> </li>
        /// <li> <p> <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during a scale-down event.</p> </li>
        /// </ul>
        pub fn set_protection_policy(
            mut self,
            input: std::option::Option<crate::model::ProtectionPolicy>,
        ) -> Self {
            self.protection_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`GameSessionDetail`](crate::model::GameSessionDetail)
        pub fn build(self) -> crate::model::GameSessionDetail {
            crate::model::GameSessionDetail {
                game_session: self.game_session,
                protection_policy: self.protection_policy,
            }
        }
    }
}
impl GameSessionDetail {
    /// Creates a new builder-style object to manufacture [`GameSessionDetail`](crate::model::GameSessionDetail)
    pub fn builder() -> crate::model::game_session_detail::Builder {
        crate::model::game_session_detail::Builder::default()
    }
}

/// <p> <b>This data type is used with the GameLift FleetIQ and game server groups.</b> </p>
/// <p> Additional properties, including status, that describe an EC2 instance in a game server group. Instance configurations are set with game server group properties (see <code>DescribeGameServerGroup</code> and with the EC2 launch template that was used when creating the game server group. </p>
/// <p>Retrieve game server instances for a game server group by calling <code>DescribeGameServerInstances</code>. </p>
/// <p> <b>Related actions</b> </p>
/// <p> <code>CreateGameServerGroup</code> | <code>ListGameServerGroups</code> | <code>DescribeGameServerGroup</code> | <code>UpdateGameServerGroup</code> | <code>DeleteGameServerGroup</code> | <code>ResumeGameServerGroup</code> | <code>SuspendGameServerGroup</code> | <code>DescribeGameServerInstances</code> | <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/reference-awssdk-fleetiq.html">All APIs by task</a> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GameServerInstance {
    /// <p>A developer-defined identifier for the game server group that includes the game server instance. The name is unique for each Region in each Amazon Web Services account.</p>
    pub game_server_group_name: std::option::Option<std::string::String>,
    /// <p>A generated unique identifier for the game server group that includes the game server instance. </p>
    pub game_server_group_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the instance where the game server is running. This ID is available in the instance metadata. EC2 instance IDs use a 17-character format, for example: <code>i-1234567890abcdef0</code>.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p> Current status of the game server instance. </p>
    /// <ul>
    /// <li> <p> <b>ACTIVE</b> -- The instance is viable for hosting game servers. </p> </li>
    /// <li> <p> <b>DRAINING</b> -- The instance is not viable for hosting game servers. Existing game servers are in the process of ending, and new game servers are not started on this instance unless no other resources are available. When the instance is put in DRAINING, a new instance is started up to replace it. Once the instance has no UTILIZED game servers, it will be terminated in favor of the new instance.</p> </li>
    /// <li> <p> <b>SPOT_TERMINATING</b> -- The instance is in the process of shutting down due to a Spot instance interruption. No new game servers are started on this instance.</p> </li>
    /// </ul>
    pub instance_status: std::option::Option<crate::model::GameServerInstanceStatus>,
}
impl GameServerInstance {
    /// <p>A developer-defined identifier for the game server group that includes the game server instance. The name is unique for each Region in each Amazon Web Services account.</p>
    pub fn game_server_group_name(&self) -> std::option::Option<&str> {
        self.game_server_group_name.as_deref()
    }
    /// <p>A generated unique identifier for the game server group that includes the game server instance. </p>
    pub fn game_server_group_arn(&self) -> std::option::Option<&str> {
        self.game_server_group_arn.as_deref()
    }
    /// <p>The unique identifier for the instance where the game server is running. This ID is available in the instance metadata. EC2 instance IDs use a 17-character format, for example: <code>i-1234567890abcdef0</code>.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p> Current status of the game server instance. </p>
    /// <ul>
    /// <li> <p> <b>ACTIVE</b> -- The instance is viable for hosting game servers. </p> </li>
    /// <li> <p> <b>DRAINING</b> -- The instance is not viable for hosting game servers. Existing game servers are in the process of ending, and new game servers are not started on this instance unless no other resources are available. When the instance is put in DRAINING, a new instance is started up to replace it. Once the instance has no UTILIZED game servers, it will be terminated in favor of the new instance.</p> </li>
    /// <li> <p> <b>SPOT_TERMINATING</b> -- The instance is in the process of shutting down due to a Spot instance interruption. No new game servers are started on this instance.</p> </li>
    /// </ul>
    pub fn instance_status(&self) -> std::option::Option<&crate::model::GameServerInstanceStatus> {
        self.instance_status.as_ref()
    }
}
impl std::fmt::Debug for GameServerInstance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GameServerInstance");
        formatter.field("game_server_group_name", &self.game_server_group_name);
        formatter.field("game_server_group_arn", &self.game_server_group_arn);
        formatter.field("instance_id", &self.instance_id);
        formatter.field("instance_status", &self.instance_status);
        formatter.finish()
    }
}
/// See [`GameServerInstance`](crate::model::GameServerInstance)
pub mod game_server_instance {
    /// A builder for [`GameServerInstance`](crate::model::GameServerInstance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) game_server_group_name: std::option::Option<std::string::String>,
        pub(crate) game_server_group_arn: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) instance_status: std::option::Option<crate::model::GameServerInstanceStatus>,
    }
    impl Builder {
        /// <p>A developer-defined identifier for the game server group that includes the game server instance. The name is unique for each Region in each Amazon Web Services account.</p>
        pub fn game_server_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_server_group_name = Some(input.into());
            self
        }
        /// <p>A developer-defined identifier for the game server group that includes the game server instance. The name is unique for each Region in each Amazon Web Services account.</p>
        pub fn set_game_server_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_server_group_name = input;
            self
        }
        /// <p>A generated unique identifier for the game server group that includes the game server instance. </p>
        pub fn game_server_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.game_server_group_arn = Some(input.into());
            self
        }
        /// <p>A generated unique identifier for the game server group that includes the game server instance. </p>
        pub fn set_game_server_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.game_server_group_arn = input;
            self
        }
        /// <p>The unique identifier for the instance where the game server is running. This ID is available in the instance metadata. EC2 instance IDs use a 17-character format, for example: <code>i-1234567890abcdef0</code>.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the instance where the game server is running. This ID is available in the instance metadata. EC2 instance IDs use a 17-character format, for example: <code>i-1234567890abcdef0</code>.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p> Current status of the game server instance. </p>
        /// <ul>
        /// <li> <p> <b>ACTIVE</b> -- The instance is viable for hosting game servers. </p> </li>
        /// <li> <p> <b>DRAINING</b> -- The instance is not viable for hosting game servers. Existing game servers are in the process of ending, and new game servers are not started on this instance unless no other resources are available. When the instance is put in DRAINING, a new instance is started up to replace it. Once the instance has no UTILIZED game servers, it will be terminated in favor of the new instance.</p> </li>
        /// <li> <p> <b>SPOT_TERMINATING</b> -- The instance is in the process of shutting down due to a Spot instance interruption. No new game servers are started on this instance.</p> </li>
        /// </ul>
        pub fn instance_status(mut self, input: crate::model::GameServerInstanceStatus) -> Self {
            self.instance_status = Some(input);
            self
        }
        /// <p> Current status of the game server instance. </p>
        /// <ul>
        /// <li> <p> <b>ACTIVE</b> -- The instance is viable for hosting game servers. </p> </li>
        /// <li> <p> <b>DRAINING</b> -- The instance is not viable for hosting game servers. Existing game servers are in the process of ending, and new game servers are not started on this instance unless no other resources are available. When the instance is put in DRAINING, a new instance is started up to replace it. Once the instance has no UTILIZED game servers, it will be terminated in favor of the new instance.</p> </li>
        /// <li> <p> <b>SPOT_TERMINATING</b> -- The instance is in the process of shutting down due to a Spot instance interruption. No new game servers are started on this instance.</p> </li>
        /// </ul>
        pub fn set_instance_status(
            mut self,
            input: std::option::Option<crate::model::GameServerInstanceStatus>,
        ) -> Self {
            self.instance_status = input;
            self
        }
        /// Consumes the builder and constructs a [`GameServerInstance`](crate::model::GameServerInstance)
        pub fn build(self) -> crate::model::GameServerInstance {
            crate::model::GameServerInstance {
                game_server_group_name: self.game_server_group_name,
                game_server_group_arn: self.game_server_group_arn,
                instance_id: self.instance_id,
                instance_status: self.instance_status,
            }
        }
    }
}
impl GameServerInstance {
    /// Creates a new builder-style object to manufacture [`GameServerInstance`](crate::model::GameServerInstance)
    pub fn builder() -> crate::model::game_server_instance::Builder {
        crate::model::game_server_instance::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GameServerInstanceStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Draining,
    #[allow(missing_docs)] // documentation missing in model
    SpotTerminating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GameServerInstanceStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => GameServerInstanceStatus::Active,
            "DRAINING" => GameServerInstanceStatus::Draining,
            "SPOT_TERMINATING" => GameServerInstanceStatus::SpotTerminating,
            other => GameServerInstanceStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GameServerInstanceStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GameServerInstanceStatus::from(s))
    }
}
impl GameServerInstanceStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GameServerInstanceStatus::Active => "ACTIVE",
            GameServerInstanceStatus::Draining => "DRAINING",
            GameServerInstanceStatus::SpotTerminating => "SPOT_TERMINATING",
            GameServerInstanceStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "DRAINING", "SPOT_TERMINATING"]
    }
}
impl AsRef<str> for GameServerInstanceStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Current resource utilization statistics in a specified fleet or location. The location value might refer to a fleet's remote location or its home Region.</p>
/// <p> <b>Related actions</b> </p>
/// <p> <code>DescribeFleetUtilization</code> | <code>DescribeFleetLocationUtilization</code> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FleetUtilization {
    /// <p>A unique identifier for the fleet associated with the location.</p>
    pub fleet_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
    /// </region></code>.</p>
    pub fleet_arn: std::option::Option<std::string::String>,
    /// <p>The number of server processes in <code>ACTIVE</code> status that are currently running across all instances in the fleet location. </p>
    pub active_server_process_count: std::option::Option<i32>,
    /// <p>The number of active game sessions that are currently being hosted across all instances in the fleet location.</p>
    pub active_game_session_count: std::option::Option<i32>,
    /// <p>The number of active player sessions that are currently being hosted across all instances in the fleet location.</p>
    pub current_player_session_count: std::option::Option<i32>,
    /// <p>The maximum number of players allowed across all game sessions that are currently being hosted across all instances in the fleet location.</p>
    pub maximum_player_session_count: std::option::Option<i32>,
    /// <p>The fleet location for the fleet utilization information, expressed as an Amazon Web Services Region code, such as <code>us-west-2</code>. </p>
    pub location: std::option::Option<std::string::String>,
}
impl FleetUtilization {
    /// <p>A unique identifier for the fleet associated with the location.</p>
    pub fn fleet_id(&self) -> std::option::Option<&str> {
        self.fleet_id.as_deref()
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
    /// </region></code>.</p>
    pub fn fleet_arn(&self) -> std::option::Option<&str> {
        self.fleet_arn.as_deref()
    }
    /// <p>The number of server processes in <code>ACTIVE</code> status that are currently running across all instances in the fleet location. </p>
    pub fn active_server_process_count(&self) -> std::option::Option<i32> {
        self.active_server_process_count
    }
    /// <p>The number of active game sessions that are currently being hosted across all instances in the fleet location.</p>
    pub fn active_game_session_count(&self) -> std::option::Option<i32> {
        self.active_game_session_count
    }
    /// <p>The number of active player sessions that are currently being hosted across all instances in the fleet location.</p>
    pub fn current_player_session_count(&self) -> std::option::Option<i32> {
        self.current_player_session_count
    }
    /// <p>The maximum number of players allowed across all game sessions that are currently being hosted across all instances in the fleet location.</p>
    pub fn maximum_player_session_count(&self) -> std::option::Option<i32> {
        self.maximum_player_session_count
    }
    /// <p>The fleet location for the fleet utilization information, expressed as an Amazon Web Services Region code, such as <code>us-west-2</code>. </p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
}
impl std::fmt::Debug for FleetUtilization {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FleetUtilization");
        formatter.field("fleet_id", &self.fleet_id);
        formatter.field("fleet_arn", &self.fleet_arn);
        formatter.field(
            "active_server_process_count",
            &self.active_server_process_count,
        );
        formatter.field("active_game_session_count", &self.active_game_session_count);
        formatter.field(
            "current_player_session_count",
            &self.current_player_session_count,
        );
        formatter.field(
            "maximum_player_session_count",
            &self.maximum_player_session_count,
        );
        formatter.field("location", &self.location);
        formatter.finish()
    }
}
/// See [`FleetUtilization`](crate::model::FleetUtilization)
pub mod fleet_utilization {
    /// A builder for [`FleetUtilization`](crate::model::FleetUtilization)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) fleet_arn: std::option::Option<std::string::String>,
        pub(crate) active_server_process_count: std::option::Option<i32>,
        pub(crate) active_game_session_count: std::option::Option<i32>,
        pub(crate) current_player_session_count: std::option::Option<i32>,
        pub(crate) maximum_player_session_count: std::option::Option<i32>,
        pub(crate) location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet associated with the location.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet associated with the location.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
        /// </region></code>.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
        /// </region></code>.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_arn = input;
            self
        }
        /// <p>The number of server processes in <code>ACTIVE</code> status that are currently running across all instances in the fleet location. </p>
        pub fn active_server_process_count(mut self, input: i32) -> Self {
            self.active_server_process_count = Some(input);
            self
        }
        /// <p>The number of server processes in <code>ACTIVE</code> status that are currently running across all instances in the fleet location. </p>
        pub fn set_active_server_process_count(mut self, input: std::option::Option<i32>) -> Self {
            self.active_server_process_count = input;
            self
        }
        /// <p>The number of active game sessions that are currently being hosted across all instances in the fleet location.</p>
        pub fn active_game_session_count(mut self, input: i32) -> Self {
            self.active_game_session_count = Some(input);
            self
        }
        /// <p>The number of active game sessions that are currently being hosted across all instances in the fleet location.</p>
        pub fn set_active_game_session_count(mut self, input: std::option::Option<i32>) -> Self {
            self.active_game_session_count = input;
            self
        }
        /// <p>The number of active player sessions that are currently being hosted across all instances in the fleet location.</p>
        pub fn current_player_session_count(mut self, input: i32) -> Self {
            self.current_player_session_count = Some(input);
            self
        }
        /// <p>The number of active player sessions that are currently being hosted across all instances in the fleet location.</p>
        pub fn set_current_player_session_count(mut self, input: std::option::Option<i32>) -> Self {
            self.current_player_session_count = input;
            self
        }
        /// <p>The maximum number of players allowed across all game sessions that are currently being hosted across all instances in the fleet location.</p>
        pub fn maximum_player_session_count(mut self, input: i32) -> Self {
            self.maximum_player_session_count = Some(input);
            self
        }
        /// <p>The maximum number of players allowed across all game sessions that are currently being hosted across all instances in the fleet location.</p>
        pub fn set_maximum_player_session_count(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_player_session_count = input;
            self
        }
        /// <p>The fleet location for the fleet utilization information, expressed as an Amazon Web Services Region code, such as <code>us-west-2</code>. </p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The fleet location for the fleet utilization information, expressed as an Amazon Web Services Region code, such as <code>us-west-2</code>. </p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`FleetUtilization`](crate::model::FleetUtilization)
        pub fn build(self) -> crate::model::FleetUtilization {
            crate::model::FleetUtilization {
                fleet_id: self.fleet_id,
                fleet_arn: self.fleet_arn,
                active_server_process_count: self.active_server_process_count,
                active_game_session_count: self.active_game_session_count,
                current_player_session_count: self.current_player_session_count,
                maximum_player_session_count: self.maximum_player_session_count,
                location: self.location,
            }
        }
    }
}
impl FleetUtilization {
    /// Creates a new builder-style object to manufacture [`FleetUtilization`](crate::model::FleetUtilization)
    pub fn builder() -> crate::model::fleet_utilization::Builder {
        crate::model::fleet_utilization::Builder::default()
    }
}

/// <p>Current resource capacity settings in a specified fleet or location. The location value might refer to a fleet's remote location or its home Region. </p>
/// <p> <b>Related actions</b> </p>
/// <p> <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetCapacity.html">DescribeFleetCapacity</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationCapacity.html">DescribeFleetLocationCapacity</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateFleetCapacity.html">UpdateFleetCapacity</a> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FleetCapacity {
    /// <p>A unique identifier for the fleet associated with the location.</p>
    pub fleet_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
    /// </region></code>.</p>
    pub fleet_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon EC2 instance type that is used for all instances in a fleet. The instance type determines the computing resources in use, including CPU, memory, storage, and networking capacity. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud Instance Types</a> for detailed descriptions.</p>
    pub instance_type: std::option::Option<crate::model::Ec2InstanceType>,
    /// <p>The current instance count and capacity settings for the fleet location. </p>
    pub instance_counts: std::option::Option<crate::model::Ec2InstanceCounts>,
    /// <p>The fleet location for the instance count information, expressed as an Amazon Web Services Region code, such as <code>us-west-2</code>. </p>
    pub location: std::option::Option<std::string::String>,
}
impl FleetCapacity {
    /// <p>A unique identifier for the fleet associated with the location.</p>
    pub fn fleet_id(&self) -> std::option::Option<&str> {
        self.fleet_id.as_deref()
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
    /// </region></code>.</p>
    pub fn fleet_arn(&self) -> std::option::Option<&str> {
        self.fleet_arn.as_deref()
    }
    /// <p>The Amazon EC2 instance type that is used for all instances in a fleet. The instance type determines the computing resources in use, including CPU, memory, storage, and networking capacity. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud Instance Types</a> for detailed descriptions.</p>
    pub fn instance_type(&self) -> std::option::Option<&crate::model::Ec2InstanceType> {
        self.instance_type.as_ref()
    }
    /// <p>The current instance count and capacity settings for the fleet location. </p>
    pub fn instance_counts(&self) -> std::option::Option<&crate::model::Ec2InstanceCounts> {
        self.instance_counts.as_ref()
    }
    /// <p>The fleet location for the instance count information, expressed as an Amazon Web Services Region code, such as <code>us-west-2</code>. </p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
}
impl std::fmt::Debug for FleetCapacity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FleetCapacity");
        formatter.field("fleet_id", &self.fleet_id);
        formatter.field("fleet_arn", &self.fleet_arn);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("instance_counts", &self.instance_counts);
        formatter.field("location", &self.location);
        formatter.finish()
    }
}
/// See [`FleetCapacity`](crate::model::FleetCapacity)
pub mod fleet_capacity {
    /// A builder for [`FleetCapacity`](crate::model::FleetCapacity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) fleet_arn: std::option::Option<std::string::String>,
        pub(crate) instance_type: std::option::Option<crate::model::Ec2InstanceType>,
        pub(crate) instance_counts: std::option::Option<crate::model::Ec2InstanceCounts>,
        pub(crate) location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet associated with the location.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet associated with the location.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
        /// </region></code>.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
        /// </region></code>.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_arn = input;
            self
        }
        /// <p>The Amazon EC2 instance type that is used for all instances in a fleet. The instance type determines the computing resources in use, including CPU, memory, storage, and networking capacity. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud Instance Types</a> for detailed descriptions.</p>
        pub fn instance_type(mut self, input: crate::model::Ec2InstanceType) -> Self {
            self.instance_type = Some(input);
            self
        }
        /// <p>The Amazon EC2 instance type that is used for all instances in a fleet. The instance type determines the computing resources in use, including CPU, memory, storage, and networking capacity. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud Instance Types</a> for detailed descriptions.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<crate::model::Ec2InstanceType>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The current instance count and capacity settings for the fleet location. </p>
        pub fn instance_counts(mut self, input: crate::model::Ec2InstanceCounts) -> Self {
            self.instance_counts = Some(input);
            self
        }
        /// <p>The current instance count and capacity settings for the fleet location. </p>
        pub fn set_instance_counts(
            mut self,
            input: std::option::Option<crate::model::Ec2InstanceCounts>,
        ) -> Self {
            self.instance_counts = input;
            self
        }
        /// <p>The fleet location for the instance count information, expressed as an Amazon Web Services Region code, such as <code>us-west-2</code>. </p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The fleet location for the instance count information, expressed as an Amazon Web Services Region code, such as <code>us-west-2</code>. </p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`FleetCapacity`](crate::model::FleetCapacity)
        pub fn build(self) -> crate::model::FleetCapacity {
            crate::model::FleetCapacity {
                fleet_id: self.fleet_id,
                fleet_arn: self.fleet_arn,
                instance_type: self.instance_type,
                instance_counts: self.instance_counts,
                location: self.location,
            }
        }
    }
}
impl FleetCapacity {
    /// Creates a new builder-style object to manufacture [`FleetCapacity`](crate::model::FleetCapacity)
    pub fn builder() -> crate::model::fleet_capacity::Builder {
        crate::model::fleet_capacity::Builder::default()
    }
}

/// <p>Resource capacity settings. Fleet capacity is measured in Amazon EC2 instances. Pending and terminating counts are non-zero when the fleet capacity is adjusting to a scaling event or if access to resources is temporarily affected.</p>
/// <p>EC2 instance counts are part of <code>FleetCapacity</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ec2InstanceCounts {
    /// <p>Ideal number of active instances. GameLift will always try to maintain the desired number of instances. Capacity is scaled up or down by changing the desired instances. </p>
    pub desired: std::option::Option<i32>,
    /// <p>The minimum instance count value allowed.</p>
    pub minimum: std::option::Option<i32>,
    /// <p>The maximum instance count value allowed.</p>
    pub maximum: std::option::Option<i32>,
    /// <p>Number of instances that are starting but not yet active.</p>
    pub pending: std::option::Option<i32>,
    /// <p>Actual number of instances that are ready to host game sessions.</p>
    pub active: std::option::Option<i32>,
    /// <p>Number of active instances that are not currently hosting a game session.</p>
    pub idle: std::option::Option<i32>,
    /// <p>Number of instances that are no longer active but haven't yet been terminated.</p>
    pub terminating: std::option::Option<i32>,
}
impl Ec2InstanceCounts {
    /// <p>Ideal number of active instances. GameLift will always try to maintain the desired number of instances. Capacity is scaled up or down by changing the desired instances. </p>
    pub fn desired(&self) -> std::option::Option<i32> {
        self.desired
    }
    /// <p>The minimum instance count value allowed.</p>
    pub fn minimum(&self) -> std::option::Option<i32> {
        self.minimum
    }
    /// <p>The maximum instance count value allowed.</p>
    pub fn maximum(&self) -> std::option::Option<i32> {
        self.maximum
    }
    /// <p>Number of instances that are starting but not yet active.</p>
    pub fn pending(&self) -> std::option::Option<i32> {
        self.pending
    }
    /// <p>Actual number of instances that are ready to host game sessions.</p>
    pub fn active(&self) -> std::option::Option<i32> {
        self.active
    }
    /// <p>Number of active instances that are not currently hosting a game session.</p>
    pub fn idle(&self) -> std::option::Option<i32> {
        self.idle
    }
    /// <p>Number of instances that are no longer active but haven't yet been terminated.</p>
    pub fn terminating(&self) -> std::option::Option<i32> {
        self.terminating
    }
}
impl std::fmt::Debug for Ec2InstanceCounts {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ec2InstanceCounts");
        formatter.field("desired", &self.desired);
        formatter.field("minimum", &self.minimum);
        formatter.field("maximum", &self.maximum);
        formatter.field("pending", &self.pending);
        formatter.field("active", &self.active);
        formatter.field("idle", &self.idle);
        formatter.field("terminating", &self.terminating);
        formatter.finish()
    }
}
/// See [`Ec2InstanceCounts`](crate::model::Ec2InstanceCounts)
pub mod ec2_instance_counts {
    /// A builder for [`Ec2InstanceCounts`](crate::model::Ec2InstanceCounts)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) desired: std::option::Option<i32>,
        pub(crate) minimum: std::option::Option<i32>,
        pub(crate) maximum: std::option::Option<i32>,
        pub(crate) pending: std::option::Option<i32>,
        pub(crate) active: std::option::Option<i32>,
        pub(crate) idle: std::option::Option<i32>,
        pub(crate) terminating: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Ideal number of active instances. GameLift will always try to maintain the desired number of instances. Capacity is scaled up or down by changing the desired instances. </p>
        pub fn desired(mut self, input: i32) -> Self {
            self.desired = Some(input);
            self
        }
        /// <p>Ideal number of active instances. GameLift will always try to maintain the desired number of instances. Capacity is scaled up or down by changing the desired instances. </p>
        pub fn set_desired(mut self, input: std::option::Option<i32>) -> Self {
            self.desired = input;
            self
        }
        /// <p>The minimum instance count value allowed.</p>
        pub fn minimum(mut self, input: i32) -> Self {
            self.minimum = Some(input);
            self
        }
        /// <p>The minimum instance count value allowed.</p>
        pub fn set_minimum(mut self, input: std::option::Option<i32>) -> Self {
            self.minimum = input;
            self
        }
        /// <p>The maximum instance count value allowed.</p>
        pub fn maximum(mut self, input: i32) -> Self {
            self.maximum = Some(input);
            self
        }
        /// <p>The maximum instance count value allowed.</p>
        pub fn set_maximum(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum = input;
            self
        }
        /// <p>Number of instances that are starting but not yet active.</p>
        pub fn pending(mut self, input: i32) -> Self {
            self.pending = Some(input);
            self
        }
        /// <p>Number of instances that are starting but not yet active.</p>
        pub fn set_pending(mut self, input: std::option::Option<i32>) -> Self {
            self.pending = input;
            self
        }
        /// <p>Actual number of instances that are ready to host game sessions.</p>
        pub fn active(mut self, input: i32) -> Self {
            self.active = Some(input);
            self
        }
        /// <p>Actual number of instances that are ready to host game sessions.</p>
        pub fn set_active(mut self, input: std::option::Option<i32>) -> Self {
            self.active = input;
            self
        }
        /// <p>Number of active instances that are not currently hosting a game session.</p>
        pub fn idle(mut self, input: i32) -> Self {
            self.idle = Some(input);
            self
        }
        /// <p>Number of active instances that are not currently hosting a game session.</p>
        pub fn set_idle(mut self, input: std::option::Option<i32>) -> Self {
            self.idle = input;
            self
        }
        /// <p>Number of instances that are no longer active but haven't yet been terminated.</p>
        pub fn terminating(mut self, input: i32) -> Self {
            self.terminating = Some(input);
            self
        }
        /// <p>Number of instances that are no longer active but haven't yet been terminated.</p>
        pub fn set_terminating(mut self, input: std::option::Option<i32>) -> Self {
            self.terminating = input;
            self
        }
        /// Consumes the builder and constructs a [`Ec2InstanceCounts`](crate::model::Ec2InstanceCounts)
        pub fn build(self) -> crate::model::Ec2InstanceCounts {
            crate::model::Ec2InstanceCounts {
                desired: self.desired,
                minimum: self.minimum,
                maximum: self.maximum,
                pending: self.pending,
                active: self.active,
                idle: self.idle,
                terminating: self.terminating,
            }
        }
    }
}
impl Ec2InstanceCounts {
    /// Creates a new builder-style object to manufacture [`Ec2InstanceCounts`](crate::model::Ec2InstanceCounts)
    pub fn builder() -> crate::model::ec2_instance_counts::Builder {
        crate::model::ec2_instance_counts::Builder::default()
    }
}

/// <p>Represents a location in a multi-location fleet.</p>
/// <p> <b>Related actions</b> </p>
/// <p> <code>DescribeFleetLocationAttributes</code> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LocationAttributes {
    /// <p>A fleet location and its current life-cycle state.</p>
    pub location_state: std::option::Option<crate::model::LocationState>,
    /// <p>A list of fleet actions that have been suspended in the fleet location.</p>
    pub stopped_actions: std::option::Option<std::vec::Vec<crate::model::FleetAction>>,
    /// <p>The status of fleet activity updates to the location. The status <code>PENDING_UPDATE</code> indicates that <code>StopFleetActions</code> or <code>StartFleetActions</code> has been requested but the update has not yet been completed for the location.</p>
    pub update_status: std::option::Option<crate::model::LocationUpdateStatus>,
}
impl LocationAttributes {
    /// <p>A fleet location and its current life-cycle state.</p>
    pub fn location_state(&self) -> std::option::Option<&crate::model::LocationState> {
        self.location_state.as_ref()
    }
    /// <p>A list of fleet actions that have been suspended in the fleet location.</p>
    pub fn stopped_actions(&self) -> std::option::Option<&[crate::model::FleetAction]> {
        self.stopped_actions.as_deref()
    }
    /// <p>The status of fleet activity updates to the location. The status <code>PENDING_UPDATE</code> indicates that <code>StopFleetActions</code> or <code>StartFleetActions</code> has been requested but the update has not yet been completed for the location.</p>
    pub fn update_status(&self) -> std::option::Option<&crate::model::LocationUpdateStatus> {
        self.update_status.as_ref()
    }
}
impl std::fmt::Debug for LocationAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LocationAttributes");
        formatter.field("location_state", &self.location_state);
        formatter.field("stopped_actions", &self.stopped_actions);
        formatter.field("update_status", &self.update_status);
        formatter.finish()
    }
}
/// See [`LocationAttributes`](crate::model::LocationAttributes)
pub mod location_attributes {
    /// A builder for [`LocationAttributes`](crate::model::LocationAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location_state: std::option::Option<crate::model::LocationState>,
        pub(crate) stopped_actions: std::option::Option<std::vec::Vec<crate::model::FleetAction>>,
        pub(crate) update_status: std::option::Option<crate::model::LocationUpdateStatus>,
    }
    impl Builder {
        /// <p>A fleet location and its current life-cycle state.</p>
        pub fn location_state(mut self, input: crate::model::LocationState) -> Self {
            self.location_state = Some(input);
            self
        }
        /// <p>A fleet location and its current life-cycle state.</p>
        pub fn set_location_state(
            mut self,
            input: std::option::Option<crate::model::LocationState>,
        ) -> Self {
            self.location_state = input;
            self
        }
        /// Appends an item to `stopped_actions`.
        ///
        /// To override the contents of this collection use [`set_stopped_actions`](Self::set_stopped_actions).
        ///
        /// <p>A list of fleet actions that have been suspended in the fleet location.</p>
        pub fn stopped_actions(mut self, input: crate::model::FleetAction) -> Self {
            let mut v = self.stopped_actions.unwrap_or_default();
            v.push(input);
            self.stopped_actions = Some(v);
            self
        }
        /// <p>A list of fleet actions that have been suspended in the fleet location.</p>
        pub fn set_stopped_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FleetAction>>,
        ) -> Self {
            self.stopped_actions = input;
            self
        }
        /// <p>The status of fleet activity updates to the location. The status <code>PENDING_UPDATE</code> indicates that <code>StopFleetActions</code> or <code>StartFleetActions</code> has been requested but the update has not yet been completed for the location.</p>
        pub fn update_status(mut self, input: crate::model::LocationUpdateStatus) -> Self {
            self.update_status = Some(input);
            self
        }
        /// <p>The status of fleet activity updates to the location. The status <code>PENDING_UPDATE</code> indicates that <code>StopFleetActions</code> or <code>StartFleetActions</code> has been requested but the update has not yet been completed for the location.</p>
        pub fn set_update_status(
            mut self,
            input: std::option::Option<crate::model::LocationUpdateStatus>,
        ) -> Self {
            self.update_status = input;
            self
        }
        /// Consumes the builder and constructs a [`LocationAttributes`](crate::model::LocationAttributes)
        pub fn build(self) -> crate::model::LocationAttributes {
            crate::model::LocationAttributes {
                location_state: self.location_state,
                stopped_actions: self.stopped_actions,
                update_status: self.update_status,
            }
        }
    }
}
impl LocationAttributes {
    /// Creates a new builder-style object to manufacture [`LocationAttributes`](crate::model::LocationAttributes)
    pub fn builder() -> crate::model::location_attributes::Builder {
        crate::model::location_attributes::Builder::default()
    }
}

/// <p>A fleet location and its life-cycle state. A location state object might be used to describe a fleet's remote location or home Region. Life-cycle state tracks the progress of launching the first instance in a new location and preparing it for game hosting, and then removing all instances and deleting the location from the fleet.</p>
/// <p> <b>Related actions</b> </p>
/// <p> <code>CreateFleet</code> | <code>CreateFleetLocations</code> | <code>DeleteFleetLocations</code> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LocationState {
    /// <p>The fleet location, expressed as an Amazon Web Services Region code such as <code>us-west-2</code>. </p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The life-cycle status of a fleet location. </p>
    pub status: std::option::Option<crate::model::FleetStatus>,
}
impl LocationState {
    /// <p>The fleet location, expressed as an Amazon Web Services Region code such as <code>us-west-2</code>. </p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
    /// <p>The life-cycle status of a fleet location. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::FleetStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for LocationState {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LocationState");
        formatter.field("location", &self.location);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`LocationState`](crate::model::LocationState)
pub mod location_state {
    /// A builder for [`LocationState`](crate::model::LocationState)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::FleetStatus>,
    }
    impl Builder {
        /// <p>The fleet location, expressed as an Amazon Web Services Region code such as <code>us-west-2</code>. </p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The fleet location, expressed as an Amazon Web Services Region code such as <code>us-west-2</code>. </p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The life-cycle status of a fleet location. </p>
        pub fn status(mut self, input: crate::model::FleetStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The life-cycle status of a fleet location. </p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::FleetStatus>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`LocationState`](crate::model::LocationState)
        pub fn build(self) -> crate::model::LocationState {
            crate::model::LocationState {
                location: self.location,
                status: self.status,
            }
        }
    }
}
impl LocationState {
    /// Creates a new builder-style object to manufacture [`LocationState`](crate::model::LocationState)
    pub fn builder() -> crate::model::location_state::Builder {
        crate::model::location_state::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FleetStatus {
    #[allow(missing_docs)] // documentation missing in model
    Activating,
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Building,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Downloading,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    New,
    #[allow(missing_docs)] // documentation missing in model
    Terminated,
    #[allow(missing_docs)] // documentation missing in model
    Validating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FleetStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVATING" => FleetStatus::Activating,
            "ACTIVE" => FleetStatus::Active,
            "BUILDING" => FleetStatus::Building,
            "DELETING" => FleetStatus::Deleting,
            "DOWNLOADING" => FleetStatus::Downloading,
            "ERROR" => FleetStatus::Error,
            "NEW" => FleetStatus::New,
            "TERMINATED" => FleetStatus::Terminated,
            "VALIDATING" => FleetStatus::Validating,
            other => FleetStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FleetStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FleetStatus::from(s))
    }
}
impl FleetStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FleetStatus::Activating => "ACTIVATING",
            FleetStatus::Active => "ACTIVE",
            FleetStatus::Building => "BUILDING",
            FleetStatus::Deleting => "DELETING",
            FleetStatus::Downloading => "DOWNLOADING",
            FleetStatus::Error => "ERROR",
            FleetStatus::New => "NEW",
            FleetStatus::Terminated => "TERMINATED",
            FleetStatus::Validating => "VALIDATING",
            FleetStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVATING",
            "ACTIVE",
            "BUILDING",
            "DELETING",
            "DOWNLOADING",
            "ERROR",
            "NEW",
            "TERMINATED",
            "VALIDATING",
        ]
    }
}
impl AsRef<str> for FleetStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Log entry describing an event that involves GameLift resources (such as a fleet). In addition to tracking activity, event codes and messages can provide additional information for troubleshooting and debugging problems.</p>
/// <p> <b>Related actions</b> </p>
/// <p> <code>DescribeFleetEvents</code> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Event {
    /// <p>A unique identifier for a fleet event.</p>
    pub event_id: std::option::Option<std::string::String>,
    /// <p>A unique identifier for an event resource, such as a fleet ID.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of event being logged. </p>
    /// <p> <b>Fleet state transition events:</b> </p>
    /// <ul>
    /// <li> <p>FLEET_CREATED -- A fleet resource was successfully created with a status of <code>NEW</code>. Event messaging includes the fleet ID.</p> </li>
    /// <li> <p>FLEET_STATE_DOWNLOADING -- Fleet status changed from <code>NEW</code> to <code>DOWNLOADING</code>. The compressed build has started downloading to a fleet instance for installation.</p> </li>
    /// <li> <p>FLEET_STATE_VALIDATING -- Fleet status changed from <code>DOWNLOADING</code> to <code>VALIDATING</code>. GameLift has successfully downloaded the build and is now validating the build files.</p> </li>
    /// <li> <p>FLEET_STATE_BUILDING -- Fleet status changed from <code>VALIDATING</code> to <code>BUILDING</code>. GameLift has successfully verified the build files and is now running the installation scripts.</p> </li>
    /// <li> <p>FLEET_STATE_ACTIVATING -- Fleet status changed from <code>BUILDING</code> to <code>ACTIVATING</code>. GameLift is trying to launch an instance and test the connectivity between the build and the GameLift Service via the Server SDK.</p> </li>
    /// <li> <p>FLEET_STATE_ACTIVE -- The fleet's status changed from <code>ACTIVATING</code> to <code>ACTIVE</code>. The fleet is now ready to host game sessions.</p> </li>
    /// <li> <p>FLEET_STATE_ERROR -- The Fleet's status changed to <code>ERROR</code>. Describe the fleet event message for more details.</p> </li>
    /// </ul>
    /// <p> <b>Fleet creation events (ordered by fleet creation activity):</b> </p>
    /// <ul>
    /// <li> <p>FLEET_BINARY_DOWNLOAD_FAILED -- The build failed to download to the fleet instance.</p> </li>
    /// <li> <p>FLEET_CREATION_EXTRACTING_BUILD -- The game server build was successfully downloaded to an instance, and the build files are now being extracted from the uploaded build and saved to an instance. Failure at this stage prevents a fleet from moving to ACTIVE status. Logs for this stage display a list of the files that are extracted and saved on the instance. Access the logs by using the URL in <i>PreSignedLogUrl</i>.</p> </li>
    /// <li> <p>FLEET_CREATION_RUNNING_INSTALLER -- The game server build files were successfully extracted, and the GameLift is now running the build's install script (if one is included). Failure in this stage prevents a fleet from moving to ACTIVE status. Logs for this stage list the installation steps and whether or not the install completed successfully. Access the logs by using the URL in <i>PreSignedLogUrl</i>.</p> </li>
    /// <li> <p>FLEET_CREATION_VALIDATING_RUNTIME_CONFIG -- The build process was successful, and the GameLift is now verifying that the game server launch paths, which are specified in the fleet's runtime configuration, exist. If any listed launch path exists, GameLift tries to launch a game server process and waits for the process to report ready. Failures in this stage prevent a fleet from moving to <code>ACTIVE</code> status. Logs for this stage list the launch paths in the runtime configuration and indicate whether each is found. Access the logs by using the URL in <i>PreSignedLogUrl</i>.</p> </li>
    /// <li> <p>FLEET_VALIDATION_LAUNCH_PATH_NOT_FOUND -- Validation of the runtime configuration failed because the executable specified in a launch path does not exist on the instance.</p> </li>
    /// <li> <p>FLEET_VALIDATION_EXECUTABLE_RUNTIME_FAILURE -- Validation of the runtime configuration failed because the executable specified in a launch path failed to run on the fleet instance.</p> </li>
    /// <li> <p>FLEET_VALIDATION_TIMED_OUT -- Validation of the fleet at the end of creation timed out. Try fleet creation again.</p> </li>
    /// <li> <p>FLEET_ACTIVATION_FAILED -- The fleet failed to successfully complete one of the steps in the fleet activation process. This event code indicates that the game build was successfully downloaded to a fleet instance, built, and validated, but was not able to start a server process. For more information, see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html#fleets-creating-debug-creation">Debug Fleet Creation Issues</a>.</p> </li>
    /// <li> <p>FLEET_ACTIVATION_FAILED_NO_INSTANCES -- Fleet creation was not able to obtain any instances based on the input fleet attributes. Try again at a different time or choose a different combination of fleet attributes such as fleet type, instance type, etc.</p> </li>
    /// <li> <p>FLEET_INITIALIZATION_FAILED -- A generic exception occurred during fleet creation. Describe the fleet event message for more details.</p> </li>
    /// </ul>
    /// <p> <b>VPC peering events:</b> </p>
    /// <ul>
    /// <li> <p>FLEET_VPC_PEERING_SUCCEEDED -- A VPC peering connection has been established between the VPC for an GameLift fleet and a VPC in your Amazon Web Services account.</p> </li>
    /// <li> <p>FLEET_VPC_PEERING_FAILED -- A requested VPC peering connection has failed. Event details and status information (see <code>DescribeVpcPeeringConnections</code>) provide additional detail. A common reason for peering failure is that the two VPCs have overlapping CIDR blocks of IPv4 addresses. To resolve this, change the CIDR block for the VPC in your Amazon Web Services account. For more information on VPC peering failures, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/PeeringGuide/invalid-peering-configurations.html">https://docs.aws.amazon.com/AmazonVPC/latest/PeeringGuide/invalid-peering-configurations.html</a> </p> </li>
    /// <li> <p>FLEET_VPC_PEERING_DELETED -- A VPC peering connection has been successfully deleted.</p> </li>
    /// </ul>
    /// <p> <b>Spot instance events:</b> </p>
    /// <ul>
    /// <li> <p> INSTANCE_INTERRUPTED -- A spot instance was interrupted by EC2 with a two-minute notification.</p> </li>
    /// </ul>
    /// <p> <b>Spot process events:</b> </p>
    /// <ul>
    /// <li> <p>SERVER_PROCESS_INVALID_PATH -- The game server executable or script could not be found based on the Fleet runtime configuration. Check that the launch path is correct based on the operating system of the Fleet.</p> </li>
    /// <li> <p>SERVER_PROCESS_SDK_INITIALIZATION_TIMEOUT -- The server process did not call InitSDK() within the time expected. Check your game session log to see why InitSDK() was not called in time.</p> </li>
    /// <li> <p>SERVER_PROCESS_PROCESS_READY_TIMEOUT -- The server process did not call ProcessReady() within the time expected after calling InitSDK(). Check your game session log to see why ProcessReady() was not called in time.</p> </li>
    /// <li> <p>SERVER_PROCESS_CRASHED -- The server process exited without calling ProcessEnding(). Check your game session log to see why ProcessEnding() was not called.</p> </li>
    /// <li> <p>SERVER_PROCESS_TERMINATED_UNHEALTHY -- The server process did not report a valid health check for too long and was therefore terminated by GameLift. Check your game session log to see if the thread became stuck processing a synchronous task for too long.</p> </li>
    /// <li> <p>SERVER_PROCESS_FORCE_TERMINATED -- The server process did not exit cleanly after OnProcessTerminate() was sent within the time expected. Check your game session log to see why termination took longer than expected.</p> </li>
    /// <li> <p>SERVER_PROCESS_PROCESS_EXIT_TIMEOUT -- The server process did not exit cleanly within the time expected after calling ProcessEnding(). Check your game session log to see why termination took longer than expected.</p> </li>
    /// </ul>
    /// <p> <b>Game session events:</b> </p>
    /// <ul>
    /// <li> <p>GAME_SESSION_ACTIVATION_TIMEOUT -- GameSession failed to activate within the expected time. Check your game session log to see why ActivateGameSession() took longer to complete than expected.</p> </li>
    /// </ul>
    /// <p> <b>Other fleet events:</b> </p>
    /// <ul>
    /// <li> <p>FLEET_SCALING_EVENT -- A change was made to the fleet's capacity settings (desired instances, minimum/maximum scaling limits). Event messaging includes the new capacity settings.</p> </li>
    /// <li> <p>FLEET_NEW_GAME_SESSION_PROTECTION_POLICY_UPDATED -- A change was made to the fleet's game session protection policy setting. Event messaging includes both the old and new policy setting. </p> </li>
    /// <li> <p>FLEET_DELETED -- A request to delete a fleet was initiated.</p> </li>
    /// <li> <p> GENERIC_EVENT -- An unspecified event has occurred.</p> </li>
    /// </ul>
    pub event_code: std::option::Option<crate::model::EventCode>,
    /// <p>Additional information related to the event.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>Time stamp indicating when this event occurred. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub event_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Location of stored logs with additional detail that is related to the event. This is useful for debugging issues. The URL is valid for 15 minutes. You can also access fleet creation logs through the GameLift console.</p>
    pub pre_signed_log_url: std::option::Option<std::string::String>,
}
impl Event {
    /// <p>A unique identifier for a fleet event.</p>
    pub fn event_id(&self) -> std::option::Option<&str> {
        self.event_id.as_deref()
    }
    /// <p>A unique identifier for an event resource, such as a fleet ID.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The type of event being logged. </p>
    /// <p> <b>Fleet state transition events:</b> </p>
    /// <ul>
    /// <li> <p>FLEET_CREATED -- A fleet resource was successfully created with a status of <code>NEW</code>. Event messaging includes the fleet ID.</p> </li>
    /// <li> <p>FLEET_STATE_DOWNLOADING -- Fleet status changed from <code>NEW</code> to <code>DOWNLOADING</code>. The compressed build has started downloading to a fleet instance for installation.</p> </li>
    /// <li> <p>FLEET_STATE_VALIDATING -- Fleet status changed from <code>DOWNLOADING</code> to <code>VALIDATING</code>. GameLift has successfully downloaded the build and is now validating the build files.</p> </li>
    /// <li> <p>FLEET_STATE_BUILDING -- Fleet status changed from <code>VALIDATING</code> to <code>BUILDING</code>. GameLift has successfully verified the build files and is now running the installation scripts.</p> </li>
    /// <li> <p>FLEET_STATE_ACTIVATING -- Fleet status changed from <code>BUILDING</code> to <code>ACTIVATING</code>. GameLift is trying to launch an instance and test the connectivity between the build and the GameLift Service via the Server SDK.</p> </li>
    /// <li> <p>FLEET_STATE_ACTIVE -- The fleet's status changed from <code>ACTIVATING</code> to <code>ACTIVE</code>. The fleet is now ready to host game sessions.</p> </li>
    /// <li> <p>FLEET_STATE_ERROR -- The Fleet's status changed to <code>ERROR</code>. Describe the fleet event message for more details.</p> </li>
    /// </ul>
    /// <p> <b>Fleet creation events (ordered by fleet creation activity):</b> </p>
    /// <ul>
    /// <li> <p>FLEET_BINARY_DOWNLOAD_FAILED -- The build failed to download to the fleet instance.</p> </li>
    /// <li> <p>FLEET_CREATION_EXTRACTING_BUILD -- The game server build was successfully downloaded to an instance, and the build files are now being extracted from the uploaded build and saved to an instance. Failure at this stage prevents a fleet from moving to ACTIVE status. Logs for this stage display a list of the files that are extracted and saved on the instance. Access the logs by using the URL in <i>PreSignedLogUrl</i>.</p> </li>
    /// <li> <p>FLEET_CREATION_RUNNING_INSTALLER -- The game server build files were successfully extracted, and the GameLift is now running the build's install script (if one is included). Failure in this stage prevents a fleet from moving to ACTIVE status. Logs for this stage list the installation steps and whether or not the install completed successfully. Access the logs by using the URL in <i>PreSignedLogUrl</i>.</p> </li>
    /// <li> <p>FLEET_CREATION_VALIDATING_RUNTIME_CONFIG -- The build process was successful, and the GameLift is now verifying that the game server launch paths, which are specified in the fleet's runtime configuration, exist. If any listed launch path exists, GameLift tries to launch a game server process and waits for the process to report ready. Failures in this stage prevent a fleet from moving to <code>ACTIVE</code> status. Logs for this stage list the launch paths in the runtime configuration and indicate whether each is found. Access the logs by using the URL in <i>PreSignedLogUrl</i>.</p> </li>
    /// <li> <p>FLEET_VALIDATION_LAUNCH_PATH_NOT_FOUND -- Validation of the runtime configuration failed because the executable specified in a launch path does not exist on the instance.</p> </li>
    /// <li> <p>FLEET_VALIDATION_EXECUTABLE_RUNTIME_FAILURE -- Validation of the runtime configuration failed because the executable specified in a launch path failed to run on the fleet instance.</p> </li>
    /// <li> <p>FLEET_VALIDATION_TIMED_OUT -- Validation of the fleet at the end of creation timed out. Try fleet creation again.</p> </li>
    /// <li> <p>FLEET_ACTIVATION_FAILED -- The fleet failed to successfully complete one of the steps in the fleet activation process. This event code indicates that the game build was successfully downloaded to a fleet instance, built, and validated, but was not able to start a server process. For more information, see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html#fleets-creating-debug-creation">Debug Fleet Creation Issues</a>.</p> </li>
    /// <li> <p>FLEET_ACTIVATION_FAILED_NO_INSTANCES -- Fleet creation was not able to obtain any instances based on the input fleet attributes. Try again at a different time or choose a different combination of fleet attributes such as fleet type, instance type, etc.</p> </li>
    /// <li> <p>FLEET_INITIALIZATION_FAILED -- A generic exception occurred during fleet creation. Describe the fleet event message for more details.</p> </li>
    /// </ul>
    /// <p> <b>VPC peering events:</b> </p>
    /// <ul>
    /// <li> <p>FLEET_VPC_PEERING_SUCCEEDED -- A VPC peering connection has been established between the VPC for an GameLift fleet and a VPC in your Amazon Web Services account.</p> </li>
    /// <li> <p>FLEET_VPC_PEERING_FAILED -- A requested VPC peering connection has failed. Event details and status information (see <code>DescribeVpcPeeringConnections</code>) provide additional detail. A common reason for peering failure is that the two VPCs have overlapping CIDR blocks of IPv4 addresses. To resolve this, change the CIDR block for the VPC in your Amazon Web Services account. For more information on VPC peering failures, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/PeeringGuide/invalid-peering-configurations.html">https://docs.aws.amazon.com/AmazonVPC/latest/PeeringGuide/invalid-peering-configurations.html</a> </p> </li>
    /// <li> <p>FLEET_VPC_PEERING_DELETED -- A VPC peering connection has been successfully deleted.</p> </li>
    /// </ul>
    /// <p> <b>Spot instance events:</b> </p>
    /// <ul>
    /// <li> <p> INSTANCE_INTERRUPTED -- A spot instance was interrupted by EC2 with a two-minute notification.</p> </li>
    /// </ul>
    /// <p> <b>Spot process events:</b> </p>
    /// <ul>
    /// <li> <p>SERVER_PROCESS_INVALID_PATH -- The game server executable or script could not be found based on the Fleet runtime configuration. Check that the launch path is correct based on the operating system of the Fleet.</p> </li>
    /// <li> <p>SERVER_PROCESS_SDK_INITIALIZATION_TIMEOUT -- The server process did not call InitSDK() within the time expected. Check your game session log to see why InitSDK() was not called in time.</p> </li>
    /// <li> <p>SERVER_PROCESS_PROCESS_READY_TIMEOUT -- The server process did not call ProcessReady() within the time expected after calling InitSDK(). Check your game session log to see why ProcessReady() was not called in time.</p> </li>
    /// <li> <p>SERVER_PROCESS_CRASHED -- The server process exited without calling ProcessEnding(). Check your game session log to see why ProcessEnding() was not called.</p> </li>
    /// <li> <p>SERVER_PROCESS_TERMINATED_UNHEALTHY -- The server process did not report a valid health check for too long and was therefore terminated by GameLift. Check your game session log to see if the thread became stuck processing a synchronous task for too long.</p> </li>
    /// <li> <p>SERVER_PROCESS_FORCE_TERMINATED -- The server process did not exit cleanly after OnProcessTerminate() was sent within the time expected. Check your game session log to see why termination took longer than expected.</p> </li>
    /// <li> <p>SERVER_PROCESS_PROCESS_EXIT_TIMEOUT -- The server process did not exit cleanly within the time expected after calling ProcessEnding(). Check your game session log to see why termination took longer than expected.</p> </li>
    /// </ul>
    /// <p> <b>Game session events:</b> </p>
    /// <ul>
    /// <li> <p>GAME_SESSION_ACTIVATION_TIMEOUT -- GameSession failed to activate within the expected time. Check your game session log to see why ActivateGameSession() took longer to complete than expected.</p> </li>
    /// </ul>
    /// <p> <b>Other fleet events:</b> </p>
    /// <ul>
    /// <li> <p>FLEET_SCALING_EVENT -- A change was made to the fleet's capacity settings (desired instances, minimum/maximum scaling limits). Event messaging includes the new capacity settings.</p> </li>
    /// <li> <p>FLEET_NEW_GAME_SESSION_PROTECTION_POLICY_UPDATED -- A change was made to the fleet's game session protection policy setting. Event messaging includes both the old and new policy setting. </p> </li>
    /// <li> <p>FLEET_DELETED -- A request to delete a fleet was initiated.</p> </li>
    /// <li> <p> GENERIC_EVENT -- An unspecified event has occurred.</p> </li>
    /// </ul>
    pub fn event_code(&self) -> std::option::Option<&crate::model::EventCode> {
        self.event_code.as_ref()
    }
    /// <p>Additional information related to the event.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>Time stamp indicating when this event occurred. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub fn event_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.event_time.as_ref()
    }
    /// <p>Location of stored logs with additional detail that is related to the event. This is useful for debugging issues. The URL is valid for 15 minutes. You can also access fleet creation logs through the GameLift console.</p>
    pub fn pre_signed_log_url(&self) -> std::option::Option<&str> {
        self.pre_signed_log_url.as_deref()
    }
}
impl std::fmt::Debug for Event {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Event");
        formatter.field("event_id", &self.event_id);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("event_code", &self.event_code);
        formatter.field("message", &self.message);
        formatter.field("event_time", &self.event_time);
        formatter.field("pre_signed_log_url", &self.pre_signed_log_url);
        formatter.finish()
    }
}
/// See [`Event`](crate::model::Event)
pub mod event {
    /// A builder for [`Event`](crate::model::Event)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) event_code: std::option::Option<crate::model::EventCode>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) event_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) pre_signed_log_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for a fleet event.</p>
        pub fn event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a fleet event.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_id = input;
            self
        }
        /// <p>A unique identifier for an event resource, such as a fleet ID.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for an event resource, such as a fleet ID.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of event being logged. </p>
        /// <p> <b>Fleet state transition events:</b> </p>
        /// <ul>
        /// <li> <p>FLEET_CREATED -- A fleet resource was successfully created with a status of <code>NEW</code>. Event messaging includes the fleet ID.</p> </li>
        /// <li> <p>FLEET_STATE_DOWNLOADING -- Fleet status changed from <code>NEW</code> to <code>DOWNLOADING</code>. The compressed build has started downloading to a fleet instance for installation.</p> </li>
        /// <li> <p>FLEET_STATE_VALIDATING -- Fleet status changed from <code>DOWNLOADING</code> to <code>VALIDATING</code>. GameLift has successfully downloaded the build and is now validating the build files.</p> </li>
        /// <li> <p>FLEET_STATE_BUILDING -- Fleet status changed from <code>VALIDATING</code> to <code>BUILDING</code>. GameLift has successfully verified the build files and is now running the installation scripts.</p> </li>
        /// <li> <p>FLEET_STATE_ACTIVATING -- Fleet status changed from <code>BUILDING</code> to <code>ACTIVATING</code>. GameLift is trying to launch an instance and test the connectivity between the build and the GameLift Service via the Server SDK.</p> </li>
        /// <li> <p>FLEET_STATE_ACTIVE -- The fleet's status changed from <code>ACTIVATING</code> to <code>ACTIVE</code>. The fleet is now ready to host game sessions.</p> </li>
        /// <li> <p>FLEET_STATE_ERROR -- The Fleet's status changed to <code>ERROR</code>. Describe the fleet event message for more details.</p> </li>
        /// </ul>
        /// <p> <b>Fleet creation events (ordered by fleet creation activity):</b> </p>
        /// <ul>
        /// <li> <p>FLEET_BINARY_DOWNLOAD_FAILED -- The build failed to download to the fleet instance.</p> </li>
        /// <li> <p>FLEET_CREATION_EXTRACTING_BUILD -- The game server build was successfully downloaded to an instance, and the build files are now being extracted from the uploaded build and saved to an instance. Failure at this stage prevents a fleet from moving to ACTIVE status. Logs for this stage display a list of the files that are extracted and saved on the instance. Access the logs by using the URL in <i>PreSignedLogUrl</i>.</p> </li>
        /// <li> <p>FLEET_CREATION_RUNNING_INSTALLER -- The game server build files were successfully extracted, and the GameLift is now running the build's install script (if one is included). Failure in this stage prevents a fleet from moving to ACTIVE status. Logs for this stage list the installation steps and whether or not the install completed successfully. Access the logs by using the URL in <i>PreSignedLogUrl</i>.</p> </li>
        /// <li> <p>FLEET_CREATION_VALIDATING_RUNTIME_CONFIG -- The build process was successful, and the GameLift is now verifying that the game server launch paths, which are specified in the fleet's runtime configuration, exist. If any listed launch path exists, GameLift tries to launch a game server process and waits for the process to report ready. Failures in this stage prevent a fleet from moving to <code>ACTIVE</code> status. Logs for this stage list the launch paths in the runtime configuration and indicate whether each is found. Access the logs by using the URL in <i>PreSignedLogUrl</i>.</p> </li>
        /// <li> <p>FLEET_VALIDATION_LAUNCH_PATH_NOT_FOUND -- Validation of the runtime configuration failed because the executable specified in a launch path does not exist on the instance.</p> </li>
        /// <li> <p>FLEET_VALIDATION_EXECUTABLE_RUNTIME_FAILURE -- Validation of the runtime configuration failed because the executable specified in a launch path failed to run on the fleet instance.</p> </li>
        /// <li> <p>FLEET_VALIDATION_TIMED_OUT -- Validation of the fleet at the end of creation timed out. Try fleet creation again.</p> </li>
        /// <li> <p>FLEET_ACTIVATION_FAILED -- The fleet failed to successfully complete one of the steps in the fleet activation process. This event code indicates that the game build was successfully downloaded to a fleet instance, built, and validated, but was not able to start a server process. For more information, see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html#fleets-creating-debug-creation">Debug Fleet Creation Issues</a>.</p> </li>
        /// <li> <p>FLEET_ACTIVATION_FAILED_NO_INSTANCES -- Fleet creation was not able to obtain any instances based on the input fleet attributes. Try again at a different time or choose a different combination of fleet attributes such as fleet type, instance type, etc.</p> </li>
        /// <li> <p>FLEET_INITIALIZATION_FAILED -- A generic exception occurred during fleet creation. Describe the fleet event message for more details.</p> </li>
        /// </ul>
        /// <p> <b>VPC peering events:</b> </p>
        /// <ul>
        /// <li> <p>FLEET_VPC_PEERING_SUCCEEDED -- A VPC peering connection has been established between the VPC for an GameLift fleet and a VPC in your Amazon Web Services account.</p> </li>
        /// <li> <p>FLEET_VPC_PEERING_FAILED -- A requested VPC peering connection has failed. Event details and status information (see <code>DescribeVpcPeeringConnections</code>) provide additional detail. A common reason for peering failure is that the two VPCs have overlapping CIDR blocks of IPv4 addresses. To resolve this, change the CIDR block for the VPC in your Amazon Web Services account. For more information on VPC peering failures, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/PeeringGuide/invalid-peering-configurations.html">https://docs.aws.amazon.com/AmazonVPC/latest/PeeringGuide/invalid-peering-configurations.html</a> </p> </li>
        /// <li> <p>FLEET_VPC_PEERING_DELETED -- A VPC peering connection has been successfully deleted.</p> </li>
        /// </ul>
        /// <p> <b>Spot instance events:</b> </p>
        /// <ul>
        /// <li> <p> INSTANCE_INTERRUPTED -- A spot instance was interrupted by EC2 with a two-minute notification.</p> </li>
        /// </ul>
        /// <p> <b>Spot process events:</b> </p>
        /// <ul>
        /// <li> <p>SERVER_PROCESS_INVALID_PATH -- The game server executable or script could not be found based on the Fleet runtime configuration. Check that the launch path is correct based on the operating system of the Fleet.</p> </li>
        /// <li> <p>SERVER_PROCESS_SDK_INITIALIZATION_TIMEOUT -- The server process did not call InitSDK() within the time expected. Check your game session log to see why InitSDK() was not called in time.</p> </li>
        /// <li> <p>SERVER_PROCESS_PROCESS_READY_TIMEOUT -- The server process did not call ProcessReady() within the time expected after calling InitSDK(). Check your game session log to see why ProcessReady() was not called in time.</p> </li>
        /// <li> <p>SERVER_PROCESS_CRASHED -- The server process exited without calling ProcessEnding(). Check your game session log to see why ProcessEnding() was not called.</p> </li>
        /// <li> <p>SERVER_PROCESS_TERMINATED_UNHEALTHY -- The server process did not report a valid health check for too long and was therefore terminated by GameLift. Check your game session log to see if the thread became stuck processing a synchronous task for too long.</p> </li>
        /// <li> <p>SERVER_PROCESS_FORCE_TERMINATED -- The server process did not exit cleanly after OnProcessTerminate() was sent within the time expected. Check your game session log to see why termination took longer than expected.</p> </li>
        /// <li> <p>SERVER_PROCESS_PROCESS_EXIT_TIMEOUT -- The server process did not exit cleanly within the time expected after calling ProcessEnding(). Check your game session log to see why termination took longer than expected.</p> </li>
        /// </ul>
        /// <p> <b>Game session events:</b> </p>
        /// <ul>
        /// <li> <p>GAME_SESSION_ACTIVATION_TIMEOUT -- GameSession failed to activate within the expected time. Check your game session log to see why ActivateGameSession() took longer to complete than expected.</p> </li>
        /// </ul>
        /// <p> <b>Other fleet events:</b> </p>
        /// <ul>
        /// <li> <p>FLEET_SCALING_EVENT -- A change was made to the fleet's capacity settings (desired instances, minimum/maximum scaling limits). Event messaging includes the new capacity settings.</p> </li>
        /// <li> <p>FLEET_NEW_GAME_SESSION_PROTECTION_POLICY_UPDATED -- A change was made to the fleet's game session protection policy setting. Event messaging includes both the old and new policy setting. </p> </li>
        /// <li> <p>FLEET_DELETED -- A request to delete a fleet was initiated.</p> </li>
        /// <li> <p> GENERIC_EVENT -- An unspecified event has occurred.</p> </li>
        /// </ul>
        pub fn event_code(mut self, input: crate::model::EventCode) -> Self {
            self.event_code = Some(input);
            self
        }
        /// <p>The type of event being logged. </p>
        /// <p> <b>Fleet state transition events:</b> </p>
        /// <ul>
        /// <li> <p>FLEET_CREATED -- A fleet resource was successfully created with a status of <code>NEW</code>. Event messaging includes the fleet ID.</p> </li>
        /// <li> <p>FLEET_STATE_DOWNLOADING -- Fleet status changed from <code>NEW</code> to <code>DOWNLOADING</code>. The compressed build has started downloading to a fleet instance for installation.</p> </li>
        /// <li> <p>FLEET_STATE_VALIDATING -- Fleet status changed from <code>DOWNLOADING</code> to <code>VALIDATING</code>. GameLift has successfully downloaded the build and is now validating the build files.</p> </li>
        /// <li> <p>FLEET_STATE_BUILDING -- Fleet status changed from <code>VALIDATING</code> to <code>BUILDING</code>. GameLift has successfully verified the build files and is now running the installation scripts.</p> </li>
        /// <li> <p>FLEET_STATE_ACTIVATING -- Fleet status changed from <code>BUILDING</code> to <code>ACTIVATING</code>. GameLift is trying to launch an instance and test the connectivity between the build and the GameLift Service via the Server SDK.</p> </li>
        /// <li> <p>FLEET_STATE_ACTIVE -- The fleet's status changed from <code>ACTIVATING</code> to <code>ACTIVE</code>. The fleet is now ready to host game sessions.</p> </li>
        /// <li> <p>FLEET_STATE_ERROR -- The Fleet's status changed to <code>ERROR</code>. Describe the fleet event message for more details.</p> </li>
        /// </ul>
        /// <p> <b>Fleet creation events (ordered by fleet creation activity):</b> </p>
        /// <ul>
        /// <li> <p>FLEET_BINARY_DOWNLOAD_FAILED -- The build failed to download to the fleet instance.</p> </li>
        /// <li> <p>FLEET_CREATION_EXTRACTING_BUILD -- The game server build was successfully downloaded to an instance, and the build files are now being extracted from the uploaded build and saved to an instance. Failure at this stage prevents a fleet from moving to ACTIVE status. Logs for this stage display a list of the files that are extracted and saved on the instance. Access the logs by using the URL in <i>PreSignedLogUrl</i>.</p> </li>
        /// <li> <p>FLEET_CREATION_RUNNING_INSTALLER -- The game server build files were successfully extracted, and the GameLift is now running the build's install script (if one is included). Failure in this stage prevents a fleet from moving to ACTIVE status. Logs for this stage list the installation steps and whether or not the install completed successfully. Access the logs by using the URL in <i>PreSignedLogUrl</i>.</p> </li>
        /// <li> <p>FLEET_CREATION_VALIDATING_RUNTIME_CONFIG -- The build process was successful, and the GameLift is now verifying that the game server launch paths, which are specified in the fleet's runtime configuration, exist. If any listed launch path exists, GameLift tries to launch a game server process and waits for the process to report ready. Failures in this stage prevent a fleet from moving to <code>ACTIVE</code> status. Logs for this stage list the launch paths in the runtime configuration and indicate whether each is found. Access the logs by using the URL in <i>PreSignedLogUrl</i>.</p> </li>
        /// <li> <p>FLEET_VALIDATION_LAUNCH_PATH_NOT_FOUND -- Validation of the runtime configuration failed because the executable specified in a launch path does not exist on the instance.</p> </li>
        /// <li> <p>FLEET_VALIDATION_EXECUTABLE_RUNTIME_FAILURE -- Validation of the runtime configuration failed because the executable specified in a launch path failed to run on the fleet instance.</p> </li>
        /// <li> <p>FLEET_VALIDATION_TIMED_OUT -- Validation of the fleet at the end of creation timed out. Try fleet creation again.</p> </li>
        /// <li> <p>FLEET_ACTIVATION_FAILED -- The fleet failed to successfully complete one of the steps in the fleet activation process. This event code indicates that the game build was successfully downloaded to a fleet instance, built, and validated, but was not able to start a server process. For more information, see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html#fleets-creating-debug-creation">Debug Fleet Creation Issues</a>.</p> </li>
        /// <li> <p>FLEET_ACTIVATION_FAILED_NO_INSTANCES -- Fleet creation was not able to obtain any instances based on the input fleet attributes. Try again at a different time or choose a different combination of fleet attributes such as fleet type, instance type, etc.</p> </li>
        /// <li> <p>FLEET_INITIALIZATION_FAILED -- A generic exception occurred during fleet creation. Describe the fleet event message for more details.</p> </li>
        /// </ul>
        /// <p> <b>VPC peering events:</b> </p>
        /// <ul>
        /// <li> <p>FLEET_VPC_PEERING_SUCCEEDED -- A VPC peering connection has been established between the VPC for an GameLift fleet and a VPC in your Amazon Web Services account.</p> </li>
        /// <li> <p>FLEET_VPC_PEERING_FAILED -- A requested VPC peering connection has failed. Event details and status information (see <code>DescribeVpcPeeringConnections</code>) provide additional detail. A common reason for peering failure is that the two VPCs have overlapping CIDR blocks of IPv4 addresses. To resolve this, change the CIDR block for the VPC in your Amazon Web Services account. For more information on VPC peering failures, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/PeeringGuide/invalid-peering-configurations.html">https://docs.aws.amazon.com/AmazonVPC/latest/PeeringGuide/invalid-peering-configurations.html</a> </p> </li>
        /// <li> <p>FLEET_VPC_PEERING_DELETED -- A VPC peering connection has been successfully deleted.</p> </li>
        /// </ul>
        /// <p> <b>Spot instance events:</b> </p>
        /// <ul>
        /// <li> <p> INSTANCE_INTERRUPTED -- A spot instance was interrupted by EC2 with a two-minute notification.</p> </li>
        /// </ul>
        /// <p> <b>Spot process events:</b> </p>
        /// <ul>
        /// <li> <p>SERVER_PROCESS_INVALID_PATH -- The game server executable or script could not be found based on the Fleet runtime configuration. Check that the launch path is correct based on the operating system of the Fleet.</p> </li>
        /// <li> <p>SERVER_PROCESS_SDK_INITIALIZATION_TIMEOUT -- The server process did not call InitSDK() within the time expected. Check your game session log to see why InitSDK() was not called in time.</p> </li>
        /// <li> <p>SERVER_PROCESS_PROCESS_READY_TIMEOUT -- The server process did not call ProcessReady() within the time expected after calling InitSDK(). Check your game session log to see why ProcessReady() was not called in time.</p> </li>
        /// <li> <p>SERVER_PROCESS_CRASHED -- The server process exited without calling ProcessEnding(). Check your game session log to see why ProcessEnding() was not called.</p> </li>
        /// <li> <p>SERVER_PROCESS_TERMINATED_UNHEALTHY -- The server process did not report a valid health check for too long and was therefore terminated by GameLift. Check your game session log to see if the thread became stuck processing a synchronous task for too long.</p> </li>
        /// <li> <p>SERVER_PROCESS_FORCE_TERMINATED -- The server process did not exit cleanly after OnProcessTerminate() was sent within the time expected. Check your game session log to see why termination took longer than expected.</p> </li>
        /// <li> <p>SERVER_PROCESS_PROCESS_EXIT_TIMEOUT -- The server process did not exit cleanly within the time expected after calling ProcessEnding(). Check your game session log to see why termination took longer than expected.</p> </li>
        /// </ul>
        /// <p> <b>Game session events:</b> </p>
        /// <ul>
        /// <li> <p>GAME_SESSION_ACTIVATION_TIMEOUT -- GameSession failed to activate within the expected time. Check your game session log to see why ActivateGameSession() took longer to complete than expected.</p> </li>
        /// </ul>
        /// <p> <b>Other fleet events:</b> </p>
        /// <ul>
        /// <li> <p>FLEET_SCALING_EVENT -- A change was made to the fleet's capacity settings (desired instances, minimum/maximum scaling limits). Event messaging includes the new capacity settings.</p> </li>
        /// <li> <p>FLEET_NEW_GAME_SESSION_PROTECTION_POLICY_UPDATED -- A change was made to the fleet's game session protection policy setting. Event messaging includes both the old and new policy setting. </p> </li>
        /// <li> <p>FLEET_DELETED -- A request to delete a fleet was initiated.</p> </li>
        /// <li> <p> GENERIC_EVENT -- An unspecified event has occurred.</p> </li>
        /// </ul>
        pub fn set_event_code(
            mut self,
            input: std::option::Option<crate::model::EventCode>,
        ) -> Self {
            self.event_code = input;
            self
        }
        /// <p>Additional information related to the event.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Additional information related to the event.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Time stamp indicating when this event occurred. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn event_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.event_time = Some(input);
            self
        }
        /// <p>Time stamp indicating when this event occurred. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn set_event_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.event_time = input;
            self
        }
        /// <p>Location of stored logs with additional detail that is related to the event. This is useful for debugging issues. The URL is valid for 15 minutes. You can also access fleet creation logs through the GameLift console.</p>
        pub fn pre_signed_log_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.pre_signed_log_url = Some(input.into());
            self
        }
        /// <p>Location of stored logs with additional detail that is related to the event. This is useful for debugging issues. The URL is valid for 15 minutes. You can also access fleet creation logs through the GameLift console.</p>
        pub fn set_pre_signed_log_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pre_signed_log_url = input;
            self
        }
        /// Consumes the builder and constructs a [`Event`](crate::model::Event)
        pub fn build(self) -> crate::model::Event {
            crate::model::Event {
                event_id: self.event_id,
                resource_id: self.resource_id,
                event_code: self.event_code,
                message: self.message,
                event_time: self.event_time,
                pre_signed_log_url: self.pre_signed_log_url,
            }
        }
    }
}
impl Event {
    /// Creates a new builder-style object to manufacture [`Event`](crate::model::Event)
    pub fn builder() -> crate::model::event::Builder {
        crate::model::event::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventCode {
    #[allow(missing_docs)] // documentation missing in model
    FleetActivationFailed,
    #[allow(missing_docs)] // documentation missing in model
    FleetActivationFailedNoInstances,
    #[allow(missing_docs)] // documentation missing in model
    FleetBinaryDownloadFailed,
    #[allow(missing_docs)] // documentation missing in model
    FleetCreated,
    #[allow(missing_docs)] // documentation missing in model
    FleetCreationExtractingBuild,
    #[allow(missing_docs)] // documentation missing in model
    FleetCreationRunningInstaller,
    #[allow(missing_docs)] // documentation missing in model
    FleetCreationValidatingRuntimeConfig,
    #[allow(missing_docs)] // documentation missing in model
    FleetDeleted,
    #[allow(missing_docs)] // documentation missing in model
    FleetInitializationFailed,
    #[allow(missing_docs)] // documentation missing in model
    FleetNewGameSessionProtectionPolicyUpdated,
    #[allow(missing_docs)] // documentation missing in model
    FleetScalingEvent,
    #[allow(missing_docs)] // documentation missing in model
    FleetStateActivating,
    #[allow(missing_docs)] // documentation missing in model
    FleetStateActive,
    #[allow(missing_docs)] // documentation missing in model
    FleetStateBuilding,
    #[allow(missing_docs)] // documentation missing in model
    FleetStateDownloading,
    #[allow(missing_docs)] // documentation missing in model
    FleetStateError,
    #[allow(missing_docs)] // documentation missing in model
    FleetStateValidating,
    #[allow(missing_docs)] // documentation missing in model
    FleetValidationExecutableRuntimeFailure,
    #[allow(missing_docs)] // documentation missing in model
    FleetValidationLaunchPathNotFound,
    #[allow(missing_docs)] // documentation missing in model
    FleetValidationTimedOut,
    #[allow(missing_docs)] // documentation missing in model
    FleetVpcPeeringDeleted,
    #[allow(missing_docs)] // documentation missing in model
    FleetVpcPeeringFailed,
    #[allow(missing_docs)] // documentation missing in model
    FleetVpcPeeringSucceeded,
    #[allow(missing_docs)] // documentation missing in model
    GameSessionActivationTimeout,
    #[allow(missing_docs)] // documentation missing in model
    GenericEvent,
    #[allow(missing_docs)] // documentation missing in model
    InstanceInterrupted,
    #[allow(missing_docs)] // documentation missing in model
    ServerProcessCrashed,
    #[allow(missing_docs)] // documentation missing in model
    ServerProcessForceTerminated,
    #[allow(missing_docs)] // documentation missing in model
    ServerProcessInvalidPath,
    #[allow(missing_docs)] // documentation missing in model
    ServerProcessProcessExitTimeout,
    #[allow(missing_docs)] // documentation missing in model
    ServerProcessProcessReadyTimeout,
    #[allow(missing_docs)] // documentation missing in model
    ServerProcessSdkInitializationTimeout,
    #[allow(missing_docs)] // documentation missing in model
    ServerProcessTerminatedUnhealthy,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventCode {
    fn from(s: &str) -> Self {
        match s {
            "FLEET_ACTIVATION_FAILED" => EventCode::FleetActivationFailed,
            "FLEET_ACTIVATION_FAILED_NO_INSTANCES" => EventCode::FleetActivationFailedNoInstances,
            "FLEET_BINARY_DOWNLOAD_FAILED" => EventCode::FleetBinaryDownloadFailed,
            "FLEET_CREATED" => EventCode::FleetCreated,
            "FLEET_CREATION_EXTRACTING_BUILD" => EventCode::FleetCreationExtractingBuild,
            "FLEET_CREATION_RUNNING_INSTALLER" => EventCode::FleetCreationRunningInstaller,
            "FLEET_CREATION_VALIDATING_RUNTIME_CONFIG" => {
                EventCode::FleetCreationValidatingRuntimeConfig
            }
            "FLEET_DELETED" => EventCode::FleetDeleted,
            "FLEET_INITIALIZATION_FAILED" => EventCode::FleetInitializationFailed,
            "FLEET_NEW_GAME_SESSION_PROTECTION_POLICY_UPDATED" => {
                EventCode::FleetNewGameSessionProtectionPolicyUpdated
            }
            "FLEET_SCALING_EVENT" => EventCode::FleetScalingEvent,
            "FLEET_STATE_ACTIVATING" => EventCode::FleetStateActivating,
            "FLEET_STATE_ACTIVE" => EventCode::FleetStateActive,
            "FLEET_STATE_BUILDING" => EventCode::FleetStateBuilding,
            "FLEET_STATE_DOWNLOADING" => EventCode::FleetStateDownloading,
            "FLEET_STATE_ERROR" => EventCode::FleetStateError,
            "FLEET_STATE_VALIDATING" => EventCode::FleetStateValidating,
            "FLEET_VALIDATION_EXECUTABLE_RUNTIME_FAILURE" => {
                EventCode::FleetValidationExecutableRuntimeFailure
            }
            "FLEET_VALIDATION_LAUNCH_PATH_NOT_FOUND" => {
                EventCode::FleetValidationLaunchPathNotFound
            }
            "FLEET_VALIDATION_TIMED_OUT" => EventCode::FleetValidationTimedOut,
            "FLEET_VPC_PEERING_DELETED" => EventCode::FleetVpcPeeringDeleted,
            "FLEET_VPC_PEERING_FAILED" => EventCode::FleetVpcPeeringFailed,
            "FLEET_VPC_PEERING_SUCCEEDED" => EventCode::FleetVpcPeeringSucceeded,
            "GAME_SESSION_ACTIVATION_TIMEOUT" => EventCode::GameSessionActivationTimeout,
            "GENERIC_EVENT" => EventCode::GenericEvent,
            "INSTANCE_INTERRUPTED" => EventCode::InstanceInterrupted,
            "SERVER_PROCESS_CRASHED" => EventCode::ServerProcessCrashed,
            "SERVER_PROCESS_FORCE_TERMINATED" => EventCode::ServerProcessForceTerminated,
            "SERVER_PROCESS_INVALID_PATH" => EventCode::ServerProcessInvalidPath,
            "SERVER_PROCESS_PROCESS_EXIT_TIMEOUT" => EventCode::ServerProcessProcessExitTimeout,
            "SERVER_PROCESS_PROCESS_READY_TIMEOUT" => EventCode::ServerProcessProcessReadyTimeout,
            "SERVER_PROCESS_SDK_INITIALIZATION_TIMEOUT" => {
                EventCode::ServerProcessSdkInitializationTimeout
            }
            "SERVER_PROCESS_TERMINATED_UNHEALTHY" => EventCode::ServerProcessTerminatedUnhealthy,
            other => EventCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventCode::from(s))
    }
}
impl EventCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventCode::FleetActivationFailed => "FLEET_ACTIVATION_FAILED",
            EventCode::FleetActivationFailedNoInstances => "FLEET_ACTIVATION_FAILED_NO_INSTANCES",
            EventCode::FleetBinaryDownloadFailed => "FLEET_BINARY_DOWNLOAD_FAILED",
            EventCode::FleetCreated => "FLEET_CREATED",
            EventCode::FleetCreationExtractingBuild => "FLEET_CREATION_EXTRACTING_BUILD",
            EventCode::FleetCreationRunningInstaller => "FLEET_CREATION_RUNNING_INSTALLER",
            EventCode::FleetCreationValidatingRuntimeConfig => {
                "FLEET_CREATION_VALIDATING_RUNTIME_CONFIG"
            }
            EventCode::FleetDeleted => "FLEET_DELETED",
            EventCode::FleetInitializationFailed => "FLEET_INITIALIZATION_FAILED",
            EventCode::FleetNewGameSessionProtectionPolicyUpdated => {
                "FLEET_NEW_GAME_SESSION_PROTECTION_POLICY_UPDATED"
            }
            EventCode::FleetScalingEvent => "FLEET_SCALING_EVENT",
            EventCode::FleetStateActivating => "FLEET_STATE_ACTIVATING",
            EventCode::FleetStateActive => "FLEET_STATE_ACTIVE",
            EventCode::FleetStateBuilding => "FLEET_STATE_BUILDING",
            EventCode::FleetStateDownloading => "FLEET_STATE_DOWNLOADING",
            EventCode::FleetStateError => "FLEET_STATE_ERROR",
            EventCode::FleetStateValidating => "FLEET_STATE_VALIDATING",
            EventCode::FleetValidationExecutableRuntimeFailure => {
                "FLEET_VALIDATION_EXECUTABLE_RUNTIME_FAILURE"
            }
            EventCode::FleetValidationLaunchPathNotFound => {
                "FLEET_VALIDATION_LAUNCH_PATH_NOT_FOUND"
            }
            EventCode::FleetValidationTimedOut => "FLEET_VALIDATION_TIMED_OUT",
            EventCode::FleetVpcPeeringDeleted => "FLEET_VPC_PEERING_DELETED",
            EventCode::FleetVpcPeeringFailed => "FLEET_VPC_PEERING_FAILED",
            EventCode::FleetVpcPeeringSucceeded => "FLEET_VPC_PEERING_SUCCEEDED",
            EventCode::GameSessionActivationTimeout => "GAME_SESSION_ACTIVATION_TIMEOUT",
            EventCode::GenericEvent => "GENERIC_EVENT",
            EventCode::InstanceInterrupted => "INSTANCE_INTERRUPTED",
            EventCode::ServerProcessCrashed => "SERVER_PROCESS_CRASHED",
            EventCode::ServerProcessForceTerminated => "SERVER_PROCESS_FORCE_TERMINATED",
            EventCode::ServerProcessInvalidPath => "SERVER_PROCESS_INVALID_PATH",
            EventCode::ServerProcessProcessExitTimeout => "SERVER_PROCESS_PROCESS_EXIT_TIMEOUT",
            EventCode::ServerProcessProcessReadyTimeout => "SERVER_PROCESS_PROCESS_READY_TIMEOUT",
            EventCode::ServerProcessSdkInitializationTimeout => {
                "SERVER_PROCESS_SDK_INITIALIZATION_TIMEOUT"
            }
            EventCode::ServerProcessTerminatedUnhealthy => "SERVER_PROCESS_TERMINATED_UNHEALTHY",
            EventCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "FLEET_ACTIVATION_FAILED",
            "FLEET_ACTIVATION_FAILED_NO_INSTANCES",
            "FLEET_BINARY_DOWNLOAD_FAILED",
            "FLEET_CREATED",
            "FLEET_CREATION_EXTRACTING_BUILD",
            "FLEET_CREATION_RUNNING_INSTALLER",
            "FLEET_CREATION_VALIDATING_RUNTIME_CONFIG",
            "FLEET_DELETED",
            "FLEET_INITIALIZATION_FAILED",
            "FLEET_NEW_GAME_SESSION_PROTECTION_POLICY_UPDATED",
            "FLEET_SCALING_EVENT",
            "FLEET_STATE_ACTIVATING",
            "FLEET_STATE_ACTIVE",
            "FLEET_STATE_BUILDING",
            "FLEET_STATE_DOWNLOADING",
            "FLEET_STATE_ERROR",
            "FLEET_STATE_VALIDATING",
            "FLEET_VALIDATION_EXECUTABLE_RUNTIME_FAILURE",
            "FLEET_VALIDATION_LAUNCH_PATH_NOT_FOUND",
            "FLEET_VALIDATION_TIMED_OUT",
            "FLEET_VPC_PEERING_DELETED",
            "FLEET_VPC_PEERING_FAILED",
            "FLEET_VPC_PEERING_SUCCEEDED",
            "GAME_SESSION_ACTIVATION_TIMEOUT",
            "GENERIC_EVENT",
            "INSTANCE_INTERRUPTED",
            "SERVER_PROCESS_CRASHED",
            "SERVER_PROCESS_FORCE_TERMINATED",
            "SERVER_PROCESS_INVALID_PATH",
            "SERVER_PROCESS_PROCESS_EXIT_TIMEOUT",
            "SERVER_PROCESS_PROCESS_READY_TIMEOUT",
            "SERVER_PROCESS_SDK_INITIALIZATION_TIMEOUT",
            "SERVER_PROCESS_TERMINATED_UNHEALTHY",
        ]
    }
}
impl AsRef<str> for EventCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a GameLift fleet of game hosting resources.</p>
/// <p> <b>Related actions</b> </p>
/// <p> <code>CreateFleet</code> | <code>DescribeFleetAttributes</code> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FleetAttributes {
    /// <p>A unique identifier for the fleet.</p>
    pub fleet_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
    /// </region></code>. In a GameLift fleet ARN, the resource ID matches the <code>FleetId</code> value.</p>
    pub fleet_arn: std::option::Option<std::string::String>,
    /// <p>The kind of instances, On-Demand or Spot, that this fleet uses.</p>
    pub fleet_type: std::option::Option<crate::model::FleetType>,
    /// <p>The Amazon EC2 instance type that determines the computing resources of each instance in the fleet. Instance type defines the CPU, memory, storage, and networking capacity. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud Instance Types</a> for detailed descriptions.</p>
    pub instance_type: std::option::Option<crate::model::Ec2InstanceType>,
    /// <p>A human-readable description of the fleet.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A descriptive label that is associated with a fleet. Fleet names do not need to be unique.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A time stamp indicating when this data object was terminated. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub termination_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Current status of the fleet. Possible fleet statuses include the following:</p>
    /// <ul>
    /// <li> <p> <b>NEW</b> -- A new fleet has been defined and desired instances is set to 1. </p> </li>
    /// <li> <p> <b>DOWNLOADING/VALIDATING/BUILDING/ACTIVATING</b> -- GameLift is setting up the new fleet, creating new instances with the game build or Realtime script and starting server processes.</p> </li>
    /// <li> <p> <b>ACTIVE</b> -- Hosts can now accept game sessions.</p> </li>
    /// <li> <p> <b>ERROR</b> -- An error occurred when downloading, validating, building, or activating the fleet.</p> </li>
    /// <li> <p> <b>DELETING</b> -- Hosts are responding to a delete fleet request.</p> </li>
    /// <li> <p> <b>TERMINATED</b> -- The fleet no longer exists.</p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::FleetStatus>,
    /// <p>A unique identifier for the build resource that is deployed on instances in this fleet.</p>
    pub build_id: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift build resource that is deployed on instances in this fleet. In a GameLift build ARN, the resource ID matches the <code>BuildId</code> value.</p>
    pub build_arn: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the Realtime script resource that is deployed on instances in this fleet.</p>
    pub script_id: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift script resource that is deployed on instances in this fleet. In a GameLift script ARN, the resource ID matches the <code>ScriptId</code> value.</p>
    pub script_arn: std::option::Option<std::string::String>,
    /// <p> <b>This parameter is no longer used.</b> Server launch paths are now defined using the fleet's <code>RuntimeConfiguration</code> parameter. Requests that use this parameter instead continue to be valid.</p>
    pub server_launch_path: std::option::Option<std::string::String>,
    /// <p> <b>This parameter is no longer used.</b> Server launch parameters are now defined using the fleet's <code>RuntimeConfiguration</code> parameter. Requests that use this parameter instead continue to be valid.</p>
    pub server_launch_parameters: std::option::Option<std::string::String>,
    /// <p> <b>This parameter is no longer used.</b> Game session log paths are now defined using the GameLift server API <code>ProcessReady()</code> <code>logParameters</code>. See more information in the <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process">Server API Reference</a>. </p>
    pub log_paths: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The type of game session protection to set on all new instances that are started in the fleet.</p>
    /// <ul>
    /// <li> <p> <b>NoProtection</b> -- The game session can be terminated during a scale-down event.</p> </li>
    /// <li> <p> <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during a scale-down event.</p> </li>
    /// </ul>
    pub new_game_session_protection_policy: std::option::Option<crate::model::ProtectionPolicy>,
    /// <p>The operating system of the fleet's computing resources. A fleet's operating system is determined by the OS of the build or script that is deployed on this fleet.</p>
    pub operating_system: std::option::Option<crate::model::OperatingSystem>,
    /// <p>The fleet policy that limits the number of game sessions an individual player can create over a span of time.</p>
    pub resource_creation_limit_policy:
        std::option::Option<crate::model::ResourceCreationLimitPolicy>,
    /// <p>Name of a metric group that metrics for this fleet are added to. In Amazon CloudWatch, you can view aggregated metrics for fleets that are in a metric group. A fleet can be included in only one metric group at a time.</p>
    pub metric_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of fleet activity that has been suspended using <code>StopFleetActions</code>. This includes fleet auto-scaling.</p>
    pub stopped_actions: std::option::Option<std::vec::Vec<crate::model::FleetAction>>,
    /// <p>A unique identifier for an IAM role that manages access to your Amazon Web Services services. With an instance role ARN set, any application that runs on an instance in this fleet can assume the role, including install scripts, server processes, and daemons (background processes). Create a role or look up a role's ARN by using the <a href="https://console.aws.amazon.com/iam/">IAM dashboard</a> in the Amazon Web Services Management Console. Learn more about using on-box credentials for your game servers at <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html"> Access external resources from a game server</a>.</p>
    pub instance_role_arn: std::option::Option<std::string::String>,
    /// <p>Indicates whether a TLS/SSL certificate was generated for the fleet. </p>
    pub certificate_configuration: std::option::Option<crate::model::CertificateConfiguration>,
}
impl FleetAttributes {
    /// <p>A unique identifier for the fleet.</p>
    pub fn fleet_id(&self) -> std::option::Option<&str> {
        self.fleet_id.as_deref()
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
    /// <region>
    /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
    /// </region></code>. In a GameLift fleet ARN, the resource ID matches the <code>FleetId</code> value.</p>
    pub fn fleet_arn(&self) -> std::option::Option<&str> {
        self.fleet_arn.as_deref()
    }
    /// <p>The kind of instances, On-Demand or Spot, that this fleet uses.</p>
    pub fn fleet_type(&self) -> std::option::Option<&crate::model::FleetType> {
        self.fleet_type.as_ref()
    }
    /// <p>The Amazon EC2 instance type that determines the computing resources of each instance in the fleet. Instance type defines the CPU, memory, storage, and networking capacity. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud Instance Types</a> for detailed descriptions.</p>
    pub fn instance_type(&self) -> std::option::Option<&crate::model::Ec2InstanceType> {
        self.instance_type.as_ref()
    }
    /// <p>A human-readable description of the fleet.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A descriptive label that is associated with a fleet. Fleet names do not need to be unique.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>A time stamp indicating when this data object was terminated. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
    pub fn termination_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.termination_time.as_ref()
    }
    /// <p>Current status of the fleet. Possible fleet statuses include the following:</p>
    /// <ul>
    /// <li> <p> <b>NEW</b> -- A new fleet has been defined and desired instances is set to 1. </p> </li>
    /// <li> <p> <b>DOWNLOADING/VALIDATING/BUILDING/ACTIVATING</b> -- GameLift is setting up the new fleet, creating new instances with the game build or Realtime script and starting server processes.</p> </li>
    /// <li> <p> <b>ACTIVE</b> -- Hosts can now accept game sessions.</p> </li>
    /// <li> <p> <b>ERROR</b> -- An error occurred when downloading, validating, building, or activating the fleet.</p> </li>
    /// <li> <p> <b>DELETING</b> -- Hosts are responding to a delete fleet request.</p> </li>
    /// <li> <p> <b>TERMINATED</b> -- The fleet no longer exists.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::FleetStatus> {
        self.status.as_ref()
    }
    /// <p>A unique identifier for the build resource that is deployed on instances in this fleet.</p>
    pub fn build_id(&self) -> std::option::Option<&str> {
        self.build_id.as_deref()
    }
    /// <p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift build resource that is deployed on instances in this fleet. In a GameLift build ARN, the resource ID matches the <code>BuildId</code> value.</p>
    pub fn build_arn(&self) -> std::option::Option<&str> {
        self.build_arn.as_deref()
    }
    /// <p>A unique identifier for the Realtime script resource that is deployed on instances in this fleet.</p>
    pub fn script_id(&self) -> std::option::Option<&str> {
        self.script_id.as_deref()
    }
    /// <p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift script resource that is deployed on instances in this fleet. In a GameLift script ARN, the resource ID matches the <code>ScriptId</code> value.</p>
    pub fn script_arn(&self) -> std::option::Option<&str> {
        self.script_arn.as_deref()
    }
    /// <p> <b>This parameter is no longer used.</b> Server launch paths are now defined using the fleet's <code>RuntimeConfiguration</code> parameter. Requests that use this parameter instead continue to be valid.</p>
    pub fn server_launch_path(&self) -> std::option::Option<&str> {
        self.server_launch_path.as_deref()
    }
    /// <p> <b>This parameter is no longer used.</b> Server launch parameters are now defined using the fleet's <code>RuntimeConfiguration</code> parameter. Requests that use this parameter instead continue to be valid.</p>
    pub fn server_launch_parameters(&self) -> std::option::Option<&str> {
        self.server_launch_parameters.as_deref()
    }
    /// <p> <b>This parameter is no longer used.</b> Game session log paths are now defined using the GameLift server API <code>ProcessReady()</code> <code>logParameters</code>. See more information in the <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process">Server API Reference</a>. </p>
    pub fn log_paths(&self) -> std::option::Option<&[std::string::String]> {
        self.log_paths.as_deref()
    }
    /// <p>The type of game session protection to set on all new instances that are started in the fleet.</p>
    /// <ul>
    /// <li> <p> <b>NoProtection</b> -- The game session can be terminated during a scale-down event.</p> </li>
    /// <li> <p> <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during a scale-down event.</p> </li>
    /// </ul>
    pub fn new_game_session_protection_policy(
        &self,
    ) -> std::option::Option<&crate::model::ProtectionPolicy> {
        self.new_game_session_protection_policy.as_ref()
    }
    /// <p>The operating system of the fleet's computing resources. A fleet's operating system is determined by the OS of the build or script that is deployed on this fleet.</p>
    pub fn operating_system(&self) -> std::option::Option<&crate::model::OperatingSystem> {
        self.operating_system.as_ref()
    }
    /// <p>The fleet policy that limits the number of game sessions an individual player can create over a span of time.</p>
    pub fn resource_creation_limit_policy(
        &self,
    ) -> std::option::Option<&crate::model::ResourceCreationLimitPolicy> {
        self.resource_creation_limit_policy.as_ref()
    }
    /// <p>Name of a metric group that metrics for this fleet are added to. In Amazon CloudWatch, you can view aggregated metrics for fleets that are in a metric group. A fleet can be included in only one metric group at a time.</p>
    pub fn metric_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.metric_groups.as_deref()
    }
    /// <p>A list of fleet activity that has been suspended using <code>StopFleetActions</code>. This includes fleet auto-scaling.</p>
    pub fn stopped_actions(&self) -> std::option::Option<&[crate::model::FleetAction]> {
        self.stopped_actions.as_deref()
    }
    /// <p>A unique identifier for an IAM role that manages access to your Amazon Web Services services. With an instance role ARN set, any application that runs on an instance in this fleet can assume the role, including install scripts, server processes, and daemons (background processes). Create a role or look up a role's ARN by using the <a href="https://console.aws.amazon.com/iam/">IAM dashboard</a> in the Amazon Web Services Management Console. Learn more about using on-box credentials for your game servers at <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html"> Access external resources from a game server</a>.</p>
    pub fn instance_role_arn(&self) -> std::option::Option<&str> {
        self.instance_role_arn.as_deref()
    }
    /// <p>Indicates whether a TLS/SSL certificate was generated for the fleet. </p>
    pub fn certificate_configuration(
        &self,
    ) -> std::option::Option<&crate::model::CertificateConfiguration> {
        self.certificate_configuration.as_ref()
    }
}
impl std::fmt::Debug for FleetAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FleetAttributes");
        formatter.field("fleet_id", &self.fleet_id);
        formatter.field("fleet_arn", &self.fleet_arn);
        formatter.field("fleet_type", &self.fleet_type);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("description", &self.description);
        formatter.field("name", &self.name);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("termination_time", &self.termination_time);
        formatter.field("status", &self.status);
        formatter.field("build_id", &self.build_id);
        formatter.field("build_arn", &self.build_arn);
        formatter.field("script_id", &self.script_id);
        formatter.field("script_arn", &self.script_arn);
        formatter.field("server_launch_path", &self.server_launch_path);
        formatter.field("server_launch_parameters", &self.server_launch_parameters);
        formatter.field("log_paths", &self.log_paths);
        formatter.field(
            "new_game_session_protection_policy",
            &self.new_game_session_protection_policy,
        );
        formatter.field("operating_system", &self.operating_system);
        formatter.field(
            "resource_creation_limit_policy",
            &self.resource_creation_limit_policy,
        );
        formatter.field("metric_groups", &self.metric_groups);
        formatter.field("stopped_actions", &self.stopped_actions);
        formatter.field("instance_role_arn", &self.instance_role_arn);
        formatter.field("certificate_configuration", &self.certificate_configuration);
        formatter.finish()
    }
}
/// See [`FleetAttributes`](crate::model::FleetAttributes)
pub mod fleet_attributes {
    /// A builder for [`FleetAttributes`](crate::model::FleetAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_id: std::option::Option<std::string::String>,
        pub(crate) fleet_arn: std::option::Option<std::string::String>,
        pub(crate) fleet_type: std::option::Option<crate::model::FleetType>,
        pub(crate) instance_type: std::option::Option<crate::model::Ec2InstanceType>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) termination_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::FleetStatus>,
        pub(crate) build_id: std::option::Option<std::string::String>,
        pub(crate) build_arn: std::option::Option<std::string::String>,
        pub(crate) script_id: std::option::Option<std::string::String>,
        pub(crate) script_arn: std::option::Option<std::string::String>,
        pub(crate) server_launch_path: std::option::Option<std::string::String>,
        pub(crate) server_launch_parameters: std::option::Option<std::string::String>,
        pub(crate) log_paths: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) new_game_session_protection_policy:
            std::option::Option<crate::model::ProtectionPolicy>,
        pub(crate) operating_system: std::option::Option<crate::model::OperatingSystem>,
        pub(crate) resource_creation_limit_policy:
            std::option::Option<crate::model::ResourceCreationLimitPolicy>,
        pub(crate) metric_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) stopped_actions: std::option::Option<std::vec::Vec<crate::model::FleetAction>>,
        pub(crate) instance_role_arn: std::option::Option<std::string::String>,
        pub(crate) certificate_configuration:
            std::option::Option<crate::model::CertificateConfiguration>,
    }
    impl Builder {
        /// <p>A unique identifier for the fleet.</p>
        pub fn fleet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the fleet.</p>
        pub fn set_fleet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_id = input;
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
        /// </region></code>. In a GameLift fleet ARN, the resource ID matches the <code>FleetId</code> value.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:
        /// <region>
        /// ::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912
        /// </region></code>. In a GameLift fleet ARN, the resource ID matches the <code>FleetId</code> value.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_arn = input;
            self
        }
        /// <p>The kind of instances, On-Demand or Spot, that this fleet uses.</p>
        pub fn fleet_type(mut self, input: crate::model::FleetType) -> Self {
            self.fleet_type = Some(input);
            self
        }
        /// <p>The kind of instances, On-Demand or Spot, that this fleet uses.</p>
        pub fn set_fleet_type(
            mut self,
            input: std::option::Option<crate::model::FleetType>,
        ) -> Self {
            self.fleet_type = input;
            self
        }
        /// <p>The Amazon EC2 instance type that determines the computing resources of each instance in the fleet. Instance type defines the CPU, memory, storage, and networking capacity. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud Instance Types</a> for detailed descriptions.</p>
        pub fn instance_type(mut self, input: crate::model::Ec2InstanceType) -> Self {
            self.instance_type = Some(input);
            self
        }
        /// <p>The Amazon EC2 instance type that determines the computing resources of each instance in the fleet. Instance type defines the CPU, memory, storage, and networking capacity. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud Instance Types</a> for detailed descriptions.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<crate::model::Ec2InstanceType>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>A human-readable description of the fleet.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A human-readable description of the fleet.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A descriptive label that is associated with a fleet. Fleet names do not need to be unique.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A descriptive label that is associated with a fleet. Fleet names do not need to be unique.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>A time stamp indicating when this data object was terminated. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn termination_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.termination_time = Some(input);
            self
        }
        /// <p>A time stamp indicating when this data object was terminated. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>
        pub fn set_termination_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.termination_time = input;
            self
        }
        /// <p>Current status of the fleet. Possible fleet statuses include the following:</p>
        /// <ul>
        /// <li> <p> <b>NEW</b> -- A new fleet has been defined and desired instances is set to 1. </p> </li>
        /// <li> <p> <b>DOWNLOADING/VALIDATING/BUILDING/ACTIVATING</b> -- GameLift is setting up the new fleet, creating new instances with the game build or Realtime script and starting server processes.</p> </li>
        /// <li> <p> <b>ACTIVE</b> -- Hosts can now accept game sessions.</p> </li>
        /// <li> <p> <b>ERROR</b> -- An error occurred when downloading, validating, building, or activating the fleet.</p> </li>
        /// <li> <p> <b>DELETING</b> -- Hosts are responding to a delete fleet request.</p> </li>
        /// <li> <p> <b>TERMINATED</b> -- The fleet no longer exists.</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::FleetStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Current status of the fleet. Possible fleet statuses include the following:</p>
        /// <ul>
        /// <li> <p> <b>NEW</b> -- A new fleet has been defined and desired instances is set to 1. </p> </li>
        /// <li> <p> <b>DOWNLOADING/VALIDATING/BUILDING/ACTIVATING</b> -- GameLift is setting up the new fleet, creating new instances with the game build or Realtime script and starting server processes.</p> </li>
        /// <li> <p> <b>ACTIVE</b> -- Hosts can now accept game sessions.</p> </li>
        /// <li> <p> <b>ERROR</b> -- An error occurred when downloading, validating, building, or activating the fleet.</p> </li>
        /// <li> <p> <b>DELETING</b> -- Hosts are responding to a delete fleet request.</p> </li>
        /// <li> <p> <b>TERMINATED</b> -- The fleet no longer exists.</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<crate::model::FleetStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>A unique identifier for the build resource that is deployed on instances in this fleet.</p>
        pub fn build_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.build_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the build resource that is deployed on instances in this fleet.</p>
        pub fn set_build_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.build_id = input;
            self
        }
        /// <p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift build resource that is deployed on instances in this fleet. In a GameLift build ARN, the resource ID matches the <code>BuildId</code> value.</p>
        pub fn build_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.build_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift build resource that is deployed on instances in this fleet. In a GameLift build ARN, the resource ID matches the <code>BuildId</code> value.</p>
        pub fn set_build_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.build_arn = input;
            self
        }
        /// <p>A unique identifier for the Realtime script resource that is deployed on instances in this fleet.</p>
        pub fn script_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.script_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the Realtime script resource that is deployed on instances in this fleet.</p>
        pub fn set_script_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.script_id = input;
            self
        }
        /// <p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift script resource that is deployed on instances in this fleet. In a GameLift script ARN, the resource ID matches the <code>ScriptId</code> value.</p>
        pub fn script_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.script_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift script resource that is deployed on instances in this fleet. In a GameLift script ARN, the resource ID matches the <code>ScriptId</code> value.</p>
        pub fn set_script_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.script_arn = input;
            self
        }
        /// <p> <b>This parameter is no longer used.</b> Server launch paths are now defined using the fleet's <code>RuntimeConfiguration</code> parameter. Requests that use this parameter instead continue to be valid.</p>
        pub fn server_launch_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_launch_path = Some(input.into());
            self
        }
        /// <p> <b>This parameter is no longer used.</b> Server launch paths are now defined using the fleet's <code>RuntimeConfiguration</code> parameter. Requests that use this parameter instead continue to be valid.</p>
        pub fn set_server_launch_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.server_launch_path = input;
            self
        }
        /// <p> <b>This parameter is no longer used.</b> Server launch parameters are now defined using the fleet's <code>RuntimeConfiguration</code> parameter. Requests that use this parameter instead continue to be valid.</p>
        pub fn server_launch_parameters(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_launch_parameters = Some(input.into());
            self
        }
        /// <p> <b>This parameter is no longer used.</b> Server launch parameters are now defined using the fleet's <code>RuntimeConfiguration</code> parameter. Requests that use this parameter instead continue to be valid.</p>
        pub fn set_server_launch_parameters(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.server_launch_parameters = input;
            self
        }
        /// Appends an item to `log_paths`.
        ///
        /// To override the contents of this collection use [`set_log_paths`](Self::set_log_paths).
        ///
        /// <p> <b>This parameter is no longer used.</b> Game session log paths are now defined using the GameLift server API <code>ProcessReady()</code> <code>logParameters</code>. See more information in the <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process">Server API Reference</a>. </p>
        pub fn log_paths(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.log_paths.unwrap_or_default();
            v.push(input.into());
            self.log_paths = Some(v);
            self
        }
        /// <p> <b>This parameter is no longer used.</b> Game session log paths are now defined using the GameLift server API <code>ProcessReady()</code> <code>logParameters</code>. See more information in the <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process">Server API Reference</a>. </p>
        pub fn set_log_paths(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.log_paths = input;
            self
        }
        /// <p>The type of game session protection to set on all new instances that are started in the fleet.</p>
        /// <ul>
        /// <li> <p> <b>NoProtection</b> -- The game session can be terminated during a scale-down event.</p> </li>
        /// <li> <p> <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during a scale-down event.</p> </li>
        /// </ul>
        pub fn new_game_session_protection_policy(
            mut self,
            input: crate::model::ProtectionPolicy,
        ) -> Self {
            self.new_game_session_protection_policy = Some(input);
            self
        }
        /// <p>The type of game session protection to set on all new instances that are started in the fleet.</p>
        /// <ul>
        /// <li> <p> <b>NoProtection</b> -- The game session can be terminated during a scale-down event.</p> </li>
        /// <li> <p> <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during a scale-down event.</p> </li>
        /// </ul>
        pub fn set_new_game_session_protection_policy(
            mut self,
            input: std::option::Option<crate::model::ProtectionPolicy>,
        ) -> Self {
            self.new_game_session_protection_policy = input;
            self
        }
        /// <p>The operating system of the fleet's computing resources. A fleet's operating system is determined by the OS of the build or script that is deployed on this fleet.</p>
        pub fn operating_system(mut self, input: crate::model::OperatingSystem) -> Self {
            self.operating_system = Some(input);
            self
        }
        /// <p>The operating system of the fleet's computing resources. A fleet's operating system is determined by the OS of the build or script that is deployed on this fleet.</p>
        pub fn set_operating_system(
            mut self,
            input: std::option::Option<crate::model::OperatingSystem>,
        ) -> Self {
            self.operating_system = input;
            self
        }
        /// <p>The fleet policy that limits the number of game sessions an individual player can create over a span of time.</p>
        pub fn resource_creation_limit_policy(
            mut self,
            input: crate::model::ResourceCreationLimitPolicy,
        ) -> Self {
            self.resource_creation_limit_policy = Some(input);
            self
        }
        /// <p>The fleet policy that limits the number of game sessions an individual player can create over a span of time.</p>
        pub fn set_resource_creation_limit_policy(
            mut self,
            input: std::option::Option<crate::model::ResourceCreationLimitPolicy>,
        ) -> Self {
            self.resource_creation_limit_policy = input;
            self
        }
        /// Appends an item to `metric_groups`.
        ///
        /// To override the contents of this collection use [`set_metric_groups`](Self::set_metric_groups).
        ///
        /// <p>Name of a metric group that metrics for this fleet are added to. In Amazon CloudWatch, you can view aggregated metrics for fleets that are in a metric group. A fleet can be included in only one metric group at a time.</p>
        pub fn metric_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.metric_groups.unwrap_or_default();
            v.push(input.into());
            self.metric_groups = Some(v);
            self
        }
        /// <p>Name of a metric group that metrics for this fleet are added to. In Amazon CloudWatch, you can view aggregated metrics for fleets that are in a metric group. A fleet can be included in only one metric group at a time.</p>
        pub fn set_metric_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.metric_groups = input;
            self
        }
        /// Appends an item to `stopped_actions`.
        ///
        /// To override the contents of this collection use [`set_stopped_actions`](Self::set_stopped_actions).
        ///
        /// <p>A list of fleet activity that has been suspended using <code>StopFleetActions</code>. This includes fleet auto-scaling.</p>
        pub fn stopped_actions(mut self, input: crate::model::FleetAction) -> Self {
            let mut v = self.stopped_actions.unwrap_or_default();
            v.push(input);
            self.stopped_actions = Some(v);
            self
        }
        /// <p>A list of fleet activity that has been suspended using <code>StopFleetActions</code>. This includes fleet auto-scaling.</p>
        pub fn set_stopped_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FleetAction>>,
        ) -> Self {
            self.stopped_actions = input;
            self
        }
        /// <p>A unique identifier for an IAM role that manages access to your Amazon Web Services services. With an instance role ARN set, any application that runs on an instance in this fleet can assume the role, including install scripts, server processes, and daemons (background processes). Create a role or look up a role's ARN by using the <a href="https://console.aws.amazon.com/iam/">IAM dashboard</a> in the Amazon Web Services Management Console. Learn more about using on-box credentials for your game servers at <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html"> Access external resources from a game server</a>.</p>
        pub fn instance_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_role_arn = Some(input.into());
            self
        }
        /// <p>A unique identifier for an IAM role that manages access to your Amazon Web Services services. With an instance role ARN set, any application that runs on an instance in this fleet can assume the role, including install scripts, server processes, and daemons (background processes). Create a role or look up a role's ARN by using the <a href="https://console.aws.amazon.com/iam/">IAM dashboard</a> in the Amazon Web Services Management Console. Learn more about using on-box credentials for your game servers at <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html"> Access external resources from a game server</a>.</p>
        pub fn set_instance_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_role_arn = input;
            self
        }
        /// <p>Indicates whether a TLS/SSL certificate was generated for the fleet. </p>
        pub fn certificate_configuration(
            mut self,
            input: crate::model::CertificateConfiguration,
        ) -> Self {
            self.certificate_configuration = Some(input);
            self
        }
        /// <p>Indicates whether a TLS/SSL certificate was generated for the fleet. </p>
        pub fn set_certificate_configuration(
            mut self,
            input: std::option::Option<crate::model::CertificateConfiguration>,
        ) -> Self {
            self.certificate_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`FleetAttributes`](crate::model::FleetAttributes)
        pub fn build(self) -> crate::model::FleetAttributes {
            crate::model::FleetAttributes {
                fleet_id: self.fleet_id,
                fleet_arn: self.fleet_arn,
                fleet_type: self.fleet_type,
                instance_type: self.instance_type,
                description: self.description,
                name: self.name,
                creation_time: self.creation_time,
                termination_time: self.termination_time,
                status: self.status,
                build_id: self.build_id,
                build_arn: self.build_arn,
                script_id: self.script_id,
                script_arn: self.script_arn,
                server_launch_path: self.server_launch_path,
                server_launch_parameters: self.server_launch_parameters,
                log_paths: self.log_paths,
                new_game_session_protection_policy: self.new_game_session_protection_policy,
                operating_system: self.operating_system,
                resource_creation_limit_policy: self.resource_creation_limit_policy,
                metric_groups: self.metric_groups,
                stopped_actions: self.stopped_actions,
                instance_role_arn: self.instance_role_arn,
                certificate_configuration: self.certificate_configuration,
            }
        }
    }
}
impl FleetAttributes {
    /// Creates a new builder-style object to manufacture [`FleetAttributes`](crate::model::FleetAttributes)
    pub fn builder() -> crate::model::fleet_attributes::Builder {
        crate::model::fleet_attributes::Builder::default()
    }
}

/// <p>Determines whether a TLS/SSL certificate is generated for a fleet. This feature must be enabled when creating the fleet. All instances in a fleet share the same certificate. The certificate can be retrieved by calling the <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk.html">GameLift Server SDK</a> operation <code>GetInstanceCertificate</code>. </p>
/// <p>A fleet's certificate configuration is part of <code>FleetAttributes</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CertificateConfiguration {
    /// <p>Indicates whether a TLS/SSL certificate is generated for a fleet. </p>
    /// <p>Valid values include: </p>
    /// <ul>
    /// <li> <p> <b>GENERATED</b> - Generate a TLS/SSL certificate for this fleet.</p> </li>
    /// <li> <p> <b>DISABLED</b> - (default) Do not generate a TLS/SSL certificate for this fleet. </p> </li>
    /// </ul>
    pub certificate_type: std::option::Option<crate::model::CertificateType>,
}
impl CertificateConfiguration {
    /// <p>Indicates whether a TLS/SSL certificate is generated for a fleet. </p>
    /// <p>Valid values include: </p>
    /// <ul>
    /// <li> <p> <b>GENERATED</b> - Generate a TLS/SSL certificate for this fleet.</p> </li>
    /// <li> <p> <b>DISABLED</b> - (default) Do not generate a TLS/SSL certificate for this fleet. </p> </li>
    /// </ul>
    pub fn certificate_type(&self) -> std::option::Option<&crate::model::CertificateType> {
        self.certificate_type.as_ref()
    }
}
impl std::fmt::Debug for CertificateConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CertificateConfiguration");
        formatter.field("certificate_type", &self.certificate_type);
        formatter.finish()
    }
}
/// See [`CertificateConfiguration`](crate::model::CertificateConfiguration)
pub mod certificate_configuration {
    /// A builder for [`CertificateConfiguration`](crate::model::CertificateConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_type: std::option::Option<crate::model::CertificateType>,
    }
    impl Builder {
        /// <p>Indicates whether a TLS/SSL certificate is generated for a fleet. </p>
        /// <p>Valid values include: </p>
        /// <ul>
        /// <li> <p> <b>GENERATED</b> - Generate a TLS/SSL certificate for this fleet.</p> </li>
        /// <li> <p> <b>DISABLED</b> - (default) Do not generate a TLS/SSL certificate for this fleet. </p> </li>
        /// </ul>
        pub fn certificate_type(mut self, input: crate::model::CertificateType) -> Self {
            self.certificate_type = Some(input);
            self
        }
        /// <p>Indicates whether a TLS/SSL certificate is generated for a fleet. </p>
        /// <p>Valid values include: </p>
        /// <ul>
        /// <li> <p> <b>GENERATED</b> - Generate a TLS/SSL certificate for this fleet.</p> </li>
        /// <li> <p> <b>DISABLED</b> - (default) Do not generate a TLS/SSL certificate for this fleet. </p> </li>
        /// </ul>
        pub fn set_certificate_type(
            mut self,
            input: std::option::Option<crate::model::CertificateType>,
        ) -> Self {
            self.certificate_type = input;
            self
        }
        /// Consumes the builder and constructs a [`CertificateConfiguration`](crate::model::CertificateConfiguration)
        pub fn build(self) -> crate::model::CertificateConfiguration {
            crate::model::CertificateConfiguration {
                certificate_type: self.certificate_type,
            }
        }
    }
}
impl CertificateConfiguration {
    /// Creates a new builder-style object to manufacture [`CertificateConfiguration`](crate::model::CertificateConfiguration)
    pub fn builder() -> crate::model::certificate_configuration::Builder {
        crate::model::certificate_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CertificateType {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Generated,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CertificateType {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => CertificateType::Disabled,
            "GENERATED" => CertificateType::Generated,
            other => CertificateType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CertificateType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CertificateType::from(s))
    }
}
impl CertificateType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CertificateType::Disabled => "DISABLED",
            CertificateType::Generated => "GENERATED",
            CertificateType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "GENERATED"]
    }
}
impl AsRef<str> for CertificateType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FleetType {
    #[allow(missing_docs)] // documentation missing in model
    OnDemand,
    #[allow(missing_docs)] // documentation missing in model
    Spot,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FleetType {
    fn from(s: &str) -> Self {
        match s {
            "ON_DEMAND" => FleetType::OnDemand,
            "SPOT" => FleetType::Spot,
            other => FleetType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FleetType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FleetType::from(s))
    }
}
impl FleetType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FleetType::OnDemand => "ON_DEMAND",
            FleetType::Spot => "SPOT",
            FleetType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ON_DEMAND", "SPOT"]
    }
}
impl AsRef<str> for FleetType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The GameLift service limits for an Amazon EC2 instance type and current utilization. GameLift allows Amazon Web Services accounts a maximum number of instances, per instance type, per Amazon Web Services Region or location, for use with GameLift. You can request an limit increase for your account by using the <b>Service limits</b> page in the GameLift console.</p>
/// <p> <b>Related actions</b> </p>
/// <p> <code>DescribeEC2InstanceLimits</code> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ec2InstanceLimit {
    /// <p>The name of an Amazon EC2 instance type. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud Instance Types</a> for detailed descriptions. </p>
    pub ec2_instance_type: std::option::Option<crate::model::Ec2InstanceType>,
    /// <p>The number of instances for the specified type and location that are currently being used by the Amazon Web Services account. </p>
    pub current_instances: std::option::Option<i32>,
    /// <p>The number of instances that is allowed for the specified instance type and location.</p>
    pub instance_limit: std::option::Option<i32>,
    /// <p>An Amazon Web Services Region code, such as <code>us-west-2</code>. </p>
    pub location: std::option::Option<std::string::String>,
}
impl Ec2InstanceLimit {
    /// <p>The name of an Amazon EC2 instance type. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud Instance Types</a> for detailed descriptions. </p>
    pub fn ec2_instance_type(&self) -> std::option::Option<&crate::model::Ec2InstanceType> {
        self.ec2_instance_type.as_ref()
    }
    /// <p>The number of instances for the specified type and location that are currently being used by the Amazon Web Services account. </p>
    pub fn current_instances(&self) -> std::option::Option<i32> {
        self.current_instances
    }
    /// <p>The number of instances that is allowed for the specified instance type and location.</p>
    pub fn instance_limit(&self) -> std::option::Option<i32> {
        self.instance_limit
    }
    /// <p>An Amazon Web Services Region code, such as <code>us-west-2</code>. </p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
}
impl std::fmt::Debug for Ec2InstanceLimit {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ec2InstanceLimit");
        formatter.field("ec2_instance_type", &self.ec2_instance_type);
        formatter.field("current_instances", &self.current_instances);
        formatter.field("instance_limit", &self.instance_limit);
        formatter.field("location", &self.location);
        formatter.finish()
    }
}
/// See [`Ec2InstanceLimit`](crate::model::Ec2InstanceLimit)
pub mod ec2_instance_limit {
    /// A builder for [`Ec2InstanceLimit`](crate::model::Ec2InstanceLimit)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ec2_instance_type: std::option::Option<crate::model::Ec2InstanceType>,
        pub(crate) current_instances: std::option::Option<i32>,
        pub(crate) instance_limit: std::option::Option<i32>,
        pub(crate) location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of an Amazon EC2 instance type. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud Instance Types</a> for detailed descriptions. </p>
        pub fn ec2_instance_type(mut self, input: crate::model::Ec2InstanceType) -> Self {
            self.ec2_instance_type = Some(input);
            self
        }
        /// <p>The name of an Amazon EC2 instance type. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud Instance Types</a> for detailed descriptions. </p>
        pub fn set_ec2_instance_type(
            mut self,
            input: std::option::Option<crate::model::Ec2InstanceType>,
        ) -> Self {
            self.ec2_instance_type = input;
            self
        }
        /// <p>The number of instances for the specified type and location that are currently being used by the Amazon Web Services account. </p>
        pub fn current_instances(mut self, input: i32) -> Self {
            self.current_instances = Some(input);
            self
        }
        /// <p>The number of instances for the specified type and location that are currently being used by the Amazon Web Services account. </p>
        pub fn set_current_instances(mut self, input: std::option::Option<i32>) -> Self {
            self.current_instances = input;
            self
        }
        /// <p>The number of instances that is allowed for the specified instance type and location.</p>
        pub fn instance_limit(mut self, input: i32) -> Self {
            self.instance_limit = Some(input);
            self
        }
        /// <p>The number of instances that is allowed for the specified instance type and location.</p>
        pub fn set_instance_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.instance_limit = input;
            self
        }
        /// <p>An Amazon Web Services Region code, such as <code>us-west-2</code>. </p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>An Amazon Web Services Region code, such as <code>us-west-2</code>. </p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`Ec2InstanceLimit`](crate::model::Ec2InstanceLimit)
        pub fn build(self) -> crate::model::Ec2InstanceLimit {
            crate::model::Ec2InstanceLimit {
                ec2_instance_type: self.ec2_instance_type,
                current_instances: self.current_instances,
                instance_limit: self.instance_limit,
                location: self.location,
            }
        }
    }
}
impl Ec2InstanceLimit {
    /// Creates a new builder-style object to manufacture [`Ec2InstanceLimit`](crate::model::Ec2InstanceLimit)
    pub fn builder() -> crate::model::ec2_instance_limit::Builder {
        crate::model::ec2_instance_limit::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GameServerGroupDeleteOption {
    #[allow(missing_docs)] // documentation missing in model
    ForceDelete,
    #[allow(missing_docs)] // documentation missing in model
    Retain,
    #[allow(missing_docs)] // documentation missing in model
    SafeDelete,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GameServerGroupDeleteOption {
    fn from(s: &str) -> Self {
        match s {
            "FORCE_DELETE" => GameServerGroupDeleteOption::ForceDelete,
            "RETAIN" => GameServerGroupDeleteOption::Retain,
            "SAFE_DELETE" => GameServerGroupDeleteOption::SafeDelete,
            other => GameServerGroupDeleteOption::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GameServerGroupDeleteOption {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GameServerGroupDeleteOption::from(s))
    }
}
impl GameServerGroupDeleteOption {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GameServerGroupDeleteOption::ForceDelete => "FORCE_DELETE",
            GameServerGroupDeleteOption::Retain => "RETAIN",
            GameServerGroupDeleteOption::SafeDelete => "SAFE_DELETE",
            GameServerGroupDeleteOption::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FORCE_DELETE", "RETAIN", "SAFE_DELETE"]
    }
}
impl AsRef<str> for GameServerGroupDeleteOption {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> <b>This data type is used with the GameLift FleetIQ and game server groups.</b> </p>
/// <p>Configuration settings for intelligent automatic scaling that uses target tracking. These settings are used to add an Auto Scaling policy when creating the corresponding Auto Scaling group with <code>CreateGameServerGroup</code>. After the Auto Scaling group is created, all updates to Auto Scaling policies, including changing this policy and adding or removing other policies, is done directly on the Auto Scaling group. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GameServerGroupAutoScalingPolicy {
    /// <p>Length of time, in seconds, it takes for a new instance to start new game server processes and register with GameLift FleetIQ. Specifying a warm-up time can be useful, particularly with game servers that take a long time to start up, because it avoids prematurely starting new instances. </p>
    pub estimated_instance_warmup: std::option::Option<i32>,
    /// <p>Settings for a target-based scaling policy applied to Auto Scaling group. These settings are used to create a target-based policy that tracks the GameLift FleetIQ metric <code>"PercentUtilizedGameServers"</code> and specifies a target value for the metric. As player usage changes, the policy triggers to adjust the game server group capacity so that the metric returns to the target value. </p>
    pub target_tracking_configuration:
        std::option::Option<crate::model::TargetTrackingConfiguration>,
}
impl GameServerGroupAutoScalingPolicy {
    /// <p>Length of time, in seconds, it takes for a new instance to start new game server processes and register with GameLift FleetIQ. Specifying a warm-up time can be useful, particularly with game servers that take a long time to start up, because it avoids prematurely starting new instances. </p>
    pub fn estimated_instance_warmup(&self) -> std::option::Option<i32> {
        self.estimated_instance_warmup
    }
    /// <p>Settings for a target-based scaling policy applied to Auto Scaling group. These settings are used to create a target-based policy that tracks the GameLift FleetIQ metric <code>"PercentUtilizedGameServers"</code> and specifies a target value for the metric. As player usage changes, the policy triggers to adjust the game server group capacity so that the metric returns to the target value. </p>
    pub fn target_tracking_configuration(
        &self,
    ) -> std::option::Option<&crate::model::TargetTrackingConfiguration> {
        self.target_tracking_configuration.as_ref()
    }
}
impl std::fmt::Debug for GameServerGroupAutoScalingPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GameServerGroupAutoScalingPolicy");
        formatter.field("estimated_instance_warmup", &self.estimated_instance_warmup);
        formatter.field(
            "target_tracking_configuration",
            &self.target_tracking_configuration,
        );
        formatter.finish()
    }
}
/// See [`GameServerGroupAutoScalingPolicy`](crate::model::GameServerGroupAutoScalingPolicy)
pub mod game_server_group_auto_scaling_policy {
    /// A builder for [`GameServerGroupAutoScalingPolicy`](crate::model::GameServerGroupAutoScalingPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) estimated_instance_warmup: std::option::Option<i32>,
        pub(crate) target_tracking_configuration:
            std::option::Option<crate::model::TargetTrackingConfiguration>,
    }
    impl Builder {
        /// <p>Length of time, in seconds, it takes for a new instance to start new game server processes and register with GameLift FleetIQ. Specifying a warm-up time can be useful, particularly with game servers that take a long time to start up, because it avoids prematurely starting new instances. </p>
        pub fn estimated_instance_warmup(mut self, input: i32) -> Self {
            self.estimated_instance_warmup = Some(input);
            self
        }
        /// <p>Length of time, in seconds, it takes for a new instance to start new game server processes and register with GameLift FleetIQ. Specifying a warm-up time can be useful, particularly with game servers that take a long time to start up, because it avoids prematurely starting new instances. </p>
        pub fn set_estimated_instance_warmup(mut self, input: std::option::Option<i32>) -> Self {
            self.estimated_instance_warmup = input;
            self
        }
        /// <p>Settings for a target-based scaling policy applied to Auto Scaling group. These settings are used to create a target-based policy that tracks the GameLift FleetIQ metric <code>"PercentUtilizedGameServers"</code> and specifies a target value for the metric. As player usage changes, the policy triggers to adjust the game server group capacity so that the metric returns to the target value. </p>
        pub fn target_tracking_configuration(
            mut self,
            input: crate::model::TargetTrackingConfiguration,
        ) -> Self {
            self.target_tracking_configuration = Some(input);
            self
        }
        /// <p>Settings for a target-based scaling policy applied to Auto Scaling group. These settings are used to create a target-based policy that tracks the GameLift FleetIQ metric <code>"PercentUtilizedGameServers"</code> and specifies a target value for the metric. As player usage changes, the policy triggers to adjust the game server group capacity so that the metric returns to the target value. </p>
        pub fn set_target_tracking_configuration(
            mut self,
            input: std::option::Option<crate::model::TargetTrackingConfiguration>,
        ) -> Self {
            self.target_tracking_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`GameServerGroupAutoScalingPolicy`](crate::model::GameServerGroupAutoScalingPolicy)
        pub fn build(self) -> crate::model::GameServerGroupAutoScalingPolicy {
            crate::model::GameServerGroupAutoScalingPolicy {
                estimated_instance_warmup: self.estimated_instance_warmup,
                target_tracking_configuration: self.target_tracking_configuration,
            }
        }
    }
}
impl GameServerGroupAutoScalingPolicy {
    /// Creates a new builder-style object to manufacture [`GameServerGroupAutoScalingPolicy`](crate::model::GameServerGroupAutoScalingPolicy)
    pub fn builder() -> crate::model::game_server_group_auto_scaling_policy::Builder {
        crate::model::game_server_group_auto_scaling_policy::Builder::default()
    }
}

/// <p> <b>This data type is used with the GameLift FleetIQ and game server groups.</b> </p>
/// <p>Settings for a target-based scaling policy as part of a <code>GameServerGroupAutoScalingPolicy</code>. These settings are used to create a target-based policy that tracks the GameLift FleetIQ metric <code>"PercentUtilizedGameServers"</code> and specifies a target value for the metric. As player usage changes, the policy triggers to adjust the game server group capacity so that the metric returns to the target value. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TargetTrackingConfiguration {
    /// <p>Desired value to use with a game server group target-based scaling policy. </p>
    pub target_value: std::option::Option<f64>,
}
impl TargetTrackingConfiguration {
    /// <p>Desired value to use with a game server group target-based scaling policy. </p>
    pub fn target_value(&self) -> std::option::Option<f64> {
        self.target_value
    }
}
impl std::fmt::Debug for TargetTrackingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TargetTrackingConfiguration");
        formatter.field("target_value", &self.target_value);
        formatter.finish()
    }
}
/// See [`TargetTrackingConfiguration`](crate::model::TargetTrackingConfiguration)
pub mod target_tracking_configuration {
    /// A builder for [`TargetTrackingConfiguration`](crate::model::TargetTrackingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_value: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>Desired value to use with a game server group target-based scaling policy. </p>
        pub fn target_value(mut self, input: f64) -> Self {
            self.target_value = Some(input);
            self
        }
        /// <p>Desired value to use with a game server group target-based scaling policy. </p>
        pub fn set_target_value(mut self, input: std::option::Option<f64>) -> Self {
            self.target_value = input;
            self
        }
        /// Consumes the builder and constructs a [`TargetTrackingConfiguration`](crate::model::TargetTrackingConfiguration)
        pub fn build(self) -> crate::model::TargetTrackingConfiguration {
            crate::model::TargetTrackingConfiguration {
                target_value: self.target_value,
            }
        }
    }
}
impl TargetTrackingConfiguration {
    /// Creates a new builder-style object to manufacture [`TargetTrackingConfiguration`](crate::model::TargetTrackingConfiguration)
    pub fn builder() -> crate::model::target_tracking_configuration::Builder {
        crate::model::target_tracking_configuration::Builder::default()
    }
}

/// <p> <b>This data type is used with the GameLift FleetIQ and game server groups.</b> </p>
/// <p>An Amazon Elastic Compute Cloud launch template that contains configuration settings and game server code to be deployed to all instances in a game server group. The launch template is specified when creating a new game server group with <code>CreateGameServerGroup</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LaunchTemplateSpecification {
    /// <p>A unique identifier for an existing Amazon EC2 launch template.</p>
    pub launch_template_id: std::option::Option<std::string::String>,
    /// <p>A readable identifier for an existing Amazon EC2 launch template. </p>
    pub launch_template_name: std::option::Option<std::string::String>,
    /// <p>The version of the Amazon EC2 launch template to use. If no version is specified, the default version will be used. With Amazon EC2, you can specify a default version for a launch template. If none is set, the default is the first version created.</p>
    pub version: std::option::Option<std::string::String>,
}
impl LaunchTemplateSpecification {
    /// <p>A unique identifier for an existing Amazon EC2 launch template.</p>
    pub fn launch_template_id(&self) -> std::option::Option<&str> {
        self.launch_template_id.as_deref()
    }
    /// <p>A readable identifier for an existing Amazon EC2 launch template. </p>
    pub fn launch_template_name(&self) -> std::option::Option<&str> {
        self.launch_template_name.as_deref()
    }
    /// <p>The version of the Amazon EC2 launch template to use. If no version is specified, the default version will be used. With Amazon EC2, you can specify a default version for a launch template. If none is set, the default is the first version created.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for LaunchTemplateSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LaunchTemplateSpecification");
        formatter.field("launch_template_id", &self.launch_template_id);
        formatter.field("launch_template_name", &self.launch_template_name);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`LaunchTemplateSpecification`](crate::model::LaunchTemplateSpecification)
pub mod launch_template_specification {
    /// A builder for [`LaunchTemplateSpecification`](crate::model::LaunchTemplateSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) launch_template_id: std::option::Option<std::string::String>,
        pub(crate) launch_template_name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for an existing Amazon EC2 launch template.</p>
        pub fn launch_template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_template_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for an existing Amazon EC2 launch template.</p>
        pub fn set_launch_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_template_id = input;
            self
        }
        /// <p>A readable identifier for an existing Amazon EC2 launch template. </p>
        pub fn launch_template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_template_name = Some(input.into());
            self
        }
        /// <p>A readable identifier for an existing Amazon EC2 launch template. </p>
        pub fn set_launch_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_template_name = input;
            self
        }
        /// <p>The version of the Amazon EC2 launch template to use. If no version is specified, the default version will be used. With Amazon EC2, you can specify a default version for a launch template. If none is set, the default is the first version created.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the Amazon EC2 launch template to use. If no version is specified, the default version will be used. With Amazon EC2, you can specify a default version for a launch template. If none is set, the default is the first version created.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`LaunchTemplateSpecification`](crate::model::LaunchTemplateSpecification)
        pub fn build(self) -> crate::model::LaunchTemplateSpecification {
            crate::model::LaunchTemplateSpecification {
                launch_template_id: self.launch_template_id,
                launch_template_name: self.launch_template_name,
                version: self.version,
            }
        }
    }
}
impl LaunchTemplateSpecification {
    /// Creates a new builder-style object to manufacture [`LaunchTemplateSpecification`](crate::model::LaunchTemplateSpecification)
    pub fn builder() -> crate::model::launch_template_specification::Builder {
        crate::model::launch_template_specification::Builder::default()
    }
}

/// <p>A remote location where a multi-location fleet can deploy EC2 instances for game hosting. </p>
/// <p> <b>Related actions</b> </p>
/// <p> <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateFleet.html">CreateFleet</a> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LocationConfiguration {
    /// <p>An Amazon Web Services Region code, such as <code>us-west-2</code>. </p>
    pub location: std::option::Option<std::string::String>,
}
impl LocationConfiguration {
    /// <p>An Amazon Web Services Region code, such as <code>us-west-2</code>. </p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
}
impl std::fmt::Debug for LocationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LocationConfiguration");
        formatter.field("location", &self.location);
        formatter.finish()
    }
}
/// See [`LocationConfiguration`](crate::model::LocationConfiguration)
pub mod location_configuration {
    /// A builder for [`LocationConfiguration`](crate::model::LocationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An Amazon Web Services Region code, such as <code>us-west-2</code>. </p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>An Amazon Web Services Region code, such as <code>us-west-2</code>. </p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`LocationConfiguration`](crate::model::LocationConfiguration)
        pub fn build(self) -> crate::model::LocationConfiguration {
            crate::model::LocationConfiguration {
                location: self.location,
            }
        }
    }
}
impl LocationConfiguration {
    /// Creates a new builder-style object to manufacture [`LocationConfiguration`](crate::model::LocationConfiguration)
    pub fn builder() -> crate::model::location_configuration::Builder {
        crate::model::location_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AcceptanceType {
    #[allow(missing_docs)] // documentation missing in model
    Accept,
    #[allow(missing_docs)] // documentation missing in model
    Reject,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AcceptanceType {
    fn from(s: &str) -> Self {
        match s {
            "ACCEPT" => AcceptanceType::Accept,
            "REJECT" => AcceptanceType::Reject,
            other => AcceptanceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AcceptanceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AcceptanceType::from(s))
    }
}
impl AcceptanceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AcceptanceType::Accept => "ACCEPT",
            AcceptanceType::Reject => "REJECT",
            AcceptanceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACCEPT", "REJECT"]
    }
}
impl AsRef<str> for AcceptanceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
