// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon FSx
///
/// Client for invoking operations on Amazon FSx. Each operation on Amazon FSx is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_fsx::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_fsx::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_fsx::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AssociateFileSystemAliases`](crate::client::fluent_builders::AssociateFileSystemAliases) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::AssociateFileSystemAliases::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::AssociateFileSystemAliases::set_client_request_token): <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    ///   - [`file_system_id(impl Into<String>)`](crate::client::fluent_builders::AssociateFileSystemAliases::file_system_id) / [`set_file_system_id(Option<String>)`](crate::client::fluent_builders::AssociateFileSystemAliases::set_file_system_id): <p>Specifies the file system with which you want to associate one or more DNS aliases.</p>
    ///   - [`aliases(Vec<String>)`](crate::client::fluent_builders::AssociateFileSystemAliases::aliases) / [`set_aliases(Option<Vec<String>>)`](crate::client::fluent_builders::AssociateFileSystemAliases::set_aliases): <p>An array of one or more DNS alias names to associate with the file system. The alias name has to comply with the following formatting requirements:</p>  <ul>   <li> <p>Formatted as a fully-qualified domain name (FQDN), <i> <code>hostname.domain</code> </i>, for example, <code>accounting.corp.example.com</code>.</p> </li>   <li> <p>Can contain alphanumeric characters and the hyphen (-).</p> </li>   <li> <p>Cannot start or end with a hyphen.</p> </li>   <li> <p>Can start with a numeric.</p> </li>  </ul>  <p>For DNS alias names, Amazon FSx stores alphabetic characters as lowercase letters (a-z), regardless of how you specify them: as uppercase letters, lowercase letters, or the corresponding letters in escape codes.</p>
    /// - On success, responds with [`AssociateFileSystemAliasesOutput`](crate::output::AssociateFileSystemAliasesOutput) with field(s):
    ///   - [`aliases(Option<Vec<Alias>>)`](crate::output::AssociateFileSystemAliasesOutput::aliases): <p>An array of the DNS aliases that Amazon FSx is associating with the file system.</p>
    /// - On failure, responds with [`SdkError<AssociateFileSystemAliasesError>`](crate::error::AssociateFileSystemAliasesError)
    pub fn associate_file_system_aliases(&self) -> fluent_builders::AssociateFileSystemAliases {
        fluent_builders::AssociateFileSystemAliases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelDataRepositoryTask`](crate::client::fluent_builders::CancelDataRepositoryTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_id(impl Into<String>)`](crate::client::fluent_builders::CancelDataRepositoryTask::task_id) / [`set_task_id(Option<String>)`](crate::client::fluent_builders::CancelDataRepositoryTask::set_task_id): <p>Specifies the data repository task to cancel.</p>
    /// - On success, responds with [`CancelDataRepositoryTaskOutput`](crate::output::CancelDataRepositoryTaskOutput) with field(s):
    ///   - [`lifecycle(Option<DataRepositoryTaskLifecycle>)`](crate::output::CancelDataRepositoryTaskOutput::lifecycle): <p>The lifecycle status of the data repository task, as follows:</p>  <ul>   <li> <p> <code>PENDING</code> - Amazon FSx has not started the task.</p> </li>   <li> <p> <code>EXECUTING</code> - Amazon FSx is processing the task.</p> </li>   <li> <p> <code>FAILED</code> - Amazon FSx was not able to complete the task. For example, there may be files the task failed to process. The <code>DataRepositoryTaskFailureDetails</code> property provides more information about task failures.</p> </li>   <li> <p> <code>SUCCEEDED</code> - FSx completed the task successfully.</p> </li>   <li> <p> <code>CANCELED</code> - Amazon FSx canceled the task and it did not complete.</p> </li>   <li> <p> <code>CANCELING</code> - FSx is in process of canceling the task.</p> </li>  </ul>
    ///   - [`task_id(Option<String>)`](crate::output::CancelDataRepositoryTaskOutput::task_id): <p>The ID of the task being canceled.</p>
    /// - On failure, responds with [`SdkError<CancelDataRepositoryTaskError>`](crate::error::CancelDataRepositoryTaskError)
    pub fn cancel_data_repository_task(&self) -> fluent_builders::CancelDataRepositoryTask {
        fluent_builders::CancelDataRepositoryTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CopyBackup`](crate::client::fluent_builders::CopyBackup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CopyBackup::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CopyBackup::set_client_request_token): <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    ///   - [`source_backup_id(impl Into<String>)`](crate::client::fluent_builders::CopyBackup::source_backup_id) / [`set_source_backup_id(Option<String>)`](crate::client::fluent_builders::CopyBackup::set_source_backup_id): <p>The ID of the source backup. Specifies the ID of the backup that's being copied.</p>
    ///   - [`source_region(impl Into<String>)`](crate::client::fluent_builders::CopyBackup::source_region) / [`set_source_region(Option<String>)`](crate::client::fluent_builders::CopyBackup::set_source_region): <p>The source Amazon Web Services Region of the backup. Specifies the Amazon Web Services Region from which the backup is being copied. The source and destination Regions must be in the same Amazon Web Services partition. If you don't specify a Region, <code>SourceRegion</code> defaults to the Region where the request is sent from (in-Region copy).</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CopyBackup::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CopyBackup::set_kms_key_id): <p>The ID of the Key Management Service (KMS) key used to encrypt the file system's data for Amazon FSx for Windows File Server file systems, Amazon FSx for NetApp ONTAP file systems, and Amazon FSx for Lustre <code>PERSISTENT_1</code> and <code>PERSISTENT_2</code> file systems at rest. If this ID isn't specified, the key managed by Amazon FSx is used. The Amazon FSx for Lustre <code>SCRATCH_1</code> and <code>SCRATCH_2</code> file systems are always encrypted at rest using Amazon FSx-managed keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html">Encrypt</a> in the <i>Key Management Service API Reference</i>.</p>
    ///   - [`copy_tags(bool)`](crate::client::fluent_builders::CopyBackup::copy_tags) / [`set_copy_tags(Option<bool>)`](crate::client::fluent_builders::CopyBackup::set_copy_tags): <p>A Boolean flag indicating whether tags from the source backup should be copied to the backup copy. This value defaults to <code>false</code>.</p>  <p>If you set <code>CopyTags</code> to <code>true</code> and the source backup has existing tags, you can use the <code>Tags</code> parameter to create new tags, provided that the sum of the source backup tags and the new tags doesn't exceed 50. Both sets of tags are merged. If there are tag conflicts (for example, two tags with the same key but different values), the tags created with the <code>Tags</code> parameter take precedence.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CopyBackup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CopyBackup::set_tags): <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
    /// - On success, responds with [`CopyBackupOutput`](crate::output::CopyBackupOutput) with field(s):
    ///   - [`backup(Option<Backup>)`](crate::output::CopyBackupOutput::backup): <p>A backup of an Amazon FSx for Windows File Server, Amazon FSx for Lustre file system, Amazon FSx for NetApp ONTAP volume, or Amazon FSx for OpenZFS file system.</p>
    /// - On failure, responds with [`SdkError<CopyBackupError>`](crate::error::CopyBackupError)
    pub fn copy_backup(&self) -> fluent_builders::CopyBackup {
        fluent_builders::CopyBackup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateBackup`](crate::client::fluent_builders::CreateBackup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`file_system_id(impl Into<String>)`](crate::client::fluent_builders::CreateBackup::file_system_id) / [`set_file_system_id(Option<String>)`](crate::client::fluent_builders::CreateBackup::set_file_system_id): <p>The ID of the file system to back up.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateBackup::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateBackup::set_client_request_token): <p>(Optional) A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent creation. This string is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateBackup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateBackup::set_tags): <p>(Optional) The tags to apply to the backup at backup creation. The key value of the <code>Name</code> tag appears in the console as the backup name. If you have set <code>CopyTagsToBackups</code> to <code>true</code>, and you specify one or more tags using the <code>CreateBackup</code> operation, no existing file system tags are copied from the file system to the backup.</p>
    ///   - [`volume_id(impl Into<String>)`](crate::client::fluent_builders::CreateBackup::volume_id) / [`set_volume_id(Option<String>)`](crate::client::fluent_builders::CreateBackup::set_volume_id): <p>(Optional) The ID of the FSx for ONTAP volume to back up.</p>
    /// - On success, responds with [`CreateBackupOutput`](crate::output::CreateBackupOutput) with field(s):
    ///   - [`backup(Option<Backup>)`](crate::output::CreateBackupOutput::backup): <p>A description of the backup.</p>
    /// - On failure, responds with [`SdkError<CreateBackupError>`](crate::error::CreateBackupError)
    pub fn create_backup(&self) -> fluent_builders::CreateBackup {
        fluent_builders::CreateBackup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDataRepositoryAssociation`](crate::client::fluent_builders::CreateDataRepositoryAssociation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`file_system_id(impl Into<String>)`](crate::client::fluent_builders::CreateDataRepositoryAssociation::file_system_id) / [`set_file_system_id(Option<String>)`](crate::client::fluent_builders::CreateDataRepositoryAssociation::set_file_system_id): <p>The globally unique ID of the file system, assigned by Amazon FSx.</p>
    ///   - [`file_system_path(impl Into<String>)`](crate::client::fluent_builders::CreateDataRepositoryAssociation::file_system_path) / [`set_file_system_path(Option<String>)`](crate::client::fluent_builders::CreateDataRepositoryAssociation::set_file_system_path): <p>A path on the file system that points to a high-level directory (such as <code>/ns1/</code>) or subdirectory (such as <code>/ns1/subdir/</code>) that will be mapped 1-1 with <code>DataRepositoryPath</code>. The leading forward slash in the name is required. Two data repository associations cannot have overlapping file system paths. For example, if a data repository is associated with file system path <code>/ns1/</code>, then you cannot link another data repository with file system path <code>/ns1/ns2</code>.</p>  <p>This path specifies where in your file system files will be exported from or imported to. This file system directory can be linked to only one Amazon S3 bucket, and no other S3 bucket can be linked to the directory.</p> <note>   <p>If you specify only a forward slash (<code>/</code>) as the file system path, you can link only 1 data repository to the file system. You can only specify "/" as the file system path for the first data repository associated with a file system.</p>  </note>
    ///   - [`data_repository_path(impl Into<String>)`](crate::client::fluent_builders::CreateDataRepositoryAssociation::data_repository_path) / [`set_data_repository_path(Option<String>)`](crate::client::fluent_builders::CreateDataRepositoryAssociation::set_data_repository_path): <p>The path to the Amazon S3 data repository that will be linked to the file system. The path can be an S3 bucket or prefix in the format <code>s3://myBucket/myPrefix/</code>. This path specifies where in the S3 data repository files will be imported from or exported to.</p>
    ///   - [`batch_import_meta_data_on_create(bool)`](crate::client::fluent_builders::CreateDataRepositoryAssociation::batch_import_meta_data_on_create) / [`set_batch_import_meta_data_on_create(Option<bool>)`](crate::client::fluent_builders::CreateDataRepositoryAssociation::set_batch_import_meta_data_on_create): <p>Set to <code>true</code> to run an import data repository task to import metadata from the data repository to the file system after the data repository association is created. Default is <code>false</code>.</p>
    ///   - [`imported_file_chunk_size(i32)`](crate::client::fluent_builders::CreateDataRepositoryAssociation::imported_file_chunk_size) / [`set_imported_file_chunk_size(Option<i32>)`](crate::client::fluent_builders::CreateDataRepositoryAssociation::set_imported_file_chunk_size): <p>For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.</p>  <p>The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.</p>
    ///   - [`s3(S3DataRepositoryConfiguration)`](crate::client::fluent_builders::CreateDataRepositoryAssociation::s3) / [`set_s3(Option<S3DataRepositoryConfiguration>)`](crate::client::fluent_builders::CreateDataRepositoryAssociation::set_s3): <p>The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateDataRepositoryAssociation::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateDataRepositoryAssociation::set_client_request_token): <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDataRepositoryAssociation::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDataRepositoryAssociation::set_tags): <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
    /// - On success, responds with [`CreateDataRepositoryAssociationOutput`](crate::output::CreateDataRepositoryAssociationOutput) with field(s):
    ///   - [`association(Option<DataRepositoryAssociation>)`](crate::output::CreateDataRepositoryAssociationOutput::association): <p>The response object returned after the data repository association is created.</p>
    /// - On failure, responds with [`SdkError<CreateDataRepositoryAssociationError>`](crate::error::CreateDataRepositoryAssociationError)
    pub fn create_data_repository_association(
        &self,
    ) -> fluent_builders::CreateDataRepositoryAssociation {
        fluent_builders::CreateDataRepositoryAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDataRepositoryTask`](crate::client::fluent_builders::CreateDataRepositoryTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`r#type(DataRepositoryTaskType)`](crate::client::fluent_builders::CreateDataRepositoryTask::type) / [`set_type(Option<DataRepositoryTaskType>)`](crate::client::fluent_builders::CreateDataRepositoryTask::set_type): <p>Specifies the type of data repository task to create.</p>
    ///   - [`paths(Vec<String>)`](crate::client::fluent_builders::CreateDataRepositoryTask::paths) / [`set_paths(Option<Vec<String>>)`](crate::client::fluent_builders::CreateDataRepositoryTask::set_paths): <p>(Optional) The path or paths on the Amazon FSx file system to use when the data repository task is processed. The default path is the file system root directory. The paths you provide need to be relative to the mount point of the file system. If the mount point is <code>/mnt/fsx</code> and <code>/mnt/fsx/path1</code> is a directory or file on the file system you want to export, then the path to provide is <code>path1</code>. If a path that you provide isn't valid, the task fails.</p>
    ///   - [`file_system_id(impl Into<String>)`](crate::client::fluent_builders::CreateDataRepositoryTask::file_system_id) / [`set_file_system_id(Option<String>)`](crate::client::fluent_builders::CreateDataRepositoryTask::set_file_system_id): <p>The globally unique ID of the file system, assigned by Amazon FSx.</p>
    ///   - [`report(CompletionReport)`](crate::client::fluent_builders::CreateDataRepositoryTask::report) / [`set_report(Option<CompletionReport>)`](crate::client::fluent_builders::CreateDataRepositoryTask::set_report): <p>Defines whether or not Amazon FSx provides a CompletionReport once the task has completed. A CompletionReport provides a detailed report on the files that Amazon FSx processed that meet the criteria specified by the <code>Scope</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/task-completion-report.html">Working with Task Completion Reports</a>.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateDataRepositoryTask::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateDataRepositoryTask::set_client_request_token): <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDataRepositoryTask::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDataRepositoryTask::set_tags): <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
    /// - On success, responds with [`CreateDataRepositoryTaskOutput`](crate::output::CreateDataRepositoryTaskOutput) with field(s):
    ///   - [`data_repository_task(Option<DataRepositoryTask>)`](crate::output::CreateDataRepositoryTaskOutput::data_repository_task): <p>The description of the data repository task that you just created.</p>
    /// - On failure, responds with [`SdkError<CreateDataRepositoryTaskError>`](crate::error::CreateDataRepositoryTaskError)
    pub fn create_data_repository_task(&self) -> fluent_builders::CreateDataRepositoryTask {
        fluent_builders::CreateDataRepositoryTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateFileSystem`](crate::client::fluent_builders::CreateFileSystem) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateFileSystem::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateFileSystem::set_client_request_token): <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent creation. This string is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    ///   - [`file_system_type(FileSystemType)`](crate::client::fluent_builders::CreateFileSystem::file_system_type) / [`set_file_system_type(Option<FileSystemType>)`](crate::client::fluent_builders::CreateFileSystem::set_file_system_type): <p>The type of Amazon FSx file system to create. Valid values are <code>WINDOWS</code>, <code>LUSTRE</code>, <code>ONTAP</code>, and <code>OPENZFS</code>.</p>
    ///   - [`storage_capacity(i32)`](crate::client::fluent_builders::CreateFileSystem::storage_capacity) / [`set_storage_capacity(Option<i32>)`](crate::client::fluent_builders::CreateFileSystem::set_storage_capacity): <p>Sets the storage capacity of the file system that you're creating, in gibibytes (GiB).</p>  <p> <b>FSx for Lustre file systems</b> - The amount of storage capacity that you can configure depends on the value that you set for <code>StorageType</code> and the Lustre <code>DeploymentType</code>, as follows:</p>  <ul>   <li> <p>For <code>SCRATCH_2</code>, <code>PERSISTENT_2</code> and <code>PERSISTENT_1</code> deployment types using SSD storage type, the valid values are 1200 GiB, 2400 GiB, and increments of 2400 GiB.</p> </li>   <li> <p>For <code>PERSISTENT_1</code> HDD file systems, valid values are increments of 6000 GiB for 12 MB/s/TiB file systems and increments of 1800 GiB for 40 MB/s/TiB file systems.</p> </li>   <li> <p>For <code>SCRATCH_1</code> deployment type, valid values are 1200 GiB, 2400 GiB, and increments of 3600 GiB.</p> </li>  </ul>  <p> <b>FSx for ONTAP file systems</b> - The amount of storage capacity that you can configure is from 1024 GiB up to 196,608 GiB (192 TiB).</p>  <p> <b>FSx for OpenZFS file systems</b> - The amount of storage capacity that you can configure is from 64 GiB up to 524,288 GiB (512 TiB).</p>  <p> <b>FSx for Windows File Server file systems</b> - The amount of storage capacity that you can configure depends on the value that you set for <code>StorageType</code> as follows:</p>  <ul>   <li> <p>For SSD storage, valid values are 32 GiB-65,536 GiB (64 TiB).</p> </li>   <li> <p>For HDD storage, valid values are 2000 GiB-65,536 GiB (64 TiB).</p> </li>  </ul>
    ///   - [`storage_type(StorageType)`](crate::client::fluent_builders::CreateFileSystem::storage_type) / [`set_storage_type(Option<StorageType>)`](crate::client::fluent_builders::CreateFileSystem::set_storage_type): <p>Sets the storage type for the file system that you're creating. Valid values are <code>SSD</code> and <code>HDD</code>.</p>  <ul>   <li> <p>Set to <code>SSD</code> to use solid state drive storage. SSD is supported on all Windows, Lustre, ONTAP, and OpenZFS deployment types.</p> </li>   <li> <p>Set to <code>HDD</code> to use hard disk drive storage. HDD is supported on <code>SINGLE_AZ_2</code> and <code>MULTI_AZ_1</code> Windows file system deployment types, and on <code>PERSISTENT_1</code> Lustre file system deployment types. </p> </li>  </ul>  <p>Default value is <code>SSD</code>. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/optimize-fsx-costs.html#storage-type-options"> Storage type options</a> in the <i>FSx for Windows File Server User Guide</i> and <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/what-is.html#storage-options">Multiple storage options</a> in the <i>FSx for Lustre User Guide</i>. </p>
    ///   - [`subnet_ids(Vec<String>)`](crate::client::fluent_builders::CreateFileSystem::subnet_ids) / [`set_subnet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateFileSystem::set_subnet_ids): <p>Specifies the IDs of the subnets that the file system will be accessible from. For Windows and ONTAP <code>MULTI_AZ_1</code> deployment types,provide exactly two subnet IDs, one for the preferred file server and one for the standby file server. You specify one of these subnets as the preferred subnet using the <code>WindowsConfiguration &gt; PreferredSubnetID</code> or <code>OntapConfiguration &gt; PreferredSubnetID</code> properties. For more information about Multi-AZ file system configuration, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html"> Availability and durability: Single-AZ and Multi-AZ file systems</a> in the <i>Amazon FSx for Windows User Guide</i> and <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/high-availability-multiAZ.html"> Availability and durability</a> in the <i>Amazon FSx for ONTAP User Guide</i>.</p>  <p>For Windows <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> and all Lustre deployment types, provide exactly one subnet ID. The file server is launched in that subnet's Availability Zone.</p>
    ///   - [`security_group_ids(Vec<String>)`](crate::client::fluent_builders::CreateFileSystem::security_group_ids) / [`set_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateFileSystem::set_security_group_ids): <p>A list of IDs specifying the security groups to apply to all network interfaces created for file system access. This list isn't returned in later requests to describe the file system.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateFileSystem::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateFileSystem::set_tags): <p>The tags to apply to the file system that's being created. The key value of the <code>Name</code> tag appears in the console as the file system name.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateFileSystem::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateFileSystem::set_kms_key_id): <p>The ID of the Key Management Service (KMS) key used to encrypt the file system's data for Amazon FSx for Windows File Server file systems, Amazon FSx for NetApp ONTAP file systems, and Amazon FSx for Lustre <code>PERSISTENT_1</code> and <code>PERSISTENT_2</code> file systems at rest. If this ID isn't specified, the key managed by Amazon FSx is used. The Amazon FSx for Lustre <code>SCRATCH_1</code> and <code>SCRATCH_2</code> file systems are always encrypted at rest using Amazon FSx-managed keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html">Encrypt</a> in the <i>Key Management Service API Reference</i>.</p>
    ///   - [`windows_configuration(CreateFileSystemWindowsConfiguration)`](crate::client::fluent_builders::CreateFileSystem::windows_configuration) / [`set_windows_configuration(Option<CreateFileSystemWindowsConfiguration>)`](crate::client::fluent_builders::CreateFileSystem::set_windows_configuration): <p>The Microsoft Windows configuration for the file system that's being created. </p>
    ///   - [`lustre_configuration(CreateFileSystemLustreConfiguration)`](crate::client::fluent_builders::CreateFileSystem::lustre_configuration) / [`set_lustre_configuration(Option<CreateFileSystemLustreConfiguration>)`](crate::client::fluent_builders::CreateFileSystem::set_lustre_configuration): <p>The Lustre configuration for the file system being created.</p> <note>   <p>The following parameters are not supported for file systems with the <code>Persistent_2</code> deployment type. Instead, use <code>CreateDataRepositoryAssociation</code> to create a data repository association to link your Lustre file system to a data repository.</p>   <ul>    <li> <p> <code>AutoImportPolicy</code> </p> </li>    <li> <p> <code>ExportPath</code> </p> </li>    <li> <p> <code>ImportedChunkSize</code> </p> </li>    <li> <p> <code>ImportPath</code> </p> </li>   </ul>  </note>
    ///   - [`ontap_configuration(CreateFileSystemOntapConfiguration)`](crate::client::fluent_builders::CreateFileSystem::ontap_configuration) / [`set_ontap_configuration(Option<CreateFileSystemOntapConfiguration>)`](crate::client::fluent_builders::CreateFileSystem::set_ontap_configuration): <p>The ONTAP configuration properties of the FSx for ONTAP file system that you are creating.</p>
    ///   - [`file_system_type_version(impl Into<String>)`](crate::client::fluent_builders::CreateFileSystem::file_system_type_version) / [`set_file_system_type_version(Option<String>)`](crate::client::fluent_builders::CreateFileSystem::set_file_system_type_version): <p>(Optional) For FSx for Lustre file systems, sets the Lustre version for the file system that you're creating. Valid values are <code>2.10</code> and <code>2.12</code>:</p>  <ul>   <li> <p>2.10 is supported by the Scratch and Persistent_1 Lustre deployment types.</p> </li>   <li> <p>2.12 is supported by all Lustre deployment types. <code>2.12</code> is required when setting FSx for Lustre <code>DeploymentType</code> to <code>PERSISTENT_2</code>.</p> </li>  </ul>  <p>Default value = <code>2.10</code>, except when <code>DeploymentType</code> is set to <code>PERSISTENT_2</code>, then the default is <code>2.12</code>.</p> <note>   <p>If you set <code>FileSystemTypeVersion</code> to <code>2.10</code> for a <code>PERSISTENT_2</code> Lustre deployment type, the <code>CreateFileSystem</code> operation fails.</p>  </note>
    ///   - [`open_zfs_configuration(CreateFileSystemOpenZfsConfiguration)`](crate::client::fluent_builders::CreateFileSystem::open_zfs_configuration) / [`set_open_zfs_configuration(Option<CreateFileSystemOpenZfsConfiguration>)`](crate::client::fluent_builders::CreateFileSystem::set_open_zfs_configuration): <p>The OpenZFS configuration for the file system that's being created.</p>
    /// - On success, responds with [`CreateFileSystemOutput`](crate::output::CreateFileSystemOutput) with field(s):
    ///   - [`file_system(Option<FileSystem>)`](crate::output::CreateFileSystemOutput::file_system): <p>The configuration of the file system that was created.</p>
    /// - On failure, responds with [`SdkError<CreateFileSystemError>`](crate::error::CreateFileSystemError)
    pub fn create_file_system(&self) -> fluent_builders::CreateFileSystem {
        fluent_builders::CreateFileSystem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateFileSystemFromBackup`](crate::client::fluent_builders::CreateFileSystemFromBackup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`backup_id(impl Into<String>)`](crate::client::fluent_builders::CreateFileSystemFromBackup::backup_id) / [`set_backup_id(Option<String>)`](crate::client::fluent_builders::CreateFileSystemFromBackup::set_backup_id): <p>The ID of the source backup. Specifies the backup that you are copying.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateFileSystemFromBackup::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateFileSystemFromBackup::set_client_request_token): <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent creation. This string is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    ///   - [`subnet_ids(Vec<String>)`](crate::client::fluent_builders::CreateFileSystemFromBackup::subnet_ids) / [`set_subnet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateFileSystemFromBackup::set_subnet_ids): <p>Specifies the IDs of the subnets that the file system will be accessible from. For Windows <code>MULTI_AZ_1</code> file system deployment types, provide exactly two subnet IDs, one for the preferred file server and one for the standby file server. You specify one of these subnets as the preferred subnet using the <code>WindowsConfiguration &gt; PreferredSubnetID</code> property.</p>  <p>Windows <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> file system deployment types, Lustre file systems, and OpenZFS file systems provide exactly one subnet ID. The file server is launched in that subnet's Availability Zone.</p>
    ///   - [`security_group_ids(Vec<String>)`](crate::client::fluent_builders::CreateFileSystemFromBackup::security_group_ids) / [`set_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateFileSystemFromBackup::set_security_group_ids): <p>A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups apply to all network interfaces. This value isn't returned in later <code>DescribeFileSystem</code> requests.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateFileSystemFromBackup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateFileSystemFromBackup::set_tags): <p>The tags to be applied to the file system at file system creation. The key value of the <code>Name</code> tag appears in the console as the file system name.</p>
    ///   - [`windows_configuration(CreateFileSystemWindowsConfiguration)`](crate::client::fluent_builders::CreateFileSystemFromBackup::windows_configuration) / [`set_windows_configuration(Option<CreateFileSystemWindowsConfiguration>)`](crate::client::fluent_builders::CreateFileSystemFromBackup::set_windows_configuration): <p>The configuration for this Microsoft Windows file system.</p>
    ///   - [`lustre_configuration(CreateFileSystemLustreConfiguration)`](crate::client::fluent_builders::CreateFileSystemFromBackup::lustre_configuration) / [`set_lustre_configuration(Option<CreateFileSystemLustreConfiguration>)`](crate::client::fluent_builders::CreateFileSystemFromBackup::set_lustre_configuration): <p>The Lustre configuration for the file system being created.</p> <note>   <p>The following parameters are not supported for file systems with the <code>Persistent_2</code> deployment type. Instead, use <code>CreateDataRepositoryAssociation</code> to create a data repository association to link your Lustre file system to a data repository.</p>   <ul>    <li> <p> <code>AutoImportPolicy</code> </p> </li>    <li> <p> <code>ExportPath</code> </p> </li>    <li> <p> <code>ImportedChunkSize</code> </p> </li>    <li> <p> <code>ImportPath</code> </p> </li>   </ul>  </note>
    ///   - [`storage_type(StorageType)`](crate::client::fluent_builders::CreateFileSystemFromBackup::storage_type) / [`set_storage_type(Option<StorageType>)`](crate::client::fluent_builders::CreateFileSystemFromBackup::set_storage_type): <p>Sets the storage type for the Windows or OpenZFS file system that you're creating from a backup. Valid values are <code>SSD</code> and <code>HDD</code>.</p>  <ul>   <li> <p>Set to <code>SSD</code> to use solid state drive storage. SSD is supported on all Windows and OpenZFS deployment types.</p> </li>   <li> <p>Set to <code>HDD</code> to use hard disk drive storage. HDD is supported on <code>SINGLE_AZ_2</code> and <code>MULTI_AZ_1</code> FSx for Windows File Server file system deployment types.</p> </li>  </ul>  <p> The default value is <code>SSD</code>. </p> <note>   <p>HDD and SSD storage types have different minimum storage capacity requirements. A restored file system's storage capacity is tied to the file system that was backed up. You can create a file system that uses HDD storage from a backup of a file system that used SSD storage if the original SSD file system had a storage capacity of at least 2000 GiB.</p>  </note>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateFileSystemFromBackup::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateFileSystemFromBackup::set_kms_key_id): <p>The ID of the Key Management Service (KMS) key used to encrypt the file system's data for Amazon FSx for Windows File Server file systems, Amazon FSx for NetApp ONTAP file systems, and Amazon FSx for Lustre <code>PERSISTENT_1</code> and <code>PERSISTENT_2</code> file systems at rest. If this ID isn't specified, the key managed by Amazon FSx is used. The Amazon FSx for Lustre <code>SCRATCH_1</code> and <code>SCRATCH_2</code> file systems are always encrypted at rest using Amazon FSx-managed keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html">Encrypt</a> in the <i>Key Management Service API Reference</i>.</p>
    ///   - [`file_system_type_version(impl Into<String>)`](crate::client::fluent_builders::CreateFileSystemFromBackup::file_system_type_version) / [`set_file_system_type_version(Option<String>)`](crate::client::fluent_builders::CreateFileSystemFromBackup::set_file_system_type_version): <p>Sets the version for the Amazon FSx for Lustre file system that you're creating from a backup. Valid values are <code>2.10</code> and <code>2.12</code>.</p>  <p>You don't need to specify <code>FileSystemTypeVersion</code> because it will be applied using the backup's <code>FileSystemTypeVersion</code> setting. If you choose to specify <code>FileSystemTypeVersion</code> when creating from backup, the value must match the backup's <code>FileSystemTypeVersion</code> setting.</p>
    ///   - [`open_zfs_configuration(CreateFileSystemOpenZfsConfiguration)`](crate::client::fluent_builders::CreateFileSystemFromBackup::open_zfs_configuration) / [`set_open_zfs_configuration(Option<CreateFileSystemOpenZfsConfiguration>)`](crate::client::fluent_builders::CreateFileSystemFromBackup::set_open_zfs_configuration): <p>The OpenZFS configuration for the file system that's being created. </p>
    /// - On success, responds with [`CreateFileSystemFromBackupOutput`](crate::output::CreateFileSystemFromBackupOutput) with field(s):
    ///   - [`file_system(Option<FileSystem>)`](crate::output::CreateFileSystemFromBackupOutput::file_system): <p>A description of the file system.</p>
    /// - On failure, responds with [`SdkError<CreateFileSystemFromBackupError>`](crate::error::CreateFileSystemFromBackupError)
    pub fn create_file_system_from_backup(&self) -> fluent_builders::CreateFileSystemFromBackup {
        fluent_builders::CreateFileSystemFromBackup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSnapshot`](crate::client::fluent_builders::CreateSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateSnapshot::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateSnapshot::set_client_request_token): <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateSnapshot::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateSnapshot::set_name): <p>The name of the snapshot. </p>
    ///   - [`volume_id(impl Into<String>)`](crate::client::fluent_builders::CreateSnapshot::volume_id) / [`set_volume_id(Option<String>)`](crate::client::fluent_builders::CreateSnapshot::set_volume_id): <p>The ID of the volume that you are taking a snapshot of.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateSnapshot::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateSnapshot::set_tags): <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
    /// - On success, responds with [`CreateSnapshotOutput`](crate::output::CreateSnapshotOutput) with field(s):
    ///   - [`snapshot(Option<Snapshot>)`](crate::output::CreateSnapshotOutput::snapshot): <p>A description of the snapshot.</p>
    /// - On failure, responds with [`SdkError<CreateSnapshotError>`](crate::error::CreateSnapshotError)
    pub fn create_snapshot(&self) -> fluent_builders::CreateSnapshot {
        fluent_builders::CreateSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateStorageVirtualMachine`](crate::client::fluent_builders::CreateStorageVirtualMachine) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`active_directory_configuration(CreateSvmActiveDirectoryConfiguration)`](crate::client::fluent_builders::CreateStorageVirtualMachine::active_directory_configuration) / [`set_active_directory_configuration(Option<CreateSvmActiveDirectoryConfiguration>)`](crate::client::fluent_builders::CreateStorageVirtualMachine::set_active_directory_configuration): <p>Describes the self-managed Microsoft Active Directory to which you want to join the SVM. Joining an Active Directory provides user authentication and access control for SMB clients, including Microsoft Windows and macOS client accessing the file system.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateStorageVirtualMachine::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateStorageVirtualMachine::set_client_request_token): <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    ///   - [`file_system_id(impl Into<String>)`](crate::client::fluent_builders::CreateStorageVirtualMachine::file_system_id) / [`set_file_system_id(Option<String>)`](crate::client::fluent_builders::CreateStorageVirtualMachine::set_file_system_id): <p>The globally unique ID of the file system, assigned by Amazon FSx.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateStorageVirtualMachine::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateStorageVirtualMachine::set_name): <p>The name of the SVM.</p>
    ///   - [`svm_admin_password(impl Into<String>)`](crate::client::fluent_builders::CreateStorageVirtualMachine::svm_admin_password) / [`set_svm_admin_password(Option<String>)`](crate::client::fluent_builders::CreateStorageVirtualMachine::set_svm_admin_password): <p>The password to use when managing the SVM using the NetApp ONTAP CLI or REST API. If you do not specify a password, you can still use the file system's <code>fsxadmin</code> user to manage the SVM.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateStorageVirtualMachine::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateStorageVirtualMachine::set_tags): <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
    ///   - [`root_volume_security_style(StorageVirtualMachineRootVolumeSecurityStyle)`](crate::client::fluent_builders::CreateStorageVirtualMachine::root_volume_security_style) / [`set_root_volume_security_style(Option<StorageVirtualMachineRootVolumeSecurityStyle>)`](crate::client::fluent_builders::CreateStorageVirtualMachine::set_root_volume_security_style): <p>The security style of the root volume of the SVM. Specify one of the following values:</p>  <ul>   <li> <p> <code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS clients, and an application accessing the data uses a UNIX user as the service account.</p> </li>   <li> <p> <code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are SMB clients, and an application accessing the data uses a Windows user as the service account.</p> </li>   <li> <p> <code>MIXED</code> if the file system is managed by both UNIX and Windows administrators and users consist of both NFS and SMB clients.</p> </li>  </ul>
    /// - On success, responds with [`CreateStorageVirtualMachineOutput`](crate::output::CreateStorageVirtualMachineOutput) with field(s):
    ///   - [`storage_virtual_machine(Option<StorageVirtualMachine>)`](crate::output::CreateStorageVirtualMachineOutput::storage_virtual_machine): <p>Returned after a successful <code>CreateStorageVirtualMachine</code> operation; describes the SVM just created.</p>
    /// - On failure, responds with [`SdkError<CreateStorageVirtualMachineError>`](crate::error::CreateStorageVirtualMachineError)
    pub fn create_storage_virtual_machine(&self) -> fluent_builders::CreateStorageVirtualMachine {
        fluent_builders::CreateStorageVirtualMachine::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateVolume`](crate::client::fluent_builders::CreateVolume) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateVolume::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateVolume::set_client_request_token): <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    ///   - [`volume_type(VolumeType)`](crate::client::fluent_builders::CreateVolume::volume_type) / [`set_volume_type(Option<VolumeType>)`](crate::client::fluent_builders::CreateVolume::set_volume_type): <p>Specifies the type of volume to create; <code>ONTAP</code> and <code>OPENZFS</code> are the only valid volume types.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateVolume::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateVolume::set_name): <p>Specifies the name of the volume that you're creating.</p>
    ///   - [`ontap_configuration(CreateOntapVolumeConfiguration)`](crate::client::fluent_builders::CreateVolume::ontap_configuration) / [`set_ontap_configuration(Option<CreateOntapVolumeConfiguration>)`](crate::client::fluent_builders::CreateVolume::set_ontap_configuration): <p>Specifies the configuration to use when creating the ONTAP volume.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateVolume::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateVolume::set_tags): <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
    ///   - [`open_zfs_configuration(CreateOpenZfsVolumeConfiguration)`](crate::client::fluent_builders::CreateVolume::open_zfs_configuration) / [`set_open_zfs_configuration(Option<CreateOpenZfsVolumeConfiguration>)`](crate::client::fluent_builders::CreateVolume::set_open_zfs_configuration): <p>Specifies the configuration to use when creating the OpenZFS volume.</p>
    /// - On success, responds with [`CreateVolumeOutput`](crate::output::CreateVolumeOutput) with field(s):
    ///   - [`volume(Option<Volume>)`](crate::output::CreateVolumeOutput::volume): <p>Returned after a successful <code>CreateVolume</code> API operation, describing the volume just created.</p>
    /// - On failure, responds with [`SdkError<CreateVolumeError>`](crate::error::CreateVolumeError)
    pub fn create_volume(&self) -> fluent_builders::CreateVolume {
        fluent_builders::CreateVolume::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateVolumeFromBackup`](crate::client::fluent_builders::CreateVolumeFromBackup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`backup_id(impl Into<String>)`](crate::client::fluent_builders::CreateVolumeFromBackup::backup_id) / [`set_backup_id(Option<String>)`](crate::client::fluent_builders::CreateVolumeFromBackup::set_backup_id): <p>The ID of the source backup. Specifies the backup that you are copying.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateVolumeFromBackup::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateVolumeFromBackup::set_client_request_token): <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateVolumeFromBackup::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateVolumeFromBackup::set_name): <p>The name of the new volume you're creating.</p>
    ///   - [`ontap_configuration(CreateOntapVolumeConfiguration)`](crate::client::fluent_builders::CreateVolumeFromBackup::ontap_configuration) / [`set_ontap_configuration(Option<CreateOntapVolumeConfiguration>)`](crate::client::fluent_builders::CreateVolumeFromBackup::set_ontap_configuration): <p>Specifies the configuration of the ONTAP volume that you are creating.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateVolumeFromBackup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateVolumeFromBackup::set_tags): <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
    /// - On success, responds with [`CreateVolumeFromBackupOutput`](crate::output::CreateVolumeFromBackupOutput) with field(s):
    ///   - [`volume(Option<Volume>)`](crate::output::CreateVolumeFromBackupOutput::volume): <p>Returned after a successful <code>CreateVolumeFromBackup</code> API operation, describing the volume just created.</p>
    /// - On failure, responds with [`SdkError<CreateVolumeFromBackupError>`](crate::error::CreateVolumeFromBackupError)
    pub fn create_volume_from_backup(&self) -> fluent_builders::CreateVolumeFromBackup {
        fluent_builders::CreateVolumeFromBackup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBackup`](crate::client::fluent_builders::DeleteBackup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`backup_id(impl Into<String>)`](crate::client::fluent_builders::DeleteBackup::backup_id) / [`set_backup_id(Option<String>)`](crate::client::fluent_builders::DeleteBackup::set_backup_id): <p>The ID of the backup that you want to delete.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::DeleteBackup::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::DeleteBackup::set_client_request_token): <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent deletion. This parameter is automatically filled on your behalf when using the CLI or SDK.</p>
    /// - On success, responds with [`DeleteBackupOutput`](crate::output::DeleteBackupOutput) with field(s):
    ///   - [`backup_id(Option<String>)`](crate::output::DeleteBackupOutput::backup_id): <p>The ID of the backup that was deleted.</p>
    ///   - [`lifecycle(Option<BackupLifecycle>)`](crate::output::DeleteBackupOutput::lifecycle): <p>The lifecycle status of the backup. If the <code>DeleteBackup</code> operation is successful, the status is <code>DELETED</code>.</p>
    /// - On failure, responds with [`SdkError<DeleteBackupError>`](crate::error::DeleteBackupError)
    pub fn delete_backup(&self) -> fluent_builders::DeleteBackup {
        fluent_builders::DeleteBackup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDataRepositoryAssociation`](crate::client::fluent_builders::DeleteDataRepositoryAssociation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`association_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDataRepositoryAssociation::association_id) / [`set_association_id(Option<String>)`](crate::client::fluent_builders::DeleteDataRepositoryAssociation::set_association_id): <p>The ID of the data repository association that you want to delete.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::DeleteDataRepositoryAssociation::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::DeleteDataRepositoryAssociation::set_client_request_token): <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    ///   - [`delete_data_in_file_system(bool)`](crate::client::fluent_builders::DeleteDataRepositoryAssociation::delete_data_in_file_system) / [`set_delete_data_in_file_system(Option<bool>)`](crate::client::fluent_builders::DeleteDataRepositoryAssociation::set_delete_data_in_file_system): <p>Set to <code>true</code> to delete the data in the file system that corresponds to the data repository association.</p>
    /// - On success, responds with [`DeleteDataRepositoryAssociationOutput`](crate::output::DeleteDataRepositoryAssociationOutput) with field(s):
    ///   - [`association_id(Option<String>)`](crate::output::DeleteDataRepositoryAssociationOutput::association_id): <p>The ID of the data repository association being deleted.</p>
    ///   - [`lifecycle(Option<DataRepositoryLifecycle>)`](crate::output::DeleteDataRepositoryAssociationOutput::lifecycle): <p>Describes the lifecycle state of the data repository association being deleted.</p>
    ///   - [`delete_data_in_file_system(Option<bool>)`](crate::output::DeleteDataRepositoryAssociationOutput::delete_data_in_file_system): <p>Indicates whether data in the file system that corresponds to the data repository association is being deleted. Default is <code>false</code>.</p>
    /// - On failure, responds with [`SdkError<DeleteDataRepositoryAssociationError>`](crate::error::DeleteDataRepositoryAssociationError)
    pub fn delete_data_repository_association(
        &self,
    ) -> fluent_builders::DeleteDataRepositoryAssociation {
        fluent_builders::DeleteDataRepositoryAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFileSystem`](crate::client::fluent_builders::DeleteFileSystem) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`file_system_id(impl Into<String>)`](crate::client::fluent_builders::DeleteFileSystem::file_system_id) / [`set_file_system_id(Option<String>)`](crate::client::fluent_builders::DeleteFileSystem::set_file_system_id): <p>The ID of the file system that you want to delete.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::DeleteFileSystem::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::DeleteFileSystem::set_client_request_token): <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent deletion. This token is automatically filled on your behalf when using the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    ///   - [`windows_configuration(DeleteFileSystemWindowsConfiguration)`](crate::client::fluent_builders::DeleteFileSystem::windows_configuration) / [`set_windows_configuration(Option<DeleteFileSystemWindowsConfiguration>)`](crate::client::fluent_builders::DeleteFileSystem::set_windows_configuration): <p>The configuration object for the Microsoft Windows file system used in the <code>DeleteFileSystem</code> operation.</p>
    ///   - [`lustre_configuration(DeleteFileSystemLustreConfiguration)`](crate::client::fluent_builders::DeleteFileSystem::lustre_configuration) / [`set_lustre_configuration(Option<DeleteFileSystemLustreConfiguration>)`](crate::client::fluent_builders::DeleteFileSystem::set_lustre_configuration): <p>The configuration object for the Amazon FSx for Lustre file system being deleted in the <code>DeleteFileSystem</code> operation.</p>
    ///   - [`open_zfs_configuration(DeleteFileSystemOpenZfsConfiguration)`](crate::client::fluent_builders::DeleteFileSystem::open_zfs_configuration) / [`set_open_zfs_configuration(Option<DeleteFileSystemOpenZfsConfiguration>)`](crate::client::fluent_builders::DeleteFileSystem::set_open_zfs_configuration): <p>The configuration object for the OpenZFS file system used in the <code>DeleteFileSystem</code> operation.</p>
    /// - On success, responds with [`DeleteFileSystemOutput`](crate::output::DeleteFileSystemOutput) with field(s):
    ///   - [`file_system_id(Option<String>)`](crate::output::DeleteFileSystemOutput::file_system_id): <p>The ID of the file system that's being deleted.</p>
    ///   - [`lifecycle(Option<FileSystemLifecycle>)`](crate::output::DeleteFileSystemOutput::lifecycle): <p>The file system lifecycle for the deletion request. If the <code>DeleteFileSystem</code> operation is successful, this status is <code>DELETING</code>.</p>
    ///   - [`windows_response(Option<DeleteFileSystemWindowsResponse>)`](crate::output::DeleteFileSystemOutput::windows_response): <p>The response object for the Microsoft Windows file system used in the <code>DeleteFileSystem</code> operation.</p>
    ///   - [`lustre_response(Option<DeleteFileSystemLustreResponse>)`](crate::output::DeleteFileSystemOutput::lustre_response): <p>The response object for the Amazon FSx for Lustre file system being deleted in the <code>DeleteFileSystem</code> operation.</p>
    ///   - [`open_zfs_response(Option<DeleteFileSystemOpenZfsResponse>)`](crate::output::DeleteFileSystemOutput::open_zfs_response): <p>The response object for the OpenZFS file system that's being deleted in the <code>DeleteFileSystem</code> operation.</p>
    /// - On failure, responds with [`SdkError<DeleteFileSystemError>`](crate::error::DeleteFileSystemError)
    pub fn delete_file_system(&self) -> fluent_builders::DeleteFileSystem {
        fluent_builders::DeleteFileSystem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSnapshot`](crate::client::fluent_builders::DeleteSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::DeleteSnapshot::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::DeleteSnapshot::set_client_request_token): <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    ///   - [`snapshot_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSnapshot::snapshot_id) / [`set_snapshot_id(Option<String>)`](crate::client::fluent_builders::DeleteSnapshot::set_snapshot_id): <p>The ID of the snapshot that you want to delete.</p>
    /// - On success, responds with [`DeleteSnapshotOutput`](crate::output::DeleteSnapshotOutput) with field(s):
    ///   - [`snapshot_id(Option<String>)`](crate::output::DeleteSnapshotOutput::snapshot_id): <p>The ID of the deleted snapshot.</p>
    ///   - [`lifecycle(Option<SnapshotLifecycle>)`](crate::output::DeleteSnapshotOutput::lifecycle): <p>The lifecycle status of the snapshot. If the <code>DeleteSnapshot</code> operation is successful, this status is <code>DELETING</code>.</p>
    /// - On failure, responds with [`SdkError<DeleteSnapshotError>`](crate::error::DeleteSnapshotError)
    pub fn delete_snapshot(&self) -> fluent_builders::DeleteSnapshot {
        fluent_builders::DeleteSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteStorageVirtualMachine`](crate::client::fluent_builders::DeleteStorageVirtualMachine) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::DeleteStorageVirtualMachine::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::DeleteStorageVirtualMachine::set_client_request_token): <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    ///   - [`storage_virtual_machine_id(impl Into<String>)`](crate::client::fluent_builders::DeleteStorageVirtualMachine::storage_virtual_machine_id) / [`set_storage_virtual_machine_id(Option<String>)`](crate::client::fluent_builders::DeleteStorageVirtualMachine::set_storage_virtual_machine_id): <p>The ID of the SVM that you want to delete.</p>
    /// - On success, responds with [`DeleteStorageVirtualMachineOutput`](crate::output::DeleteStorageVirtualMachineOutput) with field(s):
    ///   - [`storage_virtual_machine_id(Option<String>)`](crate::output::DeleteStorageVirtualMachineOutput::storage_virtual_machine_id): <p>The ID of the SVM Amazon FSx is deleting.</p>
    ///   - [`lifecycle(Option<StorageVirtualMachineLifecycle>)`](crate::output::DeleteStorageVirtualMachineOutput::lifecycle): <p>Describes the lifecycle state of the SVM being deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteStorageVirtualMachineError>`](crate::error::DeleteStorageVirtualMachineError)
    pub fn delete_storage_virtual_machine(&self) -> fluent_builders::DeleteStorageVirtualMachine {
        fluent_builders::DeleteStorageVirtualMachine::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVolume`](crate::client::fluent_builders::DeleteVolume) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::DeleteVolume::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::DeleteVolume::set_client_request_token): <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    ///   - [`volume_id(impl Into<String>)`](crate::client::fluent_builders::DeleteVolume::volume_id) / [`set_volume_id(Option<String>)`](crate::client::fluent_builders::DeleteVolume::set_volume_id): <p>The ID of the volume that you are deleting.</p>
    ///   - [`ontap_configuration(DeleteVolumeOntapConfiguration)`](crate::client::fluent_builders::DeleteVolume::ontap_configuration) / [`set_ontap_configuration(Option<DeleteVolumeOntapConfiguration>)`](crate::client::fluent_builders::DeleteVolume::set_ontap_configuration): <p>For Amazon FSx for ONTAP volumes, specify whether to take a final backup of the volume and apply tags to the backup. To apply tags to the backup, you must have the <code>fsx:TagResource</code> permission.</p>
    ///   - [`open_zfs_configuration(DeleteVolumeOpenZfsConfiguration)`](crate::client::fluent_builders::DeleteVolume::open_zfs_configuration) / [`set_open_zfs_configuration(Option<DeleteVolumeOpenZfsConfiguration>)`](crate::client::fluent_builders::DeleteVolume::set_open_zfs_configuration): <p>For Amazon FSx for OpenZFS volumes, specify whether to delete all child volumes and snapshots.</p>
    /// - On success, responds with [`DeleteVolumeOutput`](crate::output::DeleteVolumeOutput) with field(s):
    ///   - [`volume_id(Option<String>)`](crate::output::DeleteVolumeOutput::volume_id): <p>The ID of the volume that's being deleted.</p>
    ///   - [`lifecycle(Option<VolumeLifecycle>)`](crate::output::DeleteVolumeOutput::lifecycle): <p>The lifecycle state of the volume being deleted. If the <code>DeleteVolume</code> operation is successful, this value is <code>DELETING</code>.</p>
    ///   - [`ontap_response(Option<DeleteVolumeOntapResponse>)`](crate::output::DeleteVolumeOutput::ontap_response): <p>Returned after a <code>DeleteVolume</code> request, showing the status of the delete request.</p>
    /// - On failure, responds with [`SdkError<DeleteVolumeError>`](crate::error::DeleteVolumeError)
    pub fn delete_volume(&self) -> fluent_builders::DeleteVolume {
        fluent_builders::DeleteVolume::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeBackups`](crate::client::fluent_builders::DescribeBackups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeBackups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`backup_ids(Vec<String>)`](crate::client::fluent_builders::DescribeBackups::backup_ids) / [`set_backup_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeBackups::set_backup_ids): <p>The IDs of the backups that you want to retrieve. This parameter value overrides any filters. If any IDs aren't found, a <code>BackupNotFound</code> error occurs.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeBackups::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeBackups::set_filters): <p>The filters structure. The supported names are <code>file-system-id</code>, <code>backup-type</code>, <code>file-system-type</code>, and <code>volume-id</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeBackups::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeBackups::set_max_results): <p>Maximum number of backups to return in the response. This parameter value must be greater than 0. The number of items that Amazon FSx returns is the minimum of the <code>MaxResults</code> parameter specified in the request and the service's internal maximum number of items per page.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeBackups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeBackups::set_next_token): <p>An opaque pagination token returned from a previous <code>DescribeBackups</code> operation. If a token is present, the operation continues the list from where the returning call left off.</p>
    /// - On success, responds with [`DescribeBackupsOutput`](crate::output::DescribeBackupsOutput) with field(s):
    ///   - [`backups(Option<Vec<Backup>>)`](crate::output::DescribeBackupsOutput::backups): <p>An array of backups.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeBackupsOutput::next_token): <p>A <code>NextToken</code> value is present if there are more backups than returned in the response. You can use the <code>NextToken</code> value in the subsequent request to fetch the backups. </p>
    /// - On failure, responds with [`SdkError<DescribeBackupsError>`](crate::error::DescribeBackupsError)
    pub fn describe_backups(&self) -> fluent_builders::DescribeBackups {
        fluent_builders::DescribeBackups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDataRepositoryAssociations`](crate::client::fluent_builders::DescribeDataRepositoryAssociations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDataRepositoryAssociations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`association_ids(Vec<String>)`](crate::client::fluent_builders::DescribeDataRepositoryAssociations::association_ids) / [`set_association_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeDataRepositoryAssociations::set_association_ids): <p>IDs of the data repository associations whose descriptions you want to retrieve (String).</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeDataRepositoryAssociations::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeDataRepositoryAssociations::set_filters): <p>A list of <code>Filter</code> elements.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeDataRepositoryAssociations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeDataRepositoryAssociations::set_max_results): <p>The maximum number of resources to return in the response. This value must be an integer greater than zero.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeDataRepositoryAssociations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeDataRepositoryAssociations::set_next_token): <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
    /// - On success, responds with [`DescribeDataRepositoryAssociationsOutput`](crate::output::DescribeDataRepositoryAssociationsOutput) with field(s):
    ///   - [`associations(Option<Vec<DataRepositoryAssociation>>)`](crate::output::DescribeDataRepositoryAssociationsOutput::associations): <p>An array of one ore more data repository association descriptions.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeDataRepositoryAssociationsOutput::next_token): <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
    /// - On failure, responds with [`SdkError<DescribeDataRepositoryAssociationsError>`](crate::error::DescribeDataRepositoryAssociationsError)
    pub fn describe_data_repository_associations(
        &self,
    ) -> fluent_builders::DescribeDataRepositoryAssociations {
        fluent_builders::DescribeDataRepositoryAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDataRepositoryTasks`](crate::client::fluent_builders::DescribeDataRepositoryTasks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDataRepositoryTasks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_ids(Vec<String>)`](crate::client::fluent_builders::DescribeDataRepositoryTasks::task_ids) / [`set_task_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeDataRepositoryTasks::set_task_ids): <p>(Optional) IDs of the tasks whose descriptions you want to retrieve (String).</p>
    ///   - [`filters(Vec<DataRepositoryTaskFilter>)`](crate::client::fluent_builders::DescribeDataRepositoryTasks::filters) / [`set_filters(Option<Vec<DataRepositoryTaskFilter>>)`](crate::client::fluent_builders::DescribeDataRepositoryTasks::set_filters): <p>(Optional) You can use filters to narrow the <code>DescribeDataRepositoryTasks</code> response to include just tasks for specific file systems, or tasks in a specific lifecycle state.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeDataRepositoryTasks::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeDataRepositoryTasks::set_max_results): <p>The maximum number of resources to return in the response. This value must be an integer greater than zero.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeDataRepositoryTasks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeDataRepositoryTasks::set_next_token): <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
    /// - On success, responds with [`DescribeDataRepositoryTasksOutput`](crate::output::DescribeDataRepositoryTasksOutput) with field(s):
    ///   - [`data_repository_tasks(Option<Vec<DataRepositoryTask>>)`](crate::output::DescribeDataRepositoryTasksOutput::data_repository_tasks): <p>The collection of data repository task descriptions returned.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeDataRepositoryTasksOutput::next_token): <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
    /// - On failure, responds with [`SdkError<DescribeDataRepositoryTasksError>`](crate::error::DescribeDataRepositoryTasksError)
    pub fn describe_data_repository_tasks(&self) -> fluent_builders::DescribeDataRepositoryTasks {
        fluent_builders::DescribeDataRepositoryTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeFileSystemAliases`](crate::client::fluent_builders::DescribeFileSystemAliases) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::DescribeFileSystemAliases::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::DescribeFileSystemAliases::set_client_request_token): <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    ///   - [`file_system_id(impl Into<String>)`](crate::client::fluent_builders::DescribeFileSystemAliases::file_system_id) / [`set_file_system_id(Option<String>)`](crate::client::fluent_builders::DescribeFileSystemAliases::set_file_system_id): <p>The ID of the file system to return the associated DNS aliases for (String).</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeFileSystemAliases::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeFileSystemAliases::set_max_results): <p>Maximum number of DNS aliases to return in the response (integer). This parameter value must be greater than 0. The number of items that Amazon FSx returns is the minimum of the <code>MaxResults</code> parameter specified in the request and the service's internal maximum number of items per page.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeFileSystemAliases::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeFileSystemAliases::set_next_token): <p>Opaque pagination token returned from a previous <code>DescribeFileSystemAliases</code> operation (String). If a token is included in the request, the action continues the list from where the previous returning call left off.</p>
    /// - On success, responds with [`DescribeFileSystemAliasesOutput`](crate::output::DescribeFileSystemAliasesOutput) with field(s):
    ///   - [`aliases(Option<Vec<Alias>>)`](crate::output::DescribeFileSystemAliasesOutput::aliases): <p>An array of one or more DNS aliases currently associated with the specified file system.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeFileSystemAliasesOutput::next_token): <p>Present if there are more DNS aliases than returned in the response (String). You can use the <code>NextToken</code> value in a later request to fetch additional descriptions. </p>
    /// - On failure, responds with [`SdkError<DescribeFileSystemAliasesError>`](crate::error::DescribeFileSystemAliasesError)
    pub fn describe_file_system_aliases(&self) -> fluent_builders::DescribeFileSystemAliases {
        fluent_builders::DescribeFileSystemAliases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeFileSystems`](crate::client::fluent_builders::DescribeFileSystems) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeFileSystems::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`file_system_ids(Vec<String>)`](crate::client::fluent_builders::DescribeFileSystems::file_system_ids) / [`set_file_system_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeFileSystems::set_file_system_ids): <p>IDs of the file systems whose descriptions you want to retrieve (String).</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeFileSystems::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeFileSystems::set_max_results): <p>Maximum number of file systems to return in the response (integer). This parameter value must be greater than 0. The number of items that Amazon FSx returns is the minimum of the <code>MaxResults</code> parameter specified in the request and the service's internal maximum number of items per page.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeFileSystems::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeFileSystems::set_next_token): <p>Opaque pagination token returned from a previous <code>DescribeFileSystems</code> operation (String). If a token present, the operation continues the list from where the returning call left off.</p>
    /// - On success, responds with [`DescribeFileSystemsOutput`](crate::output::DescribeFileSystemsOutput) with field(s):
    ///   - [`file_systems(Option<Vec<FileSystem>>)`](crate::output::DescribeFileSystemsOutput::file_systems): <p>An array of file system descriptions.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeFileSystemsOutput::next_token): <p>Present if there are more file systems than returned in the response (String). You can use the <code>NextToken</code> value in the later request to fetch the descriptions. </p>
    /// - On failure, responds with [`SdkError<DescribeFileSystemsError>`](crate::error::DescribeFileSystemsError)
    pub fn describe_file_systems(&self) -> fluent_builders::DescribeFileSystems {
        fluent_builders::DescribeFileSystems::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSnapshots`](crate::client::fluent_builders::DescribeSnapshots) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeSnapshots::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`snapshot_ids(Vec<String>)`](crate::client::fluent_builders::DescribeSnapshots::snapshot_ids) / [`set_snapshot_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeSnapshots::set_snapshot_ids): <p>The IDs of the snapshots that you want to retrieve. This parameter value overrides any filters. If any IDs aren't found, a <code>SnapshotNotFound</code> error occurs.</p>
    ///   - [`filters(Vec<SnapshotFilter>)`](crate::client::fluent_builders::DescribeSnapshots::filters) / [`set_filters(Option<Vec<SnapshotFilter>>)`](crate::client::fluent_builders::DescribeSnapshots::set_filters): <p>The filters structure. The supported names are <code>file-system-id</code> or <code>volume-id</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeSnapshots::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeSnapshots::set_max_results): <p>The maximum number of resources to return in the response. This value must be an integer greater than zero.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeSnapshots::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeSnapshots::set_next_token): <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
    /// - On success, responds with [`DescribeSnapshotsOutput`](crate::output::DescribeSnapshotsOutput) with field(s):
    ///   - [`snapshots(Option<Vec<Snapshot>>)`](crate::output::DescribeSnapshotsOutput::snapshots): <p>An array of snapshots.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeSnapshotsOutput::next_token): <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
    /// - On failure, responds with [`SdkError<DescribeSnapshotsError>`](crate::error::DescribeSnapshotsError)
    pub fn describe_snapshots(&self) -> fluent_builders::DescribeSnapshots {
        fluent_builders::DescribeSnapshots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeStorageVirtualMachines`](crate::client::fluent_builders::DescribeStorageVirtualMachines) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeStorageVirtualMachines::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`storage_virtual_machine_ids(Vec<String>)`](crate::client::fluent_builders::DescribeStorageVirtualMachines::storage_virtual_machine_ids) / [`set_storage_virtual_machine_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeStorageVirtualMachines::set_storage_virtual_machine_ids): <p>Enter the ID of one or more SVMs that you want to view.</p>
    ///   - [`filters(Vec<StorageVirtualMachineFilter>)`](crate::client::fluent_builders::DescribeStorageVirtualMachines::filters) / [`set_filters(Option<Vec<StorageVirtualMachineFilter>>)`](crate::client::fluent_builders::DescribeStorageVirtualMachines::set_filters): <p>Enter a filter name:value pair to view a select set of SVMs.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeStorageVirtualMachines::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeStorageVirtualMachines::set_max_results): <p>The maximum number of resources to return in the response. This value must be an integer greater than zero.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeStorageVirtualMachines::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeStorageVirtualMachines::set_next_token): <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
    /// - On success, responds with [`DescribeStorageVirtualMachinesOutput`](crate::output::DescribeStorageVirtualMachinesOutput) with field(s):
    ///   - [`storage_virtual_machines(Option<Vec<StorageVirtualMachine>>)`](crate::output::DescribeStorageVirtualMachinesOutput::storage_virtual_machines): <p>Returned after a successful <code>DescribeStorageVirtualMachines</code> operation, describing each SVM.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeStorageVirtualMachinesOutput::next_token): <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
    /// - On failure, responds with [`SdkError<DescribeStorageVirtualMachinesError>`](crate::error::DescribeStorageVirtualMachinesError)
    pub fn describe_storage_virtual_machines(
        &self,
    ) -> fluent_builders::DescribeStorageVirtualMachines {
        fluent_builders::DescribeStorageVirtualMachines::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeVolumes`](crate::client::fluent_builders::DescribeVolumes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeVolumes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`volume_ids(Vec<String>)`](crate::client::fluent_builders::DescribeVolumes::volume_ids) / [`set_volume_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeVolumes::set_volume_ids): <p>The IDs of the volumes whose descriptions you want to retrieve.</p>
    ///   - [`filters(Vec<VolumeFilter>)`](crate::client::fluent_builders::DescribeVolumes::filters) / [`set_filters(Option<Vec<VolumeFilter>>)`](crate::client::fluent_builders::DescribeVolumes::set_filters): <p>Enter a filter <code>Name</code> and <code>Values</code> pair to view a select set of volumes.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeVolumes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeVolumes::set_max_results): <p>The maximum number of resources to return in the response. This value must be an integer greater than zero.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeVolumes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeVolumes::set_next_token): <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
    /// - On success, responds with [`DescribeVolumesOutput`](crate::output::DescribeVolumesOutput) with field(s):
    ///   - [`volumes(Option<Vec<Volume>>)`](crate::output::DescribeVolumesOutput::volumes): <p>Returned after a successful <code>DescribeVolumes</code> operation, describing each volume.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeVolumesOutput::next_token): <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
    /// - On failure, responds with [`SdkError<DescribeVolumesError>`](crate::error::DescribeVolumesError)
    pub fn describe_volumes(&self) -> fluent_builders::DescribeVolumes {
        fluent_builders::DescribeVolumes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateFileSystemAliases`](crate::client::fluent_builders::DisassociateFileSystemAliases) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::DisassociateFileSystemAliases::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::DisassociateFileSystemAliases::set_client_request_token): <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    ///   - [`file_system_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateFileSystemAliases::file_system_id) / [`set_file_system_id(Option<String>)`](crate::client::fluent_builders::DisassociateFileSystemAliases::set_file_system_id): <p>Specifies the file system from which to disassociate the DNS aliases.</p>
    ///   - [`aliases(Vec<String>)`](crate::client::fluent_builders::DisassociateFileSystemAliases::aliases) / [`set_aliases(Option<Vec<String>>)`](crate::client::fluent_builders::DisassociateFileSystemAliases::set_aliases): <p>An array of one or more DNS alias names to disassociate, or remove, from the file system.</p>
    /// - On success, responds with [`DisassociateFileSystemAliasesOutput`](crate::output::DisassociateFileSystemAliasesOutput) with field(s):
    ///   - [`aliases(Option<Vec<Alias>>)`](crate::output::DisassociateFileSystemAliasesOutput::aliases): <p>An array of one or more DNS aliases that Amazon FSx is attempting to disassociate from the file system.</p>
    /// - On failure, responds with [`SdkError<DisassociateFileSystemAliasesError>`](crate::error::DisassociateFileSystemAliasesError)
    pub fn disassociate_file_system_aliases(
        &self,
    ) -> fluent_builders::DisassociateFileSystemAliases {
        fluent_builders::DisassociateFileSystemAliases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTagsForResource::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The ARN of the Amazon FSx resource that will have its tags listed.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTagsForResource::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTagsForResource::set_max_results): <p>Maximum number of tags to return in the response (integer). This parameter value must be greater than 0. The number of items that Amazon FSx returns is the minimum of the <code>MaxResults</code> parameter specified in the request and the service's internal maximum number of items per page.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_next_token): <p>Opaque pagination token returned from a previous <code>ListTagsForResource</code> operation (String). If a token present, the action continues the list from where the returning call left off.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>A list of tags on the resource.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTagsForResourceOutput::next_token): <p>This is present if there are more tags than returned in the response (String). You can use the <code>NextToken</code> value in the later request to fetch the tags. </p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ReleaseFileSystemNfsV3Locks`](crate::client::fluent_builders::ReleaseFileSystemNfsV3Locks) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`file_system_id(impl Into<String>)`](crate::client::fluent_builders::ReleaseFileSystemNfsV3Locks::file_system_id) / [`set_file_system_id(Option<String>)`](crate::client::fluent_builders::ReleaseFileSystemNfsV3Locks::set_file_system_id): <p>The globally unique ID of the file system, assigned by Amazon FSx.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::ReleaseFileSystemNfsV3Locks::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::ReleaseFileSystemNfsV3Locks::set_client_request_token): <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    /// - On success, responds with [`ReleaseFileSystemNfsV3LocksOutput`](crate::output::ReleaseFileSystemNfsV3LocksOutput) with field(s):
    ///   - [`file_system(Option<FileSystem>)`](crate::output::ReleaseFileSystemNfsV3LocksOutput::file_system): <p>A description of a specific Amazon FSx file system.</p>
    /// - On failure, responds with [`SdkError<ReleaseFileSystemNfsV3LocksError>`](crate::error::ReleaseFileSystemNfsV3LocksError)
    pub fn release_file_system_nfs_v3_locks(&self) -> fluent_builders::ReleaseFileSystemNfsV3Locks {
        fluent_builders::ReleaseFileSystemNfsV3Locks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RestoreVolumeFromSnapshot`](crate::client::fluent_builders::RestoreVolumeFromSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::RestoreVolumeFromSnapshot::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::RestoreVolumeFromSnapshot::set_client_request_token): <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    ///   - [`volume_id(impl Into<String>)`](crate::client::fluent_builders::RestoreVolumeFromSnapshot::volume_id) / [`set_volume_id(Option<String>)`](crate::client::fluent_builders::RestoreVolumeFromSnapshot::set_volume_id): <p>The ID of the volume that you are restoring.</p>
    ///   - [`snapshot_id(impl Into<String>)`](crate::client::fluent_builders::RestoreVolumeFromSnapshot::snapshot_id) / [`set_snapshot_id(Option<String>)`](crate::client::fluent_builders::RestoreVolumeFromSnapshot::set_snapshot_id): <p>The ID of the source snapshot. Specifies the snapshot that you are restoring from.</p>
    ///   - [`options(Vec<RestoreOpenZfsVolumeOption>)`](crate::client::fluent_builders::RestoreVolumeFromSnapshot::options) / [`set_options(Option<Vec<RestoreOpenZfsVolumeOption>>)`](crate::client::fluent_builders::RestoreVolumeFromSnapshot::set_options): <p>The settings used when restoring the specified volume from snapshot. </p>  <ul>   <li> <p> <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> - Deletes snapshots between the current state and the specified snapshot. If there are intermediate snapshots and this option isn't used, <code>RestoreVolumeFromSnapshot</code> fails.</p> </li>   <li> <p> <code>DELETE_CLONED_VOLUMES</code> - Deletes any volumes cloned from this volume. If there are any cloned volumes and this option isn't used, <code>RestoreVolumeFromSnapshot</code> fails.</p> </li>  </ul>
    /// - On success, responds with [`RestoreVolumeFromSnapshotOutput`](crate::output::RestoreVolumeFromSnapshotOutput) with field(s):
    ///   - [`volume_id(Option<String>)`](crate::output::RestoreVolumeFromSnapshotOutput::volume_id): <p>The ID of the volume that you restored.</p>
    ///   - [`lifecycle(Option<VolumeLifecycle>)`](crate::output::RestoreVolumeFromSnapshotOutput::lifecycle): <p>The lifecycle state of the volume being restored.</p>
    /// - On failure, responds with [`SdkError<RestoreVolumeFromSnapshotError>`](crate::error::RestoreVolumeFromSnapshotError)
    pub fn restore_volume_from_snapshot(&self) -> fluent_builders::RestoreVolumeFromSnapshot {
        fluent_builders::RestoreVolumeFromSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the Amazon FSx resource that you want to tag.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>A list of tags for the resource. If a tag with a given key already exists, the value is replaced by the one specified in this parameter.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The ARN of the Amazon FSx resource to untag.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>A list of keys of tags on the resource to untag. In case the tag key doesn't exist, the call will still succeed to be idempotent.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDataRepositoryAssociation`](crate::client::fluent_builders::UpdateDataRepositoryAssociation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`association_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDataRepositoryAssociation::association_id) / [`set_association_id(Option<String>)`](crate::client::fluent_builders::UpdateDataRepositoryAssociation::set_association_id): <p>The ID of the data repository association that you are updating.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::UpdateDataRepositoryAssociation::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::UpdateDataRepositoryAssociation::set_client_request_token): <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    ///   - [`imported_file_chunk_size(i32)`](crate::client::fluent_builders::UpdateDataRepositoryAssociation::imported_file_chunk_size) / [`set_imported_file_chunk_size(Option<i32>)`](crate::client::fluent_builders::UpdateDataRepositoryAssociation::set_imported_file_chunk_size): <p>For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.</p>  <p>The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.</p>
    ///   - [`s3(S3DataRepositoryConfiguration)`](crate::client::fluent_builders::UpdateDataRepositoryAssociation::s3) / [`set_s3(Option<S3DataRepositoryConfiguration>)`](crate::client::fluent_builders::UpdateDataRepositoryAssociation::set_s3): <p>The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.</p>
    /// - On success, responds with [`UpdateDataRepositoryAssociationOutput`](crate::output::UpdateDataRepositoryAssociationOutput) with field(s):
    ///   - [`association(Option<DataRepositoryAssociation>)`](crate::output::UpdateDataRepositoryAssociationOutput::association): <p>The response object returned after the data repository association is updated.</p>
    /// - On failure, responds with [`SdkError<UpdateDataRepositoryAssociationError>`](crate::error::UpdateDataRepositoryAssociationError)
    pub fn update_data_repository_association(
        &self,
    ) -> fluent_builders::UpdateDataRepositoryAssociation {
        fluent_builders::UpdateDataRepositoryAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFileSystem`](crate::client::fluent_builders::UpdateFileSystem) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`file_system_id(impl Into<String>)`](crate::client::fluent_builders::UpdateFileSystem::file_system_id) / [`set_file_system_id(Option<String>)`](crate::client::fluent_builders::UpdateFileSystem::set_file_system_id): <p>The ID of the file system that you are updating.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::UpdateFileSystem::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::UpdateFileSystem::set_client_request_token): <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent updates. This string is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    ///   - [`storage_capacity(i32)`](crate::client::fluent_builders::UpdateFileSystem::storage_capacity) / [`set_storage_capacity(Option<i32>)`](crate::client::fluent_builders::UpdateFileSystem::set_storage_capacity): <p>Use this parameter to increase the storage capacity of an Amazon FSx for Windows File Server, Amazon FSx for Lustre, or Amazon FSx for NetApp ONTAP file system. Specifies the storage capacity target value, in GiB, to increase the storage capacity for the file system that you're updating. </p> <note>   <p>You can't make a storage capacity increase request if there is an existing storage capacity increase request in progress.</p>  </note>  <p>For Windows file systems, the storage capacity target value must be at least 10 percent greater than the current storage capacity value. To increase storage capacity, the file system must have at least 16 MBps of throughput capacity. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html">Managing storage capacity</a> in the <i>Amazon FSx for Windows File Server User Guide</i>.</p>  <p>For Lustre file systems, the storage capacity target value can be the following:</p>  <ul>   <li> <p>For <code>SCRATCH_2</code>, <code>PERSISTENT_1</code>, and <code>PERSISTENT_2 SSD</code> deployment types, valid values are in multiples of 2400 GiB. The value must be greater than the current storage capacity.</p> </li>   <li> <p>For <code>PERSISTENT HDD</code> file systems, valid values are multiples of 6000 GiB for 12-MBps throughput per TiB file systems and multiples of 1800 GiB for 40-MBps throughput per TiB file systems. The values must be greater than the current storage capacity.</p> </li>   <li> <p>For <code>SCRATCH_1</code> file systems, you can't increase the storage capacity.</p> </li>  </ul>  <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-storage-capacity.html">Managing storage and throughput capacity</a> in the <i>Amazon FSx for Lustre User Guide</i>.</p>  <p>For ONTAP file systems, the storage capacity target value must be at least 10 percent greater than the current storage capacity value. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-storage-capacity.html">Managing storage capacity and provisioned IOPS</a> in the <i>Amazon FSx for NetApp ONTAP User Guide</i>.</p>
    ///   - [`windows_configuration(UpdateFileSystemWindowsConfiguration)`](crate::client::fluent_builders::UpdateFileSystem::windows_configuration) / [`set_windows_configuration(Option<UpdateFileSystemWindowsConfiguration>)`](crate::client::fluent_builders::UpdateFileSystem::set_windows_configuration): <p>The configuration updates for an Amazon FSx for Windows File Server file system.</p>
    ///   - [`lustre_configuration(UpdateFileSystemLustreConfiguration)`](crate::client::fluent_builders::UpdateFileSystem::lustre_configuration) / [`set_lustre_configuration(Option<UpdateFileSystemLustreConfiguration>)`](crate::client::fluent_builders::UpdateFileSystem::set_lustre_configuration): <p>The configuration object for Amazon FSx for Lustre file systems used in the <code>UpdateFileSystem</code> operation.</p>
    ///   - [`ontap_configuration(UpdateFileSystemOntapConfiguration)`](crate::client::fluent_builders::UpdateFileSystem::ontap_configuration) / [`set_ontap_configuration(Option<UpdateFileSystemOntapConfiguration>)`](crate::client::fluent_builders::UpdateFileSystem::set_ontap_configuration): <p>The configuration updates for an Amazon FSx for NetApp ONTAP file system.</p>
    ///   - [`open_zfs_configuration(UpdateFileSystemOpenZfsConfiguration)`](crate::client::fluent_builders::UpdateFileSystem::open_zfs_configuration) / [`set_open_zfs_configuration(Option<UpdateFileSystemOpenZfsConfiguration>)`](crate::client::fluent_builders::UpdateFileSystem::set_open_zfs_configuration): <p>The configuration updates for an Amazon FSx for OpenZFS file system.</p>
    /// - On success, responds with [`UpdateFileSystemOutput`](crate::output::UpdateFileSystemOutput) with field(s):
    ///   - [`file_system(Option<FileSystem>)`](crate::output::UpdateFileSystemOutput::file_system): <p>A description of the file system that was updated.</p>
    /// - On failure, responds with [`SdkError<UpdateFileSystemError>`](crate::error::UpdateFileSystemError)
    pub fn update_file_system(&self) -> fluent_builders::UpdateFileSystem {
        fluent_builders::UpdateFileSystem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSnapshot`](crate::client::fluent_builders::UpdateSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::UpdateSnapshot::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::UpdateSnapshot::set_client_request_token): <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateSnapshot::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateSnapshot::set_name): <p>The name of the snapshot to update.</p>
    ///   - [`snapshot_id(impl Into<String>)`](crate::client::fluent_builders::UpdateSnapshot::snapshot_id) / [`set_snapshot_id(Option<String>)`](crate::client::fluent_builders::UpdateSnapshot::set_snapshot_id): <p>The ID of the snapshot that you want to update, in the format <code>fsvolsnap-0123456789abcdef0</code>.</p>
    /// - On success, responds with [`UpdateSnapshotOutput`](crate::output::UpdateSnapshotOutput) with field(s):
    ///   - [`snapshot(Option<Snapshot>)`](crate::output::UpdateSnapshotOutput::snapshot): <p>Returned after a successful <code>UpdateSnapshot</code> operation, describing the snapshot that you updated.</p>
    /// - On failure, responds with [`SdkError<UpdateSnapshotError>`](crate::error::UpdateSnapshotError)
    pub fn update_snapshot(&self) -> fluent_builders::UpdateSnapshot {
        fluent_builders::UpdateSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateStorageVirtualMachine`](crate::client::fluent_builders::UpdateStorageVirtualMachine) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`active_directory_configuration(UpdateSvmActiveDirectoryConfiguration)`](crate::client::fluent_builders::UpdateStorageVirtualMachine::active_directory_configuration) / [`set_active_directory_configuration(Option<UpdateSvmActiveDirectoryConfiguration>)`](crate::client::fluent_builders::UpdateStorageVirtualMachine::set_active_directory_configuration): <p>Updates the Microsoft Active Directory (AD) configuration for an SVM that is joined to an AD.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::UpdateStorageVirtualMachine::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::UpdateStorageVirtualMachine::set_client_request_token): <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    ///   - [`storage_virtual_machine_id(impl Into<String>)`](crate::client::fluent_builders::UpdateStorageVirtualMachine::storage_virtual_machine_id) / [`set_storage_virtual_machine_id(Option<String>)`](crate::client::fluent_builders::UpdateStorageVirtualMachine::set_storage_virtual_machine_id): <p>The ID of the SVM that you want to update, in the format <code>svm-0123456789abcdef0</code>.</p>
    ///   - [`svm_admin_password(impl Into<String>)`](crate::client::fluent_builders::UpdateStorageVirtualMachine::svm_admin_password) / [`set_svm_admin_password(Option<String>)`](crate::client::fluent_builders::UpdateStorageVirtualMachine::set_svm_admin_password): <p>Enter a new SvmAdminPassword if you are updating it.</p>
    /// - On success, responds with [`UpdateStorageVirtualMachineOutput`](crate::output::UpdateStorageVirtualMachineOutput) with field(s):
    ///   - [`storage_virtual_machine(Option<StorageVirtualMachine>)`](crate::output::UpdateStorageVirtualMachineOutput::storage_virtual_machine): <p>Describes the Amazon FSx for NetApp ONTAP storage virtual machine (SVM) configuraton.</p>
    /// - On failure, responds with [`SdkError<UpdateStorageVirtualMachineError>`](crate::error::UpdateStorageVirtualMachineError)
    pub fn update_storage_virtual_machine(&self) -> fluent_builders::UpdateStorageVirtualMachine {
        fluent_builders::UpdateStorageVirtualMachine::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateVolume`](crate::client::fluent_builders::UpdateVolume) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::UpdateVolume::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::UpdateVolume::set_client_request_token): <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    ///   - [`volume_id(impl Into<String>)`](crate::client::fluent_builders::UpdateVolume::volume_id) / [`set_volume_id(Option<String>)`](crate::client::fluent_builders::UpdateVolume::set_volume_id): <p>The ID of the volume that you want to update, in the format <code>fsvol-0123456789abcdef0</code>.</p>
    ///   - [`ontap_configuration(UpdateOntapVolumeConfiguration)`](crate::client::fluent_builders::UpdateVolume::ontap_configuration) / [`set_ontap_configuration(Option<UpdateOntapVolumeConfiguration>)`](crate::client::fluent_builders::UpdateVolume::set_ontap_configuration): <p>The configuration of the ONTAP volume that you are updating.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateVolume::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateVolume::set_name): <p>The name of the OpenZFS volume. OpenZFS root volumes are automatically named <code>FSX</code>. Child volume names must be unique among their parent volume's children. The name of the volume is part of the mount string for the OpenZFS volume. </p>
    ///   - [`open_zfs_configuration(UpdateOpenZfsVolumeConfiguration)`](crate::client::fluent_builders::UpdateVolume::open_zfs_configuration) / [`set_open_zfs_configuration(Option<UpdateOpenZfsVolumeConfiguration>)`](crate::client::fluent_builders::UpdateVolume::set_open_zfs_configuration): <p>The configuration of the OpenZFS volume that you are updating.</p>
    /// - On success, responds with [`UpdateVolumeOutput`](crate::output::UpdateVolumeOutput) with field(s):
    ///   - [`volume(Option<Volume>)`](crate::output::UpdateVolumeOutput::volume): <p>A description of the volume just updated. Returned after a successful <code>UpdateVolume</code> API operation.</p>
    /// - On failure, responds with [`SdkError<UpdateVolumeError>`](crate::error::UpdateVolumeError)
    pub fn update_volume(&self) -> fluent_builders::UpdateVolume {
        fluent_builders::UpdateVolume::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateFileSystemAliases`.
    ///
    /// <p>Use this action to associate one or more Domain Name Server (DNS) aliases with an existing Amazon FSx for Windows File Server file system. A file system can have a maximum of 50 DNS aliases associated with it at any one time. If you try to associate a DNS alias that is already associated with the file system, FSx takes no action on that alias in the request. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html">Working with DNS Aliases</a> and <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/walkthrough05-file-system-custom-CNAME.html">Walkthrough 5: Using DNS aliases to access your file system</a>, including additional steps you must take to be able to access your file system using a DNS alias.</p>
    /// <p>The system response shows the DNS aliases that Amazon FSx is attempting to associate with the file system. Use the API operation to monitor the status of the aliases Amazon FSx is associating with the file system.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateFileSystemAliases {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_file_system_aliases_input::Builder,
    }
    impl AssociateFileSystemAliases {
        /// Creates a new `AssociateFileSystemAliases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateFileSystemAliasesOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateFileSystemAliasesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>Specifies the file system with which you want to associate one or more DNS aliases.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(input.into());
            self
        }
        /// <p>Specifies the file system with which you want to associate one or more DNS aliases.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
        /// Appends an item to `Aliases`.
        ///
        /// To override the contents of this collection use [`set_aliases`](Self::set_aliases).
        ///
        /// <p>An array of one or more DNS alias names to associate with the file system. The alias name has to comply with the following formatting requirements:</p>
        /// <ul>
        /// <li> <p>Formatted as a fully-qualified domain name (FQDN), <i> <code>hostname.domain</code> </i>, for example, <code>accounting.corp.example.com</code>.</p> </li>
        /// <li> <p>Can contain alphanumeric characters and the hyphen (-).</p> </li>
        /// <li> <p>Cannot start or end with a hyphen.</p> </li>
        /// <li> <p>Can start with a numeric.</p> </li>
        /// </ul>
        /// <p>For DNS alias names, Amazon FSx stores alphabetic characters as lowercase letters (a-z), regardless of how you specify them: as uppercase letters, lowercase letters, or the corresponding letters in escape codes.</p>
        pub fn aliases(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aliases(input.into());
            self
        }
        /// <p>An array of one or more DNS alias names to associate with the file system. The alias name has to comply with the following formatting requirements:</p>
        /// <ul>
        /// <li> <p>Formatted as a fully-qualified domain name (FQDN), <i> <code>hostname.domain</code> </i>, for example, <code>accounting.corp.example.com</code>.</p> </li>
        /// <li> <p>Can contain alphanumeric characters and the hyphen (-).</p> </li>
        /// <li> <p>Cannot start or end with a hyphen.</p> </li>
        /// <li> <p>Can start with a numeric.</p> </li>
        /// </ul>
        /// <p>For DNS alias names, Amazon FSx stores alphabetic characters as lowercase letters (a-z), regardless of how you specify them: as uppercase letters, lowercase letters, or the corresponding letters in escape codes.</p>
        pub fn set_aliases(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_aliases(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelDataRepositoryTask`.
    ///
    /// <p>Cancels an existing Amazon FSx for Lustre data repository task if that task is in either the <code>PENDING</code> or <code>EXECUTING</code> state. When you cancel a task, Amazon FSx does the following.</p>
    /// <ul>
    /// <li> <p>Any files that FSx has already exported are not reverted.</p> </li>
    /// <li> <p>FSx continues to export any files that are "in-flight" when the cancel operation is received.</p> </li>
    /// <li> <p>FSx does not export any files that have not yet been exported.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelDataRepositoryTask {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::cancel_data_repository_task_input::Builder,
    }
    impl CancelDataRepositoryTask {
        /// Creates a new `CancelDataRepositoryTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelDataRepositoryTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelDataRepositoryTaskError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the data repository task to cancel.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(input.into());
            self
        }
        /// <p>Specifies the data repository task to cancel.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopyBackup`.
    ///
    /// <p>Copies an existing backup within the same Amazon Web Services account to another Amazon Web Services Region (cross-Region copy) or within the same Amazon Web Services Region (in-Region copy). You can have up to five backup copy requests in progress to a single destination Region per account.</p>
    /// <p>You can use cross-Region backup copies for cross-Region disaster recovery. You can periodically take backups and copy them to another Region so that in the event of a disaster in the primary Region, you can restore from backup and recover availability quickly in the other Region. You can make cross-Region copies only within your Amazon Web Services partition. A partition is a grouping of Regions. Amazon Web Services currently has three partitions: <code>aws</code> (Standard Regions), <code>aws-cn</code> (China Regions), and <code>aws-us-gov</code> (Amazon Web Services GovCloud [US] Regions).</p>
    /// <p>You can also use backup copies to clone your file dataset to another Region or within the same Region.</p>
    /// <p>You can use the <code>SourceRegion</code> parameter to specify the Amazon Web Services Region from which the backup will be copied. For example, if you make the call from the <code>us-west-1</code> Region and want to copy a backup from the <code>us-east-2</code> Region, you specify <code>us-east-2</code> in the <code>SourceRegion</code> parameter to make a cross-Region copy. If you don't specify a Region, the backup copy is created in the same Region where the request is sent from (in-Region copy).</p>
    /// <p>For more information about creating backup copies, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html#copy-backups"> Copying backups</a> in the <i>Amazon FSx for Windows User Guide</i>, <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html#copy-backups">Copying backups</a> in the <i>Amazon FSx for Lustre User Guide</i>, and <a href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/using-backups.html#copy-backups">Copying backups</a> in the <i>Amazon FSx for OpenZFS User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CopyBackup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::copy_backup_input::Builder,
    }
    impl CopyBackup {
        /// Creates a new `CopyBackup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopyBackupOutput,
            aws_smithy_http::result::SdkError<crate::error::CopyBackupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The ID of the source backup. Specifies the ID of the backup that's being copied.</p>
        pub fn source_backup_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_backup_id(input.into());
            self
        }
        /// <p>The ID of the source backup. Specifies the ID of the backup that's being copied.</p>
        pub fn set_source_backup_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_backup_id(input);
            self
        }
        /// <p>The source Amazon Web Services Region of the backup. Specifies the Amazon Web Services Region from which the backup is being copied. The source and destination Regions must be in the same Amazon Web Services partition. If you don't specify a Region, <code>SourceRegion</code> defaults to the Region where the request is sent from (in-Region copy).</p>
        pub fn source_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_region(input.into());
            self
        }
        /// <p>The source Amazon Web Services Region of the backup. Specifies the Amazon Web Services Region from which the backup is being copied. The source and destination Regions must be in the same Amazon Web Services partition. If you don't specify a Region, <code>SourceRegion</code> defaults to the Region where the request is sent from (in-Region copy).</p>
        pub fn set_source_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_region(input);
            self
        }
        /// <p>The ID of the Key Management Service (KMS) key used to encrypt the file system's data for Amazon FSx for Windows File Server file systems, Amazon FSx for NetApp ONTAP file systems, and Amazon FSx for Lustre <code>PERSISTENT_1</code> and <code>PERSISTENT_2</code> file systems at rest. If this ID isn't specified, the key managed by Amazon FSx is used. The Amazon FSx for Lustre <code>SCRATCH_1</code> and <code>SCRATCH_2</code> file systems are always encrypted at rest using Amazon FSx-managed keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html">Encrypt</a> in the <i>Key Management Service API Reference</i>.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The ID of the Key Management Service (KMS) key used to encrypt the file system's data for Amazon FSx for Windows File Server file systems, Amazon FSx for NetApp ONTAP file systems, and Amazon FSx for Lustre <code>PERSISTENT_1</code> and <code>PERSISTENT_2</code> file systems at rest. If this ID isn't specified, the key managed by Amazon FSx is used. The Amazon FSx for Lustre <code>SCRATCH_1</code> and <code>SCRATCH_2</code> file systems are always encrypted at rest using Amazon FSx-managed keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html">Encrypt</a> in the <i>Key Management Service API Reference</i>.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>A Boolean flag indicating whether tags from the source backup should be copied to the backup copy. This value defaults to <code>false</code>.</p>
        /// <p>If you set <code>CopyTags</code> to <code>true</code> and the source backup has existing tags, you can use the <code>Tags</code> parameter to create new tags, provided that the sum of the source backup tags and the new tags doesn't exceed 50. Both sets of tags are merged. If there are tag conflicts (for example, two tags with the same key but different values), the tags created with the <code>Tags</code> parameter take precedence.</p>
        pub fn copy_tags(mut self, input: bool) -> Self {
            self.inner = self.inner.copy_tags(input);
            self
        }
        /// <p>A Boolean flag indicating whether tags from the source backup should be copied to the backup copy. This value defaults to <code>false</code>.</p>
        /// <p>If you set <code>CopyTags</code> to <code>true</code> and the source backup has existing tags, you can use the <code>Tags</code> parameter to create new tags, provided that the sum of the source backup tags and the new tags doesn't exceed 50. Both sets of tags are merged. If there are tag conflicts (for example, two tags with the same key but different values), the tags created with the <code>Tags</code> parameter take precedence.</p>
        pub fn set_copy_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_copy_tags(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBackup`.
    ///
    /// <p>Creates a backup of an existing Amazon FSx for Windows File Server file system, Amazon FSx for Lustre file system, Amazon FSx for NetApp ONTAP volume, or Amazon FSx for OpenZFS file system. We recommend creating regular backups so that you can restore a file system or volume from a backup if an issue arises with the original file system or volume.</p>
    /// <p>For Amazon FSx for Lustre file systems, you can create a backup only for file systems that have the following configuration:</p>
    /// <ul>
    /// <li> <p>A Persistent deployment type</p> </li>
    /// <li> <p>Are <i>not</i> linked to a data repository</p> </li>
    /// </ul>
    /// <p>For more information about backups, see the following:</p>
    /// <ul>
    /// <li> <p>For Amazon FSx for Lustre, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html">Working with FSx for Lustre backups</a>.</p> </li>
    /// <li> <p>For Amazon FSx for Windows, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html">Working with FSx for Windows backups</a>.</p> </li>
    /// <li> <p>For Amazon FSx for NetApp ONTAP, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/using-backups.html">Working with FSx for NetApp ONTAP backups</a>.</p> </li>
    /// <li> <p>For Amazon FSx for OpenZFS, see <a href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/using-backups.html">Working with FSx for OpenZFS backups</a>.</p> </li>
    /// </ul>
    /// <p>If a backup with the specified client request token exists and the parameters match, this operation returns the description of the existing backup. If a backup with the specified client request token exists and the parameters don't match, this operation returns <code>IncompatibleParameterError</code>. If a backup with the specified client request token doesn't exist, <code>CreateBackup</code> does the following: </p>
    /// <ul>
    /// <li> <p>Creates a new Amazon FSx backup with an assigned ID, and an initial lifecycle state of <code>CREATING</code>.</p> </li>
    /// <li> <p>Returns the description of the backup.</p> </li>
    /// </ul>
    /// <p>By using the idempotent operation, you can retry a <code>CreateBackup</code> operation without the risk of creating an extra backup. This approach can be useful when an initial call fails in a way that makes it unclear whether a backup was created. If you use the same client request token and the initial call created a backup, the operation returns a successful result because all the parameters are the same.</p>
    /// <p>The <code>CreateBackup</code> operation returns while the backup's lifecycle state is still <code>CREATING</code>. You can check the backup creation status by calling the <a href="https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeBackups.html">DescribeBackups</a> operation, which returns the backup state along with other information.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateBackup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_backup_input::Builder,
    }
    impl CreateBackup {
        /// Creates a new `CreateBackup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBackupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBackupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the file system to back up.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(input.into());
            self
        }
        /// <p>The ID of the file system to back up.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
        /// <p>(Optional) A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent creation. This string is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>(Optional) A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent creation. This string is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>(Optional) The tags to apply to the backup at backup creation. The key value of the <code>Name</code> tag appears in the console as the backup name. If you have set <code>CopyTagsToBackups</code> to <code>true</code>, and you specify one or more tags using the <code>CreateBackup</code> operation, no existing file system tags are copied from the file system to the backup.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>(Optional) The tags to apply to the backup at backup creation. The key value of the <code>Name</code> tag appears in the console as the backup name. If you have set <code>CopyTagsToBackups</code> to <code>true</code>, and you specify one or more tags using the <code>CreateBackup</code> operation, no existing file system tags are copied from the file system to the backup.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>(Optional) The ID of the FSx for ONTAP volume to back up.</p>
        pub fn volume_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_id(input.into());
            self
        }
        /// <p>(Optional) The ID of the FSx for ONTAP volume to back up.</p>
        pub fn set_volume_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_volume_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDataRepositoryAssociation`.
    ///
    /// <p>Creates an Amazon FSx for Lustre data repository association (DRA). A data repository association is a link between a directory on the file system and an Amazon S3 bucket or prefix. You can have a maximum of 8 data repository associations on a file system. Data repository associations are supported only for file systems with the <code>Persistent_2</code> deployment type.</p>
    /// <p>Each data repository association must have a unique Amazon FSx file system directory and a unique S3 bucket or prefix associated with it. You can configure a data repository association for automatic import only, for automatic export only, or for both. To learn more about linking a data repository to your file system, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/create-dra-linked-data-repo.html">Linking your file system to an S3 bucket</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDataRepositoryAssociation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_data_repository_association_input::Builder,
    }
    impl CreateDataRepositoryAssociation {
        /// Creates a new `CreateDataRepositoryAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDataRepositoryAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDataRepositoryAssociationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The globally unique ID of the file system, assigned by Amazon FSx.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(input.into());
            self
        }
        /// <p>The globally unique ID of the file system, assigned by Amazon FSx.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
        /// <p>A path on the file system that points to a high-level directory (such as <code>/ns1/</code>) or subdirectory (such as <code>/ns1/subdir/</code>) that will be mapped 1-1 with <code>DataRepositoryPath</code>. The leading forward slash in the name is required. Two data repository associations cannot have overlapping file system paths. For example, if a data repository is associated with file system path <code>/ns1/</code>, then you cannot link another data repository with file system path <code>/ns1/ns2</code>.</p>
        /// <p>This path specifies where in your file system files will be exported from or imported to. This file system directory can be linked to only one Amazon S3 bucket, and no other S3 bucket can be linked to the directory.</p> <note>
        /// <p>If you specify only a forward slash (<code>/</code>) as the file system path, you can link only 1 data repository to the file system. You can only specify "/" as the file system path for the first data repository associated with a file system.</p>
        /// </note>
        pub fn file_system_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_path(input.into());
            self
        }
        /// <p>A path on the file system that points to a high-level directory (such as <code>/ns1/</code>) or subdirectory (such as <code>/ns1/subdir/</code>) that will be mapped 1-1 with <code>DataRepositoryPath</code>. The leading forward slash in the name is required. Two data repository associations cannot have overlapping file system paths. For example, if a data repository is associated with file system path <code>/ns1/</code>, then you cannot link another data repository with file system path <code>/ns1/ns2</code>.</p>
        /// <p>This path specifies where in your file system files will be exported from or imported to. This file system directory can be linked to only one Amazon S3 bucket, and no other S3 bucket can be linked to the directory.</p> <note>
        /// <p>If you specify only a forward slash (<code>/</code>) as the file system path, you can link only 1 data repository to the file system. You can only specify "/" as the file system path for the first data repository associated with a file system.</p>
        /// </note>
        pub fn set_file_system_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_path(input);
            self
        }
        /// <p>The path to the Amazon S3 data repository that will be linked to the file system. The path can be an S3 bucket or prefix in the format <code>s3://myBucket/myPrefix/</code>. This path specifies where in the S3 data repository files will be imported from or exported to.</p>
        pub fn data_repository_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_repository_path(input.into());
            self
        }
        /// <p>The path to the Amazon S3 data repository that will be linked to the file system. The path can be an S3 bucket or prefix in the format <code>s3://myBucket/myPrefix/</code>. This path specifies where in the S3 data repository files will be imported from or exported to.</p>
        pub fn set_data_repository_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_repository_path(input);
            self
        }
        /// <p>Set to <code>true</code> to run an import data repository task to import metadata from the data repository to the file system after the data repository association is created. Default is <code>false</code>.</p>
        pub fn batch_import_meta_data_on_create(mut self, input: bool) -> Self {
            self.inner = self.inner.batch_import_meta_data_on_create(input);
            self
        }
        /// <p>Set to <code>true</code> to run an import data repository task to import metadata from the data repository to the file system after the data repository association is created. Default is <code>false</code>.</p>
        pub fn set_batch_import_meta_data_on_create(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_batch_import_meta_data_on_create(input);
            self
        }
        /// <p>For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.</p>
        /// <p>The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.</p>
        pub fn imported_file_chunk_size(mut self, input: i32) -> Self {
            self.inner = self.inner.imported_file_chunk_size(input);
            self
        }
        /// <p>For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.</p>
        /// <p>The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.</p>
        pub fn set_imported_file_chunk_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_imported_file_chunk_size(input);
            self
        }
        /// <p>The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.</p>
        pub fn s3(mut self, input: crate::model::S3DataRepositoryConfiguration) -> Self {
            self.inner = self.inner.s3(input);
            self
        }
        /// <p>The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.</p>
        pub fn set_s3(
            mut self,
            input: std::option::Option<crate::model::S3DataRepositoryConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_s3(input);
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDataRepositoryTask`.
    ///
    /// <p>Creates an Amazon FSx for Lustre data repository task. You use data repository tasks to perform bulk operations between your Amazon FSx file system and its linked data repositories. An example of a data repository task is exporting any data and metadata changes, including POSIX metadata, to files, directories, and symbolic links (symlinks) from your FSx file system to a linked data repository. A <code>CreateDataRepositoryTask</code> operation will fail if a data repository is not linked to the FSx file system. To learn more about data repository tasks, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-repository-tasks.html">Data Repository Tasks</a>. To learn more about linking a data repository to your file system, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/create-dra-linked-data-repo.html">Linking your file system to an S3 bucket</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDataRepositoryTask {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_data_repository_task_input::Builder,
    }
    impl CreateDataRepositoryTask {
        /// Creates a new `CreateDataRepositoryTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDataRepositoryTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDataRepositoryTaskError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the type of data repository task to create.</p>
        pub fn r#type(mut self, input: crate::model::DataRepositoryTaskType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>Specifies the type of data repository task to create.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DataRepositoryTaskType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// Appends an item to `Paths`.
        ///
        /// To override the contents of this collection use [`set_paths`](Self::set_paths).
        ///
        /// <p>(Optional) The path or paths on the Amazon FSx file system to use when the data repository task is processed. The default path is the file system root directory. The paths you provide need to be relative to the mount point of the file system. If the mount point is <code>/mnt/fsx</code> and <code>/mnt/fsx/path1</code> is a directory or file on the file system you want to export, then the path to provide is <code>path1</code>. If a path that you provide isn't valid, the task fails.</p>
        pub fn paths(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.paths(input.into());
            self
        }
        /// <p>(Optional) The path or paths on the Amazon FSx file system to use when the data repository task is processed. The default path is the file system root directory. The paths you provide need to be relative to the mount point of the file system. If the mount point is <code>/mnt/fsx</code> and <code>/mnt/fsx/path1</code> is a directory or file on the file system you want to export, then the path to provide is <code>path1</code>. If a path that you provide isn't valid, the task fails.</p>
        pub fn set_paths(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_paths(input);
            self
        }
        /// <p>The globally unique ID of the file system, assigned by Amazon FSx.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(input.into());
            self
        }
        /// <p>The globally unique ID of the file system, assigned by Amazon FSx.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
        /// <p>Defines whether or not Amazon FSx provides a CompletionReport once the task has completed. A CompletionReport provides a detailed report on the files that Amazon FSx processed that meet the criteria specified by the <code>Scope</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/task-completion-report.html">Working with Task Completion Reports</a>.</p>
        pub fn report(mut self, input: crate::model::CompletionReport) -> Self {
            self.inner = self.inner.report(input);
            self
        }
        /// <p>Defines whether or not Amazon FSx provides a CompletionReport once the task has completed. A CompletionReport provides a detailed report on the files that Amazon FSx processed that meet the criteria specified by the <code>Scope</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/task-completion-report.html">Working with Task Completion Reports</a>.</p>
        pub fn set_report(
            mut self,
            input: std::option::Option<crate::model::CompletionReport>,
        ) -> Self {
            self.inner = self.inner.set_report(input);
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFileSystem`.
    ///
    /// <p>Creates a new, empty Amazon FSx file system. You can create the following supported Amazon FSx file systems using the <code>CreateFileSystem</code> API operation:</p>
    /// <ul>
    /// <li> <p>Amazon FSx for Lustre</p> </li>
    /// <li> <p>Amazon FSx for NetApp ONTAP</p> </li>
    /// <li> <p>Amazon FSx for OpenZFS</p> </li>
    /// <li> <p>Amazon FSx for Windows File Server</p> </li>
    /// </ul>
    /// <p>This operation requires a client request token in the request that Amazon FSx uses to ensure idempotent creation. This means that calling the operation multiple times with the same client request token has no effect. By using the idempotent operation, you can retry a <code>CreateFileSystem</code> operation without the risk of creating an extra file system. This approach can be useful when an initial call fails in a way that makes it unclear whether a file system was created. Examples are if a transport level timeout occurred, or your connection was reset. If you use the same client request token and the initial call created a file system, the client receives success as long as the parameters are the same.</p>
    /// <p>If a file system with the specified client request token exists and the parameters match, <code>CreateFileSystem</code> returns the description of the existing file system. If a file system with the specified client request token exists and the parameters don't match, this call returns <code>IncompatibleParameterError</code>. If a file system with the specified client request token doesn't exist, <code>CreateFileSystem</code> does the following: </p>
    /// <ul>
    /// <li> <p>Creates a new, empty Amazon FSx file system with an assigned ID, and an initial lifecycle state of <code>CREATING</code>.</p> </li>
    /// <li> <p>Returns the description of the file system.</p> </li>
    /// </ul>
    /// <p>This operation requires a client request token in the request that Amazon FSx uses to ensure idempotent creation. This means that calling the operation multiple times with the same client request token has no effect. By using the idempotent operation, you can retry a <code>CreateFileSystem</code> operation without the risk of creating an extra file system. This approach can be useful when an initial call fails in a way that makes it unclear whether a file system was created. Examples are if a transport-level timeout occurred, or your connection was reset. If you use the same client request token and the initial call created a file system, the client receives a success message as long as the parameters are the same.</p> <note>
    /// <p>The <code>CreateFileSystem</code> call returns while the file system's lifecycle state is still <code>CREATING</code>. You can check the file-system creation status by calling the <a href="https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeFileSystems.html">DescribeFileSystems</a> operation, which returns the file system state along with other information.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFileSystem {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_file_system_input::Builder,
    }
    impl CreateFileSystem {
        /// Creates a new `CreateFileSystem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFileSystemOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFileSystemError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent creation. This string is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent creation. This string is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The type of Amazon FSx file system to create. Valid values are <code>WINDOWS</code>, <code>LUSTRE</code>, <code>ONTAP</code>, and <code>OPENZFS</code>.</p>
        pub fn file_system_type(mut self, input: crate::model::FileSystemType) -> Self {
            self.inner = self.inner.file_system_type(input);
            self
        }
        /// <p>The type of Amazon FSx file system to create. Valid values are <code>WINDOWS</code>, <code>LUSTRE</code>, <code>ONTAP</code>, and <code>OPENZFS</code>.</p>
        pub fn set_file_system_type(
            mut self,
            input: std::option::Option<crate::model::FileSystemType>,
        ) -> Self {
            self.inner = self.inner.set_file_system_type(input);
            self
        }
        /// <p>Sets the storage capacity of the file system that you're creating, in gibibytes (GiB).</p>
        /// <p> <b>FSx for Lustre file systems</b> - The amount of storage capacity that you can configure depends on the value that you set for <code>StorageType</code> and the Lustre <code>DeploymentType</code>, as follows:</p>
        /// <ul>
        /// <li> <p>For <code>SCRATCH_2</code>, <code>PERSISTENT_2</code> and <code>PERSISTENT_1</code> deployment types using SSD storage type, the valid values are 1200 GiB, 2400 GiB, and increments of 2400 GiB.</p> </li>
        /// <li> <p>For <code>PERSISTENT_1</code> HDD file systems, valid values are increments of 6000 GiB for 12 MB/s/TiB file systems and increments of 1800 GiB for 40 MB/s/TiB file systems.</p> </li>
        /// <li> <p>For <code>SCRATCH_1</code> deployment type, valid values are 1200 GiB, 2400 GiB, and increments of 3600 GiB.</p> </li>
        /// </ul>
        /// <p> <b>FSx for ONTAP file systems</b> - The amount of storage capacity that you can configure is from 1024 GiB up to 196,608 GiB (192 TiB).</p>
        /// <p> <b>FSx for OpenZFS file systems</b> - The amount of storage capacity that you can configure is from 64 GiB up to 524,288 GiB (512 TiB).</p>
        /// <p> <b>FSx for Windows File Server file systems</b> - The amount of storage capacity that you can configure depends on the value that you set for <code>StorageType</code> as follows:</p>
        /// <ul>
        /// <li> <p>For SSD storage, valid values are 32 GiB-65,536 GiB (64 TiB).</p> </li>
        /// <li> <p>For HDD storage, valid values are 2000 GiB-65,536 GiB (64 TiB).</p> </li>
        /// </ul>
        pub fn storage_capacity(mut self, input: i32) -> Self {
            self.inner = self.inner.storage_capacity(input);
            self
        }
        /// <p>Sets the storage capacity of the file system that you're creating, in gibibytes (GiB).</p>
        /// <p> <b>FSx for Lustre file systems</b> - The amount of storage capacity that you can configure depends on the value that you set for <code>StorageType</code> and the Lustre <code>DeploymentType</code>, as follows:</p>
        /// <ul>
        /// <li> <p>For <code>SCRATCH_2</code>, <code>PERSISTENT_2</code> and <code>PERSISTENT_1</code> deployment types using SSD storage type, the valid values are 1200 GiB, 2400 GiB, and increments of 2400 GiB.</p> </li>
        /// <li> <p>For <code>PERSISTENT_1</code> HDD file systems, valid values are increments of 6000 GiB for 12 MB/s/TiB file systems and increments of 1800 GiB for 40 MB/s/TiB file systems.</p> </li>
        /// <li> <p>For <code>SCRATCH_1</code> deployment type, valid values are 1200 GiB, 2400 GiB, and increments of 3600 GiB.</p> </li>
        /// </ul>
        /// <p> <b>FSx for ONTAP file systems</b> - The amount of storage capacity that you can configure is from 1024 GiB up to 196,608 GiB (192 TiB).</p>
        /// <p> <b>FSx for OpenZFS file systems</b> - The amount of storage capacity that you can configure is from 64 GiB up to 524,288 GiB (512 TiB).</p>
        /// <p> <b>FSx for Windows File Server file systems</b> - The amount of storage capacity that you can configure depends on the value that you set for <code>StorageType</code> as follows:</p>
        /// <ul>
        /// <li> <p>For SSD storage, valid values are 32 GiB-65,536 GiB (64 TiB).</p> </li>
        /// <li> <p>For HDD storage, valid values are 2000 GiB-65,536 GiB (64 TiB).</p> </li>
        /// </ul>
        pub fn set_storage_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_storage_capacity(input);
            self
        }
        /// <p>Sets the storage type for the file system that you're creating. Valid values are <code>SSD</code> and <code>HDD</code>.</p>
        /// <ul>
        /// <li> <p>Set to <code>SSD</code> to use solid state drive storage. SSD is supported on all Windows, Lustre, ONTAP, and OpenZFS deployment types.</p> </li>
        /// <li> <p>Set to <code>HDD</code> to use hard disk drive storage. HDD is supported on <code>SINGLE_AZ_2</code> and <code>MULTI_AZ_1</code> Windows file system deployment types, and on <code>PERSISTENT_1</code> Lustre file system deployment types. </p> </li>
        /// </ul>
        /// <p>Default value is <code>SSD</code>. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/optimize-fsx-costs.html#storage-type-options"> Storage type options</a> in the <i>FSx for Windows File Server User Guide</i> and <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/what-is.html#storage-options">Multiple storage options</a> in the <i>FSx for Lustre User Guide</i>. </p>
        pub fn storage_type(mut self, input: crate::model::StorageType) -> Self {
            self.inner = self.inner.storage_type(input);
            self
        }
        /// <p>Sets the storage type for the file system that you're creating. Valid values are <code>SSD</code> and <code>HDD</code>.</p>
        /// <ul>
        /// <li> <p>Set to <code>SSD</code> to use solid state drive storage. SSD is supported on all Windows, Lustre, ONTAP, and OpenZFS deployment types.</p> </li>
        /// <li> <p>Set to <code>HDD</code> to use hard disk drive storage. HDD is supported on <code>SINGLE_AZ_2</code> and <code>MULTI_AZ_1</code> Windows file system deployment types, and on <code>PERSISTENT_1</code> Lustre file system deployment types. </p> </li>
        /// </ul>
        /// <p>Default value is <code>SSD</code>. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/optimize-fsx-costs.html#storage-type-options"> Storage type options</a> in the <i>FSx for Windows File Server User Guide</i> and <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/what-is.html#storage-options">Multiple storage options</a> in the <i>FSx for Lustre User Guide</i>. </p>
        pub fn set_storage_type(
            mut self,
            input: std::option::Option<crate::model::StorageType>,
        ) -> Self {
            self.inner = self.inner.set_storage_type(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>Specifies the IDs of the subnets that the file system will be accessible from. For Windows and ONTAP <code>MULTI_AZ_1</code> deployment types,provide exactly two subnet IDs, one for the preferred file server and one for the standby file server. You specify one of these subnets as the preferred subnet using the <code>WindowsConfiguration &gt; PreferredSubnetID</code> or <code>OntapConfiguration &gt; PreferredSubnetID</code> properties. For more information about Multi-AZ file system configuration, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html"> Availability and durability: Single-AZ and Multi-AZ file systems</a> in the <i>Amazon FSx for Windows User Guide</i> and <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/high-availability-multiAZ.html"> Availability and durability</a> in the <i>Amazon FSx for ONTAP User Guide</i>.</p>
        /// <p>For Windows <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> and all Lustre deployment types, provide exactly one subnet ID. The file server is launched in that subnet's Availability Zone.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(input.into());
            self
        }
        /// <p>Specifies the IDs of the subnets that the file system will be accessible from. For Windows and ONTAP <code>MULTI_AZ_1</code> deployment types,provide exactly two subnet IDs, one for the preferred file server and one for the standby file server. You specify one of these subnets as the preferred subnet using the <code>WindowsConfiguration &gt; PreferredSubnetID</code> or <code>OntapConfiguration &gt; PreferredSubnetID</code> properties. For more information about Multi-AZ file system configuration, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html"> Availability and durability: Single-AZ and Multi-AZ file systems</a> in the <i>Amazon FSx for Windows User Guide</i> and <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/high-availability-multiAZ.html"> Availability and durability</a> in the <i>Amazon FSx for ONTAP User Guide</i>.</p>
        /// <p>For Windows <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> and all Lustre deployment types, provide exactly one subnet ID. The file server is launched in that subnet's Availability Zone.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
        /// Appends an item to `SecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>A list of IDs specifying the security groups to apply to all network interfaces created for file system access. This list isn't returned in later requests to describe the file system.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_ids(input.into());
            self
        }
        /// <p>A list of IDs specifying the security groups to apply to all network interfaces created for file system access. This list isn't returned in later requests to describe the file system.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_ids(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply to the file system that's being created. The key value of the <code>Name</code> tag appears in the console as the file system name.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to apply to the file system that's being created. The key value of the <code>Name</code> tag appears in the console as the file system name.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The ID of the Key Management Service (KMS) key used to encrypt the file system's data for Amazon FSx for Windows File Server file systems, Amazon FSx for NetApp ONTAP file systems, and Amazon FSx for Lustre <code>PERSISTENT_1</code> and <code>PERSISTENT_2</code> file systems at rest. If this ID isn't specified, the key managed by Amazon FSx is used. The Amazon FSx for Lustre <code>SCRATCH_1</code> and <code>SCRATCH_2</code> file systems are always encrypted at rest using Amazon FSx-managed keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html">Encrypt</a> in the <i>Key Management Service API Reference</i>.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The ID of the Key Management Service (KMS) key used to encrypt the file system's data for Amazon FSx for Windows File Server file systems, Amazon FSx for NetApp ONTAP file systems, and Amazon FSx for Lustre <code>PERSISTENT_1</code> and <code>PERSISTENT_2</code> file systems at rest. If this ID isn't specified, the key managed by Amazon FSx is used. The Amazon FSx for Lustre <code>SCRATCH_1</code> and <code>SCRATCH_2</code> file systems are always encrypted at rest using Amazon FSx-managed keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html">Encrypt</a> in the <i>Key Management Service API Reference</i>.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>The Microsoft Windows configuration for the file system that's being created. </p>
        pub fn windows_configuration(
            mut self,
            input: crate::model::CreateFileSystemWindowsConfiguration,
        ) -> Self {
            self.inner = self.inner.windows_configuration(input);
            self
        }
        /// <p>The Microsoft Windows configuration for the file system that's being created. </p>
        pub fn set_windows_configuration(
            mut self,
            input: std::option::Option<crate::model::CreateFileSystemWindowsConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_windows_configuration(input);
            self
        }
        /// <p>The Lustre configuration for the file system being created.</p> <note>
        /// <p>The following parameters are not supported for file systems with the <code>Persistent_2</code> deployment type. Instead, use <code>CreateDataRepositoryAssociation</code> to create a data repository association to link your Lustre file system to a data repository.</p>
        /// <ul>
        /// <li> <p> <code>AutoImportPolicy</code> </p> </li>
        /// <li> <p> <code>ExportPath</code> </p> </li>
        /// <li> <p> <code>ImportedChunkSize</code> </p> </li>
        /// <li> <p> <code>ImportPath</code> </p> </li>
        /// </ul>
        /// </note>
        pub fn lustre_configuration(
            mut self,
            input: crate::model::CreateFileSystemLustreConfiguration,
        ) -> Self {
            self.inner = self.inner.lustre_configuration(input);
            self
        }
        /// <p>The Lustre configuration for the file system being created.</p> <note>
        /// <p>The following parameters are not supported for file systems with the <code>Persistent_2</code> deployment type. Instead, use <code>CreateDataRepositoryAssociation</code> to create a data repository association to link your Lustre file system to a data repository.</p>
        /// <ul>
        /// <li> <p> <code>AutoImportPolicy</code> </p> </li>
        /// <li> <p> <code>ExportPath</code> </p> </li>
        /// <li> <p> <code>ImportedChunkSize</code> </p> </li>
        /// <li> <p> <code>ImportPath</code> </p> </li>
        /// </ul>
        /// </note>
        pub fn set_lustre_configuration(
            mut self,
            input: std::option::Option<crate::model::CreateFileSystemLustreConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_lustre_configuration(input);
            self
        }
        /// <p>The ONTAP configuration properties of the FSx for ONTAP file system that you are creating.</p>
        pub fn ontap_configuration(
            mut self,
            input: crate::model::CreateFileSystemOntapConfiguration,
        ) -> Self {
            self.inner = self.inner.ontap_configuration(input);
            self
        }
        /// <p>The ONTAP configuration properties of the FSx for ONTAP file system that you are creating.</p>
        pub fn set_ontap_configuration(
            mut self,
            input: std::option::Option<crate::model::CreateFileSystemOntapConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_ontap_configuration(input);
            self
        }
        /// <p>(Optional) For FSx for Lustre file systems, sets the Lustre version for the file system that you're creating. Valid values are <code>2.10</code> and <code>2.12</code>:</p>
        /// <ul>
        /// <li> <p>2.10 is supported by the Scratch and Persistent_1 Lustre deployment types.</p> </li>
        /// <li> <p>2.12 is supported by all Lustre deployment types. <code>2.12</code> is required when setting FSx for Lustre <code>DeploymentType</code> to <code>PERSISTENT_2</code>.</p> </li>
        /// </ul>
        /// <p>Default value = <code>2.10</code>, except when <code>DeploymentType</code> is set to <code>PERSISTENT_2</code>, then the default is <code>2.12</code>.</p> <note>
        /// <p>If you set <code>FileSystemTypeVersion</code> to <code>2.10</code> for a <code>PERSISTENT_2</code> Lustre deployment type, the <code>CreateFileSystem</code> operation fails.</p>
        /// </note>
        pub fn file_system_type_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_type_version(input.into());
            self
        }
        /// <p>(Optional) For FSx for Lustre file systems, sets the Lustre version for the file system that you're creating. Valid values are <code>2.10</code> and <code>2.12</code>:</p>
        /// <ul>
        /// <li> <p>2.10 is supported by the Scratch and Persistent_1 Lustre deployment types.</p> </li>
        /// <li> <p>2.12 is supported by all Lustre deployment types. <code>2.12</code> is required when setting FSx for Lustre <code>DeploymentType</code> to <code>PERSISTENT_2</code>.</p> </li>
        /// </ul>
        /// <p>Default value = <code>2.10</code>, except when <code>DeploymentType</code> is set to <code>PERSISTENT_2</code>, then the default is <code>2.12</code>.</p> <note>
        /// <p>If you set <code>FileSystemTypeVersion</code> to <code>2.10</code> for a <code>PERSISTENT_2</code> Lustre deployment type, the <code>CreateFileSystem</code> operation fails.</p>
        /// </note>
        pub fn set_file_system_type_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_type_version(input);
            self
        }
        /// <p>The OpenZFS configuration for the file system that's being created.</p>
        pub fn open_zfs_configuration(
            mut self,
            input: crate::model::CreateFileSystemOpenZfsConfiguration,
        ) -> Self {
            self.inner = self.inner.open_zfs_configuration(input);
            self
        }
        /// <p>The OpenZFS configuration for the file system that's being created.</p>
        pub fn set_open_zfs_configuration(
            mut self,
            input: std::option::Option<crate::model::CreateFileSystemOpenZfsConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_open_zfs_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFileSystemFromBackup`.
    ///
    /// <p>Creates a new Amazon FSx for Lustre, Amazon FSx for Windows File Server, or Amazon FSx for OpenZFS file system from an existing Amazon FSx backup.</p>
    /// <p>If a file system with the specified client request token exists and the parameters match, this operation returns the description of the file system. If a file system with the specified client request token exists but the parameters don't match, this call returns <code>IncompatibleParameterError</code>. If a file system with the specified client request token doesn't exist, this operation does the following:</p>
    /// <ul>
    /// <li> <p>Creates a new Amazon FSx file system from backup with an assigned ID, and an initial lifecycle state of <code>CREATING</code>.</p> </li>
    /// <li> <p>Returns the description of the file system.</p> </li>
    /// </ul>
    /// <p>Parameters like the Active Directory, default share name, automatic backup, and backup settings default to the parameters of the file system that was backed up, unless overridden. You can explicitly supply other settings.</p>
    /// <p>By using the idempotent operation, you can retry a <code>CreateFileSystemFromBackup</code> call without the risk of creating an extra file system. This approach can be useful when an initial call fails in a way that makes it unclear whether a file system was created. Examples are if a transport level timeout occurred, or your connection was reset. If you use the same client request token and the initial call created a file system, the client receives a success message as long as the parameters are the same.</p> <note>
    /// <p>The <code>CreateFileSystemFromBackup</code> call returns while the file system's lifecycle state is still <code>CREATING</code>. You can check the file-system creation status by calling the <a href="https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeFileSystems.html"> DescribeFileSystems</a> operation, which returns the file system state along with other information.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFileSystemFromBackup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_file_system_from_backup_input::Builder,
    }
    impl CreateFileSystemFromBackup {
        /// Creates a new `CreateFileSystemFromBackup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFileSystemFromBackupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFileSystemFromBackupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the source backup. Specifies the backup that you are copying.</p>
        pub fn backup_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_id(input.into());
            self
        }
        /// <p>The ID of the source backup. Specifies the backup that you are copying.</p>
        pub fn set_backup_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_backup_id(input);
            self
        }
        /// <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent creation. This string is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent creation. This string is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>Specifies the IDs of the subnets that the file system will be accessible from. For Windows <code>MULTI_AZ_1</code> file system deployment types, provide exactly two subnet IDs, one for the preferred file server and one for the standby file server. You specify one of these subnets as the preferred subnet using the <code>WindowsConfiguration &gt; PreferredSubnetID</code> property.</p>
        /// <p>Windows <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> file system deployment types, Lustre file systems, and OpenZFS file systems provide exactly one subnet ID. The file server is launched in that subnet's Availability Zone.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(input.into());
            self
        }
        /// <p>Specifies the IDs of the subnets that the file system will be accessible from. For Windows <code>MULTI_AZ_1</code> file system deployment types, provide exactly two subnet IDs, one for the preferred file server and one for the standby file server. You specify one of these subnets as the preferred subnet using the <code>WindowsConfiguration &gt; PreferredSubnetID</code> property.</p>
        /// <p>Windows <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> file system deployment types, Lustre file systems, and OpenZFS file systems provide exactly one subnet ID. The file server is launched in that subnet's Availability Zone.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
        /// Appends an item to `SecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups apply to all network interfaces. This value isn't returned in later <code>DescribeFileSystem</code> requests.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_ids(input.into());
            self
        }
        /// <p>A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups apply to all network interfaces. This value isn't returned in later <code>DescribeFileSystem</code> requests.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_ids(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be applied to the file system at file system creation. The key value of the <code>Name</code> tag appears in the console as the file system name.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to be applied to the file system at file system creation. The key value of the <code>Name</code> tag appears in the console as the file system name.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The configuration for this Microsoft Windows file system.</p>
        pub fn windows_configuration(
            mut self,
            input: crate::model::CreateFileSystemWindowsConfiguration,
        ) -> Self {
            self.inner = self.inner.windows_configuration(input);
            self
        }
        /// <p>The configuration for this Microsoft Windows file system.</p>
        pub fn set_windows_configuration(
            mut self,
            input: std::option::Option<crate::model::CreateFileSystemWindowsConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_windows_configuration(input);
            self
        }
        /// <p>The Lustre configuration for the file system being created.</p> <note>
        /// <p>The following parameters are not supported for file systems with the <code>Persistent_2</code> deployment type. Instead, use <code>CreateDataRepositoryAssociation</code> to create a data repository association to link your Lustre file system to a data repository.</p>
        /// <ul>
        /// <li> <p> <code>AutoImportPolicy</code> </p> </li>
        /// <li> <p> <code>ExportPath</code> </p> </li>
        /// <li> <p> <code>ImportedChunkSize</code> </p> </li>
        /// <li> <p> <code>ImportPath</code> </p> </li>
        /// </ul>
        /// </note>
        pub fn lustre_configuration(
            mut self,
            input: crate::model::CreateFileSystemLustreConfiguration,
        ) -> Self {
            self.inner = self.inner.lustre_configuration(input);
            self
        }
        /// <p>The Lustre configuration for the file system being created.</p> <note>
        /// <p>The following parameters are not supported for file systems with the <code>Persistent_2</code> deployment type. Instead, use <code>CreateDataRepositoryAssociation</code> to create a data repository association to link your Lustre file system to a data repository.</p>
        /// <ul>
        /// <li> <p> <code>AutoImportPolicy</code> </p> </li>
        /// <li> <p> <code>ExportPath</code> </p> </li>
        /// <li> <p> <code>ImportedChunkSize</code> </p> </li>
        /// <li> <p> <code>ImportPath</code> </p> </li>
        /// </ul>
        /// </note>
        pub fn set_lustre_configuration(
            mut self,
            input: std::option::Option<crate::model::CreateFileSystemLustreConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_lustre_configuration(input);
            self
        }
        /// <p>Sets the storage type for the Windows or OpenZFS file system that you're creating from a backup. Valid values are <code>SSD</code> and <code>HDD</code>.</p>
        /// <ul>
        /// <li> <p>Set to <code>SSD</code> to use solid state drive storage. SSD is supported on all Windows and OpenZFS deployment types.</p> </li>
        /// <li> <p>Set to <code>HDD</code> to use hard disk drive storage. HDD is supported on <code>SINGLE_AZ_2</code> and <code>MULTI_AZ_1</code> FSx for Windows File Server file system deployment types.</p> </li>
        /// </ul>
        /// <p> The default value is <code>SSD</code>. </p> <note>
        /// <p>HDD and SSD storage types have different minimum storage capacity requirements. A restored file system's storage capacity is tied to the file system that was backed up. You can create a file system that uses HDD storage from a backup of a file system that used SSD storage if the original SSD file system had a storage capacity of at least 2000 GiB.</p>
        /// </note>
        pub fn storage_type(mut self, input: crate::model::StorageType) -> Self {
            self.inner = self.inner.storage_type(input);
            self
        }
        /// <p>Sets the storage type for the Windows or OpenZFS file system that you're creating from a backup. Valid values are <code>SSD</code> and <code>HDD</code>.</p>
        /// <ul>
        /// <li> <p>Set to <code>SSD</code> to use solid state drive storage. SSD is supported on all Windows and OpenZFS deployment types.</p> </li>
        /// <li> <p>Set to <code>HDD</code> to use hard disk drive storage. HDD is supported on <code>SINGLE_AZ_2</code> and <code>MULTI_AZ_1</code> FSx for Windows File Server file system deployment types.</p> </li>
        /// </ul>
        /// <p> The default value is <code>SSD</code>. </p> <note>
        /// <p>HDD and SSD storage types have different minimum storage capacity requirements. A restored file system's storage capacity is tied to the file system that was backed up. You can create a file system that uses HDD storage from a backup of a file system that used SSD storage if the original SSD file system had a storage capacity of at least 2000 GiB.</p>
        /// </note>
        pub fn set_storage_type(
            mut self,
            input: std::option::Option<crate::model::StorageType>,
        ) -> Self {
            self.inner = self.inner.set_storage_type(input);
            self
        }
        /// <p>The ID of the Key Management Service (KMS) key used to encrypt the file system's data for Amazon FSx for Windows File Server file systems, Amazon FSx for NetApp ONTAP file systems, and Amazon FSx for Lustre <code>PERSISTENT_1</code> and <code>PERSISTENT_2</code> file systems at rest. If this ID isn't specified, the key managed by Amazon FSx is used. The Amazon FSx for Lustre <code>SCRATCH_1</code> and <code>SCRATCH_2</code> file systems are always encrypted at rest using Amazon FSx-managed keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html">Encrypt</a> in the <i>Key Management Service API Reference</i>.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The ID of the Key Management Service (KMS) key used to encrypt the file system's data for Amazon FSx for Windows File Server file systems, Amazon FSx for NetApp ONTAP file systems, and Amazon FSx for Lustre <code>PERSISTENT_1</code> and <code>PERSISTENT_2</code> file systems at rest. If this ID isn't specified, the key managed by Amazon FSx is used. The Amazon FSx for Lustre <code>SCRATCH_1</code> and <code>SCRATCH_2</code> file systems are always encrypted at rest using Amazon FSx-managed keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html">Encrypt</a> in the <i>Key Management Service API Reference</i>.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>Sets the version for the Amazon FSx for Lustre file system that you're creating from a backup. Valid values are <code>2.10</code> and <code>2.12</code>.</p>
        /// <p>You don't need to specify <code>FileSystemTypeVersion</code> because it will be applied using the backup's <code>FileSystemTypeVersion</code> setting. If you choose to specify <code>FileSystemTypeVersion</code> when creating from backup, the value must match the backup's <code>FileSystemTypeVersion</code> setting.</p>
        pub fn file_system_type_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_type_version(input.into());
            self
        }
        /// <p>Sets the version for the Amazon FSx for Lustre file system that you're creating from a backup. Valid values are <code>2.10</code> and <code>2.12</code>.</p>
        /// <p>You don't need to specify <code>FileSystemTypeVersion</code> because it will be applied using the backup's <code>FileSystemTypeVersion</code> setting. If you choose to specify <code>FileSystemTypeVersion</code> when creating from backup, the value must match the backup's <code>FileSystemTypeVersion</code> setting.</p>
        pub fn set_file_system_type_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_type_version(input);
            self
        }
        /// <p>The OpenZFS configuration for the file system that's being created. </p>
        pub fn open_zfs_configuration(
            mut self,
            input: crate::model::CreateFileSystemOpenZfsConfiguration,
        ) -> Self {
            self.inner = self.inner.open_zfs_configuration(input);
            self
        }
        /// <p>The OpenZFS configuration for the file system that's being created. </p>
        pub fn set_open_zfs_configuration(
            mut self,
            input: std::option::Option<crate::model::CreateFileSystemOpenZfsConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_open_zfs_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSnapshot`.
    ///
    /// <p>Creates a snapshot of an existing Amazon FSx for OpenZFS volume. With snapshots, you can easily undo file changes and compare file versions by restoring the volume to a previous version.</p>
    /// <p>If a snapshot with the specified client request token exists, and the parameters match, this operation returns the description of the existing snapshot. If a snapshot with the specified client request token exists, and the parameters don't match, this operation returns <code>IncompatibleParameterError</code>. If a snapshot with the specified client request token doesn't exist, <code>CreateSnapshot</code> does the following:</p>
    /// <ul>
    /// <li> <p>Creates a new OpenZFS snapshot with an assigned ID, and an initial lifecycle state of <code>CREATING</code>.</p> </li>
    /// <li> <p>Returns the description of the snapshot.</p> </li>
    /// </ul>
    /// <p>By using the idempotent operation, you can retry a <code>CreateSnapshot</code> operation without the risk of creating an extra snapshot. This approach can be useful when an initial call fails in a way that makes it unclear whether a snapshot was created. If you use the same client request token and the initial call created a snapshot, the operation returns a successful result because all the parameters are the same.</p>
    /// <p>The <code>CreateSnapshot</code> operation returns while the snapshot's lifecycle state is still <code>CREATING</code>. You can check the snapshot creation status by calling the <a href="https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeSnapshots.html">DescribeSnapshots</a> operation, which returns the snapshot state along with other information.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSnapshot {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_snapshot_input::Builder,
    }
    impl CreateSnapshot {
        /// Creates a new `CreateSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSnapshotError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The name of the snapshot. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the snapshot. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The ID of the volume that you are taking a snapshot of.</p>
        pub fn volume_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_id(input.into());
            self
        }
        /// <p>The ID of the volume that you are taking a snapshot of.</p>
        pub fn set_volume_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_volume_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStorageVirtualMachine`.
    ///
    /// <p>Creates a storage virtual machine (SVM) for an Amazon FSx for ONTAP file system.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateStorageVirtualMachine {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_storage_virtual_machine_input::Builder,
    }
    impl CreateStorageVirtualMachine {
        /// Creates a new `CreateStorageVirtualMachine`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStorageVirtualMachineOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStorageVirtualMachineError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Describes the self-managed Microsoft Active Directory to which you want to join the SVM. Joining an Active Directory provides user authentication and access control for SMB clients, including Microsoft Windows and macOS client accessing the file system.</p>
        pub fn active_directory_configuration(
            mut self,
            input: crate::model::CreateSvmActiveDirectoryConfiguration,
        ) -> Self {
            self.inner = self.inner.active_directory_configuration(input);
            self
        }
        /// <p>Describes the self-managed Microsoft Active Directory to which you want to join the SVM. Joining an Active Directory provides user authentication and access control for SMB clients, including Microsoft Windows and macOS client accessing the file system.</p>
        pub fn set_active_directory_configuration(
            mut self,
            input: std::option::Option<crate::model::CreateSvmActiveDirectoryConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_active_directory_configuration(input);
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The globally unique ID of the file system, assigned by Amazon FSx.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(input.into());
            self
        }
        /// <p>The globally unique ID of the file system, assigned by Amazon FSx.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
        /// <p>The name of the SVM.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the SVM.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The password to use when managing the SVM using the NetApp ONTAP CLI or REST API. If you do not specify a password, you can still use the file system's <code>fsxadmin</code> user to manage the SVM.</p>
        pub fn svm_admin_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.svm_admin_password(input.into());
            self
        }
        /// <p>The password to use when managing the SVM using the NetApp ONTAP CLI or REST API. If you do not specify a password, you can still use the file system's <code>fsxadmin</code> user to manage the SVM.</p>
        pub fn set_svm_admin_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_svm_admin_password(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The security style of the root volume of the SVM. Specify one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS clients, and an application accessing the data uses a UNIX user as the service account.</p> </li>
        /// <li> <p> <code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are SMB clients, and an application accessing the data uses a Windows user as the service account.</p> </li>
        /// <li> <p> <code>MIXED</code> if the file system is managed by both UNIX and Windows administrators and users consist of both NFS and SMB clients.</p> </li>
        /// </ul>
        pub fn root_volume_security_style(
            mut self,
            input: crate::model::StorageVirtualMachineRootVolumeSecurityStyle,
        ) -> Self {
            self.inner = self.inner.root_volume_security_style(input);
            self
        }
        /// <p>The security style of the root volume of the SVM. Specify one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS clients, and an application accessing the data uses a UNIX user as the service account.</p> </li>
        /// <li> <p> <code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are SMB clients, and an application accessing the data uses a Windows user as the service account.</p> </li>
        /// <li> <p> <code>MIXED</code> if the file system is managed by both UNIX and Windows administrators and users consist of both NFS and SMB clients.</p> </li>
        /// </ul>
        pub fn set_root_volume_security_style(
            mut self,
            input: std::option::Option<crate::model::StorageVirtualMachineRootVolumeSecurityStyle>,
        ) -> Self {
            self.inner = self.inner.set_root_volume_security_style(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateVolume`.
    ///
    /// <p>Creates an FSx for ONTAP or Amazon FSx for OpenZFS storage volume.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateVolume {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_volume_input::Builder,
    }
    impl CreateVolume {
        /// Creates a new `CreateVolume`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateVolumeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateVolumeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>Specifies the type of volume to create; <code>ONTAP</code> and <code>OPENZFS</code> are the only valid volume types.</p>
        pub fn volume_type(mut self, input: crate::model::VolumeType) -> Self {
            self.inner = self.inner.volume_type(input);
            self
        }
        /// <p>Specifies the type of volume to create; <code>ONTAP</code> and <code>OPENZFS</code> are the only valid volume types.</p>
        pub fn set_volume_type(
            mut self,
            input: std::option::Option<crate::model::VolumeType>,
        ) -> Self {
            self.inner = self.inner.set_volume_type(input);
            self
        }
        /// <p>Specifies the name of the volume that you're creating.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>Specifies the name of the volume that you're creating.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies the configuration to use when creating the ONTAP volume.</p>
        pub fn ontap_configuration(
            mut self,
            input: crate::model::CreateOntapVolumeConfiguration,
        ) -> Self {
            self.inner = self.inner.ontap_configuration(input);
            self
        }
        /// <p>Specifies the configuration to use when creating the ONTAP volume.</p>
        pub fn set_ontap_configuration(
            mut self,
            input: std::option::Option<crate::model::CreateOntapVolumeConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_ontap_configuration(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Specifies the configuration to use when creating the OpenZFS volume.</p>
        pub fn open_zfs_configuration(
            mut self,
            input: crate::model::CreateOpenZfsVolumeConfiguration,
        ) -> Self {
            self.inner = self.inner.open_zfs_configuration(input);
            self
        }
        /// <p>Specifies the configuration to use when creating the OpenZFS volume.</p>
        pub fn set_open_zfs_configuration(
            mut self,
            input: std::option::Option<crate::model::CreateOpenZfsVolumeConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_open_zfs_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateVolumeFromBackup`.
    ///
    /// <p>Creates a new Amazon FSx for NetApp ONTAP volume from an existing Amazon FSx volume backup.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateVolumeFromBackup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_volume_from_backup_input::Builder,
    }
    impl CreateVolumeFromBackup {
        /// Creates a new `CreateVolumeFromBackup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateVolumeFromBackupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateVolumeFromBackupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the source backup. Specifies the backup that you are copying.</p>
        pub fn backup_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_id(input.into());
            self
        }
        /// <p>The ID of the source backup. Specifies the backup that you are copying.</p>
        pub fn set_backup_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_backup_id(input);
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The name of the new volume you're creating.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the new volume you're creating.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies the configuration of the ONTAP volume that you are creating.</p>
        pub fn ontap_configuration(
            mut self,
            input: crate::model::CreateOntapVolumeConfiguration,
        ) -> Self {
            self.inner = self.inner.ontap_configuration(input);
            self
        }
        /// <p>Specifies the configuration of the ONTAP volume that you are creating.</p>
        pub fn set_ontap_configuration(
            mut self,
            input: std::option::Option<crate::model::CreateOntapVolumeConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_ontap_configuration(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBackup`.
    ///
    /// <p>Deletes an Amazon FSx backup. After deletion, the backup no longer exists, and its data is gone.</p>
    /// <p>The <code>DeleteBackup</code> call returns instantly. The backup won't show up in later <code>DescribeBackups</code> calls.</p> <important>
    /// <p>The data in a deleted backup is also deleted and can't be recovered by any means.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBackup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_backup_input::Builder,
    }
    impl DeleteBackup {
        /// Creates a new `DeleteBackup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBackupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBackupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the backup that you want to delete.</p>
        pub fn backup_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_id(input.into());
            self
        }
        /// <p>The ID of the backup that you want to delete.</p>
        pub fn set_backup_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_backup_id(input);
            self
        }
        /// <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent deletion. This parameter is automatically filled on your behalf when using the CLI or SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent deletion. This parameter is automatically filled on your behalf when using the CLI or SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDataRepositoryAssociation`.
    ///
    /// <p>Deletes a data repository association on an Amazon FSx for Lustre file system. Deleting the data repository association unlinks the file system from the Amazon S3 bucket. When deleting a data repository association, you have the option of deleting the data in the file system that corresponds to the data repository association. Data repository associations are supported only for file systems with the <code>Persistent_2</code> deployment type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDataRepositoryAssociation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_data_repository_association_input::Builder,
    }
    impl DeleteDataRepositoryAssociation {
        /// Creates a new `DeleteDataRepositoryAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDataRepositoryAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDataRepositoryAssociationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the data repository association that you want to delete.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_id(input.into());
            self
        }
        /// <p>The ID of the data repository association that you want to delete.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_id(input);
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>Set to <code>true</code> to delete the data in the file system that corresponds to the data repository association.</p>
        pub fn delete_data_in_file_system(mut self, input: bool) -> Self {
            self.inner = self.inner.delete_data_in_file_system(input);
            self
        }
        /// <p>Set to <code>true</code> to delete the data in the file system that corresponds to the data repository association.</p>
        pub fn set_delete_data_in_file_system(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_delete_data_in_file_system(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFileSystem`.
    ///
    /// <p>Deletes a file system. After deletion, the file system no longer exists, and its data is gone. Any existing automatic backups and snapshots are also deleted.</p>
    /// <p>To delete an Amazon FSx for NetApp ONTAP file system, first delete all the volumes and storage virtual machines (SVMs) on the file system. Then provide a <code>FileSystemId</code> value to the <code>DeleFileSystem</code> operation.</p>
    /// <p>By default, when you delete an Amazon FSx for Windows File Server file system, a final backup is created upon deletion. This final backup isn't subject to the file system's retention policy, and must be manually deleted.</p>
    /// <p>The <code>DeleteFileSystem</code> operation returns while the file system has the <code>DELETING</code> status. You can check the file system deletion status by calling the <a href="https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeFileSystems.html">DescribeFileSystems</a> operation, which returns a list of file systems in your account. If you pass the file system ID for a deleted file system, the <code>DescribeFileSystems</code> operation returns a <code>FileSystemNotFound</code> error.</p> <note>
    /// <p>If a data repository task is in a <code>PENDING</code> or <code>EXECUTING</code> state, deleting an Amazon FSx for Lustre file system will fail with an HTTP status code 400 (Bad Request).</p>
    /// </note> <important>
    /// <p>The data in a deleted file system is also deleted and can't be recovered by any means.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFileSystem {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_file_system_input::Builder,
    }
    impl DeleteFileSystem {
        /// Creates a new `DeleteFileSystem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFileSystemOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFileSystemError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the file system that you want to delete.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(input.into());
            self
        }
        /// <p>The ID of the file system that you want to delete.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
        /// <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent deletion. This token is automatically filled on your behalf when using the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent deletion. This token is automatically filled on your behalf when using the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The configuration object for the Microsoft Windows file system used in the <code>DeleteFileSystem</code> operation.</p>
        pub fn windows_configuration(
            mut self,
            input: crate::model::DeleteFileSystemWindowsConfiguration,
        ) -> Self {
            self.inner = self.inner.windows_configuration(input);
            self
        }
        /// <p>The configuration object for the Microsoft Windows file system used in the <code>DeleteFileSystem</code> operation.</p>
        pub fn set_windows_configuration(
            mut self,
            input: std::option::Option<crate::model::DeleteFileSystemWindowsConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_windows_configuration(input);
            self
        }
        /// <p>The configuration object for the Amazon FSx for Lustre file system being deleted in the <code>DeleteFileSystem</code> operation.</p>
        pub fn lustre_configuration(
            mut self,
            input: crate::model::DeleteFileSystemLustreConfiguration,
        ) -> Self {
            self.inner = self.inner.lustre_configuration(input);
            self
        }
        /// <p>The configuration object for the Amazon FSx for Lustre file system being deleted in the <code>DeleteFileSystem</code> operation.</p>
        pub fn set_lustre_configuration(
            mut self,
            input: std::option::Option<crate::model::DeleteFileSystemLustreConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_lustre_configuration(input);
            self
        }
        /// <p>The configuration object for the OpenZFS file system used in the <code>DeleteFileSystem</code> operation.</p>
        pub fn open_zfs_configuration(
            mut self,
            input: crate::model::DeleteFileSystemOpenZfsConfiguration,
        ) -> Self {
            self.inner = self.inner.open_zfs_configuration(input);
            self
        }
        /// <p>The configuration object for the OpenZFS file system used in the <code>DeleteFileSystem</code> operation.</p>
        pub fn set_open_zfs_configuration(
            mut self,
            input: std::option::Option<crate::model::DeleteFileSystemOpenZfsConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_open_zfs_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSnapshot`.
    ///
    /// <p>Deletes an Amazon FSx for OpenZFS snapshot. After deletion, the snapshot no longer exists, and its data is gone. Deleting a snapshot doesn't affect snapshots stored in a file system backup. </p>
    /// <p>The <code>DeleteSnapshot</code> operation returns instantly. The snapshot appears with the lifecycle status of <code>DELETING</code> until the deletion is complete.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSnapshot {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_snapshot_input::Builder,
    }
    impl DeleteSnapshot {
        /// Creates a new `DeleteSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSnapshotError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The ID of the snapshot that you want to delete.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_id(input.into());
            self
        }
        /// <p>The ID of the snapshot that you want to delete.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_snapshot_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStorageVirtualMachine`.
    ///
    /// <p>Deletes an existing Amazon FSx for ONTAP storage virtual machine (SVM). Prior to deleting an SVM, you must delete all non-root volumes in the SVM, otherwise the operation will fail.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteStorageVirtualMachine {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_storage_virtual_machine_input::Builder,
    }
    impl DeleteStorageVirtualMachine {
        /// Creates a new `DeleteStorageVirtualMachine`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStorageVirtualMachineOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStorageVirtualMachineError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The ID of the SVM that you want to delete.</p>
        pub fn storage_virtual_machine_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.storage_virtual_machine_id(input.into());
            self
        }
        /// <p>The ID of the SVM that you want to delete.</p>
        pub fn set_storage_virtual_machine_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_storage_virtual_machine_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVolume`.
    ///
    /// <p>Deletes an Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volume.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteVolume {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_volume_input::Builder,
    }
    impl DeleteVolume {
        /// Creates a new `DeleteVolume`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVolumeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVolumeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The ID of the volume that you are deleting.</p>
        pub fn volume_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_id(input.into());
            self
        }
        /// <p>The ID of the volume that you are deleting.</p>
        pub fn set_volume_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_volume_id(input);
            self
        }
        /// <p>For Amazon FSx for ONTAP volumes, specify whether to take a final backup of the volume and apply tags to the backup. To apply tags to the backup, you must have the <code>fsx:TagResource</code> permission.</p>
        pub fn ontap_configuration(
            mut self,
            input: crate::model::DeleteVolumeOntapConfiguration,
        ) -> Self {
            self.inner = self.inner.ontap_configuration(input);
            self
        }
        /// <p>For Amazon FSx for ONTAP volumes, specify whether to take a final backup of the volume and apply tags to the backup. To apply tags to the backup, you must have the <code>fsx:TagResource</code> permission.</p>
        pub fn set_ontap_configuration(
            mut self,
            input: std::option::Option<crate::model::DeleteVolumeOntapConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_ontap_configuration(input);
            self
        }
        /// <p>For Amazon FSx for OpenZFS volumes, specify whether to delete all child volumes and snapshots.</p>
        pub fn open_zfs_configuration(
            mut self,
            input: crate::model::DeleteVolumeOpenZfsConfiguration,
        ) -> Self {
            self.inner = self.inner.open_zfs_configuration(input);
            self
        }
        /// <p>For Amazon FSx for OpenZFS volumes, specify whether to delete all child volumes and snapshots.</p>
        pub fn set_open_zfs_configuration(
            mut self,
            input: std::option::Option<crate::model::DeleteVolumeOpenZfsConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_open_zfs_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBackups`.
    ///
    /// <p>Returns the description of a specific Amazon FSx backup, if a <code>BackupIds</code> value is provided for that backup. Otherwise, it returns all backups owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.</p>
    /// <p>When retrieving all backups, you can optionally specify the <code>MaxResults</code> parameter to limit the number of backups in a response. If more backups remain, Amazon FSx returns a <code>NextToken</code> value in the response. In this case, send a later request with the <code>NextToken</code> request parameter set to the value of the <code>NextToken</code> value from the last response.</p>
    /// <p>This operation is used in an iterative process to retrieve a list of your backups. <code>DescribeBackups</code> is called first without a <code>NextToken</code> value. Then the operation continues to be called with the <code>NextToken</code> parameter set to the value of the last <code>NextToken</code> value until a response has no <code>NextToken</code> value.</p>
    /// <p>When using this operation, keep the following in mind:</p>
    /// <ul>
    /// <li> <p>The operation might return fewer than the <code>MaxResults</code> value of backup descriptions while still including a <code>NextToken</code> value.</p> </li>
    /// <li> <p>The order of the backups returned in the response of one <code>DescribeBackups</code> call and the order of the backups returned across the responses of a multi-call iteration is unspecified.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeBackups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_backups_input::Builder,
    }
    impl DescribeBackups {
        /// Creates a new `DescribeBackups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBackupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBackupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeBackupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeBackupsPaginator {
            crate::paginator::DescribeBackupsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `BackupIds`.
        ///
        /// To override the contents of this collection use [`set_backup_ids`](Self::set_backup_ids).
        ///
        /// <p>The IDs of the backups that you want to retrieve. This parameter value overrides any filters. If any IDs aren't found, a <code>BackupNotFound</code> error occurs.</p>
        pub fn backup_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_ids(input.into());
            self
        }
        /// <p>The IDs of the backups that you want to retrieve. This parameter value overrides any filters. If any IDs aren't found, a <code>BackupNotFound</code> error occurs.</p>
        pub fn set_backup_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_backup_ids(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters structure. The supported names are <code>file-system-id</code>, <code>backup-type</code>, <code>file-system-type</code>, and <code>volume-id</code>.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>The filters structure. The supported names are <code>file-system-id</code>, <code>backup-type</code>, <code>file-system-type</code>, and <code>volume-id</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Maximum number of backups to return in the response. This parameter value must be greater than 0. The number of items that Amazon FSx returns is the minimum of the <code>MaxResults</code> parameter specified in the request and the service's internal maximum number of items per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of backups to return in the response. This parameter value must be greater than 0. The number of items that Amazon FSx returns is the minimum of the <code>MaxResults</code> parameter specified in the request and the service's internal maximum number of items per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An opaque pagination token returned from a previous <code>DescribeBackups</code> operation. If a token is present, the operation continues the list from where the returning call left off.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An opaque pagination token returned from a previous <code>DescribeBackups</code> operation. If a token is present, the operation continues the list from where the returning call left off.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDataRepositoryAssociations`.
    ///
    /// <p>Returns the description of specific Amazon FSx for Lustre data repository associations, if one or more <code>AssociationIds</code> values are provided in the request, or if filters are used in the request. Data repository associations are supported only for file systems with the <code>Persistent_2</code> deployment type.</p>
    /// <p>You can use filters to narrow the response to include just data repository associations for specific file systems (use the <code>file-system-id</code> filter with the ID of the file system) or data repository associations for a specific repository type (use the <code>data-repository-type</code> filter with a value of <code>S3</code>). If you don't use filters, the response returns all data repository associations owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.</p>
    /// <p>When retrieving all data repository associations, you can paginate the response by using the optional <code>MaxResults</code> parameter to limit the number of data repository associations returned in a response. If more data repository associations remain, Amazon FSx returns a <code>NextToken</code> value in the response. In this case, send a later request with the <code>NextToken</code> request parameter set to the value of <code>NextToken</code> from the last response.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDataRepositoryAssociations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_data_repository_associations_input::Builder,
    }
    impl DescribeDataRepositoryAssociations {
        /// Creates a new `DescribeDataRepositoryAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDataRepositoryAssociationsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeDataRepositoryAssociationsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeDataRepositoryAssociationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeDataRepositoryAssociationsPaginator {
            crate::paginator::DescribeDataRepositoryAssociationsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// Appends an item to `AssociationIds`.
        ///
        /// To override the contents of this collection use [`set_association_ids`](Self::set_association_ids).
        ///
        /// <p>IDs of the data repository associations whose descriptions you want to retrieve (String).</p>
        pub fn association_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_ids(input.into());
            self
        }
        /// <p>IDs of the data repository associations whose descriptions you want to retrieve (String).</p>
        pub fn set_association_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_association_ids(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A list of <code>Filter</code> elements.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>A list of <code>Filter</code> elements.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of resources to return in the response. This value must be an integer greater than zero.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of resources to return in the response. This value must be an integer greater than zero.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDataRepositoryTasks`.
    ///
    /// <p>Returns the description of specific Amazon FSx for Lustre data repository tasks, if one or more <code>TaskIds</code> values are provided in the request, or if filters are used in the request. You can use filters to narrow the response to include just tasks for specific file systems, or tasks in a specific lifecycle state. Otherwise, it returns all data repository tasks owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.</p>
    /// <p>When retrieving all tasks, you can paginate the response by using the optional <code>MaxResults</code> parameter to limit the number of tasks returned in a response. If more tasks remain, Amazon FSx returns a <code>NextToken</code> value in the response. In this case, send a later request with the <code>NextToken</code> request parameter set to the value of <code>NextToken</code> from the last response.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDataRepositoryTasks {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_data_repository_tasks_input::Builder,
    }
    impl DescribeDataRepositoryTasks {
        /// Creates a new `DescribeDataRepositoryTasks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDataRepositoryTasksOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDataRepositoryTasksError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeDataRepositoryTasksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeDataRepositoryTasksPaginator {
            crate::paginator::DescribeDataRepositoryTasksPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `TaskIds`.
        ///
        /// To override the contents of this collection use [`set_task_ids`](Self::set_task_ids).
        ///
        /// <p>(Optional) IDs of the tasks whose descriptions you want to retrieve (String).</p>
        pub fn task_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_ids(input.into());
            self
        }
        /// <p>(Optional) IDs of the tasks whose descriptions you want to retrieve (String).</p>
        pub fn set_task_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_task_ids(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>(Optional) You can use filters to narrow the <code>DescribeDataRepositoryTasks</code> response to include just tasks for specific file systems, or tasks in a specific lifecycle state.</p>
        pub fn filters(mut self, input: crate::model::DataRepositoryTaskFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>(Optional) You can use filters to narrow the <code>DescribeDataRepositoryTasks</code> response to include just tasks for specific file systems, or tasks in a specific lifecycle state.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataRepositoryTaskFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of resources to return in the response. This value must be an integer greater than zero.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of resources to return in the response. This value must be an integer greater than zero.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFileSystemAliases`.
    ///
    /// <p>Returns the DNS aliases that are associated with the specified Amazon FSx for Windows File Server file system. A history of all DNS aliases that have been associated with and disassociated from the file system is available in the list of <code>AdministrativeAction</code> provided in the <code>DescribeFileSystems</code> operation response.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeFileSystemAliases {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_file_system_aliases_input::Builder,
    }
    impl DescribeFileSystemAliases {
        /// Creates a new `DescribeFileSystemAliases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFileSystemAliasesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFileSystemAliasesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The ID of the file system to return the associated DNS aliases for (String).</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(input.into());
            self
        }
        /// <p>The ID of the file system to return the associated DNS aliases for (String).</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
        /// <p>Maximum number of DNS aliases to return in the response (integer). This parameter value must be greater than 0. The number of items that Amazon FSx returns is the minimum of the <code>MaxResults</code> parameter specified in the request and the service's internal maximum number of items per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of DNS aliases to return in the response (integer). This parameter value must be greater than 0. The number of items that Amazon FSx returns is the minimum of the <code>MaxResults</code> parameter specified in the request and the service's internal maximum number of items per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Opaque pagination token returned from a previous <code>DescribeFileSystemAliases</code> operation (String). If a token is included in the request, the action continues the list from where the previous returning call left off.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Opaque pagination token returned from a previous <code>DescribeFileSystemAliases</code> operation (String). If a token is included in the request, the action continues the list from where the previous returning call left off.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFileSystems`.
    ///
    /// <p>Returns the description of specific Amazon FSx file systems, if a <code>FileSystemIds</code> value is provided for that file system. Otherwise, it returns descriptions of all file systems owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.</p>
    /// <p>When retrieving all file system descriptions, you can optionally specify the <code>MaxResults</code> parameter to limit the number of descriptions in a response. If more file system descriptions remain, Amazon FSx returns a <code>NextToken</code> value in the response. In this case, send a later request with the <code>NextToken</code> request parameter set to the value of <code>NextToken</code> from the last response.</p>
    /// <p>This operation is used in an iterative process to retrieve a list of your file system descriptions. <code>DescribeFileSystems</code> is called first without a <code>NextToken</code>value. Then the operation continues to be called with the <code>NextToken</code> parameter set to the value of the last <code>NextToken</code> value until a response has no <code>NextToken</code>.</p>
    /// <p>When using this operation, keep the following in mind:</p>
    /// <ul>
    /// <li> <p>The implementation might return fewer than <code>MaxResults</code> file system descriptions while still including a <code>NextToken</code> value.</p> </li>
    /// <li> <p>The order of file systems returned in the response of one <code>DescribeFileSystems</code> call and the order of file systems returned across the responses of a multicall iteration is unspecified.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeFileSystems {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_file_systems_input::Builder,
    }
    impl DescribeFileSystems {
        /// Creates a new `DescribeFileSystems`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFileSystemsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFileSystemsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeFileSystemsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeFileSystemsPaginator {
            crate::paginator::DescribeFileSystemsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `FileSystemIds`.
        ///
        /// To override the contents of this collection use [`set_file_system_ids`](Self::set_file_system_ids).
        ///
        /// <p>IDs of the file systems whose descriptions you want to retrieve (String).</p>
        pub fn file_system_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_ids(input.into());
            self
        }
        /// <p>IDs of the file systems whose descriptions you want to retrieve (String).</p>
        pub fn set_file_system_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_file_system_ids(input);
            self
        }
        /// <p>Maximum number of file systems to return in the response (integer). This parameter value must be greater than 0. The number of items that Amazon FSx returns is the minimum of the <code>MaxResults</code> parameter specified in the request and the service's internal maximum number of items per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of file systems to return in the response (integer). This parameter value must be greater than 0. The number of items that Amazon FSx returns is the minimum of the <code>MaxResults</code> parameter specified in the request and the service's internal maximum number of items per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Opaque pagination token returned from a previous <code>DescribeFileSystems</code> operation (String). If a token present, the operation continues the list from where the returning call left off.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Opaque pagination token returned from a previous <code>DescribeFileSystems</code> operation (String). If a token present, the operation continues the list from where the returning call left off.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSnapshots`.
    ///
    /// <p>Returns the description of specific Amazon FSx for OpenZFS snapshots, if a <code>SnapshotIds</code> value is provided. Otherwise, this operation returns all snapshots owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.</p>
    /// <p>When retrieving all snapshots, you can optionally specify the <code>MaxResults</code> parameter to limit the number of snapshots in a response. If more backups remain, Amazon FSx returns a <code>NextToken</code> value in the response. In this case, send a later request with the <code>NextToken</code> request parameter set to the value of <code>NextToken</code> from the last response. </p>
    /// <p>Use this operation in an iterative process to retrieve a list of your snapshots. <code>DescribeSnapshots</code> is called first without a <code>NextToken</code> value. Then the operation continues to be called with the <code>NextToken</code> parameter set to the value of the last <code>NextToken</code> value until a response has no <code>NextToken</code> value.</p>
    /// <p>When using this operation, keep the following in mind:</p>
    /// <ul>
    /// <li> <p>The operation might return fewer than the <code>MaxResults</code> value of snapshot descriptions while still including a <code>NextToken</code> value.</p> </li>
    /// <li> <p>The order of snapshots returned in the response of one <code>DescribeSnapshots</code> call and the order of backups returned across the responses of a multi-call iteration is unspecified. </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSnapshots {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_snapshots_input::Builder,
    }
    impl DescribeSnapshots {
        /// Creates a new `DescribeSnapshots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSnapshotsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSnapshotsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeSnapshotsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeSnapshotsPaginator {
            crate::paginator::DescribeSnapshotsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `SnapshotIds`.
        ///
        /// To override the contents of this collection use [`set_snapshot_ids`](Self::set_snapshot_ids).
        ///
        /// <p>The IDs of the snapshots that you want to retrieve. This parameter value overrides any filters. If any IDs aren't found, a <code>SnapshotNotFound</code> error occurs.</p>
        pub fn snapshot_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_ids(input.into());
            self
        }
        /// <p>The IDs of the snapshots that you want to retrieve. This parameter value overrides any filters. If any IDs aren't found, a <code>SnapshotNotFound</code> error occurs.</p>
        pub fn set_snapshot_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_ids(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters structure. The supported names are <code>file-system-id</code> or <code>volume-id</code>.</p>
        pub fn filters(mut self, input: crate::model::SnapshotFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>The filters structure. The supported names are <code>file-system-id</code> or <code>volume-id</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SnapshotFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of resources to return in the response. This value must be an integer greater than zero.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of resources to return in the response. This value must be an integer greater than zero.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeStorageVirtualMachines`.
    ///
    /// <p>Describes one or more Amazon FSx for NetApp ONTAP storage virtual machines (SVMs).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeStorageVirtualMachines {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_storage_virtual_machines_input::Builder,
    }
    impl DescribeStorageVirtualMachines {
        /// Creates a new `DescribeStorageVirtualMachines`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStorageVirtualMachinesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStorageVirtualMachinesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeStorageVirtualMachinesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeStorageVirtualMachinesPaginator {
            crate::paginator::DescribeStorageVirtualMachinesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `StorageVirtualMachineIds`.
        ///
        /// To override the contents of this collection use [`set_storage_virtual_machine_ids`](Self::set_storage_virtual_machine_ids).
        ///
        /// <p>Enter the ID of one or more SVMs that you want to view.</p>
        pub fn storage_virtual_machine_ids(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.storage_virtual_machine_ids(input.into());
            self
        }
        /// <p>Enter the ID of one or more SVMs that you want to view.</p>
        pub fn set_storage_virtual_machine_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_storage_virtual_machine_ids(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Enter a filter name:value pair to view a select set of SVMs.</p>
        pub fn filters(mut self, input: crate::model::StorageVirtualMachineFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Enter a filter name:value pair to view a select set of SVMs.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StorageVirtualMachineFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of resources to return in the response. This value must be an integer greater than zero.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of resources to return in the response. This value must be an integer greater than zero.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeVolumes`.
    ///
    /// <p>Describes one or more Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volumes.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeVolumes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_volumes_input::Builder,
    }
    impl DescribeVolumes {
        /// Creates a new `DescribeVolumes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeVolumesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeVolumesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeVolumesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeVolumesPaginator {
            crate::paginator::DescribeVolumesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `VolumeIds`.
        ///
        /// To override the contents of this collection use [`set_volume_ids`](Self::set_volume_ids).
        ///
        /// <p>The IDs of the volumes whose descriptions you want to retrieve.</p>
        pub fn volume_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_ids(input.into());
            self
        }
        /// <p>The IDs of the volumes whose descriptions you want to retrieve.</p>
        pub fn set_volume_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_volume_ids(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Enter a filter <code>Name</code> and <code>Values</code> pair to view a select set of volumes.</p>
        pub fn filters(mut self, input: crate::model::VolumeFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Enter a filter <code>Name</code> and <code>Values</code> pair to view a select set of volumes.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VolumeFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of resources to return in the response. This value must be an integer greater than zero.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of resources to return in the response. This value must be an integer greater than zero.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateFileSystemAliases`.
    ///
    /// <p>Use this action to disassociate, or remove, one or more Domain Name Service (DNS) aliases from an Amazon FSx for Windows File Server file system. If you attempt to disassociate a DNS alias that is not associated with the file system, Amazon FSx responds with a 400 Bad Request. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html">Working with DNS Aliases</a>.</p>
    /// <p>The system generated response showing the DNS aliases that Amazon FSx is attempting to disassociate from the file system. Use the API operation to monitor the status of the aliases Amazon FSx is disassociating with the file system.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateFileSystemAliases {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_file_system_aliases_input::Builder,
    }
    impl DisassociateFileSystemAliases {
        /// Creates a new `DisassociateFileSystemAliases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateFileSystemAliasesOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateFileSystemAliasesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>Specifies the file system from which to disassociate the DNS aliases.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(input.into());
            self
        }
        /// <p>Specifies the file system from which to disassociate the DNS aliases.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
        /// Appends an item to `Aliases`.
        ///
        /// To override the contents of this collection use [`set_aliases`](Self::set_aliases).
        ///
        /// <p>An array of one or more DNS alias names to disassociate, or remove, from the file system.</p>
        pub fn aliases(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aliases(input.into());
            self
        }
        /// <p>An array of one or more DNS alias names to disassociate, or remove, from the file system.</p>
        pub fn set_aliases(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_aliases(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists tags for an Amazon FSx file systems and backups in the case of Amazon FSx for Windows File Server.</p>
    /// <p>When retrieving all tags, you can optionally specify the <code>MaxResults</code> parameter to limit the number of tags in a response. If more tags remain, Amazon FSx returns a <code>NextToken</code> value in the response. In this case, send a later request with the <code>NextToken</code> request parameter set to the value of <code>NextToken</code> from the last response.</p>
    /// <p>This action is used in an iterative process to retrieve a list of your tags. <code>ListTagsForResource</code> is called first without a <code>NextToken</code>value. Then the action continues to be called with the <code>NextToken</code> parameter set to the value of the last <code>NextToken</code> value until a response has no <code>NextToken</code>.</p>
    /// <p>When using this action, keep the following in mind:</p>
    /// <ul>
    /// <li> <p>The implementation might return fewer than <code>MaxResults</code> file system descriptions while still including a <code>NextToken</code> value.</p> </li>
    /// <li> <p>The order of tags returned in the response of one <code>ListTagsForResource</code> call and the order of tags returned across the responses of a multi-call iteration is unspecified.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTagsForResourcePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTagsForResourcePaginator {
            crate::paginator::ListTagsForResourcePaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of the Amazon FSx resource that will have its tags listed.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the Amazon FSx resource that will have its tags listed.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>Maximum number of tags to return in the response (integer). This parameter value must be greater than 0. The number of items that Amazon FSx returns is the minimum of the <code>MaxResults</code> parameter specified in the request and the service's internal maximum number of items per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of tags to return in the response (integer). This parameter value must be greater than 0. The number of items that Amazon FSx returns is the minimum of the <code>MaxResults</code> parameter specified in the request and the service's internal maximum number of items per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Opaque pagination token returned from a previous <code>ListTagsForResource</code> operation (String). If a token present, the action continues the list from where the returning call left off.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Opaque pagination token returned from a previous <code>ListTagsForResource</code> operation (String). If a token present, the action continues the list from where the returning call left off.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ReleaseFileSystemNfsV3Locks`.
    ///
    /// <p>Releases the file system lock from an Amazon FSx for OpenZFS file system.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ReleaseFileSystemNfsV3Locks {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::release_file_system_nfs_v3_locks_input::Builder,
    }
    impl ReleaseFileSystemNfsV3Locks {
        /// Creates a new `ReleaseFileSystemNfsV3Locks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ReleaseFileSystemNfsV3LocksOutput,
            aws_smithy_http::result::SdkError<crate::error::ReleaseFileSystemNfsV3LocksError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The globally unique ID of the file system, assigned by Amazon FSx.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(input.into());
            self
        }
        /// <p>The globally unique ID of the file system, assigned by Amazon FSx.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RestoreVolumeFromSnapshot`.
    ///
    /// <p>Returns an Amazon FSx for OpenZFS volume to the state saved by the specified snapshot. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RestoreVolumeFromSnapshot {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::restore_volume_from_snapshot_input::Builder,
    }
    impl RestoreVolumeFromSnapshot {
        /// Creates a new `RestoreVolumeFromSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestoreVolumeFromSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::RestoreVolumeFromSnapshotError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The ID of the volume that you are restoring.</p>
        pub fn volume_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_id(input.into());
            self
        }
        /// <p>The ID of the volume that you are restoring.</p>
        pub fn set_volume_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_volume_id(input);
            self
        }
        /// <p>The ID of the source snapshot. Specifies the snapshot that you are restoring from.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_id(input.into());
            self
        }
        /// <p>The ID of the source snapshot. Specifies the snapshot that you are restoring from.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_snapshot_id(input);
            self
        }
        /// Appends an item to `Options`.
        ///
        /// To override the contents of this collection use [`set_options`](Self::set_options).
        ///
        /// <p>The settings used when restoring the specified volume from snapshot. </p>
        /// <ul>
        /// <li> <p> <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> - Deletes snapshots between the current state and the specified snapshot. If there are intermediate snapshots and this option isn't used, <code>RestoreVolumeFromSnapshot</code> fails.</p> </li>
        /// <li> <p> <code>DELETE_CLONED_VOLUMES</code> - Deletes any volumes cloned from this volume. If there are any cloned volumes and this option isn't used, <code>RestoreVolumeFromSnapshot</code> fails.</p> </li>
        /// </ul>
        pub fn options(mut self, input: crate::model::RestoreOpenZfsVolumeOption) -> Self {
            self.inner = self.inner.options(input);
            self
        }
        /// <p>The settings used when restoring the specified volume from snapshot. </p>
        /// <ul>
        /// <li> <p> <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> - Deletes snapshots between the current state and the specified snapshot. If there are intermediate snapshots and this option isn't used, <code>RestoreVolumeFromSnapshot</code> fails.</p> </li>
        /// <li> <p> <code>DELETE_CLONED_VOLUMES</code> - Deletes any volumes cloned from this volume. If there are any cloned volumes and this option isn't used, <code>RestoreVolumeFromSnapshot</code> fails.</p> </li>
        /// </ul>
        pub fn set_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RestoreOpenZfsVolumeOption>>,
        ) -> Self {
            self.inner = self.inner.set_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Tags an Amazon FSx resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon FSx resource that you want to tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon FSx resource that you want to tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags for the resource. If a tag with a given key already exists, the value is replaced by the one specified in this parameter.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags for the resource. If a tag with a given key already exists, the value is replaced by the one specified in this parameter.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>This action removes a tag from an Amazon FSx resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the Amazon FSx resource to untag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the Amazon FSx resource to untag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of keys of tags on the resource to untag. In case the tag key doesn't exist, the call will still succeed to be idempotent.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A list of keys of tags on the resource to untag. In case the tag key doesn't exist, the call will still succeed to be idempotent.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDataRepositoryAssociation`.
    ///
    /// <p>Updates the configuration of an existing data repository association on an Amazon FSx for Lustre file system. Data repository associations are supported only for file systems with the <code>Persistent_2</code> deployment type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDataRepositoryAssociation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_data_repository_association_input::Builder,
    }
    impl UpdateDataRepositoryAssociation {
        /// Creates a new `UpdateDataRepositoryAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDataRepositoryAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDataRepositoryAssociationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the data repository association that you are updating.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_id(input.into());
            self
        }
        /// <p>The ID of the data repository association that you are updating.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_id(input);
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.</p>
        /// <p>The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.</p>
        pub fn imported_file_chunk_size(mut self, input: i32) -> Self {
            self.inner = self.inner.imported_file_chunk_size(input);
            self
        }
        /// <p>For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.</p>
        /// <p>The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.</p>
        pub fn set_imported_file_chunk_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_imported_file_chunk_size(input);
            self
        }
        /// <p>The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.</p>
        pub fn s3(mut self, input: crate::model::S3DataRepositoryConfiguration) -> Self {
            self.inner = self.inner.s3(input);
            self
        }
        /// <p>The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.</p>
        pub fn set_s3(
            mut self,
            input: std::option::Option<crate::model::S3DataRepositoryConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_s3(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFileSystem`.
    ///
    /// <p>Use this operation to update the configuration of an existing Amazon FSx file system. You can update multiple properties in a single request.</p>
    /// <p>For Amazon FSx for Windows File Server file systems, you can update the following properties:</p>
    /// <ul>
    /// <li> <p> <code>AuditLogConfiguration</code> </p> </li>
    /// <li> <p> <code>AutomaticBackupRetentionDays</code> </p> </li>
    /// <li> <p> <code>DailyAutomaticBackupStartTime</code> </p> </li>
    /// <li> <p> <code>SelfManagedActiveDirectoryConfiguration</code> </p> </li>
    /// <li> <p> <code>StorageCapacity</code> </p> </li>
    /// <li> <p> <code>ThroughputCapacity</code> </p> </li>
    /// <li> <p> <code>WeeklyMaintenanceStartTime</code> </p> </li>
    /// </ul>
    /// <p>For Amazon FSx for Lustre file systems, you can update the following properties:</p>
    /// <ul>
    /// <li> <p> <code>AutoImportPolicy</code> </p> </li>
    /// <li> <p> <code>AutomaticBackupRetentionDays</code> </p> </li>
    /// <li> <p> <code>DailyAutomaticBackupStartTime</code> </p> </li>
    /// <li> <p> <code>DataCompressionType</code> </p> </li>
    /// <li> <p> <code>StorageCapacity</code> </p> </li>
    /// <li> <p> <code>WeeklyMaintenanceStartTime</code> </p> </li>
    /// </ul>
    /// <p>For Amazon FSx for NetApp ONTAP file systems, you can update the following properties:</p>
    /// <ul>
    /// <li> <p> <code>AutomaticBackupRetentionDays</code> </p> </li>
    /// <li> <p> <code>DailyAutomaticBackupStartTime</code> </p> </li>
    /// <li> <p> <code>DiskIopsConfiguration</code> </p> </li>
    /// <li> <p> <code>FsxAdminPassword</code> </p> </li>
    /// <li> <p> <code>StorageCapacity</code> </p> </li>
    /// <li> <p> <code>WeeklyMaintenanceStartTime</code> </p> </li>
    /// </ul>
    /// <p>For the Amazon FSx for OpenZFS file systems, you can update the following properties:</p>
    /// <ul>
    /// <li> <p> <code>AutomaticBackupRetentionDays</code> </p> </li>
    /// <li> <p> <code>CopyTagsToBackups</code> </p> </li>
    /// <li> <p> <code>CopyTagsToVolumes</code> </p> </li>
    /// <li> <p> <code>DailyAutomaticBackupStartTime</code> </p> </li>
    /// <li> <p> <code>ThroughputCapacity</code> </p> </li>
    /// <li> <p> <code>WeeklyMaintenanceStartTime</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFileSystem {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_file_system_input::Builder,
    }
    impl UpdateFileSystem {
        /// Creates a new `UpdateFileSystem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFileSystemOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFileSystemError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the file system that you are updating.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(input.into());
            self
        }
        /// <p>The ID of the file system that you are updating.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
        /// <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent updates. This string is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent updates. This string is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>Use this parameter to increase the storage capacity of an Amazon FSx for Windows File Server, Amazon FSx for Lustre, or Amazon FSx for NetApp ONTAP file system. Specifies the storage capacity target value, in GiB, to increase the storage capacity for the file system that you're updating. </p> <note>
        /// <p>You can't make a storage capacity increase request if there is an existing storage capacity increase request in progress.</p>
        /// </note>
        /// <p>For Windows file systems, the storage capacity target value must be at least 10 percent greater than the current storage capacity value. To increase storage capacity, the file system must have at least 16 MBps of throughput capacity. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html">Managing storage capacity</a> in the <i>Amazon FSx for Windows File Server User Guide</i>.</p>
        /// <p>For Lustre file systems, the storage capacity target value can be the following:</p>
        /// <ul>
        /// <li> <p>For <code>SCRATCH_2</code>, <code>PERSISTENT_1</code>, and <code>PERSISTENT_2 SSD</code> deployment types, valid values are in multiples of 2400 GiB. The value must be greater than the current storage capacity.</p> </li>
        /// <li> <p>For <code>PERSISTENT HDD</code> file systems, valid values are multiples of 6000 GiB for 12-MBps throughput per TiB file systems and multiples of 1800 GiB for 40-MBps throughput per TiB file systems. The values must be greater than the current storage capacity.</p> </li>
        /// <li> <p>For <code>SCRATCH_1</code> file systems, you can't increase the storage capacity.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-storage-capacity.html">Managing storage and throughput capacity</a> in the <i>Amazon FSx for Lustre User Guide</i>.</p>
        /// <p>For ONTAP file systems, the storage capacity target value must be at least 10 percent greater than the current storage capacity value. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-storage-capacity.html">Managing storage capacity and provisioned IOPS</a> in the <i>Amazon FSx for NetApp ONTAP User Guide</i>.</p>
        pub fn storage_capacity(mut self, input: i32) -> Self {
            self.inner = self.inner.storage_capacity(input);
            self
        }
        /// <p>Use this parameter to increase the storage capacity of an Amazon FSx for Windows File Server, Amazon FSx for Lustre, or Amazon FSx for NetApp ONTAP file system. Specifies the storage capacity target value, in GiB, to increase the storage capacity for the file system that you're updating. </p> <note>
        /// <p>You can't make a storage capacity increase request if there is an existing storage capacity increase request in progress.</p>
        /// </note>
        /// <p>For Windows file systems, the storage capacity target value must be at least 10 percent greater than the current storage capacity value. To increase storage capacity, the file system must have at least 16 MBps of throughput capacity. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html">Managing storage capacity</a> in the <i>Amazon FSx for Windows File Server User Guide</i>.</p>
        /// <p>For Lustre file systems, the storage capacity target value can be the following:</p>
        /// <ul>
        /// <li> <p>For <code>SCRATCH_2</code>, <code>PERSISTENT_1</code>, and <code>PERSISTENT_2 SSD</code> deployment types, valid values are in multiples of 2400 GiB. The value must be greater than the current storage capacity.</p> </li>
        /// <li> <p>For <code>PERSISTENT HDD</code> file systems, valid values are multiples of 6000 GiB for 12-MBps throughput per TiB file systems and multiples of 1800 GiB for 40-MBps throughput per TiB file systems. The values must be greater than the current storage capacity.</p> </li>
        /// <li> <p>For <code>SCRATCH_1</code> file systems, you can't increase the storage capacity.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-storage-capacity.html">Managing storage and throughput capacity</a> in the <i>Amazon FSx for Lustre User Guide</i>.</p>
        /// <p>For ONTAP file systems, the storage capacity target value must be at least 10 percent greater than the current storage capacity value. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-storage-capacity.html">Managing storage capacity and provisioned IOPS</a> in the <i>Amazon FSx for NetApp ONTAP User Guide</i>.</p>
        pub fn set_storage_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_storage_capacity(input);
            self
        }
        /// <p>The configuration updates for an Amazon FSx for Windows File Server file system.</p>
        pub fn windows_configuration(
            mut self,
            input: crate::model::UpdateFileSystemWindowsConfiguration,
        ) -> Self {
            self.inner = self.inner.windows_configuration(input);
            self
        }
        /// <p>The configuration updates for an Amazon FSx for Windows File Server file system.</p>
        pub fn set_windows_configuration(
            mut self,
            input: std::option::Option<crate::model::UpdateFileSystemWindowsConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_windows_configuration(input);
            self
        }
        /// <p>The configuration object for Amazon FSx for Lustre file systems used in the <code>UpdateFileSystem</code> operation.</p>
        pub fn lustre_configuration(
            mut self,
            input: crate::model::UpdateFileSystemLustreConfiguration,
        ) -> Self {
            self.inner = self.inner.lustre_configuration(input);
            self
        }
        /// <p>The configuration object for Amazon FSx for Lustre file systems used in the <code>UpdateFileSystem</code> operation.</p>
        pub fn set_lustre_configuration(
            mut self,
            input: std::option::Option<crate::model::UpdateFileSystemLustreConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_lustre_configuration(input);
            self
        }
        /// <p>The configuration updates for an Amazon FSx for NetApp ONTAP file system.</p>
        pub fn ontap_configuration(
            mut self,
            input: crate::model::UpdateFileSystemOntapConfiguration,
        ) -> Self {
            self.inner = self.inner.ontap_configuration(input);
            self
        }
        /// <p>The configuration updates for an Amazon FSx for NetApp ONTAP file system.</p>
        pub fn set_ontap_configuration(
            mut self,
            input: std::option::Option<crate::model::UpdateFileSystemOntapConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_ontap_configuration(input);
            self
        }
        /// <p>The configuration updates for an Amazon FSx for OpenZFS file system.</p>
        pub fn open_zfs_configuration(
            mut self,
            input: crate::model::UpdateFileSystemOpenZfsConfiguration,
        ) -> Self {
            self.inner = self.inner.open_zfs_configuration(input);
            self
        }
        /// <p>The configuration updates for an Amazon FSx for OpenZFS file system.</p>
        pub fn set_open_zfs_configuration(
            mut self,
            input: std::option::Option<crate::model::UpdateFileSystemOpenZfsConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_open_zfs_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSnapshot`.
    ///
    /// <p>Updates the name of an Amazon FSx for OpenZFS snapshot.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSnapshot {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_snapshot_input::Builder,
    }
    impl UpdateSnapshot {
        /// Creates a new `UpdateSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSnapshotError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The name of the snapshot to update.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the snapshot to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The ID of the snapshot that you want to update, in the format <code>fsvolsnap-0123456789abcdef0</code>.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_id(input.into());
            self
        }
        /// <p>The ID of the snapshot that you want to update, in the format <code>fsvolsnap-0123456789abcdef0</code>.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_snapshot_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateStorageVirtualMachine`.
    ///
    /// <p>Updates an Amazon FSx for ONTAP storage virtual machine (SVM).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateStorageVirtualMachine {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_storage_virtual_machine_input::Builder,
    }
    impl UpdateStorageVirtualMachine {
        /// Creates a new `UpdateStorageVirtualMachine`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateStorageVirtualMachineOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateStorageVirtualMachineError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Updates the Microsoft Active Directory (AD) configuration for an SVM that is joined to an AD.</p>
        pub fn active_directory_configuration(
            mut self,
            input: crate::model::UpdateSvmActiveDirectoryConfiguration,
        ) -> Self {
            self.inner = self.inner.active_directory_configuration(input);
            self
        }
        /// <p>Updates the Microsoft Active Directory (AD) configuration for an SVM that is joined to an AD.</p>
        pub fn set_active_directory_configuration(
            mut self,
            input: std::option::Option<crate::model::UpdateSvmActiveDirectoryConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_active_directory_configuration(input);
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The ID of the SVM that you want to update, in the format <code>svm-0123456789abcdef0</code>.</p>
        pub fn storage_virtual_machine_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.storage_virtual_machine_id(input.into());
            self
        }
        /// <p>The ID of the SVM that you want to update, in the format <code>svm-0123456789abcdef0</code>.</p>
        pub fn set_storage_virtual_machine_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_storage_virtual_machine_id(input);
            self
        }
        /// <p>Enter a new SvmAdminPassword if you are updating it.</p>
        pub fn svm_admin_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.svm_admin_password(input.into());
            self
        }
        /// <p>Enter a new SvmAdminPassword if you are updating it.</p>
        pub fn set_svm_admin_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_svm_admin_password(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateVolume`.
    ///
    /// <p>Updates the configuration of an Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volume.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateVolume {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_volume_input::Builder,
    }
    impl UpdateVolume {
        /// Creates a new `UpdateVolume`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateVolumeOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateVolumeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The ID of the volume that you want to update, in the format <code>fsvol-0123456789abcdef0</code>.</p>
        pub fn volume_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_id(input.into());
            self
        }
        /// <p>The ID of the volume that you want to update, in the format <code>fsvol-0123456789abcdef0</code>.</p>
        pub fn set_volume_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_volume_id(input);
            self
        }
        /// <p>The configuration of the ONTAP volume that you are updating.</p>
        pub fn ontap_configuration(
            mut self,
            input: crate::model::UpdateOntapVolumeConfiguration,
        ) -> Self {
            self.inner = self.inner.ontap_configuration(input);
            self
        }
        /// <p>The configuration of the ONTAP volume that you are updating.</p>
        pub fn set_ontap_configuration(
            mut self,
            input: std::option::Option<crate::model::UpdateOntapVolumeConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_ontap_configuration(input);
            self
        }
        /// <p>The name of the OpenZFS volume. OpenZFS root volumes are automatically named <code>FSX</code>. Child volume names must be unique among their parent volume's children. The name of the volume is part of the mount string for the OpenZFS volume. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the OpenZFS volume. OpenZFS root volumes are automatically named <code>FSX</code>. Child volume names must be unique among their parent volume's children. The name of the volume is part of the mount string for the OpenZFS volume. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The configuration of the OpenZFS volume that you are updating.</p>
        pub fn open_zfs_configuration(
            mut self,
            input: crate::model::UpdateOpenZfsVolumeConfiguration,
        ) -> Self {
            self.inner = self.inner.open_zfs_configuration(input);
            self
        }
        /// <p>The configuration of the OpenZFS volume that you are updating.</p>
        pub fn set_open_zfs_configuration(
            mut self,
            input: std::option::Option<crate::model::UpdateOpenZfsVolumeConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_open_zfs_configuration(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
