// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AssociateFileSystemAliases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateFileSystemAliasesError {
    /// Kind of error that occurred.
    pub kind: AssociateFileSystemAliasesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateFileSystemAliases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateFileSystemAliasesErrorKind {
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>No Amazon FSx file systems were found based upon supplied parameters.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateFileSystemAliasesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateFileSystemAliasesErrorKind::BadRequest(_inner) => _inner.fmt(f),
            AssociateFileSystemAliasesErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            AssociateFileSystemAliasesErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            AssociateFileSystemAliasesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateFileSystemAliasesError {
    fn code(&self) -> Option<&str> {
        AssociateFileSystemAliasesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateFileSystemAliasesError {
    /// Creates a new `AssociateFileSystemAliasesError`.
    pub fn new(kind: AssociateFileSystemAliasesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateFileSystemAliasesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateFileSystemAliasesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateFileSystemAliasesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateFileSystemAliasesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateFileSystemAliasesErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(
            &self.kind,
            AssociateFileSystemAliasesErrorKind::BadRequest(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateFileSystemAliasesErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(
            &self.kind,
            AssociateFileSystemAliasesErrorKind::FileSystemNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateFileSystemAliasesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            AssociateFileSystemAliasesErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for AssociateFileSystemAliasesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateFileSystemAliasesErrorKind::BadRequest(_inner) => Some(_inner),
            AssociateFileSystemAliasesErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            AssociateFileSystemAliasesErrorKind::InternalServerError(_inner) => Some(_inner),
            AssociateFileSystemAliasesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelDataRepositoryTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelDataRepositoryTaskError {
    /// Kind of error that occurred.
    pub kind: CancelDataRepositoryTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelDataRepositoryTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelDataRepositoryTaskErrorKind {
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>The data repository task could not be canceled because the task has already ended.</p>
    DataRepositoryTaskEnded(crate::error::DataRepositoryTaskEnded),
    /// <p>The data repository task or tasks you specified could not be found.</p>
    DataRepositoryTaskNotFound(crate::error::DataRepositoryTaskNotFound),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The requested operation is not supported for this resource or API.</p>
    UnsupportedOperation(crate::error::UnsupportedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelDataRepositoryTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelDataRepositoryTaskErrorKind::BadRequest(_inner) => _inner.fmt(f),
            CancelDataRepositoryTaskErrorKind::DataRepositoryTaskEnded(_inner) => _inner.fmt(f),
            CancelDataRepositoryTaskErrorKind::DataRepositoryTaskNotFound(_inner) => _inner.fmt(f),
            CancelDataRepositoryTaskErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CancelDataRepositoryTaskErrorKind::UnsupportedOperation(_inner) => _inner.fmt(f),
            CancelDataRepositoryTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelDataRepositoryTaskError {
    fn code(&self) -> Option<&str> {
        CancelDataRepositoryTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelDataRepositoryTaskError {
    /// Creates a new `CancelDataRepositoryTaskError`.
    pub fn new(kind: CancelDataRepositoryTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelDataRepositoryTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelDataRepositoryTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelDataRepositoryTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelDataRepositoryTaskErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelDataRepositoryTaskErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, CancelDataRepositoryTaskErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `CancelDataRepositoryTaskErrorKind::DataRepositoryTaskEnded`.
    pub fn is_data_repository_task_ended(&self) -> bool {
        matches!(
            &self.kind,
            CancelDataRepositoryTaskErrorKind::DataRepositoryTaskEnded(_)
        )
    }
    /// Returns `true` if the error kind is `CancelDataRepositoryTaskErrorKind::DataRepositoryTaskNotFound`.
    pub fn is_data_repository_task_not_found(&self) -> bool {
        matches!(
            &self.kind,
            CancelDataRepositoryTaskErrorKind::DataRepositoryTaskNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `CancelDataRepositoryTaskErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            CancelDataRepositoryTaskErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `CancelDataRepositoryTaskErrorKind::UnsupportedOperation`.
    pub fn is_unsupported_operation(&self) -> bool {
        matches!(
            &self.kind,
            CancelDataRepositoryTaskErrorKind::UnsupportedOperation(_)
        )
    }
}
impl std::error::Error for CancelDataRepositoryTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelDataRepositoryTaskErrorKind::BadRequest(_inner) => Some(_inner),
            CancelDataRepositoryTaskErrorKind::DataRepositoryTaskEnded(_inner) => Some(_inner),
            CancelDataRepositoryTaskErrorKind::DataRepositoryTaskNotFound(_inner) => Some(_inner),
            CancelDataRepositoryTaskErrorKind::InternalServerError(_inner) => Some(_inner),
            CancelDataRepositoryTaskErrorKind::UnsupportedOperation(_inner) => Some(_inner),
            CancelDataRepositoryTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CopyBackup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CopyBackupError {
    /// Kind of error that occurred.
    pub kind: CopyBackupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CopyBackup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CopyBackupErrorKind {
    /// <p>No Amazon FSx backups were found based upon the supplied parameters.</p>
    BackupNotFound(crate::error::BackupNotFound),
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>The error returned when a second request is received with the same client request token but different parameters settings. A client request token should always uniquely identify a single request.</p>
    IncompatibleParameterError(crate::error::IncompatibleParameterError),
    /// <p>Amazon FSx doesn't support Multi-AZ Windows File Server copy backup in the destination Region, so the copied backup can't be restored.</p>
    IncompatibleRegionForMultiAz(crate::error::IncompatibleRegionForMultiAz),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The Key Management Service (KMS) key of the destination backup is not valid.</p>
    InvalidDestinationKmsKey(crate::error::InvalidDestinationKmsKey),
    /// <p>The Region provided for <code>SourceRegion</code> is not valid or is in a different Amazon Web Services partition.</p>
    InvalidRegion(crate::error::InvalidRegion),
    /// <p>The Key Management Service (KMS) key of the source backup is not valid.</p>
    InvalidSourceKmsKey(crate::error::InvalidSourceKmsKey),
    /// <p>An error indicating that a particular service limit was exceeded. You can increase some service limits by contacting Amazon Web Services Support.</p>
    ServiceLimitExceeded(crate::error::ServiceLimitExceeded),
    /// <p>The request was rejected because the lifecycle status of the source backup isn't <code>AVAILABLE</code>.</p>
    SourceBackupUnavailable(crate::error::SourceBackupUnavailable),
    /// <p>The requested operation is not supported for this resource or API.</p>
    UnsupportedOperation(crate::error::UnsupportedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CopyBackupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CopyBackupErrorKind::BackupNotFound(_inner) => _inner.fmt(f),
            CopyBackupErrorKind::BadRequest(_inner) => _inner.fmt(f),
            CopyBackupErrorKind::IncompatibleParameterError(_inner) => _inner.fmt(f),
            CopyBackupErrorKind::IncompatibleRegionForMultiAz(_inner) => _inner.fmt(f),
            CopyBackupErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CopyBackupErrorKind::InvalidDestinationKmsKey(_inner) => _inner.fmt(f),
            CopyBackupErrorKind::InvalidRegion(_inner) => _inner.fmt(f),
            CopyBackupErrorKind::InvalidSourceKmsKey(_inner) => _inner.fmt(f),
            CopyBackupErrorKind::ServiceLimitExceeded(_inner) => _inner.fmt(f),
            CopyBackupErrorKind::SourceBackupUnavailable(_inner) => _inner.fmt(f),
            CopyBackupErrorKind::UnsupportedOperation(_inner) => _inner.fmt(f),
            CopyBackupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CopyBackupError {
    fn code(&self) -> Option<&str> {
        CopyBackupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CopyBackupError {
    /// Creates a new `CopyBackupError`.
    pub fn new(kind: CopyBackupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CopyBackupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CopyBackupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CopyBackupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CopyBackupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CopyBackupErrorKind::BackupNotFound`.
    pub fn is_backup_not_found(&self) -> bool {
        matches!(&self.kind, CopyBackupErrorKind::BackupNotFound(_))
    }
    /// Returns `true` if the error kind is `CopyBackupErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, CopyBackupErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `CopyBackupErrorKind::IncompatibleParameterError`.
    pub fn is_incompatible_parameter_error(&self) -> bool {
        matches!(
            &self.kind,
            CopyBackupErrorKind::IncompatibleParameterError(_)
        )
    }
    /// Returns `true` if the error kind is `CopyBackupErrorKind::IncompatibleRegionForMultiAz`.
    pub fn is_incompatible_region_for_multi_az(&self) -> bool {
        matches!(
            &self.kind,
            CopyBackupErrorKind::IncompatibleRegionForMultiAz(_)
        )
    }
    /// Returns `true` if the error kind is `CopyBackupErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, CopyBackupErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `CopyBackupErrorKind::InvalidDestinationKmsKey`.
    pub fn is_invalid_destination_kms_key(&self) -> bool {
        matches!(&self.kind, CopyBackupErrorKind::InvalidDestinationKmsKey(_))
    }
    /// Returns `true` if the error kind is `CopyBackupErrorKind::InvalidRegion`.
    pub fn is_invalid_region(&self) -> bool {
        matches!(&self.kind, CopyBackupErrorKind::InvalidRegion(_))
    }
    /// Returns `true` if the error kind is `CopyBackupErrorKind::InvalidSourceKmsKey`.
    pub fn is_invalid_source_kms_key(&self) -> bool {
        matches!(&self.kind, CopyBackupErrorKind::InvalidSourceKmsKey(_))
    }
    /// Returns `true` if the error kind is `CopyBackupErrorKind::ServiceLimitExceeded`.
    pub fn is_service_limit_exceeded(&self) -> bool {
        matches!(&self.kind, CopyBackupErrorKind::ServiceLimitExceeded(_))
    }
    /// Returns `true` if the error kind is `CopyBackupErrorKind::SourceBackupUnavailable`.
    pub fn is_source_backup_unavailable(&self) -> bool {
        matches!(&self.kind, CopyBackupErrorKind::SourceBackupUnavailable(_))
    }
    /// Returns `true` if the error kind is `CopyBackupErrorKind::UnsupportedOperation`.
    pub fn is_unsupported_operation(&self) -> bool {
        matches!(&self.kind, CopyBackupErrorKind::UnsupportedOperation(_))
    }
}
impl std::error::Error for CopyBackupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CopyBackupErrorKind::BackupNotFound(_inner) => Some(_inner),
            CopyBackupErrorKind::BadRequest(_inner) => Some(_inner),
            CopyBackupErrorKind::IncompatibleParameterError(_inner) => Some(_inner),
            CopyBackupErrorKind::IncompatibleRegionForMultiAz(_inner) => Some(_inner),
            CopyBackupErrorKind::InternalServerError(_inner) => Some(_inner),
            CopyBackupErrorKind::InvalidDestinationKmsKey(_inner) => Some(_inner),
            CopyBackupErrorKind::InvalidRegion(_inner) => Some(_inner),
            CopyBackupErrorKind::InvalidSourceKmsKey(_inner) => Some(_inner),
            CopyBackupErrorKind::ServiceLimitExceeded(_inner) => Some(_inner),
            CopyBackupErrorKind::SourceBackupUnavailable(_inner) => Some(_inner),
            CopyBackupErrorKind::UnsupportedOperation(_inner) => Some(_inner),
            CopyBackupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateBackup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBackupError {
    /// Kind of error that occurred.
    pub kind: CreateBackupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBackup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBackupErrorKind {
    /// <p>Another backup is already under way. Wait for completion before initiating additional backups of this file system.</p>
    BackupInProgress(crate::error::BackupInProgress),
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>No Amazon FSx file systems were found based upon supplied parameters.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>The error returned when a second request is received with the same client request token but different parameters settings. A client request token should always uniquely identify a single request.</p>
    IncompatibleParameterError(crate::error::IncompatibleParameterError),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An error indicating that a particular service limit was exceeded. You can increase some service limits by contacting Amazon Web Services Support.</p>
    ServiceLimitExceeded(crate::error::ServiceLimitExceeded),
    /// <p>The requested operation is not supported for this resource or API.</p>
    UnsupportedOperation(crate::error::UnsupportedOperation),
    /// <p>No Amazon FSx for NetApp ONTAP volumes were found based upon the supplied parameters.</p>
    VolumeNotFound(crate::error::VolumeNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBackupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBackupErrorKind::BackupInProgress(_inner) => _inner.fmt(f),
            CreateBackupErrorKind::BadRequest(_inner) => _inner.fmt(f),
            CreateBackupErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            CreateBackupErrorKind::IncompatibleParameterError(_inner) => _inner.fmt(f),
            CreateBackupErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateBackupErrorKind::ServiceLimitExceeded(_inner) => _inner.fmt(f),
            CreateBackupErrorKind::UnsupportedOperation(_inner) => _inner.fmt(f),
            CreateBackupErrorKind::VolumeNotFound(_inner) => _inner.fmt(f),
            CreateBackupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBackupError {
    fn code(&self) -> Option<&str> {
        CreateBackupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBackupError {
    /// Creates a new `CreateBackupError`.
    pub fn new(kind: CreateBackupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBackupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBackupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBackupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBackupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateBackupErrorKind::BackupInProgress`.
    pub fn is_backup_in_progress(&self) -> bool {
        matches!(&self.kind, CreateBackupErrorKind::BackupInProgress(_))
    }
    /// Returns `true` if the error kind is `CreateBackupErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, CreateBackupErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `CreateBackupErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(&self.kind, CreateBackupErrorKind::FileSystemNotFound(_))
    }
    /// Returns `true` if the error kind is `CreateBackupErrorKind::IncompatibleParameterError`.
    pub fn is_incompatible_parameter_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackupErrorKind::IncompatibleParameterError(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBackupErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, CreateBackupErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `CreateBackupErrorKind::ServiceLimitExceeded`.
    pub fn is_service_limit_exceeded(&self) -> bool {
        matches!(&self.kind, CreateBackupErrorKind::ServiceLimitExceeded(_))
    }
    /// Returns `true` if the error kind is `CreateBackupErrorKind::UnsupportedOperation`.
    pub fn is_unsupported_operation(&self) -> bool {
        matches!(&self.kind, CreateBackupErrorKind::UnsupportedOperation(_))
    }
    /// Returns `true` if the error kind is `CreateBackupErrorKind::VolumeNotFound`.
    pub fn is_volume_not_found(&self) -> bool {
        matches!(&self.kind, CreateBackupErrorKind::VolumeNotFound(_))
    }
}
impl std::error::Error for CreateBackupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBackupErrorKind::BackupInProgress(_inner) => Some(_inner),
            CreateBackupErrorKind::BadRequest(_inner) => Some(_inner),
            CreateBackupErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            CreateBackupErrorKind::IncompatibleParameterError(_inner) => Some(_inner),
            CreateBackupErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateBackupErrorKind::ServiceLimitExceeded(_inner) => Some(_inner),
            CreateBackupErrorKind::UnsupportedOperation(_inner) => Some(_inner),
            CreateBackupErrorKind::VolumeNotFound(_inner) => Some(_inner),
            CreateBackupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDataRepositoryAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDataRepositoryAssociationError {
    /// Kind of error that occurred.
    pub kind: CreateDataRepositoryAssociationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDataRepositoryAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDataRepositoryAssociationErrorKind {
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>No Amazon FSx file systems were found based upon supplied parameters.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>The error returned when a second request is received with the same client request token but different parameters settings. A client request token should always uniquely identify a single request.</p>
    IncompatibleParameterError(crate::error::IncompatibleParameterError),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An error indicating that a particular service limit was exceeded. You can increase some service limits by contacting Amazon Web Services Support.</p>
    ServiceLimitExceeded(crate::error::ServiceLimitExceeded),
    /// <p>The requested operation is not supported for this resource or API.</p>
    UnsupportedOperation(crate::error::UnsupportedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDataRepositoryAssociationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDataRepositoryAssociationErrorKind::BadRequest(_inner) => _inner.fmt(f),
            CreateDataRepositoryAssociationErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            CreateDataRepositoryAssociationErrorKind::IncompatibleParameterError(_inner) => {
                _inner.fmt(f)
            }
            CreateDataRepositoryAssociationErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateDataRepositoryAssociationErrorKind::ServiceLimitExceeded(_inner) => _inner.fmt(f),
            CreateDataRepositoryAssociationErrorKind::UnsupportedOperation(_inner) => _inner.fmt(f),
            CreateDataRepositoryAssociationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDataRepositoryAssociationError {
    fn code(&self) -> Option<&str> {
        CreateDataRepositoryAssociationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDataRepositoryAssociationError {
    /// Creates a new `CreateDataRepositoryAssociationError`.
    pub fn new(
        kind: CreateDataRepositoryAssociationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDataRepositoryAssociationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDataRepositoryAssociationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDataRepositoryAssociationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDataRepositoryAssociationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDataRepositoryAssociationErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataRepositoryAssociationErrorKind::BadRequest(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataRepositoryAssociationErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataRepositoryAssociationErrorKind::FileSystemNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataRepositoryAssociationErrorKind::IncompatibleParameterError`.
    pub fn is_incompatible_parameter_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataRepositoryAssociationErrorKind::IncompatibleParameterError(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataRepositoryAssociationErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataRepositoryAssociationErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataRepositoryAssociationErrorKind::ServiceLimitExceeded`.
    pub fn is_service_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataRepositoryAssociationErrorKind::ServiceLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataRepositoryAssociationErrorKind::UnsupportedOperation`.
    pub fn is_unsupported_operation(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataRepositoryAssociationErrorKind::UnsupportedOperation(_)
        )
    }
}
impl std::error::Error for CreateDataRepositoryAssociationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDataRepositoryAssociationErrorKind::BadRequest(_inner) => Some(_inner),
            CreateDataRepositoryAssociationErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            CreateDataRepositoryAssociationErrorKind::IncompatibleParameterError(_inner) => {
                Some(_inner)
            }
            CreateDataRepositoryAssociationErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateDataRepositoryAssociationErrorKind::ServiceLimitExceeded(_inner) => Some(_inner),
            CreateDataRepositoryAssociationErrorKind::UnsupportedOperation(_inner) => Some(_inner),
            CreateDataRepositoryAssociationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDataRepositoryTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDataRepositoryTaskError {
    /// Kind of error that occurred.
    pub kind: CreateDataRepositoryTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDataRepositoryTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDataRepositoryTaskErrorKind {
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>An existing data repository task is currently executing on the file system. Wait until the existing task has completed, then create the new task.</p>
    DataRepositoryTaskExecuting(crate::error::DataRepositoryTaskExecuting),
    /// <p>No Amazon FSx file systems were found based upon supplied parameters.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>The error returned when a second request is received with the same client request token but different parameters settings. A client request token should always uniquely identify a single request.</p>
    IncompatibleParameterError(crate::error::IncompatibleParameterError),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An error indicating that a particular service limit was exceeded. You can increase some service limits by contacting Amazon Web Services Support.</p>
    ServiceLimitExceeded(crate::error::ServiceLimitExceeded),
    /// <p>The requested operation is not supported for this resource or API.</p>
    UnsupportedOperation(crate::error::UnsupportedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDataRepositoryTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDataRepositoryTaskErrorKind::BadRequest(_inner) => _inner.fmt(f),
            CreateDataRepositoryTaskErrorKind::DataRepositoryTaskExecuting(_inner) => _inner.fmt(f),
            CreateDataRepositoryTaskErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            CreateDataRepositoryTaskErrorKind::IncompatibleParameterError(_inner) => _inner.fmt(f),
            CreateDataRepositoryTaskErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateDataRepositoryTaskErrorKind::ServiceLimitExceeded(_inner) => _inner.fmt(f),
            CreateDataRepositoryTaskErrorKind::UnsupportedOperation(_inner) => _inner.fmt(f),
            CreateDataRepositoryTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDataRepositoryTaskError {
    fn code(&self) -> Option<&str> {
        CreateDataRepositoryTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDataRepositoryTaskError {
    /// Creates a new `CreateDataRepositoryTaskError`.
    pub fn new(kind: CreateDataRepositoryTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDataRepositoryTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDataRepositoryTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDataRepositoryTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDataRepositoryTaskErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDataRepositoryTaskErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, CreateDataRepositoryTaskErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `CreateDataRepositoryTaskErrorKind::DataRepositoryTaskExecuting`.
    pub fn is_data_repository_task_executing(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataRepositoryTaskErrorKind::DataRepositoryTaskExecuting(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataRepositoryTaskErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataRepositoryTaskErrorKind::FileSystemNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataRepositoryTaskErrorKind::IncompatibleParameterError`.
    pub fn is_incompatible_parameter_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataRepositoryTaskErrorKind::IncompatibleParameterError(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataRepositoryTaskErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataRepositoryTaskErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataRepositoryTaskErrorKind::ServiceLimitExceeded`.
    pub fn is_service_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataRepositoryTaskErrorKind::ServiceLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataRepositoryTaskErrorKind::UnsupportedOperation`.
    pub fn is_unsupported_operation(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataRepositoryTaskErrorKind::UnsupportedOperation(_)
        )
    }
}
impl std::error::Error for CreateDataRepositoryTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDataRepositoryTaskErrorKind::BadRequest(_inner) => Some(_inner),
            CreateDataRepositoryTaskErrorKind::DataRepositoryTaskExecuting(_inner) => Some(_inner),
            CreateDataRepositoryTaskErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            CreateDataRepositoryTaskErrorKind::IncompatibleParameterError(_inner) => Some(_inner),
            CreateDataRepositoryTaskErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateDataRepositoryTaskErrorKind::ServiceLimitExceeded(_inner) => Some(_inner),
            CreateDataRepositoryTaskErrorKind::UnsupportedOperation(_inner) => Some(_inner),
            CreateDataRepositoryTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateFileSystem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateFileSystemError {
    /// Kind of error that occurred.
    pub kind: CreateFileSystemErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateFileSystem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateFileSystemErrorKind {
    /// <p>An Active Directory error.</p>
    ActiveDirectoryError(crate::error::ActiveDirectoryError),
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>The error returned when a second request is received with the same client request token but different parameters settings. A client request token should always uniquely identify a single request.</p>
    IncompatibleParameterError(crate::error::IncompatibleParameterError),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The path provided for data repository export isn't valid.</p>
    InvalidExportPath(crate::error::InvalidExportPath),
    /// <p>The path provided for data repository import isn't valid.</p>
    InvalidImportPath(crate::error::InvalidImportPath),
    /// <p>One or more network settings specified in the request are invalid.</p>
    InvalidNetworkSettings(crate::error::InvalidNetworkSettings),
    /// <p>An invalid value for <code>PerUnitStorageThroughput</code> was provided. Please create your file system again, using a valid value.</p>
    InvalidPerUnitStorageThroughput(crate::error::InvalidPerUnitStorageThroughput),
    /// <p>A file system configuration is required for this operation.</p>
    MissingFileSystemConfiguration(crate::error::MissingFileSystemConfiguration),
    /// <p>An error indicating that a particular service limit was exceeded. You can increase some service limits by contacting Amazon Web Services Support.</p>
    ServiceLimitExceeded(crate::error::ServiceLimitExceeded),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateFileSystemError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateFileSystemErrorKind::ActiveDirectoryError(_inner) => _inner.fmt(f),
            CreateFileSystemErrorKind::BadRequest(_inner) => _inner.fmt(f),
            CreateFileSystemErrorKind::IncompatibleParameterError(_inner) => _inner.fmt(f),
            CreateFileSystemErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateFileSystemErrorKind::InvalidExportPath(_inner) => _inner.fmt(f),
            CreateFileSystemErrorKind::InvalidImportPath(_inner) => _inner.fmt(f),
            CreateFileSystemErrorKind::InvalidNetworkSettings(_inner) => _inner.fmt(f),
            CreateFileSystemErrorKind::InvalidPerUnitStorageThroughput(_inner) => _inner.fmt(f),
            CreateFileSystemErrorKind::MissingFileSystemConfiguration(_inner) => _inner.fmt(f),
            CreateFileSystemErrorKind::ServiceLimitExceeded(_inner) => _inner.fmt(f),
            CreateFileSystemErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateFileSystemError {
    fn code(&self) -> Option<&str> {
        CreateFileSystemError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateFileSystemError {
    /// Creates a new `CreateFileSystemError`.
    pub fn new(kind: CreateFileSystemErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateFileSystemError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateFileSystemErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateFileSystemError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateFileSystemErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateFileSystemErrorKind::ActiveDirectoryError`.
    pub fn is_active_directory_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateFileSystemErrorKind::ActiveDirectoryError(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFileSystemErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, CreateFileSystemErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `CreateFileSystemErrorKind::IncompatibleParameterError`.
    pub fn is_incompatible_parameter_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateFileSystemErrorKind::IncompatibleParameterError(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFileSystemErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateFileSystemErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFileSystemErrorKind::InvalidExportPath`.
    pub fn is_invalid_export_path(&self) -> bool {
        matches!(&self.kind, CreateFileSystemErrorKind::InvalidExportPath(_))
    }
    /// Returns `true` if the error kind is `CreateFileSystemErrorKind::InvalidImportPath`.
    pub fn is_invalid_import_path(&self) -> bool {
        matches!(&self.kind, CreateFileSystemErrorKind::InvalidImportPath(_))
    }
    /// Returns `true` if the error kind is `CreateFileSystemErrorKind::InvalidNetworkSettings`.
    pub fn is_invalid_network_settings(&self) -> bool {
        matches!(
            &self.kind,
            CreateFileSystemErrorKind::InvalidNetworkSettings(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFileSystemErrorKind::InvalidPerUnitStorageThroughput`.
    pub fn is_invalid_per_unit_storage_throughput(&self) -> bool {
        matches!(
            &self.kind,
            CreateFileSystemErrorKind::InvalidPerUnitStorageThroughput(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFileSystemErrorKind::MissingFileSystemConfiguration`.
    pub fn is_missing_file_system_configuration(&self) -> bool {
        matches!(
            &self.kind,
            CreateFileSystemErrorKind::MissingFileSystemConfiguration(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFileSystemErrorKind::ServiceLimitExceeded`.
    pub fn is_service_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CreateFileSystemErrorKind::ServiceLimitExceeded(_)
        )
    }
}
impl std::error::Error for CreateFileSystemError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateFileSystemErrorKind::ActiveDirectoryError(_inner) => Some(_inner),
            CreateFileSystemErrorKind::BadRequest(_inner) => Some(_inner),
            CreateFileSystemErrorKind::IncompatibleParameterError(_inner) => Some(_inner),
            CreateFileSystemErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateFileSystemErrorKind::InvalidExportPath(_inner) => Some(_inner),
            CreateFileSystemErrorKind::InvalidImportPath(_inner) => Some(_inner),
            CreateFileSystemErrorKind::InvalidNetworkSettings(_inner) => Some(_inner),
            CreateFileSystemErrorKind::InvalidPerUnitStorageThroughput(_inner) => Some(_inner),
            CreateFileSystemErrorKind::MissingFileSystemConfiguration(_inner) => Some(_inner),
            CreateFileSystemErrorKind::ServiceLimitExceeded(_inner) => Some(_inner),
            CreateFileSystemErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateFileSystemFromBackup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateFileSystemFromBackupError {
    /// Kind of error that occurred.
    pub kind: CreateFileSystemFromBackupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateFileSystemFromBackup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateFileSystemFromBackupErrorKind {
    /// <p>An Active Directory error.</p>
    ActiveDirectoryError(crate::error::ActiveDirectoryError),
    /// <p>No Amazon FSx backups were found based upon the supplied parameters.</p>
    BackupNotFound(crate::error::BackupNotFound),
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>The error returned when a second request is received with the same client request token but different parameters settings. A client request token should always uniquely identify a single request.</p>
    IncompatibleParameterError(crate::error::IncompatibleParameterError),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>One or more network settings specified in the request are invalid.</p>
    InvalidNetworkSettings(crate::error::InvalidNetworkSettings),
    /// <p>An invalid value for <code>PerUnitStorageThroughput</code> was provided. Please create your file system again, using a valid value.</p>
    InvalidPerUnitStorageThroughput(crate::error::InvalidPerUnitStorageThroughput),
    /// <p>A file system configuration is required for this operation.</p>
    MissingFileSystemConfiguration(crate::error::MissingFileSystemConfiguration),
    /// <p>An error indicating that a particular service limit was exceeded. You can increase some service limits by contacting Amazon Web Services Support.</p>
    ServiceLimitExceeded(crate::error::ServiceLimitExceeded),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateFileSystemFromBackupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateFileSystemFromBackupErrorKind::ActiveDirectoryError(_inner) => _inner.fmt(f),
            CreateFileSystemFromBackupErrorKind::BackupNotFound(_inner) => _inner.fmt(f),
            CreateFileSystemFromBackupErrorKind::BadRequest(_inner) => _inner.fmt(f),
            CreateFileSystemFromBackupErrorKind::IncompatibleParameterError(_inner) => {
                _inner.fmt(f)
            }
            CreateFileSystemFromBackupErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateFileSystemFromBackupErrorKind::InvalidNetworkSettings(_inner) => _inner.fmt(f),
            CreateFileSystemFromBackupErrorKind::InvalidPerUnitStorageThroughput(_inner) => {
                _inner.fmt(f)
            }
            CreateFileSystemFromBackupErrorKind::MissingFileSystemConfiguration(_inner) => {
                _inner.fmt(f)
            }
            CreateFileSystemFromBackupErrorKind::ServiceLimitExceeded(_inner) => _inner.fmt(f),
            CreateFileSystemFromBackupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateFileSystemFromBackupError {
    fn code(&self) -> Option<&str> {
        CreateFileSystemFromBackupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateFileSystemFromBackupError {
    /// Creates a new `CreateFileSystemFromBackupError`.
    pub fn new(kind: CreateFileSystemFromBackupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateFileSystemFromBackupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateFileSystemFromBackupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateFileSystemFromBackupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateFileSystemFromBackupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateFileSystemFromBackupErrorKind::ActiveDirectoryError`.
    pub fn is_active_directory_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateFileSystemFromBackupErrorKind::ActiveDirectoryError(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFileSystemFromBackupErrorKind::BackupNotFound`.
    pub fn is_backup_not_found(&self) -> bool {
        matches!(
            &self.kind,
            CreateFileSystemFromBackupErrorKind::BackupNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFileSystemFromBackupErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(
            &self.kind,
            CreateFileSystemFromBackupErrorKind::BadRequest(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFileSystemFromBackupErrorKind::IncompatibleParameterError`.
    pub fn is_incompatible_parameter_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateFileSystemFromBackupErrorKind::IncompatibleParameterError(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFileSystemFromBackupErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateFileSystemFromBackupErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFileSystemFromBackupErrorKind::InvalidNetworkSettings`.
    pub fn is_invalid_network_settings(&self) -> bool {
        matches!(
            &self.kind,
            CreateFileSystemFromBackupErrorKind::InvalidNetworkSettings(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFileSystemFromBackupErrorKind::InvalidPerUnitStorageThroughput`.
    pub fn is_invalid_per_unit_storage_throughput(&self) -> bool {
        matches!(
            &self.kind,
            CreateFileSystemFromBackupErrorKind::InvalidPerUnitStorageThroughput(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFileSystemFromBackupErrorKind::MissingFileSystemConfiguration`.
    pub fn is_missing_file_system_configuration(&self) -> bool {
        matches!(
            &self.kind,
            CreateFileSystemFromBackupErrorKind::MissingFileSystemConfiguration(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFileSystemFromBackupErrorKind::ServiceLimitExceeded`.
    pub fn is_service_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CreateFileSystemFromBackupErrorKind::ServiceLimitExceeded(_)
        )
    }
}
impl std::error::Error for CreateFileSystemFromBackupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateFileSystemFromBackupErrorKind::ActiveDirectoryError(_inner) => Some(_inner),
            CreateFileSystemFromBackupErrorKind::BackupNotFound(_inner) => Some(_inner),
            CreateFileSystemFromBackupErrorKind::BadRequest(_inner) => Some(_inner),
            CreateFileSystemFromBackupErrorKind::IncompatibleParameterError(_inner) => Some(_inner),
            CreateFileSystemFromBackupErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateFileSystemFromBackupErrorKind::InvalidNetworkSettings(_inner) => Some(_inner),
            CreateFileSystemFromBackupErrorKind::InvalidPerUnitStorageThroughput(_inner) => {
                Some(_inner)
            }
            CreateFileSystemFromBackupErrorKind::MissingFileSystemConfiguration(_inner) => {
                Some(_inner)
            }
            CreateFileSystemFromBackupErrorKind::ServiceLimitExceeded(_inner) => Some(_inner),
            CreateFileSystemFromBackupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSnapshotError {
    /// Kind of error that occurred.
    pub kind: CreateSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSnapshotErrorKind {
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An error indicating that a particular service limit was exceeded. You can increase some service limits by contacting Amazon Web Services Support.</p>
    ServiceLimitExceeded(crate::error::ServiceLimitExceeded),
    /// <p>No Amazon FSx for NetApp ONTAP volumes were found based upon the supplied parameters.</p>
    VolumeNotFound(crate::error::VolumeNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSnapshotErrorKind::BadRequest(_inner) => _inner.fmt(f),
            CreateSnapshotErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateSnapshotErrorKind::ServiceLimitExceeded(_inner) => _inner.fmt(f),
            CreateSnapshotErrorKind::VolumeNotFound(_inner) => _inner.fmt(f),
            CreateSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSnapshotError {
    fn code(&self) -> Option<&str> {
        CreateSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSnapshotError {
    /// Creates a new `CreateSnapshotError`.
    pub fn new(kind: CreateSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSnapshotErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, CreateSnapshotErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `CreateSnapshotErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, CreateSnapshotErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `CreateSnapshotErrorKind::ServiceLimitExceeded`.
    pub fn is_service_limit_exceeded(&self) -> bool {
        matches!(&self.kind, CreateSnapshotErrorKind::ServiceLimitExceeded(_))
    }
    /// Returns `true` if the error kind is `CreateSnapshotErrorKind::VolumeNotFound`.
    pub fn is_volume_not_found(&self) -> bool {
        matches!(&self.kind, CreateSnapshotErrorKind::VolumeNotFound(_))
    }
}
impl std::error::Error for CreateSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSnapshotErrorKind::BadRequest(_inner) => Some(_inner),
            CreateSnapshotErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateSnapshotErrorKind::ServiceLimitExceeded(_inner) => Some(_inner),
            CreateSnapshotErrorKind::VolumeNotFound(_inner) => Some(_inner),
            CreateSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateStorageVirtualMachine` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateStorageVirtualMachineError {
    /// Kind of error that occurred.
    pub kind: CreateStorageVirtualMachineErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateStorageVirtualMachine` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateStorageVirtualMachineErrorKind {
    /// <p>An Active Directory error.</p>
    ActiveDirectoryError(crate::error::ActiveDirectoryError),
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>No Amazon FSx file systems were found based upon supplied parameters.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>The error returned when a second request is received with the same client request token but different parameters settings. A client request token should always uniquely identify a single request.</p>
    IncompatibleParameterError(crate::error::IncompatibleParameterError),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An error indicating that a particular service limit was exceeded. You can increase some service limits by contacting Amazon Web Services Support.</p>
    ServiceLimitExceeded(crate::error::ServiceLimitExceeded),
    /// <p>The requested operation is not supported for this resource or API.</p>
    UnsupportedOperation(crate::error::UnsupportedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateStorageVirtualMachineError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateStorageVirtualMachineErrorKind::ActiveDirectoryError(_inner) => _inner.fmt(f),
            CreateStorageVirtualMachineErrorKind::BadRequest(_inner) => _inner.fmt(f),
            CreateStorageVirtualMachineErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            CreateStorageVirtualMachineErrorKind::IncompatibleParameterError(_inner) => {
                _inner.fmt(f)
            }
            CreateStorageVirtualMachineErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateStorageVirtualMachineErrorKind::ServiceLimitExceeded(_inner) => _inner.fmt(f),
            CreateStorageVirtualMachineErrorKind::UnsupportedOperation(_inner) => _inner.fmt(f),
            CreateStorageVirtualMachineErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateStorageVirtualMachineError {
    fn code(&self) -> Option<&str> {
        CreateStorageVirtualMachineError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateStorageVirtualMachineError {
    /// Creates a new `CreateStorageVirtualMachineError`.
    pub fn new(kind: CreateStorageVirtualMachineErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateStorageVirtualMachineError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateStorageVirtualMachineErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateStorageVirtualMachineError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateStorageVirtualMachineErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateStorageVirtualMachineErrorKind::ActiveDirectoryError`.
    pub fn is_active_directory_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateStorageVirtualMachineErrorKind::ActiveDirectoryError(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStorageVirtualMachineErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(
            &self.kind,
            CreateStorageVirtualMachineErrorKind::BadRequest(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStorageVirtualMachineErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(
            &self.kind,
            CreateStorageVirtualMachineErrorKind::FileSystemNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStorageVirtualMachineErrorKind::IncompatibleParameterError`.
    pub fn is_incompatible_parameter_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateStorageVirtualMachineErrorKind::IncompatibleParameterError(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStorageVirtualMachineErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateStorageVirtualMachineErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStorageVirtualMachineErrorKind::ServiceLimitExceeded`.
    pub fn is_service_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CreateStorageVirtualMachineErrorKind::ServiceLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStorageVirtualMachineErrorKind::UnsupportedOperation`.
    pub fn is_unsupported_operation(&self) -> bool {
        matches!(
            &self.kind,
            CreateStorageVirtualMachineErrorKind::UnsupportedOperation(_)
        )
    }
}
impl std::error::Error for CreateStorageVirtualMachineError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateStorageVirtualMachineErrorKind::ActiveDirectoryError(_inner) => Some(_inner),
            CreateStorageVirtualMachineErrorKind::BadRequest(_inner) => Some(_inner),
            CreateStorageVirtualMachineErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            CreateStorageVirtualMachineErrorKind::IncompatibleParameterError(_inner) => {
                Some(_inner)
            }
            CreateStorageVirtualMachineErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateStorageVirtualMachineErrorKind::ServiceLimitExceeded(_inner) => Some(_inner),
            CreateStorageVirtualMachineErrorKind::UnsupportedOperation(_inner) => Some(_inner),
            CreateStorageVirtualMachineErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateVolume` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateVolumeError {
    /// Kind of error that occurred.
    pub kind: CreateVolumeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateVolume` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateVolumeErrorKind {
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>No Amazon FSx file systems were found based upon supplied parameters.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>The error returned when a second request is received with the same client request token but different parameters settings. A client request token should always uniquely identify a single request.</p>
    IncompatibleParameterError(crate::error::IncompatibleParameterError),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>A volume configuration is required for this operation.</p>
    MissingVolumeConfiguration(crate::error::MissingVolumeConfiguration),
    /// <p>An error indicating that a particular service limit was exceeded. You can increase some service limits by contacting Amazon Web Services Support.</p>
    ServiceLimitExceeded(crate::error::ServiceLimitExceeded),
    /// <p>No Amazon FSx for NetApp ONTAP SVMs were found based upon the supplied parameters.</p>
    StorageVirtualMachineNotFound(crate::error::StorageVirtualMachineNotFound),
    /// <p>The requested operation is not supported for this resource or API.</p>
    UnsupportedOperation(crate::error::UnsupportedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateVolumeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateVolumeErrorKind::BadRequest(_inner) => _inner.fmt(f),
            CreateVolumeErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            CreateVolumeErrorKind::IncompatibleParameterError(_inner) => _inner.fmt(f),
            CreateVolumeErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateVolumeErrorKind::MissingVolumeConfiguration(_inner) => _inner.fmt(f),
            CreateVolumeErrorKind::ServiceLimitExceeded(_inner) => _inner.fmt(f),
            CreateVolumeErrorKind::StorageVirtualMachineNotFound(_inner) => _inner.fmt(f),
            CreateVolumeErrorKind::UnsupportedOperation(_inner) => _inner.fmt(f),
            CreateVolumeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateVolumeError {
    fn code(&self) -> Option<&str> {
        CreateVolumeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateVolumeError {
    /// Creates a new `CreateVolumeError`.
    pub fn new(kind: CreateVolumeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateVolumeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateVolumeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateVolumeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateVolumeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateVolumeErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, CreateVolumeErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `CreateVolumeErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(&self.kind, CreateVolumeErrorKind::FileSystemNotFound(_))
    }
    /// Returns `true` if the error kind is `CreateVolumeErrorKind::IncompatibleParameterError`.
    pub fn is_incompatible_parameter_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateVolumeErrorKind::IncompatibleParameterError(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVolumeErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, CreateVolumeErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `CreateVolumeErrorKind::MissingVolumeConfiguration`.
    pub fn is_missing_volume_configuration(&self) -> bool {
        matches!(
            &self.kind,
            CreateVolumeErrorKind::MissingVolumeConfiguration(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVolumeErrorKind::ServiceLimitExceeded`.
    pub fn is_service_limit_exceeded(&self) -> bool {
        matches!(&self.kind, CreateVolumeErrorKind::ServiceLimitExceeded(_))
    }
    /// Returns `true` if the error kind is `CreateVolumeErrorKind::StorageVirtualMachineNotFound`.
    pub fn is_storage_virtual_machine_not_found(&self) -> bool {
        matches!(
            &self.kind,
            CreateVolumeErrorKind::StorageVirtualMachineNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVolumeErrorKind::UnsupportedOperation`.
    pub fn is_unsupported_operation(&self) -> bool {
        matches!(&self.kind, CreateVolumeErrorKind::UnsupportedOperation(_))
    }
}
impl std::error::Error for CreateVolumeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateVolumeErrorKind::BadRequest(_inner) => Some(_inner),
            CreateVolumeErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            CreateVolumeErrorKind::IncompatibleParameterError(_inner) => Some(_inner),
            CreateVolumeErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateVolumeErrorKind::MissingVolumeConfiguration(_inner) => Some(_inner),
            CreateVolumeErrorKind::ServiceLimitExceeded(_inner) => Some(_inner),
            CreateVolumeErrorKind::StorageVirtualMachineNotFound(_inner) => Some(_inner),
            CreateVolumeErrorKind::UnsupportedOperation(_inner) => Some(_inner),
            CreateVolumeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateVolumeFromBackup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateVolumeFromBackupError {
    /// Kind of error that occurred.
    pub kind: CreateVolumeFromBackupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateVolumeFromBackup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateVolumeFromBackupErrorKind {
    /// <p>No Amazon FSx backups were found based upon the supplied parameters.</p>
    BackupNotFound(crate::error::BackupNotFound),
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>No Amazon FSx file systems were found based upon supplied parameters.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>The error returned when a second request is received with the same client request token but different parameters settings. A client request token should always uniquely identify a single request.</p>
    IncompatibleParameterError(crate::error::IncompatibleParameterError),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>A volume configuration is required for this operation.</p>
    MissingVolumeConfiguration(crate::error::MissingVolumeConfiguration),
    /// <p>An error indicating that a particular service limit was exceeded. You can increase some service limits by contacting Amazon Web Services Support.</p>
    ServiceLimitExceeded(crate::error::ServiceLimitExceeded),
    /// <p>No Amazon FSx for NetApp ONTAP SVMs were found based upon the supplied parameters.</p>
    StorageVirtualMachineNotFound(crate::error::StorageVirtualMachineNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateVolumeFromBackupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateVolumeFromBackupErrorKind::BackupNotFound(_inner) => _inner.fmt(f),
            CreateVolumeFromBackupErrorKind::BadRequest(_inner) => _inner.fmt(f),
            CreateVolumeFromBackupErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            CreateVolumeFromBackupErrorKind::IncompatibleParameterError(_inner) => _inner.fmt(f),
            CreateVolumeFromBackupErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateVolumeFromBackupErrorKind::MissingVolumeConfiguration(_inner) => _inner.fmt(f),
            CreateVolumeFromBackupErrorKind::ServiceLimitExceeded(_inner) => _inner.fmt(f),
            CreateVolumeFromBackupErrorKind::StorageVirtualMachineNotFound(_inner) => _inner.fmt(f),
            CreateVolumeFromBackupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateVolumeFromBackupError {
    fn code(&self) -> Option<&str> {
        CreateVolumeFromBackupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateVolumeFromBackupError {
    /// Creates a new `CreateVolumeFromBackupError`.
    pub fn new(kind: CreateVolumeFromBackupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateVolumeFromBackupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateVolumeFromBackupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateVolumeFromBackupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateVolumeFromBackupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateVolumeFromBackupErrorKind::BackupNotFound`.
    pub fn is_backup_not_found(&self) -> bool {
        matches!(
            &self.kind,
            CreateVolumeFromBackupErrorKind::BackupNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVolumeFromBackupErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, CreateVolumeFromBackupErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `CreateVolumeFromBackupErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(
            &self.kind,
            CreateVolumeFromBackupErrorKind::FileSystemNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVolumeFromBackupErrorKind::IncompatibleParameterError`.
    pub fn is_incompatible_parameter_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateVolumeFromBackupErrorKind::IncompatibleParameterError(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVolumeFromBackupErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateVolumeFromBackupErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVolumeFromBackupErrorKind::MissingVolumeConfiguration`.
    pub fn is_missing_volume_configuration(&self) -> bool {
        matches!(
            &self.kind,
            CreateVolumeFromBackupErrorKind::MissingVolumeConfiguration(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVolumeFromBackupErrorKind::ServiceLimitExceeded`.
    pub fn is_service_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CreateVolumeFromBackupErrorKind::ServiceLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVolumeFromBackupErrorKind::StorageVirtualMachineNotFound`.
    pub fn is_storage_virtual_machine_not_found(&self) -> bool {
        matches!(
            &self.kind,
            CreateVolumeFromBackupErrorKind::StorageVirtualMachineNotFound(_)
        )
    }
}
impl std::error::Error for CreateVolumeFromBackupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateVolumeFromBackupErrorKind::BackupNotFound(_inner) => Some(_inner),
            CreateVolumeFromBackupErrorKind::BadRequest(_inner) => Some(_inner),
            CreateVolumeFromBackupErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            CreateVolumeFromBackupErrorKind::IncompatibleParameterError(_inner) => Some(_inner),
            CreateVolumeFromBackupErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateVolumeFromBackupErrorKind::MissingVolumeConfiguration(_inner) => Some(_inner),
            CreateVolumeFromBackupErrorKind::ServiceLimitExceeded(_inner) => Some(_inner),
            CreateVolumeFromBackupErrorKind::StorageVirtualMachineNotFound(_inner) => Some(_inner),
            CreateVolumeFromBackupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBackup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBackupError {
    /// Kind of error that occurred.
    pub kind: DeleteBackupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBackup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBackupErrorKind {
    /// <p>You can't delete a backup while it's being copied.</p>
    BackupBeingCopied(crate::error::BackupBeingCopied),
    /// <p>Another backup is already under way. Wait for completion before initiating additional backups of this file system.</p>
    BackupInProgress(crate::error::BackupInProgress),
    /// <p>No Amazon FSx backups were found based upon the supplied parameters.</p>
    BackupNotFound(crate::error::BackupNotFound),
    /// <p>You can't delete a backup while it's being used to restore a file system.</p>
    BackupRestoring(crate::error::BackupRestoring),
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>The error returned when a second request is received with the same client request token but different parameters settings. A client request token should always uniquely identify a single request.</p>
    IncompatibleParameterError(crate::error::IncompatibleParameterError),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBackupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBackupErrorKind::BackupBeingCopied(_inner) => _inner.fmt(f),
            DeleteBackupErrorKind::BackupInProgress(_inner) => _inner.fmt(f),
            DeleteBackupErrorKind::BackupNotFound(_inner) => _inner.fmt(f),
            DeleteBackupErrorKind::BackupRestoring(_inner) => _inner.fmt(f),
            DeleteBackupErrorKind::BadRequest(_inner) => _inner.fmt(f),
            DeleteBackupErrorKind::IncompatibleParameterError(_inner) => _inner.fmt(f),
            DeleteBackupErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteBackupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBackupError {
    fn code(&self) -> Option<&str> {
        DeleteBackupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBackupError {
    /// Creates a new `DeleteBackupError`.
    pub fn new(kind: DeleteBackupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBackupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBackupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBackupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBackupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBackupErrorKind::BackupBeingCopied`.
    pub fn is_backup_being_copied(&self) -> bool {
        matches!(&self.kind, DeleteBackupErrorKind::BackupBeingCopied(_))
    }
    /// Returns `true` if the error kind is `DeleteBackupErrorKind::BackupInProgress`.
    pub fn is_backup_in_progress(&self) -> bool {
        matches!(&self.kind, DeleteBackupErrorKind::BackupInProgress(_))
    }
    /// Returns `true` if the error kind is `DeleteBackupErrorKind::BackupNotFound`.
    pub fn is_backup_not_found(&self) -> bool {
        matches!(&self.kind, DeleteBackupErrorKind::BackupNotFound(_))
    }
    /// Returns `true` if the error kind is `DeleteBackupErrorKind::BackupRestoring`.
    pub fn is_backup_restoring(&self) -> bool {
        matches!(&self.kind, DeleteBackupErrorKind::BackupRestoring(_))
    }
    /// Returns `true` if the error kind is `DeleteBackupErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, DeleteBackupErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `DeleteBackupErrorKind::IncompatibleParameterError`.
    pub fn is_incompatible_parameter_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackupErrorKind::IncompatibleParameterError(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBackupErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, DeleteBackupErrorKind::InternalServerError(_))
    }
}
impl std::error::Error for DeleteBackupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBackupErrorKind::BackupBeingCopied(_inner) => Some(_inner),
            DeleteBackupErrorKind::BackupInProgress(_inner) => Some(_inner),
            DeleteBackupErrorKind::BackupNotFound(_inner) => Some(_inner),
            DeleteBackupErrorKind::BackupRestoring(_inner) => Some(_inner),
            DeleteBackupErrorKind::BadRequest(_inner) => Some(_inner),
            DeleteBackupErrorKind::IncompatibleParameterError(_inner) => Some(_inner),
            DeleteBackupErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteBackupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDataRepositoryAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDataRepositoryAssociationError {
    /// Kind of error that occurred.
    pub kind: DeleteDataRepositoryAssociationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDataRepositoryAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDataRepositoryAssociationErrorKind {
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>No data repository associations were found based upon the supplied parameters.</p>
    DataRepositoryAssociationNotFound(crate::error::DataRepositoryAssociationNotFound),
    /// <p>The error returned when a second request is received with the same client request token but different parameters settings. A client request token should always uniquely identify a single request.</p>
    IncompatibleParameterError(crate::error::IncompatibleParameterError),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An error indicating that a particular service limit was exceeded. You can increase some service limits by contacting Amazon Web Services Support.</p>
    ServiceLimitExceeded(crate::error::ServiceLimitExceeded),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDataRepositoryAssociationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDataRepositoryAssociationErrorKind::BadRequest(_inner) => _inner.fmt(f),
            DeleteDataRepositoryAssociationErrorKind::DataRepositoryAssociationNotFound(_inner) => {
                _inner.fmt(f)
            }
            DeleteDataRepositoryAssociationErrorKind::IncompatibleParameterError(_inner) => {
                _inner.fmt(f)
            }
            DeleteDataRepositoryAssociationErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteDataRepositoryAssociationErrorKind::ServiceLimitExceeded(_inner) => _inner.fmt(f),
            DeleteDataRepositoryAssociationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDataRepositoryAssociationError {
    fn code(&self) -> Option<&str> {
        DeleteDataRepositoryAssociationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDataRepositoryAssociationError {
    /// Creates a new `DeleteDataRepositoryAssociationError`.
    pub fn new(
        kind: DeleteDataRepositoryAssociationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDataRepositoryAssociationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDataRepositoryAssociationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDataRepositoryAssociationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDataRepositoryAssociationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDataRepositoryAssociationErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataRepositoryAssociationErrorKind::BadRequest(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDataRepositoryAssociationErrorKind::DataRepositoryAssociationNotFound`.
    pub fn is_data_repository_association_not_found(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataRepositoryAssociationErrorKind::DataRepositoryAssociationNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDataRepositoryAssociationErrorKind::IncompatibleParameterError`.
    pub fn is_incompatible_parameter_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataRepositoryAssociationErrorKind::IncompatibleParameterError(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDataRepositoryAssociationErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataRepositoryAssociationErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDataRepositoryAssociationErrorKind::ServiceLimitExceeded`.
    pub fn is_service_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataRepositoryAssociationErrorKind::ServiceLimitExceeded(_)
        )
    }
}
impl std::error::Error for DeleteDataRepositoryAssociationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDataRepositoryAssociationErrorKind::BadRequest(_inner) => Some(_inner),
            DeleteDataRepositoryAssociationErrorKind::DataRepositoryAssociationNotFound(_inner) => {
                Some(_inner)
            }
            DeleteDataRepositoryAssociationErrorKind::IncompatibleParameterError(_inner) => {
                Some(_inner)
            }
            DeleteDataRepositoryAssociationErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteDataRepositoryAssociationErrorKind::ServiceLimitExceeded(_inner) => Some(_inner),
            DeleteDataRepositoryAssociationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFileSystem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFileSystemError {
    /// Kind of error that occurred.
    pub kind: DeleteFileSystemErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFileSystem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFileSystemErrorKind {
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>No Amazon FSx file systems were found based upon supplied parameters.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>The error returned when a second request is received with the same client request token but different parameters settings. A client request token should always uniquely identify a single request.</p>
    IncompatibleParameterError(crate::error::IncompatibleParameterError),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An error indicating that a particular service limit was exceeded. You can increase some service limits by contacting Amazon Web Services Support.</p>
    ServiceLimitExceeded(crate::error::ServiceLimitExceeded),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFileSystemError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFileSystemErrorKind::BadRequest(_inner) => _inner.fmt(f),
            DeleteFileSystemErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            DeleteFileSystemErrorKind::IncompatibleParameterError(_inner) => _inner.fmt(f),
            DeleteFileSystemErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteFileSystemErrorKind::ServiceLimitExceeded(_inner) => _inner.fmt(f),
            DeleteFileSystemErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFileSystemError {
    fn code(&self) -> Option<&str> {
        DeleteFileSystemError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFileSystemError {
    /// Creates a new `DeleteFileSystemError`.
    pub fn new(kind: DeleteFileSystemErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFileSystemError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFileSystemErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFileSystemError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFileSystemErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteFileSystemErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, DeleteFileSystemErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `DeleteFileSystemErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(&self.kind, DeleteFileSystemErrorKind::FileSystemNotFound(_))
    }
    /// Returns `true` if the error kind is `DeleteFileSystemErrorKind::IncompatibleParameterError`.
    pub fn is_incompatible_parameter_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFileSystemErrorKind::IncompatibleParameterError(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFileSystemErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFileSystemErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFileSystemErrorKind::ServiceLimitExceeded`.
    pub fn is_service_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFileSystemErrorKind::ServiceLimitExceeded(_)
        )
    }
}
impl std::error::Error for DeleteFileSystemError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFileSystemErrorKind::BadRequest(_inner) => Some(_inner),
            DeleteFileSystemErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            DeleteFileSystemErrorKind::IncompatibleParameterError(_inner) => Some(_inner),
            DeleteFileSystemErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteFileSystemErrorKind::ServiceLimitExceeded(_inner) => Some(_inner),
            DeleteFileSystemErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSnapshotError {
    /// Kind of error that occurred.
    pub kind: DeleteSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSnapshotErrorKind {
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>No Amazon FSx snapshots were found based on the supplied parameters.</p>
    SnapshotNotFound(crate::error::SnapshotNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSnapshotErrorKind::BadRequest(_inner) => _inner.fmt(f),
            DeleteSnapshotErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteSnapshotErrorKind::SnapshotNotFound(_inner) => _inner.fmt(f),
            DeleteSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSnapshotError {
    fn code(&self) -> Option<&str> {
        DeleteSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSnapshotError {
    /// Creates a new `DeleteSnapshotError`.
    pub fn new(kind: DeleteSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSnapshotErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, DeleteSnapshotErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `DeleteSnapshotErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, DeleteSnapshotErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `DeleteSnapshotErrorKind::SnapshotNotFound`.
    pub fn is_snapshot_not_found(&self) -> bool {
        matches!(&self.kind, DeleteSnapshotErrorKind::SnapshotNotFound(_))
    }
}
impl std::error::Error for DeleteSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSnapshotErrorKind::BadRequest(_inner) => Some(_inner),
            DeleteSnapshotErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteSnapshotErrorKind::SnapshotNotFound(_inner) => Some(_inner),
            DeleteSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteStorageVirtualMachine` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteStorageVirtualMachineError {
    /// Kind of error that occurred.
    pub kind: DeleteStorageVirtualMachineErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteStorageVirtualMachine` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteStorageVirtualMachineErrorKind {
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>The error returned when a second request is received with the same client request token but different parameters settings. A client request token should always uniquely identify a single request.</p>
    IncompatibleParameterError(crate::error::IncompatibleParameterError),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>No Amazon FSx for NetApp ONTAP SVMs were found based upon the supplied parameters.</p>
    StorageVirtualMachineNotFound(crate::error::StorageVirtualMachineNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteStorageVirtualMachineError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteStorageVirtualMachineErrorKind::BadRequest(_inner) => _inner.fmt(f),
            DeleteStorageVirtualMachineErrorKind::IncompatibleParameterError(_inner) => {
                _inner.fmt(f)
            }
            DeleteStorageVirtualMachineErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteStorageVirtualMachineErrorKind::StorageVirtualMachineNotFound(_inner) => {
                _inner.fmt(f)
            }
            DeleteStorageVirtualMachineErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteStorageVirtualMachineError {
    fn code(&self) -> Option<&str> {
        DeleteStorageVirtualMachineError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteStorageVirtualMachineError {
    /// Creates a new `DeleteStorageVirtualMachineError`.
    pub fn new(kind: DeleteStorageVirtualMachineErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteStorageVirtualMachineError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteStorageVirtualMachineErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteStorageVirtualMachineError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteStorageVirtualMachineErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteStorageVirtualMachineErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStorageVirtualMachineErrorKind::BadRequest(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteStorageVirtualMachineErrorKind::IncompatibleParameterError`.
    pub fn is_incompatible_parameter_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStorageVirtualMachineErrorKind::IncompatibleParameterError(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteStorageVirtualMachineErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStorageVirtualMachineErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteStorageVirtualMachineErrorKind::StorageVirtualMachineNotFound`.
    pub fn is_storage_virtual_machine_not_found(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStorageVirtualMachineErrorKind::StorageVirtualMachineNotFound(_)
        )
    }
}
impl std::error::Error for DeleteStorageVirtualMachineError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteStorageVirtualMachineErrorKind::BadRequest(_inner) => Some(_inner),
            DeleteStorageVirtualMachineErrorKind::IncompatibleParameterError(_inner) => {
                Some(_inner)
            }
            DeleteStorageVirtualMachineErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteStorageVirtualMachineErrorKind::StorageVirtualMachineNotFound(_inner) => {
                Some(_inner)
            }
            DeleteStorageVirtualMachineErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteVolume` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteVolumeError {
    /// Kind of error that occurred.
    pub kind: DeleteVolumeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteVolume` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteVolumeErrorKind {
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>The error returned when a second request is received with the same client request token but different parameters settings. A client request token should always uniquely identify a single request.</p>
    IncompatibleParameterError(crate::error::IncompatibleParameterError),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>No Amazon FSx for NetApp ONTAP volumes were found based upon the supplied parameters.</p>
    VolumeNotFound(crate::error::VolumeNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteVolumeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteVolumeErrorKind::BadRequest(_inner) => _inner.fmt(f),
            DeleteVolumeErrorKind::IncompatibleParameterError(_inner) => _inner.fmt(f),
            DeleteVolumeErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteVolumeErrorKind::VolumeNotFound(_inner) => _inner.fmt(f),
            DeleteVolumeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteVolumeError {
    fn code(&self) -> Option<&str> {
        DeleteVolumeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteVolumeError {
    /// Creates a new `DeleteVolumeError`.
    pub fn new(kind: DeleteVolumeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteVolumeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteVolumeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteVolumeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteVolumeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteVolumeErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, DeleteVolumeErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `DeleteVolumeErrorKind::IncompatibleParameterError`.
    pub fn is_incompatible_parameter_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVolumeErrorKind::IncompatibleParameterError(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVolumeErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, DeleteVolumeErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `DeleteVolumeErrorKind::VolumeNotFound`.
    pub fn is_volume_not_found(&self) -> bool {
        matches!(&self.kind, DeleteVolumeErrorKind::VolumeNotFound(_))
    }
}
impl std::error::Error for DeleteVolumeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteVolumeErrorKind::BadRequest(_inner) => Some(_inner),
            DeleteVolumeErrorKind::IncompatibleParameterError(_inner) => Some(_inner),
            DeleteVolumeErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteVolumeErrorKind::VolumeNotFound(_inner) => Some(_inner),
            DeleteVolumeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeBackups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeBackupsError {
    /// Kind of error that occurred.
    pub kind: DescribeBackupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeBackups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeBackupsErrorKind {
    /// <p>No Amazon FSx backups were found based upon the supplied parameters.</p>
    BackupNotFound(crate::error::BackupNotFound),
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>No Amazon FSx file systems were found based upon supplied parameters.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>No Amazon FSx for NetApp ONTAP volumes were found based upon the supplied parameters.</p>
    VolumeNotFound(crate::error::VolumeNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeBackupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeBackupsErrorKind::BackupNotFound(_inner) => _inner.fmt(f),
            DescribeBackupsErrorKind::BadRequest(_inner) => _inner.fmt(f),
            DescribeBackupsErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            DescribeBackupsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeBackupsErrorKind::VolumeNotFound(_inner) => _inner.fmt(f),
            DescribeBackupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeBackupsError {
    fn code(&self) -> Option<&str> {
        DescribeBackupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeBackupsError {
    /// Creates a new `DescribeBackupsError`.
    pub fn new(kind: DescribeBackupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeBackupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeBackupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeBackupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeBackupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeBackupsErrorKind::BackupNotFound`.
    pub fn is_backup_not_found(&self) -> bool {
        matches!(&self.kind, DescribeBackupsErrorKind::BackupNotFound(_))
    }
    /// Returns `true` if the error kind is `DescribeBackupsErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, DescribeBackupsErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `DescribeBackupsErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(&self.kind, DescribeBackupsErrorKind::FileSystemNotFound(_))
    }
    /// Returns `true` if the error kind is `DescribeBackupsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, DescribeBackupsErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `DescribeBackupsErrorKind::VolumeNotFound`.
    pub fn is_volume_not_found(&self) -> bool {
        matches!(&self.kind, DescribeBackupsErrorKind::VolumeNotFound(_))
    }
}
impl std::error::Error for DescribeBackupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeBackupsErrorKind::BackupNotFound(_inner) => Some(_inner),
            DescribeBackupsErrorKind::BadRequest(_inner) => Some(_inner),
            DescribeBackupsErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            DescribeBackupsErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeBackupsErrorKind::VolumeNotFound(_inner) => Some(_inner),
            DescribeBackupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDataRepositoryAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDataRepositoryAssociationsError {
    /// Kind of error that occurred.
    pub kind: DescribeDataRepositoryAssociationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDataRepositoryAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDataRepositoryAssociationsErrorKind {
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>No data repository associations were found based upon the supplied parameters.</p>
    DataRepositoryAssociationNotFound(crate::error::DataRepositoryAssociationNotFound),
    /// <p>No Amazon FSx file systems were found based upon supplied parameters.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>You have filtered the response to a data repository type that is not supported.</p>
    InvalidDataRepositoryType(crate::error::InvalidDataRepositoryType),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDataRepositoryAssociationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDataRepositoryAssociationsErrorKind::BadRequest(_inner) => _inner.fmt(f),
            DescribeDataRepositoryAssociationsErrorKind::DataRepositoryAssociationNotFound(
                _inner,
            ) => _inner.fmt(f),
            DescribeDataRepositoryAssociationsErrorKind::FileSystemNotFound(_inner) => {
                _inner.fmt(f)
            }
            DescribeDataRepositoryAssociationsErrorKind::InternalServerError(_inner) => {
                _inner.fmt(f)
            }
            DescribeDataRepositoryAssociationsErrorKind::InvalidDataRepositoryType(_inner) => {
                _inner.fmt(f)
            }
            DescribeDataRepositoryAssociationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDataRepositoryAssociationsError {
    fn code(&self) -> Option<&str> {
        DescribeDataRepositoryAssociationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDataRepositoryAssociationsError {
    /// Creates a new `DescribeDataRepositoryAssociationsError`.
    pub fn new(
        kind: DescribeDataRepositoryAssociationsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDataRepositoryAssociationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDataRepositoryAssociationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDataRepositoryAssociationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDataRepositoryAssociationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDataRepositoryAssociationsErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataRepositoryAssociationsErrorKind::BadRequest(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDataRepositoryAssociationsErrorKind::DataRepositoryAssociationNotFound`.
    pub fn is_data_repository_association_not_found(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataRepositoryAssociationsErrorKind::DataRepositoryAssociationNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDataRepositoryAssociationsErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataRepositoryAssociationsErrorKind::FileSystemNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDataRepositoryAssociationsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataRepositoryAssociationsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDataRepositoryAssociationsErrorKind::InvalidDataRepositoryType`.
    pub fn is_invalid_data_repository_type(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataRepositoryAssociationsErrorKind::InvalidDataRepositoryType(_)
        )
    }
}
impl std::error::Error for DescribeDataRepositoryAssociationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDataRepositoryAssociationsErrorKind::BadRequest(_inner) => Some(_inner),
            DescribeDataRepositoryAssociationsErrorKind::DataRepositoryAssociationNotFound(
                _inner,
            ) => Some(_inner),
            DescribeDataRepositoryAssociationsErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            DescribeDataRepositoryAssociationsErrorKind::InternalServerError(_inner) => {
                Some(_inner)
            }
            DescribeDataRepositoryAssociationsErrorKind::InvalidDataRepositoryType(_inner) => {
                Some(_inner)
            }
            DescribeDataRepositoryAssociationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDataRepositoryTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDataRepositoryTasksError {
    /// Kind of error that occurred.
    pub kind: DescribeDataRepositoryTasksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDataRepositoryTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDataRepositoryTasksErrorKind {
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>The data repository task or tasks you specified could not be found.</p>
    DataRepositoryTaskNotFound(crate::error::DataRepositoryTaskNotFound),
    /// <p>No Amazon FSx file systems were found based upon supplied parameters.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDataRepositoryTasksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDataRepositoryTasksErrorKind::BadRequest(_inner) => _inner.fmt(f),
            DescribeDataRepositoryTasksErrorKind::DataRepositoryTaskNotFound(_inner) => {
                _inner.fmt(f)
            }
            DescribeDataRepositoryTasksErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            DescribeDataRepositoryTasksErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeDataRepositoryTasksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDataRepositoryTasksError {
    fn code(&self) -> Option<&str> {
        DescribeDataRepositoryTasksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDataRepositoryTasksError {
    /// Creates a new `DescribeDataRepositoryTasksError`.
    pub fn new(kind: DescribeDataRepositoryTasksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDataRepositoryTasksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDataRepositoryTasksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDataRepositoryTasksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDataRepositoryTasksErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDataRepositoryTasksErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataRepositoryTasksErrorKind::BadRequest(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDataRepositoryTasksErrorKind::DataRepositoryTaskNotFound`.
    pub fn is_data_repository_task_not_found(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataRepositoryTasksErrorKind::DataRepositoryTaskNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDataRepositoryTasksErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataRepositoryTasksErrorKind::FileSystemNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDataRepositoryTasksErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataRepositoryTasksErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DescribeDataRepositoryTasksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDataRepositoryTasksErrorKind::BadRequest(_inner) => Some(_inner),
            DescribeDataRepositoryTasksErrorKind::DataRepositoryTaskNotFound(_inner) => {
                Some(_inner)
            }
            DescribeDataRepositoryTasksErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            DescribeDataRepositoryTasksErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeDataRepositoryTasksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFileSystemAliases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFileSystemAliasesError {
    /// Kind of error that occurred.
    pub kind: DescribeFileSystemAliasesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFileSystemAliases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFileSystemAliasesErrorKind {
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>No Amazon FSx file systems were found based upon supplied parameters.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFileSystemAliasesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFileSystemAliasesErrorKind::BadRequest(_inner) => _inner.fmt(f),
            DescribeFileSystemAliasesErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            DescribeFileSystemAliasesErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeFileSystemAliasesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFileSystemAliasesError {
    fn code(&self) -> Option<&str> {
        DescribeFileSystemAliasesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFileSystemAliasesError {
    /// Creates a new `DescribeFileSystemAliasesError`.
    pub fn new(kind: DescribeFileSystemAliasesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFileSystemAliasesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFileSystemAliasesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFileSystemAliasesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFileSystemAliasesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeFileSystemAliasesErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFileSystemAliasesErrorKind::BadRequest(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFileSystemAliasesErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFileSystemAliasesErrorKind::FileSystemNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFileSystemAliasesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFileSystemAliasesErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DescribeFileSystemAliasesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFileSystemAliasesErrorKind::BadRequest(_inner) => Some(_inner),
            DescribeFileSystemAliasesErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            DescribeFileSystemAliasesErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeFileSystemAliasesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFileSystems` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFileSystemsError {
    /// Kind of error that occurred.
    pub kind: DescribeFileSystemsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFileSystems` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFileSystemsErrorKind {
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>No Amazon FSx file systems were found based upon supplied parameters.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFileSystemsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFileSystemsErrorKind::BadRequest(_inner) => _inner.fmt(f),
            DescribeFileSystemsErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            DescribeFileSystemsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeFileSystemsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFileSystemsError {
    fn code(&self) -> Option<&str> {
        DescribeFileSystemsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFileSystemsError {
    /// Creates a new `DescribeFileSystemsError`.
    pub fn new(kind: DescribeFileSystemsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFileSystemsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFileSystemsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFileSystemsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFileSystemsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeFileSystemsErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, DescribeFileSystemsErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `DescribeFileSystemsErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFileSystemsErrorKind::FileSystemNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFileSystemsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFileSystemsErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DescribeFileSystemsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFileSystemsErrorKind::BadRequest(_inner) => Some(_inner),
            DescribeFileSystemsErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            DescribeFileSystemsErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeFileSystemsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSnapshots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSnapshotsError {
    /// Kind of error that occurred.
    pub kind: DescribeSnapshotsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSnapshots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSnapshotsErrorKind {
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>No Amazon FSx snapshots were found based on the supplied parameters.</p>
    SnapshotNotFound(crate::error::SnapshotNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSnapshotsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSnapshotsErrorKind::BadRequest(_inner) => _inner.fmt(f),
            DescribeSnapshotsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeSnapshotsErrorKind::SnapshotNotFound(_inner) => _inner.fmt(f),
            DescribeSnapshotsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSnapshotsError {
    fn code(&self) -> Option<&str> {
        DescribeSnapshotsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSnapshotsError {
    /// Creates a new `DescribeSnapshotsError`.
    pub fn new(kind: DescribeSnapshotsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSnapshotsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSnapshotsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSnapshotsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSnapshotsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeSnapshotsErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, DescribeSnapshotsErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `DescribeSnapshotsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSnapshotsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSnapshotsErrorKind::SnapshotNotFound`.
    pub fn is_snapshot_not_found(&self) -> bool {
        matches!(&self.kind, DescribeSnapshotsErrorKind::SnapshotNotFound(_))
    }
}
impl std::error::Error for DescribeSnapshotsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSnapshotsErrorKind::BadRequest(_inner) => Some(_inner),
            DescribeSnapshotsErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeSnapshotsErrorKind::SnapshotNotFound(_inner) => Some(_inner),
            DescribeSnapshotsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeStorageVirtualMachines` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeStorageVirtualMachinesError {
    /// Kind of error that occurred.
    pub kind: DescribeStorageVirtualMachinesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeStorageVirtualMachines` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeStorageVirtualMachinesErrorKind {
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>No Amazon FSx for NetApp ONTAP SVMs were found based upon the supplied parameters.</p>
    StorageVirtualMachineNotFound(crate::error::StorageVirtualMachineNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeStorageVirtualMachinesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeStorageVirtualMachinesErrorKind::BadRequest(_inner) => _inner.fmt(f),
            DescribeStorageVirtualMachinesErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeStorageVirtualMachinesErrorKind::StorageVirtualMachineNotFound(_inner) => {
                _inner.fmt(f)
            }
            DescribeStorageVirtualMachinesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeStorageVirtualMachinesError {
    fn code(&self) -> Option<&str> {
        DescribeStorageVirtualMachinesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeStorageVirtualMachinesError {
    /// Creates a new `DescribeStorageVirtualMachinesError`.
    pub fn new(
        kind: DescribeStorageVirtualMachinesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeStorageVirtualMachinesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeStorageVirtualMachinesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeStorageVirtualMachinesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeStorageVirtualMachinesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeStorageVirtualMachinesErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStorageVirtualMachinesErrorKind::BadRequest(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeStorageVirtualMachinesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStorageVirtualMachinesErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeStorageVirtualMachinesErrorKind::StorageVirtualMachineNotFound`.
    pub fn is_storage_virtual_machine_not_found(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStorageVirtualMachinesErrorKind::StorageVirtualMachineNotFound(_)
        )
    }
}
impl std::error::Error for DescribeStorageVirtualMachinesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeStorageVirtualMachinesErrorKind::BadRequest(_inner) => Some(_inner),
            DescribeStorageVirtualMachinesErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeStorageVirtualMachinesErrorKind::StorageVirtualMachineNotFound(_inner) => {
                Some(_inner)
            }
            DescribeStorageVirtualMachinesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeVolumes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeVolumesError {
    /// Kind of error that occurred.
    pub kind: DescribeVolumesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeVolumes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeVolumesErrorKind {
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>No Amazon FSx for NetApp ONTAP volumes were found based upon the supplied parameters.</p>
    VolumeNotFound(crate::error::VolumeNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeVolumesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeVolumesErrorKind::BadRequest(_inner) => _inner.fmt(f),
            DescribeVolumesErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeVolumesErrorKind::VolumeNotFound(_inner) => _inner.fmt(f),
            DescribeVolumesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeVolumesError {
    fn code(&self) -> Option<&str> {
        DescribeVolumesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeVolumesError {
    /// Creates a new `DescribeVolumesError`.
    pub fn new(kind: DescribeVolumesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeVolumesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeVolumesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeVolumesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeVolumesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeVolumesErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, DescribeVolumesErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `DescribeVolumesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, DescribeVolumesErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `DescribeVolumesErrorKind::VolumeNotFound`.
    pub fn is_volume_not_found(&self) -> bool {
        matches!(&self.kind, DescribeVolumesErrorKind::VolumeNotFound(_))
    }
}
impl std::error::Error for DescribeVolumesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeVolumesErrorKind::BadRequest(_inner) => Some(_inner),
            DescribeVolumesErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeVolumesErrorKind::VolumeNotFound(_inner) => Some(_inner),
            DescribeVolumesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateFileSystemAliases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateFileSystemAliasesError {
    /// Kind of error that occurred.
    pub kind: DisassociateFileSystemAliasesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateFileSystemAliases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateFileSystemAliasesErrorKind {
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>No Amazon FSx file systems were found based upon supplied parameters.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateFileSystemAliasesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateFileSystemAliasesErrorKind::BadRequest(_inner) => _inner.fmt(f),
            DisassociateFileSystemAliasesErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            DisassociateFileSystemAliasesErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DisassociateFileSystemAliasesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateFileSystemAliasesError {
    fn code(&self) -> Option<&str> {
        DisassociateFileSystemAliasesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateFileSystemAliasesError {
    /// Creates a new `DisassociateFileSystemAliasesError`.
    pub fn new(
        kind: DisassociateFileSystemAliasesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateFileSystemAliasesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateFileSystemAliasesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateFileSystemAliasesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateFileSystemAliasesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateFileSystemAliasesErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateFileSystemAliasesErrorKind::BadRequest(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateFileSystemAliasesErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateFileSystemAliasesErrorKind::FileSystemNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateFileSystemAliasesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateFileSystemAliasesErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DisassociateFileSystemAliasesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateFileSystemAliasesErrorKind::BadRequest(_inner) => Some(_inner),
            DisassociateFileSystemAliasesErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            DisassociateFileSystemAliasesErrorKind::InternalServerError(_inner) => Some(_inner),
            DisassociateFileSystemAliasesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The resource specified for the tagging operation is not a resource type owned by Amazon FSx. Use the API of the relevant service to perform the operation. </p>
    NotServiceResourceError(crate::error::NotServiceResourceError),
    /// <p>The resource specified does not support tagging. </p>
    ResourceDoesNotSupportTagging(crate::error::ResourceDoesNotSupportTagging),
    /// <p>The resource specified by the Amazon Resource Name (ARN) can't be found.</p>
    ResourceNotFound(crate::error::ResourceNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::BadRequest(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::NotServiceResourceError(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceDoesNotSupportTagging(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFound(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, ListTagsForResourceErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::NotServiceResourceError`.
    pub fn is_not_service_resource_error(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::NotServiceResourceError(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceDoesNotSupportTagging`.
    pub fn is_resource_does_not_support_tagging(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceDoesNotSupportTagging(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFound`.
    pub fn is_resource_not_found(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFound(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::BadRequest(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalServerError(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::NotServiceResourceError(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceDoesNotSupportTagging(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFound(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ReleaseFileSystemNfsV3Locks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ReleaseFileSystemNfsV3LocksError {
    /// Kind of error that occurred.
    pub kind: ReleaseFileSystemNfsV3LocksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ReleaseFileSystemNfsV3Locks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ReleaseFileSystemNfsV3LocksErrorKind {
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>No Amazon FSx file systems were found based upon supplied parameters.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>The error returned when a second request is received with the same client request token but different parameters settings. A client request token should always uniquely identify a single request.</p>
    IncompatibleParameterError(crate::error::IncompatibleParameterError),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An error indicating that a particular service limit was exceeded. You can increase some service limits by contacting Amazon Web Services Support.</p>
    ServiceLimitExceeded(crate::error::ServiceLimitExceeded),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ReleaseFileSystemNfsV3LocksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ReleaseFileSystemNfsV3LocksErrorKind::BadRequest(_inner) => _inner.fmt(f),
            ReleaseFileSystemNfsV3LocksErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            ReleaseFileSystemNfsV3LocksErrorKind::IncompatibleParameterError(_inner) => {
                _inner.fmt(f)
            }
            ReleaseFileSystemNfsV3LocksErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ReleaseFileSystemNfsV3LocksErrorKind::ServiceLimitExceeded(_inner) => _inner.fmt(f),
            ReleaseFileSystemNfsV3LocksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ReleaseFileSystemNfsV3LocksError {
    fn code(&self) -> Option<&str> {
        ReleaseFileSystemNfsV3LocksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ReleaseFileSystemNfsV3LocksError {
    /// Creates a new `ReleaseFileSystemNfsV3LocksError`.
    pub fn new(kind: ReleaseFileSystemNfsV3LocksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ReleaseFileSystemNfsV3LocksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ReleaseFileSystemNfsV3LocksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ReleaseFileSystemNfsV3LocksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ReleaseFileSystemNfsV3LocksErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ReleaseFileSystemNfsV3LocksErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(
            &self.kind,
            ReleaseFileSystemNfsV3LocksErrorKind::BadRequest(_)
        )
    }
    /// Returns `true` if the error kind is `ReleaseFileSystemNfsV3LocksErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(
            &self.kind,
            ReleaseFileSystemNfsV3LocksErrorKind::FileSystemNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `ReleaseFileSystemNfsV3LocksErrorKind::IncompatibleParameterError`.
    pub fn is_incompatible_parameter_error(&self) -> bool {
        matches!(
            &self.kind,
            ReleaseFileSystemNfsV3LocksErrorKind::IncompatibleParameterError(_)
        )
    }
    /// Returns `true` if the error kind is `ReleaseFileSystemNfsV3LocksErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ReleaseFileSystemNfsV3LocksErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `ReleaseFileSystemNfsV3LocksErrorKind::ServiceLimitExceeded`.
    pub fn is_service_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            ReleaseFileSystemNfsV3LocksErrorKind::ServiceLimitExceeded(_)
        )
    }
}
impl std::error::Error for ReleaseFileSystemNfsV3LocksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ReleaseFileSystemNfsV3LocksErrorKind::BadRequest(_inner) => Some(_inner),
            ReleaseFileSystemNfsV3LocksErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            ReleaseFileSystemNfsV3LocksErrorKind::IncompatibleParameterError(_inner) => {
                Some(_inner)
            }
            ReleaseFileSystemNfsV3LocksErrorKind::InternalServerError(_inner) => Some(_inner),
            ReleaseFileSystemNfsV3LocksErrorKind::ServiceLimitExceeded(_inner) => Some(_inner),
            ReleaseFileSystemNfsV3LocksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RestoreVolumeFromSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RestoreVolumeFromSnapshotError {
    /// Kind of error that occurred.
    pub kind: RestoreVolumeFromSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RestoreVolumeFromSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RestoreVolumeFromSnapshotErrorKind {
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>No Amazon FSx for NetApp ONTAP volumes were found based upon the supplied parameters.</p>
    VolumeNotFound(crate::error::VolumeNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RestoreVolumeFromSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RestoreVolumeFromSnapshotErrorKind::BadRequest(_inner) => _inner.fmt(f),
            RestoreVolumeFromSnapshotErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            RestoreVolumeFromSnapshotErrorKind::VolumeNotFound(_inner) => _inner.fmt(f),
            RestoreVolumeFromSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RestoreVolumeFromSnapshotError {
    fn code(&self) -> Option<&str> {
        RestoreVolumeFromSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RestoreVolumeFromSnapshotError {
    /// Creates a new `RestoreVolumeFromSnapshotError`.
    pub fn new(kind: RestoreVolumeFromSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RestoreVolumeFromSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RestoreVolumeFromSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RestoreVolumeFromSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RestoreVolumeFromSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RestoreVolumeFromSnapshotErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(
            &self.kind,
            RestoreVolumeFromSnapshotErrorKind::BadRequest(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreVolumeFromSnapshotErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            RestoreVolumeFromSnapshotErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreVolumeFromSnapshotErrorKind::VolumeNotFound`.
    pub fn is_volume_not_found(&self) -> bool {
        matches!(
            &self.kind,
            RestoreVolumeFromSnapshotErrorKind::VolumeNotFound(_)
        )
    }
}
impl std::error::Error for RestoreVolumeFromSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RestoreVolumeFromSnapshotErrorKind::BadRequest(_inner) => Some(_inner),
            RestoreVolumeFromSnapshotErrorKind::InternalServerError(_inner) => Some(_inner),
            RestoreVolumeFromSnapshotErrorKind::VolumeNotFound(_inner) => Some(_inner),
            RestoreVolumeFromSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The resource specified for the tagging operation is not a resource type owned by Amazon FSx. Use the API of the relevant service to perform the operation. </p>
    NotServiceResourceError(crate::error::NotServiceResourceError),
    /// <p>The resource specified does not support tagging. </p>
    ResourceDoesNotSupportTagging(crate::error::ResourceDoesNotSupportTagging),
    /// <p>The resource specified by the Amazon Resource Name (ARN) can't be found.</p>
    ResourceNotFound(crate::error::ResourceNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::BadRequest(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            TagResourceErrorKind::NotServiceResourceError(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceDoesNotSupportTagging(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFound(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::NotServiceResourceError`.
    pub fn is_not_service_resource_error(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::NotServiceResourceError(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceDoesNotSupportTagging`.
    pub fn is_resource_does_not_support_tagging(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceDoesNotSupportTagging(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFound`.
    pub fn is_resource_not_found(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ResourceNotFound(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::BadRequest(_inner) => Some(_inner),
            TagResourceErrorKind::InternalServerError(_inner) => Some(_inner),
            TagResourceErrorKind::NotServiceResourceError(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceDoesNotSupportTagging(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFound(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The resource specified for the tagging operation is not a resource type owned by Amazon FSx. Use the API of the relevant service to perform the operation. </p>
    NotServiceResourceError(crate::error::NotServiceResourceError),
    /// <p>The resource specified does not support tagging. </p>
    ResourceDoesNotSupportTagging(crate::error::ResourceDoesNotSupportTagging),
    /// <p>The resource specified by the Amazon Resource Name (ARN) can't be found.</p>
    ResourceNotFound(crate::error::ResourceNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::BadRequest(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::NotServiceResourceError(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceDoesNotSupportTagging(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFound(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::NotServiceResourceError`.
    pub fn is_not_service_resource_error(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::NotServiceResourceError(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceDoesNotSupportTagging`.
    pub fn is_resource_does_not_support_tagging(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceDoesNotSupportTagging(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFound`.
    pub fn is_resource_not_found(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ResourceNotFound(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::BadRequest(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalServerError(_inner) => Some(_inner),
            UntagResourceErrorKind::NotServiceResourceError(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceDoesNotSupportTagging(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFound(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDataRepositoryAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDataRepositoryAssociationError {
    /// Kind of error that occurred.
    pub kind: UpdateDataRepositoryAssociationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDataRepositoryAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDataRepositoryAssociationErrorKind {
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>No data repository associations were found based upon the supplied parameters.</p>
    DataRepositoryAssociationNotFound(crate::error::DataRepositoryAssociationNotFound),
    /// <p>The error returned when a second request is received with the same client request token but different parameters settings. A client request token should always uniquely identify a single request.</p>
    IncompatibleParameterError(crate::error::IncompatibleParameterError),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An error indicating that a particular service limit was exceeded. You can increase some service limits by contacting Amazon Web Services Support.</p>
    ServiceLimitExceeded(crate::error::ServiceLimitExceeded),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDataRepositoryAssociationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDataRepositoryAssociationErrorKind::BadRequest(_inner) => _inner.fmt(f),
            UpdateDataRepositoryAssociationErrorKind::DataRepositoryAssociationNotFound(_inner) => {
                _inner.fmt(f)
            }
            UpdateDataRepositoryAssociationErrorKind::IncompatibleParameterError(_inner) => {
                _inner.fmt(f)
            }
            UpdateDataRepositoryAssociationErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateDataRepositoryAssociationErrorKind::ServiceLimitExceeded(_inner) => _inner.fmt(f),
            UpdateDataRepositoryAssociationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDataRepositoryAssociationError {
    fn code(&self) -> Option<&str> {
        UpdateDataRepositoryAssociationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDataRepositoryAssociationError {
    /// Creates a new `UpdateDataRepositoryAssociationError`.
    pub fn new(
        kind: UpdateDataRepositoryAssociationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDataRepositoryAssociationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDataRepositoryAssociationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDataRepositoryAssociationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDataRepositoryAssociationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDataRepositoryAssociationErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataRepositoryAssociationErrorKind::BadRequest(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataRepositoryAssociationErrorKind::DataRepositoryAssociationNotFound`.
    pub fn is_data_repository_association_not_found(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataRepositoryAssociationErrorKind::DataRepositoryAssociationNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataRepositoryAssociationErrorKind::IncompatibleParameterError`.
    pub fn is_incompatible_parameter_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataRepositoryAssociationErrorKind::IncompatibleParameterError(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataRepositoryAssociationErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataRepositoryAssociationErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataRepositoryAssociationErrorKind::ServiceLimitExceeded`.
    pub fn is_service_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataRepositoryAssociationErrorKind::ServiceLimitExceeded(_)
        )
    }
}
impl std::error::Error for UpdateDataRepositoryAssociationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDataRepositoryAssociationErrorKind::BadRequest(_inner) => Some(_inner),
            UpdateDataRepositoryAssociationErrorKind::DataRepositoryAssociationNotFound(_inner) => {
                Some(_inner)
            }
            UpdateDataRepositoryAssociationErrorKind::IncompatibleParameterError(_inner) => {
                Some(_inner)
            }
            UpdateDataRepositoryAssociationErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateDataRepositoryAssociationErrorKind::ServiceLimitExceeded(_inner) => Some(_inner),
            UpdateDataRepositoryAssociationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateFileSystem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFileSystemError {
    /// Kind of error that occurred.
    pub kind: UpdateFileSystemErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFileSystem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFileSystemErrorKind {
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>No Amazon FSx file systems were found based upon supplied parameters.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>The error returned when a second request is received with the same client request token but different parameters settings. A client request token should always uniquely identify a single request.</p>
    IncompatibleParameterError(crate::error::IncompatibleParameterError),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>A file system configuration is required for this operation.</p>
    MissingFileSystemConfiguration(crate::error::MissingFileSystemConfiguration),
    /// <p>An error indicating that a particular service limit was exceeded. You can increase some service limits by contacting Amazon Web Services Support.</p>
    ServiceLimitExceeded(crate::error::ServiceLimitExceeded),
    /// <p>The requested operation is not supported for this resource or API.</p>
    UnsupportedOperation(crate::error::UnsupportedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFileSystemError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFileSystemErrorKind::BadRequest(_inner) => _inner.fmt(f),
            UpdateFileSystemErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            UpdateFileSystemErrorKind::IncompatibleParameterError(_inner) => _inner.fmt(f),
            UpdateFileSystemErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateFileSystemErrorKind::MissingFileSystemConfiguration(_inner) => _inner.fmt(f),
            UpdateFileSystemErrorKind::ServiceLimitExceeded(_inner) => _inner.fmt(f),
            UpdateFileSystemErrorKind::UnsupportedOperation(_inner) => _inner.fmt(f),
            UpdateFileSystemErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFileSystemError {
    fn code(&self) -> Option<&str> {
        UpdateFileSystemError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFileSystemError {
    /// Creates a new `UpdateFileSystemError`.
    pub fn new(kind: UpdateFileSystemErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFileSystemError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFileSystemErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFileSystemError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFileSystemErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateFileSystemErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, UpdateFileSystemErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `UpdateFileSystemErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(&self.kind, UpdateFileSystemErrorKind::FileSystemNotFound(_))
    }
    /// Returns `true` if the error kind is `UpdateFileSystemErrorKind::IncompatibleParameterError`.
    pub fn is_incompatible_parameter_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFileSystemErrorKind::IncompatibleParameterError(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFileSystemErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFileSystemErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFileSystemErrorKind::MissingFileSystemConfiguration`.
    pub fn is_missing_file_system_configuration(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFileSystemErrorKind::MissingFileSystemConfiguration(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFileSystemErrorKind::ServiceLimitExceeded`.
    pub fn is_service_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFileSystemErrorKind::ServiceLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFileSystemErrorKind::UnsupportedOperation`.
    pub fn is_unsupported_operation(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFileSystemErrorKind::UnsupportedOperation(_)
        )
    }
}
impl std::error::Error for UpdateFileSystemError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFileSystemErrorKind::BadRequest(_inner) => Some(_inner),
            UpdateFileSystemErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            UpdateFileSystemErrorKind::IncompatibleParameterError(_inner) => Some(_inner),
            UpdateFileSystemErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateFileSystemErrorKind::MissingFileSystemConfiguration(_inner) => Some(_inner),
            UpdateFileSystemErrorKind::ServiceLimitExceeded(_inner) => Some(_inner),
            UpdateFileSystemErrorKind::UnsupportedOperation(_inner) => Some(_inner),
            UpdateFileSystemErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateSnapshotError {
    /// Kind of error that occurred.
    pub kind: UpdateSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateSnapshotErrorKind {
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>No Amazon FSx snapshots were found based on the supplied parameters.</p>
    SnapshotNotFound(crate::error::SnapshotNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateSnapshotErrorKind::BadRequest(_inner) => _inner.fmt(f),
            UpdateSnapshotErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateSnapshotErrorKind::SnapshotNotFound(_inner) => _inner.fmt(f),
            UpdateSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateSnapshotError {
    fn code(&self) -> Option<&str> {
        UpdateSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateSnapshotError {
    /// Creates a new `UpdateSnapshotError`.
    pub fn new(kind: UpdateSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateSnapshotErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, UpdateSnapshotErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `UpdateSnapshotErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, UpdateSnapshotErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `UpdateSnapshotErrorKind::SnapshotNotFound`.
    pub fn is_snapshot_not_found(&self) -> bool {
        matches!(&self.kind, UpdateSnapshotErrorKind::SnapshotNotFound(_))
    }
}
impl std::error::Error for UpdateSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateSnapshotErrorKind::BadRequest(_inner) => Some(_inner),
            UpdateSnapshotErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateSnapshotErrorKind::SnapshotNotFound(_inner) => Some(_inner),
            UpdateSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateStorageVirtualMachine` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateStorageVirtualMachineError {
    /// Kind of error that occurred.
    pub kind: UpdateStorageVirtualMachineErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateStorageVirtualMachine` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateStorageVirtualMachineErrorKind {
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>The error returned when a second request is received with the same client request token but different parameters settings. A client request token should always uniquely identify a single request.</p>
    IncompatibleParameterError(crate::error::IncompatibleParameterError),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>No Amazon FSx for NetApp ONTAP SVMs were found based upon the supplied parameters.</p>
    StorageVirtualMachineNotFound(crate::error::StorageVirtualMachineNotFound),
    /// <p>The requested operation is not supported for this resource or API.</p>
    UnsupportedOperation(crate::error::UnsupportedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateStorageVirtualMachineError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateStorageVirtualMachineErrorKind::BadRequest(_inner) => _inner.fmt(f),
            UpdateStorageVirtualMachineErrorKind::IncompatibleParameterError(_inner) => {
                _inner.fmt(f)
            }
            UpdateStorageVirtualMachineErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateStorageVirtualMachineErrorKind::StorageVirtualMachineNotFound(_inner) => {
                _inner.fmt(f)
            }
            UpdateStorageVirtualMachineErrorKind::UnsupportedOperation(_inner) => _inner.fmt(f),
            UpdateStorageVirtualMachineErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateStorageVirtualMachineError {
    fn code(&self) -> Option<&str> {
        UpdateStorageVirtualMachineError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateStorageVirtualMachineError {
    /// Creates a new `UpdateStorageVirtualMachineError`.
    pub fn new(kind: UpdateStorageVirtualMachineErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateStorageVirtualMachineError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateStorageVirtualMachineErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateStorageVirtualMachineError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateStorageVirtualMachineErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateStorageVirtualMachineErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStorageVirtualMachineErrorKind::BadRequest(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStorageVirtualMachineErrorKind::IncompatibleParameterError`.
    pub fn is_incompatible_parameter_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStorageVirtualMachineErrorKind::IncompatibleParameterError(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStorageVirtualMachineErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStorageVirtualMachineErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStorageVirtualMachineErrorKind::StorageVirtualMachineNotFound`.
    pub fn is_storage_virtual_machine_not_found(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStorageVirtualMachineErrorKind::StorageVirtualMachineNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStorageVirtualMachineErrorKind::UnsupportedOperation`.
    pub fn is_unsupported_operation(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStorageVirtualMachineErrorKind::UnsupportedOperation(_)
        )
    }
}
impl std::error::Error for UpdateStorageVirtualMachineError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateStorageVirtualMachineErrorKind::BadRequest(_inner) => Some(_inner),
            UpdateStorageVirtualMachineErrorKind::IncompatibleParameterError(_inner) => {
                Some(_inner)
            }
            UpdateStorageVirtualMachineErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateStorageVirtualMachineErrorKind::StorageVirtualMachineNotFound(_inner) => {
                Some(_inner)
            }
            UpdateStorageVirtualMachineErrorKind::UnsupportedOperation(_inner) => Some(_inner),
            UpdateStorageVirtualMachineErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateVolume` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateVolumeError {
    /// Kind of error that occurred.
    pub kind: UpdateVolumeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateVolume` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateVolumeErrorKind {
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>The error returned when a second request is received with the same client request token but different parameters settings. A client request token should always uniquely identify a single request.</p>
    IncompatibleParameterError(crate::error::IncompatibleParameterError),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>A volume configuration is required for this operation.</p>
    MissingVolumeConfiguration(crate::error::MissingVolumeConfiguration),
    /// <p>No Amazon FSx for NetApp ONTAP volumes were found based upon the supplied parameters.</p>
    VolumeNotFound(crate::error::VolumeNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateVolumeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateVolumeErrorKind::BadRequest(_inner) => _inner.fmt(f),
            UpdateVolumeErrorKind::IncompatibleParameterError(_inner) => _inner.fmt(f),
            UpdateVolumeErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateVolumeErrorKind::MissingVolumeConfiguration(_inner) => _inner.fmt(f),
            UpdateVolumeErrorKind::VolumeNotFound(_inner) => _inner.fmt(f),
            UpdateVolumeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateVolumeError {
    fn code(&self) -> Option<&str> {
        UpdateVolumeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateVolumeError {
    /// Creates a new `UpdateVolumeError`.
    pub fn new(kind: UpdateVolumeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateVolumeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateVolumeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateVolumeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateVolumeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateVolumeErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, UpdateVolumeErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `UpdateVolumeErrorKind::IncompatibleParameterError`.
    pub fn is_incompatible_parameter_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVolumeErrorKind::IncompatibleParameterError(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVolumeErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, UpdateVolumeErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `UpdateVolumeErrorKind::MissingVolumeConfiguration`.
    pub fn is_missing_volume_configuration(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVolumeErrorKind::MissingVolumeConfiguration(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVolumeErrorKind::VolumeNotFound`.
    pub fn is_volume_not_found(&self) -> bool {
        matches!(&self.kind, UpdateVolumeErrorKind::VolumeNotFound(_))
    }
}
impl std::error::Error for UpdateVolumeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateVolumeErrorKind::BadRequest(_inner) => Some(_inner),
            UpdateVolumeErrorKind::IncompatibleParameterError(_inner) => Some(_inner),
            UpdateVolumeErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateVolumeErrorKind::MissingVolumeConfiguration(_inner) => Some(_inner),
            UpdateVolumeErrorKind::VolumeNotFound(_inner) => Some(_inner),
            UpdateVolumeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>No Amazon FSx for NetApp ONTAP volumes were found based upon the supplied parameters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VolumeNotFound {
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for VolumeNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VolumeNotFound");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl VolumeNotFound {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for VolumeNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "VolumeNotFound")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for VolumeNotFound {}
/// See [`VolumeNotFound`](crate::error::VolumeNotFound)
pub mod volume_not_found {
    /// A builder for [`VolumeNotFound`](crate::error::VolumeNotFound)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`VolumeNotFound`](crate::error::VolumeNotFound)
        pub fn build(self) -> crate::error::VolumeNotFound {
            crate::error::VolumeNotFound {
                message: self.message,
            }
        }
    }
}
impl VolumeNotFound {
    /// Creates a new builder-style object to manufacture [`VolumeNotFound`](crate::error::VolumeNotFound)
    pub fn builder() -> crate::error::volume_not_found::Builder {
        crate::error::volume_not_found::Builder::default()
    }
}

/// <p>A volume configuration is required for this operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MissingVolumeConfiguration {
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MissingVolumeConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MissingVolumeConfiguration");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MissingVolumeConfiguration {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MissingVolumeConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MissingVolumeConfiguration")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for MissingVolumeConfiguration {}
/// See [`MissingVolumeConfiguration`](crate::error::MissingVolumeConfiguration)
pub mod missing_volume_configuration {
    /// A builder for [`MissingVolumeConfiguration`](crate::error::MissingVolumeConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MissingVolumeConfiguration`](crate::error::MissingVolumeConfiguration)
        pub fn build(self) -> crate::error::MissingVolumeConfiguration {
            crate::error::MissingVolumeConfiguration {
                message: self.message,
            }
        }
    }
}
impl MissingVolumeConfiguration {
    /// Creates a new builder-style object to manufacture [`MissingVolumeConfiguration`](crate::error::MissingVolumeConfiguration)
    pub fn builder() -> crate::error::missing_volume_configuration::Builder {
        crate::error::missing_volume_configuration::Builder::default()
    }
}

/// <p>A generic error indicating a server-side failure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerError {
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerError");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerError {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerError")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerError {}
/// See [`InternalServerError`](crate::error::InternalServerError)
pub mod internal_server_error {
    /// A builder for [`InternalServerError`](crate::error::InternalServerError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerError`](crate::error::InternalServerError)
        pub fn build(self) -> crate::error::InternalServerError {
            crate::error::InternalServerError {
                message: self.message,
            }
        }
    }
}
impl InternalServerError {
    /// Creates a new builder-style object to manufacture [`InternalServerError`](crate::error::InternalServerError)
    pub fn builder() -> crate::error::internal_server_error::Builder {
        crate::error::internal_server_error::Builder::default()
    }
}

/// <p>The error returned when a second request is received with the same client request token but different parameters settings. A client request token should always uniquely identify a single request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IncompatibleParameterError {
    /// <p>A parameter that is incompatible with the earlier request.</p>
    pub parameter: std::option::Option<std::string::String>,
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl IncompatibleParameterError {
    /// <p>A parameter that is incompatible with the earlier request.</p>
    pub fn parameter(&self) -> std::option::Option<&str> {
        self.parameter.as_deref()
    }
}
impl std::fmt::Debug for IncompatibleParameterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IncompatibleParameterError");
        formatter.field("parameter", &self.parameter);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IncompatibleParameterError {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IncompatibleParameterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IncompatibleParameterError")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for IncompatibleParameterError {}
/// See [`IncompatibleParameterError`](crate::error::IncompatibleParameterError)
pub mod incompatible_parameter_error {
    /// A builder for [`IncompatibleParameterError`](crate::error::IncompatibleParameterError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A parameter that is incompatible with the earlier request.</p>
        pub fn parameter(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter = Some(input.into());
            self
        }
        /// <p>A parameter that is incompatible with the earlier request.</p>
        pub fn set_parameter(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.parameter = input;
            self
        }
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IncompatibleParameterError`](crate::error::IncompatibleParameterError)
        pub fn build(self) -> crate::error::IncompatibleParameterError {
            crate::error::IncompatibleParameterError {
                parameter: self.parameter,
                message: self.message,
            }
        }
    }
}
impl IncompatibleParameterError {
    /// Creates a new builder-style object to manufacture [`IncompatibleParameterError`](crate::error::IncompatibleParameterError)
    pub fn builder() -> crate::error::incompatible_parameter_error::Builder {
        crate::error::incompatible_parameter_error::Builder::default()
    }
}

/// <p>A generic error indicating a failure with a client request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadRequest {
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BadRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadRequest");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BadRequest {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadRequest")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadRequest {}
/// See [`BadRequest`](crate::error::BadRequest)
pub mod bad_request {
    /// A builder for [`BadRequest`](crate::error::BadRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BadRequest`](crate::error::BadRequest)
        pub fn build(self) -> crate::error::BadRequest {
            crate::error::BadRequest {
                message: self.message,
            }
        }
    }
}
impl BadRequest {
    /// Creates a new builder-style object to manufacture [`BadRequest`](crate::error::BadRequest)
    pub fn builder() -> crate::error::bad_request::Builder {
        crate::error::bad_request::Builder::default()
    }
}

/// <p>The requested operation is not supported for this resource or API.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedOperation {
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedOperation");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedOperation {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedOperation")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedOperation {}
/// See [`UnsupportedOperation`](crate::error::UnsupportedOperation)
pub mod unsupported_operation {
    /// A builder for [`UnsupportedOperation`](crate::error::UnsupportedOperation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedOperation`](crate::error::UnsupportedOperation)
        pub fn build(self) -> crate::error::UnsupportedOperation {
            crate::error::UnsupportedOperation {
                message: self.message,
            }
        }
    }
}
impl UnsupportedOperation {
    /// Creates a new builder-style object to manufacture [`UnsupportedOperation`](crate::error::UnsupportedOperation)
    pub fn builder() -> crate::error::unsupported_operation::Builder {
        crate::error::unsupported_operation::Builder::default()
    }
}

/// <p>No Amazon FSx for NetApp ONTAP SVMs were found based upon the supplied parameters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StorageVirtualMachineNotFound {
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StorageVirtualMachineNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StorageVirtualMachineNotFound");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl StorageVirtualMachineNotFound {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for StorageVirtualMachineNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "StorageVirtualMachineNotFound")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for StorageVirtualMachineNotFound {}
/// See [`StorageVirtualMachineNotFound`](crate::error::StorageVirtualMachineNotFound)
pub mod storage_virtual_machine_not_found {
    /// A builder for [`StorageVirtualMachineNotFound`](crate::error::StorageVirtualMachineNotFound)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`StorageVirtualMachineNotFound`](crate::error::StorageVirtualMachineNotFound)
        pub fn build(self) -> crate::error::StorageVirtualMachineNotFound {
            crate::error::StorageVirtualMachineNotFound {
                message: self.message,
            }
        }
    }
}
impl StorageVirtualMachineNotFound {
    /// Creates a new builder-style object to manufacture [`StorageVirtualMachineNotFound`](crate::error::StorageVirtualMachineNotFound)
    pub fn builder() -> crate::error::storage_virtual_machine_not_found::Builder {
        crate::error::storage_virtual_machine_not_found::Builder::default()
    }
}

/// <p>No Amazon FSx snapshots were found based on the supplied parameters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnapshotNotFound {
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SnapshotNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnapshotNotFound");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SnapshotNotFound {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SnapshotNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SnapshotNotFound")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for SnapshotNotFound {}
/// See [`SnapshotNotFound`](crate::error::SnapshotNotFound)
pub mod snapshot_not_found {
    /// A builder for [`SnapshotNotFound`](crate::error::SnapshotNotFound)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SnapshotNotFound`](crate::error::SnapshotNotFound)
        pub fn build(self) -> crate::error::SnapshotNotFound {
            crate::error::SnapshotNotFound {
                message: self.message,
            }
        }
    }
}
impl SnapshotNotFound {
    /// Creates a new builder-style object to manufacture [`SnapshotNotFound`](crate::error::SnapshotNotFound)
    pub fn builder() -> crate::error::snapshot_not_found::Builder {
        crate::error::snapshot_not_found::Builder::default()
    }
}

/// <p>An error indicating that a particular service limit was exceeded. You can increase some service limits by contacting Amazon Web Services Support.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceLimitExceeded {
    /// <p>Enumeration of the service limit that was exceeded. </p>
    pub limit: std::option::Option<crate::model::ServiceLimit>,
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ServiceLimitExceeded {
    /// <p>Enumeration of the service limit that was exceeded. </p>
    pub fn limit(&self) -> std::option::Option<&crate::model::ServiceLimit> {
        self.limit.as_ref()
    }
}
impl std::fmt::Debug for ServiceLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceLimitExceeded");
        formatter.field("limit", &self.limit);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceLimitExceeded {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceLimitExceeded")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceLimitExceeded {}
/// See [`ServiceLimitExceeded`](crate::error::ServiceLimitExceeded)
pub mod service_limit_exceeded {
    /// A builder for [`ServiceLimitExceeded`](crate::error::ServiceLimitExceeded)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) limit: std::option::Option<crate::model::ServiceLimit>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Enumeration of the service limit that was exceeded. </p>
        pub fn limit(mut self, input: crate::model::ServiceLimit) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>Enumeration of the service limit that was exceeded. </p>
        pub fn set_limit(mut self, input: std::option::Option<crate::model::ServiceLimit>) -> Self {
            self.limit = input;
            self
        }
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceLimitExceeded`](crate::error::ServiceLimitExceeded)
        pub fn build(self) -> crate::error::ServiceLimitExceeded {
            crate::error::ServiceLimitExceeded {
                limit: self.limit,
                message: self.message,
            }
        }
    }
}
impl ServiceLimitExceeded {
    /// Creates a new builder-style object to manufacture [`ServiceLimitExceeded`](crate::error::ServiceLimitExceeded)
    pub fn builder() -> crate::error::service_limit_exceeded::Builder {
        crate::error::service_limit_exceeded::Builder::default()
    }
}

/// <p>A file system configuration is required for this operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MissingFileSystemConfiguration {
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MissingFileSystemConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MissingFileSystemConfiguration");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MissingFileSystemConfiguration {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MissingFileSystemConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MissingFileSystemConfiguration")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for MissingFileSystemConfiguration {}
/// See [`MissingFileSystemConfiguration`](crate::error::MissingFileSystemConfiguration)
pub mod missing_file_system_configuration {
    /// A builder for [`MissingFileSystemConfiguration`](crate::error::MissingFileSystemConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MissingFileSystemConfiguration`](crate::error::MissingFileSystemConfiguration)
        pub fn build(self) -> crate::error::MissingFileSystemConfiguration {
            crate::error::MissingFileSystemConfiguration {
                message: self.message,
            }
        }
    }
}
impl MissingFileSystemConfiguration {
    /// Creates a new builder-style object to manufacture [`MissingFileSystemConfiguration`](crate::error::MissingFileSystemConfiguration)
    pub fn builder() -> crate::error::missing_file_system_configuration::Builder {
        crate::error::missing_file_system_configuration::Builder::default()
    }
}

/// <p>No Amazon FSx file systems were found based upon supplied parameters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FileSystemNotFound {
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FileSystemNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FileSystemNotFound");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl FileSystemNotFound {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for FileSystemNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "FileSystemNotFound")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for FileSystemNotFound {}
/// See [`FileSystemNotFound`](crate::error::FileSystemNotFound)
pub mod file_system_not_found {
    /// A builder for [`FileSystemNotFound`](crate::error::FileSystemNotFound)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`FileSystemNotFound`](crate::error::FileSystemNotFound)
        pub fn build(self) -> crate::error::FileSystemNotFound {
            crate::error::FileSystemNotFound {
                message: self.message,
            }
        }
    }
}
impl FileSystemNotFound {
    /// Creates a new builder-style object to manufacture [`FileSystemNotFound`](crate::error::FileSystemNotFound)
    pub fn builder() -> crate::error::file_system_not_found::Builder {
        crate::error::file_system_not_found::Builder::default()
    }
}

/// <p>No data repository associations were found based upon the supplied parameters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataRepositoryAssociationNotFound {
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DataRepositoryAssociationNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataRepositoryAssociationNotFound");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DataRepositoryAssociationNotFound {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DataRepositoryAssociationNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DataRepositoryAssociationNotFound")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for DataRepositoryAssociationNotFound {}
/// See [`DataRepositoryAssociationNotFound`](crate::error::DataRepositoryAssociationNotFound)
pub mod data_repository_association_not_found {
    /// A builder for [`DataRepositoryAssociationNotFound`](crate::error::DataRepositoryAssociationNotFound)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DataRepositoryAssociationNotFound`](crate::error::DataRepositoryAssociationNotFound)
        pub fn build(self) -> crate::error::DataRepositoryAssociationNotFound {
            crate::error::DataRepositoryAssociationNotFound {
                message: self.message,
            }
        }
    }
}
impl DataRepositoryAssociationNotFound {
    /// Creates a new builder-style object to manufacture [`DataRepositoryAssociationNotFound`](crate::error::DataRepositoryAssociationNotFound)
    pub fn builder() -> crate::error::data_repository_association_not_found::Builder {
        crate::error::data_repository_association_not_found::Builder::default()
    }
}

/// <p>The resource specified by the Amazon Resource Name (ARN) can't be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFound {
    /// <p>The resource ARN of the resource that can't be found.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ResourceNotFound {
    /// <p>The resource ARN of the resource that can't be found.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ResourceNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFound");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFound {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFound")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFound {}
/// See [`ResourceNotFound`](crate::error::ResourceNotFound)
pub mod resource_not_found {
    /// A builder for [`ResourceNotFound`](crate::error::ResourceNotFound)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource ARN of the resource that can't be found.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The resource ARN of the resource that can't be found.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFound`](crate::error::ResourceNotFound)
        pub fn build(self) -> crate::error::ResourceNotFound {
            crate::error::ResourceNotFound {
                resource_arn: self.resource_arn,
                message: self.message,
            }
        }
    }
}
impl ResourceNotFound {
    /// Creates a new builder-style object to manufacture [`ResourceNotFound`](crate::error::ResourceNotFound)
    pub fn builder() -> crate::error::resource_not_found::Builder {
        crate::error::resource_not_found::Builder::default()
    }
}

/// <p>The resource specified does not support tagging. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceDoesNotSupportTagging {
    /// <p>The Amazon Resource Name (ARN) of the resource that doesn't support tagging.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ResourceDoesNotSupportTagging {
    /// <p>The Amazon Resource Name (ARN) of the resource that doesn't support tagging.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ResourceDoesNotSupportTagging {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceDoesNotSupportTagging");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceDoesNotSupportTagging {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceDoesNotSupportTagging {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceDoesNotSupportTagging")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceDoesNotSupportTagging {}
/// See [`ResourceDoesNotSupportTagging`](crate::error::ResourceDoesNotSupportTagging)
pub mod resource_does_not_support_tagging {
    /// A builder for [`ResourceDoesNotSupportTagging`](crate::error::ResourceDoesNotSupportTagging)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource that doesn't support tagging.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that doesn't support tagging.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceDoesNotSupportTagging`](crate::error::ResourceDoesNotSupportTagging)
        pub fn build(self) -> crate::error::ResourceDoesNotSupportTagging {
            crate::error::ResourceDoesNotSupportTagging {
                resource_arn: self.resource_arn,
                message: self.message,
            }
        }
    }
}
impl ResourceDoesNotSupportTagging {
    /// Creates a new builder-style object to manufacture [`ResourceDoesNotSupportTagging`](crate::error::ResourceDoesNotSupportTagging)
    pub fn builder() -> crate::error::resource_does_not_support_tagging::Builder {
        crate::error::resource_does_not_support_tagging::Builder::default()
    }
}

/// <p>The resource specified for the tagging operation is not a resource type owned by Amazon FSx. Use the API of the relevant service to perform the operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotServiceResourceError {
    /// <p>The Amazon Resource Name (ARN) of the non-Amazon FSx resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl NotServiceResourceError {
    /// <p>The Amazon Resource Name (ARN) of the non-Amazon FSx resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for NotServiceResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotServiceResourceError");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotServiceResourceError {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotServiceResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotServiceResourceError")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotServiceResourceError {}
/// See [`NotServiceResourceError`](crate::error::NotServiceResourceError)
pub mod not_service_resource_error {
    /// A builder for [`NotServiceResourceError`](crate::error::NotServiceResourceError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the non-Amazon FSx resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the non-Amazon FSx resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotServiceResourceError`](crate::error::NotServiceResourceError)
        pub fn build(self) -> crate::error::NotServiceResourceError {
            crate::error::NotServiceResourceError {
                resource_arn: self.resource_arn,
                message: self.message,
            }
        }
    }
}
impl NotServiceResourceError {
    /// Creates a new builder-style object to manufacture [`NotServiceResourceError`](crate::error::NotServiceResourceError)
    pub fn builder() -> crate::error::not_service_resource_error::Builder {
        crate::error::not_service_resource_error::Builder::default()
    }
}

/// <p>The data repository task or tasks you specified could not be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataRepositoryTaskNotFound {
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DataRepositoryTaskNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataRepositoryTaskNotFound");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DataRepositoryTaskNotFound {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DataRepositoryTaskNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DataRepositoryTaskNotFound")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for DataRepositoryTaskNotFound {}
/// See [`DataRepositoryTaskNotFound`](crate::error::DataRepositoryTaskNotFound)
pub mod data_repository_task_not_found {
    /// A builder for [`DataRepositoryTaskNotFound`](crate::error::DataRepositoryTaskNotFound)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DataRepositoryTaskNotFound`](crate::error::DataRepositoryTaskNotFound)
        pub fn build(self) -> crate::error::DataRepositoryTaskNotFound {
            crate::error::DataRepositoryTaskNotFound {
                message: self.message,
            }
        }
    }
}
impl DataRepositoryTaskNotFound {
    /// Creates a new builder-style object to manufacture [`DataRepositoryTaskNotFound`](crate::error::DataRepositoryTaskNotFound)
    pub fn builder() -> crate::error::data_repository_task_not_found::Builder {
        crate::error::data_repository_task_not_found::Builder::default()
    }
}

/// <p>You have filtered the response to a data repository type that is not supported.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDataRepositoryType {
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDataRepositoryType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDataRepositoryType");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDataRepositoryType {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDataRepositoryType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidDataRepositoryType")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDataRepositoryType {}
/// See [`InvalidDataRepositoryType`](crate::error::InvalidDataRepositoryType)
pub mod invalid_data_repository_type {
    /// A builder for [`InvalidDataRepositoryType`](crate::error::InvalidDataRepositoryType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDataRepositoryType`](crate::error::InvalidDataRepositoryType)
        pub fn build(self) -> crate::error::InvalidDataRepositoryType {
            crate::error::InvalidDataRepositoryType {
                message: self.message,
            }
        }
    }
}
impl InvalidDataRepositoryType {
    /// Creates a new builder-style object to manufacture [`InvalidDataRepositoryType`](crate::error::InvalidDataRepositoryType)
    pub fn builder() -> crate::error::invalid_data_repository_type::Builder {
        crate::error::invalid_data_repository_type::Builder::default()
    }
}

/// <p>No Amazon FSx backups were found based upon the supplied parameters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackupNotFound {
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BackupNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackupNotFound");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BackupNotFound {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BackupNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BackupNotFound")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for BackupNotFound {}
/// See [`BackupNotFound`](crate::error::BackupNotFound)
pub mod backup_not_found {
    /// A builder for [`BackupNotFound`](crate::error::BackupNotFound)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BackupNotFound`](crate::error::BackupNotFound)
        pub fn build(self) -> crate::error::BackupNotFound {
            crate::error::BackupNotFound {
                message: self.message,
            }
        }
    }
}
impl BackupNotFound {
    /// Creates a new builder-style object to manufacture [`BackupNotFound`](crate::error::BackupNotFound)
    pub fn builder() -> crate::error::backup_not_found::Builder {
        crate::error::backup_not_found::Builder::default()
    }
}

/// <p>You can't delete a backup while it's being used to restore a file system.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackupRestoring {
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The ID of a file system being restored from the backup.</p>
    pub file_system_id: std::option::Option<std::string::String>,
}
impl BackupRestoring {
    /// <p>The ID of a file system being restored from the backup.</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
}
impl std::fmt::Debug for BackupRestoring {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackupRestoring");
        formatter.field("message", &self.message);
        formatter.field("file_system_id", &self.file_system_id);
        formatter.finish()
    }
}
impl BackupRestoring {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BackupRestoring {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BackupRestoring")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for BackupRestoring {}
/// See [`BackupRestoring`](crate::error::BackupRestoring)
pub mod backup_restoring {
    /// A builder for [`BackupRestoring`](crate::error::BackupRestoring)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) file_system_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The ID of a file system being restored from the backup.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>The ID of a file system being restored from the backup.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// Consumes the builder and constructs a [`BackupRestoring`](crate::error::BackupRestoring)
        pub fn build(self) -> crate::error::BackupRestoring {
            crate::error::BackupRestoring {
                message: self.message,
                file_system_id: self.file_system_id,
            }
        }
    }
}
impl BackupRestoring {
    /// Creates a new builder-style object to manufacture [`BackupRestoring`](crate::error::BackupRestoring)
    pub fn builder() -> crate::error::backup_restoring::Builder {
        crate::error::backup_restoring::Builder::default()
    }
}

/// <p>Another backup is already under way. Wait for completion before initiating additional backups of this file system.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackupInProgress {
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BackupInProgress {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackupInProgress");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BackupInProgress {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BackupInProgress {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BackupInProgress")?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for BackupInProgress {}
/// See [`BackupInProgress`](crate::error::BackupInProgress)
pub mod backup_in_progress {
    /// A builder for [`BackupInProgress`](crate::error::BackupInProgress)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BackupInProgress`](crate::error::BackupInProgress)
        pub fn build(self) -> crate::error::BackupInProgress {
            crate::error::BackupInProgress {
                message: self.message,
            }
        }
    }
}
impl BackupInProgress {
    /// Creates a new builder-style object to manufacture [`BackupInProgress`](crate::error::BackupInProgress)
    pub fn builder() -> crate::error::backup_in_progress::Builder {
        crate::error::backup_in_progress::Builder::default()
    }
}

/// <p>You can't delete a backup while it's being copied.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackupBeingCopied {
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The ID of the source backup. Specifies the backup that you are copying.</p>
    pub backup_id: std::option::Option<std::string::String>,
}
impl BackupBeingCopied {
    /// <p>The ID of the source backup. Specifies the backup that you are copying.</p>
    pub fn backup_id(&self) -> std::option::Option<&str> {
        self.backup_id.as_deref()
    }
}
impl std::fmt::Debug for BackupBeingCopied {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackupBeingCopied");
        formatter.field("message", &self.message);
        formatter.field("backup_id", &self.backup_id);
        formatter.finish()
    }
}
impl BackupBeingCopied {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BackupBeingCopied {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BackupBeingCopied")?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for BackupBeingCopied {}
/// See [`BackupBeingCopied`](crate::error::BackupBeingCopied)
pub mod backup_being_copied {
    /// A builder for [`BackupBeingCopied`](crate::error::BackupBeingCopied)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) backup_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The ID of the source backup. Specifies the backup that you are copying.</p>
        pub fn backup_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_id = Some(input.into());
            self
        }
        /// <p>The ID of the source backup. Specifies the backup that you are copying.</p>
        pub fn set_backup_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.backup_id = input;
            self
        }
        /// Consumes the builder and constructs a [`BackupBeingCopied`](crate::error::BackupBeingCopied)
        pub fn build(self) -> crate::error::BackupBeingCopied {
            crate::error::BackupBeingCopied {
                message: self.message,
                backup_id: self.backup_id,
            }
        }
    }
}
impl BackupBeingCopied {
    /// Creates a new builder-style object to manufacture [`BackupBeingCopied`](crate::error::BackupBeingCopied)
    pub fn builder() -> crate::error::backup_being_copied::Builder {
        crate::error::backup_being_copied::Builder::default()
    }
}

/// <p>An Active Directory error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActiveDirectoryError {
    /// <p>The directory ID of the directory that an error pertains to.</p>
    pub active_directory_id: std::option::Option<std::string::String>,
    /// <p>The type of Active Directory error.</p>
    pub r#type: std::option::Option<crate::model::ActiveDirectoryErrorType>,
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ActiveDirectoryError {
    /// <p>The directory ID of the directory that an error pertains to.</p>
    pub fn active_directory_id(&self) -> std::option::Option<&str> {
        self.active_directory_id.as_deref()
    }
    /// <p>The type of Active Directory error.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ActiveDirectoryErrorType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for ActiveDirectoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActiveDirectoryError");
        formatter.field("active_directory_id", &self.active_directory_id);
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ActiveDirectoryError {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ActiveDirectoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ActiveDirectoryError")?;
        if let Some(inner_22) = &self.message {
            write!(f, ": {}", inner_22)?;
        }
        Ok(())
    }
}
impl std::error::Error for ActiveDirectoryError {}
/// See [`ActiveDirectoryError`](crate::error::ActiveDirectoryError)
pub mod active_directory_error {
    /// A builder for [`ActiveDirectoryError`](crate::error::ActiveDirectoryError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) active_directory_id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ActiveDirectoryErrorType>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The directory ID of the directory that an error pertains to.</p>
        pub fn active_directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.active_directory_id = Some(input.into());
            self
        }
        /// <p>The directory ID of the directory that an error pertains to.</p>
        pub fn set_active_directory_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.active_directory_id = input;
            self
        }
        /// <p>The type of Active Directory error.</p>
        pub fn r#type(mut self, input: crate::model::ActiveDirectoryErrorType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of Active Directory error.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ActiveDirectoryErrorType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ActiveDirectoryError`](crate::error::ActiveDirectoryError)
        pub fn build(self) -> crate::error::ActiveDirectoryError {
            crate::error::ActiveDirectoryError {
                active_directory_id: self.active_directory_id,
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl ActiveDirectoryError {
    /// Creates a new builder-style object to manufacture [`ActiveDirectoryError`](crate::error::ActiveDirectoryError)
    pub fn builder() -> crate::error::active_directory_error::Builder {
        crate::error::active_directory_error::Builder::default()
    }
}

/// <p>An invalid value for <code>PerUnitStorageThroughput</code> was provided. Please create your file system again, using a valid value.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidPerUnitStorageThroughput {
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidPerUnitStorageThroughput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidPerUnitStorageThroughput");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidPerUnitStorageThroughput {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidPerUnitStorageThroughput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidPerUnitStorageThroughput")?;
        if let Some(inner_23) = &self.message {
            write!(f, ": {}", inner_23)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidPerUnitStorageThroughput {}
/// See [`InvalidPerUnitStorageThroughput`](crate::error::InvalidPerUnitStorageThroughput)
pub mod invalid_per_unit_storage_throughput {
    /// A builder for [`InvalidPerUnitStorageThroughput`](crate::error::InvalidPerUnitStorageThroughput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidPerUnitStorageThroughput`](crate::error::InvalidPerUnitStorageThroughput)
        pub fn build(self) -> crate::error::InvalidPerUnitStorageThroughput {
            crate::error::InvalidPerUnitStorageThroughput {
                message: self.message,
            }
        }
    }
}
impl InvalidPerUnitStorageThroughput {
    /// Creates a new builder-style object to manufacture [`InvalidPerUnitStorageThroughput`](crate::error::InvalidPerUnitStorageThroughput)
    pub fn builder() -> crate::error::invalid_per_unit_storage_throughput::Builder {
        crate::error::invalid_per_unit_storage_throughput::Builder::default()
    }
}

/// <p>One or more network settings specified in the request are invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidNetworkSettings {
    /// <p>Error message explaining what's wrong with network settings.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The subnet ID that is either invalid or not part of the VPC specified.</p>
    pub invalid_subnet_id: std::option::Option<std::string::String>,
    /// <p>The security group ID is either invalid or not part of the VPC specified.</p>
    pub invalid_security_group_id: std::option::Option<std::string::String>,
    /// <p>The route table ID is either invalid or not part of the VPC specified.</p>
    pub invalid_route_table_id: std::option::Option<std::string::String>,
}
impl InvalidNetworkSettings {
    /// <p>The subnet ID that is either invalid or not part of the VPC specified.</p>
    pub fn invalid_subnet_id(&self) -> std::option::Option<&str> {
        self.invalid_subnet_id.as_deref()
    }
    /// <p>The security group ID is either invalid or not part of the VPC specified.</p>
    pub fn invalid_security_group_id(&self) -> std::option::Option<&str> {
        self.invalid_security_group_id.as_deref()
    }
    /// <p>The route table ID is either invalid or not part of the VPC specified.</p>
    pub fn invalid_route_table_id(&self) -> std::option::Option<&str> {
        self.invalid_route_table_id.as_deref()
    }
}
impl std::fmt::Debug for InvalidNetworkSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidNetworkSettings");
        formatter.field("message", &self.message);
        formatter.field("invalid_subnet_id", &self.invalid_subnet_id);
        formatter.field("invalid_security_group_id", &self.invalid_security_group_id);
        formatter.field("invalid_route_table_id", &self.invalid_route_table_id);
        formatter.finish()
    }
}
impl InvalidNetworkSettings {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidNetworkSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidNetworkSettings")?;
        if let Some(inner_24) = &self.message {
            write!(f, ": {}", inner_24)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidNetworkSettings {}
/// See [`InvalidNetworkSettings`](crate::error::InvalidNetworkSettings)
pub mod invalid_network_settings {
    /// A builder for [`InvalidNetworkSettings`](crate::error::InvalidNetworkSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) invalid_subnet_id: std::option::Option<std::string::String>,
        pub(crate) invalid_security_group_id: std::option::Option<std::string::String>,
        pub(crate) invalid_route_table_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error message explaining what's wrong with network settings.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error message explaining what's wrong with network settings.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The subnet ID that is either invalid or not part of the VPC specified.</p>
        pub fn invalid_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.invalid_subnet_id = Some(input.into());
            self
        }
        /// <p>The subnet ID that is either invalid or not part of the VPC specified.</p>
        pub fn set_invalid_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.invalid_subnet_id = input;
            self
        }
        /// <p>The security group ID is either invalid or not part of the VPC specified.</p>
        pub fn invalid_security_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.invalid_security_group_id = Some(input.into());
            self
        }
        /// <p>The security group ID is either invalid or not part of the VPC specified.</p>
        pub fn set_invalid_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.invalid_security_group_id = input;
            self
        }
        /// <p>The route table ID is either invalid or not part of the VPC specified.</p>
        pub fn invalid_route_table_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.invalid_route_table_id = Some(input.into());
            self
        }
        /// <p>The route table ID is either invalid or not part of the VPC specified.</p>
        pub fn set_invalid_route_table_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.invalid_route_table_id = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidNetworkSettings`](crate::error::InvalidNetworkSettings)
        pub fn build(self) -> crate::error::InvalidNetworkSettings {
            crate::error::InvalidNetworkSettings {
                message: self.message,
                invalid_subnet_id: self.invalid_subnet_id,
                invalid_security_group_id: self.invalid_security_group_id,
                invalid_route_table_id: self.invalid_route_table_id,
            }
        }
    }
}
impl InvalidNetworkSettings {
    /// Creates a new builder-style object to manufacture [`InvalidNetworkSettings`](crate::error::InvalidNetworkSettings)
    pub fn builder() -> crate::error::invalid_network_settings::Builder {
        crate::error::invalid_network_settings::Builder::default()
    }
}

/// <p>The path provided for data repository import isn't valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidImportPath {
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidImportPath {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidImportPath");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidImportPath {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidImportPath {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidImportPath")?;
        if let Some(inner_25) = &self.message {
            write!(f, ": {}", inner_25)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidImportPath {}
/// See [`InvalidImportPath`](crate::error::InvalidImportPath)
pub mod invalid_import_path {
    /// A builder for [`InvalidImportPath`](crate::error::InvalidImportPath)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidImportPath`](crate::error::InvalidImportPath)
        pub fn build(self) -> crate::error::InvalidImportPath {
            crate::error::InvalidImportPath {
                message: self.message,
            }
        }
    }
}
impl InvalidImportPath {
    /// Creates a new builder-style object to manufacture [`InvalidImportPath`](crate::error::InvalidImportPath)
    pub fn builder() -> crate::error::invalid_import_path::Builder {
        crate::error::invalid_import_path::Builder::default()
    }
}

/// <p>The path provided for data repository export isn't valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidExportPath {
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidExportPath {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidExportPath");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidExportPath {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidExportPath {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidExportPath")?;
        if let Some(inner_26) = &self.message {
            write!(f, ": {}", inner_26)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidExportPath {}
/// See [`InvalidExportPath`](crate::error::InvalidExportPath)
pub mod invalid_export_path {
    /// A builder for [`InvalidExportPath`](crate::error::InvalidExportPath)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidExportPath`](crate::error::InvalidExportPath)
        pub fn build(self) -> crate::error::InvalidExportPath {
            crate::error::InvalidExportPath {
                message: self.message,
            }
        }
    }
}
impl InvalidExportPath {
    /// Creates a new builder-style object to manufacture [`InvalidExportPath`](crate::error::InvalidExportPath)
    pub fn builder() -> crate::error::invalid_export_path::Builder {
        crate::error::invalid_export_path::Builder::default()
    }
}

/// <p>An existing data repository task is currently executing on the file system. Wait until the existing task has completed, then create the new task.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataRepositoryTaskExecuting {
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DataRepositoryTaskExecuting {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataRepositoryTaskExecuting");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DataRepositoryTaskExecuting {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DataRepositoryTaskExecuting {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DataRepositoryTaskExecuting")?;
        if let Some(inner_27) = &self.message {
            write!(f, ": {}", inner_27)?;
        }
        Ok(())
    }
}
impl std::error::Error for DataRepositoryTaskExecuting {}
/// See [`DataRepositoryTaskExecuting`](crate::error::DataRepositoryTaskExecuting)
pub mod data_repository_task_executing {
    /// A builder for [`DataRepositoryTaskExecuting`](crate::error::DataRepositoryTaskExecuting)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DataRepositoryTaskExecuting`](crate::error::DataRepositoryTaskExecuting)
        pub fn build(self) -> crate::error::DataRepositoryTaskExecuting {
            crate::error::DataRepositoryTaskExecuting {
                message: self.message,
            }
        }
    }
}
impl DataRepositoryTaskExecuting {
    /// Creates a new builder-style object to manufacture [`DataRepositoryTaskExecuting`](crate::error::DataRepositoryTaskExecuting)
    pub fn builder() -> crate::error::data_repository_task_executing::Builder {
        crate::error::data_repository_task_executing::Builder::default()
    }
}

/// <p>The request was rejected because the lifecycle status of the source backup isn't <code>AVAILABLE</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceBackupUnavailable {
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The ID of the source backup. Specifies the backup that you are copying.</p>
    pub backup_id: std::option::Option<std::string::String>,
}
impl SourceBackupUnavailable {
    /// <p>The ID of the source backup. Specifies the backup that you are copying.</p>
    pub fn backup_id(&self) -> std::option::Option<&str> {
        self.backup_id.as_deref()
    }
}
impl std::fmt::Debug for SourceBackupUnavailable {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceBackupUnavailable");
        formatter.field("message", &self.message);
        formatter.field("backup_id", &self.backup_id);
        formatter.finish()
    }
}
impl SourceBackupUnavailable {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SourceBackupUnavailable {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SourceBackupUnavailable")?;
        if let Some(inner_28) = &self.message {
            write!(f, ": {}", inner_28)?;
        }
        Ok(())
    }
}
impl std::error::Error for SourceBackupUnavailable {}
/// See [`SourceBackupUnavailable`](crate::error::SourceBackupUnavailable)
pub mod source_backup_unavailable {
    /// A builder for [`SourceBackupUnavailable`](crate::error::SourceBackupUnavailable)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) backup_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The ID of the source backup. Specifies the backup that you are copying.</p>
        pub fn backup_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_id = Some(input.into());
            self
        }
        /// <p>The ID of the source backup. Specifies the backup that you are copying.</p>
        pub fn set_backup_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.backup_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceBackupUnavailable`](crate::error::SourceBackupUnavailable)
        pub fn build(self) -> crate::error::SourceBackupUnavailable {
            crate::error::SourceBackupUnavailable {
                message: self.message,
                backup_id: self.backup_id,
            }
        }
    }
}
impl SourceBackupUnavailable {
    /// Creates a new builder-style object to manufacture [`SourceBackupUnavailable`](crate::error::SourceBackupUnavailable)
    pub fn builder() -> crate::error::source_backup_unavailable::Builder {
        crate::error::source_backup_unavailable::Builder::default()
    }
}

/// <p>The Key Management Service (KMS) key of the source backup is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidSourceKmsKey {
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidSourceKmsKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidSourceKmsKey");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidSourceKmsKey {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidSourceKmsKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidSourceKmsKey")?;
        if let Some(inner_29) = &self.message {
            write!(f, ": {}", inner_29)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidSourceKmsKey {}
/// See [`InvalidSourceKmsKey`](crate::error::InvalidSourceKmsKey)
pub mod invalid_source_kms_key {
    /// A builder for [`InvalidSourceKmsKey`](crate::error::InvalidSourceKmsKey)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidSourceKmsKey`](crate::error::InvalidSourceKmsKey)
        pub fn build(self) -> crate::error::InvalidSourceKmsKey {
            crate::error::InvalidSourceKmsKey {
                message: self.message,
            }
        }
    }
}
impl InvalidSourceKmsKey {
    /// Creates a new builder-style object to manufacture [`InvalidSourceKmsKey`](crate::error::InvalidSourceKmsKey)
    pub fn builder() -> crate::error::invalid_source_kms_key::Builder {
        crate::error::invalid_source_kms_key::Builder::default()
    }
}

/// <p>The Region provided for <code>SourceRegion</code> is not valid or is in a different Amazon Web Services partition.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRegion {
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRegion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRegion");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRegion {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRegion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRegion")?;
        if let Some(inner_30) = &self.message {
            write!(f, ": {}", inner_30)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRegion {}
/// See [`InvalidRegion`](crate::error::InvalidRegion)
pub mod invalid_region {
    /// A builder for [`InvalidRegion`](crate::error::InvalidRegion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRegion`](crate::error::InvalidRegion)
        pub fn build(self) -> crate::error::InvalidRegion {
            crate::error::InvalidRegion {
                message: self.message,
            }
        }
    }
}
impl InvalidRegion {
    /// Creates a new builder-style object to manufacture [`InvalidRegion`](crate::error::InvalidRegion)
    pub fn builder() -> crate::error::invalid_region::Builder {
        crate::error::invalid_region::Builder::default()
    }
}

/// <p>The Key Management Service (KMS) key of the destination backup is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDestinationKmsKey {
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDestinationKmsKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDestinationKmsKey");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDestinationKmsKey {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDestinationKmsKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidDestinationKmsKey")?;
        if let Some(inner_31) = &self.message {
            write!(f, ": {}", inner_31)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDestinationKmsKey {}
/// See [`InvalidDestinationKmsKey`](crate::error::InvalidDestinationKmsKey)
pub mod invalid_destination_kms_key {
    /// A builder for [`InvalidDestinationKmsKey`](crate::error::InvalidDestinationKmsKey)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDestinationKmsKey`](crate::error::InvalidDestinationKmsKey)
        pub fn build(self) -> crate::error::InvalidDestinationKmsKey {
            crate::error::InvalidDestinationKmsKey {
                message: self.message,
            }
        }
    }
}
impl InvalidDestinationKmsKey {
    /// Creates a new builder-style object to manufacture [`InvalidDestinationKmsKey`](crate::error::InvalidDestinationKmsKey)
    pub fn builder() -> crate::error::invalid_destination_kms_key::Builder {
        crate::error::invalid_destination_kms_key::Builder::default()
    }
}

/// <p>Amazon FSx doesn't support Multi-AZ Windows File Server copy backup in the destination Region, so the copied backup can't be restored.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IncompatibleRegionForMultiAz {
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IncompatibleRegionForMultiAz {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IncompatibleRegionForMultiAz");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IncompatibleRegionForMultiAz {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IncompatibleRegionForMultiAz {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "IncompatibleRegionForMultiAz [IncompatibleRegionForMultiAZ]"
        )?;
        if let Some(inner_32) = &self.message {
            write!(f, ": {}", inner_32)?;
        }
        Ok(())
    }
}
impl std::error::Error for IncompatibleRegionForMultiAz {}
/// See [`IncompatibleRegionForMultiAz`](crate::error::IncompatibleRegionForMultiAz)
pub mod incompatible_region_for_multi_az {
    /// A builder for [`IncompatibleRegionForMultiAz`](crate::error::IncompatibleRegionForMultiAz)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IncompatibleRegionForMultiAz`](crate::error::IncompatibleRegionForMultiAz)
        pub fn build(self) -> crate::error::IncompatibleRegionForMultiAz {
            crate::error::IncompatibleRegionForMultiAz {
                message: self.message,
            }
        }
    }
}
impl IncompatibleRegionForMultiAz {
    /// Creates a new builder-style object to manufacture [`IncompatibleRegionForMultiAz`](crate::error::IncompatibleRegionForMultiAz)
    pub fn builder() -> crate::error::incompatible_region_for_multi_az::Builder {
        crate::error::incompatible_region_for_multi_az::Builder::default()
    }
}

/// <p>The data repository task could not be canceled because the task has already ended.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataRepositoryTaskEnded {
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DataRepositoryTaskEnded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataRepositoryTaskEnded");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DataRepositoryTaskEnded {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DataRepositoryTaskEnded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DataRepositoryTaskEnded")?;
        if let Some(inner_33) = &self.message {
            write!(f, ": {}", inner_33)?;
        }
        Ok(())
    }
}
impl std::error::Error for DataRepositoryTaskEnded {}
/// See [`DataRepositoryTaskEnded`](crate::error::DataRepositoryTaskEnded)
pub mod data_repository_task_ended {
    /// A builder for [`DataRepositoryTaskEnded`](crate::error::DataRepositoryTaskEnded)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DataRepositoryTaskEnded`](crate::error::DataRepositoryTaskEnded)
        pub fn build(self) -> crate::error::DataRepositoryTaskEnded {
            crate::error::DataRepositoryTaskEnded {
                message: self.message,
            }
        }
    }
}
impl DataRepositoryTaskEnded {
    /// Creates a new builder-style object to manufacture [`DataRepositoryTaskEnded`](crate::error::DataRepositoryTaskEnded)
    pub fn builder() -> crate::error::data_repository_task_ended::Builder {
        crate::error::data_repository_task_ended::Builder::default()
    }
}
