// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateVolumeOutput {
    /// <p>A description of the volume just updated. Returned after a successful <code>UpdateVolume</code> API operation.</p>
    pub volume: std::option::Option<crate::model::Volume>,
}
impl UpdateVolumeOutput {
    /// <p>A description of the volume just updated. Returned after a successful <code>UpdateVolume</code> API operation.</p>
    pub fn volume(&self) -> std::option::Option<&crate::model::Volume> {
        self.volume.as_ref()
    }
}
impl std::fmt::Debug for UpdateVolumeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateVolumeOutput");
        formatter.field("volume", &self.volume);
        formatter.finish()
    }
}
/// See [`UpdateVolumeOutput`](crate::output::UpdateVolumeOutput)
pub mod update_volume_output {
    /// A builder for [`UpdateVolumeOutput`](crate::output::UpdateVolumeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume: std::option::Option<crate::model::Volume>,
    }
    impl Builder {
        /// <p>A description of the volume just updated. Returned after a successful <code>UpdateVolume</code> API operation.</p>
        pub fn volume(mut self, input: crate::model::Volume) -> Self {
            self.volume = Some(input);
            self
        }
        /// <p>A description of the volume just updated. Returned after a successful <code>UpdateVolume</code> API operation.</p>
        pub fn set_volume(mut self, input: std::option::Option<crate::model::Volume>) -> Self {
            self.volume = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateVolumeOutput`](crate::output::UpdateVolumeOutput)
        pub fn build(self) -> crate::output::UpdateVolumeOutput {
            crate::output::UpdateVolumeOutput {
                volume: self.volume,
            }
        }
    }
}
impl UpdateVolumeOutput {
    /// Creates a new builder-style object to manufacture [`UpdateVolumeOutput`](crate::output::UpdateVolumeOutput)
    pub fn builder() -> crate::output::update_volume_output::Builder {
        crate::output::update_volume_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateStorageVirtualMachineOutput {
    /// <p>Describes the Amazon FSx for NetApp ONTAP storage virtual machine (SVM) configuraton.</p>
    pub storage_virtual_machine: std::option::Option<crate::model::StorageVirtualMachine>,
}
impl UpdateStorageVirtualMachineOutput {
    /// <p>Describes the Amazon FSx for NetApp ONTAP storage virtual machine (SVM) configuraton.</p>
    pub fn storage_virtual_machine(
        &self,
    ) -> std::option::Option<&crate::model::StorageVirtualMachine> {
        self.storage_virtual_machine.as_ref()
    }
}
impl std::fmt::Debug for UpdateStorageVirtualMachineOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateStorageVirtualMachineOutput");
        formatter.field("storage_virtual_machine", &self.storage_virtual_machine);
        formatter.finish()
    }
}
/// See [`UpdateStorageVirtualMachineOutput`](crate::output::UpdateStorageVirtualMachineOutput)
pub mod update_storage_virtual_machine_output {
    /// A builder for [`UpdateStorageVirtualMachineOutput`](crate::output::UpdateStorageVirtualMachineOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) storage_virtual_machine:
            std::option::Option<crate::model::StorageVirtualMachine>,
    }
    impl Builder {
        /// <p>Describes the Amazon FSx for NetApp ONTAP storage virtual machine (SVM) configuraton.</p>
        pub fn storage_virtual_machine(
            mut self,
            input: crate::model::StorageVirtualMachine,
        ) -> Self {
            self.storage_virtual_machine = Some(input);
            self
        }
        /// <p>Describes the Amazon FSx for NetApp ONTAP storage virtual machine (SVM) configuraton.</p>
        pub fn set_storage_virtual_machine(
            mut self,
            input: std::option::Option<crate::model::StorageVirtualMachine>,
        ) -> Self {
            self.storage_virtual_machine = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateStorageVirtualMachineOutput`](crate::output::UpdateStorageVirtualMachineOutput)
        pub fn build(self) -> crate::output::UpdateStorageVirtualMachineOutput {
            crate::output::UpdateStorageVirtualMachineOutput {
                storage_virtual_machine: self.storage_virtual_machine,
            }
        }
    }
}
impl UpdateStorageVirtualMachineOutput {
    /// Creates a new builder-style object to manufacture [`UpdateStorageVirtualMachineOutput`](crate::output::UpdateStorageVirtualMachineOutput)
    pub fn builder() -> crate::output::update_storage_virtual_machine_output::Builder {
        crate::output::update_storage_virtual_machine_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSnapshotOutput {
    /// <p>Returned after a successful <code>UpdateSnapshot</code> operation, describing the snapshot that you updated.</p>
    pub snapshot: std::option::Option<crate::model::Snapshot>,
}
impl UpdateSnapshotOutput {
    /// <p>Returned after a successful <code>UpdateSnapshot</code> operation, describing the snapshot that you updated.</p>
    pub fn snapshot(&self) -> std::option::Option<&crate::model::Snapshot> {
        self.snapshot.as_ref()
    }
}
impl std::fmt::Debug for UpdateSnapshotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSnapshotOutput");
        formatter.field("snapshot", &self.snapshot);
        formatter.finish()
    }
}
/// See [`UpdateSnapshotOutput`](crate::output::UpdateSnapshotOutput)
pub mod update_snapshot_output {
    /// A builder for [`UpdateSnapshotOutput`](crate::output::UpdateSnapshotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot: std::option::Option<crate::model::Snapshot>,
    }
    impl Builder {
        /// <p>Returned after a successful <code>UpdateSnapshot</code> operation, describing the snapshot that you updated.</p>
        pub fn snapshot(mut self, input: crate::model::Snapshot) -> Self {
            self.snapshot = Some(input);
            self
        }
        /// <p>Returned after a successful <code>UpdateSnapshot</code> operation, describing the snapshot that you updated.</p>
        pub fn set_snapshot(mut self, input: std::option::Option<crate::model::Snapshot>) -> Self {
            self.snapshot = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSnapshotOutput`](crate::output::UpdateSnapshotOutput)
        pub fn build(self) -> crate::output::UpdateSnapshotOutput {
            crate::output::UpdateSnapshotOutput {
                snapshot: self.snapshot,
            }
        }
    }
}
impl UpdateSnapshotOutput {
    /// Creates a new builder-style object to manufacture [`UpdateSnapshotOutput`](crate::output::UpdateSnapshotOutput)
    pub fn builder() -> crate::output::update_snapshot_output::Builder {
        crate::output::update_snapshot_output::Builder::default()
    }
}

/// <p>The response object for the <code>UpdateFileSystem</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFileSystemOutput {
    /// <p>A description of the file system that was updated.</p>
    pub file_system: std::option::Option<crate::model::FileSystem>,
}
impl UpdateFileSystemOutput {
    /// <p>A description of the file system that was updated.</p>
    pub fn file_system(&self) -> std::option::Option<&crate::model::FileSystem> {
        self.file_system.as_ref()
    }
}
impl std::fmt::Debug for UpdateFileSystemOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFileSystemOutput");
        formatter.field("file_system", &self.file_system);
        formatter.finish()
    }
}
/// See [`UpdateFileSystemOutput`](crate::output::UpdateFileSystemOutput)
pub mod update_file_system_output {
    /// A builder for [`UpdateFileSystemOutput`](crate::output::UpdateFileSystemOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system: std::option::Option<crate::model::FileSystem>,
    }
    impl Builder {
        /// <p>A description of the file system that was updated.</p>
        pub fn file_system(mut self, input: crate::model::FileSystem) -> Self {
            self.file_system = Some(input);
            self
        }
        /// <p>A description of the file system that was updated.</p>
        pub fn set_file_system(
            mut self,
            input: std::option::Option<crate::model::FileSystem>,
        ) -> Self {
            self.file_system = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFileSystemOutput`](crate::output::UpdateFileSystemOutput)
        pub fn build(self) -> crate::output::UpdateFileSystemOutput {
            crate::output::UpdateFileSystemOutput {
                file_system: self.file_system,
            }
        }
    }
}
impl UpdateFileSystemOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFileSystemOutput`](crate::output::UpdateFileSystemOutput)
    pub fn builder() -> crate::output::update_file_system_output::Builder {
        crate::output::update_file_system_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDataRepositoryAssociationOutput {
    /// <p>The response object returned after the data repository association is updated.</p>
    pub association: std::option::Option<crate::model::DataRepositoryAssociation>,
}
impl UpdateDataRepositoryAssociationOutput {
    /// <p>The response object returned after the data repository association is updated.</p>
    pub fn association(&self) -> std::option::Option<&crate::model::DataRepositoryAssociation> {
        self.association.as_ref()
    }
}
impl std::fmt::Debug for UpdateDataRepositoryAssociationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDataRepositoryAssociationOutput");
        formatter.field("association", &self.association);
        formatter.finish()
    }
}
/// See [`UpdateDataRepositoryAssociationOutput`](crate::output::UpdateDataRepositoryAssociationOutput)
pub mod update_data_repository_association_output {
    /// A builder for [`UpdateDataRepositoryAssociationOutput`](crate::output::UpdateDataRepositoryAssociationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) association: std::option::Option<crate::model::DataRepositoryAssociation>,
    }
    impl Builder {
        /// <p>The response object returned after the data repository association is updated.</p>
        pub fn association(mut self, input: crate::model::DataRepositoryAssociation) -> Self {
            self.association = Some(input);
            self
        }
        /// <p>The response object returned after the data repository association is updated.</p>
        pub fn set_association(
            mut self,
            input: std::option::Option<crate::model::DataRepositoryAssociation>,
        ) -> Self {
            self.association = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDataRepositoryAssociationOutput`](crate::output::UpdateDataRepositoryAssociationOutput)
        pub fn build(self) -> crate::output::UpdateDataRepositoryAssociationOutput {
            crate::output::UpdateDataRepositoryAssociationOutput {
                association: self.association,
            }
        }
    }
}
impl UpdateDataRepositoryAssociationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDataRepositoryAssociationOutput`](crate::output::UpdateDataRepositoryAssociationOutput)
    pub fn builder() -> crate::output::update_data_repository_association_output::Builder {
        crate::output::update_data_repository_association_output::Builder::default()
    }
}

/// <p>The response object for <code>UntagResource</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

/// <p>The response object for the <code>TagResource</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreVolumeFromSnapshotOutput {
    /// <p>The ID of the volume that you restored.</p>
    pub volume_id: std::option::Option<std::string::String>,
    /// <p>The lifecycle state of the volume being restored.</p>
    pub lifecycle: std::option::Option<crate::model::VolumeLifecycle>,
}
impl RestoreVolumeFromSnapshotOutput {
    /// <p>The ID of the volume that you restored.</p>
    pub fn volume_id(&self) -> std::option::Option<&str> {
        self.volume_id.as_deref()
    }
    /// <p>The lifecycle state of the volume being restored.</p>
    pub fn lifecycle(&self) -> std::option::Option<&crate::model::VolumeLifecycle> {
        self.lifecycle.as_ref()
    }
}
impl std::fmt::Debug for RestoreVolumeFromSnapshotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreVolumeFromSnapshotOutput");
        formatter.field("volume_id", &self.volume_id);
        formatter.field("lifecycle", &self.lifecycle);
        formatter.finish()
    }
}
/// See [`RestoreVolumeFromSnapshotOutput`](crate::output::RestoreVolumeFromSnapshotOutput)
pub mod restore_volume_from_snapshot_output {
    /// A builder for [`RestoreVolumeFromSnapshotOutput`](crate::output::RestoreVolumeFromSnapshotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_id: std::option::Option<std::string::String>,
        pub(crate) lifecycle: std::option::Option<crate::model::VolumeLifecycle>,
    }
    impl Builder {
        /// <p>The ID of the volume that you restored.</p>
        pub fn volume_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_id = Some(input.into());
            self
        }
        /// <p>The ID of the volume that you restored.</p>
        pub fn set_volume_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_id = input;
            self
        }
        /// <p>The lifecycle state of the volume being restored.</p>
        pub fn lifecycle(mut self, input: crate::model::VolumeLifecycle) -> Self {
            self.lifecycle = Some(input);
            self
        }
        /// <p>The lifecycle state of the volume being restored.</p>
        pub fn set_lifecycle(
            mut self,
            input: std::option::Option<crate::model::VolumeLifecycle>,
        ) -> Self {
            self.lifecycle = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreVolumeFromSnapshotOutput`](crate::output::RestoreVolumeFromSnapshotOutput)
        pub fn build(self) -> crate::output::RestoreVolumeFromSnapshotOutput {
            crate::output::RestoreVolumeFromSnapshotOutput {
                volume_id: self.volume_id,
                lifecycle: self.lifecycle,
            }
        }
    }
}
impl RestoreVolumeFromSnapshotOutput {
    /// Creates a new builder-style object to manufacture [`RestoreVolumeFromSnapshotOutput`](crate::output::RestoreVolumeFromSnapshotOutput)
    pub fn builder() -> crate::output::restore_volume_from_snapshot_output::Builder {
        crate::output::restore_volume_from_snapshot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReleaseFileSystemNfsV3LocksOutput {
    /// <p>A description of a specific Amazon FSx file system.</p>
    pub file_system: std::option::Option<crate::model::FileSystem>,
}
impl ReleaseFileSystemNfsV3LocksOutput {
    /// <p>A description of a specific Amazon FSx file system.</p>
    pub fn file_system(&self) -> std::option::Option<&crate::model::FileSystem> {
        self.file_system.as_ref()
    }
}
impl std::fmt::Debug for ReleaseFileSystemNfsV3LocksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReleaseFileSystemNfsV3LocksOutput");
        formatter.field("file_system", &self.file_system);
        formatter.finish()
    }
}
/// See [`ReleaseFileSystemNfsV3LocksOutput`](crate::output::ReleaseFileSystemNfsV3LocksOutput)
pub mod release_file_system_nfs_v3_locks_output {
    /// A builder for [`ReleaseFileSystemNfsV3LocksOutput`](crate::output::ReleaseFileSystemNfsV3LocksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system: std::option::Option<crate::model::FileSystem>,
    }
    impl Builder {
        /// <p>A description of a specific Amazon FSx file system.</p>
        pub fn file_system(mut self, input: crate::model::FileSystem) -> Self {
            self.file_system = Some(input);
            self
        }
        /// <p>A description of a specific Amazon FSx file system.</p>
        pub fn set_file_system(
            mut self,
            input: std::option::Option<crate::model::FileSystem>,
        ) -> Self {
            self.file_system = input;
            self
        }
        /// Consumes the builder and constructs a [`ReleaseFileSystemNfsV3LocksOutput`](crate::output::ReleaseFileSystemNfsV3LocksOutput)
        pub fn build(self) -> crate::output::ReleaseFileSystemNfsV3LocksOutput {
            crate::output::ReleaseFileSystemNfsV3LocksOutput {
                file_system: self.file_system,
            }
        }
    }
}
impl ReleaseFileSystemNfsV3LocksOutput {
    /// Creates a new builder-style object to manufacture [`ReleaseFileSystemNfsV3LocksOutput`](crate::output::ReleaseFileSystemNfsV3LocksOutput)
    pub fn builder() -> crate::output::release_file_system_nfs_v3_locks_output::Builder {
        crate::output::release_file_system_nfs_v3_locks_output::Builder::default()
    }
}

/// <p>The response object for <code>ListTagsForResource</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>A list of tags on the resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>This is present if there are more tags than returned in the response (String). You can use the <code>NextToken</code> value in the later request to fetch the tags. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsForResourceOutput {
    /// <p>A list of tags on the resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>This is present if there are more tags than returned in the response (String). You can use the <code>NextToken</code> value in the later request to fetch the tags. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags on the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags on the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>This is present if there are more tags than returned in the response (String). You can use the <code>NextToken</code> value in the later request to fetch the tags. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>This is present if there are more tags than returned in the response (String). You can use the <code>NextToken</code> value in the later request to fetch the tags. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                tags: self.tags,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

/// <p>The system generated response showing the DNS aliases that Amazon FSx is attempting to disassociate from the file system. Use the API operation to monitor the status of the aliases Amazon FSx is removing from the file system.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateFileSystemAliasesOutput {
    /// <p>An array of one or more DNS aliases that Amazon FSx is attempting to disassociate from the file system.</p>
    pub aliases: std::option::Option<std::vec::Vec<crate::model::Alias>>,
}
impl DisassociateFileSystemAliasesOutput {
    /// <p>An array of one or more DNS aliases that Amazon FSx is attempting to disassociate from the file system.</p>
    pub fn aliases(&self) -> std::option::Option<&[crate::model::Alias]> {
        self.aliases.as_deref()
    }
}
impl std::fmt::Debug for DisassociateFileSystemAliasesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateFileSystemAliasesOutput");
        formatter.field("aliases", &self.aliases);
        formatter.finish()
    }
}
/// See [`DisassociateFileSystemAliasesOutput`](crate::output::DisassociateFileSystemAliasesOutput)
pub mod disassociate_file_system_aliases_output {
    /// A builder for [`DisassociateFileSystemAliasesOutput`](crate::output::DisassociateFileSystemAliasesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aliases: std::option::Option<std::vec::Vec<crate::model::Alias>>,
    }
    impl Builder {
        /// Appends an item to `aliases`.
        ///
        /// To override the contents of this collection use [`set_aliases`](Self::set_aliases).
        ///
        /// <p>An array of one or more DNS aliases that Amazon FSx is attempting to disassociate from the file system.</p>
        pub fn aliases(mut self, input: crate::model::Alias) -> Self {
            let mut v = self.aliases.unwrap_or_default();
            v.push(input);
            self.aliases = Some(v);
            self
        }
        /// <p>An array of one or more DNS aliases that Amazon FSx is attempting to disassociate from the file system.</p>
        pub fn set_aliases(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Alias>>,
        ) -> Self {
            self.aliases = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateFileSystemAliasesOutput`](crate::output::DisassociateFileSystemAliasesOutput)
        pub fn build(self) -> crate::output::DisassociateFileSystemAliasesOutput {
            crate::output::DisassociateFileSystemAliasesOutput {
                aliases: self.aliases,
            }
        }
    }
}
impl DisassociateFileSystemAliasesOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateFileSystemAliasesOutput`](crate::output::DisassociateFileSystemAliasesOutput)
    pub fn builder() -> crate::output::disassociate_file_system_aliases_output::Builder {
        crate::output::disassociate_file_system_aliases_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeVolumesOutput {
    /// <p>Returned after a successful <code>DescribeVolumes</code> operation, describing each volume.</p>
    pub volumes: std::option::Option<std::vec::Vec<crate::model::Volume>>,
    /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeVolumesOutput {
    /// <p>Returned after a successful <code>DescribeVolumes</code> operation, describing each volume.</p>
    pub fn volumes(&self) -> std::option::Option<&[crate::model::Volume]> {
        self.volumes.as_deref()
    }
    /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeVolumesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeVolumesOutput");
        formatter.field("volumes", &self.volumes);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeVolumesOutput`](crate::output::DescribeVolumesOutput)
pub mod describe_volumes_output {
    /// A builder for [`DescribeVolumesOutput`](crate::output::DescribeVolumesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volumes: std::option::Option<std::vec::Vec<crate::model::Volume>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `volumes`.
        ///
        /// To override the contents of this collection use [`set_volumes`](Self::set_volumes).
        ///
        /// <p>Returned after a successful <code>DescribeVolumes</code> operation, describing each volume.</p>
        pub fn volumes(mut self, input: crate::model::Volume) -> Self {
            let mut v = self.volumes.unwrap_or_default();
            v.push(input);
            self.volumes = Some(v);
            self
        }
        /// <p>Returned after a successful <code>DescribeVolumes</code> operation, describing each volume.</p>
        pub fn set_volumes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Volume>>,
        ) -> Self {
            self.volumes = input;
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeVolumesOutput`](crate::output::DescribeVolumesOutput)
        pub fn build(self) -> crate::output::DescribeVolumesOutput {
            crate::output::DescribeVolumesOutput {
                volumes: self.volumes,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeVolumesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeVolumesOutput`](crate::output::DescribeVolumesOutput)
    pub fn builder() -> crate::output::describe_volumes_output::Builder {
        crate::output::describe_volumes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeStorageVirtualMachinesOutput {
    /// <p>Returned after a successful <code>DescribeStorageVirtualMachines</code> operation, describing each SVM.</p>
    pub storage_virtual_machines:
        std::option::Option<std::vec::Vec<crate::model::StorageVirtualMachine>>,
    /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeStorageVirtualMachinesOutput {
    /// <p>Returned after a successful <code>DescribeStorageVirtualMachines</code> operation, describing each SVM.</p>
    pub fn storage_virtual_machines(
        &self,
    ) -> std::option::Option<&[crate::model::StorageVirtualMachine]> {
        self.storage_virtual_machines.as_deref()
    }
    /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeStorageVirtualMachinesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeStorageVirtualMachinesOutput");
        formatter.field("storage_virtual_machines", &self.storage_virtual_machines);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeStorageVirtualMachinesOutput`](crate::output::DescribeStorageVirtualMachinesOutput)
pub mod describe_storage_virtual_machines_output {
    /// A builder for [`DescribeStorageVirtualMachinesOutput`](crate::output::DescribeStorageVirtualMachinesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) storage_virtual_machines:
            std::option::Option<std::vec::Vec<crate::model::StorageVirtualMachine>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `storage_virtual_machines`.
        ///
        /// To override the contents of this collection use [`set_storage_virtual_machines`](Self::set_storage_virtual_machines).
        ///
        /// <p>Returned after a successful <code>DescribeStorageVirtualMachines</code> operation, describing each SVM.</p>
        pub fn storage_virtual_machines(
            mut self,
            input: crate::model::StorageVirtualMachine,
        ) -> Self {
            let mut v = self.storage_virtual_machines.unwrap_or_default();
            v.push(input);
            self.storage_virtual_machines = Some(v);
            self
        }
        /// <p>Returned after a successful <code>DescribeStorageVirtualMachines</code> operation, describing each SVM.</p>
        pub fn set_storage_virtual_machines(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StorageVirtualMachine>>,
        ) -> Self {
            self.storage_virtual_machines = input;
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStorageVirtualMachinesOutput`](crate::output::DescribeStorageVirtualMachinesOutput)
        pub fn build(self) -> crate::output::DescribeStorageVirtualMachinesOutput {
            crate::output::DescribeStorageVirtualMachinesOutput {
                storage_virtual_machines: self.storage_virtual_machines,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeStorageVirtualMachinesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeStorageVirtualMachinesOutput`](crate::output::DescribeStorageVirtualMachinesOutput)
    pub fn builder() -> crate::output::describe_storage_virtual_machines_output::Builder {
        crate::output::describe_storage_virtual_machines_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSnapshotsOutput {
    /// <p>An array of snapshots.</p>
    pub snapshots: std::option::Option<std::vec::Vec<crate::model::Snapshot>>,
    /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeSnapshotsOutput {
    /// <p>An array of snapshots.</p>
    pub fn snapshots(&self) -> std::option::Option<&[crate::model::Snapshot]> {
        self.snapshots.as_deref()
    }
    /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeSnapshotsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSnapshotsOutput");
        formatter.field("snapshots", &self.snapshots);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeSnapshotsOutput`](crate::output::DescribeSnapshotsOutput)
pub mod describe_snapshots_output {
    /// A builder for [`DescribeSnapshotsOutput`](crate::output::DescribeSnapshotsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshots: std::option::Option<std::vec::Vec<crate::model::Snapshot>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `snapshots`.
        ///
        /// To override the contents of this collection use [`set_snapshots`](Self::set_snapshots).
        ///
        /// <p>An array of snapshots.</p>
        pub fn snapshots(mut self, input: crate::model::Snapshot) -> Self {
            let mut v = self.snapshots.unwrap_or_default();
            v.push(input);
            self.snapshots = Some(v);
            self
        }
        /// <p>An array of snapshots.</p>
        pub fn set_snapshots(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Snapshot>>,
        ) -> Self {
            self.snapshots = input;
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSnapshotsOutput`](crate::output::DescribeSnapshotsOutput)
        pub fn build(self) -> crate::output::DescribeSnapshotsOutput {
            crate::output::DescribeSnapshotsOutput {
                snapshots: self.snapshots,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeSnapshotsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSnapshotsOutput`](crate::output::DescribeSnapshotsOutput)
    pub fn builder() -> crate::output::describe_snapshots_output::Builder {
        crate::output::describe_snapshots_output::Builder::default()
    }
}

/// <p>The response object for <code>DescribeFileSystems</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFileSystemsOutput {
    /// <p>An array of file system descriptions.</p>
    pub file_systems: std::option::Option<std::vec::Vec<crate::model::FileSystem>>,
    /// <p>Present if there are more file systems than returned in the response (String). You can use the <code>NextToken</code> value in the later request to fetch the descriptions. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeFileSystemsOutput {
    /// <p>An array of file system descriptions.</p>
    pub fn file_systems(&self) -> std::option::Option<&[crate::model::FileSystem]> {
        self.file_systems.as_deref()
    }
    /// <p>Present if there are more file systems than returned in the response (String). You can use the <code>NextToken</code> value in the later request to fetch the descriptions. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeFileSystemsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFileSystemsOutput");
        formatter.field("file_systems", &self.file_systems);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeFileSystemsOutput`](crate::output::DescribeFileSystemsOutput)
pub mod describe_file_systems_output {
    /// A builder for [`DescribeFileSystemsOutput`](crate::output::DescribeFileSystemsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_systems: std::option::Option<std::vec::Vec<crate::model::FileSystem>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `file_systems`.
        ///
        /// To override the contents of this collection use [`set_file_systems`](Self::set_file_systems).
        ///
        /// <p>An array of file system descriptions.</p>
        pub fn file_systems(mut self, input: crate::model::FileSystem) -> Self {
            let mut v = self.file_systems.unwrap_or_default();
            v.push(input);
            self.file_systems = Some(v);
            self
        }
        /// <p>An array of file system descriptions.</p>
        pub fn set_file_systems(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FileSystem>>,
        ) -> Self {
            self.file_systems = input;
            self
        }
        /// <p>Present if there are more file systems than returned in the response (String). You can use the <code>NextToken</code> value in the later request to fetch the descriptions. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Present if there are more file systems than returned in the response (String). You can use the <code>NextToken</code> value in the later request to fetch the descriptions. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFileSystemsOutput`](crate::output::DescribeFileSystemsOutput)
        pub fn build(self) -> crate::output::DescribeFileSystemsOutput {
            crate::output::DescribeFileSystemsOutput {
                file_systems: self.file_systems,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeFileSystemsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFileSystemsOutput`](crate::output::DescribeFileSystemsOutput)
    pub fn builder() -> crate::output::describe_file_systems_output::Builder {
        crate::output::describe_file_systems_output::Builder::default()
    }
}

/// <p>The response object for <code>DescribeFileSystemAliases</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFileSystemAliasesOutput {
    /// <p>An array of one or more DNS aliases currently associated with the specified file system.</p>
    pub aliases: std::option::Option<std::vec::Vec<crate::model::Alias>>,
    /// <p>Present if there are more DNS aliases than returned in the response (String). You can use the <code>NextToken</code> value in a later request to fetch additional descriptions. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeFileSystemAliasesOutput {
    /// <p>An array of one or more DNS aliases currently associated with the specified file system.</p>
    pub fn aliases(&self) -> std::option::Option<&[crate::model::Alias]> {
        self.aliases.as_deref()
    }
    /// <p>Present if there are more DNS aliases than returned in the response (String). You can use the <code>NextToken</code> value in a later request to fetch additional descriptions. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeFileSystemAliasesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFileSystemAliasesOutput");
        formatter.field("aliases", &self.aliases);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeFileSystemAliasesOutput`](crate::output::DescribeFileSystemAliasesOutput)
pub mod describe_file_system_aliases_output {
    /// A builder for [`DescribeFileSystemAliasesOutput`](crate::output::DescribeFileSystemAliasesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aliases: std::option::Option<std::vec::Vec<crate::model::Alias>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `aliases`.
        ///
        /// To override the contents of this collection use [`set_aliases`](Self::set_aliases).
        ///
        /// <p>An array of one or more DNS aliases currently associated with the specified file system.</p>
        pub fn aliases(mut self, input: crate::model::Alias) -> Self {
            let mut v = self.aliases.unwrap_or_default();
            v.push(input);
            self.aliases = Some(v);
            self
        }
        /// <p>An array of one or more DNS aliases currently associated with the specified file system.</p>
        pub fn set_aliases(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Alias>>,
        ) -> Self {
            self.aliases = input;
            self
        }
        /// <p>Present if there are more DNS aliases than returned in the response (String). You can use the <code>NextToken</code> value in a later request to fetch additional descriptions. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Present if there are more DNS aliases than returned in the response (String). You can use the <code>NextToken</code> value in a later request to fetch additional descriptions. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFileSystemAliasesOutput`](crate::output::DescribeFileSystemAliasesOutput)
        pub fn build(self) -> crate::output::DescribeFileSystemAliasesOutput {
            crate::output::DescribeFileSystemAliasesOutput {
                aliases: self.aliases,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeFileSystemAliasesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFileSystemAliasesOutput`](crate::output::DescribeFileSystemAliasesOutput)
    pub fn builder() -> crate::output::describe_file_system_aliases_output::Builder {
        crate::output::describe_file_system_aliases_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDataRepositoryTasksOutput {
    /// <p>The collection of data repository task descriptions returned.</p>
    pub data_repository_tasks: std::option::Option<std::vec::Vec<crate::model::DataRepositoryTask>>,
    /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeDataRepositoryTasksOutput {
    /// <p>The collection of data repository task descriptions returned.</p>
    pub fn data_repository_tasks(
        &self,
    ) -> std::option::Option<&[crate::model::DataRepositoryTask]> {
        self.data_repository_tasks.as_deref()
    }
    /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeDataRepositoryTasksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDataRepositoryTasksOutput");
        formatter.field("data_repository_tasks", &self.data_repository_tasks);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeDataRepositoryTasksOutput`](crate::output::DescribeDataRepositoryTasksOutput)
pub mod describe_data_repository_tasks_output {
    /// A builder for [`DescribeDataRepositoryTasksOutput`](crate::output::DescribeDataRepositoryTasksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_repository_tasks:
            std::option::Option<std::vec::Vec<crate::model::DataRepositoryTask>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `data_repository_tasks`.
        ///
        /// To override the contents of this collection use [`set_data_repository_tasks`](Self::set_data_repository_tasks).
        ///
        /// <p>The collection of data repository task descriptions returned.</p>
        pub fn data_repository_tasks(mut self, input: crate::model::DataRepositoryTask) -> Self {
            let mut v = self.data_repository_tasks.unwrap_or_default();
            v.push(input);
            self.data_repository_tasks = Some(v);
            self
        }
        /// <p>The collection of data repository task descriptions returned.</p>
        pub fn set_data_repository_tasks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataRepositoryTask>>,
        ) -> Self {
            self.data_repository_tasks = input;
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDataRepositoryTasksOutput`](crate::output::DescribeDataRepositoryTasksOutput)
        pub fn build(self) -> crate::output::DescribeDataRepositoryTasksOutput {
            crate::output::DescribeDataRepositoryTasksOutput {
                data_repository_tasks: self.data_repository_tasks,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeDataRepositoryTasksOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDataRepositoryTasksOutput`](crate::output::DescribeDataRepositoryTasksOutput)
    pub fn builder() -> crate::output::describe_data_repository_tasks_output::Builder {
        crate::output::describe_data_repository_tasks_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDataRepositoryAssociationsOutput {
    /// <p>An array of one ore more data repository association descriptions.</p>
    pub associations: std::option::Option<std::vec::Vec<crate::model::DataRepositoryAssociation>>,
    /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeDataRepositoryAssociationsOutput {
    /// <p>An array of one ore more data repository association descriptions.</p>
    pub fn associations(&self) -> std::option::Option<&[crate::model::DataRepositoryAssociation]> {
        self.associations.as_deref()
    }
    /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeDataRepositoryAssociationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDataRepositoryAssociationsOutput");
        formatter.field("associations", &self.associations);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeDataRepositoryAssociationsOutput`](crate::output::DescribeDataRepositoryAssociationsOutput)
pub mod describe_data_repository_associations_output {
    /// A builder for [`DescribeDataRepositoryAssociationsOutput`](crate::output::DescribeDataRepositoryAssociationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) associations:
            std::option::Option<std::vec::Vec<crate::model::DataRepositoryAssociation>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `associations`.
        ///
        /// To override the contents of this collection use [`set_associations`](Self::set_associations).
        ///
        /// <p>An array of one ore more data repository association descriptions.</p>
        pub fn associations(mut self, input: crate::model::DataRepositoryAssociation) -> Self {
            let mut v = self.associations.unwrap_or_default();
            v.push(input);
            self.associations = Some(v);
            self
        }
        /// <p>An array of one ore more data repository association descriptions.</p>
        pub fn set_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataRepositoryAssociation>>,
        ) -> Self {
            self.associations = input;
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDataRepositoryAssociationsOutput`](crate::output::DescribeDataRepositoryAssociationsOutput)
        pub fn build(self) -> crate::output::DescribeDataRepositoryAssociationsOutput {
            crate::output::DescribeDataRepositoryAssociationsOutput {
                associations: self.associations,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeDataRepositoryAssociationsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDataRepositoryAssociationsOutput`](crate::output::DescribeDataRepositoryAssociationsOutput)
    pub fn builder() -> crate::output::describe_data_repository_associations_output::Builder {
        crate::output::describe_data_repository_associations_output::Builder::default()
    }
}

/// <p>Response object for the <code>DescribeBackups</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBackupsOutput {
    /// <p>An array of backups.</p>
    pub backups: std::option::Option<std::vec::Vec<crate::model::Backup>>,
    /// <p>A <code>NextToken</code> value is present if there are more backups than returned in the response. You can use the <code>NextToken</code> value in the subsequent request to fetch the backups. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeBackupsOutput {
    /// <p>An array of backups.</p>
    pub fn backups(&self) -> std::option::Option<&[crate::model::Backup]> {
        self.backups.as_deref()
    }
    /// <p>A <code>NextToken</code> value is present if there are more backups than returned in the response. You can use the <code>NextToken</code> value in the subsequent request to fetch the backups. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeBackupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBackupsOutput");
        formatter.field("backups", &self.backups);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeBackupsOutput`](crate::output::DescribeBackupsOutput)
pub mod describe_backups_output {
    /// A builder for [`DescribeBackupsOutput`](crate::output::DescribeBackupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backups: std::option::Option<std::vec::Vec<crate::model::Backup>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `backups`.
        ///
        /// To override the contents of this collection use [`set_backups`](Self::set_backups).
        ///
        /// <p>An array of backups.</p>
        pub fn backups(mut self, input: crate::model::Backup) -> Self {
            let mut v = self.backups.unwrap_or_default();
            v.push(input);
            self.backups = Some(v);
            self
        }
        /// <p>An array of backups.</p>
        pub fn set_backups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Backup>>,
        ) -> Self {
            self.backups = input;
            self
        }
        /// <p>A <code>NextToken</code> value is present if there are more backups than returned in the response. You can use the <code>NextToken</code> value in the subsequent request to fetch the backups. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A <code>NextToken</code> value is present if there are more backups than returned in the response. You can use the <code>NextToken</code> value in the subsequent request to fetch the backups. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBackupsOutput`](crate::output::DescribeBackupsOutput)
        pub fn build(self) -> crate::output::DescribeBackupsOutput {
            crate::output::DescribeBackupsOutput {
                backups: self.backups,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeBackupsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeBackupsOutput`](crate::output::DescribeBackupsOutput)
    pub fn builder() -> crate::output::describe_backups_output::Builder {
        crate::output::describe_backups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVolumeOutput {
    /// <p>The ID of the volume that's being deleted.</p>
    pub volume_id: std::option::Option<std::string::String>,
    /// <p>The lifecycle state of the volume being deleted. If the <code>DeleteVolume</code> operation is successful, this value is <code>DELETING</code>.</p>
    pub lifecycle: std::option::Option<crate::model::VolumeLifecycle>,
    /// <p>Returned after a <code>DeleteVolume</code> request, showing the status of the delete request.</p>
    pub ontap_response: std::option::Option<crate::model::DeleteVolumeOntapResponse>,
}
impl DeleteVolumeOutput {
    /// <p>The ID of the volume that's being deleted.</p>
    pub fn volume_id(&self) -> std::option::Option<&str> {
        self.volume_id.as_deref()
    }
    /// <p>The lifecycle state of the volume being deleted. If the <code>DeleteVolume</code> operation is successful, this value is <code>DELETING</code>.</p>
    pub fn lifecycle(&self) -> std::option::Option<&crate::model::VolumeLifecycle> {
        self.lifecycle.as_ref()
    }
    /// <p>Returned after a <code>DeleteVolume</code> request, showing the status of the delete request.</p>
    pub fn ontap_response(&self) -> std::option::Option<&crate::model::DeleteVolumeOntapResponse> {
        self.ontap_response.as_ref()
    }
}
impl std::fmt::Debug for DeleteVolumeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVolumeOutput");
        formatter.field("volume_id", &self.volume_id);
        formatter.field("lifecycle", &self.lifecycle);
        formatter.field("ontap_response", &self.ontap_response);
        formatter.finish()
    }
}
/// See [`DeleteVolumeOutput`](crate::output::DeleteVolumeOutput)
pub mod delete_volume_output {
    /// A builder for [`DeleteVolumeOutput`](crate::output::DeleteVolumeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_id: std::option::Option<std::string::String>,
        pub(crate) lifecycle: std::option::Option<crate::model::VolumeLifecycle>,
        pub(crate) ontap_response: std::option::Option<crate::model::DeleteVolumeOntapResponse>,
    }
    impl Builder {
        /// <p>The ID of the volume that's being deleted.</p>
        pub fn volume_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_id = Some(input.into());
            self
        }
        /// <p>The ID of the volume that's being deleted.</p>
        pub fn set_volume_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_id = input;
            self
        }
        /// <p>The lifecycle state of the volume being deleted. If the <code>DeleteVolume</code> operation is successful, this value is <code>DELETING</code>.</p>
        pub fn lifecycle(mut self, input: crate::model::VolumeLifecycle) -> Self {
            self.lifecycle = Some(input);
            self
        }
        /// <p>The lifecycle state of the volume being deleted. If the <code>DeleteVolume</code> operation is successful, this value is <code>DELETING</code>.</p>
        pub fn set_lifecycle(
            mut self,
            input: std::option::Option<crate::model::VolumeLifecycle>,
        ) -> Self {
            self.lifecycle = input;
            self
        }
        /// <p>Returned after a <code>DeleteVolume</code> request, showing the status of the delete request.</p>
        pub fn ontap_response(mut self, input: crate::model::DeleteVolumeOntapResponse) -> Self {
            self.ontap_response = Some(input);
            self
        }
        /// <p>Returned after a <code>DeleteVolume</code> request, showing the status of the delete request.</p>
        pub fn set_ontap_response(
            mut self,
            input: std::option::Option<crate::model::DeleteVolumeOntapResponse>,
        ) -> Self {
            self.ontap_response = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVolumeOutput`](crate::output::DeleteVolumeOutput)
        pub fn build(self) -> crate::output::DeleteVolumeOutput {
            crate::output::DeleteVolumeOutput {
                volume_id: self.volume_id,
                lifecycle: self.lifecycle,
                ontap_response: self.ontap_response,
            }
        }
    }
}
impl DeleteVolumeOutput {
    /// Creates a new builder-style object to manufacture [`DeleteVolumeOutput`](crate::output::DeleteVolumeOutput)
    pub fn builder() -> crate::output::delete_volume_output::Builder {
        crate::output::delete_volume_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteStorageVirtualMachineOutput {
    /// <p>The ID of the SVM Amazon FSx is deleting.</p>
    pub storage_virtual_machine_id: std::option::Option<std::string::String>,
    /// <p>Describes the lifecycle state of the SVM being deleted.</p>
    pub lifecycle: std::option::Option<crate::model::StorageVirtualMachineLifecycle>,
}
impl DeleteStorageVirtualMachineOutput {
    /// <p>The ID of the SVM Amazon FSx is deleting.</p>
    pub fn storage_virtual_machine_id(&self) -> std::option::Option<&str> {
        self.storage_virtual_machine_id.as_deref()
    }
    /// <p>Describes the lifecycle state of the SVM being deleted.</p>
    pub fn lifecycle(&self) -> std::option::Option<&crate::model::StorageVirtualMachineLifecycle> {
        self.lifecycle.as_ref()
    }
}
impl std::fmt::Debug for DeleteStorageVirtualMachineOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteStorageVirtualMachineOutput");
        formatter.field(
            "storage_virtual_machine_id",
            &self.storage_virtual_machine_id,
        );
        formatter.field("lifecycle", &self.lifecycle);
        formatter.finish()
    }
}
/// See [`DeleteStorageVirtualMachineOutput`](crate::output::DeleteStorageVirtualMachineOutput)
pub mod delete_storage_virtual_machine_output {
    /// A builder for [`DeleteStorageVirtualMachineOutput`](crate::output::DeleteStorageVirtualMachineOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) storage_virtual_machine_id: std::option::Option<std::string::String>,
        pub(crate) lifecycle: std::option::Option<crate::model::StorageVirtualMachineLifecycle>,
    }
    impl Builder {
        /// <p>The ID of the SVM Amazon FSx is deleting.</p>
        pub fn storage_virtual_machine_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.storage_virtual_machine_id = Some(input.into());
            self
        }
        /// <p>The ID of the SVM Amazon FSx is deleting.</p>
        pub fn set_storage_virtual_machine_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.storage_virtual_machine_id = input;
            self
        }
        /// <p>Describes the lifecycle state of the SVM being deleted.</p>
        pub fn lifecycle(mut self, input: crate::model::StorageVirtualMachineLifecycle) -> Self {
            self.lifecycle = Some(input);
            self
        }
        /// <p>Describes the lifecycle state of the SVM being deleted.</p>
        pub fn set_lifecycle(
            mut self,
            input: std::option::Option<crate::model::StorageVirtualMachineLifecycle>,
        ) -> Self {
            self.lifecycle = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteStorageVirtualMachineOutput`](crate::output::DeleteStorageVirtualMachineOutput)
        pub fn build(self) -> crate::output::DeleteStorageVirtualMachineOutput {
            crate::output::DeleteStorageVirtualMachineOutput {
                storage_virtual_machine_id: self.storage_virtual_machine_id,
                lifecycle: self.lifecycle,
            }
        }
    }
}
impl DeleteStorageVirtualMachineOutput {
    /// Creates a new builder-style object to manufacture [`DeleteStorageVirtualMachineOutput`](crate::output::DeleteStorageVirtualMachineOutput)
    pub fn builder() -> crate::output::delete_storage_virtual_machine_output::Builder {
        crate::output::delete_storage_virtual_machine_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSnapshotOutput {
    /// <p>The ID of the deleted snapshot.</p>
    pub snapshot_id: std::option::Option<std::string::String>,
    /// <p>The lifecycle status of the snapshot. If the <code>DeleteSnapshot</code> operation is successful, this status is <code>DELETING</code>.</p>
    pub lifecycle: std::option::Option<crate::model::SnapshotLifecycle>,
}
impl DeleteSnapshotOutput {
    /// <p>The ID of the deleted snapshot.</p>
    pub fn snapshot_id(&self) -> std::option::Option<&str> {
        self.snapshot_id.as_deref()
    }
    /// <p>The lifecycle status of the snapshot. If the <code>DeleteSnapshot</code> operation is successful, this status is <code>DELETING</code>.</p>
    pub fn lifecycle(&self) -> std::option::Option<&crate::model::SnapshotLifecycle> {
        self.lifecycle.as_ref()
    }
}
impl std::fmt::Debug for DeleteSnapshotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSnapshotOutput");
        formatter.field("snapshot_id", &self.snapshot_id);
        formatter.field("lifecycle", &self.lifecycle);
        formatter.finish()
    }
}
/// See [`DeleteSnapshotOutput`](crate::output::DeleteSnapshotOutput)
pub mod delete_snapshot_output {
    /// A builder for [`DeleteSnapshotOutput`](crate::output::DeleteSnapshotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot_id: std::option::Option<std::string::String>,
        pub(crate) lifecycle: std::option::Option<crate::model::SnapshotLifecycle>,
    }
    impl Builder {
        /// <p>The ID of the deleted snapshot.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_id = Some(input.into());
            self
        }
        /// <p>The ID of the deleted snapshot.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.snapshot_id = input;
            self
        }
        /// <p>The lifecycle status of the snapshot. If the <code>DeleteSnapshot</code> operation is successful, this status is <code>DELETING</code>.</p>
        pub fn lifecycle(mut self, input: crate::model::SnapshotLifecycle) -> Self {
            self.lifecycle = Some(input);
            self
        }
        /// <p>The lifecycle status of the snapshot. If the <code>DeleteSnapshot</code> operation is successful, this status is <code>DELETING</code>.</p>
        pub fn set_lifecycle(
            mut self,
            input: std::option::Option<crate::model::SnapshotLifecycle>,
        ) -> Self {
            self.lifecycle = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSnapshotOutput`](crate::output::DeleteSnapshotOutput)
        pub fn build(self) -> crate::output::DeleteSnapshotOutput {
            crate::output::DeleteSnapshotOutput {
                snapshot_id: self.snapshot_id,
                lifecycle: self.lifecycle,
            }
        }
    }
}
impl DeleteSnapshotOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSnapshotOutput`](crate::output::DeleteSnapshotOutput)
    pub fn builder() -> crate::output::delete_snapshot_output::Builder {
        crate::output::delete_snapshot_output::Builder::default()
    }
}

/// <p>The response object for the <code>DeleteFileSystem</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFileSystemOutput {
    /// <p>The ID of the file system that's being deleted.</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>The file system lifecycle for the deletion request. If the <code>DeleteFileSystem</code> operation is successful, this status is <code>DELETING</code>.</p>
    pub lifecycle: std::option::Option<crate::model::FileSystemLifecycle>,
    /// <p>The response object for the Microsoft Windows file system used in the <code>DeleteFileSystem</code> operation.</p>
    pub windows_response: std::option::Option<crate::model::DeleteFileSystemWindowsResponse>,
    /// <p>The response object for the Amazon FSx for Lustre file system being deleted in the <code>DeleteFileSystem</code> operation.</p>
    pub lustre_response: std::option::Option<crate::model::DeleteFileSystemLustreResponse>,
    /// <p>The response object for the OpenZFS file system that's being deleted in the <code>DeleteFileSystem</code> operation.</p>
    pub open_zfs_response: std::option::Option<crate::model::DeleteFileSystemOpenZfsResponse>,
}
impl DeleteFileSystemOutput {
    /// <p>The ID of the file system that's being deleted.</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
    /// <p>The file system lifecycle for the deletion request. If the <code>DeleteFileSystem</code> operation is successful, this status is <code>DELETING</code>.</p>
    pub fn lifecycle(&self) -> std::option::Option<&crate::model::FileSystemLifecycle> {
        self.lifecycle.as_ref()
    }
    /// <p>The response object for the Microsoft Windows file system used in the <code>DeleteFileSystem</code> operation.</p>
    pub fn windows_response(
        &self,
    ) -> std::option::Option<&crate::model::DeleteFileSystemWindowsResponse> {
        self.windows_response.as_ref()
    }
    /// <p>The response object for the Amazon FSx for Lustre file system being deleted in the <code>DeleteFileSystem</code> operation.</p>
    pub fn lustre_response(
        &self,
    ) -> std::option::Option<&crate::model::DeleteFileSystemLustreResponse> {
        self.lustre_response.as_ref()
    }
    /// <p>The response object for the OpenZFS file system that's being deleted in the <code>DeleteFileSystem</code> operation.</p>
    pub fn open_zfs_response(
        &self,
    ) -> std::option::Option<&crate::model::DeleteFileSystemOpenZfsResponse> {
        self.open_zfs_response.as_ref()
    }
}
impl std::fmt::Debug for DeleteFileSystemOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFileSystemOutput");
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("lifecycle", &self.lifecycle);
        formatter.field("windows_response", &self.windows_response);
        formatter.field("lustre_response", &self.lustre_response);
        formatter.field("open_zfs_response", &self.open_zfs_response);
        formatter.finish()
    }
}
/// See [`DeleteFileSystemOutput`](crate::output::DeleteFileSystemOutput)
pub mod delete_file_system_output {
    /// A builder for [`DeleteFileSystemOutput`](crate::output::DeleteFileSystemOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) lifecycle: std::option::Option<crate::model::FileSystemLifecycle>,
        pub(crate) windows_response:
            std::option::Option<crate::model::DeleteFileSystemWindowsResponse>,
        pub(crate) lustre_response:
            std::option::Option<crate::model::DeleteFileSystemLustreResponse>,
        pub(crate) open_zfs_response:
            std::option::Option<crate::model::DeleteFileSystemOpenZfsResponse>,
    }
    impl Builder {
        /// <p>The ID of the file system that's being deleted.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>The ID of the file system that's being deleted.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// <p>The file system lifecycle for the deletion request. If the <code>DeleteFileSystem</code> operation is successful, this status is <code>DELETING</code>.</p>
        pub fn lifecycle(mut self, input: crate::model::FileSystemLifecycle) -> Self {
            self.lifecycle = Some(input);
            self
        }
        /// <p>The file system lifecycle for the deletion request. If the <code>DeleteFileSystem</code> operation is successful, this status is <code>DELETING</code>.</p>
        pub fn set_lifecycle(
            mut self,
            input: std::option::Option<crate::model::FileSystemLifecycle>,
        ) -> Self {
            self.lifecycle = input;
            self
        }
        /// <p>The response object for the Microsoft Windows file system used in the <code>DeleteFileSystem</code> operation.</p>
        pub fn windows_response(
            mut self,
            input: crate::model::DeleteFileSystemWindowsResponse,
        ) -> Self {
            self.windows_response = Some(input);
            self
        }
        /// <p>The response object for the Microsoft Windows file system used in the <code>DeleteFileSystem</code> operation.</p>
        pub fn set_windows_response(
            mut self,
            input: std::option::Option<crate::model::DeleteFileSystemWindowsResponse>,
        ) -> Self {
            self.windows_response = input;
            self
        }
        /// <p>The response object for the Amazon FSx for Lustre file system being deleted in the <code>DeleteFileSystem</code> operation.</p>
        pub fn lustre_response(
            mut self,
            input: crate::model::DeleteFileSystemLustreResponse,
        ) -> Self {
            self.lustre_response = Some(input);
            self
        }
        /// <p>The response object for the Amazon FSx for Lustre file system being deleted in the <code>DeleteFileSystem</code> operation.</p>
        pub fn set_lustre_response(
            mut self,
            input: std::option::Option<crate::model::DeleteFileSystemLustreResponse>,
        ) -> Self {
            self.lustre_response = input;
            self
        }
        /// <p>The response object for the OpenZFS file system that's being deleted in the <code>DeleteFileSystem</code> operation.</p>
        pub fn open_zfs_response(
            mut self,
            input: crate::model::DeleteFileSystemOpenZfsResponse,
        ) -> Self {
            self.open_zfs_response = Some(input);
            self
        }
        /// <p>The response object for the OpenZFS file system that's being deleted in the <code>DeleteFileSystem</code> operation.</p>
        pub fn set_open_zfs_response(
            mut self,
            input: std::option::Option<crate::model::DeleteFileSystemOpenZfsResponse>,
        ) -> Self {
            self.open_zfs_response = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFileSystemOutput`](crate::output::DeleteFileSystemOutput)
        pub fn build(self) -> crate::output::DeleteFileSystemOutput {
            crate::output::DeleteFileSystemOutput {
                file_system_id: self.file_system_id,
                lifecycle: self.lifecycle,
                windows_response: self.windows_response,
                lustre_response: self.lustre_response,
                open_zfs_response: self.open_zfs_response,
            }
        }
    }
}
impl DeleteFileSystemOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFileSystemOutput`](crate::output::DeleteFileSystemOutput)
    pub fn builder() -> crate::output::delete_file_system_output::Builder {
        crate::output::delete_file_system_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDataRepositoryAssociationOutput {
    /// <p>The ID of the data repository association being deleted.</p>
    pub association_id: std::option::Option<std::string::String>,
    /// <p>Describes the lifecycle state of the data repository association being deleted.</p>
    pub lifecycle: std::option::Option<crate::model::DataRepositoryLifecycle>,
    /// <p>Indicates whether data in the file system that corresponds to the data repository association is being deleted. Default is <code>false</code>.</p>
    pub delete_data_in_file_system: std::option::Option<bool>,
}
impl DeleteDataRepositoryAssociationOutput {
    /// <p>The ID of the data repository association being deleted.</p>
    pub fn association_id(&self) -> std::option::Option<&str> {
        self.association_id.as_deref()
    }
    /// <p>Describes the lifecycle state of the data repository association being deleted.</p>
    pub fn lifecycle(&self) -> std::option::Option<&crate::model::DataRepositoryLifecycle> {
        self.lifecycle.as_ref()
    }
    /// <p>Indicates whether data in the file system that corresponds to the data repository association is being deleted. Default is <code>false</code>.</p>
    pub fn delete_data_in_file_system(&self) -> std::option::Option<bool> {
        self.delete_data_in_file_system
    }
}
impl std::fmt::Debug for DeleteDataRepositoryAssociationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDataRepositoryAssociationOutput");
        formatter.field("association_id", &self.association_id);
        formatter.field("lifecycle", &self.lifecycle);
        formatter.field(
            "delete_data_in_file_system",
            &self.delete_data_in_file_system,
        );
        formatter.finish()
    }
}
/// See [`DeleteDataRepositoryAssociationOutput`](crate::output::DeleteDataRepositoryAssociationOutput)
pub mod delete_data_repository_association_output {
    /// A builder for [`DeleteDataRepositoryAssociationOutput`](crate::output::DeleteDataRepositoryAssociationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) association_id: std::option::Option<std::string::String>,
        pub(crate) lifecycle: std::option::Option<crate::model::DataRepositoryLifecycle>,
        pub(crate) delete_data_in_file_system: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the data repository association being deleted.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_id = Some(input.into());
            self
        }
        /// <p>The ID of the data repository association being deleted.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_id = input;
            self
        }
        /// <p>Describes the lifecycle state of the data repository association being deleted.</p>
        pub fn lifecycle(mut self, input: crate::model::DataRepositoryLifecycle) -> Self {
            self.lifecycle = Some(input);
            self
        }
        /// <p>Describes the lifecycle state of the data repository association being deleted.</p>
        pub fn set_lifecycle(
            mut self,
            input: std::option::Option<crate::model::DataRepositoryLifecycle>,
        ) -> Self {
            self.lifecycle = input;
            self
        }
        /// <p>Indicates whether data in the file system that corresponds to the data repository association is being deleted. Default is <code>false</code>.</p>
        pub fn delete_data_in_file_system(mut self, input: bool) -> Self {
            self.delete_data_in_file_system = Some(input);
            self
        }
        /// <p>Indicates whether data in the file system that corresponds to the data repository association is being deleted. Default is <code>false</code>.</p>
        pub fn set_delete_data_in_file_system(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_data_in_file_system = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDataRepositoryAssociationOutput`](crate::output::DeleteDataRepositoryAssociationOutput)
        pub fn build(self) -> crate::output::DeleteDataRepositoryAssociationOutput {
            crate::output::DeleteDataRepositoryAssociationOutput {
                association_id: self.association_id,
                lifecycle: self.lifecycle,
                delete_data_in_file_system: self.delete_data_in_file_system,
            }
        }
    }
}
impl DeleteDataRepositoryAssociationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDataRepositoryAssociationOutput`](crate::output::DeleteDataRepositoryAssociationOutput)
    pub fn builder() -> crate::output::delete_data_repository_association_output::Builder {
        crate::output::delete_data_repository_association_output::Builder::default()
    }
}

/// <p>The response object for the <code>DeleteBackup</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBackupOutput {
    /// <p>The ID of the backup that was deleted.</p>
    pub backup_id: std::option::Option<std::string::String>,
    /// <p>The lifecycle status of the backup. If the <code>DeleteBackup</code> operation is successful, the status is <code>DELETED</code>.</p>
    pub lifecycle: std::option::Option<crate::model::BackupLifecycle>,
}
impl DeleteBackupOutput {
    /// <p>The ID of the backup that was deleted.</p>
    pub fn backup_id(&self) -> std::option::Option<&str> {
        self.backup_id.as_deref()
    }
    /// <p>The lifecycle status of the backup. If the <code>DeleteBackup</code> operation is successful, the status is <code>DELETED</code>.</p>
    pub fn lifecycle(&self) -> std::option::Option<&crate::model::BackupLifecycle> {
        self.lifecycle.as_ref()
    }
}
impl std::fmt::Debug for DeleteBackupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBackupOutput");
        formatter.field("backup_id", &self.backup_id);
        formatter.field("lifecycle", &self.lifecycle);
        formatter.finish()
    }
}
/// See [`DeleteBackupOutput`](crate::output::DeleteBackupOutput)
pub mod delete_backup_output {
    /// A builder for [`DeleteBackupOutput`](crate::output::DeleteBackupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_id: std::option::Option<std::string::String>,
        pub(crate) lifecycle: std::option::Option<crate::model::BackupLifecycle>,
    }
    impl Builder {
        /// <p>The ID of the backup that was deleted.</p>
        pub fn backup_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_id = Some(input.into());
            self
        }
        /// <p>The ID of the backup that was deleted.</p>
        pub fn set_backup_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.backup_id = input;
            self
        }
        /// <p>The lifecycle status of the backup. If the <code>DeleteBackup</code> operation is successful, the status is <code>DELETED</code>.</p>
        pub fn lifecycle(mut self, input: crate::model::BackupLifecycle) -> Self {
            self.lifecycle = Some(input);
            self
        }
        /// <p>The lifecycle status of the backup. If the <code>DeleteBackup</code> operation is successful, the status is <code>DELETED</code>.</p>
        pub fn set_lifecycle(
            mut self,
            input: std::option::Option<crate::model::BackupLifecycle>,
        ) -> Self {
            self.lifecycle = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBackupOutput`](crate::output::DeleteBackupOutput)
        pub fn build(self) -> crate::output::DeleteBackupOutput {
            crate::output::DeleteBackupOutput {
                backup_id: self.backup_id,
                lifecycle: self.lifecycle,
            }
        }
    }
}
impl DeleteBackupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBackupOutput`](crate::output::DeleteBackupOutput)
    pub fn builder() -> crate::output::delete_backup_output::Builder {
        crate::output::delete_backup_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateVolumeFromBackupOutput {
    /// <p>Returned after a successful <code>CreateVolumeFromBackup</code> API operation, describing the volume just created.</p>
    pub volume: std::option::Option<crate::model::Volume>,
}
impl CreateVolumeFromBackupOutput {
    /// <p>Returned after a successful <code>CreateVolumeFromBackup</code> API operation, describing the volume just created.</p>
    pub fn volume(&self) -> std::option::Option<&crate::model::Volume> {
        self.volume.as_ref()
    }
}
impl std::fmt::Debug for CreateVolumeFromBackupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateVolumeFromBackupOutput");
        formatter.field("volume", &self.volume);
        formatter.finish()
    }
}
/// See [`CreateVolumeFromBackupOutput`](crate::output::CreateVolumeFromBackupOutput)
pub mod create_volume_from_backup_output {
    /// A builder for [`CreateVolumeFromBackupOutput`](crate::output::CreateVolumeFromBackupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume: std::option::Option<crate::model::Volume>,
    }
    impl Builder {
        /// <p>Returned after a successful <code>CreateVolumeFromBackup</code> API operation, describing the volume just created.</p>
        pub fn volume(mut self, input: crate::model::Volume) -> Self {
            self.volume = Some(input);
            self
        }
        /// <p>Returned after a successful <code>CreateVolumeFromBackup</code> API operation, describing the volume just created.</p>
        pub fn set_volume(mut self, input: std::option::Option<crate::model::Volume>) -> Self {
            self.volume = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateVolumeFromBackupOutput`](crate::output::CreateVolumeFromBackupOutput)
        pub fn build(self) -> crate::output::CreateVolumeFromBackupOutput {
            crate::output::CreateVolumeFromBackupOutput {
                volume: self.volume,
            }
        }
    }
}
impl CreateVolumeFromBackupOutput {
    /// Creates a new builder-style object to manufacture [`CreateVolumeFromBackupOutput`](crate::output::CreateVolumeFromBackupOutput)
    pub fn builder() -> crate::output::create_volume_from_backup_output::Builder {
        crate::output::create_volume_from_backup_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateVolumeOutput {
    /// <p>Returned after a successful <code>CreateVolume</code> API operation, describing the volume just created.</p>
    pub volume: std::option::Option<crate::model::Volume>,
}
impl CreateVolumeOutput {
    /// <p>Returned after a successful <code>CreateVolume</code> API operation, describing the volume just created.</p>
    pub fn volume(&self) -> std::option::Option<&crate::model::Volume> {
        self.volume.as_ref()
    }
}
impl std::fmt::Debug for CreateVolumeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateVolumeOutput");
        formatter.field("volume", &self.volume);
        formatter.finish()
    }
}
/// See [`CreateVolumeOutput`](crate::output::CreateVolumeOutput)
pub mod create_volume_output {
    /// A builder for [`CreateVolumeOutput`](crate::output::CreateVolumeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume: std::option::Option<crate::model::Volume>,
    }
    impl Builder {
        /// <p>Returned after a successful <code>CreateVolume</code> API operation, describing the volume just created.</p>
        pub fn volume(mut self, input: crate::model::Volume) -> Self {
            self.volume = Some(input);
            self
        }
        /// <p>Returned after a successful <code>CreateVolume</code> API operation, describing the volume just created.</p>
        pub fn set_volume(mut self, input: std::option::Option<crate::model::Volume>) -> Self {
            self.volume = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateVolumeOutput`](crate::output::CreateVolumeOutput)
        pub fn build(self) -> crate::output::CreateVolumeOutput {
            crate::output::CreateVolumeOutput {
                volume: self.volume,
            }
        }
    }
}
impl CreateVolumeOutput {
    /// Creates a new builder-style object to manufacture [`CreateVolumeOutput`](crate::output::CreateVolumeOutput)
    pub fn builder() -> crate::output::create_volume_output::Builder {
        crate::output::create_volume_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateStorageVirtualMachineOutput {
    /// <p>Returned after a successful <code>CreateStorageVirtualMachine</code> operation; describes the SVM just created.</p>
    pub storage_virtual_machine: std::option::Option<crate::model::StorageVirtualMachine>,
}
impl CreateStorageVirtualMachineOutput {
    /// <p>Returned after a successful <code>CreateStorageVirtualMachine</code> operation; describes the SVM just created.</p>
    pub fn storage_virtual_machine(
        &self,
    ) -> std::option::Option<&crate::model::StorageVirtualMachine> {
        self.storage_virtual_machine.as_ref()
    }
}
impl std::fmt::Debug for CreateStorageVirtualMachineOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateStorageVirtualMachineOutput");
        formatter.field("storage_virtual_machine", &self.storage_virtual_machine);
        formatter.finish()
    }
}
/// See [`CreateStorageVirtualMachineOutput`](crate::output::CreateStorageVirtualMachineOutput)
pub mod create_storage_virtual_machine_output {
    /// A builder for [`CreateStorageVirtualMachineOutput`](crate::output::CreateStorageVirtualMachineOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) storage_virtual_machine:
            std::option::Option<crate::model::StorageVirtualMachine>,
    }
    impl Builder {
        /// <p>Returned after a successful <code>CreateStorageVirtualMachine</code> operation; describes the SVM just created.</p>
        pub fn storage_virtual_machine(
            mut self,
            input: crate::model::StorageVirtualMachine,
        ) -> Self {
            self.storage_virtual_machine = Some(input);
            self
        }
        /// <p>Returned after a successful <code>CreateStorageVirtualMachine</code> operation; describes the SVM just created.</p>
        pub fn set_storage_virtual_machine(
            mut self,
            input: std::option::Option<crate::model::StorageVirtualMachine>,
        ) -> Self {
            self.storage_virtual_machine = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStorageVirtualMachineOutput`](crate::output::CreateStorageVirtualMachineOutput)
        pub fn build(self) -> crate::output::CreateStorageVirtualMachineOutput {
            crate::output::CreateStorageVirtualMachineOutput {
                storage_virtual_machine: self.storage_virtual_machine,
            }
        }
    }
}
impl CreateStorageVirtualMachineOutput {
    /// Creates a new builder-style object to manufacture [`CreateStorageVirtualMachineOutput`](crate::output::CreateStorageVirtualMachineOutput)
    pub fn builder() -> crate::output::create_storage_virtual_machine_output::Builder {
        crate::output::create_storage_virtual_machine_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSnapshotOutput {
    /// <p>A description of the snapshot.</p>
    pub snapshot: std::option::Option<crate::model::Snapshot>,
}
impl CreateSnapshotOutput {
    /// <p>A description of the snapshot.</p>
    pub fn snapshot(&self) -> std::option::Option<&crate::model::Snapshot> {
        self.snapshot.as_ref()
    }
}
impl std::fmt::Debug for CreateSnapshotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSnapshotOutput");
        formatter.field("snapshot", &self.snapshot);
        formatter.finish()
    }
}
/// See [`CreateSnapshotOutput`](crate::output::CreateSnapshotOutput)
pub mod create_snapshot_output {
    /// A builder for [`CreateSnapshotOutput`](crate::output::CreateSnapshotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot: std::option::Option<crate::model::Snapshot>,
    }
    impl Builder {
        /// <p>A description of the snapshot.</p>
        pub fn snapshot(mut self, input: crate::model::Snapshot) -> Self {
            self.snapshot = Some(input);
            self
        }
        /// <p>A description of the snapshot.</p>
        pub fn set_snapshot(mut self, input: std::option::Option<crate::model::Snapshot>) -> Self {
            self.snapshot = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSnapshotOutput`](crate::output::CreateSnapshotOutput)
        pub fn build(self) -> crate::output::CreateSnapshotOutput {
            crate::output::CreateSnapshotOutput {
                snapshot: self.snapshot,
            }
        }
    }
}
impl CreateSnapshotOutput {
    /// Creates a new builder-style object to manufacture [`CreateSnapshotOutput`](crate::output::CreateSnapshotOutput)
    pub fn builder() -> crate::output::create_snapshot_output::Builder {
        crate::output::create_snapshot_output::Builder::default()
    }
}

/// <p>The response object for the <code>CreateFileSystemFromBackup</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFileSystemFromBackupOutput {
    /// <p>A description of the file system.</p>
    pub file_system: std::option::Option<crate::model::FileSystem>,
}
impl CreateFileSystemFromBackupOutput {
    /// <p>A description of the file system.</p>
    pub fn file_system(&self) -> std::option::Option<&crate::model::FileSystem> {
        self.file_system.as_ref()
    }
}
impl std::fmt::Debug for CreateFileSystemFromBackupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFileSystemFromBackupOutput");
        formatter.field("file_system", &self.file_system);
        formatter.finish()
    }
}
/// See [`CreateFileSystemFromBackupOutput`](crate::output::CreateFileSystemFromBackupOutput)
pub mod create_file_system_from_backup_output {
    /// A builder for [`CreateFileSystemFromBackupOutput`](crate::output::CreateFileSystemFromBackupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system: std::option::Option<crate::model::FileSystem>,
    }
    impl Builder {
        /// <p>A description of the file system.</p>
        pub fn file_system(mut self, input: crate::model::FileSystem) -> Self {
            self.file_system = Some(input);
            self
        }
        /// <p>A description of the file system.</p>
        pub fn set_file_system(
            mut self,
            input: std::option::Option<crate::model::FileSystem>,
        ) -> Self {
            self.file_system = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFileSystemFromBackupOutput`](crate::output::CreateFileSystemFromBackupOutput)
        pub fn build(self) -> crate::output::CreateFileSystemFromBackupOutput {
            crate::output::CreateFileSystemFromBackupOutput {
                file_system: self.file_system,
            }
        }
    }
}
impl CreateFileSystemFromBackupOutput {
    /// Creates a new builder-style object to manufacture [`CreateFileSystemFromBackupOutput`](crate::output::CreateFileSystemFromBackupOutput)
    pub fn builder() -> crate::output::create_file_system_from_backup_output::Builder {
        crate::output::create_file_system_from_backup_output::Builder::default()
    }
}

/// <p>The response object returned after the file system is created.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFileSystemOutput {
    /// <p>The configuration of the file system that was created.</p>
    pub file_system: std::option::Option<crate::model::FileSystem>,
}
impl CreateFileSystemOutput {
    /// <p>The configuration of the file system that was created.</p>
    pub fn file_system(&self) -> std::option::Option<&crate::model::FileSystem> {
        self.file_system.as_ref()
    }
}
impl std::fmt::Debug for CreateFileSystemOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFileSystemOutput");
        formatter.field("file_system", &self.file_system);
        formatter.finish()
    }
}
/// See [`CreateFileSystemOutput`](crate::output::CreateFileSystemOutput)
pub mod create_file_system_output {
    /// A builder for [`CreateFileSystemOutput`](crate::output::CreateFileSystemOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system: std::option::Option<crate::model::FileSystem>,
    }
    impl Builder {
        /// <p>The configuration of the file system that was created.</p>
        pub fn file_system(mut self, input: crate::model::FileSystem) -> Self {
            self.file_system = Some(input);
            self
        }
        /// <p>The configuration of the file system that was created.</p>
        pub fn set_file_system(
            mut self,
            input: std::option::Option<crate::model::FileSystem>,
        ) -> Self {
            self.file_system = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFileSystemOutput`](crate::output::CreateFileSystemOutput)
        pub fn build(self) -> crate::output::CreateFileSystemOutput {
            crate::output::CreateFileSystemOutput {
                file_system: self.file_system,
            }
        }
    }
}
impl CreateFileSystemOutput {
    /// Creates a new builder-style object to manufacture [`CreateFileSystemOutput`](crate::output::CreateFileSystemOutput)
    pub fn builder() -> crate::output::create_file_system_output::Builder {
        crate::output::create_file_system_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDataRepositoryTaskOutput {
    /// <p>The description of the data repository task that you just created.</p>
    pub data_repository_task: std::option::Option<crate::model::DataRepositoryTask>,
}
impl CreateDataRepositoryTaskOutput {
    /// <p>The description of the data repository task that you just created.</p>
    pub fn data_repository_task(&self) -> std::option::Option<&crate::model::DataRepositoryTask> {
        self.data_repository_task.as_ref()
    }
}
impl std::fmt::Debug for CreateDataRepositoryTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDataRepositoryTaskOutput");
        formatter.field("data_repository_task", &self.data_repository_task);
        formatter.finish()
    }
}
/// See [`CreateDataRepositoryTaskOutput`](crate::output::CreateDataRepositoryTaskOutput)
pub mod create_data_repository_task_output {
    /// A builder for [`CreateDataRepositoryTaskOutput`](crate::output::CreateDataRepositoryTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_repository_task: std::option::Option<crate::model::DataRepositoryTask>,
    }
    impl Builder {
        /// <p>The description of the data repository task that you just created.</p>
        pub fn data_repository_task(mut self, input: crate::model::DataRepositoryTask) -> Self {
            self.data_repository_task = Some(input);
            self
        }
        /// <p>The description of the data repository task that you just created.</p>
        pub fn set_data_repository_task(
            mut self,
            input: std::option::Option<crate::model::DataRepositoryTask>,
        ) -> Self {
            self.data_repository_task = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDataRepositoryTaskOutput`](crate::output::CreateDataRepositoryTaskOutput)
        pub fn build(self) -> crate::output::CreateDataRepositoryTaskOutput {
            crate::output::CreateDataRepositoryTaskOutput {
                data_repository_task: self.data_repository_task,
            }
        }
    }
}
impl CreateDataRepositoryTaskOutput {
    /// Creates a new builder-style object to manufacture [`CreateDataRepositoryTaskOutput`](crate::output::CreateDataRepositoryTaskOutput)
    pub fn builder() -> crate::output::create_data_repository_task_output::Builder {
        crate::output::create_data_repository_task_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDataRepositoryAssociationOutput {
    /// <p>The response object returned after the data repository association is created.</p>
    pub association: std::option::Option<crate::model::DataRepositoryAssociation>,
}
impl CreateDataRepositoryAssociationOutput {
    /// <p>The response object returned after the data repository association is created.</p>
    pub fn association(&self) -> std::option::Option<&crate::model::DataRepositoryAssociation> {
        self.association.as_ref()
    }
}
impl std::fmt::Debug for CreateDataRepositoryAssociationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDataRepositoryAssociationOutput");
        formatter.field("association", &self.association);
        formatter.finish()
    }
}
/// See [`CreateDataRepositoryAssociationOutput`](crate::output::CreateDataRepositoryAssociationOutput)
pub mod create_data_repository_association_output {
    /// A builder for [`CreateDataRepositoryAssociationOutput`](crate::output::CreateDataRepositoryAssociationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) association: std::option::Option<crate::model::DataRepositoryAssociation>,
    }
    impl Builder {
        /// <p>The response object returned after the data repository association is created.</p>
        pub fn association(mut self, input: crate::model::DataRepositoryAssociation) -> Self {
            self.association = Some(input);
            self
        }
        /// <p>The response object returned after the data repository association is created.</p>
        pub fn set_association(
            mut self,
            input: std::option::Option<crate::model::DataRepositoryAssociation>,
        ) -> Self {
            self.association = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDataRepositoryAssociationOutput`](crate::output::CreateDataRepositoryAssociationOutput)
        pub fn build(self) -> crate::output::CreateDataRepositoryAssociationOutput {
            crate::output::CreateDataRepositoryAssociationOutput {
                association: self.association,
            }
        }
    }
}
impl CreateDataRepositoryAssociationOutput {
    /// Creates a new builder-style object to manufacture [`CreateDataRepositoryAssociationOutput`](crate::output::CreateDataRepositoryAssociationOutput)
    pub fn builder() -> crate::output::create_data_repository_association_output::Builder {
        crate::output::create_data_repository_association_output::Builder::default()
    }
}

/// <p>The response object for the <code>CreateBackup</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBackupOutput {
    /// <p>A description of the backup.</p>
    pub backup: std::option::Option<crate::model::Backup>,
}
impl CreateBackupOutput {
    /// <p>A description of the backup.</p>
    pub fn backup(&self) -> std::option::Option<&crate::model::Backup> {
        self.backup.as_ref()
    }
}
impl std::fmt::Debug for CreateBackupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBackupOutput");
        formatter.field("backup", &self.backup);
        formatter.finish()
    }
}
/// See [`CreateBackupOutput`](crate::output::CreateBackupOutput)
pub mod create_backup_output {
    /// A builder for [`CreateBackupOutput`](crate::output::CreateBackupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup: std::option::Option<crate::model::Backup>,
    }
    impl Builder {
        /// <p>A description of the backup.</p>
        pub fn backup(mut self, input: crate::model::Backup) -> Self {
            self.backup = Some(input);
            self
        }
        /// <p>A description of the backup.</p>
        pub fn set_backup(mut self, input: std::option::Option<crate::model::Backup>) -> Self {
            self.backup = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBackupOutput`](crate::output::CreateBackupOutput)
        pub fn build(self) -> crate::output::CreateBackupOutput {
            crate::output::CreateBackupOutput {
                backup: self.backup,
            }
        }
    }
}
impl CreateBackupOutput {
    /// Creates a new builder-style object to manufacture [`CreateBackupOutput`](crate::output::CreateBackupOutput)
    pub fn builder() -> crate::output::create_backup_output::Builder {
        crate::output::create_backup_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CopyBackupOutput {
    /// <p>A backup of an Amazon FSx for Windows File Server, Amazon FSx for Lustre file system, Amazon FSx for NetApp ONTAP volume, or Amazon FSx for OpenZFS file system.</p>
    pub backup: std::option::Option<crate::model::Backup>,
}
impl CopyBackupOutput {
    /// <p>A backup of an Amazon FSx for Windows File Server, Amazon FSx for Lustre file system, Amazon FSx for NetApp ONTAP volume, or Amazon FSx for OpenZFS file system.</p>
    pub fn backup(&self) -> std::option::Option<&crate::model::Backup> {
        self.backup.as_ref()
    }
}
impl std::fmt::Debug for CopyBackupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CopyBackupOutput");
        formatter.field("backup", &self.backup);
        formatter.finish()
    }
}
/// See [`CopyBackupOutput`](crate::output::CopyBackupOutput)
pub mod copy_backup_output {
    /// A builder for [`CopyBackupOutput`](crate::output::CopyBackupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup: std::option::Option<crate::model::Backup>,
    }
    impl Builder {
        /// <p>A backup of an Amazon FSx for Windows File Server, Amazon FSx for Lustre file system, Amazon FSx for NetApp ONTAP volume, or Amazon FSx for OpenZFS file system.</p>
        pub fn backup(mut self, input: crate::model::Backup) -> Self {
            self.backup = Some(input);
            self
        }
        /// <p>A backup of an Amazon FSx for Windows File Server, Amazon FSx for Lustre file system, Amazon FSx for NetApp ONTAP volume, or Amazon FSx for OpenZFS file system.</p>
        pub fn set_backup(mut self, input: std::option::Option<crate::model::Backup>) -> Self {
            self.backup = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyBackupOutput`](crate::output::CopyBackupOutput)
        pub fn build(self) -> crate::output::CopyBackupOutput {
            crate::output::CopyBackupOutput {
                backup: self.backup,
            }
        }
    }
}
impl CopyBackupOutput {
    /// Creates a new builder-style object to manufacture [`CopyBackupOutput`](crate::output::CopyBackupOutput)
    pub fn builder() -> crate::output::copy_backup_output::Builder {
        crate::output::copy_backup_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelDataRepositoryTaskOutput {
    /// <p>The lifecycle status of the data repository task, as follows:</p>
    /// <ul>
    /// <li> <p> <code>PENDING</code> - Amazon FSx has not started the task.</p> </li>
    /// <li> <p> <code>EXECUTING</code> - Amazon FSx is processing the task.</p> </li>
    /// <li> <p> <code>FAILED</code> - Amazon FSx was not able to complete the task. For example, there may be files the task failed to process. The <code>DataRepositoryTaskFailureDetails</code> property provides more information about task failures.</p> </li>
    /// <li> <p> <code>SUCCEEDED</code> - FSx completed the task successfully.</p> </li>
    /// <li> <p> <code>CANCELED</code> - Amazon FSx canceled the task and it did not complete.</p> </li>
    /// <li> <p> <code>CANCELING</code> - FSx is in process of canceling the task.</p> </li>
    /// </ul>
    pub lifecycle: std::option::Option<crate::model::DataRepositoryTaskLifecycle>,
    /// <p>The ID of the task being canceled.</p>
    pub task_id: std::option::Option<std::string::String>,
}
impl CancelDataRepositoryTaskOutput {
    /// <p>The lifecycle status of the data repository task, as follows:</p>
    /// <ul>
    /// <li> <p> <code>PENDING</code> - Amazon FSx has not started the task.</p> </li>
    /// <li> <p> <code>EXECUTING</code> - Amazon FSx is processing the task.</p> </li>
    /// <li> <p> <code>FAILED</code> - Amazon FSx was not able to complete the task. For example, there may be files the task failed to process. The <code>DataRepositoryTaskFailureDetails</code> property provides more information about task failures.</p> </li>
    /// <li> <p> <code>SUCCEEDED</code> - FSx completed the task successfully.</p> </li>
    /// <li> <p> <code>CANCELED</code> - Amazon FSx canceled the task and it did not complete.</p> </li>
    /// <li> <p> <code>CANCELING</code> - FSx is in process of canceling the task.</p> </li>
    /// </ul>
    pub fn lifecycle(&self) -> std::option::Option<&crate::model::DataRepositoryTaskLifecycle> {
        self.lifecycle.as_ref()
    }
    /// <p>The ID of the task being canceled.</p>
    pub fn task_id(&self) -> std::option::Option<&str> {
        self.task_id.as_deref()
    }
}
impl std::fmt::Debug for CancelDataRepositoryTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelDataRepositoryTaskOutput");
        formatter.field("lifecycle", &self.lifecycle);
        formatter.field("task_id", &self.task_id);
        formatter.finish()
    }
}
/// See [`CancelDataRepositoryTaskOutput`](crate::output::CancelDataRepositoryTaskOutput)
pub mod cancel_data_repository_task_output {
    /// A builder for [`CancelDataRepositoryTaskOutput`](crate::output::CancelDataRepositoryTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lifecycle: std::option::Option<crate::model::DataRepositoryTaskLifecycle>,
        pub(crate) task_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The lifecycle status of the data repository task, as follows:</p>
        /// <ul>
        /// <li> <p> <code>PENDING</code> - Amazon FSx has not started the task.</p> </li>
        /// <li> <p> <code>EXECUTING</code> - Amazon FSx is processing the task.</p> </li>
        /// <li> <p> <code>FAILED</code> - Amazon FSx was not able to complete the task. For example, there may be files the task failed to process. The <code>DataRepositoryTaskFailureDetails</code> property provides more information about task failures.</p> </li>
        /// <li> <p> <code>SUCCEEDED</code> - FSx completed the task successfully.</p> </li>
        /// <li> <p> <code>CANCELED</code> - Amazon FSx canceled the task and it did not complete.</p> </li>
        /// <li> <p> <code>CANCELING</code> - FSx is in process of canceling the task.</p> </li>
        /// </ul>
        pub fn lifecycle(mut self, input: crate::model::DataRepositoryTaskLifecycle) -> Self {
            self.lifecycle = Some(input);
            self
        }
        /// <p>The lifecycle status of the data repository task, as follows:</p>
        /// <ul>
        /// <li> <p> <code>PENDING</code> - Amazon FSx has not started the task.</p> </li>
        /// <li> <p> <code>EXECUTING</code> - Amazon FSx is processing the task.</p> </li>
        /// <li> <p> <code>FAILED</code> - Amazon FSx was not able to complete the task. For example, there may be files the task failed to process. The <code>DataRepositoryTaskFailureDetails</code> property provides more information about task failures.</p> </li>
        /// <li> <p> <code>SUCCEEDED</code> - FSx completed the task successfully.</p> </li>
        /// <li> <p> <code>CANCELED</code> - Amazon FSx canceled the task and it did not complete.</p> </li>
        /// <li> <p> <code>CANCELING</code> - FSx is in process of canceling the task.</p> </li>
        /// </ul>
        pub fn set_lifecycle(
            mut self,
            input: std::option::Option<crate::model::DataRepositoryTaskLifecycle>,
        ) -> Self {
            self.lifecycle = input;
            self
        }
        /// <p>The ID of the task being canceled.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_id = Some(input.into());
            self
        }
        /// <p>The ID of the task being canceled.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelDataRepositoryTaskOutput`](crate::output::CancelDataRepositoryTaskOutput)
        pub fn build(self) -> crate::output::CancelDataRepositoryTaskOutput {
            crate::output::CancelDataRepositoryTaskOutput {
                lifecycle: self.lifecycle,
                task_id: self.task_id,
            }
        }
    }
}
impl CancelDataRepositoryTaskOutput {
    /// Creates a new builder-style object to manufacture [`CancelDataRepositoryTaskOutput`](crate::output::CancelDataRepositoryTaskOutput)
    pub fn builder() -> crate::output::cancel_data_repository_task_output::Builder {
        crate::output::cancel_data_repository_task_output::Builder::default()
    }
}

/// <p>The system generated response showing the DNS aliases that Amazon FSx is attempting to associate with the file system. Use the API operation to monitor the status of the aliases Amazon FSx is associating with the file system. It can take up to 2.5 minutes for the alias status to change from <code>CREATING</code> to <code>AVAILABLE</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateFileSystemAliasesOutput {
    /// <p>An array of the DNS aliases that Amazon FSx is associating with the file system.</p>
    pub aliases: std::option::Option<std::vec::Vec<crate::model::Alias>>,
}
impl AssociateFileSystemAliasesOutput {
    /// <p>An array of the DNS aliases that Amazon FSx is associating with the file system.</p>
    pub fn aliases(&self) -> std::option::Option<&[crate::model::Alias]> {
        self.aliases.as_deref()
    }
}
impl std::fmt::Debug for AssociateFileSystemAliasesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateFileSystemAliasesOutput");
        formatter.field("aliases", &self.aliases);
        formatter.finish()
    }
}
/// See [`AssociateFileSystemAliasesOutput`](crate::output::AssociateFileSystemAliasesOutput)
pub mod associate_file_system_aliases_output {
    /// A builder for [`AssociateFileSystemAliasesOutput`](crate::output::AssociateFileSystemAliasesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aliases: std::option::Option<std::vec::Vec<crate::model::Alias>>,
    }
    impl Builder {
        /// Appends an item to `aliases`.
        ///
        /// To override the contents of this collection use [`set_aliases`](Self::set_aliases).
        ///
        /// <p>An array of the DNS aliases that Amazon FSx is associating with the file system.</p>
        pub fn aliases(mut self, input: crate::model::Alias) -> Self {
            let mut v = self.aliases.unwrap_or_default();
            v.push(input);
            self.aliases = Some(v);
            self
        }
        /// <p>An array of the DNS aliases that Amazon FSx is associating with the file system.</p>
        pub fn set_aliases(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Alias>>,
        ) -> Self {
            self.aliases = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateFileSystemAliasesOutput`](crate::output::AssociateFileSystemAliasesOutput)
        pub fn build(self) -> crate::output::AssociateFileSystemAliasesOutput {
            crate::output::AssociateFileSystemAliasesOutput {
                aliases: self.aliases,
            }
        }
    }
}
impl AssociateFileSystemAliasesOutput {
    /// Creates a new builder-style object to manufacture [`AssociateFileSystemAliasesOutput`](crate::output::AssociateFileSystemAliasesOutput)
    pub fn builder() -> crate::output::associate_file_system_aliases_output::Builder {
        crate::output::associate_file_system_aliases_output::Builder::default()
    }
}
