// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociateFileSystemAliases`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_file_system_aliases`](crate::client::Client::associate_file_system_aliases).
///
/// See [`crate::client::fluent_builders::AssociateFileSystemAliases`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateFileSystemAliases {
    _private: (),
}
impl AssociateFileSystemAliases {
    /// Creates a new builder-style object to manufacture [`AssociateFileSystemAliasesInput`](crate::input::AssociateFileSystemAliasesInput)
    pub fn builder() -> crate::input::associate_file_system_aliases_input::Builder {
        crate::input::associate_file_system_aliases_input::Builder::default()
    }
    /// Creates a new `AssociateFileSystemAliases` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateFileSystemAliases {
    type Output = std::result::Result<
        crate::output::AssociateFileSystemAliasesOutput,
        crate::error::AssociateFileSystemAliasesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_file_system_aliases_error(response)
        } else {
            crate::operation_deser::parse_associate_file_system_aliases_response(response)
        }
    }
}

/// Operation shape for `CancelDataRepositoryTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_data_repository_task`](crate::client::Client::cancel_data_repository_task).
///
/// See [`crate::client::fluent_builders::CancelDataRepositoryTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelDataRepositoryTask {
    _private: (),
}
impl CancelDataRepositoryTask {
    /// Creates a new builder-style object to manufacture [`CancelDataRepositoryTaskInput`](crate::input::CancelDataRepositoryTaskInput)
    pub fn builder() -> crate::input::cancel_data_repository_task_input::Builder {
        crate::input::cancel_data_repository_task_input::Builder::default()
    }
    /// Creates a new `CancelDataRepositoryTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelDataRepositoryTask {
    type Output = std::result::Result<
        crate::output::CancelDataRepositoryTaskOutput,
        crate::error::CancelDataRepositoryTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_data_repository_task_error(response)
        } else {
            crate::operation_deser::parse_cancel_data_repository_task_response(response)
        }
    }
}

/// Operation shape for `CopyBackup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`copy_backup`](crate::client::Client::copy_backup).
///
/// See [`crate::client::fluent_builders::CopyBackup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CopyBackup {
    _private: (),
}
impl CopyBackup {
    /// Creates a new builder-style object to manufacture [`CopyBackupInput`](crate::input::CopyBackupInput)
    pub fn builder() -> crate::input::copy_backup_input::Builder {
        crate::input::copy_backup_input::Builder::default()
    }
    /// Creates a new `CopyBackup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CopyBackup {
    type Output =
        std::result::Result<crate::output::CopyBackupOutput, crate::error::CopyBackupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_copy_backup_error(response)
        } else {
            crate::operation_deser::parse_copy_backup_response(response)
        }
    }
}

/// Operation shape for `CreateBackup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_backup`](crate::client::Client::create_backup).
///
/// See [`crate::client::fluent_builders::CreateBackup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateBackup {
    _private: (),
}
impl CreateBackup {
    /// Creates a new builder-style object to manufacture [`CreateBackupInput`](crate::input::CreateBackupInput)
    pub fn builder() -> crate::input::create_backup_input::Builder {
        crate::input::create_backup_input::Builder::default()
    }
    /// Creates a new `CreateBackup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateBackup {
    type Output =
        std::result::Result<crate::output::CreateBackupOutput, crate::error::CreateBackupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_backup_error(response)
        } else {
            crate::operation_deser::parse_create_backup_response(response)
        }
    }
}

/// Operation shape for `CreateDataRepositoryTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_data_repository_task`](crate::client::Client::create_data_repository_task).
///
/// See [`crate::client::fluent_builders::CreateDataRepositoryTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDataRepositoryTask {
    _private: (),
}
impl CreateDataRepositoryTask {
    /// Creates a new builder-style object to manufacture [`CreateDataRepositoryTaskInput`](crate::input::CreateDataRepositoryTaskInput)
    pub fn builder() -> crate::input::create_data_repository_task_input::Builder {
        crate::input::create_data_repository_task_input::Builder::default()
    }
    /// Creates a new `CreateDataRepositoryTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDataRepositoryTask {
    type Output = std::result::Result<
        crate::output::CreateDataRepositoryTaskOutput,
        crate::error::CreateDataRepositoryTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_data_repository_task_error(response)
        } else {
            crate::operation_deser::parse_create_data_repository_task_response(response)
        }
    }
}

/// Operation shape for `CreateFileSystem`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_file_system`](crate::client::Client::create_file_system).
///
/// See [`crate::client::fluent_builders::CreateFileSystem`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFileSystem {
    _private: (),
}
impl CreateFileSystem {
    /// Creates a new builder-style object to manufacture [`CreateFileSystemInput`](crate::input::CreateFileSystemInput)
    pub fn builder() -> crate::input::create_file_system_input::Builder {
        crate::input::create_file_system_input::Builder::default()
    }
    /// Creates a new `CreateFileSystem` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFileSystem {
    type Output = std::result::Result<
        crate::output::CreateFileSystemOutput,
        crate::error::CreateFileSystemError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_file_system_error(response)
        } else {
            crate::operation_deser::parse_create_file_system_response(response)
        }
    }
}

/// Operation shape for `CreateFileSystemFromBackup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_file_system_from_backup`](crate::client::Client::create_file_system_from_backup).
///
/// See [`crate::client::fluent_builders::CreateFileSystemFromBackup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFileSystemFromBackup {
    _private: (),
}
impl CreateFileSystemFromBackup {
    /// Creates a new builder-style object to manufacture [`CreateFileSystemFromBackupInput`](crate::input::CreateFileSystemFromBackupInput)
    pub fn builder() -> crate::input::create_file_system_from_backup_input::Builder {
        crate::input::create_file_system_from_backup_input::Builder::default()
    }
    /// Creates a new `CreateFileSystemFromBackup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFileSystemFromBackup {
    type Output = std::result::Result<
        crate::output::CreateFileSystemFromBackupOutput,
        crate::error::CreateFileSystemFromBackupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_file_system_from_backup_error(response)
        } else {
            crate::operation_deser::parse_create_file_system_from_backup_response(response)
        }
    }
}

/// Operation shape for `CreateStorageVirtualMachine`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_storage_virtual_machine`](crate::client::Client::create_storage_virtual_machine).
///
/// See [`crate::client::fluent_builders::CreateStorageVirtualMachine`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateStorageVirtualMachine {
    _private: (),
}
impl CreateStorageVirtualMachine {
    /// Creates a new builder-style object to manufacture [`CreateStorageVirtualMachineInput`](crate::input::CreateStorageVirtualMachineInput)
    pub fn builder() -> crate::input::create_storage_virtual_machine_input::Builder {
        crate::input::create_storage_virtual_machine_input::Builder::default()
    }
    /// Creates a new `CreateStorageVirtualMachine` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateStorageVirtualMachine {
    type Output = std::result::Result<
        crate::output::CreateStorageVirtualMachineOutput,
        crate::error::CreateStorageVirtualMachineError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_storage_virtual_machine_error(response)
        } else {
            crate::operation_deser::parse_create_storage_virtual_machine_response(response)
        }
    }
}

/// Operation shape for `CreateVolume`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_volume`](crate::client::Client::create_volume).
///
/// See [`crate::client::fluent_builders::CreateVolume`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateVolume {
    _private: (),
}
impl CreateVolume {
    /// Creates a new builder-style object to manufacture [`CreateVolumeInput`](crate::input::CreateVolumeInput)
    pub fn builder() -> crate::input::create_volume_input::Builder {
        crate::input::create_volume_input::Builder::default()
    }
    /// Creates a new `CreateVolume` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateVolume {
    type Output =
        std::result::Result<crate::output::CreateVolumeOutput, crate::error::CreateVolumeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_volume_error(response)
        } else {
            crate::operation_deser::parse_create_volume_response(response)
        }
    }
}

/// Operation shape for `CreateVolumeFromBackup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_volume_from_backup`](crate::client::Client::create_volume_from_backup).
///
/// See [`crate::client::fluent_builders::CreateVolumeFromBackup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateVolumeFromBackup {
    _private: (),
}
impl CreateVolumeFromBackup {
    /// Creates a new builder-style object to manufacture [`CreateVolumeFromBackupInput`](crate::input::CreateVolumeFromBackupInput)
    pub fn builder() -> crate::input::create_volume_from_backup_input::Builder {
        crate::input::create_volume_from_backup_input::Builder::default()
    }
    /// Creates a new `CreateVolumeFromBackup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateVolumeFromBackup {
    type Output = std::result::Result<
        crate::output::CreateVolumeFromBackupOutput,
        crate::error::CreateVolumeFromBackupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_volume_from_backup_error(response)
        } else {
            crate::operation_deser::parse_create_volume_from_backup_response(response)
        }
    }
}

/// Operation shape for `DeleteBackup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_backup`](crate::client::Client::delete_backup).
///
/// See [`crate::client::fluent_builders::DeleteBackup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBackup {
    _private: (),
}
impl DeleteBackup {
    /// Creates a new builder-style object to manufacture [`DeleteBackupInput`](crate::input::DeleteBackupInput)
    pub fn builder() -> crate::input::delete_backup_input::Builder {
        crate::input::delete_backup_input::Builder::default()
    }
    /// Creates a new `DeleteBackup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBackup {
    type Output =
        std::result::Result<crate::output::DeleteBackupOutput, crate::error::DeleteBackupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_backup_error(response)
        } else {
            crate::operation_deser::parse_delete_backup_response(response)
        }
    }
}

/// Operation shape for `DeleteFileSystem`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_file_system`](crate::client::Client::delete_file_system).
///
/// See [`crate::client::fluent_builders::DeleteFileSystem`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFileSystem {
    _private: (),
}
impl DeleteFileSystem {
    /// Creates a new builder-style object to manufacture [`DeleteFileSystemInput`](crate::input::DeleteFileSystemInput)
    pub fn builder() -> crate::input::delete_file_system_input::Builder {
        crate::input::delete_file_system_input::Builder::default()
    }
    /// Creates a new `DeleteFileSystem` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFileSystem {
    type Output = std::result::Result<
        crate::output::DeleteFileSystemOutput,
        crate::error::DeleteFileSystemError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_file_system_error(response)
        } else {
            crate::operation_deser::parse_delete_file_system_response(response)
        }
    }
}

/// Operation shape for `DeleteStorageVirtualMachine`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_storage_virtual_machine`](crate::client::Client::delete_storage_virtual_machine).
///
/// See [`crate::client::fluent_builders::DeleteStorageVirtualMachine`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteStorageVirtualMachine {
    _private: (),
}
impl DeleteStorageVirtualMachine {
    /// Creates a new builder-style object to manufacture [`DeleteStorageVirtualMachineInput`](crate::input::DeleteStorageVirtualMachineInput)
    pub fn builder() -> crate::input::delete_storage_virtual_machine_input::Builder {
        crate::input::delete_storage_virtual_machine_input::Builder::default()
    }
    /// Creates a new `DeleteStorageVirtualMachine` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteStorageVirtualMachine {
    type Output = std::result::Result<
        crate::output::DeleteStorageVirtualMachineOutput,
        crate::error::DeleteStorageVirtualMachineError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_storage_virtual_machine_error(response)
        } else {
            crate::operation_deser::parse_delete_storage_virtual_machine_response(response)
        }
    }
}

/// Operation shape for `DeleteVolume`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_volume`](crate::client::Client::delete_volume).
///
/// See [`crate::client::fluent_builders::DeleteVolume`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVolume {
    _private: (),
}
impl DeleteVolume {
    /// Creates a new builder-style object to manufacture [`DeleteVolumeInput`](crate::input::DeleteVolumeInput)
    pub fn builder() -> crate::input::delete_volume_input::Builder {
        crate::input::delete_volume_input::Builder::default()
    }
    /// Creates a new `DeleteVolume` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVolume {
    type Output =
        std::result::Result<crate::output::DeleteVolumeOutput, crate::error::DeleteVolumeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_volume_error(response)
        } else {
            crate::operation_deser::parse_delete_volume_response(response)
        }
    }
}

/// Operation shape for `DescribeBackups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_backups`](crate::client::Client::describe_backups).
///
/// See [`crate::client::fluent_builders::DescribeBackups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeBackups {
    _private: (),
}
impl DescribeBackups {
    /// Creates a new builder-style object to manufacture [`DescribeBackupsInput`](crate::input::DescribeBackupsInput)
    pub fn builder() -> crate::input::describe_backups_input::Builder {
        crate::input::describe_backups_input::Builder::default()
    }
    /// Creates a new `DescribeBackups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeBackups {
    type Output = std::result::Result<
        crate::output::DescribeBackupsOutput,
        crate::error::DescribeBackupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_backups_error(response)
        } else {
            crate::operation_deser::parse_describe_backups_response(response)
        }
    }
}

/// Operation shape for `DescribeDataRepositoryTasks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_data_repository_tasks`](crate::client::Client::describe_data_repository_tasks).
///
/// See [`crate::client::fluent_builders::DescribeDataRepositoryTasks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDataRepositoryTasks {
    _private: (),
}
impl DescribeDataRepositoryTasks {
    /// Creates a new builder-style object to manufacture [`DescribeDataRepositoryTasksInput`](crate::input::DescribeDataRepositoryTasksInput)
    pub fn builder() -> crate::input::describe_data_repository_tasks_input::Builder {
        crate::input::describe_data_repository_tasks_input::Builder::default()
    }
    /// Creates a new `DescribeDataRepositoryTasks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDataRepositoryTasks {
    type Output = std::result::Result<
        crate::output::DescribeDataRepositoryTasksOutput,
        crate::error::DescribeDataRepositoryTasksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_data_repository_tasks_error(response)
        } else {
            crate::operation_deser::parse_describe_data_repository_tasks_response(response)
        }
    }
}

/// Operation shape for `DescribeFileSystemAliases`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_file_system_aliases`](crate::client::Client::describe_file_system_aliases).
///
/// See [`crate::client::fluent_builders::DescribeFileSystemAliases`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFileSystemAliases {
    _private: (),
}
impl DescribeFileSystemAliases {
    /// Creates a new builder-style object to manufacture [`DescribeFileSystemAliasesInput`](crate::input::DescribeFileSystemAliasesInput)
    pub fn builder() -> crate::input::describe_file_system_aliases_input::Builder {
        crate::input::describe_file_system_aliases_input::Builder::default()
    }
    /// Creates a new `DescribeFileSystemAliases` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFileSystemAliases {
    type Output = std::result::Result<
        crate::output::DescribeFileSystemAliasesOutput,
        crate::error::DescribeFileSystemAliasesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_file_system_aliases_error(response)
        } else {
            crate::operation_deser::parse_describe_file_system_aliases_response(response)
        }
    }
}

/// Operation shape for `DescribeFileSystems`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_file_systems`](crate::client::Client::describe_file_systems).
///
/// See [`crate::client::fluent_builders::DescribeFileSystems`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFileSystems {
    _private: (),
}
impl DescribeFileSystems {
    /// Creates a new builder-style object to manufacture [`DescribeFileSystemsInput`](crate::input::DescribeFileSystemsInput)
    pub fn builder() -> crate::input::describe_file_systems_input::Builder {
        crate::input::describe_file_systems_input::Builder::default()
    }
    /// Creates a new `DescribeFileSystems` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFileSystems {
    type Output = std::result::Result<
        crate::output::DescribeFileSystemsOutput,
        crate::error::DescribeFileSystemsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_file_systems_error(response)
        } else {
            crate::operation_deser::parse_describe_file_systems_response(response)
        }
    }
}

/// Operation shape for `DescribeStorageVirtualMachines`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_storage_virtual_machines`](crate::client::Client::describe_storage_virtual_machines).
///
/// See [`crate::client::fluent_builders::DescribeStorageVirtualMachines`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeStorageVirtualMachines {
    _private: (),
}
impl DescribeStorageVirtualMachines {
    /// Creates a new builder-style object to manufacture [`DescribeStorageVirtualMachinesInput`](crate::input::DescribeStorageVirtualMachinesInput)
    pub fn builder() -> crate::input::describe_storage_virtual_machines_input::Builder {
        crate::input::describe_storage_virtual_machines_input::Builder::default()
    }
    /// Creates a new `DescribeStorageVirtualMachines` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeStorageVirtualMachines {
    type Output = std::result::Result<
        crate::output::DescribeStorageVirtualMachinesOutput,
        crate::error::DescribeStorageVirtualMachinesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_storage_virtual_machines_error(response)
        } else {
            crate::operation_deser::parse_describe_storage_virtual_machines_response(response)
        }
    }
}

/// Operation shape for `DescribeVolumes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_volumes`](crate::client::Client::describe_volumes).
///
/// See [`crate::client::fluent_builders::DescribeVolumes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeVolumes {
    _private: (),
}
impl DescribeVolumes {
    /// Creates a new builder-style object to manufacture [`DescribeVolumesInput`](crate::input::DescribeVolumesInput)
    pub fn builder() -> crate::input::describe_volumes_input::Builder {
        crate::input::describe_volumes_input::Builder::default()
    }
    /// Creates a new `DescribeVolumes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeVolumes {
    type Output = std::result::Result<
        crate::output::DescribeVolumesOutput,
        crate::error::DescribeVolumesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_volumes_error(response)
        } else {
            crate::operation_deser::parse_describe_volumes_response(response)
        }
    }
}

/// Operation shape for `DisassociateFileSystemAliases`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_file_system_aliases`](crate::client::Client::disassociate_file_system_aliases).
///
/// See [`crate::client::fluent_builders::DisassociateFileSystemAliases`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateFileSystemAliases {
    _private: (),
}
impl DisassociateFileSystemAliases {
    /// Creates a new builder-style object to manufacture [`DisassociateFileSystemAliasesInput`](crate::input::DisassociateFileSystemAliasesInput)
    pub fn builder() -> crate::input::disassociate_file_system_aliases_input::Builder {
        crate::input::disassociate_file_system_aliases_input::Builder::default()
    }
    /// Creates a new `DisassociateFileSystemAliases` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateFileSystemAliases {
    type Output = std::result::Result<
        crate::output::DisassociateFileSystemAliasesOutput,
        crate::error::DisassociateFileSystemAliasesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_file_system_aliases_error(response)
        } else {
            crate::operation_deser::parse_disassociate_file_system_aliases_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateFileSystem`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_file_system`](crate::client::Client::update_file_system).
///
/// See [`crate::client::fluent_builders::UpdateFileSystem`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFileSystem {
    _private: (),
}
impl UpdateFileSystem {
    /// Creates a new builder-style object to manufacture [`UpdateFileSystemInput`](crate::input::UpdateFileSystemInput)
    pub fn builder() -> crate::input::update_file_system_input::Builder {
        crate::input::update_file_system_input::Builder::default()
    }
    /// Creates a new `UpdateFileSystem` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFileSystem {
    type Output = std::result::Result<
        crate::output::UpdateFileSystemOutput,
        crate::error::UpdateFileSystemError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_file_system_error(response)
        } else {
            crate::operation_deser::parse_update_file_system_response(response)
        }
    }
}

/// Operation shape for `UpdateStorageVirtualMachine`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_storage_virtual_machine`](crate::client::Client::update_storage_virtual_machine).
///
/// See [`crate::client::fluent_builders::UpdateStorageVirtualMachine`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateStorageVirtualMachine {
    _private: (),
}
impl UpdateStorageVirtualMachine {
    /// Creates a new builder-style object to manufacture [`UpdateStorageVirtualMachineInput`](crate::input::UpdateStorageVirtualMachineInput)
    pub fn builder() -> crate::input::update_storage_virtual_machine_input::Builder {
        crate::input::update_storage_virtual_machine_input::Builder::default()
    }
    /// Creates a new `UpdateStorageVirtualMachine` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateStorageVirtualMachine {
    type Output = std::result::Result<
        crate::output::UpdateStorageVirtualMachineOutput,
        crate::error::UpdateStorageVirtualMachineError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_storage_virtual_machine_error(response)
        } else {
            crate::operation_deser::parse_update_storage_virtual_machine_response(response)
        }
    }
}

/// Operation shape for `UpdateVolume`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_volume`](crate::client::Client::update_volume).
///
/// See [`crate::client::fluent_builders::UpdateVolume`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateVolume {
    _private: (),
}
impl UpdateVolume {
    /// Creates a new builder-style object to manufacture [`UpdateVolumeInput`](crate::input::UpdateVolumeInput)
    pub fn builder() -> crate::input::update_volume_input::Builder {
        crate::input::update_volume_input::Builder::default()
    }
    /// Creates a new `UpdateVolume` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateVolume {
    type Output =
        std::result::Result<crate::output::UpdateVolumeOutput, crate::error::UpdateVolumeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_volume_error(response)
        } else {
            crate::operation_deser::parse_update_volume_response(response)
        }
    }
}
