// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Describes an Amazon FSx for NetApp ONTAP volume.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Volume {
    /// <p>The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z),
    /// also known as Unix time.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The globally unique ID of the file system, assigned by Amazon FSx.</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>The lifecycle status of the volume.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATED</code> - The volume is fully available for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATING</code> - Amazon FSx is creating the new volume.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETING</code> - Amazon FSx is deleting an existing volume.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - Amazon FSx was unable to create the volume.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MISCONFIGURED</code> - The volume is in a failed but recoverable state.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PENDING</code> - Amazon FSx has not started creating the volume.</p>
    /// </li>
    /// </ul>
    pub lifecycle: std::option::Option<crate::model::VolumeLifecycle>,
    /// <p>The name of the volume.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The configuration of an Amazon FSx for NetApp ONTAP volume</p>
    pub ontap_configuration: std::option::Option<crate::model::OntapVolumeConfiguration>,
    /// <p>The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services
    /// resources. We require an ARN when you need to specify a resource unambiguously across
    /// all of Amazon Web Services. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
    /// the <i>Amazon Web Services General Reference</i>.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The system-generated, unique ID of the volume.</p>
    pub volume_id: std::option::Option<std::string::String>,
    /// <p>The type of volume; <code>ONTAP</code> is the only valid volume type.</p>
    pub volume_type: std::option::Option<crate::model::VolumeType>,
    /// <p>Describes why the volume lifecycle state changed.</p>
    pub lifecycle_transition_reason: std::option::Option<crate::model::LifecycleTransitionReason>,
}
impl Volume {
    /// <p>The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z),
    /// also known as Unix time.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
    /// <p>The globally unique ID of the file system, assigned by Amazon FSx.</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
    /// <p>The lifecycle status of the volume.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATED</code> - The volume is fully available for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATING</code> - Amazon FSx is creating the new volume.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETING</code> - Amazon FSx is deleting an existing volume.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - Amazon FSx was unable to create the volume.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MISCONFIGURED</code> - The volume is in a failed but recoverable state.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PENDING</code> - Amazon FSx has not started creating the volume.</p>
    /// </li>
    /// </ul>
    pub fn lifecycle(&self) -> std::option::Option<&crate::model::VolumeLifecycle> {
        self.lifecycle.as_ref()
    }
    /// <p>The name of the volume.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The configuration of an Amazon FSx for NetApp ONTAP volume</p>
    pub fn ontap_configuration(
        &self,
    ) -> std::option::Option<&crate::model::OntapVolumeConfiguration> {
        self.ontap_configuration.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services
    /// resources. We require an ARN when you need to specify a resource unambiguously across
    /// all of Amazon Web Services. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
    /// the <i>Amazon Web Services General Reference</i>.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The system-generated, unique ID of the volume.</p>
    pub fn volume_id(&self) -> std::option::Option<&str> {
        self.volume_id.as_deref()
    }
    /// <p>The type of volume; <code>ONTAP</code> is the only valid volume type.</p>
    pub fn volume_type(&self) -> std::option::Option<&crate::model::VolumeType> {
        self.volume_type.as_ref()
    }
    /// <p>Describes why the volume lifecycle state changed.</p>
    pub fn lifecycle_transition_reason(
        &self,
    ) -> std::option::Option<&crate::model::LifecycleTransitionReason> {
        self.lifecycle_transition_reason.as_ref()
    }
}
impl std::fmt::Debug for Volume {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Volume");
        formatter.field("creation_time", &self.creation_time);
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("lifecycle", &self.lifecycle);
        formatter.field("name", &self.name);
        formatter.field("ontap_configuration", &self.ontap_configuration);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.field("volume_id", &self.volume_id);
        formatter.field("volume_type", &self.volume_type);
        formatter.field(
            "lifecycle_transition_reason",
            &self.lifecycle_transition_reason,
        );
        formatter.finish()
    }
}
/// See [`Volume`](crate::model::Volume)
pub mod volume {
    /// A builder for [`Volume`](crate::model::Volume)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) lifecycle: std::option::Option<crate::model::VolumeLifecycle>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) ontap_configuration: std::option::Option<crate::model::OntapVolumeConfiguration>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) volume_id: std::option::Option<std::string::String>,
        pub(crate) volume_type: std::option::Option<crate::model::VolumeType>,
        pub(crate) lifecycle_transition_reason:
            std::option::Option<crate::model::LifecycleTransitionReason>,
    }
    impl Builder {
        /// <p>The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z),
        /// also known as Unix time.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z),
        /// also known as Unix time.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The globally unique ID of the file system, assigned by Amazon FSx.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>The globally unique ID of the file system, assigned by Amazon FSx.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// <p>The lifecycle status of the volume.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATED</code> - The volume is fully available for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATING</code> - Amazon FSx is creating the new volume.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code> - Amazon FSx is deleting an existing volume.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - Amazon FSx was unable to create the volume.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MISCONFIGURED</code> - The volume is in a failed but recoverable state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PENDING</code> - Amazon FSx has not started creating the volume.</p>
        /// </li>
        /// </ul>
        pub fn lifecycle(mut self, input: crate::model::VolumeLifecycle) -> Self {
            self.lifecycle = Some(input);
            self
        }
        /// <p>The lifecycle status of the volume.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATED</code> - The volume is fully available for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATING</code> - Amazon FSx is creating the new volume.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code> - Amazon FSx is deleting an existing volume.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - Amazon FSx was unable to create the volume.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MISCONFIGURED</code> - The volume is in a failed but recoverable state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PENDING</code> - Amazon FSx has not started creating the volume.</p>
        /// </li>
        /// </ul>
        pub fn set_lifecycle(
            mut self,
            input: std::option::Option<crate::model::VolumeLifecycle>,
        ) -> Self {
            self.lifecycle = input;
            self
        }
        /// <p>The name of the volume.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the volume.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The configuration of an Amazon FSx for NetApp ONTAP volume</p>
        pub fn ontap_configuration(
            mut self,
            input: crate::model::OntapVolumeConfiguration,
        ) -> Self {
            self.ontap_configuration = Some(input);
            self
        }
        /// <p>The configuration of an Amazon FSx for NetApp ONTAP volume</p>
        pub fn set_ontap_configuration(
            mut self,
            input: std::option::Option<crate::model::OntapVolumeConfiguration>,
        ) -> Self {
            self.ontap_configuration = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services
        /// resources. We require an ARN when you need to specify a resource unambiguously across
        /// all of Amazon Web Services. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
        /// the <i>Amazon Web Services General Reference</i>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services
        /// resources. We require an ARN when you need to specify a resource unambiguously across
        /// all of Amazon Web Services. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
        /// the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The system-generated, unique ID of the volume.</p>
        pub fn volume_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_id = Some(input.into());
            self
        }
        /// <p>The system-generated, unique ID of the volume.</p>
        pub fn set_volume_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_id = input;
            self
        }
        /// <p>The type of volume; <code>ONTAP</code> is the only valid volume type.</p>
        pub fn volume_type(mut self, input: crate::model::VolumeType) -> Self {
            self.volume_type = Some(input);
            self
        }
        /// <p>The type of volume; <code>ONTAP</code> is the only valid volume type.</p>
        pub fn set_volume_type(
            mut self,
            input: std::option::Option<crate::model::VolumeType>,
        ) -> Self {
            self.volume_type = input;
            self
        }
        /// <p>Describes why the volume lifecycle state changed.</p>
        pub fn lifecycle_transition_reason(
            mut self,
            input: crate::model::LifecycleTransitionReason,
        ) -> Self {
            self.lifecycle_transition_reason = Some(input);
            self
        }
        /// <p>Describes why the volume lifecycle state changed.</p>
        pub fn set_lifecycle_transition_reason(
            mut self,
            input: std::option::Option<crate::model::LifecycleTransitionReason>,
        ) -> Self {
            self.lifecycle_transition_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`Volume`](crate::model::Volume)
        pub fn build(self) -> crate::model::Volume {
            crate::model::Volume {
                creation_time: self.creation_time,
                file_system_id: self.file_system_id,
                lifecycle: self.lifecycle,
                name: self.name,
                ontap_configuration: self.ontap_configuration,
                resource_arn: self.resource_arn,
                tags: self.tags,
                volume_id: self.volume_id,
                volume_type: self.volume_type,
                lifecycle_transition_reason: self.lifecycle_transition_reason,
            }
        }
    }
}
impl Volume {
    /// Creates a new builder-style object to manufacture [`Volume`](crate::model::Volume)
    pub fn builder() -> crate::model::volume::Builder {
        crate::model::volume::Builder::default()
    }
}

/// <p>Describes why a resource lifecycle state changed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LifecycleTransitionReason {
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl LifecycleTransitionReason {
    /// <p>A detailed error message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for LifecycleTransitionReason {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LifecycleTransitionReason");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`LifecycleTransitionReason`](crate::model::LifecycleTransitionReason)
pub mod lifecycle_transition_reason {
    /// A builder for [`LifecycleTransitionReason`](crate::model::LifecycleTransitionReason)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LifecycleTransitionReason`](crate::model::LifecycleTransitionReason)
        pub fn build(self) -> crate::model::LifecycleTransitionReason {
            crate::model::LifecycleTransitionReason {
                message: self.message,
            }
        }
    }
}
impl LifecycleTransitionReason {
    /// Creates a new builder-style object to manufacture [`LifecycleTransitionReason`](crate::model::LifecycleTransitionReason)
    pub fn builder() -> crate::model::lifecycle_transition_reason::Builder {
        crate::model::lifecycle_transition_reason::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VolumeType {
    #[allow(missing_docs)] // documentation missing in model
    Ontap,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VolumeType {
    fn from(s: &str) -> Self {
        match s {
            "ONTAP" => VolumeType::Ontap,
            other => VolumeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VolumeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VolumeType::from(s))
    }
}
impl VolumeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VolumeType::Ontap => "ONTAP",
            VolumeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ONTAP"]
    }
}
impl AsRef<str> for VolumeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies a key-value pair for a resource tag.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>A value that specifies the <code>TagKey</code>, the name of the tag. Tag keys must
    /// be unique for the resource to which they are attached.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>A value that specifies the <code>TagValue</code>, the value assigned to the
    /// corresponding tag key. Tag values can be null and don't have to be unique in a tag set.
    /// For example, you can have a key-value pair in a tag set of <code>finances : April</code>
    /// and also of <code>payroll : April</code>.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>A value that specifies the <code>TagKey</code>, the name of the tag. Tag keys must
    /// be unique for the resource to which they are attached.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>A value that specifies the <code>TagValue</code>, the value assigned to the
    /// corresponding tag key. Tag values can be null and don't have to be unique in a tag set.
    /// For example, you can have a key-value pair in a tag set of <code>finances : April</code>
    /// and also of <code>payroll : April</code>.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A value that specifies the <code>TagKey</code>, the name of the tag. Tag keys must
        /// be unique for the resource to which they are attached.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>A value that specifies the <code>TagKey</code>, the name of the tag. Tag keys must
        /// be unique for the resource to which they are attached.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>A value that specifies the <code>TagValue</code>, the value assigned to the
        /// corresponding tag key. Tag values can be null and don't have to be unique in a tag set.
        /// For example, you can have a key-value pair in a tag set of <code>finances : April</code>
        /// and also of <code>payroll : April</code>.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>A value that specifies the <code>TagValue</code>, the value assigned to the
        /// corresponding tag key. Tag values can be null and don't have to be unique in a tag set.
        /// For example, you can have a key-value pair in a tag set of <code>finances : April</code>
        /// and also of <code>payroll : April</code>.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>The configuration of an Amazon FSx for NetApp ONTAP volume</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OntapVolumeConfiguration {
    /// <p>Specifies the FlexCache endpoint type of the volume.
    /// Valid values are the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code> specifies that the volume doesn't have a FlexCache configuration.
    /// <code>NONE</code> is the default.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ORIGIN</code> specifies that the volume is the origin volume for a FlexCache volume.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CACHE</code> specifies that the volume is a FlexCache volume.</p>
    /// </li>
    /// </ul>
    pub flex_cache_endpoint_type: std::option::Option<crate::model::FlexCacheEndpointType>,
    /// <p>Specifies the directory that NAS clients use to mount the volume, along with the SVM DNS name or IP address.
    /// You can create a <code>JunctionPath</code> directly below a parent volume junction or on a
    /// directory within a volume. A <code>JunctionPath</code> for a volume named vol3 might
    /// be /vol1/vol2/vol3, or /vol1/dir2/vol3, or even /dir1/dir2/vol3..</p>
    pub junction_path: std::option::Option<std::string::String>,
    /// <p>The security style for the volume, which can be <code>UNIX</code>,
    /// <code>NTFS</code>, or <code>MIXED</code>.</p>
    pub security_style: std::option::Option<crate::model::SecurityStyle>,
    /// <p>The configured size of the volume, in megabytes (MBs).</p>
    pub size_in_megabytes: std::option::Option<i32>,
    /// <p>The volume's storage efficiency setting.</p>
    pub storage_efficiency_enabled: std::option::Option<bool>,
    /// <p>The ID of the volume's storage virtual machine.</p>
    pub storage_virtual_machine_id: std::option::Option<std::string::String>,
    /// <p>A boolean flag indicating whether this volume is the root volume for
    /// its storage virtual machine (SVM). Only one volume on an SVM can be the
    /// root volume. This value defaults to false. If this value is true, then
    /// this is the SVM root volume.</p>
    /// <p>This flag is useful when you're deleting an SVM, because you must
    /// first delete all non-root volumes. This flag, when set to false, helps
    /// you identify which volumes to delete before you can delete the SVM.</p>
    pub storage_virtual_machine_root: std::option::Option<bool>,
    /// <p>The volume's <code>TieringPolicy</code> setting.</p>
    pub tiering_policy: std::option::Option<crate::model::TieringPolicy>,
    /// <p>The volume's UUID (universally unique identifier).</p>
    pub uuid: std::option::Option<std::string::String>,
    /// <p>Specifies the type of volume. Valid values are the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>RW</code> specifies a read-write volume.
    /// <code>RW</code> is the default.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DP</code> specifies a data protection volume. You can
    /// protect data by replicating it to data protection mirror copies and use
    /// data protection mirror copies to recover data when a disaster occurs.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LS</code> specifies a load-sharing mirror volume.
    /// A load-sharing mirror reduces the network traffic to a FlexVol volume
    /// by providing additional read-only access to clients.</p>
    /// </li>
    /// </ul>
    pub ontap_volume_type: std::option::Option<crate::model::OntapVolumeType>,
}
impl OntapVolumeConfiguration {
    /// <p>Specifies the FlexCache endpoint type of the volume.
    /// Valid values are the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code> specifies that the volume doesn't have a FlexCache configuration.
    /// <code>NONE</code> is the default.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ORIGIN</code> specifies that the volume is the origin volume for a FlexCache volume.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CACHE</code> specifies that the volume is a FlexCache volume.</p>
    /// </li>
    /// </ul>
    pub fn flex_cache_endpoint_type(
        &self,
    ) -> std::option::Option<&crate::model::FlexCacheEndpointType> {
        self.flex_cache_endpoint_type.as_ref()
    }
    /// <p>Specifies the directory that NAS clients use to mount the volume, along with the SVM DNS name or IP address.
    /// You can create a <code>JunctionPath</code> directly below a parent volume junction or on a
    /// directory within a volume. A <code>JunctionPath</code> for a volume named vol3 might
    /// be /vol1/vol2/vol3, or /vol1/dir2/vol3, or even /dir1/dir2/vol3..</p>
    pub fn junction_path(&self) -> std::option::Option<&str> {
        self.junction_path.as_deref()
    }
    /// <p>The security style for the volume, which can be <code>UNIX</code>,
    /// <code>NTFS</code>, or <code>MIXED</code>.</p>
    pub fn security_style(&self) -> std::option::Option<&crate::model::SecurityStyle> {
        self.security_style.as_ref()
    }
    /// <p>The configured size of the volume, in megabytes (MBs).</p>
    pub fn size_in_megabytes(&self) -> std::option::Option<i32> {
        self.size_in_megabytes
    }
    /// <p>The volume's storage efficiency setting.</p>
    pub fn storage_efficiency_enabled(&self) -> std::option::Option<bool> {
        self.storage_efficiency_enabled
    }
    /// <p>The ID of the volume's storage virtual machine.</p>
    pub fn storage_virtual_machine_id(&self) -> std::option::Option<&str> {
        self.storage_virtual_machine_id.as_deref()
    }
    /// <p>A boolean flag indicating whether this volume is the root volume for
    /// its storage virtual machine (SVM). Only one volume on an SVM can be the
    /// root volume. This value defaults to false. If this value is true, then
    /// this is the SVM root volume.</p>
    /// <p>This flag is useful when you're deleting an SVM, because you must
    /// first delete all non-root volumes. This flag, when set to false, helps
    /// you identify which volumes to delete before you can delete the SVM.</p>
    pub fn storage_virtual_machine_root(&self) -> std::option::Option<bool> {
        self.storage_virtual_machine_root
    }
    /// <p>The volume's <code>TieringPolicy</code> setting.</p>
    pub fn tiering_policy(&self) -> std::option::Option<&crate::model::TieringPolicy> {
        self.tiering_policy.as_ref()
    }
    /// <p>The volume's UUID (universally unique identifier).</p>
    pub fn uuid(&self) -> std::option::Option<&str> {
        self.uuid.as_deref()
    }
    /// <p>Specifies the type of volume. Valid values are the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>RW</code> specifies a read-write volume.
    /// <code>RW</code> is the default.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DP</code> specifies a data protection volume. You can
    /// protect data by replicating it to data protection mirror copies and use
    /// data protection mirror copies to recover data when a disaster occurs.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LS</code> specifies a load-sharing mirror volume.
    /// A load-sharing mirror reduces the network traffic to a FlexVol volume
    /// by providing additional read-only access to clients.</p>
    /// </li>
    /// </ul>
    pub fn ontap_volume_type(&self) -> std::option::Option<&crate::model::OntapVolumeType> {
        self.ontap_volume_type.as_ref()
    }
}
impl std::fmt::Debug for OntapVolumeConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OntapVolumeConfiguration");
        formatter.field("flex_cache_endpoint_type", &self.flex_cache_endpoint_type);
        formatter.field("junction_path", &self.junction_path);
        formatter.field("security_style", &self.security_style);
        formatter.field("size_in_megabytes", &self.size_in_megabytes);
        formatter.field(
            "storage_efficiency_enabled",
            &self.storage_efficiency_enabled,
        );
        formatter.field(
            "storage_virtual_machine_id",
            &self.storage_virtual_machine_id,
        );
        formatter.field(
            "storage_virtual_machine_root",
            &self.storage_virtual_machine_root,
        );
        formatter.field("tiering_policy", &self.tiering_policy);
        formatter.field("uuid", &self.uuid);
        formatter.field("ontap_volume_type", &self.ontap_volume_type);
        formatter.finish()
    }
}
/// See [`OntapVolumeConfiguration`](crate::model::OntapVolumeConfiguration)
pub mod ontap_volume_configuration {
    /// A builder for [`OntapVolumeConfiguration`](crate::model::OntapVolumeConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flex_cache_endpoint_type:
            std::option::Option<crate::model::FlexCacheEndpointType>,
        pub(crate) junction_path: std::option::Option<std::string::String>,
        pub(crate) security_style: std::option::Option<crate::model::SecurityStyle>,
        pub(crate) size_in_megabytes: std::option::Option<i32>,
        pub(crate) storage_efficiency_enabled: std::option::Option<bool>,
        pub(crate) storage_virtual_machine_id: std::option::Option<std::string::String>,
        pub(crate) storage_virtual_machine_root: std::option::Option<bool>,
        pub(crate) tiering_policy: std::option::Option<crate::model::TieringPolicy>,
        pub(crate) uuid: std::option::Option<std::string::String>,
        pub(crate) ontap_volume_type: std::option::Option<crate::model::OntapVolumeType>,
    }
    impl Builder {
        /// <p>Specifies the FlexCache endpoint type of the volume.
        /// Valid values are the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code> specifies that the volume doesn't have a FlexCache configuration.
        /// <code>NONE</code> is the default.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ORIGIN</code> specifies that the volume is the origin volume for a FlexCache volume.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CACHE</code> specifies that the volume is a FlexCache volume.</p>
        /// </li>
        /// </ul>
        pub fn flex_cache_endpoint_type(
            mut self,
            input: crate::model::FlexCacheEndpointType,
        ) -> Self {
            self.flex_cache_endpoint_type = Some(input);
            self
        }
        /// <p>Specifies the FlexCache endpoint type of the volume.
        /// Valid values are the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code> specifies that the volume doesn't have a FlexCache configuration.
        /// <code>NONE</code> is the default.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ORIGIN</code> specifies that the volume is the origin volume for a FlexCache volume.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CACHE</code> specifies that the volume is a FlexCache volume.</p>
        /// </li>
        /// </ul>
        pub fn set_flex_cache_endpoint_type(
            mut self,
            input: std::option::Option<crate::model::FlexCacheEndpointType>,
        ) -> Self {
            self.flex_cache_endpoint_type = input;
            self
        }
        /// <p>Specifies the directory that NAS clients use to mount the volume, along with the SVM DNS name or IP address.
        /// You can create a <code>JunctionPath</code> directly below a parent volume junction or on a
        /// directory within a volume. A <code>JunctionPath</code> for a volume named vol3 might
        /// be /vol1/vol2/vol3, or /vol1/dir2/vol3, or even /dir1/dir2/vol3..</p>
        pub fn junction_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.junction_path = Some(input.into());
            self
        }
        /// <p>Specifies the directory that NAS clients use to mount the volume, along with the SVM DNS name or IP address.
        /// You can create a <code>JunctionPath</code> directly below a parent volume junction or on a
        /// directory within a volume. A <code>JunctionPath</code> for a volume named vol3 might
        /// be /vol1/vol2/vol3, or /vol1/dir2/vol3, or even /dir1/dir2/vol3..</p>
        pub fn set_junction_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.junction_path = input;
            self
        }
        /// <p>The security style for the volume, which can be <code>UNIX</code>,
        /// <code>NTFS</code>, or <code>MIXED</code>.</p>
        pub fn security_style(mut self, input: crate::model::SecurityStyle) -> Self {
            self.security_style = Some(input);
            self
        }
        /// <p>The security style for the volume, which can be <code>UNIX</code>,
        /// <code>NTFS</code>, or <code>MIXED</code>.</p>
        pub fn set_security_style(
            mut self,
            input: std::option::Option<crate::model::SecurityStyle>,
        ) -> Self {
            self.security_style = input;
            self
        }
        /// <p>The configured size of the volume, in megabytes (MBs).</p>
        pub fn size_in_megabytes(mut self, input: i32) -> Self {
            self.size_in_megabytes = Some(input);
            self
        }
        /// <p>The configured size of the volume, in megabytes (MBs).</p>
        pub fn set_size_in_megabytes(mut self, input: std::option::Option<i32>) -> Self {
            self.size_in_megabytes = input;
            self
        }
        /// <p>The volume's storage efficiency setting.</p>
        pub fn storage_efficiency_enabled(mut self, input: bool) -> Self {
            self.storage_efficiency_enabled = Some(input);
            self
        }
        /// <p>The volume's storage efficiency setting.</p>
        pub fn set_storage_efficiency_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.storage_efficiency_enabled = input;
            self
        }
        /// <p>The ID of the volume's storage virtual machine.</p>
        pub fn storage_virtual_machine_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.storage_virtual_machine_id = Some(input.into());
            self
        }
        /// <p>The ID of the volume's storage virtual machine.</p>
        pub fn set_storage_virtual_machine_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.storage_virtual_machine_id = input;
            self
        }
        /// <p>A boolean flag indicating whether this volume is the root volume for
        /// its storage virtual machine (SVM). Only one volume on an SVM can be the
        /// root volume. This value defaults to false. If this value is true, then
        /// this is the SVM root volume.</p>
        /// <p>This flag is useful when you're deleting an SVM, because you must
        /// first delete all non-root volumes. This flag, when set to false, helps
        /// you identify which volumes to delete before you can delete the SVM.</p>
        pub fn storage_virtual_machine_root(mut self, input: bool) -> Self {
            self.storage_virtual_machine_root = Some(input);
            self
        }
        /// <p>A boolean flag indicating whether this volume is the root volume for
        /// its storage virtual machine (SVM). Only one volume on an SVM can be the
        /// root volume. This value defaults to false. If this value is true, then
        /// this is the SVM root volume.</p>
        /// <p>This flag is useful when you're deleting an SVM, because you must
        /// first delete all non-root volumes. This flag, when set to false, helps
        /// you identify which volumes to delete before you can delete the SVM.</p>
        pub fn set_storage_virtual_machine_root(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.storage_virtual_machine_root = input;
            self
        }
        /// <p>The volume's <code>TieringPolicy</code> setting.</p>
        pub fn tiering_policy(mut self, input: crate::model::TieringPolicy) -> Self {
            self.tiering_policy = Some(input);
            self
        }
        /// <p>The volume's <code>TieringPolicy</code> setting.</p>
        pub fn set_tiering_policy(
            mut self,
            input: std::option::Option<crate::model::TieringPolicy>,
        ) -> Self {
            self.tiering_policy = input;
            self
        }
        /// <p>The volume's UUID (universally unique identifier).</p>
        pub fn uuid(mut self, input: impl Into<std::string::String>) -> Self {
            self.uuid = Some(input.into());
            self
        }
        /// <p>The volume's UUID (universally unique identifier).</p>
        pub fn set_uuid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uuid = input;
            self
        }
        /// <p>Specifies the type of volume. Valid values are the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>RW</code> specifies a read-write volume.
        /// <code>RW</code> is the default.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DP</code> specifies a data protection volume. You can
        /// protect data by replicating it to data protection mirror copies and use
        /// data protection mirror copies to recover data when a disaster occurs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LS</code> specifies a load-sharing mirror volume.
        /// A load-sharing mirror reduces the network traffic to a FlexVol volume
        /// by providing additional read-only access to clients.</p>
        /// </li>
        /// </ul>
        pub fn ontap_volume_type(mut self, input: crate::model::OntapVolumeType) -> Self {
            self.ontap_volume_type = Some(input);
            self
        }
        /// <p>Specifies the type of volume. Valid values are the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>RW</code> specifies a read-write volume.
        /// <code>RW</code> is the default.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DP</code> specifies a data protection volume. You can
        /// protect data by replicating it to data protection mirror copies and use
        /// data protection mirror copies to recover data when a disaster occurs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LS</code> specifies a load-sharing mirror volume.
        /// A load-sharing mirror reduces the network traffic to a FlexVol volume
        /// by providing additional read-only access to clients.</p>
        /// </li>
        /// </ul>
        pub fn set_ontap_volume_type(
            mut self,
            input: std::option::Option<crate::model::OntapVolumeType>,
        ) -> Self {
            self.ontap_volume_type = input;
            self
        }
        /// Consumes the builder and constructs a [`OntapVolumeConfiguration`](crate::model::OntapVolumeConfiguration)
        pub fn build(self) -> crate::model::OntapVolumeConfiguration {
            crate::model::OntapVolumeConfiguration {
                flex_cache_endpoint_type: self.flex_cache_endpoint_type,
                junction_path: self.junction_path,
                security_style: self.security_style,
                size_in_megabytes: self.size_in_megabytes,
                storage_efficiency_enabled: self.storage_efficiency_enabled,
                storage_virtual_machine_id: self.storage_virtual_machine_id,
                storage_virtual_machine_root: self.storage_virtual_machine_root,
                tiering_policy: self.tiering_policy,
                uuid: self.uuid,
                ontap_volume_type: self.ontap_volume_type,
            }
        }
    }
}
impl OntapVolumeConfiguration {
    /// Creates a new builder-style object to manufacture [`OntapVolumeConfiguration`](crate::model::OntapVolumeConfiguration)
    pub fn builder() -> crate::model::ontap_volume_configuration::Builder {
        crate::model::ontap_volume_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OntapVolumeType {
    #[allow(missing_docs)] // documentation missing in model
    Dp,
    #[allow(missing_docs)] // documentation missing in model
    Ls,
    #[allow(missing_docs)] // documentation missing in model
    Rw,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OntapVolumeType {
    fn from(s: &str) -> Self {
        match s {
            "DP" => OntapVolumeType::Dp,
            "LS" => OntapVolumeType::Ls,
            "RW" => OntapVolumeType::Rw,
            other => OntapVolumeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OntapVolumeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OntapVolumeType::from(s))
    }
}
impl OntapVolumeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OntapVolumeType::Dp => "DP",
            OntapVolumeType::Ls => "LS",
            OntapVolumeType::Rw => "RW",
            OntapVolumeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DP", "LS", "RW"]
    }
}
impl AsRef<str> for OntapVolumeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the data tiering policy for an ONTAP volume. When enabled, Amazon FSx for ONTAP's intelligent
/// tiering automatically transitions a volume's data between the file system's primary storage and capacity
/// pool storage based on your access patterns.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TieringPolicy {
    /// <p>Specifies the number of days that user data in a volume must remain inactive before it is considered "cold"
    /// and moved to the capacity pool. Used with the <code>AUTO</code> and <code>SNAPSHOT_ONLY</code> tiering policies.
    /// Enter a whole number between 2 and 183. Default values are 31 days for <code>AUTO</code> and 2 days for
    /// <code>SNAPSHOT_ONLY</code>.</p>
    pub cooling_period: std::option::Option<i32>,
    /// <p>Specifies the tiering policy used to transition data. Default value is <code>SNAPSHOT_ONLY</code>.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SNAPSHOT_ONLY</code> - moves cold snapshots to the capacity pool storage tier.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AUTO</code> - moves cold user data and snapshots to the capacity pool storage tier
    /// based on your access patterns.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALL</code> - moves all user data blocks in both the active file system and Snapshot copies to the
    /// storage pool tier.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NONE</code> - keeps a volume's data in the primary storage tier, preventing it from being moved to
    /// the capacity pool tier.</p>
    /// </li>
    /// </ul>
    pub name: std::option::Option<crate::model::TieringPolicyName>,
}
impl TieringPolicy {
    /// <p>Specifies the number of days that user data in a volume must remain inactive before it is considered "cold"
    /// and moved to the capacity pool. Used with the <code>AUTO</code> and <code>SNAPSHOT_ONLY</code> tiering policies.
    /// Enter a whole number between 2 and 183. Default values are 31 days for <code>AUTO</code> and 2 days for
    /// <code>SNAPSHOT_ONLY</code>.</p>
    pub fn cooling_period(&self) -> std::option::Option<i32> {
        self.cooling_period
    }
    /// <p>Specifies the tiering policy used to transition data. Default value is <code>SNAPSHOT_ONLY</code>.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SNAPSHOT_ONLY</code> - moves cold snapshots to the capacity pool storage tier.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AUTO</code> - moves cold user data and snapshots to the capacity pool storage tier
    /// based on your access patterns.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALL</code> - moves all user data blocks in both the active file system and Snapshot copies to the
    /// storage pool tier.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NONE</code> - keeps a volume's data in the primary storage tier, preventing it from being moved to
    /// the capacity pool tier.</p>
    /// </li>
    /// </ul>
    pub fn name(&self) -> std::option::Option<&crate::model::TieringPolicyName> {
        self.name.as_ref()
    }
}
impl std::fmt::Debug for TieringPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TieringPolicy");
        formatter.field("cooling_period", &self.cooling_period);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`TieringPolicy`](crate::model::TieringPolicy)
pub mod tiering_policy {
    /// A builder for [`TieringPolicy`](crate::model::TieringPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cooling_period: std::option::Option<i32>,
        pub(crate) name: std::option::Option<crate::model::TieringPolicyName>,
    }
    impl Builder {
        /// <p>Specifies the number of days that user data in a volume must remain inactive before it is considered "cold"
        /// and moved to the capacity pool. Used with the <code>AUTO</code> and <code>SNAPSHOT_ONLY</code> tiering policies.
        /// Enter a whole number between 2 and 183. Default values are 31 days for <code>AUTO</code> and 2 days for
        /// <code>SNAPSHOT_ONLY</code>.</p>
        pub fn cooling_period(mut self, input: i32) -> Self {
            self.cooling_period = Some(input);
            self
        }
        /// <p>Specifies the number of days that user data in a volume must remain inactive before it is considered "cold"
        /// and moved to the capacity pool. Used with the <code>AUTO</code> and <code>SNAPSHOT_ONLY</code> tiering policies.
        /// Enter a whole number between 2 and 183. Default values are 31 days for <code>AUTO</code> and 2 days for
        /// <code>SNAPSHOT_ONLY</code>.</p>
        pub fn set_cooling_period(mut self, input: std::option::Option<i32>) -> Self {
            self.cooling_period = input;
            self
        }
        /// <p>Specifies the tiering policy used to transition data. Default value is <code>SNAPSHOT_ONLY</code>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SNAPSHOT_ONLY</code> - moves cold snapshots to the capacity pool storage tier.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AUTO</code> - moves cold user data and snapshots to the capacity pool storage tier
        /// based on your access patterns.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL</code> - moves all user data blocks in both the active file system and Snapshot copies to the
        /// storage pool tier.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - keeps a volume's data in the primary storage tier, preventing it from being moved to
        /// the capacity pool tier.</p>
        /// </li>
        /// </ul>
        pub fn name(mut self, input: crate::model::TieringPolicyName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>Specifies the tiering policy used to transition data. Default value is <code>SNAPSHOT_ONLY</code>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SNAPSHOT_ONLY</code> - moves cold snapshots to the capacity pool storage tier.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AUTO</code> - moves cold user data and snapshots to the capacity pool storage tier
        /// based on your access patterns.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL</code> - moves all user data blocks in both the active file system and Snapshot copies to the
        /// storage pool tier.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - keeps a volume's data in the primary storage tier, preventing it from being moved to
        /// the capacity pool tier.</p>
        /// </li>
        /// </ul>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::TieringPolicyName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`TieringPolicy`](crate::model::TieringPolicy)
        pub fn build(self) -> crate::model::TieringPolicy {
            crate::model::TieringPolicy {
                cooling_period: self.cooling_period,
                name: self.name,
            }
        }
    }
}
impl TieringPolicy {
    /// Creates a new builder-style object to manufacture [`TieringPolicy`](crate::model::TieringPolicy)
    pub fn builder() -> crate::model::tiering_policy::Builder {
        crate::model::tiering_policy::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TieringPolicyName {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Auto,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    SnapshotOnly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TieringPolicyName {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => TieringPolicyName::All,
            "AUTO" => TieringPolicyName::Auto,
            "NONE" => TieringPolicyName::None,
            "SNAPSHOT_ONLY" => TieringPolicyName::SnapshotOnly,
            other => TieringPolicyName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TieringPolicyName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TieringPolicyName::from(s))
    }
}
impl TieringPolicyName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TieringPolicyName::All => "ALL",
            TieringPolicyName::Auto => "AUTO",
            TieringPolicyName::None => "NONE",
            TieringPolicyName::SnapshotOnly => "SNAPSHOT_ONLY",
            TieringPolicyName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "AUTO", "NONE", "SNAPSHOT_ONLY"]
    }
}
impl AsRef<str> for TieringPolicyName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SecurityStyle {
    #[allow(missing_docs)] // documentation missing in model
    Mixed,
    #[allow(missing_docs)] // documentation missing in model
    Ntfs,
    #[allow(missing_docs)] // documentation missing in model
    Unix,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SecurityStyle {
    fn from(s: &str) -> Self {
        match s {
            "MIXED" => SecurityStyle::Mixed,
            "NTFS" => SecurityStyle::Ntfs,
            "UNIX" => SecurityStyle::Unix,
            other => SecurityStyle::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SecurityStyle {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SecurityStyle::from(s))
    }
}
impl SecurityStyle {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SecurityStyle::Mixed => "MIXED",
            SecurityStyle::Ntfs => "NTFS",
            SecurityStyle::Unix => "UNIX",
            SecurityStyle::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MIXED", "NTFS", "UNIX"]
    }
}
impl AsRef<str> for SecurityStyle {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FlexCacheEndpointType {
    #[allow(missing_docs)] // documentation missing in model
    Cache,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Origin,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FlexCacheEndpointType {
    fn from(s: &str) -> Self {
        match s {
            "CACHE" => FlexCacheEndpointType::Cache,
            "NONE" => FlexCacheEndpointType::None,
            "ORIGIN" => FlexCacheEndpointType::Origin,
            other => FlexCacheEndpointType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FlexCacheEndpointType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FlexCacheEndpointType::from(s))
    }
}
impl FlexCacheEndpointType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FlexCacheEndpointType::Cache => "CACHE",
            FlexCacheEndpointType::None => "NONE",
            FlexCacheEndpointType::Origin => "ORIGIN",
            FlexCacheEndpointType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CACHE", "NONE", "ORIGIN"]
    }
}
impl AsRef<str> for FlexCacheEndpointType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VolumeLifecycle {
    #[allow(missing_docs)] // documentation missing in model
    Created,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Misconfigured,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VolumeLifecycle {
    fn from(s: &str) -> Self {
        match s {
            "CREATED" => VolumeLifecycle::Created,
            "CREATING" => VolumeLifecycle::Creating,
            "DELETING" => VolumeLifecycle::Deleting,
            "FAILED" => VolumeLifecycle::Failed,
            "MISCONFIGURED" => VolumeLifecycle::Misconfigured,
            "PENDING" => VolumeLifecycle::Pending,
            other => VolumeLifecycle::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VolumeLifecycle {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VolumeLifecycle::from(s))
    }
}
impl VolumeLifecycle {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VolumeLifecycle::Created => "CREATED",
            VolumeLifecycle::Creating => "CREATING",
            VolumeLifecycle::Deleting => "DELETING",
            VolumeLifecycle::Failed => "FAILED",
            VolumeLifecycle::Misconfigured => "MISCONFIGURED",
            VolumeLifecycle::Pending => "PENDING",
            VolumeLifecycle::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATED",
            "CREATING",
            "DELETING",
            "FAILED",
            "MISCONFIGURED",
            "PENDING",
        ]
    }
}
impl AsRef<str> for VolumeLifecycle {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Used to specify changes to the ONTAP configuration for the volume you are updating.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateOntapVolumeConfiguration {
    /// <p>Specifies the location in the SVM's namespace where the volume is mounted.
    /// The <code>JunctionPath</code> must have a leading forward slash, such as <code>/vol3</code>.</p>
    pub junction_path: std::option::Option<std::string::String>,
    /// <p>The security style for the volume, which can be <code>UNIX</code>.
    /// <code>NTFS</code>, or <code>MIXED</code>.</p>
    pub security_style: std::option::Option<crate::model::SecurityStyle>,
    /// <p>Specifies the size of the volume in megabytes.</p>
    pub size_in_megabytes: std::option::Option<i32>,
    /// <p>Default is <code>false</code>. Set to true to enable the deduplication,
    /// compression, and compaction storage efficiency features on the volume.</p>
    pub storage_efficiency_enabled: std::option::Option<bool>,
    /// <p>Update the volume's data tiering policy.</p>
    pub tiering_policy: std::option::Option<crate::model::TieringPolicy>,
}
impl UpdateOntapVolumeConfiguration {
    /// <p>Specifies the location in the SVM's namespace where the volume is mounted.
    /// The <code>JunctionPath</code> must have a leading forward slash, such as <code>/vol3</code>.</p>
    pub fn junction_path(&self) -> std::option::Option<&str> {
        self.junction_path.as_deref()
    }
    /// <p>The security style for the volume, which can be <code>UNIX</code>.
    /// <code>NTFS</code>, or <code>MIXED</code>.</p>
    pub fn security_style(&self) -> std::option::Option<&crate::model::SecurityStyle> {
        self.security_style.as_ref()
    }
    /// <p>Specifies the size of the volume in megabytes.</p>
    pub fn size_in_megabytes(&self) -> std::option::Option<i32> {
        self.size_in_megabytes
    }
    /// <p>Default is <code>false</code>. Set to true to enable the deduplication,
    /// compression, and compaction storage efficiency features on the volume.</p>
    pub fn storage_efficiency_enabled(&self) -> std::option::Option<bool> {
        self.storage_efficiency_enabled
    }
    /// <p>Update the volume's data tiering policy.</p>
    pub fn tiering_policy(&self) -> std::option::Option<&crate::model::TieringPolicy> {
        self.tiering_policy.as_ref()
    }
}
impl std::fmt::Debug for UpdateOntapVolumeConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateOntapVolumeConfiguration");
        formatter.field("junction_path", &self.junction_path);
        formatter.field("security_style", &self.security_style);
        formatter.field("size_in_megabytes", &self.size_in_megabytes);
        formatter.field(
            "storage_efficiency_enabled",
            &self.storage_efficiency_enabled,
        );
        formatter.field("tiering_policy", &self.tiering_policy);
        formatter.finish()
    }
}
/// See [`UpdateOntapVolumeConfiguration`](crate::model::UpdateOntapVolumeConfiguration)
pub mod update_ontap_volume_configuration {
    /// A builder for [`UpdateOntapVolumeConfiguration`](crate::model::UpdateOntapVolumeConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) junction_path: std::option::Option<std::string::String>,
        pub(crate) security_style: std::option::Option<crate::model::SecurityStyle>,
        pub(crate) size_in_megabytes: std::option::Option<i32>,
        pub(crate) storage_efficiency_enabled: std::option::Option<bool>,
        pub(crate) tiering_policy: std::option::Option<crate::model::TieringPolicy>,
    }
    impl Builder {
        /// <p>Specifies the location in the SVM's namespace where the volume is mounted.
        /// The <code>JunctionPath</code> must have a leading forward slash, such as <code>/vol3</code>.</p>
        pub fn junction_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.junction_path = Some(input.into());
            self
        }
        /// <p>Specifies the location in the SVM's namespace where the volume is mounted.
        /// The <code>JunctionPath</code> must have a leading forward slash, such as <code>/vol3</code>.</p>
        pub fn set_junction_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.junction_path = input;
            self
        }
        /// <p>The security style for the volume, which can be <code>UNIX</code>.
        /// <code>NTFS</code>, or <code>MIXED</code>.</p>
        pub fn security_style(mut self, input: crate::model::SecurityStyle) -> Self {
            self.security_style = Some(input);
            self
        }
        /// <p>The security style for the volume, which can be <code>UNIX</code>.
        /// <code>NTFS</code>, or <code>MIXED</code>.</p>
        pub fn set_security_style(
            mut self,
            input: std::option::Option<crate::model::SecurityStyle>,
        ) -> Self {
            self.security_style = input;
            self
        }
        /// <p>Specifies the size of the volume in megabytes.</p>
        pub fn size_in_megabytes(mut self, input: i32) -> Self {
            self.size_in_megabytes = Some(input);
            self
        }
        /// <p>Specifies the size of the volume in megabytes.</p>
        pub fn set_size_in_megabytes(mut self, input: std::option::Option<i32>) -> Self {
            self.size_in_megabytes = input;
            self
        }
        /// <p>Default is <code>false</code>. Set to true to enable the deduplication,
        /// compression, and compaction storage efficiency features on the volume.</p>
        pub fn storage_efficiency_enabled(mut self, input: bool) -> Self {
            self.storage_efficiency_enabled = Some(input);
            self
        }
        /// <p>Default is <code>false</code>. Set to true to enable the deduplication,
        /// compression, and compaction storage efficiency features on the volume.</p>
        pub fn set_storage_efficiency_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.storage_efficiency_enabled = input;
            self
        }
        /// <p>Update the volume's data tiering policy.</p>
        pub fn tiering_policy(mut self, input: crate::model::TieringPolicy) -> Self {
            self.tiering_policy = Some(input);
            self
        }
        /// <p>Update the volume's data tiering policy.</p>
        pub fn set_tiering_policy(
            mut self,
            input: std::option::Option<crate::model::TieringPolicy>,
        ) -> Self {
            self.tiering_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateOntapVolumeConfiguration`](crate::model::UpdateOntapVolumeConfiguration)
        pub fn build(self) -> crate::model::UpdateOntapVolumeConfiguration {
            crate::model::UpdateOntapVolumeConfiguration {
                junction_path: self.junction_path,
                security_style: self.security_style,
                size_in_megabytes: self.size_in_megabytes,
                storage_efficiency_enabled: self.storage_efficiency_enabled,
                tiering_policy: self.tiering_policy,
            }
        }
    }
}
impl UpdateOntapVolumeConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateOntapVolumeConfiguration`](crate::model::UpdateOntapVolumeConfiguration)
    pub fn builder() -> crate::model::update_ontap_volume_configuration::Builder {
        crate::model::update_ontap_volume_configuration::Builder::default()
    }
}

/// <p>Describes the Amazon FSx for NetApp ONTAP storage virtual machine (SVM) configuraton.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StorageVirtualMachine {
    /// <p>Describes the Microsoft Active Directory configuration to which the SVM is joined, if applicable.</p>
    pub active_directory_configuration:
        std::option::Option<crate::model::SvmActiveDirectoryConfiguration>,
    /// <p>The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z),
    /// also known as Unix time.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The endpoints  that are used to access data or to manage the SVM
    /// using the NetApp ONTAP CLI, REST API, or NetApp CloudManager. They
    /// are the <code>Iscsi</code>, <code>Management</code>, <code>Nfs</code>,
    /// and <code>Smb</code> endpoints.</p>
    pub endpoints: std::option::Option<crate::model::SvmEndpoints>,
    /// <p>The globally unique ID of the file system, assigned by Amazon FSx.</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>Describes the SVM's lifecycle status.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATED</code> - The SVM is fully available for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATING</code> - Amazon FSx is creating the new SVM.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETING</code> - Amazon FSx is deleting an existing SVM.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - Amazon FSx was unable to create the SVM.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MISCONFIGURED</code> - The SVM is in a failed but recoverable state.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PENDING</code> - Amazon FSx has not started creating the SVM.</p>
    /// </li>
    /// </ul>
    pub lifecycle: std::option::Option<crate::model::StorageVirtualMachineLifecycle>,
    /// <p>The name of the SVM, if provisioned.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services
    /// resources. We require an ARN when you need to specify a resource unambiguously across
    /// all of Amazon Web Services. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
    /// the <i>Amazon Web Services General Reference</i>.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The SVM's system generated unique ID.</p>
    pub storage_virtual_machine_id: std::option::Option<std::string::String>,
    /// <p>Describes the SVM's subtype.</p>
    pub subtype: std::option::Option<crate::model::StorageVirtualMachineSubtype>,
    /// <p>The SVM's UUID (universally unique identifier).</p>
    pub uuid: std::option::Option<std::string::String>,
    /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Describes why the SVM lifecycle state changed.</p>
    pub lifecycle_transition_reason: std::option::Option<crate::model::LifecycleTransitionReason>,
    /// <p>The security style of the root volume of the SVM.</p>
    pub root_volume_security_style:
        std::option::Option<crate::model::StorageVirtualMachineRootVolumeSecurityStyle>,
}
impl StorageVirtualMachine {
    /// <p>Describes the Microsoft Active Directory configuration to which the SVM is joined, if applicable.</p>
    pub fn active_directory_configuration(
        &self,
    ) -> std::option::Option<&crate::model::SvmActiveDirectoryConfiguration> {
        self.active_directory_configuration.as_ref()
    }
    /// <p>The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z),
    /// also known as Unix time.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
    /// <p>The endpoints  that are used to access data or to manage the SVM
    /// using the NetApp ONTAP CLI, REST API, or NetApp CloudManager. They
    /// are the <code>Iscsi</code>, <code>Management</code>, <code>Nfs</code>,
    /// and <code>Smb</code> endpoints.</p>
    pub fn endpoints(&self) -> std::option::Option<&crate::model::SvmEndpoints> {
        self.endpoints.as_ref()
    }
    /// <p>The globally unique ID of the file system, assigned by Amazon FSx.</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
    /// <p>Describes the SVM's lifecycle status.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATED</code> - The SVM is fully available for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATING</code> - Amazon FSx is creating the new SVM.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETING</code> - Amazon FSx is deleting an existing SVM.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - Amazon FSx was unable to create the SVM.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MISCONFIGURED</code> - The SVM is in a failed but recoverable state.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PENDING</code> - Amazon FSx has not started creating the SVM.</p>
    /// </li>
    /// </ul>
    pub fn lifecycle(&self) -> std::option::Option<&crate::model::StorageVirtualMachineLifecycle> {
        self.lifecycle.as_ref()
    }
    /// <p>The name of the SVM, if provisioned.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services
    /// resources. We require an ARN when you need to specify a resource unambiguously across
    /// all of Amazon Web Services. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
    /// the <i>Amazon Web Services General Reference</i>.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The SVM's system generated unique ID.</p>
    pub fn storage_virtual_machine_id(&self) -> std::option::Option<&str> {
        self.storage_virtual_machine_id.as_deref()
    }
    /// <p>Describes the SVM's subtype.</p>
    pub fn subtype(&self) -> std::option::Option<&crate::model::StorageVirtualMachineSubtype> {
        self.subtype.as_ref()
    }
    /// <p>The SVM's UUID (universally unique identifier).</p>
    pub fn uuid(&self) -> std::option::Option<&str> {
        self.uuid.as_deref()
    }
    /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>Describes why the SVM lifecycle state changed.</p>
    pub fn lifecycle_transition_reason(
        &self,
    ) -> std::option::Option<&crate::model::LifecycleTransitionReason> {
        self.lifecycle_transition_reason.as_ref()
    }
    /// <p>The security style of the root volume of the SVM.</p>
    pub fn root_volume_security_style(
        &self,
    ) -> std::option::Option<&crate::model::StorageVirtualMachineRootVolumeSecurityStyle> {
        self.root_volume_security_style.as_ref()
    }
}
impl std::fmt::Debug for StorageVirtualMachine {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StorageVirtualMachine");
        formatter.field(
            "active_directory_configuration",
            &self.active_directory_configuration,
        );
        formatter.field("creation_time", &self.creation_time);
        formatter.field("endpoints", &self.endpoints);
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("lifecycle", &self.lifecycle);
        formatter.field("name", &self.name);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field(
            "storage_virtual_machine_id",
            &self.storage_virtual_machine_id,
        );
        formatter.field("subtype", &self.subtype);
        formatter.field("uuid", &self.uuid);
        formatter.field("tags", &self.tags);
        formatter.field(
            "lifecycle_transition_reason",
            &self.lifecycle_transition_reason,
        );
        formatter.field(
            "root_volume_security_style",
            &self.root_volume_security_style,
        );
        formatter.finish()
    }
}
/// See [`StorageVirtualMachine`](crate::model::StorageVirtualMachine)
pub mod storage_virtual_machine {
    /// A builder for [`StorageVirtualMachine`](crate::model::StorageVirtualMachine)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) active_directory_configuration:
            std::option::Option<crate::model::SvmActiveDirectoryConfiguration>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) endpoints: std::option::Option<crate::model::SvmEndpoints>,
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) lifecycle: std::option::Option<crate::model::StorageVirtualMachineLifecycle>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) storage_virtual_machine_id: std::option::Option<std::string::String>,
        pub(crate) subtype: std::option::Option<crate::model::StorageVirtualMachineSubtype>,
        pub(crate) uuid: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) lifecycle_transition_reason:
            std::option::Option<crate::model::LifecycleTransitionReason>,
        pub(crate) root_volume_security_style:
            std::option::Option<crate::model::StorageVirtualMachineRootVolumeSecurityStyle>,
    }
    impl Builder {
        /// <p>Describes the Microsoft Active Directory configuration to which the SVM is joined, if applicable.</p>
        pub fn active_directory_configuration(
            mut self,
            input: crate::model::SvmActiveDirectoryConfiguration,
        ) -> Self {
            self.active_directory_configuration = Some(input);
            self
        }
        /// <p>Describes the Microsoft Active Directory configuration to which the SVM is joined, if applicable.</p>
        pub fn set_active_directory_configuration(
            mut self,
            input: std::option::Option<crate::model::SvmActiveDirectoryConfiguration>,
        ) -> Self {
            self.active_directory_configuration = input;
            self
        }
        /// <p>The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z),
        /// also known as Unix time.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z),
        /// also known as Unix time.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The endpoints  that are used to access data or to manage the SVM
        /// using the NetApp ONTAP CLI, REST API, or NetApp CloudManager. They
        /// are the <code>Iscsi</code>, <code>Management</code>, <code>Nfs</code>,
        /// and <code>Smb</code> endpoints.</p>
        pub fn endpoints(mut self, input: crate::model::SvmEndpoints) -> Self {
            self.endpoints = Some(input);
            self
        }
        /// <p>The endpoints  that are used to access data or to manage the SVM
        /// using the NetApp ONTAP CLI, REST API, or NetApp CloudManager. They
        /// are the <code>Iscsi</code>, <code>Management</code>, <code>Nfs</code>,
        /// and <code>Smb</code> endpoints.</p>
        pub fn set_endpoints(
            mut self,
            input: std::option::Option<crate::model::SvmEndpoints>,
        ) -> Self {
            self.endpoints = input;
            self
        }
        /// <p>The globally unique ID of the file system, assigned by Amazon FSx.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>The globally unique ID of the file system, assigned by Amazon FSx.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// <p>Describes the SVM's lifecycle status.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATED</code> - The SVM is fully available for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATING</code> - Amazon FSx is creating the new SVM.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code> - Amazon FSx is deleting an existing SVM.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - Amazon FSx was unable to create the SVM.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MISCONFIGURED</code> - The SVM is in a failed but recoverable state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PENDING</code> - Amazon FSx has not started creating the SVM.</p>
        /// </li>
        /// </ul>
        pub fn lifecycle(mut self, input: crate::model::StorageVirtualMachineLifecycle) -> Self {
            self.lifecycle = Some(input);
            self
        }
        /// <p>Describes the SVM's lifecycle status.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATED</code> - The SVM is fully available for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATING</code> - Amazon FSx is creating the new SVM.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code> - Amazon FSx is deleting an existing SVM.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - Amazon FSx was unable to create the SVM.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MISCONFIGURED</code> - The SVM is in a failed but recoverable state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PENDING</code> - Amazon FSx has not started creating the SVM.</p>
        /// </li>
        /// </ul>
        pub fn set_lifecycle(
            mut self,
            input: std::option::Option<crate::model::StorageVirtualMachineLifecycle>,
        ) -> Self {
            self.lifecycle = input;
            self
        }
        /// <p>The name of the SVM, if provisioned.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the SVM, if provisioned.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services
        /// resources. We require an ARN when you need to specify a resource unambiguously across
        /// all of Amazon Web Services. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
        /// the <i>Amazon Web Services General Reference</i>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services
        /// resources. We require an ARN when you need to specify a resource unambiguously across
        /// all of Amazon Web Services. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
        /// the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The SVM's system generated unique ID.</p>
        pub fn storage_virtual_machine_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.storage_virtual_machine_id = Some(input.into());
            self
        }
        /// <p>The SVM's system generated unique ID.</p>
        pub fn set_storage_virtual_machine_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.storage_virtual_machine_id = input;
            self
        }
        /// <p>Describes the SVM's subtype.</p>
        pub fn subtype(mut self, input: crate::model::StorageVirtualMachineSubtype) -> Self {
            self.subtype = Some(input);
            self
        }
        /// <p>Describes the SVM's subtype.</p>
        pub fn set_subtype(
            mut self,
            input: std::option::Option<crate::model::StorageVirtualMachineSubtype>,
        ) -> Self {
            self.subtype = input;
            self
        }
        /// <p>The SVM's UUID (universally unique identifier).</p>
        pub fn uuid(mut self, input: impl Into<std::string::String>) -> Self {
            self.uuid = Some(input.into());
            self
        }
        /// <p>The SVM's UUID (universally unique identifier).</p>
        pub fn set_uuid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uuid = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Describes why the SVM lifecycle state changed.</p>
        pub fn lifecycle_transition_reason(
            mut self,
            input: crate::model::LifecycleTransitionReason,
        ) -> Self {
            self.lifecycle_transition_reason = Some(input);
            self
        }
        /// <p>Describes why the SVM lifecycle state changed.</p>
        pub fn set_lifecycle_transition_reason(
            mut self,
            input: std::option::Option<crate::model::LifecycleTransitionReason>,
        ) -> Self {
            self.lifecycle_transition_reason = input;
            self
        }
        /// <p>The security style of the root volume of the SVM.</p>
        pub fn root_volume_security_style(
            mut self,
            input: crate::model::StorageVirtualMachineRootVolumeSecurityStyle,
        ) -> Self {
            self.root_volume_security_style = Some(input);
            self
        }
        /// <p>The security style of the root volume of the SVM.</p>
        pub fn set_root_volume_security_style(
            mut self,
            input: std::option::Option<crate::model::StorageVirtualMachineRootVolumeSecurityStyle>,
        ) -> Self {
            self.root_volume_security_style = input;
            self
        }
        /// Consumes the builder and constructs a [`StorageVirtualMachine`](crate::model::StorageVirtualMachine)
        pub fn build(self) -> crate::model::StorageVirtualMachine {
            crate::model::StorageVirtualMachine {
                active_directory_configuration: self.active_directory_configuration,
                creation_time: self.creation_time,
                endpoints: self.endpoints,
                file_system_id: self.file_system_id,
                lifecycle: self.lifecycle,
                name: self.name,
                resource_arn: self.resource_arn,
                storage_virtual_machine_id: self.storage_virtual_machine_id,
                subtype: self.subtype,
                uuid: self.uuid,
                tags: self.tags,
                lifecycle_transition_reason: self.lifecycle_transition_reason,
                root_volume_security_style: self.root_volume_security_style,
            }
        }
    }
}
impl StorageVirtualMachine {
    /// Creates a new builder-style object to manufacture [`StorageVirtualMachine`](crate::model::StorageVirtualMachine)
    pub fn builder() -> crate::model::storage_virtual_machine::Builder {
        crate::model::storage_virtual_machine::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StorageVirtualMachineRootVolumeSecurityStyle {
    #[allow(missing_docs)] // documentation missing in model
    Mixed,
    #[allow(missing_docs)] // documentation missing in model
    Ntfs,
    #[allow(missing_docs)] // documentation missing in model
    Unix,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StorageVirtualMachineRootVolumeSecurityStyle {
    fn from(s: &str) -> Self {
        match s {
            "MIXED" => StorageVirtualMachineRootVolumeSecurityStyle::Mixed,
            "NTFS" => StorageVirtualMachineRootVolumeSecurityStyle::Ntfs,
            "UNIX" => StorageVirtualMachineRootVolumeSecurityStyle::Unix,
            other => StorageVirtualMachineRootVolumeSecurityStyle::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StorageVirtualMachineRootVolumeSecurityStyle {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StorageVirtualMachineRootVolumeSecurityStyle::from(s))
    }
}
impl StorageVirtualMachineRootVolumeSecurityStyle {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StorageVirtualMachineRootVolumeSecurityStyle::Mixed => "MIXED",
            StorageVirtualMachineRootVolumeSecurityStyle::Ntfs => "NTFS",
            StorageVirtualMachineRootVolumeSecurityStyle::Unix => "UNIX",
            StorageVirtualMachineRootVolumeSecurityStyle::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MIXED", "NTFS", "UNIX"]
    }
}
impl AsRef<str> for StorageVirtualMachineRootVolumeSecurityStyle {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StorageVirtualMachineSubtype {
    #[allow(missing_docs)] // documentation missing in model
    Default,
    #[allow(missing_docs)] // documentation missing in model
    DpDestination,
    #[allow(missing_docs)] // documentation missing in model
    SyncDestination,
    #[allow(missing_docs)] // documentation missing in model
    SyncSource,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StorageVirtualMachineSubtype {
    fn from(s: &str) -> Self {
        match s {
            "DEFAULT" => StorageVirtualMachineSubtype::Default,
            "DP_DESTINATION" => StorageVirtualMachineSubtype::DpDestination,
            "SYNC_DESTINATION" => StorageVirtualMachineSubtype::SyncDestination,
            "SYNC_SOURCE" => StorageVirtualMachineSubtype::SyncSource,
            other => StorageVirtualMachineSubtype::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StorageVirtualMachineSubtype {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StorageVirtualMachineSubtype::from(s))
    }
}
impl StorageVirtualMachineSubtype {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StorageVirtualMachineSubtype::Default => "DEFAULT",
            StorageVirtualMachineSubtype::DpDestination => "DP_DESTINATION",
            StorageVirtualMachineSubtype::SyncDestination => "SYNC_DESTINATION",
            StorageVirtualMachineSubtype::SyncSource => "SYNC_SOURCE",
            StorageVirtualMachineSubtype::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DEFAULT",
            "DP_DESTINATION",
            "SYNC_DESTINATION",
            "SYNC_SOURCE",
        ]
    }
}
impl AsRef<str> for StorageVirtualMachineSubtype {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StorageVirtualMachineLifecycle {
    #[allow(missing_docs)] // documentation missing in model
    Created,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Misconfigured,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StorageVirtualMachineLifecycle {
    fn from(s: &str) -> Self {
        match s {
            "CREATED" => StorageVirtualMachineLifecycle::Created,
            "CREATING" => StorageVirtualMachineLifecycle::Creating,
            "DELETING" => StorageVirtualMachineLifecycle::Deleting,
            "FAILED" => StorageVirtualMachineLifecycle::Failed,
            "MISCONFIGURED" => StorageVirtualMachineLifecycle::Misconfigured,
            "PENDING" => StorageVirtualMachineLifecycle::Pending,
            other => StorageVirtualMachineLifecycle::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StorageVirtualMachineLifecycle {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StorageVirtualMachineLifecycle::from(s))
    }
}
impl StorageVirtualMachineLifecycle {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StorageVirtualMachineLifecycle::Created => "CREATED",
            StorageVirtualMachineLifecycle::Creating => "CREATING",
            StorageVirtualMachineLifecycle::Deleting => "DELETING",
            StorageVirtualMachineLifecycle::Failed => "FAILED",
            StorageVirtualMachineLifecycle::Misconfigured => "MISCONFIGURED",
            StorageVirtualMachineLifecycle::Pending => "PENDING",
            StorageVirtualMachineLifecycle::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATED",
            "CREATING",
            "DELETING",
            "FAILED",
            "MISCONFIGURED",
            "PENDING",
        ]
    }
}
impl AsRef<str> for StorageVirtualMachineLifecycle {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An Amazon FSx for NetApp ONTAP storage virtual machine (SVM) has
/// the following endpoints that are used to access data or to manage
/// the SVM using the NetApp ONTAP CLI, REST API, or NetApp CloudManager.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SvmEndpoints {
    /// <p>An endpoint for connecting using the Internet Small Computer Systems Interface (iSCSI)  protocol.</p>
    pub iscsi: std::option::Option<crate::model::SvmEndpoint>,
    /// <p>An endpoint for managing SVMs using the NetApp ONTAP CLI, NetApp ONTAP API, or NetApp CloudManager.</p>
    pub management: std::option::Option<crate::model::SvmEndpoint>,
    /// <p>An endpoint for connecting using the Network File System (NFS) protocol.</p>
    pub nfs: std::option::Option<crate::model::SvmEndpoint>,
    /// <p>An endpoint for connecting using the Server Message Block (SMB) protocol.</p>
    pub smb: std::option::Option<crate::model::SvmEndpoint>,
}
impl SvmEndpoints {
    /// <p>An endpoint for connecting using the Internet Small Computer Systems Interface (iSCSI)  protocol.</p>
    pub fn iscsi(&self) -> std::option::Option<&crate::model::SvmEndpoint> {
        self.iscsi.as_ref()
    }
    /// <p>An endpoint for managing SVMs using the NetApp ONTAP CLI, NetApp ONTAP API, or NetApp CloudManager.</p>
    pub fn management(&self) -> std::option::Option<&crate::model::SvmEndpoint> {
        self.management.as_ref()
    }
    /// <p>An endpoint for connecting using the Network File System (NFS) protocol.</p>
    pub fn nfs(&self) -> std::option::Option<&crate::model::SvmEndpoint> {
        self.nfs.as_ref()
    }
    /// <p>An endpoint for connecting using the Server Message Block (SMB) protocol.</p>
    pub fn smb(&self) -> std::option::Option<&crate::model::SvmEndpoint> {
        self.smb.as_ref()
    }
}
impl std::fmt::Debug for SvmEndpoints {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SvmEndpoints");
        formatter.field("iscsi", &self.iscsi);
        formatter.field("management", &self.management);
        formatter.field("nfs", &self.nfs);
        formatter.field("smb", &self.smb);
        formatter.finish()
    }
}
/// See [`SvmEndpoints`](crate::model::SvmEndpoints)
pub mod svm_endpoints {
    /// A builder for [`SvmEndpoints`](crate::model::SvmEndpoints)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) iscsi: std::option::Option<crate::model::SvmEndpoint>,
        pub(crate) management: std::option::Option<crate::model::SvmEndpoint>,
        pub(crate) nfs: std::option::Option<crate::model::SvmEndpoint>,
        pub(crate) smb: std::option::Option<crate::model::SvmEndpoint>,
    }
    impl Builder {
        /// <p>An endpoint for connecting using the Internet Small Computer Systems Interface (iSCSI)  protocol.</p>
        pub fn iscsi(mut self, input: crate::model::SvmEndpoint) -> Self {
            self.iscsi = Some(input);
            self
        }
        /// <p>An endpoint for connecting using the Internet Small Computer Systems Interface (iSCSI)  protocol.</p>
        pub fn set_iscsi(mut self, input: std::option::Option<crate::model::SvmEndpoint>) -> Self {
            self.iscsi = input;
            self
        }
        /// <p>An endpoint for managing SVMs using the NetApp ONTAP CLI, NetApp ONTAP API, or NetApp CloudManager.</p>
        pub fn management(mut self, input: crate::model::SvmEndpoint) -> Self {
            self.management = Some(input);
            self
        }
        /// <p>An endpoint for managing SVMs using the NetApp ONTAP CLI, NetApp ONTAP API, or NetApp CloudManager.</p>
        pub fn set_management(
            mut self,
            input: std::option::Option<crate::model::SvmEndpoint>,
        ) -> Self {
            self.management = input;
            self
        }
        /// <p>An endpoint for connecting using the Network File System (NFS) protocol.</p>
        pub fn nfs(mut self, input: crate::model::SvmEndpoint) -> Self {
            self.nfs = Some(input);
            self
        }
        /// <p>An endpoint for connecting using the Network File System (NFS) protocol.</p>
        pub fn set_nfs(mut self, input: std::option::Option<crate::model::SvmEndpoint>) -> Self {
            self.nfs = input;
            self
        }
        /// <p>An endpoint for connecting using the Server Message Block (SMB) protocol.</p>
        pub fn smb(mut self, input: crate::model::SvmEndpoint) -> Self {
            self.smb = Some(input);
            self
        }
        /// <p>An endpoint for connecting using the Server Message Block (SMB) protocol.</p>
        pub fn set_smb(mut self, input: std::option::Option<crate::model::SvmEndpoint>) -> Self {
            self.smb = input;
            self
        }
        /// Consumes the builder and constructs a [`SvmEndpoints`](crate::model::SvmEndpoints)
        pub fn build(self) -> crate::model::SvmEndpoints {
            crate::model::SvmEndpoints {
                iscsi: self.iscsi,
                management: self.management,
                nfs: self.nfs,
                smb: self.smb,
            }
        }
    }
}
impl SvmEndpoints {
    /// Creates a new builder-style object to manufacture [`SvmEndpoints`](crate::model::SvmEndpoints)
    pub fn builder() -> crate::model::svm_endpoints::Builder {
        crate::model::svm_endpoints::Builder::default()
    }
}

/// <p>An Amazon FSx for NetApp ONTAP storage virtual machine (SVM) has
/// four endpoints  that are used to access data or to manage the SVM
/// using the NetApp ONTAP CLI, REST API, or NetApp CloudManager. They
/// are the <code>Iscsi</code>, <code>Management</code>, <code>Nfs</code>,
/// and <code>Smb</code> endpoints.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SvmEndpoint {
    /// <p>The Domain Name Service (DNS) name for the file system. You can mount your file
    /// system using its DNS name.</p>
    pub dns_name: std::option::Option<std::string::String>,
    /// <p>The SVM endpoint's IP addresses.</p>
    pub ip_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl SvmEndpoint {
    /// <p>The Domain Name Service (DNS) name for the file system. You can mount your file
    /// system using its DNS name.</p>
    pub fn dns_name(&self) -> std::option::Option<&str> {
        self.dns_name.as_deref()
    }
    /// <p>The SVM endpoint's IP addresses.</p>
    pub fn ip_addresses(&self) -> std::option::Option<&[std::string::String]> {
        self.ip_addresses.as_deref()
    }
}
impl std::fmt::Debug for SvmEndpoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SvmEndpoint");
        formatter.field("dns_name", &self.dns_name);
        formatter.field("ip_addresses", &self.ip_addresses);
        formatter.finish()
    }
}
/// See [`SvmEndpoint`](crate::model::SvmEndpoint)
pub mod svm_endpoint {
    /// A builder for [`SvmEndpoint`](crate::model::SvmEndpoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dns_name: std::option::Option<std::string::String>,
        pub(crate) ip_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Domain Name Service (DNS) name for the file system. You can mount your file
        /// system using its DNS name.</p>
        pub fn dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dns_name = Some(input.into());
            self
        }
        /// <p>The Domain Name Service (DNS) name for the file system. You can mount your file
        /// system using its DNS name.</p>
        pub fn set_dns_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dns_name = input;
            self
        }
        /// Appends an item to `ip_addresses`.
        ///
        /// To override the contents of this collection use [`set_ip_addresses`](Self::set_ip_addresses).
        ///
        /// <p>The SVM endpoint's IP addresses.</p>
        pub fn ip_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ip_addresses.unwrap_or_default();
            v.push(input.into());
            self.ip_addresses = Some(v);
            self
        }
        /// <p>The SVM endpoint's IP addresses.</p>
        pub fn set_ip_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ip_addresses = input;
            self
        }
        /// Consumes the builder and constructs a [`SvmEndpoint`](crate::model::SvmEndpoint)
        pub fn build(self) -> crate::model::SvmEndpoint {
            crate::model::SvmEndpoint {
                dns_name: self.dns_name,
                ip_addresses: self.ip_addresses,
            }
        }
    }
}
impl SvmEndpoint {
    /// Creates a new builder-style object to manufacture [`SvmEndpoint`](crate::model::SvmEndpoint)
    pub fn builder() -> crate::model::svm_endpoint::Builder {
        crate::model::svm_endpoint::Builder::default()
    }
}

/// <p>Describes the configuration of the Microsoft Active Directory (AD)
/// directory to which the Amazon FSx for ONTAP storage virtual machine (SVM) is joined.
/// Pleae note, account credentials are not returned in the response payload.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SvmActiveDirectoryConfiguration {
    /// <p>The NetBIOS name of the Active Directory computer object that is joined to your SVM.</p>
    pub net_bios_name: std::option::Option<std::string::String>,
    /// <p>The configuration of the self-managed Microsoft Active Directory (AD) directory to
    /// which the Windows File Server or ONTAP storage virtual machine (SVM) instance is joined.</p>
    pub self_managed_active_directory_configuration:
        std::option::Option<crate::model::SelfManagedActiveDirectoryAttributes>,
}
impl SvmActiveDirectoryConfiguration {
    /// <p>The NetBIOS name of the Active Directory computer object that is joined to your SVM.</p>
    pub fn net_bios_name(&self) -> std::option::Option<&str> {
        self.net_bios_name.as_deref()
    }
    /// <p>The configuration of the self-managed Microsoft Active Directory (AD) directory to
    /// which the Windows File Server or ONTAP storage virtual machine (SVM) instance is joined.</p>
    pub fn self_managed_active_directory_configuration(
        &self,
    ) -> std::option::Option<&crate::model::SelfManagedActiveDirectoryAttributes> {
        self.self_managed_active_directory_configuration.as_ref()
    }
}
impl std::fmt::Debug for SvmActiveDirectoryConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SvmActiveDirectoryConfiguration");
        formatter.field("net_bios_name", &self.net_bios_name);
        formatter.field(
            "self_managed_active_directory_configuration",
            &self.self_managed_active_directory_configuration,
        );
        formatter.finish()
    }
}
/// See [`SvmActiveDirectoryConfiguration`](crate::model::SvmActiveDirectoryConfiguration)
pub mod svm_active_directory_configuration {
    /// A builder for [`SvmActiveDirectoryConfiguration`](crate::model::SvmActiveDirectoryConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) net_bios_name: std::option::Option<std::string::String>,
        pub(crate) self_managed_active_directory_configuration:
            std::option::Option<crate::model::SelfManagedActiveDirectoryAttributes>,
    }
    impl Builder {
        /// <p>The NetBIOS name of the Active Directory computer object that is joined to your SVM.</p>
        pub fn net_bios_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.net_bios_name = Some(input.into());
            self
        }
        /// <p>The NetBIOS name of the Active Directory computer object that is joined to your SVM.</p>
        pub fn set_net_bios_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.net_bios_name = input;
            self
        }
        /// <p>The configuration of the self-managed Microsoft Active Directory (AD) directory to
        /// which the Windows File Server or ONTAP storage virtual machine (SVM) instance is joined.</p>
        pub fn self_managed_active_directory_configuration(
            mut self,
            input: crate::model::SelfManagedActiveDirectoryAttributes,
        ) -> Self {
            self.self_managed_active_directory_configuration = Some(input);
            self
        }
        /// <p>The configuration of the self-managed Microsoft Active Directory (AD) directory to
        /// which the Windows File Server or ONTAP storage virtual machine (SVM) instance is joined.</p>
        pub fn set_self_managed_active_directory_configuration(
            mut self,
            input: std::option::Option<crate::model::SelfManagedActiveDirectoryAttributes>,
        ) -> Self {
            self.self_managed_active_directory_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`SvmActiveDirectoryConfiguration`](crate::model::SvmActiveDirectoryConfiguration)
        pub fn build(self) -> crate::model::SvmActiveDirectoryConfiguration {
            crate::model::SvmActiveDirectoryConfiguration {
                net_bios_name: self.net_bios_name,
                self_managed_active_directory_configuration: self
                    .self_managed_active_directory_configuration,
            }
        }
    }
}
impl SvmActiveDirectoryConfiguration {
    /// Creates a new builder-style object to manufacture [`SvmActiveDirectoryConfiguration`](crate::model::SvmActiveDirectoryConfiguration)
    pub fn builder() -> crate::model::svm_active_directory_configuration::Builder {
        crate::model::svm_active_directory_configuration::Builder::default()
    }
}

/// <p>The configuration of the self-managed Microsoft Active Directory (AD) directory to
/// which the Windows File Server or ONTAP storage virtual machine (SVM) instance is joined.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SelfManagedActiveDirectoryAttributes {
    /// <p>The fully qualified domain name of the self-managed AD directory.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The fully qualified distinguished name of the organizational unit within the
    /// self-managed AD directory to which the Windows File Server  or ONTAP storage virtual machine (SVM) instance is joined.</p>
    pub organizational_unit_distinguished_name: std::option::Option<std::string::String>,
    /// <p>The name of the domain group whose members have administrative privileges for the FSx
    /// file system.</p>
    pub file_system_administrators_group: std::option::Option<std::string::String>,
    /// <p>The user name for the service account on your self-managed AD domain that FSx uses to
    /// join to your AD domain.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>A list of up to three IP addresses of DNS servers or domain controllers in the
    /// self-managed AD directory.</p>
    pub dns_ips: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl SelfManagedActiveDirectoryAttributes {
    /// <p>The fully qualified domain name of the self-managed AD directory.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The fully qualified distinguished name of the organizational unit within the
    /// self-managed AD directory to which the Windows File Server  or ONTAP storage virtual machine (SVM) instance is joined.</p>
    pub fn organizational_unit_distinguished_name(&self) -> std::option::Option<&str> {
        self.organizational_unit_distinguished_name.as_deref()
    }
    /// <p>The name of the domain group whose members have administrative privileges for the FSx
    /// file system.</p>
    pub fn file_system_administrators_group(&self) -> std::option::Option<&str> {
        self.file_system_administrators_group.as_deref()
    }
    /// <p>The user name for the service account on your self-managed AD domain that FSx uses to
    /// join to your AD domain.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>A list of up to three IP addresses of DNS servers or domain controllers in the
    /// self-managed AD directory.</p>
    pub fn dns_ips(&self) -> std::option::Option<&[std::string::String]> {
        self.dns_ips.as_deref()
    }
}
impl std::fmt::Debug for SelfManagedActiveDirectoryAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SelfManagedActiveDirectoryAttributes");
        formatter.field("domain_name", &self.domain_name);
        formatter.field(
            "organizational_unit_distinguished_name",
            &self.organizational_unit_distinguished_name,
        );
        formatter.field(
            "file_system_administrators_group",
            &self.file_system_administrators_group,
        );
        formatter.field("user_name", &self.user_name);
        formatter.field("dns_ips", &self.dns_ips);
        formatter.finish()
    }
}
/// See [`SelfManagedActiveDirectoryAttributes`](crate::model::SelfManagedActiveDirectoryAttributes)
pub mod self_managed_active_directory_attributes {
    /// A builder for [`SelfManagedActiveDirectoryAttributes`](crate::model::SelfManagedActiveDirectoryAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) organizational_unit_distinguished_name: std::option::Option<std::string::String>,
        pub(crate) file_system_administrators_group: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) dns_ips: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The fully qualified domain name of the self-managed AD directory.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The fully qualified domain name of the self-managed AD directory.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The fully qualified distinguished name of the organizational unit within the
        /// self-managed AD directory to which the Windows File Server  or ONTAP storage virtual machine (SVM) instance is joined.</p>
        pub fn organizational_unit_distinguished_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.organizational_unit_distinguished_name = Some(input.into());
            self
        }
        /// <p>The fully qualified distinguished name of the organizational unit within the
        /// self-managed AD directory to which the Windows File Server  or ONTAP storage virtual machine (SVM) instance is joined.</p>
        pub fn set_organizational_unit_distinguished_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organizational_unit_distinguished_name = input;
            self
        }
        /// <p>The name of the domain group whose members have administrative privileges for the FSx
        /// file system.</p>
        pub fn file_system_administrators_group(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.file_system_administrators_group = Some(input.into());
            self
        }
        /// <p>The name of the domain group whose members have administrative privileges for the FSx
        /// file system.</p>
        pub fn set_file_system_administrators_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_administrators_group = input;
            self
        }
        /// <p>The user name for the service account on your self-managed AD domain that FSx uses to
        /// join to your AD domain.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The user name for the service account on your self-managed AD domain that FSx uses to
        /// join to your AD domain.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// Appends an item to `dns_ips`.
        ///
        /// To override the contents of this collection use [`set_dns_ips`](Self::set_dns_ips).
        ///
        /// <p>A list of up to three IP addresses of DNS servers or domain controllers in the
        /// self-managed AD directory.</p>
        pub fn dns_ips(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.dns_ips.unwrap_or_default();
            v.push(input.into());
            self.dns_ips = Some(v);
            self
        }
        /// <p>A list of up to three IP addresses of DNS servers or domain controllers in the
        /// self-managed AD directory.</p>
        pub fn set_dns_ips(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.dns_ips = input;
            self
        }
        /// Consumes the builder and constructs a [`SelfManagedActiveDirectoryAttributes`](crate::model::SelfManagedActiveDirectoryAttributes)
        pub fn build(self) -> crate::model::SelfManagedActiveDirectoryAttributes {
            crate::model::SelfManagedActiveDirectoryAttributes {
                domain_name: self.domain_name,
                organizational_unit_distinguished_name: self.organizational_unit_distinguished_name,
                file_system_administrators_group: self.file_system_administrators_group,
                user_name: self.user_name,
                dns_ips: self.dns_ips,
            }
        }
    }
}
impl SelfManagedActiveDirectoryAttributes {
    /// Creates a new builder-style object to manufacture [`SelfManagedActiveDirectoryAttributes`](crate::model::SelfManagedActiveDirectoryAttributes)
    pub fn builder() -> crate::model::self_managed_active_directory_attributes::Builder {
        crate::model::self_managed_active_directory_attributes::Builder::default()
    }
}

/// <p>Updates the Microsoft Active Directory (AD) configuration of an SVM joined to an AD.
/// Pleae note, account credentials are not returned in the response payload.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSvmActiveDirectoryConfiguration {
    /// <p>The configuration that Amazon FSx uses to join the Windows File Server instance to a
    /// self-managed Microsoft Active Directory (AD) directory.</p>
    pub self_managed_active_directory_configuration:
        std::option::Option<crate::model::SelfManagedActiveDirectoryConfigurationUpdates>,
}
impl UpdateSvmActiveDirectoryConfiguration {
    /// <p>The configuration that Amazon FSx uses to join the Windows File Server instance to a
    /// self-managed Microsoft Active Directory (AD) directory.</p>
    pub fn self_managed_active_directory_configuration(
        &self,
    ) -> std::option::Option<&crate::model::SelfManagedActiveDirectoryConfigurationUpdates> {
        self.self_managed_active_directory_configuration.as_ref()
    }
}
impl std::fmt::Debug for UpdateSvmActiveDirectoryConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSvmActiveDirectoryConfiguration");
        formatter.field(
            "self_managed_active_directory_configuration",
            &self.self_managed_active_directory_configuration,
        );
        formatter.finish()
    }
}
/// See [`UpdateSvmActiveDirectoryConfiguration`](crate::model::UpdateSvmActiveDirectoryConfiguration)
pub mod update_svm_active_directory_configuration {
    /// A builder for [`UpdateSvmActiveDirectoryConfiguration`](crate::model::UpdateSvmActiveDirectoryConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) self_managed_active_directory_configuration:
            std::option::Option<crate::model::SelfManagedActiveDirectoryConfigurationUpdates>,
    }
    impl Builder {
        /// <p>The configuration that Amazon FSx uses to join the Windows File Server instance to a
        /// self-managed Microsoft Active Directory (AD) directory.</p>
        pub fn self_managed_active_directory_configuration(
            mut self,
            input: crate::model::SelfManagedActiveDirectoryConfigurationUpdates,
        ) -> Self {
            self.self_managed_active_directory_configuration = Some(input);
            self
        }
        /// <p>The configuration that Amazon FSx uses to join the Windows File Server instance to a
        /// self-managed Microsoft Active Directory (AD) directory.</p>
        pub fn set_self_managed_active_directory_configuration(
            mut self,
            input: std::option::Option<
                crate::model::SelfManagedActiveDirectoryConfigurationUpdates,
            >,
        ) -> Self {
            self.self_managed_active_directory_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSvmActiveDirectoryConfiguration`](crate::model::UpdateSvmActiveDirectoryConfiguration)
        pub fn build(self) -> crate::model::UpdateSvmActiveDirectoryConfiguration {
            crate::model::UpdateSvmActiveDirectoryConfiguration {
                self_managed_active_directory_configuration: self
                    .self_managed_active_directory_configuration,
            }
        }
    }
}
impl UpdateSvmActiveDirectoryConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateSvmActiveDirectoryConfiguration`](crate::model::UpdateSvmActiveDirectoryConfiguration)
    pub fn builder() -> crate::model::update_svm_active_directory_configuration::Builder {
        crate::model::update_svm_active_directory_configuration::Builder::default()
    }
}

/// <p>The configuration that Amazon FSx uses to join the Windows File Server instance to a
/// self-managed Microsoft Active Directory (AD) directory.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SelfManagedActiveDirectoryConfigurationUpdates {
    /// <p>The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to
    /// your AD domain. This account must have the permission to join
    /// computers to the domain in the organizational unit provided in
    /// <code>OrganizationalUnitDistinguishedName</code>.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The password for the service account on your self-managed AD domain that Amazon FSx will use to join to
    /// your AD domain.</p>
    pub password: std::option::Option<std::string::String>,
    /// <p>A list of up to three IP addresses of DNS servers or domain controllers in the
    /// self-managed AD directory.</p>
    pub dns_ips: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl SelfManagedActiveDirectoryConfigurationUpdates {
    /// <p>The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to
    /// your AD domain. This account must have the permission to join
    /// computers to the domain in the organizational unit provided in
    /// <code>OrganizationalUnitDistinguishedName</code>.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>The password for the service account on your self-managed AD domain that Amazon FSx will use to join to
    /// your AD domain.</p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
    /// <p>A list of up to three IP addresses of DNS servers or domain controllers in the
    /// self-managed AD directory.</p>
    pub fn dns_ips(&self) -> std::option::Option<&[std::string::String]> {
        self.dns_ips.as_deref()
    }
}
impl std::fmt::Debug for SelfManagedActiveDirectoryConfigurationUpdates {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SelfManagedActiveDirectoryConfigurationUpdates");
        formatter.field("user_name", &self.user_name);
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.field("dns_ips", &self.dns_ips);
        formatter.finish()
    }
}
/// See [`SelfManagedActiveDirectoryConfigurationUpdates`](crate::model::SelfManagedActiveDirectoryConfigurationUpdates)
pub mod self_managed_active_directory_configuration_updates {
    /// A builder for [`SelfManagedActiveDirectoryConfigurationUpdates`](crate::model::SelfManagedActiveDirectoryConfigurationUpdates)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) dns_ips: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to
        /// your AD domain. This account must have the permission to join
        /// computers to the domain in the organizational unit provided in
        /// <code>OrganizationalUnitDistinguishedName</code>.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to
        /// your AD domain. This account must have the permission to join
        /// computers to the domain in the organizational unit provided in
        /// <code>OrganizationalUnitDistinguishedName</code>.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The password for the service account on your self-managed AD domain that Amazon FSx will use to join to
        /// your AD domain.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>The password for the service account on your self-managed AD domain that Amazon FSx will use to join to
        /// your AD domain.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// Appends an item to `dns_ips`.
        ///
        /// To override the contents of this collection use [`set_dns_ips`](Self::set_dns_ips).
        ///
        /// <p>A list of up to three IP addresses of DNS servers or domain controllers in the
        /// self-managed AD directory.</p>
        pub fn dns_ips(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.dns_ips.unwrap_or_default();
            v.push(input.into());
            self.dns_ips = Some(v);
            self
        }
        /// <p>A list of up to three IP addresses of DNS servers or domain controllers in the
        /// self-managed AD directory.</p>
        pub fn set_dns_ips(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.dns_ips = input;
            self
        }
        /// Consumes the builder and constructs a [`SelfManagedActiveDirectoryConfigurationUpdates`](crate::model::SelfManagedActiveDirectoryConfigurationUpdates)
        pub fn build(self) -> crate::model::SelfManagedActiveDirectoryConfigurationUpdates {
            crate::model::SelfManagedActiveDirectoryConfigurationUpdates {
                user_name: self.user_name,
                password: self.password,
                dns_ips: self.dns_ips,
            }
        }
    }
}
impl SelfManagedActiveDirectoryConfigurationUpdates {
    /// Creates a new builder-style object to manufacture [`SelfManagedActiveDirectoryConfigurationUpdates`](crate::model::SelfManagedActiveDirectoryConfigurationUpdates)
    pub fn builder() -> crate::model::self_managed_active_directory_configuration_updates::Builder {
        crate::model::self_managed_active_directory_configuration_updates::Builder::default()
    }
}

/// <p>The types of limits on your service utilization. Limits include file system count,
/// total throughput capacity, total storage, and total user-initiated backups. These limits
/// apply for a specific account in a specific Amazon Web Services Region. You can increase some of them by
/// contacting Amazon Web Services Support.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServiceLimit {
    #[allow(missing_docs)] // documentation missing in model
    FileSystemCount,
    #[allow(missing_docs)] // documentation missing in model
    StorageVirtualMachinesPerFileSystem,
    #[allow(missing_docs)] // documentation missing in model
    TotalInProgressCopyBackups,
    #[allow(missing_docs)] // documentation missing in model
    TotalSsdIops,
    #[allow(missing_docs)] // documentation missing in model
    TotalStorage,
    #[allow(missing_docs)] // documentation missing in model
    TotalThroughputCapacity,
    #[allow(missing_docs)] // documentation missing in model
    TotalUserInitiatedBackups,
    #[allow(missing_docs)] // documentation missing in model
    TotalUserTags,
    #[allow(missing_docs)] // documentation missing in model
    VolumesPerFileSystem,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServiceLimit {
    fn from(s: &str) -> Self {
        match s {
            "FILE_SYSTEM_COUNT" => ServiceLimit::FileSystemCount,
            "STORAGE_VIRTUAL_MACHINES_PER_FILE_SYSTEM" => {
                ServiceLimit::StorageVirtualMachinesPerFileSystem
            }
            "TOTAL_IN_PROGRESS_COPY_BACKUPS" => ServiceLimit::TotalInProgressCopyBackups,
            "TOTAL_SSD_IOPS" => ServiceLimit::TotalSsdIops,
            "TOTAL_STORAGE" => ServiceLimit::TotalStorage,
            "TOTAL_THROUGHPUT_CAPACITY" => ServiceLimit::TotalThroughputCapacity,
            "TOTAL_USER_INITIATED_BACKUPS" => ServiceLimit::TotalUserInitiatedBackups,
            "TOTAL_USER_TAGS" => ServiceLimit::TotalUserTags,
            "VOLUMES_PER_FILE_SYSTEM" => ServiceLimit::VolumesPerFileSystem,
            other => ServiceLimit::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServiceLimit {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServiceLimit::from(s))
    }
}
impl ServiceLimit {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServiceLimit::FileSystemCount => "FILE_SYSTEM_COUNT",
            ServiceLimit::StorageVirtualMachinesPerFileSystem => {
                "STORAGE_VIRTUAL_MACHINES_PER_FILE_SYSTEM"
            }
            ServiceLimit::TotalInProgressCopyBackups => "TOTAL_IN_PROGRESS_COPY_BACKUPS",
            ServiceLimit::TotalSsdIops => "TOTAL_SSD_IOPS",
            ServiceLimit::TotalStorage => "TOTAL_STORAGE",
            ServiceLimit::TotalThroughputCapacity => "TOTAL_THROUGHPUT_CAPACITY",
            ServiceLimit::TotalUserInitiatedBackups => "TOTAL_USER_INITIATED_BACKUPS",
            ServiceLimit::TotalUserTags => "TOTAL_USER_TAGS",
            ServiceLimit::VolumesPerFileSystem => "VOLUMES_PER_FILE_SYSTEM",
            ServiceLimit::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "FILE_SYSTEM_COUNT",
            "STORAGE_VIRTUAL_MACHINES_PER_FILE_SYSTEM",
            "TOTAL_IN_PROGRESS_COPY_BACKUPS",
            "TOTAL_SSD_IOPS",
            "TOTAL_STORAGE",
            "TOTAL_THROUGHPUT_CAPACITY",
            "TOTAL_USER_INITIATED_BACKUPS",
            "TOTAL_USER_TAGS",
            "VOLUMES_PER_FILE_SYSTEM",
        ]
    }
}
impl AsRef<str> for ServiceLimit {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A description of a specific Amazon FSx file system.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FileSystem {
    /// <p>The Amazon Web Services account that created the file system. If the file system was created by an
    /// Identity and Access Management (IAM) user, the Amazon Web Services account to which the
    /// IAM user belongs is the owner.</p>
    pub owner_id: std::option::Option<std::string::String>,
    /// <p>The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z),
    /// also known as Unix time.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The system-generated, unique 17-digit ID of the file system.</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>The type of Amazon FSx file system, which can be <code>LUSTRE</code>, <code>WINDOWS</code>,
    /// or <code>ONTAP</code>.</p>
    pub file_system_type: std::option::Option<crate::model::FileSystemType>,
    /// <p>The lifecycle status of the file system, following are the possible values and what they mean:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>AVAILABLE</code> - The file system is in a healthy state, and is reachable and available for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATING</code> - Amazon FSx is creating the new file system.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETING</code> - Amazon FSx is deleting an existing file system.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - An existing file system has experienced an unrecoverable failure.
    /// When creating a new file system, Amazon FSx was unable to create the file system.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MISCONFIGURED</code> indicates that the file system is in a failed but recoverable state.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATING</code> indicates that the file system is undergoing a customer initiated update.</p>
    /// </li>
    /// </ul>
    pub lifecycle: std::option::Option<crate::model::FileSystemLifecycle>,
    /// <p>A structure providing details of any failures that occur when creating the file system
    /// has failed.</p>
    pub failure_details: std::option::Option<crate::model::FileSystemFailureDetails>,
    /// <p>The storage capacity of the file system in gibibytes (GiB).</p>
    pub storage_capacity: std::option::Option<i32>,
    /// <p>The storage type of the file system.
    /// Valid values are <code>SSD</code> and <code>HDD</code>.
    /// If set to <code>SSD</code>, the file system uses solid state drive storage.
    /// If set to <code>HDD</code>, the file system uses hard disk drive storage.
    /// </p>
    pub storage_type: std::option::Option<crate::model::StorageType>,
    /// <p>The ID of the primary VPC for the file system.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>Specifies the IDs of the subnets that the file system is accessible from. For Windows and
    /// ONTAP <code>MULTI_AZ_1</code> file system deployment type, there are two subnet IDs, one for
    /// the preferred file server and one for the standby file server. The preferred file server subnet
    /// identified in the <code>PreferredSubnetID</code> property. All other file systems have only one subnet ID.</p>
    /// <p>For Lustre file systems, and Single-AZ Windows file systems, this is the ID of
    /// the subnet that contains the endpoint for the file system. For <code>MULTI_AZ_1</code> Windows and
    /// ONTAP file systems, the endpoint for the file system is available in the <code>PreferredSubnetID</code>.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The IDs of the elastic network interface from which a specific file system is
    /// accessible. The elastic network interface is automatically created in the same VPC that
    /// the Amazon FSx file system was created in. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html">Elastic Network
    /// Interfaces</a> in the <i>Amazon EC2 User Guide.</i>
    /// </p>
    ///
    /// <p>For an Amazon FSx for Windows File Server file system, you can have one network
    /// interface ID. For an Amazon FSx for Lustre file system, you can have more than
    /// one.</p>
    pub network_interface_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The DNS name for the file system.</p>
    pub dns_name: std::option::Option<std::string::String>,
    /// <p>The ID of the Key Management Service (KMS) key used to encrypt the file system's data
    /// for Amazon FSx for Windows File Server file systems, Amazon FSx for NetApp ONTAP file systems, and
    /// persistent Amazon FSx for Lustre file systems at rest. If not specified, the Amazon FSx
    /// managed key is used. The scratch Amazon FSx for Lustre file systems are always encrypted at rest using
    /// Amazon FSx managed keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html">Encrypt</a>
    /// in the <i>Key Management Service API Reference</i>.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the file system resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags to associate with the file system. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your
    /// Amazon EC2 Resources</a> in the <i>Amazon EC2 User
    /// Guide</i>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The configuration for this Microsoft Windows file system.</p>
    pub windows_configuration: std::option::Option<crate::model::WindowsFileSystemConfiguration>,
    /// <p>The configuration for the Amazon FSx for Lustre file system.</p>
    pub lustre_configuration: std::option::Option<crate::model::LustreFileSystemConfiguration>,
    /// <p>A list of administrative actions for the file system that are in process or waiting to be processed.
    /// Administrative actions describe changes to the Amazon FSx file system that you have initiated using
    /// the <code>UpdateFileSystem</code> action.</p>
    pub administrative_actions:
        std::option::Option<std::vec::Vec<crate::model::AdministrativeAction>>,
    /// <p>The configuration for this FSx for NetApp ONTAP file system.</p>
    pub ontap_configuration: std::option::Option<crate::model::OntapFileSystemConfiguration>,
    /// <p>The version of your Amazon FSx for Lustre file system, either
    /// <code>2.10</code> or <code>2.12</code>.</p>
    pub file_system_type_version: std::option::Option<std::string::String>,
}
impl FileSystem {
    /// <p>The Amazon Web Services account that created the file system. If the file system was created by an
    /// Identity and Access Management (IAM) user, the Amazon Web Services account to which the
    /// IAM user belongs is the owner.</p>
    pub fn owner_id(&self) -> std::option::Option<&str> {
        self.owner_id.as_deref()
    }
    /// <p>The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z),
    /// also known as Unix time.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
    /// <p>The system-generated, unique 17-digit ID of the file system.</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
    /// <p>The type of Amazon FSx file system, which can be <code>LUSTRE</code>, <code>WINDOWS</code>,
    /// or <code>ONTAP</code>.</p>
    pub fn file_system_type(&self) -> std::option::Option<&crate::model::FileSystemType> {
        self.file_system_type.as_ref()
    }
    /// <p>The lifecycle status of the file system, following are the possible values and what they mean:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>AVAILABLE</code> - The file system is in a healthy state, and is reachable and available for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATING</code> - Amazon FSx is creating the new file system.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETING</code> - Amazon FSx is deleting an existing file system.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - An existing file system has experienced an unrecoverable failure.
    /// When creating a new file system, Amazon FSx was unable to create the file system.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MISCONFIGURED</code> indicates that the file system is in a failed but recoverable state.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATING</code> indicates that the file system is undergoing a customer initiated update.</p>
    /// </li>
    /// </ul>
    pub fn lifecycle(&self) -> std::option::Option<&crate::model::FileSystemLifecycle> {
        self.lifecycle.as_ref()
    }
    /// <p>A structure providing details of any failures that occur when creating the file system
    /// has failed.</p>
    pub fn failure_details(&self) -> std::option::Option<&crate::model::FileSystemFailureDetails> {
        self.failure_details.as_ref()
    }
    /// <p>The storage capacity of the file system in gibibytes (GiB).</p>
    pub fn storage_capacity(&self) -> std::option::Option<i32> {
        self.storage_capacity
    }
    /// <p>The storage type of the file system.
    /// Valid values are <code>SSD</code> and <code>HDD</code>.
    /// If set to <code>SSD</code>, the file system uses solid state drive storage.
    /// If set to <code>HDD</code>, the file system uses hard disk drive storage.
    /// </p>
    pub fn storage_type(&self) -> std::option::Option<&crate::model::StorageType> {
        self.storage_type.as_ref()
    }
    /// <p>The ID of the primary VPC for the file system.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>Specifies the IDs of the subnets that the file system is accessible from. For Windows and
    /// ONTAP <code>MULTI_AZ_1</code> file system deployment type, there are two subnet IDs, one for
    /// the preferred file server and one for the standby file server. The preferred file server subnet
    /// identified in the <code>PreferredSubnetID</code> property. All other file systems have only one subnet ID.</p>
    /// <p>For Lustre file systems, and Single-AZ Windows file systems, this is the ID of
    /// the subnet that contains the endpoint for the file system. For <code>MULTI_AZ_1</code> Windows and
    /// ONTAP file systems, the endpoint for the file system is available in the <code>PreferredSubnetID</code>.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>The IDs of the elastic network interface from which a specific file system is
    /// accessible. The elastic network interface is automatically created in the same VPC that
    /// the Amazon FSx file system was created in. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html">Elastic Network
    /// Interfaces</a> in the <i>Amazon EC2 User Guide.</i>
    /// </p>
    ///
    /// <p>For an Amazon FSx for Windows File Server file system, you can have one network
    /// interface ID. For an Amazon FSx for Lustre file system, you can have more than
    /// one.</p>
    pub fn network_interface_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.network_interface_ids.as_deref()
    }
    /// <p>The DNS name for the file system.</p>
    pub fn dns_name(&self) -> std::option::Option<&str> {
        self.dns_name.as_deref()
    }
    /// <p>The ID of the Key Management Service (KMS) key used to encrypt the file system's data
    /// for Amazon FSx for Windows File Server file systems, Amazon FSx for NetApp ONTAP file systems, and
    /// persistent Amazon FSx for Lustre file systems at rest. If not specified, the Amazon FSx
    /// managed key is used. The scratch Amazon FSx for Lustre file systems are always encrypted at rest using
    /// Amazon FSx managed keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html">Encrypt</a>
    /// in the <i>Key Management Service API Reference</i>.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the file system resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tags to associate with the file system. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your
    /// Amazon EC2 Resources</a> in the <i>Amazon EC2 User
    /// Guide</i>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The configuration for this Microsoft Windows file system.</p>
    pub fn windows_configuration(
        &self,
    ) -> std::option::Option<&crate::model::WindowsFileSystemConfiguration> {
        self.windows_configuration.as_ref()
    }
    /// <p>The configuration for the Amazon FSx for Lustre file system.</p>
    pub fn lustre_configuration(
        &self,
    ) -> std::option::Option<&crate::model::LustreFileSystemConfiguration> {
        self.lustre_configuration.as_ref()
    }
    /// <p>A list of administrative actions for the file system that are in process or waiting to be processed.
    /// Administrative actions describe changes to the Amazon FSx file system that you have initiated using
    /// the <code>UpdateFileSystem</code> action.</p>
    pub fn administrative_actions(
        &self,
    ) -> std::option::Option<&[crate::model::AdministrativeAction]> {
        self.administrative_actions.as_deref()
    }
    /// <p>The configuration for this FSx for NetApp ONTAP file system.</p>
    pub fn ontap_configuration(
        &self,
    ) -> std::option::Option<&crate::model::OntapFileSystemConfiguration> {
        self.ontap_configuration.as_ref()
    }
    /// <p>The version of your Amazon FSx for Lustre file system, either
    /// <code>2.10</code> or <code>2.12</code>.</p>
    pub fn file_system_type_version(&self) -> std::option::Option<&str> {
        self.file_system_type_version.as_deref()
    }
}
impl std::fmt::Debug for FileSystem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FileSystem");
        formatter.field("owner_id", &self.owner_id);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("file_system_type", &self.file_system_type);
        formatter.field("lifecycle", &self.lifecycle);
        formatter.field("failure_details", &self.failure_details);
        formatter.field("storage_capacity", &self.storage_capacity);
        formatter.field("storage_type", &self.storage_type);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("network_interface_ids", &self.network_interface_ids);
        formatter.field("dns_name", &self.dns_name);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.field("windows_configuration", &self.windows_configuration);
        formatter.field("lustre_configuration", &self.lustre_configuration);
        formatter.field("administrative_actions", &self.administrative_actions);
        formatter.field("ontap_configuration", &self.ontap_configuration);
        formatter.field("file_system_type_version", &self.file_system_type_version);
        formatter.finish()
    }
}
/// See [`FileSystem`](crate::model::FileSystem)
pub mod file_system {
    /// A builder for [`FileSystem`](crate::model::FileSystem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner_id: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) file_system_type: std::option::Option<crate::model::FileSystemType>,
        pub(crate) lifecycle: std::option::Option<crate::model::FileSystemLifecycle>,
        pub(crate) failure_details: std::option::Option<crate::model::FileSystemFailureDetails>,
        pub(crate) storage_capacity: std::option::Option<i32>,
        pub(crate) storage_type: std::option::Option<crate::model::StorageType>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) network_interface_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) dns_name: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) windows_configuration:
            std::option::Option<crate::model::WindowsFileSystemConfiguration>,
        pub(crate) lustre_configuration:
            std::option::Option<crate::model::LustreFileSystemConfiguration>,
        pub(crate) administrative_actions:
            std::option::Option<std::vec::Vec<crate::model::AdministrativeAction>>,
        pub(crate) ontap_configuration:
            std::option::Option<crate::model::OntapFileSystemConfiguration>,
        pub(crate) file_system_type_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account that created the file system. If the file system was created by an
        /// Identity and Access Management (IAM) user, the Amazon Web Services account to which the
        /// IAM user belongs is the owner.</p>
        pub fn owner_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account that created the file system. If the file system was created by an
        /// Identity and Access Management (IAM) user, the Amazon Web Services account to which the
        /// IAM user belongs is the owner.</p>
        pub fn set_owner_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner_id = input;
            self
        }
        /// <p>The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z),
        /// also known as Unix time.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z),
        /// also known as Unix time.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The system-generated, unique 17-digit ID of the file system.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>The system-generated, unique 17-digit ID of the file system.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// <p>The type of Amazon FSx file system, which can be <code>LUSTRE</code>, <code>WINDOWS</code>,
        /// or <code>ONTAP</code>.</p>
        pub fn file_system_type(mut self, input: crate::model::FileSystemType) -> Self {
            self.file_system_type = Some(input);
            self
        }
        /// <p>The type of Amazon FSx file system, which can be <code>LUSTRE</code>, <code>WINDOWS</code>,
        /// or <code>ONTAP</code>.</p>
        pub fn set_file_system_type(
            mut self,
            input: std::option::Option<crate::model::FileSystemType>,
        ) -> Self {
            self.file_system_type = input;
            self
        }
        /// <p>The lifecycle status of the file system, following are the possible values and what they mean:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AVAILABLE</code> - The file system is in a healthy state, and is reachable and available for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATING</code> - Amazon FSx is creating the new file system.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code> - Amazon FSx is deleting an existing file system.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - An existing file system has experienced an unrecoverable failure.
        /// When creating a new file system, Amazon FSx was unable to create the file system.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MISCONFIGURED</code> indicates that the file system is in a failed but recoverable state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATING</code> indicates that the file system is undergoing a customer initiated update.</p>
        /// </li>
        /// </ul>
        pub fn lifecycle(mut self, input: crate::model::FileSystemLifecycle) -> Self {
            self.lifecycle = Some(input);
            self
        }
        /// <p>The lifecycle status of the file system, following are the possible values and what they mean:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AVAILABLE</code> - The file system is in a healthy state, and is reachable and available for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATING</code> - Amazon FSx is creating the new file system.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code> - Amazon FSx is deleting an existing file system.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - An existing file system has experienced an unrecoverable failure.
        /// When creating a new file system, Amazon FSx was unable to create the file system.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MISCONFIGURED</code> indicates that the file system is in a failed but recoverable state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATING</code> indicates that the file system is undergoing a customer initiated update.</p>
        /// </li>
        /// </ul>
        pub fn set_lifecycle(
            mut self,
            input: std::option::Option<crate::model::FileSystemLifecycle>,
        ) -> Self {
            self.lifecycle = input;
            self
        }
        /// <p>A structure providing details of any failures that occur when creating the file system
        /// has failed.</p>
        pub fn failure_details(mut self, input: crate::model::FileSystemFailureDetails) -> Self {
            self.failure_details = Some(input);
            self
        }
        /// <p>A structure providing details of any failures that occur when creating the file system
        /// has failed.</p>
        pub fn set_failure_details(
            mut self,
            input: std::option::Option<crate::model::FileSystemFailureDetails>,
        ) -> Self {
            self.failure_details = input;
            self
        }
        /// <p>The storage capacity of the file system in gibibytes (GiB).</p>
        pub fn storage_capacity(mut self, input: i32) -> Self {
            self.storage_capacity = Some(input);
            self
        }
        /// <p>The storage capacity of the file system in gibibytes (GiB).</p>
        pub fn set_storage_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.storage_capacity = input;
            self
        }
        /// <p>The storage type of the file system.
        /// Valid values are <code>SSD</code> and <code>HDD</code>.
        /// If set to <code>SSD</code>, the file system uses solid state drive storage.
        /// If set to <code>HDD</code>, the file system uses hard disk drive storage.
        /// </p>
        pub fn storage_type(mut self, input: crate::model::StorageType) -> Self {
            self.storage_type = Some(input);
            self
        }
        /// <p>The storage type of the file system.
        /// Valid values are <code>SSD</code> and <code>HDD</code>.
        /// If set to <code>SSD</code>, the file system uses solid state drive storage.
        /// If set to <code>HDD</code>, the file system uses hard disk drive storage.
        /// </p>
        pub fn set_storage_type(
            mut self,
            input: std::option::Option<crate::model::StorageType>,
        ) -> Self {
            self.storage_type = input;
            self
        }
        /// <p>The ID of the primary VPC for the file system.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the primary VPC for the file system.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>Specifies the IDs of the subnets that the file system is accessible from. For Windows and
        /// ONTAP <code>MULTI_AZ_1</code> file system deployment type, there are two subnet IDs, one for
        /// the preferred file server and one for the standby file server. The preferred file server subnet
        /// identified in the <code>PreferredSubnetID</code> property. All other file systems have only one subnet ID.</p>
        /// <p>For Lustre file systems, and Single-AZ Windows file systems, this is the ID of
        /// the subnet that contains the endpoint for the file system. For <code>MULTI_AZ_1</code> Windows and
        /// ONTAP file systems, the endpoint for the file system is available in the <code>PreferredSubnetID</code>.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>Specifies the IDs of the subnets that the file system is accessible from. For Windows and
        /// ONTAP <code>MULTI_AZ_1</code> file system deployment type, there are two subnet IDs, one for
        /// the preferred file server and one for the standby file server. The preferred file server subnet
        /// identified in the <code>PreferredSubnetID</code> property. All other file systems have only one subnet ID.</p>
        /// <p>For Lustre file systems, and Single-AZ Windows file systems, this is the ID of
        /// the subnet that contains the endpoint for the file system. For <code>MULTI_AZ_1</code> Windows and
        /// ONTAP file systems, the endpoint for the file system is available in the <code>PreferredSubnetID</code>.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Appends an item to `network_interface_ids`.
        ///
        /// To override the contents of this collection use [`set_network_interface_ids`](Self::set_network_interface_ids).
        ///
        /// <p>The IDs of the elastic network interface from which a specific file system is
        /// accessible. The elastic network interface is automatically created in the same VPC that
        /// the Amazon FSx file system was created in. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html">Elastic Network
        /// Interfaces</a> in the <i>Amazon EC2 User Guide.</i>
        /// </p>
        ///
        /// <p>For an Amazon FSx for Windows File Server file system, you can have one network
        /// interface ID. For an Amazon FSx for Lustre file system, you can have more than
        /// one.</p>
        pub fn network_interface_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.network_interface_ids.unwrap_or_default();
            v.push(input.into());
            self.network_interface_ids = Some(v);
            self
        }
        /// <p>The IDs of the elastic network interface from which a specific file system is
        /// accessible. The elastic network interface is automatically created in the same VPC that
        /// the Amazon FSx file system was created in. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html">Elastic Network
        /// Interfaces</a> in the <i>Amazon EC2 User Guide.</i>
        /// </p>
        ///
        /// <p>For an Amazon FSx for Windows File Server file system, you can have one network
        /// interface ID. For an Amazon FSx for Lustre file system, you can have more than
        /// one.</p>
        pub fn set_network_interface_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.network_interface_ids = input;
            self
        }
        /// <p>The DNS name for the file system.</p>
        pub fn dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dns_name = Some(input.into());
            self
        }
        /// <p>The DNS name for the file system.</p>
        pub fn set_dns_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dns_name = input;
            self
        }
        /// <p>The ID of the Key Management Service (KMS) key used to encrypt the file system's data
        /// for Amazon FSx for Windows File Server file systems, Amazon FSx for NetApp ONTAP file systems, and
        /// persistent Amazon FSx for Lustre file systems at rest. If not specified, the Amazon FSx
        /// managed key is used. The scratch Amazon FSx for Lustre file systems are always encrypted at rest using
        /// Amazon FSx managed keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html">Encrypt</a>
        /// in the <i>Key Management Service API Reference</i>.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID of the Key Management Service (KMS) key used to encrypt the file system's data
        /// for Amazon FSx for Windows File Server file systems, Amazon FSx for NetApp ONTAP file systems, and
        /// persistent Amazon FSx for Lustre file systems at rest. If not specified, the Amazon FSx
        /// managed key is used. The scratch Amazon FSx for Lustre file systems are always encrypted at rest using
        /// Amazon FSx managed keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html">Encrypt</a>
        /// in the <i>Key Management Service API Reference</i>.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the file system resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the file system resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to associate with the file system. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your
        /// Amazon EC2 Resources</a> in the <i>Amazon EC2 User
        /// Guide</i>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to associate with the file system. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your
        /// Amazon EC2 Resources</a> in the <i>Amazon EC2 User
        /// Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The configuration for this Microsoft Windows file system.</p>
        pub fn windows_configuration(
            mut self,
            input: crate::model::WindowsFileSystemConfiguration,
        ) -> Self {
            self.windows_configuration = Some(input);
            self
        }
        /// <p>The configuration for this Microsoft Windows file system.</p>
        pub fn set_windows_configuration(
            mut self,
            input: std::option::Option<crate::model::WindowsFileSystemConfiguration>,
        ) -> Self {
            self.windows_configuration = input;
            self
        }
        /// <p>The configuration for the Amazon FSx for Lustre file system.</p>
        pub fn lustre_configuration(
            mut self,
            input: crate::model::LustreFileSystemConfiguration,
        ) -> Self {
            self.lustre_configuration = Some(input);
            self
        }
        /// <p>The configuration for the Amazon FSx for Lustre file system.</p>
        pub fn set_lustre_configuration(
            mut self,
            input: std::option::Option<crate::model::LustreFileSystemConfiguration>,
        ) -> Self {
            self.lustre_configuration = input;
            self
        }
        /// Appends an item to `administrative_actions`.
        ///
        /// To override the contents of this collection use [`set_administrative_actions`](Self::set_administrative_actions).
        ///
        /// <p>A list of administrative actions for the file system that are in process or waiting to be processed.
        /// Administrative actions describe changes to the Amazon FSx file system that you have initiated using
        /// the <code>UpdateFileSystem</code> action.</p>
        pub fn administrative_actions(
            mut self,
            input: impl Into<crate::model::AdministrativeAction>,
        ) -> Self {
            let mut v = self.administrative_actions.unwrap_or_default();
            v.push(input.into());
            self.administrative_actions = Some(v);
            self
        }
        /// <p>A list of administrative actions for the file system that are in process or waiting to be processed.
        /// Administrative actions describe changes to the Amazon FSx file system that you have initiated using
        /// the <code>UpdateFileSystem</code> action.</p>
        pub fn set_administrative_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AdministrativeAction>>,
        ) -> Self {
            self.administrative_actions = input;
            self
        }
        /// <p>The configuration for this FSx for NetApp ONTAP file system.</p>
        pub fn ontap_configuration(
            mut self,
            input: crate::model::OntapFileSystemConfiguration,
        ) -> Self {
            self.ontap_configuration = Some(input);
            self
        }
        /// <p>The configuration for this FSx for NetApp ONTAP file system.</p>
        pub fn set_ontap_configuration(
            mut self,
            input: std::option::Option<crate::model::OntapFileSystemConfiguration>,
        ) -> Self {
            self.ontap_configuration = input;
            self
        }
        /// <p>The version of your Amazon FSx for Lustre file system, either
        /// <code>2.10</code> or <code>2.12</code>.</p>
        pub fn file_system_type_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_type_version = Some(input.into());
            self
        }
        /// <p>The version of your Amazon FSx for Lustre file system, either
        /// <code>2.10</code> or <code>2.12</code>.</p>
        pub fn set_file_system_type_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_type_version = input;
            self
        }
        /// Consumes the builder and constructs a [`FileSystem`](crate::model::FileSystem)
        pub fn build(self) -> crate::model::FileSystem {
            crate::model::FileSystem {
                owner_id: self.owner_id,
                creation_time: self.creation_time,
                file_system_id: self.file_system_id,
                file_system_type: self.file_system_type,
                lifecycle: self.lifecycle,
                failure_details: self.failure_details,
                storage_capacity: self.storage_capacity,
                storage_type: self.storage_type,
                vpc_id: self.vpc_id,
                subnet_ids: self.subnet_ids,
                network_interface_ids: self.network_interface_ids,
                dns_name: self.dns_name,
                kms_key_id: self.kms_key_id,
                resource_arn: self.resource_arn,
                tags: self.tags,
                windows_configuration: self.windows_configuration,
                lustre_configuration: self.lustre_configuration,
                administrative_actions: self.administrative_actions,
                ontap_configuration: self.ontap_configuration,
                file_system_type_version: self.file_system_type_version,
            }
        }
    }
}
impl FileSystem {
    /// Creates a new builder-style object to manufacture [`FileSystem`](crate::model::FileSystem)
    pub fn builder() -> crate::model::file_system::Builder {
        crate::model::file_system::Builder::default()
    }
}

/// <p>Configuration for the FSx for NetApp ONTAP file system.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OntapFileSystemConfiguration {
    /// <p>The number of days to retain automatic backups. Setting this to 0 disables
    /// automatic backups. You can retain automatic backups for a maximum of 90 days. The default is 0.</p>
    pub automatic_backup_retention_days: std::option::Option<i32>,
    /// <p>A recurring daily time, in the format <code>HH:MM</code>. <code>HH</code> is the
    /// zero-padded hour of the day (0-23), and <code>MM</code> is the zero-padded minute of the
    /// hour. For example, <code>05:00</code> specifies 5 AM daily. </p>
    pub daily_automatic_backup_start_time: std::option::Option<std::string::String>,
    /// <p>The ONTAP file system deployment type.</p>
    pub deployment_type: std::option::Option<crate::model::OntapDeploymentType>,
    /// <p>The IP address range in which the endpoints to access your file system
    /// are created.</p>
    pub endpoint_ip_address_range: std::option::Option<std::string::String>,
    /// <p>The <code>Management</code> and <code>Intercluster</code> endpoints
    /// that are used to access data or to manage the file system using the
    /// NetApp ONTAP CLI, REST API, or NetApp SnapMirror.</p>
    pub endpoints: std::option::Option<crate::model::FileSystemEndpoints>,
    /// <p>The SSD IOPS configuration for the ONTAP file system, specifying
    /// the number of provisioned IOPS and the provision mode.</p>
    pub disk_iops_configuration: std::option::Option<crate::model::DiskIopsConfiguration>,
    /// <p>The ID for a subnet. A <i>subnet</i> is a range of IP addresses in
    /// your virtual private cloud (VPC). For more information, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Subnets.html">VPC and Subnets</a> in the
    /// <i>Amazon VPC User Guide.</i>
    /// </p>
    pub preferred_subnet_id: std::option::Option<std::string::String>,
    /// <p>The VPC route tables in which your file system's endpoints are
    /// created.</p>
    pub route_table_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Sustained throughput of an Amazon FSx file system in MBps.</p>
    pub throughput_capacity: std::option::Option<i32>,
    /// <p>A recurring weekly time, in the format <code>D:HH:MM</code>. </p>
    /// <p>
    /// <code>D</code> is the day of the week, for which 1 represents Monday and 7
    /// represents Sunday. For further details, see <a href="https://en.wikipedia.org/wiki/ISO_week_date">the ISO-8601 spec as described on Wikipedia</a>.</p>
    /// <p>
    /// <code>HH</code> is the zero-padded hour of the day (0-23), and <code>MM</code> is
    /// the zero-padded minute of the hour. </p>
    /// <p>For example, <code>1:05:00</code> specifies maintenance at 5 AM Monday.</p>
    pub weekly_maintenance_start_time: std::option::Option<std::string::String>,
}
impl OntapFileSystemConfiguration {
    /// <p>The number of days to retain automatic backups. Setting this to 0 disables
    /// automatic backups. You can retain automatic backups for a maximum of 90 days. The default is 0.</p>
    pub fn automatic_backup_retention_days(&self) -> std::option::Option<i32> {
        self.automatic_backup_retention_days
    }
    /// <p>A recurring daily time, in the format <code>HH:MM</code>. <code>HH</code> is the
    /// zero-padded hour of the day (0-23), and <code>MM</code> is the zero-padded minute of the
    /// hour. For example, <code>05:00</code> specifies 5 AM daily. </p>
    pub fn daily_automatic_backup_start_time(&self) -> std::option::Option<&str> {
        self.daily_automatic_backup_start_time.as_deref()
    }
    /// <p>The ONTAP file system deployment type.</p>
    pub fn deployment_type(&self) -> std::option::Option<&crate::model::OntapDeploymentType> {
        self.deployment_type.as_ref()
    }
    /// <p>The IP address range in which the endpoints to access your file system
    /// are created.</p>
    pub fn endpoint_ip_address_range(&self) -> std::option::Option<&str> {
        self.endpoint_ip_address_range.as_deref()
    }
    /// <p>The <code>Management</code> and <code>Intercluster</code> endpoints
    /// that are used to access data or to manage the file system using the
    /// NetApp ONTAP CLI, REST API, or NetApp SnapMirror.</p>
    pub fn endpoints(&self) -> std::option::Option<&crate::model::FileSystemEndpoints> {
        self.endpoints.as_ref()
    }
    /// <p>The SSD IOPS configuration for the ONTAP file system, specifying
    /// the number of provisioned IOPS and the provision mode.</p>
    pub fn disk_iops_configuration(
        &self,
    ) -> std::option::Option<&crate::model::DiskIopsConfiguration> {
        self.disk_iops_configuration.as_ref()
    }
    /// <p>The ID for a subnet. A <i>subnet</i> is a range of IP addresses in
    /// your virtual private cloud (VPC). For more information, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Subnets.html">VPC and Subnets</a> in the
    /// <i>Amazon VPC User Guide.</i>
    /// </p>
    pub fn preferred_subnet_id(&self) -> std::option::Option<&str> {
        self.preferred_subnet_id.as_deref()
    }
    /// <p>The VPC route tables in which your file system's endpoints are
    /// created.</p>
    pub fn route_table_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.route_table_ids.as_deref()
    }
    /// <p>Sustained throughput of an Amazon FSx file system in MBps.</p>
    pub fn throughput_capacity(&self) -> std::option::Option<i32> {
        self.throughput_capacity
    }
    /// <p>A recurring weekly time, in the format <code>D:HH:MM</code>. </p>
    /// <p>
    /// <code>D</code> is the day of the week, for which 1 represents Monday and 7
    /// represents Sunday. For further details, see <a href="https://en.wikipedia.org/wiki/ISO_week_date">the ISO-8601 spec as described on Wikipedia</a>.</p>
    /// <p>
    /// <code>HH</code> is the zero-padded hour of the day (0-23), and <code>MM</code> is
    /// the zero-padded minute of the hour. </p>
    /// <p>For example, <code>1:05:00</code> specifies maintenance at 5 AM Monday.</p>
    pub fn weekly_maintenance_start_time(&self) -> std::option::Option<&str> {
        self.weekly_maintenance_start_time.as_deref()
    }
}
impl std::fmt::Debug for OntapFileSystemConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OntapFileSystemConfiguration");
        formatter.field(
            "automatic_backup_retention_days",
            &self.automatic_backup_retention_days,
        );
        formatter.field(
            "daily_automatic_backup_start_time",
            &self.daily_automatic_backup_start_time,
        );
        formatter.field("deployment_type", &self.deployment_type);
        formatter.field("endpoint_ip_address_range", &self.endpoint_ip_address_range);
        formatter.field("endpoints", &self.endpoints);
        formatter.field("disk_iops_configuration", &self.disk_iops_configuration);
        formatter.field("preferred_subnet_id", &self.preferred_subnet_id);
        formatter.field("route_table_ids", &self.route_table_ids);
        formatter.field("throughput_capacity", &self.throughput_capacity);
        formatter.field(
            "weekly_maintenance_start_time",
            &self.weekly_maintenance_start_time,
        );
        formatter.finish()
    }
}
/// See [`OntapFileSystemConfiguration`](crate::model::OntapFileSystemConfiguration)
pub mod ontap_file_system_configuration {
    /// A builder for [`OntapFileSystemConfiguration`](crate::model::OntapFileSystemConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) automatic_backup_retention_days: std::option::Option<i32>,
        pub(crate) daily_automatic_backup_start_time: std::option::Option<std::string::String>,
        pub(crate) deployment_type: std::option::Option<crate::model::OntapDeploymentType>,
        pub(crate) endpoint_ip_address_range: std::option::Option<std::string::String>,
        pub(crate) endpoints: std::option::Option<crate::model::FileSystemEndpoints>,
        pub(crate) disk_iops_configuration:
            std::option::Option<crate::model::DiskIopsConfiguration>,
        pub(crate) preferred_subnet_id: std::option::Option<std::string::String>,
        pub(crate) route_table_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) throughput_capacity: std::option::Option<i32>,
        pub(crate) weekly_maintenance_start_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The number of days to retain automatic backups. Setting this to 0 disables
        /// automatic backups. You can retain automatic backups for a maximum of 90 days. The default is 0.</p>
        pub fn automatic_backup_retention_days(mut self, input: i32) -> Self {
            self.automatic_backup_retention_days = Some(input);
            self
        }
        /// <p>The number of days to retain automatic backups. Setting this to 0 disables
        /// automatic backups. You can retain automatic backups for a maximum of 90 days. The default is 0.</p>
        pub fn set_automatic_backup_retention_days(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.automatic_backup_retention_days = input;
            self
        }
        /// <p>A recurring daily time, in the format <code>HH:MM</code>. <code>HH</code> is the
        /// zero-padded hour of the day (0-23), and <code>MM</code> is the zero-padded minute of the
        /// hour. For example, <code>05:00</code> specifies 5 AM daily. </p>
        pub fn daily_automatic_backup_start_time(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.daily_automatic_backup_start_time = Some(input.into());
            self
        }
        /// <p>A recurring daily time, in the format <code>HH:MM</code>. <code>HH</code> is the
        /// zero-padded hour of the day (0-23), and <code>MM</code> is the zero-padded minute of the
        /// hour. For example, <code>05:00</code> specifies 5 AM daily. </p>
        pub fn set_daily_automatic_backup_start_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.daily_automatic_backup_start_time = input;
            self
        }
        /// <p>The ONTAP file system deployment type.</p>
        pub fn deployment_type(mut self, input: crate::model::OntapDeploymentType) -> Self {
            self.deployment_type = Some(input);
            self
        }
        /// <p>The ONTAP file system deployment type.</p>
        pub fn set_deployment_type(
            mut self,
            input: std::option::Option<crate::model::OntapDeploymentType>,
        ) -> Self {
            self.deployment_type = input;
            self
        }
        /// <p>The IP address range in which the endpoints to access your file system
        /// are created.</p>
        pub fn endpoint_ip_address_range(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_ip_address_range = Some(input.into());
            self
        }
        /// <p>The IP address range in which the endpoints to access your file system
        /// are created.</p>
        pub fn set_endpoint_ip_address_range(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_ip_address_range = input;
            self
        }
        /// <p>The <code>Management</code> and <code>Intercluster</code> endpoints
        /// that are used to access data or to manage the file system using the
        /// NetApp ONTAP CLI, REST API, or NetApp SnapMirror.</p>
        pub fn endpoints(mut self, input: crate::model::FileSystemEndpoints) -> Self {
            self.endpoints = Some(input);
            self
        }
        /// <p>The <code>Management</code> and <code>Intercluster</code> endpoints
        /// that are used to access data or to manage the file system using the
        /// NetApp ONTAP CLI, REST API, or NetApp SnapMirror.</p>
        pub fn set_endpoints(
            mut self,
            input: std::option::Option<crate::model::FileSystemEndpoints>,
        ) -> Self {
            self.endpoints = input;
            self
        }
        /// <p>The SSD IOPS configuration for the ONTAP file system, specifying
        /// the number of provisioned IOPS and the provision mode.</p>
        pub fn disk_iops_configuration(
            mut self,
            input: crate::model::DiskIopsConfiguration,
        ) -> Self {
            self.disk_iops_configuration = Some(input);
            self
        }
        /// <p>The SSD IOPS configuration for the ONTAP file system, specifying
        /// the number of provisioned IOPS and the provision mode.</p>
        pub fn set_disk_iops_configuration(
            mut self,
            input: std::option::Option<crate::model::DiskIopsConfiguration>,
        ) -> Self {
            self.disk_iops_configuration = input;
            self
        }
        /// <p>The ID for a subnet. A <i>subnet</i> is a range of IP addresses in
        /// your virtual private cloud (VPC). For more information, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Subnets.html">VPC and Subnets</a> in the
        /// <i>Amazon VPC User Guide.</i>
        /// </p>
        pub fn preferred_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.preferred_subnet_id = Some(input.into());
            self
        }
        /// <p>The ID for a subnet. A <i>subnet</i> is a range of IP addresses in
        /// your virtual private cloud (VPC). For more information, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Subnets.html">VPC and Subnets</a> in the
        /// <i>Amazon VPC User Guide.</i>
        /// </p>
        pub fn set_preferred_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_subnet_id = input;
            self
        }
        /// Appends an item to `route_table_ids`.
        ///
        /// To override the contents of this collection use [`set_route_table_ids`](Self::set_route_table_ids).
        ///
        /// <p>The VPC route tables in which your file system's endpoints are
        /// created.</p>
        pub fn route_table_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.route_table_ids.unwrap_or_default();
            v.push(input.into());
            self.route_table_ids = Some(v);
            self
        }
        /// <p>The VPC route tables in which your file system's endpoints are
        /// created.</p>
        pub fn set_route_table_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.route_table_ids = input;
            self
        }
        /// <p>Sustained throughput of an Amazon FSx file system in MBps.</p>
        pub fn throughput_capacity(mut self, input: i32) -> Self {
            self.throughput_capacity = Some(input);
            self
        }
        /// <p>Sustained throughput of an Amazon FSx file system in MBps.</p>
        pub fn set_throughput_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.throughput_capacity = input;
            self
        }
        /// <p>A recurring weekly time, in the format <code>D:HH:MM</code>. </p>
        /// <p>
        /// <code>D</code> is the day of the week, for which 1 represents Monday and 7
        /// represents Sunday. For further details, see <a href="https://en.wikipedia.org/wiki/ISO_week_date">the ISO-8601 spec as described on Wikipedia</a>.</p>
        /// <p>
        /// <code>HH</code> is the zero-padded hour of the day (0-23), and <code>MM</code> is
        /// the zero-padded minute of the hour. </p>
        /// <p>For example, <code>1:05:00</code> specifies maintenance at 5 AM Monday.</p>
        pub fn weekly_maintenance_start_time(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.weekly_maintenance_start_time = Some(input.into());
            self
        }
        /// <p>A recurring weekly time, in the format <code>D:HH:MM</code>. </p>
        /// <p>
        /// <code>D</code> is the day of the week, for which 1 represents Monday and 7
        /// represents Sunday. For further details, see <a href="https://en.wikipedia.org/wiki/ISO_week_date">the ISO-8601 spec as described on Wikipedia</a>.</p>
        /// <p>
        /// <code>HH</code> is the zero-padded hour of the day (0-23), and <code>MM</code> is
        /// the zero-padded minute of the hour. </p>
        /// <p>For example, <code>1:05:00</code> specifies maintenance at 5 AM Monday.</p>
        pub fn set_weekly_maintenance_start_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.weekly_maintenance_start_time = input;
            self
        }
        /// Consumes the builder and constructs a [`OntapFileSystemConfiguration`](crate::model::OntapFileSystemConfiguration)
        pub fn build(self) -> crate::model::OntapFileSystemConfiguration {
            crate::model::OntapFileSystemConfiguration {
                automatic_backup_retention_days: self.automatic_backup_retention_days,
                daily_automatic_backup_start_time: self.daily_automatic_backup_start_time,
                deployment_type: self.deployment_type,
                endpoint_ip_address_range: self.endpoint_ip_address_range,
                endpoints: self.endpoints,
                disk_iops_configuration: self.disk_iops_configuration,
                preferred_subnet_id: self.preferred_subnet_id,
                route_table_ids: self.route_table_ids,
                throughput_capacity: self.throughput_capacity,
                weekly_maintenance_start_time: self.weekly_maintenance_start_time,
            }
        }
    }
}
impl OntapFileSystemConfiguration {
    /// Creates a new builder-style object to manufacture [`OntapFileSystemConfiguration`](crate::model::OntapFileSystemConfiguration)
    pub fn builder() -> crate::model::ontap_file_system_configuration::Builder {
        crate::model::ontap_file_system_configuration::Builder::default()
    }
}

/// <p>The SSD IOPS (input/output operations per second) configuration
/// for an Amazon FSx for NetApp ONTAP file system. The default is 3 IOPS
/// per GB of storage capacity, but you can provision additional IOPS
/// per GB of storage. The configuration consists of the total number
/// of provisioned SSD IOPS and how the amount was provisioned
/// (by the customer or by the system).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DiskIopsConfiguration {
    /// <p>Specifies whether the number of IOPS for the file system is
    /// using the system default (<code>AUTOMATIC</code>) or was
    /// provisioned by the customer (<code>USER_PROVISIONED</code>).</p>
    pub mode: std::option::Option<crate::model::DiskIopsConfigurationMode>,
    /// <p>The total number of SSD IOPS provisioned for the file system.</p>
    pub iops: std::option::Option<i64>,
}
impl DiskIopsConfiguration {
    /// <p>Specifies whether the number of IOPS for the file system is
    /// using the system default (<code>AUTOMATIC</code>) or was
    /// provisioned by the customer (<code>USER_PROVISIONED</code>).</p>
    pub fn mode(&self) -> std::option::Option<&crate::model::DiskIopsConfigurationMode> {
        self.mode.as_ref()
    }
    /// <p>The total number of SSD IOPS provisioned for the file system.</p>
    pub fn iops(&self) -> std::option::Option<i64> {
        self.iops
    }
}
impl std::fmt::Debug for DiskIopsConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DiskIopsConfiguration");
        formatter.field("mode", &self.mode);
        formatter.field("iops", &self.iops);
        formatter.finish()
    }
}
/// See [`DiskIopsConfiguration`](crate::model::DiskIopsConfiguration)
pub mod disk_iops_configuration {
    /// A builder for [`DiskIopsConfiguration`](crate::model::DiskIopsConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mode: std::option::Option<crate::model::DiskIopsConfigurationMode>,
        pub(crate) iops: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>Specifies whether the number of IOPS for the file system is
        /// using the system default (<code>AUTOMATIC</code>) or was
        /// provisioned by the customer (<code>USER_PROVISIONED</code>).</p>
        pub fn mode(mut self, input: crate::model::DiskIopsConfigurationMode) -> Self {
            self.mode = Some(input);
            self
        }
        /// <p>Specifies whether the number of IOPS for the file system is
        /// using the system default (<code>AUTOMATIC</code>) or was
        /// provisioned by the customer (<code>USER_PROVISIONED</code>).</p>
        pub fn set_mode(
            mut self,
            input: std::option::Option<crate::model::DiskIopsConfigurationMode>,
        ) -> Self {
            self.mode = input;
            self
        }
        /// <p>The total number of SSD IOPS provisioned for the file system.</p>
        pub fn iops(mut self, input: i64) -> Self {
            self.iops = Some(input);
            self
        }
        /// <p>The total number of SSD IOPS provisioned for the file system.</p>
        pub fn set_iops(mut self, input: std::option::Option<i64>) -> Self {
            self.iops = input;
            self
        }
        /// Consumes the builder and constructs a [`DiskIopsConfiguration`](crate::model::DiskIopsConfiguration)
        pub fn build(self) -> crate::model::DiskIopsConfiguration {
            crate::model::DiskIopsConfiguration {
                mode: self.mode,
                iops: self.iops,
            }
        }
    }
}
impl DiskIopsConfiguration {
    /// Creates a new builder-style object to manufacture [`DiskIopsConfiguration`](crate::model::DiskIopsConfiguration)
    pub fn builder() -> crate::model::disk_iops_configuration::Builder {
        crate::model::disk_iops_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DiskIopsConfigurationMode {
    #[allow(missing_docs)] // documentation missing in model
    Automatic,
    #[allow(missing_docs)] // documentation missing in model
    UserProvisioned,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DiskIopsConfigurationMode {
    fn from(s: &str) -> Self {
        match s {
            "AUTOMATIC" => DiskIopsConfigurationMode::Automatic,
            "USER_PROVISIONED" => DiskIopsConfigurationMode::UserProvisioned,
            other => DiskIopsConfigurationMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DiskIopsConfigurationMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DiskIopsConfigurationMode::from(s))
    }
}
impl DiskIopsConfigurationMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DiskIopsConfigurationMode::Automatic => "AUTOMATIC",
            DiskIopsConfigurationMode::UserProvisioned => "USER_PROVISIONED",
            DiskIopsConfigurationMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTOMATIC", "USER_PROVISIONED"]
    }
}
impl AsRef<str> for DiskIopsConfigurationMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An Amazon FSx for NetApp ONTAP file system has the following endpoints
/// that are used to access data or to manage the file system using the
/// NetApp ONTAP CLI, REST API, or NetApp SnapMirror.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FileSystemEndpoints {
    /// <p>An endpoint for managing your file system by setting up NetApp SnapMirror
    /// with other ONTAP systems.</p>
    pub intercluster: std::option::Option<crate::model::FileSystemEndpoint>,
    /// <p>An endpoint for managing your file system using the NetApp ONTAP CLI
    /// and NetApp ONTAP API.</p>
    pub management: std::option::Option<crate::model::FileSystemEndpoint>,
}
impl FileSystemEndpoints {
    /// <p>An endpoint for managing your file system by setting up NetApp SnapMirror
    /// with other ONTAP systems.</p>
    pub fn intercluster(&self) -> std::option::Option<&crate::model::FileSystemEndpoint> {
        self.intercluster.as_ref()
    }
    /// <p>An endpoint for managing your file system using the NetApp ONTAP CLI
    /// and NetApp ONTAP API.</p>
    pub fn management(&self) -> std::option::Option<&crate::model::FileSystemEndpoint> {
        self.management.as_ref()
    }
}
impl std::fmt::Debug for FileSystemEndpoints {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FileSystemEndpoints");
        formatter.field("intercluster", &self.intercluster);
        formatter.field("management", &self.management);
        formatter.finish()
    }
}
/// See [`FileSystemEndpoints`](crate::model::FileSystemEndpoints)
pub mod file_system_endpoints {
    /// A builder for [`FileSystemEndpoints`](crate::model::FileSystemEndpoints)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) intercluster: std::option::Option<crate::model::FileSystemEndpoint>,
        pub(crate) management: std::option::Option<crate::model::FileSystemEndpoint>,
    }
    impl Builder {
        /// <p>An endpoint for managing your file system by setting up NetApp SnapMirror
        /// with other ONTAP systems.</p>
        pub fn intercluster(mut self, input: crate::model::FileSystemEndpoint) -> Self {
            self.intercluster = Some(input);
            self
        }
        /// <p>An endpoint for managing your file system by setting up NetApp SnapMirror
        /// with other ONTAP systems.</p>
        pub fn set_intercluster(
            mut self,
            input: std::option::Option<crate::model::FileSystemEndpoint>,
        ) -> Self {
            self.intercluster = input;
            self
        }
        /// <p>An endpoint for managing your file system using the NetApp ONTAP CLI
        /// and NetApp ONTAP API.</p>
        pub fn management(mut self, input: crate::model::FileSystemEndpoint) -> Self {
            self.management = Some(input);
            self
        }
        /// <p>An endpoint for managing your file system using the NetApp ONTAP CLI
        /// and NetApp ONTAP API.</p>
        pub fn set_management(
            mut self,
            input: std::option::Option<crate::model::FileSystemEndpoint>,
        ) -> Self {
            self.management = input;
            self
        }
        /// Consumes the builder and constructs a [`FileSystemEndpoints`](crate::model::FileSystemEndpoints)
        pub fn build(self) -> crate::model::FileSystemEndpoints {
            crate::model::FileSystemEndpoints {
                intercluster: self.intercluster,
                management: self.management,
            }
        }
    }
}
impl FileSystemEndpoints {
    /// Creates a new builder-style object to manufacture [`FileSystemEndpoints`](crate::model::FileSystemEndpoints)
    pub fn builder() -> crate::model::file_system_endpoints::Builder {
        crate::model::file_system_endpoints::Builder::default()
    }
}

/// <p>An Amazon FSx for NetApp ONTAP file system has two endpoints
/// that are used to access data or to manage the file system
/// using the NetApp ONTAP CLI, REST API, or NetApp SnapMirror. They
/// are the <code>Management</code> and <code>Intercluster</code> endpoints.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FileSystemEndpoint {
    /// <p>The Domain Name Service (DNS) name for the file system. You can mount your file
    /// system using its DNS name.</p>
    pub dns_name: std::option::Option<std::string::String>,
    /// <p>IP addresses of the file system endpoint.</p>
    pub ip_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl FileSystemEndpoint {
    /// <p>The Domain Name Service (DNS) name for the file system. You can mount your file
    /// system using its DNS name.</p>
    pub fn dns_name(&self) -> std::option::Option<&str> {
        self.dns_name.as_deref()
    }
    /// <p>IP addresses of the file system endpoint.</p>
    pub fn ip_addresses(&self) -> std::option::Option<&[std::string::String]> {
        self.ip_addresses.as_deref()
    }
}
impl std::fmt::Debug for FileSystemEndpoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FileSystemEndpoint");
        formatter.field("dns_name", &self.dns_name);
        formatter.field("ip_addresses", &self.ip_addresses);
        formatter.finish()
    }
}
/// See [`FileSystemEndpoint`](crate::model::FileSystemEndpoint)
pub mod file_system_endpoint {
    /// A builder for [`FileSystemEndpoint`](crate::model::FileSystemEndpoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dns_name: std::option::Option<std::string::String>,
        pub(crate) ip_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Domain Name Service (DNS) name for the file system. You can mount your file
        /// system using its DNS name.</p>
        pub fn dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dns_name = Some(input.into());
            self
        }
        /// <p>The Domain Name Service (DNS) name for the file system. You can mount your file
        /// system using its DNS name.</p>
        pub fn set_dns_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dns_name = input;
            self
        }
        /// Appends an item to `ip_addresses`.
        ///
        /// To override the contents of this collection use [`set_ip_addresses`](Self::set_ip_addresses).
        ///
        /// <p>IP addresses of the file system endpoint.</p>
        pub fn ip_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ip_addresses.unwrap_or_default();
            v.push(input.into());
            self.ip_addresses = Some(v);
            self
        }
        /// <p>IP addresses of the file system endpoint.</p>
        pub fn set_ip_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ip_addresses = input;
            self
        }
        /// Consumes the builder and constructs a [`FileSystemEndpoint`](crate::model::FileSystemEndpoint)
        pub fn build(self) -> crate::model::FileSystemEndpoint {
            crate::model::FileSystemEndpoint {
                dns_name: self.dns_name,
                ip_addresses: self.ip_addresses,
            }
        }
    }
}
impl FileSystemEndpoint {
    /// Creates a new builder-style object to manufacture [`FileSystemEndpoint`](crate::model::FileSystemEndpoint)
    pub fn builder() -> crate::model::file_system_endpoint::Builder {
        crate::model::file_system_endpoint::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OntapDeploymentType {
    #[allow(missing_docs)] // documentation missing in model
    MultiAz1,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OntapDeploymentType {
    fn from(s: &str) -> Self {
        match s {
            "MULTI_AZ_1" => OntapDeploymentType::MultiAz1,
            other => OntapDeploymentType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OntapDeploymentType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OntapDeploymentType::from(s))
    }
}
impl OntapDeploymentType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OntapDeploymentType::MultiAz1 => "MULTI_AZ_1",
            OntapDeploymentType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MULTI_AZ_1"]
    }
}
impl AsRef<str> for OntapDeploymentType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a specific Amazon FSx administrative action for the current Windows or
/// Lustre file system.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdministrativeAction {
    /// <p>Describes the type of administrative action, as follows:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>FILE_SYSTEM_UPDATE</code> - A file system update administrative action initiated by the user from the
    /// Amazon FSx console, API (UpdateFileSystem), or CLI (update-file-system).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>STORAGE_OPTIMIZATION</code> - Once the <code>FILE_SYSTEM_UPDATE</code>
    /// task to increase a file system's storage capacity completes successfully, a
    /// <code>STORAGE_OPTIMIZATION</code> task starts.
    /// </p>
    /// <ul>
    /// <li>
    /// <p>For Windows, storage optimization is the process of migrating the file system data
    /// to the new, larger disks.</p>
    /// </li>
    /// <li>
    /// <p>For Lustre, storage optimization consists of rebalancing the data across the existing and
    /// newly added file servers.</p>
    /// </li>
    /// </ul>
    /// <p>You can track the storage optimization progress using the
    /// <code>ProgressPercent</code> property. When
    /// <code>STORAGE_OPTIMIZATION</code> completes successfully, the parent
    /// <code>FILE_SYSTEM_UPDATE</code> action status changes to
    /// <code>COMPLETED</code>. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html">Managing
    /// storage capacity</a> in the <i>Amazon FSx for Windows File Server
    /// User Guide</i> and <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-storage-capacity.html">Managing storage
    /// and throughput capacity</a> in the <i>Amazon FSx for Lustre User
    /// Guide</i>. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FILE_SYSTEM_ALIAS_ASSOCIATION</code> - A file system update to associate a new DNS alias with the file system.
    /// For more information, see
    /// .</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FILE_SYSTEM_ALIAS_DISASSOCIATION</code> - A file system update to disassociate a DNS alias from the file system.
    /// For more information, see .</p>
    /// </li>
    /// </ul>
    pub administrative_action_type: std::option::Option<crate::model::AdministrativeActionType>,
    /// <p>Provides the percent complete of a <code>STORAGE_OPTIMIZATION</code> administrative action.
    /// Does not apply to any other administrative action type.</p>
    pub progress_percent: std::option::Option<i32>,
    /// <p>Time that the administrative action request was received.</p>
    pub request_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Describes the status of the administrative action, as follows:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - Amazon FSx failed to process the administrative action successfully.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IN_PROGRESS</code> - Amazon FSx is processing the administrative action.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PENDING</code> - Amazon FSx is waiting to process the administrative action.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COMPLETED</code> - Amazon FSx has finished processing the administrative task.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATED_OPTIMIZING</code> - For a storage capacity increase update, Amazon FSx has
    /// updated the file system with the new storage capacity, and is now performing the
    /// storage optimization process. For more information, see
    /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html">Managing
    /// storage capacity</a> in the <i>Amazon FSx for Windows File Server
    /// User Guide</i> and <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-storage-capacity.html">Managing storage
    /// and throughput capacity</a> in the <i>Amazon FSx for Lustre User
    /// Guide</i>.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::Status>,
    /// <p>Describes the target value for the administration action,  
    /// provided in the <code>UpdateFileSystem</code> operation.  
    /// Returned for <code>FILE_SYSTEM_UPDATE</code> administrative actions.
    /// </p>
    pub target_file_system_values: std::option::Option<crate::model::FileSystem>,
    /// <p>Provides information about a failed administrative action.</p>
    pub failure_details: std::option::Option<crate::model::AdministrativeActionFailureDetails>,
    /// <p>Describes an Amazon FSx for NetApp ONTAP volume.</p>
    pub target_volume_values: std::option::Option<crate::model::Volume>,
}
impl AdministrativeAction {
    /// <p>Describes the type of administrative action, as follows:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>FILE_SYSTEM_UPDATE</code> - A file system update administrative action initiated by the user from the
    /// Amazon FSx console, API (UpdateFileSystem), or CLI (update-file-system).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>STORAGE_OPTIMIZATION</code> - Once the <code>FILE_SYSTEM_UPDATE</code>
    /// task to increase a file system's storage capacity completes successfully, a
    /// <code>STORAGE_OPTIMIZATION</code> task starts.
    /// </p>
    /// <ul>
    /// <li>
    /// <p>For Windows, storage optimization is the process of migrating the file system data
    /// to the new, larger disks.</p>
    /// </li>
    /// <li>
    /// <p>For Lustre, storage optimization consists of rebalancing the data across the existing and
    /// newly added file servers.</p>
    /// </li>
    /// </ul>
    /// <p>You can track the storage optimization progress using the
    /// <code>ProgressPercent</code> property. When
    /// <code>STORAGE_OPTIMIZATION</code> completes successfully, the parent
    /// <code>FILE_SYSTEM_UPDATE</code> action status changes to
    /// <code>COMPLETED</code>. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html">Managing
    /// storage capacity</a> in the <i>Amazon FSx for Windows File Server
    /// User Guide</i> and <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-storage-capacity.html">Managing storage
    /// and throughput capacity</a> in the <i>Amazon FSx for Lustre User
    /// Guide</i>. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FILE_SYSTEM_ALIAS_ASSOCIATION</code> - A file system update to associate a new DNS alias with the file system.
    /// For more information, see
    /// .</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FILE_SYSTEM_ALIAS_DISASSOCIATION</code> - A file system update to disassociate a DNS alias from the file system.
    /// For more information, see .</p>
    /// </li>
    /// </ul>
    pub fn administrative_action_type(
        &self,
    ) -> std::option::Option<&crate::model::AdministrativeActionType> {
        self.administrative_action_type.as_ref()
    }
    /// <p>Provides the percent complete of a <code>STORAGE_OPTIMIZATION</code> administrative action.
    /// Does not apply to any other administrative action type.</p>
    pub fn progress_percent(&self) -> std::option::Option<i32> {
        self.progress_percent
    }
    /// <p>Time that the administrative action request was received.</p>
    pub fn request_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.request_time.as_ref()
    }
    /// <p>Describes the status of the administrative action, as follows:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - Amazon FSx failed to process the administrative action successfully.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IN_PROGRESS</code> - Amazon FSx is processing the administrative action.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PENDING</code> - Amazon FSx is waiting to process the administrative action.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COMPLETED</code> - Amazon FSx has finished processing the administrative task.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATED_OPTIMIZING</code> - For a storage capacity increase update, Amazon FSx has
    /// updated the file system with the new storage capacity, and is now performing the
    /// storage optimization process. For more information, see
    /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html">Managing
    /// storage capacity</a> in the <i>Amazon FSx for Windows File Server
    /// User Guide</i> and <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-storage-capacity.html">Managing storage
    /// and throughput capacity</a> in the <i>Amazon FSx for Lustre User
    /// Guide</i>.</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::Status> {
        self.status.as_ref()
    }
    /// <p>Describes the target value for the administration action,  
    /// provided in the <code>UpdateFileSystem</code> operation.  
    /// Returned for <code>FILE_SYSTEM_UPDATE</code> administrative actions.
    /// </p>
    pub fn target_file_system_values(&self) -> std::option::Option<&crate::model::FileSystem> {
        self.target_file_system_values.as_ref()
    }
    /// <p>Provides information about a failed administrative action.</p>
    pub fn failure_details(
        &self,
    ) -> std::option::Option<&crate::model::AdministrativeActionFailureDetails> {
        self.failure_details.as_ref()
    }
    /// <p>Describes an Amazon FSx for NetApp ONTAP volume.</p>
    pub fn target_volume_values(&self) -> std::option::Option<&crate::model::Volume> {
        self.target_volume_values.as_ref()
    }
}
impl std::fmt::Debug for AdministrativeAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdministrativeAction");
        formatter.field(
            "administrative_action_type",
            &self.administrative_action_type,
        );
        formatter.field("progress_percent", &self.progress_percent);
        formatter.field("request_time", &self.request_time);
        formatter.field("status", &self.status);
        formatter.field("target_file_system_values", &self.target_file_system_values);
        formatter.field("failure_details", &self.failure_details);
        formatter.field("target_volume_values", &self.target_volume_values);
        formatter.finish()
    }
}
/// See [`AdministrativeAction`](crate::model::AdministrativeAction)
pub mod administrative_action {
    /// A builder for [`AdministrativeAction`](crate::model::AdministrativeAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) administrative_action_type:
            std::option::Option<crate::model::AdministrativeActionType>,
        pub(crate) progress_percent: std::option::Option<i32>,
        pub(crate) request_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<crate::model::Status>,
        pub(crate) target_file_system_values: std::option::Option<crate::model::FileSystem>,
        pub(crate) failure_details:
            std::option::Option<crate::model::AdministrativeActionFailureDetails>,
        pub(crate) target_volume_values: std::option::Option<crate::model::Volume>,
    }
    impl Builder {
        /// <p>Describes the type of administrative action, as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>FILE_SYSTEM_UPDATE</code> - A file system update administrative action initiated by the user from the
        /// Amazon FSx console, API (UpdateFileSystem), or CLI (update-file-system).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STORAGE_OPTIMIZATION</code> - Once the <code>FILE_SYSTEM_UPDATE</code>
        /// task to increase a file system's storage capacity completes successfully, a
        /// <code>STORAGE_OPTIMIZATION</code> task starts.
        /// </p>
        /// <ul>
        /// <li>
        /// <p>For Windows, storage optimization is the process of migrating the file system data
        /// to the new, larger disks.</p>
        /// </li>
        /// <li>
        /// <p>For Lustre, storage optimization consists of rebalancing the data across the existing and
        /// newly added file servers.</p>
        /// </li>
        /// </ul>
        /// <p>You can track the storage optimization progress using the
        /// <code>ProgressPercent</code> property. When
        /// <code>STORAGE_OPTIMIZATION</code> completes successfully, the parent
        /// <code>FILE_SYSTEM_UPDATE</code> action status changes to
        /// <code>COMPLETED</code>. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html">Managing
        /// storage capacity</a> in the <i>Amazon FSx for Windows File Server
        /// User Guide</i> and <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-storage-capacity.html">Managing storage
        /// and throughput capacity</a> in the <i>Amazon FSx for Lustre User
        /// Guide</i>. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FILE_SYSTEM_ALIAS_ASSOCIATION</code> - A file system update to associate a new DNS alias with the file system.
        /// For more information, see
        /// .</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FILE_SYSTEM_ALIAS_DISASSOCIATION</code> - A file system update to disassociate a DNS alias from the file system.
        /// For more information, see .</p>
        /// </li>
        /// </ul>
        pub fn administrative_action_type(
            mut self,
            input: crate::model::AdministrativeActionType,
        ) -> Self {
            self.administrative_action_type = Some(input);
            self
        }
        /// <p>Describes the type of administrative action, as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>FILE_SYSTEM_UPDATE</code> - A file system update administrative action initiated by the user from the
        /// Amazon FSx console, API (UpdateFileSystem), or CLI (update-file-system).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STORAGE_OPTIMIZATION</code> - Once the <code>FILE_SYSTEM_UPDATE</code>
        /// task to increase a file system's storage capacity completes successfully, a
        /// <code>STORAGE_OPTIMIZATION</code> task starts.
        /// </p>
        /// <ul>
        /// <li>
        /// <p>For Windows, storage optimization is the process of migrating the file system data
        /// to the new, larger disks.</p>
        /// </li>
        /// <li>
        /// <p>For Lustre, storage optimization consists of rebalancing the data across the existing and
        /// newly added file servers.</p>
        /// </li>
        /// </ul>
        /// <p>You can track the storage optimization progress using the
        /// <code>ProgressPercent</code> property. When
        /// <code>STORAGE_OPTIMIZATION</code> completes successfully, the parent
        /// <code>FILE_SYSTEM_UPDATE</code> action status changes to
        /// <code>COMPLETED</code>. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html">Managing
        /// storage capacity</a> in the <i>Amazon FSx for Windows File Server
        /// User Guide</i> and <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-storage-capacity.html">Managing storage
        /// and throughput capacity</a> in the <i>Amazon FSx for Lustre User
        /// Guide</i>. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FILE_SYSTEM_ALIAS_ASSOCIATION</code> - A file system update to associate a new DNS alias with the file system.
        /// For more information, see
        /// .</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FILE_SYSTEM_ALIAS_DISASSOCIATION</code> - A file system update to disassociate a DNS alias from the file system.
        /// For more information, see .</p>
        /// </li>
        /// </ul>
        pub fn set_administrative_action_type(
            mut self,
            input: std::option::Option<crate::model::AdministrativeActionType>,
        ) -> Self {
            self.administrative_action_type = input;
            self
        }
        /// <p>Provides the percent complete of a <code>STORAGE_OPTIMIZATION</code> administrative action.
        /// Does not apply to any other administrative action type.</p>
        pub fn progress_percent(mut self, input: i32) -> Self {
            self.progress_percent = Some(input);
            self
        }
        /// <p>Provides the percent complete of a <code>STORAGE_OPTIMIZATION</code> administrative action.
        /// Does not apply to any other administrative action type.</p>
        pub fn set_progress_percent(mut self, input: std::option::Option<i32>) -> Self {
            self.progress_percent = input;
            self
        }
        /// <p>Time that the administrative action request was received.</p>
        pub fn request_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.request_time = Some(input);
            self
        }
        /// <p>Time that the administrative action request was received.</p>
        pub fn set_request_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.request_time = input;
            self
        }
        /// <p>Describes the status of the administrative action, as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - Amazon FSx failed to process the administrative action successfully.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS</code> - Amazon FSx is processing the administrative action.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PENDING</code> - Amazon FSx is waiting to process the administrative action.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COMPLETED</code> - Amazon FSx has finished processing the administrative task.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATED_OPTIMIZING</code> - For a storage capacity increase update, Amazon FSx has
        /// updated the file system with the new storage capacity, and is now performing the
        /// storage optimization process. For more information, see
        /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html">Managing
        /// storage capacity</a> in the <i>Amazon FSx for Windows File Server
        /// User Guide</i> and <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-storage-capacity.html">Managing storage
        /// and throughput capacity</a> in the <i>Amazon FSx for Lustre User
        /// Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Describes the status of the administrative action, as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - Amazon FSx failed to process the administrative action successfully.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS</code> - Amazon FSx is processing the administrative action.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PENDING</code> - Amazon FSx is waiting to process the administrative action.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COMPLETED</code> - Amazon FSx has finished processing the administrative task.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATED_OPTIMIZING</code> - For a storage capacity increase update, Amazon FSx has
        /// updated the file system with the new storage capacity, and is now performing the
        /// storage optimization process. For more information, see
        /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html">Managing
        /// storage capacity</a> in the <i>Amazon FSx for Windows File Server
        /// User Guide</i> and <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-storage-capacity.html">Managing storage
        /// and throughput capacity</a> in the <i>Amazon FSx for Lustre User
        /// Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// <p>Describes the target value for the administration action,  
        /// provided in the <code>UpdateFileSystem</code> operation.  
        /// Returned for <code>FILE_SYSTEM_UPDATE</code> administrative actions.
        /// </p>
        pub fn target_file_system_values(mut self, input: crate::model::FileSystem) -> Self {
            self.target_file_system_values = Some(input);
            self
        }
        /// <p>Describes the target value for the administration action,  
        /// provided in the <code>UpdateFileSystem</code> operation.  
        /// Returned for <code>FILE_SYSTEM_UPDATE</code> administrative actions.
        /// </p>
        pub fn set_target_file_system_values(
            mut self,
            input: std::option::Option<crate::model::FileSystem>,
        ) -> Self {
            self.target_file_system_values = input;
            self
        }
        /// <p>Provides information about a failed administrative action.</p>
        pub fn failure_details(
            mut self,
            input: crate::model::AdministrativeActionFailureDetails,
        ) -> Self {
            self.failure_details = Some(input);
            self
        }
        /// <p>Provides information about a failed administrative action.</p>
        pub fn set_failure_details(
            mut self,
            input: std::option::Option<crate::model::AdministrativeActionFailureDetails>,
        ) -> Self {
            self.failure_details = input;
            self
        }
        /// <p>Describes an Amazon FSx for NetApp ONTAP volume.</p>
        pub fn target_volume_values(mut self, input: crate::model::Volume) -> Self {
            self.target_volume_values = Some(input);
            self
        }
        /// <p>Describes an Amazon FSx for NetApp ONTAP volume.</p>
        pub fn set_target_volume_values(
            mut self,
            input: std::option::Option<crate::model::Volume>,
        ) -> Self {
            self.target_volume_values = input;
            self
        }
        /// Consumes the builder and constructs a [`AdministrativeAction`](crate::model::AdministrativeAction)
        pub fn build(self) -> crate::model::AdministrativeAction {
            crate::model::AdministrativeAction {
                administrative_action_type: self.administrative_action_type,
                progress_percent: self.progress_percent,
                request_time: self.request_time,
                status: self.status,
                target_file_system_values: self.target_file_system_values,
                failure_details: self.failure_details,
                target_volume_values: self.target_volume_values,
            }
        }
    }
}
impl AdministrativeAction {
    /// Creates a new builder-style object to manufacture [`AdministrativeAction`](crate::model::AdministrativeAction)
    pub fn builder() -> crate::model::administrative_action::Builder {
        crate::model::administrative_action::Builder::default()
    }
}

/// <p>Provides information about a failed administrative action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdministrativeActionFailureDetails {
    /// <p>Error message providing details about the failed administrative action.</p>
    pub message: std::option::Option<std::string::String>,
}
impl AdministrativeActionFailureDetails {
    /// <p>Error message providing details about the failed administrative action.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for AdministrativeActionFailureDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdministrativeActionFailureDetails");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`AdministrativeActionFailureDetails`](crate::model::AdministrativeActionFailureDetails)
pub mod administrative_action_failure_details {
    /// A builder for [`AdministrativeActionFailureDetails`](crate::model::AdministrativeActionFailureDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error message providing details about the failed administrative action.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error message providing details about the failed administrative action.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AdministrativeActionFailureDetails`](crate::model::AdministrativeActionFailureDetails)
        pub fn build(self) -> crate::model::AdministrativeActionFailureDetails {
            crate::model::AdministrativeActionFailureDetails {
                message: self.message,
            }
        }
    }
}
impl AdministrativeActionFailureDetails {
    /// Creates a new builder-style object to manufacture [`AdministrativeActionFailureDetails`](crate::model::AdministrativeActionFailureDetails)
    pub fn builder() -> crate::model::administrative_action_failure_details::Builder {
        crate::model::administrative_action_failure_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Status {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    UpdatedOptimizing,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Status {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => Status::Completed,
            "FAILED" => Status::Failed,
            "IN_PROGRESS" => Status::InProgress,
            "PENDING" => Status::Pending,
            "UPDATED_OPTIMIZING" => Status::UpdatedOptimizing,
            other => Status::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Status {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Status::from(s))
    }
}
impl Status {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Status::Completed => "COMPLETED",
            Status::Failed => "FAILED",
            Status::InProgress => "IN_PROGRESS",
            Status::Pending => "PENDING",
            Status::UpdatedOptimizing => "UPDATED_OPTIMIZING",
            Status::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "COMPLETED",
            "FAILED",
            "IN_PROGRESS",
            "PENDING",
            "UPDATED_OPTIMIZING",
        ]
    }
}
impl AsRef<str> for Status {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the type of administrative action, as follows:</p>
/// <ul>
/// <li>
/// <p>
/// <code>FILE_SYSTEM_UPDATE</code> - A file system update administrative action initiated by the user from the
/// Amazon FSx console, API (UpdateFileSystem), or CLI (update-file-system).</p>
/// </li>
/// <li>
/// <p>
/// <code>STORAGE_OPTIMIZATION</code> - Once the <code>FILE_SYSTEM_UPDATE</code>
/// task to increase a file system's storage capacity completes successfully, a
/// <code>STORAGE_OPTIMIZATION</code> task starts.
/// </p>
/// <ul>
/// <li>
/// <p>For Windows, storage optimization is the process of migrating the file system data
/// to the new, larger disks.</p>
/// </li>
/// <li>
/// <p>For Lustre, storage optimization consists of rebalancing the data across the existing and
/// newly added file servers.</p>
/// </li>
/// </ul>
/// <p>You can track the storage optimization progress using the
/// <code>ProgressPercent</code> property. When
/// <code>STORAGE_OPTIMIZATION</code> completes successfully, the parent
/// <code>FILE_SYSTEM_UPDATE</code> action status changes to
/// <code>COMPLETED</code>. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html">Managing
/// storage capacity</a> in the <i>Amazon FSx for Windows File Server
/// User Guide</i> and <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-storage-capacity.html">Managing storage
/// and throughput capacity</a> in the <i>Amazon FSx for Lustre User
/// Guide</i>. </p>
/// </li>
/// <li>
/// <p>
/// <code>FILE_SYSTEM_ALIAS_ASSOCIATION</code> - A file system update to associate a new DNS alias with the file system.
/// For more information, see
/// .</p>
/// </li>
/// <li>
/// <p>
/// <code>FILE_SYSTEM_ALIAS_DISASSOCIATION</code> - A file system update to disassociate a DNS alias from the file system.
/// For more information, see .</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AdministrativeActionType {
    #[allow(missing_docs)] // documentation missing in model
    FileSystemAliasAssociation,
    #[allow(missing_docs)] // documentation missing in model
    FileSystemAliasDisassociation,
    #[allow(missing_docs)] // documentation missing in model
    FileSystemUpdate,
    #[allow(missing_docs)] // documentation missing in model
    StorageOptimization,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AdministrativeActionType {
    fn from(s: &str) -> Self {
        match s {
            "FILE_SYSTEM_ALIAS_ASSOCIATION" => AdministrativeActionType::FileSystemAliasAssociation,
            "FILE_SYSTEM_ALIAS_DISASSOCIATION" => {
                AdministrativeActionType::FileSystemAliasDisassociation
            }
            "FILE_SYSTEM_UPDATE" => AdministrativeActionType::FileSystemUpdate,
            "STORAGE_OPTIMIZATION" => AdministrativeActionType::StorageOptimization,
            other => AdministrativeActionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AdministrativeActionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AdministrativeActionType::from(s))
    }
}
impl AdministrativeActionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AdministrativeActionType::FileSystemAliasAssociation => "FILE_SYSTEM_ALIAS_ASSOCIATION",
            AdministrativeActionType::FileSystemAliasDisassociation => {
                "FILE_SYSTEM_ALIAS_DISASSOCIATION"
            }
            AdministrativeActionType::FileSystemUpdate => "FILE_SYSTEM_UPDATE",
            AdministrativeActionType::StorageOptimization => "STORAGE_OPTIMIZATION",
            AdministrativeActionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "FILE_SYSTEM_ALIAS_ASSOCIATION",
            "FILE_SYSTEM_ALIAS_DISASSOCIATION",
            "FILE_SYSTEM_UPDATE",
            "STORAGE_OPTIMIZATION",
        ]
    }
}
impl AsRef<str> for AdministrativeActionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The configuration for the Amazon FSx for Lustre file system.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LustreFileSystemConfiguration {
    /// <p>The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC
    /// time zone. d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.</p>
    pub weekly_maintenance_start_time: std::option::Option<std::string::String>,
    /// <p>The data repository configuration object for Lustre file systems returned in the response of
    /// the <code>CreateFileSystem</code> operation.</p>
    pub data_repository_configuration:
        std::option::Option<crate::model::DataRepositoryConfiguration>,
    /// <p>The deployment type of the FSX for Lustre file system. <i>Scratch deployment type</i> is designed for temporary storage
    /// and shorter-term processing of data.</p>
    /// <p>
    /// <code>SCRATCH_1</code> and <code>SCRATCH_2</code> deployment
    /// types are best suited for when you need temporary storage and shorter-term processing of data.
    /// The <code>SCRATCH_2</code> deployment type provides in-transit encryption of data and higher burst
    /// throughput capacity than <code>SCRATCH_1</code>.</p>
    /// <p>The <code>PERSISTENT_1</code> deployment type is used for longer-term storage
    /// and workloads and encryption of data in transit. To learn more about deployment types, see
    /// <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html">
    /// FSx for Lustre Deployment Options</a>. (Default = <code>SCRATCH_1</code>)</p>
    pub deployment_type: std::option::Option<crate::model::LustreDeploymentType>,
    /// <p> Per unit storage throughput represents the megabytes per second of read or write
    /// throughput per 1 tebibyte of storage provisioned. File system throughput capacity is
    /// equal to Storage capacity (TiB) * PerUnitStorageThroughput (MB/s/TiB). This option is
    /// only valid for <code>PERSISTENT_1</code> deployment types. </p>
    /// <p>Valid values for SSD storage: 50, 100, 200. Valid values for HDD storage: 12, 40. </p>
    pub per_unit_storage_throughput: std::option::Option<i32>,
    /// <p>You use the <code>MountName</code> value when mounting the file system.</p>
    /// <p>For the <code>SCRATCH_1</code> deployment type, this value is always "<code>fsx</code>".
    /// For <code>SCRATCH_2</code> and <code>PERSISTENT_1</code> deployment types, this
    /// value is a string that is unique within an Amazon Web Services Region.
    ///
    /// </p>
    pub mount_name: std::option::Option<std::string::String>,
    /// <p>A recurring daily time, in the format <code>HH:MM</code>. <code>HH</code> is the
    /// zero-padded hour of the day (0-23), and <code>MM</code> is the zero-padded minute of the
    /// hour. For example, <code>05:00</code> specifies 5 AM daily. </p>
    pub daily_automatic_backup_start_time: std::option::Option<std::string::String>,
    /// <p>The number of days to retain automatic backups. Setting this to 0 disables
    /// automatic backups. You can retain automatic backups for a maximum of 90 days. The default is 0.</p>
    pub automatic_backup_retention_days: std::option::Option<i32>,
    /// <p>A boolean flag indicating whether tags on the file system should be copied to backups.
    /// If it's set to true, all tags on the file system are
    /// copied to all automatic backups and any user-initiated backups where the user
    /// doesn't specify any tags. If this value is true, and you specify one or more tags,
    /// only the specified tags are copied to backups. If you specify one or more tags when
    /// creating a user-initiated backup, no tags are copied from the file system,
    /// regardless of this value. (Default = false)</p>
    pub copy_tags_to_backups: std::option::Option<bool>,
    /// <p>The type of drive cache used by PERSISTENT_1 file systems that are provisioned with
    /// HDD storage devices. This parameter is required when storage type is HDD. Set to
    /// <code>READ</code>, improve the performance for frequently accessed files and allows 20%
    /// of the total storage capacity of the file system to be cached.  </p>
    /// <p>This parameter is required when <code>StorageType</code> is set to HDD.</p>
    pub drive_cache_type: std::option::Option<crate::model::DriveCacheType>,
    /// <p>The data compression configuration for the file system. <code>DataCompressionType</code>
    /// can have the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code> - Data compression is turned off for
    /// the file system.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LZ4</code> - Data compression is turned on with the LZ4
    /// algorithm.</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data compression</a>.</p>
    pub data_compression_type: std::option::Option<crate::model::DataCompressionType>,
}
impl LustreFileSystemConfiguration {
    /// <p>The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC
    /// time zone. d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.</p>
    pub fn weekly_maintenance_start_time(&self) -> std::option::Option<&str> {
        self.weekly_maintenance_start_time.as_deref()
    }
    /// <p>The data repository configuration object for Lustre file systems returned in the response of
    /// the <code>CreateFileSystem</code> operation.</p>
    pub fn data_repository_configuration(
        &self,
    ) -> std::option::Option<&crate::model::DataRepositoryConfiguration> {
        self.data_repository_configuration.as_ref()
    }
    /// <p>The deployment type of the FSX for Lustre file system. <i>Scratch deployment type</i> is designed for temporary storage
    /// and shorter-term processing of data.</p>
    /// <p>
    /// <code>SCRATCH_1</code> and <code>SCRATCH_2</code> deployment
    /// types are best suited for when you need temporary storage and shorter-term processing of data.
    /// The <code>SCRATCH_2</code> deployment type provides in-transit encryption of data and higher burst
    /// throughput capacity than <code>SCRATCH_1</code>.</p>
    /// <p>The <code>PERSISTENT_1</code> deployment type is used for longer-term storage
    /// and workloads and encryption of data in transit. To learn more about deployment types, see
    /// <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html">
    /// FSx for Lustre Deployment Options</a>. (Default = <code>SCRATCH_1</code>)</p>
    pub fn deployment_type(&self) -> std::option::Option<&crate::model::LustreDeploymentType> {
        self.deployment_type.as_ref()
    }
    /// <p> Per unit storage throughput represents the megabytes per second of read or write
    /// throughput per 1 tebibyte of storage provisioned. File system throughput capacity is
    /// equal to Storage capacity (TiB) * PerUnitStorageThroughput (MB/s/TiB). This option is
    /// only valid for <code>PERSISTENT_1</code> deployment types. </p>
    /// <p>Valid values for SSD storage: 50, 100, 200. Valid values for HDD storage: 12, 40. </p>
    pub fn per_unit_storage_throughput(&self) -> std::option::Option<i32> {
        self.per_unit_storage_throughput
    }
    /// <p>You use the <code>MountName</code> value when mounting the file system.</p>
    /// <p>For the <code>SCRATCH_1</code> deployment type, this value is always "<code>fsx</code>".
    /// For <code>SCRATCH_2</code> and <code>PERSISTENT_1</code> deployment types, this
    /// value is a string that is unique within an Amazon Web Services Region.
    ///
    /// </p>
    pub fn mount_name(&self) -> std::option::Option<&str> {
        self.mount_name.as_deref()
    }
    /// <p>A recurring daily time, in the format <code>HH:MM</code>. <code>HH</code> is the
    /// zero-padded hour of the day (0-23), and <code>MM</code> is the zero-padded minute of the
    /// hour. For example, <code>05:00</code> specifies 5 AM daily. </p>
    pub fn daily_automatic_backup_start_time(&self) -> std::option::Option<&str> {
        self.daily_automatic_backup_start_time.as_deref()
    }
    /// <p>The number of days to retain automatic backups. Setting this to 0 disables
    /// automatic backups. You can retain automatic backups for a maximum of 90 days. The default is 0.</p>
    pub fn automatic_backup_retention_days(&self) -> std::option::Option<i32> {
        self.automatic_backup_retention_days
    }
    /// <p>A boolean flag indicating whether tags on the file system should be copied to backups.
    /// If it's set to true, all tags on the file system are
    /// copied to all automatic backups and any user-initiated backups where the user
    /// doesn't specify any tags. If this value is true, and you specify one or more tags,
    /// only the specified tags are copied to backups. If you specify one or more tags when
    /// creating a user-initiated backup, no tags are copied from the file system,
    /// regardless of this value. (Default = false)</p>
    pub fn copy_tags_to_backups(&self) -> std::option::Option<bool> {
        self.copy_tags_to_backups
    }
    /// <p>The type of drive cache used by PERSISTENT_1 file systems that are provisioned with
    /// HDD storage devices. This parameter is required when storage type is HDD. Set to
    /// <code>READ</code>, improve the performance for frequently accessed files and allows 20%
    /// of the total storage capacity of the file system to be cached.  </p>
    /// <p>This parameter is required when <code>StorageType</code> is set to HDD.</p>
    pub fn drive_cache_type(&self) -> std::option::Option<&crate::model::DriveCacheType> {
        self.drive_cache_type.as_ref()
    }
    /// <p>The data compression configuration for the file system. <code>DataCompressionType</code>
    /// can have the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code> - Data compression is turned off for
    /// the file system.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LZ4</code> - Data compression is turned on with the LZ4
    /// algorithm.</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data compression</a>.</p>
    pub fn data_compression_type(&self) -> std::option::Option<&crate::model::DataCompressionType> {
        self.data_compression_type.as_ref()
    }
}
impl std::fmt::Debug for LustreFileSystemConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LustreFileSystemConfiguration");
        formatter.field(
            "weekly_maintenance_start_time",
            &self.weekly_maintenance_start_time,
        );
        formatter.field(
            "data_repository_configuration",
            &self.data_repository_configuration,
        );
        formatter.field("deployment_type", &self.deployment_type);
        formatter.field(
            "per_unit_storage_throughput",
            &self.per_unit_storage_throughput,
        );
        formatter.field("mount_name", &self.mount_name);
        formatter.field(
            "daily_automatic_backup_start_time",
            &self.daily_automatic_backup_start_time,
        );
        formatter.field(
            "automatic_backup_retention_days",
            &self.automatic_backup_retention_days,
        );
        formatter.field("copy_tags_to_backups", &self.copy_tags_to_backups);
        formatter.field("drive_cache_type", &self.drive_cache_type);
        formatter.field("data_compression_type", &self.data_compression_type);
        formatter.finish()
    }
}
/// See [`LustreFileSystemConfiguration`](crate::model::LustreFileSystemConfiguration)
pub mod lustre_file_system_configuration {
    /// A builder for [`LustreFileSystemConfiguration`](crate::model::LustreFileSystemConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) weekly_maintenance_start_time: std::option::Option<std::string::String>,
        pub(crate) data_repository_configuration:
            std::option::Option<crate::model::DataRepositoryConfiguration>,
        pub(crate) deployment_type: std::option::Option<crate::model::LustreDeploymentType>,
        pub(crate) per_unit_storage_throughput: std::option::Option<i32>,
        pub(crate) mount_name: std::option::Option<std::string::String>,
        pub(crate) daily_automatic_backup_start_time: std::option::Option<std::string::String>,
        pub(crate) automatic_backup_retention_days: std::option::Option<i32>,
        pub(crate) copy_tags_to_backups: std::option::Option<bool>,
        pub(crate) drive_cache_type: std::option::Option<crate::model::DriveCacheType>,
        pub(crate) data_compression_type: std::option::Option<crate::model::DataCompressionType>,
    }
    impl Builder {
        /// <p>The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC
        /// time zone. d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.</p>
        pub fn weekly_maintenance_start_time(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.weekly_maintenance_start_time = Some(input.into());
            self
        }
        /// <p>The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC
        /// time zone. d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.</p>
        pub fn set_weekly_maintenance_start_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.weekly_maintenance_start_time = input;
            self
        }
        /// <p>The data repository configuration object for Lustre file systems returned in the response of
        /// the <code>CreateFileSystem</code> operation.</p>
        pub fn data_repository_configuration(
            mut self,
            input: crate::model::DataRepositoryConfiguration,
        ) -> Self {
            self.data_repository_configuration = Some(input);
            self
        }
        /// <p>The data repository configuration object for Lustre file systems returned in the response of
        /// the <code>CreateFileSystem</code> operation.</p>
        pub fn set_data_repository_configuration(
            mut self,
            input: std::option::Option<crate::model::DataRepositoryConfiguration>,
        ) -> Self {
            self.data_repository_configuration = input;
            self
        }
        /// <p>The deployment type of the FSX for Lustre file system. <i>Scratch deployment type</i> is designed for temporary storage
        /// and shorter-term processing of data.</p>
        /// <p>
        /// <code>SCRATCH_1</code> and <code>SCRATCH_2</code> deployment
        /// types are best suited for when you need temporary storage and shorter-term processing of data.
        /// The <code>SCRATCH_2</code> deployment type provides in-transit encryption of data and higher burst
        /// throughput capacity than <code>SCRATCH_1</code>.</p>
        /// <p>The <code>PERSISTENT_1</code> deployment type is used for longer-term storage
        /// and workloads and encryption of data in transit. To learn more about deployment types, see
        /// <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html">
        /// FSx for Lustre Deployment Options</a>. (Default = <code>SCRATCH_1</code>)</p>
        pub fn deployment_type(mut self, input: crate::model::LustreDeploymentType) -> Self {
            self.deployment_type = Some(input);
            self
        }
        /// <p>The deployment type of the FSX for Lustre file system. <i>Scratch deployment type</i> is designed for temporary storage
        /// and shorter-term processing of data.</p>
        /// <p>
        /// <code>SCRATCH_1</code> and <code>SCRATCH_2</code> deployment
        /// types are best suited for when you need temporary storage and shorter-term processing of data.
        /// The <code>SCRATCH_2</code> deployment type provides in-transit encryption of data and higher burst
        /// throughput capacity than <code>SCRATCH_1</code>.</p>
        /// <p>The <code>PERSISTENT_1</code> deployment type is used for longer-term storage
        /// and workloads and encryption of data in transit. To learn more about deployment types, see
        /// <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html">
        /// FSx for Lustre Deployment Options</a>. (Default = <code>SCRATCH_1</code>)</p>
        pub fn set_deployment_type(
            mut self,
            input: std::option::Option<crate::model::LustreDeploymentType>,
        ) -> Self {
            self.deployment_type = input;
            self
        }
        /// <p> Per unit storage throughput represents the megabytes per second of read or write
        /// throughput per 1 tebibyte of storage provisioned. File system throughput capacity is
        /// equal to Storage capacity (TiB) * PerUnitStorageThroughput (MB/s/TiB). This option is
        /// only valid for <code>PERSISTENT_1</code> deployment types. </p>
        /// <p>Valid values for SSD storage: 50, 100, 200. Valid values for HDD storage: 12, 40. </p>
        pub fn per_unit_storage_throughput(mut self, input: i32) -> Self {
            self.per_unit_storage_throughput = Some(input);
            self
        }
        /// <p> Per unit storage throughput represents the megabytes per second of read or write
        /// throughput per 1 tebibyte of storage provisioned. File system throughput capacity is
        /// equal to Storage capacity (TiB) * PerUnitStorageThroughput (MB/s/TiB). This option is
        /// only valid for <code>PERSISTENT_1</code> deployment types. </p>
        /// <p>Valid values for SSD storage: 50, 100, 200. Valid values for HDD storage: 12, 40. </p>
        pub fn set_per_unit_storage_throughput(mut self, input: std::option::Option<i32>) -> Self {
            self.per_unit_storage_throughput = input;
            self
        }
        /// <p>You use the <code>MountName</code> value when mounting the file system.</p>
        /// <p>For the <code>SCRATCH_1</code> deployment type, this value is always "<code>fsx</code>".
        /// For <code>SCRATCH_2</code> and <code>PERSISTENT_1</code> deployment types, this
        /// value is a string that is unique within an Amazon Web Services Region.
        ///
        /// </p>
        pub fn mount_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mount_name = Some(input.into());
            self
        }
        /// <p>You use the <code>MountName</code> value when mounting the file system.</p>
        /// <p>For the <code>SCRATCH_1</code> deployment type, this value is always "<code>fsx</code>".
        /// For <code>SCRATCH_2</code> and <code>PERSISTENT_1</code> deployment types, this
        /// value is a string that is unique within an Amazon Web Services Region.
        ///
        /// </p>
        pub fn set_mount_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mount_name = input;
            self
        }
        /// <p>A recurring daily time, in the format <code>HH:MM</code>. <code>HH</code> is the
        /// zero-padded hour of the day (0-23), and <code>MM</code> is the zero-padded minute of the
        /// hour. For example, <code>05:00</code> specifies 5 AM daily. </p>
        pub fn daily_automatic_backup_start_time(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.daily_automatic_backup_start_time = Some(input.into());
            self
        }
        /// <p>A recurring daily time, in the format <code>HH:MM</code>. <code>HH</code> is the
        /// zero-padded hour of the day (0-23), and <code>MM</code> is the zero-padded minute of the
        /// hour. For example, <code>05:00</code> specifies 5 AM daily. </p>
        pub fn set_daily_automatic_backup_start_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.daily_automatic_backup_start_time = input;
            self
        }
        /// <p>The number of days to retain automatic backups. Setting this to 0 disables
        /// automatic backups. You can retain automatic backups for a maximum of 90 days. The default is 0.</p>
        pub fn automatic_backup_retention_days(mut self, input: i32) -> Self {
            self.automatic_backup_retention_days = Some(input);
            self
        }
        /// <p>The number of days to retain automatic backups. Setting this to 0 disables
        /// automatic backups. You can retain automatic backups for a maximum of 90 days. The default is 0.</p>
        pub fn set_automatic_backup_retention_days(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.automatic_backup_retention_days = input;
            self
        }
        /// <p>A boolean flag indicating whether tags on the file system should be copied to backups.
        /// If it's set to true, all tags on the file system are
        /// copied to all automatic backups and any user-initiated backups where the user
        /// doesn't specify any tags. If this value is true, and you specify one or more tags,
        /// only the specified tags are copied to backups. If you specify one or more tags when
        /// creating a user-initiated backup, no tags are copied from the file system,
        /// regardless of this value. (Default = false)</p>
        pub fn copy_tags_to_backups(mut self, input: bool) -> Self {
            self.copy_tags_to_backups = Some(input);
            self
        }
        /// <p>A boolean flag indicating whether tags on the file system should be copied to backups.
        /// If it's set to true, all tags on the file system are
        /// copied to all automatic backups and any user-initiated backups where the user
        /// doesn't specify any tags. If this value is true, and you specify one or more tags,
        /// only the specified tags are copied to backups. If you specify one or more tags when
        /// creating a user-initiated backup, no tags are copied from the file system,
        /// regardless of this value. (Default = false)</p>
        pub fn set_copy_tags_to_backups(mut self, input: std::option::Option<bool>) -> Self {
            self.copy_tags_to_backups = input;
            self
        }
        /// <p>The type of drive cache used by PERSISTENT_1 file systems that are provisioned with
        /// HDD storage devices. This parameter is required when storage type is HDD. Set to
        /// <code>READ</code>, improve the performance for frequently accessed files and allows 20%
        /// of the total storage capacity of the file system to be cached.  </p>
        /// <p>This parameter is required when <code>StorageType</code> is set to HDD.</p>
        pub fn drive_cache_type(mut self, input: crate::model::DriveCacheType) -> Self {
            self.drive_cache_type = Some(input);
            self
        }
        /// <p>The type of drive cache used by PERSISTENT_1 file systems that are provisioned with
        /// HDD storage devices. This parameter is required when storage type is HDD. Set to
        /// <code>READ</code>, improve the performance for frequently accessed files and allows 20%
        /// of the total storage capacity of the file system to be cached.  </p>
        /// <p>This parameter is required when <code>StorageType</code> is set to HDD.</p>
        pub fn set_drive_cache_type(
            mut self,
            input: std::option::Option<crate::model::DriveCacheType>,
        ) -> Self {
            self.drive_cache_type = input;
            self
        }
        /// <p>The data compression configuration for the file system. <code>DataCompressionType</code>
        /// can have the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code> - Data compression is turned off for
        /// the file system.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LZ4</code> - Data compression is turned on with the LZ4
        /// algorithm.</p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data compression</a>.</p>
        pub fn data_compression_type(mut self, input: crate::model::DataCompressionType) -> Self {
            self.data_compression_type = Some(input);
            self
        }
        /// <p>The data compression configuration for the file system. <code>DataCompressionType</code>
        /// can have the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code> - Data compression is turned off for
        /// the file system.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LZ4</code> - Data compression is turned on with the LZ4
        /// algorithm.</p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data compression</a>.</p>
        pub fn set_data_compression_type(
            mut self,
            input: std::option::Option<crate::model::DataCompressionType>,
        ) -> Self {
            self.data_compression_type = input;
            self
        }
        /// Consumes the builder and constructs a [`LustreFileSystemConfiguration`](crate::model::LustreFileSystemConfiguration)
        pub fn build(self) -> crate::model::LustreFileSystemConfiguration {
            crate::model::LustreFileSystemConfiguration {
                weekly_maintenance_start_time: self.weekly_maintenance_start_time,
                data_repository_configuration: self.data_repository_configuration,
                deployment_type: self.deployment_type,
                per_unit_storage_throughput: self.per_unit_storage_throughput,
                mount_name: self.mount_name,
                daily_automatic_backup_start_time: self.daily_automatic_backup_start_time,
                automatic_backup_retention_days: self.automatic_backup_retention_days,
                copy_tags_to_backups: self.copy_tags_to_backups,
                drive_cache_type: self.drive_cache_type,
                data_compression_type: self.data_compression_type,
            }
        }
    }
}
impl LustreFileSystemConfiguration {
    /// Creates a new builder-style object to manufacture [`LustreFileSystemConfiguration`](crate::model::LustreFileSystemConfiguration)
    pub fn builder() -> crate::model::lustre_file_system_configuration::Builder {
        crate::model::lustre_file_system_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataCompressionType {
    #[allow(missing_docs)] // documentation missing in model
    Lz4,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataCompressionType {
    fn from(s: &str) -> Self {
        match s {
            "LZ4" => DataCompressionType::Lz4,
            "NONE" => DataCompressionType::None,
            other => DataCompressionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataCompressionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataCompressionType::from(s))
    }
}
impl DataCompressionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataCompressionType::Lz4 => "LZ4",
            DataCompressionType::None => "NONE",
            DataCompressionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LZ4", "NONE"]
    }
}
impl AsRef<str> for DataCompressionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DriveCacheType {
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Read,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DriveCacheType {
    fn from(s: &str) -> Self {
        match s {
            "NONE" => DriveCacheType::None,
            "READ" => DriveCacheType::Read,
            other => DriveCacheType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DriveCacheType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DriveCacheType::from(s))
    }
}
impl DriveCacheType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DriveCacheType::None => "NONE",
            DriveCacheType::Read => "READ",
            DriveCacheType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NONE", "READ"]
    }
}
impl AsRef<str> for DriveCacheType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LustreDeploymentType {
    #[allow(missing_docs)] // documentation missing in model
    Persistent1,
    #[allow(missing_docs)] // documentation missing in model
    Scratch1,
    #[allow(missing_docs)] // documentation missing in model
    Scratch2,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LustreDeploymentType {
    fn from(s: &str) -> Self {
        match s {
            "PERSISTENT_1" => LustreDeploymentType::Persistent1,
            "SCRATCH_1" => LustreDeploymentType::Scratch1,
            "SCRATCH_2" => LustreDeploymentType::Scratch2,
            other => LustreDeploymentType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LustreDeploymentType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LustreDeploymentType::from(s))
    }
}
impl LustreDeploymentType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LustreDeploymentType::Persistent1 => "PERSISTENT_1",
            LustreDeploymentType::Scratch1 => "SCRATCH_1",
            LustreDeploymentType::Scratch2 => "SCRATCH_2",
            LustreDeploymentType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PERSISTENT_1", "SCRATCH_1", "SCRATCH_2"]
    }
}
impl AsRef<str> for LustreDeploymentType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The data repository configuration object for Lustre file systems returned in the response of
/// the <code>CreateFileSystem</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataRepositoryConfiguration {
    /// <p>Describes the state of the file system's S3 durable data repository, if it is configured with an S3 repository.
    /// The lifecycle can have the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATING</code> - The data repository configuration between
    /// the FSx file system and the linked S3 data repository is being created.
    /// The data repository is unavailable.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AVAILABLE</code> - The data repository is available for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MISCONFIGURED</code> - Amazon FSx cannot automatically import updates from the S3 bucket
    /// until the data repository configuration is corrected. For more information, see
    /// <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/troubleshooting.html#troubleshooting-misconfigured-data-repository">Troubleshooting a Misconfigured linked S3 bucket</a>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATING</code> - The data repository is undergoing a customer initiated update and availability may be impacted.</p>
    /// </li>
    /// </ul>
    pub lifecycle: std::option::Option<crate::model::DataRepositoryLifecycle>,
    /// <p>The import path to the Amazon S3 bucket (and optional prefix) that you're using
    /// as the data repository for your FSx for Lustre file system, for example
    /// <code>s3://import-bucket/optional-prefix</code>. If a prefix is specified after the
    /// Amazon S3 bucket name, only object keys with that prefix are loaded into the file
    /// system.</p>
    pub import_path: std::option::Option<std::string::String>,
    /// <p>The export path to the Amazon S3 bucket (and prefix) that you are using to store new and
    /// changed Lustre file system files in S3.</p>
    pub export_path: std::option::Option<std::string::String>,
    /// <p>For files imported from a data repository, this value determines the stripe count and
    /// maximum amount of data per file (in MiB) stored on a single physical disk. The maximum
    /// number of disks that a single file can be striped across is limited by the total number
    /// of disks that make up the file system.</p>
    ///
    /// <p>The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500
    /// GiB). Amazon S3 objects have a maximum size of 5 TB.</p>
    pub imported_file_chunk_size: std::option::Option<i32>,
    /// <p>Describes the file system's linked S3 data repository's <code>AutoImportPolicy</code>.
    /// The AutoImportPolicy configures how Amazon FSx keeps your file and directory listings up to date
    /// as you add or modify objects in your linked S3 bucket. <code>AutoImportPolicy</code> can have the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code> - (Default) AutoImport is off. Amazon FSx only updates
    /// file and directory listings from the linked S3 bucket
    /// when the file system is created. FSx does not update file and directory
    /// listings for any new or changed objects after choosing this option.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NEW</code> - AutoImport is on. Amazon FSx automatically imports
    /// directory listings of any new objects added to the linked S3 bucket that
    /// do not currently exist in the FSx file system. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NEW_CHANGED</code> - AutoImport is on. Amazon FSx automatically imports
    /// file and directory listings of any new objects added to the S3 bucket and any
    /// existing objects that are changed in the S3 bucket after you choose this option.
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/autoimport-data-repo.html">Automatically import updates from your S3 bucket</a>.</p>
    pub auto_import_policy: std::option::Option<crate::model::AutoImportPolicyType>,
    /// <p>Provides detailed information about the data respository if its <code>Lifecycle</code> is
    /// set to <code>MISCONFIGURED</code>.</p>
    pub failure_details: std::option::Option<crate::model::DataRepositoryFailureDetails>,
}
impl DataRepositoryConfiguration {
    /// <p>Describes the state of the file system's S3 durable data repository, if it is configured with an S3 repository.
    /// The lifecycle can have the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATING</code> - The data repository configuration between
    /// the FSx file system and the linked S3 data repository is being created.
    /// The data repository is unavailable.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AVAILABLE</code> - The data repository is available for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MISCONFIGURED</code> - Amazon FSx cannot automatically import updates from the S3 bucket
    /// until the data repository configuration is corrected. For more information, see
    /// <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/troubleshooting.html#troubleshooting-misconfigured-data-repository">Troubleshooting a Misconfigured linked S3 bucket</a>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATING</code> - The data repository is undergoing a customer initiated update and availability may be impacted.</p>
    /// </li>
    /// </ul>
    pub fn lifecycle(&self) -> std::option::Option<&crate::model::DataRepositoryLifecycle> {
        self.lifecycle.as_ref()
    }
    /// <p>The import path to the Amazon S3 bucket (and optional prefix) that you're using
    /// as the data repository for your FSx for Lustre file system, for example
    /// <code>s3://import-bucket/optional-prefix</code>. If a prefix is specified after the
    /// Amazon S3 bucket name, only object keys with that prefix are loaded into the file
    /// system.</p>
    pub fn import_path(&self) -> std::option::Option<&str> {
        self.import_path.as_deref()
    }
    /// <p>The export path to the Amazon S3 bucket (and prefix) that you are using to store new and
    /// changed Lustre file system files in S3.</p>
    pub fn export_path(&self) -> std::option::Option<&str> {
        self.export_path.as_deref()
    }
    /// <p>For files imported from a data repository, this value determines the stripe count and
    /// maximum amount of data per file (in MiB) stored on a single physical disk. The maximum
    /// number of disks that a single file can be striped across is limited by the total number
    /// of disks that make up the file system.</p>
    ///
    /// <p>The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500
    /// GiB). Amazon S3 objects have a maximum size of 5 TB.</p>
    pub fn imported_file_chunk_size(&self) -> std::option::Option<i32> {
        self.imported_file_chunk_size
    }
    /// <p>Describes the file system's linked S3 data repository's <code>AutoImportPolicy</code>.
    /// The AutoImportPolicy configures how Amazon FSx keeps your file and directory listings up to date
    /// as you add or modify objects in your linked S3 bucket. <code>AutoImportPolicy</code> can have the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code> - (Default) AutoImport is off. Amazon FSx only updates
    /// file and directory listings from the linked S3 bucket
    /// when the file system is created. FSx does not update file and directory
    /// listings for any new or changed objects after choosing this option.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NEW</code> - AutoImport is on. Amazon FSx automatically imports
    /// directory listings of any new objects added to the linked S3 bucket that
    /// do not currently exist in the FSx file system. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NEW_CHANGED</code> - AutoImport is on. Amazon FSx automatically imports
    /// file and directory listings of any new objects added to the S3 bucket and any
    /// existing objects that are changed in the S3 bucket after you choose this option.
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/autoimport-data-repo.html">Automatically import updates from your S3 bucket</a>.</p>
    pub fn auto_import_policy(&self) -> std::option::Option<&crate::model::AutoImportPolicyType> {
        self.auto_import_policy.as_ref()
    }
    /// <p>Provides detailed information about the data respository if its <code>Lifecycle</code> is
    /// set to <code>MISCONFIGURED</code>.</p>
    pub fn failure_details(
        &self,
    ) -> std::option::Option<&crate::model::DataRepositoryFailureDetails> {
        self.failure_details.as_ref()
    }
}
impl std::fmt::Debug for DataRepositoryConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataRepositoryConfiguration");
        formatter.field("lifecycle", &self.lifecycle);
        formatter.field("import_path", &self.import_path);
        formatter.field("export_path", &self.export_path);
        formatter.field("imported_file_chunk_size", &self.imported_file_chunk_size);
        formatter.field("auto_import_policy", &self.auto_import_policy);
        formatter.field("failure_details", &self.failure_details);
        formatter.finish()
    }
}
/// See [`DataRepositoryConfiguration`](crate::model::DataRepositoryConfiguration)
pub mod data_repository_configuration {
    /// A builder for [`DataRepositoryConfiguration`](crate::model::DataRepositoryConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lifecycle: std::option::Option<crate::model::DataRepositoryLifecycle>,
        pub(crate) import_path: std::option::Option<std::string::String>,
        pub(crate) export_path: std::option::Option<std::string::String>,
        pub(crate) imported_file_chunk_size: std::option::Option<i32>,
        pub(crate) auto_import_policy: std::option::Option<crate::model::AutoImportPolicyType>,
        pub(crate) failure_details: std::option::Option<crate::model::DataRepositoryFailureDetails>,
    }
    impl Builder {
        /// <p>Describes the state of the file system's S3 durable data repository, if it is configured with an S3 repository.
        /// The lifecycle can have the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATING</code> - The data repository configuration between
        /// the FSx file system and the linked S3 data repository is being created.
        /// The data repository is unavailable.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AVAILABLE</code> - The data repository is available for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MISCONFIGURED</code> - Amazon FSx cannot automatically import updates from the S3 bucket
        /// until the data repository configuration is corrected. For more information, see
        /// <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/troubleshooting.html#troubleshooting-misconfigured-data-repository">Troubleshooting a Misconfigured linked S3 bucket</a>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATING</code> - The data repository is undergoing a customer initiated update and availability may be impacted.</p>
        /// </li>
        /// </ul>
        pub fn lifecycle(mut self, input: crate::model::DataRepositoryLifecycle) -> Self {
            self.lifecycle = Some(input);
            self
        }
        /// <p>Describes the state of the file system's S3 durable data repository, if it is configured with an S3 repository.
        /// The lifecycle can have the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATING</code> - The data repository configuration between
        /// the FSx file system and the linked S3 data repository is being created.
        /// The data repository is unavailable.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AVAILABLE</code> - The data repository is available for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MISCONFIGURED</code> - Amazon FSx cannot automatically import updates from the S3 bucket
        /// until the data repository configuration is corrected. For more information, see
        /// <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/troubleshooting.html#troubleshooting-misconfigured-data-repository">Troubleshooting a Misconfigured linked S3 bucket</a>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATING</code> - The data repository is undergoing a customer initiated update and availability may be impacted.</p>
        /// </li>
        /// </ul>
        pub fn set_lifecycle(
            mut self,
            input: std::option::Option<crate::model::DataRepositoryLifecycle>,
        ) -> Self {
            self.lifecycle = input;
            self
        }
        /// <p>The import path to the Amazon S3 bucket (and optional prefix) that you're using
        /// as the data repository for your FSx for Lustre file system, for example
        /// <code>s3://import-bucket/optional-prefix</code>. If a prefix is specified after the
        /// Amazon S3 bucket name, only object keys with that prefix are loaded into the file
        /// system.</p>
        pub fn import_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.import_path = Some(input.into());
            self
        }
        /// <p>The import path to the Amazon S3 bucket (and optional prefix) that you're using
        /// as the data repository for your FSx for Lustre file system, for example
        /// <code>s3://import-bucket/optional-prefix</code>. If a prefix is specified after the
        /// Amazon S3 bucket name, only object keys with that prefix are loaded into the file
        /// system.</p>
        pub fn set_import_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.import_path = input;
            self
        }
        /// <p>The export path to the Amazon S3 bucket (and prefix) that you are using to store new and
        /// changed Lustre file system files in S3.</p>
        pub fn export_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.export_path = Some(input.into());
            self
        }
        /// <p>The export path to the Amazon S3 bucket (and prefix) that you are using to store new and
        /// changed Lustre file system files in S3.</p>
        pub fn set_export_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.export_path = input;
            self
        }
        /// <p>For files imported from a data repository, this value determines the stripe count and
        /// maximum amount of data per file (in MiB) stored on a single physical disk. The maximum
        /// number of disks that a single file can be striped across is limited by the total number
        /// of disks that make up the file system.</p>
        ///
        /// <p>The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500
        /// GiB). Amazon S3 objects have a maximum size of 5 TB.</p>
        pub fn imported_file_chunk_size(mut self, input: i32) -> Self {
            self.imported_file_chunk_size = Some(input);
            self
        }
        /// <p>For files imported from a data repository, this value determines the stripe count and
        /// maximum amount of data per file (in MiB) stored on a single physical disk. The maximum
        /// number of disks that a single file can be striped across is limited by the total number
        /// of disks that make up the file system.</p>
        ///
        /// <p>The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500
        /// GiB). Amazon S3 objects have a maximum size of 5 TB.</p>
        pub fn set_imported_file_chunk_size(mut self, input: std::option::Option<i32>) -> Self {
            self.imported_file_chunk_size = input;
            self
        }
        /// <p>Describes the file system's linked S3 data repository's <code>AutoImportPolicy</code>.
        /// The AutoImportPolicy configures how Amazon FSx keeps your file and directory listings up to date
        /// as you add or modify objects in your linked S3 bucket. <code>AutoImportPolicy</code> can have the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code> - (Default) AutoImport is off. Amazon FSx only updates
        /// file and directory listings from the linked S3 bucket
        /// when the file system is created. FSx does not update file and directory
        /// listings for any new or changed objects after choosing this option.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NEW</code> - AutoImport is on. Amazon FSx automatically imports
        /// directory listings of any new objects added to the linked S3 bucket that
        /// do not currently exist in the FSx file system. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NEW_CHANGED</code> - AutoImport is on. Amazon FSx automatically imports
        /// file and directory listings of any new objects added to the S3 bucket and any
        /// existing objects that are changed in the S3 bucket after you choose this option.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/autoimport-data-repo.html">Automatically import updates from your S3 bucket</a>.</p>
        pub fn auto_import_policy(mut self, input: crate::model::AutoImportPolicyType) -> Self {
            self.auto_import_policy = Some(input);
            self
        }
        /// <p>Describes the file system's linked S3 data repository's <code>AutoImportPolicy</code>.
        /// The AutoImportPolicy configures how Amazon FSx keeps your file and directory listings up to date
        /// as you add or modify objects in your linked S3 bucket. <code>AutoImportPolicy</code> can have the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code> - (Default) AutoImport is off. Amazon FSx only updates
        /// file and directory listings from the linked S3 bucket
        /// when the file system is created. FSx does not update file and directory
        /// listings for any new or changed objects after choosing this option.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NEW</code> - AutoImport is on. Amazon FSx automatically imports
        /// directory listings of any new objects added to the linked S3 bucket that
        /// do not currently exist in the FSx file system. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NEW_CHANGED</code> - AutoImport is on. Amazon FSx automatically imports
        /// file and directory listings of any new objects added to the S3 bucket and any
        /// existing objects that are changed in the S3 bucket after you choose this option.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/autoimport-data-repo.html">Automatically import updates from your S3 bucket</a>.</p>
        pub fn set_auto_import_policy(
            mut self,
            input: std::option::Option<crate::model::AutoImportPolicyType>,
        ) -> Self {
            self.auto_import_policy = input;
            self
        }
        /// <p>Provides detailed information about the data respository if its <code>Lifecycle</code> is
        /// set to <code>MISCONFIGURED</code>.</p>
        pub fn failure_details(
            mut self,
            input: crate::model::DataRepositoryFailureDetails,
        ) -> Self {
            self.failure_details = Some(input);
            self
        }
        /// <p>Provides detailed information about the data respository if its <code>Lifecycle</code> is
        /// set to <code>MISCONFIGURED</code>.</p>
        pub fn set_failure_details(
            mut self,
            input: std::option::Option<crate::model::DataRepositoryFailureDetails>,
        ) -> Self {
            self.failure_details = input;
            self
        }
        /// Consumes the builder and constructs a [`DataRepositoryConfiguration`](crate::model::DataRepositoryConfiguration)
        pub fn build(self) -> crate::model::DataRepositoryConfiguration {
            crate::model::DataRepositoryConfiguration {
                lifecycle: self.lifecycle,
                import_path: self.import_path,
                export_path: self.export_path,
                imported_file_chunk_size: self.imported_file_chunk_size,
                auto_import_policy: self.auto_import_policy,
                failure_details: self.failure_details,
            }
        }
    }
}
impl DataRepositoryConfiguration {
    /// Creates a new builder-style object to manufacture [`DataRepositoryConfiguration`](crate::model::DataRepositoryConfiguration)
    pub fn builder() -> crate::model::data_repository_configuration::Builder {
        crate::model::data_repository_configuration::Builder::default()
    }
}

/// <p>Provides detailed information about the data respository if its <code>Lifecycle</code> is
/// set to <code>MISCONFIGURED</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataRepositoryFailureDetails {
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl DataRepositoryFailureDetails {
    /// <p>A detailed error message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for DataRepositoryFailureDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataRepositoryFailureDetails");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`DataRepositoryFailureDetails`](crate::model::DataRepositoryFailureDetails)
pub mod data_repository_failure_details {
    /// A builder for [`DataRepositoryFailureDetails`](crate::model::DataRepositoryFailureDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DataRepositoryFailureDetails`](crate::model::DataRepositoryFailureDetails)
        pub fn build(self) -> crate::model::DataRepositoryFailureDetails {
            crate::model::DataRepositoryFailureDetails {
                message: self.message,
            }
        }
    }
}
impl DataRepositoryFailureDetails {
    /// Creates a new builder-style object to manufacture [`DataRepositoryFailureDetails`](crate::model::DataRepositoryFailureDetails)
    pub fn builder() -> crate::model::data_repository_failure_details::Builder {
        crate::model::data_repository_failure_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AutoImportPolicyType {
    #[allow(missing_docs)] // documentation missing in model
    New,
    #[allow(missing_docs)] // documentation missing in model
    NewChanged,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AutoImportPolicyType {
    fn from(s: &str) -> Self {
        match s {
            "NEW" => AutoImportPolicyType::New,
            "NEW_CHANGED" => AutoImportPolicyType::NewChanged,
            "NONE" => AutoImportPolicyType::None,
            other => AutoImportPolicyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AutoImportPolicyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AutoImportPolicyType::from(s))
    }
}
impl AutoImportPolicyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AutoImportPolicyType::New => "NEW",
            AutoImportPolicyType::NewChanged => "NEW_CHANGED",
            AutoImportPolicyType::None => "NONE",
            AutoImportPolicyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NEW", "NEW_CHANGED", "NONE"]
    }
}
impl AsRef<str> for AutoImportPolicyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataRepositoryLifecycle {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Misconfigured,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataRepositoryLifecycle {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => DataRepositoryLifecycle::Available,
            "CREATING" => DataRepositoryLifecycle::Creating,
            "DELETING" => DataRepositoryLifecycle::Deleting,
            "MISCONFIGURED" => DataRepositoryLifecycle::Misconfigured,
            "UPDATING" => DataRepositoryLifecycle::Updating,
            other => DataRepositoryLifecycle::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataRepositoryLifecycle {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataRepositoryLifecycle::from(s))
    }
}
impl DataRepositoryLifecycle {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataRepositoryLifecycle::Available => "AVAILABLE",
            DataRepositoryLifecycle::Creating => "CREATING",
            DataRepositoryLifecycle::Deleting => "DELETING",
            DataRepositoryLifecycle::Misconfigured => "MISCONFIGURED",
            DataRepositoryLifecycle::Updating => "UPDATING",
            DataRepositoryLifecycle::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AVAILABLE",
            "CREATING",
            "DELETING",
            "MISCONFIGURED",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for DataRepositoryLifecycle {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The configuration for this Microsoft Windows file system.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WindowsFileSystemConfiguration {
    /// <p>The ID for an existing Amazon Web Services Managed Microsoft Active Directory instance that the file system is joined to.</p>
    pub active_directory_id: std::option::Option<std::string::String>,
    /// <p>The configuration of the self-managed Microsoft Active Directory (AD) directory to
    /// which the Windows File Server or ONTAP storage virtual machine (SVM) instance is joined.</p>
    pub self_managed_active_directory_configuration:
        std::option::Option<crate::model::SelfManagedActiveDirectoryAttributes>,
    /// <p>Specifies the file system deployment type, valid values are the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>MULTI_AZ_1</code> - Specifies a high availability file system that is configured for Multi-AZ
    /// redundancy to tolerate temporary Availability Zone (AZ) unavailability, and supports SSD and HDD storage.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SINGLE_AZ_1</code> - (Default) Specifies a file system that is configured for single AZ redundancy,
    /// only supports SSD storage.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SINGLE_AZ_2</code> - Latest generation Single AZ file system.
    /// Specifies a file system that is configured for single AZ redundancy and supports SSD and HDD storage.</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see
    /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html">Single-AZ and Multi-AZ File Systems</a>.</p>
    pub deployment_type: std::option::Option<crate::model::WindowsDeploymentType>,
    /// <p>For <code>MULTI_AZ_1</code> deployment types, use this endpoint when performing administrative tasks on the file system using
    /// Amazon FSx Remote PowerShell.</p>
    /// <p>For <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> deployment types, this is the DNS name of the file system.</p>
    /// <p>This endpoint is temporarily unavailable when the file system is undergoing maintenance.</p>
    pub remote_administration_endpoint: std::option::Option<std::string::String>,
    /// <p>For <code>MULTI_AZ_1</code> deployment types, it specifies the ID of the subnet where the preferred file server is located.
    /// Must be one of the two subnet IDs specified in <code>SubnetIds</code> property.
    /// Amazon FSx serves traffic from this subnet except in the event of a failover to the secondary file server.</p>
    /// <p>For <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> deployment types, this value is the same as that for <code>SubnetIDs</code>.
    /// For more information, see
    /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html#single-multi-az-resources">Availability and durability: Single-AZ and Multi-AZ file systems</a>.</p>
    pub preferred_subnet_id: std::option::Option<std::string::String>,
    /// <p>For <code>MULTI_AZ_1</code> deployment types, the IP address of the primary, or preferred, file server.</p>
    /// <p>Use this IP address when mounting the file system on Linux SMB clients or Windows SMB clients that
    /// are not joined to a Microsoft Active Directory.
    /// Applicable for all Windows file system deployment types.
    /// This IP address is temporarily unavailable
    /// when the file system is undergoing maintenance. For Linux and Windows
    /// SMB clients that are joined to an Active Directory, use the file system's DNSName instead. For more information
    /// on mapping and mounting file shares, see
    /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/accessing-file-shares.html">Accessing File Shares</a>.</p>
    pub preferred_file_server_ip: std::option::Option<std::string::String>,
    /// <p>The throughput of the Amazon FSx file system, measured in megabytes per
    /// second.</p>
    pub throughput_capacity: std::option::Option<i32>,
    /// <p>The list of maintenance operations in progress for this file system.</p>
    pub maintenance_operations_in_progress:
        std::option::Option<std::vec::Vec<crate::model::FileSystemMaintenanceOperation>>,
    /// <p>The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC
    /// time zone. d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.</p>
    pub weekly_maintenance_start_time: std::option::Option<std::string::String>,
    /// <p>The preferred time to take daily automatic backups, in the UTC time zone.</p>
    pub daily_automatic_backup_start_time: std::option::Option<std::string::String>,
    /// <p>The number of days to retain automatic backups. Setting this to 0 disables automatic
    /// backups. You can retain automatic backups for a maximum of 90 days.</p>
    pub automatic_backup_retention_days: std::option::Option<i32>,
    /// <p>A boolean flag indicating whether tags on the file system should be copied to backups.
    /// This value defaults to false. If it's set to true, all tags on the file system are
    /// copied to all automatic backups and any user-initiated backups where the user
    /// doesn't specify any tags. If this value is true, and you specify one or more tags,
    /// only the specified tags are copied to backups. If you specify one or more tags when
    /// creating a user-initiated backup, no tags are copied from the file system,
    /// regardless of this value.</p>
    pub copy_tags_to_backups: std::option::Option<bool>,
    /// <p>An array of one or more DNS aliases that are currently associated with the Amazon FSx file system.
    /// Aliases allow you to use existing DNS names to access the data in your Amazon FSx file system.
    /// You can associate up to 50 aliases with a file system at any time.
    /// You can associate additional DNS aliases after you create the file system using the AssociateFileSystemAliases operation.
    /// You can remove DNS aliases from the file system after it is created using the DisassociateFileSystemAliases operation.
    /// You only need to specify the alias name in the request payload. For more information, see
    /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html">DNS aliases</a>.</p>
    pub aliases: std::option::Option<std::vec::Vec<crate::model::Alias>>,
    /// <p>The configuration that Amazon FSx for Windows File Server uses to audit and log
    /// user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server
    /// file system.</p>
    pub audit_log_configuration: std::option::Option<crate::model::WindowsAuditLogConfiguration>,
}
impl WindowsFileSystemConfiguration {
    /// <p>The ID for an existing Amazon Web Services Managed Microsoft Active Directory instance that the file system is joined to.</p>
    pub fn active_directory_id(&self) -> std::option::Option<&str> {
        self.active_directory_id.as_deref()
    }
    /// <p>The configuration of the self-managed Microsoft Active Directory (AD) directory to
    /// which the Windows File Server or ONTAP storage virtual machine (SVM) instance is joined.</p>
    pub fn self_managed_active_directory_configuration(
        &self,
    ) -> std::option::Option<&crate::model::SelfManagedActiveDirectoryAttributes> {
        self.self_managed_active_directory_configuration.as_ref()
    }
    /// <p>Specifies the file system deployment type, valid values are the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>MULTI_AZ_1</code> - Specifies a high availability file system that is configured for Multi-AZ
    /// redundancy to tolerate temporary Availability Zone (AZ) unavailability, and supports SSD and HDD storage.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SINGLE_AZ_1</code> - (Default) Specifies a file system that is configured for single AZ redundancy,
    /// only supports SSD storage.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SINGLE_AZ_2</code> - Latest generation Single AZ file system.
    /// Specifies a file system that is configured for single AZ redundancy and supports SSD and HDD storage.</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see
    /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html">Single-AZ and Multi-AZ File Systems</a>.</p>
    pub fn deployment_type(&self) -> std::option::Option<&crate::model::WindowsDeploymentType> {
        self.deployment_type.as_ref()
    }
    /// <p>For <code>MULTI_AZ_1</code> deployment types, use this endpoint when performing administrative tasks on the file system using
    /// Amazon FSx Remote PowerShell.</p>
    /// <p>For <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> deployment types, this is the DNS name of the file system.</p>
    /// <p>This endpoint is temporarily unavailable when the file system is undergoing maintenance.</p>
    pub fn remote_administration_endpoint(&self) -> std::option::Option<&str> {
        self.remote_administration_endpoint.as_deref()
    }
    /// <p>For <code>MULTI_AZ_1</code> deployment types, it specifies the ID of the subnet where the preferred file server is located.
    /// Must be one of the two subnet IDs specified in <code>SubnetIds</code> property.
    /// Amazon FSx serves traffic from this subnet except in the event of a failover to the secondary file server.</p>
    /// <p>For <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> deployment types, this value is the same as that for <code>SubnetIDs</code>.
    /// For more information, see
    /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html#single-multi-az-resources">Availability and durability: Single-AZ and Multi-AZ file systems</a>.</p>
    pub fn preferred_subnet_id(&self) -> std::option::Option<&str> {
        self.preferred_subnet_id.as_deref()
    }
    /// <p>For <code>MULTI_AZ_1</code> deployment types, the IP address of the primary, or preferred, file server.</p>
    /// <p>Use this IP address when mounting the file system on Linux SMB clients or Windows SMB clients that
    /// are not joined to a Microsoft Active Directory.
    /// Applicable for all Windows file system deployment types.
    /// This IP address is temporarily unavailable
    /// when the file system is undergoing maintenance. For Linux and Windows
    /// SMB clients that are joined to an Active Directory, use the file system's DNSName instead. For more information
    /// on mapping and mounting file shares, see
    /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/accessing-file-shares.html">Accessing File Shares</a>.</p>
    pub fn preferred_file_server_ip(&self) -> std::option::Option<&str> {
        self.preferred_file_server_ip.as_deref()
    }
    /// <p>The throughput of the Amazon FSx file system, measured in megabytes per
    /// second.</p>
    pub fn throughput_capacity(&self) -> std::option::Option<i32> {
        self.throughput_capacity
    }
    /// <p>The list of maintenance operations in progress for this file system.</p>
    pub fn maintenance_operations_in_progress(
        &self,
    ) -> std::option::Option<&[crate::model::FileSystemMaintenanceOperation]> {
        self.maintenance_operations_in_progress.as_deref()
    }
    /// <p>The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC
    /// time zone. d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.</p>
    pub fn weekly_maintenance_start_time(&self) -> std::option::Option<&str> {
        self.weekly_maintenance_start_time.as_deref()
    }
    /// <p>The preferred time to take daily automatic backups, in the UTC time zone.</p>
    pub fn daily_automatic_backup_start_time(&self) -> std::option::Option<&str> {
        self.daily_automatic_backup_start_time.as_deref()
    }
    /// <p>The number of days to retain automatic backups. Setting this to 0 disables automatic
    /// backups. You can retain automatic backups for a maximum of 90 days.</p>
    pub fn automatic_backup_retention_days(&self) -> std::option::Option<i32> {
        self.automatic_backup_retention_days
    }
    /// <p>A boolean flag indicating whether tags on the file system should be copied to backups.
    /// This value defaults to false. If it's set to true, all tags on the file system are
    /// copied to all automatic backups and any user-initiated backups where the user
    /// doesn't specify any tags. If this value is true, and you specify one or more tags,
    /// only the specified tags are copied to backups. If you specify one or more tags when
    /// creating a user-initiated backup, no tags are copied from the file system,
    /// regardless of this value.</p>
    pub fn copy_tags_to_backups(&self) -> std::option::Option<bool> {
        self.copy_tags_to_backups
    }
    /// <p>An array of one or more DNS aliases that are currently associated with the Amazon FSx file system.
    /// Aliases allow you to use existing DNS names to access the data in your Amazon FSx file system.
    /// You can associate up to 50 aliases with a file system at any time.
    /// You can associate additional DNS aliases after you create the file system using the AssociateFileSystemAliases operation.
    /// You can remove DNS aliases from the file system after it is created using the DisassociateFileSystemAliases operation.
    /// You only need to specify the alias name in the request payload. For more information, see
    /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html">DNS aliases</a>.</p>
    pub fn aliases(&self) -> std::option::Option<&[crate::model::Alias]> {
        self.aliases.as_deref()
    }
    /// <p>The configuration that Amazon FSx for Windows File Server uses to audit and log
    /// user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server
    /// file system.</p>
    pub fn audit_log_configuration(
        &self,
    ) -> std::option::Option<&crate::model::WindowsAuditLogConfiguration> {
        self.audit_log_configuration.as_ref()
    }
}
impl std::fmt::Debug for WindowsFileSystemConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WindowsFileSystemConfiguration");
        formatter.field("active_directory_id", &self.active_directory_id);
        formatter.field(
            "self_managed_active_directory_configuration",
            &self.self_managed_active_directory_configuration,
        );
        formatter.field("deployment_type", &self.deployment_type);
        formatter.field(
            "remote_administration_endpoint",
            &self.remote_administration_endpoint,
        );
        formatter.field("preferred_subnet_id", &self.preferred_subnet_id);
        formatter.field("preferred_file_server_ip", &self.preferred_file_server_ip);
        formatter.field("throughput_capacity", &self.throughput_capacity);
        formatter.field(
            "maintenance_operations_in_progress",
            &self.maintenance_operations_in_progress,
        );
        formatter.field(
            "weekly_maintenance_start_time",
            &self.weekly_maintenance_start_time,
        );
        formatter.field(
            "daily_automatic_backup_start_time",
            &self.daily_automatic_backup_start_time,
        );
        formatter.field(
            "automatic_backup_retention_days",
            &self.automatic_backup_retention_days,
        );
        formatter.field("copy_tags_to_backups", &self.copy_tags_to_backups);
        formatter.field("aliases", &self.aliases);
        formatter.field("audit_log_configuration", &self.audit_log_configuration);
        formatter.finish()
    }
}
/// See [`WindowsFileSystemConfiguration`](crate::model::WindowsFileSystemConfiguration)
pub mod windows_file_system_configuration {
    /// A builder for [`WindowsFileSystemConfiguration`](crate::model::WindowsFileSystemConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) active_directory_id: std::option::Option<std::string::String>,
        pub(crate) self_managed_active_directory_configuration:
            std::option::Option<crate::model::SelfManagedActiveDirectoryAttributes>,
        pub(crate) deployment_type: std::option::Option<crate::model::WindowsDeploymentType>,
        pub(crate) remote_administration_endpoint: std::option::Option<std::string::String>,
        pub(crate) preferred_subnet_id: std::option::Option<std::string::String>,
        pub(crate) preferred_file_server_ip: std::option::Option<std::string::String>,
        pub(crate) throughput_capacity: std::option::Option<i32>,
        pub(crate) maintenance_operations_in_progress:
            std::option::Option<std::vec::Vec<crate::model::FileSystemMaintenanceOperation>>,
        pub(crate) weekly_maintenance_start_time: std::option::Option<std::string::String>,
        pub(crate) daily_automatic_backup_start_time: std::option::Option<std::string::String>,
        pub(crate) automatic_backup_retention_days: std::option::Option<i32>,
        pub(crate) copy_tags_to_backups: std::option::Option<bool>,
        pub(crate) aliases: std::option::Option<std::vec::Vec<crate::model::Alias>>,
        pub(crate) audit_log_configuration:
            std::option::Option<crate::model::WindowsAuditLogConfiguration>,
    }
    impl Builder {
        /// <p>The ID for an existing Amazon Web Services Managed Microsoft Active Directory instance that the file system is joined to.</p>
        pub fn active_directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.active_directory_id = Some(input.into());
            self
        }
        /// <p>The ID for an existing Amazon Web Services Managed Microsoft Active Directory instance that the file system is joined to.</p>
        pub fn set_active_directory_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.active_directory_id = input;
            self
        }
        /// <p>The configuration of the self-managed Microsoft Active Directory (AD) directory to
        /// which the Windows File Server or ONTAP storage virtual machine (SVM) instance is joined.</p>
        pub fn self_managed_active_directory_configuration(
            mut self,
            input: crate::model::SelfManagedActiveDirectoryAttributes,
        ) -> Self {
            self.self_managed_active_directory_configuration = Some(input);
            self
        }
        /// <p>The configuration of the self-managed Microsoft Active Directory (AD) directory to
        /// which the Windows File Server or ONTAP storage virtual machine (SVM) instance is joined.</p>
        pub fn set_self_managed_active_directory_configuration(
            mut self,
            input: std::option::Option<crate::model::SelfManagedActiveDirectoryAttributes>,
        ) -> Self {
            self.self_managed_active_directory_configuration = input;
            self
        }
        /// <p>Specifies the file system deployment type, valid values are the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>MULTI_AZ_1</code> - Specifies a high availability file system that is configured for Multi-AZ
        /// redundancy to tolerate temporary Availability Zone (AZ) unavailability, and supports SSD and HDD storage.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SINGLE_AZ_1</code> - (Default) Specifies a file system that is configured for single AZ redundancy,
        /// only supports SSD storage.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SINGLE_AZ_2</code> - Latest generation Single AZ file system.
        /// Specifies a file system that is configured for single AZ redundancy and supports SSD and HDD storage.</p>
        /// </li>
        /// </ul>
        /// <p>For more information, see
        /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html">Single-AZ and Multi-AZ File Systems</a>.</p>
        pub fn deployment_type(mut self, input: crate::model::WindowsDeploymentType) -> Self {
            self.deployment_type = Some(input);
            self
        }
        /// <p>Specifies the file system deployment type, valid values are the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>MULTI_AZ_1</code> - Specifies a high availability file system that is configured for Multi-AZ
        /// redundancy to tolerate temporary Availability Zone (AZ) unavailability, and supports SSD and HDD storage.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SINGLE_AZ_1</code> - (Default) Specifies a file system that is configured for single AZ redundancy,
        /// only supports SSD storage.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SINGLE_AZ_2</code> - Latest generation Single AZ file system.
        /// Specifies a file system that is configured for single AZ redundancy and supports SSD and HDD storage.</p>
        /// </li>
        /// </ul>
        /// <p>For more information, see
        /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html">Single-AZ and Multi-AZ File Systems</a>.</p>
        pub fn set_deployment_type(
            mut self,
            input: std::option::Option<crate::model::WindowsDeploymentType>,
        ) -> Self {
            self.deployment_type = input;
            self
        }
        /// <p>For <code>MULTI_AZ_1</code> deployment types, use this endpoint when performing administrative tasks on the file system using
        /// Amazon FSx Remote PowerShell.</p>
        /// <p>For <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> deployment types, this is the DNS name of the file system.</p>
        /// <p>This endpoint is temporarily unavailable when the file system is undergoing maintenance.</p>
        pub fn remote_administration_endpoint(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.remote_administration_endpoint = Some(input.into());
            self
        }
        /// <p>For <code>MULTI_AZ_1</code> deployment types, use this endpoint when performing administrative tasks on the file system using
        /// Amazon FSx Remote PowerShell.</p>
        /// <p>For <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> deployment types, this is the DNS name of the file system.</p>
        /// <p>This endpoint is temporarily unavailable when the file system is undergoing maintenance.</p>
        pub fn set_remote_administration_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.remote_administration_endpoint = input;
            self
        }
        /// <p>For <code>MULTI_AZ_1</code> deployment types, it specifies the ID of the subnet where the preferred file server is located.
        /// Must be one of the two subnet IDs specified in <code>SubnetIds</code> property.
        /// Amazon FSx serves traffic from this subnet except in the event of a failover to the secondary file server.</p>
        /// <p>For <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> deployment types, this value is the same as that for <code>SubnetIDs</code>.
        /// For more information, see
        /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html#single-multi-az-resources">Availability and durability: Single-AZ and Multi-AZ file systems</a>.</p>
        pub fn preferred_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.preferred_subnet_id = Some(input.into());
            self
        }
        /// <p>For <code>MULTI_AZ_1</code> deployment types, it specifies the ID of the subnet where the preferred file server is located.
        /// Must be one of the two subnet IDs specified in <code>SubnetIds</code> property.
        /// Amazon FSx serves traffic from this subnet except in the event of a failover to the secondary file server.</p>
        /// <p>For <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> deployment types, this value is the same as that for <code>SubnetIDs</code>.
        /// For more information, see
        /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html#single-multi-az-resources">Availability and durability: Single-AZ and Multi-AZ file systems</a>.</p>
        pub fn set_preferred_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_subnet_id = input;
            self
        }
        /// <p>For <code>MULTI_AZ_1</code> deployment types, the IP address of the primary, or preferred, file server.</p>
        /// <p>Use this IP address when mounting the file system on Linux SMB clients or Windows SMB clients that
        /// are not joined to a Microsoft Active Directory.
        /// Applicable for all Windows file system deployment types.
        /// This IP address is temporarily unavailable
        /// when the file system is undergoing maintenance. For Linux and Windows
        /// SMB clients that are joined to an Active Directory, use the file system's DNSName instead. For more information
        /// on mapping and mounting file shares, see
        /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/accessing-file-shares.html">Accessing File Shares</a>.</p>
        pub fn preferred_file_server_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.preferred_file_server_ip = Some(input.into());
            self
        }
        /// <p>For <code>MULTI_AZ_1</code> deployment types, the IP address of the primary, or preferred, file server.</p>
        /// <p>Use this IP address when mounting the file system on Linux SMB clients or Windows SMB clients that
        /// are not joined to a Microsoft Active Directory.
        /// Applicable for all Windows file system deployment types.
        /// This IP address is temporarily unavailable
        /// when the file system is undergoing maintenance. For Linux and Windows
        /// SMB clients that are joined to an Active Directory, use the file system's DNSName instead. For more information
        /// on mapping and mounting file shares, see
        /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/accessing-file-shares.html">Accessing File Shares</a>.</p>
        pub fn set_preferred_file_server_ip(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_file_server_ip = input;
            self
        }
        /// <p>The throughput of the Amazon FSx file system, measured in megabytes per
        /// second.</p>
        pub fn throughput_capacity(mut self, input: i32) -> Self {
            self.throughput_capacity = Some(input);
            self
        }
        /// <p>The throughput of the Amazon FSx file system, measured in megabytes per
        /// second.</p>
        pub fn set_throughput_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.throughput_capacity = input;
            self
        }
        /// Appends an item to `maintenance_operations_in_progress`.
        ///
        /// To override the contents of this collection use [`set_maintenance_operations_in_progress`](Self::set_maintenance_operations_in_progress).
        ///
        /// <p>The list of maintenance operations in progress for this file system.</p>
        pub fn maintenance_operations_in_progress(
            mut self,
            input: impl Into<crate::model::FileSystemMaintenanceOperation>,
        ) -> Self {
            let mut v = self.maintenance_operations_in_progress.unwrap_or_default();
            v.push(input.into());
            self.maintenance_operations_in_progress = Some(v);
            self
        }
        /// <p>The list of maintenance operations in progress for this file system.</p>
        pub fn set_maintenance_operations_in_progress(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FileSystemMaintenanceOperation>>,
        ) -> Self {
            self.maintenance_operations_in_progress = input;
            self
        }
        /// <p>The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC
        /// time zone. d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.</p>
        pub fn weekly_maintenance_start_time(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.weekly_maintenance_start_time = Some(input.into());
            self
        }
        /// <p>The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC
        /// time zone. d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.</p>
        pub fn set_weekly_maintenance_start_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.weekly_maintenance_start_time = input;
            self
        }
        /// <p>The preferred time to take daily automatic backups, in the UTC time zone.</p>
        pub fn daily_automatic_backup_start_time(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.daily_automatic_backup_start_time = Some(input.into());
            self
        }
        /// <p>The preferred time to take daily automatic backups, in the UTC time zone.</p>
        pub fn set_daily_automatic_backup_start_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.daily_automatic_backup_start_time = input;
            self
        }
        /// <p>The number of days to retain automatic backups. Setting this to 0 disables automatic
        /// backups. You can retain automatic backups for a maximum of 90 days.</p>
        pub fn automatic_backup_retention_days(mut self, input: i32) -> Self {
            self.automatic_backup_retention_days = Some(input);
            self
        }
        /// <p>The number of days to retain automatic backups. Setting this to 0 disables automatic
        /// backups. You can retain automatic backups for a maximum of 90 days.</p>
        pub fn set_automatic_backup_retention_days(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.automatic_backup_retention_days = input;
            self
        }
        /// <p>A boolean flag indicating whether tags on the file system should be copied to backups.
        /// This value defaults to false. If it's set to true, all tags on the file system are
        /// copied to all automatic backups and any user-initiated backups where the user
        /// doesn't specify any tags. If this value is true, and you specify one or more tags,
        /// only the specified tags are copied to backups. If you specify one or more tags when
        /// creating a user-initiated backup, no tags are copied from the file system,
        /// regardless of this value.</p>
        pub fn copy_tags_to_backups(mut self, input: bool) -> Self {
            self.copy_tags_to_backups = Some(input);
            self
        }
        /// <p>A boolean flag indicating whether tags on the file system should be copied to backups.
        /// This value defaults to false. If it's set to true, all tags on the file system are
        /// copied to all automatic backups and any user-initiated backups where the user
        /// doesn't specify any tags. If this value is true, and you specify one or more tags,
        /// only the specified tags are copied to backups. If you specify one or more tags when
        /// creating a user-initiated backup, no tags are copied from the file system,
        /// regardless of this value.</p>
        pub fn set_copy_tags_to_backups(mut self, input: std::option::Option<bool>) -> Self {
            self.copy_tags_to_backups = input;
            self
        }
        /// Appends an item to `aliases`.
        ///
        /// To override the contents of this collection use [`set_aliases`](Self::set_aliases).
        ///
        /// <p>An array of one or more DNS aliases that are currently associated with the Amazon FSx file system.
        /// Aliases allow you to use existing DNS names to access the data in your Amazon FSx file system.
        /// You can associate up to 50 aliases with a file system at any time.
        /// You can associate additional DNS aliases after you create the file system using the AssociateFileSystemAliases operation.
        /// You can remove DNS aliases from the file system after it is created using the DisassociateFileSystemAliases operation.
        /// You only need to specify the alias name in the request payload. For more information, see
        /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html">DNS aliases</a>.</p>
        pub fn aliases(mut self, input: impl Into<crate::model::Alias>) -> Self {
            let mut v = self.aliases.unwrap_or_default();
            v.push(input.into());
            self.aliases = Some(v);
            self
        }
        /// <p>An array of one or more DNS aliases that are currently associated with the Amazon FSx file system.
        /// Aliases allow you to use existing DNS names to access the data in your Amazon FSx file system.
        /// You can associate up to 50 aliases with a file system at any time.
        /// You can associate additional DNS aliases after you create the file system using the AssociateFileSystemAliases operation.
        /// You can remove DNS aliases from the file system after it is created using the DisassociateFileSystemAliases operation.
        /// You only need to specify the alias name in the request payload. For more information, see
        /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html">DNS aliases</a>.</p>
        pub fn set_aliases(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Alias>>,
        ) -> Self {
            self.aliases = input;
            self
        }
        /// <p>The configuration that Amazon FSx for Windows File Server uses to audit and log
        /// user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server
        /// file system.</p>
        pub fn audit_log_configuration(
            mut self,
            input: crate::model::WindowsAuditLogConfiguration,
        ) -> Self {
            self.audit_log_configuration = Some(input);
            self
        }
        /// <p>The configuration that Amazon FSx for Windows File Server uses to audit and log
        /// user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server
        /// file system.</p>
        pub fn set_audit_log_configuration(
            mut self,
            input: std::option::Option<crate::model::WindowsAuditLogConfiguration>,
        ) -> Self {
            self.audit_log_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`WindowsFileSystemConfiguration`](crate::model::WindowsFileSystemConfiguration)
        pub fn build(self) -> crate::model::WindowsFileSystemConfiguration {
            crate::model::WindowsFileSystemConfiguration {
                active_directory_id: self.active_directory_id,
                self_managed_active_directory_configuration: self
                    .self_managed_active_directory_configuration,
                deployment_type: self.deployment_type,
                remote_administration_endpoint: self.remote_administration_endpoint,
                preferred_subnet_id: self.preferred_subnet_id,
                preferred_file_server_ip: self.preferred_file_server_ip,
                throughput_capacity: self.throughput_capacity,
                maintenance_operations_in_progress: self.maintenance_operations_in_progress,
                weekly_maintenance_start_time: self.weekly_maintenance_start_time,
                daily_automatic_backup_start_time: self.daily_automatic_backup_start_time,
                automatic_backup_retention_days: self.automatic_backup_retention_days,
                copy_tags_to_backups: self.copy_tags_to_backups,
                aliases: self.aliases,
                audit_log_configuration: self.audit_log_configuration,
            }
        }
    }
}
impl WindowsFileSystemConfiguration {
    /// Creates a new builder-style object to manufacture [`WindowsFileSystemConfiguration`](crate::model::WindowsFileSystemConfiguration)
    pub fn builder() -> crate::model::windows_file_system_configuration::Builder {
        crate::model::windows_file_system_configuration::Builder::default()
    }
}

/// <p>The configuration that Amazon FSx for Windows File Server uses to audit and log
/// user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server
/// file system. For more information,
/// see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/file-access-auditing.html">
/// File access auditing</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WindowsAuditLogConfiguration {
    /// <p>Sets which attempt type is logged by Amazon FSx for file and folder accesses.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SUCCESS_ONLY</code> - only successful attempts to access files
    /// or folders are logged.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILURE_ONLY</code> - only failed attempts to access files
    /// or folders are logged.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SUCCESS_AND_FAILURE</code> - both successful attempts and
    /// failed attempts to access files or folders are logged.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DISABLED</code> - access auditing of files and folders is turned off.</p>
    /// </li>
    /// </ul>
    pub file_access_audit_log_level: std::option::Option<crate::model::WindowsAccessAuditLogLevel>,
    /// <p>Sets which attempt type is logged by Amazon FSx for file share accesses.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SUCCESS_ONLY</code> - only successful attempts to access file
    /// shares are logged.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILURE_ONLY</code> - only failed attempts to access file
    /// shares are logged.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SUCCESS_AND_FAILURE</code> - both successful attempts and
    /// failed attempts to access file shares are logged.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DISABLED</code> - access auditing of file shares is turned off.</p>
    /// </li>
    /// </ul>
    pub file_share_access_audit_log_level:
        std::option::Option<crate::model::WindowsAccessAuditLogLevel>,
    /// <p>The Amazon Resource Name (ARN) for the destination of the audit logs.
    /// The destination can be any Amazon CloudWatch Logs log group ARN or
    /// Amazon Kinesis Data Firehose delivery stream ARN.</p>
    /// <p>The name of the Amazon CloudWatch Logs log group must begin with
    /// the <code>/aws/fsx</code> prefix. The name of the Amazon Kinesis Data
    /// Firehouse delivery stream must begin with the <code>aws-fsx</code> prefix.</p>
    /// <p>The destination ARN (either CloudWatch Logs log group or Kinesis
    /// Data Firehose delivery stream) must be in the same Amazon Web Services partition,
    /// Amazon Web Services Region, and Amazon Web Services account as your Amazon FSx file system.</p>
    pub audit_log_destination: std::option::Option<std::string::String>,
}
impl WindowsAuditLogConfiguration {
    /// <p>Sets which attempt type is logged by Amazon FSx for file and folder accesses.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SUCCESS_ONLY</code> - only successful attempts to access files
    /// or folders are logged.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILURE_ONLY</code> - only failed attempts to access files
    /// or folders are logged.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SUCCESS_AND_FAILURE</code> - both successful attempts and
    /// failed attempts to access files or folders are logged.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DISABLED</code> - access auditing of files and folders is turned off.</p>
    /// </li>
    /// </ul>
    pub fn file_access_audit_log_level(
        &self,
    ) -> std::option::Option<&crate::model::WindowsAccessAuditLogLevel> {
        self.file_access_audit_log_level.as_ref()
    }
    /// <p>Sets which attempt type is logged by Amazon FSx for file share accesses.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SUCCESS_ONLY</code> - only successful attempts to access file
    /// shares are logged.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILURE_ONLY</code> - only failed attempts to access file
    /// shares are logged.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SUCCESS_AND_FAILURE</code> - both successful attempts and
    /// failed attempts to access file shares are logged.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DISABLED</code> - access auditing of file shares is turned off.</p>
    /// </li>
    /// </ul>
    pub fn file_share_access_audit_log_level(
        &self,
    ) -> std::option::Option<&crate::model::WindowsAccessAuditLogLevel> {
        self.file_share_access_audit_log_level.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) for the destination of the audit logs.
    /// The destination can be any Amazon CloudWatch Logs log group ARN or
    /// Amazon Kinesis Data Firehose delivery stream ARN.</p>
    /// <p>The name of the Amazon CloudWatch Logs log group must begin with
    /// the <code>/aws/fsx</code> prefix. The name of the Amazon Kinesis Data
    /// Firehouse delivery stream must begin with the <code>aws-fsx</code> prefix.</p>
    /// <p>The destination ARN (either CloudWatch Logs log group or Kinesis
    /// Data Firehose delivery stream) must be in the same Amazon Web Services partition,
    /// Amazon Web Services Region, and Amazon Web Services account as your Amazon FSx file system.</p>
    pub fn audit_log_destination(&self) -> std::option::Option<&str> {
        self.audit_log_destination.as_deref()
    }
}
impl std::fmt::Debug for WindowsAuditLogConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WindowsAuditLogConfiguration");
        formatter.field(
            "file_access_audit_log_level",
            &self.file_access_audit_log_level,
        );
        formatter.field(
            "file_share_access_audit_log_level",
            &self.file_share_access_audit_log_level,
        );
        formatter.field("audit_log_destination", &self.audit_log_destination);
        formatter.finish()
    }
}
/// See [`WindowsAuditLogConfiguration`](crate::model::WindowsAuditLogConfiguration)
pub mod windows_audit_log_configuration {
    /// A builder for [`WindowsAuditLogConfiguration`](crate::model::WindowsAuditLogConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_access_audit_log_level:
            std::option::Option<crate::model::WindowsAccessAuditLogLevel>,
        pub(crate) file_share_access_audit_log_level:
            std::option::Option<crate::model::WindowsAccessAuditLogLevel>,
        pub(crate) audit_log_destination: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Sets which attempt type is logged by Amazon FSx for file and folder accesses.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SUCCESS_ONLY</code> - only successful attempts to access files
        /// or folders are logged.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILURE_ONLY</code> - only failed attempts to access files
        /// or folders are logged.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SUCCESS_AND_FAILURE</code> - both successful attempts and
        /// failed attempts to access files or folders are logged.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DISABLED</code> - access auditing of files and folders is turned off.</p>
        /// </li>
        /// </ul>
        pub fn file_access_audit_log_level(
            mut self,
            input: crate::model::WindowsAccessAuditLogLevel,
        ) -> Self {
            self.file_access_audit_log_level = Some(input);
            self
        }
        /// <p>Sets which attempt type is logged by Amazon FSx for file and folder accesses.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SUCCESS_ONLY</code> - only successful attempts to access files
        /// or folders are logged.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILURE_ONLY</code> - only failed attempts to access files
        /// or folders are logged.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SUCCESS_AND_FAILURE</code> - both successful attempts and
        /// failed attempts to access files or folders are logged.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DISABLED</code> - access auditing of files and folders is turned off.</p>
        /// </li>
        /// </ul>
        pub fn set_file_access_audit_log_level(
            mut self,
            input: std::option::Option<crate::model::WindowsAccessAuditLogLevel>,
        ) -> Self {
            self.file_access_audit_log_level = input;
            self
        }
        /// <p>Sets which attempt type is logged by Amazon FSx for file share accesses.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SUCCESS_ONLY</code> - only successful attempts to access file
        /// shares are logged.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILURE_ONLY</code> - only failed attempts to access file
        /// shares are logged.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SUCCESS_AND_FAILURE</code> - both successful attempts and
        /// failed attempts to access file shares are logged.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DISABLED</code> - access auditing of file shares is turned off.</p>
        /// </li>
        /// </ul>
        pub fn file_share_access_audit_log_level(
            mut self,
            input: crate::model::WindowsAccessAuditLogLevel,
        ) -> Self {
            self.file_share_access_audit_log_level = Some(input);
            self
        }
        /// <p>Sets which attempt type is logged by Amazon FSx for file share accesses.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SUCCESS_ONLY</code> - only successful attempts to access file
        /// shares are logged.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILURE_ONLY</code> - only failed attempts to access file
        /// shares are logged.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SUCCESS_AND_FAILURE</code> - both successful attempts and
        /// failed attempts to access file shares are logged.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DISABLED</code> - access auditing of file shares is turned off.</p>
        /// </li>
        /// </ul>
        pub fn set_file_share_access_audit_log_level(
            mut self,
            input: std::option::Option<crate::model::WindowsAccessAuditLogLevel>,
        ) -> Self {
            self.file_share_access_audit_log_level = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the destination of the audit logs.
        /// The destination can be any Amazon CloudWatch Logs log group ARN or
        /// Amazon Kinesis Data Firehose delivery stream ARN.</p>
        /// <p>The name of the Amazon CloudWatch Logs log group must begin with
        /// the <code>/aws/fsx</code> prefix. The name of the Amazon Kinesis Data
        /// Firehouse delivery stream must begin with the <code>aws-fsx</code> prefix.</p>
        /// <p>The destination ARN (either CloudWatch Logs log group or Kinesis
        /// Data Firehose delivery stream) must be in the same Amazon Web Services partition,
        /// Amazon Web Services Region, and Amazon Web Services account as your Amazon FSx file system.</p>
        pub fn audit_log_destination(mut self, input: impl Into<std::string::String>) -> Self {
            self.audit_log_destination = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the destination of the audit logs.
        /// The destination can be any Amazon CloudWatch Logs log group ARN or
        /// Amazon Kinesis Data Firehose delivery stream ARN.</p>
        /// <p>The name of the Amazon CloudWatch Logs log group must begin with
        /// the <code>/aws/fsx</code> prefix. The name of the Amazon Kinesis Data
        /// Firehouse delivery stream must begin with the <code>aws-fsx</code> prefix.</p>
        /// <p>The destination ARN (either CloudWatch Logs log group or Kinesis
        /// Data Firehose delivery stream) must be in the same Amazon Web Services partition,
        /// Amazon Web Services Region, and Amazon Web Services account as your Amazon FSx file system.</p>
        pub fn set_audit_log_destination(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.audit_log_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`WindowsAuditLogConfiguration`](crate::model::WindowsAuditLogConfiguration)
        pub fn build(self) -> crate::model::WindowsAuditLogConfiguration {
            crate::model::WindowsAuditLogConfiguration {
                file_access_audit_log_level: self.file_access_audit_log_level,
                file_share_access_audit_log_level: self.file_share_access_audit_log_level,
                audit_log_destination: self.audit_log_destination,
            }
        }
    }
}
impl WindowsAuditLogConfiguration {
    /// Creates a new builder-style object to manufacture [`WindowsAuditLogConfiguration`](crate::model::WindowsAuditLogConfiguration)
    pub fn builder() -> crate::model::windows_audit_log_configuration::Builder {
        crate::model::windows_audit_log_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WindowsAccessAuditLogLevel {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    FailureOnly,
    #[allow(missing_docs)] // documentation missing in model
    SuccessAndFailure,
    #[allow(missing_docs)] // documentation missing in model
    SuccessOnly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WindowsAccessAuditLogLevel {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => WindowsAccessAuditLogLevel::Disabled,
            "FAILURE_ONLY" => WindowsAccessAuditLogLevel::FailureOnly,
            "SUCCESS_AND_FAILURE" => WindowsAccessAuditLogLevel::SuccessAndFailure,
            "SUCCESS_ONLY" => WindowsAccessAuditLogLevel::SuccessOnly,
            other => WindowsAccessAuditLogLevel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WindowsAccessAuditLogLevel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WindowsAccessAuditLogLevel::from(s))
    }
}
impl WindowsAccessAuditLogLevel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WindowsAccessAuditLogLevel::Disabled => "DISABLED",
            WindowsAccessAuditLogLevel::FailureOnly => "FAILURE_ONLY",
            WindowsAccessAuditLogLevel::SuccessAndFailure => "SUCCESS_AND_FAILURE",
            WindowsAccessAuditLogLevel::SuccessOnly => "SUCCESS_ONLY",
            WindowsAccessAuditLogLevel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DISABLED",
            "FAILURE_ONLY",
            "SUCCESS_AND_FAILURE",
            "SUCCESS_ONLY",
        ]
    }
}
impl AsRef<str> for WindowsAccessAuditLogLevel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A DNS alias that is associated with the file system. You can use a DNS alias to access a file system using
/// user-defined DNS names, in addition to the default DNS name
/// that Amazon FSx assigns to the file system. For more information, see
/// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html">DNS aliases</a>
/// in the <i>FSx for Windows File Server User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Alias {
    /// <p>The name of the DNS alias. The alias name has to meet the following requirements:</p>
    /// <ul>
    /// <li>
    /// <p>Formatted as a fully-qualified domain name (FQDN), <code>hostname.domain</code>, for example, <code>accounting.example.com</code>.</p>
    /// </li>
    /// <li>
    /// <p>Can contain alphanumeric characters, the underscore (_), and the hyphen (-).</p>
    /// </li>
    /// <li>
    /// <p>Cannot start or end with a hyphen.</p>
    /// </li>
    /// <li>
    /// <p>Can start with a numeric.</p>
    /// </li>
    /// </ul>
    /// <p>For DNS names, Amazon FSx stores alphabetic characters as lowercase letters (a-z), regardless of how you specify them:
    /// as uppercase letters, lowercase letters, or the corresponding letters in escape codes.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Describes the state of the DNS alias.</p>
    /// <ul>
    /// <li>
    /// <p>AVAILABLE - The DNS alias is associated with an Amazon FSx file system.</p>
    /// </li>
    /// <li>
    /// <p>CREATING - Amazon FSx is creating the DNS alias and associating it with the file system.</p>
    /// </li>
    /// <li>
    /// <p>CREATE_FAILED - Amazon FSx was unable to associate the DNS alias with the file system.</p>
    /// </li>
    /// <li>
    /// <p>DELETING - Amazon FSx is disassociating the DNS alias from the file system and deleting it.</p>
    /// </li>
    /// <li>
    /// <p>DELETE_FAILED - Amazon FSx was unable to disassociate the DNS alias from the file system.</p>
    /// </li>
    /// </ul>
    pub lifecycle: std::option::Option<crate::model::AliasLifecycle>,
}
impl Alias {
    /// <p>The name of the DNS alias. The alias name has to meet the following requirements:</p>
    /// <ul>
    /// <li>
    /// <p>Formatted as a fully-qualified domain name (FQDN), <code>hostname.domain</code>, for example, <code>accounting.example.com</code>.</p>
    /// </li>
    /// <li>
    /// <p>Can contain alphanumeric characters, the underscore (_), and the hyphen (-).</p>
    /// </li>
    /// <li>
    /// <p>Cannot start or end with a hyphen.</p>
    /// </li>
    /// <li>
    /// <p>Can start with a numeric.</p>
    /// </li>
    /// </ul>
    /// <p>For DNS names, Amazon FSx stores alphabetic characters as lowercase letters (a-z), regardless of how you specify them:
    /// as uppercase letters, lowercase letters, or the corresponding letters in escape codes.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Describes the state of the DNS alias.</p>
    /// <ul>
    /// <li>
    /// <p>AVAILABLE - The DNS alias is associated with an Amazon FSx file system.</p>
    /// </li>
    /// <li>
    /// <p>CREATING - Amazon FSx is creating the DNS alias and associating it with the file system.</p>
    /// </li>
    /// <li>
    /// <p>CREATE_FAILED - Amazon FSx was unable to associate the DNS alias with the file system.</p>
    /// </li>
    /// <li>
    /// <p>DELETING - Amazon FSx is disassociating the DNS alias from the file system and deleting it.</p>
    /// </li>
    /// <li>
    /// <p>DELETE_FAILED - Amazon FSx was unable to disassociate the DNS alias from the file system.</p>
    /// </li>
    /// </ul>
    pub fn lifecycle(&self) -> std::option::Option<&crate::model::AliasLifecycle> {
        self.lifecycle.as_ref()
    }
}
impl std::fmt::Debug for Alias {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Alias");
        formatter.field("name", &self.name);
        formatter.field("lifecycle", &self.lifecycle);
        formatter.finish()
    }
}
/// See [`Alias`](crate::model::Alias)
pub mod alias {
    /// A builder for [`Alias`](crate::model::Alias)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) lifecycle: std::option::Option<crate::model::AliasLifecycle>,
    }
    impl Builder {
        /// <p>The name of the DNS alias. The alias name has to meet the following requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Formatted as a fully-qualified domain name (FQDN), <code>hostname.domain</code>, for example, <code>accounting.example.com</code>.</p>
        /// </li>
        /// <li>
        /// <p>Can contain alphanumeric characters, the underscore (_), and the hyphen (-).</p>
        /// </li>
        /// <li>
        /// <p>Cannot start or end with a hyphen.</p>
        /// </li>
        /// <li>
        /// <p>Can start with a numeric.</p>
        /// </li>
        /// </ul>
        /// <p>For DNS names, Amazon FSx stores alphabetic characters as lowercase letters (a-z), regardless of how you specify them:
        /// as uppercase letters, lowercase letters, or the corresponding letters in escape codes.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the DNS alias. The alias name has to meet the following requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Formatted as a fully-qualified domain name (FQDN), <code>hostname.domain</code>, for example, <code>accounting.example.com</code>.</p>
        /// </li>
        /// <li>
        /// <p>Can contain alphanumeric characters, the underscore (_), and the hyphen (-).</p>
        /// </li>
        /// <li>
        /// <p>Cannot start or end with a hyphen.</p>
        /// </li>
        /// <li>
        /// <p>Can start with a numeric.</p>
        /// </li>
        /// </ul>
        /// <p>For DNS names, Amazon FSx stores alphabetic characters as lowercase letters (a-z), regardless of how you specify them:
        /// as uppercase letters, lowercase letters, or the corresponding letters in escape codes.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Describes the state of the DNS alias.</p>
        /// <ul>
        /// <li>
        /// <p>AVAILABLE - The DNS alias is associated with an Amazon FSx file system.</p>
        /// </li>
        /// <li>
        /// <p>CREATING - Amazon FSx is creating the DNS alias and associating it with the file system.</p>
        /// </li>
        /// <li>
        /// <p>CREATE_FAILED - Amazon FSx was unable to associate the DNS alias with the file system.</p>
        /// </li>
        /// <li>
        /// <p>DELETING - Amazon FSx is disassociating the DNS alias from the file system and deleting it.</p>
        /// </li>
        /// <li>
        /// <p>DELETE_FAILED - Amazon FSx was unable to disassociate the DNS alias from the file system.</p>
        /// </li>
        /// </ul>
        pub fn lifecycle(mut self, input: crate::model::AliasLifecycle) -> Self {
            self.lifecycle = Some(input);
            self
        }
        /// <p>Describes the state of the DNS alias.</p>
        /// <ul>
        /// <li>
        /// <p>AVAILABLE - The DNS alias is associated with an Amazon FSx file system.</p>
        /// </li>
        /// <li>
        /// <p>CREATING - Amazon FSx is creating the DNS alias and associating it with the file system.</p>
        /// </li>
        /// <li>
        /// <p>CREATE_FAILED - Amazon FSx was unable to associate the DNS alias with the file system.</p>
        /// </li>
        /// <li>
        /// <p>DELETING - Amazon FSx is disassociating the DNS alias from the file system and deleting it.</p>
        /// </li>
        /// <li>
        /// <p>DELETE_FAILED - Amazon FSx was unable to disassociate the DNS alias from the file system.</p>
        /// </li>
        /// </ul>
        pub fn set_lifecycle(
            mut self,
            input: std::option::Option<crate::model::AliasLifecycle>,
        ) -> Self {
            self.lifecycle = input;
            self
        }
        /// Consumes the builder and constructs a [`Alias`](crate::model::Alias)
        pub fn build(self) -> crate::model::Alias {
            crate::model::Alias {
                name: self.name,
                lifecycle: self.lifecycle,
            }
        }
    }
}
impl Alias {
    /// Creates a new builder-style object to manufacture [`Alias`](crate::model::Alias)
    pub fn builder() -> crate::model::alias::Builder {
        crate::model::alias::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AliasLifecycle {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AliasLifecycle {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => AliasLifecycle::Available,
            "CREATE_FAILED" => AliasLifecycle::CreateFailed,
            "CREATING" => AliasLifecycle::Creating,
            "DELETE_FAILED" => AliasLifecycle::DeleteFailed,
            "DELETING" => AliasLifecycle::Deleting,
            other => AliasLifecycle::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AliasLifecycle {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AliasLifecycle::from(s))
    }
}
impl AliasLifecycle {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AliasLifecycle::Available => "AVAILABLE",
            AliasLifecycle::CreateFailed => "CREATE_FAILED",
            AliasLifecycle::Creating => "CREATING",
            AliasLifecycle::DeleteFailed => "DELETE_FAILED",
            AliasLifecycle::Deleting => "DELETING",
            AliasLifecycle::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AVAILABLE",
            "CREATE_FAILED",
            "CREATING",
            "DELETE_FAILED",
            "DELETING",
        ]
    }
}
impl AsRef<str> for AliasLifecycle {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An enumeration specifying the currently ongoing maintenance operation.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FileSystemMaintenanceOperation {
    #[allow(missing_docs)] // documentation missing in model
    BackingUp,
    #[allow(missing_docs)] // documentation missing in model
    Patching,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FileSystemMaintenanceOperation {
    fn from(s: &str) -> Self {
        match s {
            "BACKING_UP" => FileSystemMaintenanceOperation::BackingUp,
            "PATCHING" => FileSystemMaintenanceOperation::Patching,
            other => FileSystemMaintenanceOperation::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FileSystemMaintenanceOperation {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FileSystemMaintenanceOperation::from(s))
    }
}
impl FileSystemMaintenanceOperation {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FileSystemMaintenanceOperation::BackingUp => "BACKING_UP",
            FileSystemMaintenanceOperation::Patching => "PATCHING",
            FileSystemMaintenanceOperation::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BACKING_UP", "PATCHING"]
    }
}
impl AsRef<str> for FileSystemMaintenanceOperation {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WindowsDeploymentType {
    #[allow(missing_docs)] // documentation missing in model
    MultiAz1,
    #[allow(missing_docs)] // documentation missing in model
    SingleAz1,
    #[allow(missing_docs)] // documentation missing in model
    SingleAz2,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WindowsDeploymentType {
    fn from(s: &str) -> Self {
        match s {
            "MULTI_AZ_1" => WindowsDeploymentType::MultiAz1,
            "SINGLE_AZ_1" => WindowsDeploymentType::SingleAz1,
            "SINGLE_AZ_2" => WindowsDeploymentType::SingleAz2,
            other => WindowsDeploymentType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WindowsDeploymentType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WindowsDeploymentType::from(s))
    }
}
impl WindowsDeploymentType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WindowsDeploymentType::MultiAz1 => "MULTI_AZ_1",
            WindowsDeploymentType::SingleAz1 => "SINGLE_AZ_1",
            WindowsDeploymentType::SingleAz2 => "SINGLE_AZ_2",
            WindowsDeploymentType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MULTI_AZ_1", "SINGLE_AZ_1", "SINGLE_AZ_2"]
    }
}
impl AsRef<str> for WindowsDeploymentType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The storage type for your Amazon FSx file system.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StorageType {
    #[allow(missing_docs)] // documentation missing in model
    Hdd,
    #[allow(missing_docs)] // documentation missing in model
    Ssd,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StorageType {
    fn from(s: &str) -> Self {
        match s {
            "HDD" => StorageType::Hdd,
            "SSD" => StorageType::Ssd,
            other => StorageType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StorageType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StorageType::from(s))
    }
}
impl StorageType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StorageType::Hdd => "HDD",
            StorageType::Ssd => "SSD",
            StorageType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HDD", "SSD"]
    }
}
impl AsRef<str> for StorageType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure providing details of any failures that occur when creating the file system
/// has failed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FileSystemFailureDetails {
    /// <p>A message describing any failures that occurred during file system creation.</p>
    pub message: std::option::Option<std::string::String>,
}
impl FileSystemFailureDetails {
    /// <p>A message describing any failures that occurred during file system creation.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for FileSystemFailureDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FileSystemFailureDetails");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`FileSystemFailureDetails`](crate::model::FileSystemFailureDetails)
pub mod file_system_failure_details {
    /// A builder for [`FileSystemFailureDetails`](crate::model::FileSystemFailureDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing any failures that occurred during file system creation.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing any failures that occurred during file system creation.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`FileSystemFailureDetails`](crate::model::FileSystemFailureDetails)
        pub fn build(self) -> crate::model::FileSystemFailureDetails {
            crate::model::FileSystemFailureDetails {
                message: self.message,
            }
        }
    }
}
impl FileSystemFailureDetails {
    /// Creates a new builder-style object to manufacture [`FileSystemFailureDetails`](crate::model::FileSystemFailureDetails)
    pub fn builder() -> crate::model::file_system_failure_details::Builder {
        crate::model::file_system_failure_details::Builder::default()
    }
}

/// <p>The lifecycle status of the file system.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FileSystemLifecycle {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Misconfigured,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FileSystemLifecycle {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => FileSystemLifecycle::Available,
            "CREATING" => FileSystemLifecycle::Creating,
            "DELETING" => FileSystemLifecycle::Deleting,
            "FAILED" => FileSystemLifecycle::Failed,
            "MISCONFIGURED" => FileSystemLifecycle::Misconfigured,
            "UPDATING" => FileSystemLifecycle::Updating,
            other => FileSystemLifecycle::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FileSystemLifecycle {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FileSystemLifecycle::from(s))
    }
}
impl FileSystemLifecycle {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FileSystemLifecycle::Available => "AVAILABLE",
            FileSystemLifecycle::Creating => "CREATING",
            FileSystemLifecycle::Deleting => "DELETING",
            FileSystemLifecycle::Failed => "FAILED",
            FileSystemLifecycle::Misconfigured => "MISCONFIGURED",
            FileSystemLifecycle::Updating => "UPDATING",
            FileSystemLifecycle::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AVAILABLE",
            "CREATING",
            "DELETING",
            "FAILED",
            "MISCONFIGURED",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for FileSystemLifecycle {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The type of file system.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FileSystemType {
    #[allow(missing_docs)] // documentation missing in model
    Lustre,
    #[allow(missing_docs)] // documentation missing in model
    Ontap,
    #[allow(missing_docs)] // documentation missing in model
    Windows,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FileSystemType {
    fn from(s: &str) -> Self {
        match s {
            "LUSTRE" => FileSystemType::Lustre,
            "ONTAP" => FileSystemType::Ontap,
            "WINDOWS" => FileSystemType::Windows,
            other => FileSystemType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FileSystemType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FileSystemType::from(s))
    }
}
impl FileSystemType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FileSystemType::Lustre => "LUSTRE",
            FileSystemType::Ontap => "ONTAP",
            FileSystemType::Windows => "WINDOWS",
            FileSystemType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LUSTRE", "ONTAP", "WINDOWS"]
    }
}
impl AsRef<str> for FileSystemType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The configuration updates for an Amazon FSx for NetApp ONTAP file system.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFileSystemOntapConfiguration {
    /// <p>The number of days to retain automatic backups. Setting this to 0 disables
    /// automatic backups. You can retain automatic backups for a maximum of 90 days. The default is 0.</p>
    pub automatic_backup_retention_days: std::option::Option<i32>,
    /// <p>A recurring daily time, in the format <code>HH:MM</code>. <code>HH</code> is the
    /// zero-padded hour of the day (0-23), and <code>MM</code> is the zero-padded minute of the
    /// hour. For example, <code>05:00</code> specifies 5 AM daily. </p>
    pub daily_automatic_backup_start_time: std::option::Option<std::string::String>,
    /// <p>The ONTAP administrative password for the <code>fsxadmin</code> user.</p>
    pub fsx_admin_password: std::option::Option<std::string::String>,
    /// <p>A recurring weekly time, in the format <code>D:HH:MM</code>. </p>
    /// <p>
    /// <code>D</code> is the day of the week, for which 1 represents Monday and 7
    /// represents Sunday. For further details, see <a href="https://en.wikipedia.org/wiki/ISO_week_date">the ISO-8601 spec as described on Wikipedia</a>.</p>
    /// <p>
    /// <code>HH</code> is the zero-padded hour of the day (0-23), and <code>MM</code> is
    /// the zero-padded minute of the hour. </p>
    /// <p>For example, <code>1:05:00</code> specifies maintenance at 5 AM Monday.</p>
    pub weekly_maintenance_start_time: std::option::Option<std::string::String>,
}
impl UpdateFileSystemOntapConfiguration {
    /// <p>The number of days to retain automatic backups. Setting this to 0 disables
    /// automatic backups. You can retain automatic backups for a maximum of 90 days. The default is 0.</p>
    pub fn automatic_backup_retention_days(&self) -> std::option::Option<i32> {
        self.automatic_backup_retention_days
    }
    /// <p>A recurring daily time, in the format <code>HH:MM</code>. <code>HH</code> is the
    /// zero-padded hour of the day (0-23), and <code>MM</code> is the zero-padded minute of the
    /// hour. For example, <code>05:00</code> specifies 5 AM daily. </p>
    pub fn daily_automatic_backup_start_time(&self) -> std::option::Option<&str> {
        self.daily_automatic_backup_start_time.as_deref()
    }
    /// <p>The ONTAP administrative password for the <code>fsxadmin</code> user.</p>
    pub fn fsx_admin_password(&self) -> std::option::Option<&str> {
        self.fsx_admin_password.as_deref()
    }
    /// <p>A recurring weekly time, in the format <code>D:HH:MM</code>. </p>
    /// <p>
    /// <code>D</code> is the day of the week, for which 1 represents Monday and 7
    /// represents Sunday. For further details, see <a href="https://en.wikipedia.org/wiki/ISO_week_date">the ISO-8601 spec as described on Wikipedia</a>.</p>
    /// <p>
    /// <code>HH</code> is the zero-padded hour of the day (0-23), and <code>MM</code> is
    /// the zero-padded minute of the hour. </p>
    /// <p>For example, <code>1:05:00</code> specifies maintenance at 5 AM Monday.</p>
    pub fn weekly_maintenance_start_time(&self) -> std::option::Option<&str> {
        self.weekly_maintenance_start_time.as_deref()
    }
}
impl std::fmt::Debug for UpdateFileSystemOntapConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFileSystemOntapConfiguration");
        formatter.field(
            "automatic_backup_retention_days",
            &self.automatic_backup_retention_days,
        );
        formatter.field(
            "daily_automatic_backup_start_time",
            &self.daily_automatic_backup_start_time,
        );
        formatter.field("fsx_admin_password", &"*** Sensitive Data Redacted ***");
        formatter.field(
            "weekly_maintenance_start_time",
            &self.weekly_maintenance_start_time,
        );
        formatter.finish()
    }
}
/// See [`UpdateFileSystemOntapConfiguration`](crate::model::UpdateFileSystemOntapConfiguration)
pub mod update_file_system_ontap_configuration {
    /// A builder for [`UpdateFileSystemOntapConfiguration`](crate::model::UpdateFileSystemOntapConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) automatic_backup_retention_days: std::option::Option<i32>,
        pub(crate) daily_automatic_backup_start_time: std::option::Option<std::string::String>,
        pub(crate) fsx_admin_password: std::option::Option<std::string::String>,
        pub(crate) weekly_maintenance_start_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The number of days to retain automatic backups. Setting this to 0 disables
        /// automatic backups. You can retain automatic backups for a maximum of 90 days. The default is 0.</p>
        pub fn automatic_backup_retention_days(mut self, input: i32) -> Self {
            self.automatic_backup_retention_days = Some(input);
            self
        }
        /// <p>The number of days to retain automatic backups. Setting this to 0 disables
        /// automatic backups. You can retain automatic backups for a maximum of 90 days. The default is 0.</p>
        pub fn set_automatic_backup_retention_days(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.automatic_backup_retention_days = input;
            self
        }
        /// <p>A recurring daily time, in the format <code>HH:MM</code>. <code>HH</code> is the
        /// zero-padded hour of the day (0-23), and <code>MM</code> is the zero-padded minute of the
        /// hour. For example, <code>05:00</code> specifies 5 AM daily. </p>
        pub fn daily_automatic_backup_start_time(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.daily_automatic_backup_start_time = Some(input.into());
            self
        }
        /// <p>A recurring daily time, in the format <code>HH:MM</code>. <code>HH</code> is the
        /// zero-padded hour of the day (0-23), and <code>MM</code> is the zero-padded minute of the
        /// hour. For example, <code>05:00</code> specifies 5 AM daily. </p>
        pub fn set_daily_automatic_backup_start_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.daily_automatic_backup_start_time = input;
            self
        }
        /// <p>The ONTAP administrative password for the <code>fsxadmin</code> user.</p>
        pub fn fsx_admin_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.fsx_admin_password = Some(input.into());
            self
        }
        /// <p>The ONTAP administrative password for the <code>fsxadmin</code> user.</p>
        pub fn set_fsx_admin_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.fsx_admin_password = input;
            self
        }
        /// <p>A recurring weekly time, in the format <code>D:HH:MM</code>. </p>
        /// <p>
        /// <code>D</code> is the day of the week, for which 1 represents Monday and 7
        /// represents Sunday. For further details, see <a href="https://en.wikipedia.org/wiki/ISO_week_date">the ISO-8601 spec as described on Wikipedia</a>.</p>
        /// <p>
        /// <code>HH</code> is the zero-padded hour of the day (0-23), and <code>MM</code> is
        /// the zero-padded minute of the hour. </p>
        /// <p>For example, <code>1:05:00</code> specifies maintenance at 5 AM Monday.</p>
        pub fn weekly_maintenance_start_time(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.weekly_maintenance_start_time = Some(input.into());
            self
        }
        /// <p>A recurring weekly time, in the format <code>D:HH:MM</code>. </p>
        /// <p>
        /// <code>D</code> is the day of the week, for which 1 represents Monday and 7
        /// represents Sunday. For further details, see <a href="https://en.wikipedia.org/wiki/ISO_week_date">the ISO-8601 spec as described on Wikipedia</a>.</p>
        /// <p>
        /// <code>HH</code> is the zero-padded hour of the day (0-23), and <code>MM</code> is
        /// the zero-padded minute of the hour. </p>
        /// <p>For example, <code>1:05:00</code> specifies maintenance at 5 AM Monday.</p>
        pub fn set_weekly_maintenance_start_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.weekly_maintenance_start_time = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFileSystemOntapConfiguration`](crate::model::UpdateFileSystemOntapConfiguration)
        pub fn build(self) -> crate::model::UpdateFileSystemOntapConfiguration {
            crate::model::UpdateFileSystemOntapConfiguration {
                automatic_backup_retention_days: self.automatic_backup_retention_days,
                daily_automatic_backup_start_time: self.daily_automatic_backup_start_time,
                fsx_admin_password: self.fsx_admin_password,
                weekly_maintenance_start_time: self.weekly_maintenance_start_time,
            }
        }
    }
}
impl UpdateFileSystemOntapConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateFileSystemOntapConfiguration`](crate::model::UpdateFileSystemOntapConfiguration)
    pub fn builder() -> crate::model::update_file_system_ontap_configuration::Builder {
        crate::model::update_file_system_ontap_configuration::Builder::default()
    }
}

/// <p>The configuration object for Amazon FSx for Lustre file systems used in the
/// <code>UpdateFileSystem</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFileSystemLustreConfiguration {
    /// <p>(Optional) The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC
    /// time zone. d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.</p>
    pub weekly_maintenance_start_time: std::option::Option<std::string::String>,
    /// <p>A recurring daily time, in the format <code>HH:MM</code>. <code>HH</code> is the
    /// zero-padded hour of the day (0-23), and <code>MM</code> is the zero-padded minute of the
    /// hour. For example, <code>05:00</code> specifies 5 AM daily. </p>
    pub daily_automatic_backup_start_time: std::option::Option<std::string::String>,
    /// <p>The number of days to retain automatic backups. Setting this to 0 disables
    /// automatic backups. You can retain automatic backups for a maximum of 90 days. The default is 0.</p>
    pub automatic_backup_retention_days: std::option::Option<i32>,
    /// <p> (Optional) When you create your file system, your existing S3 objects appear as file and directory listings.
    /// Use this property to choose how Amazon FSx keeps your file and directory listing up to date
    /// as you add or modify objects in your linked S3 bucket. <code>AutoImportPolicy</code> can
    /// have the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code> - (Default) AutoImport is off. Amazon FSx only updates
    /// file and directory listings from the linked S3 bucket
    /// when the file system is created. FSx does not update the file and directory
    /// listing for any new or changed objects after choosing this option.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NEW</code> - AutoImport is on. Amazon FSx automatically imports
    /// directory listings of any new objects added to the linked S3 bucket that
    /// do not currently exist in the FSx file system. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NEW_CHANGED</code> - AutoImport is on. Amazon FSx automatically imports
    /// file and directory listings of any new objects added to the S3 bucket and any
    /// existing objects that are changed in the S3 bucket after you choose this option.
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/autoimport-data-repo.html">Automatically import updates from your S3 bucket</a>.</p>
    pub auto_import_policy: std::option::Option<crate::model::AutoImportPolicyType>,
    /// <p>Sets the data compression configuration for the file system. <code>DataCompressionType</code>
    /// can have the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code> - Data compression is turned off for
    /// the file system.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LZ4</code> - Data compression is turned on with the LZ4
    /// algorithm.</p>
    /// </li>
    /// </ul>
    /// <p>If you don't use <code>DataCompressionType</code>, the file system retains
    /// its current data compression configuration.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data compression</a>.</p>
    pub data_compression_type: std::option::Option<crate::model::DataCompressionType>,
}
impl UpdateFileSystemLustreConfiguration {
    /// <p>(Optional) The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC
    /// time zone. d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.</p>
    pub fn weekly_maintenance_start_time(&self) -> std::option::Option<&str> {
        self.weekly_maintenance_start_time.as_deref()
    }
    /// <p>A recurring daily time, in the format <code>HH:MM</code>. <code>HH</code> is the
    /// zero-padded hour of the day (0-23), and <code>MM</code> is the zero-padded minute of the
    /// hour. For example, <code>05:00</code> specifies 5 AM daily. </p>
    pub fn daily_automatic_backup_start_time(&self) -> std::option::Option<&str> {
        self.daily_automatic_backup_start_time.as_deref()
    }
    /// <p>The number of days to retain automatic backups. Setting this to 0 disables
    /// automatic backups. You can retain automatic backups for a maximum of 90 days. The default is 0.</p>
    pub fn automatic_backup_retention_days(&self) -> std::option::Option<i32> {
        self.automatic_backup_retention_days
    }
    /// <p> (Optional) When you create your file system, your existing S3 objects appear as file and directory listings.
    /// Use this property to choose how Amazon FSx keeps your file and directory listing up to date
    /// as you add or modify objects in your linked S3 bucket. <code>AutoImportPolicy</code> can
    /// have the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code> - (Default) AutoImport is off. Amazon FSx only updates
    /// file and directory listings from the linked S3 bucket
    /// when the file system is created. FSx does not update the file and directory
    /// listing for any new or changed objects after choosing this option.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NEW</code> - AutoImport is on. Amazon FSx automatically imports
    /// directory listings of any new objects added to the linked S3 bucket that
    /// do not currently exist in the FSx file system. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NEW_CHANGED</code> - AutoImport is on. Amazon FSx automatically imports
    /// file and directory listings of any new objects added to the S3 bucket and any
    /// existing objects that are changed in the S3 bucket after you choose this option.
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/autoimport-data-repo.html">Automatically import updates from your S3 bucket</a>.</p>
    pub fn auto_import_policy(&self) -> std::option::Option<&crate::model::AutoImportPolicyType> {
        self.auto_import_policy.as_ref()
    }
    /// <p>Sets the data compression configuration for the file system. <code>DataCompressionType</code>
    /// can have the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code> - Data compression is turned off for
    /// the file system.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LZ4</code> - Data compression is turned on with the LZ4
    /// algorithm.</p>
    /// </li>
    /// </ul>
    /// <p>If you don't use <code>DataCompressionType</code>, the file system retains
    /// its current data compression configuration.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data compression</a>.</p>
    pub fn data_compression_type(&self) -> std::option::Option<&crate::model::DataCompressionType> {
        self.data_compression_type.as_ref()
    }
}
impl std::fmt::Debug for UpdateFileSystemLustreConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFileSystemLustreConfiguration");
        formatter.field(
            "weekly_maintenance_start_time",
            &self.weekly_maintenance_start_time,
        );
        formatter.field(
            "daily_automatic_backup_start_time",
            &self.daily_automatic_backup_start_time,
        );
        formatter.field(
            "automatic_backup_retention_days",
            &self.automatic_backup_retention_days,
        );
        formatter.field("auto_import_policy", &self.auto_import_policy);
        formatter.field("data_compression_type", &self.data_compression_type);
        formatter.finish()
    }
}
/// See [`UpdateFileSystemLustreConfiguration`](crate::model::UpdateFileSystemLustreConfiguration)
pub mod update_file_system_lustre_configuration {
    /// A builder for [`UpdateFileSystemLustreConfiguration`](crate::model::UpdateFileSystemLustreConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) weekly_maintenance_start_time: std::option::Option<std::string::String>,
        pub(crate) daily_automatic_backup_start_time: std::option::Option<std::string::String>,
        pub(crate) automatic_backup_retention_days: std::option::Option<i32>,
        pub(crate) auto_import_policy: std::option::Option<crate::model::AutoImportPolicyType>,
        pub(crate) data_compression_type: std::option::Option<crate::model::DataCompressionType>,
    }
    impl Builder {
        /// <p>(Optional) The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC
        /// time zone. d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.</p>
        pub fn weekly_maintenance_start_time(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.weekly_maintenance_start_time = Some(input.into());
            self
        }
        /// <p>(Optional) The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC
        /// time zone. d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.</p>
        pub fn set_weekly_maintenance_start_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.weekly_maintenance_start_time = input;
            self
        }
        /// <p>A recurring daily time, in the format <code>HH:MM</code>. <code>HH</code> is the
        /// zero-padded hour of the day (0-23), and <code>MM</code> is the zero-padded minute of the
        /// hour. For example, <code>05:00</code> specifies 5 AM daily. </p>
        pub fn daily_automatic_backup_start_time(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.daily_automatic_backup_start_time = Some(input.into());
            self
        }
        /// <p>A recurring daily time, in the format <code>HH:MM</code>. <code>HH</code> is the
        /// zero-padded hour of the day (0-23), and <code>MM</code> is the zero-padded minute of the
        /// hour. For example, <code>05:00</code> specifies 5 AM daily. </p>
        pub fn set_daily_automatic_backup_start_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.daily_automatic_backup_start_time = input;
            self
        }
        /// <p>The number of days to retain automatic backups. Setting this to 0 disables
        /// automatic backups. You can retain automatic backups for a maximum of 90 days. The default is 0.</p>
        pub fn automatic_backup_retention_days(mut self, input: i32) -> Self {
            self.automatic_backup_retention_days = Some(input);
            self
        }
        /// <p>The number of days to retain automatic backups. Setting this to 0 disables
        /// automatic backups. You can retain automatic backups for a maximum of 90 days. The default is 0.</p>
        pub fn set_automatic_backup_retention_days(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.automatic_backup_retention_days = input;
            self
        }
        /// <p> (Optional) When you create your file system, your existing S3 objects appear as file and directory listings.
        /// Use this property to choose how Amazon FSx keeps your file and directory listing up to date
        /// as you add or modify objects in your linked S3 bucket. <code>AutoImportPolicy</code> can
        /// have the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code> - (Default) AutoImport is off. Amazon FSx only updates
        /// file and directory listings from the linked S3 bucket
        /// when the file system is created. FSx does not update the file and directory
        /// listing for any new or changed objects after choosing this option.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NEW</code> - AutoImport is on. Amazon FSx automatically imports
        /// directory listings of any new objects added to the linked S3 bucket that
        /// do not currently exist in the FSx file system. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NEW_CHANGED</code> - AutoImport is on. Amazon FSx automatically imports
        /// file and directory listings of any new objects added to the S3 bucket and any
        /// existing objects that are changed in the S3 bucket after you choose this option.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/autoimport-data-repo.html">Automatically import updates from your S3 bucket</a>.</p>
        pub fn auto_import_policy(mut self, input: crate::model::AutoImportPolicyType) -> Self {
            self.auto_import_policy = Some(input);
            self
        }
        /// <p> (Optional) When you create your file system, your existing S3 objects appear as file and directory listings.
        /// Use this property to choose how Amazon FSx keeps your file and directory listing up to date
        /// as you add or modify objects in your linked S3 bucket. <code>AutoImportPolicy</code> can
        /// have the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code> - (Default) AutoImport is off. Amazon FSx only updates
        /// file and directory listings from the linked S3 bucket
        /// when the file system is created. FSx does not update the file and directory
        /// listing for any new or changed objects after choosing this option.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NEW</code> - AutoImport is on. Amazon FSx automatically imports
        /// directory listings of any new objects added to the linked S3 bucket that
        /// do not currently exist in the FSx file system. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NEW_CHANGED</code> - AutoImport is on. Amazon FSx automatically imports
        /// file and directory listings of any new objects added to the S3 bucket and any
        /// existing objects that are changed in the S3 bucket after you choose this option.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/autoimport-data-repo.html">Automatically import updates from your S3 bucket</a>.</p>
        pub fn set_auto_import_policy(
            mut self,
            input: std::option::Option<crate::model::AutoImportPolicyType>,
        ) -> Self {
            self.auto_import_policy = input;
            self
        }
        /// <p>Sets the data compression configuration for the file system. <code>DataCompressionType</code>
        /// can have the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code> - Data compression is turned off for
        /// the file system.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LZ4</code> - Data compression is turned on with the LZ4
        /// algorithm.</p>
        /// </li>
        /// </ul>
        /// <p>If you don't use <code>DataCompressionType</code>, the file system retains
        /// its current data compression configuration.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data compression</a>.</p>
        pub fn data_compression_type(mut self, input: crate::model::DataCompressionType) -> Self {
            self.data_compression_type = Some(input);
            self
        }
        /// <p>Sets the data compression configuration for the file system. <code>DataCompressionType</code>
        /// can have the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code> - Data compression is turned off for
        /// the file system.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LZ4</code> - Data compression is turned on with the LZ4
        /// algorithm.</p>
        /// </li>
        /// </ul>
        /// <p>If you don't use <code>DataCompressionType</code>, the file system retains
        /// its current data compression configuration.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data compression</a>.</p>
        pub fn set_data_compression_type(
            mut self,
            input: std::option::Option<crate::model::DataCompressionType>,
        ) -> Self {
            self.data_compression_type = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFileSystemLustreConfiguration`](crate::model::UpdateFileSystemLustreConfiguration)
        pub fn build(self) -> crate::model::UpdateFileSystemLustreConfiguration {
            crate::model::UpdateFileSystemLustreConfiguration {
                weekly_maintenance_start_time: self.weekly_maintenance_start_time,
                daily_automatic_backup_start_time: self.daily_automatic_backup_start_time,
                automatic_backup_retention_days: self.automatic_backup_retention_days,
                auto_import_policy: self.auto_import_policy,
                data_compression_type: self.data_compression_type,
            }
        }
    }
}
impl UpdateFileSystemLustreConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateFileSystemLustreConfiguration`](crate::model::UpdateFileSystemLustreConfiguration)
    pub fn builder() -> crate::model::update_file_system_lustre_configuration::Builder {
        crate::model::update_file_system_lustre_configuration::Builder::default()
    }
}

/// <p>Updates the configuration for an existing Amazon FSx for Windows
/// File Server file system. Amazon FSx only overwrites existing properties with non-null values
/// provided in the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFileSystemWindowsConfiguration {
    /// <p>The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC
    /// time zone. Where d is the weekday number, from 1 through 7, with 1 = Monday and 7 = Sunday.</p>
    pub weekly_maintenance_start_time: std::option::Option<std::string::String>,
    /// <p>The preferred time to start the daily automatic backup, in the UTC time zone, for example, <code>02:00</code>
    /// </p>
    pub daily_automatic_backup_start_time: std::option::Option<std::string::String>,
    /// <p>The number of days to retain automatic daily backups. Setting this to zero (0) disables automatic daily
    /// backups. You can retain automatic daily backups for a maximum of 90 days. For more information, see
    /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html#automatic-backups">Working with Automatic Daily Backups</a>.</p>
    pub automatic_backup_retention_days: std::option::Option<i32>,
    /// <p>Sets the target value for a file system's throughput capacity, in MB/s, that you are updating the file system to. Valid values are
    /// 8, 16, 32, 64, 128, 256, 512, 1024, 2048. You cannot make a throughput capacity update request if there is an existing throughput capacity update request in progress. For more information,
    /// see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-throughput-capacity.html">Managing Throughput Capacity</a>.</p>
    pub throughput_capacity: std::option::Option<i32>,
    /// <p>The configuration Amazon FSx uses to join the Windows File Server instance to the
    /// self-managed Microsoft AD directory. You cannot make a self-managed Microsoft AD update request if there is an existing self-managed Microsoft AD update request in progress.</p>
    pub self_managed_active_directory_configuration:
        std::option::Option<crate::model::SelfManagedActiveDirectoryConfigurationUpdates>,
    /// <p>The configuration that Amazon FSx for Windows File Server uses to audit and log
    /// user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server
    /// file system..</p>
    pub audit_log_configuration:
        std::option::Option<crate::model::WindowsAuditLogCreateConfiguration>,
}
impl UpdateFileSystemWindowsConfiguration {
    /// <p>The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC
    /// time zone. Where d is the weekday number, from 1 through 7, with 1 = Monday and 7 = Sunday.</p>
    pub fn weekly_maintenance_start_time(&self) -> std::option::Option<&str> {
        self.weekly_maintenance_start_time.as_deref()
    }
    /// <p>The preferred time to start the daily automatic backup, in the UTC time zone, for example, <code>02:00</code>
    /// </p>
    pub fn daily_automatic_backup_start_time(&self) -> std::option::Option<&str> {
        self.daily_automatic_backup_start_time.as_deref()
    }
    /// <p>The number of days to retain automatic daily backups. Setting this to zero (0) disables automatic daily
    /// backups. You can retain automatic daily backups for a maximum of 90 days. For more information, see
    /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html#automatic-backups">Working with Automatic Daily Backups</a>.</p>
    pub fn automatic_backup_retention_days(&self) -> std::option::Option<i32> {
        self.automatic_backup_retention_days
    }
    /// <p>Sets the target value for a file system's throughput capacity, in MB/s, that you are updating the file system to. Valid values are
    /// 8, 16, 32, 64, 128, 256, 512, 1024, 2048. You cannot make a throughput capacity update request if there is an existing throughput capacity update request in progress. For more information,
    /// see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-throughput-capacity.html">Managing Throughput Capacity</a>.</p>
    pub fn throughput_capacity(&self) -> std::option::Option<i32> {
        self.throughput_capacity
    }
    /// <p>The configuration Amazon FSx uses to join the Windows File Server instance to the
    /// self-managed Microsoft AD directory. You cannot make a self-managed Microsoft AD update request if there is an existing self-managed Microsoft AD update request in progress.</p>
    pub fn self_managed_active_directory_configuration(
        &self,
    ) -> std::option::Option<&crate::model::SelfManagedActiveDirectoryConfigurationUpdates> {
        self.self_managed_active_directory_configuration.as_ref()
    }
    /// <p>The configuration that Amazon FSx for Windows File Server uses to audit and log
    /// user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server
    /// file system..</p>
    pub fn audit_log_configuration(
        &self,
    ) -> std::option::Option<&crate::model::WindowsAuditLogCreateConfiguration> {
        self.audit_log_configuration.as_ref()
    }
}
impl std::fmt::Debug for UpdateFileSystemWindowsConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFileSystemWindowsConfiguration");
        formatter.field(
            "weekly_maintenance_start_time",
            &self.weekly_maintenance_start_time,
        );
        formatter.field(
            "daily_automatic_backup_start_time",
            &self.daily_automatic_backup_start_time,
        );
        formatter.field(
            "automatic_backup_retention_days",
            &self.automatic_backup_retention_days,
        );
        formatter.field("throughput_capacity", &self.throughput_capacity);
        formatter.field(
            "self_managed_active_directory_configuration",
            &self.self_managed_active_directory_configuration,
        );
        formatter.field("audit_log_configuration", &self.audit_log_configuration);
        formatter.finish()
    }
}
/// See [`UpdateFileSystemWindowsConfiguration`](crate::model::UpdateFileSystemWindowsConfiguration)
pub mod update_file_system_windows_configuration {
    /// A builder for [`UpdateFileSystemWindowsConfiguration`](crate::model::UpdateFileSystemWindowsConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) weekly_maintenance_start_time: std::option::Option<std::string::String>,
        pub(crate) daily_automatic_backup_start_time: std::option::Option<std::string::String>,
        pub(crate) automatic_backup_retention_days: std::option::Option<i32>,
        pub(crate) throughput_capacity: std::option::Option<i32>,
        pub(crate) self_managed_active_directory_configuration:
            std::option::Option<crate::model::SelfManagedActiveDirectoryConfigurationUpdates>,
        pub(crate) audit_log_configuration:
            std::option::Option<crate::model::WindowsAuditLogCreateConfiguration>,
    }
    impl Builder {
        /// <p>The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC
        /// time zone. Where d is the weekday number, from 1 through 7, with 1 = Monday and 7 = Sunday.</p>
        pub fn weekly_maintenance_start_time(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.weekly_maintenance_start_time = Some(input.into());
            self
        }
        /// <p>The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC
        /// time zone. Where d is the weekday number, from 1 through 7, with 1 = Monday and 7 = Sunday.</p>
        pub fn set_weekly_maintenance_start_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.weekly_maintenance_start_time = input;
            self
        }
        /// <p>The preferred time to start the daily automatic backup, in the UTC time zone, for example, <code>02:00</code>
        /// </p>
        pub fn daily_automatic_backup_start_time(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.daily_automatic_backup_start_time = Some(input.into());
            self
        }
        /// <p>The preferred time to start the daily automatic backup, in the UTC time zone, for example, <code>02:00</code>
        /// </p>
        pub fn set_daily_automatic_backup_start_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.daily_automatic_backup_start_time = input;
            self
        }
        /// <p>The number of days to retain automatic daily backups. Setting this to zero (0) disables automatic daily
        /// backups. You can retain automatic daily backups for a maximum of 90 days. For more information, see
        /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html#automatic-backups">Working with Automatic Daily Backups</a>.</p>
        pub fn automatic_backup_retention_days(mut self, input: i32) -> Self {
            self.automatic_backup_retention_days = Some(input);
            self
        }
        /// <p>The number of days to retain automatic daily backups. Setting this to zero (0) disables automatic daily
        /// backups. You can retain automatic daily backups for a maximum of 90 days. For more information, see
        /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html#automatic-backups">Working with Automatic Daily Backups</a>.</p>
        pub fn set_automatic_backup_retention_days(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.automatic_backup_retention_days = input;
            self
        }
        /// <p>Sets the target value for a file system's throughput capacity, in MB/s, that you are updating the file system to. Valid values are
        /// 8, 16, 32, 64, 128, 256, 512, 1024, 2048. You cannot make a throughput capacity update request if there is an existing throughput capacity update request in progress. For more information,
        /// see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-throughput-capacity.html">Managing Throughput Capacity</a>.</p>
        pub fn throughput_capacity(mut self, input: i32) -> Self {
            self.throughput_capacity = Some(input);
            self
        }
        /// <p>Sets the target value for a file system's throughput capacity, in MB/s, that you are updating the file system to. Valid values are
        /// 8, 16, 32, 64, 128, 256, 512, 1024, 2048. You cannot make a throughput capacity update request if there is an existing throughput capacity update request in progress. For more information,
        /// see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-throughput-capacity.html">Managing Throughput Capacity</a>.</p>
        pub fn set_throughput_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.throughput_capacity = input;
            self
        }
        /// <p>The configuration Amazon FSx uses to join the Windows File Server instance to the
        /// self-managed Microsoft AD directory. You cannot make a self-managed Microsoft AD update request if there is an existing self-managed Microsoft AD update request in progress.</p>
        pub fn self_managed_active_directory_configuration(
            mut self,
            input: crate::model::SelfManagedActiveDirectoryConfigurationUpdates,
        ) -> Self {
            self.self_managed_active_directory_configuration = Some(input);
            self
        }
        /// <p>The configuration Amazon FSx uses to join the Windows File Server instance to the
        /// self-managed Microsoft AD directory. You cannot make a self-managed Microsoft AD update request if there is an existing self-managed Microsoft AD update request in progress.</p>
        pub fn set_self_managed_active_directory_configuration(
            mut self,
            input: std::option::Option<
                crate::model::SelfManagedActiveDirectoryConfigurationUpdates,
            >,
        ) -> Self {
            self.self_managed_active_directory_configuration = input;
            self
        }
        /// <p>The configuration that Amazon FSx for Windows File Server uses to audit and log
        /// user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server
        /// file system..</p>
        pub fn audit_log_configuration(
            mut self,
            input: crate::model::WindowsAuditLogCreateConfiguration,
        ) -> Self {
            self.audit_log_configuration = Some(input);
            self
        }
        /// <p>The configuration that Amazon FSx for Windows File Server uses to audit and log
        /// user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server
        /// file system..</p>
        pub fn set_audit_log_configuration(
            mut self,
            input: std::option::Option<crate::model::WindowsAuditLogCreateConfiguration>,
        ) -> Self {
            self.audit_log_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFileSystemWindowsConfiguration`](crate::model::UpdateFileSystemWindowsConfiguration)
        pub fn build(self) -> crate::model::UpdateFileSystemWindowsConfiguration {
            crate::model::UpdateFileSystemWindowsConfiguration {
                weekly_maintenance_start_time: self.weekly_maintenance_start_time,
                daily_automatic_backup_start_time: self.daily_automatic_backup_start_time,
                automatic_backup_retention_days: self.automatic_backup_retention_days,
                throughput_capacity: self.throughput_capacity,
                self_managed_active_directory_configuration: self
                    .self_managed_active_directory_configuration,
                audit_log_configuration: self.audit_log_configuration,
            }
        }
    }
}
impl UpdateFileSystemWindowsConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateFileSystemWindowsConfiguration`](crate::model::UpdateFileSystemWindowsConfiguration)
    pub fn builder() -> crate::model::update_file_system_windows_configuration::Builder {
        crate::model::update_file_system_windows_configuration::Builder::default()
    }
}

/// <p>The Windows file access auditing configuration used when creating
/// or updating an Amazon FSx for Windows File Server file system.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WindowsAuditLogCreateConfiguration {
    /// <p>Sets which attempt type is logged by Amazon FSx for file and folder accesses.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SUCCESS_ONLY</code> - only successful attempts to access files
    /// or folders are logged.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILURE_ONLY</code> - only failed attempts to access files
    /// or folders are logged.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SUCCESS_AND_FAILURE</code> - both successful attempts and
    /// failed attempts to access files or folders are logged.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DISABLED</code> - access auditing of files and folders is turned off.</p>
    /// </li>
    /// </ul>
    pub file_access_audit_log_level: std::option::Option<crate::model::WindowsAccessAuditLogLevel>,
    /// <p>Sets which attempt type is logged by Amazon FSx for file share accesses.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SUCCESS_ONLY</code> - only successful attempts to access file
    /// shares are logged.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILURE_ONLY</code> - only failed attempts to access file
    /// shares are logged.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SUCCESS_AND_FAILURE</code> - both successful attempts and
    /// failed attempts to access file shares are logged.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DISABLED</code> - access auditing of file shares is turned off.</p>
    /// </li>
    /// </ul>
    pub file_share_access_audit_log_level:
        std::option::Option<crate::model::WindowsAccessAuditLogLevel>,
    /// <p>The Amazon Resource Name (ARN) that specifies the destination of the audit logs.</p>
    /// <p>The destination can be any Amazon CloudWatch Logs log group ARN or Amazon Kinesis
    /// Data Firehose delivery stream ARN, with the following requirements:</p>
    /// <ul>
    /// <li>
    /// <p>The destination ARN that you provide (either CloudWatch Logs log group
    /// or Kinesis Data Firehose delivery stream) must be in the same Amazon Web Services partition,
    /// Amazon Web Services Region, and Amazon Web Services account as your Amazon FSx file system.</p>
    /// </li>
    /// <li>
    /// <p>The name of the Amazon CloudWatch Logs log group must begin with
    /// the <code>/aws/fsx</code> prefix. The name of the Amazon Kinesis Data
    /// Firehouse delivery stream must begin with the <code>aws-fsx</code> prefix.</p>
    /// </li>
    /// <li>
    /// <p>If you do not provide a destination in <code>AuditLogDestination</code>,
    /// Amazon FSx will create and use a log stream in the CloudWatch Logs
    /// <code>/aws/fsx/windows</code> log group.</p>
    /// </li>
    /// <li>
    /// <p>If <code>AuditLogDestination</code> is provided and the resource does not
    /// exist, the request will fail with a <code>BadRequest</code> error.</p>
    /// </li>
    /// <li>
    /// <p>If <code>FileAccessAuditLogLevel</code> and <code>FileShareAccessAuditLogLevel</code>
    /// are both set to <code>DISABLED</code>, you cannot specify a destination in
    /// <code>AuditLogDestination</code>.</p>
    /// </li>
    /// </ul>
    pub audit_log_destination: std::option::Option<std::string::String>,
}
impl WindowsAuditLogCreateConfiguration {
    /// <p>Sets which attempt type is logged by Amazon FSx for file and folder accesses.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SUCCESS_ONLY</code> - only successful attempts to access files
    /// or folders are logged.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILURE_ONLY</code> - only failed attempts to access files
    /// or folders are logged.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SUCCESS_AND_FAILURE</code> - both successful attempts and
    /// failed attempts to access files or folders are logged.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DISABLED</code> - access auditing of files and folders is turned off.</p>
    /// </li>
    /// </ul>
    pub fn file_access_audit_log_level(
        &self,
    ) -> std::option::Option<&crate::model::WindowsAccessAuditLogLevel> {
        self.file_access_audit_log_level.as_ref()
    }
    /// <p>Sets which attempt type is logged by Amazon FSx for file share accesses.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SUCCESS_ONLY</code> - only successful attempts to access file
    /// shares are logged.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILURE_ONLY</code> - only failed attempts to access file
    /// shares are logged.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SUCCESS_AND_FAILURE</code> - both successful attempts and
    /// failed attempts to access file shares are logged.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DISABLED</code> - access auditing of file shares is turned off.</p>
    /// </li>
    /// </ul>
    pub fn file_share_access_audit_log_level(
        &self,
    ) -> std::option::Option<&crate::model::WindowsAccessAuditLogLevel> {
        self.file_share_access_audit_log_level.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) that specifies the destination of the audit logs.</p>
    /// <p>The destination can be any Amazon CloudWatch Logs log group ARN or Amazon Kinesis
    /// Data Firehose delivery stream ARN, with the following requirements:</p>
    /// <ul>
    /// <li>
    /// <p>The destination ARN that you provide (either CloudWatch Logs log group
    /// or Kinesis Data Firehose delivery stream) must be in the same Amazon Web Services partition,
    /// Amazon Web Services Region, and Amazon Web Services account as your Amazon FSx file system.</p>
    /// </li>
    /// <li>
    /// <p>The name of the Amazon CloudWatch Logs log group must begin with
    /// the <code>/aws/fsx</code> prefix. The name of the Amazon Kinesis Data
    /// Firehouse delivery stream must begin with the <code>aws-fsx</code> prefix.</p>
    /// </li>
    /// <li>
    /// <p>If you do not provide a destination in <code>AuditLogDestination</code>,
    /// Amazon FSx will create and use a log stream in the CloudWatch Logs
    /// <code>/aws/fsx/windows</code> log group.</p>
    /// </li>
    /// <li>
    /// <p>If <code>AuditLogDestination</code> is provided and the resource does not
    /// exist, the request will fail with a <code>BadRequest</code> error.</p>
    /// </li>
    /// <li>
    /// <p>If <code>FileAccessAuditLogLevel</code> and <code>FileShareAccessAuditLogLevel</code>
    /// are both set to <code>DISABLED</code>, you cannot specify a destination in
    /// <code>AuditLogDestination</code>.</p>
    /// </li>
    /// </ul>
    pub fn audit_log_destination(&self) -> std::option::Option<&str> {
        self.audit_log_destination.as_deref()
    }
}
impl std::fmt::Debug for WindowsAuditLogCreateConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WindowsAuditLogCreateConfiguration");
        formatter.field(
            "file_access_audit_log_level",
            &self.file_access_audit_log_level,
        );
        formatter.field(
            "file_share_access_audit_log_level",
            &self.file_share_access_audit_log_level,
        );
        formatter.field("audit_log_destination", &self.audit_log_destination);
        formatter.finish()
    }
}
/// See [`WindowsAuditLogCreateConfiguration`](crate::model::WindowsAuditLogCreateConfiguration)
pub mod windows_audit_log_create_configuration {
    /// A builder for [`WindowsAuditLogCreateConfiguration`](crate::model::WindowsAuditLogCreateConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_access_audit_log_level:
            std::option::Option<crate::model::WindowsAccessAuditLogLevel>,
        pub(crate) file_share_access_audit_log_level:
            std::option::Option<crate::model::WindowsAccessAuditLogLevel>,
        pub(crate) audit_log_destination: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Sets which attempt type is logged by Amazon FSx for file and folder accesses.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SUCCESS_ONLY</code> - only successful attempts to access files
        /// or folders are logged.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILURE_ONLY</code> - only failed attempts to access files
        /// or folders are logged.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SUCCESS_AND_FAILURE</code> - both successful attempts and
        /// failed attempts to access files or folders are logged.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DISABLED</code> - access auditing of files and folders is turned off.</p>
        /// </li>
        /// </ul>
        pub fn file_access_audit_log_level(
            mut self,
            input: crate::model::WindowsAccessAuditLogLevel,
        ) -> Self {
            self.file_access_audit_log_level = Some(input);
            self
        }
        /// <p>Sets which attempt type is logged by Amazon FSx for file and folder accesses.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SUCCESS_ONLY</code> - only successful attempts to access files
        /// or folders are logged.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILURE_ONLY</code> - only failed attempts to access files
        /// or folders are logged.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SUCCESS_AND_FAILURE</code> - both successful attempts and
        /// failed attempts to access files or folders are logged.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DISABLED</code> - access auditing of files and folders is turned off.</p>
        /// </li>
        /// </ul>
        pub fn set_file_access_audit_log_level(
            mut self,
            input: std::option::Option<crate::model::WindowsAccessAuditLogLevel>,
        ) -> Self {
            self.file_access_audit_log_level = input;
            self
        }
        /// <p>Sets which attempt type is logged by Amazon FSx for file share accesses.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SUCCESS_ONLY</code> - only successful attempts to access file
        /// shares are logged.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILURE_ONLY</code> - only failed attempts to access file
        /// shares are logged.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SUCCESS_AND_FAILURE</code> - both successful attempts and
        /// failed attempts to access file shares are logged.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DISABLED</code> - access auditing of file shares is turned off.</p>
        /// </li>
        /// </ul>
        pub fn file_share_access_audit_log_level(
            mut self,
            input: crate::model::WindowsAccessAuditLogLevel,
        ) -> Self {
            self.file_share_access_audit_log_level = Some(input);
            self
        }
        /// <p>Sets which attempt type is logged by Amazon FSx for file share accesses.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SUCCESS_ONLY</code> - only successful attempts to access file
        /// shares are logged.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILURE_ONLY</code> - only failed attempts to access file
        /// shares are logged.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SUCCESS_AND_FAILURE</code> - both successful attempts and
        /// failed attempts to access file shares are logged.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DISABLED</code> - access auditing of file shares is turned off.</p>
        /// </li>
        /// </ul>
        pub fn set_file_share_access_audit_log_level(
            mut self,
            input: std::option::Option<crate::model::WindowsAccessAuditLogLevel>,
        ) -> Self {
            self.file_share_access_audit_log_level = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that specifies the destination of the audit logs.</p>
        /// <p>The destination can be any Amazon CloudWatch Logs log group ARN or Amazon Kinesis
        /// Data Firehose delivery stream ARN, with the following requirements:</p>
        /// <ul>
        /// <li>
        /// <p>The destination ARN that you provide (either CloudWatch Logs log group
        /// or Kinesis Data Firehose delivery stream) must be in the same Amazon Web Services partition,
        /// Amazon Web Services Region, and Amazon Web Services account as your Amazon FSx file system.</p>
        /// </li>
        /// <li>
        /// <p>The name of the Amazon CloudWatch Logs log group must begin with
        /// the <code>/aws/fsx</code> prefix. The name of the Amazon Kinesis Data
        /// Firehouse delivery stream must begin with the <code>aws-fsx</code> prefix.</p>
        /// </li>
        /// <li>
        /// <p>If you do not provide a destination in <code>AuditLogDestination</code>,
        /// Amazon FSx will create and use a log stream in the CloudWatch Logs
        /// <code>/aws/fsx/windows</code> log group.</p>
        /// </li>
        /// <li>
        /// <p>If <code>AuditLogDestination</code> is provided and the resource does not
        /// exist, the request will fail with a <code>BadRequest</code> error.</p>
        /// </li>
        /// <li>
        /// <p>If <code>FileAccessAuditLogLevel</code> and <code>FileShareAccessAuditLogLevel</code>
        /// are both set to <code>DISABLED</code>, you cannot specify a destination in
        /// <code>AuditLogDestination</code>.</p>
        /// </li>
        /// </ul>
        pub fn audit_log_destination(mut self, input: impl Into<std::string::String>) -> Self {
            self.audit_log_destination = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that specifies the destination of the audit logs.</p>
        /// <p>The destination can be any Amazon CloudWatch Logs log group ARN or Amazon Kinesis
        /// Data Firehose delivery stream ARN, with the following requirements:</p>
        /// <ul>
        /// <li>
        /// <p>The destination ARN that you provide (either CloudWatch Logs log group
        /// or Kinesis Data Firehose delivery stream) must be in the same Amazon Web Services partition,
        /// Amazon Web Services Region, and Amazon Web Services account as your Amazon FSx file system.</p>
        /// </li>
        /// <li>
        /// <p>The name of the Amazon CloudWatch Logs log group must begin with
        /// the <code>/aws/fsx</code> prefix. The name of the Amazon Kinesis Data
        /// Firehouse delivery stream must begin with the <code>aws-fsx</code> prefix.</p>
        /// </li>
        /// <li>
        /// <p>If you do not provide a destination in <code>AuditLogDestination</code>,
        /// Amazon FSx will create and use a log stream in the CloudWatch Logs
        /// <code>/aws/fsx/windows</code> log group.</p>
        /// </li>
        /// <li>
        /// <p>If <code>AuditLogDestination</code> is provided and the resource does not
        /// exist, the request will fail with a <code>BadRequest</code> error.</p>
        /// </li>
        /// <li>
        /// <p>If <code>FileAccessAuditLogLevel</code> and <code>FileShareAccessAuditLogLevel</code>
        /// are both set to <code>DISABLED</code>, you cannot specify a destination in
        /// <code>AuditLogDestination</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_audit_log_destination(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.audit_log_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`WindowsAuditLogCreateConfiguration`](crate::model::WindowsAuditLogCreateConfiguration)
        pub fn build(self) -> crate::model::WindowsAuditLogCreateConfiguration {
            crate::model::WindowsAuditLogCreateConfiguration {
                file_access_audit_log_level: self.file_access_audit_log_level,
                file_share_access_audit_log_level: self.file_share_access_audit_log_level,
                audit_log_destination: self.audit_log_destination,
            }
        }
    }
}
impl WindowsAuditLogCreateConfiguration {
    /// Creates a new builder-style object to manufacture [`WindowsAuditLogCreateConfiguration`](crate::model::WindowsAuditLogCreateConfiguration)
    pub fn builder() -> crate::model::windows_audit_log_create_configuration::Builder {
        crate::model::windows_audit_log_create_configuration::Builder::default()
    }
}

/// <p>A filter used to restrict the results of describe calls for
/// Amazon FSx for NetApp ONTAP volumes. You can use multiple
/// filters to return results that meet all applied filter requirements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VolumeFilter {
    /// <p>The name for this filter.</p>
    pub name: std::option::Option<crate::model::VolumeFilterName>,
    /// <p>The values of the filter. These are all the values for any of the applied
    /// filters.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl VolumeFilter {
    /// <p>The name for this filter.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::VolumeFilterName> {
        self.name.as_ref()
    }
    /// <p>The values of the filter. These are all the values for any of the applied
    /// filters.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for VolumeFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VolumeFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`VolumeFilter`](crate::model::VolumeFilter)
pub mod volume_filter {
    /// A builder for [`VolumeFilter`](crate::model::VolumeFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::VolumeFilterName>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name for this filter.</p>
        pub fn name(mut self, input: crate::model::VolumeFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name for this filter.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::VolumeFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The values of the filter. These are all the values for any of the applied
        /// filters.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The values of the filter. These are all the values for any of the applied
        /// filters.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`VolumeFilter`](crate::model::VolumeFilter)
        pub fn build(self) -> crate::model::VolumeFilter {
            crate::model::VolumeFilter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl VolumeFilter {
    /// Creates a new builder-style object to manufacture [`VolumeFilter`](crate::model::VolumeFilter)
    pub fn builder() -> crate::model::volume_filter::Builder {
        crate::model::volume_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VolumeFilterName {
    #[allow(missing_docs)] // documentation missing in model
    FileSystemId,
    #[allow(missing_docs)] // documentation missing in model
    StorageVirtualMachineId,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VolumeFilterName {
    fn from(s: &str) -> Self {
        match s {
            "file-system-id" => VolumeFilterName::FileSystemId,
            "storage-virtual-machine-id" => VolumeFilterName::StorageVirtualMachineId,
            other => VolumeFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VolumeFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VolumeFilterName::from(s))
    }
}
impl VolumeFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VolumeFilterName::FileSystemId => "file-system-id",
            VolumeFilterName::StorageVirtualMachineId => "storage-virtual-machine-id",
            VolumeFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["file-system-id", "storage-virtual-machine-id"]
    }
}
impl AsRef<str> for VolumeFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A filter used to restrict the results of describe calls for
/// Amazon FSx for NetApp ONTAP storage virtual machines (SVMs). You can use multiple
/// filters to return results that meet all applied filter requirements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StorageVirtualMachineFilter {
    /// <p>The name for this filter.</p>
    pub name: std::option::Option<crate::model::StorageVirtualMachineFilterName>,
    /// <p>The values of the filter. These are all the values for any of the applied
    /// filters.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl StorageVirtualMachineFilter {
    /// <p>The name for this filter.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::StorageVirtualMachineFilterName> {
        self.name.as_ref()
    }
    /// <p>The values of the filter. These are all the values for any of the applied
    /// filters.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for StorageVirtualMachineFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StorageVirtualMachineFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`StorageVirtualMachineFilter`](crate::model::StorageVirtualMachineFilter)
pub mod storage_virtual_machine_filter {
    /// A builder for [`StorageVirtualMachineFilter`](crate::model::StorageVirtualMachineFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::StorageVirtualMachineFilterName>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name for this filter.</p>
        pub fn name(mut self, input: crate::model::StorageVirtualMachineFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name for this filter.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::StorageVirtualMachineFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The values of the filter. These are all the values for any of the applied
        /// filters.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The values of the filter. These are all the values for any of the applied
        /// filters.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`StorageVirtualMachineFilter`](crate::model::StorageVirtualMachineFilter)
        pub fn build(self) -> crate::model::StorageVirtualMachineFilter {
            crate::model::StorageVirtualMachineFilter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl StorageVirtualMachineFilter {
    /// Creates a new builder-style object to manufacture [`StorageVirtualMachineFilter`](crate::model::StorageVirtualMachineFilter)
    pub fn builder() -> crate::model::storage_virtual_machine_filter::Builder {
        crate::model::storage_virtual_machine_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StorageVirtualMachineFilterName {
    #[allow(missing_docs)] // documentation missing in model
    FileSystemId,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StorageVirtualMachineFilterName {
    fn from(s: &str) -> Self {
        match s {
            "file-system-id" => StorageVirtualMachineFilterName::FileSystemId,
            other => StorageVirtualMachineFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StorageVirtualMachineFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StorageVirtualMachineFilterName::from(s))
    }
}
impl StorageVirtualMachineFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StorageVirtualMachineFilterName::FileSystemId => "file-system-id",
            StorageVirtualMachineFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["file-system-id"]
    }
}
impl AsRef<str> for StorageVirtualMachineFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A description of the data repository task. You use data repository tasks
/// to perform bulk transfer operations between your Amazon FSx file system and its linked data
/// repository.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataRepositoryTask {
    /// <p>The system-generated, unique 17-digit ID of the data repository task.</p>
    pub task_id: std::option::Option<std::string::String>,
    /// <p>The lifecycle status of the data repository task, as follows:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PENDING</code> - Amazon FSx has not started the task.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EXECUTING</code> - Amazon FSx is processing the task.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> -  Amazon FSx was not able to complete the task. For example, there may be files the task failed to process.
    /// The <a>DataRepositoryTaskFailureDetails</a> property provides more information about task failures.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SUCCEEDED</code> - FSx completed the task successfully.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CANCELED</code> - Amazon FSx canceled the task and it did not complete.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CANCELING</code> - FSx is in process of canceling the task.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>You cannot delete an FSx for Lustre file system if there are data
    /// repository tasks for the file system in the <code>PENDING</code> or <code>EXECUTING</code> states.
    /// Please retry when the data repository task is finished (with a status of <code>CANCELED</code>, <code>SUCCEEDED</code>, or <code>FAILED</code>).
    /// You can use the DescribeDataRepositoryTask action to monitor the task status. Contact the FSx team if you need to delete your file system immediately.</p>
    /// </note>
    pub lifecycle: std::option::Option<crate::model::DataRepositoryTaskLifecycle>,
    /// <p>The type of data repository task; EXPORT_TO_REPOSITORY is the only type currently supported.</p>
    pub r#type: std::option::Option<crate::model::DataRepositoryTaskType>,
    /// <p>The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z),
    /// also known as Unix time.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that Amazon FSx began processing the task.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that Amazon FSx completed processing the task, populated after the task is complete.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services
    /// resources. We require an ARN when you need to specify a resource unambiguously across
    /// all of Amazon Web Services. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
    /// the <i>Amazon Web Services General Reference</i>.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The globally unique ID of the file system, assigned by Amazon FSx.</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>An array of paths on the Amazon FSx for Lustre file system that specify the data for the data repository task to process.
    /// For example, in an EXPORT_TO_REPOSITORY task, the paths specify which data to export to the linked data repository.</p>
    /// <p>(Default) If <code>Paths</code> is not specified, Amazon FSx uses the file system root directory.</p>
    pub paths: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Failure message describing why the task failed, it is populated only when <code>Lifecycle</code> is set to <code>FAILED</code>.</p>
    pub failure_details: std::option::Option<crate::model::DataRepositoryTaskFailureDetails>,
    /// <p>Provides the status of the number of files that the task has processed successfully and failed to process.</p>
    pub status: std::option::Option<crate::model::DataRepositoryTaskStatus>,
    /// <p>Provides a report detailing the data repository task results of the files processed that match the criteria specified in the report <code>Scope</code> parameter.
    /// FSx delivers the report to the file system's linked data repository in Amazon S3,
    /// using the path specified in the report <code>Path</code> parameter.
    /// You can specify whether or not a report gets generated for a task using the <code>Enabled</code> parameter.</p>
    pub report: std::option::Option<crate::model::CompletionReport>,
}
impl DataRepositoryTask {
    /// <p>The system-generated, unique 17-digit ID of the data repository task.</p>
    pub fn task_id(&self) -> std::option::Option<&str> {
        self.task_id.as_deref()
    }
    /// <p>The lifecycle status of the data repository task, as follows:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PENDING</code> - Amazon FSx has not started the task.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EXECUTING</code> - Amazon FSx is processing the task.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> -  Amazon FSx was not able to complete the task. For example, there may be files the task failed to process.
    /// The <a>DataRepositoryTaskFailureDetails</a> property provides more information about task failures.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SUCCEEDED</code> - FSx completed the task successfully.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CANCELED</code> - Amazon FSx canceled the task and it did not complete.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CANCELING</code> - FSx is in process of canceling the task.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>You cannot delete an FSx for Lustre file system if there are data
    /// repository tasks for the file system in the <code>PENDING</code> or <code>EXECUTING</code> states.
    /// Please retry when the data repository task is finished (with a status of <code>CANCELED</code>, <code>SUCCEEDED</code>, or <code>FAILED</code>).
    /// You can use the DescribeDataRepositoryTask action to monitor the task status. Contact the FSx team if you need to delete your file system immediately.</p>
    /// </note>
    pub fn lifecycle(&self) -> std::option::Option<&crate::model::DataRepositoryTaskLifecycle> {
        self.lifecycle.as_ref()
    }
    /// <p>The type of data repository task; EXPORT_TO_REPOSITORY is the only type currently supported.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::DataRepositoryTaskType> {
        self.r#type.as_ref()
    }
    /// <p>The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z),
    /// also known as Unix time.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
    /// <p>The time that Amazon FSx began processing the task.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.start_time.as_ref()
    }
    /// <p>The time that Amazon FSx completed processing the task, populated after the task is complete.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.end_time.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services
    /// resources. We require an ARN when you need to specify a resource unambiguously across
    /// all of Amazon Web Services. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
    /// the <i>Amazon Web Services General Reference</i>.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The globally unique ID of the file system, assigned by Amazon FSx.</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
    /// <p>An array of paths on the Amazon FSx for Lustre file system that specify the data for the data repository task to process.
    /// For example, in an EXPORT_TO_REPOSITORY task, the paths specify which data to export to the linked data repository.</p>
    /// <p>(Default) If <code>Paths</code> is not specified, Amazon FSx uses the file system root directory.</p>
    pub fn paths(&self) -> std::option::Option<&[std::string::String]> {
        self.paths.as_deref()
    }
    /// <p>Failure message describing why the task failed, it is populated only when <code>Lifecycle</code> is set to <code>FAILED</code>.</p>
    pub fn failure_details(
        &self,
    ) -> std::option::Option<&crate::model::DataRepositoryTaskFailureDetails> {
        self.failure_details.as_ref()
    }
    /// <p>Provides the status of the number of files that the task has processed successfully and failed to process.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::DataRepositoryTaskStatus> {
        self.status.as_ref()
    }
    /// <p>Provides a report detailing the data repository task results of the files processed that match the criteria specified in the report <code>Scope</code> parameter.
    /// FSx delivers the report to the file system's linked data repository in Amazon S3,
    /// using the path specified in the report <code>Path</code> parameter.
    /// You can specify whether or not a report gets generated for a task using the <code>Enabled</code> parameter.</p>
    pub fn report(&self) -> std::option::Option<&crate::model::CompletionReport> {
        self.report.as_ref()
    }
}
impl std::fmt::Debug for DataRepositoryTask {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataRepositoryTask");
        formatter.field("task_id", &self.task_id);
        formatter.field("lifecycle", &self.lifecycle);
        formatter.field("r#type", &self.r#type);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("paths", &self.paths);
        formatter.field("failure_details", &self.failure_details);
        formatter.field("status", &self.status);
        formatter.field("report", &self.report);
        formatter.finish()
    }
}
/// See [`DataRepositoryTask`](crate::model::DataRepositoryTask)
pub mod data_repository_task {
    /// A builder for [`DataRepositoryTask`](crate::model::DataRepositoryTask)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_id: std::option::Option<std::string::String>,
        pub(crate) lifecycle: std::option::Option<crate::model::DataRepositoryTaskLifecycle>,
        pub(crate) r#type: std::option::Option<crate::model::DataRepositoryTaskType>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) paths: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) failure_details:
            std::option::Option<crate::model::DataRepositoryTaskFailureDetails>,
        pub(crate) status: std::option::Option<crate::model::DataRepositoryTaskStatus>,
        pub(crate) report: std::option::Option<crate::model::CompletionReport>,
    }
    impl Builder {
        /// <p>The system-generated, unique 17-digit ID of the data repository task.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_id = Some(input.into());
            self
        }
        /// <p>The system-generated, unique 17-digit ID of the data repository task.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_id = input;
            self
        }
        /// <p>The lifecycle status of the data repository task, as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PENDING</code> - Amazon FSx has not started the task.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EXECUTING</code> - Amazon FSx is processing the task.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> -  Amazon FSx was not able to complete the task. For example, there may be files the task failed to process.
        /// The <a>DataRepositoryTaskFailureDetails</a> property provides more information about task failures.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SUCCEEDED</code> - FSx completed the task successfully.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CANCELED</code> - Amazon FSx canceled the task and it did not complete.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CANCELING</code> - FSx is in process of canceling the task.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>You cannot delete an FSx for Lustre file system if there are data
        /// repository tasks for the file system in the <code>PENDING</code> or <code>EXECUTING</code> states.
        /// Please retry when the data repository task is finished (with a status of <code>CANCELED</code>, <code>SUCCEEDED</code>, or <code>FAILED</code>).
        /// You can use the DescribeDataRepositoryTask action to monitor the task status. Contact the FSx team if you need to delete your file system immediately.</p>
        /// </note>
        pub fn lifecycle(mut self, input: crate::model::DataRepositoryTaskLifecycle) -> Self {
            self.lifecycle = Some(input);
            self
        }
        /// <p>The lifecycle status of the data repository task, as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PENDING</code> - Amazon FSx has not started the task.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EXECUTING</code> - Amazon FSx is processing the task.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> -  Amazon FSx was not able to complete the task. For example, there may be files the task failed to process.
        /// The <a>DataRepositoryTaskFailureDetails</a> property provides more information about task failures.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SUCCEEDED</code> - FSx completed the task successfully.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CANCELED</code> - Amazon FSx canceled the task and it did not complete.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CANCELING</code> - FSx is in process of canceling the task.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>You cannot delete an FSx for Lustre file system if there are data
        /// repository tasks for the file system in the <code>PENDING</code> or <code>EXECUTING</code> states.
        /// Please retry when the data repository task is finished (with a status of <code>CANCELED</code>, <code>SUCCEEDED</code>, or <code>FAILED</code>).
        /// You can use the DescribeDataRepositoryTask action to monitor the task status. Contact the FSx team if you need to delete your file system immediately.</p>
        /// </note>
        pub fn set_lifecycle(
            mut self,
            input: std::option::Option<crate::model::DataRepositoryTaskLifecycle>,
        ) -> Self {
            self.lifecycle = input;
            self
        }
        /// <p>The type of data repository task; EXPORT_TO_REPOSITORY is the only type currently supported.</p>
        pub fn r#type(mut self, input: crate::model::DataRepositoryTaskType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of data repository task; EXPORT_TO_REPOSITORY is the only type currently supported.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DataRepositoryTaskType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z),
        /// also known as Unix time.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z),
        /// also known as Unix time.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time that Amazon FSx began processing the task.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The time that Amazon FSx began processing the task.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The time that Amazon FSx completed processing the task, populated after the task is complete.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The time that Amazon FSx completed processing the task, populated after the task is complete.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services
        /// resources. We require an ARN when you need to specify a resource unambiguously across
        /// all of Amazon Web Services. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
        /// the <i>Amazon Web Services General Reference</i>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services
        /// resources. We require an ARN when you need to specify a resource unambiguously across
        /// all of Amazon Web Services. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
        /// the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The globally unique ID of the file system, assigned by Amazon FSx.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>The globally unique ID of the file system, assigned by Amazon FSx.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// Appends an item to `paths`.
        ///
        /// To override the contents of this collection use [`set_paths`](Self::set_paths).
        ///
        /// <p>An array of paths on the Amazon FSx for Lustre file system that specify the data for the data repository task to process.
        /// For example, in an EXPORT_TO_REPOSITORY task, the paths specify which data to export to the linked data repository.</p>
        /// <p>(Default) If <code>Paths</code> is not specified, Amazon FSx uses the file system root directory.</p>
        pub fn paths(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.paths.unwrap_or_default();
            v.push(input.into());
            self.paths = Some(v);
            self
        }
        /// <p>An array of paths on the Amazon FSx for Lustre file system that specify the data for the data repository task to process.
        /// For example, in an EXPORT_TO_REPOSITORY task, the paths specify which data to export to the linked data repository.</p>
        /// <p>(Default) If <code>Paths</code> is not specified, Amazon FSx uses the file system root directory.</p>
        pub fn set_paths(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.paths = input;
            self
        }
        /// <p>Failure message describing why the task failed, it is populated only when <code>Lifecycle</code> is set to <code>FAILED</code>.</p>
        pub fn failure_details(
            mut self,
            input: crate::model::DataRepositoryTaskFailureDetails,
        ) -> Self {
            self.failure_details = Some(input);
            self
        }
        /// <p>Failure message describing why the task failed, it is populated only when <code>Lifecycle</code> is set to <code>FAILED</code>.</p>
        pub fn set_failure_details(
            mut self,
            input: std::option::Option<crate::model::DataRepositoryTaskFailureDetails>,
        ) -> Self {
            self.failure_details = input;
            self
        }
        /// <p>Provides the status of the number of files that the task has processed successfully and failed to process.</p>
        pub fn status(mut self, input: crate::model::DataRepositoryTaskStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Provides the status of the number of files that the task has processed successfully and failed to process.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DataRepositoryTaskStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Provides a report detailing the data repository task results of the files processed that match the criteria specified in the report <code>Scope</code> parameter.
        /// FSx delivers the report to the file system's linked data repository in Amazon S3,
        /// using the path specified in the report <code>Path</code> parameter.
        /// You can specify whether or not a report gets generated for a task using the <code>Enabled</code> parameter.</p>
        pub fn report(mut self, input: crate::model::CompletionReport) -> Self {
            self.report = Some(input);
            self
        }
        /// <p>Provides a report detailing the data repository task results of the files processed that match the criteria specified in the report <code>Scope</code> parameter.
        /// FSx delivers the report to the file system's linked data repository in Amazon S3,
        /// using the path specified in the report <code>Path</code> parameter.
        /// You can specify whether or not a report gets generated for a task using the <code>Enabled</code> parameter.</p>
        pub fn set_report(
            mut self,
            input: std::option::Option<crate::model::CompletionReport>,
        ) -> Self {
            self.report = input;
            self
        }
        /// Consumes the builder and constructs a [`DataRepositoryTask`](crate::model::DataRepositoryTask)
        pub fn build(self) -> crate::model::DataRepositoryTask {
            crate::model::DataRepositoryTask {
                task_id: self.task_id,
                lifecycle: self.lifecycle,
                r#type: self.r#type,
                creation_time: self.creation_time,
                start_time: self.start_time,
                end_time: self.end_time,
                resource_arn: self.resource_arn,
                tags: self.tags,
                file_system_id: self.file_system_id,
                paths: self.paths,
                failure_details: self.failure_details,
                status: self.status,
                report: self.report,
            }
        }
    }
}
impl DataRepositoryTask {
    /// Creates a new builder-style object to manufacture [`DataRepositoryTask`](crate::model::DataRepositoryTask)
    pub fn builder() -> crate::model::data_repository_task::Builder {
        crate::model::data_repository_task::Builder::default()
    }
}

/// <p>Provides a report detailing the data repository task results of the files processed that match the criteria specified in the report <code>Scope</code> parameter.
/// FSx delivers the report to the file system's linked data repository in Amazon S3,
/// using the path specified in the report <code>Path</code> parameter.
/// You can specify whether or not a report gets generated for a task using the <code>Enabled</code> parameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CompletionReport {
    /// <p>Set <code>Enabled</code> to <code>True</code> to generate a <code>CompletionReport</code> when the task completes.
    /// If set to <code>true</code>, then you need to provide a report <code>Scope</code>, <code>Path</code>, and <code>Format</code>.
    /// Set <code>Enabled</code> to <code>False</code> if you do not want a <code>CompletionReport</code> generated when the task completes.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>Required if <code>Enabled</code> is set to <code>true</code>. Specifies the location of the report on the file system's linked S3 data repository. An absolute path that defines where the completion report will be stored in the destination location.
    /// The <code>Path</code> you provide must be located within the file system’s ExportPath.
    /// An example <code>Path</code> value is "s3://myBucket/myExportPath/optionalPrefix". The report provides the following information for each file in the report:
    /// FilePath, FileStatus, and ErrorCode. To learn more about a file system's <code>ExportPath</code>, see .
    /// </p>
    pub path: std::option::Option<std::string::String>,
    /// <p>Required if <code>Enabled</code> is set to <code>true</code>. Specifies the format of the <code>CompletionReport</code>. <code>REPORT_CSV_20191124</code> is the only format currently supported.
    /// When <code>Format</code> is set to <code>REPORT_CSV_20191124</code>, the <code>CompletionReport</code> is provided in CSV format, and is delivered to
    /// <code>{path}/task-{id}/failures.csv</code>.
    /// </p>
    pub format: std::option::Option<crate::model::ReportFormat>,
    /// <p>Required if <code>Enabled</code> is set to <code>true</code>. Specifies the scope of the <code>CompletionReport</code>; <code>FAILED_FILES_ONLY</code> is the only scope currently supported.
    /// When <code>Scope</code> is set to <code>FAILED_FILES_ONLY</code>, the <code>CompletionReport</code> only contains information about files that the data repository task failed to process.</p>
    pub scope: std::option::Option<crate::model::ReportScope>,
}
impl CompletionReport {
    /// <p>Set <code>Enabled</code> to <code>True</code> to generate a <code>CompletionReport</code> when the task completes.
    /// If set to <code>true</code>, then you need to provide a report <code>Scope</code>, <code>Path</code>, and <code>Format</code>.
    /// Set <code>Enabled</code> to <code>False</code> if you do not want a <code>CompletionReport</code> generated when the task completes.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>Required if <code>Enabled</code> is set to <code>true</code>. Specifies the location of the report on the file system's linked S3 data repository. An absolute path that defines where the completion report will be stored in the destination location.
    /// The <code>Path</code> you provide must be located within the file system’s ExportPath.
    /// An example <code>Path</code> value is "s3://myBucket/myExportPath/optionalPrefix". The report provides the following information for each file in the report:
    /// FilePath, FileStatus, and ErrorCode. To learn more about a file system's <code>ExportPath</code>, see .
    /// </p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
    /// <p>Required if <code>Enabled</code> is set to <code>true</code>. Specifies the format of the <code>CompletionReport</code>. <code>REPORT_CSV_20191124</code> is the only format currently supported.
    /// When <code>Format</code> is set to <code>REPORT_CSV_20191124</code>, the <code>CompletionReport</code> is provided in CSV format, and is delivered to
    /// <code>{path}/task-{id}/failures.csv</code>.
    /// </p>
    pub fn format(&self) -> std::option::Option<&crate::model::ReportFormat> {
        self.format.as_ref()
    }
    /// <p>Required if <code>Enabled</code> is set to <code>true</code>. Specifies the scope of the <code>CompletionReport</code>; <code>FAILED_FILES_ONLY</code> is the only scope currently supported.
    /// When <code>Scope</code> is set to <code>FAILED_FILES_ONLY</code>, the <code>CompletionReport</code> only contains information about files that the data repository task failed to process.</p>
    pub fn scope(&self) -> std::option::Option<&crate::model::ReportScope> {
        self.scope.as_ref()
    }
}
impl std::fmt::Debug for CompletionReport {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CompletionReport");
        formatter.field("enabled", &self.enabled);
        formatter.field("path", &self.path);
        formatter.field("format", &self.format);
        formatter.field("scope", &self.scope);
        formatter.finish()
    }
}
/// See [`CompletionReport`](crate::model::CompletionReport)
pub mod completion_report {
    /// A builder for [`CompletionReport`](crate::model::CompletionReport)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::ReportFormat>,
        pub(crate) scope: std::option::Option<crate::model::ReportScope>,
    }
    impl Builder {
        /// <p>Set <code>Enabled</code> to <code>True</code> to generate a <code>CompletionReport</code> when the task completes.
        /// If set to <code>true</code>, then you need to provide a report <code>Scope</code>, <code>Path</code>, and <code>Format</code>.
        /// Set <code>Enabled</code> to <code>False</code> if you do not want a <code>CompletionReport</code> generated when the task completes.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Set <code>Enabled</code> to <code>True</code> to generate a <code>CompletionReport</code> when the task completes.
        /// If set to <code>true</code>, then you need to provide a report <code>Scope</code>, <code>Path</code>, and <code>Format</code>.
        /// Set <code>Enabled</code> to <code>False</code> if you do not want a <code>CompletionReport</code> generated when the task completes.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>Required if <code>Enabled</code> is set to <code>true</code>. Specifies the location of the report on the file system's linked S3 data repository. An absolute path that defines where the completion report will be stored in the destination location.
        /// The <code>Path</code> you provide must be located within the file system’s ExportPath.
        /// An example <code>Path</code> value is "s3://myBucket/myExportPath/optionalPrefix". The report provides the following information for each file in the report:
        /// FilePath, FileStatus, and ErrorCode. To learn more about a file system's <code>ExportPath</code>, see .
        /// </p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>Required if <code>Enabled</code> is set to <code>true</code>. Specifies the location of the report on the file system's linked S3 data repository. An absolute path that defines where the completion report will be stored in the destination location.
        /// The <code>Path</code> you provide must be located within the file system’s ExportPath.
        /// An example <code>Path</code> value is "s3://myBucket/myExportPath/optionalPrefix". The report provides the following information for each file in the report:
        /// FilePath, FileStatus, and ErrorCode. To learn more about a file system's <code>ExportPath</code>, see .
        /// </p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>Required if <code>Enabled</code> is set to <code>true</code>. Specifies the format of the <code>CompletionReport</code>. <code>REPORT_CSV_20191124</code> is the only format currently supported.
        /// When <code>Format</code> is set to <code>REPORT_CSV_20191124</code>, the <code>CompletionReport</code> is provided in CSV format, and is delivered to
        /// <code>{path}/task-{id}/failures.csv</code>.
        /// </p>
        pub fn format(mut self, input: crate::model::ReportFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>Required if <code>Enabled</code> is set to <code>true</code>. Specifies the format of the <code>CompletionReport</code>. <code>REPORT_CSV_20191124</code> is the only format currently supported.
        /// When <code>Format</code> is set to <code>REPORT_CSV_20191124</code>, the <code>CompletionReport</code> is provided in CSV format, and is delivered to
        /// <code>{path}/task-{id}/failures.csv</code>.
        /// </p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::ReportFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// <p>Required if <code>Enabled</code> is set to <code>true</code>. Specifies the scope of the <code>CompletionReport</code>; <code>FAILED_FILES_ONLY</code> is the only scope currently supported.
        /// When <code>Scope</code> is set to <code>FAILED_FILES_ONLY</code>, the <code>CompletionReport</code> only contains information about files that the data repository task failed to process.</p>
        pub fn scope(mut self, input: crate::model::ReportScope) -> Self {
            self.scope = Some(input);
            self
        }
        /// <p>Required if <code>Enabled</code> is set to <code>true</code>. Specifies the scope of the <code>CompletionReport</code>; <code>FAILED_FILES_ONLY</code> is the only scope currently supported.
        /// When <code>Scope</code> is set to <code>FAILED_FILES_ONLY</code>, the <code>CompletionReport</code> only contains information about files that the data repository task failed to process.</p>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::ReportScope>) -> Self {
            self.scope = input;
            self
        }
        /// Consumes the builder and constructs a [`CompletionReport`](crate::model::CompletionReport)
        pub fn build(self) -> crate::model::CompletionReport {
            crate::model::CompletionReport {
                enabled: self.enabled,
                path: self.path,
                format: self.format,
                scope: self.scope,
            }
        }
    }
}
impl CompletionReport {
    /// Creates a new builder-style object to manufacture [`CompletionReport`](crate::model::CompletionReport)
    pub fn builder() -> crate::model::completion_report::Builder {
        crate::model::completion_report::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReportScope {
    #[allow(missing_docs)] // documentation missing in model
    FailedFilesOnly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReportScope {
    fn from(s: &str) -> Self {
        match s {
            "FAILED_FILES_ONLY" => ReportScope::FailedFilesOnly,
            other => ReportScope::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReportScope {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReportScope::from(s))
    }
}
impl ReportScope {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReportScope::FailedFilesOnly => "FAILED_FILES_ONLY",
            ReportScope::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED_FILES_ONLY"]
    }
}
impl AsRef<str> for ReportScope {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReportFormat {
    #[allow(missing_docs)] // documentation missing in model
    ReportCsv20191124,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReportFormat {
    fn from(s: &str) -> Self {
        match s {
            "REPORT_CSV_20191124" => ReportFormat::ReportCsv20191124,
            other => ReportFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReportFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReportFormat::from(s))
    }
}
impl ReportFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReportFormat::ReportCsv20191124 => "REPORT_CSV_20191124",
            ReportFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["REPORT_CSV_20191124"]
    }
}
impl AsRef<str> for ReportFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides the task status showing a running total of the total number of files to be processed,
/// the number successfully processed, and the number of files the task failed to process.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataRepositoryTaskStatus {
    /// <p>The total number of files that the task will process. While a task is executing, the sum of
    /// <code>SucceededCount</code> plus <code>FailedCount</code> may not equal <code>TotalCount</code>. When the task is complete,
    /// <code>TotalCount</code> equals the sum of <code>SucceededCount</code> plus <code>FailedCount</code>.</p>
    pub total_count: std::option::Option<i64>,
    /// <p>A running total of the number of files that the task has successfully processed.</p>
    pub succeeded_count: std::option::Option<i64>,
    /// <p>A running total of the number of files that the task failed to process.</p>
    pub failed_count: std::option::Option<i64>,
    /// <p>The time at which the task status was last updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::Instant>,
}
impl DataRepositoryTaskStatus {
    /// <p>The total number of files that the task will process. While a task is executing, the sum of
    /// <code>SucceededCount</code> plus <code>FailedCount</code> may not equal <code>TotalCount</code>. When the task is complete,
    /// <code>TotalCount</code> equals the sum of <code>SucceededCount</code> plus <code>FailedCount</code>.</p>
    pub fn total_count(&self) -> std::option::Option<i64> {
        self.total_count
    }
    /// <p>A running total of the number of files that the task has successfully processed.</p>
    pub fn succeeded_count(&self) -> std::option::Option<i64> {
        self.succeeded_count
    }
    /// <p>A running total of the number of files that the task failed to process.</p>
    pub fn failed_count(&self) -> std::option::Option<i64> {
        self.failed_count
    }
    /// <p>The time at which the task status was last updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_time.as_ref()
    }
}
impl std::fmt::Debug for DataRepositoryTaskStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataRepositoryTaskStatus");
        formatter.field("total_count", &self.total_count);
        formatter.field("succeeded_count", &self.succeeded_count);
        formatter.field("failed_count", &self.failed_count);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.finish()
    }
}
/// See [`DataRepositoryTaskStatus`](crate::model::DataRepositoryTaskStatus)
pub mod data_repository_task_status {
    /// A builder for [`DataRepositoryTaskStatus`](crate::model::DataRepositoryTaskStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) total_count: std::option::Option<i64>,
        pub(crate) succeeded_count: std::option::Option<i64>,
        pub(crate) failed_count: std::option::Option<i64>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The total number of files that the task will process. While a task is executing, the sum of
        /// <code>SucceededCount</code> plus <code>FailedCount</code> may not equal <code>TotalCount</code>. When the task is complete,
        /// <code>TotalCount</code> equals the sum of <code>SucceededCount</code> plus <code>FailedCount</code>.</p>
        pub fn total_count(mut self, input: i64) -> Self {
            self.total_count = Some(input);
            self
        }
        /// <p>The total number of files that the task will process. While a task is executing, the sum of
        /// <code>SucceededCount</code> plus <code>FailedCount</code> may not equal <code>TotalCount</code>. When the task is complete,
        /// <code>TotalCount</code> equals the sum of <code>SucceededCount</code> plus <code>FailedCount</code>.</p>
        pub fn set_total_count(mut self, input: std::option::Option<i64>) -> Self {
            self.total_count = input;
            self
        }
        /// <p>A running total of the number of files that the task has successfully processed.</p>
        pub fn succeeded_count(mut self, input: i64) -> Self {
            self.succeeded_count = Some(input);
            self
        }
        /// <p>A running total of the number of files that the task has successfully processed.</p>
        pub fn set_succeeded_count(mut self, input: std::option::Option<i64>) -> Self {
            self.succeeded_count = input;
            self
        }
        /// <p>A running total of the number of files that the task failed to process.</p>
        pub fn failed_count(mut self, input: i64) -> Self {
            self.failed_count = Some(input);
            self
        }
        /// <p>A running total of the number of files that the task failed to process.</p>
        pub fn set_failed_count(mut self, input: std::option::Option<i64>) -> Self {
            self.failed_count = input;
            self
        }
        /// <p>The time at which the task status was last updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The time at which the task status was last updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DataRepositoryTaskStatus`](crate::model::DataRepositoryTaskStatus)
        pub fn build(self) -> crate::model::DataRepositoryTaskStatus {
            crate::model::DataRepositoryTaskStatus {
                total_count: self.total_count,
                succeeded_count: self.succeeded_count,
                failed_count: self.failed_count,
                last_updated_time: self.last_updated_time,
            }
        }
    }
}
impl DataRepositoryTaskStatus {
    /// Creates a new builder-style object to manufacture [`DataRepositoryTaskStatus`](crate::model::DataRepositoryTaskStatus)
    pub fn builder() -> crate::model::data_repository_task_status::Builder {
        crate::model::data_repository_task_status::Builder::default()
    }
}

/// <p>Provides information about why a data repository task failed. Only populated when the task <code>Lifecycle</code> is set to <code>FAILED</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataRepositoryTaskFailureDetails {
    /// <p>A detailed error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl DataRepositoryTaskFailureDetails {
    /// <p>A detailed error message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for DataRepositoryTaskFailureDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataRepositoryTaskFailureDetails");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`DataRepositoryTaskFailureDetails`](crate::model::DataRepositoryTaskFailureDetails)
pub mod data_repository_task_failure_details {
    /// A builder for [`DataRepositoryTaskFailureDetails`](crate::model::DataRepositoryTaskFailureDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A detailed error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A detailed error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DataRepositoryTaskFailureDetails`](crate::model::DataRepositoryTaskFailureDetails)
        pub fn build(self) -> crate::model::DataRepositoryTaskFailureDetails {
            crate::model::DataRepositoryTaskFailureDetails {
                message: self.message,
            }
        }
    }
}
impl DataRepositoryTaskFailureDetails {
    /// Creates a new builder-style object to manufacture [`DataRepositoryTaskFailureDetails`](crate::model::DataRepositoryTaskFailureDetails)
    pub fn builder() -> crate::model::data_repository_task_failure_details::Builder {
        crate::model::data_repository_task_failure_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataRepositoryTaskType {
    #[allow(missing_docs)] // documentation missing in model
    Export,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataRepositoryTaskType {
    fn from(s: &str) -> Self {
        match s {
            "EXPORT_TO_REPOSITORY" => DataRepositoryTaskType::Export,
            other => DataRepositoryTaskType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataRepositoryTaskType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataRepositoryTaskType::from(s))
    }
}
impl DataRepositoryTaskType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataRepositoryTaskType::Export => "EXPORT_TO_REPOSITORY",
            DataRepositoryTaskType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EXPORT_TO_REPOSITORY"]
    }
}
impl AsRef<str> for DataRepositoryTaskType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataRepositoryTaskLifecycle {
    #[allow(missing_docs)] // documentation missing in model
    Canceled,
    #[allow(missing_docs)] // documentation missing in model
    Canceling,
    #[allow(missing_docs)] // documentation missing in model
    Executing,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataRepositoryTaskLifecycle {
    fn from(s: &str) -> Self {
        match s {
            "CANCELED" => DataRepositoryTaskLifecycle::Canceled,
            "CANCELING" => DataRepositoryTaskLifecycle::Canceling,
            "EXECUTING" => DataRepositoryTaskLifecycle::Executing,
            "FAILED" => DataRepositoryTaskLifecycle::Failed,
            "PENDING" => DataRepositoryTaskLifecycle::Pending,
            "SUCCEEDED" => DataRepositoryTaskLifecycle::Succeeded,
            other => DataRepositoryTaskLifecycle::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataRepositoryTaskLifecycle {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataRepositoryTaskLifecycle::from(s))
    }
}
impl DataRepositoryTaskLifecycle {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataRepositoryTaskLifecycle::Canceled => "CANCELED",
            DataRepositoryTaskLifecycle::Canceling => "CANCELING",
            DataRepositoryTaskLifecycle::Executing => "EXECUTING",
            DataRepositoryTaskLifecycle::Failed => "FAILED",
            DataRepositoryTaskLifecycle::Pending => "PENDING",
            DataRepositoryTaskLifecycle::Succeeded => "SUCCEEDED",
            DataRepositoryTaskLifecycle::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANCELED",
            "CANCELING",
            "EXECUTING",
            "FAILED",
            "PENDING",
            "SUCCEEDED",
        ]
    }
}
impl AsRef<str> for DataRepositoryTaskLifecycle {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>(Optional) An array of filter objects you can use to filter the response of data repository tasks you will see in the the response.
/// You can filter the tasks returned in the response by one or more file system IDs, task lifecycles, and by task type.
/// A filter object consists of a filter <code>Name</code>, and one or more <code>Values</code> for the filter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataRepositoryTaskFilter {
    /// <p>Name of the task property to use in filtering the tasks returned in the response.</p>
    /// <ul>
    /// <li>
    /// <p>Use <code>file-system-id</code> to retrieve data repository tasks for specific file systems.</p>
    /// </li>
    /// <li>
    /// <p>Use <code>task-lifecycle</code> to retrieve data repository tasks with one or more specific lifecycle states,
    /// as follows: CANCELED, EXECUTING, FAILED, PENDING, and SUCCEEDED.</p>
    /// </li>
    /// </ul>
    pub name: std::option::Option<crate::model::DataRepositoryTaskFilterName>,
    /// <p>Use Values to include the specific file system IDs and task
    /// lifecycle states for the filters you are using.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DataRepositoryTaskFilter {
    /// <p>Name of the task property to use in filtering the tasks returned in the response.</p>
    /// <ul>
    /// <li>
    /// <p>Use <code>file-system-id</code> to retrieve data repository tasks for specific file systems.</p>
    /// </li>
    /// <li>
    /// <p>Use <code>task-lifecycle</code> to retrieve data repository tasks with one or more specific lifecycle states,
    /// as follows: CANCELED, EXECUTING, FAILED, PENDING, and SUCCEEDED.</p>
    /// </li>
    /// </ul>
    pub fn name(&self) -> std::option::Option<&crate::model::DataRepositoryTaskFilterName> {
        self.name.as_ref()
    }
    /// <p>Use Values to include the specific file system IDs and task
    /// lifecycle states for the filters you are using.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for DataRepositoryTaskFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataRepositoryTaskFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`DataRepositoryTaskFilter`](crate::model::DataRepositoryTaskFilter)
pub mod data_repository_task_filter {
    /// A builder for [`DataRepositoryTaskFilter`](crate::model::DataRepositoryTaskFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::DataRepositoryTaskFilterName>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Name of the task property to use in filtering the tasks returned in the response.</p>
        /// <ul>
        /// <li>
        /// <p>Use <code>file-system-id</code> to retrieve data repository tasks for specific file systems.</p>
        /// </li>
        /// <li>
        /// <p>Use <code>task-lifecycle</code> to retrieve data repository tasks with one or more specific lifecycle states,
        /// as follows: CANCELED, EXECUTING, FAILED, PENDING, and SUCCEEDED.</p>
        /// </li>
        /// </ul>
        pub fn name(mut self, input: crate::model::DataRepositoryTaskFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>Name of the task property to use in filtering the tasks returned in the response.</p>
        /// <ul>
        /// <li>
        /// <p>Use <code>file-system-id</code> to retrieve data repository tasks for specific file systems.</p>
        /// </li>
        /// <li>
        /// <p>Use <code>task-lifecycle</code> to retrieve data repository tasks with one or more specific lifecycle states,
        /// as follows: CANCELED, EXECUTING, FAILED, PENDING, and SUCCEEDED.</p>
        /// </li>
        /// </ul>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::DataRepositoryTaskFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>Use Values to include the specific file system IDs and task
        /// lifecycle states for the filters you are using.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>Use Values to include the specific file system IDs and task
        /// lifecycle states for the filters you are using.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`DataRepositoryTaskFilter`](crate::model::DataRepositoryTaskFilter)
        pub fn build(self) -> crate::model::DataRepositoryTaskFilter {
            crate::model::DataRepositoryTaskFilter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl DataRepositoryTaskFilter {
    /// Creates a new builder-style object to manufacture [`DataRepositoryTaskFilter`](crate::model::DataRepositoryTaskFilter)
    pub fn builder() -> crate::model::data_repository_task_filter::Builder {
        crate::model::data_repository_task_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataRepositoryTaskFilterName {
    #[allow(missing_docs)] // documentation missing in model
    FileSystemId,
    #[allow(missing_docs)] // documentation missing in model
    TaskLifecycle,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataRepositoryTaskFilterName {
    fn from(s: &str) -> Self {
        match s {
            "file-system-id" => DataRepositoryTaskFilterName::FileSystemId,
            "task-lifecycle" => DataRepositoryTaskFilterName::TaskLifecycle,
            other => DataRepositoryTaskFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataRepositoryTaskFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataRepositoryTaskFilterName::from(s))
    }
}
impl DataRepositoryTaskFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataRepositoryTaskFilterName::FileSystemId => "file-system-id",
            DataRepositoryTaskFilterName::TaskLifecycle => "task-lifecycle",
            DataRepositoryTaskFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["file-system-id", "task-lifecycle"]
    }
}
impl AsRef<str> for DataRepositoryTaskFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A backup of an Amazon FSx for Windows File Server or Amazon FSx for Lustre file system,
/// or of an Amazon FSx for NetApp ONTAP volume.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Backup {
    /// <p>The ID of the backup.</p>
    pub backup_id: std::option::Option<std::string::String>,
    /// <p>The lifecycle status of the backup.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>AVAILABLE</code> - The backup is fully available.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PENDING</code> - For user-initiated backups on Lustre file systems only; Amazon FSx has not started creating the backup.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATING</code> - Amazon FSx is creating the backup.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TRANSFERRING</code> - For user-initiated backups on Lustre file systems only; Amazon FSx is transferring the backup to S3.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COPYING</code> - Amazon FSx is copying the backup.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETED</code> - Amazon FSx deleted the backup and it is no longer available.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - Amazon FSx could not complete the backup.</p>
    /// </li>
    /// </ul>
    pub lifecycle: std::option::Option<crate::model::BackupLifecycle>,
    /// <p>Details explaining any failures that occur when creating a backup.</p>
    pub failure_details: std::option::Option<crate::model::BackupFailureDetails>,
    /// <p>The type of the file system backup.</p>
    pub r#type: std::option::Option<crate::model::BackupType>,
    /// <p>The current percent of progress of an asynchronous task.</p>
    pub progress_percent: std::option::Option<i32>,
    /// <p>The time when a particular backup was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The ID of the Key Management Service (KMS) key used to encrypt the
    /// backup of the Amazon FSx file system's data at rest.
    /// </p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the backup resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Tags associated with a particular file system.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Metadata of the file system associated with the backup. This metadata is persisted
    /// even if the file system is deleted.</p>
    pub file_system: std::option::Option<crate::model::FileSystem>,
    /// <p>The configuration of the self-managed Microsoft Active Directory (AD) to which the Windows File Server instance is joined.</p>
    pub directory_information: std::option::Option<crate::model::ActiveDirectoryBackupAttributes>,
    /// <p>An Amazon Web Services account ID. This ID is a 12-digit number that you use to construct Amazon
    /// Resource Names (ARNs) for resources.</p>
    pub owner_id: std::option::Option<std::string::String>,
    /// <p>The ID of the source backup. Specifies the backup you are copying.</p>
    pub source_backup_id: std::option::Option<std::string::String>,
    /// <p>The source Region of the backup. Specifies the Region from where this backup
    /// is copied.</p>
    pub source_backup_region: std::option::Option<std::string::String>,
    /// <p>Specifies the resource type that is backed up.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>Describes an Amazon FSx for NetApp ONTAP volume.</p>
    pub volume: std::option::Option<crate::model::Volume>,
}
impl Backup {
    /// <p>The ID of the backup.</p>
    pub fn backup_id(&self) -> std::option::Option<&str> {
        self.backup_id.as_deref()
    }
    /// <p>The lifecycle status of the backup.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>AVAILABLE</code> - The backup is fully available.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PENDING</code> - For user-initiated backups on Lustre file systems only; Amazon FSx has not started creating the backup.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATING</code> - Amazon FSx is creating the backup.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TRANSFERRING</code> - For user-initiated backups on Lustre file systems only; Amazon FSx is transferring the backup to S3.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COPYING</code> - Amazon FSx is copying the backup.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETED</code> - Amazon FSx deleted the backup and it is no longer available.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - Amazon FSx could not complete the backup.</p>
    /// </li>
    /// </ul>
    pub fn lifecycle(&self) -> std::option::Option<&crate::model::BackupLifecycle> {
        self.lifecycle.as_ref()
    }
    /// <p>Details explaining any failures that occur when creating a backup.</p>
    pub fn failure_details(&self) -> std::option::Option<&crate::model::BackupFailureDetails> {
        self.failure_details.as_ref()
    }
    /// <p>The type of the file system backup.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::BackupType> {
        self.r#type.as_ref()
    }
    /// <p>The current percent of progress of an asynchronous task.</p>
    pub fn progress_percent(&self) -> std::option::Option<i32> {
        self.progress_percent
    }
    /// <p>The time when a particular backup was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
    /// <p>The ID of the Key Management Service (KMS) key used to encrypt the
    /// backup of the Amazon FSx file system's data at rest.
    /// </p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the backup resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>Tags associated with a particular file system.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>Metadata of the file system associated with the backup. This metadata is persisted
    /// even if the file system is deleted.</p>
    pub fn file_system(&self) -> std::option::Option<&crate::model::FileSystem> {
        self.file_system.as_ref()
    }
    /// <p>The configuration of the self-managed Microsoft Active Directory (AD) to which the Windows File Server instance is joined.</p>
    pub fn directory_information(
        &self,
    ) -> std::option::Option<&crate::model::ActiveDirectoryBackupAttributes> {
        self.directory_information.as_ref()
    }
    /// <p>An Amazon Web Services account ID. This ID is a 12-digit number that you use to construct Amazon
    /// Resource Names (ARNs) for resources.</p>
    pub fn owner_id(&self) -> std::option::Option<&str> {
        self.owner_id.as_deref()
    }
    /// <p>The ID of the source backup. Specifies the backup you are copying.</p>
    pub fn source_backup_id(&self) -> std::option::Option<&str> {
        self.source_backup_id.as_deref()
    }
    /// <p>The source Region of the backup. Specifies the Region from where this backup
    /// is copied.</p>
    pub fn source_backup_region(&self) -> std::option::Option<&str> {
        self.source_backup_region.as_deref()
    }
    /// <p>Specifies the resource type that is backed up.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>Describes an Amazon FSx for NetApp ONTAP volume.</p>
    pub fn volume(&self) -> std::option::Option<&crate::model::Volume> {
        self.volume.as_ref()
    }
}
impl std::fmt::Debug for Backup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Backup");
        formatter.field("backup_id", &self.backup_id);
        formatter.field("lifecycle", &self.lifecycle);
        formatter.field("failure_details", &self.failure_details);
        formatter.field("r#type", &self.r#type);
        formatter.field("progress_percent", &self.progress_percent);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.field("file_system", &self.file_system);
        formatter.field("directory_information", &self.directory_information);
        formatter.field("owner_id", &self.owner_id);
        formatter.field("source_backup_id", &self.source_backup_id);
        formatter.field("source_backup_region", &self.source_backup_region);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("volume", &self.volume);
        formatter.finish()
    }
}
/// See [`Backup`](crate::model::Backup)
pub mod backup {
    /// A builder for [`Backup`](crate::model::Backup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_id: std::option::Option<std::string::String>,
        pub(crate) lifecycle: std::option::Option<crate::model::BackupLifecycle>,
        pub(crate) failure_details: std::option::Option<crate::model::BackupFailureDetails>,
        pub(crate) r#type: std::option::Option<crate::model::BackupType>,
        pub(crate) progress_percent: std::option::Option<i32>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) file_system: std::option::Option<crate::model::FileSystem>,
        pub(crate) directory_information:
            std::option::Option<crate::model::ActiveDirectoryBackupAttributes>,
        pub(crate) owner_id: std::option::Option<std::string::String>,
        pub(crate) source_backup_id: std::option::Option<std::string::String>,
        pub(crate) source_backup_region: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) volume: std::option::Option<crate::model::Volume>,
    }
    impl Builder {
        /// <p>The ID of the backup.</p>
        pub fn backup_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_id = Some(input.into());
            self
        }
        /// <p>The ID of the backup.</p>
        pub fn set_backup_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.backup_id = input;
            self
        }
        /// <p>The lifecycle status of the backup.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AVAILABLE</code> - The backup is fully available.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PENDING</code> - For user-initiated backups on Lustre file systems only; Amazon FSx has not started creating the backup.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATING</code> - Amazon FSx is creating the backup.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TRANSFERRING</code> - For user-initiated backups on Lustre file systems only; Amazon FSx is transferring the backup to S3.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COPYING</code> - Amazon FSx is copying the backup.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETED</code> - Amazon FSx deleted the backup and it is no longer available.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - Amazon FSx could not complete the backup.</p>
        /// </li>
        /// </ul>
        pub fn lifecycle(mut self, input: crate::model::BackupLifecycle) -> Self {
            self.lifecycle = Some(input);
            self
        }
        /// <p>The lifecycle status of the backup.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AVAILABLE</code> - The backup is fully available.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PENDING</code> - For user-initiated backups on Lustre file systems only; Amazon FSx has not started creating the backup.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATING</code> - Amazon FSx is creating the backup.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TRANSFERRING</code> - For user-initiated backups on Lustre file systems only; Amazon FSx is transferring the backup to S3.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COPYING</code> - Amazon FSx is copying the backup.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETED</code> - Amazon FSx deleted the backup and it is no longer available.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - Amazon FSx could not complete the backup.</p>
        /// </li>
        /// </ul>
        pub fn set_lifecycle(
            mut self,
            input: std::option::Option<crate::model::BackupLifecycle>,
        ) -> Self {
            self.lifecycle = input;
            self
        }
        /// <p>Details explaining any failures that occur when creating a backup.</p>
        pub fn failure_details(mut self, input: crate::model::BackupFailureDetails) -> Self {
            self.failure_details = Some(input);
            self
        }
        /// <p>Details explaining any failures that occur when creating a backup.</p>
        pub fn set_failure_details(
            mut self,
            input: std::option::Option<crate::model::BackupFailureDetails>,
        ) -> Self {
            self.failure_details = input;
            self
        }
        /// <p>The type of the file system backup.</p>
        pub fn r#type(mut self, input: crate::model::BackupType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the file system backup.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::BackupType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The current percent of progress of an asynchronous task.</p>
        pub fn progress_percent(mut self, input: i32) -> Self {
            self.progress_percent = Some(input);
            self
        }
        /// <p>The current percent of progress of an asynchronous task.</p>
        pub fn set_progress_percent(mut self, input: std::option::Option<i32>) -> Self {
            self.progress_percent = input;
            self
        }
        /// <p>The time when a particular backup was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time when a particular backup was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The ID of the Key Management Service (KMS) key used to encrypt the
        /// backup of the Amazon FSx file system's data at rest.
        /// </p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID of the Key Management Service (KMS) key used to encrypt the
        /// backup of the Amazon FSx file system's data at rest.
        /// </p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the backup resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the backup resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags associated with a particular file system.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Tags associated with a particular file system.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Metadata of the file system associated with the backup. This metadata is persisted
        /// even if the file system is deleted.</p>
        pub fn file_system(mut self, input: crate::model::FileSystem) -> Self {
            self.file_system = Some(input);
            self
        }
        /// <p>Metadata of the file system associated with the backup. This metadata is persisted
        /// even if the file system is deleted.</p>
        pub fn set_file_system(
            mut self,
            input: std::option::Option<crate::model::FileSystem>,
        ) -> Self {
            self.file_system = input;
            self
        }
        /// <p>The configuration of the self-managed Microsoft Active Directory (AD) to which the Windows File Server instance is joined.</p>
        pub fn directory_information(
            mut self,
            input: crate::model::ActiveDirectoryBackupAttributes,
        ) -> Self {
            self.directory_information = Some(input);
            self
        }
        /// <p>The configuration of the self-managed Microsoft Active Directory (AD) to which the Windows File Server instance is joined.</p>
        pub fn set_directory_information(
            mut self,
            input: std::option::Option<crate::model::ActiveDirectoryBackupAttributes>,
        ) -> Self {
            self.directory_information = input;
            self
        }
        /// <p>An Amazon Web Services account ID. This ID is a 12-digit number that you use to construct Amazon
        /// Resource Names (ARNs) for resources.</p>
        pub fn owner_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_id = Some(input.into());
            self
        }
        /// <p>An Amazon Web Services account ID. This ID is a 12-digit number that you use to construct Amazon
        /// Resource Names (ARNs) for resources.</p>
        pub fn set_owner_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner_id = input;
            self
        }
        /// <p>The ID of the source backup. Specifies the backup you are copying.</p>
        pub fn source_backup_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_backup_id = Some(input.into());
            self
        }
        /// <p>The ID of the source backup. Specifies the backup you are copying.</p>
        pub fn set_source_backup_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_backup_id = input;
            self
        }
        /// <p>The source Region of the backup. Specifies the Region from where this backup
        /// is copied.</p>
        pub fn source_backup_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_backup_region = Some(input.into());
            self
        }
        /// <p>The source Region of the backup. Specifies the Region from where this backup
        /// is copied.</p>
        pub fn set_source_backup_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_backup_region = input;
            self
        }
        /// <p>Specifies the resource type that is backed up.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>Specifies the resource type that is backed up.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>Describes an Amazon FSx for NetApp ONTAP volume.</p>
        pub fn volume(mut self, input: crate::model::Volume) -> Self {
            self.volume = Some(input);
            self
        }
        /// <p>Describes an Amazon FSx for NetApp ONTAP volume.</p>
        pub fn set_volume(mut self, input: std::option::Option<crate::model::Volume>) -> Self {
            self.volume = input;
            self
        }
        /// Consumes the builder and constructs a [`Backup`](crate::model::Backup)
        pub fn build(self) -> crate::model::Backup {
            crate::model::Backup {
                backup_id: self.backup_id,
                lifecycle: self.lifecycle,
                failure_details: self.failure_details,
                r#type: self.r#type,
                progress_percent: self.progress_percent,
                creation_time: self.creation_time,
                kms_key_id: self.kms_key_id,
                resource_arn: self.resource_arn,
                tags: self.tags,
                file_system: self.file_system,
                directory_information: self.directory_information,
                owner_id: self.owner_id,
                source_backup_id: self.source_backup_id,
                source_backup_region: self.source_backup_region,
                resource_type: self.resource_type,
                volume: self.volume,
            }
        }
    }
}
impl Backup {
    /// Creates a new builder-style object to manufacture [`Backup`](crate::model::Backup)
    pub fn builder() -> crate::model::backup::Builder {
        crate::model::backup::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceType {
    #[allow(missing_docs)] // documentation missing in model
    FileSystem,
    #[allow(missing_docs)] // documentation missing in model
    Volume,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceType {
    fn from(s: &str) -> Self {
        match s {
            "FILE_SYSTEM" => ResourceType::FileSystem,
            "VOLUME" => ResourceType::Volume,
            other => ResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceType::from(s))
    }
}
impl ResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceType::FileSystem => "FILE_SYSTEM",
            ResourceType::Volume => "VOLUME",
            ResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FILE_SYSTEM", "VOLUME"]
    }
}
impl AsRef<str> for ResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The Microsoft AD attributes of the Amazon FSx for Windows File Server file system.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActiveDirectoryBackupAttributes {
    /// <p>The fully qualified domain name of the self-managed AD directory.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Web Services Managed Microsoft Active Directory instance to which the file system is joined.</p>
    pub active_directory_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services
    /// resources. We require an ARN when you need to specify a resource unambiguously across
    /// all of Amazon Web Services. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
    /// the <i>Amazon Web Services General Reference</i>.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ActiveDirectoryBackupAttributes {
    /// <p>The fully qualified domain name of the self-managed AD directory.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The ID of the Amazon Web Services Managed Microsoft Active Directory instance to which the file system is joined.</p>
    pub fn active_directory_id(&self) -> std::option::Option<&str> {
        self.active_directory_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services
    /// resources. We require an ARN when you need to specify a resource unambiguously across
    /// all of Amazon Web Services. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
    /// the <i>Amazon Web Services General Reference</i>.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ActiveDirectoryBackupAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActiveDirectoryBackupAttributes");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("active_directory_id", &self.active_directory_id);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}
/// See [`ActiveDirectoryBackupAttributes`](crate::model::ActiveDirectoryBackupAttributes)
pub mod active_directory_backup_attributes {
    /// A builder for [`ActiveDirectoryBackupAttributes`](crate::model::ActiveDirectoryBackupAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) active_directory_id: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The fully qualified domain name of the self-managed AD directory.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The fully qualified domain name of the self-managed AD directory.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The ID of the Amazon Web Services Managed Microsoft Active Directory instance to which the file system is joined.</p>
        pub fn active_directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.active_directory_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services Managed Microsoft Active Directory instance to which the file system is joined.</p>
        pub fn set_active_directory_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.active_directory_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services
        /// resources. We require an ARN when you need to specify a resource unambiguously across
        /// all of Amazon Web Services. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
        /// the <i>Amazon Web Services General Reference</i>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services
        /// resources. We require an ARN when you need to specify a resource unambiguously across
        /// all of Amazon Web Services. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
        /// the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ActiveDirectoryBackupAttributes`](crate::model::ActiveDirectoryBackupAttributes)
        pub fn build(self) -> crate::model::ActiveDirectoryBackupAttributes {
            crate::model::ActiveDirectoryBackupAttributes {
                domain_name: self.domain_name,
                active_directory_id: self.active_directory_id,
                resource_arn: self.resource_arn,
            }
        }
    }
}
impl ActiveDirectoryBackupAttributes {
    /// Creates a new builder-style object to manufacture [`ActiveDirectoryBackupAttributes`](crate::model::ActiveDirectoryBackupAttributes)
    pub fn builder() -> crate::model::active_directory_backup_attributes::Builder {
        crate::model::active_directory_backup_attributes::Builder::default()
    }
}

/// <p>The type of the backup.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BackupType {
    #[allow(missing_docs)] // documentation missing in model
    Automatic,
    #[allow(missing_docs)] // documentation missing in model
    AwsBackup,
    #[allow(missing_docs)] // documentation missing in model
    UserInitiated,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BackupType {
    fn from(s: &str) -> Self {
        match s {
            "AUTOMATIC" => BackupType::Automatic,
            "AWS_BACKUP" => BackupType::AwsBackup,
            "USER_INITIATED" => BackupType::UserInitiated,
            other => BackupType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BackupType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BackupType::from(s))
    }
}
impl BackupType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BackupType::Automatic => "AUTOMATIC",
            BackupType::AwsBackup => "AWS_BACKUP",
            BackupType::UserInitiated => "USER_INITIATED",
            BackupType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTOMATIC", "AWS_BACKUP", "USER_INITIATED"]
    }
}
impl AsRef<str> for BackupType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>If backup creation fails, this structure contains the details of that
/// failure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackupFailureDetails {
    /// <p>A message describing the backup creation failure.</p>
    pub message: std::option::Option<std::string::String>,
}
impl BackupFailureDetails {
    /// <p>A message describing the backup creation failure.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for BackupFailureDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackupFailureDetails");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`BackupFailureDetails`](crate::model::BackupFailureDetails)
pub mod backup_failure_details {
    /// A builder for [`BackupFailureDetails`](crate::model::BackupFailureDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the backup creation failure.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the backup creation failure.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BackupFailureDetails`](crate::model::BackupFailureDetails)
        pub fn build(self) -> crate::model::BackupFailureDetails {
            crate::model::BackupFailureDetails {
                message: self.message,
            }
        }
    }
}
impl BackupFailureDetails {
    /// Creates a new builder-style object to manufacture [`BackupFailureDetails`](crate::model::BackupFailureDetails)
    pub fn builder() -> crate::model::backup_failure_details::Builder {
        crate::model::backup_failure_details::Builder::default()
    }
}

/// <p>The lifecycle status of the backup.</p>
/// <ul>
/// <li>
/// <p>
/// <code>AVAILABLE</code> - The backup is fully available.</p>
/// </li>
/// <li>
/// <p>
/// <code>PENDING</code> - For user-initiated backups on Lustre file systems only; Amazon FSx has not started creating the backup.</p>
/// </li>
/// <li>
/// <p>
/// <code>CREATING</code> - Amazon FSx is creating the new user-intiated backup</p>
/// </li>
/// <li>
/// <p>
/// <code>TRANSFERRING</code> - For user-initiated backups on Lustre file systems only; Amazon FSx is backing up the file system.</p>
/// </li>
/// <li>
/// <p>
/// <code>COPYING</code> - Amazon FSx is copying the backup.</p>
/// </li>
/// <li>
/// <p>
/// <code>DELETED</code> - Amazon FSx deleted the backup and it is no longer available.</p>
/// </li>
/// <li>
/// <p>
/// <code>FAILED</code> - Amazon FSx could not complete the backup.</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BackupLifecycle {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Copying,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Transferring,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BackupLifecycle {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => BackupLifecycle::Available,
            "COPYING" => BackupLifecycle::Copying,
            "CREATING" => BackupLifecycle::Creating,
            "DELETED" => BackupLifecycle::Deleted,
            "FAILED" => BackupLifecycle::Failed,
            "PENDING" => BackupLifecycle::Pending,
            "TRANSFERRING" => BackupLifecycle::Transferring,
            other => BackupLifecycle::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BackupLifecycle {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BackupLifecycle::from(s))
    }
}
impl BackupLifecycle {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BackupLifecycle::Available => "AVAILABLE",
            BackupLifecycle::Copying => "COPYING",
            BackupLifecycle::Creating => "CREATING",
            BackupLifecycle::Deleted => "DELETED",
            BackupLifecycle::Failed => "FAILED",
            BackupLifecycle::Pending => "PENDING",
            BackupLifecycle::Transferring => "TRANSFERRING",
            BackupLifecycle::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AVAILABLE",
            "COPYING",
            "CREATING",
            "DELETED",
            "FAILED",
            "PENDING",
            "TRANSFERRING",
        ]
    }
}
impl AsRef<str> for BackupLifecycle {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A filter used to restrict the results of describe calls. You can use multiple
/// filters to return results that meet all applied filter requirements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Filter {
    /// <p>The name for this filter.</p>
    pub name: std::option::Option<crate::model::FilterName>,
    /// <p>The values of the filter. These are all the values for any of the applied
    /// filters.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Filter {
    /// <p>The name for this filter.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::FilterName> {
        self.name.as_ref()
    }
    /// <p>The values of the filter. These are all the values for any of the applied
    /// filters.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for Filter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Filter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`Filter`](crate::model::Filter)
pub mod filter {
    /// A builder for [`Filter`](crate::model::Filter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::FilterName>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name for this filter.</p>
        pub fn name(mut self, input: crate::model::FilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name for this filter.</p>
        pub fn set_name(mut self, input: std::option::Option<crate::model::FilterName>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The values of the filter. These are all the values for any of the applied
        /// filters.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The values of the filter. These are all the values for any of the applied
        /// filters.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`Filter`](crate::model::Filter)
        pub fn build(self) -> crate::model::Filter {
            crate::model::Filter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl Filter {
    /// Creates a new builder-style object to manufacture [`Filter`](crate::model::Filter)
    pub fn builder() -> crate::model::filter::Builder {
        crate::model::filter::Builder::default()
    }
}

/// <p>The name for a filter.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FilterName {
    #[allow(missing_docs)] // documentation missing in model
    BackupType,
    #[allow(missing_docs)] // documentation missing in model
    FileSystemId,
    #[allow(missing_docs)] // documentation missing in model
    FileSystemType,
    #[allow(missing_docs)] // documentation missing in model
    VolumeId,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FilterName {
    fn from(s: &str) -> Self {
        match s {
            "backup-type" => FilterName::BackupType,
            "file-system-id" => FilterName::FileSystemId,
            "file-system-type" => FilterName::FileSystemType,
            "volume-id" => FilterName::VolumeId,
            other => FilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FilterName::from(s))
    }
}
impl FilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FilterName::BackupType => "backup-type",
            FilterName::FileSystemId => "file-system-id",
            FilterName::FileSystemType => "file-system-type",
            FilterName::VolumeId => "volume-id",
            FilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "backup-type",
            "file-system-id",
            "file-system-type",
            "volume-id",
        ]
    }
}
impl AsRef<str> for FilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The response object for the Amazon FSx for NetApp ONTAP volume being deleted
/// in the <code>DeleteVolume</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVolumeOntapResponse {
    /// <p>The ID of the source backup. Specifies the backup you are copying.</p>
    pub final_backup_id: std::option::Option<std::string::String>,
    /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
    pub final_backup_tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl DeleteVolumeOntapResponse {
    /// <p>The ID of the source backup. Specifies the backup you are copying.</p>
    pub fn final_backup_id(&self) -> std::option::Option<&str> {
        self.final_backup_id.as_deref()
    }
    /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
    pub fn final_backup_tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.final_backup_tags.as_deref()
    }
}
impl std::fmt::Debug for DeleteVolumeOntapResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVolumeOntapResponse");
        formatter.field("final_backup_id", &self.final_backup_id);
        formatter.field("final_backup_tags", &self.final_backup_tags);
        formatter.finish()
    }
}
/// See [`DeleteVolumeOntapResponse`](crate::model::DeleteVolumeOntapResponse)
pub mod delete_volume_ontap_response {
    /// A builder for [`DeleteVolumeOntapResponse`](crate::model::DeleteVolumeOntapResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) final_backup_id: std::option::Option<std::string::String>,
        pub(crate) final_backup_tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the source backup. Specifies the backup you are copying.</p>
        pub fn final_backup_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.final_backup_id = Some(input.into());
            self
        }
        /// <p>The ID of the source backup. Specifies the backup you are copying.</p>
        pub fn set_final_backup_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.final_backup_id = input;
            self
        }
        /// Appends an item to `final_backup_tags`.
        ///
        /// To override the contents of this collection use [`set_final_backup_tags`](Self::set_final_backup_tags).
        ///
        /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
        pub fn final_backup_tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.final_backup_tags.unwrap_or_default();
            v.push(input.into());
            self.final_backup_tags = Some(v);
            self
        }
        /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
        pub fn set_final_backup_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.final_backup_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVolumeOntapResponse`](crate::model::DeleteVolumeOntapResponse)
        pub fn build(self) -> crate::model::DeleteVolumeOntapResponse {
            crate::model::DeleteVolumeOntapResponse {
                final_backup_id: self.final_backup_id,
                final_backup_tags: self.final_backup_tags,
            }
        }
    }
}
impl DeleteVolumeOntapResponse {
    /// Creates a new builder-style object to manufacture [`DeleteVolumeOntapResponse`](crate::model::DeleteVolumeOntapResponse)
    pub fn builder() -> crate::model::delete_volume_ontap_response::Builder {
        crate::model::delete_volume_ontap_response::Builder::default()
    }
}

/// <p>Use to specify skipping a final backup, or to add tags to a final backup.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVolumeOntapConfiguration {
    /// <p>Set to true if you want to skip taking a final backup of the volume
    /// you are deleting.</p>
    pub skip_final_backup: std::option::Option<bool>,
    /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
    pub final_backup_tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl DeleteVolumeOntapConfiguration {
    /// <p>Set to true if you want to skip taking a final backup of the volume
    /// you are deleting.</p>
    pub fn skip_final_backup(&self) -> std::option::Option<bool> {
        self.skip_final_backup
    }
    /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
    pub fn final_backup_tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.final_backup_tags.as_deref()
    }
}
impl std::fmt::Debug for DeleteVolumeOntapConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVolumeOntapConfiguration");
        formatter.field("skip_final_backup", &self.skip_final_backup);
        formatter.field("final_backup_tags", &self.final_backup_tags);
        formatter.finish()
    }
}
/// See [`DeleteVolumeOntapConfiguration`](crate::model::DeleteVolumeOntapConfiguration)
pub mod delete_volume_ontap_configuration {
    /// A builder for [`DeleteVolumeOntapConfiguration`](crate::model::DeleteVolumeOntapConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) skip_final_backup: std::option::Option<bool>,
        pub(crate) final_backup_tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Set to true if you want to skip taking a final backup of the volume
        /// you are deleting.</p>
        pub fn skip_final_backup(mut self, input: bool) -> Self {
            self.skip_final_backup = Some(input);
            self
        }
        /// <p>Set to true if you want to skip taking a final backup of the volume
        /// you are deleting.</p>
        pub fn set_skip_final_backup(mut self, input: std::option::Option<bool>) -> Self {
            self.skip_final_backup = input;
            self
        }
        /// Appends an item to `final_backup_tags`.
        ///
        /// To override the contents of this collection use [`set_final_backup_tags`](Self::set_final_backup_tags).
        ///
        /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
        pub fn final_backup_tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.final_backup_tags.unwrap_or_default();
            v.push(input.into());
            self.final_backup_tags = Some(v);
            self
        }
        /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
        pub fn set_final_backup_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.final_backup_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVolumeOntapConfiguration`](crate::model::DeleteVolumeOntapConfiguration)
        pub fn build(self) -> crate::model::DeleteVolumeOntapConfiguration {
            crate::model::DeleteVolumeOntapConfiguration {
                skip_final_backup: self.skip_final_backup,
                final_backup_tags: self.final_backup_tags,
            }
        }
    }
}
impl DeleteVolumeOntapConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteVolumeOntapConfiguration`](crate::model::DeleteVolumeOntapConfiguration)
    pub fn builder() -> crate::model::delete_volume_ontap_configuration::Builder {
        crate::model::delete_volume_ontap_configuration::Builder::default()
    }
}

/// <p>The response object for the Amazon FSx for Lustre file system being deleted in the
/// <code>DeleteFileSystem</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFileSystemLustreResponse {
    /// <p>The ID of the final backup for this file system.</p>
    pub final_backup_id: std::option::Option<std::string::String>,
    /// <p>The set of tags applied to the final backup.</p>
    pub final_backup_tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl DeleteFileSystemLustreResponse {
    /// <p>The ID of the final backup for this file system.</p>
    pub fn final_backup_id(&self) -> std::option::Option<&str> {
        self.final_backup_id.as_deref()
    }
    /// <p>The set of tags applied to the final backup.</p>
    pub fn final_backup_tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.final_backup_tags.as_deref()
    }
}
impl std::fmt::Debug for DeleteFileSystemLustreResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFileSystemLustreResponse");
        formatter.field("final_backup_id", &self.final_backup_id);
        formatter.field("final_backup_tags", &self.final_backup_tags);
        formatter.finish()
    }
}
/// See [`DeleteFileSystemLustreResponse`](crate::model::DeleteFileSystemLustreResponse)
pub mod delete_file_system_lustre_response {
    /// A builder for [`DeleteFileSystemLustreResponse`](crate::model::DeleteFileSystemLustreResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) final_backup_id: std::option::Option<std::string::String>,
        pub(crate) final_backup_tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the final backup for this file system.</p>
        pub fn final_backup_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.final_backup_id = Some(input.into());
            self
        }
        /// <p>The ID of the final backup for this file system.</p>
        pub fn set_final_backup_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.final_backup_id = input;
            self
        }
        /// Appends an item to `final_backup_tags`.
        ///
        /// To override the contents of this collection use [`set_final_backup_tags`](Self::set_final_backup_tags).
        ///
        /// <p>The set of tags applied to the final backup.</p>
        pub fn final_backup_tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.final_backup_tags.unwrap_or_default();
            v.push(input.into());
            self.final_backup_tags = Some(v);
            self
        }
        /// <p>The set of tags applied to the final backup.</p>
        pub fn set_final_backup_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.final_backup_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFileSystemLustreResponse`](crate::model::DeleteFileSystemLustreResponse)
        pub fn build(self) -> crate::model::DeleteFileSystemLustreResponse {
            crate::model::DeleteFileSystemLustreResponse {
                final_backup_id: self.final_backup_id,
                final_backup_tags: self.final_backup_tags,
            }
        }
    }
}
impl DeleteFileSystemLustreResponse {
    /// Creates a new builder-style object to manufacture [`DeleteFileSystemLustreResponse`](crate::model::DeleteFileSystemLustreResponse)
    pub fn builder() -> crate::model::delete_file_system_lustre_response::Builder {
        crate::model::delete_file_system_lustre_response::Builder::default()
    }
}

/// <p>The response object for the Microsoft Windows file system used in the
/// <code>DeleteFileSystem</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFileSystemWindowsResponse {
    /// <p>The ID of the final backup for this file system.</p>
    pub final_backup_id: std::option::Option<std::string::String>,
    /// <p>The set of tags applied to the final backup.</p>
    pub final_backup_tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl DeleteFileSystemWindowsResponse {
    /// <p>The ID of the final backup for this file system.</p>
    pub fn final_backup_id(&self) -> std::option::Option<&str> {
        self.final_backup_id.as_deref()
    }
    /// <p>The set of tags applied to the final backup.</p>
    pub fn final_backup_tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.final_backup_tags.as_deref()
    }
}
impl std::fmt::Debug for DeleteFileSystemWindowsResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFileSystemWindowsResponse");
        formatter.field("final_backup_id", &self.final_backup_id);
        formatter.field("final_backup_tags", &self.final_backup_tags);
        formatter.finish()
    }
}
/// See [`DeleteFileSystemWindowsResponse`](crate::model::DeleteFileSystemWindowsResponse)
pub mod delete_file_system_windows_response {
    /// A builder for [`DeleteFileSystemWindowsResponse`](crate::model::DeleteFileSystemWindowsResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) final_backup_id: std::option::Option<std::string::String>,
        pub(crate) final_backup_tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the final backup for this file system.</p>
        pub fn final_backup_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.final_backup_id = Some(input.into());
            self
        }
        /// <p>The ID of the final backup for this file system.</p>
        pub fn set_final_backup_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.final_backup_id = input;
            self
        }
        /// Appends an item to `final_backup_tags`.
        ///
        /// To override the contents of this collection use [`set_final_backup_tags`](Self::set_final_backup_tags).
        ///
        /// <p>The set of tags applied to the final backup.</p>
        pub fn final_backup_tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.final_backup_tags.unwrap_or_default();
            v.push(input.into());
            self.final_backup_tags = Some(v);
            self
        }
        /// <p>The set of tags applied to the final backup.</p>
        pub fn set_final_backup_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.final_backup_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFileSystemWindowsResponse`](crate::model::DeleteFileSystemWindowsResponse)
        pub fn build(self) -> crate::model::DeleteFileSystemWindowsResponse {
            crate::model::DeleteFileSystemWindowsResponse {
                final_backup_id: self.final_backup_id,
                final_backup_tags: self.final_backup_tags,
            }
        }
    }
}
impl DeleteFileSystemWindowsResponse {
    /// Creates a new builder-style object to manufacture [`DeleteFileSystemWindowsResponse`](crate::model::DeleteFileSystemWindowsResponse)
    pub fn builder() -> crate::model::delete_file_system_windows_response::Builder {
        crate::model::delete_file_system_windows_response::Builder::default()
    }
}

/// <p>The configuration object for the Amazon FSx for Lustre file system being deleted in the
/// <code>DeleteFileSystem</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFileSystemLustreConfiguration {
    /// <p>Set <code>SkipFinalBackup</code> to false if you want to take a final backup of the file
    /// system you are deleting. By default, Amazon FSx will not take a final backup on your behalf when the
    /// <code>DeleteFileSystem</code> operation is invoked. (Default = true)</p>
    pub skip_final_backup: std::option::Option<bool>,
    /// <p>Use if <code>SkipFinalBackup</code> is set to <code>false</code>,
    /// and you want to apply an array of tags to the final backup. If you have set the file system property
    /// <code>CopyTagsToBackups</code> to true, and
    /// you specify one or more <code>FinalBackupTags</code> when deleting a file system, Amazon FSx will not copy any existing file system tags to the backup.</p>
    pub final_backup_tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl DeleteFileSystemLustreConfiguration {
    /// <p>Set <code>SkipFinalBackup</code> to false if you want to take a final backup of the file
    /// system you are deleting. By default, Amazon FSx will not take a final backup on your behalf when the
    /// <code>DeleteFileSystem</code> operation is invoked. (Default = true)</p>
    pub fn skip_final_backup(&self) -> std::option::Option<bool> {
        self.skip_final_backup
    }
    /// <p>Use if <code>SkipFinalBackup</code> is set to <code>false</code>,
    /// and you want to apply an array of tags to the final backup. If you have set the file system property
    /// <code>CopyTagsToBackups</code> to true, and
    /// you specify one or more <code>FinalBackupTags</code> when deleting a file system, Amazon FSx will not copy any existing file system tags to the backup.</p>
    pub fn final_backup_tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.final_backup_tags.as_deref()
    }
}
impl std::fmt::Debug for DeleteFileSystemLustreConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFileSystemLustreConfiguration");
        formatter.field("skip_final_backup", &self.skip_final_backup);
        formatter.field("final_backup_tags", &self.final_backup_tags);
        formatter.finish()
    }
}
/// See [`DeleteFileSystemLustreConfiguration`](crate::model::DeleteFileSystemLustreConfiguration)
pub mod delete_file_system_lustre_configuration {
    /// A builder for [`DeleteFileSystemLustreConfiguration`](crate::model::DeleteFileSystemLustreConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) skip_final_backup: std::option::Option<bool>,
        pub(crate) final_backup_tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Set <code>SkipFinalBackup</code> to false if you want to take a final backup of the file
        /// system you are deleting. By default, Amazon FSx will not take a final backup on your behalf when the
        /// <code>DeleteFileSystem</code> operation is invoked. (Default = true)</p>
        pub fn skip_final_backup(mut self, input: bool) -> Self {
            self.skip_final_backup = Some(input);
            self
        }
        /// <p>Set <code>SkipFinalBackup</code> to false if you want to take a final backup of the file
        /// system you are deleting. By default, Amazon FSx will not take a final backup on your behalf when the
        /// <code>DeleteFileSystem</code> operation is invoked. (Default = true)</p>
        pub fn set_skip_final_backup(mut self, input: std::option::Option<bool>) -> Self {
            self.skip_final_backup = input;
            self
        }
        /// Appends an item to `final_backup_tags`.
        ///
        /// To override the contents of this collection use [`set_final_backup_tags`](Self::set_final_backup_tags).
        ///
        /// <p>Use if <code>SkipFinalBackup</code> is set to <code>false</code>,
        /// and you want to apply an array of tags to the final backup. If you have set the file system property
        /// <code>CopyTagsToBackups</code> to true, and
        /// you specify one or more <code>FinalBackupTags</code> when deleting a file system, Amazon FSx will not copy any existing file system tags to the backup.</p>
        pub fn final_backup_tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.final_backup_tags.unwrap_or_default();
            v.push(input.into());
            self.final_backup_tags = Some(v);
            self
        }
        /// <p>Use if <code>SkipFinalBackup</code> is set to <code>false</code>,
        /// and you want to apply an array of tags to the final backup. If you have set the file system property
        /// <code>CopyTagsToBackups</code> to true, and
        /// you specify one or more <code>FinalBackupTags</code> when deleting a file system, Amazon FSx will not copy any existing file system tags to the backup.</p>
        pub fn set_final_backup_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.final_backup_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFileSystemLustreConfiguration`](crate::model::DeleteFileSystemLustreConfiguration)
        pub fn build(self) -> crate::model::DeleteFileSystemLustreConfiguration {
            crate::model::DeleteFileSystemLustreConfiguration {
                skip_final_backup: self.skip_final_backup,
                final_backup_tags: self.final_backup_tags,
            }
        }
    }
}
impl DeleteFileSystemLustreConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteFileSystemLustreConfiguration`](crate::model::DeleteFileSystemLustreConfiguration)
    pub fn builder() -> crate::model::delete_file_system_lustre_configuration::Builder {
        crate::model::delete_file_system_lustre_configuration::Builder::default()
    }
}

/// <p>The configuration object for the Microsoft Windows file system used in the
/// <code>DeleteFileSystem</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFileSystemWindowsConfiguration {
    /// <p>By default, Amazon FSx for Windows takes a final backup on your behalf when the
    /// <code>DeleteFileSystem</code> operation is invoked. Doing this helps protect you
    /// from data loss, and we highly recommend taking the final backup. If you want to skip
    /// this backup, use this flag to do so.</p>
    pub skip_final_backup: std::option::Option<bool>,
    /// <p>A set of tags for your final backup.</p>
    pub final_backup_tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl DeleteFileSystemWindowsConfiguration {
    /// <p>By default, Amazon FSx for Windows takes a final backup on your behalf when the
    /// <code>DeleteFileSystem</code> operation is invoked. Doing this helps protect you
    /// from data loss, and we highly recommend taking the final backup. If you want to skip
    /// this backup, use this flag to do so.</p>
    pub fn skip_final_backup(&self) -> std::option::Option<bool> {
        self.skip_final_backup
    }
    /// <p>A set of tags for your final backup.</p>
    pub fn final_backup_tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.final_backup_tags.as_deref()
    }
}
impl std::fmt::Debug for DeleteFileSystemWindowsConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFileSystemWindowsConfiguration");
        formatter.field("skip_final_backup", &self.skip_final_backup);
        formatter.field("final_backup_tags", &self.final_backup_tags);
        formatter.finish()
    }
}
/// See [`DeleteFileSystemWindowsConfiguration`](crate::model::DeleteFileSystemWindowsConfiguration)
pub mod delete_file_system_windows_configuration {
    /// A builder for [`DeleteFileSystemWindowsConfiguration`](crate::model::DeleteFileSystemWindowsConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) skip_final_backup: std::option::Option<bool>,
        pub(crate) final_backup_tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>By default, Amazon FSx for Windows takes a final backup on your behalf when the
        /// <code>DeleteFileSystem</code> operation is invoked. Doing this helps protect you
        /// from data loss, and we highly recommend taking the final backup. If you want to skip
        /// this backup, use this flag to do so.</p>
        pub fn skip_final_backup(mut self, input: bool) -> Self {
            self.skip_final_backup = Some(input);
            self
        }
        /// <p>By default, Amazon FSx for Windows takes a final backup on your behalf when the
        /// <code>DeleteFileSystem</code> operation is invoked. Doing this helps protect you
        /// from data loss, and we highly recommend taking the final backup. If you want to skip
        /// this backup, use this flag to do so.</p>
        pub fn set_skip_final_backup(mut self, input: std::option::Option<bool>) -> Self {
            self.skip_final_backup = input;
            self
        }
        /// Appends an item to `final_backup_tags`.
        ///
        /// To override the contents of this collection use [`set_final_backup_tags`](Self::set_final_backup_tags).
        ///
        /// <p>A set of tags for your final backup.</p>
        pub fn final_backup_tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.final_backup_tags.unwrap_or_default();
            v.push(input.into());
            self.final_backup_tags = Some(v);
            self
        }
        /// <p>A set of tags for your final backup.</p>
        pub fn set_final_backup_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.final_backup_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFileSystemWindowsConfiguration`](crate::model::DeleteFileSystemWindowsConfiguration)
        pub fn build(self) -> crate::model::DeleteFileSystemWindowsConfiguration {
            crate::model::DeleteFileSystemWindowsConfiguration {
                skip_final_backup: self.skip_final_backup,
                final_backup_tags: self.final_backup_tags,
            }
        }
    }
}
impl DeleteFileSystemWindowsConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteFileSystemWindowsConfiguration`](crate::model::DeleteFileSystemWindowsConfiguration)
    pub fn builder() -> crate::model::delete_file_system_windows_configuration::Builder {
        crate::model::delete_file_system_windows_configuration::Builder::default()
    }
}

/// <p>Specifies the configuration of the ONTAP volume that you are creating.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateOntapVolumeConfiguration {
    /// <p>Specifies the location in the SVM's namespace where the volume is mounted.
    /// The <code>JunctionPath</code> must have a leading forward slash, such as <code>/vol3</code>.</p>
    pub junction_path: std::option::Option<std::string::String>,
    /// <p>The security style for the volume. Specify one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>UNIX</code> if the file system is managed by a UNIX
    /// administrator, the majority of users are NFS clients, and an application
    /// accessing the data uses a UNIX user as the service account.
    /// <code>UNIX</code> is the default.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NTFS</code> if the file system is managed by a Windows
    /// administrator, the majority of users are SMB clients, and an application
    /// accessing the data uses a Windows user as the service account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MIXED</code> if the file system is managed by both UNIX
    /// and Windows administrators and users consist of both NFS and SMB clients.</p>
    /// </li>
    /// </ul>
    pub security_style: std::option::Option<crate::model::SecurityStyle>,
    /// <p>Specifies the size of the volume, in megabytes (MB), that you are creating.</p>
    pub size_in_megabytes: std::option::Option<i32>,
    /// <p>Set to true to enable deduplication, compression, and
    /// compaction storage efficiency features on the volume.</p>
    pub storage_efficiency_enabled: std::option::Option<bool>,
    /// <p>Specifies the ONTAP SVM in which to create the volume.</p>
    pub storage_virtual_machine_id: std::option::Option<std::string::String>,
    /// <p>Describes the data tiering policy for an ONTAP volume. When enabled, Amazon FSx for ONTAP's intelligent
    /// tiering automatically transitions a volume's data between the file system's primary storage and capacity
    /// pool storage based on your access patterns.</p>
    pub tiering_policy: std::option::Option<crate::model::TieringPolicy>,
}
impl CreateOntapVolumeConfiguration {
    /// <p>Specifies the location in the SVM's namespace where the volume is mounted.
    /// The <code>JunctionPath</code> must have a leading forward slash, such as <code>/vol3</code>.</p>
    pub fn junction_path(&self) -> std::option::Option<&str> {
        self.junction_path.as_deref()
    }
    /// <p>The security style for the volume. Specify one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>UNIX</code> if the file system is managed by a UNIX
    /// administrator, the majority of users are NFS clients, and an application
    /// accessing the data uses a UNIX user as the service account.
    /// <code>UNIX</code> is the default.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NTFS</code> if the file system is managed by a Windows
    /// administrator, the majority of users are SMB clients, and an application
    /// accessing the data uses a Windows user as the service account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MIXED</code> if the file system is managed by both UNIX
    /// and Windows administrators and users consist of both NFS and SMB clients.</p>
    /// </li>
    /// </ul>
    pub fn security_style(&self) -> std::option::Option<&crate::model::SecurityStyle> {
        self.security_style.as_ref()
    }
    /// <p>Specifies the size of the volume, in megabytes (MB), that you are creating.</p>
    pub fn size_in_megabytes(&self) -> std::option::Option<i32> {
        self.size_in_megabytes
    }
    /// <p>Set to true to enable deduplication, compression, and
    /// compaction storage efficiency features on the volume.</p>
    pub fn storage_efficiency_enabled(&self) -> std::option::Option<bool> {
        self.storage_efficiency_enabled
    }
    /// <p>Specifies the ONTAP SVM in which to create the volume.</p>
    pub fn storage_virtual_machine_id(&self) -> std::option::Option<&str> {
        self.storage_virtual_machine_id.as_deref()
    }
    /// <p>Describes the data tiering policy for an ONTAP volume. When enabled, Amazon FSx for ONTAP's intelligent
    /// tiering automatically transitions a volume's data between the file system's primary storage and capacity
    /// pool storage based on your access patterns.</p>
    pub fn tiering_policy(&self) -> std::option::Option<&crate::model::TieringPolicy> {
        self.tiering_policy.as_ref()
    }
}
impl std::fmt::Debug for CreateOntapVolumeConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateOntapVolumeConfiguration");
        formatter.field("junction_path", &self.junction_path);
        formatter.field("security_style", &self.security_style);
        formatter.field("size_in_megabytes", &self.size_in_megabytes);
        formatter.field(
            "storage_efficiency_enabled",
            &self.storage_efficiency_enabled,
        );
        formatter.field(
            "storage_virtual_machine_id",
            &self.storage_virtual_machine_id,
        );
        formatter.field("tiering_policy", &self.tiering_policy);
        formatter.finish()
    }
}
/// See [`CreateOntapVolumeConfiguration`](crate::model::CreateOntapVolumeConfiguration)
pub mod create_ontap_volume_configuration {
    /// A builder for [`CreateOntapVolumeConfiguration`](crate::model::CreateOntapVolumeConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) junction_path: std::option::Option<std::string::String>,
        pub(crate) security_style: std::option::Option<crate::model::SecurityStyle>,
        pub(crate) size_in_megabytes: std::option::Option<i32>,
        pub(crate) storage_efficiency_enabled: std::option::Option<bool>,
        pub(crate) storage_virtual_machine_id: std::option::Option<std::string::String>,
        pub(crate) tiering_policy: std::option::Option<crate::model::TieringPolicy>,
    }
    impl Builder {
        /// <p>Specifies the location in the SVM's namespace where the volume is mounted.
        /// The <code>JunctionPath</code> must have a leading forward slash, such as <code>/vol3</code>.</p>
        pub fn junction_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.junction_path = Some(input.into());
            self
        }
        /// <p>Specifies the location in the SVM's namespace where the volume is mounted.
        /// The <code>JunctionPath</code> must have a leading forward slash, such as <code>/vol3</code>.</p>
        pub fn set_junction_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.junction_path = input;
            self
        }
        /// <p>The security style for the volume. Specify one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>UNIX</code> if the file system is managed by a UNIX
        /// administrator, the majority of users are NFS clients, and an application
        /// accessing the data uses a UNIX user as the service account.
        /// <code>UNIX</code> is the default.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NTFS</code> if the file system is managed by a Windows
        /// administrator, the majority of users are SMB clients, and an application
        /// accessing the data uses a Windows user as the service account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MIXED</code> if the file system is managed by both UNIX
        /// and Windows administrators and users consist of both NFS and SMB clients.</p>
        /// </li>
        /// </ul>
        pub fn security_style(mut self, input: crate::model::SecurityStyle) -> Self {
            self.security_style = Some(input);
            self
        }
        /// <p>The security style for the volume. Specify one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>UNIX</code> if the file system is managed by a UNIX
        /// administrator, the majority of users are NFS clients, and an application
        /// accessing the data uses a UNIX user as the service account.
        /// <code>UNIX</code> is the default.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NTFS</code> if the file system is managed by a Windows
        /// administrator, the majority of users are SMB clients, and an application
        /// accessing the data uses a Windows user as the service account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MIXED</code> if the file system is managed by both UNIX
        /// and Windows administrators and users consist of both NFS and SMB clients.</p>
        /// </li>
        /// </ul>
        pub fn set_security_style(
            mut self,
            input: std::option::Option<crate::model::SecurityStyle>,
        ) -> Self {
            self.security_style = input;
            self
        }
        /// <p>Specifies the size of the volume, in megabytes (MB), that you are creating.</p>
        pub fn size_in_megabytes(mut self, input: i32) -> Self {
            self.size_in_megabytes = Some(input);
            self
        }
        /// <p>Specifies the size of the volume, in megabytes (MB), that you are creating.</p>
        pub fn set_size_in_megabytes(mut self, input: std::option::Option<i32>) -> Self {
            self.size_in_megabytes = input;
            self
        }
        /// <p>Set to true to enable deduplication, compression, and
        /// compaction storage efficiency features on the volume.</p>
        pub fn storage_efficiency_enabled(mut self, input: bool) -> Self {
            self.storage_efficiency_enabled = Some(input);
            self
        }
        /// <p>Set to true to enable deduplication, compression, and
        /// compaction storage efficiency features on the volume.</p>
        pub fn set_storage_efficiency_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.storage_efficiency_enabled = input;
            self
        }
        /// <p>Specifies the ONTAP SVM in which to create the volume.</p>
        pub fn storage_virtual_machine_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.storage_virtual_machine_id = Some(input.into());
            self
        }
        /// <p>Specifies the ONTAP SVM in which to create the volume.</p>
        pub fn set_storage_virtual_machine_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.storage_virtual_machine_id = input;
            self
        }
        /// <p>Describes the data tiering policy for an ONTAP volume. When enabled, Amazon FSx for ONTAP's intelligent
        /// tiering automatically transitions a volume's data between the file system's primary storage and capacity
        /// pool storage based on your access patterns.</p>
        pub fn tiering_policy(mut self, input: crate::model::TieringPolicy) -> Self {
            self.tiering_policy = Some(input);
            self
        }
        /// <p>Describes the data tiering policy for an ONTAP volume. When enabled, Amazon FSx for ONTAP's intelligent
        /// tiering automatically transitions a volume's data between the file system's primary storage and capacity
        /// pool storage based on your access patterns.</p>
        pub fn set_tiering_policy(
            mut self,
            input: std::option::Option<crate::model::TieringPolicy>,
        ) -> Self {
            self.tiering_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateOntapVolumeConfiguration`](crate::model::CreateOntapVolumeConfiguration)
        pub fn build(self) -> crate::model::CreateOntapVolumeConfiguration {
            crate::model::CreateOntapVolumeConfiguration {
                junction_path: self.junction_path,
                security_style: self.security_style,
                size_in_megabytes: self.size_in_megabytes,
                storage_efficiency_enabled: self.storage_efficiency_enabled,
                storage_virtual_machine_id: self.storage_virtual_machine_id,
                tiering_policy: self.tiering_policy,
            }
        }
    }
}
impl CreateOntapVolumeConfiguration {
    /// Creates a new builder-style object to manufacture [`CreateOntapVolumeConfiguration`](crate::model::CreateOntapVolumeConfiguration)
    pub fn builder() -> crate::model::create_ontap_volume_configuration::Builder {
        crate::model::create_ontap_volume_configuration::Builder::default()
    }
}

/// <p>The type of error relating to Microsoft Active Directory. NOT_FOUND means that no
/// directory was found by specifying the given directory. INCOMPATIBLE_MODE means that the
/// directory specified is not a Microsoft AD directory. WRONG_VPC means that the specified
/// directory isn't accessible from the specified VPC. WRONG_STAGE means that the
/// specified directory isn't currently in the ACTIVE state.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ActiveDirectoryErrorType {
    #[allow(missing_docs)] // documentation missing in model
    DomainNotFound,
    #[allow(missing_docs)] // documentation missing in model
    IncompatibleDomainMode,
    #[allow(missing_docs)] // documentation missing in model
    InvalidDomainStage,
    #[allow(missing_docs)] // documentation missing in model
    WrongVpc,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ActiveDirectoryErrorType {
    fn from(s: &str) -> Self {
        match s {
            "DOMAIN_NOT_FOUND" => ActiveDirectoryErrorType::DomainNotFound,
            "INCOMPATIBLE_DOMAIN_MODE" => ActiveDirectoryErrorType::IncompatibleDomainMode,
            "INVALID_DOMAIN_STAGE" => ActiveDirectoryErrorType::InvalidDomainStage,
            "WRONG_VPC" => ActiveDirectoryErrorType::WrongVpc,
            other => ActiveDirectoryErrorType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ActiveDirectoryErrorType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ActiveDirectoryErrorType::from(s))
    }
}
impl ActiveDirectoryErrorType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ActiveDirectoryErrorType::DomainNotFound => "DOMAIN_NOT_FOUND",
            ActiveDirectoryErrorType::IncompatibleDomainMode => "INCOMPATIBLE_DOMAIN_MODE",
            ActiveDirectoryErrorType::InvalidDomainStage => "INVALID_DOMAIN_STAGE",
            ActiveDirectoryErrorType::WrongVpc => "WRONG_VPC",
            ActiveDirectoryErrorType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DOMAIN_NOT_FOUND",
            "INCOMPATIBLE_DOMAIN_MODE",
            "INVALID_DOMAIN_STAGE",
            "WRONG_VPC",
        ]
    }
}
impl AsRef<str> for ActiveDirectoryErrorType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The configuration that Amazon FSx uses to join the ONTAP storage virtual machine
/// (SVM) to your self-managed (including on-premises) Microsoft Active Directory (AD) directory.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSvmActiveDirectoryConfiguration {
    /// <p>The NetBIOS name of the Active Directory computer object that will be created for your SVM.</p>
    pub net_bios_name: std::option::Option<std::string::String>,
    /// <p>The configuration that Amazon FSx uses to join a FSx for Windows File Server file system or an ONTAP storage virtual machine (SVM) to
    /// a self-managed (including on-premises) Microsoft Active Directory (AD)
    /// directory. For more information, see
    /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/self-managed-AD.html">
    /// Using Amazon FSx with your self-managed Microsoft Active Directory</a> or
    /// <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html">Managing SVMs</a>.</p>
    pub self_managed_active_directory_configuration:
        std::option::Option<crate::model::SelfManagedActiveDirectoryConfiguration>,
}
impl CreateSvmActiveDirectoryConfiguration {
    /// <p>The NetBIOS name of the Active Directory computer object that will be created for your SVM.</p>
    pub fn net_bios_name(&self) -> std::option::Option<&str> {
        self.net_bios_name.as_deref()
    }
    /// <p>The configuration that Amazon FSx uses to join a FSx for Windows File Server file system or an ONTAP storage virtual machine (SVM) to
    /// a self-managed (including on-premises) Microsoft Active Directory (AD)
    /// directory. For more information, see
    /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/self-managed-AD.html">
    /// Using Amazon FSx with your self-managed Microsoft Active Directory</a> or
    /// <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html">Managing SVMs</a>.</p>
    pub fn self_managed_active_directory_configuration(
        &self,
    ) -> std::option::Option<&crate::model::SelfManagedActiveDirectoryConfiguration> {
        self.self_managed_active_directory_configuration.as_ref()
    }
}
impl std::fmt::Debug for CreateSvmActiveDirectoryConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSvmActiveDirectoryConfiguration");
        formatter.field("net_bios_name", &self.net_bios_name);
        formatter.field(
            "self_managed_active_directory_configuration",
            &self.self_managed_active_directory_configuration,
        );
        formatter.finish()
    }
}
/// See [`CreateSvmActiveDirectoryConfiguration`](crate::model::CreateSvmActiveDirectoryConfiguration)
pub mod create_svm_active_directory_configuration {
    /// A builder for [`CreateSvmActiveDirectoryConfiguration`](crate::model::CreateSvmActiveDirectoryConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) net_bios_name: std::option::Option<std::string::String>,
        pub(crate) self_managed_active_directory_configuration:
            std::option::Option<crate::model::SelfManagedActiveDirectoryConfiguration>,
    }
    impl Builder {
        /// <p>The NetBIOS name of the Active Directory computer object that will be created for your SVM.</p>
        pub fn net_bios_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.net_bios_name = Some(input.into());
            self
        }
        /// <p>The NetBIOS name of the Active Directory computer object that will be created for your SVM.</p>
        pub fn set_net_bios_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.net_bios_name = input;
            self
        }
        /// <p>The configuration that Amazon FSx uses to join a FSx for Windows File Server file system or an ONTAP storage virtual machine (SVM) to
        /// a self-managed (including on-premises) Microsoft Active Directory (AD)
        /// directory. For more information, see
        /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/self-managed-AD.html">
        /// Using Amazon FSx with your self-managed Microsoft Active Directory</a> or
        /// <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html">Managing SVMs</a>.</p>
        pub fn self_managed_active_directory_configuration(
            mut self,
            input: crate::model::SelfManagedActiveDirectoryConfiguration,
        ) -> Self {
            self.self_managed_active_directory_configuration = Some(input);
            self
        }
        /// <p>The configuration that Amazon FSx uses to join a FSx for Windows File Server file system or an ONTAP storage virtual machine (SVM) to
        /// a self-managed (including on-premises) Microsoft Active Directory (AD)
        /// directory. For more information, see
        /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/self-managed-AD.html">
        /// Using Amazon FSx with your self-managed Microsoft Active Directory</a> or
        /// <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html">Managing SVMs</a>.</p>
        pub fn set_self_managed_active_directory_configuration(
            mut self,
            input: std::option::Option<crate::model::SelfManagedActiveDirectoryConfiguration>,
        ) -> Self {
            self.self_managed_active_directory_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSvmActiveDirectoryConfiguration`](crate::model::CreateSvmActiveDirectoryConfiguration)
        pub fn build(self) -> crate::model::CreateSvmActiveDirectoryConfiguration {
            crate::model::CreateSvmActiveDirectoryConfiguration {
                net_bios_name: self.net_bios_name,
                self_managed_active_directory_configuration: self
                    .self_managed_active_directory_configuration,
            }
        }
    }
}
impl CreateSvmActiveDirectoryConfiguration {
    /// Creates a new builder-style object to manufacture [`CreateSvmActiveDirectoryConfiguration`](crate::model::CreateSvmActiveDirectoryConfiguration)
    pub fn builder() -> crate::model::create_svm_active_directory_configuration::Builder {
        crate::model::create_svm_active_directory_configuration::Builder::default()
    }
}

/// <p>The configuration that Amazon FSx uses to join a FSx for Windows File Server file system or an ONTAP storage virtual machine (SVM) to
/// a self-managed (including on-premises) Microsoft Active Directory (AD)
/// directory. For more information, see
/// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/self-managed-AD.html">
/// Using Amazon FSx with your self-managed Microsoft Active Directory</a> or
/// <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html">Managing SVMs</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SelfManagedActiveDirectoryConfiguration {
    /// <p>The fully qualified domain name of the self-managed AD directory, such as
    /// <code>corp.example.com</code>.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>(Optional) The fully qualified distinguished name of the organizational unit within
    /// your self-managed AD directory. Amazon
    /// FSx only accepts OU as the direct parent of the file system. An example is
    /// <code>OU=FSx,DC=yourdomain,DC=corp,DC=com</code>. To learn more, see <a href="https://tools.ietf.org/html/rfc2253">RFC 2253</a>. If none is provided, the
    /// FSx file system is created in the default location of your self-managed AD directory. </p>
    /// <important>
    /// <p>Only Organizational Unit (OU) objects can be the direct parent of the file system
    /// that you're creating.</p>
    /// </important>
    pub organizational_unit_distinguished_name: std::option::Option<std::string::String>,
    /// <p>(Optional) The name of the domain group whose members are granted administrative
    /// privileges for the file system. Administrative privileges include taking ownership of
    /// files and folders, setting audit controls (audit ACLs) on files and folders, and             
    /// administering the file system remotely by using the FSx Remote PowerShell.
    /// The group that you specify must already exist in your domain. If you don't provide one,
    /// your AD domain's Domain Admins group is used.</p>
    pub file_system_administrators_group: std::option::Option<std::string::String>,
    /// <p>The user name for the service account on your self-managed AD domain that Amazon FSx
    /// will use to join to your AD domain. This account must have the permission to join
    /// computers to the domain in the organizational unit provided in
    /// <code>OrganizationalUnitDistinguishedName</code>, or in the default location of your
    /// AD domain.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The password for the service account on your self-managed AD domain that Amazon FSx
    /// will use to join to your AD domain.</p>
    pub password: std::option::Option<std::string::String>,
    /// <p>A list of up to three IP addresses of DNS servers or domain controllers in the
    /// self-managed AD directory. </p>
    pub dns_ips: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl SelfManagedActiveDirectoryConfiguration {
    /// <p>The fully qualified domain name of the self-managed AD directory, such as
    /// <code>corp.example.com</code>.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>(Optional) The fully qualified distinguished name of the organizational unit within
    /// your self-managed AD directory. Amazon
    /// FSx only accepts OU as the direct parent of the file system. An example is
    /// <code>OU=FSx,DC=yourdomain,DC=corp,DC=com</code>. To learn more, see <a href="https://tools.ietf.org/html/rfc2253">RFC 2253</a>. If none is provided, the
    /// FSx file system is created in the default location of your self-managed AD directory. </p>
    /// <important>
    /// <p>Only Organizational Unit (OU) objects can be the direct parent of the file system
    /// that you're creating.</p>
    /// </important>
    pub fn organizational_unit_distinguished_name(&self) -> std::option::Option<&str> {
        self.organizational_unit_distinguished_name.as_deref()
    }
    /// <p>(Optional) The name of the domain group whose members are granted administrative
    /// privileges for the file system. Administrative privileges include taking ownership of
    /// files and folders, setting audit controls (audit ACLs) on files and folders, and             
    /// administering the file system remotely by using the FSx Remote PowerShell.
    /// The group that you specify must already exist in your domain. If you don't provide one,
    /// your AD domain's Domain Admins group is used.</p>
    pub fn file_system_administrators_group(&self) -> std::option::Option<&str> {
        self.file_system_administrators_group.as_deref()
    }
    /// <p>The user name for the service account on your self-managed AD domain that Amazon FSx
    /// will use to join to your AD domain. This account must have the permission to join
    /// computers to the domain in the organizational unit provided in
    /// <code>OrganizationalUnitDistinguishedName</code>, or in the default location of your
    /// AD domain.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>The password for the service account on your self-managed AD domain that Amazon FSx
    /// will use to join to your AD domain.</p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
    /// <p>A list of up to three IP addresses of DNS servers or domain controllers in the
    /// self-managed AD directory. </p>
    pub fn dns_ips(&self) -> std::option::Option<&[std::string::String]> {
        self.dns_ips.as_deref()
    }
}
impl std::fmt::Debug for SelfManagedActiveDirectoryConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SelfManagedActiveDirectoryConfiguration");
        formatter.field("domain_name", &self.domain_name);
        formatter.field(
            "organizational_unit_distinguished_name",
            &self.organizational_unit_distinguished_name,
        );
        formatter.field(
            "file_system_administrators_group",
            &self.file_system_administrators_group,
        );
        formatter.field("user_name", &self.user_name);
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.field("dns_ips", &self.dns_ips);
        formatter.finish()
    }
}
/// See [`SelfManagedActiveDirectoryConfiguration`](crate::model::SelfManagedActiveDirectoryConfiguration)
pub mod self_managed_active_directory_configuration {
    /// A builder for [`SelfManagedActiveDirectoryConfiguration`](crate::model::SelfManagedActiveDirectoryConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) organizational_unit_distinguished_name: std::option::Option<std::string::String>,
        pub(crate) file_system_administrators_group: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) dns_ips: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The fully qualified domain name of the self-managed AD directory, such as
        /// <code>corp.example.com</code>.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The fully qualified domain name of the self-managed AD directory, such as
        /// <code>corp.example.com</code>.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>(Optional) The fully qualified distinguished name of the organizational unit within
        /// your self-managed AD directory. Amazon
        /// FSx only accepts OU as the direct parent of the file system. An example is
        /// <code>OU=FSx,DC=yourdomain,DC=corp,DC=com</code>. To learn more, see <a href="https://tools.ietf.org/html/rfc2253">RFC 2253</a>. If none is provided, the
        /// FSx file system is created in the default location of your self-managed AD directory. </p>
        /// <important>
        /// <p>Only Organizational Unit (OU) objects can be the direct parent of the file system
        /// that you're creating.</p>
        /// </important>
        pub fn organizational_unit_distinguished_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.organizational_unit_distinguished_name = Some(input.into());
            self
        }
        /// <p>(Optional) The fully qualified distinguished name of the organizational unit within
        /// your self-managed AD directory. Amazon
        /// FSx only accepts OU as the direct parent of the file system. An example is
        /// <code>OU=FSx,DC=yourdomain,DC=corp,DC=com</code>. To learn more, see <a href="https://tools.ietf.org/html/rfc2253">RFC 2253</a>. If none is provided, the
        /// FSx file system is created in the default location of your self-managed AD directory. </p>
        /// <important>
        /// <p>Only Organizational Unit (OU) objects can be the direct parent of the file system
        /// that you're creating.</p>
        /// </important>
        pub fn set_organizational_unit_distinguished_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organizational_unit_distinguished_name = input;
            self
        }
        /// <p>(Optional) The name of the domain group whose members are granted administrative
        /// privileges for the file system. Administrative privileges include taking ownership of
        /// files and folders, setting audit controls (audit ACLs) on files and folders, and             
        /// administering the file system remotely by using the FSx Remote PowerShell.
        /// The group that you specify must already exist in your domain. If you don't provide one,
        /// your AD domain's Domain Admins group is used.</p>
        pub fn file_system_administrators_group(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.file_system_administrators_group = Some(input.into());
            self
        }
        /// <p>(Optional) The name of the domain group whose members are granted administrative
        /// privileges for the file system. Administrative privileges include taking ownership of
        /// files and folders, setting audit controls (audit ACLs) on files and folders, and             
        /// administering the file system remotely by using the FSx Remote PowerShell.
        /// The group that you specify must already exist in your domain. If you don't provide one,
        /// your AD domain's Domain Admins group is used.</p>
        pub fn set_file_system_administrators_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_administrators_group = input;
            self
        }
        /// <p>The user name for the service account on your self-managed AD domain that Amazon FSx
        /// will use to join to your AD domain. This account must have the permission to join
        /// computers to the domain in the organizational unit provided in
        /// <code>OrganizationalUnitDistinguishedName</code>, or in the default location of your
        /// AD domain.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The user name for the service account on your self-managed AD domain that Amazon FSx
        /// will use to join to your AD domain. This account must have the permission to join
        /// computers to the domain in the organizational unit provided in
        /// <code>OrganizationalUnitDistinguishedName</code>, or in the default location of your
        /// AD domain.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The password for the service account on your self-managed AD domain that Amazon FSx
        /// will use to join to your AD domain.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>The password for the service account on your self-managed AD domain that Amazon FSx
        /// will use to join to your AD domain.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// Appends an item to `dns_ips`.
        ///
        /// To override the contents of this collection use [`set_dns_ips`](Self::set_dns_ips).
        ///
        /// <p>A list of up to three IP addresses of DNS servers or domain controllers in the
        /// self-managed AD directory. </p>
        pub fn dns_ips(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.dns_ips.unwrap_or_default();
            v.push(input.into());
            self.dns_ips = Some(v);
            self
        }
        /// <p>A list of up to three IP addresses of DNS servers or domain controllers in the
        /// self-managed AD directory. </p>
        pub fn set_dns_ips(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.dns_ips = input;
            self
        }
        /// Consumes the builder and constructs a [`SelfManagedActiveDirectoryConfiguration`](crate::model::SelfManagedActiveDirectoryConfiguration)
        pub fn build(self) -> crate::model::SelfManagedActiveDirectoryConfiguration {
            crate::model::SelfManagedActiveDirectoryConfiguration {
                domain_name: self.domain_name,
                organizational_unit_distinguished_name: self.organizational_unit_distinguished_name,
                file_system_administrators_group: self.file_system_administrators_group,
                user_name: self.user_name,
                password: self.password,
                dns_ips: self.dns_ips,
            }
        }
    }
}
impl SelfManagedActiveDirectoryConfiguration {
    /// Creates a new builder-style object to manufacture [`SelfManagedActiveDirectoryConfiguration`](crate::model::SelfManagedActiveDirectoryConfiguration)
    pub fn builder() -> crate::model::self_managed_active_directory_configuration::Builder {
        crate::model::self_managed_active_directory_configuration::Builder::default()
    }
}

/// <p>The Lustre configuration for the file system being created.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFileSystemLustreConfiguration {
    /// <p>(Optional) The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC
    /// time zone, where d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.</p>
    pub weekly_maintenance_start_time: std::option::Option<std::string::String>,
    /// <p>(Optional) The path to the Amazon S3 bucket (including the optional prefix) that
    /// you're using as the data repository for your Amazon FSx for Lustre file system.
    /// The root of your FSx for Lustre file system will
    /// be mapped to the root of the Amazon S3 bucket you select. An
    /// example is <code>s3://import-bucket/optional-prefix</code>. If you specify a prefix
    /// after the Amazon S3 bucket name, only object keys with that prefix are loaded into the
    /// file system.</p>
    pub import_path: std::option::Option<std::string::String>,
    /// <p>(Optional) The path in Amazon S3 where the root of your Amazon FSx file system is exported.
    /// The path must use the same Amazon S3 bucket as specified in ImportPath. You can provide an optional prefix to which
    /// new and changed data is to be exported from your Amazon FSx for Lustre file system. If
    /// an <code>ExportPath</code> value is not provided, Amazon FSx sets a default export path,
    /// <code>s3://import-bucket/FSxLustre[creation-timestamp]</code>. The timestamp is in
    /// UTC format, for example
    /// <code>s3://import-bucket/FSxLustre20181105T222312Z</code>.</p>
    ///
    /// <p>The Amazon S3 export bucket must be the same as the import bucket specified by
    /// <code>ImportPath</code>. If you only specify a bucket name, such as
    /// <code>s3://import-bucket</code>, you get a 1:1 mapping of file system objects to S3
    /// bucket objects. This mapping means that the input data in S3 is overwritten on export.
    /// If you provide a custom prefix in the export path, such as
    /// <code>s3://import-bucket/[custom-optional-prefix]</code>, Amazon FSx exports the contents of your file
    /// system to that export prefix in the Amazon S3 bucket.</p>
    pub export_path: std::option::Option<std::string::String>,
    /// <p>(Optional) For files imported from a data repository, this value determines the stripe
    /// count and maximum amount of data per file (in MiB) stored on a single physical disk. The
    /// maximum number of disks that a single file can be striped across is limited by the total
    /// number of disks that make up the file system.</p>
    ///
    /// <p>The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500
    /// GiB). Amazon S3 objects have a maximum size of 5 TB.</p>
    pub imported_file_chunk_size: std::option::Option<i32>,
    /// <p>
    /// Choose <code>SCRATCH_1</code> and <code>SCRATCH_2</code> deployment
    /// types when you need temporary storage and shorter-term processing of data.
    /// The <code>SCRATCH_2</code> deployment type provides in-transit encryption of data and higher burst
    /// throughput capacity than <code>SCRATCH_1</code>.</p>
    ///
    /// <p>Choose <code>PERSISTENT_1</code> deployment type for longer-term storage
    /// and workloads and encryption of data in transit. To learn more about deployment types, see
    /// <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html">
    /// FSx for Lustre Deployment Options</a>.</p>
    /// <p>Encryption of data in-transit is automatically
    /// enabled when you access a <code>SCRATCH_2</code> or <code>PERSISTENT_1</code>
    /// file system from Amazon EC2 instances that <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/data-                 protection.html">support this feature</a>.
    /// (Default = <code>SCRATCH_1</code>)
    /// </p>
    /// <p>Encryption of data in-transit for <code>SCRATCH_2</code> and <code>PERSISTENT_1</code>
    /// deployment types is supported when accessed from supported instance types in supported Amazon Web Services Regions. To learn more,
    /// <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/encryption-in-transit-fsxl.html">Encrypting Data in Transit</a>.</p>
    pub deployment_type: std::option::Option<crate::model::LustreDeploymentType>,
    /// <p> (Optional) When you create your file system, your existing S3 objects appear as file and directory listings.
    /// Use this property to choose how Amazon FSx keeps your file and directory listings up to date
    /// as you add or modify objects in your linked S3 bucket. <code>AutoImportPolicy</code> can
    /// have the following values:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code> - (Default) AutoImport is off. Amazon FSx only updates
    /// file and directory listings from the linked S3 bucket
    /// when the file system is created. FSx does not update file and directory
    /// listings for any new or changed objects after choosing this option.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NEW</code> - AutoImport is on. Amazon FSx automatically imports
    /// directory listings of any new objects added to the linked S3 bucket that
    /// do not currently exist in the FSx file system. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NEW_CHANGED</code> - AutoImport is on. Amazon FSx automatically imports
    /// file and directory listings of any new objects added to the S3 bucket and any
    /// existing objects that are changed in the S3 bucket after you choose this option.
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/autoimport-data-repo.html">Automatically import updates from your S3 bucket</a>.</p>
    pub auto_import_policy: std::option::Option<crate::model::AutoImportPolicyType>,
    /// <p>
    /// Required for the <code>PERSISTENT_1</code> deployment type, describes the amount of read and write
    /// throughput for each 1 tebibyte of storage, in MB/s/TiB.
    /// File system throughput capacity is calculated by multiplying ﬁle system storage capacity (TiB) by the PerUnitStorageThroughput
    /// (MB/s/TiB). For a 2.4 TiB ﬁle system, provisioning 50 MB/s/TiB of PerUnitStorageThroughput
    /// yields 120 MB/s of ﬁle system throughput. You pay for the amount of throughput that you
    /// provision.
    /// </p>
    /// <p>Valid values for  SSD storage: 50, 100, 200. Valid values for  HDD storage: 12, 40.</p>
    pub per_unit_storage_throughput: std::option::Option<i32>,
    /// <p>A recurring daily time, in the format <code>HH:MM</code>. <code>HH</code> is the
    /// zero-padded hour of the day (0-23), and <code>MM</code> is the zero-padded minute of the
    /// hour. For example, <code>05:00</code> specifies 5 AM daily. </p>
    pub daily_automatic_backup_start_time: std::option::Option<std::string::String>,
    /// <p>The number of days to retain automatic backups. Setting this to 0 disables
    /// automatic backups. You can retain automatic backups for a maximum of 90 days. The default is 0.</p>
    pub automatic_backup_retention_days: std::option::Option<i32>,
    /// <p>(Optional) Not available to use with file systems that are linked to a data repository.
    /// A boolean flag indicating whether tags for the file system should be copied to
    /// backups. The default value is false. If it's set to true, all file system
    /// tags are copied to all automatic and user-initiated backups when the user
    /// doesn't specify any backup-specific tags. If this value is true, and you specify one or more backup tags, only
    /// the specified tags are copied to backups. If you specify one or more tags when creating a
    /// user-initiated backup, no tags are copied from the file system, regardless of this value.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html">Working with backups</a>.</p>
    pub copy_tags_to_backups: std::option::Option<bool>,
    /// <p>The type of drive cache used by PERSISTENT_1 file systems that are provisioned with
    /// HDD storage devices. This parameter is required when storage type is HDD. Set to
    /// <code>READ</code>, improve the performance for frequently accessed files and allows 20%
    /// of the total storage capacity of the file system to be cached. </p>
    /// <p>This parameter is required when <code>StorageType</code> is set to HDD.</p>
    pub drive_cache_type: std::option::Option<crate::model::DriveCacheType>,
    /// <p>Sets the data compression configuration for the file system. <code>DataCompressionType</code>
    /// can have the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code> - (Default) Data compression is turned off when
    /// the file system is created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LZ4</code> - Data compression is turned on with the LZ4
    /// algorithm.</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data compression</a>.</p>
    pub data_compression_type: std::option::Option<crate::model::DataCompressionType>,
}
impl CreateFileSystemLustreConfiguration {
    /// <p>(Optional) The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC
    /// time zone, where d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.</p>
    pub fn weekly_maintenance_start_time(&self) -> std::option::Option<&str> {
        self.weekly_maintenance_start_time.as_deref()
    }
    /// <p>(Optional) The path to the Amazon S3 bucket (including the optional prefix) that
    /// you're using as the data repository for your Amazon FSx for Lustre file system.
    /// The root of your FSx for Lustre file system will
    /// be mapped to the root of the Amazon S3 bucket you select. An
    /// example is <code>s3://import-bucket/optional-prefix</code>. If you specify a prefix
    /// after the Amazon S3 bucket name, only object keys with that prefix are loaded into the
    /// file system.</p>
    pub fn import_path(&self) -> std::option::Option<&str> {
        self.import_path.as_deref()
    }
    /// <p>(Optional) The path in Amazon S3 where the root of your Amazon FSx file system is exported.
    /// The path must use the same Amazon S3 bucket as specified in ImportPath. You can provide an optional prefix to which
    /// new and changed data is to be exported from your Amazon FSx for Lustre file system. If
    /// an <code>ExportPath</code> value is not provided, Amazon FSx sets a default export path,
    /// <code>s3://import-bucket/FSxLustre[creation-timestamp]</code>. The timestamp is in
    /// UTC format, for example
    /// <code>s3://import-bucket/FSxLustre20181105T222312Z</code>.</p>
    ///
    /// <p>The Amazon S3 export bucket must be the same as the import bucket specified by
    /// <code>ImportPath</code>. If you only specify a bucket name, such as
    /// <code>s3://import-bucket</code>, you get a 1:1 mapping of file system objects to S3
    /// bucket objects. This mapping means that the input data in S3 is overwritten on export.
    /// If you provide a custom prefix in the export path, such as
    /// <code>s3://import-bucket/[custom-optional-prefix]</code>, Amazon FSx exports the contents of your file
    /// system to that export prefix in the Amazon S3 bucket.</p>
    pub fn export_path(&self) -> std::option::Option<&str> {
        self.export_path.as_deref()
    }
    /// <p>(Optional) For files imported from a data repository, this value determines the stripe
    /// count and maximum amount of data per file (in MiB) stored on a single physical disk. The
    /// maximum number of disks that a single file can be striped across is limited by the total
    /// number of disks that make up the file system.</p>
    ///
    /// <p>The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500
    /// GiB). Amazon S3 objects have a maximum size of 5 TB.</p>
    pub fn imported_file_chunk_size(&self) -> std::option::Option<i32> {
        self.imported_file_chunk_size
    }
    /// <p>
    /// Choose <code>SCRATCH_1</code> and <code>SCRATCH_2</code> deployment
    /// types when you need temporary storage and shorter-term processing of data.
    /// The <code>SCRATCH_2</code> deployment type provides in-transit encryption of data and higher burst
    /// throughput capacity than <code>SCRATCH_1</code>.</p>
    ///
    /// <p>Choose <code>PERSISTENT_1</code> deployment type for longer-term storage
    /// and workloads and encryption of data in transit. To learn more about deployment types, see
    /// <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html">
    /// FSx for Lustre Deployment Options</a>.</p>
    /// <p>Encryption of data in-transit is automatically
    /// enabled when you access a <code>SCRATCH_2</code> or <code>PERSISTENT_1</code>
    /// file system from Amazon EC2 instances that <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/data-                 protection.html">support this feature</a>.
    /// (Default = <code>SCRATCH_1</code>)
    /// </p>
    /// <p>Encryption of data in-transit for <code>SCRATCH_2</code> and <code>PERSISTENT_1</code>
    /// deployment types is supported when accessed from supported instance types in supported Amazon Web Services Regions. To learn more,
    /// <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/encryption-in-transit-fsxl.html">Encrypting Data in Transit</a>.</p>
    pub fn deployment_type(&self) -> std::option::Option<&crate::model::LustreDeploymentType> {
        self.deployment_type.as_ref()
    }
    /// <p> (Optional) When you create your file system, your existing S3 objects appear as file and directory listings.
    /// Use this property to choose how Amazon FSx keeps your file and directory listings up to date
    /// as you add or modify objects in your linked S3 bucket. <code>AutoImportPolicy</code> can
    /// have the following values:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code> - (Default) AutoImport is off. Amazon FSx only updates
    /// file and directory listings from the linked S3 bucket
    /// when the file system is created. FSx does not update file and directory
    /// listings for any new or changed objects after choosing this option.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NEW</code> - AutoImport is on. Amazon FSx automatically imports
    /// directory listings of any new objects added to the linked S3 bucket that
    /// do not currently exist in the FSx file system. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NEW_CHANGED</code> - AutoImport is on. Amazon FSx automatically imports
    /// file and directory listings of any new objects added to the S3 bucket and any
    /// existing objects that are changed in the S3 bucket after you choose this option.
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/autoimport-data-repo.html">Automatically import updates from your S3 bucket</a>.</p>
    pub fn auto_import_policy(&self) -> std::option::Option<&crate::model::AutoImportPolicyType> {
        self.auto_import_policy.as_ref()
    }
    /// <p>
    /// Required for the <code>PERSISTENT_1</code> deployment type, describes the amount of read and write
    /// throughput for each 1 tebibyte of storage, in MB/s/TiB.
    /// File system throughput capacity is calculated by multiplying ﬁle system storage capacity (TiB) by the PerUnitStorageThroughput
    /// (MB/s/TiB). For a 2.4 TiB ﬁle system, provisioning 50 MB/s/TiB of PerUnitStorageThroughput
    /// yields 120 MB/s of ﬁle system throughput. You pay for the amount of throughput that you
    /// provision.
    /// </p>
    /// <p>Valid values for  SSD storage: 50, 100, 200. Valid values for  HDD storage: 12, 40.</p>
    pub fn per_unit_storage_throughput(&self) -> std::option::Option<i32> {
        self.per_unit_storage_throughput
    }
    /// <p>A recurring daily time, in the format <code>HH:MM</code>. <code>HH</code> is the
    /// zero-padded hour of the day (0-23), and <code>MM</code> is the zero-padded minute of the
    /// hour. For example, <code>05:00</code> specifies 5 AM daily. </p>
    pub fn daily_automatic_backup_start_time(&self) -> std::option::Option<&str> {
        self.daily_automatic_backup_start_time.as_deref()
    }
    /// <p>The number of days to retain automatic backups. Setting this to 0 disables
    /// automatic backups. You can retain automatic backups for a maximum of 90 days. The default is 0.</p>
    pub fn automatic_backup_retention_days(&self) -> std::option::Option<i32> {
        self.automatic_backup_retention_days
    }
    /// <p>(Optional) Not available to use with file systems that are linked to a data repository.
    /// A boolean flag indicating whether tags for the file system should be copied to
    /// backups. The default value is false. If it's set to true, all file system
    /// tags are copied to all automatic and user-initiated backups when the user
    /// doesn't specify any backup-specific tags. If this value is true, and you specify one or more backup tags, only
    /// the specified tags are copied to backups. If you specify one or more tags when creating a
    /// user-initiated backup, no tags are copied from the file system, regardless of this value.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html">Working with backups</a>.</p>
    pub fn copy_tags_to_backups(&self) -> std::option::Option<bool> {
        self.copy_tags_to_backups
    }
    /// <p>The type of drive cache used by PERSISTENT_1 file systems that are provisioned with
    /// HDD storage devices. This parameter is required when storage type is HDD. Set to
    /// <code>READ</code>, improve the performance for frequently accessed files and allows 20%
    /// of the total storage capacity of the file system to be cached. </p>
    /// <p>This parameter is required when <code>StorageType</code> is set to HDD.</p>
    pub fn drive_cache_type(&self) -> std::option::Option<&crate::model::DriveCacheType> {
        self.drive_cache_type.as_ref()
    }
    /// <p>Sets the data compression configuration for the file system. <code>DataCompressionType</code>
    /// can have the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code> - (Default) Data compression is turned off when
    /// the file system is created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LZ4</code> - Data compression is turned on with the LZ4
    /// algorithm.</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data compression</a>.</p>
    pub fn data_compression_type(&self) -> std::option::Option<&crate::model::DataCompressionType> {
        self.data_compression_type.as_ref()
    }
}
impl std::fmt::Debug for CreateFileSystemLustreConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFileSystemLustreConfiguration");
        formatter.field(
            "weekly_maintenance_start_time",
            &self.weekly_maintenance_start_time,
        );
        formatter.field("import_path", &self.import_path);
        formatter.field("export_path", &self.export_path);
        formatter.field("imported_file_chunk_size", &self.imported_file_chunk_size);
        formatter.field("deployment_type", &self.deployment_type);
        formatter.field("auto_import_policy", &self.auto_import_policy);
        formatter.field(
            "per_unit_storage_throughput",
            &self.per_unit_storage_throughput,
        );
        formatter.field(
            "daily_automatic_backup_start_time",
            &self.daily_automatic_backup_start_time,
        );
        formatter.field(
            "automatic_backup_retention_days",
            &self.automatic_backup_retention_days,
        );
        formatter.field("copy_tags_to_backups", &self.copy_tags_to_backups);
        formatter.field("drive_cache_type", &self.drive_cache_type);
        formatter.field("data_compression_type", &self.data_compression_type);
        formatter.finish()
    }
}
/// See [`CreateFileSystemLustreConfiguration`](crate::model::CreateFileSystemLustreConfiguration)
pub mod create_file_system_lustre_configuration {
    /// A builder for [`CreateFileSystemLustreConfiguration`](crate::model::CreateFileSystemLustreConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) weekly_maintenance_start_time: std::option::Option<std::string::String>,
        pub(crate) import_path: std::option::Option<std::string::String>,
        pub(crate) export_path: std::option::Option<std::string::String>,
        pub(crate) imported_file_chunk_size: std::option::Option<i32>,
        pub(crate) deployment_type: std::option::Option<crate::model::LustreDeploymentType>,
        pub(crate) auto_import_policy: std::option::Option<crate::model::AutoImportPolicyType>,
        pub(crate) per_unit_storage_throughput: std::option::Option<i32>,
        pub(crate) daily_automatic_backup_start_time: std::option::Option<std::string::String>,
        pub(crate) automatic_backup_retention_days: std::option::Option<i32>,
        pub(crate) copy_tags_to_backups: std::option::Option<bool>,
        pub(crate) drive_cache_type: std::option::Option<crate::model::DriveCacheType>,
        pub(crate) data_compression_type: std::option::Option<crate::model::DataCompressionType>,
    }
    impl Builder {
        /// <p>(Optional) The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC
        /// time zone, where d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.</p>
        pub fn weekly_maintenance_start_time(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.weekly_maintenance_start_time = Some(input.into());
            self
        }
        /// <p>(Optional) The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC
        /// time zone, where d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.</p>
        pub fn set_weekly_maintenance_start_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.weekly_maintenance_start_time = input;
            self
        }
        /// <p>(Optional) The path to the Amazon S3 bucket (including the optional prefix) that
        /// you're using as the data repository for your Amazon FSx for Lustre file system.
        /// The root of your FSx for Lustre file system will
        /// be mapped to the root of the Amazon S3 bucket you select. An
        /// example is <code>s3://import-bucket/optional-prefix</code>. If you specify a prefix
        /// after the Amazon S3 bucket name, only object keys with that prefix are loaded into the
        /// file system.</p>
        pub fn import_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.import_path = Some(input.into());
            self
        }
        /// <p>(Optional) The path to the Amazon S3 bucket (including the optional prefix) that
        /// you're using as the data repository for your Amazon FSx for Lustre file system.
        /// The root of your FSx for Lustre file system will
        /// be mapped to the root of the Amazon S3 bucket you select. An
        /// example is <code>s3://import-bucket/optional-prefix</code>. If you specify a prefix
        /// after the Amazon S3 bucket name, only object keys with that prefix are loaded into the
        /// file system.</p>
        pub fn set_import_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.import_path = input;
            self
        }
        /// <p>(Optional) The path in Amazon S3 where the root of your Amazon FSx file system is exported.
        /// The path must use the same Amazon S3 bucket as specified in ImportPath. You can provide an optional prefix to which
        /// new and changed data is to be exported from your Amazon FSx for Lustre file system. If
        /// an <code>ExportPath</code> value is not provided, Amazon FSx sets a default export path,
        /// <code>s3://import-bucket/FSxLustre[creation-timestamp]</code>. The timestamp is in
        /// UTC format, for example
        /// <code>s3://import-bucket/FSxLustre20181105T222312Z</code>.</p>
        ///
        /// <p>The Amazon S3 export bucket must be the same as the import bucket specified by
        /// <code>ImportPath</code>. If you only specify a bucket name, such as
        /// <code>s3://import-bucket</code>, you get a 1:1 mapping of file system objects to S3
        /// bucket objects. This mapping means that the input data in S3 is overwritten on export.
        /// If you provide a custom prefix in the export path, such as
        /// <code>s3://import-bucket/[custom-optional-prefix]</code>, Amazon FSx exports the contents of your file
        /// system to that export prefix in the Amazon S3 bucket.</p>
        pub fn export_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.export_path = Some(input.into());
            self
        }
        /// <p>(Optional) The path in Amazon S3 where the root of your Amazon FSx file system is exported.
        /// The path must use the same Amazon S3 bucket as specified in ImportPath. You can provide an optional prefix to which
        /// new and changed data is to be exported from your Amazon FSx for Lustre file system. If
        /// an <code>ExportPath</code> value is not provided, Amazon FSx sets a default export path,
        /// <code>s3://import-bucket/FSxLustre[creation-timestamp]</code>. The timestamp is in
        /// UTC format, for example
        /// <code>s3://import-bucket/FSxLustre20181105T222312Z</code>.</p>
        ///
        /// <p>The Amazon S3 export bucket must be the same as the import bucket specified by
        /// <code>ImportPath</code>. If you only specify a bucket name, such as
        /// <code>s3://import-bucket</code>, you get a 1:1 mapping of file system objects to S3
        /// bucket objects. This mapping means that the input data in S3 is overwritten on export.
        /// If you provide a custom prefix in the export path, such as
        /// <code>s3://import-bucket/[custom-optional-prefix]</code>, Amazon FSx exports the contents of your file
        /// system to that export prefix in the Amazon S3 bucket.</p>
        pub fn set_export_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.export_path = input;
            self
        }
        /// <p>(Optional) For files imported from a data repository, this value determines the stripe
        /// count and maximum amount of data per file (in MiB) stored on a single physical disk. The
        /// maximum number of disks that a single file can be striped across is limited by the total
        /// number of disks that make up the file system.</p>
        ///
        /// <p>The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500
        /// GiB). Amazon S3 objects have a maximum size of 5 TB.</p>
        pub fn imported_file_chunk_size(mut self, input: i32) -> Self {
            self.imported_file_chunk_size = Some(input);
            self
        }
        /// <p>(Optional) For files imported from a data repository, this value determines the stripe
        /// count and maximum amount of data per file (in MiB) stored on a single physical disk. The
        /// maximum number of disks that a single file can be striped across is limited by the total
        /// number of disks that make up the file system.</p>
        ///
        /// <p>The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500
        /// GiB). Amazon S3 objects have a maximum size of 5 TB.</p>
        pub fn set_imported_file_chunk_size(mut self, input: std::option::Option<i32>) -> Self {
            self.imported_file_chunk_size = input;
            self
        }
        /// <p>
        /// Choose <code>SCRATCH_1</code> and <code>SCRATCH_2</code> deployment
        /// types when you need temporary storage and shorter-term processing of data.
        /// The <code>SCRATCH_2</code> deployment type provides in-transit encryption of data and higher burst
        /// throughput capacity than <code>SCRATCH_1</code>.</p>
        ///
        /// <p>Choose <code>PERSISTENT_1</code> deployment type for longer-term storage
        /// and workloads and encryption of data in transit. To learn more about deployment types, see
        /// <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html">
        /// FSx for Lustre Deployment Options</a>.</p>
        /// <p>Encryption of data in-transit is automatically
        /// enabled when you access a <code>SCRATCH_2</code> or <code>PERSISTENT_1</code>
        /// file system from Amazon EC2 instances that <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/data-                 protection.html">support this feature</a>.
        /// (Default = <code>SCRATCH_1</code>)
        /// </p>
        /// <p>Encryption of data in-transit for <code>SCRATCH_2</code> and <code>PERSISTENT_1</code>
        /// deployment types is supported when accessed from supported instance types in supported Amazon Web Services Regions. To learn more,
        /// <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/encryption-in-transit-fsxl.html">Encrypting Data in Transit</a>.</p>
        pub fn deployment_type(mut self, input: crate::model::LustreDeploymentType) -> Self {
            self.deployment_type = Some(input);
            self
        }
        /// <p>
        /// Choose <code>SCRATCH_1</code> and <code>SCRATCH_2</code> deployment
        /// types when you need temporary storage and shorter-term processing of data.
        /// The <code>SCRATCH_2</code> deployment type provides in-transit encryption of data and higher burst
        /// throughput capacity than <code>SCRATCH_1</code>.</p>
        ///
        /// <p>Choose <code>PERSISTENT_1</code> deployment type for longer-term storage
        /// and workloads and encryption of data in transit. To learn more about deployment types, see
        /// <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html">
        /// FSx for Lustre Deployment Options</a>.</p>
        /// <p>Encryption of data in-transit is automatically
        /// enabled when you access a <code>SCRATCH_2</code> or <code>PERSISTENT_1</code>
        /// file system from Amazon EC2 instances that <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/data-                 protection.html">support this feature</a>.
        /// (Default = <code>SCRATCH_1</code>)
        /// </p>
        /// <p>Encryption of data in-transit for <code>SCRATCH_2</code> and <code>PERSISTENT_1</code>
        /// deployment types is supported when accessed from supported instance types in supported Amazon Web Services Regions. To learn more,
        /// <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/encryption-in-transit-fsxl.html">Encrypting Data in Transit</a>.</p>
        pub fn set_deployment_type(
            mut self,
            input: std::option::Option<crate::model::LustreDeploymentType>,
        ) -> Self {
            self.deployment_type = input;
            self
        }
        /// <p> (Optional) When you create your file system, your existing S3 objects appear as file and directory listings.
        /// Use this property to choose how Amazon FSx keeps your file and directory listings up to date
        /// as you add or modify objects in your linked S3 bucket. <code>AutoImportPolicy</code> can
        /// have the following values:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code> - (Default) AutoImport is off. Amazon FSx only updates
        /// file and directory listings from the linked S3 bucket
        /// when the file system is created. FSx does not update file and directory
        /// listings for any new or changed objects after choosing this option.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NEW</code> - AutoImport is on. Amazon FSx automatically imports
        /// directory listings of any new objects added to the linked S3 bucket that
        /// do not currently exist in the FSx file system. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NEW_CHANGED</code> - AutoImport is on. Amazon FSx automatically imports
        /// file and directory listings of any new objects added to the S3 bucket and any
        /// existing objects that are changed in the S3 bucket after you choose this option.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/autoimport-data-repo.html">Automatically import updates from your S3 bucket</a>.</p>
        pub fn auto_import_policy(mut self, input: crate::model::AutoImportPolicyType) -> Self {
            self.auto_import_policy = Some(input);
            self
        }
        /// <p> (Optional) When you create your file system, your existing S3 objects appear as file and directory listings.
        /// Use this property to choose how Amazon FSx keeps your file and directory listings up to date
        /// as you add or modify objects in your linked S3 bucket. <code>AutoImportPolicy</code> can
        /// have the following values:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code> - (Default) AutoImport is off. Amazon FSx only updates
        /// file and directory listings from the linked S3 bucket
        /// when the file system is created. FSx does not update file and directory
        /// listings for any new or changed objects after choosing this option.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NEW</code> - AutoImport is on. Amazon FSx automatically imports
        /// directory listings of any new objects added to the linked S3 bucket that
        /// do not currently exist in the FSx file system. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NEW_CHANGED</code> - AutoImport is on. Amazon FSx automatically imports
        /// file and directory listings of any new objects added to the S3 bucket and any
        /// existing objects that are changed in the S3 bucket after you choose this option.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/autoimport-data-repo.html">Automatically import updates from your S3 bucket</a>.</p>
        pub fn set_auto_import_policy(
            mut self,
            input: std::option::Option<crate::model::AutoImportPolicyType>,
        ) -> Self {
            self.auto_import_policy = input;
            self
        }
        /// <p>
        /// Required for the <code>PERSISTENT_1</code> deployment type, describes the amount of read and write
        /// throughput for each 1 tebibyte of storage, in MB/s/TiB.
        /// File system throughput capacity is calculated by multiplying ﬁle system storage capacity (TiB) by the PerUnitStorageThroughput
        /// (MB/s/TiB). For a 2.4 TiB ﬁle system, provisioning 50 MB/s/TiB of PerUnitStorageThroughput
        /// yields 120 MB/s of ﬁle system throughput. You pay for the amount of throughput that you
        /// provision.
        /// </p>
        /// <p>Valid values for  SSD storage: 50, 100, 200. Valid values for  HDD storage: 12, 40.</p>
        pub fn per_unit_storage_throughput(mut self, input: i32) -> Self {
            self.per_unit_storage_throughput = Some(input);
            self
        }
        /// <p>
        /// Required for the <code>PERSISTENT_1</code> deployment type, describes the amount of read and write
        /// throughput for each 1 tebibyte of storage, in MB/s/TiB.
        /// File system throughput capacity is calculated by multiplying ﬁle system storage capacity (TiB) by the PerUnitStorageThroughput
        /// (MB/s/TiB). For a 2.4 TiB ﬁle system, provisioning 50 MB/s/TiB of PerUnitStorageThroughput
        /// yields 120 MB/s of ﬁle system throughput. You pay for the amount of throughput that you
        /// provision.
        /// </p>
        /// <p>Valid values for  SSD storage: 50, 100, 200. Valid values for  HDD storage: 12, 40.</p>
        pub fn set_per_unit_storage_throughput(mut self, input: std::option::Option<i32>) -> Self {
            self.per_unit_storage_throughput = input;
            self
        }
        /// <p>A recurring daily time, in the format <code>HH:MM</code>. <code>HH</code> is the
        /// zero-padded hour of the day (0-23), and <code>MM</code> is the zero-padded minute of the
        /// hour. For example, <code>05:00</code> specifies 5 AM daily. </p>
        pub fn daily_automatic_backup_start_time(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.daily_automatic_backup_start_time = Some(input.into());
            self
        }
        /// <p>A recurring daily time, in the format <code>HH:MM</code>. <code>HH</code> is the
        /// zero-padded hour of the day (0-23), and <code>MM</code> is the zero-padded minute of the
        /// hour. For example, <code>05:00</code> specifies 5 AM daily. </p>
        pub fn set_daily_automatic_backup_start_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.daily_automatic_backup_start_time = input;
            self
        }
        /// <p>The number of days to retain automatic backups. Setting this to 0 disables
        /// automatic backups. You can retain automatic backups for a maximum of 90 days. The default is 0.</p>
        pub fn automatic_backup_retention_days(mut self, input: i32) -> Self {
            self.automatic_backup_retention_days = Some(input);
            self
        }
        /// <p>The number of days to retain automatic backups. Setting this to 0 disables
        /// automatic backups. You can retain automatic backups for a maximum of 90 days. The default is 0.</p>
        pub fn set_automatic_backup_retention_days(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.automatic_backup_retention_days = input;
            self
        }
        /// <p>(Optional) Not available to use with file systems that are linked to a data repository.
        /// A boolean flag indicating whether tags for the file system should be copied to
        /// backups. The default value is false. If it's set to true, all file system
        /// tags are copied to all automatic and user-initiated backups when the user
        /// doesn't specify any backup-specific tags. If this value is true, and you specify one or more backup tags, only
        /// the specified tags are copied to backups. If you specify one or more tags when creating a
        /// user-initiated backup, no tags are copied from the file system, regardless of this value.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html">Working with backups</a>.</p>
        pub fn copy_tags_to_backups(mut self, input: bool) -> Self {
            self.copy_tags_to_backups = Some(input);
            self
        }
        /// <p>(Optional) Not available to use with file systems that are linked to a data repository.
        /// A boolean flag indicating whether tags for the file system should be copied to
        /// backups. The default value is false. If it's set to true, all file system
        /// tags are copied to all automatic and user-initiated backups when the user
        /// doesn't specify any backup-specific tags. If this value is true, and you specify one or more backup tags, only
        /// the specified tags are copied to backups. If you specify one or more tags when creating a
        /// user-initiated backup, no tags are copied from the file system, regardless of this value.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html">Working with backups</a>.</p>
        pub fn set_copy_tags_to_backups(mut self, input: std::option::Option<bool>) -> Self {
            self.copy_tags_to_backups = input;
            self
        }
        /// <p>The type of drive cache used by PERSISTENT_1 file systems that are provisioned with
        /// HDD storage devices. This parameter is required when storage type is HDD. Set to
        /// <code>READ</code>, improve the performance for frequently accessed files and allows 20%
        /// of the total storage capacity of the file system to be cached. </p>
        /// <p>This parameter is required when <code>StorageType</code> is set to HDD.</p>
        pub fn drive_cache_type(mut self, input: crate::model::DriveCacheType) -> Self {
            self.drive_cache_type = Some(input);
            self
        }
        /// <p>The type of drive cache used by PERSISTENT_1 file systems that are provisioned with
        /// HDD storage devices. This parameter is required when storage type is HDD. Set to
        /// <code>READ</code>, improve the performance for frequently accessed files and allows 20%
        /// of the total storage capacity of the file system to be cached. </p>
        /// <p>This parameter is required when <code>StorageType</code> is set to HDD.</p>
        pub fn set_drive_cache_type(
            mut self,
            input: std::option::Option<crate::model::DriveCacheType>,
        ) -> Self {
            self.drive_cache_type = input;
            self
        }
        /// <p>Sets the data compression configuration for the file system. <code>DataCompressionType</code>
        /// can have the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code> - (Default) Data compression is turned off when
        /// the file system is created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LZ4</code> - Data compression is turned on with the LZ4
        /// algorithm.</p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data compression</a>.</p>
        pub fn data_compression_type(mut self, input: crate::model::DataCompressionType) -> Self {
            self.data_compression_type = Some(input);
            self
        }
        /// <p>Sets the data compression configuration for the file system. <code>DataCompressionType</code>
        /// can have the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code> - (Default) Data compression is turned off when
        /// the file system is created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LZ4</code> - Data compression is turned on with the LZ4
        /// algorithm.</p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data compression</a>.</p>
        pub fn set_data_compression_type(
            mut self,
            input: std::option::Option<crate::model::DataCompressionType>,
        ) -> Self {
            self.data_compression_type = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFileSystemLustreConfiguration`](crate::model::CreateFileSystemLustreConfiguration)
        pub fn build(self) -> crate::model::CreateFileSystemLustreConfiguration {
            crate::model::CreateFileSystemLustreConfiguration {
                weekly_maintenance_start_time: self.weekly_maintenance_start_time,
                import_path: self.import_path,
                export_path: self.export_path,
                imported_file_chunk_size: self.imported_file_chunk_size,
                deployment_type: self.deployment_type,
                auto_import_policy: self.auto_import_policy,
                per_unit_storage_throughput: self.per_unit_storage_throughput,
                daily_automatic_backup_start_time: self.daily_automatic_backup_start_time,
                automatic_backup_retention_days: self.automatic_backup_retention_days,
                copy_tags_to_backups: self.copy_tags_to_backups,
                drive_cache_type: self.drive_cache_type,
                data_compression_type: self.data_compression_type,
            }
        }
    }
}
impl CreateFileSystemLustreConfiguration {
    /// Creates a new builder-style object to manufacture [`CreateFileSystemLustreConfiguration`](crate::model::CreateFileSystemLustreConfiguration)
    pub fn builder() -> crate::model::create_file_system_lustre_configuration::Builder {
        crate::model::create_file_system_lustre_configuration::Builder::default()
    }
}

/// <p>The configuration object for the Microsoft Windows file system used in
/// <code>CreateFileSystem</code> and <code>CreateFileSystemFromBackup</code>
/// operations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFileSystemWindowsConfiguration {
    /// <p>The ID for an existing Amazon Web Services Managed Microsoft Active Directory (AD) instance that the
    /// file system should join when it's created.</p>
    pub active_directory_id: std::option::Option<std::string::String>,
    /// <p>The configuration that Amazon FSx uses to join a FSx for Windows File Server file system or an ONTAP storage virtual machine (SVM) to
    /// a self-managed (including on-premises) Microsoft Active Directory (AD)
    /// directory. For more information, see
    /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/self-managed-AD.html">
    /// Using Amazon FSx with your self-managed Microsoft Active Directory</a> or
    /// <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html">Managing SVMs</a>.</p>
    pub self_managed_active_directory_configuration:
        std::option::Option<crate::model::SelfManagedActiveDirectoryConfiguration>,
    /// <p>Specifies the file system deployment type, valid values are the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>MULTI_AZ_1</code> - Deploys a high availability file system that is configured
    /// for Multi-AZ redundancy to tolerate temporary Availability Zone (AZ) unavailability. You
    /// can only deploy a Multi-AZ file system in Amazon Web Services Regions that have a minimum of three Availability Zones. Also
    /// supports HDD storage type</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SINGLE_AZ_1</code> - (Default) Choose to deploy a file system that is configured for single AZ redundancy.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SINGLE_AZ_2</code> - The latest generation Single AZ file system.
    /// Specifies a file system that is configured for single AZ redundancy and supports HDD storage type.</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see
    /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html">
    /// Availability and Durability: Single-AZ and Multi-AZ File Systems</a>.</p>
    pub deployment_type: std::option::Option<crate::model::WindowsDeploymentType>,
    /// <p>Required when <code>DeploymentType</code> is set to <code>MULTI_AZ_1</code>. This specifies the subnet
    /// in which you want the preferred file server to be located. For in-Amazon Web Services applications, we recommend that you launch
    /// your clients in the same Availability Zone (AZ) as your preferred file server to reduce cross-AZ
    /// data transfer costs and minimize latency. </p>
    pub preferred_subnet_id: std::option::Option<std::string::String>,
    /// <p>The throughput of an Amazon FSx file system, measured in megabytes per second, in 2 to
    /// the <i>n</i>th increments, between 2^3 (8) and 2^11 (2048).</p>
    pub throughput_capacity: std::option::Option<i32>,
    /// <p>The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC
    /// time zone, where d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.</p>
    pub weekly_maintenance_start_time: std::option::Option<std::string::String>,
    /// <p>The preferred time to take daily automatic backups, formatted HH:MM in the UTC time
    /// zone.</p>
    pub daily_automatic_backup_start_time: std::option::Option<std::string::String>,
    /// <p>The number of days to retain automatic backups. The default is to retain backups for 7
    /// days. Setting this value to 0 disables the creation of automatic backups. The maximum
    /// retention period for backups is 90 days.</p>
    pub automatic_backup_retention_days: std::option::Option<i32>,
    /// <p>A boolean flag indicating whether tags for the file system should be copied to
    /// backups. This value defaults to false. If it's set to true, all tags for the file
    /// system are copied to all automatic and user-initiated backups where the user
    /// doesn't specify tags. If this value is true, and you specify one or more tags, only
    /// the specified tags are copied to backups. If you specify one or more tags when creating a
    /// user-initiated backup, no tags are copied from the file system, regardless of this value.</p>
    pub copy_tags_to_backups: std::option::Option<bool>,
    /// <p>An array of one or more DNS alias names that you want to associate with the Amazon FSx file system.
    /// Aliases allow you to use existing DNS names to access the data in your Amazon FSx file system.
    /// You can associate up to 50 aliases with a file system at any time.
    /// You can associate additional DNS aliases after you create the file system using the AssociateFileSystemAliases operation.
    /// You can remove DNS aliases from the file system after it is created using the DisassociateFileSystemAliases operation.
    /// You only need to specify the alias name in the request payload.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html">Working with DNS Aliases</a> and
    /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/walkthrough05-file-system-custom-CNAME.html">Walkthrough 5: Using DNS aliases to access your file system</a>, including
    /// additional steps you must take to be able to access your file system using a DNS alias.</p>
    /// <p>An alias name has to meet the following requirements:</p>
    /// <ul>
    /// <li>
    /// <p>Formatted as a fully-qualified domain name (FQDN), <code>hostname.domain</code>, for example, <code>accounting.example.com</code>.</p>
    /// </li>
    /// <li>
    /// <p>Can contain alphanumeric characters, the underscore (_), and the hyphen (-).</p>
    /// </li>
    /// <li>
    /// <p>Cannot start or end with a hyphen.</p>
    /// </li>
    /// <li>
    /// <p>Can start with a numeric.</p>
    /// </li>
    /// </ul>
    /// <p>For DNS alias names, Amazon FSx stores alphabetic characters as lowercase letters (a-z), regardless of how you specify them:
    /// as uppercase letters, lowercase letters, or the corresponding letters in escape codes.</p>
    pub aliases: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The configuration that Amazon FSx for Windows File Server uses to audit and log
    /// user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server
    /// file system.</p>
    pub audit_log_configuration:
        std::option::Option<crate::model::WindowsAuditLogCreateConfiguration>,
}
impl CreateFileSystemWindowsConfiguration {
    /// <p>The ID for an existing Amazon Web Services Managed Microsoft Active Directory (AD) instance that the
    /// file system should join when it's created.</p>
    pub fn active_directory_id(&self) -> std::option::Option<&str> {
        self.active_directory_id.as_deref()
    }
    /// <p>The configuration that Amazon FSx uses to join a FSx for Windows File Server file system or an ONTAP storage virtual machine (SVM) to
    /// a self-managed (including on-premises) Microsoft Active Directory (AD)
    /// directory. For more information, see
    /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/self-managed-AD.html">
    /// Using Amazon FSx with your self-managed Microsoft Active Directory</a> or
    /// <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html">Managing SVMs</a>.</p>
    pub fn self_managed_active_directory_configuration(
        &self,
    ) -> std::option::Option<&crate::model::SelfManagedActiveDirectoryConfiguration> {
        self.self_managed_active_directory_configuration.as_ref()
    }
    /// <p>Specifies the file system deployment type, valid values are the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>MULTI_AZ_1</code> - Deploys a high availability file system that is configured
    /// for Multi-AZ redundancy to tolerate temporary Availability Zone (AZ) unavailability. You
    /// can only deploy a Multi-AZ file system in Amazon Web Services Regions that have a minimum of three Availability Zones. Also
    /// supports HDD storage type</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SINGLE_AZ_1</code> - (Default) Choose to deploy a file system that is configured for single AZ redundancy.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SINGLE_AZ_2</code> - The latest generation Single AZ file system.
    /// Specifies a file system that is configured for single AZ redundancy and supports HDD storage type.</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see
    /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html">
    /// Availability and Durability: Single-AZ and Multi-AZ File Systems</a>.</p>
    pub fn deployment_type(&self) -> std::option::Option<&crate::model::WindowsDeploymentType> {
        self.deployment_type.as_ref()
    }
    /// <p>Required when <code>DeploymentType</code> is set to <code>MULTI_AZ_1</code>. This specifies the subnet
    /// in which you want the preferred file server to be located. For in-Amazon Web Services applications, we recommend that you launch
    /// your clients in the same Availability Zone (AZ) as your preferred file server to reduce cross-AZ
    /// data transfer costs and minimize latency. </p>
    pub fn preferred_subnet_id(&self) -> std::option::Option<&str> {
        self.preferred_subnet_id.as_deref()
    }
    /// <p>The throughput of an Amazon FSx file system, measured in megabytes per second, in 2 to
    /// the <i>n</i>th increments, between 2^3 (8) and 2^11 (2048).</p>
    pub fn throughput_capacity(&self) -> std::option::Option<i32> {
        self.throughput_capacity
    }
    /// <p>The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC
    /// time zone, where d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.</p>
    pub fn weekly_maintenance_start_time(&self) -> std::option::Option<&str> {
        self.weekly_maintenance_start_time.as_deref()
    }
    /// <p>The preferred time to take daily automatic backups, formatted HH:MM in the UTC time
    /// zone.</p>
    pub fn daily_automatic_backup_start_time(&self) -> std::option::Option<&str> {
        self.daily_automatic_backup_start_time.as_deref()
    }
    /// <p>The number of days to retain automatic backups. The default is to retain backups for 7
    /// days. Setting this value to 0 disables the creation of automatic backups. The maximum
    /// retention period for backups is 90 days.</p>
    pub fn automatic_backup_retention_days(&self) -> std::option::Option<i32> {
        self.automatic_backup_retention_days
    }
    /// <p>A boolean flag indicating whether tags for the file system should be copied to
    /// backups. This value defaults to false. If it's set to true, all tags for the file
    /// system are copied to all automatic and user-initiated backups where the user
    /// doesn't specify tags. If this value is true, and you specify one or more tags, only
    /// the specified tags are copied to backups. If you specify one or more tags when creating a
    /// user-initiated backup, no tags are copied from the file system, regardless of this value.</p>
    pub fn copy_tags_to_backups(&self) -> std::option::Option<bool> {
        self.copy_tags_to_backups
    }
    /// <p>An array of one or more DNS alias names that you want to associate with the Amazon FSx file system.
    /// Aliases allow you to use existing DNS names to access the data in your Amazon FSx file system.
    /// You can associate up to 50 aliases with a file system at any time.
    /// You can associate additional DNS aliases after you create the file system using the AssociateFileSystemAliases operation.
    /// You can remove DNS aliases from the file system after it is created using the DisassociateFileSystemAliases operation.
    /// You only need to specify the alias name in the request payload.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html">Working with DNS Aliases</a> and
    /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/walkthrough05-file-system-custom-CNAME.html">Walkthrough 5: Using DNS aliases to access your file system</a>, including
    /// additional steps you must take to be able to access your file system using a DNS alias.</p>
    /// <p>An alias name has to meet the following requirements:</p>
    /// <ul>
    /// <li>
    /// <p>Formatted as a fully-qualified domain name (FQDN), <code>hostname.domain</code>, for example, <code>accounting.example.com</code>.</p>
    /// </li>
    /// <li>
    /// <p>Can contain alphanumeric characters, the underscore (_), and the hyphen (-).</p>
    /// </li>
    /// <li>
    /// <p>Cannot start or end with a hyphen.</p>
    /// </li>
    /// <li>
    /// <p>Can start with a numeric.</p>
    /// </li>
    /// </ul>
    /// <p>For DNS alias names, Amazon FSx stores alphabetic characters as lowercase letters (a-z), regardless of how you specify them:
    /// as uppercase letters, lowercase letters, or the corresponding letters in escape codes.</p>
    pub fn aliases(&self) -> std::option::Option<&[std::string::String]> {
        self.aliases.as_deref()
    }
    /// <p>The configuration that Amazon FSx for Windows File Server uses to audit and log
    /// user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server
    /// file system.</p>
    pub fn audit_log_configuration(
        &self,
    ) -> std::option::Option<&crate::model::WindowsAuditLogCreateConfiguration> {
        self.audit_log_configuration.as_ref()
    }
}
impl std::fmt::Debug for CreateFileSystemWindowsConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFileSystemWindowsConfiguration");
        formatter.field("active_directory_id", &self.active_directory_id);
        formatter.field(
            "self_managed_active_directory_configuration",
            &self.self_managed_active_directory_configuration,
        );
        formatter.field("deployment_type", &self.deployment_type);
        formatter.field("preferred_subnet_id", &self.preferred_subnet_id);
        formatter.field("throughput_capacity", &self.throughput_capacity);
        formatter.field(
            "weekly_maintenance_start_time",
            &self.weekly_maintenance_start_time,
        );
        formatter.field(
            "daily_automatic_backup_start_time",
            &self.daily_automatic_backup_start_time,
        );
        formatter.field(
            "automatic_backup_retention_days",
            &self.automatic_backup_retention_days,
        );
        formatter.field("copy_tags_to_backups", &self.copy_tags_to_backups);
        formatter.field("aliases", &self.aliases);
        formatter.field("audit_log_configuration", &self.audit_log_configuration);
        formatter.finish()
    }
}
/// See [`CreateFileSystemWindowsConfiguration`](crate::model::CreateFileSystemWindowsConfiguration)
pub mod create_file_system_windows_configuration {
    /// A builder for [`CreateFileSystemWindowsConfiguration`](crate::model::CreateFileSystemWindowsConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) active_directory_id: std::option::Option<std::string::String>,
        pub(crate) self_managed_active_directory_configuration:
            std::option::Option<crate::model::SelfManagedActiveDirectoryConfiguration>,
        pub(crate) deployment_type: std::option::Option<crate::model::WindowsDeploymentType>,
        pub(crate) preferred_subnet_id: std::option::Option<std::string::String>,
        pub(crate) throughput_capacity: std::option::Option<i32>,
        pub(crate) weekly_maintenance_start_time: std::option::Option<std::string::String>,
        pub(crate) daily_automatic_backup_start_time: std::option::Option<std::string::String>,
        pub(crate) automatic_backup_retention_days: std::option::Option<i32>,
        pub(crate) copy_tags_to_backups: std::option::Option<bool>,
        pub(crate) aliases: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) audit_log_configuration:
            std::option::Option<crate::model::WindowsAuditLogCreateConfiguration>,
    }
    impl Builder {
        /// <p>The ID for an existing Amazon Web Services Managed Microsoft Active Directory (AD) instance that the
        /// file system should join when it's created.</p>
        pub fn active_directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.active_directory_id = Some(input.into());
            self
        }
        /// <p>The ID for an existing Amazon Web Services Managed Microsoft Active Directory (AD) instance that the
        /// file system should join when it's created.</p>
        pub fn set_active_directory_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.active_directory_id = input;
            self
        }
        /// <p>The configuration that Amazon FSx uses to join a FSx for Windows File Server file system or an ONTAP storage virtual machine (SVM) to
        /// a self-managed (including on-premises) Microsoft Active Directory (AD)
        /// directory. For more information, see
        /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/self-managed-AD.html">
        /// Using Amazon FSx with your self-managed Microsoft Active Directory</a> or
        /// <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html">Managing SVMs</a>.</p>
        pub fn self_managed_active_directory_configuration(
            mut self,
            input: crate::model::SelfManagedActiveDirectoryConfiguration,
        ) -> Self {
            self.self_managed_active_directory_configuration = Some(input);
            self
        }
        /// <p>The configuration that Amazon FSx uses to join a FSx for Windows File Server file system or an ONTAP storage virtual machine (SVM) to
        /// a self-managed (including on-premises) Microsoft Active Directory (AD)
        /// directory. For more information, see
        /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/self-managed-AD.html">
        /// Using Amazon FSx with your self-managed Microsoft Active Directory</a> or
        /// <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html">Managing SVMs</a>.</p>
        pub fn set_self_managed_active_directory_configuration(
            mut self,
            input: std::option::Option<crate::model::SelfManagedActiveDirectoryConfiguration>,
        ) -> Self {
            self.self_managed_active_directory_configuration = input;
            self
        }
        /// <p>Specifies the file system deployment type, valid values are the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>MULTI_AZ_1</code> - Deploys a high availability file system that is configured
        /// for Multi-AZ redundancy to tolerate temporary Availability Zone (AZ) unavailability. You
        /// can only deploy a Multi-AZ file system in Amazon Web Services Regions that have a minimum of three Availability Zones. Also
        /// supports HDD storage type</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SINGLE_AZ_1</code> - (Default) Choose to deploy a file system that is configured for single AZ redundancy.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SINGLE_AZ_2</code> - The latest generation Single AZ file system.
        /// Specifies a file system that is configured for single AZ redundancy and supports HDD storage type.</p>
        /// </li>
        /// </ul>
        /// <p>For more information, see
        /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html">
        /// Availability and Durability: Single-AZ and Multi-AZ File Systems</a>.</p>
        pub fn deployment_type(mut self, input: crate::model::WindowsDeploymentType) -> Self {
            self.deployment_type = Some(input);
            self
        }
        /// <p>Specifies the file system deployment type, valid values are the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>MULTI_AZ_1</code> - Deploys a high availability file system that is configured
        /// for Multi-AZ redundancy to tolerate temporary Availability Zone (AZ) unavailability. You
        /// can only deploy a Multi-AZ file system in Amazon Web Services Regions that have a minimum of three Availability Zones. Also
        /// supports HDD storage type</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SINGLE_AZ_1</code> - (Default) Choose to deploy a file system that is configured for single AZ redundancy.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SINGLE_AZ_2</code> - The latest generation Single AZ file system.
        /// Specifies a file system that is configured for single AZ redundancy and supports HDD storage type.</p>
        /// </li>
        /// </ul>
        /// <p>For more information, see
        /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html">
        /// Availability and Durability: Single-AZ and Multi-AZ File Systems</a>.</p>
        pub fn set_deployment_type(
            mut self,
            input: std::option::Option<crate::model::WindowsDeploymentType>,
        ) -> Self {
            self.deployment_type = input;
            self
        }
        /// <p>Required when <code>DeploymentType</code> is set to <code>MULTI_AZ_1</code>. This specifies the subnet
        /// in which you want the preferred file server to be located. For in-Amazon Web Services applications, we recommend that you launch
        /// your clients in the same Availability Zone (AZ) as your preferred file server to reduce cross-AZ
        /// data transfer costs and minimize latency. </p>
        pub fn preferred_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.preferred_subnet_id = Some(input.into());
            self
        }
        /// <p>Required when <code>DeploymentType</code> is set to <code>MULTI_AZ_1</code>. This specifies the subnet
        /// in which you want the preferred file server to be located. For in-Amazon Web Services applications, we recommend that you launch
        /// your clients in the same Availability Zone (AZ) as your preferred file server to reduce cross-AZ
        /// data transfer costs and minimize latency. </p>
        pub fn set_preferred_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_subnet_id = input;
            self
        }
        /// <p>The throughput of an Amazon FSx file system, measured in megabytes per second, in 2 to
        /// the <i>n</i>th increments, between 2^3 (8) and 2^11 (2048).</p>
        pub fn throughput_capacity(mut self, input: i32) -> Self {
            self.throughput_capacity = Some(input);
            self
        }
        /// <p>The throughput of an Amazon FSx file system, measured in megabytes per second, in 2 to
        /// the <i>n</i>th increments, between 2^3 (8) and 2^11 (2048).</p>
        pub fn set_throughput_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.throughput_capacity = input;
            self
        }
        /// <p>The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC
        /// time zone, where d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.</p>
        pub fn weekly_maintenance_start_time(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.weekly_maintenance_start_time = Some(input.into());
            self
        }
        /// <p>The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC
        /// time zone, where d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.</p>
        pub fn set_weekly_maintenance_start_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.weekly_maintenance_start_time = input;
            self
        }
        /// <p>The preferred time to take daily automatic backups, formatted HH:MM in the UTC time
        /// zone.</p>
        pub fn daily_automatic_backup_start_time(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.daily_automatic_backup_start_time = Some(input.into());
            self
        }
        /// <p>The preferred time to take daily automatic backups, formatted HH:MM in the UTC time
        /// zone.</p>
        pub fn set_daily_automatic_backup_start_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.daily_automatic_backup_start_time = input;
            self
        }
        /// <p>The number of days to retain automatic backups. The default is to retain backups for 7
        /// days. Setting this value to 0 disables the creation of automatic backups. The maximum
        /// retention period for backups is 90 days.</p>
        pub fn automatic_backup_retention_days(mut self, input: i32) -> Self {
            self.automatic_backup_retention_days = Some(input);
            self
        }
        /// <p>The number of days to retain automatic backups. The default is to retain backups for 7
        /// days. Setting this value to 0 disables the creation of automatic backups. The maximum
        /// retention period for backups is 90 days.</p>
        pub fn set_automatic_backup_retention_days(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.automatic_backup_retention_days = input;
            self
        }
        /// <p>A boolean flag indicating whether tags for the file system should be copied to
        /// backups. This value defaults to false. If it's set to true, all tags for the file
        /// system are copied to all automatic and user-initiated backups where the user
        /// doesn't specify tags. If this value is true, and you specify one or more tags, only
        /// the specified tags are copied to backups. If you specify one or more tags when creating a
        /// user-initiated backup, no tags are copied from the file system, regardless of this value.</p>
        pub fn copy_tags_to_backups(mut self, input: bool) -> Self {
            self.copy_tags_to_backups = Some(input);
            self
        }
        /// <p>A boolean flag indicating whether tags for the file system should be copied to
        /// backups. This value defaults to false. If it's set to true, all tags for the file
        /// system are copied to all automatic and user-initiated backups where the user
        /// doesn't specify tags. If this value is true, and you specify one or more tags, only
        /// the specified tags are copied to backups. If you specify one or more tags when creating a
        /// user-initiated backup, no tags are copied from the file system, regardless of this value.</p>
        pub fn set_copy_tags_to_backups(mut self, input: std::option::Option<bool>) -> Self {
            self.copy_tags_to_backups = input;
            self
        }
        /// Appends an item to `aliases`.
        ///
        /// To override the contents of this collection use [`set_aliases`](Self::set_aliases).
        ///
        /// <p>An array of one or more DNS alias names that you want to associate with the Amazon FSx file system.
        /// Aliases allow you to use existing DNS names to access the data in your Amazon FSx file system.
        /// You can associate up to 50 aliases with a file system at any time.
        /// You can associate additional DNS aliases after you create the file system using the AssociateFileSystemAliases operation.
        /// You can remove DNS aliases from the file system after it is created using the DisassociateFileSystemAliases operation.
        /// You only need to specify the alias name in the request payload.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html">Working with DNS Aliases</a> and
        /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/walkthrough05-file-system-custom-CNAME.html">Walkthrough 5: Using DNS aliases to access your file system</a>, including
        /// additional steps you must take to be able to access your file system using a DNS alias.</p>
        /// <p>An alias name has to meet the following requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Formatted as a fully-qualified domain name (FQDN), <code>hostname.domain</code>, for example, <code>accounting.example.com</code>.</p>
        /// </li>
        /// <li>
        /// <p>Can contain alphanumeric characters, the underscore (_), and the hyphen (-).</p>
        /// </li>
        /// <li>
        /// <p>Cannot start or end with a hyphen.</p>
        /// </li>
        /// <li>
        /// <p>Can start with a numeric.</p>
        /// </li>
        /// </ul>
        /// <p>For DNS alias names, Amazon FSx stores alphabetic characters as lowercase letters (a-z), regardless of how you specify them:
        /// as uppercase letters, lowercase letters, or the corresponding letters in escape codes.</p>
        pub fn aliases(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.aliases.unwrap_or_default();
            v.push(input.into());
            self.aliases = Some(v);
            self
        }
        /// <p>An array of one or more DNS alias names that you want to associate with the Amazon FSx file system.
        /// Aliases allow you to use existing DNS names to access the data in your Amazon FSx file system.
        /// You can associate up to 50 aliases with a file system at any time.
        /// You can associate additional DNS aliases after you create the file system using the AssociateFileSystemAliases operation.
        /// You can remove DNS aliases from the file system after it is created using the DisassociateFileSystemAliases operation.
        /// You only need to specify the alias name in the request payload.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html">Working with DNS Aliases</a> and
        /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/walkthrough05-file-system-custom-CNAME.html">Walkthrough 5: Using DNS aliases to access your file system</a>, including
        /// additional steps you must take to be able to access your file system using a DNS alias.</p>
        /// <p>An alias name has to meet the following requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Formatted as a fully-qualified domain name (FQDN), <code>hostname.domain</code>, for example, <code>accounting.example.com</code>.</p>
        /// </li>
        /// <li>
        /// <p>Can contain alphanumeric characters, the underscore (_), and the hyphen (-).</p>
        /// </li>
        /// <li>
        /// <p>Cannot start or end with a hyphen.</p>
        /// </li>
        /// <li>
        /// <p>Can start with a numeric.</p>
        /// </li>
        /// </ul>
        /// <p>For DNS alias names, Amazon FSx stores alphabetic characters as lowercase letters (a-z), regardless of how you specify them:
        /// as uppercase letters, lowercase letters, or the corresponding letters in escape codes.</p>
        pub fn set_aliases(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.aliases = input;
            self
        }
        /// <p>The configuration that Amazon FSx for Windows File Server uses to audit and log
        /// user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server
        /// file system.</p>
        pub fn audit_log_configuration(
            mut self,
            input: crate::model::WindowsAuditLogCreateConfiguration,
        ) -> Self {
            self.audit_log_configuration = Some(input);
            self
        }
        /// <p>The configuration that Amazon FSx for Windows File Server uses to audit and log
        /// user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server
        /// file system.</p>
        pub fn set_audit_log_configuration(
            mut self,
            input: std::option::Option<crate::model::WindowsAuditLogCreateConfiguration>,
        ) -> Self {
            self.audit_log_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFileSystemWindowsConfiguration`](crate::model::CreateFileSystemWindowsConfiguration)
        pub fn build(self) -> crate::model::CreateFileSystemWindowsConfiguration {
            crate::model::CreateFileSystemWindowsConfiguration {
                active_directory_id: self.active_directory_id,
                self_managed_active_directory_configuration: self
                    .self_managed_active_directory_configuration,
                deployment_type: self.deployment_type,
                preferred_subnet_id: self.preferred_subnet_id,
                throughput_capacity: self.throughput_capacity,
                weekly_maintenance_start_time: self.weekly_maintenance_start_time,
                daily_automatic_backup_start_time: self.daily_automatic_backup_start_time,
                automatic_backup_retention_days: self.automatic_backup_retention_days,
                copy_tags_to_backups: self.copy_tags_to_backups,
                aliases: self.aliases,
                audit_log_configuration: self.audit_log_configuration,
            }
        }
    }
}
impl CreateFileSystemWindowsConfiguration {
    /// Creates a new builder-style object to manufacture [`CreateFileSystemWindowsConfiguration`](crate::model::CreateFileSystemWindowsConfiguration)
    pub fn builder() -> crate::model::create_file_system_windows_configuration::Builder {
        crate::model::create_file_system_windows_configuration::Builder::default()
    }
}

/// <p>The ONTAP configuration properties of the FSx for NetApp ONTAP file system that you are creating.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFileSystemOntapConfiguration {
    /// <p>The number of days to retain automatic backups. Setting this to 0 disables
    /// automatic backups. You can retain automatic backups for a maximum of 90 days. The default is 0.</p>
    pub automatic_backup_retention_days: std::option::Option<i32>,
    /// <p>A recurring daily time, in the format <code>HH:MM</code>. <code>HH</code> is the
    /// zero-padded hour of the day (0-23), and <code>MM</code> is the zero-padded minute of the
    /// hour. For example, <code>05:00</code> specifies 5 AM daily. </p>
    pub daily_automatic_backup_start_time: std::option::Option<std::string::String>,
    /// <p>Specifies the ONTAP file system deployment type to use in creating the file system.</p>
    pub deployment_type: std::option::Option<crate::model::OntapDeploymentType>,
    /// <p>Specifies the IP address range in which the endpoints to access your file system
    /// will be created. By default, Amazon FSx selects an unused IP address range for you
    /// from the 198.19.* range.</p>
    pub endpoint_ip_address_range: std::option::Option<std::string::String>,
    /// <p>The ONTAP administrative password for the <code>fsxadmin</code> user that you can
    /// use to administer your file system using the ONTAP CLI and REST API.</p>
    pub fsx_admin_password: std::option::Option<std::string::String>,
    /// <p>The SSD IOPS configuration for the Amazon FSx for NetApp ONTAP file system.</p>
    pub disk_iops_configuration: std::option::Option<crate::model::DiskIopsConfiguration>,
    /// <p>The ID for a subnet. A <i>subnet</i> is a range of IP addresses in
    /// your virtual private cloud (VPC). For more information, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Subnets.html">VPC and Subnets</a> in the
    /// <i>Amazon VPC User Guide.</i>
    /// </p>
    pub preferred_subnet_id: std::option::Option<std::string::String>,
    /// <p>Specifies the VPC route tables in which your file system's endpoints will be
    /// created. You should specify all VPC route tables associated with the subnets
    /// in which your clients are located. By default, Amazon FSx selects your VPC's
    /// default route table.</p>
    pub route_table_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Sustained throughput of an Amazon FSx file system in MBps.</p>
    pub throughput_capacity: std::option::Option<i32>,
    /// <p>A recurring weekly time, in the format <code>D:HH:MM</code>. </p>
    /// <p>
    /// <code>D</code> is the day of the week, for which 1 represents Monday and 7
    /// represents Sunday. For further details, see <a href="https://en.wikipedia.org/wiki/ISO_week_date">the ISO-8601 spec as described on Wikipedia</a>.</p>
    /// <p>
    /// <code>HH</code> is the zero-padded hour of the day (0-23), and <code>MM</code> is
    /// the zero-padded minute of the hour. </p>
    /// <p>For example, <code>1:05:00</code> specifies maintenance at 5 AM Monday.</p>
    pub weekly_maintenance_start_time: std::option::Option<std::string::String>,
}
impl CreateFileSystemOntapConfiguration {
    /// <p>The number of days to retain automatic backups. Setting this to 0 disables
    /// automatic backups. You can retain automatic backups for a maximum of 90 days. The default is 0.</p>
    pub fn automatic_backup_retention_days(&self) -> std::option::Option<i32> {
        self.automatic_backup_retention_days
    }
    /// <p>A recurring daily time, in the format <code>HH:MM</code>. <code>HH</code> is the
    /// zero-padded hour of the day (0-23), and <code>MM</code> is the zero-padded minute of the
    /// hour. For example, <code>05:00</code> specifies 5 AM daily. </p>
    pub fn daily_automatic_backup_start_time(&self) -> std::option::Option<&str> {
        self.daily_automatic_backup_start_time.as_deref()
    }
    /// <p>Specifies the ONTAP file system deployment type to use in creating the file system.</p>
    pub fn deployment_type(&self) -> std::option::Option<&crate::model::OntapDeploymentType> {
        self.deployment_type.as_ref()
    }
    /// <p>Specifies the IP address range in which the endpoints to access your file system
    /// will be created. By default, Amazon FSx selects an unused IP address range for you
    /// from the 198.19.* range.</p>
    pub fn endpoint_ip_address_range(&self) -> std::option::Option<&str> {
        self.endpoint_ip_address_range.as_deref()
    }
    /// <p>The ONTAP administrative password for the <code>fsxadmin</code> user that you can
    /// use to administer your file system using the ONTAP CLI and REST API.</p>
    pub fn fsx_admin_password(&self) -> std::option::Option<&str> {
        self.fsx_admin_password.as_deref()
    }
    /// <p>The SSD IOPS configuration for the Amazon FSx for NetApp ONTAP file system.</p>
    pub fn disk_iops_configuration(
        &self,
    ) -> std::option::Option<&crate::model::DiskIopsConfiguration> {
        self.disk_iops_configuration.as_ref()
    }
    /// <p>The ID for a subnet. A <i>subnet</i> is a range of IP addresses in
    /// your virtual private cloud (VPC). For more information, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Subnets.html">VPC and Subnets</a> in the
    /// <i>Amazon VPC User Guide.</i>
    /// </p>
    pub fn preferred_subnet_id(&self) -> std::option::Option<&str> {
        self.preferred_subnet_id.as_deref()
    }
    /// <p>Specifies the VPC route tables in which your file system's endpoints will be
    /// created. You should specify all VPC route tables associated with the subnets
    /// in which your clients are located. By default, Amazon FSx selects your VPC's
    /// default route table.</p>
    pub fn route_table_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.route_table_ids.as_deref()
    }
    /// <p>Sustained throughput of an Amazon FSx file system in MBps.</p>
    pub fn throughput_capacity(&self) -> std::option::Option<i32> {
        self.throughput_capacity
    }
    /// <p>A recurring weekly time, in the format <code>D:HH:MM</code>. </p>
    /// <p>
    /// <code>D</code> is the day of the week, for which 1 represents Monday and 7
    /// represents Sunday. For further details, see <a href="https://en.wikipedia.org/wiki/ISO_week_date">the ISO-8601 spec as described on Wikipedia</a>.</p>
    /// <p>
    /// <code>HH</code> is the zero-padded hour of the day (0-23), and <code>MM</code> is
    /// the zero-padded minute of the hour. </p>
    /// <p>For example, <code>1:05:00</code> specifies maintenance at 5 AM Monday.</p>
    pub fn weekly_maintenance_start_time(&self) -> std::option::Option<&str> {
        self.weekly_maintenance_start_time.as_deref()
    }
}
impl std::fmt::Debug for CreateFileSystemOntapConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFileSystemOntapConfiguration");
        formatter.field(
            "automatic_backup_retention_days",
            &self.automatic_backup_retention_days,
        );
        formatter.field(
            "daily_automatic_backup_start_time",
            &self.daily_automatic_backup_start_time,
        );
        formatter.field("deployment_type", &self.deployment_type);
        formatter.field("endpoint_ip_address_range", &self.endpoint_ip_address_range);
        formatter.field("fsx_admin_password", &"*** Sensitive Data Redacted ***");
        formatter.field("disk_iops_configuration", &self.disk_iops_configuration);
        formatter.field("preferred_subnet_id", &self.preferred_subnet_id);
        formatter.field("route_table_ids", &self.route_table_ids);
        formatter.field("throughput_capacity", &self.throughput_capacity);
        formatter.field(
            "weekly_maintenance_start_time",
            &self.weekly_maintenance_start_time,
        );
        formatter.finish()
    }
}
/// See [`CreateFileSystemOntapConfiguration`](crate::model::CreateFileSystemOntapConfiguration)
pub mod create_file_system_ontap_configuration {
    /// A builder for [`CreateFileSystemOntapConfiguration`](crate::model::CreateFileSystemOntapConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) automatic_backup_retention_days: std::option::Option<i32>,
        pub(crate) daily_automatic_backup_start_time: std::option::Option<std::string::String>,
        pub(crate) deployment_type: std::option::Option<crate::model::OntapDeploymentType>,
        pub(crate) endpoint_ip_address_range: std::option::Option<std::string::String>,
        pub(crate) fsx_admin_password: std::option::Option<std::string::String>,
        pub(crate) disk_iops_configuration:
            std::option::Option<crate::model::DiskIopsConfiguration>,
        pub(crate) preferred_subnet_id: std::option::Option<std::string::String>,
        pub(crate) route_table_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) throughput_capacity: std::option::Option<i32>,
        pub(crate) weekly_maintenance_start_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The number of days to retain automatic backups. Setting this to 0 disables
        /// automatic backups. You can retain automatic backups for a maximum of 90 days. The default is 0.</p>
        pub fn automatic_backup_retention_days(mut self, input: i32) -> Self {
            self.automatic_backup_retention_days = Some(input);
            self
        }
        /// <p>The number of days to retain automatic backups. Setting this to 0 disables
        /// automatic backups. You can retain automatic backups for a maximum of 90 days. The default is 0.</p>
        pub fn set_automatic_backup_retention_days(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.automatic_backup_retention_days = input;
            self
        }
        /// <p>A recurring daily time, in the format <code>HH:MM</code>. <code>HH</code> is the
        /// zero-padded hour of the day (0-23), and <code>MM</code> is the zero-padded minute of the
        /// hour. For example, <code>05:00</code> specifies 5 AM daily. </p>
        pub fn daily_automatic_backup_start_time(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.daily_automatic_backup_start_time = Some(input.into());
            self
        }
        /// <p>A recurring daily time, in the format <code>HH:MM</code>. <code>HH</code> is the
        /// zero-padded hour of the day (0-23), and <code>MM</code> is the zero-padded minute of the
        /// hour. For example, <code>05:00</code> specifies 5 AM daily. </p>
        pub fn set_daily_automatic_backup_start_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.daily_automatic_backup_start_time = input;
            self
        }
        /// <p>Specifies the ONTAP file system deployment type to use in creating the file system.</p>
        pub fn deployment_type(mut self, input: crate::model::OntapDeploymentType) -> Self {
            self.deployment_type = Some(input);
            self
        }
        /// <p>Specifies the ONTAP file system deployment type to use in creating the file system.</p>
        pub fn set_deployment_type(
            mut self,
            input: std::option::Option<crate::model::OntapDeploymentType>,
        ) -> Self {
            self.deployment_type = input;
            self
        }
        /// <p>Specifies the IP address range in which the endpoints to access your file system
        /// will be created. By default, Amazon FSx selects an unused IP address range for you
        /// from the 198.19.* range.</p>
        pub fn endpoint_ip_address_range(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_ip_address_range = Some(input.into());
            self
        }
        /// <p>Specifies the IP address range in which the endpoints to access your file system
        /// will be created. By default, Amazon FSx selects an unused IP address range for you
        /// from the 198.19.* range.</p>
        pub fn set_endpoint_ip_address_range(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_ip_address_range = input;
            self
        }
        /// <p>The ONTAP administrative password for the <code>fsxadmin</code> user that you can
        /// use to administer your file system using the ONTAP CLI and REST API.</p>
        pub fn fsx_admin_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.fsx_admin_password = Some(input.into());
            self
        }
        /// <p>The ONTAP administrative password for the <code>fsxadmin</code> user that you can
        /// use to administer your file system using the ONTAP CLI and REST API.</p>
        pub fn set_fsx_admin_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.fsx_admin_password = input;
            self
        }
        /// <p>The SSD IOPS configuration for the Amazon FSx for NetApp ONTAP file system.</p>
        pub fn disk_iops_configuration(
            mut self,
            input: crate::model::DiskIopsConfiguration,
        ) -> Self {
            self.disk_iops_configuration = Some(input);
            self
        }
        /// <p>The SSD IOPS configuration for the Amazon FSx for NetApp ONTAP file system.</p>
        pub fn set_disk_iops_configuration(
            mut self,
            input: std::option::Option<crate::model::DiskIopsConfiguration>,
        ) -> Self {
            self.disk_iops_configuration = input;
            self
        }
        /// <p>The ID for a subnet. A <i>subnet</i> is a range of IP addresses in
        /// your virtual private cloud (VPC). For more information, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Subnets.html">VPC and Subnets</a> in the
        /// <i>Amazon VPC User Guide.</i>
        /// </p>
        pub fn preferred_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.preferred_subnet_id = Some(input.into());
            self
        }
        /// <p>The ID for a subnet. A <i>subnet</i> is a range of IP addresses in
        /// your virtual private cloud (VPC). For more information, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Subnets.html">VPC and Subnets</a> in the
        /// <i>Amazon VPC User Guide.</i>
        /// </p>
        pub fn set_preferred_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_subnet_id = input;
            self
        }
        /// Appends an item to `route_table_ids`.
        ///
        /// To override the contents of this collection use [`set_route_table_ids`](Self::set_route_table_ids).
        ///
        /// <p>Specifies the VPC route tables in which your file system's endpoints will be
        /// created. You should specify all VPC route tables associated with the subnets
        /// in which your clients are located. By default, Amazon FSx selects your VPC's
        /// default route table.</p>
        pub fn route_table_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.route_table_ids.unwrap_or_default();
            v.push(input.into());
            self.route_table_ids = Some(v);
            self
        }
        /// <p>Specifies the VPC route tables in which your file system's endpoints will be
        /// created. You should specify all VPC route tables associated with the subnets
        /// in which your clients are located. By default, Amazon FSx selects your VPC's
        /// default route table.</p>
        pub fn set_route_table_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.route_table_ids = input;
            self
        }
        /// <p>Sustained throughput of an Amazon FSx file system in MBps.</p>
        pub fn throughput_capacity(mut self, input: i32) -> Self {
            self.throughput_capacity = Some(input);
            self
        }
        /// <p>Sustained throughput of an Amazon FSx file system in MBps.</p>
        pub fn set_throughput_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.throughput_capacity = input;
            self
        }
        /// <p>A recurring weekly time, in the format <code>D:HH:MM</code>. </p>
        /// <p>
        /// <code>D</code> is the day of the week, for which 1 represents Monday and 7
        /// represents Sunday. For further details, see <a href="https://en.wikipedia.org/wiki/ISO_week_date">the ISO-8601 spec as described on Wikipedia</a>.</p>
        /// <p>
        /// <code>HH</code> is the zero-padded hour of the day (0-23), and <code>MM</code> is
        /// the zero-padded minute of the hour. </p>
        /// <p>For example, <code>1:05:00</code> specifies maintenance at 5 AM Monday.</p>
        pub fn weekly_maintenance_start_time(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.weekly_maintenance_start_time = Some(input.into());
            self
        }
        /// <p>A recurring weekly time, in the format <code>D:HH:MM</code>. </p>
        /// <p>
        /// <code>D</code> is the day of the week, for which 1 represents Monday and 7
        /// represents Sunday. For further details, see <a href="https://en.wikipedia.org/wiki/ISO_week_date">the ISO-8601 spec as described on Wikipedia</a>.</p>
        /// <p>
        /// <code>HH</code> is the zero-padded hour of the day (0-23), and <code>MM</code> is
        /// the zero-padded minute of the hour. </p>
        /// <p>For example, <code>1:05:00</code> specifies maintenance at 5 AM Monday.</p>
        pub fn set_weekly_maintenance_start_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.weekly_maintenance_start_time = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFileSystemOntapConfiguration`](crate::model::CreateFileSystemOntapConfiguration)
        pub fn build(self) -> crate::model::CreateFileSystemOntapConfiguration {
            crate::model::CreateFileSystemOntapConfiguration {
                automatic_backup_retention_days: self.automatic_backup_retention_days,
                daily_automatic_backup_start_time: self.daily_automatic_backup_start_time,
                deployment_type: self.deployment_type,
                endpoint_ip_address_range: self.endpoint_ip_address_range,
                fsx_admin_password: self.fsx_admin_password,
                disk_iops_configuration: self.disk_iops_configuration,
                preferred_subnet_id: self.preferred_subnet_id,
                route_table_ids: self.route_table_ids,
                throughput_capacity: self.throughput_capacity,
                weekly_maintenance_start_time: self.weekly_maintenance_start_time,
            }
        }
    }
}
impl CreateFileSystemOntapConfiguration {
    /// Creates a new builder-style object to manufacture [`CreateFileSystemOntapConfiguration`](crate::model::CreateFileSystemOntapConfiguration)
    pub fn builder() -> crate::model::create_file_system_ontap_configuration::Builder {
        crate::model::create_file_system_ontap_configuration::Builder::default()
    }
}
