// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AssociateFileSystemAliasesInput`](crate::input::AssociateFileSystemAliasesInput)
pub mod associate_file_system_aliases_input {
    /// A builder for [`AssociateFileSystemAliasesInput`](crate::input::AssociateFileSystemAliasesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) aliases: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
        /// ASCII characters. This token is automatically filled on your behalf when you use the
        /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
        /// ASCII characters. This token is automatically filled on your behalf when you use the
        /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>Specifies the file system with which you want to associate one or more DNS aliases.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>Specifies the file system with which you want to associate one or more DNS aliases.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// Appends an item to `aliases`.
        ///
        /// To override the contents of this collection use [`set_aliases`](Self::set_aliases).
        ///
        /// <p>An array of one or more DNS alias names to associate with the file system.
        /// The alias name has to comply with the following formatting requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Formatted as a fully-qualified domain name (FQDN), <i>
        /// <code>hostname.domain</code>
        /// </i>,
        /// for example, <code>accounting.corp.example.com</code>.</p>
        /// </li>
        /// <li>
        /// <p>Can contain alphanumeric characters and the hyphen (-).</p>
        /// </li>
        /// <li>
        /// <p>Cannot start or end with a hyphen.</p>
        /// </li>
        /// <li>
        /// <p>Can start with a numeric.</p>
        /// </li>
        /// </ul>
        /// <p>For DNS alias names, Amazon FSx stores alphabetic characters as lowercase letters (a-z), regardless of how you specify them:
        /// as uppercase letters, lowercase letters, or the corresponding letters in escape codes.</p>
        pub fn aliases(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.aliases.unwrap_or_default();
            v.push(input.into());
            self.aliases = Some(v);
            self
        }
        /// <p>An array of one or more DNS alias names to associate with the file system.
        /// The alias name has to comply with the following formatting requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Formatted as a fully-qualified domain name (FQDN), <i>
        /// <code>hostname.domain</code>
        /// </i>,
        /// for example, <code>accounting.corp.example.com</code>.</p>
        /// </li>
        /// <li>
        /// <p>Can contain alphanumeric characters and the hyphen (-).</p>
        /// </li>
        /// <li>
        /// <p>Cannot start or end with a hyphen.</p>
        /// </li>
        /// <li>
        /// <p>Can start with a numeric.</p>
        /// </li>
        /// </ul>
        /// <p>For DNS alias names, Amazon FSx stores alphabetic characters as lowercase letters (a-z), regardless of how you specify them:
        /// as uppercase letters, lowercase letters, or the corresponding letters in escape codes.</p>
        pub fn set_aliases(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.aliases = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateFileSystemAliasesInput`](crate::input::AssociateFileSystemAliasesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateFileSystemAliasesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateFileSystemAliasesInput {
                client_request_token: self.client_request_token,
                file_system_id: self.file_system_id,
                aliases: self.aliases,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateFileSystemAliasesInputOperationOutputAlias =
    crate::operation::AssociateFileSystemAliases;
#[doc(hidden)]
pub type AssociateFileSystemAliasesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateFileSystemAliasesInput {
    /// Consumes the builder and constructs an Operation<[`AssociateFileSystemAliases`](crate::operation::AssociateFileSystemAliases)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateFileSystemAliases,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateFileSystemAliasesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateFileSystemAliasesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateFileSystemAliasesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSimbaAPIService_v20180301.AssociateFileSystemAliases",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_file_system_aliases(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateFileSystemAliases::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateFileSystemAliases",
            "fsx",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateFileSystemAliasesInput`](crate::input::AssociateFileSystemAliasesInput)
    pub fn builder() -> crate::input::associate_file_system_aliases_input::Builder {
        crate::input::associate_file_system_aliases_input::Builder::default()
    }
}

/// See [`CancelDataRepositoryTaskInput`](crate::input::CancelDataRepositoryTaskInput)
pub mod cancel_data_repository_task_input {
    /// A builder for [`CancelDataRepositoryTaskInput`](crate::input::CancelDataRepositoryTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the data repository task to cancel.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_id = Some(input.into());
            self
        }
        /// <p>Specifies the data repository task to cancel.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelDataRepositoryTaskInput`](crate::input::CancelDataRepositoryTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelDataRepositoryTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelDataRepositoryTaskInput {
                task_id: self.task_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelDataRepositoryTaskInputOperationOutputAlias =
    crate::operation::CancelDataRepositoryTask;
#[doc(hidden)]
pub type CancelDataRepositoryTaskInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CancelDataRepositoryTaskInput {
    /// Consumes the builder and constructs an Operation<[`CancelDataRepositoryTask`](crate::operation::CancelDataRepositoryTask)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelDataRepositoryTask,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CancelDataRepositoryTaskInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CancelDataRepositoryTaskInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CancelDataRepositoryTaskInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSimbaAPIService_v20180301.CancelDataRepositoryTask",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_cancel_data_repository_task(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelDataRepositoryTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelDataRepositoryTask",
            "fsx",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CancelDataRepositoryTaskInput`](crate::input::CancelDataRepositoryTaskInput)
    pub fn builder() -> crate::input::cancel_data_repository_task_input::Builder {
        crate::input::cancel_data_repository_task_input::Builder::default()
    }
}

/// See [`CopyBackupInput`](crate::input::CopyBackupInput)
pub mod copy_backup_input {
    /// A builder for [`CopyBackupInput`](crate::input::CopyBackupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) source_backup_id: std::option::Option<std::string::String>,
        pub(crate) source_region: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) copy_tags: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
        /// ASCII characters. This token is automatically filled on your behalf when you use the
        /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
        /// ASCII characters. This token is automatically filled on your behalf when you use the
        /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The ID of the source backup. Specifies the ID of the backup that is
        /// being copied.</p>
        pub fn source_backup_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_backup_id = Some(input.into());
            self
        }
        /// <p>The ID of the source backup. Specifies the ID of the backup that is
        /// being copied.</p>
        pub fn set_source_backup_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_backup_id = input;
            self
        }
        /// <p>The source Amazon Web Services Region of the backup. Specifies the Amazon Web Services Region from which
        /// the backup is being copied. The source and destination Regions must be in
        /// the same Amazon Web Services partition. If you don't specify a Region, it defaults to
        /// the Region where the request is sent from (in-Region copy).</p>
        pub fn source_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_region = Some(input.into());
            self
        }
        /// <p>The source Amazon Web Services Region of the backup. Specifies the Amazon Web Services Region from which
        /// the backup is being copied. The source and destination Regions must be in
        /// the same Amazon Web Services partition. If you don't specify a Region, it defaults to
        /// the Region where the request is sent from (in-Region copy).</p>
        pub fn set_source_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_region = input;
            self
        }
        /// <p>The ID of the Key Management Service (KMS) key used to encrypt the file system's data
        /// for Amazon FSx for Windows File Server file systems, Amazon FSx for NetApp ONTAP file systems, and
        /// Amazon FSx for Lustre <code>PERSISTENT_1</code> file systems at rest. If not specified, the Amazon FSx
        /// managed key is used. The Amazon FSx for Lustre <code>SCRATCH_1</code> and <code>SCRATCH_2</code> file systems
        /// are always encrypted at rest using Amazon FSx managed keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html">Encrypt</a>
        /// in the <i>Key Management Service API Reference</i>.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID of the Key Management Service (KMS) key used to encrypt the file system's data
        /// for Amazon FSx for Windows File Server file systems, Amazon FSx for NetApp ONTAP file systems, and
        /// Amazon FSx for Lustre <code>PERSISTENT_1</code> file systems at rest. If not specified, the Amazon FSx
        /// managed key is used. The Amazon FSx for Lustre <code>SCRATCH_1</code> and <code>SCRATCH_2</code> file systems
        /// are always encrypted at rest using Amazon FSx managed keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html">Encrypt</a>
        /// in the <i>Key Management Service API Reference</i>.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>A boolean flag indicating whether tags from the source backup
        /// should be copied to the backup copy. This value defaults to false.</p>
        /// <p>If you set <code>CopyTags</code> to true and the source backup has
        /// existing tags, you can use the <code>Tags</code> parameter to create new
        /// tags, provided that the sum of the source backup tags and the new tags
        /// doesn't exceed 50. Both sets of tags are merged. If there are tag
        /// conflicts (for example, two tags with the same key but different values),
        /// the tags created with the <code>Tags</code> parameter take precedence.</p>
        pub fn copy_tags(mut self, input: bool) -> Self {
            self.copy_tags = Some(input);
            self
        }
        /// <p>A boolean flag indicating whether tags from the source backup
        /// should be copied to the backup copy. This value defaults to false.</p>
        /// <p>If you set <code>CopyTags</code> to true and the source backup has
        /// existing tags, you can use the <code>Tags</code> parameter to create new
        /// tags, provided that the sum of the source backup tags and the new tags
        /// doesn't exceed 50. Both sets of tags are merged. If there are tag
        /// conflicts (for example, two tags with the same key but different values),
        /// the tags created with the <code>Tags</code> parameter take precedence.</p>
        pub fn set_copy_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.copy_tags = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyBackupInput`](crate::input::CopyBackupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CopyBackupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CopyBackupInput {
                client_request_token: self.client_request_token,
                source_backup_id: self.source_backup_id,
                source_region: self.source_region,
                kms_key_id: self.kms_key_id,
                copy_tags: self.copy_tags,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CopyBackupInputOperationOutputAlias = crate::operation::CopyBackup;
#[doc(hidden)]
pub type CopyBackupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CopyBackupInput {
    /// Consumes the builder and constructs an Operation<[`CopyBackup`](crate::operation::CopyBackup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CopyBackup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CopyBackupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CopyBackupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CopyBackupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSimbaAPIService_v20180301.CopyBackup",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_copy_backup(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CopyBackup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CopyBackup",
            "fsx",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CopyBackupInput`](crate::input::CopyBackupInput)
    pub fn builder() -> crate::input::copy_backup_input::Builder {
        crate::input::copy_backup_input::Builder::default()
    }
}

/// See [`CreateBackupInput`](crate::input::CreateBackupInput)
pub mod create_backup_input {
    /// A builder for [`CreateBackupInput`](crate::input::CreateBackupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) volume_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the file system to back up.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>The ID of the file system to back up.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// <p>(Optional) A string of up to 64 ASCII characters that Amazon FSx uses to ensure
        /// idempotent creation. This string is automatically filled on your behalf when you use the
        /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>(Optional) A string of up to 64 ASCII characters that Amazon FSx uses to ensure
        /// idempotent creation. This string is automatically filled on your behalf when you use the
        /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>(Optional) The tags to apply to the backup at backup creation. The key value of the
        /// <code>Name</code> tag appears in the console as the backup name. If you have set <code>CopyTagsToBackups</code> to true, and
        /// you specify one or more tags using the <code>CreateBackup</code> action, no existing file system tags are copied from the file system to the backup.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>(Optional) The tags to apply to the backup at backup creation. The key value of the
        /// <code>Name</code> tag appears in the console as the backup name. If you have set <code>CopyTagsToBackups</code> to true, and
        /// you specify one or more tags using the <code>CreateBackup</code> action, no existing file system tags are copied from the file system to the backup.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The ID of he FSx for NetApp ONTAP volume to back up.</p>
        pub fn volume_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_id = Some(input.into());
            self
        }
        /// <p>The ID of he FSx for NetApp ONTAP volume to back up.</p>
        pub fn set_volume_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBackupInput`](crate::input::CreateBackupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBackupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBackupInput {
                file_system_id: self.file_system_id,
                client_request_token: self.client_request_token,
                tags: self.tags,
                volume_id: self.volume_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBackupInputOperationOutputAlias = crate::operation::CreateBackup;
#[doc(hidden)]
pub type CreateBackupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateBackupInput {
    /// Consumes the builder and constructs an Operation<[`CreateBackup`](crate::operation::CreateBackup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBackup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateBackupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateBackupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateBackupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSimbaAPIService_v20180301.CreateBackup",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_backup(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBackup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBackup",
            "fsx",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateBackupInput`](crate::input::CreateBackupInput)
    pub fn builder() -> crate::input::create_backup_input::Builder {
        crate::input::create_backup_input::Builder::default()
    }
}

/// See [`CreateDataRepositoryTaskInput`](crate::input::CreateDataRepositoryTaskInput)
pub mod create_data_repository_task_input {
    /// A builder for [`CreateDataRepositoryTaskInput`](crate::input::CreateDataRepositoryTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::DataRepositoryTaskType>,
        pub(crate) paths: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) report: std::option::Option<crate::model::CompletionReport>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Specifies the type of data repository task to create.</p>
        pub fn r#type(mut self, input: crate::model::DataRepositoryTaskType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Specifies the type of data repository task to create.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DataRepositoryTaskType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `paths`.
        ///
        /// To override the contents of this collection use [`set_paths`](Self::set_paths).
        ///
        /// <p>(Optional) The path or paths on the Amazon FSx file system to use when the data repository task is processed.
        /// The default path is the file system root directory. The paths you provide need to be relative to the mount point of the file system.
        /// If the mount point is <code>/mnt/fsx</code> and <code>/mnt/fsx/path1</code> is a directory or
        /// file on the file system you want to export, then the path to provide is <code>path1</code>.
        /// If a path that you provide isn't valid, the task fails.</p>
        pub fn paths(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.paths.unwrap_or_default();
            v.push(input.into());
            self.paths = Some(v);
            self
        }
        /// <p>(Optional) The path or paths on the Amazon FSx file system to use when the data repository task is processed.
        /// The default path is the file system root directory. The paths you provide need to be relative to the mount point of the file system.
        /// If the mount point is <code>/mnt/fsx</code> and <code>/mnt/fsx/path1</code> is a directory or
        /// file on the file system you want to export, then the path to provide is <code>path1</code>.
        /// If a path that you provide isn't valid, the task fails.</p>
        pub fn set_paths(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.paths = input;
            self
        }
        /// <p>The globally unique ID of the file system, assigned by Amazon FSx.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>The globally unique ID of the file system, assigned by Amazon FSx.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// <p>Defines whether or not Amazon FSx provides a CompletionReport once the task has completed.
        /// A CompletionReport provides a detailed  report on the files that Amazon FSx processed that meet the criteria specified by the
        /// <code>Scope</code> parameter. For more information, see
        /// <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/task-completion-report.html">Working with Task Completion Reports</a>.</p>
        pub fn report(mut self, input: crate::model::CompletionReport) -> Self {
            self.report = Some(input);
            self
        }
        /// <p>Defines whether or not Amazon FSx provides a CompletionReport once the task has completed.
        /// A CompletionReport provides a detailed  report on the files that Amazon FSx processed that meet the criteria specified by the
        /// <code>Scope</code> parameter. For more information, see
        /// <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/task-completion-report.html">Working with Task Completion Reports</a>.</p>
        pub fn set_report(
            mut self,
            input: std::option::Option<crate::model::CompletionReport>,
        ) -> Self {
            self.report = input;
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
        /// ASCII characters. This token is automatically filled on your behalf when you use the
        /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
        /// ASCII characters. This token is automatically filled on your behalf when you use the
        /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDataRepositoryTaskInput`](crate::input::CreateDataRepositoryTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDataRepositoryTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDataRepositoryTaskInput {
                r#type: self.r#type,
                paths: self.paths,
                file_system_id: self.file_system_id,
                report: self.report,
                client_request_token: self.client_request_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDataRepositoryTaskInputOperationOutputAlias =
    crate::operation::CreateDataRepositoryTask;
#[doc(hidden)]
pub type CreateDataRepositoryTaskInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDataRepositoryTaskInput {
    /// Consumes the builder and constructs an Operation<[`CreateDataRepositoryTask`](crate::operation::CreateDataRepositoryTask)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDataRepositoryTask,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDataRepositoryTaskInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDataRepositoryTaskInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDataRepositoryTaskInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSimbaAPIService_v20180301.CreateDataRepositoryTask",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_data_repository_task(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDataRepositoryTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDataRepositoryTask",
            "fsx",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDataRepositoryTaskInput`](crate::input::CreateDataRepositoryTaskInput)
    pub fn builder() -> crate::input::create_data_repository_task_input::Builder {
        crate::input::create_data_repository_task_input::Builder::default()
    }
}

/// See [`CreateFileSystemInput`](crate::input::CreateFileSystemInput)
pub mod create_file_system_input {
    /// A builder for [`CreateFileSystemInput`](crate::input::CreateFileSystemInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) file_system_type: std::option::Option<crate::model::FileSystemType>,
        pub(crate) storage_capacity: std::option::Option<i32>,
        pub(crate) storage_type: std::option::Option<crate::model::StorageType>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) windows_configuration:
            std::option::Option<crate::model::CreateFileSystemWindowsConfiguration>,
        pub(crate) lustre_configuration:
            std::option::Option<crate::model::CreateFileSystemLustreConfiguration>,
        pub(crate) ontap_configuration:
            std::option::Option<crate::model::CreateFileSystemOntapConfiguration>,
        pub(crate) file_system_type_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure
        /// idempotent creation. This string is automatically filled on your behalf when you use the
        /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure
        /// idempotent creation. This string is automatically filled on your behalf when you use the
        /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The type of Amazon FSx file system to create. Valid values are <code>WINDOWS</code>,
        /// <code>LUSTRE</code>, and <code>ONTAP</code>.</p>
        pub fn file_system_type(mut self, input: crate::model::FileSystemType) -> Self {
            self.file_system_type = Some(input);
            self
        }
        /// <p>The type of Amazon FSx file system to create. Valid values are <code>WINDOWS</code>,
        /// <code>LUSTRE</code>, and <code>ONTAP</code>.</p>
        pub fn set_file_system_type(
            mut self,
            input: std::option::Option<crate::model::FileSystemType>,
        ) -> Self {
            self.file_system_type = input;
            self
        }
        /// <p>Sets the storage capacity of the file system that you're creating.</p>      
        /// <p>For Lustre file systems:</p>
        /// <ul>
        /// <li>
        /// <p>For <code>SCRATCH_2</code> and <code>PERSISTENT_1 SSD</code> deployment types, valid values are
        /// 1200 GiB, 2400 GiB, and increments of 2400 GiB.</p>
        /// </li>
        /// <li>
        /// <p>For <code>PERSISTENT HDD</code> file systems, valid values are increments of 6000 GiB for
        /// 12 MB/s/TiB file systems and increments of 1800 GiB for 40 MB/s/TiB file systems.</p>
        /// </li>
        /// <li>
        /// <p>For <code>SCRATCH_1</code> deployment type, valid values are
        /// 1200 GiB, 2400 GiB, and increments of 3600 GiB.</p>
        /// </li>
        /// </ul>
        /// <p>For Windows file systems:</p>
        /// <ul>
        /// <li>
        /// <p>If <code>StorageType=SSD</code>, valid values are 32 GiB - 65,536 GiB (64 TiB).</p>
        /// </li>
        /// <li>
        /// <p>If <code>StorageType=HDD</code>, valid values are 2000 GiB - 65,536 GiB (64 TiB).</p>
        /// </li>
        /// </ul>
        /// <p>For ONTAP file systems:</p>
        /// <ul>
        /// <li>
        /// <p>Valid values are 1024 GiB - 196,608 GiB (192 TiB).</p>
        /// </li>
        /// </ul>
        pub fn storage_capacity(mut self, input: i32) -> Self {
            self.storage_capacity = Some(input);
            self
        }
        /// <p>Sets the storage capacity of the file system that you're creating.</p>      
        /// <p>For Lustre file systems:</p>
        /// <ul>
        /// <li>
        /// <p>For <code>SCRATCH_2</code> and <code>PERSISTENT_1 SSD</code> deployment types, valid values are
        /// 1200 GiB, 2400 GiB, and increments of 2400 GiB.</p>
        /// </li>
        /// <li>
        /// <p>For <code>PERSISTENT HDD</code> file systems, valid values are increments of 6000 GiB for
        /// 12 MB/s/TiB file systems and increments of 1800 GiB for 40 MB/s/TiB file systems.</p>
        /// </li>
        /// <li>
        /// <p>For <code>SCRATCH_1</code> deployment type, valid values are
        /// 1200 GiB, 2400 GiB, and increments of 3600 GiB.</p>
        /// </li>
        /// </ul>
        /// <p>For Windows file systems:</p>
        /// <ul>
        /// <li>
        /// <p>If <code>StorageType=SSD</code>, valid values are 32 GiB - 65,536 GiB (64 TiB).</p>
        /// </li>
        /// <li>
        /// <p>If <code>StorageType=HDD</code>, valid values are 2000 GiB - 65,536 GiB (64 TiB).</p>
        /// </li>
        /// </ul>
        /// <p>For ONTAP file systems:</p>
        /// <ul>
        /// <li>
        /// <p>Valid values are 1024 GiB - 196,608 GiB (192 TiB).</p>
        /// </li>
        /// </ul>
        pub fn set_storage_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.storage_capacity = input;
            self
        }
        /// <p>Sets the storage type for the file system you're creating.
        /// Valid values are <code>SSD</code> and <code>HDD</code>.</p>
        /// <ul>
        /// <li>
        /// <p>Set to <code>SSD</code> to use solid state drive storage.
        /// SSD is supported on all Windows, Lustre, and ONTAP deployment types.</p>
        /// </li>
        /// <li>
        /// <p>Set to <code>HDD</code> to use hard disk drive storage.
        /// HDD is supported on <code>SINGLE_AZ_2</code> and <code>MULTI_AZ_1</code> Windows file system deployment types,
        /// and on <code>PERSISTENT</code> Lustre file system deployment types.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>
        /// Default value is <code>SSD</code>. For more information, see
        /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/optimize-fsx-costs.html#storage-type-options">
        /// Storage Type Options</a> in the <i>Amazon FSx for Windows User Guide</i> and
        /// <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/what-is.html#storage-options">Multiple Storage Options</a>
        /// in the <i>Amazon FSx for Lustre User Guide</i>.
        /// </p>
        pub fn storage_type(mut self, input: crate::model::StorageType) -> Self {
            self.storage_type = Some(input);
            self
        }
        /// <p>Sets the storage type for the file system you're creating.
        /// Valid values are <code>SSD</code> and <code>HDD</code>.</p>
        /// <ul>
        /// <li>
        /// <p>Set to <code>SSD</code> to use solid state drive storage.
        /// SSD is supported on all Windows, Lustre, and ONTAP deployment types.</p>
        /// </li>
        /// <li>
        /// <p>Set to <code>HDD</code> to use hard disk drive storage.
        /// HDD is supported on <code>SINGLE_AZ_2</code> and <code>MULTI_AZ_1</code> Windows file system deployment types,
        /// and on <code>PERSISTENT</code> Lustre file system deployment types.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>
        /// Default value is <code>SSD</code>. For more information, see
        /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/optimize-fsx-costs.html#storage-type-options">
        /// Storage Type Options</a> in the <i>Amazon FSx for Windows User Guide</i> and
        /// <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/what-is.html#storage-options">Multiple Storage Options</a>
        /// in the <i>Amazon FSx for Lustre User Guide</i>.
        /// </p>
        pub fn set_storage_type(
            mut self,
            input: std::option::Option<crate::model::StorageType>,
        ) -> Self {
            self.storage_type = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>Specifies the IDs of the subnets that the file system will be accessible from. For Windows
        /// and ONTAP <code>MULTI_AZ_1</code> file system deployment types, provide exactly two subnet IDs,
        /// one for the preferred file server and one for the standby file server. You specify one of these
        /// subnets as the preferred subnet using the <code>WindowsConfiguration > PreferredSubnetID</code>
        /// or <code>OntapConfiguration > PreferredSubnetID</code> properties. For more information,
        /// see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html">
        /// Availability and durability: Single-AZ and Multi-AZ file systems</a> in the
        /// <i>Amazon FSx for Windows User Guide</i> and
        /// <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/high-availability-multiAZ.html">
        /// Availability and durability</a> in the
        /// <i>Amazon FSx for ONTAP User Guide</i>.</p>
        /// <p>For Windows <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> file system deployment types and Lustre file systems, provide exactly one subnet ID.
        /// The file server is launched in that subnet's Availability Zone.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>Specifies the IDs of the subnets that the file system will be accessible from. For Windows
        /// and ONTAP <code>MULTI_AZ_1</code> file system deployment types, provide exactly two subnet IDs,
        /// one for the preferred file server and one for the standby file server. You specify one of these
        /// subnets as the preferred subnet using the <code>WindowsConfiguration > PreferredSubnetID</code>
        /// or <code>OntapConfiguration > PreferredSubnetID</code> properties. For more information,
        /// see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html">
        /// Availability and durability: Single-AZ and Multi-AZ file systems</a> in the
        /// <i>Amazon FSx for Windows User Guide</i> and
        /// <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/high-availability-multiAZ.html">
        /// Availability and durability</a> in the
        /// <i>Amazon FSx for ONTAP User Guide</i>.</p>
        /// <p>For Windows <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> file system deployment types and Lustre file systems, provide exactly one subnet ID.
        /// The file server is launched in that subnet's Availability Zone.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>A list of IDs specifying the security groups to apply to all network interfaces
        /// created for file system access. This list isn't returned in later requests to
        /// describe the file system.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>A list of IDs specifying the security groups to apply to all network interfaces
        /// created for file system access. This list isn't returned in later requests to
        /// describe the file system.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply to the file system being created. The key value of
        /// the <code>Name</code> tag appears in the console as the file system name.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to apply to the file system being created. The key value of
        /// the <code>Name</code> tag appears in the console as the file system name.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The ID of the Key Management Service (KMS) key used to encrypt the file system's data
        /// for Amazon FSx for Windows File Server file systems, Amazon FSx for NetApp ONTAP file systems, and
        /// Amazon FSx for Lustre <code>PERSISTENT_1</code> file systems at rest. If not specified, the Amazon FSx
        /// managed key is used. The Amazon FSx for Lustre <code>SCRATCH_1</code> and <code>SCRATCH_2</code> file systems
        /// are always encrypted at rest using Amazon FSx managed keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html">Encrypt</a>
        /// in the <i>Key Management Service API Reference</i>.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID of the Key Management Service (KMS) key used to encrypt the file system's data
        /// for Amazon FSx for Windows File Server file systems, Amazon FSx for NetApp ONTAP file systems, and
        /// Amazon FSx for Lustre <code>PERSISTENT_1</code> file systems at rest. If not specified, the Amazon FSx
        /// managed key is used. The Amazon FSx for Lustre <code>SCRATCH_1</code> and <code>SCRATCH_2</code> file systems
        /// are always encrypted at rest using Amazon FSx managed keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html">Encrypt</a>
        /// in the <i>Key Management Service API Reference</i>.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The Microsoft Windows configuration for the file system being created.
        /// </p>
        pub fn windows_configuration(
            mut self,
            input: crate::model::CreateFileSystemWindowsConfiguration,
        ) -> Self {
            self.windows_configuration = Some(input);
            self
        }
        /// <p>The Microsoft Windows configuration for the file system being created.
        /// </p>
        pub fn set_windows_configuration(
            mut self,
            input: std::option::Option<crate::model::CreateFileSystemWindowsConfiguration>,
        ) -> Self {
            self.windows_configuration = input;
            self
        }
        /// <p>The Lustre configuration for the file system being created.
        /// </p>
        pub fn lustre_configuration(
            mut self,
            input: crate::model::CreateFileSystemLustreConfiguration,
        ) -> Self {
            self.lustre_configuration = Some(input);
            self
        }
        /// <p>The Lustre configuration for the file system being created.
        /// </p>
        pub fn set_lustre_configuration(
            mut self,
            input: std::option::Option<crate::model::CreateFileSystemLustreConfiguration>,
        ) -> Self {
            self.lustre_configuration = input;
            self
        }
        /// <p>The ONTAP configuration properties of the FSx for NetApp ONTAP file system that you are creating.</p>
        pub fn ontap_configuration(
            mut self,
            input: crate::model::CreateFileSystemOntapConfiguration,
        ) -> Self {
            self.ontap_configuration = Some(input);
            self
        }
        /// <p>The ONTAP configuration properties of the FSx for NetApp ONTAP file system that you are creating.</p>
        pub fn set_ontap_configuration(
            mut self,
            input: std::option::Option<crate::model::CreateFileSystemOntapConfiguration>,
        ) -> Self {
            self.ontap_configuration = input;
            self
        }
        /// <p>Sets the version of the Amazon FSx for Lustre file system you're creating.
        /// Valid values are <code>2.10</code> and <code>2.12</code>.</p>
        /// <ul>
        /// <li>
        /// <p>Set the value to <code>2.10</code> to create a Lustre 2.10
        /// file system.</p>
        /// </li>
        /// <li>
        /// <p>Set the value to <code>2.12</code> to create a Lustre 2.12
        /// file system.</p>
        /// </li>
        /// </ul>
        /// <p>Default value is <code>2.10</code>.</p>
        pub fn file_system_type_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_type_version = Some(input.into());
            self
        }
        /// <p>Sets the version of the Amazon FSx for Lustre file system you're creating.
        /// Valid values are <code>2.10</code> and <code>2.12</code>.</p>
        /// <ul>
        /// <li>
        /// <p>Set the value to <code>2.10</code> to create a Lustre 2.10
        /// file system.</p>
        /// </li>
        /// <li>
        /// <p>Set the value to <code>2.12</code> to create a Lustre 2.12
        /// file system.</p>
        /// </li>
        /// </ul>
        /// <p>Default value is <code>2.10</code>.</p>
        pub fn set_file_system_type_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_type_version = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFileSystemInput`](crate::input::CreateFileSystemInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFileSystemInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFileSystemInput {
                client_request_token: self.client_request_token,
                file_system_type: self.file_system_type,
                storage_capacity: self.storage_capacity,
                storage_type: self.storage_type,
                subnet_ids: self.subnet_ids,
                security_group_ids: self.security_group_ids,
                tags: self.tags,
                kms_key_id: self.kms_key_id,
                windows_configuration: self.windows_configuration,
                lustre_configuration: self.lustre_configuration,
                ontap_configuration: self.ontap_configuration,
                file_system_type_version: self.file_system_type_version,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFileSystemInputOperationOutputAlias = crate::operation::CreateFileSystem;
#[doc(hidden)]
pub type CreateFileSystemInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateFileSystemInput {
    /// Consumes the builder and constructs an Operation<[`CreateFileSystem`](crate::operation::CreateFileSystem)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFileSystem,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateFileSystemInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateFileSystemInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateFileSystemInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSimbaAPIService_v20180301.CreateFileSystem",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_file_system(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFileSystem::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFileSystem",
            "fsx",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateFileSystemInput`](crate::input::CreateFileSystemInput)
    pub fn builder() -> crate::input::create_file_system_input::Builder {
        crate::input::create_file_system_input::Builder::default()
    }
}

/// See [`CreateFileSystemFromBackupInput`](crate::input::CreateFileSystemFromBackupInput)
pub mod create_file_system_from_backup_input {
    /// A builder for [`CreateFileSystemFromBackupInput`](crate::input::CreateFileSystemFromBackupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_id: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) windows_configuration:
            std::option::Option<crate::model::CreateFileSystemWindowsConfiguration>,
        pub(crate) lustre_configuration:
            std::option::Option<crate::model::CreateFileSystemLustreConfiguration>,
        pub(crate) storage_type: std::option::Option<crate::model::StorageType>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) file_system_type_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the source backup. Specifies the backup you are copying.</p>
        pub fn backup_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_id = Some(input.into());
            self
        }
        /// <p>The ID of the source backup. Specifies the backup you are copying.</p>
        pub fn set_backup_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.backup_id = input;
            self
        }
        /// <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure
        /// idempotent creation. This string is automatically filled on your behalf when you use the
        /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure
        /// idempotent creation. This string is automatically filled on your behalf when you use the
        /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>Specifies the IDs of the subnets that the file system will be accessible from. For Windows <code>MULTI_AZ_1</code>
        /// file system deployment types, provide exactly two subnet IDs, one for the preferred file server
        /// and one for the standby file server. You specify one of these subnets as the preferred subnet
        /// using the <code>WindowsConfiguration > PreferredSubnetID</code> property.</p>
        /// <p>For Windows <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> deployment
        /// types and Lustre file systems, provide exactly one subnet ID.
        /// The file server is launched in that subnet's Availability Zone.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>Specifies the IDs of the subnets that the file system will be accessible from. For Windows <code>MULTI_AZ_1</code>
        /// file system deployment types, provide exactly two subnet IDs, one for the preferred file server
        /// and one for the standby file server. You specify one of these subnets as the preferred subnet
        /// using the <code>WindowsConfiguration > PreferredSubnetID</code> property.</p>
        /// <p>For Windows <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> deployment
        /// types and Lustre file systems, provide exactly one subnet ID.
        /// The file server is launched in that subnet's Availability Zone.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>A list of IDs for the security groups that apply to the specified network
        /// interfaces created for file system access. These security groups apply to all network
        /// interfaces. This value isn't returned in later DescribeFileSystem requests.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>A list of IDs for the security groups that apply to the specified network
        /// interfaces created for file system access. These security groups apply to all network
        /// interfaces. This value isn't returned in later DescribeFileSystem requests.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be applied to the file system at file system creation. The key value of
        /// the <code>Name</code> tag appears in the console as the file system
        /// name.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be applied to the file system at file system creation. The key value of
        /// the <code>Name</code> tag appears in the console as the file system
        /// name.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The configuration for this Microsoft Windows file system.</p>
        pub fn windows_configuration(
            mut self,
            input: crate::model::CreateFileSystemWindowsConfiguration,
        ) -> Self {
            self.windows_configuration = Some(input);
            self
        }
        /// <p>The configuration for this Microsoft Windows file system.</p>
        pub fn set_windows_configuration(
            mut self,
            input: std::option::Option<crate::model::CreateFileSystemWindowsConfiguration>,
        ) -> Self {
            self.windows_configuration = input;
            self
        }
        /// <p>The Lustre configuration for the file system being created.
        /// </p>
        pub fn lustre_configuration(
            mut self,
            input: crate::model::CreateFileSystemLustreConfiguration,
        ) -> Self {
            self.lustre_configuration = Some(input);
            self
        }
        /// <p>The Lustre configuration for the file system being created.
        /// </p>
        pub fn set_lustre_configuration(
            mut self,
            input: std::option::Option<crate::model::CreateFileSystemLustreConfiguration>,
        ) -> Self {
            self.lustre_configuration = input;
            self
        }
        /// <p>Sets the storage type for the Windows file system you're creating from a backup.
        /// Valid values are <code>SSD</code> and <code>HDD</code>.</p>
        /// <ul>
        /// <li>
        /// <p>Set to <code>SSD</code> to use solid state drive storage.
        /// Supported on all Windows deployment types.</p>
        /// </li>
        /// <li>
        /// <p>Set to <code>HDD</code> to use hard disk drive storage.
        /// Supported on <code>SINGLE_AZ_2</code> and <code>MULTI_AZ_1</code> Windows file system deployment types.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>
        /// Default value is <code>SSD</code>.
        /// </p>
        /// <note>
        /// <p>HDD and SSD storage types have different minimum storage capacity requirements.
        /// A restored file system's storage capacity is tied to the file system that was backed up.
        /// You can create a file system that uses HDD storage from a backup of a file system that
        /// used SSD storage only if the original SSD file system had a storage capacity of at least 2000 GiB.
        /// </p>
        /// </note>
        pub fn storage_type(mut self, input: crate::model::StorageType) -> Self {
            self.storage_type = Some(input);
            self
        }
        /// <p>Sets the storage type for the Windows file system you're creating from a backup.
        /// Valid values are <code>SSD</code> and <code>HDD</code>.</p>
        /// <ul>
        /// <li>
        /// <p>Set to <code>SSD</code> to use solid state drive storage.
        /// Supported on all Windows deployment types.</p>
        /// </li>
        /// <li>
        /// <p>Set to <code>HDD</code> to use hard disk drive storage.
        /// Supported on <code>SINGLE_AZ_2</code> and <code>MULTI_AZ_1</code> Windows file system deployment types.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>
        /// Default value is <code>SSD</code>.
        /// </p>
        /// <note>
        /// <p>HDD and SSD storage types have different minimum storage capacity requirements.
        /// A restored file system's storage capacity is tied to the file system that was backed up.
        /// You can create a file system that uses HDD storage from a backup of a file system that
        /// used SSD storage only if the original SSD file system had a storage capacity of at least 2000 GiB.
        /// </p>
        /// </note>
        pub fn set_storage_type(
            mut self,
            input: std::option::Option<crate::model::StorageType>,
        ) -> Self {
            self.storage_type = input;
            self
        }
        /// <p>The ID of the Key Management Service (KMS) key used to encrypt the file system's data
        /// for Amazon FSx for Windows File Server file systems, Amazon FSx for NetApp ONTAP file systems, and
        /// Amazon FSx for Lustre <code>PERSISTENT_1</code> file systems at rest. If not specified, the Amazon FSx
        /// managed key is used. The Amazon FSx for Lustre <code>SCRATCH_1</code> and <code>SCRATCH_2</code> file systems
        /// are always encrypted at rest using Amazon FSx managed keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html">Encrypt</a>
        /// in the <i>Key Management Service API Reference</i>.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID of the Key Management Service (KMS) key used to encrypt the file system's data
        /// for Amazon FSx for Windows File Server file systems, Amazon FSx for NetApp ONTAP file systems, and
        /// Amazon FSx for Lustre <code>PERSISTENT_1</code> file systems at rest. If not specified, the Amazon FSx
        /// managed key is used. The Amazon FSx for Lustre <code>SCRATCH_1</code> and <code>SCRATCH_2</code> file systems
        /// are always encrypted at rest using Amazon FSx managed keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html">Encrypt</a>
        /// in the <i>Key Management Service API Reference</i>.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>Sets the version for the Amazon FSx for Lustre file system you're creating from a backup.
        /// Valid values are <code>2.10</code> and <code>2.12</code>.</p>
        /// <p>You don't need to specify <code>FileSystemTypeVersion</code> because it will
        /// be applied using the backup's <code>FileSystemTypeVersion</code> setting.
        /// If you choose to specify <code>FileSystemTypeVersion</code> when creating from backup, the
        /// value must match the backup's <code>FileSystemTypeVersion</code> setting.</p>
        pub fn file_system_type_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_type_version = Some(input.into());
            self
        }
        /// <p>Sets the version for the Amazon FSx for Lustre file system you're creating from a backup.
        /// Valid values are <code>2.10</code> and <code>2.12</code>.</p>
        /// <p>You don't need to specify <code>FileSystemTypeVersion</code> because it will
        /// be applied using the backup's <code>FileSystemTypeVersion</code> setting.
        /// If you choose to specify <code>FileSystemTypeVersion</code> when creating from backup, the
        /// value must match the backup's <code>FileSystemTypeVersion</code> setting.</p>
        pub fn set_file_system_type_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_type_version = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFileSystemFromBackupInput`](crate::input::CreateFileSystemFromBackupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFileSystemFromBackupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFileSystemFromBackupInput {
                backup_id: self.backup_id,
                client_request_token: self.client_request_token,
                subnet_ids: self.subnet_ids,
                security_group_ids: self.security_group_ids,
                tags: self.tags,
                windows_configuration: self.windows_configuration,
                lustre_configuration: self.lustre_configuration,
                storage_type: self.storage_type,
                kms_key_id: self.kms_key_id,
                file_system_type_version: self.file_system_type_version,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFileSystemFromBackupInputOperationOutputAlias =
    crate::operation::CreateFileSystemFromBackup;
#[doc(hidden)]
pub type CreateFileSystemFromBackupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateFileSystemFromBackupInput {
    /// Consumes the builder and constructs an Operation<[`CreateFileSystemFromBackup`](crate::operation::CreateFileSystemFromBackup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFileSystemFromBackup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateFileSystemFromBackupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateFileSystemFromBackupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateFileSystemFromBackupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSimbaAPIService_v20180301.CreateFileSystemFromBackup",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_file_system_from_backup(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFileSystemFromBackup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFileSystemFromBackup",
            "fsx",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateFileSystemFromBackupInput`](crate::input::CreateFileSystemFromBackupInput)
    pub fn builder() -> crate::input::create_file_system_from_backup_input::Builder {
        crate::input::create_file_system_from_backup_input::Builder::default()
    }
}

/// See [`CreateStorageVirtualMachineInput`](crate::input::CreateStorageVirtualMachineInput)
pub mod create_storage_virtual_machine_input {
    /// A builder for [`CreateStorageVirtualMachineInput`](crate::input::CreateStorageVirtualMachineInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) active_directory_configuration:
            std::option::Option<crate::model::CreateSvmActiveDirectoryConfiguration>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) svm_admin_password: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) root_volume_security_style:
            std::option::Option<crate::model::StorageVirtualMachineRootVolumeSecurityStyle>,
    }
    impl Builder {
        /// <p>Describes the self-managed Microsoft Active Directory to which you want to join the SVM.
        /// Joining an Active Directory provides user authentication and access control for SMB clients,
        /// including Microsoft Windows and macOS client accessing the file system.</p>
        pub fn active_directory_configuration(
            mut self,
            input: crate::model::CreateSvmActiveDirectoryConfiguration,
        ) -> Self {
            self.active_directory_configuration = Some(input);
            self
        }
        /// <p>Describes the self-managed Microsoft Active Directory to which you want to join the SVM.
        /// Joining an Active Directory provides user authentication and access control for SMB clients,
        /// including Microsoft Windows and macOS client accessing the file system.</p>
        pub fn set_active_directory_configuration(
            mut self,
            input: std::option::Option<crate::model::CreateSvmActiveDirectoryConfiguration>,
        ) -> Self {
            self.active_directory_configuration = input;
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
        /// ASCII characters. This token is automatically filled on your behalf when you use the
        /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
        /// ASCII characters. This token is automatically filled on your behalf when you use the
        /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The globally unique ID of the file system, assigned by Amazon FSx.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>The globally unique ID of the file system, assigned by Amazon FSx.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// <p>The name of the SVM.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the SVM.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The password to use when managing the SVM using the NetApp ONTAP CLI or REST API.
        /// If you do not specify a password, you can still use the file system's
        /// <code>fsxadmin</code> user to manage the SVM.</p>
        pub fn svm_admin_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.svm_admin_password = Some(input.into());
            self
        }
        /// <p>The password to use when managing the SVM using the NetApp ONTAP CLI or REST API.
        /// If you do not specify a password, you can still use the file system's
        /// <code>fsxadmin</code> user to manage the SVM.</p>
        pub fn set_svm_admin_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.svm_admin_password = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The security style of the root volume of the SVM. Specify one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>UNIX</code> if the file system is managed by a UNIX
        /// administrator, the majority of users are NFS clients, and an application
        /// accessing the data uses a UNIX user as the service account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NTFS</code> if the file system is managed by a Windows
        /// administrator, the majority of users are SMB clients, and an application
        /// accessing the data uses a Windows user as the service account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MIXED</code> if the file system is managed by both UNIX
        /// and Windows administrators and users consist of both NFS and SMB clients.</p>
        /// </li>
        /// </ul>
        pub fn root_volume_security_style(
            mut self,
            input: crate::model::StorageVirtualMachineRootVolumeSecurityStyle,
        ) -> Self {
            self.root_volume_security_style = Some(input);
            self
        }
        /// <p>The security style of the root volume of the SVM. Specify one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>UNIX</code> if the file system is managed by a UNIX
        /// administrator, the majority of users are NFS clients, and an application
        /// accessing the data uses a UNIX user as the service account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NTFS</code> if the file system is managed by a Windows
        /// administrator, the majority of users are SMB clients, and an application
        /// accessing the data uses a Windows user as the service account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MIXED</code> if the file system is managed by both UNIX
        /// and Windows administrators and users consist of both NFS and SMB clients.</p>
        /// </li>
        /// </ul>
        pub fn set_root_volume_security_style(
            mut self,
            input: std::option::Option<crate::model::StorageVirtualMachineRootVolumeSecurityStyle>,
        ) -> Self {
            self.root_volume_security_style = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStorageVirtualMachineInput`](crate::input::CreateStorageVirtualMachineInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateStorageVirtualMachineInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateStorageVirtualMachineInput {
                active_directory_configuration: self.active_directory_configuration,
                client_request_token: self.client_request_token,
                file_system_id: self.file_system_id,
                name: self.name,
                svm_admin_password: self.svm_admin_password,
                tags: self.tags,
                root_volume_security_style: self.root_volume_security_style,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateStorageVirtualMachineInputOperationOutputAlias =
    crate::operation::CreateStorageVirtualMachine;
#[doc(hidden)]
pub type CreateStorageVirtualMachineInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateStorageVirtualMachineInput {
    /// Consumes the builder and constructs an Operation<[`CreateStorageVirtualMachine`](crate::operation::CreateStorageVirtualMachine)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateStorageVirtualMachine,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateStorageVirtualMachineInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateStorageVirtualMachineInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateStorageVirtualMachineInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSimbaAPIService_v20180301.CreateStorageVirtualMachine",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_storage_virtual_machine(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateStorageVirtualMachine::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateStorageVirtualMachine",
            "fsx",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateStorageVirtualMachineInput`](crate::input::CreateStorageVirtualMachineInput)
    pub fn builder() -> crate::input::create_storage_virtual_machine_input::Builder {
        crate::input::create_storage_virtual_machine_input::Builder::default()
    }
}

/// See [`CreateVolumeInput`](crate::input::CreateVolumeInput)
pub mod create_volume_input {
    /// A builder for [`CreateVolumeInput`](crate::input::CreateVolumeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) volume_type: std::option::Option<crate::model::VolumeType>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) ontap_configuration:
            std::option::Option<crate::model::CreateOntapVolumeConfiguration>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
        /// ASCII characters. This token is automatically filled on your behalf when you use the
        /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
        /// ASCII characters. This token is automatically filled on your behalf when you use the
        /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>Specifies the type of volume to create; <code>ONTAP</code> is the only valid volume type.</p>
        pub fn volume_type(mut self, input: crate::model::VolumeType) -> Self {
            self.volume_type = Some(input);
            self
        }
        /// <p>Specifies the type of volume to create; <code>ONTAP</code> is the only valid volume type.</p>
        pub fn set_volume_type(
            mut self,
            input: std::option::Option<crate::model::VolumeType>,
        ) -> Self {
            self.volume_type = input;
            self
        }
        /// <p>Specifies the name of the volume you're creating.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the volume you're creating.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Specifies the <code>ONTAP</code> configuration to use in creating the volume.</p>
        pub fn ontap_configuration(
            mut self,
            input: crate::model::CreateOntapVolumeConfiguration,
        ) -> Self {
            self.ontap_configuration = Some(input);
            self
        }
        /// <p>Specifies the <code>ONTAP</code> configuration to use in creating the volume.</p>
        pub fn set_ontap_configuration(
            mut self,
            input: std::option::Option<crate::model::CreateOntapVolumeConfiguration>,
        ) -> Self {
            self.ontap_configuration = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateVolumeInput`](crate::input::CreateVolumeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateVolumeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateVolumeInput {
                client_request_token: self.client_request_token,
                volume_type: self.volume_type,
                name: self.name,
                ontap_configuration: self.ontap_configuration,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateVolumeInputOperationOutputAlias = crate::operation::CreateVolume;
#[doc(hidden)]
pub type CreateVolumeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateVolumeInput {
    /// Consumes the builder and constructs an Operation<[`CreateVolume`](crate::operation::CreateVolume)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateVolume,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateVolumeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateVolumeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateVolumeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSimbaAPIService_v20180301.CreateVolume",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_volume(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateVolume::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateVolume",
            "fsx",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateVolumeInput`](crate::input::CreateVolumeInput)
    pub fn builder() -> crate::input::create_volume_input::Builder {
        crate::input::create_volume_input::Builder::default()
    }
}

/// See [`CreateVolumeFromBackupInput`](crate::input::CreateVolumeFromBackupInput)
pub mod create_volume_from_backup_input {
    /// A builder for [`CreateVolumeFromBackupInput`](crate::input::CreateVolumeFromBackupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_id: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) ontap_configuration:
            std::option::Option<crate::model::CreateOntapVolumeConfiguration>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the source backup. Specifies the backup you are copying.</p>
        pub fn backup_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_id = Some(input.into());
            self
        }
        /// <p>The ID of the source backup. Specifies the backup you are copying.</p>
        pub fn set_backup_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.backup_id = input;
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
        /// ASCII characters. This token is automatically filled on your behalf when you use the
        /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
        /// ASCII characters. This token is automatically filled on your behalf when you use the
        /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The name of the new volume you're creating.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the new volume you're creating.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Specifies the configuration of the ONTAP volume that you are creating.</p>
        pub fn ontap_configuration(
            mut self,
            input: crate::model::CreateOntapVolumeConfiguration,
        ) -> Self {
            self.ontap_configuration = Some(input);
            self
        }
        /// <p>Specifies the configuration of the ONTAP volume that you are creating.</p>
        pub fn set_ontap_configuration(
            mut self,
            input: std::option::Option<crate::model::CreateOntapVolumeConfiguration>,
        ) -> Self {
            self.ontap_configuration = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateVolumeFromBackupInput`](crate::input::CreateVolumeFromBackupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateVolumeFromBackupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateVolumeFromBackupInput {
                backup_id: self.backup_id,
                client_request_token: self.client_request_token,
                name: self.name,
                ontap_configuration: self.ontap_configuration,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateVolumeFromBackupInputOperationOutputAlias = crate::operation::CreateVolumeFromBackup;
#[doc(hidden)]
pub type CreateVolumeFromBackupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateVolumeFromBackupInput {
    /// Consumes the builder and constructs an Operation<[`CreateVolumeFromBackup`](crate::operation::CreateVolumeFromBackup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateVolumeFromBackup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateVolumeFromBackupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateVolumeFromBackupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateVolumeFromBackupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSimbaAPIService_v20180301.CreateVolumeFromBackup",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_volume_from_backup(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateVolumeFromBackup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateVolumeFromBackup",
            "fsx",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateVolumeFromBackupInput`](crate::input::CreateVolumeFromBackupInput)
    pub fn builder() -> crate::input::create_volume_from_backup_input::Builder {
        crate::input::create_volume_from_backup_input::Builder::default()
    }
}

/// See [`DeleteBackupInput`](crate::input::DeleteBackupInput)
pub mod delete_backup_input {
    /// A builder for [`DeleteBackupInput`](crate::input::DeleteBackupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_id: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the backup you want to delete.</p>
        pub fn backup_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_id = Some(input.into());
            self
        }
        /// <p>The ID of the backup you want to delete.</p>
        pub fn set_backup_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.backup_id = input;
            self
        }
        /// <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure
        /// idempotent deletion. This is automatically filled on your behalf when using
        /// the CLI or SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure
        /// idempotent deletion. This is automatically filled on your behalf when using
        /// the CLI or SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBackupInput`](crate::input::DeleteBackupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBackupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBackupInput {
                backup_id: self.backup_id,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBackupInputOperationOutputAlias = crate::operation::DeleteBackup;
#[doc(hidden)]
pub type DeleteBackupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteBackupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBackup`](crate::operation::DeleteBackup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBackup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBackupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBackupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBackupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSimbaAPIService_v20180301.DeleteBackup",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_backup(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBackup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBackup",
            "fsx",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBackupInput`](crate::input::DeleteBackupInput)
    pub fn builder() -> crate::input::delete_backup_input::Builder {
        crate::input::delete_backup_input::Builder::default()
    }
}

/// See [`DeleteFileSystemInput`](crate::input::DeleteFileSystemInput)
pub mod delete_file_system_input {
    /// A builder for [`DeleteFileSystemInput`](crate::input::DeleteFileSystemInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) windows_configuration:
            std::option::Option<crate::model::DeleteFileSystemWindowsConfiguration>,
        pub(crate) lustre_configuration:
            std::option::Option<crate::model::DeleteFileSystemLustreConfiguration>,
    }
    impl Builder {
        /// <p>The ID of the file system you want to delete.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>The ID of the file system you want to delete.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure
        /// idempotent deletion. This is automatically filled on your behalf when using the
        /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure
        /// idempotent deletion. This is automatically filled on your behalf when using the
        /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The configuration object for the Microsoft Windows file system used in the
        /// <code>DeleteFileSystem</code> operation.</p>
        pub fn windows_configuration(
            mut self,
            input: crate::model::DeleteFileSystemWindowsConfiguration,
        ) -> Self {
            self.windows_configuration = Some(input);
            self
        }
        /// <p>The configuration object for the Microsoft Windows file system used in the
        /// <code>DeleteFileSystem</code> operation.</p>
        pub fn set_windows_configuration(
            mut self,
            input: std::option::Option<crate::model::DeleteFileSystemWindowsConfiguration>,
        ) -> Self {
            self.windows_configuration = input;
            self
        }
        /// <p>The configuration object for the Amazon FSx for Lustre file system being deleted in the
        /// <code>DeleteFileSystem</code> operation.</p>
        pub fn lustre_configuration(
            mut self,
            input: crate::model::DeleteFileSystemLustreConfiguration,
        ) -> Self {
            self.lustre_configuration = Some(input);
            self
        }
        /// <p>The configuration object for the Amazon FSx for Lustre file system being deleted in the
        /// <code>DeleteFileSystem</code> operation.</p>
        pub fn set_lustre_configuration(
            mut self,
            input: std::option::Option<crate::model::DeleteFileSystemLustreConfiguration>,
        ) -> Self {
            self.lustre_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFileSystemInput`](crate::input::DeleteFileSystemInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFileSystemInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFileSystemInput {
                file_system_id: self.file_system_id,
                client_request_token: self.client_request_token,
                windows_configuration: self.windows_configuration,
                lustre_configuration: self.lustre_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFileSystemInputOperationOutputAlias = crate::operation::DeleteFileSystem;
#[doc(hidden)]
pub type DeleteFileSystemInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteFileSystemInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFileSystem`](crate::operation::DeleteFileSystem)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFileSystem,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteFileSystemInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteFileSystemInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteFileSystemInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSimbaAPIService_v20180301.DeleteFileSystem",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_file_system(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFileSystem::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFileSystem",
            "fsx",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteFileSystemInput`](crate::input::DeleteFileSystemInput)
    pub fn builder() -> crate::input::delete_file_system_input::Builder {
        crate::input::delete_file_system_input::Builder::default()
    }
}

/// See [`DeleteStorageVirtualMachineInput`](crate::input::DeleteStorageVirtualMachineInput)
pub mod delete_storage_virtual_machine_input {
    /// A builder for [`DeleteStorageVirtualMachineInput`](crate::input::DeleteStorageVirtualMachineInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) storage_virtual_machine_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
        /// ASCII characters. This token is automatically filled on your behalf when you use the
        /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
        /// ASCII characters. This token is automatically filled on your behalf when you use the
        /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The ID of the SVM that you want to delete.</p>
        pub fn storage_virtual_machine_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.storage_virtual_machine_id = Some(input.into());
            self
        }
        /// <p>The ID of the SVM that you want to delete.</p>
        pub fn set_storage_virtual_machine_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.storage_virtual_machine_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteStorageVirtualMachineInput`](crate::input::DeleteStorageVirtualMachineInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteStorageVirtualMachineInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteStorageVirtualMachineInput {
                client_request_token: self.client_request_token,
                storage_virtual_machine_id: self.storage_virtual_machine_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteStorageVirtualMachineInputOperationOutputAlias =
    crate::operation::DeleteStorageVirtualMachine;
#[doc(hidden)]
pub type DeleteStorageVirtualMachineInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteStorageVirtualMachineInput {
    /// Consumes the builder and constructs an Operation<[`DeleteStorageVirtualMachine`](crate::operation::DeleteStorageVirtualMachine)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteStorageVirtualMachine,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteStorageVirtualMachineInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteStorageVirtualMachineInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteStorageVirtualMachineInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSimbaAPIService_v20180301.DeleteStorageVirtualMachine",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_storage_virtual_machine(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteStorageVirtualMachine::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteStorageVirtualMachine",
            "fsx",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteStorageVirtualMachineInput`](crate::input::DeleteStorageVirtualMachineInput)
    pub fn builder() -> crate::input::delete_storage_virtual_machine_input::Builder {
        crate::input::delete_storage_virtual_machine_input::Builder::default()
    }
}

/// See [`DeleteVolumeInput`](crate::input::DeleteVolumeInput)
pub mod delete_volume_input {
    /// A builder for [`DeleteVolumeInput`](crate::input::DeleteVolumeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) volume_id: std::option::Option<std::string::String>,
        pub(crate) ontap_configuration:
            std::option::Option<crate::model::DeleteVolumeOntapConfiguration>,
    }
    impl Builder {
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
        /// ASCII characters. This token is automatically filled on your behalf when you use the
        /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
        /// ASCII characters. This token is automatically filled on your behalf when you use the
        /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The ID of the volume you are deleting.</p>
        pub fn volume_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_id = Some(input.into());
            self
        }
        /// <p>The ID of the volume you are deleting.</p>
        pub fn set_volume_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_id = input;
            self
        }
        /// <p>For Amazon FSx for ONTAP volumes, specify whether to take
        /// a final backup of the volume, and apply tags to the backup.</p>
        pub fn ontap_configuration(
            mut self,
            input: crate::model::DeleteVolumeOntapConfiguration,
        ) -> Self {
            self.ontap_configuration = Some(input);
            self
        }
        /// <p>For Amazon FSx for ONTAP volumes, specify whether to take
        /// a final backup of the volume, and apply tags to the backup.</p>
        pub fn set_ontap_configuration(
            mut self,
            input: std::option::Option<crate::model::DeleteVolumeOntapConfiguration>,
        ) -> Self {
            self.ontap_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVolumeInput`](crate::input::DeleteVolumeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteVolumeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteVolumeInput {
                client_request_token: self.client_request_token,
                volume_id: self.volume_id,
                ontap_configuration: self.ontap_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteVolumeInputOperationOutputAlias = crate::operation::DeleteVolume;
#[doc(hidden)]
pub type DeleteVolumeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteVolumeInput {
    /// Consumes the builder and constructs an Operation<[`DeleteVolume`](crate::operation::DeleteVolume)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteVolume,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteVolumeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteVolumeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteVolumeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSimbaAPIService_v20180301.DeleteVolume",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_volume(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteVolume::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteVolume",
            "fsx",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteVolumeInput`](crate::input::DeleteVolumeInput)
    pub fn builder() -> crate::input::delete_volume_input::Builder {
        crate::input::delete_volume_input::Builder::default()
    }
}

/// See [`DescribeBackupsInput`](crate::input::DescribeBackupsInput)
pub mod describe_backups_input {
    /// A builder for [`DescribeBackupsInput`](crate::input::DescribeBackupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `backup_ids`.
        ///
        /// To override the contents of this collection use [`set_backup_ids`](Self::set_backup_ids).
        ///
        /// <p>IDs of the backups you want to retrieve (String). This overrides any
        /// filters. If any IDs are not found, BackupNotFound will be thrown.</p>
        pub fn backup_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.backup_ids.unwrap_or_default();
            v.push(input.into());
            self.backup_ids = Some(v);
            self
        }
        /// <p>IDs of the backups you want to retrieve (String). This overrides any
        /// filters. If any IDs are not found, BackupNotFound will be thrown.</p>
        pub fn set_backup_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.backup_ids = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters structure. Supported names are <code>file-system-id</code>,
        /// <code>backup-type</code>, <code>file-system-type</code>, and
        /// <code>volume-id</code>.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Filters structure. Supported names are <code>file-system-id</code>,
        /// <code>backup-type</code>, <code>file-system-type</code>, and
        /// <code>volume-id</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>Maximum number of backups to return in the response (integer). This
        /// parameter value must be greater than 0. The number of items that Amazon FSx returns is
        /// the minimum of the <code>MaxResults</code> parameter specified in the request and the
        /// service's internal maximum number of items per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of backups to return in the response (integer). This
        /// parameter value must be greater than 0. The number of items that Amazon FSx returns is
        /// the minimum of the <code>MaxResults</code> parameter specified in the request and the
        /// service's internal maximum number of items per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Opaque pagination token returned from a previous
        /// <code>DescribeBackups</code> operation (String). If a token present, the action
        /// continues the list from where the returning call left off.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Opaque pagination token returned from a previous
        /// <code>DescribeBackups</code> operation (String). If a token present, the action
        /// continues the list from where the returning call left off.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBackupsInput`](crate::input::DescribeBackupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeBackupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeBackupsInput {
                backup_ids: self.backup_ids,
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeBackupsInputOperationOutputAlias = crate::operation::DescribeBackups;
#[doc(hidden)]
pub type DescribeBackupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeBackupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeBackups`](crate::operation::DescribeBackups)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeBackups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeBackupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeBackupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeBackupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSimbaAPIService_v20180301.DescribeBackups",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_backups(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeBackups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeBackups",
            "fsx",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeBackupsInput`](crate::input::DescribeBackupsInput)
    pub fn builder() -> crate::input::describe_backups_input::Builder {
        crate::input::describe_backups_input::Builder::default()
    }
}

/// See [`DescribeDataRepositoryTasksInput`](crate::input::DescribeDataRepositoryTasksInput)
pub mod describe_data_repository_tasks_input {
    /// A builder for [`DescribeDataRepositoryTasksInput`](crate::input::DescribeDataRepositoryTasksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::DataRepositoryTaskFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `task_ids`.
        ///
        /// To override the contents of this collection use [`set_task_ids`](Self::set_task_ids).
        ///
        /// <p>(Optional) IDs of the tasks whose descriptions you want to retrieve
        /// (String).</p>
        pub fn task_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.task_ids.unwrap_or_default();
            v.push(input.into());
            self.task_ids = Some(v);
            self
        }
        /// <p>(Optional) IDs of the tasks whose descriptions you want to retrieve
        /// (String).</p>
        pub fn set_task_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.task_ids = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>(Optional) You can use filters to narrow the <code>DescribeDataRepositoryTasks</code> response to
        /// include just tasks for specific file systems, or tasks in a specific lifecycle state.</p>
        pub fn filters(mut self, input: impl Into<crate::model::DataRepositoryTaskFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>(Optional) You can use filters to narrow the <code>DescribeDataRepositoryTasks</code> response to
        /// include just tasks for specific file systems, or tasks in a specific lifecycle state.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataRepositoryTaskFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of resources to return in the response. This value must be an
        /// integer greater than zero.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of resources to return in the response. This value must be an
        /// integer greater than zero.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If
        /// present, this token indicates from what point you can continue processing the request, where
        /// the previous <code>NextToken</code> value left off.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If
        /// present, this token indicates from what point you can continue processing the request, where
        /// the previous <code>NextToken</code> value left off.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDataRepositoryTasksInput`](crate::input::DescribeDataRepositoryTasksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDataRepositoryTasksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDataRepositoryTasksInput {
                task_ids: self.task_ids,
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDataRepositoryTasksInputOperationOutputAlias =
    crate::operation::DescribeDataRepositoryTasks;
#[doc(hidden)]
pub type DescribeDataRepositoryTasksInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDataRepositoryTasksInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDataRepositoryTasks`](crate::operation::DescribeDataRepositoryTasks)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDataRepositoryTasks,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDataRepositoryTasksInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDataRepositoryTasksInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDataRepositoryTasksInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSimbaAPIService_v20180301.DescribeDataRepositoryTasks",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_data_repository_tasks(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDataRepositoryTasks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDataRepositoryTasks",
            "fsx",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDataRepositoryTasksInput`](crate::input::DescribeDataRepositoryTasksInput)
    pub fn builder() -> crate::input::describe_data_repository_tasks_input::Builder {
        crate::input::describe_data_repository_tasks_input::Builder::default()
    }
}

/// See [`DescribeFileSystemAliasesInput`](crate::input::DescribeFileSystemAliasesInput)
pub mod describe_file_system_aliases_input {
    /// A builder for [`DescribeFileSystemAliasesInput`](crate::input::DescribeFileSystemAliasesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
        /// ASCII characters. This token is automatically filled on your behalf when you use the
        /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
        /// ASCII characters. This token is automatically filled on your behalf when you use the
        /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The ID of the file system to return the associated DNS aliases for
        /// (String).</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>The ID of the file system to return the associated DNS aliases for
        /// (String).</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// <p>Maximum number of DNS aliases to return in the response (integer). This
        /// parameter value must be greater than 0. The number of items that Amazon FSx returns is
        /// the minimum of the <code>MaxResults</code> parameter specified in the request and the
        /// service's internal maximum number of items per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of DNS aliases to return in the response (integer). This
        /// parameter value must be greater than 0. The number of items that Amazon FSx returns is
        /// the minimum of the <code>MaxResults</code> parameter specified in the request and the
        /// service's internal maximum number of items per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Opaque pagination token returned from a previous
        /// <code>DescribeFileSystemAliases</code> operation (String). If a token is included in the request, the action
        /// continues the list from where the previous returning call left off.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Opaque pagination token returned from a previous
        /// <code>DescribeFileSystemAliases</code> operation (String). If a token is included in the request, the action
        /// continues the list from where the previous returning call left off.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFileSystemAliasesInput`](crate::input::DescribeFileSystemAliasesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeFileSystemAliasesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeFileSystemAliasesInput {
                client_request_token: self.client_request_token,
                file_system_id: self.file_system_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeFileSystemAliasesInputOperationOutputAlias =
    crate::operation::DescribeFileSystemAliases;
#[doc(hidden)]
pub type DescribeFileSystemAliasesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeFileSystemAliasesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeFileSystemAliases`](crate::operation::DescribeFileSystemAliases)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeFileSystemAliases,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeFileSystemAliasesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeFileSystemAliasesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeFileSystemAliasesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSimbaAPIService_v20180301.DescribeFileSystemAliases",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_file_system_aliases(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeFileSystemAliases::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeFileSystemAliases",
            "fsx",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeFileSystemAliasesInput`](crate::input::DescribeFileSystemAliasesInput)
    pub fn builder() -> crate::input::describe_file_system_aliases_input::Builder {
        crate::input::describe_file_system_aliases_input::Builder::default()
    }
}

/// See [`DescribeFileSystemsInput`](crate::input::DescribeFileSystemsInput)
pub mod describe_file_systems_input {
    /// A builder for [`DescribeFileSystemsInput`](crate::input::DescribeFileSystemsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `file_system_ids`.
        ///
        /// To override the contents of this collection use [`set_file_system_ids`](Self::set_file_system_ids).
        ///
        /// <p>IDs of the file systems whose descriptions you want to retrieve
        /// (String).</p>
        pub fn file_system_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.file_system_ids.unwrap_or_default();
            v.push(input.into());
            self.file_system_ids = Some(v);
            self
        }
        /// <p>IDs of the file systems whose descriptions you want to retrieve
        /// (String).</p>
        pub fn set_file_system_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.file_system_ids = input;
            self
        }
        /// <p>Maximum number of file systems to return in the response (integer). This
        /// parameter value must be greater than 0. The number of items that Amazon FSx returns is
        /// the minimum of the <code>MaxResults</code> parameter specified in the request and the
        /// service's internal maximum number of items per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of file systems to return in the response (integer). This
        /// parameter value must be greater than 0. The number of items that Amazon FSx returns is
        /// the minimum of the <code>MaxResults</code> parameter specified in the request and the
        /// service's internal maximum number of items per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Opaque pagination token returned from a previous
        /// <code>DescribeFileSystems</code> operation (String). If a token present, the action
        /// continues the list from where the returning call left off.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Opaque pagination token returned from a previous
        /// <code>DescribeFileSystems</code> operation (String). If a token present, the action
        /// continues the list from where the returning call left off.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFileSystemsInput`](crate::input::DescribeFileSystemsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeFileSystemsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeFileSystemsInput {
                file_system_ids: self.file_system_ids,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeFileSystemsInputOperationOutputAlias = crate::operation::DescribeFileSystems;
#[doc(hidden)]
pub type DescribeFileSystemsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeFileSystemsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeFileSystems`](crate::operation::DescribeFileSystems)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeFileSystems,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeFileSystemsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeFileSystemsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeFileSystemsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSimbaAPIService_v20180301.DescribeFileSystems",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_file_systems(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeFileSystems::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeFileSystems",
            "fsx",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeFileSystemsInput`](crate::input::DescribeFileSystemsInput)
    pub fn builder() -> crate::input::describe_file_systems_input::Builder {
        crate::input::describe_file_systems_input::Builder::default()
    }
}

/// See [`DescribeStorageVirtualMachinesInput`](crate::input::DescribeStorageVirtualMachinesInput)
pub mod describe_storage_virtual_machines_input {
    /// A builder for [`DescribeStorageVirtualMachinesInput`](crate::input::DescribeStorageVirtualMachinesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) storage_virtual_machine_ids:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::StorageVirtualMachineFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `storage_virtual_machine_ids`.
        ///
        /// To override the contents of this collection use [`set_storage_virtual_machine_ids`](Self::set_storage_virtual_machine_ids).
        ///
        /// <p>Enter the ID of one or more SVMs that you want to view.</p>
        pub fn storage_virtual_machine_ids(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.storage_virtual_machine_ids.unwrap_or_default();
            v.push(input.into());
            self.storage_virtual_machine_ids = Some(v);
            self
        }
        /// <p>Enter the ID of one or more SVMs that you want to view.</p>
        pub fn set_storage_virtual_machine_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.storage_virtual_machine_ids = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Enter a filter name:value pair to view a select set of SVMs.</p>
        pub fn filters(
            mut self,
            input: impl Into<crate::model::StorageVirtualMachineFilter>,
        ) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Enter a filter name:value pair to view a select set of SVMs.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StorageVirtualMachineFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of resources to return in the response. This value must be an
        /// integer greater than zero.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of resources to return in the response. This value must be an
        /// integer greater than zero.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If
        /// present, this token indicates from what point you can continue processing the request, where
        /// the previous <code>NextToken</code> value left off.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If
        /// present, this token indicates from what point you can continue processing the request, where
        /// the previous <code>NextToken</code> value left off.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStorageVirtualMachinesInput`](crate::input::DescribeStorageVirtualMachinesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeStorageVirtualMachinesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeStorageVirtualMachinesInput {
                storage_virtual_machine_ids: self.storage_virtual_machine_ids,
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeStorageVirtualMachinesInputOperationOutputAlias =
    crate::operation::DescribeStorageVirtualMachines;
#[doc(hidden)]
pub type DescribeStorageVirtualMachinesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeStorageVirtualMachinesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeStorageVirtualMachines`](crate::operation::DescribeStorageVirtualMachines)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeStorageVirtualMachines,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeStorageVirtualMachinesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeStorageVirtualMachinesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeStorageVirtualMachinesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSimbaAPIService_v20180301.DescribeStorageVirtualMachines",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_storage_virtual_machines(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeStorageVirtualMachines::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeStorageVirtualMachines",
            "fsx",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeStorageVirtualMachinesInput`](crate::input::DescribeStorageVirtualMachinesInput)
    pub fn builder() -> crate::input::describe_storage_virtual_machines_input::Builder {
        crate::input::describe_storage_virtual_machines_input::Builder::default()
    }
}

/// See [`DescribeVolumesInput`](crate::input::DescribeVolumesInput)
pub mod describe_volumes_input {
    /// A builder for [`DescribeVolumesInput`](crate::input::DescribeVolumesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::VolumeFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `volume_ids`.
        ///
        /// To override the contents of this collection use [`set_volume_ids`](Self::set_volume_ids).
        ///
        /// <p>IDs of the volumes whose descriptions you want to retrieve.</p>
        pub fn volume_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.volume_ids.unwrap_or_default();
            v.push(input.into());
            self.volume_ids = Some(v);
            self
        }
        /// <p>IDs of the volumes whose descriptions you want to retrieve.</p>
        pub fn set_volume_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.volume_ids = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Enter a filter name:value pair to view a select set of volumes.</p>
        pub fn filters(mut self, input: impl Into<crate::model::VolumeFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Enter a filter name:value pair to view a select set of volumes.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VolumeFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of resources to return in the response. This value must be an
        /// integer greater than zero.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of resources to return in the response. This value must be an
        /// integer greater than zero.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If
        /// present, this token indicates from what point you can continue processing the request, where
        /// the previous <code>NextToken</code> value left off.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If
        /// present, this token indicates from what point you can continue processing the request, where
        /// the previous <code>NextToken</code> value left off.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeVolumesInput`](crate::input::DescribeVolumesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeVolumesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeVolumesInput {
                volume_ids: self.volume_ids,
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeVolumesInputOperationOutputAlias = crate::operation::DescribeVolumes;
#[doc(hidden)]
pub type DescribeVolumesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeVolumesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeVolumes`](crate::operation::DescribeVolumes)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeVolumes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeVolumesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeVolumesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeVolumesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSimbaAPIService_v20180301.DescribeVolumes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_volumes(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeVolumes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeVolumes",
            "fsx",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeVolumesInput`](crate::input::DescribeVolumesInput)
    pub fn builder() -> crate::input::describe_volumes_input::Builder {
        crate::input::describe_volumes_input::Builder::default()
    }
}

/// See [`DisassociateFileSystemAliasesInput`](crate::input::DisassociateFileSystemAliasesInput)
pub mod disassociate_file_system_aliases_input {
    /// A builder for [`DisassociateFileSystemAliasesInput`](crate::input::DisassociateFileSystemAliasesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) aliases: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
        /// ASCII characters. This token is automatically filled on your behalf when you use the
        /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
        /// ASCII characters. This token is automatically filled on your behalf when you use the
        /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>Specifies the file system from which to disassociate the DNS aliases.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>Specifies the file system from which to disassociate the DNS aliases.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// Appends an item to `aliases`.
        ///
        /// To override the contents of this collection use [`set_aliases`](Self::set_aliases).
        ///
        /// <p>An array of one or more DNS alias names to disassociate, or remove, from the file system.</p>
        pub fn aliases(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.aliases.unwrap_or_default();
            v.push(input.into());
            self.aliases = Some(v);
            self
        }
        /// <p>An array of one or more DNS alias names to disassociate, or remove, from the file system.</p>
        pub fn set_aliases(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.aliases = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateFileSystemAliasesInput`](crate::input::DisassociateFileSystemAliasesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateFileSystemAliasesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateFileSystemAliasesInput {
                client_request_token: self.client_request_token,
                file_system_id: self.file_system_id,
                aliases: self.aliases,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateFileSystemAliasesInputOperationOutputAlias =
    crate::operation::DisassociateFileSystemAliases;
#[doc(hidden)]
pub type DisassociateFileSystemAliasesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisassociateFileSystemAliasesInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateFileSystemAliases`](crate::operation::DisassociateFileSystemAliases)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateFileSystemAliases,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateFileSystemAliasesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateFileSystemAliasesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateFileSystemAliasesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSimbaAPIService_v20180301.DisassociateFileSystemAliases",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_file_system_aliases(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateFileSystemAliases::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateFileSystemAliases",
            "fsx",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateFileSystemAliasesInput`](crate::input::DisassociateFileSystemAliasesInput)
    pub fn builder() -> crate::input::disassociate_file_system_aliases_input::Builder {
        crate::input::disassociate_file_system_aliases_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the Amazon FSx resource that will have its tags listed.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Amazon FSx resource that will have its tags listed.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>Maximum number of tags to return in the response (integer). This
        /// parameter value must be greater than 0. The number of items that Amazon FSx returns is
        /// the minimum of the <code>MaxResults</code> parameter specified in the request and the
        /// service's internal maximum number of items per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of tags to return in the response (integer). This
        /// parameter value must be greater than 0. The number of items that Amazon FSx returns is
        /// the minimum of the <code>MaxResults</code> parameter specified in the request and the
        /// service's internal maximum number of items per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Opaque pagination token returned from a previous
        /// <code>ListTagsForResource</code> operation (String). If a token present, the action
        /// continues the list from where the returning call left off.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Opaque pagination token returned from a previous
        /// <code>ListTagsForResource</code> operation (String). If a token present, the action
        /// continues the list from where the returning call left off.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSimbaAPIService_v20180301.ListTagsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "fsx",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Amazon FSx resource that you want to
        /// tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon FSx resource that you want to
        /// tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags for the resource. If a tag with a given key already exists, the
        /// value is replaced by the one specified in this parameter.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags for the resource. If a tag with a given key already exists, the
        /// value is replaced by the one specified in this parameter.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSimbaAPIService_v20180301.TagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "fsx",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of the Amazon FSx resource to untag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Amazon FSx resource to untag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of keys of tags on the resource to untag. In case the tag key doesn't exist,
        /// the call will still succeed to be idempotent.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A list of keys of tags on the resource to untag. In case the tag key doesn't exist,
        /// the call will still succeed to be idempotent.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSimbaAPIService_v20180301.UntagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "fsx",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateFileSystemInput`](crate::input::UpdateFileSystemInput)
pub mod update_file_system_input {
    /// A builder for [`UpdateFileSystemInput`](crate::input::UpdateFileSystemInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) storage_capacity: std::option::Option<i32>,
        pub(crate) windows_configuration:
            std::option::Option<crate::model::UpdateFileSystemWindowsConfiguration>,
        pub(crate) lustre_configuration:
            std::option::Option<crate::model::UpdateFileSystemLustreConfiguration>,
        pub(crate) ontap_configuration:
            std::option::Option<crate::model::UpdateFileSystemOntapConfiguration>,
    }
    impl Builder {
        /// <p>Identifies the file system that you are updating.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>Identifies the file system that you are updating.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure
        /// idempotent updates. This string is automatically filled on your behalf when you use
        /// the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure
        /// idempotent updates. This string is automatically filled on your behalf when you use
        /// the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>Use this parameter to increase the storage capacity of an Amazon FSx for Windows File Server
        /// or Amazon FSx for Lustre file system.
        /// Specifies the storage capacity target value, GiB, to increase the storage capacity for the
        /// file system that you're updating. You cannot make a storage capacity increase request if
        /// there is an existing storage capacity increase request in progress.</p>
        /// <p>For Windows file systems, the storage capacity target value must be at least 10 percent
        /// (%) greater than the current storage capacity value. In order to increase storage capacity,
        /// the file system must have at least 16 MB/s of throughput capacity.</p>
        /// <p>For Lustre file systems, the storage capacity target value can be the following:</p>
        /// <ul>
        /// <li>
        /// <p>For <code>SCRATCH_2</code> and <code>PERSISTENT_1 SSD</code> deployment types, valid values
        /// are in multiples of 2400 GiB. The value must be greater than the current storage capacity.</p>
        /// </li>
        /// <li>
        /// <p>For <code>PERSISTENT HDD</code> file systems, valid values are multiples of 6000 GiB for
        /// 12 MB/s/TiB file systems and multiples of 1800 GiB for 40 MB/s/TiB file systems. The values must be greater
        /// than the current storage capacity.</p>
        /// </li>
        /// <li>
        /// <p>For <code>SCRATCH_1</code> file systems, you cannot increase the storage capacity.</p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html">Managing storage
        /// capacity</a> in the <i>Amazon FSx for Windows File Server User Guide</i>
        /// and <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-storage-capacity.html">Managing storage and throughput capacity</a> in the <i>Amazon FSx for Lustre
        /// User Guide</i>.</p>
        pub fn storage_capacity(mut self, input: i32) -> Self {
            self.storage_capacity = Some(input);
            self
        }
        /// <p>Use this parameter to increase the storage capacity of an Amazon FSx for Windows File Server
        /// or Amazon FSx for Lustre file system.
        /// Specifies the storage capacity target value, GiB, to increase the storage capacity for the
        /// file system that you're updating. You cannot make a storage capacity increase request if
        /// there is an existing storage capacity increase request in progress.</p>
        /// <p>For Windows file systems, the storage capacity target value must be at least 10 percent
        /// (%) greater than the current storage capacity value. In order to increase storage capacity,
        /// the file system must have at least 16 MB/s of throughput capacity.</p>
        /// <p>For Lustre file systems, the storage capacity target value can be the following:</p>
        /// <ul>
        /// <li>
        /// <p>For <code>SCRATCH_2</code> and <code>PERSISTENT_1 SSD</code> deployment types, valid values
        /// are in multiples of 2400 GiB. The value must be greater than the current storage capacity.</p>
        /// </li>
        /// <li>
        /// <p>For <code>PERSISTENT HDD</code> file systems, valid values are multiples of 6000 GiB for
        /// 12 MB/s/TiB file systems and multiples of 1800 GiB for 40 MB/s/TiB file systems. The values must be greater
        /// than the current storage capacity.</p>
        /// </li>
        /// <li>
        /// <p>For <code>SCRATCH_1</code> file systems, you cannot increase the storage capacity.</p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html">Managing storage
        /// capacity</a> in the <i>Amazon FSx for Windows File Server User Guide</i>
        /// and <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-storage-capacity.html">Managing storage and throughput capacity</a> in the <i>Amazon FSx for Lustre
        /// User Guide</i>.</p>
        pub fn set_storage_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.storage_capacity = input;
            self
        }
        /// <p>The configuration updates for an Amazon FSx for Windows File Server file system.</p>
        pub fn windows_configuration(
            mut self,
            input: crate::model::UpdateFileSystemWindowsConfiguration,
        ) -> Self {
            self.windows_configuration = Some(input);
            self
        }
        /// <p>The configuration updates for an Amazon FSx for Windows File Server file system.</p>
        pub fn set_windows_configuration(
            mut self,
            input: std::option::Option<crate::model::UpdateFileSystemWindowsConfiguration>,
        ) -> Self {
            self.windows_configuration = input;
            self
        }
        /// <p>The configuration object for Amazon FSx for Lustre file systems used in the
        /// <code>UpdateFileSystem</code> operation.</p>
        pub fn lustre_configuration(
            mut self,
            input: crate::model::UpdateFileSystemLustreConfiguration,
        ) -> Self {
            self.lustre_configuration = Some(input);
            self
        }
        /// <p>The configuration object for Amazon FSx for Lustre file systems used in the
        /// <code>UpdateFileSystem</code> operation.</p>
        pub fn set_lustre_configuration(
            mut self,
            input: std::option::Option<crate::model::UpdateFileSystemLustreConfiguration>,
        ) -> Self {
            self.lustre_configuration = input;
            self
        }
        /// <p>The configuration updates for an Amazon FSx for NetApp ONTAP file system.</p>
        pub fn ontap_configuration(
            mut self,
            input: crate::model::UpdateFileSystemOntapConfiguration,
        ) -> Self {
            self.ontap_configuration = Some(input);
            self
        }
        /// <p>The configuration updates for an Amazon FSx for NetApp ONTAP file system.</p>
        pub fn set_ontap_configuration(
            mut self,
            input: std::option::Option<crate::model::UpdateFileSystemOntapConfiguration>,
        ) -> Self {
            self.ontap_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFileSystemInput`](crate::input::UpdateFileSystemInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFileSystemInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFileSystemInput {
                file_system_id: self.file_system_id,
                client_request_token: self.client_request_token,
                storage_capacity: self.storage_capacity,
                windows_configuration: self.windows_configuration,
                lustre_configuration: self.lustre_configuration,
                ontap_configuration: self.ontap_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFileSystemInputOperationOutputAlias = crate::operation::UpdateFileSystem;
#[doc(hidden)]
pub type UpdateFileSystemInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateFileSystemInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFileSystem`](crate::operation::UpdateFileSystem)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFileSystem,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateFileSystemInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateFileSystemInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateFileSystemInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSimbaAPIService_v20180301.UpdateFileSystem",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_file_system(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFileSystem::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFileSystem",
            "fsx",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateFileSystemInput`](crate::input::UpdateFileSystemInput)
    pub fn builder() -> crate::input::update_file_system_input::Builder {
        crate::input::update_file_system_input::Builder::default()
    }
}

/// See [`UpdateStorageVirtualMachineInput`](crate::input::UpdateStorageVirtualMachineInput)
pub mod update_storage_virtual_machine_input {
    /// A builder for [`UpdateStorageVirtualMachineInput`](crate::input::UpdateStorageVirtualMachineInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) active_directory_configuration:
            std::option::Option<crate::model::UpdateSvmActiveDirectoryConfiguration>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) storage_virtual_machine_id: std::option::Option<std::string::String>,
        pub(crate) svm_admin_password: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Updates the Microsoft Active Directory (AD) configuration for an SVM that is joined to an AD.</p>
        pub fn active_directory_configuration(
            mut self,
            input: crate::model::UpdateSvmActiveDirectoryConfiguration,
        ) -> Self {
            self.active_directory_configuration = Some(input);
            self
        }
        /// <p>Updates the Microsoft Active Directory (AD) configuration for an SVM that is joined to an AD.</p>
        pub fn set_active_directory_configuration(
            mut self,
            input: std::option::Option<crate::model::UpdateSvmActiveDirectoryConfiguration>,
        ) -> Self {
            self.active_directory_configuration = input;
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
        /// ASCII characters. This token is automatically filled on your behalf when you use the
        /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
        /// ASCII characters. This token is automatically filled on your behalf when you use the
        /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The ID of the SVM that you want to update, in the format <code>svm-0123456789abcdef0</code>.</p>
        pub fn storage_virtual_machine_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.storage_virtual_machine_id = Some(input.into());
            self
        }
        /// <p>The ID of the SVM that you want to update, in the format <code>svm-0123456789abcdef0</code>.</p>
        pub fn set_storage_virtual_machine_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.storage_virtual_machine_id = input;
            self
        }
        /// <p>Enter a new SvmAdminPassword if you are updating it.</p>
        pub fn svm_admin_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.svm_admin_password = Some(input.into());
            self
        }
        /// <p>Enter a new SvmAdminPassword if you are updating it.</p>
        pub fn set_svm_admin_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.svm_admin_password = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateStorageVirtualMachineInput`](crate::input::UpdateStorageVirtualMachineInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateStorageVirtualMachineInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateStorageVirtualMachineInput {
                active_directory_configuration: self.active_directory_configuration,
                client_request_token: self.client_request_token,
                storage_virtual_machine_id: self.storage_virtual_machine_id,
                svm_admin_password: self.svm_admin_password,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateStorageVirtualMachineInputOperationOutputAlias =
    crate::operation::UpdateStorageVirtualMachine;
#[doc(hidden)]
pub type UpdateStorageVirtualMachineInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateStorageVirtualMachineInput {
    /// Consumes the builder and constructs an Operation<[`UpdateStorageVirtualMachine`](crate::operation::UpdateStorageVirtualMachine)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateStorageVirtualMachine,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateStorageVirtualMachineInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateStorageVirtualMachineInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateStorageVirtualMachineInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSimbaAPIService_v20180301.UpdateStorageVirtualMachine",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_storage_virtual_machine(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateStorageVirtualMachine::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateStorageVirtualMachine",
            "fsx",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateStorageVirtualMachineInput`](crate::input::UpdateStorageVirtualMachineInput)
    pub fn builder() -> crate::input::update_storage_virtual_machine_input::Builder {
        crate::input::update_storage_virtual_machine_input::Builder::default()
    }
}

/// See [`UpdateVolumeInput`](crate::input::UpdateVolumeInput)
pub mod update_volume_input {
    /// A builder for [`UpdateVolumeInput`](crate::input::UpdateVolumeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) volume_id: std::option::Option<std::string::String>,
        pub(crate) ontap_configuration:
            std::option::Option<crate::model::UpdateOntapVolumeConfiguration>,
    }
    impl Builder {
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
        /// ASCII characters. This token is automatically filled on your behalf when you use the
        /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
        /// ASCII characters. This token is automatically filled on your behalf when you use the
        /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>Specifies the volume that you want to update, formatted <code>fsvol-0123456789abcdef0</code>.</p>
        pub fn volume_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_id = Some(input.into());
            self
        }
        /// <p>Specifies the volume that you want to update, formatted <code>fsvol-0123456789abcdef0</code>.</p>
        pub fn set_volume_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_id = input;
            self
        }
        /// <p>The <code>ONTAP</code> configuration of the volume you are updating.</p>
        pub fn ontap_configuration(
            mut self,
            input: crate::model::UpdateOntapVolumeConfiguration,
        ) -> Self {
            self.ontap_configuration = Some(input);
            self
        }
        /// <p>The <code>ONTAP</code> configuration of the volume you are updating.</p>
        pub fn set_ontap_configuration(
            mut self,
            input: std::option::Option<crate::model::UpdateOntapVolumeConfiguration>,
        ) -> Self {
            self.ontap_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateVolumeInput`](crate::input::UpdateVolumeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateVolumeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateVolumeInput {
                client_request_token: self.client_request_token,
                volume_id: self.volume_id,
                ontap_configuration: self.ontap_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateVolumeInputOperationOutputAlias = crate::operation::UpdateVolume;
#[doc(hidden)]
pub type UpdateVolumeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateVolumeInput {
    /// Consumes the builder and constructs an Operation<[`UpdateVolume`](crate::operation::UpdateVolume)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateVolume,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateVolumeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateVolumeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateVolumeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSSimbaAPIService_v20180301.UpdateVolume",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_volume(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateVolume::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateVolume",
            "fsx",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateVolumeInput`](crate::input::UpdateVolumeInput)
    pub fn builder() -> crate::input::update_volume_input::Builder {
        crate::input::update_volume_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateVolumeInput {
    /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
    /// ASCII characters. This token is automatically filled on your behalf when you use the
    /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>Specifies the volume that you want to update, formatted <code>fsvol-0123456789abcdef0</code>.</p>
    pub volume_id: std::option::Option<std::string::String>,
    /// <p>The <code>ONTAP</code> configuration of the volume you are updating.</p>
    pub ontap_configuration: std::option::Option<crate::model::UpdateOntapVolumeConfiguration>,
}
impl UpdateVolumeInput {
    /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
    /// ASCII characters. This token is automatically filled on your behalf when you use the
    /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>Specifies the volume that you want to update, formatted <code>fsvol-0123456789abcdef0</code>.</p>
    pub fn volume_id(&self) -> std::option::Option<&str> {
        self.volume_id.as_deref()
    }
    /// <p>The <code>ONTAP</code> configuration of the volume you are updating.</p>
    pub fn ontap_configuration(
        &self,
    ) -> std::option::Option<&crate::model::UpdateOntapVolumeConfiguration> {
        self.ontap_configuration.as_ref()
    }
}
impl std::fmt::Debug for UpdateVolumeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateVolumeInput");
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("volume_id", &self.volume_id);
        formatter.field("ontap_configuration", &self.ontap_configuration);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateStorageVirtualMachineInput {
    /// <p>Updates the Microsoft Active Directory (AD) configuration for an SVM that is joined to an AD.</p>
    pub active_directory_configuration:
        std::option::Option<crate::model::UpdateSvmActiveDirectoryConfiguration>,
    /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
    /// ASCII characters. This token is automatically filled on your behalf when you use the
    /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The ID of the SVM that you want to update, in the format <code>svm-0123456789abcdef0</code>.</p>
    pub storage_virtual_machine_id: std::option::Option<std::string::String>,
    /// <p>Enter a new SvmAdminPassword if you are updating it.</p>
    pub svm_admin_password: std::option::Option<std::string::String>,
}
impl UpdateStorageVirtualMachineInput {
    /// <p>Updates the Microsoft Active Directory (AD) configuration for an SVM that is joined to an AD.</p>
    pub fn active_directory_configuration(
        &self,
    ) -> std::option::Option<&crate::model::UpdateSvmActiveDirectoryConfiguration> {
        self.active_directory_configuration.as_ref()
    }
    /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
    /// ASCII characters. This token is automatically filled on your behalf when you use the
    /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The ID of the SVM that you want to update, in the format <code>svm-0123456789abcdef0</code>.</p>
    pub fn storage_virtual_machine_id(&self) -> std::option::Option<&str> {
        self.storage_virtual_machine_id.as_deref()
    }
    /// <p>Enter a new SvmAdminPassword if you are updating it.</p>
    pub fn svm_admin_password(&self) -> std::option::Option<&str> {
        self.svm_admin_password.as_deref()
    }
}
impl std::fmt::Debug for UpdateStorageVirtualMachineInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateStorageVirtualMachineInput");
        formatter.field(
            "active_directory_configuration",
            &self.active_directory_configuration,
        );
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field(
            "storage_virtual_machine_id",
            &self.storage_virtual_machine_id,
        );
        formatter.field("svm_admin_password", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

/// <p>The request object for the <code>UpdateFileSystem</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFileSystemInput {
    /// <p>Identifies the file system that you are updating.</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure
    /// idempotent updates. This string is automatically filled on your behalf when you use
    /// the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>Use this parameter to increase the storage capacity of an Amazon FSx for Windows File Server
    /// or Amazon FSx for Lustre file system.
    /// Specifies the storage capacity target value, GiB, to increase the storage capacity for the
    /// file system that you're updating. You cannot make a storage capacity increase request if
    /// there is an existing storage capacity increase request in progress.</p>
    /// <p>For Windows file systems, the storage capacity target value must be at least 10 percent
    /// (%) greater than the current storage capacity value. In order to increase storage capacity,
    /// the file system must have at least 16 MB/s of throughput capacity.</p>
    /// <p>For Lustre file systems, the storage capacity target value can be the following:</p>
    /// <ul>
    /// <li>
    /// <p>For <code>SCRATCH_2</code> and <code>PERSISTENT_1 SSD</code> deployment types, valid values
    /// are in multiples of 2400 GiB. The value must be greater than the current storage capacity.</p>
    /// </li>
    /// <li>
    /// <p>For <code>PERSISTENT HDD</code> file systems, valid values are multiples of 6000 GiB for
    /// 12 MB/s/TiB file systems and multiples of 1800 GiB for 40 MB/s/TiB file systems. The values must be greater
    /// than the current storage capacity.</p>
    /// </li>
    /// <li>
    /// <p>For <code>SCRATCH_1</code> file systems, you cannot increase the storage capacity.</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html">Managing storage
    /// capacity</a> in the <i>Amazon FSx for Windows File Server User Guide</i>
    /// and <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-storage-capacity.html">Managing storage and throughput capacity</a> in the <i>Amazon FSx for Lustre
    /// User Guide</i>.</p>
    pub storage_capacity: std::option::Option<i32>,
    /// <p>The configuration updates for an Amazon FSx for Windows File Server file system.</p>
    pub windows_configuration:
        std::option::Option<crate::model::UpdateFileSystemWindowsConfiguration>,
    /// <p>The configuration object for Amazon FSx for Lustre file systems used in the
    /// <code>UpdateFileSystem</code> operation.</p>
    pub lustre_configuration:
        std::option::Option<crate::model::UpdateFileSystemLustreConfiguration>,
    /// <p>The configuration updates for an Amazon FSx for NetApp ONTAP file system.</p>
    pub ontap_configuration: std::option::Option<crate::model::UpdateFileSystemOntapConfiguration>,
}
impl UpdateFileSystemInput {
    /// <p>Identifies the file system that you are updating.</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
    /// <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure
    /// idempotent updates. This string is automatically filled on your behalf when you use
    /// the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>Use this parameter to increase the storage capacity of an Amazon FSx for Windows File Server
    /// or Amazon FSx for Lustre file system.
    /// Specifies the storage capacity target value, GiB, to increase the storage capacity for the
    /// file system that you're updating. You cannot make a storage capacity increase request if
    /// there is an existing storage capacity increase request in progress.</p>
    /// <p>For Windows file systems, the storage capacity target value must be at least 10 percent
    /// (%) greater than the current storage capacity value. In order to increase storage capacity,
    /// the file system must have at least 16 MB/s of throughput capacity.</p>
    /// <p>For Lustre file systems, the storage capacity target value can be the following:</p>
    /// <ul>
    /// <li>
    /// <p>For <code>SCRATCH_2</code> and <code>PERSISTENT_1 SSD</code> deployment types, valid values
    /// are in multiples of 2400 GiB. The value must be greater than the current storage capacity.</p>
    /// </li>
    /// <li>
    /// <p>For <code>PERSISTENT HDD</code> file systems, valid values are multiples of 6000 GiB for
    /// 12 MB/s/TiB file systems and multiples of 1800 GiB for 40 MB/s/TiB file systems. The values must be greater
    /// than the current storage capacity.</p>
    /// </li>
    /// <li>
    /// <p>For <code>SCRATCH_1</code> file systems, you cannot increase the storage capacity.</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html">Managing storage
    /// capacity</a> in the <i>Amazon FSx for Windows File Server User Guide</i>
    /// and <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-storage-capacity.html">Managing storage and throughput capacity</a> in the <i>Amazon FSx for Lustre
    /// User Guide</i>.</p>
    pub fn storage_capacity(&self) -> std::option::Option<i32> {
        self.storage_capacity
    }
    /// <p>The configuration updates for an Amazon FSx for Windows File Server file system.</p>
    pub fn windows_configuration(
        &self,
    ) -> std::option::Option<&crate::model::UpdateFileSystemWindowsConfiguration> {
        self.windows_configuration.as_ref()
    }
    /// <p>The configuration object for Amazon FSx for Lustre file systems used in the
    /// <code>UpdateFileSystem</code> operation.</p>
    pub fn lustre_configuration(
        &self,
    ) -> std::option::Option<&crate::model::UpdateFileSystemLustreConfiguration> {
        self.lustre_configuration.as_ref()
    }
    /// <p>The configuration updates for an Amazon FSx for NetApp ONTAP file system.</p>
    pub fn ontap_configuration(
        &self,
    ) -> std::option::Option<&crate::model::UpdateFileSystemOntapConfiguration> {
        self.ontap_configuration.as_ref()
    }
}
impl std::fmt::Debug for UpdateFileSystemInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFileSystemInput");
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("storage_capacity", &self.storage_capacity);
        formatter.field("windows_configuration", &self.windows_configuration);
        formatter.field("lustre_configuration", &self.lustre_configuration);
        formatter.field("ontap_configuration", &self.ontap_configuration);
        formatter.finish()
    }
}

/// <p>The request object for <code>UntagResource</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The ARN of the Amazon FSx resource to untag.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of keys of tags on the resource to untag. In case the tag key doesn't exist,
    /// the call will still succeed to be idempotent.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The ARN of the Amazon FSx resource to untag.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of keys of tags on the resource to untag. In case the tag key doesn't exist,
    /// the call will still succeed to be idempotent.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

/// <p>The request object for the <code>TagResource</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the Amazon FSx resource that you want to
    /// tag.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of tags for the resource. If a tag with a given key already exists, the
    /// value is replaced by the one specified in this parameter.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the Amazon FSx resource that you want to
    /// tag.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of tags for the resource. If a tag with a given key already exists, the
    /// value is replaced by the one specified in this parameter.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>The request object for <code>ListTagsForResource</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The ARN of the Amazon FSx resource that will have its tags listed.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Maximum number of tags to return in the response (integer). This
    /// parameter value must be greater than 0. The number of items that Amazon FSx returns is
    /// the minimum of the <code>MaxResults</code> parameter specified in the request and the
    /// service's internal maximum number of items per page.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Opaque pagination token returned from a previous
    /// <code>ListTagsForResource</code> operation (String). If a token present, the action
    /// continues the list from where the returning call left off.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The ARN of the Amazon FSx resource that will have its tags listed.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>Maximum number of tags to return in the response (integer). This
    /// parameter value must be greater than 0. The number of items that Amazon FSx returns is
    /// the minimum of the <code>MaxResults</code> parameter specified in the request and the
    /// service's internal maximum number of items per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Opaque pagination token returned from a previous
    /// <code>ListTagsForResource</code> operation (String). If a token present, the action
    /// continues the list from where the returning call left off.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>The request object of DNS aliases to disassociate from an Amazon FSx for Windows File Server file system.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateFileSystemAliasesInput {
    /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
    /// ASCII characters. This token is automatically filled on your behalf when you use the
    /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>Specifies the file system from which to disassociate the DNS aliases.</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>An array of one or more DNS alias names to disassociate, or remove, from the file system.</p>
    pub aliases: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DisassociateFileSystemAliasesInput {
    /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
    /// ASCII characters. This token is automatically filled on your behalf when you use the
    /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>Specifies the file system from which to disassociate the DNS aliases.</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
    /// <p>An array of one or more DNS alias names to disassociate, or remove, from the file system.</p>
    pub fn aliases(&self) -> std::option::Option<&[std::string::String]> {
        self.aliases.as_deref()
    }
}
impl std::fmt::Debug for DisassociateFileSystemAliasesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateFileSystemAliasesInput");
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("aliases", &self.aliases);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeVolumesInput {
    /// <p>IDs of the volumes whose descriptions you want to retrieve.</p>
    pub volume_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Enter a filter name:value pair to view a select set of volumes.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::VolumeFilter>>,
    /// <p>The maximum number of resources to return in the response. This value must be an
    /// integer greater than zero.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If
    /// present, this token indicates from what point you can continue processing the request, where
    /// the previous <code>NextToken</code> value left off.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeVolumesInput {
    /// <p>IDs of the volumes whose descriptions you want to retrieve.</p>
    pub fn volume_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.volume_ids.as_deref()
    }
    /// <p>Enter a filter name:value pair to view a select set of volumes.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::VolumeFilter]> {
        self.filters.as_deref()
    }
    /// <p>The maximum number of resources to return in the response. This value must be an
    /// integer greater than zero.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If
    /// present, this token indicates from what point you can continue processing the request, where
    /// the previous <code>NextToken</code> value left off.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeVolumesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeVolumesInput");
        formatter.field("volume_ids", &self.volume_ids);
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeStorageVirtualMachinesInput {
    /// <p>Enter the ID of one or more SVMs that you want to view.</p>
    pub storage_virtual_machine_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Enter a filter name:value pair to view a select set of SVMs.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::StorageVirtualMachineFilter>>,
    /// <p>The maximum number of resources to return in the response. This value must be an
    /// integer greater than zero.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If
    /// present, this token indicates from what point you can continue processing the request, where
    /// the previous <code>NextToken</code> value left off.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeStorageVirtualMachinesInput {
    /// <p>Enter the ID of one or more SVMs that you want to view.</p>
    pub fn storage_virtual_machine_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.storage_virtual_machine_ids.as_deref()
    }
    /// <p>Enter a filter name:value pair to view a select set of SVMs.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::StorageVirtualMachineFilter]> {
        self.filters.as_deref()
    }
    /// <p>The maximum number of resources to return in the response. This value must be an
    /// integer greater than zero.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If
    /// present, this token indicates from what point you can continue processing the request, where
    /// the previous <code>NextToken</code> value left off.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeStorageVirtualMachinesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeStorageVirtualMachinesInput");
        formatter.field(
            "storage_virtual_machine_ids",
            &self.storage_virtual_machine_ids,
        );
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>The request object for <code>DescribeFileSystems</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFileSystemsInput {
    /// <p>IDs of the file systems whose descriptions you want to retrieve
    /// (String).</p>
    pub file_system_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Maximum number of file systems to return in the response (integer). This
    /// parameter value must be greater than 0. The number of items that Amazon FSx returns is
    /// the minimum of the <code>MaxResults</code> parameter specified in the request and the
    /// service's internal maximum number of items per page.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Opaque pagination token returned from a previous
    /// <code>DescribeFileSystems</code> operation (String). If a token present, the action
    /// continues the list from where the returning call left off.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeFileSystemsInput {
    /// <p>IDs of the file systems whose descriptions you want to retrieve
    /// (String).</p>
    pub fn file_system_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.file_system_ids.as_deref()
    }
    /// <p>Maximum number of file systems to return in the response (integer). This
    /// parameter value must be greater than 0. The number of items that Amazon FSx returns is
    /// the minimum of the <code>MaxResults</code> parameter specified in the request and the
    /// service's internal maximum number of items per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Opaque pagination token returned from a previous
    /// <code>DescribeFileSystems</code> operation (String). If a token present, the action
    /// continues the list from where the returning call left off.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeFileSystemsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFileSystemsInput");
        formatter.field("file_system_ids", &self.file_system_ids);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>The request object for <code>DescribeFileSystemAliases</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFileSystemAliasesInput {
    /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
    /// ASCII characters. This token is automatically filled on your behalf when you use the
    /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The ID of the file system to return the associated DNS aliases for
    /// (String).</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>Maximum number of DNS aliases to return in the response (integer). This
    /// parameter value must be greater than 0. The number of items that Amazon FSx returns is
    /// the minimum of the <code>MaxResults</code> parameter specified in the request and the
    /// service's internal maximum number of items per page.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Opaque pagination token returned from a previous
    /// <code>DescribeFileSystemAliases</code> operation (String). If a token is included in the request, the action
    /// continues the list from where the previous returning call left off.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeFileSystemAliasesInput {
    /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
    /// ASCII characters. This token is automatically filled on your behalf when you use the
    /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The ID of the file system to return the associated DNS aliases for
    /// (String).</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
    /// <p>Maximum number of DNS aliases to return in the response (integer). This
    /// parameter value must be greater than 0. The number of items that Amazon FSx returns is
    /// the minimum of the <code>MaxResults</code> parameter specified in the request and the
    /// service's internal maximum number of items per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Opaque pagination token returned from a previous
    /// <code>DescribeFileSystemAliases</code> operation (String). If a token is included in the request, the action
    /// continues the list from where the previous returning call left off.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeFileSystemAliasesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFileSystemAliasesInput");
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDataRepositoryTasksInput {
    /// <p>(Optional) IDs of the tasks whose descriptions you want to retrieve
    /// (String).</p>
    pub task_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>(Optional) You can use filters to narrow the <code>DescribeDataRepositoryTasks</code> response to
    /// include just tasks for specific file systems, or tasks in a specific lifecycle state.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::DataRepositoryTaskFilter>>,
    /// <p>The maximum number of resources to return in the response. This value must be an
    /// integer greater than zero.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If
    /// present, this token indicates from what point you can continue processing the request, where
    /// the previous <code>NextToken</code> value left off.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeDataRepositoryTasksInput {
    /// <p>(Optional) IDs of the tasks whose descriptions you want to retrieve
    /// (String).</p>
    pub fn task_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.task_ids.as_deref()
    }
    /// <p>(Optional) You can use filters to narrow the <code>DescribeDataRepositoryTasks</code> response to
    /// include just tasks for specific file systems, or tasks in a specific lifecycle state.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::DataRepositoryTaskFilter]> {
        self.filters.as_deref()
    }
    /// <p>The maximum number of resources to return in the response. This value must be an
    /// integer greater than zero.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>(Optional) Opaque pagination token returned from a previous operation (String). If
    /// present, this token indicates from what point you can continue processing the request, where
    /// the previous <code>NextToken</code> value left off.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeDataRepositoryTasksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDataRepositoryTasksInput");
        formatter.field("task_ids", &self.task_ids);
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>The request object for <code>DescribeBackups</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBackupsInput {
    /// <p>IDs of the backups you want to retrieve (String). This overrides any
    /// filters. If any IDs are not found, BackupNotFound will be thrown.</p>
    pub backup_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Filters structure. Supported names are <code>file-system-id</code>,
    /// <code>backup-type</code>, <code>file-system-type</code>, and
    /// <code>volume-id</code>.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>Maximum number of backups to return in the response (integer). This
    /// parameter value must be greater than 0. The number of items that Amazon FSx returns is
    /// the minimum of the <code>MaxResults</code> parameter specified in the request and the
    /// service's internal maximum number of items per page.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Opaque pagination token returned from a previous
    /// <code>DescribeBackups</code> operation (String). If a token present, the action
    /// continues the list from where the returning call left off.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeBackupsInput {
    /// <p>IDs of the backups you want to retrieve (String). This overrides any
    /// filters. If any IDs are not found, BackupNotFound will be thrown.</p>
    pub fn backup_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.backup_ids.as_deref()
    }
    /// <p>Filters structure. Supported names are <code>file-system-id</code>,
    /// <code>backup-type</code>, <code>file-system-type</code>, and
    /// <code>volume-id</code>.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p>Maximum number of backups to return in the response (integer). This
    /// parameter value must be greater than 0. The number of items that Amazon FSx returns is
    /// the minimum of the <code>MaxResults</code> parameter specified in the request and the
    /// service's internal maximum number of items per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Opaque pagination token returned from a previous
    /// <code>DescribeBackups</code> operation (String). If a token present, the action
    /// continues the list from where the returning call left off.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeBackupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBackupsInput");
        formatter.field("backup_ids", &self.backup_ids);
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVolumeInput {
    /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
    /// ASCII characters. This token is automatically filled on your behalf when you use the
    /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The ID of the volume you are deleting.</p>
    pub volume_id: std::option::Option<std::string::String>,
    /// <p>For Amazon FSx for ONTAP volumes, specify whether to take
    /// a final backup of the volume, and apply tags to the backup.</p>
    pub ontap_configuration: std::option::Option<crate::model::DeleteVolumeOntapConfiguration>,
}
impl DeleteVolumeInput {
    /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
    /// ASCII characters. This token is automatically filled on your behalf when you use the
    /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The ID of the volume you are deleting.</p>
    pub fn volume_id(&self) -> std::option::Option<&str> {
        self.volume_id.as_deref()
    }
    /// <p>For Amazon FSx for ONTAP volumes, specify whether to take
    /// a final backup of the volume, and apply tags to the backup.</p>
    pub fn ontap_configuration(
        &self,
    ) -> std::option::Option<&crate::model::DeleteVolumeOntapConfiguration> {
        self.ontap_configuration.as_ref()
    }
}
impl std::fmt::Debug for DeleteVolumeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVolumeInput");
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("volume_id", &self.volume_id);
        formatter.field("ontap_configuration", &self.ontap_configuration);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteStorageVirtualMachineInput {
    /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
    /// ASCII characters. This token is automatically filled on your behalf when you use the
    /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The ID of the SVM that you want to delete.</p>
    pub storage_virtual_machine_id: std::option::Option<std::string::String>,
}
impl DeleteStorageVirtualMachineInput {
    /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
    /// ASCII characters. This token is automatically filled on your behalf when you use the
    /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The ID of the SVM that you want to delete.</p>
    pub fn storage_virtual_machine_id(&self) -> std::option::Option<&str> {
        self.storage_virtual_machine_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteStorageVirtualMachineInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteStorageVirtualMachineInput");
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field(
            "storage_virtual_machine_id",
            &self.storage_virtual_machine_id,
        );
        formatter.finish()
    }
}

/// <p>The request object for <code>DeleteFileSystem</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFileSystemInput {
    /// <p>The ID of the file system you want to delete.</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure
    /// idempotent deletion. This is automatically filled on your behalf when using the
    /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The configuration object for the Microsoft Windows file system used in the
    /// <code>DeleteFileSystem</code> operation.</p>
    pub windows_configuration:
        std::option::Option<crate::model::DeleteFileSystemWindowsConfiguration>,
    /// <p>The configuration object for the Amazon FSx for Lustre file system being deleted in the
    /// <code>DeleteFileSystem</code> operation.</p>
    pub lustre_configuration:
        std::option::Option<crate::model::DeleteFileSystemLustreConfiguration>,
}
impl DeleteFileSystemInput {
    /// <p>The ID of the file system you want to delete.</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
    /// <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure
    /// idempotent deletion. This is automatically filled on your behalf when using the
    /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The configuration object for the Microsoft Windows file system used in the
    /// <code>DeleteFileSystem</code> operation.</p>
    pub fn windows_configuration(
        &self,
    ) -> std::option::Option<&crate::model::DeleteFileSystemWindowsConfiguration> {
        self.windows_configuration.as_ref()
    }
    /// <p>The configuration object for the Amazon FSx for Lustre file system being deleted in the
    /// <code>DeleteFileSystem</code> operation.</p>
    pub fn lustre_configuration(
        &self,
    ) -> std::option::Option<&crate::model::DeleteFileSystemLustreConfiguration> {
        self.lustre_configuration.as_ref()
    }
}
impl std::fmt::Debug for DeleteFileSystemInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFileSystemInput");
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("windows_configuration", &self.windows_configuration);
        formatter.field("lustre_configuration", &self.lustre_configuration);
        formatter.finish()
    }
}

/// <p>The request object for <code>DeleteBackup</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBackupInput {
    /// <p>The ID of the backup you want to delete.</p>
    pub backup_id: std::option::Option<std::string::String>,
    /// <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure
    /// idempotent deletion. This is automatically filled on your behalf when using
    /// the CLI or SDK.</p>
    pub client_request_token: std::option::Option<std::string::String>,
}
impl DeleteBackupInput {
    /// <p>The ID of the backup you want to delete.</p>
    pub fn backup_id(&self) -> std::option::Option<&str> {
        self.backup_id.as_deref()
    }
    /// <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure
    /// idempotent deletion. This is automatically filled on your behalf when using
    /// the CLI or SDK.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
}
impl std::fmt::Debug for DeleteBackupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBackupInput");
        formatter.field("backup_id", &self.backup_id);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateVolumeFromBackupInput {
    /// <p>The ID of the source backup. Specifies the backup you are copying.</p>
    pub backup_id: std::option::Option<std::string::String>,
    /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
    /// ASCII characters. This token is automatically filled on your behalf when you use the
    /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The name of the new volume you're creating.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Specifies the configuration of the ONTAP volume that you are creating.</p>
    pub ontap_configuration: std::option::Option<crate::model::CreateOntapVolumeConfiguration>,
    /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateVolumeFromBackupInput {
    /// <p>The ID of the source backup. Specifies the backup you are copying.</p>
    pub fn backup_id(&self) -> std::option::Option<&str> {
        self.backup_id.as_deref()
    }
    /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
    /// ASCII characters. This token is automatically filled on your behalf when you use the
    /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The name of the new volume you're creating.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Specifies the configuration of the ONTAP volume that you are creating.</p>
    pub fn ontap_configuration(
        &self,
    ) -> std::option::Option<&crate::model::CreateOntapVolumeConfiguration> {
        self.ontap_configuration.as_ref()
    }
    /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateVolumeFromBackupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateVolumeFromBackupInput");
        formatter.field("backup_id", &self.backup_id);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("name", &self.name);
        formatter.field("ontap_configuration", &self.ontap_configuration);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateVolumeInput {
    /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
    /// ASCII characters. This token is automatically filled on your behalf when you use the
    /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>Specifies the type of volume to create; <code>ONTAP</code> is the only valid volume type.</p>
    pub volume_type: std::option::Option<crate::model::VolumeType>,
    /// <p>Specifies the name of the volume you're creating.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Specifies the <code>ONTAP</code> configuration to use in creating the volume.</p>
    pub ontap_configuration: std::option::Option<crate::model::CreateOntapVolumeConfiguration>,
    /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateVolumeInput {
    /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
    /// ASCII characters. This token is automatically filled on your behalf when you use the
    /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>Specifies the type of volume to create; <code>ONTAP</code> is the only valid volume type.</p>
    pub fn volume_type(&self) -> std::option::Option<&crate::model::VolumeType> {
        self.volume_type.as_ref()
    }
    /// <p>Specifies the name of the volume you're creating.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Specifies the <code>ONTAP</code> configuration to use in creating the volume.</p>
    pub fn ontap_configuration(
        &self,
    ) -> std::option::Option<&crate::model::CreateOntapVolumeConfiguration> {
        self.ontap_configuration.as_ref()
    }
    /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateVolumeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateVolumeInput");
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("volume_type", &self.volume_type);
        formatter.field("name", &self.name);
        formatter.field("ontap_configuration", &self.ontap_configuration);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateStorageVirtualMachineInput {
    /// <p>Describes the self-managed Microsoft Active Directory to which you want to join the SVM.
    /// Joining an Active Directory provides user authentication and access control for SMB clients,
    /// including Microsoft Windows and macOS client accessing the file system.</p>
    pub active_directory_configuration:
        std::option::Option<crate::model::CreateSvmActiveDirectoryConfiguration>,
    /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
    /// ASCII characters. This token is automatically filled on your behalf when you use the
    /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The globally unique ID of the file system, assigned by Amazon FSx.</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>The name of the SVM.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The password to use when managing the SVM using the NetApp ONTAP CLI or REST API.
    /// If you do not specify a password, you can still use the file system's
    /// <code>fsxadmin</code> user to manage the SVM.</p>
    pub svm_admin_password: std::option::Option<std::string::String>,
    /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The security style of the root volume of the SVM. Specify one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>UNIX</code> if the file system is managed by a UNIX
    /// administrator, the majority of users are NFS clients, and an application
    /// accessing the data uses a UNIX user as the service account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NTFS</code> if the file system is managed by a Windows
    /// administrator, the majority of users are SMB clients, and an application
    /// accessing the data uses a Windows user as the service account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MIXED</code> if the file system is managed by both UNIX
    /// and Windows administrators and users consist of both NFS and SMB clients.</p>
    /// </li>
    /// </ul>
    pub root_volume_security_style:
        std::option::Option<crate::model::StorageVirtualMachineRootVolumeSecurityStyle>,
}
impl CreateStorageVirtualMachineInput {
    /// <p>Describes the self-managed Microsoft Active Directory to which you want to join the SVM.
    /// Joining an Active Directory provides user authentication and access control for SMB clients,
    /// including Microsoft Windows and macOS client accessing the file system.</p>
    pub fn active_directory_configuration(
        &self,
    ) -> std::option::Option<&crate::model::CreateSvmActiveDirectoryConfiguration> {
        self.active_directory_configuration.as_ref()
    }
    /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
    /// ASCII characters. This token is automatically filled on your behalf when you use the
    /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The globally unique ID of the file system, assigned by Amazon FSx.</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
    /// <p>The name of the SVM.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The password to use when managing the SVM using the NetApp ONTAP CLI or REST API.
    /// If you do not specify a password, you can still use the file system's
    /// <code>fsxadmin</code> user to manage the SVM.</p>
    pub fn svm_admin_password(&self) -> std::option::Option<&str> {
        self.svm_admin_password.as_deref()
    }
    /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The security style of the root volume of the SVM. Specify one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>UNIX</code> if the file system is managed by a UNIX
    /// administrator, the majority of users are NFS clients, and an application
    /// accessing the data uses a UNIX user as the service account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NTFS</code> if the file system is managed by a Windows
    /// administrator, the majority of users are SMB clients, and an application
    /// accessing the data uses a Windows user as the service account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MIXED</code> if the file system is managed by both UNIX
    /// and Windows administrators and users consist of both NFS and SMB clients.</p>
    /// </li>
    /// </ul>
    pub fn root_volume_security_style(
        &self,
    ) -> std::option::Option<&crate::model::StorageVirtualMachineRootVolumeSecurityStyle> {
        self.root_volume_security_style.as_ref()
    }
}
impl std::fmt::Debug for CreateStorageVirtualMachineInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateStorageVirtualMachineInput");
        formatter.field(
            "active_directory_configuration",
            &self.active_directory_configuration,
        );
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("name", &self.name);
        formatter.field("svm_admin_password", &"*** Sensitive Data Redacted ***");
        formatter.field("tags", &self.tags);
        formatter.field(
            "root_volume_security_style",
            &self.root_volume_security_style,
        );
        formatter.finish()
    }
}

/// <p>The request object for the <code>CreateFileSystemFromBackup</code>
/// operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFileSystemFromBackupInput {
    /// <p>The ID of the source backup. Specifies the backup you are copying.</p>
    pub backup_id: std::option::Option<std::string::String>,
    /// <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure
    /// idempotent creation. This string is automatically filled on your behalf when you use the
    /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>Specifies the IDs of the subnets that the file system will be accessible from. For Windows <code>MULTI_AZ_1</code>
    /// file system deployment types, provide exactly two subnet IDs, one for the preferred file server
    /// and one for the standby file server. You specify one of these subnets as the preferred subnet
    /// using the <code>WindowsConfiguration > PreferredSubnetID</code> property.</p>
    /// <p>For Windows <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> deployment
    /// types and Lustre file systems, provide exactly one subnet ID.
    /// The file server is launched in that subnet's Availability Zone.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of IDs for the security groups that apply to the specified network
    /// interfaces created for file system access. These security groups apply to all network
    /// interfaces. This value isn't returned in later DescribeFileSystem requests.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The tags to be applied to the file system at file system creation. The key value of
    /// the <code>Name</code> tag appears in the console as the file system
    /// name.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The configuration for this Microsoft Windows file system.</p>
    pub windows_configuration:
        std::option::Option<crate::model::CreateFileSystemWindowsConfiguration>,
    /// <p>The Lustre configuration for the file system being created.
    /// </p>
    pub lustre_configuration:
        std::option::Option<crate::model::CreateFileSystemLustreConfiguration>,
    /// <p>Sets the storage type for the Windows file system you're creating from a backup.
    /// Valid values are <code>SSD</code> and <code>HDD</code>.</p>
    /// <ul>
    /// <li>
    /// <p>Set to <code>SSD</code> to use solid state drive storage.
    /// Supported on all Windows deployment types.</p>
    /// </li>
    /// <li>
    /// <p>Set to <code>HDD</code> to use hard disk drive storage.
    /// Supported on <code>SINGLE_AZ_2</code> and <code>MULTI_AZ_1</code> Windows file system deployment types.
    /// </p>
    /// </li>
    /// </ul>
    /// <p>
    /// Default value is <code>SSD</code>.
    /// </p>
    /// <note>
    /// <p>HDD and SSD storage types have different minimum storage capacity requirements.
    /// A restored file system's storage capacity is tied to the file system that was backed up.
    /// You can create a file system that uses HDD storage from a backup of a file system that
    /// used SSD storage only if the original SSD file system had a storage capacity of at least 2000 GiB.
    /// </p>
    /// </note>
    pub storage_type: std::option::Option<crate::model::StorageType>,
    /// <p>The ID of the Key Management Service (KMS) key used to encrypt the file system's data
    /// for Amazon FSx for Windows File Server file systems, Amazon FSx for NetApp ONTAP file systems, and
    /// Amazon FSx for Lustre <code>PERSISTENT_1</code> file systems at rest. If not specified, the Amazon FSx
    /// managed key is used. The Amazon FSx for Lustre <code>SCRATCH_1</code> and <code>SCRATCH_2</code> file systems
    /// are always encrypted at rest using Amazon FSx managed keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html">Encrypt</a>
    /// in the <i>Key Management Service API Reference</i>.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>Sets the version for the Amazon FSx for Lustre file system you're creating from a backup.
    /// Valid values are <code>2.10</code> and <code>2.12</code>.</p>
    /// <p>You don't need to specify <code>FileSystemTypeVersion</code> because it will
    /// be applied using the backup's <code>FileSystemTypeVersion</code> setting.
    /// If you choose to specify <code>FileSystemTypeVersion</code> when creating from backup, the
    /// value must match the backup's <code>FileSystemTypeVersion</code> setting.</p>
    pub file_system_type_version: std::option::Option<std::string::String>,
}
impl CreateFileSystemFromBackupInput {
    /// <p>The ID of the source backup. Specifies the backup you are copying.</p>
    pub fn backup_id(&self) -> std::option::Option<&str> {
        self.backup_id.as_deref()
    }
    /// <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure
    /// idempotent creation. This string is automatically filled on your behalf when you use the
    /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>Specifies the IDs of the subnets that the file system will be accessible from. For Windows <code>MULTI_AZ_1</code>
    /// file system deployment types, provide exactly two subnet IDs, one for the preferred file server
    /// and one for the standby file server. You specify one of these subnets as the preferred subnet
    /// using the <code>WindowsConfiguration > PreferredSubnetID</code> property.</p>
    /// <p>For Windows <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> deployment
    /// types and Lustre file systems, provide exactly one subnet ID.
    /// The file server is launched in that subnet's Availability Zone.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>A list of IDs for the security groups that apply to the specified network
    /// interfaces created for file system access. These security groups apply to all network
    /// interfaces. This value isn't returned in later DescribeFileSystem requests.</p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
    /// <p>The tags to be applied to the file system at file system creation. The key value of
    /// the <code>Name</code> tag appears in the console as the file system
    /// name.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The configuration for this Microsoft Windows file system.</p>
    pub fn windows_configuration(
        &self,
    ) -> std::option::Option<&crate::model::CreateFileSystemWindowsConfiguration> {
        self.windows_configuration.as_ref()
    }
    /// <p>The Lustre configuration for the file system being created.
    /// </p>
    pub fn lustre_configuration(
        &self,
    ) -> std::option::Option<&crate::model::CreateFileSystemLustreConfiguration> {
        self.lustre_configuration.as_ref()
    }
    /// <p>Sets the storage type for the Windows file system you're creating from a backup.
    /// Valid values are <code>SSD</code> and <code>HDD</code>.</p>
    /// <ul>
    /// <li>
    /// <p>Set to <code>SSD</code> to use solid state drive storage.
    /// Supported on all Windows deployment types.</p>
    /// </li>
    /// <li>
    /// <p>Set to <code>HDD</code> to use hard disk drive storage.
    /// Supported on <code>SINGLE_AZ_2</code> and <code>MULTI_AZ_1</code> Windows file system deployment types.
    /// </p>
    /// </li>
    /// </ul>
    /// <p>
    /// Default value is <code>SSD</code>.
    /// </p>
    /// <note>
    /// <p>HDD and SSD storage types have different minimum storage capacity requirements.
    /// A restored file system's storage capacity is tied to the file system that was backed up.
    /// You can create a file system that uses HDD storage from a backup of a file system that
    /// used SSD storage only if the original SSD file system had a storage capacity of at least 2000 GiB.
    /// </p>
    /// </note>
    pub fn storage_type(&self) -> std::option::Option<&crate::model::StorageType> {
        self.storage_type.as_ref()
    }
    /// <p>The ID of the Key Management Service (KMS) key used to encrypt the file system's data
    /// for Amazon FSx for Windows File Server file systems, Amazon FSx for NetApp ONTAP file systems, and
    /// Amazon FSx for Lustre <code>PERSISTENT_1</code> file systems at rest. If not specified, the Amazon FSx
    /// managed key is used. The Amazon FSx for Lustre <code>SCRATCH_1</code> and <code>SCRATCH_2</code> file systems
    /// are always encrypted at rest using Amazon FSx managed keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html">Encrypt</a>
    /// in the <i>Key Management Service API Reference</i>.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>Sets the version for the Amazon FSx for Lustre file system you're creating from a backup.
    /// Valid values are <code>2.10</code> and <code>2.12</code>.</p>
    /// <p>You don't need to specify <code>FileSystemTypeVersion</code> because it will
    /// be applied using the backup's <code>FileSystemTypeVersion</code> setting.
    /// If you choose to specify <code>FileSystemTypeVersion</code> when creating from backup, the
    /// value must match the backup's <code>FileSystemTypeVersion</code> setting.</p>
    pub fn file_system_type_version(&self) -> std::option::Option<&str> {
        self.file_system_type_version.as_deref()
    }
}
impl std::fmt::Debug for CreateFileSystemFromBackupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFileSystemFromBackupInput");
        formatter.field("backup_id", &self.backup_id);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("tags", &self.tags);
        formatter.field("windows_configuration", &self.windows_configuration);
        formatter.field("lustre_configuration", &self.lustre_configuration);
        formatter.field("storage_type", &self.storage_type);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("file_system_type_version", &self.file_system_type_version);
        formatter.finish()
    }
}

/// <p>The request object used to create a new Amazon FSx file system.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFileSystemInput {
    /// <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure
    /// idempotent creation. This string is automatically filled on your behalf when you use the
    /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The type of Amazon FSx file system to create. Valid values are <code>WINDOWS</code>,
    /// <code>LUSTRE</code>, and <code>ONTAP</code>.</p>
    pub file_system_type: std::option::Option<crate::model::FileSystemType>,
    /// <p>Sets the storage capacity of the file system that you're creating.</p>      
    /// <p>For Lustre file systems:</p>
    /// <ul>
    /// <li>
    /// <p>For <code>SCRATCH_2</code> and <code>PERSISTENT_1 SSD</code> deployment types, valid values are
    /// 1200 GiB, 2400 GiB, and increments of 2400 GiB.</p>
    /// </li>
    /// <li>
    /// <p>For <code>PERSISTENT HDD</code> file systems, valid values are increments of 6000 GiB for
    /// 12 MB/s/TiB file systems and increments of 1800 GiB for 40 MB/s/TiB file systems.</p>
    /// </li>
    /// <li>
    /// <p>For <code>SCRATCH_1</code> deployment type, valid values are
    /// 1200 GiB, 2400 GiB, and increments of 3600 GiB.</p>
    /// </li>
    /// </ul>
    /// <p>For Windows file systems:</p>
    /// <ul>
    /// <li>
    /// <p>If <code>StorageType=SSD</code>, valid values are 32 GiB - 65,536 GiB (64 TiB).</p>
    /// </li>
    /// <li>
    /// <p>If <code>StorageType=HDD</code>, valid values are 2000 GiB - 65,536 GiB (64 TiB).</p>
    /// </li>
    /// </ul>
    /// <p>For ONTAP file systems:</p>
    /// <ul>
    /// <li>
    /// <p>Valid values are 1024 GiB - 196,608 GiB (192 TiB).</p>
    /// </li>
    /// </ul>
    pub storage_capacity: std::option::Option<i32>,
    /// <p>Sets the storage type for the file system you're creating.
    /// Valid values are <code>SSD</code> and <code>HDD</code>.</p>
    /// <ul>
    /// <li>
    /// <p>Set to <code>SSD</code> to use solid state drive storage.
    /// SSD is supported on all Windows, Lustre, and ONTAP deployment types.</p>
    /// </li>
    /// <li>
    /// <p>Set to <code>HDD</code> to use hard disk drive storage.
    /// HDD is supported on <code>SINGLE_AZ_2</code> and <code>MULTI_AZ_1</code> Windows file system deployment types,
    /// and on <code>PERSISTENT</code> Lustre file system deployment types.
    /// </p>
    /// </li>
    /// </ul>
    /// <p>
    /// Default value is <code>SSD</code>. For more information, see
    /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/optimize-fsx-costs.html#storage-type-options">
    /// Storage Type Options</a> in the <i>Amazon FSx for Windows User Guide</i> and
    /// <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/what-is.html#storage-options">Multiple Storage Options</a>
    /// in the <i>Amazon FSx for Lustre User Guide</i>.
    /// </p>
    pub storage_type: std::option::Option<crate::model::StorageType>,
    /// <p>Specifies the IDs of the subnets that the file system will be accessible from. For Windows
    /// and ONTAP <code>MULTI_AZ_1</code> file system deployment types, provide exactly two subnet IDs,
    /// one for the preferred file server and one for the standby file server. You specify one of these
    /// subnets as the preferred subnet using the <code>WindowsConfiguration > PreferredSubnetID</code>
    /// or <code>OntapConfiguration > PreferredSubnetID</code> properties. For more information,
    /// see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html">
    /// Availability and durability: Single-AZ and Multi-AZ file systems</a> in the
    /// <i>Amazon FSx for Windows User Guide</i> and
    /// <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/high-availability-multiAZ.html">
    /// Availability and durability</a> in the
    /// <i>Amazon FSx for ONTAP User Guide</i>.</p>
    /// <p>For Windows <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> file system deployment types and Lustre file systems, provide exactly one subnet ID.
    /// The file server is launched in that subnet's Availability Zone.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of IDs specifying the security groups to apply to all network interfaces
    /// created for file system access. This list isn't returned in later requests to
    /// describe the file system.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The tags to apply to the file system being created. The key value of
    /// the <code>Name</code> tag appears in the console as the file system name.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The ID of the Key Management Service (KMS) key used to encrypt the file system's data
    /// for Amazon FSx for Windows File Server file systems, Amazon FSx for NetApp ONTAP file systems, and
    /// Amazon FSx for Lustre <code>PERSISTENT_1</code> file systems at rest. If not specified, the Amazon FSx
    /// managed key is used. The Amazon FSx for Lustre <code>SCRATCH_1</code> and <code>SCRATCH_2</code> file systems
    /// are always encrypted at rest using Amazon FSx managed keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html">Encrypt</a>
    /// in the <i>Key Management Service API Reference</i>.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The Microsoft Windows configuration for the file system being created.
    /// </p>
    pub windows_configuration:
        std::option::Option<crate::model::CreateFileSystemWindowsConfiguration>,
    /// <p>The Lustre configuration for the file system being created.
    /// </p>
    pub lustre_configuration:
        std::option::Option<crate::model::CreateFileSystemLustreConfiguration>,
    /// <p>The ONTAP configuration properties of the FSx for NetApp ONTAP file system that you are creating.</p>
    pub ontap_configuration: std::option::Option<crate::model::CreateFileSystemOntapConfiguration>,
    /// <p>Sets the version of the Amazon FSx for Lustre file system you're creating.
    /// Valid values are <code>2.10</code> and <code>2.12</code>.</p>
    /// <ul>
    /// <li>
    /// <p>Set the value to <code>2.10</code> to create a Lustre 2.10
    /// file system.</p>
    /// </li>
    /// <li>
    /// <p>Set the value to <code>2.12</code> to create a Lustre 2.12
    /// file system.</p>
    /// </li>
    /// </ul>
    /// <p>Default value is <code>2.10</code>.</p>
    pub file_system_type_version: std::option::Option<std::string::String>,
}
impl CreateFileSystemInput {
    /// <p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure
    /// idempotent creation. This string is automatically filled on your behalf when you use the
    /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The type of Amazon FSx file system to create. Valid values are <code>WINDOWS</code>,
    /// <code>LUSTRE</code>, and <code>ONTAP</code>.</p>
    pub fn file_system_type(&self) -> std::option::Option<&crate::model::FileSystemType> {
        self.file_system_type.as_ref()
    }
    /// <p>Sets the storage capacity of the file system that you're creating.</p>      
    /// <p>For Lustre file systems:</p>
    /// <ul>
    /// <li>
    /// <p>For <code>SCRATCH_2</code> and <code>PERSISTENT_1 SSD</code> deployment types, valid values are
    /// 1200 GiB, 2400 GiB, and increments of 2400 GiB.</p>
    /// </li>
    /// <li>
    /// <p>For <code>PERSISTENT HDD</code> file systems, valid values are increments of 6000 GiB for
    /// 12 MB/s/TiB file systems and increments of 1800 GiB for 40 MB/s/TiB file systems.</p>
    /// </li>
    /// <li>
    /// <p>For <code>SCRATCH_1</code> deployment type, valid values are
    /// 1200 GiB, 2400 GiB, and increments of 3600 GiB.</p>
    /// </li>
    /// </ul>
    /// <p>For Windows file systems:</p>
    /// <ul>
    /// <li>
    /// <p>If <code>StorageType=SSD</code>, valid values are 32 GiB - 65,536 GiB (64 TiB).</p>
    /// </li>
    /// <li>
    /// <p>If <code>StorageType=HDD</code>, valid values are 2000 GiB - 65,536 GiB (64 TiB).</p>
    /// </li>
    /// </ul>
    /// <p>For ONTAP file systems:</p>
    /// <ul>
    /// <li>
    /// <p>Valid values are 1024 GiB - 196,608 GiB (192 TiB).</p>
    /// </li>
    /// </ul>
    pub fn storage_capacity(&self) -> std::option::Option<i32> {
        self.storage_capacity
    }
    /// <p>Sets the storage type for the file system you're creating.
    /// Valid values are <code>SSD</code> and <code>HDD</code>.</p>
    /// <ul>
    /// <li>
    /// <p>Set to <code>SSD</code> to use solid state drive storage.
    /// SSD is supported on all Windows, Lustre, and ONTAP deployment types.</p>
    /// </li>
    /// <li>
    /// <p>Set to <code>HDD</code> to use hard disk drive storage.
    /// HDD is supported on <code>SINGLE_AZ_2</code> and <code>MULTI_AZ_1</code> Windows file system deployment types,
    /// and on <code>PERSISTENT</code> Lustre file system deployment types.
    /// </p>
    /// </li>
    /// </ul>
    /// <p>
    /// Default value is <code>SSD</code>. For more information, see
    /// <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/optimize-fsx-costs.html#storage-type-options">
    /// Storage Type Options</a> in the <i>Amazon FSx for Windows User Guide</i> and
    /// <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/what-is.html#storage-options">Multiple Storage Options</a>
    /// in the <i>Amazon FSx for Lustre User Guide</i>.
    /// </p>
    pub fn storage_type(&self) -> std::option::Option<&crate::model::StorageType> {
        self.storage_type.as_ref()
    }
    /// <p>Specifies the IDs of the subnets that the file system will be accessible from. For Windows
    /// and ONTAP <code>MULTI_AZ_1</code> file system deployment types, provide exactly two subnet IDs,
    /// one for the preferred file server and one for the standby file server. You specify one of these
    /// subnets as the preferred subnet using the <code>WindowsConfiguration > PreferredSubnetID</code>
    /// or <code>OntapConfiguration > PreferredSubnetID</code> properties. For more information,
    /// see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html">
    /// Availability and durability: Single-AZ and Multi-AZ file systems</a> in the
    /// <i>Amazon FSx for Windows User Guide</i> and
    /// <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/high-availability-multiAZ.html">
    /// Availability and durability</a> in the
    /// <i>Amazon FSx for ONTAP User Guide</i>.</p>
    /// <p>For Windows <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> file system deployment types and Lustre file systems, provide exactly one subnet ID.
    /// The file server is launched in that subnet's Availability Zone.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>A list of IDs specifying the security groups to apply to all network interfaces
    /// created for file system access. This list isn't returned in later requests to
    /// describe the file system.</p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
    /// <p>The tags to apply to the file system being created. The key value of
    /// the <code>Name</code> tag appears in the console as the file system name.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The ID of the Key Management Service (KMS) key used to encrypt the file system's data
    /// for Amazon FSx for Windows File Server file systems, Amazon FSx for NetApp ONTAP file systems, and
    /// Amazon FSx for Lustre <code>PERSISTENT_1</code> file systems at rest. If not specified, the Amazon FSx
    /// managed key is used. The Amazon FSx for Lustre <code>SCRATCH_1</code> and <code>SCRATCH_2</code> file systems
    /// are always encrypted at rest using Amazon FSx managed keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html">Encrypt</a>
    /// in the <i>Key Management Service API Reference</i>.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The Microsoft Windows configuration for the file system being created.
    /// </p>
    pub fn windows_configuration(
        &self,
    ) -> std::option::Option<&crate::model::CreateFileSystemWindowsConfiguration> {
        self.windows_configuration.as_ref()
    }
    /// <p>The Lustre configuration for the file system being created.
    /// </p>
    pub fn lustre_configuration(
        &self,
    ) -> std::option::Option<&crate::model::CreateFileSystemLustreConfiguration> {
        self.lustre_configuration.as_ref()
    }
    /// <p>The ONTAP configuration properties of the FSx for NetApp ONTAP file system that you are creating.</p>
    pub fn ontap_configuration(
        &self,
    ) -> std::option::Option<&crate::model::CreateFileSystemOntapConfiguration> {
        self.ontap_configuration.as_ref()
    }
    /// <p>Sets the version of the Amazon FSx for Lustre file system you're creating.
    /// Valid values are <code>2.10</code> and <code>2.12</code>.</p>
    /// <ul>
    /// <li>
    /// <p>Set the value to <code>2.10</code> to create a Lustre 2.10
    /// file system.</p>
    /// </li>
    /// <li>
    /// <p>Set the value to <code>2.12</code> to create a Lustre 2.12
    /// file system.</p>
    /// </li>
    /// </ul>
    /// <p>Default value is <code>2.10</code>.</p>
    pub fn file_system_type_version(&self) -> std::option::Option<&str> {
        self.file_system_type_version.as_deref()
    }
}
impl std::fmt::Debug for CreateFileSystemInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFileSystemInput");
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("file_system_type", &self.file_system_type);
        formatter.field("storage_capacity", &self.storage_capacity);
        formatter.field("storage_type", &self.storage_type);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("tags", &self.tags);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("windows_configuration", &self.windows_configuration);
        formatter.field("lustre_configuration", &self.lustre_configuration);
        formatter.field("ontap_configuration", &self.ontap_configuration);
        formatter.field("file_system_type_version", &self.file_system_type_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDataRepositoryTaskInput {
    /// <p>Specifies the type of data repository task to create.</p>
    pub r#type: std::option::Option<crate::model::DataRepositoryTaskType>,
    /// <p>(Optional) The path or paths on the Amazon FSx file system to use when the data repository task is processed.
    /// The default path is the file system root directory. The paths you provide need to be relative to the mount point of the file system.
    /// If the mount point is <code>/mnt/fsx</code> and <code>/mnt/fsx/path1</code> is a directory or
    /// file on the file system you want to export, then the path to provide is <code>path1</code>.
    /// If a path that you provide isn't valid, the task fails.</p>
    pub paths: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The globally unique ID of the file system, assigned by Amazon FSx.</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>Defines whether or not Amazon FSx provides a CompletionReport once the task has completed.
    /// A CompletionReport provides a detailed  report on the files that Amazon FSx processed that meet the criteria specified by the
    /// <code>Scope</code> parameter. For more information, see
    /// <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/task-completion-report.html">Working with Task Completion Reports</a>.</p>
    pub report: std::option::Option<crate::model::CompletionReport>,
    /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
    /// ASCII characters. This token is automatically filled on your behalf when you use the
    /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateDataRepositoryTaskInput {
    /// <p>Specifies the type of data repository task to create.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::DataRepositoryTaskType> {
        self.r#type.as_ref()
    }
    /// <p>(Optional) The path or paths on the Amazon FSx file system to use when the data repository task is processed.
    /// The default path is the file system root directory. The paths you provide need to be relative to the mount point of the file system.
    /// If the mount point is <code>/mnt/fsx</code> and <code>/mnt/fsx/path1</code> is a directory or
    /// file on the file system you want to export, then the path to provide is <code>path1</code>.
    /// If a path that you provide isn't valid, the task fails.</p>
    pub fn paths(&self) -> std::option::Option<&[std::string::String]> {
        self.paths.as_deref()
    }
    /// <p>The globally unique ID of the file system, assigned by Amazon FSx.</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
    /// <p>Defines whether or not Amazon FSx provides a CompletionReport once the task has completed.
    /// A CompletionReport provides a detailed  report on the files that Amazon FSx processed that meet the criteria specified by the
    /// <code>Scope</code> parameter. For more information, see
    /// <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/task-completion-report.html">Working with Task Completion Reports</a>.</p>
    pub fn report(&self) -> std::option::Option<&crate::model::CompletionReport> {
        self.report.as_ref()
    }
    /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
    /// ASCII characters. This token is automatically filled on your behalf when you use the
    /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateDataRepositoryTaskInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDataRepositoryTaskInput");
        formatter.field("r#type", &self.r#type);
        formatter.field("paths", &self.paths);
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("report", &self.report);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>The request object for the <code>CreateBackup</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBackupInput {
    /// <p>The ID of the file system to back up.</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>(Optional) A string of up to 64 ASCII characters that Amazon FSx uses to ensure
    /// idempotent creation. This string is automatically filled on your behalf when you use the
    /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>(Optional) The tags to apply to the backup at backup creation. The key value of the
    /// <code>Name</code> tag appears in the console as the backup name. If you have set <code>CopyTagsToBackups</code> to true, and
    /// you specify one or more tags using the <code>CreateBackup</code> action, no existing file system tags are copied from the file system to the backup.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The ID of he FSx for NetApp ONTAP volume to back up.</p>
    pub volume_id: std::option::Option<std::string::String>,
}
impl CreateBackupInput {
    /// <p>The ID of the file system to back up.</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
    /// <p>(Optional) A string of up to 64 ASCII characters that Amazon FSx uses to ensure
    /// idempotent creation. This string is automatically filled on your behalf when you use the
    /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>(Optional) The tags to apply to the backup at backup creation. The key value of the
    /// <code>Name</code> tag appears in the console as the backup name. If you have set <code>CopyTagsToBackups</code> to true, and
    /// you specify one or more tags using the <code>CreateBackup</code> action, no existing file system tags are copied from the file system to the backup.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The ID of he FSx for NetApp ONTAP volume to back up.</p>
    pub fn volume_id(&self) -> std::option::Option<&str> {
        self.volume_id.as_deref()
    }
}
impl std::fmt::Debug for CreateBackupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBackupInput");
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("tags", &self.tags);
        formatter.field("volume_id", &self.volume_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CopyBackupInput {
    /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
    /// ASCII characters. This token is automatically filled on your behalf when you use the
    /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The ID of the source backup. Specifies the ID of the backup that is
    /// being copied.</p>
    pub source_backup_id: std::option::Option<std::string::String>,
    /// <p>The source Amazon Web Services Region of the backup. Specifies the Amazon Web Services Region from which
    /// the backup is being copied. The source and destination Regions must be in
    /// the same Amazon Web Services partition. If you don't specify a Region, it defaults to
    /// the Region where the request is sent from (in-Region copy).</p>
    pub source_region: std::option::Option<std::string::String>,
    /// <p>The ID of the Key Management Service (KMS) key used to encrypt the file system's data
    /// for Amazon FSx for Windows File Server file systems, Amazon FSx for NetApp ONTAP file systems, and
    /// Amazon FSx for Lustre <code>PERSISTENT_1</code> file systems at rest. If not specified, the Amazon FSx
    /// managed key is used. The Amazon FSx for Lustre <code>SCRATCH_1</code> and <code>SCRATCH_2</code> file systems
    /// are always encrypted at rest using Amazon FSx managed keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html">Encrypt</a>
    /// in the <i>Key Management Service API Reference</i>.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>A boolean flag indicating whether tags from the source backup
    /// should be copied to the backup copy. This value defaults to false.</p>
    /// <p>If you set <code>CopyTags</code> to true and the source backup has
    /// existing tags, you can use the <code>Tags</code> parameter to create new
    /// tags, provided that the sum of the source backup tags and the new tags
    /// doesn't exceed 50. Both sets of tags are merged. If there are tag
    /// conflicts (for example, two tags with the same key but different values),
    /// the tags created with the <code>Tags</code> parameter take precedence.</p>
    pub copy_tags: std::option::Option<bool>,
    /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CopyBackupInput {
    /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
    /// ASCII characters. This token is automatically filled on your behalf when you use the
    /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The ID of the source backup. Specifies the ID of the backup that is
    /// being copied.</p>
    pub fn source_backup_id(&self) -> std::option::Option<&str> {
        self.source_backup_id.as_deref()
    }
    /// <p>The source Amazon Web Services Region of the backup. Specifies the Amazon Web Services Region from which
    /// the backup is being copied. The source and destination Regions must be in
    /// the same Amazon Web Services partition. If you don't specify a Region, it defaults to
    /// the Region where the request is sent from (in-Region copy).</p>
    pub fn source_region(&self) -> std::option::Option<&str> {
        self.source_region.as_deref()
    }
    /// <p>The ID of the Key Management Service (KMS) key used to encrypt the file system's data
    /// for Amazon FSx for Windows File Server file systems, Amazon FSx for NetApp ONTAP file systems, and
    /// Amazon FSx for Lustre <code>PERSISTENT_1</code> file systems at rest. If not specified, the Amazon FSx
    /// managed key is used. The Amazon FSx for Lustre <code>SCRATCH_1</code> and <code>SCRATCH_2</code> file systems
    /// are always encrypted at rest using Amazon FSx managed keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html">Encrypt</a>
    /// in the <i>Key Management Service API Reference</i>.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>A boolean flag indicating whether tags from the source backup
    /// should be copied to the backup copy. This value defaults to false.</p>
    /// <p>If you set <code>CopyTags</code> to true and the source backup has
    /// existing tags, you can use the <code>Tags</code> parameter to create new
    /// tags, provided that the sum of the source backup tags and the new tags
    /// doesn't exceed 50. Both sets of tags are merged. If there are tag
    /// conflicts (for example, two tags with the same key but different values),
    /// the tags created with the <code>Tags</code> parameter take precedence.</p>
    pub fn copy_tags(&self) -> std::option::Option<bool> {
        self.copy_tags
    }
    /// <p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CopyBackupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CopyBackupInput");
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("source_backup_id", &self.source_backup_id);
        formatter.field("source_region", &self.source_region);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("copy_tags", &self.copy_tags);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>Cancels a data repository task.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelDataRepositoryTaskInput {
    /// <p>Specifies the data repository task to cancel.</p>
    pub task_id: std::option::Option<std::string::String>,
}
impl CancelDataRepositoryTaskInput {
    /// <p>Specifies the data repository task to cancel.</p>
    pub fn task_id(&self) -> std::option::Option<&str> {
        self.task_id.as_deref()
    }
}
impl std::fmt::Debug for CancelDataRepositoryTaskInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelDataRepositoryTaskInput");
        formatter.field("task_id", &self.task_id);
        formatter.finish()
    }
}

/// <p>The request object specifying one or more DNS alias names to associate with an Amazon FSx for Windows File Server file system.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateFileSystemAliasesInput {
    /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
    /// ASCII characters. This token is automatically filled on your behalf when you use the
    /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>Specifies the file system with which you want to associate one or more DNS aliases.</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>An array of one or more DNS alias names to associate with the file system.
    /// The alias name has to comply with the following formatting requirements:</p>
    /// <ul>
    /// <li>
    /// <p>Formatted as a fully-qualified domain name (FQDN), <i>
    /// <code>hostname.domain</code>
    /// </i>,
    /// for example, <code>accounting.corp.example.com</code>.</p>
    /// </li>
    /// <li>
    /// <p>Can contain alphanumeric characters and the hyphen (-).</p>
    /// </li>
    /// <li>
    /// <p>Cannot start or end with a hyphen.</p>
    /// </li>
    /// <li>
    /// <p>Can start with a numeric.</p>
    /// </li>
    /// </ul>
    /// <p>For DNS alias names, Amazon FSx stores alphabetic characters as lowercase letters (a-z), regardless of how you specify them:
    /// as uppercase letters, lowercase letters, or the corresponding letters in escape codes.</p>
    pub aliases: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl AssociateFileSystemAliasesInput {
    /// <p>(Optional) An idempotency token for resource creation, in a string of up to 64
    /// ASCII characters. This token is automatically filled on your behalf when you use the
    /// Command Line Interface (CLI) or an Amazon Web Services SDK.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>Specifies the file system with which you want to associate one or more DNS aliases.</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
    /// <p>An array of one or more DNS alias names to associate with the file system.
    /// The alias name has to comply with the following formatting requirements:</p>
    /// <ul>
    /// <li>
    /// <p>Formatted as a fully-qualified domain name (FQDN), <i>
    /// <code>hostname.domain</code>
    /// </i>,
    /// for example, <code>accounting.corp.example.com</code>.</p>
    /// </li>
    /// <li>
    /// <p>Can contain alphanumeric characters and the hyphen (-).</p>
    /// </li>
    /// <li>
    /// <p>Cannot start or end with a hyphen.</p>
    /// </li>
    /// <li>
    /// <p>Can start with a numeric.</p>
    /// </li>
    /// </ul>
    /// <p>For DNS alias names, Amazon FSx stores alphabetic characters as lowercase letters (a-z), regardless of how you specify them:
    /// as uppercase letters, lowercase letters, or the corresponding letters in escape codes.</p>
    pub fn aliases(&self) -> std::option::Option<&[std::string::String]> {
        self.aliases.as_deref()
    }
}
impl std::fmt::Debug for AssociateFileSystemAliasesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateFileSystemAliasesInput");
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("aliases", &self.aliases);
        formatter.finish()
    }
}
