// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>An Active Directory error.</p>
    ActiveDirectoryError(crate::error::ActiveDirectoryError),
    /// <p>You can't delete a backup while it's being copied.</p>
    BackupBeingCopied(crate::error::BackupBeingCopied),
    /// <p>Another backup is already under way. Wait for completion before initiating
    /// additional backups of this file system.</p>
    BackupInProgress(crate::error::BackupInProgress),
    /// <p>No Amazon FSx backups were found based upon the supplied parameters.</p>
    BackupNotFound(crate::error::BackupNotFound),
    /// <p>You can't delete a backup while it's being used to restore a file
    /// system.</p>
    BackupRestoring(crate::error::BackupRestoring),
    /// <p>A generic error indicating a failure with a client request.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>The data repository task could not be canceled because the task has already ended.</p>
    DataRepositoryTaskEnded(crate::error::DataRepositoryTaskEnded),
    /// <p>An existing data repository task is currently executing on the file system.  
    /// Wait until the existing task has completed, then create the new task.</p>
    DataRepositoryTaskExecuting(crate::error::DataRepositoryTaskExecuting),
    /// <p>The data repository task or tasks you specified could not be found.</p>
    DataRepositoryTaskNotFound(crate::error::DataRepositoryTaskNotFound),
    /// <p>No Amazon FSx file systems were found based upon supplied parameters.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>The error returned when a second request is received with the same client request
    /// token but different parameters settings. A client request token should always uniquely
    /// identify a single request.</p>
    IncompatibleParameterError(crate::error::IncompatibleParameterError),
    /// <p>Amazon FSx doesn't support Multi-AZ Windows File Server
    /// copy backup in the destination Region, so the copied backup
    /// can't be restored.</p>
    IncompatibleRegionForMultiAz(crate::error::IncompatibleRegionForMultiAz),
    /// <p>A generic error indicating a server-side failure.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The Key Management Service (KMS) key of the destination
    /// backup is invalid.</p>
    InvalidDestinationKmsKey(crate::error::InvalidDestinationKmsKey),
    /// <p>The path provided for data repository export isn't valid.</p>
    InvalidExportPath(crate::error::InvalidExportPath),
    /// <p>The path provided for data repository import isn't valid.</p>
    InvalidImportPath(crate::error::InvalidImportPath),
    /// <p>One or more network settings specified in the request are invalid.</p>
    InvalidNetworkSettings(crate::error::InvalidNetworkSettings),
    /// <p>An invalid value for <code>PerUnitStorageThroughput</code> was provided. Please create your file system again, using a valid value.</p>
    InvalidPerUnitStorageThroughput(crate::error::InvalidPerUnitStorageThroughput),
    /// <p>The Region provided for <code>Source Region</code> is invalid or
    /// is in a different Amazon Web Services partition.</p>
    InvalidRegion(crate::error::InvalidRegion),
    /// <p>The Key Management Service (KMS) key of the source backup
    /// is invalid.</p>
    InvalidSourceKmsKey(crate::error::InvalidSourceKmsKey),
    /// <p>A file system configuration is required for this operation.</p>
    MissingFileSystemConfiguration(crate::error::MissingFileSystemConfiguration),
    /// <p>A volume configuration is required for this operation.</p>
    MissingVolumeConfiguration(crate::error::MissingVolumeConfiguration),
    /// <p>The resource specified for the tagging operation is not a resource type owned by
    /// Amazon FSx. Use the API of the relevant service to perform the operation. </p>
    NotServiceResourceError(crate::error::NotServiceResourceError),
    /// <p>The resource specified does not support tagging. </p>
    ResourceDoesNotSupportTagging(crate::error::ResourceDoesNotSupportTagging),
    /// <p>The resource specified by the Amazon Resource Name (ARN) can't be found.</p>
    ResourceNotFound(crate::error::ResourceNotFound),
    /// <p>An error indicating that a particular service limit was exceeded. You can increase
    /// some service limits by contacting Amazon Web Services Support.</p>
    ServiceLimitExceeded(crate::error::ServiceLimitExceeded),
    /// <p>The request was rejected because the lifecycle status of the
    /// source backup is not <code>AVAILABLE</code>.</p>
    SourceBackupUnavailable(crate::error::SourceBackupUnavailable),
    /// <p>No Amazon FSx for NetApp ONTAP SVMs were found based upon the supplied parameters.</p>
    StorageVirtualMachineNotFound(crate::error::StorageVirtualMachineNotFound),
    /// <p>The requested operation is not supported for this resource or API.</p>
    UnsupportedOperation(crate::error::UnsupportedOperation),
    /// <p>No Amazon FSx for NetApp ONTAP volumes were found based upon the supplied parameters.</p>
    VolumeNotFound(crate::error::VolumeNotFound),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::ActiveDirectoryError(inner) => inner.fmt(f),
            Error::BackupBeingCopied(inner) => inner.fmt(f),
            Error::BackupInProgress(inner) => inner.fmt(f),
            Error::BackupNotFound(inner) => inner.fmt(f),
            Error::BackupRestoring(inner) => inner.fmt(f),
            Error::BadRequest(inner) => inner.fmt(f),
            Error::DataRepositoryTaskEnded(inner) => inner.fmt(f),
            Error::DataRepositoryTaskExecuting(inner) => inner.fmt(f),
            Error::DataRepositoryTaskNotFound(inner) => inner.fmt(f),
            Error::FileSystemNotFound(inner) => inner.fmt(f),
            Error::IncompatibleParameterError(inner) => inner.fmt(f),
            Error::IncompatibleRegionForMultiAz(inner) => inner.fmt(f),
            Error::InternalServerError(inner) => inner.fmt(f),
            Error::InvalidDestinationKmsKey(inner) => inner.fmt(f),
            Error::InvalidExportPath(inner) => inner.fmt(f),
            Error::InvalidImportPath(inner) => inner.fmt(f),
            Error::InvalidNetworkSettings(inner) => inner.fmt(f),
            Error::InvalidPerUnitStorageThroughput(inner) => inner.fmt(f),
            Error::InvalidRegion(inner) => inner.fmt(f),
            Error::InvalidSourceKmsKey(inner) => inner.fmt(f),
            Error::MissingFileSystemConfiguration(inner) => inner.fmt(f),
            Error::MissingVolumeConfiguration(inner) => inner.fmt(f),
            Error::NotServiceResourceError(inner) => inner.fmt(f),
            Error::ResourceDoesNotSupportTagging(inner) => inner.fmt(f),
            Error::ResourceNotFound(inner) => inner.fmt(f),
            Error::ServiceLimitExceeded(inner) => inner.fmt(f),
            Error::SourceBackupUnavailable(inner) => inner.fmt(f),
            Error::StorageVirtualMachineNotFound(inner) => inner.fmt(f),
            Error::UnsupportedOperation(inner) => inner.fmt(f),
            Error::VolumeNotFound(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AssociateFileSystemAliasesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AssociateFileSystemAliasesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AssociateFileSystemAliasesErrorKind::BadRequest(inner) => {
                    Error::BadRequest(inner)
                }
                crate::error::AssociateFileSystemAliasesErrorKind::FileSystemNotFound(inner) => {
                    Error::FileSystemNotFound(inner)
                }
                crate::error::AssociateFileSystemAliasesErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::AssociateFileSystemAliasesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CancelDataRepositoryTaskError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CancelDataRepositoryTaskError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CancelDataRepositoryTaskErrorKind::BadRequest(inner) => {
                    Error::BadRequest(inner)
                }
                crate::error::CancelDataRepositoryTaskErrorKind::DataRepositoryTaskEnded(inner) => {
                    Error::DataRepositoryTaskEnded(inner)
                }
                crate::error::CancelDataRepositoryTaskErrorKind::DataRepositoryTaskNotFound(
                    inner,
                ) => Error::DataRepositoryTaskNotFound(inner),
                crate::error::CancelDataRepositoryTaskErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CancelDataRepositoryTaskErrorKind::UnsupportedOperation(inner) => {
                    Error::UnsupportedOperation(inner)
                }
                crate::error::CancelDataRepositoryTaskErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CopyBackupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CopyBackupError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CopyBackupErrorKind::BackupNotFound(inner) => {
                    Error::BackupNotFound(inner)
                }
                crate::error::CopyBackupErrorKind::BadRequest(inner) => Error::BadRequest(inner),
                crate::error::CopyBackupErrorKind::IncompatibleParameterError(inner) => {
                    Error::IncompatibleParameterError(inner)
                }
                crate::error::CopyBackupErrorKind::IncompatibleRegionForMultiAz(inner) => {
                    Error::IncompatibleRegionForMultiAz(inner)
                }
                crate::error::CopyBackupErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CopyBackupErrorKind::InvalidDestinationKmsKey(inner) => {
                    Error::InvalidDestinationKmsKey(inner)
                }
                crate::error::CopyBackupErrorKind::InvalidRegion(inner) => {
                    Error::InvalidRegion(inner)
                }
                crate::error::CopyBackupErrorKind::InvalidSourceKmsKey(inner) => {
                    Error::InvalidSourceKmsKey(inner)
                }
                crate::error::CopyBackupErrorKind::ServiceLimitExceeded(inner) => {
                    Error::ServiceLimitExceeded(inner)
                }
                crate::error::CopyBackupErrorKind::SourceBackupUnavailable(inner) => {
                    Error::SourceBackupUnavailable(inner)
                }
                crate::error::CopyBackupErrorKind::UnsupportedOperation(inner) => {
                    Error::UnsupportedOperation(inner)
                }
                crate::error::CopyBackupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateBackupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateBackupError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateBackupErrorKind::BackupInProgress(inner) => {
                    Error::BackupInProgress(inner)
                }
                crate::error::CreateBackupErrorKind::BadRequest(inner) => Error::BadRequest(inner),
                crate::error::CreateBackupErrorKind::FileSystemNotFound(inner) => {
                    Error::FileSystemNotFound(inner)
                }
                crate::error::CreateBackupErrorKind::IncompatibleParameterError(inner) => {
                    Error::IncompatibleParameterError(inner)
                }
                crate::error::CreateBackupErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CreateBackupErrorKind::ServiceLimitExceeded(inner) => {
                    Error::ServiceLimitExceeded(inner)
                }
                crate::error::CreateBackupErrorKind::UnsupportedOperation(inner) => {
                    Error::UnsupportedOperation(inner)
                }
                crate::error::CreateBackupErrorKind::VolumeNotFound(inner) => {
                    Error::VolumeNotFound(inner)
                }
                crate::error::CreateBackupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDataRepositoryTaskError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDataRepositoryTaskError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateDataRepositoryTaskErrorKind::BadRequest(inner) => {
                    Error::BadRequest(inner)
                }
                crate::error::CreateDataRepositoryTaskErrorKind::DataRepositoryTaskExecuting(
                    inner,
                ) => Error::DataRepositoryTaskExecuting(inner),
                crate::error::CreateDataRepositoryTaskErrorKind::FileSystemNotFound(inner) => {
                    Error::FileSystemNotFound(inner)
                }
                crate::error::CreateDataRepositoryTaskErrorKind::IncompatibleParameterError(
                    inner,
                ) => Error::IncompatibleParameterError(inner),
                crate::error::CreateDataRepositoryTaskErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CreateDataRepositoryTaskErrorKind::ServiceLimitExceeded(inner) => {
                    Error::ServiceLimitExceeded(inner)
                }
                crate::error::CreateDataRepositoryTaskErrorKind::UnsupportedOperation(inner) => {
                    Error::UnsupportedOperation(inner)
                }
                crate::error::CreateDataRepositoryTaskErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateFileSystemError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateFileSystemError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateFileSystemErrorKind::ActiveDirectoryError(inner) => {
                    Error::ActiveDirectoryError(inner)
                }
                crate::error::CreateFileSystemErrorKind::BadRequest(inner) => {
                    Error::BadRequest(inner)
                }
                crate::error::CreateFileSystemErrorKind::IncompatibleParameterError(inner) => {
                    Error::IncompatibleParameterError(inner)
                }
                crate::error::CreateFileSystemErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CreateFileSystemErrorKind::InvalidExportPath(inner) => {
                    Error::InvalidExportPath(inner)
                }
                crate::error::CreateFileSystemErrorKind::InvalidImportPath(inner) => {
                    Error::InvalidImportPath(inner)
                }
                crate::error::CreateFileSystemErrorKind::InvalidNetworkSettings(inner) => {
                    Error::InvalidNetworkSettings(inner)
                }
                crate::error::CreateFileSystemErrorKind::InvalidPerUnitStorageThroughput(inner) => {
                    Error::InvalidPerUnitStorageThroughput(inner)
                }
                crate::error::CreateFileSystemErrorKind::MissingFileSystemConfiguration(inner) => {
                    Error::MissingFileSystemConfiguration(inner)
                }
                crate::error::CreateFileSystemErrorKind::ServiceLimitExceeded(inner) => {
                    Error::ServiceLimitExceeded(inner)
                }
                crate::error::CreateFileSystemErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateFileSystemFromBackupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateFileSystemFromBackupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateFileSystemFromBackupErrorKind::ActiveDirectoryError(inner) => Error::ActiveDirectoryError(inner),
                crate::error::CreateFileSystemFromBackupErrorKind::BackupNotFound(inner) => Error::BackupNotFound(inner),
                crate::error::CreateFileSystemFromBackupErrorKind::BadRequest(inner) => Error::BadRequest(inner),
                crate::error::CreateFileSystemFromBackupErrorKind::IncompatibleParameterError(inner) => Error::IncompatibleParameterError(inner),
                crate::error::CreateFileSystemFromBackupErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::CreateFileSystemFromBackupErrorKind::InvalidNetworkSettings(inner) => Error::InvalidNetworkSettings(inner),
                crate::error::CreateFileSystemFromBackupErrorKind::InvalidPerUnitStorageThroughput(inner) => Error::InvalidPerUnitStorageThroughput(inner),
                crate::error::CreateFileSystemFromBackupErrorKind::MissingFileSystemConfiguration(inner) => Error::MissingFileSystemConfiguration(inner),
                crate::error::CreateFileSystemFromBackupErrorKind::ServiceLimitExceeded(inner) => Error::ServiceLimitExceeded(inner),
                crate::error::CreateFileSystemFromBackupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateStorageVirtualMachineError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateStorageVirtualMachineError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateStorageVirtualMachineErrorKind::ActiveDirectoryError(inner) => {
                    Error::ActiveDirectoryError(inner)
                }
                crate::error::CreateStorageVirtualMachineErrorKind::BadRequest(inner) => {
                    Error::BadRequest(inner)
                }
                crate::error::CreateStorageVirtualMachineErrorKind::FileSystemNotFound(inner) => {
                    Error::FileSystemNotFound(inner)
                }
                crate::error::CreateStorageVirtualMachineErrorKind::IncompatibleParameterError(
                    inner,
                ) => Error::IncompatibleParameterError(inner),
                crate::error::CreateStorageVirtualMachineErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CreateStorageVirtualMachineErrorKind::ServiceLimitExceeded(inner) => {
                    Error::ServiceLimitExceeded(inner)
                }
                crate::error::CreateStorageVirtualMachineErrorKind::UnsupportedOperation(inner) => {
                    Error::UnsupportedOperation(inner)
                }
                crate::error::CreateStorageVirtualMachineErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateVolumeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateVolumeError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateVolumeErrorKind::BadRequest(inner) => Error::BadRequest(inner),
                crate::error::CreateVolumeErrorKind::FileSystemNotFound(inner) => {
                    Error::FileSystemNotFound(inner)
                }
                crate::error::CreateVolumeErrorKind::IncompatibleParameterError(inner) => {
                    Error::IncompatibleParameterError(inner)
                }
                crate::error::CreateVolumeErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CreateVolumeErrorKind::MissingVolumeConfiguration(inner) => {
                    Error::MissingVolumeConfiguration(inner)
                }
                crate::error::CreateVolumeErrorKind::ServiceLimitExceeded(inner) => {
                    Error::ServiceLimitExceeded(inner)
                }
                crate::error::CreateVolumeErrorKind::StorageVirtualMachineNotFound(inner) => {
                    Error::StorageVirtualMachineNotFound(inner)
                }
                crate::error::CreateVolumeErrorKind::UnsupportedOperation(inner) => {
                    Error::UnsupportedOperation(inner)
                }
                crate::error::CreateVolumeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateVolumeFromBackupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateVolumeFromBackupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateVolumeFromBackupErrorKind::BackupNotFound(inner) => {
                    Error::BackupNotFound(inner)
                }
                crate::error::CreateVolumeFromBackupErrorKind::BadRequest(inner) => {
                    Error::BadRequest(inner)
                }
                crate::error::CreateVolumeFromBackupErrorKind::FileSystemNotFound(inner) => {
                    Error::FileSystemNotFound(inner)
                }
                crate::error::CreateVolumeFromBackupErrorKind::IncompatibleParameterError(
                    inner,
                ) => Error::IncompatibleParameterError(inner),
                crate::error::CreateVolumeFromBackupErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CreateVolumeFromBackupErrorKind::MissingVolumeConfiguration(
                    inner,
                ) => Error::MissingVolumeConfiguration(inner),
                crate::error::CreateVolumeFromBackupErrorKind::ServiceLimitExceeded(inner) => {
                    Error::ServiceLimitExceeded(inner)
                }
                crate::error::CreateVolumeFromBackupErrorKind::StorageVirtualMachineNotFound(
                    inner,
                ) => Error::StorageVirtualMachineNotFound(inner),
                crate::error::CreateVolumeFromBackupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteBackupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteBackupError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteBackupErrorKind::BackupBeingCopied(inner) => {
                    Error::BackupBeingCopied(inner)
                }
                crate::error::DeleteBackupErrorKind::BackupInProgress(inner) => {
                    Error::BackupInProgress(inner)
                }
                crate::error::DeleteBackupErrorKind::BackupNotFound(inner) => {
                    Error::BackupNotFound(inner)
                }
                crate::error::DeleteBackupErrorKind::BackupRestoring(inner) => {
                    Error::BackupRestoring(inner)
                }
                crate::error::DeleteBackupErrorKind::BadRequest(inner) => Error::BadRequest(inner),
                crate::error::DeleteBackupErrorKind::IncompatibleParameterError(inner) => {
                    Error::IncompatibleParameterError(inner)
                }
                crate::error::DeleteBackupErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DeleteBackupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteFileSystemError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteFileSystemError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteFileSystemErrorKind::BadRequest(inner) => {
                    Error::BadRequest(inner)
                }
                crate::error::DeleteFileSystemErrorKind::FileSystemNotFound(inner) => {
                    Error::FileSystemNotFound(inner)
                }
                crate::error::DeleteFileSystemErrorKind::IncompatibleParameterError(inner) => {
                    Error::IncompatibleParameterError(inner)
                }
                crate::error::DeleteFileSystemErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DeleteFileSystemErrorKind::ServiceLimitExceeded(inner) => {
                    Error::ServiceLimitExceeded(inner)
                }
                crate::error::DeleteFileSystemErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteStorageVirtualMachineError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteStorageVirtualMachineError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteStorageVirtualMachineErrorKind::BadRequest(inner) => Error::BadRequest(inner),
                crate::error::DeleteStorageVirtualMachineErrorKind::IncompatibleParameterError(inner) => Error::IncompatibleParameterError(inner),
                crate::error::DeleteStorageVirtualMachineErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DeleteStorageVirtualMachineErrorKind::StorageVirtualMachineNotFound(inner) => Error::StorageVirtualMachineNotFound(inner),
                crate::error::DeleteStorageVirtualMachineErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteVolumeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteVolumeError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteVolumeErrorKind::BadRequest(inner) => Error::BadRequest(inner),
                crate::error::DeleteVolumeErrorKind::IncompatibleParameterError(inner) => {
                    Error::IncompatibleParameterError(inner)
                }
                crate::error::DeleteVolumeErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DeleteVolumeErrorKind::VolumeNotFound(inner) => {
                    Error::VolumeNotFound(inner)
                }
                crate::error::DeleteVolumeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeBackupsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeBackupsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeBackupsErrorKind::BackupNotFound(inner) => {
                    Error::BackupNotFound(inner)
                }
                crate::error::DescribeBackupsErrorKind::BadRequest(inner) => {
                    Error::BadRequest(inner)
                }
                crate::error::DescribeBackupsErrorKind::FileSystemNotFound(inner) => {
                    Error::FileSystemNotFound(inner)
                }
                crate::error::DescribeBackupsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeBackupsErrorKind::VolumeNotFound(inner) => {
                    Error::VolumeNotFound(inner)
                }
                crate::error::DescribeBackupsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDataRepositoryTasksError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDataRepositoryTasksError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDataRepositoryTasksErrorKind::BadRequest(inner) => {
                    Error::BadRequest(inner)
                }
                crate::error::DescribeDataRepositoryTasksErrorKind::DataRepositoryTaskNotFound(
                    inner,
                ) => Error::DataRepositoryTaskNotFound(inner),
                crate::error::DescribeDataRepositoryTasksErrorKind::FileSystemNotFound(inner) => {
                    Error::FileSystemNotFound(inner)
                }
                crate::error::DescribeDataRepositoryTasksErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeDataRepositoryTasksErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeFileSystemAliasesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeFileSystemAliasesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeFileSystemAliasesErrorKind::BadRequest(inner) => {
                    Error::BadRequest(inner)
                }
                crate::error::DescribeFileSystemAliasesErrorKind::FileSystemNotFound(inner) => {
                    Error::FileSystemNotFound(inner)
                }
                crate::error::DescribeFileSystemAliasesErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeFileSystemAliasesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeFileSystemsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeFileSystemsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeFileSystemsErrorKind::BadRequest(inner) => {
                    Error::BadRequest(inner)
                }
                crate::error::DescribeFileSystemsErrorKind::FileSystemNotFound(inner) => {
                    Error::FileSystemNotFound(inner)
                }
                crate::error::DescribeFileSystemsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeFileSystemsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeStorageVirtualMachinesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeStorageVirtualMachinesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeStorageVirtualMachinesErrorKind::BadRequest(inner) => Error::BadRequest(inner),
                crate::error::DescribeStorageVirtualMachinesErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DescribeStorageVirtualMachinesErrorKind::StorageVirtualMachineNotFound(inner) => Error::StorageVirtualMachineNotFound(inner),
                crate::error::DescribeStorageVirtualMachinesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeVolumesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeVolumesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeVolumesErrorKind::BadRequest(inner) => {
                    Error::BadRequest(inner)
                }
                crate::error::DescribeVolumesErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeVolumesErrorKind::VolumeNotFound(inner) => {
                    Error::VolumeNotFound(inner)
                }
                crate::error::DescribeVolumesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DisassociateFileSystemAliasesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DisassociateFileSystemAliasesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DisassociateFileSystemAliasesErrorKind::BadRequest(inner) => {
                    Error::BadRequest(inner)
                }
                crate::error::DisassociateFileSystemAliasesErrorKind::FileSystemNotFound(inner) => {
                    Error::FileSystemNotFound(inner)
                }
                crate::error::DisassociateFileSystemAliasesErrorKind::InternalServerError(
                    inner,
                ) => Error::InternalServerError(inner),
                crate::error::DisassociateFileSystemAliasesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTagsForResourceErrorKind::BadRequest(inner) => {
                    Error::BadRequest(inner)
                }
                crate::error::ListTagsForResourceErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ListTagsForResourceErrorKind::NotServiceResourceError(inner) => {
                    Error::NotServiceResourceError(inner)
                }
                crate::error::ListTagsForResourceErrorKind::ResourceDoesNotSupportTagging(
                    inner,
                ) => Error::ResourceDoesNotSupportTagging(inner),
                crate::error::ListTagsForResourceErrorKind::ResourceNotFound(inner) => {
                    Error::ResourceNotFound(inner)
                }
                crate::error::ListTagsForResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TagResourceErrorKind::BadRequest(inner) => Error::BadRequest(inner),
                crate::error::TagResourceErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::TagResourceErrorKind::NotServiceResourceError(inner) => {
                    Error::NotServiceResourceError(inner)
                }
                crate::error::TagResourceErrorKind::ResourceDoesNotSupportTagging(inner) => {
                    Error::ResourceDoesNotSupportTagging(inner)
                }
                crate::error::TagResourceErrorKind::ResourceNotFound(inner) => {
                    Error::ResourceNotFound(inner)
                }
                crate::error::TagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UntagResourceErrorKind::BadRequest(inner) => Error::BadRequest(inner),
                crate::error::UntagResourceErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::UntagResourceErrorKind::NotServiceResourceError(inner) => {
                    Error::NotServiceResourceError(inner)
                }
                crate::error::UntagResourceErrorKind::ResourceDoesNotSupportTagging(inner) => {
                    Error::ResourceDoesNotSupportTagging(inner)
                }
                crate::error::UntagResourceErrorKind::ResourceNotFound(inner) => {
                    Error::ResourceNotFound(inner)
                }
                crate::error::UntagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateFileSystemError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateFileSystemError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateFileSystemErrorKind::BadRequest(inner) => {
                    Error::BadRequest(inner)
                }
                crate::error::UpdateFileSystemErrorKind::FileSystemNotFound(inner) => {
                    Error::FileSystemNotFound(inner)
                }
                crate::error::UpdateFileSystemErrorKind::IncompatibleParameterError(inner) => {
                    Error::IncompatibleParameterError(inner)
                }
                crate::error::UpdateFileSystemErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::UpdateFileSystemErrorKind::MissingFileSystemConfiguration(inner) => {
                    Error::MissingFileSystemConfiguration(inner)
                }
                crate::error::UpdateFileSystemErrorKind::ServiceLimitExceeded(inner) => {
                    Error::ServiceLimitExceeded(inner)
                }
                crate::error::UpdateFileSystemErrorKind::UnsupportedOperation(inner) => {
                    Error::UnsupportedOperation(inner)
                }
                crate::error::UpdateFileSystemErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateStorageVirtualMachineError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateStorageVirtualMachineError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateStorageVirtualMachineErrorKind::BadRequest(inner) => Error::BadRequest(inner),
                crate::error::UpdateStorageVirtualMachineErrorKind::IncompatibleParameterError(inner) => Error::IncompatibleParameterError(inner),
                crate::error::UpdateStorageVirtualMachineErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::UpdateStorageVirtualMachineErrorKind::StorageVirtualMachineNotFound(inner) => Error::StorageVirtualMachineNotFound(inner),
                crate::error::UpdateStorageVirtualMachineErrorKind::UnsupportedOperation(inner) => Error::UnsupportedOperation(inner),
                crate::error::UpdateStorageVirtualMachineErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateVolumeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateVolumeError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateVolumeErrorKind::BadRequest(inner) => Error::BadRequest(inner),
                crate::error::UpdateVolumeErrorKind::IncompatibleParameterError(inner) => {
                    Error::IncompatibleParameterError(inner)
                }
                crate::error::UpdateVolumeErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::UpdateVolumeErrorKind::MissingVolumeConfiguration(inner) => {
                    Error::MissingVolumeConfiguration(inner)
                }
                crate::error::UpdateVolumeErrorKind::VolumeNotFound(inner) => {
                    Error::VolumeNotFound(inner)
                }
                crate::error::UpdateVolumeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
