// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_file_system_aliases_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateFileSystemAliasesOutput,
    crate::error::AssociateFileSystemAliasesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssociateFileSystemAliasesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AssociateFileSystemAliasesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequest" => crate::error::AssociateFileSystemAliasesError {
            meta: generic,
            kind: crate::error::AssociateFileSystemAliasesErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::AssociateFileSystemAliasesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FileSystemNotFound" => crate::error::AssociateFileSystemAliasesError {
            meta: generic,
            kind: crate::error::AssociateFileSystemAliasesErrorKind::FileSystemNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateFileSystemAliasesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::AssociateFileSystemAliasesError {
            meta: generic,
            kind: crate::error::AssociateFileSystemAliasesErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateFileSystemAliasesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AssociateFileSystemAliasesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_file_system_aliases_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateFileSystemAliasesOutput,
    crate::error::AssociateFileSystemAliasesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::associate_file_system_aliases_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_associate_file_system_aliases(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AssociateFileSystemAliasesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_data_repository_task_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CancelDataRepositoryTaskOutput,
    crate::error::CancelDataRepositoryTaskError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CancelDataRepositoryTaskError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CancelDataRepositoryTaskError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequest" => crate::error::CancelDataRepositoryTaskError {
            meta: generic,
            kind: crate::error::CancelDataRepositoryTaskErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CancelDataRepositoryTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DataRepositoryTaskEnded" => crate::error::CancelDataRepositoryTaskError {
            meta: generic,
            kind: crate::error::CancelDataRepositoryTaskErrorKind::DataRepositoryTaskEnded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::data_repository_task_ended::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_data_repository_task_ended_json_err(response.body().as_ref(), output).map_err(crate::error::CancelDataRepositoryTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DataRepositoryTaskNotFound" => crate::error::CancelDataRepositoryTaskError {
            meta: generic,
            kind: crate::error::CancelDataRepositoryTaskErrorKind::DataRepositoryTaskNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::data_repository_task_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_data_repository_task_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::CancelDataRepositoryTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::CancelDataRepositoryTaskError {
            meta: generic,
            kind: crate::error::CancelDataRepositoryTaskErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::CancelDataRepositoryTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperation" => crate::error::CancelDataRepositoryTaskError {
            meta: generic,
            kind: crate::error::CancelDataRepositoryTaskErrorKind::UnsupportedOperation({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unsupported_operation::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_json_err(response.body().as_ref(), output).map_err(crate::error::CancelDataRepositoryTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CancelDataRepositoryTaskError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_data_repository_task_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CancelDataRepositoryTaskOutput,
    crate::error::CancelDataRepositoryTaskError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::cancel_data_repository_task_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_cancel_data_repository_task(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CancelDataRepositoryTaskError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_copy_backup_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CopyBackupOutput, crate::error::CopyBackupError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CopyBackupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CopyBackupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BackupNotFound" => {
            crate::error::CopyBackupError {
                meta: generic,
                kind: crate::error::CopyBackupErrorKind::BackupNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::backup_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_backup_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::CopyBackupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "BadRequest" => crate::error::CopyBackupError {
            meta: generic,
            kind: crate::error::CopyBackupErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CopyBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IncompatibleParameterError" => crate::error::CopyBackupError {
            meta: generic,
            kind: crate::error::CopyBackupErrorKind::IncompatibleParameterError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::incompatible_parameter_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_incompatible_parameter_error_json_err(response.body().as_ref(), output).map_err(crate::error::CopyBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IncompatibleRegionForMultiAZ" => crate::error::CopyBackupError {
            meta: generic,
            kind: crate::error::CopyBackupErrorKind::IncompatibleRegionForMultiAz({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::incompatible_region_for_multi_az::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_incompatible_region_for_multi_az_json_err(response.body().as_ref(), output).map_err(crate::error::CopyBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::CopyBackupError {
            meta: generic,
            kind: crate::error::CopyBackupErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::CopyBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDestinationKmsKey" => crate::error::CopyBackupError {
            meta: generic,
            kind: crate::error::CopyBackupErrorKind::InvalidDestinationKmsKey({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_destination_kms_key::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_destination_kms_key_json_err(response.body().as_ref(), output).map_err(crate::error::CopyBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRegion" => crate::error::CopyBackupError {
            meta: generic,
            kind: crate::error::CopyBackupErrorKind::InvalidRegion({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_region::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_invalid_region_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::CopyBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSourceKmsKey" => crate::error::CopyBackupError {
            meta: generic,
            kind: crate::error::CopyBackupErrorKind::InvalidSourceKmsKey({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_source_kms_key::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_source_kms_key_json_err(response.body().as_ref(), output).map_err(crate::error::CopyBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceLimitExceeded" => crate::error::CopyBackupError {
            meta: generic,
            kind: crate::error::CopyBackupErrorKind::ServiceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CopyBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SourceBackupUnavailable" => crate::error::CopyBackupError {
            meta: generic,
            kind: crate::error::CopyBackupErrorKind::SourceBackupUnavailable({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::source_backup_unavailable::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_source_backup_unavailable_json_err(response.body().as_ref(), output).map_err(crate::error::CopyBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperation" => crate::error::CopyBackupError {
            meta: generic,
            kind: crate::error::CopyBackupErrorKind::UnsupportedOperation({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unsupported_operation::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_json_err(response.body().as_ref(), output).map_err(crate::error::CopyBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CopyBackupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_copy_backup_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CopyBackupOutput, crate::error::CopyBackupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::copy_backup_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_copy_backup(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CopyBackupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_backup_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateBackupOutput, crate::error::CreateBackupError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateBackupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateBackupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BackupInProgress" => {
            crate::error::CreateBackupError {
                meta: generic,
                kind: crate::error::CreateBackupErrorKind::BackupInProgress({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::backup_in_progress::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_backup_in_progress_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBackupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "BadRequest" => crate::error::CreateBackupError {
            meta: generic,
            kind: crate::error::CreateBackupErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FileSystemNotFound" => crate::error::CreateBackupError {
            meta: generic,
            kind: crate::error::CreateBackupErrorKind::FileSystemNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IncompatibleParameterError" => crate::error::CreateBackupError {
            meta: generic,
            kind: crate::error::CreateBackupErrorKind::IncompatibleParameterError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::incompatible_parameter_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_incompatible_parameter_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::CreateBackupError {
            meta: generic,
            kind: crate::error::CreateBackupErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceLimitExceeded" => crate::error::CreateBackupError {
            meta: generic,
            kind: crate::error::CreateBackupErrorKind::ServiceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperation" => crate::error::CreateBackupError {
            meta: generic,
            kind: crate::error::CreateBackupErrorKind::UnsupportedOperation({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unsupported_operation::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "VolumeNotFound" => {
            crate::error::CreateBackupError {
                meta: generic,
                kind: crate::error::CreateBackupErrorKind::VolumeNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::volume_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_volume_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBackupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::CreateBackupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_backup_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateBackupOutput, crate::error::CreateBackupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_backup_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_backup(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateBackupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_data_repository_task_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDataRepositoryTaskOutput,
    crate::error::CreateDataRepositoryTaskError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateDataRepositoryTaskError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateDataRepositoryTaskError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequest" => crate::error::CreateDataRepositoryTaskError {
            meta: generic,
            kind: crate::error::CreateDataRepositoryTaskErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateDataRepositoryTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DataRepositoryTaskExecuting" => crate::error::CreateDataRepositoryTaskError {
            meta: generic,
            kind: crate::error::CreateDataRepositoryTaskErrorKind::DataRepositoryTaskExecuting({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::data_repository_task_executing::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_data_repository_task_executing_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDataRepositoryTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FileSystemNotFound" => crate::error::CreateDataRepositoryTaskError {
            meta: generic,
            kind: crate::error::CreateDataRepositoryTaskErrorKind::FileSystemNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDataRepositoryTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IncompatibleParameterError" => crate::error::CreateDataRepositoryTaskError {
            meta: generic,
            kind: crate::error::CreateDataRepositoryTaskErrorKind::IncompatibleParameterError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::incompatible_parameter_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_incompatible_parameter_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDataRepositoryTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::CreateDataRepositoryTaskError {
            meta: generic,
            kind: crate::error::CreateDataRepositoryTaskErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDataRepositoryTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceLimitExceeded" => crate::error::CreateDataRepositoryTaskError {
            meta: generic,
            kind: crate::error::CreateDataRepositoryTaskErrorKind::ServiceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDataRepositoryTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperation" => crate::error::CreateDataRepositoryTaskError {
            meta: generic,
            kind: crate::error::CreateDataRepositoryTaskErrorKind::UnsupportedOperation({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unsupported_operation::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDataRepositoryTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateDataRepositoryTaskError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_data_repository_task_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDataRepositoryTaskOutput,
    crate::error::CreateDataRepositoryTaskError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_data_repository_task_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_data_repository_task(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateDataRepositoryTaskError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_file_system_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateFileSystemOutput, crate::error::CreateFileSystemError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateFileSystemError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateFileSystemError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ActiveDirectoryError" => crate::error::CreateFileSystemError {
            meta: generic,
            kind: crate::error::CreateFileSystemErrorKind::ActiveDirectoryError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::active_directory_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_active_directory_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BadRequest" => crate::error::CreateFileSystemError {
            meta: generic,
            kind: crate::error::CreateFileSystemErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IncompatibleParameterError" => crate::error::CreateFileSystemError {
            meta: generic,
            kind: crate::error::CreateFileSystemErrorKind::IncompatibleParameterError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::incompatible_parameter_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_incompatible_parameter_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::CreateFileSystemError {
            meta: generic,
            kind: crate::error::CreateFileSystemErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidExportPath" => crate::error::CreateFileSystemError {
            meta: generic,
            kind: crate::error::CreateFileSystemErrorKind::InvalidExportPath({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_export_path::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_export_path_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidImportPath" => crate::error::CreateFileSystemError {
            meta: generic,
            kind: crate::error::CreateFileSystemErrorKind::InvalidImportPath({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_import_path::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_import_path_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNetworkSettings" => crate::error::CreateFileSystemError {
            meta: generic,
            kind: crate::error::CreateFileSystemErrorKind::InvalidNetworkSettings({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_network_settings::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_network_settings_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidPerUnitStorageThroughput" => crate::error::CreateFileSystemError {
            meta: generic,
            kind: crate::error::CreateFileSystemErrorKind::InvalidPerUnitStorageThroughput({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_per_unit_storage_throughput::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_per_unit_storage_throughput_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingFileSystemConfiguration" => crate::error::CreateFileSystemError {
            meta: generic,
            kind: crate::error::CreateFileSystemErrorKind::MissingFileSystemConfiguration({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_file_system_configuration::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_file_system_configuration_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceLimitExceeded" => crate::error::CreateFileSystemError {
            meta: generic,
            kind: crate::error::CreateFileSystemErrorKind::ServiceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateFileSystemError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_file_system_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateFileSystemOutput, crate::error::CreateFileSystemError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_file_system_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_file_system(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateFileSystemError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_file_system_from_backup_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateFileSystemFromBackupOutput,
    crate::error::CreateFileSystemFromBackupError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateFileSystemFromBackupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateFileSystemFromBackupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ActiveDirectoryError" => crate::error::CreateFileSystemFromBackupError {
            meta: generic,
            kind: crate::error::CreateFileSystemFromBackupErrorKind::ActiveDirectoryError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::active_directory_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_active_directory_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFileSystemFromBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BackupNotFound" => {
            crate::error::CreateFileSystemFromBackupError {
                meta: generic,
                kind: crate::error::CreateFileSystemFromBackupErrorKind::BackupNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::backup_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_backup_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFileSystemFromBackupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "BadRequest" => crate::error::CreateFileSystemFromBackupError {
            meta: generic,
            kind: crate::error::CreateFileSystemFromBackupErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateFileSystemFromBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IncompatibleParameterError" => crate::error::CreateFileSystemFromBackupError {
            meta: generic,
            kind: crate::error::CreateFileSystemFromBackupErrorKind::IncompatibleParameterError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::incompatible_parameter_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_incompatible_parameter_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFileSystemFromBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::CreateFileSystemFromBackupError {
            meta: generic,
            kind: crate::error::CreateFileSystemFromBackupErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFileSystemFromBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNetworkSettings" => crate::error::CreateFileSystemFromBackupError {
            meta: generic,
            kind: crate::error::CreateFileSystemFromBackupErrorKind::InvalidNetworkSettings({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_network_settings::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_network_settings_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFileSystemFromBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidPerUnitStorageThroughput" => crate::error::CreateFileSystemFromBackupError {
            meta: generic,
            kind:
                crate::error::CreateFileSystemFromBackupErrorKind::InvalidPerUnitStorageThroughput(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_per_unit_storage_throughput::Builder::default(
                                );
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_per_unit_storage_throughput_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFileSystemFromBackupError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "MissingFileSystemConfiguration" => crate::error::CreateFileSystemFromBackupError {
            meta: generic,
            kind: crate::error::CreateFileSystemFromBackupErrorKind::MissingFileSystemConfiguration(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::missing_file_system_configuration::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_missing_file_system_configuration_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFileSystemFromBackupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ServiceLimitExceeded" => crate::error::CreateFileSystemFromBackupError {
            meta: generic,
            kind: crate::error::CreateFileSystemFromBackupErrorKind::ServiceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFileSystemFromBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateFileSystemFromBackupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_file_system_from_backup_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateFileSystemFromBackupOutput,
    crate::error::CreateFileSystemFromBackupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_file_system_from_backup_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_file_system_from_backup(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateFileSystemFromBackupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_storage_virtual_machine_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateStorageVirtualMachineOutput,
    crate::error::CreateStorageVirtualMachineError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateStorageVirtualMachineError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateStorageVirtualMachineError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ActiveDirectoryError" => crate::error::CreateStorageVirtualMachineError {
            meta: generic,
            kind: crate::error::CreateStorageVirtualMachineErrorKind::ActiveDirectoryError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::active_directory_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_active_directory_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateStorageVirtualMachineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BadRequest" => crate::error::CreateStorageVirtualMachineError {
            meta: generic,
            kind: crate::error::CreateStorageVirtualMachineErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateStorageVirtualMachineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FileSystemNotFound" => crate::error::CreateStorageVirtualMachineError {
            meta: generic,
            kind: crate::error::CreateStorageVirtualMachineErrorKind::FileSystemNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::CreateStorageVirtualMachineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IncompatibleParameterError" => crate::error::CreateStorageVirtualMachineError {
            meta: generic,
            kind: crate::error::CreateStorageVirtualMachineErrorKind::IncompatibleParameterError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::incompatible_parameter_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_incompatible_parameter_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateStorageVirtualMachineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::CreateStorageVirtualMachineError {
            meta: generic,
            kind: crate::error::CreateStorageVirtualMachineErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateStorageVirtualMachineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceLimitExceeded" => crate::error::CreateStorageVirtualMachineError {
            meta: generic,
            kind: crate::error::CreateStorageVirtualMachineErrorKind::ServiceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateStorageVirtualMachineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperation" => crate::error::CreateStorageVirtualMachineError {
            meta: generic,
            kind: crate::error::CreateStorageVirtualMachineErrorKind::UnsupportedOperation({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unsupported_operation::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_json_err(response.body().as_ref(), output).map_err(crate::error::CreateStorageVirtualMachineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateStorageVirtualMachineError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_storage_virtual_machine_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateStorageVirtualMachineOutput,
    crate::error::CreateStorageVirtualMachineError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_storage_virtual_machine_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_storage_virtual_machine(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateStorageVirtualMachineError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_volume_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateVolumeOutput, crate::error::CreateVolumeError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateVolumeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateVolumeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequest" => crate::error::CreateVolumeError {
            meta: generic,
            kind: crate::error::CreateVolumeErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateVolumeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FileSystemNotFound" => crate::error::CreateVolumeError {
            meta: generic,
            kind: crate::error::CreateVolumeErrorKind::FileSystemNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::CreateVolumeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IncompatibleParameterError" => crate::error::CreateVolumeError {
            meta: generic,
            kind: crate::error::CreateVolumeErrorKind::IncompatibleParameterError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::incompatible_parameter_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_incompatible_parameter_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateVolumeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::CreateVolumeError {
            meta: generic,
            kind: crate::error::CreateVolumeErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateVolumeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingVolumeConfiguration" => crate::error::CreateVolumeError {
            meta: generic,
            kind: crate::error::CreateVolumeErrorKind::MissingVolumeConfiguration({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::missing_volume_configuration::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_volume_configuration_json_err(response.body().as_ref(), output).map_err(crate::error::CreateVolumeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceLimitExceeded" => crate::error::CreateVolumeError {
            meta: generic,
            kind: crate::error::CreateVolumeErrorKind::ServiceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateVolumeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StorageVirtualMachineNotFound" => crate::error::CreateVolumeError {
            meta: generic,
            kind: crate::error::CreateVolumeErrorKind::StorageVirtualMachineNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::storage_virtual_machine_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_storage_virtual_machine_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::CreateVolumeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperation" => crate::error::CreateVolumeError {
            meta: generic,
            kind: crate::error::CreateVolumeErrorKind::UnsupportedOperation({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unsupported_operation::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_json_err(response.body().as_ref(), output).map_err(crate::error::CreateVolumeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateVolumeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_volume_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateVolumeOutput, crate::error::CreateVolumeError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_volume_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_volume(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateVolumeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_volume_from_backup_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateVolumeFromBackupOutput,
    crate::error::CreateVolumeFromBackupError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateVolumeFromBackupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateVolumeFromBackupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BackupNotFound" => {
            crate::error::CreateVolumeFromBackupError {
                meta: generic,
                kind: crate::error::CreateVolumeFromBackupErrorKind::BackupNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::backup_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_backup_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::CreateVolumeFromBackupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "BadRequest" => crate::error::CreateVolumeFromBackupError {
            meta: generic,
            kind: crate::error::CreateVolumeFromBackupErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateVolumeFromBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FileSystemNotFound" => crate::error::CreateVolumeFromBackupError {
            meta: generic,
            kind: crate::error::CreateVolumeFromBackupErrorKind::FileSystemNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::CreateVolumeFromBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IncompatibleParameterError" => crate::error::CreateVolumeFromBackupError {
            meta: generic,
            kind: crate::error::CreateVolumeFromBackupErrorKind::IncompatibleParameterError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::incompatible_parameter_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_incompatible_parameter_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateVolumeFromBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::CreateVolumeFromBackupError {
            meta: generic,
            kind: crate::error::CreateVolumeFromBackupErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateVolumeFromBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingVolumeConfiguration" => crate::error::CreateVolumeFromBackupError {
            meta: generic,
            kind: crate::error::CreateVolumeFromBackupErrorKind::MissingVolumeConfiguration({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::missing_volume_configuration::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_volume_configuration_json_err(response.body().as_ref(), output).map_err(crate::error::CreateVolumeFromBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceLimitExceeded" => crate::error::CreateVolumeFromBackupError {
            meta: generic,
            kind: crate::error::CreateVolumeFromBackupErrorKind::ServiceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateVolumeFromBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StorageVirtualMachineNotFound" => crate::error::CreateVolumeFromBackupError {
            meta: generic,
            kind: crate::error::CreateVolumeFromBackupErrorKind::StorageVirtualMachineNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::storage_virtual_machine_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_storage_virtual_machine_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::CreateVolumeFromBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateVolumeFromBackupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_volume_from_backup_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateVolumeFromBackupOutput,
    crate::error::CreateVolumeFromBackupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_volume_from_backup_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_volume_from_backup(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateVolumeFromBackupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_backup_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteBackupOutput, crate::error::DeleteBackupError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteBackupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteBackupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BackupBeingCopied" => crate::error::DeleteBackupError {
            meta: generic,
            kind: crate::error::DeleteBackupErrorKind::BackupBeingCopied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::backup_being_copied::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_backup_being_copied_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BackupInProgress" => {
            crate::error::DeleteBackupError {
                meta: generic,
                kind: crate::error::DeleteBackupErrorKind::BackupInProgress({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::backup_in_progress::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_backup_in_progress_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBackupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "BackupNotFound" => {
            crate::error::DeleteBackupError {
                meta: generic,
                kind: crate::error::DeleteBackupErrorKind::BackupNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::backup_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_backup_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBackupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "BackupRestoring" => {
            crate::error::DeleteBackupError {
                meta: generic,
                kind: crate::error::DeleteBackupErrorKind::BackupRestoring({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::backup_restoring::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_backup_restoring_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBackupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "BadRequest" => crate::error::DeleteBackupError {
            meta: generic,
            kind: crate::error::DeleteBackupErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IncompatibleParameterError" => crate::error::DeleteBackupError {
            meta: generic,
            kind: crate::error::DeleteBackupErrorKind::IncompatibleParameterError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::incompatible_parameter_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_incompatible_parameter_error_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::DeleteBackupError {
            meta: generic,
            kind: crate::error::DeleteBackupErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteBackupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_backup_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteBackupOutput, crate::error::DeleteBackupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_backup_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_backup(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteBackupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_file_system_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteFileSystemOutput, crate::error::DeleteFileSystemError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteFileSystemError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteFileSystemError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequest" => crate::error::DeleteFileSystemError {
            meta: generic,
            kind: crate::error::DeleteFileSystemErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FileSystemNotFound" => crate::error::DeleteFileSystemError {
            meta: generic,
            kind: crate::error::DeleteFileSystemErrorKind::FileSystemNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IncompatibleParameterError" => crate::error::DeleteFileSystemError {
            meta: generic,
            kind: crate::error::DeleteFileSystemErrorKind::IncompatibleParameterError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::incompatible_parameter_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_incompatible_parameter_error_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::DeleteFileSystemError {
            meta: generic,
            kind: crate::error::DeleteFileSystemErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceLimitExceeded" => crate::error::DeleteFileSystemError {
            meta: generic,
            kind: crate::error::DeleteFileSystemErrorKind::ServiceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteFileSystemError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_file_system_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteFileSystemOutput, crate::error::DeleteFileSystemError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_file_system_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_file_system(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteFileSystemError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_storage_virtual_machine_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteStorageVirtualMachineOutput,
    crate::error::DeleteStorageVirtualMachineError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteStorageVirtualMachineError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteStorageVirtualMachineError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequest" => crate::error::DeleteStorageVirtualMachineError {
            meta: generic,
            kind: crate::error::DeleteStorageVirtualMachineErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteStorageVirtualMachineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IncompatibleParameterError" => crate::error::DeleteStorageVirtualMachineError {
            meta: generic,
            kind: crate::error::DeleteStorageVirtualMachineErrorKind::IncompatibleParameterError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::incompatible_parameter_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_incompatible_parameter_error_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteStorageVirtualMachineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::DeleteStorageVirtualMachineError {
            meta: generic,
            kind: crate::error::DeleteStorageVirtualMachineErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteStorageVirtualMachineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StorageVirtualMachineNotFound" => crate::error::DeleteStorageVirtualMachineError {
            meta: generic,
            kind: crate::error::DeleteStorageVirtualMachineErrorKind::StorageVirtualMachineNotFound(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::storage_virtual_machine_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_storage_virtual_machine_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteStorageVirtualMachineError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DeleteStorageVirtualMachineError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_storage_virtual_machine_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteStorageVirtualMachineOutput,
    crate::error::DeleteStorageVirtualMachineError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_storage_virtual_machine_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_storage_virtual_machine(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteStorageVirtualMachineError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_volume_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteVolumeOutput, crate::error::DeleteVolumeError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteVolumeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteVolumeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequest" => crate::error::DeleteVolumeError {
            meta: generic,
            kind: crate::error::DeleteVolumeErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteVolumeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IncompatibleParameterError" => crate::error::DeleteVolumeError {
            meta: generic,
            kind: crate::error::DeleteVolumeErrorKind::IncompatibleParameterError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::incompatible_parameter_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_incompatible_parameter_error_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteVolumeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::DeleteVolumeError {
            meta: generic,
            kind: crate::error::DeleteVolumeErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteVolumeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "VolumeNotFound" => {
            crate::error::DeleteVolumeError {
                meta: generic,
                kind: crate::error::DeleteVolumeErrorKind::VolumeNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::volume_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_volume_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteVolumeError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteVolumeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_volume_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteVolumeOutput, crate::error::DeleteVolumeError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_volume_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_volume(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteVolumeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_backups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeBackupsOutput, crate::error::DescribeBackupsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeBackupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeBackupsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BackupNotFound" => {
            crate::error::DescribeBackupsError {
                meta: generic,
                kind: crate::error::DescribeBackupsErrorKind::BackupNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::backup_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_backup_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBackupsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "BadRequest" => crate::error::DescribeBackupsError {
            meta: generic,
            kind: crate::error::DescribeBackupsErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DescribeBackupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FileSystemNotFound" => crate::error::DescribeBackupsError {
            meta: generic,
            kind: crate::error::DescribeBackupsErrorKind::FileSystemNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBackupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::DescribeBackupsError {
            meta: generic,
            kind: crate::error::DescribeBackupsErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBackupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "VolumeNotFound" => {
            crate::error::DescribeBackupsError {
                meta: generic,
                kind: crate::error::DescribeBackupsErrorKind::VolumeNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::volume_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_volume_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBackupsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeBackupsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_backups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeBackupsOutput, crate::error::DescribeBackupsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_backups_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_backups(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeBackupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_data_repository_tasks_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDataRepositoryTasksOutput,
    crate::error::DescribeDataRepositoryTasksError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDataRepositoryTasksError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeDataRepositoryTasksError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequest" => crate::error::DescribeDataRepositoryTasksError {
            meta: generic,
            kind: crate::error::DescribeDataRepositoryTasksErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DescribeDataRepositoryTasksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DataRepositoryTaskNotFound" => crate::error::DescribeDataRepositoryTasksError {
            meta: generic,
            kind: crate::error::DescribeDataRepositoryTasksErrorKind::DataRepositoryTaskNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::data_repository_task_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_data_repository_task_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDataRepositoryTasksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FileSystemNotFound" => crate::error::DescribeDataRepositoryTasksError {
            meta: generic,
            kind: crate::error::DescribeDataRepositoryTasksErrorKind::FileSystemNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDataRepositoryTasksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::DescribeDataRepositoryTasksError {
            meta: generic,
            kind: crate::error::DescribeDataRepositoryTasksErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDataRepositoryTasksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeDataRepositoryTasksError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_data_repository_tasks_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDataRepositoryTasksOutput,
    crate::error::DescribeDataRepositoryTasksError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_data_repository_tasks_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_data_repository_tasks(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeDataRepositoryTasksError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_file_system_aliases_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeFileSystemAliasesOutput,
    crate::error::DescribeFileSystemAliasesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeFileSystemAliasesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeFileSystemAliasesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequest" => crate::error::DescribeFileSystemAliasesError {
            meta: generic,
            kind: crate::error::DescribeFileSystemAliasesErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DescribeFileSystemAliasesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FileSystemNotFound" => crate::error::DescribeFileSystemAliasesError {
            meta: generic,
            kind: crate::error::DescribeFileSystemAliasesErrorKind::FileSystemNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeFileSystemAliasesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::DescribeFileSystemAliasesError {
            meta: generic,
            kind: crate::error::DescribeFileSystemAliasesErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeFileSystemAliasesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeFileSystemAliasesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_file_system_aliases_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeFileSystemAliasesOutput,
    crate::error::DescribeFileSystemAliasesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_file_system_aliases_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_file_system_aliases(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeFileSystemAliasesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_file_systems_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeFileSystemsOutput,
    crate::error::DescribeFileSystemsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeFileSystemsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeFileSystemsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequest" => crate::error::DescribeFileSystemsError {
            meta: generic,
            kind: crate::error::DescribeFileSystemsErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DescribeFileSystemsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FileSystemNotFound" => crate::error::DescribeFileSystemsError {
            meta: generic,
            kind: crate::error::DescribeFileSystemsErrorKind::FileSystemNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeFileSystemsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::DescribeFileSystemsError {
            meta: generic,
            kind: crate::error::DescribeFileSystemsErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeFileSystemsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeFileSystemsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_file_systems_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeFileSystemsOutput,
    crate::error::DescribeFileSystemsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_file_systems_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_file_systems(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeFileSystemsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_storage_virtual_machines_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeStorageVirtualMachinesOutput,
    crate::error::DescribeStorageVirtualMachinesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeStorageVirtualMachinesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeStorageVirtualMachinesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequest" => crate::error::DescribeStorageVirtualMachinesError {
            meta: generic,
            kind: crate::error::DescribeStorageVirtualMachinesErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DescribeStorageVirtualMachinesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::DescribeStorageVirtualMachinesError {
            meta: generic,
            kind: crate::error::DescribeStorageVirtualMachinesErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeStorageVirtualMachinesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StorageVirtualMachineNotFound" => crate::error::DescribeStorageVirtualMachinesError {
            meta: generic,
            kind:
                crate::error::DescribeStorageVirtualMachinesErrorKind::StorageVirtualMachineNotFound(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::storage_virtual_machine_not_found::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_storage_virtual_machine_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeStorageVirtualMachinesError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::DescribeStorageVirtualMachinesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_storage_virtual_machines_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeStorageVirtualMachinesOutput,
    crate::error::DescribeStorageVirtualMachinesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_storage_virtual_machines_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_describe_storage_virtual_machines(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeStorageVirtualMachinesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_volumes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeVolumesOutput, crate::error::DescribeVolumesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeVolumesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeVolumesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequest" => crate::error::DescribeVolumesError {
            meta: generic,
            kind: crate::error::DescribeVolumesErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DescribeVolumesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::DescribeVolumesError {
            meta: generic,
            kind: crate::error::DescribeVolumesErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeVolumesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "VolumeNotFound" => {
            crate::error::DescribeVolumesError {
                meta: generic,
                kind: crate::error::DescribeVolumesErrorKind::VolumeNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::volume_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_volume_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeVolumesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeVolumesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_volumes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeVolumesOutput, crate::error::DescribeVolumesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_volumes_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_volumes(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeVolumesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_file_system_aliases_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateFileSystemAliasesOutput,
    crate::error::DisassociateFileSystemAliasesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisassociateFileSystemAliasesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DisassociateFileSystemAliasesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequest" => crate::error::DisassociateFileSystemAliasesError {
            meta: generic,
            kind: crate::error::DisassociateFileSystemAliasesErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DisassociateFileSystemAliasesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FileSystemNotFound" => crate::error::DisassociateFileSystemAliasesError {
            meta: generic,
            kind: crate::error::DisassociateFileSystemAliasesErrorKind::FileSystemNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateFileSystemAliasesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::DisassociateFileSystemAliasesError {
            meta: generic,
            kind: crate::error::DisassociateFileSystemAliasesErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateFileSystemAliasesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DisassociateFileSystemAliasesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_file_system_aliases_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateFileSystemAliasesOutput,
    crate::error::DisassociateFileSystemAliasesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disassociate_file_system_aliases_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_disassociate_file_system_aliases(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DisassociateFileSystemAliasesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsForResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequest" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotServiceResourceError" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::NotServiceResourceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_service_resource_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_service_resource_error_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceDoesNotSupportTagging" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::ResourceDoesNotSupportTagging({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_does_not_support_tagging::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_does_not_support_tagging_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => {
            crate::error::ListTagsForResourceError {
                meta: generic,
                kind: crate::error::ListTagsForResourceErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListTagsForResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_for_resource_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tags_for_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequest" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotServiceResourceError" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::NotServiceResourceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_service_resource_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_service_resource_error_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceDoesNotSupportTagging" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::ResourceDoesNotSupportTagging({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_does_not_support_tagging::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_does_not_support_tagging_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => {
            crate::error::TagResourceError {
                meta: generic,
                kind: crate::error::TagResourceErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::TagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequest" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotServiceResourceError" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::NotServiceResourceError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_service_resource_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_service_resource_error_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceDoesNotSupportTagging" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::ResourceDoesNotSupportTagging({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_does_not_support_tagging::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_does_not_support_tagging_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => {
            crate::error::UntagResourceError {
                meta: generic,
                kind: crate::error::UntagResourceErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UntagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_file_system_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateFileSystemOutput, crate::error::UpdateFileSystemError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateFileSystemError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateFileSystemError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequest" => crate::error::UpdateFileSystemError {
            meta: generic,
            kind: crate::error::UpdateFileSystemErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UpdateFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FileSystemNotFound" => crate::error::UpdateFileSystemError {
            meta: generic,
            kind: crate::error::UpdateFileSystemErrorKind::FileSystemNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IncompatibleParameterError" => crate::error::UpdateFileSystemError {
            meta: generic,
            kind: crate::error::UpdateFileSystemErrorKind::IncompatibleParameterError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::incompatible_parameter_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_incompatible_parameter_error_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::UpdateFileSystemError {
            meta: generic,
            kind: crate::error::UpdateFileSystemErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingFileSystemConfiguration" => crate::error::UpdateFileSystemError {
            meta: generic,
            kind: crate::error::UpdateFileSystemErrorKind::MissingFileSystemConfiguration({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_file_system_configuration::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_file_system_configuration_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceLimitExceeded" => crate::error::UpdateFileSystemError {
            meta: generic,
            kind: crate::error::UpdateFileSystemErrorKind::ServiceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperation" => crate::error::UpdateFileSystemError {
            meta: generic,
            kind: crate::error::UpdateFileSystemErrorKind::UnsupportedOperation({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unsupported_operation::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateFileSystemError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_file_system_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateFileSystemOutput, crate::error::UpdateFileSystemError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_file_system_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_file_system(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateFileSystemError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_storage_virtual_machine_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateStorageVirtualMachineOutput,
    crate::error::UpdateStorageVirtualMachineError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateStorageVirtualMachineError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateStorageVirtualMachineError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequest" => crate::error::UpdateStorageVirtualMachineError {
            meta: generic,
            kind: crate::error::UpdateStorageVirtualMachineErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UpdateStorageVirtualMachineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IncompatibleParameterError" => crate::error::UpdateStorageVirtualMachineError {
            meta: generic,
            kind: crate::error::UpdateStorageVirtualMachineErrorKind::IncompatibleParameterError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::incompatible_parameter_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_incompatible_parameter_error_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateStorageVirtualMachineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::UpdateStorageVirtualMachineError {
            meta: generic,
            kind: crate::error::UpdateStorageVirtualMachineErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateStorageVirtualMachineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StorageVirtualMachineNotFound" => crate::error::UpdateStorageVirtualMachineError {
            meta: generic,
            kind: crate::error::UpdateStorageVirtualMachineErrorKind::StorageVirtualMachineNotFound(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::storage_virtual_machine_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_storage_virtual_machine_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateStorageVirtualMachineError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "UnsupportedOperation" => crate::error::UpdateStorageVirtualMachineError {
            meta: generic,
            kind: crate::error::UpdateStorageVirtualMachineErrorKind::UnsupportedOperation({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unsupported_operation::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateStorageVirtualMachineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateStorageVirtualMachineError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_storage_virtual_machine_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateStorageVirtualMachineOutput,
    crate::error::UpdateStorageVirtualMachineError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_storage_virtual_machine_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_storage_virtual_machine(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateStorageVirtualMachineError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_volume_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateVolumeOutput, crate::error::UpdateVolumeError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateVolumeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateVolumeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequest" => crate::error::UpdateVolumeError {
            meta: generic,
            kind: crate::error::UpdateVolumeErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UpdateVolumeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IncompatibleParameterError" => crate::error::UpdateVolumeError {
            meta: generic,
            kind: crate::error::UpdateVolumeErrorKind::IncompatibleParameterError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::incompatible_parameter_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_incompatible_parameter_error_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateVolumeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::UpdateVolumeError {
            meta: generic,
            kind: crate::error::UpdateVolumeErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateVolumeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingVolumeConfiguration" => crate::error::UpdateVolumeError {
            meta: generic,
            kind: crate::error::UpdateVolumeErrorKind::MissingVolumeConfiguration({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::missing_volume_configuration::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_volume_configuration_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateVolumeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "VolumeNotFound" => {
            crate::error::UpdateVolumeError {
                meta: generic,
                kind: crate::error::UpdateVolumeErrorKind::VolumeNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::volume_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_volume_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateVolumeError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdateVolumeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_volume_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateVolumeOutput, crate::error::UpdateVolumeError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_volume_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_volume(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateVolumeError::unhandled)?;
        output.build()
    })
}
