// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>A rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Rule {
    /// <p>The detector for which the rule is associated.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The rule ID.</p>
    pub rule_id: std::option::Option<std::string::String>,
    /// <p>The rule version.</p>
    pub rule_version: std::option::Option<std::string::String>,
}
impl Rule {
    /// <p>The detector for which the rule is associated.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>The rule ID.</p>
    pub fn rule_id(&self) -> std::option::Option<&str> {
        self.rule_id.as_deref()
    }
    /// <p>The rule version.</p>
    pub fn rule_version(&self) -> std::option::Option<&str> {
        self.rule_version.as_deref()
    }
}
impl std::fmt::Debug for Rule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Rule");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("rule_id", &self.rule_id);
        formatter.field("rule_version", &self.rule_version);
        formatter.finish()
    }
}
/// See [`Rule`](crate::model::Rule)
pub mod rule {
    /// A builder for [`Rule`](crate::model::Rule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) rule_id: std::option::Option<std::string::String>,
        pub(crate) rule_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The detector for which the rule is associated.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The detector for which the rule is associated.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The rule ID.</p>
        pub fn rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_id = Some(input.into());
            self
        }
        /// <p>The rule ID.</p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_id = input;
            self
        }
        /// <p>The rule version.</p>
        pub fn rule_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_version = Some(input.into());
            self
        }
        /// <p>The rule version.</p>
        pub fn set_rule_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_version = input;
            self
        }
        /// Consumes the builder and constructs a [`Rule`](crate::model::Rule)
        pub fn build(self) -> crate::model::Rule {
            crate::model::Rule {
                detector_id: self.detector_id,
                rule_id: self.rule_id,
                rule_version: self.rule_version,
            }
        }
    }
}
impl Rule {
    /// Creates a new builder-style object to manufacture [`Rule`](crate::model::Rule)
    pub fn builder() -> crate::model::rule::Builder {
        crate::model::rule::Builder::default()
    }
}

/// <p>A key and value pair. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>A tag key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>A value assigned to a tag key.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>A tag key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>A value assigned to a tag key.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A tag key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>A tag key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>A value assigned to a tag key.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>A value assigned to a tag key.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Language {
    #[allow(missing_docs)] // documentation missing in model
    Detectorpl,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Language {
    fn from(s: &str) -> Self {
        match s {
            "DETECTORPL" => Language::Detectorpl,
            other => Language::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Language {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Language::from(s))
    }
}
impl Language {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Language::Detectorpl => "DETECTORPL",
            Language::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DETECTORPL"]
    }
}
impl AsRef<str> for Language {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ModelVersionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    #[allow(missing_docs)] // documentation missing in model
    TrainingCancelled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ModelVersionStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ModelVersionStatus::Active,
            "INACTIVE" => ModelVersionStatus::Inactive,
            "TRAINING_CANCELLED" => ModelVersionStatus::TrainingCancelled,
            other => ModelVersionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ModelVersionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ModelVersionStatus::from(s))
    }
}
impl ModelVersionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ModelVersionStatus::Active => "ACTIVE",
            ModelVersionStatus::Inactive => "INACTIVE",
            ModelVersionStatus::TrainingCancelled => "TRAINING_CANCELLED",
            ModelVersionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "INACTIVE", "TRAINING_CANCELLED"]
    }
}
impl AsRef<str> for ModelVersionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ModelTypeEnum {
    #[allow(missing_docs)] // documentation missing in model
    OnlineFraudInsights,
    #[allow(missing_docs)] // documentation missing in model
    TransactionFraudInsights,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ModelTypeEnum {
    fn from(s: &str) -> Self {
        match s {
            "ONLINE_FRAUD_INSIGHTS" => ModelTypeEnum::OnlineFraudInsights,
            "TRANSACTION_FRAUD_INSIGHTS" => ModelTypeEnum::TransactionFraudInsights,
            other => ModelTypeEnum::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ModelTypeEnum {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ModelTypeEnum::from(s))
    }
}
impl ModelTypeEnum {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ModelTypeEnum::OnlineFraudInsights => "ONLINE_FRAUD_INSIGHTS",
            ModelTypeEnum::TransactionFraudInsights => "TRANSACTION_FRAUD_INSIGHTS",
            ModelTypeEnum::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ONLINE_FRAUD_INSIGHTS", "TRANSACTION_FRAUD_INSIGHTS"]
    }
}
impl AsRef<str> for ModelTypeEnum {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The details of the ingested event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IngestedEventsDetail {
    /// <p>The start and stop time of the ingested events.</p>
    pub ingested_events_time_window: std::option::Option<crate::model::IngestedEventsTimeWindow>,
}
impl IngestedEventsDetail {
    /// <p>The start and stop time of the ingested events.</p>
    pub fn ingested_events_time_window(
        &self,
    ) -> std::option::Option<&crate::model::IngestedEventsTimeWindow> {
        self.ingested_events_time_window.as_ref()
    }
}
impl std::fmt::Debug for IngestedEventsDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IngestedEventsDetail");
        formatter.field(
            "ingested_events_time_window",
            &self.ingested_events_time_window,
        );
        formatter.finish()
    }
}
/// See [`IngestedEventsDetail`](crate::model::IngestedEventsDetail)
pub mod ingested_events_detail {
    /// A builder for [`IngestedEventsDetail`](crate::model::IngestedEventsDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ingested_events_time_window:
            std::option::Option<crate::model::IngestedEventsTimeWindow>,
    }
    impl Builder {
        /// <p>The start and stop time of the ingested events.</p>
        pub fn ingested_events_time_window(
            mut self,
            input: crate::model::IngestedEventsTimeWindow,
        ) -> Self {
            self.ingested_events_time_window = Some(input);
            self
        }
        /// <p>The start and stop time of the ingested events.</p>
        pub fn set_ingested_events_time_window(
            mut self,
            input: std::option::Option<crate::model::IngestedEventsTimeWindow>,
        ) -> Self {
            self.ingested_events_time_window = input;
            self
        }
        /// Consumes the builder and constructs a [`IngestedEventsDetail`](crate::model::IngestedEventsDetail)
        pub fn build(self) -> crate::model::IngestedEventsDetail {
            crate::model::IngestedEventsDetail {
                ingested_events_time_window: self.ingested_events_time_window,
            }
        }
    }
}
impl IngestedEventsDetail {
    /// Creates a new builder-style object to manufacture [`IngestedEventsDetail`](crate::model::IngestedEventsDetail)
    pub fn builder() -> crate::model::ingested_events_detail::Builder {
        crate::model::ingested_events_detail::Builder::default()
    }
}

/// <p>The start and stop time of the ingested events.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IngestedEventsTimeWindow {
    /// <p>Timestamp of the first ingensted event.</p>
    pub start_time: std::option::Option<std::string::String>,
    /// <p>Timestamp of the final ingested event.</p>
    pub end_time: std::option::Option<std::string::String>,
}
impl IngestedEventsTimeWindow {
    /// <p>Timestamp of the first ingensted event.</p>
    pub fn start_time(&self) -> std::option::Option<&str> {
        self.start_time.as_deref()
    }
    /// <p>Timestamp of the final ingested event.</p>
    pub fn end_time(&self) -> std::option::Option<&str> {
        self.end_time.as_deref()
    }
}
impl std::fmt::Debug for IngestedEventsTimeWindow {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IngestedEventsTimeWindow");
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.finish()
    }
}
/// See [`IngestedEventsTimeWindow`](crate::model::IngestedEventsTimeWindow)
pub mod ingested_events_time_window {
    /// A builder for [`IngestedEventsTimeWindow`](crate::model::IngestedEventsTimeWindow)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<std::string::String>,
        pub(crate) end_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Timestamp of the first ingensted event.</p>
        pub fn start_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_time = Some(input.into());
            self
        }
        /// <p>Timestamp of the first ingensted event.</p>
        pub fn set_start_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start_time = input;
            self
        }
        /// <p>Timestamp of the final ingested event.</p>
        pub fn end_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.end_time = Some(input.into());
            self
        }
        /// <p>Timestamp of the final ingested event.</p>
        pub fn set_end_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`IngestedEventsTimeWindow`](crate::model::IngestedEventsTimeWindow)
        pub fn build(self) -> crate::model::IngestedEventsTimeWindow {
            crate::model::IngestedEventsTimeWindow {
                start_time: self.start_time,
                end_time: self.end_time,
            }
        }
    }
}
impl IngestedEventsTimeWindow {
    /// Creates a new builder-style object to manufacture [`IngestedEventsTimeWindow`](crate::model::IngestedEventsTimeWindow)
    pub fn builder() -> crate::model::ingested_events_time_window::Builder {
        crate::model::ingested_events_time_window::Builder::default()
    }
}

/// <p>Details for the external events data used for model version training.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExternalEventsDetail {
    /// <p>The Amazon S3 bucket location for the data.</p>
    pub data_location: std::option::Option<std::string::String>,
    /// <p>The ARN of the role that provides Amazon Fraud Detector access to the data location.</p>
    pub data_access_role_arn: std::option::Option<std::string::String>,
}
impl ExternalEventsDetail {
    /// <p>The Amazon S3 bucket location for the data.</p>
    pub fn data_location(&self) -> std::option::Option<&str> {
        self.data_location.as_deref()
    }
    /// <p>The ARN of the role that provides Amazon Fraud Detector access to the data location.</p>
    pub fn data_access_role_arn(&self) -> std::option::Option<&str> {
        self.data_access_role_arn.as_deref()
    }
}
impl std::fmt::Debug for ExternalEventsDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExternalEventsDetail");
        formatter.field("data_location", &self.data_location);
        formatter.field("data_access_role_arn", &self.data_access_role_arn);
        formatter.finish()
    }
}
/// See [`ExternalEventsDetail`](crate::model::ExternalEventsDetail)
pub mod external_events_detail {
    /// A builder for [`ExternalEventsDetail`](crate::model::ExternalEventsDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_location: std::option::Option<std::string::String>,
        pub(crate) data_access_role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon S3 bucket location for the data.</p>
        pub fn data_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_location = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket location for the data.</p>
        pub fn set_data_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_location = input;
            self
        }
        /// <p>The ARN of the role that provides Amazon Fraud Detector access to the data location.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_access_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the role that provides Amazon Fraud Detector access to the data location.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_access_role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ExternalEventsDetail`](crate::model::ExternalEventsDetail)
        pub fn build(self) -> crate::model::ExternalEventsDetail {
            crate::model::ExternalEventsDetail {
                data_location: self.data_location,
                data_access_role_arn: self.data_access_role_arn,
            }
        }
    }
}
impl ExternalEventsDetail {
    /// Creates a new builder-style object to manufacture [`ExternalEventsDetail`](crate::model::ExternalEventsDetail)
    pub fn builder() -> crate::model::external_events_detail::Builder {
        crate::model::external_events_detail::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DetectorVersionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Draft,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DetectorVersionStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => DetectorVersionStatus::Active,
            "DRAFT" => DetectorVersionStatus::Draft,
            "INACTIVE" => DetectorVersionStatus::Inactive,
            other => DetectorVersionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DetectorVersionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DetectorVersionStatus::from(s))
    }
}
impl DetectorVersionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DetectorVersionStatus::Active => "ACTIVE",
            DetectorVersionStatus::Draft => "DRAFT",
            DetectorVersionStatus::Inactive => "INACTIVE",
            DetectorVersionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "DRAFT", "INACTIVE"]
    }
}
impl AsRef<str> for DetectorVersionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RuleExecutionMode {
    #[allow(missing_docs)] // documentation missing in model
    AllMatched,
    #[allow(missing_docs)] // documentation missing in model
    FirstMatched,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RuleExecutionMode {
    fn from(s: &str) -> Self {
        match s {
            "ALL_MATCHED" => RuleExecutionMode::AllMatched,
            "FIRST_MATCHED" => RuleExecutionMode::FirstMatched,
            other => RuleExecutionMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RuleExecutionMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RuleExecutionMode::from(s))
    }
}
impl RuleExecutionMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RuleExecutionMode::AllMatched => "ALL_MATCHED",
            RuleExecutionMode::FirstMatched => "FIRST_MATCHED",
            RuleExecutionMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL_MATCHED", "FIRST_MATCHED"]
    }
}
impl AsRef<str> for RuleExecutionMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The model version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModelVersion {
    /// <p>The model ID.</p>
    pub model_id: std::option::Option<std::string::String>,
    /// <p>The model type.</p>
    pub model_type: std::option::Option<crate::model::ModelTypeEnum>,
    /// <p>The model version number.</p>
    pub model_version_number: std::option::Option<std::string::String>,
    /// <p>The model version ARN.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl ModelVersion {
    /// <p>The model ID.</p>
    pub fn model_id(&self) -> std::option::Option<&str> {
        self.model_id.as_deref()
    }
    /// <p>The model type.</p>
    pub fn model_type(&self) -> std::option::Option<&crate::model::ModelTypeEnum> {
        self.model_type.as_ref()
    }
    /// <p>The model version number.</p>
    pub fn model_version_number(&self) -> std::option::Option<&str> {
        self.model_version_number.as_deref()
    }
    /// <p>The model version ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for ModelVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModelVersion");
        formatter.field("model_id", &self.model_id);
        formatter.field("model_type", &self.model_type);
        formatter.field("model_version_number", &self.model_version_number);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`ModelVersion`](crate::model::ModelVersion)
pub mod model_version {
    /// A builder for [`ModelVersion`](crate::model::ModelVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_id: std::option::Option<std::string::String>,
        pub(crate) model_type: std::option::Option<crate::model::ModelTypeEnum>,
        pub(crate) model_version_number: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The model ID.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_id = Some(input.into());
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_id = input;
            self
        }
        /// <p>The model type.</p>
        pub fn model_type(mut self, input: crate::model::ModelTypeEnum) -> Self {
            self.model_type = Some(input);
            self
        }
        /// <p>The model type.</p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.model_type = input;
            self
        }
        /// <p>The model version number.</p>
        pub fn model_version_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_version_number = Some(input.into());
            self
        }
        /// <p>The model version number.</p>
        pub fn set_model_version_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_version_number = input;
            self
        }
        /// <p>The model version ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The model version ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ModelVersion`](crate::model::ModelVersion)
        pub fn build(self) -> crate::model::ModelVersion {
            crate::model::ModelVersion {
                model_id: self.model_id,
                model_type: self.model_type,
                model_version_number: self.model_version_number,
                arn: self.arn,
            }
        }
    }
}
impl ModelVersion {
    /// Creates a new builder-style object to manufacture [`ModelVersion`](crate::model::ModelVersion)
    pub fn builder() -> crate::model::model_version::Builder {
        crate::model::model_version::Builder::default()
    }
}

/// <p>The entity details. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Entity {
    /// <p>The entity type.</p>
    pub entity_type: std::option::Option<std::string::String>,
    /// <p>The entity ID. If you do not know the <code>entityId</code>, you can pass <code>unknown</code>, which is areserved string literal.</p>
    pub entity_id: std::option::Option<std::string::String>,
}
impl Entity {
    /// <p>The entity type.</p>
    pub fn entity_type(&self) -> std::option::Option<&str> {
        self.entity_type.as_deref()
    }
    /// <p>The entity ID. If you do not know the <code>entityId</code>, you can pass <code>unknown</code>, which is areserved string literal.</p>
    pub fn entity_id(&self) -> std::option::Option<&str> {
        self.entity_id.as_deref()
    }
}
impl std::fmt::Debug for Entity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Entity");
        formatter.field("entity_type", &self.entity_type);
        formatter.field("entity_id", &self.entity_id);
        formatter.finish()
    }
}
/// See [`Entity`](crate::model::Entity)
pub mod entity {
    /// A builder for [`Entity`](crate::model::Entity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entity_type: std::option::Option<std::string::String>,
        pub(crate) entity_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The entity type.</p>
        pub fn entity_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_type = Some(input.into());
            self
        }
        /// <p>The entity type.</p>
        pub fn set_entity_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_type = input;
            self
        }
        /// <p>The entity ID. If you do not know the <code>entityId</code>, you can pass <code>unknown</code>, which is areserved string literal.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id = Some(input.into());
            self
        }
        /// <p>The entity ID. If you do not know the <code>entityId</code>, you can pass <code>unknown</code>, which is areserved string literal.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Entity`](crate::model::Entity)
        pub fn build(self) -> crate::model::Entity {
            crate::model::Entity {
                entity_type: self.entity_type,
                entity_id: self.entity_id,
            }
        }
    }
}
impl Entity {
    /// Creates a new builder-style object to manufacture [`Entity`](crate::model::Entity)
    pub fn builder() -> crate::model::entity::Builder {
        crate::model::entity::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ModelEndpointStatus {
    #[allow(missing_docs)] // documentation missing in model
    Associated,
    #[allow(missing_docs)] // documentation missing in model
    Dissociated,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ModelEndpointStatus {
    fn from(s: &str) -> Self {
        match s {
            "ASSOCIATED" => ModelEndpointStatus::Associated,
            "DISSOCIATED" => ModelEndpointStatus::Dissociated,
            other => ModelEndpointStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ModelEndpointStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ModelEndpointStatus::from(s))
    }
}
impl ModelEndpointStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ModelEndpointStatus::Associated => "ASSOCIATED",
            ModelEndpointStatus::Dissociated => "DISSOCIATED",
            ModelEndpointStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASSOCIATED", "DISSOCIATED"]
    }
}
impl AsRef<str> for ModelEndpointStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides the Amazon Sagemaker model output configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModelOutputConfiguration {
    /// <p>The format of the model output configuration.</p>
    pub format: std::option::Option<crate::model::ModelOutputDataFormat>,
    /// <p>A map of JSON keys in response from SageMaker to the Amazon Fraud Detector variables. </p>
    pub json_key_to_variable_map:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A map of CSV index values in the SageMaker response to the Amazon Fraud Detector variables. </p>
    pub csv_index_to_variable_map:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ModelOutputConfiguration {
    /// <p>The format of the model output configuration.</p>
    pub fn format(&self) -> std::option::Option<&crate::model::ModelOutputDataFormat> {
        self.format.as_ref()
    }
    /// <p>A map of JSON keys in response from SageMaker to the Amazon Fraud Detector variables. </p>
    pub fn json_key_to_variable_map(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.json_key_to_variable_map.as_ref()
    }
    /// <p>A map of CSV index values in the SageMaker response to the Amazon Fraud Detector variables. </p>
    pub fn csv_index_to_variable_map(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.csv_index_to_variable_map.as_ref()
    }
}
impl std::fmt::Debug for ModelOutputConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModelOutputConfiguration");
        formatter.field("format", &self.format);
        formatter.field("json_key_to_variable_map", &self.json_key_to_variable_map);
        formatter.field("csv_index_to_variable_map", &self.csv_index_to_variable_map);
        formatter.finish()
    }
}
/// See [`ModelOutputConfiguration`](crate::model::ModelOutputConfiguration)
pub mod model_output_configuration {
    /// A builder for [`ModelOutputConfiguration`](crate::model::ModelOutputConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) format: std::option::Option<crate::model::ModelOutputDataFormat>,
        pub(crate) json_key_to_variable_map: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) csv_index_to_variable_map: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The format of the model output configuration.</p>
        pub fn format(mut self, input: crate::model::ModelOutputDataFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>The format of the model output configuration.</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::ModelOutputDataFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// Adds a key-value pair to `json_key_to_variable_map`.
        ///
        /// To override the contents of this collection use [`set_json_key_to_variable_map`](Self::set_json_key_to_variable_map).
        ///
        /// <p>A map of JSON keys in response from SageMaker to the Amazon Fraud Detector variables. </p>
        pub fn json_key_to_variable_map(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.json_key_to_variable_map.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.json_key_to_variable_map = Some(hash_map);
            self
        }
        /// <p>A map of JSON keys in response from SageMaker to the Amazon Fraud Detector variables. </p>
        pub fn set_json_key_to_variable_map(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.json_key_to_variable_map = input;
            self
        }
        /// Adds a key-value pair to `csv_index_to_variable_map`.
        ///
        /// To override the contents of this collection use [`set_csv_index_to_variable_map`](Self::set_csv_index_to_variable_map).
        ///
        /// <p>A map of CSV index values in the SageMaker response to the Amazon Fraud Detector variables. </p>
        pub fn csv_index_to_variable_map(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.csv_index_to_variable_map.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.csv_index_to_variable_map = Some(hash_map);
            self
        }
        /// <p>A map of CSV index values in the SageMaker response to the Amazon Fraud Detector variables. </p>
        pub fn set_csv_index_to_variable_map(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.csv_index_to_variable_map = input;
            self
        }
        /// Consumes the builder and constructs a [`ModelOutputConfiguration`](crate::model::ModelOutputConfiguration)
        pub fn build(self) -> crate::model::ModelOutputConfiguration {
            crate::model::ModelOutputConfiguration {
                format: self.format,
                json_key_to_variable_map: self.json_key_to_variable_map,
                csv_index_to_variable_map: self.csv_index_to_variable_map,
            }
        }
    }
}
impl ModelOutputConfiguration {
    /// Creates a new builder-style object to manufacture [`ModelOutputConfiguration`](crate::model::ModelOutputConfiguration)
    pub fn builder() -> crate::model::model_output_configuration::Builder {
        crate::model::model_output_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ModelOutputDataFormat {
    #[allow(missing_docs)] // documentation missing in model
    Jsonlines,
    #[allow(missing_docs)] // documentation missing in model
    Csv,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ModelOutputDataFormat {
    fn from(s: &str) -> Self {
        match s {
            "APPLICATION_JSONLINES" => ModelOutputDataFormat::Jsonlines,
            "TEXT_CSV" => ModelOutputDataFormat::Csv,
            other => ModelOutputDataFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ModelOutputDataFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ModelOutputDataFormat::from(s))
    }
}
impl ModelOutputDataFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ModelOutputDataFormat::Jsonlines => "APPLICATION_JSONLINES",
            ModelOutputDataFormat::Csv => "TEXT_CSV",
            ModelOutputDataFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["APPLICATION_JSONLINES", "TEXT_CSV"]
    }
}
impl AsRef<str> for ModelOutputDataFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The Amazon SageMaker model input configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModelInputConfiguration {
    /// <p>The event type name.</p>
    pub event_type_name: std::option::Option<std::string::String>,
    /// <p> The format of the model input configuration. The format differs depending on if it is passed through to SageMaker or constructed by Amazon Fraud Detector.</p>
    pub format: std::option::Option<crate::model::ModelInputDataFormat>,
    /// <p>The event variables.</p>
    pub use_event_variables: std::option::Option<bool>,
    /// <p> Template for constructing the JSON input-data sent to SageMaker. At event-evaluation, the placeholders for variable names in the template will be replaced with the variable values before being sent to SageMaker. </p>
    pub json_input_template: std::option::Option<std::string::String>,
    /// <p> Template for constructing the CSV input-data sent to SageMaker. At event-evaluation, the placeholders for variable-names in the template will be replaced with the variable values before being sent to SageMaker. </p>
    pub csv_input_template: std::option::Option<std::string::String>,
}
impl ModelInputConfiguration {
    /// <p>The event type name.</p>
    pub fn event_type_name(&self) -> std::option::Option<&str> {
        self.event_type_name.as_deref()
    }
    /// <p> The format of the model input configuration. The format differs depending on if it is passed through to SageMaker or constructed by Amazon Fraud Detector.</p>
    pub fn format(&self) -> std::option::Option<&crate::model::ModelInputDataFormat> {
        self.format.as_ref()
    }
    /// <p>The event variables.</p>
    pub fn use_event_variables(&self) -> std::option::Option<bool> {
        self.use_event_variables
    }
    /// <p> Template for constructing the JSON input-data sent to SageMaker. At event-evaluation, the placeholders for variable names in the template will be replaced with the variable values before being sent to SageMaker. </p>
    pub fn json_input_template(&self) -> std::option::Option<&str> {
        self.json_input_template.as_deref()
    }
    /// <p> Template for constructing the CSV input-data sent to SageMaker. At event-evaluation, the placeholders for variable-names in the template will be replaced with the variable values before being sent to SageMaker. </p>
    pub fn csv_input_template(&self) -> std::option::Option<&str> {
        self.csv_input_template.as_deref()
    }
}
impl std::fmt::Debug for ModelInputConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModelInputConfiguration");
        formatter.field("event_type_name", &self.event_type_name);
        formatter.field("format", &self.format);
        formatter.field("use_event_variables", &self.use_event_variables);
        formatter.field("json_input_template", &self.json_input_template);
        formatter.field("csv_input_template", &self.csv_input_template);
        formatter.finish()
    }
}
/// See [`ModelInputConfiguration`](crate::model::ModelInputConfiguration)
pub mod model_input_configuration {
    /// A builder for [`ModelInputConfiguration`](crate::model::ModelInputConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_type_name: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::ModelInputDataFormat>,
        pub(crate) use_event_variables: std::option::Option<bool>,
        pub(crate) json_input_template: std::option::Option<std::string::String>,
        pub(crate) csv_input_template: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The event type name.</p>
        pub fn event_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_type_name = Some(input.into());
            self
        }
        /// <p>The event type name.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_type_name = input;
            self
        }
        /// <p> The format of the model input configuration. The format differs depending on if it is passed through to SageMaker or constructed by Amazon Fraud Detector.</p>
        pub fn format(mut self, input: crate::model::ModelInputDataFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p> The format of the model input configuration. The format differs depending on if it is passed through to SageMaker or constructed by Amazon Fraud Detector.</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::ModelInputDataFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// <p>The event variables.</p>
        pub fn use_event_variables(mut self, input: bool) -> Self {
            self.use_event_variables = Some(input);
            self
        }
        /// <p>The event variables.</p>
        pub fn set_use_event_variables(mut self, input: std::option::Option<bool>) -> Self {
            self.use_event_variables = input;
            self
        }
        /// <p> Template for constructing the JSON input-data sent to SageMaker. At event-evaluation, the placeholders for variable names in the template will be replaced with the variable values before being sent to SageMaker. </p>
        pub fn json_input_template(mut self, input: impl Into<std::string::String>) -> Self {
            self.json_input_template = Some(input.into());
            self
        }
        /// <p> Template for constructing the JSON input-data sent to SageMaker. At event-evaluation, the placeholders for variable names in the template will be replaced with the variable values before being sent to SageMaker. </p>
        pub fn set_json_input_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.json_input_template = input;
            self
        }
        /// <p> Template for constructing the CSV input-data sent to SageMaker. At event-evaluation, the placeholders for variable-names in the template will be replaced with the variable values before being sent to SageMaker. </p>
        pub fn csv_input_template(mut self, input: impl Into<std::string::String>) -> Self {
            self.csv_input_template = Some(input.into());
            self
        }
        /// <p> Template for constructing the CSV input-data sent to SageMaker. At event-evaluation, the placeholders for variable-names in the template will be replaced with the variable values before being sent to SageMaker. </p>
        pub fn set_csv_input_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.csv_input_template = input;
            self
        }
        /// Consumes the builder and constructs a [`ModelInputConfiguration`](crate::model::ModelInputConfiguration)
        pub fn build(self) -> crate::model::ModelInputConfiguration {
            crate::model::ModelInputConfiguration {
                event_type_name: self.event_type_name,
                format: self.format,
                use_event_variables: self.use_event_variables,
                json_input_template: self.json_input_template,
                csv_input_template: self.csv_input_template,
            }
        }
    }
}
impl ModelInputConfiguration {
    /// Creates a new builder-style object to manufacture [`ModelInputConfiguration`](crate::model::ModelInputConfiguration)
    pub fn builder() -> crate::model::model_input_configuration::Builder {
        crate::model::model_input_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ModelInputDataFormat {
    #[allow(missing_docs)] // documentation missing in model
    Json,
    #[allow(missing_docs)] // documentation missing in model
    Csv,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ModelInputDataFormat {
    fn from(s: &str) -> Self {
        match s {
            "APPLICATION_JSON" => ModelInputDataFormat::Json,
            "TEXT_CSV" => ModelInputDataFormat::Csv,
            other => ModelInputDataFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ModelInputDataFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ModelInputDataFormat::from(s))
    }
}
impl ModelInputDataFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ModelInputDataFormat::Json => "APPLICATION_JSON",
            ModelInputDataFormat::Csv => "TEXT_CSV",
            ModelInputDataFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["APPLICATION_JSON", "TEXT_CSV"]
    }
}
impl AsRef<str> for ModelInputDataFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ModelSource {
    #[allow(missing_docs)] // documentation missing in model
    Sagemaker,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ModelSource {
    fn from(s: &str) -> Self {
        match s {
            "SAGEMAKER" => ModelSource::Sagemaker,
            other => ModelSource::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ModelSource {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ModelSource::from(s))
    }
}
impl ModelSource {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ModelSource::Sagemaker => "SAGEMAKER",
            ModelSource::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SAGEMAKER"]
    }
}
impl AsRef<str> for ModelSource {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventIngestion {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventIngestion {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => EventIngestion::Disabled,
            "ENABLED" => EventIngestion::Enabled,
            other => EventIngestion::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventIngestion {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventIngestion::from(s))
    }
}
impl EventIngestion {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventIngestion::Disabled => "DISABLED",
            EventIngestion::Enabled => "ENABLED",
            EventIngestion::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for EventIngestion {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Information about the summary of an event prediction. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventPredictionSummary {
    /// <p> The event ID. </p>
    pub event_id: std::option::Option<std::string::String>,
    /// <p> The event type. </p>
    pub event_type_name: std::option::Option<std::string::String>,
    /// <p> The timestamp of the event. </p>
    pub event_timestamp: std::option::Option<std::string::String>,
    /// <p> The timestamp when the prediction was generated. </p>
    pub prediction_timestamp: std::option::Option<std::string::String>,
    /// <p> The detector ID. </p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p> The detector version ID. </p>
    pub detector_version_id: std::option::Option<std::string::String>,
}
impl EventPredictionSummary {
    /// <p> The event ID. </p>
    pub fn event_id(&self) -> std::option::Option<&str> {
        self.event_id.as_deref()
    }
    /// <p> The event type. </p>
    pub fn event_type_name(&self) -> std::option::Option<&str> {
        self.event_type_name.as_deref()
    }
    /// <p> The timestamp of the event. </p>
    pub fn event_timestamp(&self) -> std::option::Option<&str> {
        self.event_timestamp.as_deref()
    }
    /// <p> The timestamp when the prediction was generated. </p>
    pub fn prediction_timestamp(&self) -> std::option::Option<&str> {
        self.prediction_timestamp.as_deref()
    }
    /// <p> The detector ID. </p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p> The detector version ID. </p>
    pub fn detector_version_id(&self) -> std::option::Option<&str> {
        self.detector_version_id.as_deref()
    }
}
impl std::fmt::Debug for EventPredictionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventPredictionSummary");
        formatter.field("event_id", &self.event_id);
        formatter.field("event_type_name", &self.event_type_name);
        formatter.field("event_timestamp", &self.event_timestamp);
        formatter.field("prediction_timestamp", &self.prediction_timestamp);
        formatter.field("detector_id", &self.detector_id);
        formatter.field("detector_version_id", &self.detector_version_id);
        formatter.finish()
    }
}
/// See [`EventPredictionSummary`](crate::model::EventPredictionSummary)
pub mod event_prediction_summary {
    /// A builder for [`EventPredictionSummary`](crate::model::EventPredictionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_id: std::option::Option<std::string::String>,
        pub(crate) event_type_name: std::option::Option<std::string::String>,
        pub(crate) event_timestamp: std::option::Option<std::string::String>,
        pub(crate) prediction_timestamp: std::option::Option<std::string::String>,
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) detector_version_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The event ID. </p>
        pub fn event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_id = Some(input.into());
            self
        }
        /// <p> The event ID. </p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_id = input;
            self
        }
        /// <p> The event type. </p>
        pub fn event_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_type_name = Some(input.into());
            self
        }
        /// <p> The event type. </p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_type_name = input;
            self
        }
        /// <p> The timestamp of the event. </p>
        pub fn event_timestamp(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_timestamp = Some(input.into());
            self
        }
        /// <p> The timestamp of the event. </p>
        pub fn set_event_timestamp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_timestamp = input;
            self
        }
        /// <p> The timestamp when the prediction was generated. </p>
        pub fn prediction_timestamp(mut self, input: impl Into<std::string::String>) -> Self {
            self.prediction_timestamp = Some(input.into());
            self
        }
        /// <p> The timestamp when the prediction was generated. </p>
        pub fn set_prediction_timestamp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.prediction_timestamp = input;
            self
        }
        /// <p> The detector ID. </p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p> The detector ID. </p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p> The detector version ID. </p>
        pub fn detector_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_version_id = Some(input.into());
            self
        }
        /// <p> The detector version ID. </p>
        pub fn set_detector_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`EventPredictionSummary`](crate::model::EventPredictionSummary)
        pub fn build(self) -> crate::model::EventPredictionSummary {
            crate::model::EventPredictionSummary {
                event_id: self.event_id,
                event_type_name: self.event_type_name,
                event_timestamp: self.event_timestamp,
                prediction_timestamp: self.prediction_timestamp,
                detector_id: self.detector_id,
                detector_version_id: self.detector_version_id,
            }
        }
    }
}
impl EventPredictionSummary {
    /// Creates a new builder-style object to manufacture [`EventPredictionSummary`](crate::model::EventPredictionSummary)
    pub fn builder() -> crate::model::event_prediction_summary::Builder {
        crate::model::event_prediction_summary::Builder::default()
    }
}

/// <p> The time period for when the predictions were generated. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PredictionTimeRange {
    /// <p> The start time of the time period for when the predictions were generated. </p>
    pub start_time: std::option::Option<std::string::String>,
    /// <p> The end time of the time period for when the predictions were generated. </p>
    pub end_time: std::option::Option<std::string::String>,
}
impl PredictionTimeRange {
    /// <p> The start time of the time period for when the predictions were generated. </p>
    pub fn start_time(&self) -> std::option::Option<&str> {
        self.start_time.as_deref()
    }
    /// <p> The end time of the time period for when the predictions were generated. </p>
    pub fn end_time(&self) -> std::option::Option<&str> {
        self.end_time.as_deref()
    }
}
impl std::fmt::Debug for PredictionTimeRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PredictionTimeRange");
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.finish()
    }
}
/// See [`PredictionTimeRange`](crate::model::PredictionTimeRange)
pub mod prediction_time_range {
    /// A builder for [`PredictionTimeRange`](crate::model::PredictionTimeRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<std::string::String>,
        pub(crate) end_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The start time of the time period for when the predictions were generated. </p>
        pub fn start_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_time = Some(input.into());
            self
        }
        /// <p> The start time of the time period for when the predictions were generated. </p>
        pub fn set_start_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start_time = input;
            self
        }
        /// <p> The end time of the time period for when the predictions were generated. </p>
        pub fn end_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.end_time = Some(input.into());
            self
        }
        /// <p> The end time of the time period for when the predictions were generated. </p>
        pub fn set_end_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`PredictionTimeRange`](crate::model::PredictionTimeRange)
        pub fn build(self) -> crate::model::PredictionTimeRange {
            crate::model::PredictionTimeRange {
                start_time: self.start_time,
                end_time: self.end_time,
            }
        }
    }
}
impl PredictionTimeRange {
    /// Creates a new builder-style object to manufacture [`PredictionTimeRange`](crate::model::PredictionTimeRange)
    pub fn builder() -> crate::model::prediction_time_range::Builder {
        crate::model::prediction_time_range::Builder::default()
    }
}

/// <p> A conditional statement for filtering a list of past predictions. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FilterCondition {
    /// <p> A statement containing a resource property and a value to specify filter condition. </p>
    pub value: std::option::Option<std::string::String>,
}
impl FilterCondition {
    /// <p> A statement containing a resource property and a value to specify filter condition. </p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for FilterCondition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FilterCondition");
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`FilterCondition`](crate::model::FilterCondition)
pub mod filter_condition {
    /// A builder for [`FilterCondition`](crate::model::FilterCondition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> A statement containing a resource property and a value to specify filter condition. </p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p> A statement containing a resource property and a value to specify filter condition. </p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`FilterCondition`](crate::model::FilterCondition)
        pub fn build(self) -> crate::model::FilterCondition {
            crate::model::FilterCondition { value: self.value }
        }
    }
}
impl FilterCondition {
    /// Creates a new builder-style object to manufacture [`FilterCondition`](crate::model::FilterCondition)
    pub fn builder() -> crate::model::filter_condition::Builder {
        crate::model::filter_condition::Builder::default()
    }
}

/// <p>The variable.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Variable {
    /// <p>The name of the variable.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The data type of the variable. For more information see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable types</a>.</p>
    pub data_type: std::option::Option<crate::model::DataType>,
    /// <p>The data source of the variable.</p>
    pub data_source: std::option::Option<crate::model::DataSource>,
    /// <p>The default value of the variable.</p>
    pub default_value: std::option::Option<std::string::String>,
    /// <p>The description of the variable. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The variable type of the variable.</p>
    /// <p>Valid Values: <code>AUTH_CODE | AVS | BILLING_ADDRESS_L1 | BILLING_ADDRESS_L2 | BILLING_CITY | BILLING_COUNTRY | BILLING_NAME | BILLING_PHONE | BILLING_STATE | BILLING_ZIP | CARD_BIN | CATEGORICAL | CURRENCY_CODE | EMAIL_ADDRESS | FINGERPRINT | FRAUD_LABEL | FREE_FORM_TEXT | IP_ADDRESS | NUMERIC | ORDER_ID | PAYMENT_TYPE | PHONE_NUMBER | PRICE | PRODUCT_CATEGORY | SHIPPING_ADDRESS_L1 | SHIPPING_ADDRESS_L2 | SHIPPING_CITY | SHIPPING_COUNTRY | SHIPPING_NAME | SHIPPING_PHONE | SHIPPING_STATE | SHIPPING_ZIP | USERAGENT </code> </p>
    pub variable_type: std::option::Option<std::string::String>,
    /// <p>The time when variable was last updated.</p>
    pub last_updated_time: std::option::Option<std::string::String>,
    /// <p>The time when the variable was created.</p>
    pub created_time: std::option::Option<std::string::String>,
    /// <p>The ARN of the variable.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl Variable {
    /// <p>The name of the variable.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The data type of the variable. For more information see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable types</a>.</p>
    pub fn data_type(&self) -> std::option::Option<&crate::model::DataType> {
        self.data_type.as_ref()
    }
    /// <p>The data source of the variable.</p>
    pub fn data_source(&self) -> std::option::Option<&crate::model::DataSource> {
        self.data_source.as_ref()
    }
    /// <p>The default value of the variable.</p>
    pub fn default_value(&self) -> std::option::Option<&str> {
        self.default_value.as_deref()
    }
    /// <p>The description of the variable. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The variable type of the variable.</p>
    /// <p>Valid Values: <code>AUTH_CODE | AVS | BILLING_ADDRESS_L1 | BILLING_ADDRESS_L2 | BILLING_CITY | BILLING_COUNTRY | BILLING_NAME | BILLING_PHONE | BILLING_STATE | BILLING_ZIP | CARD_BIN | CATEGORICAL | CURRENCY_CODE | EMAIL_ADDRESS | FINGERPRINT | FRAUD_LABEL | FREE_FORM_TEXT | IP_ADDRESS | NUMERIC | ORDER_ID | PAYMENT_TYPE | PHONE_NUMBER | PRICE | PRODUCT_CATEGORY | SHIPPING_ADDRESS_L1 | SHIPPING_ADDRESS_L2 | SHIPPING_CITY | SHIPPING_COUNTRY | SHIPPING_NAME | SHIPPING_PHONE | SHIPPING_STATE | SHIPPING_ZIP | USERAGENT </code> </p>
    pub fn variable_type(&self) -> std::option::Option<&str> {
        self.variable_type.as_deref()
    }
    /// <p>The time when variable was last updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&str> {
        self.last_updated_time.as_deref()
    }
    /// <p>The time when the variable was created.</p>
    pub fn created_time(&self) -> std::option::Option<&str> {
        self.created_time.as_deref()
    }
    /// <p>The ARN of the variable.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for Variable {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Variable");
        formatter.field("name", &self.name);
        formatter.field("data_type", &self.data_type);
        formatter.field("data_source", &self.data_source);
        formatter.field("default_value", &self.default_value);
        formatter.field("description", &self.description);
        formatter.field("variable_type", &self.variable_type);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("created_time", &self.created_time);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`Variable`](crate::model::Variable)
pub mod variable {
    /// A builder for [`Variable`](crate::model::Variable)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) data_type: std::option::Option<crate::model::DataType>,
        pub(crate) data_source: std::option::Option<crate::model::DataSource>,
        pub(crate) default_value: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) variable_type: std::option::Option<std::string::String>,
        pub(crate) last_updated_time: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the variable.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the variable.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The data type of the variable. For more information see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable types</a>.</p>
        pub fn data_type(mut self, input: crate::model::DataType) -> Self {
            self.data_type = Some(input);
            self
        }
        /// <p>The data type of the variable. For more information see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable types</a>.</p>
        pub fn set_data_type(mut self, input: std::option::Option<crate::model::DataType>) -> Self {
            self.data_type = input;
            self
        }
        /// <p>The data source of the variable.</p>
        pub fn data_source(mut self, input: crate::model::DataSource) -> Self {
            self.data_source = Some(input);
            self
        }
        /// <p>The data source of the variable.</p>
        pub fn set_data_source(
            mut self,
            input: std::option::Option<crate::model::DataSource>,
        ) -> Self {
            self.data_source = input;
            self
        }
        /// <p>The default value of the variable.</p>
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_value = Some(input.into());
            self
        }
        /// <p>The default value of the variable.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// <p>The description of the variable. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the variable. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The variable type of the variable.</p>
        /// <p>Valid Values: <code>AUTH_CODE | AVS | BILLING_ADDRESS_L1 | BILLING_ADDRESS_L2 | BILLING_CITY | BILLING_COUNTRY | BILLING_NAME | BILLING_PHONE | BILLING_STATE | BILLING_ZIP | CARD_BIN | CATEGORICAL | CURRENCY_CODE | EMAIL_ADDRESS | FINGERPRINT | FRAUD_LABEL | FREE_FORM_TEXT | IP_ADDRESS | NUMERIC | ORDER_ID | PAYMENT_TYPE | PHONE_NUMBER | PRICE | PRODUCT_CATEGORY | SHIPPING_ADDRESS_L1 | SHIPPING_ADDRESS_L2 | SHIPPING_CITY | SHIPPING_COUNTRY | SHIPPING_NAME | SHIPPING_PHONE | SHIPPING_STATE | SHIPPING_ZIP | USERAGENT </code> </p>
        pub fn variable_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.variable_type = Some(input.into());
            self
        }
        /// <p>The variable type of the variable.</p>
        /// <p>Valid Values: <code>AUTH_CODE | AVS | BILLING_ADDRESS_L1 | BILLING_ADDRESS_L2 | BILLING_CITY | BILLING_COUNTRY | BILLING_NAME | BILLING_PHONE | BILLING_STATE | BILLING_ZIP | CARD_BIN | CATEGORICAL | CURRENCY_CODE | EMAIL_ADDRESS | FINGERPRINT | FRAUD_LABEL | FREE_FORM_TEXT | IP_ADDRESS | NUMERIC | ORDER_ID | PAYMENT_TYPE | PHONE_NUMBER | PRICE | PRODUCT_CATEGORY | SHIPPING_ADDRESS_L1 | SHIPPING_ADDRESS_L2 | SHIPPING_CITY | SHIPPING_COUNTRY | SHIPPING_NAME | SHIPPING_PHONE | SHIPPING_STATE | SHIPPING_ZIP | USERAGENT </code> </p>
        pub fn set_variable_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.variable_type = input;
            self
        }
        /// <p>The time when variable was last updated.</p>
        pub fn last_updated_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_updated_time = Some(input.into());
            self
        }
        /// <p>The time when variable was last updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>The time when the variable was created.</p>
        pub fn created_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_time = Some(input.into());
            self
        }
        /// <p>The time when the variable was created.</p>
        pub fn set_created_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The ARN of the variable.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the variable.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Variable`](crate::model::Variable)
        pub fn build(self) -> crate::model::Variable {
            crate::model::Variable {
                name: self.name,
                data_type: self.data_type,
                data_source: self.data_source,
                default_value: self.default_value,
                description: self.description,
                variable_type: self.variable_type,
                last_updated_time: self.last_updated_time,
                created_time: self.created_time,
                arn: self.arn,
            }
        }
    }
}
impl Variable {
    /// Creates a new builder-style object to manufacture [`Variable`](crate::model::Variable)
    pub fn builder() -> crate::model::variable::Builder {
        crate::model::variable::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataSource {
    #[allow(missing_docs)] // documentation missing in model
    Event,
    #[allow(missing_docs)] // documentation missing in model
    ExternalModelScore,
    #[allow(missing_docs)] // documentation missing in model
    ModelScore,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataSource {
    fn from(s: &str) -> Self {
        match s {
            "EVENT" => DataSource::Event,
            "EXTERNAL_MODEL_SCORE" => DataSource::ExternalModelScore,
            "MODEL_SCORE" => DataSource::ModelScore,
            other => DataSource::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataSource {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataSource::from(s))
    }
}
impl DataSource {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataSource::Event => "EVENT",
            DataSource::ExternalModelScore => "EXTERNAL_MODEL_SCORE",
            DataSource::ModelScore => "MODEL_SCORE",
            DataSource::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EVENT", "EXTERNAL_MODEL_SCORE", "MODEL_SCORE"]
    }
}
impl AsRef<str> for DataSource {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataType {
    #[allow(missing_docs)] // documentation missing in model
    Boolean,
    #[allow(missing_docs)] // documentation missing in model
    Float,
    #[allow(missing_docs)] // documentation missing in model
    Integer,
    #[allow(missing_docs)] // documentation missing in model
    String,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataType {
    fn from(s: &str) -> Self {
        match s {
            "BOOLEAN" => DataType::Boolean,
            "FLOAT" => DataType::Float,
            "INTEGER" => DataType::Integer,
            "STRING" => DataType::String,
            other => DataType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataType::from(s))
    }
}
impl DataType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataType::Boolean => "BOOLEAN",
            DataType::Float => "FLOAT",
            DataType::Integer => "INTEGER",
            DataType::String => "STRING",
            DataType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BOOLEAN", "FLOAT", "INTEGER", "STRING"]
    }
}
impl AsRef<str> for DataType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The details of the rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RuleDetail {
    /// <p>The rule ID.</p>
    pub rule_id: std::option::Option<std::string::String>,
    /// <p>The rule description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The detector for which the rule is associated.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The rule version.</p>
    pub rule_version: std::option::Option<std::string::String>,
    /// <p>The rule expression.</p>
    pub expression: std::option::Option<std::string::String>,
    /// <p>The rule language.</p>
    pub language: std::option::Option<crate::model::Language>,
    /// <p>The rule outcomes.</p>
    pub outcomes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Timestamp of the last time the rule was updated.</p>
    pub last_updated_time: std::option::Option<std::string::String>,
    /// <p>The timestamp of when the rule was created.</p>
    pub created_time: std::option::Option<std::string::String>,
    /// <p>The rule ARN.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl RuleDetail {
    /// <p>The rule ID.</p>
    pub fn rule_id(&self) -> std::option::Option<&str> {
        self.rule_id.as_deref()
    }
    /// <p>The rule description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The detector for which the rule is associated.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>The rule version.</p>
    pub fn rule_version(&self) -> std::option::Option<&str> {
        self.rule_version.as_deref()
    }
    /// <p>The rule expression.</p>
    pub fn expression(&self) -> std::option::Option<&str> {
        self.expression.as_deref()
    }
    /// <p>The rule language.</p>
    pub fn language(&self) -> std::option::Option<&crate::model::Language> {
        self.language.as_ref()
    }
    /// <p>The rule outcomes.</p>
    pub fn outcomes(&self) -> std::option::Option<&[std::string::String]> {
        self.outcomes.as_deref()
    }
    /// <p>Timestamp of the last time the rule was updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&str> {
        self.last_updated_time.as_deref()
    }
    /// <p>The timestamp of when the rule was created.</p>
    pub fn created_time(&self) -> std::option::Option<&str> {
        self.created_time.as_deref()
    }
    /// <p>The rule ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for RuleDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RuleDetail");
        formatter.field("rule_id", &self.rule_id);
        formatter.field("description", &self.description);
        formatter.field("detector_id", &self.detector_id);
        formatter.field("rule_version", &self.rule_version);
        formatter.field("expression", &"*** Sensitive Data Redacted ***");
        formatter.field("language", &self.language);
        formatter.field("outcomes", &self.outcomes);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("created_time", &self.created_time);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`RuleDetail`](crate::model::RuleDetail)
pub mod rule_detail {
    /// A builder for [`RuleDetail`](crate::model::RuleDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) rule_version: std::option::Option<std::string::String>,
        pub(crate) expression: std::option::Option<std::string::String>,
        pub(crate) language: std::option::Option<crate::model::Language>,
        pub(crate) outcomes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) last_updated_time: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The rule ID.</p>
        pub fn rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_id = Some(input.into());
            self
        }
        /// <p>The rule ID.</p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_id = input;
            self
        }
        /// <p>The rule description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The rule description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The detector for which the rule is associated.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The detector for which the rule is associated.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The rule version.</p>
        pub fn rule_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_version = Some(input.into());
            self
        }
        /// <p>The rule version.</p>
        pub fn set_rule_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_version = input;
            self
        }
        /// <p>The rule expression.</p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.expression = Some(input.into());
            self
        }
        /// <p>The rule expression.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.expression = input;
            self
        }
        /// <p>The rule language.</p>
        pub fn language(mut self, input: crate::model::Language) -> Self {
            self.language = Some(input);
            self
        }
        /// <p>The rule language.</p>
        pub fn set_language(mut self, input: std::option::Option<crate::model::Language>) -> Self {
            self.language = input;
            self
        }
        /// Appends an item to `outcomes`.
        ///
        /// To override the contents of this collection use [`set_outcomes`](Self::set_outcomes).
        ///
        /// <p>The rule outcomes.</p>
        pub fn outcomes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.outcomes.unwrap_or_default();
            v.push(input.into());
            self.outcomes = Some(v);
            self
        }
        /// <p>The rule outcomes.</p>
        pub fn set_outcomes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.outcomes = input;
            self
        }
        /// <p>Timestamp of the last time the rule was updated.</p>
        pub fn last_updated_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_updated_time = Some(input.into());
            self
        }
        /// <p>Timestamp of the last time the rule was updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>The timestamp of when the rule was created.</p>
        pub fn created_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_time = Some(input.into());
            self
        }
        /// <p>The timestamp of when the rule was created.</p>
        pub fn set_created_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The rule ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The rule ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`RuleDetail`](crate::model::RuleDetail)
        pub fn build(self) -> crate::model::RuleDetail {
            crate::model::RuleDetail {
                rule_id: self.rule_id,
                description: self.description,
                detector_id: self.detector_id,
                rule_version: self.rule_version,
                expression: self.expression,
                language: self.language,
                outcomes: self.outcomes,
                last_updated_time: self.last_updated_time,
                created_time: self.created_time,
                arn: self.arn,
            }
        }
    }
}
impl RuleDetail {
    /// Creates a new builder-style object to manufacture [`RuleDetail`](crate::model::RuleDetail)
    pub fn builder() -> crate::model::rule_detail::Builder {
        crate::model::rule_detail::Builder::default()
    }
}

/// <p>The outcome.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Outcome {
    /// <p>The outcome name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The outcome description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The timestamp when the outcome was last updated.</p>
    pub last_updated_time: std::option::Option<std::string::String>,
    /// <p>The timestamp when the outcome was created.</p>
    pub created_time: std::option::Option<std::string::String>,
    /// <p>The outcome ARN.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl Outcome {
    /// <p>The outcome name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The outcome description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The timestamp when the outcome was last updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&str> {
        self.last_updated_time.as_deref()
    }
    /// <p>The timestamp when the outcome was created.</p>
    pub fn created_time(&self) -> std::option::Option<&str> {
        self.created_time.as_deref()
    }
    /// <p>The outcome ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for Outcome {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Outcome");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("created_time", &self.created_time);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`Outcome`](crate::model::Outcome)
pub mod outcome {
    /// A builder for [`Outcome`](crate::model::Outcome)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) last_updated_time: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The outcome name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The outcome name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The outcome description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The outcome description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The timestamp when the outcome was last updated.</p>
        pub fn last_updated_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_updated_time = Some(input.into());
            self
        }
        /// <p>The timestamp when the outcome was last updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>The timestamp when the outcome was created.</p>
        pub fn created_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_time = Some(input.into());
            self
        }
        /// <p>The timestamp when the outcome was created.</p>
        pub fn set_created_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The outcome ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The outcome ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Outcome`](crate::model::Outcome)
        pub fn build(self) -> crate::model::Outcome {
            crate::model::Outcome {
                name: self.name,
                description: self.description,
                last_updated_time: self.last_updated_time,
                created_time: self.created_time,
                arn: self.arn,
            }
        }
    }
}
impl Outcome {
    /// Creates a new builder-style object to manufacture [`Outcome`](crate::model::Outcome)
    pub fn builder() -> crate::model::outcome::Builder {
        crate::model::outcome::Builder::default()
    }
}

/// <p>The training data schema.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrainingDataSchema {
    /// <p>The training data schema variables.</p>
    pub model_variables: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The label schema.</p>
    pub label_schema: std::option::Option<crate::model::LabelSchema>,
}
impl TrainingDataSchema {
    /// <p>The training data schema variables.</p>
    pub fn model_variables(&self) -> std::option::Option<&[std::string::String]> {
        self.model_variables.as_deref()
    }
    /// <p>The label schema.</p>
    pub fn label_schema(&self) -> std::option::Option<&crate::model::LabelSchema> {
        self.label_schema.as_ref()
    }
}
impl std::fmt::Debug for TrainingDataSchema {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrainingDataSchema");
        formatter.field("model_variables", &self.model_variables);
        formatter.field("label_schema", &self.label_schema);
        formatter.finish()
    }
}
/// See [`TrainingDataSchema`](crate::model::TrainingDataSchema)
pub mod training_data_schema {
    /// A builder for [`TrainingDataSchema`](crate::model::TrainingDataSchema)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_variables: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) label_schema: std::option::Option<crate::model::LabelSchema>,
    }
    impl Builder {
        /// Appends an item to `model_variables`.
        ///
        /// To override the contents of this collection use [`set_model_variables`](Self::set_model_variables).
        ///
        /// <p>The training data schema variables.</p>
        pub fn model_variables(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.model_variables.unwrap_or_default();
            v.push(input.into());
            self.model_variables = Some(v);
            self
        }
        /// <p>The training data schema variables.</p>
        pub fn set_model_variables(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.model_variables = input;
            self
        }
        /// <p>The label schema.</p>
        pub fn label_schema(mut self, input: crate::model::LabelSchema) -> Self {
            self.label_schema = Some(input);
            self
        }
        /// <p>The label schema.</p>
        pub fn set_label_schema(
            mut self,
            input: std::option::Option<crate::model::LabelSchema>,
        ) -> Self {
            self.label_schema = input;
            self
        }
        /// Consumes the builder and constructs a [`TrainingDataSchema`](crate::model::TrainingDataSchema)
        pub fn build(self) -> crate::model::TrainingDataSchema {
            crate::model::TrainingDataSchema {
                model_variables: self.model_variables,
                label_schema: self.label_schema,
            }
        }
    }
}
impl TrainingDataSchema {
    /// Creates a new builder-style object to manufacture [`TrainingDataSchema`](crate::model::TrainingDataSchema)
    pub fn builder() -> crate::model::training_data_schema::Builder {
        crate::model::training_data_schema::Builder::default()
    }
}

/// <p>The label schema.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LabelSchema {
    /// <p>The label mapper maps the Amazon Fraud Detector supported model classification labels (<code>FRAUD</code>, <code>LEGIT</code>) to the appropriate event type labels. For example, if "<code>FRAUD</code>" and "<code>LEGIT</code>" are Amazon Fraud Detector supported labels, this mapper could be: <code>{"FRAUD" =&gt; ["0"]</code>, <code>"LEGIT" =&gt; ["1"]}</code> or <code>{"FRAUD" =&gt; ["false"]</code>, <code>"LEGIT" =&gt; ["true"]}</code> or <code>{"FRAUD" =&gt; ["fraud", "abuse"]</code>, <code>"LEGIT" =&gt; ["legit", "safe"]}</code>. The value part of the mapper is a list, because you may have multiple label variants from your event type for a single Amazon Fraud Detector label. </p>
    pub label_mapper: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    >,
    /// <p>The action to take for unlabeled events.</p>
    pub unlabeled_events_treatment: std::option::Option<crate::model::UnlabeledEventsTreatment>,
}
impl LabelSchema {
    /// <p>The label mapper maps the Amazon Fraud Detector supported model classification labels (<code>FRAUD</code>, <code>LEGIT</code>) to the appropriate event type labels. For example, if "<code>FRAUD</code>" and "<code>LEGIT</code>" are Amazon Fraud Detector supported labels, this mapper could be: <code>{"FRAUD" =&gt; ["0"]</code>, <code>"LEGIT" =&gt; ["1"]}</code> or <code>{"FRAUD" =&gt; ["false"]</code>, <code>"LEGIT" =&gt; ["true"]}</code> or <code>{"FRAUD" =&gt; ["fraud", "abuse"]</code>, <code>"LEGIT" =&gt; ["legit", "safe"]}</code>. The value part of the mapper is a list, because you may have multiple label variants from your event type for a single Amazon Fraud Detector label. </p>
    pub fn label_mapper(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    > {
        self.label_mapper.as_ref()
    }
    /// <p>The action to take for unlabeled events.</p>
    pub fn unlabeled_events_treatment(
        &self,
    ) -> std::option::Option<&crate::model::UnlabeledEventsTreatment> {
        self.unlabeled_events_treatment.as_ref()
    }
}
impl std::fmt::Debug for LabelSchema {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LabelSchema");
        formatter.field("label_mapper", &self.label_mapper);
        formatter.field(
            "unlabeled_events_treatment",
            &self.unlabeled_events_treatment,
        );
        formatter.finish()
    }
}
/// See [`LabelSchema`](crate::model::LabelSchema)
pub mod label_schema {
    /// A builder for [`LabelSchema`](crate::model::LabelSchema)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) label_mapper: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
        pub(crate) unlabeled_events_treatment:
            std::option::Option<crate::model::UnlabeledEventsTreatment>,
    }
    impl Builder {
        /// Adds a key-value pair to `label_mapper`.
        ///
        /// To override the contents of this collection use [`set_label_mapper`](Self::set_label_mapper).
        ///
        /// <p>The label mapper maps the Amazon Fraud Detector supported model classification labels (<code>FRAUD</code>, <code>LEGIT</code>) to the appropriate event type labels. For example, if "<code>FRAUD</code>" and "<code>LEGIT</code>" are Amazon Fraud Detector supported labels, this mapper could be: <code>{"FRAUD" =&gt; ["0"]</code>, <code>"LEGIT" =&gt; ["1"]}</code> or <code>{"FRAUD" =&gt; ["false"]</code>, <code>"LEGIT" =&gt; ["true"]}</code> or <code>{"FRAUD" =&gt; ["fraud", "abuse"]</code>, <code>"LEGIT" =&gt; ["legit", "safe"]}</code>. The value part of the mapper is a list, because you may have multiple label variants from your event type for a single Amazon Fraud Detector label. </p>
        pub fn label_mapper(
            mut self,
            k: impl Into<std::string::String>,
            v: std::vec::Vec<std::string::String>,
        ) -> Self {
            let mut hash_map = self.label_mapper.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.label_mapper = Some(hash_map);
            self
        }
        /// <p>The label mapper maps the Amazon Fraud Detector supported model classification labels (<code>FRAUD</code>, <code>LEGIT</code>) to the appropriate event type labels. For example, if "<code>FRAUD</code>" and "<code>LEGIT</code>" are Amazon Fraud Detector supported labels, this mapper could be: <code>{"FRAUD" =&gt; ["0"]</code>, <code>"LEGIT" =&gt; ["1"]}</code> or <code>{"FRAUD" =&gt; ["false"]</code>, <code>"LEGIT" =&gt; ["true"]}</code> or <code>{"FRAUD" =&gt; ["fraud", "abuse"]</code>, <code>"LEGIT" =&gt; ["legit", "safe"]}</code>. The value part of the mapper is a list, because you may have multiple label variants from your event type for a single Amazon Fraud Detector label. </p>
        pub fn set_label_mapper(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.label_mapper = input;
            self
        }
        /// <p>The action to take for unlabeled events.</p>
        pub fn unlabeled_events_treatment(
            mut self,
            input: crate::model::UnlabeledEventsTreatment,
        ) -> Self {
            self.unlabeled_events_treatment = Some(input);
            self
        }
        /// <p>The action to take for unlabeled events.</p>
        pub fn set_unlabeled_events_treatment(
            mut self,
            input: std::option::Option<crate::model::UnlabeledEventsTreatment>,
        ) -> Self {
            self.unlabeled_events_treatment = input;
            self
        }
        /// Consumes the builder and constructs a [`LabelSchema`](crate::model::LabelSchema)
        pub fn build(self) -> crate::model::LabelSchema {
            crate::model::LabelSchema {
                label_mapper: self.label_mapper,
                unlabeled_events_treatment: self.unlabeled_events_treatment,
            }
        }
    }
}
impl LabelSchema {
    /// Creates a new builder-style object to manufacture [`LabelSchema`](crate::model::LabelSchema)
    pub fn builder() -> crate::model::label_schema::Builder {
        crate::model::label_schema::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UnlabeledEventsTreatment {
    #[allow(missing_docs)] // documentation missing in model
    Fraud,
    #[allow(missing_docs)] // documentation missing in model
    Ignore,
    #[allow(missing_docs)] // documentation missing in model
    Legit,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UnlabeledEventsTreatment {
    fn from(s: &str) -> Self {
        match s {
            "FRAUD" => UnlabeledEventsTreatment::Fraud,
            "IGNORE" => UnlabeledEventsTreatment::Ignore,
            "LEGIT" => UnlabeledEventsTreatment::Legit,
            other => UnlabeledEventsTreatment::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UnlabeledEventsTreatment {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UnlabeledEventsTreatment::from(s))
    }
}
impl UnlabeledEventsTreatment {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UnlabeledEventsTreatment::Fraud => "FRAUD",
            UnlabeledEventsTreatment::Ignore => "IGNORE",
            UnlabeledEventsTreatment::Legit => "LEGIT",
            UnlabeledEventsTreatment::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FRAUD", "IGNORE", "LEGIT"]
    }
}
impl AsRef<str> for UnlabeledEventsTreatment {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TrainingDataSourceEnum {
    #[allow(missing_docs)] // documentation missing in model
    ExternalEvents,
    #[allow(missing_docs)] // documentation missing in model
    IngestedEvents,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TrainingDataSourceEnum {
    fn from(s: &str) -> Self {
        match s {
            "EXTERNAL_EVENTS" => TrainingDataSourceEnum::ExternalEvents,
            "INGESTED_EVENTS" => TrainingDataSourceEnum::IngestedEvents,
            other => TrainingDataSourceEnum::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TrainingDataSourceEnum {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TrainingDataSourceEnum::from(s))
    }
}
impl TrainingDataSourceEnum {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TrainingDataSourceEnum::ExternalEvents => "EXTERNAL_EVENTS",
            TrainingDataSourceEnum::IngestedEvents => "INGESTED_EVENTS",
            TrainingDataSourceEnum::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EXTERNAL_EVENTS", "INGESTED_EVENTS"]
    }
}
impl AsRef<str> for TrainingDataSourceEnum {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The model.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Model {
    /// <p>The model ID.</p>
    pub model_id: std::option::Option<std::string::String>,
    /// <p>The model type.</p>
    pub model_type: std::option::Option<crate::model::ModelTypeEnum>,
    /// <p>The model description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The name of the event type.</p>
    pub event_type_name: std::option::Option<std::string::String>,
    /// <p>Timestamp of when the model was created.</p>
    pub created_time: std::option::Option<std::string::String>,
    /// <p>Timestamp of last time the model was updated.</p>
    pub last_updated_time: std::option::Option<std::string::String>,
    /// <p>The ARN of the model.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl Model {
    /// <p>The model ID.</p>
    pub fn model_id(&self) -> std::option::Option<&str> {
        self.model_id.as_deref()
    }
    /// <p>The model type.</p>
    pub fn model_type(&self) -> std::option::Option<&crate::model::ModelTypeEnum> {
        self.model_type.as_ref()
    }
    /// <p>The model description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The name of the event type.</p>
    pub fn event_type_name(&self) -> std::option::Option<&str> {
        self.event_type_name.as_deref()
    }
    /// <p>Timestamp of when the model was created.</p>
    pub fn created_time(&self) -> std::option::Option<&str> {
        self.created_time.as_deref()
    }
    /// <p>Timestamp of last time the model was updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&str> {
        self.last_updated_time.as_deref()
    }
    /// <p>The ARN of the model.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for Model {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Model");
        formatter.field("model_id", &self.model_id);
        formatter.field("model_type", &self.model_type);
        formatter.field("description", &self.description);
        formatter.field("event_type_name", &self.event_type_name);
        formatter.field("created_time", &self.created_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`Model`](crate::model::Model)
pub mod model {
    /// A builder for [`Model`](crate::model::Model)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_id: std::option::Option<std::string::String>,
        pub(crate) model_type: std::option::Option<crate::model::ModelTypeEnum>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) event_type_name: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<std::string::String>,
        pub(crate) last_updated_time: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The model ID.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_id = Some(input.into());
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_id = input;
            self
        }
        /// <p>The model type.</p>
        pub fn model_type(mut self, input: crate::model::ModelTypeEnum) -> Self {
            self.model_type = Some(input);
            self
        }
        /// <p>The model type.</p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.model_type = input;
            self
        }
        /// <p>The model description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The model description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name of the event type.</p>
        pub fn event_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_type_name = Some(input.into());
            self
        }
        /// <p>The name of the event type.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_type_name = input;
            self
        }
        /// <p>Timestamp of when the model was created.</p>
        pub fn created_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_time = Some(input.into());
            self
        }
        /// <p>Timestamp of when the model was created.</p>
        pub fn set_created_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_time = input;
            self
        }
        /// <p>Timestamp of last time the model was updated.</p>
        pub fn last_updated_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_updated_time = Some(input.into());
            self
        }
        /// <p>Timestamp of last time the model was updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>The ARN of the model.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the model.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Model`](crate::model::Model)
        pub fn build(self) -> crate::model::Model {
            crate::model::Model {
                model_id: self.model_id,
                model_type: self.model_type,
                description: self.description,
                event_type_name: self.event_type_name,
                created_time: self.created_time,
                last_updated_time: self.last_updated_time,
                arn: self.arn,
            }
        }
    }
}
impl Model {
    /// Creates a new builder-style object to manufacture [`Model`](crate::model::Model)
    pub fn builder() -> crate::model::model::Builder {
        crate::model::model::Builder::default()
    }
}

/// <p>The label details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Label {
    /// <p>The label name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The label description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Timestamp of when the label was last updated.</p>
    pub last_updated_time: std::option::Option<std::string::String>,
    /// <p>Timestamp of when the event type was created.</p>
    pub created_time: std::option::Option<std::string::String>,
    /// <p>The label ARN.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl Label {
    /// <p>The label name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The label description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Timestamp of when the label was last updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&str> {
        self.last_updated_time.as_deref()
    }
    /// <p>Timestamp of when the event type was created.</p>
    pub fn created_time(&self) -> std::option::Option<&str> {
        self.created_time.as_deref()
    }
    /// <p>The label ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for Label {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Label");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("created_time", &self.created_time);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`Label`](crate::model::Label)
pub mod label {
    /// A builder for [`Label`](crate::model::Label)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) last_updated_time: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The label name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The label name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The label description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The label description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Timestamp of when the label was last updated.</p>
        pub fn last_updated_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_updated_time = Some(input.into());
            self
        }
        /// <p>Timestamp of when the label was last updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>Timestamp of when the event type was created.</p>
        pub fn created_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_time = Some(input.into());
            self
        }
        /// <p>Timestamp of when the event type was created.</p>
        pub fn set_created_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The label ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The label ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Label`](crate::model::Label)
        pub fn build(self) -> crate::model::Label {
            crate::model::Label {
                name: self.name,
                description: self.description,
                last_updated_time: self.last_updated_time,
                created_time: self.created_time,
                arn: self.arn,
            }
        }
    }
}
impl Label {
    /// Creates a new builder-style object to manufacture [`Label`](crate::model::Label)
    pub fn builder() -> crate::model::label::Builder {
        crate::model::label::Builder::default()
    }
}

/// <p>The KMS key details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsKey {
    /// <p>The encryption key ARN.</p>
    pub kms_encryption_key_arn: std::option::Option<std::string::String>,
}
impl KmsKey {
    /// <p>The encryption key ARN.</p>
    pub fn kms_encryption_key_arn(&self) -> std::option::Option<&str> {
        self.kms_encryption_key_arn.as_deref()
    }
}
impl std::fmt::Debug for KmsKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsKey");
        formatter.field("kms_encryption_key_arn", &self.kms_encryption_key_arn);
        formatter.finish()
    }
}
/// See [`KmsKey`](crate::model::KmsKey)
pub mod kms_key {
    /// A builder for [`KmsKey`](crate::model::KmsKey)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) kms_encryption_key_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The encryption key ARN.</p>
        pub fn kms_encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_encryption_key_arn = Some(input.into());
            self
        }
        /// <p>The encryption key ARN.</p>
        pub fn set_kms_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.kms_encryption_key_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsKey`](crate::model::KmsKey)
        pub fn build(self) -> crate::model::KmsKey {
            crate::model::KmsKey {
                kms_encryption_key_arn: self.kms_encryption_key_arn,
            }
        }
    }
}
impl KmsKey {
    /// Creates a new builder-style object to manufacture [`KmsKey`](crate::model::KmsKey)
    pub fn builder() -> crate::model::kms_key::Builder {
        crate::model::kms_key::Builder::default()
    }
}

/// <p>The Amazon SageMaker model.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExternalModel {
    /// <p>The Amazon SageMaker model endpoints.</p>
    pub model_endpoint: std::option::Option<std::string::String>,
    /// <p>The source of the model.</p>
    pub model_source: std::option::Option<crate::model::ModelSource>,
    /// <p>The role used to invoke the model. </p>
    pub invoke_model_endpoint_role_arn: std::option::Option<std::string::String>,
    /// <p>The input configuration.</p>
    pub input_configuration: std::option::Option<crate::model::ModelInputConfiguration>,
    /// <p>The output configuration.</p>
    pub output_configuration: std::option::Option<crate::model::ModelOutputConfiguration>,
    /// <p>The Amazon Fraud Detector status for the external model endpoint</p>
    pub model_endpoint_status: std::option::Option<crate::model::ModelEndpointStatus>,
    /// <p>Timestamp of when the model was last updated.</p>
    pub last_updated_time: std::option::Option<std::string::String>,
    /// <p>Timestamp of when the model was last created.</p>
    pub created_time: std::option::Option<std::string::String>,
    /// <p>The model ARN.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl ExternalModel {
    /// <p>The Amazon SageMaker model endpoints.</p>
    pub fn model_endpoint(&self) -> std::option::Option<&str> {
        self.model_endpoint.as_deref()
    }
    /// <p>The source of the model.</p>
    pub fn model_source(&self) -> std::option::Option<&crate::model::ModelSource> {
        self.model_source.as_ref()
    }
    /// <p>The role used to invoke the model. </p>
    pub fn invoke_model_endpoint_role_arn(&self) -> std::option::Option<&str> {
        self.invoke_model_endpoint_role_arn.as_deref()
    }
    /// <p>The input configuration.</p>
    pub fn input_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ModelInputConfiguration> {
        self.input_configuration.as_ref()
    }
    /// <p>The output configuration.</p>
    pub fn output_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ModelOutputConfiguration> {
        self.output_configuration.as_ref()
    }
    /// <p>The Amazon Fraud Detector status for the external model endpoint</p>
    pub fn model_endpoint_status(&self) -> std::option::Option<&crate::model::ModelEndpointStatus> {
        self.model_endpoint_status.as_ref()
    }
    /// <p>Timestamp of when the model was last updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&str> {
        self.last_updated_time.as_deref()
    }
    /// <p>Timestamp of when the model was last created.</p>
    pub fn created_time(&self) -> std::option::Option<&str> {
        self.created_time.as_deref()
    }
    /// <p>The model ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for ExternalModel {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExternalModel");
        formatter.field("model_endpoint", &self.model_endpoint);
        formatter.field("model_source", &self.model_source);
        formatter.field(
            "invoke_model_endpoint_role_arn",
            &self.invoke_model_endpoint_role_arn,
        );
        formatter.field("input_configuration", &self.input_configuration);
        formatter.field("output_configuration", &self.output_configuration);
        formatter.field("model_endpoint_status", &self.model_endpoint_status);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("created_time", &self.created_time);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`ExternalModel`](crate::model::ExternalModel)
pub mod external_model {
    /// A builder for [`ExternalModel`](crate::model::ExternalModel)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_endpoint: std::option::Option<std::string::String>,
        pub(crate) model_source: std::option::Option<crate::model::ModelSource>,
        pub(crate) invoke_model_endpoint_role_arn: std::option::Option<std::string::String>,
        pub(crate) input_configuration: std::option::Option<crate::model::ModelInputConfiguration>,
        pub(crate) output_configuration:
            std::option::Option<crate::model::ModelOutputConfiguration>,
        pub(crate) model_endpoint_status: std::option::Option<crate::model::ModelEndpointStatus>,
        pub(crate) last_updated_time: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon SageMaker model endpoints.</p>
        pub fn model_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_endpoint = Some(input.into());
            self
        }
        /// <p>The Amazon SageMaker model endpoints.</p>
        pub fn set_model_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_endpoint = input;
            self
        }
        /// <p>The source of the model.</p>
        pub fn model_source(mut self, input: crate::model::ModelSource) -> Self {
            self.model_source = Some(input);
            self
        }
        /// <p>The source of the model.</p>
        pub fn set_model_source(
            mut self,
            input: std::option::Option<crate::model::ModelSource>,
        ) -> Self {
            self.model_source = input;
            self
        }
        /// <p>The role used to invoke the model. </p>
        pub fn invoke_model_endpoint_role_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.invoke_model_endpoint_role_arn = Some(input.into());
            self
        }
        /// <p>The role used to invoke the model. </p>
        pub fn set_invoke_model_endpoint_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.invoke_model_endpoint_role_arn = input;
            self
        }
        /// <p>The input configuration.</p>
        pub fn input_configuration(mut self, input: crate::model::ModelInputConfiguration) -> Self {
            self.input_configuration = Some(input);
            self
        }
        /// <p>The input configuration.</p>
        pub fn set_input_configuration(
            mut self,
            input: std::option::Option<crate::model::ModelInputConfiguration>,
        ) -> Self {
            self.input_configuration = input;
            self
        }
        /// <p>The output configuration.</p>
        pub fn output_configuration(
            mut self,
            input: crate::model::ModelOutputConfiguration,
        ) -> Self {
            self.output_configuration = Some(input);
            self
        }
        /// <p>The output configuration.</p>
        pub fn set_output_configuration(
            mut self,
            input: std::option::Option<crate::model::ModelOutputConfiguration>,
        ) -> Self {
            self.output_configuration = input;
            self
        }
        /// <p>The Amazon Fraud Detector status for the external model endpoint</p>
        pub fn model_endpoint_status(mut self, input: crate::model::ModelEndpointStatus) -> Self {
            self.model_endpoint_status = Some(input);
            self
        }
        /// <p>The Amazon Fraud Detector status for the external model endpoint</p>
        pub fn set_model_endpoint_status(
            mut self,
            input: std::option::Option<crate::model::ModelEndpointStatus>,
        ) -> Self {
            self.model_endpoint_status = input;
            self
        }
        /// <p>Timestamp of when the model was last updated.</p>
        pub fn last_updated_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_updated_time = Some(input.into());
            self
        }
        /// <p>Timestamp of when the model was last updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>Timestamp of when the model was last created.</p>
        pub fn created_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_time = Some(input.into());
            self
        }
        /// <p>Timestamp of when the model was last created.</p>
        pub fn set_created_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The model ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The model ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ExternalModel`](crate::model::ExternalModel)
        pub fn build(self) -> crate::model::ExternalModel {
            crate::model::ExternalModel {
                model_endpoint: self.model_endpoint,
                model_source: self.model_source,
                invoke_model_endpoint_role_arn: self.invoke_model_endpoint_role_arn,
                input_configuration: self.input_configuration,
                output_configuration: self.output_configuration,
                model_endpoint_status: self.model_endpoint_status,
                last_updated_time: self.last_updated_time,
                created_time: self.created_time,
                arn: self.arn,
            }
        }
    }
}
impl ExternalModel {
    /// Creates a new builder-style object to manufacture [`ExternalModel`](crate::model::ExternalModel)
    pub fn builder() -> crate::model::external_model::Builder {
        crate::model::external_model::Builder::default()
    }
}

/// <p>The event type details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventType {
    /// <p>The event type name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The event type description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The event type event variables.</p>
    pub event_variables: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The event type labels.</p>
    pub labels: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The event type entity types.</p>
    pub entity_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If <code>Enabled</code>, Amazon Fraud Detector stores event data when you generate a prediction and uses that data to update calculated variables in near real-time. Amazon Fraud Detector uses this data, known as <code>INGESTED_EVENTS</code>, to train your model and improve fraud predictions.</p>
    pub event_ingestion: std::option::Option<crate::model::EventIngestion>,
    /// <p>Data about the stored events.</p>
    pub ingested_event_statistics: std::option::Option<crate::model::IngestedEventStatistics>,
    /// <p>Timestamp of when the event type was last updated.</p>
    pub last_updated_time: std::option::Option<std::string::String>,
    /// <p>Timestamp of when the event type was created.</p>
    pub created_time: std::option::Option<std::string::String>,
    /// <p>The entity type ARN.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl EventType {
    /// <p>The event type name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The event type description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The event type event variables.</p>
    pub fn event_variables(&self) -> std::option::Option<&[std::string::String]> {
        self.event_variables.as_deref()
    }
    /// <p>The event type labels.</p>
    pub fn labels(&self) -> std::option::Option<&[std::string::String]> {
        self.labels.as_deref()
    }
    /// <p>The event type entity types.</p>
    pub fn entity_types(&self) -> std::option::Option<&[std::string::String]> {
        self.entity_types.as_deref()
    }
    /// <p>If <code>Enabled</code>, Amazon Fraud Detector stores event data when you generate a prediction and uses that data to update calculated variables in near real-time. Amazon Fraud Detector uses this data, known as <code>INGESTED_EVENTS</code>, to train your model and improve fraud predictions.</p>
    pub fn event_ingestion(&self) -> std::option::Option<&crate::model::EventIngestion> {
        self.event_ingestion.as_ref()
    }
    /// <p>Data about the stored events.</p>
    pub fn ingested_event_statistics(
        &self,
    ) -> std::option::Option<&crate::model::IngestedEventStatistics> {
        self.ingested_event_statistics.as_ref()
    }
    /// <p>Timestamp of when the event type was last updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&str> {
        self.last_updated_time.as_deref()
    }
    /// <p>Timestamp of when the event type was created.</p>
    pub fn created_time(&self) -> std::option::Option<&str> {
        self.created_time.as_deref()
    }
    /// <p>The entity type ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for EventType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventType");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("event_variables", &self.event_variables);
        formatter.field("labels", &self.labels);
        formatter.field("entity_types", &self.entity_types);
        formatter.field("event_ingestion", &self.event_ingestion);
        formatter.field("ingested_event_statistics", &self.ingested_event_statistics);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("created_time", &self.created_time);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`EventType`](crate::model::EventType)
pub mod event_type {
    /// A builder for [`EventType`](crate::model::EventType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) event_variables: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) labels: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) entity_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) event_ingestion: std::option::Option<crate::model::EventIngestion>,
        pub(crate) ingested_event_statistics:
            std::option::Option<crate::model::IngestedEventStatistics>,
        pub(crate) last_updated_time: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The event type name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The event type name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The event type description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The event type description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `event_variables`.
        ///
        /// To override the contents of this collection use [`set_event_variables`](Self::set_event_variables).
        ///
        /// <p>The event type event variables.</p>
        pub fn event_variables(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_variables.unwrap_or_default();
            v.push(input.into());
            self.event_variables = Some(v);
            self
        }
        /// <p>The event type event variables.</p>
        pub fn set_event_variables(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_variables = input;
            self
        }
        /// Appends an item to `labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// <p>The event type labels.</p>
        pub fn labels(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.labels.unwrap_or_default();
            v.push(input.into());
            self.labels = Some(v);
            self
        }
        /// <p>The event type labels.</p>
        pub fn set_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.labels = input;
            self
        }
        /// Appends an item to `entity_types`.
        ///
        /// To override the contents of this collection use [`set_entity_types`](Self::set_entity_types).
        ///
        /// <p>The event type entity types.</p>
        pub fn entity_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.entity_types.unwrap_or_default();
            v.push(input.into());
            self.entity_types = Some(v);
            self
        }
        /// <p>The event type entity types.</p>
        pub fn set_entity_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.entity_types = input;
            self
        }
        /// <p>If <code>Enabled</code>, Amazon Fraud Detector stores event data when you generate a prediction and uses that data to update calculated variables in near real-time. Amazon Fraud Detector uses this data, known as <code>INGESTED_EVENTS</code>, to train your model and improve fraud predictions.</p>
        pub fn event_ingestion(mut self, input: crate::model::EventIngestion) -> Self {
            self.event_ingestion = Some(input);
            self
        }
        /// <p>If <code>Enabled</code>, Amazon Fraud Detector stores event data when you generate a prediction and uses that data to update calculated variables in near real-time. Amazon Fraud Detector uses this data, known as <code>INGESTED_EVENTS</code>, to train your model and improve fraud predictions.</p>
        pub fn set_event_ingestion(
            mut self,
            input: std::option::Option<crate::model::EventIngestion>,
        ) -> Self {
            self.event_ingestion = input;
            self
        }
        /// <p>Data about the stored events.</p>
        pub fn ingested_event_statistics(
            mut self,
            input: crate::model::IngestedEventStatistics,
        ) -> Self {
            self.ingested_event_statistics = Some(input);
            self
        }
        /// <p>Data about the stored events.</p>
        pub fn set_ingested_event_statistics(
            mut self,
            input: std::option::Option<crate::model::IngestedEventStatistics>,
        ) -> Self {
            self.ingested_event_statistics = input;
            self
        }
        /// <p>Timestamp of when the event type was last updated.</p>
        pub fn last_updated_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_updated_time = Some(input.into());
            self
        }
        /// <p>Timestamp of when the event type was last updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>Timestamp of when the event type was created.</p>
        pub fn created_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_time = Some(input.into());
            self
        }
        /// <p>Timestamp of when the event type was created.</p>
        pub fn set_created_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The entity type ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The entity type ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`EventType`](crate::model::EventType)
        pub fn build(self) -> crate::model::EventType {
            crate::model::EventType {
                name: self.name,
                description: self.description,
                event_variables: self.event_variables,
                labels: self.labels,
                entity_types: self.entity_types,
                event_ingestion: self.event_ingestion,
                ingested_event_statistics: self.ingested_event_statistics,
                last_updated_time: self.last_updated_time,
                created_time: self.created_time,
                arn: self.arn,
            }
        }
    }
}
impl EventType {
    /// Creates a new builder-style object to manufacture [`EventType`](crate::model::EventType)
    pub fn builder() -> crate::model::event_type::Builder {
        crate::model::event_type::Builder::default()
    }
}

/// <p>Data about the stored events.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IngestedEventStatistics {
    /// <p>The number of stored events.</p>
    pub number_of_events: std::option::Option<i64>,
    /// <p>The total size of the stored events.</p>
    pub event_data_size_in_bytes: std::option::Option<i64>,
    /// <p>The oldest stored event.</p>
    pub least_recent_event: std::option::Option<std::string::String>,
    /// <p>The newest stored event.</p>
    pub most_recent_event: std::option::Option<std::string::String>,
    /// <p>Timestamp of when the stored event was last updated. </p>
    pub last_updated_time: std::option::Option<std::string::String>,
}
impl IngestedEventStatistics {
    /// <p>The number of stored events.</p>
    pub fn number_of_events(&self) -> std::option::Option<i64> {
        self.number_of_events
    }
    /// <p>The total size of the stored events.</p>
    pub fn event_data_size_in_bytes(&self) -> std::option::Option<i64> {
        self.event_data_size_in_bytes
    }
    /// <p>The oldest stored event.</p>
    pub fn least_recent_event(&self) -> std::option::Option<&str> {
        self.least_recent_event.as_deref()
    }
    /// <p>The newest stored event.</p>
    pub fn most_recent_event(&self) -> std::option::Option<&str> {
        self.most_recent_event.as_deref()
    }
    /// <p>Timestamp of when the stored event was last updated. </p>
    pub fn last_updated_time(&self) -> std::option::Option<&str> {
        self.last_updated_time.as_deref()
    }
}
impl std::fmt::Debug for IngestedEventStatistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IngestedEventStatistics");
        formatter.field("number_of_events", &self.number_of_events);
        formatter.field("event_data_size_in_bytes", &self.event_data_size_in_bytes);
        formatter.field("least_recent_event", &self.least_recent_event);
        formatter.field("most_recent_event", &self.most_recent_event);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.finish()
    }
}
/// See [`IngestedEventStatistics`](crate::model::IngestedEventStatistics)
pub mod ingested_event_statistics {
    /// A builder for [`IngestedEventStatistics`](crate::model::IngestedEventStatistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) number_of_events: std::option::Option<i64>,
        pub(crate) event_data_size_in_bytes: std::option::Option<i64>,
        pub(crate) least_recent_event: std::option::Option<std::string::String>,
        pub(crate) most_recent_event: std::option::Option<std::string::String>,
        pub(crate) last_updated_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The number of stored events.</p>
        pub fn number_of_events(mut self, input: i64) -> Self {
            self.number_of_events = Some(input);
            self
        }
        /// <p>The number of stored events.</p>
        pub fn set_number_of_events(mut self, input: std::option::Option<i64>) -> Self {
            self.number_of_events = input;
            self
        }
        /// <p>The total size of the stored events.</p>
        pub fn event_data_size_in_bytes(mut self, input: i64) -> Self {
            self.event_data_size_in_bytes = Some(input);
            self
        }
        /// <p>The total size of the stored events.</p>
        pub fn set_event_data_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.event_data_size_in_bytes = input;
            self
        }
        /// <p>The oldest stored event.</p>
        pub fn least_recent_event(mut self, input: impl Into<std::string::String>) -> Self {
            self.least_recent_event = Some(input.into());
            self
        }
        /// <p>The oldest stored event.</p>
        pub fn set_least_recent_event(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.least_recent_event = input;
            self
        }
        /// <p>The newest stored event.</p>
        pub fn most_recent_event(mut self, input: impl Into<std::string::String>) -> Self {
            self.most_recent_event = Some(input.into());
            self
        }
        /// <p>The newest stored event.</p>
        pub fn set_most_recent_event(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.most_recent_event = input;
            self
        }
        /// <p>Timestamp of when the stored event was last updated. </p>
        pub fn last_updated_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_updated_time = Some(input.into());
            self
        }
        /// <p>Timestamp of when the stored event was last updated. </p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// Consumes the builder and constructs a [`IngestedEventStatistics`](crate::model::IngestedEventStatistics)
        pub fn build(self) -> crate::model::IngestedEventStatistics {
            crate::model::IngestedEventStatistics {
                number_of_events: self.number_of_events,
                event_data_size_in_bytes: self.event_data_size_in_bytes,
                least_recent_event: self.least_recent_event,
                most_recent_event: self.most_recent_event,
                last_updated_time: self.last_updated_time,
            }
        }
    }
}
impl IngestedEventStatistics {
    /// Creates a new builder-style object to manufacture [`IngestedEventStatistics`](crate::model::IngestedEventStatistics)
    pub fn builder() -> crate::model::ingested_event_statistics::Builder {
        crate::model::ingested_event_statistics::Builder::default()
    }
}

/// <p> The details of the external (Amazon Sagemaker) model evaluated for generating predictions. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EvaluatedExternalModel {
    /// <p> The endpoint of the external (Amazon Sagemaker) model. </p>
    pub model_endpoint: std::option::Option<std::string::String>,
    /// <p> Indicates whether event variables were used to generate predictions. </p>
    pub use_event_variables: std::option::Option<bool>,
    /// <p> Input variables use for generating predictions. </p>
    pub input_variables:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p> Output variables. </p>
    pub output_variables:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl EvaluatedExternalModel {
    /// <p> The endpoint of the external (Amazon Sagemaker) model. </p>
    pub fn model_endpoint(&self) -> std::option::Option<&str> {
        self.model_endpoint.as_deref()
    }
    /// <p> Indicates whether event variables were used to generate predictions. </p>
    pub fn use_event_variables(&self) -> std::option::Option<bool> {
        self.use_event_variables
    }
    /// <p> Input variables use for generating predictions. </p>
    pub fn input_variables(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.input_variables.as_ref()
    }
    /// <p> Output variables. </p>
    pub fn output_variables(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.output_variables.as_ref()
    }
}
impl std::fmt::Debug for EvaluatedExternalModel {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EvaluatedExternalModel");
        formatter.field("model_endpoint", &self.model_endpoint);
        formatter.field("use_event_variables", &self.use_event_variables);
        formatter.field("input_variables", &"*** Sensitive Data Redacted ***");
        formatter.field("output_variables", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`EvaluatedExternalModel`](crate::model::EvaluatedExternalModel)
pub mod evaluated_external_model {
    /// A builder for [`EvaluatedExternalModel`](crate::model::EvaluatedExternalModel)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_endpoint: std::option::Option<std::string::String>,
        pub(crate) use_event_variables: std::option::Option<bool>,
        pub(crate) input_variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) output_variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p> The endpoint of the external (Amazon Sagemaker) model. </p>
        pub fn model_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_endpoint = Some(input.into());
            self
        }
        /// <p> The endpoint of the external (Amazon Sagemaker) model. </p>
        pub fn set_model_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_endpoint = input;
            self
        }
        /// <p> Indicates whether event variables were used to generate predictions. </p>
        pub fn use_event_variables(mut self, input: bool) -> Self {
            self.use_event_variables = Some(input);
            self
        }
        /// <p> Indicates whether event variables were used to generate predictions. </p>
        pub fn set_use_event_variables(mut self, input: std::option::Option<bool>) -> Self {
            self.use_event_variables = input;
            self
        }
        /// Adds a key-value pair to `input_variables`.
        ///
        /// To override the contents of this collection use [`set_input_variables`](Self::set_input_variables).
        ///
        /// <p> Input variables use for generating predictions. </p>
        pub fn input_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.input_variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.input_variables = Some(hash_map);
            self
        }
        /// <p> Input variables use for generating predictions. </p>
        pub fn set_input_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.input_variables = input;
            self
        }
        /// Adds a key-value pair to `output_variables`.
        ///
        /// To override the contents of this collection use [`set_output_variables`](Self::set_output_variables).
        ///
        /// <p> Output variables. </p>
        pub fn output_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.output_variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.output_variables = Some(hash_map);
            self
        }
        /// <p> Output variables. </p>
        pub fn set_output_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.output_variables = input;
            self
        }
        /// Consumes the builder and constructs a [`EvaluatedExternalModel`](crate::model::EvaluatedExternalModel)
        pub fn build(self) -> crate::model::EvaluatedExternalModel {
            crate::model::EvaluatedExternalModel {
                model_endpoint: self.model_endpoint,
                use_event_variables: self.use_event_variables,
                input_variables: self.input_variables,
                output_variables: self.output_variables,
            }
        }
    }
}
impl EvaluatedExternalModel {
    /// Creates a new builder-style object to manufacture [`EvaluatedExternalModel`](crate::model::EvaluatedExternalModel)
    pub fn builder() -> crate::model::evaluated_external_model::Builder {
        crate::model::evaluated_external_model::Builder::default()
    }
}

/// <p> The model version evaluated for generating prediction. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EvaluatedModelVersion {
    /// <p> The model ID. </p>
    pub model_id: std::option::Option<std::string::String>,
    /// <p> The model version. </p>
    pub model_version: std::option::Option<std::string::String>,
    /// <p>The model type. </p>
    /// <p>Valid values: <code>ONLINE_FRAUD_INSIGHTS</code> | <code>TRANSACTION_FRAUD_INSIGHTS</code> </p>
    pub model_type: std::option::Option<std::string::String>,
    /// <p> Evaluations generated for the model version. </p>
    pub evaluations: std::option::Option<std::vec::Vec<crate::model::ModelVersionEvaluation>>,
}
impl EvaluatedModelVersion {
    /// <p> The model ID. </p>
    pub fn model_id(&self) -> std::option::Option<&str> {
        self.model_id.as_deref()
    }
    /// <p> The model version. </p>
    pub fn model_version(&self) -> std::option::Option<&str> {
        self.model_version.as_deref()
    }
    /// <p>The model type. </p>
    /// <p>Valid values: <code>ONLINE_FRAUD_INSIGHTS</code> | <code>TRANSACTION_FRAUD_INSIGHTS</code> </p>
    pub fn model_type(&self) -> std::option::Option<&str> {
        self.model_type.as_deref()
    }
    /// <p> Evaluations generated for the model version. </p>
    pub fn evaluations(&self) -> std::option::Option<&[crate::model::ModelVersionEvaluation]> {
        self.evaluations.as_deref()
    }
}
impl std::fmt::Debug for EvaluatedModelVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EvaluatedModelVersion");
        formatter.field("model_id", &self.model_id);
        formatter.field("model_version", &self.model_version);
        formatter.field("model_type", &self.model_type);
        formatter.field("evaluations", &self.evaluations);
        formatter.finish()
    }
}
/// See [`EvaluatedModelVersion`](crate::model::EvaluatedModelVersion)
pub mod evaluated_model_version {
    /// A builder for [`EvaluatedModelVersion`](crate::model::EvaluatedModelVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_id: std::option::Option<std::string::String>,
        pub(crate) model_version: std::option::Option<std::string::String>,
        pub(crate) model_type: std::option::Option<std::string::String>,
        pub(crate) evaluations:
            std::option::Option<std::vec::Vec<crate::model::ModelVersionEvaluation>>,
    }
    impl Builder {
        /// <p> The model ID. </p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_id = Some(input.into());
            self
        }
        /// <p> The model ID. </p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_id = input;
            self
        }
        /// <p> The model version. </p>
        pub fn model_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_version = Some(input.into());
            self
        }
        /// <p> The model version. </p>
        pub fn set_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_version = input;
            self
        }
        /// <p>The model type. </p>
        /// <p>Valid values: <code>ONLINE_FRAUD_INSIGHTS</code> | <code>TRANSACTION_FRAUD_INSIGHTS</code> </p>
        pub fn model_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_type = Some(input.into());
            self
        }
        /// <p>The model type. </p>
        /// <p>Valid values: <code>ONLINE_FRAUD_INSIGHTS</code> | <code>TRANSACTION_FRAUD_INSIGHTS</code> </p>
        pub fn set_model_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_type = input;
            self
        }
        /// Appends an item to `evaluations`.
        ///
        /// To override the contents of this collection use [`set_evaluations`](Self::set_evaluations).
        ///
        /// <p> Evaluations generated for the model version. </p>
        pub fn evaluations(mut self, input: crate::model::ModelVersionEvaluation) -> Self {
            let mut v = self.evaluations.unwrap_or_default();
            v.push(input);
            self.evaluations = Some(v);
            self
        }
        /// <p> Evaluations generated for the model version. </p>
        pub fn set_evaluations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ModelVersionEvaluation>>,
        ) -> Self {
            self.evaluations = input;
            self
        }
        /// Consumes the builder and constructs a [`EvaluatedModelVersion`](crate::model::EvaluatedModelVersion)
        pub fn build(self) -> crate::model::EvaluatedModelVersion {
            crate::model::EvaluatedModelVersion {
                model_id: self.model_id,
                model_version: self.model_version,
                model_type: self.model_type,
                evaluations: self.evaluations,
            }
        }
    }
}
impl EvaluatedModelVersion {
    /// Creates a new builder-style object to manufacture [`EvaluatedModelVersion`](crate::model::EvaluatedModelVersion)
    pub fn builder() -> crate::model::evaluated_model_version::Builder {
        crate::model::evaluated_model_version::Builder::default()
    }
}

/// <p> The model version evalutions. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModelVersionEvaluation {
    /// <p> The output variable name. </p>
    pub output_variable_name: std::option::Option<std::string::String>,
    /// <p> The evaluation score generated for the model version. </p>
    pub evaluation_score: std::option::Option<std::string::String>,
    /// <p> The prediction explanations generated for the model version. </p>
    pub prediction_explanations: std::option::Option<crate::model::PredictionExplanations>,
}
impl ModelVersionEvaluation {
    /// <p> The output variable name. </p>
    pub fn output_variable_name(&self) -> std::option::Option<&str> {
        self.output_variable_name.as_deref()
    }
    /// <p> The evaluation score generated for the model version. </p>
    pub fn evaluation_score(&self) -> std::option::Option<&str> {
        self.evaluation_score.as_deref()
    }
    /// <p> The prediction explanations generated for the model version. </p>
    pub fn prediction_explanations(
        &self,
    ) -> std::option::Option<&crate::model::PredictionExplanations> {
        self.prediction_explanations.as_ref()
    }
}
impl std::fmt::Debug for ModelVersionEvaluation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModelVersionEvaluation");
        formatter.field("output_variable_name", &self.output_variable_name);
        formatter.field("evaluation_score", &self.evaluation_score);
        formatter.field("prediction_explanations", &self.prediction_explanations);
        formatter.finish()
    }
}
/// See [`ModelVersionEvaluation`](crate::model::ModelVersionEvaluation)
pub mod model_version_evaluation {
    /// A builder for [`ModelVersionEvaluation`](crate::model::ModelVersionEvaluation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) output_variable_name: std::option::Option<std::string::String>,
        pub(crate) evaluation_score: std::option::Option<std::string::String>,
        pub(crate) prediction_explanations:
            std::option::Option<crate::model::PredictionExplanations>,
    }
    impl Builder {
        /// <p> The output variable name. </p>
        pub fn output_variable_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_variable_name = Some(input.into());
            self
        }
        /// <p> The output variable name. </p>
        pub fn set_output_variable_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.output_variable_name = input;
            self
        }
        /// <p> The evaluation score generated for the model version. </p>
        pub fn evaluation_score(mut self, input: impl Into<std::string::String>) -> Self {
            self.evaluation_score = Some(input.into());
            self
        }
        /// <p> The evaluation score generated for the model version. </p>
        pub fn set_evaluation_score(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.evaluation_score = input;
            self
        }
        /// <p> The prediction explanations generated for the model version. </p>
        pub fn prediction_explanations(
            mut self,
            input: crate::model::PredictionExplanations,
        ) -> Self {
            self.prediction_explanations = Some(input);
            self
        }
        /// <p> The prediction explanations generated for the model version. </p>
        pub fn set_prediction_explanations(
            mut self,
            input: std::option::Option<crate::model::PredictionExplanations>,
        ) -> Self {
            self.prediction_explanations = input;
            self
        }
        /// Consumes the builder and constructs a [`ModelVersionEvaluation`](crate::model::ModelVersionEvaluation)
        pub fn build(self) -> crate::model::ModelVersionEvaluation {
            crate::model::ModelVersionEvaluation {
                output_variable_name: self.output_variable_name,
                evaluation_score: self.evaluation_score,
                prediction_explanations: self.prediction_explanations,
            }
        }
    }
}
impl ModelVersionEvaluation {
    /// Creates a new builder-style object to manufacture [`ModelVersionEvaluation`](crate::model::ModelVersionEvaluation)
    pub fn builder() -> crate::model::model_version_evaluation::Builder {
        crate::model::model_version_evaluation::Builder::default()
    }
}

/// <p> The prediction explanations that provide insight into how each event variable impacted the model version's fraud prediction score. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PredictionExplanations {
    /// <p> The details of the event variable's impact on the prediction score. </p>
    pub variable_impact_explanations:
        std::option::Option<std::vec::Vec<crate::model::VariableImpactExplanation>>,
}
impl PredictionExplanations {
    /// <p> The details of the event variable's impact on the prediction score. </p>
    pub fn variable_impact_explanations(
        &self,
    ) -> std::option::Option<&[crate::model::VariableImpactExplanation]> {
        self.variable_impact_explanations.as_deref()
    }
}
impl std::fmt::Debug for PredictionExplanations {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PredictionExplanations");
        formatter.field(
            "variable_impact_explanations",
            &self.variable_impact_explanations,
        );
        formatter.finish()
    }
}
/// See [`PredictionExplanations`](crate::model::PredictionExplanations)
pub mod prediction_explanations {
    /// A builder for [`PredictionExplanations`](crate::model::PredictionExplanations)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) variable_impact_explanations:
            std::option::Option<std::vec::Vec<crate::model::VariableImpactExplanation>>,
    }
    impl Builder {
        /// Appends an item to `variable_impact_explanations`.
        ///
        /// To override the contents of this collection use [`set_variable_impact_explanations`](Self::set_variable_impact_explanations).
        ///
        /// <p> The details of the event variable's impact on the prediction score. </p>
        pub fn variable_impact_explanations(
            mut self,
            input: crate::model::VariableImpactExplanation,
        ) -> Self {
            let mut v = self.variable_impact_explanations.unwrap_or_default();
            v.push(input);
            self.variable_impact_explanations = Some(v);
            self
        }
        /// <p> The details of the event variable's impact on the prediction score. </p>
        pub fn set_variable_impact_explanations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VariableImpactExplanation>>,
        ) -> Self {
            self.variable_impact_explanations = input;
            self
        }
        /// Consumes the builder and constructs a [`PredictionExplanations`](crate::model::PredictionExplanations)
        pub fn build(self) -> crate::model::PredictionExplanations {
            crate::model::PredictionExplanations {
                variable_impact_explanations: self.variable_impact_explanations,
            }
        }
    }
}
impl PredictionExplanations {
    /// Creates a new builder-style object to manufacture [`PredictionExplanations`](crate::model::PredictionExplanations)
    pub fn builder() -> crate::model::prediction_explanations::Builder {
        crate::model::prediction_explanations::Builder::default()
    }
}

/// <p> The details of the event variable's impact on the prediction score. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VariableImpactExplanation {
    /// <p> The event variable name. </p>
    pub event_variable_name: std::option::Option<std::string::String>,
    /// <p> The event variable's relative impact in terms of magnitude on the prediction scores. The relative impact values consist of a numerical rating (0-5, 5 being the highest) and direction (increased/decreased) impact of the fraud risk. </p>
    pub relative_impact: std::option::Option<std::string::String>,
    /// <p> The raw, uninterpreted value represented as log-odds of the fraud. These values are usually between -10 to +10, but range from - infinity to + infinity.</p>
    /// <ul>
    /// <li> <p>A positive value indicates that the variable drove the risk score up.</p> </li>
    /// <li> <p>A negative value indicates that the variable drove the risk score down.</p> </li>
    /// </ul>
    pub log_odds_impact: std::option::Option<f32>,
}
impl VariableImpactExplanation {
    /// <p> The event variable name. </p>
    pub fn event_variable_name(&self) -> std::option::Option<&str> {
        self.event_variable_name.as_deref()
    }
    /// <p> The event variable's relative impact in terms of magnitude on the prediction scores. The relative impact values consist of a numerical rating (0-5, 5 being the highest) and direction (increased/decreased) impact of the fraud risk. </p>
    pub fn relative_impact(&self) -> std::option::Option<&str> {
        self.relative_impact.as_deref()
    }
    /// <p> The raw, uninterpreted value represented as log-odds of the fraud. These values are usually between -10 to +10, but range from - infinity to + infinity.</p>
    /// <ul>
    /// <li> <p>A positive value indicates that the variable drove the risk score up.</p> </li>
    /// <li> <p>A negative value indicates that the variable drove the risk score down.</p> </li>
    /// </ul>
    pub fn log_odds_impact(&self) -> std::option::Option<f32> {
        self.log_odds_impact
    }
}
impl std::fmt::Debug for VariableImpactExplanation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VariableImpactExplanation");
        formatter.field("event_variable_name", &self.event_variable_name);
        formatter.field("relative_impact", &self.relative_impact);
        formatter.field("log_odds_impact", &self.log_odds_impact);
        formatter.finish()
    }
}
/// See [`VariableImpactExplanation`](crate::model::VariableImpactExplanation)
pub mod variable_impact_explanation {
    /// A builder for [`VariableImpactExplanation`](crate::model::VariableImpactExplanation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_variable_name: std::option::Option<std::string::String>,
        pub(crate) relative_impact: std::option::Option<std::string::String>,
        pub(crate) log_odds_impact: std::option::Option<f32>,
    }
    impl Builder {
        /// <p> The event variable name. </p>
        pub fn event_variable_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_variable_name = Some(input.into());
            self
        }
        /// <p> The event variable name. </p>
        pub fn set_event_variable_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_variable_name = input;
            self
        }
        /// <p> The event variable's relative impact in terms of magnitude on the prediction scores. The relative impact values consist of a numerical rating (0-5, 5 being the highest) and direction (increased/decreased) impact of the fraud risk. </p>
        pub fn relative_impact(mut self, input: impl Into<std::string::String>) -> Self {
            self.relative_impact = Some(input.into());
            self
        }
        /// <p> The event variable's relative impact in terms of magnitude on the prediction scores. The relative impact values consist of a numerical rating (0-5, 5 being the highest) and direction (increased/decreased) impact of the fraud risk. </p>
        pub fn set_relative_impact(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.relative_impact = input;
            self
        }
        /// <p> The raw, uninterpreted value represented as log-odds of the fraud. These values are usually between -10 to +10, but range from - infinity to + infinity.</p>
        /// <ul>
        /// <li> <p>A positive value indicates that the variable drove the risk score up.</p> </li>
        /// <li> <p>A negative value indicates that the variable drove the risk score down.</p> </li>
        /// </ul>
        pub fn log_odds_impact(mut self, input: f32) -> Self {
            self.log_odds_impact = Some(input);
            self
        }
        /// <p> The raw, uninterpreted value represented as log-odds of the fraud. These values are usually between -10 to +10, but range from - infinity to + infinity.</p>
        /// <ul>
        /// <li> <p>A positive value indicates that the variable drove the risk score up.</p> </li>
        /// <li> <p>A negative value indicates that the variable drove the risk score down.</p> </li>
        /// </ul>
        pub fn set_log_odds_impact(mut self, input: std::option::Option<f32>) -> Self {
            self.log_odds_impact = input;
            self
        }
        /// Consumes the builder and constructs a [`VariableImpactExplanation`](crate::model::VariableImpactExplanation)
        pub fn build(self) -> crate::model::VariableImpactExplanation {
            crate::model::VariableImpactExplanation {
                event_variable_name: self.event_variable_name,
                relative_impact: self.relative_impact,
                log_odds_impact: self.log_odds_impact,
            }
        }
    }
}
impl VariableImpactExplanation {
    /// Creates a new builder-style object to manufacture [`VariableImpactExplanation`](crate::model::VariableImpactExplanation)
    pub fn builder() -> crate::model::variable_impact_explanation::Builder {
        crate::model::variable_impact_explanation::Builder::default()
    }
}

/// <p> The details of the rule used for evaluating variable values. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EvaluatedRule {
    /// <p> The rule ID. </p>
    pub rule_id: std::option::Option<std::string::String>,
    /// <p> The rule version. </p>
    pub rule_version: std::option::Option<std::string::String>,
    /// <p> The rule expression. </p>
    pub expression: std::option::Option<std::string::String>,
    /// <p> The rule expression value. </p>
    pub expression_with_values: std::option::Option<std::string::String>,
    /// <p> The rule outcome. </p>
    pub outcomes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> Indicates whether the rule was evaluated. </p>
    pub evaluated: std::option::Option<bool>,
    /// <p> Indicates whether the rule matched. </p>
    pub matched: std::option::Option<bool>,
}
impl EvaluatedRule {
    /// <p> The rule ID. </p>
    pub fn rule_id(&self) -> std::option::Option<&str> {
        self.rule_id.as_deref()
    }
    /// <p> The rule version. </p>
    pub fn rule_version(&self) -> std::option::Option<&str> {
        self.rule_version.as_deref()
    }
    /// <p> The rule expression. </p>
    pub fn expression(&self) -> std::option::Option<&str> {
        self.expression.as_deref()
    }
    /// <p> The rule expression value. </p>
    pub fn expression_with_values(&self) -> std::option::Option<&str> {
        self.expression_with_values.as_deref()
    }
    /// <p> The rule outcome. </p>
    pub fn outcomes(&self) -> std::option::Option<&[std::string::String]> {
        self.outcomes.as_deref()
    }
    /// <p> Indicates whether the rule was evaluated. </p>
    pub fn evaluated(&self) -> std::option::Option<bool> {
        self.evaluated
    }
    /// <p> Indicates whether the rule matched. </p>
    pub fn matched(&self) -> std::option::Option<bool> {
        self.matched
    }
}
impl std::fmt::Debug for EvaluatedRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EvaluatedRule");
        formatter.field("rule_id", &self.rule_id);
        formatter.field("rule_version", &self.rule_version);
        formatter.field("expression", &"*** Sensitive Data Redacted ***");
        formatter.field("expression_with_values", &"*** Sensitive Data Redacted ***");
        formatter.field("outcomes", &self.outcomes);
        formatter.field("evaluated", &self.evaluated);
        formatter.field("matched", &self.matched);
        formatter.finish()
    }
}
/// See [`EvaluatedRule`](crate::model::EvaluatedRule)
pub mod evaluated_rule {
    /// A builder for [`EvaluatedRule`](crate::model::EvaluatedRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_id: std::option::Option<std::string::String>,
        pub(crate) rule_version: std::option::Option<std::string::String>,
        pub(crate) expression: std::option::Option<std::string::String>,
        pub(crate) expression_with_values: std::option::Option<std::string::String>,
        pub(crate) outcomes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) evaluated: std::option::Option<bool>,
        pub(crate) matched: std::option::Option<bool>,
    }
    impl Builder {
        /// <p> The rule ID. </p>
        pub fn rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_id = Some(input.into());
            self
        }
        /// <p> The rule ID. </p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_id = input;
            self
        }
        /// <p> The rule version. </p>
        pub fn rule_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_version = Some(input.into());
            self
        }
        /// <p> The rule version. </p>
        pub fn set_rule_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_version = input;
            self
        }
        /// <p> The rule expression. </p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.expression = Some(input.into());
            self
        }
        /// <p> The rule expression. </p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.expression = input;
            self
        }
        /// <p> The rule expression value. </p>
        pub fn expression_with_values(mut self, input: impl Into<std::string::String>) -> Self {
            self.expression_with_values = Some(input.into());
            self
        }
        /// <p> The rule expression value. </p>
        pub fn set_expression_with_values(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expression_with_values = input;
            self
        }
        /// Appends an item to `outcomes`.
        ///
        /// To override the contents of this collection use [`set_outcomes`](Self::set_outcomes).
        ///
        /// <p> The rule outcome. </p>
        pub fn outcomes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.outcomes.unwrap_or_default();
            v.push(input.into());
            self.outcomes = Some(v);
            self
        }
        /// <p> The rule outcome. </p>
        pub fn set_outcomes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.outcomes = input;
            self
        }
        /// <p> Indicates whether the rule was evaluated. </p>
        pub fn evaluated(mut self, input: bool) -> Self {
            self.evaluated = Some(input);
            self
        }
        /// <p> Indicates whether the rule was evaluated. </p>
        pub fn set_evaluated(mut self, input: std::option::Option<bool>) -> Self {
            self.evaluated = input;
            self
        }
        /// <p> Indicates whether the rule matched. </p>
        pub fn matched(mut self, input: bool) -> Self {
            self.matched = Some(input);
            self
        }
        /// <p> Indicates whether the rule matched. </p>
        pub fn set_matched(mut self, input: std::option::Option<bool>) -> Self {
            self.matched = input;
            self
        }
        /// Consumes the builder and constructs a [`EvaluatedRule`](crate::model::EvaluatedRule)
        pub fn build(self) -> crate::model::EvaluatedRule {
            crate::model::EvaluatedRule {
                rule_id: self.rule_id,
                rule_version: self.rule_version,
                expression: self.expression,
                expression_with_values: self.expression_with_values,
                outcomes: self.outcomes,
                evaluated: self.evaluated,
                matched: self.matched,
            }
        }
    }
}
impl EvaluatedRule {
    /// Creates a new builder-style object to manufacture [`EvaluatedRule`](crate::model::EvaluatedRule)
    pub fn builder() -> crate::model::evaluated_rule::Builder {
        crate::model::evaluated_rule::Builder::default()
    }
}

/// <p> Information about the summary of an event variable that was evaluated for generating prediction. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventVariableSummary {
    /// <p> The event variable name. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The value of the event variable. </p>
    pub value: std::option::Option<std::string::String>,
    /// <p> The event variable source. </p>
    pub source: std::option::Option<std::string::String>,
}
impl EventVariableSummary {
    /// <p> The event variable name. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> The value of the event variable. </p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
    /// <p> The event variable source. </p>
    pub fn source(&self) -> std::option::Option<&str> {
        self.source.as_deref()
    }
}
impl std::fmt::Debug for EventVariableSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventVariableSummary");
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("value", &"*** Sensitive Data Redacted ***");
        formatter.field("source", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`EventVariableSummary`](crate::model::EventVariableSummary)
pub mod event_variable_summary {
    /// A builder for [`EventVariableSummary`](crate::model::EventVariableSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The event variable name. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The event variable name. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The value of the event variable. </p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p> The value of the event variable. </p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p> The event variable source. </p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p> The event variable source. </p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// Consumes the builder and constructs a [`EventVariableSummary`](crate::model::EventVariableSummary)
        pub fn build(self) -> crate::model::EventVariableSummary {
            crate::model::EventVariableSummary {
                name: self.name,
                value: self.value,
                source: self.source,
            }
        }
    }
}
impl EventVariableSummary {
    /// Creates a new builder-style object to manufacture [`EventVariableSummary`](crate::model::EventVariableSummary)
    pub fn builder() -> crate::model::event_variable_summary::Builder {
        crate::model::event_variable_summary::Builder::default()
    }
}

/// <p>The fraud prediction scores from Amazon SageMaker model.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExternalModelOutputs {
    /// <p>The Amazon SageMaker model.</p>
    pub external_model: std::option::Option<crate::model::ExternalModelSummary>,
    /// <p>The fraud prediction scores from Amazon SageMaker model.</p>
    pub outputs:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ExternalModelOutputs {
    /// <p>The Amazon SageMaker model.</p>
    pub fn external_model(&self) -> std::option::Option<&crate::model::ExternalModelSummary> {
        self.external_model.as_ref()
    }
    /// <p>The fraud prediction scores from Amazon SageMaker model.</p>
    pub fn outputs(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.outputs.as_ref()
    }
}
impl std::fmt::Debug for ExternalModelOutputs {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExternalModelOutputs");
        formatter.field("external_model", &self.external_model);
        formatter.field("outputs", &self.outputs);
        formatter.finish()
    }
}
/// See [`ExternalModelOutputs`](crate::model::ExternalModelOutputs)
pub mod external_model_outputs {
    /// A builder for [`ExternalModelOutputs`](crate::model::ExternalModelOutputs)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) external_model: std::option::Option<crate::model::ExternalModelSummary>,
        pub(crate) outputs: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon SageMaker model.</p>
        pub fn external_model(mut self, input: crate::model::ExternalModelSummary) -> Self {
            self.external_model = Some(input);
            self
        }
        /// <p>The Amazon SageMaker model.</p>
        pub fn set_external_model(
            mut self,
            input: std::option::Option<crate::model::ExternalModelSummary>,
        ) -> Self {
            self.external_model = input;
            self
        }
        /// Adds a key-value pair to `outputs`.
        ///
        /// To override the contents of this collection use [`set_outputs`](Self::set_outputs).
        ///
        /// <p>The fraud prediction scores from Amazon SageMaker model.</p>
        pub fn outputs(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.outputs.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.outputs = Some(hash_map);
            self
        }
        /// <p>The fraud prediction scores from Amazon SageMaker model.</p>
        pub fn set_outputs(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.outputs = input;
            self
        }
        /// Consumes the builder and constructs a [`ExternalModelOutputs`](crate::model::ExternalModelOutputs)
        pub fn build(self) -> crate::model::ExternalModelOutputs {
            crate::model::ExternalModelOutputs {
                external_model: self.external_model,
                outputs: self.outputs,
            }
        }
    }
}
impl ExternalModelOutputs {
    /// Creates a new builder-style object to manufacture [`ExternalModelOutputs`](crate::model::ExternalModelOutputs)
    pub fn builder() -> crate::model::external_model_outputs::Builder {
        crate::model::external_model_outputs::Builder::default()
    }
}

/// <p>The Amazon SageMaker model.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExternalModelSummary {
    /// <p>The endpoint of the Amazon SageMaker model.</p>
    pub model_endpoint: std::option::Option<std::string::String>,
    /// <p>The source of the model.</p>
    pub model_source: std::option::Option<crate::model::ModelSource>,
}
impl ExternalModelSummary {
    /// <p>The endpoint of the Amazon SageMaker model.</p>
    pub fn model_endpoint(&self) -> std::option::Option<&str> {
        self.model_endpoint.as_deref()
    }
    /// <p>The source of the model.</p>
    pub fn model_source(&self) -> std::option::Option<&crate::model::ModelSource> {
        self.model_source.as_ref()
    }
}
impl std::fmt::Debug for ExternalModelSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExternalModelSummary");
        formatter.field("model_endpoint", &self.model_endpoint);
        formatter.field("model_source", &self.model_source);
        formatter.finish()
    }
}
/// See [`ExternalModelSummary`](crate::model::ExternalModelSummary)
pub mod external_model_summary {
    /// A builder for [`ExternalModelSummary`](crate::model::ExternalModelSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_endpoint: std::option::Option<std::string::String>,
        pub(crate) model_source: std::option::Option<crate::model::ModelSource>,
    }
    impl Builder {
        /// <p>The endpoint of the Amazon SageMaker model.</p>
        pub fn model_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_endpoint = Some(input.into());
            self
        }
        /// <p>The endpoint of the Amazon SageMaker model.</p>
        pub fn set_model_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_endpoint = input;
            self
        }
        /// <p>The source of the model.</p>
        pub fn model_source(mut self, input: crate::model::ModelSource) -> Self {
            self.model_source = Some(input);
            self
        }
        /// <p>The source of the model.</p>
        pub fn set_model_source(
            mut self,
            input: std::option::Option<crate::model::ModelSource>,
        ) -> Self {
            self.model_source = input;
            self
        }
        /// Consumes the builder and constructs a [`ExternalModelSummary`](crate::model::ExternalModelSummary)
        pub fn build(self) -> crate::model::ExternalModelSummary {
            crate::model::ExternalModelSummary {
                model_endpoint: self.model_endpoint,
                model_source: self.model_source,
            }
        }
    }
}
impl ExternalModelSummary {
    /// Creates a new builder-style object to manufacture [`ExternalModelSummary`](crate::model::ExternalModelSummary)
    pub fn builder() -> crate::model::external_model_summary::Builder {
        crate::model::external_model_summary::Builder::default()
    }
}

/// <p>The rule results.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RuleResult {
    /// <p>The rule ID that was matched, based on the rule execution mode.</p>
    pub rule_id: std::option::Option<std::string::String>,
    /// <p>The outcomes of the matched rule, based on the rule execution mode.</p>
    pub outcomes: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl RuleResult {
    /// <p>The rule ID that was matched, based on the rule execution mode.</p>
    pub fn rule_id(&self) -> std::option::Option<&str> {
        self.rule_id.as_deref()
    }
    /// <p>The outcomes of the matched rule, based on the rule execution mode.</p>
    pub fn outcomes(&self) -> std::option::Option<&[std::string::String]> {
        self.outcomes.as_deref()
    }
}
impl std::fmt::Debug for RuleResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RuleResult");
        formatter.field("rule_id", &self.rule_id);
        formatter.field("outcomes", &self.outcomes);
        formatter.finish()
    }
}
/// See [`RuleResult`](crate::model::RuleResult)
pub mod rule_result {
    /// A builder for [`RuleResult`](crate::model::RuleResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_id: std::option::Option<std::string::String>,
        pub(crate) outcomes: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The rule ID that was matched, based on the rule execution mode.</p>
        pub fn rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_id = Some(input.into());
            self
        }
        /// <p>The rule ID that was matched, based on the rule execution mode.</p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_id = input;
            self
        }
        /// Appends an item to `outcomes`.
        ///
        /// To override the contents of this collection use [`set_outcomes`](Self::set_outcomes).
        ///
        /// <p>The outcomes of the matched rule, based on the rule execution mode.</p>
        pub fn outcomes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.outcomes.unwrap_or_default();
            v.push(input.into());
            self.outcomes = Some(v);
            self
        }
        /// <p>The outcomes of the matched rule, based on the rule execution mode.</p>
        pub fn set_outcomes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.outcomes = input;
            self
        }
        /// Consumes the builder and constructs a [`RuleResult`](crate::model::RuleResult)
        pub fn build(self) -> crate::model::RuleResult {
            crate::model::RuleResult {
                rule_id: self.rule_id,
                outcomes: self.outcomes,
            }
        }
    }
}
impl RuleResult {
    /// Creates a new builder-style object to manufacture [`RuleResult`](crate::model::RuleResult)
    pub fn builder() -> crate::model::rule_result::Builder {
        crate::model::rule_result::Builder::default()
    }
}

/// <p>The fraud prediction scores.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModelScores {
    /// <p>The model version.</p>
    pub model_version: std::option::Option<crate::model::ModelVersion>,
    /// <p>The model's fraud prediction scores.</p>
    pub scores: std::option::Option<std::collections::HashMap<std::string::String, f32>>,
}
impl ModelScores {
    /// <p>The model version.</p>
    pub fn model_version(&self) -> std::option::Option<&crate::model::ModelVersion> {
        self.model_version.as_ref()
    }
    /// <p>The model's fraud prediction scores.</p>
    pub fn scores(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, f32>> {
        self.scores.as_ref()
    }
}
impl std::fmt::Debug for ModelScores {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModelScores");
        formatter.field("model_version", &self.model_version);
        formatter.field("scores", &self.scores);
        formatter.finish()
    }
}
/// See [`ModelScores`](crate::model::ModelScores)
pub mod model_scores {
    /// A builder for [`ModelScores`](crate::model::ModelScores)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_version: std::option::Option<crate::model::ModelVersion>,
        pub(crate) scores: std::option::Option<std::collections::HashMap<std::string::String, f32>>,
    }
    impl Builder {
        /// <p>The model version.</p>
        pub fn model_version(mut self, input: crate::model::ModelVersion) -> Self {
            self.model_version = Some(input);
            self
        }
        /// <p>The model version.</p>
        pub fn set_model_version(
            mut self,
            input: std::option::Option<crate::model::ModelVersion>,
        ) -> Self {
            self.model_version = input;
            self
        }
        /// Adds a key-value pair to `scores`.
        ///
        /// To override the contents of this collection use [`set_scores`](Self::set_scores).
        ///
        /// <p>The model's fraud prediction scores.</p>
        pub fn scores(mut self, k: impl Into<std::string::String>, v: f32) -> Self {
            let mut hash_map = self.scores.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.scores = Some(hash_map);
            self
        }
        /// <p>The model's fraud prediction scores.</p>
        pub fn set_scores(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, f32>>,
        ) -> Self {
            self.scores = input;
            self
        }
        /// Consumes the builder and constructs a [`ModelScores`](crate::model::ModelScores)
        pub fn build(self) -> crate::model::ModelScores {
            crate::model::ModelScores {
                model_version: self.model_version,
                scores: self.scores,
            }
        }
    }
}
impl ModelScores {
    /// Creates a new builder-style object to manufacture [`ModelScores`](crate::model::ModelScores)
    pub fn builder() -> crate::model::model_scores::Builder {
        crate::model::model_scores::Builder::default()
    }
}

/// <p>A pre-formed Amazon SageMaker model input you can include if your detector version includes an imported Amazon SageMaker model endpoint with pass-through input configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModelEndpointDataBlob {
    /// <p>The byte buffer of the Amazon SageMaker model endpoint input data blob.</p>
    pub byte_buffer: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The content type of the Amazon SageMaker model endpoint input data blob. </p>
    pub content_type: std::option::Option<std::string::String>,
}
impl ModelEndpointDataBlob {
    /// <p>The byte buffer of the Amazon SageMaker model endpoint input data blob.</p>
    pub fn byte_buffer(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.byte_buffer.as_ref()
    }
    /// <p>The content type of the Amazon SageMaker model endpoint input data blob. </p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
}
impl std::fmt::Debug for ModelEndpointDataBlob {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModelEndpointDataBlob");
        formatter.field("byte_buffer", &self.byte_buffer);
        formatter.field("content_type", &self.content_type);
        formatter.finish()
    }
}
/// See [`ModelEndpointDataBlob`](crate::model::ModelEndpointDataBlob)
pub mod model_endpoint_data_blob {
    /// A builder for [`ModelEndpointDataBlob`](crate::model::ModelEndpointDataBlob)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) byte_buffer: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) content_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The byte buffer of the Amazon SageMaker model endpoint input data blob.</p>
        pub fn byte_buffer(mut self, input: aws_smithy_types::Blob) -> Self {
            self.byte_buffer = Some(input);
            self
        }
        /// <p>The byte buffer of the Amazon SageMaker model endpoint input data blob.</p>
        pub fn set_byte_buffer(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.byte_buffer = input;
            self
        }
        /// <p>The content type of the Amazon SageMaker model endpoint input data blob. </p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The content type of the Amazon SageMaker model endpoint input data blob. </p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ModelEndpointDataBlob`](crate::model::ModelEndpointDataBlob)
        pub fn build(self) -> crate::model::ModelEndpointDataBlob {
            crate::model::ModelEndpointDataBlob {
                byte_buffer: self.byte_buffer,
                content_type: self.content_type,
            }
        }
    }
}
impl ModelEndpointDataBlob {
    /// Creates a new builder-style object to manufacture [`ModelEndpointDataBlob`](crate::model::ModelEndpointDataBlob)
    pub fn builder() -> crate::model::model_endpoint_data_blob::Builder {
        crate::model::model_endpoint_data_blob::Builder::default()
    }
}

/// <p>The event details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Event {
    /// <p>The event ID.</p>
    pub event_id: std::option::Option<std::string::String>,
    /// <p>The event type.</p>
    pub event_type_name: std::option::Option<std::string::String>,
    /// <p>The timestamp that defines when the event under evaluation occurred. The timestamp must be specified using ISO 8601 standard in UTC.</p>
    pub event_timestamp: std::option::Option<std::string::String>,
    /// <p>Names of the event type's variables you defined in Amazon Fraud Detector to represent data elements and their corresponding values for the event you are sending for evaluation.</p>
    pub event_variables:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The label associated with the event.</p>
    pub current_label: std::option::Option<std::string::String>,
    /// <p>The timestamp associated with the label to update. The timestamp must be specified using ISO 8601 standard in UTC.</p>
    pub label_timestamp: std::option::Option<std::string::String>,
    /// <p>The event entities.</p>
    pub entities: std::option::Option<std::vec::Vec<crate::model::Entity>>,
}
impl Event {
    /// <p>The event ID.</p>
    pub fn event_id(&self) -> std::option::Option<&str> {
        self.event_id.as_deref()
    }
    /// <p>The event type.</p>
    pub fn event_type_name(&self) -> std::option::Option<&str> {
        self.event_type_name.as_deref()
    }
    /// <p>The timestamp that defines when the event under evaluation occurred. The timestamp must be specified using ISO 8601 standard in UTC.</p>
    pub fn event_timestamp(&self) -> std::option::Option<&str> {
        self.event_timestamp.as_deref()
    }
    /// <p>Names of the event type's variables you defined in Amazon Fraud Detector to represent data elements and their corresponding values for the event you are sending for evaluation.</p>
    pub fn event_variables(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.event_variables.as_ref()
    }
    /// <p>The label associated with the event.</p>
    pub fn current_label(&self) -> std::option::Option<&str> {
        self.current_label.as_deref()
    }
    /// <p>The timestamp associated with the label to update. The timestamp must be specified using ISO 8601 standard in UTC.</p>
    pub fn label_timestamp(&self) -> std::option::Option<&str> {
        self.label_timestamp.as_deref()
    }
    /// <p>The event entities.</p>
    pub fn entities(&self) -> std::option::Option<&[crate::model::Entity]> {
        self.entities.as_deref()
    }
}
impl std::fmt::Debug for Event {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Event");
        formatter.field("event_id", &self.event_id);
        formatter.field("event_type_name", &self.event_type_name);
        formatter.field("event_timestamp", &self.event_timestamp);
        formatter.field("event_variables", &self.event_variables);
        formatter.field("current_label", &self.current_label);
        formatter.field("label_timestamp", &self.label_timestamp);
        formatter.field("entities", &self.entities);
        formatter.finish()
    }
}
/// See [`Event`](crate::model::Event)
pub mod event {
    /// A builder for [`Event`](crate::model::Event)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_id: std::option::Option<std::string::String>,
        pub(crate) event_type_name: std::option::Option<std::string::String>,
        pub(crate) event_timestamp: std::option::Option<std::string::String>,
        pub(crate) event_variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) current_label: std::option::Option<std::string::String>,
        pub(crate) label_timestamp: std::option::Option<std::string::String>,
        pub(crate) entities: std::option::Option<std::vec::Vec<crate::model::Entity>>,
    }
    impl Builder {
        /// <p>The event ID.</p>
        pub fn event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_id = Some(input.into());
            self
        }
        /// <p>The event ID.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_id = input;
            self
        }
        /// <p>The event type.</p>
        pub fn event_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_type_name = Some(input.into());
            self
        }
        /// <p>The event type.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_type_name = input;
            self
        }
        /// <p>The timestamp that defines when the event under evaluation occurred. The timestamp must be specified using ISO 8601 standard in UTC.</p>
        pub fn event_timestamp(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_timestamp = Some(input.into());
            self
        }
        /// <p>The timestamp that defines when the event under evaluation occurred. The timestamp must be specified using ISO 8601 standard in UTC.</p>
        pub fn set_event_timestamp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_timestamp = input;
            self
        }
        /// Adds a key-value pair to `event_variables`.
        ///
        /// To override the contents of this collection use [`set_event_variables`](Self::set_event_variables).
        ///
        /// <p>Names of the event type's variables you defined in Amazon Fraud Detector to represent data elements and their corresponding values for the event you are sending for evaluation.</p>
        pub fn event_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.event_variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.event_variables = Some(hash_map);
            self
        }
        /// <p>Names of the event type's variables you defined in Amazon Fraud Detector to represent data elements and their corresponding values for the event you are sending for evaluation.</p>
        pub fn set_event_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.event_variables = input;
            self
        }
        /// <p>The label associated with the event.</p>
        pub fn current_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.current_label = Some(input.into());
            self
        }
        /// <p>The label associated with the event.</p>
        pub fn set_current_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_label = input;
            self
        }
        /// <p>The timestamp associated with the label to update. The timestamp must be specified using ISO 8601 standard in UTC.</p>
        pub fn label_timestamp(mut self, input: impl Into<std::string::String>) -> Self {
            self.label_timestamp = Some(input.into());
            self
        }
        /// <p>The timestamp associated with the label to update. The timestamp must be specified using ISO 8601 standard in UTC.</p>
        pub fn set_label_timestamp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.label_timestamp = input;
            self
        }
        /// Appends an item to `entities`.
        ///
        /// To override the contents of this collection use [`set_entities`](Self::set_entities).
        ///
        /// <p>The event entities.</p>
        pub fn entities(mut self, input: crate::model::Entity) -> Self {
            let mut v = self.entities.unwrap_or_default();
            v.push(input);
            self.entities = Some(v);
            self
        }
        /// <p>The event entities.</p>
        pub fn set_entities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Entity>>,
        ) -> Self {
            self.entities = input;
            self
        }
        /// Consumes the builder and constructs a [`Event`](crate::model::Event)
        pub fn build(self) -> crate::model::Event {
            crate::model::Event {
                event_id: self.event_id,
                event_type_name: self.event_type_name,
                event_timestamp: self.event_timestamp,
                event_variables: self.event_variables,
                current_label: self.current_label,
                label_timestamp: self.label_timestamp,
                entities: self.entities,
            }
        }
    }
}
impl Event {
    /// Creates a new builder-style object to manufacture [`Event`](crate::model::Event)
    pub fn builder() -> crate::model::event::Builder {
        crate::model::event::Builder::default()
    }
}

/// <p>The entity type details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntityType {
    /// <p>The entity type name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The entity type description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Timestamp of when the entity type was last updated.</p>
    pub last_updated_time: std::option::Option<std::string::String>,
    /// <p>Timestamp of when the entity type was created.</p>
    pub created_time: std::option::Option<std::string::String>,
    /// <p>The entity type ARN.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl EntityType {
    /// <p>The entity type name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The entity type description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Timestamp of when the entity type was last updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&str> {
        self.last_updated_time.as_deref()
    }
    /// <p>Timestamp of when the entity type was created.</p>
    pub fn created_time(&self) -> std::option::Option<&str> {
        self.created_time.as_deref()
    }
    /// <p>The entity type ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for EntityType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntityType");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("created_time", &self.created_time);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`EntityType`](crate::model::EntityType)
pub mod entity_type {
    /// A builder for [`EntityType`](crate::model::EntityType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) last_updated_time: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The entity type name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The entity type name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The entity type description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The entity type description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Timestamp of when the entity type was last updated.</p>
        pub fn last_updated_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_updated_time = Some(input.into());
            self
        }
        /// <p>Timestamp of when the entity type was last updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>Timestamp of when the entity type was created.</p>
        pub fn created_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_time = Some(input.into());
            self
        }
        /// <p>Timestamp of when the entity type was created.</p>
        pub fn set_created_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The entity type ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The entity type ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`EntityType`](crate::model::EntityType)
        pub fn build(self) -> crate::model::EntityType {
            crate::model::EntityType {
                name: self.name,
                description: self.description,
                last_updated_time: self.last_updated_time,
                created_time: self.created_time,
                arn: self.arn,
            }
        }
    }
}
impl EntityType {
    /// Creates a new builder-style object to manufacture [`EntityType`](crate::model::EntityType)
    pub fn builder() -> crate::model::entity_type::Builder {
        crate::model::entity_type::Builder::default()
    }
}

/// <p>The detector.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Detector {
    /// <p>The detector ID.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The detector description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The name of the event type.</p>
    pub event_type_name: std::option::Option<std::string::String>,
    /// <p>Timestamp of when the detector was last updated.</p>
    pub last_updated_time: std::option::Option<std::string::String>,
    /// <p>Timestamp of when the detector was created.</p>
    pub created_time: std::option::Option<std::string::String>,
    /// <p>The detector ARN.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl Detector {
    /// <p>The detector ID.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>The detector description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The name of the event type.</p>
    pub fn event_type_name(&self) -> std::option::Option<&str> {
        self.event_type_name.as_deref()
    }
    /// <p>Timestamp of when the detector was last updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&str> {
        self.last_updated_time.as_deref()
    }
    /// <p>Timestamp of when the detector was created.</p>
    pub fn created_time(&self) -> std::option::Option<&str> {
        self.created_time.as_deref()
    }
    /// <p>The detector ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for Detector {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Detector");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("description", &self.description);
        formatter.field("event_type_name", &self.event_type_name);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("created_time", &self.created_time);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`Detector`](crate::model::Detector)
pub mod detector {
    /// A builder for [`Detector`](crate::model::Detector)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) event_type_name: std::option::Option<std::string::String>,
        pub(crate) last_updated_time: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The detector ID.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The detector ID.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The detector description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The detector description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name of the event type.</p>
        pub fn event_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_type_name = Some(input.into());
            self
        }
        /// <p>The name of the event type.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_type_name = input;
            self
        }
        /// <p>Timestamp of when the detector was last updated.</p>
        pub fn last_updated_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_updated_time = Some(input.into());
            self
        }
        /// <p>Timestamp of when the detector was last updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>Timestamp of when the detector was created.</p>
        pub fn created_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_time = Some(input.into());
            self
        }
        /// <p>Timestamp of when the detector was created.</p>
        pub fn set_created_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The detector ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The detector ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Detector`](crate::model::Detector)
        pub fn build(self) -> crate::model::Detector {
            crate::model::Detector {
                detector_id: self.detector_id,
                description: self.description,
                event_type_name: self.event_type_name,
                last_updated_time: self.last_updated_time,
                created_time: self.created_time,
                arn: self.arn,
            }
        }
    }
}
impl Detector {
    /// Creates a new builder-style object to manufacture [`Detector`](crate::model::Detector)
    pub fn builder() -> crate::model::detector::Builder {
        crate::model::detector::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AsyncJobStatus {
    #[allow(missing_docs)] // documentation missing in model
    Canceled,
    #[allow(missing_docs)] // documentation missing in model
    CancelInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Complete,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    InProgressInitializing,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AsyncJobStatus {
    fn from(s: &str) -> Self {
        match s {
            "CANCELED" => AsyncJobStatus::Canceled,
            "CANCEL_IN_PROGRESS" => AsyncJobStatus::CancelInProgress,
            "COMPLETE" => AsyncJobStatus::Complete,
            "FAILED" => AsyncJobStatus::Failed,
            "IN_PROGRESS" => AsyncJobStatus::InProgress,
            "IN_PROGRESS_INITIALIZING" => AsyncJobStatus::InProgressInitializing,
            other => AsyncJobStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AsyncJobStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AsyncJobStatus::from(s))
    }
}
impl AsyncJobStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AsyncJobStatus::Canceled => "CANCELED",
            AsyncJobStatus::CancelInProgress => "CANCEL_IN_PROGRESS",
            AsyncJobStatus::Complete => "COMPLETE",
            AsyncJobStatus::Failed => "FAILED",
            AsyncJobStatus::InProgress => "IN_PROGRESS",
            AsyncJobStatus::InProgressInitializing => "IN_PROGRESS_INITIALIZING",
            AsyncJobStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANCELED",
            "CANCEL_IN_PROGRESS",
            "COMPLETE",
            "FAILED",
            "IN_PROGRESS",
            "IN_PROGRESS_INITIALIZING",
        ]
    }
}
impl AsRef<str> for AsyncJobStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The batch prediction details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchPrediction {
    /// <p>The job ID for the batch prediction.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The batch prediction status.</p>
    pub status: std::option::Option<crate::model::AsyncJobStatus>,
    /// <p>The reason a batch prediction job failed.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>Timestamp of when the batch prediction job started.</p>
    pub start_time: std::option::Option<std::string::String>,
    /// <p>Timestamp of when the batch prediction job completed.</p>
    pub completion_time: std::option::Option<std::string::String>,
    /// <p>Timestamp of most recent heartbeat indicating the batch prediction job was making progress.</p>
    pub last_heartbeat_time: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 location of your training file.</p>
    pub input_path: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 location of your output file.</p>
    pub output_path: std::option::Option<std::string::String>,
    /// <p>The name of the event type.</p>
    pub event_type_name: std::option::Option<std::string::String>,
    /// <p>The name of the detector.</p>
    pub detector_name: std::option::Option<std::string::String>,
    /// <p>The detector version. </p>
    pub detector_version: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM role to use for this job request.</p>
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of batch prediction job.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The number of records processed by the batch prediction job.</p>
    pub processed_records_count: std::option::Option<i32>,
    /// <p>The total number of records in the batch prediction job.</p>
    pub total_records_count: std::option::Option<i32>,
}
impl BatchPrediction {
    /// <p>The job ID for the batch prediction.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The batch prediction status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::AsyncJobStatus> {
        self.status.as_ref()
    }
    /// <p>The reason a batch prediction job failed.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>Timestamp of when the batch prediction job started.</p>
    pub fn start_time(&self) -> std::option::Option<&str> {
        self.start_time.as_deref()
    }
    /// <p>Timestamp of when the batch prediction job completed.</p>
    pub fn completion_time(&self) -> std::option::Option<&str> {
        self.completion_time.as_deref()
    }
    /// <p>Timestamp of most recent heartbeat indicating the batch prediction job was making progress.</p>
    pub fn last_heartbeat_time(&self) -> std::option::Option<&str> {
        self.last_heartbeat_time.as_deref()
    }
    /// <p>The Amazon S3 location of your training file.</p>
    pub fn input_path(&self) -> std::option::Option<&str> {
        self.input_path.as_deref()
    }
    /// <p>The Amazon S3 location of your output file.</p>
    pub fn output_path(&self) -> std::option::Option<&str> {
        self.output_path.as_deref()
    }
    /// <p>The name of the event type.</p>
    pub fn event_type_name(&self) -> std::option::Option<&str> {
        self.event_type_name.as_deref()
    }
    /// <p>The name of the detector.</p>
    pub fn detector_name(&self) -> std::option::Option<&str> {
        self.detector_name.as_deref()
    }
    /// <p>The detector version. </p>
    pub fn detector_version(&self) -> std::option::Option<&str> {
        self.detector_version.as_deref()
    }
    /// <p>The ARN of the IAM role to use for this job request.</p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
    /// <p>The ARN of batch prediction job.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The number of records processed by the batch prediction job.</p>
    pub fn processed_records_count(&self) -> std::option::Option<i32> {
        self.processed_records_count
    }
    /// <p>The total number of records in the batch prediction job.</p>
    pub fn total_records_count(&self) -> std::option::Option<i32> {
        self.total_records_count
    }
}
impl std::fmt::Debug for BatchPrediction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchPrediction");
        formatter.field("job_id", &self.job_id);
        formatter.field("status", &self.status);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("start_time", &self.start_time);
        formatter.field("completion_time", &self.completion_time);
        formatter.field("last_heartbeat_time", &self.last_heartbeat_time);
        formatter.field("input_path", &self.input_path);
        formatter.field("output_path", &self.output_path);
        formatter.field("event_type_name", &self.event_type_name);
        formatter.field("detector_name", &self.detector_name);
        formatter.field("detector_version", &self.detector_version);
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field("arn", &self.arn);
        formatter.field("processed_records_count", &self.processed_records_count);
        formatter.field("total_records_count", &self.total_records_count);
        formatter.finish()
    }
}
/// See [`BatchPrediction`](crate::model::BatchPrediction)
pub mod batch_prediction {
    /// A builder for [`BatchPrediction`](crate::model::BatchPrediction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::AsyncJobStatus>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<std::string::String>,
        pub(crate) completion_time: std::option::Option<std::string::String>,
        pub(crate) last_heartbeat_time: std::option::Option<std::string::String>,
        pub(crate) input_path: std::option::Option<std::string::String>,
        pub(crate) output_path: std::option::Option<std::string::String>,
        pub(crate) event_type_name: std::option::Option<std::string::String>,
        pub(crate) detector_name: std::option::Option<std::string::String>,
        pub(crate) detector_version: std::option::Option<std::string::String>,
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) processed_records_count: std::option::Option<i32>,
        pub(crate) total_records_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The job ID for the batch prediction.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The job ID for the batch prediction.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The batch prediction status.</p>
        pub fn status(mut self, input: crate::model::AsyncJobStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The batch prediction status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AsyncJobStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The reason a batch prediction job failed.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>The reason a batch prediction job failed.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>Timestamp of when the batch prediction job started.</p>
        pub fn start_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_time = Some(input.into());
            self
        }
        /// <p>Timestamp of when the batch prediction job started.</p>
        pub fn set_start_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start_time = input;
            self
        }
        /// <p>Timestamp of when the batch prediction job completed.</p>
        pub fn completion_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.completion_time = Some(input.into());
            self
        }
        /// <p>Timestamp of when the batch prediction job completed.</p>
        pub fn set_completion_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.completion_time = input;
            self
        }
        /// <p>Timestamp of most recent heartbeat indicating the batch prediction job was making progress.</p>
        pub fn last_heartbeat_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_heartbeat_time = Some(input.into());
            self
        }
        /// <p>Timestamp of most recent heartbeat indicating the batch prediction job was making progress.</p>
        pub fn set_last_heartbeat_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_heartbeat_time = input;
            self
        }
        /// <p>The Amazon S3 location of your training file.</p>
        pub fn input_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_path = Some(input.into());
            self
        }
        /// <p>The Amazon S3 location of your training file.</p>
        pub fn set_input_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input_path = input;
            self
        }
        /// <p>The Amazon S3 location of your output file.</p>
        pub fn output_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_path = Some(input.into());
            self
        }
        /// <p>The Amazon S3 location of your output file.</p>
        pub fn set_output_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.output_path = input;
            self
        }
        /// <p>The name of the event type.</p>
        pub fn event_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_type_name = Some(input.into());
            self
        }
        /// <p>The name of the event type.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_type_name = input;
            self
        }
        /// <p>The name of the detector.</p>
        pub fn detector_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_name = Some(input.into());
            self
        }
        /// <p>The name of the detector.</p>
        pub fn set_detector_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_name = input;
            self
        }
        /// <p>The detector version. </p>
        pub fn detector_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_version = Some(input.into());
            self
        }
        /// <p>The detector version. </p>
        pub fn set_detector_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_version = input;
            self
        }
        /// <p>The ARN of the IAM role to use for this job request.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role to use for this job request.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// <p>The ARN of batch prediction job.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of batch prediction job.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The number of records processed by the batch prediction job.</p>
        pub fn processed_records_count(mut self, input: i32) -> Self {
            self.processed_records_count = Some(input);
            self
        }
        /// <p>The number of records processed by the batch prediction job.</p>
        pub fn set_processed_records_count(mut self, input: std::option::Option<i32>) -> Self {
            self.processed_records_count = input;
            self
        }
        /// <p>The total number of records in the batch prediction job.</p>
        pub fn total_records_count(mut self, input: i32) -> Self {
            self.total_records_count = Some(input);
            self
        }
        /// <p>The total number of records in the batch prediction job.</p>
        pub fn set_total_records_count(mut self, input: std::option::Option<i32>) -> Self {
            self.total_records_count = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchPrediction`](crate::model::BatchPrediction)
        pub fn build(self) -> crate::model::BatchPrediction {
            crate::model::BatchPrediction {
                job_id: self.job_id,
                status: self.status,
                failure_reason: self.failure_reason,
                start_time: self.start_time,
                completion_time: self.completion_time,
                last_heartbeat_time: self.last_heartbeat_time,
                input_path: self.input_path,
                output_path: self.output_path,
                event_type_name: self.event_type_name,
                detector_name: self.detector_name,
                detector_version: self.detector_version,
                iam_role_arn: self.iam_role_arn,
                arn: self.arn,
                processed_records_count: self.processed_records_count,
                total_records_count: self.total_records_count,
            }
        }
    }
}
impl BatchPrediction {
    /// Creates a new builder-style object to manufacture [`BatchPrediction`](crate::model::BatchPrediction)
    pub fn builder() -> crate::model::batch_prediction::Builder {
        crate::model::batch_prediction::Builder::default()
    }
}

/// <p>The batch import job details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchImport {
    /// <p>The ID of the batch import job. </p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The status of the batch import job.</p>
    pub status: std::option::Option<crate::model::AsyncJobStatus>,
    /// <p>The reason batch import job failed.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>Timestamp of when the batch import job started.</p>
    pub start_time: std::option::Option<std::string::String>,
    /// <p>Timestamp of when batch import job completed.</p>
    pub completion_time: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 location of your data file for batch import.</p>
    pub input_path: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 location of your output file.</p>
    pub output_path: std::option::Option<std::string::String>,
    /// <p>The name of the event type.</p>
    pub event_type_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM role to use for this job request.</p>
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the batch import job.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The number of records processed by batch import job.</p>
    pub processed_records_count: std::option::Option<i32>,
    /// <p>The number of records that failed to import. </p>
    pub failed_records_count: std::option::Option<i32>,
    /// <p>The total number of records in the batch import job.</p>
    pub total_records_count: std::option::Option<i32>,
}
impl BatchImport {
    /// <p>The ID of the batch import job. </p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The status of the batch import job.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::AsyncJobStatus> {
        self.status.as_ref()
    }
    /// <p>The reason batch import job failed.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>Timestamp of when the batch import job started.</p>
    pub fn start_time(&self) -> std::option::Option<&str> {
        self.start_time.as_deref()
    }
    /// <p>Timestamp of when batch import job completed.</p>
    pub fn completion_time(&self) -> std::option::Option<&str> {
        self.completion_time.as_deref()
    }
    /// <p>The Amazon S3 location of your data file for batch import.</p>
    pub fn input_path(&self) -> std::option::Option<&str> {
        self.input_path.as_deref()
    }
    /// <p>The Amazon S3 location of your output file.</p>
    pub fn output_path(&self) -> std::option::Option<&str> {
        self.output_path.as_deref()
    }
    /// <p>The name of the event type.</p>
    pub fn event_type_name(&self) -> std::option::Option<&str> {
        self.event_type_name.as_deref()
    }
    /// <p>The ARN of the IAM role to use for this job request.</p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
    /// <p>The ARN of the batch import job.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The number of records processed by batch import job.</p>
    pub fn processed_records_count(&self) -> std::option::Option<i32> {
        self.processed_records_count
    }
    /// <p>The number of records that failed to import. </p>
    pub fn failed_records_count(&self) -> std::option::Option<i32> {
        self.failed_records_count
    }
    /// <p>The total number of records in the batch import job.</p>
    pub fn total_records_count(&self) -> std::option::Option<i32> {
        self.total_records_count
    }
}
impl std::fmt::Debug for BatchImport {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchImport");
        formatter.field("job_id", &self.job_id);
        formatter.field("status", &self.status);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("start_time", &self.start_time);
        formatter.field("completion_time", &self.completion_time);
        formatter.field("input_path", &self.input_path);
        formatter.field("output_path", &self.output_path);
        formatter.field("event_type_name", &self.event_type_name);
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field("arn", &self.arn);
        formatter.field("processed_records_count", &self.processed_records_count);
        formatter.field("failed_records_count", &self.failed_records_count);
        formatter.field("total_records_count", &self.total_records_count);
        formatter.finish()
    }
}
/// See [`BatchImport`](crate::model::BatchImport)
pub mod batch_import {
    /// A builder for [`BatchImport`](crate::model::BatchImport)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::AsyncJobStatus>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<std::string::String>,
        pub(crate) completion_time: std::option::Option<std::string::String>,
        pub(crate) input_path: std::option::Option<std::string::String>,
        pub(crate) output_path: std::option::Option<std::string::String>,
        pub(crate) event_type_name: std::option::Option<std::string::String>,
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) processed_records_count: std::option::Option<i32>,
        pub(crate) failed_records_count: std::option::Option<i32>,
        pub(crate) total_records_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the batch import job. </p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID of the batch import job. </p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The status of the batch import job.</p>
        pub fn status(mut self, input: crate::model::AsyncJobStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the batch import job.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AsyncJobStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The reason batch import job failed.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>The reason batch import job failed.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>Timestamp of when the batch import job started.</p>
        pub fn start_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_time = Some(input.into());
            self
        }
        /// <p>Timestamp of when the batch import job started.</p>
        pub fn set_start_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start_time = input;
            self
        }
        /// <p>Timestamp of when batch import job completed.</p>
        pub fn completion_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.completion_time = Some(input.into());
            self
        }
        /// <p>Timestamp of when batch import job completed.</p>
        pub fn set_completion_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.completion_time = input;
            self
        }
        /// <p>The Amazon S3 location of your data file for batch import.</p>
        pub fn input_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_path = Some(input.into());
            self
        }
        /// <p>The Amazon S3 location of your data file for batch import.</p>
        pub fn set_input_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input_path = input;
            self
        }
        /// <p>The Amazon S3 location of your output file.</p>
        pub fn output_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_path = Some(input.into());
            self
        }
        /// <p>The Amazon S3 location of your output file.</p>
        pub fn set_output_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.output_path = input;
            self
        }
        /// <p>The name of the event type.</p>
        pub fn event_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_type_name = Some(input.into());
            self
        }
        /// <p>The name of the event type.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_type_name = input;
            self
        }
        /// <p>The ARN of the IAM role to use for this job request.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role to use for this job request.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// <p>The ARN of the batch import job.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the batch import job.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The number of records processed by batch import job.</p>
        pub fn processed_records_count(mut self, input: i32) -> Self {
            self.processed_records_count = Some(input);
            self
        }
        /// <p>The number of records processed by batch import job.</p>
        pub fn set_processed_records_count(mut self, input: std::option::Option<i32>) -> Self {
            self.processed_records_count = input;
            self
        }
        /// <p>The number of records that failed to import. </p>
        pub fn failed_records_count(mut self, input: i32) -> Self {
            self.failed_records_count = Some(input);
            self
        }
        /// <p>The number of records that failed to import. </p>
        pub fn set_failed_records_count(mut self, input: std::option::Option<i32>) -> Self {
            self.failed_records_count = input;
            self
        }
        /// <p>The total number of records in the batch import job.</p>
        pub fn total_records_count(mut self, input: i32) -> Self {
            self.total_records_count = Some(input);
            self
        }
        /// <p>The total number of records in the batch import job.</p>
        pub fn set_total_records_count(mut self, input: std::option::Option<i32>) -> Self {
            self.total_records_count = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchImport`](crate::model::BatchImport)
        pub fn build(self) -> crate::model::BatchImport {
            crate::model::BatchImport {
                job_id: self.job_id,
                status: self.status,
                failure_reason: self.failure_reason,
                start_time: self.start_time,
                completion_time: self.completion_time,
                input_path: self.input_path,
                output_path: self.output_path,
                event_type_name: self.event_type_name,
                iam_role_arn: self.iam_role_arn,
                arn: self.arn,
                processed_records_count: self.processed_records_count,
                failed_records_count: self.failed_records_count,
                total_records_count: self.total_records_count,
            }
        }
    }
}
impl BatchImport {
    /// Creates a new builder-style object to manufacture [`BatchImport`](crate::model::BatchImport)
    pub fn builder() -> crate::model::batch_import::Builder {
        crate::model::batch_import::Builder::default()
    }
}

/// <p>The details of the model version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModelVersionDetail {
    /// <p>The model ID.</p>
    pub model_id: std::option::Option<std::string::String>,
    /// <p>The model type.</p>
    pub model_type: std::option::Option<crate::model::ModelTypeEnum>,
    /// <p>The model version number.</p>
    pub model_version_number: std::option::Option<std::string::String>,
    /// <p>The status of the model version.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The model version training data source.</p>
    pub training_data_source: std::option::Option<crate::model::TrainingDataSourceEnum>,
    /// <p>The training data schema.</p>
    pub training_data_schema: std::option::Option<crate::model::TrainingDataSchema>,
    /// <p>The external events data details. This will be populated if the <code>trainingDataSource</code> for the model version is specified as <code>EXTERNAL_EVENTS</code>.</p>
    pub external_events_detail: std::option::Option<crate::model::ExternalEventsDetail>,
    /// <p>The ingested events data details. This will be populated if the <code>trainingDataSource</code> for the model version is specified as <code>INGESTED_EVENTS</code>.</p>
    pub ingested_events_detail: std::option::Option<crate::model::IngestedEventsDetail>,
    /// <p>The training results.</p>
    pub training_result: std::option::Option<crate::model::TrainingResult>,
    /// <p>The timestamp when the model was last updated.</p>
    pub last_updated_time: std::option::Option<std::string::String>,
    /// <p>The timestamp when the model was created.</p>
    pub created_time: std::option::Option<std::string::String>,
    /// <p>The model version ARN.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl ModelVersionDetail {
    /// <p>The model ID.</p>
    pub fn model_id(&self) -> std::option::Option<&str> {
        self.model_id.as_deref()
    }
    /// <p>The model type.</p>
    pub fn model_type(&self) -> std::option::Option<&crate::model::ModelTypeEnum> {
        self.model_type.as_ref()
    }
    /// <p>The model version number.</p>
    pub fn model_version_number(&self) -> std::option::Option<&str> {
        self.model_version_number.as_deref()
    }
    /// <p>The status of the model version.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The model version training data source.</p>
    pub fn training_data_source(
        &self,
    ) -> std::option::Option<&crate::model::TrainingDataSourceEnum> {
        self.training_data_source.as_ref()
    }
    /// <p>The training data schema.</p>
    pub fn training_data_schema(&self) -> std::option::Option<&crate::model::TrainingDataSchema> {
        self.training_data_schema.as_ref()
    }
    /// <p>The external events data details. This will be populated if the <code>trainingDataSource</code> for the model version is specified as <code>EXTERNAL_EVENTS</code>.</p>
    pub fn external_events_detail(
        &self,
    ) -> std::option::Option<&crate::model::ExternalEventsDetail> {
        self.external_events_detail.as_ref()
    }
    /// <p>The ingested events data details. This will be populated if the <code>trainingDataSource</code> for the model version is specified as <code>INGESTED_EVENTS</code>.</p>
    pub fn ingested_events_detail(
        &self,
    ) -> std::option::Option<&crate::model::IngestedEventsDetail> {
        self.ingested_events_detail.as_ref()
    }
    /// <p>The training results.</p>
    pub fn training_result(&self) -> std::option::Option<&crate::model::TrainingResult> {
        self.training_result.as_ref()
    }
    /// <p>The timestamp when the model was last updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&str> {
        self.last_updated_time.as_deref()
    }
    /// <p>The timestamp when the model was created.</p>
    pub fn created_time(&self) -> std::option::Option<&str> {
        self.created_time.as_deref()
    }
    /// <p>The model version ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for ModelVersionDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModelVersionDetail");
        formatter.field("model_id", &self.model_id);
        formatter.field("model_type", &self.model_type);
        formatter.field("model_version_number", &self.model_version_number);
        formatter.field("status", &self.status);
        formatter.field("training_data_source", &self.training_data_source);
        formatter.field("training_data_schema", &self.training_data_schema);
        formatter.field("external_events_detail", &self.external_events_detail);
        formatter.field("ingested_events_detail", &self.ingested_events_detail);
        formatter.field("training_result", &self.training_result);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("created_time", &self.created_time);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`ModelVersionDetail`](crate::model::ModelVersionDetail)
pub mod model_version_detail {
    /// A builder for [`ModelVersionDetail`](crate::model::ModelVersionDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_id: std::option::Option<std::string::String>,
        pub(crate) model_type: std::option::Option<crate::model::ModelTypeEnum>,
        pub(crate) model_version_number: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) training_data_source: std::option::Option<crate::model::TrainingDataSourceEnum>,
        pub(crate) training_data_schema: std::option::Option<crate::model::TrainingDataSchema>,
        pub(crate) external_events_detail: std::option::Option<crate::model::ExternalEventsDetail>,
        pub(crate) ingested_events_detail: std::option::Option<crate::model::IngestedEventsDetail>,
        pub(crate) training_result: std::option::Option<crate::model::TrainingResult>,
        pub(crate) last_updated_time: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The model ID.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_id = Some(input.into());
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_id = input;
            self
        }
        /// <p>The model type.</p>
        pub fn model_type(mut self, input: crate::model::ModelTypeEnum) -> Self {
            self.model_type = Some(input);
            self
        }
        /// <p>The model type.</p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.model_type = input;
            self
        }
        /// <p>The model version number.</p>
        pub fn model_version_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_version_number = Some(input.into());
            self
        }
        /// <p>The model version number.</p>
        pub fn set_model_version_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_version_number = input;
            self
        }
        /// <p>The status of the model version.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the model version.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The model version training data source.</p>
        pub fn training_data_source(mut self, input: crate::model::TrainingDataSourceEnum) -> Self {
            self.training_data_source = Some(input);
            self
        }
        /// <p>The model version training data source.</p>
        pub fn set_training_data_source(
            mut self,
            input: std::option::Option<crate::model::TrainingDataSourceEnum>,
        ) -> Self {
            self.training_data_source = input;
            self
        }
        /// <p>The training data schema.</p>
        pub fn training_data_schema(mut self, input: crate::model::TrainingDataSchema) -> Self {
            self.training_data_schema = Some(input);
            self
        }
        /// <p>The training data schema.</p>
        pub fn set_training_data_schema(
            mut self,
            input: std::option::Option<crate::model::TrainingDataSchema>,
        ) -> Self {
            self.training_data_schema = input;
            self
        }
        /// <p>The external events data details. This will be populated if the <code>trainingDataSource</code> for the model version is specified as <code>EXTERNAL_EVENTS</code>.</p>
        pub fn external_events_detail(mut self, input: crate::model::ExternalEventsDetail) -> Self {
            self.external_events_detail = Some(input);
            self
        }
        /// <p>The external events data details. This will be populated if the <code>trainingDataSource</code> for the model version is specified as <code>EXTERNAL_EVENTS</code>.</p>
        pub fn set_external_events_detail(
            mut self,
            input: std::option::Option<crate::model::ExternalEventsDetail>,
        ) -> Self {
            self.external_events_detail = input;
            self
        }
        /// <p>The ingested events data details. This will be populated if the <code>trainingDataSource</code> for the model version is specified as <code>INGESTED_EVENTS</code>.</p>
        pub fn ingested_events_detail(mut self, input: crate::model::IngestedEventsDetail) -> Self {
            self.ingested_events_detail = Some(input);
            self
        }
        /// <p>The ingested events data details. This will be populated if the <code>trainingDataSource</code> for the model version is specified as <code>INGESTED_EVENTS</code>.</p>
        pub fn set_ingested_events_detail(
            mut self,
            input: std::option::Option<crate::model::IngestedEventsDetail>,
        ) -> Self {
            self.ingested_events_detail = input;
            self
        }
        /// <p>The training results.</p>
        pub fn training_result(mut self, input: crate::model::TrainingResult) -> Self {
            self.training_result = Some(input);
            self
        }
        /// <p>The training results.</p>
        pub fn set_training_result(
            mut self,
            input: std::option::Option<crate::model::TrainingResult>,
        ) -> Self {
            self.training_result = input;
            self
        }
        /// <p>The timestamp when the model was last updated.</p>
        pub fn last_updated_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_updated_time = Some(input.into());
            self
        }
        /// <p>The timestamp when the model was last updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>The timestamp when the model was created.</p>
        pub fn created_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_time = Some(input.into());
            self
        }
        /// <p>The timestamp when the model was created.</p>
        pub fn set_created_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The model version ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The model version ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ModelVersionDetail`](crate::model::ModelVersionDetail)
        pub fn build(self) -> crate::model::ModelVersionDetail {
            crate::model::ModelVersionDetail {
                model_id: self.model_id,
                model_type: self.model_type,
                model_version_number: self.model_version_number,
                status: self.status,
                training_data_source: self.training_data_source,
                training_data_schema: self.training_data_schema,
                external_events_detail: self.external_events_detail,
                ingested_events_detail: self.ingested_events_detail,
                training_result: self.training_result,
                last_updated_time: self.last_updated_time,
                created_time: self.created_time,
                arn: self.arn,
            }
        }
    }
}
impl ModelVersionDetail {
    /// Creates a new builder-style object to manufacture [`ModelVersionDetail`](crate::model::ModelVersionDetail)
    pub fn builder() -> crate::model::model_version_detail::Builder {
        crate::model::model_version_detail::Builder::default()
    }
}

/// <p>The training result details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrainingResult {
    /// <p>The validation metrics.</p>
    pub data_validation_metrics: std::option::Option<crate::model::DataValidationMetrics>,
    /// <p>The training metric details.</p>
    pub training_metrics: std::option::Option<crate::model::TrainingMetrics>,
    /// <p>The variable importance metrics.</p>
    pub variable_importance_metrics: std::option::Option<crate::model::VariableImportanceMetrics>,
}
impl TrainingResult {
    /// <p>The validation metrics.</p>
    pub fn data_validation_metrics(
        &self,
    ) -> std::option::Option<&crate::model::DataValidationMetrics> {
        self.data_validation_metrics.as_ref()
    }
    /// <p>The training metric details.</p>
    pub fn training_metrics(&self) -> std::option::Option<&crate::model::TrainingMetrics> {
        self.training_metrics.as_ref()
    }
    /// <p>The variable importance metrics.</p>
    pub fn variable_importance_metrics(
        &self,
    ) -> std::option::Option<&crate::model::VariableImportanceMetrics> {
        self.variable_importance_metrics.as_ref()
    }
}
impl std::fmt::Debug for TrainingResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrainingResult");
        formatter.field("data_validation_metrics", &self.data_validation_metrics);
        formatter.field("training_metrics", &self.training_metrics);
        formatter.field(
            "variable_importance_metrics",
            &self.variable_importance_metrics,
        );
        formatter.finish()
    }
}
/// See [`TrainingResult`](crate::model::TrainingResult)
pub mod training_result {
    /// A builder for [`TrainingResult`](crate::model::TrainingResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_validation_metrics:
            std::option::Option<crate::model::DataValidationMetrics>,
        pub(crate) training_metrics: std::option::Option<crate::model::TrainingMetrics>,
        pub(crate) variable_importance_metrics:
            std::option::Option<crate::model::VariableImportanceMetrics>,
    }
    impl Builder {
        /// <p>The validation metrics.</p>
        pub fn data_validation_metrics(
            mut self,
            input: crate::model::DataValidationMetrics,
        ) -> Self {
            self.data_validation_metrics = Some(input);
            self
        }
        /// <p>The validation metrics.</p>
        pub fn set_data_validation_metrics(
            mut self,
            input: std::option::Option<crate::model::DataValidationMetrics>,
        ) -> Self {
            self.data_validation_metrics = input;
            self
        }
        /// <p>The training metric details.</p>
        pub fn training_metrics(mut self, input: crate::model::TrainingMetrics) -> Self {
            self.training_metrics = Some(input);
            self
        }
        /// <p>The training metric details.</p>
        pub fn set_training_metrics(
            mut self,
            input: std::option::Option<crate::model::TrainingMetrics>,
        ) -> Self {
            self.training_metrics = input;
            self
        }
        /// <p>The variable importance metrics.</p>
        pub fn variable_importance_metrics(
            mut self,
            input: crate::model::VariableImportanceMetrics,
        ) -> Self {
            self.variable_importance_metrics = Some(input);
            self
        }
        /// <p>The variable importance metrics.</p>
        pub fn set_variable_importance_metrics(
            mut self,
            input: std::option::Option<crate::model::VariableImportanceMetrics>,
        ) -> Self {
            self.variable_importance_metrics = input;
            self
        }
        /// Consumes the builder and constructs a [`TrainingResult`](crate::model::TrainingResult)
        pub fn build(self) -> crate::model::TrainingResult {
            crate::model::TrainingResult {
                data_validation_metrics: self.data_validation_metrics,
                training_metrics: self.training_metrics,
                variable_importance_metrics: self.variable_importance_metrics,
            }
        }
    }
}
impl TrainingResult {
    /// Creates a new builder-style object to manufacture [`TrainingResult`](crate::model::TrainingResult)
    pub fn builder() -> crate::model::training_result::Builder {
        crate::model::training_result::Builder::default()
    }
}

/// <p>The variable importance metrics details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VariableImportanceMetrics {
    /// <p>List of variable metrics.</p>
    pub log_odds_metrics: std::option::Option<std::vec::Vec<crate::model::LogOddsMetric>>,
}
impl VariableImportanceMetrics {
    /// <p>List of variable metrics.</p>
    pub fn log_odds_metrics(&self) -> std::option::Option<&[crate::model::LogOddsMetric]> {
        self.log_odds_metrics.as_deref()
    }
}
impl std::fmt::Debug for VariableImportanceMetrics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VariableImportanceMetrics");
        formatter.field("log_odds_metrics", &self.log_odds_metrics);
        formatter.finish()
    }
}
/// See [`VariableImportanceMetrics`](crate::model::VariableImportanceMetrics)
pub mod variable_importance_metrics {
    /// A builder for [`VariableImportanceMetrics`](crate::model::VariableImportanceMetrics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_odds_metrics:
            std::option::Option<std::vec::Vec<crate::model::LogOddsMetric>>,
    }
    impl Builder {
        /// Appends an item to `log_odds_metrics`.
        ///
        /// To override the contents of this collection use [`set_log_odds_metrics`](Self::set_log_odds_metrics).
        ///
        /// <p>List of variable metrics.</p>
        pub fn log_odds_metrics(mut self, input: crate::model::LogOddsMetric) -> Self {
            let mut v = self.log_odds_metrics.unwrap_or_default();
            v.push(input);
            self.log_odds_metrics = Some(v);
            self
        }
        /// <p>List of variable metrics.</p>
        pub fn set_log_odds_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LogOddsMetric>>,
        ) -> Self {
            self.log_odds_metrics = input;
            self
        }
        /// Consumes the builder and constructs a [`VariableImportanceMetrics`](crate::model::VariableImportanceMetrics)
        pub fn build(self) -> crate::model::VariableImportanceMetrics {
            crate::model::VariableImportanceMetrics {
                log_odds_metrics: self.log_odds_metrics,
            }
        }
    }
}
impl VariableImportanceMetrics {
    /// Creates a new builder-style object to manufacture [`VariableImportanceMetrics`](crate::model::VariableImportanceMetrics)
    pub fn builder() -> crate::model::variable_importance_metrics::Builder {
        crate::model::variable_importance_metrics::Builder::default()
    }
}

/// <p>The log odds metric details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LogOddsMetric {
    /// <p>The name of the variable.</p>
    pub variable_name: std::option::Option<std::string::String>,
    /// <p>The type of variable.</p>
    pub variable_type: std::option::Option<std::string::String>,
    /// <p>The relative importance of the variable. For more information, see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/model-variable-importance.html">Model variable importance</a>.</p>
    pub variable_importance: std::option::Option<f32>,
}
impl LogOddsMetric {
    /// <p>The name of the variable.</p>
    pub fn variable_name(&self) -> std::option::Option<&str> {
        self.variable_name.as_deref()
    }
    /// <p>The type of variable.</p>
    pub fn variable_type(&self) -> std::option::Option<&str> {
        self.variable_type.as_deref()
    }
    /// <p>The relative importance of the variable. For more information, see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/model-variable-importance.html">Model variable importance</a>.</p>
    pub fn variable_importance(&self) -> std::option::Option<f32> {
        self.variable_importance
    }
}
impl std::fmt::Debug for LogOddsMetric {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LogOddsMetric");
        formatter.field("variable_name", &self.variable_name);
        formatter.field("variable_type", &self.variable_type);
        formatter.field("variable_importance", &self.variable_importance);
        formatter.finish()
    }
}
/// See [`LogOddsMetric`](crate::model::LogOddsMetric)
pub mod log_odds_metric {
    /// A builder for [`LogOddsMetric`](crate::model::LogOddsMetric)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) variable_name: std::option::Option<std::string::String>,
        pub(crate) variable_type: std::option::Option<std::string::String>,
        pub(crate) variable_importance: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>The name of the variable.</p>
        pub fn variable_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.variable_name = Some(input.into());
            self
        }
        /// <p>The name of the variable.</p>
        pub fn set_variable_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.variable_name = input;
            self
        }
        /// <p>The type of variable.</p>
        pub fn variable_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.variable_type = Some(input.into());
            self
        }
        /// <p>The type of variable.</p>
        pub fn set_variable_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.variable_type = input;
            self
        }
        /// <p>The relative importance of the variable. For more information, see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/model-variable-importance.html">Model variable importance</a>.</p>
        pub fn variable_importance(mut self, input: f32) -> Self {
            self.variable_importance = Some(input);
            self
        }
        /// <p>The relative importance of the variable. For more information, see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/model-variable-importance.html">Model variable importance</a>.</p>
        pub fn set_variable_importance(mut self, input: std::option::Option<f32>) -> Self {
            self.variable_importance = input;
            self
        }
        /// Consumes the builder and constructs a [`LogOddsMetric`](crate::model::LogOddsMetric)
        pub fn build(self) -> crate::model::LogOddsMetric {
            crate::model::LogOddsMetric {
                variable_name: self.variable_name,
                variable_type: self.variable_type,
                variable_importance: self.variable_importance,
            }
        }
    }
}
impl LogOddsMetric {
    /// Creates a new builder-style object to manufacture [`LogOddsMetric`](crate::model::LogOddsMetric)
    pub fn builder() -> crate::model::log_odds_metric::Builder {
        crate::model::log_odds_metric::Builder::default()
    }
}

/// <p>The training metric details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrainingMetrics {
    /// <p>The area under the curve. This summarizes true positive rate (TPR) and false positive rate (FPR) across all possible model score thresholds. A model with no predictive power has an AUC of 0.5, whereas a perfect model has a score of 1.0.</p>
    pub auc: std::option::Option<f32>,
    /// <p>The data points details.</p>
    pub metric_data_points: std::option::Option<std::vec::Vec<crate::model::MetricDataPoint>>,
}
impl TrainingMetrics {
    /// <p>The area under the curve. This summarizes true positive rate (TPR) and false positive rate (FPR) across all possible model score thresholds. A model with no predictive power has an AUC of 0.5, whereas a perfect model has a score of 1.0.</p>
    pub fn auc(&self) -> std::option::Option<f32> {
        self.auc
    }
    /// <p>The data points details.</p>
    pub fn metric_data_points(&self) -> std::option::Option<&[crate::model::MetricDataPoint]> {
        self.metric_data_points.as_deref()
    }
}
impl std::fmt::Debug for TrainingMetrics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrainingMetrics");
        formatter.field("auc", &self.auc);
        formatter.field("metric_data_points", &self.metric_data_points);
        formatter.finish()
    }
}
/// See [`TrainingMetrics`](crate::model::TrainingMetrics)
pub mod training_metrics {
    /// A builder for [`TrainingMetrics`](crate::model::TrainingMetrics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auc: std::option::Option<f32>,
        pub(crate) metric_data_points:
            std::option::Option<std::vec::Vec<crate::model::MetricDataPoint>>,
    }
    impl Builder {
        /// <p>The area under the curve. This summarizes true positive rate (TPR) and false positive rate (FPR) across all possible model score thresholds. A model with no predictive power has an AUC of 0.5, whereas a perfect model has a score of 1.0.</p>
        pub fn auc(mut self, input: f32) -> Self {
            self.auc = Some(input);
            self
        }
        /// <p>The area under the curve. This summarizes true positive rate (TPR) and false positive rate (FPR) across all possible model score thresholds. A model with no predictive power has an AUC of 0.5, whereas a perfect model has a score of 1.0.</p>
        pub fn set_auc(mut self, input: std::option::Option<f32>) -> Self {
            self.auc = input;
            self
        }
        /// Appends an item to `metric_data_points`.
        ///
        /// To override the contents of this collection use [`set_metric_data_points`](Self::set_metric_data_points).
        ///
        /// <p>The data points details.</p>
        pub fn metric_data_points(mut self, input: crate::model::MetricDataPoint) -> Self {
            let mut v = self.metric_data_points.unwrap_or_default();
            v.push(input);
            self.metric_data_points = Some(v);
            self
        }
        /// <p>The data points details.</p>
        pub fn set_metric_data_points(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricDataPoint>>,
        ) -> Self {
            self.metric_data_points = input;
            self
        }
        /// Consumes the builder and constructs a [`TrainingMetrics`](crate::model::TrainingMetrics)
        pub fn build(self) -> crate::model::TrainingMetrics {
            crate::model::TrainingMetrics {
                auc: self.auc,
                metric_data_points: self.metric_data_points,
            }
        }
    }
}
impl TrainingMetrics {
    /// Creates a new builder-style object to manufacture [`TrainingMetrics`](crate::model::TrainingMetrics)
    pub fn builder() -> crate::model::training_metrics::Builder {
        crate::model::training_metrics::Builder::default()
    }
}

/// <p>Model performance metrics data points.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricDataPoint {
    /// <p>The false positive rate. This is the percentage of total legitimate events that are incorrectly predicted as fraud.</p>
    pub fpr: std::option::Option<f32>,
    /// <p>The percentage of fraud events correctly predicted as fraudulent as compared to all events predicted as fraudulent.</p>
    pub precision: std::option::Option<f32>,
    /// <p>The true positive rate. This is the percentage of total fraud the model detects. Also known as capture rate.</p>
    pub tpr: std::option::Option<f32>,
    /// <p>The model threshold that specifies an acceptable fraud capture rate. For example, a threshold of 500 means any model score 500 or above is labeled as fraud.</p>
    pub threshold: std::option::Option<f32>,
}
impl MetricDataPoint {
    /// <p>The false positive rate. This is the percentage of total legitimate events that are incorrectly predicted as fraud.</p>
    pub fn fpr(&self) -> std::option::Option<f32> {
        self.fpr
    }
    /// <p>The percentage of fraud events correctly predicted as fraudulent as compared to all events predicted as fraudulent.</p>
    pub fn precision(&self) -> std::option::Option<f32> {
        self.precision
    }
    /// <p>The true positive rate. This is the percentage of total fraud the model detects. Also known as capture rate.</p>
    pub fn tpr(&self) -> std::option::Option<f32> {
        self.tpr
    }
    /// <p>The model threshold that specifies an acceptable fraud capture rate. For example, a threshold of 500 means any model score 500 or above is labeled as fraud.</p>
    pub fn threshold(&self) -> std::option::Option<f32> {
        self.threshold
    }
}
impl std::fmt::Debug for MetricDataPoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricDataPoint");
        formatter.field("fpr", &self.fpr);
        formatter.field("precision", &self.precision);
        formatter.field("tpr", &self.tpr);
        formatter.field("threshold", &self.threshold);
        formatter.finish()
    }
}
/// See [`MetricDataPoint`](crate::model::MetricDataPoint)
pub mod metric_data_point {
    /// A builder for [`MetricDataPoint`](crate::model::MetricDataPoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fpr: std::option::Option<f32>,
        pub(crate) precision: std::option::Option<f32>,
        pub(crate) tpr: std::option::Option<f32>,
        pub(crate) threshold: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>The false positive rate. This is the percentage of total legitimate events that are incorrectly predicted as fraud.</p>
        pub fn fpr(mut self, input: f32) -> Self {
            self.fpr = Some(input);
            self
        }
        /// <p>The false positive rate. This is the percentage of total legitimate events that are incorrectly predicted as fraud.</p>
        pub fn set_fpr(mut self, input: std::option::Option<f32>) -> Self {
            self.fpr = input;
            self
        }
        /// <p>The percentage of fraud events correctly predicted as fraudulent as compared to all events predicted as fraudulent.</p>
        pub fn precision(mut self, input: f32) -> Self {
            self.precision = Some(input);
            self
        }
        /// <p>The percentage of fraud events correctly predicted as fraudulent as compared to all events predicted as fraudulent.</p>
        pub fn set_precision(mut self, input: std::option::Option<f32>) -> Self {
            self.precision = input;
            self
        }
        /// <p>The true positive rate. This is the percentage of total fraud the model detects. Also known as capture rate.</p>
        pub fn tpr(mut self, input: f32) -> Self {
            self.tpr = Some(input);
            self
        }
        /// <p>The true positive rate. This is the percentage of total fraud the model detects. Also known as capture rate.</p>
        pub fn set_tpr(mut self, input: std::option::Option<f32>) -> Self {
            self.tpr = input;
            self
        }
        /// <p>The model threshold that specifies an acceptable fraud capture rate. For example, a threshold of 500 means any model score 500 or above is labeled as fraud.</p>
        pub fn threshold(mut self, input: f32) -> Self {
            self.threshold = Some(input);
            self
        }
        /// <p>The model threshold that specifies an acceptable fraud capture rate. For example, a threshold of 500 means any model score 500 or above is labeled as fraud.</p>
        pub fn set_threshold(mut self, input: std::option::Option<f32>) -> Self {
            self.threshold = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricDataPoint`](crate::model::MetricDataPoint)
        pub fn build(self) -> crate::model::MetricDataPoint {
            crate::model::MetricDataPoint {
                fpr: self.fpr,
                precision: self.precision,
                tpr: self.tpr,
                threshold: self.threshold,
            }
        }
    }
}
impl MetricDataPoint {
    /// Creates a new builder-style object to manufacture [`MetricDataPoint`](crate::model::MetricDataPoint)
    pub fn builder() -> crate::model::metric_data_point::Builder {
        crate::model::metric_data_point::Builder::default()
    }
}

/// <p>The model training validation messages.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataValidationMetrics {
    /// <p>The file-specific model training validation messages.</p>
    pub file_level_messages:
        std::option::Option<std::vec::Vec<crate::model::FileValidationMessage>>,
    /// <p>The field-specific model training validation messages.</p>
    pub field_level_messages:
        std::option::Option<std::vec::Vec<crate::model::FieldValidationMessage>>,
}
impl DataValidationMetrics {
    /// <p>The file-specific model training validation messages.</p>
    pub fn file_level_messages(
        &self,
    ) -> std::option::Option<&[crate::model::FileValidationMessage]> {
        self.file_level_messages.as_deref()
    }
    /// <p>The field-specific model training validation messages.</p>
    pub fn field_level_messages(
        &self,
    ) -> std::option::Option<&[crate::model::FieldValidationMessage]> {
        self.field_level_messages.as_deref()
    }
}
impl std::fmt::Debug for DataValidationMetrics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataValidationMetrics");
        formatter.field("file_level_messages", &self.file_level_messages);
        formatter.field("field_level_messages", &self.field_level_messages);
        formatter.finish()
    }
}
/// See [`DataValidationMetrics`](crate::model::DataValidationMetrics)
pub mod data_validation_metrics {
    /// A builder for [`DataValidationMetrics`](crate::model::DataValidationMetrics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_level_messages:
            std::option::Option<std::vec::Vec<crate::model::FileValidationMessage>>,
        pub(crate) field_level_messages:
            std::option::Option<std::vec::Vec<crate::model::FieldValidationMessage>>,
    }
    impl Builder {
        /// Appends an item to `file_level_messages`.
        ///
        /// To override the contents of this collection use [`set_file_level_messages`](Self::set_file_level_messages).
        ///
        /// <p>The file-specific model training validation messages.</p>
        pub fn file_level_messages(mut self, input: crate::model::FileValidationMessage) -> Self {
            let mut v = self.file_level_messages.unwrap_or_default();
            v.push(input);
            self.file_level_messages = Some(v);
            self
        }
        /// <p>The file-specific model training validation messages.</p>
        pub fn set_file_level_messages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FileValidationMessage>>,
        ) -> Self {
            self.file_level_messages = input;
            self
        }
        /// Appends an item to `field_level_messages`.
        ///
        /// To override the contents of this collection use [`set_field_level_messages`](Self::set_field_level_messages).
        ///
        /// <p>The field-specific model training validation messages.</p>
        pub fn field_level_messages(mut self, input: crate::model::FieldValidationMessage) -> Self {
            let mut v = self.field_level_messages.unwrap_or_default();
            v.push(input);
            self.field_level_messages = Some(v);
            self
        }
        /// <p>The field-specific model training validation messages.</p>
        pub fn set_field_level_messages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FieldValidationMessage>>,
        ) -> Self {
            self.field_level_messages = input;
            self
        }
        /// Consumes the builder and constructs a [`DataValidationMetrics`](crate::model::DataValidationMetrics)
        pub fn build(self) -> crate::model::DataValidationMetrics {
            crate::model::DataValidationMetrics {
                file_level_messages: self.file_level_messages,
                field_level_messages: self.field_level_messages,
            }
        }
    }
}
impl DataValidationMetrics {
    /// Creates a new builder-style object to manufacture [`DataValidationMetrics`](crate::model::DataValidationMetrics)
    pub fn builder() -> crate::model::data_validation_metrics::Builder {
        crate::model::data_validation_metrics::Builder::default()
    }
}

/// <p>The message details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FieldValidationMessage {
    /// <p>The field name.</p>
    pub field_name: std::option::Option<std::string::String>,
    /// <p>The message ID.</p>
    pub identifier: std::option::Option<std::string::String>,
    /// <p>The message title.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p>The message content.</p>
    pub content: std::option::Option<std::string::String>,
    /// <p>The message type.</p>
    pub r#type: std::option::Option<std::string::String>,
}
impl FieldValidationMessage {
    /// <p>The field name.</p>
    pub fn field_name(&self) -> std::option::Option<&str> {
        self.field_name.as_deref()
    }
    /// <p>The message ID.</p>
    pub fn identifier(&self) -> std::option::Option<&str> {
        self.identifier.as_deref()
    }
    /// <p>The message title.</p>
    pub fn title(&self) -> std::option::Option<&str> {
        self.title.as_deref()
    }
    /// <p>The message content.</p>
    pub fn content(&self) -> std::option::Option<&str> {
        self.content.as_deref()
    }
    /// <p>The message type.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for FieldValidationMessage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FieldValidationMessage");
        formatter.field("field_name", &self.field_name);
        formatter.field("identifier", &self.identifier);
        formatter.field("title", &self.title);
        formatter.field("content", &self.content);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`FieldValidationMessage`](crate::model::FieldValidationMessage)
pub mod field_validation_message {
    /// A builder for [`FieldValidationMessage`](crate::model::FieldValidationMessage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field_name: std::option::Option<std::string::String>,
        pub(crate) identifier: std::option::Option<std::string::String>,
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The field name.</p>
        pub fn field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.field_name = Some(input.into());
            self
        }
        /// <p>The field name.</p>
        pub fn set_field_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.field_name = input;
            self
        }
        /// <p>The message ID.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>The message ID.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// <p>The message title.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>The message title.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>The message content.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The message content.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// <p>The message type.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The message type.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`FieldValidationMessage`](crate::model::FieldValidationMessage)
        pub fn build(self) -> crate::model::FieldValidationMessage {
            crate::model::FieldValidationMessage {
                field_name: self.field_name,
                identifier: self.identifier,
                title: self.title,
                content: self.content,
                r#type: self.r#type,
            }
        }
    }
}
impl FieldValidationMessage {
    /// Creates a new builder-style object to manufacture [`FieldValidationMessage`](crate::model::FieldValidationMessage)
    pub fn builder() -> crate::model::field_validation_message::Builder {
        crate::model::field_validation_message::Builder::default()
    }
}

/// <p>The message details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FileValidationMessage {
    /// <p>The message title.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p>The message content.</p>
    pub content: std::option::Option<std::string::String>,
    /// <p>The message type.</p>
    pub r#type: std::option::Option<std::string::String>,
}
impl FileValidationMessage {
    /// <p>The message title.</p>
    pub fn title(&self) -> std::option::Option<&str> {
        self.title.as_deref()
    }
    /// <p>The message content.</p>
    pub fn content(&self) -> std::option::Option<&str> {
        self.content.as_deref()
    }
    /// <p>The message type.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for FileValidationMessage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FileValidationMessage");
        formatter.field("title", &self.title);
        formatter.field("content", &self.content);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`FileValidationMessage`](crate::model::FileValidationMessage)
pub mod file_validation_message {
    /// A builder for [`FileValidationMessage`](crate::model::FileValidationMessage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message title.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>The message title.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>The message content.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The message content.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// <p>The message type.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The message type.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`FileValidationMessage`](crate::model::FileValidationMessage)
        pub fn build(self) -> crate::model::FileValidationMessage {
            crate::model::FileValidationMessage {
                title: self.title,
                content: self.content,
                r#type: self.r#type,
            }
        }
    }
}
impl FileValidationMessage {
    /// Creates a new builder-style object to manufacture [`FileValidationMessage`](crate::model::FileValidationMessage)
    pub fn builder() -> crate::model::file_validation_message::Builder {
        crate::model::file_validation_message::Builder::default()
    }
}

/// <p>The summary of the detector version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetectorVersionSummary {
    /// <p>The detector version ID. </p>
    pub detector_version_id: std::option::Option<std::string::String>,
    /// <p>The detector version status. </p>
    pub status: std::option::Option<crate::model::DetectorVersionStatus>,
    /// <p>The detector version description. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Timestamp of when the detector version was last updated.</p>
    pub last_updated_time: std::option::Option<std::string::String>,
}
impl DetectorVersionSummary {
    /// <p>The detector version ID. </p>
    pub fn detector_version_id(&self) -> std::option::Option<&str> {
        self.detector_version_id.as_deref()
    }
    /// <p>The detector version status. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::DetectorVersionStatus> {
        self.status.as_ref()
    }
    /// <p>The detector version description. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Timestamp of when the detector version was last updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&str> {
        self.last_updated_time.as_deref()
    }
}
impl std::fmt::Debug for DetectorVersionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetectorVersionSummary");
        formatter.field("detector_version_id", &self.detector_version_id);
        formatter.field("status", &self.status);
        formatter.field("description", &self.description);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.finish()
    }
}
/// See [`DetectorVersionSummary`](crate::model::DetectorVersionSummary)
pub mod detector_version_summary {
    /// A builder for [`DetectorVersionSummary`](crate::model::DetectorVersionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_version_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::DetectorVersionStatus>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) last_updated_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The detector version ID. </p>
        pub fn detector_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_version_id = Some(input.into());
            self
        }
        /// <p>The detector version ID. </p>
        pub fn set_detector_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_version_id = input;
            self
        }
        /// <p>The detector version status. </p>
        pub fn status(mut self, input: crate::model::DetectorVersionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The detector version status. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DetectorVersionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The detector version description. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The detector version description. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Timestamp of when the detector version was last updated.</p>
        pub fn last_updated_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_updated_time = Some(input.into());
            self
        }
        /// <p>Timestamp of when the detector version was last updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DetectorVersionSummary`](crate::model::DetectorVersionSummary)
        pub fn build(self) -> crate::model::DetectorVersionSummary {
            crate::model::DetectorVersionSummary {
                detector_version_id: self.detector_version_id,
                status: self.status,
                description: self.description,
                last_updated_time: self.last_updated_time,
            }
        }
    }
}
impl DetectorVersionSummary {
    /// Creates a new builder-style object to manufacture [`DetectorVersionSummary`](crate::model::DetectorVersionSummary)
    pub fn builder() -> crate::model::detector_version_summary::Builder {
        crate::model::detector_version_summary::Builder::default()
    }
}

/// <p>Provides the error of the batch get variable API.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetVariableError {
    /// <p>The error name. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The error code. </p>
    pub code: i32,
    /// <p>The error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl BatchGetVariableError {
    /// <p>The error name. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The error code. </p>
    pub fn code(&self) -> i32 {
        self.code
    }
    /// <p>The error message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for BatchGetVariableError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetVariableError");
        formatter.field("name", &self.name);
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`BatchGetVariableError`](crate::model::BatchGetVariableError)
pub mod batch_get_variable_error {
    /// A builder for [`BatchGetVariableError`](crate::model::BatchGetVariableError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<i32>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error name. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The error name. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The error code. </p>
        pub fn code(mut self, input: i32) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The error code. </p>
        pub fn set_code(mut self, input: std::option::Option<i32>) -> Self {
            self.code = input;
            self
        }
        /// <p>The error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetVariableError`](crate::model::BatchGetVariableError)
        pub fn build(self) -> crate::model::BatchGetVariableError {
            crate::model::BatchGetVariableError {
                name: self.name,
                code: self.code.unwrap_or_default(),
                message: self.message,
            }
        }
    }
}
impl BatchGetVariableError {
    /// Creates a new builder-style object to manufacture [`BatchGetVariableError`](crate::model::BatchGetVariableError)
    pub fn builder() -> crate::model::batch_get_variable_error::Builder {
        crate::model::batch_get_variable_error::Builder::default()
    }
}

/// <p>Provides the error of the batch create variable API.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchCreateVariableError {
    /// <p>The name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The error code. </p>
    pub code: i32,
    /// <p>The error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl BatchCreateVariableError {
    /// <p>The name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The error code. </p>
    pub fn code(&self) -> i32 {
        self.code
    }
    /// <p>The error message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for BatchCreateVariableError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchCreateVariableError");
        formatter.field("name", &self.name);
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`BatchCreateVariableError`](crate::model::BatchCreateVariableError)
pub mod batch_create_variable_error {
    /// A builder for [`BatchCreateVariableError`](crate::model::BatchCreateVariableError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<i32>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The error code. </p>
        pub fn code(mut self, input: i32) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The error code. </p>
        pub fn set_code(mut self, input: std::option::Option<i32>) -> Self {
            self.code = input;
            self
        }
        /// <p>The error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchCreateVariableError`](crate::model::BatchCreateVariableError)
        pub fn build(self) -> crate::model::BatchCreateVariableError {
            crate::model::BatchCreateVariableError {
                name: self.name,
                code: self.code.unwrap_or_default(),
                message: self.message,
            }
        }
    }
}
impl BatchCreateVariableError {
    /// Creates a new builder-style object to manufacture [`BatchCreateVariableError`](crate::model::BatchCreateVariableError)
    pub fn builder() -> crate::model::batch_create_variable_error::Builder {
        crate::model::batch_create_variable_error::Builder::default()
    }
}

/// <p>A variable in the list of variables for the batch create variable request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VariableEntry {
    /// <p>The name of the variable.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The data type of the variable.</p>
    pub data_type: std::option::Option<std::string::String>,
    /// <p>The data source of the variable.</p>
    pub data_source: std::option::Option<std::string::String>,
    /// <p>The default value of the variable.</p>
    pub default_value: std::option::Option<std::string::String>,
    /// <p>The description of the variable.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The type of the variable. For more information see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable types</a>.</p>
    /// <p>Valid Values: <code>AUTH_CODE | AVS | BILLING_ADDRESS_L1 | BILLING_ADDRESS_L2 | BILLING_CITY | BILLING_COUNTRY | BILLING_NAME | BILLING_PHONE | BILLING_STATE | BILLING_ZIP | CARD_BIN | CATEGORICAL | CURRENCY_CODE | EMAIL_ADDRESS | FINGERPRINT | FRAUD_LABEL | FREE_FORM_TEXT | IP_ADDRESS | NUMERIC | ORDER_ID | PAYMENT_TYPE | PHONE_NUMBER | PRICE | PRODUCT_CATEGORY | SHIPPING_ADDRESS_L1 | SHIPPING_ADDRESS_L2 | SHIPPING_CITY | SHIPPING_COUNTRY | SHIPPING_NAME | SHIPPING_PHONE | SHIPPING_STATE | SHIPPING_ZIP | USERAGENT </code> </p>
    pub variable_type: std::option::Option<std::string::String>,
}
impl VariableEntry {
    /// <p>The name of the variable.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The data type of the variable.</p>
    pub fn data_type(&self) -> std::option::Option<&str> {
        self.data_type.as_deref()
    }
    /// <p>The data source of the variable.</p>
    pub fn data_source(&self) -> std::option::Option<&str> {
        self.data_source.as_deref()
    }
    /// <p>The default value of the variable.</p>
    pub fn default_value(&self) -> std::option::Option<&str> {
        self.default_value.as_deref()
    }
    /// <p>The description of the variable.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The type of the variable. For more information see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable types</a>.</p>
    /// <p>Valid Values: <code>AUTH_CODE | AVS | BILLING_ADDRESS_L1 | BILLING_ADDRESS_L2 | BILLING_CITY | BILLING_COUNTRY | BILLING_NAME | BILLING_PHONE | BILLING_STATE | BILLING_ZIP | CARD_BIN | CATEGORICAL | CURRENCY_CODE | EMAIL_ADDRESS | FINGERPRINT | FRAUD_LABEL | FREE_FORM_TEXT | IP_ADDRESS | NUMERIC | ORDER_ID | PAYMENT_TYPE | PHONE_NUMBER | PRICE | PRODUCT_CATEGORY | SHIPPING_ADDRESS_L1 | SHIPPING_ADDRESS_L2 | SHIPPING_CITY | SHIPPING_COUNTRY | SHIPPING_NAME | SHIPPING_PHONE | SHIPPING_STATE | SHIPPING_ZIP | USERAGENT </code> </p>
    pub fn variable_type(&self) -> std::option::Option<&str> {
        self.variable_type.as_deref()
    }
}
impl std::fmt::Debug for VariableEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VariableEntry");
        formatter.field("name", &self.name);
        formatter.field("data_type", &self.data_type);
        formatter.field("data_source", &self.data_source);
        formatter.field("default_value", &self.default_value);
        formatter.field("description", &self.description);
        formatter.field("variable_type", &self.variable_type);
        formatter.finish()
    }
}
/// See [`VariableEntry`](crate::model::VariableEntry)
pub mod variable_entry {
    /// A builder for [`VariableEntry`](crate::model::VariableEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) data_type: std::option::Option<std::string::String>,
        pub(crate) data_source: std::option::Option<std::string::String>,
        pub(crate) default_value: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) variable_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the variable.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the variable.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The data type of the variable.</p>
        pub fn data_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_type = Some(input.into());
            self
        }
        /// <p>The data type of the variable.</p>
        pub fn set_data_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_type = input;
            self
        }
        /// <p>The data source of the variable.</p>
        pub fn data_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source = Some(input.into());
            self
        }
        /// <p>The data source of the variable.</p>
        pub fn set_data_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_source = input;
            self
        }
        /// <p>The default value of the variable.</p>
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_value = Some(input.into());
            self
        }
        /// <p>The default value of the variable.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// <p>The description of the variable.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the variable.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The type of the variable. For more information see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable types</a>.</p>
        /// <p>Valid Values: <code>AUTH_CODE | AVS | BILLING_ADDRESS_L1 | BILLING_ADDRESS_L2 | BILLING_CITY | BILLING_COUNTRY | BILLING_NAME | BILLING_PHONE | BILLING_STATE | BILLING_ZIP | CARD_BIN | CATEGORICAL | CURRENCY_CODE | EMAIL_ADDRESS | FINGERPRINT | FRAUD_LABEL | FREE_FORM_TEXT | IP_ADDRESS | NUMERIC | ORDER_ID | PAYMENT_TYPE | PHONE_NUMBER | PRICE | PRODUCT_CATEGORY | SHIPPING_ADDRESS_L1 | SHIPPING_ADDRESS_L2 | SHIPPING_CITY | SHIPPING_COUNTRY | SHIPPING_NAME | SHIPPING_PHONE | SHIPPING_STATE | SHIPPING_ZIP | USERAGENT </code> </p>
        pub fn variable_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.variable_type = Some(input.into());
            self
        }
        /// <p>The type of the variable. For more information see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable types</a>.</p>
        /// <p>Valid Values: <code>AUTH_CODE | AVS | BILLING_ADDRESS_L1 | BILLING_ADDRESS_L2 | BILLING_CITY | BILLING_COUNTRY | BILLING_NAME | BILLING_PHONE | BILLING_STATE | BILLING_ZIP | CARD_BIN | CATEGORICAL | CURRENCY_CODE | EMAIL_ADDRESS | FINGERPRINT | FRAUD_LABEL | FREE_FORM_TEXT | IP_ADDRESS | NUMERIC | ORDER_ID | PAYMENT_TYPE | PHONE_NUMBER | PRICE | PRODUCT_CATEGORY | SHIPPING_ADDRESS_L1 | SHIPPING_ADDRESS_L2 | SHIPPING_CITY | SHIPPING_COUNTRY | SHIPPING_NAME | SHIPPING_PHONE | SHIPPING_STATE | SHIPPING_ZIP | USERAGENT </code> </p>
        pub fn set_variable_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.variable_type = input;
            self
        }
        /// Consumes the builder and constructs a [`VariableEntry`](crate::model::VariableEntry)
        pub fn build(self) -> crate::model::VariableEntry {
            crate::model::VariableEntry {
                name: self.name,
                data_type: self.data_type,
                data_source: self.data_source,
                default_value: self.default_value,
                description: self.description,
                variable_type: self.variable_type,
            }
        }
    }
}
impl VariableEntry {
    /// Creates a new builder-style object to manufacture [`VariableEntry`](crate::model::VariableEntry)
    pub fn builder() -> crate::model::variable_entry::Builder {
        crate::model::variable_entry::Builder::default()
    }
}
