// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Fraud Detector
///
/// Client for invoking operations on Amazon Fraud Detector. Each operation on Amazon Fraud Detector is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_frauddetector::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_frauddetector::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_frauddetector::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`BatchCreateVariable`](crate::client::fluent_builders::BatchCreateVariable) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`variable_entries(Vec<VariableEntry>)`](crate::client::fluent_builders::BatchCreateVariable::variable_entries) / [`set_variable_entries(Option<Vec<VariableEntry>>)`](crate::client::fluent_builders::BatchCreateVariable::set_variable_entries): <p>The list of variables for the batch create variable request.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::BatchCreateVariable::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::BatchCreateVariable::set_tags): <p>A collection of key and value pairs.</p>
    /// - On success, responds with [`BatchCreateVariableOutput`](crate::output::BatchCreateVariableOutput) with field(s):
    ///   - [`errors(Option<Vec<BatchCreateVariableError>>)`](crate::output::BatchCreateVariableOutput::errors): <p>Provides the errors for the <code>BatchCreateVariable</code> request.</p>
    /// - On failure, responds with [`SdkError<BatchCreateVariableError>`](crate::error::BatchCreateVariableError)
    pub fn batch_create_variable(&self) -> fluent_builders::BatchCreateVariable {
        fluent_builders::BatchCreateVariable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchGetVariable`](crate::client::fluent_builders::BatchGetVariable) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`names(Vec<String>)`](crate::client::fluent_builders::BatchGetVariable::names) / [`set_names(Option<Vec<String>>)`](crate::client::fluent_builders::BatchGetVariable::set_names): <p>The list of variable names to get.</p>
    /// - On success, responds with [`BatchGetVariableOutput`](crate::output::BatchGetVariableOutput) with field(s):
    ///   - [`variables(Option<Vec<Variable>>)`](crate::output::BatchGetVariableOutput::variables): <p>The returned variables.</p>
    ///   - [`errors(Option<Vec<BatchGetVariableError>>)`](crate::output::BatchGetVariableOutput::errors): <p>The errors from the request.</p>
    /// - On failure, responds with [`SdkError<BatchGetVariableError>`](crate::error::BatchGetVariableError)
    pub fn batch_get_variable(&self) -> fluent_builders::BatchGetVariable {
        fluent_builders::BatchGetVariable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelBatchImportJob`](crate::client::fluent_builders::CancelBatchImportJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::CancelBatchImportJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::CancelBatchImportJob::set_job_id): <p> The ID of an in-progress batch import job to cancel. </p>  <p>Amazon Fraud Detector will throw an error if the batch import job is in <code>FAILED</code>, <code>CANCELED</code>, or <code>COMPLETED</code> state.</p>
    /// - On success, responds with [`CancelBatchImportJobOutput`](crate::output::CancelBatchImportJobOutput)

    /// - On failure, responds with [`SdkError<CancelBatchImportJobError>`](crate::error::CancelBatchImportJobError)
    pub fn cancel_batch_import_job(&self) -> fluent_builders::CancelBatchImportJob {
        fluent_builders::CancelBatchImportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelBatchPredictionJob`](crate::client::fluent_builders::CancelBatchPredictionJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::CancelBatchPredictionJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::CancelBatchPredictionJob::set_job_id): <p>The ID of the batch prediction job to cancel.</p>
    /// - On success, responds with [`CancelBatchPredictionJobOutput`](crate::output::CancelBatchPredictionJobOutput)

    /// - On failure, responds with [`SdkError<CancelBatchPredictionJobError>`](crate::error::CancelBatchPredictionJobError)
    pub fn cancel_batch_prediction_job(&self) -> fluent_builders::CancelBatchPredictionJob {
        fluent_builders::CancelBatchPredictionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateBatchImportJob`](crate::client::fluent_builders::CreateBatchImportJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::CreateBatchImportJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::CreateBatchImportJob::set_job_id): <p>The ID of the batch import job. The ID cannot be of a past job, unless the job exists in <code>CREATE_FAILED</code> state.</p>
    ///   - [`input_path(impl Into<String>)`](crate::client::fluent_builders::CreateBatchImportJob::input_path) / [`set_input_path(Option<String>)`](crate::client::fluent_builders::CreateBatchImportJob::set_input_path): <p>The URI that points to the Amazon S3 location of your data file.</p>
    ///   - [`output_path(impl Into<String>)`](crate::client::fluent_builders::CreateBatchImportJob::output_path) / [`set_output_path(Option<String>)`](crate::client::fluent_builders::CreateBatchImportJob::set_output_path): <p>The URI that points to the Amazon S3 location for storing your results. </p>
    ///   - [`event_type_name(impl Into<String>)`](crate::client::fluent_builders::CreateBatchImportJob::event_type_name) / [`set_event_type_name(Option<String>)`](crate::client::fluent_builders::CreateBatchImportJob::set_event_type_name): <p>The name of the event type.</p>
    ///   - [`iam_role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateBatchImportJob::iam_role_arn) / [`set_iam_role_arn(Option<String>)`](crate::client::fluent_builders::CreateBatchImportJob::set_iam_role_arn): <p>The ARN of the IAM role created for Amazon S3 bucket that holds your data file. The IAM role must have read and write permissions to both input and output S3 buckets.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateBatchImportJob::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateBatchImportJob::set_tags): <p>A collection of key-value pairs associated with this request. </p>
    /// - On success, responds with [`CreateBatchImportJobOutput`](crate::output::CreateBatchImportJobOutput)

    /// - On failure, responds with [`SdkError<CreateBatchImportJobError>`](crate::error::CreateBatchImportJobError)
    pub fn create_batch_import_job(&self) -> fluent_builders::CreateBatchImportJob {
        fluent_builders::CreateBatchImportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateBatchPredictionJob`](crate::client::fluent_builders::CreateBatchPredictionJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::CreateBatchPredictionJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::CreateBatchPredictionJob::set_job_id): <p>The ID of the batch prediction job.</p>
    ///   - [`input_path(impl Into<String>)`](crate::client::fluent_builders::CreateBatchPredictionJob::input_path) / [`set_input_path(Option<String>)`](crate::client::fluent_builders::CreateBatchPredictionJob::set_input_path): <p>The Amazon S3 location of your training file.</p>
    ///   - [`output_path(impl Into<String>)`](crate::client::fluent_builders::CreateBatchPredictionJob::output_path) / [`set_output_path(Option<String>)`](crate::client::fluent_builders::CreateBatchPredictionJob::set_output_path): <p>The Amazon S3 location of your output file.</p>
    ///   - [`event_type_name(impl Into<String>)`](crate::client::fluent_builders::CreateBatchPredictionJob::event_type_name) / [`set_event_type_name(Option<String>)`](crate::client::fluent_builders::CreateBatchPredictionJob::set_event_type_name): <p>The name of the event type.</p>
    ///   - [`detector_name(impl Into<String>)`](crate::client::fluent_builders::CreateBatchPredictionJob::detector_name) / [`set_detector_name(Option<String>)`](crate::client::fluent_builders::CreateBatchPredictionJob::set_detector_name): <p>The name of the detector.</p>
    ///   - [`detector_version(impl Into<String>)`](crate::client::fluent_builders::CreateBatchPredictionJob::detector_version) / [`set_detector_version(Option<String>)`](crate::client::fluent_builders::CreateBatchPredictionJob::set_detector_version): <p>The detector version.</p>
    ///   - [`iam_role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateBatchPredictionJob::iam_role_arn) / [`set_iam_role_arn(Option<String>)`](crate::client::fluent_builders::CreateBatchPredictionJob::set_iam_role_arn): <p>The ARN of the IAM role to use for this job request.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateBatchPredictionJob::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateBatchPredictionJob::set_tags): <p>A collection of key and value pairs.</p>
    /// - On success, responds with [`CreateBatchPredictionJobOutput`](crate::output::CreateBatchPredictionJobOutput)

    /// - On failure, responds with [`SdkError<CreateBatchPredictionJobError>`](crate::error::CreateBatchPredictionJobError)
    pub fn create_batch_prediction_job(&self) -> fluent_builders::CreateBatchPredictionJob {
        fluent_builders::CreateBatchPredictionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDetectorVersion`](crate::client::fluent_builders::CreateDetectorVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`detector_id(impl Into<String>)`](crate::client::fluent_builders::CreateDetectorVersion::detector_id) / [`set_detector_id(Option<String>)`](crate::client::fluent_builders::CreateDetectorVersion::set_detector_id): <p>The ID of the detector under which you want to create a new version.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateDetectorVersion::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateDetectorVersion::set_description): <p>The description of the detector version.</p>
    ///   - [`external_model_endpoints(Vec<String>)`](crate::client::fluent_builders::CreateDetectorVersion::external_model_endpoints) / [`set_external_model_endpoints(Option<Vec<String>>)`](crate::client::fluent_builders::CreateDetectorVersion::set_external_model_endpoints): <p>The Amazon Sagemaker model endpoints to include in the detector version.</p>
    ///   - [`rules(Vec<Rule>)`](crate::client::fluent_builders::CreateDetectorVersion::rules) / [`set_rules(Option<Vec<Rule>>)`](crate::client::fluent_builders::CreateDetectorVersion::set_rules): <p>The rules to include in the detector version.</p>
    ///   - [`model_versions(Vec<ModelVersion>)`](crate::client::fluent_builders::CreateDetectorVersion::model_versions) / [`set_model_versions(Option<Vec<ModelVersion>>)`](crate::client::fluent_builders::CreateDetectorVersion::set_model_versions): <p>The model versions to include in the detector version.</p>
    ///   - [`rule_execution_mode(RuleExecutionMode)`](crate::client::fluent_builders::CreateDetectorVersion::rule_execution_mode) / [`set_rule_execution_mode(Option<RuleExecutionMode>)`](crate::client::fluent_builders::CreateDetectorVersion::set_rule_execution_mode): <p>The rule execution mode for the rules included in the detector version.</p>  <p>You can define and edit the rule mode at the detector version level, when it is in draft status.</p>  <p>If you specify <code>FIRST_MATCHED</code>, Amazon Fraud Detector evaluates rules sequentially, first to last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule.</p>  <p>If you specifiy <code>ALL_MATCHED</code>, Amazon Fraud Detector evaluates all rules and returns the outcomes for all matched rules. </p>  <p>The default behavior is <code>FIRST_MATCHED</code>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDetectorVersion::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDetectorVersion::set_tags): <p>A collection of key and value pairs.</p>
    /// - On success, responds with [`CreateDetectorVersionOutput`](crate::output::CreateDetectorVersionOutput) with field(s):
    ///   - [`detector_id(Option<String>)`](crate::output::CreateDetectorVersionOutput::detector_id): <p>The ID for the created version's parent detector.</p>
    ///   - [`detector_version_id(Option<String>)`](crate::output::CreateDetectorVersionOutput::detector_version_id): <p>The ID for the created detector. </p>
    ///   - [`status(Option<DetectorVersionStatus>)`](crate::output::CreateDetectorVersionOutput::status): <p>The status of the detector version.</p>
    /// - On failure, responds with [`SdkError<CreateDetectorVersionError>`](crate::error::CreateDetectorVersionError)
    pub fn create_detector_version(&self) -> fluent_builders::CreateDetectorVersion {
        fluent_builders::CreateDetectorVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateModel`](crate::client::fluent_builders::CreateModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`model_id(impl Into<String>)`](crate::client::fluent_builders::CreateModel::model_id) / [`set_model_id(Option<String>)`](crate::client::fluent_builders::CreateModel::set_model_id): <p>The model ID.</p>
    ///   - [`model_type(ModelTypeEnum)`](crate::client::fluent_builders::CreateModel::model_type) / [`set_model_type(Option<ModelTypeEnum>)`](crate::client::fluent_builders::CreateModel::set_model_type): <p>The model type. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateModel::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateModel::set_description): <p>The model description. </p>
    ///   - [`event_type_name(impl Into<String>)`](crate::client::fluent_builders::CreateModel::event_type_name) / [`set_event_type_name(Option<String>)`](crate::client::fluent_builders::CreateModel::set_event_type_name): <p>The name of the event type.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateModel::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateModel::set_tags): <p>A collection of key and value pairs.</p>
    /// - On success, responds with [`CreateModelOutput`](crate::output::CreateModelOutput)

    /// - On failure, responds with [`SdkError<CreateModelError>`](crate::error::CreateModelError)
    pub fn create_model(&self) -> fluent_builders::CreateModel {
        fluent_builders::CreateModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateModelVersion`](crate::client::fluent_builders::CreateModelVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`model_id(impl Into<String>)`](crate::client::fluent_builders::CreateModelVersion::model_id) / [`set_model_id(Option<String>)`](crate::client::fluent_builders::CreateModelVersion::set_model_id): <p>The model ID. </p>
    ///   - [`model_type(ModelTypeEnum)`](crate::client::fluent_builders::CreateModelVersion::model_type) / [`set_model_type(Option<ModelTypeEnum>)`](crate::client::fluent_builders::CreateModelVersion::set_model_type): <p>The model type.</p>
    ///   - [`training_data_source(TrainingDataSourceEnum)`](crate::client::fluent_builders::CreateModelVersion::training_data_source) / [`set_training_data_source(Option<TrainingDataSourceEnum>)`](crate::client::fluent_builders::CreateModelVersion::set_training_data_source): <p>The training data source location in Amazon S3. </p>
    ///   - [`training_data_schema(TrainingDataSchema)`](crate::client::fluent_builders::CreateModelVersion::training_data_schema) / [`set_training_data_schema(Option<TrainingDataSchema>)`](crate::client::fluent_builders::CreateModelVersion::set_training_data_schema): <p>The training data schema.</p>
    ///   - [`external_events_detail(ExternalEventsDetail)`](crate::client::fluent_builders::CreateModelVersion::external_events_detail) / [`set_external_events_detail(Option<ExternalEventsDetail>)`](crate::client::fluent_builders::CreateModelVersion::set_external_events_detail): <p>Details of the external events data used for model version training. Required if <code>trainingDataSource</code> is <code>EXTERNAL_EVENTS</code>.</p>
    ///   - [`ingested_events_detail(IngestedEventsDetail)`](crate::client::fluent_builders::CreateModelVersion::ingested_events_detail) / [`set_ingested_events_detail(Option<IngestedEventsDetail>)`](crate::client::fluent_builders::CreateModelVersion::set_ingested_events_detail): <p>Details of the ingested events data used for model version training. Required if <code>trainingDataSource</code> is <code>INGESTED_EVENTS</code>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateModelVersion::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateModelVersion::set_tags): <p>A collection of key and value pairs.</p>
    /// - On success, responds with [`CreateModelVersionOutput`](crate::output::CreateModelVersionOutput) with field(s):
    ///   - [`model_id(Option<String>)`](crate::output::CreateModelVersionOutput::model_id): <p>The model ID.</p>
    ///   - [`model_type(Option<ModelTypeEnum>)`](crate::output::CreateModelVersionOutput::model_type): <p>The model type.</p>
    ///   - [`model_version_number(Option<String>)`](crate::output::CreateModelVersionOutput::model_version_number): <p>The model version number of the model version created.</p>
    ///   - [`status(Option<String>)`](crate::output::CreateModelVersionOutput::status): <p>The model version status. </p>
    /// - On failure, responds with [`SdkError<CreateModelVersionError>`](crate::error::CreateModelVersionError)
    pub fn create_model_version(&self) -> fluent_builders::CreateModelVersion {
        fluent_builders::CreateModelVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRule`](crate::client::fluent_builders::CreateRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_id(impl Into<String>)`](crate::client::fluent_builders::CreateRule::rule_id) / [`set_rule_id(Option<String>)`](crate::client::fluent_builders::CreateRule::set_rule_id): <p>The rule ID.</p>
    ///   - [`detector_id(impl Into<String>)`](crate::client::fluent_builders::CreateRule::detector_id) / [`set_detector_id(Option<String>)`](crate::client::fluent_builders::CreateRule::set_detector_id): <p>The detector ID for the rule's parent detector.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateRule::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateRule::set_description): <p>The rule description.</p>
    ///   - [`expression(impl Into<String>)`](crate::client::fluent_builders::CreateRule::expression) / [`set_expression(Option<String>)`](crate::client::fluent_builders::CreateRule::set_expression): <p>The rule expression.</p>
    ///   - [`language(Language)`](crate::client::fluent_builders::CreateRule::language) / [`set_language(Option<Language>)`](crate::client::fluent_builders::CreateRule::set_language): <p>The language of the rule.</p>
    ///   - [`outcomes(Vec<String>)`](crate::client::fluent_builders::CreateRule::outcomes) / [`set_outcomes(Option<Vec<String>>)`](crate::client::fluent_builders::CreateRule::set_outcomes): <p>The outcome or outcomes returned when the rule expression matches.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateRule::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateRule::set_tags): <p>A collection of key and value pairs.</p>
    /// - On success, responds with [`CreateRuleOutput`](crate::output::CreateRuleOutput) with field(s):
    ///   - [`rule(Option<Rule>)`](crate::output::CreateRuleOutput::rule): <p>The created rule.</p>
    /// - On failure, responds with [`SdkError<CreateRuleError>`](crate::error::CreateRuleError)
    pub fn create_rule(&self) -> fluent_builders::CreateRule {
        fluent_builders::CreateRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateVariable`](crate::client::fluent_builders::CreateVariable) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateVariable::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateVariable::set_name): <p>The name of the variable.</p>
    ///   - [`data_type(DataType)`](crate::client::fluent_builders::CreateVariable::data_type) / [`set_data_type(Option<DataType>)`](crate::client::fluent_builders::CreateVariable::set_data_type): <p>The data type.</p>
    ///   - [`data_source(DataSource)`](crate::client::fluent_builders::CreateVariable::data_source) / [`set_data_source(Option<DataSource>)`](crate::client::fluent_builders::CreateVariable::set_data_source): <p>The source of the data.</p>
    ///   - [`default_value(impl Into<String>)`](crate::client::fluent_builders::CreateVariable::default_value) / [`set_default_value(Option<String>)`](crate::client::fluent_builders::CreateVariable::set_default_value): <p>The default value for the variable when no value is received.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateVariable::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateVariable::set_description): <p>The description.</p>
    ///   - [`variable_type(impl Into<String>)`](crate::client::fluent_builders::CreateVariable::variable_type) / [`set_variable_type(Option<String>)`](crate::client::fluent_builders::CreateVariable::set_variable_type): <p>The variable type. For more information see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable types</a>. </p>  <p>Valid Values: <code>AUTH_CODE | AVS | BILLING_ADDRESS_L1 | BILLING_ADDRESS_L2 | BILLING_CITY | BILLING_COUNTRY | BILLING_NAME | BILLING_PHONE | BILLING_STATE | BILLING_ZIP | CARD_BIN | CATEGORICAL | CURRENCY_CODE | EMAIL_ADDRESS | FINGERPRINT | FRAUD_LABEL | FREE_FORM_TEXT | IP_ADDRESS | NUMERIC | ORDER_ID | PAYMENT_TYPE | PHONE_NUMBER | PRICE | PRODUCT_CATEGORY | SHIPPING_ADDRESS_L1 | SHIPPING_ADDRESS_L2 | SHIPPING_CITY | SHIPPING_COUNTRY | SHIPPING_NAME | SHIPPING_PHONE | SHIPPING_STATE | SHIPPING_ZIP | USERAGENT</code> </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateVariable::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateVariable::set_tags): <p>A collection of key and value pairs.</p>
    /// - On success, responds with [`CreateVariableOutput`](crate::output::CreateVariableOutput)

    /// - On failure, responds with [`SdkError<CreateVariableError>`](crate::error::CreateVariableError)
    pub fn create_variable(&self) -> fluent_builders::CreateVariable {
        fluent_builders::CreateVariable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBatchImportJob`](crate::client::fluent_builders::DeleteBatchImportJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::DeleteBatchImportJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::DeleteBatchImportJob::set_job_id): <p>The ID of the batch import job to delete. </p>
    /// - On success, responds with [`DeleteBatchImportJobOutput`](crate::output::DeleteBatchImportJobOutput)

    /// - On failure, responds with [`SdkError<DeleteBatchImportJobError>`](crate::error::DeleteBatchImportJobError)
    pub fn delete_batch_import_job(&self) -> fluent_builders::DeleteBatchImportJob {
        fluent_builders::DeleteBatchImportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBatchPredictionJob`](crate::client::fluent_builders::DeleteBatchPredictionJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::DeleteBatchPredictionJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::DeleteBatchPredictionJob::set_job_id): <p>The ID of the batch prediction job to delete.</p>
    /// - On success, responds with [`DeleteBatchPredictionJobOutput`](crate::output::DeleteBatchPredictionJobOutput)

    /// - On failure, responds with [`SdkError<DeleteBatchPredictionJobError>`](crate::error::DeleteBatchPredictionJobError)
    pub fn delete_batch_prediction_job(&self) -> fluent_builders::DeleteBatchPredictionJob {
        fluent_builders::DeleteBatchPredictionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDetector`](crate::client::fluent_builders::DeleteDetector) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`detector_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDetector::detector_id) / [`set_detector_id(Option<String>)`](crate::client::fluent_builders::DeleteDetector::set_detector_id): <p>The ID of the detector to delete.</p>
    /// - On success, responds with [`DeleteDetectorOutput`](crate::output::DeleteDetectorOutput)

    /// - On failure, responds with [`SdkError<DeleteDetectorError>`](crate::error::DeleteDetectorError)
    pub fn delete_detector(&self) -> fluent_builders::DeleteDetector {
        fluent_builders::DeleteDetector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDetectorVersion`](crate::client::fluent_builders::DeleteDetectorVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`detector_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDetectorVersion::detector_id) / [`set_detector_id(Option<String>)`](crate::client::fluent_builders::DeleteDetectorVersion::set_detector_id): <p>The ID of the parent detector for the detector version to delete.</p>
    ///   - [`detector_version_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDetectorVersion::detector_version_id) / [`set_detector_version_id(Option<String>)`](crate::client::fluent_builders::DeleteDetectorVersion::set_detector_version_id): <p>The ID of the detector version to delete.</p>
    /// - On success, responds with [`DeleteDetectorVersionOutput`](crate::output::DeleteDetectorVersionOutput)

    /// - On failure, responds with [`SdkError<DeleteDetectorVersionError>`](crate::error::DeleteDetectorVersionError)
    pub fn delete_detector_version(&self) -> fluent_builders::DeleteDetectorVersion {
        fluent_builders::DeleteDetectorVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEntityType`](crate::client::fluent_builders::DeleteEntityType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteEntityType::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteEntityType::set_name): <p>The name of the entity type to delete.</p>
    /// - On success, responds with [`DeleteEntityTypeOutput`](crate::output::DeleteEntityTypeOutput)

    /// - On failure, responds with [`SdkError<DeleteEntityTypeError>`](crate::error::DeleteEntityTypeError)
    pub fn delete_entity_type(&self) -> fluent_builders::DeleteEntityType {
        fluent_builders::DeleteEntityType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEvent`](crate::client::fluent_builders::DeleteEvent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`event_id(impl Into<String>)`](crate::client::fluent_builders::DeleteEvent::event_id) / [`set_event_id(Option<String>)`](crate::client::fluent_builders::DeleteEvent::set_event_id): <p>The ID of the event to delete.</p>
    ///   - [`event_type_name(impl Into<String>)`](crate::client::fluent_builders::DeleteEvent::event_type_name) / [`set_event_type_name(Option<String>)`](crate::client::fluent_builders::DeleteEvent::set_event_type_name): <p>The name of the event type.</p>
    ///   - [`delete_audit_history(bool)`](crate::client::fluent_builders::DeleteEvent::delete_audit_history) / [`set_delete_audit_history(Option<bool>)`](crate::client::fluent_builders::DeleteEvent::set_delete_audit_history): <p>Specifies whether or not to delete any predictions associated with the event.</p>
    /// - On success, responds with [`DeleteEventOutput`](crate::output::DeleteEventOutput)

    /// - On failure, responds with [`SdkError<DeleteEventError>`](crate::error::DeleteEventError)
    pub fn delete_event(&self) -> fluent_builders::DeleteEvent {
        fluent_builders::DeleteEvent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEventsByEventType`](crate::client::fluent_builders::DeleteEventsByEventType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`event_type_name(impl Into<String>)`](crate::client::fluent_builders::DeleteEventsByEventType::event_type_name) / [`set_event_type_name(Option<String>)`](crate::client::fluent_builders::DeleteEventsByEventType::set_event_type_name): <p>The name of the event type.</p>
    /// - On success, responds with [`DeleteEventsByEventTypeOutput`](crate::output::DeleteEventsByEventTypeOutput) with field(s):
    ///   - [`event_type_name(Option<String>)`](crate::output::DeleteEventsByEventTypeOutput::event_type_name): <p>Name of event type for which to delete the events.</p>
    ///   - [`events_deletion_status(Option<String>)`](crate::output::DeleteEventsByEventTypeOutput::events_deletion_status): <p>The status of the delete request.</p>
    /// - On failure, responds with [`SdkError<DeleteEventsByEventTypeError>`](crate::error::DeleteEventsByEventTypeError)
    pub fn delete_events_by_event_type(&self) -> fluent_builders::DeleteEventsByEventType {
        fluent_builders::DeleteEventsByEventType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEventType`](crate::client::fluent_builders::DeleteEventType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteEventType::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteEventType::set_name): <p>The name of the event type to delete.</p>
    /// - On success, responds with [`DeleteEventTypeOutput`](crate::output::DeleteEventTypeOutput)

    /// - On failure, responds with [`SdkError<DeleteEventTypeError>`](crate::error::DeleteEventTypeError)
    pub fn delete_event_type(&self) -> fluent_builders::DeleteEventType {
        fluent_builders::DeleteEventType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteExternalModel`](crate::client::fluent_builders::DeleteExternalModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`model_endpoint(impl Into<String>)`](crate::client::fluent_builders::DeleteExternalModel::model_endpoint) / [`set_model_endpoint(Option<String>)`](crate::client::fluent_builders::DeleteExternalModel::set_model_endpoint): <p>The endpoint of the Amazon Sagemaker model to delete.</p>
    /// - On success, responds with [`DeleteExternalModelOutput`](crate::output::DeleteExternalModelOutput)

    /// - On failure, responds with [`SdkError<DeleteExternalModelError>`](crate::error::DeleteExternalModelError)
    pub fn delete_external_model(&self) -> fluent_builders::DeleteExternalModel {
        fluent_builders::DeleteExternalModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteLabel`](crate::client::fluent_builders::DeleteLabel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteLabel::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteLabel::set_name): <p>The name of the label to delete.</p>
    /// - On success, responds with [`DeleteLabelOutput`](crate::output::DeleteLabelOutput)

    /// - On failure, responds with [`SdkError<DeleteLabelError>`](crate::error::DeleteLabelError)
    pub fn delete_label(&self) -> fluent_builders::DeleteLabel {
        fluent_builders::DeleteLabel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteModel`](crate::client::fluent_builders::DeleteModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`model_id(impl Into<String>)`](crate::client::fluent_builders::DeleteModel::model_id) / [`set_model_id(Option<String>)`](crate::client::fluent_builders::DeleteModel::set_model_id): <p>The model ID of the model to delete.</p>
    ///   - [`model_type(ModelTypeEnum)`](crate::client::fluent_builders::DeleteModel::model_type) / [`set_model_type(Option<ModelTypeEnum>)`](crate::client::fluent_builders::DeleteModel::set_model_type): <p>The model type of the model to delete.</p>
    /// - On success, responds with [`DeleteModelOutput`](crate::output::DeleteModelOutput)

    /// - On failure, responds with [`SdkError<DeleteModelError>`](crate::error::DeleteModelError)
    pub fn delete_model(&self) -> fluent_builders::DeleteModel {
        fluent_builders::DeleteModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteModelVersion`](crate::client::fluent_builders::DeleteModelVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`model_id(impl Into<String>)`](crate::client::fluent_builders::DeleteModelVersion::model_id) / [`set_model_id(Option<String>)`](crate::client::fluent_builders::DeleteModelVersion::set_model_id): <p>The model ID of the model version to delete.</p>
    ///   - [`model_type(ModelTypeEnum)`](crate::client::fluent_builders::DeleteModelVersion::model_type) / [`set_model_type(Option<ModelTypeEnum>)`](crate::client::fluent_builders::DeleteModelVersion::set_model_type): <p>The model type of the model version to delete.</p>
    ///   - [`model_version_number(impl Into<String>)`](crate::client::fluent_builders::DeleteModelVersion::model_version_number) / [`set_model_version_number(Option<String>)`](crate::client::fluent_builders::DeleteModelVersion::set_model_version_number): <p>The model version number of the model version to delete.</p>
    /// - On success, responds with [`DeleteModelVersionOutput`](crate::output::DeleteModelVersionOutput)

    /// - On failure, responds with [`SdkError<DeleteModelVersionError>`](crate::error::DeleteModelVersionError)
    pub fn delete_model_version(&self) -> fluent_builders::DeleteModelVersion {
        fluent_builders::DeleteModelVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteOutcome`](crate::client::fluent_builders::DeleteOutcome) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteOutcome::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteOutcome::set_name): <p>The name of the outcome to delete.</p>
    /// - On success, responds with [`DeleteOutcomeOutput`](crate::output::DeleteOutcomeOutput)

    /// - On failure, responds with [`SdkError<DeleteOutcomeError>`](crate::error::DeleteOutcomeError)
    pub fn delete_outcome(&self) -> fluent_builders::DeleteOutcome {
        fluent_builders::DeleteOutcome::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRule`](crate::client::fluent_builders::DeleteRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule(Rule)`](crate::client::fluent_builders::DeleteRule::rule) / [`set_rule(Option<Rule>)`](crate::client::fluent_builders::DeleteRule::set_rule): <p>A rule.</p>
    /// - On success, responds with [`DeleteRuleOutput`](crate::output::DeleteRuleOutput)

    /// - On failure, responds with [`SdkError<DeleteRuleError>`](crate::error::DeleteRuleError)
    pub fn delete_rule(&self) -> fluent_builders::DeleteRule {
        fluent_builders::DeleteRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVariable`](crate::client::fluent_builders::DeleteVariable) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteVariable::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteVariable::set_name): <p>The name of the variable to delete.</p>
    /// - On success, responds with [`DeleteVariableOutput`](crate::output::DeleteVariableOutput)

    /// - On failure, responds with [`SdkError<DeleteVariableError>`](crate::error::DeleteVariableError)
    pub fn delete_variable(&self) -> fluent_builders::DeleteVariable {
        fluent_builders::DeleteVariable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDetector`](crate::client::fluent_builders::DescribeDetector) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`detector_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDetector::detector_id) / [`set_detector_id(Option<String>)`](crate::client::fluent_builders::DescribeDetector::set_detector_id): <p>The detector ID.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeDetector::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeDetector::set_next_token): <p>The next token from the previous response.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeDetector::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeDetector::set_max_results): <p>The maximum number of results to return for the request.</p>
    /// - On success, responds with [`DescribeDetectorOutput`](crate::output::DescribeDetectorOutput) with field(s):
    ///   - [`detector_id(Option<String>)`](crate::output::DescribeDetectorOutput::detector_id): <p>The detector ID.</p>
    ///   - [`detector_version_summaries(Option<Vec<DetectorVersionSummary>>)`](crate::output::DescribeDetectorOutput::detector_version_summaries): <p>The status and description for each detector version.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeDetectorOutput::next_token): <p>The next token to be used for subsequent requests.</p>
    ///   - [`arn(Option<String>)`](crate::output::DescribeDetectorOutput::arn): <p>The detector ARN.</p>
    /// - On failure, responds with [`SdkError<DescribeDetectorError>`](crate::error::DescribeDetectorError)
    pub fn describe_detector(&self) -> fluent_builders::DescribeDetector {
        fluent_builders::DescribeDetector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeModelVersions`](crate::client::fluent_builders::DescribeModelVersions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeModelVersions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`model_id(impl Into<String>)`](crate::client::fluent_builders::DescribeModelVersions::model_id) / [`set_model_id(Option<String>)`](crate::client::fluent_builders::DescribeModelVersions::set_model_id): <p>The model ID.</p>
    ///   - [`model_version_number(impl Into<String>)`](crate::client::fluent_builders::DescribeModelVersions::model_version_number) / [`set_model_version_number(Option<String>)`](crate::client::fluent_builders::DescribeModelVersions::set_model_version_number): <p>The model version number.</p>
    ///   - [`model_type(ModelTypeEnum)`](crate::client::fluent_builders::DescribeModelVersions::model_type) / [`set_model_type(Option<ModelTypeEnum>)`](crate::client::fluent_builders::DescribeModelVersions::set_model_type): <p>The model type.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeModelVersions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeModelVersions::set_next_token): <p>The next token from the previous results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeModelVersions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeModelVersions::set_max_results): <p>The maximum number of results to return.</p>
    /// - On success, responds with [`DescribeModelVersionsOutput`](crate::output::DescribeModelVersionsOutput) with field(s):
    ///   - [`model_version_details(Option<Vec<ModelVersionDetail>>)`](crate::output::DescribeModelVersionsOutput::model_version_details): <p>The model version details.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeModelVersionsOutput::next_token): <p>The next token.</p>
    /// - On failure, responds with [`SdkError<DescribeModelVersionsError>`](crate::error::DescribeModelVersionsError)
    pub fn describe_model_versions(&self) -> fluent_builders::DescribeModelVersions {
        fluent_builders::DescribeModelVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBatchImportJobs`](crate::client::fluent_builders::GetBatchImportJobs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetBatchImportJobs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::GetBatchImportJobs::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::GetBatchImportJobs::set_job_id): <p>The ID of the batch import job to get.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetBatchImportJobs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetBatchImportJobs::set_max_results): <p>The maximum number of objects to return for request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetBatchImportJobs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetBatchImportJobs::set_next_token): <p>The next token from the previous request.</p>
    /// - On success, responds with [`GetBatchImportJobsOutput`](crate::output::GetBatchImportJobsOutput) with field(s):
    ///   - [`batch_imports(Option<Vec<BatchImport>>)`](crate::output::GetBatchImportJobsOutput::batch_imports): <p>An array containing the details of each batch import job.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetBatchImportJobsOutput::next_token): <p>The next token for the subsequent resquest.</p>
    /// - On failure, responds with [`SdkError<GetBatchImportJobsError>`](crate::error::GetBatchImportJobsError)
    pub fn get_batch_import_jobs(&self) -> fluent_builders::GetBatchImportJobs {
        fluent_builders::GetBatchImportJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBatchPredictionJobs`](crate::client::fluent_builders::GetBatchPredictionJobs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetBatchPredictionJobs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::GetBatchPredictionJobs::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::GetBatchPredictionJobs::set_job_id): <p>The batch prediction job for which to get the details.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetBatchPredictionJobs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetBatchPredictionJobs::set_max_results): <p>The maximum number of objects to return for the request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetBatchPredictionJobs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetBatchPredictionJobs::set_next_token): <p>The next token from the previous request.</p>
    /// - On success, responds with [`GetBatchPredictionJobsOutput`](crate::output::GetBatchPredictionJobsOutput) with field(s):
    ///   - [`batch_predictions(Option<Vec<BatchPrediction>>)`](crate::output::GetBatchPredictionJobsOutput::batch_predictions): <p>An array containing the details of each batch prediction job.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetBatchPredictionJobsOutput::next_token): <p>The next token for the subsequent request.</p>
    /// - On failure, responds with [`SdkError<GetBatchPredictionJobsError>`](crate::error::GetBatchPredictionJobsError)
    pub fn get_batch_prediction_jobs(&self) -> fluent_builders::GetBatchPredictionJobs {
        fluent_builders::GetBatchPredictionJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDeleteEventsByEventTypeStatus`](crate::client::fluent_builders::GetDeleteEventsByEventTypeStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`event_type_name(impl Into<String>)`](crate::client::fluent_builders::GetDeleteEventsByEventTypeStatus::event_type_name) / [`set_event_type_name(Option<String>)`](crate::client::fluent_builders::GetDeleteEventsByEventTypeStatus::set_event_type_name): <p>Name of event type for which to get the deletion status.</p>
    /// - On success, responds with [`GetDeleteEventsByEventTypeStatusOutput`](crate::output::GetDeleteEventsByEventTypeStatusOutput) with field(s):
    ///   - [`event_type_name(Option<String>)`](crate::output::GetDeleteEventsByEventTypeStatusOutput::event_type_name): <p>The event type name.</p>
    ///   - [`events_deletion_status(Option<AsyncJobStatus>)`](crate::output::GetDeleteEventsByEventTypeStatusOutput::events_deletion_status): <p>The deletion status.</p>
    /// - On failure, responds with [`SdkError<GetDeleteEventsByEventTypeStatusError>`](crate::error::GetDeleteEventsByEventTypeStatusError)
    pub fn get_delete_events_by_event_type_status(
        &self,
    ) -> fluent_builders::GetDeleteEventsByEventTypeStatus {
        fluent_builders::GetDeleteEventsByEventTypeStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDetectors`](crate::client::fluent_builders::GetDetectors) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetDetectors::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`detector_id(impl Into<String>)`](crate::client::fluent_builders::GetDetectors::detector_id) / [`set_detector_id(Option<String>)`](crate::client::fluent_builders::GetDetectors::set_detector_id): <p>The detector ID.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetDetectors::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetDetectors::set_next_token): <p>The next token for the subsequent request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetDetectors::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetDetectors::set_max_results): <p>The maximum number of objects to return for the request.</p>
    /// - On success, responds with [`GetDetectorsOutput`](crate::output::GetDetectorsOutput) with field(s):
    ///   - [`detectors(Option<Vec<Detector>>)`](crate::output::GetDetectorsOutput::detectors): <p>The detectors.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetDetectorsOutput::next_token): <p>The next page token.</p>
    /// - On failure, responds with [`SdkError<GetDetectorsError>`](crate::error::GetDetectorsError)
    pub fn get_detectors(&self) -> fluent_builders::GetDetectors {
        fluent_builders::GetDetectors::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDetectorVersion`](crate::client::fluent_builders::GetDetectorVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`detector_id(impl Into<String>)`](crate::client::fluent_builders::GetDetectorVersion::detector_id) / [`set_detector_id(Option<String>)`](crate::client::fluent_builders::GetDetectorVersion::set_detector_id): <p>The detector ID.</p>
    ///   - [`detector_version_id(impl Into<String>)`](crate::client::fluent_builders::GetDetectorVersion::detector_version_id) / [`set_detector_version_id(Option<String>)`](crate::client::fluent_builders::GetDetectorVersion::set_detector_version_id): <p>The detector version ID.</p>
    /// - On success, responds with [`GetDetectorVersionOutput`](crate::output::GetDetectorVersionOutput) with field(s):
    ///   - [`detector_id(Option<String>)`](crate::output::GetDetectorVersionOutput::detector_id): <p>The detector ID.</p>
    ///   - [`detector_version_id(Option<String>)`](crate::output::GetDetectorVersionOutput::detector_version_id): <p>The detector version ID.</p>
    ///   - [`description(Option<String>)`](crate::output::GetDetectorVersionOutput::description): <p>The detector version description.</p>
    ///   - [`external_model_endpoints(Option<Vec<String>>)`](crate::output::GetDetectorVersionOutput::external_model_endpoints): <p>The Amazon SageMaker model endpoints included in the detector version.</p>
    ///   - [`model_versions(Option<Vec<ModelVersion>>)`](crate::output::GetDetectorVersionOutput::model_versions): <p>The model versions included in the detector version. </p>
    ///   - [`rules(Option<Vec<Rule>>)`](crate::output::GetDetectorVersionOutput::rules): <p>The rules included in the detector version.</p>
    ///   - [`status(Option<DetectorVersionStatus>)`](crate::output::GetDetectorVersionOutput::status): <p>The status of the detector version.</p>
    ///   - [`last_updated_time(Option<String>)`](crate::output::GetDetectorVersionOutput::last_updated_time): <p>The timestamp when the detector version was last updated. </p>
    ///   - [`created_time(Option<String>)`](crate::output::GetDetectorVersionOutput::created_time): <p>The timestamp when the detector version was created. </p>
    ///   - [`rule_execution_mode(Option<RuleExecutionMode>)`](crate::output::GetDetectorVersionOutput::rule_execution_mode): <p>The execution mode of the rule in the dectector</p>  <p> <code>FIRST_MATCHED</code> indicates that Amazon Fraud Detector evaluates rules sequentially, first to last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule.</p>  <p> <code>ALL_MATCHED</code> indicates that Amazon Fraud Detector evaluates all rules and returns the outcomes for all matched rules. You can define and edit the rule mode at the detector version level, when it is in draft status.</p>
    ///   - [`arn(Option<String>)`](crate::output::GetDetectorVersionOutput::arn): <p>The detector version ARN.</p>
    /// - On failure, responds with [`SdkError<GetDetectorVersionError>`](crate::error::GetDetectorVersionError)
    pub fn get_detector_version(&self) -> fluent_builders::GetDetectorVersion {
        fluent_builders::GetDetectorVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetEntityTypes`](crate::client::fluent_builders::GetEntityTypes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetEntityTypes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetEntityTypes::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetEntityTypes::set_name): <p>The name.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetEntityTypes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetEntityTypes::set_next_token): <p>The next token for the subsequent request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetEntityTypes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetEntityTypes::set_max_results): <p>The maximum number of objects to return for the request.</p>
    /// - On success, responds with [`GetEntityTypesOutput`](crate::output::GetEntityTypesOutput) with field(s):
    ///   - [`entity_types(Option<Vec<EntityType>>)`](crate::output::GetEntityTypesOutput::entity_types): <p>An array of entity types.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetEntityTypesOutput::next_token): <p>The next page token.</p>
    /// - On failure, responds with [`SdkError<GetEntityTypesError>`](crate::error::GetEntityTypesError)
    pub fn get_entity_types(&self) -> fluent_builders::GetEntityTypes {
        fluent_builders::GetEntityTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetEvent`](crate::client::fluent_builders::GetEvent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`event_id(impl Into<String>)`](crate::client::fluent_builders::GetEvent::event_id) / [`set_event_id(Option<String>)`](crate::client::fluent_builders::GetEvent::set_event_id): <p>The ID of the event to retrieve.</p>
    ///   - [`event_type_name(impl Into<String>)`](crate::client::fluent_builders::GetEvent::event_type_name) / [`set_event_type_name(Option<String>)`](crate::client::fluent_builders::GetEvent::set_event_type_name): <p>The event type of the event to retrieve.</p>
    /// - On success, responds with [`GetEventOutput`](crate::output::GetEventOutput) with field(s):
    ///   - [`event(Option<Event>)`](crate::output::GetEventOutput::event): <p>The details of the event.</p>
    /// - On failure, responds with [`SdkError<GetEventError>`](crate::error::GetEventError)
    pub fn get_event(&self) -> fluent_builders::GetEvent {
        fluent_builders::GetEvent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetEventPrediction`](crate::client::fluent_builders::GetEventPrediction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`detector_id(impl Into<String>)`](crate::client::fluent_builders::GetEventPrediction::detector_id) / [`set_detector_id(Option<String>)`](crate::client::fluent_builders::GetEventPrediction::set_detector_id): <p>The detector ID.</p>
    ///   - [`detector_version_id(impl Into<String>)`](crate::client::fluent_builders::GetEventPrediction::detector_version_id) / [`set_detector_version_id(Option<String>)`](crate::client::fluent_builders::GetEventPrediction::set_detector_version_id): <p>The detector version ID.</p>
    ///   - [`event_id(impl Into<String>)`](crate::client::fluent_builders::GetEventPrediction::event_id) / [`set_event_id(Option<String>)`](crate::client::fluent_builders::GetEventPrediction::set_event_id): <p>The unique ID used to identify the event.</p>
    ///   - [`event_type_name(impl Into<String>)`](crate::client::fluent_builders::GetEventPrediction::event_type_name) / [`set_event_type_name(Option<String>)`](crate::client::fluent_builders::GetEventPrediction::set_event_type_name): <p>The event type associated with the detector specified for the prediction.</p>
    ///   - [`entities(Vec<Entity>)`](crate::client::fluent_builders::GetEventPrediction::entities) / [`set_entities(Option<Vec<Entity>>)`](crate::client::fluent_builders::GetEventPrediction::set_entities): <p>The entity type (associated with the detector's event type) and specific entity ID representing who performed the event. If an entity id is not available, use "UNKNOWN."</p>
    ///   - [`event_timestamp(impl Into<String>)`](crate::client::fluent_builders::GetEventPrediction::event_timestamp) / [`set_event_timestamp(Option<String>)`](crate::client::fluent_builders::GetEventPrediction::set_event_timestamp): <p>Timestamp that defines when the event under evaluation occurred. The timestamp must be specified using ISO 8601 standard in UTC.</p>
    ///   - [`event_variables(HashMap<String, String>)`](crate::client::fluent_builders::GetEventPrediction::event_variables) / [`set_event_variables(Option<HashMap<String, String>>)`](crate::client::fluent_builders::GetEventPrediction::set_event_variables): <p>Names of the event type's variables you defined in Amazon Fraud Detector to represent data elements and their corresponding values for the event you are sending for evaluation.</p> <important>   <p>You must provide at least one eventVariable</p>  </important>  <p>To ensure most accurate fraud prediction and to simplify your data preparation, Amazon Fraud Detector will replace all missing variables or values as follows:</p>  <p> <b>For Amazon Fraud Detector trained models:</b> </p>  <p>If a null value is provided explicitly for a variable or if a variable is missing, model will replace the null value or the missing variable (no variable name in the eventVariables map) with calculated default mean/medians for numeric variables and with special values for categorical variables.</p>  <p> <b>For imported SageMaker models:</b> </p>  <p>If a null value is provided explicitly for a variable, the model and rules will use “null” as the value. If a variable is not provided (no variable name in the eventVariables map), model and rules will use the default value that is provided for the variable. </p>
    ///   - [`external_model_endpoint_data_blobs(HashMap<String, ModelEndpointDataBlob>)`](crate::client::fluent_builders::GetEventPrediction::external_model_endpoint_data_blobs) / [`set_external_model_endpoint_data_blobs(Option<HashMap<String, ModelEndpointDataBlob>>)`](crate::client::fluent_builders::GetEventPrediction::set_external_model_endpoint_data_blobs): <p>The Amazon SageMaker model endpoint input data blobs.</p>
    /// - On success, responds with [`GetEventPredictionOutput`](crate::output::GetEventPredictionOutput) with field(s):
    ///   - [`model_scores(Option<Vec<ModelScores>>)`](crate::output::GetEventPredictionOutput::model_scores): <p>The model scores. Amazon Fraud Detector generates model scores between 0 and 1000, where 0 is low fraud risk and 1000 is high fraud risk. Model scores are directly related to the false positive rate (FPR). For example, a score of 600 corresponds to an estimated 10% false positive rate whereas a score of 900 corresponds to an estimated 2% false positive rate.</p>
    ///   - [`rule_results(Option<Vec<RuleResult>>)`](crate::output::GetEventPredictionOutput::rule_results): <p>The results from the rules.</p>
    ///   - [`external_model_outputs(Option<Vec<ExternalModelOutputs>>)`](crate::output::GetEventPredictionOutput::external_model_outputs): <p>The model scores for Amazon SageMaker models.</p>
    /// - On failure, responds with [`SdkError<GetEventPredictionError>`](crate::error::GetEventPredictionError)
    pub fn get_event_prediction(&self) -> fluent_builders::GetEventPrediction {
        fluent_builders::GetEventPrediction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetEventPredictionMetadata`](crate::client::fluent_builders::GetEventPredictionMetadata) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`event_id(impl Into<String>)`](crate::client::fluent_builders::GetEventPredictionMetadata::event_id) / [`set_event_id(Option<String>)`](crate::client::fluent_builders::GetEventPredictionMetadata::set_event_id): <p> The event ID. </p>
    ///   - [`event_type_name(impl Into<String>)`](crate::client::fluent_builders::GetEventPredictionMetadata::event_type_name) / [`set_event_type_name(Option<String>)`](crate::client::fluent_builders::GetEventPredictionMetadata::set_event_type_name): <p> The event type associated with the detector specified for the prediction. </p>
    ///   - [`detector_id(impl Into<String>)`](crate::client::fluent_builders::GetEventPredictionMetadata::detector_id) / [`set_detector_id(Option<String>)`](crate::client::fluent_builders::GetEventPredictionMetadata::set_detector_id): <p> The detector ID. </p>
    ///   - [`detector_version_id(impl Into<String>)`](crate::client::fluent_builders::GetEventPredictionMetadata::detector_version_id) / [`set_detector_version_id(Option<String>)`](crate::client::fluent_builders::GetEventPredictionMetadata::set_detector_version_id): <p> The detector version ID. </p>
    ///   - [`prediction_timestamp(impl Into<String>)`](crate::client::fluent_builders::GetEventPredictionMetadata::prediction_timestamp) / [`set_prediction_timestamp(Option<String>)`](crate::client::fluent_builders::GetEventPredictionMetadata::set_prediction_timestamp): <p> The timestamp that defines when the prediction was generated. </p>
    /// - On success, responds with [`GetEventPredictionMetadataOutput`](crate::output::GetEventPredictionMetadataOutput) with field(s):
    ///   - [`event_id(Option<String>)`](crate::output::GetEventPredictionMetadataOutput::event_id): <p> The event ID. </p>
    ///   - [`event_type_name(Option<String>)`](crate::output::GetEventPredictionMetadataOutput::event_type_name): <p> The event type associated with the detector specified for this prediction. </p>
    ///   - [`entity_id(Option<String>)`](crate::output::GetEventPredictionMetadataOutput::entity_id): <p> The entity ID. </p>
    ///   - [`entity_type(Option<String>)`](crate::output::GetEventPredictionMetadataOutput::entity_type): <p> The entity type. </p>
    ///   - [`event_timestamp(Option<String>)`](crate::output::GetEventPredictionMetadataOutput::event_timestamp): <p> The timestamp for when the prediction was generated for the associated event ID. </p>
    ///   - [`detector_id(Option<String>)`](crate::output::GetEventPredictionMetadataOutput::detector_id): <p> The detector ID. </p>
    ///   - [`detector_version_id(Option<String>)`](crate::output::GetEventPredictionMetadataOutput::detector_version_id): <p> The detector version ID. </p>
    ///   - [`detector_version_status(Option<String>)`](crate::output::GetEventPredictionMetadataOutput::detector_version_status): <p> The status of the detector version. </p>
    ///   - [`event_variables(Option<Vec<EventVariableSummary>>)`](crate::output::GetEventPredictionMetadataOutput::event_variables): <p> A list of event variables that influenced the prediction scores. </p>
    ///   - [`rules(Option<Vec<EvaluatedRule>>)`](crate::output::GetEventPredictionMetadataOutput::rules): <p> List of rules associated with the detector version that were used for evaluating variable values. </p>
    ///   - [`rule_execution_mode(Option<RuleExecutionMode>)`](crate::output::GetEventPredictionMetadataOutput::rule_execution_mode): <p> The execution mode of the rule used for evaluating variable values. </p>
    ///   - [`outcomes(Option<Vec<String>>)`](crate::output::GetEventPredictionMetadataOutput::outcomes): <p> The outcomes of the matched rule, based on the rule execution mode. </p>
    ///   - [`evaluated_model_versions(Option<Vec<EvaluatedModelVersion>>)`](crate::output::GetEventPredictionMetadataOutput::evaluated_model_versions): <p> Model versions that were evaluated for generating predictions. </p>
    ///   - [`evaluated_external_models(Option<Vec<EvaluatedExternalModel>>)`](crate::output::GetEventPredictionMetadataOutput::evaluated_external_models): <p> External (Amazon SageMaker) models that were evaluated for generating predictions. </p>
    ///   - [`prediction_timestamp(Option<String>)`](crate::output::GetEventPredictionMetadataOutput::prediction_timestamp): <p>The timestamp that defines when the prediction was generated. </p>
    /// - On failure, responds with [`SdkError<GetEventPredictionMetadataError>`](crate::error::GetEventPredictionMetadataError)
    pub fn get_event_prediction_metadata(&self) -> fluent_builders::GetEventPredictionMetadata {
        fluent_builders::GetEventPredictionMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetEventTypes`](crate::client::fluent_builders::GetEventTypes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetEventTypes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetEventTypes::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetEventTypes::set_name): <p>The name.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetEventTypes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetEventTypes::set_next_token): <p>The next token for the subsequent request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetEventTypes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetEventTypes::set_max_results): <p>The maximum number of objects to return for the request.</p>
    /// - On success, responds with [`GetEventTypesOutput`](crate::output::GetEventTypesOutput) with field(s):
    ///   - [`event_types(Option<Vec<EventType>>)`](crate::output::GetEventTypesOutput::event_types): <p>An array of event types.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetEventTypesOutput::next_token): <p>The next page token.</p>
    /// - On failure, responds with [`SdkError<GetEventTypesError>`](crate::error::GetEventTypesError)
    pub fn get_event_types(&self) -> fluent_builders::GetEventTypes {
        fluent_builders::GetEventTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetExternalModels`](crate::client::fluent_builders::GetExternalModels) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetExternalModels::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`model_endpoint(impl Into<String>)`](crate::client::fluent_builders::GetExternalModels::model_endpoint) / [`set_model_endpoint(Option<String>)`](crate::client::fluent_builders::GetExternalModels::set_model_endpoint): <p>The Amazon SageMaker model endpoint.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetExternalModels::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetExternalModels::set_next_token): <p>The next page token for the request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetExternalModels::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetExternalModels::set_max_results): <p>The maximum number of objects to return for the request.</p>
    /// - On success, responds with [`GetExternalModelsOutput`](crate::output::GetExternalModelsOutput) with field(s):
    ///   - [`external_models(Option<Vec<ExternalModel>>)`](crate::output::GetExternalModelsOutput::external_models): <p>Gets the Amazon SageMaker models.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetExternalModelsOutput::next_token): <p>The next page token to be used in subsequent requests.</p>
    /// - On failure, responds with [`SdkError<GetExternalModelsError>`](crate::error::GetExternalModelsError)
    pub fn get_external_models(&self) -> fluent_builders::GetExternalModels {
        fluent_builders::GetExternalModels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetKMSEncryptionKey`](crate::client::fluent_builders::GetKMSEncryptionKey) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetKMSEncryptionKey::send) it.

    /// - On success, responds with [`GetKmsEncryptionKeyOutput`](crate::output::GetKmsEncryptionKeyOutput) with field(s):
    ///   - [`kms_key(Option<KmsKey>)`](crate::output::GetKmsEncryptionKeyOutput::kms_key): <p>The KMS encryption key.</p>
    /// - On failure, responds with [`SdkError<GetKMSEncryptionKeyError>`](crate::error::GetKMSEncryptionKeyError)
    pub fn get_kms_encryption_key(&self) -> fluent_builders::GetKMSEncryptionKey {
        fluent_builders::GetKMSEncryptionKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLabels`](crate::client::fluent_builders::GetLabels) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetLabels::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetLabels::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetLabels::set_name): <p>The name of the label or labels to get.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetLabels::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetLabels::set_next_token): <p>The next token for the subsequent request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetLabels::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetLabels::set_max_results): <p>The maximum number of objects to return for the request.</p>
    /// - On success, responds with [`GetLabelsOutput`](crate::output::GetLabelsOutput) with field(s):
    ///   - [`labels(Option<Vec<Label>>)`](crate::output::GetLabelsOutput::labels): <p>An array of labels.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetLabelsOutput::next_token): <p>The next page token.</p>
    /// - On failure, responds with [`SdkError<GetLabelsError>`](crate::error::GetLabelsError)
    pub fn get_labels(&self) -> fluent_builders::GetLabels {
        fluent_builders::GetLabels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetModels`](crate::client::fluent_builders::GetModels) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetModels::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`model_id(impl Into<String>)`](crate::client::fluent_builders::GetModels::model_id) / [`set_model_id(Option<String>)`](crate::client::fluent_builders::GetModels::set_model_id): <p>The model ID.</p>
    ///   - [`model_type(ModelTypeEnum)`](crate::client::fluent_builders::GetModels::model_type) / [`set_model_type(Option<ModelTypeEnum>)`](crate::client::fluent_builders::GetModels::set_model_type): <p>The model type.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetModels::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetModels::set_next_token): <p>The next token for the subsequent request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetModels::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetModels::set_max_results): <p>The maximum number of objects to return for the request. </p>
    /// - On success, responds with [`GetModelsOutput`](crate::output::GetModelsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::GetModelsOutput::next_token): <p>The next page token to be used in subsequent requests.</p>
    ///   - [`models(Option<Vec<Model>>)`](crate::output::GetModelsOutput::models): <p>The array of models.</p>
    /// - On failure, responds with [`SdkError<GetModelsError>`](crate::error::GetModelsError)
    pub fn get_models(&self) -> fluent_builders::GetModels {
        fluent_builders::GetModels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetModelVersion`](crate::client::fluent_builders::GetModelVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`model_id(impl Into<String>)`](crate::client::fluent_builders::GetModelVersion::model_id) / [`set_model_id(Option<String>)`](crate::client::fluent_builders::GetModelVersion::set_model_id): <p>The model ID.</p>
    ///   - [`model_type(ModelTypeEnum)`](crate::client::fluent_builders::GetModelVersion::model_type) / [`set_model_type(Option<ModelTypeEnum>)`](crate::client::fluent_builders::GetModelVersion::set_model_type): <p>The model type.</p>
    ///   - [`model_version_number(impl Into<String>)`](crate::client::fluent_builders::GetModelVersion::model_version_number) / [`set_model_version_number(Option<String>)`](crate::client::fluent_builders::GetModelVersion::set_model_version_number): <p>The model version number.</p>
    /// - On success, responds with [`GetModelVersionOutput`](crate::output::GetModelVersionOutput) with field(s):
    ///   - [`model_id(Option<String>)`](crate::output::GetModelVersionOutput::model_id): <p>The model ID.</p>
    ///   - [`model_type(Option<ModelTypeEnum>)`](crate::output::GetModelVersionOutput::model_type): <p>The model type.</p>
    ///   - [`model_version_number(Option<String>)`](crate::output::GetModelVersionOutput::model_version_number): <p>The model version number.</p>
    ///   - [`training_data_source(Option<TrainingDataSourceEnum>)`](crate::output::GetModelVersionOutput::training_data_source): <p>The training data source.</p>
    ///   - [`training_data_schema(Option<TrainingDataSchema>)`](crate::output::GetModelVersionOutput::training_data_schema): <p>The training data schema.</p>
    ///   - [`external_events_detail(Option<ExternalEventsDetail>)`](crate::output::GetModelVersionOutput::external_events_detail): <p>The details of the external events data used for training the model version. This will be populated if the <code>trainingDataSource</code> is <code>EXTERNAL_EVENTS</code> </p>
    ///   - [`ingested_events_detail(Option<IngestedEventsDetail>)`](crate::output::GetModelVersionOutput::ingested_events_detail): <p>The details of the ingested events data used for training the model version. This will be populated if the <code>trainingDataSource</code> is <code>INGESTED_EVENTS</code>.</p>
    ///   - [`status(Option<String>)`](crate::output::GetModelVersionOutput::status): <p>The model version status.</p>  <p>Possible values are:</p>  <ul>   <li> <p> <code>TRAINING_IN_PROGRESS</code> </p> </li>   <li> <p> <code>TRAINING_COMPLETE</code> </p> </li>   <li> <p> <code>ACTIVATE_REQUESTED</code> </p> </li>   <li> <p> <code>ACTIVATE_IN_PROGRESS</code> </p> </li>   <li> <p> <code>ACTIVE</code> </p> </li>   <li> <p> <code>INACTIVATE_REQUESTED</code> </p> </li>   <li> <p> <code>INACTIVATE_IN_PROGRESS</code> </p> </li>   <li> <p> <code>INACTIVE</code> </p> </li>   <li> <p> <code>ERROR</code> </p> </li>  </ul>
    ///   - [`arn(Option<String>)`](crate::output::GetModelVersionOutput::arn): <p>The model version ARN.</p>
    /// - On failure, responds with [`SdkError<GetModelVersionError>`](crate::error::GetModelVersionError)
    pub fn get_model_version(&self) -> fluent_builders::GetModelVersion {
        fluent_builders::GetModelVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetOutcomes`](crate::client::fluent_builders::GetOutcomes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetOutcomes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetOutcomes::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetOutcomes::set_name): <p>The name of the outcome or outcomes to get.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetOutcomes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetOutcomes::set_next_token): <p>The next page token for the request. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetOutcomes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetOutcomes::set_max_results): <p>The maximum number of objects to return for the request. </p>
    /// - On success, responds with [`GetOutcomesOutput`](crate::output::GetOutcomesOutput) with field(s):
    ///   - [`outcomes(Option<Vec<Outcome>>)`](crate::output::GetOutcomesOutput::outcomes): <p>The outcomes. </p>
    ///   - [`next_token(Option<String>)`](crate::output::GetOutcomesOutput::next_token): <p>The next page token for subsequent requests.</p>
    /// - On failure, responds with [`SdkError<GetOutcomesError>`](crate::error::GetOutcomesError)
    pub fn get_outcomes(&self) -> fluent_builders::GetOutcomes {
        fluent_builders::GetOutcomes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRules`](crate::client::fluent_builders::GetRules) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetRules::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_id(impl Into<String>)`](crate::client::fluent_builders::GetRules::rule_id) / [`set_rule_id(Option<String>)`](crate::client::fluent_builders::GetRules::set_rule_id): <p>The rule ID.</p>
    ///   - [`detector_id(impl Into<String>)`](crate::client::fluent_builders::GetRules::detector_id) / [`set_detector_id(Option<String>)`](crate::client::fluent_builders::GetRules::set_detector_id): <p>The detector ID.</p>
    ///   - [`rule_version(impl Into<String>)`](crate::client::fluent_builders::GetRules::rule_version) / [`set_rule_version(Option<String>)`](crate::client::fluent_builders::GetRules::set_rule_version): <p>The rule version.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetRules::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetRules::set_next_token): <p>The next page token.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetRules::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetRules::set_max_results): <p>The maximum number of rules to return for the request.</p>
    /// - On success, responds with [`GetRulesOutput`](crate::output::GetRulesOutput) with field(s):
    ///   - [`rule_details(Option<Vec<RuleDetail>>)`](crate::output::GetRulesOutput::rule_details): <p>The details of the requested rule.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetRulesOutput::next_token): <p>The next page token to be used in subsequent requests.</p>
    /// - On failure, responds with [`SdkError<GetRulesError>`](crate::error::GetRulesError)
    pub fn get_rules(&self) -> fluent_builders::GetRules {
        fluent_builders::GetRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetVariables`](crate::client::fluent_builders::GetVariables) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetVariables::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetVariables::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetVariables::set_name): <p>The name of the variable. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetVariables::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetVariables::set_next_token): <p>The next page token of the get variable request. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetVariables::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetVariables::set_max_results): <p>The max size per page determined for the get variable request. </p>
    /// - On success, responds with [`GetVariablesOutput`](crate::output::GetVariablesOutput) with field(s):
    ///   - [`variables(Option<Vec<Variable>>)`](crate::output::GetVariablesOutput::variables): <p>The names of the variables returned. </p>
    ///   - [`next_token(Option<String>)`](crate::output::GetVariablesOutput::next_token): <p>The next page token to be used in subsequent requests. </p>
    /// - On failure, responds with [`SdkError<GetVariablesError>`](crate::error::GetVariablesError)
    pub fn get_variables(&self) -> fluent_builders::GetVariables {
        fluent_builders::GetVariables::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListEventPredictions`](crate::client::fluent_builders::ListEventPredictions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListEventPredictions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`event_id(FilterCondition)`](crate::client::fluent_builders::ListEventPredictions::event_id) / [`set_event_id(Option<FilterCondition>)`](crate::client::fluent_builders::ListEventPredictions::set_event_id): <p> The event ID. </p>
    ///   - [`event_type(FilterCondition)`](crate::client::fluent_builders::ListEventPredictions::event_type) / [`set_event_type(Option<FilterCondition>)`](crate::client::fluent_builders::ListEventPredictions::set_event_type): <p> The event type associated with the detector. </p>
    ///   - [`detector_id(FilterCondition)`](crate::client::fluent_builders::ListEventPredictions::detector_id) / [`set_detector_id(Option<FilterCondition>)`](crate::client::fluent_builders::ListEventPredictions::set_detector_id): <p> The detector ID. </p>
    ///   - [`detector_version_id(FilterCondition)`](crate::client::fluent_builders::ListEventPredictions::detector_version_id) / [`set_detector_version_id(Option<FilterCondition>)`](crate::client::fluent_builders::ListEventPredictions::set_detector_version_id): <p> The detector version ID. </p>
    ///   - [`prediction_time_range(PredictionTimeRange)`](crate::client::fluent_builders::ListEventPredictions::prediction_time_range) / [`set_prediction_time_range(Option<PredictionTimeRange>)`](crate::client::fluent_builders::ListEventPredictions::set_prediction_time_range): <p> The time period for when the predictions were generated. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListEventPredictions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListEventPredictions::set_next_token): <p> Identifies the next page of results to return. Use the token to make the call again to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListEventPredictions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListEventPredictions::set_max_results): <p> The maximum number of predictions to return for the request. </p>
    /// - On success, responds with [`ListEventPredictionsOutput`](crate::output::ListEventPredictionsOutput) with field(s):
    ///   - [`event_prediction_summaries(Option<Vec<EventPredictionSummary>>)`](crate::output::ListEventPredictionsOutput::event_prediction_summaries): <p> The summary of the past predictions. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListEventPredictionsOutput::next_token): <p> Identifies the next page of results to return. Use the token to make the call again to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. </p>
    /// - On failure, responds with [`SdkError<ListEventPredictionsError>`](crate::error::ListEventPredictionsError)
    pub fn list_event_predictions(&self) -> fluent_builders::ListEventPredictions {
        fluent_builders::ListEventPredictions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTagsForResource::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The ARN that specifies the resource whose tags you want to list.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_next_token): <p>The next token from the previous results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTagsForResource::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTagsForResource::set_max_results): <p>The maximum number of objects to return for the request. </p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>A collection of key and value pairs.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTagsForResourceOutput::next_token): <p>The next token for subsequent requests. </p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutDetector`](crate::client::fluent_builders::PutDetector) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`detector_id(impl Into<String>)`](crate::client::fluent_builders::PutDetector::detector_id) / [`set_detector_id(Option<String>)`](crate::client::fluent_builders::PutDetector::set_detector_id): <p>The detector ID. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::PutDetector::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::PutDetector::set_description): <p>The description of the detector.</p>
    ///   - [`event_type_name(impl Into<String>)`](crate::client::fluent_builders::PutDetector::event_type_name) / [`set_event_type_name(Option<String>)`](crate::client::fluent_builders::PutDetector::set_event_type_name): <p>The name of the event type.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::PutDetector::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::PutDetector::set_tags): <p>A collection of key and value pairs.</p>
    /// - On success, responds with [`PutDetectorOutput`](crate::output::PutDetectorOutput)

    /// - On failure, responds with [`SdkError<PutDetectorError>`](crate::error::PutDetectorError)
    pub fn put_detector(&self) -> fluent_builders::PutDetector {
        fluent_builders::PutDetector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutEntityType`](crate::client::fluent_builders::PutEntityType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::PutEntityType::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::PutEntityType::set_name): <p>The name of the entity type.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::PutEntityType::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::PutEntityType::set_description): <p>The description.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::PutEntityType::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::PutEntityType::set_tags): <p>A collection of key and value pairs.</p>
    /// - On success, responds with [`PutEntityTypeOutput`](crate::output::PutEntityTypeOutput)

    /// - On failure, responds with [`SdkError<PutEntityTypeError>`](crate::error::PutEntityTypeError)
    pub fn put_entity_type(&self) -> fluent_builders::PutEntityType {
        fluent_builders::PutEntityType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutEventType`](crate::client::fluent_builders::PutEventType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::PutEventType::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::PutEventType::set_name): <p>The name.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::PutEventType::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::PutEventType::set_description): <p>The description of the event type.</p>
    ///   - [`event_variables(Vec<String>)`](crate::client::fluent_builders::PutEventType::event_variables) / [`set_event_variables(Option<Vec<String>>)`](crate::client::fluent_builders::PutEventType::set_event_variables): <p>The event type variables.</p>
    ///   - [`labels(Vec<String>)`](crate::client::fluent_builders::PutEventType::labels) / [`set_labels(Option<Vec<String>>)`](crate::client::fluent_builders::PutEventType::set_labels): <p>The event type labels.</p>
    ///   - [`entity_types(Vec<String>)`](crate::client::fluent_builders::PutEventType::entity_types) / [`set_entity_types(Option<Vec<String>>)`](crate::client::fluent_builders::PutEventType::set_entity_types): <p>The entity type for the event type. Example entity types: customer, merchant, account.</p>
    ///   - [`event_ingestion(EventIngestion)`](crate::client::fluent_builders::PutEventType::event_ingestion) / [`set_event_ingestion(Option<EventIngestion>)`](crate::client::fluent_builders::PutEventType::set_event_ingestion): <p>Specifies if ingenstion is enabled or disabled.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::PutEventType::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::PutEventType::set_tags): <p>A collection of key and value pairs.</p>
    /// - On success, responds with [`PutEventTypeOutput`](crate::output::PutEventTypeOutput)

    /// - On failure, responds with [`SdkError<PutEventTypeError>`](crate::error::PutEventTypeError)
    pub fn put_event_type(&self) -> fluent_builders::PutEventType {
        fluent_builders::PutEventType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutExternalModel`](crate::client::fluent_builders::PutExternalModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`model_endpoint(impl Into<String>)`](crate::client::fluent_builders::PutExternalModel::model_endpoint) / [`set_model_endpoint(Option<String>)`](crate::client::fluent_builders::PutExternalModel::set_model_endpoint): <p>The model endpoints name.</p>
    ///   - [`model_source(ModelSource)`](crate::client::fluent_builders::PutExternalModel::model_source) / [`set_model_source(Option<ModelSource>)`](crate::client::fluent_builders::PutExternalModel::set_model_source): <p>The source of the model.</p>
    ///   - [`invoke_model_endpoint_role_arn(impl Into<String>)`](crate::client::fluent_builders::PutExternalModel::invoke_model_endpoint_role_arn) / [`set_invoke_model_endpoint_role_arn(Option<String>)`](crate::client::fluent_builders::PutExternalModel::set_invoke_model_endpoint_role_arn): <p>The IAM role used to invoke the model endpoint.</p>
    ///   - [`input_configuration(ModelInputConfiguration)`](crate::client::fluent_builders::PutExternalModel::input_configuration) / [`set_input_configuration(Option<ModelInputConfiguration>)`](crate::client::fluent_builders::PutExternalModel::set_input_configuration): <p>The model endpoint input configuration.</p>
    ///   - [`output_configuration(ModelOutputConfiguration)`](crate::client::fluent_builders::PutExternalModel::output_configuration) / [`set_output_configuration(Option<ModelOutputConfiguration>)`](crate::client::fluent_builders::PutExternalModel::set_output_configuration): <p>The model endpoint output configuration.</p>
    ///   - [`model_endpoint_status(ModelEndpointStatus)`](crate::client::fluent_builders::PutExternalModel::model_endpoint_status) / [`set_model_endpoint_status(Option<ModelEndpointStatus>)`](crate::client::fluent_builders::PutExternalModel::set_model_endpoint_status): <p>The model endpoint’s status in Amazon Fraud Detector.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::PutExternalModel::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::PutExternalModel::set_tags): <p>A collection of key and value pairs.</p>
    /// - On success, responds with [`PutExternalModelOutput`](crate::output::PutExternalModelOutput)

    /// - On failure, responds with [`SdkError<PutExternalModelError>`](crate::error::PutExternalModelError)
    pub fn put_external_model(&self) -> fluent_builders::PutExternalModel {
        fluent_builders::PutExternalModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutKMSEncryptionKey`](crate::client::fluent_builders::PutKMSEncryptionKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`kms_encryption_key_arn(impl Into<String>)`](crate::client::fluent_builders::PutKMSEncryptionKey::kms_encryption_key_arn) / [`set_kms_encryption_key_arn(Option<String>)`](crate::client::fluent_builders::PutKMSEncryptionKey::set_kms_encryption_key_arn): <p>The KMS encryption key ARN.</p>
    /// - On success, responds with [`PutKmsEncryptionKeyOutput`](crate::output::PutKmsEncryptionKeyOutput)

    /// - On failure, responds with [`SdkError<PutKMSEncryptionKeyError>`](crate::error::PutKMSEncryptionKeyError)
    pub fn put_kms_encryption_key(&self) -> fluent_builders::PutKMSEncryptionKey {
        fluent_builders::PutKMSEncryptionKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutLabel`](crate::client::fluent_builders::PutLabel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::PutLabel::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::PutLabel::set_name): <p>The label name.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::PutLabel::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::PutLabel::set_description): <p>The label description.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::PutLabel::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::PutLabel::set_tags): <p></p>
    /// - On success, responds with [`PutLabelOutput`](crate::output::PutLabelOutput)

    /// - On failure, responds with [`SdkError<PutLabelError>`](crate::error::PutLabelError)
    pub fn put_label(&self) -> fluent_builders::PutLabel {
        fluent_builders::PutLabel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutOutcome`](crate::client::fluent_builders::PutOutcome) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::PutOutcome::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::PutOutcome::set_name): <p>The name of the outcome.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::PutOutcome::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::PutOutcome::set_description): <p>The outcome description.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::PutOutcome::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::PutOutcome::set_tags): <p>A collection of key and value pairs.</p>
    /// - On success, responds with [`PutOutcomeOutput`](crate::output::PutOutcomeOutput)

    /// - On failure, responds with [`SdkError<PutOutcomeError>`](crate::error::PutOutcomeError)
    pub fn put_outcome(&self) -> fluent_builders::PutOutcome {
        fluent_builders::PutOutcome::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SendEvent`](crate::client::fluent_builders::SendEvent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`event_id(impl Into<String>)`](crate::client::fluent_builders::SendEvent::event_id) / [`set_event_id(Option<String>)`](crate::client::fluent_builders::SendEvent::set_event_id): <p>The event ID to upload.</p>
    ///   - [`event_type_name(impl Into<String>)`](crate::client::fluent_builders::SendEvent::event_type_name) / [`set_event_type_name(Option<String>)`](crate::client::fluent_builders::SendEvent::set_event_type_name): <p>The event type name of the event.</p>
    ///   - [`event_timestamp(impl Into<String>)`](crate::client::fluent_builders::SendEvent::event_timestamp) / [`set_event_timestamp(Option<String>)`](crate::client::fluent_builders::SendEvent::set_event_timestamp): <p>The timestamp that defines when the event under evaluation occurred. The timestamp must be specified using ISO 8601 standard in UTC.</p>
    ///   - [`event_variables(HashMap<String, String>)`](crate::client::fluent_builders::SendEvent::event_variables) / [`set_event_variables(Option<HashMap<String, String>>)`](crate::client::fluent_builders::SendEvent::set_event_variables): <p>Names of the event type's variables you defined in Amazon Fraud Detector to represent data elements and their corresponding values for the event you are sending for evaluation.</p>
    ///   - [`assigned_label(impl Into<String>)`](crate::client::fluent_builders::SendEvent::assigned_label) / [`set_assigned_label(Option<String>)`](crate::client::fluent_builders::SendEvent::set_assigned_label): <p>The label to associate with the event. Required if specifying <code>labelTimestamp</code>.</p>
    ///   - [`label_timestamp(impl Into<String>)`](crate::client::fluent_builders::SendEvent::label_timestamp) / [`set_label_timestamp(Option<String>)`](crate::client::fluent_builders::SendEvent::set_label_timestamp): <p>The timestamp associated with the label. Required if specifying <code>assignedLabel</code>.</p>
    ///   - [`entities(Vec<Entity>)`](crate::client::fluent_builders::SendEvent::entities) / [`set_entities(Option<Vec<Entity>>)`](crate::client::fluent_builders::SendEvent::set_entities): <p>An array of entities.</p>
    /// - On success, responds with [`SendEventOutput`](crate::output::SendEventOutput)

    /// - On failure, responds with [`SdkError<SendEventError>`](crate::error::SendEventError)
    pub fn send_event(&self) -> fluent_builders::SendEvent {
        fluent_builders::SendEvent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The resource ARN.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags to assign to the resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The ARN of the resource from which to remove the tag.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The resource ARN.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDetectorVersion`](crate::client::fluent_builders::UpdateDetectorVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`detector_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDetectorVersion::detector_id) / [`set_detector_id(Option<String>)`](crate::client::fluent_builders::UpdateDetectorVersion::set_detector_id): <p>The parent detector ID for the detector version you want to update.</p>
    ///   - [`detector_version_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDetectorVersion::detector_version_id) / [`set_detector_version_id(Option<String>)`](crate::client::fluent_builders::UpdateDetectorVersion::set_detector_version_id): <p>The detector version ID. </p>
    ///   - [`external_model_endpoints(Vec<String>)`](crate::client::fluent_builders::UpdateDetectorVersion::external_model_endpoints) / [`set_external_model_endpoints(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateDetectorVersion::set_external_model_endpoints): <p>The Amazon SageMaker model endpoints to include in the detector version.</p>
    ///   - [`rules(Vec<Rule>)`](crate::client::fluent_builders::UpdateDetectorVersion::rules) / [`set_rules(Option<Vec<Rule>>)`](crate::client::fluent_builders::UpdateDetectorVersion::set_rules): <p>The rules to include in the detector version.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateDetectorVersion::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateDetectorVersion::set_description): <p>The detector version description. </p>
    ///   - [`model_versions(Vec<ModelVersion>)`](crate::client::fluent_builders::UpdateDetectorVersion::model_versions) / [`set_model_versions(Option<Vec<ModelVersion>>)`](crate::client::fluent_builders::UpdateDetectorVersion::set_model_versions): <p>The model versions to include in the detector version.</p>
    ///   - [`rule_execution_mode(RuleExecutionMode)`](crate::client::fluent_builders::UpdateDetectorVersion::rule_execution_mode) / [`set_rule_execution_mode(Option<RuleExecutionMode>)`](crate::client::fluent_builders::UpdateDetectorVersion::set_rule_execution_mode): <p>The rule execution mode to add to the detector.</p>  <p>If you specify <code>FIRST_MATCHED</code>, Amazon Fraud Detector evaluates rules sequentially, first to last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule.</p>  <p>If you specifiy <code>ALL_MATCHED</code>, Amazon Fraud Detector evaluates all rules and returns the outcomes for all matched rules. You can define and edit the rule mode at the detector version level, when it is in draft status.</p>  <p>The default behavior is <code>FIRST_MATCHED</code>.</p>
    /// - On success, responds with [`UpdateDetectorVersionOutput`](crate::output::UpdateDetectorVersionOutput)

    /// - On failure, responds with [`SdkError<UpdateDetectorVersionError>`](crate::error::UpdateDetectorVersionError)
    pub fn update_detector_version(&self) -> fluent_builders::UpdateDetectorVersion {
        fluent_builders::UpdateDetectorVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDetectorVersionMetadata`](crate::client::fluent_builders::UpdateDetectorVersionMetadata) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`detector_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDetectorVersionMetadata::detector_id) / [`set_detector_id(Option<String>)`](crate::client::fluent_builders::UpdateDetectorVersionMetadata::set_detector_id): <p>The detector ID.</p>
    ///   - [`detector_version_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDetectorVersionMetadata::detector_version_id) / [`set_detector_version_id(Option<String>)`](crate::client::fluent_builders::UpdateDetectorVersionMetadata::set_detector_version_id): <p>The detector version ID. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateDetectorVersionMetadata::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateDetectorVersionMetadata::set_description): <p>The description.</p>
    /// - On success, responds with [`UpdateDetectorVersionMetadataOutput`](crate::output::UpdateDetectorVersionMetadataOutput)

    /// - On failure, responds with [`SdkError<UpdateDetectorVersionMetadataError>`](crate::error::UpdateDetectorVersionMetadataError)
    pub fn update_detector_version_metadata(
        &self,
    ) -> fluent_builders::UpdateDetectorVersionMetadata {
        fluent_builders::UpdateDetectorVersionMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDetectorVersionStatus`](crate::client::fluent_builders::UpdateDetectorVersionStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`detector_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDetectorVersionStatus::detector_id) / [`set_detector_id(Option<String>)`](crate::client::fluent_builders::UpdateDetectorVersionStatus::set_detector_id): <p>The detector ID. </p>
    ///   - [`detector_version_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDetectorVersionStatus::detector_version_id) / [`set_detector_version_id(Option<String>)`](crate::client::fluent_builders::UpdateDetectorVersionStatus::set_detector_version_id): <p>The detector version ID. </p>
    ///   - [`status(DetectorVersionStatus)`](crate::client::fluent_builders::UpdateDetectorVersionStatus::status) / [`set_status(Option<DetectorVersionStatus>)`](crate::client::fluent_builders::UpdateDetectorVersionStatus::set_status): <p>The new status.</p>
    /// - On success, responds with [`UpdateDetectorVersionStatusOutput`](crate::output::UpdateDetectorVersionStatusOutput)

    /// - On failure, responds with [`SdkError<UpdateDetectorVersionStatusError>`](crate::error::UpdateDetectorVersionStatusError)
    pub fn update_detector_version_status(&self) -> fluent_builders::UpdateDetectorVersionStatus {
        fluent_builders::UpdateDetectorVersionStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateEventLabel`](crate::client::fluent_builders::UpdateEventLabel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`event_id(impl Into<String>)`](crate::client::fluent_builders::UpdateEventLabel::event_id) / [`set_event_id(Option<String>)`](crate::client::fluent_builders::UpdateEventLabel::set_event_id): <p>The ID of the event associated with the label to update.</p>
    ///   - [`event_type_name(impl Into<String>)`](crate::client::fluent_builders::UpdateEventLabel::event_type_name) / [`set_event_type_name(Option<String>)`](crate::client::fluent_builders::UpdateEventLabel::set_event_type_name): <p>The event type of the event associated with the label to update.</p>
    ///   - [`assigned_label(impl Into<String>)`](crate::client::fluent_builders::UpdateEventLabel::assigned_label) / [`set_assigned_label(Option<String>)`](crate::client::fluent_builders::UpdateEventLabel::set_assigned_label): <p>The new label to assign to the event.</p>
    ///   - [`label_timestamp(impl Into<String>)`](crate::client::fluent_builders::UpdateEventLabel::label_timestamp) / [`set_label_timestamp(Option<String>)`](crate::client::fluent_builders::UpdateEventLabel::set_label_timestamp): <p>The timestamp associated with the label. The timestamp must be specified using ISO 8601 standard in UTC. </p>
    /// - On success, responds with [`UpdateEventLabelOutput`](crate::output::UpdateEventLabelOutput)

    /// - On failure, responds with [`SdkError<UpdateEventLabelError>`](crate::error::UpdateEventLabelError)
    pub fn update_event_label(&self) -> fluent_builders::UpdateEventLabel {
        fluent_builders::UpdateEventLabel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateModel`](crate::client::fluent_builders::UpdateModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`model_id(impl Into<String>)`](crate::client::fluent_builders::UpdateModel::model_id) / [`set_model_id(Option<String>)`](crate::client::fluent_builders::UpdateModel::set_model_id): <p>The model ID.</p>
    ///   - [`model_type(ModelTypeEnum)`](crate::client::fluent_builders::UpdateModel::model_type) / [`set_model_type(Option<ModelTypeEnum>)`](crate::client::fluent_builders::UpdateModel::set_model_type): <p>The model type.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateModel::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateModel::set_description): <p>The new model description.</p>
    /// - On success, responds with [`UpdateModelOutput`](crate::output::UpdateModelOutput)

    /// - On failure, responds with [`SdkError<UpdateModelError>`](crate::error::UpdateModelError)
    pub fn update_model(&self) -> fluent_builders::UpdateModel {
        fluent_builders::UpdateModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateModelVersion`](crate::client::fluent_builders::UpdateModelVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`model_id(impl Into<String>)`](crate::client::fluent_builders::UpdateModelVersion::model_id) / [`set_model_id(Option<String>)`](crate::client::fluent_builders::UpdateModelVersion::set_model_id): <p>The model ID.</p>
    ///   - [`model_type(ModelTypeEnum)`](crate::client::fluent_builders::UpdateModelVersion::model_type) / [`set_model_type(Option<ModelTypeEnum>)`](crate::client::fluent_builders::UpdateModelVersion::set_model_type): <p>The model type.</p>
    ///   - [`major_version_number(impl Into<String>)`](crate::client::fluent_builders::UpdateModelVersion::major_version_number) / [`set_major_version_number(Option<String>)`](crate::client::fluent_builders::UpdateModelVersion::set_major_version_number): <p>The major version number.</p>
    ///   - [`external_events_detail(ExternalEventsDetail)`](crate::client::fluent_builders::UpdateModelVersion::external_events_detail) / [`set_external_events_detail(Option<ExternalEventsDetail>)`](crate::client::fluent_builders::UpdateModelVersion::set_external_events_detail): <p>The details of the external events data used for training the model version. Required if <code>trainingDataSource</code> is <code>EXTERNAL_EVENTS</code>.</p>
    ///   - [`ingested_events_detail(IngestedEventsDetail)`](crate::client::fluent_builders::UpdateModelVersion::ingested_events_detail) / [`set_ingested_events_detail(Option<IngestedEventsDetail>)`](crate::client::fluent_builders::UpdateModelVersion::set_ingested_events_detail): <p>The details of the ingested event used for training the model version. Required if your <code>trainingDataSource</code> is <code>INGESTED_EVENTS</code>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::UpdateModelVersion::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::UpdateModelVersion::set_tags): <p>A collection of key and value pairs.</p>
    /// - On success, responds with [`UpdateModelVersionOutput`](crate::output::UpdateModelVersionOutput) with field(s):
    ///   - [`model_id(Option<String>)`](crate::output::UpdateModelVersionOutput::model_id): <p>The model ID.</p>
    ///   - [`model_type(Option<ModelTypeEnum>)`](crate::output::UpdateModelVersionOutput::model_type): <p>The model type.</p>
    ///   - [`model_version_number(Option<String>)`](crate::output::UpdateModelVersionOutput::model_version_number): <p>The model version number of the model version updated.</p>
    ///   - [`status(Option<String>)`](crate::output::UpdateModelVersionOutput::status): <p>The status of the updated model version.</p>
    /// - On failure, responds with [`SdkError<UpdateModelVersionError>`](crate::error::UpdateModelVersionError)
    pub fn update_model_version(&self) -> fluent_builders::UpdateModelVersion {
        fluent_builders::UpdateModelVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateModelVersionStatus`](crate::client::fluent_builders::UpdateModelVersionStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`model_id(impl Into<String>)`](crate::client::fluent_builders::UpdateModelVersionStatus::model_id) / [`set_model_id(Option<String>)`](crate::client::fluent_builders::UpdateModelVersionStatus::set_model_id): <p>The model ID of the model version to update.</p>
    ///   - [`model_type(ModelTypeEnum)`](crate::client::fluent_builders::UpdateModelVersionStatus::model_type) / [`set_model_type(Option<ModelTypeEnum>)`](crate::client::fluent_builders::UpdateModelVersionStatus::set_model_type): <p>The model type.</p>
    ///   - [`model_version_number(impl Into<String>)`](crate::client::fluent_builders::UpdateModelVersionStatus::model_version_number) / [`set_model_version_number(Option<String>)`](crate::client::fluent_builders::UpdateModelVersionStatus::set_model_version_number): <p>The model version number.</p>
    ///   - [`status(ModelVersionStatus)`](crate::client::fluent_builders::UpdateModelVersionStatus::status) / [`set_status(Option<ModelVersionStatus>)`](crate::client::fluent_builders::UpdateModelVersionStatus::set_status): <p>The model version status.</p>
    /// - On success, responds with [`UpdateModelVersionStatusOutput`](crate::output::UpdateModelVersionStatusOutput)

    /// - On failure, responds with [`SdkError<UpdateModelVersionStatusError>`](crate::error::UpdateModelVersionStatusError)
    pub fn update_model_version_status(&self) -> fluent_builders::UpdateModelVersionStatus {
        fluent_builders::UpdateModelVersionStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRuleMetadata`](crate::client::fluent_builders::UpdateRuleMetadata) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule(Rule)`](crate::client::fluent_builders::UpdateRuleMetadata::rule) / [`set_rule(Option<Rule>)`](crate::client::fluent_builders::UpdateRuleMetadata::set_rule): <p>The rule to update.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateRuleMetadata::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateRuleMetadata::set_description): <p>The rule description.</p>
    /// - On success, responds with [`UpdateRuleMetadataOutput`](crate::output::UpdateRuleMetadataOutput)

    /// - On failure, responds with [`SdkError<UpdateRuleMetadataError>`](crate::error::UpdateRuleMetadataError)
    pub fn update_rule_metadata(&self) -> fluent_builders::UpdateRuleMetadata {
        fluent_builders::UpdateRuleMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRuleVersion`](crate::client::fluent_builders::UpdateRuleVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule(Rule)`](crate::client::fluent_builders::UpdateRuleVersion::rule) / [`set_rule(Option<Rule>)`](crate::client::fluent_builders::UpdateRuleVersion::set_rule): <p>The rule to update.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateRuleVersion::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateRuleVersion::set_description): <p>The description.</p>
    ///   - [`expression(impl Into<String>)`](crate::client::fluent_builders::UpdateRuleVersion::expression) / [`set_expression(Option<String>)`](crate::client::fluent_builders::UpdateRuleVersion::set_expression): <p>The rule expression.</p>
    ///   - [`language(Language)`](crate::client::fluent_builders::UpdateRuleVersion::language) / [`set_language(Option<Language>)`](crate::client::fluent_builders::UpdateRuleVersion::set_language): <p>The language.</p>
    ///   - [`outcomes(Vec<String>)`](crate::client::fluent_builders::UpdateRuleVersion::outcomes) / [`set_outcomes(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateRuleVersion::set_outcomes): <p>The outcomes.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::UpdateRuleVersion::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::UpdateRuleVersion::set_tags): <p>The tags to assign to the rule version.</p>
    /// - On success, responds with [`UpdateRuleVersionOutput`](crate::output::UpdateRuleVersionOutput) with field(s):
    ///   - [`rule(Option<Rule>)`](crate::output::UpdateRuleVersionOutput::rule): <p>The new rule version that was created.</p>
    /// - On failure, responds with [`SdkError<UpdateRuleVersionError>`](crate::error::UpdateRuleVersionError)
    pub fn update_rule_version(&self) -> fluent_builders::UpdateRuleVersion {
        fluent_builders::UpdateRuleVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateVariable`](crate::client::fluent_builders::UpdateVariable) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateVariable::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateVariable::set_name): <p>The name of the variable.</p>
    ///   - [`default_value(impl Into<String>)`](crate::client::fluent_builders::UpdateVariable::default_value) / [`set_default_value(Option<String>)`](crate::client::fluent_builders::UpdateVariable::set_default_value): <p>The new default value of the variable.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateVariable::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateVariable::set_description): <p>The new description.</p>
    ///   - [`variable_type(impl Into<String>)`](crate::client::fluent_builders::UpdateVariable::variable_type) / [`set_variable_type(Option<String>)`](crate::client::fluent_builders::UpdateVariable::set_variable_type): <p>The variable type. For more information see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable types</a>.</p>
    /// - On success, responds with [`UpdateVariableOutput`](crate::output::UpdateVariableOutput)

    /// - On failure, responds with [`SdkError<UpdateVariableError>`](crate::error::UpdateVariableError)
    pub fn update_variable(&self) -> fluent_builders::UpdateVariable {
        fluent_builders::UpdateVariable::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchCreateVariable`.
    ///
    /// <p>Creates a batch of variables.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchCreateVariable {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_create_variable_input::Builder,
    }
    impl BatchCreateVariable {
        /// Creates a new `BatchCreateVariable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchCreateVariableOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchCreateVariableError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `variableEntries`.
        ///
        /// To override the contents of this collection use [`set_variable_entries`](Self::set_variable_entries).
        ///
        /// <p>The list of variables for the batch create variable request.</p>
        pub fn variable_entries(mut self, input: crate::model::VariableEntry) -> Self {
            self.inner = self.inner.variable_entries(input);
            self
        }
        /// <p>The list of variables for the batch create variable request.</p>
        pub fn set_variable_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VariableEntry>>,
        ) -> Self {
            self.inner = self.inner.set_variable_entries(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetVariable`.
    ///
    /// <p>Gets a batch of variables.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchGetVariable {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_get_variable_input::Builder,
    }
    impl BatchGetVariable {
        /// Creates a new `BatchGetVariable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetVariableOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetVariableError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>The list of variable names to get.</p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.names(input.into());
            self
        }
        /// <p>The list of variable names to get.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelBatchImportJob`.
    ///
    /// <p> Cancels an in-progress batch import job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelBatchImportJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::cancel_batch_import_job_input::Builder,
    }
    impl CancelBatchImportJob {
        /// Creates a new `CancelBatchImportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelBatchImportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelBatchImportJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID of an in-progress batch import job to cancel. </p>
        /// <p>Amazon Fraud Detector will throw an error if the batch import job is in <code>FAILED</code>, <code>CANCELED</code>, or <code>COMPLETED</code> state.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p> The ID of an in-progress batch import job to cancel. </p>
        /// <p>Amazon Fraud Detector will throw an error if the batch import job is in <code>FAILED</code>, <code>CANCELED</code>, or <code>COMPLETED</code> state.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelBatchPredictionJob`.
    ///
    /// <p>Cancels the specified batch prediction job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelBatchPredictionJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::cancel_batch_prediction_job_input::Builder,
    }
    impl CancelBatchPredictionJob {
        /// Creates a new `CancelBatchPredictionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelBatchPredictionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelBatchPredictionJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the batch prediction job to cancel.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The ID of the batch prediction job to cancel.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBatchImportJob`.
    ///
    /// <p>Creates a batch import job. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateBatchImportJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_batch_import_job_input::Builder,
    }
    impl CreateBatchImportJob {
        /// Creates a new `CreateBatchImportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBatchImportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBatchImportJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the batch import job. The ID cannot be of a past job, unless the job exists in <code>CREATE_FAILED</code> state.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The ID of the batch import job. The ID cannot be of a past job, unless the job exists in <code>CREATE_FAILED</code> state.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The URI that points to the Amazon S3 location of your data file.</p>
        pub fn input_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_path(input.into());
            self
        }
        /// <p>The URI that points to the Amazon S3 location of your data file.</p>
        pub fn set_input_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_input_path(input);
            self
        }
        /// <p>The URI that points to the Amazon S3 location for storing your results. </p>
        pub fn output_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.output_path(input.into());
            self
        }
        /// <p>The URI that points to the Amazon S3 location for storing your results. </p>
        pub fn set_output_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_output_path(input);
            self
        }
        /// <p>The name of the event type.</p>
        pub fn event_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_type_name(input.into());
            self
        }
        /// <p>The name of the event type.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_type_name(input);
            self
        }
        /// <p>The ARN of the IAM role created for Amazon S3 bucket that holds your data file. The IAM role must have read and write permissions to both input and output S3 buckets.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_role_arn(input.into());
            self
        }
        /// <p>The ARN of the IAM role created for Amazon S3 bucket that holds your data file. The IAM role must have read and write permissions to both input and output S3 buckets.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_iam_role_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key-value pairs associated with this request. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A collection of key-value pairs associated with this request. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBatchPredictionJob`.
    ///
    /// <p>Creates a batch prediction job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateBatchPredictionJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_batch_prediction_job_input::Builder,
    }
    impl CreateBatchPredictionJob {
        /// Creates a new `CreateBatchPredictionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBatchPredictionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBatchPredictionJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the batch prediction job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The ID of the batch prediction job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The Amazon S3 location of your training file.</p>
        pub fn input_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_path(input.into());
            self
        }
        /// <p>The Amazon S3 location of your training file.</p>
        pub fn set_input_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_input_path(input);
            self
        }
        /// <p>The Amazon S3 location of your output file.</p>
        pub fn output_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.output_path(input.into());
            self
        }
        /// <p>The Amazon S3 location of your output file.</p>
        pub fn set_output_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_output_path(input);
            self
        }
        /// <p>The name of the event type.</p>
        pub fn event_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_type_name(input.into());
            self
        }
        /// <p>The name of the event type.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_type_name(input);
            self
        }
        /// <p>The name of the detector.</p>
        pub fn detector_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_name(input.into());
            self
        }
        /// <p>The name of the detector.</p>
        pub fn set_detector_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_detector_name(input);
            self
        }
        /// <p>The detector version.</p>
        pub fn detector_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_version(input.into());
            self
        }
        /// <p>The detector version.</p>
        pub fn set_detector_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_detector_version(input);
            self
        }
        /// <p>The ARN of the IAM role to use for this job request.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_role_arn(input.into());
            self
        }
        /// <p>The ARN of the IAM role to use for this job request.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_iam_role_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDetectorVersion`.
    ///
    /// <p>Creates a detector version. The detector version starts in a <code>DRAFT</code> status.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDetectorVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_detector_version_input::Builder,
    }
    impl CreateDetectorVersion {
        /// Creates a new `CreateDetectorVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDetectorVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDetectorVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the detector under which you want to create a new version.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(input.into());
            self
        }
        /// <p>The ID of the detector under which you want to create a new version.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The description of the detector version.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the detector version.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `externalModelEndpoints`.
        ///
        /// To override the contents of this collection use [`set_external_model_endpoints`](Self::set_external_model_endpoints).
        ///
        /// <p>The Amazon Sagemaker model endpoints to include in the detector version.</p>
        pub fn external_model_endpoints(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_model_endpoints(input.into());
            self
        }
        /// <p>The Amazon Sagemaker model endpoints to include in the detector version.</p>
        pub fn set_external_model_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_external_model_endpoints(input);
            self
        }
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>The rules to include in the detector version.</p>
        pub fn rules(mut self, input: crate::model::Rule) -> Self {
            self.inner = self.inner.rules(input);
            self
        }
        /// <p>The rules to include in the detector version.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.inner = self.inner.set_rules(input);
            self
        }
        /// Appends an item to `modelVersions`.
        ///
        /// To override the contents of this collection use [`set_model_versions`](Self::set_model_versions).
        ///
        /// <p>The model versions to include in the detector version.</p>
        pub fn model_versions(mut self, input: crate::model::ModelVersion) -> Self {
            self.inner = self.inner.model_versions(input);
            self
        }
        /// <p>The model versions to include in the detector version.</p>
        pub fn set_model_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ModelVersion>>,
        ) -> Self {
            self.inner = self.inner.set_model_versions(input);
            self
        }
        /// <p>The rule execution mode for the rules included in the detector version.</p>
        /// <p>You can define and edit the rule mode at the detector version level, when it is in draft status.</p>
        /// <p>If you specify <code>FIRST_MATCHED</code>, Amazon Fraud Detector evaluates rules sequentially, first to last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule.</p>
        /// <p>If you specifiy <code>ALL_MATCHED</code>, Amazon Fraud Detector evaluates all rules and returns the outcomes for all matched rules. </p>
        /// <p>The default behavior is <code>FIRST_MATCHED</code>.</p>
        pub fn rule_execution_mode(mut self, input: crate::model::RuleExecutionMode) -> Self {
            self.inner = self.inner.rule_execution_mode(input);
            self
        }
        /// <p>The rule execution mode for the rules included in the detector version.</p>
        /// <p>You can define and edit the rule mode at the detector version level, when it is in draft status.</p>
        /// <p>If you specify <code>FIRST_MATCHED</code>, Amazon Fraud Detector evaluates rules sequentially, first to last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule.</p>
        /// <p>If you specifiy <code>ALL_MATCHED</code>, Amazon Fraud Detector evaluates all rules and returns the outcomes for all matched rules. </p>
        /// <p>The default behavior is <code>FIRST_MATCHED</code>.</p>
        pub fn set_rule_execution_mode(
            mut self,
            input: std::option::Option<crate::model::RuleExecutionMode>,
        ) -> Self {
            self.inner = self.inner.set_rule_execution_mode(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateModel`.
    ///
    /// <p>Creates a model using the specified model type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateModel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_model_input::Builder,
    }
    impl CreateModel {
        /// Creates a new `CreateModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateModelOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateModelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The model ID.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_id(input.into());
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_id(input);
            self
        }
        /// <p>The model type. </p>
        pub fn model_type(mut self, input: crate::model::ModelTypeEnum) -> Self {
            self.inner = self.inner.model_type(input);
            self
        }
        /// <p>The model type. </p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_model_type(input);
            self
        }
        /// <p>The model description. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The model description. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The name of the event type.</p>
        pub fn event_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_type_name(input.into());
            self
        }
        /// <p>The name of the event type.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_type_name(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateModelVersion`.
    ///
    /// <p>Creates a version of the model using the specified model type and model id. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateModelVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_model_version_input::Builder,
    }
    impl CreateModelVersion {
        /// Creates a new `CreateModelVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateModelVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateModelVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The model ID. </p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_id(input.into());
            self
        }
        /// <p>The model ID. </p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_id(input);
            self
        }
        /// <p>The model type.</p>
        pub fn model_type(mut self, input: crate::model::ModelTypeEnum) -> Self {
            self.inner = self.inner.model_type(input);
            self
        }
        /// <p>The model type.</p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_model_type(input);
            self
        }
        /// <p>The training data source location in Amazon S3. </p>
        pub fn training_data_source(mut self, input: crate::model::TrainingDataSourceEnum) -> Self {
            self.inner = self.inner.training_data_source(input);
            self
        }
        /// <p>The training data source location in Amazon S3. </p>
        pub fn set_training_data_source(
            mut self,
            input: std::option::Option<crate::model::TrainingDataSourceEnum>,
        ) -> Self {
            self.inner = self.inner.set_training_data_source(input);
            self
        }
        /// <p>The training data schema.</p>
        pub fn training_data_schema(mut self, input: crate::model::TrainingDataSchema) -> Self {
            self.inner = self.inner.training_data_schema(input);
            self
        }
        /// <p>The training data schema.</p>
        pub fn set_training_data_schema(
            mut self,
            input: std::option::Option<crate::model::TrainingDataSchema>,
        ) -> Self {
            self.inner = self.inner.set_training_data_schema(input);
            self
        }
        /// <p>Details of the external events data used for model version training. Required if <code>trainingDataSource</code> is <code>EXTERNAL_EVENTS</code>.</p>
        pub fn external_events_detail(mut self, input: crate::model::ExternalEventsDetail) -> Self {
            self.inner = self.inner.external_events_detail(input);
            self
        }
        /// <p>Details of the external events data used for model version training. Required if <code>trainingDataSource</code> is <code>EXTERNAL_EVENTS</code>.</p>
        pub fn set_external_events_detail(
            mut self,
            input: std::option::Option<crate::model::ExternalEventsDetail>,
        ) -> Self {
            self.inner = self.inner.set_external_events_detail(input);
            self
        }
        /// <p>Details of the ingested events data used for model version training. Required if <code>trainingDataSource</code> is <code>INGESTED_EVENTS</code>.</p>
        pub fn ingested_events_detail(mut self, input: crate::model::IngestedEventsDetail) -> Self {
            self.inner = self.inner.ingested_events_detail(input);
            self
        }
        /// <p>Details of the ingested events data used for model version training. Required if <code>trainingDataSource</code> is <code>INGESTED_EVENTS</code>.</p>
        pub fn set_ingested_events_detail(
            mut self,
            input: std::option::Option<crate::model::IngestedEventsDetail>,
        ) -> Self {
            self.inner = self.inner.set_ingested_events_detail(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRule`.
    ///
    /// <p>Creates a rule for use with the specified detector. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_rule_input::Builder,
    }
    impl CreateRule {
        /// Creates a new `CreateRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The rule ID.</p>
        pub fn rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_id(input.into());
            self
        }
        /// <p>The rule ID.</p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_id(input);
            self
        }
        /// <p>The detector ID for the rule's parent detector.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(input.into());
            self
        }
        /// <p>The detector ID for the rule's parent detector.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The rule description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The rule description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The rule expression.</p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expression(input.into());
            self
        }
        /// <p>The rule expression.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_expression(input);
            self
        }
        /// <p>The language of the rule.</p>
        pub fn language(mut self, input: crate::model::Language) -> Self {
            self.inner = self.inner.language(input);
            self
        }
        /// <p>The language of the rule.</p>
        pub fn set_language(mut self, input: std::option::Option<crate::model::Language>) -> Self {
            self.inner = self.inner.set_language(input);
            self
        }
        /// Appends an item to `outcomes`.
        ///
        /// To override the contents of this collection use [`set_outcomes`](Self::set_outcomes).
        ///
        /// <p>The outcome or outcomes returned when the rule expression matches.</p>
        pub fn outcomes(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.outcomes(input.into());
            self
        }
        /// <p>The outcome or outcomes returned when the rule expression matches.</p>
        pub fn set_outcomes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_outcomes(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateVariable`.
    ///
    /// <p>Creates a variable.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateVariable {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_variable_input::Builder,
    }
    impl CreateVariable {
        /// Creates a new `CreateVariable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateVariableOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateVariableError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the variable.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the variable.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The data type.</p>
        pub fn data_type(mut self, input: crate::model::DataType) -> Self {
            self.inner = self.inner.data_type(input);
            self
        }
        /// <p>The data type.</p>
        pub fn set_data_type(mut self, input: std::option::Option<crate::model::DataType>) -> Self {
            self.inner = self.inner.set_data_type(input);
            self
        }
        /// <p>The source of the data.</p>
        pub fn data_source(mut self, input: crate::model::DataSource) -> Self {
            self.inner = self.inner.data_source(input);
            self
        }
        /// <p>The source of the data.</p>
        pub fn set_data_source(
            mut self,
            input: std::option::Option<crate::model::DataSource>,
        ) -> Self {
            self.inner = self.inner.set_data_source(input);
            self
        }
        /// <p>The default value for the variable when no value is received.</p>
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_value(input.into());
            self
        }
        /// <p>The default value for the variable when no value is received.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_value(input);
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The variable type. For more information see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable types</a>. </p>
        /// <p>Valid Values: <code>AUTH_CODE | AVS | BILLING_ADDRESS_L1 | BILLING_ADDRESS_L2 | BILLING_CITY | BILLING_COUNTRY | BILLING_NAME | BILLING_PHONE | BILLING_STATE | BILLING_ZIP | CARD_BIN | CATEGORICAL | CURRENCY_CODE | EMAIL_ADDRESS | FINGERPRINT | FRAUD_LABEL | FREE_FORM_TEXT | IP_ADDRESS | NUMERIC | ORDER_ID | PAYMENT_TYPE | PHONE_NUMBER | PRICE | PRODUCT_CATEGORY | SHIPPING_ADDRESS_L1 | SHIPPING_ADDRESS_L2 | SHIPPING_CITY | SHIPPING_COUNTRY | SHIPPING_NAME | SHIPPING_PHONE | SHIPPING_STATE | SHIPPING_ZIP | USERAGENT</code> </p>
        pub fn variable_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.variable_type(input.into());
            self
        }
        /// <p>The variable type. For more information see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable types</a>. </p>
        /// <p>Valid Values: <code>AUTH_CODE | AVS | BILLING_ADDRESS_L1 | BILLING_ADDRESS_L2 | BILLING_CITY | BILLING_COUNTRY | BILLING_NAME | BILLING_PHONE | BILLING_STATE | BILLING_ZIP | CARD_BIN | CATEGORICAL | CURRENCY_CODE | EMAIL_ADDRESS | FINGERPRINT | FRAUD_LABEL | FREE_FORM_TEXT | IP_ADDRESS | NUMERIC | ORDER_ID | PAYMENT_TYPE | PHONE_NUMBER | PRICE | PRODUCT_CATEGORY | SHIPPING_ADDRESS_L1 | SHIPPING_ADDRESS_L2 | SHIPPING_CITY | SHIPPING_COUNTRY | SHIPPING_NAME | SHIPPING_PHONE | SHIPPING_STATE | SHIPPING_ZIP | USERAGENT</code> </p>
        pub fn set_variable_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_variable_type(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBatchImportJob`.
    ///
    /// <p>Deletes data that was batch imported to Amazon Fraud Detector. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBatchImportJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_batch_import_job_input::Builder,
    }
    impl DeleteBatchImportJob {
        /// Creates a new `DeleteBatchImportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBatchImportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBatchImportJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the batch import job to delete. </p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The ID of the batch import job to delete. </p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBatchPredictionJob`.
    ///
    /// <p>Deletes a batch prediction job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBatchPredictionJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_batch_prediction_job_input::Builder,
    }
    impl DeleteBatchPredictionJob {
        /// Creates a new `DeleteBatchPredictionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBatchPredictionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBatchPredictionJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the batch prediction job to delete.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The ID of the batch prediction job to delete.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDetector`.
    ///
    /// <p>Deletes the detector. Before deleting a detector, you must first delete all detector versions and rule versions associated with the detector.</p>
    /// <p>When you delete a detector, Amazon Fraud Detector permanently deletes the detector and the data is no longer stored in Amazon Fraud Detector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDetector {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_detector_input::Builder,
    }
    impl DeleteDetector {
        /// Creates a new `DeleteDetector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDetectorOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDetectorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the detector to delete.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(input.into());
            self
        }
        /// <p>The ID of the detector to delete.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDetectorVersion`.
    ///
    /// <p>Deletes the detector version. You cannot delete detector versions that are in <code>ACTIVE</code> status.</p>
    /// <p>When you delete a detector version, Amazon Fraud Detector permanently deletes the detector and the data is no longer stored in Amazon Fraud Detector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDetectorVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_detector_version_input::Builder,
    }
    impl DeleteDetectorVersion {
        /// Creates a new `DeleteDetectorVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDetectorVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDetectorVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the parent detector for the detector version to delete.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(input.into());
            self
        }
        /// <p>The ID of the parent detector for the detector version to delete.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The ID of the detector version to delete.</p>
        pub fn detector_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_version_id(input.into());
            self
        }
        /// <p>The ID of the detector version to delete.</p>
        pub fn set_detector_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_detector_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEntityType`.
    ///
    /// <p>Deletes an entity type.</p>
    /// <p>You cannot delete an entity type that is included in an event type.</p>
    /// <p>When you delete an entity type, Amazon Fraud Detector permanently deletes that entity type and the data is no longer stored in Amazon Fraud Detector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEntityType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_entity_type_input::Builder,
    }
    impl DeleteEntityType {
        /// Creates a new `DeleteEntityType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEntityTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEntityTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the entity type to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the entity type to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEvent`.
    ///
    /// <p>Deletes the specified event.</p>
    /// <p>When you delete an event, Amazon Fraud Detector permanently deletes that event and the event data is no longer stored in Amazon Fraud Detector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEvent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_event_input::Builder,
    }
    impl DeleteEvent {
        /// Creates a new `DeleteEvent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEventOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEventError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the event to delete.</p>
        pub fn event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_id(input.into());
            self
        }
        /// <p>The ID of the event to delete.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_event_id(input);
            self
        }
        /// <p>The name of the event type.</p>
        pub fn event_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_type_name(input.into());
            self
        }
        /// <p>The name of the event type.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_type_name(input);
            self
        }
        /// <p>Specifies whether or not to delete any predictions associated with the event.</p>
        pub fn delete_audit_history(mut self, input: bool) -> Self {
            self.inner = self.inner.delete_audit_history(input);
            self
        }
        /// <p>Specifies whether or not to delete any predictions associated with the event.</p>
        pub fn set_delete_audit_history(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_delete_audit_history(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEventsByEventType`.
    ///
    /// <p>Deletes all events of a particular event type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEventsByEventType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_events_by_event_type_input::Builder,
    }
    impl DeleteEventsByEventType {
        /// Creates a new `DeleteEventsByEventType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEventsByEventTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEventsByEventTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the event type.</p>
        pub fn event_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_type_name(input.into());
            self
        }
        /// <p>The name of the event type.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_type_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEventType`.
    ///
    /// <p>Deletes an event type.</p>
    /// <p>You cannot delete an event type that is used in a detector or a model.</p>
    /// <p>When you delete an event type, Amazon Fraud Detector permanently deletes that event type and the data is no longer stored in Amazon Fraud Detector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEventType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_event_type_input::Builder,
    }
    impl DeleteEventType {
        /// Creates a new `DeleteEventType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEventTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEventTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the event type to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the event type to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteExternalModel`.
    ///
    /// <p>Removes a SageMaker model from Amazon Fraud Detector.</p>
    /// <p>You can remove an Amazon SageMaker model if it is not associated with a detector version. Removing a SageMaker model disconnects it from Amazon Fraud Detector, but the model remains available in SageMaker.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteExternalModel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_external_model_input::Builder,
    }
    impl DeleteExternalModel {
        /// Creates a new `DeleteExternalModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteExternalModelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteExternalModelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The endpoint of the Amazon Sagemaker model to delete.</p>
        pub fn model_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_endpoint(input.into());
            self
        }
        /// <p>The endpoint of the Amazon Sagemaker model to delete.</p>
        pub fn set_model_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_endpoint(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLabel`.
    ///
    /// <p>Deletes a label.</p>
    /// <p>You cannot delete labels that are included in an event type in Amazon Fraud Detector.</p>
    /// <p>You cannot delete a label assigned to an event ID. You must first delete the relevant event ID.</p>
    /// <p>When you delete a label, Amazon Fraud Detector permanently deletes that label and the data is no longer stored in Amazon Fraud Detector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLabel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_label_input::Builder,
    }
    impl DeleteLabel {
        /// Creates a new `DeleteLabel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLabelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLabelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the label to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the label to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteModel`.
    ///
    /// <p>Deletes a model.</p>
    /// <p>You can delete models and model versions in Amazon Fraud Detector, provided that they are not associated with a detector version.</p>
    /// <p> When you delete a model, Amazon Fraud Detector permanently deletes that model and the data is no longer stored in Amazon Fraud Detector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteModel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_model_input::Builder,
    }
    impl DeleteModel {
        /// Creates a new `DeleteModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteModelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteModelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The model ID of the model to delete.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_id(input.into());
            self
        }
        /// <p>The model ID of the model to delete.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_id(input);
            self
        }
        /// <p>The model type of the model to delete.</p>
        pub fn model_type(mut self, input: crate::model::ModelTypeEnum) -> Self {
            self.inner = self.inner.model_type(input);
            self
        }
        /// <p>The model type of the model to delete.</p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_model_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteModelVersion`.
    ///
    /// <p>Deletes a model version.</p>
    /// <p>You can delete models and model versions in Amazon Fraud Detector, provided that they are not associated with a detector version.</p>
    /// <p> When you delete a model version, Amazon Fraud Detector permanently deletes that model version and the data is no longer stored in Amazon Fraud Detector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteModelVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_model_version_input::Builder,
    }
    impl DeleteModelVersion {
        /// Creates a new `DeleteModelVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteModelVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteModelVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The model ID of the model version to delete.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_id(input.into());
            self
        }
        /// <p>The model ID of the model version to delete.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_id(input);
            self
        }
        /// <p>The model type of the model version to delete.</p>
        pub fn model_type(mut self, input: crate::model::ModelTypeEnum) -> Self {
            self.inner = self.inner.model_type(input);
            self
        }
        /// <p>The model type of the model version to delete.</p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_model_type(input);
            self
        }
        /// <p>The model version number of the model version to delete.</p>
        pub fn model_version_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_version_number(input.into());
            self
        }
        /// <p>The model version number of the model version to delete.</p>
        pub fn set_model_version_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_version_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteOutcome`.
    ///
    /// <p>Deletes an outcome.</p>
    /// <p>You cannot delete an outcome that is used in a rule version.</p>
    /// <p>When you delete an outcome, Amazon Fraud Detector permanently deletes that outcome and the data is no longer stored in Amazon Fraud Detector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteOutcome {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_outcome_input::Builder,
    }
    impl DeleteOutcome {
        /// Creates a new `DeleteOutcome`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteOutcomeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteOutcomeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the outcome to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the outcome to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRule`.
    ///
    /// <p>Deletes the rule. You cannot delete a rule if it is used by an <code>ACTIVE</code> or <code>INACTIVE</code> detector version.</p>
    /// <p>When you delete a rule, Amazon Fraud Detector permanently deletes that rule and the data is no longer stored in Amazon Fraud Detector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_rule_input::Builder,
    }
    impl DeleteRule {
        /// Creates a new `DeleteRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A rule.</p>
        pub fn rule(mut self, input: crate::model::Rule) -> Self {
            self.inner = self.inner.rule(input);
            self
        }
        /// <p>A rule.</p>
        pub fn set_rule(mut self, input: std::option::Option<crate::model::Rule>) -> Self {
            self.inner = self.inner.set_rule(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVariable`.
    ///
    /// <p>Deletes a variable.</p>
    /// <p>You can't delete variables that are included in an event type in Amazon Fraud Detector.</p>
    /// <p>Amazon Fraud Detector automatically deletes model output variables and SageMaker model output variables when you delete the model. You can't delete these variables manually.</p>
    /// <p>When you delete a variable, Amazon Fraud Detector permanently deletes that variable and the data is no longer stored in Amazon Fraud Detector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteVariable {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_variable_input::Builder,
    }
    impl DeleteVariable {
        /// Creates a new `DeleteVariable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVariableOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVariableError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the variable to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the variable to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDetector`.
    ///
    /// <p>Gets all versions for a specified detector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDetector {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_detector_input::Builder,
    }
    impl DescribeDetector {
        /// Creates a new `DescribeDetector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDetectorOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDetectorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The detector ID.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(input.into());
            self
        }
        /// <p>The detector ID.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The next token from the previous response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next token from the previous response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for the request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeModelVersions`.
    ///
    /// <p>Gets all of the model versions for the specified model type or for the specified model type and model ID. You can also get details for a single, specified model version. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeModelVersions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_model_versions_input::Builder,
    }
    impl DescribeModelVersions {
        /// Creates a new `DescribeModelVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeModelVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeModelVersionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeModelVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeModelVersionsPaginator {
            crate::paginator::DescribeModelVersionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The model ID.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_id(input.into());
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_id(input);
            self
        }
        /// <p>The model version number.</p>
        pub fn model_version_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_version_number(input.into());
            self
        }
        /// <p>The model version number.</p>
        pub fn set_model_version_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_version_number(input);
            self
        }
        /// <p>The model type.</p>
        pub fn model_type(mut self, input: crate::model::ModelTypeEnum) -> Self {
            self.inner = self.inner.model_type(input);
            self
        }
        /// <p>The model type.</p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_model_type(input);
            self
        }
        /// <p>The next token from the previous results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next token from the previous results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBatchImportJobs`.
    ///
    /// <p>Gets all batch import jobs or a specific job of the specified ID. This is a paginated API. If you provide a null <code>maxResults</code>, this action retrieves a maximum of 50 records per page. If you provide a <code>maxResults</code>, the value must be between 1 and 50. To get the next page results, provide the pagination token from the <code>GetBatchImportJobsResponse</code> as part of your request. A null pagination token fetches the records from the beginning.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBatchImportJobs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_batch_import_jobs_input::Builder,
    }
    impl GetBatchImportJobs {
        /// Creates a new `GetBatchImportJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBatchImportJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBatchImportJobsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetBatchImportJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetBatchImportJobsPaginator {
            crate::paginator::GetBatchImportJobsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the batch import job to get.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The ID of the batch import job to get.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The maximum number of objects to return for request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of objects to return for request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The next token from the previous request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next token from the previous request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBatchPredictionJobs`.
    ///
    /// <p>Gets all batch prediction jobs or a specific job if you specify a job ID. This is a paginated API. If you provide a null maxResults, this action retrieves a maximum of 50 records per page. If you provide a maxResults, the value must be between 1 and 50. To get the next page results, provide the pagination token from the GetBatchPredictionJobsResponse as part of your request. A null pagination token fetches the records from the beginning.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBatchPredictionJobs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_batch_prediction_jobs_input::Builder,
    }
    impl GetBatchPredictionJobs {
        /// Creates a new `GetBatchPredictionJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBatchPredictionJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBatchPredictionJobsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetBatchPredictionJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetBatchPredictionJobsPaginator {
            crate::paginator::GetBatchPredictionJobsPaginator::new(self.handle, self.inner)
        }
        /// <p>The batch prediction job for which to get the details.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The batch prediction job for which to get the details.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The next token from the previous request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next token from the previous request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDeleteEventsByEventTypeStatus`.
    ///
    /// <p>Retrieves the status of a <code>DeleteEventsByEventType</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDeleteEventsByEventTypeStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_delete_events_by_event_type_status_input::Builder,
    }
    impl GetDeleteEventsByEventTypeStatus {
        /// Creates a new `GetDeleteEventsByEventTypeStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeleteEventsByEventTypeStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeleteEventsByEventTypeStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of event type for which to get the deletion status.</p>
        pub fn event_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_type_name(input.into());
            self
        }
        /// <p>Name of event type for which to get the deletion status.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_type_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDetectors`.
    ///
    /// <p>Gets all detectors or a single detector if a <code>detectorId</code> is specified. This is a paginated API. If you provide a null <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you provide a <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the pagination token from the <code>GetDetectorsResponse</code> as part of your request. A null pagination token fetches the records from the beginning. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDetectors {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_detectors_input::Builder,
    }
    impl GetDetectors {
        /// Creates a new `GetDetectors`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDetectorsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDetectorsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetDetectorsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetDetectorsPaginator {
            crate::paginator::GetDetectorsPaginator::new(self.handle, self.inner)
        }
        /// <p>The detector ID.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(input.into());
            self
        }
        /// <p>The detector ID.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The next token for the subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next token for the subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDetectorVersion`.
    ///
    /// <p>Gets a particular detector version. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDetectorVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_detector_version_input::Builder,
    }
    impl GetDetectorVersion {
        /// Creates a new `GetDetectorVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDetectorVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDetectorVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The detector ID.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(input.into());
            self
        }
        /// <p>The detector ID.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The detector version ID.</p>
        pub fn detector_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_version_id(input.into());
            self
        }
        /// <p>The detector version ID.</p>
        pub fn set_detector_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_detector_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEntityTypes`.
    ///
    /// <p>Gets all entity types or a specific entity type if a name is specified. This is a paginated API. If you provide a null <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you provide a <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the pagination token from the <code>GetEntityTypesResponse</code> as part of your request. A null pagination token fetches the records from the beginning. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEntityTypes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_entity_types_input::Builder,
    }
    impl GetEntityTypes {
        /// Creates a new `GetEntityTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEntityTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEntityTypesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetEntityTypesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetEntityTypesPaginator {
            crate::paginator::GetEntityTypesPaginator::new(self.handle, self.inner)
        }
        /// <p>The name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The next token for the subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next token for the subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEvent`.
    ///
    /// <p>Retrieves details of events stored with Amazon Fraud Detector. This action does not retrieve prediction results.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEvent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_event_input::Builder,
    }
    impl GetEvent {
        /// Creates a new `GetEvent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEventOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEventError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the event to retrieve.</p>
        pub fn event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_id(input.into());
            self
        }
        /// <p>The ID of the event to retrieve.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_event_id(input);
            self
        }
        /// <p>The event type of the event to retrieve.</p>
        pub fn event_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_type_name(input.into());
            self
        }
        /// <p>The event type of the event to retrieve.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_type_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEventPrediction`.
    ///
    /// <p>Evaluates an event against a detector version. If a version ID is not provided, the detector’s (<code>ACTIVE</code>) version is used.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEventPrediction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_event_prediction_input::Builder,
    }
    impl GetEventPrediction {
        /// Creates a new `GetEventPrediction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEventPredictionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEventPredictionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The detector ID.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(input.into());
            self
        }
        /// <p>The detector ID.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The detector version ID.</p>
        pub fn detector_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_version_id(input.into());
            self
        }
        /// <p>The detector version ID.</p>
        pub fn set_detector_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_detector_version_id(input);
            self
        }
        /// <p>The unique ID used to identify the event.</p>
        pub fn event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_id(input.into());
            self
        }
        /// <p>The unique ID used to identify the event.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_event_id(input);
            self
        }
        /// <p>The event type associated with the detector specified for the prediction.</p>
        pub fn event_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_type_name(input.into());
            self
        }
        /// <p>The event type associated with the detector specified for the prediction.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_type_name(input);
            self
        }
        /// Appends an item to `entities`.
        ///
        /// To override the contents of this collection use [`set_entities`](Self::set_entities).
        ///
        /// <p>The entity type (associated with the detector's event type) and specific entity ID representing who performed the event. If an entity id is not available, use "UNKNOWN."</p>
        pub fn entities(mut self, input: crate::model::Entity) -> Self {
            self.inner = self.inner.entities(input);
            self
        }
        /// <p>The entity type (associated with the detector's event type) and specific entity ID representing who performed the event. If an entity id is not available, use "UNKNOWN."</p>
        pub fn set_entities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Entity>>,
        ) -> Self {
            self.inner = self.inner.set_entities(input);
            self
        }
        /// <p>Timestamp that defines when the event under evaluation occurred. The timestamp must be specified using ISO 8601 standard in UTC.</p>
        pub fn event_timestamp(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_timestamp(input.into());
            self
        }
        /// <p>Timestamp that defines when the event under evaluation occurred. The timestamp must be specified using ISO 8601 standard in UTC.</p>
        pub fn set_event_timestamp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_timestamp(input);
            self
        }
        /// Adds a key-value pair to `eventVariables`.
        ///
        /// To override the contents of this collection use [`set_event_variables`](Self::set_event_variables).
        ///
        /// <p>Names of the event type's variables you defined in Amazon Fraud Detector to represent data elements and their corresponding values for the event you are sending for evaluation.</p> <important>
        /// <p>You must provide at least one eventVariable</p>
        /// </important>
        /// <p>To ensure most accurate fraud prediction and to simplify your data preparation, Amazon Fraud Detector will replace all missing variables or values as follows:</p>
        /// <p> <b>For Amazon Fraud Detector trained models:</b> </p>
        /// <p>If a null value is provided explicitly for a variable or if a variable is missing, model will replace the null value or the missing variable (no variable name in the eventVariables map) with calculated default mean/medians for numeric variables and with special values for categorical variables.</p>
        /// <p> <b>For imported SageMaker models:</b> </p>
        /// <p>If a null value is provided explicitly for a variable, the model and rules will use “null” as the value. If a variable is not provided (no variable name in the eventVariables map), model and rules will use the default value that is provided for the variable. </p>
        pub fn event_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.event_variables(k.into(), v.into());
            self
        }
        /// <p>Names of the event type's variables you defined in Amazon Fraud Detector to represent data elements and their corresponding values for the event you are sending for evaluation.</p> <important>
        /// <p>You must provide at least one eventVariable</p>
        /// </important>
        /// <p>To ensure most accurate fraud prediction and to simplify your data preparation, Amazon Fraud Detector will replace all missing variables or values as follows:</p>
        /// <p> <b>For Amazon Fraud Detector trained models:</b> </p>
        /// <p>If a null value is provided explicitly for a variable or if a variable is missing, model will replace the null value or the missing variable (no variable name in the eventVariables map) with calculated default mean/medians for numeric variables and with special values for categorical variables.</p>
        /// <p> <b>For imported SageMaker models:</b> </p>
        /// <p>If a null value is provided explicitly for a variable, the model and rules will use “null” as the value. If a variable is not provided (no variable name in the eventVariables map), model and rules will use the default value that is provided for the variable. </p>
        pub fn set_event_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_event_variables(input);
            self
        }
        /// Adds a key-value pair to `externalModelEndpointDataBlobs`.
        ///
        /// To override the contents of this collection use [`set_external_model_endpoint_data_blobs`](Self::set_external_model_endpoint_data_blobs).
        ///
        /// <p>The Amazon SageMaker model endpoint input data blobs.</p>
        pub fn external_model_endpoint_data_blobs(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ModelEndpointDataBlob,
        ) -> Self {
            self.inner = self.inner.external_model_endpoint_data_blobs(k.into(), v);
            self
        }
        /// <p>The Amazon SageMaker model endpoint input data blobs.</p>
        pub fn set_external_model_endpoint_data_blobs(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ModelEndpointDataBlob>,
            >,
        ) -> Self {
            self.inner = self.inner.set_external_model_endpoint_data_blobs(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEventPredictionMetadata`.
    ///
    /// <p> Gets details of the past fraud predictions for the specified event ID, event type, detector ID, and detector version ID that was generated in the specified time period. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEventPredictionMetadata {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_event_prediction_metadata_input::Builder,
    }
    impl GetEventPredictionMetadata {
        /// Creates a new `GetEventPredictionMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEventPredictionMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEventPredictionMetadataError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The event ID. </p>
        pub fn event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_id(input.into());
            self
        }
        /// <p> The event ID. </p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_event_id(input);
            self
        }
        /// <p> The event type associated with the detector specified for the prediction. </p>
        pub fn event_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_type_name(input.into());
            self
        }
        /// <p> The event type associated with the detector specified for the prediction. </p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_type_name(input);
            self
        }
        /// <p> The detector ID. </p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(input.into());
            self
        }
        /// <p> The detector ID. </p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p> The detector version ID. </p>
        pub fn detector_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_version_id(input.into());
            self
        }
        /// <p> The detector version ID. </p>
        pub fn set_detector_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_detector_version_id(input);
            self
        }
        /// <p> The timestamp that defines when the prediction was generated. </p>
        pub fn prediction_timestamp(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.prediction_timestamp(input.into());
            self
        }
        /// <p> The timestamp that defines when the prediction was generated. </p>
        pub fn set_prediction_timestamp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_prediction_timestamp(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEventTypes`.
    ///
    /// <p>Gets all event types or a specific event type if name is provided. This is a paginated API. If you provide a null <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you provide a <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the pagination token from the <code>GetEventTypesResponse</code> as part of your request. A null pagination token fetches the records from the beginning. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEventTypes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_event_types_input::Builder,
    }
    impl GetEventTypes {
        /// Creates a new `GetEventTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEventTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEventTypesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetEventTypesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetEventTypesPaginator {
            crate::paginator::GetEventTypesPaginator::new(self.handle, self.inner)
        }
        /// <p>The name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The next token for the subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next token for the subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetExternalModels`.
    ///
    /// <p>Gets the details for one or more Amazon SageMaker models that have been imported into the service. This is a paginated API. If you provide a null <code>maxResults</code>, this actions retrieves a maximum of 10 records per page. If you provide a <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the pagination token from the <code>GetExternalModelsResult</code> as part of your request. A null pagination token fetches the records from the beginning. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetExternalModels {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_external_models_input::Builder,
    }
    impl GetExternalModels {
        /// Creates a new `GetExternalModels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetExternalModelsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetExternalModelsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetExternalModelsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetExternalModelsPaginator {
            crate::paginator::GetExternalModelsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon SageMaker model endpoint.</p>
        pub fn model_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_endpoint(input.into());
            self
        }
        /// <p>The Amazon SageMaker model endpoint.</p>
        pub fn set_model_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_endpoint(input);
            self
        }
        /// <p>The next page token for the request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next page token for the request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetKMSEncryptionKey`.
    ///
    /// <p>Gets the encryption key if a KMS key has been specified to be used to encrypt content in Amazon Fraud Detector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetKMSEncryptionKey {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_kms_encryption_key_input::Builder,
    }
    impl GetKMSEncryptionKey {
        /// Creates a new `GetKMSEncryptionKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetKmsEncryptionKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetKMSEncryptionKeyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetLabels`.
    ///
    /// <p>Gets all labels or a specific label if name is provided. This is a paginated API. If you provide a null <code>maxResults</code>, this action retrieves a maximum of 50 records per page. If you provide a <code>maxResults</code>, the value must be between 10 and 50. To get the next page results, provide the pagination token from the <code>GetGetLabelsResponse</code> as part of your request. A null pagination token fetches the records from the beginning. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLabels {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_labels_input::Builder,
    }
    impl GetLabels {
        /// Creates a new `GetLabels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLabelsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLabelsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetLabelsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetLabelsPaginator {
            crate::paginator::GetLabelsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the label or labels to get.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the label or labels to get.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The next token for the subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next token for the subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetModels`.
    ///
    /// <p>Gets one or more models. Gets all models for the Amazon Web Services account if no model type and no model id provided. Gets all models for the Amazon Web Services account and model type, if the model type is specified but model id is not provided. Gets a specific model if (model type, model id) tuple is specified. </p>
    /// <p>This is a paginated API. If you provide a null <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you provide a <code>maxResults</code>, the value must be between 1 and 10. To get the next page results, provide the pagination token from the response as part of your request. A null pagination token fetches the records from the beginning.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetModels {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_models_input::Builder,
    }
    impl GetModels {
        /// Creates a new `GetModels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetModelsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetModelsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetModelsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetModelsPaginator {
            crate::paginator::GetModelsPaginator::new(self.handle, self.inner)
        }
        /// <p>The model ID.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_id(input.into());
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_id(input);
            self
        }
        /// <p>The model type.</p>
        pub fn model_type(mut self, input: crate::model::ModelTypeEnum) -> Self {
            self.inner = self.inner.model_type(input);
            self
        }
        /// <p>The model type.</p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_model_type(input);
            self
        }
        /// <p>The next token for the subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next token for the subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects to return for the request. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of objects to return for the request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetModelVersion`.
    ///
    /// <p>Gets the details of the specified model version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetModelVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_model_version_input::Builder,
    }
    impl GetModelVersion {
        /// Creates a new `GetModelVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetModelVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetModelVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The model ID.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_id(input.into());
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_id(input);
            self
        }
        /// <p>The model type.</p>
        pub fn model_type(mut self, input: crate::model::ModelTypeEnum) -> Self {
            self.inner = self.inner.model_type(input);
            self
        }
        /// <p>The model type.</p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_model_type(input);
            self
        }
        /// <p>The model version number.</p>
        pub fn model_version_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_version_number(input.into());
            self
        }
        /// <p>The model version number.</p>
        pub fn set_model_version_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_version_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetOutcomes`.
    ///
    /// <p>Gets one or more outcomes. This is a paginated API. If you provide a null <code>maxResults</code>, this actions retrieves a maximum of 100 records per page. If you provide a <code>maxResults</code>, the value must be between 50 and 100. To get the next page results, provide the pagination token from the <code>GetOutcomesResult</code> as part of your request. A null pagination token fetches the records from the beginning. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetOutcomes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_outcomes_input::Builder,
    }
    impl GetOutcomes {
        /// Creates a new `GetOutcomes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOutcomesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetOutcomesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetOutcomesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetOutcomesPaginator {
            crate::paginator::GetOutcomesPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the outcome or outcomes to get.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the outcome or outcomes to get.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The next page token for the request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next page token for the request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects to return for the request. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of objects to return for the request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRules`.
    ///
    /// <p>Get all rules for a detector (paginated) if <code>ruleId</code> and <code>ruleVersion</code> are not specified. Gets all rules for the detector and the <code>ruleId</code> if present (paginated). Gets a specific rule if both the <code>ruleId</code> and the <code>ruleVersion</code> are specified.</p>
    /// <p>This is a paginated API. Providing null maxResults results in retrieving maximum of 100 records per page. If you provide maxResults the value must be between 50 and 100. To get the next page result, a provide a pagination token from GetRulesResult as part of your request. Null pagination token fetches the records from the beginning.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRules {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_rules_input::Builder,
    }
    impl GetRules {
        /// Creates a new `GetRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRulesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetRulesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetRulesPaginator {
            crate::paginator::GetRulesPaginator::new(self.handle, self.inner)
        }
        /// <p>The rule ID.</p>
        pub fn rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_id(input.into());
            self
        }
        /// <p>The rule ID.</p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_id(input);
            self
        }
        /// <p>The detector ID.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(input.into());
            self
        }
        /// <p>The detector ID.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The rule version.</p>
        pub fn rule_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_version(input.into());
            self
        }
        /// <p>The rule version.</p>
        pub fn set_rule_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_version(input);
            self
        }
        /// <p>The next page token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next page token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of rules to return for the request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of rules to return for the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVariables`.
    ///
    /// <p>Gets all of the variables or the specific variable. This is a paginated API. Providing null <code>maxSizePerPage</code> results in retrieving maximum of 100 records per page. If you provide <code>maxSizePerPage</code> the value must be between 50 and 100. To get the next page result, a provide a pagination token from <code>GetVariablesResult</code> as part of your request. Null pagination token fetches the records from the beginning. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetVariables {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_variables_input::Builder,
    }
    impl GetVariables {
        /// Creates a new `GetVariables`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetVariablesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetVariablesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetVariablesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetVariablesPaginator {
            crate::paginator::GetVariablesPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the variable. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the variable. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The next page token of the get variable request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next page token of the get variable request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The max size per page determined for the get variable request. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The max size per page determined for the get variable request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEventPredictions`.
    ///
    /// <p>Gets a list of past predictions. The list can be filtered by detector ID, detector version ID, event ID, event type, or by specifying a time period. If filter is not specified, the most recent prediction is returned.</p>
    /// <p>For example, the following filter lists all past predictions for <code>xyz</code> event type - <code>{ "eventType":{ "value": "xyz" }” } </code> </p>
    /// <p>This is a paginated API. If you provide a null <code>maxResults</code>, this action will retrieve a maximum of 10 records per page. If you provide a <code>maxResults</code>, the value must be between 50 and 100. To get the next page results, provide the <code>nextToken</code> from the response as part of your request. A null <code>nextToken</code> fetches the records from the beginning. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEventPredictions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_event_predictions_input::Builder,
    }
    impl ListEventPredictions {
        /// Creates a new `ListEventPredictions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEventPredictionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEventPredictionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListEventPredictionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListEventPredictionsPaginator {
            crate::paginator::ListEventPredictionsPaginator::new(self.handle, self.inner)
        }
        /// <p> The event ID. </p>
        pub fn event_id(mut self, input: crate::model::FilterCondition) -> Self {
            self.inner = self.inner.event_id(input);
            self
        }
        /// <p> The event ID. </p>
        pub fn set_event_id(
            mut self,
            input: std::option::Option<crate::model::FilterCondition>,
        ) -> Self {
            self.inner = self.inner.set_event_id(input);
            self
        }
        /// <p> The event type associated with the detector. </p>
        pub fn event_type(mut self, input: crate::model::FilterCondition) -> Self {
            self.inner = self.inner.event_type(input);
            self
        }
        /// <p> The event type associated with the detector. </p>
        pub fn set_event_type(
            mut self,
            input: std::option::Option<crate::model::FilterCondition>,
        ) -> Self {
            self.inner = self.inner.set_event_type(input);
            self
        }
        /// <p> The detector ID. </p>
        pub fn detector_id(mut self, input: crate::model::FilterCondition) -> Self {
            self.inner = self.inner.detector_id(input);
            self
        }
        /// <p> The detector ID. </p>
        pub fn set_detector_id(
            mut self,
            input: std::option::Option<crate::model::FilterCondition>,
        ) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p> The detector version ID. </p>
        pub fn detector_version_id(mut self, input: crate::model::FilterCondition) -> Self {
            self.inner = self.inner.detector_version_id(input);
            self
        }
        /// <p> The detector version ID. </p>
        pub fn set_detector_version_id(
            mut self,
            input: std::option::Option<crate::model::FilterCondition>,
        ) -> Self {
            self.inner = self.inner.set_detector_version_id(input);
            self
        }
        /// <p> The time period for when the predictions were generated. </p>
        pub fn prediction_time_range(mut self, input: crate::model::PredictionTimeRange) -> Self {
            self.inner = self.inner.prediction_time_range(input);
            self
        }
        /// <p> The time period for when the predictions were generated. </p>
        pub fn set_prediction_time_range(
            mut self,
            input: std::option::Option<crate::model::PredictionTimeRange>,
        ) -> Self {
            self.inner = self.inner.set_prediction_time_range(input);
            self
        }
        /// <p> Identifies the next page of results to return. Use the token to make the call again to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> Identifies the next page of results to return. Use the token to make the call again to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of predictions to return for the request. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of predictions to return for the request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists all tags associated with the resource. This is a paginated API. To get the next page results, provide the pagination token from the response as part of your request. A null pagination token fetches the records from the beginning. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTagsForResourcePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTagsForResourcePaginator {
            crate::paginator::ListTagsForResourcePaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN that specifies the resource whose tags you want to list.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN that specifies the resource whose tags you want to list.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The next token from the previous results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The next token from the previous results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects to return for the request. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of objects to return for the request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutDetector`.
    ///
    /// <p>Creates or updates a detector. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutDetector {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_detector_input::Builder,
    }
    impl PutDetector {
        /// Creates a new `PutDetector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutDetectorOutput,
            aws_smithy_http::result::SdkError<crate::error::PutDetectorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The detector ID. </p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(input.into());
            self
        }
        /// <p>The detector ID. </p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The description of the detector.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the detector.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The name of the event type.</p>
        pub fn event_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_type_name(input.into());
            self
        }
        /// <p>The name of the event type.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_type_name(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutEntityType`.
    ///
    /// <p>Creates or updates an entity type. An entity represents who is performing the event. As part of a fraud prediction, you pass the entity ID to indicate the specific entity who performed the event. An entity type classifies the entity. Example classifications include customer, merchant, or account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutEntityType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_entity_type_input::Builder,
    }
    impl PutEntityType {
        /// Creates a new `PutEntityType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutEntityTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::PutEntityTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the entity type.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the entity type.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutEventType`.
    ///
    /// <p>Creates or updates an event type. An event is a business activity that is evaluated for fraud risk. With Amazon Fraud Detector, you generate fraud predictions for events. An event type defines the structure for an event sent to Amazon Fraud Detector. This includes the variables sent as part of the event, the entity performing the event (such as a customer), and the labels that classify the event. Example event types include online payment transactions, account registrations, and authentications.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutEventType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_event_type_input::Builder,
    }
    impl PutEventType {
        /// Creates a new `PutEventType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutEventTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::PutEventTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the event type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the event type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `eventVariables`.
        ///
        /// To override the contents of this collection use [`set_event_variables`](Self::set_event_variables).
        ///
        /// <p>The event type variables.</p>
        pub fn event_variables(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_variables(input.into());
            self
        }
        /// <p>The event type variables.</p>
        pub fn set_event_variables(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_event_variables(input);
            self
        }
        /// Appends an item to `labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// <p>The event type labels.</p>
        pub fn labels(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.labels(input.into());
            self
        }
        /// <p>The event type labels.</p>
        pub fn set_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_labels(input);
            self
        }
        /// Appends an item to `entityTypes`.
        ///
        /// To override the contents of this collection use [`set_entity_types`](Self::set_entity_types).
        ///
        /// <p>The entity type for the event type. Example entity types: customer, merchant, account.</p>
        pub fn entity_types(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_types(input.into());
            self
        }
        /// <p>The entity type for the event type. Example entity types: customer, merchant, account.</p>
        pub fn set_entity_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_entity_types(input);
            self
        }
        /// <p>Specifies if ingenstion is enabled or disabled.</p>
        pub fn event_ingestion(mut self, input: crate::model::EventIngestion) -> Self {
            self.inner = self.inner.event_ingestion(input);
            self
        }
        /// <p>Specifies if ingenstion is enabled or disabled.</p>
        pub fn set_event_ingestion(
            mut self,
            input: std::option::Option<crate::model::EventIngestion>,
        ) -> Self {
            self.inner = self.inner.set_event_ingestion(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutExternalModel`.
    ///
    /// <p>Creates or updates an Amazon SageMaker model endpoint. You can also use this action to update the configuration of the model endpoint, including the IAM role and/or the mapped variables. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutExternalModel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_external_model_input::Builder,
    }
    impl PutExternalModel {
        /// Creates a new `PutExternalModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutExternalModelOutput,
            aws_smithy_http::result::SdkError<crate::error::PutExternalModelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The model endpoints name.</p>
        pub fn model_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_endpoint(input.into());
            self
        }
        /// <p>The model endpoints name.</p>
        pub fn set_model_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_endpoint(input);
            self
        }
        /// <p>The source of the model.</p>
        pub fn model_source(mut self, input: crate::model::ModelSource) -> Self {
            self.inner = self.inner.model_source(input);
            self
        }
        /// <p>The source of the model.</p>
        pub fn set_model_source(
            mut self,
            input: std::option::Option<crate::model::ModelSource>,
        ) -> Self {
            self.inner = self.inner.set_model_source(input);
            self
        }
        /// <p>The IAM role used to invoke the model endpoint.</p>
        pub fn invoke_model_endpoint_role_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.invoke_model_endpoint_role_arn(input.into());
            self
        }
        /// <p>The IAM role used to invoke the model endpoint.</p>
        pub fn set_invoke_model_endpoint_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_invoke_model_endpoint_role_arn(input);
            self
        }
        /// <p>The model endpoint input configuration.</p>
        pub fn input_configuration(mut self, input: crate::model::ModelInputConfiguration) -> Self {
            self.inner = self.inner.input_configuration(input);
            self
        }
        /// <p>The model endpoint input configuration.</p>
        pub fn set_input_configuration(
            mut self,
            input: std::option::Option<crate::model::ModelInputConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_input_configuration(input);
            self
        }
        /// <p>The model endpoint output configuration.</p>
        pub fn output_configuration(
            mut self,
            input: crate::model::ModelOutputConfiguration,
        ) -> Self {
            self.inner = self.inner.output_configuration(input);
            self
        }
        /// <p>The model endpoint output configuration.</p>
        pub fn set_output_configuration(
            mut self,
            input: std::option::Option<crate::model::ModelOutputConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_output_configuration(input);
            self
        }
        /// <p>The model endpoint’s status in Amazon Fraud Detector.</p>
        pub fn model_endpoint_status(mut self, input: crate::model::ModelEndpointStatus) -> Self {
            self.inner = self.inner.model_endpoint_status(input);
            self
        }
        /// <p>The model endpoint’s status in Amazon Fraud Detector.</p>
        pub fn set_model_endpoint_status(
            mut self,
            input: std::option::Option<crate::model::ModelEndpointStatus>,
        ) -> Self {
            self.inner = self.inner.set_model_endpoint_status(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutKMSEncryptionKey`.
    ///
    /// <p>Specifies the KMS key to be used to encrypt content in Amazon Fraud Detector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutKMSEncryptionKey {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_kms_encryption_key_input::Builder,
    }
    impl PutKMSEncryptionKey {
        /// Creates a new `PutKMSEncryptionKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutKmsEncryptionKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutKMSEncryptionKeyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The KMS encryption key ARN.</p>
        pub fn kms_encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_encryption_key_arn(input.into());
            self
        }
        /// <p>The KMS encryption key ARN.</p>
        pub fn set_kms_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_kms_encryption_key_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutLabel`.
    ///
    /// <p>Creates or updates label. A label classifies an event as fraudulent or legitimate. Labels are associated with event types and used to train supervised machine learning models in Amazon Fraud Detector. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutLabel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_label_input::Builder,
    }
    impl PutLabel {
        /// Creates a new `PutLabel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutLabelOutput,
            aws_smithy_http::result::SdkError<crate::error::PutLabelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The label name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The label name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The label description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The label description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p></p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p></p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutOutcome`.
    ///
    /// <p>Creates or updates an outcome. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutOutcome {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_outcome_input::Builder,
    }
    impl PutOutcome {
        /// Creates a new `PutOutcome`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutOutcomeOutput,
            aws_smithy_http::result::SdkError<crate::error::PutOutcomeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the outcome.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the outcome.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The outcome description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The outcome description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendEvent`.
    ///
    /// <p>Stores events in Amazon Fraud Detector without generating fraud predictions for those events. For example, you can use <code>SendEvent</code> to upload a historical dataset, which you can then later use to train a model.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SendEvent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::send_event_input::Builder,
    }
    impl SendEvent {
        /// Creates a new `SendEvent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendEventOutput,
            aws_smithy_http::result::SdkError<crate::error::SendEventError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The event ID to upload.</p>
        pub fn event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_id(input.into());
            self
        }
        /// <p>The event ID to upload.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_event_id(input);
            self
        }
        /// <p>The event type name of the event.</p>
        pub fn event_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_type_name(input.into());
            self
        }
        /// <p>The event type name of the event.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_type_name(input);
            self
        }
        /// <p>The timestamp that defines when the event under evaluation occurred. The timestamp must be specified using ISO 8601 standard in UTC.</p>
        pub fn event_timestamp(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_timestamp(input.into());
            self
        }
        /// <p>The timestamp that defines when the event under evaluation occurred. The timestamp must be specified using ISO 8601 standard in UTC.</p>
        pub fn set_event_timestamp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_timestamp(input);
            self
        }
        /// Adds a key-value pair to `eventVariables`.
        ///
        /// To override the contents of this collection use [`set_event_variables`](Self::set_event_variables).
        ///
        /// <p>Names of the event type's variables you defined in Amazon Fraud Detector to represent data elements and their corresponding values for the event you are sending for evaluation.</p>
        pub fn event_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.event_variables(k.into(), v.into());
            self
        }
        /// <p>Names of the event type's variables you defined in Amazon Fraud Detector to represent data elements and their corresponding values for the event you are sending for evaluation.</p>
        pub fn set_event_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_event_variables(input);
            self
        }
        /// <p>The label to associate with the event. Required if specifying <code>labelTimestamp</code>.</p>
        pub fn assigned_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assigned_label(input.into());
            self
        }
        /// <p>The label to associate with the event. Required if specifying <code>labelTimestamp</code>.</p>
        pub fn set_assigned_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assigned_label(input);
            self
        }
        /// <p>The timestamp associated with the label. Required if specifying <code>assignedLabel</code>.</p>
        pub fn label_timestamp(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.label_timestamp(input.into());
            self
        }
        /// <p>The timestamp associated with the label. Required if specifying <code>assignedLabel</code>.</p>
        pub fn set_label_timestamp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_label_timestamp(input);
            self
        }
        /// Appends an item to `entities`.
        ///
        /// To override the contents of this collection use [`set_entities`](Self::set_entities).
        ///
        /// <p>An array of entities.</p>
        pub fn entities(mut self, input: crate::model::Entity) -> Self {
            self.inner = self.inner.entities(input);
            self
        }
        /// <p>An array of entities.</p>
        pub fn set_entities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Entity>>,
        ) -> Self {
            self.inner = self.inner.set_entities(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Assigns tags to a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to assign to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource from which to remove the tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource from which to remove the tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The resource ARN.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDetectorVersion`.
    ///
    /// <p> Updates a detector version. The detector version attributes that you can update include models, external model endpoints, rules, rule execution mode, and description. You can only update a <code>DRAFT</code> detector version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDetectorVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_detector_version_input::Builder,
    }
    impl UpdateDetectorVersion {
        /// Creates a new `UpdateDetectorVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDetectorVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDetectorVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The parent detector ID for the detector version you want to update.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(input.into());
            self
        }
        /// <p>The parent detector ID for the detector version you want to update.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The detector version ID. </p>
        pub fn detector_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_version_id(input.into());
            self
        }
        /// <p>The detector version ID. </p>
        pub fn set_detector_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_detector_version_id(input);
            self
        }
        /// Appends an item to `externalModelEndpoints`.
        ///
        /// To override the contents of this collection use [`set_external_model_endpoints`](Self::set_external_model_endpoints).
        ///
        /// <p>The Amazon SageMaker model endpoints to include in the detector version.</p>
        pub fn external_model_endpoints(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_model_endpoints(input.into());
            self
        }
        /// <p>The Amazon SageMaker model endpoints to include in the detector version.</p>
        pub fn set_external_model_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_external_model_endpoints(input);
            self
        }
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>The rules to include in the detector version.</p>
        pub fn rules(mut self, input: crate::model::Rule) -> Self {
            self.inner = self.inner.rules(input);
            self
        }
        /// <p>The rules to include in the detector version.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.inner = self.inner.set_rules(input);
            self
        }
        /// <p>The detector version description. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The detector version description. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `modelVersions`.
        ///
        /// To override the contents of this collection use [`set_model_versions`](Self::set_model_versions).
        ///
        /// <p>The model versions to include in the detector version.</p>
        pub fn model_versions(mut self, input: crate::model::ModelVersion) -> Self {
            self.inner = self.inner.model_versions(input);
            self
        }
        /// <p>The model versions to include in the detector version.</p>
        pub fn set_model_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ModelVersion>>,
        ) -> Self {
            self.inner = self.inner.set_model_versions(input);
            self
        }
        /// <p>The rule execution mode to add to the detector.</p>
        /// <p>If you specify <code>FIRST_MATCHED</code>, Amazon Fraud Detector evaluates rules sequentially, first to last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule.</p>
        /// <p>If you specifiy <code>ALL_MATCHED</code>, Amazon Fraud Detector evaluates all rules and returns the outcomes for all matched rules. You can define and edit the rule mode at the detector version level, when it is in draft status.</p>
        /// <p>The default behavior is <code>FIRST_MATCHED</code>.</p>
        pub fn rule_execution_mode(mut self, input: crate::model::RuleExecutionMode) -> Self {
            self.inner = self.inner.rule_execution_mode(input);
            self
        }
        /// <p>The rule execution mode to add to the detector.</p>
        /// <p>If you specify <code>FIRST_MATCHED</code>, Amazon Fraud Detector evaluates rules sequentially, first to last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule.</p>
        /// <p>If you specifiy <code>ALL_MATCHED</code>, Amazon Fraud Detector evaluates all rules and returns the outcomes for all matched rules. You can define and edit the rule mode at the detector version level, when it is in draft status.</p>
        /// <p>The default behavior is <code>FIRST_MATCHED</code>.</p>
        pub fn set_rule_execution_mode(
            mut self,
            input: std::option::Option<crate::model::RuleExecutionMode>,
        ) -> Self {
            self.inner = self.inner.set_rule_execution_mode(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDetectorVersionMetadata`.
    ///
    /// <p>Updates the detector version's description. You can update the metadata for any detector version (<code>DRAFT, ACTIVE,</code> or <code>INACTIVE</code>). </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDetectorVersionMetadata {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_detector_version_metadata_input::Builder,
    }
    impl UpdateDetectorVersionMetadata {
        /// Creates a new `UpdateDetectorVersionMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDetectorVersionMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDetectorVersionMetadataError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The detector ID.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(input.into());
            self
        }
        /// <p>The detector ID.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The detector version ID. </p>
        pub fn detector_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_version_id(input.into());
            self
        }
        /// <p>The detector version ID. </p>
        pub fn set_detector_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_detector_version_id(input);
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDetectorVersionStatus`.
    ///
    /// <p>Updates the detector version’s status. You can perform the following promotions or demotions using <code>UpdateDetectorVersionStatus</code>: <code>DRAFT</code> to <code>ACTIVE</code>, <code>ACTIVE</code> to <code>INACTIVE</code>, and <code>INACTIVE</code> to <code>ACTIVE</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDetectorVersionStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_detector_version_status_input::Builder,
    }
    impl UpdateDetectorVersionStatus {
        /// Creates a new `UpdateDetectorVersionStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDetectorVersionStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDetectorVersionStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The detector ID. </p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(input.into());
            self
        }
        /// <p>The detector ID. </p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The detector version ID. </p>
        pub fn detector_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_version_id(input.into());
            self
        }
        /// <p>The detector version ID. </p>
        pub fn set_detector_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_detector_version_id(input);
            self
        }
        /// <p>The new status.</p>
        pub fn status(mut self, input: crate::model::DetectorVersionStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The new status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DetectorVersionStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEventLabel`.
    ///
    /// <p>Updates the specified event with a new label.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateEventLabel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_event_label_input::Builder,
    }
    impl UpdateEventLabel {
        /// Creates a new `UpdateEventLabel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEventLabelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEventLabelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the event associated with the label to update.</p>
        pub fn event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_id(input.into());
            self
        }
        /// <p>The ID of the event associated with the label to update.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_event_id(input);
            self
        }
        /// <p>The event type of the event associated with the label to update.</p>
        pub fn event_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_type_name(input.into());
            self
        }
        /// <p>The event type of the event associated with the label to update.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_type_name(input);
            self
        }
        /// <p>The new label to assign to the event.</p>
        pub fn assigned_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assigned_label(input.into());
            self
        }
        /// <p>The new label to assign to the event.</p>
        pub fn set_assigned_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assigned_label(input);
            self
        }
        /// <p>The timestamp associated with the label. The timestamp must be specified using ISO 8601 standard in UTC. </p>
        pub fn label_timestamp(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.label_timestamp(input.into());
            self
        }
        /// <p>The timestamp associated with the label. The timestamp must be specified using ISO 8601 standard in UTC. </p>
        pub fn set_label_timestamp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_label_timestamp(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateModel`.
    ///
    /// <p>Updates model description.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateModel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_model_input::Builder,
    }
    impl UpdateModel {
        /// Creates a new `UpdateModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateModelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateModelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The model ID.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_id(input.into());
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_id(input);
            self
        }
        /// <p>The model type.</p>
        pub fn model_type(mut self, input: crate::model::ModelTypeEnum) -> Self {
            self.inner = self.inner.model_type(input);
            self
        }
        /// <p>The model type.</p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_model_type(input);
            self
        }
        /// <p>The new model description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The new model description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateModelVersion`.
    ///
    /// <p>Updates a model version. Updating a model version retrains an existing model version using updated training data and produces a new minor version of the model. You can update the training data set location and data access role attributes using this action. This action creates and trains a new minor version of the model, for example version 1.01, 1.02, 1.03.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateModelVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_model_version_input::Builder,
    }
    impl UpdateModelVersion {
        /// Creates a new `UpdateModelVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateModelVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateModelVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The model ID.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_id(input.into());
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_id(input);
            self
        }
        /// <p>The model type.</p>
        pub fn model_type(mut self, input: crate::model::ModelTypeEnum) -> Self {
            self.inner = self.inner.model_type(input);
            self
        }
        /// <p>The model type.</p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_model_type(input);
            self
        }
        /// <p>The major version number.</p>
        pub fn major_version_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.major_version_number(input.into());
            self
        }
        /// <p>The major version number.</p>
        pub fn set_major_version_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_major_version_number(input);
            self
        }
        /// <p>The details of the external events data used for training the model version. Required if <code>trainingDataSource</code> is <code>EXTERNAL_EVENTS</code>.</p>
        pub fn external_events_detail(mut self, input: crate::model::ExternalEventsDetail) -> Self {
            self.inner = self.inner.external_events_detail(input);
            self
        }
        /// <p>The details of the external events data used for training the model version. Required if <code>trainingDataSource</code> is <code>EXTERNAL_EVENTS</code>.</p>
        pub fn set_external_events_detail(
            mut self,
            input: std::option::Option<crate::model::ExternalEventsDetail>,
        ) -> Self {
            self.inner = self.inner.set_external_events_detail(input);
            self
        }
        /// <p>The details of the ingested event used for training the model version. Required if your <code>trainingDataSource</code> is <code>INGESTED_EVENTS</code>.</p>
        pub fn ingested_events_detail(mut self, input: crate::model::IngestedEventsDetail) -> Self {
            self.inner = self.inner.ingested_events_detail(input);
            self
        }
        /// <p>The details of the ingested event used for training the model version. Required if your <code>trainingDataSource</code> is <code>INGESTED_EVENTS</code>.</p>
        pub fn set_ingested_events_detail(
            mut self,
            input: std::option::Option<crate::model::IngestedEventsDetail>,
        ) -> Self {
            self.inner = self.inner.set_ingested_events_detail(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateModelVersionStatus`.
    ///
    /// <p>Updates the status of a model version.</p>
    /// <p>You can perform the following status updates:</p>
    /// <ol>
    /// <li> <p>Change the <code>TRAINING_COMPLETE</code> status to <code>ACTIVE</code>.</p> </li>
    /// <li> <p>Change <code>ACTIVE</code> to <code>INACTIVE</code>.</p> </li>
    /// </ol>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateModelVersionStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_model_version_status_input::Builder,
    }
    impl UpdateModelVersionStatus {
        /// Creates a new `UpdateModelVersionStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateModelVersionStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateModelVersionStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The model ID of the model version to update.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_id(input.into());
            self
        }
        /// <p>The model ID of the model version to update.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_id(input);
            self
        }
        /// <p>The model type.</p>
        pub fn model_type(mut self, input: crate::model::ModelTypeEnum) -> Self {
            self.inner = self.inner.model_type(input);
            self
        }
        /// <p>The model type.</p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_model_type(input);
            self
        }
        /// <p>The model version number.</p>
        pub fn model_version_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_version_number(input.into());
            self
        }
        /// <p>The model version number.</p>
        pub fn set_model_version_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_version_number(input);
            self
        }
        /// <p>The model version status.</p>
        pub fn status(mut self, input: crate::model::ModelVersionStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The model version status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ModelVersionStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRuleMetadata`.
    ///
    /// <p>Updates a rule's metadata. The description attribute can be updated.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRuleMetadata {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_rule_metadata_input::Builder,
    }
    impl UpdateRuleMetadata {
        /// Creates a new `UpdateRuleMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRuleMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRuleMetadataError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The rule to update.</p>
        pub fn rule(mut self, input: crate::model::Rule) -> Self {
            self.inner = self.inner.rule(input);
            self
        }
        /// <p>The rule to update.</p>
        pub fn set_rule(mut self, input: std::option::Option<crate::model::Rule>) -> Self {
            self.inner = self.inner.set_rule(input);
            self
        }
        /// <p>The rule description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The rule description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRuleVersion`.
    ///
    /// <p>Updates a rule version resulting in a new rule version. Updates a rule version resulting in a new rule version (version 1, 2, 3 ...). </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRuleVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_rule_version_input::Builder,
    }
    impl UpdateRuleVersion {
        /// Creates a new `UpdateRuleVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRuleVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRuleVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The rule to update.</p>
        pub fn rule(mut self, input: crate::model::Rule) -> Self {
            self.inner = self.inner.rule(input);
            self
        }
        /// <p>The rule to update.</p>
        pub fn set_rule(mut self, input: std::option::Option<crate::model::Rule>) -> Self {
            self.inner = self.inner.set_rule(input);
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The rule expression.</p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expression(input.into());
            self
        }
        /// <p>The rule expression.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_expression(input);
            self
        }
        /// <p>The language.</p>
        pub fn language(mut self, input: crate::model::Language) -> Self {
            self.inner = self.inner.language(input);
            self
        }
        /// <p>The language.</p>
        pub fn set_language(mut self, input: std::option::Option<crate::model::Language>) -> Self {
            self.inner = self.inner.set_language(input);
            self
        }
        /// Appends an item to `outcomes`.
        ///
        /// To override the contents of this collection use [`set_outcomes`](Self::set_outcomes).
        ///
        /// <p>The outcomes.</p>
        pub fn outcomes(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.outcomes(input.into());
            self
        }
        /// <p>The outcomes.</p>
        pub fn set_outcomes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_outcomes(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the rule version.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to assign to the rule version.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateVariable`.
    ///
    /// <p>Updates a variable.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateVariable {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_variable_input::Builder,
    }
    impl UpdateVariable {
        /// Creates a new `UpdateVariable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateVariableOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateVariableError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the variable.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the variable.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The new default value of the variable.</p>
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_value(input.into());
            self
        }
        /// <p>The new default value of the variable.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_value(input);
            self
        }
        /// <p>The new description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The new description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The variable type. For more information see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable types</a>.</p>
        pub fn variable_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.variable_type(input.into());
            self
        }
        /// <p>The variable type. For more information see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable types</a>.</p>
        pub fn set_variable_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_variable_type(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
