// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateVariableOutput {}
impl std::fmt::Debug for UpdateVariableOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateVariableOutput");
        formatter.finish()
    }
}
/// See [`UpdateVariableOutput`](crate::output::UpdateVariableOutput)
pub mod update_variable_output {
    /// A builder for [`UpdateVariableOutput`](crate::output::UpdateVariableOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateVariableOutput`](crate::output::UpdateVariableOutput)
        pub fn build(self) -> crate::output::UpdateVariableOutput {
            crate::output::UpdateVariableOutput {}
        }
    }
}
impl UpdateVariableOutput {
    /// Creates a new builder-style object to manufacture [`UpdateVariableOutput`](crate::output::UpdateVariableOutput)
    pub fn builder() -> crate::output::update_variable_output::Builder {
        crate::output::update_variable_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRuleVersionOutput {
    /// <p>The new rule version that was created.</p>
    pub rule: std::option::Option<crate::model::Rule>,
}
impl UpdateRuleVersionOutput {
    /// <p>The new rule version that was created.</p>
    pub fn rule(&self) -> std::option::Option<&crate::model::Rule> {
        self.rule.as_ref()
    }
}
impl std::fmt::Debug for UpdateRuleVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRuleVersionOutput");
        formatter.field("rule", &self.rule);
        formatter.finish()
    }
}
/// See [`UpdateRuleVersionOutput`](crate::output::UpdateRuleVersionOutput)
pub mod update_rule_version_output {
    /// A builder for [`UpdateRuleVersionOutput`](crate::output::UpdateRuleVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule: std::option::Option<crate::model::Rule>,
    }
    impl Builder {
        /// <p>The new rule version that was created.</p>
        pub fn rule(mut self, input: crate::model::Rule) -> Self {
            self.rule = Some(input);
            self
        }
        /// <p>The new rule version that was created.</p>
        pub fn set_rule(mut self, input: std::option::Option<crate::model::Rule>) -> Self {
            self.rule = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRuleVersionOutput`](crate::output::UpdateRuleVersionOutput)
        pub fn build(self) -> crate::output::UpdateRuleVersionOutput {
            crate::output::UpdateRuleVersionOutput { rule: self.rule }
        }
    }
}
impl UpdateRuleVersionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRuleVersionOutput`](crate::output::UpdateRuleVersionOutput)
    pub fn builder() -> crate::output::update_rule_version_output::Builder {
        crate::output::update_rule_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRuleMetadataOutput {}
impl std::fmt::Debug for UpdateRuleMetadataOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRuleMetadataOutput");
        formatter.finish()
    }
}
/// See [`UpdateRuleMetadataOutput`](crate::output::UpdateRuleMetadataOutput)
pub mod update_rule_metadata_output {
    /// A builder for [`UpdateRuleMetadataOutput`](crate::output::UpdateRuleMetadataOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateRuleMetadataOutput`](crate::output::UpdateRuleMetadataOutput)
        pub fn build(self) -> crate::output::UpdateRuleMetadataOutput {
            crate::output::UpdateRuleMetadataOutput {}
        }
    }
}
impl UpdateRuleMetadataOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRuleMetadataOutput`](crate::output::UpdateRuleMetadataOutput)
    pub fn builder() -> crate::output::update_rule_metadata_output::Builder {
        crate::output::update_rule_metadata_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateModelVersionStatusOutput {}
impl std::fmt::Debug for UpdateModelVersionStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateModelVersionStatusOutput");
        formatter.finish()
    }
}
/// See [`UpdateModelVersionStatusOutput`](crate::output::UpdateModelVersionStatusOutput)
pub mod update_model_version_status_output {
    /// A builder for [`UpdateModelVersionStatusOutput`](crate::output::UpdateModelVersionStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateModelVersionStatusOutput`](crate::output::UpdateModelVersionStatusOutput)
        pub fn build(self) -> crate::output::UpdateModelVersionStatusOutput {
            crate::output::UpdateModelVersionStatusOutput {}
        }
    }
}
impl UpdateModelVersionStatusOutput {
    /// Creates a new builder-style object to manufacture [`UpdateModelVersionStatusOutput`](crate::output::UpdateModelVersionStatusOutput)
    pub fn builder() -> crate::output::update_model_version_status_output::Builder {
        crate::output::update_model_version_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateModelVersionOutput {
    /// <p>The model ID.</p>
    pub model_id: std::option::Option<std::string::String>,
    /// <p>The model type.</p>
    pub model_type: std::option::Option<crate::model::ModelTypeEnum>,
    /// <p>The model version number of the model version updated.</p>
    pub model_version_number: std::option::Option<std::string::String>,
    /// <p>The status of the updated model version.</p>
    pub status: std::option::Option<std::string::String>,
}
impl UpdateModelVersionOutput {
    /// <p>The model ID.</p>
    pub fn model_id(&self) -> std::option::Option<&str> {
        self.model_id.as_deref()
    }
    /// <p>The model type.</p>
    pub fn model_type(&self) -> std::option::Option<&crate::model::ModelTypeEnum> {
        self.model_type.as_ref()
    }
    /// <p>The model version number of the model version updated.</p>
    pub fn model_version_number(&self) -> std::option::Option<&str> {
        self.model_version_number.as_deref()
    }
    /// <p>The status of the updated model version.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for UpdateModelVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateModelVersionOutput");
        formatter.field("model_id", &self.model_id);
        formatter.field("model_type", &self.model_type);
        formatter.field("model_version_number", &self.model_version_number);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`UpdateModelVersionOutput`](crate::output::UpdateModelVersionOutput)
pub mod update_model_version_output {
    /// A builder for [`UpdateModelVersionOutput`](crate::output::UpdateModelVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_id: std::option::Option<std::string::String>,
        pub(crate) model_type: std::option::Option<crate::model::ModelTypeEnum>,
        pub(crate) model_version_number: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The model ID.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_id = Some(input.into());
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_id = input;
            self
        }
        /// <p>The model type.</p>
        pub fn model_type(mut self, input: crate::model::ModelTypeEnum) -> Self {
            self.model_type = Some(input);
            self
        }
        /// <p>The model type.</p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.model_type = input;
            self
        }
        /// <p>The model version number of the model version updated.</p>
        pub fn model_version_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_version_number = Some(input.into());
            self
        }
        /// <p>The model version number of the model version updated.</p>
        pub fn set_model_version_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_version_number = input;
            self
        }
        /// <p>The status of the updated model version.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the updated model version.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateModelVersionOutput`](crate::output::UpdateModelVersionOutput)
        pub fn build(self) -> crate::output::UpdateModelVersionOutput {
            crate::output::UpdateModelVersionOutput {
                model_id: self.model_id,
                model_type: self.model_type,
                model_version_number: self.model_version_number,
                status: self.status,
            }
        }
    }
}
impl UpdateModelVersionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateModelVersionOutput`](crate::output::UpdateModelVersionOutput)
    pub fn builder() -> crate::output::update_model_version_output::Builder {
        crate::output::update_model_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateModelOutput {}
impl std::fmt::Debug for UpdateModelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateModelOutput");
        formatter.finish()
    }
}
/// See [`UpdateModelOutput`](crate::output::UpdateModelOutput)
pub mod update_model_output {
    /// A builder for [`UpdateModelOutput`](crate::output::UpdateModelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateModelOutput`](crate::output::UpdateModelOutput)
        pub fn build(self) -> crate::output::UpdateModelOutput {
            crate::output::UpdateModelOutput {}
        }
    }
}
impl UpdateModelOutput {
    /// Creates a new builder-style object to manufacture [`UpdateModelOutput`](crate::output::UpdateModelOutput)
    pub fn builder() -> crate::output::update_model_output::Builder {
        crate::output::update_model_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEventLabelOutput {}
impl std::fmt::Debug for UpdateEventLabelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEventLabelOutput");
        formatter.finish()
    }
}
/// See [`UpdateEventLabelOutput`](crate::output::UpdateEventLabelOutput)
pub mod update_event_label_output {
    /// A builder for [`UpdateEventLabelOutput`](crate::output::UpdateEventLabelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateEventLabelOutput`](crate::output::UpdateEventLabelOutput)
        pub fn build(self) -> crate::output::UpdateEventLabelOutput {
            crate::output::UpdateEventLabelOutput {}
        }
    }
}
impl UpdateEventLabelOutput {
    /// Creates a new builder-style object to manufacture [`UpdateEventLabelOutput`](crate::output::UpdateEventLabelOutput)
    pub fn builder() -> crate::output::update_event_label_output::Builder {
        crate::output::update_event_label_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDetectorVersionStatusOutput {}
impl std::fmt::Debug for UpdateDetectorVersionStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDetectorVersionStatusOutput");
        formatter.finish()
    }
}
/// See [`UpdateDetectorVersionStatusOutput`](crate::output::UpdateDetectorVersionStatusOutput)
pub mod update_detector_version_status_output {
    /// A builder for [`UpdateDetectorVersionStatusOutput`](crate::output::UpdateDetectorVersionStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateDetectorVersionStatusOutput`](crate::output::UpdateDetectorVersionStatusOutput)
        pub fn build(self) -> crate::output::UpdateDetectorVersionStatusOutput {
            crate::output::UpdateDetectorVersionStatusOutput {}
        }
    }
}
impl UpdateDetectorVersionStatusOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDetectorVersionStatusOutput`](crate::output::UpdateDetectorVersionStatusOutput)
    pub fn builder() -> crate::output::update_detector_version_status_output::Builder {
        crate::output::update_detector_version_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDetectorVersionMetadataOutput {}
impl std::fmt::Debug for UpdateDetectorVersionMetadataOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDetectorVersionMetadataOutput");
        formatter.finish()
    }
}
/// See [`UpdateDetectorVersionMetadataOutput`](crate::output::UpdateDetectorVersionMetadataOutput)
pub mod update_detector_version_metadata_output {
    /// A builder for [`UpdateDetectorVersionMetadataOutput`](crate::output::UpdateDetectorVersionMetadataOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateDetectorVersionMetadataOutput`](crate::output::UpdateDetectorVersionMetadataOutput)
        pub fn build(self) -> crate::output::UpdateDetectorVersionMetadataOutput {
            crate::output::UpdateDetectorVersionMetadataOutput {}
        }
    }
}
impl UpdateDetectorVersionMetadataOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDetectorVersionMetadataOutput`](crate::output::UpdateDetectorVersionMetadataOutput)
    pub fn builder() -> crate::output::update_detector_version_metadata_output::Builder {
        crate::output::update_detector_version_metadata_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDetectorVersionOutput {}
impl std::fmt::Debug for UpdateDetectorVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDetectorVersionOutput");
        formatter.finish()
    }
}
/// See [`UpdateDetectorVersionOutput`](crate::output::UpdateDetectorVersionOutput)
pub mod update_detector_version_output {
    /// A builder for [`UpdateDetectorVersionOutput`](crate::output::UpdateDetectorVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateDetectorVersionOutput`](crate::output::UpdateDetectorVersionOutput)
        pub fn build(self) -> crate::output::UpdateDetectorVersionOutput {
            crate::output::UpdateDetectorVersionOutput {}
        }
    }
}
impl UpdateDetectorVersionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDetectorVersionOutput`](crate::output::UpdateDetectorVersionOutput)
    pub fn builder() -> crate::output::update_detector_version_output::Builder {
        crate::output::update_detector_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendEventOutput {}
impl std::fmt::Debug for SendEventOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendEventOutput");
        formatter.finish()
    }
}
/// See [`SendEventOutput`](crate::output::SendEventOutput)
pub mod send_event_output {
    /// A builder for [`SendEventOutput`](crate::output::SendEventOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SendEventOutput`](crate::output::SendEventOutput)
        pub fn build(self) -> crate::output::SendEventOutput {
            crate::output::SendEventOutput {}
        }
    }
}
impl SendEventOutput {
    /// Creates a new builder-style object to manufacture [`SendEventOutput`](crate::output::SendEventOutput)
    pub fn builder() -> crate::output::send_event_output::Builder {
        crate::output::send_event_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutOutcomeOutput {}
impl std::fmt::Debug for PutOutcomeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutOutcomeOutput");
        formatter.finish()
    }
}
/// See [`PutOutcomeOutput`](crate::output::PutOutcomeOutput)
pub mod put_outcome_output {
    /// A builder for [`PutOutcomeOutput`](crate::output::PutOutcomeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutOutcomeOutput`](crate::output::PutOutcomeOutput)
        pub fn build(self) -> crate::output::PutOutcomeOutput {
            crate::output::PutOutcomeOutput {}
        }
    }
}
impl PutOutcomeOutput {
    /// Creates a new builder-style object to manufacture [`PutOutcomeOutput`](crate::output::PutOutcomeOutput)
    pub fn builder() -> crate::output::put_outcome_output::Builder {
        crate::output::put_outcome_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutLabelOutput {}
impl std::fmt::Debug for PutLabelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutLabelOutput");
        formatter.finish()
    }
}
/// See [`PutLabelOutput`](crate::output::PutLabelOutput)
pub mod put_label_output {
    /// A builder for [`PutLabelOutput`](crate::output::PutLabelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutLabelOutput`](crate::output::PutLabelOutput)
        pub fn build(self) -> crate::output::PutLabelOutput {
            crate::output::PutLabelOutput {}
        }
    }
}
impl PutLabelOutput {
    /// Creates a new builder-style object to manufacture [`PutLabelOutput`](crate::output::PutLabelOutput)
    pub fn builder() -> crate::output::put_label_output::Builder {
        crate::output::put_label_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutKmsEncryptionKeyOutput {}
impl std::fmt::Debug for PutKmsEncryptionKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutKmsEncryptionKeyOutput");
        formatter.finish()
    }
}
/// See [`PutKmsEncryptionKeyOutput`](crate::output::PutKmsEncryptionKeyOutput)
pub mod put_kms_encryption_key_output {
    /// A builder for [`PutKmsEncryptionKeyOutput`](crate::output::PutKmsEncryptionKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutKmsEncryptionKeyOutput`](crate::output::PutKmsEncryptionKeyOutput)
        pub fn build(self) -> crate::output::PutKmsEncryptionKeyOutput {
            crate::output::PutKmsEncryptionKeyOutput {}
        }
    }
}
impl PutKmsEncryptionKeyOutput {
    /// Creates a new builder-style object to manufacture [`PutKmsEncryptionKeyOutput`](crate::output::PutKmsEncryptionKeyOutput)
    pub fn builder() -> crate::output::put_kms_encryption_key_output::Builder {
        crate::output::put_kms_encryption_key_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutExternalModelOutput {}
impl std::fmt::Debug for PutExternalModelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutExternalModelOutput");
        formatter.finish()
    }
}
/// See [`PutExternalModelOutput`](crate::output::PutExternalModelOutput)
pub mod put_external_model_output {
    /// A builder for [`PutExternalModelOutput`](crate::output::PutExternalModelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutExternalModelOutput`](crate::output::PutExternalModelOutput)
        pub fn build(self) -> crate::output::PutExternalModelOutput {
            crate::output::PutExternalModelOutput {}
        }
    }
}
impl PutExternalModelOutput {
    /// Creates a new builder-style object to manufacture [`PutExternalModelOutput`](crate::output::PutExternalModelOutput)
    pub fn builder() -> crate::output::put_external_model_output::Builder {
        crate::output::put_external_model_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutEventTypeOutput {}
impl std::fmt::Debug for PutEventTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutEventTypeOutput");
        formatter.finish()
    }
}
/// See [`PutEventTypeOutput`](crate::output::PutEventTypeOutput)
pub mod put_event_type_output {
    /// A builder for [`PutEventTypeOutput`](crate::output::PutEventTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutEventTypeOutput`](crate::output::PutEventTypeOutput)
        pub fn build(self) -> crate::output::PutEventTypeOutput {
            crate::output::PutEventTypeOutput {}
        }
    }
}
impl PutEventTypeOutput {
    /// Creates a new builder-style object to manufacture [`PutEventTypeOutput`](crate::output::PutEventTypeOutput)
    pub fn builder() -> crate::output::put_event_type_output::Builder {
        crate::output::put_event_type_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutEntityTypeOutput {}
impl std::fmt::Debug for PutEntityTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutEntityTypeOutput");
        formatter.finish()
    }
}
/// See [`PutEntityTypeOutput`](crate::output::PutEntityTypeOutput)
pub mod put_entity_type_output {
    /// A builder for [`PutEntityTypeOutput`](crate::output::PutEntityTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutEntityTypeOutput`](crate::output::PutEntityTypeOutput)
        pub fn build(self) -> crate::output::PutEntityTypeOutput {
            crate::output::PutEntityTypeOutput {}
        }
    }
}
impl PutEntityTypeOutput {
    /// Creates a new builder-style object to manufacture [`PutEntityTypeOutput`](crate::output::PutEntityTypeOutput)
    pub fn builder() -> crate::output::put_entity_type_output::Builder {
        crate::output::put_entity_type_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutDetectorOutput {}
impl std::fmt::Debug for PutDetectorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutDetectorOutput");
        formatter.finish()
    }
}
/// See [`PutDetectorOutput`](crate::output::PutDetectorOutput)
pub mod put_detector_output {
    /// A builder for [`PutDetectorOutput`](crate::output::PutDetectorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutDetectorOutput`](crate::output::PutDetectorOutput)
        pub fn build(self) -> crate::output::PutDetectorOutput {
            crate::output::PutDetectorOutput {}
        }
    }
}
impl PutDetectorOutput {
    /// Creates a new builder-style object to manufacture [`PutDetectorOutput`](crate::output::PutDetectorOutput)
    pub fn builder() -> crate::output::put_detector_output::Builder {
        crate::output::put_detector_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>A collection of key and value pairs.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The next token for subsequent requests. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsForResourceOutput {
    /// <p>A collection of key and value pairs.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The next token for subsequent requests. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The next token for subsequent requests. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next token for subsequent requests. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                tags: self.tags,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetVariablesOutput {
    /// <p>The names of the variables returned. </p>
    pub variables: std::option::Option<std::vec::Vec<crate::model::Variable>>,
    /// <p>The next page token to be used in subsequent requests. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetVariablesOutput {
    /// <p>The names of the variables returned. </p>
    pub fn variables(&self) -> std::option::Option<&[crate::model::Variable]> {
        self.variables.as_deref()
    }
    /// <p>The next page token to be used in subsequent requests. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetVariablesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetVariablesOutput");
        formatter.field("variables", &self.variables);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetVariablesOutput`](crate::output::GetVariablesOutput)
pub mod get_variables_output {
    /// A builder for [`GetVariablesOutput`](crate::output::GetVariablesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) variables: std::option::Option<std::vec::Vec<crate::model::Variable>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `variables`.
        ///
        /// To override the contents of this collection use [`set_variables`](Self::set_variables).
        ///
        /// <p>The names of the variables returned. </p>
        pub fn variables(mut self, input: crate::model::Variable) -> Self {
            let mut v = self.variables.unwrap_or_default();
            v.push(input);
            self.variables = Some(v);
            self
        }
        /// <p>The names of the variables returned. </p>
        pub fn set_variables(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Variable>>,
        ) -> Self {
            self.variables = input;
            self
        }
        /// <p>The next page token to be used in subsequent requests. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page token to be used in subsequent requests. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetVariablesOutput`](crate::output::GetVariablesOutput)
        pub fn build(self) -> crate::output::GetVariablesOutput {
            crate::output::GetVariablesOutput {
                variables: self.variables,
                next_token: self.next_token,
            }
        }
    }
}
impl GetVariablesOutput {
    /// Creates a new builder-style object to manufacture [`GetVariablesOutput`](crate::output::GetVariablesOutput)
    pub fn builder() -> crate::output::get_variables_output::Builder {
        crate::output::get_variables_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRulesOutput {
    /// <p>The details of the requested rule.</p>
    pub rule_details: std::option::Option<std::vec::Vec<crate::model::RuleDetail>>,
    /// <p>The next page token to be used in subsequent requests.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetRulesOutput {
    /// <p>The details of the requested rule.</p>
    pub fn rule_details(&self) -> std::option::Option<&[crate::model::RuleDetail]> {
        self.rule_details.as_deref()
    }
    /// <p>The next page token to be used in subsequent requests.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetRulesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRulesOutput");
        formatter.field("rule_details", &self.rule_details);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetRulesOutput`](crate::output::GetRulesOutput)
pub mod get_rules_output {
    /// A builder for [`GetRulesOutput`](crate::output::GetRulesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_details: std::option::Option<std::vec::Vec<crate::model::RuleDetail>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `rule_details`.
        ///
        /// To override the contents of this collection use [`set_rule_details`](Self::set_rule_details).
        ///
        /// <p>The details of the requested rule.</p>
        pub fn rule_details(mut self, input: crate::model::RuleDetail) -> Self {
            let mut v = self.rule_details.unwrap_or_default();
            v.push(input);
            self.rule_details = Some(v);
            self
        }
        /// <p>The details of the requested rule.</p>
        pub fn set_rule_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RuleDetail>>,
        ) -> Self {
            self.rule_details = input;
            self
        }
        /// <p>The next page token to be used in subsequent requests.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page token to be used in subsequent requests.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRulesOutput`](crate::output::GetRulesOutput)
        pub fn build(self) -> crate::output::GetRulesOutput {
            crate::output::GetRulesOutput {
                rule_details: self.rule_details,
                next_token: self.next_token,
            }
        }
    }
}
impl GetRulesOutput {
    /// Creates a new builder-style object to manufacture [`GetRulesOutput`](crate::output::GetRulesOutput)
    pub fn builder() -> crate::output::get_rules_output::Builder {
        crate::output::get_rules_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetOutcomesOutput {
    /// <p>The outcomes. </p>
    pub outcomes: std::option::Option<std::vec::Vec<crate::model::Outcome>>,
    /// <p>The next page token for subsequent requests.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetOutcomesOutput {
    /// <p>The outcomes. </p>
    pub fn outcomes(&self) -> std::option::Option<&[crate::model::Outcome]> {
        self.outcomes.as_deref()
    }
    /// <p>The next page token for subsequent requests.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetOutcomesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetOutcomesOutput");
        formatter.field("outcomes", &self.outcomes);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetOutcomesOutput`](crate::output::GetOutcomesOutput)
pub mod get_outcomes_output {
    /// A builder for [`GetOutcomesOutput`](crate::output::GetOutcomesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) outcomes: std::option::Option<std::vec::Vec<crate::model::Outcome>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `outcomes`.
        ///
        /// To override the contents of this collection use [`set_outcomes`](Self::set_outcomes).
        ///
        /// <p>The outcomes. </p>
        pub fn outcomes(mut self, input: crate::model::Outcome) -> Self {
            let mut v = self.outcomes.unwrap_or_default();
            v.push(input);
            self.outcomes = Some(v);
            self
        }
        /// <p>The outcomes. </p>
        pub fn set_outcomes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Outcome>>,
        ) -> Self {
            self.outcomes = input;
            self
        }
        /// <p>The next page token for subsequent requests.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page token for subsequent requests.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOutcomesOutput`](crate::output::GetOutcomesOutput)
        pub fn build(self) -> crate::output::GetOutcomesOutput {
            crate::output::GetOutcomesOutput {
                outcomes: self.outcomes,
                next_token: self.next_token,
            }
        }
    }
}
impl GetOutcomesOutput {
    /// Creates a new builder-style object to manufacture [`GetOutcomesOutput`](crate::output::GetOutcomesOutput)
    pub fn builder() -> crate::output::get_outcomes_output::Builder {
        crate::output::get_outcomes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetModelVersionOutput {
    /// <p>The model ID.</p>
    pub model_id: std::option::Option<std::string::String>,
    /// <p>The model type.</p>
    pub model_type: std::option::Option<crate::model::ModelTypeEnum>,
    /// <p>The model version number.</p>
    pub model_version_number: std::option::Option<std::string::String>,
    /// <p>The training data source.</p>
    pub training_data_source: std::option::Option<crate::model::TrainingDataSourceEnum>,
    /// <p>The training data schema.</p>
    pub training_data_schema: std::option::Option<crate::model::TrainingDataSchema>,
    /// <p>The details of the external events data used for training the model version. This will be populated if the <code>trainingDataSource</code> is <code>EXTERNAL_EVENTS</code> </p>
    pub external_events_detail: std::option::Option<crate::model::ExternalEventsDetail>,
    /// <p>The details of the ingested events data used for training the model version. This will be populated if the <code>trainingDataSource</code> is <code>INGESTED_EVENTS</code>.</p>
    pub ingested_events_detail: std::option::Option<crate::model::IngestedEventsDetail>,
    /// <p>The model version status.</p>
    /// <p>Possible values are:</p>
    /// <ul>
    /// <li> <p> <code>TRAINING_IN_PROGRESS</code> </p> </li>
    /// <li> <p> <code>TRAINING_COMPLETE</code> </p> </li>
    /// <li> <p> <code>ACTIVATE_REQUESTED</code> </p> </li>
    /// <li> <p> <code>ACTIVATE_IN_PROGRESS</code> </p> </li>
    /// <li> <p> <code>ACTIVE</code> </p> </li>
    /// <li> <p> <code>INACTIVATE_REQUESTED</code> </p> </li>
    /// <li> <p> <code>INACTIVATE_IN_PROGRESS</code> </p> </li>
    /// <li> <p> <code>INACTIVE</code> </p> </li>
    /// <li> <p> <code>ERROR</code> </p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The model version ARN.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl GetModelVersionOutput {
    /// <p>The model ID.</p>
    pub fn model_id(&self) -> std::option::Option<&str> {
        self.model_id.as_deref()
    }
    /// <p>The model type.</p>
    pub fn model_type(&self) -> std::option::Option<&crate::model::ModelTypeEnum> {
        self.model_type.as_ref()
    }
    /// <p>The model version number.</p>
    pub fn model_version_number(&self) -> std::option::Option<&str> {
        self.model_version_number.as_deref()
    }
    /// <p>The training data source.</p>
    pub fn training_data_source(
        &self,
    ) -> std::option::Option<&crate::model::TrainingDataSourceEnum> {
        self.training_data_source.as_ref()
    }
    /// <p>The training data schema.</p>
    pub fn training_data_schema(&self) -> std::option::Option<&crate::model::TrainingDataSchema> {
        self.training_data_schema.as_ref()
    }
    /// <p>The details of the external events data used for training the model version. This will be populated if the <code>trainingDataSource</code> is <code>EXTERNAL_EVENTS</code> </p>
    pub fn external_events_detail(
        &self,
    ) -> std::option::Option<&crate::model::ExternalEventsDetail> {
        self.external_events_detail.as_ref()
    }
    /// <p>The details of the ingested events data used for training the model version. This will be populated if the <code>trainingDataSource</code> is <code>INGESTED_EVENTS</code>.</p>
    pub fn ingested_events_detail(
        &self,
    ) -> std::option::Option<&crate::model::IngestedEventsDetail> {
        self.ingested_events_detail.as_ref()
    }
    /// <p>The model version status.</p>
    /// <p>Possible values are:</p>
    /// <ul>
    /// <li> <p> <code>TRAINING_IN_PROGRESS</code> </p> </li>
    /// <li> <p> <code>TRAINING_COMPLETE</code> </p> </li>
    /// <li> <p> <code>ACTIVATE_REQUESTED</code> </p> </li>
    /// <li> <p> <code>ACTIVATE_IN_PROGRESS</code> </p> </li>
    /// <li> <p> <code>ACTIVE</code> </p> </li>
    /// <li> <p> <code>INACTIVATE_REQUESTED</code> </p> </li>
    /// <li> <p> <code>INACTIVATE_IN_PROGRESS</code> </p> </li>
    /// <li> <p> <code>INACTIVE</code> </p> </li>
    /// <li> <p> <code>ERROR</code> </p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The model version ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for GetModelVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetModelVersionOutput");
        formatter.field("model_id", &self.model_id);
        formatter.field("model_type", &self.model_type);
        formatter.field("model_version_number", &self.model_version_number);
        formatter.field("training_data_source", &self.training_data_source);
        formatter.field("training_data_schema", &self.training_data_schema);
        formatter.field("external_events_detail", &self.external_events_detail);
        formatter.field("ingested_events_detail", &self.ingested_events_detail);
        formatter.field("status", &self.status);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`GetModelVersionOutput`](crate::output::GetModelVersionOutput)
pub mod get_model_version_output {
    /// A builder for [`GetModelVersionOutput`](crate::output::GetModelVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_id: std::option::Option<std::string::String>,
        pub(crate) model_type: std::option::Option<crate::model::ModelTypeEnum>,
        pub(crate) model_version_number: std::option::Option<std::string::String>,
        pub(crate) training_data_source: std::option::Option<crate::model::TrainingDataSourceEnum>,
        pub(crate) training_data_schema: std::option::Option<crate::model::TrainingDataSchema>,
        pub(crate) external_events_detail: std::option::Option<crate::model::ExternalEventsDetail>,
        pub(crate) ingested_events_detail: std::option::Option<crate::model::IngestedEventsDetail>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The model ID.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_id = Some(input.into());
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_id = input;
            self
        }
        /// <p>The model type.</p>
        pub fn model_type(mut self, input: crate::model::ModelTypeEnum) -> Self {
            self.model_type = Some(input);
            self
        }
        /// <p>The model type.</p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.model_type = input;
            self
        }
        /// <p>The model version number.</p>
        pub fn model_version_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_version_number = Some(input.into());
            self
        }
        /// <p>The model version number.</p>
        pub fn set_model_version_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_version_number = input;
            self
        }
        /// <p>The training data source.</p>
        pub fn training_data_source(mut self, input: crate::model::TrainingDataSourceEnum) -> Self {
            self.training_data_source = Some(input);
            self
        }
        /// <p>The training data source.</p>
        pub fn set_training_data_source(
            mut self,
            input: std::option::Option<crate::model::TrainingDataSourceEnum>,
        ) -> Self {
            self.training_data_source = input;
            self
        }
        /// <p>The training data schema.</p>
        pub fn training_data_schema(mut self, input: crate::model::TrainingDataSchema) -> Self {
            self.training_data_schema = Some(input);
            self
        }
        /// <p>The training data schema.</p>
        pub fn set_training_data_schema(
            mut self,
            input: std::option::Option<crate::model::TrainingDataSchema>,
        ) -> Self {
            self.training_data_schema = input;
            self
        }
        /// <p>The details of the external events data used for training the model version. This will be populated if the <code>trainingDataSource</code> is <code>EXTERNAL_EVENTS</code> </p>
        pub fn external_events_detail(mut self, input: crate::model::ExternalEventsDetail) -> Self {
            self.external_events_detail = Some(input);
            self
        }
        /// <p>The details of the external events data used for training the model version. This will be populated if the <code>trainingDataSource</code> is <code>EXTERNAL_EVENTS</code> </p>
        pub fn set_external_events_detail(
            mut self,
            input: std::option::Option<crate::model::ExternalEventsDetail>,
        ) -> Self {
            self.external_events_detail = input;
            self
        }
        /// <p>The details of the ingested events data used for training the model version. This will be populated if the <code>trainingDataSource</code> is <code>INGESTED_EVENTS</code>.</p>
        pub fn ingested_events_detail(mut self, input: crate::model::IngestedEventsDetail) -> Self {
            self.ingested_events_detail = Some(input);
            self
        }
        /// <p>The details of the ingested events data used for training the model version. This will be populated if the <code>trainingDataSource</code> is <code>INGESTED_EVENTS</code>.</p>
        pub fn set_ingested_events_detail(
            mut self,
            input: std::option::Option<crate::model::IngestedEventsDetail>,
        ) -> Self {
            self.ingested_events_detail = input;
            self
        }
        /// <p>The model version status.</p>
        /// <p>Possible values are:</p>
        /// <ul>
        /// <li> <p> <code>TRAINING_IN_PROGRESS</code> </p> </li>
        /// <li> <p> <code>TRAINING_COMPLETE</code> </p> </li>
        /// <li> <p> <code>ACTIVATE_REQUESTED</code> </p> </li>
        /// <li> <p> <code>ACTIVATE_IN_PROGRESS</code> </p> </li>
        /// <li> <p> <code>ACTIVE</code> </p> </li>
        /// <li> <p> <code>INACTIVATE_REQUESTED</code> </p> </li>
        /// <li> <p> <code>INACTIVATE_IN_PROGRESS</code> </p> </li>
        /// <li> <p> <code>INACTIVE</code> </p> </li>
        /// <li> <p> <code>ERROR</code> </p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The model version status.</p>
        /// <p>Possible values are:</p>
        /// <ul>
        /// <li> <p> <code>TRAINING_IN_PROGRESS</code> </p> </li>
        /// <li> <p> <code>TRAINING_COMPLETE</code> </p> </li>
        /// <li> <p> <code>ACTIVATE_REQUESTED</code> </p> </li>
        /// <li> <p> <code>ACTIVATE_IN_PROGRESS</code> </p> </li>
        /// <li> <p> <code>ACTIVE</code> </p> </li>
        /// <li> <p> <code>INACTIVATE_REQUESTED</code> </p> </li>
        /// <li> <p> <code>INACTIVATE_IN_PROGRESS</code> </p> </li>
        /// <li> <p> <code>INACTIVE</code> </p> </li>
        /// <li> <p> <code>ERROR</code> </p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The model version ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The model version ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetModelVersionOutput`](crate::output::GetModelVersionOutput)
        pub fn build(self) -> crate::output::GetModelVersionOutput {
            crate::output::GetModelVersionOutput {
                model_id: self.model_id,
                model_type: self.model_type,
                model_version_number: self.model_version_number,
                training_data_source: self.training_data_source,
                training_data_schema: self.training_data_schema,
                external_events_detail: self.external_events_detail,
                ingested_events_detail: self.ingested_events_detail,
                status: self.status,
                arn: self.arn,
            }
        }
    }
}
impl GetModelVersionOutput {
    /// Creates a new builder-style object to manufacture [`GetModelVersionOutput`](crate::output::GetModelVersionOutput)
    pub fn builder() -> crate::output::get_model_version_output::Builder {
        crate::output::get_model_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetModelsOutput {
    /// <p>The next page token to be used in subsequent requests.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The array of models.</p>
    pub models: std::option::Option<std::vec::Vec<crate::model::Model>>,
}
impl GetModelsOutput {
    /// <p>The next page token to be used in subsequent requests.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The array of models.</p>
    pub fn models(&self) -> std::option::Option<&[crate::model::Model]> {
        self.models.as_deref()
    }
}
impl std::fmt::Debug for GetModelsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetModelsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("models", &self.models);
        formatter.finish()
    }
}
/// See [`GetModelsOutput`](crate::output::GetModelsOutput)
pub mod get_models_output {
    /// A builder for [`GetModelsOutput`](crate::output::GetModelsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) models: std::option::Option<std::vec::Vec<crate::model::Model>>,
    }
    impl Builder {
        /// <p>The next page token to be used in subsequent requests.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page token to be used in subsequent requests.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `models`.
        ///
        /// To override the contents of this collection use [`set_models`](Self::set_models).
        ///
        /// <p>The array of models.</p>
        pub fn models(mut self, input: crate::model::Model) -> Self {
            let mut v = self.models.unwrap_or_default();
            v.push(input);
            self.models = Some(v);
            self
        }
        /// <p>The array of models.</p>
        pub fn set_models(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Model>>,
        ) -> Self {
            self.models = input;
            self
        }
        /// Consumes the builder and constructs a [`GetModelsOutput`](crate::output::GetModelsOutput)
        pub fn build(self) -> crate::output::GetModelsOutput {
            crate::output::GetModelsOutput {
                next_token: self.next_token,
                models: self.models,
            }
        }
    }
}
impl GetModelsOutput {
    /// Creates a new builder-style object to manufacture [`GetModelsOutput`](crate::output::GetModelsOutput)
    pub fn builder() -> crate::output::get_models_output::Builder {
        crate::output::get_models_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLabelsOutput {
    /// <p>An array of labels.</p>
    pub labels: std::option::Option<std::vec::Vec<crate::model::Label>>,
    /// <p>The next page token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetLabelsOutput {
    /// <p>An array of labels.</p>
    pub fn labels(&self) -> std::option::Option<&[crate::model::Label]> {
        self.labels.as_deref()
    }
    /// <p>The next page token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetLabelsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLabelsOutput");
        formatter.field("labels", &self.labels);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetLabelsOutput`](crate::output::GetLabelsOutput)
pub mod get_labels_output {
    /// A builder for [`GetLabelsOutput`](crate::output::GetLabelsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) labels: std::option::Option<std::vec::Vec<crate::model::Label>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// <p>An array of labels.</p>
        pub fn labels(mut self, input: crate::model::Label) -> Self {
            let mut v = self.labels.unwrap_or_default();
            v.push(input);
            self.labels = Some(v);
            self
        }
        /// <p>An array of labels.</p>
        pub fn set_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Label>>,
        ) -> Self {
            self.labels = input;
            self
        }
        /// <p>The next page token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLabelsOutput`](crate::output::GetLabelsOutput)
        pub fn build(self) -> crate::output::GetLabelsOutput {
            crate::output::GetLabelsOutput {
                labels: self.labels,
                next_token: self.next_token,
            }
        }
    }
}
impl GetLabelsOutput {
    /// Creates a new builder-style object to manufacture [`GetLabelsOutput`](crate::output::GetLabelsOutput)
    pub fn builder() -> crate::output::get_labels_output::Builder {
        crate::output::get_labels_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetKmsEncryptionKeyOutput {
    /// <p>The KMS encryption key.</p>
    pub kms_key: std::option::Option<crate::model::KmsKey>,
}
impl GetKmsEncryptionKeyOutput {
    /// <p>The KMS encryption key.</p>
    pub fn kms_key(&self) -> std::option::Option<&crate::model::KmsKey> {
        self.kms_key.as_ref()
    }
}
impl std::fmt::Debug for GetKmsEncryptionKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetKmsEncryptionKeyOutput");
        formatter.field("kms_key", &self.kms_key);
        formatter.finish()
    }
}
/// See [`GetKmsEncryptionKeyOutput`](crate::output::GetKmsEncryptionKeyOutput)
pub mod get_kms_encryption_key_output {
    /// A builder for [`GetKmsEncryptionKeyOutput`](crate::output::GetKmsEncryptionKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) kms_key: std::option::Option<crate::model::KmsKey>,
    }
    impl Builder {
        /// <p>The KMS encryption key.</p>
        pub fn kms_key(mut self, input: crate::model::KmsKey) -> Self {
            self.kms_key = Some(input);
            self
        }
        /// <p>The KMS encryption key.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<crate::model::KmsKey>) -> Self {
            self.kms_key = input;
            self
        }
        /// Consumes the builder and constructs a [`GetKmsEncryptionKeyOutput`](crate::output::GetKmsEncryptionKeyOutput)
        pub fn build(self) -> crate::output::GetKmsEncryptionKeyOutput {
            crate::output::GetKmsEncryptionKeyOutput {
                kms_key: self.kms_key,
            }
        }
    }
}
impl GetKmsEncryptionKeyOutput {
    /// Creates a new builder-style object to manufacture [`GetKmsEncryptionKeyOutput`](crate::output::GetKmsEncryptionKeyOutput)
    pub fn builder() -> crate::output::get_kms_encryption_key_output::Builder {
        crate::output::get_kms_encryption_key_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetExternalModelsOutput {
    /// <p>Gets the Amazon SageMaker models.</p>
    pub external_models: std::option::Option<std::vec::Vec<crate::model::ExternalModel>>,
    /// <p>The next page token to be used in subsequent requests.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetExternalModelsOutput {
    /// <p>Gets the Amazon SageMaker models.</p>
    pub fn external_models(&self) -> std::option::Option<&[crate::model::ExternalModel]> {
        self.external_models.as_deref()
    }
    /// <p>The next page token to be used in subsequent requests.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetExternalModelsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetExternalModelsOutput");
        formatter.field("external_models", &self.external_models);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetExternalModelsOutput`](crate::output::GetExternalModelsOutput)
pub mod get_external_models_output {
    /// A builder for [`GetExternalModelsOutput`](crate::output::GetExternalModelsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) external_models: std::option::Option<std::vec::Vec<crate::model::ExternalModel>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `external_models`.
        ///
        /// To override the contents of this collection use [`set_external_models`](Self::set_external_models).
        ///
        /// <p>Gets the Amazon SageMaker models.</p>
        pub fn external_models(mut self, input: crate::model::ExternalModel) -> Self {
            let mut v = self.external_models.unwrap_or_default();
            v.push(input);
            self.external_models = Some(v);
            self
        }
        /// <p>Gets the Amazon SageMaker models.</p>
        pub fn set_external_models(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExternalModel>>,
        ) -> Self {
            self.external_models = input;
            self
        }
        /// <p>The next page token to be used in subsequent requests.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page token to be used in subsequent requests.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetExternalModelsOutput`](crate::output::GetExternalModelsOutput)
        pub fn build(self) -> crate::output::GetExternalModelsOutput {
            crate::output::GetExternalModelsOutput {
                external_models: self.external_models,
                next_token: self.next_token,
            }
        }
    }
}
impl GetExternalModelsOutput {
    /// Creates a new builder-style object to manufacture [`GetExternalModelsOutput`](crate::output::GetExternalModelsOutput)
    pub fn builder() -> crate::output::get_external_models_output::Builder {
        crate::output::get_external_models_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEventTypesOutput {
    /// <p>An array of event types.</p>
    pub event_types: std::option::Option<std::vec::Vec<crate::model::EventType>>,
    /// <p>The next page token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetEventTypesOutput {
    /// <p>An array of event types.</p>
    pub fn event_types(&self) -> std::option::Option<&[crate::model::EventType]> {
        self.event_types.as_deref()
    }
    /// <p>The next page token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetEventTypesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEventTypesOutput");
        formatter.field("event_types", &self.event_types);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetEventTypesOutput`](crate::output::GetEventTypesOutput)
pub mod get_event_types_output {
    /// A builder for [`GetEventTypesOutput`](crate::output::GetEventTypesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_types: std::option::Option<std::vec::Vec<crate::model::EventType>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `event_types`.
        ///
        /// To override the contents of this collection use [`set_event_types`](Self::set_event_types).
        ///
        /// <p>An array of event types.</p>
        pub fn event_types(mut self, input: crate::model::EventType) -> Self {
            let mut v = self.event_types.unwrap_or_default();
            v.push(input);
            self.event_types = Some(v);
            self
        }
        /// <p>An array of event types.</p>
        pub fn set_event_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventType>>,
        ) -> Self {
            self.event_types = input;
            self
        }
        /// <p>The next page token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEventTypesOutput`](crate::output::GetEventTypesOutput)
        pub fn build(self) -> crate::output::GetEventTypesOutput {
            crate::output::GetEventTypesOutput {
                event_types: self.event_types,
                next_token: self.next_token,
            }
        }
    }
}
impl GetEventTypesOutput {
    /// Creates a new builder-style object to manufacture [`GetEventTypesOutput`](crate::output::GetEventTypesOutput)
    pub fn builder() -> crate::output::get_event_types_output::Builder {
        crate::output::get_event_types_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEventPredictionOutput {
    /// <p>The model scores. Amazon Fraud Detector generates model scores between 0 and 1000, where 0 is low fraud risk and 1000 is high fraud risk. Model scores are directly related to the false positive rate (FPR). For example, a score of 600 corresponds to an estimated 10% false positive rate whereas a score of 900 corresponds to an estimated 2% false positive rate.</p>
    pub model_scores: std::option::Option<std::vec::Vec<crate::model::ModelScores>>,
    /// <p>The results from the rules.</p>
    pub rule_results: std::option::Option<std::vec::Vec<crate::model::RuleResult>>,
    /// <p>The model scores for Amazon SageMaker models.</p>
    pub external_model_outputs:
        std::option::Option<std::vec::Vec<crate::model::ExternalModelOutputs>>,
}
impl GetEventPredictionOutput {
    /// <p>The model scores. Amazon Fraud Detector generates model scores between 0 and 1000, where 0 is low fraud risk and 1000 is high fraud risk. Model scores are directly related to the false positive rate (FPR). For example, a score of 600 corresponds to an estimated 10% false positive rate whereas a score of 900 corresponds to an estimated 2% false positive rate.</p>
    pub fn model_scores(&self) -> std::option::Option<&[crate::model::ModelScores]> {
        self.model_scores.as_deref()
    }
    /// <p>The results from the rules.</p>
    pub fn rule_results(&self) -> std::option::Option<&[crate::model::RuleResult]> {
        self.rule_results.as_deref()
    }
    /// <p>The model scores for Amazon SageMaker models.</p>
    pub fn external_model_outputs(
        &self,
    ) -> std::option::Option<&[crate::model::ExternalModelOutputs]> {
        self.external_model_outputs.as_deref()
    }
}
impl std::fmt::Debug for GetEventPredictionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEventPredictionOutput");
        formatter.field("model_scores", &self.model_scores);
        formatter.field("rule_results", &self.rule_results);
        formatter.field("external_model_outputs", &self.external_model_outputs);
        formatter.finish()
    }
}
/// See [`GetEventPredictionOutput`](crate::output::GetEventPredictionOutput)
pub mod get_event_prediction_output {
    /// A builder for [`GetEventPredictionOutput`](crate::output::GetEventPredictionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_scores: std::option::Option<std::vec::Vec<crate::model::ModelScores>>,
        pub(crate) rule_results: std::option::Option<std::vec::Vec<crate::model::RuleResult>>,
        pub(crate) external_model_outputs:
            std::option::Option<std::vec::Vec<crate::model::ExternalModelOutputs>>,
    }
    impl Builder {
        /// Appends an item to `model_scores`.
        ///
        /// To override the contents of this collection use [`set_model_scores`](Self::set_model_scores).
        ///
        /// <p>The model scores. Amazon Fraud Detector generates model scores between 0 and 1000, where 0 is low fraud risk and 1000 is high fraud risk. Model scores are directly related to the false positive rate (FPR). For example, a score of 600 corresponds to an estimated 10% false positive rate whereas a score of 900 corresponds to an estimated 2% false positive rate.</p>
        pub fn model_scores(mut self, input: crate::model::ModelScores) -> Self {
            let mut v = self.model_scores.unwrap_or_default();
            v.push(input);
            self.model_scores = Some(v);
            self
        }
        /// <p>The model scores. Amazon Fraud Detector generates model scores between 0 and 1000, where 0 is low fraud risk and 1000 is high fraud risk. Model scores are directly related to the false positive rate (FPR). For example, a score of 600 corresponds to an estimated 10% false positive rate whereas a score of 900 corresponds to an estimated 2% false positive rate.</p>
        pub fn set_model_scores(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ModelScores>>,
        ) -> Self {
            self.model_scores = input;
            self
        }
        /// Appends an item to `rule_results`.
        ///
        /// To override the contents of this collection use [`set_rule_results`](Self::set_rule_results).
        ///
        /// <p>The results from the rules.</p>
        pub fn rule_results(mut self, input: crate::model::RuleResult) -> Self {
            let mut v = self.rule_results.unwrap_or_default();
            v.push(input);
            self.rule_results = Some(v);
            self
        }
        /// <p>The results from the rules.</p>
        pub fn set_rule_results(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RuleResult>>,
        ) -> Self {
            self.rule_results = input;
            self
        }
        /// Appends an item to `external_model_outputs`.
        ///
        /// To override the contents of this collection use [`set_external_model_outputs`](Self::set_external_model_outputs).
        ///
        /// <p>The model scores for Amazon SageMaker models.</p>
        pub fn external_model_outputs(mut self, input: crate::model::ExternalModelOutputs) -> Self {
            let mut v = self.external_model_outputs.unwrap_or_default();
            v.push(input);
            self.external_model_outputs = Some(v);
            self
        }
        /// <p>The model scores for Amazon SageMaker models.</p>
        pub fn set_external_model_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExternalModelOutputs>>,
        ) -> Self {
            self.external_model_outputs = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEventPredictionOutput`](crate::output::GetEventPredictionOutput)
        pub fn build(self) -> crate::output::GetEventPredictionOutput {
            crate::output::GetEventPredictionOutput {
                model_scores: self.model_scores,
                rule_results: self.rule_results,
                external_model_outputs: self.external_model_outputs,
            }
        }
    }
}
impl GetEventPredictionOutput {
    /// Creates a new builder-style object to manufacture [`GetEventPredictionOutput`](crate::output::GetEventPredictionOutput)
    pub fn builder() -> crate::output::get_event_prediction_output::Builder {
        crate::output::get_event_prediction_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEventOutput {
    /// <p>The details of the event.</p>
    pub event: std::option::Option<crate::model::Event>,
}
impl GetEventOutput {
    /// <p>The details of the event.</p>
    pub fn event(&self) -> std::option::Option<&crate::model::Event> {
        self.event.as_ref()
    }
}
impl std::fmt::Debug for GetEventOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEventOutput");
        formatter.field("event", &self.event);
        formatter.finish()
    }
}
/// See [`GetEventOutput`](crate::output::GetEventOutput)
pub mod get_event_output {
    /// A builder for [`GetEventOutput`](crate::output::GetEventOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event: std::option::Option<crate::model::Event>,
    }
    impl Builder {
        /// <p>The details of the event.</p>
        pub fn event(mut self, input: crate::model::Event) -> Self {
            self.event = Some(input);
            self
        }
        /// <p>The details of the event.</p>
        pub fn set_event(mut self, input: std::option::Option<crate::model::Event>) -> Self {
            self.event = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEventOutput`](crate::output::GetEventOutput)
        pub fn build(self) -> crate::output::GetEventOutput {
            crate::output::GetEventOutput { event: self.event }
        }
    }
}
impl GetEventOutput {
    /// Creates a new builder-style object to manufacture [`GetEventOutput`](crate::output::GetEventOutput)
    pub fn builder() -> crate::output::get_event_output::Builder {
        crate::output::get_event_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEntityTypesOutput {
    /// <p>An array of entity types.</p>
    pub entity_types: std::option::Option<std::vec::Vec<crate::model::EntityType>>,
    /// <p>The next page token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetEntityTypesOutput {
    /// <p>An array of entity types.</p>
    pub fn entity_types(&self) -> std::option::Option<&[crate::model::EntityType]> {
        self.entity_types.as_deref()
    }
    /// <p>The next page token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetEntityTypesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEntityTypesOutput");
        formatter.field("entity_types", &self.entity_types);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetEntityTypesOutput`](crate::output::GetEntityTypesOutput)
pub mod get_entity_types_output {
    /// A builder for [`GetEntityTypesOutput`](crate::output::GetEntityTypesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entity_types: std::option::Option<std::vec::Vec<crate::model::EntityType>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `entity_types`.
        ///
        /// To override the contents of this collection use [`set_entity_types`](Self::set_entity_types).
        ///
        /// <p>An array of entity types.</p>
        pub fn entity_types(mut self, input: crate::model::EntityType) -> Self {
            let mut v = self.entity_types.unwrap_or_default();
            v.push(input);
            self.entity_types = Some(v);
            self
        }
        /// <p>An array of entity types.</p>
        pub fn set_entity_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EntityType>>,
        ) -> Self {
            self.entity_types = input;
            self
        }
        /// <p>The next page token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEntityTypesOutput`](crate::output::GetEntityTypesOutput)
        pub fn build(self) -> crate::output::GetEntityTypesOutput {
            crate::output::GetEntityTypesOutput {
                entity_types: self.entity_types,
                next_token: self.next_token,
            }
        }
    }
}
impl GetEntityTypesOutput {
    /// Creates a new builder-style object to manufacture [`GetEntityTypesOutput`](crate::output::GetEntityTypesOutput)
    pub fn builder() -> crate::output::get_entity_types_output::Builder {
        crate::output::get_entity_types_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDetectorVersionOutput {
    /// <p>The detector ID.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The detector version ID.</p>
    pub detector_version_id: std::option::Option<std::string::String>,
    /// <p>The detector version description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon SageMaker model endpoints included in the detector version.</p>
    pub external_model_endpoints: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The model versions included in the detector version. </p>
    pub model_versions: std::option::Option<std::vec::Vec<crate::model::ModelVersion>>,
    /// <p>The rules included in the detector version.</p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::Rule>>,
    /// <p>The status of the detector version.</p>
    pub status: std::option::Option<crate::model::DetectorVersionStatus>,
    /// <p>The timestamp when the detector version was last updated. </p>
    pub last_updated_time: std::option::Option<std::string::String>,
    /// <p>The timestamp when the detector version was created. </p>
    pub created_time: std::option::Option<std::string::String>,
    /// <p>The execution mode of the rule in the dectector</p>
    /// <p> <code>FIRST_MATCHED</code> indicates that Amazon Fraud Detector evaluates rules sequentially, first to last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule.</p>
    /// <p> <code>ALL_MATCHED</code> indicates that Amazon Fraud Detector evaluates all rules and returns the outcomes for all matched rules. You can define and edit the rule mode at the detector version level, when it is in draft status.</p>
    pub rule_execution_mode: std::option::Option<crate::model::RuleExecutionMode>,
    /// <p>The detector version ARN.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl GetDetectorVersionOutput {
    /// <p>The detector ID.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>The detector version ID.</p>
    pub fn detector_version_id(&self) -> std::option::Option<&str> {
        self.detector_version_id.as_deref()
    }
    /// <p>The detector version description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon SageMaker model endpoints included in the detector version.</p>
    pub fn external_model_endpoints(&self) -> std::option::Option<&[std::string::String]> {
        self.external_model_endpoints.as_deref()
    }
    /// <p>The model versions included in the detector version. </p>
    pub fn model_versions(&self) -> std::option::Option<&[crate::model::ModelVersion]> {
        self.model_versions.as_deref()
    }
    /// <p>The rules included in the detector version.</p>
    pub fn rules(&self) -> std::option::Option<&[crate::model::Rule]> {
        self.rules.as_deref()
    }
    /// <p>The status of the detector version.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::DetectorVersionStatus> {
        self.status.as_ref()
    }
    /// <p>The timestamp when the detector version was last updated. </p>
    pub fn last_updated_time(&self) -> std::option::Option<&str> {
        self.last_updated_time.as_deref()
    }
    /// <p>The timestamp when the detector version was created. </p>
    pub fn created_time(&self) -> std::option::Option<&str> {
        self.created_time.as_deref()
    }
    /// <p>The execution mode of the rule in the dectector</p>
    /// <p> <code>FIRST_MATCHED</code> indicates that Amazon Fraud Detector evaluates rules sequentially, first to last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule.</p>
    /// <p> <code>ALL_MATCHED</code> indicates that Amazon Fraud Detector evaluates all rules and returns the outcomes for all matched rules. You can define and edit the rule mode at the detector version level, when it is in draft status.</p>
    pub fn rule_execution_mode(&self) -> std::option::Option<&crate::model::RuleExecutionMode> {
        self.rule_execution_mode.as_ref()
    }
    /// <p>The detector version ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for GetDetectorVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDetectorVersionOutput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("detector_version_id", &self.detector_version_id);
        formatter.field("description", &self.description);
        formatter.field("external_model_endpoints", &self.external_model_endpoints);
        formatter.field("model_versions", &self.model_versions);
        formatter.field("rules", &self.rules);
        formatter.field("status", &self.status);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("created_time", &self.created_time);
        formatter.field("rule_execution_mode", &self.rule_execution_mode);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`GetDetectorVersionOutput`](crate::output::GetDetectorVersionOutput)
pub mod get_detector_version_output {
    /// A builder for [`GetDetectorVersionOutput`](crate::output::GetDetectorVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) detector_version_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) external_model_endpoints:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) model_versions: std::option::Option<std::vec::Vec<crate::model::ModelVersion>>,
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        pub(crate) status: std::option::Option<crate::model::DetectorVersionStatus>,
        pub(crate) last_updated_time: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<std::string::String>,
        pub(crate) rule_execution_mode: std::option::Option<crate::model::RuleExecutionMode>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The detector ID.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The detector ID.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The detector version ID.</p>
        pub fn detector_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_version_id = Some(input.into());
            self
        }
        /// <p>The detector version ID.</p>
        pub fn set_detector_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_version_id = input;
            self
        }
        /// <p>The detector version description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The detector version description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `external_model_endpoints`.
        ///
        /// To override the contents of this collection use [`set_external_model_endpoints`](Self::set_external_model_endpoints).
        ///
        /// <p>The Amazon SageMaker model endpoints included in the detector version.</p>
        pub fn external_model_endpoints(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.external_model_endpoints.unwrap_or_default();
            v.push(input.into());
            self.external_model_endpoints = Some(v);
            self
        }
        /// <p>The Amazon SageMaker model endpoints included in the detector version.</p>
        pub fn set_external_model_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.external_model_endpoints = input;
            self
        }
        /// Appends an item to `model_versions`.
        ///
        /// To override the contents of this collection use [`set_model_versions`](Self::set_model_versions).
        ///
        /// <p>The model versions included in the detector version. </p>
        pub fn model_versions(mut self, input: crate::model::ModelVersion) -> Self {
            let mut v = self.model_versions.unwrap_or_default();
            v.push(input);
            self.model_versions = Some(v);
            self
        }
        /// <p>The model versions included in the detector version. </p>
        pub fn set_model_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ModelVersion>>,
        ) -> Self {
            self.model_versions = input;
            self
        }
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>The rules included in the detector version.</p>
        pub fn rules(mut self, input: crate::model::Rule) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input);
            self.rules = Some(v);
            self
        }
        /// <p>The rules included in the detector version.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// <p>The status of the detector version.</p>
        pub fn status(mut self, input: crate::model::DetectorVersionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the detector version.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DetectorVersionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The timestamp when the detector version was last updated. </p>
        pub fn last_updated_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_updated_time = Some(input.into());
            self
        }
        /// <p>The timestamp when the detector version was last updated. </p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>The timestamp when the detector version was created. </p>
        pub fn created_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_time = Some(input.into());
            self
        }
        /// <p>The timestamp when the detector version was created. </p>
        pub fn set_created_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The execution mode of the rule in the dectector</p>
        /// <p> <code>FIRST_MATCHED</code> indicates that Amazon Fraud Detector evaluates rules sequentially, first to last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule.</p>
        /// <p> <code>ALL_MATCHED</code> indicates that Amazon Fraud Detector evaluates all rules and returns the outcomes for all matched rules. You can define and edit the rule mode at the detector version level, when it is in draft status.</p>
        pub fn rule_execution_mode(mut self, input: crate::model::RuleExecutionMode) -> Self {
            self.rule_execution_mode = Some(input);
            self
        }
        /// <p>The execution mode of the rule in the dectector</p>
        /// <p> <code>FIRST_MATCHED</code> indicates that Amazon Fraud Detector evaluates rules sequentially, first to last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule.</p>
        /// <p> <code>ALL_MATCHED</code> indicates that Amazon Fraud Detector evaluates all rules and returns the outcomes for all matched rules. You can define and edit the rule mode at the detector version level, when it is in draft status.</p>
        pub fn set_rule_execution_mode(
            mut self,
            input: std::option::Option<crate::model::RuleExecutionMode>,
        ) -> Self {
            self.rule_execution_mode = input;
            self
        }
        /// <p>The detector version ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The detector version ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDetectorVersionOutput`](crate::output::GetDetectorVersionOutput)
        pub fn build(self) -> crate::output::GetDetectorVersionOutput {
            crate::output::GetDetectorVersionOutput {
                detector_id: self.detector_id,
                detector_version_id: self.detector_version_id,
                description: self.description,
                external_model_endpoints: self.external_model_endpoints,
                model_versions: self.model_versions,
                rules: self.rules,
                status: self.status,
                last_updated_time: self.last_updated_time,
                created_time: self.created_time,
                rule_execution_mode: self.rule_execution_mode,
                arn: self.arn,
            }
        }
    }
}
impl GetDetectorVersionOutput {
    /// Creates a new builder-style object to manufacture [`GetDetectorVersionOutput`](crate::output::GetDetectorVersionOutput)
    pub fn builder() -> crate::output::get_detector_version_output::Builder {
        crate::output::get_detector_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDetectorsOutput {
    /// <p>The detectors.</p>
    pub detectors: std::option::Option<std::vec::Vec<crate::model::Detector>>,
    /// <p>The next page token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetDetectorsOutput {
    /// <p>The detectors.</p>
    pub fn detectors(&self) -> std::option::Option<&[crate::model::Detector]> {
        self.detectors.as_deref()
    }
    /// <p>The next page token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetDetectorsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDetectorsOutput");
        formatter.field("detectors", &self.detectors);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetDetectorsOutput`](crate::output::GetDetectorsOutput)
pub mod get_detectors_output {
    /// A builder for [`GetDetectorsOutput`](crate::output::GetDetectorsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detectors: std::option::Option<std::vec::Vec<crate::model::Detector>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `detectors`.
        ///
        /// To override the contents of this collection use [`set_detectors`](Self::set_detectors).
        ///
        /// <p>The detectors.</p>
        pub fn detectors(mut self, input: crate::model::Detector) -> Self {
            let mut v = self.detectors.unwrap_or_default();
            v.push(input);
            self.detectors = Some(v);
            self
        }
        /// <p>The detectors.</p>
        pub fn set_detectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Detector>>,
        ) -> Self {
            self.detectors = input;
            self
        }
        /// <p>The next page token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDetectorsOutput`](crate::output::GetDetectorsOutput)
        pub fn build(self) -> crate::output::GetDetectorsOutput {
            crate::output::GetDetectorsOutput {
                detectors: self.detectors,
                next_token: self.next_token,
            }
        }
    }
}
impl GetDetectorsOutput {
    /// Creates a new builder-style object to manufacture [`GetDetectorsOutput`](crate::output::GetDetectorsOutput)
    pub fn builder() -> crate::output::get_detectors_output::Builder {
        crate::output::get_detectors_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeleteEventsByEventTypeStatusOutput {
    /// <p>The event type name.</p>
    pub event_type_name: std::option::Option<std::string::String>,
    /// <p>The deletion status.</p>
    pub events_deletion_status: std::option::Option<crate::model::AsyncJobStatus>,
}
impl GetDeleteEventsByEventTypeStatusOutput {
    /// <p>The event type name.</p>
    pub fn event_type_name(&self) -> std::option::Option<&str> {
        self.event_type_name.as_deref()
    }
    /// <p>The deletion status.</p>
    pub fn events_deletion_status(&self) -> std::option::Option<&crate::model::AsyncJobStatus> {
        self.events_deletion_status.as_ref()
    }
}
impl std::fmt::Debug for GetDeleteEventsByEventTypeStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeleteEventsByEventTypeStatusOutput");
        formatter.field("event_type_name", &self.event_type_name);
        formatter.field("events_deletion_status", &self.events_deletion_status);
        formatter.finish()
    }
}
/// See [`GetDeleteEventsByEventTypeStatusOutput`](crate::output::GetDeleteEventsByEventTypeStatusOutput)
pub mod get_delete_events_by_event_type_status_output {
    /// A builder for [`GetDeleteEventsByEventTypeStatusOutput`](crate::output::GetDeleteEventsByEventTypeStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_type_name: std::option::Option<std::string::String>,
        pub(crate) events_deletion_status: std::option::Option<crate::model::AsyncJobStatus>,
    }
    impl Builder {
        /// <p>The event type name.</p>
        pub fn event_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_type_name = Some(input.into());
            self
        }
        /// <p>The event type name.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_type_name = input;
            self
        }
        /// <p>The deletion status.</p>
        pub fn events_deletion_status(mut self, input: crate::model::AsyncJobStatus) -> Self {
            self.events_deletion_status = Some(input);
            self
        }
        /// <p>The deletion status.</p>
        pub fn set_events_deletion_status(
            mut self,
            input: std::option::Option<crate::model::AsyncJobStatus>,
        ) -> Self {
            self.events_deletion_status = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeleteEventsByEventTypeStatusOutput`](crate::output::GetDeleteEventsByEventTypeStatusOutput)
        pub fn build(self) -> crate::output::GetDeleteEventsByEventTypeStatusOutput {
            crate::output::GetDeleteEventsByEventTypeStatusOutput {
                event_type_name: self.event_type_name,
                events_deletion_status: self.events_deletion_status,
            }
        }
    }
}
impl GetDeleteEventsByEventTypeStatusOutput {
    /// Creates a new builder-style object to manufacture [`GetDeleteEventsByEventTypeStatusOutput`](crate::output::GetDeleteEventsByEventTypeStatusOutput)
    pub fn builder() -> crate::output::get_delete_events_by_event_type_status_output::Builder {
        crate::output::get_delete_events_by_event_type_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBatchPredictionJobsOutput {
    /// <p>An array containing the details of each batch prediction job.</p>
    pub batch_predictions: std::option::Option<std::vec::Vec<crate::model::BatchPrediction>>,
    /// <p>The next token for the subsequent request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetBatchPredictionJobsOutput {
    /// <p>An array containing the details of each batch prediction job.</p>
    pub fn batch_predictions(&self) -> std::option::Option<&[crate::model::BatchPrediction]> {
        self.batch_predictions.as_deref()
    }
    /// <p>The next token for the subsequent request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetBatchPredictionJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBatchPredictionJobsOutput");
        formatter.field("batch_predictions", &self.batch_predictions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetBatchPredictionJobsOutput`](crate::output::GetBatchPredictionJobsOutput)
pub mod get_batch_prediction_jobs_output {
    /// A builder for [`GetBatchPredictionJobsOutput`](crate::output::GetBatchPredictionJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) batch_predictions:
            std::option::Option<std::vec::Vec<crate::model::BatchPrediction>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `batch_predictions`.
        ///
        /// To override the contents of this collection use [`set_batch_predictions`](Self::set_batch_predictions).
        ///
        /// <p>An array containing the details of each batch prediction job.</p>
        pub fn batch_predictions(mut self, input: crate::model::BatchPrediction) -> Self {
            let mut v = self.batch_predictions.unwrap_or_default();
            v.push(input);
            self.batch_predictions = Some(v);
            self
        }
        /// <p>An array containing the details of each batch prediction job.</p>
        pub fn set_batch_predictions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchPrediction>>,
        ) -> Self {
            self.batch_predictions = input;
            self
        }
        /// <p>The next token for the subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next token for the subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBatchPredictionJobsOutput`](crate::output::GetBatchPredictionJobsOutput)
        pub fn build(self) -> crate::output::GetBatchPredictionJobsOutput {
            crate::output::GetBatchPredictionJobsOutput {
                batch_predictions: self.batch_predictions,
                next_token: self.next_token,
            }
        }
    }
}
impl GetBatchPredictionJobsOutput {
    /// Creates a new builder-style object to manufacture [`GetBatchPredictionJobsOutput`](crate::output::GetBatchPredictionJobsOutput)
    pub fn builder() -> crate::output::get_batch_prediction_jobs_output::Builder {
        crate::output::get_batch_prediction_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBatchImportJobsOutput {
    /// <p>An array containing the details of each batch import job.</p>
    pub batch_imports: std::option::Option<std::vec::Vec<crate::model::BatchImport>>,
    /// <p>The next token for the subsequent resquest.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetBatchImportJobsOutput {
    /// <p>An array containing the details of each batch import job.</p>
    pub fn batch_imports(&self) -> std::option::Option<&[crate::model::BatchImport]> {
        self.batch_imports.as_deref()
    }
    /// <p>The next token for the subsequent resquest.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetBatchImportJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBatchImportJobsOutput");
        formatter.field("batch_imports", &self.batch_imports);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetBatchImportJobsOutput`](crate::output::GetBatchImportJobsOutput)
pub mod get_batch_import_jobs_output {
    /// A builder for [`GetBatchImportJobsOutput`](crate::output::GetBatchImportJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) batch_imports: std::option::Option<std::vec::Vec<crate::model::BatchImport>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `batch_imports`.
        ///
        /// To override the contents of this collection use [`set_batch_imports`](Self::set_batch_imports).
        ///
        /// <p>An array containing the details of each batch import job.</p>
        pub fn batch_imports(mut self, input: crate::model::BatchImport) -> Self {
            let mut v = self.batch_imports.unwrap_or_default();
            v.push(input);
            self.batch_imports = Some(v);
            self
        }
        /// <p>An array containing the details of each batch import job.</p>
        pub fn set_batch_imports(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchImport>>,
        ) -> Self {
            self.batch_imports = input;
            self
        }
        /// <p>The next token for the subsequent resquest.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next token for the subsequent resquest.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBatchImportJobsOutput`](crate::output::GetBatchImportJobsOutput)
        pub fn build(self) -> crate::output::GetBatchImportJobsOutput {
            crate::output::GetBatchImportJobsOutput {
                batch_imports: self.batch_imports,
                next_token: self.next_token,
            }
        }
    }
}
impl GetBatchImportJobsOutput {
    /// Creates a new builder-style object to manufacture [`GetBatchImportJobsOutput`](crate::output::GetBatchImportJobsOutput)
    pub fn builder() -> crate::output::get_batch_import_jobs_output::Builder {
        crate::output::get_batch_import_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeModelVersionsOutput {
    /// <p>The model version details.</p>
    pub model_version_details: std::option::Option<std::vec::Vec<crate::model::ModelVersionDetail>>,
    /// <p>The next token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeModelVersionsOutput {
    /// <p>The model version details.</p>
    pub fn model_version_details(
        &self,
    ) -> std::option::Option<&[crate::model::ModelVersionDetail]> {
        self.model_version_details.as_deref()
    }
    /// <p>The next token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeModelVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeModelVersionsOutput");
        formatter.field("model_version_details", &self.model_version_details);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeModelVersionsOutput`](crate::output::DescribeModelVersionsOutput)
pub mod describe_model_versions_output {
    /// A builder for [`DescribeModelVersionsOutput`](crate::output::DescribeModelVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_version_details:
            std::option::Option<std::vec::Vec<crate::model::ModelVersionDetail>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `model_version_details`.
        ///
        /// To override the contents of this collection use [`set_model_version_details`](Self::set_model_version_details).
        ///
        /// <p>The model version details.</p>
        pub fn model_version_details(mut self, input: crate::model::ModelVersionDetail) -> Self {
            let mut v = self.model_version_details.unwrap_or_default();
            v.push(input);
            self.model_version_details = Some(v);
            self
        }
        /// <p>The model version details.</p>
        pub fn set_model_version_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ModelVersionDetail>>,
        ) -> Self {
            self.model_version_details = input;
            self
        }
        /// <p>The next token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeModelVersionsOutput`](crate::output::DescribeModelVersionsOutput)
        pub fn build(self) -> crate::output::DescribeModelVersionsOutput {
            crate::output::DescribeModelVersionsOutput {
                model_version_details: self.model_version_details,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeModelVersionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeModelVersionsOutput`](crate::output::DescribeModelVersionsOutput)
    pub fn builder() -> crate::output::describe_model_versions_output::Builder {
        crate::output::describe_model_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDetectorOutput {
    /// <p>The detector ID.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The status and description for each detector version.</p>
    pub detector_version_summaries:
        std::option::Option<std::vec::Vec<crate::model::DetectorVersionSummary>>,
    /// <p>The next token to be used for subsequent requests.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The detector ARN.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl DescribeDetectorOutput {
    /// <p>The detector ID.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>The status and description for each detector version.</p>
    pub fn detector_version_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::DetectorVersionSummary]> {
        self.detector_version_summaries.as_deref()
    }
    /// <p>The next token to be used for subsequent requests.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The detector ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeDetectorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDetectorOutput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field(
            "detector_version_summaries",
            &self.detector_version_summaries,
        );
        formatter.field("next_token", &self.next_token);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`DescribeDetectorOutput`](crate::output::DescribeDetectorOutput)
pub mod describe_detector_output {
    /// A builder for [`DescribeDetectorOutput`](crate::output::DescribeDetectorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) detector_version_summaries:
            std::option::Option<std::vec::Vec<crate::model::DetectorVersionSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The detector ID.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The detector ID.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// Appends an item to `detector_version_summaries`.
        ///
        /// To override the contents of this collection use [`set_detector_version_summaries`](Self::set_detector_version_summaries).
        ///
        /// <p>The status and description for each detector version.</p>
        pub fn detector_version_summaries(
            mut self,
            input: crate::model::DetectorVersionSummary,
        ) -> Self {
            let mut v = self.detector_version_summaries.unwrap_or_default();
            v.push(input);
            self.detector_version_summaries = Some(v);
            self
        }
        /// <p>The status and description for each detector version.</p>
        pub fn set_detector_version_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DetectorVersionSummary>>,
        ) -> Self {
            self.detector_version_summaries = input;
            self
        }
        /// <p>The next token to be used for subsequent requests.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next token to be used for subsequent requests.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The detector ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The detector ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDetectorOutput`](crate::output::DescribeDetectorOutput)
        pub fn build(self) -> crate::output::DescribeDetectorOutput {
            crate::output::DescribeDetectorOutput {
                detector_id: self.detector_id,
                detector_version_summaries: self.detector_version_summaries,
                next_token: self.next_token,
                arn: self.arn,
            }
        }
    }
}
impl DescribeDetectorOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDetectorOutput`](crate::output::DescribeDetectorOutput)
    pub fn builder() -> crate::output::describe_detector_output::Builder {
        crate::output::describe_detector_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVariableOutput {}
impl std::fmt::Debug for DeleteVariableOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVariableOutput");
        formatter.finish()
    }
}
/// See [`DeleteVariableOutput`](crate::output::DeleteVariableOutput)
pub mod delete_variable_output {
    /// A builder for [`DeleteVariableOutput`](crate::output::DeleteVariableOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteVariableOutput`](crate::output::DeleteVariableOutput)
        pub fn build(self) -> crate::output::DeleteVariableOutput {
            crate::output::DeleteVariableOutput {}
        }
    }
}
impl DeleteVariableOutput {
    /// Creates a new builder-style object to manufacture [`DeleteVariableOutput`](crate::output::DeleteVariableOutput)
    pub fn builder() -> crate::output::delete_variable_output::Builder {
        crate::output::delete_variable_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRuleOutput {}
impl std::fmt::Debug for DeleteRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRuleOutput");
        formatter.finish()
    }
}
/// See [`DeleteRuleOutput`](crate::output::DeleteRuleOutput)
pub mod delete_rule_output {
    /// A builder for [`DeleteRuleOutput`](crate::output::DeleteRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteRuleOutput`](crate::output::DeleteRuleOutput)
        pub fn build(self) -> crate::output::DeleteRuleOutput {
            crate::output::DeleteRuleOutput {}
        }
    }
}
impl DeleteRuleOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRuleOutput`](crate::output::DeleteRuleOutput)
    pub fn builder() -> crate::output::delete_rule_output::Builder {
        crate::output::delete_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteOutcomeOutput {}
impl std::fmt::Debug for DeleteOutcomeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteOutcomeOutput");
        formatter.finish()
    }
}
/// See [`DeleteOutcomeOutput`](crate::output::DeleteOutcomeOutput)
pub mod delete_outcome_output {
    /// A builder for [`DeleteOutcomeOutput`](crate::output::DeleteOutcomeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteOutcomeOutput`](crate::output::DeleteOutcomeOutput)
        pub fn build(self) -> crate::output::DeleteOutcomeOutput {
            crate::output::DeleteOutcomeOutput {}
        }
    }
}
impl DeleteOutcomeOutput {
    /// Creates a new builder-style object to manufacture [`DeleteOutcomeOutput`](crate::output::DeleteOutcomeOutput)
    pub fn builder() -> crate::output::delete_outcome_output::Builder {
        crate::output::delete_outcome_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteModelVersionOutput {}
impl std::fmt::Debug for DeleteModelVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteModelVersionOutput");
        formatter.finish()
    }
}
/// See [`DeleteModelVersionOutput`](crate::output::DeleteModelVersionOutput)
pub mod delete_model_version_output {
    /// A builder for [`DeleteModelVersionOutput`](crate::output::DeleteModelVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteModelVersionOutput`](crate::output::DeleteModelVersionOutput)
        pub fn build(self) -> crate::output::DeleteModelVersionOutput {
            crate::output::DeleteModelVersionOutput {}
        }
    }
}
impl DeleteModelVersionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteModelVersionOutput`](crate::output::DeleteModelVersionOutput)
    pub fn builder() -> crate::output::delete_model_version_output::Builder {
        crate::output::delete_model_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteModelOutput {}
impl std::fmt::Debug for DeleteModelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteModelOutput");
        formatter.finish()
    }
}
/// See [`DeleteModelOutput`](crate::output::DeleteModelOutput)
pub mod delete_model_output {
    /// A builder for [`DeleteModelOutput`](crate::output::DeleteModelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteModelOutput`](crate::output::DeleteModelOutput)
        pub fn build(self) -> crate::output::DeleteModelOutput {
            crate::output::DeleteModelOutput {}
        }
    }
}
impl DeleteModelOutput {
    /// Creates a new builder-style object to manufacture [`DeleteModelOutput`](crate::output::DeleteModelOutput)
    pub fn builder() -> crate::output::delete_model_output::Builder {
        crate::output::delete_model_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLabelOutput {}
impl std::fmt::Debug for DeleteLabelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLabelOutput");
        formatter.finish()
    }
}
/// See [`DeleteLabelOutput`](crate::output::DeleteLabelOutput)
pub mod delete_label_output {
    /// A builder for [`DeleteLabelOutput`](crate::output::DeleteLabelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteLabelOutput`](crate::output::DeleteLabelOutput)
        pub fn build(self) -> crate::output::DeleteLabelOutput {
            crate::output::DeleteLabelOutput {}
        }
    }
}
impl DeleteLabelOutput {
    /// Creates a new builder-style object to manufacture [`DeleteLabelOutput`](crate::output::DeleteLabelOutput)
    pub fn builder() -> crate::output::delete_label_output::Builder {
        crate::output::delete_label_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteExternalModelOutput {}
impl std::fmt::Debug for DeleteExternalModelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteExternalModelOutput");
        formatter.finish()
    }
}
/// See [`DeleteExternalModelOutput`](crate::output::DeleteExternalModelOutput)
pub mod delete_external_model_output {
    /// A builder for [`DeleteExternalModelOutput`](crate::output::DeleteExternalModelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteExternalModelOutput`](crate::output::DeleteExternalModelOutput)
        pub fn build(self) -> crate::output::DeleteExternalModelOutput {
            crate::output::DeleteExternalModelOutput {}
        }
    }
}
impl DeleteExternalModelOutput {
    /// Creates a new builder-style object to manufacture [`DeleteExternalModelOutput`](crate::output::DeleteExternalModelOutput)
    pub fn builder() -> crate::output::delete_external_model_output::Builder {
        crate::output::delete_external_model_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEventTypeOutput {}
impl std::fmt::Debug for DeleteEventTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEventTypeOutput");
        formatter.finish()
    }
}
/// See [`DeleteEventTypeOutput`](crate::output::DeleteEventTypeOutput)
pub mod delete_event_type_output {
    /// A builder for [`DeleteEventTypeOutput`](crate::output::DeleteEventTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteEventTypeOutput`](crate::output::DeleteEventTypeOutput)
        pub fn build(self) -> crate::output::DeleteEventTypeOutput {
            crate::output::DeleteEventTypeOutput {}
        }
    }
}
impl DeleteEventTypeOutput {
    /// Creates a new builder-style object to manufacture [`DeleteEventTypeOutput`](crate::output::DeleteEventTypeOutput)
    pub fn builder() -> crate::output::delete_event_type_output::Builder {
        crate::output::delete_event_type_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEventsByEventTypeOutput {
    /// <p>Name of event type for which to delete the events.</p>
    pub event_type_name: std::option::Option<std::string::String>,
    /// <p>The status of the delete request.</p>
    pub events_deletion_status: std::option::Option<std::string::String>,
}
impl DeleteEventsByEventTypeOutput {
    /// <p>Name of event type for which to delete the events.</p>
    pub fn event_type_name(&self) -> std::option::Option<&str> {
        self.event_type_name.as_deref()
    }
    /// <p>The status of the delete request.</p>
    pub fn events_deletion_status(&self) -> std::option::Option<&str> {
        self.events_deletion_status.as_deref()
    }
}
impl std::fmt::Debug for DeleteEventsByEventTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEventsByEventTypeOutput");
        formatter.field("event_type_name", &self.event_type_name);
        formatter.field("events_deletion_status", &self.events_deletion_status);
        formatter.finish()
    }
}
/// See [`DeleteEventsByEventTypeOutput`](crate::output::DeleteEventsByEventTypeOutput)
pub mod delete_events_by_event_type_output {
    /// A builder for [`DeleteEventsByEventTypeOutput`](crate::output::DeleteEventsByEventTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_type_name: std::option::Option<std::string::String>,
        pub(crate) events_deletion_status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of event type for which to delete the events.</p>
        pub fn event_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_type_name = Some(input.into());
            self
        }
        /// <p>Name of event type for which to delete the events.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_type_name = input;
            self
        }
        /// <p>The status of the delete request.</p>
        pub fn events_deletion_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.events_deletion_status = Some(input.into());
            self
        }
        /// <p>The status of the delete request.</p>
        pub fn set_events_deletion_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.events_deletion_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEventsByEventTypeOutput`](crate::output::DeleteEventsByEventTypeOutput)
        pub fn build(self) -> crate::output::DeleteEventsByEventTypeOutput {
            crate::output::DeleteEventsByEventTypeOutput {
                event_type_name: self.event_type_name,
                events_deletion_status: self.events_deletion_status,
            }
        }
    }
}
impl DeleteEventsByEventTypeOutput {
    /// Creates a new builder-style object to manufacture [`DeleteEventsByEventTypeOutput`](crate::output::DeleteEventsByEventTypeOutput)
    pub fn builder() -> crate::output::delete_events_by_event_type_output::Builder {
        crate::output::delete_events_by_event_type_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEventOutput {}
impl std::fmt::Debug for DeleteEventOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEventOutput");
        formatter.finish()
    }
}
/// See [`DeleteEventOutput`](crate::output::DeleteEventOutput)
pub mod delete_event_output {
    /// A builder for [`DeleteEventOutput`](crate::output::DeleteEventOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteEventOutput`](crate::output::DeleteEventOutput)
        pub fn build(self) -> crate::output::DeleteEventOutput {
            crate::output::DeleteEventOutput {}
        }
    }
}
impl DeleteEventOutput {
    /// Creates a new builder-style object to manufacture [`DeleteEventOutput`](crate::output::DeleteEventOutput)
    pub fn builder() -> crate::output::delete_event_output::Builder {
        crate::output::delete_event_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEntityTypeOutput {}
impl std::fmt::Debug for DeleteEntityTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEntityTypeOutput");
        formatter.finish()
    }
}
/// See [`DeleteEntityTypeOutput`](crate::output::DeleteEntityTypeOutput)
pub mod delete_entity_type_output {
    /// A builder for [`DeleteEntityTypeOutput`](crate::output::DeleteEntityTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteEntityTypeOutput`](crate::output::DeleteEntityTypeOutput)
        pub fn build(self) -> crate::output::DeleteEntityTypeOutput {
            crate::output::DeleteEntityTypeOutput {}
        }
    }
}
impl DeleteEntityTypeOutput {
    /// Creates a new builder-style object to manufacture [`DeleteEntityTypeOutput`](crate::output::DeleteEntityTypeOutput)
    pub fn builder() -> crate::output::delete_entity_type_output::Builder {
        crate::output::delete_entity_type_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDetectorVersionOutput {}
impl std::fmt::Debug for DeleteDetectorVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDetectorVersionOutput");
        formatter.finish()
    }
}
/// See [`DeleteDetectorVersionOutput`](crate::output::DeleteDetectorVersionOutput)
pub mod delete_detector_version_output {
    /// A builder for [`DeleteDetectorVersionOutput`](crate::output::DeleteDetectorVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteDetectorVersionOutput`](crate::output::DeleteDetectorVersionOutput)
        pub fn build(self) -> crate::output::DeleteDetectorVersionOutput {
            crate::output::DeleteDetectorVersionOutput {}
        }
    }
}
impl DeleteDetectorVersionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDetectorVersionOutput`](crate::output::DeleteDetectorVersionOutput)
    pub fn builder() -> crate::output::delete_detector_version_output::Builder {
        crate::output::delete_detector_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDetectorOutput {}
impl std::fmt::Debug for DeleteDetectorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDetectorOutput");
        formatter.finish()
    }
}
/// See [`DeleteDetectorOutput`](crate::output::DeleteDetectorOutput)
pub mod delete_detector_output {
    /// A builder for [`DeleteDetectorOutput`](crate::output::DeleteDetectorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteDetectorOutput`](crate::output::DeleteDetectorOutput)
        pub fn build(self) -> crate::output::DeleteDetectorOutput {
            crate::output::DeleteDetectorOutput {}
        }
    }
}
impl DeleteDetectorOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDetectorOutput`](crate::output::DeleteDetectorOutput)
    pub fn builder() -> crate::output::delete_detector_output::Builder {
        crate::output::delete_detector_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBatchPredictionJobOutput {}
impl std::fmt::Debug for DeleteBatchPredictionJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBatchPredictionJobOutput");
        formatter.finish()
    }
}
/// See [`DeleteBatchPredictionJobOutput`](crate::output::DeleteBatchPredictionJobOutput)
pub mod delete_batch_prediction_job_output {
    /// A builder for [`DeleteBatchPredictionJobOutput`](crate::output::DeleteBatchPredictionJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteBatchPredictionJobOutput`](crate::output::DeleteBatchPredictionJobOutput)
        pub fn build(self) -> crate::output::DeleteBatchPredictionJobOutput {
            crate::output::DeleteBatchPredictionJobOutput {}
        }
    }
}
impl DeleteBatchPredictionJobOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBatchPredictionJobOutput`](crate::output::DeleteBatchPredictionJobOutput)
    pub fn builder() -> crate::output::delete_batch_prediction_job_output::Builder {
        crate::output::delete_batch_prediction_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBatchImportJobOutput {}
impl std::fmt::Debug for DeleteBatchImportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBatchImportJobOutput");
        formatter.finish()
    }
}
/// See [`DeleteBatchImportJobOutput`](crate::output::DeleteBatchImportJobOutput)
pub mod delete_batch_import_job_output {
    /// A builder for [`DeleteBatchImportJobOutput`](crate::output::DeleteBatchImportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteBatchImportJobOutput`](crate::output::DeleteBatchImportJobOutput)
        pub fn build(self) -> crate::output::DeleteBatchImportJobOutput {
            crate::output::DeleteBatchImportJobOutput {}
        }
    }
}
impl DeleteBatchImportJobOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBatchImportJobOutput`](crate::output::DeleteBatchImportJobOutput)
    pub fn builder() -> crate::output::delete_batch_import_job_output::Builder {
        crate::output::delete_batch_import_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateVariableOutput {}
impl std::fmt::Debug for CreateVariableOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateVariableOutput");
        formatter.finish()
    }
}
/// See [`CreateVariableOutput`](crate::output::CreateVariableOutput)
pub mod create_variable_output {
    /// A builder for [`CreateVariableOutput`](crate::output::CreateVariableOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateVariableOutput`](crate::output::CreateVariableOutput)
        pub fn build(self) -> crate::output::CreateVariableOutput {
            crate::output::CreateVariableOutput {}
        }
    }
}
impl CreateVariableOutput {
    /// Creates a new builder-style object to manufacture [`CreateVariableOutput`](crate::output::CreateVariableOutput)
    pub fn builder() -> crate::output::create_variable_output::Builder {
        crate::output::create_variable_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRuleOutput {
    /// <p>The created rule.</p>
    pub rule: std::option::Option<crate::model::Rule>,
}
impl CreateRuleOutput {
    /// <p>The created rule.</p>
    pub fn rule(&self) -> std::option::Option<&crate::model::Rule> {
        self.rule.as_ref()
    }
}
impl std::fmt::Debug for CreateRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRuleOutput");
        formatter.field("rule", &self.rule);
        formatter.finish()
    }
}
/// See [`CreateRuleOutput`](crate::output::CreateRuleOutput)
pub mod create_rule_output {
    /// A builder for [`CreateRuleOutput`](crate::output::CreateRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule: std::option::Option<crate::model::Rule>,
    }
    impl Builder {
        /// <p>The created rule.</p>
        pub fn rule(mut self, input: crate::model::Rule) -> Self {
            self.rule = Some(input);
            self
        }
        /// <p>The created rule.</p>
        pub fn set_rule(mut self, input: std::option::Option<crate::model::Rule>) -> Self {
            self.rule = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRuleOutput`](crate::output::CreateRuleOutput)
        pub fn build(self) -> crate::output::CreateRuleOutput {
            crate::output::CreateRuleOutput { rule: self.rule }
        }
    }
}
impl CreateRuleOutput {
    /// Creates a new builder-style object to manufacture [`CreateRuleOutput`](crate::output::CreateRuleOutput)
    pub fn builder() -> crate::output::create_rule_output::Builder {
        crate::output::create_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateModelVersionOutput {
    /// <p>The model ID.</p>
    pub model_id: std::option::Option<std::string::String>,
    /// <p>The model type.</p>
    pub model_type: std::option::Option<crate::model::ModelTypeEnum>,
    /// <p>The model version number of the model version created.</p>
    pub model_version_number: std::option::Option<std::string::String>,
    /// <p>The model version status. </p>
    pub status: std::option::Option<std::string::String>,
}
impl CreateModelVersionOutput {
    /// <p>The model ID.</p>
    pub fn model_id(&self) -> std::option::Option<&str> {
        self.model_id.as_deref()
    }
    /// <p>The model type.</p>
    pub fn model_type(&self) -> std::option::Option<&crate::model::ModelTypeEnum> {
        self.model_type.as_ref()
    }
    /// <p>The model version number of the model version created.</p>
    pub fn model_version_number(&self) -> std::option::Option<&str> {
        self.model_version_number.as_deref()
    }
    /// <p>The model version status. </p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for CreateModelVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateModelVersionOutput");
        formatter.field("model_id", &self.model_id);
        formatter.field("model_type", &self.model_type);
        formatter.field("model_version_number", &self.model_version_number);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`CreateModelVersionOutput`](crate::output::CreateModelVersionOutput)
pub mod create_model_version_output {
    /// A builder for [`CreateModelVersionOutput`](crate::output::CreateModelVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_id: std::option::Option<std::string::String>,
        pub(crate) model_type: std::option::Option<crate::model::ModelTypeEnum>,
        pub(crate) model_version_number: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The model ID.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_id = Some(input.into());
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_id = input;
            self
        }
        /// <p>The model type.</p>
        pub fn model_type(mut self, input: crate::model::ModelTypeEnum) -> Self {
            self.model_type = Some(input);
            self
        }
        /// <p>The model type.</p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.model_type = input;
            self
        }
        /// <p>The model version number of the model version created.</p>
        pub fn model_version_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_version_number = Some(input.into());
            self
        }
        /// <p>The model version number of the model version created.</p>
        pub fn set_model_version_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_version_number = input;
            self
        }
        /// <p>The model version status. </p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The model version status. </p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateModelVersionOutput`](crate::output::CreateModelVersionOutput)
        pub fn build(self) -> crate::output::CreateModelVersionOutput {
            crate::output::CreateModelVersionOutput {
                model_id: self.model_id,
                model_type: self.model_type,
                model_version_number: self.model_version_number,
                status: self.status,
            }
        }
    }
}
impl CreateModelVersionOutput {
    /// Creates a new builder-style object to manufacture [`CreateModelVersionOutput`](crate::output::CreateModelVersionOutput)
    pub fn builder() -> crate::output::create_model_version_output::Builder {
        crate::output::create_model_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateModelOutput {}
impl std::fmt::Debug for CreateModelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateModelOutput");
        formatter.finish()
    }
}
/// See [`CreateModelOutput`](crate::output::CreateModelOutput)
pub mod create_model_output {
    /// A builder for [`CreateModelOutput`](crate::output::CreateModelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateModelOutput`](crate::output::CreateModelOutput)
        pub fn build(self) -> crate::output::CreateModelOutput {
            crate::output::CreateModelOutput {}
        }
    }
}
impl CreateModelOutput {
    /// Creates a new builder-style object to manufacture [`CreateModelOutput`](crate::output::CreateModelOutput)
    pub fn builder() -> crate::output::create_model_output::Builder {
        crate::output::create_model_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDetectorVersionOutput {
    /// <p>The ID for the created version's parent detector.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The ID for the created detector. </p>
    pub detector_version_id: std::option::Option<std::string::String>,
    /// <p>The status of the detector version.</p>
    pub status: std::option::Option<crate::model::DetectorVersionStatus>,
}
impl CreateDetectorVersionOutput {
    /// <p>The ID for the created version's parent detector.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>The ID for the created detector. </p>
    pub fn detector_version_id(&self) -> std::option::Option<&str> {
        self.detector_version_id.as_deref()
    }
    /// <p>The status of the detector version.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::DetectorVersionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for CreateDetectorVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDetectorVersionOutput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("detector_version_id", &self.detector_version_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`CreateDetectorVersionOutput`](crate::output::CreateDetectorVersionOutput)
pub mod create_detector_version_output {
    /// A builder for [`CreateDetectorVersionOutput`](crate::output::CreateDetectorVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) detector_version_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::DetectorVersionStatus>,
    }
    impl Builder {
        /// <p>The ID for the created version's parent detector.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The ID for the created version's parent detector.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The ID for the created detector. </p>
        pub fn detector_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_version_id = Some(input.into());
            self
        }
        /// <p>The ID for the created detector. </p>
        pub fn set_detector_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_version_id = input;
            self
        }
        /// <p>The status of the detector version.</p>
        pub fn status(mut self, input: crate::model::DetectorVersionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the detector version.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DetectorVersionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDetectorVersionOutput`](crate::output::CreateDetectorVersionOutput)
        pub fn build(self) -> crate::output::CreateDetectorVersionOutput {
            crate::output::CreateDetectorVersionOutput {
                detector_id: self.detector_id,
                detector_version_id: self.detector_version_id,
                status: self.status,
            }
        }
    }
}
impl CreateDetectorVersionOutput {
    /// Creates a new builder-style object to manufacture [`CreateDetectorVersionOutput`](crate::output::CreateDetectorVersionOutput)
    pub fn builder() -> crate::output::create_detector_version_output::Builder {
        crate::output::create_detector_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBatchPredictionJobOutput {}
impl std::fmt::Debug for CreateBatchPredictionJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBatchPredictionJobOutput");
        formatter.finish()
    }
}
/// See [`CreateBatchPredictionJobOutput`](crate::output::CreateBatchPredictionJobOutput)
pub mod create_batch_prediction_job_output {
    /// A builder for [`CreateBatchPredictionJobOutput`](crate::output::CreateBatchPredictionJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateBatchPredictionJobOutput`](crate::output::CreateBatchPredictionJobOutput)
        pub fn build(self) -> crate::output::CreateBatchPredictionJobOutput {
            crate::output::CreateBatchPredictionJobOutput {}
        }
    }
}
impl CreateBatchPredictionJobOutput {
    /// Creates a new builder-style object to manufacture [`CreateBatchPredictionJobOutput`](crate::output::CreateBatchPredictionJobOutput)
    pub fn builder() -> crate::output::create_batch_prediction_job_output::Builder {
        crate::output::create_batch_prediction_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBatchImportJobOutput {}
impl std::fmt::Debug for CreateBatchImportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBatchImportJobOutput");
        formatter.finish()
    }
}
/// See [`CreateBatchImportJobOutput`](crate::output::CreateBatchImportJobOutput)
pub mod create_batch_import_job_output {
    /// A builder for [`CreateBatchImportJobOutput`](crate::output::CreateBatchImportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateBatchImportJobOutput`](crate::output::CreateBatchImportJobOutput)
        pub fn build(self) -> crate::output::CreateBatchImportJobOutput {
            crate::output::CreateBatchImportJobOutput {}
        }
    }
}
impl CreateBatchImportJobOutput {
    /// Creates a new builder-style object to manufacture [`CreateBatchImportJobOutput`](crate::output::CreateBatchImportJobOutput)
    pub fn builder() -> crate::output::create_batch_import_job_output::Builder {
        crate::output::create_batch_import_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelBatchPredictionJobOutput {}
impl std::fmt::Debug for CancelBatchPredictionJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelBatchPredictionJobOutput");
        formatter.finish()
    }
}
/// See [`CancelBatchPredictionJobOutput`](crate::output::CancelBatchPredictionJobOutput)
pub mod cancel_batch_prediction_job_output {
    /// A builder for [`CancelBatchPredictionJobOutput`](crate::output::CancelBatchPredictionJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CancelBatchPredictionJobOutput`](crate::output::CancelBatchPredictionJobOutput)
        pub fn build(self) -> crate::output::CancelBatchPredictionJobOutput {
            crate::output::CancelBatchPredictionJobOutput {}
        }
    }
}
impl CancelBatchPredictionJobOutput {
    /// Creates a new builder-style object to manufacture [`CancelBatchPredictionJobOutput`](crate::output::CancelBatchPredictionJobOutput)
    pub fn builder() -> crate::output::cancel_batch_prediction_job_output::Builder {
        crate::output::cancel_batch_prediction_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelBatchImportJobOutput {}
impl std::fmt::Debug for CancelBatchImportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelBatchImportJobOutput");
        formatter.finish()
    }
}
/// See [`CancelBatchImportJobOutput`](crate::output::CancelBatchImportJobOutput)
pub mod cancel_batch_import_job_output {
    /// A builder for [`CancelBatchImportJobOutput`](crate::output::CancelBatchImportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CancelBatchImportJobOutput`](crate::output::CancelBatchImportJobOutput)
        pub fn build(self) -> crate::output::CancelBatchImportJobOutput {
            crate::output::CancelBatchImportJobOutput {}
        }
    }
}
impl CancelBatchImportJobOutput {
    /// Creates a new builder-style object to manufacture [`CancelBatchImportJobOutput`](crate::output::CancelBatchImportJobOutput)
    pub fn builder() -> crate::output::cancel_batch_import_job_output::Builder {
        crate::output::cancel_batch_import_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetVariableOutput {
    /// <p>The returned variables.</p>
    pub variables: std::option::Option<std::vec::Vec<crate::model::Variable>>,
    /// <p>The errors from the request.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::BatchGetVariableError>>,
}
impl BatchGetVariableOutput {
    /// <p>The returned variables.</p>
    pub fn variables(&self) -> std::option::Option<&[crate::model::Variable]> {
        self.variables.as_deref()
    }
    /// <p>The errors from the request.</p>
    pub fn errors(&self) -> std::option::Option<&[crate::model::BatchGetVariableError]> {
        self.errors.as_deref()
    }
}
impl std::fmt::Debug for BatchGetVariableOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetVariableOutput");
        formatter.field("variables", &self.variables);
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchGetVariableOutput`](crate::output::BatchGetVariableOutput)
pub mod batch_get_variable_output {
    /// A builder for [`BatchGetVariableOutput`](crate::output::BatchGetVariableOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) variables: std::option::Option<std::vec::Vec<crate::model::Variable>>,
        pub(crate) errors: std::option::Option<std::vec::Vec<crate::model::BatchGetVariableError>>,
    }
    impl Builder {
        /// Appends an item to `variables`.
        ///
        /// To override the contents of this collection use [`set_variables`](Self::set_variables).
        ///
        /// <p>The returned variables.</p>
        pub fn variables(mut self, input: crate::model::Variable) -> Self {
            let mut v = self.variables.unwrap_or_default();
            v.push(input);
            self.variables = Some(v);
            self
        }
        /// <p>The returned variables.</p>
        pub fn set_variables(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Variable>>,
        ) -> Self {
            self.variables = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>The errors from the request.</p>
        pub fn errors(mut self, input: crate::model::BatchGetVariableError) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input);
            self.errors = Some(v);
            self
        }
        /// <p>The errors from the request.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchGetVariableError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetVariableOutput`](crate::output::BatchGetVariableOutput)
        pub fn build(self) -> crate::output::BatchGetVariableOutput {
            crate::output::BatchGetVariableOutput {
                variables: self.variables,
                errors: self.errors,
            }
        }
    }
}
impl BatchGetVariableOutput {
    /// Creates a new builder-style object to manufacture [`BatchGetVariableOutput`](crate::output::BatchGetVariableOutput)
    pub fn builder() -> crate::output::batch_get_variable_output::Builder {
        crate::output::batch_get_variable_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchCreateVariableOutput {
    /// <p>Provides the errors for the <code>BatchCreateVariable</code> request.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::BatchCreateVariableError>>,
}
impl BatchCreateVariableOutput {
    /// <p>Provides the errors for the <code>BatchCreateVariable</code> request.</p>
    pub fn errors(&self) -> std::option::Option<&[crate::model::BatchCreateVariableError]> {
        self.errors.as_deref()
    }
}
impl std::fmt::Debug for BatchCreateVariableOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchCreateVariableOutput");
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchCreateVariableOutput`](crate::output::BatchCreateVariableOutput)
pub mod batch_create_variable_output {
    /// A builder for [`BatchCreateVariableOutput`](crate::output::BatchCreateVariableOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) errors:
            std::option::Option<std::vec::Vec<crate::model::BatchCreateVariableError>>,
    }
    impl Builder {
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>Provides the errors for the <code>BatchCreateVariable</code> request.</p>
        pub fn errors(mut self, input: crate::model::BatchCreateVariableError) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input);
            self.errors = Some(v);
            self
        }
        /// <p>Provides the errors for the <code>BatchCreateVariable</code> request.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchCreateVariableError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchCreateVariableOutput`](crate::output::BatchCreateVariableOutput)
        pub fn build(self) -> crate::output::BatchCreateVariableOutput {
            crate::output::BatchCreateVariableOutput {
                errors: self.errors,
            }
        }
    }
}
impl BatchCreateVariableOutput {
    /// Creates a new builder-style object to manufacture [`BatchCreateVariableOutput`](crate::output::BatchCreateVariableOutput)
    pub fn builder() -> crate::output::batch_create_variable_output::Builder {
        crate::output::batch_create_variable_output::Builder::default()
    }
}
