// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `BatchCreateVariable`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_create_variable`](crate::client::Client::batch_create_variable).
///
/// See [`crate::client::fluent_builders::BatchCreateVariable`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchCreateVariable {
    _private: (),
}
impl BatchCreateVariable {
    /// Creates a new builder-style object to manufacture [`BatchCreateVariableInput`](crate::input::BatchCreateVariableInput)
    pub fn builder() -> crate::input::batch_create_variable_input::Builder {
        crate::input::batch_create_variable_input::Builder::default()
    }
    /// Creates a new `BatchCreateVariable` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchCreateVariable {
    type Output = std::result::Result<
        crate::output::BatchCreateVariableOutput,
        crate::error::BatchCreateVariableError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_create_variable_error(response)
        } else {
            crate::operation_deser::parse_batch_create_variable_response(response)
        }
    }
}

/// Operation shape for `BatchGetVariable`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_get_variable`](crate::client::Client::batch_get_variable).
///
/// See [`crate::client::fluent_builders::BatchGetVariable`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchGetVariable {
    _private: (),
}
impl BatchGetVariable {
    /// Creates a new builder-style object to manufacture [`BatchGetVariableInput`](crate::input::BatchGetVariableInput)
    pub fn builder() -> crate::input::batch_get_variable_input::Builder {
        crate::input::batch_get_variable_input::Builder::default()
    }
    /// Creates a new `BatchGetVariable` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchGetVariable {
    type Output = std::result::Result<
        crate::output::BatchGetVariableOutput,
        crate::error::BatchGetVariableError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_get_variable_error(response)
        } else {
            crate::operation_deser::parse_batch_get_variable_response(response)
        }
    }
}

/// Operation shape for `CancelBatchImportJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_batch_import_job`](crate::client::Client::cancel_batch_import_job).
///
/// See [`crate::client::fluent_builders::CancelBatchImportJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelBatchImportJob {
    _private: (),
}
impl CancelBatchImportJob {
    /// Creates a new builder-style object to manufacture [`CancelBatchImportJobInput`](crate::input::CancelBatchImportJobInput)
    pub fn builder() -> crate::input::cancel_batch_import_job_input::Builder {
        crate::input::cancel_batch_import_job_input::Builder::default()
    }
    /// Creates a new `CancelBatchImportJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelBatchImportJob {
    type Output = std::result::Result<
        crate::output::CancelBatchImportJobOutput,
        crate::error::CancelBatchImportJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_batch_import_job_error(response)
        } else {
            crate::operation_deser::parse_cancel_batch_import_job_response(response)
        }
    }
}

/// Operation shape for `CancelBatchPredictionJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_batch_prediction_job`](crate::client::Client::cancel_batch_prediction_job).
///
/// See [`crate::client::fluent_builders::CancelBatchPredictionJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelBatchPredictionJob {
    _private: (),
}
impl CancelBatchPredictionJob {
    /// Creates a new builder-style object to manufacture [`CancelBatchPredictionJobInput`](crate::input::CancelBatchPredictionJobInput)
    pub fn builder() -> crate::input::cancel_batch_prediction_job_input::Builder {
        crate::input::cancel_batch_prediction_job_input::Builder::default()
    }
    /// Creates a new `CancelBatchPredictionJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelBatchPredictionJob {
    type Output = std::result::Result<
        crate::output::CancelBatchPredictionJobOutput,
        crate::error::CancelBatchPredictionJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_batch_prediction_job_error(response)
        } else {
            crate::operation_deser::parse_cancel_batch_prediction_job_response(response)
        }
    }
}

/// Operation shape for `CreateBatchImportJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_batch_import_job`](crate::client::Client::create_batch_import_job).
///
/// See [`crate::client::fluent_builders::CreateBatchImportJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateBatchImportJob {
    _private: (),
}
impl CreateBatchImportJob {
    /// Creates a new builder-style object to manufacture [`CreateBatchImportJobInput`](crate::input::CreateBatchImportJobInput)
    pub fn builder() -> crate::input::create_batch_import_job_input::Builder {
        crate::input::create_batch_import_job_input::Builder::default()
    }
    /// Creates a new `CreateBatchImportJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateBatchImportJob {
    type Output = std::result::Result<
        crate::output::CreateBatchImportJobOutput,
        crate::error::CreateBatchImportJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_batch_import_job_error(response)
        } else {
            crate::operation_deser::parse_create_batch_import_job_response(response)
        }
    }
}

/// Operation shape for `CreateBatchPredictionJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_batch_prediction_job`](crate::client::Client::create_batch_prediction_job).
///
/// See [`crate::client::fluent_builders::CreateBatchPredictionJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateBatchPredictionJob {
    _private: (),
}
impl CreateBatchPredictionJob {
    /// Creates a new builder-style object to manufacture [`CreateBatchPredictionJobInput`](crate::input::CreateBatchPredictionJobInput)
    pub fn builder() -> crate::input::create_batch_prediction_job_input::Builder {
        crate::input::create_batch_prediction_job_input::Builder::default()
    }
    /// Creates a new `CreateBatchPredictionJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateBatchPredictionJob {
    type Output = std::result::Result<
        crate::output::CreateBatchPredictionJobOutput,
        crate::error::CreateBatchPredictionJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_batch_prediction_job_error(response)
        } else {
            crate::operation_deser::parse_create_batch_prediction_job_response(response)
        }
    }
}

/// Operation shape for `CreateDetectorVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_detector_version`](crate::client::Client::create_detector_version).
///
/// See [`crate::client::fluent_builders::CreateDetectorVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDetectorVersion {
    _private: (),
}
impl CreateDetectorVersion {
    /// Creates a new builder-style object to manufacture [`CreateDetectorVersionInput`](crate::input::CreateDetectorVersionInput)
    pub fn builder() -> crate::input::create_detector_version_input::Builder {
        crate::input::create_detector_version_input::Builder::default()
    }
    /// Creates a new `CreateDetectorVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDetectorVersion {
    type Output = std::result::Result<
        crate::output::CreateDetectorVersionOutput,
        crate::error::CreateDetectorVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_detector_version_error(response)
        } else {
            crate::operation_deser::parse_create_detector_version_response(response)
        }
    }
}

/// Operation shape for `CreateModel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_model`](crate::client::Client::create_model).
///
/// See [`crate::client::fluent_builders::CreateModel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateModel {
    _private: (),
}
impl CreateModel {
    /// Creates a new builder-style object to manufacture [`CreateModelInput`](crate::input::CreateModelInput)
    pub fn builder() -> crate::input::create_model_input::Builder {
        crate::input::create_model_input::Builder::default()
    }
    /// Creates a new `CreateModel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateModel {
    type Output =
        std::result::Result<crate::output::CreateModelOutput, crate::error::CreateModelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_model_error(response)
        } else {
            crate::operation_deser::parse_create_model_response(response)
        }
    }
}

/// Operation shape for `CreateModelVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_model_version`](crate::client::Client::create_model_version).
///
/// See [`crate::client::fluent_builders::CreateModelVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateModelVersion {
    _private: (),
}
impl CreateModelVersion {
    /// Creates a new builder-style object to manufacture [`CreateModelVersionInput`](crate::input::CreateModelVersionInput)
    pub fn builder() -> crate::input::create_model_version_input::Builder {
        crate::input::create_model_version_input::Builder::default()
    }
    /// Creates a new `CreateModelVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateModelVersion {
    type Output = std::result::Result<
        crate::output::CreateModelVersionOutput,
        crate::error::CreateModelVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_model_version_error(response)
        } else {
            crate::operation_deser::parse_create_model_version_response(response)
        }
    }
}

/// Operation shape for `CreateRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_rule`](crate::client::Client::create_rule).
///
/// See [`crate::client::fluent_builders::CreateRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRule {
    _private: (),
}
impl CreateRule {
    /// Creates a new builder-style object to manufacture [`CreateRuleInput`](crate::input::CreateRuleInput)
    pub fn builder() -> crate::input::create_rule_input::Builder {
        crate::input::create_rule_input::Builder::default()
    }
    /// Creates a new `CreateRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRule {
    type Output =
        std::result::Result<crate::output::CreateRuleOutput, crate::error::CreateRuleError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_rule_error(response)
        } else {
            crate::operation_deser::parse_create_rule_response(response)
        }
    }
}

/// Operation shape for `CreateVariable`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_variable`](crate::client::Client::create_variable).
///
/// See [`crate::client::fluent_builders::CreateVariable`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateVariable {
    _private: (),
}
impl CreateVariable {
    /// Creates a new builder-style object to manufacture [`CreateVariableInput`](crate::input::CreateVariableInput)
    pub fn builder() -> crate::input::create_variable_input::Builder {
        crate::input::create_variable_input::Builder::default()
    }
    /// Creates a new `CreateVariable` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateVariable {
    type Output =
        std::result::Result<crate::output::CreateVariableOutput, crate::error::CreateVariableError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_variable_error(response)
        } else {
            crate::operation_deser::parse_create_variable_response(response)
        }
    }
}

/// Operation shape for `DeleteBatchImportJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_batch_import_job`](crate::client::Client::delete_batch_import_job).
///
/// See [`crate::client::fluent_builders::DeleteBatchImportJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBatchImportJob {
    _private: (),
}
impl DeleteBatchImportJob {
    /// Creates a new builder-style object to manufacture [`DeleteBatchImportJobInput`](crate::input::DeleteBatchImportJobInput)
    pub fn builder() -> crate::input::delete_batch_import_job_input::Builder {
        crate::input::delete_batch_import_job_input::Builder::default()
    }
    /// Creates a new `DeleteBatchImportJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBatchImportJob {
    type Output = std::result::Result<
        crate::output::DeleteBatchImportJobOutput,
        crate::error::DeleteBatchImportJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_batch_import_job_error(response)
        } else {
            crate::operation_deser::parse_delete_batch_import_job_response(response)
        }
    }
}

/// Operation shape for `DeleteBatchPredictionJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_batch_prediction_job`](crate::client::Client::delete_batch_prediction_job).
///
/// See [`crate::client::fluent_builders::DeleteBatchPredictionJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBatchPredictionJob {
    _private: (),
}
impl DeleteBatchPredictionJob {
    /// Creates a new builder-style object to manufacture [`DeleteBatchPredictionJobInput`](crate::input::DeleteBatchPredictionJobInput)
    pub fn builder() -> crate::input::delete_batch_prediction_job_input::Builder {
        crate::input::delete_batch_prediction_job_input::Builder::default()
    }
    /// Creates a new `DeleteBatchPredictionJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBatchPredictionJob {
    type Output = std::result::Result<
        crate::output::DeleteBatchPredictionJobOutput,
        crate::error::DeleteBatchPredictionJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_batch_prediction_job_error(response)
        } else {
            crate::operation_deser::parse_delete_batch_prediction_job_response(response)
        }
    }
}

/// Operation shape for `DeleteDetector`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_detector`](crate::client::Client::delete_detector).
///
/// See [`crate::client::fluent_builders::DeleteDetector`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDetector {
    _private: (),
}
impl DeleteDetector {
    /// Creates a new builder-style object to manufacture [`DeleteDetectorInput`](crate::input::DeleteDetectorInput)
    pub fn builder() -> crate::input::delete_detector_input::Builder {
        crate::input::delete_detector_input::Builder::default()
    }
    /// Creates a new `DeleteDetector` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDetector {
    type Output =
        std::result::Result<crate::output::DeleteDetectorOutput, crate::error::DeleteDetectorError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_detector_error(response)
        } else {
            crate::operation_deser::parse_delete_detector_response(response)
        }
    }
}

/// Operation shape for `DeleteDetectorVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_detector_version`](crate::client::Client::delete_detector_version).
///
/// See [`crate::client::fluent_builders::DeleteDetectorVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDetectorVersion {
    _private: (),
}
impl DeleteDetectorVersion {
    /// Creates a new builder-style object to manufacture [`DeleteDetectorVersionInput`](crate::input::DeleteDetectorVersionInput)
    pub fn builder() -> crate::input::delete_detector_version_input::Builder {
        crate::input::delete_detector_version_input::Builder::default()
    }
    /// Creates a new `DeleteDetectorVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDetectorVersion {
    type Output = std::result::Result<
        crate::output::DeleteDetectorVersionOutput,
        crate::error::DeleteDetectorVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_detector_version_error(response)
        } else {
            crate::operation_deser::parse_delete_detector_version_response(response)
        }
    }
}

/// Operation shape for `DeleteEntityType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_entity_type`](crate::client::Client::delete_entity_type).
///
/// See [`crate::client::fluent_builders::DeleteEntityType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEntityType {
    _private: (),
}
impl DeleteEntityType {
    /// Creates a new builder-style object to manufacture [`DeleteEntityTypeInput`](crate::input::DeleteEntityTypeInput)
    pub fn builder() -> crate::input::delete_entity_type_input::Builder {
        crate::input::delete_entity_type_input::Builder::default()
    }
    /// Creates a new `DeleteEntityType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEntityType {
    type Output = std::result::Result<
        crate::output::DeleteEntityTypeOutput,
        crate::error::DeleteEntityTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_entity_type_error(response)
        } else {
            crate::operation_deser::parse_delete_entity_type_response(response)
        }
    }
}

/// Operation shape for `DeleteEvent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_event`](crate::client::Client::delete_event).
///
/// See [`crate::client::fluent_builders::DeleteEvent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEvent {
    _private: (),
}
impl DeleteEvent {
    /// Creates a new builder-style object to manufacture [`DeleteEventInput`](crate::input::DeleteEventInput)
    pub fn builder() -> crate::input::delete_event_input::Builder {
        crate::input::delete_event_input::Builder::default()
    }
    /// Creates a new `DeleteEvent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEvent {
    type Output =
        std::result::Result<crate::output::DeleteEventOutput, crate::error::DeleteEventError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_event_error(response)
        } else {
            crate::operation_deser::parse_delete_event_response(response)
        }
    }
}

/// Operation shape for `DeleteEventsByEventType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_events_by_event_type`](crate::client::Client::delete_events_by_event_type).
///
/// See [`crate::client::fluent_builders::DeleteEventsByEventType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEventsByEventType {
    _private: (),
}
impl DeleteEventsByEventType {
    /// Creates a new builder-style object to manufacture [`DeleteEventsByEventTypeInput`](crate::input::DeleteEventsByEventTypeInput)
    pub fn builder() -> crate::input::delete_events_by_event_type_input::Builder {
        crate::input::delete_events_by_event_type_input::Builder::default()
    }
    /// Creates a new `DeleteEventsByEventType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEventsByEventType {
    type Output = std::result::Result<
        crate::output::DeleteEventsByEventTypeOutput,
        crate::error::DeleteEventsByEventTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_events_by_event_type_error(response)
        } else {
            crate::operation_deser::parse_delete_events_by_event_type_response(response)
        }
    }
}

/// Operation shape for `DeleteEventType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_event_type`](crate::client::Client::delete_event_type).
///
/// See [`crate::client::fluent_builders::DeleteEventType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEventType {
    _private: (),
}
impl DeleteEventType {
    /// Creates a new builder-style object to manufacture [`DeleteEventTypeInput`](crate::input::DeleteEventTypeInput)
    pub fn builder() -> crate::input::delete_event_type_input::Builder {
        crate::input::delete_event_type_input::Builder::default()
    }
    /// Creates a new `DeleteEventType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEventType {
    type Output = std::result::Result<
        crate::output::DeleteEventTypeOutput,
        crate::error::DeleteEventTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_event_type_error(response)
        } else {
            crate::operation_deser::parse_delete_event_type_response(response)
        }
    }
}

/// Operation shape for `DeleteExternalModel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_external_model`](crate::client::Client::delete_external_model).
///
/// See [`crate::client::fluent_builders::DeleteExternalModel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteExternalModel {
    _private: (),
}
impl DeleteExternalModel {
    /// Creates a new builder-style object to manufacture [`DeleteExternalModelInput`](crate::input::DeleteExternalModelInput)
    pub fn builder() -> crate::input::delete_external_model_input::Builder {
        crate::input::delete_external_model_input::Builder::default()
    }
    /// Creates a new `DeleteExternalModel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteExternalModel {
    type Output = std::result::Result<
        crate::output::DeleteExternalModelOutput,
        crate::error::DeleteExternalModelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_external_model_error(response)
        } else {
            crate::operation_deser::parse_delete_external_model_response(response)
        }
    }
}

/// Operation shape for `DeleteLabel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_label`](crate::client::Client::delete_label).
///
/// See [`crate::client::fluent_builders::DeleteLabel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLabel {
    _private: (),
}
impl DeleteLabel {
    /// Creates a new builder-style object to manufacture [`DeleteLabelInput`](crate::input::DeleteLabelInput)
    pub fn builder() -> crate::input::delete_label_input::Builder {
        crate::input::delete_label_input::Builder::default()
    }
    /// Creates a new `DeleteLabel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLabel {
    type Output =
        std::result::Result<crate::output::DeleteLabelOutput, crate::error::DeleteLabelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_label_error(response)
        } else {
            crate::operation_deser::parse_delete_label_response(response)
        }
    }
}

/// Operation shape for `DeleteModel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_model`](crate::client::Client::delete_model).
///
/// See [`crate::client::fluent_builders::DeleteModel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteModel {
    _private: (),
}
impl DeleteModel {
    /// Creates a new builder-style object to manufacture [`DeleteModelInput`](crate::input::DeleteModelInput)
    pub fn builder() -> crate::input::delete_model_input::Builder {
        crate::input::delete_model_input::Builder::default()
    }
    /// Creates a new `DeleteModel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteModel {
    type Output =
        std::result::Result<crate::output::DeleteModelOutput, crate::error::DeleteModelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_model_error(response)
        } else {
            crate::operation_deser::parse_delete_model_response(response)
        }
    }
}

/// Operation shape for `DeleteModelVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_model_version`](crate::client::Client::delete_model_version).
///
/// See [`crate::client::fluent_builders::DeleteModelVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteModelVersion {
    _private: (),
}
impl DeleteModelVersion {
    /// Creates a new builder-style object to manufacture [`DeleteModelVersionInput`](crate::input::DeleteModelVersionInput)
    pub fn builder() -> crate::input::delete_model_version_input::Builder {
        crate::input::delete_model_version_input::Builder::default()
    }
    /// Creates a new `DeleteModelVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteModelVersion {
    type Output = std::result::Result<
        crate::output::DeleteModelVersionOutput,
        crate::error::DeleteModelVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_model_version_error(response)
        } else {
            crate::operation_deser::parse_delete_model_version_response(response)
        }
    }
}

/// Operation shape for `DeleteOutcome`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_outcome`](crate::client::Client::delete_outcome).
///
/// See [`crate::client::fluent_builders::DeleteOutcome`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteOutcome {
    _private: (),
}
impl DeleteOutcome {
    /// Creates a new builder-style object to manufacture [`DeleteOutcomeInput`](crate::input::DeleteOutcomeInput)
    pub fn builder() -> crate::input::delete_outcome_input::Builder {
        crate::input::delete_outcome_input::Builder::default()
    }
    /// Creates a new `DeleteOutcome` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteOutcome {
    type Output =
        std::result::Result<crate::output::DeleteOutcomeOutput, crate::error::DeleteOutcomeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_outcome_error(response)
        } else {
            crate::operation_deser::parse_delete_outcome_response(response)
        }
    }
}

/// Operation shape for `DeleteRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_rule`](crate::client::Client::delete_rule).
///
/// See [`crate::client::fluent_builders::DeleteRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRule {
    _private: (),
}
impl DeleteRule {
    /// Creates a new builder-style object to manufacture [`DeleteRuleInput`](crate::input::DeleteRuleInput)
    pub fn builder() -> crate::input::delete_rule_input::Builder {
        crate::input::delete_rule_input::Builder::default()
    }
    /// Creates a new `DeleteRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRule {
    type Output =
        std::result::Result<crate::output::DeleteRuleOutput, crate::error::DeleteRuleError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_rule_error(response)
        } else {
            crate::operation_deser::parse_delete_rule_response(response)
        }
    }
}

/// Operation shape for `DeleteVariable`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_variable`](crate::client::Client::delete_variable).
///
/// See [`crate::client::fluent_builders::DeleteVariable`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVariable {
    _private: (),
}
impl DeleteVariable {
    /// Creates a new builder-style object to manufacture [`DeleteVariableInput`](crate::input::DeleteVariableInput)
    pub fn builder() -> crate::input::delete_variable_input::Builder {
        crate::input::delete_variable_input::Builder::default()
    }
    /// Creates a new `DeleteVariable` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVariable {
    type Output =
        std::result::Result<crate::output::DeleteVariableOutput, crate::error::DeleteVariableError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_variable_error(response)
        } else {
            crate::operation_deser::parse_delete_variable_response(response)
        }
    }
}

/// Operation shape for `DescribeDetector`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_detector`](crate::client::Client::describe_detector).
///
/// See [`crate::client::fluent_builders::DescribeDetector`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDetector {
    _private: (),
}
impl DescribeDetector {
    /// Creates a new builder-style object to manufacture [`DescribeDetectorInput`](crate::input::DescribeDetectorInput)
    pub fn builder() -> crate::input::describe_detector_input::Builder {
        crate::input::describe_detector_input::Builder::default()
    }
    /// Creates a new `DescribeDetector` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDetector {
    type Output = std::result::Result<
        crate::output::DescribeDetectorOutput,
        crate::error::DescribeDetectorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_detector_error(response)
        } else {
            crate::operation_deser::parse_describe_detector_response(response)
        }
    }
}

/// Operation shape for `DescribeModelVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_model_versions`](crate::client::Client::describe_model_versions).
///
/// See [`crate::client::fluent_builders::DescribeModelVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeModelVersions {
    _private: (),
}
impl DescribeModelVersions {
    /// Creates a new builder-style object to manufacture [`DescribeModelVersionsInput`](crate::input::DescribeModelVersionsInput)
    pub fn builder() -> crate::input::describe_model_versions_input::Builder {
        crate::input::describe_model_versions_input::Builder::default()
    }
    /// Creates a new `DescribeModelVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeModelVersions {
    type Output = std::result::Result<
        crate::output::DescribeModelVersionsOutput,
        crate::error::DescribeModelVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_model_versions_error(response)
        } else {
            crate::operation_deser::parse_describe_model_versions_response(response)
        }
    }
}

/// Operation shape for `GetBatchImportJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_batch_import_jobs`](crate::client::Client::get_batch_import_jobs).
///
/// See [`crate::client::fluent_builders::GetBatchImportJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBatchImportJobs {
    _private: (),
}
impl GetBatchImportJobs {
    /// Creates a new builder-style object to manufacture [`GetBatchImportJobsInput`](crate::input::GetBatchImportJobsInput)
    pub fn builder() -> crate::input::get_batch_import_jobs_input::Builder {
        crate::input::get_batch_import_jobs_input::Builder::default()
    }
    /// Creates a new `GetBatchImportJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBatchImportJobs {
    type Output = std::result::Result<
        crate::output::GetBatchImportJobsOutput,
        crate::error::GetBatchImportJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_batch_import_jobs_error(response)
        } else {
            crate::operation_deser::parse_get_batch_import_jobs_response(response)
        }
    }
}

/// Operation shape for `GetBatchPredictionJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_batch_prediction_jobs`](crate::client::Client::get_batch_prediction_jobs).
///
/// See [`crate::client::fluent_builders::GetBatchPredictionJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBatchPredictionJobs {
    _private: (),
}
impl GetBatchPredictionJobs {
    /// Creates a new builder-style object to manufacture [`GetBatchPredictionJobsInput`](crate::input::GetBatchPredictionJobsInput)
    pub fn builder() -> crate::input::get_batch_prediction_jobs_input::Builder {
        crate::input::get_batch_prediction_jobs_input::Builder::default()
    }
    /// Creates a new `GetBatchPredictionJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBatchPredictionJobs {
    type Output = std::result::Result<
        crate::output::GetBatchPredictionJobsOutput,
        crate::error::GetBatchPredictionJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_batch_prediction_jobs_error(response)
        } else {
            crate::operation_deser::parse_get_batch_prediction_jobs_response(response)
        }
    }
}

/// Operation shape for `GetDeleteEventsByEventTypeStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_delete_events_by_event_type_status`](crate::client::Client::get_delete_events_by_event_type_status).
///
/// See [`crate::client::fluent_builders::GetDeleteEventsByEventTypeStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDeleteEventsByEventTypeStatus {
    _private: (),
}
impl GetDeleteEventsByEventTypeStatus {
    /// Creates a new builder-style object to manufacture [`GetDeleteEventsByEventTypeStatusInput`](crate::input::GetDeleteEventsByEventTypeStatusInput)
    pub fn builder() -> crate::input::get_delete_events_by_event_type_status_input::Builder {
        crate::input::get_delete_events_by_event_type_status_input::Builder::default()
    }
    /// Creates a new `GetDeleteEventsByEventTypeStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDeleteEventsByEventTypeStatus {
    type Output = std::result::Result<
        crate::output::GetDeleteEventsByEventTypeStatusOutput,
        crate::error::GetDeleteEventsByEventTypeStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_delete_events_by_event_type_status_error(response)
        } else {
            crate::operation_deser::parse_get_delete_events_by_event_type_status_response(response)
        }
    }
}

/// Operation shape for `GetDetectors`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_detectors`](crate::client::Client::get_detectors).
///
/// See [`crate::client::fluent_builders::GetDetectors`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDetectors {
    _private: (),
}
impl GetDetectors {
    /// Creates a new builder-style object to manufacture [`GetDetectorsInput`](crate::input::GetDetectorsInput)
    pub fn builder() -> crate::input::get_detectors_input::Builder {
        crate::input::get_detectors_input::Builder::default()
    }
    /// Creates a new `GetDetectors` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDetectors {
    type Output =
        std::result::Result<crate::output::GetDetectorsOutput, crate::error::GetDetectorsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_detectors_error(response)
        } else {
            crate::operation_deser::parse_get_detectors_response(response)
        }
    }
}

/// Operation shape for `GetDetectorVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_detector_version`](crate::client::Client::get_detector_version).
///
/// See [`crate::client::fluent_builders::GetDetectorVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDetectorVersion {
    _private: (),
}
impl GetDetectorVersion {
    /// Creates a new builder-style object to manufacture [`GetDetectorVersionInput`](crate::input::GetDetectorVersionInput)
    pub fn builder() -> crate::input::get_detector_version_input::Builder {
        crate::input::get_detector_version_input::Builder::default()
    }
    /// Creates a new `GetDetectorVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDetectorVersion {
    type Output = std::result::Result<
        crate::output::GetDetectorVersionOutput,
        crate::error::GetDetectorVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_detector_version_error(response)
        } else {
            crate::operation_deser::parse_get_detector_version_response(response)
        }
    }
}

/// Operation shape for `GetEntityTypes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_entity_types`](crate::client::Client::get_entity_types).
///
/// See [`crate::client::fluent_builders::GetEntityTypes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetEntityTypes {
    _private: (),
}
impl GetEntityTypes {
    /// Creates a new builder-style object to manufacture [`GetEntityTypesInput`](crate::input::GetEntityTypesInput)
    pub fn builder() -> crate::input::get_entity_types_input::Builder {
        crate::input::get_entity_types_input::Builder::default()
    }
    /// Creates a new `GetEntityTypes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetEntityTypes {
    type Output =
        std::result::Result<crate::output::GetEntityTypesOutput, crate::error::GetEntityTypesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_entity_types_error(response)
        } else {
            crate::operation_deser::parse_get_entity_types_response(response)
        }
    }
}

/// Operation shape for `GetEvent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_event`](crate::client::Client::get_event).
///
/// See [`crate::client::fluent_builders::GetEvent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetEvent {
    _private: (),
}
impl GetEvent {
    /// Creates a new builder-style object to manufacture [`GetEventInput`](crate::input::GetEventInput)
    pub fn builder() -> crate::input::get_event_input::Builder {
        crate::input::get_event_input::Builder::default()
    }
    /// Creates a new `GetEvent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetEvent {
    type Output = std::result::Result<crate::output::GetEventOutput, crate::error::GetEventError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_event_error(response)
        } else {
            crate::operation_deser::parse_get_event_response(response)
        }
    }
}

/// Operation shape for `GetEventPrediction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_event_prediction`](crate::client::Client::get_event_prediction).
///
/// See [`crate::client::fluent_builders::GetEventPrediction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetEventPrediction {
    _private: (),
}
impl GetEventPrediction {
    /// Creates a new builder-style object to manufacture [`GetEventPredictionInput`](crate::input::GetEventPredictionInput)
    pub fn builder() -> crate::input::get_event_prediction_input::Builder {
        crate::input::get_event_prediction_input::Builder::default()
    }
    /// Creates a new `GetEventPrediction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetEventPrediction {
    type Output = std::result::Result<
        crate::output::GetEventPredictionOutput,
        crate::error::GetEventPredictionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_event_prediction_error(response)
        } else {
            crate::operation_deser::parse_get_event_prediction_response(response)
        }
    }
}

/// Operation shape for `GetEventPredictionMetadata`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_event_prediction_metadata`](crate::client::Client::get_event_prediction_metadata).
///
/// See [`crate::client::fluent_builders::GetEventPredictionMetadata`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetEventPredictionMetadata {
    _private: (),
}
impl GetEventPredictionMetadata {
    /// Creates a new builder-style object to manufacture [`GetEventPredictionMetadataInput`](crate::input::GetEventPredictionMetadataInput)
    pub fn builder() -> crate::input::get_event_prediction_metadata_input::Builder {
        crate::input::get_event_prediction_metadata_input::Builder::default()
    }
    /// Creates a new `GetEventPredictionMetadata` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetEventPredictionMetadata {
    type Output = std::result::Result<
        crate::output::GetEventPredictionMetadataOutput,
        crate::error::GetEventPredictionMetadataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_event_prediction_metadata_error(response)
        } else {
            crate::operation_deser::parse_get_event_prediction_metadata_response(response)
        }
    }
}

/// Operation shape for `GetEventTypes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_event_types`](crate::client::Client::get_event_types).
///
/// See [`crate::client::fluent_builders::GetEventTypes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetEventTypes {
    _private: (),
}
impl GetEventTypes {
    /// Creates a new builder-style object to manufacture [`GetEventTypesInput`](crate::input::GetEventTypesInput)
    pub fn builder() -> crate::input::get_event_types_input::Builder {
        crate::input::get_event_types_input::Builder::default()
    }
    /// Creates a new `GetEventTypes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetEventTypes {
    type Output =
        std::result::Result<crate::output::GetEventTypesOutput, crate::error::GetEventTypesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_event_types_error(response)
        } else {
            crate::operation_deser::parse_get_event_types_response(response)
        }
    }
}

/// Operation shape for `GetExternalModels`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_external_models`](crate::client::Client::get_external_models).
///
/// See [`crate::client::fluent_builders::GetExternalModels`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetExternalModels {
    _private: (),
}
impl GetExternalModels {
    /// Creates a new builder-style object to manufacture [`GetExternalModelsInput`](crate::input::GetExternalModelsInput)
    pub fn builder() -> crate::input::get_external_models_input::Builder {
        crate::input::get_external_models_input::Builder::default()
    }
    /// Creates a new `GetExternalModels` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetExternalModels {
    type Output = std::result::Result<
        crate::output::GetExternalModelsOutput,
        crate::error::GetExternalModelsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_external_models_error(response)
        } else {
            crate::operation_deser::parse_get_external_models_response(response)
        }
    }
}

/// Operation shape for `GetKMSEncryptionKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_kms_encryption_key`](crate::client::Client::get_kms_encryption_key).
///
/// See [`crate::client::fluent_builders::GetKMSEncryptionKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetKMSEncryptionKey {
    _private: (),
}
impl GetKMSEncryptionKey {
    /// Creates a new builder-style object to manufacture [`GetKmsEncryptionKeyInput`](crate::input::GetKmsEncryptionKeyInput)
    pub fn builder() -> crate::input::get_kms_encryption_key_input::Builder {
        crate::input::get_kms_encryption_key_input::Builder::default()
    }
    /// Creates a new `GetKMSEncryptionKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetKMSEncryptionKey {
    type Output = std::result::Result<
        crate::output::GetKmsEncryptionKeyOutput,
        crate::error::GetKMSEncryptionKeyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_kms_encryption_key_error(response)
        } else {
            crate::operation_deser::parse_get_kms_encryption_key_response(response)
        }
    }
}

/// Operation shape for `GetLabels`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_labels`](crate::client::Client::get_labels).
///
/// See [`crate::client::fluent_builders::GetLabels`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLabels {
    _private: (),
}
impl GetLabels {
    /// Creates a new builder-style object to manufacture [`GetLabelsInput`](crate::input::GetLabelsInput)
    pub fn builder() -> crate::input::get_labels_input::Builder {
        crate::input::get_labels_input::Builder::default()
    }
    /// Creates a new `GetLabels` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLabels {
    type Output = std::result::Result<crate::output::GetLabelsOutput, crate::error::GetLabelsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_labels_error(response)
        } else {
            crate::operation_deser::parse_get_labels_response(response)
        }
    }
}

/// Operation shape for `GetModels`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_models`](crate::client::Client::get_models).
///
/// See [`crate::client::fluent_builders::GetModels`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetModels {
    _private: (),
}
impl GetModels {
    /// Creates a new builder-style object to manufacture [`GetModelsInput`](crate::input::GetModelsInput)
    pub fn builder() -> crate::input::get_models_input::Builder {
        crate::input::get_models_input::Builder::default()
    }
    /// Creates a new `GetModels` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetModels {
    type Output = std::result::Result<crate::output::GetModelsOutput, crate::error::GetModelsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_models_error(response)
        } else {
            crate::operation_deser::parse_get_models_response(response)
        }
    }
}

/// Operation shape for `GetModelVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_model_version`](crate::client::Client::get_model_version).
///
/// See [`crate::client::fluent_builders::GetModelVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetModelVersion {
    _private: (),
}
impl GetModelVersion {
    /// Creates a new builder-style object to manufacture [`GetModelVersionInput`](crate::input::GetModelVersionInput)
    pub fn builder() -> crate::input::get_model_version_input::Builder {
        crate::input::get_model_version_input::Builder::default()
    }
    /// Creates a new `GetModelVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetModelVersion {
    type Output = std::result::Result<
        crate::output::GetModelVersionOutput,
        crate::error::GetModelVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_model_version_error(response)
        } else {
            crate::operation_deser::parse_get_model_version_response(response)
        }
    }
}

/// Operation shape for `GetOutcomes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_outcomes`](crate::client::Client::get_outcomes).
///
/// See [`crate::client::fluent_builders::GetOutcomes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetOutcomes {
    _private: (),
}
impl GetOutcomes {
    /// Creates a new builder-style object to manufacture [`GetOutcomesInput`](crate::input::GetOutcomesInput)
    pub fn builder() -> crate::input::get_outcomes_input::Builder {
        crate::input::get_outcomes_input::Builder::default()
    }
    /// Creates a new `GetOutcomes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetOutcomes {
    type Output =
        std::result::Result<crate::output::GetOutcomesOutput, crate::error::GetOutcomesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_outcomes_error(response)
        } else {
            crate::operation_deser::parse_get_outcomes_response(response)
        }
    }
}

/// Operation shape for `GetRules`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_rules`](crate::client::Client::get_rules).
///
/// See [`crate::client::fluent_builders::GetRules`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRules {
    _private: (),
}
impl GetRules {
    /// Creates a new builder-style object to manufacture [`GetRulesInput`](crate::input::GetRulesInput)
    pub fn builder() -> crate::input::get_rules_input::Builder {
        crate::input::get_rules_input::Builder::default()
    }
    /// Creates a new `GetRules` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRules {
    type Output = std::result::Result<crate::output::GetRulesOutput, crate::error::GetRulesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_rules_error(response)
        } else {
            crate::operation_deser::parse_get_rules_response(response)
        }
    }
}

/// Operation shape for `GetVariables`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_variables`](crate::client::Client::get_variables).
///
/// See [`crate::client::fluent_builders::GetVariables`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetVariables {
    _private: (),
}
impl GetVariables {
    /// Creates a new builder-style object to manufacture [`GetVariablesInput`](crate::input::GetVariablesInput)
    pub fn builder() -> crate::input::get_variables_input::Builder {
        crate::input::get_variables_input::Builder::default()
    }
    /// Creates a new `GetVariables` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetVariables {
    type Output =
        std::result::Result<crate::output::GetVariablesOutput, crate::error::GetVariablesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_variables_error(response)
        } else {
            crate::operation_deser::parse_get_variables_response(response)
        }
    }
}

/// Operation shape for `ListEventPredictions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_event_predictions`](crate::client::Client::list_event_predictions).
///
/// See [`crate::client::fluent_builders::ListEventPredictions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListEventPredictions {
    _private: (),
}
impl ListEventPredictions {
    /// Creates a new builder-style object to manufacture [`ListEventPredictionsInput`](crate::input::ListEventPredictionsInput)
    pub fn builder() -> crate::input::list_event_predictions_input::Builder {
        crate::input::list_event_predictions_input::Builder::default()
    }
    /// Creates a new `ListEventPredictions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListEventPredictions {
    type Output = std::result::Result<
        crate::output::ListEventPredictionsOutput,
        crate::error::ListEventPredictionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_event_predictions_error(response)
        } else {
            crate::operation_deser::parse_list_event_predictions_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `PutDetector`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_detector`](crate::client::Client::put_detector).
///
/// See [`crate::client::fluent_builders::PutDetector`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutDetector {
    _private: (),
}
impl PutDetector {
    /// Creates a new builder-style object to manufacture [`PutDetectorInput`](crate::input::PutDetectorInput)
    pub fn builder() -> crate::input::put_detector_input::Builder {
        crate::input::put_detector_input::Builder::default()
    }
    /// Creates a new `PutDetector` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutDetector {
    type Output =
        std::result::Result<crate::output::PutDetectorOutput, crate::error::PutDetectorError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_detector_error(response)
        } else {
            crate::operation_deser::parse_put_detector_response(response)
        }
    }
}

/// Operation shape for `PutEntityType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_entity_type`](crate::client::Client::put_entity_type).
///
/// See [`crate::client::fluent_builders::PutEntityType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutEntityType {
    _private: (),
}
impl PutEntityType {
    /// Creates a new builder-style object to manufacture [`PutEntityTypeInput`](crate::input::PutEntityTypeInput)
    pub fn builder() -> crate::input::put_entity_type_input::Builder {
        crate::input::put_entity_type_input::Builder::default()
    }
    /// Creates a new `PutEntityType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutEntityType {
    type Output =
        std::result::Result<crate::output::PutEntityTypeOutput, crate::error::PutEntityTypeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_entity_type_error(response)
        } else {
            crate::operation_deser::parse_put_entity_type_response(response)
        }
    }
}

/// Operation shape for `PutEventType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_event_type`](crate::client::Client::put_event_type).
///
/// See [`crate::client::fluent_builders::PutEventType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutEventType {
    _private: (),
}
impl PutEventType {
    /// Creates a new builder-style object to manufacture [`PutEventTypeInput`](crate::input::PutEventTypeInput)
    pub fn builder() -> crate::input::put_event_type_input::Builder {
        crate::input::put_event_type_input::Builder::default()
    }
    /// Creates a new `PutEventType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutEventType {
    type Output =
        std::result::Result<crate::output::PutEventTypeOutput, crate::error::PutEventTypeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_event_type_error(response)
        } else {
            crate::operation_deser::parse_put_event_type_response(response)
        }
    }
}

/// Operation shape for `PutExternalModel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_external_model`](crate::client::Client::put_external_model).
///
/// See [`crate::client::fluent_builders::PutExternalModel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutExternalModel {
    _private: (),
}
impl PutExternalModel {
    /// Creates a new builder-style object to manufacture [`PutExternalModelInput`](crate::input::PutExternalModelInput)
    pub fn builder() -> crate::input::put_external_model_input::Builder {
        crate::input::put_external_model_input::Builder::default()
    }
    /// Creates a new `PutExternalModel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutExternalModel {
    type Output = std::result::Result<
        crate::output::PutExternalModelOutput,
        crate::error::PutExternalModelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_external_model_error(response)
        } else {
            crate::operation_deser::parse_put_external_model_response(response)
        }
    }
}

/// Operation shape for `PutKMSEncryptionKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_kms_encryption_key`](crate::client::Client::put_kms_encryption_key).
///
/// See [`crate::client::fluent_builders::PutKMSEncryptionKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutKMSEncryptionKey {
    _private: (),
}
impl PutKMSEncryptionKey {
    /// Creates a new builder-style object to manufacture [`PutKmsEncryptionKeyInput`](crate::input::PutKmsEncryptionKeyInput)
    pub fn builder() -> crate::input::put_kms_encryption_key_input::Builder {
        crate::input::put_kms_encryption_key_input::Builder::default()
    }
    /// Creates a new `PutKMSEncryptionKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutKMSEncryptionKey {
    type Output = std::result::Result<
        crate::output::PutKmsEncryptionKeyOutput,
        crate::error::PutKMSEncryptionKeyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_kms_encryption_key_error(response)
        } else {
            crate::operation_deser::parse_put_kms_encryption_key_response(response)
        }
    }
}

/// Operation shape for `PutLabel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_label`](crate::client::Client::put_label).
///
/// See [`crate::client::fluent_builders::PutLabel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutLabel {
    _private: (),
}
impl PutLabel {
    /// Creates a new builder-style object to manufacture [`PutLabelInput`](crate::input::PutLabelInput)
    pub fn builder() -> crate::input::put_label_input::Builder {
        crate::input::put_label_input::Builder::default()
    }
    /// Creates a new `PutLabel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutLabel {
    type Output = std::result::Result<crate::output::PutLabelOutput, crate::error::PutLabelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_label_error(response)
        } else {
            crate::operation_deser::parse_put_label_response(response)
        }
    }
}

/// Operation shape for `PutOutcome`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_outcome`](crate::client::Client::put_outcome).
///
/// See [`crate::client::fluent_builders::PutOutcome`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutOutcome {
    _private: (),
}
impl PutOutcome {
    /// Creates a new builder-style object to manufacture [`PutOutcomeInput`](crate::input::PutOutcomeInput)
    pub fn builder() -> crate::input::put_outcome_input::Builder {
        crate::input::put_outcome_input::Builder::default()
    }
    /// Creates a new `PutOutcome` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutOutcome {
    type Output =
        std::result::Result<crate::output::PutOutcomeOutput, crate::error::PutOutcomeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_outcome_error(response)
        } else {
            crate::operation_deser::parse_put_outcome_response(response)
        }
    }
}

/// Operation shape for `SendEvent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_event`](crate::client::Client::send_event).
///
/// See [`crate::client::fluent_builders::SendEvent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendEvent {
    _private: (),
}
impl SendEvent {
    /// Creates a new builder-style object to manufacture [`SendEventInput`](crate::input::SendEventInput)
    pub fn builder() -> crate::input::send_event_input::Builder {
        crate::input::send_event_input::Builder::default()
    }
    /// Creates a new `SendEvent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendEvent {
    type Output = std::result::Result<crate::output::SendEventOutput, crate::error::SendEventError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_send_event_error(response)
        } else {
            crate::operation_deser::parse_send_event_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateDetectorVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_detector_version`](crate::client::Client::update_detector_version).
///
/// See [`crate::client::fluent_builders::UpdateDetectorVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDetectorVersion {
    _private: (),
}
impl UpdateDetectorVersion {
    /// Creates a new builder-style object to manufacture [`UpdateDetectorVersionInput`](crate::input::UpdateDetectorVersionInput)
    pub fn builder() -> crate::input::update_detector_version_input::Builder {
        crate::input::update_detector_version_input::Builder::default()
    }
    /// Creates a new `UpdateDetectorVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDetectorVersion {
    type Output = std::result::Result<
        crate::output::UpdateDetectorVersionOutput,
        crate::error::UpdateDetectorVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_detector_version_error(response)
        } else {
            crate::operation_deser::parse_update_detector_version_response(response)
        }
    }
}

/// Operation shape for `UpdateDetectorVersionMetadata`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_detector_version_metadata`](crate::client::Client::update_detector_version_metadata).
///
/// See [`crate::client::fluent_builders::UpdateDetectorVersionMetadata`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDetectorVersionMetadata {
    _private: (),
}
impl UpdateDetectorVersionMetadata {
    /// Creates a new builder-style object to manufacture [`UpdateDetectorVersionMetadataInput`](crate::input::UpdateDetectorVersionMetadataInput)
    pub fn builder() -> crate::input::update_detector_version_metadata_input::Builder {
        crate::input::update_detector_version_metadata_input::Builder::default()
    }
    /// Creates a new `UpdateDetectorVersionMetadata` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDetectorVersionMetadata {
    type Output = std::result::Result<
        crate::output::UpdateDetectorVersionMetadataOutput,
        crate::error::UpdateDetectorVersionMetadataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_detector_version_metadata_error(response)
        } else {
            crate::operation_deser::parse_update_detector_version_metadata_response(response)
        }
    }
}

/// Operation shape for `UpdateDetectorVersionStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_detector_version_status`](crate::client::Client::update_detector_version_status).
///
/// See [`crate::client::fluent_builders::UpdateDetectorVersionStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDetectorVersionStatus {
    _private: (),
}
impl UpdateDetectorVersionStatus {
    /// Creates a new builder-style object to manufacture [`UpdateDetectorVersionStatusInput`](crate::input::UpdateDetectorVersionStatusInput)
    pub fn builder() -> crate::input::update_detector_version_status_input::Builder {
        crate::input::update_detector_version_status_input::Builder::default()
    }
    /// Creates a new `UpdateDetectorVersionStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDetectorVersionStatus {
    type Output = std::result::Result<
        crate::output::UpdateDetectorVersionStatusOutput,
        crate::error::UpdateDetectorVersionStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_detector_version_status_error(response)
        } else {
            crate::operation_deser::parse_update_detector_version_status_response(response)
        }
    }
}

/// Operation shape for `UpdateEventLabel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_event_label`](crate::client::Client::update_event_label).
///
/// See [`crate::client::fluent_builders::UpdateEventLabel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateEventLabel {
    _private: (),
}
impl UpdateEventLabel {
    /// Creates a new builder-style object to manufacture [`UpdateEventLabelInput`](crate::input::UpdateEventLabelInput)
    pub fn builder() -> crate::input::update_event_label_input::Builder {
        crate::input::update_event_label_input::Builder::default()
    }
    /// Creates a new `UpdateEventLabel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateEventLabel {
    type Output = std::result::Result<
        crate::output::UpdateEventLabelOutput,
        crate::error::UpdateEventLabelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_event_label_error(response)
        } else {
            crate::operation_deser::parse_update_event_label_response(response)
        }
    }
}

/// Operation shape for `UpdateModel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_model`](crate::client::Client::update_model).
///
/// See [`crate::client::fluent_builders::UpdateModel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateModel {
    _private: (),
}
impl UpdateModel {
    /// Creates a new builder-style object to manufacture [`UpdateModelInput`](crate::input::UpdateModelInput)
    pub fn builder() -> crate::input::update_model_input::Builder {
        crate::input::update_model_input::Builder::default()
    }
    /// Creates a new `UpdateModel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateModel {
    type Output =
        std::result::Result<crate::output::UpdateModelOutput, crate::error::UpdateModelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_model_error(response)
        } else {
            crate::operation_deser::parse_update_model_response(response)
        }
    }
}

/// Operation shape for `UpdateModelVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_model_version`](crate::client::Client::update_model_version).
///
/// See [`crate::client::fluent_builders::UpdateModelVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateModelVersion {
    _private: (),
}
impl UpdateModelVersion {
    /// Creates a new builder-style object to manufacture [`UpdateModelVersionInput`](crate::input::UpdateModelVersionInput)
    pub fn builder() -> crate::input::update_model_version_input::Builder {
        crate::input::update_model_version_input::Builder::default()
    }
    /// Creates a new `UpdateModelVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateModelVersion {
    type Output = std::result::Result<
        crate::output::UpdateModelVersionOutput,
        crate::error::UpdateModelVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_model_version_error(response)
        } else {
            crate::operation_deser::parse_update_model_version_response(response)
        }
    }
}

/// Operation shape for `UpdateModelVersionStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_model_version_status`](crate::client::Client::update_model_version_status).
///
/// See [`crate::client::fluent_builders::UpdateModelVersionStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateModelVersionStatus {
    _private: (),
}
impl UpdateModelVersionStatus {
    /// Creates a new builder-style object to manufacture [`UpdateModelVersionStatusInput`](crate::input::UpdateModelVersionStatusInput)
    pub fn builder() -> crate::input::update_model_version_status_input::Builder {
        crate::input::update_model_version_status_input::Builder::default()
    }
    /// Creates a new `UpdateModelVersionStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateModelVersionStatus {
    type Output = std::result::Result<
        crate::output::UpdateModelVersionStatusOutput,
        crate::error::UpdateModelVersionStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_model_version_status_error(response)
        } else {
            crate::operation_deser::parse_update_model_version_status_response(response)
        }
    }
}

/// Operation shape for `UpdateRuleMetadata`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_rule_metadata`](crate::client::Client::update_rule_metadata).
///
/// See [`crate::client::fluent_builders::UpdateRuleMetadata`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRuleMetadata {
    _private: (),
}
impl UpdateRuleMetadata {
    /// Creates a new builder-style object to manufacture [`UpdateRuleMetadataInput`](crate::input::UpdateRuleMetadataInput)
    pub fn builder() -> crate::input::update_rule_metadata_input::Builder {
        crate::input::update_rule_metadata_input::Builder::default()
    }
    /// Creates a new `UpdateRuleMetadata` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRuleMetadata {
    type Output = std::result::Result<
        crate::output::UpdateRuleMetadataOutput,
        crate::error::UpdateRuleMetadataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_rule_metadata_error(response)
        } else {
            crate::operation_deser::parse_update_rule_metadata_response(response)
        }
    }
}

/// Operation shape for `UpdateRuleVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_rule_version`](crate::client::Client::update_rule_version).
///
/// See [`crate::client::fluent_builders::UpdateRuleVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRuleVersion {
    _private: (),
}
impl UpdateRuleVersion {
    /// Creates a new builder-style object to manufacture [`UpdateRuleVersionInput`](crate::input::UpdateRuleVersionInput)
    pub fn builder() -> crate::input::update_rule_version_input::Builder {
        crate::input::update_rule_version_input::Builder::default()
    }
    /// Creates a new `UpdateRuleVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRuleVersion {
    type Output = std::result::Result<
        crate::output::UpdateRuleVersionOutput,
        crate::error::UpdateRuleVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_rule_version_error(response)
        } else {
            crate::operation_deser::parse_update_rule_version_response(response)
        }
    }
}

/// Operation shape for `UpdateVariable`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_variable`](crate::client::Client::update_variable).
///
/// See [`crate::client::fluent_builders::UpdateVariable`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateVariable {
    _private: (),
}
impl UpdateVariable {
    /// Creates a new builder-style object to manufacture [`UpdateVariableInput`](crate::input::UpdateVariableInput)
    pub fn builder() -> crate::input::update_variable_input::Builder {
        crate::input::update_variable_input::Builder::default()
    }
    /// Creates a new `UpdateVariable` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateVariable {
    type Output =
        std::result::Result<crate::output::UpdateVariableOutput, crate::error::UpdateVariableError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_variable_error(response)
        } else {
            crate::operation_deser::parse_update_variable_response(response)
        }
    }
}
