// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`BatchCreateVariableInput`](crate::input::BatchCreateVariableInput)
pub mod batch_create_variable_input {
    /// A builder for [`BatchCreateVariableInput`](crate::input::BatchCreateVariableInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) variable_entries:
            std::option::Option<std::vec::Vec<crate::model::VariableEntry>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `variable_entries`.
        ///
        /// To override the contents of this collection use [`set_variable_entries`](Self::set_variable_entries).
        ///
        /// <p>The list of variables for the batch create variable request.</p>
        pub fn variable_entries(mut self, input: impl Into<crate::model::VariableEntry>) -> Self {
            let mut v = self.variable_entries.unwrap_or_default();
            v.push(input.into());
            self.variable_entries = Some(v);
            self
        }
        /// <p>The list of variables for the batch create variable request.</p>
        pub fn set_variable_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VariableEntry>>,
        ) -> Self {
            self.variable_entries = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchCreateVariableInput`](crate::input::BatchCreateVariableInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchCreateVariableInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchCreateVariableInput {
                variable_entries: self.variable_entries,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchCreateVariableInputOperationOutputAlias = crate::operation::BatchCreateVariable;
#[doc(hidden)]
pub type BatchCreateVariableInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchCreateVariableInput {
    /// Consumes the builder and constructs an Operation<[`BatchCreateVariable`](crate::operation::BatchCreateVariable)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchCreateVariable,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchCreateVariableInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchCreateVariableInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchCreateVariableInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.BatchCreateVariable",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_create_variable(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchCreateVariable::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchCreateVariable",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchCreateVariableInput`](crate::input::BatchCreateVariableInput)
    pub fn builder() -> crate::input::batch_create_variable_input::Builder {
        crate::input::batch_create_variable_input::Builder::default()
    }
}

/// See [`BatchGetVariableInput`](crate::input::BatchGetVariableInput)
pub mod batch_get_variable_input {
    /// A builder for [`BatchGetVariableInput`](crate::input::BatchGetVariableInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>The list of variable names to get.</p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.names.unwrap_or_default();
            v.push(input.into());
            self.names = Some(v);
            self
        }
        /// <p>The list of variable names to get.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.names = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetVariableInput`](crate::input::BatchGetVariableInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchGetVariableInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchGetVariableInput { names: self.names })
        }
    }
}
#[doc(hidden)]
pub type BatchGetVariableInputOperationOutputAlias = crate::operation::BatchGetVariable;
#[doc(hidden)]
pub type BatchGetVariableInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchGetVariableInput {
    /// Consumes the builder and constructs an Operation<[`BatchGetVariable`](crate::operation::BatchGetVariable)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchGetVariable,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchGetVariableInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchGetVariableInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchGetVariableInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.BatchGetVariable",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_get_variable(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchGetVariable::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchGetVariable",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchGetVariableInput`](crate::input::BatchGetVariableInput)
    pub fn builder() -> crate::input::batch_get_variable_input::Builder {
        crate::input::batch_get_variable_input::Builder::default()
    }
}

/// See [`CancelBatchImportJobInput`](crate::input::CancelBatchImportJobInput)
pub mod cancel_batch_import_job_input {
    /// A builder for [`CancelBatchImportJobInput`](crate::input::CancelBatchImportJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The ID of an in-progress batch import job to cancel. </p>
        /// <p>Amazon Fraud Detector will throw an error if the batch import job is in <code>FAILED</code>, <code>CANCELED</code>, or  <code>COMPLETED</code> state.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p> The ID of an in-progress batch import job to cancel. </p>
        /// <p>Amazon Fraud Detector will throw an error if the batch import job is in <code>FAILED</code>, <code>CANCELED</code>, or  <code>COMPLETED</code> state.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelBatchImportJobInput`](crate::input::CancelBatchImportJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelBatchImportJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelBatchImportJobInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelBatchImportJobInputOperationOutputAlias = crate::operation::CancelBatchImportJob;
#[doc(hidden)]
pub type CancelBatchImportJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CancelBatchImportJobInput {
    /// Consumes the builder and constructs an Operation<[`CancelBatchImportJob`](crate::operation::CancelBatchImportJob)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelBatchImportJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CancelBatchImportJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CancelBatchImportJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CancelBatchImportJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.CancelBatchImportJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_cancel_batch_import_job(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelBatchImportJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelBatchImportJob",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CancelBatchImportJobInput`](crate::input::CancelBatchImportJobInput)
    pub fn builder() -> crate::input::cancel_batch_import_job_input::Builder {
        crate::input::cancel_batch_import_job_input::Builder::default()
    }
}

/// See [`CancelBatchPredictionJobInput`](crate::input::CancelBatchPredictionJobInput)
pub mod cancel_batch_prediction_job_input {
    /// A builder for [`CancelBatchPredictionJobInput`](crate::input::CancelBatchPredictionJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the batch prediction job to cancel.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID of the batch prediction job to cancel.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelBatchPredictionJobInput`](crate::input::CancelBatchPredictionJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelBatchPredictionJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelBatchPredictionJobInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelBatchPredictionJobInputOperationOutputAlias =
    crate::operation::CancelBatchPredictionJob;
#[doc(hidden)]
pub type CancelBatchPredictionJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CancelBatchPredictionJobInput {
    /// Consumes the builder and constructs an Operation<[`CancelBatchPredictionJob`](crate::operation::CancelBatchPredictionJob)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelBatchPredictionJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CancelBatchPredictionJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CancelBatchPredictionJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CancelBatchPredictionJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.CancelBatchPredictionJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_cancel_batch_prediction_job(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelBatchPredictionJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelBatchPredictionJob",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CancelBatchPredictionJobInput`](crate::input::CancelBatchPredictionJobInput)
    pub fn builder() -> crate::input::cancel_batch_prediction_job_input::Builder {
        crate::input::cancel_batch_prediction_job_input::Builder::default()
    }
}

/// See [`CreateBatchImportJobInput`](crate::input::CreateBatchImportJobInput)
pub mod create_batch_import_job_input {
    /// A builder for [`CreateBatchImportJobInput`](crate::input::CreateBatchImportJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) input_path: std::option::Option<std::string::String>,
        pub(crate) output_path: std::option::Option<std::string::String>,
        pub(crate) event_type_name: std::option::Option<std::string::String>,
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the batch import job. The ID cannot be of a past job, unless the job exists in <code>CREATE_FAILED</code> state.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID of the batch import job. The ID cannot be of a past job, unless the job exists in <code>CREATE_FAILED</code> state.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The URI that points to the Amazon S3 location of your data file.</p>
        pub fn input_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_path = Some(input.into());
            self
        }
        /// <p>The URI that points to the Amazon S3 location of your data file.</p>
        pub fn set_input_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input_path = input;
            self
        }
        /// <p>The URI that points to the Amazon S3 location for storing your results. </p>
        pub fn output_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_path = Some(input.into());
            self
        }
        /// <p>The URI that points to the Amazon S3 location for storing your results. </p>
        pub fn set_output_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.output_path = input;
            self
        }
        /// <p>The name of the event type.</p>
        pub fn event_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_type_name = Some(input.into());
            self
        }
        /// <p>The name of the event type.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_type_name = input;
            self
        }
        /// <p>The ARN of the IAM role created for Amazon S3 bucket that holds your data file.
        /// The IAM role must have read and write permissions to both input and output S3 buckets.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role created for Amazon S3 bucket that holds your data file.
        /// The IAM role must have read and write permissions to both input and output S3 buckets.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key-value pairs associated with this request.  </p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A collection of key-value pairs associated with this request.  </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBatchImportJobInput`](crate::input::CreateBatchImportJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBatchImportJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBatchImportJobInput {
                job_id: self.job_id,
                input_path: self.input_path,
                output_path: self.output_path,
                event_type_name: self.event_type_name,
                iam_role_arn: self.iam_role_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBatchImportJobInputOperationOutputAlias = crate::operation::CreateBatchImportJob;
#[doc(hidden)]
pub type CreateBatchImportJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateBatchImportJobInput {
    /// Consumes the builder and constructs an Operation<[`CreateBatchImportJob`](crate::operation::CreateBatchImportJob)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBatchImportJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateBatchImportJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateBatchImportJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateBatchImportJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.CreateBatchImportJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_batch_import_job(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBatchImportJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBatchImportJob",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateBatchImportJobInput`](crate::input::CreateBatchImportJobInput)
    pub fn builder() -> crate::input::create_batch_import_job_input::Builder {
        crate::input::create_batch_import_job_input::Builder::default()
    }
}

/// See [`CreateBatchPredictionJobInput`](crate::input::CreateBatchPredictionJobInput)
pub mod create_batch_prediction_job_input {
    /// A builder for [`CreateBatchPredictionJobInput`](crate::input::CreateBatchPredictionJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) input_path: std::option::Option<std::string::String>,
        pub(crate) output_path: std::option::Option<std::string::String>,
        pub(crate) event_type_name: std::option::Option<std::string::String>,
        pub(crate) detector_name: std::option::Option<std::string::String>,
        pub(crate) detector_version: std::option::Option<std::string::String>,
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the batch prediction job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID of the batch prediction job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The Amazon S3 location of your training file.</p>
        pub fn input_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_path = Some(input.into());
            self
        }
        /// <p>The Amazon S3 location of your training file.</p>
        pub fn set_input_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input_path = input;
            self
        }
        /// <p>The Amazon S3 location of your output file.</p>
        pub fn output_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_path = Some(input.into());
            self
        }
        /// <p>The Amazon S3 location of your output file.</p>
        pub fn set_output_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.output_path = input;
            self
        }
        /// <p>The name of the event type.</p>
        pub fn event_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_type_name = Some(input.into());
            self
        }
        /// <p>The name of the event type.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_type_name = input;
            self
        }
        /// <p>The name of the detector.</p>
        pub fn detector_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_name = Some(input.into());
            self
        }
        /// <p>The name of the detector.</p>
        pub fn set_detector_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_name = input;
            self
        }
        /// <p>The detector version.</p>
        pub fn detector_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_version = Some(input.into());
            self
        }
        /// <p>The detector version.</p>
        pub fn set_detector_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_version = input;
            self
        }
        /// <p>The ARN of the IAM role to use for this job request.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role to use for this job request.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBatchPredictionJobInput`](crate::input::CreateBatchPredictionJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBatchPredictionJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBatchPredictionJobInput {
                job_id: self.job_id,
                input_path: self.input_path,
                output_path: self.output_path,
                event_type_name: self.event_type_name,
                detector_name: self.detector_name,
                detector_version: self.detector_version,
                iam_role_arn: self.iam_role_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBatchPredictionJobInputOperationOutputAlias =
    crate::operation::CreateBatchPredictionJob;
#[doc(hidden)]
pub type CreateBatchPredictionJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateBatchPredictionJobInput {
    /// Consumes the builder and constructs an Operation<[`CreateBatchPredictionJob`](crate::operation::CreateBatchPredictionJob)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBatchPredictionJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateBatchPredictionJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateBatchPredictionJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateBatchPredictionJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.CreateBatchPredictionJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_batch_prediction_job(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBatchPredictionJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBatchPredictionJob",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateBatchPredictionJobInput`](crate::input::CreateBatchPredictionJobInput)
    pub fn builder() -> crate::input::create_batch_prediction_job_input::Builder {
        crate::input::create_batch_prediction_job_input::Builder::default()
    }
}

/// See [`CreateDetectorVersionInput`](crate::input::CreateDetectorVersionInput)
pub mod create_detector_version_input {
    /// A builder for [`CreateDetectorVersionInput`](crate::input::CreateDetectorVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) external_model_endpoints:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        pub(crate) model_versions: std::option::Option<std::vec::Vec<crate::model::ModelVersion>>,
        pub(crate) rule_execution_mode: std::option::Option<crate::model::RuleExecutionMode>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the detector under which you want to create a new version.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The ID of the detector under which you want to create a new version.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The description of the detector version.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the detector version.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `external_model_endpoints`.
        ///
        /// To override the contents of this collection use [`set_external_model_endpoints`](Self::set_external_model_endpoints).
        ///
        /// <p>The Amazon Sagemaker model endpoints to include in the detector version.</p>
        pub fn external_model_endpoints(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.external_model_endpoints.unwrap_or_default();
            v.push(input.into());
            self.external_model_endpoints = Some(v);
            self
        }
        /// <p>The Amazon Sagemaker model endpoints to include in the detector version.</p>
        pub fn set_external_model_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.external_model_endpoints = input;
            self
        }
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>The rules to include in the detector version.</p>
        pub fn rules(mut self, input: impl Into<crate::model::Rule>) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input.into());
            self.rules = Some(v);
            self
        }
        /// <p>The rules to include in the detector version.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// Appends an item to `model_versions`.
        ///
        /// To override the contents of this collection use [`set_model_versions`](Self::set_model_versions).
        ///
        /// <p>The model versions to include in the detector version.</p>
        pub fn model_versions(mut self, input: impl Into<crate::model::ModelVersion>) -> Self {
            let mut v = self.model_versions.unwrap_or_default();
            v.push(input.into());
            self.model_versions = Some(v);
            self
        }
        /// <p>The model versions to include in the detector version.</p>
        pub fn set_model_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ModelVersion>>,
        ) -> Self {
            self.model_versions = input;
            self
        }
        /// <p>The rule execution mode for the rules included in the detector version.</p>
        /// <p>You can define and edit the rule mode at the detector version level, when it is in draft status.</p>
        /// <p>If you specify <code>FIRST_MATCHED</code>, Amazon Fraud Detector evaluates rules sequentially, first to last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule.</p>
        /// <p>If you specifiy <code>ALL_MATCHED</code>, Amazon Fraud Detector evaluates all rules and returns the outcomes for all matched rules. </p>
        /// <p>The default behavior is <code>FIRST_MATCHED</code>.</p>
        pub fn rule_execution_mode(mut self, input: crate::model::RuleExecutionMode) -> Self {
            self.rule_execution_mode = Some(input);
            self
        }
        /// <p>The rule execution mode for the rules included in the detector version.</p>
        /// <p>You can define and edit the rule mode at the detector version level, when it is in draft status.</p>
        /// <p>If you specify <code>FIRST_MATCHED</code>, Amazon Fraud Detector evaluates rules sequentially, first to last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule.</p>
        /// <p>If you specifiy <code>ALL_MATCHED</code>, Amazon Fraud Detector evaluates all rules and returns the outcomes for all matched rules. </p>
        /// <p>The default behavior is <code>FIRST_MATCHED</code>.</p>
        pub fn set_rule_execution_mode(
            mut self,
            input: std::option::Option<crate::model::RuleExecutionMode>,
        ) -> Self {
            self.rule_execution_mode = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDetectorVersionInput`](crate::input::CreateDetectorVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDetectorVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDetectorVersionInput {
                detector_id: self.detector_id,
                description: self.description,
                external_model_endpoints: self.external_model_endpoints,
                rules: self.rules,
                model_versions: self.model_versions,
                rule_execution_mode: self.rule_execution_mode,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDetectorVersionInputOperationOutputAlias = crate::operation::CreateDetectorVersion;
#[doc(hidden)]
pub type CreateDetectorVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDetectorVersionInput {
    /// Consumes the builder and constructs an Operation<[`CreateDetectorVersion`](crate::operation::CreateDetectorVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDetectorVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDetectorVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDetectorVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDetectorVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.CreateDetectorVersion",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_detector_version(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDetectorVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDetectorVersion",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDetectorVersionInput`](crate::input::CreateDetectorVersionInput)
    pub fn builder() -> crate::input::create_detector_version_input::Builder {
        crate::input::create_detector_version_input::Builder::default()
    }
}

/// See [`CreateModelInput`](crate::input::CreateModelInput)
pub mod create_model_input {
    /// A builder for [`CreateModelInput`](crate::input::CreateModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_id: std::option::Option<std::string::String>,
        pub(crate) model_type: std::option::Option<crate::model::ModelTypeEnum>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) event_type_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The model ID.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_id = Some(input.into());
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_id = input;
            self
        }
        /// <p>The model type. </p>
        pub fn model_type(mut self, input: crate::model::ModelTypeEnum) -> Self {
            self.model_type = Some(input);
            self
        }
        /// <p>The model type. </p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.model_type = input;
            self
        }
        /// <p>The model description. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The model description. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name of the event type.</p>
        pub fn event_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_type_name = Some(input.into());
            self
        }
        /// <p>The name of the event type.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_type_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateModelInput`](crate::input::CreateModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateModelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateModelInput {
                model_id: self.model_id,
                model_type: self.model_type,
                description: self.description,
                event_type_name: self.event_type_name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateModelInputOperationOutputAlias = crate::operation::CreateModel;
#[doc(hidden)]
pub type CreateModelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateModelInput {
    /// Consumes the builder and constructs an Operation<[`CreateModel`](crate::operation::CreateModel)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateModel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateModelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateModelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateModelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.CreateModel",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_model(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateModel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateModel",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateModelInput`](crate::input::CreateModelInput)
    pub fn builder() -> crate::input::create_model_input::Builder {
        crate::input::create_model_input::Builder::default()
    }
}

/// See [`CreateModelVersionInput`](crate::input::CreateModelVersionInput)
pub mod create_model_version_input {
    /// A builder for [`CreateModelVersionInput`](crate::input::CreateModelVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_id: std::option::Option<std::string::String>,
        pub(crate) model_type: std::option::Option<crate::model::ModelTypeEnum>,
        pub(crate) training_data_source: std::option::Option<crate::model::TrainingDataSourceEnum>,
        pub(crate) training_data_schema: std::option::Option<crate::model::TrainingDataSchema>,
        pub(crate) external_events_detail: std::option::Option<crate::model::ExternalEventsDetail>,
        pub(crate) ingested_events_detail: std::option::Option<crate::model::IngestedEventsDetail>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The model ID. </p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_id = Some(input.into());
            self
        }
        /// <p>The model ID. </p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_id = input;
            self
        }
        /// <p>The model type.</p>
        pub fn model_type(mut self, input: crate::model::ModelTypeEnum) -> Self {
            self.model_type = Some(input);
            self
        }
        /// <p>The model type.</p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.model_type = input;
            self
        }
        /// <p>The training data source location in Amazon S3. </p>
        pub fn training_data_source(mut self, input: crate::model::TrainingDataSourceEnum) -> Self {
            self.training_data_source = Some(input);
            self
        }
        /// <p>The training data source location in Amazon S3. </p>
        pub fn set_training_data_source(
            mut self,
            input: std::option::Option<crate::model::TrainingDataSourceEnum>,
        ) -> Self {
            self.training_data_source = input;
            self
        }
        /// <p>The training data schema.</p>
        pub fn training_data_schema(mut self, input: crate::model::TrainingDataSchema) -> Self {
            self.training_data_schema = Some(input);
            self
        }
        /// <p>The training data schema.</p>
        pub fn set_training_data_schema(
            mut self,
            input: std::option::Option<crate::model::TrainingDataSchema>,
        ) -> Self {
            self.training_data_schema = input;
            self
        }
        /// <p>Details of the external events data used for model version training. Required if <code>trainingDataSource</code> is <code>EXTERNAL_EVENTS</code>.</p>
        pub fn external_events_detail(mut self, input: crate::model::ExternalEventsDetail) -> Self {
            self.external_events_detail = Some(input);
            self
        }
        /// <p>Details of the external events data used for model version training. Required if <code>trainingDataSource</code> is <code>EXTERNAL_EVENTS</code>.</p>
        pub fn set_external_events_detail(
            mut self,
            input: std::option::Option<crate::model::ExternalEventsDetail>,
        ) -> Self {
            self.external_events_detail = input;
            self
        }
        /// <p>Details of the ingested events data used for model version training. Required if <code>trainingDataSource</code> is <code>INGESTED_EVENTS</code>.</p>
        pub fn ingested_events_detail(mut self, input: crate::model::IngestedEventsDetail) -> Self {
            self.ingested_events_detail = Some(input);
            self
        }
        /// <p>Details of the ingested events data used for model version training. Required if <code>trainingDataSource</code> is <code>INGESTED_EVENTS</code>.</p>
        pub fn set_ingested_events_detail(
            mut self,
            input: std::option::Option<crate::model::IngestedEventsDetail>,
        ) -> Self {
            self.ingested_events_detail = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateModelVersionInput`](crate::input::CreateModelVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateModelVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateModelVersionInput {
                model_id: self.model_id,
                model_type: self.model_type,
                training_data_source: self.training_data_source,
                training_data_schema: self.training_data_schema,
                external_events_detail: self.external_events_detail,
                ingested_events_detail: self.ingested_events_detail,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateModelVersionInputOperationOutputAlias = crate::operation::CreateModelVersion;
#[doc(hidden)]
pub type CreateModelVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateModelVersionInput {
    /// Consumes the builder and constructs an Operation<[`CreateModelVersion`](crate::operation::CreateModelVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateModelVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateModelVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateModelVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateModelVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.CreateModelVersion",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_model_version(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateModelVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateModelVersion",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateModelVersionInput`](crate::input::CreateModelVersionInput)
    pub fn builder() -> crate::input::create_model_version_input::Builder {
        crate::input::create_model_version_input::Builder::default()
    }
}

/// See [`CreateRuleInput`](crate::input::CreateRuleInput)
pub mod create_rule_input {
    /// A builder for [`CreateRuleInput`](crate::input::CreateRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_id: std::option::Option<std::string::String>,
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) expression: std::option::Option<std::string::String>,
        pub(crate) language: std::option::Option<crate::model::Language>,
        pub(crate) outcomes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The rule ID.</p>
        pub fn rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_id = Some(input.into());
            self
        }
        /// <p>The rule ID.</p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_id = input;
            self
        }
        /// <p>The detector ID for the rule's parent detector.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The detector ID for the rule's parent detector.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The rule description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The rule description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The rule expression.</p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.expression = Some(input.into());
            self
        }
        /// <p>The rule expression.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.expression = input;
            self
        }
        /// <p>The language of the rule.</p>
        pub fn language(mut self, input: crate::model::Language) -> Self {
            self.language = Some(input);
            self
        }
        /// <p>The language of the rule.</p>
        pub fn set_language(mut self, input: std::option::Option<crate::model::Language>) -> Self {
            self.language = input;
            self
        }
        /// Appends an item to `outcomes`.
        ///
        /// To override the contents of this collection use [`set_outcomes`](Self::set_outcomes).
        ///
        /// <p>The outcome or outcomes returned when the rule expression matches.</p>
        pub fn outcomes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.outcomes.unwrap_or_default();
            v.push(input.into());
            self.outcomes = Some(v);
            self
        }
        /// <p>The outcome or outcomes returned when the rule expression matches.</p>
        pub fn set_outcomes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.outcomes = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRuleInput`](crate::input::CreateRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRuleInput {
                rule_id: self.rule_id,
                detector_id: self.detector_id,
                description: self.description,
                expression: self.expression,
                language: self.language,
                outcomes: self.outcomes,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRuleInputOperationOutputAlias = crate::operation::CreateRule;
#[doc(hidden)]
pub type CreateRuleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateRuleInput {
    /// Consumes the builder and constructs an Operation<[`CreateRule`](crate::operation::CreateRule)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.CreateRule",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_rule(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRule",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateRuleInput`](crate::input::CreateRuleInput)
    pub fn builder() -> crate::input::create_rule_input::Builder {
        crate::input::create_rule_input::Builder::default()
    }
}

/// See [`CreateVariableInput`](crate::input::CreateVariableInput)
pub mod create_variable_input {
    /// A builder for [`CreateVariableInput`](crate::input::CreateVariableInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) data_type: std::option::Option<crate::model::DataType>,
        pub(crate) data_source: std::option::Option<crate::model::DataSource>,
        pub(crate) default_value: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) variable_type: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the variable.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the variable.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The data type.</p>
        pub fn data_type(mut self, input: crate::model::DataType) -> Self {
            self.data_type = Some(input);
            self
        }
        /// <p>The data type.</p>
        pub fn set_data_type(mut self, input: std::option::Option<crate::model::DataType>) -> Self {
            self.data_type = input;
            self
        }
        /// <p>The source of the data.</p>
        pub fn data_source(mut self, input: crate::model::DataSource) -> Self {
            self.data_source = Some(input);
            self
        }
        /// <p>The source of the data.</p>
        pub fn set_data_source(
            mut self,
            input: std::option::Option<crate::model::DataSource>,
        ) -> Self {
            self.data_source = input;
            self
        }
        /// <p>The default value for the variable when no value is received.</p>
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_value = Some(input.into());
            self
        }
        /// <p>The default value for the variable when no value is received.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The variable type. For more information see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable types</a>.
        /// </p>
        /// <p>Valid Values: <code>AUTH_CODE | AVS | BILLING_ADDRESS_L1 | BILLING_ADDRESS_L2 | BILLING_CITY | BILLING_COUNTRY | BILLING_NAME | BILLING_PHONE | BILLING_STATE | BILLING_ZIP | CARD_BIN | CATEGORICAL | CURRENCY_CODE | EMAIL_ADDRESS | FINGERPRINT | FRAUD_LABEL | FREE_FORM_TEXT | IP_ADDRESS | NUMERIC | ORDER_ID | PAYMENT_TYPE | PHONE_NUMBER | PRICE | PRODUCT_CATEGORY | SHIPPING_ADDRESS_L1 | SHIPPING_ADDRESS_L2 | SHIPPING_CITY | SHIPPING_COUNTRY | SHIPPING_NAME | SHIPPING_PHONE | SHIPPING_STATE | SHIPPING_ZIP | USERAGENT</code>
        /// </p>
        pub fn variable_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.variable_type = Some(input.into());
            self
        }
        /// <p>The variable type. For more information see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable types</a>.
        /// </p>
        /// <p>Valid Values: <code>AUTH_CODE | AVS | BILLING_ADDRESS_L1 | BILLING_ADDRESS_L2 | BILLING_CITY | BILLING_COUNTRY | BILLING_NAME | BILLING_PHONE | BILLING_STATE | BILLING_ZIP | CARD_BIN | CATEGORICAL | CURRENCY_CODE | EMAIL_ADDRESS | FINGERPRINT | FRAUD_LABEL | FREE_FORM_TEXT | IP_ADDRESS | NUMERIC | ORDER_ID | PAYMENT_TYPE | PHONE_NUMBER | PRICE | PRODUCT_CATEGORY | SHIPPING_ADDRESS_L1 | SHIPPING_ADDRESS_L2 | SHIPPING_CITY | SHIPPING_COUNTRY | SHIPPING_NAME | SHIPPING_PHONE | SHIPPING_STATE | SHIPPING_ZIP | USERAGENT</code>
        /// </p>
        pub fn set_variable_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.variable_type = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateVariableInput`](crate::input::CreateVariableInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateVariableInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateVariableInput {
                name: self.name,
                data_type: self.data_type,
                data_source: self.data_source,
                default_value: self.default_value,
                description: self.description,
                variable_type: self.variable_type,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateVariableInputOperationOutputAlias = crate::operation::CreateVariable;
#[doc(hidden)]
pub type CreateVariableInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateVariableInput {
    /// Consumes the builder and constructs an Operation<[`CreateVariable`](crate::operation::CreateVariable)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateVariable,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateVariableInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateVariableInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateVariableInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.CreateVariable",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_variable(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateVariable::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateVariable",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateVariableInput`](crate::input::CreateVariableInput)
    pub fn builder() -> crate::input::create_variable_input::Builder {
        crate::input::create_variable_input::Builder::default()
    }
}

/// See [`DeleteBatchImportJobInput`](crate::input::DeleteBatchImportJobInput)
pub mod delete_batch_import_job_input {
    /// A builder for [`DeleteBatchImportJobInput`](crate::input::DeleteBatchImportJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the batch import job to delete. </p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID of the batch import job to delete. </p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBatchImportJobInput`](crate::input::DeleteBatchImportJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBatchImportJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBatchImportJobInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBatchImportJobInputOperationOutputAlias = crate::operation::DeleteBatchImportJob;
#[doc(hidden)]
pub type DeleteBatchImportJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteBatchImportJobInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBatchImportJob`](crate::operation::DeleteBatchImportJob)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBatchImportJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBatchImportJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBatchImportJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBatchImportJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.DeleteBatchImportJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_batch_import_job(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBatchImportJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBatchImportJob",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBatchImportJobInput`](crate::input::DeleteBatchImportJobInput)
    pub fn builder() -> crate::input::delete_batch_import_job_input::Builder {
        crate::input::delete_batch_import_job_input::Builder::default()
    }
}

/// See [`DeleteBatchPredictionJobInput`](crate::input::DeleteBatchPredictionJobInput)
pub mod delete_batch_prediction_job_input {
    /// A builder for [`DeleteBatchPredictionJobInput`](crate::input::DeleteBatchPredictionJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the batch prediction job to delete.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID of the batch prediction job to delete.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBatchPredictionJobInput`](crate::input::DeleteBatchPredictionJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBatchPredictionJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBatchPredictionJobInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBatchPredictionJobInputOperationOutputAlias =
    crate::operation::DeleteBatchPredictionJob;
#[doc(hidden)]
pub type DeleteBatchPredictionJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteBatchPredictionJobInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBatchPredictionJob`](crate::operation::DeleteBatchPredictionJob)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBatchPredictionJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBatchPredictionJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBatchPredictionJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBatchPredictionJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.DeleteBatchPredictionJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_batch_prediction_job(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBatchPredictionJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBatchPredictionJob",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBatchPredictionJobInput`](crate::input::DeleteBatchPredictionJobInput)
    pub fn builder() -> crate::input::delete_batch_prediction_job_input::Builder {
        crate::input::delete_batch_prediction_job_input::Builder::default()
    }
}

/// See [`DeleteDetectorInput`](crate::input::DeleteDetectorInput)
pub mod delete_detector_input {
    /// A builder for [`DeleteDetectorInput`](crate::input::DeleteDetectorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the detector to delete.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The ID of the detector to delete.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDetectorInput`](crate::input::DeleteDetectorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDetectorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDetectorInput {
                detector_id: self.detector_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDetectorInputOperationOutputAlias = crate::operation::DeleteDetector;
#[doc(hidden)]
pub type DeleteDetectorInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDetectorInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDetector`](crate::operation::DeleteDetector)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDetector,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDetectorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDetectorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDetectorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.DeleteDetector",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_detector(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDetector::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDetector",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDetectorInput`](crate::input::DeleteDetectorInput)
    pub fn builder() -> crate::input::delete_detector_input::Builder {
        crate::input::delete_detector_input::Builder::default()
    }
}

/// See [`DeleteDetectorVersionInput`](crate::input::DeleteDetectorVersionInput)
pub mod delete_detector_version_input {
    /// A builder for [`DeleteDetectorVersionInput`](crate::input::DeleteDetectorVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) detector_version_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the parent detector for the detector version to delete.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The ID of the parent detector for the detector version to delete.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The ID of the detector version to delete.</p>
        pub fn detector_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_version_id = Some(input.into());
            self
        }
        /// <p>The ID of the detector version to delete.</p>
        pub fn set_detector_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDetectorVersionInput`](crate::input::DeleteDetectorVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDetectorVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDetectorVersionInput {
                detector_id: self.detector_id,
                detector_version_id: self.detector_version_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDetectorVersionInputOperationOutputAlias = crate::operation::DeleteDetectorVersion;
#[doc(hidden)]
pub type DeleteDetectorVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDetectorVersionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDetectorVersion`](crate::operation::DeleteDetectorVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDetectorVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDetectorVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDetectorVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDetectorVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.DeleteDetectorVersion",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_detector_version(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDetectorVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDetectorVersion",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDetectorVersionInput`](crate::input::DeleteDetectorVersionInput)
    pub fn builder() -> crate::input::delete_detector_version_input::Builder {
        crate::input::delete_detector_version_input::Builder::default()
    }
}

/// See [`DeleteEntityTypeInput`](crate::input::DeleteEntityTypeInput)
pub mod delete_entity_type_input {
    /// A builder for [`DeleteEntityTypeInput`](crate::input::DeleteEntityTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the entity type to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the entity type to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEntityTypeInput`](crate::input::DeleteEntityTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEntityTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEntityTypeInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteEntityTypeInputOperationOutputAlias = crate::operation::DeleteEntityType;
#[doc(hidden)]
pub type DeleteEntityTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteEntityTypeInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEntityType`](crate::operation::DeleteEntityType)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEntityType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteEntityTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteEntityTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteEntityTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.DeleteEntityType",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_entity_type(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEntityType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEntityType",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteEntityTypeInput`](crate::input::DeleteEntityTypeInput)
    pub fn builder() -> crate::input::delete_entity_type_input::Builder {
        crate::input::delete_entity_type_input::Builder::default()
    }
}

/// See [`DeleteEventInput`](crate::input::DeleteEventInput)
pub mod delete_event_input {
    /// A builder for [`DeleteEventInput`](crate::input::DeleteEventInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_id: std::option::Option<std::string::String>,
        pub(crate) event_type_name: std::option::Option<std::string::String>,
        pub(crate) delete_audit_history: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the event to delete.</p>
        pub fn event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_id = Some(input.into());
            self
        }
        /// <p>The ID of the event to delete.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_id = input;
            self
        }
        /// <p>The name of the event type.</p>
        pub fn event_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_type_name = Some(input.into());
            self
        }
        /// <p>The name of the event type.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_type_name = input;
            self
        }
        /// <p>Specifies whether or not to delete any predictions associated with the event.</p>
        pub fn delete_audit_history(mut self, input: bool) -> Self {
            self.delete_audit_history = Some(input);
            self
        }
        /// <p>Specifies whether or not to delete any predictions associated with the event.</p>
        pub fn set_delete_audit_history(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_audit_history = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEventInput`](crate::input::DeleteEventInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEventInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEventInput {
                event_id: self.event_id,
                event_type_name: self.event_type_name,
                delete_audit_history: self.delete_audit_history,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEventInputOperationOutputAlias = crate::operation::DeleteEvent;
#[doc(hidden)]
pub type DeleteEventInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteEventInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEvent`](crate::operation::DeleteEvent)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEvent,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteEventInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteEventInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteEventInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.DeleteEvent",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_event(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEvent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEvent",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteEventInput`](crate::input::DeleteEventInput)
    pub fn builder() -> crate::input::delete_event_input::Builder {
        crate::input::delete_event_input::Builder::default()
    }
}

/// See [`DeleteEventsByEventTypeInput`](crate::input::DeleteEventsByEventTypeInput)
pub mod delete_events_by_event_type_input {
    /// A builder for [`DeleteEventsByEventTypeInput`](crate::input::DeleteEventsByEventTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_type_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the event type.</p>
        pub fn event_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_type_name = Some(input.into());
            self
        }
        /// <p>The name of the event type.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_type_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEventsByEventTypeInput`](crate::input::DeleteEventsByEventTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEventsByEventTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEventsByEventTypeInput {
                event_type_name: self.event_type_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEventsByEventTypeInputOperationOutputAlias =
    crate::operation::DeleteEventsByEventType;
#[doc(hidden)]
pub type DeleteEventsByEventTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteEventsByEventTypeInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEventsByEventType`](crate::operation::DeleteEventsByEventType)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEventsByEventType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteEventsByEventTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteEventsByEventTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteEventsByEventTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.DeleteEventsByEventType",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_events_by_event_type(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEventsByEventType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEventsByEventType",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteEventsByEventTypeInput`](crate::input::DeleteEventsByEventTypeInput)
    pub fn builder() -> crate::input::delete_events_by_event_type_input::Builder {
        crate::input::delete_events_by_event_type_input::Builder::default()
    }
}

/// See [`DeleteEventTypeInput`](crate::input::DeleteEventTypeInput)
pub mod delete_event_type_input {
    /// A builder for [`DeleteEventTypeInput`](crate::input::DeleteEventTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the event type to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the event type to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEventTypeInput`](crate::input::DeleteEventTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEventTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEventTypeInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteEventTypeInputOperationOutputAlias = crate::operation::DeleteEventType;
#[doc(hidden)]
pub type DeleteEventTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteEventTypeInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEventType`](crate::operation::DeleteEventType)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEventType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteEventTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteEventTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteEventTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.DeleteEventType",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_event_type(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEventType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEventType",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteEventTypeInput`](crate::input::DeleteEventTypeInput)
    pub fn builder() -> crate::input::delete_event_type_input::Builder {
        crate::input::delete_event_type_input::Builder::default()
    }
}

/// See [`DeleteExternalModelInput`](crate::input::DeleteExternalModelInput)
pub mod delete_external_model_input {
    /// A builder for [`DeleteExternalModelInput`](crate::input::DeleteExternalModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_endpoint: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The endpoint of the Amazon Sagemaker model to delete.</p>
        pub fn model_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_endpoint = Some(input.into());
            self
        }
        /// <p>The endpoint of the Amazon Sagemaker model to delete.</p>
        pub fn set_model_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteExternalModelInput`](crate::input::DeleteExternalModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteExternalModelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteExternalModelInput {
                model_endpoint: self.model_endpoint,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteExternalModelInputOperationOutputAlias = crate::operation::DeleteExternalModel;
#[doc(hidden)]
pub type DeleteExternalModelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteExternalModelInput {
    /// Consumes the builder and constructs an Operation<[`DeleteExternalModel`](crate::operation::DeleteExternalModel)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteExternalModel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteExternalModelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteExternalModelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteExternalModelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.DeleteExternalModel",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_external_model(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteExternalModel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteExternalModel",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteExternalModelInput`](crate::input::DeleteExternalModelInput)
    pub fn builder() -> crate::input::delete_external_model_input::Builder {
        crate::input::delete_external_model_input::Builder::default()
    }
}

/// See [`DeleteLabelInput`](crate::input::DeleteLabelInput)
pub mod delete_label_input {
    /// A builder for [`DeleteLabelInput`](crate::input::DeleteLabelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the label to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the label to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLabelInput`](crate::input::DeleteLabelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteLabelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteLabelInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteLabelInputOperationOutputAlias = crate::operation::DeleteLabel;
#[doc(hidden)]
pub type DeleteLabelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteLabelInput {
    /// Consumes the builder and constructs an Operation<[`DeleteLabel`](crate::operation::DeleteLabel)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteLabel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteLabelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteLabelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteLabelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.DeleteLabel",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_label(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteLabel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteLabel",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteLabelInput`](crate::input::DeleteLabelInput)
    pub fn builder() -> crate::input::delete_label_input::Builder {
        crate::input::delete_label_input::Builder::default()
    }
}

/// See [`DeleteModelInput`](crate::input::DeleteModelInput)
pub mod delete_model_input {
    /// A builder for [`DeleteModelInput`](crate::input::DeleteModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_id: std::option::Option<std::string::String>,
        pub(crate) model_type: std::option::Option<crate::model::ModelTypeEnum>,
    }
    impl Builder {
        /// <p>The model ID of the model to delete.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_id = Some(input.into());
            self
        }
        /// <p>The model ID of the model to delete.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_id = input;
            self
        }
        /// <p>The model type of the model to delete.</p>
        pub fn model_type(mut self, input: crate::model::ModelTypeEnum) -> Self {
            self.model_type = Some(input);
            self
        }
        /// <p>The model type of the model to delete.</p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.model_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteModelInput`](crate::input::DeleteModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteModelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteModelInput {
                model_id: self.model_id,
                model_type: self.model_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteModelInputOperationOutputAlias = crate::operation::DeleteModel;
#[doc(hidden)]
pub type DeleteModelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteModelInput {
    /// Consumes the builder and constructs an Operation<[`DeleteModel`](crate::operation::DeleteModel)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteModel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteModelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteModelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteModelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.DeleteModel",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_model(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteModel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteModel",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteModelInput`](crate::input::DeleteModelInput)
    pub fn builder() -> crate::input::delete_model_input::Builder {
        crate::input::delete_model_input::Builder::default()
    }
}

/// See [`DeleteModelVersionInput`](crate::input::DeleteModelVersionInput)
pub mod delete_model_version_input {
    /// A builder for [`DeleteModelVersionInput`](crate::input::DeleteModelVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_id: std::option::Option<std::string::String>,
        pub(crate) model_type: std::option::Option<crate::model::ModelTypeEnum>,
        pub(crate) model_version_number: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The model ID of the model version to delete.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_id = Some(input.into());
            self
        }
        /// <p>The model ID of the model version to delete.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_id = input;
            self
        }
        /// <p>The model type of the model version to delete.</p>
        pub fn model_type(mut self, input: crate::model::ModelTypeEnum) -> Self {
            self.model_type = Some(input);
            self
        }
        /// <p>The model type of the model version to delete.</p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.model_type = input;
            self
        }
        /// <p>The model version number of the model version to delete.</p>
        pub fn model_version_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_version_number = Some(input.into());
            self
        }
        /// <p>The model version number of the model version to delete.</p>
        pub fn set_model_version_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_version_number = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteModelVersionInput`](crate::input::DeleteModelVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteModelVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteModelVersionInput {
                model_id: self.model_id,
                model_type: self.model_type,
                model_version_number: self.model_version_number,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteModelVersionInputOperationOutputAlias = crate::operation::DeleteModelVersion;
#[doc(hidden)]
pub type DeleteModelVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteModelVersionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteModelVersion`](crate::operation::DeleteModelVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteModelVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteModelVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteModelVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteModelVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.DeleteModelVersion",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_model_version(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteModelVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteModelVersion",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteModelVersionInput`](crate::input::DeleteModelVersionInput)
    pub fn builder() -> crate::input::delete_model_version_input::Builder {
        crate::input::delete_model_version_input::Builder::default()
    }
}

/// See [`DeleteOutcomeInput`](crate::input::DeleteOutcomeInput)
pub mod delete_outcome_input {
    /// A builder for [`DeleteOutcomeInput`](crate::input::DeleteOutcomeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the outcome to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the outcome to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteOutcomeInput`](crate::input::DeleteOutcomeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteOutcomeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteOutcomeInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteOutcomeInputOperationOutputAlias = crate::operation::DeleteOutcome;
#[doc(hidden)]
pub type DeleteOutcomeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteOutcomeInput {
    /// Consumes the builder and constructs an Operation<[`DeleteOutcome`](crate::operation::DeleteOutcome)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteOutcome,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteOutcomeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteOutcomeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteOutcomeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.DeleteOutcome",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_outcome(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteOutcome::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteOutcome",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteOutcomeInput`](crate::input::DeleteOutcomeInput)
    pub fn builder() -> crate::input::delete_outcome_input::Builder {
        crate::input::delete_outcome_input::Builder::default()
    }
}

/// See [`DeleteRuleInput`](crate::input::DeleteRuleInput)
pub mod delete_rule_input {
    /// A builder for [`DeleteRuleInput`](crate::input::DeleteRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule: std::option::Option<crate::model::Rule>,
    }
    impl Builder {
        /// <p>A rule.</p>
        pub fn rule(mut self, input: crate::model::Rule) -> Self {
            self.rule = Some(input);
            self
        }
        /// <p>A rule.</p>
        pub fn set_rule(mut self, input: std::option::Option<crate::model::Rule>) -> Self {
            self.rule = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRuleInput`](crate::input::DeleteRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRuleInput { rule: self.rule })
        }
    }
}
#[doc(hidden)]
pub type DeleteRuleInputOperationOutputAlias = crate::operation::DeleteRule;
#[doc(hidden)]
pub type DeleteRuleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteRuleInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRule`](crate::operation::DeleteRule)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.DeleteRule",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_rule(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRule",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteRuleInput`](crate::input::DeleteRuleInput)
    pub fn builder() -> crate::input::delete_rule_input::Builder {
        crate::input::delete_rule_input::Builder::default()
    }
}

/// See [`DeleteVariableInput`](crate::input::DeleteVariableInput)
pub mod delete_variable_input {
    /// A builder for [`DeleteVariableInput`](crate::input::DeleteVariableInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the variable to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the variable to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVariableInput`](crate::input::DeleteVariableInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteVariableInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteVariableInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteVariableInputOperationOutputAlias = crate::operation::DeleteVariable;
#[doc(hidden)]
pub type DeleteVariableInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteVariableInput {
    /// Consumes the builder and constructs an Operation<[`DeleteVariable`](crate::operation::DeleteVariable)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteVariable,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteVariableInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteVariableInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteVariableInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.DeleteVariable",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_variable(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteVariable::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteVariable",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteVariableInput`](crate::input::DeleteVariableInput)
    pub fn builder() -> crate::input::delete_variable_input::Builder {
        crate::input::delete_variable_input::Builder::default()
    }
}

/// See [`DescribeDetectorInput`](crate::input::DescribeDetectorInput)
pub mod describe_detector_input {
    /// A builder for [`DescribeDetectorInput`](crate::input::DescribeDetectorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The detector ID.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The detector ID.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The next token from the previous response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next token from the previous response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return for the request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return for the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDetectorInput`](crate::input::DescribeDetectorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDetectorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDetectorInput {
                detector_id: self.detector_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDetectorInputOperationOutputAlias = crate::operation::DescribeDetector;
#[doc(hidden)]
pub type DescribeDetectorInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDetectorInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDetector`](crate::operation::DescribeDetector)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDetector,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDetectorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDetectorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDetectorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.DescribeDetector",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_detector(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDetector::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDetector",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDetectorInput`](crate::input::DescribeDetectorInput)
    pub fn builder() -> crate::input::describe_detector_input::Builder {
        crate::input::describe_detector_input::Builder::default()
    }
}

/// See [`DescribeModelVersionsInput`](crate::input::DescribeModelVersionsInput)
pub mod describe_model_versions_input {
    /// A builder for [`DescribeModelVersionsInput`](crate::input::DescribeModelVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_id: std::option::Option<std::string::String>,
        pub(crate) model_version_number: std::option::Option<std::string::String>,
        pub(crate) model_type: std::option::Option<crate::model::ModelTypeEnum>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The model ID.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_id = Some(input.into());
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_id = input;
            self
        }
        /// <p>The model version number.</p>
        pub fn model_version_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_version_number = Some(input.into());
            self
        }
        /// <p>The model version number.</p>
        pub fn set_model_version_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_version_number = input;
            self
        }
        /// <p>The model type.</p>
        pub fn model_type(mut self, input: crate::model::ModelTypeEnum) -> Self {
            self.model_type = Some(input);
            self
        }
        /// <p>The model type.</p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.model_type = input;
            self
        }
        /// <p>The next token from the previous results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next token from the previous results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeModelVersionsInput`](crate::input::DescribeModelVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeModelVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeModelVersionsInput {
                model_id: self.model_id,
                model_version_number: self.model_version_number,
                model_type: self.model_type,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeModelVersionsInputOperationOutputAlias = crate::operation::DescribeModelVersions;
#[doc(hidden)]
pub type DescribeModelVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeModelVersionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeModelVersions`](crate::operation::DescribeModelVersions)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeModelVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeModelVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeModelVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeModelVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.DescribeModelVersions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_model_versions(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeModelVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeModelVersions",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeModelVersionsInput`](crate::input::DescribeModelVersionsInput)
    pub fn builder() -> crate::input::describe_model_versions_input::Builder {
        crate::input::describe_model_versions_input::Builder::default()
    }
}

/// See [`GetBatchImportJobsInput`](crate::input::GetBatchImportJobsInput)
pub mod get_batch_import_jobs_input {
    /// A builder for [`GetBatchImportJobsInput`](crate::input::GetBatchImportJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the batch import job to get.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID of the batch import job to get.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The maximum number of objects to return for request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of objects to return for request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The next token from the previous request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next token from the previous request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBatchImportJobsInput`](crate::input::GetBatchImportJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBatchImportJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBatchImportJobsInput {
                job_id: self.job_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBatchImportJobsInputOperationOutputAlias = crate::operation::GetBatchImportJobs;
#[doc(hidden)]
pub type GetBatchImportJobsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetBatchImportJobsInput {
    /// Consumes the builder and constructs an Operation<[`GetBatchImportJobs`](crate::operation::GetBatchImportJobs)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBatchImportJobs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBatchImportJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBatchImportJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBatchImportJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.GetBatchImportJobs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_batch_import_jobs(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBatchImportJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBatchImportJobs",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBatchImportJobsInput`](crate::input::GetBatchImportJobsInput)
    pub fn builder() -> crate::input::get_batch_import_jobs_input::Builder {
        crate::input::get_batch_import_jobs_input::Builder::default()
    }
}

/// See [`GetBatchPredictionJobsInput`](crate::input::GetBatchPredictionJobsInput)
pub mod get_batch_prediction_jobs_input {
    /// A builder for [`GetBatchPredictionJobsInput`](crate::input::GetBatchPredictionJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The batch prediction job for which to get the details.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The batch prediction job for which to get the details.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The next token from the previous request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next token from the previous request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBatchPredictionJobsInput`](crate::input::GetBatchPredictionJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBatchPredictionJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBatchPredictionJobsInput {
                job_id: self.job_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBatchPredictionJobsInputOperationOutputAlias = crate::operation::GetBatchPredictionJobs;
#[doc(hidden)]
pub type GetBatchPredictionJobsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetBatchPredictionJobsInput {
    /// Consumes the builder and constructs an Operation<[`GetBatchPredictionJobs`](crate::operation::GetBatchPredictionJobs)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBatchPredictionJobs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBatchPredictionJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBatchPredictionJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBatchPredictionJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.GetBatchPredictionJobs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_batch_prediction_jobs(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBatchPredictionJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBatchPredictionJobs",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBatchPredictionJobsInput`](crate::input::GetBatchPredictionJobsInput)
    pub fn builder() -> crate::input::get_batch_prediction_jobs_input::Builder {
        crate::input::get_batch_prediction_jobs_input::Builder::default()
    }
}

/// See [`GetDeleteEventsByEventTypeStatusInput`](crate::input::GetDeleteEventsByEventTypeStatusInput)
pub mod get_delete_events_by_event_type_status_input {
    /// A builder for [`GetDeleteEventsByEventTypeStatusInput`](crate::input::GetDeleteEventsByEventTypeStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_type_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of event type for which to get the deletion status.</p>
        pub fn event_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_type_name = Some(input.into());
            self
        }
        /// <p>Name of event type for which to get the deletion status.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_type_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeleteEventsByEventTypeStatusInput`](crate::input::GetDeleteEventsByEventTypeStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDeleteEventsByEventTypeStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDeleteEventsByEventTypeStatusInput {
                event_type_name: self.event_type_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDeleteEventsByEventTypeStatusInputOperationOutputAlias =
    crate::operation::GetDeleteEventsByEventTypeStatus;
#[doc(hidden)]
pub type GetDeleteEventsByEventTypeStatusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDeleteEventsByEventTypeStatusInput {
    /// Consumes the builder and constructs an Operation<[`GetDeleteEventsByEventTypeStatus`](crate::operation::GetDeleteEventsByEventTypeStatus)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDeleteEventsByEventTypeStatus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDeleteEventsByEventTypeStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDeleteEventsByEventTypeStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDeleteEventsByEventTypeStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.GetDeleteEventsByEventTypeStatus",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_delete_events_by_event_type_status(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDeleteEventsByEventTypeStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDeleteEventsByEventTypeStatus",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDeleteEventsByEventTypeStatusInput`](crate::input::GetDeleteEventsByEventTypeStatusInput)
    pub fn builder() -> crate::input::get_delete_events_by_event_type_status_input::Builder {
        crate::input::get_delete_events_by_event_type_status_input::Builder::default()
    }
}

/// See [`GetDetectorsInput`](crate::input::GetDetectorsInput)
pub mod get_detectors_input {
    /// A builder for [`GetDetectorsInput`](crate::input::GetDetectorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The detector ID.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The detector ID.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The next token for the subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next token for the subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDetectorsInput`](crate::input::GetDetectorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDetectorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDetectorsInput {
                detector_id: self.detector_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDetectorsInputOperationOutputAlias = crate::operation::GetDetectors;
#[doc(hidden)]
pub type GetDetectorsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDetectorsInput {
    /// Consumes the builder and constructs an Operation<[`GetDetectors`](crate::operation::GetDetectors)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDetectors,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDetectorsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDetectorsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDetectorsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.GetDetectors",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_detectors(&self)
            .map_err(|err| {
            aws_smithy_http::operation::BuildError::SerializationError(err.into())
        })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDetectors::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDetectors",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDetectorsInput`](crate::input::GetDetectorsInput)
    pub fn builder() -> crate::input::get_detectors_input::Builder {
        crate::input::get_detectors_input::Builder::default()
    }
}

/// See [`GetDetectorVersionInput`](crate::input::GetDetectorVersionInput)
pub mod get_detector_version_input {
    /// A builder for [`GetDetectorVersionInput`](crate::input::GetDetectorVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) detector_version_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The detector ID.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The detector ID.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The detector version ID.</p>
        pub fn detector_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_version_id = Some(input.into());
            self
        }
        /// <p>The detector version ID.</p>
        pub fn set_detector_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDetectorVersionInput`](crate::input::GetDetectorVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDetectorVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDetectorVersionInput {
                detector_id: self.detector_id,
                detector_version_id: self.detector_version_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDetectorVersionInputOperationOutputAlias = crate::operation::GetDetectorVersion;
#[doc(hidden)]
pub type GetDetectorVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDetectorVersionInput {
    /// Consumes the builder and constructs an Operation<[`GetDetectorVersion`](crate::operation::GetDetectorVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDetectorVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDetectorVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDetectorVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDetectorVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.GetDetectorVersion",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_detector_version(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDetectorVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDetectorVersion",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDetectorVersionInput`](crate::input::GetDetectorVersionInput)
    pub fn builder() -> crate::input::get_detector_version_input::Builder {
        crate::input::get_detector_version_input::Builder::default()
    }
}

/// See [`GetEntityTypesInput`](crate::input::GetEntityTypesInput)
pub mod get_entity_types_input {
    /// A builder for [`GetEntityTypesInput`](crate::input::GetEntityTypesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The next token for the subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next token for the subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEntityTypesInput`](crate::input::GetEntityTypesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEntityTypesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEntityTypesInput {
                name: self.name,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEntityTypesInputOperationOutputAlias = crate::operation::GetEntityTypes;
#[doc(hidden)]
pub type GetEntityTypesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetEntityTypesInput {
    /// Consumes the builder and constructs an Operation<[`GetEntityTypes`](crate::operation::GetEntityTypes)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEntityTypes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetEntityTypesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetEntityTypesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetEntityTypesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.GetEntityTypes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_entity_types(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEntityTypes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEntityTypes",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetEntityTypesInput`](crate::input::GetEntityTypesInput)
    pub fn builder() -> crate::input::get_entity_types_input::Builder {
        crate::input::get_entity_types_input::Builder::default()
    }
}

/// See [`GetEventInput`](crate::input::GetEventInput)
pub mod get_event_input {
    /// A builder for [`GetEventInput`](crate::input::GetEventInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_id: std::option::Option<std::string::String>,
        pub(crate) event_type_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the event to retrieve.</p>
        pub fn event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_id = Some(input.into());
            self
        }
        /// <p>The ID of the event to retrieve.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_id = input;
            self
        }
        /// <p>The event type of the event to retrieve.</p>
        pub fn event_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_type_name = Some(input.into());
            self
        }
        /// <p>The event type of the event to retrieve.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_type_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEventInput`](crate::input::GetEventInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetEventInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetEventInput {
                event_id: self.event_id,
                event_type_name: self.event_type_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEventInputOperationOutputAlias = crate::operation::GetEvent;
#[doc(hidden)]
pub type GetEventInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetEventInput {
    /// Consumes the builder and constructs an Operation<[`GetEvent`](crate::operation::GetEvent)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEvent,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetEventInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetEventInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetEventInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.GetEvent",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_event(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetEvent::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetEvent",
                    "frauddetector",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetEventInput`](crate::input::GetEventInput)
    pub fn builder() -> crate::input::get_event_input::Builder {
        crate::input::get_event_input::Builder::default()
    }
}

/// See [`GetEventPredictionInput`](crate::input::GetEventPredictionInput)
pub mod get_event_prediction_input {
    /// A builder for [`GetEventPredictionInput`](crate::input::GetEventPredictionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) detector_version_id: std::option::Option<std::string::String>,
        pub(crate) event_id: std::option::Option<std::string::String>,
        pub(crate) event_type_name: std::option::Option<std::string::String>,
        pub(crate) entities: std::option::Option<std::vec::Vec<crate::model::Entity>>,
        pub(crate) event_timestamp: std::option::Option<std::string::String>,
        pub(crate) event_variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) external_model_endpoint_data_blobs: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ModelEndpointDataBlob>,
        >,
    }
    impl Builder {
        /// <p>The detector ID.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The detector ID.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The detector version ID.</p>
        pub fn detector_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_version_id = Some(input.into());
            self
        }
        /// <p>The detector version ID.</p>
        pub fn set_detector_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_version_id = input;
            self
        }
        /// <p>The unique ID used to identify the event.</p>
        pub fn event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_id = Some(input.into());
            self
        }
        /// <p>The unique ID used to identify the event.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_id = input;
            self
        }
        /// <p>The event type associated with the detector specified for the prediction.</p>
        pub fn event_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_type_name = Some(input.into());
            self
        }
        /// <p>The event type associated with the detector specified for the prediction.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_type_name = input;
            self
        }
        /// Appends an item to `entities`.
        ///
        /// To override the contents of this collection use [`set_entities`](Self::set_entities).
        ///
        /// <p>The entity type (associated with the detector's event type) and specific entity ID representing who performed the event. If an entity id is not available, use "UNKNOWN."</p>
        pub fn entities(mut self, input: impl Into<crate::model::Entity>) -> Self {
            let mut v = self.entities.unwrap_or_default();
            v.push(input.into());
            self.entities = Some(v);
            self
        }
        /// <p>The entity type (associated with the detector's event type) and specific entity ID representing who performed the event. If an entity id is not available, use "UNKNOWN."</p>
        pub fn set_entities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Entity>>,
        ) -> Self {
            self.entities = input;
            self
        }
        /// <p>Timestamp that defines when the event under evaluation occurred. The timestamp must be specified using ISO 8601 standard in UTC.</p>
        pub fn event_timestamp(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_timestamp = Some(input.into());
            self
        }
        /// <p>Timestamp that defines when the event under evaluation occurred. The timestamp must be specified using ISO 8601 standard in UTC.</p>
        pub fn set_event_timestamp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_timestamp = input;
            self
        }
        /// Adds a key-value pair to `event_variables`.
        ///
        /// To override the contents of this collection use [`set_event_variables`](Self::set_event_variables).
        ///
        /// <p>Names of the event type's variables you defined in Amazon Fraud Detector to represent data elements and
        /// their corresponding values for the event you are sending for evaluation.</p>
        /// <important>         
        /// <p>You must provide at least one eventVariable</p>        
        /// </important>
        ///
        /// <p>To ensure most accurate fraud prediction and to simplify your data preparation, Amazon Fraud Detector will replace all missing variables or values as follows:</p>
        ///
        /// <p>
        /// <b>For Amazon Fraud Detector trained models:</b>
        /// </p>
        /// <p>If a null value is provided explicitly for a variable or if a variable is missing, model will replace the null value or the missing variable (no variable name in the eventVariables map)
        /// with calculated default mean/medians for numeric variables and with special values for categorical variables.</p>
        ///
        /// <p>
        /// <b>For imported SageMaker models:</b>
        /// </p>
        /// <p>If a null value is provided explicitly for a variable, the model and rules will use “null” as the value. If a variable is not provided (no variable name in the eventVariables map), model and rules
        /// will use the default value that is provided for the variable. </p>
        pub fn event_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.event_variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.event_variables = Some(hash_map);
            self
        }
        /// <p>Names of the event type's variables you defined in Amazon Fraud Detector to represent data elements and
        /// their corresponding values for the event you are sending for evaluation.</p>
        /// <important>         
        /// <p>You must provide at least one eventVariable</p>        
        /// </important>
        ///
        /// <p>To ensure most accurate fraud prediction and to simplify your data preparation, Amazon Fraud Detector will replace all missing variables or values as follows:</p>
        ///
        /// <p>
        /// <b>For Amazon Fraud Detector trained models:</b>
        /// </p>
        /// <p>If a null value is provided explicitly for a variable or if a variable is missing, model will replace the null value or the missing variable (no variable name in the eventVariables map)
        /// with calculated default mean/medians for numeric variables and with special values for categorical variables.</p>
        ///
        /// <p>
        /// <b>For imported SageMaker models:</b>
        /// </p>
        /// <p>If a null value is provided explicitly for a variable, the model and rules will use “null” as the value. If a variable is not provided (no variable name in the eventVariables map), model and rules
        /// will use the default value that is provided for the variable. </p>
        pub fn set_event_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.event_variables = input;
            self
        }
        /// Adds a key-value pair to `external_model_endpoint_data_blobs`.
        ///
        /// To override the contents of this collection use [`set_external_model_endpoint_data_blobs`](Self::set_external_model_endpoint_data_blobs).
        ///
        /// <p>The Amazon SageMaker model endpoint input data blobs.</p>
        pub fn external_model_endpoint_data_blobs(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ModelEndpointDataBlob>,
        ) -> Self {
            let mut hash_map = self.external_model_endpoint_data_blobs.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.external_model_endpoint_data_blobs = Some(hash_map);
            self
        }
        /// <p>The Amazon SageMaker model endpoint input data blobs.</p>
        pub fn set_external_model_endpoint_data_blobs(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ModelEndpointDataBlob>,
            >,
        ) -> Self {
            self.external_model_endpoint_data_blobs = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEventPredictionInput`](crate::input::GetEventPredictionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEventPredictionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEventPredictionInput {
                detector_id: self.detector_id,
                detector_version_id: self.detector_version_id,
                event_id: self.event_id,
                event_type_name: self.event_type_name,
                entities: self.entities,
                event_timestamp: self.event_timestamp,
                event_variables: self.event_variables,
                external_model_endpoint_data_blobs: self.external_model_endpoint_data_blobs,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEventPredictionInputOperationOutputAlias = crate::operation::GetEventPrediction;
#[doc(hidden)]
pub type GetEventPredictionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetEventPredictionInput {
    /// Consumes the builder and constructs an Operation<[`GetEventPrediction`](crate::operation::GetEventPrediction)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEventPrediction,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetEventPredictionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetEventPredictionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetEventPredictionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.GetEventPrediction",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_event_prediction(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEventPrediction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEventPrediction",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetEventPredictionInput`](crate::input::GetEventPredictionInput)
    pub fn builder() -> crate::input::get_event_prediction_input::Builder {
        crate::input::get_event_prediction_input::Builder::default()
    }
}

/// See [`GetEventTypesInput`](crate::input::GetEventTypesInput)
pub mod get_event_types_input {
    /// A builder for [`GetEventTypesInput`](crate::input::GetEventTypesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The next token for the subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next token for the subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEventTypesInput`](crate::input::GetEventTypesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEventTypesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEventTypesInput {
                name: self.name,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEventTypesInputOperationOutputAlias = crate::operation::GetEventTypes;
#[doc(hidden)]
pub type GetEventTypesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetEventTypesInput {
    /// Consumes the builder and constructs an Operation<[`GetEventTypes`](crate::operation::GetEventTypes)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEventTypes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetEventTypesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetEventTypesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetEventTypesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.GetEventTypes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_event_types(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEventTypes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEventTypes",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetEventTypesInput`](crate::input::GetEventTypesInput)
    pub fn builder() -> crate::input::get_event_types_input::Builder {
        crate::input::get_event_types_input::Builder::default()
    }
}

/// See [`GetExternalModelsInput`](crate::input::GetExternalModelsInput)
pub mod get_external_models_input {
    /// A builder for [`GetExternalModelsInput`](crate::input::GetExternalModelsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_endpoint: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon SageMaker model endpoint.</p>
        pub fn model_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_endpoint = Some(input.into());
            self
        }
        /// <p>The Amazon SageMaker model endpoint.</p>
        pub fn set_model_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_endpoint = input;
            self
        }
        /// <p>The next page token for the request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page token for the request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetExternalModelsInput`](crate::input::GetExternalModelsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetExternalModelsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetExternalModelsInput {
                model_endpoint: self.model_endpoint,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetExternalModelsInputOperationOutputAlias = crate::operation::GetExternalModels;
#[doc(hidden)]
pub type GetExternalModelsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetExternalModelsInput {
    /// Consumes the builder and constructs an Operation<[`GetExternalModels`](crate::operation::GetExternalModels)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetExternalModels,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetExternalModelsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetExternalModelsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetExternalModelsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.GetExternalModels",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_external_models(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetExternalModels::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetExternalModels",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetExternalModelsInput`](crate::input::GetExternalModelsInput)
    pub fn builder() -> crate::input::get_external_models_input::Builder {
        crate::input::get_external_models_input::Builder::default()
    }
}

/// See [`GetKmsEncryptionKeyInput`](crate::input::GetKmsEncryptionKeyInput)
pub mod get_kms_encryption_key_input {
    /// A builder for [`GetKmsEncryptionKeyInput`](crate::input::GetKmsEncryptionKeyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetKmsEncryptionKeyInput`](crate::input::GetKmsEncryptionKeyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetKmsEncryptionKeyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetKmsEncryptionKeyInput {})
        }
    }
}
#[doc(hidden)]
pub type GetKmsEncryptionKeyInputOperationOutputAlias = crate::operation::GetKMSEncryptionKey;
#[doc(hidden)]
pub type GetKmsEncryptionKeyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetKmsEncryptionKeyInput {
    /// Consumes the builder and constructs an Operation<[`GetKMSEncryptionKey`](crate::operation::GetKMSEncryptionKey)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetKMSEncryptionKey,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetKmsEncryptionKeyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetKmsEncryptionKeyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetKmsEncryptionKeyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.GetKMSEncryptionKey",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_kms_encryption_key(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetKMSEncryptionKey::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetKMSEncryptionKey",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetKmsEncryptionKeyInput`](crate::input::GetKmsEncryptionKeyInput)
    pub fn builder() -> crate::input::get_kms_encryption_key_input::Builder {
        crate::input::get_kms_encryption_key_input::Builder::default()
    }
}

/// See [`GetLabelsInput`](crate::input::GetLabelsInput)
pub mod get_labels_input {
    /// A builder for [`GetLabelsInput`](crate::input::GetLabelsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the label or labels to get.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the label or labels to get.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The next token for the subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next token for the subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLabelsInput`](crate::input::GetLabelsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetLabelsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetLabelsInput {
                name: self.name,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetLabelsInputOperationOutputAlias = crate::operation::GetLabels;
#[doc(hidden)]
pub type GetLabelsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetLabelsInput {
    /// Consumes the builder and constructs an Operation<[`GetLabels`](crate::operation::GetLabels)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLabels,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetLabelsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetLabelsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetLabelsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.GetLabels",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_labels(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetLabels::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetLabels",
                    "frauddetector",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetLabelsInput`](crate::input::GetLabelsInput)
    pub fn builder() -> crate::input::get_labels_input::Builder {
        crate::input::get_labels_input::Builder::default()
    }
}

/// See [`GetModelsInput`](crate::input::GetModelsInput)
pub mod get_models_input {
    /// A builder for [`GetModelsInput`](crate::input::GetModelsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_id: std::option::Option<std::string::String>,
        pub(crate) model_type: std::option::Option<crate::model::ModelTypeEnum>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The model ID.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_id = Some(input.into());
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_id = input;
            self
        }
        /// <p>The model type.</p>
        pub fn model_type(mut self, input: crate::model::ModelTypeEnum) -> Self {
            self.model_type = Some(input);
            self
        }
        /// <p>The model type.</p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.model_type = input;
            self
        }
        /// <p>The next token for the subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next token for the subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of objects to return for the request. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of objects to return for the request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetModelsInput`](crate::input::GetModelsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetModelsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetModelsInput {
                model_id: self.model_id,
                model_type: self.model_type,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetModelsInputOperationOutputAlias = crate::operation::GetModels;
#[doc(hidden)]
pub type GetModelsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetModelsInput {
    /// Consumes the builder and constructs an Operation<[`GetModels`](crate::operation::GetModels)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetModels,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetModelsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetModelsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetModelsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.GetModels",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_models(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetModels::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetModels",
                    "frauddetector",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetModelsInput`](crate::input::GetModelsInput)
    pub fn builder() -> crate::input::get_models_input::Builder {
        crate::input::get_models_input::Builder::default()
    }
}

/// See [`GetModelVersionInput`](crate::input::GetModelVersionInput)
pub mod get_model_version_input {
    /// A builder for [`GetModelVersionInput`](crate::input::GetModelVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_id: std::option::Option<std::string::String>,
        pub(crate) model_type: std::option::Option<crate::model::ModelTypeEnum>,
        pub(crate) model_version_number: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The model ID.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_id = Some(input.into());
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_id = input;
            self
        }
        /// <p>The model type.</p>
        pub fn model_type(mut self, input: crate::model::ModelTypeEnum) -> Self {
            self.model_type = Some(input);
            self
        }
        /// <p>The model type.</p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.model_type = input;
            self
        }
        /// <p>The model version number.</p>
        pub fn model_version_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_version_number = Some(input.into());
            self
        }
        /// <p>The model version number.</p>
        pub fn set_model_version_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_version_number = input;
            self
        }
        /// Consumes the builder and constructs a [`GetModelVersionInput`](crate::input::GetModelVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetModelVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetModelVersionInput {
                model_id: self.model_id,
                model_type: self.model_type,
                model_version_number: self.model_version_number,
            })
        }
    }
}
#[doc(hidden)]
pub type GetModelVersionInputOperationOutputAlias = crate::operation::GetModelVersion;
#[doc(hidden)]
pub type GetModelVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetModelVersionInput {
    /// Consumes the builder and constructs an Operation<[`GetModelVersion`](crate::operation::GetModelVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetModelVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetModelVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetModelVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetModelVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.GetModelVersion",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_model_version(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetModelVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetModelVersion",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetModelVersionInput`](crate::input::GetModelVersionInput)
    pub fn builder() -> crate::input::get_model_version_input::Builder {
        crate::input::get_model_version_input::Builder::default()
    }
}

/// See [`GetOutcomesInput`](crate::input::GetOutcomesInput)
pub mod get_outcomes_input {
    /// A builder for [`GetOutcomesInput`](crate::input::GetOutcomesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the outcome or outcomes to get.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the outcome or outcomes to get.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The next page token for the request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page token for the request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of objects to return for the request. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of objects to return for the request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOutcomesInput`](crate::input::GetOutcomesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetOutcomesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetOutcomesInput {
                name: self.name,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetOutcomesInputOperationOutputAlias = crate::operation::GetOutcomes;
#[doc(hidden)]
pub type GetOutcomesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetOutcomesInput {
    /// Consumes the builder and constructs an Operation<[`GetOutcomes`](crate::operation::GetOutcomes)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetOutcomes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetOutcomesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetOutcomesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetOutcomesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.GetOutcomes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_outcomes(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetOutcomes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetOutcomes",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetOutcomesInput`](crate::input::GetOutcomesInput)
    pub fn builder() -> crate::input::get_outcomes_input::Builder {
        crate::input::get_outcomes_input::Builder::default()
    }
}

/// See [`GetRulesInput`](crate::input::GetRulesInput)
pub mod get_rules_input {
    /// A builder for [`GetRulesInput`](crate::input::GetRulesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_id: std::option::Option<std::string::String>,
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) rule_version: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The rule ID.</p>
        pub fn rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_id = Some(input.into());
            self
        }
        /// <p>The rule ID.</p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_id = input;
            self
        }
        /// <p>The detector ID.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The detector ID.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The rule version.</p>
        pub fn rule_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_version = Some(input.into());
            self
        }
        /// <p>The rule version.</p>
        pub fn set_rule_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_version = input;
            self
        }
        /// <p>The next page token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of rules to return for the request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of rules to return for the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRulesInput`](crate::input::GetRulesInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetRulesInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetRulesInput {
                rule_id: self.rule_id,
                detector_id: self.detector_id,
                rule_version: self.rule_version,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRulesInputOperationOutputAlias = crate::operation::GetRules;
#[doc(hidden)]
pub type GetRulesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetRulesInput {
    /// Consumes the builder and constructs an Operation<[`GetRules`](crate::operation::GetRules)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRules,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetRulesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetRulesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetRulesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.GetRules",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_rules(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetRules::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetRules",
                    "frauddetector",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetRulesInput`](crate::input::GetRulesInput)
    pub fn builder() -> crate::input::get_rules_input::Builder {
        crate::input::get_rules_input::Builder::default()
    }
}

/// See [`GetVariablesInput`](crate::input::GetVariablesInput)
pub mod get_variables_input {
    /// A builder for [`GetVariablesInput`](crate::input::GetVariablesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the variable. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the variable. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The next page token of the get variable request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next page token of the get variable request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The max size per page determined for the get variable request. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The max size per page determined for the get variable request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetVariablesInput`](crate::input::GetVariablesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetVariablesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetVariablesInput {
                name: self.name,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetVariablesInputOperationOutputAlias = crate::operation::GetVariables;
#[doc(hidden)]
pub type GetVariablesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetVariablesInput {
    /// Consumes the builder and constructs an Operation<[`GetVariables`](crate::operation::GetVariables)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetVariables,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetVariablesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetVariablesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetVariablesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.GetVariables",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_variables(&self)
            .map_err(|err| {
            aws_smithy_http::operation::BuildError::SerializationError(err.into())
        })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetVariables::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetVariables",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetVariablesInput`](crate::input::GetVariablesInput)
    pub fn builder() -> crate::input::get_variables_input::Builder {
        crate::input::get_variables_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ARN that specifies the resource whose tags you want to list.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN that specifies the resource whose tags you want to list.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The next token from the previous results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next token from the previous results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of objects to return for the request. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of objects to return for the request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.ListTagsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`PutDetectorInput`](crate::input::PutDetectorInput)
pub mod put_detector_input {
    /// A builder for [`PutDetectorInput`](crate::input::PutDetectorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) event_type_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The detector ID. </p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The detector ID. </p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The description of the detector.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the detector.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name of the event type.</p>
        pub fn event_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_type_name = Some(input.into());
            self
        }
        /// <p>The name of the event type.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_type_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`PutDetectorInput`](crate::input::PutDetectorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutDetectorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutDetectorInput {
                detector_id: self.detector_id,
                description: self.description,
                event_type_name: self.event_type_name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type PutDetectorInputOperationOutputAlias = crate::operation::PutDetector;
#[doc(hidden)]
pub type PutDetectorInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutDetectorInput {
    /// Consumes the builder and constructs an Operation<[`PutDetector`](crate::operation::PutDetector)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutDetector,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutDetectorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutDetectorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutDetectorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.PutDetector",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_put_detector(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutDetector::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutDetector",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutDetectorInput`](crate::input::PutDetectorInput)
    pub fn builder() -> crate::input::put_detector_input::Builder {
        crate::input::put_detector_input::Builder::default()
    }
}

/// See [`PutEntityTypeInput`](crate::input::PutEntityTypeInput)
pub mod put_entity_type_input {
    /// A builder for [`PutEntityTypeInput`](crate::input::PutEntityTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the entity type.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the entity type.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`PutEntityTypeInput`](crate::input::PutEntityTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutEntityTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutEntityTypeInput {
                name: self.name,
                description: self.description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type PutEntityTypeInputOperationOutputAlias = crate::operation::PutEntityType;
#[doc(hidden)]
pub type PutEntityTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutEntityTypeInput {
    /// Consumes the builder and constructs an Operation<[`PutEntityType`](crate::operation::PutEntityType)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutEntityType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutEntityTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutEntityTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutEntityTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.PutEntityType",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_put_entity_type(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutEntityType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutEntityType",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutEntityTypeInput`](crate::input::PutEntityTypeInput)
    pub fn builder() -> crate::input::put_entity_type_input::Builder {
        crate::input::put_entity_type_input::Builder::default()
    }
}

/// See [`PutEventTypeInput`](crate::input::PutEventTypeInput)
pub mod put_event_type_input {
    /// A builder for [`PutEventTypeInput`](crate::input::PutEventTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) event_variables: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) labels: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) entity_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) event_ingestion: std::option::Option<crate::model::EventIngestion>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the event type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the event type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `event_variables`.
        ///
        /// To override the contents of this collection use [`set_event_variables`](Self::set_event_variables).
        ///
        /// <p>The event type variables.</p>
        pub fn event_variables(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_variables.unwrap_or_default();
            v.push(input.into());
            self.event_variables = Some(v);
            self
        }
        /// <p>The event type variables.</p>
        pub fn set_event_variables(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_variables = input;
            self
        }
        /// Appends an item to `labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// <p>The event type labels.</p>
        pub fn labels(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.labels.unwrap_or_default();
            v.push(input.into());
            self.labels = Some(v);
            self
        }
        /// <p>The event type labels.</p>
        pub fn set_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.labels = input;
            self
        }
        /// Appends an item to `entity_types`.
        ///
        /// To override the contents of this collection use [`set_entity_types`](Self::set_entity_types).
        ///
        /// <p>The entity type for the event type. Example entity types: customer, merchant, account.</p>
        pub fn entity_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.entity_types.unwrap_or_default();
            v.push(input.into());
            self.entity_types = Some(v);
            self
        }
        /// <p>The entity type for the event type. Example entity types: customer, merchant, account.</p>
        pub fn set_entity_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.entity_types = input;
            self
        }
        /// <p>Specifies if ingenstion is enabled or disabled.</p>
        pub fn event_ingestion(mut self, input: crate::model::EventIngestion) -> Self {
            self.event_ingestion = Some(input);
            self
        }
        /// <p>Specifies if ingenstion is enabled or disabled.</p>
        pub fn set_event_ingestion(
            mut self,
            input: std::option::Option<crate::model::EventIngestion>,
        ) -> Self {
            self.event_ingestion = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`PutEventTypeInput`](crate::input::PutEventTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutEventTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutEventTypeInput {
                name: self.name,
                description: self.description,
                event_variables: self.event_variables,
                labels: self.labels,
                entity_types: self.entity_types,
                event_ingestion: self.event_ingestion,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type PutEventTypeInputOperationOutputAlias = crate::operation::PutEventType;
#[doc(hidden)]
pub type PutEventTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutEventTypeInput {
    /// Consumes the builder and constructs an Operation<[`PutEventType`](crate::operation::PutEventType)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutEventType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutEventTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutEventTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutEventTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.PutEventType",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_put_event_type(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutEventType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutEventType",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutEventTypeInput`](crate::input::PutEventTypeInput)
    pub fn builder() -> crate::input::put_event_type_input::Builder {
        crate::input::put_event_type_input::Builder::default()
    }
}

/// See [`PutExternalModelInput`](crate::input::PutExternalModelInput)
pub mod put_external_model_input {
    /// A builder for [`PutExternalModelInput`](crate::input::PutExternalModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_endpoint: std::option::Option<std::string::String>,
        pub(crate) model_source: std::option::Option<crate::model::ModelSource>,
        pub(crate) invoke_model_endpoint_role_arn: std::option::Option<std::string::String>,
        pub(crate) input_configuration: std::option::Option<crate::model::ModelInputConfiguration>,
        pub(crate) output_configuration:
            std::option::Option<crate::model::ModelOutputConfiguration>,
        pub(crate) model_endpoint_status: std::option::Option<crate::model::ModelEndpointStatus>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The model endpoints name.</p>
        pub fn model_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_endpoint = Some(input.into());
            self
        }
        /// <p>The model endpoints name.</p>
        pub fn set_model_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_endpoint = input;
            self
        }
        /// <p>The source of the model.</p>
        pub fn model_source(mut self, input: crate::model::ModelSource) -> Self {
            self.model_source = Some(input);
            self
        }
        /// <p>The source of the model.</p>
        pub fn set_model_source(
            mut self,
            input: std::option::Option<crate::model::ModelSource>,
        ) -> Self {
            self.model_source = input;
            self
        }
        /// <p>The IAM role used to invoke the model endpoint.</p>
        pub fn invoke_model_endpoint_role_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.invoke_model_endpoint_role_arn = Some(input.into());
            self
        }
        /// <p>The IAM role used to invoke the model endpoint.</p>
        pub fn set_invoke_model_endpoint_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.invoke_model_endpoint_role_arn = input;
            self
        }
        /// <p>The model endpoint input configuration.</p>
        pub fn input_configuration(mut self, input: crate::model::ModelInputConfiguration) -> Self {
            self.input_configuration = Some(input);
            self
        }
        /// <p>The model endpoint input configuration.</p>
        pub fn set_input_configuration(
            mut self,
            input: std::option::Option<crate::model::ModelInputConfiguration>,
        ) -> Self {
            self.input_configuration = input;
            self
        }
        /// <p>The model endpoint output configuration.</p>
        pub fn output_configuration(
            mut self,
            input: crate::model::ModelOutputConfiguration,
        ) -> Self {
            self.output_configuration = Some(input);
            self
        }
        /// <p>The model endpoint output configuration.</p>
        pub fn set_output_configuration(
            mut self,
            input: std::option::Option<crate::model::ModelOutputConfiguration>,
        ) -> Self {
            self.output_configuration = input;
            self
        }
        /// <p>The model endpoint’s status in Amazon Fraud Detector.</p>
        pub fn model_endpoint_status(mut self, input: crate::model::ModelEndpointStatus) -> Self {
            self.model_endpoint_status = Some(input);
            self
        }
        /// <p>The model endpoint’s status in Amazon Fraud Detector.</p>
        pub fn set_model_endpoint_status(
            mut self,
            input: std::option::Option<crate::model::ModelEndpointStatus>,
        ) -> Self {
            self.model_endpoint_status = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`PutExternalModelInput`](crate::input::PutExternalModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutExternalModelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutExternalModelInput {
                model_endpoint: self.model_endpoint,
                model_source: self.model_source,
                invoke_model_endpoint_role_arn: self.invoke_model_endpoint_role_arn,
                input_configuration: self.input_configuration,
                output_configuration: self.output_configuration,
                model_endpoint_status: self.model_endpoint_status,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type PutExternalModelInputOperationOutputAlias = crate::operation::PutExternalModel;
#[doc(hidden)]
pub type PutExternalModelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutExternalModelInput {
    /// Consumes the builder and constructs an Operation<[`PutExternalModel`](crate::operation::PutExternalModel)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutExternalModel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutExternalModelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutExternalModelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutExternalModelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.PutExternalModel",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_external_model(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutExternalModel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutExternalModel",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutExternalModelInput`](crate::input::PutExternalModelInput)
    pub fn builder() -> crate::input::put_external_model_input::Builder {
        crate::input::put_external_model_input::Builder::default()
    }
}

/// See [`PutKmsEncryptionKeyInput`](crate::input::PutKmsEncryptionKeyInput)
pub mod put_kms_encryption_key_input {
    /// A builder for [`PutKmsEncryptionKeyInput`](crate::input::PutKmsEncryptionKeyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) kms_encryption_key_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The KMS encryption key ARN.</p>
        pub fn kms_encryption_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_encryption_key_arn = Some(input.into());
            self
        }
        /// <p>The KMS encryption key ARN.</p>
        pub fn set_kms_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.kms_encryption_key_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`PutKmsEncryptionKeyInput`](crate::input::PutKmsEncryptionKeyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutKmsEncryptionKeyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutKmsEncryptionKeyInput {
                kms_encryption_key_arn: self.kms_encryption_key_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type PutKmsEncryptionKeyInputOperationOutputAlias = crate::operation::PutKMSEncryptionKey;
#[doc(hidden)]
pub type PutKmsEncryptionKeyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutKmsEncryptionKeyInput {
    /// Consumes the builder and constructs an Operation<[`PutKMSEncryptionKey`](crate::operation::PutKMSEncryptionKey)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutKMSEncryptionKey,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutKmsEncryptionKeyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutKmsEncryptionKeyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutKmsEncryptionKeyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.PutKMSEncryptionKey",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_kms_encryption_key(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutKMSEncryptionKey::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutKMSEncryptionKey",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutKmsEncryptionKeyInput`](crate::input::PutKmsEncryptionKeyInput)
    pub fn builder() -> crate::input::put_kms_encryption_key_input::Builder {
        crate::input::put_kms_encryption_key_input::Builder::default()
    }
}

/// See [`PutLabelInput`](crate::input::PutLabelInput)
pub mod put_label_input {
    /// A builder for [`PutLabelInput`](crate::input::PutLabelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The label name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The label name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The label description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The label description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p></p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p></p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`PutLabelInput`](crate::input::PutLabelInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::PutLabelInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::PutLabelInput {
                name: self.name,
                description: self.description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type PutLabelInputOperationOutputAlias = crate::operation::PutLabel;
#[doc(hidden)]
pub type PutLabelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutLabelInput {
    /// Consumes the builder and constructs an Operation<[`PutLabel`](crate::operation::PutLabel)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutLabel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutLabelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutLabelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutLabelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.PutLabel",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_put_label(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::PutLabel::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "PutLabel",
                    "frauddetector",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutLabelInput`](crate::input::PutLabelInput)
    pub fn builder() -> crate::input::put_label_input::Builder {
        crate::input::put_label_input::Builder::default()
    }
}

/// See [`PutOutcomeInput`](crate::input::PutOutcomeInput)
pub mod put_outcome_input {
    /// A builder for [`PutOutcomeInput`](crate::input::PutOutcomeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the outcome.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the outcome.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The outcome description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The outcome description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`PutOutcomeInput`](crate::input::PutOutcomeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutOutcomeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutOutcomeInput {
                name: self.name,
                description: self.description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type PutOutcomeInputOperationOutputAlias = crate::operation::PutOutcome;
#[doc(hidden)]
pub type PutOutcomeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutOutcomeInput {
    /// Consumes the builder and constructs an Operation<[`PutOutcome`](crate::operation::PutOutcome)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutOutcome,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutOutcomeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutOutcomeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutOutcomeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.PutOutcome",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_put_outcome(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutOutcome::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutOutcome",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutOutcomeInput`](crate::input::PutOutcomeInput)
    pub fn builder() -> crate::input::put_outcome_input::Builder {
        crate::input::put_outcome_input::Builder::default()
    }
}

/// See [`SendEventInput`](crate::input::SendEventInput)
pub mod send_event_input {
    /// A builder for [`SendEventInput`](crate::input::SendEventInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_id: std::option::Option<std::string::String>,
        pub(crate) event_type_name: std::option::Option<std::string::String>,
        pub(crate) event_timestamp: std::option::Option<std::string::String>,
        pub(crate) event_variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) assigned_label: std::option::Option<std::string::String>,
        pub(crate) label_timestamp: std::option::Option<std::string::String>,
        pub(crate) entities: std::option::Option<std::vec::Vec<crate::model::Entity>>,
    }
    impl Builder {
        /// <p>The event ID to upload.</p>
        pub fn event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_id = Some(input.into());
            self
        }
        /// <p>The event ID to upload.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_id = input;
            self
        }
        /// <p>The event type name of the event.</p>
        pub fn event_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_type_name = Some(input.into());
            self
        }
        /// <p>The event type name of the event.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_type_name = input;
            self
        }
        /// <p>The timestamp that defines when the event under evaluation occurred. The timestamp must be specified using ISO 8601 standard in UTC.</p>
        pub fn event_timestamp(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_timestamp = Some(input.into());
            self
        }
        /// <p>The timestamp that defines when the event under evaluation occurred. The timestamp must be specified using ISO 8601 standard in UTC.</p>
        pub fn set_event_timestamp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_timestamp = input;
            self
        }
        /// Adds a key-value pair to `event_variables`.
        ///
        /// To override the contents of this collection use [`set_event_variables`](Self::set_event_variables).
        ///
        /// <p>Names of the event type's variables you defined in Amazon Fraud Detector to represent data elements and their corresponding values for the event you are sending for evaluation.</p>
        pub fn event_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.event_variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.event_variables = Some(hash_map);
            self
        }
        /// <p>Names of the event type's variables you defined in Amazon Fraud Detector to represent data elements and their corresponding values for the event you are sending for evaluation.</p>
        pub fn set_event_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.event_variables = input;
            self
        }
        /// <p>The label to associate with the event. Required if specifying <code>labelTimestamp</code>.</p>
        pub fn assigned_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.assigned_label = Some(input.into());
            self
        }
        /// <p>The label to associate with the event. Required if specifying <code>labelTimestamp</code>.</p>
        pub fn set_assigned_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assigned_label = input;
            self
        }
        /// <p>The timestamp associated with the label. Required if specifying <code>assignedLabel</code>.</p>
        pub fn label_timestamp(mut self, input: impl Into<std::string::String>) -> Self {
            self.label_timestamp = Some(input.into());
            self
        }
        /// <p>The timestamp associated with the label. Required if specifying <code>assignedLabel</code>.</p>
        pub fn set_label_timestamp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.label_timestamp = input;
            self
        }
        /// Appends an item to `entities`.
        ///
        /// To override the contents of this collection use [`set_entities`](Self::set_entities).
        ///
        /// <p>An array of entities.</p>
        pub fn entities(mut self, input: impl Into<crate::model::Entity>) -> Self {
            let mut v = self.entities.unwrap_or_default();
            v.push(input.into());
            self.entities = Some(v);
            self
        }
        /// <p>An array of entities.</p>
        pub fn set_entities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Entity>>,
        ) -> Self {
            self.entities = input;
            self
        }
        /// Consumes the builder and constructs a [`SendEventInput`](crate::input::SendEventInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::SendEventInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::SendEventInput {
                event_id: self.event_id,
                event_type_name: self.event_type_name,
                event_timestamp: self.event_timestamp,
                event_variables: self.event_variables,
                assigned_label: self.assigned_label,
                label_timestamp: self.label_timestamp,
                entities: self.entities,
            })
        }
    }
}
#[doc(hidden)]
pub type SendEventInputOperationOutputAlias = crate::operation::SendEvent;
#[doc(hidden)]
pub type SendEventInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SendEventInput {
    /// Consumes the builder and constructs an Operation<[`SendEvent`](crate::operation::SendEvent)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SendEvent,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SendEventInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SendEventInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SendEventInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.SendEvent",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_send_event(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::SendEvent::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "SendEvent",
                    "frauddetector",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SendEventInput`](crate::input::SendEventInput)
    pub fn builder() -> crate::input::send_event_input::Builder {
        crate::input::send_event_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the resource.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to assign to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.TagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of the resource from which to remove the tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource from which to remove the tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The resource ARN.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.UntagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateDetectorVersionInput`](crate::input::UpdateDetectorVersionInput)
pub mod update_detector_version_input {
    /// A builder for [`UpdateDetectorVersionInput`](crate::input::UpdateDetectorVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) detector_version_id: std::option::Option<std::string::String>,
        pub(crate) external_model_endpoints:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) model_versions: std::option::Option<std::vec::Vec<crate::model::ModelVersion>>,
        pub(crate) rule_execution_mode: std::option::Option<crate::model::RuleExecutionMode>,
    }
    impl Builder {
        /// <p>The parent detector ID for the detector version you want to update.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The parent detector ID for the detector version you want to update.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The detector version ID. </p>
        pub fn detector_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_version_id = Some(input.into());
            self
        }
        /// <p>The detector version ID. </p>
        pub fn set_detector_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_version_id = input;
            self
        }
        /// Appends an item to `external_model_endpoints`.
        ///
        /// To override the contents of this collection use [`set_external_model_endpoints`](Self::set_external_model_endpoints).
        ///
        /// <p>The Amazon SageMaker model endpoints to include in the detector version.</p>
        pub fn external_model_endpoints(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.external_model_endpoints.unwrap_or_default();
            v.push(input.into());
            self.external_model_endpoints = Some(v);
            self
        }
        /// <p>The Amazon SageMaker model endpoints to include in the detector version.</p>
        pub fn set_external_model_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.external_model_endpoints = input;
            self
        }
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>The rules to include in the detector version.</p>
        pub fn rules(mut self, input: impl Into<crate::model::Rule>) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input.into());
            self.rules = Some(v);
            self
        }
        /// <p>The rules to include in the detector version.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// <p>The detector version description. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The detector version description. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `model_versions`.
        ///
        /// To override the contents of this collection use [`set_model_versions`](Self::set_model_versions).
        ///
        /// <p>The model versions to include in the detector version.</p>
        pub fn model_versions(mut self, input: impl Into<crate::model::ModelVersion>) -> Self {
            let mut v = self.model_versions.unwrap_or_default();
            v.push(input.into());
            self.model_versions = Some(v);
            self
        }
        /// <p>The model versions to include in the detector version.</p>
        pub fn set_model_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ModelVersion>>,
        ) -> Self {
            self.model_versions = input;
            self
        }
        /// <p>The rule execution mode to add to the detector.</p>
        /// <p>If you specify <code>FIRST_MATCHED</code>, Amazon Fraud Detector evaluates rules sequentially, first to last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule.</p>
        /// <p>If you specifiy <code>ALL_MATCHED</code>, Amazon Fraud Detector evaluates all rules and returns the outcomes for all matched rules. You can define and edit the rule mode at the detector version level, when it is in draft status.</p>
        /// <p>The default behavior is <code>FIRST_MATCHED</code>.</p>
        pub fn rule_execution_mode(mut self, input: crate::model::RuleExecutionMode) -> Self {
            self.rule_execution_mode = Some(input);
            self
        }
        /// <p>The rule execution mode to add to the detector.</p>
        /// <p>If you specify <code>FIRST_MATCHED</code>, Amazon Fraud Detector evaluates rules sequentially, first to last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule.</p>
        /// <p>If you specifiy <code>ALL_MATCHED</code>, Amazon Fraud Detector evaluates all rules and returns the outcomes for all matched rules. You can define and edit the rule mode at the detector version level, when it is in draft status.</p>
        /// <p>The default behavior is <code>FIRST_MATCHED</code>.</p>
        pub fn set_rule_execution_mode(
            mut self,
            input: std::option::Option<crate::model::RuleExecutionMode>,
        ) -> Self {
            self.rule_execution_mode = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDetectorVersionInput`](crate::input::UpdateDetectorVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDetectorVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDetectorVersionInput {
                detector_id: self.detector_id,
                detector_version_id: self.detector_version_id,
                external_model_endpoints: self.external_model_endpoints,
                rules: self.rules,
                description: self.description,
                model_versions: self.model_versions,
                rule_execution_mode: self.rule_execution_mode,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDetectorVersionInputOperationOutputAlias = crate::operation::UpdateDetectorVersion;
#[doc(hidden)]
pub type UpdateDetectorVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateDetectorVersionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDetectorVersion`](crate::operation::UpdateDetectorVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDetectorVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDetectorVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDetectorVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDetectorVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.UpdateDetectorVersion",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_detector_version(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDetectorVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDetectorVersion",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateDetectorVersionInput`](crate::input::UpdateDetectorVersionInput)
    pub fn builder() -> crate::input::update_detector_version_input::Builder {
        crate::input::update_detector_version_input::Builder::default()
    }
}

/// See [`UpdateDetectorVersionMetadataInput`](crate::input::UpdateDetectorVersionMetadataInput)
pub mod update_detector_version_metadata_input {
    /// A builder for [`UpdateDetectorVersionMetadataInput`](crate::input::UpdateDetectorVersionMetadataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) detector_version_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The detector ID.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The detector ID.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The detector version ID. </p>
        pub fn detector_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_version_id = Some(input.into());
            self
        }
        /// <p>The detector version ID. </p>
        pub fn set_detector_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_version_id = input;
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDetectorVersionMetadataInput`](crate::input::UpdateDetectorVersionMetadataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDetectorVersionMetadataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDetectorVersionMetadataInput {
                detector_id: self.detector_id,
                detector_version_id: self.detector_version_id,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDetectorVersionMetadataInputOperationOutputAlias =
    crate::operation::UpdateDetectorVersionMetadata;
#[doc(hidden)]
pub type UpdateDetectorVersionMetadataInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateDetectorVersionMetadataInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDetectorVersionMetadata`](crate::operation::UpdateDetectorVersionMetadata)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDetectorVersionMetadata,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDetectorVersionMetadataInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDetectorVersionMetadataInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDetectorVersionMetadataInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.UpdateDetectorVersionMetadata",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_detector_version_metadata(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDetectorVersionMetadata::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDetectorVersionMetadata",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateDetectorVersionMetadataInput`](crate::input::UpdateDetectorVersionMetadataInput)
    pub fn builder() -> crate::input::update_detector_version_metadata_input::Builder {
        crate::input::update_detector_version_metadata_input::Builder::default()
    }
}

/// See [`UpdateDetectorVersionStatusInput`](crate::input::UpdateDetectorVersionStatusInput)
pub mod update_detector_version_status_input {
    /// A builder for [`UpdateDetectorVersionStatusInput`](crate::input::UpdateDetectorVersionStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) detector_version_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::DetectorVersionStatus>,
    }
    impl Builder {
        /// <p>The detector ID. </p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The detector ID. </p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The detector version ID. </p>
        pub fn detector_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_version_id = Some(input.into());
            self
        }
        /// <p>The detector version ID. </p>
        pub fn set_detector_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_version_id = input;
            self
        }
        /// <p>The new status.</p>
        pub fn status(mut self, input: crate::model::DetectorVersionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The new status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DetectorVersionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDetectorVersionStatusInput`](crate::input::UpdateDetectorVersionStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDetectorVersionStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDetectorVersionStatusInput {
                detector_id: self.detector_id,
                detector_version_id: self.detector_version_id,
                status: self.status,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDetectorVersionStatusInputOperationOutputAlias =
    crate::operation::UpdateDetectorVersionStatus;
#[doc(hidden)]
pub type UpdateDetectorVersionStatusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateDetectorVersionStatusInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDetectorVersionStatus`](crate::operation::UpdateDetectorVersionStatus)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDetectorVersionStatus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDetectorVersionStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDetectorVersionStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDetectorVersionStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.UpdateDetectorVersionStatus",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_detector_version_status(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDetectorVersionStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDetectorVersionStatus",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateDetectorVersionStatusInput`](crate::input::UpdateDetectorVersionStatusInput)
    pub fn builder() -> crate::input::update_detector_version_status_input::Builder {
        crate::input::update_detector_version_status_input::Builder::default()
    }
}

/// See [`UpdateEventLabelInput`](crate::input::UpdateEventLabelInput)
pub mod update_event_label_input {
    /// A builder for [`UpdateEventLabelInput`](crate::input::UpdateEventLabelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_id: std::option::Option<std::string::String>,
        pub(crate) event_type_name: std::option::Option<std::string::String>,
        pub(crate) assigned_label: std::option::Option<std::string::String>,
        pub(crate) label_timestamp: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the event associated with the label to update.</p>
        pub fn event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_id = Some(input.into());
            self
        }
        /// <p>The ID of the event associated with the label to update.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_id = input;
            self
        }
        /// <p>The event type of the event associated with the label to update.</p>
        pub fn event_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_type_name = Some(input.into());
            self
        }
        /// <p>The event type of the event associated with the label to update.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_type_name = input;
            self
        }
        /// <p>The new label to assign to the event.</p>
        pub fn assigned_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.assigned_label = Some(input.into());
            self
        }
        /// <p>The new label to assign to the event.</p>
        pub fn set_assigned_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assigned_label = input;
            self
        }
        /// <p>The timestamp associated with the label. The timestamp must be specified using ISO 8601 standard in UTC. </p>
        pub fn label_timestamp(mut self, input: impl Into<std::string::String>) -> Self {
            self.label_timestamp = Some(input.into());
            self
        }
        /// <p>The timestamp associated with the label. The timestamp must be specified using ISO 8601 standard in UTC. </p>
        pub fn set_label_timestamp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.label_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEventLabelInput`](crate::input::UpdateEventLabelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateEventLabelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateEventLabelInput {
                event_id: self.event_id,
                event_type_name: self.event_type_name,
                assigned_label: self.assigned_label,
                label_timestamp: self.label_timestamp,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateEventLabelInputOperationOutputAlias = crate::operation::UpdateEventLabel;
#[doc(hidden)]
pub type UpdateEventLabelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateEventLabelInput {
    /// Consumes the builder and constructs an Operation<[`UpdateEventLabel`](crate::operation::UpdateEventLabel)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateEventLabel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateEventLabelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateEventLabelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateEventLabelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.UpdateEventLabel",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_event_label(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateEventLabel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateEventLabel",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateEventLabelInput`](crate::input::UpdateEventLabelInput)
    pub fn builder() -> crate::input::update_event_label_input::Builder {
        crate::input::update_event_label_input::Builder::default()
    }
}

/// See [`UpdateModelInput`](crate::input::UpdateModelInput)
pub mod update_model_input {
    /// A builder for [`UpdateModelInput`](crate::input::UpdateModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_id: std::option::Option<std::string::String>,
        pub(crate) model_type: std::option::Option<crate::model::ModelTypeEnum>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The model ID.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_id = Some(input.into());
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_id = input;
            self
        }
        /// <p>The model type.</p>
        pub fn model_type(mut self, input: crate::model::ModelTypeEnum) -> Self {
            self.model_type = Some(input);
            self
        }
        /// <p>The model type.</p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.model_type = input;
            self
        }
        /// <p>The new model description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The new model description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateModelInput`](crate::input::UpdateModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateModelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateModelInput {
                model_id: self.model_id,
                model_type: self.model_type,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateModelInputOperationOutputAlias = crate::operation::UpdateModel;
#[doc(hidden)]
pub type UpdateModelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateModelInput {
    /// Consumes the builder and constructs an Operation<[`UpdateModel`](crate::operation::UpdateModel)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateModel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateModelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateModelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateModelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.UpdateModel",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_model(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateModel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateModel",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateModelInput`](crate::input::UpdateModelInput)
    pub fn builder() -> crate::input::update_model_input::Builder {
        crate::input::update_model_input::Builder::default()
    }
}

/// See [`UpdateModelVersionInput`](crate::input::UpdateModelVersionInput)
pub mod update_model_version_input {
    /// A builder for [`UpdateModelVersionInput`](crate::input::UpdateModelVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_id: std::option::Option<std::string::String>,
        pub(crate) model_type: std::option::Option<crate::model::ModelTypeEnum>,
        pub(crate) major_version_number: std::option::Option<std::string::String>,
        pub(crate) external_events_detail: std::option::Option<crate::model::ExternalEventsDetail>,
        pub(crate) ingested_events_detail: std::option::Option<crate::model::IngestedEventsDetail>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The model ID.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_id = Some(input.into());
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_id = input;
            self
        }
        /// <p>The model type.</p>
        pub fn model_type(mut self, input: crate::model::ModelTypeEnum) -> Self {
            self.model_type = Some(input);
            self
        }
        /// <p>The model type.</p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.model_type = input;
            self
        }
        /// <p>The major version number.</p>
        pub fn major_version_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.major_version_number = Some(input.into());
            self
        }
        /// <p>The major version number.</p>
        pub fn set_major_version_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.major_version_number = input;
            self
        }
        /// <p>The details of the external events data used for training the model version. Required if <code>trainingDataSource</code> is <code>EXTERNAL_EVENTS</code>.</p>
        pub fn external_events_detail(mut self, input: crate::model::ExternalEventsDetail) -> Self {
            self.external_events_detail = Some(input);
            self
        }
        /// <p>The details of the external events data used for training the model version. Required if <code>trainingDataSource</code> is <code>EXTERNAL_EVENTS</code>.</p>
        pub fn set_external_events_detail(
            mut self,
            input: std::option::Option<crate::model::ExternalEventsDetail>,
        ) -> Self {
            self.external_events_detail = input;
            self
        }
        /// <p>The details of the ingested event used for training the model version. Required if your <code>trainingDataSource</code> is <code>INGESTED_EVENTS</code>.</p>
        pub fn ingested_events_detail(mut self, input: crate::model::IngestedEventsDetail) -> Self {
            self.ingested_events_detail = Some(input);
            self
        }
        /// <p>The details of the ingested event used for training the model version. Required if your <code>trainingDataSource</code> is <code>INGESTED_EVENTS</code>.</p>
        pub fn set_ingested_events_detail(
            mut self,
            input: std::option::Option<crate::model::IngestedEventsDetail>,
        ) -> Self {
            self.ingested_events_detail = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateModelVersionInput`](crate::input::UpdateModelVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateModelVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateModelVersionInput {
                model_id: self.model_id,
                model_type: self.model_type,
                major_version_number: self.major_version_number,
                external_events_detail: self.external_events_detail,
                ingested_events_detail: self.ingested_events_detail,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateModelVersionInputOperationOutputAlias = crate::operation::UpdateModelVersion;
#[doc(hidden)]
pub type UpdateModelVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateModelVersionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateModelVersion`](crate::operation::UpdateModelVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateModelVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateModelVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateModelVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateModelVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.UpdateModelVersion",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_model_version(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateModelVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateModelVersion",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateModelVersionInput`](crate::input::UpdateModelVersionInput)
    pub fn builder() -> crate::input::update_model_version_input::Builder {
        crate::input::update_model_version_input::Builder::default()
    }
}

/// See [`UpdateModelVersionStatusInput`](crate::input::UpdateModelVersionStatusInput)
pub mod update_model_version_status_input {
    /// A builder for [`UpdateModelVersionStatusInput`](crate::input::UpdateModelVersionStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_id: std::option::Option<std::string::String>,
        pub(crate) model_type: std::option::Option<crate::model::ModelTypeEnum>,
        pub(crate) model_version_number: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ModelVersionStatus>,
    }
    impl Builder {
        /// <p>The model ID of the model version to update.</p>
        pub fn model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_id = Some(input.into());
            self
        }
        /// <p>The model ID of the model version to update.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_id = input;
            self
        }
        /// <p>The model type.</p>
        pub fn model_type(mut self, input: crate::model::ModelTypeEnum) -> Self {
            self.model_type = Some(input);
            self
        }
        /// <p>The model type.</p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.model_type = input;
            self
        }
        /// <p>The model version number.</p>
        pub fn model_version_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_version_number = Some(input.into());
            self
        }
        /// <p>The model version number.</p>
        pub fn set_model_version_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_version_number = input;
            self
        }
        /// <p>The model version status.</p>
        pub fn status(mut self, input: crate::model::ModelVersionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The model version status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ModelVersionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateModelVersionStatusInput`](crate::input::UpdateModelVersionStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateModelVersionStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateModelVersionStatusInput {
                model_id: self.model_id,
                model_type: self.model_type,
                model_version_number: self.model_version_number,
                status: self.status,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateModelVersionStatusInputOperationOutputAlias =
    crate::operation::UpdateModelVersionStatus;
#[doc(hidden)]
pub type UpdateModelVersionStatusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateModelVersionStatusInput {
    /// Consumes the builder and constructs an Operation<[`UpdateModelVersionStatus`](crate::operation::UpdateModelVersionStatus)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateModelVersionStatus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateModelVersionStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateModelVersionStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateModelVersionStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.UpdateModelVersionStatus",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_model_version_status(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateModelVersionStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateModelVersionStatus",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateModelVersionStatusInput`](crate::input::UpdateModelVersionStatusInput)
    pub fn builder() -> crate::input::update_model_version_status_input::Builder {
        crate::input::update_model_version_status_input::Builder::default()
    }
}

/// See [`UpdateRuleMetadataInput`](crate::input::UpdateRuleMetadataInput)
pub mod update_rule_metadata_input {
    /// A builder for [`UpdateRuleMetadataInput`](crate::input::UpdateRuleMetadataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule: std::option::Option<crate::model::Rule>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The rule to update.</p>
        pub fn rule(mut self, input: crate::model::Rule) -> Self {
            self.rule = Some(input);
            self
        }
        /// <p>The rule to update.</p>
        pub fn set_rule(mut self, input: std::option::Option<crate::model::Rule>) -> Self {
            self.rule = input;
            self
        }
        /// <p>The rule description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The rule description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRuleMetadataInput`](crate::input::UpdateRuleMetadataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateRuleMetadataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateRuleMetadataInput {
                rule: self.rule,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateRuleMetadataInputOperationOutputAlias = crate::operation::UpdateRuleMetadata;
#[doc(hidden)]
pub type UpdateRuleMetadataInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateRuleMetadataInput {
    /// Consumes the builder and constructs an Operation<[`UpdateRuleMetadata`](crate::operation::UpdateRuleMetadata)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateRuleMetadata,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateRuleMetadataInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateRuleMetadataInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateRuleMetadataInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.UpdateRuleMetadata",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_rule_metadata(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateRuleMetadata::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateRuleMetadata",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateRuleMetadataInput`](crate::input::UpdateRuleMetadataInput)
    pub fn builder() -> crate::input::update_rule_metadata_input::Builder {
        crate::input::update_rule_metadata_input::Builder::default()
    }
}

/// See [`UpdateRuleVersionInput`](crate::input::UpdateRuleVersionInput)
pub mod update_rule_version_input {
    /// A builder for [`UpdateRuleVersionInput`](crate::input::UpdateRuleVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule: std::option::Option<crate::model::Rule>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) expression: std::option::Option<std::string::String>,
        pub(crate) language: std::option::Option<crate::model::Language>,
        pub(crate) outcomes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The rule to update.</p>
        pub fn rule(mut self, input: crate::model::Rule) -> Self {
            self.rule = Some(input);
            self
        }
        /// <p>The rule to update.</p>
        pub fn set_rule(mut self, input: std::option::Option<crate::model::Rule>) -> Self {
            self.rule = input;
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The rule expression.</p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.expression = Some(input.into());
            self
        }
        /// <p>The rule expression.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.expression = input;
            self
        }
        /// <p>The language.</p>
        pub fn language(mut self, input: crate::model::Language) -> Self {
            self.language = Some(input);
            self
        }
        /// <p>The language.</p>
        pub fn set_language(mut self, input: std::option::Option<crate::model::Language>) -> Self {
            self.language = input;
            self
        }
        /// Appends an item to `outcomes`.
        ///
        /// To override the contents of this collection use [`set_outcomes`](Self::set_outcomes).
        ///
        /// <p>The outcomes.</p>
        pub fn outcomes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.outcomes.unwrap_or_default();
            v.push(input.into());
            self.outcomes = Some(v);
            self
        }
        /// <p>The outcomes.</p>
        pub fn set_outcomes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.outcomes = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the rule version.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to assign to the rule version.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRuleVersionInput`](crate::input::UpdateRuleVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateRuleVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateRuleVersionInput {
                rule: self.rule,
                description: self.description,
                expression: self.expression,
                language: self.language,
                outcomes: self.outcomes,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateRuleVersionInputOperationOutputAlias = crate::operation::UpdateRuleVersion;
#[doc(hidden)]
pub type UpdateRuleVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateRuleVersionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateRuleVersion`](crate::operation::UpdateRuleVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateRuleVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateRuleVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateRuleVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateRuleVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.UpdateRuleVersion",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_rule_version(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateRuleVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateRuleVersion",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateRuleVersionInput`](crate::input::UpdateRuleVersionInput)
    pub fn builder() -> crate::input::update_rule_version_input::Builder {
        crate::input::update_rule_version_input::Builder::default()
    }
}

/// See [`UpdateVariableInput`](crate::input::UpdateVariableInput)
pub mod update_variable_input {
    /// A builder for [`UpdateVariableInput`](crate::input::UpdateVariableInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) default_value: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) variable_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the variable.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the variable.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The new default value of the variable.</p>
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_value = Some(input.into());
            self
        }
        /// <p>The new default value of the variable.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// <p>The new description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The new description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The variable type. For more information see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable types</a>.</p>
        pub fn variable_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.variable_type = Some(input.into());
            self
        }
        /// <p>The variable type. For more information see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable types</a>.</p>
        pub fn set_variable_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.variable_type = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateVariableInput`](crate::input::UpdateVariableInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateVariableInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateVariableInput {
                name: self.name,
                default_value: self.default_value,
                description: self.description,
                variable_type: self.variable_type,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateVariableInputOperationOutputAlias = crate::operation::UpdateVariable;
#[doc(hidden)]
pub type UpdateVariableInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateVariableInput {
    /// Consumes the builder and constructs an Operation<[`UpdateVariable`](crate::operation::UpdateVariable)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateVariable,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateVariableInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateVariableInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateVariableInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHawksNestServiceFacade.UpdateVariable",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_variable(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateVariable::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateVariable",
            "frauddetector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateVariableInput`](crate::input::UpdateVariableInput)
    pub fn builder() -> crate::input::update_variable_input::Builder {
        crate::input::update_variable_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateVariableInput {
    /// <p>The name of the variable.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The new default value of the variable.</p>
    pub default_value: std::option::Option<std::string::String>,
    /// <p>The new description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The variable type. For more information see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable types</a>.</p>
    pub variable_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateVariableInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateVariableInput");
        formatter.field("name", &self.name);
        formatter.field("default_value", &self.default_value);
        formatter.field("description", &self.description);
        formatter.field("variable_type", &self.variable_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRuleVersionInput {
    /// <p>The rule to update.</p>
    pub rule: std::option::Option<crate::model::Rule>,
    /// <p>The description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The rule expression.</p>
    pub expression: std::option::Option<std::string::String>,
    /// <p>The language.</p>
    pub language: std::option::Option<crate::model::Language>,
    /// <p>The outcomes.</p>
    pub outcomes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The tags to assign to the rule version.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for UpdateRuleVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRuleVersionInput");
        formatter.field("rule", &self.rule);
        formatter.field("description", &self.description);
        formatter.field("expression", &"*** Sensitive Data Redacted ***");
        formatter.field("language", &self.language);
        formatter.field("outcomes", &self.outcomes);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRuleMetadataInput {
    /// <p>The rule to update.</p>
    pub rule: std::option::Option<crate::model::Rule>,
    /// <p>The rule description.</p>
    pub description: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateRuleMetadataInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRuleMetadataInput");
        formatter.field("rule", &self.rule);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateModelVersionStatusInput {
    /// <p>The model ID of the model version to update.</p>
    pub model_id: std::option::Option<std::string::String>,
    /// <p>The model type.</p>
    pub model_type: std::option::Option<crate::model::ModelTypeEnum>,
    /// <p>The model version number.</p>
    pub model_version_number: std::option::Option<std::string::String>,
    /// <p>The model version status.</p>
    pub status: std::option::Option<crate::model::ModelVersionStatus>,
}
impl std::fmt::Debug for UpdateModelVersionStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateModelVersionStatusInput");
        formatter.field("model_id", &self.model_id);
        formatter.field("model_type", &self.model_type);
        formatter.field("model_version_number", &self.model_version_number);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateModelVersionInput {
    /// <p>The model ID.</p>
    pub model_id: std::option::Option<std::string::String>,
    /// <p>The model type.</p>
    pub model_type: std::option::Option<crate::model::ModelTypeEnum>,
    /// <p>The major version number.</p>
    pub major_version_number: std::option::Option<std::string::String>,
    /// <p>The details of the external events data used for training the model version. Required if <code>trainingDataSource</code> is <code>EXTERNAL_EVENTS</code>.</p>
    pub external_events_detail: std::option::Option<crate::model::ExternalEventsDetail>,
    /// <p>The details of the ingested event used for training the model version. Required if your <code>trainingDataSource</code> is <code>INGESTED_EVENTS</code>.</p>
    pub ingested_events_detail: std::option::Option<crate::model::IngestedEventsDetail>,
    /// <p>A collection of key and value pairs.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for UpdateModelVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateModelVersionInput");
        formatter.field("model_id", &self.model_id);
        formatter.field("model_type", &self.model_type);
        formatter.field("major_version_number", &self.major_version_number);
        formatter.field("external_events_detail", &self.external_events_detail);
        formatter.field("ingested_events_detail", &self.ingested_events_detail);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateModelInput {
    /// <p>The model ID.</p>
    pub model_id: std::option::Option<std::string::String>,
    /// <p>The model type.</p>
    pub model_type: std::option::Option<crate::model::ModelTypeEnum>,
    /// <p>The new model description.</p>
    pub description: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateModelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateModelInput");
        formatter.field("model_id", &self.model_id);
        formatter.field("model_type", &self.model_type);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEventLabelInput {
    /// <p>The ID of the event associated with the label to update.</p>
    pub event_id: std::option::Option<std::string::String>,
    /// <p>The event type of the event associated with the label to update.</p>
    pub event_type_name: std::option::Option<std::string::String>,
    /// <p>The new label to assign to the event.</p>
    pub assigned_label: std::option::Option<std::string::String>,
    /// <p>The timestamp associated with the label. The timestamp must be specified using ISO 8601 standard in UTC. </p>
    pub label_timestamp: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateEventLabelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEventLabelInput");
        formatter.field("event_id", &self.event_id);
        formatter.field("event_type_name", &self.event_type_name);
        formatter.field("assigned_label", &self.assigned_label);
        formatter.field("label_timestamp", &self.label_timestamp);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDetectorVersionStatusInput {
    /// <p>The detector ID. </p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The detector version ID. </p>
    pub detector_version_id: std::option::Option<std::string::String>,
    /// <p>The new status.</p>
    pub status: std::option::Option<crate::model::DetectorVersionStatus>,
}
impl std::fmt::Debug for UpdateDetectorVersionStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDetectorVersionStatusInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("detector_version_id", &self.detector_version_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDetectorVersionMetadataInput {
    /// <p>The detector ID.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The detector version ID. </p>
    pub detector_version_id: std::option::Option<std::string::String>,
    /// <p>The description.</p>
    pub description: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateDetectorVersionMetadataInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDetectorVersionMetadataInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("detector_version_id", &self.detector_version_id);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDetectorVersionInput {
    /// <p>The parent detector ID for the detector version you want to update.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The detector version ID. </p>
    pub detector_version_id: std::option::Option<std::string::String>,
    /// <p>The Amazon SageMaker model endpoints to include in the detector version.</p>
    pub external_model_endpoints: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The rules to include in the detector version.</p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::Rule>>,
    /// <p>The detector version description. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The model versions to include in the detector version.</p>
    pub model_versions: std::option::Option<std::vec::Vec<crate::model::ModelVersion>>,
    /// <p>The rule execution mode to add to the detector.</p>
    /// <p>If you specify <code>FIRST_MATCHED</code>, Amazon Fraud Detector evaluates rules sequentially, first to last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule.</p>
    /// <p>If you specifiy <code>ALL_MATCHED</code>, Amazon Fraud Detector evaluates all rules and returns the outcomes for all matched rules. You can define and edit the rule mode at the detector version level, when it is in draft status.</p>
    /// <p>The default behavior is <code>FIRST_MATCHED</code>.</p>
    pub rule_execution_mode: std::option::Option<crate::model::RuleExecutionMode>,
}
impl std::fmt::Debug for UpdateDetectorVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDetectorVersionInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("detector_version_id", &self.detector_version_id);
        formatter.field("external_model_endpoints", &self.external_model_endpoints);
        formatter.field("rules", &self.rules);
        formatter.field("description", &self.description);
        formatter.field("model_versions", &self.model_versions);
        formatter.field("rule_execution_mode", &self.rule_execution_mode);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The ARN of the resource from which to remove the tag.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The resource ARN.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The resource ARN.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags to assign to the resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendEventInput {
    /// <p>The event ID to upload.</p>
    pub event_id: std::option::Option<std::string::String>,
    /// <p>The event type name of the event.</p>
    pub event_type_name: std::option::Option<std::string::String>,
    /// <p>The timestamp that defines when the event under evaluation occurred. The timestamp must be specified using ISO 8601 standard in UTC.</p>
    pub event_timestamp: std::option::Option<std::string::String>,
    /// <p>Names of the event type's variables you defined in Amazon Fraud Detector to represent data elements and their corresponding values for the event you are sending for evaluation.</p>
    pub event_variables:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The label to associate with the event. Required if specifying <code>labelTimestamp</code>.</p>
    pub assigned_label: std::option::Option<std::string::String>,
    /// <p>The timestamp associated with the label. Required if specifying <code>assignedLabel</code>.</p>
    pub label_timestamp: std::option::Option<std::string::String>,
    /// <p>An array of entities.</p>
    pub entities: std::option::Option<std::vec::Vec<crate::model::Entity>>,
}
impl std::fmt::Debug for SendEventInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendEventInput");
        formatter.field("event_id", &self.event_id);
        formatter.field("event_type_name", &self.event_type_name);
        formatter.field("event_timestamp", &self.event_timestamp);
        formatter.field("event_variables", &self.event_variables);
        formatter.field("assigned_label", &self.assigned_label);
        formatter.field("label_timestamp", &self.label_timestamp);
        formatter.field("entities", &self.entities);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutOutcomeInput {
    /// <p>The name of the outcome.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The outcome description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A collection of key and value pairs.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for PutOutcomeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutOutcomeInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutLabelInput {
    /// <p>The label name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The label description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p></p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for PutLabelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutLabelInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutKmsEncryptionKeyInput {
    /// <p>The KMS encryption key ARN.</p>
    pub kms_encryption_key_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PutKmsEncryptionKeyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutKmsEncryptionKeyInput");
        formatter.field("kms_encryption_key_arn", &self.kms_encryption_key_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutExternalModelInput {
    /// <p>The model endpoints name.</p>
    pub model_endpoint: std::option::Option<std::string::String>,
    /// <p>The source of the model.</p>
    pub model_source: std::option::Option<crate::model::ModelSource>,
    /// <p>The IAM role used to invoke the model endpoint.</p>
    pub invoke_model_endpoint_role_arn: std::option::Option<std::string::String>,
    /// <p>The model endpoint input configuration.</p>
    pub input_configuration: std::option::Option<crate::model::ModelInputConfiguration>,
    /// <p>The model endpoint output configuration.</p>
    pub output_configuration: std::option::Option<crate::model::ModelOutputConfiguration>,
    /// <p>The model endpoint’s status in Amazon Fraud Detector.</p>
    pub model_endpoint_status: std::option::Option<crate::model::ModelEndpointStatus>,
    /// <p>A collection of key and value pairs.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for PutExternalModelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutExternalModelInput");
        formatter.field("model_endpoint", &self.model_endpoint);
        formatter.field("model_source", &self.model_source);
        formatter.field(
            "invoke_model_endpoint_role_arn",
            &self.invoke_model_endpoint_role_arn,
        );
        formatter.field("input_configuration", &self.input_configuration);
        formatter.field("output_configuration", &self.output_configuration);
        formatter.field("model_endpoint_status", &self.model_endpoint_status);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutEventTypeInput {
    /// <p>The name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the event type.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The event type variables.</p>
    pub event_variables: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The event type labels.</p>
    pub labels: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The entity type for the event type. Example entity types: customer, merchant, account.</p>
    pub entity_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies if ingenstion is enabled or disabled.</p>
    pub event_ingestion: std::option::Option<crate::model::EventIngestion>,
    /// <p>A collection of key and value pairs.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for PutEventTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutEventTypeInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("event_variables", &self.event_variables);
        formatter.field("labels", &self.labels);
        formatter.field("entity_types", &self.entity_types);
        formatter.field("event_ingestion", &self.event_ingestion);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutEntityTypeInput {
    /// <p>The name of the entity type.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A collection of key and value pairs.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for PutEntityTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutEntityTypeInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutDetectorInput {
    /// <p>The detector ID. </p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The description of the detector.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The name of the event type.</p>
    pub event_type_name: std::option::Option<std::string::String>,
    /// <p>A collection of key and value pairs.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for PutDetectorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutDetectorInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("description", &self.description);
        formatter.field("event_type_name", &self.event_type_name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The ARN that specifies the resource whose tags you want to list.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The next token from the previous results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of objects to return for the request. </p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetVariablesInput {
    /// <p>The name of the variable. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The next page token of the get variable request. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The max size per page determined for the get variable request. </p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for GetVariablesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetVariablesInput");
        formatter.field("name", &self.name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRulesInput {
    /// <p>The rule ID.</p>
    pub rule_id: std::option::Option<std::string::String>,
    /// <p>The detector ID.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The rule version.</p>
    pub rule_version: std::option::Option<std::string::String>,
    /// <p>The next page token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of rules to return for the request.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for GetRulesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRulesInput");
        formatter.field("rule_id", &self.rule_id);
        formatter.field("detector_id", &self.detector_id);
        formatter.field("rule_version", &self.rule_version);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetOutcomesInput {
    /// <p>The name of the outcome or outcomes to get.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The next page token for the request. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of objects to return for the request. </p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for GetOutcomesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetOutcomesInput");
        formatter.field("name", &self.name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetModelVersionInput {
    /// <p>The model ID.</p>
    pub model_id: std::option::Option<std::string::String>,
    /// <p>The model type.</p>
    pub model_type: std::option::Option<crate::model::ModelTypeEnum>,
    /// <p>The model version number.</p>
    pub model_version_number: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetModelVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetModelVersionInput");
        formatter.field("model_id", &self.model_id);
        formatter.field("model_type", &self.model_type);
        formatter.field("model_version_number", &self.model_version_number);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetModelsInput {
    /// <p>The model ID.</p>
    pub model_id: std::option::Option<std::string::String>,
    /// <p>The model type.</p>
    pub model_type: std::option::Option<crate::model::ModelTypeEnum>,
    /// <p>The next token for the subsequent request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of objects to return for the request. </p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for GetModelsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetModelsInput");
        formatter.field("model_id", &self.model_id);
        formatter.field("model_type", &self.model_type);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLabelsInput {
    /// <p>The name of the label or labels to get.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The next token for the subsequent request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of objects to return for the request.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for GetLabelsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLabelsInput");
        formatter.field("name", &self.name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetKmsEncryptionKeyInput {}
impl std::fmt::Debug for GetKmsEncryptionKeyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetKmsEncryptionKeyInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetExternalModelsInput {
    /// <p>The Amazon SageMaker model endpoint.</p>
    pub model_endpoint: std::option::Option<std::string::String>,
    /// <p>The next page token for the request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of objects to return for the request.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for GetExternalModelsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetExternalModelsInput");
        formatter.field("model_endpoint", &self.model_endpoint);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEventTypesInput {
    /// <p>The name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The next token for the subsequent request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of objects to return for the request.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for GetEventTypesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEventTypesInput");
        formatter.field("name", &self.name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEventPredictionInput {
    /// <p>The detector ID.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The detector version ID.</p>
    pub detector_version_id: std::option::Option<std::string::String>,
    /// <p>The unique ID used to identify the event.</p>
    pub event_id: std::option::Option<std::string::String>,
    /// <p>The event type associated with the detector specified for the prediction.</p>
    pub event_type_name: std::option::Option<std::string::String>,
    /// <p>The entity type (associated with the detector's event type) and specific entity ID representing who performed the event. If an entity id is not available, use "UNKNOWN."</p>
    pub entities: std::option::Option<std::vec::Vec<crate::model::Entity>>,
    /// <p>Timestamp that defines when the event under evaluation occurred. The timestamp must be specified using ISO 8601 standard in UTC.</p>
    pub event_timestamp: std::option::Option<std::string::String>,
    /// <p>Names of the event type's variables you defined in Amazon Fraud Detector to represent data elements and
    /// their corresponding values for the event you are sending for evaluation.</p>
    /// <important>         
    /// <p>You must provide at least one eventVariable</p>        
    /// </important>
    ///
    /// <p>To ensure most accurate fraud prediction and to simplify your data preparation, Amazon Fraud Detector will replace all missing variables or values as follows:</p>
    ///
    /// <p>
    /// <b>For Amazon Fraud Detector trained models:</b>
    /// </p>
    /// <p>If a null value is provided explicitly for a variable or if a variable is missing, model will replace the null value or the missing variable (no variable name in the eventVariables map)
    /// with calculated default mean/medians for numeric variables and with special values for categorical variables.</p>
    ///
    /// <p>
    /// <b>For imported SageMaker models:</b>
    /// </p>
    /// <p>If a null value is provided explicitly for a variable, the model and rules will use “null” as the value. If a variable is not provided (no variable name in the eventVariables map), model and rules
    /// will use the default value that is provided for the variable. </p>
    pub event_variables:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The Amazon SageMaker model endpoint input data blobs.</p>
    pub external_model_endpoint_data_blobs: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ModelEndpointDataBlob>,
    >,
}
impl std::fmt::Debug for GetEventPredictionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEventPredictionInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("detector_version_id", &self.detector_version_id);
        formatter.field("event_id", &self.event_id);
        formatter.field("event_type_name", &self.event_type_name);
        formatter.field("entities", &self.entities);
        formatter.field("event_timestamp", &self.event_timestamp);
        formatter.field("event_variables", &self.event_variables);
        formatter.field(
            "external_model_endpoint_data_blobs",
            &"*** Sensitive Data Redacted ***",
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEventInput {
    /// <p>The ID of the event to retrieve.</p>
    pub event_id: std::option::Option<std::string::String>,
    /// <p>The event type of the event to retrieve.</p>
    pub event_type_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetEventInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEventInput");
        formatter.field("event_id", &self.event_id);
        formatter.field("event_type_name", &self.event_type_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEntityTypesInput {
    /// <p>The name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The next token for the subsequent request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of objects to return for the request.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for GetEntityTypesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEntityTypesInput");
        formatter.field("name", &self.name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDetectorVersionInput {
    /// <p>The detector ID.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The detector version ID.</p>
    pub detector_version_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetDetectorVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDetectorVersionInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("detector_version_id", &self.detector_version_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDetectorsInput {
    /// <p>The detector ID.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The next token for the subsequent request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of objects to return for the request.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for GetDetectorsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDetectorsInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeleteEventsByEventTypeStatusInput {
    /// <p>Name of event type for which to get the deletion status.</p>
    pub event_type_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetDeleteEventsByEventTypeStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeleteEventsByEventTypeStatusInput");
        formatter.field("event_type_name", &self.event_type_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBatchPredictionJobsInput {
    /// <p>The batch prediction job for which to get the details.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of objects to return for the request.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The next token from the previous request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetBatchPredictionJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBatchPredictionJobsInput");
        formatter.field("job_id", &self.job_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBatchImportJobsInput {
    /// <p>The ID of the batch import job to get.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of objects to return for request.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The next token from the previous request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetBatchImportJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBatchImportJobsInput");
        formatter.field("job_id", &self.job_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeModelVersionsInput {
    /// <p>The model ID.</p>
    pub model_id: std::option::Option<std::string::String>,
    /// <p>The model version number.</p>
    pub model_version_number: std::option::Option<std::string::String>,
    /// <p>The model type.</p>
    pub model_type: std::option::Option<crate::model::ModelTypeEnum>,
    /// <p>The next token from the previous results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for DescribeModelVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeModelVersionsInput");
        formatter.field("model_id", &self.model_id);
        formatter.field("model_version_number", &self.model_version_number);
        formatter.field("model_type", &self.model_type);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDetectorInput {
    /// <p>The detector ID.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The next token from the previous response.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return for the request.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for DescribeDetectorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDetectorInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVariableInput {
    /// <p>The name of the variable to delete.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteVariableInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVariableInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRuleInput {
    /// <p>A rule.</p>
    pub rule: std::option::Option<crate::model::Rule>,
}
impl std::fmt::Debug for DeleteRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRuleInput");
        formatter.field("rule", &self.rule);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteOutcomeInput {
    /// <p>The name of the outcome to delete.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteOutcomeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteOutcomeInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteModelVersionInput {
    /// <p>The model ID of the model version to delete.</p>
    pub model_id: std::option::Option<std::string::String>,
    /// <p>The model type of the model version to delete.</p>
    pub model_type: std::option::Option<crate::model::ModelTypeEnum>,
    /// <p>The model version number of the model version to delete.</p>
    pub model_version_number: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteModelVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteModelVersionInput");
        formatter.field("model_id", &self.model_id);
        formatter.field("model_type", &self.model_type);
        formatter.field("model_version_number", &self.model_version_number);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteModelInput {
    /// <p>The model ID of the model to delete.</p>
    pub model_id: std::option::Option<std::string::String>,
    /// <p>The model type of the model to delete.</p>
    pub model_type: std::option::Option<crate::model::ModelTypeEnum>,
}
impl std::fmt::Debug for DeleteModelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteModelInput");
        formatter.field("model_id", &self.model_id);
        formatter.field("model_type", &self.model_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLabelInput {
    /// <p>The name of the label to delete.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteLabelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLabelInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteExternalModelInput {
    /// <p>The endpoint of the Amazon Sagemaker model to delete.</p>
    pub model_endpoint: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteExternalModelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteExternalModelInput");
        formatter.field("model_endpoint", &self.model_endpoint);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEventTypeInput {
    /// <p>The name of the event type to delete.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteEventTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEventTypeInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEventsByEventTypeInput {
    /// <p>The name of the event type.</p>
    pub event_type_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteEventsByEventTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEventsByEventTypeInput");
        formatter.field("event_type_name", &self.event_type_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEventInput {
    /// <p>The ID of the event to delete.</p>
    pub event_id: std::option::Option<std::string::String>,
    /// <p>The name of the event type.</p>
    pub event_type_name: std::option::Option<std::string::String>,
    /// <p>Specifies whether or not to delete any predictions associated with the event.</p>
    pub delete_audit_history: std::option::Option<bool>,
}
impl std::fmt::Debug for DeleteEventInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEventInput");
        formatter.field("event_id", &self.event_id);
        formatter.field("event_type_name", &self.event_type_name);
        formatter.field("delete_audit_history", &self.delete_audit_history);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEntityTypeInput {
    /// <p>The name of the entity type to delete.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteEntityTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEntityTypeInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDetectorVersionInput {
    /// <p>The ID of the parent detector for the detector version to delete.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The ID of the detector version to delete.</p>
    pub detector_version_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteDetectorVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDetectorVersionInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("detector_version_id", &self.detector_version_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDetectorInput {
    /// <p>The ID of the detector to delete.</p>
    pub detector_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteDetectorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDetectorInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBatchPredictionJobInput {
    /// <p>The ID of the batch prediction job to delete.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteBatchPredictionJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBatchPredictionJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBatchImportJobInput {
    /// <p>The ID of the batch import job to delete. </p>
    pub job_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteBatchImportJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBatchImportJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateVariableInput {
    /// <p>The name of the variable.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The data type.</p>
    pub data_type: std::option::Option<crate::model::DataType>,
    /// <p>The source of the data.</p>
    pub data_source: std::option::Option<crate::model::DataSource>,
    /// <p>The default value for the variable when no value is received.</p>
    pub default_value: std::option::Option<std::string::String>,
    /// <p>The description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The variable type. For more information see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable types</a>.
    /// </p>
    /// <p>Valid Values: <code>AUTH_CODE | AVS | BILLING_ADDRESS_L1 | BILLING_ADDRESS_L2 | BILLING_CITY | BILLING_COUNTRY | BILLING_NAME | BILLING_PHONE | BILLING_STATE | BILLING_ZIP | CARD_BIN | CATEGORICAL | CURRENCY_CODE | EMAIL_ADDRESS | FINGERPRINT | FRAUD_LABEL | FREE_FORM_TEXT | IP_ADDRESS | NUMERIC | ORDER_ID | PAYMENT_TYPE | PHONE_NUMBER | PRICE | PRODUCT_CATEGORY | SHIPPING_ADDRESS_L1 | SHIPPING_ADDRESS_L2 | SHIPPING_CITY | SHIPPING_COUNTRY | SHIPPING_NAME | SHIPPING_PHONE | SHIPPING_STATE | SHIPPING_ZIP | USERAGENT</code>
    /// </p>
    pub variable_type: std::option::Option<std::string::String>,
    /// <p>A collection of key and value pairs.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateVariableInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateVariableInput");
        formatter.field("name", &self.name);
        formatter.field("data_type", &self.data_type);
        formatter.field("data_source", &self.data_source);
        formatter.field("default_value", &self.default_value);
        formatter.field("description", &self.description);
        formatter.field("variable_type", &self.variable_type);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRuleInput {
    /// <p>The rule ID.</p>
    pub rule_id: std::option::Option<std::string::String>,
    /// <p>The detector ID for the rule's parent detector.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The rule description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The rule expression.</p>
    pub expression: std::option::Option<std::string::String>,
    /// <p>The language of the rule.</p>
    pub language: std::option::Option<crate::model::Language>,
    /// <p>The outcome or outcomes returned when the rule expression matches.</p>
    pub outcomes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A collection of key and value pairs.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRuleInput");
        formatter.field("rule_id", &self.rule_id);
        formatter.field("detector_id", &self.detector_id);
        formatter.field("description", &self.description);
        formatter.field("expression", &"*** Sensitive Data Redacted ***");
        formatter.field("language", &self.language);
        formatter.field("outcomes", &self.outcomes);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateModelVersionInput {
    /// <p>The model ID. </p>
    pub model_id: std::option::Option<std::string::String>,
    /// <p>The model type.</p>
    pub model_type: std::option::Option<crate::model::ModelTypeEnum>,
    /// <p>The training data source location in Amazon S3. </p>
    pub training_data_source: std::option::Option<crate::model::TrainingDataSourceEnum>,
    /// <p>The training data schema.</p>
    pub training_data_schema: std::option::Option<crate::model::TrainingDataSchema>,
    /// <p>Details of the external events data used for model version training. Required if <code>trainingDataSource</code> is <code>EXTERNAL_EVENTS</code>.</p>
    pub external_events_detail: std::option::Option<crate::model::ExternalEventsDetail>,
    /// <p>Details of the ingested events data used for model version training. Required if <code>trainingDataSource</code> is <code>INGESTED_EVENTS</code>.</p>
    pub ingested_events_detail: std::option::Option<crate::model::IngestedEventsDetail>,
    /// <p>A collection of key and value pairs.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateModelVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateModelVersionInput");
        formatter.field("model_id", &self.model_id);
        formatter.field("model_type", &self.model_type);
        formatter.field("training_data_source", &self.training_data_source);
        formatter.field("training_data_schema", &self.training_data_schema);
        formatter.field("external_events_detail", &self.external_events_detail);
        formatter.field("ingested_events_detail", &self.ingested_events_detail);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateModelInput {
    /// <p>The model ID.</p>
    pub model_id: std::option::Option<std::string::String>,
    /// <p>The model type. </p>
    pub model_type: std::option::Option<crate::model::ModelTypeEnum>,
    /// <p>The model description. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The name of the event type.</p>
    pub event_type_name: std::option::Option<std::string::String>,
    /// <p>A collection of key and value pairs.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateModelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateModelInput");
        formatter.field("model_id", &self.model_id);
        formatter.field("model_type", &self.model_type);
        formatter.field("description", &self.description);
        formatter.field("event_type_name", &self.event_type_name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDetectorVersionInput {
    /// <p>The ID of the detector under which you want to create a new version.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The description of the detector version.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon Sagemaker model endpoints to include in the detector version.</p>
    pub external_model_endpoints: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The rules to include in the detector version.</p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::Rule>>,
    /// <p>The model versions to include in the detector version.</p>
    pub model_versions: std::option::Option<std::vec::Vec<crate::model::ModelVersion>>,
    /// <p>The rule execution mode for the rules included in the detector version.</p>
    /// <p>You can define and edit the rule mode at the detector version level, when it is in draft status.</p>
    /// <p>If you specify <code>FIRST_MATCHED</code>, Amazon Fraud Detector evaluates rules sequentially, first to last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule.</p>
    /// <p>If you specifiy <code>ALL_MATCHED</code>, Amazon Fraud Detector evaluates all rules and returns the outcomes for all matched rules. </p>
    /// <p>The default behavior is <code>FIRST_MATCHED</code>.</p>
    pub rule_execution_mode: std::option::Option<crate::model::RuleExecutionMode>,
    /// <p>A collection of key and value pairs.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateDetectorVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDetectorVersionInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("description", &self.description);
        formatter.field("external_model_endpoints", &self.external_model_endpoints);
        formatter.field("rules", &self.rules);
        formatter.field("model_versions", &self.model_versions);
        formatter.field("rule_execution_mode", &self.rule_execution_mode);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBatchPredictionJobInput {
    /// <p>The ID of the batch prediction job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 location of your training file.</p>
    pub input_path: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 location of your output file.</p>
    pub output_path: std::option::Option<std::string::String>,
    /// <p>The name of the event type.</p>
    pub event_type_name: std::option::Option<std::string::String>,
    /// <p>The name of the detector.</p>
    pub detector_name: std::option::Option<std::string::String>,
    /// <p>The detector version.</p>
    pub detector_version: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM role to use for this job request.</p>
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// <p>A collection of key and value pairs.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateBatchPredictionJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBatchPredictionJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.field("input_path", &self.input_path);
        formatter.field("output_path", &self.output_path);
        formatter.field("event_type_name", &self.event_type_name);
        formatter.field("detector_name", &self.detector_name);
        formatter.field("detector_version", &self.detector_version);
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBatchImportJobInput {
    /// <p>The ID of the batch import job. The ID cannot be of a past job, unless the job exists in <code>CREATE_FAILED</code> state.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The URI that points to the Amazon S3 location of your data file.</p>
    pub input_path: std::option::Option<std::string::String>,
    /// <p>The URI that points to the Amazon S3 location for storing your results. </p>
    pub output_path: std::option::Option<std::string::String>,
    /// <p>The name of the event type.</p>
    pub event_type_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM role created for Amazon S3 bucket that holds your data file.
    /// The IAM role must have read and write permissions to both input and output S3 buckets.</p>
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// <p>A collection of key-value pairs associated with this request.  </p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateBatchImportJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBatchImportJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.field("input_path", &self.input_path);
        formatter.field("output_path", &self.output_path);
        formatter.field("event_type_name", &self.event_type_name);
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelBatchPredictionJobInput {
    /// <p>The ID of the batch prediction job to cancel.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CancelBatchPredictionJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelBatchPredictionJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelBatchImportJobInput {
    /// <p> The ID of an in-progress batch import job to cancel. </p>
    /// <p>Amazon Fraud Detector will throw an error if the batch import job is in <code>FAILED</code>, <code>CANCELED</code>, or  <code>COMPLETED</code> state.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CancelBatchImportJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelBatchImportJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetVariableInput {
    /// <p>The list of variable names to get.</p>
    pub names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for BatchGetVariableInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetVariableInput");
        formatter.field("names", &self.names);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchCreateVariableInput {
    /// <p>The list of variables for the batch create variable request.</p>
    pub variable_entries: std::option::Option<std::vec::Vec<crate::model::VariableEntry>>,
    /// <p>A collection of key and value pairs.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for BatchCreateVariableInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchCreateVariableInput");
        formatter.field("variable_entries", &self.variable_entries);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
