// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `BatchCreateVariable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchCreateVariableError {
    /// Kind of error that occurred.
    pub kind: BatchCreateVariableErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchCreateVariable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchCreateVariableErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchCreateVariableError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchCreateVariableErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            BatchCreateVariableErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            BatchCreateVariableErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            BatchCreateVariableErrorKind::ValidationException(_inner) => _inner.fmt(f),
            BatchCreateVariableErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchCreateVariableError {
    fn code(&self) -> Option<&str> {
        BatchCreateVariableError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchCreateVariableError {
    /// Creates a new `BatchCreateVariableError`.
    pub fn new(kind: BatchCreateVariableErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchCreateVariableError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchCreateVariableErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchCreateVariableError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchCreateVariableErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `BatchCreateVariableErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateVariableErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `BatchCreateVariableErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateVariableErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `BatchCreateVariableErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateVariableErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `BatchCreateVariableErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateVariableErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for BatchCreateVariableError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchCreateVariableErrorKind::AccessDeniedException(_inner) => Some(_inner),
            BatchCreateVariableErrorKind::InternalServerException(_inner) => Some(_inner),
            BatchCreateVariableErrorKind::ThrottlingException(_inner) => Some(_inner),
            BatchCreateVariableErrorKind::ValidationException(_inner) => Some(_inner),
            BatchCreateVariableErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchGetVariable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchGetVariableError {
    /// Kind of error that occurred.
    pub kind: BatchGetVariableErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchGetVariable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchGetVariableErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchGetVariableError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchGetVariableErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            BatchGetVariableErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            BatchGetVariableErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            BatchGetVariableErrorKind::ValidationException(_inner) => _inner.fmt(f),
            BatchGetVariableErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchGetVariableError {
    fn code(&self) -> Option<&str> {
        BatchGetVariableError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchGetVariableError {
    /// Creates a new `BatchGetVariableError`.
    pub fn new(kind: BatchGetVariableErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchGetVariableError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchGetVariableErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchGetVariableError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchGetVariableErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `BatchGetVariableErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetVariableErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `BatchGetVariableErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetVariableErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `BatchGetVariableErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetVariableErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `BatchGetVariableErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetVariableErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for BatchGetVariableError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchGetVariableErrorKind::AccessDeniedException(_inner) => Some(_inner),
            BatchGetVariableErrorKind::InternalServerException(_inner) => Some(_inner),
            BatchGetVariableErrorKind::ThrottlingException(_inner) => Some(_inner),
            BatchGetVariableErrorKind::ValidationException(_inner) => Some(_inner),
            BatchGetVariableErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelBatchImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelBatchImportJobError {
    /// Kind of error that occurred.
    pub kind: CancelBatchImportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelBatchImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelBatchImportJobErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelBatchImportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelBatchImportJobErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CancelBatchImportJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CancelBatchImportJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CancelBatchImportJobErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CancelBatchImportJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CancelBatchImportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelBatchImportJobError {
    fn code(&self) -> Option<&str> {
        CancelBatchImportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelBatchImportJobError {
    /// Creates a new `CancelBatchImportJobError`.
    pub fn new(kind: CancelBatchImportJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelBatchImportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelBatchImportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelBatchImportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelBatchImportJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CancelBatchImportJobErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelBatchImportJobErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `CancelBatchImportJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelBatchImportJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `CancelBatchImportJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelBatchImportJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CancelBatchImportJobErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelBatchImportJobErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `CancelBatchImportJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelBatchImportJobErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CancelBatchImportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelBatchImportJobErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CancelBatchImportJobErrorKind::InternalServerException(_inner) => Some(_inner),
            CancelBatchImportJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CancelBatchImportJobErrorKind::ThrottlingException(_inner) => Some(_inner),
            CancelBatchImportJobErrorKind::ValidationException(_inner) => Some(_inner),
            CancelBatchImportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelBatchPredictionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelBatchPredictionJobError {
    /// Kind of error that occurred.
    pub kind: CancelBatchPredictionJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelBatchPredictionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelBatchPredictionJobErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelBatchPredictionJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelBatchPredictionJobErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CancelBatchPredictionJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CancelBatchPredictionJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CancelBatchPredictionJobErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CancelBatchPredictionJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CancelBatchPredictionJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelBatchPredictionJobError {
    fn code(&self) -> Option<&str> {
        CancelBatchPredictionJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelBatchPredictionJobError {
    /// Creates a new `CancelBatchPredictionJobError`.
    pub fn new(kind: CancelBatchPredictionJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelBatchPredictionJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelBatchPredictionJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelBatchPredictionJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelBatchPredictionJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CancelBatchPredictionJobErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelBatchPredictionJobErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `CancelBatchPredictionJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelBatchPredictionJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `CancelBatchPredictionJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelBatchPredictionJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CancelBatchPredictionJobErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelBatchPredictionJobErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `CancelBatchPredictionJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelBatchPredictionJobErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CancelBatchPredictionJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelBatchPredictionJobErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CancelBatchPredictionJobErrorKind::InternalServerException(_inner) => Some(_inner),
            CancelBatchPredictionJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CancelBatchPredictionJobErrorKind::ThrottlingException(_inner) => Some(_inner),
            CancelBatchPredictionJobErrorKind::ValidationException(_inner) => Some(_inner),
            CancelBatchPredictionJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateBatchImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBatchImportJobError {
    /// Kind of error that occurred.
    pub kind: CreateBatchImportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBatchImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBatchImportJobErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBatchImportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBatchImportJobErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateBatchImportJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateBatchImportJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateBatchImportJobErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateBatchImportJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateBatchImportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBatchImportJobError {
    fn code(&self) -> Option<&str> {
        CreateBatchImportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBatchImportJobError {
    /// Creates a new `CreateBatchImportJobError`.
    pub fn new(kind: CreateBatchImportJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBatchImportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBatchImportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBatchImportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBatchImportJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateBatchImportJobErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBatchImportJobErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `CreateBatchImportJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBatchImportJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `CreateBatchImportJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBatchImportJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateBatchImportJobErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBatchImportJobErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `CreateBatchImportJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBatchImportJobErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateBatchImportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBatchImportJobErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateBatchImportJobErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateBatchImportJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateBatchImportJobErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateBatchImportJobErrorKind::ValidationException(_inner) => Some(_inner),
            CreateBatchImportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateBatchPredictionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBatchPredictionJobError {
    /// Kind of error that occurred.
    pub kind: CreateBatchPredictionJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBatchPredictionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBatchPredictionJobErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBatchPredictionJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBatchPredictionJobErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateBatchPredictionJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateBatchPredictionJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateBatchPredictionJobErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateBatchPredictionJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateBatchPredictionJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBatchPredictionJobError {
    fn code(&self) -> Option<&str> {
        CreateBatchPredictionJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBatchPredictionJobError {
    /// Creates a new `CreateBatchPredictionJobError`.
    pub fn new(kind: CreateBatchPredictionJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBatchPredictionJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBatchPredictionJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBatchPredictionJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBatchPredictionJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateBatchPredictionJobErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBatchPredictionJobErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `CreateBatchPredictionJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBatchPredictionJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `CreateBatchPredictionJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBatchPredictionJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateBatchPredictionJobErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBatchPredictionJobErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `CreateBatchPredictionJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBatchPredictionJobErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateBatchPredictionJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBatchPredictionJobErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateBatchPredictionJobErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateBatchPredictionJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateBatchPredictionJobErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateBatchPredictionJobErrorKind::ValidationException(_inner) => Some(_inner),
            CreateBatchPredictionJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDetectorVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDetectorVersionError {
    /// Kind of error that occurred.
    pub kind: CreateDetectorVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDetectorVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDetectorVersionErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDetectorVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDetectorVersionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateDetectorVersionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateDetectorVersionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateDetectorVersionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateDetectorVersionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateDetectorVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDetectorVersionError {
    fn code(&self) -> Option<&str> {
        CreateDetectorVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDetectorVersionError {
    /// Creates a new `CreateDetectorVersionError`.
    pub fn new(kind: CreateDetectorVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDetectorVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDetectorVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDetectorVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDetectorVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateDetectorVersionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDetectorVersionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `CreateDetectorVersionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDetectorVersionErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `CreateDetectorVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDetectorVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateDetectorVersionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDetectorVersionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `CreateDetectorVersionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDetectorVersionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateDetectorVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDetectorVersionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateDetectorVersionErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateDetectorVersionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateDetectorVersionErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateDetectorVersionErrorKind::ValidationException(_inner) => Some(_inner),
            CreateDetectorVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateModelError {
    /// Kind of error that occurred.
    pub kind: CreateModelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateModelErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateModelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateModelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateModelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateModelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateModelErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateModelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateModelError {
    fn code(&self) -> Option<&str> {
        CreateModelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateModelError {
    /// Creates a new `CreateModelError`.
    pub fn new(kind: CreateModelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateModelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateModelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateModelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateModelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateModelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateModelErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `CreateModelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, CreateModelErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `CreateModelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateModelErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `CreateModelErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateModelErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateModelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateModelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateModelErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateModelErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateModelErrorKind::ValidationException(_inner) => Some(_inner),
            CreateModelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateModelVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateModelVersionError {
    /// Kind of error that occurred.
    pub kind: CreateModelVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateModelVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateModelVersionErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateModelVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateModelVersionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateModelVersionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateModelVersionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateModelVersionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateModelVersionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateModelVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateModelVersionError {
    fn code(&self) -> Option<&str> {
        CreateModelVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateModelVersionError {
    /// Creates a new `CreateModelVersionError`.
    pub fn new(kind: CreateModelVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateModelVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateModelVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateModelVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateModelVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateModelVersionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateModelVersionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `CreateModelVersionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateModelVersionErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `CreateModelVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateModelVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateModelVersionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateModelVersionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `CreateModelVersionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateModelVersionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateModelVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateModelVersionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateModelVersionErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateModelVersionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateModelVersionErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateModelVersionErrorKind::ValidationException(_inner) => Some(_inner),
            CreateModelVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRuleError {
    /// Kind of error that occurred.
    pub kind: CreateRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRuleErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRuleErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateRuleErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateRuleErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateRuleErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRuleError {
    fn code(&self) -> Option<&str> {
        CreateRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRuleError {
    /// Creates a new `CreateRuleError`.
    pub fn new(kind: CreateRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRuleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateRuleErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateRuleErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `CreateRuleErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, CreateRuleErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `CreateRuleErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateRuleErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `CreateRuleErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateRuleErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRuleErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateRuleErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateRuleErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateRuleErrorKind::ValidationException(_inner) => Some(_inner),
            CreateRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateVariable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateVariableError {
    /// Kind of error that occurred.
    pub kind: CreateVariableErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateVariable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateVariableErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateVariableError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateVariableErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateVariableErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateVariableErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateVariableErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateVariableErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateVariableError {
    fn code(&self) -> Option<&str> {
        CreateVariableError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateVariableError {
    /// Creates a new `CreateVariableError`.
    pub fn new(kind: CreateVariableErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateVariableError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateVariableErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateVariableError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateVariableErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateVariableErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVariableErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `CreateVariableErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVariableErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `CreateVariableErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateVariableErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `CreateVariableErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateVariableErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateVariableError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateVariableErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateVariableErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateVariableErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateVariableErrorKind::ValidationException(_inner) => Some(_inner),
            CreateVariableErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBatchImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBatchImportJobError {
    /// Kind of error that occurred.
    pub kind: DeleteBatchImportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBatchImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBatchImportJobErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBatchImportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBatchImportJobErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteBatchImportJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteBatchImportJobErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteBatchImportJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteBatchImportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBatchImportJobError {
    fn code(&self) -> Option<&str> {
        DeleteBatchImportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBatchImportJobError {
    /// Creates a new `DeleteBatchImportJobError`.
    pub fn new(kind: DeleteBatchImportJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBatchImportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBatchImportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBatchImportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBatchImportJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteBatchImportJobErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBatchImportJobErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteBatchImportJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBatchImportJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `DeleteBatchImportJobErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBatchImportJobErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `DeleteBatchImportJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBatchImportJobErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteBatchImportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBatchImportJobErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteBatchImportJobErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteBatchImportJobErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteBatchImportJobErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteBatchImportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBatchPredictionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBatchPredictionJobError {
    /// Kind of error that occurred.
    pub kind: DeleteBatchPredictionJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBatchPredictionJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBatchPredictionJobErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBatchPredictionJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBatchPredictionJobErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteBatchPredictionJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteBatchPredictionJobErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteBatchPredictionJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteBatchPredictionJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBatchPredictionJobError {
    fn code(&self) -> Option<&str> {
        DeleteBatchPredictionJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBatchPredictionJobError {
    /// Creates a new `DeleteBatchPredictionJobError`.
    pub fn new(kind: DeleteBatchPredictionJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBatchPredictionJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBatchPredictionJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBatchPredictionJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBatchPredictionJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteBatchPredictionJobErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBatchPredictionJobErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteBatchPredictionJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBatchPredictionJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `DeleteBatchPredictionJobErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBatchPredictionJobErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `DeleteBatchPredictionJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBatchPredictionJobErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteBatchPredictionJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBatchPredictionJobErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteBatchPredictionJobErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteBatchPredictionJobErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteBatchPredictionJobErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteBatchPredictionJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDetectorError {
    /// Kind of error that occurred.
    pub kind: DeleteDetectorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDetectorErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating there was a conflict during a delete operation.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDetectorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDetectorErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteDetectorErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteDetectorErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteDetectorErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteDetectorErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteDetectorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDetectorError {
    fn code(&self) -> Option<&str> {
        DeleteDetectorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDetectorError {
    /// Creates a new `DeleteDetectorError`.
    pub fn new(kind: DeleteDetectorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDetectorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDetectorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDetectorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDetectorErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteDetectorErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDetectorErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDetectorErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteDetectorErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `DeleteDetectorErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDetectorErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDetectorErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteDetectorErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `DeleteDetectorErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteDetectorErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteDetectorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDetectorErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteDetectorErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteDetectorErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteDetectorErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteDetectorErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteDetectorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDetectorVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDetectorVersionError {
    /// Kind of error that occurred.
    pub kind: DeleteDetectorVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDetectorVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDetectorVersionErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating there was a conflict during a delete operation.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDetectorVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDetectorVersionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteDetectorVersionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteDetectorVersionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteDetectorVersionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDetectorVersionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteDetectorVersionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteDetectorVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDetectorVersionError {
    fn code(&self) -> Option<&str> {
        DeleteDetectorVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDetectorVersionError {
    /// Creates a new `DeleteDetectorVersionError`.
    pub fn new(kind: DeleteDetectorVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDetectorVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDetectorVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDetectorVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDetectorVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteDetectorVersionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDetectorVersionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDetectorVersionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDetectorVersionErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDetectorVersionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDetectorVersionErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDetectorVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDetectorVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDetectorVersionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDetectorVersionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDetectorVersionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDetectorVersionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteDetectorVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDetectorVersionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteDetectorVersionErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteDetectorVersionErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteDetectorVersionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDetectorVersionErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteDetectorVersionErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteDetectorVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEntityType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEntityTypeError {
    /// Kind of error that occurred.
    pub kind: DeleteEntityTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEntityType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEntityTypeErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating there was a conflict during a delete operation.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEntityTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEntityTypeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteEntityTypeErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteEntityTypeErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteEntityTypeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteEntityTypeErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteEntityTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEntityTypeError {
    fn code(&self) -> Option<&str> {
        DeleteEntityTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteEntityTypeError {
    /// Creates a new `DeleteEntityTypeError`.
    pub fn new(kind: DeleteEntityTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEntityTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEntityTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEntityTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEntityTypeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteEntityTypeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEntityTypeErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteEntityTypeErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteEntityTypeErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `DeleteEntityTypeErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEntityTypeErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `DeleteEntityTypeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEntityTypeErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `DeleteEntityTypeErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEntityTypeErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteEntityTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEntityTypeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteEntityTypeErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteEntityTypeErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteEntityTypeErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteEntityTypeErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteEntityTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEvent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEventError {
    /// Kind of error that occurred.
    pub kind: DeleteEventErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEvent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEventErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEventError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEventErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteEventErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteEventErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteEventErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteEventErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEventError {
    fn code(&self) -> Option<&str> {
        DeleteEventError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteEventError {
    /// Creates a new `DeleteEventError`.
    pub fn new(kind: DeleteEventErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEventError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEventErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEventError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEventErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteEventErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteEventErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `DeleteEventErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, DeleteEventErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `DeleteEventErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteEventErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `DeleteEventErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteEventErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteEventError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEventErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteEventErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteEventErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteEventErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteEventErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEventsByEventType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEventsByEventTypeError {
    /// Kind of error that occurred.
    pub kind: DeleteEventsByEventTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEventsByEventType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEventsByEventTypeErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating there was a conflict during a delete operation.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEventsByEventTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEventsByEventTypeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteEventsByEventTypeErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteEventsByEventTypeErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteEventsByEventTypeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteEventsByEventTypeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteEventsByEventTypeErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteEventsByEventTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEventsByEventTypeError {
    fn code(&self) -> Option<&str> {
        DeleteEventsByEventTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteEventsByEventTypeError {
    /// Creates a new `DeleteEventsByEventTypeError`.
    pub fn new(kind: DeleteEventsByEventTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEventsByEventTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEventsByEventTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEventsByEventTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEventsByEventTypeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteEventsByEventTypeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventsByEventTypeErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteEventsByEventTypeErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventsByEventTypeErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `DeleteEventsByEventTypeErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventsByEventTypeErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `DeleteEventsByEventTypeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventsByEventTypeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteEventsByEventTypeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventsByEventTypeErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `DeleteEventsByEventTypeErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventsByEventTypeErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteEventsByEventTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEventsByEventTypeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteEventsByEventTypeErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteEventsByEventTypeErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteEventsByEventTypeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteEventsByEventTypeErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteEventsByEventTypeErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteEventsByEventTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEventType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEventTypeError {
    /// Kind of error that occurred.
    pub kind: DeleteEventTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEventType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEventTypeErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating there was a conflict during a delete operation.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEventTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEventTypeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteEventTypeErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteEventTypeErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteEventTypeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteEventTypeErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteEventTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEventTypeError {
    fn code(&self) -> Option<&str> {
        DeleteEventTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteEventTypeError {
    /// Creates a new `DeleteEventTypeError`.
    pub fn new(kind: DeleteEventTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEventTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEventTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEventTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEventTypeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteEventTypeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventTypeErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteEventTypeErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteEventTypeErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `DeleteEventTypeErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventTypeErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `DeleteEventTypeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteEventTypeErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `DeleteEventTypeErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteEventTypeErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteEventTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEventTypeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteEventTypeErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteEventTypeErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteEventTypeErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteEventTypeErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteEventTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteExternalModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteExternalModelError {
    /// Kind of error that occurred.
    pub kind: DeleteExternalModelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteExternalModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteExternalModelErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating there was a conflict during a delete operation.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteExternalModelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteExternalModelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteExternalModelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteExternalModelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteExternalModelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteExternalModelErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteExternalModelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteExternalModelError {
    fn code(&self) -> Option<&str> {
        DeleteExternalModelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteExternalModelError {
    /// Creates a new `DeleteExternalModelError`.
    pub fn new(kind: DeleteExternalModelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteExternalModelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteExternalModelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteExternalModelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteExternalModelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteExternalModelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteExternalModelErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteExternalModelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteExternalModelErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `DeleteExternalModelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteExternalModelErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `DeleteExternalModelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteExternalModelErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `DeleteExternalModelErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteExternalModelErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteExternalModelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteExternalModelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteExternalModelErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteExternalModelErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteExternalModelErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteExternalModelErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteExternalModelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteLabel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteLabelError {
    /// Kind of error that occurred.
    pub kind: DeleteLabelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteLabel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteLabelErrorKind {
    /// <p>An exception indicating there was a conflict during a delete operation.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteLabelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteLabelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteLabelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteLabelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteLabelErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteLabelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteLabelError {
    fn code(&self) -> Option<&str> {
        DeleteLabelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteLabelError {
    /// Creates a new `DeleteLabelError`.
    pub fn new(kind: DeleteLabelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteLabelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteLabelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteLabelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteLabelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteLabelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteLabelErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `DeleteLabelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, DeleteLabelErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `DeleteLabelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteLabelErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `DeleteLabelErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteLabelErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteLabelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteLabelErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteLabelErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteLabelErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteLabelErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteLabelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteModelError {
    /// Kind of error that occurred.
    pub kind: DeleteModelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteModelErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating there was a conflict during a delete operation.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteModelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteModelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteModelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteModelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteModelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteModelErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteModelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteModelError {
    fn code(&self) -> Option<&str> {
        DeleteModelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteModelError {
    /// Creates a new `DeleteModelError`.
    pub fn new(kind: DeleteModelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteModelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteModelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteModelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteModelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteModelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteModelErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `DeleteModelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteModelErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `DeleteModelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, DeleteModelErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `DeleteModelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteModelErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `DeleteModelErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteModelErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteModelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteModelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteModelErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteModelErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteModelErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteModelErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteModelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteModelVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteModelVersionError {
    /// Kind of error that occurred.
    pub kind: DeleteModelVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteModelVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteModelVersionErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating there was a conflict during a delete operation.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteModelVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteModelVersionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteModelVersionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteModelVersionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteModelVersionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteModelVersionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteModelVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteModelVersionError {
    fn code(&self) -> Option<&str> {
        DeleteModelVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteModelVersionError {
    /// Creates a new `DeleteModelVersionError`.
    pub fn new(kind: DeleteModelVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteModelVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteModelVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteModelVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteModelVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteModelVersionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteModelVersionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteModelVersionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteModelVersionErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `DeleteModelVersionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteModelVersionErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `DeleteModelVersionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteModelVersionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `DeleteModelVersionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteModelVersionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteModelVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteModelVersionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteModelVersionErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteModelVersionErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteModelVersionErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteModelVersionErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteModelVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteOutcome` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteOutcomeError {
    /// Kind of error that occurred.
    pub kind: DeleteOutcomeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteOutcome` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteOutcomeErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating there was a conflict during a delete operation.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteOutcomeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteOutcomeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteOutcomeErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteOutcomeErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteOutcomeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteOutcomeErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteOutcomeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteOutcomeError {
    fn code(&self) -> Option<&str> {
        DeleteOutcomeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteOutcomeError {
    /// Creates a new `DeleteOutcomeError`.
    pub fn new(kind: DeleteOutcomeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteOutcomeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteOutcomeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteOutcomeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteOutcomeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteOutcomeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteOutcomeErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `DeleteOutcomeErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteOutcomeErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `DeleteOutcomeErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOutcomeErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `DeleteOutcomeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteOutcomeErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `DeleteOutcomeErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteOutcomeErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteOutcomeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteOutcomeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteOutcomeErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteOutcomeErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteOutcomeErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteOutcomeErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteOutcomeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRuleError {
    /// Kind of error that occurred.
    pub kind: DeleteRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRuleErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating there was a conflict during a delete operation.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRuleErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteRuleErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteRuleErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteRuleErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteRuleErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRuleError {
    fn code(&self) -> Option<&str> {
        DeleteRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRuleError {
    /// Creates a new `DeleteRuleError`.
    pub fn new(kind: DeleteRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRuleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteRuleErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteRuleErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `DeleteRuleErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteRuleErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `DeleteRuleErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, DeleteRuleErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `DeleteRuleErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteRuleErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `DeleteRuleErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteRuleErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRuleErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteRuleErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteRuleErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteRuleErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteRuleErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteVariable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteVariableError {
    /// Kind of error that occurred.
    pub kind: DeleteVariableErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteVariable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteVariableErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating there was a conflict during a delete operation.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteVariableError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteVariableErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteVariableErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteVariableErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteVariableErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteVariableErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteVariableErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteVariableError {
    fn code(&self) -> Option<&str> {
        DeleteVariableError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteVariableError {
    /// Creates a new `DeleteVariableError`.
    pub fn new(kind: DeleteVariableErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteVariableError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteVariableErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteVariableError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteVariableErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteVariableErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVariableErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteVariableErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteVariableErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `DeleteVariableErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVariableErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `DeleteVariableErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteVariableErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `DeleteVariableErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteVariableErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteVariableError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteVariableErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteVariableErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteVariableErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteVariableErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteVariableErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteVariableErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDetectorError {
    /// Kind of error that occurred.
    pub kind: DescribeDetectorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDetectorErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDetectorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDetectorErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeDetectorErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeDetectorErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDetectorErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeDetectorErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeDetectorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDetectorError {
    fn code(&self) -> Option<&str> {
        DescribeDetectorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDetectorError {
    /// Creates a new `DescribeDetectorError`.
    pub fn new(kind: DescribeDetectorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDetectorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDetectorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDetectorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDetectorErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeDetectorErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDetectorErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DescribeDetectorErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDetectorErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `DescribeDetectorErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDetectorErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeDetectorErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDetectorErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `DescribeDetectorErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDetectorErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeDetectorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDetectorErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeDetectorErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeDetectorErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDetectorErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeDetectorErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeDetectorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeModelVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeModelVersionsError {
    /// Kind of error that occurred.
    pub kind: DescribeModelVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeModelVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeModelVersionsErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeModelVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeModelVersionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeModelVersionsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeModelVersionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeModelVersionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeModelVersionsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeModelVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeModelVersionsError {
    fn code(&self) -> Option<&str> {
        DescribeModelVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeModelVersionsError {
    /// Creates a new `DescribeModelVersionsError`.
    pub fn new(kind: DescribeModelVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeModelVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeModelVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeModelVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeModelVersionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeModelVersionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeModelVersionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DescribeModelVersionsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeModelVersionsErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `DescribeModelVersionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeModelVersionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeModelVersionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeModelVersionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `DescribeModelVersionsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeModelVersionsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeModelVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeModelVersionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeModelVersionsErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeModelVersionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeModelVersionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeModelVersionsErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeModelVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBatchImportJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBatchImportJobsError {
    /// Kind of error that occurred.
    pub kind: GetBatchImportJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBatchImportJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBatchImportJobsErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBatchImportJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBatchImportJobsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetBatchImportJobsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetBatchImportJobsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetBatchImportJobsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetBatchImportJobsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetBatchImportJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBatchImportJobsError {
    fn code(&self) -> Option<&str> {
        GetBatchImportJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBatchImportJobsError {
    /// Creates a new `GetBatchImportJobsError`.
    pub fn new(kind: GetBatchImportJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBatchImportJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBatchImportJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBatchImportJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBatchImportJobsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetBatchImportJobsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBatchImportJobsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `GetBatchImportJobsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBatchImportJobsErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `GetBatchImportJobsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBatchImportJobsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetBatchImportJobsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBatchImportJobsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `GetBatchImportJobsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBatchImportJobsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetBatchImportJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBatchImportJobsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetBatchImportJobsErrorKind::InternalServerException(_inner) => Some(_inner),
            GetBatchImportJobsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetBatchImportJobsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetBatchImportJobsErrorKind::ValidationException(_inner) => Some(_inner),
            GetBatchImportJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBatchPredictionJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBatchPredictionJobsError {
    /// Kind of error that occurred.
    pub kind: GetBatchPredictionJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBatchPredictionJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBatchPredictionJobsErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBatchPredictionJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBatchPredictionJobsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetBatchPredictionJobsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetBatchPredictionJobsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetBatchPredictionJobsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetBatchPredictionJobsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetBatchPredictionJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBatchPredictionJobsError {
    fn code(&self) -> Option<&str> {
        GetBatchPredictionJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBatchPredictionJobsError {
    /// Creates a new `GetBatchPredictionJobsError`.
    pub fn new(kind: GetBatchPredictionJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBatchPredictionJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBatchPredictionJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBatchPredictionJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBatchPredictionJobsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetBatchPredictionJobsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBatchPredictionJobsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `GetBatchPredictionJobsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBatchPredictionJobsErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `GetBatchPredictionJobsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBatchPredictionJobsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetBatchPredictionJobsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBatchPredictionJobsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `GetBatchPredictionJobsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBatchPredictionJobsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetBatchPredictionJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBatchPredictionJobsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetBatchPredictionJobsErrorKind::InternalServerException(_inner) => Some(_inner),
            GetBatchPredictionJobsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetBatchPredictionJobsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetBatchPredictionJobsErrorKind::ValidationException(_inner) => Some(_inner),
            GetBatchPredictionJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDeleteEventsByEventTypeStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDeleteEventsByEventTypeStatusError {
    /// Kind of error that occurred.
    pub kind: GetDeleteEventsByEventTypeStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDeleteEventsByEventTypeStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDeleteEventsByEventTypeStatusErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDeleteEventsByEventTypeStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDeleteEventsByEventTypeStatusErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            GetDeleteEventsByEventTypeStatusErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            GetDeleteEventsByEventTypeStatusErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetDeleteEventsByEventTypeStatusErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetDeleteEventsByEventTypeStatusErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetDeleteEventsByEventTypeStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDeleteEventsByEventTypeStatusError {
    fn code(&self) -> Option<&str> {
        GetDeleteEventsByEventTypeStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDeleteEventsByEventTypeStatusError {
    /// Creates a new `GetDeleteEventsByEventTypeStatusError`.
    pub fn new(
        kind: GetDeleteEventsByEventTypeStatusErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDeleteEventsByEventTypeStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDeleteEventsByEventTypeStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDeleteEventsByEventTypeStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDeleteEventsByEventTypeStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetDeleteEventsByEventTypeStatusErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeleteEventsByEventTypeStatusErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `GetDeleteEventsByEventTypeStatusErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeleteEventsByEventTypeStatusErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `GetDeleteEventsByEventTypeStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeleteEventsByEventTypeStatusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetDeleteEventsByEventTypeStatusErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeleteEventsByEventTypeStatusErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `GetDeleteEventsByEventTypeStatusErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeleteEventsByEventTypeStatusErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetDeleteEventsByEventTypeStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDeleteEventsByEventTypeStatusErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            GetDeleteEventsByEventTypeStatusErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            GetDeleteEventsByEventTypeStatusErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetDeleteEventsByEventTypeStatusErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetDeleteEventsByEventTypeStatusErrorKind::ValidationException(_inner) => Some(_inner),
            GetDeleteEventsByEventTypeStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDetectors` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDetectorsError {
    /// Kind of error that occurred.
    pub kind: GetDetectorsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDetectors` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDetectorsErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDetectorsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDetectorsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetDetectorsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetDetectorsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetDetectorsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetDetectorsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetDetectorsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDetectorsError {
    fn code(&self) -> Option<&str> {
        GetDetectorsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDetectorsError {
    /// Creates a new `GetDetectorsError`.
    pub fn new(kind: GetDetectorsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDetectorsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDetectorsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDetectorsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDetectorsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetDetectorsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetDetectorsErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `GetDetectorsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDetectorsErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `GetDetectorsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDetectorsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetDetectorsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetDetectorsErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `GetDetectorsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetDetectorsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetDetectorsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDetectorsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetDetectorsErrorKind::InternalServerException(_inner) => Some(_inner),
            GetDetectorsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetDetectorsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetDetectorsErrorKind::ValidationException(_inner) => Some(_inner),
            GetDetectorsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDetectorVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDetectorVersionError {
    /// Kind of error that occurred.
    pub kind: GetDetectorVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDetectorVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDetectorVersionErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDetectorVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDetectorVersionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetDetectorVersionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetDetectorVersionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetDetectorVersionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetDetectorVersionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetDetectorVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDetectorVersionError {
    fn code(&self) -> Option<&str> {
        GetDetectorVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDetectorVersionError {
    /// Creates a new `GetDetectorVersionError`.
    pub fn new(kind: GetDetectorVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDetectorVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDetectorVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDetectorVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDetectorVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetDetectorVersionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDetectorVersionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `GetDetectorVersionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDetectorVersionErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `GetDetectorVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDetectorVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetDetectorVersionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDetectorVersionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `GetDetectorVersionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDetectorVersionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetDetectorVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDetectorVersionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetDetectorVersionErrorKind::InternalServerException(_inner) => Some(_inner),
            GetDetectorVersionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetDetectorVersionErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetDetectorVersionErrorKind::ValidationException(_inner) => Some(_inner),
            GetDetectorVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetEntityTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetEntityTypesError {
    /// Kind of error that occurred.
    pub kind: GetEntityTypesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetEntityTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetEntityTypesErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetEntityTypesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetEntityTypesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetEntityTypesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetEntityTypesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetEntityTypesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetEntityTypesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetEntityTypesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetEntityTypesError {
    fn code(&self) -> Option<&str> {
        GetEntityTypesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetEntityTypesError {
    /// Creates a new `GetEntityTypesError`.
    pub fn new(kind: GetEntityTypesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetEntityTypesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetEntityTypesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetEntityTypesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetEntityTypesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetEntityTypesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEntityTypesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `GetEntityTypesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEntityTypesErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `GetEntityTypesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEntityTypesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetEntityTypesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetEntityTypesErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `GetEntityTypesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetEntityTypesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetEntityTypesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetEntityTypesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetEntityTypesErrorKind::InternalServerException(_inner) => Some(_inner),
            GetEntityTypesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetEntityTypesErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetEntityTypesErrorKind::ValidationException(_inner) => Some(_inner),
            GetEntityTypesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetEvent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetEventError {
    /// Kind of error that occurred.
    pub kind: GetEventErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetEvent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetEventErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetEventError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetEventErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetEventErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetEventErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetEventErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetEventErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetEventErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetEventError {
    fn code(&self) -> Option<&str> {
        GetEventError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetEventError {
    /// Creates a new `GetEventError`.
    pub fn new(kind: GetEventErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetEventError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetEventErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetEventError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetEventErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetEventErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetEventErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `GetEventErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetEventErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `GetEventErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetEventErrorKind::ResourceNotFoundException(_))
    }
    /// Returns true if the error kind is `GetEventErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetEventErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `GetEventErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetEventErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetEventError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetEventErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetEventErrorKind::InternalServerException(_inner) => Some(_inner),
            GetEventErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetEventErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetEventErrorKind::ValidationException(_inner) => Some(_inner),
            GetEventErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetEventPrediction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetEventPredictionError {
    /// Kind of error that occurred.
    pub kind: GetEventPredictionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetEventPrediction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetEventPredictionErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating there was a conflict during a delete operation.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating that the attached customer-owned (external) model threw an exception when Amazon Fraud Detector invoked the model.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetEventPredictionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetEventPredictionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetEventPredictionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetEventPredictionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetEventPredictionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetEventPredictionErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            GetEventPredictionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetEventPredictionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetEventPredictionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetEventPredictionError {
    fn code(&self) -> Option<&str> {
        GetEventPredictionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetEventPredictionError {
    /// Creates a new `GetEventPredictionError`.
    pub fn new(kind: GetEventPredictionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetEventPredictionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetEventPredictionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetEventPredictionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetEventPredictionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetEventPredictionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventPredictionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `GetEventPredictionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventPredictionErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `GetEventPredictionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventPredictionErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `GetEventPredictionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventPredictionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetEventPredictionErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventPredictionErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `GetEventPredictionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventPredictionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `GetEventPredictionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventPredictionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetEventPredictionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetEventPredictionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetEventPredictionErrorKind::ConflictException(_inner) => Some(_inner),
            GetEventPredictionErrorKind::InternalServerException(_inner) => Some(_inner),
            GetEventPredictionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetEventPredictionErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            GetEventPredictionErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetEventPredictionErrorKind::ValidationException(_inner) => Some(_inner),
            GetEventPredictionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetEventTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetEventTypesError {
    /// Kind of error that occurred.
    pub kind: GetEventTypesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetEventTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetEventTypesErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetEventTypesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetEventTypesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetEventTypesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetEventTypesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetEventTypesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetEventTypesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetEventTypesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetEventTypesError {
    fn code(&self) -> Option<&str> {
        GetEventTypesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetEventTypesError {
    /// Creates a new `GetEventTypesError`.
    pub fn new(kind: GetEventTypesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetEventTypesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetEventTypesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetEventTypesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetEventTypesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetEventTypesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetEventTypesErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `GetEventTypesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventTypesErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `GetEventTypesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventTypesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetEventTypesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetEventTypesErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `GetEventTypesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetEventTypesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetEventTypesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetEventTypesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetEventTypesErrorKind::InternalServerException(_inner) => Some(_inner),
            GetEventTypesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetEventTypesErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetEventTypesErrorKind::ValidationException(_inner) => Some(_inner),
            GetEventTypesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetExternalModels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetExternalModelsError {
    /// Kind of error that occurred.
    pub kind: GetExternalModelsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetExternalModels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetExternalModelsErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetExternalModelsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetExternalModelsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetExternalModelsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetExternalModelsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetExternalModelsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetExternalModelsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetExternalModelsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetExternalModelsError {
    fn code(&self) -> Option<&str> {
        GetExternalModelsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetExternalModelsError {
    /// Creates a new `GetExternalModelsError`.
    pub fn new(kind: GetExternalModelsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetExternalModelsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetExternalModelsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetExternalModelsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetExternalModelsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetExternalModelsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExternalModelsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `GetExternalModelsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExternalModelsErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `GetExternalModelsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExternalModelsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetExternalModelsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExternalModelsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `GetExternalModelsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExternalModelsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetExternalModelsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetExternalModelsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetExternalModelsErrorKind::InternalServerException(_inner) => Some(_inner),
            GetExternalModelsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetExternalModelsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetExternalModelsErrorKind::ValidationException(_inner) => Some(_inner),
            GetExternalModelsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetKMSEncryptionKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetKMSEncryptionKeyError {
    /// Kind of error that occurred.
    pub kind: GetKMSEncryptionKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetKMSEncryptionKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetKMSEncryptionKeyErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetKMSEncryptionKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetKMSEncryptionKeyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetKMSEncryptionKeyErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetKMSEncryptionKeyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetKMSEncryptionKeyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetKMSEncryptionKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetKMSEncryptionKeyError {
    fn code(&self) -> Option<&str> {
        GetKMSEncryptionKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetKMSEncryptionKeyError {
    /// Creates a new `GetKMSEncryptionKeyError`.
    pub fn new(kind: GetKMSEncryptionKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetKMSEncryptionKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetKMSEncryptionKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetKMSEncryptionKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetKMSEncryptionKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetKMSEncryptionKeyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetKMSEncryptionKeyErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `GetKMSEncryptionKeyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetKMSEncryptionKeyErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `GetKMSEncryptionKeyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetKMSEncryptionKeyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetKMSEncryptionKeyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetKMSEncryptionKeyErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for GetKMSEncryptionKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetKMSEncryptionKeyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetKMSEncryptionKeyErrorKind::InternalServerException(_inner) => Some(_inner),
            GetKMSEncryptionKeyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetKMSEncryptionKeyErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetKMSEncryptionKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLabels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLabelsError {
    /// Kind of error that occurred.
    pub kind: GetLabelsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLabels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLabelsErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLabelsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLabelsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetLabelsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetLabelsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetLabelsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetLabelsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetLabelsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLabelsError {
    fn code(&self) -> Option<&str> {
        GetLabelsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLabelsError {
    /// Creates a new `GetLabelsError`.
    pub fn new(kind: GetLabelsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLabelsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLabelsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLabelsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLabelsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetLabelsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetLabelsErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `GetLabelsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetLabelsErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `GetLabelsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetLabelsErrorKind::ResourceNotFoundException(_))
    }
    /// Returns true if the error kind is `GetLabelsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetLabelsErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `GetLabelsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetLabelsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetLabelsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLabelsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetLabelsErrorKind::InternalServerException(_inner) => Some(_inner),
            GetLabelsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetLabelsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetLabelsErrorKind::ValidationException(_inner) => Some(_inner),
            GetLabelsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetModels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetModelsError {
    /// Kind of error that occurred.
    pub kind: GetModelsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetModels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetModelsErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetModelsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetModelsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetModelsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetModelsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetModelsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetModelsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetModelsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetModelsError {
    fn code(&self) -> Option<&str> {
        GetModelsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetModelsError {
    /// Creates a new `GetModelsError`.
    pub fn new(kind: GetModelsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetModelsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetModelsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetModelsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetModelsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetModelsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetModelsErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `GetModelsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetModelsErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `GetModelsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetModelsErrorKind::ResourceNotFoundException(_))
    }
    /// Returns true if the error kind is `GetModelsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetModelsErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `GetModelsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetModelsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetModelsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetModelsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetModelsErrorKind::InternalServerException(_inner) => Some(_inner),
            GetModelsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetModelsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetModelsErrorKind::ValidationException(_inner) => Some(_inner),
            GetModelsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetModelVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetModelVersionError {
    /// Kind of error that occurred.
    pub kind: GetModelVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetModelVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetModelVersionErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetModelVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetModelVersionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetModelVersionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetModelVersionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetModelVersionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetModelVersionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetModelVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetModelVersionError {
    fn code(&self) -> Option<&str> {
        GetModelVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetModelVersionError {
    /// Creates a new `GetModelVersionError`.
    pub fn new(kind: GetModelVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetModelVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetModelVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetModelVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetModelVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetModelVersionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetModelVersionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `GetModelVersionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetModelVersionErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `GetModelVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetModelVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetModelVersionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetModelVersionErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `GetModelVersionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetModelVersionErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetModelVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetModelVersionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetModelVersionErrorKind::InternalServerException(_inner) => Some(_inner),
            GetModelVersionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetModelVersionErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetModelVersionErrorKind::ValidationException(_inner) => Some(_inner),
            GetModelVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetOutcomes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetOutcomesError {
    /// Kind of error that occurred.
    pub kind: GetOutcomesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetOutcomes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetOutcomesErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetOutcomesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetOutcomesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetOutcomesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetOutcomesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetOutcomesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetOutcomesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetOutcomesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetOutcomesError {
    fn code(&self) -> Option<&str> {
        GetOutcomesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetOutcomesError {
    /// Creates a new `GetOutcomesError`.
    pub fn new(kind: GetOutcomesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetOutcomesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetOutcomesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetOutcomesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetOutcomesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetOutcomesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetOutcomesErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `GetOutcomesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetOutcomesErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `GetOutcomesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOutcomesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetOutcomesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetOutcomesErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `GetOutcomesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetOutcomesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetOutcomesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetOutcomesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetOutcomesErrorKind::InternalServerException(_inner) => Some(_inner),
            GetOutcomesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetOutcomesErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetOutcomesErrorKind::ValidationException(_inner) => Some(_inner),
            GetOutcomesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRulesError {
    /// Kind of error that occurred.
    pub kind: GetRulesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRulesErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRulesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRulesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetRulesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetRulesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetRulesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetRulesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetRulesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRulesError {
    fn code(&self) -> Option<&str> {
        GetRulesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRulesError {
    /// Creates a new `GetRulesError`.
    pub fn new(kind: GetRulesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRulesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRulesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRulesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRulesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetRulesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetRulesErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `GetRulesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetRulesErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `GetRulesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetRulesErrorKind::ResourceNotFoundException(_))
    }
    /// Returns true if the error kind is `GetRulesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetRulesErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `GetRulesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetRulesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetRulesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRulesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetRulesErrorKind::InternalServerException(_inner) => Some(_inner),
            GetRulesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetRulesErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetRulesErrorKind::ValidationException(_inner) => Some(_inner),
            GetRulesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetVariables` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetVariablesError {
    /// Kind of error that occurred.
    pub kind: GetVariablesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetVariables` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetVariablesErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetVariablesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetVariablesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetVariablesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetVariablesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetVariablesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetVariablesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetVariablesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetVariablesError {
    fn code(&self) -> Option<&str> {
        GetVariablesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetVariablesError {
    /// Creates a new `GetVariablesError`.
    pub fn new(kind: GetVariablesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetVariablesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetVariablesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetVariablesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetVariablesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetVariablesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetVariablesErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `GetVariablesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVariablesErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `GetVariablesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetVariablesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetVariablesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetVariablesErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `GetVariablesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetVariablesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetVariablesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetVariablesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetVariablesErrorKind::InternalServerException(_inner) => Some(_inner),
            GetVariablesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetVariablesErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetVariablesErrorKind::ValidationException(_inner) => Some(_inner),
            GetVariablesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutDetectorError {
    /// Kind of error that occurred.
    pub kind: PutDetectorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutDetectorErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating there was a conflict during a delete operation.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutDetectorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutDetectorErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutDetectorErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutDetectorErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            PutDetectorErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutDetectorErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutDetectorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutDetectorError {
    fn code(&self) -> Option<&str> {
        PutDetectorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutDetectorError {
    /// Creates a new `PutDetectorError`.
    pub fn new(kind: PutDetectorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutDetectorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutDetectorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutDetectorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutDetectorErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutDetectorErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, PutDetectorErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `PutDetectorErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, PutDetectorErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `PutDetectorErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, PutDetectorErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `PutDetectorErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, PutDetectorErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `PutDetectorErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, PutDetectorErrorKind::ValidationException(_))
    }
}
impl std::error::Error for PutDetectorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutDetectorErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutDetectorErrorKind::ConflictException(_inner) => Some(_inner),
            PutDetectorErrorKind::InternalServerException(_inner) => Some(_inner),
            PutDetectorErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutDetectorErrorKind::ValidationException(_inner) => Some(_inner),
            PutDetectorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutEntityType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutEntityTypeError {
    /// Kind of error that occurred.
    pub kind: PutEntityTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutEntityType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutEntityTypeErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating there was a conflict during a delete operation.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutEntityTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutEntityTypeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutEntityTypeErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutEntityTypeErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            PutEntityTypeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutEntityTypeErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutEntityTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutEntityTypeError {
    fn code(&self) -> Option<&str> {
        PutEntityTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutEntityTypeError {
    /// Creates a new `PutEntityTypeError`.
    pub fn new(kind: PutEntityTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutEntityTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutEntityTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutEntityTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutEntityTypeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutEntityTypeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, PutEntityTypeErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `PutEntityTypeErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, PutEntityTypeErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `PutEntityTypeErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutEntityTypeErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `PutEntityTypeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, PutEntityTypeErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `PutEntityTypeErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, PutEntityTypeErrorKind::ValidationException(_))
    }
}
impl std::error::Error for PutEntityTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutEntityTypeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutEntityTypeErrorKind::ConflictException(_inner) => Some(_inner),
            PutEntityTypeErrorKind::InternalServerException(_inner) => Some(_inner),
            PutEntityTypeErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutEntityTypeErrorKind::ValidationException(_inner) => Some(_inner),
            PutEntityTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutEventType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutEventTypeError {
    /// Kind of error that occurred.
    pub kind: PutEventTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutEventType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutEventTypeErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating there was a conflict during a delete operation.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutEventTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutEventTypeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutEventTypeErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutEventTypeErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            PutEventTypeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutEventTypeErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutEventTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutEventTypeError {
    fn code(&self) -> Option<&str> {
        PutEventTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutEventTypeError {
    /// Creates a new `PutEventTypeError`.
    pub fn new(kind: PutEventTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutEventTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutEventTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutEventTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutEventTypeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutEventTypeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, PutEventTypeErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `PutEventTypeErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, PutEventTypeErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `PutEventTypeErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutEventTypeErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `PutEventTypeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, PutEventTypeErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `PutEventTypeErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, PutEventTypeErrorKind::ValidationException(_))
    }
}
impl std::error::Error for PutEventTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutEventTypeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutEventTypeErrorKind::ConflictException(_inner) => Some(_inner),
            PutEventTypeErrorKind::InternalServerException(_inner) => Some(_inner),
            PutEventTypeErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutEventTypeErrorKind::ValidationException(_inner) => Some(_inner),
            PutEventTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutExternalModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutExternalModelError {
    /// Kind of error that occurred.
    pub kind: PutExternalModelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutExternalModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutExternalModelErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating there was a conflict during a delete operation.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutExternalModelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutExternalModelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutExternalModelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutExternalModelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            PutExternalModelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutExternalModelErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutExternalModelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutExternalModelError {
    fn code(&self) -> Option<&str> {
        PutExternalModelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutExternalModelError {
    /// Creates a new `PutExternalModelError`.
    pub fn new(kind: PutExternalModelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutExternalModelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutExternalModelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutExternalModelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutExternalModelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutExternalModelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutExternalModelErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `PutExternalModelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, PutExternalModelErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `PutExternalModelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutExternalModelErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `PutExternalModelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutExternalModelErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `PutExternalModelErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutExternalModelErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutExternalModelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutExternalModelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutExternalModelErrorKind::ConflictException(_inner) => Some(_inner),
            PutExternalModelErrorKind::InternalServerException(_inner) => Some(_inner),
            PutExternalModelErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutExternalModelErrorKind::ValidationException(_inner) => Some(_inner),
            PutExternalModelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutKMSEncryptionKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutKMSEncryptionKeyError {
    /// Kind of error that occurred.
    pub kind: PutKMSEncryptionKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutKMSEncryptionKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutKMSEncryptionKeyErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating there was a conflict during a delete operation.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutKMSEncryptionKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutKMSEncryptionKeyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutKMSEncryptionKeyErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutKMSEncryptionKeyErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            PutKMSEncryptionKeyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutKMSEncryptionKeyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutKMSEncryptionKeyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutKMSEncryptionKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutKMSEncryptionKeyError {
    fn code(&self) -> Option<&str> {
        PutKMSEncryptionKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutKMSEncryptionKeyError {
    /// Creates a new `PutKMSEncryptionKeyError`.
    pub fn new(kind: PutKMSEncryptionKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutKMSEncryptionKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutKMSEncryptionKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutKMSEncryptionKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutKMSEncryptionKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutKMSEncryptionKeyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutKMSEncryptionKeyErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `PutKMSEncryptionKeyErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutKMSEncryptionKeyErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `PutKMSEncryptionKeyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutKMSEncryptionKeyErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `PutKMSEncryptionKeyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutKMSEncryptionKeyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `PutKMSEncryptionKeyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutKMSEncryptionKeyErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `PutKMSEncryptionKeyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutKMSEncryptionKeyErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutKMSEncryptionKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutKMSEncryptionKeyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutKMSEncryptionKeyErrorKind::ConflictException(_inner) => Some(_inner),
            PutKMSEncryptionKeyErrorKind::InternalServerException(_inner) => Some(_inner),
            PutKMSEncryptionKeyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutKMSEncryptionKeyErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutKMSEncryptionKeyErrorKind::ValidationException(_inner) => Some(_inner),
            PutKMSEncryptionKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutLabel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutLabelError {
    /// Kind of error that occurred.
    pub kind: PutLabelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutLabel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutLabelErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating there was a conflict during a delete operation.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutLabelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutLabelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutLabelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutLabelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            PutLabelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutLabelErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutLabelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutLabelError {
    fn code(&self) -> Option<&str> {
        PutLabelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutLabelError {
    /// Creates a new `PutLabelError`.
    pub fn new(kind: PutLabelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutLabelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutLabelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutLabelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutLabelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutLabelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, PutLabelErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `PutLabelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, PutLabelErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `PutLabelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, PutLabelErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `PutLabelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, PutLabelErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `PutLabelErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, PutLabelErrorKind::ValidationException(_))
    }
}
impl std::error::Error for PutLabelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutLabelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutLabelErrorKind::ConflictException(_inner) => Some(_inner),
            PutLabelErrorKind::InternalServerException(_inner) => Some(_inner),
            PutLabelErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutLabelErrorKind::ValidationException(_inner) => Some(_inner),
            PutLabelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutOutcome` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutOutcomeError {
    /// Kind of error that occurred.
    pub kind: PutOutcomeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutOutcome` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutOutcomeErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating there was a conflict during a delete operation.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutOutcomeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutOutcomeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutOutcomeErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutOutcomeErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            PutOutcomeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutOutcomeErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutOutcomeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutOutcomeError {
    fn code(&self) -> Option<&str> {
        PutOutcomeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutOutcomeError {
    /// Creates a new `PutOutcomeError`.
    pub fn new(kind: PutOutcomeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutOutcomeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutOutcomeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutOutcomeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutOutcomeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutOutcomeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, PutOutcomeErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `PutOutcomeErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, PutOutcomeErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `PutOutcomeErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, PutOutcomeErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `PutOutcomeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, PutOutcomeErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `PutOutcomeErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, PutOutcomeErrorKind::ValidationException(_))
    }
}
impl std::error::Error for PutOutcomeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutOutcomeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutOutcomeErrorKind::ConflictException(_inner) => Some(_inner),
            PutOutcomeErrorKind::InternalServerException(_inner) => Some(_inner),
            PutOutcomeErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutOutcomeErrorKind::ValidationException(_inner) => Some(_inner),
            PutOutcomeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SendEvent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SendEventError {
    /// Kind of error that occurred.
    pub kind: SendEventErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SendEvent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SendEventErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating there was a conflict during a delete operation.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SendEventError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SendEventErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            SendEventErrorKind::ConflictException(_inner) => _inner.fmt(f),
            SendEventErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            SendEventErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            SendEventErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            SendEventErrorKind::ValidationException(_inner) => _inner.fmt(f),
            SendEventErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SendEventError {
    fn code(&self) -> Option<&str> {
        SendEventError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SendEventError {
    /// Creates a new `SendEventError`.
    pub fn new(kind: SendEventErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SendEventError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SendEventErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SendEventError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SendEventErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `SendEventErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, SendEventErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `SendEventErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, SendEventErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `SendEventErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, SendEventErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `SendEventErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, SendEventErrorKind::ResourceNotFoundException(_))
    }
    /// Returns true if the error kind is `SendEventErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, SendEventErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `SendEventErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, SendEventErrorKind::ValidationException(_))
    }
}
impl std::error::Error for SendEventError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SendEventErrorKind::AccessDeniedException(_inner) => Some(_inner),
            SendEventErrorKind::ConflictException(_inner) => Some(_inner),
            SendEventErrorKind::InternalServerException(_inner) => Some(_inner),
            SendEventErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            SendEventErrorKind::ThrottlingException(_inner) => Some(_inner),
            SendEventErrorKind::ValidationException(_inner) => Some(_inner),
            SendEventErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `TagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDetectorVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDetectorVersionError {
    /// Kind of error that occurred.
    pub kind: UpdateDetectorVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDetectorVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDetectorVersionErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating there was a conflict during a delete operation.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDetectorVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDetectorVersionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateDetectorVersionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateDetectorVersionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateDetectorVersionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateDetectorVersionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateDetectorVersionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateDetectorVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDetectorVersionError {
    fn code(&self) -> Option<&str> {
        UpdateDetectorVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDetectorVersionError {
    /// Creates a new `UpdateDetectorVersionError`.
    pub fn new(kind: UpdateDetectorVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDetectorVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDetectorVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDetectorVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDetectorVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateDetectorVersionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDetectorVersionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDetectorVersionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDetectorVersionErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDetectorVersionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDetectorVersionErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDetectorVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDetectorVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDetectorVersionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDetectorVersionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDetectorVersionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDetectorVersionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateDetectorVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDetectorVersionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateDetectorVersionErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateDetectorVersionErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateDetectorVersionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateDetectorVersionErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateDetectorVersionErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateDetectorVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDetectorVersionMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDetectorVersionMetadataError {
    /// Kind of error that occurred.
    pub kind: UpdateDetectorVersionMetadataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDetectorVersionMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDetectorVersionMetadataErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating there was a conflict during a delete operation.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDetectorVersionMetadataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDetectorVersionMetadataErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateDetectorVersionMetadataErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateDetectorVersionMetadataErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            UpdateDetectorVersionMetadataErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateDetectorVersionMetadataErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateDetectorVersionMetadataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDetectorVersionMetadataError {
    fn code(&self) -> Option<&str> {
        UpdateDetectorVersionMetadataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDetectorVersionMetadataError {
    /// Creates a new `UpdateDetectorVersionMetadataError`.
    pub fn new(
        kind: UpdateDetectorVersionMetadataErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDetectorVersionMetadataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDetectorVersionMetadataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDetectorVersionMetadataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDetectorVersionMetadataErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateDetectorVersionMetadataErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDetectorVersionMetadataErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDetectorVersionMetadataErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDetectorVersionMetadataErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDetectorVersionMetadataErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDetectorVersionMetadataErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDetectorVersionMetadataErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDetectorVersionMetadataErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDetectorVersionMetadataErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDetectorVersionMetadataErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateDetectorVersionMetadataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDetectorVersionMetadataErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateDetectorVersionMetadataErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateDetectorVersionMetadataErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateDetectorVersionMetadataErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateDetectorVersionMetadataErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateDetectorVersionMetadataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDetectorVersionStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDetectorVersionStatusError {
    /// Kind of error that occurred.
    pub kind: UpdateDetectorVersionStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDetectorVersionStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDetectorVersionStatusErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating there was a conflict during a delete operation.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDetectorVersionStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDetectorVersionStatusErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateDetectorVersionStatusErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateDetectorVersionStatusErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateDetectorVersionStatusErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateDetectorVersionStatusErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateDetectorVersionStatusErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateDetectorVersionStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDetectorVersionStatusError {
    fn code(&self) -> Option<&str> {
        UpdateDetectorVersionStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDetectorVersionStatusError {
    /// Creates a new `UpdateDetectorVersionStatusError`.
    pub fn new(kind: UpdateDetectorVersionStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDetectorVersionStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDetectorVersionStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDetectorVersionStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDetectorVersionStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateDetectorVersionStatusErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDetectorVersionStatusErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDetectorVersionStatusErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDetectorVersionStatusErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDetectorVersionStatusErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDetectorVersionStatusErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDetectorVersionStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDetectorVersionStatusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDetectorVersionStatusErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDetectorVersionStatusErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDetectorVersionStatusErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDetectorVersionStatusErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateDetectorVersionStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDetectorVersionStatusErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateDetectorVersionStatusErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateDetectorVersionStatusErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateDetectorVersionStatusErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateDetectorVersionStatusErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateDetectorVersionStatusErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateDetectorVersionStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateEventLabel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateEventLabelError {
    /// Kind of error that occurred.
    pub kind: UpdateEventLabelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateEventLabel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateEventLabelErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating there was a conflict during a delete operation.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateEventLabelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateEventLabelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateEventLabelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateEventLabelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateEventLabelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateEventLabelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateEventLabelErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateEventLabelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateEventLabelError {
    fn code(&self) -> Option<&str> {
        UpdateEventLabelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateEventLabelError {
    /// Creates a new `UpdateEventLabelError`.
    pub fn new(kind: UpdateEventLabelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateEventLabelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateEventLabelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateEventLabelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateEventLabelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateEventLabelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventLabelErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `UpdateEventLabelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateEventLabelErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpdateEventLabelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventLabelErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `UpdateEventLabelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventLabelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateEventLabelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventLabelErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `UpdateEventLabelErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventLabelErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateEventLabelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateEventLabelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateEventLabelErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateEventLabelErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateEventLabelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateEventLabelErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateEventLabelErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateEventLabelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateModelError {
    /// Kind of error that occurred.
    pub kind: UpdateModelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateModelErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating there was a conflict during a delete operation.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateModelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateModelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateModelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateModelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateModelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateModelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateModelErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateModelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateModelError {
    fn code(&self) -> Option<&str> {
        UpdateModelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateModelError {
    /// Creates a new `UpdateModelError`.
    pub fn new(kind: UpdateModelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateModelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateModelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateModelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateModelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateModelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateModelErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `UpdateModelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateModelErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpdateModelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, UpdateModelErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `UpdateModelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateModelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateModelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateModelErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `UpdateModelErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateModelErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateModelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateModelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateModelErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateModelErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateModelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateModelErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateModelErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateModelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateModelVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateModelVersionError {
    /// Kind of error that occurred.
    pub kind: UpdateModelVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateModelVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateModelVersionErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating there was a conflict during a delete operation.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateModelVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateModelVersionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateModelVersionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateModelVersionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateModelVersionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateModelVersionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateModelVersionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateModelVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateModelVersionError {
    fn code(&self) -> Option<&str> {
        UpdateModelVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateModelVersionError {
    /// Creates a new `UpdateModelVersionError`.
    pub fn new(kind: UpdateModelVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateModelVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateModelVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateModelVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateModelVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateModelVersionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateModelVersionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `UpdateModelVersionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateModelVersionErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `UpdateModelVersionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateModelVersionErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `UpdateModelVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateModelVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateModelVersionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateModelVersionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `UpdateModelVersionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateModelVersionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateModelVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateModelVersionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateModelVersionErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateModelVersionErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateModelVersionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateModelVersionErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateModelVersionErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateModelVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateModelVersionStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateModelVersionStatusError {
    /// Kind of error that occurred.
    pub kind: UpdateModelVersionStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateModelVersionStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateModelVersionStatusErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating there was a conflict during a delete operation.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateModelVersionStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateModelVersionStatusErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateModelVersionStatusErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateModelVersionStatusErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateModelVersionStatusErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateModelVersionStatusErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateModelVersionStatusErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateModelVersionStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateModelVersionStatusError {
    fn code(&self) -> Option<&str> {
        UpdateModelVersionStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateModelVersionStatusError {
    /// Creates a new `UpdateModelVersionStatusError`.
    pub fn new(kind: UpdateModelVersionStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateModelVersionStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateModelVersionStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateModelVersionStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateModelVersionStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateModelVersionStatusErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateModelVersionStatusErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `UpdateModelVersionStatusErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateModelVersionStatusErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `UpdateModelVersionStatusErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateModelVersionStatusErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `UpdateModelVersionStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateModelVersionStatusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateModelVersionStatusErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateModelVersionStatusErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `UpdateModelVersionStatusErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateModelVersionStatusErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateModelVersionStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateModelVersionStatusErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateModelVersionStatusErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateModelVersionStatusErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateModelVersionStatusErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateModelVersionStatusErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateModelVersionStatusErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateModelVersionStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRuleMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRuleMetadataError {
    /// Kind of error that occurred.
    pub kind: UpdateRuleMetadataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRuleMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRuleMetadataErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating there was a conflict during a delete operation.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRuleMetadataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRuleMetadataErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateRuleMetadataErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateRuleMetadataErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateRuleMetadataErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateRuleMetadataErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateRuleMetadataErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateRuleMetadataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRuleMetadataError {
    fn code(&self) -> Option<&str> {
        UpdateRuleMetadataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRuleMetadataError {
    /// Creates a new `UpdateRuleMetadataError`.
    pub fn new(kind: UpdateRuleMetadataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRuleMetadataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRuleMetadataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRuleMetadataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRuleMetadataErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateRuleMetadataErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleMetadataErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `UpdateRuleMetadataErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleMetadataErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `UpdateRuleMetadataErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleMetadataErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `UpdateRuleMetadataErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleMetadataErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateRuleMetadataErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleMetadataErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `UpdateRuleMetadataErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleMetadataErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateRuleMetadataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRuleMetadataErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateRuleMetadataErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateRuleMetadataErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateRuleMetadataErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateRuleMetadataErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateRuleMetadataErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateRuleMetadataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRuleVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRuleVersionError {
    /// Kind of error that occurred.
    pub kind: UpdateRuleVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRuleVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRuleVersionErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating there was a conflict during a delete operation.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRuleVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRuleVersionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateRuleVersionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateRuleVersionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateRuleVersionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateRuleVersionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateRuleVersionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateRuleVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRuleVersionError {
    fn code(&self) -> Option<&str> {
        UpdateRuleVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRuleVersionError {
    /// Creates a new `UpdateRuleVersionError`.
    pub fn new(kind: UpdateRuleVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRuleVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRuleVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRuleVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRuleVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateRuleVersionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleVersionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `UpdateRuleVersionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateRuleVersionErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpdateRuleVersionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleVersionErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `UpdateRuleVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateRuleVersionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleVersionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `UpdateRuleVersionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleVersionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateRuleVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRuleVersionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateRuleVersionErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateRuleVersionErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateRuleVersionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateRuleVersionErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateRuleVersionErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateRuleVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateVariable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateVariableError {
    /// Kind of error that occurred.
    pub kind: UpdateVariableErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateVariable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateVariableErrorKind {
    /// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An exception indicating there was a conflict during a delete operation.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An exception indicating an internal server error.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An exception indicating the specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>An exception indicating a throttling error.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception indicating a specified value is not allowed.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateVariableError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateVariableErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateVariableErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateVariableErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateVariableErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateVariableErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateVariableErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateVariableErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateVariableError {
    fn code(&self) -> Option<&str> {
        UpdateVariableError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateVariableError {
    /// Creates a new `UpdateVariableError`.
    pub fn new(kind: UpdateVariableErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateVariableError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateVariableErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateVariableError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateVariableErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateVariableErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVariableErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `UpdateVariableErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateVariableErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpdateVariableErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVariableErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `UpdateVariableErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVariableErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateVariableErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateVariableErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `UpdateVariableErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateVariableErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateVariableError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateVariableErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateVariableErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateVariableErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateVariableErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateVariableErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateVariableErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateVariableErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>An exception indicating a specified value is not allowed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>An exception indicating a throttling error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>An exception indicating the specified resource was not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>An exception indicating an internal server error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>An exception indicating there was a conflict during a delete operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>An exception indicating that the attached customer-owned (external) model threw an exception when Amazon Fraud Detector invoked the model.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceUnavailableException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceUnavailableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceUnavailableException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceUnavailableException {}
/// See [`ResourceUnavailableException`](crate::error::ResourceUnavailableException)
pub mod resource_unavailable_exception {
    /// A builder for [`ResourceUnavailableException`](crate::error::ResourceUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceUnavailableException`](crate::error::ResourceUnavailableException)
        pub fn build(self) -> crate::error::ResourceUnavailableException {
            crate::error::ResourceUnavailableException {
                message: self.message,
            }
        }
    }
}
impl ResourceUnavailableException {
    /// Creates a new builder-style object to manufacture [`ResourceUnavailableException`](crate::error::ResourceUnavailableException)
    pub fn builder() -> crate::error::resource_unavailable_exception::Builder {
        crate::error::resource_unavailable_exception::Builder::default()
    }
}
