// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AWSHawksNestServiceFacade`.
///
/// This client allows ergonomic access to a `AWSHawksNestServiceFacade`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `BatchCreateVariable` operation.
    ///
    /// See [`BatchCreateVariable`](crate::client::fluent_builders::BatchCreateVariable) for more information about the
    /// operation and its arguments.
    pub fn batch_create_variable(&self) -> fluent_builders::BatchCreateVariable<C, M, R> {
        fluent_builders::BatchCreateVariable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchGetVariable` operation.
    ///
    /// See [`BatchGetVariable`](crate::client::fluent_builders::BatchGetVariable) for more information about the
    /// operation and its arguments.
    pub fn batch_get_variable(&self) -> fluent_builders::BatchGetVariable<C, M, R> {
        fluent_builders::BatchGetVariable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelBatchImportJob` operation.
    ///
    /// See [`CancelBatchImportJob`](crate::client::fluent_builders::CancelBatchImportJob) for more information about the
    /// operation and its arguments.
    pub fn cancel_batch_import_job(&self) -> fluent_builders::CancelBatchImportJob<C, M, R> {
        fluent_builders::CancelBatchImportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelBatchPredictionJob` operation.
    ///
    /// See [`CancelBatchPredictionJob`](crate::client::fluent_builders::CancelBatchPredictionJob) for more information about the
    /// operation and its arguments.
    pub fn cancel_batch_prediction_job(
        &self,
    ) -> fluent_builders::CancelBatchPredictionJob<C, M, R> {
        fluent_builders::CancelBatchPredictionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateBatchImportJob` operation.
    ///
    /// See [`CreateBatchImportJob`](crate::client::fluent_builders::CreateBatchImportJob) for more information about the
    /// operation and its arguments.
    pub fn create_batch_import_job(&self) -> fluent_builders::CreateBatchImportJob<C, M, R> {
        fluent_builders::CreateBatchImportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateBatchPredictionJob` operation.
    ///
    /// See [`CreateBatchPredictionJob`](crate::client::fluent_builders::CreateBatchPredictionJob) for more information about the
    /// operation and its arguments.
    pub fn create_batch_prediction_job(
        &self,
    ) -> fluent_builders::CreateBatchPredictionJob<C, M, R> {
        fluent_builders::CreateBatchPredictionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDetectorVersion` operation.
    ///
    /// See [`CreateDetectorVersion`](crate::client::fluent_builders::CreateDetectorVersion) for more information about the
    /// operation and its arguments.
    pub fn create_detector_version(&self) -> fluent_builders::CreateDetectorVersion<C, M, R> {
        fluent_builders::CreateDetectorVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateModel` operation.
    ///
    /// See [`CreateModel`](crate::client::fluent_builders::CreateModel) for more information about the
    /// operation and its arguments.
    pub fn create_model(&self) -> fluent_builders::CreateModel<C, M, R> {
        fluent_builders::CreateModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateModelVersion` operation.
    ///
    /// See [`CreateModelVersion`](crate::client::fluent_builders::CreateModelVersion) for more information about the
    /// operation and its arguments.
    pub fn create_model_version(&self) -> fluent_builders::CreateModelVersion<C, M, R> {
        fluent_builders::CreateModelVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRule` operation.
    ///
    /// See [`CreateRule`](crate::client::fluent_builders::CreateRule) for more information about the
    /// operation and its arguments.
    pub fn create_rule(&self) -> fluent_builders::CreateRule<C, M, R> {
        fluent_builders::CreateRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateVariable` operation.
    ///
    /// See [`CreateVariable`](crate::client::fluent_builders::CreateVariable) for more information about the
    /// operation and its arguments.
    pub fn create_variable(&self) -> fluent_builders::CreateVariable<C, M, R> {
        fluent_builders::CreateVariable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBatchImportJob` operation.
    ///
    /// See [`DeleteBatchImportJob`](crate::client::fluent_builders::DeleteBatchImportJob) for more information about the
    /// operation and its arguments.
    pub fn delete_batch_import_job(&self) -> fluent_builders::DeleteBatchImportJob<C, M, R> {
        fluent_builders::DeleteBatchImportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBatchPredictionJob` operation.
    ///
    /// See [`DeleteBatchPredictionJob`](crate::client::fluent_builders::DeleteBatchPredictionJob) for more information about the
    /// operation and its arguments.
    pub fn delete_batch_prediction_job(
        &self,
    ) -> fluent_builders::DeleteBatchPredictionJob<C, M, R> {
        fluent_builders::DeleteBatchPredictionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDetector` operation.
    ///
    /// See [`DeleteDetector`](crate::client::fluent_builders::DeleteDetector) for more information about the
    /// operation and its arguments.
    pub fn delete_detector(&self) -> fluent_builders::DeleteDetector<C, M, R> {
        fluent_builders::DeleteDetector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDetectorVersion` operation.
    ///
    /// See [`DeleteDetectorVersion`](crate::client::fluent_builders::DeleteDetectorVersion) for more information about the
    /// operation and its arguments.
    pub fn delete_detector_version(&self) -> fluent_builders::DeleteDetectorVersion<C, M, R> {
        fluent_builders::DeleteDetectorVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEntityType` operation.
    ///
    /// See [`DeleteEntityType`](crate::client::fluent_builders::DeleteEntityType) for more information about the
    /// operation and its arguments.
    pub fn delete_entity_type(&self) -> fluent_builders::DeleteEntityType<C, M, R> {
        fluent_builders::DeleteEntityType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEvent` operation.
    ///
    /// See [`DeleteEvent`](crate::client::fluent_builders::DeleteEvent) for more information about the
    /// operation and its arguments.
    pub fn delete_event(&self) -> fluent_builders::DeleteEvent<C, M, R> {
        fluent_builders::DeleteEvent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEventsByEventType` operation.
    ///
    /// See [`DeleteEventsByEventType`](crate::client::fluent_builders::DeleteEventsByEventType) for more information about the
    /// operation and its arguments.
    pub fn delete_events_by_event_type(&self) -> fluent_builders::DeleteEventsByEventType<C, M, R> {
        fluent_builders::DeleteEventsByEventType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEventType` operation.
    ///
    /// See [`DeleteEventType`](crate::client::fluent_builders::DeleteEventType) for more information about the
    /// operation and its arguments.
    pub fn delete_event_type(&self) -> fluent_builders::DeleteEventType<C, M, R> {
        fluent_builders::DeleteEventType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteExternalModel` operation.
    ///
    /// See [`DeleteExternalModel`](crate::client::fluent_builders::DeleteExternalModel) for more information about the
    /// operation and its arguments.
    pub fn delete_external_model(&self) -> fluent_builders::DeleteExternalModel<C, M, R> {
        fluent_builders::DeleteExternalModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteLabel` operation.
    ///
    /// See [`DeleteLabel`](crate::client::fluent_builders::DeleteLabel) for more information about the
    /// operation and its arguments.
    pub fn delete_label(&self) -> fluent_builders::DeleteLabel<C, M, R> {
        fluent_builders::DeleteLabel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteModel` operation.
    ///
    /// See [`DeleteModel`](crate::client::fluent_builders::DeleteModel) for more information about the
    /// operation and its arguments.
    pub fn delete_model(&self) -> fluent_builders::DeleteModel<C, M, R> {
        fluent_builders::DeleteModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteModelVersion` operation.
    ///
    /// See [`DeleteModelVersion`](crate::client::fluent_builders::DeleteModelVersion) for more information about the
    /// operation and its arguments.
    pub fn delete_model_version(&self) -> fluent_builders::DeleteModelVersion<C, M, R> {
        fluent_builders::DeleteModelVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteOutcome` operation.
    ///
    /// See [`DeleteOutcome`](crate::client::fluent_builders::DeleteOutcome) for more information about the
    /// operation and its arguments.
    pub fn delete_outcome(&self) -> fluent_builders::DeleteOutcome<C, M, R> {
        fluent_builders::DeleteOutcome::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRule` operation.
    ///
    /// See [`DeleteRule`](crate::client::fluent_builders::DeleteRule) for more information about the
    /// operation and its arguments.
    pub fn delete_rule(&self) -> fluent_builders::DeleteRule<C, M, R> {
        fluent_builders::DeleteRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteVariable` operation.
    ///
    /// See [`DeleteVariable`](crate::client::fluent_builders::DeleteVariable) for more information about the
    /// operation and its arguments.
    pub fn delete_variable(&self) -> fluent_builders::DeleteVariable<C, M, R> {
        fluent_builders::DeleteVariable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDetector` operation.
    ///
    /// See [`DescribeDetector`](crate::client::fluent_builders::DescribeDetector) for more information about the
    /// operation and its arguments.
    pub fn describe_detector(&self) -> fluent_builders::DescribeDetector<C, M, R> {
        fluent_builders::DescribeDetector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeModelVersions` operation.
    ///
    /// See [`DescribeModelVersions`](crate::client::fluent_builders::DescribeModelVersions) for more information about the
    /// operation and its arguments.
    pub fn describe_model_versions(&self) -> fluent_builders::DescribeModelVersions<C, M, R> {
        fluent_builders::DescribeModelVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBatchImportJobs` operation.
    ///
    /// See [`GetBatchImportJobs`](crate::client::fluent_builders::GetBatchImportJobs) for more information about the
    /// operation and its arguments.
    pub fn get_batch_import_jobs(&self) -> fluent_builders::GetBatchImportJobs<C, M, R> {
        fluent_builders::GetBatchImportJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBatchPredictionJobs` operation.
    ///
    /// See [`GetBatchPredictionJobs`](crate::client::fluent_builders::GetBatchPredictionJobs) for more information about the
    /// operation and its arguments.
    pub fn get_batch_prediction_jobs(&self) -> fluent_builders::GetBatchPredictionJobs<C, M, R> {
        fluent_builders::GetBatchPredictionJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDeleteEventsByEventTypeStatus` operation.
    ///
    /// See [`GetDeleteEventsByEventTypeStatus`](crate::client::fluent_builders::GetDeleteEventsByEventTypeStatus) for more information about the
    /// operation and its arguments.
    pub fn get_delete_events_by_event_type_status(
        &self,
    ) -> fluent_builders::GetDeleteEventsByEventTypeStatus<C, M, R> {
        fluent_builders::GetDeleteEventsByEventTypeStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDetectors` operation.
    ///
    /// See [`GetDetectors`](crate::client::fluent_builders::GetDetectors) for more information about the
    /// operation and its arguments.
    pub fn get_detectors(&self) -> fluent_builders::GetDetectors<C, M, R> {
        fluent_builders::GetDetectors::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDetectorVersion` operation.
    ///
    /// See [`GetDetectorVersion`](crate::client::fluent_builders::GetDetectorVersion) for more information about the
    /// operation and its arguments.
    pub fn get_detector_version(&self) -> fluent_builders::GetDetectorVersion<C, M, R> {
        fluent_builders::GetDetectorVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetEntityTypes` operation.
    ///
    /// See [`GetEntityTypes`](crate::client::fluent_builders::GetEntityTypes) for more information about the
    /// operation and its arguments.
    pub fn get_entity_types(&self) -> fluent_builders::GetEntityTypes<C, M, R> {
        fluent_builders::GetEntityTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetEvent` operation.
    ///
    /// See [`GetEvent`](crate::client::fluent_builders::GetEvent) for more information about the
    /// operation and its arguments.
    pub fn get_event(&self) -> fluent_builders::GetEvent<C, M, R> {
        fluent_builders::GetEvent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetEventPrediction` operation.
    ///
    /// See [`GetEventPrediction`](crate::client::fluent_builders::GetEventPrediction) for more information about the
    /// operation and its arguments.
    pub fn get_event_prediction(&self) -> fluent_builders::GetEventPrediction<C, M, R> {
        fluent_builders::GetEventPrediction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetEventTypes` operation.
    ///
    /// See [`GetEventTypes`](crate::client::fluent_builders::GetEventTypes) for more information about the
    /// operation and its arguments.
    pub fn get_event_types(&self) -> fluent_builders::GetEventTypes<C, M, R> {
        fluent_builders::GetEventTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetExternalModels` operation.
    ///
    /// See [`GetExternalModels`](crate::client::fluent_builders::GetExternalModels) for more information about the
    /// operation and its arguments.
    pub fn get_external_models(&self) -> fluent_builders::GetExternalModels<C, M, R> {
        fluent_builders::GetExternalModels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetKMSEncryptionKey` operation.
    ///
    /// See [`GetKMSEncryptionKey`](crate::client::fluent_builders::GetKMSEncryptionKey) for more information about the
    /// operation and its arguments.
    pub fn get_kms_encryption_key(&self) -> fluent_builders::GetKMSEncryptionKey<C, M, R> {
        fluent_builders::GetKMSEncryptionKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLabels` operation.
    ///
    /// See [`GetLabels`](crate::client::fluent_builders::GetLabels) for more information about the
    /// operation and its arguments.
    pub fn get_labels(&self) -> fluent_builders::GetLabels<C, M, R> {
        fluent_builders::GetLabels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetModels` operation.
    ///
    /// See [`GetModels`](crate::client::fluent_builders::GetModels) for more information about the
    /// operation and its arguments.
    pub fn get_models(&self) -> fluent_builders::GetModels<C, M, R> {
        fluent_builders::GetModels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetModelVersion` operation.
    ///
    /// See [`GetModelVersion`](crate::client::fluent_builders::GetModelVersion) for more information about the
    /// operation and its arguments.
    pub fn get_model_version(&self) -> fluent_builders::GetModelVersion<C, M, R> {
        fluent_builders::GetModelVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetOutcomes` operation.
    ///
    /// See [`GetOutcomes`](crate::client::fluent_builders::GetOutcomes) for more information about the
    /// operation and its arguments.
    pub fn get_outcomes(&self) -> fluent_builders::GetOutcomes<C, M, R> {
        fluent_builders::GetOutcomes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRules` operation.
    ///
    /// See [`GetRules`](crate::client::fluent_builders::GetRules) for more information about the
    /// operation and its arguments.
    pub fn get_rules(&self) -> fluent_builders::GetRules<C, M, R> {
        fluent_builders::GetRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetVariables` operation.
    ///
    /// See [`GetVariables`](crate::client::fluent_builders::GetVariables) for more information about the
    /// operation and its arguments.
    pub fn get_variables(&self) -> fluent_builders::GetVariables<C, M, R> {
        fluent_builders::GetVariables::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutDetector` operation.
    ///
    /// See [`PutDetector`](crate::client::fluent_builders::PutDetector) for more information about the
    /// operation and its arguments.
    pub fn put_detector(&self) -> fluent_builders::PutDetector<C, M, R> {
        fluent_builders::PutDetector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutEntityType` operation.
    ///
    /// See [`PutEntityType`](crate::client::fluent_builders::PutEntityType) for more information about the
    /// operation and its arguments.
    pub fn put_entity_type(&self) -> fluent_builders::PutEntityType<C, M, R> {
        fluent_builders::PutEntityType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutEventType` operation.
    ///
    /// See [`PutEventType`](crate::client::fluent_builders::PutEventType) for more information about the
    /// operation and its arguments.
    pub fn put_event_type(&self) -> fluent_builders::PutEventType<C, M, R> {
        fluent_builders::PutEventType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutExternalModel` operation.
    ///
    /// See [`PutExternalModel`](crate::client::fluent_builders::PutExternalModel) for more information about the
    /// operation and its arguments.
    pub fn put_external_model(&self) -> fluent_builders::PutExternalModel<C, M, R> {
        fluent_builders::PutExternalModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutKMSEncryptionKey` operation.
    ///
    /// See [`PutKMSEncryptionKey`](crate::client::fluent_builders::PutKMSEncryptionKey) for more information about the
    /// operation and its arguments.
    pub fn put_kms_encryption_key(&self) -> fluent_builders::PutKMSEncryptionKey<C, M, R> {
        fluent_builders::PutKMSEncryptionKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutLabel` operation.
    ///
    /// See [`PutLabel`](crate::client::fluent_builders::PutLabel) for more information about the
    /// operation and its arguments.
    pub fn put_label(&self) -> fluent_builders::PutLabel<C, M, R> {
        fluent_builders::PutLabel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutOutcome` operation.
    ///
    /// See [`PutOutcome`](crate::client::fluent_builders::PutOutcome) for more information about the
    /// operation and its arguments.
    pub fn put_outcome(&self) -> fluent_builders::PutOutcome<C, M, R> {
        fluent_builders::PutOutcome::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendEvent` operation.
    ///
    /// See [`SendEvent`](crate::client::fluent_builders::SendEvent) for more information about the
    /// operation and its arguments.
    pub fn send_event(&self) -> fluent_builders::SendEvent<C, M, R> {
        fluent_builders::SendEvent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDetectorVersion` operation.
    ///
    /// See [`UpdateDetectorVersion`](crate::client::fluent_builders::UpdateDetectorVersion) for more information about the
    /// operation and its arguments.
    pub fn update_detector_version(&self) -> fluent_builders::UpdateDetectorVersion<C, M, R> {
        fluent_builders::UpdateDetectorVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDetectorVersionMetadata` operation.
    ///
    /// See [`UpdateDetectorVersionMetadata`](crate::client::fluent_builders::UpdateDetectorVersionMetadata) for more information about the
    /// operation and its arguments.
    pub fn update_detector_version_metadata(
        &self,
    ) -> fluent_builders::UpdateDetectorVersionMetadata<C, M, R> {
        fluent_builders::UpdateDetectorVersionMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDetectorVersionStatus` operation.
    ///
    /// See [`UpdateDetectorVersionStatus`](crate::client::fluent_builders::UpdateDetectorVersionStatus) for more information about the
    /// operation and its arguments.
    pub fn update_detector_version_status(
        &self,
    ) -> fluent_builders::UpdateDetectorVersionStatus<C, M, R> {
        fluent_builders::UpdateDetectorVersionStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateEventLabel` operation.
    ///
    /// See [`UpdateEventLabel`](crate::client::fluent_builders::UpdateEventLabel) for more information about the
    /// operation and its arguments.
    pub fn update_event_label(&self) -> fluent_builders::UpdateEventLabel<C, M, R> {
        fluent_builders::UpdateEventLabel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateModel` operation.
    ///
    /// See [`UpdateModel`](crate::client::fluent_builders::UpdateModel) for more information about the
    /// operation and its arguments.
    pub fn update_model(&self) -> fluent_builders::UpdateModel<C, M, R> {
        fluent_builders::UpdateModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateModelVersion` operation.
    ///
    /// See [`UpdateModelVersion`](crate::client::fluent_builders::UpdateModelVersion) for more information about the
    /// operation and its arguments.
    pub fn update_model_version(&self) -> fluent_builders::UpdateModelVersion<C, M, R> {
        fluent_builders::UpdateModelVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateModelVersionStatus` operation.
    ///
    /// See [`UpdateModelVersionStatus`](crate::client::fluent_builders::UpdateModelVersionStatus) for more information about the
    /// operation and its arguments.
    pub fn update_model_version_status(
        &self,
    ) -> fluent_builders::UpdateModelVersionStatus<C, M, R> {
        fluent_builders::UpdateModelVersionStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRuleMetadata` operation.
    ///
    /// See [`UpdateRuleMetadata`](crate::client::fluent_builders::UpdateRuleMetadata) for more information about the
    /// operation and its arguments.
    pub fn update_rule_metadata(&self) -> fluent_builders::UpdateRuleMetadata<C, M, R> {
        fluent_builders::UpdateRuleMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRuleVersion` operation.
    ///
    /// See [`UpdateRuleVersion`](crate::client::fluent_builders::UpdateRuleVersion) for more information about the
    /// operation and its arguments.
    pub fn update_rule_version(&self) -> fluent_builders::UpdateRuleVersion<C, M, R> {
        fluent_builders::UpdateRuleVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateVariable` operation.
    ///
    /// See [`UpdateVariable`](crate::client::fluent_builders::UpdateVariable) for more information about the
    /// operation and its arguments.
    pub fn update_variable(&self) -> fluent_builders::UpdateVariable<C, M, R> {
        fluent_builders::UpdateVariable::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchCreateVariable`.
    ///
    /// <p>Creates a batch of variables.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchCreateVariable<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_create_variable_input::Builder,
    }
    impl<C, M, R> BatchCreateVariable<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchCreateVariable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchCreateVariableOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchCreateVariableError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchCreateVariableInputOperationOutputAlias,
                crate::output::BatchCreateVariableOutput,
                crate::error::BatchCreateVariableError,
                crate::input::BatchCreateVariableInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `variableEntries`.
        ///
        /// To override the contents of this collection use [`set_variable_entries`](Self::set_variable_entries).
        ///
        /// <p>The list of variables for the batch create variable request.</p>
        pub fn variable_entries(mut self, inp: impl Into<crate::model::VariableEntry>) -> Self {
            self.inner = self.inner.variable_entries(inp);
            self
        }
        /// <p>The list of variables for the batch create variable request.</p>
        pub fn set_variable_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VariableEntry>>,
        ) -> Self {
            self.inner = self.inner.set_variable_entries(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetVariable`.
    ///
    /// <p>Gets a batch of variables.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchGetVariable<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_variable_input::Builder,
    }
    impl<C, M, R> BatchGetVariable<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetVariable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetVariableOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetVariableError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetVariableInputOperationOutputAlias,
                crate::output::BatchGetVariableOutput,
                crate::error::BatchGetVariableError,
                crate::input::BatchGetVariableInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>The list of variable names to get.</p>
        pub fn names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.names(inp);
            self
        }
        /// <p>The list of variable names to get.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelBatchImportJob`.
    ///
    /// <p> Cancels an in-progress batch import job.</p>
    #[derive(std::fmt::Debug)]
    pub struct CancelBatchImportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_batch_import_job_input::Builder,
    }
    impl<C, M, R> CancelBatchImportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelBatchImportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelBatchImportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelBatchImportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelBatchImportJobInputOperationOutputAlias,
                crate::output::CancelBatchImportJobOutput,
                crate::error::CancelBatchImportJobError,
                crate::input::CancelBatchImportJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p> The ID of an in-progress batch import job to cancel. </p>
        /// <p>Amazon Fraud Detector will throw an error if the batch import job is in <code>FAILED</code>, <code>CANCELED</code>, or  <code>COMPLETED</code> state.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p> The ID of an in-progress batch import job to cancel. </p>
        /// <p>Amazon Fraud Detector will throw an error if the batch import job is in <code>FAILED</code>, <code>CANCELED</code>, or  <code>COMPLETED</code> state.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelBatchPredictionJob`.
    ///
    /// <p>Cancels the specified batch prediction job.</p>
    #[derive(std::fmt::Debug)]
    pub struct CancelBatchPredictionJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_batch_prediction_job_input::Builder,
    }
    impl<C, M, R> CancelBatchPredictionJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelBatchPredictionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelBatchPredictionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelBatchPredictionJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelBatchPredictionJobInputOperationOutputAlias,
                crate::output::CancelBatchPredictionJobOutput,
                crate::error::CancelBatchPredictionJobError,
                crate::input::CancelBatchPredictionJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the batch prediction job to cancel.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The ID of the batch prediction job to cancel.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBatchImportJob`.
    ///
    /// <p>Creates a batch import job. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateBatchImportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_batch_import_job_input::Builder,
    }
    impl<C, M, R> CreateBatchImportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBatchImportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBatchImportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBatchImportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBatchImportJobInputOperationOutputAlias,
                crate::output::CreateBatchImportJobOutput,
                crate::error::CreateBatchImportJobError,
                crate::input::CreateBatchImportJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the batch import job. The ID cannot be of a past job, unless the job exists in <code>CREATE_FAILED</code> state.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The ID of the batch import job. The ID cannot be of a past job, unless the job exists in <code>CREATE_FAILED</code> state.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The URI that points to the Amazon S3 location of your data file.</p>
        pub fn input_path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_path(inp);
            self
        }
        /// <p>The URI that points to the Amazon S3 location of your data file.</p>
        pub fn set_input_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_input_path(input);
            self
        }
        /// <p>The URI that points to the Amazon S3 location for storing your results. </p>
        pub fn output_path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.output_path(inp);
            self
        }
        /// <p>The URI that points to the Amazon S3 location for storing your results. </p>
        pub fn set_output_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_output_path(input);
            self
        }
        /// <p>The name of the event type.</p>
        pub fn event_type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_type_name(inp);
            self
        }
        /// <p>The name of the event type.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_type_name(input);
            self
        }
        /// <p>The ARN of the IAM role created for Amazon S3 bucket that holds your data file.
        /// The IAM role must have read and write permissions to both input and output S3 buckets.</p>
        pub fn iam_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_role_arn(inp);
            self
        }
        /// <p>The ARN of the IAM role created for Amazon S3 bucket that holds your data file.
        /// The IAM role must have read and write permissions to both input and output S3 buckets.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_iam_role_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key-value pairs associated with this request.  </p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A collection of key-value pairs associated with this request.  </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBatchPredictionJob`.
    ///
    /// <p>Creates a batch prediction job.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateBatchPredictionJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_batch_prediction_job_input::Builder,
    }
    impl<C, M, R> CreateBatchPredictionJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBatchPredictionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBatchPredictionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBatchPredictionJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBatchPredictionJobInputOperationOutputAlias,
                crate::output::CreateBatchPredictionJobOutput,
                crate::error::CreateBatchPredictionJobError,
                crate::input::CreateBatchPredictionJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the batch prediction job.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The ID of the batch prediction job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The Amazon S3 location of your training file.</p>
        pub fn input_path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_path(inp);
            self
        }
        /// <p>The Amazon S3 location of your training file.</p>
        pub fn set_input_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_input_path(input);
            self
        }
        /// <p>The Amazon S3 location of your output file.</p>
        pub fn output_path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.output_path(inp);
            self
        }
        /// <p>The Amazon S3 location of your output file.</p>
        pub fn set_output_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_output_path(input);
            self
        }
        /// <p>The name of the event type.</p>
        pub fn event_type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_type_name(inp);
            self
        }
        /// <p>The name of the event type.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_type_name(input);
            self
        }
        /// <p>The name of the detector.</p>
        pub fn detector_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_name(inp);
            self
        }
        /// <p>The name of the detector.</p>
        pub fn set_detector_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_detector_name(input);
            self
        }
        /// <p>The detector version.</p>
        pub fn detector_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_version(inp);
            self
        }
        /// <p>The detector version.</p>
        pub fn set_detector_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_detector_version(input);
            self
        }
        /// <p>The ARN of the IAM role to use for this job request.</p>
        pub fn iam_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_role_arn(inp);
            self
        }
        /// <p>The ARN of the IAM role to use for this job request.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_iam_role_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDetectorVersion`.
    ///
    /// <p>Creates a detector version. The detector version starts in a <code>DRAFT</code> status.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDetectorVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_detector_version_input::Builder,
    }
    impl<C, M, R> CreateDetectorVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDetectorVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDetectorVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDetectorVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDetectorVersionInputOperationOutputAlias,
                crate::output::CreateDetectorVersionOutput,
                crate::error::CreateDetectorVersionError,
                crate::input::CreateDetectorVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the detector under which you want to create a new version.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The ID of the detector under which you want to create a new version.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The description of the detector version.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the detector version.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `externalModelEndpoints`.
        ///
        /// To override the contents of this collection use [`set_external_model_endpoints`](Self::set_external_model_endpoints).
        ///
        /// <p>The Amazon Sagemaker model endpoints to include in the detector version.</p>
        pub fn external_model_endpoints(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_model_endpoints(inp);
            self
        }
        /// <p>The Amazon Sagemaker model endpoints to include in the detector version.</p>
        pub fn set_external_model_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_external_model_endpoints(input);
            self
        }
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>The rules to include in the detector version.</p>
        pub fn rules(mut self, inp: impl Into<crate::model::Rule>) -> Self {
            self.inner = self.inner.rules(inp);
            self
        }
        /// <p>The rules to include in the detector version.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.inner = self.inner.set_rules(input);
            self
        }
        /// Appends an item to `modelVersions`.
        ///
        /// To override the contents of this collection use [`set_model_versions`](Self::set_model_versions).
        ///
        /// <p>The model versions to include in the detector version.</p>
        pub fn model_versions(mut self, inp: impl Into<crate::model::ModelVersion>) -> Self {
            self.inner = self.inner.model_versions(inp);
            self
        }
        /// <p>The model versions to include in the detector version.</p>
        pub fn set_model_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ModelVersion>>,
        ) -> Self {
            self.inner = self.inner.set_model_versions(input);
            self
        }
        /// <p>The rule execution mode for the rules included in the detector version.</p>
        /// <p>You can define and edit the rule mode at the detector version level, when it is in draft status.</p>
        /// <p>If you specify <code>FIRST_MATCHED</code>, Amazon Fraud Detector evaluates rules sequentially, first to last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule.</p>
        /// <p>If you specifiy <code>ALL_MATCHED</code>, Amazon Fraud Detector evaluates all rules and returns the outcomes for all matched rules. </p>
        /// <p>The default behavior is <code>FIRST_MATCHED</code>.</p>
        pub fn rule_execution_mode(mut self, inp: crate::model::RuleExecutionMode) -> Self {
            self.inner = self.inner.rule_execution_mode(inp);
            self
        }
        /// <p>The rule execution mode for the rules included in the detector version.</p>
        /// <p>You can define and edit the rule mode at the detector version level, when it is in draft status.</p>
        /// <p>If you specify <code>FIRST_MATCHED</code>, Amazon Fraud Detector evaluates rules sequentially, first to last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule.</p>
        /// <p>If you specifiy <code>ALL_MATCHED</code>, Amazon Fraud Detector evaluates all rules and returns the outcomes for all matched rules. </p>
        /// <p>The default behavior is <code>FIRST_MATCHED</code>.</p>
        pub fn set_rule_execution_mode(
            mut self,
            input: std::option::Option<crate::model::RuleExecutionMode>,
        ) -> Self {
            self.inner = self.inner.set_rule_execution_mode(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateModel`.
    ///
    /// <p>Creates a model using the specified model type.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateModel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_model_input::Builder,
    }
    impl<C, M, R> CreateModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateModelOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateModelInputOperationOutputAlias,
                crate::output::CreateModelOutput,
                crate::error::CreateModelError,
                crate::input::CreateModelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The model ID.</p>
        pub fn model_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_id(inp);
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_id(input);
            self
        }
        /// <p>The model type. </p>
        pub fn model_type(mut self, inp: crate::model::ModelTypeEnum) -> Self {
            self.inner = self.inner.model_type(inp);
            self
        }
        /// <p>The model type. </p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_model_type(input);
            self
        }
        /// <p>The model description. </p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The model description. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The name of the event type.</p>
        pub fn event_type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_type_name(inp);
            self
        }
        /// <p>The name of the event type.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_type_name(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateModelVersion`.
    ///
    /// <p>Creates a version of the model using the specified model type and model id.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateModelVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_model_version_input::Builder,
    }
    impl<C, M, R> CreateModelVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateModelVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateModelVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateModelVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateModelVersionInputOperationOutputAlias,
                crate::output::CreateModelVersionOutput,
                crate::error::CreateModelVersionError,
                crate::input::CreateModelVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The model ID. </p>
        pub fn model_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_id(inp);
            self
        }
        /// <p>The model ID. </p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_id(input);
            self
        }
        /// <p>The model type.</p>
        pub fn model_type(mut self, inp: crate::model::ModelTypeEnum) -> Self {
            self.inner = self.inner.model_type(inp);
            self
        }
        /// <p>The model type.</p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_model_type(input);
            self
        }
        /// <p>The training data source location in Amazon S3. </p>
        pub fn training_data_source(mut self, inp: crate::model::TrainingDataSourceEnum) -> Self {
            self.inner = self.inner.training_data_source(inp);
            self
        }
        /// <p>The training data source location in Amazon S3. </p>
        pub fn set_training_data_source(
            mut self,
            input: std::option::Option<crate::model::TrainingDataSourceEnum>,
        ) -> Self {
            self.inner = self.inner.set_training_data_source(input);
            self
        }
        /// <p>The training data schema.</p>
        pub fn training_data_schema(mut self, inp: crate::model::TrainingDataSchema) -> Self {
            self.inner = self.inner.training_data_schema(inp);
            self
        }
        /// <p>The training data schema.</p>
        pub fn set_training_data_schema(
            mut self,
            input: std::option::Option<crate::model::TrainingDataSchema>,
        ) -> Self {
            self.inner = self.inner.set_training_data_schema(input);
            self
        }
        /// <p>Details of the external events data used for model version training. Required if <code>trainingDataSource</code> is <code>EXTERNAL_EVENTS</code>.</p>
        pub fn external_events_detail(mut self, inp: crate::model::ExternalEventsDetail) -> Self {
            self.inner = self.inner.external_events_detail(inp);
            self
        }
        /// <p>Details of the external events data used for model version training. Required if <code>trainingDataSource</code> is <code>EXTERNAL_EVENTS</code>.</p>
        pub fn set_external_events_detail(
            mut self,
            input: std::option::Option<crate::model::ExternalEventsDetail>,
        ) -> Self {
            self.inner = self.inner.set_external_events_detail(input);
            self
        }
        /// <p>Details of the ingested events data used for model version training. Required if <code>trainingDataSource</code> is <code>INGESTED_EVENTS</code>.</p>
        pub fn ingested_events_detail(mut self, inp: crate::model::IngestedEventsDetail) -> Self {
            self.inner = self.inner.ingested_events_detail(inp);
            self
        }
        /// <p>Details of the ingested events data used for model version training. Required if <code>trainingDataSource</code> is <code>INGESTED_EVENTS</code>.</p>
        pub fn set_ingested_events_detail(
            mut self,
            input: std::option::Option<crate::model::IngestedEventsDetail>,
        ) -> Self {
            self.inner = self.inner.set_ingested_events_detail(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRule`.
    ///
    /// <p>Creates a rule for use with the specified detector. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_rule_input::Builder,
    }
    impl<C, M, R> CreateRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRuleInputOperationOutputAlias,
                crate::output::CreateRuleOutput,
                crate::error::CreateRuleError,
                crate::input::CreateRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The rule ID.</p>
        pub fn rule_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_id(inp);
            self
        }
        /// <p>The rule ID.</p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_id(input);
            self
        }
        /// <p>The detector ID for the rule's parent detector.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The detector ID for the rule's parent detector.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The rule description.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The rule description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The rule expression.</p>
        pub fn expression(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expression(inp);
            self
        }
        /// <p>The rule expression.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_expression(input);
            self
        }
        /// <p>The language of the rule.</p>
        pub fn language(mut self, inp: crate::model::Language) -> Self {
            self.inner = self.inner.language(inp);
            self
        }
        /// <p>The language of the rule.</p>
        pub fn set_language(mut self, input: std::option::Option<crate::model::Language>) -> Self {
            self.inner = self.inner.set_language(input);
            self
        }
        /// Appends an item to `outcomes`.
        ///
        /// To override the contents of this collection use [`set_outcomes`](Self::set_outcomes).
        ///
        /// <p>The outcome or outcomes returned when the rule expression matches.</p>
        pub fn outcomes(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.outcomes(inp);
            self
        }
        /// <p>The outcome or outcomes returned when the rule expression matches.</p>
        pub fn set_outcomes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_outcomes(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateVariable`.
    ///
    /// <p>Creates a variable.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateVariable<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_variable_input::Builder,
    }
    impl<C, M, R> CreateVariable<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateVariable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateVariableOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateVariableError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateVariableInputOperationOutputAlias,
                crate::output::CreateVariableOutput,
                crate::error::CreateVariableError,
                crate::input::CreateVariableInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the variable.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the variable.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The data type.</p>
        pub fn data_type(mut self, inp: crate::model::DataType) -> Self {
            self.inner = self.inner.data_type(inp);
            self
        }
        /// <p>The data type.</p>
        pub fn set_data_type(mut self, input: std::option::Option<crate::model::DataType>) -> Self {
            self.inner = self.inner.set_data_type(input);
            self
        }
        /// <p>The source of the data.</p>
        pub fn data_source(mut self, inp: crate::model::DataSource) -> Self {
            self.inner = self.inner.data_source(inp);
            self
        }
        /// <p>The source of the data.</p>
        pub fn set_data_source(
            mut self,
            input: std::option::Option<crate::model::DataSource>,
        ) -> Self {
            self.inner = self.inner.set_data_source(input);
            self
        }
        /// <p>The default value for the variable when no value is received.</p>
        pub fn default_value(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_value(inp);
            self
        }
        /// <p>The default value for the variable when no value is received.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_value(input);
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The variable type. For more information see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable types</a>.
        /// </p>
        /// <p>Valid Values: <code>AUTH_CODE | AVS | BILLING_ADDRESS_L1 | BILLING_ADDRESS_L2 | BILLING_CITY | BILLING_COUNTRY | BILLING_NAME | BILLING_PHONE | BILLING_STATE | BILLING_ZIP | CARD_BIN | CATEGORICAL | CURRENCY_CODE | EMAIL_ADDRESS | FINGERPRINT | FRAUD_LABEL | FREE_FORM_TEXT | IP_ADDRESS | NUMERIC | ORDER_ID | PAYMENT_TYPE | PHONE_NUMBER | PRICE | PRODUCT_CATEGORY | SHIPPING_ADDRESS_L1 | SHIPPING_ADDRESS_L2 | SHIPPING_CITY | SHIPPING_COUNTRY | SHIPPING_NAME | SHIPPING_PHONE | SHIPPING_STATE | SHIPPING_ZIP | USERAGENT</code>
        /// </p>
        pub fn variable_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.variable_type(inp);
            self
        }
        /// <p>The variable type. For more information see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable types</a>.
        /// </p>
        /// <p>Valid Values: <code>AUTH_CODE | AVS | BILLING_ADDRESS_L1 | BILLING_ADDRESS_L2 | BILLING_CITY | BILLING_COUNTRY | BILLING_NAME | BILLING_PHONE | BILLING_STATE | BILLING_ZIP | CARD_BIN | CATEGORICAL | CURRENCY_CODE | EMAIL_ADDRESS | FINGERPRINT | FRAUD_LABEL | FREE_FORM_TEXT | IP_ADDRESS | NUMERIC | ORDER_ID | PAYMENT_TYPE | PHONE_NUMBER | PRICE | PRODUCT_CATEGORY | SHIPPING_ADDRESS_L1 | SHIPPING_ADDRESS_L2 | SHIPPING_CITY | SHIPPING_COUNTRY | SHIPPING_NAME | SHIPPING_PHONE | SHIPPING_STATE | SHIPPING_ZIP | USERAGENT</code>
        /// </p>
        pub fn set_variable_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_variable_type(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBatchImportJob`.
    ///
    /// <p>Deletes data that was batch imported to Amazon Fraud Detector. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBatchImportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_batch_import_job_input::Builder,
    }
    impl<C, M, R> DeleteBatchImportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBatchImportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBatchImportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBatchImportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBatchImportJobInputOperationOutputAlias,
                crate::output::DeleteBatchImportJobOutput,
                crate::error::DeleteBatchImportJobError,
                crate::input::DeleteBatchImportJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the batch import job to delete. </p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The ID of the batch import job to delete. </p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBatchPredictionJob`.
    ///
    /// <p>Deletes a batch prediction job.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBatchPredictionJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_batch_prediction_job_input::Builder,
    }
    impl<C, M, R> DeleteBatchPredictionJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBatchPredictionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBatchPredictionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBatchPredictionJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBatchPredictionJobInputOperationOutputAlias,
                crate::output::DeleteBatchPredictionJobOutput,
                crate::error::DeleteBatchPredictionJobError,
                crate::input::DeleteBatchPredictionJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the batch prediction job to delete.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The ID of the batch prediction job to delete.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDetector`.
    ///
    /// <p>Deletes the detector. Before deleting a detector, you must first delete all detector versions and rule versions associated with the detector.</p>
    /// <p>When you delete a detector, Amazon Fraud Detector permanently deletes the detector and the data is no longer stored in Amazon Fraud Detector.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDetector<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_detector_input::Builder,
    }
    impl<C, M, R> DeleteDetector<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDetector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDetectorOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDetectorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDetectorInputOperationOutputAlias,
                crate::output::DeleteDetectorOutput,
                crate::error::DeleteDetectorError,
                crate::input::DeleteDetectorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the detector to delete.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The ID of the detector to delete.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDetectorVersion`.
    ///
    /// <p>Deletes the detector version. You cannot delete detector versions that are in <code>ACTIVE</code> status.</p>
    /// <p>When you delete a detector version, Amazon Fraud Detector permanently deletes the detector and the data is no longer stored in Amazon Fraud Detector.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDetectorVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_detector_version_input::Builder,
    }
    impl<C, M, R> DeleteDetectorVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDetectorVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDetectorVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDetectorVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDetectorVersionInputOperationOutputAlias,
                crate::output::DeleteDetectorVersionOutput,
                crate::error::DeleteDetectorVersionError,
                crate::input::DeleteDetectorVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the parent detector for the detector version to delete.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The ID of the parent detector for the detector version to delete.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The ID of the detector version to delete.</p>
        pub fn detector_version_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_version_id(inp);
            self
        }
        /// <p>The ID of the detector version to delete.</p>
        pub fn set_detector_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_detector_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEntityType`.
    ///
    /// <p>Deletes an entity type.</p>
    /// <p>You cannot delete an entity type that is included in an event type.</p>
    /// <p>When you delete an entity type, Amazon Fraud Detector permanently deletes that entity type and the data is no longer stored in Amazon Fraud Detector.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteEntityType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_entity_type_input::Builder,
    }
    impl<C, M, R> DeleteEntityType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEntityType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEntityTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEntityTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEntityTypeInputOperationOutputAlias,
                crate::output::DeleteEntityTypeOutput,
                crate::error::DeleteEntityTypeError,
                crate::input::DeleteEntityTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the entity type to delete.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the entity type to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEvent`.
    ///
    /// <p>Deletes the specified event.</p>
    /// <p>When you delete an event, Amazon Fraud Detector permanently deletes that event and the event data is no longer stored in Amazon Fraud Detector.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteEvent<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_event_input::Builder,
    }
    impl<C, M, R> DeleteEvent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEvent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEventOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEventError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEventInputOperationOutputAlias,
                crate::output::DeleteEventOutput,
                crate::error::DeleteEventError,
                crate::input::DeleteEventInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the event to delete.</p>
        pub fn event_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_id(inp);
            self
        }
        /// <p>The ID of the event to delete.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_event_id(input);
            self
        }
        /// <p>The name of the event type.</p>
        pub fn event_type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_type_name(inp);
            self
        }
        /// <p>The name of the event type.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_type_name(input);
            self
        }
        /// <p>Specifies whether or not to delete any predictions associated with the event.</p>
        pub fn delete_audit_history(mut self, inp: bool) -> Self {
            self.inner = self.inner.delete_audit_history(inp);
            self
        }
        /// <p>Specifies whether or not to delete any predictions associated with the event.</p>
        pub fn set_delete_audit_history(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_delete_audit_history(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEventsByEventType`.
    ///
    /// <p>Deletes all events of a particular event type.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteEventsByEventType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_events_by_event_type_input::Builder,
    }
    impl<C, M, R> DeleteEventsByEventType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEventsByEventType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEventsByEventTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEventsByEventTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEventsByEventTypeInputOperationOutputAlias,
                crate::output::DeleteEventsByEventTypeOutput,
                crate::error::DeleteEventsByEventTypeError,
                crate::input::DeleteEventsByEventTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the event type.</p>
        pub fn event_type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_type_name(inp);
            self
        }
        /// <p>The name of the event type.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_type_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEventType`.
    ///
    /// <p>Deletes an event type.</p>
    /// <p>You cannot delete an event type that is used in a detector or a model.</p>
    /// <p>When you delete an event type, Amazon Fraud Detector permanently deletes that event type and the data is no longer stored in Amazon Fraud Detector.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteEventType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_event_type_input::Builder,
    }
    impl<C, M, R> DeleteEventType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEventType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEventTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEventTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEventTypeInputOperationOutputAlias,
                crate::output::DeleteEventTypeOutput,
                crate::error::DeleteEventTypeError,
                crate::input::DeleteEventTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the event type to delete.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the event type to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteExternalModel`.
    ///
    /// <p>Removes a SageMaker model from Amazon Fraud Detector.</p>
    /// <p>You can remove an Amazon SageMaker model if it is not associated with a detector version. Removing a SageMaker model disconnects it from Amazon Fraud Detector, but the model remains available in SageMaker.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteExternalModel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_external_model_input::Builder,
    }
    impl<C, M, R> DeleteExternalModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteExternalModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteExternalModelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteExternalModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteExternalModelInputOperationOutputAlias,
                crate::output::DeleteExternalModelOutput,
                crate::error::DeleteExternalModelError,
                crate::input::DeleteExternalModelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The endpoint of the Amazon Sagemaker model to delete.</p>
        pub fn model_endpoint(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_endpoint(inp);
            self
        }
        /// <p>The endpoint of the Amazon Sagemaker model to delete.</p>
        pub fn set_model_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_endpoint(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLabel`.
    ///
    /// <p>Deletes a label.</p>
    /// <p>You cannot delete labels that are included in an event type in Amazon Fraud Detector.</p>
    /// <p>You cannot delete a label assigned to an event ID. You must first delete the relevant event ID.</p>
    ///
    /// <p>When you delete a label, Amazon Fraud Detector permanently deletes that label and the data is no longer stored in Amazon Fraud Detector.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteLabel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_label_input::Builder,
    }
    impl<C, M, R> DeleteLabel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLabel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLabelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLabelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLabelInputOperationOutputAlias,
                crate::output::DeleteLabelOutput,
                crate::error::DeleteLabelError,
                crate::input::DeleteLabelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the label to delete.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the label to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteModel`.
    ///
    /// <p>Deletes a model.</p>
    /// <p>You can delete models and model versions in Amazon Fraud Detector, provided that they are not associated with a detector version.</p>
    /// <p> When you delete a model, Amazon Fraud Detector permanently deletes that model and the data is no longer stored in Amazon Fraud Detector.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteModel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_model_input::Builder,
    }
    impl<C, M, R> DeleteModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteModelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteModelInputOperationOutputAlias,
                crate::output::DeleteModelOutput,
                crate::error::DeleteModelError,
                crate::input::DeleteModelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The model ID of the model to delete.</p>
        pub fn model_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_id(inp);
            self
        }
        /// <p>The model ID of the model to delete.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_id(input);
            self
        }
        /// <p>The model type of the model to delete.</p>
        pub fn model_type(mut self, inp: crate::model::ModelTypeEnum) -> Self {
            self.inner = self.inner.model_type(inp);
            self
        }
        /// <p>The model type of the model to delete.</p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_model_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteModelVersion`.
    ///
    /// <p>Deletes a model version.</p>
    /// <p>You can delete models and model versions in Amazon Fraud Detector, provided that they are not associated with a detector version.</p>
    /// <p> When you delete a model version, Amazon Fraud Detector permanently deletes that model version and the data is no longer stored in Amazon Fraud Detector.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteModelVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_model_version_input::Builder,
    }
    impl<C, M, R> DeleteModelVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteModelVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteModelVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteModelVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteModelVersionInputOperationOutputAlias,
                crate::output::DeleteModelVersionOutput,
                crate::error::DeleteModelVersionError,
                crate::input::DeleteModelVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The model ID of the model version to delete.</p>
        pub fn model_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_id(inp);
            self
        }
        /// <p>The model ID of the model version to delete.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_id(input);
            self
        }
        /// <p>The model type of the model version to delete.</p>
        pub fn model_type(mut self, inp: crate::model::ModelTypeEnum) -> Self {
            self.inner = self.inner.model_type(inp);
            self
        }
        /// <p>The model type of the model version to delete.</p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_model_type(input);
            self
        }
        /// <p>The model version number of the model version to delete.</p>
        pub fn model_version_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_version_number(inp);
            self
        }
        /// <p>The model version number of the model version to delete.</p>
        pub fn set_model_version_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_version_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteOutcome`.
    ///
    /// <p>Deletes an outcome.</p>
    /// <p>You cannot delete an outcome that is used in a rule version.</p>
    /// <p>When you delete an outcome, Amazon Fraud Detector permanently deletes that outcome and the data is no longer stored in Amazon Fraud Detector.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteOutcome<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_outcome_input::Builder,
    }
    impl<C, M, R> DeleteOutcome<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteOutcome`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteOutcomeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteOutcomeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteOutcomeInputOperationOutputAlias,
                crate::output::DeleteOutcomeOutput,
                crate::error::DeleteOutcomeError,
                crate::input::DeleteOutcomeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the outcome to delete.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the outcome to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRule`.
    ///
    /// <p>Deletes the rule. You cannot delete a rule if it is used by an <code>ACTIVE</code> or <code>INACTIVE</code> detector version.</p>
    /// <p>When you delete a rule, Amazon Fraud Detector permanently deletes that rule and the data is no longer stored in Amazon Fraud Detector.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_rule_input::Builder,
    }
    impl<C, M, R> DeleteRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRuleInputOperationOutputAlias,
                crate::output::DeleteRuleOutput,
                crate::error::DeleteRuleError,
                crate::input::DeleteRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A rule.</p>
        pub fn rule(mut self, inp: crate::model::Rule) -> Self {
            self.inner = self.inner.rule(inp);
            self
        }
        /// <p>A rule.</p>
        pub fn set_rule(mut self, input: std::option::Option<crate::model::Rule>) -> Self {
            self.inner = self.inner.set_rule(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVariable`.
    ///
    /// <p>Deletes a variable.</p>
    /// <p>You can't delete variables that are included in an event type in Amazon Fraud Detector.</p>
    /// <p>Amazon Fraud Detector automatically deletes model output variables and SageMaker model output variables when you delete the model. You can't delete these variables manually.</p>
    /// <p>When you delete a variable, Amazon Fraud Detector permanently deletes that variable and the data is no longer stored in Amazon Fraud Detector.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteVariable<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_variable_input::Builder,
    }
    impl<C, M, R> DeleteVariable<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVariable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVariableOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVariableError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteVariableInputOperationOutputAlias,
                crate::output::DeleteVariableOutput,
                crate::error::DeleteVariableError,
                crate::input::DeleteVariableInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the variable to delete.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the variable to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDetector`.
    ///
    /// <p>Gets all versions for a specified detector.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDetector<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_detector_input::Builder,
    }
    impl<C, M, R> DescribeDetector<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDetector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDetectorOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDetectorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDetectorInputOperationOutputAlias,
                crate::output::DescribeDetectorOutput,
                crate::error::DescribeDetectorError,
                crate::input::DescribeDetectorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The detector ID.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The detector ID.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The next token from the previous response.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The next token from the previous response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for the request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return for the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeModelVersions`.
    ///
    /// <p>Gets all of the model versions for the specified model type or for the specified model type and model ID. You can also get details for a single, specified model version. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeModelVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_model_versions_input::Builder,
    }
    impl<C, M, R> DescribeModelVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeModelVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeModelVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeModelVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeModelVersionsInputOperationOutputAlias,
                crate::output::DescribeModelVersionsOutput,
                crate::error::DescribeModelVersionsError,
                crate::input::DescribeModelVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The model ID.</p>
        pub fn model_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_id(inp);
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_id(input);
            self
        }
        /// <p>The model version number.</p>
        pub fn model_version_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_version_number(inp);
            self
        }
        /// <p>The model version number.</p>
        pub fn set_model_version_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_version_number(input);
            self
        }
        /// <p>The model type.</p>
        pub fn model_type(mut self, inp: crate::model::ModelTypeEnum) -> Self {
            self.inner = self.inner.model_type(inp);
            self
        }
        /// <p>The model type.</p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_model_type(input);
            self
        }
        /// <p>The next token from the previous results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The next token from the previous results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBatchImportJobs`.
    ///
    /// <p>Gets all batch import jobs or a specific job of the specified ID. This is a paginated API. If you provide a null <code>maxResults</code>,
    /// this action retrieves a maximum of 50 records per page. If you provide a <code>maxResults</code>, the value must be between 1 and 50.
    /// To get the next page results, provide the pagination token from the <code>GetBatchImportJobsResponse</code> as part of your request.
    /// A null pagination token fetches the records from the beginning.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetBatchImportJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_batch_import_jobs_input::Builder,
    }
    impl<C, M, R> GetBatchImportJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBatchImportJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBatchImportJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBatchImportJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBatchImportJobsInputOperationOutputAlias,
                crate::output::GetBatchImportJobsOutput,
                crate::error::GetBatchImportJobsError,
                crate::input::GetBatchImportJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the batch import job to get.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The ID of the batch import job to get.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The maximum number of objects to return for request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of objects to return for request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The next token from the previous request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The next token from the previous request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBatchPredictionJobs`.
    ///
    /// <p>Gets all batch prediction jobs or a specific job if you specify a job ID. This is a paginated API. If you provide a null maxResults, this action retrieves a maximum of 50 records per page. If you provide a maxResults, the value must be between 1 and 50. To get the next page results, provide the pagination token from the GetBatchPredictionJobsResponse as part of your request. A null pagination token fetches the records from the beginning.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetBatchPredictionJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_batch_prediction_jobs_input::Builder,
    }
    impl<C, M, R> GetBatchPredictionJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBatchPredictionJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBatchPredictionJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBatchPredictionJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBatchPredictionJobsInputOperationOutputAlias,
                crate::output::GetBatchPredictionJobsOutput,
                crate::error::GetBatchPredictionJobsError,
                crate::input::GetBatchPredictionJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The batch prediction job for which to get the details.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The batch prediction job for which to get the details.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The next token from the previous request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The next token from the previous request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDeleteEventsByEventTypeStatus`.
    ///
    /// <p>Retrieves the status of a <code>DeleteEventsByEventType</code> action.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDeleteEventsByEventTypeStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_delete_events_by_event_type_status_input::Builder,
    }
    impl<C, M, R> GetDeleteEventsByEventTypeStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDeleteEventsByEventTypeStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeleteEventsByEventTypeStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeleteEventsByEventTypeStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDeleteEventsByEventTypeStatusInputOperationOutputAlias,
                crate::output::GetDeleteEventsByEventTypeStatusOutput,
                crate::error::GetDeleteEventsByEventTypeStatusError,
                crate::input::GetDeleteEventsByEventTypeStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of event type for which to get the deletion status.</p>
        pub fn event_type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_type_name(inp);
            self
        }
        /// <p>Name of event type for which to get the deletion status.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_type_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDetectors`.
    ///
    /// <p>Gets all detectors or a single detector if a <code>detectorId</code> is specified. This is a paginated API. If you
    /// provide a null <code>maxResults</code>, this action retrieves a maximum of 10 records
    /// per page. If you provide a <code>maxResults</code>, the value must be between 5 and 10.
    /// To get the next page results, provide the pagination token from the
    /// <code>GetDetectorsResponse</code> as part of your request. A null pagination token
    /// fetches the records from the beginning. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetDetectors<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_detectors_input::Builder,
    }
    impl<C, M, R> GetDetectors<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDetectors`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDetectorsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDetectorsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDetectorsInputOperationOutputAlias,
                crate::output::GetDetectorsOutput,
                crate::error::GetDetectorsError,
                crate::input::GetDetectorsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The detector ID.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The detector ID.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The next token for the subsequent request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The next token for the subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDetectorVersion`.
    ///
    /// <p>Gets a particular detector version. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetDetectorVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_detector_version_input::Builder,
    }
    impl<C, M, R> GetDetectorVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDetectorVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDetectorVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDetectorVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDetectorVersionInputOperationOutputAlias,
                crate::output::GetDetectorVersionOutput,
                crate::error::GetDetectorVersionError,
                crate::input::GetDetectorVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The detector ID.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The detector ID.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The detector version ID.</p>
        pub fn detector_version_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_version_id(inp);
            self
        }
        /// <p>The detector version ID.</p>
        pub fn set_detector_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_detector_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEntityTypes`.
    ///
    /// <p>Gets all entity types or a specific entity type if a name is specified. This is a paginated API. If you
    /// provide a null <code>maxResults</code>, this action retrieves a maximum of 10 records
    /// per page. If you provide a <code>maxResults</code>, the value must be between 5 and 10.
    /// To get the next page results, provide the pagination token from the
    /// <code>GetEntityTypesResponse</code> as part of your request. A null pagination token
    /// fetches the records from the beginning. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetEntityTypes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_entity_types_input::Builder,
    }
    impl<C, M, R> GetEntityTypes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEntityTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEntityTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEntityTypesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEntityTypesInputOperationOutputAlias,
                crate::output::GetEntityTypesOutput,
                crate::error::GetEntityTypesError,
                crate::input::GetEntityTypesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The next token for the subsequent request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The next token for the subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEvent`.
    ///
    /// <p>Retrieves details of events stored with Amazon Fraud Detector. This action does not retrieve prediction results.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetEvent<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_event_input::Builder,
    }
    impl<C, M, R> GetEvent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEvent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEventOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEventError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEventInputOperationOutputAlias,
                crate::output::GetEventOutput,
                crate::error::GetEventError,
                crate::input::GetEventInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the event to retrieve.</p>
        pub fn event_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_id(inp);
            self
        }
        /// <p>The ID of the event to retrieve.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_event_id(input);
            self
        }
        /// <p>The event type of the event to retrieve.</p>
        pub fn event_type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_type_name(inp);
            self
        }
        /// <p>The event type of the event to retrieve.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_type_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEventPrediction`.
    ///
    /// <p>Evaluates an event against a detector version. If a version ID is not provided, the detector’s (<code>ACTIVE</code>) version is used.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetEventPrediction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_event_prediction_input::Builder,
    }
    impl<C, M, R> GetEventPrediction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEventPrediction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEventPredictionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEventPredictionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEventPredictionInputOperationOutputAlias,
                crate::output::GetEventPredictionOutput,
                crate::error::GetEventPredictionError,
                crate::input::GetEventPredictionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The detector ID.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The detector ID.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The detector version ID.</p>
        pub fn detector_version_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_version_id(inp);
            self
        }
        /// <p>The detector version ID.</p>
        pub fn set_detector_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_detector_version_id(input);
            self
        }
        /// <p>The unique ID used to identify the event.</p>
        pub fn event_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_id(inp);
            self
        }
        /// <p>The unique ID used to identify the event.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_event_id(input);
            self
        }
        /// <p>The event type associated with the detector specified for the prediction.</p>
        pub fn event_type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_type_name(inp);
            self
        }
        /// <p>The event type associated with the detector specified for the prediction.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_type_name(input);
            self
        }
        /// Appends an item to `entities`.
        ///
        /// To override the contents of this collection use [`set_entities`](Self::set_entities).
        ///
        /// <p>The entity type (associated with the detector's event type) and specific entity ID representing who performed the event. If an entity id is not available, use "UNKNOWN."</p>
        pub fn entities(mut self, inp: impl Into<crate::model::Entity>) -> Self {
            self.inner = self.inner.entities(inp);
            self
        }
        /// <p>The entity type (associated with the detector's event type) and specific entity ID representing who performed the event. If an entity id is not available, use "UNKNOWN."</p>
        pub fn set_entities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Entity>>,
        ) -> Self {
            self.inner = self.inner.set_entities(input);
            self
        }
        /// <p>Timestamp that defines when the event under evaluation occurred. The timestamp must be specified using ISO 8601 standard in UTC.</p>
        pub fn event_timestamp(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_timestamp(inp);
            self
        }
        /// <p>Timestamp that defines when the event under evaluation occurred. The timestamp must be specified using ISO 8601 standard in UTC.</p>
        pub fn set_event_timestamp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_timestamp(input);
            self
        }
        /// Adds a key-value pair to `eventVariables`.
        ///
        /// To override the contents of this collection use [`set_event_variables`](Self::set_event_variables).
        ///
        /// <p>Names of the event type's variables you defined in Amazon Fraud Detector to represent data elements and
        /// their corresponding values for the event you are sending for evaluation.</p>
        /// <important>         
        /// <p>You must provide at least one eventVariable</p>        
        /// </important>
        ///
        /// <p>To ensure most accurate fraud prediction and to simplify your data preparation, Amazon Fraud Detector will replace all missing variables or values as follows:</p>
        ///
        /// <p>
        /// <b>For Amazon Fraud Detector trained models:</b>
        /// </p>
        /// <p>If a null value is provided explicitly for a variable or if a variable is missing, model will replace the null value or the missing variable (no variable name in the eventVariables map)
        /// with calculated default mean/medians for numeric variables and with special values for categorical variables.</p>
        ///
        /// <p>
        /// <b>For imported SageMaker models:</b>
        /// </p>
        /// <p>If a null value is provided explicitly for a variable, the model and rules will use “null” as the value. If a variable is not provided (no variable name in the eventVariables map), model and rules
        /// will use the default value that is provided for the variable. </p>
        pub fn event_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.event_variables(k, v);
            self
        }
        /// <p>Names of the event type's variables you defined in Amazon Fraud Detector to represent data elements and
        /// their corresponding values for the event you are sending for evaluation.</p>
        /// <important>         
        /// <p>You must provide at least one eventVariable</p>        
        /// </important>
        ///
        /// <p>To ensure most accurate fraud prediction and to simplify your data preparation, Amazon Fraud Detector will replace all missing variables or values as follows:</p>
        ///
        /// <p>
        /// <b>For Amazon Fraud Detector trained models:</b>
        /// </p>
        /// <p>If a null value is provided explicitly for a variable or if a variable is missing, model will replace the null value or the missing variable (no variable name in the eventVariables map)
        /// with calculated default mean/medians for numeric variables and with special values for categorical variables.</p>
        ///
        /// <p>
        /// <b>For imported SageMaker models:</b>
        /// </p>
        /// <p>If a null value is provided explicitly for a variable, the model and rules will use “null” as the value. If a variable is not provided (no variable name in the eventVariables map), model and rules
        /// will use the default value that is provided for the variable. </p>
        pub fn set_event_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_event_variables(input);
            self
        }
        /// Adds a key-value pair to `externalModelEndpointDataBlobs`.
        ///
        /// To override the contents of this collection use [`set_external_model_endpoint_data_blobs`](Self::set_external_model_endpoint_data_blobs).
        ///
        /// <p>The Amazon SageMaker model endpoint input data blobs.</p>
        pub fn external_model_endpoint_data_blobs(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ModelEndpointDataBlob>,
        ) -> Self {
            self.inner = self.inner.external_model_endpoint_data_blobs(k, v);
            self
        }
        /// <p>The Amazon SageMaker model endpoint input data blobs.</p>
        pub fn set_external_model_endpoint_data_blobs(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ModelEndpointDataBlob>,
            >,
        ) -> Self {
            self.inner = self.inner.set_external_model_endpoint_data_blobs(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEventTypes`.
    ///
    /// <p>Gets all event types or a specific event type if name is provided. This is a paginated API. If you
    /// provide a null <code>maxResults</code>, this action retrieves a maximum of 10 records
    /// per page. If you provide a <code>maxResults</code>, the value must be between 5 and 10.
    /// To get the next page results, provide the pagination token from the
    /// <code>GetEventTypesResponse</code> as part of your request. A null pagination token
    /// fetches the records from the beginning. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetEventTypes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_event_types_input::Builder,
    }
    impl<C, M, R> GetEventTypes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEventTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEventTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEventTypesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEventTypesInputOperationOutputAlias,
                crate::output::GetEventTypesOutput,
                crate::error::GetEventTypesError,
                crate::input::GetEventTypesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The next token for the subsequent request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The next token for the subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetExternalModels`.
    ///
    /// <p>Gets the details for one or more Amazon SageMaker models that have been imported into the
    /// service. This is a paginated API. If you provide a null <code>maxResults</code>, this
    /// actions retrieves a maximum of 10 records per page. If you provide a
    /// <code>maxResults</code>, the value must be between 5 and 10. To get the next page
    /// results, provide the pagination token from the <code>GetExternalModelsResult</code> as part
    /// of your request. A null pagination token fetches the records from the beginning. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetExternalModels<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_external_models_input::Builder,
    }
    impl<C, M, R> GetExternalModels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetExternalModels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetExternalModelsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetExternalModelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetExternalModelsInputOperationOutputAlias,
                crate::output::GetExternalModelsOutput,
                crate::error::GetExternalModelsError,
                crate::input::GetExternalModelsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon SageMaker model endpoint.</p>
        pub fn model_endpoint(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_endpoint(inp);
            self
        }
        /// <p>The Amazon SageMaker model endpoint.</p>
        pub fn set_model_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_endpoint(input);
            self
        }
        /// <p>The next page token for the request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The next page token for the request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetKMSEncryptionKey`.
    ///
    /// <p>Gets the encryption key if a KMS key has been specified to be used to encrypt content in Amazon Fraud Detector.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetKMSEncryptionKey<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_kms_encryption_key_input::Builder,
    }
    impl<C, M, R> GetKMSEncryptionKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetKMSEncryptionKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetKmsEncryptionKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetKMSEncryptionKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetKmsEncryptionKeyInputOperationOutputAlias,
                crate::output::GetKmsEncryptionKeyOutput,
                crate::error::GetKMSEncryptionKeyError,
                crate::input::GetKmsEncryptionKeyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetLabels`.
    ///
    /// <p>Gets all labels or a specific label if name is provided. This is a paginated API. If you
    /// provide a null <code>maxResults</code>, this action retrieves a maximum of 50 records
    /// per page. If you provide a <code>maxResults</code>, the value must be between 10 and 50.
    /// To get the next page results, provide the pagination token from the
    /// <code>GetGetLabelsResponse</code> as part of your request. A null pagination token
    /// fetches the records from the beginning. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetLabels<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_labels_input::Builder,
    }
    impl<C, M, R> GetLabels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLabels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLabelsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLabelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLabelsInputOperationOutputAlias,
                crate::output::GetLabelsOutput,
                crate::error::GetLabelsError,
                crate::input::GetLabelsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the label or labels to get.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the label or labels to get.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The next token for the subsequent request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The next token for the subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of objects to return for the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetModels`.
    ///
    /// <p>Gets one or more models. Gets all models for the Amazon Web Services account if no model type and no model id provided. Gets all models for the Amazon Web Services account and model type, if the model type is specified but model id is not provided. Gets a specific model if (model type, model id) tuple is specified. </p>
    /// <p>This is a paginated API. If you
    /// provide a null <code>maxResults</code>, this action retrieves a maximum of 10 records
    /// per page. If you provide a <code>maxResults</code>, the value must be between 1 and 10.
    /// To get the next page results, provide the pagination token from the
    /// response as part of your request. A null pagination token
    /// fetches the records from the beginning.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetModels<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_models_input::Builder,
    }
    impl<C, M, R> GetModels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetModels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetModelsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetModelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetModelsInputOperationOutputAlias,
                crate::output::GetModelsOutput,
                crate::error::GetModelsError,
                crate::input::GetModelsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The model ID.</p>
        pub fn model_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_id(inp);
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_id(input);
            self
        }
        /// <p>The model type.</p>
        pub fn model_type(mut self, inp: crate::model::ModelTypeEnum) -> Self {
            self.inner = self.inner.model_type(inp);
            self
        }
        /// <p>The model type.</p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_model_type(input);
            self
        }
        /// <p>The next token for the subsequent request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The next token for the subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects to return for the request. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of objects to return for the request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetModelVersion`.
    ///
    /// <p>Gets the details of the specified model version.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetModelVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_model_version_input::Builder,
    }
    impl<C, M, R> GetModelVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetModelVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetModelVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetModelVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetModelVersionInputOperationOutputAlias,
                crate::output::GetModelVersionOutput,
                crate::error::GetModelVersionError,
                crate::input::GetModelVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The model ID.</p>
        pub fn model_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_id(inp);
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_id(input);
            self
        }
        /// <p>The model type.</p>
        pub fn model_type(mut self, inp: crate::model::ModelTypeEnum) -> Self {
            self.inner = self.inner.model_type(inp);
            self
        }
        /// <p>The model type.</p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_model_type(input);
            self
        }
        /// <p>The model version number.</p>
        pub fn model_version_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_version_number(inp);
            self
        }
        /// <p>The model version number.</p>
        pub fn set_model_version_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_version_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetOutcomes`.
    ///
    /// <p>Gets one or more outcomes. This is a paginated
    /// API. If you provide a null <code>maxResults</code>, this actions retrieves a maximum of
    /// 100 records per page. If you provide a <code>maxResults</code>, the value must be
    /// between 50 and 100. To get the next page results, provide the pagination token from the
    /// <code>GetOutcomesResult</code> as part of your request. A null pagination token
    /// fetches the records from the beginning. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetOutcomes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_outcomes_input::Builder,
    }
    impl<C, M, R> GetOutcomes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetOutcomes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOutcomesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetOutcomesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetOutcomesInputOperationOutputAlias,
                crate::output::GetOutcomesOutput,
                crate::error::GetOutcomesError,
                crate::input::GetOutcomesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the outcome or outcomes to get.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the outcome or outcomes to get.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The next page token for the request. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The next page token for the request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects to return for the request. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of objects to return for the request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRules`.
    ///
    /// <p>Get all rules for a detector (paginated) if <code>ruleId</code> and <code>ruleVersion</code> are not specified. Gets all rules for the detector and the <code>ruleId</code> if present (paginated). Gets a specific rule if both the <code>ruleId</code> and the <code>ruleVersion</code> are specified.</p>
    /// <p>This is a paginated API. Providing null maxResults results in retrieving maximum of 100 records per page. If you provide maxResults the value must be between 50 and 100. To get the next page result, a provide a pagination token from GetRulesResult as part of your request. Null pagination token fetches the records from the beginning.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRules<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_rules_input::Builder,
    }
    impl<C, M, R> GetRules<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRulesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRulesInputOperationOutputAlias,
                crate::output::GetRulesOutput,
                crate::error::GetRulesError,
                crate::input::GetRulesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The rule ID.</p>
        pub fn rule_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_id(inp);
            self
        }
        /// <p>The rule ID.</p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_id(input);
            self
        }
        /// <p>The detector ID.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The detector ID.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The rule version.</p>
        pub fn rule_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_version(inp);
            self
        }
        /// <p>The rule version.</p>
        pub fn set_rule_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_version(input);
            self
        }
        /// <p>The next page token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The next page token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of rules to return for the request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of rules to return for the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetVariables`.
    ///
    /// <p>Gets all of the variables or the specific variable. This is a
    /// paginated API. Providing null <code>maxSizePerPage</code> results in retrieving maximum of
    /// 100 records per page. If you provide <code>maxSizePerPage</code> the value must be between
    /// 50 and 100. To get the next page result, a provide a pagination token from
    /// <code>GetVariablesResult</code> as part of your request. Null pagination token
    /// fetches the records from the beginning. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetVariables<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_variables_input::Builder,
    }
    impl<C, M, R> GetVariables<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetVariables`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetVariablesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetVariablesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetVariablesInputOperationOutputAlias,
                crate::output::GetVariablesOutput,
                crate::error::GetVariablesError,
                crate::input::GetVariablesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the variable. </p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the variable. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The next page token of the get variable request. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The next page token of the get variable request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The max size per page determined for the get variable request. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The max size per page determined for the get variable request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists all tags associated with the resource. This is a paginated API. To get the next page results, provide the pagination token from the
    /// response as part of your request. A null pagination token
    /// fetches the records from the beginning. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN that specifies the resource whose tags you want to list.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN that specifies the resource whose tags you want to list.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The next token from the previous results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The next token from the previous results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects to return for the request. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of objects to return for the request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutDetector`.
    ///
    /// <p>Creates or updates a detector. </p>
    #[derive(std::fmt::Debug)]
    pub struct PutDetector<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_detector_input::Builder,
    }
    impl<C, M, R> PutDetector<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutDetector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutDetectorOutput,
            aws_smithy_http::result::SdkError<crate::error::PutDetectorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutDetectorInputOperationOutputAlias,
                crate::output::PutDetectorOutput,
                crate::error::PutDetectorError,
                crate::input::PutDetectorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The detector ID. </p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The detector ID. </p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The description of the detector.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the detector.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The name of the event type.</p>
        pub fn event_type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_type_name(inp);
            self
        }
        /// <p>The name of the event type.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_type_name(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutEntityType`.
    ///
    /// <p>Creates or updates an entity type. An entity represents who is performing the event. As part of a fraud prediction, you pass the entity ID to indicate the specific entity who performed the event. An entity type classifies the entity. Example classifications include customer, merchant, or account.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutEntityType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_entity_type_input::Builder,
    }
    impl<C, M, R> PutEntityType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutEntityType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutEntityTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::PutEntityTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutEntityTypeInputOperationOutputAlias,
                crate::output::PutEntityTypeOutput,
                crate::error::PutEntityTypeError,
                crate::input::PutEntityTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the entity type.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the entity type.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutEventType`.
    ///
    /// <p>Creates or updates an event type. An event is a business activity that is evaluated for fraud risk. With Amazon Fraud Detector, you generate fraud predictions for events. An event type defines the structure for an event sent to Amazon Fraud Detector. This includes the variables sent as part of the event, the entity performing the event (such as a customer), and the labels that classify the event. Example event types include online payment transactions, account registrations, and authentications.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutEventType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_event_type_input::Builder,
    }
    impl<C, M, R> PutEventType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutEventType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutEventTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::PutEventTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutEventTypeInputOperationOutputAlias,
                crate::output::PutEventTypeOutput,
                crate::error::PutEventTypeError,
                crate::input::PutEventTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the event type.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the event type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `eventVariables`.
        ///
        /// To override the contents of this collection use [`set_event_variables`](Self::set_event_variables).
        ///
        /// <p>The event type variables.</p>
        pub fn event_variables(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_variables(inp);
            self
        }
        /// <p>The event type variables.</p>
        pub fn set_event_variables(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_event_variables(input);
            self
        }
        /// Appends an item to `labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// <p>The event type labels.</p>
        pub fn labels(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.labels(inp);
            self
        }
        /// <p>The event type labels.</p>
        pub fn set_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_labels(input);
            self
        }
        /// Appends an item to `entityTypes`.
        ///
        /// To override the contents of this collection use [`set_entity_types`](Self::set_entity_types).
        ///
        /// <p>The entity type for the event type. Example entity types: customer, merchant, account.</p>
        pub fn entity_types(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_types(inp);
            self
        }
        /// <p>The entity type for the event type. Example entity types: customer, merchant, account.</p>
        pub fn set_entity_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_entity_types(input);
            self
        }
        /// <p>Specifies if ingenstion is enabled or disabled.</p>
        pub fn event_ingestion(mut self, inp: crate::model::EventIngestion) -> Self {
            self.inner = self.inner.event_ingestion(inp);
            self
        }
        /// <p>Specifies if ingenstion is enabled or disabled.</p>
        pub fn set_event_ingestion(
            mut self,
            input: std::option::Option<crate::model::EventIngestion>,
        ) -> Self {
            self.inner = self.inner.set_event_ingestion(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutExternalModel`.
    ///
    /// <p>Creates or updates an Amazon SageMaker model endpoint. You can also use this action to update the configuration of the model endpoint, including the IAM role and/or the mapped variables.  </p>
    #[derive(std::fmt::Debug)]
    pub struct PutExternalModel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_external_model_input::Builder,
    }
    impl<C, M, R> PutExternalModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutExternalModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutExternalModelOutput,
            aws_smithy_http::result::SdkError<crate::error::PutExternalModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutExternalModelInputOperationOutputAlias,
                crate::output::PutExternalModelOutput,
                crate::error::PutExternalModelError,
                crate::input::PutExternalModelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The model endpoints name.</p>
        pub fn model_endpoint(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_endpoint(inp);
            self
        }
        /// <p>The model endpoints name.</p>
        pub fn set_model_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_endpoint(input);
            self
        }
        /// <p>The source of the model.</p>
        pub fn model_source(mut self, inp: crate::model::ModelSource) -> Self {
            self.inner = self.inner.model_source(inp);
            self
        }
        /// <p>The source of the model.</p>
        pub fn set_model_source(
            mut self,
            input: std::option::Option<crate::model::ModelSource>,
        ) -> Self {
            self.inner = self.inner.set_model_source(input);
            self
        }
        /// <p>The IAM role used to invoke the model endpoint.</p>
        pub fn invoke_model_endpoint_role_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.invoke_model_endpoint_role_arn(inp);
            self
        }
        /// <p>The IAM role used to invoke the model endpoint.</p>
        pub fn set_invoke_model_endpoint_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_invoke_model_endpoint_role_arn(input);
            self
        }
        /// <p>The model endpoint input configuration.</p>
        pub fn input_configuration(mut self, inp: crate::model::ModelInputConfiguration) -> Self {
            self.inner = self.inner.input_configuration(inp);
            self
        }
        /// <p>The model endpoint input configuration.</p>
        pub fn set_input_configuration(
            mut self,
            input: std::option::Option<crate::model::ModelInputConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_input_configuration(input);
            self
        }
        /// <p>The model endpoint output configuration.</p>
        pub fn output_configuration(mut self, inp: crate::model::ModelOutputConfiguration) -> Self {
            self.inner = self.inner.output_configuration(inp);
            self
        }
        /// <p>The model endpoint output configuration.</p>
        pub fn set_output_configuration(
            mut self,
            input: std::option::Option<crate::model::ModelOutputConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_output_configuration(input);
            self
        }
        /// <p>The model endpoint’s status in Amazon Fraud Detector.</p>
        pub fn model_endpoint_status(mut self, inp: crate::model::ModelEndpointStatus) -> Self {
            self.inner = self.inner.model_endpoint_status(inp);
            self
        }
        /// <p>The model endpoint’s status in Amazon Fraud Detector.</p>
        pub fn set_model_endpoint_status(
            mut self,
            input: std::option::Option<crate::model::ModelEndpointStatus>,
        ) -> Self {
            self.inner = self.inner.set_model_endpoint_status(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutKMSEncryptionKey`.
    ///
    /// <p>Specifies the KMS key to be used to encrypt content in Amazon Fraud Detector.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutKMSEncryptionKey<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_kms_encryption_key_input::Builder,
    }
    impl<C, M, R> PutKMSEncryptionKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutKMSEncryptionKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutKmsEncryptionKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutKMSEncryptionKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutKmsEncryptionKeyInputOperationOutputAlias,
                crate::output::PutKmsEncryptionKeyOutput,
                crate::error::PutKMSEncryptionKeyError,
                crate::input::PutKmsEncryptionKeyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The KMS encryption key ARN.</p>
        pub fn kms_encryption_key_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_encryption_key_arn(inp);
            self
        }
        /// <p>The KMS encryption key ARN.</p>
        pub fn set_kms_encryption_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_kms_encryption_key_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutLabel`.
    ///
    /// <p>Creates or updates label. A label classifies an event as fraudulent or legitimate. Labels are associated with event types and used to train supervised machine learning models in Amazon Fraud Detector. </p>
    #[derive(std::fmt::Debug)]
    pub struct PutLabel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_label_input::Builder,
    }
    impl<C, M, R> PutLabel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutLabel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutLabelOutput,
            aws_smithy_http::result::SdkError<crate::error::PutLabelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutLabelInputOperationOutputAlias,
                crate::output::PutLabelOutput,
                crate::error::PutLabelError,
                crate::input::PutLabelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The label name.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The label name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The label description.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The label description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p></p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p></p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutOutcome`.
    ///
    /// <p>Creates or updates an outcome. </p>
    #[derive(std::fmt::Debug)]
    pub struct PutOutcome<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_outcome_input::Builder,
    }
    impl<C, M, R> PutOutcome<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutOutcome`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutOutcomeOutput,
            aws_smithy_http::result::SdkError<crate::error::PutOutcomeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutOutcomeInputOperationOutputAlias,
                crate::output::PutOutcomeOutput,
                crate::error::PutOutcomeError,
                crate::input::PutOutcomeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the outcome.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the outcome.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The outcome description.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The outcome description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendEvent`.
    ///
    /// <p>Stores events in Amazon Fraud Detector without generating fraud predictions for those events. For example, you can use <code>SendEvent</code> to upload a historical dataset, which you can then later use to train a model.</p>
    #[derive(std::fmt::Debug)]
    pub struct SendEvent<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_event_input::Builder,
    }
    impl<C, M, R> SendEvent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendEvent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendEventOutput,
            aws_smithy_http::result::SdkError<crate::error::SendEventError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendEventInputOperationOutputAlias,
                crate::output::SendEventOutput,
                crate::error::SendEventError,
                crate::input::SendEventInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The event ID to upload.</p>
        pub fn event_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_id(inp);
            self
        }
        /// <p>The event ID to upload.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_event_id(input);
            self
        }
        /// <p>The event type name of the event.</p>
        pub fn event_type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_type_name(inp);
            self
        }
        /// <p>The event type name of the event.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_type_name(input);
            self
        }
        /// <p>The timestamp that defines when the event under evaluation occurred. The timestamp must be specified using ISO 8601 standard in UTC.</p>
        pub fn event_timestamp(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_timestamp(inp);
            self
        }
        /// <p>The timestamp that defines when the event under evaluation occurred. The timestamp must be specified using ISO 8601 standard in UTC.</p>
        pub fn set_event_timestamp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_timestamp(input);
            self
        }
        /// Adds a key-value pair to `eventVariables`.
        ///
        /// To override the contents of this collection use [`set_event_variables`](Self::set_event_variables).
        ///
        /// <p>Names of the event type's variables you defined in Amazon Fraud Detector to represent data elements and their corresponding values for the event you are sending for evaluation.</p>
        pub fn event_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.event_variables(k, v);
            self
        }
        /// <p>Names of the event type's variables you defined in Amazon Fraud Detector to represent data elements and their corresponding values for the event you are sending for evaluation.</p>
        pub fn set_event_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_event_variables(input);
            self
        }
        /// <p>The label to associate with the event. Required if specifying <code>labelTimestamp</code>.</p>
        pub fn assigned_label(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assigned_label(inp);
            self
        }
        /// <p>The label to associate with the event. Required if specifying <code>labelTimestamp</code>.</p>
        pub fn set_assigned_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assigned_label(input);
            self
        }
        /// <p>The timestamp associated with the label. Required if specifying <code>assignedLabel</code>.</p>
        pub fn label_timestamp(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.label_timestamp(inp);
            self
        }
        /// <p>The timestamp associated with the label. Required if specifying <code>assignedLabel</code>.</p>
        pub fn set_label_timestamp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_label_timestamp(input);
            self
        }
        /// Appends an item to `entities`.
        ///
        /// To override the contents of this collection use [`set_entities`](Self::set_entities).
        ///
        /// <p>An array of entities.</p>
        pub fn entities(mut self, inp: impl Into<crate::model::Entity>) -> Self {
            self.inner = self.inner.entities(inp);
            self
        }
        /// <p>An array of entities.</p>
        pub fn set_entities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Entity>>,
        ) -> Self {
            self.inner = self.inner.set_entities(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Assigns tags to a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to assign to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource from which to remove the tag.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the resource from which to remove the tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The resource ARN.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDetectorVersion`.
    ///
    /// <p> Updates a detector version. The detector version attributes that you can update include models, external model endpoints, rules, rule execution mode, and description. You can only update a <code>DRAFT</code> detector version.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDetectorVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_detector_version_input::Builder,
    }
    impl<C, M, R> UpdateDetectorVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDetectorVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDetectorVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDetectorVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDetectorVersionInputOperationOutputAlias,
                crate::output::UpdateDetectorVersionOutput,
                crate::error::UpdateDetectorVersionError,
                crate::input::UpdateDetectorVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The parent detector ID for the detector version you want to update.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The parent detector ID for the detector version you want to update.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The detector version ID. </p>
        pub fn detector_version_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_version_id(inp);
            self
        }
        /// <p>The detector version ID. </p>
        pub fn set_detector_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_detector_version_id(input);
            self
        }
        /// Appends an item to `externalModelEndpoints`.
        ///
        /// To override the contents of this collection use [`set_external_model_endpoints`](Self::set_external_model_endpoints).
        ///
        /// <p>The Amazon SageMaker model endpoints to include in the detector version.</p>
        pub fn external_model_endpoints(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_model_endpoints(inp);
            self
        }
        /// <p>The Amazon SageMaker model endpoints to include in the detector version.</p>
        pub fn set_external_model_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_external_model_endpoints(input);
            self
        }
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>The rules to include in the detector version.</p>
        pub fn rules(mut self, inp: impl Into<crate::model::Rule>) -> Self {
            self.inner = self.inner.rules(inp);
            self
        }
        /// <p>The rules to include in the detector version.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.inner = self.inner.set_rules(input);
            self
        }
        /// <p>The detector version description. </p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The detector version description. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `modelVersions`.
        ///
        /// To override the contents of this collection use [`set_model_versions`](Self::set_model_versions).
        ///
        /// <p>The model versions to include in the detector version.</p>
        pub fn model_versions(mut self, inp: impl Into<crate::model::ModelVersion>) -> Self {
            self.inner = self.inner.model_versions(inp);
            self
        }
        /// <p>The model versions to include in the detector version.</p>
        pub fn set_model_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ModelVersion>>,
        ) -> Self {
            self.inner = self.inner.set_model_versions(input);
            self
        }
        /// <p>The rule execution mode to add to the detector.</p>
        /// <p>If you specify <code>FIRST_MATCHED</code>, Amazon Fraud Detector evaluates rules sequentially, first to last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule.</p>
        /// <p>If you specifiy <code>ALL_MATCHED</code>, Amazon Fraud Detector evaluates all rules and returns the outcomes for all matched rules. You can define and edit the rule mode at the detector version level, when it is in draft status.</p>
        /// <p>The default behavior is <code>FIRST_MATCHED</code>.</p>
        pub fn rule_execution_mode(mut self, inp: crate::model::RuleExecutionMode) -> Self {
            self.inner = self.inner.rule_execution_mode(inp);
            self
        }
        /// <p>The rule execution mode to add to the detector.</p>
        /// <p>If you specify <code>FIRST_MATCHED</code>, Amazon Fraud Detector evaluates rules sequentially, first to last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule.</p>
        /// <p>If you specifiy <code>ALL_MATCHED</code>, Amazon Fraud Detector evaluates all rules and returns the outcomes for all matched rules. You can define and edit the rule mode at the detector version level, when it is in draft status.</p>
        /// <p>The default behavior is <code>FIRST_MATCHED</code>.</p>
        pub fn set_rule_execution_mode(
            mut self,
            input: std::option::Option<crate::model::RuleExecutionMode>,
        ) -> Self {
            self.inner = self.inner.set_rule_execution_mode(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDetectorVersionMetadata`.
    ///
    /// <p>Updates the detector version's description. You can update the metadata for any detector version (<code>DRAFT, ACTIVE,</code> or
    /// <code>INACTIVE</code>). </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDetectorVersionMetadata<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_detector_version_metadata_input::Builder,
    }
    impl<C, M, R> UpdateDetectorVersionMetadata<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDetectorVersionMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDetectorVersionMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDetectorVersionMetadataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDetectorVersionMetadataInputOperationOutputAlias,
                crate::output::UpdateDetectorVersionMetadataOutput,
                crate::error::UpdateDetectorVersionMetadataError,
                crate::input::UpdateDetectorVersionMetadataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The detector ID.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The detector ID.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The detector version ID. </p>
        pub fn detector_version_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_version_id(inp);
            self
        }
        /// <p>The detector version ID. </p>
        pub fn set_detector_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_detector_version_id(input);
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDetectorVersionStatus`.
    ///
    /// <p>Updates the detector version’s status. You can perform the following promotions or
    /// demotions using <code>UpdateDetectorVersionStatus</code>: <code>DRAFT</code> to <code>ACTIVE</code>, <code>ACTIVE</code> to <code>INACTIVE</code>, and <code>INACTIVE</code> to <code>ACTIVE</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDetectorVersionStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_detector_version_status_input::Builder,
    }
    impl<C, M, R> UpdateDetectorVersionStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDetectorVersionStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDetectorVersionStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDetectorVersionStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDetectorVersionStatusInputOperationOutputAlias,
                crate::output::UpdateDetectorVersionStatusOutput,
                crate::error::UpdateDetectorVersionStatusError,
                crate::input::UpdateDetectorVersionStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The detector ID. </p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The detector ID. </p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The detector version ID. </p>
        pub fn detector_version_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_version_id(inp);
            self
        }
        /// <p>The detector version ID. </p>
        pub fn set_detector_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_detector_version_id(input);
            self
        }
        /// <p>The new status.</p>
        pub fn status(mut self, inp: crate::model::DetectorVersionStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>The new status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DetectorVersionStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEventLabel`.
    ///
    /// <p>Updates the specified event with a new label.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateEventLabel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_event_label_input::Builder,
    }
    impl<C, M, R> UpdateEventLabel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateEventLabel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEventLabelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEventLabelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateEventLabelInputOperationOutputAlias,
                crate::output::UpdateEventLabelOutput,
                crate::error::UpdateEventLabelError,
                crate::input::UpdateEventLabelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the event associated with the label to update.</p>
        pub fn event_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_id(inp);
            self
        }
        /// <p>The ID of the event associated with the label to update.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_event_id(input);
            self
        }
        /// <p>The event type of the event associated with the label to update.</p>
        pub fn event_type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_type_name(inp);
            self
        }
        /// <p>The event type of the event associated with the label to update.</p>
        pub fn set_event_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_type_name(input);
            self
        }
        /// <p>The new label to assign to the event.</p>
        pub fn assigned_label(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assigned_label(inp);
            self
        }
        /// <p>The new label to assign to the event.</p>
        pub fn set_assigned_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assigned_label(input);
            self
        }
        /// <p>The timestamp associated with the label. The timestamp must be specified using ISO 8601 standard in UTC. </p>
        pub fn label_timestamp(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.label_timestamp(inp);
            self
        }
        /// <p>The timestamp associated with the label. The timestamp must be specified using ISO 8601 standard in UTC. </p>
        pub fn set_label_timestamp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_label_timestamp(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateModel`.
    ///
    /// <p>Updates model description.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateModel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_model_input::Builder,
    }
    impl<C, M, R> UpdateModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateModelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateModelInputOperationOutputAlias,
                crate::output::UpdateModelOutput,
                crate::error::UpdateModelError,
                crate::input::UpdateModelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The model ID.</p>
        pub fn model_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_id(inp);
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_id(input);
            self
        }
        /// <p>The model type.</p>
        pub fn model_type(mut self, inp: crate::model::ModelTypeEnum) -> Self {
            self.inner = self.inner.model_type(inp);
            self
        }
        /// <p>The model type.</p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_model_type(input);
            self
        }
        /// <p>The new model description.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The new model description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateModelVersion`.
    ///
    /// <p>Updates a model version. Updating a model version retrains an existing model version using updated training data and produces a new minor version of the model. You can update the training data set location and data access role attributes using this action. This action creates and trains a new minor version of the model, for example version 1.01, 1.02, 1.03.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateModelVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_model_version_input::Builder,
    }
    impl<C, M, R> UpdateModelVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateModelVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateModelVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateModelVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateModelVersionInputOperationOutputAlias,
                crate::output::UpdateModelVersionOutput,
                crate::error::UpdateModelVersionError,
                crate::input::UpdateModelVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The model ID.</p>
        pub fn model_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_id(inp);
            self
        }
        /// <p>The model ID.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_id(input);
            self
        }
        /// <p>The model type.</p>
        pub fn model_type(mut self, inp: crate::model::ModelTypeEnum) -> Self {
            self.inner = self.inner.model_type(inp);
            self
        }
        /// <p>The model type.</p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_model_type(input);
            self
        }
        /// <p>The major version number.</p>
        pub fn major_version_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.major_version_number(inp);
            self
        }
        /// <p>The major version number.</p>
        pub fn set_major_version_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_major_version_number(input);
            self
        }
        /// <p>The details of the external events data used for training the model version. Required if <code>trainingDataSource</code> is <code>EXTERNAL_EVENTS</code>.</p>
        pub fn external_events_detail(mut self, inp: crate::model::ExternalEventsDetail) -> Self {
            self.inner = self.inner.external_events_detail(inp);
            self
        }
        /// <p>The details of the external events data used for training the model version. Required if <code>trainingDataSource</code> is <code>EXTERNAL_EVENTS</code>.</p>
        pub fn set_external_events_detail(
            mut self,
            input: std::option::Option<crate::model::ExternalEventsDetail>,
        ) -> Self {
            self.inner = self.inner.set_external_events_detail(input);
            self
        }
        /// <p>The details of the ingested event used for training the model version. Required if your <code>trainingDataSource</code> is <code>INGESTED_EVENTS</code>.</p>
        pub fn ingested_events_detail(mut self, inp: crate::model::IngestedEventsDetail) -> Self {
            self.inner = self.inner.ingested_events_detail(inp);
            self
        }
        /// <p>The details of the ingested event used for training the model version. Required if your <code>trainingDataSource</code> is <code>INGESTED_EVENTS</code>.</p>
        pub fn set_ingested_events_detail(
            mut self,
            input: std::option::Option<crate::model::IngestedEventsDetail>,
        ) -> Self {
            self.inner = self.inner.set_ingested_events_detail(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A collection of key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateModelVersionStatus`.
    ///
    /// <p>Updates the status of a model version.</p>
    /// <p>You can perform the following status updates:</p>
    /// <ol>
    /// <li>
    /// <p>Change the <code>TRAINING_COMPLETE</code> status to <code>ACTIVE</code>.</p>
    /// </li>
    /// <li>
    /// <p>Change <code>ACTIVE</code> to <code>INACTIVE</code>.</p>
    /// </li>
    /// </ol>
    #[derive(std::fmt::Debug)]
    pub struct UpdateModelVersionStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_model_version_status_input::Builder,
    }
    impl<C, M, R> UpdateModelVersionStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateModelVersionStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateModelVersionStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateModelVersionStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateModelVersionStatusInputOperationOutputAlias,
                crate::output::UpdateModelVersionStatusOutput,
                crate::error::UpdateModelVersionStatusError,
                crate::input::UpdateModelVersionStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The model ID of the model version to update.</p>
        pub fn model_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_id(inp);
            self
        }
        /// <p>The model ID of the model version to update.</p>
        pub fn set_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_id(input);
            self
        }
        /// <p>The model type.</p>
        pub fn model_type(mut self, inp: crate::model::ModelTypeEnum) -> Self {
            self.inner = self.inner.model_type(inp);
            self
        }
        /// <p>The model type.</p>
        pub fn set_model_type(
            mut self,
            input: std::option::Option<crate::model::ModelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_model_type(input);
            self
        }
        /// <p>The model version number.</p>
        pub fn model_version_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_version_number(inp);
            self
        }
        /// <p>The model version number.</p>
        pub fn set_model_version_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_version_number(input);
            self
        }
        /// <p>The model version status.</p>
        pub fn status(mut self, inp: crate::model::ModelVersionStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>The model version status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ModelVersionStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRuleMetadata`.
    ///
    /// <p>Updates a rule's metadata. The description attribute can be updated.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRuleMetadata<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_rule_metadata_input::Builder,
    }
    impl<C, M, R> UpdateRuleMetadata<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRuleMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRuleMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRuleMetadataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRuleMetadataInputOperationOutputAlias,
                crate::output::UpdateRuleMetadataOutput,
                crate::error::UpdateRuleMetadataError,
                crate::input::UpdateRuleMetadataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The rule to update.</p>
        pub fn rule(mut self, inp: crate::model::Rule) -> Self {
            self.inner = self.inner.rule(inp);
            self
        }
        /// <p>The rule to update.</p>
        pub fn set_rule(mut self, input: std::option::Option<crate::model::Rule>) -> Self {
            self.inner = self.inner.set_rule(input);
            self
        }
        /// <p>The rule description.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The rule description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRuleVersion`.
    ///
    /// <p>Updates a rule version resulting in a new rule version. Updates a rule version resulting in a new rule version (version 1, 2, 3 ...). </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRuleVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_rule_version_input::Builder,
    }
    impl<C, M, R> UpdateRuleVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRuleVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRuleVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRuleVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRuleVersionInputOperationOutputAlias,
                crate::output::UpdateRuleVersionOutput,
                crate::error::UpdateRuleVersionError,
                crate::input::UpdateRuleVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The rule to update.</p>
        pub fn rule(mut self, inp: crate::model::Rule) -> Self {
            self.inner = self.inner.rule(inp);
            self
        }
        /// <p>The rule to update.</p>
        pub fn set_rule(mut self, input: std::option::Option<crate::model::Rule>) -> Self {
            self.inner = self.inner.set_rule(input);
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The rule expression.</p>
        pub fn expression(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expression(inp);
            self
        }
        /// <p>The rule expression.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_expression(input);
            self
        }
        /// <p>The language.</p>
        pub fn language(mut self, inp: crate::model::Language) -> Self {
            self.inner = self.inner.language(inp);
            self
        }
        /// <p>The language.</p>
        pub fn set_language(mut self, input: std::option::Option<crate::model::Language>) -> Self {
            self.inner = self.inner.set_language(input);
            self
        }
        /// Appends an item to `outcomes`.
        ///
        /// To override the contents of this collection use [`set_outcomes`](Self::set_outcomes).
        ///
        /// <p>The outcomes.</p>
        pub fn outcomes(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.outcomes(inp);
            self
        }
        /// <p>The outcomes.</p>
        pub fn set_outcomes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_outcomes(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the rule version.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to assign to the rule version.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateVariable`.
    ///
    /// <p>Updates a variable.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateVariable<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_variable_input::Builder,
    }
    impl<C, M, R> UpdateVariable<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateVariable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateVariableOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateVariableError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateVariableInputOperationOutputAlias,
                crate::output::UpdateVariableOutput,
                crate::error::UpdateVariableError,
                crate::input::UpdateVariableInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the variable.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the variable.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The new default value of the variable.</p>
        pub fn default_value(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_value(inp);
            self
        }
        /// <p>The new default value of the variable.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_value(input);
            self
        }
        /// <p>The new description.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The new description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The variable type. For more information see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable types</a>.</p>
        pub fn variable_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.variable_type(inp);
            self
        }
        /// <p>The variable type. For more information see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable types</a>.</p>
        pub fn set_variable_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_variable_type(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
