// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateAutoPredictor`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_auto_predictor`](crate::client::Client::create_auto_predictor).
///
/// See [`crate::client::fluent_builders::CreateAutoPredictor`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAutoPredictor {
    _private: (),
}
impl CreateAutoPredictor {
    /// Creates a new builder-style object to manufacture [`CreateAutoPredictorInput`](crate::input::CreateAutoPredictorInput)
    pub fn builder() -> crate::input::create_auto_predictor_input::Builder {
        crate::input::create_auto_predictor_input::Builder::default()
    }
    /// Creates a new `CreateAutoPredictor` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAutoPredictor {
    type Output = std::result::Result<
        crate::output::CreateAutoPredictorOutput,
        crate::error::CreateAutoPredictorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_auto_predictor_error(response)
        } else {
            crate::operation_deser::parse_create_auto_predictor_response(response)
        }
    }
}

/// Operation shape for `CreateDataset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_dataset`](crate::client::Client::create_dataset).
///
/// See [`crate::client::fluent_builders::CreateDataset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDataset {
    _private: (),
}
impl CreateDataset {
    /// Creates a new builder-style object to manufacture [`CreateDatasetInput`](crate::input::CreateDatasetInput)
    pub fn builder() -> crate::input::create_dataset_input::Builder {
        crate::input::create_dataset_input::Builder::default()
    }
    /// Creates a new `CreateDataset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDataset {
    type Output =
        std::result::Result<crate::output::CreateDatasetOutput, crate::error::CreateDatasetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_dataset_error(response)
        } else {
            crate::operation_deser::parse_create_dataset_response(response)
        }
    }
}

/// Operation shape for `CreateDatasetGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_dataset_group`](crate::client::Client::create_dataset_group).
///
/// See [`crate::client::fluent_builders::CreateDatasetGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDatasetGroup {
    _private: (),
}
impl CreateDatasetGroup {
    /// Creates a new builder-style object to manufacture [`CreateDatasetGroupInput`](crate::input::CreateDatasetGroupInput)
    pub fn builder() -> crate::input::create_dataset_group_input::Builder {
        crate::input::create_dataset_group_input::Builder::default()
    }
    /// Creates a new `CreateDatasetGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDatasetGroup {
    type Output = std::result::Result<
        crate::output::CreateDatasetGroupOutput,
        crate::error::CreateDatasetGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_dataset_group_error(response)
        } else {
            crate::operation_deser::parse_create_dataset_group_response(response)
        }
    }
}

/// Operation shape for `CreateDatasetImportJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_dataset_import_job`](crate::client::Client::create_dataset_import_job).
///
/// See [`crate::client::fluent_builders::CreateDatasetImportJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDatasetImportJob {
    _private: (),
}
impl CreateDatasetImportJob {
    /// Creates a new builder-style object to manufacture [`CreateDatasetImportJobInput`](crate::input::CreateDatasetImportJobInput)
    pub fn builder() -> crate::input::create_dataset_import_job_input::Builder {
        crate::input::create_dataset_import_job_input::Builder::default()
    }
    /// Creates a new `CreateDatasetImportJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDatasetImportJob {
    type Output = std::result::Result<
        crate::output::CreateDatasetImportJobOutput,
        crate::error::CreateDatasetImportJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_dataset_import_job_error(response)
        } else {
            crate::operation_deser::parse_create_dataset_import_job_response(response)
        }
    }
}

/// Operation shape for `CreateExplainability`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_explainability`](crate::client::Client::create_explainability).
///
/// See [`crate::client::fluent_builders::CreateExplainability`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateExplainability {
    _private: (),
}
impl CreateExplainability {
    /// Creates a new builder-style object to manufacture [`CreateExplainabilityInput`](crate::input::CreateExplainabilityInput)
    pub fn builder() -> crate::input::create_explainability_input::Builder {
        crate::input::create_explainability_input::Builder::default()
    }
    /// Creates a new `CreateExplainability` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateExplainability {
    type Output = std::result::Result<
        crate::output::CreateExplainabilityOutput,
        crate::error::CreateExplainabilityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_explainability_error(response)
        } else {
            crate::operation_deser::parse_create_explainability_response(response)
        }
    }
}

/// Operation shape for `CreateExplainabilityExport`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_explainability_export`](crate::client::Client::create_explainability_export).
///
/// See [`crate::client::fluent_builders::CreateExplainabilityExport`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateExplainabilityExport {
    _private: (),
}
impl CreateExplainabilityExport {
    /// Creates a new builder-style object to manufacture [`CreateExplainabilityExportInput`](crate::input::CreateExplainabilityExportInput)
    pub fn builder() -> crate::input::create_explainability_export_input::Builder {
        crate::input::create_explainability_export_input::Builder::default()
    }
    /// Creates a new `CreateExplainabilityExport` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateExplainabilityExport {
    type Output = std::result::Result<
        crate::output::CreateExplainabilityExportOutput,
        crate::error::CreateExplainabilityExportError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_explainability_export_error(response)
        } else {
            crate::operation_deser::parse_create_explainability_export_response(response)
        }
    }
}

/// Operation shape for `CreateForecast`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_forecast`](crate::client::Client::create_forecast).
///
/// See [`crate::client::fluent_builders::CreateForecast`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateForecast {
    _private: (),
}
impl CreateForecast {
    /// Creates a new builder-style object to manufacture [`CreateForecastInput`](crate::input::CreateForecastInput)
    pub fn builder() -> crate::input::create_forecast_input::Builder {
        crate::input::create_forecast_input::Builder::default()
    }
    /// Creates a new `CreateForecast` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateForecast {
    type Output =
        std::result::Result<crate::output::CreateForecastOutput, crate::error::CreateForecastError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_forecast_error(response)
        } else {
            crate::operation_deser::parse_create_forecast_response(response)
        }
    }
}

/// Operation shape for `CreateForecastExportJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_forecast_export_job`](crate::client::Client::create_forecast_export_job).
///
/// See [`crate::client::fluent_builders::CreateForecastExportJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateForecastExportJob {
    _private: (),
}
impl CreateForecastExportJob {
    /// Creates a new builder-style object to manufacture [`CreateForecastExportJobInput`](crate::input::CreateForecastExportJobInput)
    pub fn builder() -> crate::input::create_forecast_export_job_input::Builder {
        crate::input::create_forecast_export_job_input::Builder::default()
    }
    /// Creates a new `CreateForecastExportJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateForecastExportJob {
    type Output = std::result::Result<
        crate::output::CreateForecastExportJobOutput,
        crate::error::CreateForecastExportJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_forecast_export_job_error(response)
        } else {
            crate::operation_deser::parse_create_forecast_export_job_response(response)
        }
    }
}

/// Operation shape for `CreatePredictor`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_predictor`](crate::client::Client::create_predictor).
///
/// See [`crate::client::fluent_builders::CreatePredictor`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePredictor {
    _private: (),
}
impl CreatePredictor {
    /// Creates a new builder-style object to manufacture [`CreatePredictorInput`](crate::input::CreatePredictorInput)
    pub fn builder() -> crate::input::create_predictor_input::Builder {
        crate::input::create_predictor_input::Builder::default()
    }
    /// Creates a new `CreatePredictor` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePredictor {
    type Output = std::result::Result<
        crate::output::CreatePredictorOutput,
        crate::error::CreatePredictorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_predictor_error(response)
        } else {
            crate::operation_deser::parse_create_predictor_response(response)
        }
    }
}

/// Operation shape for `CreatePredictorBacktestExportJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_predictor_backtest_export_job`](crate::client::Client::create_predictor_backtest_export_job).
///
/// See [`crate::client::fluent_builders::CreatePredictorBacktestExportJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePredictorBacktestExportJob {
    _private: (),
}
impl CreatePredictorBacktestExportJob {
    /// Creates a new builder-style object to manufacture [`CreatePredictorBacktestExportJobInput`](crate::input::CreatePredictorBacktestExportJobInput)
    pub fn builder() -> crate::input::create_predictor_backtest_export_job_input::Builder {
        crate::input::create_predictor_backtest_export_job_input::Builder::default()
    }
    /// Creates a new `CreatePredictorBacktestExportJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePredictorBacktestExportJob {
    type Output = std::result::Result<
        crate::output::CreatePredictorBacktestExportJobOutput,
        crate::error::CreatePredictorBacktestExportJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_predictor_backtest_export_job_error(response)
        } else {
            crate::operation_deser::parse_create_predictor_backtest_export_job_response(response)
        }
    }
}

/// Operation shape for `DeleteDataset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_dataset`](crate::client::Client::delete_dataset).
///
/// See [`crate::client::fluent_builders::DeleteDataset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDataset {
    _private: (),
}
impl DeleteDataset {
    /// Creates a new builder-style object to manufacture [`DeleteDatasetInput`](crate::input::DeleteDatasetInput)
    pub fn builder() -> crate::input::delete_dataset_input::Builder {
        crate::input::delete_dataset_input::Builder::default()
    }
    /// Creates a new `DeleteDataset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDataset {
    type Output =
        std::result::Result<crate::output::DeleteDatasetOutput, crate::error::DeleteDatasetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_dataset_error(response)
        } else {
            crate::operation_deser::parse_delete_dataset_response(response)
        }
    }
}

/// Operation shape for `DeleteDatasetGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_dataset_group`](crate::client::Client::delete_dataset_group).
///
/// See [`crate::client::fluent_builders::DeleteDatasetGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDatasetGroup {
    _private: (),
}
impl DeleteDatasetGroup {
    /// Creates a new builder-style object to manufacture [`DeleteDatasetGroupInput`](crate::input::DeleteDatasetGroupInput)
    pub fn builder() -> crate::input::delete_dataset_group_input::Builder {
        crate::input::delete_dataset_group_input::Builder::default()
    }
    /// Creates a new `DeleteDatasetGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDatasetGroup {
    type Output = std::result::Result<
        crate::output::DeleteDatasetGroupOutput,
        crate::error::DeleteDatasetGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_dataset_group_error(response)
        } else {
            crate::operation_deser::parse_delete_dataset_group_response(response)
        }
    }
}

/// Operation shape for `DeleteDatasetImportJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_dataset_import_job`](crate::client::Client::delete_dataset_import_job).
///
/// See [`crate::client::fluent_builders::DeleteDatasetImportJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDatasetImportJob {
    _private: (),
}
impl DeleteDatasetImportJob {
    /// Creates a new builder-style object to manufacture [`DeleteDatasetImportJobInput`](crate::input::DeleteDatasetImportJobInput)
    pub fn builder() -> crate::input::delete_dataset_import_job_input::Builder {
        crate::input::delete_dataset_import_job_input::Builder::default()
    }
    /// Creates a new `DeleteDatasetImportJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDatasetImportJob {
    type Output = std::result::Result<
        crate::output::DeleteDatasetImportJobOutput,
        crate::error::DeleteDatasetImportJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_dataset_import_job_error(response)
        } else {
            crate::operation_deser::parse_delete_dataset_import_job_response(response)
        }
    }
}

/// Operation shape for `DeleteExplainability`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_explainability`](crate::client::Client::delete_explainability).
///
/// See [`crate::client::fluent_builders::DeleteExplainability`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteExplainability {
    _private: (),
}
impl DeleteExplainability {
    /// Creates a new builder-style object to manufacture [`DeleteExplainabilityInput`](crate::input::DeleteExplainabilityInput)
    pub fn builder() -> crate::input::delete_explainability_input::Builder {
        crate::input::delete_explainability_input::Builder::default()
    }
    /// Creates a new `DeleteExplainability` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteExplainability {
    type Output = std::result::Result<
        crate::output::DeleteExplainabilityOutput,
        crate::error::DeleteExplainabilityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_explainability_error(response)
        } else {
            crate::operation_deser::parse_delete_explainability_response(response)
        }
    }
}

/// Operation shape for `DeleteExplainabilityExport`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_explainability_export`](crate::client::Client::delete_explainability_export).
///
/// See [`crate::client::fluent_builders::DeleteExplainabilityExport`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteExplainabilityExport {
    _private: (),
}
impl DeleteExplainabilityExport {
    /// Creates a new builder-style object to manufacture [`DeleteExplainabilityExportInput`](crate::input::DeleteExplainabilityExportInput)
    pub fn builder() -> crate::input::delete_explainability_export_input::Builder {
        crate::input::delete_explainability_export_input::Builder::default()
    }
    /// Creates a new `DeleteExplainabilityExport` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteExplainabilityExport {
    type Output = std::result::Result<
        crate::output::DeleteExplainabilityExportOutput,
        crate::error::DeleteExplainabilityExportError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_explainability_export_error(response)
        } else {
            crate::operation_deser::parse_delete_explainability_export_response(response)
        }
    }
}

/// Operation shape for `DeleteForecast`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_forecast`](crate::client::Client::delete_forecast).
///
/// See [`crate::client::fluent_builders::DeleteForecast`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteForecast {
    _private: (),
}
impl DeleteForecast {
    /// Creates a new builder-style object to manufacture [`DeleteForecastInput`](crate::input::DeleteForecastInput)
    pub fn builder() -> crate::input::delete_forecast_input::Builder {
        crate::input::delete_forecast_input::Builder::default()
    }
    /// Creates a new `DeleteForecast` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteForecast {
    type Output =
        std::result::Result<crate::output::DeleteForecastOutput, crate::error::DeleteForecastError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_forecast_error(response)
        } else {
            crate::operation_deser::parse_delete_forecast_response(response)
        }
    }
}

/// Operation shape for `DeleteForecastExportJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_forecast_export_job`](crate::client::Client::delete_forecast_export_job).
///
/// See [`crate::client::fluent_builders::DeleteForecastExportJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteForecastExportJob {
    _private: (),
}
impl DeleteForecastExportJob {
    /// Creates a new builder-style object to manufacture [`DeleteForecastExportJobInput`](crate::input::DeleteForecastExportJobInput)
    pub fn builder() -> crate::input::delete_forecast_export_job_input::Builder {
        crate::input::delete_forecast_export_job_input::Builder::default()
    }
    /// Creates a new `DeleteForecastExportJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteForecastExportJob {
    type Output = std::result::Result<
        crate::output::DeleteForecastExportJobOutput,
        crate::error::DeleteForecastExportJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_forecast_export_job_error(response)
        } else {
            crate::operation_deser::parse_delete_forecast_export_job_response(response)
        }
    }
}

/// Operation shape for `DeletePredictor`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_predictor`](crate::client::Client::delete_predictor).
///
/// See [`crate::client::fluent_builders::DeletePredictor`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePredictor {
    _private: (),
}
impl DeletePredictor {
    /// Creates a new builder-style object to manufacture [`DeletePredictorInput`](crate::input::DeletePredictorInput)
    pub fn builder() -> crate::input::delete_predictor_input::Builder {
        crate::input::delete_predictor_input::Builder::default()
    }
    /// Creates a new `DeletePredictor` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePredictor {
    type Output = std::result::Result<
        crate::output::DeletePredictorOutput,
        crate::error::DeletePredictorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_predictor_error(response)
        } else {
            crate::operation_deser::parse_delete_predictor_response(response)
        }
    }
}

/// Operation shape for `DeletePredictorBacktestExportJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_predictor_backtest_export_job`](crate::client::Client::delete_predictor_backtest_export_job).
///
/// See [`crate::client::fluent_builders::DeletePredictorBacktestExportJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePredictorBacktestExportJob {
    _private: (),
}
impl DeletePredictorBacktestExportJob {
    /// Creates a new builder-style object to manufacture [`DeletePredictorBacktestExportJobInput`](crate::input::DeletePredictorBacktestExportJobInput)
    pub fn builder() -> crate::input::delete_predictor_backtest_export_job_input::Builder {
        crate::input::delete_predictor_backtest_export_job_input::Builder::default()
    }
    /// Creates a new `DeletePredictorBacktestExportJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePredictorBacktestExportJob {
    type Output = std::result::Result<
        crate::output::DeletePredictorBacktestExportJobOutput,
        crate::error::DeletePredictorBacktestExportJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_predictor_backtest_export_job_error(response)
        } else {
            crate::operation_deser::parse_delete_predictor_backtest_export_job_response(response)
        }
    }
}

/// Operation shape for `DeleteResourceTree`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_resource_tree`](crate::client::Client::delete_resource_tree).
///
/// See [`crate::client::fluent_builders::DeleteResourceTree`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteResourceTree {
    _private: (),
}
impl DeleteResourceTree {
    /// Creates a new builder-style object to manufacture [`DeleteResourceTreeInput`](crate::input::DeleteResourceTreeInput)
    pub fn builder() -> crate::input::delete_resource_tree_input::Builder {
        crate::input::delete_resource_tree_input::Builder::default()
    }
    /// Creates a new `DeleteResourceTree` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteResourceTree {
    type Output = std::result::Result<
        crate::output::DeleteResourceTreeOutput,
        crate::error::DeleteResourceTreeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_resource_tree_error(response)
        } else {
            crate::operation_deser::parse_delete_resource_tree_response(response)
        }
    }
}

/// Operation shape for `DescribeAutoPredictor`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_auto_predictor`](crate::client::Client::describe_auto_predictor).
///
/// See [`crate::client::fluent_builders::DescribeAutoPredictor`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAutoPredictor {
    _private: (),
}
impl DescribeAutoPredictor {
    /// Creates a new builder-style object to manufacture [`DescribeAutoPredictorInput`](crate::input::DescribeAutoPredictorInput)
    pub fn builder() -> crate::input::describe_auto_predictor_input::Builder {
        crate::input::describe_auto_predictor_input::Builder::default()
    }
    /// Creates a new `DescribeAutoPredictor` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAutoPredictor {
    type Output = std::result::Result<
        crate::output::DescribeAutoPredictorOutput,
        crate::error::DescribeAutoPredictorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_auto_predictor_error(response)
        } else {
            crate::operation_deser::parse_describe_auto_predictor_response(response)
        }
    }
}

/// Operation shape for `DescribeDataset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_dataset`](crate::client::Client::describe_dataset).
///
/// See [`crate::client::fluent_builders::DescribeDataset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDataset {
    _private: (),
}
impl DescribeDataset {
    /// Creates a new builder-style object to manufacture [`DescribeDatasetInput`](crate::input::DescribeDatasetInput)
    pub fn builder() -> crate::input::describe_dataset_input::Builder {
        crate::input::describe_dataset_input::Builder::default()
    }
    /// Creates a new `DescribeDataset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDataset {
    type Output = std::result::Result<
        crate::output::DescribeDatasetOutput,
        crate::error::DescribeDatasetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_dataset_error(response)
        } else {
            crate::operation_deser::parse_describe_dataset_response(response)
        }
    }
}

/// Operation shape for `DescribeDatasetGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_dataset_group`](crate::client::Client::describe_dataset_group).
///
/// See [`crate::client::fluent_builders::DescribeDatasetGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDatasetGroup {
    _private: (),
}
impl DescribeDatasetGroup {
    /// Creates a new builder-style object to manufacture [`DescribeDatasetGroupInput`](crate::input::DescribeDatasetGroupInput)
    pub fn builder() -> crate::input::describe_dataset_group_input::Builder {
        crate::input::describe_dataset_group_input::Builder::default()
    }
    /// Creates a new `DescribeDatasetGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDatasetGroup {
    type Output = std::result::Result<
        crate::output::DescribeDatasetGroupOutput,
        crate::error::DescribeDatasetGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_dataset_group_error(response)
        } else {
            crate::operation_deser::parse_describe_dataset_group_response(response)
        }
    }
}

/// Operation shape for `DescribeDatasetImportJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_dataset_import_job`](crate::client::Client::describe_dataset_import_job).
///
/// See [`crate::client::fluent_builders::DescribeDatasetImportJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDatasetImportJob {
    _private: (),
}
impl DescribeDatasetImportJob {
    /// Creates a new builder-style object to manufacture [`DescribeDatasetImportJobInput`](crate::input::DescribeDatasetImportJobInput)
    pub fn builder() -> crate::input::describe_dataset_import_job_input::Builder {
        crate::input::describe_dataset_import_job_input::Builder::default()
    }
    /// Creates a new `DescribeDatasetImportJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDatasetImportJob {
    type Output = std::result::Result<
        crate::output::DescribeDatasetImportJobOutput,
        crate::error::DescribeDatasetImportJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_dataset_import_job_error(response)
        } else {
            crate::operation_deser::parse_describe_dataset_import_job_response(response)
        }
    }
}

/// Operation shape for `DescribeExplainability`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_explainability`](crate::client::Client::describe_explainability).
///
/// See [`crate::client::fluent_builders::DescribeExplainability`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeExplainability {
    _private: (),
}
impl DescribeExplainability {
    /// Creates a new builder-style object to manufacture [`DescribeExplainabilityInput`](crate::input::DescribeExplainabilityInput)
    pub fn builder() -> crate::input::describe_explainability_input::Builder {
        crate::input::describe_explainability_input::Builder::default()
    }
    /// Creates a new `DescribeExplainability` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeExplainability {
    type Output = std::result::Result<
        crate::output::DescribeExplainabilityOutput,
        crate::error::DescribeExplainabilityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_explainability_error(response)
        } else {
            crate::operation_deser::parse_describe_explainability_response(response)
        }
    }
}

/// Operation shape for `DescribeExplainabilityExport`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_explainability_export`](crate::client::Client::describe_explainability_export).
///
/// See [`crate::client::fluent_builders::DescribeExplainabilityExport`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeExplainabilityExport {
    _private: (),
}
impl DescribeExplainabilityExport {
    /// Creates a new builder-style object to manufacture [`DescribeExplainabilityExportInput`](crate::input::DescribeExplainabilityExportInput)
    pub fn builder() -> crate::input::describe_explainability_export_input::Builder {
        crate::input::describe_explainability_export_input::Builder::default()
    }
    /// Creates a new `DescribeExplainabilityExport` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeExplainabilityExport {
    type Output = std::result::Result<
        crate::output::DescribeExplainabilityExportOutput,
        crate::error::DescribeExplainabilityExportError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_explainability_export_error(response)
        } else {
            crate::operation_deser::parse_describe_explainability_export_response(response)
        }
    }
}

/// Operation shape for `DescribeForecast`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_forecast`](crate::client::Client::describe_forecast).
///
/// See [`crate::client::fluent_builders::DescribeForecast`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeForecast {
    _private: (),
}
impl DescribeForecast {
    /// Creates a new builder-style object to manufacture [`DescribeForecastInput`](crate::input::DescribeForecastInput)
    pub fn builder() -> crate::input::describe_forecast_input::Builder {
        crate::input::describe_forecast_input::Builder::default()
    }
    /// Creates a new `DescribeForecast` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeForecast {
    type Output = std::result::Result<
        crate::output::DescribeForecastOutput,
        crate::error::DescribeForecastError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_forecast_error(response)
        } else {
            crate::operation_deser::parse_describe_forecast_response(response)
        }
    }
}

/// Operation shape for `DescribeForecastExportJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_forecast_export_job`](crate::client::Client::describe_forecast_export_job).
///
/// See [`crate::client::fluent_builders::DescribeForecastExportJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeForecastExportJob {
    _private: (),
}
impl DescribeForecastExportJob {
    /// Creates a new builder-style object to manufacture [`DescribeForecastExportJobInput`](crate::input::DescribeForecastExportJobInput)
    pub fn builder() -> crate::input::describe_forecast_export_job_input::Builder {
        crate::input::describe_forecast_export_job_input::Builder::default()
    }
    /// Creates a new `DescribeForecastExportJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeForecastExportJob {
    type Output = std::result::Result<
        crate::output::DescribeForecastExportJobOutput,
        crate::error::DescribeForecastExportJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_forecast_export_job_error(response)
        } else {
            crate::operation_deser::parse_describe_forecast_export_job_response(response)
        }
    }
}

/// Operation shape for `DescribePredictor`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_predictor`](crate::client::Client::describe_predictor).
///
/// See [`crate::client::fluent_builders::DescribePredictor`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePredictor {
    _private: (),
}
impl DescribePredictor {
    /// Creates a new builder-style object to manufacture [`DescribePredictorInput`](crate::input::DescribePredictorInput)
    pub fn builder() -> crate::input::describe_predictor_input::Builder {
        crate::input::describe_predictor_input::Builder::default()
    }
    /// Creates a new `DescribePredictor` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePredictor {
    type Output = std::result::Result<
        crate::output::DescribePredictorOutput,
        crate::error::DescribePredictorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_predictor_error(response)
        } else {
            crate::operation_deser::parse_describe_predictor_response(response)
        }
    }
}

/// Operation shape for `DescribePredictorBacktestExportJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_predictor_backtest_export_job`](crate::client::Client::describe_predictor_backtest_export_job).
///
/// See [`crate::client::fluent_builders::DescribePredictorBacktestExportJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePredictorBacktestExportJob {
    _private: (),
}
impl DescribePredictorBacktestExportJob {
    /// Creates a new builder-style object to manufacture [`DescribePredictorBacktestExportJobInput`](crate::input::DescribePredictorBacktestExportJobInput)
    pub fn builder() -> crate::input::describe_predictor_backtest_export_job_input::Builder {
        crate::input::describe_predictor_backtest_export_job_input::Builder::default()
    }
    /// Creates a new `DescribePredictorBacktestExportJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePredictorBacktestExportJob {
    type Output = std::result::Result<
        crate::output::DescribePredictorBacktestExportJobOutput,
        crate::error::DescribePredictorBacktestExportJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_predictor_backtest_export_job_error(response)
        } else {
            crate::operation_deser::parse_describe_predictor_backtest_export_job_response(response)
        }
    }
}

/// Operation shape for `GetAccuracyMetrics`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_accuracy_metrics`](crate::client::Client::get_accuracy_metrics).
///
/// See [`crate::client::fluent_builders::GetAccuracyMetrics`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAccuracyMetrics {
    _private: (),
}
impl GetAccuracyMetrics {
    /// Creates a new builder-style object to manufacture [`GetAccuracyMetricsInput`](crate::input::GetAccuracyMetricsInput)
    pub fn builder() -> crate::input::get_accuracy_metrics_input::Builder {
        crate::input::get_accuracy_metrics_input::Builder::default()
    }
    /// Creates a new `GetAccuracyMetrics` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAccuracyMetrics {
    type Output = std::result::Result<
        crate::output::GetAccuracyMetricsOutput,
        crate::error::GetAccuracyMetricsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_accuracy_metrics_error(response)
        } else {
            crate::operation_deser::parse_get_accuracy_metrics_response(response)
        }
    }
}

/// Operation shape for `ListDatasetGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_dataset_groups`](crate::client::Client::list_dataset_groups).
///
/// See [`crate::client::fluent_builders::ListDatasetGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDatasetGroups {
    _private: (),
}
impl ListDatasetGroups {
    /// Creates a new builder-style object to manufacture [`ListDatasetGroupsInput`](crate::input::ListDatasetGroupsInput)
    pub fn builder() -> crate::input::list_dataset_groups_input::Builder {
        crate::input::list_dataset_groups_input::Builder::default()
    }
    /// Creates a new `ListDatasetGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDatasetGroups {
    type Output = std::result::Result<
        crate::output::ListDatasetGroupsOutput,
        crate::error::ListDatasetGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_dataset_groups_error(response)
        } else {
            crate::operation_deser::parse_list_dataset_groups_response(response)
        }
    }
}

/// Operation shape for `ListDatasetImportJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_dataset_import_jobs`](crate::client::Client::list_dataset_import_jobs).
///
/// See [`crate::client::fluent_builders::ListDatasetImportJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDatasetImportJobs {
    _private: (),
}
impl ListDatasetImportJobs {
    /// Creates a new builder-style object to manufacture [`ListDatasetImportJobsInput`](crate::input::ListDatasetImportJobsInput)
    pub fn builder() -> crate::input::list_dataset_import_jobs_input::Builder {
        crate::input::list_dataset_import_jobs_input::Builder::default()
    }
    /// Creates a new `ListDatasetImportJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDatasetImportJobs {
    type Output = std::result::Result<
        crate::output::ListDatasetImportJobsOutput,
        crate::error::ListDatasetImportJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_dataset_import_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_dataset_import_jobs_response(response)
        }
    }
}

/// Operation shape for `ListDatasets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_datasets`](crate::client::Client::list_datasets).
///
/// See [`crate::client::fluent_builders::ListDatasets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDatasets {
    _private: (),
}
impl ListDatasets {
    /// Creates a new builder-style object to manufacture [`ListDatasetsInput`](crate::input::ListDatasetsInput)
    pub fn builder() -> crate::input::list_datasets_input::Builder {
        crate::input::list_datasets_input::Builder::default()
    }
    /// Creates a new `ListDatasets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDatasets {
    type Output =
        std::result::Result<crate::output::ListDatasetsOutput, crate::error::ListDatasetsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_datasets_error(response)
        } else {
            crate::operation_deser::parse_list_datasets_response(response)
        }
    }
}

/// Operation shape for `ListExplainabilities`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_explainabilities`](crate::client::Client::list_explainabilities).
///
/// See [`crate::client::fluent_builders::ListExplainabilities`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListExplainabilities {
    _private: (),
}
impl ListExplainabilities {
    /// Creates a new builder-style object to manufacture [`ListExplainabilitiesInput`](crate::input::ListExplainabilitiesInput)
    pub fn builder() -> crate::input::list_explainabilities_input::Builder {
        crate::input::list_explainabilities_input::Builder::default()
    }
    /// Creates a new `ListExplainabilities` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListExplainabilities {
    type Output = std::result::Result<
        crate::output::ListExplainabilitiesOutput,
        crate::error::ListExplainabilitiesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_explainabilities_error(response)
        } else {
            crate::operation_deser::parse_list_explainabilities_response(response)
        }
    }
}

/// Operation shape for `ListExplainabilityExports`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_explainability_exports`](crate::client::Client::list_explainability_exports).
///
/// See [`crate::client::fluent_builders::ListExplainabilityExports`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListExplainabilityExports {
    _private: (),
}
impl ListExplainabilityExports {
    /// Creates a new builder-style object to manufacture [`ListExplainabilityExportsInput`](crate::input::ListExplainabilityExportsInput)
    pub fn builder() -> crate::input::list_explainability_exports_input::Builder {
        crate::input::list_explainability_exports_input::Builder::default()
    }
    /// Creates a new `ListExplainabilityExports` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListExplainabilityExports {
    type Output = std::result::Result<
        crate::output::ListExplainabilityExportsOutput,
        crate::error::ListExplainabilityExportsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_explainability_exports_error(response)
        } else {
            crate::operation_deser::parse_list_explainability_exports_response(response)
        }
    }
}

/// Operation shape for `ListForecastExportJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_forecast_export_jobs`](crate::client::Client::list_forecast_export_jobs).
///
/// See [`crate::client::fluent_builders::ListForecastExportJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListForecastExportJobs {
    _private: (),
}
impl ListForecastExportJobs {
    /// Creates a new builder-style object to manufacture [`ListForecastExportJobsInput`](crate::input::ListForecastExportJobsInput)
    pub fn builder() -> crate::input::list_forecast_export_jobs_input::Builder {
        crate::input::list_forecast_export_jobs_input::Builder::default()
    }
    /// Creates a new `ListForecastExportJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListForecastExportJobs {
    type Output = std::result::Result<
        crate::output::ListForecastExportJobsOutput,
        crate::error::ListForecastExportJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_forecast_export_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_forecast_export_jobs_response(response)
        }
    }
}

/// Operation shape for `ListForecasts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_forecasts`](crate::client::Client::list_forecasts).
///
/// See [`crate::client::fluent_builders::ListForecasts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListForecasts {
    _private: (),
}
impl ListForecasts {
    /// Creates a new builder-style object to manufacture [`ListForecastsInput`](crate::input::ListForecastsInput)
    pub fn builder() -> crate::input::list_forecasts_input::Builder {
        crate::input::list_forecasts_input::Builder::default()
    }
    /// Creates a new `ListForecasts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListForecasts {
    type Output =
        std::result::Result<crate::output::ListForecastsOutput, crate::error::ListForecastsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_forecasts_error(response)
        } else {
            crate::operation_deser::parse_list_forecasts_response(response)
        }
    }
}

/// Operation shape for `ListPredictorBacktestExportJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_predictor_backtest_export_jobs`](crate::client::Client::list_predictor_backtest_export_jobs).
///
/// See [`crate::client::fluent_builders::ListPredictorBacktestExportJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPredictorBacktestExportJobs {
    _private: (),
}
impl ListPredictorBacktestExportJobs {
    /// Creates a new builder-style object to manufacture [`ListPredictorBacktestExportJobsInput`](crate::input::ListPredictorBacktestExportJobsInput)
    pub fn builder() -> crate::input::list_predictor_backtest_export_jobs_input::Builder {
        crate::input::list_predictor_backtest_export_jobs_input::Builder::default()
    }
    /// Creates a new `ListPredictorBacktestExportJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPredictorBacktestExportJobs {
    type Output = std::result::Result<
        crate::output::ListPredictorBacktestExportJobsOutput,
        crate::error::ListPredictorBacktestExportJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_predictor_backtest_export_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_predictor_backtest_export_jobs_response(response)
        }
    }
}

/// Operation shape for `ListPredictors`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_predictors`](crate::client::Client::list_predictors).
///
/// See [`crate::client::fluent_builders::ListPredictors`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPredictors {
    _private: (),
}
impl ListPredictors {
    /// Creates a new builder-style object to manufacture [`ListPredictorsInput`](crate::input::ListPredictorsInput)
    pub fn builder() -> crate::input::list_predictors_input::Builder {
        crate::input::list_predictors_input::Builder::default()
    }
    /// Creates a new `ListPredictors` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPredictors {
    type Output =
        std::result::Result<crate::output::ListPredictorsOutput, crate::error::ListPredictorsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_predictors_error(response)
        } else {
            crate::operation_deser::parse_list_predictors_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `StopResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_resource`](crate::client::Client::stop_resource).
///
/// See [`crate::client::fluent_builders::StopResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopResource {
    _private: (),
}
impl StopResource {
    /// Creates a new builder-style object to manufacture [`StopResourceInput`](crate::input::StopResourceInput)
    pub fn builder() -> crate::input::stop_resource_input::Builder {
        crate::input::stop_resource_input::Builder::default()
    }
    /// Creates a new `StopResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopResource {
    type Output =
        std::result::Result<crate::output::StopResourceOutput, crate::error::StopResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_resource_error(response)
        } else {
            crate::operation_deser::parse_stop_resource_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateDatasetGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_dataset_group`](crate::client::Client::update_dataset_group).
///
/// See [`crate::client::fluent_builders::UpdateDatasetGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDatasetGroup {
    _private: (),
}
impl UpdateDatasetGroup {
    /// Creates a new builder-style object to manufacture [`UpdateDatasetGroupInput`](crate::input::UpdateDatasetGroupInput)
    pub fn builder() -> crate::input::update_dataset_group_input::Builder {
        crate::input::update_dataset_group_input::Builder::default()
    }
    /// Creates a new `UpdateDatasetGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDatasetGroup {
    type Output = std::result::Result<
        crate::output::UpdateDatasetGroupOutput,
        crate::error::UpdateDatasetGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_dataset_group_error(response)
        } else {
            crate::operation_deser::parse_update_dataset_group_response(response)
        }
    }
}
